<?php

namespace App\Events;

use Exception;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class MailQueueFailed
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    private $error;
    /**
     * Create a new event instance.
     */
    public function __construct(Exception $e)
    {
        $this->error = $e;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */

    public function getError(): Exception
    {
        return $this->error;
    }
}
