<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Articles;
use App\Models\Journals;
use App\Models\User;
use Exception;
use PhpParser\Node\Expr\Cast\Object_;
use Illuminate\Support\Facades\Hash;
use Spatie\Backup\Tasks\Backup\BackupJob;
use ZipArchive;
use Illuminate\Support\Facades\Artisan;
use DB;
use Illuminate\Support\Facades\Schema;
class All_Articles_Api extends Controller
{
    public function view_articles(Request $request){
        try{
            $data = $request->all();
            $post_data = $data['filterVal'];
            $sort_field = $data['sort_field'] ?? 'art_id';
            $sort_order = $data['sort_order'] ?? 'desc';
            $limit = $data['per_page'] ?? 10;
            $condition = "(`art`.`art_status` IN('a','r','t','y') OR(
                CASE WHEN art.art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art.art_status = 'n' THEN (jwf_stage_type = 'resubmission' OR jwf_stage_type = 'author_submission') AND aflw_status = 'a'
            END)) ";
            $where = ' AND ';
            if(isset($post_data['article_id']) && $post_data['article_id'] != ""){
				$condition .= $where.' art_code LIKE "%'.$post_data['article_id'].'%"';			
			}
            if(isset($post_data['article_name']) && $post_data['article_name'] != ""){
				$condition .= $where.' art_title LIKE "%'.$post_data['article_name'].'%"';			
			}
            if(isset($post_data['article_type']) && $post_data['article_type'] != ""){
				$condition .= $where.' art_artp_id = '.$post_data['article_type'];
				
			}
			if(isset($post_data['journal']) && $post_data['journal'] != ""){
				$condition .= $where.' jnl_id = '.$post_data['journal'];
				
			}
			if(isset($post_data['article_status']) && $post_data['article_status'] != ""){
				$condition .= $where.' art_delete_status = "'.$post_data['article_status'].'"';
				
			}
			if((isset($post_data['sele_art_submit_date']) && $post_data['sele_art_submit_date'] == "d") && (isset($post_data['article_sub_date']) && $post_data['article_sub_date'] != "" ))            {
               $art_sub_date = date('Y-m-d', strtotime($post_data['article_sub_date']));
               $article_sub_date   =   convert_dmy_to_ymd($art_sub_date, $this->current_client->settings->cs_date_format);
               $condition .=  $where.'Date(art_submission_date) = "'.$article_sub_date.'"';  
			   
            }
            if((isset($post_data['sele_art_submit_date']) && $post_data['sele_art_submit_date'] == "dr" ) && (isset($post_data['article_sub_datestart']) && $post_data['article_sub_datestart'] != "" ) && (isset($post_data['article_sub_dateend']) && $post_data['article_sub_dateend'] != "" ))            {
                $article_sub_datestart   =   $post_data['article_sub_datestart'];
                $submit_start_date = date('Y-m-d', strtotime(trim($article_sub_datestart)));
				$srch_start_date = convert_dmy_to_ymd($submit_start_date, $this->current_client->settings->cs_date_format);
                $article_sub_dateend   =   $post_data['article_sub_dateend'];  
                $submit_end_date = date('Y-m-d', strtotime(trim($article_sub_dateend)));
				$srch_end_date = convert_dmy_to_ymd($submit_end_date , $this->current_client->settings->cs_date_format);
                $condition .=  $where.'DATE(art_submission_date) BETWEEN "'.$srch_start_date.'" AND "'.$srch_end_date .'"';	
            }
		   if((isset($post_data['sele_art_deci_date']) && $post_data['sele_art_deci_date'] == "d") && (isset($post_data['article_deci_date']) && $post_data['article_deci_date'] != ""))   {
               
               $article_deci_date = date('Y-m-d', strtotime($post_data['article_deci_date']));
               $article_deci_date   =   convert_dmy_to_ymd($article_deci_date, $this->current_client->settings->cs_date_format);
               $condition .=  $where.'Date(art_decision_date) = "'.$article_deci_date.'"'; 
            }
			if((isset($post_data['sele_art_deci_date']) && $post_data['sele_art_deci_date'] == "dr") && (isset($post_data['article_deci_datestart']) && $post_data['article_deci_datestart'] != "") && (isset($post_data['article_deci_dateend']) && $post_data['article_deci_dateend'] != ""))            { 
                $article_deci_datestart   =   $post_data['article_deci_datestart']; 
                $deci_start_date = date('Y-m-d', strtotime(trim($article_deci_datestart)));
				$decision_start_date = convert_dmy_to_ymd($deci_start_date , $this->current_client->settings->cs_date_format);
                $article_deci_dateend   =   $post_data['article_deci_dateend']; 
                $deci_end_date = date('Y-m-d', strtotime(trim($article_deci_dateend)));
				$decision_end_date = convert_dmy_to_ymd($deci_end_date , $this->current_client->settings->cs_date_format);
                $condition .=  $where.'DATE(art_decision_date) BETWEEN "'.$decision_start_date.'" AND "'.$decision_end_date .'"';
			  
            }
			if(isset($post_data['article_srch_author']) && $post_data['article_srch_author'] != ""){                  
	            if (preg_match("/^-?[1-9][0-9]*$/D",$post_data['article_srch_author'])) 
				{
					$condition .= $where.' art_submitted_by = '.$post_data['article_srch_author'];
				}
				else
				{				
				    $condition .= $where.'LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' .$post_data['article_srch_author'] . '%")';	 
				}
				
			}
            $date_format = (isset($this->current_client->settings->cs_date_format)?$this->current_client->settings->cs_date_format:'d-m-Y');

            $jwf_workflow_stage = '(SELECT jwf_stage_name  FROM rvw_journal_workflows JOIN rvw_article_flow ON jwf_id = aflw_jwf_id WHERE aflw_art_id = art_id AND jwf_stage_type != "transit" ORDER BY aflw_level desc limit 1 ) as stage_name';
            
            $select = 'art_id,art_code,REPLACE(strip_tags(art_title),\'&nbsp;\',\' \') as art_title,art_submission_date,art_decision_date,jnl_journal_name,artp_article_type,artp_abbr_article_type,
                        art_delete_status,art_pre_all_ids,art_transfer_article,
                        CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as name,'
                        . $jwf_workflow_stage;

            $all_records = Articles::get_all_articles($select,$condition,$sort_field,$sort_order,$limit,TRUE,TRUE,TRUE);           
            $data = array();
            $flag_icon_selector = $this->current_client->functionality->cfty_flag_icon_selector; 
            foreach ($all_records['article_result'] as $key=>$art)
			{
				$flagVal = [];
                if(!empty($art->flagicon))
                  {
                      $ar_flagname = explode(',',$art->flagname); 
                      $ar_icon = explode(',',$art->flagicon);
                      $ar_color = explode(',',$art->flagcolor);
                      $art_flag_count = count($ar_flagname);
                      
                      if($art_flag_count > 0)
                      {
                           
                      for($i = 0; $i < $art_flag_count; $i++ )
                      {
                      if(isset($ar_icon[$i]) && $ar_icon[$i] != null && $flag_icon_selector == 'y')
                      $flagVal[$i]['icon'] = $ar_icon[$i];
                      else
                      $flagVal[$i]['icon'] = 'tag';
                      $flagVal[$i]['color'] = isset($ar_color[$i])?$ar_color[$i]:"";  
                      $flagVal[$i]['title'] = isset($ar_flagname[$i])?$ar_flagname[$i]:"";      
                      }
                      }
                  }
                          $all_records['article_result'][$key]->art_submission_date = date($date_format, strtotime($art->art_submission_date));
                          $all_records['article_result'][$key]->art_decision_date = date($date_format, strtotime($art->art_decision_date));
                          $all_records['article_result'][$key]->stage_name = $art->stage_name; 
                          $all_records['article_result'][$key]->flag = $flagVal ;      
            }
            return $this->success('Success',200,$all_records); 
        }catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }     
    }

    public function view_article_config(Request $request){
        try{
            $all_records = array();
            $criteria = array(
                'jnl_journal_status' => 'y',
                'jnl_standalone' => 'n'
            );
            $all_records['journal'] = Journals::get_all_records_with_bind_cond('jnl_id AS value,jnl_journal_name AS label', $criteria);
            $data = collect([
                'value' => '',
                'label' => customTrans('Select :Journal'),
            ]);
            $all_records['journal'] = $all_records['journal']->prepend($data);
            return $this->success('Success',200,$all_records); 
        }catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }   
    }

    public function remove_article(Request $request){
        try{
            DB::beginTransaction();
            if($request->disableSend == true){
                return $this->failure('Failed',200,customTrans('Cannot delete without backup :article'));
            }
            $articleId = array('input'=>$request->id,'type'=>'string','enc_data'=>TRUE);
            $articleValidation = $this->Rv_validator($articleId);
            if($articleValidation != true){
                DB::rollback();
                return $this->warning('Warning',200,'Invalid data','Warning');
            }
            $this->current_user = $this->get_current_user_details();
            //$articleId=Rv_decrypt($request->id);
            $articleIds = $request->id;
		    $article_ids = explode(",", $articleIds);
            if(empty($article_ids)){
                DB::rollback();
                return $this->warning('Warning',200,customTrans(':Article not exist'),'Warning');
            }

            foreach($article_ids AS $articleId){
                $articleId = Rv_decrypt($articleId);
                $condition = ['art_id'=>$articleId];
                $articlesTable = (new \App\Models\Articles())->getTable();
                $articlesTypeTable = (new \App\Models\Article_types())->getTable();
                $journal_table = (new \App\Models\Journals())->getTable();
                $tables = array(
                    'main_table' => $articlesTable,
                    'join_table' => array( $articlesTypeTable => array($articlesTable . '.art_artp_id', $articlesTypeTable . '.artp_id'), $journal_table => array($articlesTypeTable . '.artp_jnl_id',$journal_table . '.jnl_id'))
                );
                $del_articles = Articles::get_results_using_joins($tables, '*', $condition, 'all');

                if(isset($del_articles[0])){
                    $article = $del_articles[0];
                    $delete = Articles::delete_records(array('art_id'=> $article->art_id), '', $this->current_user);
                    if($delete){
                        $folder = 'uploads/'.$article->jnl_journal_code.'/'.$article->artp_abbr_article_type.'/'.$article->art_id;
                        if (file_exists($folder))
                        {
                            delfolder($folder);
                        }
                    }
                }
            }
            DB::commit();
            return $this->success('Success',200,customTrans(':Article removed successfully'));
        }catch(Exception $e){
            DB::rollback();
            return $this->failure('Failed',500,$e->getMessage());
        }   
    }

    public function validate_password_and_backup(Request $request){
        $act = $request->act;
        $this->current_user = $this->get_current_user_details();
		if(!isset($act)){
            return $this->warning('Warning',200,'Invalid request','Warning');
		}
		if(!in_array('sudo', $this->current_user['roles'])){
            return $this->warning('Warning',200,'Sudo permission error','Warning');
		}
		if($act != 'password' && $act != 'application'){
            return $this->warning('Warning',200,'Invalid request','Warning');
		}
        try{
            DB::beginTransaction();
            $article = $request->artIdVal;
            $article_ids = explode(",", $article);
            if(empty($article)){
                DB::rollback();
                return $this->warning('Warning',200,customTrans(':Article ID invalid'),'Warning');
            }
            $art_array = array();
            foreach($article_ids as $art){
                $art_array[] = Rv_decrypt($art);
            }
            if($act == 'password'){
                $password = Rv_decrypt($request->password);
                $get_usr_pwd = User::get_single_record_with_bind_cond('usr_pwd',array('usr_id'=>$this->current_user));
                if(empty($get_usr_pwd)){
                    return $this->warning('Warning',200,'Invalid request','Warning');
                }

                if (!Hash::check($password, $get_usr_pwd->usr_pwd)) {
                    return $this->warning('Warning',200,'Invalid password','Warning');
                }
                
                $condition = ' art_id in ('.join(',',$art_array).')';
                //$bind_data = $art_array;
                $articles_table = (new \App\Models\Articles())->getTable();
                $article_type_table = (new \App\Models\Article_types())->getTable();
                $journal_table = (new \App\Models\Journals())->getTable();
                $tables = array(
                    'main_table' => $articles_table,
                    'join_table' => array( $article_type_table => array($articles_table . '.art_artp_id', $article_type_table . '.artp_id'),
                                        $journal_table => array($article_type_table . '.artp_jnl_id',$journal_table . '.jnl_id') )
                );
                $select = $articles_table . '.*,' . $journal_table . '.jnl_journal_code';
                $del_articles = Articles::get_results_using_joins($tables,$select,$condition);
                $jnl_tables = array();
                if(!empty($del_articles)){
                    $backup = false;
                    foreach($del_articles as $del_article){
                        $jnl_tables['gdata_id'] = 'rvw_article_gnf_form_data_'.$del_article->jnl_journal_code;
                        $backup = $this->take_db_backup($jnl_tables,$del_article);
                    }
                    if($backup == true){
                        DB::commit();
                        return $this->success('Success',200,'DB backup successfully'); 
                    }else{
                        DB::rollback();
                        return  $this->failure('Failed', 500, 'DB backup failed');
                    }
                }
            }
            else{
                $condition = ' art_id in ('.join(',',$art_array).')';
                $del_articles = Articles::get_all_records_with_bind_cond('*',$condition);
                if($this->take_folder_backup($del_articles) == true){
                    DB::commit();
                    return $this->success('Success',200,'Application backup success'); 
                }else{
                    DB::rollback();
                    return $this->failure('Failed', 500, 'Application backup fail');
                }
            }
        }catch(Exception $e){
            DB::rollback();
            return $this->failure('Failed',500,$e->getMessage());
        }
    }
    
    private function take_db_backup($jnl_tables=array(),$article){
		$tables = array(
            "art_id" => "rvw_articles",
            "atmnt_art_id" => "rvw_article_attachment_files",
			"auth_art_id" => "rvw_article_authors",
			"exp_art_id" => "rvw_article_export_data",
			"aflg_art_id" => "rvw_article_flag",
			"aflw_art_id" => "rvw_article_flow",
			"afd_art_id" => "rvw_article_funder_details",
			"ak_art_id" => "rvw_article_keywords",
			"an_art_id" => "rvw_article_notes",
			"ane_art_id" => "rvw_article_notification_emails",
			"pdf_art_id" => "rvw_article_pdf",
			"atp_art_id" => "rvw_article_primary_classification",
			"sorw_art_id" => "rvw_article_reviewers",
			"ars_sorw_id" => "rvw_article_reviewers_suggest",
			"ats_art_id" => "rvw_article_secondary_classification",
			"asup_art_id" => "rvw_article_supplementary_files",
			"ats_art_id" => "rvw_article_transfer_suggestion",
			"auaff_auth_id" => "rvw_author_affiliation",
			"acr_auth_id" => "rvw_author_credits",
			"con_auth_id" => "rvw_casrai_conflicts",
			"cd_aflw_id" => "rvw_change_due_date",
			"crt_art_id" => "rvw_copyright",
			"esl_article_id" => "rvw_email_send_log",
            "pmt_ord_art_id" => "rvw_payment_order",
			// 'rvw_payment_discounts',
			"rsc_current_flow_id" => "rvw_rescind_reset_record",
			"rvd_aflw_id" => "rvw_review_discussions",
			"rvr_aflw_id" => "rvw_review_rating",
			"unsn_aflw_id" => "rvw_unassign_users",
			"usra_art_id" => "rvw_user_articles"
		);

		$tables = array_merge($tables,$jnl_tables);

         // Create a temporary directory for storing backup files
        $tempDir = public_path('storage/uploads/backups/db_backup/temp');
        if (!file_exists($tempDir)) {
            mkdir($tempDir, 0777, true); // Recursive directory creation
        }

        // Create a zip archive
        $zipFileName = 'backup_' . $article->art_id . '.zip';
        $zipFilePath = public_path('storage/uploads/backups/db_backup/' . $zipFileName);
        $zip = new ZipArchive();

        if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
            // Backup data for each table
            foreach ($tables as $key => $table) {             
                $backupData = $this->backupTableData($article,$key,$table,$tempDir);
                if ($backupData) {
                    $zip->addFile($backupData, $table . '_backup.csv');
                }
            }
            $zip->close();
        } else {
            return false;
        }

        $this->cleanUpTempDir($tempDir);
        
    return true;
    }

    // private function backupTableData($key, $table, $article, $tempDir)
    private function backupTableData($article,$key,$table,$tempDir)
    {
        //  // Backup data related to the given table and article
        $backupFileName = $table . '_backup.csv';
        $backupFilePath = $tempDir . '/' . $backupFileName;
        $columns = Schema::getColumnListing($table);

        try {
            $file = fopen($backupFilePath, 'w');
            fputcsv($file, $columns);
            $article_model = new Articles;
            $articles_table = $article_model->getTable();
            if($table == 'rvw_articles'){
                $data = json_decode(json_encode($article), true);
                fputcsv($file, $data);
            }else{
                if($table == 'rvw_article_reviewers_suggest'){
                    $tables = array(
                        'main_table' => $articles_table,
                        'join_table' => array( 'rvw_article_reviewers' => array('rvw_article_reviewers.sorw_art_id', $articles_table . '.art_id'),
                                                $table => array($table . '.' . $key,'rvw_article_reviewers.sorw_id'),
                                           ),
                    );
                }else if(in_array($table,['rvw_author_affiliation','rvw_author_credits','rvw_casrai_conflicts'])){
                    $tables = array(
                        'main_table' => $articles_table,
                        'join_table' => array( 'rvw_article_authors' => array('rvw_article_authors.auth_art_id', $articles_table . '.art_id'),
                                                $table => array($table . '.' . $key,'rvw_article_authors.auth_id'),
                                           ),
                    );
                }else if(in_array($table,['rvw_change_due_date','rvw_rescind_reset_record','rvw_review_discussions','rvw_review_rating','rvw_unassign_users'])){
                    $tables = array(
                        'main_table' => $articles_table,
                        'join_table' => array( 'rvw_article_flow' => array('rvw_article_flow.aflw_art_id', $articles_table . '.art_id'),
                                                $table => array($table . '.' . $key,'rvw_article_flow.aflw_id'),
                                           ),
                    );
                }else{
                    $tables = array(
                        'main_table' => $articles_table,
                        'join_table' => array( $table => array($table . '.' . $key, $articles_table . '.art_id'))
                    );
                }
                $condition = ['art_id' => $article->art_id];
                $select = $table . '.*';
                $datas = Articles::get_results_using_joins($tables,$select,$condition);
                $datas->map(function($item) use($file){
                    $data = json_decode(json_encode($item), true);
                    fputcsv($file, $data);
                });
            }
            fclose($file);
        } catch (\Exception $e) {
            throw $e;
        }

        return $backupFilePath;
    }

    private function cleanUpTempDir($tempDir)
    {
        $files = glob($tempDir . '/*');
        foreach ($files as $file) {
            unlink($file);
        }
        rmdir($tempDir);
    }

    public function get_revise_articles(Request $request){
        $post_data = $request->all();
        $articles = $post_data['articles'];
        $return_array = [];
        try {
            if(count($articles)>0){              
                $all_ids = [];
                foreach($articles AS $article){   
                    $return_array['status'] = false; 
                    array_push($all_ids,strval($article['art_id']));
                    if($article['art_pre_all_ids']!="" && $article['art_transfer_article']!='y'){
                        $return_array['status'] = true; 
                        $artIds = explode(',',$article['art_pre_all_ids']);                      
                        $all_ids = array_merge($all_ids,$artIds);
                        $revisions = Articles::whereIn('art_id',$artIds)
                                             ->pluck('art_code')
                                             ->toArray();
                        if(count($revisions)){
                            $return_array['art'][$article['art_id']] = [
                                'art_ids' => $article['art_pre_all_ids'],
                                'art_codes' => implode(',',$revisions),
                                'art_codeArr' => $revisions,
                            ];
                        }
                    }
                }
                $return_array['all_ids'] = $all_ids;
            }
            return $this->success('Success',200,$return_array); 
        }catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }
    }
}
