<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use App\Models\Roles;
use App\Models\Journals;
use  App\Http\Traits\RolesConfigTrait;
use Illuminate\Support\Facades\Validator;
use App\Models\Email_templates;
use App\Models\Stage_email_templates;
use App\Http\Traits\General_ConfigTraits;
use App\Models\Generic_flows;
use App\Models\User_to_journals;

class All_Generic_Api extends Controller
{
    use RolesConfigTrait;
    use General_ConfigTraits;
    /*
     Get all Roles
     Date:10-05-2022
    */
    public function all_roles(Request $request)
    {
        try {
            $allroles = Roles::get_all_records();
            $role_used = $this->RolesConfigdata('privileged_user_roles');
            $privillged_user = $role_used['privileged_user_roles'];
            foreach($allroles as $single_all_roles)
			{
                
				if(in_array($single_all_roles->role_assigned_role,$privillged_user))
				{
					$single_all_roles->privillaged = "y";
				}
				else
				{
					$single_all_roles->privillaged = "n";
				}
			}
            return $this->success('success', 200, $allroles);
        }         catch (Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function client_functionalities(Request $request)
    {
       
        try {
            $return_array=array();
            $client_functionality = $this->get_client_functionalities($this->current_client->clnt_id, $this->current_client->clnt_client_code);
            $return_array['client_functionality']=$client_functionality;
            $return_array['module_status']=$this->current_client->modules;
            return $this->success('success', 200, $return_array);
        }         catch (Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    } 

}
