<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
//use App\Models\User;
use App\Models\Authorize;
use App\Models\Clients;
use App\Models\Journals;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\ConnectException;
use App\Models\User_password_history;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use App\Models\User;
use App\Models\User_emails;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Config;
use DB;
use Auth;
use Illuminate\Support\Facades\Log;
use App\Http\Traits\ModalDataTrait;
use App\Http\Traits\OrcidlibTraits;
use App\Models\User_to_journals;
use Nette\Utils\Random;
use PhpParser\Node\Expr\Cast\Object_;
use App\Http\Traits\StandaloneDataTrait;
use Illuminate\Support\Facades\Cookie;

class Authentication extends Controller
{
    use ModalDataTrait;
    use OrcidlibTraits;
    use StandaloneDataTrait;
    use AuthenticatesUsers;

    protected $maxAttempts = 5;
    protected $decayMinutes = 30;
    /*
   login  form setting
   commited date :- 17-01-2022
   Requested type :- POST
    */

    public function username()
    {
        return 'username';
    }

    public function login(Request $request)
    {

        try {
            $Users = new \App\Models\User();
            $response   =   array();
            $credentials = $request->only('username', 'password');

            $validator = Validator::make($request->all(), [
                'username'      => 'required',
                'password'    => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $start = microtime(true);
            $login_count = 0;
            $relogin_after = 0;
            $attemptscheck=0;
            $logcookies=false;
            $fail_login = false;
            $fail_limit = $this->maxAttempts();
            $standalone_journal_group = session('group')??null;
            $standalone_journal_id  = Journals::get_single_record_with_bind_cond('jnl_id', null, "jnl_journal_status = ?  AND jnl_standalone_group = ? ", ['y', $standalone_journal_group])?->jnl_id;

            $criteria = array(
                'jnl_journal_status' => 'y',
                'jnl_standalone' => 'n'
            );
            if ($standalone_journal_id != null) {
                unset($criteria['jnl_standalone']);
                $criteria['jnl_id'] = $standalone_journal_id;
            }

            $data['all_active_journals'] = Journals::get_all_records_with_bind_cond('jnl_id,jnl_journal_code,jnl_journal_name', $criteria);
            // $where = "(usr_username = '$request->username' OR usr_email = '$request->username') ";
            $where  =   "(usr_username = ? OR usr_email = ?) ";
            $user_dets = $Users::get_user_by_email_journal($where, $standalone_journal_id,binding_arr:[$request->username,$request->username]);
            $cond = " (usr_username = ? or usr_email = ? )";
            $bind = [$request->username, $request->username];
            if($standalone_journal_id){
                $cond.= " and usr_jnl_standalone = ? ";
                $bind[] = $standalone_journal_id;
            }
            $user = Authorize::whereRaw($cond)->setBindings($bind)->first();
            if ($user && isset($user->usr_id)){
                $get_journal_details = Rv_encrypt($this->user_journal_details($user->usr_id, $standalone_journal_id));
            }
            //   $relogin_after =$review_flow_login['relogin_after'];
              if (!isset($_COOKIE['failedlogincount']) || (isset($_COOKIE['failedlogincount']))) {
                if ($user && \Hash::check($request->password, $user->usr_pwd)) {
                    if ($user && isset($user->usr_status) && $user->usr_status != 'a') {
                        if($user->usr_status == 'n' || $user->usr_status == 's'){
                            $response = ['success' => false, 'status' => 'inactive', 'message' => 'Suspended !!'];
                        }
                        elseif($user->usr_status == 'w'){
                            $response = ['success' => false, 'status' => 'waiting', 'message' => 'Waiting !!'];
                        }
                        elseif($user->usr_status == 'u'){
                            $response = ['success' => false, 'status' => 'noaccess', 'message' => 'No access !!'];
                        }
                        return response()->json($response, 200);
                    }
                    setcookie('failedlogincount', 0, time() + $relogin_after); //unset cookie after successful login
                    $logcookies=true;
                }else{
                    $this->incrementLoginAttempts($request);
                }
              }else{
                $fail_login = true;
              } 
            $resp = $this->checkForLoginAttempt($request, $attemptscheck, $relogin_after);
              if($resp){
                return $resp;
              }
              if((isset($_COOKIE['failedlogincount'])) && $_COOKIE['failedlogincount']==$fail_limit-1 && $logcookies==false)
              {
                $fail_login = true;
              }
                if ($user && \Hash::check($request->password, $user->usr_pwd) && $fail_login == false) {
                    $result_data['first_loging_stautus'] = false;
                    $this->clearLoginAttempts($request);
                    if (isset($user->usr_status) && $user->usr_f_status == 'y' &&  $user->usr_status == 'a') {
                        $result_data['usr_status']=Rv_encrypt($user->usr_id);
                        $result_data['usr_name']=Rv_encrypt($user->usr_username);
                        return response()->json([
                            'success' => true,
                            'first_loging_stautus'=>true,
                            'google_2fa' => false,
                            'data' => $result_data
                        ]);
                    }
                    //force users to change their password after a specific time period of the last password change
                    if (isset($this->current_client->functionality->cfty_force_change_password) && $this->current_client->functionality->cfty_force_change_password == 'y') {
                        $review_config = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                        $review_flow_login  = Config::get($review_config);
                       $change_password_interval =$review_flow_login['change_password_interval'];
                        // $criteria = "pash_usr_id={$user->usr_id}";
                        $criteria = array("pash_usr_id"=>$user->usr_id);
                        $last_password_change_date  = User_password_history::get_single_record_with_bind_cond('pash_posted_date', $criteria, NULL, NULL,NULL,NUll, 'pash_id DESC');
                        if (!empty($last_password_change_date)) {
                            $last_password_change_date = $last_password_change_date->pash_posted_date;
                        }else {
                          //$sql_raw_query  = 'SELECT usr_posted_date from tbk_users where usr_id=' . $user->usr_id . ' ORDER BY tbk_id ASC LIMIT 1';
                          //$users      =   User::get_records_by_raw_query($sql_raw_query);
                          $users = DB::select('SELECT usr_posted_date from tbk_users where usr_id=' . $user->usr_id . ' ORDER BY tbk_id ASC LIMIT 1' );
                          $last_password_change_date = $users[0]->usr_posted_date;
                        }
                        $date_diff = time() - strtotime($last_password_change_date);
                        $days = round($date_diff / (60 * 60 * 24));
                        if ($days > $change_password_interval) {
                            $change_password = true;
                        }
                    }
                     //Reauthorise the user account after a specific interval
                     if (isset($this->current_client->functionality->cfty_reauthorise_user_account) && $this->current_client->functionality->cfty_reauthorise_user_account == 'y') {
                        $review_config = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                        $review_flow_login  = Config::get($review_config);
                        $reauthorise_interval =$review_flow_login['reauthorise_interval'];
                        $criteria2 = array("usr_id"=>$user->usr_id);
                        $last_reauthorised_date = User::get_single_record_with_bind_cond('usr_reauthorised_date',$criteria2);
                        if (empty($last_reauthorised_date->usr_reauthorised_date)) {
                            $criteria3 = array("usr_id"=>$user->usr_id);
                            $registration_date = User::get_single_record_with_bind_cond('usr_reg_date', $criteria3);
                            if (empty($registration_date->usr_reg_date)) {
                                //$sql_query  = 'SELECT usr_posted_date from tbk_users where usr_id=' . $user->usr_id . ' ORDER BY tbk_id ASC LIMIT 1';
                               // $users      =   User::get_records_by_raw_query($sql_query);
                                $users = DB::select('SELECT usr_posted_date from tbk_users where usr_id=' . $user->usr_id . ' ORDER BY tbk_id ASC LIMIT 1' );
                                $last_reauthorised_date = $users[0]->usr_posted_date;
                            } else {
                                $last_reauthorised_date = $registration_date->usr_reg_date;
                            }


                        }else {
                            $last_reauthorised_date = $last_reauthorised_date->usr_reauthorised_date;
                        }
                        $date_diff = time() - strtotime($last_reauthorised_date);
                        $days = round($date_diff / (60 * 60 * 24));
                        if ($days >  $reauthorise_interval) {
                            $user_admin_roles = $this->UserConfigdata('managing_roles');
                            $admin_user_found_re = array();
                            if ($user->usr_roles !== NULL) {
                                $admin_user_found_re = array_intersect(array_keys($user_admin_roles['managing_roles']), json_decode($user->usr_roles));
                            }
                            if (!empty($admin_user_found_re)) {
                                $reauthorise_account = true;
                            }else {
                                $UserToJournal = new \App\Models\User_to_journals();
                                $journal_where_authorize = 'usrj_usr_id =' . $user->usr_id . ' AND usrj_role_id IN(SELECT role_id from rvw_roles WHERE role_reauthorize_accont_enable = \'y\')';
                                $authorize_required = $UserToJournal->get_single_record('count(usrj_id) as cnt', $journal_where_authorize);
                                if ($authorize_required->cnt > 0) {
                                    $reauthorise_account = true;
                                }
                            }

                        }
                     }
                     if((isset($change_password) && $change_password == true))
                     {
                        if((isset($reauthorise_account) && $reauthorise_account == true))
                        {
                            $result_data['reauthorosation'] = true;
                            $criteriaemail = array("uml_user_id"=>$user->usr_id);
                            $cc_mail_data = User_emails::get_all_records_with_bind_cond('uml_email,uml_cc_email,uml_status',$criteriaemail);
                            if( $user->usr_url==NULL)
                            {
                                $user->usr_url='';
                            }
                            if($user->usr_url!='')
                            {
                                $user->usr_url='url';
                            }
                            $result_data['cc_email'] = $cc_mail_data;
                            $result_data['user_email'] = $user->usr_email;
                            $result_data['usr_url'] = $user->usr_url;
                            $result_data['usr_status'] = $user->usr_status;
                        }
                        $result_data['user_name'] = $user->usr_username;
                        $result_data['user_id'] = $user->usr_id;
                        $result_data['change_password_msg'] = 'Please update your password as it has been more than '.$change_password_interval.' days since you last did so.';
                        $result_data['change_password'] = true;
                        return response()->json([
                            'success' => true,
                            'change_password'=>true,
                            'data' => $result_data
                        ]);
                     }
                     elseif((isset($reauthorise_account) && $reauthorise_account == true))
                     {
                        $criteriaemail = array("uml_user_id"=>$user->usr_id);
                        $cc_mail_data = User_emails::get_all_records_with_bind_cond('uml_email,uml_cc_email,uml_status',$criteriaemail);
                        if( $user->usr_url==NULL)
                        {
                            $user->usr_url='';
                        }
                        if($user->usr_url!='')
                            {
                                $user->usr_url='url';
                            }
                                $result_data['cc_email'] = $cc_mail_data;
                                $result_data['user_name'] = $user->usr_username;
                                $result_data['user_id'] = $user->usr_id;
                                $result_data['user_email'] = $user->usr_email;
                                $result_data['usr_url'] = $user->usr_url;
                                $result_data['usr_status'] = $user->usr_status;
                                $result_data['reauthorise_user_account'] = true;
                        return response()->json([
                            'success' => true,
                            'reauthorise_user_account'=>true,
                            'data' => $result_data
                        ]);

                     }
                    // $this->login_tracker_entry('in',$user->usr_id);
                    //$token = JWTAuth::fromUser($user);
                    //$token = JWTAuth::customClaims(['user_id' => $user->usr_id,'proxy_user_id'=>$user->usr_id])->fromUser($user);
                    $check_user_mfa = false;
                    if (isset($this->current_client->functionality->cfty_enable_google_mfa) && $this->current_client->functionality->cfty_enable_google_mfa == 'y') {
                        $user_admin_roles = $this->UserConfigdata('managing_roles');
                        $admin_user_found = array();
                        if ($user->usr_roles !== NULL) {
                            $admin_user_found = array_intersect(array_keys($user_admin_roles['managing_roles']), json_decode($user->usr_roles));
                        }
                        if (!empty($admin_user_found)) {
                            $check_user_mfa = true;
                        } else {
                            $UserToJournal = new \App\Models\User_to_journals();
                            $journal_where = 'usrj_usr_id =' . $user->usr_id . ' AND usrj_role_id IN(SELECT role_id from rvw_roles WHERE role_mfa_enabled = \'y\')';
                            $mfa_required = $UserToJournal->get_single_record('count(usrj_id) as cnt', $journal_where);
                            if ($mfa_required->cnt > 0) {
                                $check_user_mfa = true;
                            }
                        }
                    }

                    if ($check_user_mfa == true) {
                        $qr_image = NULL;
                        $google2fa_secret = '';
                        if ($user->usr_mfa_token !== NULL) {
                            $google2fa_secret = $user->usr_mfa_token;
                        } else {
                            $google2fa = app('pragmarx.google2fa');
                            $google2fa_secret = $google2fa->generateSecretKey();
                            $qr_image = $google2fa->getQRCodeInline(
                                config('app.name'),
                                $user->usr_email,
                                $google2fa_secret
                            );
                        }
                        $encrypt_params = encrypt_link('token_id=' . $user->usr_id . '&secret_code=' . $google2fa_secret);
                        setcookie('token_params', $encrypt_params, time()+300);
                        return response()->json([
                            'success' => true,
                            'google_2fa' => true,
                            'type_status' => false, // if true with proxy password else normal user
                            'params' => $encrypt_params,
                            'qr_image' => $qr_image
                        ]);

                    } else {
                        $loggeddata = $this->set_user_loggin($user->usr_id);
                        $forcepassword = $this->force_password_check($user);
                        if (!empty($loggeddata)) {
                            $this->set_login_tracker('in', $user->usr_id, $request->ip());
                            $token = $loggeddata['token'];
                            $result_data['client_functionality'] = $loggeddata['client_functionality'];
                            $result_data['module_status'] = $loggeddata['module_status'];
                            $result_data['profiledetails'] = $loggeddata['profile_data'];
                            $result_data['redirect_to'] = $get_journal_details;
                            $this->clearLoginAttempts($request);
                            setcookie('failedlogincount', 0, time() + $relogin_after); //unset cookie after successful login
                            return response()->json([
                                'success' => true,
                                'google_2fa' => false,
                                'type_status' => false, // if true with proxy password else normal user
                                'token' => $token,
                                'token_type' => 'bearer',
                                'redirect_url' => $forcepassword,
                                'log_data' => $result_data,
                                'expires_in' =>  auth('api')->factory()->getTTL() * 60
                            ]);
                        } else
                            $response = ['success' => false, 'message' => 'User not found !!'];
                    }
                } else if ($user && $fail_login == false) {
                    $debug_data = $this->get_debug_status();
                    if ($debug_data->gnl_debug_mode == 'y') {
                        $Sudo_proxy = new \App\Models\Sudo_proxy_password();
                        $sudo_table = (new \App\Models\Sudo_proxy_password())->getTable();
                        $condition ='select sp_id from `' . $sudo_table . '` where sp_password = ?   AND DATE_FORMAT(sp_posted_date,"%Y-%m-%d") = "' . date('Y-m-d') . '" limit 1';
                        $bindarray = array(
                            "$request->password "
                        );
                        $check_proxy = $Sudo_proxy::execute_query($condition,false,$bindarray);
                        if (!empty($check_proxy)) {
                            $loggeddata = $this->set_user_loggin($user->usr_id);
                            $forcepassword = $this->force_password_check($user);
                            if (!empty($loggeddata)) {
                                $this->set_login_tracker('in', $user->usr_id, $request->ip(),'sudo');
                                $token = $loggeddata['token'];
                                $result_data['client_functionality'] = $loggeddata['client_functionality'];
                                $result_data['module_status'] = $loggeddata['module_status'];
                                $result_data['profiledetails'] = $loggeddata['profile_data'];
                                $result_data['redirect_to'] = $get_journal_details;
                                $this->clearLoginAttempts($request);
                                setcookie('failedlogincount', 0, time() + $relogin_after); //unset cookie after successful login
                                return response()->json([
                                    'success' => true,
                                    'google_2fa' => false,
                                    'type_status' => true, // if true with proxy password else normal user
                                    'token' => $token,
                                    'token_type' => 'bearer',
                                    'redirect_url' => $forcepassword,
                                    'log_data' => $result_data,
                                    'expires_in' =>  auth('api')->factory()->getTTL() * 60
                                ]);
                            }
                        } else {
                            $response = ['success' => false,'failed_loginattempt'=> $attemptscheck, 'message' => 'User not found !!'];
                        }
                    }
                    else {
                        $response = ['success' => false, 'status' => 'noaccess', 'message' => 'No access !!'];
                    }
                } else{
                    if($fail_login == true)
                    {
                        $response = ['success' => false,'status' => 'failed_login','failed_loginattempt'=> $attemptscheck, 'relogin'=> $relogin_after,'message' => 'User not found !!'];
                    }else{
                        $response = ['success' => false, 'failed_loginattempt'=> $attemptscheck,'message' => 'User not found !!'];
                    }
                }
                $minResponseTime = 500000; // 500ms
                $elapsed = microtime(true) - $start;
                $remaining = $minResponseTime - ($elapsed * 1_000_000);
                if ($remaining > 0) {
                    usleep((int) $remaining);
                }
            
            return response()->json($response, 200);
        } catch (Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    private function checkForLoginAttempt(Request $request, &$attemptscheck, &$relogin_after){
        $key = $this->throttleKey($request);
        $attemptscheck = $this->limiter()->attempts($key);
        if ($this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);
            $relogin_after = $this->limiter()->availableIn($key);
            $response = ['success' => false,'status' => 'failed_login','failed_loginattempt'=> $attemptscheck, 'relogin'=> $relogin_after,'message' => 'User not found !!'];
            setcookie('failedlogincount', $attemptscheck, time() + $relogin_after);
            return response()->json($response, 200);
        }
        return false;
    }
    public function verifyGoogleOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'verify_token'      => 'required',
            'token_params'    => 'required',
            'verified_user' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $validator = Validator::make(['token_params' => cookie::get('token_params')], [
            'token_params'    => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $atmpt = cookie::get('attempt_c', 1 )+ 1;
        $return_array['invalid'] = false;
        $data = $request->only('verify_token', 'token_params', 'verified_user');
        parse_str(decrypt_link($data['token_params']), $decrypt_data);
        $google2fa = app('pragmarx.google2fa');
        $otp_success = FALSE;
        $check_mfa = $google2fa->verifyKey($decrypt_data['secret_code'], $data['verify_token']);
        if ($check_mfa == true) {
            $otp_success = TRUE;
        } else {
            $user_data = Authorize::where('usr_id', $decrypt_data['token_id'])->get('usr_alt_totps')->first();
            $alt_tokens = json_decode($user_data->usr_alt_totps);
            if ($alt_tokens !== null && in_array(md5($data['verify_token']), $alt_tokens)) {
                $otp_success = TRUE;
            }
        }
        if ($otp_success == TRUE) {
            $current_user = array();
            $return_array['invalid'] = false;
            if ($data['verified_user'] == FALSE) {
                $random_tokens = $this->generateRandomOTP(6);
                $update_arr = array('usr_mfa_token' => $decrypt_data['secret_code'], 'usr_alt_totps' => json_encode($random_tokens['hashed']));
                $condition = 'usr_id = ' . $decrypt_data['token_id'];
                $current_user['user_id'] =  $current_user['proxy_user_id'] = $decrypt_data['token_id'];
                $Users = new \App\Models\User();
                $update_usr = $Users::update_record($update_arr, $condition, $current_user);
            }
            $user_data = Authorize::where('usr_id', $decrypt_data['token_id'])->get()->first();
            $loggeddata = $this->set_user_loggin($user_data->usr_id);
            $forcepassword = $this->force_password_check($user_data);
            $get_journal_details = Rv_encrypt($this->user_journal_details($user_data->usr_id));
            if (!empty($loggeddata)) {
                $this->set_login_tracker('in', $user_data->usr_id, $request->ip());
                $token = $loggeddata['token'];
                $result_data['client_functionality'] = $loggeddata['client_functionality'];
                $result_data['module_status'] = $loggeddata['module_status'];
                $result_data['profiledetails'] = $loggeddata['profile_data'];
                $result_data['redirect_to'] = $get_journal_details;
                $return_array =  array(
                    'success' => true,
                    'invalid' => false,
                    'display_otps' => isset($random_tokens) ? $random_tokens['display'] : '',
                    'token' => $token,
                    'token_type' => 'bearer',
                    'redirect_url' => $forcepassword,
                    'log_data' => $result_data,
                    'expires_in' =>  auth('api')->factory()->getTTL() * 60
                );
                return $this->success('Success', 200, $return_array);
            } else {
                $response = ['success' => false, 'message' => 'User not found !!'];
            }
        } else {
            if($atmpt > 3){
                setcookie('attempt_c', $atmpt, time()+0);
                setcookie('token_params', 0, time()+0);
                return $this->success("success", data:['relogin' => true]);
            }
            setcookie('attempt_c', $atmpt, time()+1800);
            $return_array['invalid'] = true;
            return $this->success('Success', 200, $return_array);
        }
    }

    public function generateRandomOTP($count)
    {
        $random_arr =  $dip_array = $md5_arr = array();
        for ($i = 0; $i < $count; $i++) {
            $new_otp = random_int(100000, 999999);
            array_push($dip_array, $new_otp);
            array_push($md5_arr, md5($new_otp));
        }
        $random_arr['display'] = $dip_array;
        $random_arr['hashed'] = $md5_arr;
        return $random_arr;
    }

    public function sudoLogin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'username'      => 'required',
            'password'    => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $return_array = array('status' => 'invalid');
        $user = Authorize::where('usr_username', $request->username)->orWhere('usr_email', $request->username)->get()->first();
        if ($user && \Hash::check($request->password, $user->usr_pwd)) {
            if (in_array('sudo', json_decode($user->usr_roles)) && $user->usr_status == 'a') {
                $data = $this->set_user_loggin($user->usr_id);
                $return_array['status'] = 'success';
                $return_array['token'] = $data['token'];
                $return_array['client_functionality'] = $data['client_functionality'];
                $General_settings = new \App\Models\General_Settings();
                $get_debug_enabled = $General_settings->where('gnl_id', 1)->get('gnl_debug_mode')->first();
                $return_array['debug_mode'] =  $get_debug_enabled->gnl_debug_mode;
            }
        }
        return $this->success('Success', 200, $return_array);
    }

    public function getClientFunctionalities(Request $request)
    {
        try {
            $orcid_status = $this->current_client->modules->mdl_orcid;
            $es_integration = $this->current_client->modules->mdl_es_integration;
            $return_array = [];
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
            $client_params  = Config::get($review_config);
            $client_url = [];
            $clntfnctlytcge = [];
            $jnl_id = NULL;
            $manage_register_button=$this->current_client->functionality->cfty_manage_login_register_button;
            $manage_contact_form=$this->current_client->functionality->cfty_feedback_form;
            $manage_contact_title=$this->current_client->functionality->cfty_disable_user_titles_salutation_mandatory;
            $clntfnctlytcge['tandc'] = $this->current_client->functionality->cfty_show_terms_conditions;
            $clntfnctlytcge['gndretncty'] = $this->current_client->functionality->cfty_gender_race_ethnicity;
            $track_registration_source = $this->current_client->functionality->cfty_track_registration_source;
            // $standalone_journal = $this->get_standalone_journal_data();
            // if ($standalone_journal != null){
            //     $jnl_id = $standalone_journal->jnl_id;
            // }
            if ($client_params && $orcid_status == 'y') {
                $client_url['client_id'] = isset($client_params['orcid']['oauth_client_id']) ? encrypt_link($client_params['orcid']['oauth_client_id']):'';
                $client_url['client_secret'] = isset($client_params['orcid']['oauth_client_secret']) ? encrypt_link($client_params['orcid']['oauth_client_secret']):'';
                $client_url['auth_url'] = isset($client_params['orcid']['oauth_authorization_url']) ? encrypt_link($client_params['orcid']['oauth_authorization_url']):'';
                $client_url['scope'] = isset($client_params['orcid']['scope']) ? encrypt_link($client_params['orcid']['scope']):'';
                $client_url['main_url'] = isset($client_params['orcid']['main_url']) ? encrypt_link($client_params['orcid']['main_url']):'';
                $client_url['member_api'] = isset($client_params['orcid']['member_api_url']) ? encrypt_link($client_params['orcid']['member_api_url']):'';
                $client_url['orcid_uri'] = encrypt_link('profile');
                $client_url['orcid_jnl_id'] = encrypt_link($jnl_id);
           
                $client_url['view_url'] = isset($client_params['orcid']['view_url']) ? encrypt_link($client_params['orcid']['view_url']):'';
                $client_url['link_url'] = isset($client_params['orcid']['link_url']) ? encrypt_link($client_params['orcid']['link_url']):'';    
            }
            if($es_integration == 'y')
            {
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $return_array['live_link'] = Rv_encrypt($es_api_data['ums_url']);
            }
            $all_platforms = Journals::get_all_records('jnl_journal_code as value ,jnl_journal_name as label', array(), NULL, NULL, '', NULL, 'jnl_journal_type');
            $return_array['params'] = ($orcid_status == 'y') ? Rv_encrypt(json_encode($client_url)) : [];
            $return_array['ajnls'] = (($manage_contact_form == 'y') && $all_platforms) ? Rv_encrypt($all_platforms) : '';
            $return_array['logorc'] = ($orcid_status == 'y') ? encrypt_link($orcid_status) : '';
            $return_array['tcge'] = Rv_encrypt(json_encode($clntfnctlytcge));
            /*For lepra Submission Guidlines Page */
            $return_array['submission_guide']=$this->current_client->functionality->cfty_show_submission_guidelines;
            /*end */
            $return_array['register_button_show'] = ($manage_register_button == 'y') ? encrypt_link($manage_register_button) : '';
            $return_array['manage_contact_form'] = ($manage_contact_form == 'y') ? encrypt_link($manage_contact_form) : '';
            $return_array['manage_contact_title'] = encrypt_link($manage_contact_title);
            $return_array['track_registration_source'] = encrypt_link($track_registration_source);
            $general_config= Config::get('general_config');
            $source_count = $general_config['source_count'];
            $return_array['source_count']=$source_count;

            $return_array['rvw_upg_lbl']  =   '';
            $rvw_upg_lbl_dt     =   '';
            $json=$this->current_client->functionality;
            $functionality = (array) $json; // decode as array
            $selectedKeys = ["cfty_change_password", "cfty_enable_chunk_upload_stream","cfty_reviewer_rating_feedback","cfty_disable_author_classification_edit","cfty_collect_supporting_details"];

            $return_array['selected_functionality'] = array_intersect_key($functionality, array_flip($selectedKeys));
            // if($this->current_client->clnt_client_code == 'pcori') {
            //     $rvw_upg_lbl_dt =   'August 14th.';
            // } 
            // else if($this->current_client->clnt_client_code == 'gigax') {
            //     $rvw_upg_lbl_dt =   'May 11th, 2024.';
            // }
            // else if($this->current_client->clnt_client_code == 'intech') {
            //     $rvw_upg_lbl_dt =   'June 9, 2024.';
            // }
            // if( $rvw_upg_lbl_dt != '')
            //     $return_array['rvw_upg_lbl'] = 'We have upgraded ReView to a major new version with enhanced security. Please reset your password using the "I forgot my password" link. Please disregard this message if you have already reset your password after '.$rvw_upg_lbl_dt;
            $client_exists=Clients::get_single_record_with_bind_cond('clnt_login_message',['clnt_client_code'=>$this->current_client->clnt_client_code]);
            if($client_exists){
                $return_array['rvw_upg_lbl'] = $client_exists->clnt_login_message ?? "";
            }
            $sys_dwntime_res        =   $this->get_sys_dwntime_message();
            $return_array['sys_downtime_msg'] = '';
            if(count($sys_dwntime_res) > 0) {
                $return_array['sys_downtime_msg']        =   $sys_dwntime_res;
            }           
            $proceeding_config = 'clients.' . $this->current_client->clnt_client_code . '.proceeding_config';
            $proceeding_array = Config::get($proceeding_config);
            $return_array['proceedingarray']=$proceeding_array; 
            return $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function logout_user(Request $request)
    {
        try
       {
        $return_array=array();
        $token=$request->bearerToken();
        $user_type = 'normal';
        if(isset($request['proxy_password']) && $request['proxy_password'] == TRUE)
        {
            $user_type = 'sudo';
        }
        $this->current_user = $this->get_current_user_details();
        $this->set_login_tracker('out',$this->current_user['user_id'], $request->ip(),$user_type);
        \JWTAuth::manager()->invalidate(new \Tymon\JWTAuth\Token($token), $forceForever = false);
        return $this->success('Success', 200, $return_array);
       }
       catch(\Exception $e)
       {
        return  $this->failure('Failed', 500, $e);
       }
    }

    //Code executed when 'connect orcid link' is clicked
    public function user_connect_orcid(Request $request)
    {
        /*
        if (isset($_GET['code'])) {
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
            $client_params  = Config::get($review_config);
            // $this->OrcidlibTraits('orcid_lib', $this->config->item('orcid'));
            $return = OrcidlibTraits::exchange_authorization_code($_GET['code'], 'orcid/connect');
            if ($return['status'] === false) {
                return array(
                    'status' => false,
                    'error_message' => $return['error_message']
                );
                // $this->session->set_flashdata('msg_error', $return['error_message']);
            }
            $orcid = array();
            $orcid_id = OrcidlibTraits::get_orcid_id();
            $token = OrcidlibTraits::get_token();
            // $current_user = $this->session->userdata('logged_user'); // need to update from local storage
            $data = array(
                'usr_orcid_id' => $orcid_id,
                'usr_orcid_token' => $token
            );
            $condition = array(
                'usr_id' => $current_user['user_id']
            );
            User::update_record($data, $condition, $current_user);
            // $this->session->set_flashdata('msg_success', customTrans('user_connected'));// use local storage
            $mails_info = OrcidlibTraits::get_primary_email($this->Users);
            if ($mails_info['status'] === true)

                $mail_data = User::get_single_record('usr_email', array(
                    'usr_email' => $mails_info['email']
                ));
            if ($mail_data == NULL && $mails_info['email'] != '') {
                $cc_data['uml_user_id'] = $current_user['user_id'];
                $cc_data['uml_email'] = $mails_info['email'];
                $cc_data['uml_posted_by'] = $current_user['user_id'];
                User_emails::insert_record($cc_data);
            }
            $cc_mails_info = OrcidlibTraits::get_secondary_emails($this->User_emails);
            if ($cc_mails_info['status'] === true)
                foreach ($cc_mails_info['email_array'] as $key => $mail) {
                    $cc_mail_data = User_emails::get_single_record('uml_email', array(
                        'uml_user_id' => $mail
                    ));
                    $cc_data['uml_user_id'] = $current_user['user_id'];
                    $cc_data['uml_email'] = $mail;
                    $cc_data['uml_posted_by'] = $current_user['user_id'];
                    if ($cc_mail_data == NULL && $mail != '')
                        User_emails::insert_record($cc_data);
                }
            $return_emp_affl_info = OrcidlibTraits::get_employments();
            if ($return_emp_affl_info['status'] === true)
                $orcid['employments'] = $return_emp_affl_info['employments'];
            $return_edu_affl_info = OrcidlibTraits::get_education_details();
            if ($return_edu_affl_info['status'] === true)
                $orcid['educations'] = $return_edu_affl_info['educations'];
            if (count($orcid['employments']) > 0) {
                $this->load->model('Country');
                $this->data['country_list'] = $this->Country->get_all_records('*', array(
                    'cnt_id !=' => '0'
                ), 'cnt_country');
                $this->data['user_connect'] = TRUE;
                $this->data['content_view'] = 'user/user_orcid_info';
                $this->data['js_view'] = 'user/user_orcid_info_js';
                $this->data['data_view'] = $orcid;
                $this->_render_page('templates/fullscreen', $this->data);
            } else {
                redirect(base_url('profile'));
            }
        } else if (isset($_GET['error'])) {
            set_flash("error", customTrans('orcid_connect_deny'));
            redirect(base_url('profile'));
        } else {
            $this->session->set_userdata('login_with_orcid', array(
                'status' => false,
                'error_message' => customTrans('orcid_error_01')
            ));
            redirect(site_url());
        }
        */
    }

    // Orcid affiliations importing to the system
    /*public function orcid_aff_save(Request $request)
    {
        $post_data = $this->input->post('orcid');
        if ($post_data !== NULL) {
            $current_user = $this->session->userdata('logged_user');
            if (isset($post_data['emp_aff']) && count($post_data['emp_aff']) > 0 || isset($post_data['edu_aff']) && count($post_data['edu_aff']) > 0) {
                $this->load->model('user/User_affiliation');
                if (!empty($post_data['emp_aff'])) {
                    foreach ($post_data['emp_aff'] as $empl) {
                        $user_emp_affiliation = array(
                            'usaff_email' => '',
                            'usaff_department' => $empl['dep'],
                            'usaff_company' => $empl['inst'],
                            'usaff_address_line1' => $empl['city'],
                            'usaff_address_line2' => $empl['region'],
                            'usaff_cnt_id' => $empl['cntry'],
                            'usaff_user_id' => $current_user['user_id'],
                            'usaff_from_orcid' => 'y'
                        );
                        $user_affiliation_status = $this->User_affiliation->insert_record($user_emp_affiliation);
                    }
                }
                if (!empty($post_data['edu_aff'])) {
                    foreach ($post_data['edu_aff'] as $edu_aff) {
                        $user_edu_affiliation = array(
                            'usaff_email' => '',
                            'usaff_department' => $edu_aff['dep'],
                            'usaff_company' => $edu_aff['inst'],
                            'usaff_address_line1' => $edu_aff['city'],
                            'usaff_address_line2' => $edu_aff['region'],
                            'usaff_cnt_id' => $edu_aff['cntry'],
                            'usaff_user_id' => $current_user['user_id'],
                            'usaff_from_orcid' => 'y'
                        );
                        $user_affiliation_status = $this->User_affiliation->insert_record($user_edu_affiliation);
                    }
                }
                echo json_encode(array(
                    'status' => 'success',
                    'link' => base_url('profile')
                ));
            }
        } else {
            echo json_encode(array(
                'status' => 'error',
                'link' => base_url('profile')
            ));
        }
    }*/


    /*
    get client details
    commited date :- 17-01-2022
    Requested type :- GET
    */


  public function user_journal_details($user_id, $standalone_journal = null)
    {
        try {
            $data = '/';
            $select = "DISTINCT(usrj_jnl_id),jnl_journal_code";
            $user_journal_table = (new \App\Models\User_to_journals())->getTable();
            $journal_table = (new \App\Models\Journals())->getTable();
            $tables = array(
                'main_table' => $user_journal_table,
                'join_table' => array( $journal_table => array($user_journal_table . '.usrj_jnl_id', $journal_table . '.jnl_id') )
            );
            $criteria = "usrj_usr_id = {$user_id} AND jnl_journal_status ='y'";
            $criteria .= isset($standalone_journal) ? " AND jnl_standalone = 'y' " : "";
            $jnl_data = Journals::get_results_using_joins($tables, $select, $criteria, 'all');
            if (!empty($jnl_data) && count($jnl_data) == 1) {
                $data .= env("PLATFORMTYPE"). '/' . $jnl_data[0]->jnl_journal_code;
            }
            return $data;
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
}
