<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use App\Models\User;
use App\Models\Clients;
use App\Models\User_emails;
use App\Models\User_flags;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\ConnectException;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Config;
use DB;
use Auth;
use App\Http\Traits\ModalDataTrait;

class Clientconfig_Api extends Controller
{

    /*
    loading config file based on client code
    commited date :-  08-02-2022
    Request type :- GET
    */ 
    public function index(Request $request)
    {

        $request_array = $request->all(); 
        $select='*';
       $client= Clients::get_single_record($select);

        if(isset($request_array['search']) )
        {
        $config_iet=$request_array['search'];
        $config=Config::get('clients.'.$client->clnt_client_code.'.'.$config_iet);
        try {
            // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
            return response()->json([
                'result' =>$config,
                'client_fieldvalid'  => $this->get_clientfieldrequired_functionalities(),
                'success'=>true
    
            ],200);
            } 
        catch (ConnectException $e) {
            return response()->json([
                'success' => false,
                'result' => $e->getMessage(),
            ], 500);
        } 
        }
        /*else
        {
            $config=Config::get('clients.'.$client->clnt_client_code);
            try {
                return response()->json([
                    'result'=>$config,
                    'success'=>true
        
                ],200);
            } 
            catch (ConnectException $e) {
                return response()->json([
                    'success' => false,
                    'result' => $e->getMessage(),
                ], 500);
            }
        }  */
    }    
    /*
GET CLIENT SETTINGs
    */
    public function client_settings(Request $request)
    {
      
        try {
        
            $client_settings=$this->current_client->settings;
            return response()->json([
                'result'=>$client_settings,
                'success'=>true
    
            ],200);
        }
        catch (ConnectException $e) {
            return response()->json([
                'success' => false,
                'result' => $e->getMessage(),
            ], 500);
        }
    }

    public function terms_condition(Request $request)
    {
        try
        {
        $return_array=array();
        $post_data=$request->all();
        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        $User=new \App\Models\User();
        $user_id=Rv_decrypt($post_data['user_id']);
        $valid_user=$this->validate_exist_user($user_id);
       // parse_str($this->decrypt_data($post_data['select']), $_GET);
       if( $valid_user)
       {
       $user_data=$User::get_single_record("usr_terms_condition","usr_id={$user_id}");
        $review_terms=$this->current_client->clnt_review_terms;
        $return_array['terms']=$review_terms;
        $return_array['user_terms_status']=$user_data->usr_terms_condition;
       }
        return  $this->success('Success',200,$return_array);    
       }
  catch (\Exception $e){

       return  $this->failure('Failed',500,$e);
     }

    }
    public function disagree_terms_condition(Request $request)
    {
        try{
            $post_data=$request->all();
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
        
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $user_id=$this->decrypt_data($post_data['user_id']);
            $User=new \App\Models\User();
            $usr_result=$User::get_single_record("*","usr_id={$user_id}");
            $terms_condition['terms'] =$usr_result->usr_terms_condition;

            return  $this->success('Success',200,$terms_condition);   

        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }

    }
    public function save_terms_condition(Request $request)
    {
        try
        {
            $return_array=array();
            $post_data=$request->all();
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
        
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $user_id=$this->decrypt_data($post_data['user_id']);
            $valid_user=$this->validate_exist_user($user_id);

            if ($valid_user==true)
            {
            $this->current_user= array(
                'user_id' =>$user_id,
                'proxy_user_id' => 0,
            ); 
            $User=new \App\Models\User();
            $usr_condition ="usr_id={$user_id}";
			$user_details = array(
				'usr_terms_condition' => 'y'
			);
		
			$updated_result = $User::update_record($user_details,$usr_condition);
			if ($updated_result)
			{
                $usr_result=$User::get_single_record("*","usr_id={$user_id}");
                if((isset($post_data['terms_flag'])&&$post_data['terms_flag']==false))
                $site_url= $this->confirm_mail_terms($usr_result);
                $return_arr['status'] = 'success';
                $return_arr['msg'] = 'Thank you for confirming your email. Please check your inbox to get your username and password.';

			}
		
        }
            return  $this->success('Success',200,$return_array);   

        }
        catch(\Exception $e)
        {
      
           return  $this->failure('Failed',500,$e);
        }
    }

    public function confirm_mail_terms($user_data)
    {

      $user_id=$user_data->usr_id;
      $user_deeplink_token=$user_data->usr_deeplink_token;
     

        $current_date_time = date('Y-m-d H:i:s');
        $User=new \App\Models\User();
        $user_record = $User::get_single_record('*', "usr_id={$user_id} AND usr_deeplink_token='{$user_deeplink_token}'");
           
        //$this->check_standalone_url($this->session->userdata('userId'));
        if ($user_record != NULL && ($user_record->usr_status == 'w' || $user_record->usr_status == 'a')) {
            //#370 BUG Empty "Account created date" in user info
            $User::update_record(array('usr_reg_date'=>$current_date_time),"usr_id={$user_record->usr_id}");
            $current_user = array(
                'user_id' => $user_record->usr_id,
                'proxy_user_id' => $user_record->usr_id);
            $send_mail = $this->create_user_email($user_record, $current_user);
              
            }

            
    }
    public function terms_data(Request $request)
    {
        try
        {
            $post_data=$request->all();
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            $User=new \App\Models\User();
            if($post_data['select']!=NULL)
            {

            $user_id=isset($_GET['userid']) ? $_GET['userid'] : '';
            $deeplink_token=isset($_GET['key']) ? $_GET['key'] : '';
            if($user_id!=NULL&&$deeplink_token!=NULL)
            {
               
            $verify_userid=$this->validate_exist_user($user_id);
            if($verify_userid==TRUE)
            {
                $user_data=$User::get_single_record("usr_id,usr_deeplink_token","usr_id={$user_id}");
                $return_array['userdata']=$user_data;
            }
     
            }
            return  $this->success('Success',200,$return_array);  
       
             }

        }
        catch(\Exception $e)
        {
           return  $this->failure('Failed',500,$e);
        }
    }



    public function getGenderracestatus(Request $request)
    {
        try
        {
            $return_array=array();
            $post_data=$request->all();
            $status='n';
            $main_array=[];
            $genderconfigkey=array("gender","ethnic_origins","race");
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $User=new \App\Models\User();
            $user_id=$this->decrypt_data($post_data['user_id']);
            $valid_user=$this->validate_exist_user($user_id);
           if( $valid_user) {
                $user_data=$User::get_single_record("usr_gender as gender,usr_ethnicity as ethnicity,usr_race as race","usr_id={$user_id} ");
                if(!empty($user_data)){
                    if(empty($user_data->gender) && empty($user_data->ethnicity) && empty($user_data->race)) {
                        $status='y';
                    }                    
                } 
                $return_array['user_data']=$user_data;
                $return_array['user_genderracestatus']=$status;
            }
            

            $post_data = $request->all(); 
            
            $url  =   '';
            //use select_array_exist common function
            if(isset( $post_data)&&(isset($post_data['select']))&&($post_data['select']!=NULL)){
                  $select_string=implode(',',$post_data['select']);
                  $select_array=explode(',',$select_string);
                  if(isset($post_data['url']))
                        $url  =   decrypt_link($post_data['url']);

                  if(!empty($select_array)) {

                      foreach($select_array as $select) {                      
                        if (!in_array($select,$genderconfigkey)) {
                          continue;
                        }

                        if($select == 'subjects') {
                            if($url == '/login')
                                $select =   'feedback_subjects_login';
                            else
                                $select =   'feedback_subjects';
                        }
                        $main_array[$select]=$this->UserConfigdata($select)[$select];

                      }
                  }
            }
            $return_array['config_array'] = $main_array;
            return  $this->success('Success',200,$return_array);    
        } catch (\Exception $e){
            return  $this->failure('Failed',500,$e);
        }
    }

    public function saveGenderracestatus(Request $request) {
        try
        {
            $return_array=array();
            $post_data=$request->all();
            $ethnicityarray=[];
            $racearray=[];
            $gender=null;
            $ethnicity_val=null;
            $race_val=null;

            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'gender' => 'required',
                'ethnicity' => 'required',
                'race' => 'required'
            ]);
        
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $user_id=$this->decrypt_data($post_data['user_id']);

            $gender=$post_data['gender'];
            $ethnicity=implode(',',$post_data['ethnicity']);            
            $ethnicityarray['opt_val'] = $ethnicity;
            if(in_array('s',$post_data['ethnicity'])){
                $ethnicity_selfdescribe=$post_data['ethnicity_selfdescribe'];
                $ethnicityarray['selfdescribe'] = $ethnicity_selfdescribe;
            }
            $race=implode(',',$post_data['race']);           
            $racearray['opt_val'] = $race;           
            if(in_array('s',$post_data['race'])){
                $race_selfdescribe=$post_data['race_selfdescribe'];
                $racearray['selfdescribe'] = $race_selfdescribe;
            }

            $ethnicity_val=json_encode($ethnicityarray);
            $race_val=json_encode($racearray);
            $valid_user=$this->validate_exist_user($user_id);

            if ($valid_user==true) {
            
                $this->current_user= array(
                    'user_id' =>$user_id,
                    'proxy_user_id' => 0,
                ); 
                $User=new \App\Models\User();
                $usr_condition ="usr_id={$user_id}";
                $user_details = array(
                    'usr_gender' =>  $gender,
                    'usr_ethnicity' =>  $ethnicity_val,
                    'usr_race' =>  $race_val
                );
                $updated_result = $User::update_record($user_details,$usr_condition);
                return  $this->success('Success',200,$return_array);   
		
            }else {
                $return_array['msg']='Unauthorized access'; 
                return  $this->warning('Warnings',200,$return_array,'warning');
            }
           

        }
        catch(\Exception $e)
        {
      
           return  $this->failure('Failed',500,$e);
        }
    }






}
