<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use  App\Http\Traits\UserDataTrait;
use App\Models\Articles;  /* TASK #9388 Encrypted Article ID Passed When Clicking "Contact Us" from View Article Page*/
use Illuminate\Support\Facades\Validator;
use Config;
class Configuartion_Data_Api extends Controller
{
   use UserDataTrait;
 /*  load global config file
     commited date :-  08-02-2022
     Request type :- GET
 */
  public  function index(Request $request)
    {
        try
        {
        $select=$request->select;
        $configvalues=$this->UserConfigdata($select);
        // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
            return response()->json([
                'success'=>true,
                'result'=>$configvalues,
                'client_fieldvalid'  => $this->get_clientfieldrequired_functionalities()
            ]);
        
        }
        catch (exception $e) {
            return response()->json([
                'success'=>false,
                'result'=>$e
            ]);
        }
     
    }

    public function get_multiple_client_config_data(Request $request)
    {
        try{
            $request_array = $request->all(); 
            $main_array=[];
            $url  =   '';
            $validator = Validator::make($request_array, [
                'select'     => 'required',
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }
            $txtstagebtnarray = array('input'=>$request_array['select'][0],'type'=>'string', 'enc_data'=>FALSE ); 
            $arrayvalidation = $this->Rv_validator($txtstagebtnarray);
            $select_arrays=['titles','managing_roles','userstatus','production_designated_roles','roles','gender','ethnic_origins','race','feedback_subjects_login','feedback_subjects','subjects'];
            if(isset( $request_array)&&(isset($request_array['select']))&&($request_array['select']!=NULL)){
                if ($arrayvalidation != TRUE) {
                    return $this->warning('Failed', 422, 'Invalid data');
                }
                  $select_string=implode(',',$request_array['select']);
                  $select_array=explode(',',$select_string);
                if(isset($request_array['url'])) { /* TASK #9388 Encrypted Article ID Passed When Clicking "Contact Us" from View Article Page*/
                    $url  =   decrypt_link($request_array['url']);
                    /* TASK #9388 Encrypted Article ID Passed When Clicking "Contact Us" from View Article Page*/
                    $parts = explode("/", $url);
                    if ((in_array('view-article', $parts) || in_array('author-article',$parts)) && isset($parts[4])) {
                        $articleId = decrypt_link($parts[4]);
                    } elseif ((in_array('edit-article', $parts) || in_array('preview-article', $parts)||in_array('edit-article-production', $parts)) && isset($parts[5])) {
                        $articleId = decrypt_link($parts[5]);
                    }
                    if (isset($articleId)) {
                        $article_code = Articles::get_single_record_with_bind_cond('art_code', ['art_id' => $articleId]);
                        if ($article_code) {
                            $main_array['article_code'] = $article_code->art_code;
                        }
                    }
                }
                    /* end TASK #9388 Encrypted Article ID Passed When Clicking "Contact Us" from View Article Page*/
                  if(!empty($select_array))
                  {
                      
                      foreach($select_array as $select)
                      {
                        if (!in_array($select,$select_arrays)) {
                            return  $this->failure('Failed', 422, 'Invalid data');
                            // continue;
                          }
                        if($select == 'subjects') {
                            if($url == '/login' || $url == '/identify')
                                $select =   'feedback_subjects_login';
                            else
                                $select =   'feedback_subjects';
                        }
                        $main_array[$select]=$this->UserConfigdata($select)[$select];
                      }
                  }
            }
            // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
            $main_array['client_fieldvalid']  = $this->get_clientfieldrequired_functionalities();
            return  $this->success('Success',200,$main_array);
        }
             catch (\Exception $e){
            return  $this->failure('Failed',500,$e);
        }
    }
}
