<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\Validator;
use Illuminate\Routing\Controller as BaseController;
use App\Models\User_affiliations;
use App\Models\Clients;
use App\Models\Modules;
use App\Models\Client_settings;
use App\Models\Client_functionalities;
use JWTAuth;
use JWTAuthException;
use Illuminate\Support\Facades\URL;
use  App\Http\Traits\UserDataTrait;
use App\Http\Traits\ReviewerListTrait;
use App\Http\Traits\ArticlelistTrait;
use App\Http\Traits\RespondsWithHttpStatus;
use Config;
use \stdClass;
use App\Models\User;
use App\Models\Roles;
use App\Models\User_password_history;
use App\Models\Generic_flows;
use App\Models\Journal_settings;
use App\Models\Article_flow;
use App\Models\Suspecious_activity;
use App\Models\Advance_flow_movement;
use App\Models\Journals;
use App\Models\User_to_journals;
use App\Models\Articles;
use App\Models\Article_types;
use App\Models\Article_type_advance_options;
use App\Models\Article_pdf;
use App\Models\Attachment_files;
use App\Models\Blind_user_articles;
use App\Models\Ithenticate_autosubmission;
use App\Models\User_journal_sort_keys;
use App\Models\User_journal_dashboard_tile_sort_keys;
use App\Models\Article_next_task;
use App\Models\Article_tab_status;
use App\Http\Traits\JournalUserfunctionTrait;
use Illuminate\Support\Facades\Storage;
use App\Http\Traits\RolesConfigTrait;
use App\Http\Traits\IthenticateTrait;
use File;
use App\Http\Traits\StagemovementTrait;
use App\Http\Traits\General_ConfigTraits;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\SubmissionTrait;
use App\Http\Traits\InstituteSearchEngineTrait;
use App\Http\Traits\SendGlobalEmailFunctionTrait;
use App\Http\Traits\WorkflowAssignmentTypeTrait;
use App\Models\Journal_permission;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use ZipArchive;
use App\Http\Traits\WorkflowTrait;
use App\Models\Adhoc_user_role;
use App\Models\Article_custom_reasons;
use App\Models\Author_credits;
use App\Models\Authors;
use App\Models\Authors_affiliation;
use App\Models\Reviewed_privilaged_users;
use App\Models\User_articles;
use App\Models\User_attachment_files;
use App\Models\User_emails;
use App\Models\User_flags;
use App\Models\User_global_flags;
use App\Models\User_journal_classifications;
use App\Models\Classifications;
use App\Models\User_journal_filter_keys;
use App\Models\User_journal_preference;
use App\Models\User_meta;
use App\Models\User_note;
use App\Models\User_panel_collapsible_view;
use App\Models\User_to_journal_orcid_details;
use App\Models\Userkeywords;
use App\Models\Users_unavailability;
use APP\Models\Issue_management;
use APP\Models\Article_flag;
use APP\Models\Article_versions_reviewers;
use APP\Models\Authors_table;
use App\Models\Flags;
use App\Models\Ftp;
use App\Models\Ftp_master;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use DB;
use Jenssegers\Agent\Facades\Agent;
use Image;
use Log;
use App\Models\System_downtime;

use App\Models\Payment_order;
use App\Models\General_permission;
use App\Models\Stage_email_tmpl_reference;
use App\Models\Terms;
use App\Models\Article_classification;
use DateTime;  /*Task #1787 Due date in settings page */

class Controller extends BaseController
{
    use UserDataTrait;
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    use RespondsWithHttpStatus;
    use JournalUserfunctionTrait;
    use RolesConfigTrait;
    use IthenticateTrait;
    use StagemovementTrait;
    use General_ConfigTraits;
    use UtilityTrait;
    use SubmissionTrait;
    use SendGlobalEmailFunctionTrait;
    use WorkflowTrait;
    use ArticlelistTrait;
    use InstituteSearchEngineTrait;
    use WorkflowAssignmentTypeTrait;
    use ReviewerListTrait;
    protected $client_code;
    protected $current_client;
    //use DateTime;
    public function __construct()
    {

        /* start --- check if application supports multiclient and get curresponding client data */
        //Get Client Details
        $client_details = $this->get_client_details();
        $this->client_code = $client_details->clnt_client_code;
        $client_advanced_settings = $this->get_client_settings($client_details->clnt_id);
        //Get Modules and Basic Settings
        $client_settings = $client_advanced_settings['client_settings'];
        $client_modules = $client_advanced_settings['client_modules'];
        $client_functionality = $this->get_client_functionalities($client_details->clnt_id, $this->client_code);

        if ($client_details == NULL || $client_settings == NULL || $client_modules == NULL) {
            die('Client settings not found');
        }
        $current_client = new StdClass;
        $current_client->clnt_id = $client_details->clnt_id;
        $current_client->clnt_client_code = $client_details->clnt_client_code;
        $current_client->clnt_client_name = $client_details->clnt_client_name;
        $current_client->clnt_client_city = $client_details->clnt_client_city;
        $current_client->clnt_client_region = $client_details->clnt_client_region;
        $current_client->clnt_client_country = $client_details->clnt_client_country;
        $current_client->clnt_created_date = $client_details->clnt_created_date;
        $current_client->clnt_email = $client_details->clnt_email;
        $current_client->clnt_phone = $client_details->clnt_phone;
        $current_client->clnt_fax = $client_details->clnt_fax;
        $current_client->clnt_review_terms = $client_details->clnt_review_terms;
        $current_client->settings = $client_settings;
        $current_client->platform_type = env('PLATFORMTYPE', 'journal');
        $current_client->enable_upload_s3_bucket = isset($client_functionality->cfty_enable_upload_s3_bucket) ? $client_functionality->cfty_enable_upload_s3_bucket : 'n';

        //remove unwanted fields from module object
        unset($client_modules->mdl_posted_date, $client_modules->mdl_posted_by, $client_modules->mdl_operation);
        $current_client->modules = $client_modules;
        //remove unwanted fields from functionality object
        unset($client_functionality->cfty_posted_date, $client_functionality->cfty_posted_by, $client_functionality->cfty_operation);
        $current_client->functionality = $client_functionality;
        $this->current_client = $current_client;
        $this->data['current_client'] = $current_client;

        /* end --- check if application supports multiclient and get curresponding client data */
    }
    /*
    Data:12-03-2022
    Get Client information based on client id
    */
    public function get_client_details($select = '*')
    {
        $criteria = 'clnt_id=1';
        $client_details = Clients::get_single_record($select, $criteria);
        return $client_details;
    }
    /*
    Data:12-03-2022
    Get Client Settings and Modules based on client id
    */
    public function get_client_settings($clnt_id)
    {
        $settings_crietria = 'cs_client_id=' . $clnt_id;
        $client_settings = Client_settings::get_single_record('cs_client_identifier,cs_client_identifier_type,cs_min_keyword,cs_max_keyword,cs_date_format, cs_google_analytics_id', $settings_crietria);
        $module_crietria = 'mdl_clnt_id=' . $clnt_id;
        $client_modules = Modules::get_single_record('*', $module_crietria);
        $return_array['client_settings'] = $client_settings;
        $return_array['client_modules'] = $client_modules;
        return $return_array;
    }

    public function get_current_user_details()
    {
        $current_user = array();
        $token = JWTAuth::getToken();

        if(!$token){
            return null;
        }
        
        $tokeninfo = JWTAuth::getPayload($token)->toArray();

        if (isset($tokeninfo) && (!empty($tokeninfo))) {

            if ($tokeninfo['user_id'] == $tokeninfo['proxy_user_id'])
                $proxy_user_id = 0;
            else
                $proxy_user_id = $tokeninfo['proxy_user_id'];
            $current_user = array(
                'user_id' => $tokeninfo['user_id'],
                'usr_jnl_standalone' => auth()->user()->usr_jnl_standalone ??'',
                'proxy_user_id' => $proxy_user_id,
                'roles' => ($tokeninfo['user_role']!=NULL)?json_decode($tokeninfo['user_role']):[]
            );
        }

        return  $current_user;
    }
    public function add_user_affiliation($affiliation_data, $user_id, $mark_as_prime = FALSE)
    {

        $data_affiliation = array(
            'usaff_user_id' => $user_id,
            'usaff_email' => (isset($affiliation_data['affiliation_email'])?$affiliation_data['affiliation_email'] : null),
            'usaff_department' => isset($affiliation_data['department'])?$affiliation_data['department']:'',
            // 'usaff_type' => $affiliation_data['type_institution'],
            'usaff_company' => isset($affiliation_data['institution'])?$affiliation_data['institution']:'',
            'usaff_address_line1' => isset($affiliation_data['addressline_1'])?$affiliation_data['addressline_1']:'',
            'usaff_address_line2' => isset($affiliation_data['addressline_2'])?($affiliation_data['addressline_2']):'',
            'usaff_cnt_id' => isset($affiliation_data['country'])?$affiliation_data['country']:'',
            'usaff_postal_code' => isset($affiliation_data['zipcode'])?$affiliation_data['zipcode']:'',
            'usaff_phone' => isset($affiliation_data['aff_phonenumber'])?$affiliation_data['aff_phonenumber']:'', //changed for ajo john
            'usaff_type' => $affiliation_data['type_institution'],
            'usaff_posted_by'=> $user_id,
            'usaff_state' => isset($affiliation_data['state'])?$affiliation_data['state']:'',
            //'usaff_from_orcid' => 'n'
        );
        if ($this->current_client->modules->mdl_ror == 'y' && !empty($affiliation_data['rorIdentifier']) && $affiliation_data['rorIdentifier'] != 'undefined') {
            $data_affiliation['usaff_ror_id'] = $affiliation_data['rorIdentifier'];
            $data_affiliation['usaff_ringgold_id'] = NULL;
            $data_affiliation['usaff_ringgold_family'] = NULL;
        } elseif ($this->current_client->modules->mdl_ringgold == 'y' && !empty($affiliation_data['ringgoldIdentifier']) && $affiliation_data['ringgoldIdentifier'] != 'undefined') {
            $data_affiliation['usaff_ror_id'] = NULL;
            $data_affiliation['usaff_ringgold_id'] = $affiliation_data['ringgoldIdentifier'];
            $post_data = array(
                'search_key' => $affiliation_data['ringgoldIdentifier']
            );
            $response = $this->search_organisation($post_data, false, true);
            $responseArr = json_decode($response);
            $ringgoldFamily = (implode(',', array_column($responseArr->response, 'member')));
            $data_affiliation['usaff_ringgold_family'] = '[' . $ringgoldFamily . ']';
        }

        $change_prime_aff = FALSE;
        if (!empty($affiliation_data['prime_aff_check']) && $affiliation_data['prime_aff_check'] == 'y')
            $change_prime_aff = TRUE;

        if ($mark_as_prime == TRUE || $change_prime_aff == TRUE)
            $data_affiliation['usaff_prime_affiliation'] = 'y';
        $insert_id = User_affiliations::insert_record($data_affiliation);
    }
    public function get_userstatus($status)
    {
        $select = 'userstatus';
        $configvalues = $this->UserConfigdata($select);
        return $configvalues['userstatus'][$status];
    }
    public static function check_standalone_user_status($user_id=NULL)
	  {
		try{

			$jrnl_grp = null;
			$url = $this->url_first_content();
			if ($url != NULL)
			{
				if ($url == 'controlpanel')
				{
					$jrnl_grp = $url;
				}
				else
				{
					// $criteria ='jnl_standalone_group =' .$url;
					$criteria =array('jnl_standalone_group'=>$url);
					$jrnl_grp = Journals::get_single_record_with_bind_cond('*',$criteria );

				}
			}

			return $jrnl_grp;
		} catch (Exception $e) {
			return  $this->failure('Failed', 500, $e);
		}
	  }
    public function save_generic_forms($userid, $formid, $formdata, $client_gnrc_form_identifiers = NULL)
    {
        $Generic_form_elements = new \App\Models\Generic_form_elements();
        $User_meta = new \App\Models\User_meta();
            $i = 1;
            $manage_depend_file_upload = array();
        foreach ($formdata as $key => $formdetails)
		{
            $elementid = explode('_', $key);
			$elementid = end($elementid);
            $elementdata = $Generic_form_elements::get_element_details_with_group($elementid);
            $processed_data = $this->process_form_element_data($elementid, $formdetails, $elementdata);
            $dataarray = array(
				'urg_user_id' => $userid,
				'urg_frm_id' => $formid,
				'urg_element_id' => $elementid,
				'urg_gform_title' => $elementdata->gncf_form_title,
				'urg_gfg_id' => $elementdata->gfg_id,
				'urg_group_name' => $elementdata->gfg_group_name,
				'urg_label' => $elementdata->emt_label,
				'urg_data' => $processed_data['elementvalue'],
				'urg_display_data' => $processed_data['element_dply_data'],
				'urg_data_order' => $i
			);
            $elem_codition  = "urg_user_id={$userid} AND urg_frm_id={$formid} AND  urg_element_id= {$elementid}";
            // $user_array   = "user_id={$userid} AND proxy_user_id={$userid}";
            $user_array = array(
				'user_id' => $userid,
				'proxy_user_id' => $userid
			);
			$existdata =$User_meta::get_single_record("*", $elem_codition);
            $insert_validate = TRUE;

            if ($elementdata->emt_dependency_required == 1)
			{
				if (in_array('ctrl_' . $elementdata->emt_depending_control, $formdata))
				{
                    $criteria = "emt_id={$elementdata->emt_depending_control}";
					$dependency_elementdata = $Generic_form_elements->get_single_record('*', $criteria);

					$insert_validate = $this->validate_dependency_insert($elementdata, $dependency_elementdata, $formdata);
				}
            }
                // if (count($existdata) > 0)
                if (!empty($existdata))
			    {
                    if ($elementdata->emt_element_type != 'file')
				    {
					$User_meta::delete_records($elem_codition, '', $this->current_user);
					if ($insert_validate == TRUE)
					{

					$insertid = $User_meta::insert_record($dataarray, $user_array);

//					Customisation #1345 : Update user table with DND -- if edit generic form
						if (in_array($elementdata->emt_element_type, array(
								'radiobutton',
								'combobox')) && !empty($client_gnrc_form_identifiers) && !empty($elementdata->emt_unique_identifier) && array_key_exists($elementdata->emt_unique_identifier, $client_gnrc_form_identifiers))
						{
							$user_tb_fileld_value = 'n';
							if ($processed_data['elementvalue'] == $elementdata->emt_dnd_value)
							{
								$user_tb_fileld_value = 'y';
							}

							$user_tb_fileld_name = '';
							if ($elementdata->emt_unique_identifier == 'USER_DATA_PROTECTION_MARKETING')
								$user_tb_fileld_name = 'usr_dnd_marketing';
							elseif ($elementdata->emt_unique_identifier == 'USER_DATA_PROTECTION_SHARE_TO_COPUBLISHERS')
								$user_tb_fileld_name = 'usr_dnd_share_data';

							if ($user_tb_fileld_name != '')
							{
								User::update_record(array(
									$user_tb_fileld_name => $user_tb_fileld_value), array(
									'usr_id' => $userid), $user_array);
							}
						}

					}
				    }
                    /*
                    elseif ($elementdata->emt_element_type == 'file' && $elementdata->emt_dependency_required == 1 && $insert_validate == TRUE)
				        {
					        if ($existdata->urg_data != '')
					            {
                                    /// starting remove uploaded files///
                                    $upload_file_ids = json_decode($existdata->urg_data);
                                    $generic_upload_files = $this->User_meta_files->get_upload_files($upload_file_ids);
                                    foreach ($generic_upload_files as $up_file)
                                    {
                                        $articletype_code = $get_article_data->artp_abbr_article_type;
                                        $article_id = $get_article_data->art_id;

                                        $file_path = 'uploads/user_meta_files' . '/' . $userid . '/' . $up_file->agf_name;
                                        if (file_exists($file_path))
                                        {
                                            unlink($file_path);
                                        }
                                    }
                                    /// end remove uploaded files//
                                    //remove uploaded files from rvw_article_generic_form_files
                                    $this->User_meta_files->del_upload_files($upload_file_ids);
                                    $this->User_meta->delete_records($elem_codition, '', $this->current_user);

                                    $manage_depend_file_upload['tb_upload_list_' . $elementid] = 'tb_body_' . $elementid;
					            }
				        }
                        elseif ($elementdata->emt_element_type == 'file')
                        {
                            $this->User_meta->update_record(array(
                                'urg_data_order' => $i
                                ), $elem_codition, $user_array);
                        }
				        $insertid = $existdata->urg_id;
                        */
                }
                else
			    {

				if ($elementdata->emt_element_type != 'file' && $insert_validate == TRUE)
				{
					$insertid = $User_meta::insert_record($dataarray, $user_array);


//				Customisation #1345 : Update user table with DND
					if (in_array($elementdata->emt_element_type, array(
							'radiobutton',
							'combobox')) && !empty($client_gnrc_form_identifiers) && !empty($elementdata->emt_unique_identifier) && array_key_exists($elementdata->emt_unique_identifier, $client_gnrc_form_identifiers))
					{
						$user_tb_fileld_value = 'n';
						if ($processed_data['elementvalue'] == $elementdata->emt_dnd_value)
						{
							$user_tb_fileld_value = 'y';
						}

						$user_tb_fileld_name = '';
						if ($elementdata->emt_unique_identifier == 'USER_DATA_PROTECTION_MARKETING')
							$user_tb_fileld_name = 'usr_dnd_marketing';
						elseif ($elementdata->emt_unique_identifier == 'USER_DATA_PROTECTION_SHARE_TO_COPUBLISHERS')
							$user_tb_fileld_name = 'usr_dnd_share_data';

						if ($user_tb_fileld_name != '')
						{
                            $criteria="usr_id={userid}";
							User::update_record(array(
								$user_tb_fileld_name => $user_tb_fileld_value), $criteria, $user_array);
						}
					}
				}
				elseif ($elementdata->emt_element_type == 'file')
				{
					$insertid = TRUE;
				}
			}
			$i++;
			}
            /*
            if ($insertid != '')
            {
                $current_user = $this->session->userdata('logged_user');
                if (isset($current_user['wrg_msg_profile_meta']))
                {
                    unset($current_user['wrg_msg_profile_meta']);

                    // $general_settings = $this->General_settings->get_single_record('*', array(gnl_id' => 1));

                    $keyword_count = $this->User_keywords->get_single_record('count(*) as cnt', array(
                        'ukwd_usr_id' => $userid));

                    unset($current_user['wrg_msg_profile_keyword']);
                    if ($this->current_client->settings->cs_min_keyword > $keyword_count->cnt)
                        $current_user['wrg_msg_profile_keyword'] = lang('profile_not_cmpt');
                    //$this->session->set_userdata('logged_user', $current_user);
                    $this->set_user_session_data($current_user, TRUE);
                }
            }
            */

            $data['manage_depend_file_upload'] = $manage_depend_file_upload;
            $data['insertid'] = $insertid;
            return $data;

        // print_r($formid);
    }
    public function validate_dependency_insert($elementdata, $dependency_elementdata, $formdata, $dynamc_id = null)
	{
        $dynamc_key = '';
        if($dynamc_id != null)
            $dynamc_key = '_'.$dynamc_id;
		$return_valid = FALSE;
		if ($dependency_elementdata->emt_element_type == 'checkbox')
		{
			if (in_array($elementdata->emt_depending_value, $formdata['ctrl_' . $elementdata->emt_depending_control.$dynamc_key]))
			{
				$return_valid = TRUE;
			}
		}
		elseif ($elementdata->emt_element_type != 'file')
		{
			$frm_data = '';
			if (isset($formdata['ctrl_' . $elementdata->emt_depending_control.$dynamc_key]))
				$frm_data = $formdata['ctrl_' . $elementdata->emt_depending_control.$dynamc_key];
			if ($elementdata->emt_depending_value == $frm_data)
				$return_valid = TRUE;
		}

		return $return_valid;
	}

    public function force_password_check($user_dets)
    {
        $Clients = new \App\Models\Clients();
        $Login_tracking = new \App\Models\Login_tracking();
        $return_data = array();
        $return_data['redirect_url'] = '';
        //#325 Modification in Force reset password logic
        if (!empty($user_dets)) {
            $is_sudo    =    false;
            if ($user_dets->usr_roles != NULL) {
                $usr_rolArr = json_decode($user_dets->usr_roles, true);
                //check user is sudo
                if (in_array("sudo", $usr_rolArr)) {
                    $is_sudo    =    true;
                }
            }
            //force change password is only for non-sudo users
            if ($is_sudo    ==    false) {

                //to fetch the client force password date
                $client_sett                = $Clients::client_details_with_sett('clnt_usr_force_password_status');

                //date_time or NULL value
                $usr_force_password_status    =    $client_sett[0]->clnt_usr_force_password_status;
                $last_loginfo                = $Login_tracking::get_last_login_info($user_dets->usr_id);

                if (!empty($last_loginfo) && $usr_force_password_status != NULL) {
                    $last_login                =    $last_loginfo[0]->ltk_posted_date;
                    if (strtotime($last_login) < strtotime($usr_force_password_status)) {
                        $return_data['redirect_url']        =    'change-password';
                    }
                }
            }
        }

        return $return_data;
    }


    public function encrypt_data($value)
    {
        $encrypt_val = base64_encode($value);
        return $encrypt_val;
    }
    public function decrypt_data($value)
    {
        $decrypt_val = base64_decode($value);
        return $decrypt_val;
    }
    /* Create a standalone URL.Check if the URL was inside the group. start */
    public function url_first_content()
    {
        $first_part = null;
        $url_arr = array();
        if (isset($_SERVER['HTTP_HOST'])) {
            $url_str = $_SERVER['HTTP_HOST'];
            $url_arr = explode('.', $url_str);
        }
        if (count($url_arr) === 4) {
            $first_part = $url_arr[0];
        }
        return $first_part;
    }
    /* Create a standalone URL.Check if the URL was inside the group. end*/


    //this function return all db roles (role id , role name) as key value pair
    public function set_all_roles_key_value($encrypt_role_id = FALSE, $avoid_system_role = FALSE)
    {

        $user_role_arr = array();

        $condition = array();
        if ($avoid_system_role == TRUE) {
            $condition = "role_assigned_role IS system";
            /* $condition = array(
              'role_assigned_role IS '=> '\'system\''
          );*/
        }

        $all_roles = Roles::get_all_records('role_id,role_name', $condition);
        if (count($all_roles) > 0) {
            foreach ($all_roles as $role) {
                $role_id = $role->role_id;
                if ($encrypt_role_id == TRUE) {
                    $role_id = $this->encrypt_data($role->role_id);
                }

                $user_role_arr[$role_id] = $role->role_name;
            }
        }
        return $user_role_arr;
    }

    /**Function to store the password history of a user
     *  commited date :- 18-03-2022
    Requested type :- POST
     */
   public function update_password_history($new_password, $user_id, $userdata)
    {

        $data = array(
            'pash_usr_id' => $user_id,
            'pash_pwd' => $new_password
        );
        $val = User_password_history::insert_record($data, $userdata);
        ///print_r( $val);exit;
        return  $val;
    }
    /**End of functon to store password history of a user */

    public function convert_to_assoc($tree, $key)
    {
        $assoc_tree = array();
        for ($i = 0; $i < count($tree); $i++) {
            $assoc_tree[$tree[$i]->$key] = $tree[$i];
        }
        return $assoc_tree;
    }

    function have_exit_points($tree, $hay_field)
    {
        foreach ($tree as $stage) {
            if (json_decode($stage->$hay_field) == NULL)
                return TRUE;
        }
        return FALSE;
    }

    /* jourl validate check function */
    public function validate_journal($master_id, $type_id, $type = 'j')
    { //$master_id -> flow master id, $type_id -> article type or journal id

        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $return_arr = array(
            'status' => FALSE
        );
        $return_arr['err_msg'] = array();
        // Task #3022 Remove ‘abstract’ field’ in article submission page
        $remove_abstract_submission=false;
        $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
        if(!empty($proceedingArr)) {
            $remove_abstract_submission=isset($proceedingArr['remove_abstract_submission'])?$proceedingArr['remove_abstract_submission']:false;
        }
        if (!empty($master_id)) {

            //Task #596 Create EIDO configuration and build workflow
            if ($this->current_client->modules->mdl_review_for_doc == 'y') {
                $sql_doc_workflow = 'SELECT COUNT(tb1.jwf_id) AS cnt FROM ' . $generic_flow_table . ' as tb1 WHERE tb1.jwf_fwm_id = ' . $master_id . '  AND  tb1.jwf_stage_type = \'accept\' AND IF(tb1.jwf_child_stages != \'[]\',(SELECT COUNT(tb2.jwf_id) FROM ' . $generic_flow_table . ' as tb2 WHERE tb2.jwf_stage_type = \'document_queue\' AND FIND_IN_SET(tb2.jwf_id,(REPLACE(REPLACE(REPLACE(tb1.jwf_child_stages,\'"\',\'\'),\']\',\'\'),\'[\',\'\'))) ) > 0,FALSE) ';
                $jnl_flow = Generic_flows::get_records_by_raw_query($sql_doc_workflow, TRUE);
            } else {
                if ($this->current_client->modules->mdl_production == 'y') {
                    $stage_type='publish';
                }
                else
                {
                    $stage_type='production';
                }
                $condition = "jwf_stage_type='{$stage_type}' AND jwf_fwm_id={$master_id}";
                $jnl_flow = Generic_flows::get_single_record('count(jwf_id) as cnt', $condition);
            }

            $gen_form_count = 0;
            $custom_form_missing = FALSE;

            if ($this->current_client->modules->mdl_review_for_doc == 'y') {

                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';

                $review_flow  = Config::get($workflow_config);

                $condition = "jwf_fwm_id={$master_id}";
                $stage_generic_form_all = Generic_flows::get_all_records('jwf_forms, jwf_stage_name,jwf_stage_type', $condition);

                foreach ($stage_generic_form_all as $single_stages) {
                    if (isset($review_flow[$single_stages->jwf_stage_type]['generic_form']) && $review_flow[$single_stages->jwf_stage_type]['generic_form'] == 1) {
                        if ($single_stages->jwf_forms == '[]') {
                            $custom_form_missing = TRUE;
                        }
                    }
                }
            }
            $condition = "jwf_stage_type='author_submission' AND jwf_fwm_id={$master_id}";
            $stage_generic_form = Generic_flows::get_single_record('jwf_forms, jwf_stage_name', $condition);

            if (!empty($stage_generic_form)) {
                $gen_form_count = count(json_decode($stage_generic_form->jwf_forms));
            }
            $option_status = FALSE;
            if ($type == 'j') {
                $condition = "jset_jnl_id={$type_id}";
                $option_settings = Journal_settings::get_single_record('*', $condition);
                $art_sub_type = json_decode($option_settings->jset_article_submission_type);
                $paper_length = $option_settings->jset_paper_length;
                $review_method = $option_settings->jset_review_method;
                $file_type = $option_settings->jset_file_type;
            } else {
                $condition = "atotp_artp_id={$type_id}";
                $option_settings = Article_type_advance_options::get_single_record('*', $condition);
                $art_sub_type = (isset($option_settings->atotp_article_submission_type) && $option_settings->atotp_article_submission_type !='') ?json_decode($option_settings->atotp_article_submission_type):[];
                $paper_length = (isset($option_settings->atotp_paper_length) && $option_settings->atotp_paper_length !='')?$option_settings->atotp_paper_length:[];
                $review_method = (isset($option_settings->atotp_review_method)&&($option_settings->atotp_review_method !=''))?$option_settings->atotp_review_method :[];
                $file_type = (isset($option_settings->atotp_file_type) && ($option_settings->atotp_file_type != ''))?$option_settings->atotp_file_type:[];
            }
            // Task #3022 Remove ‘abstract’ field’ in article submission page
            if (($remove_abstract_submission==true || $remove_abstract_submission===false && $paper_length != NULL) && $review_method != "" && ((in_array("fu", $art_sub_type) && $file_type != NULL) || !in_array("fu", $art_sub_type))) {

                $option_status = TRUE;
            }

            if ($jnl_flow->cnt > 0 && $gen_form_count > 0 && $option_status == TRUE && $custom_form_missing == FALSE) {

                $return_arr['status'] = TRUE;
            } else {

                $return_arr['status'] = FALSE;
                if ($type == 'j') {
                    if ($jnl_flow->cnt == 0)
                        $return_arr['err_msg'][] = customTrans('platform_settings.incomplete_journal_flow');

                    if ($gen_form_count == 0 && !empty($stage_generic_form) && $this->current_client->modules->mdl_review_for_doc == 'n')
                        $return_arr['err_msg'][] = str_replace('REPLACE_STAGE_NAME', $stage_generic_form->jwf_stage_name, customTrans('platform_settings.missing_generic_form'));

                    if ($option_status == FALSE)
                        $return_arr['err_msg'][] = customTrans('platform_settings.incomplete_journal_options');
                } else {
                    if ($jnl_flow->cnt == 0)
                        $return_arr['err_msg'][] = customTrans('platform_settings.incomplete_art_type_flow');

                    if ($gen_form_count == 0 && !empty($stage_generic_form) && $this->current_client->modules->mdl_review_for_doc == 'n')
                        $return_arr['err_msg'][] = str_replace('REPLACE_STAGE_NAME', $stage_generic_form->jwf_stage_name, 'missing_art_type_generic_form');

                    if ($option_status == FALSE)
                        $return_arr['err_msg'][] = customTrans('platform_settings.incomplete_art_type_options');
                }
                if (count($return_arr['err_msg']) == 0) {
                    if ($custom_form_missing == TRUE) {
                        $return_arr['err_msg'][] = customTrans('platform_settings.complete_custom_form_doc');
                        $return_arr['status'] = FALSE;
                    } else {
                        $return_arr['status'] = TRUE;
                    }
                }
            }
        }

        return $return_arr;
    }
    /*
Check Role Required function
Request type
type:articletype/platform
id:platform id |Article type id
$edit_user :Edit User id
Role_id:Remove User Role id
*/

    public function check_role_required($type, $id, $edit_user, $removed_list_role_id)
    {
            $condition="role_id={$removed_list_role_id}";
            $temp = Roles::get_single_record('role_assigned_role',$condition);
            if($temp->role_assigned_role == 'author'){
            $role_user_author_count = Article_flow::check_role_required_used_author($type, $id, $edit_user, $removed_list_role_id);
            if ($role_user_author_count && $role_user_author_count['status']) {
                if ($type === 'a') {
                    $reason_suffix = customTrans(':article type');
                } else {
                    $reason_suffix = customTrans(':journal');
                }
                return array(
                    'status' => true,
                    'reason' => $role_user_author_count['reason'] . ' ' . $reason_suffix
                );
            } else {
                return array(
                    'status' => false
                );
            }
        }else {
        $role_user_count = Article_flow::check_role_required_used_article($type, $id, $edit_user, $removed_list_role_id);
        if ($role_user_count && $role_user_count['status']) {
            return array(
                'status' => true,
                'reason' => $role_user_count['reason']
            );
        } else {
            $role_asign_count = User_articles::check_role_assigned_article($type, $id, $edit_user, $removed_list_role_id);
            if ($role_asign_count && $role_asign_count['status']) {
                if ($type === 'a') {
                     $reason_suffix = customTrans(':article type');
                } else {
                   $reason_suffix = customTrans(':journal');
                }
                return array(
                    'status' => true,
                    'reason' => $role_asign_count['reason']
                );
            }
            else{
            return array(
                'status' => false
            );
        }
        }
    }
    }
    public function manage_advance_flow_movement_entries(string $old_fwm_id = NULL, $new_fwm_id, $old_new_id_arr)
    {


        $trans_flag = FALSE;
        $advance_flow_movement_table = (new \App\Models\Advance_flow_movement())->getTable();
        /*if(!isset(Advance_flow_movement::$db_trans))
    {
        $trans_flag = TRUE;
        Advance_flow_movement::trans_start();
    }*/
        //only journal xml import time old_fwm_id will be null
        if ($old_fwm_id != NULL) {
            $current_user = 1;
            $sql = 'Insert into ' . $advance_flow_movement_table . ' (afm_jwf_id,afm_fwm_id,afm_associated_stage_ids,afm_button_title,afm_button_tooltip,afm_posted_by,afm_posted_date,afm_proxy_id,afm_operation) '
                . 'select  afm_jwf_id,' . $new_fwm_id . ',afm_associated_stage_ids,afm_button_title,afm_button_tooltip,' . $current_user . ',\'' . date('Y-m-d H:i:s') . '\',afm_proxy_id,\'i\'  FROM ' . $advance_flow_movement_table . ' WHERE afm_fwm_id = ' . $old_fwm_id;
            Advance_flow_movement::get_records_by_raw_query($sql);
            //	$this->Advance_flow_movement->add_advance_flow_movement($old_fwm_id, $new_fwm_id, $this->current_user['user_id']);
        }
        $flow_master_id = "afm_fwm_id={$new_fwm_id}";
        $get_adv_flow_moments = Advance_flow_movement::get_all_records('afm_id,afm_jwf_id,afm_associated_stage_ids', $flow_master_id);

        if (count($get_adv_flow_moments) > 0) {
            foreach ($get_adv_flow_moments as $ad_f_mnt) {
                $new_data = array();

                if (isset($old_new_id_arr[$ad_f_mnt->afm_jwf_id]))
                    $new_data['afm_jwf_id'] = $old_new_id_arr[$ad_f_mnt->afm_jwf_id];
                if ($ad_f_mnt->afm_associated_stage_ids != '') {
                    $temp_ids = explode(',', $ad_f_mnt->afm_associated_stage_ids);
                    $tmids = array();
                    foreach ($temp_ids as $tm_id) {
                        if (isset($old_new_id_arr[$tm_id]))
                            $tmids[] = $old_new_id_arr[$tm_id];
                    }

                    if (count($tmids) > 0)
                        $new_data['afm_associated_stage_ids'] = implode(',', $tmids);
                }
                $confition = "afm_id={$ad_f_mnt->afm_id}";
                	Advance_flow_movement::update_record($new_data,$confition);
            }
        }

        if ($trans_flag == TRUE)
            //	Advance_flow_movement::trans_complete();
            return;
    }
    /*
Get Platform Data Based on Platform code
*/
    public function platform_basic_settings_data($platform_code)
    {
        $platform_data = Journal_settings::get_essential_platform_settings($platform_code);
        return $platform_data;
    }

    public function article_type_settings_data($art_type_code, $platform_id = NULL,$art_type_id=NULL)
    {
        $article_type_table = (new \App\Models\Article_types())->getTable();
        $article_advance_type_table = (new \App\Models\Article_type_advance_options())->getTable();
        // $criteria = "artp_abbr_article_type='{$art_type_code}'";
        $criteria = "artp_abbr_article_type = ?"; //TASK #5384 Api for getting unset tab details
        $bindings = [$art_type_code];
        if ($platform_id != NULL){
            //  $criteria .= " AND artp_jnl_id='{$platform_id}'";
            $criteria .= " AND artp_jnl_id = ?"; //TASK #5384 Api for getting unset tab details
            $bindings[] = $platform_id;
        }
        if($art_type_id!=NULL){
            // $criteria .= " AND artp_id='{$art_type_id}'";
            $criteria .= " AND artp_id = ?"; //TASK #5384 Api for getting unset tab details
            $bindings[] = $art_type_id;
        }
        $select = '*';
        $tables = array(
            'main_table' => $article_type_table,
            'join_table' => array(
                $article_advance_type_table => array($article_type_table . '.artp_id', $article_advance_type_table . '.atotp_artp_id', "left")
            )
        );

        // $article_type_details = Article_types::get_results_using_joins($tables, $select, $criteria, 'single');
        $article_type_details = Article_types::get_results_using_joins($tables, $select, $criteria, 'single',binding_arr:[$bindings]); //TASK #5384 Api for getting unset tab details
        return $article_type_details;
    }

    public function addDireactory($path,$usedisk = false,$mode = 0755, $recursive = false)
    {
        if ($usedisk  === true) {
            if (!File::exists($path)) {
                return File::makeDirectory($path, $mode, $recursive);
            }
        }
        else {
            if (!Storage::exists($path)) 
            {
                if ($this->current_client->enable_upload_s3_bucket == 'y') {
                    $response = Storage::makeDirectory($path);
                    $response = Storage::disk('s3')->put($path, '');
                }
                else
                {
                    $response = Storage::makeDirectory($path);
                }
            }
        }       
    }
    public function get_upload_data($path, $upload_folder = FALSE, $name = NULL, $option = 'asset')
    {
        if ($this->current_client->enable_upload_s3_bucket == 'y') {
            //$uploaded = Storage::disk('s3')->url('uploads/' . $path);
            $general_config= Config::get('general_config');
            $s3_bucket_access_time = $general_config['s3_bucket_access_time'];
            $uploaded = Storage::disk('s3')->temporaryUrl('uploads/' . $path, now()->addHours($s3_bucket_access_time));
        } else {
            $file_path = Config::get('general_config.file_retrieval')['file_path'];
            if ($option == 'asset') {
                $uploaded = asset($file_path . '/' . $path . '/' . $name);
            }
            elseif ($option == 'public') {
                if ($upload_folder == TRUE)
                    $uploaded = public_path($path);
                else
                    $uploaded = public_path($file_path . '/' . $path . '/' . $name);
            }
        }
        return $uploaded;
    }
    public function get_upload_path($path, $abspath = false, $option = 'storage',$local_location = FALSE)
    {
        if ($this->current_client->enable_upload_s3_bucket == 'y' && $local_location == FALSE) {
            $general_config= Config::get('general_config');
            $s3_bucket_access_time = $general_config['s3_bucket_access_time'];
            $fullpath = Storage::disk('s3')->temporaryUrl($path, now()->addHours($s3_bucket_access_time));
        } else {
            $file_path = Config::get('general_config.file_retrieval')['file_path'];
            if ($abspath == TRUE) {
                $path = str_starts_with($path, "uploads/") ? substr($path, 8) : $path;
                $fullpath = public_path() . $file_path . '/' . $path;
            } elseif ($option == 'storage') {
                $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
                $fullpath = storage_path() . $file_storage_path . $path;
            } else {
                $public_path = 'public/uploads/';
                $fullpath = $public_path . $path;
            }
        }
        return $fullpath;
    }
    public function upload_folder_path($path, $specific_path = false)
    {
        if ($this->current_client->enable_upload_s3_bucket == 'y') {
            if ($specific_path == true)
            {
                $upload_path = Storage::disk('s3')->put($path, '');
                $upload_path =  $path;
            }
            else {
                //$upload_path = Storage::disk('s3')->url($path);
                $general_config= Config::get('general_config');
                $s3_bucket_access_time = $general_config['s3_bucket_access_time'];
                $upload_path = Storage::disk('s3')->temporaryUrl($path, now()->addHours($s3_bucket_access_time));
            }
        } else {
            if ($specific_path == true) {
                $upload_path = 'uploads/' . $path;
            } else {
                $upload_path = storage_path() . '/app/public/' . $path;
            }
        }

        return $upload_path;
    }

    /*
Get Upload File Handler
*/
    public function upload_file_handler($path, $attachment_file, $name)
    {
        $file_path = Config::get('general_config.file_retrieval')['file_path'];
        $aws=false;
        if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y') {
            $aws=true;
        }


        $fullpath = "uploads" . DIRECTORY_SEPARATOR . $path;
        if ($this->current_client->enable_upload_s3_bucket == 'y') {
            $name = $this->rename_file(public_path() . '/storage/uploads/' . $path . DIRECTORY_SEPARATOR, $name,$aws,$fullpath);
            Storage::disk('public')->putFileAs($fullpath, $attachment_file, $name);

            //$storagePath = Storage::disk('s3')->putFileAs($fullpath, $attachment_file, $name);
            // $src=Storage::disk('public')->url('public/' .$fullpath . DIRECTORY_SEPARATOR . $name);

            // $size=Storage::size($path.DIRECTORY_SEPARATOR.$name);
            //  $size = File::size($path.DIRECTORY_SEPARATOR.$name);
            $size = Storage::size('public/' . $fullpath . DIRECTORY_SEPARATOR . $name);
           //
            Storage::disk('public')->putFileAs($fullpath, $attachment_file, $name);
            $size = Storage::size('public/' . $fullpath . DIRECTORY_SEPARATOR . $name);
            $storagePath = Storage::disk('s3')->putFileAs($fullpath, $attachment_file, $name);
            $size = Storage::disk('s3')->size($fullpath . DIRECTORY_SEPARATOR . $name);
        } else {

            $name = $this->rename_file(public_path() . $file_path . "/" . $path . DIRECTORY_SEPARATOR, $name,$aws,$fullpath);

            Storage::disk('public')->putFileAs($fullpath, $attachment_file, $name);
            $size = Storage::size('public/' . $fullpath . DIRECTORY_SEPARATOR . $name);
        }



        // Storage::disk('public')->putFileAs($fullpath, $attachment_file, $name);
        // Storage::disk('s3')->put($fullpath, file_get_contents($attachment_file),'public');
        //  $src=Storage::disk('s3')->url($fullpath . DIRECTORY_SEPARATOR . $name);
        //$size = Storage::size('public/' . $fullpath . DIRECTORY_SEPARATOR . $name);
        $return_array['name'] = $name;
        $return_array['size'] = $size;
        if ($size == 0)
            $error = true;
        else
            $error = false;
        $return_array['error'] = $error;
        return $return_array;
    }
    public function upload_file_content($name, $content)
    {
        if ($this->current_client->enable_upload_s3_bucket == 'y') {
            Storage::disk('s3')->put($name, $content);
            Storage::disk('public')->put($name, $content);
        } else {
            Storage::disk('public')->put($name, $content);
        }
    }
    public function rename_file($path, $filename, $aws = false,$fullpath=NULL)
    {
        $filename = str_replace(' ', '_', $filename);
        $fnameNoExt = pathinfo($filename, PATHINFO_FILENAME);
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $lcase_ext = strtolower($ext);
        $ucase_ext = strtoupper($ext);
        if ($aws == true) {
            if ($this->fileExistsS3($path, "$fnameNoExt.$lcase_ext",$fullpath) == TRUE || $this->fileExistsS3($path, "$fnameNoExt.$ucase_ext",$fullpath) == TRUE) {
                $fnameNoExt = pathinfo($filename, PATHINFO_FILENAME);
                $ext = pathinfo($filename, PATHINFO_EXTENSION);

                $i = 1;
                while (file_exists($path . "$fnameNoExt($i).$lcase_ext") || file_exists($path . "$fnameNoExt($i).$ucase_ext")) {
                    $i++;
                }
                $changedname = $fnameNoExt . '(' . $i . ').' . $ext;
            } else {
                // $filename = str_replace(' ', '_', $filename);
                return $filename;
            }
        } else {

            if (file_exists($path . DIRECTORY_SEPARATOR . "$fnameNoExt.$lcase_ext") == TRUE || file_exists($path . DIRECTORY_SEPARATOR . "$fnameNoExt.$ucase_ext") == TRUE)
            {
                $fnameNoExt = pathinfo($filename, PATHINFO_FILENAME);
                $ext = pathinfo($filename, PATHINFO_EXTENSION);

                $i = 1;
                while (file_exists($path . "$fnameNoExt($i).$lcase_ext") || file_exists($path . "$fnameNoExt($i).$ucase_ext")) {
                    $i++;
                }
                $changedname = $fnameNoExt . '(' . $i . ').' . $ext;
            }
            else
            {
                // $filename = str_replace(' ', '_', $filename);

                return $filename;
            }
        }

        $changedname = str_replace(' ', '_', $changedname);
        return $changedname;
    }

    public  function fileExistsS3($directoryOnS3, $image, $fullpath = NULL)
    {
        // $directoryOnS3 = Config::get('custom.AWS_PUBLIC_ENDPOINT') . $directoryOnS3;
        // $exists = @getimagesize($directoryOnS3 . $image);
        $filePath = $fullpath . '/' . $image;
        $fileExists = Storage::disk('s3')->exists($filePath);
        if($fileExists){
            // print_r($image . ' file exist');
            return true;
        }else{
            return false;
            // print_r($image . ' file not exist');
        }
    }
    public function file_exist_folder($directory,$filename){
        if ($this->current_client->enable_upload_s3_bucket == 'y') {

            return $this->fileExistsS3($directory,$filename);
        }
        else
        {
            $exist= false;
            if (file_exists($directory . '/' . $filename))
            {
                $exist= true;
            }
            return $exist;

        }
    }
    public function file_size_convert_to_kb($file_size)
    {
        return   $file_size / 1000;
    }

    public function has_tex_files($files)
    {
        $status = FALSE;
        foreach ($files as $file) {
            if (preg_match('/\.tex$/', $file->atmnt_file_name) == TRUE) {
                $status = TRUE;
                break;
            }
        }
        return $status;
    }
    public function get_article_resubmission_no_using_upload_path($attach_upload_path)
    {

        $article_id_frm_upload_path = explode('/', $attach_upload_path);
        $resubmission_no = Articles::get_single_record('art_resubmission_no', "art_id={$article_id_frm_upload_path[2]->art_resubmission_no}");
        return $resubmission_no;
    }
   public  function string_with_comma_separation($str_arr)
    {
        $str = '';
        if (is_array($str_arr) && count($str_arr) > 0) {
            $str = implode(', ', $str_arr);
            $spos = strrpos($str, ',');
            if ($spos != '')
                $str = substr_replace($str, ' and', $spos, 1);
        }

        return $str;
    }
    /* Callback function to replace charachters in the string
@parameter1 - Each character match in the string index 0 holds the character used to match group, index 1 holds value of the text that found using group 1.
*/
    public function replace_latexspecialchars($matchtext)
    {
        return preg_replace_callback(
            "|([\^\%~\\\\#\$%&_\{\}])|",
            function ($match) {
                $map = array(
                    "#" => "\\#",
                    "$" => "\\$",
                    "%" => "\\%",
                    "&" => "\\&",
                    "~" => "\\~{}",
                    "_" => "\\_",
                    "^" => "\\^{}",
                    // "\\"=>"\\textbackslash{}"
                );
                return $map[$match[1]];
            },
            $matchtext

        );
    }
    /* Function to Update Article Pdf Generated Status*/

    public function update_article_pdf_status($art_id, $pdf_status = 'n')
    {
        $this->current_user = $this->get_current_user_details();
        $status = 'failed';
        if (!empty($art_id)) {

            $update = Articles::update_record(array(
                'art_pdf_status' => $pdf_status
            ), "art_id={$art_id}", $this->current_user);
            $status = 'success';
        }

        return $status;
    }
    /*
Function Get Pdf Status Get in
*/
    public function get_article_pdf_status($article_id, $plagiarism_check = FALSE, $current_art_status_id = NULL, $platform_code = NULL,$jnl_code=NULL)
    {
        $identical_attachment_order = TRUE;
        $return_arr = array(
            'status' => TRUE,
            'view_pdf_link' => '',
            'ithenticate_link' => ''
        );
        $jset_date_format = 'dd/mm/yyyy';
        $ithenticate_view = '';
        $ithenticate_view_arr = array();
        $attachmenttable = (new \App\Models\Attachment_files())->getTable();
        $attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
        $article_type_advance = (new \App\Models\Article_type_advance_options())->getTable();
        $article_type_advance_obj = new \App\Models\Article_type_advance_options();
        $article_type_table = (new \App\Models\Article_types)->getTable();;
        $article_flow_table = (new \App\Models\Article_flow)->getTable();
        $article_pdf_table = (new \App\Models\Article_pdf)->getTable();
        $ithenticate_auto_submit_table = (new \App\Models\Ithenticate_autosubmission)->getTable();

        // $article_data = Articles::get_single_record('art_article_upload_path', "art_id={$article_id}");
        $article_data = Articles::get_single_record('art_article_upload_path', "art_id= ?",binding_arr:[$article_id]);

        /* $get_article_rec = $this->Articles->get_single_record('art_status', array(
		  'art_id' => $article_id)); */
        // $where_cnd = ' `pdf_id` = (select max(`pdf_id`) from ' . $article_pdf_table . ' where `pdf_art_id` = ' . $article_id . '  and `pdf_show_status`= \'y\')';
        $where_cnd = ' `pdf_id` = (select max(`pdf_id`) from ' . $article_pdf_table . ' where `pdf_art_id` = ?  and `pdf_show_status`= \'y\')';

        /* $get_pdf_details = $this->Article_pdf->get_single_record('pdf_id,pdf_art_attachement_order,pdf_ith_document_id', $where_cnd); */
        // $get_pdf_details = Article_pdf::get_single_record('*', $where_cnd);
        $get_pdf_details = Article_pdf::get_single_record('*', $where_cnd,binding_arr:[$article_id]);
        //print_r($get_pdf_details->pdf_name);
        //305 TASK Exclude covering letters from composite PDF
        //fetch all attchments of the article in which the document type is not excluded from generating pdf
        $form_select = 'count(*) as cnt';

        // $pdf_review_cnd = "atmnt_art_id={$article_id} AND atmnt_designated_to like '%r%'";
        $pdf_review_cnd = "atmnt_art_id= ? AND atmnt_designated_to like '%r%'";
        if (isset($this->current_client->functionality->cfty_include_short_metadata_file) && $this->current_client->functionality->cfty_include_short_metadata_file == 'y')
        {
            $pdf_review_cnd.= " and atmnt_metadata_file='n'";
        }
        // $set_review_status = Attachment_files::get_single_record($form_select, $pdf_review_cnd);
        $set_review_status = Attachment_files::get_single_record($form_select, $pdf_review_cnd,binding_arr:[$article_id]);


        //if($get_article_rec->art_status != 'n')

        $tables = array(
            'main_table' => $attachmenttable,
            'join_table' => array(
                $attachment_file_description_table => array($attachmenttable . '.atmnt_label', $attachment_file_description_table . '.afdec_id', "inner")
            )
        );
        $condition = '';
        $bind_array = [];
        if ($set_review_status->cnt > 0){
            // $condition = "atmnt_designated_to like '%r%' AND atmnt_art_id={$article_id} AND ";
            $condition = "atmnt_designated_to like '%r%' AND atmnt_art_id= ? AND ";
            $bind_array[] =    $article_id;
        }
        /*	$pdf_review_cndition['atmnt_designated_to like '] = '%"r"%';
			$condition=$pdf_review_cndition;
			$condition['afdec_exclude_file']='y';
			$condition['atmnt_label IS NOT'] = NULL;	*/
        $condition .= " atmnt_label IS NOT NULL AND afdec_exclude_file='y'";
        if (isset($this->current_client->functionality->cfty_include_short_metadata_file) && $this->current_client->functionality->cfty_include_short_metadata_file == 'y')
        {
            $condition.= " and atmnt_metadata_file='n'";
        }
        // $not_exclude_files = Attachment_files::get_results_using_joins($tables, 'atmnt_id,atmnt_file_name', $condition, 'all', 'atmnt_order asc');
        $not_exclude_files = Attachment_files::get_results_using_joins($tables, 'atmnt_id,atmnt_file_name', $condition, 'all', 'atmnt_order asc',binding_arr:$bind_array);
        $not_exclude_order = array();
        $current_order = array();
        $exclude_list = array(
            'zip'
        );
        if (!empty($not_exclude_files) && count($not_exclude_files) > 0) {
            foreach ($not_exclude_files as $val => $key) {
                /*** Bug #1955 - JPR-308 Export includes not accepted file types -  Modification in zip extract﻿ * */
                $ext = pathinfo($key->atmnt_file_name, PATHINFO_EXTENSION);
                if (!in_array($ext, $exclude_list)) {
                    $exclude_order[] = $key->atmnt_id;
                }
            }
        }
        // $pdf_review_cndition = "atmnt_art_id={$article_id}";
        $pdf_review_cndition = "atmnt_art_id= ?";
        if ($set_review_status->cnt > 0)
            $pdf_review_cndition .= " AND atmnt_designated_to like '%r%' ";
        
        if (isset($this->current_client->functionality->cfty_include_short_metadata_file) && $this->current_client->functionality->cfty_include_short_metadata_file == 'y')
        {
            $pdf_review_cndition.= " and atmnt_metadata_file='n'";
        }
        // $all_review_files = Attachment_files::get_all_records('atmnt_id,atmnt_file_name,atmnt_old_label', $pdf_review_cndition, 'atmnt_order');
        $all_review_files = Attachment_files::get_all_records('atmnt_id,atmnt_file_name,atmnt_old_label', $pdf_review_cndition, 'atmnt_order',binding_arr:[$article_id]);
        $chk_filedesc_change =0;
        foreach ($all_review_files as $val => $key) {
            if (!empty($not_exclude_files) && count($not_exclude_files) > 0) {
                if (!in_array($key->atmnt_id, $exclude_order)) {
                    /*** Bug #1955 - JPR-308 Export includes not accepted file types -  Modification in zip extract﻿ **/
                    $ext = pathinfo($key->atmnt_file_name, PATHINFO_EXTENSION);
                    if (!in_array($ext, $exclude_list)) {
                        $current_order[] = $key->atmnt_id;
                    }
                }
            } else {
                /*** Bug #1955 - JPR-308 Export includes not accepted file types -  Modification in zip extract﻿ **/
                $ext = pathinfo($key->atmnt_file_name, PATHINFO_EXTENSION);
                if (!in_array($ext, $exclude_list)) {
                    $current_order[] = $key->atmnt_id;
                }
            }
            if($key->atmnt_old_label != null || $key->atmnt_old_label != '') {
                $chk_filedesc_change++;
            }

        }
        $return_arr['pdf_id'] ='';
        if (!empty($get_pdf_details)) {
            $generated_order = json_decode($get_pdf_details->pdf_art_attachement_order);

            $return_arr['view_pdf_link'] = $this->get_upload_data($article_data->art_article_upload_path, TRUE, $get_pdf_details->pdf_name);



            if (empty($current_order) || $generated_order != $current_order || $chk_filedesc_change > 0) {

                $return_arr['status'] = FALSE;
                $return_arr['view_pdf_link'] = '';
            }
            //for plagiarism checking
            $ithenticate_link = '';
            $return_arr['eulatnc'] = '';
            if ($plagiarism_check == TRUE && $return_arr['status'] == TRUE && $this->is_non_author_privileged_user($article_id,NULL,$jnl_code) == TRUE && $this->current_client->modules->mdl_ithenticate == 'y') {

                $get_artp_sett = Articles::get_single_record('art_artp_id,(select atotp_plagiarism_checking from ' . $article_type_advance . ' where atotp_artp_id = art_artp_id) as plagiarism_checking, (select atotp_ithsubmission_type from ' . $article_type_advance . ' where atotp_artp_id = art_artp_id) as ithsubmission_type, (select artp_jnl_id from ' . $article_type_table . ' where artp_id = art_artp_id) as jnl_id, (select max(aflw_id) from ' . $article_flow_table . ' where aflw_art_id = ' . $article_id . ' and (aflw_status = \'a\' or aflw_status = \'w\' or aflw_status = \'p\') and aflw_parent_flow_id IS NULL ) as artf_flow_id', "art_id= ?",binding_arr:[$article_id]);
                if(!empty($get_artp_sett))
                {
                    $date_format = $this->get_platform_date_format($get_artp_sett->jnl_id);
                    $return_arr['ithsubmission_type'] = $get_artp_sett->ithsubmission_type;

                    $ith_auto_submit_sql = "
                    SELECT `ias_status`, `ias_retry_count`, `pdf_ith_submission_status`, `pdf_ith_submission_message`
                    FROM {$ithenticate_auto_submit_table}
                    LEFT JOIN {$article_pdf_table} ON `pdf_id` = `ias_pdf_id`
                    WHERE `ias_pdf_id` IN (
                        SELECT `pdf_id`
                        FROM {$article_pdf_table}
                        WHERE `pdf_art_id` = ?
                    )";
                    
                    $ith_auto_submission = Ithenticate_autosubmission::get_records_by_raw_query($ith_auto_submit_sql,binding_arr:[$article_id]);

                    $submit_to_ithenticate = FALSE;
                    if (!empty($ith_auto_submission) && ($return_arr['ithsubmission_type'] == 'auto' || $get_pdf_details->pdf_ith_submission_status == 'i')) {
                        $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
                        $ithenticateconfig  = Config::get($ithenticate_config);

                        // Cheking auto-ithentication resubmission limit reached
                    if ($ith_auto_submission[0]->ias_status == 'm' || ($ith_auto_submission[0]->ias_status == 'n' && $ith_auto_submission[0]->ias_retry_count >= $ithenticateconfig['retry_submission_limit']))
                        {
                            // If auto submission status failed
                            if ($ith_auto_submission[0]->pdf_ith_submission_status == 'F' || $ith_auto_submission[0]->pdf_ith_submission_status == 'i' || $ith_auto_submission[0]->ias_status == 'm')
                            {
                                $submit_to_ithenticate = TRUE;
                            }
                        }
                    }
                    if ($submit_to_ithenticate == FALSE && $get_artp_sett->ithsubmission_type == 'auto') {
                        $return_arr['manual_ith_link'] = '<span class="ithenticate" id="pending_ithenticate_report">Generating Similarity Report</span>';
                        //#352 Bug-In article correction it shows "Please upload files in Attach files tab" warning alert while changing the description of the file in attach file tab and click on continue
                        if (isset($article_id))
                            //$return_arr['manual_ith_link']  .='<input type="hidden" id="hdn_art_id" name="attachment[art_hdn_id]" value="'.encrypt_data($article_id).'">';

                            if (isset($get_artp_sett->art_artp_id))
                                $return_arr['manual_ith_link']  .= '<input type="hidden" id="hdn_artp_id" name="attachment[hdn_artp_id]" value="' . $get_artp_sett->art_artp_id . '">';
                    }
                    if (isset($get_artp_sett->artf_flow_id) && $get_artp_sett->artf_flow_id!='' && $get_artp_sett->artf_flow_id!=NULL && $current_art_status_id == NULL)
                    {
                        $current_art_status_id = $get_artp_sett->artf_flow_id;
                    }

                    $ithenticate_permission = 'n';
                    if ($current_art_status_id != NULL) {
                        $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
                        $get_jnl_flow = Article_flow::get_single_record('(select jwf_enable_ithenticate from ' . $Generic_flows_table . ' where jwf_id = aflw_jwf_id) as jnl_flow_ithenticate_status', "aflw_id={$current_art_status_id}");
                        if(!empty($get_jnl_flow))
                            $ithenticate_permission = $get_jnl_flow->jnl_flow_ithenticate_status;
                    }
                    
                 if (!empty($get_pdf_details->pdf_ith_document_id)) { //for view link
                    if ($get_artp_sett->plagiarism_checking == 'y') {
                        /*
						 * get pdf details to show preview link
						 */
                        $ith_api_condition = array(
							'acrd_clnt_id' => $this->current_client->clnt_id,
							'acrd_api_name' => 'ithenticate',
							'acrd_artp_id' => $get_artp_sett->art_artp_id,
							'acrd_jnl_id' => $get_artp_sett->jnl_id
						);
                       $sid = $this->login_ithenticate($ith_api_condition);
                        if (empty($get_pdf_details->pdf_ith_view_only_url)) {
                            $similarity_report = $this->similarity_report($get_pdf_details->pdf_ith_document_id, $sid, $ith_api_condition,$get_artp_sett->art_artp_id);
                            if (isset($similarity_report['is_pending']) && $similarity_report['is_pending'] == TRUE) {
                                $ithenticate_link =false;
                                $ithenticate_view = ' <span class="ithenticate" id="pending_ithenticate_report">Generating Similarity Report</span>';
                                //#352 Bug-In article correction it shows "Please upload files in Attach files tab" warning alert while changing the description of the file in attach file tab and click on continue
                                if (isset($article_id))
                                    //	$ithenticate_link .= '<input type="hidden" id="hdn_art_id" name="attachment[art_hdn_id]" value="' . encrypt_data($article_id) . '">';

                                    if (isset($get_artp_sett->art_artp_id))
                                        $ithenticate_link .= '<input type="hidden" id="hdn_artp_id" name="attachment[hdn_artp_id]" value="' . $get_artp_sett->art_artp_id . '">';
                            } else {
                                /* #222 Show posted date for each Ithenticate generated report */
                                $pdf_posted_date    =    $get_pdf_details->pdf_posted_date;
                                if ($get_pdf_details->pdf_ith_report_date != NULL) {
                                    $pdf_posted_date    =    $get_pdf_details->pdf_ith_report_date;
                                }
                                $ithenticate_link =false;
                                $pdf_ith_sub_date    =    ' as on ' . date($date_format . ' h:i:s A', strtotime($pdf_posted_date));

                                $ithenticate_view = true;
                                $ithenticate_view_arr = array(
                                    'word'=> $get_pdf_details->pdf_word_count,
                                    'url'=>URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_code . '/show-similarity-report/' . $this->encrypt_data($get_pdf_details->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($get_artp_sett->jnl_id),
                                    'percentage'=>$get_pdf_details->pdf_ith_similarity_percentage,
                                    'on_date' => $pdf_ith_sub_date
                                );
                            }
                        } elseif (!empty($get_pdf_details->pdf_ith_view_only_url)) {
                            /* #222 Show posted date for each Ithenticate generated report */
                            $pdf_posted_date    =    $get_pdf_details->pdf_posted_date;
                            if ($get_pdf_details->pdf_ith_report_date != NULL) {
                                $pdf_posted_date    =    $get_pdf_details->pdf_ith_report_date;
                            }
                            $ithenticate_link =false;
                            $pdf_ith_sub_date    =    ' as on ' . date($date_format . ' h:i:s A', strtotime($pdf_posted_date));

                            // $ithenticate_view = ' ( Words: ' . $get_pdf_details->pdf_word_count . ' ) | <a class="ithenticate" target="#" id="view_ithenticate_report" href="' . URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_code . '/show-similarity-report/' . $this->encrypt_data($get_pdf_details->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($get_artp_sett->jnl_id) . '" >View Similarity Report (' . $get_pdf_details->pdf_ith_similarity_percentage . '%)</a>'.$pdf_ith_sub_date;

                            $ithenticate_view = true;
                            $ithenticate_view_arr = array(
                                'word'=> $get_pdf_details->pdf_word_count,
                                'url'=>URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_code . '/show-similarity-report/' . $this->encrypt_data($get_pdf_details->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($get_artp_sett->jnl_id),
                                'percentage'=>$get_pdf_details->pdf_ith_similarity_percentage,
                                'on_date' => $pdf_ith_sub_date
                            );
                        }
                    }
                } elseif ($get_artp_sett->ithsubmission_type == 'manual' && $ithenticate_permission == 'y') { // generate ithenticate link
                    $ithenticate_link =true;
                    $return_arr['pdf_id'] = $get_pdf_details->pdf_id;
                }

                //Task 7850  iThenticate v2 enhancement
                if (isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y' && ($ithenticate_link == true || $get_pdf_details->pdf_ith_version == 'v1'))
                {
                    $ithv2url = $sid = null;
                    $ith_api_condition = array(
                        'acrd_clnt_id' => $this->current_client->clnt_id,
                        'acrd_api_name' => 'ithenticate',
                        'acrd_artp_id' => $get_artp_sett->art_artp_id,
                        'acrd_jnl_id' => $get_artp_sett->jnl_id
                    );
                    $credential = $this->get_credentials($ith_api_condition);
                    $acrd_eula = null;
                    if(isset($credential['details']))
                    {
                        if($credential['details']['acrd_eula'] == null)
                        {
                            $acrd_eula = $this->setEULA($credential,true,$credential['details']['acrd_id']);
                        }
                        else
                        {
                            $acrd_eula = $credential['details']['acrd_eula'];
                        }
                    }
                    if(isset($credential['password']) && $acrd_eula == 'y')
                    {
                        $ithv2url = $credential['username'];
                        $sid = $credential['password'];
                        $currentuser = $this->get_current_user_details();
                        $return_arr['eulatnc'] = $this->geteulaTNC($ithv2url,$sid,$currentuser['user_id']);
                    }
                }
                
            }
            }
            $return_arr['ithenticate_link'] = $ithenticate_link;
            $return_arr['ithenticate_view'] = $ithenticate_view;
            $return_arr['ithenticate_view_arr'] = $ithenticate_view_arr;
        } else {
            $return_arr['status'] = FALSE;
        }


        return $return_arr;
    }

    /*
Non Previleged Author Function
*/

    public function is_non_author_privileged_user($article_id, $privileged_user = NULL, $jnl_code = NULL)
    {
        $this->current_user = $this->get_current_user_details();
        $privileged_user = $privileged_user === NULL ? $this->has_journal_privilege($jnl_code, $this->current_user['user_id']) : $privileged_user;
        $Authors = new \App\Models\Authors;
        $article_author_details = $Authors::get_single_record('count(auth_id) as cnt', 'auth_art_id= ? AND auth_usr_id=' . $this->current_user['user_id'],binding_arr:[$article_id]);
        if ($article_author_details->cnt == 0 && $privileged_user == TRUE) {
            return TRUE;
        }
        return FALSE;
    }
    public function curl_intialize($url, $parameters, $header)
    {

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($parameters),
            CURLOPT_HTTPHEADER => $header,
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            return $response;
        }
    }
    public function get_uploaded_file_size_config()
    {
        $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
        $client_defaults  = Config::get($client_default);
        $max_file_size_mb = $client_defaults['max_single_size'] . "MB";
        $max_production_single_file_size_in_mb=$client_defaults['max_production_single_file_size'] ."MB";
        $array_file_size = array();
        $array_file_size['max_single_file'] = $this->toByteSize($max_file_size_mb);
        $array_file_size['max_single_file_mb'] = $client_defaults['max_single_size'];
        $array_file_size['max_entire_file'] = $client_defaults['max_enitire_file_size'];
        $array_file_size['max_production_single_file_size'] = $this->toByteSize($max_production_single_file_size_in_mb);
        $array_file_size['max_production_single_file_size_in_mb'] = $client_defaults['max_production_single_file_size'];
        if ($array_file_size['max_single_file'] == '' || $array_file_size['max_entire_file'] == '') {
            $max_file_size_mb = "30MB";
            $array_file_size['max_single_file'] = $this->toByteSize($max_file_size_mb);
            $array_file_size['max_single_file_mb'] = 30;
            $array_file_size['max_entire_file'] = 200;
        }
        // for copy right signed file upload file types
        if (array_key_exists('copyright_file_type', $client_defaults)) {
            $array_file_size['copyright_file_type'] = $client_defaults['copyright_file_type'];
        }

        return $array_file_size;
    }
    //To convert mbt to bytes
    public function toByteSize($p_sFormatted)
    {
        $aUnits = array('B' => 0, 'KB' => 1, 'MB' => 2, 'GB' => 3, 'TB' => 4, 'PB' => 5, 'EB' => 6, 'ZB' => 7, 'YB' => 8);
        $sUnit = strtoupper(trim(substr($p_sFormatted, -2)));
        if (intval($sUnit) !== 0) {
            $sUnit = 'B';
        }
        if (!in_array($sUnit, array_keys($aUnits))) {
            return false;
        }
        $iUnits = trim(substr($p_sFormatted, 0, strlen($p_sFormatted) - 2));
        if (!intval($iUnits) == $iUnits) {
            return false;
        }
        return $iUnits * pow(1024, $aUnits[$sUnit]);
    }

   public function get_user_display_name($array_data, &$is_blinded = false)
    {
        $this->current_user = $this->get_current_user_details();
        $user_id = isset($array_data['user_id']) ? $array_data['user_id'] : '';
        $user_data = user::get_single_record('usr_status,usr_email',"usr_id = {$user_id}");
        /*
        $domain = substr(strrchr($user_data->usr_email, "@"), 1);
        $emailcheck_config= Config::get('emailCheckerConfig');
        $flags = '';
        $emailcheck =false;
        if (in_array($domain, $emailcheck_config['domains'])) {
            $emailcheck=true;
        }*/
        $user_status =  (isset($user_data) && !empty($user_data->usr_status))? $user_data->usr_status:"";
        $journal_id = isset($array_data['journal_id']) ? $array_data['journal_id'] : '';
        $flag = isset($array_data['flag']) ? $array_data['flag'] : TRUE;
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $availability = isset($array_data['availability']) ? $array_data['availability'] : TRUE;
        $unavailable_msg =isset($array_data['unavailable_msg']) ? $array_data['unavailable_msg'] : '';
        $save_coauthor = isset($array_data['save_coauthor']) ? $array_data['save_coauthor'] : FALSE;
        $remove_user = isset($array_data['remove_user']) ? $array_data['remove_user'] : FALSE;
        $source = isset($array_data['source']) ? $array_data['source'] : NULL;
        $salutation = isset($array_data['salutation']) ? $array_data['salutation'] : TRUE;
        $flag_only = isset($array_data['flag_only']) ? $array_data['flag_only'] : FALSE;
        $inactive_user = isset($array_data['inactive_user']) ? $array_data['inactive_user'] : FALSE;
        $fullname_only = isset($array_data['fullname_only']) ? $array_data['fullname_only'] : FALSE;
        $alternate_no = isset($array_data['alternate_no']) ? $array_data['alternate_no'] : NULL;
        $journal_code = isset($array_data['jnl_code']) ? $array_data['jnl_code'] : NULL;
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : NULL;
        $conflict_interest = isset($array_data['conflict_interest']) ? $array_data['conflict_interest'] : NULL;
        $jwf_role_id = $array_data['jwf_role_id'] ?? $array_data['role_id'] ?? null;
        $art_aflw_id = $array_data['aflw_id'] ?? null;
        $specifyjournal=isset($array_data['specifyjournal']) ? $array_data['specifyjournal'] : '';
        $in_notin=isset($array_data['in_notin']) ? $array_data['in_notin'] : '';
        /*Task #80 Implementation of live notification in review3*/
        $push_notify=isset($array_data['push_notify']) ? $array_data['push_notify'] : null;
        //If flag is true return flags also
        $return_array = array();
        $user_name = '';
        $flags = '';
        $user_flags = '';
        $flag_data = array();
        $unregistered_user = FALSE;
        $global_note = '';
        $alternate_text = '';
        if ($alternate_no != NULL) {
            $alternate_text = 'Alt. ' . $alternate_no;
        }
        $return_array['alternative']='';
        $manage_roles = $this->convert_string_array($this->current_user['roles']);
        $titles = $this->UserConfigdata('titles')['titles'];
        $User = new \App\Models\User;
        // $user_data = $User::get_single_record('usr_first_name, usr_middle_name, usr_last_name,usr_title,usr_status', "usr_id={$user_id}");
        /*Task #80 Implementation of live notification in review3*/
        if($push_notify==true)
        {
            $criteria = ['usr_id' =>$user_id];
            $user_data=(new User())->setTable(User::$tbk_table)::get_single_record_with_bind_cond('usr_first_name, usr_middle_name, usr_last_name,usr_title,usr_status',$criteria);
        }
        else
        {
        $user_data = $User::get_single_record('usr_first_name, usr_middle_name, usr_last_name,usr_title,usr_status', "usr_id= ?",binding_arr:[$user_id]);
        }
        $return_array['unregister'] = FALSE;
        $return_array['linkable'] = FALSE;
        $return_array['status'] = $user_status;
        $return_array['remove_user'] = FALSE;
        $return_array['fullname_only'] = FALSE;
        $return_array['publon'] = FALSE;
        $return_array['user_id'] = $user_id;
        $return_array['availability']=$availability;
        $return_array['unavailable_msg']=$unavailable_msg;

        if($article_id && ($user_id || $jwf_role_id || $art_aflw_id)){
        /*Task #80 Implementation of live notification in review3*/    
        if($push_notify==true)
        {
            $is_blinded =  $this->is_custom_blinded(null, $article_id, blinded_user:$user_id);
        }
        else
        {
        $is_blinded =  $this->is_custom_blinded($jwf_role_id, $article_id, blinded_user:$user_id, aflw_id:$art_aflw_id);
        }
        }
        if ($user_data != NULL) {

            if ($salutation == TRUE) {
                $user_name =  (isset($titles[$user_data->usr_title])) ? $titles[$user_data->usr_title] . ' ' : '';
            }

            if ($this->current_client->functionality->cfty_avoid_salutation == 'y') {
                $user_name = '';
            }

            $user_name .= $user_data->usr_first_name;
            if (!empty($user_data->usr_middle_name))
                $user_name .= ' ' . $user_data->usr_middle_name;
            $user_name .= ' ' . $user_data->usr_last_name;

            if ($fullname_only == TRUE) {
                $return_array['fullname_only'] = TRUE;
                $return_array['fullname'] = $is_blinded ? $is_blinded :  $user_name;
            }
        }
        if (($user_data == NULL) && ($remove_user == TRUE)) {
            $remove_reviewer_suggest = new \App\Models\Article_remove_reviewer_suggest;

            // $removeuser_data = $remove_reviewer_suggest::get_single_record('arw_first_name,arw_last_name', "arw_usr_id={$user_id}");
            $removeuser_data = $remove_reviewer_suggest::get_single_record('arw_first_name,arw_last_name', "arw_usr_id= ?",binding_arr:[$user_id]);

            if (isset($removeuser_data) && !(empty($removeuser_data))) {
                $user_name = $removeuser_data->arw_first_name;
                $user_name .= ' ' . $removeuser_data->arw_last_name;
            }
        }

        if ($user_data == NULL && $inactive_user == TRUE) {
            $inactiveusers = new \App\Models\Inactive_users;
            // $legacy_article_inactive_user = $inactiveusers::get_single_record('iact_usr_title, iact_usr_first_name, iact_usr_middle_name, iact_usr_last_name', "iact_usr_id= {$user_id} ");
            $legacy_article_inactive_user = $inactiveusers::get_single_record('iact_usr_title, iact_usr_first_name, iact_usr_middle_name, iact_usr_last_name', "iact_usr_id= ?",binding_arr:[$user_id]);

            if (!empty($legacy_article_inactive_user)) {
                $user_name =  (isset($legacy_article_inactive_user->iact_usr_title)) ? $titles[$legacy_article_inactive_user->iact_usr_title] . ' ' : '';
                $user_name .=  (isset($legacy_article_inactive_user->iact_usr_first_name)) ? $legacy_article_inactive_user->iact_usr_first_name . ' ' : '';
                $user_name .=  (isset($legacy_article_inactive_user->iact_usr_middle_name)) ? $legacy_article_inactive_user->iact_usr_middle_name . ' ' : '';
                $user_name .=  (isset($legacy_article_inactive_user->iact_usr_last_name)) ? $legacy_article_inactive_user->iact_usr_last_name . ' ' : '';
            }
        }

        $user_flag_Arr=array();
        if ($flag == TRUE && $user_id != $this->current_user['user_id']) {
            $super_permission = (isset($manage_roles) && (!empty(array_intersect(array_keys($this->UserConfigdata('managing_roles')['managing_roles']), $manage_roles)))) ? TRUE : FALSE;
            if ($journal_id != ''  || $specifyjournal!='') {
                $user_flag = new \App\Models\User_flags;
                // $user_roles = $this->validate_user_journal($journal_code,$user_id);
                 $user_roles = $this->validate_user_journal($journal_code,$this->current_user['user_id']);
                 /*
                 if($article_id !=''){
                    $article_data = Articles::get_article_data($article_id);
                    $user_roles=$this->validate_user_journal( $article_data->jnl_journal_code,$this->current_user['user_id'],$article_data->artp_id);
                } 
                */  
                $current_userroles = $user_roles['role_id'];
                if($specifyjournal=='')
                $usr_flag_data = $user_flag::get_user_flags($journal_id, $user_id);
                else
                $usr_flag_data = $user_flag::get_user_flags($journal_id, $user_id,$specifyjournal,$in_notin);
                //$usr_flag_data = $user_flag::get_user_flags($journal_id, $user_id);
                if (count($usr_flag_data) > 0) {


                    foreach ($usr_flag_data as $fvalue) {
                        $fvalue->permitted_roles = json_decode($fvalue->flag_role);
                    }
                    foreach ($usr_flag_data as $flag_value) {
                        if(!in_array($flag_value->flag_id, $user_flag_Arr))
                        {
                            $user_flag_Arr[]=$flag_value->flag_id;
                        // the journal flag of a user is not showing for sa/sudo, if sa/sudo is looking at users in journal settings page and the journal flags are not showing.
                        if (count(array_intersect($flag_value->permitted_roles, $current_userroles)) > 0 || $super_permission == true) {
                            $new_fav_icon   =   $this->fav_icon_replace($flag_value->flag_icon);
                            $user_flags .= '<span class="'.$flag_value->flag_prefix.' fa-' . $new_fav_icon . '" style="color:' . $flag_value->flag_color . '" title="' . $flag_value->flag_name . '">&thinsp;</span>';
                        }
                    }
                    }
                }
            }

            $super_array = array(
                'super_admin',
                'sudo'
            );

            // $super_permission = (isset($manage_roles) && (!empty(array_intersect(array_keys($this->UserConfigdata('managing_roles')['managing_roles']), $manage_roles)))) ? TRUE : FALSE;
            if ($super_permission == TRUE || $journal_id != '') {

                $current_userroles = array();
                if ($journal_id != '') {
                    // $user_roles = $this->validate_user_journal($journal_code, $user_id);
                    $user_roles = $this->validate_user_journal($journal_code,$this->current_user['user_id']);
                
                    if($article_id !='' ){  
                        $article_data = Articles::get_article_data($article_id);
                        if(isset($article_data->jnl_journal_code) && isset($article_data->artp_id))
                        $user_roles=$this->validate_user_journal( $article_data->jnl_journal_code,$this->current_user['user_id'],$article_data->artp_id);
                    }  
                    
                    $current_userroles = $user_roles['role_id'];
                }
                $user_global_flag = new \App\Models\User_global_flags;
                // $flag_data = $user_global_flag::get_user_global_flags("ugf_user_id={$user_id}");
                $flag_data = $user_global_flag::get_user_global_flags("ugf_user_id= ?",binding_arr:[$user_id]);
                if (count($flag_data) > 0) {
                    $client_functionality =  $this->get_client_functionalities($this->current_client->clnt_id, $this->current_client->clnt_client_code);
                    $flag_icon_selector = $client_functionality->cfty_flag_icon_selector;
                    //					$flag_icon_selector = $this->Client_functionality->get_single_record('cfty_flag_icon_selector', array(
                    //							'cfty_id' => $this->current_client->modules->mdl_clnt_id))->cfty_flag_icon_selector;
                    $flags .= ' ';
                    foreach ($flag_data as $flag_value) {
                        $flag_roles = json_decode($flag_value->flag_role);
                        // commited for ajo
                        if($flag_roles==null){
                            $flag_roles=$current_userroles;
                        }
                        if(!in_array($flag_value->flag_id, $user_flag_Arr))
                        {
                            $user_flag_Arr[]=$flag_value->flag_id;
                        if ((count(array_intersect($flag_roles, $current_userroles)) > 0) || $super_permission == TRUE) {

                            if ($flag_value->flag_icon != null && $flag_icon_selector == 'y')
                                $icon = $flag_value->flag_icon;
                            else
                                $icon = 'flag';

                            $new_fav_icon   =   $this->fav_icon_replace($icon);
                            $flags .= '<span class="'.$flag_value->flag_prefix.' fa-' . $new_fav_icon . '" style="color:' . $flag_value->flag_color . '" title="' . $flag_value->flag_name . '">&thinsp;</span>';
                        }
                    }
                    }
                }
                /*
                if($emailcheck===true)
                $flags .= "<span className='s-issue bg-green' title='Personal email'>E </span>";
                */
            }
        }

        if ($flags == '' && $user_flags != '')
            $user_flags = ' ' . $user_flags;

        //		if ($this->has_journal_privilege() user_id== TRUE || in_array('super_admin', $this->current_user['roles']) || in_array('sudo','roles']))

        //BUG#289 User popup link missing in My Tasks (user before entering a article)
        $privillaged_user = FALSE;
        if ($journal_id != '') {
            $temp_jrnl_code        =    NULL;

            // $temp_jrnl            =    Journals::get_single_record('jnl_journal_code', "jnl_id={$journal_id}");
            $temp_jrnl            =    Journals::get_single_record('jnl_journal_code', "jnl_id= ?",binding_arr:[$journal_id]);
            if (!empty($temp_jrnl)) {
                $temp_jrnl_code        =    $temp_jrnl->jnl_journal_code;
            }

            $privillaged_user = $this->has_journal_privilege($temp_jrnl_code,$this->current_user['user_id'],$artp_id);

        }

        if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' && !empty($article_id))
        {
            if($this->check_user_as_reviewer_version($article_id, $this->current_user['user_id'] ) == true)
            {
                $privillaged_user = false;
            }
        }

        if ($privillaged_user == TRUE || (!empty($manage_roles) && !empty(array_intersect(array_keys($this->UserConfigdata('managing_roles')['managing_roles']), $manage_roles)))) {
            $is_viewable = TRUE;
            if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y' && $privillaged_user == TRUE && $article_id != '') {
                /*$this->load->model(array(
					'Articles',
					'journals/article_types/Article_types',
					'journals/Journals'));
				$article_details = $this->Articles->get_article_data($article_id);
				if (isset($article_details))
					$is_viewable = $this->is_reviewer_privileged_user($article_id, $article_details->artp_fwm_id);
                 */
            }
            if ($is_viewable == TRUE && $article_id != NULL)
                $is_viewable = $this->is_non_author_privileged_user($article_id, $privillaged_user); //no need to user details for  authors
            $unavailable_class = (!$availability) ? 'un-available' : '';
            $unavailable_title = (!$availability) ? 'Unavailable' : '';
            $jnl = '';


            // checking wheather the user is unregistered if user status is n

            if (!empty($user_data) && $user_data->usr_status == 'u') {

                // $criteria = "uur_usr_id={$user_id} AND uur_request_status ='y'";
                $criteria = "uur_usr_id= ? AND uur_request_status ='y'";
                $user_unregister = new \App\Models\User_unregister;
                $unregistered = $user_unregister::get_single_record('count(uur_id) as unreg_count', $criteria,binding_arr:[$user_id]);
                if ($unregistered->unreg_count != 0) {
                    $unregistered_user = TRUE;
                }
            }

            if ($is_viewable == TRUE) {

                if ($unregistered_user == TRUE) {


                    $return_array['unregister'] = TRUE;
                    // return $return_array;
                    // $user_name='<span class="unregistered_usr" title="Unregistered user">'. $user_name .'</span>';
                } else if (($user_data == NULL) && ($remove_user == TRUE)) {
                    // echo $user_name;
                    // $user_name='<span style="color:red;">'. $user_name .'</span>';
                    $return_array['remove_user'] = TRUE;
                } else {

                    //$user_name = '<a href="#" title="' . $unavailable_title . '" class="user_info_doc text-light ' . $unavailable_class . '" data-leg="false" data-key=' . $this->encrypt_data($user_id) . ' data-jnl="' . $jnl . '" data-artid="' . $article_id . '">' . $user_name.$alternate_text . '</a>';
                    $user_name = $user_name;
                }
            }
        }
        //              Task #264 JPR-389 setting global note
        //$global_note= $this->get_global_note_popover($user_id,$journal_id);
        $global_note_val = array();
        if($journal_id!=""){
            $global_note_val = $this->get_global_note_popover($user_id,$journal_id);
        }

        if ($source == 'p') {
            $return_array['publon'] = TRUE;
            //class "publons_logo" is used to count the number of shortlisted publons suggested users
            //$user_name = ' <img title="Suggested by Publons" class="publons_logo" src="' . base_url('/assets/images/publons_logo.png') . '" height="12px"> '.$user_name;
        }
        if ($flag_only == FALSE && $fullname_only == FALSE ) {
            $return_array['linkable'] = $is_blinded ? false :((isset($privillaged_user)&& $privillaged_user == TRUE && ($is_viewable))?TRUE:FALSE);
            $return_array['flagonly'] = $flags . $user_flags. $global_note;
            $user_disp_name = $is_blinded ? $is_blinded : $user_name ;
            $return_array['fullname'] = $user_disp_name;
            $return_array['alternative'] = $alternate_text;
            //return $user_disp_name;
        } else {

            $user_disp_flags =  $flags . $user_flags. $global_note;
            $return_array['flagonly'] = $user_disp_flags;

            //return $user_disp_flags;
        }
        $return_array['conflict_interest']=array();
        $return_array['conflict_interest_flag']=false;
        if($conflict_interest!=NULL)
        {
            if(!empty($conflict_interest))
            {
                $value_interest='';
                foreach ($conflict_interest as $interest) {

                        $value_interest .= "<div>".$interest."</div>";
                    }

                $return_array['conflict_interest']=$value_interest;
                $return_array['conflict_interest_flag']=TRUE;
            }

        }
        $return_array['unavailable_date_flag']=FALSE;
        if($unavailable_msg!=NULL&&(!empty($unavailable_msg)))
        {
            $return_array['unavailable_date_flag']=TRUE;
        }
        $return_array['jnl_id'] = $journal_id;
        $return_array['journal_code'] = $journal_code;
        $return_array['global_note'] = $global_note_val;
        return $return_array;
    }

    //        Task #264 JPR-389 setting global note
    public function get_global_note_popover($user_id,$journal_id)
    {
        //global note starts

        $i            = 0;
        $global_note  = '';
        $global_title = 'Notes';
        $global_title_sin = '';
        $global_note_html = '';
        $global_note_html_sin = '';
        $global_note_html_mul = '';
        $this->current_user = $this->get_current_user_details();
        $criteria = "usnote_user_id = ? AND usnote_global = 'y'";
        $global_note_records = User_note::get_all_records('usnote_id,usnote_title,usnote_content,usnote_to', $criteria,binding_arr:[$user_id]);
        if(isset($user_id) && $user_id!=''   && $journal_id!='' && isset($journal_id))
        {
        $core_role_id = array();
        $condition="usrj_jnl_id  ={$journal_id} AND usrj_usr_id ={$user_id}";
        // $journal_user_sql="SELECT DISTINCT role_name FROM `rvw_user_journals` INNER JOIN `rvw_roles` ON usrj_role_id= role_id WHERE usrj_jnl_id ={$journal_id} AND usrj_usr_id ={$this->current_user['user_id']}";
        $journal_user_sql="SELECT DISTINCT role_name FROM `rvw_user_journals` INNER JOIN `rvw_roles` ON usrj_role_id= role_id WHERE usrj_jnl_id = ? AND usrj_usr_id ={$this->current_user['user_id']}";
        $core_role_ids= Roles::get_records_by_raw_query($journal_user_sql,binding_arr:[$journal_id]);
            foreach ($core_role_ids as $val) {
                $core_role_id[] = $val->role_name;
            }
        }
        $global_note = array();
        if(isset($this->current_client->functionality->cfty_enable_global_user_notes) && $this->current_client->functionality->cfty_enable_global_user_notes == 'y' && isset($global_note_records) && !empty($global_note_records) && $user_id != $this->current_user['user_id'] /*&& $is_viewable == TRUE */)
        {
            foreach($global_note_records as $globl_note_recrd)
            {
                if($globl_note_recrd->usnote_to == NULL)
                {
                    $defult_usr_roles = $this->get_default_user_roles_to_global_notes();
                }
                else
                {
                    $defult_usr = $globl_note_recrd->usnote_to;
                    $role_value = array();
                    $defult_usr_roles_string =implode(',',json_decode($defult_usr));
                    $role_value_sql="SELECT role_name FROM rvw_roles WHERE role_id IN(".$defult_usr_roles_string.") ORDER BY role_name";
                    $role_values= Roles::get_records_by_raw_query($role_value_sql);
                    foreach ($role_values as $val) {

                                $role_value[] = $val->role_name;

                    }
                    $defult_usr_roles=$role_value;
                }

                if((array_intersect($core_role_id,$defult_usr_roles)) || (in_array('super_admin',array_values($core_role_id))) )
                {

                        // $global_title_sin      = $globl_note_recrd->usnote_title;
                        // $global_note_html_sin  = $globl_note_recrd->usnote_content;
                        // $global_note_html_mul .= '<b>'.$globl_note_recrd->usnote_title.'</b><br /> '.$globl_note_recrd->usnote_content.'<br /><hr style="margin-top:4px;margin-bottom:4px;">';
                        // $i++;
                        $global_note[] = [
                            'title' => $globl_note_recrd->usnote_title,
                            'content' => $globl_note_recrd->usnote_content,
                        ];
                }
            }
            // if($i > 1)
            // {
            //     $global_note_html = $global_note_html_mul;
            // }

            // else
            // {
            //     $global_title     = $global_title_sin;
            //     $global_note_html = $global_note_html_sin;
            // }
            // $i_align = 'style="z-index: 1071;"';
            // if (isset($v_align) && $v_align == TRUE)
            //     $i_align = 'style="vertical-align:middle;z-index: 1071;"';
            // if(isset($global_note_html) && !empty($global_note_html))
            // $global_note ='<a class="text-yellow global_note" href="#" data-toggle="tooltip" rel="tooltip" data-placement="top" title="' . $global_title . '" data-content="' . htmlentities($global_note_html) . '"><i '. $i_align .' class="fa fa-comment-dots"></i></a>';
            //  $global_note = '<a class="text-yellow global_note" tabindex="0" data-trigger="hover" data-container="body" data-html="true" data-toggle="popover" data-placement="top" title="' . $global_title . '" data-content="' . htmlentities($global_note_html) . '" style="cursor: default;" ><i '. $i_align .' class="fa fa-comment-dots"></i></a> ';
            // $global_note = '<span class=" text-yellow fa fa-comment-dots"></span>';

        }
        return $global_note;
    }
    public function has_journal_privilege($jnl_code = NULL, $user_id = NULL, $article_type = NULL)
    {
        $return = FALSE;
        $role_used = $this->RolesConfigdata('privileged_user_roles');
        $privileged_roles = $role_used['privileged_user_roles'];
        if ($jnl_code != NULL) {
            $roles = User_to_journals::get_journal_user_roles($user_id, $jnl_code, $article_type);
            if(!empty($roles[0]->role_assigned_roles)){
            $role_array = explode(";", $roles[0]->role_assigned_roles);
            if (!empty(array_intersect($privileged_roles, $role_array)))
            {
                $return = TRUE;
            }
            }
        }
        return $return;
    }


    //Display Article code
    public function get_article_display_code($article_id, $journal_id, $special_issue = FALSE, $is_invited_art = FALSE, $user_artp_roles = NULL,$role_id=NULL)
    {
        //If flag is true return flags also
        $article_code = '';
        $flags = '';

        //bug#2537
        //if role id is not NULL

        if (isset($user_artp_roles) && $user_artp_roles != NULL) {
            //fetch flag icons
            $flags = $this->get_article_flags($article_id, $user_artp_roles);
            $flags = $flags . " ";
        }

        $special_issue_tag = '';
        $invited_art_icon = '';
        $permitted_roles = array();
        $current_userroles = array();
        $art_disp_name = '';

        $Article = new \App\Models\Articles;
        $article_data = $Article::get_single_record('art_artp_id,art_resubmission_after_reject,art_code,art_biorxiv,art_prev_article_id,art_transfer_article,art_delete_status,art_delete_reason','art_id=:art_id',NULL,'',NULL, array("art_id"=>$article_id));
        $return_array = array();
        $return_array['hold'] =FALSE;
        $return_array['hold_reason'] ='';
        if (isset($article_data->art_delete_status) && ($article_data->art_delete_status == 'h')) {
            $Article_types = new \App\Models\Article_types();
            $Journals=new \App\Models\Journals();
            $article_type_data=$Article_types::get_single_record('artp_fwm_id ',"artp_id=:artp_id",NULL,'',NULL, array("artp_id"=>$article_data->art_artp_id));
            $journal_data = $Journals::get_single_record('jnl_journal_code',"jnl_id=:jnl_id",NULL,'',NULL, array("jnl_id"=>$journal_id));
            $article_details = (object) [
                'artp_id' =>$article_data->art_artp_id,
                'art_id' =>$article_id,
                'artp_fwm_id'=>$article_type_data->artp_fwm_id,
                'jnl_journal_code'=>$journal_data->jnl_journal_code,
                'art_artp_id'=>$article_data->art_artp_id
            ];

            $art_previlege=$this->article_privilages($article_details,NULL,$journal_data->jnl_journal_code);
            $hold_status=$this->set_hold_status($art_previlege,$article_details,true);

            $return_array['hold'] =$hold_status;
            $return_array['hold_reason']=$article_data->art_delete_reason;
        }

        $return_array['biorxiv'] = FALSE;
        $return_array['biorxivj2b'] = FALSE;
        $return_array['specialissue'] = FALSE;
        $return_array['isinvited'] = FALSE;
        $return_array['istransfer'] = FALSE;
        $return_array['revisiontag'] = FALSE;
        $return_array['paymenttag'] = FALSE;
        $return_array['payment'] = FALSE;
        $return_array['suspecious'] = FALSE;

        if (!empty($article_data->art_code)) {
            $article_code = $article_data->art_code;
            if ($this->current_client->functionality->cfty_biorxiv == 'y' && $article_data->art_biorxiv == 'y') {
                //$article_code = '<span class="biorxv" title="Submission from bioRxiv">bR</span> ' . $article_code;
                $return_array['biorxiv'] = TRUE;
            }
            if (($this->current_client->functionality->cfty_biorxiv_j2b == 'y' || $this->current_client->functionality->cfty_j2b_along_with_submission == 'y') && $article_data->art_biorxiv == 'b') {
                //$article_code = '<span class="biorxivj2b" title="Submitted to bioRxiv">bRx</span> ' . $article_code;
                $return_array['biorxivj2b'] = TRUE;
            }
            if ($special_issue == TRUE) {
                //$special_issue_tag = '<span class="s-issue bg-purple" title="Special issue">S</span> ';
                $return_array['specialissue'] = TRUE;
            }
            if ($is_invited_art == TRUE) {
                //$invited_art_icon = '<span class="glyphicon glyphicon-bookmark invite-icon" title = "Invited article"></span> ';
                $return_array['isinvited'] = TRUE;
            }
            $transfered_tag = '';
            if ($article_data->art_transfer_article == 'y') {
                //$transfered_tag = '<span class="s-issue bg-purple" title="Transferred article">T</span> ';
                $return_array['istransfer'] = TRUE;
            }
            $revison_tag = '';
            if ($article_data->art_prev_article_id != '' && $article_data->art_transfer_article == 'n') {
                //Customisation #2537 JPR-411get_article_display_code
                $return_array['revisiontag'] = TRUE;
                $badge_text = $article_data->art_resubmission_after_reject == "y" ? "RS" : "R";
                $badge_title = $article_data->art_resubmission_after_reject == "y" ? "Resubmitted version" : "Revised version";
                $return_array['badgetext'] = $badge_text;
                $return_array['badge_title'] = $badge_title;
                // $revison_tag = '<span class="r-revised bg-yellow" title="' . $badge_title . '">' . $badge_text . '</span> ';
            }
            $return_array['flags'] = $flags;
            $return_array['code'] = $article_code;

            //Suspecious activity
            if(isset($role_id) && !empty($role_id) && isset($article_id) && !empty($article_id) && isset($article_data->art_artp_id) && !empty($article_data->art_artp_id))
            {
                $Journal_permission = new \App\Models\Journal_permission();
                $articletype_table = (new \App\Models\Article_types)->getTable();
                $Journal_permission_table = (new \App\Models\Journal_permission)->getTable();
                $select = 'jp_id';
                $where='JSON_SEARCH(jp_suspecious_activity,\'all\','.$role_id.') is NOT NULL AND artp_id='.$article_data->art_artp_id;
                $tables = array(
                    'main_table' =>  $articletype_table,
                    'join_table' => array(
                        $Journal_permission_table => array($Journal_permission_table . '.jp_jpm_id', $articletype_table . '.artp_jpm_id', "join")
                    )
                );
                $option_settings = $Journal_permission::get_results_using_joins($tables, $select, $where, 'single');
                if(!empty($option_settings))
                {
                    $criteria =array(
                        'sup_art_id'=>$article_id,
                        'sus_flag_status'=>'y'
                    );
                    $susp_check = suspecious_activity::get_single_record_with_bind_cond('sup_id',$criteria);
                    if(!empty($susp_check))
                    {
                        $return_array['suspecious'] = true;   
                    }
                }
               
            }

            $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
            $Article_flow_table = (new \App\Models\Article_flow)->getTable();
            $Copyright_table = (new \App\Models\Copyright)->getTable();
            $Copyright_master_table = (new \App\Models\Copyright_master)->getTable();
    $tables = array(
                'main_table' => $Generic_flows_table,
                'join_table' => array(
                    $Article_flow_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id',"inner"),
                    $Copyright_table => array($Copyright_table . '.crt_art_id', $Article_flow_table . '.aflw_art_id', "inner"),
                    $Copyright_master_table => array($Copyright_master_table . '.crtm_id', $Copyright_table . '.crt_crtm_id', "inner")
                                )
            );


            $select = 'aflw_art_id, aflw_status, jwf_stage_type, crtm_payment ,crtm_license_name';
            $where = 'jwf_stage_type IN ("payment", "production","author_submission") AND crtm_payment = "o" AND aflw_art_id=' .$article_id;
            $article_copy_open_status = Generic_flows::get_results_using_joins($tables, $select, $where);
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {

                $art_flw_tbl    =   (new Article_flow())->getTable().' as af';
                $jnl_flw_tbl    =   (new Generic_flows())->getTable().' as jw';
                $pmnt_tbl       =   (new \App\Models\Payment_order())->getTable().' as po';
                $cnd    =   "af.aflw_art_id = ? and jw.jwf_stage_type IN ('author_submission','revision') and jwf_enable_payment = 'y'";
                $binding_arr    =   [$article_id];
                $slct   =   "aflw_id, jwf_stage_type,pmt_ord_id,aflw_status";
                $tables =   [
                    "main_table"    =>  $art_flw_tbl,
                    "join_table"    =>  [
                        $jnl_flw_tbl    =>  ['jw.jwf_id','af.aflw_jwf_id','left'],
                        $pmnt_tbl    =>  ['af.aflw_id','po.pmt_ord_aflw_id','left'],
                    ]
                ];
                $Payment_order_details  =   Article_flow::get_results_using_joins($tables,$slct,$cnd,'single','aflw_id DESC',binding_arr:$binding_arr);
                $return_array['payment_details'] = $Payment_order_details;
            }
           if(count($article_copy_open_status) > 0)
			{
                if(($article_copy_open_status[0]->jwf_stage_type == 'author_submission') && env('VITE_CONFERENCE_PROCEEDINGS') && env('VITE_CONFERENCE_PROCEEDINGS')==true && $article_copy_open_status[0]->crtm_license_name !=''){
                $return_array['paymenttag'] = $article_copy_open_status[0]->crtm_license_name;
                }
				else if(($article_copy_open_status[0]->jwf_stage_type == 'production') || ($article_copy_open_status[0]->jwf_stage_type == 'payment' && $article_copy_open_status[0]->aflw_status != 'c'))
				{
					//$OA_badge = '<span class="oa-status bg-yellow" title="OA payment pending">OA</span> ';
                    $return_array['paymenttag'] = "Inprogress";
				}
				else
				{
                    $return_array['paymenttag'] = "Completed";
					//$OA_badge = '<span class="oa-issue bg-green" title="OA payment completed">OA&#x2713</span> ';
				}
			}

            //bug#2537
            //   $return_array['art_disp_name'] = $article_code;
        }
        $art_code_array = $return_array;
        return $art_code_array;
    }

    public function get_due_date_class($remaining_dates = null)
    {
        $due_date_cls   = '';
        if ($remaining_dates != null && isset($this->current_client->functionality->cfty_enable_duedate_color_coding) && $this->current_client->functionality->cfty_enable_duedate_color_coding == 'y') {
            if ($remaining_dates < 0) {
                $due_date_cls = 'due_date_passed';
            } elseif ($remaining_dates == 0 || $remaining_dates == 1) {
                $due_date_cls = 'due_date_approching';
            }
        }
        return $due_date_cls;
    }

    public function cron_log($cron_respose, $current_date)
    {
        $path = 'logs/cron';
        $file_path = $path . '/publons_' . $current_date . '.json';
        if (!file_exists($path)) {
            mkdir($path, 0765, TRUE);
        }

        if (!file_exists($file_path)) {
            $tempArray = $cron_respose;
        } else {
            $inp = file_get_contents($file_path);
            $tempArray = (array)json_decode($inp);
            array_push($tempArray, $cron_respose);
        }
        $jsonData = json_encode($tempArray);
        file_put_contents($file_path, $jsonData);
    }
    /*
    check user is an author or reviewer for this article at this particular stage.
    $article_data=> basic article and article type data, curr_flw_id=> article flow id of current stage, $specify=> all(returns the end result); author(returns that the current user is whether an author or not); reviewer(same as for reviewer also).
    */
    public function article_privilages($article_data, $curr_flw_id = NULL, $journal_code = NULL, $specify = 'all',$test = FALSE)
    {
        $this->current_user = $this->get_current_user_details();
        $result = array();
        $article_id = $article_data->art_id;
        if ($specify == 'author' || $specify == 'all') {
            $Authors = new \App\Models\Authors;
            /** Identify article author/reviewer/privileged user * */
            $chk_cond="auth_usr_id=:user_id AND auth_art_id=:auth_art_id";
            $chk_arr=array('user_id'=>$this->current_user['user_id'],
                            'auth_art_id'=>$article_id
            );
            $chk_author = $Authors::get_single_record('count(auth_id) as count', $chk_cond,NULL,'',NULL,$chk_arr);
            $proxy_non_privilaged = FALSE;
            $is_author = (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;

            /** * Bug #2275 - IET Feedback changes - A staff member who is also an author cannot interact with their paper in the system, but they can just proxy as another staff member and make changes to it at various stages this way.  ** */

            if (isset($this->current_user['proxy_user_id']) && $this->current_user['proxy_user_id'] != 0 && $is_author == FALSE) {
                $chk_arr=array('user_id'=>$this->current_user['proxy_user_id'],
                            'auth_art_id'=>$article_id
                );
                $chk_author_proxy = $Authors::get_single_record('count(auth_id) as count', $chk_cond,NULL,'',NULL,$chk_arr);
                if ((isset($chk_author_proxy->count) && $chk_author_proxy->count > 0)) {
                    $is_author = TRUE;
                    $proxy_non_privilaged = TRUE;
                }
            }
            if ($specify == 'author') {
                $result['author'] = $is_author;
                $result['proxy_non_privilaged'] = $proxy_non_privilaged;
                return $result;
            }
        }
        $privillaged_user = $is_reviewer = FALSE;

        if ($specify == "reviewer" || ($specify == 'all' && (isset($is_author) && $is_author == FALSE))) {
            $privillaged_user = $this->has_journal_privilege($journal_code, $this->current_user['user_id'], $article_data->artp_id);
            $article_flow_table = (new \App\Models\Article_flow)->getTable();;
            $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
            $tables = array(
                'main_table' => $article_flow_table,
                'join_table' => array(
                    $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "left")
                )
            );
            $reviewer_criteria = "aflw_art_id=:aflw_art_id AND jwf_assignment=:jwf_assignment AND aflw_usr_id=:aflw_usr_id";
            $binding_arr=array(
                'aflw_art_id'=>$article_id,
                'jwf_assignment'=>'invitation',
                'aflw_usr_id'=>$this->current_user['user_id']
            );
            $where_in='';
            if($privillaged_user == TRUE)
            {
                $where_in='aflw_status IN ("i","a")';
                $reviwer_role_count = Article_flow::get_results_using_joins($tables, 'count(aflw_id) as cnt', $reviewer_criteria, 'single',NULL,NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr,$where_in);
            }
            else{
                $reviwer_role_count = Article_flow::get_results_using_joins($tables, 'count(aflw_id) as cnt', $reviewer_criteria, 'single',NULL,NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr);
            }
            $is_reviewer = (isset($reviwer_role_count->cnt) && $reviwer_role_count->cnt > 0) ? TRUE : FALSE;
            /*if($is_reviewer==FALSE)
            {
                $binding_arr=array(
                    'aflw_art_id'=>$article_id,
                    'aflw_usr_id'=>$this->current_user['user_id']
                );
                $reviewer_criteria = "aflw_art_id=:aflw_art_id AND aflw_usr_id=:aflw_usr_id";
                $role_data = Article_flow::get_results_using_joins($tables, 'group_concat(jwf_role_id) as role_ids', $reviewer_criteria, 'single',NULL,NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr,$where_in);
                if(isset($role_data->role_ids) && !empty($role_data->role_ids))
                {
                    $allroles = Roles::get_single_record('group_concat(role_assigned_role) as corerole', "role_id in (".$role_data->role_ids.")");
                    if(isset($allroles->corerole) && !empty($allroles->corerole))
                    {
                        $core_roles = explode(" ",$allroles->corerole);
                       if(in_array("reviewer",$core_roles) && $privillaged_user==FALSE)
                       {
                            $is_reviewer = TRUE;
                       }
                    }
                }
            }*/

        }
        $this->show_msg_review_privilaged = FALSE;
        $user_allocate_article = $this->check_user_allocate($this->current_user['user_id'], $article_id);
        if ($privillaged_user == TRUE) {
            $review_privilaged = $this->is_reviewer_privileged_user($article_id, $article_data->artp_fwm_id, FALSE, NULL, $curr_flw_id,$user_allocate_article);
            $this->show_msg_review_privilaged = $privillaged_user;
            $privillaged_user = $review_privilaged;

            if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' && $privillaged_user == FALSE)
            {
               $is_reviewer =  TRUE;
            }

            //#1843 GigaScience enchancement - Stop blocking curators/editors serving as reviewers
            /*if (isset($this->current_client->clnt_client_code) && $this->current_client->clnt_client_code == 'gigax') {
                //if the user is present in the user_to_article_type  table, then that user has the permission
                $for_roles = array('editor_in_chief', 'staff');
                if (in_array($this->current_user['jnl_user_role'][$journal_code]['core_role'], $for_roles)) {
                    $user_present = $this->does_user_present_in_this_article_type($article_data->artp_id, $this->current_user, $journal_code);
                    $privillaged_user = $user_present;
                }
            }*/
        }
        else {
            $Article_versions_reviewers = new \App\Models\Article_versions_reviewers;
            $articlereview_table = (new \App\Models\Article_versions_reviewers)->getTable();
            $condition1 = ' artvr_user_id = ' . $this->current_user['user_id'];
            $condition1 .= ' AND CASE WHEN artvr_previous_art_ids IS NOT NULL THEN FIND_IN_SET(' . $article_id . ',CONCAT_WS(\',\',artvr_article_id,artvr_previous_art_ids)) > 0 ELSE artvr_article_id = ' . $article_id . ' END';
            $str_sql = 'SELECT count(artvr_id) as cnt FROM ' . $articlereview_table . ' WHERE ' . $condition1;
            $query_result = $Article_versions_reviewers::get_records_by_raw_query($str_sql, TRUE);
            if ($query_result->cnt > 0) {
            $is_reviewer = TRUE;
            }
        }
        if($specify == "reviewer" && $privillaged_user == FALSE)
        {
            $is_reviewer = TRUE;
        }

        $roles = $this->validate_user_journal($journal_code, $this->current_user['user_id']);
        
        #Get overriding prevented over roles
        $client = $this->get_client_details('clnt_client_code')?->clnt_client_code;
        $jwf_id = (new Article_flow())->select(['aflw_jwf_id'])->find($curr_flw_id)?->aflw_jwf_id;
        $role_id = Generic_flows::find($jwf_id)?->jwf_role_id;
        $flow_role = Roles::find($role_id)?->role_assigned_role;
        $prevented_roles = config('clients.'.$client.'.workflow_config.overriding_prevented_over'.env('PLATFORMTYPE'), ['author', 'reviewer']);
        #End of get overriding prevented over roles

        if($this->current_client->modules->mdl_conference == 'y' && in_array('journal_admin', $roles['assigned_roles']) && !in_array($flow_role, $prevented_roles)) {
            $result['reviewer'] = false;
            $result['privilaged'] = true;
            $result['user_allocated'] = false;
            $result['author'] = $is_author ?? false;
            $result['proxy_non_privilaged'] = false;
            return $result;
        }
        if ($specify == "reviewer") {
            $result['reviewer'] = $is_reviewer;
            $result['privilaged'] = $privillaged_user;
            $result['user_allocated'] = $user_allocate_article;
            return $result;
        }
        $article_privilages = array(
            'privilaged' => $privillaged_user,
            'proxy_non_privilaged' => $proxy_non_privilaged,
            'author' => $is_author,
            'reviewer' => $is_reviewer,
            'user_allocated' => $user_allocate_article,
        );
        return $article_privilages;
    }
    // Check user allocate or not in article.
    public function check_user_allocate($user_id, $article_id)
    {
        $User_articles = new \App\Models\User_articles;
        $user_assigned = $User_articles::get_single_record('count(usra_id) as count', "usra_usr_id=:usra_usr_id AND usra_art_id=:usra_art_id",NULL,'',NULL,array('usra_usr_id'=>$user_id,'usra_art_id'=>$article_id));
        if (!empty($user_assigned) && ($user_assigned->count > 0))
            return TRUE;
        else
            return FALSE;
    }

    public function is_reviewer_privileged_user($article_id, $artp_fwm_id = NULL, $completed = FALSE, $artp_id = NULL, $curr_flw_id = NULL,$user_allocation =FALSE)
    {
        $Article_versions_reviewers = new \App\Models\Article_versions_reviewers;
        $articlereview_table = (new \App\Models\Article_versions_reviewers)->getTable();
        $articletype_table = (new \App\Models\Article_types())->getTable();
        $userjournal_table = (new \App\Models\User_to_journals())->getTable();
        $roles_table = (new \App\Models\Roles())->getTable();
        //modified function
        $is_reviewer_privileged = TRUE;
        //$user_allocation = $this->check_user_allocate($this->current_user['user_id'], $article_id);
        $this->current_user=$this->get_current_user_details();
        if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
            $role_used = $this->RolesConfigdata('privileged_user_roles');
            $privleged_roles = $role_used['privileged_user_roles'];
            $satge_assigned = $this->check_stage_assigned_user($article_id, $this->current_user['user_id'], $curr_flw_id);
            $retire_cnd = '';
            if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y' && $user_allocation == FALSE && $satge_assigned == FALSE) {
                $retire_cnd = ' AND usrj_role_retired =\'n\' ';
            }

            $join_str = '';
            $condition_str = '';
            if ($artp_id != NULL) {
                $condition_str = ' usrj_artp_id = ' . $artp_id . ' AND  ';
            } elseif ($artp_fwm_id != NULL) {   
                $join_str = $articletype_table . ',';
                $condition_str = ' artp_fwm_id = ' . $artp_fwm_id . ' AND artp_id = usrj_artp_id AND  ';
            }
            $str_sql = 'SELECT count(usrj_id) as cnt FROM ' . $join_str . $userjournal_table . ',' . $roles_table . ' WHERE ' . $condition_str . ' usrj_role_id = role_id AND role_assigned_role IN (\'' . implode('\',\'', $privleged_roles) . '\') ' . $retire_cnd . ' AND usrj_usr_id = ' . $this->current_user['user_id'];
            $privilaged_reviews = Article_types::get_records_by_raw_query($str_sql, TRUE);
            if ($privilaged_reviews->cnt > 0 && ($artp_fwm_id != NULL || $artp_id != NULL)) {
                $condition = ' artvr_user_id = ' . $this->current_user['user_id'];
                $condition .= ' AND CASE WHEN artvr_previous_art_ids IS NOT NULL THEN FIND_IN_SET(' . $article_id . ',CONCAT_WS(\',\',artvr_article_id,artvr_previous_art_ids)) > 0 ELSE artvr_article_id = ' . $article_id . ' END';
                $str_sql = 'SELECT count(artvr_id) as cnt FROM ' . $articlereview_table . '  WHERE ' . $condition;
                $result =  $Article_versions_reviewers::get_records_by_raw_query($str_sql, TRUE);
                if ($result->cnt > 0) {
                    $is_reviewer_privileged = FALSE;
                }
            } else {
                $is_reviewer_privileged = FALSE;
            }
        }
        return $is_reviewer_privileged;
    }
    //#1843 GigaScience enchancement - Stop blocking curators/editors serving as reviewers
    public function does_user_present_in_this_article_type($art_type_id, $current_user, $journal_code)
    {
        $is_user_present = User_to_journals::get_single_record(
            'usrj_id',
            'usrj_usr_id=' . $current_user['user_id'] . ' and usrj_artp_id=' . $art_type_id . ' AND usrj_role_id=' . $current_user['jnl_user_role'][$journal_code]['role_id']
        );
        if (!empty($is_user_present)) {
            return TRUE;
        }
        return FALSE;
    }

    public function get_article_user_roles($array_data)
    {

        $this->current_user = $this->get_current_user_details();
        $user_roles = isset($array_data['user_roles']) ? $array_data['user_roles'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $roles = isset($array_data['all_roles']) ? $array_data['all_roles'] : array();
        $article_privilages = isset($array_data['article_privilages']) ? $array_data['article_privilages'] : array();
        $jnl_id = isset($array_data['jnl_id']) ? $array_data['jnl_id'] : '';
        $user_id = isset($array_data['user_id']) ? $array_data['user_id'] : '';
        $curr_flow_id = isset($array_data['art_flow_id']) ? $array_data['art_flow_id'] : '';
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : NULL;
        $User_articles = new \App\Models\User_articles;
        $roles = $this->rebuild_array_by_field($roles, 'role_id');
        $userarticletable = ($User_articles)->getTable();
        /* All roles assigned to this article */
        $article_roles = $User_articles::get_all_records('usra_role_id as role_id,usra_usr_id as user_id', 'usra_art_id=?',binding_arr:[$article_id]);
        $user_article_roles = array();
        $article_role_counts = array();
        $user_retired_roles = array();
        $retiredflag = FALSE;
        $this->current_user = $this->get_current_user_details();
        /* Feature #2063 - JPR-214 Retiring an AE/Editor -- View article section */
        if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y') {
            $usra_query = 'SELECT usra_role_id,count(usra_usr_id) as role_count FROM ' . $userarticletable . ' WHERE usra_art_id = ' . $article_id . ' GROUP BY usra_role_id';
            $article_role_counts = $User_articles::get_records_by_raw_query($usra_query);
            $article_role_counts = array_column(json_decode(json_encode($article_role_counts), true), 'role_count', 'usra_role_id');
            //$user_journal_retired_roles = User_to_journals::get_single_record('GROUP_CONCAT(usrj_role_id) as role_ids', "usrj_usr_id='" . $user_id . "' AND usrj_jnl_id='" . $jnl_id . "' AND usrj_role_retired='y'");
            $user_journal_retired_roles = User_to_journals::get_single_record('GROUP_CONCAT(usrj_role_id) as role_ids', "usrj_usr_id=? AND usrj_jnl_id=? AND usrj_role_retired=?",binding_arr:[$user_id,$jnl_id,'y']);
            if (isset($user_journal_retired_roles->role_ids) && $user_journal_retired_roles->role_ids != "") {
                $user_retired_roles = explode(',', $user_journal_retired_roles->role_ids);
            }
            if (isset($article_id) && (isset($user_id) && (!empty($user_retired_roles)))) {
                $stage_assignedflag = $this->check_stage_assigned_user($article_id, $user_id, $curr_flow_id);

                $user_assignedflag = $this->check_user_allocate($this->current_user['user_id'], $article_id);
                if ($stage_assignedflag == TRUE || $user_assignedflag == TRUE) {
                    $retiredflag = TRUE;
                }
            }
        }

        $this->article_assigned_roles = array();
        $this->assigned_user_head = array();
        //$is_author = Articles::get_single_record('count(art_id) as cnt', 'art_id=' . $article_id . ' AND art_submitted_by=' . $this->current_user['user_id']);
        if (!empty($article_roles)) {
            foreach ($article_roles as $ar) {
                $us_role = $roles[$ar->role_id];
                $ar->role_name = $us_role->role_name;
                $user_article_roles[$ar->role_id][] = $ar->user_id;
                $array_data['user_id'] = $ar->user_id;
                $array_data['journal_id'] = $jnl_id;
                $array_data['flag'] = TRUE;
                $array_data['article_id'] = $article_id;
                $array_data['artp_id'] = $artp_id;
                $array_data['role_id'] = $ar->role_id;

                // $array_data['jnl_code'] = $jnlcode;
                $ar->user_name = $this->get_user_display_name($array_data);
                $this->article_assigned_roles[$ar->role_name][] = $ar->user_name;
                $this->assigned_user_head[$ar->user_id]['user_name'] = $ar->user_name;
                $this->assigned_user_head[$ar->user_id]['role'][] = $ar->role_name;
            }
        }


        /* If current user doesnt assigned to user articles, then remove the role from article type roles */
        $art_role = (!empty($user_article_roles)) ? array_keys($user_article_roles) : array();

        if (isset($user_roles['role_id'])) {
            if (count($common_roles = array_intersect($user_roles['role_id'], $art_role)) > 0) {
                foreach ($common_roles as $com) {
                    if (!in_array($this->current_user['user_id'], $user_article_roles[$com])) {
                        $unset_key = array_search($com, $user_roles['role_id']);
                    }
                }
            }

            if (!empty($user_retired_roles) && $retiredflag == FALSE) {
                $user_retired_roles = array_unique($user_retired_roles);
                if (!empty($user_roles['role_id'])) {
                    foreach ($user_roles['role_id'] as $rk => $ro) {
                        if (in_array($ro, $user_retired_roles) && (!isset($article_role_counts[$ro]))) {
                            unset($user_roles['roles'][$rk]);
                            unset($user_roles['assigned_roles'][$rk]);
                            unset($user_roles['role_id_name_list'][$ro]);
                            unset($user_roles['role_id'][$rk]);
                        }
                    }
                }
            }
        }

        if (isset($article_privilages['author']) && $article_privilages['author'] == TRUE) {
            if (count($user_roles['assigned_roles']) > 1) {
                $temp_array = array();
                $unset_key = array_search('author', $user_roles['assigned_roles']);
                if ($user_roles['role_id'][$unset_key]) {

                    $temp_array['roles'] = array($user_roles['roles'][$unset_key]);
                    $temp_array['assigned_roles'] = array($user_roles['assigned_roles'][$unset_key]);
                    $temp_array['role_id_name_list'] = array($user_roles['role_id_name_list'][$user_roles['role_id'][$unset_key]]);
                    $temp_array['role_id'] = array($user_roles['role_id'][$unset_key]);
                    $user_roles = $temp_array;
                }
            }
        }

        if (!isset($article_privilages['author']) && isset($user_roles['assigned_roles'])&&in_array('author', $user_roles['assigned_roles'])) {

            $Authors = new \App\Models\Authors;
            $check_author = $Authors::get_single_record('count(auth_id) as cnt', 'auth_usr_id=' . $this->current_user['user_id'] . '   AND auth_art_id=' . $article_id);
            if ($check_author->cnt == 0) {
                $unset_key = array_search('author', $user_roles['assigned_roles']);
                unset($user_roles['roles'][$unset_key]);
                unset($user_roles['assigned_roles'][$unset_key]);
                unset($user_roles['role_id_name_list'][$user_roles['role_id'][$unset_key]]);
                unset($user_roles['role_id'][$unset_key]);
            }
        }
        return $user_roles;
    }

    public function rebuild_array_by_field($array, $field)
    {
        $new_array = array();
        foreach ($array as $val) {
            $new_array[$val->$field] = $val;
        }
        return $new_array;
    }
    public function convert_string_array($roles)
    {
        if (!is_array($roles)) {
            $manage_roles = explode(',', $roles);
        } else {
            $manage_roles = $roles;
        }
        return $manage_roles;
    }

    function check_stage_assigned_user($article_id = NULL, $user_id = NULL, $curr_flw_id = NULL)
    {
        if ($curr_flw_id != NULL) {
            $stage_assigned = Article_flow::get_single_record('count(aflw_id) as count', 'aflw_usr_id=' . $user_id . ' AND aflw_art_id=' . $article_id . ' AND aflw_id=' . $curr_flw_id);
            if (isset($stage_assigned->count) && ($stage_assigned->count > 0)) {
                return TRUE;
            }
        } else {
            $role_used = $this->RolesConfigdata('privileged_user_roles');
            $privileged_core_roles = $role_used['privileged_user_roles'];
            if (!empty($privileged_core_roles)) {
                $condition = ' aflw_art_id=' . $article_id . ' and aflw_usr_id=' . $user_id . ' and aflw_status= \'a\' and role_assigned_role IN(\'' . implode('\',\'', $privileged_core_roles) . '\')';
            }
            $select = 'count(aflw_id) as flow_count';
            $stage_assignment = Article_flow::get_article_flow_details($select, $condition);

            if (isset($stage_assignment[0]->flow_count) && $stage_assignment[0]->flow_count > 0) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function get_assign_details($user_role, $allocation_user, $art_id, $ReView_roles_arr)
    {
        $assigned_roles = array();
        if (is_array($user_role)) {
            $parent_roles = $user_role;
        } else
            $parent_roles = explode(',', $user_role);

        foreach ($parent_roles as $key => $parent_role) {
            if (!empty($allocation_user)) {
                if (isset($allocation_user[$art_id][$parent_role])) {
                    $assigned_roles['assigned_users_assign'][] = implode(',', $allocation_user[$art_id][$parent_role]);
                } else if (isset($ReView_roles_arr[$parent_role])) {
                    $assigned_roles['assigned_roles_assign'][] = $ReView_roles_arr[$parent_role];
                }
            } else if (isset($ReView_roles_arr[$parent_role])) {
                $assigned_roles['assigned_roles_assign'][] = $ReView_roles_arr[$parent_role];
            }
        }

        return $assigned_roles;
    }
    function date_status($art_stage, $privileged_user_arttype, $core_role)
    {
        $enable_assigned_date = FALSE;
        $enable_accept_date = FALSE;
        $enable_complete_date = FALSE;
        $enable_export_date = FALSE;
        $enable_declined_date = FALSE;
        $completed_date = '';
        $assigned_date = '';
        $accepted_date = '';
        $exp_posted_date = '';
        $declined_date = '';
        $author_arr = array('copyright','pro_revision','proof_reading','revision','transit','resubmission');
        //$art_stage->jwf_stage_type == "copyright"
        if (($core_role == 'author' && in_array($art_stage->jwf_stage_type,$author_arr)) || $core_role != 'author')
        {
            if (($art_stage->aflw_status == 'i' || $art_stage->aflw_status == 'u' || $art_stage->aflw_status == 'p' || $art_stage->aflw_status == 'w')  && isset($art_stage->aflw_assigned_date) && !empty($art_stage->aflw_assigned_date)) {
                $enable_assigned_date = TRUE;
                $assigned_date = $art_stage->aflw_assigned_date;
            }

            if (($art_stage->aflw_status == 'a' || $art_stage->aflw_status == 'c') &&  isset($art_stage->aflw_accepted_date) && !empty($art_stage->aflw_accepted_date) && !isset($art_stage->export_posted_date)) {
                $enable_accept_date = TRUE;
                $accepted_date = $art_stage->aflw_accepted_date;
            }

            if ($art_stage->aflw_status == 'c' && isset($art_stage->aflw_returned_date) && $art_stage->aflw_returned_date && !isset($art_stage->export_posted_date)) {
                $enable_complete_date = TRUE;
                $completed_date = $art_stage->aflw_returned_date;
            }
            if ($art_stage->aflw_status == 'c' && isset($art_stage->export_posted_date) && !empty($art_stage->export_posted_date)) {
                $enable_export_date = TRUE;
                $exp_posted_date = $art_stage->export_posted_date;
            }

            if ($art_stage->aflw_status == 'd' && isset($art_stage->aflw_returned_date) && $art_stage->aflw_returned_date && !isset($art_stage->export_posted_date)) {
                $enable_declined_date = TRUE;
                $declined_date = $art_stage->aflw_returned_date;
            }

        }
        $art_stage->exp_posted_date = $exp_posted_date;
        $art_stage->aflw_accepted_date = $accepted_date;
        $art_stage->aflw_assigned_date = $assigned_date;
        $art_stage->aflw_returned_date = $completed_date;
        $art_stage->declined_date = $declined_date;
        $art_stage->enable_assigned_date = $enable_assigned_date;
        $art_stage->enable_accept_date = $enable_accept_date;
        $art_stage->enable_complete_date = $enable_complete_date;
        $art_stage->enable_export_date = $enable_export_date;
        $art_stage->enable_declined_date = $enable_declined_date;
    }
    public function has_temporary_status_name($status_name, $status_name_formatted = NULL, $art_flw_status = NULL, $temporary_status_name = NULL, $temporary_status_name_formatted = NULL)
    {
        $stage_name_formatted   = '';
        $status_arr             = array('a', 'i', 'u', 'w', 'p');
        if (!empty($temporary_status_name) && in_array($art_flw_status, $status_arr)) {
            $stage_name_formatted = ($temporary_status_name_formatted != NULL) ? $temporary_status_name_formatted : $temporary_status_name;
        } else {
            $stage_name_formatted = ($status_name_formatted != NULL) ? $status_name_formatted : $status_name;
        }
        return $stage_name_formatted;
    }


    public function article_action_buttons($array_data)
    {
        $this->current_user = $this->get_current_user_details();
        $article_privilages = isset($array_data['article_privilages']) ? $array_data['article_privilages'] : array();
        $article_data = isset($array_data['article_data']) ? $array_data['article_data'] : array();
        $article_type_advance = isset($array_data['article_type_advance']) ? $array_data['article_type_advance'] : array();
        $user_roles = isset($array_data['user_roles']) ? $array_data['user_roles'] : array();
        $stage_role = isset($array_data['stage_role']) ? $array_data['stage_role'] : array();
        $review_exists = isset($array_data['review_exists']) ? $array_data['review_exists'] : FALSE;
        $advanced_search = isset($array_data['advanced_search']) ? $array_data['advanced_search'] : FALSE;
        $bulksubmission = isset($array_data['bulksubmission']) ? $array_data['bulksubmission'] : FALSE;
        $jnlcode = isset($array_data['jnlcode']) ? $array_data['jnlcode'] : '';
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $action_buttons = array();
        $i = 0;
       // $this->data['avoid_pdf_reviwer_permission'] = FALSE;
        /* View PDF Button */
        if ($article_data->jwf_assignment == 'invitation' && $article_data->aflw_parent_flow_id != NULL && $article_data->aflw_usr_id == $this->current_user['user_id'] && isset($article_data->article_pdf['pdf_id'])) {

            $link =   URL::to('/') . '/' . $this->current_client->platform_type . '/' . $article_data->jnl_journal_code . '/view-pdf/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($article_data->article_pdf['pdf_id']);

           /* $this->data['view_pdf'] = TRUE;
            $this->data['view_pdf_link'] = $link;
            if ($article_data->aflw_status == 'i') {
                $this->data['avoid_pdf_reviwer_permission'] = TRUE;
            }*/
        }

        $resubmit = FALSE;
        if ($article_data->jwf_stage_type == 'resubmission' && $article_data->aflw_status == 'a') {
            $resubmit = TRUE;
        }
        //$this->data['resubmit'] = $resubmit;

        /* Accept/Reject buttons */
        if ($article_data->aflw_usr_id == $this->current_user['user_id'] && $article_data->aflw_status == 'i' && $article_data->art_status != 't' && $article_privilages['proxy_non_privilaged'] == FALSE) {
            // decline invitation button
           // $this->data['show_invitation'] = TRUE;
            if($article_data->art_stage_submission_method=='b' && $article_data->art_status=='n' && $article_data->jwf_stage_type == 'author_submission')
            {
                $bulksubmission = TRUE;
            }
            /*if ($bulksubmission == TRUE)
                $decl_link = url() . 'journal/' . $article_data->jnl_journal_code . '/decline-invitation?' . $this->encrypt_data('art_flw_id=' . $article_data->aflw_id . '&show_user_terms_condition_modal=hide' . '&bulksubmission=' . $bulksubmission);
            else
                $decl_link = url() . 'journal/' . $jnlcode . '/decline-invitation?' . $this->encrypt_data('art_flw_id=' . $article_data->aflw_id . '&show_user_terms_condition_modal=hide');*/
            if (!isset($this->current_user['insist_view_article'])) {
                $action_buttons[$i]['act'] = 'decline_invitation';
                $action_buttons[$i]['type'] = 'b';
                $action_buttons[$i]['name'] = 'decline_invitation';
                $action_buttons[$i]['class'] = 'btn-danger btn_rev_acp_rej mr-2';
                $action_buttons[$i]['label'] = customTrans('viewarticle.decline_button');
                $action_buttons[$i]['id'] = 'declineinvitation';
                $action_buttons[$i]['title'] = customTrans('viewarticle.decline_title');
                $action_buttons[$i]['data_key'] = 'decline-invitation';
                $action_buttons[$i]['bulksubmission'] = $bulksubmission;
                $action_buttons[$i]['aflw_id'] =  $this->encrypt_data($article_data->aflw_id);
                /*$action_buttons[$i]['attrs'] = array(
                    'id' => 'decline_invitation',
                    'title' => customTrans('viewarticle.decline_title'),
                    'data-key' => $decl_link
                );*/
                $action_buttons[$i]['description'] = $bulksubmission ? customTrans('viewarticle.decline'):customTrans('viewarticle.decline_review');
                $i++;
            }
            // accept invitation button
            //$accpt_data = '#' . $this->encrypt_data($article_data->aflw_id);
            $action_buttons[$i]['act'] = 'accept_invitation';
            $action_buttons[$i]['type'] = 'b';
            $action_buttons[$i]['name'] = 'accept_invitation';
            $action_buttons[$i]['class'] = 'btn-success btn_rev_acp_rej mr-2';
            $action_buttons[$i]['label'] = customTrans('viewarticle.accept_button');
            $action_buttons[$i]['id'] = 'acceptinvitation';
            $action_buttons[$i]['title'] = customTrans('viewarticle.accept_invitation');
            $action_buttons[$i]['data_key'] = 'accept-invitation';
            $action_buttons[$i]['data_button_type'] = 'accept_from_view';
            $action_buttons[$i]['aflw_id'] =  $this->encrypt_data($article_data->aflw_id);
            $action_buttons[$i]['bulksubmission'] = $bulksubmission;
            /*$action_buttons[$i]['attrs'] = array(
                'id' => 'accept_invitation',
                'title' => 'Accept Invitation',
                'data-key' => $accpt_data,
                'data-button-type' => "accept_from_view"
            );*/
            $action_buttons[$i]['description'] = $bulksubmission ? customTrans('viewarticle.accept'):customTrans('viewarticle.accept_review');
            $i++;
        }
        /*check user allocated for role*/
        $user_assigned = User_articles::get_single_record('group_concat(usra_usr_id) as usra_usr_id', 'usra_role_id=' . $article_data->jwf_role_id . ' AND usra_art_id=' . $article_data->art_id);

        /* Checkout article */
        $checkout_mode = FALSE;
        if (($article_data->aflw_status == 'u' && $article_data->jwf_assignment == 'self_service' && $article_data->jwf_stage_type != 'resubmission' && isset($user_roles['role_id']) && in_array($article_data->jwf_role_id, $user_roles['role_id']) && $article_data->art_status != 't' && ($stage_role->role_assigned_role != 'author' || ($stage_role->role_assigned_role == 'author' && $article_data->aflw_usr_id == $this->current_user['user_id'])) && $article_privilages['proxy_non_privilaged'] == FALSE && ($article_privilages['reviewer']== FALSE || ($article_privilages['reviewer'] == TRUE && $article_privilages['user_allocated'] == TRUE)) && $article_privilages['author']== FALSE) && (isset($user_assigned->usra_usr_id) && (!empty($user_assigned->usra_usr_id) && $article_privilages['user_allocated'] == TRUE && in_array($this->current_user['user_id'],explode(',',$user_assigned->usra_usr_id))) || empty($user_assigned->usra_usr_id)) ) {
            $checkout_mode = TRUE;
            $action_buttons[$i]['act'] = 'checkout_article';
            $action_buttons[$i]['type'] = 'b';
            $action_buttons[$i]['name'] = 'move_stage';
            $action_buttons[$i]['class'] = 'btn mr-2 btn-primary';
            $action_buttons[$i]['label'] = 'Start';
            //$action_buttons[$i]['attrs'] = array('data-choice' => 'checkout');
            $action_buttons[$i]['data_choice'] = 'checkout';
            //remove the fature for this client functtionality as suggested by gijo
            //$action_buttons[$i]['confirm_msg'] = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
            //$action_buttons[$i]['description'] = 'Start stage: <br />"'. $article_data->jwf_stage_name .'"';
            $action_buttons[$i]['description'] = "Start stage: '" . $article_data->jwf_stage_name . "'";
            $action_buttons[$i]['stage_name'] = $article_data->jwf_stage_name;
            $action_buttons[$i]['id'] = 'startbutton';
            $i++;
            //$this->data['show_decison_js'] = TRUE;
        }
        $checkdata=$this->check_espermission_access(array('article_id' => $article_data->art_id));
        $has_es_main_doc_permission = false;
        if($checkdata == true)
        {
            $check_arr = array('art_id' => $article_data->art_id,'artp_id' => $article_data->art_artp_id,'role_id' => $array_data['role_id'],'core_role' => null,'article_privillages' => $article_privilages);
            $has_es_main_doc_permission = $this->main_doc_permission($check_arr);
        }
         if($has_es_main_doc_permission == true && !in_array($article_data->aflw_status,['i','d','g']) && $article_data->art_es_document_type !== null)
         {
             $editor_mode = false;
             $active_stage = false;
             $is_cust_form_user = false;
             if($article_data->art_es_document_status == 'y' && $article_data->jwf_stage_type == 'review' && ($article_data->aflw_status == 'a' || $article_data->aflw_status == 'c') && $article_data->aflw_usr_id == $this->current_user['user_id'])
             {
                $is_cust_form_user = true;
             }
             if(in_array($article_data->aflw_status,['a','u']))
             {
                 $editor_mode = true;
                 $active_stage = true;
             }
             if($article_data->aflw_status == 'w' || $article_data->aflw_status == 'p')
             {
                 $criteria = 'aflw_parent_flow_id = '.$article_data->aflw_id;
                 $parent_count = Article_flow::get_single_record('count(aflw_id) as cnt', $criteria);
                 if($parent_count->cnt < $article_data->aflw_stage_min_users)
                 {
                     $editor_mode = true;
                     $active_stage = true;
                 } 
             }
             if($article_data->jwf_stage_type == 'resubmission' && in_array($article_data->aflw_status,['u']))
             {
                 $editor_mode = false;
                 $active_stage = false;
             }
             $action_buttons[$i]['type'] = 'b';
             $action_buttons[$i]['class'] = 'btn-info mr-2';
             $action_buttons[$i]['data_editor_mode'] = $editor_mode;
             $action_buttons[$i]['is_cust_form_user'] = $is_cust_form_user;

             if((((isset($article_type_advance->jp_edit_article_files) && $article_type_advance->jp_edit_article_files != NULL) && count(array_intersect($user_roles['role_id'], json_decode($article_type_advance->jp_edit_article_files))) > 0 && $article_privilages['reviewer'] == false && $article_privilages['author'] == false && ($stage_role->role_assigned_role !== 'author'|| $article_privilages['privilaged'] == true)) || ($article_privilages['author'] == true && $stage_role->role_assigned_role == 'author')) && $active_stage == true)
             {
                 $action_buttons[$i]['act'] = 'launch_in_editor';
                 $action_buttons[$i]['label'] =  customTrans('viewarticle.launch_in_editor');
                 $action_buttons[$i]['id'] = 'lauchineditor';
                 $action_buttons[$i]['description'] = customTrans('viewarticle.editor_document_title');
                 $action_buttons[$i]['name'] = 'launch_in_editor';
             }
             else
             {
                 $action_buttons[$i]['act'] = 'view_document';
                 $action_buttons[$i]['label'] =  customTrans('viewarticle.view_document_btn');
                 $action_buttons[$i]['id'] = 'viewdocument';
                 $action_buttons[$i]['description'] = customTrans('viewarticle.editor_document_title');
                 $action_buttons[$i]['name'] = 'view_document';
             }
             $i++;                   
         }
        /* Start Resubmission */
        if ($article_data->aflw_status == 'u' && $article_data->jwf_stage_type == 'resubmission' && $this->current_user['user_id'] == $article_data->aflw_usr_id) {
            $action_buttons[$i]['act'] = 'resubmit_article';
            $action_buttons[$i]['type'] = 'b';
            $action_buttons[$i]['name'] = 'move_stage';
            $action_buttons[$i]['class'] = 'btn mr-2 btn-primary';
            $action_buttons[$i]['label'] = 'Start ' . $article_data->jwf_status_name;
            /*$action_buttons[$i]['attrs'] = array(
                'data-choice' => 'resubmission'
            );*/
            $action_buttons[$i]['data_choice'] = 'resubmission';
            $action_buttons[$i]['description'] = customTrans('viewarticle.resubmit');
            $i++;
        }

        //Task #5388 EditorSuite integration
        if ($article_data->aflw_status == 'a' && $article_data->jwf_connect_to_es == 'y') {
            //Task #5388 EditorSuite integration
            if (isset($review_flow[$article_data->jwf_stage_type]['connect_to_es']) && $review_flow[$article_data->jwf_stage_type]['connect_to_es'] == TRUE) {
                $action_buttons[$i]['act'] = 'connect_es';
                $action_buttons[$i]['type'] = 'b';
                $action_buttons[$i]['name'] = 'connect_es';
                $action_buttons[$i]['class'] = 'btn mr-2 btn-success';
                $action_buttons[$i]['label'] = 'Open in EditorSute';
                $action_buttons[$i]['description'] = customTrans('viewarticle.connect_to_es');
                $action_buttons[$i]['id'] = 'btnconnectes';
                $action_buttons[$i]['data_aflwid'] = $this->encrypt_data($article_data->aflw_id);
                $action_buttons[$i]['data_artid'] =  $this->encrypt_data($article_data->art_id);
                /*$action_buttons[$i]['attrs'] = array(
                    'id' => 'btn_connect_es',
                    'data-aflwid' => $this->encrypt_data($article_data->aflw_id),
                    'data-artid' => $this->encrypt_data($article_data->art_id),
                );*/
                $i++;
            }
        }

        /* Edit article contents */
        if ($article_privilages['author'] == TRUE && $article_data->aflw_status == 'a') {
            if ($article_data->art_submitted_by == $this->current_user['user_id'] && (in_array($article_data->jwf_stage_type, array(
                'author_submission',
                'resubmission'
            )) || ($article_data->jwf_stage_type == 'revision' && $article_data->jwf_article_editable == TRUE) || ($article_data->art_transfer_status == 'y')) && $article_data->aflw_status == 'a') {
                /*$edit_url = url() . 'journal/' . $jnlcode . '/' . $article_data->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($article_data->art_id);
                if (($article_data->jwf_stage_type == 'revision' || $article_data->jwf_stage_type == 'resubmission') && $stage_role->role_assigned_role == 'author') {
                    $edit_url = url() . 'journal/' . $jnlcode . '/' . $article_data->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($article_data->aflw_id);
                    if (isset($article_data->art_stage_submission_method) && $article_data->art_stage_submission_method == 'b') {
                        $edit_url = url() . 'journal/' . $jnlcode . '/' . $article_data->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($article_data->art_id) . '?' . $this->encrypt_data('current_flow_id=' . $article_data->aflw_id . '&bulksubmission=true');
                    }
                }
                $this->data['article_edit_url'] = $edit_url;*/
                /*if ($article_data->aflw_status != 'c') {
                    $this->data['article_edit_sections'] = TRUE;
                    $this->data['article_edit_mode'] = TRUE;
                }*/
            }
        }

        if ($article_privilages['privilaged'] == TRUE && (isset($article_type_advance->jp_edit_articles) && $article_type_advance->jp_edit_articles != NULL) && (!in_array($article_data->art_status, array(
            'r',
            'c'
        ))) && count(array_intersect(json_decode($article_type_advance->jp_edit_articles), $user_roles['role_id'])) > 0 && $article_data->aflw_parent_flow_id == NULL) {
            //$this->data['article_details_edit_mode'] = TRUE;
        }

        if ($article_privilages['privilaged'] == TRUE && (isset($article_type_advance->jp_edit_articles) && $article_type_advance->jp_edit_articles != NULL) && (!in_array($article_data->art_status, array(
            'r',
            'c'
        ))) && count(array_intersect(json_decode($article_type_advance->jp_edit_articles), $user_roles['role_id'])) > 0 && $article_data->aflw_parent_flow_id == NULL && $checkout_mode == FALSE) {
            //$this->data['article_edit_mode'] = TRUE;
            $edit_article = TRUE;

            $edit_url =  $this->current_client->platform_type . '/' . $jnlcode . '/' . $article_data->artp_abbr_article_type . '/article-correction/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($article_data->aflw_id);
            $this->data['article_edit_url'] = $edit_url;
        }

        if ($article_privilages['privilaged'] == TRUE && $article_data->art_status != 't' && $article_data->art_status != 'c') {
            $article_flow_table = (new \App\Models\Article_flow())->getTable();
            $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
            $artflw_tables = array(
                'main_table' => $article_flow_table,
                'join_table' => array(
                    $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "left")
                )
            );
            $artflw_criteria = "aflw_art_id=$article_data->art_id and jwf_assignment='invitation' and aflw_parent_flow_id IS NULL";
            $review_stage_status = Article_flow::get_results_using_joins($artflw_tables, 'aflw_id,aflw_status', $artflw_criteria, 'single');
            $article_flow = $review_flow[$article_data->jwf_stage_type];

            /* More reviewers */
            if ($article_data->aflw_status == 'a' && isset($article_flow['more_reviewers']) && $article_flow['more_reviewers'] == TRUE && $article_data->aflw_usr_id == $this->current_user['user_id'] && $review_exists == TRUE && (isset($review_stage_status->aflw_status) && $review_stage_status->aflw_status != 'c')) {
                //$this->data['more_review_required'] = TRUE;
                $action_buttons[$i]['act'] = 'more_reviewers';
                $action_buttons[$i]['type'] = 'b';
                $action_buttons[$i]['name'] = 'more_review_required';
                $action_buttons[$i]['class'] = 'btn mr-2 btn-primary';
                $action_buttons[$i]['label'] = 'More reviewers ';
                $action_buttons[$i]['description'] = customTrans('viewarticle.more_review');
                $i++;
            }

            $who_can_invite_cnt = ($article_data->jwf_who_can_invite != '') ? count(array_intersect($user_roles['role_id'], json_decode($article_data->jwf_who_can_invite))) : 1;
            $who_can_asgn_cnt = ($article_data->jwf_parent_user_roles != '') ? count(array_intersect($user_roles['role_id'], json_decode($article_data->jwf_parent_user_roles))) : 1;

            /* Proceed without review */
            if ($article_data->art_status != 't' && $this->current_client->functionality->cfty_proceed_without_review == 'y' && $article_data->jwf_assignment=='invitation' && $article_data->aflw_parent_flow_id == NULL) {
                $curr_stage_child = json_decode($article_data->jwf_child_stages);
                $curr_stage_review_count = Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_parent_flow_id = ' . $article_data->aflw_id . ' and aflw_status = \'c\'');
                if (count($curr_stage_child) == 1 && $article_data->aflw_skip_review == 'n' && $curr_stage_review_count->cnt == 0 && $this->current_client->functionality->cfty_proceed_without_review == 'y' && ($who_can_asgn_cnt || $who_can_invite_cnt > 0) && $article_data->aflw_reopened_min_user_count == 0 && (($article_data->jwf_fwm_id == $article_data->artp_fwm_id))) {

                    $action_buttons[$i]['act'] = 'proceed_without_review';
                    $action_buttons[$i]['type'] = 'b';
                    $action_buttons[$i]['name'] = 'proceed_without_review';
                    $action_buttons[$i]['class'] = 'btn mr-2 btn-primary';
                    $action_buttons[$i]['label'] = 'Proceed without ' . $article_data->jwf_stage_name;
                    $action_buttons[$i]['description'] = customTrans('viewarticle.proceed_without_review');
                    $action_buttons[$i]['id'] = 'proceedwithoutreview';
                    /*$action_buttons[$i]['attrs'] = array(
                        'id' => 'proceed_without_review'
                    );*/
                    $i++;
                }

                /* Proceed to the stage from where review stage made in hold */
                $hold_stages = Article_flow::get_all_records('aflw_id,aflw_stage_min_users,aflw_status,aflw_resume_source_of,aflw_jwf_id, aflw_reopened_stage_min_max_count', 'aflw_status = "h" AND aflw_resume_source_of IS NOT NULL AND aflw_resume_source_of = ' . $article_data->aflw_id);
                if (!empty($hold_stages) && count($hold_stages) > 1) {
                    $reopened_min_max_column = array_column(json_decode(json_encode($hold_stages), TRUE), 'aflw_reopened_stage_min_max_count');
                    $min_array = array();
                    foreach ($reopened_min_max_column as $min_max) {
                        $min_array[] = json_decode($min_max)[0];
                    }
                    $maximum_min_count_index = array_search(max($min_array), $min_array);
                    $hold_stages[0] = $hold_stages[$maximum_min_count_index];
                }
                $hold_stage = isset($hold_stages[0]) ? $hold_stages[0] : array();
                $is_any_submitted_review = FALSE; //check whether atleast 1 submit review in reopen
                // Commented the condition Bug #2046 - Reducing number of required reviewers

                $next_active_stage_exists = Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_status IN ("a","u") AND aflw_art_id = ' . $article_data->art_id . ' AND aflw_parent_flow_id IS NULL');
                if (!empty($hold_stage) && $is_any_submitted_review == FALSE && ($who_can_asgn_cnt || $who_can_invite_cnt > 0) && $next_active_stage_exists->cnt == 0) {
                    $resume_source = Article_flow::get_single_record('aflw_level, aflw_reopened_flow_id, aflw_more_review_skip_status,aflw_jwf_id', 'aflw_id = ' . $hold_stage->aflw_resume_source_of);
                    if ($resume_source->aflw_reopened_flow_id != NULL && $resume_source->aflw_reopened_flow_id != 0) {
                        //for client functionality cfty_resume_current_stage_after_review
                        $return_stage = Generic_flows::get_single_record(
                            'jwf_stage_name,jwf_role_id',
                            'jwf_id=' . $hold_stage->aflw_jwf_id
                        );
                        $proceed_flw_id = $hold_stage->aflw_id;
                        $proceed_stage_name = $return_stage->jwf_stage_name;
                    } else {
                        $get_flow = Generic_flows::get_all_records('jwf_id,jwf_child_stages,jwf_stage_type,jwf_stage_name', 'jwf_fwm_id=' . $article_data->jwf_fwm_id);
                        $workflow = $this->process_flow($get_flow);
                        $get_next_proceed_stage =$this->get_next_stage_reopen($resume_source->aflw_jwf_id, $workflow, $article_data->art_id, $review_flow);
                        $nxt_stage_condition = "aflw_id >='" . $hold_stage->aflw_resume_source_of . "' and aflw_level >='" . $resume_source->aflw_level . "' and aflw_art_id = '" . $article_data->art_id . "' AND aflw_jwf_id ='" . $get_next_proceed_stage . "'";
                        $proceed_stage_flow_id = Article_flow::get_single_record('aflw_id', $nxt_stage_condition);
                        $proceed_flw_id = $proceed_stage_flow_id->aflw_id;
                        $proceed_stage_name = $workflow[$hold_stage->aflw_jwf_id]->jwf_stage_name;
                    }
                    $action_buttons[$i]['act'] = 'proceed_to';
                    $action_buttons[$i]['type'] = 'b';
                    $action_buttons[$i]['name'] = 'return_to';
                    $action_buttons[$i]['class'] = 'btn mr-2 btn-primary return_to_reopen';
                    $action_buttons[$i]['label'] = 'Proceed to ' . $proceed_stage_name;
                    $action_buttons[$i]['description'] = customTrans('viewarticle.proceed_to_next') . ' ' . $proceed_stage_name;
                    $action_buttons[$i]['data_hold'] =  $this->encrypt_data($hold_stage->aflw_id);
                    $action_buttons[$i]['data_article'] = $this->encrypt_data($proceed_flw_id);
                    $action_buttons[$i]['data_choice'] = 'return_to';
                    /*$action_buttons[$i]['attrs'] = array(
                        'data-hold' => $this->encrypt_data($hold_stage->aflw_id),
                        'data-article' => $this->encrypt_data($proceed_flw_id),
                        'data-choice' => 'return_to'
                    );*/
                    $return_to = array(
                        'id' => $proceed_flw_id,
                        'stage' => $proceed_stage_name,
                        'hold_stage' => $hold_stage->aflw_id
                    );
                    $i++;
                }
            }

            if (isset($article_flow['permission']) && $article_data->art_status != 't') {
                /* Rescind article */
                //436 BUG More than one stage is in ready status
                $latest_stage_id = Article_flow::get_single_record('MAX(aflw_id) as aflw_id,aflw_level', "aflw_art_id='" . $article_data->art_id . "' AND aflw_parent_flow_id IS NULL AND aflw_level >='" . $article_data->aflw_level . "'");
                $next_stage_exists = 1;
                if ($latest_stage_id->aflw_id == $article_data->aflw_id || $article_data->aflw_level == $latest_stage_id->aflw_level) {
                    $next_stage_exists = 0;
                }
                $current_stage_parent = json_decode($article_data->jwf_parent_stages);
                $parent_advanced = FALSE;
                if (count($current_stage_parent) == 1) {
                    $check_advanced = Generic_flows::get_single_record('jwf_flow_proceed_type', 'jwf_id=' . $article_data->aflw_jwf_id);
                    if ($check_advanced->jwf_flow_proceed_type == "advance") {
                        $parent_advanced = TRUE;
                    }
                }
                /* Reset article */
                if ((in_array('reset', $article_flow['permission']) === TRUE && (isset($article_type_advance->jp_reset_article) && $article_type_advance->jp_reset_article != NULL) && count(array_intersect($user_roles['role_id'], json_decode($article_type_advance->jp_reset_article))) > 0 && $article_data->aflw_parent_flow_id == NULL && $next_stage_exists == 0 && $article_data->jwf_assignment == 'self_service' && $article_data->aflw_status != 'u' && (($article_data->jwf_stage_type!='production' && $article_data->aflw_status != 'c') || ($article_data->aflw_status != 'c' && $article_data->jwf_stage_type == 'production'))  && ($article_data->jwf_stage_type!='reject' || ($article_data->aflw_status != 'c' && $article_data->jwf_stage_type == 'reject')) )  && $article_privilages['author'] == FALSE)  {
                    //$this->data['show_rescind_reset_popup'] = TRUE;
                    $action_buttons[$i]['act'] = 'reset_article';
                    $action_buttons[$i]['type'] = 'b';
                    $action_buttons[$i]['name'] = 'reset_article';
                    $action_buttons[$i]['class'] = 'btn-warning mr-2';
                    $action_buttons[$i]['label'] = 'Reset stage';
                    $action_buttons[$i]['id'] = 'resetarticle';
                    $action_buttons[$i]['description'] = customTrans('viewarticle.reset');
                    $attrs = array();
                    /* Bug #432  Reset button  Enable and disabled*/
                    if (isset($article_data->aflw_status) && $article_data->aflw_status == 'u') {
                        $checkout_mode = TRUE;
                    }
                    if ($checkout_mode == TRUE) {
                        $attrs['disabled'] = 'disabled';
                    }
                    $action_buttons[$i]['attrs'] = $attrs;
                    $i++;
                }
                /*
                    start ----In initiate production stage, no need to show rescind button
                    But if prev aflw stage of Initiate production is a production stage, then show the rescind button
                */
                $is_prev_prod_flg = false;
                if($article_data->jwf_stage_type == 'qulity_check')
                {
                    $Generic_flows_tbl =    (new \App\Models\Generic_flows())->getTable();
                    $Article_flow_tbl  =    (new \App\Models\Article_flow())->getTable();
                    $slct              =    'jwf_stage_type';
                    $art_flw_tbls = array(
                        'main_table' => $Article_flow_tbl,
                        'join_table' => array(
                                            $Generic_flows_tbl => array($Article_flow_tbl . '.aflw_jwf_id', $Generic_flows_tbl . '.jwf_id')
                                        )
                    );

                    $aflw_lvl_min_1 =  $article_data->aflw_level - 1;
                    $aflw_lvl_condi = 'aflw_art_id = '.$article_data->art_id.' AND aflw_level = '.$aflw_lvl_min_1.' AND aflw_id < '.$article_data->aflw_id;
                    $prev_aflw_stg_res = Article_flow::get_results_using_joins($art_flw_tbls, $slct, $aflw_lvl_condi, 'single');

                    if(!empty($prev_aflw_stg_res)) {
                        if (isset($review_flow[$prev_aflw_stg_res->jwf_stage_type]['stage_for']) && $review_flow[$prev_aflw_stg_res->jwf_stage_type]['stage_for'] == 'manageproduction') {
                            $is_prev_prod_flg = true;
                        }
                    }
                }
                /* end ---- If prev aflw stage of Initiate production is production stage, then show the rescind button */
                /* Reset button condition in production stage */
                $end_stage=array('production','publish');
                if ((((in_array('rescind', $article_flow['permission']) === TRUE && $resubmit == FALSE && (isset($article_type_advance->jp_rescind_article) && $article_type_advance->jp_rescind_article != NULL) && count(array_intersect($user_roles['role_id'], json_decode($article_type_advance->jp_rescind_article))) > 0 && ($article_data->aflw_parent_flow_id == NULL || ($article_data->aflw_usr_id != $this->current_user['user_id'] && $article_data->jwf_assignment == "manual" && $article_data->aflw_parent_flow_id!=null && $article_data->aflw_status == 'a' && $article_data->art_status != 't') || $parent_advanced == TRUE) && ($next_stage_exists == 0 || $parent_advanced == TRUE)) && ((!in_array($article_data->jwf_stage_type, $end_stage) && $article_data->aflw_status != 'c') || ($article_data->aflw_status != 'c' && in_array($article_data->jwf_stage_type, $end_stage))) && ($article_privilages['author'] == FALSE) && ($article_data->art_status!='r'))) || $is_prev_prod_flg == TRUE) {


                    //$this->data['show_rescind_reset_popup'] = TRUE;
                    $action_buttons[$i]['act'] = 'rescind_article';
                    $action_buttons[$i]['type'] = 'b';
                    $action_buttons[$i]['name'] = 'rescind_article';
                    $action_buttons[$i]['class'] = 'btn-danger mr-2';
                    $action_buttons[$i]['label'] = 'Rescind to previous stage';
                    $action_buttons[$i]['description'] = str_replace("stagename", $article_data->jwf_stage_name, customTrans('viewarticle.resc_ind'));
                    //$this->data['show_complete_email_js'] = TRUE;
                    $attrs = array();

                    $i++;
                }
                $who_can_invite_cnt = ($article_data->jwf_who_can_invite != '') ? count(array_intersect($user_roles['role_id'], json_decode($article_data->jwf_who_can_invite))) : 0;
                if($article_data->aflw_usr_id != $this->current_user['user_id'] && $article_data->jwf_assignment == "manual" && $article_data->aflw_parent_flow_id!=null && $article_data->aflw_status == 'a' && $article_data->art_status != 't' && $who_can_asgn_cnt > 0 ) 
                {
                    $action_buttons[$i]['act'] = 'edit_stage_assignment';
                    $action_buttons[$i]['type'] = 'l';
                    $action_buttons[$i]['name'] = 'edit_stage_assignment';
                    $action_buttons[$i]['class'] = 'btn-primary mr-2';
                    $action_buttons[$i]['label'] = 'Edit stage assignment';
                    $action_buttons[$i]['description'] = customTrans('viewarticle.change_stage_assignment');
                    $action_buttons[$i]['id'] = 'edit_stage_assignment';
                    $action_buttons[$i]['parentflow'] =  $this->encrypt_data($article_data->aflw_parent_flow_id);
                    
                    $i++;
                }
                

                #Task 225 JPR-447 Rescind a paper from production to enable licence form to be completed after author requesting changes
                if (isset($this->current_client->functionality->cfty_enable_rescind_request) && $this->current_client->functionality->cfty_enable_rescind_request == 'y') {
                    if ((in_array('rescind', $article_flow['permission']) === TRUE && (isset($article_type_advance->jp_request_rescind) && $article_type_advance->jp_request_rescind != NULL) && count(array_intersect($user_roles['role_id'], json_decode($article_type_advance->jp_request_rescind))) > 0 && $article_data->aflw_parent_flow_id == NULL && $next_stage_exists == 0) && ($article_data->aflw_status == 'c' && $article_data->jwf_stage_type == 'production')) {

                        $Article_rescind_request = new \App\Models\Article_rescind_request;
                        $Article_export_data = new \App\Models\Article_export_data;
                        // $logged_user_role = $this->current_user['jnl_user_role'][$jnlcode];
                        // $core_role = $logged_user_role['core_role']; // print_r($this->current_user);die;
                        $core_role_details  =   Roles::get_single_record('role_assigned_role','role_id = ?',binding_arr:[$stage_role->role_id]);//Task #5093 get core role from table
                        $core_role  =   !empty($core_role_details) ? $core_role_details->role_assigned_role : '';
                        //check whether rescind request accepted or not
                        // $request_status = $Article_rescind_request::get_single_record('rrq_request_status,rrq_aflw_id', 'rrq_art_id=' . $article_data->art_id, 'rrq_id desc');
                        $request_status = $Article_rescind_request::get_single_record('rrq_request_status,rrq_aflw_id', 'rrq_art_id=' . $article_data->art_id,orderby:'rrq_id desc');
                        if (!empty($request_status) && $request_status->rrq_request_status == 'a' &&  $request_status->rrq_aflw_id == $article_data->aflw_id) {
                            $action_buttons[$i]['act'] = 'rescind_article';
                            $action_buttons[$i]['type'] = 'b';
                            $action_buttons[$i]['name'] = 'rescind_article';
                            $action_buttons[$i]['class'] = 'btn-danger mr-2';
                            $action_buttons[$i]['label'] = 'Rescind to previous stage';
                            $action_buttons[$i]['description'] = str_replace("stagename", $article_data->jwf_stage_name, customTrans('viewarticle.resc_ind'));
                        } else {
                            //get the last checkout user
                            // $checkout_user = $Article_export_data::get_single_record('exp_user_id', 'exp_art_id=' . $article_data->art_id, 'exp_id desc');
                            $checkout_user = $Article_export_data::get_single_record('exp_user_id', 'exp_art_id=' . $article_data->art_id,orderby:'exp_id desc');
                            if (($core_role == 'staff' || $core_role == 'journal_admin') && (isset($checkout_user->exp_user_id) && $checkout_user->exp_user_id == $this->current_user['user_id'])) {
                               // $this->data['show_rescind_reset_popup'] = TRUE;
                                $action_buttons[$i]['act'] = 'request_rescind_article';
                                $action_buttons[$i]['type'] = 'b';
                                $action_buttons[$i]['name'] = 'request_rescind_article';
                                $action_buttons[$i]['class'] = 'btn-danger mr-2';
                                $action_buttons[$i]['label'] = 'Request for rescind';
                                $action_buttons[$i]['description'] = 'Sent request to super admin for rescind the article from production';
                            }
                        }
                       //$this->data['show_complete_email_js'] = TRUE;
                        $attrs = array();
                        $i++;
                    }
                }
                if($article_privilages['privilaged'] == true && ($article_privilages['reviewer'] == false || ($article_privilages['reviewer'] == true && $article_privilages['user_allocated'] == true)) && (isset($article_type_advance->jp_change_usr_assigmnts) && $article_type_advance->jp_change_usr_assigmnts != NULL) && count(array_intersect($user_roles['role_id'], json_decode($article_type_advance->jp_change_usr_assigmnts))) > 0)
                {
                //echo '<pre>';print_r($article_type_advance); die;
                $change_assignment = $this->change_assignment_permission($article_data, $user_roles, $review_flow);
                if ($change_assignment == TRUE) {
                   // $this->data['show_complete_email_js'] = TRUE;
                    $action_buttons[$i]['act'] = 'btn_change_assignment';
                    $action_buttons[$i]['type'] = 'b';
                    $action_buttons[$i]['name'] = 'btn_change_assignment';
                    $action_buttons[$i]['class'] = 'btn mr-2 btn-primary';
                    $action_buttons[$i]['label'] = 'Change assignment';
                    $action_buttons[$i]['description'] = customTrans('viewarticle.change_assignment');

                    $action_buttons[$i]['id'] = 'btnchangeassignment';
                    $action_buttons[$i]['data_art'] = $this->encrypt_data($article_data->art_id);
                    $action_buttons[$i]['data_artf_stus'] = $this->encrypt_data($article_data->aflw_id);
                    /*$attrs = array(
                        'id' => 'btn_change_assignment',
                        'data-art' => $this->encrypt_data($article_data->art_id),
                        'data-artf_stus' => $this->encrypt_data($article_data->aflw_id)
                    );*/

                    //$action_buttons[$i]['attrs'] = $attrs;
                    $i++;
                }
                }
                if (isset($article_type_advance->jp_transfer_article) && $article_type_advance->jp_transfer_article != '' && $article_privilages['privilaged'] == true && $article_privilages['author'] == false ) {
                    if ($article_data->jwf_enable_transfer == 'y' && in_array('transfer', $article_flow['permission']) && count(array_intersect(json_decode($article_type_advance->jp_transfer_article), $user_roles['role_id'])) > 0) {
                        $action_buttons[$i]['act'] = 'transfer_article';
                        $action_buttons[$i]['type'] = 'b';
                        $action_buttons[$i]['name'] = 'transfer_article';
                        $action_buttons[$i]['class'] = 'btn-primary trnsfr_artcle mr-2';
                        $action_buttons[$i]['label'] = 'Transfer article';
                        $action_buttons[$i]['description'] = customTrans('viewarticle.transfer');
                        $i++;
                        $this->data['show_transfer_article_popup'] = TRUE;
                    }
                }
            }
        }

        /* Return to search result button */
        if ($this->current_client->functionality->cfty_save_advanced_search_filters == 'y' && $article_privilages['privilaged'] == TRUE && $advanced_search == true) {
            $action_buttons[$i]['act'] = 'return_to_search';
            $action_buttons[$i]['type'] = 'b';
            $action_buttons[$i]['name'] = 'return_to_search';
            $action_buttons[$i]['class'] = 'btn-primary mr-2';
            $action_buttons[$i]['label'] = 'Return to search';
            $action_buttons[$i]['data_choice'] = 'return_search_result';
            $action_buttons[$i]['data_original_title'] = 'Return to search result';
            /*$action_buttons[$i]['attrs'] = array(
                'data-choice' => 'return_search_result', 'data-original-title' => 'Return to search result'
            );*/
            $i++;
        }
        if (isset($article_type_advance->jp_download_review) && $article_type_advance->jp_download_review != '' && count(array_intersect(json_decode($article_type_advance->jp_download_review), $user_roles['role_id'])) > 0 && $article_privilages['privilaged'] == true) {
            //$curr_stage_review_count = Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_parent_flow_id = ' . $article_data->aflw_id . ' and aflw_status = \'c\'');
            $tbl_article_flow = (new \App\Models\Article_flow())->getTable();
            $tbl_generic_flow = (new \App\Models\Generic_flows())->getTable();
            $flw_tables = array(
                'main_table' => $tbl_article_flow,
                'join_table' => array(
                    $tbl_generic_flow => array($tbl_generic_flow . '.jwf_id', $tbl_article_flow . '.aflw_jwf_id', "left")
                )
            );

            $artflw_criteria = "aflw_art_id=$article_data->art_id and jwf_assignment='invitation' and aflw_parent_flow_id IS NULL";
            //DB::enableQueryLog();
            $review_stage_status = Article_flow::get_results_using_joins($flw_tables, 'aflw_id,aflw_status,aflw_stage_min_users', $artflw_criteria);
            $flw_id = array();
            if(!empty($review_stage_status))
            {
                foreach($review_stage_status as $val)
                {
                    $curr_stage_review_count = Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_parent_flow_id = ' . $val->aflw_id . ' and aflw_status = \'c\'');
                    if($curr_stage_review_count->cnt >= $val->aflw_stage_min_users)
                    {
                        $flw_id[] = $val->aflw_id;
                    }
                }
            }
            //$query = DB::getQueryLog();$query = end($query);dd($query);
            if(!empty($flw_id))
            {
                $action_buttons[$i]['act'] = 'download_rw';
                $action_buttons[$i]['type'] = 'b';
                $action_buttons[$i]['name'] = 'download_review';
                $action_buttons[$i]['class'] = 'btn-primary  mr-2';
                $action_buttons[$i]['label'] = 'Download all reviews';
                $i++;
            }
        }

        $jwf_data = Generic_flows::get_single_record_with_bind_cond('jwf_stage_name,jwf_stage_type,jwf_prevent_edit',['jwf_id' => $article_data->aflw_jwf_id]);
        if(isset($review_flow[$jwf_data->jwf_stage_type]) && isset($review_flow[$jwf_data->jwf_stage_type]['prevent_edit']) && $review_flow[$jwf_data->jwf_stage_type]['prevent_edit'] == true && $jwf_data->jwf_prevent_edit == 'y' && $article_data->aflw_status != 'c'){
            $condition = [
                'cusr_action_type' => 'prevent_edit_request_access',
                'cusr_art_id' => $article_data->art_id,
                'cusr_aflw_id' => $article_data->aflw_id,
                'cusr_status' => 'p',
                'cusr_status_change_by' => null
            ];
            $preventEditExist = false;
            $requestExist = Article_custom_reasons::with(['user_articles' => function ($query) use($user_roles) {
                                                        $query->select('usra_usr_id','usra_art_id','usra_role_id')
                                                              ->whereIn('usra_role_id',$user_roles['role_id']); 
                                                    }])->select('cusr_id','cusr_art_id')
                                                    ->where($condition)
                                                    ->first();
            if($requestExist && isset($article_type_advance->jp_prevent_edit) && $article_type_advance->jp_prevent_edit != ''){
                $preventEditRoles = array_intersect($user_roles['role_id'],json_decode($article_type_advance->jp_prevent_edit));
                if(count($preventEditRoles) > 0){
                    $preventEditExist = true;
                    if(isset($requestExist->user_articles) && count($requestExist->user_articles) > 0){
                        $userRoleIds = $requestExist->user_articles->where('usra_usr_id',$this->current_user['user_id'])->pluck('usra_role_id')->toArray();      
                        $preventEditExist = count(array_intersect($userRoleIds,$preventEditRoles)) > 0 || count(array_diff(array_diff($preventEditRoles,$userRoleIds),$requestExist->user_articles->pluck('usra_role_id')->toArray())) > 0 ?true:false;       
                    }
                }                
            }
            if($preventEditExist){
                $action_buttons = [];
                $i = 0;
                $action_buttons[$i]['act'] = 'prevent_edit_history';
                $action_buttons[$i]['type'] = 'b';
                $action_buttons[$i]['name'] = 'prevent_edit_history';
                $action_buttons[$i]['id'] = 'prevent_edit_history';
                $action_buttons[$i]['class'] = 'btn btn-default mr-2';
                $action_buttons[$i]['description'] = "Request to edit author list history";
                $i++;

                $action_buttons[$i]['act'] = 'prevent_edit_approve';
                $action_buttons[$i]['type'] = 'b';
                $action_buttons[$i]['name'] = 'prevent_edit_grant';
                $action_buttons[$i]['id'] = 'prevent_edit_approve';
                $action_buttons[$i]['class'] = 'btn-success mr-2';
                $action_buttons[$i]['label'] = 'Approve request';
                $action_buttons[$i]['data_choice'] = 'a';
                $action_buttons[$i]['confirm_exist'] = true;
                $action_buttons[$i]['confirm_box'] = array(
                    'title' => 'Are you sure?',
                    'okText' => 'Yes',
                    'cancelText' => 'No',
                    'className' => 'btn btn-primary'
                );
                $i++;

                $action_buttons[$i]['act'] = 'prevent_edit_reject';
                $action_buttons[$i]['type'] = 'b';
                $action_buttons[$i]['name'] = 'prevent_edit_grant';
                $action_buttons[$i]['id'] = 'prevent_edit_reject';
                $action_buttons[$i]['class'] = 'btn-warning mr-2';
                $action_buttons[$i]['label'] = 'Decline request';
                $action_buttons[$i]['data_choice'] = 'r';
                $i++;
            }
        }
        return $action_buttons;
    }

    public function change_assignment_permission($article_details, $user_roles, $review_flow)
    {
        $Journal_permission = (new \App\Models\Journal_permission())->getTable();
        $return = FALSE;
        if (!isset($article_details) || $this->current_client->functionality->cfty_change_assignment == 'n')
            return $return;
        else {
            //condtions
            /*stage user change
			1.current user have the right to allocate current stage role user? (Assignments permission)
			2.current user have 'change assignment permission' from article permission tab
			3.check self assignment also

			article all stage permissions (article)
			1. current user have the permission to allocate allocated users
			2.current user have 'change assignment permission'
			3.check self assignment
			*/
            if (!empty($user_roles['role_id'])) {
                $author_roles = Roles::get_single_record('group_concat(role_id) as role_ids', "role_assigned_role='author'");
                $auth_roles = explode(',', $author_roles->role_ids);
                $user_allocation_cnd = 'usra_art_id=' . $article_details->art_id;
                $self_assignment_flag = FALSE;
                if ($this->current_client->functionality->cfty_self_assignment == 'n' && $article_details->aflw_usr_id != $this->current_user['user_id']) {
                    $self_assignment_flag = TRUE;
                    $user_allocation_cnd .= ' and usra_usr_id!=' . $this->current_user['user_id'];
                } elseif ($this->current_client->functionality->cfty_self_assignment == 'y') {
                    $self_assignment_flag = TRUE;
                }

                $cur_article_type = $article_details->artp_id;
                $cur_stage_role = $article_details->jwf_role_id;
                $user_roles_ids = $user_roles['role_id'];
                //Task #3996 Allow change assignment in TrAction stages
                $production_flag = FALSE;
                if (isset($review_flow[$article_details->jwf_stage_type]['stage_for']) && $review_flow[$article_details->jwf_stage_type]['stage_for'] == 'manageproduction')
                    $production_flag = TRUE;
                if ($production_flag == TRUE) {
                    $Roles_table = (new \App\Models\Roles)->getTable();
                    $sql_production_roles = "SELECT group_concat(role_id) as role_ids  FROM " . $Roles_table. " WHERE FIND_IN_SET('p',role_used_in)";
                    $production_roles_arr = User::get_records_by_raw_query($sql_production_roles);
                    $production_roles = explode(',', $production_roles_arr[0]->role_ids);
                    $user_roles_ids = array_intersect($user_roles_ids, $production_roles);
                }

                //non author condition
                $Authors = new \App\Models\Authors;
                $non_author_cnd = $Authors::get_single_record('count(auth_id) as cnt', "auth_art_id='" . $article_details->art_id . "' AND auth_usr_id='" . $this->current_user['user_id'] . "'");
                $article_type_table = (new \App\Models\Article_types())->getTable();
                //current user have 'change assignment permission' from article permission tab
                $sql = 'select FIND_array_intersect(\'' . implode(',',  $user_roles_ids) . '\',REPLACE(REPLACE(REPLACE(jp_change_usr_assigmnts,"]",""),"[","")," ","")) as change_usr_assign,FIND_array_intersect(\''.implode(',', $user_roles['role_id']) . '\',REPLACE(REPLACE(REPLACE(REPLACE(jp_change_usr_assigmnts,\'"\',""),"]",""),"[","")," ","")) as change_usr_assignold from ' . $Journal_permission . ' left join ' . $article_type_table . ' on artp_jpm_id=jp_jpm_id where `artp_id` =' . $cur_article_type;
                $res = Article_type_advance_options::get_records_by_raw_query($sql);
                //stage change assignment
                //current user have the right to allocate current stage role user? (Assignments permission)
                $Assign_permission = new \App\Models\Assign_permission;
                $condition = 'asgm_artp_id = ' . $cur_article_type . ' AND asgm_assgnd_role = ' . $cur_stage_role . ' AND asgm_can_assgn_role IN (' . implode(',',  $user_roles_ids) . ')';
                $result = $Assign_permission::get_single_record('count(*) as cnt', $condition);

               /*$article_flow = null;
                $stage_min_users = null;
                if ($article_details->jwf_stage_type == 'review') {
                    $cond = 'aflw_id = ? and aflw_status = \'c\'';
                    $cond_arr = [$article_details->aflw_id];
                    if (isset($article_details->aflw_parent_flow_id)) {
                        $cond = 'aflw_parent_flow_id = ? and aflw_status = \'c\'';
                        $cond_arr = [$article_details->aflw_parent_flow_id];
                    }
                    $article_flow = Article_flow::get_single_record('count(aflw_id) as minimcnt',$cond,binding_arr:$cond_arr);
                    $stage_min_users = Article_flow::get_single_record('aflw_stage_min_users','aflw_id = ?',binding_arr:$cond_arr);
                }*/

               // if ($non_author_cnd->cnt == 0 && ($article_details->art_status == 'y' || ($article_details->art_status == 'a' && $production_flag == TRUE)) && (in_array($article_details->aflw_status,['a','i']) && (($article_details->jwf_stage_type == 'review' && isset($stage_min_users->aflw_stage_min_users) && $article_flow->minimcnt != $stage_min_users->aflw_stage_min_users) || $article_details->jwf_stage_type != 'review')) && $article_details->jwf_stage_type != 'invitation' && (isset($res[0]) && ($res[0]->change_usr_assign == TRUE || $res[0]->change_usr_assignold == TRUE) || $result->cnt > 0)) {
                if ($non_author_cnd->cnt == 0 && ($article_details->art_status == 'y' || ($article_details->art_status == 'a' && $production_flag == TRUE)) && (in_array($article_details->aflw_status,['a','i'])) && $article_details->jwf_assignment != 'invitation' && (isset($res[0]) && ($res[0]->change_usr_assign == TRUE || $res[0]->change_usr_assignold == TRUE) || $result->cnt > 0)) {
                   $return = TRUE;
                }

                //article change assignment
                if ($production_flag == TRUE) {
                    $Roles_table = (new \App\Models\Roles)->getTable();
                    $sql_production_roles = "SELECT group_concat(role_id) as role_ids  FROM " . $Roles_table . " WHERE FIND_IN_SET('p',role_used_in)";
                    $production_roles_arr = User::get_records_by_raw_query($sql_production_roles);
                    $user_allocation_cnd .= ' and usra_role_id in ("' . $production_roles_arr[0]->role_ids . '")';
                }
                $User_articles = new \App\Models\User_articles;
                $user_allocation = $User_articles::get_single_record('count(usra_id) as cnt,group_concat(distinct usra_role_id) as allocate_roles', $user_allocation_cnd);

                //$condition = 'asgm_artp_id = ' . $cur_article_type . ' AND FIND_array_intersect(asgm_assgnd_role,\'' . $user_allocation->allocate_roles . '\') = 1  AND  FIND_array_intersect(asgm_can_assgn_role,\'' . implode(',',  $user_roles_ids) . '\') = 1 ';
                $condition = 'asgm_artp_id = ' . $cur_article_type . ' AND FIND_array_intersect(asgm_assgnd_role,\'' . $user_allocation->allocate_roles . '\') = 1';
                //$art_result = $Assign_permission::get_single_record('count(*) as cnt', $condition);

                $select = 'role_id, role_name,asgm_can_assgn_role';
                $to_assign = $Assign_permission->get_roles_to_assign($select, $condition);

                $roles_to_assign = $this->check_assignment_tab_visibility($article_details, $to_assign, $article_details->jwf_stage_type);
                $status_arr = array('a', 'u', 'w','i','c');
                //if ($non_author_cnd->cnt == 0 && ($article_details->art_status == 'y' || ($article_details->art_status == 'a' && $production_flag == TRUE)) && ( (isset($res[0]->change_usr_assign) && ($res[0]->change_usr_assign == TRUE || $res[0]->change_usr_assignold == TRUE)) || $art_result->cnt > 0) && $user_allocation->cnt > 0 && $self_assignment_flag == TRUE && (in_array($article_details->aflw_status, $status_arr)) && !in_array($cur_stage_role, $auth_roles)) {
                if ($non_author_cnd->cnt == 0 && ($article_details->art_status == 'y' || ($article_details->art_status == 'a' && $production_flag == TRUE)) && ( (isset($res[0]->change_usr_assign) && ($res[0]->change_usr_assign == TRUE || $res[0]->change_usr_assignold == TRUE)) ) && (!empty($roles_to_assign) && isset($roles_to_assign[0]->role_id)) && $self_assignment_flag == TRUE && in_array($article_details->aflw_status, $status_arr) && !in_array($cur_stage_role, $auth_roles) && ($article_details->jwf_assignment != 'invitation' || ($article_details->jwf_assignment == 'invitation' && $user_allocation->cnt > 0))) {



                   $return = TRUE;
                }
            }
        }
        return $return;
    }

    public function get_next_stage_buttons($array_data)
    {
        $this->current_user = $this->get_current_user_details();
        $article_privilages = isset($array_data['article_privilages']) ? $array_data['article_privilages'] : array();
        $article_data = isset($array_data['article_data']) ? $array_data['article_data'] : array();
        $article_type_advance = isset($array_data['article_type_advance']) ? $array_data['article_type_advance'] : array();
        $user_roles = isset($array_data['user_roles']) ? $array_data['user_roles'] : array();
        // $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : array();
        $segment = isset($array_data['segment']) ? $array_data['segment'] : '';
        $current_status_id = isset($array_data['current_status_id']) ? $array_data['current_status_id'] : '';
        $stage_role = isset($array_data['stage_role']) ? $array_data['stage_role'] : '';
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $jnlcode = isset($array_data['jnlcode']) ? $array_data['jnlcode'] : '';
        $decision = isset($array_data['decision']) ? $array_data['decision'] : array();
        $review_flow  = Config::get($workflow_config);
        $i = 0;
        $next_stage_buttons = array();
        /*/*
            * this line of is used for previous eido client now useless.
        */
        $simplified_popover = FALSE;
        if (isset($this->current_client->functionality->cfty_simplified_next_stage_popover) && $this->current_client->functionality->cfty_simplified_next_stage_popover == "y") {
            $simplified_popover = TRUE;
        }
        $next_stage_button_details = array();
        if (isset($article_data->aflw_jwf_id) && (isset($article_data->jwf_fwm_id)) && (isset($article_data->art_id)))
            $next_stage_button_details = $this->get_next_stages($article_data->aflw_jwf_id, $article_data->jwf_fwm_id, $article_data->art_id, FALSE, $review_flow);
            if (($article_data->aflw_status == 'a' || ($article_data->aflw_status == 'c' && $article_data->jwf_stage_type == 'production' && (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n')) || (env('VITE_CONFERENCE_PROCEEDINGS') === true && $article_data->aflw_status == 'c' && $article_data->jwf_stage_type == 'production')) && $current_status_id == $article_data->aflw_id && ($this->current_user['user_id'] == $article_data->aflw_usr_id || ($this->current_client->modules->mdl_conference == 'y' && in_array('admin', $this->current_user['roles']))) && $article_privilages['proxy_non_privilaged'] == FALSE) {

            if (
                $article_data->jwf_flow_proceed_type != 'parallel' && $stage_role->role_assigned_role != 'author' && $article_data->jwf_assignment != 'invitation'
            ) {
                /* Move next buttons */
                $email_to_auth = array(
                    'submit_author',
                    'Author',
                    'Authors',
                    'article_authors'
                );
                $eml_to_auth_str = '"' . join('","', $email_to_auth) . '"';
                $next_stage_details = $this->get_next_stages($article_data->aflw_jwf_id, $article_data->jwf_fwm_id, $article_data->art_id, FALSE, $review_flow);
                if ($next_stage_details && !empty($next_stage_details['stages']) && is_array($next_stage_details['stages'])) {
                    if ($article_data->art_status != 't') {
                        //Task 664 ICE ReView new stages
                        $advance_single_button = array();
                        $delete_btn_arr = array();
                        $advance_flow = Advance_flow_movement::get_all_records('afm_id,afm_jwf_id,afm_associated_stage_ids,afm_button_title,afm_button_tooltip', 'afm_fwm_id=' . $article_data->jwf_fwm_id . ' AND afm_jwf_id=' . $article_data->aflw_jwf_id);
                        $stage_label_from_adv_flow = array();
                        if ($article_data->jwf_flow_proceed_type == 'advance' && count($advance_flow) > 0) {
                            $temp_arr = array_column($next_stage_details['stages'], 'stage_id');
                            $temp_hld_arr = array();
                            foreach ($advance_flow as $key => $advflw) {
                                $advance_single_button_option = array();
                                $stage_arr = explode(',', $advflw->afm_associated_stage_ids);
                                $sg_name = array();
                                $sg_data = array();
                                if (count($stage_arr) > 1) {
                                    foreach ($stage_arr as $st_id) {
                                        $ind_no = array_search($st_id, $temp_arr);
                                        if (isset($next_stage_details['stages'][$ind_no])) {
                                            $sg_data = $next_stage_details['stages'][$ind_no];
                                            $sg_name[] = $sg_data['stage_name'];
                                            $temp_hld_arr[$ind_no] = $next_stage_details['stages'][$ind_no];
                                            unset($next_stage_details['stages'][$ind_no]);
                                        } elseif (isset($temp_hld_arr[$ind_no])) {
                                            $sg_data = $temp_hld_arr[$ind_no];
                                            $sg_name[] = $sg_data['stage_name'];
                                        }
                                    }

                                    if ($advflw->afm_button_tooltip == '')
                                        $advflw->afm_button_tooltip = implode(', ', $sg_name);

                                    //***********************************
                                    $next_stage_buttons[$key]['id'] = 'btn' . $advflw->afm_id;
                                    $next_stage_buttons[$key]['name'] = 'move_stage';
                                    $next_stage_buttons[$key]['button_class'] = 'btn-primary mr-2';
                                    $next_stage_buttons[$key]['choice'] = 'move_to_advance_selected';
                                    if ($simplified_popover == TRUE) {
                                        $next_stage_buttons[$key]['title'] = 'Are you sure?';
                                    } else {
                                        $next_stage_buttons[$key]['title'] = 'Proceed to: \'\'' . $advflw->afm_button_tooltip . '\'\'?';
                                    }
                                    $next_stage_buttons[$key]['label'] = $advflw->afm_button_title;
                                    $next_stage_buttons[$key]['stage_id'] = $advflw->afm_id;
                                    $next_stage_buttons[$key]['type'] = 'b';
                                } elseif (isset($stage_arr[0])) //2459 MISC - Advance flow button render correction
                                {
                                    $ind_no = array_search($stage_arr[0], $temp_arr);
                                    if (isset($next_stage_details['stages'][$ind_no])) {
                                        $sg_data = $next_stage_details['stages'][$ind_no];
                                        $temp_hld_arr[$ind_no] = $sg_data;
                                        unset($next_stage_details['stages'][$ind_no]);
                                    } elseif (isset($temp_hld_arr[$ind_no]))
                                        $sg_data = $temp_hld_arr[$ind_no];
                                    if (count($sg_data) > 0) {
                                        /* Modified Advanced flow single stage button rendering */
                                        $advance_single_button_option['label'] =  $advflw->afm_button_title;
                                        $advance_single_button_option['id'] = 'btn' . $sg_data['stage_id'];
                                        $advance_single_button_option['name'] = 'move_stage';
                                        $advance_single_button_option['button_class'] = 'btn-primary mr-2';
                                        $advance_single_button_option['choice'] = 'move_to_selected';
                                        if ($simplified_popover == TRUE) {
                                            $advance_single_button_option['title'] = 'Are you sure?';
                                        } else {
                                            $advance_single_button_option['title'] = 'Proceed to: \'\'' . $sg_data['stage_name'] . '\'\'?';
                                        }
                                        $advance_single_button_option['stage_name'] = $sg_data['stage_name'];
                                        $advance_single_button_option['stage_role_id'] = $sg_data['stage_role_id'];
                                        $advance_single_button_option['stage_role_assigned_role'] = $sg_data['stage_role_assigned_role'];
                                        $advance_single_button_option['stage_id'] = $sg_data['stage_id'];
                                        $advance_single_button_option['stage_type'] = $sg_data['stage_type'];
                                        $advance_single_button_option['type'] = 'b';
                                        $advance_single_button_option = $this->get_next_stage_button_condition_setting($sg_data, $article_type_advance, $article_data, $eml_to_auth_str, $advance_single_button_option);
                                        $next_stage_buttons[] = $advance_single_button_option;
                                        /* Modified Advanced flow single stage button rendering*/
                                    }
                                }
                            }
                        }

                        $next_stage_key_start = 0;
                        $key = 0;
                        if (!empty($next_stage_buttons)) {
                            if (count($next_stage_buttons) > 0) {
                                $next_stage_key = array_keys($next_stage_buttons);
                                $next_stage_key_start = end($next_stage_key);
                                $key = $next_stage_key_start + 1;
                            }
                        } else {
                            $key = $next_stage_key_start;
                        }

                        foreach ($next_stage_details['stages'] as $key_start => $val) {
                            $normal_flow_button_option = array();
                            /*Modification in workflow stage button title introduced */
                            if (isset($val['stage_button_text']) && $val['stage_button_text'] != '')
                                $label_text = $val['stage_button_text'];
                            else
                                $label_text = $val['stage_name'];


                            /* Modification of button rendering start */

                            $normal_flow_button_option['id'] = 'btn' . $val['stage_id'];
                            $normal_flow_button_option['name'] = 'move_stage';
                            $normal_flow_button_option['button_class'] = 'btn-primary mr-2';
                            $normal_flow_button_option['choice'] = 'move_to_selected';
                            if ($simplified_popover == TRUE) {
                                $normal_flow_button_option['title'] = 'Are you sure?';
                            } else {
                                $normal_flow_button_option['title'] = 'Proceed to: \'\'' . $val['stage_name'] . '\'\'?';
                            }

                            $normal_flow_button_option['label'] =  $label_text;
                            $normal_flow_button_option['stage_name'] = $val['stage_name'];
                            $normal_flow_button_option['stage_role_id'] = $val['stage_role_id'];
                            $normal_flow_button_option['stage_role_assigned_role'] = $val['stage_role_assigned_role'];
                            $normal_flow_button_option['stage_id'] = $val['stage_id'];
                            $normal_flow_button_option['stage_type'] = $val['stage_type'];
                            $normal_flow_button_option['type'] = 'b';
                            $normal_flow_button_option['stageid'] = $this->encrypt_data($val['stage_id']);
                            $normal_flow_button_option['decision'] = $decision;
                            $normal_flow_button_option = $this->get_next_stage_button_condition_setting($val, $article_type_advance, $article_data, $eml_to_auth_str, $normal_flow_button_option);
                            $next_stage_buttons[] = $normal_flow_button_option;
                            $key++;
                        }
                        //echo '<pre>';print_r($next_stage_buttons);die;
                    } else {
                        //Bug #2440	Article move to next stage even the article is in transit stage
                        $next_stage_buttons = 'transit_msg';
                    }
                } elseif ($article_data->jwf_stage_type == 'production') {
                    /* Export Data */

                    $defult_export = 1;
                    /*					 * * Customisation #1177 - Export multiple location  ** */
                    if ($this->current_client->functionality->cfty_export_multiple_location == 'y') {
                        $Journal_export_config = new \App\Models\Journal_export_config;
                        $clnt_id = (isset($this->current_client->clnt_id)) ? $this->current_client->clnt_id : 0;
                        $export_multipl_details = $Journal_export_config::get_all_records('cje_hostname,cje_username,cje_file_type,cje_id,cje_name', 'cje_jnl_id=' . $this->jnl_data->jnl_id . ' and cje_clnt_id=' . $clnt_id);
                        $export_jnl_setting = Journal_settings::get_single_record('jset_export_using_single_button', 'jset_jnl_id=' . $this->jnl_data->jnl_id);
                        if (!empty($export_multipl_details)) {
                            if (isset($export_jnl_setting->jset_export_using_single_button) && $export_jnl_setting->jset_export_using_single_button == 'm') {
                                $defult_export = 0;
                                foreach ($export_multipl_details as $exp) {
                                    $next_stage_buttons[$i]['label'] = 'Export Data to ' . $exp->cje_name;
                                    $next_stage_buttons[$i]['name'] = 'export_data[]';
                                    $next_stage_buttons[$i]['button_class'] = 'btn btn-primary mr-2 btn_production';
                                    $next_stage_buttons[$i]['id'] = $exp->cje_id;
                                    $i++;
                                }
                            }
                        }
                    }
                    if ($defult_export == 1) {
                        /*Task 305 - ES Integration - export article modification*/
                        $es_condition = array('article_id' => $article_data->art_id);
                        $checkdata=$this->check_espermission_access($es_condition);
                        if($checkdata == false)
                        {
                        $next_stage_buttons[$i]['label'] = 'Export Data';
                        $next_stage_buttons[$i]['name'] = 'export_data';
                        $next_stage_buttons[$i]['title'] = 'Are you sure you want to Export data?';
                        $next_stage_buttons[$i]['type'] = 'b';
                        $next_stage_buttons[$i]['button_class'] = 'btn btn-primary btn_production mr-2';
                        $next_stage_buttons[$i]['id'] = (empty($export_multipl_details)) ? 'default' : 'multiple';
                        
                        // in batch decision page, user needs to export the production completed abstract again
                        if ($this->current_client->modules->mdl_conference == 'y' && $article_data->aflw_status == 'c' && $article_data->jwf_stage_type == 'production') {
                            $next_stage_buttons[$i]['choice'] = 'export_already_completed';
                        }
                        }
                        else
                        {
                            /*Task 305 - ES Integration - export article modification*/
                            $next_stage_buttons[$i]['label'] = 'Publish';
                            $next_stage_buttons[$i]['name'] = 'publish_data_es';
                            $next_stage_buttons[$i]['title'] = 'Are you sure you want to Export data?';
                            $next_stage_buttons[$i]['type'] = 'b';
                            $next_stage_buttons[$i]['button_class'] = 'btn btn-primary btn_production mr-2';
                            $next_stage_buttons[$i]['id'] = 'publish_data_es';
                            $pass_array = array();
                            $pass_array['article_id'] = $article_data->art_id;
                            $pass_array['artp_id'] = $article_data->art_artp_id;
                            $pass_array['artp_fwm_id'] = $article_data->artp_fwm_id;
                            $pass_array['jnl_code'] = $jnlcode;
                            $pass_array['flow_id'] = $article_data->aflw_id;
                            $pass_array['flow_status'] = $article_data->aflw_status;
                            $pass_array['stage_type'] = $article_data->jwf_stage_type;
                            $pass_array['role_id'] = $array_data['role_id'];
                            $pass_array['jp_edit_article_files'] = $article_type_advance->jp_edit_article_files;
                            $pass_array['flow_usr_id'] = $article_data->aflw_usr_id;
                            $pass_array['aflw_stage_min_users'] = $article_data->aflw_stage_min_users;
                            $next_stage_buttons[$i]['es_array'] = $this->get_es_integrations_permissions($pass_array);
                        }
                        $i++;
                    }
                } elseif ($article_data->jwf_stage_type == 'reject') {
                    /* Reject article */
                    /*Modification in workflow stage button title introduced */
                    if (isset($next_stage_button_details['stages'][0]['stage_button_text']) && ($next_stage_button_details['stages'][0]['stage_button_text']))
                        $label_text = $next_stage_button_details['stages'][0]['stage_button_text'];
                    else
                        $label_text = 'Confirm Reject';

                    $next_stage_buttons[$i]['label'] = $label_text;
                    $next_stage_buttons[$i]['name'] = 'reject_article';
                    $next_stage_buttons[$i]['type'] = 'b';
                    $next_stage_buttons[$i]['button_class'] = 'btn-danger mr-2';

                    if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' && (isset($article_type_advance->atotp_review_open_decision) && $article_type_advance->atotp_review_open_decision == 'n')) {
                        $users_to_unassign = Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_parent_flow_id is not NULL and aflw_status = "a" and  aflw_art_id =' . $article_data->art_id);
                        if (isset($users_to_unassign->cnt) && $users_to_unassign->cnt > 0) {
                            $next_stage_buttons[$i]['has_unassign_users'] = TRUE;
                        }
                    }
                    $next_stage_buttons[$i]['title'] = 'Are you sure?';
                    $i++;
                } elseif ($article_data->jwf_stage_type == 'aop_publish') {
                    $next_stage_buttons[$i]['label'] = 'Publish AoP1';
                    //$next_stage_buttons[$i]['name'] = 'aop1_publish';
                    $next_stage_buttons[$i]['name'] = 'move_stage';
                    //the below code  is commented as per the discussion with gijo because mile stone stage needs Are you sure.
                    $next_stage_buttons[$i]['title'] = 'Are you sure?';
                    $next_stage_buttons[$i]['type'] = 'b';
                    $next_stage_buttons[$i]['choice'] = 'complete_aop1_publish';
                    $next_stage_buttons[$i]['button_class'] = 'btn btn-primary mr-2';
                    $next_stage_buttons[$i]['id'] = '';
                    $i++;
                } elseif ($article_data->jwf_stage_type == 'publish') {
                    $next_stage_buttons[$i]['label'] = 'Notify author';
                    $next_stage_buttons[$i]['name'] = 'move_stage';
                    if ($simplified_popover == TRUE) {
                        $next_stage_buttons[$i]['title'] = 'Are you sure?';
                    } else {
                        $next_stage_buttons[$i]['title'] = 'Are you sure you want to notify the author?';
                    }
                    $next_stage_buttons[$i]['type'] = 'b';
                    $next_stage_buttons[$i]['choice'] = 'complete_publish';
                    $next_stage_buttons[$i]['button_class'] = 'btn btn-primary mr-2';
                    $next_stage_buttons[$i]['id'] = '';
                    $i++;
                }
            } elseif (($article_data->art_submitted_by == $this->current_user['user_id'] || isset($article_data->art_stage_submission_method) && $article_data->art_stage_submission_method == 'n') && $article_data->jwf_stage_type == 'author_submission' && $segment == "preview-article") { // Edit article button at the bottom
                $skip_submit_btn =  FALSE;
                $show_preview_link_btn = FALSE;
                if(isset($article_data->art_id) && !empty($article_data->art_id))
                {
                    $esarray['article_id']=$article_data->art_id;
                }else{
                    $esarray['article_id']='';
                }
                $checkdata=$this->check_espermission_access($esarray);
               // if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $article_data->art_es_document_status == 'y')
                if($checkdata==true && $article_data->art_es_document_status == 'y')
                {
                    $show_preview_link_btn = TRUE;
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    if(isset($es_api_data['check_submission_preview']))
                    {
                        $apiUrl = $es_api_data['check_submission_preview'];
                        $data_to_editor = array('art_id' => $article_data->art_id);
                        $data_to_editor = http_build_query($data_to_editor);
                        $response = $this->es_curl_request($apiUrl,$data_to_editor);
                        $response = json_decode($response);
                        if(isset($response->preview_status) && $response->preview_status == FALSE)
                        {
                            $skip_submit_btn = TRUE;
                        }
                    }
                }
                $next_stage_buttons[$i]['type'] = 'a';
                $next_stage_buttons[$i]['name'] = 'edit_submission';
                $next_stage_buttons[$i]['button_class'] = 'btn-danger';
                if(isset($article_data->art_stage_submission_method) && $article_data->art_stage_submission_method == 'n')
                {
                    $next_stage_buttons[$i]['button_class'] = 'btn-primary';
                }
                $next_stage_buttons[$i]['title'] = customTrans('Do you want to edit :article?');
                $next_stage_buttons[$i]['label'] = 'Edit Submission';
                $next_stage_buttons[$i]['href'] = $jnlcode . '/' . $article_data->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($article_data->aflw_id);
                if(isset($article_data->art_stage_submission_method) && $article_data->art_stage_submission_method == 'n')
                {
                    $next_stage_buttons[$i]['href'] = $jnlcode . '/' . $article_data->artp_abbr_article_type . '/edit-article-production/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($article_data->aflw_id);
                }
                $next_stage_buttons[$i]['button_position'] = 'pull-left';
                $next_stage_buttons[$i]['id'] = 'editbutton';
                $i++;
                if($skip_submit_btn == FALSE)
                {
                $next_stage_buttons[$i]['name'] = 'final_submit';
                $next_stage_buttons[$i]['type'] = 'b';
                $next_stage_buttons[$i]['title'] = 'Do you want to submit?';
                $next_stage_buttons[$i]['label'] = !empty($article_data->jwf_button_title)?$article_data->jwf_button_title:"Submit";
                $next_stage_buttons[$i]['button_position'] = 'pull-right';
                $next_stage_buttons[$i]['button_class'] = 'btn-primary';
                $next_stage_buttons[$i]['id'] = 'submitbutton';
                $i++;
                }
                if($show_preview_link_btn == TRUE)
                {
                    $next_stage_buttons[$i]['name'] = 'preview_submit';
                    $next_stage_buttons[$i]['type'] = 'preview_es_link';
                    $next_stage_buttons[$i]['label'] = 'Preview Document';
                    $next_stage_buttons[$i]['button_position'] = 'pull-right';
                    $next_stage_buttons[$i]['button_class'] = 'btn-warning';
                    $next_stage_buttons[$i]['id'] = 'previewlink';
                    $next_stage_buttons[$i]['skip_submit'] = $skip_submit_btn;
                    $i++;
                }

            } elseif ($article_data->jwf_stage_type == 'resubmission') {
                /* Resubmit */
                /*Modification in workflow stage button title introduced */
                $label_text = 'Submit revision';
                $next_stage_buttons[$i]['type'] = 'b';
                $next_stage_buttons[$i]['name'] = 'move_stage';
                if(isset($this->current_client->platform_type) && $this->current_client->platform_type == 'conference') {
                    $ppr =   'abstract';
                } else {
                    $ppr =   'article';
                }
                $next_stage_buttons[$i]['title'] = 'Are you sure you want to resubmit this '.$ppr.'?';
                $next_stage_buttons[$i]['label'] = $label_text;
                $next_stage_buttons[$i]['type'] = 'b';
                $next_stage_buttons[$i]['choice'] = 'resubmitauthor';
                $i++;
            } elseif ($article_data->jwf_stage_type == 'revision') {
                $label_text = 'Submit';
                if ($article_data->art_submitted_by == $this->current_user['user_id']) {
                    /* Revision Submit */
                    $next_stage_buttons[$i]['name'] = 'move_stage';
                    $next_stage_buttons[$i]['title'] = 'Do you want to submit?';
                    $next_stage_buttons[$i]['label'] = $label_text;
                    $next_stage_buttons[$i]['type'] = 'b';

                    $i++;
                }
            } else {
                $para_bth_r_rviw = FALSE;
                if ($article_data->jwf_flow_proceed_type == 'parallel' && isset($next_stage_button_details['stages'])) {
                    $review_stages_found = FALSE;
                    foreach ($next_stage_button_details['stages'] as $sing_next_stg) {
                        if ($sing_next_stg['stage_type'] == 'review') {
                            $review_stages_found = TRUE;
                        }
                    }
                    if ($review_stages_found == TRUE) {
                        $para_bth_r_rviw = TRUE;
                    }
                }

                /* Submit */
                /*Modification in workflow stage button title introduced */
                if (isset($next_stage_button_details['stages'][0]['stage_button_text']) && ($next_stage_button_details['stages'][0]['stage_button_text']) && $para_bth_r_rviw == FALSE)
                    $label_text = $next_stage_button_details['stages'][0]['stage_button_text'];
                else
                    $label_text = 'Submit';
                $next_stage_buttons[$i]['label'] = $label_text;
                if ($simplified_popover == TRUE && $article_data->art_submitted_by !== $this->current_user['user_id']) {
                    $next_stage_buttons[$i]['title'] = 'Are you sure?';
                } else {
                    $next_stage_buttons[$i]['title'] = 'Do you want to submit?';
                }
                if( $label_text == "Submit")
                {
                $next_stage_buttons[$i]['choice'] = $article_data->jwf_stage_type;
                }
                /* Task #9213 If the user selects the workflow preference 'Parallel execution of all stages,' the system fails to open all child stages. */
                if(isset($next_stage_button_details['stages'][0]['stage_id'])&&count($next_stage_button_details['stages'])>1)
                {
                    $next_stage_buttons[$i]['stage_id']='';
                }
                else
                {
                $next_stage_buttons[$i]['stage_id'] = isset($next_stage_button_details['stages'][0]['stage_id'])?$next_stage_button_details['stages'][0]['stage_id']:'';
                }
                    /* Task #9213 End */
                $next_stage_buttons[$i]['name'] = 'move_stage';
                $next_stage_buttons[$i]['type'] = 'b';
                if ($article_data->jwf_stage_type == 'pro_revision' && $stage_role->role_assigned_role == 'author' && $next_stage_button_details['stages'][0]['stage_type'] == 'editorial_amendment') {
                    $next_stage_buttons[$i]['label'] = "Submit files";
                    if ($simplified_popover == TRUE) {
                        $next_stage_buttons[$i]['title'] = 'Are you sure?';
                    }
                }

            if ($article_data->jwf_stage_type == 'review') {
                    /*Modification in workflow stage button title introduced */
                    if (isset($next_stage_button_details['stages'][0]['stage_button_text']) && ($next_stage_button_details['stages'][0]['stage_button_text']))
                        $label_text = $next_stage_button_details['stages'][0]['stage_button_text'];
                    else
                        $label_text = 'Submit Review';

                    $next_stage_buttons[$i]['label'] = $label_text;
                    $next_stage_buttons[$i]['title'] = 'Are you sure you want to submit your review?';
                    $next_stage_buttons[$i]['button_class'] = 'btn-success mr-2';
                    $next_stage_buttons[$i]['stage_name'] = 'review';
                }
                if ($article_data->jwf_stage_type == 'author_submission') {
                    $label_text = 'Submit';
                    if ($article_data->art_submitted_by == $this->current_user['user_id']) {
                        /* Revision Submit */
                        $next_stage_buttons[$i]['name'] = 'move_stage';
                        $next_stage_buttons[$i]['title'] = customTrans('viewarticle.submit');;
                        $next_stage_buttons[$i]['label'] = $label_text;
                        $next_stage_buttons[$i]['type'] = 'b';
                    }
                }
                $i++;
            }
        }
        /* check Current stage is Payment and Client functionality article payment bypass enable */
        if ($article_data->jwf_stage_type == 'payment' && $this->current_client->functionality->cfty_enable_article_payment_bypass == 'y' && $article_data->aflw_status == 'u') {
            if (isset($article_type_advance->jp_move_article_from_payment) && !empty($article_type_advance->jp_move_article_from_payment) && count(array_intersect(json_decode($article_type_advance->jp_move_article_from_payment), $user_roles['role_id'])) > 0) {
                $Payment_order = new \App\Models\Payment_order();
                /* Get the Current article transaction Status */
                $article_payment_status = $Payment_order::get_single_record('pmt_transaction_status','pmt_ord_art_id=' . $article_data->art_id);
                /* Check Payment Status CheckoutComplete */
                if(!empty($article_payment_status))
                {
                if ($article_payment_status->pmt_transaction_status == 'CC') {
                    /* Get the imformation From the next Stage */

                    $next_stage_details = $this->get_next_stages($article_data->aflw_jwf_id, $article_data->jwf_fwm_id, $article_data->art_id, FALSE, $review_flow);

                    if ($next_stage_details && !empty($next_stage_details['stages']) && is_array($next_stage_details['stages'])) {
                        foreach ($next_stage_details['stages'] as $key => $val) {
                            $next_stage_buttons[$key]['id'] = 'btn_payment_bypass';
                            $next_stage_buttons[$key]['name'] = 'move_payment_bypass';
                            $next_stage_buttons[$key]['button_class'] = 'btn-primary mr-2';
                            $next_stage_buttons[$key]['choice'] = 'move_to_selected';
                            $next_stage_buttons[$key]['title'] = 'Proceed to: \'\' ' . $val['stage_name'] . '\'\'?';
                            if (isset($val['stage_button_text']) && $val['stage_button_text'] != '') {
                                $next_stage_buttons[$key]['label'] = $val['stage_button_text'];
                            } else {
                                $next_stage_buttons[$key]['label'] = $val['stage_name'];
                            }
                            $next_stage_buttons[$key]['stage_name'] = $val['stage_name'];
                            $next_stage_buttons[$key]['stage_role_id'] = $val['stage_role_id'];
                            $next_stage_buttons[$key]['stage_role_assigned_role'] = $val['stage_role_assigned_role'];
                            $next_stage_buttons[$key]['stage_id'] = $val['stage_id'];
                            $next_stage_buttons[$key]['stage_type'] = $val['stage_type'];
                            $next_stage_buttons[$i]['type'] = 'b';
                            $i++;
                        }
                    }
                }
            }
            }
        }

        if ($article_data->jwf_stage_type == 'payment' && $this->current_client->functionality->cfty_enable_re_instantiate_payment == 'y' && $article_data->aflw_status == 'u') {
            if (isset($article_type_advance->jp_reinstantiate_payment) && count(array_intersect(json_decode($article_type_advance->jp_reinstantiate_payment), $user_roles['role_id'])) > 0) {
                $Payment_order = new \App\Models\Payment_order();
                /* Get the Current article transaction Status */
                $article_payment_status = $Payment_order::get_single_record('pmt_transaction_status', 'pmt_ord_art_id=' . $article_data->art_id);

                if (isset($article_payment_status->pmt_transaction_status) && ($article_payment_status->pmt_transaction_status == 'CL')) {
                    $next_stage_buttons[$i]['id'] = 'reinstantiate_id';
                    $next_stage_buttons[$i]['button_class'] = 'btn-primary mr-2';
                    $next_stage_buttons[$i]['name'] = 're-instantiate';
                    $next_stage_buttons[$i]['type'] = 'b';
                    $next_stage_buttons[$i]['label'] = 'Re-instantiate payment';
                    $next_stage_buttons[$i]['title'] = 'Are you sure?';

                    $i++;
                }
            }
        }
        return $next_stage_buttons;
    }

    /* get next stage button condition button rendering */

    public function get_next_stage_button_condition_setting($val, $article_type_advance, $article_data, $eml_to_auth_str, $next_stage_button)
    {
        /*Bug#4518 AE cannot review decision letters now start  */
        $next_stage_decision_id = '';
        $assigned_role = '';
        $assigned_stage_type = '';
        $general_config = General_ConfigTraits::General_config_data('decision_popup_showstages');
        $decision_poup_show_stage_array = $general_config['decision_popup_showstages'];
        if (!empty($decision_poup_show_stage_array) && (in_array($article_data->jwf_stage_type, $decision_poup_show_stage_array)) && isset($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage) && ($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage == 'y')) {
            $next_stage_decision_id = $this->get_next_decision_stageid(array($val['stage_id']), allow_multi_stage_return:true);
            if(is_array($next_stage_decision_id) && count($next_stage_decision_id) == 1 ){
                $next_stage_decision_id = $next_stage_decision_id[0];
            }
            if ($next_stage_decision_id != NULL){
                $next_id = is_array($next_stage_decision_id) ? $next_stage_decision_id[0] : $next_stage_decision_id;
                $assigned_details = $this->get_next_decision_details($next_id);

            }
            if (!empty($assigned_details)) {
                $assigned_role  = $assigned_details['role_assigne_role'];
                $assigned_stage_type = $assigned_details['stage_type'];
            }
        }
        if ($next_stage_decision_id == NULL) {
            $next_stage_decision_id = $val['stage_id'];
        }
        if ($assigned_stage_type == NULL) {
            $assigned_stage_type = $val['stage_type'];
        }
        $Article_notification_emails = new \App\Models\Article_notification_emails;
        $Stage_email_templates = new \App\Models\Stage_email_templates;
        /*Bug#4518 AE cannot review decision letters now End  */
        if (in_array(trim($val['stage_type']), array(
            'reject',
            'accept',
            'decision_revision',
            'pre_assessment',
            'review',
            'post_assessment'
        )) && $article_data->jwf_stage_type != "staff_check") {
            $next_stage_button['confirm_msg'] = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
        }
        $next_stage_button['author_stage_email'] = FALSE;
        $next_stage_button['author_stage_email_tmpl_cnt'] = NULL;
        $decision_email = FALSE;
        if((isset($next_stage_button['decision']['decisioncontroldetails']) && !in_array($next_stage_button['decision']['decisioncontroldetails']['decisioncontrolstage'],array(
        'reject',
        'accept')))  || !isset($next_stage_button['decision']))
        {
            $decision_email = TRUE;
        }
        /*Bug#4518 AE cannot review decision letters now start  */
        if(is_array( $next_stage_decision_id)){
            $next_stage_decision_id = " ('" . implode("','",  $next_stage_decision_id) . "') ";
        }else{
            $next_stage_decision_id = " ( $next_stage_decision_id) ";
        }
        if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' && ($val['stage_role_assigned_role'] == 'author' || ($next_stage_decision_id != NULL && $assigned_role == 'author')) && $decision_email == TRUE) {
            $author_stage_email = $Stage_email_templates::get_stage_email_tmpl_to_trigger('count(*) as cnt', 'setr_jwf_id IN ' . $next_stage_decision_id . ' AND (stage_etmp_action = "assigned" OR stage_etmp_action = "initialization")');
            if (isset($author_stage_email[0]->cnt) && $author_stage_email[0]->cnt > 0) {
                $next_stage_button['author_stage_email'] = TRUE;
                $this->data['show_complete_email_js'] = TRUE;
                $next_stage_button['author_stage_email_tmpl_cnt'] = $author_stage_email[0]->cnt;
            } else {

                $where = ' (stage_etmp_action = "declined" OR stage_etmp_action = "completed" ) AND stage_etmp_stage_type ="' . $article_data->jwf_stage_type . '" AND setr_jwf_id=' . $article_data->aflw_jwf_id . ' AND stage_etmp_to IN (' . $eml_to_auth_str . ')';
                $on_complete_emails = $Stage_email_templates::get_stage_email_tmpl_to_trigger('count(*) as cnt', $where);
                $au_cnt = isset($on_complete_emails[0]->cnt) ? $on_complete_emails[0]->cnt : 0;
                $next_stage_button['author_stage_email_tmpl_cnt'] = $au_cnt;
            }
        }
        /*Bug#4518 AE cannot review decision letters now start  */
        if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' && in_array($assigned_stage_type, array(
            'reject',
            'accept',
            'decision_revision'
        ))) {
            $email_to_auth = array(
                'submit_author',
                'Author',
                'Authors',
                'article_authors'
            );
            $eml_to_auth_str = '"' . join('","', $email_to_auth) . '"';
            $dec_cnt = 0;
            /*Bug#4518 AE cannot review decision letters now start  */
            $dec_stage_email = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_id', 'setr_jwf_id IN ' . $next_stage_decision_id . ' AND ((stage_etmp_action = "completed" AND stage_etmp_stage_type != "reject") OR (stage_etmp_action = "declined" AND stage_etmp_stage_type = "reject")) AND stage_etmp_to IN (' . $eml_to_auth_str . ')');

            if (!empty($dec_stage_email)) {
                foreach ($dec_stage_email as $dc) {
                    $dec_edited = $Article_notification_emails::get_single_record('ane_to', 'ane_stage_etmp_id = ' . $dc->stage_etmp_id . ' AND ane_prev_aflw_id = ' . $article_data->aflw_id);
                    if (!empty($dec_edited)) {
                        if (isset($dec_edited->ane_to) && in_array($dec_edited->ane_to, $email_to_auth)) {
                            $dec_cnt++;
                        }
                    } else {
                        $dec_cnt++;
                    }
                }
            }
            if ($dec_cnt > 0) {
                $next_stage_button['decsn_stage_email'] = TRUE;
                //$this->data['show_complete_email_js'] = TRUE;
            }
        }

        if ((isset($article_type_advance->atotp_review_open_decision) && $article_type_advance->atotp_review_open_decision == 'n') && in_array($article_data->jwf_stage_type, array(
            'accept',
            'reject',
            'decision_revision'
        ))) {
            $Article_flow = new \App\Models\Article_flow;
            $article_flow_table = (new \App\Models\Article_flow)->getTable();
            $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
            $quer = 'select count(*) as cnt FROM ' . $article_flow_table . ' JOIN ' . $generic_flow_table  . ' ON jwf_id = aflw_jwf_id WHERE aflw_parent_flow_id is not NULL and aflw_status = "a" and  aflw_art_id =' . $article_data->art_id . ' AND jwf_assignment = "invitation"';

            $users_to_unassign = $Article_flow::get_records_by_raw_query($quer);
            if (isset($users_to_unassign[0]->cnt) && $users_to_unassign[0]->cnt > 0) {
                $next_stage_button['has_unassign_users'] = TRUE;
                //$this->data['show_complete_email_js'] = TRUE;
            }
        }

        return $next_stage_button;
    }
    /* End stage button condition */
    /*Bug#4518 AE cannot review decision letters now start  */
    /* $allow_multi_stage_return returns array of next_stage_id if all the child stage_type are equal */
    public function get_next_decision_stageid($stage_array = array(), $main_array = array(), $allow_multi_stage_return = false)
    {
        $next_stage_id = FALSE;
        $array_decision = array('resubmission', 'accept', 'reject', 'revision');
        if (!empty($stage_array)) {
            $condition = 'jwf_id IN(' . implode(',', $stage_array) . ')';
            $stagedetails = Generic_flows::get_all_records('jwf_id,jwf_stage_type,jwf_child_stages', $condition);
            if (!empty($stagedetails)) {
                $temp_array = array();
                $temp_flag = 0;
                $last_stage_type = null; 
                foreach ($stagedetails as $stage) {
                    if ($stage->jwf_stage_type == 'review') {
                        return FALSE;
                    } elseif (in_array($stage->jwf_stage_type, $array_decision)) {
                        if($allow_multi_stage_return){
                            if($last_stage_type != $stage->jwf_stage_type){
                                $last_stage_type = $stage->jwf_stage_type;
                                $temp_flag++;
                            }
                            $next_stage_id[] = $stage->jwf_id;
                        }else{
                            $temp_flag++;
                            $next_stage_id = $stage->jwf_id;
                        }
                    } else {
                        $child_stage_ids = json_decode($stage->jwf_child_stages);
                        if (!empty($child_stage_ids)) {
                            foreach ($child_stage_ids as $child) {
                                if (!in_array($child, $main_array)) {
                                    $temp_array[] = $child;
                                }
                            }
                        }
                    }
                }
                if ($temp_flag == 0 && $next_stage_id == FALSE) {

                    $main_array = array_merge($temp_array, $main_array);

                    $next_stage_id = $this->get_next_decision_stageid($temp_array, $main_array, $allow_multi_stage_return);
                }
                if ($temp_flag > 1) {
                    $next_stage_id = FALSE;
                }
            }
        }
        return $next_stage_id;
    }

    public function get_next_decision_details($next_jwf_id)
    {
        $assigned_details = array();
        if ($next_jwf_id != NULL) {
            $condition = 'jwf_id=' . $next_jwf_id;
            $stagedetails = Generic_flows::get_single_record('jwf_role_id,jwf_stage_type', $condition);
            if (isset($stagedetails->jwf_role_id) && $stagedetails->jwf_role_id != NULL) {
                $cond_role = 'role_id=' . $stagedetails->jwf_role_id;
                $assigned_details['stage_type'] = $stagedetails->jwf_stage_type;
                $role_assigned_det = Roles::get_single_record('role_assigned_role', $cond_role);
                if (!empty($role_assigned_det)) {
                    $assigned_details['role_assigne_role'] = $role_assigned_det->role_assigned_role;
                }
            }
        }
        return $assigned_details;
    }


    //this function will return select/invite  => users and rolse
    public function get_formated_roles_and_users_list($assigned_role_users, $art_id, $user_disply_name = array(), $jnl_array = array(),$artp_id = NULL)
    {

        $assigned_roles_assign = array();
        $assigned_user_data_assign = array();
        $assigned_list = '';
        $assigned_roles = array();
        if (isset($assigned_role_users['assigned_roles_assign']))
            $assigned_roles = $assigned_role_users['assigned_roles_assign'];

        if (isset($assigned_role_users['assigned_users_assign'])) {
            foreach ($assigned_role_users['assigned_users_assign'] as $usr) {

                    $usridarray=explode(',',$usr);
                    foreach($usridarray as $userid)
                    {
                    $array_data['user_id'] = $userid;
                    $array_data['journal_id'] = $jnl_array['jnl_id'];
                    $array_data['flag'] = TRUE;
                    $array_data['article_id'] = $art_id;
                    $array_data['jnl_code'] = $jnl_array['jnl_code'];
                    $array_data['artp_id'] = $artp_id;

                   $usr_nm = $this->get_user_display_name($array_data);
                   $assigned_user_data_assign[] = $usr_nm;
                    }

            }
        }
        $assigned_user_data_assign = array_map("unserialize", array_unique(array_map("serialize", $assigned_user_data_assign)));
        //if (count($assigned_roles_assign) > 0)
        // $assigned_list=$usr_nm;
        //$assigned_list = implode(',', $assigned_roles_assign);
        $assigned_roles_assign['roles'] = $assigned_roles;
        $assigned_roles_assign['users'] = $assigned_user_data_assign;
        return $assigned_roles_assign;
    }



    public function global_function_for_search_article($location = 'journal_dashboard', $form_post = NULL, $my_task = TRUE, $overview_stg_type = array(), $overview_stg_title = array(), $journal_data = array(), $tile_info = array(),$post_data = array())
    {
        $form_post_conditions = NULL;
        $loading_all_stages = FALSE;
        $filter_key = NULL;
        $only_jnl_admin = FALSE;
        $this->current_user = $this->get_current_user_details();
        $form_post_conditions['conditions'] = FALSE;
        $jnl_id = $journal_data['jnl_id'];
        $jnl_code = $journal_data['jnl_code'];
        $user_id = $this->current_user['user_id'];
        if ($form_post !== NULL) {
            $form_post_conditions = $this->set_search_filter_post_contents($location, $form_post, $my_task, $journal_data,$tile_info);
        }

        $form_post_conditions['art_privileged_user'] = FALSE;
        $form_post_conditions['only_jnl_admin'] = FALSE;
        $form_post_conditions['only_author_role'] = FALSE;
        $form_post_conditions['sort_key'] = FALSE;
        $form_post_conditions['sort_order_by'] = FALSE;
        $form_post_conditions['sort_type_array'] = array();

        $form_post_conditions['journal_stages'] = array();
        $User_journal_sort_keys = new \App\Models\User_journal_sort_keys();
        $User_journal_filter_keys = new \App\Models\User_journal_filter_keys();
        $User_home_filter_sort_keys = new \App\Models\User_home_filter_sort_keys();
        $User_journal_dashboard_tile_sort_keys = new \App\Models\User_journal_dashboard_tile_sort_keys();
        if (isset($journal_data['jnl_id'])) {
            $role_id = NULL;
            if (isset($journal_data['role_id']) && isset($jnl_code)) {
                if (isset($journal_data['role_id'])) {
                    //$logged_user_role = $this->current_user['jnl_user_role'][$jnl_code];
                    $role_id = $journal_data['role_id'];
                }
            }

            $sort = [];
            if(isset($tile_info) && $tile_info == array())
            {
                $condition="ujsk_usr_id={$user_id} AND ujsk_jnl_id={$journal_data['jnl_id']}";
                $resultsort =$User_journal_sort_keys::get_single_record('ujsk_sort_keys', $condition);
                if(!empty($resultsort))
                {
                    // $sortlist=json_decode($resultsort->ujsk_sort_keys, TRUE);
                    $sort_key = (array)json_decode($resultsort->ujsk_sort_keys);

                }
            }
            else
            {
                $section = decrypt_link($post_data['section']);
                $data = 'ujdtsk_usr_id ='.$this->current_user['user_id'].' AND ujdtsk_jnl_id = '.$jnl_id;
                $resultsort = User_journal_dashboard_tile_sort_keys::get_single_record('ujdtsk_sort_keys,ujdtsk_id', $data);
                $section_str =  $section;
                if(isset($post_data['type']) && !empty($post_data['type']))//for overview
                {
                    $type = decrypt_link($post_data['type']);
                    $title_name = decrypt_link($post_data['title']);
                    $section_str = $type . '#' . str_replace(' ','_',$title_name);
                }
                if(!empty($resultsort))
                {
                    $sort_list_tile=(array)json_decode($resultsort->ujdtsk_sort_keys);
                    if(isset($sort_list_tile[$section_str]) && !empty($sort_list_tile[$section_str]))
                    {
                        $sort_key = (array)json_decode($sort_list_tile[$section_str]);
                    }
                }
            }

                if (isset($sort_key) && !empty($sort_key)) {
                    $form_post_conditions['sort_key'] = $sort_key;

                    $sort['sort_type'] = array_keys($sort_key)[0];

                    $sort['sort_order'] = $sort_key[array_keys($sort_key)[0]];
                    $form_post_conditions['sort_type_array'] = $sort;
                }
                else
                {
                //Task#361 - Default sort order configurable for client
                $form_post_conditions['sort_key'] = $this->get_default_sort_order(TRUE);
                }
        }

        if ($location == 'journal_dashboard' || $location == 'inner_list') {

            /*			 * *  Getting user privilege Data **************** */
            $privileged_user = $this->has_journal_privilege($journal_data['jnl_code'], $this->current_user['user_id']);
            $art_privileged_user = $privileged_user;
            $form_post_conditions['art_privileged_user'] = $privileged_user;
            $user_roles = $this->validate_user_journal($jnl_code, $user_id);

            if (in_array('journal_admin', $user_roles['assigned_roles']) && count(array_unique($user_roles['role_id'])) == 1) {

                $only_jnl_admin = TRUE;
            }
            $form_post_conditions['only_jnl_admin'] = $only_jnl_admin;

            $only_author_role = FALSE;
            if (in_array('author', $user_roles['assigned_roles']) && count(array_unique($user_roles['role_id'])) == 1) {
                $only_author_role = TRUE;
            }
            $form_post_conditions['only_author_role'] = $only_author_role;

            $db_label = ($privileged_user == TRUE) ? 'jwf_stage_name' : 'jwf_status_name';
            $loading_all_stages = TRUE;

            /*			 * *  Getting user privilege Data **************** */
        }


        /*		 * *  Getting Saved Filter Data **************** */
        if ($location == 'journal_dashboard') {

            $form_post_conditions['filter_key'] = FALSE;


            if (isset($jnl_id)) {
                $cur_user_profile = $User_journal_filter_keys::get_single_record('ujfk_filter_keys', "ujfk_usr_id={$user_id} AND ujfk_jnl_id={$jnl_id} AND ujfk_role_id={$role_id}");
                //echo $this->db->last_query(); die;
                if ($cur_user_profile != '')
                    $filter_key = json_decode($cur_user_profile->ujfk_filter_keys);
                if ($filter_key != NULL) {
                    $form_post_conditions['filter_key'] = $filter_key;
                    if ($filter_key->article_type != '') {
                        $art_privileged_user = $this->has_journal_privilege($jnl_code, $this->current_user['user_id'], $filter_key->article_type);
                        $form_post_conditions['art_privileged_user'] = $art_privileged_user;
                        $db_label = ($art_privileged_user == TRUE) ? 'jwf_stage_name' : 'jwf_status_name';
                        $article_status = Generic_flows::get_article_type_stages($db_label, array(
                            'artp_id' => $filter_key->article_type
                        ), $db_label);
                        if (!empty($article_status))
                            $form_post_conditions['article_status'] = array_column(json_decode(json_encode($article_status), True), $db_label);
                    }
                }
            }
        } else if ($location == 'user_dashboard') {

            $form_post_conditions['filter_key'] = NULL;
            $form_post_conditions['sort_key'] =  NULL;

            $cur_user_profile = $User_home_filter_sort_keys::get_single_record('uhfs_home_filter_keys', array(
                'uhfs_usr_id' => $this->current_user['user_id']
            ));
            if ($cur_user_profile) {
                $filter_key = json_decode($cur_user_profile->uhfs_home_filter_keys);
                $privileged_user = FALSE;
                $form_post_conditions['filter_key'] =  NULL;
                if ($filter_key != NULL) {
                    $form_post_conditions['filter_key'] = $filter_key;
                    if (!empty($filter_key->sort)) {
                        foreach ($filter_key->sort as $key => $val) {
                            $form_post_conditions['sort_th'] = $key;
                            $form_post_conditions['sort_val'] = $val;
                        }
                    }
                }
            }
            $cur_user_sort_profile = $User_home_filter_sort_keys::get_single_record('uhfs_home_sort_keys', "uhfs_usr_id={$user_id}");
            if (!empty($cur_user_sort_profile)) {
                $sort_key = json_decode($cur_user_sort_profile->uhfs_home_sort_keys);
                $privileged_user = FALSE;
                $form_post_conditions['sort_key'] =  NULL;
                $sort_key = json_decode($cur_user_sort_profile->uhfs_home_sort_keys, TRUE);

                if ($sort_key != NULL) {
                    $form_post_conditions['sort_key'] = $sort_key;
                    $sortlist = (array)$sort_key;
                }
            } else {
                //Task#361 - Default sort order configurable for client
                $form_post_conditions['sort_key'] = $this->get_default_sort_order(TRUE);
            }
        }
        /*		 * *  Getting Saved Filter Data **************** */

        if ($loading_all_stages == TRUE) {
            $form_post_conditions['journal_stages'] = $this->get_all_articletype_stages($db_label, NULL, $overview_stg_type, $overview_stg_title, $journal_data);
        }

        return $form_post_conditions;
    }
    public function set_search_filter_post_contents($location = 'journal_dashboard', $form_post = array(), $my_task = '', $journal_data = array(), $tile_info = array())
    {
        $condition = '';
        $condition_stg = '';
        $condition_order_by = '';

        $jset_date_format =  $this->get_platform_date_format($journal_data['jnl_id']);

        if ($form_post !== NULL) {
            if (isset($form_post['article_code']) && $form_post['article_code'] != "")
                $condition .= ' AND art_code like "%' . htmlspecialchars($form_post['article_code'], ENT_QUOTES) . '%"';
            if (isset($form_post['art_title']) && $form_post['art_title'] != "")
                // $condition .= ' AND art_title like "%' . htmlspecialchars($form_post['art_title'], ENT_QUOTES) . '%"';
                $condition .= ' AND REPLACE(strip_tags(art_title),\'&nbsp;\',\' \') like "%' . htmlentities(trim($form_post['art_title']),ENT_NOQUOTES) . '%"';

            if (isset($journal_data['jnl_id']) && $journal_data['jnl_id'] != "")
                //$condition .= ' AND jnl_id =' . $journal_data['jnl_id'];

                if (isset($form_post['article_type']) && $form_post['article_type'] != "" && $form_post['article_type'] != 0)
                    $condition .= ' AND artp_id =' . $form_post['article_type'];
                if (isset($form_post['special_issue']) && $form_post['special_issue'] != "" )
                {
                    $condition .= ' AND artp_special_issue = "' . $form_post['special_issue'] .'" ';
                }
            //1.Customisation #2201: Pending Assignments
            if (isset($form_post['pending_assignment']) && $form_post['pending_assignment'] != "") {
                $role_id = $form_post['pending_assignment'];
                //2501 Add Awaiting assignment tile
                $stage_assign = ' (aflw_status = \'p\' AND jwf_role_id =' . $role_id . ')';
                $art_assign = ' (aflw_status = \'a\' AND asgm_assgnd_role = ' . $role_id . ')';

                $condition .= ' AND (' . $stage_assign . ' OR ' . $art_assign . ' )';
            }

            if (isset($form_post['stage_name']) && $form_post['stage_name'] != "" && $form_post['stage_name'] != 0)
                $condition_stg .= ' like \'' . $form_post['stage_name'] . '\'';

            if (isset($form_post['status_name']) && $form_post['status_name'] != "" && $form_post['status_name'] != 0)
                $condition_stg .= ' like \'' . $form_post['status_name'] . '\'';

            if (isset($form_post['date']) && $form_post['date'] != "" && $form_post['date'] != "0") {
                if (!empty($form_post["end_date"]) || !empty($form_post["start_date"])) {
                    switch ($form_post['date']) {
                        case 'aflw_due_date':
                            //							$condition .= ' AND `aflw_status` NOT IN ("w","p")';
                            $condition .= ' AND `aflw_status` NOT IN ("p")';
                            break;
                        case 'aflw_accepted_date':
                            $condition .= ' AND aflw_accepted_date is NOT NULL ';
                            break;
                        case 'aflw_assigned_date':
                            $condition .= ' AND aflw_assigned_date is NOT NULL ';
                            $condition .= ' AND art_status !="n" ';
                            break;
                        default:
                            break;
                    }
                }

                if (
                    isset($form_post["start_date"]) &&
                    $form_post["start_date"] != "" &&
                    (!isset($form_post["end_date"]) or $form_post["end_date"] == "")
                ) {
                    if ($location == 'journal_dashboard' || $location == 'inner_list')
                        $condition .= ' AND ' . $form_post['date'] . ' like \'%' . convert_dmy_to_ymd($form_post["start_date"], $jset_date_format) . '%\'';
                    else
                        $condition .= ' AND ' . $form_post['date'] . ' like \'%' . convert_dmy_to_ymd($form_post["start_date"],  $this->current_client->settings->cs_date_format) . '%\'';
                } else if (
                    isset($form_post["end_date"]) &&
                    $form_post["end_date"] != "" &&
                    (!isset($form_post["start_date"]) || $form_post["start_date"] == "")
                ) {
                    if ($location == 'journal_dashboard' || $location == 'inner_list')
                        $condition .= ' AND ' . $form_post['date'] . ' like \'%' . convert_dmy_to_ymd($form_post["end_date"], $jset_date_format) . '%\'';
                    else
                        $condition .= ' AND ' . $form_post['date'] . ' like \'%' . convert_dmy_to_ymd($form_post["end_date"],  $this->current_client->settings->cs_date_format) . '%\'';
                } else if (
                    isset($form_post["start_date"]) &&
                    $form_post["start_date"] != "" &&
                    isset($form_post["end_date"]) && $form_post["end_date"] != ""
                ) {

                    //$condition .= ' AND ' . $form_post['date'] . ' BETWEEN \'' . convert_dmy_to_ymd($form_post["start_date"], $this->jnl_data->jset_date_format) . '\'' . ' AND \'' . convert_dmy_to_ymd($form_post["end_date"], $this->jnl_data->jset_date_format) . '\'';
                    if (($location == 'journal_dashboard' || $location == 'inner_list') && isset($jset_date_format))
                        $condition .= ' AND DATE_FORMAT(' . $form_post['date'] . ',"%Y-%m-%d") >= "' . convert_dmy_to_ymd($form_post["start_date"], $jset_date_format) . '" AND DATE_FORMAT(' . $form_post['date'] . ',"%Y-%m-%d") <= "' . convert_dmy_to_ymd($form_post["end_date"], $jset_date_format) . '" ';
                    else
                        $condition .= ' AND DATE_FORMAT(' . $form_post['date'] . ',"%Y-%m-%d") >= "' . convert_dmy_to_ymd($form_post["start_date"], $this->current_client->settings->cs_date_format) . '" AND DATE_FORMAT(' . $form_post['date'] . ',"%Y-%m-%d") <= "' . convert_dmy_to_ymd($form_post["end_date"], $this->current_client->settings->cs_date_format) . '" ';
                }
            }
            if(empty($condition_order_by))
			{
                if(isset($tile_info['type']) && $tile_info['type'] == 'transit' && isset($tile_info['section_id']) && $tile_info['section_id'] == 'overview' && $location == 'inner_list')
                {
                    $condition_order_by = '';
                }
                else
                {
                $condition_order_by = ' aflw_due_date ASC';
                }
            }
            if (isset($form_post['sort_order']) && $form_post['sort_order'] !== "") {

                $array_order = $form_post['sort_order'];
            if (isset($this->current_client->functionality->cfty_show_minimised_sort)&&($this->current_client->functionality->cfty_show_minimised_sort == 'y'))
            {
                $condition_order_by =  $array_order['sort_type'] . " " . $array_order['order'];
            }
            else
            {
                if (is_array($array_order['sort_type']) || is_object($array_order['sort_type']))
                {
                    $sort_type = implode(' '.$array_order['order'].',', $array_order['sort_type']);
                    $sort_type .= ' '.$array_order['order'];
                    $condition_order_by =  $sort_type;
                }
            }


                //				$condition_order_by = ' ORDER BY aflw_due_date ' . $form_post['sort_order'];
                //	$condition_order_by = ' ORDER BY ' . $form_post['sort_order'];
            }

            if (isset($form_post['my_task']) && $form_post['my_task'] == "0") {
                $my_task = FALSE;
            }
        }

        $return_arr = array(
            'conditions' => $condition,
            'condition_stage' => $condition_stg,
            'condition_order_by' => $condition_order_by,
            'my_task' => $my_task,
        );

        return $return_arr;
    }


    //Task#361 - Default sort order configurable for client
    public function get_default_sort_order($reset = FALSE, $get_sort_order_frm_utility = FALSE)
    {
        $new_order = array();
        $pltfrm     =   '';
        if(isset($this->current_client->platform_type) && $this->current_client->platform_type == 'conference') {
            $pltfrm =   '_conference';
        }
        $default_sort_order = 'clients.' . $this->current_client->clnt_client_code . '.default_sort_order.default_sort_order_list'.$pltfrm;
        $default_sort_order_list = Config::get($default_sort_order);

        $sort_list_item = sort_items();
        if (!empty($default_sort_order_list)) {
            $default_sort_by = $default_sort_order_list['sort_by'];
            if ($reset == TRUE) {
                foreach ($default_sort_by as $k => $v) {
                    $new_order[$v] = $default_sort_order_list['sort_order'];
                }
            } else {
                $new_order['article_sort'] = $default_sort_by;
                $new_order['sort_order']   = $default_sort_order_list['sort_order'];
                $new_order['user_sort']   = $sort_list_item['user_sort'];
            }
        } elseif ($get_sort_order_frm_utility == TRUE) {
            $new_order  = $sort_list_item;
        }
        return $new_order;
    }

    public function get_all_articletype_stages($stage, $artp_id = NULL, $core_stages_arr = array(), $stage_name_arr = array(), $journal_data = array())
    {
        //$logged_user_role = $this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code];
        $role_id = $journal_data['role_id'];

        if (!empty($core_stages_arr) && count($core_stages_arr) == 0) {
            $curr_role_used = Roles::get_single_record('role_used_in', "role_id={$role_id}");

            if (count($curr_role_used) > 0) {
                if ($curr_role_used->role_used_in != '') {
                    $temp = explode(',', $curr_role_used->role_used_in);

                    $core_stages = $this->get_production_stages_keys(NULL, FALSE, TRUE);
                    if (count($temp) == 1 && in_array('r', $temp)) {
                        $core_stages_arr = $core_stages['review'];
                    } elseif (count($temp) == 1) {
                        $core_stages_arr = $core_stages['production'];
                    }
                }
            }
        }

        $condition = 'artp_jnl_id = ' . $journal_data['jnl_id'] . ' AND jwf_stage_type !="author_submission"';

        if ($artp_id != NULL) {
            $condition .= ' AND artp_id = ' . $artp_id;
        }

        if (count($core_stages_arr) > 0) {
            $condition .= ' AND jwf_stage_type IN (\'' . implode('\',\'', $core_stages_arr) . '\')';
        }

        if (count($stage_name_arr) > 0) {
            $condition .= ' AND jwf_stage_name IN (\'' . implode('\',\'', $stage_name_arr) . '\')';
        }
        $article_type_table = (new \App\Models\Article_types())->getTable();
        $gneneric_flow_table = (new \App\Models\Generic_flows())->getTable();
        $sql_stages = 'SELECT GROUP_CONCAT(jwf_id) AS jwf_id,' . $stage . ' FROM ' . $article_type_table . ' JOIN ' . $gneneric_flow_table . ' ON artp_fwm_id = jwf_fwm_id WHERE ' . $condition . ' GROUP BY ' . $stage;

        $stage_data = Article_types::get_records_by_raw_query($sql_stages);

        return $stage_data;
    }
    public function get_production_stages_keys($workflow = NULL, $review_stage = FALSE, $both = FALSE)
    {
        if (empty($workflow)) {
            $workflowconfig = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $workflow = Config::get($workflowconfig);
        }
        $prdn_stages = array();
        if (!empty($workflow)) {
            foreach ($workflow as $k => $v) {
                if ($both == FALSE) {
                    if ($review_stage == TRUE) {
                        if (isset($v['stage_for']) && $v['stage_for'] == 'review') {
                            $prdn_stages[] = $k;
                        }
                    } else {
                        if (isset($v['stage_for']) && $v['stage_for'] == 'manageproduction') {

                            $prdn_stages[] = $k;
                        }
                    }
                } else {
                    if (isset($v['stage_for']) && $v['stage_for'] == 'manageproduction') {
                        $prdn_stages['production'][] = $k;
                    } else {
                        $prdn_stages['review'][] = $k;
                    }
                }
            }
        }
        return $prdn_stages;
    }

    public function get_platform_date_format($jnl_id = NULL)
    {
        $platform_date_format = '';
        if($jnl_id != NULL)
        {
            $Journal_settings = new \App\Models\Journal_settings();
            //$platformdata = $Journal_settings::get_single_record('jset_date_format', "jset_jnl_id={$jnl_id}");
            $platformdata = $Journal_settings::get_single_record('jset_date_format', "jset_jnl_id=?",binding_arr:[$jnl_id]); // 7017 SQL Injection Fix
            if (!empty($platformdata)) {
                if (isset($platformdata->jset_date_format) && $platformdata->jset_date_format != '') {
                    $platform_date_format = $platformdata->jset_date_format;
                } else {
                    $platform_date_format = $this->current_client->settings->cs_date_format;
                }
            }
        }
        else
        {
            $platform_date_format = $this->current_client->settings->cs_date_format;
        }

        return $platform_date_format;
    }

    public function check_assignment_tab_visibility($flow_data, $to_assign, $current_tab = "")
    {
        $returnarr=array();
        if ($flow_data->artp_id != '' && !empty($to_assign) && $flow_data->artp_fwm_id != '') {
            foreach ($to_assign as $tk => $tv) {
                //echo '<pre>'; print_r($to_assign); die;
                $this->roleids = array();
                $this->completed = array();
                $this->tocomplete = array();
                $where = 'jwf_fwm_id=' . $flow_data->artp_fwm_id;
                if ($current_tab != "") {
                    $where .= " and jwf_stage_type='" . $current_tab . "'";
                }
                $where .= ' and jwf_role_id=' . $tv->role_id;
                $journal_flow_details = Generic_flows::get_single_record('jwf_id', $where);
                $exclude_ids = array();
                if (!empty($journal_flow_details)) {
                    $first_flow_id = Article_flow::get_single_record('aflw_status,aflw_art_id,aflw_level,aflw_jwf_id', 'aflw_art_id=' . $flow_data->art_id . ' and aflw_id=' . $flow_data->aflw_id);
                    if (!empty($first_flow_id)) {
                        $aflw_where = 'aflw_art_id=' . $flow_data->art_id;
                        $aflw_where .= ' and aflw_level <' . $first_flow_id->aflw_level;
                        $article_flow = Article_flow::get_all_records('aflw_art_id,aflw_level,aflw_jwf_id', $aflw_where);
                        if (!empty($article_flow)) {
                            foreach ($article_flow as $exc) {
                                // The current flow status is active, and the current flow JWF ID exists in the excluded JWF IDs. Remove the JWF ID from the excluded list and add this user role to the array.
                                if(in_array($first_flow_id->aflw_status, array('u','a')) && $first_flow_id->aflw_jwf_id==$exc->aflw_jwf_id){
                                    array_push($this->roleids, $tv->role_id);
                                } else {
                                    $exclude_ids[] = $exc->aflw_jwf_id;
                                }
                            }
                        }
                    }
                }
                $this->assignment_tab_visible($flow_data->artp_id, $current_tab, $flow_data->artp_fwm_id, "", $exclude_ids);
                if (!in_array($tv->role_id, $this->roleids)) {
                   unset($to_assign[$tk]);
                    
                }
                
            }
            foreach($to_assign as $tk => $tv)
            {
                $returnarr[]= $tv;
            }
        }
        //die;
        return $returnarr;
    }

    public function assignment_tab_visible($artp_id, $current_tab = "", $jnl_fwm_id = NULL, $child_id = "", $exclude_array = array())
    {

        $where = 'jwf_fwm_id =' . $jnl_fwm_id;
        if ($current_tab != "") {
            $where .= ' AND jwf_stage_type = "' . $current_tab . '"';
        }
        if ($child_id != "") {
            $where .= '  AND jwf_id =' . $child_id;

        }
        $journal_flow_data = array();
        if (!empty($exclude_array) && empty($child_id)) {
            $where .= ' AND jwf_id NOT IN  (' . join(",", $exclude_array) . ')';
        }
        $genric_table = (new \App\Models\Generic_flows())->getTable();
        $af_sql = "SELECT jwf_id,jwf_child_stages,jwf_role_id,jwf_parent_user_roles,jwf_who_can_invite,jwf_stage_name,jwf_parent_stages FROM " . $genric_table . ' WHERE ' . $where . ' ';
        $journal_flow_datas = Generic_flows::get_records_by_raw_query($af_sql);
        if (!empty($journal_flow_datas)) {
            foreach ($journal_flow_datas as $journal_flow_data) {
                $parent_roles = (isset($journal_flow_data->jwf_parent_user_roles) && $journal_flow_data->jwf_parent_user_roles != NULL) ? json_decode($journal_flow_data->jwf_parent_user_roles) : array();
                $who_can_invite = (isset($journal_flow_data->jwf_who_can_invite) && $journal_flow_data->jwf_who_can_invite != NULL) ? json_decode($journal_flow_data->jwf_who_can_invite) : array();

                array_push($this->roleids, $journal_flow_data->jwf_role_id);
                array_push($this->completed, $journal_flow_data->jwf_id);

                $this->tocomplete = array_diff($this->tocomplete, array(
                    $journal_flow_data->jwf_id
                ));
                $this->roleids = array_unique(array_merge($parent_roles, $who_can_invite, $this->roleids));
                if ($journal_flow_data->jwf_child_stages != NULL) {
                    $childstages = json_decode($journal_flow_data->jwf_child_stages);
                    if (!empty($childstages)) {
                        foreach ($childstages as $ch) {
                            if (!in_array($ch, $this->completed)) {
                                array_push($this->tocomplete, $ch);
                            }
                        }
                    }
                }
            }

            if (count($this->tocomplete) > 0) {
                foreach ($this->tocomplete as $to) {
                    $this->tocomplete = array_diff($this->tocomplete, array(
                        $to
                    ));
                    $this->assignment_tab_visible($artp_id, "", $jnl_fwm_id, $to, $exclude_array);
                }
            }
        }
    }
    public function get_tat_dates($stage_id = null)
    {

        $tat = 0;
        if ($stage_id != null) {
            $table_name = (new \App\Models\Generic_flows())->getTable();
            $query = "SELECT (jwf_tat_accept+jwf_tat_complete) as TAT FROM " . $table_name . " WHERE `jwf_id` = $stage_id LIMIT 1";

            $flow = Generic_flows::get_records_by_raw_query($query);
            if (isset($flow[0]))
                $tat = ($flow[0]->TAT);
        }
        $date_from = new \DateTime();
        $date_from = $date_from->format('Y-m-d');
        $tat_dates[] = $date_from;
        $date_to = new \DateTime();
        $date_to->modify("+$tat day");
        $date_to = $date_to->format('Y-m-d');
        $date_from = strtotime($date_from);
        $date_to = strtotime($date_to);
        for ($i = $date_from; $i <= $date_to; $i += 86400) {

            $tat_dates[] = date("Y-m-d", $i);
        }
        return $tat_dates;
    }

    public function get_users_unavailability($user_id, $tat_dates)
    {
        $Users_unavailability = new \App\Models\Users_unavailability();
        $userunavailability_table = ($Users_unavailability)->getTable();
        if (!empty($tat_dates)) {
            // $unavailability_query = 'SELECT *
            // FROM ' . $userunavailability_table . '
            // WHERE `unavail_user_id` = ' . $user_id;
            $unavailability_query = 'SELECT *
            FROM ' . $userunavailability_table . '
            WHERE `unavail_user_id` = ?';
            $i = 0;
            foreach ($tat_dates as $k => $d) {
                $i++;
                $con = ' AND(';
                if ($i > 1) {
                    $con = ' OR ';
                }
                $unavailability_query .= $con . '   (  `unavail_start_date`<= "' . $d . '" AND   `unavail_end_date`  >= "' . $d . '")';
            }
            $unavailability_query .= ')';
            return $Users_unavailability::get_records_by_raw_query($unavailability_query,binding_arr:[$user_id]);
        } else {
            return NULL;
        }
    }
    public function get_column_array($obj, $column)
    {
        return array_column(json_decode(json_encode($obj), true), $column);
    }

    public function validate_exist_user($user_id)
    {
        $return_array = array();
        $User = new \App\Models\User();

        if (is_numeric($user_id) != true) {
            return false;
        }
        $check_user = $User::get_single_record('count(usr_id) as cnt', "usr_id={$user_id}");
        if ($check_user->cnt > 0)
            return true;
        else
            return false;
    }
    public function verifyDate($value)
    {
        if ($value instanceof DateTimeInterface) {
            return true;
        }

        try {
            if ((!is_string($value) && !is_numeric($value)) || strtotime($value) === false) {
                return false;
            }
        } catch (Exception $e) {
            return false;
        }

        $date = date_parse($value);

        return checkdate($date['month'], $date['day'], $date['year']);
    }
    public function set_user_loggin($user_id)
    {
        $Authorize = new \App\Models\Authorize();
        $user = $Authorize::where('usr_id', $user_id)->get()->first();

        $return_array = array();
        if (!empty($user)) {
            $token = JWTAuth::fromUser($user);
            $token = JWTAuth::customClaims(['user_id' => $user->usr_id, 'proxy_user_id' => $user->usr_id])->fromUser($user);
            $client_functionality = $this->get_client_functionalities($this->current_client->clnt_id, $this->current_client->clnt_client_code);
            $return_array['client_functionality'] = $client_functionality;
            $return_array['module_status'] = $this->current_client->modules;
            $return_array['token'] = $token;
            $return_array['profile_data'] = $this->set_profile_data($user_id, $user_id);
        } else {
            $return_array['token'] = '';
            $return_array['client_functionality'] = '';
            $return_array['module_status'] = '';
            $return_array['profile_data'] = '';
        }
        return  $return_array;
    }
    public function set_profile_data($user_id, $proxi_id)
    {
        $userdata = array();
        $select = 'usr_id,usr_f_status,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name)as fullname ,usr_title,usr_username, usr_first_name, usr_middle_name,usr_last_name,usr_email,usr_phone_no,usr_image,usr_institution,usr_jnl_standalone,usr_last_review_invite,usr_postal_code,usr_pwd_original,usr_roles,usr_status,usr_terms_condition,usr_url,usr_orcid_id,DATE(usr_reg_date) AS usr_reg_date,usr_deeplink_token,usr_website';
        $criteria = 'usr_id=' . $user_id;
        $userdata = User::get_single_record($select, $criteria);
        $file_retrieval = '';
        $file_path = Config::get('general_config.file_retrieval');
        $userdata->usr_image=$this->get_profile_image($userdata,$user_id);
        if (isset($proxi_id) && ($proxi_id != ''))
            $userdata->usr_proxy_id = (int)$proxi_id;
        return $userdata;
    }
    public function user_login_check($curren_user)
    {
        $this->current_user = $curren_user;
        $User_meta = new \App\Models\User_meta();
        $Userkeywords = new \App\Models\Userkeywords();
        //* start checking profile complete user meta && user_keywords *//
        $user_meta_data = $User_meta::get_single_record('count(urg_id) as cnt', "urg_user_id={$this->current_user->usr_id} AND urg_data!=NULL");

        /* $general_settings = $this->General_settings->get_single_record('*', array(
		  'gnl_id' => 1)); */

        $keyword_count = $Userkeywords::get_single_record('count(ukwd_id) as cnt', "ukwd_usr_id={$this->current_user->usr_id}");
        $keyword_flag = TRUE;
        if ($this->current_client->settings->cs_min_keyword > $keyword_count->cnt)
            $keyword_flag = FALSE;


        $usr_role = array();
        $sudo_login = FALSE;
        //$sudo_proxy = $this->session->userdata('sudo_proxy_user');

        //**$sudo_login  FOR SUDO ADMIN LOGIN**//
        /*if (count($sudo_proxy) > 0)
			$sudo_login = TRUE;
*/
        if ($this->current_user->usr_roles != NULL) {
            $usr_role = json_decode($this->current_user->usr_roles);
        }

        $user_full_name = $this->current_user->usr_first_name . ' ' . $this->current_user->usr_last_name;
        //	$login_session = $this->set_login_session_data($this->current_user);
        //* stop  profile complete user meta && user_keywords *//
        $login_session = array();
        if (($keyword_flag == FALSE) && !in_array('super_admin', $usr_role) && !in_array('sudo', $usr_role)) {
            $login_session['wrg_msg_profile_keyword'] = customTrans('users.profile-not-complete');
        }
        //* stop  profile complete user meta && user_keywords *//
        //$this->session->set_userdata('logged_user', $login_session);

        $reditect_url = '';

        if ($this->current_user->usr_status == 'w' && $this->current_user->usr_f_status == 'n') {
            $user_email = $this->current_user->usr_email;
            //$login_session['wrg_msg_profile_not_active'] = 'Dear ' . $user_full_name . str_replace('REPLACE_EMAIL',$user_email,lang('act_error_msg'));
            $login_session['wrg_msg_profile_not_active'] = str_replace('REPLACE_EMAIL', $user_email, customTrans('users.act_error_msg'));
            $login_session['reditect_url'] = 'profile';
            $login_session['usertoken'] = $this->set_user_loggin($this->current_user->usr_id);
            //$this->set_user_session_data($login_session, TRUE);
            //$this->login_tracker('in');
            //redirect(site_url($reditect_url), 'refresh');
        } else if ($this->current_user->usr_f_status == 'y' && $sudo_login == FALSE && ($this->current_user->usr_status == 'w' || $this->current_user->usr_status == 'a')) {
            $login_session['reditect_url'] = 'change-password?' . encrypt_link('&userid=' . $this->current_user->usr_id . '&user_name=' . $this->current_user->usr_username . '&terms_agreed=' . $this->current_user->usr_terms_condition);

            //	$this->set_user_session_data($login_session, TRUE);
            //$this->login_tracker('in');
            //redirect(site_url($reditect_url), 'refresh');
        } else {
            $login_session['reditect_url'] = $reditect_url;
            //	$this->set_user_session_data($login_session, TRUE);
            //	$this->login_tracker('in');
            //redirect(site_url($reditect_url), 'refresh');
        }
        return $login_session;
    }
   public function get_profile_image($userdata,$user_id)
   {
    if (isset($userdata->usr_image)) {
        $usr_image = $this->get_upload_data('users/' . $user_id . '/pic_' . $userdata->usr_image);
        $exists=false;
        $filePath = '';
         $path = $this->get_upload_path('uploads/users/' . $user_id . '/');
         $filePath = $path . 'pic_' .$userdata->usr_image;
         if($filePath != '' && $this->current_client->enable_upload_s3_bucket == 'y'){
             $headers = get_headers($filePath);
             //$exists = strpos($headers[0], '200 OK') !== false;
             $exists = storage::disk('s3')->exists('uploads/users/' . $user_id . '/pic_' . $userdata->usr_image);
            }else{
                $exists = $this->file_exist_folder($path,'pic_' .$userdata->usr_image);
            }
       $userdata->usr_image = ($exists) ? $usr_image : '/img/photo_tiny.jpg';

    }
     else
     {
        $userdata->usr_image = '/img/photo_tiny.jpg';
     }
     return $userdata->usr_image;
   }
   /* check submit production article previlage */
	public function check_submit_article_production($user_role=NULL)
	{
		$show_production_submission=FALSE;


		$core_role = $user_role;
                //#3422 permission limited to Staff and Journal Admin only
        $sfp_permitted_roles    =   array('staff', 'journal_admin');
			if (isset($this->current_client->functionality->cfty_enable_submit_production_article) && ($this->current_client->functionality->cfty_enable_submit_production_article == 'y') && isset($core_role)&&(in_array($core_role,$sfp_permitted_roles)))
		 {
				$show_production_submission=TRUE;;
		 }

		return $show_production_submission;
	}
    public function check_article_editable($articletype_id, $article_id, $non_author_privileged_user = NULL, $article_files = FALSE, $platform_code = '')
    {
        $this->current_user = $this->get_current_user_details();
        $editable_column = 'jp_edit_articles';
        if ($article_files == TRUE) //for checking article file editable
            $editable_column = 'jp_edit_article_files';
        // $where_cnd = "jnl_journal_code = '" . $platform_code . "'";
        $where_cnd = "jnl_journal_code = ?";
        // $journal_data = Journals::get_single_record('*', $where_cnd);;
        $journal_data = Journals::get_single_record('*', $where_cnd,binding_arr:[$platform_code]);

        /* start -- check if article is editable
		 * case: author; either in any of stage, [author_submission, revision (with edit permission), resubmission] the article should be in "in progress"
		 * case: staff; checking journl permission with staff role. Article stub created by staff. ie, posted by staff
		 */

        // start -- get currnet users role ids


        $current_user_roles = User_to_journals::get_user_role_classification($articletype_id, 'a', array($this->current_user['user_id']));

        if (!empty($current_user_roles)) {
            $current_user_roles = $current_user_roles[0];

            $user_roles = explode(';', $current_user_roles->role_assigned_role);
            $user_roles_ids = explode(';', $current_user_roles->role_ids);
        }
        // end -- get currnet users role ids

        // $check_posted_by = Articles::get_single_record('art_submitted_by', 'art_id=' . $article_id . ' AND art_submitted_by=' . $this->current_user['user_id']);
        $check_posted_by = Articles::get_single_record('art_submitted_by', 'art_id= ? AND art_submitted_by=' . $this->current_user['user_id'],binding_arr:[$platform_code]);
        $edit_flag = FALSE;
        if (!empty($user_roles) && in_array('author', $user_roles) && !empty($check_posted_by)) {
            //2014 Journals production can edit permission (in production rivision stage(pro_rivision)) allow user edit if allowed in workflow
            $sql_txt = ' jwf_stage_type = "revision"';
            if ($this->current_client->modules->mdl_production == 'y') {
                $sql_txt = '(jwf_stage_type = "revision" OR jwf_stage_type = "pro_revision")';
            }

            // check if article is in ["author_submission", "revision", "resubmission"]
            $where = 'aflw_art_id = ' . $article_id
                . ' AND aflw_status != "c"'
                . ' AND (jwf_stage_type IN ("author_submission", "resubmission")'
                . ' OR ( ' . $sql_txt . ' AND jwf_article_editable = 1))';

            $autor_edit_stages = Article_flow::get_generic_flow('aflw_id', $where);

            //	if ($autor_edit_stages && $article_files == FALSE)Bug #1030 - IET0177 - Resubmitted/Revised Papers
            if ($autor_edit_stages) {
                $edit_flag = TRUE;
            }
        }

        $non_author_privileged_user = $non_author_privileged_user == NULL ? $this->is_non_author_privileged_user($article_id) : $non_author_privileged_user;
        if ($non_author_privileged_user != NULL && $non_author_privileged_user) {
            // $posted_by_staff = Articles::get_single_record('art_id, art_status,art_artp_id', 'art_id=' . $article_id . ' AND art_posted_by=' . $this->current_user['user_id']);
            $posted_by_staff = Articles::get_single_record('art_id, art_status,art_artp_id', 'art_id= ? AND art_posted_by=' . $this->current_user['user_id'],binding_arr:[$article_id]);
            $permission_roles = Journal_permission::get_single_record($editable_column, 'jp_jpm_id=' . $journal_data->jnl_jpm_id);

            $journal_settings_table = (new \App\Models\Journal_settings())->getTable();
            $article_type_table = (new \App\Models\Article_types())->getTable();
            $sql_quer = 'SELECT jset_create_article_stub FROM ' . $journal_settings_table . ' WHERE jset_jnl_id = (SELECT artp_jnl_id FROM ' . $article_type_table . ' WHERE artp_id = ' . $articletype_id . ')';
            $stub_permitted = $art_stub_user = $art_stub_user_array = array();
            $art_stub_user = Journal_settings::get_records_by_raw_query($sql_quer);
            $art_stub_user_array = (!empty($art_stub_user)) ? json_decode($art_stub_user[0]->jset_create_article_stub) : array();
            $stub_permitted = (!empty($user_roles_ids) && !empty($art_stub_user_array)) ? array_intersect($user_roles_ids, $art_stub_user_array) : array();
            // $check_author_submission = Article_flow::get_single_record('aflw_id', 'aflw_art_id=' . $article_id);
            $check_author_submission = Article_flow::get_single_record('aflw_id', 'aflw_art_id= ?',binding_arr:[$article_id]);

            if ($this->current_client->modules->mdl_review_for_doc == 'y' && !empty($posted_by_staff)) {
                $edit_flag = TRUE;
            } else if (isset($permission_roles->$editable_column) && $permission_roles->$editable_column != NULL) {
                if ($article_files == FALSE && ($this->check_journal_permission_with_role_ids(json_decode($permission_roles->$editable_column), $platform_code, $articletype_id) || (!empty($user_roles) && in_array('staff', $user_roles) && !empty($posted_by_staff) && in_array($posted_by_staff->art_status, array(
                    'c',
                    'r'
                )) === FALSE)
                )) {
                    $edit_flag = TRUE;
                } elseif (
                    $article_files == TRUE && $this->check_journal_permission_with_role_ids(json_decode($permission_roles->$editable_column), $platform_code, $articletype_id) //only for article file editable
                ) {
                    $edit_flag = TRUE;
                }
            } else if (!empty($posted_by_staff) && $posted_by_staff->art_status == 'n' && !empty($stub_permitted) && empty($check_author_submission)) { //Article Stub
                $edit_flag = TRUE;
            }
        }
        return $edit_flag;
    }
    //select workflow assignment based on client functionality and stage type
    public function workflow_assignment_type_seletion_status($current_stage = NULL)
    {
        $source_assign_status = FALSE;
        $destination_assign_status = FALSE;
        if (isset($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers) && ($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers == 'y'))
        {
            $source_select_stage = Config::get('general_config.workflow_assignment_type_source_select');
            $destination_select_stage = Config::get('general_config.workflow_assignment_type_destination_select');
            if(in_array($current_stage,$source_select_stage))
            {
                $source_assign_status = TRUE;
            }
            elseif(in_array($current_stage,$destination_select_stage))
            {
                $destination_assign_status = TRUE;
            }
        }
        $return_arr['source_assign_status'] = $source_assign_status;
        $return_arr['destination_assign_status'] = $destination_assign_status;
        return $return_arr;
    }
    public function process_form_element_data($elementid, $formdetails, $elementdata)
    {
        try {
        $temp_value = array();
        $temp_display_value = array();

        $elementvalue = $formdetails;
        $element_dply_data = $formdetails;


        $return_arr = array(
            'elementvalue' => '',
            'element_dply_data' => '',
        );
        if (empty($elementdata)) {
            exit;
        }
        //If checkbox is the input element means getting data text for the corresponding value from db
        if (isset($formdetails) && !empty($formdetails)) {
            if ($elementdata->emt_element_type == 'checkbox' && $elementdata->emt_id == $elementid) {
                $optionvaluechk = json_decode($elementdata->emt_options);
                /// start -- data arrange///
                //$temp_value = array();
                //$temp_display_value = array();
                foreach ($optionvaluechk as $optchk) {
                    foreach ($optchk as $keychk => $optckresult) {

                        /*foreach ($optchk as $keychk => $optckresult) {
                            if(!is_array($keychk)){
                                $temp_value[] = $keychk;
                                $temp_display_value[] = $optckresult;
                            } else if (in_array($keychk, $formdetails)) {
                                $temp_value[] = $keychk;
                                $temp_display_value[] = $optckresult;
                            }
                        }*/
                        if(is_string($formdetails)){
                            $formdetails=explode(',',$formdetails);
                        }
                        if (in_array($keychk, $formdetails)) {
                            $temp_value[] = $keychk;
                            $temp_display_value[] = $optckresult;
                        }

                    }
                }


                $elementvalue = $temp_value;
                $element_dply_data = $temp_display_value;
            } elseif ($elementdata->emt_element_type == 'combobox' && $elementdata->emt_id == $elementid) {
                //If combobox is the input element means getting data text for the corresponding value from db
                //$temp_value = array();
                //$temp_display_value = array();

                $populate_tables = $this->Utility('populate_tables');
                $pop_all_keys = array_keys($populate_tables['populate_tables']);
                    foreach($pop_all_keys as $key => $value){
                        $pop_data = $populate_tables['populate_tables'][$value];
                        if (in_array($elementdata->emp_populate_from_table, array_keys($pop_data))) {
                            $elementdata->emt_options = $this->populate_options_from_table($elementdata, $pop_data);
                        }
            }

                $optionvaluecom = json_decode($elementdata->emt_options);
                foreach ($optionvaluecom as $keycom => $optcom) {
                    foreach ($optcom as $combkey => $optcomresult) {
                        if ($formdetails == $combkey) {
                            $temp_value[] = $combkey;
                            $temp_display_value[] = $optcomresult;
                        }
                    }
                }
                $elementvalue = $temp_value;
                $element_dply_data = $temp_display_value;
            } elseif ($elementdata->emt_element_type == 'radiobutton' && $elementdata->emt_id == $elementid) {
                //If radiobutton is the input element means getting data text for the corresponding value from db
                $optionvaluerad = json_decode($elementdata->emt_options);
                foreach ($optionvaluerad as $keyrad => $optrad) {
                    foreach ($optrad as $radkey => $optresultrad) {
                        if ($formdetails == $radkey) {
                            $temp_value[] = $radkey;
                            $temp_display_value[] = $optresultrad;
                        }
                    }
                }
                $elementvalue = $temp_value;
                $element_dply_data = $temp_display_value;
            }

            if (is_array($elementvalue))
                $elementvalue = implode(',', $elementvalue);
            if (is_array($element_dply_data))
                $element_dply_data = implode(',', $element_dply_data);

            $return_arr['elementvalue'] = $elementvalue;
            $return_arr['element_dply_data'] = $element_dply_data;
        }
        return $return_arr;
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
    }

    function populate_options_from_table($element, $populate_tables)
    {
        $populate_table = $populate_tables[$element->emp_populate_from_table];

        //$populate_table = array_values($populate_table);
        //$populate_table = $populate_table[0];

        $populate_table_model = $populate_table['model'];
        $select = $populate_table['key'] . ',' . $populate_table['value'];
        $model_name = '\\App\Models\\' . $populate_table_model;
        $populate_table_model = (new $model_name());

        //$populate_table_model = explode("/", $populate_table_model);
        //$populate_table_model = $populate_table_model[sizeof($populate_table_model) - 1];
        $result = $populate_table_model::get_all_records($select, array(), $populate_table['order_by']);
        foreach ($result as $res) {
            $key = $res->{$populate_table['key']};
            $res->$key = $res->{$populate_table['value']};
            unset($res->{$populate_table['key']});
            unset($res->{$populate_table['value']});
        }
        return json_encode($result);
    }

    public function get_all_version_art_ids($art_id = '')
    {
        $article_ids = $art_id;
        $curnt_art_details = Articles::get_single_record('art_id,art_pre_all_ids', 'art_id =' . $art_id . ' OR FIND_IN_SET(' . $art_id . ',art_pre_all_ids)', '', '', 'art_id DESC');
        if (isset($curnt_art_details->art_pre_all_ids) && !empty($curnt_art_details))
            $article_ids .= ',' . $curnt_art_details->art_pre_all_ids . ',' . $curnt_art_details->art_id;
        return $article_ids;
    }

    public function check_user_production_status($article_id, $user_id)
    {
        $Articles = new \App\Models\Articles();
        $User_to_journals = new \App\Models\User_to_journals();
        $Roles = new \App\Models\Roles();
        $article_details = $Articles::get_single_record('art_artp_id', "art_id={$article_id}");
        if (!empty($article_details)) {
            $journal_usr_details = $User_to_journals::get_single_record('group_concat(usrj_role_id) as usr_roles', "usrj_artp_id={$article_details->art_artp_id} AND usrj_usr_id={$user_id}");
            if (!empty($journal_usr_details)) {
                $roles_ids = $journal_usr_details->usr_roles;
                if (!empty($roles_ids)) {
                    $select_role = "group_concat(role_used_in) role_used_in";
                    $where_condition = ' role_id IN(' . $roles_ids . ')';
                    $roles = $Roles::get_single_record($select_role, $where_condition);
                    if (!empty($roles)) {
                        $user_assigned_roles_in = explode(",", $roles->role_used_in);

                        if (in_array('p', $user_assigned_roles_in) && in_array('r', $user_assigned_roles_in)) {
                            return "both";
                        } elseif (in_array('r', $user_assigned_roles_in)) {
                            return "review_only";
                        } elseif (in_array('p', $user_assigned_roles_in)) {
                            return "production_only";
                        } else
                            return "";
                    }
                    return "";
                } else return "";
            }
        }
    }
    public function get_article_type_permission($select, $condition,$condition_arr=array())
    {
        $Article_types = new \App\Models\Article_types();
        $article_type_table = (new \App\Models\Article_types)->getTable();
        $journal_permission_table = (new \App\Models\Journal_permission)->getTable();
        $article_type_advance_table = (new \App\Models\Article_type_advance_options)->getTable();
        $sql = "SELECT {$select} FROM $article_type_table JOIN $article_type_advance_table ON atotp_artp_id=artp_id  JOIN $journal_permission_table ON jp_jpm_id=artp_jpm_id WHERE $condition LIMIT 1";
        if(!empty($condition_arr))
        $permission_data = $Article_types::get_records_by_raw_query($sql,FALSE,$condition_arr);
        else
        $permission_data = $Article_types::get_records_by_raw_query($sql);
        if (!empty($permission_data))
            return $permission_data[0];
    }

    public function get_user_data($user_id)
    {
        $record = User::get_single_record('*', "usr_id={$user_id}");
        if (!empty($record))
            return $record;
    }


    public function confirm_registered_user($user_data, $current_user, $act_type)
    {
        $current_date_time = date('Y-m-d H:i:s');
        $updt_data = array(
            'usr_reg_date' => $current_date_time,
            'usr_status' => 'a',
            'usr_activation' => 'y',
            'usr_url' => '',
            // 'usr_deeplink_token' => ''
        );
        $condition = "usr_id={$user_data->usr_id}";

        //Task #5284 Reviewer invite auto-accepted - ICE
        $deeplink_str = NULL;
        if ($user_data->usr_deeplink_token != NULL) {
            $deeplink_str = $user_data->usr_deeplink_token;
        } elseif ($user_data->usr_url != NULL) {
            $deeplink_str = $user_data->usr_url;
        }

        if ($deeplink_str != NULL) {
            $this->Email_deeplink_click_tracker($deeplink_str,$act_type,$current_user);
        }

        User::update_record($updt_data, $condition,$current_user);
        if ($this->current_client->functionality->cfty_adhoc_user_role == 'y') {
            $this->adhoc_role_to_journal($user_data->usr_id, $current_user);
        }
        $User_emails = new \App\Models\User_emails();
        $Email_templates = new \App\Models\Email_templates();
        //confirm altenate emails
        $user_cnfrm = $User_emails::get_all_records('*', "uml_user_id={$user_data->usr_id} AND uml_status!='c'");
        $array=array();
        foreach($user_cnfrm as $k =>$a){
            $array[$k] = json_decode(json_encode($a));
        }
        $arr =(object) $array;
        $this->send_cc_email_confirmation($arr, $user_data);
    }


    public function Email_deeplink_click_tracker($deeplink_token, $action_type, $current_user)
    {
        //expecting action types $action_type => {ec/ra/rr/ap}
        //NOTE : ec-email confirmation,ra-review accpet,rr-review reject,ap-article proposal

        $action_type_arr = array(
            'ec',
            'url',
            'ra',
            'rr',
            'ap'
        );

        $status = FALSE;

        if (!empty($deeplink_token) && in_array($action_type, $action_type_arr) == TRUE) {

            $Email_deeplink_clicktracking = new \App\Models\Email_deeplink_clicktracking();
            $browser = Agent::browser();
            $b_version = Agent::version($browser);
            $browser_with_vrson = $browser . ' ' . $b_version;
            $platform = Agent::platform();
            $p_version = Agent::version($platform);
            $user_type = 'normal';
            if ($p_version !== FALSE) {
                $platform = $platform . ' ' . $p_version;
            }
           $ip_address=trim(shell_exec("dig +short myip.opendns.com @resolver1.opendns.com"));

            $insert_arr = array(
                'edt_ip' => $ip_address,
                'edt_browser' => $browser_with_vrson,
                'edt_os' => $platform,
                'edt_deeplink_token' => $deeplink_token,
                'edt_action_type' => $action_type,
            );


            if ($Email_deeplink_clicktracking::insert_record($insert_arr, $current_user)) {
                $status = TRUE;
            }
        }
        return $status;
    }
    //Feature #1536 : Add Adhoc user role : add user requested role in sign up to journal
    public function adhoc_role_to_journal($user_id, $current_user)
    {
        $Roles = new \App\Models\Roles();
        $Adhoc_user_role = new \App\Models\Adhoc_user_role();
        $User_to_journals = new \App\Models\User_to_journals();
        $adhoc_roles = $Roles::get_all_records('role_id', 'role_assigned_role IN("author", "reviewer") AND role_adhoc_role_status="y"');
        $adhoc_roles = array_column(json_decode(json_encode($adhoc_roles), TRUE), 'role_id');

        //#660 SELECT query error when $adhoc_roles array is NULL
        $adhoc_role_condi   =   '';
        if (count($adhoc_roles) > 0) {
            $adhoc_role_condi   =   ' AND aur_role_id IN (' . implode(',', $adhoc_roles) . ')';
        }
        $adhoc_condition = 'aur_role_approved_status = "n" AND aur_usr_id = ' . $user_id . '' . $adhoc_role_condi;
        //$adhoc_condition = 'aur_role_approved_status = "n" AND aur_usr_id = ' . $user_id . ' aND aur_role_id IN (' . implode(',', $adhoc_roles) . ')';
        $requested_roles = $Adhoc_user_role::get_all_records('aur_id, aur_jnl_id, aur_role_id', $adhoc_condition);
        if (!empty($requested_roles)) {
            $insert_usr_to_jrnl = array();
            $update_adhoc_tbl = array();

            $User_to_journals = new \App\Models\User_to_journals();
            foreach ($requested_roles as $record) {
                $update_adhoc_tbl[] = $record->aur_id;
                $condition = "usrj_usr_id={$user_id} AND usrj_jnl_id={$record->aur_jnl_id} AND usrj_role_id={$record->aur_role_id} usrj_artp_id IS NULL";
                $is_exist_role = $User_to_journals::get_single_record('count(usrj_id) as cnt', $condition);
                if (!empty($is_exist_role) && $is_exist_role->cnt == 0) {
                    $insert_usr_to_jrnl[] = array(
                        'usrj_jnl_id' => $record->aur_jnl_id,
                        'usrj_usr_id' => $user_id,
                        'usrj_role_id' => $record->aur_role_id,
                        'usrj_posted_by' => $current_user['user_id'],
                        'usrj_posted_date' => date('Y-m-d H:i:s'),
                        'usrj_proxy_id' => $current_user['proxy_user_id']
                    );
                }
            }
            if (!empty($insert_usr_to_jrnl)) {
                //add role to journals
                $User_to_journals::insert_batch($insert_usr_to_jrnl, $current_user);
            }

            if (!empty($update_adhoc_tbl)) {
                $updt_conditn = 'aur_id IN (' . implode(',', $update_adhoc_tbl) . ')';
                $Adhoc_user_role::update_record(array(
                    'aur_role_approved_status' => 'y'
                ), $updt_conditn, $current_user);
            }
        }
    }
    public function create_user_email($user_record, $current_user)
    {
        $pass = Str::random(8);
        $deeplink_str = NULL;
        if (!empty($user_record->usr_deeplink_token)) {
            $deeplink_str = $user_record->usr_deeplink_token;
        } elseif (!empty($user_record->usr_url)) {
            $deeplink_str = $user_record->usr_url;
        }
        if (!empty($deeplink_str)) {
            $this->Email_deeplink_click_tracker($deeplink_str,'ec',$current_user);
        }
        $current_date_time = date('Y-m-d H:i:s');

        $updt_data = array(
            'usr_reg_date' => $current_date_time,
            'usr_pwd' => Hash::make($pass),
            'usr_status' => 'a',
            'usr_deeplink_token' => '',
            'usr_url' => ''
        );
        User::update_record($updt_data, "usr_id={$user_record->usr_id}");

        $this->send_create_user_email($user_record);
    }

    public function update_s3_files($path,$aws_path=NULL)
{
       if($aws_path==NULL)
       {
        $aws_path=$path;
       }
	$mainpath = storage_path().'/app/public/uploads/' . $path;
	$s3_path= env('AWS_BUCKET')."/uploads" . DIRECTORY_SEPARATOR . $aws_path;
	/*$files = File::allFiles($mainpath);
	if (sizeof($files) > 0) {



		foreach ($files as $file) {

			$path_info = pathinfo($file);

			$file_name = $path_info['filename'] . '.' . $path_info['extension'];

			Storage::disk('s3')->putFileAs($s3_path,$file, $file_name);
		}
	}
    $mainpath='/var/www/html/ReView_Conferences_V1/storage/app/public/uploads/pcori/DFRR/659';
      $shellcomand= 'aws '.$mainpath.' s3://review3/uploads/ratheesh';
  */
$public_path=public_path().'/storage/uploads/'. $path;
$awspath='s3://'.$s3_path;

$shellcomand= 'aws s3 sync '.$public_path.' '.$awspath;
$output = shell_exec($shellcomand);


}
    public function zip_extract($zip_path, $file_name, $allowd_filetypes,$specific_path=NULL)
    {
        $return_arr = array();
        $path = $zip_path . $file_name;
        $fullpath = "uploads" . DIRECTORY_SEPARATOR . $path;
        $zip = new \ZipArchive();

        if ($zip->open($path) === true) {
            for ($i = 0; $i < $zip->numFiles; $i++) {
                $filename = $zip->getNameIndex($i);
                $fileinfo = pathinfo($filename);
                $file_details = $zip->statName($filename);
                $dir_name = '';
                if (!is_dir($zip_path . $fileinfo['dirname'])) {
                    mkdir($zip_path . $fileinfo['dirname'], 0777, TRUE);
                    $dir_name = $fileinfo['dirname'];
                }

                if (isset($fileinfo['extension'])) {
                    $pattern_name = '/^[A-Za-z0-9-\/_.()\s(\w+\s?)]+$/';
                    $pattern_adjacent_space = '/\s\s+/';
                    if (in_array(strtolower($fileinfo['extension']), $allowd_filetypes) && preg_match($pattern_name, $filename) && !preg_match($pattern_adjacent_space, $filename)) {
                        $source = "zip://" . $path . "#" . $filename;
                        $zip_entry = $zip->getStream($filename);

                        $dest_file_name = $this->rename_file($zip_path, $filename,false,$fullpath);
                        $copy_path = $zip_path . $dest_file_name;

                        $return_arr[] = array(
                            'filename' => $dest_file_name,
                            'filesize' => $file_details['size'],
                        );
                        copy($source, $copy_path);
                        if ($this->current_client->enable_upload_s3_bucket == 'y'&&$specific_path!=NULL) {
                           // $temp_zip_path='public/uploads/' .$specific_path.'/temp_zip/';
                          //  Storage::makeDirectory($temp_zip_path);

                          //  copy($source, $zip_path.'temp_zip/'.$dest_file_name);
                           // $path_info = pathinfo($filename);
                           $aws_path=$specific_path;
                           $this->update_s3_files($specific_path,$aws_path);

                         //   $file_path = Config::get('general_config.file_retrieval')['file_path'];
                         //   $tmpfullpath = public_path() . $file_path . '/'.$specific_path.'/temp_zip';


                        }


                    }
                }
            }
            $zip->close();

            return $return_arr;
        }
    }
    public function remove_fileinfolder($path,$file_name,$aws_path=NULL){

        if ($this->current_client->enable_upload_s3_bucket == 'y'&&$aws_path!=NULL) {

            //if ($this->fileExistsS3($aws_path,$file_name) == TRUE) {

                Storage::disk('s3')->delete($aws_path.$file_name);
           // }

            if (file_exists($path .$file_name))
            {
                unlink($path .$file_name);
            }

        }
        else
        {
            if (file_exists($path .$file_name)) {
                unlink($path .$file_name);
            }
        }
    }
    public function validate_stage_forms($aflw_id, $jnl_id, $jnl_code, $art_user_roles = array(),$flow_data=NULL)
    {
        $this->current_user = $this->get_current_user_details();
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $generic_forms_validated = FALSE;
        $static_forms_validated = FALSE;
        // $stage_details = Article_flow::get_stage_details('aflw_id=' . $aflw_id);
        $assignment_details = '';
        $stage_details = Article_flow::get_stage_details('aflw_id= :aflw_id',wherearr:["aflw_id"=>$aflw_id]);
        $article_type = Article_types::get_single_record("artp_id", 'artp_fwm_id=' . $stage_details->jwf_fwm_id);
        if (empty($art_user_roles)) {
            $art_user_roles =  FALSE;
            $all_user_roles = $this->validate_user_journal($jnl_code, $this->current_user['user_id'], $stage_details->art_artp_id);
            $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
            /* Roles assigned to this article */
            $user_array = array();
            $user_array['user_roles'] = $all_user_roles;
            $user_array['article_id'] = $stage_details->aflw_art_id;
            $user_array['all_roles'] = $all_roles;
            $user_array['jnl_id'] = $jnl_id;
            $user_array['user_id'] = $this->current_user['user_id'];
            $user_array['artp_id'] = $stage_details->art_artp_id;
            $user_roles = $this->get_article_user_roles($user_array);
            $user_rls = isset($user_roles['role_id']) ? $user_roles['role_id'] : array();
            if (!empty($user_rls) && in_array($stage_details->jwf_role_id, $user_rls)) {
                $art_user_roles = array($stage_details->jwf_role_id);
            }
        }
        if($flow_data != NULL && isset($user_roles))
        {
            $stage_flow = $review_flow[$flow_data->jwf_stage_type];
            $assignment_details=$this->assignment_details($flow_data,$jnl_id,$this->current_user['user_id'],$stage_flow,$user_roles);
        }
        $validated_assignment_forms = ($review_flow[$stage_details->jwf_stage_type]['assignment_tabs'] == FALSE || $art_user_roles == FALSE) ? TRUE : $this->validate_assignment_forms($stage_details->art_artp_id, $stage_details->aflw_art_id, $art_user_roles, $aflw_id, $jnl_code, $jnl_id,$assignment_details);
        //Validating generic forms
        $generic_form_ids = json_decode($stage_details->jwf_forms);
        //print_r($generic_form_ids);exit;
        $stage_artp_forms = array();
        $Generic_forms = new \App\Models\Generic_forms();
        $generic_forms_table = ($Generic_forms)->getTable();
        $Generic_form_elements = new \App\Models\Generic_form_elements();
        if (!empty($generic_form_ids)) {
            /*$flt_user_roles =  json_decode($stage_details->jwf_forms);
        $implode_role_data = implode(',', array_keys($flt_user_roles));*/
            $implode_role_data = implode(',', json_decode($stage_details->jwf_forms, TRUE));
            $sql_stage = "SELECT * FROM " . $generic_forms_table . " WHERE gncf_id IN({$implode_role_data})";
            $stage_artp_forms = $Generic_forms::get_records_by_raw_query($sql_stage);
        }
        $forms_validated = array();
        $required_array = array();
        foreach ($stage_artp_forms as $fk => $forms) {
            $elements = $Generic_form_elements::get_all_records("*", 'emt_gucf_id=' . $forms->gncf_id);
            if (count($elements) > 0 && $this->has_required_form_element($elements) == TRUE) {
                $Article_generic_form_data = new \App\Models\Article_generic_form_data();
                foreach ($elements as $element) {
                    $depend_data = array();
                    $data = new \stdClass();
                    /* Modified Bug #1378 - RVW1276 - Form validation */
                    if ($element->emt_dependency_required == 1 && $element->emt_required == 1) {
                        // $depend_data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_depending_control}' and gdata_artflw_id='{$aflw_id}' and gdata_atf_id='{$forms->gncf_id}' and gdata_data='{$element->emt_depending_value}' and gdata_artflw_stage_repeat_count='{$stage_details->aflw_stage_repeat_count}' ", '', "_" . $jnl_code);
                        $depend_data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_depending_control}' and gdata_artflw_id= ? and gdata_atf_id='{$forms->gncf_id}' and gdata_data='{$element->emt_depending_value}' and gdata_artflw_stage_repeat_count='{$stage_details->aflw_stage_repeat_count}' ", '', "_" . $jnl_code,binding_arr:[$aflw_id]);
                        if ($depend_data->cnt > 0) {
                            // $data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_id}' and gdata_artflw_id='{$aflw_id}' and gdata_atf_id='{$forms->gncf_id}' and gdata_artflw_stage_repeat_count='{$stage_details->aflw_stage_repeat_count}' ", '', "_" . $jnl_code);
                            $data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_id}' and gdata_artflw_id= ? and gdata_atf_id='{$forms->gncf_id}' and gdata_artflw_stage_repeat_count='{$stage_details->aflw_stage_repeat_count}' ", '', "_" . $jnl_code,binding_arr:[$aflw_id]);
                        } else {
                            $data->cnt = 1;
                        }
                    } elseif ($element->emt_required == 1) {
                        // $data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_id}' and gdata_artflw_id='{$aflw_id}' and gdata_atf_id='{$forms->gncf_id}' and gdata_artflw_stage_repeat_count='{$stage_details->aflw_stage_repeat_count}' ", '', "_" . $jnl_code);
                        $data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_id}' and gdata_artflw_id= ? and gdata_atf_id='{$forms->gncf_id}' and gdata_artflw_stage_repeat_count='{$stage_details->aflw_stage_repeat_count}' ", '', "_" . $jnl_code,binding_arr:[$aflw_id]);
                    } else {
                        $data->cnt = 1;
                    }
                    if ((isset($data->cnt) && $data->cnt == 0)) {
                        $required_array[] = $forms->gncf_id;
                        break;
                    }
                }
            }
        }
        if (count($required_array) == 0) {
            $generic_forms_validated = TRUE;
        }
        // if stage completed then generic form validation become true for prodution stage
        //TASK #6357 - Bug on Export
        if($stage_details->aflw_status=='c' && $stage_details->jwf_stage_type == 'production') {
            $generic_forms_validated = TRUE;
        }
        //die($generic_forms_validated);
        //Validating static forms
        $forms_validated = array();
        if (isset($review_flow[$stage_details->jwf_stage_type]['static_forms'])) {
            $static_forms = $review_flow[$stage_details->jwf_stage_type]['static_forms'];
            $static_form_data = WorkflowTrait::static_form_data();
            foreach ($static_forms as $static_form) {
                if(isset($static_form_data[$static_form])) {
                $table_details = $static_form_data[$static_form];
                //$this->load->model($table_details['model']);
                $model = $table_details['model'];
                if($model=='Copyright') {
                    $table_model = new \App\Models\Copyright();
                }
                if($model=='Article_transfer_suggestion') {
                    $table_model = new \App\Models\Article_transfer_suggestion();
                }

                $tmp_aflw_id = $aflw_id;
                // $where = array(
                //     $table_details['key_field'] => $tmp_aflw_id
                // );
                // $where = $table_details['key_field']."={$tmp_aflw_id}";
                $where = $table_details['key_field']."= ?";
                // addig additional conditions
                if (isset($table_details['condition'])) {
                    //$where = array_merge($where, $table_details['condition']);
                    $where .= " and ".$table_details['condition'];
                }
                $data = $table_model::get_single_record('count(*) as count', $where,binding_arr:[$tmp_aflw_id]);
                //echo $this->db->last_query(); exit;
                if ($data->count > 0) {
                    $forms_validated[] = $static_form;
                }
            }
            }
            if (count($static_forms) == count($forms_validated)) {
                $static_forms_validated = TRUE;
            }
        } else {
            $static_forms_validated = TRUE;
        }
        //Task #424 Production Management
        $production_validation = TRUE;
        if (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') {
            $pro_valid_data = $this->validate_production_stage($aflw_id);
            if ($pro_valid_data['status'] == 'false')
                $production_validation = FALSE;
        }
        if ($static_forms_validated == TRUE && $generic_forms_validated == TRUE && $validated_assignment_forms == TRUE && $production_validation == TRUE) {
           return TRUE;
        } else {
            return FALSE;
        }
    }
    public function validate_assignment_forms($article_type_id, $article_id, $art_user_roles = array(), $aflw_id = NULL, $jnl_code = '', $jnl_id = '',$assignment_details= array())
    {
        $status = TRUE;
        $this->current_user = $this->get_current_user_details();
        //No need to check assignment if the user is author of article
        $Authors = new \App\Models\Authors();
        // $authors = $Authors::get_single_record('count(*) as count', 'auth_usr_id=' . $this->current_user['user_id'] . ' and auth_art_id=' . $article_id);
        $authors = $Authors::get_single_record('count(*) as count', 'auth_usr_id=' . $this->current_user['user_id'] . ' and auth_art_id= ?',binding_arr:[$article_id]);
        if ($authors->count == 0) {
            //$article_details = Article_flow::get_single_record('aflw_skip_assignment', 'aflw_art_id=' . $article_id . ' and aflw_id=' . $aflw_id);
            $select = 'DISTINCT(role_id), role_name';
            if (!empty($art_user_roles)) {
                $user_roles_art = $art_user_roles;
            } else {
                $user_roles = $this->validate_user_journal($jnl_code, $this->current_user['user_id'], $article_type_id);
                $roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
                $user_array = array();
                $user_array['user_roles'] = $user_roles;
                $user_array['article_id'] = $article_id;
                $user_array['all_roles'] = $roles;
                $user_array['jnl_id'] = $jnl_id;
                $user_array['user_id'] = $this->current_user['user_id'];
                $user_array['artp_id'] = $article_type_id;
                $user_roles = $this->get_article_user_roles($user_array);
                $art_user_roles = $user_roles['role_id'];
            }
            $roles_to_assign = NULL;
            if (isset($art_user_roles) && !empty($art_user_roles)) {
                $user_roles = implode(',', $art_user_roles);
                $Assign_permission = new \App\Models\Assign_permission();
                $where = "asgm_artp_id=" . $article_type_id . " and asgm_can_assgn_role in (" . $user_roles . ")";
                $roles_to_assign = $Assign_permission::get_roles_to_assign($select, $where);
            }
            if (!empty($assignment_details) && (isset($assignment_details['roles_to_assign'])&& !empty($assignment_details['roles_to_assign']))) {
                $roles_array = array();
                $assign_roles = $assignment_details['roles_to_assign'];
                //$assign_roles =  json_decode(json_encode($roles_to_assign), TRUE);
                $roles_array = array_filter(array_column($assign_roles, 'role_id'));
                $assigned_roles = array();

                if (!empty($roles_array)) {
                    $User_articles = new \App\Models\User_articles;
                    $user_article_table = ($User_articles)->getTable();
                    // $assigned_users = $User_articles::get_records_by_raw_query('SELECT GROUP_CONCAT(DISTINCT usra_role_id) as assigned_roles FROM ' . $user_article_table . ' WHERE usra_art_id = ' . $article_id . ' AND usra_role_id IN (' . join(',', $roles_array) . ')');
                    $assigned_users = $User_articles::get_records_by_raw_query('SELECT GROUP_CONCAT(DISTINCT usra_role_id) as assigned_roles FROM ' . $user_article_table . ' WHERE usra_art_id = ? AND usra_role_id IN (' . join(',', $roles_array) . ')',binding_arr:[$article_id]);

                    $assigned_roles = isset($assigned_users[0]->assigned_roles) ? array_filter(explode(',', $assigned_users[0]->assigned_roles)) : array();
                }
                $assign_select = 'group_concat(aflw_skip_assignment) as aflw_skip_assignment';
                // $assign_where = "aflw_art_id = " . $article_id . " and aflw_usr_id=" . $this->current_user['user_id'];
                $assign_where = "aflw_art_id = ?  and aflw_usr_id=" . $this->current_user['user_id'];
                // $assign_dets = Article_flow::get_article_flow_details($assign_select, $assign_where);
                $assign_dets = Article_flow::get_article_flow_details($assign_select, $assign_where,condition_arr:[$article_id]);
                $skipped_roles = ($assign_dets[0]->aflw_skip_assignment != NULL) ? array_filter(explode(',', $assign_dets[0]->aflw_skip_assignment)) : array();
                $skipped_roles = array_intersect($skipped_roles, $roles_array);
                $final_array = array_unique(array_merge($skipped_roles, $assigned_roles));
                if(isset($assignment_details) && !empty($assignment_details['roles_to_assign']) && (count($assignment_details['roles_to_assign'])!= count($final_array)))
                {
                    $status = FALSE;
                }
                // if(count($roles_to_assign) != count($final_array)) {
                //     $status = FALSE;
                // }
            }
        }
        return $status;
    }
    //Function to check generic form has any required field
    public function has_required_form_element($elements)
    {
        $status = FALSE;
        foreach ($elements as $element) {
            if ($element->emt_required == 1) {
                $status = TRUE;
                break;
            }
        }
        return $status;
    }

    public function get_allocated_users_list($articleids = array())
    {
        $allocated_user = array();
        if (!empty($articleids)) {
            $User_articles = new \App\Models\User_articles;
            $articleids = implode(',', $articleids);
            $conditions = 'usra_art_id IN (' . $articleids . ')';
            // $results = $User_articles::get_all_records('usra_art_id,usra_usr_id,usra_role_id',$conditions,'usra_art_id,usra_role_id');
            $results = $User_articles::get_all_records('usra_art_id,usra_usr_id,usra_role_id', $conditions);
            if (!empty($results)) {
                foreach ($results as $res) {
                    $art_id = $res->usra_art_id;
                    $usr_id = $res->usra_usr_id;
                    $role_id = $res->usra_role_id;
                    $allocated_user[$art_id][$role_id][] = $usr_id;
                }
            }
        }
        return $allocated_user;
    }

    public function reviewer_privilaged_listing($user_id = NULL, $is_awaiting = FALSE)
    {
        $user_article_table = (new \App\Models\User_articles())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $roles_table = (new \App\Models\Roles())->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $this->current_user = $this->get_current_user_details();
        if ($is_awaiting == FALSE) {
            $allocation_cnd = ' ( CASE WHEN (SELECT count(usa.usra_usr_id) FROM ' . $user_article_table . ' usa WHERE usa.usra_art_id = art_id AND usa.usra_usr_id = ' . $this->current_user['user_id'] . ') > 0 THEN TRUE END) OR ';

            // Only child review stage returns for reviewer role
            $list_query = ' ( ' . $allocation_cnd . ' (IF (((SELECT count(aflw_id) as cnt FROM ' . $article_flow_table . ' aflw JOIN ' . $generic_flow_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' . $roles_table . ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role = "reviewer" AND jwf.jwf_fwm_id=artp_fwm_id AND (aflw.aflw_status NOT IN("c","d") ) AND aflw.aflw_usr_id = ' . $this->current_user['user_id'] . ' AND aflw.aflw_art_id = art_id ) > 0)  ,FALSE,TRUE)) OR (IF (((SELECT count(aflw_id) as cnt FROM ' . $article_flow_table . ' aflw JOIN ' . $generic_flow_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' . $roles_table . ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role = "reviewer" AND jwf.jwf_fwm_id=artp_fwm_id AND ( (aflw.aflw_status IN("i","a") AND rvw_article_flow.aflw_usr_id = ' . $this->current_user['user_id'] . ')) AND aflw.aflw_usr_id = ' . $this->current_user['user_id'] . ' AND aflw.aflw_art_id = art_id ) > 0)  ,TRUE,FALSE)) )';


            if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
                $list_query = ' ( (IF (((SELECT count(aflw_id) as cnt FROM ' . $article_flow_table . ' aflw JOIN ' . $generic_flow_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' . $roles_table . ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role = "reviewer" AND jwf.jwf_fwm_id=artp_fwm_id  AND aflw.aflw_usr_id = ' . $this->current_user['user_id'] . ' AND aflw.aflw_art_id = art_id ) > 0)  ,FALSE,TRUE)) OR (IF (((SELECT count(aflw_id) as cnt FROM ' . $article_flow_table . ' aflw JOIN ' . $article_flow_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' . $roles_table . ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role = "reviewer" AND jwf.jwf_fwm_id=artp_fwm_id AND ( (aflw.aflw_status IN("i","a","c","d") AND rvw_article_flow.aflw_usr_id = ' . $this->current_user['user_id'] . ')) AND aflw.aflw_usr_id = ' . $this->current_user['user_id'] . ' AND aflw.aflw_art_id = art_id ) > 0)  ,TRUE,FALSE)) ';

                $list_query .= '  AND (
                            IF(
                            (
                            (
                             SELECT
        COUNT(aflw_id) AS cnt
      FROM
      ' . $article_flow_table . ' aflw
      JOIN
      ' . $generic_flow_table . ' jwf
      ON
        jwf.jwf_id = aflw.aflw_jwf_id
        JOIN
       ' . $article_table . '
        ON
         art_id = aflw.aflw_art_id
      WHERE
      jwf_assignment = "invitation" AND IF(art_pre_all_ids IS NOT NULL,FIND_IN_SET(aflw.aflw_art_id, art_pre_all_ids) > 0,aflw.aflw_art_id = art_id )  AND `aflw`.`aflw_usr_id` = ' . $user_id . ' AND aflw.aflw_parent_flow_id IS NOT NULL
    ) > 0
                            ),TRUE,FALSE
                        ) ) ';

                $list_query .= ')';
            }
        } else { // Exclude article from list if user assigned as reviewer - for privilaged view
            $list_query = ' ( (IF (((SELECT count(aflw_id) as cnt FROM ' . $article_flow_table . ' aflw JOIN ' . $generic_flow_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' .  $roles_table . ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role = "reviewer" AND jwf.jwf_fwm_id=artp_fwm_id AND (aflw.aflw_status NOT IN("c","d") ) AND aflw.aflw_usr_id = ' . $this->current_user['user_id'] . ' AND aflw.aflw_art_id = art_id ) > 0)  ,0,TRUE)) )';
        }

        return $list_query;
    }

    public function get_blinded_articles($user_id)
    {
        $rtn_articles = array();

        $article_table = (new \App\Models\Articles())->getTable();
        $blind_articleuser = new \App\Models\Blind_user_articles();

        $raw_sql = 'SELECT bau_art_id,art_pre_all_ids as prev_art_id,(SELECT GROUP_CONCAT(`art2`.`art_id`) FROM ' . $article_table . ' AS `art2` WHERE FIND_IN_SET(
				`org_art`.`art_id`,`art2`.`art_pre_all_ids`)) AS `next_art_id`
		FROM ' . $blind_articleuser->getTable() . ' LEFT JOIN ' . $article_table . ' AS `org_art` ON `bau_art_id` = `art_id` WHERE JSON_SEARCH(`bau_usr_ids`, "all", \'' . $user_id . '\') IS NOT NULL';

        $blind_articles = $blind_articleuser::get_records_by_raw_query($raw_sql);

        if (!empty($blind_articles)) {
            foreach ($blind_articles as $blnd_art) {
                if (!empty($blnd_art->bau_art_id) && ($blnd_art->bau_art_id != NULL)) {
                    $rtn_articles[] = $blnd_art->bau_art_id;
                }
                if (!empty($blnd_art->prev_art_id) && ($blnd_art->prev_art_id != NULL)) {
                    $rtn_articles[] = $blnd_art->prev_art_id;
                }
                if (!empty($blnd_art->next_art_id) && ($blnd_art->next_art_id != NULL)) {
                    $rtn_articles[] = $blnd_art->next_art_id;
                }
            }
            $rtn_articles = implode(',', $rtn_articles);
        }
        return $rtn_articles;
    }

    public function getexistdata_deatails($forms, $art_id, $jnlcode, $art_flow_id,$repeat_count=0,$editcmtforms = FALSE)
    {
        $return_array = array();
        $return_array['form_openid']='';
        $activateformcount = 0;
        $form_valid=false;
        $form_complete=true;
        $form_openstatus=false;
        $form_open=0;
        $Generic_form_elements = new \App\Models\Generic_form_elements();
        $Article_generic_form_data = new \App\Models\Article_generic_form_data();
        $Article_generic_form_data_temp = new \App\Models\Article_generic_form_data_temp();
        $data = json_decode($forms, TRUE);
        $lastvalidform='';
        $lastnotvalidform='';
        if (!empty($data)) {
            $suport_files = $Generic_form_elements::supporting_files($data);
            //$suport_files_count = $suport_files->file_upload;
            foreach ($data as $formid) {
                $form_open++;
                $temp_save = FALSE;
                $btn_status = true;
                $lastnotvalidform=$formid;
                // generic form ids
                $valid_req_generic_forms[] = $formid;
                $condition2 = 'emt_gucf_id=' . $formid;
                $elements = $Generic_form_elements::get_all_records('*', $condition2);
                if (sizeof($elements) == 0) {
                    $btn_status = false;
                    $activateformcount++;
                }
                $return_array['form_validation'][$formid]=false;
                // no of elemt required

                if(!empty($elements)) {
                    foreach ($elements as $element) {
                        if ($element->emt_required == 1) {
                            $return_array['form_validation'][$formid]=true;
                            $lastvalidform=$formid;
                        }
                    }
                }


                //Bug #1426 Invite Submission
                if ($art_id != '') {
                    //checking for form which exists in db with details
                    $formatted_journal_code = '_' . $jnlcode;
                    $existdata = $Article_generic_form_data::load_exist_form_contents($formid, $art_id, $art_flow_id, $formatted_journal_code,NULL,FALSE,$repeat_count);
                    $article_table = (new \App\Models\Articles())->getTable();
                    $article_type_advance_options_table = (new \App\Models\Article_type_advance_options())->getTable();
                    $sql = "select atotp_review_method, atotp_custom_blind_params from {$article_table} left join {$article_type_advance_options_table} on art_artp_id=atotp_artp_id where art_id={$art_id}";
                    $data_sql = Articles::get_records_by_raw_query($sql);
                    $atotp_review = $data_sql[0] ?? null;
                    $atotp_review_method = isset($data_sql[0]->atotp_review_method)?$data_sql[0]->atotp_review_method:'';
                    $jnl_id = Journals::get_single_record('jnl_id', "jnl_journal_code = '{$jnlcode}' ")->jnl_id;

                } else {
                    $existdata = NULL;
                }

                $file_only = FALSE;
                if ($existdata != NULL && count($existdata) > 0) {
                    $file_only = TRUE;
                    $activateformcount++;
                    foreach ($existdata as $data) {
                        if ($data->gdata_element_type != 'file') {
                            $file_only = FALSE;
                            break;
                        }
                    }

                    $last_posted_date = $existdata[0]->gdata_posted_date;
                    $gdatacond = "gdata_posted_date >'".$last_posted_date."' and gdata_art_id=".$art_id;
                    $check_gdata_exist=$Article_generic_form_data::get_generic_form_stage_elements($formatted_journal_code,'*',$gdatacond);

                    if(!empty($check_gdata_exist) && $editcmtforms == FALSE) {
                        $existdata = $this->get_updated_gdata($check_gdata_exist,$existdata,$art_id,$atotp_review_method,$last_posted_date,$formatted_journal_code,$jnl_id, $atotp_review);
                    }

                }

                if($return_array['form_validation'][$formid]==true && ($existdata==NULL || count($existdata)==0)) {
                    if($form_openstatus==false){
                        $form_openstatus=true;
                        $form_valid=true;
                        $return_array['form_open']=$form_open-1;
                    }
                }
                if(($existdata==NULL || count($existdata)==0)){
                    $form_complete=false;
                    if(empty($return_array['form_openid'])) {
                        $return_array['form_openid']=$formid;
                    }
                }

                if($file_only==true) {
                    $form_complete=false;
                    $return_array['form_openid']=$formid;
                }

                $temp_data = FALSE;
                if (($existdata == NULL || count($existdata) == 0) || ($existdata != NULL  && count($existdata) > 0 && $file_only == TRUE)) {
                    $existdata_temp = $Article_generic_form_data_temp::load_exist_form_contents($formid, $art_id, $art_flow_id,NULL,FALSE,$repeat_count);
                    if ($existdata_temp && sizeof($existdata_temp) > 0) {
                        if ($existdata == NULL) {
                            $existdata = $existdata_temp;
                        } else {
                            $k = 0;
                            foreach ($existdata_temp as $temp_data) {
                                $existdata[$k] = $temp_data;
                                $k++;
                            }
                        }
                        $temp_save = TRUE;
                        $temp_data = TRUE;
                        $last_posted_date = $existdata[0]->gdata_posted_date;
                        $gdatacond = "gdata_posted_date >'".$last_posted_date."' and gdata_art_id=".$art_id;
                        $check_gdata_exist=$Article_generic_form_data::get_generic_form_stage_elements($formatted_journal_code,'*',$gdatacond);

                        if(!empty($check_gdata_exist)) {
                            $existdata = $this->get_updated_gdata($check_gdata_exist,$existdata,$art_id,$atotp_review_method,$last_posted_date,$formatted_journal_code,$jnl_id, $atotp_review);
                        }
                    }
                }

                $return_array['existdata'][$formid] = $existdata;
                $return_array['temp_save'][$formid] = $temp_save;
                $return_array['file_only'][$formid] = $file_only;
                $return_array['formbtn_status'][$formid] = $btn_status;
            }
        }
        $return_array['form_valid']=$form_valid;
        $return_array['form_complete']=$form_complete;

        if (!array_key_exists("form_openid",$return_array)) {
            if(!empty($lastvalidform)){
                $return_array['form_openid']=$lastvalidform;
            } else{
                $return_array['form_openid']=$lastnotvalidform;
            }
        }

        return $return_array;
    }


    public function get_stage_info($status_id, $jnl_array)
    {

        $Articles = new \App\Models\Articles();
        $Article_flow = new \App\Models\Article_flow();
        //$date_format = Article_flow::$date_format_map[$this->jnl_data->jset_date_format];
        $date_format = $jnl_array['date_format'];
        $artp_id = isset($jnl_array['artp_id']) ? $jnl_array['artp_id'] : NULL;

        $select = 'jwf_stage_name, aflw_art_id, aflw_id, aflw_jwf_id, aflw_status, aflw_usr_id, jwf_assignment, jwf_parent_user_roles, jwf_who_can_invite, jwf_role_id, '
            . 'IF(jwf_assignment = "self_service", '
            . '(SELECT role_name FROM rvw_roles WHERE role_id = jwf_role_id), "") '
            . 'AS user_role, '
            . 'DATE_FORMAT(aflw_due_date,"' . $date_format . '") as duedate,'
            . 'DATE_FORMAT(aflw_invite_due_date,"' . $date_format . '") as invite_duedate,aflw_art_id';

        $where = 'aflw_id IN( ' . implode(',', $status_id) . ')';

        $stage_details =  $Article_flow::get_generic_flow($select, $where);

        $article_arr = array();
        $art_title_arr = array();
        $user_name_arr = array();
        $art_allocation = array();
        $user_role_arr = $this->set_all_roles_key_value();

        foreach ($stage_details as $val) {
            //check article having allocated users
            if (!isset($art_allocation[$val->aflw_art_id])) {
                $allocated_user = $this->get_allocated_users_list(array($val->aflw_art_id));
                if (isset($allocated_user[$val->aflw_art_id]))
                    $art_allocation[$val->aflw_art_id] = $allocated_user[$val->aflw_art_id];
                else
                    $art_allocation[$val->aflw_art_id] = array();
            }

            $val->user_full_name = '';
            $val->who_can_assign = '';
            $val->who_can_invite = '';

            if ($val->aflw_usr_id != '') {
                if (isset($user_name_arr[$val->aflw_usr_id])) {
                    $val->user_full_name = $user_name_arr[$val->aflw_usr_id];
                } else {
                    $array_data['user_id'] = $val->aflw_usr_id;
                    $array_data['journal_id'] = $jnl_array['jnl_id'];
                    $array_data['flag'] = TRUE;
                    $array_data['article_id'] = $val->aflw_art_id;
                    $array_data['jnl_code'] = $jnl_array['jnl_code'];
                    $array_data['artp_id'] = $artp_id;
                    $array_data['jwf_role_id'] = $val->jwf_role_id;
                    $val->user_full_name = $this->get_user_display_name($array_data);
                    $user_name_arr[$val->aflw_usr_id] = $val->user_full_name;
                }
            }

            if ($val->aflw_art_id != "") {
                if (isset($article_arr[$val->aflw_art_id])) {
                    $article_code = $article_arr[$val->aflw_art_id];
                    $article_title = $art_title_arr[$val->aflw_art_id];
                } else {
                    $art = $Articles::get_single_record('art_code,art_title', "art_id={$val->aflw_art_id}");
                    $article_code = $art->art_code;
                    $article_title = $art->art_title;
                    $art_title_arr[$val->aflw_art_id] = $article_title;
                    $article_arr[$val->aflw_art_id] = $article_code;
                }
                $val->art_title = $article_title;
                $val->art_code = $article_code;
            }

            /* start -- checking assignment types and getting roles of that */
            if ($val->jwf_assignment == 'manual' || $val->jwf_assignment == 'invitation') {
                /* role who is assigning users */
                $assigning_roles = json_decode($val->jwf_parent_user_roles);
                $assigned_role_users = $this->get_assign_details($assigning_roles, $art_allocation, $val->aflw_art_id, $user_role_arr);

                $val->who_can_assign = $this->get_formated_roles_and_users_list($assigned_role_users, $val->aflw_art_id, $user_name_arr, $jnl_array,$artp_id);

                /*
				$select = 'GROUP_CONCAT(role_name SEPARATOR ",") AS roles';
				$where = 'role_id IN(' . implode(',', $assigning_roles) . ')';
				$who_can_assign = $this->Roles->get_single_record($select, $where);

				$val->who_can_assign = $who_can_assign->roles;
				*/
                if ($val->jwf_assignment == 'invitation') {
                    /* role who is inviting users */
                    $inviting_roles = json_decode($val->jwf_who_can_invite);
                    /*
					$select = 'GROUP_CONCAT(role_name SEPARATOR ",") AS roles';
					$where = 'role_id IN(' . implode(',', $inviting_roles) . ')';
					$who_can_invite = $this->Roles->get_single_record($select, $where);
					$val->who_can_invite = $who_can_invite->roles;
					*/
                    $invite_role_users = $this->get_assign_details($inviting_roles, $art_allocation, $val->aflw_art_id, $user_role_arr);

                    $val->who_can_invite = $this->get_formated_roles_and_users_list($invite_role_users, $val->aflw_art_id, $user_name_arr, $jnl_array);
                }
            }
            /* end -- checking assignment types and getting roles of that */
        }

        return $stage_details;
    }
    public function save_cc_email_confirmation($ccmailflag, $user_id, $form_data)
    {
        $User_emails = new \App\Models\User_emails();
        $this->current_user = $this->get_current_user_details();
        $cc_object_array = array();
        $cc_data = [];
        if (isset($form_data)) {
            if ($ccmailflag == 'add') {
                foreach ($form_data as $keys => $mail) {
                    if ($mail != "") {
                        $cc_data['uml_user_id'] = $user_id;
                        $cc_data['uml_email'] = $mail;
                        $cc_data['uml_status'] = 'c';    //admin added alternate mail confirmed directly : Bug #1249
                        $cc_data['uml_posted_by'] = $this->current_user['user_id'];
                        array_push($cc_object_array, $cc_data['uml_email']);
                        $User_emails::insert_record($cc_data);
                    }
                }
            }
            else if($ccmailflag == 'savejrnluserdetails')
            {

                $condition = 'uml_user_id=' . $user_id;
                $cc_mail_data = $User_emails::get_all_records('uml_email', $condition);
                $cc_mail_data_array = array();
                foreach ($cc_mail_data as $key => $mail) {
                    $cc_mail_data_array[] = $mail->uml_email;

                    if (!in_array($mail->uml_email, $form_data)) {
                        $criteria = "uml_email = '{$mail->uml_email}' AND uml_user_id = {$user_id}";

                        $User_emails::delete_records($criteria, '', $this->current_user);
                    }
                }
                foreach ($form_data as $key => $mail) {
                    if (!in_array($mail, $cc_mail_data_array) && $mail != '') {
                        $cc_data['uml_user_id'] = $user_id;
                        $cc_data['uml_email'] = $mail;
                        $cc_data['uml_status'] = 'n';
                        $cc_data['uml_posted_by'] = $this->current_user['user_id'];
                        $User_emails::insert_record($cc_data);
                        array_push($cc_object_array, $cc_data['uml_email']);
                    }
                }
            }
             else {
                $condition = 'uml_user_id=' . $user_id;
                $cc_mail_data = $User_emails::get_all_records('uml_email', $condition);
                $cc_mail_data_array = array();
                foreach ($cc_mail_data as $key => $mail) {
                    $cc_mail_data_array[] = $mail->uml_email;

                    if (!in_array($mail->uml_email, $form_data)) {
                        $criteria = "uml_email = '{$mail->uml_email}' AND uml_user_id = {$user_id}";

                        $User_emails::delete_records($criteria, '', $this->current_user);
                    }
                }
                foreach ($form_data as $key => $mail) {
                    if (!in_array($mail, $cc_mail_data_array) && $mail != '') {
                        $cc_data['uml_user_id'] = $user_id;
                        $cc_data['uml_email'] = $mail;
                        $cc_data['uml_status'] = 'c';    //admin added alternate mail confirmed directly : Bug #1249
                        $cc_data['uml_posted_by'] = $this->current_user['user_id'];
                        $User_emails::insert_record($cc_data);
                        array_push($cc_object_array, $cc_data['uml_email']);
                    }
                }
            }
            return $cc_object_array;
        }
    }

    public function get_article_conflict_array($article_id)
    {

        $conflict_interest = $this->get_conflict_of_interest($article_id);

        return $conflict_interest;
    }

    public function get_conflict_of_interest($article_id)
    {
        $Authors = new \App\Models\Authors;
        $results = $Authors::get_corresp_author_details($article_id);
        $institution_array = $Authors::get_institution_details($article_id);
        
        /* post code conflict */
        $post_code = array();
        $inst_family = array();
        $inst_array = array();
        $author_ids = array();
        foreach ($results as $result) {
            $author_ids[] = $result->usr_id;

            if ($result->auaff_pcode != NULL) {
                $auaff_pcode_arr = explode(',', $result->auaff_pcode);
                foreach ($auaff_pcode_arr as $auaff_pcode) {
                    if(!empty($auaff_pcode) && $auaff_pcode != NULL)
                    {
                    $post_code[] = trim($auaff_pcode);
                    }
                }
            }
            if ($result->usaff_pcode != NULL) {
                $usaff_pcode_arr = explode(',', $result->usaff_pcode);
                foreach ($usaff_pcode_arr as $usaff_pcode) {
                    if(!empty($usaff_pcode) && $usaff_pcode != NULL)
                    {
                    $post_code[] = trim($usaff_pcode);
                    }
                }
            }

            
            
        }
        $institution_combinations = [];

        foreach ($institution_array as $item) {
            foreach (['user_institution', 'author_institution'] as $key) {
                if (!empty($item[$key])) {
                    $company = trim($item[$key]['company'] ?? '');
                    $country_id = trim($item[$key]['country_id'] ?? '');
                    $postal_code = trim($item[$key]['postal_code'] ?? '');

                    // Only include if all 3 fields are non-empty
                    if ($company !== '' && $country_id !== '' && $postal_code !== '') {
                        $institution_combinations[] = [
                            'company' => $company,
                            'country_id' => $country_id,
                            'postal_code' => $postal_code,
                        ];
                    }
                }
            }
        }
        //die;
        $postcode_conflict_user_ids = NULL;
        $coauthor_conflict_user_ids = NULL;
        $institute_conflict_user_ids = NULL;
        if (!empty($post_code)) {
            $postcode_conflict_user_ids = $Authors::get_user_ids_have_post_codes($post_code);

            if ($postcode_conflict_user_ids != NULL)
                array_walk($postcode_conflict_user_ids, 'convert_to_user_id_array');
        }

        if (!empty($author_ids)) {
            $coauthor_conflict_user_ids = $Authors::get_all_article_coauthors_ids($author_ids);
            if ($coauthor_conflict_user_ids != NULL)
                array_walk($coauthor_conflict_user_ids, 'convert_to_user_id_array');
        }
        if (!empty($institution_combinations)) {
            $institute_conflict_user_ids = $Authors::get_user_ids_with_matching_institution($institution_combinations);

            if ($institute_conflict_user_ids != null) {
                array_walk($institute_conflict_user_ids, 'convert_to_user_id_array');
            }
        }
        return array(
            'postcode_conflict_user_ids' => $postcode_conflict_user_ids,
            'coauthor_conflict_user_ids' => $coauthor_conflict_user_ids,
            'institute_conflict_user_ids' => $institute_conflict_user_ids
        );
    }
    public function get_user_conflict_of_interest($conflict_interest, $user_id)
    {
        $show_conflict_interest_message = array();

        if (isset($conflict_interest['postcode_conflict_user_ids'])&&$conflict_interest['postcode_conflict_user_ids'] != NULL && !empty($conflict_interest['postcode_conflict_user_ids']) && in_array($user_id, $conflict_interest['postcode_conflict_user_ids']))
            $show_conflict_interest_message[] = '- ' . 'User shares the same postcode as author';
        if (isset($conflict_interest['coauthor_conflict_user_ids'])&&$conflict_interest['coauthor_conflict_user_ids'] != NULL && !empty($conflict_interest['coauthor_conflict_user_ids']) && in_array($user_id, $conflict_interest['coauthor_conflict_user_ids']))
            $show_conflict_interest_message[] = '- ' . 'User co-authored article(s) with author';

        if (isset($conflict_interest['coauthor_conflict_user_ids'])&&$conflict_interest['institute_conflict_user_ids'] != NULL && !empty($conflict_interest['institute_conflict_user_ids']) && in_array($user_id, $conflict_interest['institute_conflict_user_ids']))
            $show_conflict_interest_message[] = '- ' . 'User and author are at the same institution.';
        

        return $show_conflict_interest_message;
    }

    public function customErrorAction($title, $error)
    {
        $currentdate = date('Y-m-d');
        $errorLog = new Logger($title);
        $errorLog->pushHandler(new StreamHandler(storage_path('logs/' . $currentdate . '.log')), Logger::DEBUG);
        $errorLog->error($error);
    }

    public function get_users_in_role($article_id, $article_type_id, $role_id, $jnl_id, $jnl_code, $check_blinding = false)
    {
        $roles = array();
        if (count($role_id) > 0) { //$role_id  can not empty
            $retire_condition = '';
            if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y') {
                $retire_condition = ' AND usrj_role_retired = "n" ';
            }
            $select = 'role_id, role_name, role_assigned_role, '
                . 'IF((SELECT COUNT("usra_id") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ) > 0, '
                . '(SELECT GROUP_CONCAT(usra_usr_id SEPARATOR ",") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ), '
                . '(SELECT GROUP_CONCAT(usrj_usr_id SEPARATOR ",")  FROM rvw_user_journals WHERE usrj_role_id = role_id AND usrj_artp_id = ' . $article_type_id . $retire_condition . ' AND usrj_usr_id NOT IN(SELECT auth_usr_id FROM rvw_article_authors WHERE auth_art_id = ' . $article_id . ')) ) AS user_id';
            $where = 'role_id IN(' . implode(',', $role_id) . ')';
            $roles = Roles::get_all_records($select, $where);

            foreach ($roles as $val) {
                if ($val->user_id != '') {
                    $user_ids = array_map('trim', explode(',', $val->user_id));

                    $user_ids = array_unique($user_ids);

                    $tmp_users = array();
                    if($check_blinding && $this->is_custom_blinded($val->role_id, $article_id, artp:$article_type_id, jnl:$jnl_id, blinded_user:$val->user_id)){
                        $val->users[0] = ['fullname' => "**users of this role is blinded from you**", 'linkable' => false];
                        continue;
                    }
                    foreach ($user_ids as $key => $tmp_usr_id) {
                        $user_data = User::get_single_record('usr_status', 'usr_id=' . $tmp_usr_id);
                        if ($user_data != NULL && isset($user_data->usr_status) && ($user_data->usr_status == 'a')) {
                            $array_data['user_id'] = $tmp_usr_id;
                            $array_data['journal_id'] = $jnl_id;
                            $array_data['flag'] = TRUE;
                            $array_data['article_id'] = $article_id;
                            $array_data['jnl_code'] = $jnl_code;
                            $array_data['artp_id'] = $article_type_id;
                            $array_data['role_id'] = $val->role_id;
                            $tmp_users[] = $this->get_user_display_name($array_data);
                        }
                    }
                    $val->users = $tmp_users;
                }
            }
        }

        return $roles;
    }
    /*
Get Previleged Data
*/
    public function get_article_flow_privilages($article_id, $flow_id, $jnl_code, $jnl_id)
    {

        $this->current_user = $this->get_current_user_details();
        $Article = new \App\Models\Articles;
        $Article_flow = new \App\Models\Article_flow;
        $Roles = new \App\Models\Roles;
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $roles_table = (new \App\Models\Roles)->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $article_type_table = (new \App\Models\Article_types())->getTable();
        $article_type_advance_table = (new \App\Models\Article_type_advance_options())->getTable();
        $journal_permission_table = (new \App\Models\Journal_permission())->getTable();
        $art_tables = array(
            'main_table' => $article_table,
            'join_table' => array(
                $article_type_table => array($article_table . '.art_artp_id', $article_type_table . '.artp_id'),
                $article_type_advance_table => array($article_type_advance_table . '.atotp_artp_id', $article_type_table . '.artp_id'),
                $journal_permission_table => array($journal_permission_table  . '.jp_jpm_id', $article_type_table . '.artp_jpm_id'),

            )
        );

        $art_criteria = "art_id={$article_id}";
        $selectfields = 'art_id,artp_id,artp_fwm_id,atotp_review_method,art_status,art_stub,art_artp_id,atotp_review_open_decision,art_status,atotp_review_open_count,art_article_upload_path,art_submitted_by,art_delete_status,jp_edit_reviewer_count';

        $article_data = $Article::get_results_using_joins($art_tables, $selectfields, $art_criteria, 'single');

        // $query = end($query);
        //print_r($query);exit;


        $privilages = $this->article_privilages($article_data, $flow_id, $jnl_code);

        $tables = array(
            'main_table' => $article_flow_table,
            'join_table' => array(
                $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id'),
                $roles_table => array($generic_flow_table . '.jwf_role_id', $roles_table . '.role_id', "left")
            )
        );

        $form_criteria = "aflw_art_id={$article_id} AND aflw_id={$flow_id}";

        $article_flow_details = $Article_flow::get_results_using_joins($tables, 'aflw_usr_id,aflw_parent_flow_id,jwf_assignment,jwf_stage_type,jwf_stage_name,jwf_fwm_id,jwf_role_id,jwf_forms,jwf_tab_name,aflw_stage_repeat_count,aflw_id,jwf_tab_name,jwf_id,aflw_level,jwf_parent_user_roles,jwf_who_can_invite,aflw_skip_review,jwf_reviewers_discuss_forum,aflw_status,aflw_returned_date,aflw_stage_min_users,aflw_stage_max_users,aflw_art_id,aflw_more_review_skip_status,jwf_status_name,jwf_child_stages,jwf_flow_proceed_type,role_name', $form_criteria, 'single');

        $user_roles = $this->validate_user_journal($jnl_code, $this->current_user['user_id'], $article_data->artp_id);
        $all_roles = $Roles::get_all_records('role_id,role_name,role_assigned_role');
        /* Roles assigned to this article */
        $array_data['user_roles'] = $user_roles;
        $array_data['article_id'] = $article_id;
        $array_data['all_roles'] = $all_roles;
        $array_data['article_privilages'] = $privilages;
        $array_data['art_flow_id'] = $flow_id;
        $array_data['jnl_id'] = $jnl_id;
        $array_data['artp_id'] = $article_data->artp_id;
        $user_roles = $this->get_article_user_roles($array_data);

        return array(
            'article_data' => $article_data,
            'privilages' => $privilages,
            'article_flow_details' => $article_flow_details,
            'user_roles' => $user_roles,
            'all_roles' => $all_roles
        );
    }



    /*
    #must contain arguments
    1.journal id
    2.role id
    3.type
    #expecting
    1.article with stage list as array
    2.filters details as array
    3.section detail if comming from tile listing section
    */
    public function write_user_article_list($array_data)
    {
        $jnl_id = isset($array_data['jnl_id']) ? $array_data['jnl_id'] : '';
        $role_id = isset($array_data['role_id']) ? $array_data['role_id'] : '';
        $type = isset($array_data['type']) ? $array_data['type'] : '';
        $section = isset($array_data['filter_list']['section']) ? $this->decrypt_data($array_data['filter_list']['section']) : NULL;
        $art_list = isset($array_data['art_list']) ? $array_data['art_list'] : array();
        $filter_list = isset($array_data['filter_list']) ? $array_data['filter_list'] : array();

        if ($jnl_id != '' && $role_id != '' && $type != '') {
            $Article_next_task_table = new \App\Models\Article_next_task();

            $cond_str = 'ant_usr_id = ' . $this->current_user['user_id'] . ' AND ant_jnl_id = ' . $jnl_id . ' AND ant_role_id = ' . $role_id . ' AND ant_type = \'' . $type . '\'';

            if(isset($filter_list['type']) && $section == 'overview')
            {
                $section = $this->decrypt_data($filter_list['type']);
            }

            $data = array(
                'ant_usr_id' => $this->current_user['user_id'],
                'ant_jnl_id' => $jnl_id,
                'ant_role_id' => $role_id,
                'ant_type' => $type,
                'ant_section' => $section,
                'ant_article_list' => json_encode($art_list),
                'ant_filter_list' => json_encode($filter_list),
                'ant_operation' => 'i'
            );

            $result = $Article_next_task_table::get_single_record('count(ant_id) as cnt', $cond_str);

            if (!empty($result) && $result->cnt > 0) {
                $data['ant_operation'] = 'u';
                $id = Article_next_task::update_record($data, $cond_str, $this->current_user);
            } else {
                $id = Article_next_task::insert_record($data, $this->current_user);
            }
            $result = $id;
        } else {
            $result = false;
        }
        return $result;
    }
    public function get_user_profile_modification_history($user, $date_format)
    {
        $reviewer_email_change_arr = array();
        $User = new \App\Models\User;
        $changable_fields = array(
            'usr_email' => 'reviewer email',
            'usr_first_name' => 'reviewer first name',
            'usr_last_name' => 'reviewer last name'
        );
        $reviewer_email_change_history = $User::get_user_profile_modification_history($user, $date_format);
        for ($i = count($reviewer_email_change_history) - 1; $i >= 0; $i--) {
            if (isset($reviewer_email_change_history[$i - 1])) {
                $hissrting = $reviewer_email_change_history[$i - 1]->ae_full_name . ' updated ';
                $ch_no = 0;
                foreach ($changable_fields as $field => $label) {
                    if ($reviewer_email_change_history[$i - 1]->$field != $reviewer_email_change_history[$i]->$field) {
                        $ch_no++;
                    }
                }

                $uch_no = 0;
                foreach ($changable_fields as $field => $label) {
                    if ($reviewer_email_change_history[$i - 1]->$field != $reviewer_email_change_history[$i]->$field) {
                        $uch_no++;
                        if ($uch_no > 1) {
                            if ($uch_no < 3 and $ch_no == 3) {
                                $hissrting .= ', ';
                            } else {
                                $hissrting .= ' and ';
                            }
                        }
                        $hissrting .= $label . ' from ' . $reviewer_email_change_history[$i - 1]->$field . ' to ' . $reviewer_email_change_history[$i]->$field;
                    }
                }
                if ($uch_no > 0) {
                    $reviewer_email_change_arr[$reviewer_email_change_history[$i]->unx_posted_date]['date'] = $reviewer_email_change_history[$i - 1]->usr_posted_date;
                    $reviewer_email_change_arr[$reviewer_email_change_history[$i]->unx_posted_date]['action_message'] = $hissrting;
                }
            }
        }
        return $reviewer_email_change_arr;
    }
    public function check_usr_account($user_id)
    {
        $User_unregister = new \App\Models\User_unregister;

        $condition = "uur_usr_id={$user_id} AND uur_request_status='y'";
        $check_status = $User_unregister::get_single_record('count(uur_id) as unregister', $condition);

        if ($check_status->unregister == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function set_login_tracker($type, $user, $ip_address,$user_type = 'normal')
    {

        $browser = Agent::browser();
        $b_version = Agent::version($browser);
        $browser_with_vrson = $browser . ' ' . $b_version;
        $platform = Agent::platform();
        $p_version = Agent::version($platform);
        if ($p_version !== FALSE) {
            $platform = $platform . ' ' . $p_version;
        }
        $data = array(
            'ltk_ip' => $ip_address,
            'ltk_browser' => $browser_with_vrson,
            'ltk_os' => $platform,
            'ltk_action_type' => $type,
            'ltk_user_type' => $user_type,
        );
        $curren_user = array();
        $current_user['user_id'] =  $user;
        $current_user['proxy_user_id'] = 0;
        $Login_tracking = new \App\Models\Login_tracking();

        $insert_data = $Login_tracking::insert_record($data, $current_user);
    }

    public function get_invite_email_attachments($art_id, $ane_id, $return_html = TRUE, $jnl_code = '',$type = '')
    {
        $Email_attachments = new \App\Models\Email_attachments;
        $temp_value = array();
        $rtn_arr = NULL;
        $condition = "emat_ane_id ={$ane_id} AND emat_art_id ={$art_id}";
        if ($type != '') {
            $condition .= " AND emat_for ='{$type}'";
        } 
        $email_attachments    =    $Email_attachments::get_all_records('*', $condition);
        if ($this->current_client->enable_upload_s3_bucket == 'y') {
            $mainpath="uploads/email_attachments/";
        }
        else
        {
            $mainpath="email_attachments/";
        }

        if (!empty($email_attachments)) {
            if ($return_html == TRUE) {
                $attch_file_html = '';
                foreach ($email_attachments as $atc) {
                    $emat_id    =    $atc->emat_id;
                    $emat_name    =    $atc->emat_file_name;
                    $emat_art_id =    $atc->emat_art_id;
                    $attach_path    =     $this->get_upload_path($mainpath . $art_id . '/' . $emat_name,TRUE);
                    $link        =    URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_code . '/download-files' . '?' . encrypt_link('path=' . $attach_path);
                    $data['link']        =    $link;
                    $data['attach_path']        =    $attach_path;
                    $data['ane_id']        =    $emat_id;
                    $data['ane_name']    =    $emat_name;
                    $data['ane_art_id']    =    $emat_art_id;
                    $data['document_size']    =    $atc->emat_document_size;
                    $temp_value[]	=	 $data;
                }
                $rtn_arr = $temp_value;

            } else {
                $attach_mod = $attachments = $files_attached = array();
                foreach ($email_attachments as $att) {
                    $attach_mod[$att->emat_id]  = $att->emat_file_name;
                    $path             =    $mainpath. $art_id . '/' . $att->emat_file_name;

                    $full_file_path             =    $this->get_upload_path($path ,TRUE);

                    $files_attached[$att->emat_file_name]   =   $full_file_path;
                }
				if(!empty($attach_mod) && (count($attach_mod) > 0)){
                    $attachments['modified'] = $attach_mod;
                }
                $attachments        =    json_encode($attachments);
                $rtn_arr['attachments'] = !empty($attachments) ? $attachments : NULL;
                $rtn_arr['files_attached'] = $files_attached;
            }
        }
        return $rtn_arr;
    }
    public function get_reply_to_email($jnl_id = NULL, $current_status = array())
    {
        $email_config = 'clients.' . $this->current_client->clnt_client_code;
        $email_config_data = Config::get($email_config . '.email');
        $replay_to_email = $email_config_data['email_settings']['reply_to_email'];
        $Journal_settings = new \App\Models\Journal_settings();
        $reply_to = '';
        if (isset($replay_to_email) && $replay_to_email != '') {
            $reply_to = $replay_to_email;
        }
        if ($this->current_client->functionality->cfty_enable_journal_reply_to == "y" && $jnl_id!=NULL) {
            // $jnl_data = $Journal_settings::get_single_record('jset_reply_to_email,jset_reply_to_email_traction', "jset_jnl_id={$jnl_id}");
            $jnl_data = $Journal_settings::get_single_record('jset_reply_to_email,jset_reply_to_email_traction', "jset_jnl_id= ?",binding_arr:[$jnl_id]);

            if ($jnl_data->jset_reply_to_email != "" && $jnl_data->jset_reply_to_email != NULL)
                $reply_to = $jnl_data->jset_reply_to_email;
        }
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow = Config::get($workflow_config);
        if (isset($current_status[0]) && isset($review_flow[$current_status[0]->jwf_stage_type]['stage_for']) && $review_flow[$current_status[0]->jwf_stage_type]['stage_for'] == 'manageproduction') {
            if (isset($jnl_data->jset_reply_to_email_traction) && $jnl_data->jset_reply_to_email_traction != "" && $jnl_data->jset_reply_to_email_traction != null)
                $reply_to = $jnl_data->jset_reply_to_email_traction;
        }
        return $reply_to;
    }

    public function user_permitted_role($user_id, $jnl_code, $article_type_id)
    {
        $user_active_roles_article_type = User_to_journals::get_journal_user_roles($user_id, $jnl_code, $article_type_id);
        if (!empty($user_active_roles_article_type)) {
            $user_permitd_roles = explode(';', $user_active_roles_article_type[0]->role_assigned_roles);
            if (in_array('staff', $user_permitd_roles)) {

                return TRUE;
            }
        }
        return FALSE;
    }

    public function update_parallel_flow($article_id, $current_jwf_id, $next_stage = NULL, $status = NULL)
    {

        $Articles = new \App\Models\Articles;
        $Article_flow = new \App\Models\Article_flow();
        $Generic_flows = new \App\Models\Generic_flows();
        $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
        $where_condition = "aflw_art_id={$article_id} AND apfm_status='a'";
        $add_where = 'FIND_IN_SET(' . $current_jwf_id . ',apfm_travel_path_ids) > 0';
        $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
        $orderby = 'apfm_id desc';
        $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where, $orderby);
        foreach ($get_path_having_jwf as $single_path) {
            $up_data = '';
            $where_condition = "aflw_art_id={$article_id} AND apfm_status!='c'";

            $travel_path_arr = explode(',', $single_path->apfm_travel_path_ids);
            $add_where = 'apfm_bgn_stg_jwf_id IN (' . $single_path->apfm_travel_path_ids . ')';
            $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
            $record_status = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where);
            if (count($record_status) == 1 || count($record_status) == 0 || count($travel_path_arr) == 1) {
                if ($next_stage !== NULL) {
                    if ($next_stage == $single_path->apfm_end_stg_jwf_id || count($record_status) == 0) {
                        $up_data = " apfm_status='" . $status . "' ";
                    }
                } else {
                    $up_data = " apfm_status='" . $status . "'"; // this was the one existed in this function
                }
            }
            if (!empty($up_data)) {
                $article_parallel_flow_movement_table = (new \App\Models\Article_parallel_flow_movement())->getTable();
                $condition = array("apfm_id" => $single_path->apfm_id);
                $sql = "update {$article_parallel_flow_movement_table} set " . $up_data . " where apfm_id =" . $single_path->apfm_id;
                $update_records = $Article_parallel_flow_movement::execute_query($sql, TRUE);
            }
        }
    }

    public function validate_duplicate_entry($post_data, $article_data)
    {
        $Article_flow = new \App\Models\Article_flow();
        $Roles = new \App\Models\Roles();
        $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
        $current_status_id = isset($post_data['art_flow_id']) ?  $this->decrypt_data($post_data['art_flow_id']) : '';
        $action = $post_data['data_choice'];
        
        //in conference, the production completed abstracts need to be export again in the batch decison page. So need of duplcation check.
        if($action == 'export_already_completed') {
            return true;
        }

        $platform_id = isset($post_data['jnl_id']) ? $post_data['jnl_id'] : '';
        $has_error = FALSE;
        $err_msg = '';
        if ($action == 'checkout') {
            $accepted_flow =  $Article_flow::get_single_record('aflw_status', "aflw_id={$current_status_id} and aflw_status !='u'");
            if (!empty($accepted_flow)) {
                $has_error = TRUE;
                $err_msg = ($accepted_flow->aflw_status == 'a') ? customTrans('viewarticle.checkout_duplicate_err') : customTrans('viewarticle.completed_duplicate_err');
            }
        } elseif ($action == 'resubmission') {
            $accepted_flow =  $Article_flow::get_single_record('aflw_status', "aflw_id={$current_status_id} and aflw_status !='u'");
            if (!empty($accepted_flow)) {
                $has_error = TRUE;
                $err_msg =  ($accepted_flow->aflw_status == 'a') ? customTrans('viewarticle.resubmission_duplicate_err')  : customTrans('viewarticle.completed_duplicate_err');
            }
        } elseif ($action == 'decline') {
            $declined_flow =  $Article_flow::get_single_record('count(*) as cnt', "aflw_id={$current_status_id} and aflw_status='d'");
            if ($declined_flow->cnt > 0) {
                $has_error = TRUE;
                $err_msg = customTrans('viewarticle.decline_duplicate_err');
            }
        } elseif ($action == 'accept') {
            $accepted_flow =  $Article_flow::get_single_record('aflw_status', "aflw_id={$current_status_id} and aflw_status != 'i'");
            if (!empty($accepted_flow)) {
                $has_error = TRUE;
                $err_msg = ($accepted_flow->aflw_status == 'a') ? customTrans('viewarticle.accept_duplicate_err')  : customTrans('viewarticle.completed_duplicate_err');
            }
        } else {
            $completed_flow =  $Article_flow::get_single_record('count(*) as cnt', "aflw_id={$current_status_id} and aflw_status='c'");
            if ($completed_flow->cnt > 0) {
                $has_error = TRUE;
                $err_msg = customTrans('viewarticle.completed_duplicate_err');
            }
        }

        if ($has_error == TRUE) {
            $select = 'jwf_role_id';
            $articleflow_table = (new \App\Models\Article_flow)->getTable();
            $genericflow_table = (new \App\Models\Generic_flows)->getTable();
            $art_flw_tables = array(
                'main_table' => $articleflow_table,
                'join_table' => array(
                    $genericflow_table => array($articleflow_table . '.aflw_jwf_id', $genericflow_table . '.jwf_id'),
                )
            );
            $art_flw_criteria = 'aflw_id=' . $current_status_id;
            $article_flow_dets = $Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'single');
            $stage_role = Roles::get_single_record('role_assigned_role', 'role_id=' . $article_flow_dets->jwf_role_id);
            $view_article = ($stage_role->role_assigned_role == 'author') ? 'author-article' : 'view-article';
            /*$jnl_code = $article_data->jnl_journal_code;
            $redirect_url = base_url('journal/' . $jnl_code . '/' . $view_article . '?' . encrypt_link('status_id=' . $current_status_id . '&article_id=' . $article_id));
            $redirect_jnl_url = base_url('journal/' . $jnl_code);
            $return_data = array('status' => 'failed', 'msg' => $err_msg, 'duplicate_status' => 'yes', 'redirect' => $redirect_url, 'redirect_jnl' => $redirect_jnl_url);*/
            $return_data = array('status' => 'failed', 'msg' => $err_msg, 'duplicate_status' => 'yes', 'viewstatus' => $view_article);
            return $return_data;
        }
        return true;
    }

    public function active_parallel_flow($article_id, $jwf_id)
    {
        $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
        $article_parallel_flow_movement_table = (new \App\Models\Article_parallel_flow_movement())->getTable();
        $where_condition = "aflw_art_id={$article_id} AND apfm_status='c'";
        $add_where = 'FIND_array_intersect("' . $jwf_id . '",apfm_travel_path_ids) > 0';
        $select = "group_concat(apfm_id) as ids";
        $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where);
        if (!empty($get_path_having_jwf)) {
            $ids = $get_path_having_jwf[0]->ids;
            if (!empty($ids)) {
                $sql = "update {$article_parallel_flow_movement_table} set apfm_status = 'a' where apfm_id IN (" . $ids . ")";
                $update_records = $Article_parallel_flow_movement::execute_query($sql, TRUE);
            }
        }
    }

    public function reviewer_privilage_check($art_id=NULL)
	{
        $articleflow_table = (new \App\Models\Article_flow)->getTable();
        $genericflow_table = (new \App\Models\Generic_flows)->getTable();
        $article_table = (new \App\Models\Articles)->getTable();
        $roles_table = (new \App\Models\Roles)->getTable();

        $this->current_user = $this->get_current_user_details();
        $tables = array(
			'main_table' => $articleflow_table,
			'join_table' => array(
				$genericflow_table => array('jwf_id','aflw_jwf_id')
			)
		);
        //aflw_status
		$form_criteria = 'aflw_art_id = ' . $art_id . ' AND aflw_usr_id = ' . $this->current_user['user_id'] . ' AND jwf_stage_type = "review" ';
		$active_review_stages = Article_flow::get_results_using_joins($tables,'aflw_status', $form_criteria);
		$review_status = array();
		foreach ($active_review_stages as $each_review_stage) {
			$review_status[] = $each_review_stage->aflw_status;
		}
		if (isset($active_review_stages) && count($active_review_stages)>0) {
			if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
				return FALSE;
			} else {
				$tables = array(
					'main_table' => $articleflow_table,
					'join_table' => array(
						$genericflow_table => array('jwf_id','aflw_jwf_id'),
						$article_table => array('aflw_art_id','art_id'),
						$roles_table => array('jwf_role_id','role_id')
					)
				);
				$select = 'aflw_id,aflw_usr_id,aflw_status,aflw_posted_by,jwf_stage_type,role_assigned_role,art_stage_submission_method,aflw_parent_flow_id';
				$form_criteria = 'aflw_art_id = ' . $art_id . ' ';
				$all_stages = Article_flow::get_results_using_joins($tables, $select, $form_criteria);
				// echo "<pre>";	print_r($all_stages);die;
				$i = 0;
				foreach ($all_stages as $each_stage) {
					if ($each_stage->jwf_stage_type == 'author_submission' && $each_stage->art_stage_submission_method == 'b' && $each_stage->aflw_posted_by == $this->current_user['user_id']) {
						$i++;
					} elseif ($each_stage->jwf_stage_type == 'review' && $each_stage->aflw_parent_flow_id != NULL) {
						$select_reviewer_posted_data = 'select aflw_posted_by from tbk_article_flow where  aflw_art_id=' . $art_id . ' and aflw_id=' .$each_stage->aflw_id . ' and aflw_parent_flow_id != "NULL" and aflw_usr_id != aflw_posted_by and aflw_posted_by='.$this->current_user['user_id'];
						$reviewer_posted_data = Article_flow::get_records_by_raw_query($select_reviewer_posted_data);

                        //if(in_array($this->current_user['user_id'],$reviewer_posted_data))
                        if(!empty($reviewer_posted_data))
						{
						$i++;
						}
					} elseif (!in_array($each_stage->role_assigned_role, array('author', 'reviewer')) && ($each_stage->aflw_usr_id == $this->current_user['user_id'])) {
						$i++;
					}
				}
			}
			if ($i > 0) {
				if (in_array('a', $review_status)) {
					return FALSE;
				} else {
					return TRUE;
				}
			} else {
				return FALSE;
			}
		} else {
			return TRUE;
		}
	}

    /**
     * This function decides whether to display the author name or not.
     */
    public function show_author_name($article_data)
    {
        $show_author_details = TRUE;
        $this->current_user = $this->get_current_user_details();
        $reviewer_privilage = $this->reviewer_privilage_check($article_data->art_id);

        if(!isset($article_data->artp_id))
            $article_data->artp_id = $article_data->art_artp_id;

        $jnl_code = NULL;
        if(isset($article_data->jnl_journal_code))
        {
            $jnl_code = $article_data->jnl_journal_code;
            $art_jnl_code = $jnl_code;
        }else{
            $art_jnl_code = (new Articles())->with('journals')->find($article_data->art_id)->journals->jnl_journal_code;
        }

        $privillaged_user = $this->article_privilages($article_data,NULL,$jnl_code,'all',TRUE);
        //$article_data, $curr_flw_id = NULL, $journal_code = NULL, $specify = 'all',$test = FALSE
        if (($article_data->atotp_review_method == 'd' && $reviewer_privilage == FALSE) )
		{
			$show_author_details = FALSE;
		}
        if($this->is_custom_blinded('author', $article_data->art_id, jnl:$art_jnl_code)){
            $show_author_details = FALSE;
        }

        $show_authors = FALSE;
		if ($article_data->atotp_review_method != 'd' && $article_data->atotp_review_method != 'c')
		{
			$show_authors = TRUE;
		}
        elseif (($article_data->atotp_review_method == 'd' && ($privillaged_user['author'] == TRUE || (($privillaged_user['privilaged'] == TRUE && $privillaged_user['reviewer'] == FALSE) || ($privillaged_user['reviewer'] == TRUE && $privillaged_user['user_allocated'] == TRUE)) ) && $show_author_details == TRUE))
		{
			$show_authors = TRUE;
		}
        if($article_data->atotp_review_method != 'd' && !$this->is_custom_blinded('author',$article_data->art_id,jnl:$art_jnl_code)){
            $show_authors = true;
        }
        return $show_authors;
    }

    public function format_head_article($article_list, $jnl_id, $jnl_code,$curr_role_id = NULL,$section = NULL)
    {
        $article_base_array = array();
        $this->current_user = $this->get_current_user_details();
        $articleflow_table = (new \App\Models\Article_flow)->getTable();
        $genericflow_table = (new \App\Models\Generic_flows)->getTable();
        $article_table = (new \App\Models\Articles)->getTable();
        $roles_table = (new \App\Models\Roles)->getTable();
        foreach ($article_list as $article) {
            $article->jnl_journal_code = $jnl_code;
            $artp_id = isset($article->art_artp_id) ? $article->art_artp_id : NULL;

            $show_author = $this->show_author_name($article);

            if($show_author == true)
            {
                $article->articlecode = $article->art_code;
                $author_id = $article->art_submitted_by;

                if(empty($article->art_submitted_by))
                {
                    if(isset($article->art_stage_submission_method) && ($article->art_stage_submission_method == 'n' || $article->art_stage_submission_method == 'z') && isset($article->art_posted_by))
                    {
                        $article->art_submission_date_format = '';
                        $author_id = $article->art_posted_by;
                    }
                }
                $array_data['user_id'] = $author_id;
                $array_data['journal_id'] = $jnl_id;
                $array_data['flag'] = TRUE;
                $array_data['article_id'] = $article->art_id;
                $array_data['jnl_code'] = $jnl_code;
                $array_data['artp_id'] = $artp_id;
                $article->user_full_name = $this->get_user_display_name($array_data);

                $article->corresp_suptag = false;
                $article->corresp_author_name_tag = false;

                if(!empty($article->auth_corr_author_list))
                {
                    $author_list = explode(',',$article->auth_corr_author_list);

                    if(count($author_list) > 1)
                    {
                    $article->auth_corr_author_list = $author_list[0];
                    }

                    if(in_array($article->art_submitted_by,$author_list))
                    {
                        $article->corresp_suptag = true;//here check submitting author
                    }
                    else
                    {
                        $article->corresp_author_name_tag = true;//here corresp. author
                        $array_data['user_id'] = $article->auth_corr_author_list;
                        $array_data['journal_id'] = $jnl_id;
                        $array_data['flag'] = TRUE;
                        $array_data['article_id'] = $article->art_id;
                        $array_data['jnl_code'] = $jnl_code;
                        $array_data['artp_id'] = $artp_id;
                        $article->corresp_user_full_name = $this->get_user_display_name($array_data);
                    }
                }
            }
            //formatted art_epub_date
            $article->formatted_art_epub_date = '';
            if(isset($article->formatted_art_epub_date) && isset($this->current_client->modules->mdl_production) &&  $this->current_client->modules->mdl_production == 'y')
            {
                if(isset($article->rv_art_epub_date))
                {
                $article->formatted_art_epub_date = $article->rv_art_epub_date;
                if(!isset($article->art_epub_date_flag))
                {
                    $article->art_epub_date_flag = FALSE;
                }
               }
            }

            //article code
            /*$is_special = FALSE;
            if ($article->artp_special_issue == 'y') {
                $is_special = TRUE;
            }*/
            $is_special=$this->check_special_issue_in_article($article);
            //Bug #2482 - ADD invited article along with aricle code
            $is_invited = FALSE;
            if (isset($article->art_stub) && $article->art_stub != 'n') {
                $is_invited = TRUE;
            }

            $article->art_code = $this->get_article_display_code($article->art_id, $jnl_id, $is_special, $is_invited,role_id:$curr_role_id);
            $article->article_due = '';
            if (isset($article->due_date) && $article->due_date != '') {
                $deu_temp = '';
                if ($article->rvd_remaining_days < 0)
                    $deu_temp = ' (' . abs($article->rvd_remaining_days) . ' days overdue)';
                $due_date_class = $this->get_due_date_class($article->rvd_remaining_days);
                //$article->article_due = '| <span class="'.$due_date_class.'">Due: <strong>'.$article->due_date.$deu_temp.'</strong></span>';
            }

            $is_reviewer = TRUE;
            $privleged_reviewer = $this->is_reviewer_privileged_user($article->art_id, NULL, FALSE, $article->art_artp_id);
            if ($privleged_reviewer == TRUE)
                $is_reviewer = FALSE;

            $edit_article_editable_array = $this->check_article_editable_action($article, $is_reviewer, $jnl_code,$curr_role_id);

            $article->article_editable = false;
            $article->delete_article = false;
            $article->article_title_class = 'col-lg-12';
            $tile_icon_count = 0;
            $tables = array(
                'main_table' => $articleflow_table,
                'join_table' => array(
                    $genericflow_table => array('jwf_id','aflw_jwf_id'),
                    $article_table => array('aflw_art_id','art_id'),
                    $roles_table => array('jwf_role_id','role_id')
                )
            );
            $select = 'aflw_id,aflw_usr_id,aflw_status,aflw_posted_by,jwf_stage_type,role_assigned_role,art_stage_submission_method,aflw_parent_flow_id';
            $form_criteria = 'aflw_art_id = ' . $article->art_id . ' ';
            $orderby = 'aflw_id DESC';
            $stages = Article_flow::get_results_using_joins($tables, $select, $form_criteria, 'single', $orderby, NULL, '', NULL, NULL);
            if(isset($edit_article_editable_array['edit_article_status']) && $edit_article_editable_array['edit_article_status'] == TRUE && $stages->jwf_stage_type != "author_submission" && $stages->aflw_status != "c")
            {
                $article->article_editable = true;
                $tile_icon_count++;
                if(isset($article->art_stage_submission_method) && $article->art_stage_submission_method == 'n')
                {
                    $article->article_editable_link = 'edit-article-production';
                }
                else
                {
                    $article->article_editable_link = 'edit-article';
                }
                $article->article_title_class = 'col-sm-10 col-lg-11';
                if(isset($this->current_client->functionality->cfty_enable_article_delete) && $this->current_client->functionality->cfty_enable_article_delete == 'y')
                {
                    if(isset($jnl_code)&&isset($this->current_user['user_id']))
                    {
                    $user_roles= $this->validate_user_journal($jnl_code,$this->current_user['user_id']);
                    $Journal_settings = new \App\Models\Journal_settings();
                    $user_permission_roles =$Journal_settings::get_single_record_with_bind_cond('jset_manage_article',array("jset_jnl_id"=>$jnl_id));
                    if($user_permission_roles->jset_manage_article != NULL)
                    $manage_article = json_decode($user_permission_roles->jset_manage_article);

                    if(isset($user_roles['role_id'])&&(isset($manage_article))&&array_intersect($user_roles['role_id'],$manage_article))
                    {
                    $article->delete_article = true;
                    $tile_icon_count++;
                    }
                    }
                    $article->encrypt_art_id = $this->encrypt_data($article->art_id);
                    $article->artp_id = $this->encrypt_data($artp_id);
                    $article->jnl_id = $this->encrypt_data($jnl_id);
                    $article->jnl_code = $this->encrypt_data($jnl_code);
                    $article->article_title_class = 'col-sm-10 col-lg-10';
                }
            }
            if(isset($article->art_es_document_status) && $article->art_es_document_status == 'y' && isset($article->art_es_document_type) && $article->art_es_document_type !== null)
            {
                $tile_icon_count++;
            }
            if($tile_icon_count > 0 && $tile_icon_count < 3)
            {
                $article->article_title_class = 'col-sm-10 col-lg-11';
            }
            if($tile_icon_count == 3)
            {
                $article->article_title_class = 'col-sm-10 col-lg-10';
            }
            if($section=="search")
            {
                if($stages->aflw_status!='h')
                {
                    $article->aflw_id = $stages->aflw_id;
                }
                else
                {
                    $reviewtage = Article_flow::get_single_record('aflw_id', "aflw_art_id= ".$article->art_id." and aflw_status='w'",null,'','aflw_id DESC');  
                    if(isset($reviewtage) && !empty($reviewtage->aflw_id))
                    {
                        $article->aflw_id = $reviewtage->aflw_id;
                    }
                }
            }
            $article_base_array[$article->art_id] = $article;
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {

                $art_flw_tbl    =   (new Article_flow())->getTable().' as af';
                $jnl_flw_tbl    =   (new Generic_flows())->getTable().' as jw';
                $curr_tbl       =   (new \App\Models\Currency_master())->getTable().' as cm';
                $pmnt_tbl       =   (new Payment_order())->getTable().' as po';
                $cnd    =   "po.pmt_ord_art_id = ?  and po.pmt_transaction_status = 'fn' and jw.jwf_stage_type IN ('author_submission','revision') and jwf_enable_payment = 'y'";
                $binding_arr    =   [$article->artp_id];
                // if ($aflw_id != NULL) {
                //     $cnd .= 'and po.pmt_ord_aflw_id = ?';
                //     $binding_arr[]  =   $aflw_id;
                // }
                $slct   =   "cm.curr_symbol,cm.curr_code,jw.jwf_payment_fees,po.pmt_ord_transaction_id,jw.jwf_stage_type,po.pmt_ord_card_no,po.pmt_ord_id,po.pmt_ord_price";
                $tables =   [
                    "main_table"    =>  $pmnt_tbl,
                    "join_table"    =>  [
                        $art_flw_tbl    =>  ['af.aflw_id','po.pmt_ord_aflw_id'],
                        $jnl_flw_tbl    =>  ['jw.jwf_id','af.aflw_jwf_id'],
                        $curr_tbl       =>  ['cm.curr_id','jw.jwf_curr_id']
                    ]
                ];
                $Payment_order_details  =   Payment_order::get_results_using_joins($tables,$slct,$cnd,'all',binding_arr:$binding_arr);
                // $Payment_order_details ->pmt_ord_transaction_id !=''?$article->payment=true:$article->payment=false;

                // $return_array['payment_details'] = count($Payment_order_details) > 0 ? 'true':'null';
            }
            $article->articleFlags = $this->get_article_flags_formatted($article->art_id,$jnl_code);
        }
        return  $article_base_array;
    }

    public function display_stage_name($stage_data,$user_privilage=FALSE)
    {
        $stage_name = (isset($stage_data->jwf_stage_name))?$stage_data->jwf_stage_name:'';
        $temp_stage_name = (isset($stage_data->jwf_temporary_status_name))?$stage_data->jwf_temporary_status_name:'';
        $status_name = (isset($stage_data->jwf_status_name))?$stage_data->jwf_status_name:'';

        $stage_status = (isset($stage_data->aflw_status))?$stage_data->aflw_status:'';

        $formated_stage_name = '';
        if($user_privilage == FALSE)
        {
            if($stage_status == 'u' || $stage_status == 'i')
            {
                $formated_stage_name = ($temp_stage_name!='')?$temp_stage_name:$status_name;
            }
            elseif($stage_status == 'a' || $stage_status == 'c' || $stage_status == 'w' || $stage_status == 'p' || $stage_status =='d' || $stage_status =='g')
            {
                $formated_stage_name = $status_name;
            }
        }
        elseif($user_privilage == TRUE)
        {
            $formated_stage_name = $stage_name;
        }
        return $formated_stage_name;
    }

    public function arrange_article_stages($stages, $jnl_code, $jnl_id, $core_role, $type, $my_task,$curr_role_id = NULL,$section = '',$date_format = '')
    {
        $art_stages = $art_list = array();
        $journal_settings = $this->platform_basic_settings_data($jnl_code);
        $privileged_user_arttype = FALSE;
        $invite_permission = FALSE;
        $allocation_user = array();
        $user_name_arr = array();
        $privileged_user_roles = $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
        $jnl_array = array("jnl_id" => $jnl_id, "jnl_code" => $jnl_code);
        $this->current_user = $this->get_current_user_details();
        $global_es_data_arr = array();
        if (in_array($core_role, $privileged_user_roles)) {
            $privileged_user_arttype = TRUE;
        }
        if (count($stages) > 0) {
            $client_code = $this->current_client->clnt_client_code;
            $this->review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');

            $role_arr = $this->set_all_roles_key_value();
            $collection = collect($stages);
               
            $unique_city_ids = $collection->pluck('art_id')->unique()->values();
            $arr_stat = array();
            
       
           if(!empty($unique_city_ids))
           {
              foreach($unique_city_ids as $artid)
              { 
                if($artid !='') 
                {
                $qry = 'SELECT `art_id`, flow_details.jwf_stage_name,(SELECT aflw_id FROM rvw_article_flow WHERE aflw_art_id ='.$artid.' ORDER BY CASE WHEN aflw_level = 1 THEN ROW_NUMBER() OVER (ORDER BY aflw_id) ELSE aflw_level END DESC LIMIT 1) AS last_aflwid FROM rvw_articles INNER JOIN( SELECT jwf_stage_name, aflw_id,aflw_art_id FROM rvw_article_flow INNER JOIN rvw_journal_workflows ON aflw_jwf_id = jwf_id AND jwf_stage_type = "resubmission" WHERE aflw_status = "a" OR aflw_status = "c" ) AS flow_details ON flow_details.aflw_art_id = art_id WHERE art_prev_article_id = '.$artid;
                $rvsn_rcrd= Articles::get_records_by_raw_query($qry);
           
                if(!empty($rvsn_rcrd))
                {
                
                $arr_stat[$rvsn_rcrd[0]->last_aflwid] = $rvsn_rcrd[0]->jwf_stage_name;
                }
                
               /* if($val !='')
                {
                //$lasid = $collection->where('art_id', $val)->pluck('aflw_id')->last();
                $lasid = Article_flow::where('aflw_art_id', $val)->get('aflw_id')->last();
                $arr_stat[$lasid->aflw_id] = $key ;
                }*/
            }
              }           
           }
           /*Task #92 taskbot  Change the status of editor decision when article moved to revision stage .If additional reviews (more reviewers) are performed from the Editor Decision stage, the Editor Decision entry should appear below the Review entry once the review stage is completed. Additionally, the new status should be updated and displayed in the Editor Decision entry accordingly.  */
           $checkempty = $collection->pluck('rn')->filter()->isNotEmpty();
           
            if ($checkempty == true) {
                $sort_stage = $collection->toArray();
                usort($sort_stage, function ($a, $b) {
                    if ($a->jwf_stage_type == 'transit' && $b->jwf_stage_type != 'transit' || $a->jwf_stage_type != 'transit' && $b->jwf_stage_type == 'transit') {
                        return strcmp($a->rn, $b->rn);
                    }
                });
                $stages = collect($sort_stage)->map(function ($item) {
                    return (object) $item; // Convert each item to an object
                })->toArray();
            }
             /*Task #92 taskbot  Change the status of editor decision when article moved to revision stage If additional reviews (more reviewers) are performed from the Editor Decision stage, the Editor Decision entry should appear below the Review entry once the review stage is completed. Additionally, the new status should be updated and displayed in the Editor Decision entry accordingly.  */
           $emt    =   1;
           $emf    =   1;
            foreach ($stages as $key => $art_stage)
            {
                $org_submission = TRUE;
                if(isset($art_stage->art_stage_submission_method) && ($art_stage->art_stage_submission_method == 'n' || $art_stage->art_stage_submission_method == 'z') && $art_stage->art_status == 'n' && $art_stage->jwf_stage_type == 'author_submission')
                {
                    $org_submission = FALSE;
                    $art_stage->aflw_accepted_date = '';
                }
                $art_stage->fn_type = $type; //for identify the area todo = d,tile=t, overview = o
                $art_stage->fn_section = $section;//for identfy the sub section eg: which tile, which overview section
                if(!isset($allocation_user[$art_stage->art_id]))
                {
                    $allocation_user = $this->get_allocated_users_list(array($art_stage->art_id));
                }
                $route_url = '';
                $core_stage = $art_stage->jwf_stage_type;
                $art_stage->assigned_user = '';
                $art_stage->art_submitted_by_id = $art_stage->art_submitted_by;
                $is_reviewer = TRUE;
                if (isset($is_art_reviewer_arr[$art_stage->art_id])) {
                    $is_reviewer = $is_art_reviewer_arr[$art_stage->art_id];
                } else {

                    $privleged_reviewer = $this->is_reviewer_privileged_user($art_stage->art_id, NULL, FALSE, $art_stage->art_artp_id);
                    if ($privleged_reviewer == TRUE)
                        $is_reviewer = FALSE;

                    $is_art_reviewer_arr[$art_stage->art_id] = $is_reviewer;
                }

                $skip_review_author = FALSE;
                if ($this->current_client->modules->mdl_review_for_doc == 'y') {
                    $array_skip_review_author_roles = array('author', 'reviewer', 'staff', 'journal_admin');
                    if (in_array($core_role, $array_skip_review_author_roles)) {
                        $skip_review_author = TRUE;
                    }
                }

                $is_author=FALSE;
                if (isset($is_art_author_arr[$art_stage->art_id])) {
                    $is_author = $is_art_author_arr[$art_stage->art_id];
                } else {
                    $Authors = new \App\Models\Authors;
                    $chk_author = $Authors::get_single_record('count(auth_id) as count', 'auth_usr_id=' . $this->current_user['user_id'] . ' AND auth_art_id=' . $art_stage->art_id);
                    $is_author = (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;
                    $is_art_author_arr[$art_stage->art_id] = $is_author;
                }

                //if ($art_stage->art_status == 'n') {
                if($is_author == TRUE || $org_submission == FALSE){
                    $art_stage->authorurl = FALSE;
                    if($is_author == TRUE)
                        $art_stage->authorurl = TRUE;
                    $art_stage->status_link = $this->author_status_link($art_stage, $is_reviewer, $jnl_code);
                } else {
                    $art_stage->status_link = $this->set_article_url($art_stage, $skip_review_author, $core_role);
                }

                if($is_author == TRUE /* && $section == 'manage-peer-review'*/)
                {
                    $org_submission = FALSE;
                }

                $art_stage->due_date_show = TRUE;
                if($is_author == TRUE || $is_reviewer == TRUE )
                {
                    if($curr_role_id != $art_stage->jwf_role_id)
                        $art_stage->due_date_show = FALSE;
                }
                $flow_status_arr = array('u','i','a','w','p');
                if(!in_array($art_stage->aflw_status,$flow_status_arr) )
                {
                    $art_stage->due_date_show = FALSE;
                }

                $shorlist_permission = FALSE;
                if ($my_task == FALSE) {
                    $shorlist_permission = TRUE;
                    $invite_permission = TRUE;
                } else //if(isset($art_list->$temp_art_id))
                {
                    //$shorlist_permission = $art_list->$temp_art_id->shortlist_permission;
                    //$invite_permission = $art_list->$temp_art_id->invite_permission;
                    if (isset($art_stage->shortlist_permission))
                        $shorlist_permission = $art_stage->shortlist_permission;
                    if (isset($art_stage->invite_permission))
                        $invite_permission = $art_stage->invite_permission;
                }
                //$art_stage->artp_id = $art_stage->art_artp_id;
                //$privillaged_user = $this->article_privilages($art_stage,$art_stage->aflw_id);

                $due_date_array=$this->format_due_date($art_stage,$jnl_id);

			    $art_stage->due_date=$due_date_array['due_date'];
			    $art_stage->expired=$due_date_array['expired_status'];
                $mng_flow_status_w = '';
                if($org_submission == TRUE)
                {
                    $assigned_details = $this->get_assiged_user_details($art_stage, $role_arr, $shorlist_permission, $invite_permission, $allocation_user, $jnl_array);

                    $assigned_roles = implode(', ',  $assigned_details['assigned_role']);
                    $art_stage->assigned_text = $assigned_details['assigned_text'];
                    $art_stage->assigned_role = $assigned_roles;
                    $art_stage->allocated_user_arr =  $assigned_details['assigned_users'];
                    $mng_flow_status_w = $assigned_details['manage_flow_status'];
                }
                if($key == (count($stages) - 1) && $art_stage->aflw_status == 'c' && $art_stage->art_delete_status == 'w')
                {
                    $art_stage->art_current_status = customTrans('dashboard.art_withdrawn');
                }
                elseif($art_stage->art_status=="t" && $art_stage->jwf_stage_type!='transit' && $art_stage->aflw_status != 'c' )
                {
                    $art_stage->art_current_status = customTrans("dashboard.art_transfer");
                }
                else
                {
                    $art_stage->art_current_status = $mng_flow_status_w .' '. $this->formated_article_status($art_stage,$jnl_code);
                  
                    if(!empty($arr_stat))
                    {
                    if (array_key_exists($art_stage->aflw_id,$arr_stat))
                     {
                        $art_stage->art_current_status =  $art_stage->art_current_status.' and sent for '.ucfirst(strtolower($arr_stat[$art_stage->aflw_id]));                  
                     }
                    }
                   
                }

                $hold_baldge_reason = '';
                $art_stage->export = FALSE;
                if($art_stage->aflw_status == 'c' && $art_stage->jwf_stage_type == 'production' && $this->current_client->modules->mdl_production == 'n')
                {
                    $export_data = DB::select('SELECT DATE_FORMAT(exp_posted_date,"' . $date_format . ' %H:%i") AS export_date FROM rvw_article_export_data WHERE exp_art_id = '.$art_stage->art_id.'  ORDER BY exp_id desc limit 1');
                    // commited for muneer
                    if(!empty($export_data))
                    {
                    $art_stage->export = TRUE;
                    $art_stage->export_date = $export_data[0]->export_date;
                    }
                }

                $art_stage->hold_baldge_reason = $hold_baldge_reason;
                if (isset($jwf_status_name_array[$art_stage->aflw_status]))
                    $art_stage->art_current_status = $mng_flow_status_w.' '.$jwf_status_name_array[$art_stage->aflw_status];

                //$art_stage->formated_stagename = $art_stage->jwf_stage_name . ' ' . $mng_flow_status_w;

                $formated_stagename = $this->display_stage_name($art_stage,$privileged_user_arttype);
                $art_stage->formated_stagename =  $formated_stagename;
                $art_stage->privileged_user_arttype = $privileged_user_arttype;


                $this->date_status($art_stage, $privileged_user_arttype, $core_role);
                $art_stage->article_due = '';
                $due_date_change = FALSE;

                $edit_article_editable_array = $this->check_article_editable_action($art_stage, $is_reviewer, $jnl_code, $curr_role_id);

                if ($edit_article_editable_array['due_date_extend_status'] == TRUE) {
                    $due_date_change  = TRUE;
                }

                $art_stage->edit_due_date = FALSE;
                if ($due_date_change == TRUE && isset($art_stage->rvd_aflw_due_date) && isset($art_stage->aflw_returned_date) && empty($art_stage->aflw_returned_date)) {
                    $art_stage->edit_due_date = TRUE;
                    //$art_stage->due_date_show = TRUE;
                }

                /* if($art_stage->$due_change_field != '')
                                    {
                                        $deu_temp = '';
                                        if($art_stage->$due_remaining_days < 0)
                                            $deu_temp = ' ('.abs($art_stage->$due_remaining_days).' days overdue)';
                                        $art_stage->article_due = $art_stage->$due_change_field_modified.$deu_temp;
                                    }
                                    */
                if($section == 'open-generic-discussion')
                {
                    $art_stage->assigned_user = '';
                    $art_stage->aflw_returned_date = '';
                }
                $art_stage->show_action_button = FALSE;
                $art_stage->es_article = false;
                $check_es_article = $this->check_espermission_access(array('article_id' => $art_stage->art_id));
                $main_converted = false;       
                if($check_es_article == true)
                {
                    $article_data = (object) [
                        'artp_id' =>$art_stage->art_artp_id,
                        'art_id' =>$art_stage->art_id,
                        'artp_fwm_id'=>$art_stage->artp_fwm_id,
                        'jnl_journal_code'=>$jnl_code,
                        'art_artp_id'=>$art_stage->art_artp_id
                    ];
                    $article_privilages = $this->article_privilages($article_data,NULL,$jnl_code,'all',TRUE);
    
                    $check_arr = array('art_id' => $art_stage->art_id,'artp_id' => $art_stage->art_artp_id,'role_id' => $curr_role_id,'core_role' => $core_role,'article_privillages' => $article_privilages);
                    $has_es_main_doc_permission = $this->main_doc_permission($check_arr);
                    $check_main_doc_type = Articles::get_single_record_with_bind_cond('art_es_document_type,art_es_document_status',array('art_id' => $art_stage->art_id));
                    if($check_main_doc_type->art_es_document_type == 'u' && $has_es_main_doc_permission == true)
                    {
                         $attachmenttable = (new \App\Models\Attachment_files())->getTable();
                         $attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
                            $tables = array(
                            'main_table' => $attachmenttable,
                            'join_table' => array(
                                $attachment_file_description_table => array($attachment_file_description_table . '.afdec_id', $attachmenttable . '.atmnt_label',"inner"),)
                            );
                        $criteria = 'afdec_main_document = \'y\' AND atmnt_doc_created_in_es = \'y\' AND atmnt_art_id ='.$art_stage->art_id;
                        $select = 'count(atmnt_id) as cnt';
                        $main_doc_created = Attachment_files::get_results_using_joins($tables, $select, $criteria);
                        if($main_doc_created[0]->cnt > 0)
                        {
                            $main_converted = true;
                        }    
                    }
                    if($check_main_doc_type->art_es_document_type == 'n' && $check_main_doc_type->art_es_document_status == 'y' && $has_es_main_doc_permission == true)
                    {
                        $main_converted = true;
                    }
                }
                $art_stage->show_start_resubmission = false;
                if($main_converted == true && !in_array($art_stage->aflw_status,['i','d','g']))
                {
                    $comment_mode = false;
                    $active_stage = false;
                    $es_data_array = array();
                    /*$article_data = (object) [
                        'artp_id' =>$art_stage->art_artp_id,
                        'art_id' =>$art_stage->art_id,
                        'artp_fwm_id'=>$art_stage->artp_fwm_id,
                        'jnl_journal_code'=>$jnl_code,
                        'art_artp_id'=>$art_stage->art_artp_id
                    ];
                    $article_privilages = $this->article_privilages($article_data,NULL,$jnl_code,'all',TRUE);*/
                    $comment_mode = false;
                    $active_stage = false;
                    if(in_array($art_stage->aflw_status,['a','u']))
                    {
                        $comment_mode = true;
                        $active_stage = true;
                    }
                    if($art_stage->aflw_status == 'w' || $art_stage->aflw_status == 'p')
                    {
                        $criteria = 'aflw_parent_flow_id = '.$art_stage->aflw_id;
                        $parent_count = Article_flow::get_single_record('count(aflw_id) as cnt', $criteria);
                        if($parent_count->cnt < $art_stage->aflw_stage_min_users)
                        {
                            $comment_mode = true;
                            $active_stage = true;
                        } 
                    }
                    if($article_privilages['author'] == true && $art_stage->jwf_stage_type == 'resubmission' && in_array($art_stage->aflw_status,['u']))
                    {
                        $comment_mode = false;
                        $active_stage = false;
                    }
                    $es_data_array['comment_mode'] = $comment_mode;
                    $user_roles= $this->validate_user_journal($jnl_code,$this->current_user['user_id']);
                    $role_data = Roles::get_single_record('role_assigned_role',"role_id={$art_stage->jwf_role_id}");
                    if(!isset($art_stage->jp_edit_article_files))
                    {
                        $jpm_id = Article_types::get_single_record('artp_jpm_id',"artp_id = {$art_stage->art_artp_id}");
                        if(!empty($jpm_id))
                        {
                            $edit_permission_data = Journal_permission::get_single_record('jp_edit_article_files',"jp_jpm_id={$jpm_id->artp_jpm_id}");
                            if($edit_permission_data !== null)
                            {
                                $art_stage->jp_edit_article_files = $edit_permission_data->jp_edit_article_files;
                            }
                        }
                    }
                    if((((isset($art_stage->jp_edit_article_files) && $art_stage->jp_edit_article_files != NULL) && count(array_intersect($user_roles['role_id'], json_decode($art_stage->jp_edit_article_files))) > 0 && $article_privilages['reviewer'] == false && $article_privilages['author'] == false && ($role_data->role_assigned_role !== 'author' || $article_privilages['privilaged'] == true)) || ($article_privilages['author'] == true && $role_data->role_assigned_role == 'author')) &&  $active_stage == true && ($art_stage->jwf_stage_type !== 'resubmission' || ($art_stage->jwf_stage_type == 'resubmission' && $art_stage->aflw_status !== 'u')))
                    {
                        $es_data_array['edit_mode'] = true;
                        $es_data_array['emt'] = $emt++;
                    }
                    else
                    {
                        $es_data_array['edit_mode'] = false;
                        $es_data_array['emf'] = $emf++;
                    }
                    $is_custom_form_usr = false;
                    if($art_stage->jwf_stage_type == 'review' && ($art_stage->aflw_status == 'a' || $art_stage->aflw_status == 'c') && $this->current_user['user_id'] == $art_stage->aflw_usr_id)
                    {
                        $is_custom_form_usr = true;
                    }
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
				    $es_api_data  = Config::get($es_config);
				    $es_data_array['es_url'] = $es_api_data['api_url'];
                    $es_data_array['is_custom_form_usr'] = $is_custom_form_usr;
                    $es_data_array['flow_id'] = $art_stage->aflw_id;
                    $art_stage->es_array = $es_data_array;
                    $art_stage->es_article = true;                
                   if($art_stage->jwf_stage_type == 'resubmission' && $article_privilages['author'] == true  && $this->current_user['user_id'] == $art_stage->aflw_usr_id)
                    {
                        if($art_stage->aflw_status == 'u')
                        {
                            $art_stage->show_start_resubmission = true;
                        }
                        else
                        {
                            $es_data_array['edit_mode'] = true;
                            $es_data_array['comment_mode'] = true;
                        }
                    }
                    $global_es_data_arr[$art_stage->art_id] = $es_data_array;
                }
                $art_stages[$art_stage->art_id][] = $art_stage;
                $art_list[$art_stage->art_id][] = $art_stage->aflw_id;
                if(isset($assigned_details['extra_invitation']) && $assigned_details['extra_invitation'] == TRUE)
                {
                    $art_stage_invt = new stdClass;
                    $art_stage_invt = clone $art_stage;

                    $assigned_details = $this->get_assiged_user_details($art_stage_invt, $role_arr, $shorlist_permission, $invite_permission, $allocation_user, $jnl_array,'invite_only');

                    $assigned_roles = implode(', ',  $assigned_details['assigned_role']);

                    $art_stage_invt->assigned_text = $assigned_details['assigned_text'];
                    $art_stage_invt->assigned_role = $assigned_roles;
                    $art_stage_invt->allocated_user_arr = $assigned_details['assigned_users'];
                    $art_stage_invt->is_blinded = $assigned_details['is_user_blinded'] ?? false;

                    $mng_flow_status_i = $assigned_details['manage_flow_status'];

                    $art_stage_invt->art_current_status = $mng_flow_status_i.' '.$this->formated_article_status($art_stage_invt,$jnl_code);
                    $hold_baldge_reason = '';

                    $art_stage_invt->hold_baldge_reason = $hold_baldge_reason;
                    if (isset($jwf_status_name_array[$art_stage_invt->aflw_status]))
                        $art_stage_invt->art_current_status = $mng_flow_status_i .''.$jwf_status_name_array[$art_stage_invt->aflw_status];

                    $formated_stagename = $this->display_stage_name($art_stage_invt,$privileged_user_arttype);
                    $art_stage_invt->formated_stagename = $formated_stagename ;

                    $art_stage_invt->rvd_aflw_due_date = $art_stage_invt->invite_due_date;
                    $art_stage_invt->rvd_remaining_days = $art_stage_invt->rvd_remaining_days_invite_due;

                    $due_date_array=$this->format_due_date($art_stage_invt,$jnl_id,'invite_only');
			        $art_stage_invt->due_date=$due_date_array['due_date'];
			        $art_stage_invt->expired=$due_date_array['expired_status'];

                    $art_stages[$art_stage_invt->art_id][] = $art_stage_invt;
                    $art_list[$art_stage_invt->art_id][] = $art_stage_invt->aflw_id.'i';
                }

            }
        }
        return array(
            'art_stages' => $art_stages,
            'art_list' => $art_list,
            'es_data_global_arr' => $global_es_data_arr
        );
    }

    //check advance search enable or not
    public function hasAdvanceSearch($jnl_id, $core_role)
    {
        $enable_advanced_search = FALSE;
        $non_privileged_user_roles = $this->RolesConfigdata('non_privileged_user_roles')['non_privileged_user_roles'];

        if ($jnl_id != '' && (isset($core_role) && (!in_array($core_role, $non_privileged_user_roles)))) {
            $this->current_user = $this->get_current_user_details();

            $User_to_journals = new \App\Models\User_to_journals();
            $user_id = $this->current_user['user_id'];
            $user_active_roles = $User_to_journals::get_active_user_roles($user_id, $jnl_id);

            $user_active_roles_array = array();
            if (isset($user_active_roles[0]->role_assigned_roles)) {
                $user_active_roles_array = explode(";", $user_active_roles[0]->role_assigned_roles);
                $privileged_user_roles = $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
                if (!empty(array_intersect($privileged_user_roles, $user_active_roles_array))) {
                    $enable_advanced_search = TRUE;
                }
            }
        }
        return $enable_advanced_search;
    }


    public function unicode_correction_export($str)
    {
        //unicode and ther correction
        $unicode_correction_set = array(
            '&AMP;' => '&amp;',
            'Â¡ÅŽ'  => '',
            'Â'  => '',
            'Â€™'   => '\'',
            '&ndash;' => '-',
            '&thinsp;' => '',
            '&#039;' => '\'',
            '&lsquo;' => '\'',
            '&rsquo;' => '\'',
            '&nbsp;' => ' ',
        );
        $unicode        = array_keys($unicode_correction_set);
        $correct_code   = array_values($unicode_correction_set);
        $corrected_str = htmlspecialchars_decode(str_replace($unicode, $correct_code, $str), ENT_QUOTES);
        return $corrected_str;
    }
    /* public function get_blinded_users($art_id, $show_user_info = FALSE, $article_blind_permission = TRUE, $full_name_only = FALSE)
    {
        $blinded_usr_details = $usr_names = $blind_list = array();
        $blinded_usr_records = Blind_user_articles::get_single_record('bau_usr_ids', 'bau_art_id = ' . $art_id);
        if (isset($blinded_usr_records->bau_usr_ids)) {
            $blinded_usr_ids = implode(',', json_decode($blinded_usr_records->bau_usr_ids));
            $blinded_usr_details = $this->get_all_users('', $art_id, $blinded_usr_ids);
        }
        if ($show_user_info == TRUE) {
            if (!empty($blinded_usr_details)) {
                foreach ($blinded_usr_details as $bln_user) {
                    $usr_names[] = $this->get_user_display_name($bln_user->usr_id, $this->jnl_data->jnl_id, TRUE, $art_id, TRUE, FALSE, FALSE, NULL, TRUE, FALSE, FALSE, $full_name_only);
                }
                $blind_list = implode(', ', $usr_names);
                if ($article_blind_permission == TRUE && $full_name_only == FALSE) {
                    $blind_list .= '<span class="update_userList" data-artid=" ' . encrypt_link($art_id) . ' " title="Edit"><i class="btn fa fa-pencil"></i></span>';
                }
            } else {
                $blind_list = '<span id="span_userList"><a class="text-light add_userList" data-artid="' . encrypt_link($art_id) . '">Select user</a></span>';
                if ($article_blind_permission == FALSE) {
                    $blind_list = '<center>--</center>';
                }
                if ($full_name_only == TRUE) {
                    $blind_list = '--';
                }
            }
            return $blind_list;
        }
        return $blinded_usr_details;
    } */
    public function get_debug_status()
    {
        $General_settings = new \App\Models\General_Settings();
        $debug_data = $General_settings::where('gnl_id', 1)->get('gnl_debug_mode')->first();
        return  $debug_data;
    }
    // children
    public function addToArr(&$arr, $data, $expanded = false)
    {
        // Helper: build a node
        $node = [
            "id" => $data->cls_id,
            "title" => $data->term_name,
            "expanded" => $expanded,
            "dragDisabled" => true,
            "children" => []
        ];

        // If no parent, add directly to root
        if (empty($data->cls_primary_id) || $data->cls_primary_id == 0) {
            $arr[] = $node;
            return;
        }

        // Try to find the parent in the current tree
        $foundParent = $this->insertIntoTree($arr, $data->cls_primary_id, $node);

        // If parent not found → treat as root node
        if (!$foundParent) {
            $arr[] = $node;
        }
    }

    private function insertIntoTree(&$arr, $parentId, $childNode)
    {
        foreach ($arr as &$node) {
            if ($node['id'] == $parentId) {
                $node['children'][] = $childNode;
                return true;
            }

            if (!empty($node['children'])) {
                $found = $this->insertIntoTree($node['children'], $parentId, $childNode);
                if ($found) return true;
            }
        }
        return false;
    }


    //Task #424 Production Management
    public function validate_production_stage($stage_id = NULL, $review_workflow = NULL, $check_generic_form = FALSE)
    {
        $return = array(
            'status' => 'false',
            'msg' => ''
        );
        $post = FALSE;
        if ($stage_id == NULL) {
            parse_str($this->decrypt_data($_SERVER["QUERY_STRING"]), $_GET);
            $stage_id = $this->input->get('stg_id');
            $post = TRUE;
        }
        if ($review_workflow == NULL) {
            /* Load Library */
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_workflow  = Config::get($workflow_config);
        }
        if ($stage_id != '' && $review_workflow !=  NULL) {
            // $review_data = Article_flow::get_generic_flow('jwf_stage_type,jwf_forms,jwf_production_upload', 'aflw_id=' . $stage_id);
            $review_data = Article_flow::get_generic_flow('jwf_stage_type,jwf_forms,jwf_production_upload', 'aflw_id= ?',bind_data:[$stage_id]);
            $stage_type = $review_data[0]->jwf_stage_type;
            $stage_forms = $review_data[0]->jwf_forms;
            if (isset($review_workflow[$stage_type]['stage_for']) && $review_workflow[$stage_type]['stage_for'] == 'review') {  //in review stages this validation not needed
                return array(
                    'status' => 'success',
                );
                exit;
            }
            $generic_form_validation = TRUE;
            if ($check_generic_form == TRUE && isset($review_workflow[$stage_type]['generic_form'])) {
                $forms = json_decode($stage_forms);
                if ($review_workflow[$stage_type]['generic_form'] != -1 && count($forms) > 0) {
                    $genericform_element_table = (new \App\Models\Generic_form_elements())->getTable();
                    $genericform_table = (new \App\Models\Article_generic_form_data())->getTable();
                    $tables = array(
                        'main_table' => $genericform_element_table,
                        'join_table' => array(
                            $genericform_table . '_' . $this->journal_code => array($genericform_element_table . '.emt_gucf_id', $genericform_table . '.gdata_atf_id', 'left'),
                        )
                    );
                    /*join_table' => array(
						$genericform_table.'_'.$this->journal_code => '(emt_gucf_id = gdata_atf_id  AND gdata_artflw_id = '.$stage_id.')'),*/
                    /*$criteria = array(
					//'gdata_artflw_id' => $stage_id,
					'emt_required' => 1,
					'emt_gucf_id IN '=> '(\''. implode('\',\'', $forms).'\')',
					);*/
                    $criteria = 'gdata_artflw_id=' . $stage_id . ' and emt_required=1 and emt_gucf_id IN (' . implode($forms) . ')';
                    $select = 'count(DISTINCT emt_id) as cnt,sum(IF(gdata_atf_id IS NOT NULL,1,0)) as answered';
                    $stage_form_data = Article_flow::get_results_using_joins($tables, $select, $criteria, 'single', NULL, NULL, '', NULL, NULL, TRUE);
                    if (($stage_form_data->answered < $stage_form_data->cnt) &&  $stage_form_data->cnt > 0) {
                        $generic_form_validation = FALSE;
                    }
                }
            }
            $Production_attachment_files = new \App\Models\Production_attachment_files();
            // $file_uploaded = $Production_attachment_files::get_single_record('count(paf_id)  as cnt', 'paf_aflw_id=' . $stage_id);
            $file_uploaded = $Production_attachment_files::get_single_record('count(paf_id)  as cnt', 'paf_aflw_id= ?',binding_arr:[$stage_id]);
            $upload_type = '';
            //if(isset($review_workflow[$stage_type]['upload_type']))
            if (isset($review_data[0]->jwf_production_upload)) {
                //n= not applicable, r = required, o = optional
                $upload_type = $review_data[0]->jwf_production_upload;
            }
            if ($generic_form_validation == FALSE) {
                $return['msg'] =  customTrans('viewarticle.gncform_valid_fail');
            }
            //elseif($file_uploaded->cnt > 0 && $stage_info->cnt > 0)
            elseif ($file_uploaded->cnt > 0 || $upload_type == 'o' || $upload_type == 'n' || ($upload_type == '' && $generic_form_validation == TRUE)) {
                $return['status'] = 'true';
            } elseif ($upload_type == 'r' && $file_uploaded->cnt == 0) {
                $return['msg'] = customTrans('viewarticle.no_upload_msg');
            }
        }
        if ($post == TRUE)
            echo json_encode($return);
        else
            return $return;
    }
    public function anonymize_users($user_id, $user_status = '')
    {
        DB::enableQueryLog();
        $current_user = $this->get_current_user_details();
        $return_data = array();

        if ($user_id != '') {
            $user_criteria = "usr_id = {$user_id}";
            $user_exist = User::get_single_record('*', $user_criteria);
            if ($user_exist) {
                DB::beginTransaction();
                $delete_outputs = array();
                $update_outputs = array();
                /*------------------------Users table start-------------------------*/
                $url_prefix = (isset($_SERVER['HTTPS']) ? 'https://' : 'http://');
                $email_postfix = trim(env('APP_URL'), $url_prefix);
                if (empty($email_postfix)) {
                    $email_postfix = 'ReView.com';
                }
                $user_data = array(
                    'usr_username' => 'RVUSER_' . $user_id,
                    'usr_pwd' => 'xxxxxx',
                    'usr_email' => $user_id . '@' . $email_postfix,
                    'usr_status' => $user_status,
                    'usr_twitter_id' => '',
                    'usr_github_id' => '',
                    'usr_phone_no' => '',
                    'usr_orcid_id' => '',
                    'usr_orcid_token' => ''
                );
                $user_criteria = "usr_id = {$user_id}";
                $user_update = User::update_record($user_data, $user_criteria, $current_user);

                $del_usr_sql = 'DELETE FROM ' . User::$tbk_table . ' where usr_id = '.$user_id;
                $usr_tbk_delete = User::execute_query($del_usr_sql, TRUE);
                $delete_outputs[User::$tbk_table] = $usr_tbk_delete;



                /*------------------------Users table End-------------------------*/

                if ($user_update) {
                    $update_outputs[(new \App\Models\User())->getTable()] = $user_update;

                    /*------------------------User Affliation start-------------------------*/

                    $usr_aff_criteria = "usaff_user_id = {$user_id} AND usaff_prime_affiliation = 'n' ";
                    $aff_delete = User_affiliations::delete_records($usr_aff_criteria, '', $current_user);
                    $criteria_update = array(
                        'usaff_email' => '',
                        'usaff_department' => '',
                        'usaff_ringgold_id' => '',
                        'usaff_ringgold_family' => '',
                        'usaff_phone' => ''
                    );
                    $condition = "usaff_user_id = {$user_id} AND usaff_prime_affiliation = 'y'";
                    $aff_update = User_affiliations::update_record($criteria_update, $condition, $current_user);
                    $del_user_aff_sql = 'delete from ' . User_affiliations::$tbk_table . ' where usaff_user_id = ' . $user_id;
                    $usr_affiliation_tbk_delete = User_affiliations::execute_query($del_user_aff_sql, TRUE);
                    $delete_outputs[User_affiliations::$tbk_table] = $usr_affiliation_tbk_delete;

                    /*------------------------User Affliation End-------------------------*/

                    /*------------------------Author start-------------------------*/

                    $auth_article_present = Authors::get_all_records('*',"auth_usr_id = {$user_id}");

                    if (count($auth_article_present) > 0) {
                        foreach ($auth_article_present as $auth_article) {
                            $auth_aff_present = Authors_affiliation::get_all_records('auaff_id', "auaff_auth_id = {$auth_article->auth_id}");

                            /*--------------------Author affliation start-------------------------*/

                            if (!empty($auth_aff_present)) {
                                $update_outputs[(new \App\Models\Authors_affiliation())->getTable()] = 0;
                                foreach ($auth_aff_present as $auth_aff) {
                                    $update_auth_aff_data = array(
                                        'auaff_email' => '',
                                        'auaff_department' => '',
                                        'auaff_company' => '',
                                        'auaff_address_line1' => '',
                                        'auaff_address_line2' => '',
                                        'auaff_postal_code' => '',
                                        'auaff_website' => '',
                                        'auaff_phone' => '',
                                        'auaff_cnt_id' => '',
                                        'auaff_ringgold_id' => '',
                                        'auaff_ringgold_family' => ''
                                    );

                                    $update_auth_aff = Authors_affiliation::update_record($update_auth_aff_data, "auaff_id = {$auth_aff->auaff_id}", $current_user);
                                    if ($update_auth_aff) {
                                        $update_outputs[(new \App\Models\Authors_affiliation())->getTable()] = ++$update_outputs[(new \App\Models\Authors_affiliation())->getTable()];
                                    }

                                    $del_aff_sql = 'delete from ' . Authors_affiliation::$tbk_table . ' where auaff_id = ' . $auth_aff->auaff_id;

                                    $aff_tbk_credit = Authors_affiliation::execute_query($del_aff_sql, TRUE);
                                    $delete_outputs[Authors_affiliation::$tbk_table] = $aff_tbk_credit;
                                }
                            }
                            /*--------------------Author affliation End-------------------------*/

                            $del_auth_sql = 'delete from ' . Authors::$tbk_table . ' where auth_id = ' . $auth_article->auth_id;

                            $auth_tbk_credit = Authors::execute_query($del_auth_sql, TRUE);
                            $delete_outputs[Authors::$tbk_table] = $auth_tbk_credit;


                            /*--------------------Author credits start-------------------------*/

                            $criteria_au = "acr_auth_id = {$auth_article->auth_id}";
                            $author_credit = Author_credits::delete_records($criteria_au, '', $current_user);
                            $del_sql = 'delete from ' . Author_credits::$tbk_table . ' where acr_auth_id = ' . $auth_article->auth_id;

                            $auth_tbk_credit = Author_credits::execute_query($del_sql, TRUE);
                            $delete_outputs[Author_credits::$tbk_table] = $auth_tbk_credit;

                            /*--------------------Author credits end-------------------------*/
                        }
                    }
                    /*------------------------Author  End-------------------------*/
                }

                /*------------------------38 tables delete start-------------------------*/


                $user_attachments = User_attachment_files::get_all_records("*", "usatmnt_user_id ={$user_id}");

                if (!empty($user_attachments)) {
                    foreach ($user_attachments as $attachment) {
                        $file_path = APP_DOC_PATH . $attachment->usatmnt_file_name;
                        if (file_exists($file_path)) {
                            unlink($file_path);
                        }
                    }
                }

                $delete_entry_table = array(
                    (new \App\Models\Adhoc_user_role())->getTable() => 'aur_usr_id',
                    Adhoc_user_role::$tbk_table => 'aur_usr_id',
                    (new \App\Models\Reviewed_privilaged_users())->getTable() => 'rvp_usr_id',
                    Reviewed_privilaged_users::$tbk_table => 'rvp_usr_id',
                    (new \App\Models\User_attachment_files())->getTable() => 'usatmnt_user_id',
                    User_attachment_files::$tbk_table => 'usatmnt_user_id',
                    (new \App\Models\User_emails())->getTable() => 'uml_user_id',
                    User_emails::$tbk_table => 'uml_user_id',
                    (new \App\Models\User_flags())->getTable() => 'uf_usr_id',
                    User_flags::$tbk_table => 'uf_usr_id',
                    (new \App\Models\User_global_flags())->getTable() => 'ugf_user_id',
                    User_global_flags::$tbk_table => 'ugf_user_id',
                    (new \App\Models\User_to_journals())->getTable() => 'usrj_usr_id',
                    User_to_journals::$tbk_table => 'usrj_usr_id',
                    (new \App\Models\User_journal_classifications())->getTable() => 'jucl_usr_id',
                    User_journal_classifications::$tbk_table => 'jucl_usr_id',
                    (new \App\Models\User_journal_filter_keys())->getTable() => 'ujfk_usr_id',
                    User_journal_filter_keys::$tbk_table => 'ujfk_usr_id',
                    (new \App\Models\User_to_journal_orcid_details())->getTable() => 'ujo_usr_id',
                    User_to_journal_orcid_details::$tbk_table => 'ujo_usr_id',
                    (new \App\Models\User_journal_preference())->getTable() => 'pref_usr_id',
                    User_journal_preference::$tbk_table => 'pref_usr_id',
                    (new \App\Models\User_journal_sort_keys())->getTable() => 'ujsk_usr_id',
                    User_journal_sort_keys::$tbk_table => 'ujsk_usr_id',
                    (new \App\Models\Userkeywords())->getTable() => 'ukwd_usr_id',
                    Userkeywords::$tbk_table => 'ukwd_usr_id',
                    (new \App\Models\User_meta())->getTable() => 'urg_user_id',
                    User_meta::$tbk_table => 'urg_user_id',
                    (new \App\Models\User_note())->getTable() => 'usnote_user_id',
                    User_note::$tbk_table => 'usnote_user_id',
                    (new \App\Models\User_panel_collapsible_view())->getTable() => 'upcv_user_id',
                    User_panel_collapsible_view::$tbk_table => 'upcv_user_id',
                    (new \App\Models\Users_unavailability())->getTable() => 'unavail_user_id',
                    Users_unavailability::$tbk_table => 'unavail_user_id',
                    (new \App\Models\User_articles())->getTable() => 'usra_usr_id',
                    User_articles::$tbk_table => 'usra_usr_id',
                    (new \App\Models\User_feedback())->getTable() => 'fd_posted_by',
                    (new \App\Models\User_home_filter_sort_keys())->getTable() => 'uhfs_usr_id',
                );

                foreach ($delete_entry_table as $table_name => $field_name) {
                    $sql = 'delete from ' . $table_name . ' where ' . $field_name . ' = ' . $user_id;
                    $delete_value = User::execute_query($sql, TRUE);
                    $delete_outputs[$table_name] = $delete_value;
                }
                /*------------------------38 tables delete end-------------------------*/
                DB::commit();

                // if (DB::commit() ==TRUE) {
                    $return_data['status'] = 'success';
                    $return_data['msg'] = 'anonymize_success';
                // } else {
                //     $return_data['status'] = 'failed';
                //     $return_data['msg'] = 'anonymize_trans_err';
                // }

            } else //user not found
            {
                $return_data['status'] = 'failed';
                $return_data['msg'] = 'anonymize_usr_unknown';
            }
        } else //empty user id
        {
            $return_data['status'] = 'failed';
            $return_data['msg'] = 'anonymize_usr_empty';
        }
        // print_r($return_data);
        // print_r(' test conform');
        // exit;
        return $return_data;
    }

    //Feature #1493   JPR-100 - Re-assigning Users on Articles  (send notify email to the new assigned user)
	Public function send_change_assign_notify_email($data)
	{
        $this->current_user = $this->get_current_user_details();
		$sent_bactch_id = '';
        $Article_flow = new \App\Models\Article_flow();
        $Roles = new \App\Models\Roles();
        $Users = new \App\Models\User();
        $Email_templates = new \App\Models\Email_templates();
		if ($data['event_template'] != '')
		{
			$user_id = $data['user_id'];
			$role_id = $data['role'];
			$artp_id = $data['article_type'];
			$art_id = $data['article_id'];
			$stage_id = $data['aflw_id'];
			$jnl_code = $data['jnlcode'];
			$jnl_id = $data['jnlid'];
			$posted_template = $data['event_template'];
            $core_role=(isset($data['core_role']))?$data['core_role']:'';
            $role_name=(isset($data['role_name']))?$data['role_name']:'';
			//send email section
			$email_data = new stdClass;
			$email_data->article_id = $art_id;
			$email_data->user_id = $user_id;
			$email_data->jnl_journal_code = $jnl_code;
			$email_data->artp_id = $artp_id;
			$email_data->jnl_id = $jnl_id;
			$email_data->aflw_id = $stage_id;
			$select = 'jwf_stage_type';
            $where = "aflw_art_id={$email_data->article_id} AND aflw_id={$email_data->aflw_id}";

			$current_status = $Article_flow::get_generic_flow($select, $where);
			$client_code = $this->current_client->clnt_client_code;
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($review_config);

			$email_data->article_id = $art_id;
			$email_data->mail_recipient_ids = $user_id;
			$email_data->email_templates_config = $this->email_templates_config();
			$email_data->join_config = $this->join_config();
			$email_data->join_dependency_config = $this->join_dependency_config();

			$send_mail_to = '';
			$send_mail_to_usr_ids = '';
            //reply_to start
            $current_status = array();
            $article_flow_table = (new \App\Models\Article_flow);
            if((isset($art_id)&&$art_id!=NULL)&&(isset($stage_id)&&$stage_id!=NULL))
            {
            $select = 'jwf_stage_type,jwf_role_id';
            $where ="aflw_art_id={$art_id} AND aflw_id={$stage_id}";
            $current_status = $article_flow_table::get_generic_flow($select, $where);
            }
            $reply_to=$this->get_reply_to_email($jnl_id,$current_status);
			//reply_to end
            if (isset($reply_to) && $reply_to != '')
				$email_data->reply_to = $reply_to;

			$email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;


			if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
				$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

			$assign_user_data = $Users::get_single_record('*,CONCAT_WS(" ",usr_first_name,usr_middle_name,usr_last_name) as assignee_full_name',"usr_id={$user_id}");

			$role_data = $Roles::get_single_record('role_name',"role_id={$role_id}");

			if (!empty($assign_user_data))
			{
				$send_mail_to = $assign_user_data->usr_email;
				$send_mail_to_usr_ids = $user_id;
			}

			$template = $Email_templates::get_single_record('*',"etmp_name='change_assign'");

			$subject = $posted_template['stage_template_sub'];
			$body = $posted_template['stage_template_content'];

			//get cc, bcc, reply_to from preview
			$template->etmp_cc = $template->etmp_bcc = '';
			$template->etmp_cust_cc = $template->etmp_cust_bcc = '';
            $optccvalue = array();
            if (isset($posted_template['stage_cust_cc'])&&!empty($posted_template['stage_cust_cc']) && (in_array('Custom_cc',$posted_template['stage_template_to_cc'])||in_array('Custom',$posted_template['stage_template_to_cc']))) {
                $custm_cc = $posted_template['stage_cust_cc'];
                for ($i = 0; $i < count($custm_cc); $i++) {
                    $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                    array_push($optccvalue, $cust_value);


                }
                $posted_template['stage_cust_cc'] = implode(',', $optccvalue);

            }
            else{
                $posted_template['stage_cust_cc']='';
            }
            $optbccvalue = array();
            if (isset($posted_template['stage_cust_bcc'])&&!empty($posted_template['stage_cust_bcc']) && (in_array('Custom_bcc',$posted_template['stage_template_to_bcc'])||in_array('Custom',$posted_template['stage_template_to_bcc']))) {
                $custm_bcc = $posted_template['stage_cust_bcc'];
                for ($i = 0; $i < count($custm_bcc); $i++) {
                    $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                    $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                    $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                    array_push($optbccvalue, $cust_bcc_value);

                }
                $posted_template['stage_cust_bcc'] = implode(',', $optbccvalue);
            }
            else{
                $posted_template['stage_cust_bcc']='';
            }
            if(!empty($posted_template['stage_template_to_cc']))
			{
				$template->etmp_cc =json_encode($posted_template['stage_template_to_cc']);
				if(in_array('Custom_cc', $posted_template['stage_template_to_cc'])||in_array('Custom', $posted_template['stage_template_to_cc']))
					$template->etmp_cust_cc = trim($posted_template['stage_cust_cc']);
			}
			if(!empty($posted_template['stage_template_to_bcc']))
			{
				$template->etmp_bcc =json_encode($posted_template['stage_template_to_bcc']);
				if(in_array('Custom_bcc', $posted_template['stage_template_to_bcc'])||in_array('Custom', $posted_template['stage_template_to_bcc']))
					$template->etmp_cust_bcc = trim($posted_template['stage_cust_bcc']);
			}
			$email_data->reply_to = trim($posted_template['stage_template_to_mail']);

			$email_data->ASSIGN_USER_FULL_NAME = $assign_user_data->assignee_full_name;
			$email_data->ASSIGN_USER_ROLE = $role_data->role_name;
                        if($data['jwf_stage_type'] == 'review')
                        {
                        $email_data->esl_etmp_action = 'assignment_change';
                        }
                        $email_data->assignment_change = TRUE;

			//generate_email_data_from_keys
			$assign_user = array(
				'user_id' => $user_id
			);
            $email_data->status_link_blind_event = TRUE;
            $replace_button = array('<button contenteditable="false">', '</button>');
            $replaceval = str_replace($replace_button, '##', $body);
            $body = $replaceval;
			$email_data->subject = strip_tags($this->generate_email_data_from_keys($email_data, $subject, $this->current_user));
			$user_titles =$this->UserConfigdata('titles')['titles'];
			$email_data->body = $this->generate_email_data_from_keys($email_data, $body, $this->current_user, $user_titles, TRUE);

			$email_data->email_templates_config = $this->email_templates_config();
            $send_mail_to = trim($send_mail_to);
            $send_mail_to=str_replace(' ', '', $send_mail_to);
            $send_mail_to_usr_ids = trim($send_mail_to_usr_ids);
            $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);

			if ($send_mail_to != '' )
			{
				$email_data->user_email = $send_mail_to;
				$email_data->mail_recipient_ids = $send_mail_to_usr_ids;
				$core_role=(isset($core_role))?$core_role:'';
				$email_data->core_role = $core_role;
				$core_role_name=(isset($role_name))?$role_name:'';
				$email_data->core_role_name = $core_role_name;
				$sent_bactch_id = $this->send_email_notification($template, $email_data,$this->current_user, 'etmp_', TRUE);
			}
		}

		return $sent_bactch_id;
	}


    public function checkValidRecord($art_id,$aflw_id,$jnlcode,$jnlid = NULL)
    {
            if(is_numeric($aflw_id) == false || is_numeric($art_id)== false || $jnlcode=='')
            {
                return false;
            }
            else{
            $articleflowtable = new \App\Models\Article_flow();
            $articletable = new \App\Models\Articles();
            $journalstable = new \App\Models\Journals();
            $article=$articletable::get_single_record('art_id as cnt','art_id=?',binding_arr:[$art_id]);                    // TASK #7017
            $article_flow=$articleflowtable::get_single_record('aflw_id as cnt','aflw_id=?',binding_arr:[$aflw_id]);        // TASK #7017
            $journals=$journalstable::get_single_record('jnl_id as cnt'," binary jnl_journal_code=?",binding_arr:[$jnlcode]);       // TASK #7017
            if($jnlid!=""){
                $journalVal = $journalstable::get_single_record('jnl_id as cnt',"jnl_id=?",binding_arr:[$jnlid]);
                if(!$journalVal){
                    return false;
                }
            }
            if((isset($article->cnt) && $article->cnt>0) && (isset($article_flow->cnt) && $article_flow->cnt>0) && (isset($journals->cnt) && $journals->cnt>0))
            {
                return true;
            }
            else{
                return false;
            }
        }
}

    public function getReadOnlyView($parentSet)
    {
        $readOnlySet = '';
        $returnSet = array();
        foreach ($parentSet as $parent) {
            $parentTitle = $parent['title'];
            if (count($parent['children']) > 0) {
                $readOnlySet = $readOnlySet . '#$#' . $this->getChildSet($parent['children'], $parentTitle);
            } else {
                $readOnlySet = $readOnlySet . '#$#' . $parentTitle;
            }
        }
        $getReadOnlyViewArr = array_filter(explode('#$#', $readOnlySet));
        if (count($getReadOnlyViewArr) > 0) {
            foreach ($getReadOnlyViewArr as $row) {
                $returnSet[] = ((explode('>>', $row)));
            }
        }
        return ($returnSet);
    }
    public function getChildSet($childSet, $parentTitle)
    {
        $readOnlySet = '';
        $resultSet = '';
        $breaker = ">>";
        foreach ($childSet as $child) {
            if (count($child['children']) > 0) {
                $resultSet = $this->getChildSet($child['children'], $parentTitle . $breaker . $child['title']);
            } else {
                $resultSet = $parentTitle . $breaker . $child['title'];
            }
            $readOnlySet = $readOnlySet . '#$#' . $resultSet;
        }
        return ($readOnlySet);
    }

public function send_unassign_email($email_template, $post_data, $article_details, $usr_details,$jnl_id='',$jnl_code='')
{
    $reviewer_id = $usr_details->usr_id;
    $Article_type_advance_options = new \App\Models\Article_type_advance_options;
    $current_user = $this->get_current_user_details();
    $email_data = new stdClass;
    $email_data->article_id = $post_data['art_id'];
    $email_data->user_id = $reviewer_id;
    $email_data->jnl_journal_code = $jnl_code;
    $email_data->artp_id = $article_details->art_artp_id;
    $email_data->jnl_id = $jnl_id;
    $reply_to = '';
    if (isset($post_data['esl_aflw_id']))
      {
          $email_data->aflw_id = $post_data['esl_aflw_id'];
      }

    $email_data->reply_to = trim($post_data['unassign_email_reply_to']);
    $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
    $email_template->stage_etmp_cc = $email_template->stage_etmp_bcc = '';
    $email_template->stage_etmp_cust_cc = $email_template->stage_etmp_cust_bcc = '';
    if (!empty($post_data['unassign_tmpl_to_cc']))
    {
        $email_template->stage_etmp_cc = json_encode($post_data['unassign_tmpl_to_cc']);
        if (in_array('Custom', $post_data['unassign_tmpl_to_cc']) || in_array('Custom_cc', $post_data['unassign_tmpl_to_cc']))
            $email_template->stage_etmp_cust_cc = trim($post_data['unassign_tmpl_to_cust_cc']);
    }
    if (!empty($post_data['unassign_tmpl_to_bcc']))
    {
        $email_template->stage_etmp_bcc = json_encode($post_data['unassign_tmpl_to_bcc']);
        if (in_array('Custom', $post_data['unassign_tmpl_to_bcc']) || in_array('Custom_bcc', $post_data['unassign_tmpl_to_bcc']))
            $email_template->stage_etmp_cust_bcc = trim($post_data['unassign_tmpl_to_cust_bcc']);
    }
    $send_mail_to = $usr_details->usr_email;
    $send_mail_to_usr_ids = $reviewer_id;

    if ($email_template->stage_etmp_to != 'User' && $email_template->stage_etmp_to != 'Custom')
    {
        $cfty_retire_role = FALSE;
        if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
        {
            $cfty_retire_role = TRUE;
        }
        $send_mail_to_detail = $this->send_email_to($email_template->stage_etmp_to, $jnl_code, $article_details->art_artp_id, $post_data['art_id'],$cfty_retire_role);
        $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
        $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
        $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
        $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
        $send_mail_to = $send_mail_to_detail['email_ids'];
        $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
    }

    $subject = $post_data['postdata']['stage_template_sub'];
    $content = $post_data['postdata']['stage_template_content'];
    $email_data->subject = $subject;
    $email_data->body = $content;

        $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$article_details->art_artp_id}");
        if(!empty($artp_settings))
        {
            $email_template->review_method = $email_template->assignments='';
            $core_role ='';
           /* if(isset($this->jnl_data->jnl_journal_code) && isset($this->current_user['jnl_user_role']))
            {
                $core_role = $this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role'];
            }
            else*/
            if(isset($article_details->jwf_role_id))
            {
                $roles = Roles::get_single_record('role_assigned_role',"role_id={$article_details->jwf_role_id}");
                $core_role = $roles->role_assigned_role;
            }
            if($core_role == 'reviewer' && ($email_template->stage_etmp_to == 'submit_author' || $email_template->stage_etmp_to == 'Author' || $email_template->stage_etmp_to == 'article_authors' || $email_template->stage_etmp_to == 'Authors'))
            {
                $email_template->review_method = $artp_settings->atotp_review_method;
            }
        }
    if ($send_mail_to != '' || $email_template->stage_etmp_to == 'Custom')
    {
        $email_data->user_email = $send_mail_to;
        $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
        $email_data->email_templates_config = $this->email_templates_config();
        if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
            $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
        // $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
       $core_role='';
        $email_data->core_role = $core_role;
        // $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
        $core_role_name='';
        $email_data->core_role_name = $core_role_name;
        $this->send_email_notification($email_template, $email_data, $current_user, 'stage_etmp_');
    }
}
public function send_decline_notification_email( $article_details,$current_user,$cron_flag = FALSE)
{
    $Email_templates = new \App\Models\Email_templates();

    $email_template = $Email_templates::get_single_record('*',"etmp_name='notification_on_decline' AND etmp_notification='User'");

    if(!empty($email_template))
    {
        $email_data = new stdClass;
        $article_id = $article_details->art_id;
        $email_data->article_id = $article_id;

        $email_data->jnl_journal_code = $article_details->jnl_journal_code;
        $email_data->artp_id = $article_details->art_artp_id;
        $email_data->jnl_id = $article_details->jnl_id;
        $action_name = '';
        if($cron_flag== TRUE)
        {
            $action_name = 'cron_job';
        }
        $email_data->name = $action_name;
        if (isset($article_details->aflw_id))
          {  $email_data->aflw_id = $article_details->aflw_id;}
        $reply_to=$this->get_reply_to_email($article_details->jnl_id);

        if (isset($reply_to) && $reply_to != '')
        {
            $email_data->reply_to = $reply_to;
        }
        $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;


        $invite_roles = ($article_details->jwf_who_can_invite != NULL)  ? json_decode($article_details->jwf_who_can_invite) : array();
        $assign_roles = ($article_details->jwf_parent_user_roles != NULL)  ? json_decode($article_details->jwf_parent_user_roles) : array();
        $invite_assign_role = array_unique(array_merge($invite_roles,$assign_roles));
        $avoid_roles = ($article_details->jwf_avoid_email_notifications_to_roles != NULL)  ? json_decode($article_details->jwf_avoid_email_notifications_to_roles) : array();
        if (!empty($avoid_roles)) {
            $invite_assign_role = array_diff($invite_assign_role, $avoid_roles);
        }
        $user_ids = array();
        if(!empty($invite_assign_role))
        {
            foreach($invite_assign_role as $v)
            {
                $users_in_article = User_articles::get_all_records('usra_usr_id',"usra_role_id={$v} AND usra_art_id={$article_id}");
                $userids_for_article = array();
                if(empty($users_in_article) || count($users_in_article) == 0)
                {
                    $users_in_journal = User_to_journals::get_all_records('usrj_usr_id',"usrj_role_id={$v} AND usrj_artp_id={$article_details->art_artp_id} AND usrj_role_retired = 'n'");
                    $userids_for_article =  array_column(json_decode(json_encode($users_in_journal), TRUE), 'usrj_usr_id');
                }
                else
                {
                    $userids_for_article =  array_column(json_decode(json_encode($users_in_article), TRUE), 'usra_usr_id');
                }
                $user_ids = array_unique(array_merge($user_ids,$userids_for_article));

            }
        }

        $send_mail_to = $send_mail_to_usr_ids = '';
        if(!empty($user_ids))
        {
            $user_ids;
            $user_details = User::get_all_records('usr_id,usr_email','usr_id IN ('.join(',',$user_ids).')');
            $send_mail_to = join(', ',array_column(json_decode(json_encode($user_details), TRUE), 'usr_email'));
            $send_mail_to_usr_ids = join(', ',array_column(json_decode(json_encode($user_details), TRUE), 'usr_id'));
        }
        $email_data->subject = $email_template->etmp_subject;
        $email_data->body =  $email_template->etmp_email_template;


        if ($send_mail_to != '' )
        {
            $redirect_base_url = URL::to('/');
            if (isset($article_details->jnl_standalone_group) && $article_details->jnl_standalone_group != NULL)
            {
                $redirect_base_url = $this->build_url_standalone($article_details->jnl_standalone_group);
            }
            $aflw_id =  ( $article_details->aflw_parent_flow_id != NULL) ? $article_details->aflw_parent_flow_id : $article_details->aflw_id ;
            $article_url =  $redirect_base_url.'/'. $this->current_client->platform_type.'/'. $article_details->jnl_journal_code . '/view-article?' . encrypt_link('article_id=' . $article_id . '&status_id=' .$aflw_id);
            $send_mail_to = trim($send_mail_to);
            $send_mail_to=str_replace(' ', '', $send_mail_to);
            $send_mail_to_usr_ids = trim($send_mail_to_usr_ids);
            $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);

            $email_data->all_user_roles = User_to_journals::get_user_role_classification($article_details->art_id, 'a');

            $email_data->ARTICLE_STATUS_LINK = $article_url;
            $email_data->user_email = $send_mail_to;
            $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
            $email_data->email_templates_config = $this->email_templates_config();
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();
            $email_data->user_role_tags = $this->user_role_tags();
            if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
            if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
            if (isset($email_template->etmp_email_template) && strpos($email_template->etmp_email_template,"OPENING_PARAGRAPH") > 0)
            $email_template->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->etmp_email_template);
            /*if(!empty($this->current_user['jnl_user_role']))
            {
            $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
            $email_data->core_role = $core_role;
            $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
            $email_data->core_role_name = $core_role_name;
            }*/
            $data = array(
                'record' => $email_template,
                'email_data' => $email_data,
                'user_data' =>$current_user,
                'column_prefix' =>'etmp_',
            );
            $this->notify_mail($data);
        }
    }
}
public function get_all_issue_mng_data_by_article_id($art_id, $jnl_id, $role_id, $artp_id = NULL)
{
    $rtn_data       = array();
    $open_issues    = NULL;
    $allow_issue_assignment = FALSE;
    $issue_status_edit_mode = FALSE;
    $assigned_issue_data = array(
        'title' => 'No issue assignment',
        'id'    => ''
        );
    $allow_issue_assignment = TRUE;
    $Issues = new \App\Models\Issues;
    $Volumes = new \App\Models\Volumes;
    $Issue_management = new \App\Models\Issue_management;
    $Articles = new \App\Models\Articles;
    $Journal_settings = new \App\Models\Journal_settings;
    $current_user = $this->get_current_user_details();
    //who can add article to issue permisstion check
    //$current_user_role      = $this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code];
    $active_role_id         = $role_id;
    $user_permission_roles  = $Journal_settings::get_single_record('jset_add_article_to_issue', 'jset_jnl_id='.$jnl_id);
        $who_can_add_article_to_issue = array();
        if($user_permission_roles->jset_add_article_to_issue != NULL)
            $who_can_add_article_to_issue= json_decode($user_permission_roles->jset_add_article_to_issue);
        if(in_array($active_role_id, $who_can_add_article_to_issue))
        {
            if(!empty($art_id))
            {
                $article_data = $Articles::get_single_record('art_status', 'art_id='.$art_id);
                if($article_data->art_status!='c')
                    $issue_status_edit_mode = TRUE;
            }
            //$assigned_issue_data['title'] = '<a id = "assign_issue_add">' . lang('issue_select') . '</a>';
        }
        $Issue_management_table = (new \App\Models\Issue_management)->getTable();
        $Issues_table = (new \App\Models\Issues)->getTable();
        $Volumes_table = (new \App\Models\Volumes)->getTable();
        $Articles_table = (new \App\Models\Articles)->getTable();
        $tables = array(
            'main_table' => $Issue_management_table,
            'join_table' => array(
                                $Issues_table => array($Issues_table . '.iss_id', $Issue_management_table . '.ism_iss_id',"inner"),
                                $Volumes_table => array($Volumes_table . '.vol_id', $Issues_table . '.iss_vol_id', "left"),
                                $Articles_table => array($Articles_table . '.art_id', $Issue_management_table . '.ism_art_id', "left")
                            )
        );
        //$date_format = Issues::$date_format_map[$this->jnl_data->jset_date_format];
        $select = 'vol_id,vol_title,iss_id,iss_title,art_delete_status,iss_hard_end_date';

        $condition='ism_art_id='.$art_id .' and (iss_start_date <= CURDATE() or iss_start_date is NULL) ';
       // $result_set = $Issue_management::get_results_using_joins($join_tables,'single',$select,$condi);
        $result_set = Issue_management::get_results_using_joins($tables, $select, $condition);

        if($result_set->isNotEmpty())
        {
            //commenting the code after getting confirmation from gijo
            /*if($result_set->art_delete_status != 'h')
            {
            $issue_status_edit_mode = TRUE;
            }*/
            $assigned_issue_data['title'] = $result_set[0]->iss_title . ' (' . $result_set[0]->vol_title . ')';
            $assigned_issue_data['id']    = $result_set[0]->iss_id;
            $assigned_issue_data['hardend_date']    = $result_set[0]->iss_hard_end_date;
        }
        //list of all open issues
        $jn_tables = array(
            'main_table' => $Issues_table,
            'join_table' => array(
                                $Volumes_table => array($Volumes_table . '.vol_id', $Issues_table . '.iss_vol_id', "left"),
                            )
        );
        $sel = "vol_id,vol_title,iss_id,concat(iss_title,' (',vol_title,')') as iss_title,iss_hard_end_date,iss_art_type";
        if($artp_id != NULL)
        {
            $con = '(iss_art_type IS NOT NULL AND FIND_IN_SET('.$artp_id.',iss_art_type) > 0 OR iss_art_type IS NULL OR iss_art_type ="[]") and iss_status!=\'c\' and vol_jnl_id='.$jnl_id.' and (iss_start_date <= CURDATE() or iss_start_date is NULL) and (iss_hard_end_date >= CURDATE() or iss_hard_end_date is NULL)';
        }
        else
        {
            $con = 'iss_status!=\'c\' and vol_jnl_id='.$jnl_id.' and (iss_start_date <= CURDATE() or iss_start_date is NULL) and (iss_hard_end_date >= CURDATE() or iss_hard_end_date is NULL)';
        }
        $open_issues = $Issue_management::get_results_using_joins($jn_tables, $sel, $con);
        $issue_found = FALSE;
        foreach($open_issues as $data)
        {
            if($data->iss_id == $assigned_issue_data['id'])
            {
                $issue_found = TRUE;
            }
        }
        if($issue_found == FALSE)
        {
            //issue close akumbol article details il basic details inullil issue inta title kanikilla
            // isue listing il close aya issues kanilla so not found, ennal corresponding article issue add cheythit und so name list akkan
            // code ezhuthi
            $assigned_issue_data = array(
                'title' => ($result_set->isNotEmpty())?$assigned_issue_data['title']:'No issue assignment',
                'id'    => ''
            );
        }
        //SELECT vol_id, vol_title, iss_id, CONCAT(iss_title, ' (', vol_title, ')') AS iss_title, iss_hard_end_date, iss_art_type FROM rvw_issues LEFT JOIN rvw_issue_volumes ON rvw_issue_volumes.vol_id = rvw_issues.iss_vol_id WHERE IF(iss_art_type IS NOT NULL AND FIND_IN_SET('17',iss_art_type) > 0 , true, false) OR IF(iss_art_type IS NULL, true, false) AND iss_status != 'c' AND vol_jnl_id = 5 AND (iss_start_date <= CURDATE() OR iss_start_date IS NULL) AND (iss_hard_end_date >= CURDATE() OR iss_hard_end_date IS NULL) ORDER BY iss_art_type ASC;
     $rtn_data = array(
        'allow_issue_assignment' => $allow_issue_assignment,
        'issue_status_edit_mode' => $issue_status_edit_mode,
        'assigned_issue_data'    => $assigned_issue_data,
        'open_issues'            => $open_issues
    );
    return $rtn_data;
}
public function get_article_display_name($article_id, $journal_code, $flag = TRUE, $special_issue = FALSE, $is_invited_art = FALSE, $user_artp_roles = NULL, $hold_status = FALSE, $artp_id = NULL)
	{
		//If flag is true return flags also
		$article_name = '';
		$flags = '';
		$special_issue_tag = '';
		$invited_art_icon = '';
		$permitted_roles = array();
		$current_userroles = array();
		$current_user = $this->get_current_user_details();
        $Articles_table = (new \App\Models\Articles)->getTable();
        $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
        $Article_flow_table = (new \App\Models\Article_flow)->getTable();
        $Copyright_table = (new \App\Models\Copyright)->getTable();
        $Copyright_master_table = (new \App\Models\Copyright_master)->getTable();

		$article_data = Articles::get_single_record('art_resubmission_after_reject,art_title,art_biorxiv,art_transfer_article,art_prev_article_id,art_artp_id', 'art_id='.$article_id);
		if($artp_id == NULL)
			$artp_id = $article_data->art_artp_id;
		$art_title = str_replace(array(
			'<p>',
			'</p>'), '', $article_data->art_title);

		/* Commented the below line for displaying article title for article stub*/
//		if (!(isset($is_invited_art) && ($is_invited_art == 'flag_only')))
			$article_name = $art_title;
//		else
//			$article_name = '';
        $tables = array(
            'main_table' => $Generic_flows_table,
            'join_table' => array(
                $Article_flow_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id',"inner"),
                $Copyright_table => array($Copyright_table . '.crt_art_id', $Article_flow_table . '.aflw_art_id', "inner"),
                $Copyright_master_table => array($Copyright_master_table . '.crtm_id', $Copyright_table . '.crt_crtm_id', "inner")
                            )
        );


		$select = 'aflw_art_id, aflw_status, jwf_stage_type, crtm_payment';
		$where = 'jwf_stage_type IN ("payment", "production") AND crtm_payment = "o" AND aflw_art_id=' .$article_id;
		$article_copy_open_status = Generic_flows::get_results_using_joins($tables, $select, $where);
		if ($this->current_client->functionality->cfty_biorxiv == 'y' && $article_data->art_biorxiv == 'y')
		{
			$article_name = '<span class="biorxv" title="Submission from bioRxiv">bR</span> ' . $article_name;
		}
		if (($this->current_client->functionality->cfty_biorxiv_j2b == 'y' || $this->current_client->functionality->cfty_j2b_along_with_submission == 'y') && $article_data->art_biorxiv == 'b')
		{
			$article_name = '<span class="biorxivj2b biorxivj-bg-colr" title="Submitted to bioRxiv">bRx</span> ' . $article_name;
		}
		if ($flag == TRUE)
		{
			$user_roles = $this->validate_user_journal($journal_code, $current_user['user_id'], NULL, $user_artp_roles);
			$current_userroles = $user_roles['role_id'];
            $Article_flag_table = (new \App\Models\Article_flag)->getTable();
            $Flag_table = (new \App\Models\Flags)->getTable();
            $Client_functionality_table = (new \App\Models\Client_functionalities)->getTable();
            $Authors_table = (new \App\Models\Authors)->getTable();
            $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
            $Article_flow_table = (new \App\Models\Article_flow)->getTable();
			//#604 Replace fetch_role_flags_of_user() with get_article_flags() for fetching article flags.
			//$flags=$this->fetch_role_flags_of_user($journal_id, $article_id,$current_userroles);
            $flags = $this->get_article_flags($article_id,$current_userroles,$journal_code);
		}
		$client_code = $this->current_client->clnt_client_code;
		$special_issue_col_header = 'Special issue';
		// if(file_exists(APPPATH . 'config/clients/' . $client_code . '/issue_management_config.php'))
		// {
            $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
            $issue_config_data = Config::get($issue_management_config);
            $special_issue_types = $issue_config_data['special_issue_type'];

		// }
		if ($special_issue == TRUE)
		{
			$special_issue_tag = '<span class="s-issue bg-purple" title="'.$special_issue_col_header.'">S</span>&nbsp;';
		}
		if ($is_invited_art == TRUE)
		{
			$invited_art_icon = '<span class="glyphicon glyphicon-bookmark invite-icon" title = "Invited article"></span>&nbsp;';
		}
		$transfered_tag = '';
		$OA_badge = '';
		if ($article_data->art_transfer_article == 'y')
		{
			$transfered_tag = '<span class="s-issue bg-purple" title="Transferred article">T</span>&nbsp; ';
		}
		if(count($article_copy_open_status) > 0  )
        {
            if(($article_copy_open_status[0]->jwf_stage_type == 'production') || ($article_copy_open_status[0]->jwf_stage_type == 'payment' && $article_copy_open_status[0]->aflw_status != 'c'))
            {
                $OA_badge = '<span class="oa-pending bg-yellow" title="OA payment pending">OA</span> ';
            }
            else
            {
                $OA_badge = '<span class="oa-complete bg-green" title="OA payment completed">OA&#x2713</span> ';
            }
        }
		$revison_tag='';
		if($article_data->art_prev_article_id!='' && $article_data->art_transfer_article == 'n')
		{
			//Customisation #2537 JPR-411
		 $badge_text = $article_data->art_resubmission_after_reject== "y" ? "RS" : "R";
		 $badge_title = $article_data->art_resubmission_after_reject== "y" ? "Resubmitted version" : "Revised version";
        //  r-revised
		$revison_tag='<span class="badge bg-yellow" title="'.$badge_title.'">'.$badge_text.'</span>&nbsp; ';

		}

		//check logged user is an author starts
		$is_author = FALSE;
		$chk_author = Authors::get_single_record('auth_art_id', 'auth_art_id='.$article_id.' AND auth_usr_id='.$current_user['user_id']);
		if(!empty($chk_author))
		{
			$is_author= TRUE;
		}
		//check logged user is an author ends
		//Task #548 Hold icon-Reviewer
		if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y')
		{
			$is_reviewers = TRUE;
			$privleged_reviewer = $this->is_reviewer_privileged_user($article_id,NULL,FALSE,$artp_id);
			if($privleged_reviewer == TRUE)
				$is_reviewers = FALSE;
		}
		else
		{
			$condition =' aflw_art_id='.$article_id.' and aflw_usr_id='.$current_user['user_id'].' and aflw_status IN (\'u\',\'i\',\'a\') and jwf_stage_type=\'review\'';
			$sql_str = ' SELECT COUNT(DISTINCT aflw_id) AS cnt FROM '.$Article_flow_table.','.$Generic_flows_table.' WHERE '.$condition;
			$reviewer_record = Article_flow::get_records_by_raw_query($sql_str,TRUE);
			if($reviewer_record->cnt > 0)
				$is_reviewers = TRUE;
			else
				$is_reviewers = FALSE;
		}
		//check logged user is an reviewer starts
		$hold_baldge_reason = '';

		//check logged user is an reviewer starts
		if ($hold_status == TRUE && $artp_id != NULL && $is_author == FALSE  && $is_reviewers == FALSE)
		{
			$hold_baldge_reason = $this->set_hold_article_baldge($article_id, $artp_id, [], [], $journal_code);
		}
		$art_disp_name = $OA_badge . $flags .$hold_baldge_reason. $invited_art_icon . $special_issue_tag .$transfered_tag. $revison_tag  .'&nbsp;'. $article_name;
		return $art_disp_name;
	}

    /* Customisation #2537
	 * to show all article flags in the article heading (left side of article title)
         * #604 Replace fetch_role_flags_of_user() with get_article_flags() for fetching article flags.
         * pass a third parameter "$title_only" (T/F) for fetching only the flag titles comma seperated
	 */
	public function get_article_flags($art_id,$current_userroles,$journal_code='',$title_only=FALSE,$return_array=false) {
        $current_user = $this->get_current_user_details();
        $Article = (new \App\Models\Articles)->getTable();
        $Article_flag_table = (new \App\Models\Article_flag)->getTable();
		$newflags	=	'';
        $newflags_arr	=	array();
		$flag_data = Article_flag::get_article_flags('*', 'aflg_art_id='.$art_id);
                $reviewer_role_id = 0;
                $check_revwr = FALSE;
                $current_user = $this->get_current_user_details();
				$is_non_author = TRUE;

		if (count($flag_data) > 0)
		{
			$roles =Roles::get_all_records('role_id,role_name,role_assigned_role');
			$roles_array =json_decode(json_encode($roles), true);
			$reviewer_role_id =''; $author_role_id ='';
			$array_column=array_column($roles_array, 'role_assigned_role');
			if (in_array('reviewer',$array_column))
			{
				$key = array_search('reviewer',$array_column);
				$reviewer_role_id = $roles_array[$key]['role_id'] ;
                        if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                        {
                           // $reviewer_role_id = $this->Roles->get_single_record('role_id', array('role_assigned_role' => 'reviewer'));
                            $check_revwr = $this->check_user_as_reviewer_version($art_id,$current_user['user_id'] );
                        }
            }
			if (in_array('author', $array_column))
			{
				$article_details = Articles::get_single_record('art_artp_id','art_id='.$art_id);
				$articletype_id  = $article_details->art_artp_id;
				$key = array_search('author', $array_column);
				$author_role_id = $roles_array[$key]['role_id'];
				$privillaged_user = $this->has_journal_privilege($journal_code, $current_user['user_id'], $articletype_id);
				$is_non_author = $this->is_non_author_privileged_user($art_id,$privillaged_user);
				//$is_non_author= true, when nonauthor and $is_non_author= false when author
			 }
			$flag_icon_selector=$this->current_client->functionality->cfty_flag_icon_selector;
			$newflags .= ' ';
            $i=0;
			foreach ($flag_data as $flag_value)
			{
				$permitted_roles=json_decode($flag_value->flag_role);
				if ((count(array_intersect($permitted_roles, $current_userroles)) > 0) && ((!in_array($reviewer_role_id,$permitted_roles) && $check_revwr == FALSE) || (in_array($reviewer_role_id,$permitted_roles))) && ((!in_array($author_role_id,$permitted_roles) && $is_non_author == TRUE) || (in_array($author_role_id,$permitted_roles))))
				{
					if ($flag_value->flag_icon != null && $flag_icon_selector == 'y')
						$icon = $flag_value->flag_icon;
					else
						$icon = 'tag';

                    $new_fav_icon   =   $this->fav_icon_replace($icon);
                                        if($title_only == TRUE)
                                            $newflags .= $flag_value->flag_name . ', ';
                                        elseif($return_array == TRUE){
                                            $newflags_arr[$i]['flag_id'] = $flag_value->flag_id;
                                            $newflags_arr[$i]['flag_name'] = $flag_value->flag_name;
                                            $newflags_arr[$i]['flag_color'] = $flag_value->flag_color;
                                            $newflags_arr[$i]['flag_icon'] = $icon;
                                            $i++;
                                        }
                                        else
                                            $newflags .= '<span class="'.$flag_value->flag_prefix.' fa-' . $new_fav_icon . '" style="color:' . $flag_value->flag_color . '" title="' . $flag_value->flag_name . '">&thinsp;</span>';
				}
			}
		}
        if($title_only == TRUE) {
            $newflags = rtrim($newflags, ', ');
        }
        if($return_array == TRUE){
            return $newflags_arr;
        }
		return $newflags;
	}

    // check user as reviewer in any version of article
	public function check_user_as_reviewer_version($article_id, $user_id)
	{
        $Article_versions_reviewers_table = (new \App\Models\Article_versions_reviewers)->getTable();
		$qry = 'SELECT count(artvr_id) as count FROM '.$Article_versions_reviewers_table.' WHERE `artvr_user_id` = '.$user_id.' AND ((FIND_IN_SET('.$article_id.', artvr_previous_art_ids) > 0 ) OR artvr_article_id='.$article_id. ')';
		$reviewer_exist = Article_versions_reviewers::get_records_by_raw_query($qry);
		$is_reviewer_in_version = (isset($reviewer_exist[0]->count) && $reviewer_exist[0]->count > 0) ? TRUE : FALSE;
      	return $is_reviewer_in_version;
	}
    // set hold article baldge (H)
	public function set_hold_article_baldge($article_id,$artp_id,$is_author = array(),$is_reviewer= array(), $journal_code = NULL)
	{
            $current_user = $this->get_current_user_details();
            // r-revised
			$baldge_text = '<span class="badge bg-purple" title="Article on hold">H</span>&nbsp;';
			$article_privilage = $this->set_user_privilage($article_id,$artp_id,$is_author,$is_reviewer,$journal_code);
			if($article_privilage['privilaged'] == TRUE)
			{
				/* Roles assigned to current user in the article type */
				$all_user_roles = $this->validate_user_journal($journal_code, $current_user['user_id'], $artp_id);
				$all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
				/* Roles assigned to this article */
				$user_roles = $this->get_article_user_roles($all_user_roles, $article_id, $all_roles);

				if(in_array('journal_admin',$user_roles['assigned_roles']) || in_array('staff',$user_roles['assigned_roles']))
				{
                    // r-revised
					$baldge_text = '<a class = "hold-article-popover hold-content" id = "hold-id_'.$article_id.'" data-toggle = "popover" data-placement = "top" ><span class="badge bg-purple">H</span></a>&nbsp;';
			}

			}

			return $baldge_text;
	}
    public function set_user_privilage($article_id,$artp_id,$is_author=array(),$is_reviewer=array(),$journal_code=NULL)
		{
            $current_user = $this->get_current_user_details();
            $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
            $Article_flow_table = (new \App\Models\Article_flow)->getTable();
			//need to check privilaged role as reviewer
			//enable information for staff and journal admin
			$article_data = Article_types::get_single_record('artp_id,artp_fwm_id','artp_id='.$artp_id);
			$privilaged_user = TRUE;

			if(empty($is_author))
			{
			/** Identify article author/reviewer/privileged user * */
			$chk_author = Authors::get_single_record('count(*) as count', 'auth_usr_id='.$current_user['user_id'],'auth_art_id='.$article_id);
			$is_author = (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;
			}
			/*		 * * Bug #2275 - IET Feedback changes - A staff member who is also an author cannot interact with their paper in the system, but they can just proxy as another staff member and make changes to it at various stages this way.  ** */

			if (isset($current_user['proxy_user_id']) && $current_user['proxy_user_id'] != 0 && $is_author == FALSE)
			{
				$chk_author_proxy = Authors::get_single_record('count(*) as count','auth_usr_id='.$current_user['proxy_user_id'],'auth_art_id='.$article_id);
				if ((isset($chk_author_proxy->count) && $chk_author_proxy->count > 0))
				{
					$is_author = TRUE;
				}
			}



			if(empty($is_reviewer))
			{
				$is_reviewer = FALSE;
				if ($is_author == FALSE)
				{
                    $tables = array(
                        'main_table' => $Article_flow_table,
                        'join_table' => array(
                            $Generic_flows_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id'),
                        )
                    );


                    $select = 'count(aflw_id) as cnt';
                    $where = 'aflw_art_id=' .$article_id.' AND jwf_stage_type = "review" AND aflw_usr_id='.$current_user['user_id'];
                    $reviwer_role_count = Article_flow::get_results_using_joins($tables, $select, $where, 'single');


					$is_reviewer = (isset($reviwer_role_count->cnt) && $reviwer_role_count->cnt > 0) ? TRUE : FALSE;
					$privilaged_user = $this->has_journal_privilege($journal_code, $current_user['user_id'], $article_data->artp_id);
					// here code code is null so in my task outside privilages not showing
				}


				if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y' && $privilaged_user == TRUE)
				{
					$review_privilaged = $this->is_reviewer_privileged_user($article_id, $article_data->artp_fwm_id);

				}
			}
			if($is_author == TRUE || $is_reviewer == TRUE)
				$privilaged_user = FALSE;

			$user_privilages = array(
			'privilaged' => $privilaged_user,
			'author' => $is_author,
			'reviewer' => $is_reviewer);
			//print_r($user_privilages); die;
			return $user_privilages;
		}
    public function get_article_saved_email_template_details(array|int|string $article_id,$stage_id)
    {

        if($article_id != null && $stage_id != null){
            if(!is_array($stage_id)){
                $stage_id = " ($stage_id) ";
            }else{
                $stage_id = " ('".implode("','",$stage_id) . "') ";
            }
        $Article_notification_emails = new \App\Models\Article_notification_emails;

        $where =  'ane_art_id = ' . $article_id.' AND ane_next_jwf_id IN ' .$stage_id;
        $stage_save_emails = $Article_notification_emails::get_all_records('DISTINCT(ane_stage_etmp_id) as stage_etmp_id,ane_subject as stage_etmp_subject,ane_template_name as stage_etmp_name,ane_setr_id as setr_id', $where,'ane_id','','','','','ASC');
        return 	$stage_save_emails;
        }
    }
     //moved this fuction from manage_dashboard to my_controller
     public function save_article_email_notification($article_data, $from, $type = '')
     {
                $current_user = $this->get_current_user_details();
                 $Article_notification_emails = new \App\Models\Article_notification_emails;
                 $Email_attachments = new \App\Models\Email_attachments;
                 $Generic_form_files = new \App\Models\Generic_form_files;
                 $Articles = new \App\Models\Articles;
                 $Production_attachment_files = new \App\Models\Production_attachment_files();
                 $Email_templates = new \App\Models\Email_templates;
                 $Stage_email_templates = new \App\Models\Stage_email_templates;
                 $id = isset($article_data['id']) ? decrypt_link($article_data['id']): '';
                 $art_id = isset($article_data['art_id']) ? decrypt_link($article_data['art_id']): '';
                 $aflw_id = isset($article_data['aflw_id']) ? decrypt_link($article_data['aflw_id']): '';
                 $template = isset($article_data['template']) ?  decrypt_link($article_data['template']): '';
                 $current_status = isset($article_data['current_status']) ?  decrypt_link($article_data['current_status']): '';
         $hidden_id = '';
         if ($from == 'email')
         {
             $article_data['article_id'] = $art_id;
             $hidden_id = (isset($article_data['ane_id'])&&$article_data['ane_id'] != "") ? decrypt_link($article_data['ane_id']) : "";
             $email_template_name = $email_template_action = $email_template_stage_type = '';
             if(isset($article_data['event_temp']) && $article_data['event_temp'] == 'y' )
             {
                 if(isset($article_data['id']) && $article_data['id'] !== '')
                 {
                     $template_id = $id;
                 }
                 else
                 {
                     $template_id = $article_data['temp_id'];
                     $article_data['id'] = encrypt_link($template_id);
                 }
                 $email_template_name = '';
                 if(!empty($template_id)){
                    $event_email = $Email_templates::get_single_record('etmp_templete_name',"etmp_id={$template_id}");
                    $email_template_name = $event_email->etmp_templete_name;
                 }

                 $email_template_action =  (isset($article_data['tmpl_action']) && $article_data['tmpl_action']!=NULL)?$article_data['tmpl_action']:'';
                 $email_template_stage_type = $article_data['stage_type'];
             }
             else
             {
                 $stage_email = $Stage_email_templates::get_single_record('stage_etmp_to,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action',"stage_etmp_id={$id}");
                 $email_template_name = $stage_email->stage_etmp_name;
                 $email_template_action =  $stage_email->stage_etmp_action;
                 $email_template_stage_type = $stage_email->stage_etmp_stage_type;
                 if(!isset($article_data['to'])){
                    $article_data['to'] = $stage_email->stage_etmp_to;
                 }
             }
             $cust_bcc =isset($article_data['postdata']['stage_cust_bcc'])  ? $article_data['postdata']['stage_cust_bcc'] : '';
             $cust_cc =isset($article_data['postdata']['stage_cust_cc'])  ? $article_data['postdata']['stage_cust_cc'] : '';
             $replaceval = '';
             if(isset($article_data['postdata']['stage_template_content'])){
                 $replace_button = array('<button contenteditable="false">', '</button>');
                 $replaceval = str_replace($replace_button,'##',$article_data['postdata']['stage_template_content']);
                }else{
                    $replaceval = $article_data['content'];
                }
             $content = $replaceval;
             $formdata = array(
                 'ane_stage_etmp_id' => $id,
                 'ane_art_id' => $art_id,
                 'ane_stage_type' => $email_template_stage_type,
                 'ane_action' => $email_template_action,
                 'ane_template_name' => $email_template_name,
                 'ane_to' => isset($article_data['postdata']['stage_template_to']) ? $article_data['postdata']['stage_template_to'] : $article_data['to'],
                 'ane_subject' => isset($article_data['postdata']['stage_template_sub']) ? $article_data['postdata']['stage_template_sub'] : $article_data['email_sub'],
                 'ane_content' => $content,
                 'ane_setr_id' => isset($article_data['setr_id']) ? decrypt_link($article_data['setr_id']):0,
                 'ane_cust_to' => (isset($article_data['postdata']['stage_cust_to']) && trim($article_data['postdata']['stage_template_to']) == "Custom_to") ? $article_data['postdata']['stage_cust_to'] : '',
                 'ane_cust_cc' => $cust_cc,
                 'ane_cust_bcc' => $cust_bcc,
                 'ane_reply_to' => (isset($article_data['postdata']['stage_template_to_mail'])) ? $article_data['postdata']['stage_template_to_mail'] : ''
             );
             if($type != ''){
                 $formdata['ane_for'] = $type;
             }
             if (isset($article_data['email_for']) && ($article_data['email_for'] == 'complete' || $article_data['email_for'] == 'change_asmt'))
             {
                 $formdata['ane_aflw_id'] = $aflw_id;
             }
             if (isset($article_data['email_for']) && ($article_data['email_for'] == 'initialization' || $article_data['email_for'] == 'decision'))
             {
                 $formdata['ane_prev_aflw_id'] =$aflw_id;
                 if(isset($article_data['setr_id'])){
                   $str_id  = decrypt_link($article_data['setr_id']);
                   $nxt_jwf_id = Stage_email_tmpl_reference::find($str_id)?->setr_jwf_id;
                   $formdata['ane_next_jwf_id'] = $nxt_jwf_id;
                 }else{
                    $formdata['ane_next_jwf_id'] = decrypt_link($article_data['next_jwf_id']);
                 }
                 //#357 ane_flow_id was NULL
                 $formdata['ane_aflw_id'] = $aflw_id;
             }
             if (isset($article_data['email_for']) && $article_data['email_for'] == 'rescind')
             {
                 if ($article_data['source'] == 'source')
                 {
                     $formdata['ane_aflw_id'] = $aflw_id;
                 }
                 else
                 {
                     $formdata['ane_prev_aflw_id'] = $aflw_id;
                     $formdata['ane_next_jwf_id'] = decrypt_link($article_data['next_jwf_id']);
                 }
             }
             if(isset($aflw_id)){
                $formdata['ane_aflw_id'] = $aflw_id;
             }
             $formdata['ane_cc'] ='';
             $formdata['ane_bcc'] ='';
             if (isset($article_data['postdata']['stage_template_to_cc'])) {
                	$cc = $article_data['postdata']['stage_template_to_cc'];
                    $formdata['ane_cc'] = json_encode($cc);
                }
                if (isset($article_data['postdata']['stage_template_to_bcc'])) {
                	$bcc = $article_data['postdata']['stage_template_to_bcc'];
                	$formdata['ane_bcc'] = json_encode($bcc);
                }
            //  $formdata['ane_cc'] = (isset($article_data['stage_template_to_cc']) && $article_data['stage_template_to_cc'] != "") ? json_encode($article_data['stage_template_to_cc']) : '';
            //  $formdata['ane_bcc'] = (isset($article_data['stage_template_to_bcc']) && $article_data['stage_template_to_bcc'] != "") ? json_encode($article_data['stage_template_to_bcc']) : '';

             if ($hidden_id == "")
             {
                 $art_noti_condition = ' ane_status = 0 AND ';
                 if($type != ''){
                    $art_noti_condition .= "ane_for = '{$type}' AND ";
                }
                 if(isset($article_data['event_temp']) && $article_data['event_temp'] == 'y' )
                 {
                    if(empty($id) && $article_data['stage_type'] == 'reopen_review'){
                        $etmp = $Email_templates::get_single_record('etmp_id,etmp_notification',"etmp_name='{$article_data['stage_type']}'");
                        $id = $etmp->etmp_id;
                        $formdata['ane_to'] = $etmp->etmp_notification;
                    }
                     $art_noti_condition .="ane_event_etmp_id={$id} AND ane_art_id={$art_id} AND ane_stage_type='{$email_template_stage_type}' AND ane_aflw_id={$aflw_id}";
                 }
                 else
                 {
                    $art_noti_condition .="ane_stage_etmp_id={$id} AND ane_art_id={$art_id} AND ane_stage_type='{$email_template_stage_type}' AND ane_aflw_id={$aflw_id}";
                 }
                 $article_notification = $Article_notification_emails::get_single_record('ane_id',$art_noti_condition, orderby:"ane_id desc");
                 if (!empty($article_notification))
                 {
                     $hidden_id = $article_notification->ane_id;
                 }
             }
         }
                 else if($from === 'default_save')
                 {
                     $stage_email = $Stage_email_templates::get_single_record('stage_etmp_name,stage_etmp_to,stage_etmp_stage_type,stage_etmp_action,stage_etmp_cust_to,stage_etmp_subject,stage_etmp_content,stage_etmp_cc,stage_etmp_bcc',"stage_etmp_id={$id}");
                     $formdata = array(
                             'ane_stage_etmp_id' => $id,
                             'ane_art_id' => $art_id,
                             'ane_stage_type' => $stage_email->stage_etmp_stage_type,
                             'ane_aflw_id' => $aflw_id,
                             'ane_action' => $stage_email->stage_etmp_action,
                             'ane_to'     => $stage_email->stage_etmp_to,
                             'ane_subject' => $stage_email->stage_etmp_subject,
                             'ane_content' => $stage_email->stage_etmp_content,
                             'ane_template_name' => $stage_email->stage_etmp_name,
                             'ane_cust_to' => $stage_email->stage_etmp_cust_to,
                             'ane_cust_cc' => $stage_email->stage_etmp_cc,
                             'ane_cust_bcc' => $stage_email->stage_etmp_bcc,
                             'ane_setr_id' => $article_data['setr_id'],
                             'ane_reply_to' => ''
                     );

                     $formdata['ane_cc'] = '';
                     $formdata['ane_bcc'] = '';
                     if (isset($article_data['postdata']['stage_template_to_cc'])) {
                        $cc = implode(',', $article_data['postdata']['stage_template_to_cc']);
                        $formdata['ane_cc'] = json_encode($cc);
                    }
                    if (isset($article_data['postdata']['stage_template_to_bcc'])) {
                        $bcc = implode(',', $article_data['postdata']['stage_template_to_bcc']);
                        $formdata['ane_bcc'] = json_encode($bcc);
                    }
                     $article_notification = $Article_notification_emails::get_single_record('ane_id',"ane_stage_etmp_id={$id} AND ane_art_id={$art_id} AND ane_stage_type='{$stage_email->stage_etmp_stage_type}' AND ane_aflw_id={$aflw_id} AND ane_status = 0 ");
                     if (!empty($article_notification))
                     {
                             $hidden_id = $article_notification->ane_id;
                     }
                 }
         else
         {
             $stage_email = $Stage_email_templates::get_single_record('stage_etmp_name,stage_etmp_stage_type,stage_etmp_action', "stage_etmp_id={$template}");
             $cust_bcc = ((isset($article_data['postdata']['stage_template_to_bcc'])) && !empty($article_data['postdata']['stage_template_to_bcc']) && in_array('Custom_bcc', $article_data['postdata']['stage_template_to_bcc'])) ? $article_data['postdata']['stage_cust_bcc'] : '';
             $cust_cc = ((isset($article_data['postdata']['stage_template_to_cc'])) && !empty($article_data['postdata']['stage_template_to_cc']) && in_array('Custom_cc', $article_data['postdata']['stage_template_to_cc'])) ? $article_data['postdata']['stage_cust_cc'] : '';

             $formdata = array(
                 'ane_stage_etmp_id' => $template,
                 'ane_art_id' => $article_data['article_id'],
                 'ane_stage_type' => $article_data['stage_etmp_stage_type'],
                 'ane_aflw_id' => decrypt_link($article_data['current_status']),
                 'ane_action' => $article_data['stage_etmp_action'],
                 'ane_to' => $article_data['to_mail'],
                 'ane_subject' => $article_data['subject'],
                 'ane_content' => $article_data['content'],
                 'ane_template_name' => $stage_email->stage_etmp_name,
                 'ane_cust_to' => (isset($article_data['cust_to']) && trim($article_data['cust_to']) == "Custom") ? $article_data['cust_to'] : '',
                 'ane_cust_cc' => $cust_cc,
                 'ane_cust_bcc' => $cust_bcc,
                 'ane_reply_to' => (isset($article_data['reply_to'])) ? $article_data['reply_to'] : ''
             );

             $formdata['ane_cc'] = '';
             $formdata['ane_bcc'] = '';
             if (isset($article_data['postdata']['stage_template_to_cc'])) {
                $cc = implode(',', $article_data['postdata']['stage_template_to_cc']);
                $formdata['ane_cc'] = json_encode($cc);
            }
            if (isset($article_data['postdata']['stage_template_to_bcc'])) {
                $bcc = implode(',', $article_data['postdata']['stage_template_to_bcc']);
                $formdata['ane_bcc'] = json_encode($bcc);
            }
             $hidden_id = ($article_data['stage_hdn_id'] != "") ? decrypt_link($article_data['stage_hdn_id']) : '';
             if ($hidden_id == "")
             {
                 $article_notification = $Article_notification_emails::get_single_record('ane_id',"ane_stage_etmp_id={$template} AND ane_art_id={$article_data['article_id']} AND ane_stage_type='{$article_data['stage_etmp_stage_type']}' AND ane_aflw_id={$current_status} and ane_status = 0 order by ane_id desc");
                 if (!empty($article_notification))
                 {
                     $hidden_id = $article_notification->ane_id;
                 }
             }
         }

         if(isset($article_data['event_temp']) && $article_data['event_temp'] == 'y' && isset($formdata['ane_stage_etmp_id']))
         {
             $formdata['ane_stage_etmp_id'] = NULL;
             $formdata['ane_event_etmp_id'] = $id;
         }
         else
         {
             $formdata['ane_event_etmp_id'] = NULL;
         }
         if($formdata['ane_cc']=='[]'||$formdata['ane_cc']=='""'){
            $formdata['ane_cc']='';
         }
         if($formdata['ane_bcc']=='[]'||$formdata['ane_bcc']=='""'){
            $formdata['ane_bcc']='';
         }
         if (isset($hidden_id) && $hidden_id != '')
{
             $ane_id = $hidden_id;
             $Article_notification_emails::update_record($formdata, "ane_id={$hidden_id}", $current_user);
         }
         else
         {
             $ane_id = $Article_notification_emails::insert_record($formdata, $current_user);
         }
         if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y') {
             if (isset($article_data['postdata']['attach_org']) && !empty($article_data['postdata']['attach_org'])) {
                 $article_details = $Articles::get_single_record('art_article_upload_path',"art_id={$article_data['article_id']}");
                 foreach ($article_data['postdata']['attach_org'] as $att) {
                     $genric_form_file = $Generic_form_files::get_single_record('agf_id,agf_name,agf_file_size',"agf_id={$att}");
                     if (!empty($genric_form_file)) {
                        $insert_data = array(
							'emat_file_name' => $genric_form_file->agf_name,
							'emat_ane_id' => $ane_id,
							'emat_agf_id' => $genric_form_file->agf_id,
							'emat_art_id' => $article_data['article_id'],
							'emat_document_size' => $genric_form_file->agf_file_size
						);
                        if($type != ''){
                            $insert_data['emat_for'] = $type;
                        }
                         $email_attach_exists = $Email_attachments::get_single_record('emat_file_name',"emat_file_name='{$genric_form_file->agf_name}' and emat_ane_id={$ane_id} and emat_agf_id={$genric_form_file->agf_id} ");
                         if (empty($email_attach_exists)) {
                            $source = public_path() . '/storage/uploads/' . $article_details->art_article_upload_path . '/' . $genric_form_file->agf_name;
							$destination = public_path() . '/storage/uploads/email_attachments/' . $art_id;

							if (!file_exists($destination)){
								mkdir($destination, 0765, TRUE);
							}
							$dest_file = $destination . '/' . $genric_form_file->agf_name;
							//#357 if $source does not exists , PHP error showing for copy function
							if (file_exists($source)) {
								copy($source, $dest_file);
							}
                            $Email_attachments::insert_record($insert_data, $this->current_user);
                         }
                     }
                 }
             }
 //#1954 Author designated file attach publish complete stage code start
             if (isset($article_data['postdata']['attach_mod_production']) && !empty($article_data['postdata']['attach_mod_production']))
             {
                 $article_details = $Articles::get_single_record('art_article_upload_path',"art_id={$article_data['article_id']}" );
                 foreach ($article_data['postdata']['attach_mod_production'] as $att_production)
                 {
                     $production_uploaded_files = $Production_attachment_files::get_single_record('paf_id,paf_file_name,paf_aflw_id',"paf_id={$att_production}");
                         if (!empty($production_uploaded_files))
                     {
                         $destination = 'uploads/email_attachments/' . $article_data['article_id'];
                             if (!file_exists($destination))
                                 mkdir($destination, 0765, TRUE);

                             $dest_file = $destination . '/' . $production_uploaded_files->paf_file_name;
                     $original_name_of_file=$production_uploaded_files->paf_file_name;
                if(file_exists($dest_file))
                {
                    $name_of_uploaded_file=$this->updatenewName($destination, $original_name_of_file);



                         $destination_file_path =$destination.'/'. $name_of_uploaded_file;
                }
                else
                {
                   $name_of_uploaded_file =$production_uploaded_files->paf_file_name;
                   $destination_file_path=$dest_file;
                }
                $insert_data ="emat_file_name={$name_of_uploaded_file} AND emat_ane_id={$ane_id} AND emat_agf_id={$ $production_uploaded_files->paf_id}";

                         $email_attach_exists = $Email_attachments::get_single_record('emat_file_name', $insert_data);

                         if (empty($email_attach_exists))
                         {
                             $source = 'uploads/' . $article_details->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/'. $production_uploaded_files->paf_aflw_id. DIRECTORY_SEPARATOR.$production_uploaded_files->paf_file_name;


                             //#357 if $source does not exists , PHP error showing for copy function
                             if (file_exists($source)) {

                                 copy($source, $destination_file_path);
                             }
                             $Email_attachments::insert_record($insert_data);
                         }
                     }
                 }
             }

         }
         //#1954 Author designated file attach publish complete stage code end
         return $ane_id;
     }
    public function copy_user_affliation_to_author($affiliation_data_arr, $user_affliation, $auth_id, $prime_aff_status = 'n')
    {
        $current_user = $this->get_current_user_details();
        if (!empty($user_affliation)) {
            foreach ($user_affliation as $key => $us_value) {
                $usraff_row = array(
                    'auaff_auth_id' => $auth_id,
                    'auaff_email' => $us_value->usaff_email,
                    'auaff_department' => $us_value->usaff_department,
                    'auaff_company' => $us_value->usaff_company,
                    'auaff_ringgold_id' => $us_value->usaff_ringgold_id,
                    'auaff_ringgold_family' => $us_value->usaff_ringgold_family,
                    'auaff_address_line1' => $us_value->usaff_address_line1,
                    'auaff_address_line2' => $us_value->usaff_address_line2,
                    'auaff_cnt_id' => $us_value->usaff_cnt_id,
                    'auaff_state' => $us_value->usaff_state,
                    'auaff_postal_code' => $us_value->usaff_postal_code,
                    'auaff_type' => $us_value->usaff_type,
                    'auaff_phone' => $us_value->usaff_phone,
                    'auaff_posted_by' => $current_user['user_id'],
                    'auaff_posted_date' => date('Y-m-d H:i:s'),
                    'auaff_prime_affiliation' => ($prime_aff_status == 'n') ? $us_value->usaff_prime_affiliation : 'n'
                );
                array_push($affiliation_data_arr, $usraff_row);
            }
            Authors_affiliation::insert_batch($affiliation_data_arr);
        }
    }
    public function get_blinded_users($jnl_code,$art_id,$show_user_info=FALSE,$article_blind_permission = TRUE,$full_name_only = FALSE)
    {
        if($art_id && is_array($art_id)){
            return [];
        }
        $Blind_user_articles = new \App\Models\Blind_user_articles();
        $Blind_user_articles_table = ($Blind_user_articles)->getTable();
        $blinded_usr_details = $usr_names = $blind_list = array();
        $blinded_usr_records = $Blind_user_articles::get_single_record('bau_usr_ids','bau_art_id = '. $art_id);
        $platform_data = $this->platform_basic_settings_data($jnl_code);
        $journal_id = $platform_data->jnl_id;
        if(isset($blinded_usr_records->bau_usr_ids)){
            $blinded_usr_ids = implode(',',json_decode($blinded_usr_records->bau_usr_ids));
            $checkdata = str_replace(",","",$blinded_usr_ids);
            if(!empty($checkdata))
            {
            $blinded_usr_details = $this->get_all_users('',$art_id,$blinded_usr_ids,$jnl_code);
            }
        }
        if($show_user_info == TRUE)
        {
            if(!empty($blinded_usr_details))
            {
                foreach($blinded_usr_details as $bln_user)
                {
                    $array_data['user_id'] = $bln_user->usr_id;
                    $array_data['journal_id'] = $journal_id;
                    $array_data['flag'] = TRUE;
                    $array_data['article_id'] = $art_id;
                    $array_data['jnl_code'] = $jnl_code;
                    $usr_names[] = $this->get_user_display_name($array_data);
                }
                $blind_list = $usr_names;
                if($article_blind_permission == TRUE && $full_name_only == FALSE)
                {
                   // $blind_list .= '<span class="update_userList" data-artid=" '. encrypt_link($art_id) .' " title="Edit"><i class="btn fa fa-pencil"></i></span>';
                }
            }
            else
            {
               // $blind_list = '<span id="span_userList"><a class="text-light add_userList" data-artid="'. encrypt_link($art_id) .'">Select user</a></span>';
                if($article_blind_permission == FALSE)
                {
                  //  $blind_list ='<center>--</center>';
                }
                if($full_name_only == TRUE)
                {
                    $blind_list ='--';
                }
            }
            return $blind_list;
        }
        return $blinded_usr_details;
    }
    public function get_all_users($post_data_search='', $art_id='', $blinded_usr_ids='',$jnl_code='')
    {
        $Generic_discussion = new \App\Models\Generic_discussion();
        $Generic_discussion_table = ($Generic_discussion)->getTable();
        $Article_flow = new \App\Models\Article_flow();
        $Article_flow_table = ($Article_flow)->getTable();
        $User_articles = new \App\Models\User_articles();
        $User_articles_table = ($User_articles)->getTable();
        $current_user = $this->current_user = $this->get_current_user_details();
        //users who are already associated with the article dont need to be listed for blinding.
        //exclude users in user_article table
        $select_fields = 'GROUP_CONCAT(DISTINCT(aflw_usr_id)) as user_ids,GROUP_CONCAT(DISTINCT(usra_usr_id)) as user_article_ids';
        $user_id_sql = "SELECT " . $select_fields . " from  ".$Article_flow_table." LEFT JOIN ".$User_articles_table." ON usra_art_id = aflw_art_id WHERE aflw_art_id = " . $art_id;
        $user_ids = Articles::get_records_by_raw_query($user_id_sql);
        $exclude_user_ids = $user_ids[0]->user_ids;
        if(isset($user_ids[0]->user_article_ids) && !empty($user_ids[0]->user_article_ids))
        {
            $exclude_user_ids = $exclude_user_ids .','.$user_ids[0]->user_article_ids;
        }
        //exclude all co-authors
        $article_author_details = Authors::get_single_record('group_concat(auth_usr_id) as auth_usr_ids', 'auth_art_id=' . $art_id );
        if(!empty($article_author_details->auth_usr_ids)){
            $exclude_user_ids = $exclude_user_ids .','. $article_author_details->auth_usr_ids;
        }
        //exclude users in generic discussions
        $where = 'gdis_art_id = ' . $art_id . ' AND gdis_participants_by_usr_id IS NOT NULL';
        $users_in_discussion = $Generic_discussion::get_all_records('gdis_participants_by_usr_id', $where);
        if(!empty($users_in_discussion))
        {
            $user_ind_discn_arr = array();
            $user_ind_discn_str = '';
            foreach($users_in_discussion as $user)
            {
                if(!empty($user->gdis_participants_by_usr_id) && (is_null($user->gdis_participants_by_usr_id) == true) ){
                    $user_ind_discn_arr[] = implode(',',json_decode($user->gdis_participants_by_usr_id));
                }
            }
            $user_ind_discn_str = implode(',',array_unique(explode(',',implode(',',$user_ind_discn_arr))));
            if(!empty($user_ind_discn_str)){
                $exclude_user_ids = $exclude_user_ids . ',' . $user_ind_discn_str;
            }
        }
        if($current_user){
            if($current_user['proxy_user_id'] == 0)
            {
                $exclude_user_ids = $exclude_user_ids . ',' . $current_user['user_id'];
            }
            else
            {
                $exclude_user_ids = $exclude_user_ids . ',' . $current_user['proxy_user_id'];
            }
        }
        $all_users = User_to_journals::get_blind_article_users($jnl_code,  $current_user['proxy_user_id'] ?? 0,$exclude_user_ids,$blinded_usr_ids, $post_data_search);
        return $all_users;
    }

    public function assignment_details($flow_data,$platform_id,$user_id,$stage_flow,$user_roles)
    {
        $assignment = FALSE;
        $return_array =array('roles_to_assign'=>'','assignment'=>$assignment);
        $Assign_permission = new \App\Models\Assign_permission();
        if ($flow_data->aflw_status == 'a' && $flow_data->aflw_usr_id == $user_id) {
            $roles_to_assign = array();
            if ((isset($stage_flow['assignment_tabs']) && $stage_flow['assignment_tabs'] == TRUE) && !empty($stage_flow['child_stages']) && $flow_data->aflw_usr_id == $user_id && !in_array($flow_data->jwf_stage_type, array(
                'accept',
                'reject',
                'decision_revision',
                'license_check','production'
            ))) {
                    $to_assign = array();
                    if (!empty($user_roles) && in_array($flow_data->jwf_role_id, $user_roles)) {
                        //$assigncount = $Assign_permission->get_single_record('count(asgm_artp_id) as cnt', 'asgm_artp_id=' . $flow_data->artp_id . ' AND asgm_can_assgn_role=' . $flow_data->jwf_role_id);
                        $assigncount = $Assign_permission->get_single_record('count(asgm_artp_id) as cnt', 'asgm_artp_id=' . $flow_data->artp_id);
                        $select = 'distinct role_id, role_name,asgm_can_assgn_role';
                        if ($assigncount->cnt > 0) {
                            $where = 'asgm_artp_id = ' . $flow_data->artp_id . ' AND asgm_can_assgn_role=' . $flow_data->jwf_role_id;
                        } else {
                            $where = 'asgm_artp_id IS NULL and asgm_jnl_id = ' . $platform_id . ' AND asgm_can_assgn_role=' . $flow_data->jwf_role_id;
                        }
                        $to_assign = $Assign_permission->get_roles_to_assign($select, $where);
                        if (!empty($to_assign) && $stage_flow['assignment_tabs']==TRUE) {
                            $roles_to_assign = $this->check_assignment_tab_visibility($flow_data, $to_assign, $flow_data->jwf_stage_type); // To remove the assignment tab if child stages don't have the roles.
                            //die;
                            //die($roles_to_assign);
                            if (!empty($roles_to_assign) && isset($roles_to_assign[0]->role_id)) {
                                $assignment = TRUE;
                            }
                        }
                        else{
                            $assignment = TRUE;
                            $roles_to_assign = $to_assign;
                        }
                        if(!empty($roles_to_assign) && isset($roles_to_assign[0]->role_id))
                        {
                        $return_array['roles_to_assign'] = $roles_to_assign;
                        $return_array['assignment'] = $assignment;
                        }
                    }
                }


            }
            else if ($flow_data->aflw_status == "p") {
                $assignment = FALSE;
                //check assignment exist
                $to_assign = array();
                if (!empty($stage_flow['child_stages']) && !in_array($flow_data->jwf_stage_type, array(
                    'accept',
                    'reject',
                    'decision_revision'
                ))) {
                    $assigned_core_role = Roles::get_single_record('role_name,role_assigned_role', 'role_id=' . $flow_data->jwf_role_id);
                    $to_assign =  array('role_id' => $flow_data->jwf_role_id, 'role_name' => $assigned_core_role->role_name, 'asgm_can_assgn_role' => '');
                    $assignment = TRUE;
                }
                $return_array['roles_to_assign']= $to_assign;
                $return_array['assignment'] = $assignment;
            }
            return $return_array;
        }
///manage email
public function get_email_contents($stage_flow, $article_flow)
{
    $this->current_user = $this->get_current_user_details();
    $Article_notification_emails = new \App\Models\Article_notification_emails;
    $Article_notification_emails_table= (new \App\Models\Article_notification_emails)->getTable();;
    $Stage_email_templates = new \App\Models\Stage_email_templates;
    $Email_send_log=new \App\Models\Email_send_log();
    $article_id = $article_flow[0]->art_id;
    $current_aflw_id = $article_flow[0]->aflw_id;
    $show_emails = FALSE;
    $author_stages = array(
        'author_submission',
        'review',
        'revision',
        'resubmission');
    $decision_stages = array(
        'accept',
        'reject',
        'decision_revision');
    $content = '';
    // $this->remove_tab = TRUE;

    $complete_email = $this->current_client->functionality->cfty_manage_on_complete_email;

    $permission = (isset($stage_flow['permission']) && in_array('notifications',$stage_flow['permission'])) ? TRUE : FALSE;

    if (!in_array($article_flow[0]->jwf_stage_type, $author_stages) && ($this->current_user['user_id'] == $article_flow[0]->aflw_usr_id || $this->is_access_overriding_user($article_flow[0]->jnl_journal_code, $this->current_user['user_id'], $current_aflw_id)))
    {
        if (( $complete_email == 'y' || $permission == TRUE ) && $article_flow[0]->art_status != 'n' && $article_flow[0]->aflw_status == 'a')
        {

            $show_emails = TRUE;
            $date_format=$this->get_platform_date_format($article_flow[0]->jnl_id);
            $date_format=$this->date_format_map($date_format);
            $where = ' (stage_etmp_action = "declined" OR stage_etmp_action = "completed" ) AND stage_etmp_stage_type ="' . $article_flow[0]->jwf_stage_type . '" AND setr_jwf_id=' . $article_flow[0]->jwf_id . ' AND stage_etmp_to != "User"';
            if ($complete_email == 'y')
            {
                $select = 'setr_id,stage_etmp_subject,stage_etmp_name,stage_etmp_id,DATE_FORMAT(stage_etmp_posted_date, "' . $date_format . ' %H:%i") as stage_date,(SELECT DATE_FORMAT(ane_updated_date, "' . $date_format . ' %H:%i") FROM ' . $Article_notification_emails_table . ' WHERE ane_stage_etmp_id = stage_etmp_id AND ane_art_id = ' . $article_id . ' AND ane_updated_date IS NOT NULL ) as last_updated_date';
            }
            else
            {
                $select = 'stage_etmp_id,stage_etmp_name';
            }


            $stage_emails = $Stage_email_templates::get_stage_email_tmpl_to_trigger($select, $where);

            if ($complete_email == 'y' && count($stage_emails) > 0)
            {
                $data['on_complete_emails'] = $stage_emails;
                $data['status_id'] = $current_aflw_id;
                $data['article_id'] = $article_id;
                $data['journal_code'] = $article_flow[0]->jnl_journal_code;
                // $data['on_complte_email_tab_name'] = (in_array($article_flow[0]->jwf_stage_type, $decision_stages)) ? 'Decision Letter' : 'Manage Email';
                $content =  $data;
                // $this->remove_tab = FALSE;
            }
            elseif ($complete_email == 'n')
            {
                $data['article_stage_emails'] = $stage_emails;
                $content =  $data;
                // $this->remove_tab = FALSE;
            }
        }
        elseif ($article_flow[0]->aflw_status == 'c' && in_array($article_flow[0]->jwf_stage_type, $decision_stages) && ($permission == TRUE || $complete_email == 'y'))
        {

            $email_action = ($article_flow[0]->jwf_stage_type == 'reject') ? 'declined' : 'completed'; //need to list only email send on complete decision in decision letter.
            $esl_action_exist = FALSE;

            $fetch_condition['esl_aflw_id'] = $current_aflw_id;
            $exist_compl_email = $Email_send_log::get_single_record('COUNT(esl_id) as cnt', "esl_aflw_id ={$current_aflw_id} AND esl_resend_email_id='0' AND esl_etmp_action IS NOT NULL");
            if (!empty($exist_compl_email) && $exist_compl_email->cnt > 0)
            {
                $esl_action_exist = TRUE;
                $fetch_condition['esl_etmp_action'] = $email_action;
            }
                            //Minor bug fix.- resented decision mails are listing in the decision letter tab
                            $fetch_condition['esl_resend_email_id'] = 0;
            $decision_email_sent_data = $Email_send_log::get_all_records('esl_id as id,esl_to as to,esl_bcc as bcc,esl_cc as cc,esl_content as content,esl_subject as subject,esl_attachments', $fetch_condition);

            if (empty($decision_email_sent_data) && $esl_action_exist === FALSE)
            {

                $possible_roles = array();
                $possible_roles['User'] = 'Stage assigned user';
                $possible_roles['submit_author'] = 'Submitted author';
                $possible_roles['Author'] = 'Corresponding author';
                $possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
                // $possible_roles['Authors'] = 'All authors in article type';

                $privileged_roles = privileged_user_roles();
                $all_usr_roles = Roles::get_all_records('role_id,role_name, role_assigned_role', 'role_assigned_role IN ("' . implode('","', $privileged_roles) . '")');   //to fix:- user roles array updated
                if (!empty($all_usr_roles))
                {
                    foreach ($all_usr_roles as $usrole)
                    {
                        $role_label = "All " . strtolower($usrole->role_name) . "s";
                        $possible_roles[$usrole->role_name] = $role_label;
                    }
                }

                $stage_email_templetes = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_to,stage_etmp_cust_to,stage_etmp_cc,stage_etmp_cust_cc,stage_etmp_bcc,stage_etmp_cust_bcc,stage_etmp_subject as subject,stage_etmp_content as content,stage_etmp_id as id,setr_id',"setr_jwf_id={$article_flow[0]->jwf_id} AND stage_etmp_action={$email_action}");
                if (!empty($stage_email_templetes))
                {

                    $email_data = new stdClass;
                    $cfty_decision_mail_comment_submitted = false;
                    if (isset($this->current_client))
                    {
                        if (isset($this->current_client->functionality))
                        {
                            $cfty_decision_mail_comment_submitted = ($this->current_client->functionality->cfty_decision_mail_comment_submitted == 'y') ? true : false;
                        }
                    }
                    $email_data->cfty_decision_mail_comment_submitted = $cfty_decision_mail_comment_submitted;
                    $email_data->article_title = $article_flow[0]->art_title;
                    $email_data->article_id = $article_flow[0]->art_id;
                    $email_data->jnl_journal_code = $this->jnl_data->jnl_journal_code;
                    $email_data->aflw_id = $current_aflw_id;
                    $email_data->stage_name = $article_flow[0]->jwf_stage_name;
                    $email_data->status_name = $article_flow[0]->jwf_status_name;
                    $email_data->artp_id = $article_flow[0]->artp_id;
                    $email_data->jnl_id = $article_flow[0]->jnl_id;
                    $email_data->article_type = $article_flow[0]->artp_article_type;


                    $email_data->user_id = $this->current_user['user_id'];


                    $email_data->email_templates_config = $this->email_templates_config();
                    if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                        $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();

                    if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

                    $user_titles =$this->UserConfigdata('titles')['titles'];

                    foreach ($stage_email_templetes as $stage_em)
                    {

                        $article_notification = $Article_notification_emails::get_single_record('ane_to as to,ane_cc as cc,ane_bcc as bcc,ane_subject as subject,ane_content as content,ane_setr_id as setr_id',"ane_stage_etmp_id={$stage_em->id} AND ane_aflw_id={$current_aflw_id}");
                        if (!empty($article_notification))
                        {
                            $article_notification->id = $stage_em->id;
                            $article_notification->to = $possible_roles[$article_notification->to];
                            $article_notification->bcc = ( ( $article_notification->bcc != "" && $article_notification->bcc != '""') ? join(',', json_decode($article_notification->bcc)) : '');
                            $article_notification->cc = ( ( $article_notification->cc != "" && $article_notification->cc != '""') ? join(',', json_decode($article_notification->cc)) : '');

                            //get tag replaced subject and content
                            $article_notification->subject = $this->generate_email_data_from_keys($email_data, $stage_em->subject,$this->current_user, $user_titles);
                            $article_notification->content = $this->generate_email_data_from_keys($email_data, $stage_em->content,$this->current_user, $user_titles);

                            $decision_email_sent_data[] = $article_notification;
                        }
                        else
                        {
                            $stage_em->subject = $this->generate_email_data_from_keys($email_data, $stage_em->subject,$this->current_user, $user_titles);
                            $stage_em->content = $this->generate_email_data_from_keys($email_data, $stage_em->content,$this->current_user, $user_titles);
                            $stage_em->to = ($stage_em->stage_etmp_cust_to != "") ? $stage_em->stage_etmp_cust_to : $possible_roles[$stage_em->stage_etmp_to];
                            $stage_em->bcc = ($stage_em->stage_etmp_cust_bcc != "") ? $stage_em->stage_etmp_cust_bcc : ( ( $stage_em->stage_etmp_bcc != "" && $stage_em->stage_etmp_bcc != '""') ? join(',', json_decode($stage_em->stage_etmp_bcc)) : '');
                            $stage_em->cc = ($stage_em->stage_etmp_cust_cc != "") ? $stage_em->stage_etmp_cust_cc : ( ( $stage_em->stage_etmp_cust_cc != "" && $stage_em->stage_etmp_cust_cc != '""') ? join(',', json_decode($stage_em->stage_etmp_cust_cc)) : '');
                            $decision_email_sent_data[] = $stage_em;
                        }
                    }

                    $decision_email_sent_data = (object) $decision_email_sent_data;
                }
            }
            else
            {
                if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y')
                {
                    foreach ($decision_email_sent_data as $eml)
                    {
                        $esl_attach = ($eml->esl_attachments != NULL) ? json_decode($eml->esl_attachments, TRUE) : array();
                        $email_attach = array();
                        if (!empty($esl_attach))
                        {


                            if (isset($esl_attach['article']) && !empty($esl_attach['article']))
                            {
                                foreach ($esl_attach['article'] as $eat)
                                {
                                    $email_attach[$eat] = 'uploads/' . $article_details->art_article_upload_path . '/' . $eat;
                                }
                            }
                            elseif (isset($esl_attach['modified']) && !empty($esl_attach['modified']))
                            {
                                foreach ($esl_attach['modified'] as $eat)
                                {
                                    $email_attach[$eat] = 'uploads/email_attachments/' . $article_details->art_id . '/' . $eat;
                                }
                            }
                        }
                        $eml->email_attachments = $email_attach;
                    }
                }
            }
            $data['decision_email_sent_data'] = $decision_email_sent_data;
            $data['journal_code'] = $this->jnl_data->jnl_journal_code;
            $content =  $data;
            // $this->remove_tab = FALSE;
        }
    }
    return $content;
}
    public function get_article_flags_formatted($article_id, $jnlcode)
    {
        $Article_flag = new \App\Models\Article_flag();
        $rtnHtml = '';
        $reviewer_role_id ='';
        $author_role_id ='';
        $reviewer_role_id = 0;
        $check_revwr = FALSE;
        $is_non_author = TRUE;
        // $artcriteria = "aflg_art_id=$article_id  AND flag_status='y'";
        $artcriteria = "aflg_art_id=$article_id AND flag_status = 'y' GROUP BY aflg_flag_id, aflg_art_id, aflg_jnl_id";
        $current_user = $this->get_current_user_details();
        $client_details = $this->get_client_details();
        $client_code = $client_details->clnt_client_code;
        $client_functionality = $this->get_client_functionalities($client_details->clnt_id, $client_code);
        $user_roles = $this->validate_user_journal($jnlcode, $current_user['user_id']);

        $article_flags = $Article_flag::get_article_flags('flag_id,flag_prefix,flag_icon,flag_role,flag_color,flag_name,aflg_id,aflg_flag_id', $artcriteria);
        if (count($article_flags) > 0) {
			$roles =Roles::get_all_records('role_id,role_name,role_assigned_role');
			$roles_array =json_decode(json_encode($roles), true);
			$array_column=array_column($roles_array, 'role_assigned_role');
            if (in_array('reviewer',$array_column))
			{
				$key = array_search('reviewer',$array_column);
				$reviewer_role_id = $roles_array[$key]['role_id'] ;
                if ($client_functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                {
                    $check_revwr = $this->check_user_as_reviewer_version($article_id,$current_user['user_id'] );
                }
            }
			if (in_array('author', $array_column))
            {
				$article_details =Articles::get_single_record('art_artp_id','art_id ='.$article_id);
				$articletype_id=$article_details->art_artp_id;
				$key = array_search('author', $array_column);
				$author_role_id = $roles_array[$key]['role_id'] ;
				$privillaged_user = $this->has_journal_privilege($jnlcode, $current_user['user_id'], $articletype_id);
				$is_non_author = $this->is_non_author_privileged_user($article_id,$privillaged_user);
            }
			$flag_icon_selector=$client_functionality->cfty_flag_icon_selector;

            foreach ($article_flags as $flag) {
				$permitted_roles=json_decode($flag->flag_role);
				if ((count(array_intersect($permitted_roles, $user_roles['role_id'])) > 0) && ((!in_array($reviewer_role_id,$permitted_roles) && $check_revwr == FALSE) || (in_array($reviewer_role_id,$permitted_roles))) && ((!in_array($author_role_id,$permitted_roles) && $is_non_author == TRUE) || (in_array($author_role_id,$permitted_roles))))
                {
                    $new_fav_icon   =   $this->fav_icon_replace($flag->flag_icon);
                    $rtnHtml .= "<span class='{$flag->flag_prefix} fa-{$new_fav_icon}' style='color:{$flag->flag_color}' title='{$flag->flag_name}' ></span>" . "  ";
                }
            }
        }
        return $rtnHtml;
    }
    public function getArticleClassifications($selectedClassifications)
    {
        $res = [];
        $parentSetArr = array();
        $parentSetStr = '';
        if (count($selectedClassifications) > 0) {
            $term_table = (new \App\Models\Terms())->getTable();
            $classification_table = (new \App\Models\Classifications())->getTable();
            $classificationData = (implode(',', $selectedClassifications));
            $pnt_criteria = "cls_id IN ({$classificationData})"; //TASK #4943 getsortabletreedata sql injection
            $parentSet = Classifications::get_all_records('DISTINCT cls_parents_id', $pnt_criteria); //TASK #4943 getsortabletreedata sql injection
            // $pnt_criteria = "cls_id IN (?)"; //TASK #4943 getsortabletreedata sql injection
            // $parentSet = Classifications::get_all_records('DISTINCT cls_parents_id', $pnt_criteria,binding_arr:[$classificationData]); //TASK #4943 getsortabletreedata sql injection
            if (count($parentSet) > 0) {
                foreach ($parentSet as $eachSet) {
                    if (!empty($eachSet->cls_parents_id)) {
                        $parentSetArr[] = implode(',', json_decode($eachSet->cls_parents_id));
                    }
                }
                $parentSetStr = implode(',', $parentSetArr);
                if (!empty($parentSetStr)) {
                    $classificationData = $classificationData . ',' . $parentSetStr;
                }
            }
            $select = '*';
            $cls_criteria = "cls_id IN ({$classificationData})"; //TASK #4943 getsortabletreedata sql injection
            // $cls_criteria = "cls_id IN (?)"; //TASK #4943 getsortabletreedata sql injection
            $tables = array(
                'main_table' => $term_table,
                'join_table' => array(
                    $classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
                )
            );
            $classification_details = Classifications::get_results_using_joins($tables, $select, $cls_criteria, ''); //TASK #4943 getsortabletreedata sql injection
            // $classification_details = Classifications::get_results_using_joins($tables, $select, $cls_criteria, '',binding_arr:[$classificationData]); //TASK #4943 getsortabletreedata sql injection
            if (count($classification_details) > 0) {
                foreach ($classification_details as $e) {
                    $this->addToArr($res, $e, false);
                }
            }
        }
        return $res;
    }

    public function fetch_privileged_users_involved_ina_article($article_id,$artp_id,$journal_id) {
        $this->current_user = $this->get_current_user_details();
        $to_users               =   array();
        $Roles = new \App\Models\Roles();
        $roles_table = ($Roles)->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $generic_table = (new \App\Models\Generic_flows())->getTable();
        $user_table = (new \App\Models\User())->getTable();
        $User_to_journals = new \App\Models\User_to_journals();
        $User_to_journals_table = (new \App\Models\User_to_journals())->getTable();
        //select only privileged users involved in article
        $privileged_roles = $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
        $privileged_role_sql    =   'SELECT GROUP_CONCAT(CONCAT("\'", role_id, "\'")) as role_ids FROM '.$roles_table.' WHERE role_assigned_role IN ("' .implode('","', $privileged_roles) . '")';
        $privileged_role_res    =   $Roles::get_records_by_raw_query($privileged_role_sql);
        $where_retire = '';
        if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
        {
        $user_retired_roles_sql = 'select usrj_role_id,group_concat(DISTINCT usrj_usr_id) as user_ids  from '.$User_to_journals_table.' where usrj_jnl_id= '.$journal_id.' and usrj_role_retired= "y" and usrj_artp_id= '.$artp_id.' group by usrj_role_id';
        $user_journal_retired_roles = $User_to_journals::get_records_by_raw_query($user_retired_roles_sql);
        if(!empty($user_journal_retired_roles) && $user_journal_retired_roles != NULL)
        {
        $where_retire = ' AND (CASE';
        foreach($user_journal_retired_roles as $each_roles)
        {
            $where_retire .= ' WHEN r.role_id ='.$each_roles->usrj_role_id.' AND af.aflw_status != "a" THEN af.aflw_usr_id NOT IN ('.$each_roles->user_ids.' )';
        }
        $where_retire .= ' ELSE TRUE END )';
        }
        }
        if($privileged_role_res[0]->role_ids != '') {
            $usrs_sql   =   'SELECT
                                u.usr_id,u.usr_email,group_concat(DISTINCT r.role_name SEPARATOR \', \') as roles,CONCAT( IF( u.usr_title IS NULL OR u.usr_title = "", " ", CONCAT( UPPER(SUBSTR(u.usr_title, 1, 1)), LOWER(SUBSTR(u.usr_title, 2)) ) )," ", u.usr_first_name, IF(u.usr_middle_name IS NULL or u.usr_middle_name="", " ", CONCAT(" ",u.usr_middle_name," ")), u.usr_last_name) as user_name, jw.jwf_role_id as role_id 
                              FROM
                                '.$article_flow_table .' af
                              JOIN
                                '.$generic_table.' jw
                              ON
                                (af.`aflw_jwf_id` = jw.jwf_id)
                              JOIN
                                '.$roles_table.' r
                              ON
                                (jw.jwf_role_id = r.role_id)
                              JOIN
                                '.$user_table.' u
                              ON (af.`aflw_usr_id` = u.usr_id)
                              WHERE
                                af.`aflw_art_id` = '.$article_id.' AND af.`aflw_usr_id` != '.$this->current_user['user_id'].' AND r.role_id IN ('.$privileged_role_res[0]->role_ids.') '
                                .$where_retire. 'GROUP BY u.usr_id';

            $to_users   = Article_flow::get_records_by_raw_query($usrs_sql);
            foreach($to_users as $key => $user){
                $is_blinded = $this->is_custom_blinded($user->role_id, $article_id, artp:$artp_id, jnl:$journal_id, blinded_user:$user->usr_id);
                if($is_blinded){
                    $to_users[$key]->user_name = $is_blinded;
                }
            }
        }
        return $to_users;
    }

    // get the current status of article
		public function get_current_status($article_details,$article_privilages,$result_art_status_show =FALSE,$role_id='')
		{
            $article_id = $article_details->art_id;
            $article_curr_status = '';
            $result_art_status =array();
			if ($article_details->art_delete_status == 'w')
			{
				$article_curr_status = customTrans('viewarticle.article_withdraw_status');
			}
			elseif ($article_details->art_delete_status == 'h' && $article_privilages['author'] == FALSE && $article_privilages['reviewer'] == FALSE)
			{
				/*$core_role = '';
				if (isset($this->current_user['jnl_user_role']) && isset($this->jnl_data->jnl_journal_code))
				{
					$logged_user_role = $this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code];
					$core_role = $logged_user_role['core_role'];
				}*/
				$hold_status = $this->set_hold_status($article_privilages,$article_details);
				$article_curr_status = $hold_status;
			}
			elseif ($article_details->art_status == "t")
			{
				$article_curr_status = 'Transfer';
			}
            elseif($article_details->jwf_stage_type=="transit" && $article_details->aflw_status=="c" && $article_details->aflw_jwf_id != NULL)
            {
                $article_curr_status = 'Transfer Completed';
            }
			else
			{

				$limit = 'order by aflw_id desc limit 0,1';
				$status_arr = array(
					'a',
					'i',
					'u',
					'w',
					'p');
				$select_fields = 'jwf_status_name as article_current_status,art_status,art_stub,jwf_stage_type,GROUP_CONCAT(jwf_stage_type,"/",aflw_status) AS article_status';
				if ($article_privilages['privilaged'] == TRUE && ($article_privilages['reviewer'] == FALSE || ($article_privilages['reviewer'] ==TRUE && $article_privilages['user_allocated']==TRUE)) && $article_privilages['author'] == FALSE)
				{
					$limit = '';
					$select_fields = 'GROUP_CONCAT(jwf_stage_name) as article_current_status,art_status,art_stub,jwf_stage_type,aflw_status,GROUP_CONCAT(jwf_stage_type,"/",aflw_status) AS article_status';
				}
				else
				{
					//Customization #2472 --Need to implement "temporary status name" in every article listing section for non-privileged user
					$select_fields = 'CASE WHEN ((`jwf_temporary_status_name` IS NOT NULL AND `jwf_temporary_status_name` != \'\') and ( aflw_status IN (\'a\',\'i\',\'u\',\'w\',\'p\'))) THEN `jwf_temporary_status_name` ELSE `jwf_status_name` END AS article_current_status,art_status,art_stub,jwf_stage_type,aflw_status,GROUP_CONCAT(jwf_stage_type,"/",aflw_status) AS article_status';
				}
				$stage_condition='';
				if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
				{
					$current_role_status = $this->check_user_production_status($article_id,$this->current_user['user_id']);
					if($current_role_status != "both")
					{
						if($current_role_status == 'review_only')
						{
							$act_stage = $this->get_production_stages_keys(NULL,TRUE);
							if($role_id!='' && !empty($act_stage))
							{
								$condition="role_id={$role_id}";
                                $roledata=Roles::get_single_record('role_id,role_name,role_assigned_role',$condition);
                                $active_role_id = $roledata->role_id;
                                $core_role=$roledata->role_assigned_role;
								if($core_role == 'author')
								{
									if(!in_array('pro_revision',$act_stage))
									{
										array_push($act_stage,'pro_revision');
									}
									if(!in_array('proofreading',$act_stage))
									{
										array_push($act_stage,'proofreading');
									}
								}
							}
							$stage_condition=" and jwf_stage_type  in ('" . implode("','", $act_stage) . "')";
							$status_tat=" OR (jwf_stage_type IN('reject','production') AND aflw_status = 'c')";
						}
						else if($current_role_status == 'production_only')
						{
							$act_stage = $this->get_production_stages_keys();
							$stage_condition=" and jwf_stage_type  in ('" . implode("','", $act_stage) . "')";
							$status_tat=" OR (jwf_stage_type IN('reject','publish','aop_publish') AND aflw_status = 'c')";
						}
						else
						{
							$status_tat=" OR (jwf_stage_type IN('reject','publish','aop_publish') AND aflw_status = 'c')";
						}
					}
					else
					{
						$status_tat=" OR (jwf_stage_type IN('reject','publish','aop_publish') AND aflw_status = 'c')";
					}
				}
				else
					$status_tat=" OR (jwf_stage_type IN('reject','production') AND aflw_status = 'c')";


				$art_cur_status_sql = "select " . $select_fields . " from  rvw_article_flow,rvw_journal_workflows,rvw_articles  where jwf_id = aflw_jwf_id ".$stage_condition." and aflw_art_id = art_id  and aflw_art_id = (select IF((select count(b.art_id) from rvw_articles b where Find_in_set(a.art_id,b.art_pre_all_ids)) >0,(select max(b.art_id) from rvw_articles b where Find_in_set(a.art_id,b.art_pre_all_ids)),a.art_id) as current_art_id from rvw_articles a where a.art_id = " . $article_id . ") and aflw_parent_flow_id IS NULL and ( aflw_status IN ('u','a','w','p','i') ".$status_tat.") and IF(jwf_stage_type = 'review' and aflw_stage_min_users <= (select count(*) from rvw_article_flow af where aflw_id = af.aflw_parent_flow_id and af.aflw_status = 'c'),FALSE,TRUE) " . $limit;
                $result_art_status = Articles::get_records_by_raw_query($art_cur_status_sql);
				//echo $art_cur_status_sql; die;

				$article_curr_status = '';
				if (count($result_art_status) > 0)
				{
					if ($result_art_status[0]->art_status == 'n' && $result_art_status[0]->art_stub == 'y')
						$article_curr_status = $result_art_status[0]->article_current_status . ' in progress';
					else
					{
						$article_curr_status = $result_art_status[0]->article_current_status;
                        
						/* Task #225  JPR-447
						  Rescind a paper from production to enable licence form to be completed after author requesting changes */
						//starts #225
						if ($result_art_status[0]->article_current_status == 'Payment' && $result_art_status[0]->art_status == 'a')
						{
                            $Payment_order = new \App\Models\Payment_order();
							$payment_status = $Payment_order::get_single_record('pmt_transaction_status','pmt_ord_art_id='.$article_id);
							//check payment cancelled or not in current stage

							if (isset($payment_status->pmt_transaction_status) && isset($result_art_status[0]->art_status) && isset($result_art_status[0]->art_stub) && $payment_status->pmt_transaction_status == 'CL' && $result_art_status[0]->art_status == 'a' && $result_art_status[0]->art_stub == 'n')
								$article_curr_status = '<b>'.$result_art_status[0]->article_current_status . ' cancelled</b>';
						}
                        
                        if($result_art_status[0]->aflw_status == 'c'|| strrpos($result_art_status[0]->article_status,"/c") > 0)
						{
                            if($result_art_status[0]->jwf_stage_type == "publish" || $result_art_status[0]->jwf_stage_type == "aop_publish" || strrpos($result_art_status[0]->article_status,"publish") > 0)
                            {
                                if($article_privilages['privilaged'] == TRUE && ($article_privilages['reviewer'] == FALSE || ($article_privilages['reviewer'] ==TRUE && $article_privilages['user_allocated']==TRUE)) && $article_privilages['author'] == FALSE)
                                {
                                $curr_status=explode(',',$article_curr_status);
                                $stage_name_complete=''; $stage_name_notcomplete=''; $stage_notcomplete=array();
                                $article_status = $result_art_status[0]->article_status;
                                $status_arr=explode(',',$article_status);
                                if(count($status_arr)>0)
                                {
                                    $article_curr_status='';
                                    for($i=0; $i<count($status_arr); $i++)
                                    {

                                        $status=explode('/',$status_arr[$i]);
                                        if(isset($status[1]) && isset($curr_status[$i]))
                                        {
                                        if($status[1]=="c")
                                        {
                                            $stage_name_complete.=($stage_name_complete!='')?', <b>'.$curr_status[$i].'</b>':'<b>'.$curr_status[$i].'</b>';
                                        }
                                        else
                                        {
                                            array_push($stage_notcomplete,$curr_status[$i]);
                                            $stage_name_notcomplete.=($stage_name_notcomplete!='')?', <b>'.$curr_status[$i].'</b>':'<b>'.$curr_status[$i].'</b>';
                                        }
                                        }
                                    }
                                    if($stage_name_complete!='')
                                    $article_curr_status =$stage_name_complete.'<b> completed</b>';
                                    if($stage_name_notcomplete!='')
                                    {
                                        if(count($stage_notcomplete)>1)
                                        {
                                            $strpos = strrpos($stage_name_notcomplete,",");
                                            $stage_name_notcomplete=substr_replace($stage_name_notcomplete,"<b>, and </b>", $strpos, 1);
                                        }
                                        $article_curr_status .=' | Stages being in progress : '.$stage_name_notcomplete.'.';
                                    }
                                }
                                }
                            }
                            else
                            {
                                $article_curr_status =  '<b>'.$result_art_status[0]->article_current_status .' completed</b>';
                            }
						}
					}
				}
			}
            //die;
			if($result_art_status_show ==  TRUE)
			{
				$article_curr_stat=array();
				$article_curr_stat['status']=$article_curr_status;
				$article_curr_stat['result_art_status']=$result_art_status;
				return $article_curr_stat;
			}
			else
			return $article_curr_status;
		}

        public function set_hold_status($article_privilage,$article_details,$checkflag=false)
		{
            $this->current_user = $this->get_current_user_details();
			//$this->journal_code //if journal code wiil be null for my task in that case get journal code from article type , paass journal id and then get journal code
			$reason_text = FALSE;
			//$article_privilage = $this->set_user_privilage($article_details->art_id,$artp_id,$is_author,$is_reviewer);
			if($article_privilage['privilaged'] == TRUE)
			{
                 $Roles = new \App\Models\Roles();
				/* Roles assigned to current user in the article type */
				$all_user_roles = $this->validate_user_journal($article_details->jnl_journal_code, $this->current_user['user_id'], $article_details->art_artp_id);
				$all_roles = $Roles::get_all_records('role_id,role_name,role_assigned_role');
				/* Roles assigned to this article */
                $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
                /* Roles assigned to this article */
                $user_array = array();
                $array_data['user_roles']=$all_user_roles;
                $array_data['article_id']=$article_details->art_id;
                $array_data['all_roles']=$all_roles;
                $array_data['article_privilages']=$article_privilage;
				$user_roles = $this->get_article_user_roles($array_data);
				$reason_text=FALSE;
				if(in_array('journal_admin',$user_roles['assigned_roles']) || in_array('staff',$user_roles['assigned_roles']))
				{
                    $reason_text = TRUE;
					//$reason_text = ' <a class = "hold-article-popover " id="hold-id_'.$article_id.'" data-toggle="popover"  data-placement="top" ><i class="fa fa-info-circle" aria-hidden="true"></i></a>';

				}
			}
           if($checkflag==TRUE)
           {
			$article_curr_status =$reason_text;
           }
           else
           {
            $article_curr_status=customTrans('viewarticle.article_hold_status');
           }
			return $article_curr_status;
		}
public function formatted_user_unavailability_dates($user_id,$tat_date,$jnl_id)
{
        $formated_reason=array();
        $formated_reason['reason']='';
        $formated_reason['date_msg']='';
        $users_unavailability = $this->get_users_unavailability($user_id, $tat_date);
        $date_format =  $this->get_platform_date_format($jnl_id);
        if ($users_unavailability != null)
        {
            $availability = FALSE;
            if ($users_unavailability[0]->unavail_start_date != $users_unavailability[0]->unavail_end_date)
            {
                //echo date_format(date_create($users_unavailability[0]->unavail_start_date),$date_format);exit;

                $date_bwn = ' between ' . date($date_format, strtotime($users_unavailability[0]->unavail_start_date)) . ' and ' . date($date_format, strtotime($users_unavailability[0]->unavail_end_date));

            }
            else
            {
                $date_bwn = ' on ' . date($date_format, strtotime($users_unavailability[0]->unavail_start_date));
            }
            if($date_bwn!='')
            {
            $formated_reason['date_msg']=$date_bwn;
             $formated_reason['reason']=$users_unavailability[0]->unavail_reason;

            }
        }

        return $formated_reason;

}

        public function check_user_required($type, $id, $edit_user, $removed_list_role_id)
        {

            $role_user_count = Article_flow::check_user_required_used_article($type, $id, $edit_user, $removed_list_role_id);
            
          if (!empty($role_user_count) && isset($role_user_count['status']) && $role_user_count['status']) {
               
                return array(
                    'status' => true,
                    'reason' => $role_user_count['reason']
                );
            } else {
                $role_user_author_count = Article_flow::check_user_required_used_author($type, $id, $edit_user, $removed_list_role_id);
                if (!empty($role_user_author_count) && isset($role_user_author_count['status']) && $role_user_author_count['status']) {
                    if ($type === 'a') {
                          $reason_suffix = customTrans(':article type');
                    } else {
                        $reason_suffix = customTrans(':journal');
                       
                    }
                    return array(
                        'status' => true,
                        'reason' => $role_user_author_count['reason'] . ' ' . $reason_suffix
                    );
                } else {
                    
                    $role_user_asign_count = User_articles::check_role_assigned_article($type, $id, $edit_user,null);
                       if (!empty($role_user_asign_count) && isset($role_user_asign_count['status']) && $role_user_asign_count['status']) {
                        if ($type === 'a') {
                           $reason_suffix = customTrans(':article type');
                        } else {
                            $reason_suffix = customTrans(':journal');
                        }
                        return array(
                            'status' => true,
                            'reason' => $role_user_asign_count['reason']
                        );
                    }
                }
            }
            
            return ['status' => false];
        }
    public function change_article_pdf_status($article_id, $current_user)
    {
        $genereate_pdf_changed = FALSE;
        $ArticlePdfTable = (new \App\Models\Article_pdf())->getTable();
        $pdf_sql = 'SELECT pdf_id FROM ' . $ArticlePdfTable . ' WHERE pdf_art_id =' . $article_id . ' ORDER BY pdf_id DESC LIMIT 1';
        $pdf_det = Article_pdf::get_records_by_raw_query($pdf_sql);
        $art_pdf_det = (isset($pdf_det[0]) && !empty($pdf_det[0])) ? $pdf_det[0] : array();
        if (!empty($art_pdf_det)) {
            Article_pdf::update_record(array('pdf_show_status' => 'n'), 'pdf_id =' . $art_pdf_det->pdf_id, $current_user);
            $genereate_pdf_changed = TRUE;
        }
        return $genereate_pdf_changed;
    }

/* #625 Queue system for shortlisted reviewers auto invitation function */
public function auto_invite_reviewer($array_rvwer_details,$cron_flag = FALSE)
{

    $Articles=new \App\Models\Articles;
    $Article_flow=new \App\Models\Article_flow;
    $Article_reviewers=new \App\Models\Article_reviewers();
    $Generic_flows=new \App\Models\Generic_flows();
    $Roles=new \App\Models\Roles();
    $User=new \App\Models\User();
    $Authors=new \App\Models\Authors();
    $Article_types=new \App\Models\Article_types();
    $User_to_journals=new \App\Models\User_to_journals();
    $Reject_reasons=new \App\Models\Reject_reasons();
    $Roles=new \App\Models\Roles();
    $User_articles=new \App\Models\User_articles();
    $Article_versions_reviewers=new \App\Models\Article_versions_reviewers();
    $Article_reviewers=new \App\Models\Article_reviewers();
    $User=new \App\Models\User();
    $User_affiliation=new \App\Models\User_affiliations();
    $Article_reviewer_suggest=new \App\Models\Article_reviewer_suggest();
    $Stage_email_templates=new \App\Models\Stage_email_templates();
    $Email_templates=new \App\Models\Email_templates();
    $Journals=new \App\Models\Journals();
    $Email_send_log=new \App\Models\Email_send_log();

    $Article_flow_alternativereviewer_priorityorder=new \App\Models\Article_flow_alternativereviewer_priorityorder();
    $Article_user_alternativereviewer_priorityorder=new \App\Models\Article_user_alternativereviewer_priorityorder();
    $Article_autoinvitation_emails=new \App\Models\Article_autoinvitation_emails();
    $Article_alternativereviewer_priority_settings=new \App\Models\Article_alternativereviewer_priority_settings();
    $Article_notification_emails=new \App\Models\Article_notification_emails();
    $Email_attachments=new \App\Models\Email_attachments();
    $Article_type_advance_options = new \App\Models\Article_type_advance_options;
    $jnl_code = isset($array_rvwer_details['jnl_code'])?$array_rvwer_details['jnl_code']:'';
    $jnl_id = isset($array_rvwer_details['jnl_id'])?$array_rvwer_details['jnl_id']:'';
    $core_role = isset($array_rvwer_details['core_role'])?$array_rvwer_details['core_role']:'';

    $user_data = array('user_id'=>0,'proxy_user_id'=>0);

    if($cron_flag == FALSE)
    {
        $this->current_user =$this->get_current_user_details();
        $current_user = $this->current_user;
    }
    else
    {
        $current_user = $user_data ;
    }

    $document_module = FALSE;
    $enable_article_priority_reviwer=FALSE;

        if(isset($array_rvwer_details['user_data']) && !empty($array_rvwer_details['user_data']))
        {
            $current_user = $array_rvwer_details['user_data'];
        }

        if(!isset($jnl_data) && isset($array_rvwer_details['jnl_data']) && !empty($array_rvwer_details['jnl_data']))
        {
            $jnl_data = $array_rvwer_details['jnl_data'];

        }
        if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))
        {
                $enable_article_priority_reviwer=TRUE;
        }
        if (isset($this->current_client->modules->mdl_review_for_doc) && $this->current_client->modules->mdl_review_for_doc == 'y')
        {
            $document_module = TRUE;
        }
        $alternatervwer=array();
        if (isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y')){

            $articleflow_table = (new \App\Models\Article_flow())->getTable();
            $alternative_user_priority_order_table = (new \App\Models\Article_user_alternativereviewer_priorityorder())->getTable();
        /* Check Alternate reviewer exist in   invited User based priority assign  */

        $assg_tables_user = array(
            'main_table' => $articleflow_table,
            'join_table' => array(
                $alternative_user_priority_order_table => array($articleflow_table . '.aflw_id', $alternative_user_priority_order_table  . '.auap_aflw_id')
            )
        );
       /* $assg_tables_user = array(
        'main_table' => Article_flow::$tbl_name . ' as af ',
        'join_table' => array(
            Article_user_alternativereviewer_priorityorder::$tbl_name => 'auap_aflw_id=af.aflw_id'
    ));
       */

//
        $selectrewer='auap_id as priority_id,auap_alternate_usr_id as user_id,auap_number';
        $criteria="auap_usr_id={$current_user['user_id']} AND auap_art_id={$array_rvwer_details['article_id']} AND auap_parent_flow_id={$array_rvwer_details['parentflow_id']} AND aflw_status!='i'";
        /*$criteria=array('auap_usr_id'=>$current_user['user_id'],'auap_art_id'=>$array_rvwer_details['article_id'],'auap_parent_flow_id'=>$array_rvwer_details['parentflow_id'],"aflw_status !="=>'i');
        /* Get data in Priority Setting check user multple auto invitation on or off*/
            $priority_settings_user=$Article_alternativereviewer_priority_settings::get_single_record('aaps_multiple_invitation_status	as multiple_invitation ',"aaps_usr_id={$current_user['user_id']} AND aaps_art_id={$array_rvwer_details['article_id']} AND aaps_parent_flow_id={$array_rvwer_details['parentflow_id']}");
        if(isset($priority_settings_user->multiple_invitation)&&$priority_settings_user->multiple_invitation == 'y')
        $limit="";
        else
        $limit="1";
        $alternatervwer= $Article_flow::get_results_using_joins($assg_tables_user, $selectrewer, $criteria,'all','auap_id',$limit);

        $col_priority_email='aae_auap_id';
             }

        if($alternatervwer->isEmpty() && $enable_article_priority_reviwer == TRUE)
        {
            $articleflow_table = (new \App\Models\Article_flow())->getTable();
                $alternative_priority_order_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();

                                $assg_tables_flow = array(
                                    'main_table' => $articleflow_table,
                                    'join_table' => array(
                                        $alternative_priority_order_table => array($articleflow_table . '.aflw_id', $alternative_priority_order_table . '.afap_aflw_id')
                                    )
                                );

        $selectrewer='afap_id as priority_id,afap_usr_id as user_id,afap_number';
        $criteria="afap_art_id={$array_rvwer_details['article_id']}  AND afap_parent_flow_id={$array_rvwer_details['parentflow_id']} AND aflw_status!='i'";

        $priority_settings_user=$Article_alternativereviewer_priority_settings::get_single_record('aaps_multiple_invitation_status	as multiple_invitation ',"aaps_usr_id=0 AND aaps_art_id={$array_rvwer_details['article_id']} AND aaps_parent_flow_id={$array_rvwer_details['parentflow_id']}");
        if(isset($priority_settings_user->multiple_invitation)&&$priority_settings_user->multiple_invitation == 'y')
        $limit="";
        else
        $limit="1";
        $alternatervwer=$Article_flow::get_results_using_joins($assg_tables_flow,$selectrewer, $criteria,'all','afap_number',$limit);

        $col_priority_email='aae_afap_id';
        }
        if(!empty($alternatervwer))
        {
            $rv_cnt = 0;
            foreach($alternatervwer as $reviwer)
            {
                $user_id=$reviwer->user_id;
                $priority_id=$reviwer->priority_id;
                $article_reviewer_data = array();

                $current_stage_id=$array_rvwer_details['parentflow_id'];
                $array_rvwer_details['artflow_id']=$array_rvwer_details['article_id'];

                $aflw_deeplink_token = Str::random(8);;


                $current_flow = $Article_flow::get_single_record('aflw_parent_flow_id',"aflw_id={$current_stage_id}");
                $current_stage_id = ($current_flow->aflw_parent_flow_id != NULL) ? $current_flow->aflw_parent_flow_id : $current_stage_id;

                $condition ="aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id}";

                $current_aflw_id_rec = $Article_flow::get_single_record('aflw_id,aflw_art_id,aflw_deeplink_token', $condition,NULL,'','aflw_id DESC');
                $current_aflw_id = $current_aflw_id_rec->aflw_id;

                $data['aflw_status'] = 'i';
                //$updateReviewerverion = false;

                /* 1.1 get users who previously declined invititation
                *     in the current flow */
                $decline_data = $Article_flow::get_single_record('*',"aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_status='d'");
                $today = date('Y-m-d H:i:s', time());
                $due_date = new \DateTime($today);

                $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
                $article_details = $Articles::get_article_details($select,"aflw_id={$current_aflw_id}");

                $article_details = $article_details[0];
                $article_id = $article_details->art_id;

                // $due_date = $due_date->modify('+' . $article_details->jwf_tat_accept . ' days');
                // $due_date = $due_date->format('Y-m-d H:i:s');
                // $data['aflw_due_date'] = $due_date;
                $data['aflw_due_date'] = $this->get_due_date_for_article($article_id, $article_details->jwf_tat_accept);


                $tmpl_condition ="aae_usr_id={$user_id} AND aae_art_id={$article_id} AND aae_aflw_id={$current_aflw_id_rec->aflw_id} AND {$col_priority_email}={$priority_id}";
                $template=$Article_autoinvitation_emails::get_single_record('*', $tmpl_condition);
                /* If a user doesn't save the alternative reviewers invitation email, a default email should be sent instead. start */
                if ($template == NULL) {
                    $stage_email_templates = new \App\Models\Stage_email_templates();
                    $template = $stage_email_templates::get_stage_email_tmpl_to_trigger('*', "stage_etmp_stage_type='{$article_details->jwf_stage_type}' AND setr_jwf_id={$article_details->jwf_id} AND stage_etmp_action='assigned'");
                    $template = $template[0];
                    if ($template != NULL) {
                        if (isset($reviwer->afap_number)) {
                            $afap_id = $reviwer->priority_id;
                            $auap_id = 0;
                        } else {
                            $afap_id = 0;
                            $auap_id = $reviwer->priority_id;
                        }
                        $reply_to = $this->get_reply_to_email($jnl_id);
                        $insert_data = array(
                            'aae_usr_id' => $user_id,
                            'aae_stage_etmp_id' => $template->stage_etmp_id,
                            'aae_art_id' => $article_id,
                            'aae_aflw_id' => $current_aflw_id_rec->aflw_id,
                            'aae_auap_id' => $auap_id,
                            'aae_afap_id' => $afap_id,
                            'aae_template_name' => $template->stage_etmp_name,
                            'aae_action' => $template->stage_etmp_action,
                            'aae_to' => $template->stage_etmp_to,
                            'aae_cc' => $template->stage_etmp_cc,
                            'aae_bcc' => $template->stage_etmp_cc,
                            'aae_subject' => $template->stage_etmp_subject,
                            'aae_content' => $template->stage_etmp_content,
                            'aae_cust_to' => $template->stage_etmp_cust_to,
                            'aae_cust_cc' => $template->stage_etmp_cust_cc,
                            'aae_cust_bcc' => $template->stage_etmp_cust_bcc,
                            'aae_reply_to' => $reply_to,
                            'ane_updated_date' => $today,
                            'ane_setr_id' => $template->setr_id
                        );
                        $auto_invied_id = $Article_autoinvitation_emails::insert_record($insert_data,$current_user);
                        if ($auto_invied_id == TRUE)
                        {
                            $tmpl_condition ="aae_usr_id={$user_id} AND aae_art_id={$article_id} AND aae_aflw_id={$current_aflw_id_rec->aflw_id} AND {$col_priority_email}={$priority_id}";
                            $template=$Article_autoinvitation_emails::get_single_record('*', $tmpl_condition);
                        }
                    }
                }
                /* If a user doesn't save the alternative reviewers invitation email, a default email should be sent instead. End */
                $allow_reveiwer=$this->check_allow_reveiwer_invitation($array_rvwer_details['article_id'],$user_id);
                if ($template != NULL && $allow_reveiwer== TRUE)
                {
                    $Article_pdf=new \App\Models\Article_pdf;

                    /* 1.1.1 if $decline_data found */
                    if ($decline_data!=NULL)
                    {

                        $invite_user_data = $Article_flow::get_single_record('*',"aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_status='u'");

                        // Check uninvite user  record already exist
                        if (!empty($invite_user_data))
                        {
                            $invite_condition ="aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_status='u'";

                            $flow = $Article_flow::get_single_record('aflw_deeplink_token,aflw_art_id', $invite_condition);

                            $aflw_deeplink_token = ($flow->aflw_deeplink_token != '' ) ? $flow->aflw_deeplink_token : $aflw_deeplink_token;
                            $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                            $data['aflw_assigned_date'] = $today;
                            /* 1.1.2 else ,update status row in article flow table  */
                            $status = $Article_flow::update_record($data, $invite_condition, $user_data);
                            if($status)
                            {
                                //$updateReviewerverion = true;
                                $this->mngReviewerversion($flow->aflw_art_id,$current_stage_id,$user_id);
                            }
                            /* if the suggested user is not have reviewer role in journal or article type then add role-- start */
                            $is_sugst_usr = $Article_reviewers::get_single_record('sorw_id',"sorw_suggested_reviewer_id={$user_id} AND sorw_action='s' AND sorw_aflw_id={$current_aflw_id}");
                            if ($is_sugst_usr !== NULL)
                            {
                                $revw_role_id = $article_details->jwf_role_id;
                                $user_role_details = array(
                                    'usrj_jnl_id' => $jnl_id,
                                    'usrj_usr_id' => $user_id,
                                    'usrj_role_id' => $revw_role_id,
                                    'usrj_artp_id' => NULL,
                                );
                                $condition_user_role_details="usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id IS NULL";
                                $jnl_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);

                                if ($jnl_reviewr_record == NULL)
                                {
                                    $user_role_details['usrj_invite'] = 'n';
                                    $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                                    unset($user_role_details['usrj_invite']);
                                }
                                //user as article type reviewer
                                $condition_user_role_details="usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id ={$article_details->art_artp_id}";

                                $art_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);
                                if ($art_reviewr_record == NULL)
                                {
                                    $user_role_details['usrj_invite'] = 'n';
                                    $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                                }
                            }
                            /* add reviewer role end */
                        }
                        else
                        {
                            $revw_role_id = $article_details->jwf_role_id;
                            $user_role_details = array(
                                'usrj_jnl_id' =>$jnl_id,
                                'usrj_usr_id' => $user_id,
                                'usrj_role_id' => $revw_role_id,
                                'usrj_artp_id' => NULL,
                            );
                            $condition_user_role_details="usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id IS NULL";
                            $jnl_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);

                            if ($jnl_reviewr_record == NULL)
                            {
                                $user_role_details['usrj_invite'] = 'n';
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                                unset($user_role_details['usrj_invite']);
                            }
                            //user as article type reviewer
                            $user_role_details['usrj_artp_id'] = $article_details->art_artp_id;
                            $art_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);
                            if ($art_reviewr_record == NULL)
                            {
                                $user_role_details['usrj_invite'] = 'n';
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                            }
                            /* 1.1.1.1 use $decline_data array for new invite */
                            $new_invite = array(
                                'aflw_parent_flow_id' => $decline_data->aflw_parent_flow_id,
                                'aflw_art_id' => $decline_data->aflw_art_id,
                                'aflw_jwf_id' => $decline_data->aflw_jwf_id,
                                'aflw_usr_id' => $decline_data->aflw_usr_id,
                                'aflw_assigned_date' => $today,
                                'aflw_due_date' => $data['aflw_due_date'],
                                'aflw_status' => 'i',
                                'aflw_deeplink_token' => $aflw_deeplink_token,
                                'aflw_level' => $decline_data->aflw_level
                            );

                            /* 1.1.1.2 insert new status row and get newly inserted id */
                            $status = $Article_flow::insert_record($new_invite, $user_data);
                            if($status)
                            {
                                //$updateReviewerverion = true;
                                $this->mngReviewerversion($decline_data->aflw_art_id,$status,$decline_data->aflw_usr_id);
                            }
                            $article_details->aflw_id = $status;
                            $re_invite_users[$rv_cnt] = $decline_data->aflw_usr_id;

                            $previous_suggested_user_id = $Article_reviewers::get_single_record('sorw_suggested_user_id',"sorw_aflw_id={$decline_data->aflw_id}");
                            $article_reviewer_data ['sorw_aflw_id'] = $status;
                            $article_reviewer_data ['sorw_suggested_reviewer_id'] = $user_id;
                            $article_reviewer_data ['sorw_suggested_user_id'] = $previous_suggested_user_id->sorw_suggested_user_id;
                            $article_reviewer_data['sorw_suggested_on'] = $today;
                            $article_reviewer_data['sorw_art_id'] = $decline_data->aflw_art_id;
                            $article_reviewer_data ['sorw_invited_by'] = $current_user['user_id'];
                            $article_reviewer_data['sorw_invited_on'] = $today;
                            /* 1.1.1.2 insert article reviewers in Article_reviewers table */
                            $re_reviewer_ids[$rv_cnt]['review'] = $Article_reviewers::insert_record($article_reviewer_data, $current_user);
                            $re_reviewer_ids[$rv_cnt]['flow'] = $status;
                            $rv_cnt++;
                        }
                    }
                    else
                    {


                        $flow = $Article_flow::get_single_record('aflw_deeplink_token,aflw_art_id', $condition);

                        $aflw_deeplink_token = ($flow->aflw_deeplink_token != '' ) ? $flow->aflw_deeplink_token : $aflw_deeplink_token;

                        $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                        $data['aflw_assigned_date'] = $today;
                        /* 1.1.2 else ,update status row in article flow table  */
                        $status = $Article_flow::update_record($data, $condition, $user_data);
                        if($status)
                        {
                            //$updateReviewerverion = true;
                            $this->mngReviewerversion($flow->aflw_art_id,$current_stage_id,$user_id);
                        }
                        /* if the suggested user is not have reviewer role in journal or article type then add role-- start */
                        $is_sugst_usr = $Article_reviewers::get_single_record('sorw_id',"sorw_suggested_reviewer_id={$user_id} AND sorw_action='s' AND sorw_aflw_id={$current_aflw_id}");

                        if ($is_sugst_usr !== NULL)
                        {
                            $revw_role_id = $article_details->jwf_role_id;
                            $user_role_details = array(
                                'usrj_jnl_id' => $jnl_id,
                                'usrj_usr_id' => $user_id,
                                'usrj_role_id' => $revw_role_id,
                                'usrj_artp_id' => NULL,
                            );
                            $condition_user_role_details="usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id IS NULL";
                            $jnl_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);

                            if ($jnl_reviewr_record == NULL)
                            {
                                $user_role_details['usrj_invite'] = 'n';
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                                unset($user_role_details['usrj_invite']);
                            }
                            //user as article type reviewer
                            $condition_user_role_details="usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id ={$article_details->art_artp_id}";

                            $art_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);
                            if ($art_reviewr_record == NULL)
                            {
                                $user_role_details['usrj_invite'] = 'n';
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                            }
                        }
                        /* add reviewer role end */
                    }

                    /* 1.2 if no declined users found,update corresponding row in Article_reviewers table */
                    if ($decline_data == NULL)
                    {

                        $article_reviewer_data ['sorw_invited_by'] =$user_data['user_id'];
                        $article_reviewer_data ['sorw_invited_on'] = $today;
                        $article_reviewer_condition ="sorw_art_id={$article_id} AND sorw_suggested_reviewer_id={$user_id}";
                        $Article_reviewers::update_record($article_reviewer_data, $article_reviewer_condition, $user_data);
                    }

                    $reviewer_role = $Roles::get_single_record('role_id',"role_assigned_role='reviewer'");

                    $role_id = $reviewer_role->role_id;
                    if ($document_module == TRUE)
                    {
                        $user_role_in_journal = $User_to_journals::get_single_record('count(usrj_id) as count',"usrj_jnl_id={$jnl_id} AND usrj_artp_id IS NULL AND usrj_usr_id={$user_id} AND usrj_role_id={$role_id}");
                        if ($user_role_in_journal != NULL && $user_role_in_journal->count == 0)
                        {
                            $journal_user_data ['usrj_usr_id'] = $user_id;
                            $journal_user_data ['usrj_role_id'] = $role_id;
                            $journal_user_data['usrj_artp_id'] = NULL;
                            $journal_user_data['usrj_invite'] = 'n';
                            $journal_user_data['usrj_cpy_class_art_type'] = 'n';
                            $journal_user_data['usrj_jnl_id'] = $jnl_id;
                            $User_to_journals::insert_record($journal_user_data, $user_data);
                        }
                        if (isset($article_details->art_artp_id))
                        {
                            $user_role_cnt_in_artp = $User_to_journals::get_single_record('count(usrj_id) as cnt',"usrj_jnl_id={$jnl_id} AND usrj_artp_id={$article_details->art_artp_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$role_id}");
                            if ($user_role_cnt_in_artp != NULL && $user_role_cnt_in_artp->cnt == 0)
                            {
                                $atp_user_data['usrj_jnl_id']=$jnl_id;
                                $atp_user_data['usrj_artp_id']=$article_details->art_artp_id;
                                $atp_user_data['usrj_usr_id']=$user_id;
                                $atp_user_data['usrj_role_id']=$role_id;
                                $atp_user_data['usrj_invite'] = 'n';
                                $atp_user_data['usrj_cpy_class_art_type'] = 'n';
                                $User_to_journals::insert_record($atp_user_data, $user_data);
                            }
                        }
                    }
                    $Article_user_alternativereviewer_priorityorder::delete_records("auap_alternate_usr_id={$user_id} AND auap_art_id={$article_id}");
                    $Article_flow_alternativereviewer_priorityorder::delete_records("afap_usr_id={$user_id} AND afap_art_id={$article_id}");
                    $Article_autoinvitation_emails::delete_records("aae_usr_id={$user_id} AND aae_art_id={$article_id}");

                    $attachments = $files_attached = array();
                    $article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to',"ane_stage_etmp_id={$template->aae_stage_etmp_id} AND ane_art_id={$article_id} AND ane_aflw_id ={$article_details->aflw_id}");
                    if(isset($article_notification->ane_id))
                    {
                        $email_attachments	=	$this->get_invite_email_attachments($article_id,$article_notification->ane_id,FALSE);
                        if(!empty($email_attachments))
                        {
                            $attachments = $email_attachments['attachments'];
                            $files_attached = $email_attachments['files_attached'];
                        }

                    }

                    $email_data = new stdClass;
                    $email_data->article_id = $article_id;
                    if (!empty($files_attached))
                    {
                        $email_data->attachments = $attachments;
                        $email_data->files_attached = $files_attached;
                    }
                    $email_data->user_id = $user_id;
                    $email_data->jnl_journal_code = $jnl_code;
                    $email_data->artp_id = $article_details->art_artp_id;
                    $email_data->jnl_id = $jnl_id;
                    $email_data->aflw_id = $article_details->aflw_id;
                    $send_mail_to = '';
                    $send_mail_to_usr_ids = '';
                    $reply_to = $this->get_reply_to_email($jnl_id);

                    if (isset($reply_to) && $reply_to != '')
                        $email_data->reply_to = $reply_to;
                    $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                    $res = $User::get_single_record('usr_email, usr_status, usr_deeplink_token', "usr_id={$user_id}");

                    if ($res)
                    {
                        $send_mail_to = $res->usr_email;
                        $send_mail_to_usr_ids = $user_id;
                        if ($res->usr_status == 'w')
                        {
                            if (!empty($res->usr_deeplink_token))
                                $aflw_deeplink_token = $res->usr_deeplink_token;
                            else
                            {
                                $Users::update_record(array(
                                    'usr_deeplink_token' => $aflw_deeplink_token),"usr_id={$user_id}" );
                            }
                        }
                    }
                    $link =URL::to('/').'/'. $this->current_client->platform_type.'/'.  $jnl_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&user_role_id=' . $role_id . '&article_flow_id=' . $article_details->aflw_id);

                    $accept_link = URL::to('/').'/'. $this->current_client->platform_type.'/'.  $jnl_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id);
                                    //#581 hide terms & conditions popup for reviewers on decline invitation
                    $reject_link = URL::to('/').'/'. $this->current_client->platform_type.'/'.  $jnl_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide');


                    if ($template->aae_to != 'User' && $template->aae_to != 'Custom')
                    {
                        $cfty_retire_role = FALSE;
                        if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
                        {
                            $cfty_retire_role = TRUE;
                        }
                        $send_mail_to_detail = $this->send_email_to($template->aae_to,  $jnl_code, $article_details->art_artp_id, $article_id,$cfty_retire_role);
                        $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
                        $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
                        $send_mail_to = $send_mail_to_detail['email_ids'];
                        $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];

                    }

                        $subject = $template->aae_subject;
                        $content = $template->aae_content;

                        //get cc, bcc, reply_to from preview
                        $template->stage_etmp_cc = $template->stage_etmp_bcc = '';
                        $template->stage_etmp_cust_cc = $template->stage_etmp_cust_bcc = '';
                        $template->stage_etmp_cust_to = '';
                        if (!empty($template->aae_cc))
                        {
                            $template->stage_etmp_cc = $template->aae_cc;

                            if (in_array('Custom',json_decode($template->aae_cc)))
                                $template->stage_etmp_cust_cc = trim($template->aae_cust_cc);
                        }
                        if (!empty($template->aae_bcc))
                        {
                            $template->stage_etmp_bcc = $template->aae_bcc;
                            if (in_array('Custom', json_decode($template->aae_bcc)))
                                $template->stage_etmp_cust_bcc = trim( $template->aae_cust_bcc);
                        }
                        $email_data->reply_to =$template->aae_reply_to;

                        if ($decline_data!=NULL)
                        {
                            preg_match_all('/##([^##]*)##/', $template->aae_content, $matches);
                            $keys = $matches[1];
                            if (in_array('CONFIRMATION_URL', $keys))
                                $content = preg_replace('/<a id="confirmation_url_tag_reinvite".*>.*<\/a>/', '<a id="confirmation_url_tag_reinvite" href="' . $link . '">' . $link . '</a>', $content);
                            if (in_array('DIRECT_ACCEPT', $keys))
                                $content = preg_replace('/<a id="direct_accept_tag_reinvite".*>.*<\/a>/', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' . 'Accept' . '</a>', $content);
                            if (in_array('DIRECT_REJECT', $keys))
                                $content = preg_replace('/<a id="direct_reject_tag_reinvite".*>.*<\/a>/', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '">' . 'Reject' . '</a>', $content);
                        }

                        //bug with link tags DIRECT_ACCEPT, DIRECT_REJECT, CONFIRMATION_URL
                        if (!empty($template->aae_to) && $template->aae_to == 'User')
                        {
                            preg_match_all('/##([^##]*)##/', $template->aae_content, $matches);
                            $keys = $matches[1];
                            if (in_array('CONFIRMATION_URL', $keys))
                            {
                                $content = str_ireplace('##CONFIRMATION_URL##', '<a id="confirmation_url_tag_reinvite" href="' . $link . '">' . $link . '</a>', $content);
                            }

                            if (in_array('DIRECT_ACCEPT', $keys))
                            {
                                $content = str_ireplace('##DIRECT_ACCEPT##', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' .((customTrans('client_lang.accept_link_text') != '') ? customTrans('client_lang.accept_link_text') : 'Accept'). '</a>', $content);
                            }

                            if (in_array('DIRECT_REJECT', $keys))
                            {
                                $content = str_ireplace('##DIRECT_REJECT##', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '" >' .  ((customTrans('client_lang.reject_link_text') != '') ? customTrans('client_lang.reject_link_text') : 'Reject'). '</a>', $content);
                            }
                        }
                        else
                        {
                            $content = str_ireplace('##CONFIRMATION_URL##', '', $content);
                            $content = str_ireplace('##DIRECT_ACCEPT##', '', $content);
                            $content = str_ireplace('##DIRECT_REJECT##', '', $content);
                        }
                        $email_data->subject = $subject;
                        $email_data->body = $content;
                        $email_data->email_templates_config = $this->email_templates_config();
                        if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                            $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];

                        if ($send_mail_to != '' || $template->aae_to == 'Custom')
                        {

                            $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$article_details->art_artp_id}");
                            if(!empty($artp_settings))
                            {
                                $template->review_method = $template->assignments='';
                                // if(isset($core_role) )
                                // {
                                //     $core_role = $core_role;
                                // }
                                // else
                                if(isset($article_details->jwf_role_id))
                                {
                                    $roles = $Roles::get_single_record('role_assigned_role',"role_id={$article_details->jwf_role_id}");
                                    $core_role = $roles->role_assigned_role;
                                }
                                if($core_role == 'reviewer' && (isset($template->stage_etmp_to) && ($template->stage_etmp_to == 'submit_author' || $template->stage_etmp_to == 'Author' || $template->stage_etmp_to == 'article_authors' || $template->stage_etmp_to == 'Authors')))
                                {
                                    $template->review_method = $artp_settings->atotp_review_method;
                                }
                            }
                            $template->stage_etmp_action='assigned';
                            $email_data->user_email = $send_mail_to;
                            $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
                            $email_data->core_role = $core_role;
                            $core_role_name='';
                            // $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
                            $email_data->core_role_name = $core_role_name;

                            $action_name = '';
                            if($cron_flag== TRUE)
                            {
                                $action_name = 'cron_job';
                            }
                            $email_data->name = $action_name;
                            $email_data->email_templates_config = $this->email_templates_config();
                            $email_data->join_config = $this->join_config();
                            $email_data->join_dependency_config = $this->join_dependency_config();
                            $email_data->user_role_tags = $this->user_role_tags();
                            $user_titles =$this->UserConfigdata('titles')['titles'];
                            $template->aae_content = $email_data->body= $this->generate_email_data_from_keys($email_data, $content, $current_user, $user_titles, TRUE);
                            $template->aae_subject = $email_data->subject = $this->generate_email_data_from_keys($email_data, $subject, $current_user, $user_titles, TRUE);
                            $this->send_email_notification($template, $email_data, $user_data, 'stage_etmp_');
                        }


                    $invitation_send = TRUE;
                }
            }
        }

    }


	//get single article data
    public function get_article_permitted_users($artp_id,$article_id,$roles = array())
	{
        $User_to_journals=new \App\Models\User_to_journals();
        $User=new \App\Models\User();
        $user_arr = array();
		$non_alocate_roles = array();
        $cfty_retire_role_flag = '';
        $alocate_users = $this->get_allocated_users_list(array($article_id));
		$return_arr = array(
			'user_ids' => array(),
			'user_emails' => array()
		);

		if(count($roles) > 0)
		{
			foreach ($roles as $role)
			{
				if(isset($alocate_users[$article_id][$role]))
				{
					$user_arr = array_merge($user_arr, $alocate_users[$article_id][$role]);
				}
				else
				{
                    $non_alocate_roles[] = $role;
                }
			}
			if(count($non_alocate_roles) > 0)
			{

				if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
				{
					$cfty_retire_role_flag = ' AND usrj_role_retired = \'n\' ';
				}

				$condition = ' usrj_artp_id = '.$artp_id.' AND usrj_role_id IN ('. implode(',', $non_alocate_roles).') '.$cfty_retire_role_flag;

				$non_alocate_roles_res = $User_to_journals::get_all_records('usrj_usr_id',$condition);
				$art_user_id = array_column(json_decode(json_encode($non_alocate_roles_res),TRUE), 'usrj_usr_id');

				$user_arr = array_merge($user_arr, $art_user_id);
			}

			if(count($user_arr) > 0)
			{
				$users = ' usr_id IN ('.implode(',', $user_arr).')';
				$user_emails =  $User::get_all_records('usr_email',$users);
				$art_user_emails = array_column(json_decode(json_encode($user_emails),TRUE), 'usr_email');

				$return_arr['user_ids'] = array_unique($user_arr);
				$return_arr['user_emails'] = array_unique($art_user_emails);
			}
		}

		return $return_arr;

	}
    public function check_allow_reveiwer_invitation($article_id, $user_id)
    {
        $allow_reveiwer = TRUE;

        if (isset($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer) && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
        {
            $Article_flow=new \App\Models\Article_flow;

            $user_allocate_article = $this->check_user_allocate($user_id, $article_id);
            if ($user_allocate_article == TRUE)
            {
                $allow_reveiwer = FALSE;
            }
            $select = 'aflw_usr_id  as usr_id';

            $where ="aflw_art_id={$article_id} AND jwf_stage_type='post_assessment' AND aflw_usr_id={$user_id}";


            $stage_assignment_revwr = $Article_flow::get_article_flow_details($select, $where);

            if (!empty($stage_assignment_revwr) && count($stage_assignment_revwr)>0)
            {
                $allow_reveiwer = FALSE;
            }
        }
        return $allow_reveiwer;
    }

    public function issue_management_page_count($article_id,$jnl_code)
    {
        $Issue_management = new \App\Models\Issue_management();
        $Article_generic_form_data = new \App\Models\Article_generic_form_data();
        $pages = 0;
        $final_page_count = 0;
        $issue_record=$Issue_management::get_single_record('ism_art_page_cnt',"ism_art_id={$article_id}" );
        if(isset($issue_record) && !empty($issue_record))
        {
            $final_page_count = $issue_record->ism_art_page_cnt;
        }
        // $article_detail = new stdClass();
        // $article_detail->art_id = $article_id;
        $author_desigated_files = $this->get_attach_to_author_files($article_id,FALSE);
        $pdf_pages = 0;
        if(isset($author_desigated_files) && !empty($author_desigated_files))
        {
            foreach($author_desigated_files as $file)
            {
                $path = $this->get_upload_path('uploads/'.$file->art_article_upload_path.'/production/'.$file->paf_aflw_id);
                $exists = $this->file_exist_folder($path,$file->paf_file_name);
                 if($exists==true)
                 {
                    $pdf_dir = $path;
                    $file_name=$file->paf_file_name;
                    $pdf_pages += $this->count_pages($pdf_dir,$file_name);
                 }  
            }
        }


        $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();

        $tab_name = $article_generic_form_data_table.'_'.$jnl_code;

        $tables = array(
            'main_table' => $tab_name,
            'join_table' => array(
                $article_flow_table => array($article_flow_table . '.aflw_id', $tab_name. '.gdata_artflw_id', "join"))
            );

        $condition="gdata_art_id={$article_id} AND gdata_unique_identifier='DOCUMENT_PAGE_COUNT' AND gdata_data!=''";
        $generic_form = $Article_generic_form_data::get_results_using_joins($tables, "gdata_data,aflw_level", $condition, 'single','gdata_id DESC');
        if(isset($generic_form->gdata_data) && !empty($generic_form->gdata_data))
        {
            $pages = $generic_form->gdata_data;
        }
        if(isset($generic_form->aflw_level) && !empty($generic_form->aflw_level) && isset($author_desigated_files[0]->aflw_level) && !empty($author_desigated_files[0]->aflw_level) && ($generic_form->aflw_level == $author_desigated_files[0]->aflw_level || $generic_form->aflw_level < $author_desigated_files[0]->aflw_level))
        {
            $final_page_count = $pdf_pages;
        }
        elseif(isset($generic_form->aflw_level) && !empty($generic_form->aflw_level) && isset($author_desigated_files[0]->aflw_level) && !empty($author_desigated_files[0]->aflw_level) && $generic_form->aflw_level > $author_desigated_files[0]->aflw_level)
        {
            $final_page_count = $pages;
        }
        elseif(isset($generic_form) && !empty($generic_form))
        {
            $final_page_count = $pages;
        }
        elseif(isset($author_desigated_files) && !empty($author_desigated_files))
        {
            $final_page_count = $pdf_pages;
        }
        return $final_page_count;
    }

    public function get_attach_to_author_files($art_id,$return_count=FALSE)
	{
        $Articles = new \App\Models\Articles();
        $Article_flow = new \App\Models\Article_flow();
        $Generic_flows = new \App\Models\Generic_flows();
        $Attachment_file_description = new \App\Models\Attachment_file_description();
        $Production_attachment_files = new \App\Models\Production_attachment_files();
        $Article_type_advance_options = new \App\Models\Article_type_advance_options();

        $production_attachment_table = (new \App\Models\Production_attachment_files)->getTable();
        $article_table = (new \App\Models\Articles)->getTable();
        $file_description_table = (new \App\Models\Attachment_file_description)->getTable();
        $Article_flow_table = (new \App\Models\Article_flow)->getTable();



        $tables = array(
            'main_table' => $production_attachment_table,
            'join_table' => array(
                $file_description_table => array($file_description_table . '.afdec_id', $production_attachment_table . '.paf_description_id', "join"),
            )
        );
        $condition="paf_art_id={$art_id} AND afdec_attach_to_author='y'";
        $result = $Production_attachment_files::get_results_using_joins($tables, "MAX(paf_aflw_id) as aflw_id", $condition, 'single');
        if(isset($result->aflw_id))
        {
            $aflw_id = $result->aflw_id;
            $condition="paf_art_id={$art_id} AND afdec_attach_to_author='y' AND paf_aflw_id={$aflw_id}";
        }
        else
        {
            $condition="paf_art_id={$art_id} AND afdec_attach_to_author='y'";
        }

        $tables = array(
            'main_table' => $production_attachment_table,
            'join_table' => array(
                $article_table => array($article_table . '.art_id', $production_attachment_table . '.paf_art_id', "join"),
                $file_description_table => array($file_description_table . '.afdec_id', $production_attachment_table . '.paf_description_id', "join"),
                $Article_flow_table => array($Article_flow_table . '.aflw_id', $production_attachment_table . '.paf_aflw_id', "join")
            )
        );
        $author_desigated_files = $Article_flow::get_results_using_joins($tables, "paf_id,paf_aflw_id,paf_file_name,paf_document_size,art_article_upload_path,aflw_level", $condition, 'all','paf_id DESC');
		if($return_count == FALSE)
			return $author_desigated_files;
		else
		{
			$pdf_pages = 0;
			if(isset($author_desigated_files) && !empty($author_desigated_files))
			{
                foreach($author_desigated_files as $attach)
                {
                  $path = $this->get_upload_path('uploads/'.$attach->art_article_upload_path.'/production/'.$attach->paf_aflw_id);
                  $exists = $this->file_exist_folder($path,$attach->paf_file_name);
				  if($exists==true)
				  {
					$pdf_dir = $path;
                    $file_name=$attach->paf_file_name;
					$pdf_pages += $this->count_pages($pdf_dir,$file_name);
				  }
                }
			}
			return $pdf_pages;
		}
	}
	public function count_pages($pdfdir,$pdfname)
	{
		$num = 0;
        $exists = $this->file_exist_folder($pdfdir,$pdfname);
		if($exists==true)
		{
			$pdftext = file_get_contents($pdfdir.'/'.$pdfname);
			$num = preg_match_all("/\/Page\W/", $pdftext);
			if($num == 0)
			{
				$num = preg_match_all("/\/Pages\W/", $pdftext);
			}
		}
		return $num;
	}

    public function create_merge_unique_array($array_data)
    {

        $assigned_user_ids = [];
        if(!empty($array_data))
        {
        foreach ($array_data as $user) {
            if(isset($user->user_id)&&($user->user_id!=''))
            {
                $expolde_user=explode(',',$user->user_id);
            }
            if(!empty($expolde_user))
            $assigned_user_ids=array_unique(array_merge($assigned_user_ids,$expolde_user));

        }
        }
        return $assigned_user_ids;
    }
   public function get_who_can_shortlist_invite_users($flow_privilages,$article_id,$jnl_id,$jnl_code)
   {
    $return_array=array();
    $assigning_roles = json_decode($flow_privilages['article_flow_details']->jwf_parent_user_roles);
    $who_can_assign = '';
    if ($assigning_roles != '') {
        $who_can_assign = $this->get_users_in_role($article_id,$flow_privilages['article_data']->artp_id, $assigning_roles,$jnl_id,$jnl_code);
    }
    $return_array['assigned_user_ids'] = [];
    if(!empty($who_can_assign))
    {
        $return_array['assigned_user_ids']=$this->create_merge_unique_array($who_can_assign);
    }
    $who_can_invite = '';

      $inviting_roles = json_decode($flow_privilages['article_flow_details']->jwf_who_can_invite);
        if ($inviting_roles != '') {
     $who_can_invite = $this->get_users_in_role($article_id,$flow_privilages['article_data']->artp_id, $inviting_roles,$jnl_id,$jnl_code);
        }
        $return_array['who_can_invite_user_ids']=[];

        if(!empty($who_can_invite))
        {
            $return_array['who_can_invite_user_ids']=$this->create_merge_unique_array($who_can_invite);
        }

        return $return_array;

   }

   /*
    * some fontawesome flags need to be replaced when we use <i> tag or the icon classname
    */
    public function fav_icon_replace($flag_icon) {
        $return_new_fav_icon=   '';
        switch ($flag_icon) {
            case "triangle-exclamation":
                $return_new_fav_icon    = "exclamation-triangle";break;
            case "xmark":
                $return_new_fav_icon    = "times";break;
            case "square-envelope":
                $return_new_fav_icon    = "envelope-square";break;
            case "square-check":
                $return_new_fav_icon    = "check-square";break;
            case "circle-xmark":
                $return_new_fav_icon    = "times-circle"; break;
            case "face-frown":
                $return_new_fav_icon    = "frown";break;
            case "arrows-rotate":
                $return_new_fav_icon    = "sync";break;
            case "square-h":
                $return_new_fav_icon    = "h-square";break;
            default:
                $return_new_fav_icon    = $flag_icon;
        }

        return $return_new_fav_icon;
    }
    public function checkuserhaspermission($article_privilages,$user_roles,$article_basics,$user_id,$jnl_id,$jnl_code)
    {
        if($article_basics->jwf_stage_type=="transit")
        {
            return true;
        }
        if($article_privilages['privilaged']==TRUE && $article_privilages['proxy_non_privilaged']==FALSE && $article_privilages['author']==FALSE && $article_privilages['reviewer']==FALSE)
        {
            if(!empty(array_intersect($user_roles['assigned_roles'], array("journal_admin"))))
            {
                $diff =array_diff($user_roles['assigned_roles'],array("journal_admin"));
                if(empty($diff))
                {
                    return true;
                }
                elseif(empty(array_intersect($user_roles['assigned_roles'], array("editor_in_chief"))) && empty(array_intersect($user_roles['assigned_roles'], array("associate_editor")))){
                    return true;
                }

                $Roles = new \App\Models\Roles();
                $where_condition = "role_assigned_role=:role";
                $roles = $Roles::get_single_record('group_concat(role_id) as roleids', $where_condition,NULL,'',NULL,array('role'=>'staff'));
                $staff_roles=explode(',', $roles->roleids);
                $Article_flow_table = (new \App\Models\Article_flow)->getTable();
                $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
                $sql = 'SELECT group_concat(jwf_role_id) as roleids FROM ' . $Article_flow_table. ' aflw JOIN ' . $Generic_flows_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id where aflw_art_id =:aflw_art_id and aflw_usr_id=:aflw_usr_id';
                $flow_records = Article_flow::get_records_by_raw_query($sql,FALSE,array("aflw_art_id"=>$article_basics->art_id,"aflw_usr_id"=>$user_id));
                $user_roles=explode(',', $flow_records[0]->roleids);
                $result=array_diff($staff_roles,$user_roles);
                if(empty($user_roles[0]) || empty($result))
                {
                    return true;
                }
            }
            if($article_basics->jwf_assignment=='self_service' || ($article_basics->jwf_assignment=="manual" && $article_basics->aflw_usr_id!=''))
            {
                $Roles = new \App\Models\Roles();
                $select_role = "role_assigned_role";
                $where_condition = ' role_id =:role_id';
                $roles = $Roles::get_single_record($select_role, $where_condition,NULL,'',NULL,array('role_id'=>$article_basics->jwf_role_id));
                if ($this->current_client->functionality->cfty_manage_search_results_for_editors == 'y' && ($roles->role_assigned_role=="editor_in_chief" || $roles->role_assigned_role=="associate_editor")) {
                    $User_articles = new \App\Models\User_articles();
                    $article_users = $User_articles::get_single_record('group_concat(usra_usr_id) as userids','usra_art_id=:usra_art_id and usra_role_id=:usra_role_id',NULL,'',NULL,array('usra_art_id'=>$article_basics->art_id,'usra_role_id'=>$article_basics->jwf_role_id));
                    if(isset($article_users->userids))
                    {
                        $user_ids=explode(',', $article_users->userids);
                        if(!in_array($user_id, $user_ids)) {
                            $flowdata = Article_flow::get_article_flow_details('aflw_id','aflw_id=:aflw_id and jwf_role_id=:jwf_role_id',FALSE,array('aflw_id'=>$article_basics->aflw_id,'jwf_role_id'=>$article_basics->jwf_role_id));
                            if(isset($flowdata[0]) && (isset($flowdata[0]->aflw_id) && $flowdata[0]->aflw_id!=''))
                            {
                                return true;
                            }
                            else
                            {
                                $array_data['user_id']=$user_id;
                                $array_data['article_id']=$article_basics->art_id;
                                $checkuserdiscussion= $this->check_discussionparticipient_user($array_data);
                                if($checkuserdiscussion==TRUE)
                                {
                                    return true;
                                }
                                else
                                {
                                    return false;
                                }
                            }

                        }
                        else
                        return true;
                    }
                    else
                    return true;
                } else
                return true;
            }
            else{
                $assigning_roles = json_decode($article_basics->jwf_parent_user_roles);
                $who_can_assign = '';
                if ($assigning_roles != '') {
                    $who_can_assign = $this->get_users_in_role($article_basics->art_id,$article_basics->art_artp_id, $assigning_roles,$jnl_id,$jnl_code);
                }
                $assigned_user_ids=[];
                if(!empty($who_can_assign))
                {
                    $assigned_user_ids=$this->create_merge_unique_array($who_can_assign);
                }
                $who_can_invite = '';
                $inviting_roles = json_decode($article_basics->jwf_who_can_invite);
                if ($inviting_roles != '') {
                    $who_can_invite = $this->get_users_in_role($article_basics->art_id,$article_basics->art_artp_id, $inviting_roles,$jnl_id,$jnl_code);
                }
                    $who_can_invite_user_ids=[];

                    if(!empty($who_can_invite))
                    {
                        $who_can_invite_user_ids=$this->create_merge_unique_array($who_can_invite);
                    }
                    $user_arrays =array_unique(array_merge($assigned_user_ids,$who_can_invite_user_ids));
                    if(isset($user_arrays))
                    {
                        if(!in_array($user_id, $user_arrays)) {
                            $flowdata = Article_flow::get_article_flow_details('aflw_id','aflw_id=:aflw_id and jwf_role_id=:jwf_role_id',FALSE,array('aflw_id'=>$article_basics->aflw_id,'jwf_role_id'=>$article_basics->jwf_role_id));
                            if(isset($flowdata[0]) && (isset($flowdata[0]->aflw_id) && $flowdata[0]->aflw_id!=''))
                            {
                                return true;
                            }
                            else
                            {
                                $array_data['user_id']=$user_id;
                                $array_data['article_id']=$article_basics->art_id;
                                $checkuserdiscussion= $this->check_discussionparticipient_user($array_data);
                                if($checkuserdiscussion==TRUE)
                                {
                                    return true;
                                }
                                else
                                {
                                    return false;
                                }
                            }
                        }
                        else
                        return true;
                    }
            }
        }
        else if($article_privilages['author']==TRUE){
            $author_stages = array('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright', 'author_submission','proof_reading','pro_revision','decision_revision');
            if(!in_array($article_basics->jwf_stage_type, $author_stages))
            {
                $flowdata = Article_flow::get_single_record('aflw_id','aflw_id=:aflw_id and aflw_art_id =:art_id',NULL,'',NULL,array('aflw_id'=>$article_basics->aflw_id,'art_id'=>$article_basics->art_id));
                if(isset($flowdata) && (isset($flowdata->aflw_id) && $flowdata->aflw_id!=''))
                {
                    return true;
                }
                else
                {
                    $array_data['user_id']=$user_id;
                    $array_data['article_id']=$article_basics->art_id;
                    $checkuserdiscussion= $this->check_discussionparticipient_user($array_data);
                    if($checkuserdiscussion==TRUE)
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            }
            else
            {
                return true;
            }
        }
        else if($article_privilages['reviewer']==TRUE){
            if($article_privilages['privilaged']==TRUE)
            {
                if($article_privilages['user_allocated']==TRUE)
                {
                    return true;
                }
                $Article_flow = new \App\Models\Article_flow;
                $flow_records = $Article_flow::get_single_record('aflw_id','aflw_art_id=:aflw_art_id and aflw_usr_id =:aflw_usr_id and aflw_status=:aflw_status',NULL,'',NULL,array("aflw_art_id"=>$article_basics->art_id,"aflw_usr_id"=>$user_id,"aflw_status"=>"c"));
                if(!empty($flow_records) && (isset($flow_records) && isset($flow_records->aflw_id) && !empty($flow_records->aflw_id)))
                {
                    return true;
                }
            }
            $reviewer_criteria = "aflw_art_id=:aflw_art_id AND jwf_assignment=:jwf_assignment AND aflw_usr_id=:aflw_usr_id";
            $binding_arr=array(
                'aflw_art_id'=>$article_basics->art_id,
                'jwf_assignment'=>'invitation',
                'aflw_usr_id'=>$user_id
            );
            $where_in='aflw_status IN ("i","a")';
            $article_flow_table = (new \App\Models\Article_flow)->getTable();;
            $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
            $tables = array(
                'main_table' => $article_flow_table,
                'join_table' => array(
                    $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "left")
                )
            );

            $reviwer_role_count = Article_flow::get_results_using_joins($tables, 'count(aflw_id) as cnt', $reviewer_criteria, 'single',NULL,NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr,$where_in);
            $is_reviewer = (isset($reviwer_role_count->cnt) && $reviwer_role_count->cnt > 0) ? TRUE : FALSE;
            if($is_reviewer == TRUE)
            {
            $reviewer_stage=array('review');
            if(!in_array($article_basics->jwf_stage_type, $reviewer_stage))
            {
                $array_data['user_id']=$user_id;
                $array_data['article_id']=$article_basics->art_id;
                $checkuserdiscussion= $this->check_discussionparticipient_user($array_data);
                if($checkuserdiscussion==TRUE || ($article_basics->aflw_status=='c' && $article_basics->aflw_usr_id=$user_id))
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return true;
            }
            }
            else
            {
                return true;
            }
        }
        else{
            $Article_flow = new \App\Models\Article_flow;
            $flow_records = $Article_flow::get_single_record('aflw_id','aflw_art_id=:aflw_art_id and aflw_usr_id =:aflw_usr_id',NULL,'',NULL,array("aflw_art_id"=>$article_basics->art_id,"aflw_usr_id"=>$user_id));
            if(!empty($flow_records) && (isset($flow_records) && isset($flow_records->aflw_id) && !empty($flow_records->aflw_id)))
            {
                return true;
            }
            else{
            $array_data['user_id']=$user_id;
            $array_data['article_id']=$article_basics->art_id;
            $checkuserdiscussion= $this->check_discussionparticipient_user($array_data);
            if($checkuserdiscussion==TRUE)
            {
                return true;
            }
            else
            {
                return false;
            }
            }
        }


    }
    public function check_delete_user($user_id)
	{
        $return_data['can_delete_user'] = TRUE;
        $criteria='usrj_usr_id ='.$user_id;
		$check_avl_user = User_to_journals::get_single_record('*',$criteria);
        $condition= 'art_posted_by='. $user_id;
		$check_avl_art = Articles::get_single_record('*', $condition);
		if ($check_avl_user != NULL)
		{
			$return_data['can_delete_user'] = FALSE;
			$return_data['status'] = 'refer_user_journal';
			$return_data['msg'] = customTrans('users.refer_user_journal');
		}
		else if ($check_avl_art != NULL)
		{
			$return_data['can_delete_user'] = FALSE;
			$return_data['status'] = 'refer_art';
			$return_data['msg'] = customTrans('users.refer_art');
		}

		return $return_data;
	}
    public function validateInput($data)
    {
        // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
        $client_fieldvalid  = $this->get_clientfieldrequired_functionalities();


        if (array_key_exists('username',$data) ){
            $rules['username'] = 'required|regex:/^(?!.*<[^>]*>)/|regex:/^[a-zA-Z](?:_?[a-zA-Z0-9@._-]+)*$/';
        }
        if (isset($client_fieldvalid->firstname) && $client_fieldvalid->firstname=='y' && array_key_exists('firstname',$data) ){
            $rules['firstname'] = 'required|regex:/^[A-Za-z\'\s\-]+$/|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->middlename) && $client_fieldvalid->middlename=='y' && array_key_exists('middlename',$data) ){
            $rules['middlename'] = 'required|regex:/^[A-Za-z\'\s\-]+$/|regex:/^(?!.*<[^>]*>)/';
        }else if(array_key_exists('middlename',$data)) {
            $rules['middlename'] = 'nullable|regex:/^[A-Za-z\'\s\-]+$/|regex:/^(?!.*<[^>]*>)/';
        }

        if (isset($client_fieldvalid->website) && $client_fieldvalid->website=='y' && array_key_exists('website',$data) ){
            $rules['website'] = 'required|url|regex:/^(?!.*<[^>]*>)/';
        }else if (array_key_exists('website',$data)) {
            $rules['website'] = 'nullable|url|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->phonenumber) && $client_fieldvalid->phonenumber=='y' && array_key_exists('phonenumber',$data) ){
            $rules['phonenumber'] = 'required|min:6|regex:/^[\d\s()+-]+$/|regex:/^(?!.*<[^>]*>)/';
        } else if(array_key_exists('phonenumber',$data) ) {
            $rules['phonenumber'] = 'nullable|min:6|regex:/^[\d\s()+-]+$/|regex:/^(?!.*<[^>]*>)/';
        }
        if (array_key_exists('confirmpassword',$data) ){
            $rules['confirmpassword'] = 'nullable|min:6|regex:/^[\d\s()+-]+$/|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->lastname) && $client_fieldvalid->lastname=='y' && array_key_exists('lastname',$data) ){
            $rules['lastname'] = 'required|regex:/^[A-Za-z\'\s\-]+$/|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->primary_email_address) && $client_fieldvalid->primary_email_address=='y' && array_key_exists('email',$data) ){
            $rules['email'] = 'required|email|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->type_institution) && $client_fieldvalid->type_institution=='y' && array_key_exists('type_institution',$data) ){
            $rules['type_institution'] = 'required|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->institution) && $client_fieldvalid->institution=='y' && array_key_exists('institution',$data) ){
            $rules['institution'] = 'required|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->country) && $client_fieldvalid->country=='y' && array_key_exists('country',$data) ){
            $rules['country'] = 'required|regex:/^(?!.*<[^>]*>)/';
        }
        if (isset($client_fieldvalid->postal_code) && $client_fieldvalid->postal_code=='y' && array_key_exists('zipcode',$data) ){
            $rules['zipcode'] = 'required|regex:/^(?!.*<[^>]*>)/';
        }
        if (array_key_exists('password',$data) ){
            $rules['password'] = 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/';
        }
        if (array_key_exists('confirmpassword',$data) ){
            $rules['confirmpassword'] = 'required';
        }
        if (array_key_exists('form_id',$data) ){
            $rules['form_id'] = 'required';
        }

        if (array_key_exists('cfty_gender_race_ethnicity',$data) && $data['cfty_gender_race_ethnicity'] == 'y') {
            if (array_key_exists('gender',$data) ){
                $rules['gender'] = 'required';
            }
            if (array_key_exists('ethnicity',$data) ){
                $rules['ethnicity'] = 'required';
            }
            if (array_key_exists('race',$data) ){
                $rules['race'] = 'required';
            }
        }

        if (array_key_exists('cfty_show_terms_conditions',$data) && $data['cfty_show_terms_conditions'] == 'y') {
            if (array_key_exists('terms',$data) ){
                $rules['terms'] = 'required';
            }
        }

        if (isset($client_fieldvalid->aff_phonenumber) && $client_fieldvalid->aff_phonenumber=='y' && array_key_exists('aff_phonenumber',$data) ){
            $rules['aff_phonenumber'] = 'required|min:6|regex:/^[\d\s()+-]+$/|regex:/^(?!.*<[^>]*>)/';
        } else if (array_key_exists('aff_phonenumber',$data)){
            $rules['aff_phonenumber'] = 'nullable|min:6|regex:/^[\d\s()+-]+$/|regex:/^(?!.*<[^>]*>)/';
        }

        if ($this->current_client->functionality->cfty_hide_affiliation_email_field=='n' && isset($client_fieldvalid->affiliation_email) && $client_fieldvalid->affiliation_email=='y' && array_key_exists('affiliation_email',$data) ){
            $rules['affiliation_email'] = 'required|email|regex:/^(?!.*<[^>]*>)/';
        } else if(array_key_exists('affiliation_email',$data)){
            $rules['affiliation_email'] = 'nullable|email|regex:/^(?!.*<[^>]*>)/';
        }

        if (isset($client_fieldvalid->state) && $client_fieldvalid->state=='y' && array_key_exists('state',$data) ){
            $rules['state'] = 'required';
        }

        if (isset($client_fieldvalid->department) && $client_fieldvalid->department=='y' && array_key_exists('department',$data) ){
            $rules['department'] = 'required';
        }
        if (isset($client_fieldvalid->addressline_1) && $client_fieldvalid->addressline_1=='y' && array_key_exists('addressline_1',$data) ){
            $rules['addressline_1'] = 'required';
        }
        if (isset($client_fieldvalid->addressline_2) && $client_fieldvalid->addressline_2=='y' && array_key_exists('addressline_2',$data) ){
            $rules['addressline_2'] = 'required';
        }
        if (isset($client_fieldvalid->title) && $client_fieldvalid->title=='y' && array_key_exists('title',$data) ){
            $rules['title'] = 'required';
        }




          $validator = Validator::make($data, $rules);
          if ($validator->fails()) {
            $valid_data['status'] = 'error';
            $valid_data['msg'] = 'error occured';
            $valid_data['errors']=$validator->errors();
            return  $valid_data;
        }
        $valid_data['status'] = 'false';
        $valid_data['msg'] = 'error occured';
        return $valid_data;
        // Validation passed, continue with your logic
    }
    public function check_username($username,$user_id)
    {
        $input_arr = array(
            'input' => $username
        );
        $edited_id_validate = $this->Rv_validator($input_arr);
        if($edited_id_validate != TRUE ){
            return $this->failure('Failed',422,'Username Invalid');
        }
    $criteria ='usr_username=?';
    $bnd_arr = array($username);
    if($user_id!='')
    {
        $criteria.=' AND usr_id<>?';
        $bnd_arr[] = $user_id;
    }
    $check_username = User::get_single_record_with_bind_cond('count(usr_id) as cnt',array(), $criteria,$bnd_arr);

    if($check_username->cnt>0)
    {
            return true;
    }
    else
    {
            return false;
        }
    }
    public function check_email($email,$user_id,$stand_alone=NULL,$emaildata=NULL)
    {
        $input_arr = array(
            'input' => $email,
            'type'=> 'email'
        );
        $edited_id_validate = $this->Rv_validator($input_arr);
        if($edited_id_validate != TRUE ){
            return $this->failure('Failed',422,'Invalid');
        }
        $criteria ='usr_email= ? ';
        $condition_arr=array(
             $email
        );
        if($user_id!='')
        {
             $criteria.=' AND usr_id!= ?';
            $condition_arr[]=$user_id;
        }
                $jnl_id = '';
                $jrnl_grp = $this->get_standalone_journal_data();

                if (!empty($jrnl_grp)) {
                    $jnl_id = $jrnl_grp->jnl_id;
                   
                } else if (isset($stand_alone) && $stand_alone != '') {
                    $jnl_id = $stand_alone;
                }             
            $get_email_record =User::get_user_by_email_journal($criteria, $jnl_id,'AND',NULL, $condition_arr);
            if(count($get_email_record) > 0)
            {
            return true;
            }
            else
            {
            return false;
            }
            }

    /**
      **** ##ReView validation function##****
    * input = May be a string / number / date
     * type = number/date/email/string/bflag (boolean flag) expected
     * * bflag = y-yes,n-no for checking boolean flages only
     * enc_data if the input data encypted then send this argument True
     */
    // $input,$must_number = FALSE,$must_date,$enc_data = FALSE
    public function Rv_validator($parameters_arr)
    {
	  $return = FALSE;
        if(isset($parameters_arr['input']))
        {
            $input = $parameters_arr['input'];
            $type = isset($parameters_arr['type'])?$parameters_arr['type']:''; // must be number/date/email/string
            $enc_data = isset($parameters_arr['enc_data'])?$parameters_arr['enc_data']:FALSE;
            $rv_enc_data = isset($parameters_arr['rv_enc_data'])?$parameters_arr['rv_enc_data']:FALSE;
            $required_data = isset($parameters_arr['required'])?$parameters_arr['required']:TRUE;

            if($required_data == FALSE && empty($parameters_arr['input']))
            {
                $return = TRUE;
            }
            elseif(!empty($parameters_arr['input']))
            {
                //$pattern = '/["<>\']/';
                if($enc_data == TRUE)
                {
                    $input = trim($this->decrypt_data($input)); //TASK #3755 Modification in adhoc email to load the 'View Article' link with its content
                }
                if($rv_enc_data == TRUE)
                {
                    $input = Rv_decrypt($input);
                }

                switch($type)
                {
                    case 'number':
                        $pattern = '/^[0-9]+$/';
                        break;
                    case 'date':
                        $pattern = '/^\d+(?:[\/-])\d+(?:[\/-])\d+/';
                        break;
                    case 'bflag':
                        $pattern = '/^[yn]+$/';
                        break;
                    case 'email':
                        $pattern = "/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/";
                        break;
                    case 'alphabet':
                        $pattern = "/^[a-zA-Z]+$/"; 
                        break;
                    default:
                        $pattern = '/^(?!.*<[^>]*>)/';
                        break;
                }

                if(preg_match($pattern, $input) == TRUE)
                {
                    $return = TRUE;
                }
            }
        }
		return $return;
    }

    public function filter_validator($filter_arr)
    {
        $flag = TRUE;
        if(count($filter_arr) > 0)
        {
            $string_check = array('article_code','art_title','article_type_set','stage_name','date');
            $number_check = array('article_type');
            $date_check = array('start_date','end_date');
            $bflag = array('special_issue');
            foreach($filter_arr as $key =>$value)
            {
                $value = trim($value);
                if(in_array($key,$string_check))
                {
                    $input_arr = array(
                        'input' => $value,
                        'required' => FALSE
                    );
                    $flag = $this->Rv_validator($input_arr);
                    if($flag == FALSE)
                    {
                        break;
                    }
                }
                if(in_array($key,$bflag))
                {
                    $input_arr = array(
                        'input' => $value,
                        'type' => 'bflag',
                        'required' => FALSE
                    );
                    $flag = $this->Rv_validator($input_arr);
                    if($flag == FALSE)
                    {
                        break;
                    }
                }
                if(in_array($key,$number_check))
                {
                    $input_arr = array(
                        'input' => $value,
                        'type' => 'number',
                        'required' => FALSE
                    );
                    $flag = $this->Rv_validator($input_arr);
                    if($flag == FALSE)
                    {
                        break;
                    }
                }
                if(in_array($key,$date_check))
                {
                    $input_arr = array(
                        'input' => $value,
                        'type' => 'date',
                        'required' => FALSE
                    );
                    $flag = $this->Rv_validator($input_arr);
                    if($flag == FALSE)
                    {
                        break;
                    }
                }
            }
        }
        return $flag;
    }
    public function check_discussionparticipient_user($array_data)
    {
        $checkparticipient=false;
        $Generic_discussion=new \App\Models\Generic_discussion();
        if(isset($array_data['user_id']) && !empty($array_data['user_id']) && isset($array_data['article_id']) && !empty($array_data['article_id']))
        {
        // $condcheckuserexit = ' (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$array_data['user_id'].') is NOT NULL OR gdis_started_by='.$array_data['user_id'].') AND gdis_art_id='.$array_data['article_id'].''; // TASK #4943 updatesubmissiontab sql injection
        // $discussion_checkuser = $Generic_discussion::get_single_record('gdis_id',$condcheckuserexit); TASK #4943 updatesubmissiontab sql injection
        $condcheckuserexit = ' (JSON_SEARCH(gdis_participants_by_usr_id,\'all\', ?) IS NOT NULL OR gdis_started_by = ?) AND gdis_art_id = ?'; // TASK #4943 updatesubmissiontab sql injection
        $discussion_checkuser = $Generic_discussion::get_single_record('gdis_id', $condcheckuserexit, binding_arr: [$array_data['user_id'], $array_data['user_id'], $array_data['article_id']]); // TASK #4943 updatesubmissiontab sql injection
        if(!empty($discussion_checkuser))
        {
            $checkparticipient=true;
        }
        }
        return $checkparticipient;
    }
    public function suspecious_activity_check($array_data)
    {
        
        if(isset($array_data['current_user']['proxy_user_id']) && $array_data['current_user']['proxy_user_id']=='0')
        {
            if(isset($array_data['role_id']) && !empty($array_data['role_id']) && isset($array_data['article_id']) && !empty($array_data['article_id']))
            {
                $role_id=$array_data['role_id'];
                $Roles = new \App\Models\Roles();
                $select_core_role = "role_assigned_role";
                $where_condition =array(
                    'role_id'=>$role_id
                );
                $roles = $Roles::get_single_record_with_bind_cond($select_core_role, $where_condition);
                if(!empty($roles))
                {
                    //set common role permission
                    $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default.suspecious_roles';
                    $role_array_check   = Config::get($client_default);
                    if(isset($role_array_check))
                    {
                        $role_array=$role_array_check;
                    }else
                    {
                        $role_array=['author', 'reviewer', 'associate_editor','editor_in_chief'];
                    }
                    if (in_array($roles->role_assigned_role, $role_array)) 
                    {
                       
                        $Login_tracking = new \App\Models\Login_tracking();
                        $suspecious_activity = new \App\Models\Suspecious_activity();
                        //check user is direct login or proxy login.Direct login only allow
                        if(isset($array_data['current_user']['user_id']) && !empty($array_data['current_user']['user_id']))
                        {
                          $user_id=$array_data['current_user']['user_id'];
                          //get last login record
                            $last_loginfo = $Login_tracking::get_last_login_sus_ip($user_id);
                            if (!empty($last_loginfo) ) {
                                $last_login_date       =    $last_loginfo[0]->ltk_posted_date;
                                $ltk_ip                =    $last_loginfo[0]->ltk_ip;
                                $ltk_id                =    $last_loginfo[0]->ltk_id;
                                $article_id=$array_data['article_id'];
                                $condition = "sup_art_id=? AND sup_usr_id!=?";
                                $binding_arr = array($article_id,$user_id);
                                $suspecious_activity_table = (new \App\Models\Suspecious_activity)->getTable();;
                                $login_tracking_table = (new \App\Models\Login_tracking())->getTable();
                                //check the same ip adress login exits in new table
                                $tables = array(
                                    'main_table' => $suspecious_activity_table,
                                    'join_table' => array(
                                        $login_tracking_table => array($login_tracking_table . '.ltk_id', $suspecious_activity_table . '.sup_ltk_id', "left")
                                    )
                                );
                    
                                $ip_check = Suspecious_activity::get_results_using_joins($tables, 'ltk_ip,sus_flag_status,sup_id', $condition, 'all',NULL,NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr);
                                if(!empty($ip_check))
                                {
                                   
                                  $exists = collect($ip_check)->contains('ltk_ip',$ltk_ip);
                                  //if exists same ip adress then update the record as flaged
                                  if ($exists) {
                                    //initial set flag as true
                                    $flg=true;
                                    foreach ($ip_check as $row)
                                    {
                                        
                                        if($row->ltk_ip==$ltk_ip)
                                        {
                                            $sup_id=$row->sup_id;
                                            if($row->sus_flag_status=='n')
                                            {
                                            $flg=false;
                                            //if user is alredy exits the flag is n same ip then exits recod update flag y
                                            $old_update = array(
                                                'sus_flag_status' => 'y',
                                                'sup_submission_date' => date('Y-m-d H:i:s'),
                                                'sup_ref_ltk_id'=>$ltk_id
                                            );
                                            Suspecious_activity::update_record($old_update,"sup_art_id={$article_id} AND sup_id={$sup_id}", $array_data['current_user']);
                                           

                                        }
                                    }
                                    }
                                    if($flg==false)
                                    {
                                        //then insert record as  
                                        $insert_array = array(
                                            'sup_art_id' => $article_id,
                                            'sup_usr_id' => $user_id,
                                            'sup_role_id'=>$role_id,
                                            'sup_aflw_id' => $array_data['current_stage'],
                                            'sup_ltk_id' => $ltk_id,
                                            'sus_flag_status' => 'y',
                                            'sup_submission_date' => date('Y-m-d H:i:s'),
                                            'sup_ref_ltk_id'=>$ltk_id
                                        );
                                        Suspecious_activity::insert_record($insert_array, $array_data['current_user']);  
                                    }
                                    if($flg==true){
                                    $where_condition1 =array(
                                        'sup_art_id'=>$article_id,
                                        'sup_id'=>$sup_id,
                                        'sus_flag_status'=>'y'
                                    );
                                    //get referenece ip id from flaged user then update to new record
                                    $sup_reff = Suspecious_activity::get_single_record_with_bind_cond('sup_ref_ltk_id', $where_condition1);
                                    if(!empty($sup_reff))
                                    {
                                        $sup_ref_ltk_id=$sup_reff->sup_ref_ltk_id;
                                    }else{ $sup_ref_ltk_id=$ltk_id;}
                                    //inser new enty as login entry and perform task
                                    $insert_array = array(
                                        'sup_art_id' => $article_id,
                                        'sup_usr_id' => $user_id,
                                        'sup_role_id'=>$role_id,
                                        'sup_aflw_id' => $array_data['current_stage'],
                                        'sup_ltk_id' => $ltk_id,
                                        'sus_flag_status' => 'y',
                                        'sup_submission_date' => date('Y-m-d H:i:s'),
                                        'sup_ref_ltk_id'=>$sup_ref_ltk_id
                                    );
                                     Suspecious_activity::insert_record($insert_array, $array_data['current_user']); 
                                } 
                                }
                                else
                                {
                                    //no users then inser default value
                                    $insert_array = array(
                                        'sup_art_id' => $article_id,
                                        'sup_usr_id' => $user_id,
                                        'sup_role_id'=>$role_id,
                                        'sup_aflw_id' => $array_data['current_stage'],
                                        'sup_ltk_id' => $ltk_id,
                                        'sus_flag_status' => 'n',
                                        'sup_submission_date' => date('Y-m-d H:i:s'),
                                        'sup_ref_ltk_id'=>0
                                    );
                                     $suspecious_activity::insert_record($insert_array, $array_data['current_user']);  
                                }
                                }else
                                {
                                    //its first insert default value
                                    $insert_array = array(
                                        'sup_art_id' => $article_id,
                                        'sup_usr_id' => $user_id,
                                        'sup_role_id'=>$role_id,
                                        'sup_aflw_id' => $array_data['current_stage'],
                                        'sup_ltk_id' => $ltk_id,
                                        'sus_flag_status' => 'n',
                                        'sup_submission_date' => date('Y-m-d H:i:s'),
                                        'sup_ref_ltk_id'=>0
                                    );
                                     $suspecious_activity::insert_record($insert_array, $array_data['current_user']);  
                                }
                                
                            }
                        }

                    }
                }

        }
    }
    }
    public function check_client_proceeding()
    {
        $aippflag=false;
        if((env('VITE_CONFERENCE_PROCEEDINGS')) && env('VITE_CONFERENCE_PROCEEDINGS')==true)
			{
				$aippflag=true;		
			}
        return $aippflag;    
    }
    public function check_espermission_access($array_data)
    {
        $esflag=false;
        if(isset($array_data['article_id']) && !empty($array_data['article_id']))
        {
                $article_id=$array_data['article_id'];
                $select_fields = "art_status,art_es_document_status,art_es_document_type,artp_id,artp_es_document_type";
                $condition = "art_id=?";
                $Article_types = (new \App\Models\Article_types())->getTable();
                $Articles = (new \App\Models\Articles())->getTable();
                $tables = array(
                    'main_table' => $Articles,
                    'join_table' => array(
                        $Article_types => array($Article_types . '.artp_id', $Articles . '.art_artp_id','left')
                    )
                );
                $option_settings = Articles::get_results_using_joins($tables, $select_fields, $condition, 'single',binding_arr:[$article_id]);
                if(!empty($option_settings))
                {
                    if($option_settings->art_es_document_status=='y')
                    {
                        $esflag=true;
                    }
                    else if(($option_settings->art_es_document_status=='a'))
                    {
                        $esflag=true;
                    }
                   /* else if(($option_settings->art_es_document_status=='n') && $option_settings->art_status!='n')
                    {
                        $esflag=false;
                    }*/
                   
                   /* else if(($option_settings->art_es_document_status=='a') && $option_settings->art_status=='n' && $option_settings->artp_es_document_type=='y' && isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                    {
                        $esflag=true;
                    }*/
                }

        }
        return $esflag;
    }

        /*
    Function to Check Access the Api service in user */
    public function check_permission_access_user($array_data)
    {

        $user_access=false;
        $access_url_timeline_list=Config::get('user_access_page.manange-timeline-url');
        $access_url_note_list=Config::get('user_access_page.manange-article-notes');
        $access_url_discussion_list=Config::get('user_access_page.manange-article-discussion');
        $acess_url_flag_list=Config::get('user_access_page.manange-article-flag');
        $acess_url_article_submission_list=Config::get('user_access_page.manange-article-submisiion-api');
        if(isset($array_data['article_id'])&&$array_data['article_id']!='')
        {
            $current_user =$this->get_current_user_details();
            $Articles = new \App\Models\Articles();
            $User_to_journals=new \App\Models\User_to_journals();
            $Roles=new \App\Models\Roles();
            $article_data = $Articles::get_article_data($array_data['article_id']);
            if(empty($article_data))
            {
             return false;
            }
            //check article is resubmitted;
            // $previous_condition="art_prev_article_id={$article_data->art_id}"; // TASK #4943 updatesubmissiontab sql injection
            // $previous_record= $Articles::get_single_record('art_id', $previous_condition); TASK #4943 updatesubmissiontab sql injection
            $previous_condition="art_prev_article_id=?"; // TASK #4943 updatesubmissiontab sql injection
            $previous_record= $Articles::get_single_record('art_id', $previous_condition,binding_arr:[$article_data->art_id]); // TASK #4943 updatesubmissiontab sql injection

            if(isset($previous_record->art_id))
            {
                $user_access=TRUE;
            }
            $article_type_id = $article_data->artp_id;
            $select = "artp_abbr_article_type,jp_add_notes,jp_flag_articles,jp_view_auditrail,jp_view_email_log,jp_edit_articles,jp_stage_manual_reminder,jp_view_file_inventory,jp_generic_discussion,artp_jnl_id";
            $condition = "artp_id=:artp_id";
            $article_type_advance = $this->get_article_type_permission($select, $condition,array("artp_id"=>$article_type_id));

            if($array_data['current_flow_id']!='')
            $article_privilages = $this->article_privilages($article_data,$array_data['current_flow_id'],$array_data['jnl_code']);
            else
            $article_privilages['privilaged']=TRUE;

            $user_roles = $this->validate_user_journal($array_data['jnl_code'], $current_user['user_id'], $article_type_id);

            if ($article_privilages['privilaged'] == TRUE)
            {

                     /* Timeline */
                     if(in_array($array_data['url'],$access_url_timeline_list))
                     {
                        //Task #2569 "View Details" in Proposal History Shows Blank Popup When Timeline Permission Is Missing
                        $allow_proposal_roles =Journal_settings::get_single_record_with_bind_cond('jset_draft_proposal_invite',array("jset_jnl_id"=>$article_type_advance->artp_jnl_id));
                           if ($article_type_advance->jp_view_auditrail != '' || $allow_proposal_roles->jset_draft_proposal_invite  !='') {
                        $allow_audit_roles = json_decode($article_type_advance->jp_view_auditrail, true);
                        $manage_draft = json_decode($allow_proposal_roles->jset_draft_proposal_invite, true);
                        $allow_audit_roles = is_array($allow_audit_roles) ? $allow_audit_roles : [];
                        $manage_draft = is_array($manage_draft) ? $manage_draft : [];
                        
                        if (
                            $article_data->art_stub != 'y' &&
                            (
                                count(array_intersect($user_roles['role_id'], $allow_audit_roles)) > 0 ||
                                count(array_intersect($user_roles['role_id'], $manage_draft)) > 0
                            )
                        ) {
                            $user_access = TRUE;
                        }
                        if (isset($article_privilages['author'])&& $article_privilages['author'] == TRUE) {
                            $user_access = FALSE;
                        }

                    }
                    /* end timeline */

                   }

            }
            else{
                $Article_flow = new \App\Models\Article_flow;
                $flow_records = $Article_flow::get_single_record('aflw_id','aflw_art_id=:aflw_art_id and aflw_usr_id =:aflw_usr_id',NULL,'',NULL,array("aflw_art_id"=>$array_data['article_id'],"aflw_usr_id"=>$current_user['user_id']));
                if(!empty($flow_records) && (isset($flow_records) && isset($flow_records->aflw_id) && !empty($flow_records->aflw_id)))
                {
                    $user_access = TRUE;
                }
            }
            if(in_array($array_data['url'],$access_url_timeline_list))
            {
            if ($article_type_advance->jp_view_email_log != '' ) {
                $allow_emaillog_roles = json_decode($article_type_advance->jp_view_email_log);
                if ((count(array_intersect($user_roles['role_id'], $allow_emaillog_roles)) > 0)) {
                    $user_access=TRUE;
                }

            }
        }


                      /* Article flags */
                      if(in_array($array_data['url'],$acess_url_flag_list))
                      {

                     if ($article_type_advance->jp_flag_articles != '') {
                          $allow_flag_roles = json_decode($article_type_advance->jp_flag_articles);
                          if ( (count(array_intersect($user_roles['role_id'], $allow_flag_roles)) > 0)) {

                            $user_access=TRUE;
                          }

                        }
                      }
                    /* File Inventory */
               /* if ($article_type_advance->jp_view_file_inventory != '') {
                    $allow_inventory_roles = json_decode($article_type_advance->jp_view_file_inventory);
                    if ((count(array_intersect($user_roles['role_id'], $allow_inventory_roles)) > 0)) {
                        $user_access=TRUE;
                    }
                }*/
                 /* Article Notes */
                 if(in_array($array_data['url'],$access_url_note_list))
                 {
                if ($article_type_advance->jp_add_notes != '') {
                    $allow_note_roles = json_decode($article_type_advance->jp_add_notes);
                    if ((count(array_intersect($user_roles['role_id'], $allow_note_roles)) > 0)) {
                        $user_access=TRUE;
                    }
                }
               }
                /* Discussion  */
                if(in_array($array_data['url'],$access_url_discussion_list))
                {
                if (isset($article_type_advance->jp_generic_discussion) && ($article_type_advance->jp_generic_discussion != '')) {
                    $allow_generic_discussion = json_decode($article_type_advance->jp_generic_discussion);
                    if ((count(array_intersect($user_roles['role_id'], $allow_generic_discussion)) > 0)) {
                        $user_access=TRUE;
                    }
                    else{
                      $checkuserdiscussion= $this->check_discussionparticipient_user($array_data);
                      if($checkuserdiscussion==TRUE)
                      {
                        $user_access=TRUE;
                      }

                    }
                    }
                }



                    if(in_array($array_data['url'],$acess_url_article_submission_list)&&isset($array_data['current_flow_id'])&&$array_data['current_flow_id']!='')
                    {

                        $jnl_user_roles = $User_to_journals::get_user_jnl_roles($current_user['user_id'],$article_type_advance->artp_jnl_id);

                        if ($jnl_user_roles[0]->role_ids != '') {
                            $current_user_roles = explode(';', $jnl_user_roles[0]->role_ids);
                        }
                        $all_roles = $Roles::get_all_records('role_id,role_name,role_assigned_role');
                        $all_roles = $this->rebuild_array_by_field($all_roles, 'role_id');


                        $return_data=array();
                        $return_data['article_edit_mode']=false;
                        $Article_flow = new \App\Models\Article_flow();
                        $articleflow_table = (new \App\Models\Article_flow)->getTable();
                        $genericflow_table = (new \App\Models\Generic_flows)->getTable();
                        $tables = array(
                            'main_table' =>  $articleflow_table,
                            'join_table' => array(
                                $genericflow_table => array($genericflow_table . '.jwf_id', $articleflow_table . '.aflw_jwf_id', "join")
                            )
                        );
                        $select_cur = 'aflw_id,jwf_stage_type,aflw_jwf_id,aflw_status,aflw_usr_id,jwf_forms,jwf_stage_name,jwf_role_id,jwf_assignment,aflw_parent_flow_id,jwf_article_editable';
                        // $current_stage_detials =$Article_flow::get_results_using_joins($tables, $select_cur, "aflw_id={$array_data['current_flow_id']}", 'single'); // TASK #4943 updatesubmissiontab sql injection
                        $current_stage_detials =$Article_flow::get_results_using_joins($tables, $select_cur, "aflw_id=?", 'single',binding_arr:[$array_data['current_flow_id']]); // TASK #4943 updatesubmissiontab sql injection
                        $stage_role = $all_roles[$current_stage_detials->jwf_role_id];
                        $current_stage_detials->role_name = $stage_role->role_name;
                        $current_stage_detials->role_assigned_role = $stage_role->role_assigned_role;

                        //* start edit article*/
                        $checkout_mode = FALSE;
                        if ($current_stage_detials->aflw_status == 'u' && $current_stage_detials->jwf_assignment == 'self_service' && $current_stage_detials->jwf_stage_type != 'resubmission' && isset($user_roles['role_id']) && in_array($current_stage_detials->jwf_role_id, $user_roles['role_id']) && $article_data->art_status != 't' && ($current_stage_detials->role_assigned_role != 'author' || ($current_stage_detials->role_assigned_role == 'author' && $current_stage_detials->aflw_usr_id == $current_user['user_id'])) && $article_privilages['proxy_non_privilaged'] == FALSE) {
                            $checkout_mode = TRUE;
                        }

                        if ($article_privilages['author'] == TRUE && $current_stage_detials->aflw_status == 'a') {

                            if ($article_data->art_submitted_by == $current_user['user_id'] && (in_array($current_stage_detials->jwf_stage_type, array(
                                'author_submission',
                                'resubmission'
                            )) || ($current_stage_detials->jwf_stage_type == 'revision' && $current_stage_detials->jwf_article_editable == TRUE) || ($article_data->art_transfer_status == 'y'))) {

                                if ($current_stage_detials->aflw_status != 'c') {
                                    $return_data['article_edit_sections'] = TRUE;
                                    $return_data['article_edit_mode'] = TRUE;
                                }
                            }
                        } else if ($article_privilages['privilaged'] == TRUE && $article_type_advance->jp_edit_articles != NULL && (!in_array($article_data->art_status, array(
                            'r',
                            'c'
                        ))) && count(array_intersect(json_decode($article_type_advance->jp_edit_articles), $user_roles['role_id'])) > 0 && $checkout_mode == FALSE) {


                            $return_data['article_edit_mode'] = TRUE;
                            $edit_article = TRUE;

                        }

                        if( isset($return_data['article_edit_mode'])&&( $return_data['article_edit_mode']==TRUE))
                        {

                            $user_access=TRUE;
                        }
                        if (isset($article_privilages['author'])&&$article_privilages['author'] == TRUE||isset($article_privilages['user_allocated'])&&$article_privilages['user_allocated'] == TRUE||isset($article_privilages['privilaged'])&&$article_privilages['privilaged'] == TRUE||isset($article_privilages['reviewer'])&&$article_privilages['reviewer'] == TRUE)
                        {

                            $user_access=TRUE;
                        }


                    }
                    if($user_access==FALSE)
                    {
                        $array_data['user_id']=$current_user['user_id'];
                        $checkuserdiscussion= $this->check_discussionparticipient_user($array_data);
                        if($checkuserdiscussion==TRUE)
                        {
                          $user_access=TRUE;
                        }
                    }


                }

        return $user_access;
    }
    //used to conver string content to xml
	public function filter_html_contents($contents, $html_to_xml = FALSE, $root_node = NULL)
	{
		//$contents = strip_tags($contents);
		//$contents = str_replace('&nbsp;', ' ', $contents);
		if ($html_to_xml == TRUE)
		{
			$contents = $this->convert_html_to_xml($contents, $root_node);
		}
		else
			$contents = htmlentities($contents, ENT_XML1);

            return $contents;
        }
        public function get_ftp_data($select, $criteria, $groupBy=NULL)
        {
            $FtpTable = (new \App\Models\Ftp())->getTable();
            $FtpMasterTable = (new \App\Models\Ftp_master())->getTable();
            $tables = array(
                'main_table' => $FtpTable,
                'join_table' => array(
                    $FtpMasterTable => array($FtpTable . '.ftp_ftpm_id', $FtpMasterTable . '.ftpm_id', "inner")
                )
            );
            $ftp_data = Ftp::get_results_using_joins($tables, $select, $criteria, 'all', NULL, NULL, '', NULL, NUll, FALSE , $groupBy);
            return  $ftp_data;
        }
    public function convert_html_to_xml($string, $doc, $node = NULL, $node_id = NULL)
	{
		if ($node_id == NULL)
			$node_id = 'temp_id';

		$avoid_string = '<sup><a><sub><i><u><b><p><strong><em>';
		$string = strip_tags($string, $avoid_string);
		$string = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i", '<$1$2>', $string);

		/* Some previous article has div tag instead of p, and creates dtd validation error. Eg: in bmj staging article - bmjos-2018-000004 */
		if ($node_id == 'abstract_content')
		{
			if (substr(trim($string), 0, 2) != '<p')
			{
				$string = '<p>' . $string . '</p>';
			}
		}

		$string = preg_replace("/& /", "&amp; ", $string);//Bug #2043 - JPR-348 Two papers exported without titles in the xml
		$string = '<div id="' . $node_id . '">' . $string . '</div>';
		$string = preg_replace("/\&nbsp;/", " ", $string);
		$string = preg_replace('/<br[^>]*>/', "", $string);

		$string = preg_replace_callback('/&(\w+);/', function($match)
		{
			if (in_array($match[1], array(
					'amp',
					'lt',
					'gt',
					'quot',
					'apos')))
				return $match[0];
			else
				return html_entity_decode($match[0], ENT_COMPAT, 'UTF-8');
		}, $string);
		$htmldoc = new \DOMDocument();
		$htmldoc->formatOutput = false;

		$htmldoc->loadXML($string);
		$htmlxpath = new \DOMXpath($htmldoc);

		// $html_elm_array = $this->utility->review_xml_tags;
        $html_elm_array = UtilityTrait::Utility('review_xml_tags');

		foreach ($html_elm_array as $key => $val)
		{
			$html_elements = $htmlxpath->query("//{$key}");
			/* do in reverse order so that nested childs will also get converted before its parent element */
			for ($i = ($html_elements->length - 1); $i >= 0; $i--)
			{
				$cur_html_elm = $html_elements->item($i);

				$new_tag = $htmldoc->createElement($val);

//				$strtempid = $this->get_id($cur_html_elm, $greatest_id, $doc, $sti);
//				$new_tag->setAttribute("id", $strtempid);

				$this->html_child_to_xml($cur_html_elm, $new_tag);
			}
		}

		if ($node != NULL)
		{
			$abstract_div_cont = $htmlxpath->query('//div[@id="' . $node_id . '"]');
			$abstract_div = $abstract_div_cont->item(0);
			foreach ($abstract_div->childNodes as $childs)
			{
				$new_node = $doc->importNode($childs, true);
				$node->appendChild($new_node);
			}
			return "";
		}
		else
		{
			return $htmldoc->saveHTML();
		}



		/*  for ($k = 0; $k < count($html_elm_array); $k++)
		  {
		  $html_elements = $htmlxpath->query("//{$html_elm_array[$k]}");
		  for ($i = ($html_elements->length - 1); $i >= 0; $i--)
		  {
		  $cur_html_elm = $html_elements->item($i);

		  $new_tag = $htmldoc->createElement($xml_elm_array[$k]);


		  $strtempid = $this->get_id($cur_html_elm, $greatest_id, $doc, $sti);

		  $new_tag->setAttribute("id", $strtempid);

		  $this->html_child_to_xml($cur_html_elm, $new_tag);
		  }
		  } */
	}

    public function html_child_to_xml($cur_html_elm, $new_tag, $skip_text_nodes = FALSE)
	{
		if ($cur_html_elm->nodeName == "a") {
			$new_tag->setAttribute("xlink:href", $cur_html_elm->getAttribute('href'));
		}
		for ($k = 0; $k < $cur_html_elm->childNodes->length; $k++) {
			$childnode = $cur_html_elm->childNodes->item($k);
			if ($skip_text_nodes == TRUE && $childnode->nodeType === XML_TEXT_NODE && $childnode->nodeValue !== "–")
				continue;
			$new_tag->appendChild(clone ($childnode));
		}
		$cur_html_elm->parentNode->replaceChild($new_tag, $cur_html_elm);
	}

public function get_due_date($dateformat, $artp_hard_enddate)
{

    $end_date = date_create($artp_hard_enddate);
    $current_date = date_create(date('Y-m-d'));
    $overdue = '';
    if ($end_date < $current_date) {
        $interval = date_diff($end_date, $current_date);
        if (!empty($interval)) {
            $year = $interval->y;
            $month = $interval->m;
            $day = $interval->d;
            if ($year > 0) {
                if ($year == 1)
                    $overdue .= '1 Year ';
                else
                    $overdue .= $year . ' Years ';
            }

            if ($month > 0) {
                if ($month == 1)
                    $overdue .= '1 Month ';
                else
                    $month .= $year . ' Months ';
            }

            if ($day > 0) {
                if ($day == 1)
                    $overdue .= '1 Day';
                else
                    $overdue .= $day . ' Days';
            }
        }
    }
    return $overdue;
}

public function validatecode($validarray,$encrypt=false,$rvdecrypt=false){
    $return = array();
    if(array_key_exists('jnl_code',$validarray)){
        $return['jnl_code']=false;
        $jnl_code=$validarray['jnl_code'];
        if($encrypt) {
            $jnl_code=$this->decrypt_data($validarray['jnl_code']);
        }
        if($rvdecrypt) {
            $jnl_code=Rv_decrypt($validarray['jnl_code']);
        }
        $check_code_type = ctype_alpha($jnl_code);
        if(env('VITE_CONFERENCE_PROCEEDINGS') === true)
        {
            $check_code_type = ctype_alnum($jnl_code);
        }
        if($check_code_type) {
            $temp_jrnl = Journals::get_single_record_with_bind_cond('jnl_journal_code', array('jnl_journal_code'=>$jnl_code) );
            if(!empty($temp_jrnl)) {
                $return['jnl_code']=true;
            }
        }

    }
    if(array_key_exists('jnl_id',$validarray)){
        $return['jnl_id']=false;
        $jnl_id=$validarray['jnl_id'];
        if($encrypt) {
            $jnl_id=$this->decrypt_data($validarray['jnl_id']);
        }
        if($rvdecrypt) {
            $jnl_id=Rv_decrypt($validarray['jnl_id']);
        }
        $temp_jrnl = Journals::get_single_record_with_bind_cond('jnl_id', array('jnl_id'=>$jnl_id) );
        if(!empty($temp_jrnl)) {
            $return['jnl_id']=true;
        }
    }
    if(array_key_exists('abbr_article_type',$validarray)){
        $return['abbr_article_type']=false;
        $abbr_article_type=$validarray['abbr_article_type'];
        if($encrypt) {
            $abbr_article_type=$this->decrypt_data($validarray['abbr_article_type']);
        }
        if($rvdecrypt) {
            $abbr_article_type=Rv_decrypt($validarray['abbr_article_type']);
        }
        $result = Article_types::get_single_record_with_bind_cond('artp_abbr_article_type', array('artp_abbr_article_type'=>$abbr_article_type) );
        if(!empty($result)) {
            $return['abbr_article_type']=true;
        }
    }
    if(array_key_exists('role_assigned_role',$validarray)){
        $return['role_assigned_role']=false;
        $role_assigned_role=$validarray['role_assigned_role'];
        if($encrypt) {
            $role_assigned_role=$this->decrypt_data($validarray['role_assigned_role']);
        }
        if($rvdecrypt) {
            $role_assigned_role=Rv_decrypt($validarray['role_assigned_role']);
        }
        $result = Roles::get_single_record_with_bind_cond('role_assigned_role', array('role_assigned_role'=>$role_assigned_role) );
        if(!empty($result)) {
            $return['role_assigned_role']=true;
        }
    }
    return $return;
}
public function get_custom_hostlist($jnl_id,$final_file_export=false)
        {
            $rtn_data = array();
            $select = 'ftp_is_default, ftpm_display_name as disply_name, ftpm_host_name as hostname,ftpm_user_name as username, ftpm_password as password, ftpm_location as location, ftpm_port as portno, ftpm_enable_private_key as enable_private_key, ftpm_private_key_path as private_key_path,ftp_ext_location as ext_location';
            $criteria = '';
            //Task #55(Taskbbot) Updated for issue final file upload.
            if($final_file_export == true)
            {
                $criteria = 'ftp_jnl_id='.$jnl_id.' AND ftp_jwf_id IS NULL AND ftp_ext_location="y"';
            }
            else
            {
                $criteria = 'ftp_jnl_id='.$jnl_id.' AND ftp_jwf_id IS NULL';
            }
            $ftp_data = $this->get_ftp_data($select, $criteria, $groupBy=NULL);
            if(!empty($ftp_data))
            {
                foreach ($ftp_data as $row)
                {
                    if($row->ftp_is_default == 'n')
                    {
                        $rtn_data[] = (array)$row;
                    }
                }
            }
            return $rtn_data;
        }
    //set path slash
	public function set_path_slash($path, $begin_sh = TRUE, $end_sh = TRUE)
	{
		$ftp_path = '';
		if ($path != '')
		{
			$first_char = substr($path, 0, 1);
			$last_char = substr($path, -1);

			if ($first_char != '/' && $begin_sh == TRUE)
				$ftp_path = '/' . $path;
			else
				$ftp_path = $path;

			if ($last_char != '/' && $end_sh == TRUE)
				$ftp_path = $ftp_path . '/';
		}
		return $ftp_path;
	}


// function written by shammer moved to my controller as this is using in managearticle api and mange viewarticle
public function transfer_article_create_new($article_id, $current_status_id, $author_without_confirmation = FALSE,$journa_id_input='',$journal_code='') {
    $this->current_user=$this->get_current_user_details();
    //$redirection_link = base_url('journal/' . $journal_code);
    if (!empty($article_id) && !empty($current_status_id) && !empty($journa_id_input)) {
        $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
        $Articles = new \App\Models\Articles();
        $Journals = new \App\Models\Journals();
        $Article_types = new \App\Models\Article_types();
        $Article_flow = new \App\Models\Article_flow();
        $Article_flag = new \App\Models\Article_flag();
        $Generic_flows = new \App\Models\Generic_flows();
        $Article_type_advance_options = new \App\Models\Article_type_advance_options();
        $Article_primary_classification = new \App\Models\Article_primary_classification();
        $Article_secondary_classification = new \App\Models\Article_secondary_classification();
        $Journal_terms = new \App\Models\Journal_terms();
        $Article_generic_form_data = new \App\Models\Article_generic_form_data();
        $Users = new \App\Models\User();
        $Email_templates = new \App\Models\Email_templates();


        $transfer_details = $Article_transfer_suggestion::get_single_record('*',"ats_art_id={$article_id} and ats_aflw_id={$current_status_id} and ats_src_jnl={$journa_id_input} ");
        //print_r($transfer_details); die;
        if (!empty($transfer_details)) {
            $article_id = $transfer_details->ats_art_id;
            $article_type = $transfer_details->ats_dst_artp;
            $journal_id = $transfer_details->ats_dst_jnl;
            $stage = $transfer_details->ats_dst_stage;
            $generic_data_transfer = TRUE;

            $transfer_mode = $transfer_details->ats_article_data; //1 - resubmit 2 - move to particular stage
            $author_action = $transfer_details->ats_author_action;

            if ($author_action == 1) { // Author accept Transfer article

                // $this->load->library('Sendemail', array(
                //     'client' => $this->current_client));
                // $this->load->library('email');
                // $this->load->library('utility');
                // $this->load->library('workflow');

                // $load_libraries['sendemail'] = $this->sendemail;
                // $load_libraries['email'] = $this->email;
                // $load_libraries['utility'] = $this->utility;

                $article_data = $Articles::get_article_data($article_id);
                $old_upload_path = $article_data->art_article_upload_path;
                $submited_user = array(
                    'user_id' => $article_data->art_submitted_by,
                    'proxy_user_id' => $article_data->art_submitted_by
                );
                $destination_journal_data = $Journals::get_single_record('jnl_journal_code',"jnl_id={$journal_id}");

                $source_journal_data = $Journals::get_single_record('jnl_journal_name',"jnl_id={$transfer_details->ats_src_jnl}");



                $destination_artp = $Article_types::get_single_record('artp_fwm_id',"artp_id={$transfer_details->ats_dst_artp}");
                //if transfer article in the same journal then no need to shift generic form data
                if ($destination_journal_data->jnl_journal_code == $article_data->jnl_journal_code) {
                    $generic_data_transfer = FALSE;
                }
                $transit_jwf_id = $Article_flow::get_single_record('aflw_jwf_id',"aflw_id={$current_status_id}");

                //* start -- db opterions*//
                //Article_flow::trans_start();
                //update rvw_article_flow tb
                if($destination_artp->artp_fwm_id != $article_data->artp_fwm_id) {

                    $condition ="(aflw_status = 'a' or aflw_status = 'w' or aflw_status = 'p') and aflw_art_id={$article_id} and aflw_id!={$current_status_id}";

                    $Article_flow::update_flow(array(
                        'aflw_status' => 'c',
                        'aflw_returned_date' => date('Y-m-d H:i:s'),
                        'aflw_posted_date' => date('Y-m-d H:i:s')
                        ), $condition);

                    $Article_flow::delete_records("aflw_art_id={$article_id} and aflw_status = 'u' ", '', $this->current_user);
                }

                if ($transfer_mode == 2) { // move trasnfer mode
                    //update article tb
                    //$new_article_code = $this->workflow->create_article_code($load_models, $article_type);
                    $old_article_update = array(
                        'art_transfer_article' => 'y',
                        'art_pdf_status' => 'n',
                        'art_status' => 't',
                        'art_transfer_status' => 'y',
                        'art_artp_id' => $article_type,
                        //'art_code' => $new_article_code
                    );
                    //update article tb
                    $Articles::update_record($old_article_update,"art_id={$article_id}", $this->current_user);

                    //update rvw_article_flag tb
                    $Article_flag::update_record(array(
                        'aflg_jnl_id' => $journal_id),"aflg_art_id={$article_id}", $this->current_user);

                    //insert in rvw_article_flow tb
                    $article_type_details = $Article_types::get_single_record('artp_fwm_id',"artp_id={$article_type}");

                    $flow_details = $Generic_flows::get_single_record('jwf_id',"jwf_fwm_id={$article_type_details->artp_fwm_id} and jwf_stage_type='transit' ");

                    //if ($author_without_confirmation == FALSE ) {
                        $Article_flow::update_flow(array(
                            'aflw_jwf_id' => $flow_details->jwf_id,
                            'aflw_operation' => 't',
                            'aflw_posted_date' => date('Y-m-d H:i:s'),// "t" operation to exclude it from timeline
                            ),"aflw_id={$current_status_id}");
                        //}


                    $new_article_id = $article_id;
                    $article_new_data = $Articles::get_article_data($new_article_id);

                    // Bug #1624 Add reviewers to article
                    $this->add_users_to_article($article_id, $article_new_data, 'reviewer');
                    // Bug #1624 Add reviewers to article

                    $new_upload_path = $article_new_data->jnl_journal_code . '/' . $article_new_data->artp_abbr_article_type . '/' . $new_article_id;
                    //update article tb
                    $Articles::update_record(array(
                        'art_article_upload_path' => $new_upload_path,
                        ),"art_id={$new_article_id}", $this->current_user);

                    $this->change_article_pdf_status($new_article_id,$this->current_user);

                    /* Classifications */

                    $Article_classification = new \App\Models\Article_classification;
                    $old_art_classification = $Article_classification::get_all_records('arcls_cls_id','arcls_art_id='.$article_id);
                    if(!empty($old_art_classification)) {
                        foreach($old_art_classification as $oc) {
                            $Article_classification::insert_record(array('arcls_cls_id'=>$oc->arcls_cls_id,'arcls_art_id'=>$new_article_id),$this->current_user);
                        }
                    }


                    //$new_art_advance = $Article_type_advance_options::get_single_record('atotp_primary_class,atotp_secondary_class',"atotp_artp_id={$article_new_data->artp_id}");
                    /*$article_primary_classificatios = $Article_primary_classification::get_article_class_primary($new_article_id);
                    $article_secondary_classificatios = $Article_secondary_classification::get_article_class_secondary($new_article_id);


                    if (!empty($article_primary_classificatios)) {
                        $Article_primary_classification::delete_records("atp_art_id={$new_article_id}");

                        if ($new_art_advance->atotp_primary_class == 'y') {
                            foreach ($article_primary_classificatios as $ap) {
                                $art_jnl_terms = $Journal_terms::get_single_record('jntm_id',"jntm_term_id={$ap->term_id} and jntm_artp_id={$article_new_data->artp_id} and jntm_type='p' ");
                                if (!empty($art_jnl_terms)) {
                                    $jnl_term_id = $art_jnl_terms->jntm_id;
                                }else {
                                    $insert_arry_primary = array(
                                        'jntm_jnl_id' => $this->jnl_data->jnl_id,
                                        'jntm_term_id' => $ap->term_id,
                                        'jntm_type' => 'p',
                                        'jntm_artp_id' => $article_new_data->artp_id);
                                    $jnl_term_id = $Journal_terms::insert_record($insert_arry_primary);
                                }
                                $Article_primary_classification::insert_record(array(
                                    'atp_art_id' => $new_article_id,
                                    'atp_tpc_id' => $jnl_term_id));
                            }
                        }
                    }

                    if (!empty($article_secondary_classificatios)) {
                        $Article_secondary_classification::delete_records("ats_art_id={$new_article_id}");
                        if ($new_art_advance->atotp_secondary_class == 'y') {
                            foreach ($article_secondary_classificatios as $ap) {
                                $art_jnl_terms = $Journal_terms::get_single_record('jntm_id',"jntm_term_id={$ap->term_id} and jntm_artp_id={$article_new_data->artp_id} and jntm_type='s' " );
                                if (!empty($art_jnl_terms)) {
                                    $jnl_term_id = $art_jnl_terms->jntm_id;
                                } else {
                                    $insert_arry_primary = array(
                                        'jntm_jnl_id' => $this->jnl_data->jnl_id,
                                        'jntm_term_id' => $ap->term_id,
                                        'jntm_type' => 's',
                                        'jntm_artp_id' => $article_new_data->artp_id);
                                    $jnl_term_id = $Journal_terms::insert_record($insert_arry_primary);
                                }
                                $Article_secondary_classification::insert_record(array(
                                    'ats_art_id' => $new_article_id,
                                    'ats_kwd_id' => $jnl_term_id));
                            }
                        }
                    }*/

                } else { // copy trasnfer mode
                    if($author_without_confirmation == FALSE) {
                        $Article_flow::update_flow(array(
                            'aflw_status' => 'c',
                            'aflw_returned_date' => date('Y-m-d H:i:s'),
                            'aflw_posted_date' => date('Y-m-d H:i:s'),
                            ),"aflw_id={$current_status_id}");

                        /*Task #2285 The 'On Complete' email is not triggered when the user selects 'Resubmit New Data' during the transfer process.
                          get transit complete email template */
                       if (!empty($transit_jwf_id))
                       {  // Fetch email template
                           $Stage_email_templates = new \App\Models\Stage_email_templates();
                           $email_template =  $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_action,stage_etmp_to,stage_etmp_id', "stage_etmp_action = 'completed' AND setr_jwf_id = {$transit_jwf_id->aflw_jwf_id}");                          
                           if (!empty($email_template))
                            {
                                foreach ($email_template as $template)
                                {
                                    if (isset($transfer_details->ats_src_artp, $article_data->jnl_id, $article_data->jnl_journal_code, $article_data->art_submitted_by)) 
                                    {
                                        $custom_data = array(
                                            'prev_article_id'=> $article_id,
                                            'article_id'=> $article_id,
                                            'artp_id'=> $transfer_details->ats_src_artp,
                                            'stage_etmp_action' => $template->stage_etmp_action,
                                            'stage_etmp_to'     => $template->stage_etmp_to,
                                            'template_id'     => $template->stage_etmp_id,
                                            'jnl_id'=>$article_data->jnl_id,
                                            'jnl_code'=>$journal_code,
                                            'src_jnl_id'=>$article_data->jnl_id,
                                            'aflw_id'=>$current_status_id,
                                        );
                                        $email_data = array(
                                            'type' => 'stage',
                                            'action' => 'send',
                                            'aflw_id'=>$current_status_id,
                                            'email_with_login' => TRUE,
                                            'user_id' => $article_data->art_submitted_by,
                                            'jnl_user_role'=>array(
                                            'core_role'=>'',
                                            'role_name'=>'',
                                            'jnl_journal_code'=> $journal_code
                                        ),
                                            'custom_data' => $custom_data
                                        );
                                        
                                        
                                        $this->master_email_details($email_data);
                                    }
                                }
                            }
                        }

                    }
                    $old_article_update = array(
                        'art_status' => 'c',
                        "art_decision_date" => date('Y-m-d H:i:s')
                    );
                    //update article tb
                    $Articles::update_record($old_article_update,"art_id={$article_id} ", $this->current_user);

                    //*********************

                    $old_article_id = $article_id;
                    //create new article
                    $new_article_id = $this->create_article_copy($old_article_id,$this->current_user,$article_type,TRUE, $this->current_client);
                    /* Task #196-10096 Starts */
                    $article_tab_status = Article_tab_status::get_single_record_with_bind_cond('tab_status_transfer_bit',['tab_status_art_id' => $new_article_id]);
                    if(isset($article_tab_status->tab_status_transfer_bit) && $article_tab_status->tab_status_transfer_bit == 'n'){
                        $art_submission_tab=array('tab_article_details'=>'p','tab_co_author'=>'','tab_attach_files'=>'', 'tab_review_preference'=>'', 'tab_payment_info' =>'','tab_additional_info'=>'');
                        Article_tab_status::update_record(array(
                            "tab_status_array" => json_encode($art_submission_tab),"tab_status_transfer_bit" => "y"),"tab_status_art_id=?", $this->current_user,binding_arr:[$new_article_id]);
                    }
                    /* Task #196-10096 Ends */
                    $article_new_data = $Articles::get_article_data($new_article_id);
                    if ($article_data->art_attachment_order != '') {

                        $article_table = (new \App\Models\Articles())->getTable();
                        $attachment_files_table = (new \App\Models\Attachment_files())->getTable();

                        $sql = "UPDATE {$article_table} SET art_attachment_order=(SELECT GROUP_CONCAT(`atmnt_id` SEPARATOR ',') FROM {$attachment_files_table} WHERE `atmnt_art_id`=" . $new_article_id . ") WHERE art_id=" . $new_article_id;
                        $Articles::get_records_by_raw_query($sql);
                    }

                    $article_flag_table = (new \App\Models\Article_flag())->getTable();

                    //insert rvw_article_flag db
                    //$this->Article_flag->copy_article_flag($old_article_id, $new_article_id, $journal_id);

                    $today = date('Y-m-d H:i:s', time());
                    $sql = "INSERT INTO {$article_flag_table} (aflg_flag_id,aflg_art_id,aflg_jnl_id,aflg_posted_by,aflg_posted_date,aflg_proxy_id) SELECT aflg_flag_id," . $new_article_id . "," . $journal_id . ",aflg_posted_by,'" . $today . "',aflg_proxy_id FROM {$article_flag_table} WHERE aflg_art_id=" . $old_article_id;
                    $Article_flag::get_records_by_raw_query($sql);

                    //insert rvw_article_flow db
                    $aflw_usr_id = $this->current_user['user_id'];
                    if($author_without_confirmation == TRUE) {
                        $aflw_usr_id = $article_data->art_submitted_by;
                    }

                    $first_stage = $Generic_flows::get_single_record('*',"jwf_fwm_id={$article_new_data->artp_fwm_id} and jwf_parent_stages='[]'");

                    $insert_array = array(
                        'aflw_art_id' => $new_article_id,
                        'aflw_jwf_id' => $first_stage->jwf_id,
                        'aflw_usr_id' => $aflw_usr_id,
                        'aflw_assigned_date' => $today,
                        'aflw_accepted_date' => $today,
                        'aflw_status' => 'a',
                        'aflw_remarks' => 'Article submission begins'
                    );
                    $aflw_id = $Article_flow::insert_record($insert_array, $this->current_user);

                    //$stage_move_result = $this->workflow->move_next_stage($new_article_id, $submited_user, $load_models, $article_new_data->artp_fwm_id, NULL, NULL, FALSE, $article_type, $load_libraries, FALSE, FALSE, TRUE, NULL, $this->current_client, NULL, $this->jnl_data->jset_reply_to_email);
                    //*UPDATE GENERIC FORM*//
                    $Article_generic_form_data::update_newarticle_gen_formdata($new_article_id, "_" . $destination_journal_data->jnl_journal_code);
                    //$new_submission_flow = $this->Article_flow->get_single_record('aflw_id',array('aflw_art_id'=>$new_article_id));
                    //$aflw_id = $new_submission_flow->aflw_id;
                }

                //if($author_without_confirmation == FALSE){
                $new_article_update = array(
                    'art_status' => 't',
                    'art_transfer_status' => 'y',
                );

                $Articles::update_record($new_article_update,"art_id={$new_article_id}", $this->current_user);

                //}
                /* Bug  Add authors to article */
                $this->add_users_to_article($article_id, $article_new_data, 'author');
                /* Bug  Add authors to article */


                //TASK #666 - without author confirmation
                if ( $author_without_confirmation == TRUE && $this->current_client->functionality->cfty_allow_transfer_without_au_confirmation == 'y' ) {
                    // $this->load->model(array(
                    //     'Email_templates',
                    //     'user/Roles',
                    //     'Batch_id_generate'));
                    $user_data = $Users::get_single_record('usr_email,concat(usr_first_name," ",usr_last_name) as fullname',"usr_id={$article_data->art_submitted_by}" );

                    if( $transfer_mode == 1 ) {
                        $email_template_transfer = 'transfer_article_without_author_confirmation_resubmit';
                    }elseif($transfer_mode == 2) {
                        $email_template_transfer = 'transfer_article_without_confirmation';
                    }

                    $email_template_data = $Email_templates::get_single_record('*',"etmp_name='".$email_template_transfer."' and etmp_notification='User'");

                    if (!empty($email_template_data)) {
                        //$transfer_link =  URL::to('/') . '/' . $this->current_client->platform_type . '/' . $article_new_data->jnl_journal_code . '/' . $article_new_data->artp_abbr_article_type . '/edit-article/' . encrypt_link($new_article_id) . '?status=transfer';
                        $newflowdetails=Article_flow::check_articlesubmission($new_article_id);
                        $transfer_link = $article_new_data->jnl_journal_code . '/' . $article_new_data->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($new_article_id) .'/'.$this->encrypt_data($newflowdetails->aflw_id) ;

                        $custom_data = array(
                            'usr_email'=>$user_data->usr_email,
                            'mail_recipient_ids'=> $article_data->art_submitted_by,

                             'esl_etmp_action'=>'transfer_article',
                             'transfer_article'=>True,
                             'prev_article_id'=> $article_id,
                             'article_id'=> $article_id,
                             'artp_id'=> $transfer_details->ats_src_artp,
                             'jnl_id'=>$transfer_details->ats_src_jnl,
                             'jnl_code'=>$journal_code,
                             'src_jnl_id'=>$transfer_details->ats_src_jnl,
                             'aflw_id'=>$current_status_id,
                             'transfer_link'=>$transfer_link
                         );
                         $email_data = array(
                             'type' => 'global',
                             'action' => 'send',
                             'email_with_login' => TRUE,
                             'user_id' => $article_data->art_submitted_by,
                             'empt_name' => $email_template_transfer,
                             'jnl_user_role'=>array(
                             'core_role'=>'',
                             'role_name'=>'',
                             'jnl_journal_code'=> $journal_code
                         ),
                             'custom_data' => $custom_data
                         );
                         $this->master_email_details($email_data);

                    }
                }

                // end without author confirmation

                //* start -- move article attachments*//

                $copy_flag = FALSE;

                if ($transfer_mode == 2) {

                        //$copy_flag = $this->workflow->copyfolder("uploads/" . $old_upload_path, "uploads/" . $new_upload_path);
                        //1.Upgrade #2293 Manage review uploads

                        $new_upload_pathdata ="public/uploads/".$new_upload_path;
                        $this->addDireactory($new_upload_pathdata);
                        $files = File::allFiles(storage_path()."/app/public/uploads/".$old_upload_path);
                        //print_r($files);die;
                        if (sizeof($files) > 0) {

                            foreach ($files as $file) {

                                $path_info = pathinfo($file);

                                $file_name = $path_info['filename'] . '.' . $path_info['extension'];
                                if ($this->current_client->enable_upload_s3_bucket == 'y') {
                                    $s3_path= env('AWS_BUCKET')."/uploads" . DIRECTORY_SEPARATOR . $new_upload_path;
                                    Storage::disk('s3')->putFileAs($s3_path,$file, $file_name);
                                    Storage::disk('public')->putFileAs("uploads/".$new_upload_path,$file, $file_name);
                                }
                                else
                                {
                                    Storage::disk('public')->putFileAs("uploads/".$new_upload_path,$file, $file_name);
                                }
                            }
                        }


                        $Attachment_files = new \App\Models\Attachment_files();
                        $attach_files = $Attachment_files::get_all_records('atmnt_file_name',"atmnt_art_id={$new_article_id}");
                        if (!empty($attach_files)) {

                             //$new_path = APP_DOC_PATH . $new_upload_path;
                             foreach ($attach_files as $attach_file)
                             {
                                 $file_loc = $new_upload_path . '/' . $attach_file->atmnt_file_name;
                                 $file_path = public_path() . '/storage/uploads/' . $new_upload_path . "/";
                                 $aws_path="uploads/" . $new_upload_path . "/";
                                 if ($attach_file->atmnt_file_name != '' && Storage::exists($file_loc))
                                 {
                                    $this->remove_fileinfolder($file_loc,$attach_file->atmnt_file_name,$aws_path);
                                    /*if (is_dir($file_loc))
                                     {
                                         $this->delfolder($file_loc);
                                     }
                                     else
                                     {
                                         unlink($file_loc);
                                     }*/
                                 }
                             }
                         }

                    }


                    $result['msg']='copy_article_success';


            }

            if ($transfer_mode == 2) {
                $redirection_link = $journal_code . '/author-article/'.$this->encrypt_data($article_id) .'/' .$this->encrypt_data($current_status_id);
                $result['reloadpage']=true;
            } else {
                $newflowdetails=Article_flow::check_articlesubmission($new_article_id);
                if(!empty($newflowdetails) && $newflowdetails->jwf_stage_type=='author_submission') {
                //$redirection_link = $article_new_data->jnl_journal_code . '/' . $article_new_data->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($new_article_id) . '?status=transfer';
                $redirection_link = $article_new_data->jnl_journal_code . '/' . $article_new_data->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($new_article_id) .'/'.$this->encrypt_data($newflowdetails->aflw_id) ;
                }
                $result['reloadpage']=false;
            }
        }
        else
        {
            $result['msg']='not_valid_frm';
            //return $this->success('Success', 200, $result);
            // $this->session->set_flashdata('msg', json_encode(array(
            //     'alert' => 'error',
            //     'msg' => lang('not_valid_frm'))));
        }
    }
    else
    {
        $result['msg']='not_valid_frm';
         //   return $this->success('Success', 200, $result);
        // $this->session->set_flashdata('msg', json_encode(array(
        //     'alert' => 'error',
        //     'msg' => lang('not_valid_frm'))));
    }

    if($author_without_confirmation == FALSE){
        $result['redirection_link']=$redirection_link;
        return $result;
        //return $this->success('Success', 200, $result);
    }
}
public function add_users_to_article($article_id, $article_new_data, $role = 'reviewer') {
    $journal_id = $article_new_data->jnl_id;
    $article_users = array();
    if ($role == 'reviewer') {
        $articleflow_table = (new \App\Models\Article_flow())->getTable();
        $genericflows_table = (new \App\Models\Generic_flows())->getTable();
        $sql = 'SELECT aflw_usr_id as user_id,jwf_role_id as role_id FROM ' . $articleflow_table . ' as aflw JOIN ' . $genericflows_table . ' as jwf ON aflw_jwf_id = jwf_id WHERE aflw_art_id =' . $article_id . ' AND jwf_stage_type = "review" AND aflw_status !="d" AND aflw_usr_id IS NOT NULL';

        $article_users = Article_flow::get_records_by_raw_query($sql);
    }
    if ($role == 'author') {
        $Authors = new \App\Models\Authors();
        $author_role = Roles::get_single_record('role_id', "role_assigned_role='author'");
        $article_users = $Authors::get_all_records('auth_usr_id as user_id,' . $author_role->role_id . ' as role_id', 'auth_art_id=' . $article_id);
    }

    if (!empty($article_users)) {
        foreach ($article_users as $art) {
            $User_to_journals = new \App\Models\User_to_journals();
            $user_in_journal = $User_to_journals::find_user_in_journal($article_new_data->jnl_id, $art->user_id, $role, $article_new_data->artp_id, $art->role_id);

            $user_in_journal=count($user_in_journal)>0?$user_in_journal['0']:[];
            // die(print_r($user_in_journal));
            // $query = DB::getQueryLog();
            // $query = end($query);
            // print_r($query);exit;

            $insert_fields = array(
                'usrj_jnl_id' => $journal_id,
                'usrj_usr_id' => $art->user_id,
                'usrj_role_id' => $art->role_id
            );
            if ($user_in_journal->user_in_jnl == 0) { //add user in journal
                $User_to_journals::insert_record($insert_fields, $this->current_user);
            }

            if ($user_in_journal->user_in_artp == 0) { //add user in article type
                $insert_fields['usrj_artp_id'] = $article_new_data->artp_id;
                $User_to_journals::insert_record($insert_fields, $this->current_user);
            }
        }
    }
}
/*
select and multi select check value exist
*/

public function select_array_exist($post_data=array(),$genderconfigkey=array())
    {
            $url  =   '';
            $select_string=implode(',',$post_data['select']);
            $select_array=explode(',',$select_string);
            if(isset($post_data['url']))
                  $url  =   decrypt_link($post_data['url']);

            if(!empty($select_array)) {
                foreach($select_array as $select) {
                  if (!in_array($select,$genderconfigkey)) {
                    continue;
                  }

                  if($select == 'subjects') {
                      if($url == '/login')
                          $select =   'feedback_subjects_login';
                      else
                          $select =   'feedback_subjects';
                  }
                  $main_array[$select]=$this->UserConfigdata($select)[$select];
                }

            }
            return $main_array;
    }

    /*
    #2357 Function to show the google analytics data in login form and inside pages
    */
    public static function show_google_analytics_data($script)
    {
        $header_script  =   '';
        $body_script    =   '';
        $_this          =   new self;
        if(isset($_this->current_client->settings->cs_google_analytics_id) && $_this->current_client->settings->cs_google_analytics_id != NULL) {
            $cs_gs_data     =   json_decode($_this->current_client->settings->cs_google_analytics_id);
            $page           =   $_SERVER['REQUEST_URI'];
            // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
            $sudo_urls      =   array(
                                    '/sudo',
                                    '/sudo_dashboard',
                                    '/client_funtionalities',
                                    '/client_fieldvalidation',
                                    '/debug_site',
                                    '/client',
                                    '/manage_downtime',
                                    '/manage_faq',
                                    '/manage_analytics',
                                );
            if (!in_array($page, $sudo_urls)) {
                if($script == 'header_script') {
                    $i  =   0;
                    foreach($cs_gs_data as $val)
                    {
                        if($i > 0) {
                            $header_script  .=   '<br/>';
                        }
                        $header_script .=   $val->header_script;
                        $i++;
                    }
                }
                if($script == 'body_script') {
                    $j  =   0;
                    foreach($cs_gs_data as $val)
                    {
                        if($j > 0) {
                            $body_script  .=   '<br/>';
                        }
                        $body_script  .=   $val->body_script;
                        $j++;
                    }
                }
            }
        }
        if($script == 'header_script')
            return $header_script;
        else
            return $body_script;
    }
    public static function standalonecheck($url=null)
    {
        $Journals=new \App\Models\Journals();
        $jrnl_grp = null;
        $first_part = null;
        $url_arr = array();
        $hostname = env('APP_URL');
        if (isset($_SERVER['HTTP_HOST'])) {
            $url_str = $_SERVER['HTTP_HOST'];
            $url_arr = explode('.', $url_str);
        }

        if (count($url_arr) === 4) {
            $first_part = $url_arr[0];
        }
        if ($first_part != NULL)
        {
                if($first_part =='127')
                {
                    $port = $_SERVER['SERVER_PORT'];
                    return "http://127.0.0.1:$port";
                }
                if ($first_part  == 'controlpanel')
                {
                    $jrnl_grp = $first_part;
                }
                else
                {
                $url=$first_part;
                $criteria =array('jnl_standalone_group'=>$url);
                $jrnl_grp = $Journals::get_single_record_with_bind_cond('*',$criteria );
                if(!empty($jrnl_grp))
                {
                    $hostname = env('APP_URL');
                    $url = $hostname;
			        $transformedUrl = str_replace('https://', 'https://'.$first_part.'.', $hostname);
                    return $transformedUrl;
                }
                {
                    return $hostname;
                }

            }

         }
         return $hostname;
    }

    public function check_view_article_on_submission($condition_arr)
    {
        $return_status = FALSE;
        $client_details = $this->get_client_details();
        $client_code = $client_details->clnt_client_code;
        $client_functionality = $this->get_client_functionalities($client_details->clnt_id, $client_code);
        if(isset($client_functionality->cfty_submission_inprogress_view_article) &&  $client_functionality->cfty_submission_inprogress_view_article == 'y')
        {
            if($this->current_client->modules->mdl_conference == 'y'){
                return true;
            }
            $jnl_art_view_perm = Journal_settings::get_single_record('jset_view_article_on_submission', "jset_jnl_id = '{$condition_arr['jnl_id']}' ")->jset_view_article_on_submission;
            if($jnl_art_view_perm !== NULL)
            {
                $viewable_roles_artcle_submission = json_decode($jnl_art_view_perm);
                if(in_array($condition_arr['role_id'],$viewable_roles_artcle_submission))
                {
                    $return_status = TRUE;
                }
            }
        }

        return $return_status;

    }


    public function get_updated_gdata($check_gdata_exist,$existdata,$article_id,$atotp_review_method,$last_posted_date,$formatted_journal_code,$jnl_id, $atotp_review)
	{
		if(!empty($existdata))
		{
			$check_gdata_exist =json_encode($check_gdata_exist);
			$gdata_exist_arr = json_decode($check_gdata_exist,TRUE);
			$gdata =array_column($gdata_exist_arr, 'emt_id');
            $jnl_code = (new Journals())::select('jnl_journal_code')->where('jnl_id', $jnl_id)->get()->first()?->jnl_journal_code;
			foreach ($existdata as $data)
			{
				$content='';
				$ele_cond = 'emt_id='.$data->gdata_atfemt_id;
                $Generic_form_elements = new \App\Models\Generic_form_elements();
                $Article_generic_form_data = new \App\Models\Article_generic_form_data();
				$elements = $Generic_form_elements::get_single_record('emt_source_elementid,emt_populate_data,emt_tinymce_required',$ele_cond);
                // TASK #8406 Custom Form Not Displayed After Rescinding and Error on View Article
                if(empty($elements)){
                    $sql = 'SELECT emt_source_elementid,emt_populate_data,emt_tinymce_required from '.$Generic_form_elements::$tbk_table.' WHERE emt_id = '.$data->gdata_atfemt_id.' and emt_posted_date<="'.$data->gdata_posted_date.'"  order by tbk_id DESC limit 1';
                    $result = DB::select($sql);
                    $elements=!empty($result)?$result[0]:'';
                }
				if($elements->emt_populate_data == 1)
				{
					$form_stage_type='';
					$emt_keys =array_keys($gdata,$elements->emt_source_elementid);
					$l=NULL;
					$cnt=0;
					foreach($emt_keys as $emt_key)
					{
						$ele_data = $gdata_exist_arr[$emt_key];
						$elemnts_data=(object) $ele_data;
						$sql = "select gncf_form_type from rvw_generic_forms where gncf_id=".$ele_data['emt_gucf_id'];
				
						$form_type = Articles::get_records_by_raw_query($sql);
						$form_stage_type =$form_type[0]->gncf_form_type;
						if($form_stage_type == 'review' && (($atotp_review_method != 'o' && $atotp_review_method != 'c') || ($this->is_custom_blinded('author', $article_id, jnl:$jnl_code)))){
							if($cnt==0)
							{
							//sah posted date nu munnae ethra review vannitund ennu nokkukka ennittu athintae koodae onnu plus cheyuka.. ithil already vaanitundel athum edukkam
							$gdatacond = "gdata_posted_date <'".$last_posted_date."' and gdata_art_id=".$article_id." and gdata_atfemt_id=".$elements->emt_source_elementid;
							$result=$Article_generic_form_data::get_generic_form_stage_elements($formatted_journal_code,'count(gdata_artflw_id) as datacount',$gdatacond);
							$cnt=$result[0]->datacount;
							$l=$cnt+1;
							}
							$content.='';
							$content.=$this->get_element_content($elements, $jnl_id, $atotp_review_method, $article_id, $form_stage_type, $elemnts_data, $l, $atotp_review);
						}
						else
						{
						$content.=$this->get_element_content($elements, $jnl_id, $atotp_review_method, $article_id, $form_stage_type, $elemnts_data, $l, $atotp_review);
						}
						if($l>0)
						{
						$l++;

						}
					}
				}
				//echo $data->gdata_data;
				//echo '<br/>';
				$data->gdata_data=$data->gdata_data.$content;
				//echo $data->gdata_data;
			}
		}
		return $existdata;
	}



    public function get_element_content($element_data,$jnl_id,$atotp_review_method,$article_id,$form_stage_type,$gdata,$l=NULL, $atotp_review) {
		$gdatadt_content='';
		if($element_data->emt_tinymce_required == TRUE) {
			if(!empty($l)) {
				if(!empty($atotp_review_method) && isset($form_stage_type) && ($form_stage_type == 'review' && (($atotp_review_method != 'o' && $atotp_review_method != 'c') || ($this->is_custom_blinded('reviewer', $article_id, jnl:$jnl_id, blinded_user: $gdata->gdata_posted_by))))) {
					$gdatadt_content.='<p><strong>Reviewer #'.$l.'</strong></p>';
				} else{
                     // TASK #9095 Article Showing Error with ViewFormDemo API After Two More Reviews
                    $array_data=array('user_id'=>$gdata->gdata_posted_by,'journal_id'=>$jnl_id,'flag'=>FALSE,
                    'article_id'=>$article_id,
                    'availability'=>FALSE,
                    'fullname_only'=>TRUE,
                    );
                    $user_disp_name=$this->get_user_display_name($array_data);
					$gdatadt_content.='<p><strong>'.$user_disp_name['fullname'].'</strong></p>';
				}
			}
			$gdatadt_content.=$gdata->gdata_data;
		} else {
			if($l>1) {
				$gdatadt_content.='&#13;&#10;';
			}
			if(!empty($l)) {
				if(!empty($atotp_review_method) && isset($form_stage_type) && ($form_stage_type == 'review' && (($atotp_review_method != 'o' && $atotp_review_method != 'c') || ($this->is_custom_blinded('reviewer', $article_id, jnl:$jnl_id,blinded_user: $gdata->gdata_posted_by))))) {
					$gdatadt_content.='Reviewer #'.$l;
					$gdatadt_content.='&#13;&#10;';
				} else{
                    // TASK #9095 Article Showing Error with ViewFormDemo API After Two More Reviews
                    $array_data=array('user_id'=>$gdata->gdata_posted_by,'journal_id'=>$jnl_id,'flag'=>FALSE,
                    'article_id'=>$article_id,
                    'availability'=>FALSE,
                    'fullname_only'=>TRUE,
                    );
                    $user_disp_name=$this->get_user_display_name($array_data);
					$gdatadt_content.=$user_disp_name['fullname'];
					$gdatadt_content.='&#13;&#10;';
				}
			}
			$original_data=str_replace("<p>","",$gdata->gdata_data);
			$original_data=str_replace("</p>", "", $original_data);
			$gdatadt_content.=$original_data;
			$gdatadt_content.='&#13;&#10;';
			//$gdatadt_content.=$gdata->gdata_data;
		}
		return $gdatadt_content;
	}
    // for searching classification
    public function search_classificationdata($searchData=NULL,$checkedData=NULL,$jnl_id=NULL)
    {
        $term_table = (new \App\Models\Terms())->getTable();
        $classification_table = (new \App\Models\Classifications())->getTable();
        // $cls_criteria = "cls_jnl_id='{$jnl_id}' AND cls_artp_id IS NULL";
        $cls_criteria = "cls_jnl_id= ? AND cls_artp_id IS NULL";
        $bind_arr =   [$jnl_id];
        if($searchData != NULL){
            // $cls_criteria .= " AND term_name LIKE '%{$searchData}%'";
            $cls_criteria .= " AND term_name LIKE ?";
            $bind_arr[] =   "%{$searchData}%";
        }
        if($checkedData != NULL){
            $cls_criteria .= " AND cls_id IN ({$checkedData})";
        }

        $select = '*';
        $tables = array(
            'main_table' => $term_table,
            'join_table' => array(
                $classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
            )
        );
        // $classification_details = Classifications::get_results_using_joins($tables, $select, $cls_criteria, '');
        $classification_details = Classifications::get_results_using_joins($tables, $select, $cls_criteria, '',binding_arr:$bind_arr);
        $parentSetArr = array();
        $childSetArr = array();
        $parentSetStr = '';
        $childSetStr = '';
        $collcn='';
        if (count($classification_details)) {
            foreach ($classification_details as $row) {
                if (!empty($row->cls_parents_id)) {
                    $parentSetArr[] = implode(',', json_decode($row->cls_parents_id));
                }
                if (!empty($row->cls_children_id)) {
                    $childSetArr[] = implode(',', json_decode($row->cls_children_id));
                }
            }
        }
        $classification_treedata = array();
        if (count($parentSetArr) > 0) {
            $parentSetStr = (implode(',', $parentSetArr));
            $cls_criteria = "(cls_id IN ({$parentSetStr}) AND cls_jnl_id={$jnl_id}) OR " . $cls_criteria;
            $collcn = $parentSetStr;
        }
        if (count($childSetArr) > 0) {
            $childSetStr = (implode(',', $childSetArr));
            $cls_criteria = "(cls_id IN ({$childSetStr})) OR " . $cls_criteria;
            if($collcn != ''){
                $collcn .= ',';
            }
            $collcn .= $childSetStr;
        }
        // $classification_details = Classifications::get_results_using_joins($tables, $select, $cls_criteria, '');
        $classification_details = Classifications::get_results_using_joins($tables, $select, $cls_criteria, '',binding_arr:$bind_arr);
        $res = [];
        if (count($classification_details) > 0) {
            foreach ($classification_details as $e) {
                $this->convertToArr($res, $e);
            }
        }
        $classification_treedata = json_decode(json_encode($res));
        if($checkedData == NULL){
            return $classification_treedata;
        }
        else{
            return json_decode(json_encode(explode(',', $collcn)));
        }
    }
    public function convertToArr(&$arr, $data)
    {
        if ($data->cls_primary_id == 0)
            return $arr[] =  ["key" => (string)$data->cls_id, "title" => $data->term_name, "children" => []];
        foreach ($arr as &$e) {
            if ($e["key"] == $data->cls_primary_id) {
                $e["children"][] = (["key" => (string)$data->cls_id, "title" => $data->term_name, "children" => []]);
                break;
            }
            $this->convertToArr($e["children"], $data);
        }
    }

    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    public function get_author_suggested_reviewstage_flag($article_id)
    {
        $enable_author_suggested_reviewers=FALSE;
        if(isset($this->current_client->functionality->cfty_shortlist_author_suggested_reviewers)&&($this->current_client->functionality->cfty_shortlist_author_suggested_reviewers == 'y'))		  {
            $Article_reviewers = new \App\Models\Article_reviewers();
            $reviewer_data =$Article_reviewers::get_single_record('count(sorw_id) as cnt', "sorw_art_id={$article_id} AND sorw_suggested_user_role='a' AND sorw_action='s'");
            if($reviewer_data->cnt >0)
                $enable_author_suggested_reviewers=TRUE;
        }
        return $enable_author_suggested_reviewers;
    }
    public function auto_invite_reviewer_pre_review($array_rvwer_details, $cron_flag = FALSE)
    {

        $Articles = new \App\Models\Articles;
        $Article_flow = new \App\Models\Article_flow;
        $Article_reviewers = new \App\Models\Article_reviewers();
        $Roles = new \App\Models\Roles();
        $User = new \App\Models\User();
        $User_to_journals = new \App\Models\User_to_journals();
        $Roles = new \App\Models\Roles();
        $Article_reviewers = new \App\Models\Article_reviewers();
        $User = new \App\Models\User();

        $Article_flow_alternativereviewer_priorityorder = new \App\Models\Article_flow_alternativereviewer_priorityorder();
        $Article_user_alternativereviewer_priorityorder = new \App\Models\Article_user_alternativereviewer_priorityorder();
        $Article_autoinvitation_emails = new \App\Models\Article_autoinvitation_emails();
        $Article_alternativereviewer_priority_settings = new \App\Models\Article_alternativereviewer_priority_settings();
        $Article_notification_emails = new \App\Models\Article_notification_emails();
        $Article_type_advance_options = new \App\Models\Article_type_advance_options;
        $jnl_code = isset($array_rvwer_details['jnl_code']) ? $array_rvwer_details['jnl_code'] : '';
        $jnl_id = isset($array_rvwer_details['jnl_id']) ? $array_rvwer_details['jnl_id'] : '';
        $core_role = isset($array_rvwer_details['core_role']) ? $array_rvwer_details['core_role'] : '';
        $flow_id = isset($array_rvwer_details['artflow_id']) ? $array_rvwer_details['artflow_id'] : '';
        $art_id = isset($array_rvwer_details['article_id']) ? $array_rvwer_details['article_id'] : '';
        $current_pool_details = $Article_flow::get_single_record('aflw_source_assignment_id,aflw_assignment_type_id,aflw_jwf_id', "aflw_id={$flow_id}");
        $source_id = $current_pool_details->aflw_source_assignment_id;
        $pool_id = $current_pool_details->aflw_assignment_type_id;
        $destination_id = $current_pool_details->aflw_jwf_id;
        $user_data = array('user_id' => 0, 'proxy_user_id' => 0);
        if ($cron_flag == FALSE) {
            $this->current_user = $this->get_current_user_details();
            $current_user = $this->current_user;
        } else {
            $current_user = $user_data;
}

        $document_module = FALSE;
        $enable_article_priority_reviwer = FALSE;

        if (isset($array_rvwer_details['user_data']) && !empty($array_rvwer_details['user_data'])) {
            $current_user = $array_rvwer_details['user_data'];
        }

        if (!isset($jnl_data) && isset($array_rvwer_details['jnl_data']) && !empty($array_rvwer_details['jnl_data'])) {
            $jnl_data = $array_rvwer_details['jnl_data'];
        }
        if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')) {
            $enable_article_priority_reviwer = TRUE;
        }
        if (isset($this->current_client->modules->mdl_review_for_doc) && $this->current_client->modules->mdl_review_for_doc == 'y') {
            $document_module = TRUE;
        }
        $alternatervwer = array();
        if (isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y')) {

            $articleflow_table = (new \App\Models\Article_flow())->getTable();
            $alternative_user_priority_order_table = (new \App\Models\Article_user_alternativereviewer_priorityorder())->getTable();
            /* Check Alternate reviewer exist in   invited User based priority assign  */

            $assg_tables_user = array(
                'main_table' => $articleflow_table,
                'join_table' => array(
                    $alternative_user_priority_order_table => array($articleflow_table . '.aflw_id', $alternative_user_priority_order_table  . '.auap_aflw_id')
                )
            );
            $selectrewer = 'auap_id as priority_id,auap_alternate_usr_id as user_id,auap_number';
            $criteria = "auap_usr_id={$current_user['user_id']} AND auap_art_id={$array_rvwer_details['article_id']} AND auap_current_aflw_id={$flow_id} AND aflw_status!='i'";
            $priority_settings_user = $Article_alternativereviewer_priority_settings::get_single_record('aaps_multiple_invitation_status	as multiple_invitation ', "aaps_usr_id={$current_user['user_id']} AND aaps_art_id={$array_rvwer_details['article_id']} AND aaps_aflw_id={$flow_id}");
            if (isset($priority_settings_user->multiple_invitation) && $priority_settings_user->multiple_invitation == 'y')
                $limit = "";
            else
                $limit = "1";
            $alternatervwer = $Article_flow::get_results_using_joins($assg_tables_user, $selectrewer, $criteria, 'all', 'auap_id', $limit);

            $col_priority_email = 'aae_auap_id';
        }
// need to check this code start
        if ($alternatervwer->isEmpty() && $enable_article_priority_reviwer == TRUE) {
            $articleflow_table = (new \App\Models\Article_flow())->getTable();
            $alternative_priority_order_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();

            $assg_tables_flow = array(
                'main_table' => $articleflow_table,
                'join_table' => array(
                    $alternative_priority_order_table => array($articleflow_table . '.aflw_id', $alternative_priority_order_table . '.afap_aflw_id')
                )
            );

            $selectrewer = 'afap_id as priority_id,afap_usr_id as user_id,afap_number';
            $criteria = "afap_art_id={$array_rvwer_details['article_id']}  AND aflw_assignment_type_id={$pool_id} AND aflw_jwf_id={$destination_id} AND aflw_status!='i'";

            $priority_settings_user = $Article_alternativereviewer_priority_settings::get_single_record('aaps_multiple_invitation_status	as multiple_invitation ', "aaps_usr_id=0 AND aaps_art_id={$array_rvwer_details['article_id']} AND aaps_pool_id={$pool_id} AND aaps_destination_id={$destination_id}");
            if (isset($priority_settings_user->multiple_invitation) && $priority_settings_user->multiple_invitation == 'y')
                $limit = "";
            else
                $limit = "1";
            $alternatervwer = $Article_flow::get_results_using_joins($assg_tables_flow, $selectrewer, $criteria, 'all', 'afap_number', $limit);

            $col_priority_email = 'aae_afap_id';
        }
// need to check this code end
        if (!empty($alternatervwer)) {
            $rv_cnt = 0;
            foreach ($alternatervwer as $reviwer) {
                $user_id = $reviwer->user_id;
                $priority_id = $reviwer->priority_id;
                $article_reviewer_data = array();

                $aflw_deeplink_token = Str::random(8);

                $condition = "aflw_usr_id={$user_id} AND aflw_art_id={$art_id} AND aflw_assignment_type_id={$pool_id} AND aflw_jwf_id={$destination_id}";

                $current_aflw_id_rec = $Article_flow::get_single_record(
                    'aflw_id,aflw_deeplink_token',
                    $condition
                );
                $current_aflw_id = $current_aflw_id_rec->aflw_id;



                $data['aflw_status'] = 'i';


                /* 1.1 get users who previously declined invititation
         *     in the current flow */
                $decline_data = $Article_flow::get_single_record('*', "aflw_usr_id={$user_id} AND aflw_art_id={$art_id} AND aflw_assignment_type_id={$pool_id} AND aflw_jwf_id={$destination_id} AND aflw_status='d'");
                $today = date('Y-m-d H:i:s', time());

                $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
                $article_details = $Articles::get_article_details($select, "aflw_id={$current_aflw_id}");

                $article_details = $article_details[0];
                $article_id = $article_details->art_id;

                $due_date = $this->get_due_date_for_article($art_id, $article_details->jwf_tat_accept);
                $data['aflw_due_date'] = $due_date;


                $tmpl_condition = "aae_usr_id={$user_id} AND aae_art_id={$article_id} AND aae_aflw_id={$current_aflw_id_rec->aflw_id} AND {$col_priority_email}={$priority_id}";
                $template = $Article_autoinvitation_emails::get_single_record('*', $tmpl_condition);
                $allow_reveiwer = $this->check_allow_reveiwer_invitation($array_rvwer_details['article_id'], $user_id);
                if ($template != NULL && $allow_reveiwer == TRUE) {

                    /* 1.1.1 if $decline_data found */
                    if ($decline_data != NULL) {

                        $invite_user_data = $Article_flow::get_single_record('*', "aflw_usr_id={$user_id} AND aflw_art_id={$art_id} AND aflw_assignment_type_id={$pool_id} AND aflw_jwf_id={$destination_id} AND aflw_status='u'");

                        // Check uninvite user  record already exist
                        if (!empty($invite_user_data)) {
                            $invite_condition = "aflw_usr_id={$user_id} AND aflw_art_id={$art_id} AND aflw_assignment_type_id={$pool_id} AND aflw_jwf_id={$destination_id} AND aflw_status='u'";

                            $flow = $Article_flow::get_single_record('aflw_deeplink_token', $invite_condition);

                            $aflw_deeplink_token = ($flow->aflw_deeplink_token != '') ? $flow->aflw_deeplink_token : $aflw_deeplink_token;
                            $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                            $data['aflw_assigned_date'] = $today;
                            /* 1.1.2 else ,update status row in article flow table  */
                            $status = $Article_flow::update_record($data, $invite_condition, $user_data);
                            /* if the suggested user is not have reviewer role in journal or article type then add role-- start */
                            $is_sugst_usr = $Article_reviewers::get_single_record('sorw_id', "sorw_suggested_reviewer_id={$user_id} AND sorw_action='s' AND sorw_aflw_id={$current_aflw_id}");
                            if ($is_sugst_usr !== NULL) {
                                $revw_role_id = $article_details->jwf_role_id;
                                $user_role_details = array(
                                    'usrj_jnl_id' => $jnl_id,
                                    'usrj_usr_id' => $user_id,
                                    'usrj_role_id' => $revw_role_id,
                                    'usrj_artp_id' => NULL,
                                );
                                $condition_user_role_details = "usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id IS NULL";
                                $jnl_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);

                                if ($jnl_reviewr_record == NULL) {
                                    $user_role_details['usrj_invite'] = 'n';
                                    $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                                    unset($user_role_details['usrj_invite']);
                                }
                                //user as article type reviewer
                                $condition_user_role_details = "usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id ={$article_details->art_artp_id}";

                                $art_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);
                                if ($art_reviewr_record == NULL) {
                                    $user_role_details['usrj_invite'] = 'n';
                                    $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                                }
                            }

                        }
                    } else {


                        $flow = $Article_flow::get_single_record('aflw_deeplink_token', $condition);

                        $aflw_deeplink_token = ($flow->aflw_deeplink_token != '') ? $flow->aflw_deeplink_token : $aflw_deeplink_token;

                        $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                        $data['aflw_assigned_date'] = $today;
                        /* 1.1.2 else ,update status row in article flow table  */
                        $status = $Article_flow::update_record($data, $condition, $user_data);
                        /* if the suggested user is not have reviewer role in journal or article type then add role-- start */
                        $is_sugst_usr = $Article_reviewers::get_single_record('sorw_id', "sorw_suggested_reviewer_id={$user_id} AND sorw_action='s' AND sorw_aflw_id={$current_aflw_id}");

                        if ($is_sugst_usr !== NULL) {
                            $revw_role_id = $article_details->jwf_role_id;
                            $user_role_details = array(
                                'usrj_jnl_id' => $jnl_id,
                                'usrj_usr_id' => $user_id,
                                'usrj_role_id' => $revw_role_id,
                                'usrj_artp_id' => NULL,
                            );
                            $condition_user_role_details = "usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id IS NULL";
                            $jnl_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);

                            if ($jnl_reviewr_record == NULL) {
                                $user_role_details['usrj_invite'] = 'n';
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                                unset($user_role_details['usrj_invite']);
                            }
                            //user as article type reviewer
                            $condition_user_role_details = "usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND usrj_artp_id ={$article_details->art_artp_id}";

                            $art_reviewr_record = $User_to_journals::get_single_record('usrj_id', $condition_user_role_details);
                            if ($art_reviewr_record == NULL) {
                                $user_role_details['usrj_invite'] = 'n';
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                            }
                        }
                        /* add reviewer role end */
                    }

                    /* 1.2 if no declined users found,update corresponding row in Article_reviewers table */
                    if ($decline_data == NULL) {

                        $article_reviewer_data['sorw_invited_by'] = $user_data['user_id'];
                        $article_reviewer_data['sorw_invited_on'] = $today;
                        $article_reviewer_condition = "sorw_art_id={$article_id} AND sorw_suggested_reviewer_id={$user_id}";
                        $Article_reviewers::update_record($article_reviewer_data, $article_reviewer_condition, $user_data);
                    }

                    $reviewer_role = $Roles::get_single_record('role_id', "role_assigned_role='reviewer'");

                    $role_id = $reviewer_role->role_id;
                    if ($document_module == TRUE) {
                        $user_role_in_journal = $User_to_journals::get_single_record('count(usrj_id) as count', "usrj_jnl_id={$jnl_id} AND usrj_artp_id IS NULL AND usrj_usr_id={$user_id} AND usrj_role_id={$role_id}");
                        if ($user_role_in_journal != NULL && $user_role_in_journal->count == 0) {
                            $journal_user_data['usrj_usr_id'] = $user_id;
                            $journal_user_data['usrj_role_id'] = $role_id;
                            $journal_user_data['usrj_artp_id'] = NULL;
                            $journal_user_data['usrj_invite'] = 'n';
                            $journal_user_data['usrj_cpy_class_art_type'] = 'n';
                            $journal_user_data['usrj_jnl_id'] = $jnl_id;
                            $User_to_journals::insert_record($journal_user_data, $user_data);
                        }
                        if (isset($article_details->art_artp_id)) {
                            $user_role_cnt_in_artp = $User_to_journals::get_single_record('count(usrj_id) as cnt', "usrj_jnl_id={$jnl_id} AND usrj_artp_id={$article_details->art_artp_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$role_id}");
                            if ($user_role_cnt_in_artp != NULL && $user_role_cnt_in_artp->cnt == 0) {
                                $atp_user_data['usrj_jnl_id'] = $jnl_id;
                                $atp_user_data['usrj_artp_id'] = $article_details->art_artp_id;
                                $atp_user_data['usrj_usr_id'] = $user_id;
                                $atp_user_data['usrj_role_id'] = $role_id;
                                $atp_user_data['usrj_invite'] = 'n';
                                $atp_user_data['usrj_cpy_class_art_type'] = 'n';
                                $User_to_journals::insert_record($atp_user_data, $user_data);
                            }
                        }
                    }
                    $Article_user_alternativereviewer_priorityorder::delete_records("auap_alternate_usr_id={$user_id} AND auap_art_id={$article_id}");
                    $Article_flow_alternativereviewer_priorityorder::delete_records("afap_usr_id={$user_id} AND afap_art_id={$article_id}");
                    $Article_autoinvitation_emails::delete_records("aae_usr_id={$user_id} AND aae_art_id={$article_id}");

                    $attachments = $files_attached = array();
                    $article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to', "ane_stage_etmp_id={$template->aae_stage_etmp_id} AND ane_art_id={$article_id} AND ane_aflw_id ={$article_details->aflw_id}");
                    // print_r("=============================================");
                    // print_r("ane_stage_etmp_id={$template->aae_stage_etmp_id} AND ane_art_id={$article_id} AND ane_aflw_id ={$article_details->aflw_id}");
                    // print_r("=============================================");   
                    if (isset($article_notification->ane_id)) {
                        $email_attachments    =    $this->get_invite_email_attachments($article_id, $article_notification->ane_id, FALSE);
                        if (!empty($email_attachments)) {
                            $attachments = $email_attachments['attachments'];
                            $files_attached = $email_attachments['files_attached'];
                        }
                    }

                    $email_data = new stdClass;
                    $email_data->article_id = $article_id;
                    if (!empty($files_attached)) {
                        $email_data->attachments = $attachments;
                        $email_data->files_attached = $files_attached;
                    }
                    $email_data->user_id = $user_id;
                    $email_data->jnl_journal_code = $jnl_code;
                    $email_data->artp_id = $article_details->art_artp_id;
                    $email_data->jnl_id = $jnl_id;
                    $email_data->aflw_id = $article_details->aflw_id;
                    $send_mail_to = '';
                    $send_mail_to_usr_ids = '';
                    $reply_to = $this->get_reply_to_email($jnl_id);

                    if (isset($reply_to) && $reply_to != '')
                        $email_data->reply_to = $reply_to;
                    $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                    $res = $User::get_single_record('usr_email, usr_status, usr_deeplink_token', "usr_id={$user_id}");

                    if ($res) {
                        $send_mail_to = $res->usr_email;
                        $send_mail_to_usr_ids = $user_id;
                        if ($res->usr_status == 'w') {
                            if (!empty($res->usr_deeplink_token))
                                $aflw_deeplink_token = $res->usr_deeplink_token;
                            else {
                                $Users::update_record(array(
                                    'usr_deeplink_token' => $aflw_deeplink_token
                                ), "usr_id={$user_id}");
                            }
                        }
                    }
                    $link = URL::to('/') . '/' . $this->current_client->platform_type . '/' .  $jnl_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&user_role_id=' . $role_id . '&article_flow_id=' . $article_details->aflw_id);

                    $accept_link = URL::to('/') . '/' . $this->current_client->platform_type . '/' .  $jnl_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id);
                    //#581 hide terms & conditions popup for reviewers on decline invitation
                    $reject_link = URL::to('/') . '/' . $this->current_client->platform_type . '/' .  $jnl_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide');


                    if ($template->aae_to != 'User' && $template->aae_to != 'Custom') {
                        $cfty_retire_role = FALSE;
                        if ((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y') {
                            $cfty_retire_role = TRUE;
                        }
                        $send_mail_to_detail = $this->send_email_to($template->aae_to,  $jnl_code, $article_details->art_artp_id, $article_id, $cfty_retire_role);
                        $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['email_ids'] = str_replace(' ', '', $send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
                        $send_mail_to_detail['usr_ids'] = str_replace(' ', '', $send_mail_to_detail['usr_ids']);
                        $send_mail_to = $send_mail_to_detail['email_ids'];
                        $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
                    }

                    $subject = $template->aae_subject;
                    $content = $template->aae_content;

                    //get cc, bcc, reply_to from preview
                    $template->stage_etmp_cc = $template->stage_etmp_bcc = '';
                    $template->stage_etmp_cust_cc = $template->stage_etmp_cust_bcc = '';
                    $template->stage_etmp_cust_to = '';
                    if (!empty($template->aae_cc)) {
                        $template->stage_etmp_cc = $template->aae_cc;

                        if (in_array('Custom', json_decode($template->aae_cc)))
                            $template->stage_etmp_cust_cc = trim($template->aae_cust_cc);
                    }
                    if (!empty($template->aae_bcc)) {
                        $template->stage_etmp_bcc = $template->aae_bcc;
                        if (in_array('Custom', json_decode($template->aae_bcc)))
                            $template->stage_etmp_cust_bcc = trim($template->aae_cust_bcc);
                    }
                    $email_data->reply_to = $template->aae_reply_to;

                    if ($decline_data != NULL) {
                        preg_match_all('/##([^##]*)##/', $template->aae_content, $matches);
                        $keys = $matches[1];
                        if (in_array('CONFIRMATION_URL', $keys))
                            $content = preg_replace('/<a id="confirmation_url_tag_reinvite".*>.*<\/a>/', '<a id="confirmation_url_tag_reinvite" href="' . $link . '">' . $link . '</a>', $content);
                        if (in_array('DIRECT_ACCEPT', $keys))
                            $content = preg_replace('/<a id="direct_accept_tag_reinvite".*>.*<\/a>/', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' . 'Accept' . '</a>', $content);
                        if (in_array('DIRECT_REJECT', $keys))
                            $content = preg_replace('/<a id="direct_reject_tag_reinvite".*>.*<\/a>/', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '">' . 'Reject' . '</a>', $content);
                    }

                    //bug with link tags DIRECT_ACCEPT, DIRECT_REJECT, CONFIRMATION_URL
                    if (!empty($template->aae_to) && $template->aae_to == 'User') {
                        preg_match_all('/##([^##]*)##/', $template->aae_content, $matches);
                        $keys = $matches[1];
                        if (in_array('CONFIRMATION_URL', $keys)) {
                            $content = str_ireplace('##CONFIRMATION_URL##', '<a id="confirmation_url_tag_reinvite" href="' . $link . '">' . $link . '</a>', $content);
                        }

                        if (in_array('DIRECT_ACCEPT', $keys)) {
                            $content = str_ireplace('##DIRECT_ACCEPT##', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' . ((trans('client_lang.accept_link_text') != '') ? trans('client_lang.accept_link_text') : 'Accept') . '</a>', $content);
                        }

                        if (in_array('DIRECT_REJECT', $keys)) {
                            $content = str_ireplace('##DIRECT_REJECT##', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '" >' .  ((trans('client_lang.reject_link_text') != '') ? trans('client_lang.reject_link_text') : 'Reject') . '</a>', $content);
                        }
                    } else {
                        $content = str_ireplace('##CONFIRMATION_URL##', '', $content);
                        $content = str_ireplace('##DIRECT_ACCEPT##', '', $content);
                        $content = str_ireplace('##DIRECT_REJECT##', '', $content);
                    }
                    $email_data->subject = $subject;
                    $email_data->body = $content;
                    $email_data->email_templates_config = $this->email_templates_config();
                    if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                        $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];

                    if ($send_mail_to != '' || $template->aae_to == 'Custom') {

                        $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method', "atotp_artp_id={$article_details->art_artp_id}");
                        if (!empty($artp_settings)) {
                            $template->review_method = $template->assignments = '';
                            // if(isset($core_role) )
                            // {
                            //     $core_role = $core_role;
                            // }
                            // else
                            if (isset($article_details->jwf_role_id)) {
                                $roles = $Roles::get_single_record('role_assigned_role', "role_id={$article_details->jwf_role_id}");
                                $core_role = $roles->role_assigned_role;
                            }
                            if ($core_role == 'reviewer' && (isset($template->stage_etmp_to) && ($template->stage_etmp_to == 'submit_author' || $template->stage_etmp_to == 'Author' || $template->stage_etmp_to == 'article_authors' || $template->stage_etmp_to == 'Authors'))) {
                                $template->review_method = $artp_settings->atotp_review_method;
                            }
                        }
                        $template->stage_etmp_action = 'assigned';
                        $email_data->user_email = $send_mail_to;
                        $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
                        $email_data->core_role = $core_role;
                        $core_role_name = '';
                        // $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
                        $email_data->core_role_name = $core_role_name;

                        $action_name = '';
                        if ($cron_flag == TRUE) {
                            $action_name = 'cron_job';
                        }
                        $email_data->name = $action_name;
                        $this->send_email_notification($template, $email_data, $user_data, 'stage_etmp_');
                    }


                    $invitation_send = TRUE;
                }
            }
        }
    }

    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
    public function get_sys_dwntime_message() {
        $returnArr          =   array();
        $sysDowntimeArr     =   System_downtime::get_sys_dwntime_record();
        // date_default_timezone_get();                         //SERVER TIMEZONE
        $currentDate	    =	date('Y-m-d H:i:s');            //SERVER CURRENT TIME
        $ISTzone			=	new \DateTime('now', new \DateTimeZone('Asia/Kolkata'));
        $currentISTDate		=	$ISTzone->format('Y-m-d H:i:s');

        $diff				=	strtotime($currentISTDate) - strtotime($currentDate);
        $hours				=	floor($diff / 3600);
        $minutes			=	floor(($diff - $hours * 3600) / 60);

        if(!empty($sysDowntimeArr)) {
            $downtime_res       =   $sysDowntimeArr[0];
            $sys_downtime_tz	=	$downtime_res->dwn_time_zone;
            $startTime			=	$downtime_res->dwn_time_message_start;
            $endTime			=	$downtime_res->dwn_time_scheduled;

            if($sys_downtime_tz == 'b') {
                if(strtotime($currentDate) > strtotime($endTime)) {
                    return array();
                }
                $conv_startTime  =   date('Y-m-d H:i:s',strtotime('+'.$hours.' hour +'.$minutes.' minutes',strtotime($startTime)));
                $conv_endTime    =   date('Y-m-d H:i:s',strtotime('+'.$hours.' hour +'.$minutes.' minutes',strtotime($endTime)));
            } else {
                if(strtotime($currentISTDate) > strtotime($endTime)) {
                    return array();
                }
                $conv_startTime  =   date('Y-m-d H:i:s',strtotime('-'.$hours.' hour -'.$minutes.' minutes',strtotime($startTime)));
                $conv_endTime    =   date('Y-m-d H:i:s',strtotime('-'.$hours.' hour -'.$minutes.' minutes',strtotime($endTime)));
            }

            $returnArr      =   array(
                'dwn_time_zone' => $sys_downtime_tz,
                'dwn_time_message' => $downtime_res->dwn_time_message,
                'dwn_time_speed' => $downtime_res->dwn_time_speed,
                'dwn_time_message_start' => $startTime,
                'dwn_time_scheduled' => $endTime,
                'dwn_time_message_start_converted' => $conv_startTime,
                'dwn_time_scheduled_converted' => $conv_endTime,
            );
            return $returnArr;
        } else {
            return array();
        }
    }
    public function escape_string($data)
    {
        $result = array();
        foreach ($data as $row) {
            $result[] = str_replace('"', '', $row);
        }
        return $result;
    }
    public function checkArticletypeError($flow_master_id){
        $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
        $errorstatus=false;
        $condition = "jwf_fwm_id={$flow_master_id}";
        $stage_generic_form_all = Generic_flows::get_all_records('jwf_import_custom_form_err, jwf_import_user_role_err, jwf_import_email_form_err', $condition);
        if (!empty($stage_generic_form_all)){
            foreach ($stage_generic_form_all as $single_stages) {
                if ($single_stages->jwf_import_custom_form_err != '' || $single_stages->jwf_import_user_role_err != '' || $single_stages->jwf_import_email_form_err != '') {
                    $errorstatus=true;
                }
            }
        }
        return $errorstatus;

    }
    public function getPermittedArticleStatus($current_client){
        $permissions = array(
            'deletePermission'     => (isset($current_client->functionality->cfty_enable_article_delete) && $current_client->functionality->cfty_enable_article_delete == 'y') ? TRUE : FALSE,
            'withdrawPermission'   => (isset($current_client->functionality->cfty_enable_article_withdraw) && $current_client->functionality->cfty_enable_article_withdraw == 'y') ? TRUE : FALSE,
            'holdPermission'       => (isset($current_client->functionality->cfty_enable_article_hold) && $current_client->functionality->cfty_enable_article_hold == 'y') ? TRUE : FALSE
        );
        if (isset($current_client->modules->mdl_review_for_doc) && $current_client->modules->mdl_review_for_doc == 'n') {
            $articleStatus = array(
                'y' => 'In Progress',
                'c' => 'Closed',
                'r' => 'Rejected',
                't' => 'Transferred',
                'a' => 'Accepted'
            );
        } else {
            $articleStatus = array(
                'y' => 'In Progress',
                'c' => 'Closed',
                'a' => 'Accepted',
                'q' => 'In queue'
            );
        }
        if ($permissions['withdrawPermission'] === TRUE) {
            $articleStatus['w'] = 'Withdrawn';
        }
        if ($permissions['holdPermission'] === TRUE) {
            $articleStatus['h'] = 'On hold';
        }
        $return['articleStatus'] = $articleStatus;
        $return['permissions'] = $permissions;
        return $return;
    }

   public function get_specific_cc_bcc_values($post_stage_cust_cc,$post_stage_cust_bcc){
    $return_array=array();
    $optccvalue = array();
    if (isset($post_stage_cust_cc)&&!empty($post_stage_cust_cc)) {
        $custm_cc = $post_stage_cust_cc;
        for ($i = 0; $i < count($custm_cc); $i++) {
            $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
            $cust_value = str_replace('\\', '"', $cust_value);
            $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

            array_push($optccvalue, $cust_value);


        }
        $return_array['cust_cc'] = implode(',', $optccvalue);

    }
    else{
        $return_array['cust_cc']='';
    }
    $optbccvalue = array();
    if (isset($post_stage_cust_bcc)&&!empty($post_stage_cust_bcc)) {
        $custm_bcc = $post_stage_cust_bcc;
        for ($i = 0; $i < count($custm_bcc); $i++) {
            $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
            $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
            $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

            array_push($optbccvalue, $cust_bcc_value);

        }
        $return_array['cust_bcc'] = implode(',', $optbccvalue);
    }
    else{
        $return_array['cust_bcc']='';
    }
    return $return_array;
}

    public function is_access_overriding_user($jnl_code, $usr_id, $flow_id){
        $client = $this->get_client_details('clnt_client_code')?->clnt_client_code;
        $jwf_id = (new Article_flow())->select(['aflw_jwf_id'])->find($flow_id)?->aflw_jwf_id;
        $role_id = Generic_flows::find($jwf_id)?->jwf_role_id;
        $role_assigned_role = Roles::find($role_id)?->role_assigned_role;
        $prevented_roles = config('clients.'.$client.'.workflow_config.overriding_prevented_over'.env('PLATFORMTYPE'), ['author', 'reviewer']);
        if(in_array($role_assigned_role, $prevented_roles)){
            return false;
        }
        $user = $this->validate_user_journal($jnl_code, $usr_id);
        $priv_access_roles = config('clients.'.$client.'.workflow_config.overriding_user_roles');
        $platform_based = $priv_access_roles[env('PLATFORMTYPE')] ?? null;
        if( !$platform_based ||  count($platform_based) <= 0 ){
            return false;
        }

        return count(array_intersect($platform_based, $user['assigned_roles']))>0;
    }
    public function check_all_request_exist($condition_arr,$type)
    {
        $this->current_user = $this->get_current_user_details();
        $return_array = [];
        $return_val = "";
        $return_status = FALSE;
        $articlesTable = (new Articles)->getTable();
        $articlesTypeTable = (new Article_types)->getTable();
        $customReasonTable = (new Article_custom_reasons)->getTable();
        $jpTable = (new Journal_permission)->getTable();
        //$select = $jsTable . '.jset_prevent_edit AS jset_prevent_edit,' . $jpTable . '.jp_prevent_edit AS jp_prevent_edit,cusr_art_id';
        $select = 'cusr_id,art_id,jp_prevent_edit';
        $tables = array(
            'main_table' => $articlesTable,
            'join_table' => array( $articlesTypeTable => array($articlesTable . '.art_artp_id', $articlesTypeTable . '.artp_id'),
                                    $customReasonTable => array($articlesTable . '.art_id',$customReasonTable . '.cusr_art_id'),
                                    $jpTable => array($jpTable . '.jp_jpm_id',$articlesTypeTable . '.artp_jpm_id'))
        );
        $criteria = 'artp_jnl_id=? AND cusr_action_type = \'prevent_edit_request_access\' AND cusr_status=\'p\' AND cusr_status_change_by IS NULL';
        $binding_arr = [$condition_arr['jnl_id']];
        if(isset($condition_arr['post_from'])){
            $searchBy = $condition_arr['search_by'] ?? "";
            $searchValue = $condition_arr['search_value'] ?? "";
            if($searchValue!=""){
                $key = 'art_code';
                switch($searchBy){
                    case 'article_id':
                        $key = 'art_code';
                    break;
                    case 'article_title':
                        $key = 'art_title';
                    break;
                }
                $searchBit = TRUE;
                $criteria .= ' AND '.$key.' LIKE \'%'.$searchValue.'%\'';
            }
        }else if(isset($condition_arr['search_arr'])){
            if(isset($condition_arr['search_arr']['article_id_left'])){
                foreach($condition_arr['search_arr']['article_id_left'] AS $key=>$article_id_left){
                    if($article_id_left == 'EXACT_MATCH'){
                        $criteria .= ' AND art_code = \''.$condition_arr['search_arr']['article_id_right'][$key].'\'';
                    }else if($article_id_left == 'STARTS_WITH'){
                        $criteria .= ' AND art_code LIKE \''.$condition_arr['search_arr']['article_id_right'][$key].'%\'';
                    }else if($article_id_left == 'ENDS_WITH'){
                        $criteria .= ' AND art_code LIKE \'%'.$condition_arr['search_arr']['article_id_right'][$key].'\'';
                    }
                    else
                        $criteria .= ' AND art_code '.$article_id_left.' \'%'.$condition_arr['search_arr']['article_id_right'][$key].'%\'';
                }
            }
            if(isset($condition_arr['search_arr']['article_title_left'])){
                foreach($condition_arr['search_arr']['article_title_left'] AS $key=>$article_title_left){
                    if($article_title_left == 'EXACT_MATCH'){
                        $criteria .= ' AND art_title = \''.$condition_arr['search_arr']['article_title_right'][$key].'\'';
                    }else if($article_title_left == 'STARTS_WITH'){
                        $criteria .= ' AND art_title LIKE \''.$condition_arr['search_arr']['article_title_right'][$key].'%\'';
                    }else if($article_title_left == 'ENDS_WITH'){
                        $criteria .= ' AND art_title LIKE \'%'.$condition_arr['search_arr']['article_title_right'][$key].'\'';
                    }else{
                        $criteria .= ' AND art_title '.$article_title_left.' \'%'.$condition_arr['search_arr']['article_title_right'][$key].'%\'';
                    }
                }
            }
        }else if(isset($condition_arr['filter'])){
            if(isset($condition_arr['filter']['article_code']) && $condition_arr['filter']['article_code']!=""){
                $criteria .= ' AND art_code LIKE \'%'.$condition_arr['filter']['article_code'].'%\'';
            } 
            if(isset($condition_arr['filter']['art_title']) && $condition_arr['filter']['art_title']!=""){
                $criteria .= ' AND art_title LIKE \'%'.$condition_arr['filter']['art_title'].'%\'';
            }       
        }
        $articles = Articles::get_results_using_joins($tables,$select,$criteria,binding_arr:$binding_arr);
        if($articles){
            $articleIds = $articles->pluck('art_id')->toArray();
            $allocated_user = $this->get_allocated_users_list($articleIds);
            switch($type){
                case 'count':
                    $artCount = 0;
                    foreach($articles AS $article){
                        $jp_prevent_edit = json_decode($article->jp_prevent_edit,TRUE);
                        if($jp_prevent_edit!=""){
                            if(isset($allocated_user[$article->art_id]) && isset($allocated_user[$article->art_id][$condition_arr['role_id']])){
                                in_array($this->current_user['user_id'],$allocated_user[$article->art_id][$condition_arr['role_id']])?$artCount++:"";
                            }else if(isset($condition_arr['role_id']) && count($jp_prevent_edit) > 0 && in_array($condition_arr['role_id'],$jp_prevent_edit))
                                $artCount++;
                        }
                    }
                    if($artCount > 0){
                        $return_status = TRUE;
                    }
                    $return_val = $articles;
                break;
                case 'art_id':
                    $rtn_articles = $articles->pluck('art_id')->unique()->toArray();
                    $artArr = [];
                    if(count($rtn_articles)>0){
                        //for($i=0;$i<count($rtn_articles);$i++){
                        foreach($rtn_articles AS $i => $rtn_article){
                            $jp_prevent_edit = json_decode($articles[$i]->jp_prevent_edit,TRUE);
                            if($jp_prevent_edit!=""){
                                if(isset($allocated_user[$rtn_article]) && isset($allocated_user[$rtn_article][$condition_arr['role_id']])){
                                    in_array($this->current_user['user_id'],$allocated_user[$rtn_article][$condition_arr['role_id']]) ? array_push($artArr,$rtn_article) :"";
                                }else if(isset($condition_arr['role_id']) && count($jp_prevent_edit) > 0 && in_array($condition_arr['role_id'],$jp_prevent_edit))
                                    array_push($artArr,$rtn_article);
                            $return_status = TRUE;
                            }
                        }
                    }
                    $return_val = implode(',', $artArr);
                break;
            }
        }
        $return_array = [
            'status' => $return_status,
            'art_perm' => $return_val,
        ];
        return $return_array;
    }
    public function ValidateReviewerparticipated_postreviewstage($article_id,$user_id,$suggested_user_id,$jnl_id) {
        $Article_flow=new \App\Models\Article_flow();
        $selected_user_name = '';
        $select = 'aflw_usr_id  as usr_id,jwf_stage_name,jwf_role_id as role_id,role_name';
        $where = "aflw_art_id={$article_id} AND jwf_stage_type='post_assessment'";
        $stage_assignment = $Article_flow::get_article_flow_details($select, $where);
        $msg='';
        if (($stage_assignment->isNotempty()) && isset($user_id) && $suggested_user_id!='') {
            foreach ($stage_assignment as $stages) {
                if( $stages->usr_id == $suggested_user_id) {
                    $displayarray=array();
                    $displayarray['user_id']=$user_id;
                    $displayarray['salutation']=true;
                    $displayarray['fullname_only']=true;
                    $displayarray['journal_id']=$jnl_id;
                    $displayarray['article_id']=$article_id;
                    $selected_user_name_array = $this->get_user_display_name($displayarray);
                    if(is_array($selected_user_name_array)){
                        $selected_user_name=$selected_user_name_array['fullname'];
                    }else {
                        $selected_user_name=$selected_user_name_array;
                    }
                    $msg="Sorry! You cannot assign <span id='usr_info_warning'>##user full name## </span> as a reviewer because the user already participated in a post review stage.";
                    $msg =  str_replace('##user full name##', $selected_user_name,$msg);
                    return $msg;
                }
            }
        }
        return $msg;
    }

    public function ValidateReviewerhasonlyonerole($article_id,$suggested_user_id,$jnl_id,$jnl_code) {
        $Articles=new \App\Models\Articles();
        $User_to_journals=new \App\Models\User_to_journals();
        $msg='';
        $selected_user_name='';
        if (isset($suggested_user_id) && $suggested_user_id!='') {
            $article_detls = $Articles::get_article_data($article_id);
            $user_roles = $this->validate_user_journal($jnl_code,$suggested_user_id,$article_detls->artp_id);

            $only_one_roles = '';
            foreach ($user_roles['role_id'] as $role_cnt) {
                $usrs_list_artp = $User_to_journals::get_usrs_count($article_detls->artp_id,$role_cnt);
                if(count($usrs_list_artp) == 1) {
                    $only_one_roles .= $usrs_list_artp[0]->role_name .'/';
                }
            }

            if( $only_one_roles !='' ) {
                $only_one_roles = trim($only_one_roles, '/');
                $displayarray=array();
                $displayarray['user_id']=$suggested_user_id;
                $displayarray['salutation']=true;
                $displayarray['fullname_only']=true;
                $displayarray['journal_id']=$jnl_id;
                $displayarray['article_id']=$article_id;
                $selected_user_name_array = $this->get_user_display_name($displayarray);
                if(is_array($selected_user_name_array)){
                    $selected_user_name=$selected_user_name_array['fullname'];
                }else {
                    $selected_user_name=$selected_user_name_array;
                }
                $msg="Sorry! You cannot assign <span id='usr_info_warning'>##user full name## </span> as a reviewer because the user is the only ##user role## for this article.";
                $msg = str_replace('##user full name##', $selected_user_name,$msg);
                $msg = str_replace('##user role##', $only_one_roles,$msg);
                return $msg;
            }
        }

        return $msg;
    }

    public function ValidateReviewerassignedroles($article_id,$suggested_user_id) {
        $user_assigned_cnt = array();
        $role_names = '';
        $msg='';
        $change_assignment = FALSE;
        $User_articles=new \App\Models\User_articles();
        $Roles=new \App\Models\Roles();
        $article_assigned_users = $this->get_allocated_users_list(array($article_id));
        if(isset($suggested_user_id) && !empty($suggested_user_id)) {
            $condi = "usra_art_id={$article_id} AND usra_usr_id={$suggested_user_id}";
        } else{
            $condi = "usra_art_id={$article_id}";
        }

        $user_roles_data = $User_articles::get_allocate_user_with_role('usra_art_id,usra_usr_id as usr_id,usra_role_id as role_id,role_name,role_assigned_role', $condi, 'role_name');
        $privileged_user_roles=$this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
        if(isset($suggested_user_id) && !empty($suggested_user_id) ) {
            if(!empty($user_roles_data)) {
                foreach ($user_roles_data as $details) {
                    if (array_key_exists($details->role_id, $article_assigned_users[$article_id] ) && in_array($details->role_assigned_role, $privileged_user_roles)) {
                        $where ="usra_art_id={$article_id} AND usra_role_id={$details->role_id}";
                        $user_assigned_cnt = $User_articles::get_assigned_users('count(	usra_id) as cnt', $where);
                        if ( !empty($user_assigned_cnt) && $user_assigned_cnt[0]->cnt == 1 ) {
                            $role_names .= $Roles::get_role_name($details->role_id)->role_name.'/';
                            $change_assignment = TRUE;
                        }
                    }
                }

                if ($change_assignment == TRUE) {
                    $role_names = trim($role_names, '/');
                    $msg="You have selected an ##roles## of this article as a reviewer. Please change the assigned ##roles## before proceeding with this for the flawless processing of this article.";
                    $msg= str_replace('##roles##', $role_names, $msg);
                    return $msg;
                }
            }
        }
        return $msg;
    }

    public function ValidateRevieweralreadyexist($article_id,$suggested_user_id,$type='',$fullname='',$art_parent_flw_id='') {
        $Article_flow=new \App\Models\Article_flow();
        $article_flow_table=(new \App\Models\Article_flow())->getTable();
        $genericflows_table = (new \App\Models\Generic_flows())->getTable();
        $msg='';

        if(isset($article_id)&&isset($suggested_user_id)&&($suggested_user_id!='')) {
            $tables = array(
                'main_table' => $article_flow_table,
                'join_table' => array($genericflows_table => array($article_flow_table . '.aflw_jwf_id', $genericflows_table . '.jwf_id'))
                );
                $reviewer_criteria ="aflw_art_id={$article_id} AND jwf_stage_type='review' AND aflw_usr_id={$suggested_user_id}";
                if(!empty($art_parent_flw_id)){
                    $reviewer_criteria .=" and aflw_parent_flow_id={$art_parent_flw_id}";
                }
                $reviwer_role_count = $Article_flow::get_results_using_joins($tables, 'count(aflw_id) as cnt', $reviewer_criteria,'single');
                $cnt_rvwer=$reviwer_role_count->cnt;
                if($cnt_rvwer>0) {
                    if($type=='m') { // multiple reviewer
                        $msg=customTrans('accept_decline_invite.named_invitation_already_exist');
                        $msg= str_replace('##user full name##', $fullname, $msg);
                    } else {
                        $msg=customTrans('accept_decline_invite.invitation_already_exist');
                    }
                    return $msg;
                }
        }
        return $msg;
    }

    public function es_curl_request($api_url,$data)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_URL, $api_url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($curl);
        Log::channel('editor')->info("\nRequest URL: $api_url\nRequest Data: " . json_encode($data) . "\nResponse: " . $response);
        return $response;
    }

    public function log_incoming_request($request,$return_arr)
    {
        Log::channel('editor')->info(
            'Incoming Request:', [
            'url' => $request->url(),
            'method' => $request->method(),
            'headers' => $request->headers->all(),
            'body' => $request->isJson() ? $request->json()->all() : $request->all(),
            'response' => $return_arr
        ]);
    }
    public function addnewreviwerdecline($article_id, $aflow_id,$suggest_reviewer,$suggest_flag,$bulksubmission) {
        $User=new \App\Models\User();
        $Authors=new \App\Models\Authors();
        $User_affiliation=new \App\Models\User_affiliations();
        $currentuser = $this->get_current_user_details();
        $jnl_id=decrypt_link($suggest_reviewer['jnl_id']);
        $jnl_code=$suggest_reviewer['jnl_code'];
        $user_id=decrypt_link($suggest_reviewer['aflw_usr_id']);
        $jnl_standlone=$suggest_reviewer['jnl_standalone'];
        $art_parent_flw_id = isset($suggest_reviewer['art_parent_flw_id']) ? decrypt_link($suggest_reviewer['art_parent_flw_id']):'';
        $suggested_user_id=isset($suggest_reviewer['suggested_user_id']) ? decrypt_link($suggest_reviewer['suggested_user_id']) : '';
        $return_data['success']=true;

        if (isset($suggest_flag) && $suggest_flag == 'y') {
            if ( $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' && $suggest_flag== 'y') {
                
                //Validate the reviewer because the user has already participated in a post-review stage.
                $msg=$this->ValidateReviewerparticipated_postreviewstage($article_id,$user_id,$suggested_user_id,$jnl_id);                  
                if(!empty($msg)) {
                    $return_data['msg']  =  $msg;
                    $return_data['success']=false;
                    return $return_data;
                }

                //Validate the reviewer because the user has only one role.
                $msg=$this->ValidateReviewerhasonlyonerole($article_id,$suggested_user_id,$jnl_id,$jnl_code);                  
                if(!empty($msg)){
                    $return_data['msg']  =  $msg;
                    $return_data['success']=false;
                    return $return_data;
                }

                //Validate The assigned role of the reviewer should be changed before proceeding for flawless processing of this article.
                $msg=$this->ValidateReviewerassignedroles($article_id,$suggested_user_id,$jnl_id,$jnl_code);                  
                if(!empty($msg)){
                    $return_data['msg']  =  $msg;
                    $return_data['success']=false;
                    return $return_data;
                }               

            }


            //Validate reviewer already exist in the article.
            $msg=$this->ValidateRevieweralreadyexist($article_id,$suggested_user_id,'','',$art_parent_flw_id);                  
            if(!empty($msg)){
                $return_data['msg']  =  $msg;
                $return_data['success']=false;
                return $return_data;
            }




            $stand_jnl_id = ($jnl_standlone == 'y') ? $jnl_id : null;
            if (isset($suggest_reviewer['email_address']) && $suggest_reviewer['email_address'] != "") {
                $check_email ="usr_email='{$suggest_reviewer['email_address']}'";
                if (isset($suggest_reviewer['hdn_confirm_user']) && $suggest_reviewer['hdn_confirm_user'] != ""){
                    $confirm_user=decrypt_link($suggest_reviewer['hdn_confirm_user']);
                    $check_email.=" AND usr_id!={$confirm_user}";
                } else if (isset($suggested_user_id) && $suggested_user_id != "") {
                    $check_email.=" AND usr_id!={$suggested_user_id}";
                }

                $get_email_record = $User::get_user_by_email_journal($check_email, $stand_jnl_id);
                if (count($get_email_record) > 0) {
                    //restrict the use of author details -- Bug #1312
                    $is_author = $Authors::get_single_record('count(auth_id) as cnt',"auth_art_id={$article_id} AND auth_usr_id={$get_email_record[0]->usr_id}");
                    if ($is_author->cnt > 0 || $get_email_record[0]->usr_id == $currentuser['user_id'] || ($get_email_record[0]->usr_status != "a" && $get_email_record[0]->usr_status != "w" )) { 
                        //exclude declined user and article authors                    
                        $return_data['msg'] =customTrans('accept_decline_invite.author_email_unable_touse');
                        $return_data['success']=false;
                        return $return_data;
                    }
                    $all_titles =$this->UserConfigdata('titles')['titles'];
                    if(isset($all_titles[$get_email_record[0]->usr_title])) {
                        $owner_name = $all_titles[$get_email_record[0]->usr_title] . '.' . $get_email_record[0]->usr_first_name . ' ' . $get_email_record[0]->usr_last_name;
                    } else{
                        $owner_name = $get_email_record[0]->usr_first_name . ' ' . $get_email_record[0]->usr_last_name;
                    }
                    $confirm_msg = 'You have entered the email address "' . $suggest_reviewer['email_address'] . '" for this user. But ' . $owner_name . ' is already registered in this system using this email address. click "confirm" to use the details of ' . $owner_name . ' otherwise click "No" and change the email address';
                    $return_data['status'] ='confirm';
                    $return_data['user_id'] =encrypt_link($get_email_record[0]->usr_id);
                    $return_data['msg'] =$confirm_msg;
                    $return_data['success']=false;
                    $userdetails=array();
                    if (!empty($get_email_record[0]->usr_id)) {
                        $displayarray=array();
                        $displayarray['user_id']=$get_email_record[0]->usr_id;
                        $displayarray['salutation']=true;
                        $displayarray['fullname_only']=true;
                        $displayarray['journal_id']=$jnl_id;
                        $displayarray['article_id']=$article_id;
                        $selected_user_name = $this->get_user_display_name($displayarray);
                        $us_details = $User::get_single_record('usr_id,usr_first_name,usr_email,usr_status, usr_id AS user_id',"usr_id={$get_email_record[0]->usr_id}");
                        $userdetails['fullname']=$selected_user_name['fullname'];
                        $userdetails['email']=protect_email($suggest_reviewer['email_address']);
                        $userdetails['user_id']=$get_email_record[0]->usr_id;
                        $userdetails['user_status']=$us_details->usr_status;
                    }
                    $return_data['user_data'] =$userdetails;
                    return $return_data;
                }

            }



            if (isset($suggested_user_id) && $suggested_user_id != "") {
                $user_id = $suggested_user_id;
            } else {
                $user_deeplink_token = Str::random(20);
                $date_format =  $this->get_platform_date_format($jnl_id);
                $date_format= date_format_map($date_format);
                $current_date_time = date($date_format . ' H:i:s');
                $password =  Str::random(8);
                $user_details = array(
                    'usr_username' => $suggest_reviewer['email_address'],
                    'usr_first_name' => $suggest_reviewer['firstname'],
                    'usr_last_name' => $suggest_reviewer['lastname'],
                    'usr_email' => $suggest_reviewer['email_address'],
                    'usr_title' => $suggest_reviewer['title'],
                    'usr_phone_no' => isset($suggest_reviewer['phonenumber'])? $suggest_reviewer['phonenumber']:'',
                    'usr_pwd' => md5($password),
                    'usr_deeplink_token' => $user_deeplink_token,
                    'usr_status' => 'w',
                    'usr_registered' => 'n',
                    'usr_jnl_standalone' => $stand_jnl_id
                );
                // var_dump($suggest_reviewer);die;
                $user_id = $User::insert_record($user_details, $currentuser);
                if($user_id) {
                    $newusername=$suggest_reviewer['firstname'].$user_id;
                    $data_username_new = array('usr_username' =>$newusername);
                    $user_condition = "usr_id = {$user_id}";
                    $User::update_record($data_username_new, $user_condition, $currentuser);
                    $this->emailchecker($suggest_reviewer['email_address'],$user_id,$currentuser);
                }

                $user_aff_details = array(
                    'usaff_user_id' => $user_id,
                    'usaff_email' => $suggest_reviewer['affiliationemail'],
                    //'usaff_department' => $suggest_reviewer['university'],
                    'usaff_department' => $suggest_reviewer['department'],
                    'usaff_company' => $suggest_reviewer['university'],
                    'usaff_state' => $suggest_reviewer['state'],
                    //	'usaff_ringgold_id' => $suggest_reviewer['university_id'],
                    //	'usaff_ringgold_family' => $suggest_reviewer['university_family'], //-- bug when the module is not activated
                    'usaff_address_line1' => $suggest_reviewer['address_line_1'],
                    'usaff_address_line2' => $suggest_reviewer['address_line_2'],
                    'usaff_postal_code' => $suggest_reviewer['postal_code'],
                    //'usaff_cnt_id' => $suggest_reviewer['title'],
                    'usaff_cnt_id' => $suggest_reviewer['country'],
                    'usaff_type' => $suggest_reviewer['type'],
                );


                if ($this->current_client->modules->mdl_ror == 'y' && !empty($suggest_reviewer['rorIdentifier']) && $suggest_reviewer['rorIdentifier'] != 'undefined') {
                    $data_affiliation['usaff_ror_id'] = $suggest_reviewer['rorIdentifier'];
                    $data_affiliation['usaff_ringgold_id'] = NULL;
                    $data_affiliation['usaff_ringgold_family'] = NULL;
                } elseif ($this->current_client->modules->mdl_ringgold == 'y' && !empty($suggest_reviewer['ringgoldIdentifier']) && $suggest_reviewer['ringgoldIdentifier'] != 'undefined') {
                    $data_affiliation['usaff_ror_id'] = NULL;
                    $data_affiliation['usaff_ringgold_id'] = $suggest_reviewer['ringgoldIdentifier'];
                    $post_data = array(
                        'search_key' => $suggest_reviewer['ringgoldIdentifier']
                    );
                    $response = $this->search_organisation($post_data, false, true);
                    $responseArr = json_decode($response);
                    $ringgoldFamily = (implode(',', array_column($responseArr->response, 'member')));
                    $data_affiliation['usaff_ringgold_family'] = '[' . $ringgoldFamily . ']';
                }


                if ($user_id){
                    $User_affiliation::insert_record($user_aff_details, $currentuser);
                }



                $userdetails=array();
                $return=array();
                if (!empty($user_id)) {
                    $displayarray=array();
                    $displayarray['user_id']=$user_id;
                    $displayarray['salutation']=true;
                    $displayarray['fullname_only']=true;
                    $displayarray['journal_id']=$jnl_id;
                    $displayarray['article_id']=$article_id;
                    $selected_user_name = $this->get_user_display_name($displayarray);
                    $us_details = $User::get_single_record('usr_id,usr_first_name,usr_email,usr_status, usr_id AS user_id',"usr_id={$user_id}");
                    $userdetails['fullname']=$selected_user_name['fullname'];
                    $userdetails['email']=protect_email($suggest_reviewer['email_address']);
                    $userdetails['user_id']=$user_id;
                    $userdetails['user_status']=$us_details->usr_status;
                    $hasuser = TRUE;
                }
                $return_data['user_data'] =$userdetails;
                $return_data['user_addnew'] ='add_new';
                $return_data['success']=true;
                return $return_data;
            }

        }
        return $return_data;

    }

    public function multiplereviwerdecline($article_id, $aflow_id,$suggest_reviewer,$suggest_flag,$bulksubmission) {
        $article_flow_table=(new \App\Models\Article_flow())->getTable();
        $Article_versions_reviewers=new \App\Models\Article_versions_reviewers();
        $Article_reviewers=new \App\Models\Article_reviewers();
        $Article_flow=new \App\Models\Article_flow();
        $User=new \App\Models\User();
        $Articles=new \App\Models\Articles;
        $Authors=new \App\Models\Authors();
        $Article_reviewer_suggest=new \App\Models\Article_reviewer_suggest();
        $User_affiliation=new \App\Models\User_affiliations();
        $currentuser= $this->get_current_user_details();
        $jnl_id=decrypt_link($suggest_reviewer['jnl_id']);
        $jnl_code=$suggest_reviewer['jnl_code'];
        $user_id=decrypt_link($suggest_reviewer['aflw_usr_id']);
        $multiplereviwerdata=$suggest_reviewer['multiplereviwerdata'];
        $jnl_standlone=$suggest_reviewer['jnl_standalone'];
        $art_parent_flw_id = decrypt_link($suggest_reviewer['art_parent_flw_id']);
        $core_role=$suggest_reviewer['core_role'];
        $insist_view_article=$suggest_reviewer['insist_view_article'];

        $reviewer_data = $return_data = array();
        $reason_for_rejection = '';
        
        $lastcount=0;
        $errmsg='';
        $return_data['success']=false;
        $today = date('Y-m-d H:i:s', time());
        if (isset($suggest_reviewer['custom_reason']) && $suggest_reviewer['custom_reason'] != "") {
            $reason_for_rejection = $suggest_reviewer['custom_reason'];
        } 
        elseif(isset($suggest_reviewer['hdn_reason_text']) && $suggest_reviewer['hdn_reason_text'] != "") {
            $reason_for_rejection = $suggest_reviewer['hdn_reason_text'];
        }        
        
        $multiplereviwercount=count($multiplereviwerdata);
        if(!empty($multiplereviwerdata) && isset($suggest_flag) && $suggest_flag == 'y') {
        foreach ($multiplereviwerdata as $user) {
            $user_deeplink_token = Str::random(20);
            $lastcount++;
            $suggested_user_id=$user['user_id'];
            $flag=0;
            
            if ( $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' ) {
                //Validate the reviewer because the user has already participated in a post-review stage.
                $res=$this->ValidateReviewerparticipated_postreviewstage($article_id,$user_id,$suggested_user_id,$jnl_id);
                if(!empty($res)){
                    $errmsg.=$res;
                    $flag=1;
                }

                if ($flag==0) {
                    //Validate the reviewer because the user has only one role.
                    $res=$this->ValidateReviewerhasonlyonerole($article_id,$suggested_user_id,$jnl_id,$jnl_code);
                    if(!empty($res)){
                        $errmsg.=$res;
                        $flag=1;
                    }
                }

                if ($flag==0) {
                    //Validate The assigned role of the reviewer should be changed before proceeding for flawless processing of this article.
                    $res=$this->ValidateReviewerassignedroles($article_id,$suggested_user_id,$jnl_id,$jnl_code);
                    if(!empty($res)){
                        $errmsg.=$res;
                        $flag=1;
                    }
                }
            }
        

        if ($flag==0) {
            //Validate reviewer already exist in the article.
            $res=$this->ValidateRevieweralreadyexist($article_id,$suggested_user_id,'m',$user['fullname'],$art_parent_flw_id);
            if(!empty($res)){
                $errmsg.=$res.'<hr/>';
                $flag=1;
            }
        }



            $stand_jnl_id = ($jnl_standlone == 'y') ? $jnl_id : null;
            if (isset($suggest_reviewer['email_address']) && $suggest_reviewer['email_address'] != "" && $flag==0 && $lastcount==$multiplereviwercount) {
                $check_email ="usr_email='{$suggest_reviewer['email_address']}'";
                if (isset($suggest_reviewer['hdn_confirm_user']) && $suggest_reviewer['hdn_confirm_user'] != "") {
                        $confirm_user=decrypt_link($suggest_reviewer['hdn_confirm_user']);
                        $check_email.=" AND usr_id!={$confirm_user}";
                    } else if (isset($suggested_user_id) && $suggested_user_id != "") {
                        $check_email.=" AND usr_id!={$suggested_user_id}";
                    }

                    $get_email_record = $User::get_user_by_email_journal($check_email, $stand_jnl_id);
                    if (count($get_email_record) > 0) {
                        //restrict the use of author details -- Bug #1312
                        $is_author = $Authors::get_single_record('count(auth_id) as cnt',"auth_art_id={$article_id} AND auth_usr_id={$get_email_record[0]->usr_id}");
                        if ($is_author->cnt > 0 || $get_email_record[0]->usr_id == $currentuser['user_id']) {
                            //exclude declined user and article authors
                            $msg =customTrans('accept_decline_invite.author_email_unable_touse');
                            $errmsg.=$msg;
                            $flag=1;
                            //return $this->success('warning',200,$return_data);
                        }
                        $all_titles =$this->UserConfigdata('titles')['titles'];
                        if(isset($all_titles[$get_email_record[0]->usr_title])) {
                            $owner_name = $all_titles[$get_email_record[0]->usr_title] . '.' . $get_email_record[0]->usr_first_name . ' ' . $get_email_record[0]->usr_last_name;
                        } else{
                            $owner_name = $get_email_record[0]->usr_first_name . ' ' . $get_email_record[0]->usr_last_name;
                        }
                        if($flag==0) {
                        $confirm_msg = 'You have entered the email address "' . $suggest_reviewer['email_address'] . '" for this user. But ' . $owner_name . ' is already registered in this system using this email address. click "confirm" to use the details of ' . $owner_name . ' otherwise click "No" and change the email address';
                        $return_data['status'] ='confirm';
                        $return_data['user_id'] =encrypt_link($get_email_record[0]->usr_id);
                        $return_data['msg'] =$confirm_msg;
                        $errmsg.=$confirm_msg;
                        $flag=1;
                        // return $this->success('warning',200,$return_data,'warning');
                        }
                    }

                }
                if($flag==1) {
                    continue;
                }

                if (isset($suggested_user_id) && $suggested_user_id != "") {
                    $user_id = $suggested_user_id;
                } else {
                    $date_format =  $this->get_platform_date_format($jnl_id);
                    $date_format= date_format_map($date_format);
                    $current_date_time = date($date_format . ' H:i:s');
                    $password =  Str::random(8);
                    $user_details = array(
                        'usr_username' => $suggest_reviewer['email_address'],
                        'usr_first_name' => $suggest_reviewer['firstname'],
                        'usr_last_name' => $suggest_reviewer['lastname'],
                        'usr_email' => $suggest_reviewer['email_address'],
                        'usr_title' => $suggest_reviewer['title'],
                        'usr_pwd' => md5($password),
                        'usr_deeplink_token' => $user_deeplink_token,
                        'usr_status' => 'w',
                        'usr_registered' => 'n',
                        'usr_jnl_standalone' => $stand_jnl_id
                    );
                    // var_dump($suggest_reviewer);die;
                    $user_id = $User::insert_record($user_details, $currentuser);
                    if($user_id) {
                        $newusername=$suggest_reviewer['firstname'].$user_id;
                        $data_username_new = array('usr_username' =>$newusername);
                        $user_condition = "usr_id = {$user_id}";
                        $User::update_record($data_username_new, $user_condition, $currentuser);
                        $this->emailchecker($suggest_reviewer['email_address'],$user_id,$currentuser);
                    }

                    $user_aff_details = array(
                        'usaff_user_id' => $user_id,
                        'usaff_email' => $suggest_reviewer['affiliationemail'],
                        //'usaff_department' => $suggest_reviewer['university'],
                        'usaff_department' => $suggest_reviewer['department'],
                        'usaff_company' => $suggest_reviewer['university'],
                        'usaff_state' => $suggest_reviewer['state'],
                        //	'usaff_ringgold_id' => $suggest_reviewer['university_id'],
                        //	'usaff_ringgold_family' => $suggest_reviewer['university_family'], //-- bug when the module is not activated
                        'usaff_address_line1' => $suggest_reviewer['address_line_1'],
                        'usaff_address_line2' => $suggest_reviewer['address_line_2'],
                        'usaff_postal_code' => $suggest_reviewer['postal_code'],
                        //'usaff_cnt_id' => $suggest_reviewer['title'],
                        'usaff_cnt_id' => $suggest_reviewer['country'],
                        'usaff_type' => $suggest_reviewer['type'],
                    );


                    if ($this->current_client->modules->mdl_ror == 'y' && !empty($suggest_reviewer['rorIdentifier']) && $suggest_reviewer['rorIdentifier'] != 'undefined') {
                        $data_affiliation['usaff_ror_id'] = $suggest_reviewer['rorIdentifier'];
                        $data_affiliation['usaff_ringgold_id'] = NULL;
                        $data_affiliation['usaff_ringgold_family'] = NULL;
                    } elseif ($this->current_client->modules->mdl_ringgold == 'y' && !empty($suggest_reviewer['ringgoldIdentifier']) && $suggest_reviewer['ringgoldIdentifier'] != 'undefined') {
                        $data_affiliation['usaff_ror_id'] = NULL;
                        $data_affiliation['usaff_ringgold_id'] = $suggest_reviewer['ringgoldIdentifier'];
                        $post_data = array(
                            'search_key' => $suggest_reviewer['ringgoldIdentifier']
                        );
                        $response = $this->search_organisation($post_data, false, true);
                        $responseArr = json_decode($response);
                        $ringgoldFamily = (implode(',', array_column($responseArr->response, 'member')));
                        $data_affiliation['usaff_ringgold_family'] = '[' . $ringgoldFamily . ']';
                    }


                    if ($user_id){
                        $User_affiliation::insert_record($user_aff_details, $currentuser);
                    }
                }






            //* start -- check the reviewer already suggested *//
            $reviewer_exist_condition = 'sorw_art_id = ' . $article_id . ' and sorw_suggested_reviewer_id = ' . $user_id . ' and  (aflw_status  !="d" OR (aflw_status ="d" and rjct_reinvite_flag = "y")) and aflw_parent_flow_id IN (select aflw_parent_flow_id from ' . $article_flow_table . ' where aflw_id=' . $aflow_id . ')';
            $result_cnt = $Article_reviewers::get_exist_reviewer('count(sorw_id) as cnt', $reviewer_exist_condition);
            $result = $Article_reviewers::get_exist_reviewer('sorw_id,rjct_reinvite_flag', $reviewer_exist_condition, 'sorw_id');
            //* end -- check the reviewer already suggested *//

            $email_notification = FALSE;
            if ($result_cnt->cnt == 0) {
                $reviewer_data = array(
                    'sorw_art_id' => $article_id,
                    'sorw_title' => $suggest_reviewer['title'],
                    'sorw_name' => $suggest_reviewer['firstname'],
                    'sorw_last_name' => $suggest_reviewer['lastname'],
                    'sorw_email' => $suggest_reviewer['email_address'],
                    'sorw_position' => $suggest_reviewer['position'],
                    'sorw_phone_number' => $suggest_reviewer['phonenumber'],
                    'sorw_department' => $suggest_reviewer['department'],
                    'sorw_university' => $suggest_reviewer['university'],
                    'sorw_cnt_id' => $suggest_reviewer['country'],
                    'sorw_state' => $suggest_reviewer['state'],
                    'sorw_postal_code' => $suggest_reviewer['postal_code'],
                    'sorw_reason' => $suggest_reviewer['reason_data'],
                    'sorw_action' => 's',
                    'sorw_rvwr_deeplink_token' => $user_deeplink_token,
                    'sorw_suggested_reviewer_id' => $user_id,
                    'sorw_suggested_user_id' => $currentuser['user_id'],
                    'sorw_suggested_on' => date('Y-m-d H:i:s', time()),
                    'sorw_suggested_user_role' => 'r'
                );

                if($this->current_client->modules->mdl_ror == 'y' && !empty($suggest_reviewer['rorIdentifier']) && $suggest_reviewer['rorIdentifier'] != 'undefined'){
                    $reviewer_data['sorw_ror_id'] = $suggest_reviewer['rorIdentifier'];
                  }elseif($this->current_client->modules->mdl_ringgold == 'y' && !empty($suggest_reviewer['ringgoldIdentifier']) && $suggest_reviewer['ringgoldIdentifier'] != 'undefined'){
                    $reviewer_data['sorw_ringgold_id'] = $suggest_reviewer['ringgoldIdentifier'];
                    $post_data = array(
                      'search_key' => $suggest_reviewer['ringgoldIdentifier']
                    );
                    $response = $this->search_organisation($post_data, false, true);
                    $responseArr = json_decode($response);
                    $ringgoldFamily = (implode( ',',array_column( $responseArr->response, 'member')));
                    $data['sorw_ringgold_family'] = '['.$ringgoldFamily.']';
                  }
                $reviewer_id = $Article_reviewers::insert_record($reviewer_data, $currentuser);
                $email_notification = TRUE;

                  $this->sugestion_reviewr_new($jnl_id,$user_id,$aflow_id,$reviewer_id,$article_id);


            } else {
                $reviewer_id = $result->sorw_id;
            }
// echo $reviewer_id;
//             die();
            $Article_reviewer_suggest::insert_record(array(
                'ars_sorw_id' => $reviewer_id,
                'ars_reason' => trim($suggest_reviewer['reason_data']),
                'ars_usr_id' => $currentuser['user_id'],
                ), $currentuser);

            $revier_exist = $Article_versions_reviewers::get_single_record('count(artvr_id) as count',"artvr_article_id={$article_id} AND artvr_user_id={$user_id}");

            if($revier_exist->count > 0) {
                $criteria_revwr ="artvr_article_id={$article_id} AND artvr_user_id={$user_id}";
                $Article_versions_reviewers::delete_records($criteria_revwr,'',$currentuser);
            }

            $get_article_rec = $Articles::get_single_record('art_pre_all_ids',"art_id={$article_id}");
            $reviwers_details = array(
                                        'artvr_user_id' => $user_id,
                                        //'artvr_prev_art_id' => $user_id,
                                        'artvr_article_id' => $article_id,
                                        'artvr_previous_art_ids' => $get_article_rec->art_pre_all_ids
                                );
            $Article_versions_reviewers::insert_record($reviwers_details,$currentuser);
            //* end -- adding suggested details to  rvw_article_version_reviewers*//

            $user_record_status = $User::get_single_record('usr_id,usr_first_name,usr_last_name,usr_status,usr_terms_condition',"usr_id={$user_id}");

            if($user_record_status->usr_status == "a" || $user_record_status->usr_status == "w") {
                if ($email_notification == FALSE) {

                    $Stage_email_templates=new \App\Models\Stage_email_templates();
                    $Email_send_log=new \App\Models\Email_send_log();


                    $select = 'art_id, art_title, art_artp_id, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_source_assignment_id,aflw_assignment_type_id, aflw_jwf_id,jwf_stage_type, jwf_stage_name, jwf_status_name, CONCAT(auth_sub.usr_title,  " ", auth_sub.usr_first_name, " ", auth_sub.usr_last_name) AS submitted_author, CONCAT(auth_coresp.usr_title,  " ", auth_coresp.usr_first_name, " ", auth_coresp.usr_last_name) AS coresp_author,aflw_level,aflw_reviewer_added_by_stage_status';

                    $article_details = $Articles::get_article_details($select,"aflw_id={$aflow_id}",NULL,TRUE);

                    $article_details = $article_details[0];
                    if(($article_details->aflw_source_assignment_id != NULL || $article_details->aflw_source_assignment_id != 0) && ($article_details->aflw_assignment_type_id != NULL || $article_details->aflw_assignment_type_id != 0) ) {
                        $aflw_data['aflw_source_assignment_id'] = $article_details->aflw_source_assignment_id;
                        $aflw_data['aflw_assignment_type_id'] = $article_details->aflw_assignment_type_id;
                    }
                    $article_type_id = $article_details->art_artp_id;
                    $aflw_jwf_id = $article_details->aflw_jwf_id;
                    $level = $article_details->aflw_level;
                    $usr_details = $User::get_single_record('*, usr_id AS user_id',"usr_id={$user_id}");
                    $user_name = $usr_details->usr_username;
                    $user_email = $usr_details->usr_email;
                    $name = $usr_details->usr_first_name;
                    if (isset($suggested_user_id) && $suggested_user_id != "") {
                        $link = '';
                        $Article_reviewers::update_record(array(
                            'sorw_rvwr_deeplink_token' => ''),"sorw_id={$reviewer_id}",$currentuser);
                        $aflw_data['aflw_usr_id'] = $user_id;
                        $aflw_data['aflw_art_id'] = $article_id;
                        $aflw_data['aflw_parent_flow_id'] = $art_parent_flw_id;
                        ;
                        $aflw_data['aflw_status'] = 'u';
                        $aflw_data['aflw_assigned_date'] = $today;
                        $aflw_data['aflw_jwf_id'] = $aflw_jwf_id;
                        $aflw_data['aflw_level'] = $level;
                        $aflw_id = $Article_flow::insert_record($aflw_data, $currentuser);

                        $reviewer_data = $Article_reviewers::update_record(array(
                            'sorw_suggestion_accepted' => 'y',
                            'sorw_aflw_id' => $aflw_id,
                            'sorw_suggested_user_id' => $currentuser['user_id']
                            ),"sorw_id={$reviewer_id}", $currentuser);
                    } else {

                        $custom_data=array(
                            'confirmation_link'=>URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/confirmreviewersuggestion/' . encrypt_link('&key=' . $user_deeplink_token . '&userid=' . $user_id . '&reviewer_id=' . $reviewer_id . '&article_type_id=' . $article_type_id . '&jnl_id=' . $jnl_id . '&aflw_id=' . $aflow_id),
                            'article_status_link'=>URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/view-article/' .encrypt_link($article_id) .'/'. encrypt_link($aflow_id) ,
                            'user_name'=>$user_name,
                            'usr_email'=>$user_email,
                             'article_id'=> $article_id,
                             'artp_id'=>$article_details->art_artp_id,
                             'jnl_id'=>$jnl_id,
                             'jnl_code'=>$jnl_code,
                             'aflw_id'=>$aflow_id,
                        );
                            $email_data=array(
                                'type'=>'global',
                                'action'=>'send',
                                'email_with_login'=>TRUE,
                                'user_id'=>$user_id,
                                'empt_name'=>'reviewer_suggestion',
                                'custom_data'=>$custom_data
                            );

                            $this->master_email_details($email_data);

                    }
                }
                $msg =customTrans('accept_decline_invite.invitation_reviewer_suggestion');
                //#581 for reviewer, after decline and suggesting a user show this msg in logout page
                $logout_redirect_msg    =   'decline-and-reviewer-sugg';
            } else {
                $errmsg =customTrans('accept_decline_invite.author_email_unable_touse');
                //return $this->success('warning',200,$return_data,'warning');
            }
       

    

        }
    }

        if($errmsg!='') {
            $return_data['msg']=$errmsg;
            return $return_data;
        }
        
            if (isset($aflow_id) && $aflow_id != '') {
        
                    $reason_data	=	$suggest_reviewer['reason_data'];
                    $user_id = $currentuser['user_id'];
                    $condition ="aflw_id={$aflow_id}";
         
           $data = array(
                            'aflw_status' => 'd',
                            'aflw_returned_date' => date('Y-m-d H:i:s'),
                            'aflw_remarks' => $reason_for_rejection);
                    if ((isset($insist_view_article) && $insist_view_article!= NULL && $insist_view_article==true)) {
                        $data['aflw_deeplink_token'] = '';
                    }
                    $update_result = $Article_flow::update_record($data, $condition, $currentuser);
                    if($update_result)
                    {
                        $this->mngReviewerversion($article_id,$aflow_id,$user_id,false);
                    }
                    //update with decline reason id
                    $Article_reviewers::update_record(array('sorw_rjct_id' => $reason_data),"sorw_aflw_id={$aflow_id}",$currentuser);
        
                    if ($update_result) {
        
                        if ($bulksubmission!=TRUE) {
                          /*Task #9205 AE Shortlist Reviewer in Pre Review Stage Alternative email not Send*/
                            $select = 'art_id, art_artp_id,art_title, aflw_id,artp_article_type, jnl_journal_name, jwf_id, jwf_stage_type,jwf_stage_name, jwf_status_name,aflw_parent_flow_id,aflw_id,jnl_journal_code,jnl_id,jwf_who_can_invite,jwf_avoid_email_notifications_to_roles,jwf_parent_user_roles,jnl_standalone_group,aflw_reviewer_added_by_stage_status,aflw_assignment_type_id,aflw_source_assignment_id,aflw_jwf_id';
                            $article_details = $Articles->get_article_details($select, "aflw_id={$aflow_id }");
                            $article_details = $article_details[0];
                            $reviews_completed = $Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_status IN ("i","a","c") AND aflw_parent_flow_id =' . $article_details->aflw_parent_flow_id);
                           
                            $parent_stage = $Article_flow::get_single_record('aflw_stage_min_users',"aflw_id={$article_details->aflw_parent_flow_id}");
                            /* check whether alternate reviewer exist for this particular user or article  start */
                            $Article_alternativereviewer_priority_settings = new \App\Models\Article_alternativereviewer_priority_settings();
                            if (isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y')) {
        
                                $alternative_user_priority_order_table = (new \App\Models\Article_user_alternativereviewer_priorityorder())->getTable();
                                $articleflow_table = (new \App\Models\Article_flow())->getTable();
                                $assg_tables_user = array(
                                            'main_table' => $articleflow_table,
                                            'join_table' => array(
                                                $alternative_user_priority_order_table => array($articleflow_table . '.aflw_id', $alternative_user_priority_order_table  . '.auap_aflw_id')
                                            )
                                );
                                $selectrewer = 'auap_id';
                                $criteria = "auap_usr_id={$user_id} AND auap_art_id={$article_id} AND auap_parent_flow_id={$article_details->aflw_parent_flow_id} AND aflw_status='u'";
                                $priority_settings_user = $Article_alternativereviewer_priority_settings::get_single_record('aaps_multiple_invitation_status	as multiple_invitation ', "aaps_usr_id={$user_id} AND aaps_art_id={$article_id} AND aaps_parent_flow_id={$article_details->aflw_parent_flow_id}");
                                if (isset($priority_settings_user->multiple_invitation) && $priority_settings_user->multiple_invitation == 'y')
                                    $limit = "";
                                else
                                    $limit = "1";
                                $alternatervwer = $Article_flow::get_results_using_joins($assg_tables_user, $selectrewer, $criteria, 'all', 'auap_id',$limit);
                            }
        
                            if (((isset($alternatervwer) && count($alternatervwer) == 0) || !isset($alternatervwer)) && (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))) {
                                $articleflow_table = (new \App\Models\Article_flow())->getTable();
                                $alternative_priority_order_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();
        
                                $assg_tables_flow = array(
                                            'main_table' => $articleflow_table,
                                            'join_table' => array(
                                                $alternative_priority_order_table => array($articleflow_table . '.aflw_id', $alternative_priority_order_table . '.afap_aflw_id')
                                            )
                                        );
        
                                $selectrewer = 'afap_id';
                                $criteria = "afap_art_id={$article_id}  AND afap_parent_flow_id={$article_details->aflw_parent_flow_id} AND aflw_status='u'";
                                $priority_settings_user = $Article_alternativereviewer_priority_settings::get_single_record('aaps_multiple_invitation_status	as multiple_invitation ', "aaps_usr_id=0 AND aaps_art_id={$article_id} AND aaps_parent_flow_id={$article_details->aflw_parent_flow_id}");
                                if (isset($priority_settings_user->multiple_invitation) && $priority_settings_user->multiple_invitation == 'y')
                                    $limit = "";
                                else
                                    $limit = "1";
                                $alternatervwer = $Article_flow::get_results_using_joins($assg_tables_flow, $selectrewer, $criteria, 'all', 'afap_number',$limit);
                            }
        
                            if(isset($alternatervwer) && count($alternatervwer) > 0) {
                                $reviews_completed->cnt = $reviews_completed->cnt + count($alternatervwer);
                            }
        
                            /* check whether alternate reviewer exist for this particular user or article  end */
                            if ($reviews_completed->cnt < $parent_stage->aflw_stage_min_users && $article_details->aflw_reviewer_added_by_stage_status != 'p') {
                                $this->send_decline_notification_email($article_details, $currentuser);
                            }
                        }
        
                        $custom_data=array(
                            'stage_etmp_action' => 'declined',
                            'reason_for_rejection'=>$reason_for_rejection
                            );
        
                        $email_data=array(
                                        'type'=>'stage',
                                        'action'=>'send',
                                        'email_with_login'=>TRUE,
                                        'user_id'=> $user_id,
                                        'aflw_id'=>$aflow_id,
                                        'custom_data'=>$custom_data,
                                        'jnl_user_role'=>array(
                                            'core_role'=>$core_role,
                                            // 'role_name'=>$jnl_array['role_name'],
                                            'jnl_id'=>$jnl_id,
                                            'jnl_journal_code'=> $jnl_code
                                        ),
                                    );
                            $send = $this->master_email_details($email_data);
                    }
        
        
        
                    }
                

        //#581 for reviewer , after decline redirect to logout page with decline msg
        $user_t_and_c_record = $User::get_single_record('usr_status,usr_terms_condition',"usr_id={$user_id}");
        if($user_t_and_c_record->usr_terms_condition == 'n' && isset($this->current_client->functionality->cfty_show_terms_conditions) && $this->current_client->functionality->cfty_show_terms_conditions == 'y') {
            // $invitation_url = base_url('logout?'.encrypt_link('status=' . $logout_redirect_msg));
            $return_data['invitation_url']='logout';
        }else {
            $return_data['invitation_url']='dashboard';
            // $invitation_url = base_url() . 'journal/' . $this->journal_code;
        }

        /* #625 Queue system for shortlisted reviewers auto invitation function */
        
        
        if ((isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y')|| isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))&&($bulksubmission!=TRUE)) {
          /*Task #9205 AE Shortlist Reviewer in Pre Review Stage Alternative email not Send*/
            if(isset($article_details->aflw_reviewer_added_by_stage_status)&&$article_details->aflw_reviewer_added_by_stage_status != 'r')
            {
             
               $count_min_max_reviewer= $this->get_min_max_count_pre_review_stage($article_details->aflw_assignment_type_id,$article_details->aflw_id,$article_details->aflw_source_assignment_id,$article_details->aflw_jwf_id);
               $parent_min_user=$count_min_max_reviewer->min_user;
               /* Task #9205 , alternate reviewer mail not sent when min count update( Criteria :-> if min value greater than 1 to lower of that min value or 1) =>  Start*/
               $reviews_completed_criteria = 'aflw_status IN ("i","a","c") AND aflw_assignment_type_id = '.$article_details->aflw_assignment_type_id.' AND aflw_art_id = '.$article_details->art_id.' AND aflw_jwf_id = '.$article_details->aflw_jwf_id;
               $reviews_completed = $Article_flow::get_single_record('count(aflw_id) as cnt', $reviews_completed_criteria);
               /* Task #9205 , alternate reviewer mail not sent when min count update( Criteria :-> if min value greater than 1 to lower of that min value or 1) =>  End*/
            }
            else
            {
                $parent_min_user=$parent_stage->aflw_stage_min_users;
                $reviews_completed = $Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_status IN ("i","a","c") AND aflw_parent_flow_id =' . $article_details->aflw_parent_flow_id);
            }
            /*Task #9205 End*/

               /*Task #9205 AE Shortlist Reviewer in Pre Review Stage Alternative email not Send*/
            if($reviews_completed->cnt < $parent_min_user){
            $array_rvwer_details=array();
            $array_rvwer_details['article_id']=$article_id;
            $array_rvwer_details['artflow_id']=$aflow_id;
            $array_rvwer_details['parentflow_id']=$art_parent_flw_id;
            $array_rvwer_details['jnl_id']=$jnl_id;
            $array_rvwer_details['jnl_code']=$jnl_code;
            $array_rvwer_details['core_role']=$core_role;
            if($article_details->aflw_reviewer_added_by_stage_status != 'p') {
                $this->auto_invite_reviewer($array_rvwer_details);
            } else {
                $this->auto_invite_reviewer_pre_review($array_rvwer_details);
            }  
            } 
        }
        $return_data['msg']=$errmsg;
        if($errmsg=='') {
            $return_data['msg']=customTrans('accept_decline_invite.invitation_declined');
            $return_data['success']=true;
        }
        return $return_data;


    }

    /**
     * Check whether a specific role is blinded towards current user or specified user
     *
     * @param integer|string   $blind_towards  speific role id or role name(optional if $blinded_user or $aflw_is is given)
     * @param integer $art_id id of the article to check
     * @param integer $user_id id of the user to check the blind, if not passed, current user id is taken if $usr_role_id is not passed(optional)
     * @param integer $usr_role_id role id of the user to which specifc role is checked against(optional)
     * @param integer|string $artp article type id or article type code(optional)
     * @param integer|string $jnl journal id or journal code(optional)
     * @param integer $blinded_user can be used if specifc role of blinded user is not avaiable(optional if $blind_towards and $aflw_id is specified)
     * @param integer $aflw_id article flow id(optional if $blind_towards is already specified)
     * 
     * @author Midhun Vijay <Midhun.1138.rvt@gmail.com>
     * @return boolean true if blinded else false
     */
    public function is_custom_blinded($blind_towards, $art_id, $user_id = null, $usr_role_id = null, $artp = null, $jnl = null, $blinded_user = null, $aflw_id = null)
    {
        if (($this->current_client->functionality->cfty_enable_custom_blinding ?? 'n') != 'y') {
            return false;
        }
        if($blinded_user === 0){
            return false;
        }
        $articles_model = new Articles();
        $article_type_model = new Article_types();
        $artp_adv_optn = new Article_type_advance_options();

        if (!$jnl && $art_id) {
            $jnl = ($articles_model)->with('journals')->find($art_id)?->journals?->jnl_journal_code;
            if(!$jnl){
                return false;
            }
        } elseif (is_numeric($jnl)) {
            $jnl = (new Journals())->findOrFail($jnl)?->jnl_journal_code;
        }
        if (!$jnl) {
            throw new \Exception("Journal code not found");
        }

        if (!$artp && $art_id) {
            $artp = ($articles_model)->with('article_types')->findOrFail($art_id)?->article_types?->artp_id;
        }
        if (!$artp) {
            throw new \Exception("Article type code not found");
        }

        if (is_numeric($artp)) {
            $atotp = ($artp_adv_optn)->select(['atotp_review_method', 'atotp_custom_blind_params'])->where('atotp_artp_id', '=', $artp)->get()->first();
        } else {
            $atotp = ($article_type_model)->with('article_type_advance_options')->select(['Article_type_advance_options'])->where('atotp_artp_id', '=', $artp)->get()?->first()->article_type_advance_options;
        }

        $method = $atotp->atotp_review_method;
        $params = $atotp->atotp_custom_blind_params;
        if ($method != 'c' || ($params != null && $params == '{}')) {
            return false;
        }
        $params = json_decode($params, true);
        $blind_ids = [];
        $non_article_user = false;
        $non_priv_role = config('general_config.non_priv_roles') ?? ['author', 'reviewer'];

        if (is_numeric($blind_towards)) {
            if($blind_towards == 0){
                return false;
            }
            $blind_ids = [$blind_towards];
            $blind_towards = (new Roles)->select(['role_assigned_role'])->find($blind_towards);
        } else if ($aflw_id) {
            $jwf_id = (new Article_flow())->setTable(Article_flow::$tbk_table)->select(['aflw_jwf_id'])->orderby('tbk_id', 'desc')->find($aflw_id)?->aflw_jwf_id;
            $role_id = Generic_flows::find($jwf_id)?->jwf_role_id;
            $blind_ids = [$role_id];
        } else if ($blinded_user) {
            $role_id_qry = Journals::get_records_by_raw_query("select group_concat(distinct role_id) as role_ids  from rvw_journal_workflows , rvw_article_flow, rvw_roles where aflw_jwf_id = jwf_id and jwf_role_id = role_id and aflw_art_id in (?) and aflw_usr_id = ? ", false, [$art_id, $blinded_user]);
            $blind_ids = isset($role_id_qry[0]) && $role_id_qry[0]->role_ids ? explode(',', $role_id_qry[0]->role_ids) : [];
            if(!$blind_ids){
                $role_id_qry = Authors::where([['auth_usr_id',$blinded_user],['auth_art_id', $art_id]])?->first();
                $blind_ids = isset($role_id_qry) ? [Roles::where('role_assigned_role', 'author')->get(['role_id'])?->first()?->role_id] : [];
            }
            if(!$blind_ids){
                $role_id_qry = User_articles::where([['usra_usr_id',$blinded_user],['usra_art_id', $artp]])->groupBy('usra_usr_id')->get([DB::raw('group_concat(distinct usra_role_id) as role_ids')])?->first();
                $blind_ids = isset($role_id_qry) && $role_id_qry->role_ids ? explode(',', $role_id_qry->role_ids) : [];
            }
            if(!$blind_ids){
                $non_article_user = true;
                $role_id_qry = User_to_journals::where([['usrj_usr_id',$blinded_user],['usrj_artp_id', $artp]])->groupBy('usrj_usr_id')->get([DB::raw('group_concat(distinct usrj_role_id) as role_ids')])?->first();
                $blind_ids = isset($role_id_qry) && $role_id_qry->role_ids ? explode(',', $role_id_qry->role_ids) : [];
                $skip_roles_qry_resp = Roles::whereIn('role_assigned_role', $non_priv_role)->get(['role_id'])->toArray();
                $skip_roles = array_column($skip_roles_qry_resp, 'role_id');
            }
        } else {
            $roles = (new Roles)->selectRaw('group_concat(distinct role_id) as role_ids')->where('role_assigned_role', '=', $blind_towards)->groupby(['role_assigned_role'])->get()?->first()?->role_ids;
            $blind_ids = explode(',', $roles);
        }
        if (!$user_id) {
            $user_id = session('user_id');
        }
        $latest_art_id = Articles::whereRaw(" Find_in_set('$art_id',art_pre_all_ids) ")->orderby('art_submission_date', 'desc')->limit(1)->get(['art_id'])[0]?->art_id ?? null;
        $art_id = $latest_art_id ?? $art_id;
        $qry_resp = $usr_role_id ? [json_decode(json_encode(['role_id' => $usr_role_id]))] : Journals::get_records_by_raw_query("select role_id, role_assigned_role  from rvw_journal_workflows , rvw_article_flow, rvw_roles where aflw_jwf_id = jwf_id and jwf_role_id = role_id and aflw_art_id = (?) and aflw_usr_id = ? ", false, [$art_id, $user_id]);
        if (isset($qry_resp[0])) {
            foreach ($qry_resp as $role_resp) {
                $blind = false;
                if (isset($params[$role_resp->role_id])) {
                    foreach ($blind_ids as $blind_id) {
                        if (in_array($blind_id, $params[$role_resp->role_id])) {
                            // $role_name = Roles::select('role_name')->find($blind_id)->role_name;
                            $blind = "anonymous user";
                        };
                    }
                } else {
                    $blind = false;
                }

                if ($blind && ($this->current_client->functionality->cfty_enable_strict_blinding ?? 'n') == 'y') {
                    return $blind;
                }
                if (!$blind && ($this->current_client->functionality->cfty_enable_strict_blinding ?? 'n') == 'n') {
                    return false;
                }
            }
            return $blind;
        } else {
            $is_blinded = true;
            if(!$user_id){
                return false;
            }
            $roles = $this->validate_user_journal($jnl, $user_id);
            $i = 0;
            foreach ($roles['role_id_name_list'] as $id => $value) {
                $i++;
                if (in_array($value['assigned_role'], $non_priv_role)) {
                    continue;
                }
                if (isset($params[$id])) {
                    foreach ($blind_ids as $blind_id) {
                        $is_blinded = "anonymous user";
                        if($non_article_user){
                            if(in_array($blind_id, $skip_roles)){
                                continue;
                            }
                        }
                        if (!in_array($blind_id, $params[$id])) {
                            $is_blinded = false;
                        } else {
                            if (($this->current_client->functionality->cfty_enable_strict_blinding ?? 'n') == 'y') {
                                return $is_blinded;
                            }
                        }
                    }
                } else {
                    $is_blinded = false;
                }
            }
        }
        return $is_blinded;
    }


    public function is_user_blinded($blind_towards, $art_id, $user_id = null, $usr_role_id = null, $jnl = null, $blinded_user = null, $aflw_id = null){
        $artp_id = Articles::find($art_id, ['art_artp_id'])?->art_artp_id;
        $atotp = Article_type_advance_options::select(['atotp_review_method', 'atotp_custom_blind_params'])->where('atotp_artp_id', '=', $artp_id)->get()->first();
        if(!$user_id){
            $user_id = session('user_id');
        }
        $qry_resp =  Journals::get_records_by_raw_query("select role_id, role_assigned_role  from rvw_journal_workflows , rvw_article_flow, rvw_roles where aflw_jwf_id = jwf_id and jwf_role_id = role_id and aflw_art_id = (?) and aflw_usr_id = ? ", false, [$art_id, $user_id]);
        $role = count($qry_resp ?? []) ? $qry_resp[0]->role_assigned_role : null;
        $method = $atotp->atotp_review_method;
        if (is_numeric($blind_towards)) {
            if($blind_towards == 0){
                return false;
            }
            $blind_towards = (new Roles)->select(['role_assigned_role'])->find($blind_towards);
        }
        if($method == 's' && $blind_towards == 'reviewer' && $role == 'author'){
            return true;
        }
        elseif($method == 'd' && (($blind_towards == 'reviewer' && $role == 'author') || $blind_towards == 'author' && $role == 'reviewer')){
            return true;
        }
        elseif($method == 'c'){
            return $this->is_custom_blinded($blind_towards, $art_id, $user_id, $usr_role_id, $artp_id, $jnl, $blinded_user, $aflw_id);
        }else{
            return false;
        }

    }

    //restricting edit-author url for users who are not allowed to view
    //TASK #3606 - Url redirecting issue in author submission - start
    public function confirm_author_access($arr)
    {
        $article_type_details = $this->article_type_settings_data($arr['article_type_code'], $arr['platform_id']);
        $current_user = $this->get_current_user_details();
        if ($arr['article_id'] != '') {
            $permitted_user = true;
            $get_current_art_status = Articles::get_single_record_with_bind_cond("art_status,art_prev_article_id,art_submitted_by,art_stage_submission_method,art_posted_by", array('art_id' => $arr['article_id']));
            if ($get_current_art_status->art_status == 'n' && $get_current_art_status->art_prev_article_id == '') {
                //submission method = o - normal author submitted papers, submitted author and all coauthors has the permission to access.
                //submission method = n - submitted to prodution papers
                $authors_list = Authors::get_single_record_with_bind_cond('GROUP_CONCAT(auth_usr_id) as auth_usr_id', array('auth_art_id' => $arr['article_id'] ));
                $authors_list_arr = array();
                if(isset($authors_list->auth_usr_id)){
                    $authors_list_arr = explode(',',$authors_list->auth_usr_id);
                }
                if(($get_current_art_status->art_stage_submission_method == 'o' || $get_current_art_status->art_stage_submission_method == 'b')){
                    if(!in_array($current_user['user_id'], $authors_list_arr)){
                        $permitted_user = false;
                    }
                } else if($get_current_art_status->art_stage_submission_method == 'n'){
                    if(($get_current_art_status->art_posted_by == $current_user['user_id']) || ($get_current_art_status->art_submitted_by == $current_user['user_id'])){
                        $permitted_user = true;
                    } else {
                        $permitted_user = false;
                    }
                }

                if ($permitted_user == false) {
                    $return_array['status'] = 'failed';
                    // $return_array['message'] = customTrans('validation.notPermittedUser');
                    $return_array['message'] = '';
                    // return $this->warning("Failed",201,$return_array);
                    return $return_array;
                }
            }
            if (isset($article_type_details->artp_article_type) && $article_type_details->artp_article_type != '' && $article_type_details->artp_article_submission_status == 'n' && $get_current_art_status->art_submitted_by == $current_user['user_id']) {
                $return_array['status'] = 'failed';
                $message = customTrans('validation.stopSubmissionMessage');
                $return_array['message'] = str_replace('##article_type##', $article_type_details->artp_article_type, $message);
                return $return_array;
            }
        }
    }
    //TASK #3606 - Url redirecting issue in author submission - end
    /* TASK #6805 Copy journal and manage article type icon is disabled */
    public function check_admin_access($permission_route,$current_user_roles)
    {
        $access=false;
        $condition_array=array("permission_route"=>$permission_route);
        $permission_roles = General_permission::get_single_record_with_bind_cond('permission_roles',$condition_array);

        $permission_data=array();
        if(isset($permission_roles->permission_roles)&&$permission_roles->permission_roles!=NULL)
        {
        $permission_data = json_decode($permission_roles->permission_roles);
        }

        if(count(array_intersect($permission_data, $current_user_roles)) > 0)
        {
           $access=true;
        }

        return $access;
    }
    /* TASK #6805 End */
    /* TASK #8105 Retire roles able to proxy as a another user 
    Commited date :- 27-08-2024
    Params :- user id , journal id , article id (for future needs).
    Function use :-  To check whether the current user has proxy permission privilege or not.
    Function logic :-  Take journal proxy permitted roles and current user journal roles with roles retire status, if user role have proxy permission and retire status is 'y' then user cant access proxt with retired roles
    if user have proxy permitted roles then that user cans proxy the other users.
    */
     public function check_user_proxy_access($user_id,$jnl_id,$art_id = null)
     {
         $proxy_access=false;
         $proxy_permission_roles =Journal_settings::get_single_record('jset_proxy_login', "jset_jnl_id={$jnl_id}");
         $proxy_allowed_roles = (isset($proxy_permission_roles) && !empty($proxy_permission_roles->jset_proxy_login)) ? json_decode($proxy_permission_roles->jset_proxy_login) : [] ;
         $condition="usrj_usr_id = {$user_id} AND usrj_jnl_id = {$jnl_id} AND usrj_artp_id IS NULL AND usrj_role_retired = 'n' ";
         $user_roles_in_journal = User_to_journals::get_single_record("GROUP_CONCAT(DISTINCT (usrj_role_id)) AS role_id", $condition);
         $user_role_array = (isset($user_roles_in_journal) && !empty($user_roles_in_journal->role_id)) ? explode(',',$user_roles_in_journal->role_id) : [] ;
         $common_roles = array_intersect($user_role_array, $proxy_allowed_roles);
         if(count($common_roles) > 0){
             $proxy_access=true;
            }
            return $proxy_access;
        }
    /* TASK #8105 End */
    /* TASK #7987, Retire and inactive issue. 
    Commited date :- 08-10-2024
    Params :- user id , journal id , prev_roles_id , $art_type_status(if user or role remove from the article type user with roles section) , article type id (for future needs).
    Function use :-  If the specified role that has at least one stage activity in any stage of the workflow, an info message for add new user into that particular role should be shown when change a user's status from active into Inactive/suspend or remove a user who have the mentioned.
    Same as above mentioned scenario, if we remove the role from the user, the info msg should be displayed to inform that to add new users into that role.
    Function logic :-  To check the specified-role / users roles in journal have more than one active users, user roles with related to the user in journal roles and journal workflow stages roles.
    */
    public function check_roles_of_user_in_journal_change_details($user_id, $jnl_id, $prev_roles_id = null, $art_type_status = false, $art_type_id = null)
    {
        $role_change_status = false;
        $warning_message = '';
        $restricted_roles = array();
        $role_id = '';
        $role_id_array = '';
        $non_privilage_role_criteria = "role_assigned_role IN ('author','reviewer')";
        $user_role_ids = Roles::get_all_records('group_concat(role_id) as roleids', $non_privilage_role_criteria);
        $type = $art_type_status ? 'a' : 'j';
        $user_roles_condition = "usrj_usr_id={$user_id} AND usrj_role_retired='n' AND usrj_jnl_id = {$jnl_id}";
        if (isset($user_role_ids[0]->roleids)) {
            $role_id_array = $user_role_ids[0]->roleids;
            if (isset($prev_roles_id)) {
                $role_id_array .= "," . $prev_roles_id;
            }
            $user_roles_condition .= " AND usrj_role_id not in (" . $role_id_array . ")";
            $user_roles_condition .= ($art_type_status) ? " AND usrj_artp_id = {$art_type_id} " : '';
        }
        $user_roles = User_to_journals::get_all_roles($user_roles_condition, TRUE, $type);
        foreach ($user_roles as $role_data) {
            $exist_user_with_roles_cond = "usrj_role_id={$role_data->role_id} AND usrj_jnl_id={$jnl_id}  AND usrj_usr_id <>{$user_id} AND usrj_role_retired='n' AND usr_status='a'";
            $result_data = User_to_journals::get_users_based_role($exist_user_with_roles_cond);
            if ($result_data < 1) {
                $check_role_used_in_workflow_or_not_sql = "SELECT jwf_fwm_id , GROUP_CONCAT(DISTINCT jwf_stage_name) FROM rvw_journal_workflows LEFT JOIN rvw_article_types ON jwf_fwm_id = artp_fwm_id LEFT JOIN rvw_user_journals ON artp_jnl_id = usrj_jnl_id WHERE  artp_jnl_id = {$jnl_id} AND jwf_role_id = {$role_data->role_id} GROUP BY jwf_fwm_id";
                $role_flow_data = Generic_flows::get_records_by_raw_query($check_role_used_in_workflow_or_not_sql, TRUE);
                if (isset($role_flow_data) && !empty($role_flow_data)) {
                    // $restricted_roles .= ($restricted_roles != '') ? ',' . $role_data->role_name : $role_data->role_name;
                    array_push($restricted_roles, $role_data->role_name);
                }
            }
        }
        if (!empty($restricted_roles)) {
            $index = 1;
            $roles_names = '';
            foreach ($restricted_roles as $retired_roles) {
                if ($index < count($restricted_roles)) {
                    $index++;
                    $roles_names .= ($roles_names != '') ? ',' .  $retired_roles : $retired_roles;
                } else {
                    $roles_names .= ($roles_names != '') ? ' and ' .  $retired_roles : $retired_roles;
                }
            }
            $warning_message = customTrans('manageusers.role-active-user-status-warning-head') . "{$roles_names}" . ($art_type_status ? customTrans('manageusers.role-active-user-status-art-type-warning-tail') : customTrans('manageusers.role-active-user-status-journal-warning-tail'));
        }
        return $warning_message;
    }
   /* TASK #7987 End */


   public function send_editor_suite_file_to_ftp($pass_data)
   {
        $return_arr = array('status' => false);
        $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
        $es_api_data  = Config::get($es_config);
        $es_ftp_folder = $es_api_data['ftp_folder_path'];
        $es_file_path = $es_api_data['ftp_file_path'];
        $actual_key_Path = $this->upload_folder_path('uploads/key_for_es/es.pem');
        $require_private_key = array();
        $require_private_key['sftp_flag'] 	= TRUE;
        $require_private_key['key_path'] 	= $actual_key_Path;
        $client_code = $this->current_client->clnt_client_code;
        $ftp_connection = array();
        $ssh ='';
        $conn_id='';
        $inside_path = strtoupper($client_code).'/'.$pass_data['folder_path'].'/';
        $destination_folder = $es_ftp_folder.$inside_path;
        $destination = $this->set_server_path_ftp($destination_folder,'ftp','pcori',FALSE);
        $ftp_connection = $this->connect_to_es();
        if(isset($ftp_connection['login']) && $ftp_connection['login'] == true)
        {
            $ssh = $ftp_connection['ssh'];
            $conn_id = $ftp_connection['conn_id'];
            $this->make_server_directory($conn_id,$destination, $require_private_key['sftp_flag'], $ssh);
            $source_file_path =  $pass_data['source_file_path'];
            if(file_exists($source_file_path))
            {
                $destination_file = $es_file_path.$inside_path.$pass_data['file_name'];
                $response = $this->put_files($conn_id,$destination_file,$source_file_path, $require_private_key['sftp_flag'],$ssh);
                if($response == true)
                {
                    $return_arr['status'] = true;
                }
            } 
        }  
        return $return_arr;
   }

   public function set_server_path_ftp($path, $upload_mode, $jnl_code, $jnl_floer = TRUE)
   {
       $ftp_location = '';
       if ($path != '') {

           $ftp_location = $this->set_path_slash($path, FALSE);
           if ($jnl_floer == TRUE) {
               $ftp_location .= '/' . $jnl_code;
           }
       } else {
           if ($jnl_floer == TRUE) {
               $ftp_location = '/' . $jnl_code;
           } elseif ($upload_mode == 'shell') {
               $ftp_location = '/';
           }
       }

       return $ftp_location;
   }


   public function connect_to_es()
   {
       try
       {
           $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
           $es_api_data  = Config::get($es_config);
           $es_ftp_host = $es_api_data['ftp_host'];
           $es_ftp_port = $es_api_data['ftp_port']; 
           $es_ftp_user = $es_api_data['ftp_user_name']; 
           $es_ftp_password = $es_api_data['ftp_password']; 
           $actual_key_Path = $this->upload_folder_path('uploads/key_for_es/es.pem');
           $require_private_key = array();
           $require_private_key['sftp_flag'] 	= TRUE;
           $require_private_key['key_path'] 	= $actual_key_Path;
           $client_code = $this->current_client->clnt_client_code;
           $ftp_connection = $this->remoteConneciton($es_ftp_host, $es_ftp_user, $es_ftp_password,$es_ftp_port,false);
           return $ftp_connection;
       }
       catch(\Exeception $e)
       {
           return FALSE;
       }   
   }

    /* TASK #9154, Peer review stage issues. TASK #3044,Ability for AEs to shortlist reviewers during Pre-Review
  Commited date :- 28-11-2024
  Params :- user id , article id , article flow id , $exclude notification id (if we want keep article notification for future reference in our system ) , article type id (for future needs).
  Function use :- to remove un wanted email templates and its corresponding attachemnts keep in table after its actual purpose done.
  Function logic :-  To check the article notification tables to get not using/un wanted article notification id/ids from the table and remove that from the table and also its related attachments from the email attachmennt table .
  */
    public function auto_delete_notification_templates_and_corresponding_attachments($art_details, $from_table = '', $exclude_data = '', $assignment_type = false)
    {
        try {

            // DB::enableQueryLog();
            $Workflow = new \App\Models\Generic_flows();
            $Article_flow = new \App\Models\Article_flow();
            $Email_attachments = new \App\Models\Email_attachments();
            $Stage_email_templates = new \App\Models\Stage_email_templates();
            $Article_notify_mail_templates = new \App\Models\Article_notification_emails();

            $art_id = $art_details['art_id'];
            $flow_id = $art_details['art_flow_id'];
            // if(!$assignment_type){ }
            // else{ }
            $user_id = $art_details['art_user_id'];
            $notify_get_type = $art_details['notify_get_type'];

            $remove_data = '';
            $templates_count = 0;
            $attachments_count = 0;
            $current_user = $this->get_current_user_details();
            $all_associated_notify_mails_ids = '';
            $get_flow_master_data = $Article_flow::get_single_record('aflw_jwf_id', "aflw_id = {$flow_id}");
            if (isset($get_flow_master_data->aflw_jwf_id) && !empty($get_flow_master_data->aflw_jwf_id)) {
                $flow_master_id = $get_flow_master_data->aflw_jwf_id;

                /** fetch stage type */
                $get_stage_type_records = $Workflow::get_single_record('jwf_stage_type', "jwf_id = {$flow_master_id}");
                $stage_type = $get_stage_type_records->jwf_stage_type;

                /** fetch stage assigned/linked all possible mails to for this stage */
                $fetch_all_possible_stage_email_temp_id_query = "SELECT GROUP_CONCAT(stage_etmp_id) AS temp_ids FROM rvw_stage_email_tmpls LEFT JOIN rvw_stage_email_tmpl_reference ON rvw_stage_email_tmpl_reference.setr_stage_etmp_id = rvw_stage_email_tmpls.stage_etmp_id where stage_etmp_stage_type='{$stage_type}' AND setr_jwf_id={$flow_master_id} AND stage_etmp_action='assigned'";
                $fetch_stage_email_templates_record = $Stage_email_templates::get_records_by_raw_query($fetch_all_possible_stage_email_temp_id_query);
                $stage_template_ids = $fetch_stage_email_templates_record[0]->temp_ids;

                /** Exclude notification id from the resultant data. */
                if ($exclude_data != '') {
                    $stage_template_ids = implode(',', array_diff(explode(',', $stage_template_ids), explode(',', $exclude_data)));
                    $templates_count = count(explode(',', $stage_template_ids));
                }

                /** fetch assigned templates in the stages based on the possible email templates */
                if ($from_table == 'notification') {
                    if (isset($notify_get_type) && !empty($notify_get_type) && $notify_get_type != '') {
                        $fetch_all_associated_article_notification_mails_condition = " ane_stage_etmp_id IN ({$stage_template_ids}) AND ane_art_id = {$art_id} AND ane_aflw_id ={$flow_id} AND ane_for = '{$notify_get_type}' ";
                    } else {
                        $fetch_all_associated_article_notification_mails_condition = " ane_stage_etmp_id IN ({$stage_template_ids}) AND ane_art_id = {$art_id} AND ane_aflw_id ={$flow_id} ";
                    }
                    $fetch_all_associated_article_notification_mails_records = $Article_notify_mail_templates::get_single_record(" GROUP_CONCAT(ane_id) AS notify_ids, COUNT(DISTINCT(ane_id)) AS temp_count ", $fetch_all_associated_article_notification_mails_condition);
                    $all_associated_notify_mails_ids = $fetch_all_associated_article_notification_mails_records->notify_ids;
                    $templates_count = $fetch_all_associated_article_notification_mails_records->temp_count;
                    // print_r($fetch_all_associated_article_notification_mails_records);die;
                }

                /** fetch attachments if they added in the multiple or single mail template select case with respect to the notification table (ane id) */
                if($templates_count>0){
                    $fetch_attachment_records = $Email_attachments::get_single_record(" GROUP_CONCAT(DISTINCT(emat_id)) AS attachment_ids, COUNT(DISTINCT(emat_id)) AS attach_count ", " emat_art_id = {$art_id}  AND emat_ane_id IN ({$all_associated_notify_mails_ids}) ");
                    $attachment_ids = $fetch_attachment_records->attachment_ids;
                    $attachments_count = $fetch_attachment_records->attach_count;
                }

                if (isset($all_associated_notify_mails_ids) && !empty($all_associated_notify_mails_ids && $templates_count > 0)) {
                    if ($from_table == 'notification') {
                        $template_result = $Article_notify_mail_templates::delete_records("ane_id IN ({$all_associated_notify_mails_ids})", '', $current_user);
                        $remove_data .= " removed notification templates (id) " . $all_associated_notify_mails_ids;
                    }
                    if (isset($attachment_ids) && !empty($attachment_ids && $attachments_count > 0)) {
                        $attach_result = $Email_attachments::delete_records("emat_id IN ({$attachment_ids})", '', $current_user);
                        $remove_data .= " removed attachements (id) " . $attachment_ids;
                    }
                }
                return $remove_data;
            }
        } catch (\Exception $e) {
          /*  print_r($e);      */
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_file_name_and_path($atth_data)
    {
        $return_arr = array();
        $attachment_file_name_org = $atth_data->atmnt_file_name;
        $attachment_file_path_org = $atth_data->atmnt_orginal_upload_path;
        if(strpos($attachment_file_name_org, '/') !== false) {
            $parts = explode('/', $attachment_file_name_org);
            $total_length = count($parts);
            foreach($parts as $part_index => $single_parts)
            {
                if($part_index + 1 == $total_length)
                {
                    $attachment_file_name_org = $single_parts;
                }
                else
                {
                    $attachment_file_path_org .= '/'.$single_parts;
                }
            }
        }
        $return_arr['file_name'] = $attachment_file_name_org;
        $return_arr['file_path'] = $attachment_file_path_org;
        return $return_arr;
    }
    /* TASK #7987, Retire and inactive issue. 
    Commited date :- 16-12-2024
    Params :- $jnl_id, $user_ids, $role_ids.
    Function use :-  To check the user is already exist under the jounral and if exist check the new roles added from article types are retired in journal or not.
    If the user roles is retired then show an warning msg to that user with that role cant be added into the article type due to role retired in the journal
    Function logic :-  To check the specified-role of users is exist in user journal table and check if exist with retire flag status.
    Bug fixing on Taskbot  Task #1258, User role retire and inactive issue -> to check the conditions on adding new roles into users.(02/04/2025)
    */
    public function validate_save_platform_user_roles($jnl_id, $user_ids, $role_ids)
    {
        $warning_message = '';
        $warning_data = array();
        $restricted_data = array();
        $restricted_users = array();
        if(isset($role_ids) && !empty($role_ids) && count($role_ids) != 0) {
            $role_ids = implode(',',$role_ids);
            foreach ($user_ids as $user_id) {
                $user_roles_condition = "usrj_usr_id = ? AND usrj_role_id IN (?) AND usrj_jnl_id = ? AND `usrj_artp_id` IS NULL";
                $user_roles_cond_array = [$user_id, $role_ids, $jnl_id];
                $user_roles = User_to_journals::get_single_record_with_bind_cond("CASE WHEN COUNT( CASE WHEN usrj_role_retired = 'y' THEN 1 END ) > 0 THEN 'r' ELSE 'a' END AS role_retired_status, GROUP_CONCAT(DISTINCT CASE WHEN usrj_role_retired = 'y' THEN `usrj_role_id` END ) AS retired_roles ", null,$user_roles_condition,$user_roles_cond_array);
                if (isset($user_roles) && !empty($user_roles) && !empty($user_roles->role_retired_status) && $user_roles->role_retired_status === 'r' ) {
                    $roles_id = (!empty($user_roles->retired_roles) ? $user_roles->retired_roles : '');
                    array_push($restricted_users, $user_id);
                    $roles_criteria = "role_id IN (?)";
                    $roles_bind_array = [$roles_id];
                    $user_roles_details = Roles::get_single_record_with_bind_cond("CASE WHEN COUNT(*) > 1 THEN CONCAT( SUBSTRING_INDEX( GROUP_CONCAT( `role_name`ORDER BY `role_id` SEPARATOR ', ' ), ',', LENGTH( GROUP_CONCAT( `role_name` ORDER BY `role_id` SEPARATOR ', ' ) ) - LENGTH( REPLACE ( GROUP_CONCAT( `role_name` ORDER BY `role_id` SEPARATOR ', ' ), ',', '' )) ), ' and', SUBSTRING_INDEX( GROUP_CONCAT( `role_name` ORDER BY `role_id` SEPARATOR ', '),',',-1)) ELSE GROUP_CONCAT(`role_name` ORDER BY `role_id` SEPARATOR '' ) END AS roles", null, $roles_criteria, $roles_bind_condition);
                    $user_criteria = "usr_id = ? ";
                    $user_bind_array = [$user_id];
                    $user_details = User::get_single_record_with_bind_cond('GROUP_CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name SEPARATOR ", ") AS usr_name,usr_email', null, $user_criteria, $user_bind_array);
                    $retired_data = array(
                        'usr_name' => $user_details->usr_name,
                        'usr_email' => $user_details->usr_email,
                        'usr_roles' => $user_roles_details->roles,
                        'usr_roles_count' => count(explode(',', $roles_id))
                    );
                    array_push($restricted_data, $retired_data);
                }
            }
        }
        if (!empty($restricted_data) && isset($restricted_data)) {
             array_push($warning_data, $retired_data);
             $warning_message = customTrans('manageusers.retired-roles-in-journal-added-through-article-types-warning');
         }
         $return_data = array(
            'usr_id' => $restricted_users,
            'msg' => $warning_message,
            'data' => $warning_data,
            'error_status' => (!empty($restricted_data) && isset($restricted_data)) ? true : false,
        );
        return $return_data;
    }
   /* TASK #7987 End */


    public function get_clientfieldrequired_functionalities() {

        // Initializing variables
        $conf_client_functionalities = array();
        $db_client_functionalities = array();
        $final_client_functionalities = array();
    
   
        // If config file exists
        // if(file_exists($path))
        // {
        // Getting config data
        $conf_client_functionalities = Config::get('client_fieldvalidation.fieldvalidation');
    
        // }
    
        // Getting client functionalities from database
        $cfv_tbl = new \App\Models\Client_fieldvalidation();
        $client_functionalities_db = $cfv_tbl::get_all_records_with_bind_cond('cfv_validate_fields, cfv_status');
    
        // Traversing through the rows to create an array of client functionalites
        if (!empty($client_functionalities_db)) {
            foreach ($client_functionalities_db as $row) {
                $db_client_functionalities[$row->cfv_validate_fields] = $row->cfv_status;
            }
        }
        // Getting the functionalities which are not in db
        $func_only_in_conf = array_diff_key($conf_client_functionalities, $db_client_functionalities);
    
        // Resetting all the values in $func_only_in_conf array to 'n' except 'cfty_keyword_hierarchy'
        array_walk($func_only_in_conf, function (&$value, $key) {
            $value = $key == 'cfty_keyword_hierarchy' ? 'c' : 'n';
        });
    
        // Merging arrays $common_functionalities and $func_only_in_conf
        $final_client_functionalities = array_merge($db_client_functionalities, $func_only_in_conf);
    
        // Return the array:$final_client_functionalities as object
        return (object) $final_client_functionalities;
   /*Global function to get es integration permissions for document access*/
    }

   public function get_es_integrations_permissions($pass_data)
   {
        $main_converted = false;
        $es_data_array = array();
        $check_main_doc_type = Articles::get_single_record_with_bind_cond('art_es_document_type',array('art_id' => $pass_data['article_id']));
        if($check_main_doc_type->art_es_document_type == 'u')
        {
            $attachmenttable = (new \App\Models\Attachment_files())->getTable();
            $attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
            $tables = array(
                     'main_table' => $attachmenttable,
                     'join_table' => array(
                         $attachment_file_description_table => array($attachment_file_description_table . '.afdec_id', $attachmenttable . '.atmnt_label',"inner"),)
                    );
            $criteria = 'afdec_main_document = \'y\' AND atmnt_doc_created_in_es = \'y\' AND atmnt_art_id ='.$pass_data['article_id'];
            $select = 'count(atmnt_id) as cnt';
            $main_doc_created = Attachment_files::get_results_using_joins($tables, $select, $criteria);
            if($main_doc_created[0]->cnt > 0)
            {
                $main_converted = true;
            }    
        }
        if($check_main_doc_type->art_es_document_type == 'n')
        {
            $main_converted = true;
        }
        
        $article_data = (object) [
                'artp_id' =>$pass_data['artp_id'],
                'art_id' =>$pass_data['article_id'],
                'artp_fwm_id'=>$pass_data['artp_fwm_id'],
                'jnl_journal_code'=>$pass_data['jnl_code'],
                'art_artp_id'=>$pass_data['artp_id']
        ];
        $jnl_code = $pass_data['jnl_code'];
        $article_privilages = $this->article_privilages($article_data,NULL,$jnl_code,'all',TRUE);
        if($main_converted == true && !in_array($pass_data['flow_status'],['i','d','g']))
        {
            $comment_mode = false;
            $active_stage = false;
            if(in_array($pass_data['flow_status'],['a','u']))
            {
                $comment_mode = true;
                $active_stage = true;
            }
            if($pass_data['flow_status'] == 'w' || $pass_data['flow_status'] == 'p')
            {
                $criteria = 'aflw_parent_flow_id = '.$pass_data['flow_id'];
                $parent_count = Article_flow::get_single_record('count(aflw_id) as cnt', $criteria);
                if($parent_count->cnt < $pass_data['aflw_stage_min_users'])
                {
                    $comment_mode = true;
                    $active_stage = true;
                } 
            }
            if($article_privilages['author'] == true && $pass_data['stage_type'] == 'resubmission' && in_array($pass_data['flow_status'],['u']))
            {
                $comment_mode = false;
                $active_stage = false;
            }
            $es_data_array['comment_mode'] = $comment_mode;
            $user_roles= $this->validate_user_journal($jnl_code,$this->current_user['user_id']);
            $role_data = Roles::get_single_record('role_assigned_role',"role_id={$pass_data['role_id']}");
            if((((isset($pass_data['jp_edit_article_files']) && $pass_data['jp_edit_article_files'] != NULL) && count(array_intersect($user_roles['role_id'], json_decode($pass_data['jp_edit_article_files']))) > 0 && $article_privilages['reviewer'] == false && $article_privilages['author'] == false && $role_data->role_assigned_role !== 'author') || ($article_privilages['author'] == true && $role_data->role_assigned_role == 'author')) &&  $active_stage == true)
            {
                $es_data_array['edit_mode'] = true;
            }
            else
            {
                $es_data_array['edit_mode'] = false;
            }
            $is_custom_form_usr = false;
            if($pass_data['stage_type'] == 'review' && ($pass_data['flow_status'] == 'a' || $pass_data['flow_status'] == 'c') && $this->current_user['user_id'] == $pass_data['flow_usr_id'])
            {
                $is_custom_form_usr = true;
            }
            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
            $es_api_data  = Config::get($es_config);
            $es_data_array['es_url'] = $es_api_data['api_url'];
            $es_data_array['is_custom_form_usr'] = $is_custom_form_usr;
            $es_data_array['flow_id'] = $pass_data['flow_id'];
        }
        return $es_data_array;
    }

    /*Task #870 join as author button management in no adhoc submission*/
public function get_adhoc_submission_type_data($jnl_id)
{
    $criteria = 'artp_jnl_id = '.$jnl_id .' AND artp_status = \'y\' AND JSON_SEARCH(artp_login_user_type, \'all\', \'a\') IS NOT NULL ';
    if (isset($this->current_client->functionality->cfty_enable_stop_submission_in_article_type) && $this->current_client->functionality->cfty_enable_stop_submission_in_article_type == 'y')
    {
        $criteria .= 'AND artp_article_submission_status = \'y\'';
    }
    $select = 'count(artp_id) as cnt';
    $article_types =Article_types::get_single_record($select,$criteria);
    return  $article_types;

}
/* Personal email checker for merge users */
public function emailchecker($email,$user_id,$userdata) {

    $domain = substr(strrchr($email, "@"), 1);
    $emailcheck_config= Config::get('emailCheckerConfig');

    $flag_id=Flags::get_single_record_with_bind_cond('flag_id' ,array('flag_type' => 's','flag_name' =>'Personal email','flag_status' => 'y'));
    if (!in_array($domain, $emailcheck_config['domains'])) {

        $whereCondition='ugf_user_id='.$user_id.' AND ugf_flag_id='.$flag_id->flag_id;
        User_global_flags::delete_records($whereCondition,'',$userdata);
    }
    /*
    else{
             $insert_data = array(
            'ugf_user_id' => $user_id,
            'ugf_flag_id' => $flag_id->flag_id,
            'ugf_operation' => 'z'
        );
       User_global_flags::insert_record($insert_data,$userdata);
    }
       */
}


/*End Task #870 join as author button management in no adhoc submission*/

/*common function for checking file permissions for es documents*/
public function main_doc_permission($array_data)
{
    $Attachment_file_description = new \App\Models\Attachment_file_description();
    $Attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
    $Required_file_type_tbl = (new \App\Models\Required_file_type())->getTable();
    if($array_data['core_role'] == null)
    {
        $core_role = Roles::get_single_record_with_bind_cond('role_assigned_role',array('role_id' => $array_data['role_id']));
        $array_data['core_role'] = $core_role->role_assigned_role;
    }
    $join_tbls = array(
                    'main_table' => $Attachment_file_description_table,
                    'join_table' => array(
                        $Required_file_type_tbl => array($Required_file_type_tbl . '.rft_file_desp_id', $Attachment_file_description_table . '.afdec_id')
                    )
                );
    $select_fields_decripin = 'afdec_viewable_roles,afdec_description';
    $criteria_check = 'rft_artp_id=' .$array_data['artp_id'].' AND afdec_main_document =\'y\'';
    $get_main_attachment = $Attachment_file_description::get_results_using_joins($join_tbls, $select_fields_decripin, $criteria_check, 'single');     
    $is_viewable = false;
    if(!empty($get_main_attachment))
    {
        $viewable_roles = explode(',',$get_main_attachment->afdec_viewable_roles);
        if(in_array($array_data['role_id'],$viewable_roles) || $array_data['core_role'] == 'journal_admin' || $array_data['article_privillages']['author'] == true)
        {
            $is_viewable = true;
        }
    }
    return $is_viewable;
}
//Task #3029 After article submission, the cp team member should able to change the submitting author
 public function change_submitted_by_in_article($change_submitted_by) {
        try{
            $Email_templates = new \App\Models\Email_templates;
            if(isset($change_submitted_by))
            {
                $article_flow_update =array();
                $journal_code = Journals::find($change_submitted_by['jnl_id'], ['jnl_journal_code'])?->jnl_journal_code;
                if (($change_submitted_by['aflw_status'] == 'u' || $change_submitted_by['aflw_status'] == 'a') && $change_submitted_by['flow_role'] == 'author' && $change_submitted_by['workflo_flow_id'] == $change_submitted_by['aflw_jwf_id']) {
                   $article_flow_update['aflw_usr_id']=$change_submitted_by['new_user_id'];  
                   $flow_update_condition="aflw_art_id={$change_submitted_by['article_id']} AND aflw_jwf_id={$change_submitted_by['aflw_jwf_id']}";
                    Article_flow::update_record($article_flow_update, $flow_update_condition, $this->currentuser);
                }
                    $emails = [
                    [
                        'template' => 'change_submitting_old_author',
                        'user_id'  => $change_submitted_by['old_user_id'],
                    ],
                    [
                        'template' => 'change_submitting_new_author',
                        'user_id'  => $change_submitted_by['new_user_id'],
                    ],
                 ];

            foreach ($emails as $email) {
            $record = $Email_templates::get_single_record_with_bind_cond( "*",['etmp_name' => $email['template'],'etmp_notification' => 'User']);
            if ($record !== null) {
                $article_details = Articles::where('art_id',$change_submitted_by['article_id'])->get('art_artp_id')->first();
                $custom_data = [
                    'esl_etmp_action' => $email['template'],
                    'jnl_id' => $change_submitted_by['jnl_id'],
                    'jnl_code' => $journal_code,
                    'article_id' => $change_submitted_by['article_id'],
                    'aflw_id' => $change_submitted_by['aflw_id'] ?? null,
                    'artp_id'=> $article_details->art_artp_id
                ];

                $email_data = [
                    'type' => 'global',
                    'action' => 'send',
                    'email_with_login' => false,
                    'user_id' => $email['user_id'],
                    'empt_name' => $email['template'],
                    'custom_data' => $custom_data,
                ];
             $this->master_email_details($email_data);
                    }

                     }

            
        }
    }catch(\Exception $e)
        {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*Task #1787 Due date in settings page */
    public function check_creation_due_date($jnl_id,$active_default_role) {
        try {
            $roles_affecting_due_date=['editor_in_chief'];
            $conf_due_date_enabled = isset($this->current_client->functionality->cfty_conf_article_submission_due_date) 
                && $this->current_client->functionality->cfty_conf_article_submission_due_date === 'y';

            $conf_proceedings_enabled=$this->check_client_proceeding();

            if ($conf_due_date_enabled && $conf_proceedings_enabled && isset($jnl_id) && isset($active_default_role['core_role'])
            && in_array($active_default_role['core_role'], $roles_affecting_due_date)) {
                $journal_settings = Journal_settings::get_single_record_with_bind_cond(
                    'jset_conf_duedate,jset_date_format',
                    ['jset_jnl_id' => $jnl_id]
                );

                if ($journal_settings && !empty($journal_settings->jset_conf_duedate)) {
                    $duedate = new DateTime($journal_settings->jset_conf_duedate);
                    $today = new DateTime('today');

                    return $duedate < $today;
                }
            }

            return false;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
 /*end Task #1787 Due date in settings page */

/*
 * fetch the client's proceeding config array 
 * returns array
 * param can be empty or a string
 * */
 public function fetch_client_proceeding_config_array($input = '') {
    if($input != '')
        $proceeding_config = 'clients.' . $this->current_client->clnt_client_code . '.proceeding_config.'.$input;
    else
        $proceeding_config = 'clients.' . $this->current_client->clnt_client_code . '.proceeding_config';
    $proceeding_array  = Config::get($proceeding_config);
    
    if(isset($proceeding_array)) {
        return $proceeding_array;
    } else {
        return array();
    }
 }
public function restrict_delete_form($removed_forms=array(),$stage_id=null,$jnlcode=null,$mode=null){
    try{
               $result=array();
               $articleTable = (new \App\Models\Articles())->getTable();
               $flowTable = (new \App\Models\Article_flow())->getTable();
               $ArticleFlow = new \App\Models\Article_flow();
               $remove_restrict_form = [];
               $Article_generic_form_data = new \App\Models\Article_generic_form_data();
               $Generic_forms_table = (new \App\Models\Generic_forms)->getTable();
               $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
               $form_select = 'GROUP_CONCAT(DISTINCT gncf_form_name) as gncf_form_name';

               $tables = [
                   'main_table' => $flowTable,
                   'join_table' => [
                       $articleTable => [$articleTable . '.art_id', $flowTable . '.aflw_art_id', "inner"]
                   ]
               ];

               $criteria = "aflw_jwf_id=:stage_id and aflw_status ='a' and art_delete_status !='d'";
               $binding = ['stage_id' => $stage_id];

               $formDetails = $ArticleFlow::get_results_using_joins(
                   $tables,
                   'distinct aflw_id, aflw_art_id',
                   $criteria,
                   'all',
                   null,
                   null,
                   '',
                   null,
                   null,
                   false,
                   null,
                   false,
                   $binding
               );

               if (!empty($removed_forms) && !empty($formDetails)) {
                   $formattedJournalCode = '_' . $jnlcode;
                       foreach ($formDetails as $detail) {
                        $where = ' gdata_artflw_id =  ' . $detail->aflw_id . ' AND gdata_art_id = ' . $detail->aflw_art_id  . ' AND gdata_atf_id IN(' . implode(',', $removed_forms) . ')';
                        $details_tables = array(
                        'main_table' => 'rvw_article_gnf_form_data' . $formattedJournalCode,
                        'join_table' => array(
                            $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formattedJournalCode . '.gdata_atf_id'),
                            $Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formattedJournalCode . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id','left')
                        )
                );
                $order_by = "gdata_data_order,gdata_posted_date asc";
                     $existData = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', $order_by, null, '', null, null, true);
                           if (!empty($removed_forms) && !empty($existData) &&  isset($existData[0]->gncf_form_name) && !empty($existData[0]->gncf_form_name) )
                           {
                            $existData=$existData[0];
                            $remove_restrict_form=explode(',',$existData->gncf_form_name);
                           }
                   }
               }
               if (!empty($remove_restrict_form)) {
                   $formNames = array_values($remove_restrict_form); // Get just the form names
                   if (count($formNames) === 1) {
                       $message =customTrans('customform.restrict_form_validation_single',array('labelval'=>ucfirst(strtolower($formNames[0]))));
                   } else {
                       // Bold each form name individually
                       $boldFormNames = array_map(function($name) {
                           return '<strong>' . ucfirst(strtolower($name)) . '</strong>';
                       }, $formNames);

                       $lastForm = array_pop($boldFormNames);
                       $formList = count($boldFormNames) > 1
                           ? implode(', ', $boldFormNames) . ' and ' . $lastForm
                           : $boldFormNames[0] . ' and ' . $lastForm;
                       $message =customTrans('customform.restrict_form_validation',array('labelval'=>$formList));
                   }
                   $result['remove_restrict_form']=$remove_restrict_form;
                   $result['msg']=$message;
                   }
               return  $result;
   }
   catch(\Exception $e)
   {
   return $this->failure('Failed',500,$e);
   }

   }
    
   public function createOrUpdateClassification($term,$jnl_id,$artp_id = NULL,$article_id){    //Task #1850
        $term_table = (new \App\Models\Terms())->getTable();
        $classification_table = (new \App\Models\Classifications())->getTable();
        $current_user = $this->get_current_user_details();
        $criteria = 'term_name LIKE ?';
        if (empty($term)) {
         $term_exist = null;
          } else {
		$term_exist = Terms::get_single_record_with_bind_cond('term_id', sting_cond:$criteria,bind_data:['%' . $term . '%']);
          }
        if($term_exist){
            $tables = array(
                'main_table' => $term_table,
                'join_table' => array(
                    $classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
                )
            );
            $criteria = [
                'cls_term_id' => $term_exist->term_id,
                'cls_jnl_id' => $jnl_id,
            ];
            // ($artp_id != "")?$criteria['cls_artp_id'] = $artp_id:"";
            $classification_details = Classifications::get_results_using_joins($tables,'*', $criteria, 'single');
            if(!empty($classification_details)){
                $art_classification_criteria = [
                    'arcls_art_id' => $article_id,
                    'arcls_cls_id'  => $classification_details->cls_id,
                    'arcls_posted_date' => date('Y-m-d H:i:s'),
                    'arcls_posted_by'   => $current_user['user_id'],
                    'arcls_proxy_id'    => $current_user['proxy_user_id'],
                    'arcls_operation'   => 'i',
                ];
                Article_classification::firstOrCreate($art_classification_criteria);
            }else{
                $classification_data = [
                    'cls_term_id' => $term_exist->term_id,
                    'cls_jnl_id'  => $jnl_id,
                    'cls_posted_date' => date('Y-m-d H:i:s'),
                    'cls_posted_by'   => $current_user['user_id'],
                    'cls_proxy_id'    => $current_user['proxy_user_id'],
                    'cls_operation'   => 'i'
                ];
                $new_classification = Classifications::create($classification_data);
                Article_classification::create([
                    'arcls_art_id' => $article_id,
                    'arcls_cls_id'  => $new_classification->cls_id,
                    'arcls_posted_date' => date('Y-m-d H:i:s'),
                    'arcls_posted_by'   => $current_user['user_id'],
                    'arcls_proxy_id'    => $current_user['proxy_user_id'],
                    'arcls_operation'   => 'i'
                ]);
            }
        }else{
            $new_term = new Terms;
            $new_term->term_name = $term;
            $new_term->term_custom_addition = 'n';
            $new_term->term_posted_by = $current_user['user_id'];
            $new_term->term_posted_date = date('Y-m-d H:i:s');
            $new_term->term_proxy_id = $current_user['proxy_user_id'];
            $new_term->term_operation = 'i';
            $new_term->save();

            if($new_term){
                $classification_data = [
                    'cls_term_id' => $new_term->term_id,
                    'cls_jnl_id'  => $jnl_id,
                    'cls_posted_date' => date('Y-m-d H:i:s'),
                    'cls_posted_by'   => $current_user['user_id'],
                    'cls_proxy_id'    => $current_user['proxy_user_id'],
                    'cls_operation'   => 'i'
                ];

                // if (!empty($artp_id)) {
                //     $classification_data['cls_artp_id'] = $artp_id;
                // }

                $new_classification = Classifications::create($classification_data);

                Article_classification::create([
                    'arcls_art_id' => $article_id,
                    'arcls_cls_id'  => $new_classification->cls_id,
                    'arcls_posted_date' => date('Y-m-d H:i:s'),
                    'arcls_posted_by'   => $current_user['user_id'],
                    'arcls_proxy_id'    => $current_user['proxy_user_id'],
                    'arcls_operation'   => 'i'
                ]);
            }
        }
    return true;
    }
    public function saveClassification($articleId, $classificationData)
    {
        //get all the classification if any
        $insRow = array();
		$current_user = $this->get_current_user_details();
        $condition ="arcls_art_id ={$articleId}";
        $savedClassificationData = Article_classification::get_all_records('*', $condition);
        if (!empty($savedClassificationData)) {
            //remove already saved classification
            Article_classification::delete_records($condition, '', $current_user);
        }
        foreach ($classificationData as $row) {
            $insRow[] = array(
                'arcls_art_id'      => $articleId,
                'arcls_cls_id'      => $row,
                'arcls_posted_date' => date('Y-m-d H:i:s'),
                'arcls_posted_by'   => $current_user['user_id'],
                'arcls_proxy_id'    => $current_user['proxy_user_id'],
            );
        }
        if (!empty($insRow)) {
            Article_classification::insert_batch($insRow,$current_user);
        }
    }
        // Task #3393 Metadata custom form fields should be able to delete
        // Task #3563 Collecting Supporting Documents for Conference
        public function get_metadatafilepath($type=null) {
            $clnt_config = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
            $fetch_confArr  = Config::get($clnt_config);
            $metadata_path     =   '';
            if($type=='s' && isset($fetch_confArr['supportingdata_path']) && $fetch_confArr['supportingdata_path'] != '') {
                $metadata_path    =   $fetch_confArr['supportingdata_path'];
            } else {
                if(isset($fetch_confArr['metadata_path']) && $fetch_confArr['metadata_path'] != '') {
                    $metadata_path    =   $fetch_confArr['metadata_path'];
                }
            }
            return $metadata_path;
        }

        // Task #3563 Collecting Supporting Documents for Conference
    public function validate_supportingdataforms($jnl_id) {
        $generic_forms_validated = FALSE;
        $required_array = array();
        $Generic_forms = new \App\Models\Generic_forms();
        $generic_forms_table = ($Generic_forms)->getTable();
        $Generic_form_elements = new \App\Models\Generic_form_elements();
        $journaldata = Journals::get_single_record_with_bind_cond('jnl_journal_code,jnl_supporting_forms',array("jnl_id"=>$jnl_id));
        if(!empty($journaldata)) {
            $generic_form_ids = json_decode($journaldata->jnl_supporting_forms);
            $jnl_code=$journaldata->jnl_journal_code;
            if (!empty($generic_form_ids)) {
                $implode_role_data = implode(',', json_decode($journaldata->jnl_supporting_forms, TRUE));
                $sql_stage = "SELECT * FROM " . $generic_forms_table . " WHERE gncf_id IN({$implode_role_data})";
                $supporting_forms = $Generic_forms::get_records_by_raw_query($sql_stage);
                if(!empty($supporting_forms)) {
               
                    foreach ($supporting_forms as $fk => $forms) {
                        $elements = $Generic_form_elements::get_all_records("*", 'emt_gucf_id=' . $forms->gncf_id);
                        if (count($elements) > 0 && $this->has_required_form_element($elements) == TRUE) {
                            $Article_generic_form_data = new \App\Models\Article_generic_form_data();
                            foreach ($elements as $element) {
                                $depend_data = array();
                                $data = new \stdClass();
                                if ($element->emt_dependency_required == 1 && $element->emt_required == 1) {
                                    $depend_data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_depending_control}' and gdata_atf_id=?' and gdata_data='{$element->emt_depending_value}'  ", '', "_" . $jnl_code,binding_arr:[$forms->gncf_id]);
                                    if ($depend_data->cnt > 0) {
                                        $data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_id}' and gdata_atf_id=? ", '', "_" . $jnl_code,binding_arr:[$forms->gncf_id]);
                                    } else {
                                        $data->cnt = 1;
                                    }
                                } elseif ($element->emt_required == 1) {
                                    $data = $Article_generic_form_data::get_single_record('count(gdata_id) as cnt', "gdata_atfemt_id='{$element->emt_id}' and gdata_atf_id=?  ", '', "_" . $jnl_code,binding_arr:[$forms->gncf_id]);
                                } else {
                                    $data->cnt = 1;
                                }
                                if ((isset($data->cnt) && $data->cnt == 0)) {
                                    $required_array[] = $forms->gncf_id;
                                    break;
                                }
                            }
                        }
                    }

            }



            }
        }


        if (count($required_array) == 0) {
            $generic_forms_validated = TRUE;
        }
        
        return $generic_forms_validated;

    }
    
    /*
    * Task #3703 new COPYRIGHT tags
    * If tag element data is empty then show 'underscore'
    */
    public function convert_submission_stage_unique_identifiers($identifier, $form, $art_id=NULL, $jnl_code) {
        $jnl_md_res     =   '';
        $art_sub_qry    =   '';
        if($art_id != null) {
            $art_sub_qry    =   'AND md.gdata_art_id = '.$art_id;
        }
        $jnl_md_qry     =  "SELECT
                                md.gdata_label, md.gdata_data
                            FROM
                            `rvw_article_gnf_form_data_$jnl_code` md
                            left join `rvw_generic_form_group` gfg ON (md.gdata_gfg_id = gfg.gfg_id) 
                            left join `rvw_generic_forms` gf ON (gf.gncf_id = gfg.gfg_gncf_id)
                            WHERE
                                gf.gncf_form_type ='".$form."' $art_sub_qry AND md.gdata_unique_identifier = '".$identifier."'";
        $jnl_md_get    =   Article_flow::get_records_by_raw_query($jnl_md_qry); 
        if (!empty($jnl_md_get)) {   
            if($jnl_md_get[0]->gdata_data != '' || $jnl_md_get[0]->gdata_data != NULL)
                $jnl_md_res    =   $jnl_md_get[0]->gdata_data;
            else
                $jnl_md_res    =   '______________';
        } else {
            $jnl_md_res    =   '______________';
        }
        return $jnl_md_res;
    }

}
