<?php

namespace App\Http\Controllers\Dbmanagement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Journals;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Models\Journal_settings_tbk;
use App\Models\Journal_permission_master;
use App\Models\Journal_permission;
use App\Models\Article_type_advance_options;
use App\Models\Classifications;
use App\Models\Article_classification;
use App\Models\Article_secondary_classification;
use App\Models\Article_primary_classification;
use App\Models\Articles;
use App\Models\Roles;
use App\Models\Generic_flows;
use App\Models\User;
use Config;
use App\Models\Generic_forms;
use App\Models\Ftp;
use App\Models\Ftp_master;
use App\Models\User_to_journals;
use App\Models\Api_credentials;
use Faker\Core\File;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use JWTAuth;
use JWTAuthException;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;
use Laminas\Validator\InArray;
use App\Consts;
use App\Models\Article_flow;
use App\Models\Article_reviewers;
use App\Models\Issue_management;
use App\Models\Issue_management_tbk;
use App\Models\Issues;
use Carbon\Carbon;
use Exception;
use Log;
use Illuminate\Support\Facades\Validator;
use App\Models\Email_templates;
use App\Models\Stage_email_templates;
use App\Models\Article_autoinvitation_emails;
use App\Models\Adhoc_notification_emails;
use App\Models\Article_notification_emails;
use App\Models\Advance_flow_movement;
use Mpdf\Tag\Em;
use App\Models\All_Client_Functionalities;
use App\Models\Client_functionalities;
use App\Models\All_Clients;
use App\Models\All_Client_Functionality_Status;
use App\models\All_Client_Url;
use App\models\Modules;
use App\Http\Controllers\SudoManagementApi;
use App\Http\Controllers\Sudo_Manage_Modules_Api;
use App\Models\Events_model; //Task #3791

class Manage_Database extends Controller
{

	public function manage_common_permissions()
	{
try{
		///Start--copy journal permissions
		$journals_table = (new \App\Models\Journals())->getTable();
		$journal_settings_table = (new \App\Models\Journal_settings())->getTable();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
		$article_type_advance_options_table = (new \App\Models\Article_type_advance_options())->getTable();
		$jnl_details = Journals::get_all_records('jnl_id,jnl_journal_name,jnl_posted_by,jnl_posted_date,jnl_proxy_id');
		if (!empty($jnl_details)) {
			foreach ($jnl_details as $jn) {
				$current_user['user_id'] = $jn->jnl_posted_by;
				$current_user['proxy_user_id'] = $jn->jnl_proxy_id;
				// save master permission
				$jounal_name = $jn->jnl_journal_name;
				$permission_desc = "Permission of $jounal_name";
				$mast_permission_id = Journal_permission_master::insert_record(array(
					'jpm_description' => $permission_desc
				), $current_user);

				//update permissionid in journal table
				$update_data['jnl_jpm_id'] = $mast_permission_id;
				$jnlid = 'jnl_id=' . $jn->jnl_id;
				Journals::update_record($update_data, $jnlid, $current_user);

				//copy journal permissions
				$sql = "insert into " . $journal_permission_table . " (jp_jpm_id,jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_files,
						jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
						jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_rate_reviewer,jp_posted_by,jp_posted_date
						)"
					. "select " . $mast_permission_id . ",jset_add_notes,jset_flag_articles,jset_edit_articles,jset_edit_article_files,jset_transfer_article,jset_rescind_article,jset_rescind_review,jset_generic_discussion,jset_reset_article,jset_view_auditrail,jset_view_email_log,jset_stage_manual_reminder,jset_extend_task,jset_edit_reviewer_count,jset_view_file_inventory,jset_view_article_pdf,jset_auto_assign_role,jset_change_usr_assigmnts,jset_move_article_from_payment,jset_reinstantiate_payment,jset_rate_reviewer," . $jn->jnl_posted_by . ",'".date('Y-m-d H:i:s')."' from " . $journal_settings_table . " where jset_jnl_id=" . $jn->jnl_id;
					DB::select($sql);


				//copy article permissions

				$condition = "artp_jnl_id={$jn->jnl_id}";
				$all_article_types = Article_types::get_all_records('*', $condition);
				if (!empty($all_article_types)) {
					foreach ($all_article_types as $atype) {

						$atype_current_user['user_id'] = $atype->artp_posted_by;
						$atype_current_user['proxy_user_id'] = $atype->artp_proxy_id;

						//save master permission
						$atype_permission_desc = 'Permission of ' . $atype->artp_article_type;
						$mast_permission_id_arttype = Journal_permission_master::insert_record(array(
							'jpm_description' => $atype_permission_desc
						), $atype_current_user);


						//update permissionid in article_type table
						$arttype_update_data['artp_jpm_id'] = $mast_permission_id_arttype;
						$arttype_condition = 'artp_id=' . $atype->artp_id;
						Article_types::update_record($arttype_update_data, $arttype_condition, $atype_current_user);


						//copy article type permissions
						$atype_sql = "insert into " . $journal_permission_table . " (jp_jpm_id,jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_files,
						jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
						jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_rate_reviewer,jp_posted_by,jp_posted_date
						)"
							. "select " . $mast_permission_id_arttype . ",atotp_add_notes,atotp_flag_articles,atotp_edit_articles,atotp_edit_article_files,atotp_transfer_article,atotp_rescind_article,atotp_rescind_review,atotp_generic_discussion,atotp_reset_article,atotp_view_auditrail,atotp_view_email_log,atotp_stage_manual_reminder,atotp_extend_task,atotp_edit_reviewer_count,atotp_view_file_inventory,atotp_view_article_pdf,atotp_auto_assign_role,atotp_change_usr_assigmnts,atotp_move_article_from_payment,atotp_reinstantiate_payment,atotp_rate_reviewer," . $current_user['user_id'] . ",'".date('Y-m-d H:i:s')."' from " . $article_type_advance_options_table . " where atotp_artp_id=" . $atype->artp_id;
						DB::select($atype_sql);
						// $atype_result = Journal_permission::get_records_by_unfiltered_raw_query($atype_sql);
					}
				}
			}
		}
		// $journal_settings_table
		//drop common fields rvw_journal_settings_temp
		$drop_sql = "ALTER TABLE rvw_journal_settings DROP  `jset_add_notes`,DROP   `jset_flag_articles`,DROP   `jset_edit_articles`,DROP   `jset_edit_article_files`,DROP   `jset_transfer_article`,DROP  `jset_rescind_article`,DROP   `jset_rescind_review`,DROP   `jset_reset_article`,DROP   `jset_view_auditrail`,DROP   `jset_view_email_log`,DROP   `jset_stage_manual_reminder`,DROP   `jset_extend_task`,DROP   `jset_edit_reviewer_count`,DROP   `jset_view_file_inventory`,DROP   `jset_view_article_pdf`,DROP   `jset_auto_assign_role`,DROP   `jset_change_usr_assigmnts`,DROP   `jset_move_article_from_payment`,DROP   `jset_reinstantiate_payment`,DROP   `jset_rate_reviewer`";
		Journal_settings::get_records_by_raw_query($drop_sql);

		$drop_sql_tbk = "ALTER TABLE tbk_journal_settings DROP  `jset_add_notes`,DROP   `jset_flag_articles`,DROP   `jset_edit_articles`,DROP   `jset_edit_article_files`,DROP   `jset_transfer_article`,DROP  `jset_rescind_article`,DROP   `jset_rescind_review`,DROP   `jset_reset_article`,DROP   `jset_view_auditrail`,DROP   `jset_view_email_log`,DROP   `jset_stage_manual_reminder`,DROP   `jset_extend_task`,DROP   `jset_edit_reviewer_count`,DROP   `jset_view_file_inventory`,DROP   `jset_view_article_pdf`,DROP   `jset_auto_assign_role`,DROP   `jset_change_usr_assigmnts`,DROP   `jset_move_article_from_payment`,DROP   `jset_reinstantiate_payment`,DROP   `jset_rate_reviewer`";
		DB::select($drop_sql_tbk);


		$drop_adv_sql = "ALTER TABLE " . $article_type_advance_options_table . "
                DROP `atotp_add_notes`,
                DROP `atotp_flag_articles`,
                DROP `atotp_edit_articles`,
                DROP `atotp_edit_article_files`,
                DROP `atotp_transfer_article`,
                DROP `atotp_view_auditrail`,
                DROP `atotp_view_email_log`,
                DROP `atotp_stage_manual_reminder`,
                DROP `atotp_rate_reviewer`,
                DROP `atotp_rescind_article`,
                DROP `atotp_generic_discussion`,
                DROP `atotp_rescind_review`,
                DROP `atotp_reset_article`,
                DROP `atotp_extend_task`,
                DROP `atotp_edit_reviewer_count`,
                DROP `atotp_view_article_pdf`,
                DROP `atotp_view_file_inventory`,
                DROP `atotp_change_usr_assigmnts`,
                DROP `atotp_move_article_from_payment`,
                DROP `atotp_reinstantiate_payment`,
                DROP `atotp_auto_assign_role`";

		Article_type_advance_options::get_records_by_raw_query($drop_adv_sql);




		$drop_adv_tbk_sql = "ALTER TABLE `tbk_article_type_advance_options`
                DROP `atotp_add_notes`,
                DROP `atotp_flag_articles`,
                DROP `atotp_edit_articles`,
                DROP `atotp_edit_article_files`,
                DROP `atotp_transfer_article`,
                DROP `atotp_view_auditrail`,
                DROP `atotp_view_email_log`,
                DROP `atotp_stage_manual_reminder`,
                DROP `atotp_rate_reviewer`,
                DROP `atotp_rescind_article`,
                DROP `atotp_generic_discussion`,
                DROP `atotp_rescind_review`,
                DROP `atotp_reset_article`,
                DROP `atotp_extend_task`,
                DROP `atotp_edit_reviewer_count`,
                DROP `atotp_view_article_pdf`,
                DROP `atotp_view_file_inventory`,
                DROP `atotp_change_usr_assigmnts`,
                DROP `atotp_move_article_from_payment`,
                DROP `atotp_reinstantiate_payment`,
                DROP `atotp_auto_assign_role`";

		DB::select($drop_adv_tbk_sql);

	}
	catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
		///End--copy journal permissions


	}
	public function manage_classifications()
	{
		try{
		$classification_table = (new \App\Models\Classifications())->getTable();
		// $sql = "insert into " . $classification_table . " (cls_id,cls_jnl_id,cls_term_id,cls_primary_id,cls_parents_id,
		// cls_children_id,cls_artp_id,cls_posted_by,cls_posted_date,cls_old_cls_id,cls_proxy_id,cls_operation
		// 				)"
		// 	. "select  jntm_id,jntm_jnl_id,jntm_term_id,jntm_primary_id,CONCAT('[',jntm_primary_id,']'),(SELECT GROUP_CONCAT(DISTINCT jntm_id) FROM rvw_journal_terms  where jntm_id=jntm_primary_id) as child,jntm_artp_id,jntm_posted_by,jntm_posted_date,jntm_old_jntm_id,jntm_proxy_id,jntm_operation from " . $journal_terms_table;

		$sql = "insert into " . $classification_table . " (cls_id,cls_jnl_id,cls_term_id,cls_primary_id,cls_parents_id,
		cls_children_id,cls_artp_id,cls_posted_by,cls_posted_date,cls_old_cls_id,cls_proxy_id,cls_operation
						)"
			. "select jntm_id,jntm_jnl_id,jntm_term_id,jntm_primary_id,CONCAT('[',jntm_primary_id,']'),CONCAT('[',(SELECT GROUP_CONCAT(DISTINCT jntm_id) FROM rvw_journal_terms as innertbl where master.jntm_id=innertbl.jntm_primary_id),']') as children,jntm_artp_id,jntm_posted_by,jntm_posted_date,jntm_old_jntm_id,jntm_proxy_id,jntm_operation from rvw_journal_terms as master";

		DB::select($sql);
		$this->manage_classifications_removefields();
	}
	catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
	}
	public function manage_classifications_removefields()
	{
       try
	   {
		$drp_jnlsettings = "ALTER TABLE `rvw_journal_settings`
		DROP `jset_secondary_class`,
		DROP `jset_min_no_secondary_class`,
		DROP `jset_max_no_secondary_class`,
		DROP `jset_min_no_primary_class`,
		DROP `jset_max_no_primary_class`,
		DROP `jset_primary_class_alias`,
		DROP `jset_secondary_class_alias`,
		DROP `jset_cust_secondary_class`
		";
		DB::select($drp_jnlsettings);

		$drp_tbk_jnlsettings = "ALTER TABLE `tbk_journal_settings`
		DROP `jset_secondary_class`,
		DROP `jset_min_no_secondary_class`,
		DROP `jset_max_no_secondary_class`,
		DROP `jset_min_no_primary_class`,
		DROP `jset_max_no_primary_class`,
		DROP `jset_primary_class_alias`,
		DROP `jset_secondary_class_alias`,
		DROP `jset_cust_secondary_class`
		";
		DB::select($drp_tbk_jnlsettings);

		$change_jnlsettings = "ALTER TABLE `rvw_journal_settings` CHANGE `jset_primary_class` `jset_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT 'n' COMMENT 'y= yes, n=no'";
		DB::select($change_jnlsettings);

		$change_tbk_jnlsettings = "ALTER TABLE `tbk_journal_settings` CHANGE `jset_primary_class` `jset_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT 'n' COMMENT 'y= yes, n=no'";
		DB::select($change_tbk_jnlsettings);

		$change_jnl = "ALTER TABLE `rvw_journal_settings` CHANGE `jset_cust_primary_class` `jset_custom_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'y=yes,n=no'";
		DB::select($change_jnl);

		$change_tbk_jnl = "ALTER TABLE `tbk_journal_settings` CHANGE `jset_cust_primary_class` `jset_custom_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'y=yes,n=no'";
		DB::select($change_tbk_jnl);

		$drp_atypesettings = "ALTER TABLE `rvw_article_type_advance_options`
            DROP `atotp_secondary_class`,
            DROP `atotp_min_no_secondary_class`,
            DROP `atotp_max_no_secondary_class`,
            DROP `atotp_min_no_primary_class`,
            DROP `atotp_max_no_primary_class`,
            DROP `atotp_cust_secondary_class`,
            DROP `atotp_secondary_class_alias`,
            DROP `atotp_primary_class_alias`
            ";
		DB::select($drp_atypesettings);

		$drp_tbk_atypesettings = "ALTER TABLE `tbk_article_type_advance_options`
	   DROP `atotp_secondary_class`,
	   DROP `atotp_min_no_secondary_class`,
	   DROP `atotp_max_no_secondary_class`,
	   DROP `atotp_min_no_primary_class`,
	   DROP `atotp_max_no_primary_class`,
	   DROP `atotp_cust_secondary_class`,
	   DROP `atotp_secondary_class_alias`,
	   DROP `atotp_primary_class_alias`
	   ";
		DB::select($drp_tbk_atypesettings);


		$change_atypesettings = "ALTER TABLE `rvw_article_type_advance_options` CHANGE `atotp_primary_class` `atotp_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'y=yes,n=no'";
		DB::select($change_atypesettings);

		$change_tbk_atypesettings = "ALTER TABLE `tbk_article_type_advance_options` CHANGE `atotp_primary_class` `atotp_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'y=yes,n=no'";
		DB::select($change_tbk_atypesettings);

		$change_atype = "ALTER TABLE `rvw_article_type_advance_options` CHANGE `atotp_cust_primary_class` `atotp_custom_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'y=yes and n=no'";
		DB::select($change_atype);

		$change_tbk_jnl = "ALTER TABLE `tbk_article_type_advance_options` CHANGE `atotp_cust_primary_class` `atotp_custom_classification` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'y=yes and n=no'";
		DB::select($change_tbk_jnl);
	}
	catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
	}

	public function manage_journal_metadata()
	{
		try
	   {
		$drop_adv_tbk_sql = "ALTER TABLE `rvw_article_gnf_form_data` CHANGE `gdata_art_id` `gdata_art_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_articles', CHANGE `gdata_artflw_id` `gdata_artflw_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_article_flow table'";
		DB::select($drop_adv_tbk_sql);
		$drop_adv_tbk_sql = "ALTER TABLE `tbk_article_gnf_form_data` CHANGE `gdata_art_id` `gdata_art_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_articles', CHANGE `gdata_artflw_id` `gdata_artflw_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_article_flow table'";
		DB::select($drop_adv_tbk_sql);
		$jnl_details = Journals::get_all_records('jnl_id,jnl_journal_name,jnl_journal_code,jnl_posted_by,jnl_proxy_id');
	    $metadataform=Generic_forms::get_single_record('gncf_id',"gncf_metadata_status='m'");
		if (!empty($jnl_details)) {
			foreach ($jnl_details as $jn) {
				$jnlcode = $jn->jnl_journal_code;
				$qry="ALTER TABLE `rvw_article_gnf_form_data_".$jnlcode."` CHANGE `gdata_art_id` `gdata_art_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_articles', CHANGE `gdata_artflw_id` `gdata_artflw_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_article_flow table'";
				DB::select($qry);
				$qry="ALTER TABLE `tbk_article_gnf_form_data_".$jnlcode."` CHANGE `gdata_art_id` `gdata_art_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_articles', CHANGE `gdata_artflw_id` `gdata_artflw_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_article_flow table'";
				DB::select($qry);
				if(isset($metadataform->gncf_id)&&!empty($metadataform->gncf_id))
				{
					$current_user['user_id'] = $jn->jnl_posted_by;
				    $current_user['proxy_user_id'] = $jn->jnl_proxy_id;
					$update_data['jnl_metadata_id'] = $metadataform->gncf_id;
					$jnlid = 'jnl_id=' . $jn->jnl_id;
					Journals::update_record($update_data, $jnlid, $current_user);
				}
			}
		}
	}
		catch (\Exception $e) {

			return $this->failure('Failed', 500, $e);
		}
	}
	public function manage_article_classifications()
	{
		$secondaryClassification = Article_secondary_classification::get_article_class_secondary();
		$this->manage_article_insert_classifications($secondaryClassification);
		$primaryClassification = Article_primary_classification::get_article_class_primary();
		$this->manage_article_insert_classifications($primaryClassification);
	}
	public function manage_article_insert_classifications($classifications)
	{
		$current_user = $this->get_current_user_details();
		if (count($classifications) > 0) {
			foreach ($classifications as $classification) {
				$classId = Classifications::get_all_records('cls_id', 'cls_jnl_id=' . $classification->jnl_id . ' AND cls_artp_id=' . $classification->artp_id . ' AND cls_term_id=' . $classification->term_id);
				$classExist = Article_classification::get_single_record('arcls_id', 'arcls_art_id =' . $classification->art_id . ' AND arcls_cls_id=' . $classId[0]->cls_id);
				if (!isset($classExist->arcls_id) && isset($classId[0]) && !empty($classId[0]->cls_id)) {
					Article_classification::insert_record(array('arcls_art_id' => $classification->art_id, 'arcls_cls_id' => $classId[0]->cls_id), $current_user);
				}
			}
		}
	}
	public function article_attachment_status()
	{
		$Generic_flows = new \App\Models\Generic_flows;
		$updt_data = array(
            'jwf_article_attachment_status' => 'y',

        );
		$current_user = $this->get_current_user_details();
		$update_usr = $Generic_flows::update_record($updt_data,"jwf_stage_type='author_submission'", $current_user);

	}
	public function article_palette_color_code_modify()
	{
		try
	  	{
		$Article_types = new \App\Models\Article_types();
		$change_atypesettings = "UPDATE
		`rvw_article_types`
		SET
			`artp_palette_color_code` = CASE
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'b' THEN '#00FFFF'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'g' THEN '#00FF00'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'cb' THEN '#3c8dbc'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'cr' THEN '#4B0082'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'mg' THEN '#BFFF00'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'cg' THEN '#bcd3d4'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'gg' THEN '#817fa0'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'sg' THEN '#cccccc'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'cb' THEN '#7abdb8'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'mr' THEN '#f7d0cb'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'op' THEN '#8f7bcd'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'lp' THEN '#b9a0e6'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'ig' THEN '#5a645b'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'pp' THEN '#800020'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'wp' THEN '#392742'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'nb' THEN '#6497b1'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'dy' THEN '#ffdc78'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'jp' THEN '#660033'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'sp' THEN '#566D7E'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'fg' THEN '#45B39D'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'pg' THEN '#0B5345'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'bg' THEN '#0c0c0c'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'yl' THEN '#ffff00'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'sb' THEN '#8B4513'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'sm' THEN '#ADD8E6'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'dg' THEN '#696969'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'pl' THEN '#E5E4E2'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'bl' THEN '#6960EC'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'eg' THEN '#614051'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'rb' THEN '#D1E231'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'vg' THEN '#34282C'
				WHEN `rvw_article_types`.`artp_palette_color_code` = 'do' THEN '#FFE5B4'
			ELSE `rvw_article_types`.`artp_palette_color_code`
		END";
		$return=DB::update($change_atypesettings);
		return $return;
		 }
		catch (\Exception $e) {

			return $this->failure('Failed', 500, $e);
		}

	}
	public function manage_ftp_data(){
		try
		{
		$ftpTable = (new \App\Models\Ftp())->getTable();
		$ftpMasterTable = (new \App\Models\Ftp_master())->getTable();
		//get distinct ftp details from rwv_ftp_location
		//`ftpm_id`,
		//`ftp_id`,
		Ftp::get_records_by_raw_query("UPDATE `rvw_ftp_locations` SET `ftp_private_key_path` = NULLIF(`ftp_private_key_path`, ''), `ftp_location` = NULLIF(`ftp_location`, '');");
		Ftp::get_records_by_raw_query("SET GLOBAL group_concat_max_len=15000;");
		Ftp::get_records_by_raw_query("INSERT IGNORE INTO {$ftpMasterTable}( `ftpm_display_name`, `ftpm_host_name`, `ftpm_user_name`, `ftpm_password`, `ftpm_enable_private_key`, `ftpm_private_key_path`, `ftpm_port`, `ftpm_location`, `ftpm_temp_ftp_ids`, `ftpm_posted_by`, `ftpm_proxy_id`, `ftpm_posted_date`, `ftpm_operation` ) SELECT `ftp_display_name`, `ftp_host_name`, `ftp_user_name`, `ftp_password`, `ftp_enable_private_key`, `ftp_private_key_path`, `ftp_port`, `ftp_location`, GROUP_CONCAT(`ftp_id`) as ftp_temp_ftp_ids, `ftp_posted_by`, `ftp_proxy_id`, `ftp_posted_date`, `ftp_operation`  FROM {$ftpTable} GROUP BY `ftp_display_name`, `ftp_host_name`, `ftp_user_name`, `ftp_password`, `ftp_enable_private_key`, `ftp_private_key_path`, `ftp_port`, `ftp_location`; ");
		Ftp::get_records_by_raw_query("UPDATE {$ftpTable} JOIN {$ftpMasterTable} on find_in_set(ftp_id,ftpm_temp_ftp_ids) SET `ftp_ftpm_id` = ftpm_id WHERE find_in_set(ftp_id,ftpm_temp_ftp_ids);");
		//remove unwanted columns
		Ftp::get_records_by_raw_query("ALTER TABLE {$ftpTable} DROP `ftp_display_name`, DROP `ftp_host_name`, DROP `ftp_user_name`, DROP `ftp_password`, DROP `ftp_enable_private_key`, DROP `ftp_private_key_path`, DROP `ftp_port`, DROP `ftp_location`;");
		Ftp::get_records_by_raw_query("ALTER TABLE `tbk_ftp_locations` DROP `ftp_display_name`, DROP `ftp_host_name`, DROP `ftp_user_name`, DROP `ftp_password`, DROP `ftp_enable_private_key`, DROP `ftp_private_key_path`, DROP `ftp_port`, DROP `ftp_location`;");
		Ftp_master::get_records_by_raw_query("ALTER TABLE {$ftpMasterTable} DROP `ftpm_temp_ftp_ids`;");
		Ftp_master::get_records_by_raw_query("ALTER TABLE {$ftpTable} CHANGE `ftp_event_type` `ftp_event_type` CHAR(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL DEFAULT 'i' COMMENT 'i - on stage initize, c - on stage complete';");
		Ftp_master::get_records_by_raw_query("ALTER TABLE `tbk_ftp_locations` CHANGE `ftp_event_type` `ftp_event_type` CHAR(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL DEFAULT 'i' COMMENT 'i - on stage initize, c - on stage complete';");
		}
		catch (\Exception $e) {

			return $this->failure('Failed', 500, $e);
		}
	}

	/**
	 * This function change character set from CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci
	 * to utf8mb4_unicode_ci
	 *
	 * task : file (for download file)
	 * task : show (list details)
	 * task : run (work from this function)
	 */
	public function change_characterset(Request $request)
	{
		try
		{
			$download_path = 'uploads/';
			$download_path =  $this->get_upload_path($download_path,FALSE,'storage',TRUE);
			$show_path =  $this->get_upload_path('',TRUE);

			$post_data = $request->all();
			$Run_flag = 'show';
			if(isset($post_data['task']))
			{
				$Run_flag = trim($post_data['task']);
			}

			if($Run_flag != 'file' && $Run_flag != 'run')
			{

				echo "<br>##=============================================================================##<br>";
				echo '##==================For running below queries send argument "task"======================##<br>';
				echo '##=================="task" : "show" for display the details=============================##<br>';
				echo '##=================="task" : "file" download file=============================##<br>';
				echo '##=================="location" : '.$show_path.'==##<br>';
				echo '##=================="task" : "run" for doing permission==============================##';
				echo "<br>##=============================================================================##<br>";
			}

			$query_file_string = array();
			//DB::connection()->getPDO();
			$databaseName =  DB::connection()->getDatabaseName();

			//CHANGE DATABASE CHARACTER SET FROM  UTF8MB3 TO UTF8MB4
			$query_db = "ALTER DATABASE `".$databaseName."` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";
			if($Run_flag == 'run')
			{
				echo 'Start time : '.date('D M Y H:i:s').'<br>';
				Articles::get_records_by_raw_query($query_db);
			}
			elseif($Run_flag == 'file')
			{
				$query_file_string[] = $query_db;
			}

			//CHANGE TABLES CHARACTER SET FROM  UTF8MB3 TO UTF8MB4

			$query = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '".$databaseName."' AND TABLE_COLLATION != 'utf8mb4_unicode_ci'";
			$results = Articles::get_records_by_raw_query($query);

			if($Run_flag == 'run' || $Run_flag == 'file')
			{
				if(count($results)>0)
				{
					foreach($results as $result_query)
					{
						$query_table = 'ALTER TABLE '.$result_query->TABLE_NAME.' CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;';
						if($Run_flag == 'run')
						{
							Articles::get_records_by_raw_query($query_table);
						}
						elseif($Run_flag == 'file')
						{
							$query_file_string[] = $query_table;
						}

					}
					if($Run_flag == 'run')
						echo count($results).' table/s in database :'.$databaseName.' changed to utf8mb4_unicode_ci <br>';
				}
				elseif($Run_flag == 'run')
				{
					echo 'No tables updated in database :'.$databaseName.'<br>';
				}
			}
			else
			{
				echo count($results).' Table/s in database :'.$databaseName.' will be change to utf8mb4_unicode_ci.<br>';
				echo '<pre>';print_r($results);
				echo "<br>##=========================================================================================##<br>";
			}


			$sql = "SELECT CONCAT('ALTER TABLE ', TABLE_NAME, ' MODIFY ', COLUMN_NAME,' ',COLUMN_TYPE, ' CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ',IF(IS_NULLABLE = 'YES',' NULL ',' NOT NULL '),' ',IF(COLUMN_DEFAULT is not null,concat('DEFAULT \'',COLUMN_DEFAULT,'\''),''),IF(COLUMN_COMMENT != '',concat(' COMMENT ','\'',REPLACE(COLUMN_COMMENT,\"'\",''),'\''),''),';') AS Query FROM INFORMATION_SCHEMA.COLUMNS WHERE COLLATION_NAME NOT LIKE 'utf8mb4_unicode_ci' AND TABLE_SCHEMA = '".$databaseName."' AND DATA_TYPE IN ('char', 'varchar', 'text', 'tinytext', 'mediumtext', 'longtext') AND TABLE_NAME NOT LIKE 'view_article_status' ORDER BY TABLE_SCHEMA, TABLE_NAME;";
			$results = Articles::get_records_by_raw_query($sql);


			if($Run_flag == 'run' || $Run_flag == 'file')
			{
				if(!empty($results))
				{
					//DB::beginTransaction();
					$query_index1 = 'ALTER TABLE `rvw_faqs` DROP INDEX `faq_search_key`;';
					if($Run_flag == 'run')
					{
						Articles::get_records_by_raw_query($query_index1);
					}
					elseif($Run_flag == 'file')
					{
						$query_file_string[]= $query_index1;
					}


					foreach($results as $result_query)
					{
						if($Run_flag == 'run')
						{
							Articles::get_records_by_raw_query($result_query->Query);
						}
						elseif($Run_flag == 'file')
						{
							$query_file_string[]= $result_query->Query;
						}

					}

					$query_index2 = 'ALTER TABLE `rvw_faqs` ADD FULLTEXT faq_search_key(`faq_question`, `faq_answer`, `faq_tags`);';
					if($Run_flag == 'run')
					{
						Articles::get_records_by_raw_query($query_index2);
					}
					elseif($Run_flag == 'file')
					{
						$query_file_string[]= $query_index2;
					}

					if($Run_flag == 'run')
						echo count($results).' Column/s in database :'.$databaseName.' changed to utf8mb4_unicode_ci<br>';
					//DB::commit();
				}
				elseif($Run_flag == 'run')
				{
					echo 'No column/s updated in database :'.$databaseName.'<br>';
				}

			}
			else
			{
				echo count($results).' Column/s in database :'.$databaseName.' will be change to utf8mb4_unicode_ci.<br>';
				echo '<pre>';print_r($results);
				echo "<br>##=========================================================================================##<br>";
			}

			if($Run_flag == 'file')
			{
				$file_name = 'changeCharacterset_'.$databaseName.'.sql';
				$download_path = $download_path.$file_name;
				echo 'Location :'.$show_path.$file_name;
				$contents =  implode(' ',$query_file_string);

				file_put_contents($download_path,$contents);
			}
			elseif($Run_flag == 'run')
			{
				echo 'End time : '.date('D M Y H:i:s');
			}

		}
		catch(\Exception $e)
		{
			//DB::rollback();
			print_r($e);exit;
		}

	}

	public function manage_filter_data(){
		try
		{

		$User_journal_filter_keys = (new \App\Models\User_journal_filter_keys());
		$current_user = $this->get_current_user_details();
		$all_filter_rec = $User_journal_filter_keys::get_all_records();
		if(!empty($all_filter_rec))
		{
			foreach($all_filter_rec as $all_filter)
			{
				$data_array=array();
				$all_filter->ujfk_id;
				$all_filt= json_decode($all_filter->ujfk_filter_keys);
				if(array_key_exists("article_code",(array)$all_filt)) {
					$data_array['article_code']=$all_filt->article_code;
				}
				if(array_key_exists("art_title",(array)$all_filt)) {
					$data_array['art_title']=$all_filt->art_title;
				}
				if(array_key_exists("article_title",(array)$all_filt)) {
					$data_array['art_title']=$all_filt->article_title;
				}
				if(array_key_exists("article_type",(array)$all_filt)) {
					if($all_filt->article_type !='' && !is_numeric($all_filt->article_type)) {
						$data_array['article_type']=$this->decrypt_data($all_filt->article_type);
						$article_type_data= Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$this->decrypt_data($all_filt->article_type)}");
					}
					if($all_filt->article_type !='' && is_numeric($all_filt->article_type)) {
						$data_array['article_type']=$all_filt->article_type;
						$article_type_data= Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$all_filt->article_type}");
					}

					if($all_filt->article_type !='' && !array_key_exists("article_type_set",(array)$all_filt)) {
						$data_array['article_type_set']=$article_type_data->artp_article_type;
					}
				}
				if(array_key_exists("article_type_set",(array)$all_filt)) {
					$data_array['article_type_set']=$all_filt->article_type_set;
				}
				if(array_key_exists("special_issue",(array)$all_filt)) {
					$data_array['special_issue']=$all_filt->special_issue;
				}
				if(array_key_exists("stage_name",(array)$all_filt)) {
					$data_array['stage_name']=$all_filt->stage_name;
				}
				if(array_key_exists("status_name",(array)$all_filt)) {
					$data_array['stage_name']=$all_filt->status_name;
				}
				if(array_key_exists("date",(array)$all_filt)) {
					$data_array['date']=$all_filt->date;
				}
				if(array_key_exists("my_list",(array)$all_filt)) {
					$data_array['my_list']=$all_filt->my_list;
				}
				if(array_key_exists("start_date",(array)$all_filt)) {
					$date_set = '';
					if($all_filt->start_date != "")
					{
						$var = $all_filt->start_date;
						$date_set= date("Y-m-d", strtotime($var));
					}
					$data_array['start_date']=$date_set;
				}
				if(array_key_exists("end_date",(array)$all_filt)) {
					$date_sett = '';
					if($all_filt->end_date != "")
					{
						$var = $all_filt->end_date;
						$date_set= date("Y-m-d", strtotime($var));
					}
					$data_array['end_date']=$date_sett;
				}
				if(array_key_exists("sort",(array)$all_filt)) {
					$data_array['sort']=$all_filt->sort;
				}
				$condition="ujfk_id={$all_filter->ujfk_id}";
				$update_arr = array(
					'ujfk_filter_keys' => json_encode($data_array));
					$result = $User_journal_filter_keys::update_record($update_arr, $condition, $current_user);
			}
		}
		return $result;
		}
		catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}

	public function manage_filter_tile_data(){
		try
		{
		$result=array();
		$User_journal_dashboard_tile_filter_keys = (new \App\Models\User_journal_dashboard_tile_filter_keys());
		$current_user = $this->get_current_user_details();
		$all_filter_tile = $User_journal_dashboard_tile_filter_keys::get_all_records();

		if(!empty($all_filter_tile))
		{
			foreach($all_filter_tile as $all_filter)
			{
				$core_role = Roles::get_single_record('role_assigned_role', 'role_id = ' . $all_filter->ujdtfk_role_id);
				$dashboard_conf = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
                $dashboard_arr  = Config::get($dashboard_conf);
				$dashboard_config = $dashboard_arr[$core_role->role_assigned_role];
				$dashboard_config['Tiles'] = array_values($dashboard_config['Tiles']);
				$data_array=array();

				foreach($dashboard_config['Tiles'] as $dash_tile)
				{
					$all_filter->ujdtfk_id;
					$all_filt=json_decode($all_filter->ujdtfk_filter_keys);
					if (is_array($all_filt) || is_object($all_filt))
					{
						foreach ($all_filt as $key => $val)
						{
							if($key==$dash_tile['function'])
							{
								$data_array[$dash_tile['section_id']]=$all_filt->{$dash_tile['function']};
							}
							if($key==$dash_tile['section_id'])
							{
								$data_array[$dash_tile['section_id']]=$all_filt->{$dash_tile['section_id']};
							}
							if(isset($all_filt->{$dash_tile['function']}) && $all_filt->{$dash_tile['function']} != "")
							{
								$key_arr=array();
								foreach($all_filt->{$dash_tile['function']} as $ky=>$val)
								{
								if($ky=="article_code") {
									$key_arr['article_code']=$all_filt->{$dash_tile['function']}->article_code;
								}
								if($ky=="art_title") {
									$key_arr['art_title']=$all_filt->{$dash_tile['function']}->art_title;
								}
								if($ky=="article_title") {
									$key_arr['art_title']=$all_filt->{$dash_tile['function']}->article_title;
								}
								if($ky=="article_type") {
									if($all_filt->{$dash_tile['function']}->article_type !='' && !is_numeric($all_filt->{$dash_tile['function']}->article_type)) {
										$key_arr['article_type']=$this->decrypt_data($all_filt->{$dash_tile['function']}->article_type);
										$article_type_data= Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$this->decrypt_data($all_filt->{$dash_tile['function']}->article_type)}");
									}
									elseif($all_filt->{$dash_tile['function']}->article_type !='' && is_numeric($all_filt->{$dash_tile['function']}->article_type)) {
										$key_arr['article_type']=$all_filt->{$dash_tile['function']}->article_type;
										$article_type_data= Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$all_filt->{$dash_tile['function']}->article_type}");
									}
									if($all_filt->{$dash_tile['function']}->article_type !='' ) {
										$key_arr['article_type_set']=$article_type_data->artp_article_type;
									}
								}
								if($ky=="article_type_set") {
									$key_arr['article_type_set']=$all_filt->{$dash_tile['function']}->article_type_set;
								}
								if($ky=="special_issue") {
									$key_arr['special_issue']=$all_filt->{$dash_tile['function']}->special_issue;
								}
								if($ky=="stage_name") {
									$key_arr['stage_name']=$all_filt->{$dash_tile['function']}->stage_name;
								}
								if($ky=="status_name") {
									$key_arr['stage_name']=$all_filt->{$dash_tile['function']}->status_name;
								}
								if($ky=="date") {
									$key_arr['date']=$all_filt->{$dash_tile['function']}->date;
								}
								if($ky=="my_list") {
									$key_arr['my_list']=$all_filt->{$dash_tile['function']}->my_list;
								}
								if($ky=="start_date") {
									$date_set = '';
									if($all_filt->{$dash_tile['function']}->start_date != "")
									{
										$var = $all_filt->{$dash_tile['function']}->start_date;
										$date_set= date("Y-m-d", strtotime($var));
									}
									$key_arr['start_date']=$date_set;
								}
								if($ky=="end_date") {
									$date_sett = '';
									if($all_filt->{$dash_tile['function']}->end_date != "")
									{
										$varr = $all_filt->{$dash_tile['function']}->end_date;
										$date_sett= date("Y-m-d", strtotime($varr));
									}
									$key_arr['end_date']=$date_sett;
								}
								}
								$data_array[$dash_tile['section_id']]=$key_arr;
							}
							elseif(isset($all_filt->{$dash_tile['section_id']}) && $all_filt->{$dash_tile['section_id']} != "")
							{
								$key_arr=array();
								foreach($all_filt->{$dash_tile['section_id']} as $ky=>$val)
								{
								if($ky=="article_code") {
									$key_arr['article_code']=$all_filt->{$dash_tile['section_id']}->article_code;
								}
								if($ky=="art_title") {
									$key_arr['art_title']=$all_filt->{$dash_tile['section_id']}->art_title;
								}
								if($ky=="article_title") {
									$key_arr['art_title']=$all_filt->{$dash_tile['section_id']}->article_title;
								}
								if($ky=="article_type") {
									if($all_filt->{$dash_tile['section_id']}->article_type !='' && !is_numeric($all_filt->{$dash_tile['section_id']}->article_type)) {
										$key_arr['article_type']=$this->decrypt_data($all_filt->{$dash_tile['section_id']}->article_type);
										$article_type_data= Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$this->decrypt_data($all_filt->{$dash_tile['section_id']}->article_type)}");
									}
									elseif($all_filt->{$dash_tile['section_id']}->article_type !='' && is_numeric($all_filt->{$dash_tile['section_id']}->article_type)) {
										$key_arr['article_type']=$all_filt->{$dash_tile['section_id']}->article_type;
										$article_type_data= Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$all_filt->{$dash_tile['section_id']}->article_type}");
									}
									if($all_filt->{$dash_tile['section_id']}->article_type != "")
									{
										$article_type_data= Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$all_filt->{$dash_tile['section_id']}->article_type}");
									}
									if($all_filt->{$dash_tile['section_id']}->article_type !='' ) {
										$key_arr['article_type_set']=$article_type_data->artp_article_type;
									}
								}
								if($ky=="article_type_set") {
									$key_arr['article_type_set']=$all_filt->{$dash_tile['section_id']}->article_type_set;
								}
								if($ky=="special_issue") {
									$key_arr['special_issue']=$all_filt->{$dash_tile['section_id']}->special_issue;
								}
								if($ky=="stage_name") {
									$key_arr['stage_name']=$all_filt->{$dash_tile['section_id']}->stage_name;
								}
								if($ky=="status_name") {
									$key_arr['stage_name']=$all_filt->{$dash_tile['section_id']}->status_name;
								}
								if($ky=="date") {
									$key_arr['date']=$all_filt->{$dash_tile['section_id']}->date;
								}
								if($ky=="my_list") {
									$key_arr['my_list']=$all_filt->{$dash_tile['section_id']}->my_list;
								}
								if($ky=="start_date") {
									$date_set = '';
									if($all_filt->{$dash_tile['section_id']}->start_date != "")
									{
										$var = $all_filt->{$dash_tile['section_id']}->start_date;
										$date_set= date("Y-m-d", strtotime($var));
									}
									$key_arr['start_date']=$date_set;
								}
								if($ky=="end_date") {
									$date_sett = '';
									if($all_filt->{$dash_tile['section_id']}->end_date != "")
									{
										$varr = $all_filt->{$dash_tile['section_id']}->end_date;
										$date_sett= date("Y-m-d", strtotime($varr));
									}
									$key_arr['end_date']=$date_sett;
								}
								}
								$data_array[$dash_tile['section_id']]=$key_arr;
							}

						}
					}
				}
				$condition="ujdtfk_id={$all_filter->ujdtfk_id}";
				$update_arr = array(
					'ujdtfk_filter_keys' => json_encode((object)$data_array));
					$result = $User_journal_dashboard_tile_filter_keys::update_record($update_arr, $condition, $current_user);
			}
		}
		return $result;
		}
		catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}

	public function manage_dynamic_customform() {
		try {
		$jnl_details = Journals::get_all_records('jnl_id,jnl_journal_code');
		if (!empty($jnl_details)) {
			foreach ($jnl_details as $jn) {
				$jnlcode=$jn->jnl_journal_code;
				$table_name = 'rvw_article_gnf_form_data_'.$jnlcode;
				$tbk_table_name = 'tbk_article_gnf_form_data_'.$jnlcode;
				if (Schema::hasTable($table_name)) {
				$qry_gdata="ALTER TABLE `rvw_article_gnf_form_data_".$jnlcode."` ADD `gdata_dynamic_status` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'y=yes,n=no,g=group dynamic' AFTER `gdata_data_order`";
				DB::select($qry_gdata);
				}
				if (Schema::hasTable($tbk_table_name)) {
				$qry_tbkgdata="ALTER TABLE `tbk_article_gnf_form_data_".$jnlcode."` ADD `gdata_dynamic_status` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'y=yes,n=no,g=group dynamic' AFTER `gdata_data_order`";
				DB::select($qry_tbkgdata);
				}
			}
		}

		$qry_element = "ALTER TABLE `rvw_generic_form_elements` ADD `emt_dynamic_status` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'y=yes,n=no' AFTER `emt_source_elementid`";
		DB::select($qry_element);

		$qry_tbkelement = "ALTER TABLE `tbk_generic_form_elements` ADD `emt_dynamic_status` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'y=yes,n=no' AFTER `emt_source_elementid`";
		DB::select($qry_tbkelement);


		$qry_group = "ALTER TABLE `rvw_generic_form_group` ADD `gfg_dynamic_status` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'y=yes,n=no' AFTER `gfg_group_name`";
		DB::select($qry_group);

		$qry_tbkgroup = "ALTER TABLE `tbk_generic_form_group` ADD `gfg_dynamic_status` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'y=yes,n=no' AFTER `gfg_group_name`";
		DB::select($qry_tbkgroup);

		$qry_temp = "ALTER TABLE `rvw_article_gnf_form_data_temp` ADD `gdata_dynamic_status` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'y=yes,n=no,g=group dynamic' AFTER `gdata_data_order`";
		DB::select($qry_temp);

	}
	catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}


	}

	public function manage_dropdynamic_customform() {
		try {
		$jnl_details = Journals::get_all_records('jnl_id,jnl_journal_code');
		if (!empty($jnl_details)) {
			foreach ($jnl_details as $jn) {
				$jnlcode=$jn->jnl_journal_code;
				$table_name = 'rvw_article_gnf_form_data_'.$jnlcode;
				$tbk_table_name = 'tbk_article_gnf_form_data_'.$jnlcode;
				if (Schema::hasTable($table_name)) {
					$qry_gdata="ALTER TABLE `rvw_article_gnf_form_data_".$jnlcode."` DROP `gdata_dynamic_status`";
					DB::select($qry_gdata);
				}

				if (Schema::hasTable($tbk_table_name)) {
					$qry_tbkgdata="ALTER TABLE `tbk_article_gnf_form_data_".$jnlcode."` DROP `gdata_dynamic_status`";
					DB::select($qry_tbkgdata);
				}


			}
		}
		$qry_element = "ALTER TABLE `rvw_generic_form_elements` DROP `emt_dynamic_status` ";
		DB::select($qry_element);

		$qry_tbkelement = "ALTER TABLE `tbk_generic_form_elements` DROP `emt_dynamic_status` ";
		DB::select($qry_tbkelement);


		$qry_group = "ALTER TABLE `rvw_generic_form_group` DROP `gfg_dynamic_status` ";
		DB::select($qry_group);

		$qry_tbkgroup = "ALTER TABLE `tbk_generic_form_group` DROP `gfg_dynamic_status` ";
		DB::select($qry_tbkgroup);

		$qry_temp = "ALTER TABLE `rvw_article_gnf_form_data_temp` DROP `gdata_dynamic_status` ";
		DB::select($qry_temp);



	}
	catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}


	}

	public function manage_role_in_article_not_in_journal(Request $request)
	{
		try {
			// TASK #6273 start	

			$post_data = $request->all();
			$validator = Validator::make($request->all(), [
                'jnl_id' => 'required'
            ]);
            
            if($validator->fails())
            {
                    return  $this->failure('Failed',422,$validator->errors());
            }
			// $select_row = "SELECT * FROM (SELECT `usrj_jnl_id`,`usrj_usr_id`,GROUP_CONCAT(`usrj_role_id`) roles_in_jnl FROM `rvw_user_journals` WHERE `usrj_artp_id` IS null GROUP by `usrj_jnl_id`,`usrj_usr_id` ORDER by `usrj_jnl_id`,`usrj_usr_id`) as tb1 JOIN (SELECT `usrj_jnl_id`,`usrj_usr_id`,GROUP_CONCAT(`usrj_artp_id`) as artps,GROUP_CONCAT(DISTINCT `usrj_role_id`) roles_in_artp FROM `rvw_user_journals` WHERE `usrj_artp_id` IS NOT null GROUP by `usrj_jnl_id`,`usrj_usr_id`) as tb2 ON (tb1.usrj_jnl_id = tb2.usrj_jnl_id and tb1.usrj_usr_id = tb2.usrj_usr_id) WHERE FIND_array_in_all (roles_in_artp,roles_in_jnl) =0  AND tb2.usrj_jnl_id ={$post_data['jnl_id']}";
			// TASK #6273 end	
			$double_quote_param = '"';
			$select_row = "SELECT usrj_jnl_id, roles_in_jnl, usrj_usr_id, jnl_roles, roles_in_jnl_count, artps, roles_in_artp, artp_roles, roles_in_artp_count, GROUP_CONCAT(artp_role) AS grouped_artp_roles FROM ( SELECT tb3.usrj_jnl_id, tb3.usrj_usr_id, tb3.roles_in_jnl, tb3.jnl_roles, tb3.roles_in_jnl_count, tb3.artps, tb3.roles_in_artp, tb3.artp_roles, tb3.roles_in_artp_count, JSON_UNQUOTE(JSON_EXTRACT(tb3.artp_roles, CONCAT('$[', idx, ']'))) AS artp_role FROM ( SELECT tb1.usrj_jnl_id, tb1.usrj_usr_id, tb1.roles_in_jnl , tb1.jnl_roles, tb1.roles_in_jnl_count, tb2.artps, tb2.roles_in_artp , tb2.artp_roles, tb2.roles_in_artp_count, seq.idx FROM ( SELECT usrj_jnl_id, usrj_usr_id, GROUP_CONCAT(`usrj_role_id`) roles_in_jnl, CONCAT( '[', GROUP_CONCAT( '{$double_quote_param}', usrj_role_id, '{$double_quote_param}' SEPARATOR ',' ), ']' ) AS jnl_roles, COUNT(DISTINCT usrj_role_id) AS roles_in_jnl_count FROM rvw_user_journals WHERE usrj_artp_id IS NULL GROUP BY usrj_jnl_id, usrj_usr_id ) AS tb1 JOIN ( SELECT usrj_jnl_id, usrj_usr_id, GROUP_CONCAT(usrj_artp_id) AS artps,GROUP_CONCAT(DISTINCT `usrj_role_id`) roles_in_artp, CONCAT( '[', GROUP_CONCAT( DISTINCT '{$double_quote_param}', usrj_role_id, '{$double_quote_param}' SEPARATOR ',' ), ']' ) AS artp_roles, COUNT(DISTINCT usrj_role_id) AS roles_in_artp_count FROM rvw_user_journals WHERE usrj_artp_id IS NOT NULL GROUP BY usrj_jnl_id, usrj_usr_id ) AS tb2 ON tb1.usrj_jnl_id = tb2.usrj_jnl_id AND tb1.usrj_usr_id = tb2.usrj_usr_id, ( SELECT 0 AS idx UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8 UNION ALL SELECT 9) AS seq WHERE seq.idx < JSON_LENGTH(tb2.artp_roles) ) AS tb3) AS tb4 WHERE NOT JSON_CONTAINS(jnl_roles, JSON_QUOTE(artp_role), '$')GROUP BY usrj_jnl_id, usrj_usr_id, jnl_roles, roles_in_jnl_count, artps, artp_roles, roles_in_artp_count" ;

			$role_details = User_to_journals::get_records_by_raw_query($select_row);
			// print_r(count($role_details));
			// die;

			if (!empty($role_details)) {
				foreach ($role_details as $role_data) {
					$jnlID = $role_data->usrj_jnl_id;
					$userID = $role_data->usrj_usr_id;
					$roles_in_jnl = explode(',', $role_data->roles_in_jnl);
					$roles_in_artp = explode(',', $role_data->roles_in_artp);
					$difference = array_diff($roles_in_artp, $roles_in_jnl);
					$usertojournaltable = (new \App\Models\User_to_journals())->getTable();

					if ($difference > 0) {
						foreach ($difference as $roleId) {
							$get_role_update_details = 'SELECT `usrj_posted_date`,`usrj_posted_by`,`usrj_operation`  FROM `tbk_user_journals` WHERE `usrj_jnl_id` = ' . $jnlID . ' AND `usrj_usr_id` = ' . $userID . ' AND `usrj_role_id` = ' . $roleId . ' AND `usrj_operation` != "d"  ORDER BY `usrj_posted_date` DESC LIMIT 1';
							$role_update_details = User_to_journals::get_records_by_raw_query($get_role_update_details);

							$posted_date = date('Y-m-d H:i:s', strtotime($role_update_details[0]->usrj_posted_date));
							$posted_by_user = $role_update_details[0]->usrj_posted_by;
							$usrj_operation = $role_update_details[0]->usrj_operation;

							$update_sql = "INSERT INTO $usertojournaltable (usrj_jnl_id, usrj_usr_id, usrj_role_id, usrj_artp_id, usrj_cpy_class_art_type, usrj_enable_default_role, usrj_invite, usrj_role_retired, usrj_posted_by, usrj_posted_date, usrj_proxy_id) VALUES ($jnlID, $userID, $roleId, NULL, 'n', 'n', 'n', 'n', $posted_by_user, '" . $posted_date . "', $posted_by_user);";
							DB::select($update_sql);
							// die;
						}
					}
				}
				return $this->success("Success", 200, 'All articles roles are added into journal roles');
			} else {
				return $this->success("Success", 200, 'All articles roles were already added into journal roles');
			}
		} catch (Exception $e) {
			//print_r($e);
			return $this->failure('Failed', 500, $e);
		}
	}
	public function migratetabel(Request $request)
	{
	try{

		$table_conf= 'clients.' . $this->current_client->clnt_client_code.'.tabel_config';
		$exclude_arr  = Config::get($table_conf)['excluded_table'];
		$select_row ="SELECT CONCAT('SHOW CREATE TABLE ', table_name, ';') as table_name
		FROM information_schema.tables
		WHERE table_schema = '$request->database_name'";
		$resut=DB::select($select_row);
		$directory = "public/uploads/migration_intial/$request->folder_name";
		foreach($resut as $results){
		if (!Storage::exists($directory)) {
			$response = Storage::makeDirectory($directory);
		}

		$sourceStructure = DB::select($results->table_name);
		$structure =$sourceStructure[0];
		if (!in_array($structure->Table, $exclude_arr))
		{
			$databaseName = $request->database_name; // Replace with your database name
		$tableName = $structure->Table; // Replace with your table name

		$query = "
			SELECT TRIGGER_NAME, EVENT_OBJECT_TABLE, ACTION_STATEMENT
			FROM information_schema.TRIGGERS
			WHERE TRIGGER_SCHEMA = :databaseName
			AND EVENT_OBJECT_TABLE = :tableName;
		";

		$triggers = DB::select($query, [
			'databaseName' => $databaseName,
			'tableName' => $tableName,
		]);


	if($request->folder_name=='trigger_table'){
		foreach ($triggers as $trigger) {
			$migrationName = 'create_trigger_' . $trigger->TRIGGER_NAME;

			$content = '<?php use Illuminate\Database\Migrations\Migration;
			use Illuminate\Support\Facades\DB;
			use Illuminate\Support\Facades\Schema;

			return new class extends Migration
			{
				public function up()
				{
					DB::unprepared("CREATE TRIGGER ' . $trigger->TRIGGER_NAME . ' AFTER ' . $trigger->ACTION_STATEMENT . '");
				}

				public function down()
				{
					DB::unprepared("DROP TRIGGER ' . $trigger->TRIGGER_NAME . '");
				}
			};
			';

			$migrationPath = $directory . '/' . date('Y_m_d_His') . '_' . $migrationName . '.php';

			Storage::put($migrationPath, $content);
			$resut="database created successfully";
		}


	}

    else
	{
				Storage::put("$directory/$structure->Table.php", '<?php  use Illuminate\Database\Migrations\Migration;
				use Illuminate\Support\Facades\DB;
				use Illuminate\Support\Facades\Schema;
				return new class extends Migration
				{
					public function up()
					{
				DB::statement('.'"'. $structure->{'Create Table'} .'"'.');
			}public function down()
			{
				Schema::dropIfExists('.'"'. $structure->Table.'"'.');
			}
			};');

	}
	$resut="database created successfully2";
	}
}
return $resut;
	} catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}

	}

public function AlterColumnIN_gdatatb()
	{
		$mode = 'add';
		try
		{
			$databaseName =  DB::connection()->getDatabaseName();
			$query = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '".$databaseName."' AND (TABLE_NAME LIKE  'rvw_article_gnf_form_data%' OR TABLE_NAME LIKE  'tbk_article_gnf_form_data%')";
			$results = Articles::get_records_by_raw_query($query);

			if(!empty($results))
			{
				echo 'Start time : '.date('D M Y H:i:s').'<br>';

				foreach($results as $tableName)
				{
					$alter_query = 'ALTER TABLE '.$tableName->TABLE_NAME.' ADD `gdata_feh_id` BIGINT UNSIGNED DEFAULT NULL COMMENT \'PK of rvw_form_edithistory table\' AFTER `gdata_atfemt_id`;';
					$query_index2 = "ALTER TABLE ".$tableName->TABLE_NAME." ADD INDEX(`gdata_feh_id`);";

					Articles::get_records_by_raw_query($alter_query);
					Articles::get_records_by_raw_query($query_index2);
				}
				echo 'End time : '.date('D M Y H:i:s');
			}

		}
		catch(\Exception $e)
		{
			print_r($e);exit;
		}
	}
public function hideClassificationArticletype()
{
	try{
		DB::beginTransaction();
		$current_user = ['user_id' => 1, 'proxy_user_id' => 0];
		$update_data['atotp_classification'] = 'n';
		$condition['atotp_classification'] = 'y';
		Article_type_advance_options::update_record($update_data, $condition, $current_user);
		DB::commit();
	}
	catch(\Exception $e){
		DB::rollback();
		print_r($e);exit;
	}
}

/*
* DB fun to remove the copyright records for those articles which copyright stage is rescind
* After a article's copyright stage is rescind, that article's record in rvw_copyright tbl was not removed.
*/
public function remove_copyright_records_after_rescind() {
	try{
		$Copyright 	= 	new \App\Models\Copyright;
		$copyrgt_tbl= 	(new \App\Models\Copyright())->getTable();
		$query 		=	"SELECT c.crt_id FROM `".$copyrgt_tbl."` c WHERE NOT EXISTS (SELECT `aflw_id` FROM rvw_article_flow af WHERE af.aflw_id = c.crt_aflw_id)";
		$result 	= 	$Copyright::get_records_by_raw_query($query);
		if(count($result) > 0) {
			DB::beginTransaction();
			$delQry 		=	"DELETE FROM `".$copyrgt_tbl."` c WHERE NOT EXISTS (SELECT `aflw_id` FROM rvw_article_flow af WHERE af.aflw_id = c.crt_aflw_id)";
			if($Copyright::get_records_by_raw_query($delQry) == true) {
				echo count($result) . " records removed from " . $copyrgt_tbl;
			}
			DB::commit();
		} else {
			echo "No records to remove";
		}
	}
	catch(\Exception $e){
		DB::rollback();
		print_r($e);exit;
	}
}

/*
* If a uers's journal user flag already exists in the hs global user flag
* then that user's journal flag needs to be removed.
*/
public function remove_jnl_usr_flgs() {
	try{
		$Userflags 		= 	new \App\Models\User_flags;
		$usrflg_tbl		= 	(new \App\Models\User_flags())->getTable();
		$usrglbflg_tbl	= 	(new \App\Models\User_global_flags())->getTable();
		$query 			=	"SELECT `uf_flag_id` AS flag_id, `uf_usr_id` AS usr_id
							FROM `".$usrflg_tbl."` `uf`
							INNER JOIN `".$usrglbflg_tbl."` `ugf`
							ON (`ugf`.`ugf_user_id` = `uf`.`uf_usr_id` AND `ugf`.`ugf_flag_id` = `uf`.`uf_flag_id`)";
		$result 	= 	$Userflags::get_records_by_raw_query($query);

		if(count($result) > 0) {
			DB::beginTransaction();
			$condi	=	"WHERE ";
			foreach($result as $key => $arr) {
				$flg_id 	=	$arr->flag_id;
				$usr_id 	=	$arr->usr_id;
				$condi	.=	"(uf_flag_id = ".$flg_id." AND uf_usr_id = ".$usr_id.") OR ";
			}
			$condi 		= 	rtrim($condi," OR ");
			$sqlQry 	=	"SELECT f.flag_name, j.jnl_journal_name, concat(u.usr_first_name, ' ', u.usr_last_name) as user
							FROM
								`rvw_user_flags` uf
							JOIN `rvw_flags` f ON (f.flag_id = uf.uf_flag_id)
							JOIN `rvw_journals` j ON (j.jnl_id = uf.uf_jnl_id)
							JOIN `rvw_users` u ON (u.usr_id = uf.uf_usr_id)
							".$condi."";
			$records	=	$Userflags::get_records_by_raw_query($sqlQry);
			foreach($records as $key => $arr) {
				echo "<div><b>".$arr->user ."</b>'s <i>".$arr->flag_name."</i> flag in <u>".$arr->jnl_journal_name."</u> has been removed.</div><br/>" ;
			}
			$delQry		=	"DELETE FROM `".$usrflg_tbl."`".$condi."";
			$Userflags::get_records_by_raw_query($delQry);
			DB::commit();
		} else {
			echo "There are no user journal flags to remove.";
		}
	}
	catch(\Exception $e){
		DB::rollback();
		print_r($e);exit;
	}
}

/*
*Task_id: #4544
*Function to convert article_title with non ascii characters to html entity
*/
public function convert_non_ascii_char_to_code()
{
	try {
		$entArr 	= 	Consts::EntitiesArr;
		$select 	=	"`art_id`, `art_title`";
		$condition	=	"`art_title` <> CONVERT(`art_title` USING ASCII)";
		//getting non ascii character string
		$result		=	Articles::get_all_records($select,$condition,'art_id',NULL,'',NULL,NULL,'DESC');
		if (!empty($result)) {
			foreach ($result as $key => $value) {
				$converted_string	=	strtr($value->art_title,$entArr);
				$data['art_title']	=	$converted_string;
				//update the art_title with new string
				Articles::update_record($data,"art_id = {$value->art_id}");//art_operation
			}
		} else {
			echo "No record found";
		}
	} catch (\Exception $e) {
		DB::rollback();
	}
}

	public function fix_due_date_time_issue()
	{
		try {
			$Generic_flows_table = (new \App\Models\Generic_flows())->getTable();	
			$Articles_table = (new \App\Models\Articles())->getTable();	
			$Article_flow_table = (new \App\Models\Article_flow())->getTable();
			$tables = array(
				'main_table' => $Article_flow_table,
				'join_table' => array(
					$Articles_table => array($Articles_table . '.art_id', $Article_flow_table . '.aflw_art_id'),
					$Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', 'left')
				)
			);
			$select_fields = 'art_id,aflw_posted_date,aflw_due_date';
			$criteria = "aflw_due_date LIKE '%00:00:00%' AND jwf_stage_type='author_submission'";
			$art_dets = Articles::get_results_using_joins($tables, $select_fields, $criteria, 'all','aflw_id DESC');
			if (count($art_dets) > 0){
				$sql_set = '';
				foreach ($art_dets as $art){
					$posted_date = Carbon::parse($art->aflw_posted_date);
					$posted_time = $posted_date->format('H:i:s');

					$due_date = Carbon::parse($art->aflw_due_date);
					$updated_due_time = $due_date->format('Y-m-d') .' '. $posted_time;
					$art->updated_due_time = $updated_due_time;

					$update_data = "aflw_due_date ='" . $art->updated_due_time ."'";
					$sql_set =  "update {$Article_flow_table} set " . $update_data . " where aflw_art_id =" . $art->art_id . ";";
					Article_flow::execute_query($sql_set, TRUE);
				}
			}
		} catch (\Exception $e) {
			// print_r($e);exit;
			return  $this->failure('Failed',500,$e);
			//throw $th;
		}
	}
	
	public function manage_hidelabel() {
		try {
			$qry_element = "ALTER TABLE `rvw_generic_form_elements` ADD `emt_hideafterstage` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'label hide after stage complete y=yes,n=no' AFTER `emt_dynamic_status`";
			DB::select($qry_element);

			$qry_tbkelement = "ALTER TABLE `tbk_generic_form_elements` ADD `emt_hideafterstage` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'label hide after stage complete y=yes,n=no' AFTER `emt_dynamic_status`";
			DB::select($qry_tbkelement);
		} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}

	public function moveClassificationToJournal()
	{
		try
		{
			$current_user = array('user_id' => 1, 'proxy_user_id' => 0);
			$classifications_table = (new \App\Models\Classifications())->getTable();
			DB::beginTransaction();
			$result = Classifications::delete_records("cls_jnl_id=16 AND cls_artp_id IS NULL", "", $current_user);
			if($result)
			{
				$data = Classifications::update_record(array("cls_artp_id" => NULL), "cls_jnl_id=16 AND cls_artp_id IS NOT NULL", $current_user);
				print_r($data);
			}
			DB::commit();
		}catch (\Exception $e) {
			// print_r($e);exit;
			DB::rollback();
			return  $this->failure('Failed',500,$e);
		}
	}

//changing existing retire status y  of author,reviewer to n
	public function changeRetirestatus()
	{
		try{
			DB::beginTransaction();
			$criteria = "usr_username LIKE '%sudo%'";
			$userdata= User::get_single_record('usr_id',$criteria);
			$current_user = ['user_id' =>$userdata->usr_id, 'proxy_user_id' => 0];
			$role_criteria = "role_assigned_role IN ('author','reviewer')";
			$roledata= Roles::get_all_records('role_id',$role_criteria);
			$roles = array_column(json_decode(json_encode($roledata), TRUE), 'role_id');
            $role_cond = 'usrj_role_id IN (' . implode(',', $roles) . ') AND usrj_role_retired=\'y\'';	
			$update_data['usrj_role_retired'] = 'n';
			User_to_journals::update_record($update_data,$role_cond,$current_user);
			DB::commit();
		}
		catch(\Exception $e){
			DB::rollback();
			
		}
	}

	public function copy_table_btw_connections(array $table_details,string $from_conn, string $to_conn, $include_data = false, $copy_data_only = false, $incl_client_code = false, $keep_id = true)
	{
		$table_name = $table_details['name'];
		$client_code = $incl_client_code ? $this->client_code : null;
		$cols = DB::getSchemaBuilder()->getColumns($table_name);
		$sql = "CREATE TABLE $table_name (";
		$message = '';
		$prefix = $table_details['prefix'];
		$primary_key = $table_details['primary_key'];
		$table_exist = Schema::connection($to_conn)->hasTable($table_name);
		if ($table_exist && !$copy_data_only) {
			return "Table already exist";
		}
		$client_column = $prefix.'_client_code';
		if($client_code){
			$client_col = array(
				'name' => $prefix.'_client_code',
				'type' => 'varchar(50)',
				'collation' => 'utf8mb4_unicode_ci',
				'default' => null,
				'comment' => null,
				'auto_increment' => false,
				'nullable' => true,
			);

			array_splice($cols, 1, 0,[$client_col]);
		}
		try{
			DB::beginTransaction();
		if (!$copy_data_only) {
			foreach ($cols as $col) {
				$name = $col['name'];
				$type = $col['type'];
				$default = $nullable = '';
				$nullable = $col['nullable'] ? '' : "NOT NULL" ;
				$auto_inc = $col['auto_increment'] ? 'AUTO_INCREMENT PRIMARY KEY' : '';
				if(!$auto_inc){
					if($col['nullable']){
						$default = $col['default'] == null ? "DEFAULT NULL" : "DEFAULT '".$col['default']."'";
					}
				}
				$cmnt = $col['comment'];
				$collate = $col['collation'];
				$sql .= "$name $type $nullable $default $auto_inc";
				if($collate){
					$sql .= "COLLATE $collate $auto_inc ";
				}
				if($cmnt){
					$sql.= 'COMMENT "'. "$cmnt" . '"' ;
				}
				$sql .= ", ";
			}
			$sql = rtrim($sql, ", ");
			$sql .= ");";
			DB::connection('mysql_common')->statement($sql);
			$message = "Table created. ";
		}

		if ($include_data) {
			DB::connection($from_conn)->table($table_name)->orderBy($primary_key)->chunk('500', function ($rows) use ($table_name, $to_conn, $client_column, $client_code, $keep_id, $primary_key) {
				foreach ($rows as $row) {
					if($client_code)
						$row->$client_column = $client_code;
					if(!$keep_id){
						unset($row->$primary_key);
					}
					DB::connection($to_conn)->table($table_name)->insert(json_decode(json_encode($row), true));
				}
			});

			$message .= "Data copied.";
		}
		DB::commit();
	}
	catch(Exception $e){
		DB::rollBack();
		Log::warning("Error in copy_table_btw_connections");
		Log::warning($e);
		return "Unable to complete the transaction, Please check the log for further details.";
	}

		return $message;
	}
	public function add_role_into_journals(Request $request)
	{
		try {
			print_r($request->role_id);die;
			$jnl_id_array = ($request->jnl_id) ? explode(',',$request->jnl_id) : []; 
			$role_id_array = ($request->role_id) ? explode(',',$request->role_id) : [];
			if (count($jnl_id_array)>0) {
				$this->add_roles_to_journal($jnl_id_array,$role_id_array);
				return $this->success("Success", 200, 'User roles are added into the given journals');
			}
			 else {
				$journal_id_details = Journals::get_all_records("jnl_id,jnl_journal_name");
                $journal_id_arr = array_column(json_decode(json_encode($journal_id_details),true) ,'jnl_id');
				$this->add_roles_to_journal($journal_id_arr,$role_id_array);
				return $this->success("Success", 200, 'User roles added into all journals');
			}
		} catch (Exception $e) {
			//print_r($e);
			return $this->failure('Failed', 500, $e);
		}
	}
	public function add_roles_to_journal($jnlidarray,$roleidarray)
	{
		try {
			foreach ($jnlidarray as $jnl_id) {
				$jnlID = $jnl_id;
				$userID = '1';
				$usertojournaltable = (new \App\Models\User_to_journals())->getTable();
				if ($roleidarray > 0) {
					foreach ($roleidarray as $roleId) {
						$posted_date = date('Y-m-d H:i:s', time());
						$posted_by_user = '1';
						$usrj_operation = 'i';
						$insert_sql = "INSERT INTO $usertojournaltable (usrj_jnl_id, usrj_usr_id, usrj_role_id, usrj_artp_id, usrj_cpy_class_art_type, usrj_enable_default_role, usrj_invite, usrj_role_retired, usrj_posted_by, usrj_posted_date, usrj_proxy_id,usrj_operation) VALUES ($jnlID, $userID, $roleId, NULL, 'n', 'n', 'n', 'n', $posted_by_user, '" . $posted_date . "', $posted_by_user,$usrj_operation);";
						DB::select($insert_sql);
					}
				}
			}
			return true;
		} catch (\Throwable $th) {
			return false;
		}
	}
	public function update_inviation_date_as_assigned_date()
	{

		try {
			$Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
			$Article_flow_table = (new \App\Models\Article_flow())->getTable();
			$Article_reviewers_table = (new \App\Models\Article_reviewers())->getTable();

			$tables = array(
				'main_table' => $Article_flow_table,
				'join_table' => array(
					$Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id')
				)
			);
			$select_fields = 'aflw_id';
			$criteria = "aflw_status = 'i' AND jwf_stage_type='review'";
			$art_dets = Articles::get_results_using_joins($tables, $select_fields, $criteria, 'all', 'aflw_id DESC');
			if (count($art_dets) > 0) {
				$sql_set = '';
				foreach ($art_dets as $art) {
					$aflw_id = $art->aflw_id;
					$reviewer_data = Article_reviewers::get_single_record('sorw_invited_on', "sorw_aflw_id={$aflw_id} ");
					$update_data = "aflw_assigned_date ='" . $reviewer_data->sorw_invited_on . "' , aflw_flow_operation = 'e'";
					$sql_set =  "update {$Article_flow_table} set " . $update_data . " where aflw_id =" . $aflw_id . " AND aflw_assigned_date !='" . $reviewer_data->sorw_invited_on . "';";
					Article_flow::execute_query($sql_set, TRUE);
				}
				return $this->success("Success", 200, 'Assigned date updated successfully');
			} else {
				return $this->success("Success", 200, 'No record found');
			}
		} catch (\Exception $e) {
			return  $this->failure('Failed', 500, $e);
		}
	}

	public function updateProposalmethod()
	{
		try
		{
		Articles::execute_query("UPDATE `rvw_articles` SET `art_proposal_method` = 'invite' WHERE art_proposal_method IS NULL AND art_stage_submission_method ='b';");
	} catch (\Exception $e) {
		return  $this->failure('Failed', 500, $e);
	}
     }
     
	 public function journal_workflow_jsondata(Request $request)
	 {
		try {
			$post_data = $request->all();
			$flw_master_id = isset($post_data['fwm_id']) ?  $post_data['fwm_id'] : '';
			if(!empty($flw_master_id))
			{
				$con="jwf_fwm_id='{$flw_master_id}'";
				$work_flows = Generic_flows::get_all_records('*', $con);
				if (!empty($work_flows))
				{
					foreach ($work_flows as $article_flow)
					{
						$parent_stages = json_decode($article_flow->jwf_parent_stages);
						$parent_stages_arr=array();
						foreach ($parent_stages as $key => $parent_stages_id)
						{
									array_push($parent_stages_arr,"".$parent_stages_id."");		
						}
						$flow_con="jwf_id='{$article_flow->jwf_id}'";

						Generic_flows::update_record(array(
					'jwf_parent_stages' => json_encode($parent_stages_arr)), $flow_con);

					$child_stages = json_decode($article_flow->jwf_child_stages);
					$child_stage_arr=array();
					foreach ($child_stages as $key => $child_stages_id)
					{
								array_push($child_stage_arr,"".$child_stages_id."");	
					}
					Generic_flows::update_record(array(
						'jwf_child_stages' => json_encode($child_stage_arr)), $flow_con);

				}

				}
			}
		}catch (\Exception $e) {
			return  $this->failure('Failed', 500, $e);
		}
	 }

	 public function remove_empty_attachment_data_from_email_send_log(Request $request)
	 {
		 try {
			 $email_send_log_table=new \App\Models\Email_send_log();
			 die;
			 $select_row = " SELECT * FROM rvw_email_send_log WHERE `esl_attachments` IN( '{\"article\":[],\"modified\":[]}', '{\"modified\":[]}', '{\"article\":[]}' )";
			 $mail_details = $email_send_log_table::get_records_by_raw_query($select_row);
			 if (!empty($mail_details) && count($mail_details)>0) {
				 $update_sql = "UPDATE `rvw_email_send_log` SET `esl_attachments` = NULL WHERE `esl_attachments` IN( '{\"article\":[],\"modified\":[]}', '{\"modified\":[]}', '{\"article\":[]}' )";
				 DB::select($update_sql);
				 return $this->success("Success", 200, 'Empty array of attchments in articles and modified removed and replace with NULL in email send log esl_attachements column.');
			 } else {
				 return $this->success("Success", 200, 'No empty data exist in email send log esl_attachments column.');
			 }
 
		 } catch (Exception $e) {
			 return $this->failure('Failed', 500, $e);
		 }
	 }
	
	 //function to update currency id with 0 into null in rvw_journal_workflows table,TASK #7993
	 public function updateJwfCurrencyColumn()
	 {
		try {
			DB::beginTransaction();
			$data = ['jwf_curr_id'=>null,'jwf_payment_fees'=>null,'jwf_payment_notes'=>null];
			$criteria = 'jwf_curr_id = 0 or jwf_payment_fees = 0';
			Generic_flows::update_record($data,$criteria);
			DB::commit();
		} catch (Exception $e) {
			DB::rollBack();
			Log::warning("Error in update currency id");
			Log::warning($e);
			return "unable to complete transaction";
		}
	 }
	 public function initiate_manual_export(Request $request){
		try {
			$post_data = $request->all();
			$this->current_user = $this->get_current_user_details();
			$art_id  = $post_data['art_id'];
			$aflw_id = $post_data['current_flow_id'];
			$next_stage_result = array(
				'stage_id' => $post_data['next_flow_id']
			);
			$this->upload_article_data_to_custom_ftp($art_id, $aflw_id, 'c', $next_stage_result);
		} catch (Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	 }
	 public function insert_data_in_all_clients()
	 {
		try {
			DB::beginTransaction();
			$current_client = $this->get_client_details();
			$all_clients = new \App\Models\All_Clients();
			$all_clients::firstOrCreate(
				['acls_client_code' => $current_client->clnt_client_code],
				[	'acls_client_name' => $current_client->clnt_client_name,
					'acls_posted_date' => date("Y-m-d H:i:s"),
					'acls_posted_by' => 0,
					'acls_proxy_id'  => 0,
					'acls_operation' => 'i'
				]
			);
			DB::commit();
		} catch (Exception $e) {
			DB::rollBack();
			Log::warning("Error in insrt data into all_clients table");
			Log::warning($e);
			return "unable to complete transaction";
		}
	 }
	 public function assignIssueToNewArticleVersion()
	 {
		try { 
			DB::beginTransaction();
			$criteria = "usr_username LIKE '%sudo%'";
			$userdata= User::get_single_record('usr_id',$criteria);
			$current_user = ['user_id' =>$userdata->usr_id, 'proxy_user_id' => 0];
			$issues_table = (new \App\Models\Issues())->getTable();
			$articles_table = (new \App\Models\Issues())->getTable();
			$issue_management_table = (new \App\Models\Issue_management())->getTable();
			$issue_management_tbk_table = (new \App\Models\Issue_management())->getTable();
			//1.To get the articles currently assigned to an issue from issue management.
			$condition="ism_art_id IS NOT NULL";
			$ism_articles = Issue_management::get_all_records('ism_id,ism_iss_id,ism_art_id,ism_posted_by,ism_posted_date,ism_operation',$condition);
			foreach($ism_articles as $ism_art)
			{
				$condition="art_id={$ism_art->ism_art_id}";
				$available_article_version = Articles::get_single_record("art_id,art_code,art_artp_id,art_publication_issue,art_transfer_article", $condition);
				if(!empty($available_article_version))
				{
					$condition="artp_id={$available_article_version->art_artp_id}";
					$available_article_version_art_type = Article_types::get_single_record('artp_id,artp_jnl_id', $condition);
					$available_art_journal_id = $available_article_version_art_type->artp_jnl_id;
					//2.To get the articles of the next version from the article table.
					$condition="art_prev_article_id={$ism_art->ism_art_id}";
					$revised_version_article = Articles::get_single_record("art_id,art_code,art_artp_id,art_publication_issue,art_transfer_article", $condition);
					//3.The loop begins to recursively collect the latest versions of the article and randomly checks if any issue is currently assigned.
					while(!empty($revised_version_article))
					{
						//4.If the next version of the article is found, initiate the process to assign the current issue, provided no issue has been assigned yet.
						if(!empty($revised_version_article))
						{	
							$condition="artp_id={$revised_version_article->art_artp_id}";
							$revised_version_article_type = Article_types::get_single_record('artp_id,artp_jnl_id', $condition);
							$revised_journal_id = $revised_version_article_type->artp_jnl_id;
							$revision_available = true;
							$issue_id_to_assign = $ism_art->ism_iss_id;
							if($available_art_journal_id == $revised_journal_id && $revised_version_article->art_transfer_article == 'n')
							{
								//5.Verifies whether any issue is currently assigned to a single article.
								$condition="ism_art_id={$revised_version_article->art_id}";
								$ism_record = Issue_management::get_single_record('ism_id,ism_iss_id,ism_art_id,ism_posted_by,ism_posted_date,ism_operation',$condition);
								//6.If no issue is found, verify whether it has been removed by the user by checking the issue management tbk table.
								//  Else get the issue from the next version and assign to variable $issue_id_to_assign.
								if(empty($ism_record))
								{
									$query="SELECT ism_id,ism_iss_id,ism_art_id,ism_posted_by,ism_posted_date,ism_operation from tbk_issue_management WHERE ism_art_id={$revised_version_article->art_id}";
									$tbk_result = DB::select($query);
									//7.Check the TBK table to confirm if the user has removed the issue from the next version of the article that requires issue assignment.
									//$tbk_result[count($tbk_result)-1]->ism_operation == 'd'
									if(count($tbk_result) == 0)
									{
										//8.If no entry is found in the backup table, proceed to assign the issue to the selected article.
										$parts = explode('-', $revised_version_article->art_code);
										$jnl_code = 'j'.strtolower($parts[0]);
										//$pdf_pages = $this->issue_management_page_count($revised_version_article->art_id,$jnl_code);
										$jnl_details = Journals::get_single_record('jnl_id,jnl_journal_name');
										if(!empty($jnl_details))
										{
											$data = array(
												'ism_art_page_cnt' => 1,
												'ism_iss_id' =>  $issue_id_to_assign,
												'ism_art_id' =>  $revised_version_article->art_id,
												'ism_order'  =>  1
											);
											$condition="iss_id={$issue_id_to_assign}";
											$issue_data = Issues::get_single_record('iss_id,iss_title,iss_status',$condition);
											if($issue_data->iss_status != 'c')
											{
												$issue_record = Issue_management::get_single_record('ism_id','ism_art_id='.$revised_version_article->art_id);
												if(empty($issue_record))
												{
													// $result = Issue_management::insert_record($data, $current_user);
													// $criteria = 'art_id = "' .$revised_version_article->art_id.'"';
													// $data = array('art_publication_issue' => $issue_id_to_assign);
													// $result = Articles::update_record($data, $criteria, $current_user);
													echo "\n".$revised_version_article->art_code." -> ".$issue_data->iss_title." (".$issue_data->iss_status.") ";
												}
											}
										}
									}
								}
								else
								{
									$issue_id_to_assign = $ism_record->ism_iss_id;
								}
								//To get the articles of the next version of the current assigned.
								$previous_journal_id = $revised_journal_id;
								$condition="art_prev_article_id={$revised_version_article->art_id}";
								$revised_version_article = Articles::get_single_record("art_id,art_code,art_artp_id,art_publication_issue,art_transfer_article", $condition);
								if(!empty($revised_version_article))
								{
									$condition="artp_id={$revised_version_article->art_artp_id}";
									$revised_version_article_type = Article_types::get_single_record('artp_id,artp_jnl_id', $condition);
									$revised_journal_id = $revised_version_article_type->artp_jnl_id;
								}
								
							}
							else
							{
								$revised_version_article = NULL;
								continue;
							}
						}
					}
				
				}
			}
			DB::commit();
		} catch (Exception $e) {
			DB::rollBack();
			Log::warning($e);
			print_r($e);
		}
	 }


	 public function updateiThenticateConfig()
	 {
		 if(isset($this->current_client->functionality->cfty_ithenticate_v2) &&  isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
		 {
			 $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
			 $ithenticateconfig  = Config::get($ithenticate_config);
			 $ithV2Config = isset($ithenticateconfig['ithenticate_v2'])?$ithenticateconfig['ithenticate_v2']:null;
 
			 $url = isset($ithV2Config['api_url']) && $ithV2Config['api_url']!= null? $ithV2Config['api_url']:null;
			 $api_key = isset($ithV2Config['api_key']) && $ithV2Config['api_key']!= null?$ithV2Config['api_key']:null;
 
			 $data_view_settings = $data_index_settings = $data_save_changes = array();
			 if(isset($ithV2Config['view_settings']))
			 {
				 foreach($ithV2Config['view_settings'] as $key=>$val)
				 {
					 $data_view_settings[$key] = $val['value'];
				 }
			 }
			 if(isset($ithV2Config['indexing_settings']))
			 {
				 foreach($ithV2Config['indexing_settings'] as $key=>$val)
				 {
					 $data_index_settings[$key] = $val['value'];
				 }
			 }
			 if(isset($ithV2Config['similarity_view_settings']))
			 {
				 foreach($ithV2Config['similarity_view_settings'] as $key=>$val)
				 {
					 $data_save_changes[$key] = $val['value'];
				 }
			 }
			 //echo '<pre>';print_r($data_save_changes);exit;
			 $Journal_settings_table = (new \App\Models\Journal_settings())->getTable();
			 $Api_credentials_table = (new \App\Models\Api_credentials())->getTable();
			 
			 $tables = array(
				 'main_table' => $Journal_settings_table,
				 'join_table' => array(
					 $Api_credentials_table => array('jset_jnl_id','acrd_jnl_id','left'),
			 ));
			 $criteria = 'acrd_artp_id IS NULL AND (jset_ith_v2_view_settings IS NOT NULL OR acrd_jnl_id IS NOT NULL) ';
			 $select ='jset_jnl_id as jnl_id,jset_eula as eula,jset_ith_v2_view_settings as ith_v2_view_settings,jset_ith_v2_add_to_index as ith_v2_add_to_index,jset_ith_v2_save_changes as ith_v2_save_changes,acrd_id,acrd_user_name,acrd_password';
			 //$type = 'artp' ;
			 
			 $art_details =  Journal_settings::get_results_using_joins($tables,$select,$criteria,'all');
			 //echo '<pre>';print_r($art_details);exit;
			 //set here only for journal not for article type in api_credentials
			 $this->updateithCredTable($art_details,$data_view_settings,$data_index_settings,$data_save_changes,$url,$api_key);
		 }
	 }
 
	 public function updateithCredTable($details,$data_view_settings,$data_index_settings,$data_save_changes,$url,$api_key,$type='jnl')
	 {
		 $return = false;
		 if(!empty($details))
		 {
			 $user_data = array(
				 'user_id' => 0,
				 'proxy_user_id' => 0
			 );
			 foreach($details as $creds)
			 {
				 $ith_v2_view_settings = $creds->ith_v2_view_settings != null?$creds->ith_v2_view_settings:json_encode($data_view_settings);
				 $ith_v2_add_to_index = $creds->ith_v2_add_to_index!= null?$creds->ith_v2_add_to_index:json_encode($data_index_settings);
				 $ith_v2_save_changes = $creds->ith_v2_save_changes!= null? $creds->ith_v2_save_changes:json_encode($data_save_changes);
 
				 $data = array(	
					 'acrd_ith_v2_view_settings'=>$ith_v2_view_settings,
					 'acrd_ith_v2_add_to_index'=>$ith_v2_add_to_index,
					 'acrd_ith_v2_save_changes'=>$ith_v2_save_changes,
				 );
				 if($creds->acrd_id == null && $url != null && $api_key != null)
				 {
					 $data['acrd_clnt_id'] = $this->current_client->clnt_id;
					 $data['acrd_api_name'] = 'ithenticate';
					 $data['acrd_user_name'] = $url;
					 $data['acrd_password'] = encrypt_link($api_key);
					 $data['acrd_jnl_id'] = $creds->jnl_id;
					 if(isset($creds->artp_id) && $type== 'artp')
					 {
						 $data['acrd_artp_id'] = $creds->artp_id;
					 }
					 
					 Api_credentials::insert_record($data,$user_data);
				 }
				 elseif($creds->acrd_id != null)
				 {
					 $cond = array(
						 'acrd_id' => $creds->acrd_id
					 );
					 Api_credentials::update_record($data,$cond,$user_data);
				 }
			 }
			 $return = true;
		 }
		 return $return;
	 }
	 //TASK #9125 The email template's BCC field did not specify a specific email address.
	 public function updateCcBccemailtemplate()
      {
    try {
        // Update queries for `rvw_email_tmpls`
        Email_templates::execute_query(
            "UPDATE rvw_email_tmpls 
            SET 
                etmp_bcc = REPLACE(etmp_bcc, 'Custom', 'Custom_bcc'),
                etmp_cc = REPLACE(etmp_cc, 'Custom', 'Custom_cc') 
            WHERE 
                (etmp_bcc LIKE '%Custom%' AND etmp_bcc NOT LIKE '%Custom_bcc%') 
                OR 
                (etmp_cc LIKE '%Custom%' AND etmp_cc NOT LIKE '%Custom_cc%');"
        );
        
        // Update queries for `rvw_stage_email_tmpls`
        Stage_email_templates::execute_query(
            "UPDATE rvw_stage_email_tmpls 
            SET 
                stage_etmp_bcc = REPLACE(stage_etmp_bcc, 'Custom', 'Custom_bcc'),
                stage_etmp_cc = REPLACE(stage_etmp_cc, 'Custom', 'Custom_cc') 
            WHERE 
                (stage_etmp_bcc LIKE '%Custom%' AND stage_etmp_bcc NOT LIKE '%Custom_bcc%') 
                OR 
                (stage_etmp_cc LIKE '%Custom%' AND stage_etmp_cc NOT LIKE '%Custom_cc%');"
        );

        // Update queries for `rvw_article_autoinvitation_emails`
        Article_autoinvitation_emails::execute_query(
            "UPDATE rvw_article_autoinvitation_emails 
            SET 
                aae_bcc = REPLACE(aae_bcc, 'Custom', 'Custom_bcc'),
                aae_cc = REPLACE(aae_cc, 'Custom', 'Custom_cc') 
            WHERE 
                (aae_bcc LIKE '%Custom%' AND aae_bcc NOT LIKE '%Custom_bcc%') 
                OR 
                (aae_cc LIKE '%Custom%' AND aae_cc NOT LIKE '%Custom_cc%');"
        );

        // Update queries for `rvw_adhoc_notification_emails`
        Adhoc_notification_emails::execute_query(
            "UPDATE rvw_adhoc_notification_emails 
            SET 
                ade_bcc = REPLACE(ade_bcc, 'Custom', 'Custom_bcc'),
                ade_cc = REPLACE(ade_cc, 'Custom', 'Custom_cc') 
            WHERE 
                (ade_bcc LIKE '%Custom%' AND ade_bcc NOT LIKE '%Custom_bcc%') 
                OR 
                (ade_cc LIKE '%Custom%' AND ade_cc NOT LIKE '%Custom_cc%');"
        );

        // Update queries for `rvw_article_notification_emails`
        Article_notification_emails::execute_query(
            "UPDATE rvw_article_notification_emails 
            SET 
                ane_bcc = REPLACE(ane_bcc, 'Custom', 'Custom_bcc'),
                ane_cc = REPLACE(ane_cc, 'Custom', 'Custom_cc') 
            WHERE 
                (ane_bcc LIKE '%Custom%' AND ane_bcc NOT LIKE '%Custom_bcc%') 
                OR 
                (ane_cc LIKE '%Custom%' AND ane_cc NOT LIKE '%Custom_cc%');"
        );
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
     }

	/**
	 * Task #10009  Remove AoP1 statges from ICE/Emerald workflow
	 * STEPS

		0.Add "copy_editing" stage in "qulity_check" stage's child array 			==>	done
		1.Run above query and fetch master ids and avoid these flow				==>	done
		2.Except these workflow stages disable 						==>	
		3.connect disabled master flows initate production stage and copyedit stage
		4.Manage Workflow preference


		==> rvw_article_parallel_flow_movement -- no action needed in this table
		==> rvw_advance_flow_movement		 -- in this table -- (*)Initiate production (qulity_check) [Preprocessing -> copyediting] change afm_associated_stage_ids id if not multiple then change it to copyedit stage , (*) change afm_button_title and afm_button_tooltip  set as null (if existed)
	*/
	public function alterAoP1Workflow()
	{
		try
		{
			DB::beginTransaction();
			//$testingCnd = ' AND jwf_fwm_id = 72'; 
			$testingCnd = '';
			$currentUser = array(
				'user_id' => 0,
				'proxy_user_id' => 0
			);

			$mainCnd = " ( (jwf_stage_type = 'aop_publish' AND jwf_stage_name = 'Publish AoP1') OR (jwf_stage_type = 'preprocessing' AND jwf_stage_name = 'Check AoP1') OR (jwf_stage_type = 'editorial_process' AND jwf_stage_name = 'AoP1 correction') OR (jwf_stage_type = 'preprocessing' AND jwf_stage_name = 'Preprocess for AoP1') ) ";
			$query = "SELECT group_concat(DISTINCT jwf_fwm_id) as master_ids FROM rvw_journal_workflows JOIN rvw_article_flow ON aflw_jwf_id = jwf_id LEFT JOIN rvw_article_types ON jwf_fwm_id = artp_fwm_id LEFT JOIN rvw_journals ON artp_jnl_id = jnl_id LEFT JOIN rvw_articles ON art_id = aflw_art_id WHERE ".$mainCnd." AND aflw_status != 'c'  AND art_delete_status != 'w'";
			$result = Generic_flows::get_records_by_raw_query($query,true);
			//$excludeflows = array();
			$excludeCnd1 = '';
			$excludeCnd = '';
			if(!empty($result))
			{
				//$excludeflows = explode(',',$result->master_ids);
				if(isset($result->master_ids) && $result->master_ids != '')
				{
					$excludeCnd1 = ' where FIND_array_not_in(jwf_fwm_id,"'.$result->master_ids.'") = 1';
					$excludeCnd = ' AND FIND_array_not_in(jwf_fwm_id,"'.$result->master_ids.'") = 1';
				}
			}
			
			//Update required stages with hide status y
			$queryUpdate = "Update rvw_journal_workflows SET jwf_hide_status = 'y' WHERE jwf_hide_status!= 'y' AND ".$mainCnd.$excludeCnd.$testingCnd;
			Generic_flows::execute_query($queryUpdate);

			$querySelect = 'Select DISTINCT `jwf_fwm_id` from rvw_journal_workflows '.$excludeCnd1.$testingCnd;
			$resultMaster = Generic_flows::get_records_by_raw_query($querySelect);

			if(!empty($resultMaster))
			{
				$maipulateCond = ' ( (jwf_stage_type = "preprocessing" AND jwf_stage_name = "Preprocess for AoP1") OR (jwf_stage_type = "qulity_check" AND jwf_stage_name = "Initiate production") OR (jwf_stage_type = "copy_editing" AND jwf_stage_name = "Copyedit manuscript"))';

				foreach($resultMaster as $item)
				{
					$querySelectM = "Select jwf_id,jwf_stage_name,jwf_stage_type,jwf_assignment,jwf_flow_proceed_type,jwf_parent_stages,jwf_child_stages from rvw_journal_workflows where ".$maipulateCond." AND jwf_fwm_id = ".$item->jwf_fwm_id;
					$resultM = Generic_flows::get_records_by_raw_query($querySelectM);

					if(!empty($resultM))
					{
						$qualityCheck = (object) array();
						$preprocess = (object) array();
						$copyEdit= (object) array();

						foreach($resultM as $itM)
						{
							if($itM->jwf_stage_type == "qulity_check")
							{
								$qualityCheck = $itM;
							}
							elseif($itM->jwf_stage_type == "preprocessing")
							{
								$preprocess = $itM;
							}
							else
							{
								$copyEdit = $itM;
							}
						}

						//MANAGE CHILD
						/**
						 * Initiate production stage child changed. Remove preprocessing id and add copyedit it
						 */
						$qulitychild = ($qualityCheck->jwf_child_stages)?? array();
						$qulitychild = json_decode($qulitychild);
						//echo '<pre>';print_r($qulitychild);
						
						$qualitchId = ($qualityCheck->jwf_id)?? '';

						//for remove
						$preprosId = ($preprocess->jwf_id)?? '';

						//for adding
						$copyeditId = ($copyEdit->jwf_id)?? '';
						$keyRm = array_search($preprosId,$qulitychild);
						
						$qualityUpdate = false;
						if($keyRm !== false)
						{
							unset($qulitychild[$keyRm]);
							$qulitychild = array_unique($qulitychild);
							$qualityUpdate = true;
						}

						if(!empty($copyeditId))
						{
							$qulitychild[] = "$copyeditId";
							$qulitychild = array_unique($qulitychild);
							$qualityUpdate = true;
						}
						//echo json_encode(array_values($qulitychild));
						if(isset($qualityCheck->jwf_id) && !empty($qualityCheck->jwf_id) && $qualityUpdate == true)
						{
							$cond = array(
								'jwf_id' => $qualityCheck->jwf_id
							);
							$data = array(
								'jwf_child_stages' => json_encode(array_values($qulitychild))
							);
							Generic_flows::update_record($data,$cond,$currentUser);

							//******************changes in   rvw_advance_flow_movement*********************** */
							if($qualityCheck->jwf_flow_proceed_type == 'advance')
							{
								$select = 'afm_id,afm_associated_stage_ids,afm_button_title,afm_button_tooltip';
								$moveCnd = 'afm_jwf_id = '.$qualityCheck->jwf_id.' AND afm_fwm_id = '.$item->jwf_fwm_id.' AND find_in_set('.$preprosId.',afm_associated_stage_ids) > 0';
								
								$resultMov = Advance_flow_movement::get_all_records($select,$moveCnd);
								if(!empty($resultMov))
								{
									foreach($resultMov as $movItem)
									{
										$AdvmoveID = $movItem->afm_id;
										$stage_idsexp = explode(',',$movItem->afm_associated_stage_ids);
										$keysg = array_search($preprosId,$stage_idsexp);
						
										$updateAdvmove = false;
										if($keysg !== false)
										{
											unset($stage_idsexp[$keysg]);
											$stage_idsexp = array_unique($stage_idsexp);
											$updateAdvmove = true;
										}
										if(!empty($copyeditId))
										{
											$stage_idsexp[] = $copyeditId;
											$stage_idsexp = array_unique($stage_idsexp);
											$updateAdvmove = true;
										}
										if($updateAdvmove == true)
										{
											$dataAdvmove = array(
												'afm_associated_stage_ids' => implode(",",$stage_idsexp),
												'afm_button_tooltip' => ''
											);
											//echo $AdvmoveID.'<pre>';print_r($dataAdvmove);exit;
											if(isset($copyEdit->jwf_stage_name))
											{
												$buttom_name = str_replace('Preprocessing',$copyEdit->jwf_stage_name,$movItem->afm_button_title);
												$dataAdvmove['afm_button_title'] = $buttom_name;
											}
											$cndAdv = array(
												'afm_id' => $AdvmoveID
											);
											Advance_flow_movement::update_record($dataAdvmove,$cndAdv,$currentUser);
										}
									}
								}
								//echo '<pre>';print_r($resultMov);
							}
							
							//***************************************** */

						}

						//MANAGE PARENT
						$copyeditparents = ($copyEdit->jwf_parent_stages)?? array();
						$copyeditparents = json_decode($copyeditparents);

						$keyRm = array_search($preprosId,$copyeditparents);
						
						//Remove preprocess id from copyedit parent
						$copyeditUpdate = false;
						if($keyRm !== false)
						{
							unset($copyeditparents[$keyRm]);
							$copyeditparents = array_unique($copyeditparents);
							$copyeditUpdate = true;
						}

						//Add quality check id to copy edit parent
						if(!empty($qualitchId))
						{
							$copyeditparents[] = "$qualitchId";
							$copyeditparents = array_unique($copyeditparents);
							$copyeditUpdate = true;
						}

						//echo json_encode(array_values($copyeditparents));
						if(isset($copyEdit->jwf_id) && !empty($copyEdit->jwf_id) && $copyeditUpdate == true)
						{
							$cond = array(
								'jwf_id' => $copyEdit->jwf_id
							);
							$data = array(
								'jwf_parent_stages' => json_encode(array_values($copyeditparents))
							);
							Generic_flows::update_record($data,$cond,$currentUser);
						}

					}
					
				}

				echo "Changed in ".count($resultMaster)." workflow <br>";

				$notworkingWorkflow = "SELECT art_code ,jnl_journal_name ,artp_article_type ,jwf_stage_name ,IF(aflw_status = 'a','In progress','Ready') as status FROM rvw_journal_workflows JOIN rvw_article_flow ON aflw_jwf_id = jwf_id LEFT JOIN rvw_article_types ON jwf_fwm_id = artp_fwm_id LEFT JOIN rvw_journals ON artp_jnl_id = jnl_id LEFT JOIN rvw_articles ON art_id = aflw_art_id WHERE ( (jwf_stage_type = 'aop_publish' AND jwf_stage_name = 'Publish AoP1') OR (jwf_stage_type = 'preprocessing' AND jwf_stage_name = 'Check AoP1') OR (jwf_stage_type = 'editorial_process' AND jwf_stage_name = 'AoP1 correction') OR (jwf_stage_type = 'preprocessing' AND jwf_stage_name = 'Preprocess for AoP1') ) AND aflw_status != 'c'  AND art_delete_status != 'w' GROUP BY jwf_fwm_id, art_code, aflw_id,jnl_journal_name, artp_article_type";
				$results = Generic_flows::get_records_by_raw_query($notworkingWorkflow);
				if(!empty($result) && count($results) >0)
				{
					$i = 0;
					foreach($results as $res)
					{
						$i++;
						echo "{$i}. The {$res->art_code} in {$res->jnl_journal_name} -- {$res->artp_article_type} -- {$res->jwf_stage_name}  with status {$res->status} <br>";
					}
				}
				else
				{
					echo 'All workflow altered';	
				}
			}


			DB::commit();
		}
		catch (\Exception $e)
		{
			print_r($e);exit;
		}
		
		


	}

	public function insert_data_in_all_exist_client_functionality(){
		

		try {
			//DB::beginTransaction();
			
			$current_client = $this->get_client_details();
			$all_client_functl_status = new \App\Models\All_Client_Functionality_Status();
			
		     $app_url=env('APP_URL','');
			
			#$client_config          =   'clients.' . $current_client->clnt_client_code . '.client_configurations.client_functionality';
			$client_config='client_configurations.client_functionality';
			$clnt_functionalities   =   Config::get($client_config);

            (new SudoManagementApi)->data_insert_update_client_all_clients($current_client);

			(new SudoManagementApi)->data_insert_update_client_url($current_client);
            foreach($clnt_functionalities as $functionality=>$status)
			{
            (new SudoManagementApi)->data_insert_client_functionality($functionality,$status);
			}
			$client_functionalities_db =(new Client_functionalities())->get_all_records_with_bind_cond('*',array("cfty_clnt_id"=>$current_client->clnt_id));
			
			$client_data=(new All_Clients())->get_single_record_with_bind_cond("*",array("acls_client_code"=>$current_client->clnt_client_code));
			$client_url_data=(new All_Client_Url())->get_single_record_with_bind_cond('*',array("clu_acls_id"=>$client_data->acls_id,'clu_url'=>$app_url));
				
			if(!empty($client_functionalities_db))
			{
				
				foreach($client_functionalities_db as $client_fun_db)
				{
					(new SudoManagementApi)->save_client_functionality_status($client_fun_db->cfty_functionality,$client_fun_db->cfty_status,$client_data,$client_url_data);
					
				
		    	}
			}
		    
			//DB::commit();
		} catch (Exception $e) {
		
			DB::rollBack();
			Log::warning("Error in insrt data into all_clients table");
			Log::warning($e);
			return $e;
		}

	}
/* module functionality update all client based */
	public function all_module_functionality_update()
	{

		try {
			//DB::beginTransaction();
			
			$current_client = $this->get_client_details();
			$client_id=$current_client->clnt_id;
			$mdl_db = Modules::get_single_record_with_bind_cond('*',['mdl_clnt_id'=>$client_id]);
			
			if(!empty($mdl_db)) {
				$mdl_db_arr = [];
				//setting only the required modules from the db in the array.
				foreach ($mdl_db as $column => $value) {
					// Check if the value is 'y' or 'n'
					if ($value === 'y' || $value === 'n') {
						$mdl_db_arr[$column] = $value;
					}
				}
				//sorting both arrays for comparing.
				ksort($mdl_db_arr);
				
			}
		     $app_url=env('APP_URL','');
            (new SudoManagementApi)->data_insert_update_client_all_clients($current_client);
			(new SudoManagementApi)->data_insert_update_client_url($current_client);
			foreach($mdl_db_arr as $module=>$value)
			{
			(new Sudo_Manage_Modules_Api)->save_client_module_common($module,$value,$current_client->clnt_client_code);
			}
		    
			//DB::commit();
		} catch (Exception $e) {
		
			DB::rollBack();
			Log::warning("Error in insrt data into all_clients table");
			Log::warning($e);
			return $e;
		}

	}
	public function insert_missing_tab_status_entries()
	{
		try {
			DB::enableQueryLog();
			
			$Article_tab_status = new \App\Models\Article_tab_status();
			$default_tab_status_array = json_encode([
				"tab_article_details" => "p",
				"tab_co_author" => "",
				"tab_attach_files" => "",
				"tab_review_preference" => "",
				"tab_payment_info" => "",
				"tab_additional_info" => ""
			]);
	
			$posted_date = date('Y-m-d H:i:s');
			$proxy_id = 0;
			$operation = 'i';
	
			$missing_articles = DB::select("
				SELECT art_id,art_submitted_by
				FROM rvw_articles 
				LEFT JOIN rvw_article_submission_tab_status 
				  ON rvw_articles.art_id = rvw_article_submission_tab_status.tab_status_art_id
				WHERE rvw_article_submission_tab_status.tab_status_art_id IS NULL 
				  AND rvw_articles.art_stage_submission_method = 'b';
			");
			if (!empty($missing_articles)) {
			foreach ($missing_articles as $article) {
				DB::insert("
					INSERT INTO rvw_article_submission_tab_status 
						(tab_status_art_id, tab_status_array, tab_status_posted_by, tab_status_posted_date, tab_status_proxy_id, tab_status_operation)
					VALUES (?, ?, ?, ?, ?, ?);
				", [
					$article->art_id,
					$default_tab_status_array,
					$article->art_submitted_by,
					$posted_date,
					$proxy_id,
					$operation
				]);
			}
		}
		    
				return true;
			
	       
		} catch (\Throwable $th) {
			return false;
		}
	}
	public function update_submit_for_production_permission()
	{
		try {
			if (
				isset($this->current_client->functionality->cfty_enable_submit_production_article) &&
				$this->current_client->functionality->cfty_enable_submit_production_article === 'y'
			) {
				$Roles = new \App\Models\Roles();
				$role_list = $Roles::get_single_record('GROUP_CONCAT(role_id) as role_ids','role_assigned_role IN ("staff", "journal_admin")');
				$role_ids = $role_list->role_ids;
				$role_ids = explode(',', $role_ids);
				$json_role_ids = json_encode($role_ids);
				$update_data = ['jset_manage_production_article' => $json_role_ids];
				$criteria = 'jset_manage_production_article IS NULL';
				Journal_settings::update_record($update_data, $criteria);
				return true;
			}
		} catch (\Throwable $th) {
			return false;
		}
	}
	public function update_drafted_by_from_tbk_articles()
{
    try {
        // Step 1: Get rvw_articles needing update
        $articles = \DB::select("
            SELECT ra.art_id
            FROM rvw_articles ra
            WHERE ra.art_drafted_by IS NULL
              AND ra.art_stage_submission_method IN ('z','n')
        ");

        if (empty($articles)) {
            return true; // nothing to update
        }

        // Step 2: Loop & update each with tbk_id ASC (first entry)
        foreach ($articles as $article) {
            $firstPostedBy = \DB::selectOne("
                SELECT art_posted_by
                FROM tbk_articles
                WHERE art_id = ?
                  AND art_posted_by IS NOT NULL
                ORDER BY tbk_id ASC
                LIMIT 1
            ", [$article->art_id]);

            if ($firstPostedBy && $firstPostedBy->art_posted_by) {
                \DB::update("
                    UPDATE rvw_articles
                    SET art_drafted_by = ?
                    WHERE art_id = ?
                      AND art_drafted_by IS NULL
                ", [$firstPostedBy->art_posted_by, $article->art_id]);
            }
        }

        return true;
    } catch (\Throwable $th) {
        // log if needed
        return false;
    }
}

	/*
	* Task #3027 Article numbering in <abstract_number> tag in xml
	* This function will update the articles with article number only if the client func 'cfty_article_numbering' is ON
	*/
	public function assign_article_number() 
	{
		try {
			if(isset($this->current_client->functionality->cfty_article_numbering) && $this->current_client->functionality->cfty_article_numbering == 'y')
			{
				$jnl_details 	= Journals::get_all_records('jnl_id, jnl_journal_name', 'jnl_journal_status="y" and jnl_standalone="n"');
				if (!empty($jnl_details)) {
					$str 	=	'';
					foreach ($jnl_details as $jn) {
						// task #3027-1 AND art_delete_status = 'n'
						$sql 	=	"SELECT
										art_id,
										art_code,
										art_proposal_method,
										art_title,
										art_status,
										artp_article_type,
										art_chapter_order
									FROM
										`rvw_articles`
									LEFT JOIN `rvw_article_flow` AS `fl1` ON `art_id` = `fl1`.`aflw_art_id`
									LEFT JOIN `rvw_article_types` ON `art_artp_id` = `artp_id`
									LEFT JOIN `rvw_journals` ON `artp_jnl_id` = `jnl_id`
									LEFT JOIN `rvw_journal_workflows` ON `aflw_jwf_id` = `jwf_id`
									WHERE
										jnl_id = $jn->jnl_id AND art_stage_submission_method = 'b' AND fl1.aflw_id =(
										SELECT
											MAX(aflw_id)
										FROM
											rvw_article_flow AS fl2
										WHERE
											fl2.aflw_art_id = fl1.aflw_art_id
									) AND(
										`art_status` IN('n', 'a', 'r', 't', 'y') OR(
											CASE WHEN art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art_status = 'n' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'a'
										END
									))
										ORDER BY `art_id` ASC";
						
						$results = Journals::get_records_by_raw_query($sql);
						if (!empty($results)) {
							$order 	=	1;
							$str .= '</br></br>Journal :'.$jn->jnl_journal_name.'</br>';
							foreach ($results as $rs) {
								Articles::execute_query("UPDATE `rvw_articles` SET `art_chapter_order` = ".$order." WHERE art_id =".$rs->art_id);
								$str .= 'Order number is '.$order.' for the article '.$rs->art_code.'</br>';
								$order++;
							}
						}
					}
					if($str == "")
					{
						echo "No articles found";
						exit;
					}
					else
					{
						echo $str;
						exit;
					}
				} else {
					echo "No journals found";
					exit;
				}
			} 
			else {
				echo "Please switch ON cfty_article_numbering functionality.";exit;
			}
		} catch (\Exception $e) {
			DB::rollback();
			print_r($e);exit;
		}
	}

	/*
	* Task #3791 No edit, attachments, and re-order for Organizer
	*/
	public function organizer_and_cpteammember_events() {
		try {
			$is_proceeding=$this->check_client_proceeding();
			if($is_proceeding == true) {
				$res 	= '';
				$events_table = (new \App\Models\Events_model())->getTable();
				$event_invtd_table = (new \App\Models\Event_invited_users())->getTable();

				//insert two new records in events table
				$evnt_name1 	=	'Notify organizers';
				$sel_sql1		=	"SELECT event_id FROM ".$events_table." WHERE event_name='".$evnt_name1."'";
				$results1 		= 	Events_model::get_records_by_raw_query($sel_sql1);
				if (empty($results1)) {
					$sql1 	= "INSERT into " . $events_table . " (event_id,event_name,event_due_date,event_type,event_posted_by,event_posted_date,event_proxy_id,event_operation) 
								VALUES (NULL, '".$evnt_name1."', '".date('Y-m-d H:i:s')."', 'c', 1, '".date('Y-m-d H:i:s')."', 0, 'i') ";
					if(DB::select($sql1)) {
						$res 	.= "Added event records for notifying organizers";
					}

					$update_sql = "UPDATE ".$event_invtd_table." SET `evu_event_id` = (SELECT event_id FROM ".$events_table." WHERE event_name='".$evnt_name1."')";
					if(DB::select($update_sql)) {
						$res 	.= "<br/>Updated invited records with notifying organizer's evengt id";
					}
				}

				$evnt_name2 	=	'Notify cp_team_members';
				$sel_sql2		=	"SELECT event_id FROM ".$events_table." WHERE event_name='".$evnt_name2."'";
				$results2 		= 	Events_model::get_records_by_raw_query($sel_sql2);
				if (empty($results2)) {
					$sql2 	= "INSERT into " . $events_table . " (event_id,event_name,event_due_date,event_type,event_posted_by,event_posted_date,event_proxy_id,event_operation) 
								VALUES (NULL, '".$evnt_name2."', '".date('Y-m-d H:i:s')."', 'c', 1, '".date('Y-m-d H:i:s')."', 0, 'i') ";
					if(DB::select($sql2)) {
						$res 	.= "<br/><br/>Added event records for cp_team_members";
					}
				}

				echo $res;exit;
			}
		} catch (\Exception $e) {
			DB::rollback();
			print_r($e);exit;
		}

	}


}
