<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Articles;
use App\Models\Generic_flows;
use App\Models\Journal_settings;
use App\Models\Article_flow;
use App\Models\Roles;
use \Mpdf\Mpdf as PDF;
use Response;
use File;
use App\Models\Journals;
use Config;
use Illuminate\Support\Facades\Http;


class Download_Review_Api extends Controller
{
   
      public function get_download_data(Request $request)
      {
        try{
        $post_data = $request->all();
        $validator = Validator::make($request->all(), [
            'art_id' => 'required',
            'art_flow_id' => 'required',
            'jnl_id' => 'required',
            'jnlcode' => 'required'
        ]);
        if ($validator->fails()) {
          return  $this->failure('Failed', 422, $validator->errors());
      }
      
        $art_id = isset($post_data['art_id']) ?  decrypt_link($post_data['art_id']) : '';
        $art_flow_id = isset($post_data['art_flow_id']) ?  decrypt_link($post_data['art_flow_id']):'';
        $jnlcode = isset($post_data['jnlcode']) ? decrypt_link($post_data['jnlcode']) : '';
        //$roleid = isset($post_data['roleid']) ? Rv_decrypt($post_data['roleid']) : '';
        $platform_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
        $this->current_user = $this->get_current_user_details();
        $join_table = '';
        $cvr_data = array();
        $articleflow_table = (new \App\Models\Article_flow)->getTable();;
        $Generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $Journal_settings = new \App\Models\Journal_settings;
        $Journal = new \App\Models\Journals;
        $condition = "art_id=:mainart_id";
        $condition_arr=array(
            'mainart_id' => $art_id);
          //DB::enableQueryLog();
          $article_data = Articles::get_article_details('artp_jpm_id,art_title,artp_id,art_version_no,art_id,artp_fwm_id,art_status,aflw_parent_flow_id,jwf_stage_type,art_code,art_delete_status,aflw_status,artp_article_type', $condition, NULL, TRUE, FALSE,NULL,$condition_arr);
         //$query = DB::getQueryLog();$query = end($query);dd($query);
         $article_data = $article_data[0];
         $cvr_data['art_code'] =  $article_data->art_code;
         $article_privilages = $this->article_privilages($article_data, NULL,$jnlcode);
         $cvr_data['art_title'] =$article_data->art_title;
         $cvr_data['article_type'] =$article_data->artp_article_type;
         $all_user_roles = $this->validate_user_journal($jnlcode,$this->current_user['user_id'] , $article_data->artp_id);
         $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
         $user_array = array();
         $user_array['user_roles'] = $all_user_roles;
         $user_array['article_id'] = $art_id;
         $user_array['all_roles'] = $all_roles;
         $user_array['article_privilages'] = $article_privilages;
         $user_array['jnl_id'] = $platform_id;
         $user_roles = $this->get_article_user_roles($user_array);
         //$data = array();
         
        //$join_table = '(SELECT IF(aflw_parent_flow_id IS NOT NULL,aflw_parent_flow_id,aflw_id) as id from ' . $articleflow_table . ',rvw_article_gnf_form_data_' . $jnlcode . ',' . $Generic_forms_table;
        //$join_table .= ' where aflw_id = gdata_artflw_id AND gncf_id = gdata_atf_id AND aflw_status IN (\'w\',\'c\') AND gdata_art_id = "' . $art_id . '"  AND CASE WHEN FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN TRUE WHEN FIND_IN_SET("' . $author_role_id . '",gdata_user_roles)> 0 THEN TRUE END ) as tb1';


        $journal_name = $Journal::get_single_record('jnl_journal_name,jnl_logo', "jnl_id = '{$platform_id}' ");
         $cvr_data['journal_name'] = $journal_name->jnl_journal_name;
         $cvr_data['jnl_logo']=$journal_name->jnl_logo;
        $jnl_date_format = $Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$platform_id}' ")->jset_date_format;
        $date_format = $this->date_format_map($jnl_date_format);
        $group_by = ' aflw_posted_date,aflw_jwf_id';
        $criteria = ' aflw_art_id =' .$art_id.' AND jwf_stage_type ="review" AND aflw_parent_flow_id IS NULL';
        $flowdetails = Article_flow::getcompletedstages('aflw_stage_repeat_count,jwf_stage_type,jwf_stage_name,aflw_id,aflw_jwf_id,aflw_status,jwf_tab_name,jwf_no_of_min_users,jwf_no_of_max_users,jwf_reviewers_discuss_forum,jwf_parent_user_roles,jwf_who_can_invite,aflw_stage_min_users,jwf_role_id,aflw_parent_flow_id,jwf_reviewers_discuss_forum,jwf_forms,aflw_skip_assignment,aflw_usr_id,DATE_FORMAT(aflw_returned_date, "' . $date_format . ' ") as returned_date,jwf_assignment,aflw_skip_review,aflw_more_review_skip_status,aflw_bypassed_status,aflw_art_id,atotp_review_method,aflw_posted_date,aflw_posted_by,artp_id,art_id,artp_fwm_id,jwf_child_stages,jwf_flow_proceed_type,aflw_level,art_delete_status,jwf_status_name,aflw_stage_max_users,jwf_fwm_id,aflw_returned_date', $criteria, $group_by,'','','review');
        if(!empty($flowdetails))
         {
           foreach($flowdetails as $flow)
           { 
             $count = 0;
            $completedformreviewarr = array();
            $select = 'distinct aflw_id,aflw_art_id,aflw_status,aflw_usr_id,jwf_stage_type,aflw_posted_by,aflw_remarks';
            $art_flw_criteria = "aflw_parent_flow_id={$flow->aflw_id} and aflw_status in ('c')";
            $art_flw_tables = array(
              'main_table' => $articleflow_table,
              'join_table' => array(
                $Generic_flow_table => array($articleflow_table . '.aflw_jwf_id', $Generic_flow_table . '.jwf_id'),
              'rvw_article_gnf_form_data_'.$jnlcode => array('rvw_article_gnf_form_data_'.$jnlcode. '.gdata_artflw_id',$articleflow_table .'.aflw_id', "left"),
              )
          );
            $article_flow_dets = Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'all', 'gdata_data_order,gdata_posted_date asc', NULL, '', NULL, NULL, TRUE);

            if (count($article_flow_dets)>0) { 
              $cnt =1;              
              foreach ($article_flow_dets as $usra) {
                $count++;
                $reviewer_name ="Reviewer #" . $count ;
                $flow->userflow=$usra->aflw_id;

            $formatted_journal_code = '_' . $jnlcode;
            $user_roles_form=$user_roles["role_id"];
            $author_key=array_search("author",$user_roles["assigned_roles"]);
            if($author_key !== false && $author_key >= 0)
            {
                unset($user_roles_form[$author_key]);
            }
            $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
            $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
            /* Taskbot Task-1540 - PDF Download Shows Unauthorized Custom Form Fields in "Download All Reviews" */
            $form_select ="CASE WHEN emt_hideafterstage IS NULL THEN (SELECT emt_hideafterstage FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='label' order by tbk_id DESC limit 1) ELSE emt_hideafterstage END AS emt_hideafterstage, CASE WHEN emt_element_type IS NULL THEN (SELECT emt_element_type FROM tbk_generic_form_elements WHERE emt_id=gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date <=gdata_posted_date order by tbk_id DESC limit 1) ELSE emt_element_type END AS emt_element_type, CASE WHEN emt_tinymce_required IS NULL THEN (SELECT emt_tinymce_required FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='textarea' order by tbk_id DESC limit 1) ELSE emt_tinymce_required END AS emt_tinymce_required,";
            $form_select .= 'gdata_art_id,gdata_gform_title,gdata_group_name,gdata_label,gdata_user_roles,gdata_element_type,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_atf_id,gdata_artflw_id,gdata_posted_by,gdata_gfg_id,gncf_form_type,gncf_user_roles,gncf_posted_by,gncf_form_privilege_usr_edit';
            $where = ' gdata_artflw_id =  ' . $usra->aflw_id . ' AND gdata_art_id = ' . $usra->aflw_art_id; 
            $where .= ' and CASE WHEN gncf_user_roles IS NULL THEN TRUE WHEN gncf_user_roles = "[]" THEN TRUE WHEN FIND_array_intersect(REPLACE(REPLACE(REPLACE(gncf_user_roles,\']\',\'\'),\'[\',\'\'),\'"\',\'\'), "'.implode(",",$user_roles_form).'") >0 THEN TRUE WHEN gdata_posted_by =' . $this->current_user["user_id"].' THEN TRUE END';
            $details_tables = array(
              'main_table' => 'rvw_article_gnf_form_data_'.$jnlcode,
              'join_table' => array(
                  $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data_' .$jnlcode. '.gdata_atf_id'),
                  $Generic_form_elements_table => array('rvw_article_gnf_form_data_' .$jnlcode. '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id'),
                  )
          );
         // DB::enableQueryLog();
            $reviewforms = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', 'gdata_data_order,gdata_posted_date asc', NULL, '', NULL, NULL, TRUE);
            //$query = DB::getQueryLog();$query = end($query);dd($query);
            if (!empty($reviewforms) && count($reviewforms) > 0) {
              $review_forms_count=count($reviewforms);
              
              foreach ($reviewforms as $val => $rvfrm) {
                /* Taskbot Task-1540 - PDF Download Shows Unauthorized Custom Form Fields in Download All Reviews */
                if($rvfrm->emt_hideafterstage=='y') {
                  continue;
                }

                $gncf_user_roles = json_decode($rvfrm->gncf_user_roles);
                if (!empty($gncf_user_roles) && $rvfrm->gdata_posted_by != $this->current_user["user_id"]) {
                  foreach ($user_roles['role_id'] as $ri) {
                      if (in_array($ri, $gncf_user_roles)) {
                          $reviewpermission_form = TRUE;
                          break;
                      }
                  }
              } elseif ($rvfrm->gdata_posted_by == $this->current_user["user_id"] || empty($gncf_user_roles)) {
                  $reviewpermission_form = TRUE;
              }
              $order=$rvfrm->gdata_data_order;
                if(empty($order)){
                    $order=$review_forms_count++;
                }
                if(!empty($rvfrm->gdata_user_roles) && isset($user_roles['role_id']) && $this->current_user['user_id'] != $rvfrm->gdata_posted_by) {
                  $emt_viewable_rls = explode(',', $rvfrm->gdata_user_roles);
                  if(count(array_intersect($user_roles['role_id'], $emt_viewable_rls)) == 0) {
                      $rvfrm->element_viewstatus=FALSE;
                      continue;
                  }
              }

             /* review ratings */

             $Review_rating = new \App\Models\Review_rating;
             $reviewer_rating_all = '';
            // DB::enableQueryLog();
             $review_rate = $Review_rating::get_all_records('ROUND(AVG(rvr_rating), 2) as rvr_rating,rvr_five_star', "rvr_aflw_id={$rvfrm->gdata_artflw_id} and rvr_reviewer_id={$usra->aflw_usr_id} ");
             //$query = DB::getQueryLog();$query = end($query);print_r($query);

             $completedformreviewarr['flow'.$usra->aflw_id]['review_rating_enabled'] = TRUE;
             $completedformreviewarr['flow'.$usra->aflw_id]['five_star'] = FALSE;
             if(count($review_rate) == 1 && $review_rate[0]->rvr_five_star == 'y')
              {
                $reviewer_rating_all = $review_rate[0]->rvr_rating;
                $completedformreviewarr['flow'.$usra->aflw_id]['five_star'] = TRUE;
                }
                else
                {
                  $rating_result = $Review_rating::get_single_record('sum(rvr_rating) as reviewer_rating', "rvr_aflw_id={$rvfrm->gdata_artflw_id} and rvr_reviewer_id={$usra->aflw_usr_id} and rvr_rated_by={$this->current_user['user_id']} ");
                  $reviewer_rating_all = $rating_result->reviewer_rating / 2;
                }
                $completedformreviewarr['flow'.$usra->aflw_id]['reviewer_rating'] = '';
								if ($reviewer_rating_all !== '')
								{
                                    //$stage_head[$fr->$field]['reviewer_rating'] = $rating_result->reviewer_rating;
									$completedformreviewarr['flow'.$usra->aflw_id]['reviewer_rating'] = $reviewer_rating_all;
                }

             /* review ratings */
             
              $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['form_title'] = $rvfrm->gdata_gform_title;
              $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['permission_form'] = $reviewpermission_form; 
              $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['cnt'] = $order;
              $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id][$order]= $rvfrm; 

              $completedformreviewarr['flow'.$usra->aflw_id]['title'] = $reviewer_name ;
              }
          
            }

            }

          } 
          $flow->review_childstages = $completedformreviewarr;
          //$data['review_childstages'] = $completedformreviewarr;
           }
           $data['flowdetails'] = $flowdetails;
         }
         $cvr_data['article_code'] = $article_data->art_code;
         $cvr_data['jnlcode'] = $jnlcode;
         if(file_exists(public_path().'/img/Half_Star.png'))
         {
          $data['half_star']= public_path().'/img/Half_Star.png';
         }
         if(file_exists(public_path().'/img/Full-star.png'))
         {
          $data['star_on']= public_path().'/img/Full-star.png';
         }
         if(file_exists(public_path().'/img/Star-off.png'))
         {
          $data['star_off']= public_path().'/img/Star-off.png';
         }
        
         //$path = public_path().'/storage/uploads/'.$jnlcode.'/';
         $rw_pdf_path = public_path().'/storage/uploads/'.$jnlcode.'/review_pdf'; 
         if (!file_exists($rw_pdf_path)) {
          mkdir($rw_pdf_path, 0765, TRUE);
          }
          $filepath =  $rw_pdf_path.'/'.$article_data->art_id;

          if (!file_exists($filepath)) {
            mkdir($filepath, 0765, TRUE);
            }
            
         $cover_page = $this->cover_page($cvr_data,$filepath);
         $merge_file_array[0] = array(
            'file_name' => $cover_page,
            'file_path' => $filepath,
            'original_file_name' => $cover_page,
            'file_id' => 0,
            'file_ext' => 'pdf'
          ); 
          
        //  if (!file_exists($path)) {
        //   mkdir($path, 0765, TRUE);
        //   }
         $document = new PDF( [
          'mode' => 'utf-8',
          'format' => 'A4',
          'margin_header' => '3',
          'margin_top' => '20',
          'margin_bottom' => '20',
          'margin_footer' => '2',
        ]);     
         $result['content_view'] = view('template.tmpl_pdf_rw_download')->with($data);
         $document->WriteHTML($result['content_view']);
         $filename = $article_data->art_code.'.pdf';
         $document->Output( $filepath.'/'.$filename, 'F');

         $merge_file_array[1] = array(
          'file_name' => $filename,
          'file_path' =>  $filepath,
          'original_file_name' => $filename,
          'file_id' => 1,
          'file_ext' => 'pdf'
        ); 
         $short_path = $jnlcode.'/review_pdf/'.$article_data->art_id;
         $combined_pdf = $this->reviewpdf_combine($merge_file_array, $article_data,$short_path,$jnlcode);

          $return_array= array(
           'filepath'=>$filename
         );
          return  $this->success('Success',200,$return_array);

      }
      catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
      }
      }
      
      public function download_review_as_pdf($filepath)
      {
        try{
       
         $filepath = json_decode($filepath);
         $jnlcode = decrypt_link($filepath->jnlcode);
         $art_id = decrypt_link($filepath->art_id);
         $dwnld_file =  storage_path().'/app/public/uploads/'.$jnlcode.'/review_pdf/'.$art_id.'/'.$filepath->path;
        //$dwnld_file = $this->upload_folder_path("uploads/".$jnlcode."/review_pdf/".$art_id."/".$filepath->path);	
        //$dwnld_file = $this->upload_folder_path("uploads/".$jnlcode."/".$filepath->path);	
        if(file_exists($dwnld_file))
        {
          return Response::download($dwnld_file);
        }
          else
					{
						$this->warning('Failed',500,'file not exist');
					}
      }
      catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
          }


      }


  public function cover_page($cvr_data,$filepath)
  {
  try{
 
    $coverd = array();
   $journalData = Journals::get_single_record('jnl_id,jnl_journal_name,jnl_logo,jnl_journal_code',"jnl_journal_code='{$cvr_data['jnlcode']}'");
  $coverdata['journal'] = $journalData->jnl_journal_name;
  $coverdata['article_title'] =  $cvr_data['art_title'];
  $coverdata['article_type'] = $cvr_data['article_type'];
   $coverdata['article_code'] = $cvr_data['art_code'];
   $coverdata['article_submitted'] = NULL;
   //$coverdata['update_last_date'] = '';
   $coverdata['article_authors']='';
   $coverdata['article_keywords']= '';
   $document = new PDF( [
  'mode' => 'utf-8',
  'format' => 'A4',
  'margin_header' => '3',
  'margin_top' => '20',
  'margin_bottom' => '20',
  'margin_footer' => '2',
]);
   $data = array();
   $data['page_type'] = 'front';
   $data['coverdata'] = $coverdata;
   $data['jnl_data']= $journalData;
   /*  date today */
   $jnl_date_format = $this->get_platform_date_format($journalData->jnl_id);
   $today = date('Y-m-d H:i:s');
   $currentdate = date($jnl_date_format,strtotime($today));
   $data['currentdate'] = $currentdate;
/*  date today */
   $client_functionality =  $this->get_client_functionalities($this->current_client->clnt_id, $this->current_client->clnt_client_code);

   $data['review_logo']= public_path().'/img/rvt-logo.png';
   $folder_path=public_path().'/storage/uploads/'.$journalData->jnl_journal_code.'/thumb_'.$journalData->jnl_logo;
   $data['folder_file_exist']=FALSE;
    if (file_exists($folder_path)) {

     $data['folder_file_exist']=TRUE;
 }
  $logo_path='uploads/'.$cvr_data['jnlcode'].'/thumb_'.$cvr_data['jnl_logo'];
  // $path = public_path().'/storage/uploads/'.$cvr_data['jnlcode'].'/';
  // if (!file_exists($path)) {
  //   mkdir($path, 0765, TRUE);
  //   }
 $data['jnl_logo']=$this->get_upload_path($logo_path);
 $data['content_view'] = view('template.tmpl_pdf_pages')->with($data);
 $document->WriteHTML($data['content_view']);
 $document->Output($filepath.'/rw_cover_page.pdf', 'F');
return 'rw_cover_page.pdf';
}
catch (\Exception $e) {
  
      return  $this->failure('Failed', 500, $e);
    }
   }

 public function reviewpdf_combine($file_arr, $article_data, $path,$jnlcode)
 {


  $usepackage_pax             =   '';
  $platform_data=$this->platform_basic_settings_data($jnlcode);
  $pdf_journal_title = $platform_data->jnl_journal_name;
  $pdffooter = 'clients.' . $this->current_client->clnt_client_code . '.pdf.pdf_footer';
  $footer_text  = '';
  $pdf_article_title =$this->replace_latexspecialchars($article_data->art_title);
  $pdf_settings=Config::get('pdf.pdf_settings');
  $pdflatex = $pdf_settings['PDFLATEX'];

		$pdf_article_code = $this->replace_latexspecialchars($article_data->art_code);
    $new_pdf_filename = $article_data->art_code;
		//$pdf_article_type =$article_type;
		$pdf_rvt_logo_path = public_path()."/images/rvt-logo.png";
    $template_file_join= 'uploads/'.$path.'/join_template.tex';
    if (file_exists($template_file_join))
			unlink($template_file_join);

 $join_template_file_content = '\documentclass[8pt,a4paper]{article}
 \usepackage{grffile}
 \usepackage[final]{pdfpages}
 \usepackage[left=1cm, right=1cm, top=2cm, bottom=2cm]{geometry}
 \usepackage[yyyymmdd,hhmmss]{datetime}
 \usepackage{pgffor}
 \usepackage{titleps}
 \usepackage{graphicx}
 '.$usepackage_pax.'
 \usepackage[utf8x]{inputenc}
 \usepackage[yyyymmdd,hhmmss]{datetime}%\
 \usepackage[export]{adjustbox}
 \usepackage{epstopdf}
 \epstopdfDeclareGraphicsRule{.tif}{png}{.png}{convert #1 \OutputFile}
 \AppendGraphicsExtensions{.tif}
 
 \usepackage{tcolorbox}% http://ctan.org/pkg/tcolorbox
 \definecolor{mycolor}{rgb}{0.122, 0.435, 0.698}% Rule colour
 \makeatletter
 \usepackage[export]{adjustbox}
 %\newcommand{\mybox}[1]{%
 %  \setbox0=\hbox{#1}%
 %  \setlength{\@tempdima}{\dimexpr\wd0+13pt}%
 %  \begin{tcolorbox}[colframe=mycolor,boxrule=0.5pt,arc=4pt,
 %      left=6pt,right=6pt,top=6pt,bottom=6pt,boxsep=0pt,width=\@tempdima]
 %    #1
 %  \end{tcolorbox}
 %}
 
 \newpagestyle{main}{%
 \setheadrule{0.4pt}
 \sethead{\itshape\sffamily Auto-generated PDF by ReView}{}{\sffamily\itshape '. $pdf_journal_title .'}
 \setfootrule{0.4pt}
 %\setfoot{\itshape\sffamily\today\ \currenttime}{\itshape\sffamily ' . escapeshellcmd($footer_text) . '}{\sffamily\itshape\thepage}
 \setfoot{\itshape\sffamily\scriptsize\ \name}{\itshape\sffamily ' . escapeshellcmd($footer_text) . '}{\sffamily\itshape\thepage}
 %Uncomment following line to set the label
 %\begin{picture}(0, 0)\put(-30,10){{\large\bfseries\name}}\end{picture}
 %\begin{picture}(0, 0)\put(-43,10){\fboxsep=3pt\mybox{{\normalsize\bfseries\name}}}\end{picture}
 }
 \def\xincludepdf[#1]#2[#3]{\gdef\name{#3}\includepdf[#1]{#2}}
 
 \begin{document}
 ';
 //ksort($file_array);
 foreach($file_arr as $filedetail)
 {
  $file_path =$filedetail['file_path'];
  $page_style = $filedetail['file_id'] == '0' ? '\thispagestyle{empty}':'\thispagestyle{main}';
   $join_template_file_content .= '\xincludepdf[width=\textwidth,keepaspectratio,pages=-,pagecommand={'.$page_style.'}]{' .$file_path.'/'.$filedetail['file_name']. '}['. escapeshellcmd($filedetail['original_file_name']).']';
  
 }
 $join_template_file_content .= '\end{document}';
 $this->upload_file_content($template_file_join, $join_template_file_content);
 $temp_join_file_path = storage_path().'/app/public/uploads/'.$path.'/'.$new_pdf_filename . '/';
 $storagepath=public_path()."/storage/uploads/".$path.'/';

 if(!file_exists($temp_join_file_path))
    File::makeDirectory($temp_join_file_path,$mode = 0777, true, true);
    chdir($storagepath);
    /* Taskbot Task - 1540 Fix completed review PDF Download Issue During Local Dockerization Setup */
    $tex_compiler = env('TEX_COMPILER', 'local');
    if($tex_compiler == 'local'){
      $output = shell_exec($pdflatex . ' -output-directory=' . $temp_join_file_path . ' -jobname=' . $new_pdf_filename . ' -interaction=nonstopmode -shell-escape join_template.tex');
    }elseif($tex_compiler == 'docker'){
      $base_path = base_path();
      $output = shell_exec("$base_path/latex-script.sh PDFLATEX $new_pdf_filename");
    }elseif($tex_compiler == 'microservice'){
          $tex_host = config('general_config.tex_host');
          $tex_port = config('general_config.tex_port');
          $response = Http::post("http://$tex_host:$tex_port/execute", [
        'command' => 'pdflatex -output-directory=' . $temp_join_file_path . ' -jobname=' . $new_pdf_filename . ' -interaction=nonstopmode -shell-escape join_template.tex',
        'working_dir' => $storagepath
      ]);
    }
    
    if (file_exists($temp_join_file_path . $new_pdf_filename . '.pdf'))
		{
			rename($temp_join_file_path . $new_pdf_filename . '.pdf', $storagepath . $new_pdf_filename . '.pdf');
		}
    $return_array['filename']=$new_pdf_filename . '.pdf';

 }

}
            