<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Journals;

use App\Models\User;

use App\Http\Traits\PlatformTrait;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Models\User_journal_preference;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Config;
class Manage_Home_List_Api extends Controller
{
	use PlatformTrait;
	use UtilityTrait;
	use RolesConfigTrait;
	public $current_user;
	//
	/*
    get all platform
    commited date :-  13-03-2022
    Request type :- POST
    */
	public function index(Request $request)
	{

		try {
					$return_data=array();
					$this->current_user = $this->get_current_user_details();
					$User_to_journals =  new \App\Models\User_to_journals;
					$Article_types=new \App\Models\Article_types;
					$User_journal_preference=new \App\Models\User_journal_preference;
					$Journals=new \App\Models\Journals;
					/* standalone journal  get all user from Authorrize table(jwt)*/
					$user = auth()->user();
					$standalone_journal_id = $user->usr_jnl_standalone;
					$standalone_group = Journals::find($standalone_journal_id)?->jnl_standalone_group;
					$criteria = array(
						'jnl_journal_status' => 'y',
						'jnl_standalone' => 'n'
					);
					if ($standalone_journal_id != null && session('group') == $standalone_group) {
						$criteria="jnl_journal_status='y' AND jnl_id={$standalone_journal_id}";
					}
					else
					{
						$criteria="jnl_journal_status='y' AND jnl_standalone='n'";
					}

					$all_platforms = Journals::get_all_records('*', $criteria, NULL, NULL, '', NULL, 'jnl_journal_type');
					$admin_journal_array = array();
					if($standalone_journal_id != null && session('group') == $standalone_group){
						$admin_journals = array();
					}else{
					$admin_journals = $User_to_journals::get_journals_by_role($this->current_user["user_id"], array(
						'journal_admin'));
					}
					$journal_user_roles =$User_to_journals::get_user_roles($this->current_user['user_id'], '', '');
					$jrnl_role_arr = array();
					if(!empty($journal_user_roles))
					{
					foreach ($journal_user_roles as $jrole) {
						if ($jrole->role_assigned_role != 'journal_admin') {
							$jrnl_role_arr[] = $jrole->role_assigned_role;
						}
					}
		  			}
					if(!empty($admin_journals))
					{
					foreach ($admin_journals as $value) {
						$condition="jnl_journal_status='y' AND jnl_id={$value->usrj_jnl_id}";
						$active_journals = $Journals::get_single_record('jnl_id', $condition); // check active journal
						if ($active_journals != NULL)
							$admin_journal_array[] = $value->usrj_jnl_id;
					}
				}
				$valid_jnl_array=array();
				$exclude        =array();
				$manage_roles=$this->convert_string_array($this->current_user['roles']);

				if(!in_array('super_admin', $manage_roles))
				{
				/* CHeck valid Journal*/
				if(!empty($all_platforms))
				{

					foreach ($all_platforms as $jnl)
					{
					

							if( isset($this->current_client->modules->mdl_review_for_doc)&&$this->current_client->modules->mdl_review_for_doc == 'y')
						{
							$val_artp_conditiion = ' artp_jnl_id = '.$jnl->jnl_id.' AND atotp_paper_length IS NOT NULL AND  atotp_review_method != \'\' AND atotp_file_type != \'\' AND jwf_stage_type IN (\'author_submission\',\'document_queue\',\'accept\')  ';
						}
						else
						{
								$val_artp_conditiion = ' artp_jnl_id = '.$jnl->jnl_id.' AND atotp_paper_length IS NOT NULL AND  atotp_review_method != \'\' AND atotp_file_type != \'\' AND jwf_stage_type IN (\'author_submission\',\'document_queue\',\'accept\')  ';
						}

						$all_article_types =$Article_types::get_all_valid_articletype('artp_fwm_id,artp_id,artp_article_type',$val_artp_conditiion);

						if(empty($all_article_types))
						{
						$valid_jnl_array[]=$jnl->jnl_id;
						}
						$user_roles = $User_to_journals::get_user_roles($this->current_user['user_id'], $jnl->jnl_id, 'j');
						if(count($user_roles) == 1 && $user_roles[0]->role_assigned_role == 'author'){
								$proper_flow = $this->validate_journal($jnl->jnl_fwm_id, $jnl->jnl_id);
								if($proper_flow['status'] == false){
									$valid_jnl_array[]=$jnl->jnl_id;
								}
						}
						}
					}
					$exclude=array_diff($valid_jnl_array,$admin_journal_array);
				}
				$user_preference = $User_journal_preference::get_all_records("pref_jnl_id","pref_usr_id={$this->current_user['user_id']} AND pref_preference='y'");
				$order = NULL;
				$t_array = array();

				if(count($user_preference)>0)
				{
				foreach ($user_preference as $pref) {
					$t_array[] = $pref->pref_jnl_id;
				}
				}
				if (count($t_array) > 0) {
					$order = "FIELD(jnl_id," . implode(" ,", $t_array) . ") DESC, jnl_journal_name ASC";
				}
				else
				{
					$order="jnl_journal_name ASC";
				}
				$standalone_condition= session('group') == $standalone_group ? 'y' : null ;
				$getjournal=$Journals::get_journal_by_article_type($admin_journal_array, $order,$exclude,$standalone_condition,$this->current_user);
				$activethumbcondition = "usr_id ={$this->current_user["user_id"]}";
				$active_thumb = User::get_single_record('usr_thumb_preference', $activethumbcondition); // check active journal
				foreach ($getjournal as $jnls) {
					if (isset($jnls->jnl_logo)) {	
						$jnl_image = $this->get_upload_data($jnls->jnl_journal_code . '/' . $jnls->jnl_logo);
						$exists=false;
						$path = $this->get_upload_path('uploads/' . $jnls->jnl_journal_code . '/');
						$filePath = '';
						$filePath = $this->get_upload_path('uploads/' . $jnls->jnl_journal_code . '/' . $jnls->jnl_logo);
						if($filePath != '' && $this->current_client->enable_upload_s3_bucket == 'y'){
						$headers = get_headers($filePath);
						$exists = storage::disk('s3')->exists('uploads/' . $jnls->jnl_journal_code . '/' . $jnls->jnl_logo);
						
					}else{
						$exists = $this->file_exist_folder($path,$jnls->jnl_logo);
					}
					$jnls->jnl_logo = ($exists) ? $jnl_image : '';
					}
					else
					{
						$jnls->jnl_logo = '';
					}

				}
				$return_data['list']=$getjournal;
				if ($this->current_client->enable_upload_s3_bucket == 'y') {
					$return_data['upload_url']=Storage::disk('s3')->url('uploads');
				}
				else
				{
					$return_data['upload_url']=$this->get_upload_data('');
				}
				$return_data['admin_journals'] = $admin_journal_array;
				$return_data['starred_journals'] = $t_array;
				$return_data['saved_thumb'] = $active_thumb->usr_thumb_preference;
				/* Task #549 Add Notice on Welcome Page*/
				$return_data['notify_system']=false;
				$fetch_confArr  = Config::get('clients.' . $this->current_client->clnt_client_code . '.client_default');
				if(isset($fetch_confArr['notify_system_message']) && $fetch_confArr['notify_system_message'] != '') {
					$return_data['notify_system']    = $fetch_confArr['notify_system_message'];
				}
				$return_data['jnl_description_count_grid']=250;
				$return_data['jnl_description_count_tblr']=500;
				$general_config= Config::get('general_config');
				if(isset($general_config['jnl_description_count_grid']) && $general_config['jnl_description_count_grid']!=''){
					$jnl_description_count_grid = $general_config['jnl_description_count_grid'];
					$return_data['jnl_description_count_grid']=$jnl_description_count_grid;
				}
				if(isset($general_config['jnl_description_count_tblr']) && $general_config['jnl_description_count_tblr']!='')
				{
				$jnl_description_count_tblr = $general_config['jnl_description_count_tblr'];
				$return_data['jnl_description_count_tblr']=$jnl_description_count_tblr;
				}
				/* Task #549 Add Notice on Welcome Page */
				return $this->success(customTrans('platform_settings.list-records'),200,$return_data);
				}
				catch (\Exception $e) {

					return  $this->failure('Failed',500,$e);
				}
    		}
	/**
	 * save thumbnile and list view and thumb view
	 * 
	 */
	public function save_thumb_class(Request $request) {
        try{
            $form_data = $request->all();
			$validator = Validator::make($request->all(), [
				'thumb' => 'required'
			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
            $current_user = $this->get_current_user_details();
            $update_data = array(
                'usr_thumb_preference' => $form_data['thumb']
            );
            User::update_record($update_data,"usr_id = {$current_user['user_id']}", $current_user);
            return $this->success('success', 200, []);
        }
        catch(\Exception $e){

            return $this->failure('Failed', 500, $e);
        }
    }
	/**
	 * save Preference rating into the data
	 */
	public function update_preference(Request $request)
    {
        try{
            $post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_id' => 'required',
				'preference'=>'required'
			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
            $current_user = $this->get_current_user_details();

            if ($post_data)
            {
                $data = array(
                    "pref_usr_id" => $current_user["user_id"],
                    "pref_jnl_id" => $this->decrypt_data($post_data["jnl_id"]),
                    "pref_preference" => $post_data["preference"]);

                $exist_criteria = "pref_usr_id ={$current_user["user_id"]} AND pref_jnl_id = {$this->decrypt_data($post_data["jnl_id"])}";
                $exists = User_journal_preference::get_single_record("pref_id", $exist_criteria);
                if (!empty($exists))
                    User_journal_preference::update_record($data, "pref_id = {$exists->pref_id}",$current_user);
                else
                    User_journal_preference::insert_record($data,$current_user);

                return $this->success('success', 200, []);

            }
        }
        catch(\Exception $e){

                return $this->failure('Failed', 500, $e);
        }
    }


}
