<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Login_tracking;
use App\Models\User;


class Login_Tracker_Api extends Controller
{
   

    public function get_tracker_data(Request $request)
    {
       
        try{
            $form_data = $request->all();
            $total_records = 0;
            $bind_ar = array();
            $condition = 'usr_id IS NOT NULL';
            $search = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
             if(!empty($search))
             {
                if(isset($search['srch_user_name']) && $search['srch_user_name'] !='')
                {
                    $condition  .= ' AND (LOWER(CONCAT(usr_first_name,IF (COALESCE(usr_middle_name,\'\') =\'\', \' \', CONCAT(\' \',usr_middle_name, \' \')),usr_last_name)) LIKE LOWER(?))';
                   $bind_ar[] = '%'.$search['srch_user_name'].'%';
                }
                if(isset($search['srch_user_email']) && $search['srch_user_email']!= '') {
                    $condition  .=  ' AND (`usr_email` LIKE ?)';
                    $bind_ar[] = '%'.$search['srch_user_email']. '%';
                }
                if(isset($search['srch_acti_type'])  && $search['srch_acti_type']!= '') {
                    $condition  .=  ' AND t1.ltk_action_type = ?';
                    $bind_ar[] = $search['srch_acti_type'];
                }
                if((isset($search['date_selection']) && $search['date_selection'] == 'dr') && (isset($search['date_range']) && $search['date_range'] != '')) {
                    $date_range         =   $search['date_range'];
                    $date_range_arr     =   explode(' to ', $date_range);
                    $srch_start_date    =   trim($date_range_arr[0]);
                    $start_date         =   convert_dmy_to_ymd($srch_start_date, $this->current_client->settings->cs_date_format);
                    $srch_end_date      =   trim($date_range_arr[1]);
                    $end_date           =   convert_dmy_to_ymd($srch_end_date, $this->current_client->settings->cs_date_format);
                    $condition          .=  ' AND DATE(t1.ltk_posted_date) BETWEEN ? AND ?';
                    $bind_ar[] = $start_date;
                    $bind_ar[] = $end_date;
                }
                if((isset($search['date_selection']) && $search['date_selection'] == 'd') && (isset($search['login_date']) && $search['login_date'] != '')) {
                    $date = $search['login_date'];
                    $date = convert_dmy_to_ymd($date, $this->current_client->settings->cs_date_format);
                    $condition .= ' AND DATE(t1.ltk_posted_date) LIKE ? ';
                    $bind_ar[] = "%".$date."%";
                }     
            }
            $limit     = $form_data['per_page'] ?? '10';
            $select    = ' SQL_CALC_FOUND_ROWS t1.ltk_posted_by ';
           // DB::enableQueryLog();
            $fetch_details = Login_tracking::fetch_login_tracks_data($select,$condition,$bind_ar,$limit);
            //$query = DB::getQueryLog();$query = end($query);dd($query);
            
            if(!empty($fetch_details))
            {
                $displayArray = array(
                    'jnl_code' => NULL,
                    'flag'     => TRUE,
                    'article_id' =>  NULL,
                    'availability' => TRUE,
                    'save_coauthor' => FALSE,
                    'remove_user' => FALSE,
                    'source' => FALSE,
                    'salutation' => TRUE,
                    'flag_only' => FALSE,
                    'inactive_user' => FALSE,
                    'fullname_only' => FALSE,
                    'journal_id' => NULL,
                );
                foreach($fetch_details as $each_data)
                {
                  $displayArray['user_id'] = $each_data->ltk_posted_by;
                  $fullname = $this->get_user_display_name($displayArray);
                  $each_data->name = $fullname;
                  $login_conditn = array(
                    'ltk_action_type' => 'in',
                    'ltk_posted_by'   => $each_data->ltk_posted_by
                );
                $recent_login = $this->get_log_data($login_conditn);
                $each_data->recent_login = $recent_login['formatted_date']; 
                $logout_conditn = array(
                    'ltk_action_type' => 'out',
                    'ltk_posted_by'   => $each_data->ltk_posted_by.' AND ltk_posted_date >'.$recent_login['original_date'],
                    );

            $recent_logout = $this->get_log_data($logout_conditn);
            $each_data->recent_logout = $recent_logout['formatted_date'];
                } 
            }
            return $fetch_details;            
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function get_log_data($condition)
    {
        try{
        $rtn_log = array();
        $order_by = 'ltk_id DESC';
        $recent_log = Login_tracking::get_single_record_with_bind_cond('ltk_posted_date', $condition,NULL,NULL,NULL,NULL,$order_by);
        $date_format = $this->current_client->settings->cs_date_format.' h:ia';
        if(isset($recent_log->ltk_posted_date) && !empty($recent_log->ltk_posted_date))
            $rtn_log = array(
                'original_date' => $recent_log->ltk_posted_date,
                'formatted_date'=> date($date_format, strtotime($recent_log->ltk_posted_date)),
                );
        else
            $rtn_log = array(
                'original_date' => '--',
                'formatted_date'=> '--'
                );
                
        return $rtn_log;
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }


 public function get_log_history_data(Request $request)
 {
    try{
        $form_data = $request->all();
        $validator = Validator::make($request->all(), [
            'log_usr_id'      => 'required',
        ]); 
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        } 
        $log_usr_id = $this->decrypt_data($form_data['log_usr_id']);
        $bind_arr = array();
        $search = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
        $srch_ip_addr = Login_tracking::get_all_records_with_bind_cond('DISTINCT ltk_ip',array('ltk_posted_by'=>$log_usr_id));
        $srch_os = Login_tracking::get_all_records_with_bind_cond('DISTINCT ltk_os',array('ltk_posted_by'=>$log_usr_id));
        $srch_browser = Login_tracking::get_all_records_with_bind_cond('DISTINCT ltk_browser',array('ltk_posted_by'=>$log_usr_id));
        $dateformat = $this->current_client->settings->cs_date_format;
        $dateFormat= date_format_map($dateformat);
        
        if (isset($form_data["start"]) && $form_data["start"] != 0)
        {
                $no = $form_data["start"];
        }
        else
        {
                $no = 10;
        }
        // if (isset($form_data["length"]))
        //         $length = $form_data["length"];
        // else
        //         $length = 10;
        
        //$limit_qry = ''.$no.', '.$length;
        $limit_qry = $no;
        $condition = 'ltk_posted_by = ?';
        $bind_arr[] = $log_usr_id;
        //DB::enableQueryLog();
        if(!empty($search))
        {
        if(isset($search['activity']) && $search['activity'] !='') {
            $condition .= ' AND ltk_action_type = ?';
            $bind_arr[] = $search['activity'];
        }
                //2781 Sudo user Login tracking modification
        if(isset($search['ip_address']) && $search['ip_address'] !='') {
            $condition .= ' AND ltk_ip = ?';
            $bind_arr[] = $search['ip_address'];
        }
        if(isset($search['os']) && $search['os'] !='') {
            $condition .= ' AND ltk_os = ?';
            $bind_arr[] = $search['os'];
        }
        if(isset($search['browser']) && $search['browser'] !='') {
            $condition .= ' AND ltk_browser = ?';
            $bind_arr[] = $search['browser'];
        }
        if(isset($search['activity_date']) && $search['activity_date'] !='') {
            $date_range        =   $search['activity_date'];
            $date_range_arr    =   explode(' - ', $date_range);
            $srch_start_date   =   trim($date_range_arr[0]);
            $date_format       = (isset($this->current_client->settings->cs_date_format)?$this->current_client->settings->cs_date_format:'d-m-Y') . ' - h:ia';
            $start_date        =   convert_dmy_to_ymd($srch_start_date, $date_format);
            $srch_end_date     =   trim($date_range_arr[1]);
            $end_date          =   convert_dmy_to_ymd($srch_end_date, $date_format);
            $condition        .=  ' AND DATE(ltk_posted_date) BETWEEN ? AND ?';
            $bind_arr[] = $start_date;
            $bind_arr[] = $end_date;
        }
        }
        $select = ' DATE_FORMAT(ltk_posted_date, "'.$dateFormat.' %h:%i: %p") as ltk_posted_date,ltk_action_type,ltk_ip,ltk_os,ltk_browser,ltk_user_type';
        
         //DB::enableQueryLog();
          $fetch_history  =  Login_tracking::fetch_login_tracks_history($select,$condition,$bind_arr,$limit_qry);
         //$query = DB::getQueryLog();$query = end($query);dd($query);
        $return_arr['ip_addr'] = $srch_ip_addr;
        $return_arr['srch_os']  = $srch_os;
        $return_arr['srch_browser'] = $srch_browser;
        $return_arr['fetch_history'] = $fetch_history;
        return  $return_arr;
    }
    catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
    }
     
 }
              
}
            