<?php

namespace App\Http\Controllers;

use App\Http\Services\ConveyService;
use App\Models\Article_types;
use App\Models\Articles;
use App\Models\ConveyData;
use App\Models\Journal_permission;
use App\Models\Journals;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use \stdClass;

class ManageConveyApi extends Controller
{

    public function getAllArticleDisclosers(Request $request)
    {
        try {
            $post_data = $request->all();
            $article_id = Rv_decrypt($post_data['article_id']);
            $is_blinded = $this->is_user_blinded('author', $article_id, session('user_id'));
            if ($is_blinded) {
                $disclosers = app(ConveyService::class)->disclosersInArticleBlinded($article_id);
            } else {
                $disclosers = app(ConveyService::class)->disclosersInArticle($article_id);
            }
            $response = [];
            $data = [];
            $article_code = Articles::find($article_id, ['art_code'])?->art_code;
            $response['heading'] = "Conflict of interest disclosure for $article_code";
            foreach ($disclosers as $discloser) {
                $data['id'] = $discloser['id'];
                $data['fullname'] = implode(" ", [$discloser['firstName'], $discloser['lastName']]);
                $data['role'] = $discloser['role'];
                $data['disclosureStatus'] = $discloser['disclosureStatus']['description'];
                if ($discloser['disclosureStatus']['id'] == 'completed') {
                    $data['action_btn'] = [
                        'label' => 'View Disclosure',
                        'action' => 'getDiscloure',
                        'action_id' => $discloser['disclosureId'],
                    ];
                } elseif ($discloser['disclosureStatus']['id'] != 'completed') {
                    $data['action_btn'] = [
                        'label' => 'Send Reminder',
                        'action' => 'setDisclosureReminder',
                        'action_id' => $discloser['id'],
                    ];
                }
                $data['download_enabled'] = !$is_blinded;
                $response['disclosers'][] = $data;
            }

            return $this->success('success', data: ['discloser_data' => $response]);
        } catch (Exception $e) {
            return $this->failure(data: $e);
        }
    }

    public function actionOnDiscloser(Request $request)
    {
        try {
            $post_data = $request->all();
            $action_id = $post_data['action_id'];
            //disclosure id for action 'View disclosure' and doscloser id for action 'Send reminder'

            if ($post_data['action'] == 'getDiscloure') {
                $disclosure = app(ConveyService::class)->getDisclosureById($action_id);
                $formated_diclosure = [];
                $formated_diclosure['purpose'] = $disclosure['purpose'];
                $formated_diclosure['previous_disclosure'] = $disclosure['previousDisclosureId'] ?? null;
                if ($disclosure['cloneDate']) {
                    $first = end($disclosure['purposes']);
                    $formated_diclosure['cloned_from'] = $first['purpose'];
                }
                foreach ($disclosure['certifiedInterests'] as $key => $interest) {
                    $disclosure_interest['entityName'] = $interest['entity']['name'];
                    $disclosure_interest['interestType'] = $interest['interestType'];
                    $disclosure_interest['interestHeldBy'] = $interest['attribution']['description'];
                    $disclosure_interest['designation'] = $interest['category']['description'] ?? $interest['title'] ?? '';
                    $formated_diclosure['interestDisclosure'][] = $disclosure_interest;
                }

                return  $this->success('success', data: ['component' => 'table', 'data' => $formated_diclosure]);
            } elseif ($post_data['action'] == 'setDisclosureReminder') {
                $article_id = decrypt_link($post_data['article_id']);
                $article_detail = Articles::find($article_id, ['art_artp_id']);
                $jpm = Article_types::find($article_detail->art_artp_id, ['artp_jpm_id', 'artp_jnl_id']);
                $Email_templates = new \App\Models\Email_templates();
                $select = "email_hooks";
                $email_hooks = $this->Utility($select);
                $Roles = (new \App\Models\Roles());
                $hook_data = $email_hooks['email_hooks']['reminder_disclosure_convey_email'];
                $user_roles =
                    $recipient_roles = array();
                $hook_recipient = $hook_data['to'];
                $criteria = 'role_assigned_role != "system"';
                $roles = $Roles::get_all_records('*', $criteria);
                if (!empty($roles)) {
                    foreach ($roles as $usrole) {
                        $usrole->role_label = "";
                        if ($usrole->role_assigned_role != 'author' and $usrole->role_assigned_role != 'system') {
                            $usrole->role_label = "All " . $usrole->role_name . "s";
                        } else if ($usrole->role_assigned_role == 'author') {
                            $usrole->role_label = 'Corresponding Author';
                        } else {
                            $usrole->role_label = $usrole->role_name;
                        }
                    }
                }

                foreach ($roles as $role) {
                    $user_roles[$role->role_name] = $role->role_label;
                }
                $user_roles['article_authors'] = 'All ' . CustomTrans(':article') . ' authors';
                if (!empty($hook_recipient)) {
                    foreach ($hook_recipient as $recipient) {
                        if (array_key_exists($recipient, $user_roles)) {
                            $recipient_roles[$recipient] = $user_roles[$recipient];
                        }
                    }
                } else {
                    $recipient_roles = $user_roles;
                }
                $cc_roles = $bcc_roles = $user_roles;

                $email_template_data = $Email_templates::get_single_record('*', "etmp_name='reminder_disclosure_convey_email'");
                if (!empty($email_template_data)) {
                    $email_template_data->reply_to = $this->get_reply_to_email($jpm->artp_jnl_id);
                    $current_user = $this->get_current_user_details();
                    $email_data = new stdClass;
                    $email_data->email_templates_config = $this->email_templates_config();
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    $email_data->article_id =  $article_id;
                    $email_data->mail_type = 'edit';
                    $content = $email_template_data->etmp_email_template;
                    $user_titles = $this->UserConfigdata('titles')['titles'];
                    $email_template_data->etmp_email_template =   $this->generate_email_data_from_keys($email_data, $content, $current_user, $user_titles, TRUE);
                    preg_match_all('/##([^##]*)##/', $email_template_data->etmp_email_template, $matches);
                    $keys = $matches[1];
                    for ($i = 0; $i < count($keys); $i++) {
                        $element = $keys[$i];
                        if (!empty($element)) {
                            $tmpl_data = str_ireplace('##' . $element . '##', '<button contenteditable="false">' . $element . '</button>',  $email_template_data->etmp_email_template);
                            $email_template_data->etmp_email_template = $tmpl_data;
                        }
                    }
                    $email_template_data->recipient_roles = $recipient_roles;
                    $email_template_data->cc_roles = $cc_roles;
                    $email_template_data->bcc_roles = $bcc_roles;
                }
                return $this->success('success', data: ['component' => 'email_preview', 'data' => $email_template_data]);
            } elseif ($post_data['action'] == 'sendDisclosureReminder') {

                $post_data['post_data']['article_id'] = decrypt_link($post_data['post_data']['article_id']);
                $post_data['post_data']['aflw_id'] = decrypt_link($post_data['post_data']['current_flow_id']);
                $post_data['post_data']['stage_template_sub'] = $post_data['post_data']['stage_etmp_subject'];
                $replace_button = array('<button contenteditable="false">', '</button>');
                $replaceval = str_replace($replace_button, '##',  $post_data['post_data']['stage_etmp_content']);
                $post_data['post_data']['stage_template_content'] = $replaceval;
                $email_data['postdata'] = $post_data['post_data'];
                $email_data['jnl_code'] = encrypt_link($post_data['post_data']['jnl_code']);
                $email_data['jnl_id'] = encrypt_link($post_data['post_data']['jnl_id']);
                (new Manage_Email_Api())->sendConveyDisclosureEmail($action_id, 'reminder_disclosure_convey_email', '', $email_data);
                return $this->success('success', data: ['component' => 'toaster', 'msg' => 'Reminder email has been successfully sent']);
            }
        } catch (Exception $e) {
            return $this->failure(data: $e);
        }
    }

    public function getDisclosureQuestions(Request $request)
    {
        $disclosure_id = $request['action_id'];
        $disclosure = app(ConveyService::class)->retriveAdtnlQstns($disclosure_id);

        return $this->success('success', data: [$disclosure]);
    }

    public function getDisclosureDownloadLink(Request $request)
    {
        $disclosure_id = $request['action_id'];
        $discloser_id = $request['discloser_id'];
        $link = app(ConveyService::class)->getDownLoadLink($discloser_id, $disclosure_id);

        return $this->success('success', data: ['link' => $link]);
    }

    public function getAllDisclosureList(Request $request)
    {
        $filter = $request->get('filter', []);
        $filter = $request;
        $final_filter['start_date'] = $filter['start_date'] ? Carbon::parse($filter['start_date'])->format('m-d-Y') : Carbon::now()->startOfYear()->format('m-d-Y');
        $final_filter['end_date'] = $filter['end_date'] ? Carbon::parse($filter['end_date'])->format('m-d-Y') : Carbon::now()->format('m-d-Y');
        $final_filter['size'] = $filter['size'] ?? 10;
        $final_filter['page'] = isset($filter['page']) ? $filter['page'] - 1 : 0;
        $data = app(ConveyService::class)->getAllDisclosureList($final_filter);
        $date_format = $this->get_platform_date_format();
        foreach ($data['content'] as $key => $value) {
            $data['content'][$key] = [
                'id' => $value['id'],
                'name' => $value['personalInfo']['firstName'] != 'anonymous' ? trim(implode(" ", [$value['personalInfo']['title'], $value['personalInfo']['firstName'], $value['personalInfo']['lastName']])) : 'anonymous user',
                'identifier' => $value['identifier'],
                'purpose' => implode(', ',array_column($value['purposes'], 'purpose')),
                'certifiedDate' => $value['certifiedDate'] ? Carbon::parse($value['certifiedDate'])->format($date_format) : null,
                'cloneDate' => $value['cloneDate'] ? Carbon::parse($value['cloneDate'])->format($date_format) : null,
                'interestsDisclosedCount' => $value['interestsDisclosedCount'],
            ];
        }

        return $data;
    }
}
