<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Common_optional_select_column;
use App\Models\Journal_settings;
use Exception;
use Config;

class ManageOptionalColumnController extends Controller
{
    public function getCommonOptionalColums(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
            ]);
            $post_data = $request->all();
            $page = $post_data['page'];     //Name of the dataTable or page
            $jnl_id = decrypt_link($post_data['jnl_id']);
            $current_user = $this->get_current_user_details();
            $condition = [
                "cosc_user_id" => $current_user['user_id'],
                "cosc_jnl_id" => $jnl_id,
                "cosc_type" => $page
            ];
            $result = [];
            $jnl_setting = Journal_settings::get_single_record_with_bind_cond('jset_classification',array("jset_jnl_id"=>$jnl_id));
            $optional_columns_table = Common_optional_select_column::get_single_record_with_bind_cond('cosc_colums', $condition);
            $affl_config = 'clients.' . $this->current_client->clnt_client_code;
            $optionalListTable = Config::get($affl_config . '.proposal_article')['optional_column'];
            
            $optional_columns_selected = "";
            if($optional_columns_table){
                $optional_columns_selected = json_decode($optional_columns_table->cosc_colums);
            }
            if($jnl_setting->jset_classification == 'n'){
                if(isset($optional_columns_selected['classification']))
                    unset($optional_columns_selected['classification']);

                if(isset($optionalListTable['classification']))
                    unset($optionalListTable['classification']);
            }
            $optionalColumn = array_keys($optionalListTable);
            $result['optional_columns_selected'] = $optional_columns_selected;
            $result['optional_column'] = $optionalColumn;
            return  $this->success('Success', 200, $result);
        }catch(Exception $e){
            return  $this->failure('Failed',500,$e);
        }
    }
    public function saveCommonOptionalColums(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $page = $post_data['page'];     //Name of the dataTable or page
            $validator = Validator::make($request->all(), [
                'optional_colums_selected' => 'present|array',
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            else
            {
                $current_user = $this->get_current_user_details();
                $condition = [
                    "cosc_user_id" => $current_user['user_id'],
                    "cosc_jnl_id" => decrypt_link($post_data['jnl_id']),
                    "cosc_type" => $page
                ];
                $saved_data = Common_optional_select_column::get_single_record_with_bind_cond('cosc_id', $condition);
                if(empty($saved_data))
                {
                    $insert_data = array(
                        'cosc_user_id' => $current_user['user_id'],
                        'cosc_jnl_id'  => decrypt_link($post_data['jnl_id']),
                        'cosc_colums' => json_encode($post_data['optional_colums_selected']),
                        'cosc_type' => $page
                    );
                    
                    Common_optional_select_column::insert_record($insert_data, $current_user);
                }
                else
                {
                    $condition = [
                        "cosc_id" => $saved_data->cosc_id,
                    ];
                    $update_data = array(
                        'cosc_colums' => json_encode($post_data['optional_colums_selected'])
                    );
                    Common_optional_select_column::update_record($update_data, $condition, $current_user);
                }

                return $this->success('success', 200);
            }
        }
        catch(\Exception $e)
        {

            return  $this->failure('Failed',500,$e);
        }
    }
}
