<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Config;
use \stdClass;
use WorkflowDataTrait;
use StagemovementTrait;
use Illuminate\Support\Facades\Validator;

use App\Models\Articles;
use App\Models\User;
use App\Models\Article_flow;
use App\Models\Article_generic_form_data;
use App\Models\Article_generic_form_data_temp;
use App\Models\User_articles;
use App\Models\Production_attachment_files;
use App\Models\Production_stages_info;
use App\Models\Rescind_reset_record;
use App\Models\Stage_email_templates;
use App\Models\Stage_email_tmpl_reference;
use App\Models\User_to_journals;
use App\Models\Article_parallel_flow_movement;
use App\Models\Article_type_advance_options;
use App\Models\Generic_flows;
use App\Models\Article_notification_emails;
use App\Models\Roles;
use App\Models\Authors;
use App\Models\Payment_order;
use App\Models\Journal_permission_master;
use App\Models\Journal_permission;
use App\Models\Article_types;
use App\Models\Article_flag;
use App\Models\Research_integrity_reports;

use App\Http\Traits\ReviewerListTrait;
use App\Http\Controllers\Manage_Generic_Form_Api;
use Illuminate\Support\Facades\Storage;
class Manage_Article_Actions_Api extends Controller
{
    use ReviewerListTrait;
    /**
     * Reset an article
     *
     * @param Request  $request
     * @return Response
     */
    public function reset_article(Request $request) {
        DB::beginTransaction();
        try {
            $post_data          = $request->all();
            $this->current_user = $this->get_current_user_details();

            if(count($post_data) > 0) {
                $client_code        = $this->current_client->clnt_client_code;
                //post variables
                $art_id             = $this->decrypt_data($post_data['art_id']);
                $current_status_id  = $this->decrypt_data($post_data['current_status_id']);
                $reset_reason       = $post_data['reset_reason'];
                $jnlcode            = $post_data['jnlcode'];
                $journal_id         = $post_data['jnl_id'];
                $curr_role_id       = $post_data['core_role_id'];
               
                if ($art_id != '' && $current_status_id != '' && $reset_reason != '')
                {
                    $es_article = FALSE;
                    $reset_es_data = [];
                    $esarray['article_id']=$art_id;
                    $checkdata=$this->check_espermission_access($esarray);
                    //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                    if($checkdata==true)
                    {
                        $art_data = Articles::get_single_record_with_bind_cond('art_es_document_status' ,array('art_id' => $art_id));
                        if($art_data->art_es_document_status !== 'n')
                        {
                            $es_article = TRUE;
                            array_push($reset_es_data,(int)$current_status_id);
                        }
                    }
                    $return = array(
                        'status' => 'success', 'msg' => customTrans('viewarticle.art_reset_success')
                    );
                    $select     =   'aflw_id, jwf_stage_type,aflw_status,aflw_jwf_id,aflw_usr_id,jwf_assignment,jwf_role_id,jwf_stage_name,jwf_forms';
                    $crnt_stage =   Article_flow::get_generic_flow($select, "aflw_id=$current_status_id");
                    $crnt_stage =   $crnt_stage[0];

                    if($crnt_stage->aflw_usr_id == '') {
                        $return = array(
                            'status' => 'failed', 'msg' => customTrans('viewarticle.missing_parameters')
                        );
                        return $this->warning('Warnings',200,$return,'warning');
                    }
                    $crnt_stage->art_id=$art_id;
                    $article_types =  Articles::get_single_record('art_artp_id,art_article_upload_path', 'art_id=:article_id',NULL,'',NULL,array('article_id'=>$art_id));
                    $crnt_stage->artp_id = $article_types->art_artp_id;
                    $article_types_data =  Article_types::get_single_record('artp_fwm_id', 'artp_id=:artp_id',NULL,'',NULL,array('artp_id'=>$crnt_stage->artp_id));
                    $crnt_stage->artp_fwm_id = $article_types_data->artp_fwm_id;
                    $article_privilages = $this->article_privilages($crnt_stage, $current_status_id, $jnlcode);
                    $isauthor = $article_privilages['author'];
                    $isreviewer=$article_privilages['reviewer'];
                    $user_allocated=$article_privilages['user_allocated'];
                    if($isauthor==true || ($isreviewer==true && $user_allocated == false))
                    {
                        return  $this->warning('Failed', 200, "redirectdashboard");
                    }
                    $current_stage_usr  =   $crnt_stage->aflw_usr_id;
                    $current_stage_type =   $crnt_stage->jwf_stage_type;
                    $aflw_status        =   $crnt_stage->aflw_status;
                    $jwf_assignment     =   $crnt_stage->jwf_assignment;
                    $jwf_role_id        =   $crnt_stage->jwf_role_id;
                    $aflw_jwf_id        =   $crnt_stage->aflw_jwf_id;
                    $forms              =   json_decode($crnt_stage->jwf_forms, true);
                    // Check if the current stage has already completed
                    if ($aflw_status == 'c')
                    {
                        $return = array(
                            'status' => 'failed', 'msg' => customTrans('viewarticle.stage_completed')
                        );
                        return $this->warning('Warnings',200,$return,'warning');
                    }
                    
                    $workflow_config    =   'clients.' . $client_code . '.workflow_config.review_flow';
                    $review_flow        =   Config::get($workflow_config);
                    $current_stage_flow = $review_flow[$current_stage_type];

                    // start -- check if current stage has reset permission	
                    if (isset($current_stage_flow['permission']) && in_array('reset', $current_stage_flow['permission']))
                    {
                        $production_flag = FALSE;
                        if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
                        {
                            $mng_production = $this->is_article_in_production_management($art_id, $current_status_id);
                            if($mng_production['status'] == TRUE)
                            {                                 
                                $production_flag = TRUE;
                            }
                        }
                        $aflw_status = ($current_stage_type == 'resubmission') ? 'a' : 'u'; // Reset resubmission - No need to begin from  start resubmission in resubmission stage.
                        $formatted_journal_code = '_' . $jnlcode;
                        $delvalues = array();
                        
                        $filepath=$article_types->art_article_upload_path;
                        if(!empty($forms))
                        {
                            foreach($forms as $formid)
                            {
                                $elem_condition = "gdata_art_id=? and gdata_atf_id=? and gdata_artflw_id=? and gdata_element_type=?";
                                $bindArr = [$art_id, $formid, $current_status_id, "file"];

                                /* Start -- clear generic form elements */
                                /* Get generic form elements that need to be cleared */
                                $result = Article_generic_form_data::get_generic_form_stage_elements(
                                    $formatted_journal_code,
                                    'gdata_id, gdata_element_type, gdata_data',
                                    $elem_condition,
                                    bind_data: $bindArr
                                );
                                 if ($result) {
                                    $otherController = new Manage_Generic_Form_Api();
                                    foreach ($result as $value) {
                                       $otherController->removeUploadedFiles($value, $filepath);
                                    }
                                   
                                }
                                /* end -- clear genereic form elements */
                            }
                        }


                        if ($aflw_status == 'p' || $aflw_status == 'w')
                        {
                            $get_review_ids = Article_flow::get_all_records('aflw_id', "aflw_parent_flow_id = {$current_status_id}");
                            foreach ($get_review_ids as $get_review_id)
                            {
                                array_push($delvalues, $get_review_id->aflw_id);
                            }
                        }
                        array_push($delvalues, $current_status_id);
                        /* TASK #6282 Implement Review Article grading System */
                           $Article_Rating = new \App\Models\Article_rating(); 
                           $rate_data=$Article_Rating::get_single_record_with_bind_cond('count(rat_id) AS cnt',array('rat_art_id'=>$art_id,'rat_aflw_id'=>$current_status_id));
                           
                           if(!empty($rate_data)&&isset($rate_data->cnt)&&$rate_data->cnt>0)
                           {
                        
                            $Article_Rating::delete_records(array('rat_art_id'=> $art_id,'rat_aflw_id'=>$current_status_id), '', $this->current_user);
                           }
                        /*  TASK  #6282 END     */
                         // Delete Flag  from form
                        Article_flag::delete_generic_form_flag_data($formatted_journal_code,'gdata_artflw_id',$delvalues,$this->current_user );
                        // Delete generic form data
                        Article_generic_form_data::delete_generic_form_data($formatted_journal_code, 'gdata_artflw_id', $delvalues,$this->current_user );

                        //Delete from temp table
			            Article_generic_form_data_temp::delete_generic_form_data_temp('gdata_artflw_id', $delvalues);
                        
                        // Delete allocated article users
                        $where1 = "usra_art_id = '{$art_id}' AND usra_aflw_id = {$current_status_id}"; 
                        User_articles::delete_records($where1, '', $this->current_user);

                        // Delete pre/post assesments data
                        $where2 = 'aflw_art_id = '.$art_id.' and aflw_parent_flow_id = '.$current_status_id.'';
                        /* TASK #9144 If the stage is reset, the saved 'On Complete' email should also be reset.*/
                        //Delete edited email template when stage is reset.
                        if (!empty($art_id) && !empty($current_status_id)) {
                            $ane_id = Article_notification_emails::where('ane_art_id', $art_id)
                            ->where('ane_aflw_id', $current_status_id)
                            ->where('ane_status', 0)
                            ->value('ane_id'); //fetches the ane_id

                        if ($ane_id) {
                            // check for already edited email template
                            $edited_old_mail = DB::table('tbk_article_notification_emails')
                            ->where('ane_id', $ane_id)
                            ->where('ane_aflw_id', '!=', $current_status_id)
                            ->orderByDesc('tbk_id')
                            ->first();
                    
                            if ($edited_old_mail) {
                                $edited_old_mail = (array) $edited_old_mail; //converting to array
                                unset($edited_old_mail['tbk_id']);
                    
                                // Ensure ane_id exists in the retrieved data before updating
                                if (isset($edited_old_mail['ane_id'])) {
                                    Article_notification_emails::where('ane_id', $edited_old_mail['ane_id'])
                                        ->update($edited_old_mail); //updating the email with last edited content.
                                }
                            } else {
                                // If no old record exists, delete the current record
                                Article_notification_emails::where([
                                    'ane_art_id' => $art_id,
                                    'ane_aflw_id' => $current_status_id,
                                    'ane_status' => 0
                                ])->delete();
                            }
                        }
                            }
                            /*end TASK #9144  If the stage is reset, the saved 'On Complete' email should also be reset.*/
                        if($es_article == TRUE)
                        {
                            $delete_entries = Article_flow::get_all_records('aflw_id',$where2);
                            if(count($delete_entries) > 0)
                            {
                                foreach($delete_entries as $single_delete_entries)
                                {
                                    if(!in_array($single_delete_entries->aflw_id,$reset_es_data))
                                    {
                                        array_push($reset_es_data,$single_delete_entries->aflw_id);
                                    }
                                }
                            }
                        }
                        Article_flow::delete_records($where2, '', $this->current_user);

                        $aflw_usr_id = $crnt_stage->aflw_usr_id;
                        if ($jwf_assignment == 'self_service' && $jwf_assignment != 'resubmission')
			            {
                            $aflw_usr_id =  NULL;
                            $aflw_status =  'u';

                            $where3 = 'usra_art_id = '.$art_id.' and usra_role_id = '.$jwf_role_id.' and usra_usr_id = '.$current_stage_usr;
                            $user_assignment_exists     = User_articles::get_single_record('count(usra_id) as cnt', $where3);  
                            
                            $where4 = 'usra_art_id = '.$art_id.' and usra_role_id = '.$jwf_role_id;
                            $no_of_user_assignment_role = User_articles::get_single_record('count(usra_id) as cnt', $where4);  
            
                            if ($user_assignment_exists->cnt > 0 && $no_of_user_assignment_role->cnt==1)
                            {
                                $aflw_usr_id = $current_stage_usr;
                                $aflw_status = 'a';
                            }
                            if($this->current_client->modules->mdl_review_for_doc =='n')
                            {
                                $where5         =   'art_id = '.$art_id.' and art_submitted_by = '.$current_stage_usr;
                                $author_user    =   Articles::get_single_record('count(art_id) as cnt', $where5);
                                if($author_user->cnt>0)
                                {
                                    $aflw_usr_id = $current_stage_usr;
                                    $aflw_status = 'a';
                                }
                            }
                        }
                        //Update article flow status $aflw_status(u/p/w)
                        $update_arr = array(
                            'aflw_status' => $aflw_status,
                            'aflw_usr_id' => $aflw_usr_id,
                            'aflw_flow_operation' => "r",
                            'aflw_skip_assignment'=>NULL
                        );
                        
                        $where6 = 'aflw_art_id = '.$art_id.' and aflw_id = '.$current_status_id.' and aflw_merge_date IS NULL';
                        $art_flw_upd    =   Article_flow::update_record($update_arr, $where6, $this->current_user);
                        
                        if($art_flw_upd == 0) {
                            $return =   array(
                                'status' => 'failed', 
                                'message' => customTrans('viewarticle.art_reset_failed'),
                            );
                            return  $this->warning('Warnings',200,$return,'warning');
                        }
                        if($production_flag == TRUE)
                        {
                            $where7=    'paf_aflw_id = '.$current_status_id;
                            Production_attachment_files::delete_records($where7, '', $this->current_user); 
            
                            $where8=    'psi_aflw_id = '.$current_status_id;
                            Production_stages_info::delete_records($where8, '', $this->current_user); 
                        }

                        if($production_flag == TRUE) 
                        {
                            $stage_attach = Production_attachment_files::get_single_record('count(paf_id) as cnt', 'paf_aflw_id = '.$current_status_id); 
                            
                            if($stage_attach->cnt == 0 && $current_status_id != '')
                            {
                                //get article path
                                $art_data       =   Articles::get_single_record('art_article_upload_path', 'art_id = '.$art_id);
                                $pro_stage_path =   'uploads/' . $art_data->art_article_upload_path.'/production/'.$current_status_id;
                                if(file_exists($pro_stage_path))
                                {
                                    chdir($pro_stage_path);            
                                    $cmd    =   'rm -r  *';
                                    shell_exec($cmd);
                                }
                            }
                        }
                        $rescind_record = array(
                            'rsc_current_flow_id' => $current_status_id,
                            'rsc_source_jwf_id' => $aflw_jwf_id,
                            'rsc_reason' => $reset_reason,
                            'rsc_action' => 'reset');
                        Rescind_reset_record::insert_record($rescind_record, $this->current_user);

                        if ($current_stage_usr != NULL)
                        {
                            $aflw_select        =   'art_id, art_artp_id, art_title, artp_article_type, jnl_id, jnl_journal_name, jnl_journal_code, aflw_usr_id, aflw_jwf_id';
                            $article_details    =   Article_flow::get_article_stage_data($aflw_select, 'aflw_id = '.$current_status_id);
                            
                            $source_condition       = 'stage_etmp_journal_id = '.$article_details->jnl_id.' and stage_etmp_stage_type = "'.$current_stage_type.'" and stage_etmp_action = "reset" and setr_jwf_id = '.$article_details->aflw_jwf_id;
                            $source_email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $source_condition);
                            
                            $source_email_templates_arr     =   array();
                            if(!$source_email_templates->isEmpty()) {
                                $source_email_templates_arr = $source_email_templates[0];
                            }

                            //send reset email if an email is associated with that stage and in that journal
                            if (!empty($source_email_templates_arr)) {                                
                                $email_data=array(
                                    'type'=>'stage',
                                    'action'=>'send',
                                    'email_with_login'=>FALSE,
                                    'article_id'=>$art_id,
                                    'user_id'=> $current_stage_usr,
                                    'aflw_id'=> $current_status_id,
                                    'artp_id'=> $article_details->art_artp_id,
                                    'jnl_user_role'=>array(
                                        'core_role'=>$curr_role_id,
                                        'jnl_id'=> $journal_id,
                                        'jnl_journal_code'=> $jnlcode
                                    ),
                                );
                                // $this->send_mail_notification($source_email_templates, $email_data);
                            } 

                            $journal_dashboard_redirection = FALSE;
                            if(isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y')
                            {
                                $current_usr_id         =   $this->current_user['user_id'];
                                $retired_role_criteria  =   'usrj_jnl_id ='.$journal_id.' and usrj_usr_id ='.$current_usr_id.' and usrj_role_id ='.$curr_role_id;
                                $check_retired_role = User_to_journals::get_single_record('usrj_role_retired',$retired_role_criteria);
                                if(!$source_email_templates->isEmpty())
                                {
                                    if($check_retired_role->usrj_role_retired == 'y')
                                    {
                                        $journal_dashboard_redirection = TRUE;
                                    }
                                }
                            }
                            
                            $return =   array(
                                'status' => 'success', 
                                'message' => customTrans('viewarticle.art_reset_success'),
                            );
                        }
                    }
                    DB::commit();
                    if($es_article == TRUE)
                    {
                        $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                        $es_api_data  = Config::get($es_config);
                        if(isset($es_api_data['reset_stage']))
                        {
                            $apiUrl = $es_api_data['reset_stage'];
                            $data_to_editor = array('art_id' => $art_id,'delete_flows' => $reset_es_data);
                            $data_to_editor = http_build_query($data_to_editor);
                            $response = $this->es_curl_request($apiUrl,$data_to_editor);
                            $response = json_decode($response);
                            $message_to_rvrite =customTrans('viewarticle.stage_reset_rvrite');
                            $message_to_rvrite = str_replace('##STAGE_NAME##', $crnt_stage->jwf_stage_name,$message_to_rvrite);
                            $return['message_to_rvrite'] = $message_to_rvrite;
                        }
                    }
                    return $this->success('Success',200,$return);
                }
                else{
                    $return = array(
                        'status' => 'failed', 'msg' => customTrans('viewarticle.missing_parameters')
                    );
                    return  $this->warning('Warnings',200,$return,'warning');
                }
            } else {
                $return = array(
                    'status' => 'failed', 'msg' => customTrans('viewarticle.invalid_access')
                );
                return  $this->warning('Warnings',200,$return,'warning');
            }
        } catch (\exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }


    /**
     * Rescind an article
     *
     * @param Request  $request
     * @return Response
     */
    public function rescind_article(Request $request) {
        
        try {
            $post_data          =   $request->all();
            $this->current_user =   $this->get_current_user_details();
            $authors_table      =   (new \App\Models\Authors())->getTable();
            $users_table        =   (new \App\Models\User())->getTable();
            $article_flow_table =   (new \App\Models\Article_flow())->getTable();
            $immediate_parent_status    = NULL;
            $clear_payment_order_status = NULL;
            if(count($post_data) > 0) {
                $current_stage_type =   '';
                $client_code        = $this->current_client->clnt_client_code;
                //post variables
                $art_id             =   $this->decrypt_data($post_data['art_id']);
                $current_status_id  =   $this->decrypt_data($post_data['current_status_id']);
                $rescind_reason     =   $post_data['rescind_reason'];
                $jnlcode            =   $post_data['jnlcode'];
                $journal_id         =   $post_data['jnl_id'];
                $curr_role_id       =   $post_data['core_role_id'];
                $role_name       =   $post_data['role_name'];
                $core_role      =   $post_data['core_role'];
                $email_tmpls        =   '';
                $current_aflw_id    =   '';
                $jnl_user_role=array(
                    'core_role'=>$core_role,
                    'role_name'=>$role_name,
                    'jnl_id'=> $journal_id,
                    'jnl_journal_code'=> $jnlcode
                );
                if(isset($post_data['email_tmpls']))
                    $email_tmpls        =   $post_data['email_tmpls'];

                if ($art_id != '' && $current_status_id != '' && $rescind_reason != '')
                {
                    DB::beginTransaction();
                    $return = array(
                        'status' => 'success', 'msg' => customTrans('viewarticle.art_rescind_success')
                    );
                    $select         =   'aflw_level, aflw_jwf_id, aflw_status,aflw_skip_review,aflw_more_review_skip_status,aflw_stage_min_users,aflw_id,jwf_stage_name';
                    // $current_stage  =   Article_flow::get_generic_flow($select, "aflw_id=$current_status_id");
                    $current_stage  =   Article_flow::get_generic_flow($select, "aflw_id= ?",bind_data:[$current_status_id]);
                    $current_stage  =   $current_stage[0];
                    $aflw_level=$current_stage->aflw_level;
                    $last_flw_level=$aflw_level-3;
                    $possible_condition= "aflw_art_id =".$art_id." and aflw_level between ".$last_flw_level." and ".$aflw_level;
                    $all_possible_aflw_id   =   Article_flow::get_single_record("GROUP_CONCAT(aflw_id) as flows",$possible_condition);
                    // $all_possible_aflw_id   =   Article_flow::get_single_record("GROUP_CONCAT(aflw_id) as flows", "aflw_art_id = ?",binding_arr:[$art_id]);
                    $parallel_flow_condi    =   " apfm_end_stg_jwf_id = ".$current_stage->aflw_jwf_id." AND apfm_aflw_id IN(".$all_possible_aflw_id->flows.")";
                    $parallel_flows         =   Article_parallel_flow_movement::get_all_records("apfm_id,apfm_travel_path_ids", $parallel_flow_condi);
                    $parallel_workflow_set  = FALSE;
			        $para_mov_arr           = array();
                    if(!$parallel_flows->isEmpty()) {
                        $parallel_workflow_set = TRUE;
                        foreach($parallel_flows as $single_paralel_flow)
                        {
                            $flow_arr = explode(',',$single_paralel_flow->apfm_travel_path_ids);
                            if(count($flow_arr)>0)
                            {
                                $flow_detail=Article_flow::get_single_record('aflw_jwf_id','aflw_jwf_id IN ('.$single_paralel_flow->apfm_travel_path_ids.') and aflw_parent_flow_id is null and aflw_art_id='.$art_id,NULL,'','aflw_id desc');
                                if(isset($flow_detail->aflw_jwf_id) && !empty($flow_detail->aflw_jwf_id ))
                                {
                                    array_push($para_mov_arr,$flow_detail->aflw_jwf_id);
                                }
                            }
                            else
                            {
                                array_push($para_mov_arr,$single_paralel_flow->apfm_travel_path_ids);
                            }
                            //array_push($para_mov_arr, end($flow_arr));
                        }
                    }

                    $review_stage_condi =   array('aflw_parent_flow_id'=> $current_status_id);
                    $review_stage       =   Article_flow::get_single_record_with_bind_cond('count(aflw_id) as cnt',$review_stage_condi);
                    $min_review_count=0;
                    if(isset($review_stage->cnt)&& $review_stage->cnt>0)
                    {
                        $min_review_count=$review_stage->cnt;
                    }
                    $latest_stage_condi =   'aflw_art_id= ? and aflw_parent_flow_id IS NULL and aflw_level >= ?'; 
                    $latest_stage       =   Article_flow::get_single_record('MAX(aflw_id) as aflw_id', $latest_stage_condi,binding_arr:[$art_id,$current_stage->aflw_level]);
                    if (!empty($latest_stage) && (($latest_stage->aflw_id != $current_status_id) || $latest_stage->aflw_id == $current_status_id && $current_stage->aflw_status=="p"))
                    {
                        $lastflwid=$latest_stage->aflw_id;
                        $orderby='aflw_id desc';
                        $latest_status_condi =  'aflw_art_id='.$art_id.' and (aflw_parent_flow_id='.$lastflwid.' or aflw_id='.$lastflwid.')'; 
                        $latest_status      =   Article_flow::get_single_record('aflw_status,aflw_force_next_stage,aflw_usr_id', $latest_status_condi,NULL,'',$orderby);
                        if($latest_status->aflw_status == "h" || $current_stage->aflw_status == "c" || ($current_stage->aflw_status == "p" && $latest_status->aflw_status=="a" && $latest_status->aflw_usr_id==$this->current_user['user_id'])||($current_stage->aflw_status == "w" && ($min_review_count >= $current_stage->aflw_stage_min_users || $current_stage->aflw_skip_review == 'y' || $latest_status->aflw_force_next_stage == 'y' || $current_stage->aflw_more_review_skip_status=='y')))
                        {
                            $message_to_rvrite =customTrans('viewarticle.art_unable_rescind');
                            $message_to_rvrite = str_replace('##STAGE_NAME##', $current_stage->jwf_stage_name,$message_to_rvrite);
                            $return = array(
                                'status' => 'warning','rerender'=>true, 'msg' => $message_to_rvrite
                            );
                            return  $this->warning('Warnings',200,$return,'warning');
                        }
                    }

                    $current_stage->art_id=$art_id;
                    $article_types =  Articles::get_single_record('art_artp_id', 'art_id=:article_id',NULL,'',NULL,array('article_id'=>$art_id));
                    $current_stage->artp_id = $article_types->art_artp_id;
                    $article_types_data =  Article_types::get_single_record('artp_fwm_id', 'artp_id=:artp_id',NULL,'',NULL,array('artp_id'=>$current_stage->artp_id));
                    $current_stage->artp_fwm_id = $article_types_data->artp_fwm_id;
                    $article_privilages = $this->article_privilages($current_stage, $current_status_id, $jnlcode);
                    $isauthor = $article_privilages['author'];
                    $isreviewer=$article_privilages['reviewer'];
                    $user_allocated=$article_privilages['user_allocated'];
                    if($isauthor==true || ($isreviewer==true && $user_allocated == false))
                    {
                        return  $this->warning('Failed', 200, "redirectdashboard");
                    }
                    
                    //Check article stage exist or not
                    // $article_status = Article_flow::get_generic_flow('aflw_art_id', 'aflw_id ='.$current_status_id);
                    $article_status = Article_flow::get_generic_flow('aflw_art_id', 'aflw_id = ?',bind_data:[$current_status_id]);
                    if($article_status->isEmpty()) {
                        $return = array(
                            'status' => 'failed', 'msg' => customTrans('viewarticle.article_stage_not_exist')
                        );
                        return  $this->warning('Warnings',200,$return,'warning');
                    }

                    $production_flag = FALSE;
                    if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
                    {
                        $mng_production = $this->is_article_in_production_management($art_id, $current_status_id);
                        if($mng_production['status'] == TRUE)
                        {
                            $production_flag = TRUE;
                        }
                    }
                    //get article path
                    // $art_data = Articles::get_single_record('art_article_upload_path, art_status, art_artp_id', 'art_id ='.$art_id);
                    $art_data = Articles::get_single_record('art_article_upload_path, art_status, art_artp_id', 'art_id = ?',binding_arr:[$art_id]);
                    $art_type_id = $art_data->art_artp_id;
                    
                    // get current workflow from generic workflow table
                    $select     = 'aflw_id, aflw_status, jwf_stage_type, jwf_parent_stages, jwf_assignment,aflw_jwf_id,aflw_usr_id,jwf_role_id,jwf_id,jwf_fwm_id,aflw_level,jwf_stage_name,jwf_flow_proceed_type';
                    // $where      = 'aflw_id ='.$current_status_id;
                    $where      = 'aflw_id = ?';
                    $crnt_stage = Article_flow::get_generic_flow($select, $where,bind_data:[$current_status_id]);
                    if(!$crnt_stage->isEmpty()) {
                        $crnt_stage         =   $crnt_stage[0];
                        $current_stage_user =   $crnt_stage->aflw_usr_id;
                        $current_stage_type =   $crnt_stage->jwf_stage_type;                      
                        $workflow_config    =   'clients.' . $client_code . '.workflow_config.review_flow';
			            $review_flow        =   Config::get($workflow_config);
                        $current_stage_flow =   $review_flow[$crnt_stage->jwf_stage_type];
                        
                        $artp_table     =   (new \App\Models\Article_types())->getTable();
                        $jpm_table      =   (new \App\Models\Journal_permission_master())->getTable();
                        $jp_table       =   (new \App\Models\Journal_permission())->getTable();
                        $tables         =   array(
                                                'main_table' => $artp_table,
                                                'join_table' => array(
                                                    $jpm_table => array($artp_table . '.artp_jpm_id', $jpm_table . '.jpm_id', "left"),
                                                    $jp_table => array($jp_table . '.jp_jpm_id', $jpm_table . '.jpm_id', "left")
                                            ));
                        $criteria       =   "artp_id = {$art_type_id}";
                        $artp_opt     =   Article_types::get_results_using_joins($tables, 'jp_auto_assign_role', $criteria, 'single');

                        if($this->current_client->functionality->cfty_auto_assign_user_for_role == 'y' && !empty($artp_opt->jp_auto_assign_role != '' && $crnt_stage->jwf_stage_type != 'review')){
                            $cur_role_id    =   $crnt_stage->jwf_role_id;
                            $cur_jwf_id     =   $crnt_stage->jwf_id;
                            $asgn_role      =   json_decode($artp_opt->jp_auto_assign_role,TRUE);
                            if(in_array($cur_role_id,$asgn_role))
                            {
                                $first_stage_wthrole = Generic_flows::get_single_record('jwf_id', 'jwf_role_id='.$cur_role_id.' and jwf_fwm_id='.$crnt_stage->jwf_fwm_id);
                                if($first_stage_wthrole->jwf_id == $cur_jwf_id)
                                {
                                    $record = User_articles::get_single_record('usra_id', 'usra_art_id='.$art_id.' and usra_role_id='.$cur_role_id);
                                    if(!empty($record->usra_art_id))
                                    {
                                        User_articles::delete_records('usra_id='.$record->usra_art_id, '', $this->current_user);
                                    }
                                }
                            }
                        }
                    }
                    if (!isset($current_stage_flow['permission']))
                    {
                        $return = array(
                            'status' => 'failed', 'msg' => customTrans('viewarticle.art_rescind_failed')
                        );
                        return  $this->warning('Warnings',200,$return,'warning');
                    }
                    // end -- check if current stage has rescind permission

                    //  start-- fetch article details before deleting stage
                    $select = 'art_id, art_artp_id, art_stub, art_title,art_es_document_status, artp_article_type, jnl_id, jnl_journal_name, jnl_journal_code, aflw_usr_id, art_submitted_by, aflw_level';
                    $article_details = Article_flow::get_article_stage_data($select, 'aflw_id='.$current_status_id);
                    $flows_to_be_removed = array();
                    $es_article = FALSE;
                    $esarray['article_id']=$art_id;
                    $checkdata=$this->check_espermission_access($esarray);
                    //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $article_details->art_es_document_status !== 'n')
                    if($checkdata==true && $article_details->art_es_document_status !== 'n')
                    {
                        $es_article = TRUE;
                        array_push($flows_to_be_removed,(int)$current_status_id);
                    }
                    //  end-- fetch article details before deleting stage

                    //Task #925 reset research integrity report if generated
                    // $this->reset_research_integrity_report($art_id, $current_status_id, $article_details);

                    // start -- remove current stages child status stages if the stage assignment type is invitation/assignment 
                    $status_childs_deleted      = FALSE;
                    $rescind_status_id          = array();
                    $change_article_status      = false;
                    $change_art_decision_status = FALSE;

                    if ($art_data->art_status == 'r' && $crnt_stage->jwf_stage_type == 'reject')
                        $change_art_decision_status = TRUE;

                    if ($crnt_stage->jwf_assignment != 'self_service')
                    {
                        $where = 'aflw_art_id='.$art_id.' and aflw_parent_flow_id='.$crnt_stage->aflw_id;
                        $status_childs = Article_flow::get_single_record('count(*) as count', $where);
                        if ($status_childs->count > 0)
                        {
                            //DB::beginTransaction();
                            /*
                            $update_arr     =   array('aflw_operation'=>'d','aflw_posted_date'=>date('Y-m-d H:i:s'),'aflw_posted_by'=>$this->current_user['user_id'],'aflw_proxy_id'=>$this->current_user['proxy_user_id']);
                            */
                            //Task #122  The article is not listed for the privileged user after it is rescinded
                            $stages_to_remove = Article_flow::get_all_records('aflw_id,aflw_art_id,aflw_usr_id',$where);
                            if($es_article == TRUE)
                            {
                                if(count($stages_to_remove) > 0)
                                {
                                    foreach($stages_to_remove as $single_flow)
                                    {
                                        array_push($flows_to_be_removed,(int)$single_flow->aflw_id);
                                    }
                                }
                            }

                            // Article_flow::update_flow($update_arr, $where);
                            // Article_flow::delete_flow($where);

                            //Task #122  The article is not listed for the privileged user after it is rescinded
                            if(!empty($stages_to_remove))
                            {
                                foreach($stages_to_remove as $stRm)
                                {
                                   $this->mngReviewerversion($stRm->aflw_art_id,$stRm->aflw_id,$stRm->aflw_usr_id,false);
                                }
                            }
                            Article_flow::delete_records($where,user_data:$this->current_user);
                            
            
                            $status = $crnt_stage->jwf_assignment == 'invitation' ? 'w' : 'p';
                            $update_data = array(
                                'aflw_id' => $crnt_stage->aflw_id,
                                'aflw_status' => $status,
                                'aflw_returned_date' => NULL,
                                'aflw_posted_by' => $this->current_user['user_id'],
                                'aflw_posted_date' => date('Y-m-d H:i:s'));
            
                            $where = 'aflw_art_id = '.$art_id.' and aflw_id = '.$crnt_stage->aflw_id;
            
                            $rescind_status_id[] = $crnt_stage->aflw_id;
                            Article_flow::update_record($update_data, $where);
            
                            $status_childs_deleted = TRUE;
                            $current_aflw_id = $crnt_stage->aflw_id;
                           // DB::commit();
                        }
                    }
                    // end -- remove current stages child status stages if the stage assignment type is invitation/assignment 
                    $has_author_stage = FALSE;
                    $stgFlg =   0;
                    if ($status_childs_deleted != TRUE)
                    { 
                        // start -- make parent stage/s in progress
                        // get parent stages
                        
                        /* Get enabled parent stages Starts */
                        $available_parent_stages=$crnt_stage->jwf_parent_stages;
                        $available_parent=json_decode($available_parent_stages,TRUE);
                        if(count($available_parent)>1)
                        {
                        $select='group_concat(jwf_id) as jwfids';
                        // DB::enableQueryLog();
                        $current_aflw_level=$crnt_stage->aflw_level;
                        if($crnt_stage->jwf_flow_proceed_type!='manual')
                        {
                            $last_flw_level=$current_aflw_level-3;
                        }
                        else
                        {
                            $last_flw_level=$current_aflw_level-1;
                        }
                        $where= "aflw_art_id =".$art_id." and aflw_level between ".$last_flw_level." and ".$current_aflw_level;
                        //$where=" aflw_art_id=".$art_id;
                        $where_in['aflw_jwf_id'] = $available_parent;
                        $getvailable_stage = Generic_flows::get_artcle_flow($select, $where, $where_in, 'aflw_level DESC, aflw_id ASC');
                        $available_parent_stages=json_encode(explode(',',$getvailable_stage[0]->jwfids));
                       }
                        $enabled_parent_stages  =   $this->get_enabled_parent($crnt_stage->aflw_jwf_id, $available_parent_stages);
                        $parent_stage_ids       =   array();
                        foreach ($enabled_parent_stages as $parent)
                        {
                            if ($parent->jwf_disable_status == 'n')
                                $parent_stage_ids[] = $parent->jwf_id;
                        } 
                        
                        if($parallel_workflow_set == TRUE)
                        {
                            $parent_stage_ids = $para_mov_arr;
                        }
                        
                        /* Get enabled parent stages Ends */
                        $select         =   'aflw_id, aflw_level, aflw_status,aflw_usr_id, jwf_stage_type, jwf_child_stages, jwf_assignment,jwf_role_id, aflw_skip_review, jwf_flow_proceed_type, jwf_id, jwf_fwm_id,jwf_stage_name';
                        /*$where          =  "aflw_art_id ={$art_id} AND aflw_parent_flow_id IS NULL AND aflw_level IN(SELECT MAX(aflw_level) from {$article_flow_table} as afl_tbl WHERE afl_tbl.aflw_jwf_id = c_flw.aflw_jwf_id and afl_tbl.aflw_art_id = c_flw.aflw_art_id) ";*/
                        $where          =  "aflw_art_id ={$art_id} AND aflw_parent_flow_id IS NULL";
                        $where_in       =   NULL;
                        //code is commented because this is not present in review2 and the warning is not displaying
                        /*if(count($parent_stage_ids) > 0){
                            // check the parent stg exists in the article flow table
                            foreach ($parent_stage_ids as $par_stg)
                            {
                                $this_stg_exits     =   Article_flow::get_single_record('count(`aflw_id`) as cnt', "aflw_art_id ={$art_id} AND aflw_jwf_id = {$par_stg}");
                                if($this_stg_exits->cnt != 0) {
                                    $stgFlg++;
                                }
                            }
                            if($stgFlg == 0) {
                                $prev_stg_lvl   =   $crnt_stage->aflw_level - 1;
                                $prev_stg_flw     =   Article_flow::get_single_record('aflw_jwf_id', "aflw_art_id ={$art_id} AND aflw_level = {$prev_stg_lvl}");
                                if(isset($prev_stg_flw)) {
                                    unset($parent_stage_ids);
                                    $parent_stage_ids[]   =  $prev_stg_flw->aflw_jwf_id;
                                } 
                            }
                            $where_in['aflw_jwf_id']       =   $parent_stage_ids;
                        }*/
                        $where_in['aflw_jwf_id']       =   $parent_stage_ids;
                        $parent_stages  =   Generic_flows::get_artcle_flow($select, $where, $where_in, 'aflw_level DESC, aflw_id ASC');
                        
                        if ($parent_stages->isEmpty())
                        {
                            $return = array(
                                'status' => 'warning', 'msg' => customTrans('viewarticle.article_restrict_rescind_new_stage')
                            );
                            return  $this->warning('Warnings',200,$return,'warning');
                        }
                        $update_data            =   array();
                        $child_stages_in        =   array();
                        $aflw_parent_flow_ids   =   array();
                        $parent_flow_ids        =   array();

                      

                        /* author role ids :  to check next stage is author satge */
                        $author_role_ids    =   array();
                        $author_roles       =   Roles::get_all_records('role_id', 'role_assigned_role = "author"');
                        if(!$author_roles->isEmpty()) {
                            foreach ($author_roles as $au) {
                                $author_role_ids[] = $au->role_id;
                            }
                        }
                        $advanced_flow          =   $this->rescind_advanced_flow($art_id,$crnt_stage,$current_stage->aflw_jwf_id,$journal_id,$jnl_user_role);
                        if(count($advanced_flow['remove_flows']) > 0 && $es_article == TRUE)
                        {
                            foreach($advanced_flow['remove_flows'] as $key => $single_flow)
                            {
                                if(!in_array($single_flow,$flows_to_be_removed))
                                {
                                    array_push($flows_to_be_removed,$single_flow);
                                }
                            }
                        }
                        $advanced_flow = $advanced_flow['status'];
                        $stage_id_arr=array();
                        foreach ($parent_stages as $stg)
                        {
                            if($stg->jwf_stage_type=="author_submission" && $crnt_stage->aflw_level>2)
                            {
                               continue;
                            }
                            if(!in_array($stg->jwf_id, $stage_id_arr))
                            {
                                array_push($stage_id_arr,$stg->jwf_id);
                            }
                            else
                            {
                                continue;
                            }
                            if (in_array($stg->jwf_role_id, $author_role_ids))
                            {
                                $has_author_stage = TRUE;
                            }
                            // only considering parent stages with same level
                            /*if ($stg->aflw_level != $parent_stages[0]->aflw_level && $advanced_flow == FALSE)
                            {
                                break;
                            }*/
                            $immediate_parent_status = $parent_stages[0]->aflw_id; // to delete immediate child stages, after parent status
                            $status = 'a';
                            if ($stg->jwf_assignment != 'self_service')
                            {
                                $status = $stg->jwf_assignment == 'invitation' ? 'w' : 'p';
                            }
                            /* Task #225  JPR-447
                            Rescind a paper from production to enable licence form to be completed after author requesting changes */
                            if ($crnt_stage->aflw_status == 'c' && $crnt_stage->jwf_stage_type == 'production' && isset($this->current_client->functionality->cfty_enable_rescind_request) && $this->current_client->functionality->cfty_enable_rescind_request == 'y' && $parent_stages[0]->jwf_stage_type == 'payment')
                            {
                                $status = 'a'; // change the aflw_status as a if parent stage is payment stage,and cancellation of payment is done
                            }
                            if ($stg->jwf_stage_type == 'copyright')
                            {
                                $clear_payment_order_status = $stg->aflw_id;
                            }

                            $rescind_status_id[]    =   $stg->aflw_id;
                            $proceedingArr  =   $this->fetch_client_proceeding_config_array('article-proposal');
                            $art_sub_by = Articles::get_single_record_with_bind_cond('art_submitted_by',['art_id' => $art_id]);
                            $flow_role = Roles::find($stg->jwf_role_id)?->role_assigned_role;
                            $update_item = array(
                                'aflw_id' => $stg->aflw_id,
                                'aflw_status' => $status,
                                'aflw_returned_date' => NULL,
                                'aflw_posted_by' => $this->current_user['user_id'],
                                'aflw_posted_date' => date('Y-m-d H:i:s'),
                                'aflw_skip_review' => ($stg->aflw_skip_review == 'y') ? 'n' : $stg->aflw_skip_review
                                );
                             
                            if (
                                    !empty($proceedingArr['change_submitting_author']) &&
                                    !empty($flow_role) &&
                                    strcasecmp($flow_role, 'author') === 0 &&
                                    !empty($art_sub_by?->art_submitted_by) &&
                                    $art_sub_by->art_submitted_by !== $stg->aflw_usr_id
                                ) {
                    
                               $update_item['aflw_usr_id'] = $art_sub_by->art_submitted_by;
                                        }
                               
                            $update_data[] = $update_item;
                            /* Get enabled parent stages Starts */
                            $enabled_child_stages = $this->get_enabled_child($crnt_stage->aflw_jwf_id, $stg->jwf_child_stages, TRUE);
                            $child_stage_ids = array();
                            foreach ($enabled_child_stages as $childs)
                            {
                                $child_stage_ids[] = $childs->jwf_id;
                            }
                            /* Get enabled parent stages Ends */

                            // child stages to be deleted (includes current stage also)
                            $child_stages_in    =   array_unique(array_merge($child_stages_in, $child_stage_ids));

                            // to make the stages which are from parent flow, in progress
                            $parent_flow_ids[]  =   $stg->aflw_id;

                            // set flag if rescind to submission stage
                            if ($stg->jwf_stage_type == 'author_submission' && $change_article_status == false)
                            {
                                $change_article_status = true;
                            }
                            //set flag if rescind to accept stage
                            if ($stg->jwf_stage_type == 'accept' && $change_art_decision_status == FALSE)
                                $change_art_decision_status = TRUE;
                        }
                    // }
                    if ($immediate_parent_status != NULL)
                        $current_aflw_id = $immediate_parent_status;

                    if($current_aflw_id != '')  {
                        $rescind_record =   array(
                                                'rsc_current_flow_id' => $current_aflw_id,
                                                'rsc_source_jwf_id' => $crnt_stage->aflw_jwf_id,
                                                'rsc_reason' => $rescind_reason,
                                                'rsc_action' => 'rescind'
                                            );  
                        $record_id = Rescind_reset_record::insert_record($rescind_record, $this->current_user);
                        if(!$record_id) {
                            $return = array(
                                'status' => 'failed', 'msg' => customTrans('viewarticle.art_rescind_failed')
                            );
                            return  $this->warning('Warnings',200,$return,'warning');
                        }
                    } else {
                        $return = array(
                            'status' => 'failed', 'msg' => customTrans('Could not rescind :article')
                        );
                        return  $this->warning('Warnings',200,$return,'warning');
                    }
                    $check_last_entry = '';
                    if(!empty($rescind_status_id))
                    {
                        $check_last_entry = DB::table(Article_flow::$tbk_table)->whereIn('aflw_id', $rescind_status_id)
                        ->orderBy('aflw_posted_date', 'desc')
                        ->first();
                    }  
                    //echo  '<pre>'; print_r($update_data); die;
                    /*$update_data[]          =   array(
                                                'aflw_id' => $stg->aflw_id,
                                                'aflw_status' => $status,
                                                'aflw_returned_date' => NULL,
                                                'aflw_posted_by' => $this->current_user['user_id'],
                                                'aflw_posted_date' => date('Y-m-d H:i:s'),
                                                'aflw_skip_review' => ($stg->aflw_skip_review == 'y') ? 'n' : $stg->aflw_skip_review
                                                );*/
                    Article_flow::update_batch($update_data, 'aflw_id');

                    // Added  aflw_flow_operation inorder to distinguisg between delete and rescind viewing timeline
                    $rescind_data=array();
                    /* Task #225  JPR-447 Rescind a paper from production to enable licence form to be completed after author requesting changes */
                    //check whether the production stage is completed and client functionality to enable rescind request is ON/OFF
                    if ($crnt_stage->aflw_status == 'c' && $crnt_stage->jwf_stage_type == 'production' && isset($this->current_client->functionality->cfty_enable_rescind_request) && $this->current_client->functionality->cfty_enable_rescind_request == 'y')
                    {
                        //to avoid the duplication of 'production stage completed' while rescind,set the aflw_status as 'a'
                        $rescind_data = array(
                            'aflw_flow_operation' => "d", 'aflw_status' => "a"
                        );
                        //if the parent stage is payment,set the status in rvw_payment_order table as CL
                        if ($parent_stages[0]->jwf_stage_type == 'payment')
                        {
                            Payment_order::update_record(array('pmt_transaction_status'=>'CL'), "pmt_ord_art_id = {$art_id}", $this->current_user);
                        }
                    }
                    else
                    {
                        $rescind_data = array('aflw_flow_operation' => "d");
                    } 
                    Article_flow::update_record($rescind_data, "aflw_id= {$current_status_id}", $this->current_user);

        
                    if ($clear_payment_order_status != NULL)
                    {
                        Payment_order::delete_records(array('pmt_ord_art_id' => $art_id),'',$this->current_user);
                    }

                    // remove copyright record from copyrights table
                    if($current_stage_type == 'copyright') {
                        $Copyright  = new \App\Models\Copyright();
                        $copy_condi = "crt_art_id={$art_id} and crt_aflw_id={$current_status_id} ";
                        $copy_res   = $Copyright::get_single_record('crt_id', $copy_condi);
                        if(isset($copy_res) && !empty($copy_res->crt_id)) {
                            $Copyright::delete_records(array('crt_id' => $copy_res->crt_id));
                        }
                    }
                    // start -- make the stages which are from parent flow, in progress 
			        /* Task #225  JPR-447 Rescind a paper from production to enable licence form to be completed after author requesting changes */
                  
                    $parent_flow_ids =   implode(",",$parent_flow_ids);
                    $update_data    =   array(
                                        'aflw_status' => 'a', 'aflw_returned_date' => NULL
                                        );
                    $where          =   "aflw_parent_flow_id IN ({$parent_flow_ids}) and aflw_status = 'c'";
                    Article_flow::update_record($update_data, $where, $this->current_user);
                    // end -- make the stages which are from parent flow, in progress 

                       /* TASK #6282 Implement Review Article grading System */
                       $Article_Rating = new \App\Models\Article_rating(); 
                       $rate_data=$Article_Rating::get_single_record_with_bind_cond('count(rat_id) AS cnt',array('rat_art_id'=>$art_id,'rat_aflw_id'=>$current_status_id));
                       if(!empty($rate_data)&&isset($rate_data->cnt)&&$rate_data->cnt>0)
                       {
                    
                        $Article_Rating::delete_records(array('rat_art_id'=> $art_id,'rat_aflw_id'=>$current_status_id), '', $this->current_user);
                       }
                    /*  TASK  #6282 END     */

                    // if($current_aflw_id != '') {
                        $new_stage_user                 =   Article_flow::get_single_record('aflw_usr_id', "aflw_id = {$current_aflw_id}");
                        $email_data                     =   new StdClass;
                        $email_data->article_id         = $article_details->art_id;
                        $email_data->action             = 'rescind';
                        $email_data->artp_id            = $article_details->art_artp_id;
                        $email_data->art_artp_id        = $article_details->art_artp_id;
                        $email_data->jnl_id             = $article_details->jnl_id;
                        $email_data->jnl_journal_code   = $article_details->jnl_journal_code;
                        $email_data->aflw_id            = $current_aflw_id;

                        $stage_email_ids = array();
                        if ($email_tmpls != '' && $this->current_client->functionality->cfty_manage_on_complete_email == 'y')
                        {
                            $stage_email_ids=$email_tmpls;
                            
                        }
                        // Task #969 Email related issue while rescind
                        if (!empty($stage_email_ids))
                        {
                            $has_author_stage = TRUE;
                        }
                        $dest_email_templates = array();
                        if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' && $has_author_stage == TRUE)
                        {
                            if (!empty($stage_email_ids))
                            {
                                $dest_condition = ' stage_etmp_action = "rescind_destination" AND stage_etmp_id in(' . join(",", $stage_email_ids) . ')';
                                $dest_email_templates = Stage_email_templates::get_all_records('*, stage_etmp_content AS stage_etmp_email_template', $dest_condition);
                            }
                        }
                        else
                        {
                            $dest_condition = ' stage_etmp_action = "rescind_destination" AND  setr_jwf_id in (' . join(",", $parent_stage_ids) . ')';
                            $dest_email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $dest_condition);
                        }
                        if (!empty($dest_email_templates))
                        {
                            foreach ($dest_email_templates as $dest)
                            {
                                $article_notification = array();
                                if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' && $has_author_stage == TRUE)
                                {
                                    $where = "ane_stage_etmp_id={$dest->stage_etmp_id} AND  ane_next_jwf_id = {$crnt_stage->aflw_jwf_id} AND ane_prev_aflw_id ={$current_status_id}";
                                    $article_notification = Article_notification_emails::get_single_record('*', $where);
                                    if (!empty($article_notification))
                                    {
                                        $dest->stage_etmp_to = $article_notification->ane_to;
                                        $dest->stage_etmp_cc = $article_notification->ane_cc;
                                        $dest->stage_etmp_bcc = $article_notification->ane_bcc;
                                        $dest->stage_etmp_cust_to = $article_notification->ane_cust_to;
                                        $dest->stage_etmp_cust_cc = $article_notification->ane_cust_cc;
                                        $dest->stage_etmp_cust_bcc = $article_notification->ane_cust_bcc;
                                        $dest->stage_etmp_subject = $article_notification->ane_subject;
                                        $dest->stage_etmp_email_template = $article_notification->ane_content;
                                        $dest->stage_etmp_reply_to = $article_notification->ane_reply_to;
                                    }
                                }
                            }
                        }
                        
                        $source_email_templates = array();
                        if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' && $has_author_stage == TRUE)
                        {
                            if (!empty($stage_email_ids))
                            {
                                $source_condition = ' stage_etmp_action = "rescind_source" AND stage_etmp_id in(' . join(",", $stage_email_ids) . ') AND stage_etmp_stage_type="' . $current_stage_type . '"';
                                $source_email_templates = Stage_email_templates::get_all_records('*, stage_etmp_content AS stage_etmp_email_template', $source_condition);
                            }
                        }
                        else
                        {
                            $source_condition = "stage_etmp_journal_id={$article_details->jnl_id} and stage_etmp_stage_type= '{$current_stage_type}' and stage_etmp_action= 'rescind_source' and setr_jwf_id={$crnt_stage->aflw_jwf_id}";
                            $source_email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $source_condition);
                        }

                        if (!empty($source_email_templates))
                        {
                            foreach ($source_email_templates as $sorc)
                            {
                                $article_notification = array();
                                if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' && $has_author_stage == TRUE)
                                {
                                    $article_notification = Article_notification_emails::get_single_record('*', "ane_stage_etmp_id={$sorc->stage_etmp_id} and ane_aflw_id={$current_status_id}");
                                    if (!empty($article_notification))
                                    {
                                        $sorc->stage_etmp_to = $article_notification->ane_to;
                                        $sorc->stage_etmp_cc = $article_notification->ane_cc;
                                        $sorc->stage_etmp_bcc = $article_notification->ane_bcc;
                                        $sorc->stage_etmp_cust_to = $article_notification->ane_cust_to;
                                        $sorc->stage_etmp_cust_cc = $article_notification->ane_cust_cc;
                                        $sorc->stage_etmp_cust_bcc = $article_notification->ane_cust_bcc;
                                        $sorc->stage_etmp_subject = $article_notification->ane_subject;
                                        $sorc->stage_etmp_email_template = $article_notification->ane_content;
                                        $sorc->stage_etmp_reply_to = $article_notification->ane_reply_to;
                                    }
                                }
                            }
                        }
                        
                        // start -- delete child stages(includs current stage)
                        $where      = "aflw_art_id={$art_id} and aflw_id > {$immediate_parent_status}"; // child status record after immediate parent
                        $where_in   =   array();
                        if (count($child_stages_in) > 0)
                        {
                           $where_condition    = 'aflw_art_id = ' . $art_id . ' and aflw_id > ' . $immediate_parent_status . ' and aflw_jwf_id IN (' . implode(',', $child_stage_ids) . ')';
                           // if prev wrkflw stage not found in the article flow tbl, 
                           if($stgFlg == 0) {
                            $where_condition    = 'aflw_art_id = ' . $art_id . ' and aflw_id > ' . $immediate_parent_status . ' and aflw_jwf_id = ' .$crnt_stage->aflw_jwf_id. '';
                           }

                           $get_deleting_flows = Article_flow::get_all_records('aflw_id,aflw_art_id,aflw_usr_id',$where_condition);
                           if($es_article == TRUE)
                           {
                            if(count($get_deleting_flows) > 0)
                            {
                                foreach($get_deleting_flows as $single_flow)
                                {
                                    if(!in_array($single_flow->aflw_id,$flows_to_be_removed))
                                    {
                                        array_push($flows_to_be_removed,$single_flow->aflw_id);
                                    }
                                }
                            }
                           }
                        // Delete Flag  from form
                        $formatted_journal_code = '_' . $jnlcode;
                        $delvalues = array();
                        /*
                        $get_review_ids = Article_flow::get_all_records('aflw_id', "aflw_id = {$current_status_id}");
                        foreach ($get_review_ids as $get_review_id)
                        {
                            array_push($delvalues, $get_review_id->aflw_id);
                        }
                        */
                        
                        array_push($delvalues, $current_status_id);
                            Article_flag::delete_generic_form_flag_data($formatted_journal_code,'gdata_artflw_id',$delvalues, $this->current_user);
                          //Task #122  The article is not listed for the privileged user after it is rescinded
                          if(!empty($get_deleting_flows) > 0)
                          {
                            foreach($get_deleting_flows as $flRm)
                            {
                                $this->mngReviewerversion($flRm->aflw_art_id,$flRm->aflw_id,$flRm->aflw_usr_id,false);
                            }
                          }
                          Article_generic_form_data::delete_generic_form_data($formatted_journal_code, 'gdata_artflw_id', $delvalues,$this->current_user);
                          Article_flow::delete_records($where_condition, '', $this->current_user);
                        }
                        // end -- delete child stages(includs current stage)
                        if($es_article == TRUE)
                        {
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            if(isset($es_api_data['rescind_stage']))
                            {
                                $apiUrl = $es_api_data['rescind_stage'];
                                $last_completed_aflw = $check_last_entry->aflw_id ? $check_last_entry->aflw_id : '';
                                $data_to_editor = array('art_id' => $art_id,'delete_flows' => $flows_to_be_removed,'toFlowId' => $last_completed_aflw,'currentFlowId' => $current_status_id);
                                $data_to_editor = http_build_query($data_to_editor);
                                $response = $this->es_curl_request($apiUrl,$data_to_editor);
                                $response = json_decode($response);
                                $message_to_rvrite =customTrans('viewarticle.stage_rescind_rvrite');
                                $message_to_rvrite = str_replace('##STAGE_NAME##', $crnt_stage->jwf_stage_name,$message_to_rvrite);
                                $return['message_to_rvrite'] = $message_to_rvrite;
                            }
                        }
                        // change article status and article stub status if rescind to article submission
                        if ($change_article_status == true)
                        {
                            $art_stub   =   ($article_details->art_stub == 'i') ? 'y' : 'n';	
                            Articles::update_record(array(
                                'art_status' => 'n',
                                'art_stub' => $art_stub), "art_id = {$art_id}", $this->current_user);
                            }
                            
                            // change article decision status if rescind to accept stage
                            if ($change_art_decision_status == TRUE)
                            {
                                $generic_flow_table = (new \App\Models\Generic_flows())->getTable();

                                Articles::update_record(array(
                                    'art_status' => 'y'), "art_id = {$art_id}", $this->current_user);

                                    /**
                                 * Revert invitation stage article flow status from 'c (complete)' to 'w'
                                 */
                                $dt_time = date('Y-m-d H:i:s');
                                $update_stmt = 'UPDATE '.$article_flow_table.' JOIN '.$generic_flow_table.' ON aflw_jwf_id = jwf_id  SET  aflw_status = \'w\', aflw_posted_date = \''.$dt_time.'\',aflw_operation = \'e\'  WHERE jwf_assignment = \'invitation\' AND aflw_parent_flow_id IS NULL AND aflw_status = \'c\' AND aflw_level <= '.$current_stage->aflw_level.' AND aflw_art_id ='.$art_id;
                                
                                Article_flow::execute_query($update_stmt,TRUE);
                            }

                                

                                if ($immediate_parent_status != NULL)
                                $current_aflw_id = $immediate_parent_status;
                                
                                if (!empty($source_email_templates))
                                {
                                    foreach ($source_email_templates as $sorc)
                                    {
                                        if (($current_stage_user != NULL && $sorc->stage_etmp_to == 'User') || $sorc->stage_etmp_to != 'User')
                                        {
                                            $touser_d = $send_mail_to = $send_mail_to_usr_ids = NULL;
                                            
                                            if ($sorc->stage_etmp_to == 'submit_author')
                                            {
                                                // #4544 Manage author  data listing(normalization)
                                                $tables = array(
                                                    'main_table' => $authors_table,
                                                    'join_table' => array(
                                                        $users_table => array($authors_table . '.auth_usr_id', $users_table . '.usr_id', "left")
                                                    ));
                                                    
                                                    $select_fields          =   'usr_email as auth_email';
                                                    $criteria               =   "auth_art_id = {$article_details->art_id} and auth_usr_id = {$article_details->art_submitted_by}";
                                                    $sub_author             =   Authors::get_results_using_joins($tables,$select_fields,$criteria,'single');
                                                    $send_mail_to           =   $sub_author->auth_email;
                                                    $send_mail_to_usr_ids   =   $touser_d = $article_details->art_submitted_by;
                                                }
                                                elseif ($sorc->stage_etmp_to == 'User')
                                                {
                                                    $user_record            =   User::get_single_record('usr_email', "usr_id = {$current_stage_user}");
                                        $touser_d               =   ($sorc->stage_etmp_to == 'User') ? $current_stage_user : '';
                                        $send_mail_to           =   ($sorc->stage_etmp_to == 'User') ? $user_record->usr_email : '';
                                        $send_mail_to_usr_ids   =   $touser_d;                                       
                                    }
                                    $send_mail_to = trim($send_mail_to);
                                    $send_mail_to=str_replace(' ', '', $send_mail_to);
                                    $send_mail_to_usr_ids = trim($send_mail_to_usr_ids);
                                    $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);
                                    $email_data->user_email         = $send_mail_to;
                                    $email_data->user_id            = $touser_d;
                                    $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
                                    $email_data->jnl_id             =   $journal_id;

                                    $this->send_mail_notification($sorc, $email_data,$jnl_user_role);
                                }
                            }
                        }
                        
                        if (!empty($dest_email_templates))
                        {
                            foreach ($dest_email_templates as $dest)
                            {
                                if (($new_stage_user->aflw_usr_id != NULL && $dest->stage_etmp_to == 'User') || $dest->stage_etmp_to != 'User')
                                {
                                    $touser_d = $send_mail_to = $send_mail_to_usr_ids = NULL;
                                    
                                    if ($dest->stage_etmp_to == 'submit_author')
                                    {
                                        // #4544 Manage author  data listing(normalization)
                                        $tables = array(
                                            'main_table' => $authors_table,
                                            'join_table' => array(
                                                $users_table => array($authors_table . '.auth_usr_id', $users_table . '.usr_id', "left")
                                            ));
                                            $select_fields  =   'usr_email as auth_email';
                                            $criteria       =   "auth_art_id = {$article_details->art_id} AND auth_usr_id = {$article_details->art_submitted_by}";
                                            $sub_author     =   Authors::get_results_using_joins($tables,$select_fields,$criteria,'single');
                                            $send_mail_to   =   $sub_author->auth_email;
                                            $send_mail_to_usr_ids = $touser_d = $article_details->art_submitted_by;
                                        }
                                        elseif ($dest->stage_etmp_to == 'User')
                                        {
                                            $user_record    =   User::get_single_record('usr_email', "usr_id = {$new_stage_user->aflw_usr_id}");
                                            $touser_d       =   ($dest->stage_etmp_to == 'User') ? $new_stage_user->aflw_usr_id : '';
                                        $send_mail_to   =   ($dest->stage_etmp_to == 'User') ? $user_record->usr_email : '';
                                        $send_mail_to_usr_ids = $touser_d;
                                    }
                                    $send_mail_to = trim($send_mail_to);
                                    $send_mail_to=str_replace(' ', '', $send_mail_to);
                                    $send_mail_to_usr_ids = trim($send_mail_to_usr_ids);
                                    $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);
                                    $email_data->user_email         =   $send_mail_to;
                                    $email_data->user_id            =   $touser_d;
                                    $email_data->mail_recipient_ids =   $send_mail_to_usr_ids;
                                    $email_data->jnl_id             =   $journal_id;
                                    $this->send_mail_notification($dest, $email_data,$jnl_user_role);
                                }
                            }
                        }
                    }
                        /*
                        * model info to show on rescind
                        */
                        $select     =   'aflw_id,jwf_role_id,jwf_stage_name, aflw_status, aflw_usr_id, jwf_assignment, jwf_parent_user_roles, jwf_who_can_invite, jwf_stage_type,'
                                        . 'IF(jwf_assignment = "self_service", '
                                        . '(SELECT role_name FROM rvw_roles WHERE role_id = jwf_role_id), "") '
                                        . 'AS user_role';

                        $where      =   'aflw_id IN( ' . implode(',', $rescind_status_id) . ')';
                        $group_by   =   array('jwf_stage_name', 'aflw_usr_id');
                        $next_stage_details = Article_flow::get_generic_flow($select, $where, null, $group_by);

                        $data               =   array();
                        $loggined_role_id   =   $curr_role_id;
                        $article_details->artp_id =$art_type_id;
                        $Article_types = new \App\Models\Article_types();
                        $article_type_data=$Article_types::get_single_record('artp_fwm_id ',"artp_id=:artp_id",NULL,'',NULL, array("artp_id"=>$art_type_id));
                        $article_details->artp_fwm_id=$article_type_data->artp_fwm_id;
                        $article_privilages = $this->article_privilages($article_details, $current_status_id, $jnlcode);
                        $privileged_user = $article_privilages['privilaged'];
                        $isauthor = $article_privilages['author'];
                        $return['stageid']='';
                        $privileged_user = $article_privilages['privilaged'];
                        $return['privileged_user'] = $privileged_user;
                        $return['isauthor'] = $isauthor;
                        $redirect_after_complete = 'n';
                        if (!empty($next_stage_details))
                        {
                            
                            /*$return['stageid']=$this->encrypt_data($next_stage_details[0]->aflw_id);
                            $sql_raw_query  = 'SELECT aflw_id from rvw_article_flow where aflw_id<'.$current_status_id.' and aflw_level<'.$crnt_stage->aflw_level.' and aflw_art_id='.$article_details->art_id.' order by aflw_id desc LIMIT 1,1';
                            $article_prev      =   Article_flow::get_records_by_raw_query($sql_raw_query);
                            if(isset($article_prev[0]->aflw_id))
                            {
                            $return['prev_aflw_id'] = $this->encrypt_data($article_prev[0]->aflw_id); 
                            }
                            else
                            {
                                $return['prev_aflw_id'] = '';
                            }*/
                            foreach ($next_stage_details as $val)
                            {   
                                
                                if($val->jwf_stage_type == "accept" && isset($this->current_client->functionality->cfty_include_short_metadata_file) && $this->current_client->functionality->cfty_include_short_metadata_file == 'y')
                                {
                                    
                                    $Attachment_files = new \App\Models\Attachment_files();
                                    $pdf_review_cnd= "atmnt_art_id=$art_id and atmnt_metadata_file='y'";
                                    $attach_status = $Attachment_files::get_single_record('atmnt_id,atmnt_orginal_upload_path,atmnt_file_name', $pdf_review_cnd);
                                    if(isset($attach_status->atmnt_id) && !empty($attach_status->atmnt_id))
                                    {
                                            $result = $Attachment_files::delete_records("atmnt_id={$attach_status->atmnt_id}", '', $this->current_user);
                                            Storage::disk('public')->delete('uploads/'.$attach_status->atmnt_orginal_upload_path.'/'.$attach_status->atmnt_file_name);
                                            
                                        if (isset($this->current_client->functionality->cfty_enable_upload_s3_bucket) && $this->current_client->functionality->cfty_enable_upload_s3_bucket == 'y')
                                        {
                                            Storage::disk('s3')->delete('uploads/'.$attach_status->atmnt_orginal_upload_path.'/'.$attach_status->atmnt_file_name);
                                        }
                                    }
                                }   


                                $assign_permission = '';
                                $assigning_roles = json_decode($val->jwf_parent_user_roles);
                                if (!empty($assigning_roles))
                                {
                                    $article_assign_permission = $this->get_users_in_role($article_details->art_id, $article_details->art_artp_id, $assigning_roles, $journal_id, $jnlcode);
                                }
                                $invite_permission = '';
                                //role who is inviting users 
                                $inviting_roles = json_decode($val->jwf_who_can_invite);
                                if (!empty($inviting_roles))
                                {
                                    $article_invite_permission = $this->get_users_in_role($article_details->art_id, $article_details->art_artp_id, $inviting_roles, $journal_id, $jnlcode);
                                }
                                if (!empty($article_assign_permission))
                                {
                                    $data['who_can_assign'] = $article_assign_permission;
                                }
                                if (!empty($article_invite_permission))
                                {
                                    $data['who_can_invite'] = $article_invite_permission;
                                }
                                $val->user_full_name = '';
                                $val->who_can_assign = '';
                                $val->who_can_invite = '';
                
                                if ($val->aflw_usr_id != '')
                                {
                                    $array_data['user_id']      = $val->aflw_usr_id;
                                    $array_data['journal_id']   = $journal_id;
                                    $array_data['flag']         = TRUE;
                                    $array_data['article_id']   = $art_id;

                                    $val->user_full_name = $this->get_user_display_name($array_data);            
                                    $next_array[$val->jwf_stage_name]['name'][] = $val->user_full_name;
                                    if ($val->aflw_usr_id == $this->current_user['user_id'] && $val->jwf_role_id == $loggined_role_id)
                                    {
                                        $redirect_after_complete = 'n';
                                    }
                                }
                
                                // start -- checking assignment types and getting roles of that 
                                if ($val->jwf_assignment == 'manual' || $val->jwf_assignment == 'invitation')
                                {
                                    // role who is assigning users 
                                    $assigning_roles = json_decode($val->jwf_parent_user_roles);
                
                                    $select = 'GROUP_CONCAT(role_name SEPARATOR ",") AS roles';
                                    $where  = 'role_id IN(' . implode(',', $assigning_roles) . ')';
                                    $who_can_assign = Roles::get_single_record($select, $where);
                
                                    $val->who_can_assign = $who_can_assign->roles;
                                    $next_array[$val->jwf_stage_name]['who_can_assign'] = $who_can_assign->roles;
                                    $next_array[$val->jwf_stage_name]['jwf_assignment'] = $val->jwf_assignment;
                                    if (in_array($loggined_role_id, $assigning_roles))
                                    {
                                        $redirect_after_complete = 'n';
                                    }            
                                    if ($val->jwf_assignment == 'invitation')
                                    {
                                        // role who is inviting users 
                                        $inviting_roles =   json_decode($val->jwf_who_can_invite);            
                                        $select         =   'GROUP_CONCAT(role_name SEPARATOR ",") AS roles';
                                        $where          =   'role_id IN(' . implode(',', $inviting_roles) . ')';
                                        $who_can_invite =   Roles::get_single_record($select, $where);
                
                                        $val->who_can_invite = $who_can_invite->roles;
                                        $next_array[$val->jwf_stage_name]['who_can_invite'] = $who_can_invite->roles;
                                        if (in_array($loggined_role_id, $inviting_roles))
                                        {
                                            $redirect_after_complete = 'n';
                                        }
                                    }
                                    $select = 'GROUP_CONCAT(role_id SEPARATOR ",") AS roles';
                                    $where = 'role_assigned_role ="staff"';
                                    $core_role_staff = Roles::get_single_record($select, $where);
                                    $core_role_staff_id = $core_role_staff->roles;
                                    $core_role_staffid_arr = explode(",", $core_role_staff_id);
                                    $staff_assigned = FALSE;
                                    $invite_staff = array_intersect($core_role_staffid_arr, $inviting_roles);
                                    $assign_staff = array_intersect($core_role_staffid_arr, $assigning_roles);
                                    if (count($invite_staff) > 0 || count($assign_staff) > 0) {
                                        $merge_arr = array_merge($invite_staff, $assign_staff);
                                        //check assignment exist , if yes then $staff_assigned
                                        $cond = 'usra_role_id IN(' . implode(',', $merge_arr) . ') and usra_art_id=' . $article_details->art_id;
                                        $User_articles = new \App\Models\User_articles;
                                        $record = $User_articles::get_single_record('count(usra_id) as cnt', $cond);
                                        if ($record->cnt > 0)
                                            $staff_assigned = TRUE;
									}          
                                    $next_array[$val->jwf_stage_name]['staff_assigned'] = $staff_assigned;
                                    $select_des         = 'role_name';
                                    $where_des          = 'role_id =' . $val->jwf_role_id;
                                    $user_assign_role   = Roles::get_single_record($select_des, $where_des);
                
                                    $next_array[$val->jwf_stage_name]['user_assign_role'] = $user_assign_role->role_name;
                                    $next_array[$val->jwf_stage_name]['assigned_usrs'] = isset($data['who_can_assign']) ? $data['who_can_assign'] : '';
                                    $next_array[$val->jwf_stage_name]['invite_usrs'] = isset($data['who_can_invite']) ? $data['who_can_invite'] : '';
                                }
                                $next_array[$val->jwf_stage_name]['user_role'] = $val->user_role; 
                                $next_array[$val->jwf_stage_name]['stage_name'] = $val->jwf_stage_name;           
                                // end -- checking assignment types and getting roles of that 
                
                                if ($val->jwf_role_id == $loggined_role_id)
                                {
                                    $redirect_after_complete = 'n';
                                }
                            }
                            $return['next_array'] = $next_array;
                            $return['redirect_after_complete'] = $redirect_after_complete;
                            if ($change_article_status == TRUE && count($rescind_status_id) > 0)
                            {
                                $return['redirecttostatus'] = 'dashboard';
                            }
                            else
                            {
                                $return['redirecttostatus'] = 'view-article';
                            }
                            $return['next_aflw_id'] = $this->encrypt_data($rescind_status_id[0]);
								
                        }
                        $url_segmnt = '';
                        if($production_flag == TRUE)
                        {
                            // $url_segmnt     =   '-production';
                            $stage_attach   =   Production_attachment_files::get_single_record('count(paf_id) as cnt', "paf_aflw_id = {$current_status_id}"); 
                            
                            if($stage_attach->cnt == 0 && $current_status_id != '')
                            {
                                $pro_stage_path = 'uploads/' . $art_data->art_article_upload_path.'/production/';
                                if(file_exists($pro_stage_path.$current_status_id))
                                {
                                    chdir($pro_stage_path);                                
                                    $cmd = 'rm -r '.$current_status_id;
                                    shell_exec($cmd);
                                }
                            }
                        }
                        DB::commit();
                        return $this->success('Success',200,$return); 
                    // } else {
                    //     $return = array(
                    //         'status' => 'failed', 'msg' => customTrans('viewarticle.missing_parameters')
                    //     );
                    //     return  $this->warning('Warnings',200,$return,'warning');
                    // }  
                                    
                } else {
                    $return = array(
                        'status' => 'failed', 'msg' => customTrans('viewarticle.missing_parameters')
                    );
                    return  $this->warning('Warnings',200,$return,'warning');
                }
            }

        } catch (\exception $e) {
            // $this->customErrorAction('rescind_article',$e);
            // DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }

    public function rescind_advanced_flow($art_id,$crnt_stage,$jwf_flow_id,$journal_id,$jnl_user_role)
	{
        $select     =   'aflw_id, aflw_level, aflw_status, jwf_stage_type, jwf_child_stages, jwf_assignment,jwf_role_id, aflw_skip_review, jwf_flow_proceed_type, jwf_id, jwf_fwm_id'; 
		$where      =   "aflw_art_id = {$art_id}";
        $where_in   =   array();
        $available_parent_stages=$crnt_stage->jwf_parent_stages;
        $available_parent=json_decode($available_parent_stages,TRUE);
        if(count($available_parent)>1)
        {
        $grpselect='group_concat(jwf_id) as jwfids';
        $current_aflw_level=$crnt_stage->aflw_level;
        $last_flw_level=$current_aflw_level-3;
        $where= "aflw_art_id =".$art_id." and aflw_level between ".$last_flw_level." and ".$current_aflw_level;
        $where_in['aflw_jwf_id'] = $available_parent;
        $getvailable_stage = Generic_flows::get_artcle_flow($grpselect, $where, $where_in, 'aflw_level DESC, aflw_id ASC');
        $available_parent_stages=json_encode(explode(',',$getvailable_stage[0]->jwfids));
        }
		$enabled_parent_stages = $this->get_enabled_parent($crnt_stage->aflw_jwf_id, $available_parent_stages);
        $advanced_flow = array();
		$parent_stage_ids = array();
		foreach ($enabled_parent_stages as $parent)
		{
			if ($parent->jwf_disable_status == 'n')
			{
				$parent_stage_ids[] = $parent->jwf_id;
			}
		} 
        $where_in['aflw_jwf_id']= $parent_stage_ids;
        $parent_stages_advanced = Generic_flows::get_artcle_flow($select, $where, $where_in, 'aflw_level DESC, aflw_id DESC');	
        $advanced_flow['status'] = FALSE;
        $advanced_flow['remove_flows'] = [];
        // if(!$parent_stages_advanced->isEmpty()) {
        if(isset($parent_stages_advanced[0]->aflw_id) && !empty($parent_stages_advanced[0]->aflw_id) && count($parent_stages_advanced)>1)
        {
            $aflw_level=$crnt_stage->aflw_level;
            $last_flw_level=$aflw_level-3;
            $possible_condition= "aflw_art_id =".$art_id." and aflw_level between ".$last_flw_level." and ".$aflw_level;
            $all_possi_aflw_id  = Article_flow::get_single_record("GROUP_CONCAT(aflw_id) as flows", $possible_condition);
			$paral_flow_condi   = "apfm_end_stg_jwf_id = ".$crnt_stage->aflw_jwf_id." AND apfm_aflw_id IN(".$all_possi_aflw_id->flows.")";
			$parallel_flows = Article_parallel_flow_movement::get_all_records("apfm_id", $paral_flow_condi);
            if(!$parallel_flows->isEmpty()) {
				foreach($parallel_flows as $single_parallel_flows)
				{
					$update_arr         =   array('apfm_status' => 'a');
					$update_condition   =   "apfm_id = {$single_parallel_flows->apfm_id}";
					$update_parallel    =   Article_parallel_flow_movement::update_record($update_arr, $update_condition,$this->current_user);
					$advanced_flow['status'] = TRUE;
				}
			}
		}
        
        $act_parent_stages  = Generic_flows::get_artcle_flow($select, $where, $where_in, 'aflw_level DESC, aflw_id DESC',TRUE);	
        //echo $act_parent_stages->aflw_id; die;
         //if($act_parent_stages->isEmpty() != 1 && ((isset($act_parent_stages[0]->jwf_flow_proceed_type) && $act_parent_stages[0]->jwf_flow_proceed_type == "advance") || (isset($act_parent_stages[0]->jwf_flow_proceed_type) && $act_parent_stages[0]->jwf_flow_proceed_type == "parallel")))
        if((isset($act_parent_stages->aflw_id) && !empty($act_parent_stages->aflw_id)) && ((isset($act_parent_stages->jwf_flow_proceed_type) && $act_parent_stages->jwf_flow_proceed_type == "advance") || (isset($act_parent_stages->jwf_flow_proceed_type) && $act_parent_stages->jwf_flow_proceed_type == "parallel")))
        {
            $raw_workflow   = Generic_flows::get_all_records('*', "jwf_fwm_id ={$act_parent_stages->jwf_fwm_id}"); 
			$this_workflow  = $this->process_flow($raw_workflow);

			$child_workflow_arr = array();
			$path_child_arr     = array();	
            if($this_workflow[$act_parent_stages->jwf_id]->jwf_child_stages !== '[]')
			{
                $child_flows =json_decode($this_workflow[$act_parent_stages->jwf_id]->jwf_child_stages);
                foreach($child_flows as $single_flow)
				{
					$flow_present = Article_flow::get_single_record('count(aflw_id) as count', "aflw_jwf_id = {$single_flow} AND aflw_art_id = {$art_id}");
						 
					if(!in_array($single_flow, $child_workflow_arr) && $flow_present->count > 0 && $single_flow != $jwf_flow_id)
					{
						array_push($child_workflow_arr, $single_flow);
						array_push($path_child_arr, $single_flow);
					}
				}
                foreach($child_workflow_arr as $ind_wrk_flw)
				{
                    if($this_workflow[$ind_wrk_flw]->jwf_child_stages !== "[]")
					{
                        $new_child_arr          =   json_decode($this_workflow[$ind_wrk_flw]->jwf_child_stages);
						$rotation_childs_array  =   array();
						foreach($new_child_arr as $single_new_child)
						{
							if(!in_array($single_new_child,$path_child_arr))
							{
								array_push($path_child_arr, $single_new_child);
								array_push($rotation_childs_array, $single_new_child);
							}
                        }
                        if(!empty($rotation_childs_array))
                        {
                            $all_child_got      = FALSE;
                            $new_rotation_arr   = array();
                            while($all_child_got == FALSE)
                            {
                                foreach($rotation_childs_array as $single_rotate_array)
                                {
                                    if($this_workflow[$ind_wrk_flw]->jwf_child_stages !== "[]")
                                    {
                                        foreach(json_decode($this_workflow[$single_rotate_array]->jwf_child_stages) as $single_new_array)
                                        {
                                            if(!in_array($single_new_array,$path_child_arr))
                                            {
                                                array_push($path_child_arr, $single_new_array);
                                                array_push($new_rotation_arr,$single_new_array);
                                            }
                                        }
                                    }
                                }
                                if(!empty($new_rotation_arr))
                                {
                                    $rotation_childs_array = $new_rotation_arr;
                                    $new_rotation_arr = array();
                                }
                                else
                                {
                                    $all_child_got = TRUE;
                                }				
                            }
                        }
                    }
                }
                if(!empty($path_child_arr))
				{
					$article_flow_condition = " aflw_art_id = ".$art_id." AND aflw_jwf_id IN(".implode(',',$path_child_arr).") AND aflw_id > ".$act_parent_stages->aflw_id;
                    $remove_flows = Article_flow::get_all_records("aflw_id, aflw_jwf_id,aflw_art_id,aflw_usr_id",$article_flow_condition);
                    foreach($remove_flows as $single_remove_flows)
					{
                        $source_email_templates = array();
						$select = 'art_id, art_artp_id, art_stub,art_title,artp_article_type,jnl_id,jnl_journal_name,jnl_journal_code,aflw_usr_id,art_submitted_by,jwf_stage_type';
						
						$article_details = Article_flow::get_article_stage_data($select, "aflw_id = {$single_remove_flows->aflw_id}",TRUE);
						
                        $source_condition       = 'stage_etmp_journal_id = '.$article_details->jnl_id.' and stage_etmp_stage_type = "'.$article_details->jwf_stage_type.'" and stage_etmp_action = "rescind_source" and setr_jwf_id = '.$single_remove_flows->aflw_jwf_id;
                        
                        $source_email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $source_condition);
                        if (!$source_email_templates->isEmpty())
						{
							$email_data                     = new StdClass;
							$email_data->article_id         = $article_details->art_id;
							$email_data->action             = 'rescind';
							$email_data->artp_id            = $article_details->art_artp_id;
							$email_data->jnl_id             = $article_details->jnl_id;
							$email_data->jnl_journal_code   = $article_details->jnl_journal_code;
							$email_data->aflw_id            = $single_remove_flows->aflw_id;
							
							foreach ($source_email_templates as $sorc)
							{
								if (($article_details->aflw_usr_id != NULL && $sorc->stage_etmp_to == 'User') || $sorc->stage_etmp_to != 'User')
								{
									$touser_d = $send_mail_to = $send_mail_to_usr_ids = NULL;

									if ($sorc->stage_etmp_to == 'submit_author')
									{
										// #4544 Manage author  data listing(normalization)	
                                        $authors_table  =   (new \App\Models\Authors())->getTable();
                                        $users_table    =   (new \App\Models\User())->getTable();
										$tables = array(
											'main_table' => $authors_table,
											'join_table' => array(
												$users_table => array($authors_table . '.auth_usr_id', $users_table . '.usr_id', "left")
											));

										$select_fields  =   'usr_email as auth_email';
										$criteria       =   "auth_art_id = {$article_details->art_id} and auth_usr_id = {$article_details->art_submitted_by}";
										$sub_author     =   Authors::get_results_using_joins($tables, $select_fields, $criteria, 'single');		
										$send_mail_to   =   $sub_author->auth_email;
										$send_mail_to_usr_ids = $touser_d = $article_details->art_submitted_by;
									}
									elseif ($sorc->stage_etmp_to == 'User')
									{
										$user_record    =   User::get_single_record('usr_email', "usr_id = {$article_details->aflw_usr_id}");
										$touser_d       =   ($sorc->stage_etmp_to == 'User') ? $article_details->aflw_usr_id : '';
										$send_mail_to   =   ($sorc->stage_etmp_to == 'User') ? $user_record->usr_email : '';
										$send_mail_to_usr_ids = $touser_d;
									}
                                    $send_mail_to = trim($send_mail_to);
                                    $send_mail_to=str_replace(' ', '', $send_mail_to);
                                    $send_mail_to_usr_ids = trim($send_mail_to_usr_ids);
                                    $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);
									$email_data->user_email         =   $send_mail_to;
									$email_data->user_id            =   $touser_d;
									$email_data->mail_recipient_ids =   $send_mail_to_usr_ids;
									$email_data->jnl_id =   $journal_id;
									$this->send_mail_notification($sorc, $email_data,$jnl_user_role);
								}
							}                            
                        }
                        array_push($advanced_flow['remove_flows'],$single_remove_flows->aflw_id);
                        User_articles::delete_records("usra_aflw_id = {$single_remove_flows->aflw_id}");
						
                        //Task #122  The article is not listed for the privileged user after it is rescinded
                        $this->mngReviewerversion($single_remove_flows->aflw_art_id,$single_remove_flows->aflw_id,$single_remove_flows->aflw_usr_id,false);	

                        Article_flow::delete_records("aflw_art_id = {$art_id} and aflw_id = {$single_remove_flows->aflw_id}");
					}
                    Article_parallel_flow_movement::delete_records("apfm_aflw_id = {$act_parent_stages->aflw_id}");
                    
                }
            }
        }
        return $advanced_flow;
    }
    public function get_rescind_reset_details(Request $request)
	{
        try {
            $post_data          =   $request->all();
            $this->current_user =   $this->get_current_user_details();
		$article_id = decrypt_link($post_data['art_id']);
		$act = $post_data['act'];
        $jnlcode = $post_data['jnlcode'];
		$aflw_id = decrypt_link($post_data['status_id']);
        $Generic_flows = new \App\Models\Generic_flows();
        $Article_types = new \App\Models\Article_types();
        $Roles = new \App\Models\Roles();
        $Article_flow=new \App\Models\Article_flow();
        $Stage_email_templates = new \App\Models\Stage_email_templates;
        $Stage_email_tmpl_reference=new \App\Models\Stage_email_tmpl_reference;
        $Payment_order=new \App\Models\Payment_order();
        $Articles=new \App\Models\Articles; 
        $article_flow_table = (new \App\Models\Article_flow)->getTable();;
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $join_tables         =   array(
            'main_table' => $article_flow_table,
            'join_table' => array(
                $generic_flow_table => array($article_flow_table . '.aflw_jwf_id', $generic_flow_table . '.jwf_id'),
                $article_table => array($article_flow_table . '.aflw_art_id', $article_table . '.art_id')
        ));
	
		$criteria ="aflw_id={$aflw_id}";

		$select = 'aflw_jwf_id,jwf_parent_stages,art_code,jwf_stage_type,art_artp_id';
        $current_stage = $Article_flow::get_results_using_joins($join_tables, $select, $criteria, 'single');
        $current_stage->art_id=$article_id;
        $current_stage->artp_id = $current_stage->art_artp_id;
        $article_types_data =  Article_types::get_single_record('artp_fwm_id', 'artp_id=:artp_id',NULL,'',NULL,array('artp_id'=>$current_stage->artp_id));
        $current_stage->artp_fwm_id = $article_types_data->artp_fwm_id;
        $article_privilages = $this->article_privilages($current_stage, $aflw_id, $jnlcode);
        $isauthor = $article_privilages['author'];
        $isreviewer=$article_privilages['reviewer'];
        $user_allocated=$article_privilages['user_allocated'];
        if($isauthor==true || ($isreviewer==true && $user_allocated == false))
        {
            return  $this->warning('Failed', 200, "redirectdashboard");
        }
		
		$author_email = FALSE;

		if ($act == 'rescind_article')
		{

			$enabled_parent_stages = $this->get_enabled_parent($current_stage->aflw_jwf_id, $current_stage->jwf_parent_stages);
			$parent_stage_ids = array();
			if (!empty($enabled_parent_stages))
			{
				foreach ($enabled_parent_stages as $parent)
				{
					if ($parent->jwf_disable_status == 'n')
						$parent_stage_ids[] = $parent->jwf_id;
				}
			}
			$author_roles = $Roles::get_all_records('role_id', "role_assigned_role='author'");

            if (!empty($parent_stage_ids))
            {
                foreach ($parent_stage_ids as $parent_stage)
                {
                    $array_value[]= $parent_stage;
                }
                $where_in['aflw_jwf_id'] =$array_value; 
            }  
            $auth_role_ids = array();
			if (!empty($author_roles))
			{
				foreach ($author_roles as $aut)
				{
					$auth_role_ids[] = $aut->role_id;
				}
				$where_in['jwf_role_id'] = $auth_role_ids;
			}
            
			$select = 'jwf_role_id';
			$auth_where = "aflw_art_id={$article_id} and aflw_parent_flow_id IS NULL";
			$parent_stages = $Generic_flows::get_artcle_flow($select, $auth_where, $where_in, 'aflw_level DESC, aflw_id ASC');
/* Task #225  JPR-447  Rescind a paper from production to enable licence form to be completed after author requesting changes */
			$return['rescind_payment_alert'] = FALSE;
			$return['payment'] = '';
			if (isset($this->current_client->functionality->cfty_enable_rescind_request) && $this->current_client->functionality->cfty_enable_rescind_request == 'y' && $current_stage->jwf_stage_type == 'payment')
			{
				$payment_details = $Payment_order::get_single_record('pmt_ord_manuscript_id,pmt_ord_transaction_id,pmt_transaction_status',"pmt_ord_art_id={$article_id}");
				//check whether the transaction completed or not	
				if (isset($payment_details) && !empty($payment_details->pmt_ord_transaction_id))
				{
					$return['rescind_payment_alert'] = TRUE;
					$return_payment = array(
									'manuscript_id' => encrypt_link($payment_details->pmt_ord_manuscript_id),
									'transaction_id' => encrypt_link($payment_details->pmt_ord_transaction_id),
									'art_code' => encrypt_link($current_stage->art_code),
									);
					$return['payment'] = $return_payment;
				}
			}
/* Task #225  JPR-447 ends */
			$dest_condition = '(setr_jwf_id =' . $current_stage->aflw_jwf_id . ' AND stage_etmp_action = "rescind_source") ';
			if (!empty($parent_stage_ids))
			{
				$dest_condition .= ' OR (stage_etmp_action = "rescind_destination" AND setr_jwf_id in(' . join(",", $parent_stage_ids) . '))';
			}
			$resc_eml_count = $Stage_email_templates::get_stage_email_tmpl_to_trigger('count(stage_etmp_id) as cnt', $dest_condition);
            if (isset($resc_eml_count[0]->cnt) && $resc_eml_count[0]->cnt > 0)
			{
				$author_email = TRUE;
			}
		}
		$data['author_email'] = $author_email;
		$data['action'] = ($act == 'rescind_article') ? 'rescind' : 'reset';
		$return['content'] = $data;
		$return['status'] = 'success';
        return $this->success('Success',200,$return); 
    } catch (\exception $e) {
        
        return $this->failure('Failed', 500, $e);
    }
	}
    public function get_rescind_email(Request $request)
    {
        try {
            $post_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'aflw_id' => 'required'
            ]);
            
            if($validator->fails())
            {
                    return  $this->failure('Failed',422,$validator->errors());
            }
            $aflwidarray = array('input'=>$post_data['aflw_id'],'type'=>'number', 'enc_data'=>TRUE );
            $aflwidvalidation= $this->Rv_validator($aflwidarray);

            if($aflwidvalidation != TRUE ){
                return $this->failure('Failed',422,customTrans('viewarticle.invalid_data'));	
            }
            $Article_flow = new \App\Models\Article_flow();
            $Generic_flows = new \App\Models\Generic_flows();
            $Article_types = new \App\Models\Article_types();
            $Roles = new \App\Models\Roles();
            $Stage_email_templates = new \App\Models\Stage_email_templates;
            $Article_notification_emails = new \App\Models\Article_notification_emails;

            $aflw_id = decrypt_link($post_data['aflw_id']);
            $select = 'aflw_jwf_id,jwf_parent_stages,aflw_art_id, jwf_flow_proceed_type,aflw_level';

            $article_status = $Article_flow::get_generic_flow($select, "aflw_id={$aflw_id}");
            $article_status = $article_status[0];
            $article_id = $article_status->aflw_art_id;

            $enabled_parent_stages = $this->get_enabled_parent($article_status->aflw_jwf_id, $article_status->jwf_parent_stages);
            $parent_stage_ids = array();
            if (!empty($enabled_parent_stages)) {
                foreach ($enabled_parent_stages as $parent) {
                    if ($parent->jwf_disable_status == 'n') {
                        $parent_stage_ids[] = $parent->jwf_id;
                    }

                }
            }
            $parent_stage_ids=array_unique($parent_stage_ids);
            $author_roles = $Roles::get_all_records('role_id', "role_assigned_role='author'");
            $array_value = array();
            if (!empty($parent_stage_ids)) {
                foreach ($parent_stage_ids as $parent_stage) {
                    $array_value[] = $parent_stage;
                }
                $where_in['aflw_jwf_id'] = $array_value;
            }
            $auth_role_ids = array();
            if (!empty($author_roles)) {
                foreach ($author_roles as $aut) {
                    $auth_role_ids[] = $aut->role_id;
                }
                $where_in['jwf_role_id'] = $auth_role_ids;
            }

            $select = 'jwf_role_id,jwf_id';
            $auth_where = "aflw_art_id={$article_id} and aflw_parent_flow_id IS NULL";

            $parent_stages = $Generic_flows::get_artcle_flow($select, $auth_where, $where_in, 'aflw_level DESC, aflw_id ASC');
            $dest_email_templates = $source_email_templates = array();
            if (!empty($parent_stages)) {
                $possible_roles = array();
                $possible_roles['User'] = 'Stage assigned user';
                $possible_roles['submit_author'] = 'Submitted author';
                $possible_roles['Author'] = 'Corresponding author';
                $possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
                // $possible_roles['Authors'] = 'All authors in article type';
                $possible_roles['Custom_to'] = $possible_roles['Custom'] = 'Specific email ID';
                $role_used = $this->RolesConfigdata('privileged_user_roles');
                $privileged_roles = $role_used['privileged_user_roles'];
                $all_user_roles = $Roles::get_all_records('role_name, role_assigned_role', 'role_assigned_role IN ("' . implode('","', $privileged_roles) . '")');
                if (!empty($all_user_roles)) {
                    foreach ($all_user_roles as $usrole) {
                        $role_label = "All " . strtolower($usrole->role_name) . "s";
                        $possible_roles[$usrole->role_name] = $role_label;
                    }
                }
                foreach ($parent_stages as $par) {
                    $parent_stage_ids[] = $par->jwf_id;
                }
                //  . join(",", $parent_stage_ids) .
                //$last_stage = Article_flow::WhereIn('aflw_jwf_id', array_unique($parent_stage_ids))->orderBy('aflw_id', 'desc')->get('aflw_jwf_id')?->first()?->aflw_jwf_id;
                // print_r($parent_stage_ids);die;
                $stages= "aflw_art_id={$article_id}";
                if(count(array_unique($parent_stage_ids))>1)
                {
                    if($article_status->jwf_flow_proceed_type!='manual')
                    {
                        $last_flw_level=$article_status->aflw_level-3;
                    }
                    else
                    {
                        $last_flw_level=$article_status->aflw_level-1;
                    }
                    $stages.= ' and aflw_jwf_id in (' . join(",", $parent_stage_ids) . ') and aflw_level between '.$last_flw_level.' and '.$article_status->aflw_level;
                    //need to check aflw_art_id and in with aflw_jwf_id and get the aflw_jwf_id then get the parent stages in an array
                    $parentstg=$Generic_flows::get_artcle_flow($select,$stages);
                    if(!empty($parentstg) && isset($parentstg[0]->jwf_id))
                    {
                        $parent_stage_ids=array();
                        foreach ($parentstg as $par) {
                            $parent_stage_ids[] = $par->jwf_id;
                        }
                    }
               }


                $dest_condition = 'stage_etmp_action = "rescind_destination"  AND setr_jwf_id in(' . join(",", $parent_stage_ids) . ')';
                // print_r($parent_stages);die;    
                // $immediate_parent_status[] = $parent_stages[0]->jwf_id;
                // $dest_condition = 'stage_etmp_action = "rescind_destination" AND setr_jwf_id in(' . join(",", $immediate_parent_status) . ')';
                $dest_email_templates = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*', $dest_condition);
                if (!empty($dest_email_templates)) {
                    foreach ($dest_email_templates as $des) {
                        $article_notif = array();
                        $article_notif = $Article_notification_emails::get_single_record('ane_to', "ane_aflw_id={$aflw_id} AND ane_stage_etmp_id={$des->stage_etmp_id}");
                        if (!empty($article_notif)) {
                            $des->stage_etmp_to = $article_notif->ane_to;
                        }
                        $des->stage_etmp_to = (isset($possible_roles[$des->stage_etmp_to])) ? $possible_roles[$des->stage_etmp_to] : $des->stage_etmp_to;
                    }
                }
                $source_condition = "stage_etmp_action='rescind_source' AND setr_jwf_id={$article_status->aflw_jwf_id}";
                $source_email_templates = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*', $source_condition);
                if (!empty($source_email_templates)) {
                    foreach ($source_email_templates as $sr) {
                        $article_notif = array();
                        $article_notif = $Article_notification_emails::get_single_record('ane_to', "ane_aflw_id={$aflw_id} AND ane_stage_etmp_id={$sr->stage_etmp_id}");
                        if (!empty($article_notif)) {
                            $sr->stage_etmp_to = $article_notif->ane_to;
                        }
                        $sr->stage_etmp_to = (isset($possible_roles[$sr->stage_etmp_to])) ? $possible_roles[$sr->stage_etmp_to] : $sr->stage_etmp_to;
                    }
                }
            }

            $data['source_email_templates'] = $source_email_templates;
            $data['dest_email_templates'] = $dest_email_templates;
            $data['stage_id'] = $article_status->aflw_jwf_id;
            $data['author_stage_tab_name'] = 'Rescind Emails';
            $data['author_stage_info'] = 'Please select emails from list for users who are to be notified, upon rescinding stage';
            return $this->success('Success', 200, $data);
        }catch (\exception $e) {
            
            return $this->failure('Failed', 500, $e);
        }
    }

    //TASK #7627 Lepra Missing feature - Request to rescind
    public function request_rescind_article(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'current_status_id' => 'required',
                'rescind_reason' => 'required',
                'jnlcode' => 'required',
                'jnl_id' => 'required'
            ]);
            
            if($validator->fails()){
                return  $this->failure('Failed',422,$validator->errors());
            }
            $article_id = decrypt_link($request->art_id);
            $current_status_id = decrypt_link($request->current_status_id);
            $rescind_reason = $request->rescind_reason;
            $jnl_journal_code = $request->jnlcode;
            $jnl_id = $request->jnl_id;
            $Article_rescind_request = new \App\Models\Article_rescind_request();
            $check_exist = $Article_rescind_request::get_single_record('rrq_id',"rrq_art_id = ? and rrq_request_status = 'n'",binding_arr:[$article_id]);
            if (!$check_exist) {
                $Email_templates = new \App\Models\Email_templates();
                $email_template = $Email_templates::get_single_record('*',"etmp_name = 'request_rescind_article' and etmp_notification = 'Super Admin'");
                if (empty($email_template)) {
                    return $this->warning('Warning', 200,customTrans('viewarticle.undefined_template'));
                }
                $select = 'aflw_id, aflw_status, jwf_stage_type, jwf_parent_stages, jwf_assignment,aflw_jwf_id,aflw_usr_id';
                $crnt_stage = Article_flow::get_generic_flow($select,'aflw_id = ?',bind_data:[$current_status_id]);
                if (!empty($crnt_stage)) {
                    $crnt_stage = $crnt_stage[0];
                    $review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');
                    $current_stage_flow = $review_flow[$crnt_stage->jwf_stage_type];
                }
                $article_details = Articles::get_single_record('art_artp_id','art_id = ?',binding_arr:[$article_id]);
                if (!isset($current_stage_flow['permission'])) {
                    return $this->warning('Warning', 200, customTrans('viewarticle.invalid_access'));
                }
                $current_user = $this->get_current_user_details();
                $insert_data = [
                    'rrq_art_id' => $article_id,
                    'rrq_aflw_id' => $crnt_stage->aflw_id,
                    'rrq_usr_id' => $current_user['user_id'],
                    'rrq_reason' => $rescind_reason,
                    'rrq_request_status'=>'n'
                ];
                $insert_id = $Article_rescind_request::insert_record($insert_data,$current_user);
                if ($insert_id) {
                    $user_data = User::get_single_record('usr_username,usr_status,usr_registered,usr_email','usr_id = '.$current_user['user_id']);
                    $data['usr_username'] = $user_data->usr_username;
                    $data['usr_status'] = $user_data->usr_status;
                    $data['usr_registered'] = $user_data->usr_registered;

                    $data['user_id'] = $current_user['user_id'];
                    $data['proxy_user_id'] = '0';
                    $select = 'GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids';
                    $user_data_super = User::get_single_record($select,'usr_roles LIKE "%super_admin%"');

                    $email_data = new stdClass;
                    $email_data->user_id = $user_data_super->usr_ids;
                    $email_data->user_email = $user_data_super->usr_email;
                    $email_data->mail_recipient_ids = $user_data_super->usr_ids;
                    $email_data->article_id = $article_id;
                    $email_data->aflw_id = $crnt_stage->aflw_id;
                    $email_data->jnl_journal_code = $jnl_journal_code;
                    $email_data->jnl_id = $jnl_id;
                    $email_data->artp_id = $article_details->art_artp_id;
                    $email_data->email_templates_config = $this->email_templates_config();
                    $email_data->join_config = $this->join_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_config = 'clients.' . $this->current_client->clnt_client_code;
                    $email_config_data = Config::get($email_config . '.email');
                    $email_data->reply_to= $email_config_data['email_settings']['reply_to_email'];
                    $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                    if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y') {
                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
                    }
                    if (isset($email_template->etmp_email_template) && strpos($email_template->etmp_email_template,"OPENING_PARAGRAPH") > 0){
                        $email_template->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->etmp_email_template);
                    }
                    $email_data->core_role = isset($request->core_role_id) ? decrypt_link($request->core_role_id) : '';
                    $email_data->core_role_name = isset($request->role_name) ? $request->role_name:'';

                    $data_array = [
                        'record' => $email_template,
                        'email_data' => $email_data,
                        'user_data' =>$data,
                        'column_prefix' =>'etmp_',
                    ];
                    $this->notify_mail($data_array);
                    $return = [
                        'status' => 'success',
                        'msg' => customTrans('rescindrequest.request_sent')
                    ];
                    return $this->success('success', 200, $return);
                }
            }
            return $this->warning('Warning', 200, customTrans('rescindrequest.already_sent'));
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
    * Task #925 in reset / rescind remove the research integrity report of that stage fom the table
    */
    public function reset_research_integrity_report($art_id, $current_status_id, $article_flow) {
        try {
            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                $art_artp_id                =   $article_flow->art_artp_id;
                $aflw_level                 =   $article_flow->aflw_level;
                $current_user               =   $this->get_current_user_details();
            $Article_type_advance_opt   =   new \App\Models\Article_type_advance_options();
            $Research_integrity_reports =   new \App\Models\Research_integrity_reports();

            $is_research_integrity_on   =   'n';
                $article_type_opt_data      =   $Article_type_advance_opt::get_single_record('atotp_research_integrity, atotp_rvriauto_submissions',"atotp_artp_id=:atotp_artp_id",null,'',null, array("atotp_artp_id"=>$art_artp_id));
            if(!empty($article_type_opt_data))
            {
                    $is_research_integrity_on   = $article_type_opt_data->atotp_research_integrity;
            }
                if($is_research_integrity_on == 'y')
            {
                $result     =   $Research_integrity_reports::get_latest_research_integrity_report($art_id);
                if(!empty($result)) {
                        if($result->rri_submission_type == 'm') {
                    $where  =   array('rri_art_id'=>$art_id, 'rri_aflw_id'=>$current_status_id);
                        } else {
                            $Article_flow_table     =   (new \App\Models\Article_flow())->getTable();
                            $General_flow_table     =   (new \App\Models\Generic_flows())->getTable();
                            $Roles_table            =   (new \App\Models\Roles())->getTable();

                            $PrevFlwSql = 'SELECT * 
                                            FROM '.$Article_flow_table.' 
                                            JOIN '.$General_flow_table.' ON (`aflw_jwf_id` = `jwf_id`)
                                            JOIN '.$Roles_table.' ON (role_id = jwf_role_id)
                                            WHERE  aflw_level < ' . $aflw_level . ' AND `aflw_art_id` = '.$art_id.'  and role_assigned_role = "author"
                                            group by aflw_id 
                                            order by aflw_id DESC 
                                            LIMIT 1';
                            $prev_stage_data =  Article_flow::get_records_by_raw_query($PrevFlwSql);
                            if (!empty($prev_stage_data)) {
                                $prev_stg       =   $prev_stage_data[0];
                                $prev_aflw_id   =   $prev_stg->aflw_id;
                                $where  =   array('rri_art_id'=>$art_id, 'rri_aflw_id'=>$prev_aflw_id);
                            }
                        }
                    $Research_integrity_reports::delete_records($where,'',$current_user);
                }
            }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
}
