<?php


namespace App\Http\Controllers;

use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use Config;
use DB;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use App\Models\Journals;
use App\Models\Generic_forms;
use App\Models\Generic_form_elements;
use App\Models\Generic_form_groups;
use App\Models\Generic_form_files;
use App\Models\Stage_email_templates;
use App\Models\Article_generic_form_data;
use App\Models\Article_generic_form_data_temp;
use App\Models\File_upload_type;
use App\Http\Traits\UserDataTrait;
use App\Http\Traits\WorkflowTrait;
use phpDocumentor\Reflection\DocBlock\Tags\Generic;
use App\Models\Roles;
use App\Models\Generic_flows;
use App\Models\Articles;
use App\Models\Article_types;
use App\Models\Article_flow;
use App\Models\User_to_journals;
use App\Models\Article_publons;
use App\Models\Article_figshare;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\StagemovementTrait;
use App\Models\Abstract_category;
use Exception;
use File;
use Illuminate\Support\Facades\Storage;
class Manage_Article_Api extends Controller
{

    use StagemovementTrait;

public function article_submission(Request $request) {
    try {
        $form_data = $request->all();
        $validator = Validator::make($request->all(), [
            'art_id' => 'required',
            'art_flow_id' => 'required',
            'jnl_code'=>'required',
            'jnl_id'=>'required',
        ]);
        if ($validator->fails()) {
            return $this->failure('Failed', 422, $validator->errors());
        }
        $jnlidarray = array('input'=>$form_data['jnl_id'],'type'=>'number', 'rv_enc_data'=>TRUE );
        $jnlcodearray = array('input'=>$form_data['jnl_code'],'type'=>'string', 'rv_enc_data'=>TRUE );
        $articleidarray = array('input'=>$form_data['art_id'],'type'=>'number', 'rv_enc_data'=>TRUE );
        $flowidarray = array('input'=>$form_data['art_flow_id'],'type'=>'number', 'rv_enc_data'=>TRUE );

        $jnlidvalidation= $this->Rv_validator($jnlidarray);
        $jnlcodevalidation= $this->Rv_validator($jnlcodearray);
        $flowidvalidation= $this->Rv_validator($flowidarray);
		$articleidvalidation= $this->Rv_validator($articleidarray);

        if($jnlidvalidation != TRUE || $jnlcodevalidation != TRUE || $flowidvalidation != TRUE || $articleidvalidation != TRUE ){
            return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
        }
        $jnlcodevalid = $this->validatecode(array('jnl_code'=>$form_data['jnl_code']),false,true);
        if($jnlcodevalid['jnl_code'] != TRUE ){
            $res['msg']=customTrans('viewarticle.invalid_data');
            return  $this->warning('Warnings',200,$res,'warning');
        }

        $article_id = isset($form_data['art_id'])?Rv_decrypt($form_data['art_id']):'';
        $art_flow_id = isset($form_data['art_flow_id'])?Rv_decrypt($form_data['art_flow_id']):'';
        $jnlcode = isset($form_data['jnl_code'])?Rv_decrypt($form_data['jnl_code']):'';
        $jnl_id = isset($form_data['jnl_id'])?Rv_decrypt($form_data['jnl_id']):'';

        $assignment=isset($form_data['assignment'])?$form_data['assignment']:false;
        $version =isset($form_data['version'])?$form_data['version']:'';
        $formatted_journal_code = '_'.$jnlcode;
        $article_for_resubmission = FALSE;
        $activateformcount = 0;
        $return_array=array();
        $decision_array=array();
        $articletype_id='';
        $current_user=isset($form_data['current_user'])?Rv_decrypt($form_data['current_user']):'';
        if($current_user=='')
        {
            $user=$this->get_current_user_details();
            $current_user = $user['user_id'];
        }
        $article = Articles::get_single_record_with_bind_cond("art_artp_id",array('art_id'=>$article_id));

        if(empty($article)){
            return  $this->warning('ERROR',200,'','warning');
        } else {
            $return_array['artp_id']=$articletype_id=$article->art_artp_id;
        }
        $condition = 'aflw_id=' . $art_flow_id;
        $flowdetails = Articles::get_article_details("aflw_level,aflw_stage_repeat_count,aflw_status,aflw_posted_by,aflw_usr_id,aflw_id,aflw_jwf_id,jwf_stage_name,jwf_stage_type,jwf_forms,artp_id,art_id,artp_fwm_id,jwf_role_id,jwf_tab_name,jwf_parent_user_roles,jwf_who_can_invite,jwf_role_id,jwf_production_upload,jwf_assignment,art_artp_id,art_status,jwf_fwm_id,jwf_child_stages", $condition, NULL, FALSE);
        //after rescind $flowdetails is null, so $flowdetails[0] was getting error
        if(!$flowdetails->isEmpty()) {
        $flow_data = $flowdetails[0];
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $stage_flow = $review_flow[$flow_data->jwf_stage_type];
        $user_roles = $this->validate_user_journal($jnlcode, $current_user, $flow_data->artp_id);
        $condition = 'role_assigned_role!=\'system\'';
        $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role', $condition);
        $article_privilages = $this->article_privilages($flow_data, $art_flow_id, $jnlcode);

        if($version!='old')
        {
        $check_user_permission =$this->checkuserhaspermission($article_privilages,$user_roles,$flow_data,$current_user,$jnl_id,$jnlcode);
        if($check_user_permission==FALSE)
        {
            return  $this->warning('Failed', 200, "permission_denied");
        }
        }
        $articleflow_table = (new \App\Models\Article_flow())->getTable();
        $genericflows_table = (new \App\Models\Generic_flows())->getTable();
        $form_valid = false;
        $getforms = $forms =array();
        $tobevalidatedform=0;
        if ($article_for_resubmission == FALSE) {
            $Generic_forms = new \App\Models\Generic_forms();
            if($assignment==true){
                $tables = array(
                    'main_table' => $articleflow_table,
                    'join_table' => array(
                    $genericflows_table => array($articleflow_table . '.aflw_jwf_id', $genericflows_table . '.jwf_id', "left"))
                );

               $condition = "aflw_art_id=? AND aflw_id=?";
                $binding_arr = array($article_id,$art_flow_id);
                $getstagetype = Article_flow::get_results_using_joins($tables, 'jwf_stage_type,jwf_id', $condition, 'single', NULL, NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr);
                if(!empty($getstagetype)) {
                    $jwf_stage_type=$getstagetype->jwf_stage_type;
                    $jwf_id=$getstagetype->jwf_id;
                    $getforms = Article_types::get_form_onstage($jwf_stage_type, $articletype_id,$jwf_id);
                }

            } else {
                $getforms = Article_types::get_form_onstage('author_submission', $articletype_id);
            }


            $return_array['article_details']= Articles::get_single_record_with_bind_cond('art_id,art_artp_id,art_status',array('art_id'=>$article_id));
            $return_array['globaldecisioncontrol']=false;
            $globaldecisionstages=array();
            $decisionstageids=array();
            //$condition = 'aflw_id=' . $art_flow_id;
            //$getforms = Articles::get_article_details("aflw_status,aflw_posted_by,aflw_usr_id,aflw_id,aflw_jwf_id,jwf_stage_name,jwf_stage_type,jwf_forms,artp_id,art_id,artp_fwm_id,jwf_role_id", $condition, NULL, FALSE);
            //echo '<pre>'; print_r($getforms);
            if(!empty($getforms) && (isset($getforms[0]->jwf_forms) && !empty($getforms[0]->jwf_forms)))
            $forms = implode(',',json_decode($getforms[0]->jwf_forms, TRUE));



            if(!empty($forms))
            {
            $condition = "gncf_id in (" . $forms . ") ORDER by FIELD(gncf_id,".$forms .")";
            $generic_forms = $Generic_forms::get_all_records('gncf_id,gncf_form_type,gncf_form_name,gncf_form_title,gncf_user_roles', $condition);
            //echo '<pre>'; print_r($generic_forms); die;
            $return_array['formdata']=$generic_forms;
            $form_count=count(json_decode($getforms[0]->jwf_forms, TRUE));
            $form_openstatus=false;
            $form_open=0;
            $form_valid=false;
            $optval='';
            foreach ($getforms as $gnf_florm) {
                $return_array['form_openid']='';
                $lastvalidform='';
                $lastnotvalidform='';
                $show_generic_tab= TRUE;
                $data=json_decode($gnf_florm->jwf_forms, TRUE);
                if(!empty($data)) {
                    $suport_files = Generic_form_elements::supporting_files($data);
                    //$suport_files_count = $suport_files->file_upload;
                    foreach ($data as $formid) {
                        $decisionstages=array();
                        $form_open++;
                        $lastnotvalidform=$formid;
                        //$return_array['form_open']=$form_open;
                        $temp_save = FALSE;
                        $btn_status=true;
                        // generic form ids
                        $valid_req_generic_forms[] = $formid;
                        $condition2=array('emt_gucf_id'=>$formid);
                        $elements = Generic_form_elements::get_all_records_with_bind_cond('emt_id,emt_required,emt_element_type,emt_options',$condition2);
                        $Generic_form_groups = Generic_form_groups::get_all_records_with_bind_cond('gfg_gncf_id',array('gfg_gncf_id'=>$formid));
                        $Generic_form = Generic_forms::get_all_records_with_bind_cond('gncf_id,gncf_form_type,gncf_form_name,gncf_form_title,gncf_user_roles',array('gncf_id'=>$formid));
                        if(sizeof($elements)==0){
                            $btn_status=false;$activateformcount++;
                        }
                        $return_array['form_validation'][$formid]=false;
                        $decisionstatus=false;
                        $decisioncontrolstages=array();

                         // no of elemt required
                        if(!empty($elements)) {
                            foreach ($elements as $element) {
                                if ($element->emt_required == 1) {
                                    $return_array['form_validation'][$formid]=true;
                                    $lastvalidform=$formid;
                                }
                                if ($element->emt_element_type == 'radiobutton' || $element->emt_element_type == 'combobox') {
                                    if(!empty($element->emt_options)) {
                                    foreach(json_decode($element->emt_options) as $item => $values) {
                                        foreach($values as $item2 => $values2)  {
                                            if($item2=="next_stage") {
                                                $decisionstatus=true;
                                                $return_array['globaldecisioncontrol']=true;
                                                $decisionstages[$optval] =$values2;
                                                $return_array['decision_control']['decisioncontrolemtid']=$element->emt_id;
                                            }else{
                                                $optval=$item2;
                                            }
                                        }
                                    }

                                    $return_array['decision_control']['decisioncontrolstatus']=$decisionstatus;
                                    // if($decisionstatus){
                                    //     $return_array['decision_control']['decisioncontrolemtid']=$element->emt_id;
                                    // }
                                    }

                                }

                            }
                        }



                        // if($return_array[$formid]['form_validation']==false){
                        //     $activateformcount++;
                        // }
                        //Bug #1426 Invite Submission
                        if ($article_id != '') {
                            //checking for form which exists in db with details
                            if($assignment==true) { // other journal work flow stage exclude  author_submission and rivision
                                $flowid=$art_flow_id;
                            } else { // if it is author_submission or revision
                                $tables = array(
                                    'main_table' => $articleflow_table,
                                    'join_table' => array(
                                        $genericflows_table => array($articleflow_table . '.aflw_jwf_id', $genericflows_table . '.jwf_id', "left")
                                    )
                                );

                                $condition = "aflw_art_id=? AND jwf_stage_type='author_submission'";
                                $binding_arr = array($article_id);
                                $original_art_data = Article_flow::get_results_using_joins($tables, 'aflw_id', $condition, 'single', NULL, NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr);
                                if(!empty($original_art_data)){
                                    $flowid=$original_art_data->aflw_id;
                                } else {
                                    $condition2 = "aflw_art_id=? AND jwf_stage_type='revision'";
                                    $binding_arr1 = array($article_id);
                                    $original_art_rivision = Article_flow::get_results_using_joins($tables, 'aflw_id', $condition2, 'single', NULL, NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr1);
                                    if(!empty($original_art_rivision)) {
                                        $flowid=$original_art_rivision->aflw_id;
                                    }

                                    if(empty($flowid)) {
                                        $flowid=$art_flow_id;
                                    }
                                }
                            }


                            $existdata = Article_generic_form_data::load_exist_form_contents($formid, $article_id, $flowid, $formatted_journal_code,NULL,FALSE,$flow_data->aflw_stage_repeat_count);
                        } else {
                            $existdata = NULL;
                        }

                        if($return_array['form_validation'][$formid]==true) {
                            $tobevalidatedform++;
                        }

                        if($return_array['form_validation'][$formid]==true && ($existdata==NULL || count($existdata)==0)) {
                            if($form_openstatus==false){
                                $form_openstatus=true;
                                $form_valid=true;
                                $return_array['form_open']=$form_open-1;
                            }
                        }
                        if(($existdata==NULL || count($existdata)==0)){
                            if(empty($return_array['form_openid'])) {
                                $return_array['form_openid']=$formid;
                            }
                        }

                        if($form_valid==false) {
                            $return_array['form_open']=$form_open-1;
                        }
                        if($assignment==true) {
                            if($return_array['form_validation'][$formid]==true && ($existdata==NULL || count($existdata)==0)) {
                                $form_valid=true;
                            } else {
                                $form_valid=false;
                            }
                        }


                        $file_only = FALSE;
                        if ($existdata != NULL && count($existdata)>0 ) {
                            $file_only = TRUE;
                            $activateformcount++;
                            foreach ($existdata as $data) {
                                if ($data->gdata_element_type != 'file') {
                                    $file_only = FALSE;
                                    break;
                                }
                            }
                            foreach ($existdata as $data) {
                                if ($data->gdata_element_type != 'file') {
                                    if(isset($return_array['decision_control']['decisioncontrolemtid']) && $return_array['decision_control']['decisioncontrolemtid']==$data->gdata_atfemt_id) {
                                        $data->gdata_decisioncontrol=true;
                                        if(isset($decisionstages[$data->gdata_data]))
                                        array_push($globaldecisionstages,$decisionstages[$data->gdata_data]);
                                    }
                                }
                            }
                        }

                        if($file_only==true) {
                            $return_array['form_openid']=$formid;
                        }
                        $temp_data = FALSE;
                        if (($existdata == NULL || count($existdata)==0) || ($existdata != NULL  && count($existdata)>0 && $file_only == TRUE)) { //print_r($existdata);exit;
                            $existdata_temp = Article_generic_form_data_temp::load_exist_form_contents($formid, $article_id, $art_flow_id);
                            //print_r($existdata_temp);exit;
                            if ($existdata_temp && sizeof($existdata_temp) > 0) {
                                if ($existdata == NULL) {
                                    $existdata = $existdata_temp;
                                } else {
                                    $k = 0;
                                    foreach ($existdata_temp as $temp_data) {
                                        $existdata[$k] = $temp_data;
                                        $k++;
                                    }
                                }
                                $temp_save = TRUE;
                                $temp_data = TRUE;
                            }
                        }

                        $return_array['existdata'][$formid]=$existdata;
                        $return_array['temp_save'][$formid]=$temp_save;
                        $return_array['file_only'][$formid]=$file_only;
                        $return_array['formbtn_status'][$formid]=$btn_status;
                    }
                }
                if(empty($return_array['form_openid'])) {
                    $return_array['form_openid']=$lastnotvalidform;
                }
            }
            $return_array['decision_control']['decisioncontrolstage']=(!empty($globaldecisionstages))? implode(",",$globaldecisionstages):'' ;
            }
        }
        $return_array['tobevalidatedform']=$tobevalidatedform;
        $return_array['completedformcount']=$activateformcount;
        //$return_array['form_valid']=($tobevalidatedform!=0 && $tobevalidatedform!=$activateformcount )?true:$form_valid;
        $valid=$this->validate_stage_forms($art_flow_id,$jnl_id,$jnlcode,array(),$flow_data);
        if($valid || $flow_data->art_status=='t'){
            $return_array['form_valid']=FALSE;
        } else {
            $return_array['form_valid']=TRUE;
        }
        $return_array['forms']= !empty($forms)?explode(',',$forms):[];
        $next_roles_found = array();
        //$return_array['next_roles_found']= $next_roles_found;
        if($form_valid == false &&  $assignment == true)
        {

            /*$condition = 'aflw_id=' . $art_flow_id;
            $flowdetails = Articles::get_article_details("aflw_status,aflw_posted_by,aflw_usr_id,aflw_id,aflw_jwf_id,jwf_stage_name,jwf_stage_type,jwf_forms,artp_id,art_id,artp_fwm_id,jwf_role_id,jwf_tab_name,jwf_parent_user_roles,jwf_who_can_invite,jwf_role_id,jwf_production_upload", $condition, NULL, FALSE);
            //after rescind $flowdetails is null, so $flowdetails[0] was getting error
            if(!$flowdetails->isEmpty()) {
            $flow_data = $flowdetails[0];*/
            if($flow_data->aflw_status == 'p' || $flow_data->aflw_status== 'a')
            {
            /*$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);
            $stage_flow = $review_flow[$flow_data->jwf_stage_type];
            $user_roles = $this->validate_user_journal($jnlcode, $current_user, $flow_data->artp_id);
            $condition = 'role_assigned_role!=\'system\'';
            $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role', $condition);
            $article_privilages = $this->article_privilages($flow_data, $art_flow_id, $jnlcode);*/
            /* Roles assigned to this article */
            $user_array = array();
            $user_array['user_roles'] = $user_roles;
            $user_array['article_id'] = $article_id;
            $user_array['all_roles'] = $all_roles;
            $user_array['article_privilages'] = $article_privilages;
            $user_array['jnl_id'] = $jnl_id;
            $user_array['user_id'] = $current_user;
            $user_array['art_flow_id'] = $art_flow_id;
            $user_roles = $this->get_article_user_roles($user_array);

            $assignment_details=$this->assignment_details($flow_data,$jnl_id,$current_user,$stage_flow,$user_roles);
            if(!empty($assignment_details))
            {
                if(!in_array($flow_data->jwf_stage_type, array(
                    'accept',
                    'reject',
                    'decision_revision',
                    'license_check','production'
                )))
                {
               $assignment_status= $assignment_details['assignment'];
                if($flow_data->aflw_status == 'p')
                {
                $roles_to_assign[] = $assignment_details['roles_to_assign'];
                }
                else
                $roles_to_assign = $assignment_details['roles_to_assign'];
                if($assignment_status== true)
                {
                    $globaldecisionstages =(!empty($globaldecisionstages))? explode(",",$globaldecisionstages[0]):array();
                   if(!empty($globaldecisionstages))
                   {
                    $child_stages=json_decode($flow_data->jwf_child_stages,TRUE);
                    $Generic_flows = new \App\Models\Generic_flows();
                    if(!empty($child_stages))
                    {
                        $return_button = $return_button_rank= array();
                        foreach($child_stages as $each_stage)
                        {
                        $get_current_data = $Generic_flows::get_single_record('jwf_stage_type,jwf_child_stages','jwf_id='. $each_stage);
                        if(in_array($get_current_data->jwf_stage_type,$globaldecisionstages))
                        {
                            //array_push($return_button,'btn'.$each_stage);
                            $return_button_rank[$each_stage] = 1;
                        }
                        else
                        {
                            if(count(json_decode($get_current_data->jwf_child_stages,1)) != 0)
                            {
                                $child_stages_imlode = json_decode($get_current_data->jwf_child_stages);
                                $child_stages_for_check = implode(',',$child_stages_imlode);
                                $while_intial = TRUE;
                                $decision_found = FALSE;
                                $new_childs_for_nxt_loop = $child_stages_for_check;
                                $roles = array();
                                $stages_present = array();
                                $child_stages_already_checked = array();
                                $return_btn_rank = 2;
                                while ($while_intial == TRUE)
                                {
                                    $get_fields = 'jwf_id,jwf_stage_type,jwf_child_stages,jwf_disable_status';
                                    $get_child_details = $Generic_flows::get_child_details($get_fields,$new_childs_for_nxt_loop);

                                    $new_childs_for_nxt_loop = '';

                                    if(!empty($get_child_details))
                                    {
                                        foreach($get_child_details as $ind_data)
                                        {
                                            if(in_array($ind_data->jwf_stage_type,$globaldecisionstages) && $ind_data->jwf_disable_status == 'n')
                                            {
                                                if($decision_found == FALSE)
                                                {
                                                    $return_button_rank[$each_stage] = $return_btn_rank;
                                                }
                                                $while_intial = FALSE;
                                                $decision_found = TRUE;
                                                array_push($stages_present, $ind_data->jwf_stage_type);
                                            }
                                            else
                                            {

                                                if(count(json_decode($ind_data->jwf_child_stages,1)) != 0)
                                                {
                                                    $child_stages_arr= json_decode($ind_data->jwf_child_stages);
                                                    foreach($child_stages_arr as $child_stages)
                                                    {
                                                        if(!in_array($child_stages, $child_stages_already_checked))
                                                        {
                                                            $new_childs_for_nxt_loop = $new_childs_for_nxt_loop.','.$child_stages;
                                                            array_push($child_stages_already_checked,$child_stages);
                                                        }
                                                    }
                                                }
                                            }
                                        }

                                        $return_btn_rank++;

                                    }

                                    $new_childs_for_nxt_loop = ltrim($new_childs_for_nxt_loop,',');
                                    if($new_childs_for_nxt_loop == '')
                                    {
                                        $while_intial = FALSE;
                                    }
                                }
                            }
                        }
                    }
                    if(!empty($return_button_rank))
                    {
                        $shortest_path = min($return_button_rank);
                        foreach($return_button_rank as $stage_id => $node_level)
                        {
                            if($node_level == $shortest_path)
                            {
                                array_push($return_button,$stage_id);
                            }
                        }
                    }
                }

                if(!empty($return_button))
                {
                    $res=$this->getAllAssignedworkflowid($return_button);
                    $flowids=implode(",",$res);
                    // print_r($res);  die;
                    //  die;
                    // // DB::enableQueryLog();
                    $sql="select jwf_id,jwf_stage_type,jwf_role_id,jwf_child_stages from rvw_journal_workflows where jwf_id in (".$flowids.") ";
                    $result=$Generic_flows::get_records_by_raw_query($sql);
                    // print_r($result);  die;

                    $return_array['form_valid']=false;

                    // $sql="select jwf_id from rvw_journal_workflows where jwf_id NOT IN (select aflw_jwf_id from rvw_article_flow where aflw_level< {$flow_data->aflw_level}  and aflw_art_id = {$flow_data->art_id}) and jwf_fwm_id = {$flow_data->jwf_fwm_id} ";
                    // $result=$Generic_flows::get_records_by_raw_query($sql);


                    foreach($result as $each_stage)
                    {
                        $decision_found = TRUE;

                        //$each_stage = substr($allowed_stages, strpos($allowed_stages, "btn") + 3);
                        $role_id_arr = array();
                        $get_current_data = $Generic_flows::get_single_record('jwf_stage_type,jwf_role_id,jwf_child_stages','jwf_id='.$each_stage->jwf_id);
                        array_push($role_id_arr,$get_current_data->jwf_role_id);
                        if(in_array($get_current_data->jwf_stage_type,$globaldecisionstages))
                        {
                            $decision_found = TRUE;
                            foreach($roles_to_assign as $key => $value)
                            {
                                if(in_array($value->role_id, $role_id_arr))
                                {
                                    if(!in_array((string)$value->role_id,$next_roles_found))
                                    {
                                        array_push($next_roles_found,$value->role_id);
                                    }
                                }
                            }

                        }

                        if(count(json_decode($get_current_data->jwf_child_stages,1)) != 0)
                        {
                                $child_stages_imlode = json_decode($get_current_data->jwf_child_stages);
                                $child_stages_for_check = implode(',',$child_stages_imlode);
                                $while_intial = TRUE;
                                $new_childs_for_nxt_loop = $child_stages_for_check;
                                $roles = array();
                                $stages_present = array();
                                $child_stages_already_checked = array();
                                while ($while_intial == TRUE)
                                {
                                    $get_fields = 'jwf_id,jwf_stage_type,jwf_child_stages,jwf_disable_status,jwf_role_id';
                                    $get_child_details = $Generic_flows::get_child_details($get_fields,$new_childs_for_nxt_loop);

                                    $new_childs_for_nxt_loop = '';

                                    if(!empty($get_child_details))
                                    {
                                        foreach($get_child_details as $ind_data)
                                        {
                                            if(in_array($ind_data->jwf_stage_type,$globaldecisionstages) && $ind_data->jwf_disable_status == 'n')
                                            {
                                                $decision_found = TRUE;
                                            }
                                            if(count(json_decode($ind_data->jwf_child_stages,1)) != 0)
                                            {
                                                $child_stages_arr= json_decode($ind_data->jwf_child_stages);
                                                foreach($child_stages_arr as $child_stages)
                                                {
                                                    if(!in_array($child_stages, $child_stages_already_checked))
                                                    {
                                                        $new_childs_for_nxt_loop = $new_childs_for_nxt_loop.','.$child_stages;
                                                        array_push($child_stages_already_checked,$child_stages);
                                                    }
                                                }
                                            }
                                            if(!in_array($ind_data->jwf_role_id, $role_id_arr))
                                            {
                                                array_push($role_id_arr,$ind_data->jwf_role_id);
                                            }
                                        }

                                    }

                                    $new_childs_for_nxt_loop = ltrim($new_childs_for_nxt_loop,',');
                                    if($new_childs_for_nxt_loop == '')
                                    {
                                        $while_intial = FALSE;
                                    }
                                }

                                if($decision_found == TRUE)
                                {
                                    foreach($roles_to_assign as $key => $value)
                                    {
                                        if(in_array($value->role_id, $role_id_arr))
                                        {
                                            if(!in_array((string)$value->role_id,$next_roles_found))
                                            {
                                            array_push($next_roles_found,$value);
                                            }
                                        }
                                    }
                                }
                            }

                        }
                    }

                    if(!empty($next_roles_found))
                    {
                    $assign_select = 'group_concat(aflw_skip_assignment) as aflw_skip_assignment';
                    $assign_where = "aflw_art_id = " . $article_id . " and aflw_usr_id=" . $current_user;
                    $assign_dets = Article_flow::get_article_flow_details($assign_select, $assign_where);
                    $skipped_roles = ($assign_dets[0]->aflw_skip_assignment != NULL) ? array_filter(explode(',', $assign_dets[0]->aflw_skip_assignment)) : array();
                    foreach($roles_to_assign  as $roles)
                    {
                        if ($flow_data->aflw_status == 'a' && $flow_data->aflw_usr_id == $current_user) {
                            $User_articles = new \App\Models\User_articles();
                            $assigned_users = $User_articles::get_all_records('usra_id', 'usra_art_id=' . $article_id . ' and usra_role_id=' . $roles->role_id);

                            if (!isset($assigned_users[0]->usra_id) && (!in_array($roles->role_id, $skipped_roles))) {
                                $return_array['form_valid']=true;
                                break;
                            }
                            //articleassignmnet
                        }
                        else{
                           //stage assignmnet
                            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                            $tables = array(
                                'main_table' => $Article_flow_table,
                                'join_table' => array(
                                    $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id')
                                )
                            );
                            $criteria = "aflw_art_id=$article_id AND aflw_parent_flow_id=$art_flow_id and jwf_role_id=" . $roles['role_id'];
                           $getdetails = Article_flow::get_results_using_joins($tables, 'aflw_usr_id', $criteria, 'single');
                           if(!isset($getdetails->aflw_usr_id))
                           {
                            $return_array['form_valid']=true;
                            break;
                           }
                        }

                    }

                }
                }
                else{
                    $assign_select = 'group_concat(aflw_skip_assignment) as aflw_skip_assignment';
                    $assign_where = "aflw_art_id = " . $article_id . " and aflw_usr_id=" . $current_user;
                    $assign_dets = Article_flow::get_article_flow_details($assign_select, $assign_where);
                    $skipped_roles = ($assign_dets[0]->aflw_skip_assignment != NULL) ? array_filter(explode(',', $assign_dets[0]->aflw_skip_assignment)) : array();
                    foreach($roles_to_assign  as $roles)
                    {
                        if ($flow_data->aflw_status == 'a' && $flow_data->aflw_usr_id == $current_user) {
                            $User_articles = new \App\Models\User_articles();
                            $assigned_users = $User_articles::get_all_records('usra_id', 'usra_art_id=' . $article_id . ' and usra_role_id=' . $roles->role_id);

                            if (!isset($assigned_users[0]->usra_id) && (!in_array($roles->role_id, $skipped_roles))) {
                                $return_array['form_valid']=true;
                                break;
                            }
                            //articleassignmnet
                        }
                        else{
                           //stage assignmnet
                            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                            $tables = array(
                                'main_table' => $Article_flow_table,
                                'join_table' => array(
                                    $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id')
                                )
                            );
                            $criteria = "aflw_art_id=$article_id AND aflw_parent_flow_id=$art_flow_id and jwf_role_id=" . $roles['role_id'];
                           $getdetails = Article_flow::get_results_using_joins($tables, 'aflw_usr_id', $criteria, 'single');
                           if(!isset($getdetails->aflw_usr_id))
                           {
                            $return_array['form_valid']=true;
                            break;
                           }
                        }
                    }
                    $next_roles_found[]=$roles_to_assign;
                }
            }
            }else{
                $assignment == true;
                $return_array['form_valid']=false;
            }

            }
            $return_array['next_roles_found']= $next_roles_found;

            if((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y'))
			{
                //if(isset($stage_flow['upload_type']) && isset($stage_flow['stage_for']) && $stage_flow['stage_for'] == 'manageproduction' && ($stage_flow['upload_type'] == 'required' ||  $flow_data->jwf_production_upload =="r"))
                if(isset($stage_flow['stage_for']) && $stage_flow['stage_for'] == 'manageproduction' && $flow_data->jwf_production_upload =="r")
                {
                    $return_array['form_valid']=true;
                    $Production_attachment_files = new \App\Models\Production_attachment_files();
                    $file_uploaded = $Production_attachment_files::get_single_record('count(paf_id)  as cnt', 'paf_aflw_id=' . $art_flow_id.' and paf_description_id IS NOT NULL');
                    if($file_uploaded->cnt>0)
                        $return_array['form_valid']=false;
                }
            }

            if($flow_data->jwf_stage_type=='copyright' || $flow_data->jwf_stage_type=='transit') {
                $valid=$this->validate_stage_forms($art_flow_id,$jnl_id,$jnlcode,array());
                if($flow_data->jwf_stage_type=='copyright' && $this->current_client->functionality->cfty_enable_copyright_attachment=='y'){
                    $Copyright = new \App\Models\Copyright();
                    $condition = "crt_art_id={$flow_data->art_id} and crt_aflw_id={$flow_data->aflw_id} ";
                    $result = $Copyright::get_single_record('copy_location,copy_att_name', $condition);
                    if(isset($result) && empty($result->copy_location) && empty($result->copy_att_name) ) {
                        $valid=false;
                    }
                }

                if($valid){
                    $return_array['form_valid']=FALSE;
                } else {
                    $return_array['form_valid']=TRUE;
                }
            }
            
        }
        }
        if($return_array['form_valid']==true)
        {
            if($flow_data->jwf_stage_type == 'payment' && $this->current_client->functionality->cfty_enable_re_instantiate_payment == 'y')
            {
                $Payment_order = new \App\Models\Payment_order();
                /* Get the Current article transaction Status */
                $article_payment_status = $Payment_order::get_single_record('pmt_transaction_status', 'pmt_ord_art_id=' . $flow_data->art_id);
                if (isset($article_payment_status->pmt_transaction_status) && ($article_payment_status->pmt_transaction_status == 'CL')) {
                    $return_array['form_valid']=false;
                }
            }
            if($flow_data->jwf_stage_type == 'payment' && $this->current_client->functionality->cfty_enable_article_payment_bypass == 'y' && $flow_data->aflw_status == 'u')
            {
                $Payment_order = new \App\Models\Payment_order();
                /* Get the Current article transaction Status */
                $article_payment_status = $Payment_order::get_single_record('pmt_transaction_status', 'pmt_ord_art_id=' . $flow_data->art_id);
                if (isset($article_payment_status->pmt_transaction_status) && ($article_payment_status->pmt_transaction_status == 'CC')) {
                    $return_array['form_valid']=false;
                }
            }
        }
    }

    //formbtn_status
        return $this->success('Success', 200, $return_array);
    } catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
}

public function get_all_abstract_categories(Request $request){
    $data = Abstract_category::get_abstract_categories();

    return $this->success('Success', data : ['abstract_categories' => $data]);
}


public function article_save_later(Request $request) {
    try {
        $form_data = $request->all();
        $validator = Validator::make($request->all(), [
            'articleid' => 'required',
            'hdn_current_status_id'=>'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        $formid = $this->decrypt_data($form_data['form_id']);
		$articleid = $this->decrypt_data($form_data['articleid']);
	    $current_status_id = $this->decrypt_data($form_data['hdn_current_status_id']);
        $journal_code = $form_data['jnl_code'];
        $jnl_id = $this->decrypt_data($form_data['jnl_id']);

        $res=array();
        $formelmtdata=array();
        $formatted_journal_code = '_'.$journal_code;
        $this->current_user = $this->get_current_user_details();

        if ($articleid != '' && $current_status_id != '') {
            $autosave = 0;
            if(isset($form_data['autosave']))  $autosave = 1;

            // $stage_type_dtls = Article_flow::get_stage_details("aflw_id='{$current_status_id}'" ,'aflw_stage_repeat_count');
            $stage_type_dtls = Article_flow::get_stage_details("aflw_id=?" ,'aflw_stage_repeat_count',wherearr:[$current_status_id]);        //TASK #7017
            if(!empty($stage_type_dtls))
            {            
            if(!empty($form_data)) {
                $get_all_dependency = Generic_form_elements::get_form_dependency_elements($formid);
                if(!empty($get_all_dependency)) {
                foreach($form_data as $key_elmnt => $ind_elemnt) {
                    $res=explode('_',$key_elmnt);
                    if(count($res)==4) $res[] = 0;
                        if(count($res)==5 ){
                        list($keylbl, $keyfrmid, $ctrl_id, $grp_id, $dynamic_id)=$res;
                        if($keylbl=='form' && $keyfrmid==$formid) { $formelmtdata['ctrl_'.$ctrl_id.'_'.$dynamic_id]=$ind_elemnt; //array_push($elmtdata,'ctrl_'.$ctrl_id);
                            // $elem_codition = "gdata_art_id='{$articleid}' and gdata_atf_id='{$formid}' and gdata_atfemt_id='{$ctrl_id}'
                            // and gdata_artflw_id='{$current_status_id}' and gdata_artflw_stage_repeat_count='{$stage_type_dtls->aflw_stage_repeat_count}' and gdata_dynamic_id = {$dynamic_id} ";
                            $elem_codition = [
                                'gdata_art_id' => $articleid,
                                'gdata_atf_id' => $formid,
                                'gdata_atfemt_id' => $ctrl_id,
                                'gdata_artflw_id' => $current_status_id,
                                'gdata_artflw_stage_repeat_count' => $stage_type_dtls->aflw_stage_repeat_count,
                                'gdata_dynamic_id' => $dynamic_id
                            ];          //TASK #7017
                            foreach($get_all_dependency as $dependency) {
                                 $delete_dependency = FALSE;
                                 if($dependency->emt_id == $ctrl_id) {
                                    $is_data = $form_data['form_'.$formid.'_'.$dependency->emt_depending_control.'_'.$grp_id.'_'.$dynamic_id] ??  null;
                                     if(isset($is_data)) {
                                         if(is_array($is_data)) {
                                             if(!in_array($dependency->emt_depending_value, $is_data)) {
                                                 $delete_dependency = TRUE;
                                                 ///unset($form_data[$key_elmnt]);
                                             }
                                         } else {
                                             if($is_data != $dependency->emt_depending_value) {
                                                 $delete_dependency = TRUE;
                                                 //unset($form_data[$key_elmnt]);
                                             }
                                         }
                                     } else {
                                         $delete_dependency = TRUE;
                                         //unset($form_data[$key_elmnt]);
                                     }

                                 }
                                 if($delete_dependency == TRUE) {
                                      //$existdata = Article_generic_form_data::get_single_record("gdata_id",$elem_codition,'',$formatted_journal_code);
                                    $existdata = Article_generic_form_data::get_single_record_with_bind_cond("gdata_id",$elem_codition,journal_code:$formatted_journal_code);       //TASK #7017
                                    if(!empty($existdata)) {
                                    Article_generic_form_data::delete_records($elem_codition, $formatted_journal_code, $this->current_user);
                                    }
                                 }
                            }
                        }
                    }
                }
                }
            }
            }
            // $journal_records = Journals::get_single_record('*', "jnl_journal_code='{$journal_code}'" );
            $journal_records = Journals::get_single_record_with_bind_cond('*', ['jnl_journal_code' => $journal_code]);      //TASK #7017

			// $stage_type = Article_flow::get_stage_details("aflw_id='{$current_status_id}'",'jwf_stage_type,aflw_stage_repeat_count');
            $stage_type = Article_flow::get_stage_details("aflw_id=?" ,'jwf_stage_type,aflw_stage_repeat_count',wherearr:[$current_status_id]);           //TASK #7017
            if (!empty($stage_type)) {
                // $elem_codition = "gdata_art_id='{$articleid}' and gdata_atf_id='{$formid}' and gdata_artflw_id='{$current_status_id}'
                // and gdata_artflw_stage_repeat_count='{$stage_type->aflw_stage_repeat_count}'";
                $elem_codition = [
                    'gdata_art_id' => $articleid,
                    'gdata_atf_id' => $formid,
                    'gdata_artflw_id' => $current_status_id,
                    'gdata_artflw_stage_repeat_count' => $stage_type->aflw_stage_repeat_count
                ];         //TASK #7017
                //$result = Article_generic_form_data_temp::get_all_records('gdata_id,gdata_data,gdata_atfemt_id,gdata_dynamic_id', $elem_codition);
                $result = Article_generic_form_data_temp::get_all_records_with_bind_cond('gdata_id,gdata_data,gdata_atfemt_id,gdata_dynamic_id', $elem_codition);       //TASK #7017

				$forms_data = array();//$form_data = array();
				$formdetails_array = array();
                if (is_array($formelmtdata) && count($formelmtdata) > 1) {
                    foreach ($formelmtdata as $key => $formdetails) {
                        if ($formdetails != '')
							$formdetails_array[] = $formdetails;
                            if(empty($formdetails)){
                                $formdetails='';
                            }
                        $element_data = explode('_', $key);
                        $elementid = $element_data[1];
                        $dynamic_id = end($element_data);
                        $elementdata = Generic_form_elements::get_element_details_with_group($elementid);
						$processed_data = $this->process_form_element_data($elementid, $formdetails, $elementdata);
						if ($elementdata->emt_element_type != 'file') {
							$forms_data[$elementid] = $elementdata->emt_dynamic_status=='y'?is_array($formdetails)?json_encode($formdetails):$formdetails:$processed_data['elementvalue'];
						}
                    }
                }

                if (sizeof($formdetails_array) <= 0 && (is_array($formelmtdata) && count($formelmtdata) > 1)) {
					$change_status = FALSE;
					$msg = '';
					if ($autosave != 1)
						$msg ='no_data';  // lang('no_data');
					$output = array(
						'status' => 'success',
						'msg' => $msg,
						'change_status' => $change_status
					);
                    return  $this->warning('Warnings',200,$output,'warning');
				}



				if ($result) {
					$clear_elements = array();
					$exist_data = array();
					foreach ($result as $value) {
						$clear_elements[] = $value->gdata_id;
						$exist_data[$value->gdata_atfemt_id] = $value->gdata_data;
					}
					$diff_result = ($forms_data != $exist_data) ? TRUE : FALSE;

					if ($diff_result == TRUE) {
						$change_status = TRUE;
						Article_generic_form_data_temp::delete_generic_form_data_temp('gdata_id', $clear_elements);
					} else {
						if ($autosave != 1) {
							$change_status = FALSE;
						} else {
							exit;
						}
					}
				} else {
					$change_status = TRUE;
				}

                if (isset($form_data['label_only_element']) && $form_data['label_only_element'] != null){
					$insertid = $this->save_label_element($articleid, $formid, $current_status_id, $form_data, $stage_type);
				} elseif (isset($form_data['label_only_element']) && $form_data['label_only_element'] == null) {
					exit;
				}

                if (is_array($formelmtdata)) {
					$i = 1;
					foreach ($formelmtdata as $key => $formdetails) {
						if (!empty($formdetails)) {
                            $element_data = explode('_', $key);
                            $elementid = $element_data[1];
                            $dynamic_id = end($element_data);

							$elementdata = Generic_form_elements::get_element_details_with_group($elementid);

							$processed_data = $this->process_form_element_data($elementid, $formdetails, $elementdata);
                            if(empty($formdetails)){
                                $formdetails='';
                            }

							if ($elementdata->emt_element_type != 'file') {
								$dataarray = array(
									'gdata_art_id' => $articleid,
									'gdata_atf_id' => $formid,
									'gdata_atfemt_id' => $elementid,
									'gdata_artflw_id' => $current_status_id,
									'gdata_gform_title' => $elementdata->gncf_form_title,
									'gdata_gfg_id' => $elementdata->gfg_id,
									'gdata_group_name' => $elementdata->gfg_group_name,
									'gdata_label' => $elementdata->emt_label,
									'gdata_unique_identifier' => $elementdata->emt_unique_identifier,
									'gdata_data' => $elementdata->emt_dynamic_status=='y'?is_array($formdetails)?json_encode($formdetails):$formdetails:$processed_data['elementvalue'],
						            'gdata_display_data' => $elementdata->emt_dynamic_status=='y'?is_array($formdetails)?json_encode($formdetails):$formdetails:$processed_data['element_dply_data'],
                                    'gdata_dynamic_status'=>$elementdata->emt_dynamic_status=='y'?'y':'n',
									'gdata_data_order' => $i,
									'gdata_artflw_stage_repeat_count' => $stage_type->aflw_stage_repeat_count,
									'gdata_jnl_id' => $journal_records->jnl_id,
                                    'gdata_dynamic_id' => $dynamic_id);

								$insertid = Article_generic_form_data_temp::insert_record($dataarray, $this->current_user);
							}
							else
								$insertid = TRUE;
							$i++;
						}
					}

					if (isset($insertid)) {
						if ($autosave == 1)
							//$msg = '<span class="glyphicon glyphicon-ok" aria-hidden="true"></span> ' . lang('auto_save');
                            $msg = 'auto_save';
						else
							//$msg = lang('save_later');
                            $msg = 'save_later';
						$output = array(
							'status' => 'success',
							'msg' => $msg,
							'change_status' => $change_status
						);
					} else {
						$output = array(
							'status' => 'failed',
							//'msg' => '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span> ' . lang('err_save')
                            'msg' => 'err_save'
						);
					}
					return  $this->success('Success', 200, $output);
				}


            }

        }

        //print_r($form_data);exit;

    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
}

public function article_similarity_list(Request $request)
{
    try{

        $return_array=array();
        $post_data=$request->all();
        $validator = Validator::make($request->all(), [
            'article_id' => 'required',
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        $article_id=Rv_decrypt($post_data['article_id']);
        $input_arr = array(
            'input' =>$article_id,
            'type'=> 'number'
        );
        $art_id_validate = $this->Rv_validator($input_arr);
        if($art_id_validate == FALSE)
        {
          $arraymsg['mesage'] = customTrans('validation.notvalid');
         return $this->warning("Failed",200,$arraymsg);
         }
        $articleflow_table = (new \App\Models\Article_flow())->getTable();
        $genericflows_table = (new \App\Models\Generic_flows())->getTable();
        $Authors = new \App\Models\Authors();
        $Articles = new \App\Models\Articles();
        $Article_types = new \App\Models\Article_types();
        $Journals=new \App\Models\Journals;

      // $this->load->library('utility');

		$select = 'art_code,art_title,art_abstract,art_artp_id';
		$get_article_details = $Articles::get_single_record($select,"art_id={$article_id}");
         $article_type_id=$get_article_details->art_artp_id;
		$journal_details = $Article_types::get_single_record('artp_jnl_id',"artp_id={$article_type_id}");

		$journal_id=$journal_details->artp_jnl_id;
		$journal_name_details = $Journals::get_single_record('jnl_journal_name',"jnl_id={$journal_id}");
		$journal_name = $journal_name_details->jnl_journal_name;
		$get_author_details = $Authors::get_all_records('auth_usr_id',"auth_art_id={$article_id}");
		$article_title = strip_tags($get_article_details->art_title);

		$article_abstract = strip_tags($get_article_details->art_abstract);
		$article_code = $get_article_details->art_code;
		$author_array = array();
		foreach ($get_author_details as $author)
		{
			array_push($author_array, $author->auth_usr_id);
		}

        $exclude_list_array =$this->Utility('exclude_string_array')['exclude_string_array'];

		$exclude_list=array();
        if(!empty($exclude_list_array))
		{
		$exclude_list = explode(',', $exclude_list_array[0]);
		}
		$journal_name_word_list_array = explode(' ', $journal_name);
        $journal_name_word_list_array=array_filter($journal_name_word_list_array, fn($value) => !is_null($value) && $value !== '');
		$count_journal_name_word = count($journal_name_word_list_array);
		$article_title_word_list_array = explode(' ', $article_title);
		// $article_title_word_list = array_diff($article_title_word_list_array, $exclude_list);
		$count_title_word = count($article_title_word_list_array);

		$abst_word_list_array = explode(' ', $article_abstract);
		// $abst_word_list= array_diff($abst_word_list_array, $exclude_list);
		$count_abstract_word = count($abst_word_list_array);

		$title_condition_qry = '';
		$condition = '';
		$abstrlvnt_wrd_qry = '';
		$abscondition = '';
		$authrlvnt_wrd_qry = '';
		$authrlvnt_wrd_qry_legacy='';
		$auth_condition = '';
		$article_title_sql_legacy='';
		$abstrlvnt_wrd_qry_legacy='';
		$abscondition_legacy='';
		$abscondition_legacy='';
		$legacy_article_title_condition_qry='';
		$legancy_condition='';
		$journal_name_condition = '';
		$journal_name_condition_qry = '';
		$i = 0;
		$l = 0;
		/* Journal name subquery condition */
		$join_journal_inner=" JOIN rvw_article_types ON rvw_article_types.artp_id=rvw_articles.art_artp_id JOIN rvw_journals  ON  rvw_article_types.artp_jnl_id=rvw_journals.jnl_id ";
		if(!empty($journal_name_word_list_array))
		{
		foreach ($journal_name_word_list_array as $key => $journalname)
		{
			if(in_array(strtolower($journalname),$exclude_list))
			{
				$count_journal_name_word--;
			}
			else
			{
			$l++;
			$journalword = addslashes(trim($journalname));
            $journalword=str_replace(array('(', ')',']','[' ), '', $journalword);
			if(empty($journalword))
			{
				$count_journal_name_word--;
			}

			if ($count_journal_name_word != $l && !empty($journalword))
			{
				$journal_name_operator = '+';
				$journal_name_cond_opertor = ' OR ';
			}
			else
			{
				$journal_name_operator = '';
				$journal_name_cond_opertor = '';
			}
			$journal_name_con = "REGEXP '\\\b" . addslashes($journalword) . "\\\b'";
			$journal_name_condition_qry .= "IF((jnl_journal_name " . $journal_name_con . "), 1,0) " . $journal_name_operator;

			$journal_name_condition .= "jnl_journal_name LIKE '%" . addslashes($journalword) . "%' " . $journal_name_cond_opertor;

			}
		}
		}
		$journal_name_sql = 'select art_id,jnl_id,jnl_journal_name,artp_id,sum(' . $journal_name_condition_qry . ') AS sim_count FROM rvw_articles'.$join_journal_inner.' Group by art_id';

		$journal_name_sql_legacy='select jnl_id,jnl_journal_name,sum(' . $journal_name_condition_qry . ') AS sim_count FROM rvw_journals Group by jnl_id';
		/*Article title subquery condition */
		if(!empty($article_title_word_list_array))
		{
		foreach ($article_title_word_list_array as $key => $titleword)
		{
			$i++;
			$word = addslashes($titleword);
            $word=str_replace(array('(', ')',']','[' ), '', $word);
			if(empty($word))
			{
				$count_journal_name_word--;
			}
            else
            {
			if ($count_title_word != $i && !empty($word))
			{
				$operator = '+';
				$cond_opertor = ' OR ';
			}
			else
			{
				$operator = '';
				$cond_opertor = '';
			}
			$con = "REGEXP '\\\b" . addslashes($word) . "\\\b'";
			$title_condition_qry .= "IF((art_title " . $con . "), 1,0) " . $operator;
			$legacy_article_title_condition_qry.= "IF((	arld_article_title " . $con . "), 1,0) " . $operator;

			$condition .= "art_title LIKE '%" . addslashes($word) . "%' " . $cond_opertor;
			$legancy_condition.="arld_article_title LIKE '%" . $word . "%' " . $cond_opertor;
           }
		}
		}

		/* $where_jounal_condition=' AND rvw_journals.jnl_id='.$journal_id;
		$where_jounal_legacy_condition=" WHERE rvw_article_legacydata.arld_jnl_id =".$journal_id; */
		/* Join based on Journal */


		$article_title_sql = 'select art_id,art_title,sum(' . $title_condition_qry . ') AS sim_count FROM rvw_articles'.$join_journal_inner.' Group by art_id';

		$article_title_sql_legacy='select arld_id,arld_article_title,sum(' . $legacy_article_title_condition_qry . ') AS sim_count FROM rvw_article_legacydata Group by arld_id';

	/*Article Abstract subquery condition */
		$j = 0;
		if(!empty($abst_word_list_array))
		{
		foreach ($abst_word_list_array as $abskey => $abskw)
		{
			$j++;
			$absword = addslashes($abskw);
            $absword=str_replace(array( '(', ')',']','[' ), '', $absword);
			if(empty($absword))
			{
				$count_journal_name_word--;
			}
            else
            {
			if ($count_abstract_word != $j && !empty($absword))
			{
				$operatorabs = '+';
				$cond_opertorabs = ' OR ';
			}
			else
			{
				$operatorabs = '';
				$cond_opertorabs = '';
			}
			$abscon = "REGEXP '\\\b" . addslashes($absword) . "\\\b'";
			$abstrlvnt_wrd_qry .= "IF((art_abstract " . $abscon . "), 1,0) " . $operatorabs;
			$abstrlvnt_wrd_qry_legacy .= "IF((	arld_article_abstract " . $abscon . "), 1,0) " . $operatorabs;

			$abscondition .= "art_abstract LIKE '%" . addslashes($absword) . "%' " . $cond_opertorabs;
	    	$abscondition_legacy .= "arld_article_abstract LIKE '%" . addslashes($absword) . "%' " . $cond_opertorabs;
        }
		}
		}
		$article_abstract_sql = 'select art_id,art_title,sum(' . $abstrlvnt_wrd_qry . ') AS sim_count FROM rvw_articles'.$join_journal_inner.' Group by art_id';
		$article_abstract_sql_legacy = 'select arld_id,arld_article_title,sum(' . $abstrlvnt_wrd_qry_legacy . ') AS sim_count FROM rvw_article_legacydata Group by arld_id';
		$count_author_word = count($author_array);
		$k = 0;

		/*Article authors subquery condition */
		if(!empty($author_array))
		{
		foreach ($author_array as $authkey => $authkw)
		{
			$k++;
			$authword = addslashes($authkw);

			if (count($author_array) != $k)
			{
				$operatorauth = '+';
				$cond_opertorabs = ' OR ';
			}
			else
			{
				$operatorauth = '';
				$cond_opertorabs = '';
			}
			$auth_condition = "=" . $authkw;
			$authrlvnt_wrd_qry .= "IF(auth_usr_id" . $auth_condition . ", 1,0) " . $operatorauth;

			$authrlvnt_wrd_qry_legacy .= "IF(LOCATE(".$authkw.",arld_author_id)>0,1,0)" . $operatorauth;
			$abscondition .= "art_abstract LIKE '%" . $authword . "%' " . $cond_opertorabs;
		}
		}
		$page = $post_data['page'];

		if ($page > 0)
		{
			$start = ($page - 1) * 15;
		}
		else
		{
			$start = 0;
		}
		$limit = 15;
		 $max_score_array=array();
		// #4544 Manage author  data listing(normalization)
		$article_author_sql = 'select count(auth_usr_id) as authorcount,auth_art_id ,sum(' . $authrlvnt_wrd_qry . ') AS sim_count FROM rvw_article_authors GROUP BY auth_art_id';
		$article_author_legacy="select arld_id,(LENGTH(arld_author_id) - LENGTH(REPLACE(arld_author_id, ',', '')) + 1) as authorcount,sum(' . $authrlvnt_wrd_qry_legacy . ') AS sim_count,arld_id as auth_art_id FROM rvw_article_legacydata GROUP BY arld_id";


		$join_journal='';
		/* Select query legacy aricle table*/
		$select_legacy = "SELECT rvw_journals.jnl_journal_name,main_tb_legacy.arld_id, main_tb_legacy.arld_article_code,main_tb_legacy.arld_article_title,main_tb_legacy.arld_article_abstract,journal_name_similarity_tb.sim_count AS journal_name_similarity,title_similarity_tb.sim_count AS article_title_similarity,abstract_similarity_tb.sim_count AS abstract_similarity,author_similarity_tb.sim_count AS author_similarity,ROUND(journal_name_similarity_tb.sim_count/" . $count_journal_name_word . " *100) AS journal_name_percentage, ROUND(title_similarity_tb.sim_count/" . $count_title_word . " *100) AS title_percentage,ROUND(abstract_similarity_tb.sim_count/" . $count_abstract_word . " *100) AS abstract_percentage,ROUND((ROUND(journal_name_similarity_tb.sim_count/" . $count_journal_name_word . " *100)+ROUND(title_similarity_tb.sim_count/" . $count_title_word . " *100)+ROUND(abstract_similarity_tb.sim_count/" . $count_abstract_word . " *100)+ROUND(author_similarity_tb.sim_count/author_similarity_tb.authorcount*100))/4) AS averge_per,ROUND(author_similarity_tb.sim_count/author_similarity_tb.authorcount*100) AS author_persentage";

				/* Select query main  aricle table*/

		$select = "SELECT  SQL_CALC_FOUND_ROWS rvw_journals.jnl_journal_name,main_tb.art_id, main_tb.art_code,main_tb.art_title,main_tb.art_abstract,journal_name_similarity_tb.sim_count AS journal_name_similarity,title_similarity_tb.sim_count AS article_title_similarity,abstract_similarity_tb.sim_count AS abstract_similarity,author_similarity_tb.sim_count AS author_similarity,ROUND(journal_name_similarity_tb.sim_count/" . $count_journal_name_word . " *100) AS journal_name_percentage, ROUND(title_similarity_tb.sim_count/" . $count_title_word . " *100) AS title_percentage,ROUND(abstract_similarity_tb.sim_count/" . $count_abstract_word . " *100) AS abstract_percentage,ROUND((ROUND(journal_name_similarity_tb.sim_count/" . $count_journal_name_word . " *100)+ROUND(title_similarity_tb.sim_count/" . $count_title_word . " *100)+ROUND(abstract_similarity_tb.sim_count/" . $count_abstract_word . " *100)+ROUND(author_similarity_tb.sim_count/author_similarity_tb.authorcount*100))/4) AS averge_per,ROUND(author_similarity_tb.sim_count/author_similarity_tb.authorcount*100) AS author_persentage";
	/* Where  condition in article table */
		$where = " WHERE (journal_name_similarity_tb.sim_count> 0 OR title_similarity_tb.sim_count > 0  OR  abstract_similarity_tb.sim_count > 0 OR author_similarity_tb.sim_count>0)  AND  main_tb.art_id!=" . $article_id .' AND main_tb.art_status != "n" ' ;

		// $where_jounal_condition=' AND rvw_journals.jnl_id='.$journal_id;
		/* Join based on Journal */
		$join_journal=" JOIN rvw_article_types ON rvw_article_types.artp_id=main_tb.art_artp_id JOIN rvw_journals ON  rvw_article_types.artp_jnl_id=rvw_journals.jnl_id ";
        $join_journal_legacy=" JOIN rvw_journals ON main_tb_legacy.arld_jnl_id = rvw_journals.jnl_id ";
		/*join condition article table */
		$join_main_article_condition=" FROM rvw_articles AS main_tb ".$join_journal." JOIN (" . $journal_name_sql . ") AS journal_name_similarity_tb ON main_tb.art_id = journal_name_similarity_tb.art_id JOIN (" . $article_title_sql . ") AS title_similarity_tb ON main_tb.art_id = title_similarity_tb.art_id JOIN (" . $article_abstract_sql . ") AS abstract_similarity_tb ON main_tb.art_id = abstract_similarity_tb.art_id JOIN(" . $article_author_sql . ") AS author_similarity_tb ON main_tb.art_id = author_similarity_tb.auth_art_id" . $where;
		/* main article table build sql */
		$mainsql = $select .$join_main_article_condition ;
		/* Where  condition in legacy article table */
		// $where_legacy_jnl_id=' AND main_tb_legacy.arld_jnl_id='.$journal_id;

		$where_legacy=" WHERE (journal_name_similarity_tb.sim_count > 0 OR title_similarity_tb.sim_count > 0  OR  abstract_similarity_tb.sim_count > 0 OR author_similarity_tb.sim_count>0) AND main_tb_legacy.arld_id!=" . $article_id;
		/*order by averege in Descending order*/
		$order_by=' order by averge_per DESC';
		/*join condition legacy article table */
		$join_main_article_legacy_condition= " FROM  rvw_article_legacydata AS main_tb_legacy  ".$join_journal_legacy." JOIN (" . $journal_name_sql_legacy . ") AS journal_name_similarity_tb ON main_tb_legacy.arld_jnl_id = journal_name_similarity_tb.jnl_id JOIN (" . $article_title_sql_legacy . ") AS title_similarity_tb ON main_tb_legacy.arld_id = title_similarity_tb.arld_id JOIN (" . $article_abstract_sql_legacy . ") AS abstract_similarity_tb ON main_tb_legacy.arld_id = abstract_similarity_tb.arld_id JOIN(" . $article_author_legacy . ") AS author_similarity_tb ON main_tb_legacy.arld_id = author_similarity_tb.auth_art_id".$where_legacy;
			/* main legacy article table build sql */
		$mainsql_legacy=$select_legacy . $join_main_article_legacy_condition;
		/* combined sql article and legacy article */
        $limitsql=' LIMIT '.$start.', '.$limit;
		$combined_sql=$mainsql." UNION ALL ".$mainsql_legacy.$order_by.$limitsql;



			/* maximum averege  query in sql*/
		$selectmax_avg="SELECT MAX(ROUND((ROUND(journal_name_similarity_tb.sim_count/" . $count_journal_name_word . " *100)+ROUND(title_similarity_tb.sim_count/" . $count_title_word . " *100)+ROUND(abstract_similarity_tb.sim_count/" . $count_abstract_word . " *100)+ROUND(author_similarity_tb.sim_count/author_similarity_tb.authorcount*100))/4))AS total_avg";
		$max_averege_similarirty_query=	$selectmax_avg . $join_main_article_condition ;
		$max_averege_similarirty_legacy_article_query=	$selectmax_avg .$join_main_article_legacy_condition ;

	    $similartyreport = $Articles::get_records_by_raw_query($combined_sql);

		$query = 'select found_rows() count';
		$count = $Articles::get_records_by_raw_query($query);
       $max_total_avg_article=$Articles::get_records_by_raw_query($max_averege_similarirty_query);
	   $max_total_avg_legacy_article=$Articles::get_records_by_raw_query($max_averege_similarirty_legacy_article_query);


       $duplicate_score_aricle=0;
	   $duplicate_score_legacy_aricle=0;
       $max_duplcate_score=0;

		if(isset($max_total_avg_article[0]->total_avg)&&$max_total_avg_article[0]->total_avg!='')
			$duplicate_score_aricle=$max_total_avg_article[0]->total_avg;
		if(isset($max_total_avg_legacy_article[0]->total_avg)&&($max_total_avg_legacy_article[0]->total_avg!=''))
			$duplicate_score_legacy_aricle=$max_total_avg_legacy_article[0]->total_avg;
		if($duplicate_score_aricle>$duplicate_score_legacy_aricle)
			$max_duplcate_score=$duplicate_score_aricle;
		else
			$max_duplcate_score=$duplicate_score_legacy_aricle;
            /* Create CSV file  */
            //$this->create_csv_file_creation($article_id,$similarity_data);
            $array_data['article_id']=$article_id;
            $array_data['max_duplcate_score'] = $max_duplcate_score;
            $array_data['total_record'] = $count[0]->count;
            $array_data['main_data']=$similartyreport;
            /*Read Excel Updated  Data */
            #$similarity_data=$this->get_similarity_list($array_data);
            /* Read Mysql Data */
            $similarity_data=$this->get_similarity_record_data($array_data);
            $return_array['similarity_data']=$similarity_data;

        return  $this->success('Success', 200, $return_array);
    }
    catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
}
public function confirm_user_accept_reviewer_suggestion(Request $request)
	{
        try{
        $post_data= $request->all();

        parse_str(decrypt_link($post_data['user_url']), $data);
        $article_type_id=$data['article_type_id'];
        $reviewer_id = $data['reviewer_id'];
		$journal_id = $data['jnl_id'];
		$user_id = $data['userid'];
		$aflw_id = $data['aflw_id'];
		$key = $data['key'];
        $rewr_key = '';
		$today = date('Y-m-d H:i:s', time());
        $Article_reviewers=new \App\Models\Article_reviewers();

        $user_data = $this->get_current_user_details();
        // $this->session->userdata('logged_user');

        if ($user_data != NULL)
		{
			if ($user_data['user_id'] != $user_id)
			{
				// $this->session->unset_userdata('logged_user');
			}
		}

        if ($reviewer_id != '')
		{
			$rewr_key_detail =$Article_reviewers::get_single_record_with_bind_cond('sorw_rvwr_deeplink_token,sorw_art_id', array(
				'sorw_id' => $reviewer_id));
			if ($rewr_key_detail != NULL)
			{
				$rewr_key = $rewr_key_detail->sorw_rvwr_deeplink_token;
				$article_id = $rewr_key_detail->sorw_art_id;
			}
		}
        $user_data = User::get_single_record_with_bind_cond('*', array(
			'usr_id' => $user_id));

		$reviewer_role = Roles::get_single_record_with_bind_cond('role_id', array(
			'role_assigned_role' => 'reviewer'));

		$user_role_detail = array(
			'usrj_jnl_id' => $journal_id,
			'usrj_usr_id' => $user_id,
			'usrj_role_id' => $reviewer_role->role_id,
			'usrj_artp_id' => NULL,
			'usrj_invite' => 'n'
		);
        $User_to_journals = new \App\Models\User_to_journals();
		$check_user_role_id_exst = $User_to_journals::get_single_record_with_bind_cond('*', $user_role_detail);

        // $check_user_role_id_exst->isEmpty()
        if ( empty($check_user_role_id_exst))
		{
			if ($user_data != NULL && $user_data->usr_status != 'n')
			{
				// $login_session = $this->set_login_session_data($user_data);
				//$this->session->set_userdata('logged_user', $login_session);
				// $this->set_user_session_data($login_session, TRUE);

				if (($user_data->usr_status == 'w' || $user_data->usr_status == 'a') && $user_data->usr_deeplink_token == $key)
				{
//					$this->load->helper('string');
					$user_data->usr_deeplink_toke = '';

					if ($user_data->usr_status == 'a') // for existing user with deeplink token
					{
						$password = $user_data->usr_pwd;
						$user_email = $user_data->usr_email;
						User::update_record(array(
							'usr_deeplink_token' => ''), array(
							'usr_id' => $user_id));
					}
					else
					{

						$login_session['active_status'] = 'a';
						// $this->set_user_session_data($login_session, TRUE);
						if (!empty($user_data->usr_pwd) && !empty($user_data->usr_url))
						{
							$this->confirm_registered_user($user_data, $login_session,'url');
						}
						else if ((!empty($user_data->usr_deeplink_token)) || empty($user_data->usr_pwd))
						{
							$reply_to_email = NULL;
							// if ($this->current_client->functionality->cfty_enable_journal_reply_to == "y")
							// {
							// 	if ($this->jnl_data->jset_reply_to_email != "" && $this->jnl_data->jset_reply_to_email != null)
							// 		$reply_to_email = $this->jnl_data->jset_reply_to_email;
							// }
							// $this->create_user_email($user_data, $login_session, $reply_to_email);
						}
						else
						{
							User::update_record(array(
								'usr_status' => 'a'), array(
								'usr_id' => $user_id));
						}
					}
				}
				$user_data = User::get_single_record_with_bind_cond('*', array(
					'usr_id' => $user_id));

				if ($user_data->usr_status != 'w' && $user_data->usr_deeplink_token == '')
				{
					$Article_reviewers::update_record(array(
						'sorw_rvwr_deeplink_token' => ''), array(
						'sorw_id' => $reviewer_id), $this->current_user);

					//check role already exists in jrnl and article type
					$role_in_jrnl = $role_in_artp = FALSE;
					$check_role_exist_condtn = array(
						'usrj_jnl_id' => $journal_id,
						'usrj_usr_id' => $user_id,
						'usrj_role_id' => $reviewer_role->role_id,
						'usrj_artp_id' => NULL
					);
					$jrnl_role = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $check_role_exist_condtn);
					if (!empty($jrnl_role) && $jrnl_role->usrj_id > 0)
						$role_in_jrnl = TRUE;

					$check_role_exist_condtn['usrj_artp_id'] = $article_type_id;
					$artp_role = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $check_role_exist_condtn);
					if (!empty($artp_role) && $artp_role->usrj_id > 0)
						$role_in_artp = TRUE;

					$user_role_details = array(
						'usrj_jnl_id' => $journal_id,
						'usrj_usr_id' => $user_id,
						'usrj_role_id' => $reviewer_role->role_id,
						'usrj_artp_id' => NULL,
						'usrj_invite' => 'n'
					);

					if ($role_in_jrnl == FALSE)
					{
						$user_role_id = $User_to_journals::insert_record($user_role_details, $this->current_user);
					}
					//register user as article type reviewer
					$user_role_details['usrj_artp_id'] = $article_type_id;
					if ($role_in_artp == FALSE)
					{
						$user_role_id = $User_to_journals::insert_record($user_role_details, $this->current_user);
					}


					$flow_data = Article_flow::get_single_record_with_bind_cond('*', array(
						'aflw_id' => $aflw_id));
					if ($flow_data != NULL)
					{
						$aflw_data['aflw_usr_id'] = $user_id;
						$aflw_data['aflw_art_id'] = $article_id;
						$aflw_data['aflw_parent_flow_id'] = $flow_data->aflw_parent_flow_id;
						$aflw_data['aflw_status'] = 'u';
						$aflw_data['aflw_assigned_date'] = $today;
						$aflw_data['aflw_jwf_id'] = $flow_data->aflw_jwf_id;					 $aflw_data['aflw_level'] = $flow_data->aflw_level;
						$aflw_id = Article_flow::insert_record($aflw_data, $this->current_user);
					}

					$reviewer_data = $Article_reviewers::update_record(array(
						'sorw_suggestion_accepted' => 'y',
						'sorw_aflw_id' => $aflw_id,
						'sorw_suggested_user_id' => $flow_data->aflw_usr_id
						), array(
						'sorw_id' => $reviewer_id), $this->current_user);
					if ($reviewer_data > 0)
					{
						$msg = 'Thank you for accepting the review invitation';
						// $this->session->set_flashdata('msg_success', $msg);
						// redirect(base_url() . 'journal/' . $this->journal_code);
					}
				}

			}
		}
        else
		{
			// $this->session->set_flashdata('msg_error', lang('confrm_failed'));
			// redirect(base_url());
		}
    }
    catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
	}

public function aricle_similarity_result(Request $request)
{
    try{
        $post_data=$request->all();
        $Authors = new \App\Models\Authors();
        $Articles = new \App\Models\Articles();
        $Article_types = new \App\Models\Article_types();
        $Journals=new \App\Models\Journals;

        $table_body = '';
		$article_id = decrypt_link($post_data['article_id']);

		//$max_duplcate_score = $post_data['max_duplcate_score'];
		//$total_count = $post_data['total_count'];
        $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
        $csv_file=storage_path() .$file_storage_path .'uploads/similarity_report/similarty_report_'.$article_id. '.csv';
        $main_array=array();
        $array_data['article_id']=$article_id;
        $array_data['total_record']=100;
        $array_data['max_duplcate_score'] =63;
        $similarity_data=$this->get_similarity_list($array_data);
		$return_array['similarity_data']=$similarity_data;
        return  $this->success('Success', 200, $return_array);

}
    catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
}

public function get_similarity_list($array_data)
{

    $article_id=$array_data['article_id'];
    $total_record=$array_data['total_record'];
    $Articles = new \App\Models\Articles();
    $max_duplcate_score = $array_data['max_duplcate_score'];
    //$total_count = $post_data['total_count'];
    $get_article_details = $Articles::get_single_record('*', "art_id={$article_id}");
    $article_title = strip_tags($get_article_details->art_title);
    $return_arr['article_title'] = $article_title;
    $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
    $csv_file=storage_path() .$file_storage_path .'uploads/similarity_report/similarty_report_'.$article_id. '.csv';
    $main_array=array();
    if(file_exists($csv_file))
    {

        $file = fopen($csv_file, 'r');
        fgetcsv($file);
        $numrow = 0;
        $page = 1;
        if ($page > 0) {
            $start = ($page - 1) * 100;
        } else {
            $start = 0;
        }
        $limit = 100;
        $i = 0;

        while (($row = fgetcsv($file)) && ($numrow < $limit)) {
            if ($i >= $start) {
                $numrow = $numrow + 1;
                $data['jnl_journal_name']	= $row[0];
                $data['art_code']			= $row[1];
                $data['art_title']  		= $row[2];
                $data['art_abstract']  		= $row[3];
                $data['journal_name_percentage']= $row[4];
                $data['title_percentage']  	= $row[5];
                $data['abstract_percentage']= $row[6];
                $data['author_persentage']  = $row[7];
                $data['averge_per']  		= $row[8];
                $main_array[]=$data;
            }
            $i++;
        }

        $return_arr['links'] = '';
        $return_arr['datainfo']=$main_array;
        $return_arr['max_duplcate_score'] = $max_duplcate_score;
        $return_arr['total_record'] =$total_record;
        return $return_arr;
        //$get_article_details = $Articles::get_single_record('*',"art_id={$article_id}");
    }
}
     public function get_similarity_record_data($array_data)
     {

        $article_id=$array_data['article_id'];
        $total_record=$array_data['total_record'];
        $main_array=$array_data['main_data'];
        $Articles = new \App\Models\Articles();
        $max_duplcate_score = $array_data['max_duplcate_score'];
        //$total_count = $post_data['total_count'];
        $get_article_details = $Articles::get_single_record('*', "art_id={$article_id}");
        $article_title = strip_tags($get_article_details->art_title);
        $return_arr['article_title'] = $article_title;
         $return_arr['totalpage']=ceil($total_record / 15);;
        $return_arr['links'] = '';
        $return_arr['datainfo']=$main_array;
        $return_arr['max_duplcate_score'] = $max_duplcate_score;
        $return_arr['total_record'] =$total_record;
        return $return_arr;

}
public function create_csv_file_creation($article_id)
{
    $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
    $sourcepath = storage_path() . $file_storage_path ."uploads/similarity_report";
    $csv_file=$file_storage_path .'uploads/similarity_report/similarty_report_'.$article_id. '.csv';
 if (!file_exists($file_storage_path .'uploads/similarity_report/similarty_report_'.$article_id. '.csv'))
 {
   $path = 'public/uploads/similarity_report';
   $this->addDireactory($path);

 }

    $file = fopen(storage_path().$csv_file,'w');
    $headers = array('Journal Name','Article ID','Article title','Abstract','Journal Name Similarity','Title Similarity','Abstract Similarity','Author Similarity','averege similarity');
    header("Content-type: application/octet-stream");
    header("Content-Disposition: attachment; filename=$csv_file");
    header("Pragma: no-cache");
    header("Expires: 0");
    fputcsv($file, $headers);
    foreach($similartyreport as $data)
    {
        $csv_content['journal_name']  = $data->jnl_journal_name;
        $csv_content['article_id']  = $data->art_code;
        $csv_content['article_title']=$data->art_title;
        $csv_content['article_abstract']=$data->art_abstract;
        $csv_content['journal_name_similarity']=$data->journal_name_percentage;
        $csv_content['title_similarity']=$data->title_percentage;
        $csv_content['abstract_similarity']=$data->abstract_percentage;
        $csv_content['author_similarity']=$data->author_persentage;
        $csv_content['averge_per']=$data->averge_per;
        fputcsv($file, $csv_content);
    }
    fclose($file);
}



public function save_transfer_suggestion(Request $request)	{
    try {
        $post_data = $request->all();
        $validator = Validator::make($request->all(), [
            'suggestion' => 'required',
            'jnl_id' => 'required',
            'jnl_code' => 'required',
            'article_id' => 'required',
            'flow_id' => 'required'

        ]);
        if ($validator->fails()) {
            return  $this->warning('Warnings',200,$validator->errors(),'warning');
        }

        $result=array();
        $this->current_user = $this->get_current_user_details();

        $transfer_data = $request->all();
        $cur_status_id=$this->decrypt_data($transfer_data['flow_id']);
        $journal_id=$this->decrypt_data($transfer_data['jnl_id']);
        $article_id=$this->decrypt_data($transfer_data['article_id']);
        $jnl_code=$transfer_data['jnl_code'];

        $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
        $user_id = $this->current_user['user_id'];

        $condition = array(
			'ats_art_id' => $article_id,
			'ats_src_jnl' => $journal_id,
			'ats_aflw_id' => $cur_status_id);

		$existing_data = $Article_transfer_suggestion->get_single_record('*',"ats_art_id={$article_id} and ats_src_jnl={$journal_id} and ats_aflw_id={$cur_status_id}");

        $save_status = FALSE;
		$insert_data['ats_author_action'] = $transfer_data['suggestion'];
		$insert_data['ats_action_time'] = date('Y-m-d H:i:s');
     /* TASK #9176 ADD reason for do not transfer option */
     if(isset($transfer_data['suggestion'])&&$transfer_data['suggestion']==0){
    $insert_data['ats_reason'] = $transfer_data['reason'];
      }
      /* TASK #9176 */
		if (!empty($existing_data)) {
			$save_status = $Article_transfer_suggestion::update_record($insert_data,"ats_art_id={$article_id} and ats_src_jnl={$journal_id} and ats_aflw_id={$cur_status_id}", $this->current_user);
		}

        if ($save_status) {
			$result['status'] = 'success';
            $result['msg'] = customTrans('transit.transfer_suggestion_save_success');
			$result['forms_validated'] = $this->validate_stage_forms($cur_status_id,$journal_id,$jnl_code,array());
			$redirect_url = '';
			if ($transfer_data['suggestion'] == 1) {
				$redirect_url = $this->transfer_article_create_new($article_id, $cur_status_id,false,$journal_id,$jnl_code);
			}
			$result['redirect_url'] = $redirect_url;
		}



        return $this->success('Success', 200, $result);
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
}

public function getAllAssignedworkflowid($flowids) {
    $this->completed = array();
    $flowids=implode(",",$flowids);
    $Generic_flows = new \App\Models\Generic_flows();
    //$get_current_data = $Generic_flows::get_all_records('jwf_id,jwf_stage_type,jwf_role_id,jwf_child_stages','jwf_id in('.$flowids.')');
    //print_r($flowids);die;
    $sql="select jwf_id,jwf_stage_type,jwf_role_id,jwf_child_stages from rvw_journal_workflows where jwf_id in (".$flowids.") ";
    $get_current_data=$Generic_flows::get_records_by_raw_query($sql);
    if(!empty($get_current_data)) {
            foreach ($get_current_data as $element) {
                if (!in_array((string)$element->jwf_id, $this->completed)) {
                    array_push($this->completed, $element->jwf_id);
                }
                $child_stages=json_decode($element->jwf_child_stages,TRUE);

                if(count(json_decode($element->jwf_child_stages,1)) != 0) {
                    $this->getnextworkflowids($child_stages);
                }
            }

    }
    return $this->completed;

}

public function getnextworkflowids($flowids) {
    $flowids=implode(",",$flowids);
    $Generic_flows = new \App\Models\Generic_flows();
    $get_current_data = $Generic_flows::get_all_records('jwf_id,jwf_stage_type,jwf_role_id,jwf_child_stages','jwf_id in('.$flowids.')');
    $sql="select jwf_id,jwf_stage_type,jwf_role_id,jwf_child_stages from rvw_journal_workflows where jwf_id in (".$flowids.") ";
    $get_current_data=$Generic_flows::get_records_by_raw_query($sql);
    if(!empty($get_current_data)) {
            foreach ($get_current_data as $element) {
                if (!in_array((string)$element->jwf_id, $this->completed)) {
                    array_push($this->completed, $element->jwf_id);
                }
                $child_stages=json_decode($element->jwf_child_stages,TRUE);
                if (!empty($childstages)) {
                    foreach ($childstages as $ch) {
                        if (!in_array($ch, $this->completed)) {
                            array_push($this->tocomplete, $ch);
                        }
                    }
                }
            }

            if (count($this->tocomplete) > 0) {
                foreach ($this->tocomplete as $to) {
                    $this->tocomplete = array_diff($this->tocomplete, array(
                        $to
                    ));
                    $this->getnextworkflowids($this->tocomplete);
                }
            }

    }
}


public function article_similarity_list_new(Request $request)
{
    try{
        $comparison_arr = array();
        //$python_logic_flag = TRUE;
        $return_array=array();
        $post_data=$request->all();
        $validator = Validator::make($request->all(), [
            'article_id' => 'required',
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        $article_id=Rv_decrypt($post_data['article_id']);
        $input_arr = array(
            'input' =>$post_data['per_page'],
            'type'=> 'number'
        );
        $per_page_validate = $this->Rv_validator($input_arr);
        $input_arr = array(
            'input' =>$article_id,
            'type'=> 'number'
        );
        $art_id_validate = $this->Rv_validator($input_arr);
        if($art_id_validate == FALSE)
        {
          $arraymsg['mesage'] = customTrans('validation.notvalid');
         return $this->warning("Failed",200,$arraymsg);
         }
        $per_page = 10;
        if(isset($post_data['per_page']) && $per_page_validate == TRUE)
            $per_page = $post_data['per_page'];

        $Articles = new \App\Models\Articles();
        $select = 'art_code,art_title,art_abstract,art_artp_id';
		$get_article_details = $Articles::get_single_record($select,"art_id={$article_id}");

        $page = $post_data['page'];

        if ($page > 0)
        {
            $start = ($page - 1) * $per_page;
        }
        else
        {
            $start = 0;
        }
        $limit = $per_page;
        $end = $start + ($limit - 1);

        $duplicate_check_upload = 'uploads/python_script';
        $duplicate_check_file_path =  $this->get_upload_path($duplicate_check_upload,FALSE,'storage',TRUE);
        if(!file_exists($duplicate_check_file_path))
        {
            $cmd = ' mkdir -p '.$duplicate_check_file_path;
            shell_exec($cmd);
        }

        $dataFile = $duplicate_check_file_path.'/'.$article_id.'.json';
        $data_result_file = $duplicate_check_file_path.'/'.$article_id.'_result.json';

        if(isset($post_data['repFJ']) && $post_data['repFJ'] == TRUE && file_exists($data_result_file))
        {
            $article_title = strip_tags($get_article_details->art_title);

            $json_Rdata = $this->ReadFJson($data_result_file,$start,$end,$limit);
            $json_Rdata['article_title'] = $article_title;
            $json_Rdata['links'] = '';

            $return_array['similarity_data'] = $json_Rdata;
        }
        else
        {
            $articleflow_table = (new \App\Models\Article_flow())->getTable();
            $genericflows_table = (new \App\Models\Generic_flows())->getTable();
            $Authors = new \App\Models\Authors();

            $Article_types = new \App\Models\Article_types();
            $Journals=new \App\Models\Journals;

            $Article_table = (new \App\Models\Articles())->getTable();
            $Article_type_table = (new \App\Models\Article_types())->getTable();
            $Author_table = (new \App\Models\Authors())->getTable();

            //FETCHING SOURCE DETAILS
            $select = 'art_code,art_title,art_abstract,art_artp_id';
            $get_article_details = $Articles::get_single_record($select,"art_id={$article_id}");
            if(!empty($get_article_details))
            {
                $article_type_id=$get_article_details->art_artp_id;
                $journal_details = $Article_types::get_single_record('artp_jnl_id',"artp_id={$article_type_id}");
                $journal_id=$journal_details->artp_jnl_id;

                $journal_name_details = $Journals::get_all_records("jnl_id,jnl_journal_name");
                $journal_name_arr = array_column(json_decode(json_encode($journal_name_details),true) ,'jnl_journal_name','jnl_id');
                $journal_name = $journal_name_arr[$journal_id];

                $get_author_details = $Authors::get_single_record('group_concat(auth_usr_id) as auth_usr_id',"auth_art_id={$article_id}",'auth_art_id');

                $article_title = trim(strip_tags(html_entity_decode($get_article_details->art_title)));
                $article_abstract = strip_tags($get_article_details->art_abstract);
                $article_code = $get_article_details->art_code;

                $exclude_list_array =$this->Utility('exclude_string_array')['exclude_string_array'];

                $exclude_list=array();
                if(!empty($exclude_list_array))
                {
                    $exclude_list = explode(',', $exclude_list_array[0]);
                }
                $journal_name = strtolower(trim($journal_name));
                $journal_name_word_list_array = explode(' ', $journal_name);
                $journal_name_word_list_array=array_filter($journal_name_word_list_array, fn($value) => !is_null($value) && $value !== '');
                $journal_name_word_list_array = array_unique($journal_name_word_list_array);

                $article_title = strtolower(trim($article_title));
                $article_title_word_list_array = explode(' ', $article_title);
                $article_title_word_list_array = array_unique($article_title_word_list_array);
                $article_title_word_list_array = array_diff($article_title_word_list_array, $exclude_list);

                $article_abstract = strtolower(trim($article_abstract));
                $abst_word_list_array = explode(' ', $article_abstract);
                $abst_word_list_array= array_diff($abst_word_list_array, $exclude_list);
                $abst_word_list_array = array_unique($abst_word_list_array);

                $article_live_sql = 'SELECT art_id,art_code,strip_tags(art_title) as art_title,strip_tags(art_abstract) as art_abstract,artp_jnl_id as jnl_id,author_table.art_authors FROM '.$Article_table.' JOIN   '.$Article_type_table.' ON art_artp_id = artp_id JOIN (SELECT auth_art_id, GROUP_CONCAT(DISTINCT auth_usr_id) AS art_authors FROM '.$Author_table.' GROUP BY auth_art_id) AS author_table ON art_id = author_table.auth_art_id where art_id != '.$article_id.' AND art_status != \'n\'  GROUP by art_id';

                $article_legacy_sql='SELECT arld_id AS art_id,arld_article_code AS art_code,arld_article_title AS art_title,arld_article_abstract AS art_abstract,arld_jnl_id AS jnl_id,arld_author_id AS art_authors  FROM rvw_article_legacydata Group by arld_id';

                $article_data_sql = $article_live_sql.' UNION '.$article_legacy_sql;

                $article_data_result = $Articles::get_records_by_raw_query($article_data_sql);
                if(!empty($article_data_result))
                {
                    //All journal list
                    $comparison_arr['all_journals'] = $journal_name_arr;
                    $comparison_arr['source_abstract'] = $abst_word_list_array;
                    $comparison_arr['source_articletitle'] = $article_title_word_list_array;
                    $comparison_arr['source_journal'] = $journal_name_word_list_array;
                    $comparison_arr['sauthors'] = $get_author_details->auth_usr_id;
                    $comparison_arr['sart_id'] = $article_id;
                    //$comparison_arr['excluded_list'] = $exclude_list;
                    $comparison_arr['data_frame'] = $article_data_result;

                    //$duplicate_check_folder = 'uploads/python_script';
                    $duplicate_check_folder = public_path();
                    $python_file_path = $duplicate_check_folder.'/dist/python/duplicate_check.py';

                    $jsonfileContent = json_encode($comparison_arr);
                    file_put_contents($dataFile, $jsonfileContent);

                    //if previous result file exist then remove it
                    if(file_exists($data_result_file))
                        unlink($data_result_file);

                    $pcnd = 'which python3';
                    $pcnd_res = shell_exec($pcnd);

                    if(file_exists($dataFile) && $pcnd_res!='')
                    {
                        $cmdPandas = 'pip show pandas 2>/dev/null | awk \'$1=="Name:" {print $2} END {if (NR == 0) print "NOT_INSTALLED"}\'';
                        $cmdPandasRes = shell_exec($cmdPandas);
                        if(trim($cmdPandasRes) == 'NOT_INSTALLED')
                        {
                            shell_exec('pip install pandas');
                        }

                        $py_cmd = "python3 ".$python_file_path." ".$data_result_file." ".$dataFile;
                        $duplicatorResult = shell_exec($py_cmd);

                        if(trim($duplicatorResult) == '0' && file_exists($data_result_file))
                        {
                            unlink($dataFile);
                            $json_Rdata = $this->ReadFJson($data_result_file,$start,$end,$limit);
                            $json_Rdata['article_title'] = $article_title;
                            $json_Rdata['links'] = '';

                            $return_array['similarity_data'] = $json_Rdata;
                        }
                        else
                        {
                            $return_array['msg']='101 -- Internal server error occured!';
                            return  $this->warning('Warnings',200,$return_array,'warning');
                        }
                    }
                    else
                    {
                        $return_array['msg']='105 -- Internal server error occured!';
                        return  $this->warning('Warnings',200,$return_array,'warning');
                    }
                }
            }
        }
        return  $this->success('Success', 200, $return_array);
    }
    catch (\Exception $e) {
        //print_r($e);exit;
        return $this->failure('Failed', 500, $e);
    }
}

//fetch data from json file
public function ReadFJson($data_result_file,$start,$end,$limit)
{
    $return_array = array();
    if(file_exists($data_result_file))
    {
        $SimilartyData = file_get_contents($data_result_file);
        $res = json_decode($SimilartyData);

        if(!empty($res))
        {
            $return_array['totalpage'] = count($res);
            /*  */
            if($return_array['totalpage']  < $end ){
                $end=$return_array['totalpage']-1;
            }

            $page_data = array();
            for($i = $start;$i<=$end;$i++)
            {
                $page_data[] = $res[$i];
            }

            //#SEND TO FRONT ENT - START#//
            $total_record = count($res);
            $totalpage = (int)($total_record/$limit);
            $return_array = array(
               // 'article_title' => $article_title,
                'totalpage' => $totalpage,
                //'links' => '',
                'datainfo' => $page_data,
                'max_duplcate_score' =>$res[0]->averge_per,
                'total_record' => $total_record
            );
            //#SEND TO FRONT ENT - END#//
        }
    }
    return $return_array;
}

/* Save Article Rating */
public function save_article_rating(Request $request)
{
    try{
        $Article_Rating = new \App\Models\Article_rating();
        $current_user = $this->get_current_user_details();
        $post_data=$request->all();
        $return_array=array();
        $validator = Validator::make($request->all(), [
            'article_id' => 'required',
            'flow_id' => 'required',
            'star_value'=>'required'
        ]);
        $article_id=decrypt_link($post_data['article_id']);
        $rating_value=$post_data['star_value'];
        $flow_id=decrypt_link($post_data['flow_id']);
        $dataarray=array('rat_art_id'=>$article_id,
        'rat_aflw_id'=>$flow_id,
        'rat_rated_by'=>$current_user['user_id'],
        'rat_star_value'=>$rating_value,
        'rat_star_comments'=>$post_data['comments_val']
    );
        $check_exist=$Article_Rating::get_single_record_with_bind_cond('count(rat_id) as cnt',array('rat_art_id'=>$article_id,'rat_aflw_id'=>$flow_id));
        if($check_exist->cnt==0)
        $insertid = $Article_Rating::insert_record($dataarray,$current_user);
        else
        $Article_Rating::update_record($dataarray,array('rat_art_id'=>$article_id,'rat_aflw_id'=>$flow_id),$current_user);
        return  $this->success('Success', 200, $return_array);
    }
    catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
}
}
