<?php

namespace App\Http\Controllers;

use App\Http\Services\ConveyService;
use App\Http\Traits\GeneralEmailTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use DB;
use App\Models\Authors;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Authors_affiliation;
use App\Models\User;
use App\Models\User_affiliations;
use App\Models\User_unregister;
use App\Models\Roles;
use App\Models\User_to_journals;
use App\Models\Journals;
use App\Models\Article_reviewers;
use App\Models\User_articles;
use App\Models\Email_templates;
use App\Models\Article_types;
use App\Models\Article_type_advance_options;
use App\Models\Article_custom_reasons;
use App\Models\Generic_flows;
use App\Jobs\addUserToConveyJob;
use App\Models\AuthorHistory;
use App\Models\Journal_permission; /*TASK #9579 Co-author basic details edit in author submission */
use App\Models\Journal_permission_master; /*TASK #9579 Co-author basic details edit in author submission */
use Illuminate\Support\Str;
use App\Http\Traits\StandaloneDataTrait;
use Illuminate\Support\Facades\URL;
use App\Http\Traits\InstituteSearchEngineTrait;
use Illuminate\Support\Facades\Crypt;
use App\Models\Journal_settings;
use Config;
use Exception;
use PhpParser\Node\Expr\Cast\Object_;
use App\Http\Traits\ResearchIntegrityTrait;
use App\Models\Research_integrity_reports;

class Manage_Article_Author_Api extends Controller
{
  use StandaloneDataTrait;
  use ResearchIntegrityTrait;
  use InstituteSearchEngineTrait,GeneralEmailTrait;
    public  function getarticleauthorslist(Request $request)
    {
    try{
        $post_data=$request->all();

        $validator=Validator::make($request->all(),[
            'art_id'=>'required',
            'journal_code'=>'required'
        ]);
        if($validator->fails())
        {
          return $this->failure('Failed',422,$validator->error());
        }
        $art_id_arr = array('input'=> Rv_Decrypt($post_data['art_id']),'type'=>'number', 'enc_data'=>FALSE );
        $art_validation= $this->Rv_validator($art_id_arr);   
        if($art_validation != TRUE)
        {
          return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
        }
      $array['article_id']=Rv_decrypt($post_data['art_id']);
      $array['jnl_code']=$request->segment(3);
      $array['current_flow_id']=Rv_decrypt($post_data['art_flow_id']);
      $array['url']=$request->segment(4);
      $user_access=$this->check_permission_access_user($array);
      if($user_access!=true)
      {
          return  $this->warning('Unauthorized', 200, 'Unauthorized User');

      }
        $journalCode      = $this->decrypt_data($post_data['journal_code']);
        $journalData      = Journals::get_journal_data($journalCode);
        $Author_credits = new \App\Models\Author_credits();
        $has_corresp_author=FALSE;
        $article_id=Rv_decrypt($post_data['art_id']);
        // $criteria = 'auth_art_id='.$article_id." AND auth_corr_author='y'";
        $criteria = "auth_art_id= ? AND auth_corr_author='y'";
        // $check_corresp_author = Authors::get_single_record('*',$criteria);
        $check_corresp_author = Authors::get_single_record('*',$criteria,binding_arr:[$article_id]);
        $current_user = $this->get_current_user_details();
        $return_array['current_usr'] = $current_user['user_id'];
        if ($check_corresp_author != NULL)
				{
					$has_corresp_author = TRUE;
				}
        // $condition='aflw_art_id='.$article_id;
        $condition='aflw_art_id= ?';
        // $article_status = Article_flow::get_single_record('aflw_id',$condition);
        $article_status = Article_flow::get_single_record('aflw_id',$condition,binding_arr:[$article_id]);
        if ($article_status != NULL)
        {
          $article_status_data = Article_flow::get_generic_flow('*',"aflw_id=$article_status->aflw_id");
          $article_status_data = $article_status_data[0];
          if ($article_status_data->jwf_stage_type == 'resubmission')
					{
				$return_array['resubmit_warning'] = 0;
						$get_pdf_status = $this->get_article_pdf_status($article_id, false);
						if (!$get_pdf_status['status'])
            $return_array['resubmit_warning'] = 1;
					}
                }
                $return_array['has_corresp_author'] = $has_corresp_author;
         $condition2='auth_art_id='.$article_id;
  		  //  $get_article_details = Articles::get_single_record('art_artp_id,art_submitted_by', "art_id ={$article_id}");
         $get_article_details = Articles::get_single_record('art_artp_id,art_submitted_by', "art_id = ?",binding_arr:[$article_id]); 
         $article_details = Article_type_advance_options::get_single_record('atotp_co_authors_agreement', "atotp_artp_id = {$get_article_details->art_artp_id}");
         $is_blinded = $this->is_custom_blinded('author', $article_id, artp:$get_article_details->art_artp_id, jnl:$journalData->jnl_journal_code);
         $coauthorlist =  Authors::get_author_user_details('usr_id,usr_username,usr_title,usr_first_name,usr_image,usr_middle_name,usr_last_name,usr_email,usr_status,auth_id,auth_usr_id,auth_corr_author,auth_confirm_status,usr_orcid_id,auth_pres_author', $condition2, 'auth_order');
         if(!$is_blinded){
         $Country_table = (new \App\Models\Country())->getTable();
         $user_titles =$this->UserConfigdata('titles')['titles'];
         $article_type_data=Article_types::get_single_record('artp_fwm_id ',"artp_id={$get_article_details->art_artp_id}");
         $articleDetails = (object) [
          'artp_id' =>$get_article_details->art_artp_id,
          'art_id' =>$article_id,
          'artp_fwm_id'=>$article_type_data->artp_fwm_id,
          'jnl_journal_code'=>$journalData->jnl_journal_code,
          'art_artp_id'=>$get_article_details->art_artp_id
      ];
        $article_privilages=$this->article_privilages($articleDetails,NULL,$journalData->jnl_journal_code);

        $show_user_info = true;
  			if(($article_privilages['reviewer'] == TRUE || $article_privilages['author'] == TRUE) && ($this->current_client->modules->mdl_review_for_doc =='y' || (($article_privilages['reviewer'] == TRUE || $article_privilages['author'] == TRUE) || ($get_article_details->art_submitted_by == $current_user['user_id'] && $this->current_client->modules->mdl_review_for_doc == 'n')))){
          $show_user_info = FALSE;
        }
        }else{
          if($coauthorlist){
            $return_array['author_data_blinded'] = true;
          }
          $coauthorlist = [];
        }
         foreach ($coauthorlist as $coauthor){
          $coauthor->authorFullname = (!empty($coauthor->usr_title)?($user_titles[$coauthor->usr_title].'. '):'') . $coauthor->usr_first_name . (!empty($coauthor->usr_middle_name)?(' ' .$coauthor->usr_middle_name.' '):' ') . (!empty($coauthor->usr_last_name)?($coauthor->usr_last_name):'');
           $sel = 'auaff_department,auaff_company,auaff_address_line1,auaff_address_line2,auaff_postal_code,auaff_postal_code,auaff_type,(select cnt_country from ' . $Country_table . ' where cnt_id = auaff_cnt_id) as aff_country';
           $crit = "auaff_auth_id ={$coauthor->auth_id} AND auaff_prime_affiliation ='y'";
           $aff = Authors_affiliation::get_single_record($sel, $crit);
           $coauthor->primary_affliation =$aff;
           $coauthor->auth_affliation = '';
          if ($aff != NUll && !empty($aff)) {
            $dept = '';
            if (!empty($aff->auaff_department)) {
              $dept = "
                    <tr>
                          <td style='font-weight:600;'>Department</td>
                          <td>{$aff->auaff_department}</td>
                    </tr>
                ";
            }
            $addr1 = '';
            if (!empty($aff->auaff_address_line1)) {
              $addr1 = "
                    <tr>
                          <td style='font-weight:600;'>Address line 1</td>
                          <td>{$aff->auaff_address_line1}</td>
                    </tr>
                ";
            } 
            $addr2 = '';
            if (!empty($aff->auaff_address_line2)) {
              $addr2 = "
                    <tr>
                          <td style='font-weight:600;'>Address line 2</td>
                          <td>{$aff->auaff_address_line2}</td>
                    </tr>
                ";
            }
            $coauthor->auth_affliation = "
                <div class='popover-content text-break author-view-popover'>
                    <table class='table table-borderless popover-table'>
                        <tbody>
                            {$dept}
                            <tr>
                                    <td style='width:150px;font-weight:600;'>Institution</td>
                                    <td>{$aff->auaff_company}</td>
                            </tr>
                            {$addr1}
                            {$addr2}
                            <tr>
                                    <td style='font-weight:600;'>Country</td>
                                    <td>{$aff->aff_country}</td>
                            </tr>
                            <tr>
                                    <td style='font-weight:600;'>Zip/Postal code</td>
                                    <td>{$aff->auaff_postal_code}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
              ";
          }
          $coauthor->atotp_co_authors_agreement = $article_details->atotp_co_authors_agreement;
          $coauthor->art_artp_id = $get_article_details->art_artp_id;
          $showConformationBtn = false;
          if($current_user['user_id'] == $coauthor->usr_id && $coauthor->auth_confirm_status == 'i' && $coauthor->atotp_co_authors_agreement =='y') // TASK #4793 Seek confirmation issue
          {
            $showConformationBtn = true;
          }
          $coauthor->showConformationBtn = $showConformationBtn;
          $displayArray = array(
            'user_id' => $coauthor->usr_id,
            'jnl_code' => $journalData->jnl_journal_code,
            'flag'     => TRUE,
            'article_id' => $article_id,
            'availability' => TRUE,
            'save_coauthor' => FALSE,
            'remove_user' => FALSE,
            'source' => FALSE,
            'salutation' => TRUE,
            'flag_only' => FALSE,
            'inactive_user' => FALSE,
            'fullname_only' => FALSE,
            'journal_id' => $journalData->jnl_id,
          );
          $coauthor->title_html            = '';
          if($show_user_info == TRUE){
            $coauthor->title_html          = $this->get_user_display_name($displayArray);
          }
          if ($this->current_client->modules->mdl_casrai_credit == 'y')
          {
          $coauthor->credits = $Author_credits->get_casrai_credits($coauthor->auth_id);
          }
        $coauthor->usr_image=$this->get_profile_image($coauthor,$coauthor->usr_id);
        }
      
        $return_array['coauthorlist'] = $coauthorlist;
        if (isset($get_article_details->art_submitted_by)) {
       $return_array['art_submitted_by'] = $get_article_details->art_submitted_by;
        }
        // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
        $return_array['client_fieldvalid']  = $this->get_clientfieldrequired_functionalities();
        return  $this->success('Success',200,$return_array);
        }
      catch (\Exception $e){
           return  $this->failure('Failed',500,$e);
       }
    }
  public function save_co_author(Request $request)
  {
    try
    {   
    $co_author = $request->all();
    $validator=Validator::make($request->all(),[
      'jnl_id'=>'required',
      'jnl_code'=>'required',
      'article_id'=>'required',
      'art_flw_id'=>'required'
  ]);
  //TASK #7687 ICE error log bug fix savecoauthor
  if($validator->fails()){
    return $this->failure('Failed',422,$validator->error());
  }
  // end TASK #7687 ICE error log bug fix savecoauthor
  $array['article_id']=decrypt_link($co_author['article_id']);
  $array['jnl_code']=$request->segment(3);
  $array['current_flow_id'] = isset($co_author['art_flw_id']) ? decrypt_link($co_author['art_flw_id']) : ''; //TASK #7687 ICE error log bug fix savecoauthor
  $array['url']=$request->segment(4);
 
  $user_access=$this->check_permission_access_user($array);
 
  if($user_access!=true)
  {
      return  $this->failure('Unauthorized', 200, 'Unauthorized User');

  }
  
		$link = '';
    $data=array();
    $insert_id='';
    $record = NULL;
		$awaiting_user = 0;
		$article_stub = FALSE;
    $correspond_author_id = '';
    $data_affiliation = array();
    $genereate_pdf_changed = FALSE;
    $affiliation_data_arr = array();
    $corresp_author = (isset($co_author['corresp_author']) && !empty($co_author['corresp_author']))? $co_author['corresp_author'][0] : 'n';
    $etmp_name="";
    $link ="";
    $Author_credits = new \App\Models\Author_credits();

    $jnl_hdn_id = decrypt_link($co_author['jnl_id']);
    $jnl_code = decrypt_link($co_author['jnl_code']);
    $core_role = $co_author['core_role'];
    $role_name = $co_author['role_name'];
    $current_user = $this->get_current_user_details();
    $title = (isset($co_author['co_author_title'])) ? $co_author['co_author_title'] : '';
    $email_address = $co_author['co_author_email_address'];
    $jnl_standalone = $co_author['jnl_standalone'];
    $user_id = decrypt_link($co_author['hdn_user_id']);
		$article_id = decrypt_link($co_author['article_id']);
    $jo_id = ($jnl_standalone == 'y') ? $jnl_hdn_id : null;
    $cur_user_details = User::get_user_by_email_journal(
      "usr_id={$current_user['user_id']}",
      $jo_id
    );
    $cur_user_details = $cur_user_details[0];
    if(!empty($cur_user_details) && $this->current_client->modules->mdl_review_for_doc == 'n')
		{
			if($cur_user_details->usr_status == 'w')
			{
				$awaiting_user =1;
			}
			elseif($cur_user_details->usr_status == 'n')
			{
				$reg_msg = 'Cannot add this user as a co-author due to the user account is already'. ' inactive';
			}
			elseif($cur_user_details->usr_status == 's')
			{
				$reg_msg = 'Cannot add this user as a co-author due to the user account is already'. ' suspended';
			}
		}
    $articletype_id = ($co_author['hdn_article_type_id']);
    $author_full_name = '';
    if (isset($title) && $title != null && $this->current_client->functionality->cfty_avoid_salutation == 'n') {
      // $author_full_name .=  (isset($title[$co_author['title']])) ? $title[$co_author['title']] : $co_author['title'];
      $author_full_name .= $title;
    }
    if (isset($first_name)) {
      $author_full_name .= ' ' . $first_name;
    }
    if (isset($last_name)) {
      $author_full_name .= ' ' . $last_name;
    }
    if (!empty($author_full_name)) {
      $author_full_name = ucfirst($author_full_name);
    }
    $article_details = Article_type_advance_options::get_single_record('atotp_co_authors_agreement', "atotp_artp_id = {$articletype_id}");
    if (!empty($article_id)) {
      if ($co_author != FALSE && isset($co_author)) {
        if($co_author['hdn_user_id']){
        $j_id = ($jnl_standalone == 'y') ? $jnl_hdn_id : null;
						$srch_user_details = User::get_user_by_email_journal('usr_id =' . decrypt_link($co_author['hdn_user_id']), $j_id);
          if (!empty($srch_user_details)) {
            $authors_table = (new \App\Models\Authors())->getTable();
            $user_table = (new \App\Models\User())->getTable();
            $criteria = "auth_art_id={$article_id} AND auth_usr_id={$srch_user_details[0]->usr_id}";
            $select_fields = 'usr_title as auth_title,usr_first_name as auth_first_name,usr_last_name as auth_last_name ,auth_id,auth_usr_id,auth_art_id,auth_corr_author,auth_confirm_status';
            $tables = array(
              'main_table' => $authors_table,
              'join_table' => array(
                $user_table => array($authors_table . '.auth_usr_id', $user_table . '.usr_id')
              )
            );
            $check_author = Authors::get_results_using_joins($tables, $select_fields, $criteria, 'single');
          }
        }
        if (!empty($check_author))
        {
          $duplication_msg = 'This user has already been added as co-author';
          if($this->current_client->modules->mdl_review_for_doc == 'y'){
            $duplication_msg= str_replace("co-author", "author", $duplication_msg);
          }
          return  $this->warning($duplication_msg, 201,[],"warning");
        }
        $data = array(
          'auth_art_id' => $article_id
        );

        $j_id = ($jnl_standalone == 'y') ? $jnl_hdn_id : null;
        $check_email = "usr_email ='{$email_address}'";
        $get_email_record = User::get_user_by_email_journal($check_email, $j_id);
        if (!empty($get_email_record[0])) {
          $get_email_record=$get_email_record[0];
          $check_author = Authors::get_single_record('*', "auth_art_id={$article_id} AND auth_usr_id={$get_email_record->usr_id}");

          if (!empty($check_author)) {
            $duplication_msg = 'That user has already been added as co-author';

            // $all_titles = $this->user->titles;
            $owner_name = $get_email_record->usr_title . '.' . $get_email_record->usr_first_name . ' ' . $get_email_record->usr_last_name;
            $confirm_msg = 'You have entered the email address <b>' . $email_address . '</b> for this user. But ' . $owner_name . ' is already registered in this system using this email address. click "confirm" to populate the details of ' . $owner_name . ' otherwise click "No" and change the email address';
          }
        }
        if (isset($corresp_author) && $corresp_author == 'y') {
          $data['auth_corr_author'] = 'y';
        } else {
          $data['auth_corr_author'] = 'n';
        } 

        if (isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y') {// Task #5181 implement presenting author for conference
          $presing_author = (isset($co_author['presenting_author']) && !empty($co_author['presenting_author']))? $co_author['presenting_author'][0] : 'n';
          $data['auth_pres_author'] = $presing_author;
        }
        
        $art_submit_status = Articles::get_single_record('art_status,art_pre_all_ids', "art_id={$article_id}");
        if (isset($co_author['hdn_user_id']) && $co_author['hdn_user_id'] != "")
        {
          $data['auth_usr_id'] = $new_user_id = decrypt_link($co_author['hdn_user_id']);

          if ($art_submit_status->art_status != 'n')
          {
            $etmp_name="coauthor_account_notification";
          }
        }else{
          $j_id = ($jnl_standalone == 'y') ? $jnl_hdn_id : null;
          $user_details = array(
            'usr_username' => $email_address,
            'usr_first_name' => $co_author['co_author_fname'],
            'usr_last_name' => $co_author['co_author_lname'],
            'usr_email' => $email_address,
            'usr_title' => $title,
            'usr_status' => 'w', // modified status from a to 'w'
            'usr_jnl_standalone' => $j_id
          );
          $key = $randomString = Str::random(20);
          $user_details['usr_deeplink_token'] = $key;

          $new_user_id = User::insert_record($user_details, $current_user);
          if($new_user_id)
          {
          $newusername=$co_author['co_author_fname'].$new_user_id;
          $data_username_new = array('usr_username' =>$newusername);
          $user_condition = "usr_id = {$new_user_id}";
          User::update_record($data_username_new, $user_condition, $this->current_user);
          }
          if ($new_user_id > 0 && ($art_submit_status->art_status != 'n' || $art_submit_status->art_pre_all_ids != NULL || $article_details->atotp_co_authors_agreement == 'y')){
            $etmp_name='coauthor_account_creation';
            $link =URL::to('/') . "/confirmation/" . encrypt_link("&key=" . $key . "&userid=" . $new_user_id."&name=coauthor_account_creation");
          }
          $data['auth_usr_id'] = $new_user_id;
        }

        if ($etmp_name!='' && $new_user_id > 0 ){
          $custom_data = array(
            'confirmation_link' => $link,
            'esl_etmp_action'=>'coauthor_notify',
            'coauthor_notify'=>True,
            'jnl_id'=>$jnl_hdn_id,
            'jnl_code'=>$jnl_code,
            'article_id'=>$article_id,
            'artp_id'=>$articletype_id,

        );
        $email_data = array(
            'type' => 'global',
            'action' => 'send',
            'email_with_login' => TRUE,
            'user_id' => $new_user_id,
            'empt_name' => $etmp_name,
            'jnl_user_role'=>array(
              'core_role'=>$core_role,
              'role_name'=>$role_name,
              'jnl_journal_code'=> $jnl_code
          ),
            'custom_data' => $custom_data
        );

        $this->master_email_details($email_data);
        }
        $current_user = $this->get_current_user_details();
        if ($article_details->atotp_co_authors_agreement == 'y' && $current_user['user_id'] != $data['auth_usr_id']) {
          $data['auth_confirm_status'] = isset($co_author['auth_confirm_status']) && $co_author['auth_confirm_status'] != "" ? $co_author['auth_confirm_status'] : "n";
        }
        $art_submit_status = Articles::get_single_record('art_stage_submission_method', "art_id={$article_id}");
        if(isset($art_submit_status->art_stage_submission_method) && $art_submit_status->art_stage_submission_method == 'n'){
          $data['auth_confirm_status'] = 'y';
        }

        if($co_author['institution'] || isset($co_author['aff_type'])){
          $data_affiliation = array(
            // 'auaff_email' => '',
            'auaff_email' => isset($co_author['affiliationemail'])?$co_author['affiliationemail']:'',
            'auaff_department' => $co_author['department'],
            'auaff_company' => $co_author['institution'],
            'auaff_address_line1' => $co_author['address_line_1'],
            'auaff_address_line2' => $co_author['address_line_2'],
            'auaff_state' => $co_author['state'],
            'auaff_cnt_id' => $co_author['country'],
            'auaff_postal_code' => $co_author['postal_code'],
            'auaff_type' => $co_author['aff_type'],
            'auaff_editable' => 'y',
            'auaff_phone'=>$co_author['phone']
            // 'auaff_prime_affiliation' => $co_author['auth_prime_aff_check']
          );
        }
      }
      $cnt = 0;
      // print_r($data);die;
      if ($data['auth_corr_author'] == 'n') {
        $co_author_cnt = Authors::get_single_record('count(*) + 1 as cnt', "auth_art_id={$article_id} AND auth_corr_author ='n'");
        $data['auth_order'] = $co_author_cnt->cnt;
        $cnt = $co_author_cnt->cnt + 1;
      } else {
        $article_authors = Authors::get_all_records('auth_id, auth_corr_author', "auth_art_id={$article_id}", 'auth_order');
        $order = 1;
        foreach ($article_authors as $auth) {
          $condition = "auth_id ={$auth->auth_id}";
          $updt_data = array(
            'auth_order' => $order
          );
          $operation = 'e';
          if ($auth->auth_corr_author == 'y') {
            $updt_data['auth_corr_author'] = 'n';
            $correspond_author_id = $this->encrypt_data($auth->auth_id);
            $operation = 'u';
          } else
            $condition .= " AND auth_order !={$order}";
          Authors::update_record($updt_data, $condition, $current_user, '', $operation);
          $order++;
        }
        $cnt = count($article_authors) + 1;
      }
      if($this->current_client->modules->mdl_review_for_doc =='y' )
      {
        $author_exist = Authors::get_single_record('count(auth_id) as cnt', 'auth_art_id =' . $article_id);
        if ($author_exist->cnt == 0) {
          $data['auth_corr_author'] = 'y';
        }
      }
      $auth_id = Authors::insert_record($data, $current_user);
      if ($auth_id == TRUE) {
        $user_affliation = User_affiliations::get_all_records('*', 'usaff_user_id =' . $data['auth_usr_id']);
        if (isset($co_author['institution']) || isset($co_author['aff_type']))
        {
          $data_affiliation['auaff_auth_id'] = $auth_id;
          $data_affiliation['auaff_posted_by'] = $current_user['user_id'];
          $data_affiliation['auaff_posted_date'] = date('Y-m-d H:i:s');
          array_push($affiliation_data_arr, $data_affiliation);
        }
        if (count($user_affliation) > 0)
        {
          $prime_aff_status = 'n';
          if (!empty($affiliation_data_arr) && isset($co_author['auaff_prime_affiliation']))
          {				
            $prime_aff_status = $co_author['auaff_prime_affiliation'];											
          }
          $affiliation_data_arr = $this->copy_user_affliation_to_author($affiliation_data_arr, $user_affliation, $auth_id, $prime_aff_status);
        }elseif($co_author['institution'] != '' || $co_author['aff_type'] != ''){
            // mail
              //code here
              if(isset($co_author['modetype']) && $co_author['modetype'] == 'add'){
                $data_affiliation['auaff_prime_affiliation'] = 'y';
              }
              $insert_id = Authors_affiliation::insert_record($data_affiliation, $current_user);
              $status = 'aff_insert_success';
              $co_author_insert = TRUE;
        }
        else{
            $insert_id = Authors_affiliation::insert_record($data_affiliation, $current_user);
        }
        /* Add co author to journal */
        $author_role_id = Roles::get_single_record('role_id', "role_assigned_role = 'author'");
        $user_in_jnl_arr = array(
          'usrj_usr_id' => $new_user_id,
          'usrj_role_id' => $author_role_id->role_id,
          'usrj_jnl_id' => $jnl_hdn_id,
          'usrj_artp_id' => null
        );
        $user_in_jnl_str = 'usrj_usr_id=' . $new_user_id . ' AND usrj_role_id =' . $author_role_id->role_id . ' AND usrj_jnl_id =' . $jnl_hdn_id . ' AND usrj_artp_id is null' ;
    
        $user_in_artp_arr = array(
          'usrj_jnl_id' => $jnl_hdn_id,
          'usrj_usr_id' => $new_user_id,
          'usrj_role_id' => $author_role_id->role_id,
          'usrj_artp_id' => $articletype_id,
        );
        $user_in_artp_str = 'usrj_jnl_id =' . $jnl_hdn_id . ' AND usrj_usr_id=' . $new_user_id . ' AND usrj_role_id=' . $author_role_id->role_id . ' AND usrj_artp_id=' . $articletype_id;
        $user_journals_count = User_to_journals::get_single_record('count(*) AS row_count', $user_in_jnl_str);
    
        if ($user_journals_count->row_count == 0) {
          $user_in_jnl_arr['usrj_invite'] = 'n';
          User_to_journals::insert_record($user_in_jnl_arr, $current_user);
        }
        $user_jnl_tb_count = User_to_journals::get_single_record('count(*) as cnt', $user_in_artp_str);
        if ($user_jnl_tb_count->cnt == 0) { //check if not exist
          $user_in_artp_arr['usrj_invite'] = 'n';
          User_to_journals::insert_record($user_in_artp_arr, $current_user);
        }
							/* Add co author to journal ends */
        $this->change_article_pdf_status($article_id, $current_user);
        /*TASK #4667 GigaScience Missing feature - Author Contributorship*/
        if (isset($co_author['autodata'][0]['cas_id']) && isset($co_author['autodata'][0]['credit_status'])) {
          $optvalue = array();
          $temp_arr = array();

          for ($i = 0; $i < count($co_author['autodata']); $i++) {
            $casrai_credits = $co_author['autodata'][$i]['cas_id'];
            $credit = $co_author['autodata'][$i]['credit_status'];
            $cr_array['acr_auth_id'] = $auth_id;
            $cr_array['acr_cas_id'] = $casrai_credits;
            $cr_array['acr_credit_status'] = $credit;
            $Author_credits::insert_record($cr_array, $current_user);
          }
        }
        /*End TASK #4667 GigaScience Missing feature - Author Contributorship*/
      }
      $msg = "Co-author added successfully";
      
      if($corresp_author == 'y')
      {
        if(isset($co_author['submit_for_production']) && $co_author['submit_for_production'] == TRUE)
        {
          $update_item = array('art_submitted_by' =>$new_user_id);
          $update_table = Articles::update_record($update_item,'art_id ='.decrypt_link($co_author['article_id']),$current_user);
        }
      $msg = "Corresponding author details added";
      }
      // Task #925 if any author changes done run the research integration report
      if(isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
      {
          $art_submit_status = Articles::get_single_record('art_status', "art_id={$article_id}");
          $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type', 'atotp_artp_id=' . $articletype_id); 
          if($article_type_options->atotp_research_integrity == 'y' && $art_submit_status->art_status == 'y'){
            if($article_type_options->atotp_rvrisubmission_type == 'auto')
              $this->generateresearchintegrity($article_id, $array['current_flow_id']);
            else {
              $data_rri   =   array();
              $data_rri['rri_new_report'] = 'n';
              Research_integrity_reports::update_record($data_rri, 'rri_art_id=' . $article_id, $current_user);
            }
          }
      }

      if(isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y'){
        $jwf_flow_name = Article_flow::find($array['current_flow_id'])?->aflw_jwf_id;
        if($jwf_flow_name && $jwf_stage = Generic_flows::find($jwf_flow_name)?->jwf_stage_type)
        {
          if(!in_array($jwf_stage, ['author_submission', 'resubmission'])){
            addUserToConveyJob::dispatch($new_user_id, $array['article_id'], [$corresp_author == 'y' ? 'Corresponding author': 'Co-author']);
          }
      }
    }

      return  $this->success($msg, 201, $insert_id);
    }
  }
  catch (\Exception $e) {
    return $this->failure('Failed', 500, $e);
}
  }
    public function get_attachmentfile_details(Request $request){
      try {
          
          $validator=Validator::make($request->all(),[
              'article_id'=>'required',
          ]);
          if($validator->fails())
          {
            return $this->failure('Failed',422,$validator->error());
          }
          $post_data = $request->all();
          $art_id_arr = array('input'=> Rv_decrypt($post_data['article_id']),'type'=>'number', 'enc_data' => FALSE );
          $art_validation= $this->Rv_validator($art_id_arr);   
          if($art_validation != TRUE)
          {
            return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
          }
          $article_id =Rv_decrypt($post_data['article_id']);
          $jnlcode =($post_data['jnlcode']);
          $attachmentfiles=new \App\Models\Attachment_files();
          $attachmenttable=(new \App\Models\Attachment_files())->getTable();
	        $attachment_file_description_table=(new \App\Models\Attachment_file_description())->getTable();
          $Article_types = new \App\Models\Article_types();
          $Generic_flows = new \App\Models\Generic_flows();
          //restricting edit-author url for users who are not allowed to view
          //TASK #3606 - Url redirecting issue in author submission - start
          $platform_data = $this->platform_basic_settings_data($jnlcode);
          $platform_id   = $platform_data->jnl_id;
          $arr = array(
              'article_id'        => $article_id,
              'article_type_code' => $post_data['art_type_code'],
              'platform_id'       => $platform_id
          );
          $check_status = $this->confirm_author_access($arr);
          if(isset($check_status['status']) && $check_status['status'] == 'failed') {
              return $this->warning("Failed",201,$check_status);
          }
          //TASK #3606 - Url redirecting issue in author submission - end
          //$criteria = "atmnt_art_id={$article_id} AND afdec_exclude_file='n' AND atmnt_label IS NOT NULL AND atmnt_designated_to like '%r%' ";
          //$criteria = "atmnt_art_id={$article_id} AND atmnt_label IS NOT NULL AND atmnt_designated_to like '%r%' ";
          $criteria = "atmnt_art_id={$article_id} AND atmnt_label IS NOT NULL";
          $select = '*';
          $tables = array(
          'main_table' => $attachmenttable,
          'join_table' => array(
          $attachment_file_description_table => array($attachmenttable . '.atmnt_label', $attachment_file_description_table . '.afdec_id', "inner"),
          )
          );
          $showAttachments= false;
          $article_attachments = $attachmentfiles::get_results_using_joins($tables, $select, $criteria, 'all');
          $current_user = $this->get_current_user_details();
  		    $flow_data = Articles::get_single_record('art_submitted_by,art_artp_id', "art_id ={$article_id}"); 
          $user_roles = $this->validate_user_journal($jnlcode, $current_user['user_id'], $flow_data->art_artp_id);
          $privileged_user = $this->has_journal_privilege($jnlcode, $current_user['user_id'], $flow_data->art_artp_id);
			    $non_author_privileged_user = $this->is_non_author_privileged_user($article_id, $privileged_user);
          $flow_master_id = $Article_types::get_single_record('artp_fwm_id', "artp_id=".$flow_data->art_artp_id);
          $stage = $Generic_flows::get_single_record('jwf_article_attachment_status', "jwf_stage_type='author_submission' AND jwf_fwm_id={$flow_master_id->artp_fwm_id}");
          $article_attachment_status = $stage->jwf_article_attachment_status;
          if (($article_attachment_status == 'y') &&(!in_array("reviewer", $user_roles["assigned_roles"]) || $non_author_privileged_user == TRUE || $flow_data->art_submitted_by == $current_user['user_id'])){
            $showAttachments= true;
          }
         $condition2='auth_art_id='.$article_id;
         $coauthorlist =  Authors::get_author_user_details('usr_id,auth_confirm_status', $condition2, 'auth_order');
         $coauthorPreview = true;
         foreach ($coauthorlist as $coauthor){
          if($current_user['user_id'] == $coauthor->usr_id){
            $coauthorPreview = false;
          }
         }
        $article_sub_status = Articles::get_single_record('art_stage_submission_method,art_es_document_status,art_es_document_type','art_id ='.$article_id);
        $es_new_doc = FALSE;
        $es_site_url = '';
        $es_article = FALSE;
        $es_download_url = '';
        $es_data = array();
        $esarray['article_id']=$article_id;
        $checkdata=$this->check_espermission_access($esarray);
        //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $article_sub_status->art_es_document_status !== 'n')
        if($checkdata==true && $article_sub_status->art_es_document_status !== 'n')
        {
          $es_article = TRUE;
          $es_new_doc = $article_sub_status->art_es_document_type;
          $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
          $es_api_data  = Config::get($es_config);
          $es_site_url = $es_api_data['api_url'];
          $encryped_article_id = Crypt::encrypt($article_id);
          $es_download_url = $es_api_data['doc_download_url'] ;
          $platform_data = $this->platform_basic_settings_data($post_data['jnlcode']);
          $date_format = $platform_data->jset_date_format;
          $query_string = 'article_id='.$article_id;
          $encrypted_string = Rv_encrypt($query_string);
          $pass_data = array('encryptedData' => $encrypted_string);
          //$pass_data = http_build_query($pass_data);
          $apiUrl = $es_api_data['main_doc_dtls'];
          $response = $this->es_curl_request($apiUrl,$pass_data);
          $response = json_decode($response);
          $es_data = array();
          $es_data['file_name'] = '';
          $es_data['file_size'] = '';
          $es_data['created_date'] = '';
          if(isset($response->status) && $response->status == 200)
          {
            $es_data['file_name'] = $response->file_name;
            $es_data['file_size'] = $response->file_size;
            if($date_format !== '')
            {
              $es_data['created_date'] = date($date_format,strtotime($response->created_at));
            }
            else
            {
              $es_data['created_date'] = $response->created_at;
            }
          }
          $description_tbl = new \App\Models\Attachment_file_description();
          $main_document =  $description_tbl::get_single_record_with_bind_cond('afdec_description',array('afdec_main_document' => 'y'));
          $es_data['main_doc_desc'] = $main_document->afdec_description;
        }
          $return_array = array(
            'article_attachments' => $article_attachments,
            'showAttachments'     => $showAttachments,
            'coauthorPreview'     => $coauthorPreview,
            'submission_status' => $article_sub_status->art_stage_submission_method,
            'es_doc_type' => $es_new_doc,
            'es_site_url' => $es_site_url,
            'es_article' => $es_article,
            'es_download_link' => $es_download_url,
            'es_doc_created_data' => $es_data
          );
          return $this->success('Success', 200, $return_array);
      } catch (\Exception $e) {

          return $this->failure('Failed', 500, $e);
      }

    }
    public function get_next_row_credits(Request $request)
    {
      try{
      $my_config = 'clients.'.$this->current_client->clnt_client_code.'.casrai_credit.credit_status';
      $credit = Config::get($my_config);
      $casrai_credits = array();
      $casrai_credits_model=new \App\Models\Casrai_credits();
      $all_casrai_credits = $casrai_credits_model::get_all_records('cas_id,cas_credit_name');	
      $return_array['credit']= $credit ;
      $return_array['casrai_credits']= $all_casrai_credits ;
      return  $this->success('Success',200,$return_array);    
    
      }
      catch (\Exception $e){

        return  $this->failure('Failed',500,$e);
    }
    }
    public function get_author_dtls_for_article(Request $request)
    {
      try{
        $post_data=$request->all();
        $validator=Validator::make($request->all(),[
          'jnl_id'=>'required',
          'auth_id'=>'required',
          'auth_usr_id'=>'required',
          'jnl_code'=>'required'
      ]);
    
        $config_afftype=Config::get('clients.'.$this->current_client->clnt_client_code.'.aff_config.user_affiliation_type');
        $auth_id =$this->decrypt_data($post_data['auth_id']);
        $auth_usr_id =$this->decrypt_data($post_data['auth_usr_id']);
        $jnlid =$this->decrypt_data($post_data['jnl_id']);
        $jnlcode =$post_data['jnl_code'];
        $get_co_au_details = Authors::get_single_record('*', "auth_id ={$auth_id}", 'auth_order');	
        $this->current_user = $this->get_current_user_details();
        $article_type_advance_options=new \App\Models\Article_type_advance_options();		
        // $authors_affiliation=new \App\Models\Authors_affiliation();		
          $titles = $this->UserConfigdata('titles')['titles'];
              $array_data['user_id'] =$get_co_au_details->auth_usr_id;
      $array_data['journal_id'] = $jnlid;
      $array_data['flag'] = TRUE;
      $array_data['article_id'] = $get_co_au_details->auth_art_id;
      $array_data['jnl_code'] = $jnlcode;
      $array['article_id']=$get_co_au_details->auth_art_id;
      $array['jnl_code']=$request->segment(3);
      $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
      $array['url']=$request->segment(4);
      $edit_basic_info = false; /*TASK #9579 Co-author basic details edit in author submission */
      $user_access=$this->check_permission_access_user($array);
      if($user_access!=true)
      {
          return  $this->failure('Unauthorized', 200, 'Unauthorized User');
    
      }
      $get_co_au_details->auth_full_name = $this->get_user_display_name($array_data);
			$user_data = User::get_single_record('usr_title,usr_image,usr_orcid_id,concat_ws(" ",usr_first_name,usr_middle_name,usr_last_name) as display_name,usr_first_name,usr_middle_name,usr_last_name,usr_email,usr_website,usr_phone_no',"usr_id ={$auth_usr_id}");
	    $get_co_au_details->user_data = $user_data;
      $Author_credits = new \App\Models\Author_credits();
      // var_dump($get_co_au_details);die;
			// $get_co_au_details->titles = $title;
		  $get_article_details = Articles::get_single_record('*', "art_id ={$get_co_au_details->auth_art_id}"); 
		  
		  $article_status = Article_flow::get_single_record('aflw_id',"aflw_art_id ={$get_co_au_details->auth_art_id}");
      $author_array = array();
    //   if (!empty($get_co_au_details))
    //   {        
       
    //    foreach ($get_co_au_details as $c_ak => $c_au)
    //    {
    //      $author_array[] = $c_ak->auth_usr_id;
    //                                          $get_co_au_details[$c_ak]->credits = '';
    //      if ($this->current_client->modules->mdl_casrai_credit == 'y')
    //      {
    //        $get_co_au_details[$c_ak]->credits = $Author_credits::get_casrai_credits($c_au->auth_id);
    //      }
    //    }
    //  }
		  $article_details = $article_type_advance_options::get_single_record('*', "atotp_artp_id = {$get_article_details->art_artp_id}");
      if ($this->current_client->modules->mdl_orcid == 'y')
			{
          $my_config = 'clients.'.$this->current_client->clnt_client_code.'.orcid.orcid';
          $config_orcid = Config::get($my_config);
      
					$jnl_id = NULL;
					$standalone_journal = $this->get_standalone_journal_data();
       
					if ($standalone_journal != null)
						$jnl_id = $standalone_journal->jnl_id;

					$orcid_jnl_id = $jnl_id;
					$orcid_uri = 'edit';

			if (isset($this->current_client->functionality) && $this->current_client->functionality->cfty_mandate_orcid == 'y')
					{
						if (!empty($get_co_au_details))
						{
              if(is_array($get_co_au_details)){
                foreach ($get_co_au_details as $c_ak => $c_au)
                {
                  $get_co_au_details[$c_ak]->confirm_orcid = ($c_au->usr_orcid_id == NULL && $c_au->auth_usr_id == $get_article_details[0]->art_submitted_by) ? 1 : 0;
                  $get_co_au_details[$c_ak]->art_id = $get_article_details[0]->art_id;
                  $get_co_au_details[$c_ak]->currentstatus = $article_status->aflw_id;
                }
              } else {
                $get_co_au_details->confirm_orcid = ($get_co_au_details->user_data->usr_orcid_id == NULL && $get_co_au_details->auth_usr_id == $get_article_details->art_submitted_by) ? 1 : 0;
                $get_co_au_details->art_id = $get_article_details->art_id;
                $get_co_au_details->currentstatus = $article_status->aflw_id;
              }
						}
					}
			}
      $get_coauthor_affs = array();
      $author_title_missing = FALSE;
      $show_add_credit = FALSE;
      $all_author_primary_aff_found = TRUE;
      foreach ($get_co_au_details as $get_co_au_detail)
      {
      $primary_aff_found = FALSE;
			$format_aff_text = array();
			$get_coauthor_affs = Authors_affiliation::user_affiliation($get_co_au_details->auth_id);
      if(!empty($get_coauthor_affs))
					{
            foreach($get_coauthor_affs as $single_co_author_aff)
						{
              $single_co_author_aff->affiliation_types =isset($config_afftype[$single_co_author_aff->auaff_type])?$config_afftype[$single_co_author_aff->auaff_type]:'';
							if($single_co_author_aff->auaff_prime_affiliation == 'y')
							{
								$primary_aff_found = TRUE;
							}
						}
					}
          if($primary_aff_found == FALSE)
					{
						$all_author_primary_aff_found = FALSE;
					}
          if ($this->current_client->modules->mdl_orcid == 'y')
					{
                            // var_dump($config_orcid);die;

						$get_co_au_details->config_orcid[] = $config_orcid;
						$get_co_au_details->orcid_jnl_id = $orcid_jnl_id;
						$get_co_au_details->orcid_uri = $orcid_uri;
					}
      $get_co_au_details->affiliations = $get_coauthor_affs;
      // $array_data['user_id'] =$get_co_au_details->auth_usr_id;
      // $array_data['journal_id'] = $jnlid;
      // $array_data['flag'] = TRUE;
      // $array_data['article_id'] = $get_co_au_details->auth_art_id;
      // $array_data['jnl_code'] = $jnlcode;
      // $get_co_au_details->auth_full_name = $this->get_user_display_name($array_data);
      $is_viewable = FALSE;
      // $privillaged_user = $this->has_journal_privilege($jnlcode, $this->current_user['user_id'], $get_article_details->art_artp_id);
      // if ($privillaged_user == TRUE)
      // {
      //     $is_viewable = TRUE;
      // }
//       // $get_co_au_detail->global_note = $this->get_global_note_popover($get_co_au_detail->auth_usr_id,$is_viewable,TRUE);
      // $get_co_au_detail->auth_flags = $this->get_user_display_name($get_co_au_detail->auth_usr_id, $this->jnl_data->jnl_id, TRUE, $article_id,'','','','','',TRUE);
      $get_co_au_details->unregistered_user = FALSE;
      $author_array[] = $get_co_au_details->auth_usr_id;
      $unregistered_user = User_unregister::get_single_record("uur_request_status","uur_usr_id={$get_co_au_details->auth_usr_id}");
      if (!empty($unregistered_user))
      {
        if ($unregistered_user->uur_request_status == "y")
        {
          $get_co_au_details->unregistered_user = TRUE;
        }
      }
    }
    $has_affiliation = $all_author_primary_aff_found;
    $get_co_au_details->author_array = $author_array;
      $this->current_user = $this->get_current_user_details();
      $logged_user_id=$this->current_user ['user_id'];
      // $logged_user_id = $this->session->userdata('logged_user')['user_id'];
			// $get_co_au_details->logged_cls = "";
			// 	if ($logged_user_id == $get_co_au_details->auth_usr_id)
			// 	{
			// 		$get_co_au_details->logged_cls = "author_cls";
			// 	}
			// $get_co_au_details->jnl_data = $this->jnl_data;
			$get_co_au_details->article_id = $get_co_au_details->auth_art_id;
			$get_co_au_details->jnl_id = $jnlid;
			// $get_co_au_details->cnt = $cnt;
			$get_co_au_details->atotp_co_authors_agreement = $article_details->atotp_co_authors_agreement;

			$get_co_au_details->prof_pic = NULL;
			// // #4544 Manage author  data listing(normalization)			
			if ($user_data->usr_image != NULL)
				{
					$get_co_au_details->prof_pic = $user_data->usr_image;
				}
			$prof_pic = $get_co_au_details->prof_pic;
			
			// $get_co_au_details->is_author = $is_author;
			// $get_co_au_details->article_stub = $article_stub;
			// $get_co_au_details->editable = $editable;
			// $get_co_au_details->hide_affiliation_email = $this->current_client->functionality;
			$get_co_au_details->auth_id = $auth_id;
			// $get_co_au_details->hdn_data = $this->input->post();
			$get_co_au_details->artp_id = $get_article_details->art_artp_id;
			// $get_co_au_details->auth_edit_delete = TRUE;
      if ($this->current_client->modules->mdl_casrai_credit == 'y')
			{
				// $this->load->model(array(
				// 	'Author_credits',
				// 	'Modules',
				// 	'Casrai_credits'));

				$get_co_au_details->credits = $Author_credits->get_casrai_credits($auth_id);
        $my_config = 'clients.'.$this->current_client->clnt_client_code.'.casrai_credit.casrai_credit';
        $priorites = Config::get($my_config);
				$get_co_au_details->casrai_status = (isset($priorites['status'])) ? $priorites['status'] : array();
				// $casrai_str = "";
                                
				// if(!empty($credits) && !empty($casrai_status))
				// {
				// 					$show_add_credit = true;
				// 	foreach ($credits as $cr)
				// 	{
				// 		$casrai_str .= ' <span class= "co_author_credits lbl-kwd label-primary label-link-inline">' . $cr->credit_name . '(' . $casrai_status[$cr->credit_status] . ')</span> ';
				// 	}
				// 	$get_co_au_details->casrai_credits_show = $casrai_str;
				// }
			}
      /*TASK #9579 Co-author basic details edit in author submission */
      if(isset($auth_usr_id) && isset($get_co_au_details->auth_art_id)){
        $authors_table = (new \App\Models\Authors())->getTable();
        $user_table = (new \App\Models\User())->getTable();
        $articles_table = (new \App\Models\Articles())->getTable();
        $select_fields = 'art_status,count(auth_id) as count';
        $criteria = ['auth_art_id'=>$get_co_au_details->auth_art_id,'auth_usr_id'=> $logged_user_id];
        $tables = array(
          'main_table' => $authors_table,
          'join_table' => array(
            $articles_table => array( $authors_table.'.auth_art_id',$articles_table.'.art_id'),
          ));
        $check_author = Authors::get_results_using_joins($tables, $select_fields, $criteria,records:'single');
        $is_author =(isset($check_author->count) && $check_author->count > 0) ? TRUE : FALSE;
        $user_status = User::get_single_record_with_bind_cond('usr_status,usr_posted_by',['usr_id'=>$auth_usr_id]);
        if ( $is_author && $check_author->art_status == 'n' && $user_status->usr_status == 'w' && $user_status->usr_posted_by == $logged_user_id){
          $edit_basic_info = true;
        }
        $get_co_au_details->edit_basic_info=$edit_basic_info;
        }
        /* end TASK #9579 Co-author basic details edit in author submission */
          return  $this->success('Success',200,$get_co_au_details);    

      }
      catch (\Exception $e){
        return  $this->failure('Failed',500,$e);
    }
    }
    public function get_author_affiliation(Request $request)
    {
      try{
        $post_data=$request->all();
        $affid = $this->decrypt_data($post_data['aff_id']);
    
			$user_aff = Authors_affiliation::get_single_record('*', "auaff_id={$affid}");
    return  $this->success('Success',200,$user_aff);   
      }
      catch (\Exception $e){
        return  $this->failure('Failed',500,$e);
    }
    }
  public function save_coauthor_affliation(Request $request)
  {
    try {
      $returnStat = false;
      $setPrimeAff = false;
      $co_author = $request->all();
      $validator=Validator::make($request->all(),[
        'art_id'=>'required',
     
    ]);
    if($validator->fails())
    {
      return $this->failure('Failed',422,$validator->errors());
    }
      $array['article_id']=$co_author['art_id'];
      $array['jnl_code']=$request->segment(3);
      $array['current_flow_id']=decrypt_link($co_author['art_flow_id']);
      $array['url']=$request->segment(4);
      
      $user_access=$this->check_permission_access_user($array);
      if($user_access!=true)
      {
          return  $this->failure('Unauthorized', 200, 'Unauthorized User');

      }
      $mode = $co_author['modetype'];
      $Author_credits = new \App\Models\Author_credits();
      $corresp_author = (isset($co_author['corresp_author'][0]) && !empty($co_author['corresp_author'][0]))? $co_author['corresp_author'][0] : 'n';
      if (isset($co_author['aff_id']) && $co_author['aff_id'] != '') {
        $aff_id = $this->decrypt_data($co_author['aff_id']);
      }
      $current_user = $this->get_current_user_details();
      if (isset($co_author['deleteaffiliationsid']) && $co_author['deleteaffiliationsid']) {
        $aff_del_arr = $co_author['deleteaffiliationsid'];

        foreach ($aff_del_arr as $aff_del_val) {
          $condition = "auaff_id={$this->decrypt_data($aff_del_val)}";
          $insert_id = Authors_affiliation::delete_records($condition, '', $current_user);
        }
      }

      if ($co_author['auth_id'] != '') {
        if ($mode == 'addaff') {
          $author_id    = $co_author['auth_id'];
          $author_dept  = (isset($co_author['department'])) ? $co_author['department'] : '';
          $author_inst  = $co_author['institution'];
          $select = 'auaff_department,auaff_company,auaff_address_line1,auaff_address_line2,auaff_cnt_id,auaff_postal_code,auaff_type';
          if($author_dept != ''){
            // $criteria = "auaff_auth_id ={$author_id} AND auaff_department = '{$author_dept}' AND auaff_company ='{$author_inst}'";
            $criteria = "auaff_auth_id =" . $author_id . " AND auaff_department = \"" . $author_dept . "\" AND auaff_company =\"" . $author_inst . "\"";
          }else {
            // $criteria = "auaff_auth_id ={$author_id} AND auaff_department IS NULL AND auaff_company ='{$author_inst}'";
            $criteria = "auaff_auth_id =" . $author_id . " AND auaff_department IS NULL AND auaff_company =\"" . $author_inst . "\"";
          }
          $auth_aff = Authors_affiliation::get_all_records($select, $criteria);
          if (count($auth_aff) > 0) {
            $msg = "Author affiliation already exist";
            return  $this->warning($msg, 200, $auth_aff, 'warning');
          } else {
            $sel = 'auaff_department,auaff_company,auaff_address_line1,auaff_address_line2,auaff_cnt_id,auaff_postal_code,auaff_type';
            $crit = "auaff_auth_id ={$author_id}";
            $all_aff = Authors_affiliation::get_all_records($sel, $crit);
            
            $returnStat = true;
            
            $data_affiliation = array(
              'auaff_auth_id' => $co_author['auth_id'],
              'auaff_email' => (isset($co_author['affiliationemail']))?$co_author['affiliationemail']:null,
              'auaff_department' => $co_author['department'],
              'auaff_company' => $co_author['institution'],
              'auaff_address_line1' => $co_author['address_line_1'],
              'auaff_address_line2' => $co_author['address_line_2'],
              'auaff_cnt_id' => $co_author['country'],
              'auaff_state' => $co_author['state'],
              'auaff_postal_code' => $co_author['postal_code'],
              'auaff_phone' => $co_author['phone'],
              'auaff_type' => $co_author['aff_type'],
              'auaff_editable' => 'y',
            );
            if($this->current_client->modules->mdl_ror == 'y' && !empty($co_author['rorIdentifier']) && $co_author['rorIdentifier'] != 'undefined') {
              $data_affiliation['auaff_ror_id'] = $co_author['rorIdentifier'];
            }elseif($this->current_client->modules->mdl_ringgold == 'y' && !empty($co_author['ringgoldIdentifier']) && $co_author['ringgoldIdentifier'] != 'undefined') {
              $data_affiliation['auaff_ringgold_id'] = $co_author['ringgoldIdentifier'];
              $post_data = array(
                'search_key' => $co_author['ringgoldIdentifier']
              );
              $response = $this->search_organisation($post_data, false, true);
              $responseArr = json_decode($response);
              $ringgoldFamily = (implode( ',',array_column( $responseArr->response, 'member')));
              $data_affiliation['auaff_ringgold_family'] = '['.$ringgoldFamily.']';
            }
            if(count($all_aff) == 0 || (isset($co_author['prime_aff_check']) && $co_author['prime_aff_check'] == true) ) {
              $data_affiliation['auaff_prime_affiliation'] = 'y';
              Authors_affiliation::update_record(array(
                'auaff_prime_affiliation' => 'n'
              ), 'auaff_auth_id =' . $co_author['auth_id'] , $current_user);
            }
            $insert_id =  Authors_affiliation::insert_record($data_affiliation, $current_user);
            // return  $this->success($mode, 200, $insert_id);
          }
        }
        if ($mode == 'affedit') {
          $data_affiliation = array(
            'auaff_auth_id' => $co_author['auth_id'],
            'auaff_email' => (isset($co_author['affiliationemail']))?$co_author['affiliationemail']:null,
            'auaff_department' => $co_author['department'],
            'auaff_company' => $co_author['institution'],
            'auaff_address_line1' => $co_author['address_line_1'],
            'auaff_address_line2' => $co_author['address_line_2'],
            'auaff_state' => $co_author['state'],
            'auaff_cnt_id' => $co_author['country'],
            'auaff_postal_code' => $co_author['postal_code'],
            'auaff_phone' => $co_author['phone'],
            'auaff_type' => $co_author['aff_type'],
            'auaff_editable' => 'y',
          );
          if(isset($co_author['prime_aff_check']) && $co_author['prime_aff_check'] == true && !empty($aff_id)){
            $data_affiliation['auaff_prime_affiliation'] = 'y';
            Authors_affiliation::update_record(array(
              'auaff_prime_affiliation' => 'n'
            ), 'auaff_auth_id =' . $co_author['auth_id'] , $current_user);
  
          }
          Authors_affiliation::update_record($data_affiliation, "auaff_id={$aff_id}", $current_user);
          $insert_id =  $aff_id;
          // return  $this->success($mode, 200, $insert_id);
          $returnStat = true;
        }
        // print_r($insert_id);die;
        if (!empty($co_author['prime_aff_check']) && $co_author['prime_aff_check'] == true)
				{ 
          $jnl_id = decrypt_link($co_author['jnl_id']);
					$select = 'auth_corr_author';
					$where = 'auth_id=' . $data_affiliation['auaff_auth_id'];
					$author_info = Authors::get_single_record($select, $where);
					if ($author_info->auth_corr_author == 'y')
					{
            $article_id = ($co_author['art_id']);
						$this->update_article_author_map($article_id, $insert_id, $jnl_id);
					}
				}
        if ($mode == 'editcoauthor' || $mode == 'delete_coau_aff') {
          $condition = "acr_auth_id={$co_author['auth_id']}";
          // print_r($co_author);die;
          $Author_credits::delete_records($condition, '', $current_user);
          if (isset($co_author['autodata'][0]['cas_id']) && isset($co_author['autodata'][0]['credit_status'])) {
            $optvalue = array();
            $temp_arr = array();

            for ($i = 0; $i < count($co_author['autodata']); $i++) {
              $casrai_credits = $co_author['autodata'][$i]['cas_id'];
              $credit = $co_author['autodata'][$i]['credit_status'];
              $cr_array['acr_auth_id'] = $co_author['auth_id'];
              $cr_array['acr_cas_id'] = $casrai_credits;
              $cr_array['acr_credit_status'] = $credit;
              $Author_credits::insert_record($cr_array, $current_user);
            }
            // return  $this->success($mode, 200, $insert_id);
            $returnStat = true;
          }
          //
          $data = array(
            'auth_art_id' => $co_author['art_id']
          );
          $data['auth_usr_id'] = ($co_author['user_id']);
          if (isset($corresp_author) && $corresp_author == 'y') {
            $data['auth_corr_author'] = 'y';
          } else {
            $data['auth_corr_author'] = 'n';
          }
          if ($data['auth_corr_author'] == 'n' && $mode !='editcoauthor') {
            $co_author_cnt = Authors::get_single_record('count(*) + 1 as cnt', "auth_art_id={$co_author['art_id']} AND auth_corr_author ='n'");
            $data['auth_order'] = $co_author_cnt->cnt;
            $cnt = $co_author_cnt->cnt + 1;
          } elseif($data['auth_corr_author'] == 'y'){
            
            $article_authors = Authors::get_all_records('auth_id, auth_corr_author', "auth_art_id={$co_author['art_id']} AND auth_id <>{$co_author['auth_id']}", 'auth_order');

            $order = 1;
            foreach ($article_authors as $auth) {
              $condition = "auth_id ={$auth->auth_id}";
              $updt_data = array(
                'auth_order' => $order
              );
              $operation = 'e';
              if ($auth->auth_corr_author == 'y') {
                $updt_data['auth_corr_author'] = 'n';
                $correspond_author_id = $this->encrypt_data($auth->auth_id);
                $operation = 'u';
              } else
              $condition .= " AND auth_order !={$order}";
             
              Authors::update_record($updt_data, $condition, $current_user, '', $operation);
              $order++;
            }
              $data['auth_order'] = 0;
          }
          $co_author_id = ($co_author['auth_id']);
          $curr_author = Authors::get_single_record('auth_corr_author,auth_editable', 'auth_id =' . $co_author_id);
         

          if (isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y') {// Task #5181 implement presenting author for conference
            $presing_author = (isset($co_author['presenting_author']) && !empty($co_author['presenting_author']))? $co_author['presenting_author'][0] : 'n';
            Authors::update_record(['auth_pres_author' => $presing_author], 'auth_id =' . $co_author_id, $current_user);
          }

          $updation = true;
          if ($curr_author->auth_corr_author != "y" || $curr_author->auth_editable != "n") {
            // print_r($data);
            // die;
            $operation = 'u';
            if ($curr_author->auth_corr_author == "y")
              $operation = 'e';

            $updation = Authors::update_record($data, 'auth_id =' . $co_author_id, $current_user, '', $operation);
          }
          /*TASK #9579 Co-author basic details edit in author submission */
          if(isset($co_author['auth_id']) && isset($co_author['art_id'])){
            $logged_user_id = $current_user['user_id'];
            $authors_table = (new \App\Models\Authors())->getTable();
            $user_table = (new \App\Models\User())->getTable();
            $articles_table = (new \App\Models\Articles())->getTable();
            $select_fields = 'art_status,count(auth_id) as count';
            $criteria = ['auth_art_id'=>$co_author['art_id'],'auth_usr_id'=> $logged_user_id];
            $tables = array(
              'main_table' => $authors_table,
              'join_table' => array(
                $articles_table => array( $authors_table.'.auth_art_id',$articles_table.'.art_id'),
              )
              );
            $check_author = Authors::get_results_using_joins($tables, $select_fields, $criteria,records:'single');
            $is_author =(isset($check_author->count) && $check_author->count > 0) ? TRUE : FALSE;
            $user_status = User::get_single_record_with_bind_cond('usr_status,usr_posted_by',['usr_id'=>$co_author['user_id']]);
            if ($is_author && $check_author->art_status == 'n' &&  $user_status->usr_status =='w' && $user_status->usr_posted_by == $logged_user_id)
              {
                  DB::beginTransaction();
                  $update_info = array(
                    'usr_title' => (isset($co_author['co_author_title']))?$co_author['co_author_title']:null,
                    'usr_first_name' => $co_author['co_author_fname'],
                    'usr_last_name' => $co_author['co_author_lname'],
                  );
                  $update_usr_info = User::update_record($update_info,['usr_id'=>$co_author['user_id']],$this->current_user);
                  DB::commit();
              }
        }
        /* end TASK #9579 Co-author basic details edit in author submission */
          // return  $this->success($mode, 200, $updation);
          $returnStat = true;
        }

        // Task #925 if any author affiliation changes done run the research integration report
        if(isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
        {
            $art_submit_status = Articles::get_single_record('art_status, art_artp_id', "art_id={$co_author['art_id']}");
            $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type', 'atotp_artp_id=' . $art_submit_status->art_artp_id); 
            if($article_type_options->atotp_research_integrity == 'y' && $art_submit_status->art_status == 'y'){
              if($article_type_options->atotp_rvrisubmission_type == 'auto')
                $this->generateresearchintegrity($co_author['art_id'], $co_author['art_flow_id']);
              else {
                $data_rri   =   array();
                $data_rri['rri_new_report'] = 'n';
                Research_integrity_reports::update_record($data_rri, 'rri_art_id=' . $co_author['art_id'], $this->current_user);
              }
            }
        }

        if($returnStat == true){
          if((isset($co_author['corresp_author']) && isset($co_author['corresp_author'][0]) && $co_author['corresp_author'][0] == 'y') && (isset($co_author['submit_for_production']) && $co_author['submit_for_production'] == TRUE))
          {
            $update_item = array('art_submitted_by' =>$co_author['user_id']);
            $update_table = Articles::update_record($update_item,'art_id ='.$co_author['art_id'],$current_user);
          }
          return  $this->success($mode, 200);
        }

      }
    } catch (\Exception $e) {
      return  $this->failure('Failed', 500, $e);
    }
  }

  // Task #6007: Request Edit Access Starts
  public function request_author_access(Request $request){
    DB::beginTransaction();
    try {
      $validator = Validator::make($request->all(), [
        'article_id' => 'required',
        'art_flow_id' => 'required',
        'jnl_id' => 'required',
        'req_reason' => 'required',
      ]);
      if ($validator->fails()) {
          return $this->failure('Failed', 200, $validator->errors()->first());
      }

      $post_data = $request->all();
      $this->current_user = $this->get_current_user_details();
      $input_arr = array(
        'input' => $post_data['article_id'],
        'enc_data' => TRUE,
        'type'=> 'number'
      );
      $validator = $this->Rv_validator($input_arr);
      $jnl_id = Rv_decrypt($request->jnl_id);
      $article_id = Rv_decrypt($post_data['article_id']);
      $art_flow_id = Rv_decrypt($post_data['art_flow_id']);
      //$user_id = Rv_decrypt($post_data['usr_id']);
      $condition = [
        'cusr_action_type' => 'prevent_edit_request_access',
        'cusr_art_id' => $article_id,
        'cusr_aflw_id' => $art_flow_id,
        'cusr_status' => 'p',
        'cusr_status_change_by' => null
      ];
      $requestExist = Article_custom_reasons::get_single_record_with_bind_cond('cusr_id', $condition);
      if($requestExist){
        return $this->failure('Failed', 200, customTrans('viewarticle.prevent_edit_requested_already'));
      }

      $artp_id = Articles::get_single_record('art_artp_id','art_id = ? ',binding_arr:[$article_id])->art_artp_id;
      $returnMessage = customTrans('viewarticle.prevent_edit_submitted');
      $records = Email_templates::get_single_record('*', "etmp_name ='prevent_edit_request_access'");
      if (!empty($records)) {
        $cfty_retire_role = FALSE;
        if ((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y') {
            $cfty_retire_role = TRUE;
        }   
        $send_mail_to_detail = $this->send_email_to($records->etmp_notification,$jnl_id,$artp_id,$article_id, $cfty_retire_role,etmp_name:$records->etmp_name);
        if (isset($send_mail_to_detail['usr_ids']) && !empty($send_mail_to_detail['usr_ids'])) {
          $send_mail_to_usr_ids = trim($send_mail_to_detail['usr_ids']);
          $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);
          $send_mail_to = trim($send_mail_to_detail['email_ids']);
          $send_mail_to=str_replace(' ', '', $send_mail_to);
          if(isset($article_id)){
            $Articles = new \App\Models\Articles;
            $jnl_journal_code = $Articles::get_art_jnl_column_val($article_id, 'jnl_journal_code');
          }
            $email_data = (Object)NULL;
            $email_data->type = 'global';
            $email_data->email_temp = 'global';
            $email_data->action = 'send';
            $email_data->email_with_login = FALSE;
            $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
            $email_data->user_email = $send_mail_to;
            $email_data->email_templates_config = $this->email_templates_config();
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();
            $email_data->empt_name = 'prevent_edit_request_access';
            $email_data->user_data = $this->current_user;
            $email_data->return_batch_id = TRUE;
            $email_data->article_id = $article_id;
            $email_data->artp_id = $artp_id;
            $email_data->etmp_notification = $records->etmp_notification;
            $email_data->prevent_edit_reason = $post_data['req_reason'];
            $email_data->jnl_journal_code = $jnl_journal_code;
            $email_data->esl_etmp_action = 'author_request_access';
            $email_data->author_request_access = TRUE;
            $email_data->reply_to =  $this->get_reply_to_email($jnl_id,$this->current_user);
            $data = array(
              'record' => $records,
              'email_data' => $email_data,
              'user_data' => $this->current_user,
              'column_prefix' =>'etmp_',
              'return_batch_id' => false,
              'email_update_data' => [],

          );
            $this->notify_mail($data);
          //}
          // DB::commit();
          // return $this->success('success',200,'Authorization request sent successfully');
          $returnMessage = customTrans('viewarticle.prevent_edit_sent');
        }else if($records->etmp_notification == 'permitted_user'){
          return $this->failure('Failed', 200, customTrans('viewarticle.prevent_edit_denied'));
        }
      }
      $custom_reason = new Article_custom_reasons;
      $reason_data = array(
        'cusr_art_id' => $article_id,
        'cusr_aflw_id' => $art_flow_id,
        'cusr_action_type' => 'prevent_edit_request_access',
        'cusr_reason' => $post_data['req_reason'] ?? "",
        'cusr_status' => 'p',
      );
      $custom_reason::insert_record($reason_data,$this->current_user);

      DB::commit();
      return $this->success('success',200,$returnMessage);
    }catch(Exception $e){
      DB::rollback();
      return $this->failure('Failed', 500, $e);
    }
  }

  public function getpreventeditactivitylist(Request $request){
    try {
      $validator = Validator::make($request->all(), [
        'art_id' => 'required',
        'art_flow_id' => 'required',
        'art_artp_id' => 'required',
      ]);
      if ($validator->fails()) {
          return $this->failure('Failed', 200, $validator->errors()->first());
      }

      $post_data = $request->all();
      $article_id = Rv_decrypt($post_data['art_id']);
      $art_artp_id = Rv_decrypt($post_data['art_artp_id']);
      $art_flow_id = Rv_decrypt($post_data['art_flow_id']);
      $journal_setting_table = (new Journal_settings())->getTable();
      $article_type_table = (new Article_types())->getTable();
      $jset_date_format = "%d-%m-%y";
      if(isset($post_data['key']) && $post_data['key'] == 'author'){
        $art_flow_id = base64_decode($art_flow_id);
        $tables = array(
          'main_table' => $journal_setting_table,
          'join_table' => array(
            $article_type_table => array($journal_setting_table . '.jset_jnl_id', $article_type_table . '.artp_jnl_id')
          )
        );
        $criteria = ['artp_id' => $art_artp_id];
        $jset = Journal_settings::get_results_using_joins($tables, 'jset_date_format', $criteria, 'single');
      }else{
        $jnl_id = Rv_decrypt($post_data['jnl_id']);
        $criteria = ['jset_jnl_id' => $jnl_id];
        $jset = Journal_settings::get_single_record_with_bind_cond('jset_date_format', $criteria);
      }
      
      
      if(isset($jset->jset_date_format)){
        $jset_date_format = '%' . $jset->jset_date_format;
        $jset_date_format = str_replace('-', '-%', $jset_date_format);
      }
      $custom_reason_activities = DB::table('rvw_article_custom_reasons')
                                    ->where(['cusr_art_id' => $article_id])
                                    ->select('*')
                                    ->selectRaw('DATE_FORMAT(cusr_posted_date, "' . $jset_date_format .' %h:%i %p") AS posted_date')
                                    ->orderBy('cusr_id','DESC')
                                    ->get();     
      if($custom_reason_activities){
        $custom_reason_activities->map(function ($item, $key) {
            $item->proxied_user = User::get_single_record_with_bind_cond('CONCAT(usr_first_name," ",usr_last_name) AS full_name', ['usr_id' => $item->cusr_proxy_id]);
            $item->posted_user = User::get_single_record_with_bind_cond('CONCAT(usr_first_name," ",usr_last_name) AS full_name', ['usr_id' => $item->cusr_posted_by]);
            return $item;
        });
      }                         

      return $this->success('success',200,$custom_reason_activities);
    }catch(Exception $e){
      return $this->failure('Failed', 500, $e);
    }
  }
  // Task #6007: Request Edit Access Ends
  //Task #7691 Starts
  public function assign_primary_authority(Request $request){
    try{
      $post_data = $request->all();
      $current_user = $this->get_current_user_details();
      $msg = "";
      if (isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y') {
        //$presing_author = (isset($co_author['presenting_author']) && !empty($co_author['presenting_author']))? $co_author['presenting_author'][0] : 'n';
        $presenting_author = $post_data['presenting_author'] ?? 'n';
        $co_author = $post_data['auth_id'] ?? "";
        Authors::update_record(['auth_pres_author' => $presenting_author],['auth_id' => $co_author], $current_user);
        //commit by rebin
        if($presenting_author == 'n') 
          $msg = "Presenting Author role removed from this author";
        else
          $msg = "Presenting Author role added to this author";
      }
      return $this->success('success',200,$msg);
    }catch(Exception $e){
      return $this->failure('Failed', 500, $e);
    }
    
  }
  //Task #7691 Ends
}
