<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Config;
use DB;
use App\Models\Articles;
use App\Models\Article_keywords;
use App\Models\Article_flow;
use App\Models\Roles;
use APP\Models\Article_flag;
use App\Models\Flags;
use App\Models\Article_notes;
use App\Models\Authors;
use App\Models\User;
use App\Models\User_to_journals;
use App\Models\Article_types;
use  App\Http\Traits\UserDataTrait;
use App\Htp\Traits\Rescind_reset_record;
use App\Models\Article_generic_form_data;
use App\Models\Generic_flows;
use App\Models\Journals;
use \stdClass;
class Manage_Article_Righticon_Api extends Controller
{
    use UserDataTrait;
public function get_selected_righticon_details(Request $request){
    try{
        $post_data=$request->all();
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'article_id'=> 'required',
            'jnl_code'=>'required',
            'current_status_id'=>'required'
        ]);
        if($validator->fails())
        {
          return $this->failure('Failed',422,$validator->errors());
        }
       $return_array=array();

        $type=$post_data['type'];
        $array['article_id']=decrypt_link($post_data['article_id']);
        $array['type']=$type;
        $array['jnl_code']=$post_data['jnl_code'];
        $array['current_flow_id']=decrypt_link($post_data['current_status_id']); //TASK #4739 Time line and email log details dosen't show in view article when allow_privileged_users_as_only_reviewer client functionality is on.
        $array['url']=$request->segment(4);
        $user_access=$this->check_permission_access_user($array);
        if($user_access!=true)
        {
            return  $this->failure('Unauthorized', 200, 'Unauthorized User');
        }
        if ($type=='timeline')
		{
		$return_array['content'] = $this->get_timeline_details($post_data);
		}
        elseif($type=='emaillog')
        {
        $return_array['content'] = $this->get_emaillog_details($post_data);

        }
        elseif ($type == 'flags')
		{
            $return_array['content'] = $this->get_flag_details($post_data);
		}
        if(isset($return_array['content']['auditrail_data']['filter_data']['stage_users'])){
            $stage_users = $return_array['content']['auditrail_data']['filter_data']['stage_users'];
            // print_r($return_array['content']['auditrail_data']['filter_data']);
            foreach($stage_users as $key => $stage_user){
                $is_blinded = $this->is_custom_blinded(null,$array['article_id'], blinded_user:$stage_user->usr_id);
                if($is_blinded){
                    $stage_user->usr_title = $stage_user->usr_last_name = $stage_user->usr_middle_name = '';
                    $stage_user->usr_first_name = $is_blinded;
                    $stage_users[$key] = $stage_user;
                }
            }

            $return_array['content']['auditrail_data']['filter_data']['stage_users'] = $stage_users;
        }
        return  $this->success('Success',201,$return_array);
    }
    catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }

}
public function article_audit_filter_data(Request $request)
{
    try{
        $post_data=$request->all();

        $validator = Validator::make($request->all(), [
            'type' => 'required'
        ]);
        if($validator->fails())
        {
            return $this->failure('Failed',422,$validator->errors());
        }
        $article_id = $this->decrypt_data($post_data['article_id']);
        $previous_show = TRUE;
        $current_journal_data['role_id']=$post_data['role_id'];
        $current_journal_data['jnl_id']=$post_data['jnl_id'];
        $current_journal_data['jnl_code']=$post_data['jnl_code'];
        $current_journal_data['core_role']=$post_data['core_role'];
        $data['filter_data'] = $this->get_article_timeline_filter_data($article_id,'timeline',$previous_show,$current_journal_data);
        return  $this->success('Success',200,$data);
    }
    catch(\Exception $e)
    {

        return $this->failure('Failed', 500, $e);
    }

}
public function get_timeline_details($post_data){

    $article_id = $this->decrypt_data($post_data['article_id']);
    $current_version_id = $this->decrypt_data($post_data['current_version_id']);
    $core_role=$post_data['core_role'];
    $this->current_user = $this->get_current_user_details();
    $current_role_status = $this->check_user_production_status($article_id,$this->current_user['user_id']);
    if($current_role_status !='review_only' && $core_role != 'journal_admin')
        $previous_show = $this->get_previous_view_permission($post_data);
    else
        $previous_show = TRUE;
    $last_action_time = '';
    $last_audit = 0;
    $limit = 200;
    $offs = ($post_data['page']-1)*100;

    $last_audit = 0;
    $current_journal_data['role_id']=$post_data['role_id'];
    $current_journal_data['jnl_id']=$post_data['jnl_id'];
    $current_journal_data['jnl_code']=$post_data['jnl_code'];
    $current_journal_data['core_role']=$post_data['core_role'];
    $timeline_filter=$this->set_filter_data($post_data);
    $data = $this->audittrial_display($article_id, $limit, $offs, $last_audit, $current_version_id, $timeline_filter,$previous_show,$current_journal_data);

    //Task #180 JPR-317 Timeline: filtering
    $data['filter_data'] = $this->get_article_timeline_filter_data($article_id,'timeline',$previous_show,$current_journal_data);
    $data['client_code'] = $this->current_client->clnt_client_code;
    $data['client_code'] = $this->current_client->clnt_client_code;
    $data['previous_show']=$previous_show;
    $return_arr = array(
        'status' => 'success',

        'auditrail_data' =>$data,
        'type'=>'timeline'
        //'filter_data' => $filters,
     //   'last_audit_trial' => $data['last_audit_trial'],
  //      'show_load_more' => $data['show_load_more'],
     //   'count' => count($data['article_auditrail_data']),
     //   'last_action_time' => $last_action_time);

    );
   return $return_arr ;

}
private function get_emaillog_details($post_data)
{
    $article_id = decrypt_link($post_data['article_id']);
    $current_version_id = decrypt_link($post_data['current_version_id']);
    $core_role=$post_data['core_role'];
    $last_action_time = '';
    $last_audit = 0;
    $limit = 100;
    $offs = 0;
    $last_audit = 0;
    $this->current_user = $this->get_current_user_details();
    $current_role_status = $this->check_user_production_status($article_id,$this->current_user['user_id']);
    $offs = ($post_data['page']-1)*100;
    //$post_data = $this->input->post();
    if($current_role_status !='review_only' && $core_role != 'journal_admin')
    {
        $previous_show = $this->get_previous_view_permission($post_data);
    }
    else
    {
        $previous_show = TRUE;
    }

    if($article_id != '' && $current_version_id != '')
    {

        $non_privileged_user_roles=$this->RolesConfigdata('non_privileged_user_roles')['non_privileged_user_roles'];
        $current_user_id='';
        if(in_array($core_role, $non_privileged_user_roles))
        {
            $current_user_id = $this->current_user['user_id'];
        }
        $current_journal_data['role_id']=$post_data['role_id'];
        $current_journal_data['jnl_id']=$post_data['jnl_id'];
        $current_journal_data['jnl_code']=$post_data['jnl_code'];
        $current_journal_data['core_role']=$post_data['core_role'];
        $email_filter=$this->set_filter_data($post_data);
        $data = $this->article_email_log($article_id,$current_version_id,$limit, $offs, $last_audit,$previous_show,$current_user_id,$current_journal_data,$email_filter);
        $data['filter_html'] = $this->get_article_timeline_filter_data($article_id,'emaillog',$previous_show,$current_journal_data);
        $data['client_code'] = $this->current_client->clnt_client_code;
        $data['previous_show']=$previous_show;
        $return_arr = array(
            'status' => 'success',

            'auditrail_data' =>$data,
            'type'=>'timeline'
            //'filter_data' => $filters,
         //   'last_audit_trial' => $data['last_audit_trial'],
      //      'show_load_more' => $data['show_load_more'],
         //   'count' => count($data['article_auditrail_data']),
         //   'last_action_time' => $last_action_time);

        );

    }
    return $return_arr ;
}

public function article_email_log($article_id,$current_version_id = NULL,$limit = 100, $offs = 0, $last_audit = 0,$previous_show = TRUE,$user_id = '',$current_journal_data=array(),$email_filter=array(),$esl_id = NULL,$parent_mail_flag = FALSE)
{

    $this->current_user = $this->get_current_user_details();
    $action = 'load';
    $last_action_time = '';
    // $user_id = '';
    $stage_id = '';
    /*if ($article_id == NULL || $current_version_id == NULL)
    {
        $action = 'search';
        $article_id = decrypt_link($this->input->post('artid'));
        $current_version_id = decrypt_link($this->input->post('current_version_id'));

        $last_action_time = trim($this->input->post('last_action_time'));
        $last_audit = $this->input->post('last_audit');

        $limit = 100;
        $offs = ($last_audit == 0) ? 0 : $last_audit * $limit;
    }*/

    $no_log_msg = 'There is no email log to display';
    if($last_audit > 0)
        $no_log_msg = 'No more email log to display';


    $emaillog_arr = array(
        'emaillog_data' => $no_log_msg,
        'status' => 'error'
    );

    if($article_id != NULL)
    {
        $Articles = new \App\Models\Articles;
        $Generic_flows = new \App\Models\Generic_flows;
        $Article_flow = new \App\Models\Article_flow;
        $Article_emaillog = new \App\Models\Article_emaillog;
        $Email_send_log = new \App\Models\Email_send_log;
        $Article_timeline = new \App\Models\Article_timeline;
        $Authors = new \App\Models\Authors;

        $where = array(
            'article_id' => $article_id);
        $article_data = $Articles::get_single_record('art_artp_id,art_prev_article_id,art_submitted_by',"art_id={$article_id}");

        $current_article_data = $Articles::get_single_record('art_pre_all_ids',"art_id={$current_version_id}");
        $previous_versions = $this->get_previous_versions($current_article_data);
        $article_data->art_id=$article_id;
        $article_data->artp_id= $article_data->art_artp_id;
        $Article_types = new \App\Models\Article_types();
        $article_types =$Article_types::get_single_record('artp_fwm_id',"artp_id={$article_data->art_artp_id}");
        $article_data->artp_fwm_id=$article_types->artp_fwm_id;

        $article_privilages = $this->article_privilages($article_data, NULL, $current_journal_data['jnl_code']);
        $last_audit_trial = $last_audit + 1;
        $posted_date = time();
        $article_posted_detail = $Articles::get_article_start_time($article_id);
        if (!empty($article_posted_detail))
        {
            $posted_date = $article_posted_detail->art_posted_date;
        }
        $action_time = $posted_date;
        $where['action_time >='] = $action_time;
        $show_load_more = 'y';

        if( $current_journal_data['core_role'] != 'journal_admin' && isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
        {
            $current_role_status = $this->check_user_production_status($article_id,$this->current_user['user_id']);

            if($current_role_status != "both")
            {

                $client_code = $this->current_client->clnt_client_code;
                $this->review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');

                $stage_for =array_column($this->review_flow,"stage_for");
                $prdn_stages= $review_stages =array();
                foreach($this->review_flow as $rf=>$r)
                {
                    if($r['stage_for'] == "manageproduction")
                    {
                        $prdn_stages[]=$rf;
                    }
                    else
                        $review_stages[]=$rf;

                }

                if($current_role_status == "review_only" || ($current_role_status =='' && $previous_show == TRUE))
                {
                    $where["jwf_stage_type"]= "" . implode("','", $review_stages) . "";
                }
                elseif($current_role_status == "production_only" || ($current_role_status =='' && $previous_show == FALSE))
                {
                    $where["jwf_stage_type"]= "" . implode("','", $prdn_stages) . "";
                }
            }
        }


        $work_tables = array(
            'email_send_log' => array()
        );
        if($esl_id != NULL){
            $work_tables['email_send_log'][] = ' esl_id = '.$esl_id;
        }
        if(isset($email_filter['user'])&&$email_filter['user']!='')
        {
            $user = $email_filter['user'];

            $work_tables['email_send_log'][] = ' (esl_user_id = '.$user.' OR  esl_posted_by ='.$user.' OR esl_proxy_id ='.$user.') ';
        }

        if(isset($email_filter['stage'])&&$email_filter['stage'] != '')
        {

            $stage = $email_filter['stage'];

            $stage_type =  $email_filter['stage_type'];
            $stage_assignment =$email_filter['stage_assignment'];
          //  $temp_stage_type =$stage ;
           /* if($temp_stage_type != '')
            {
                $stage_type_arr = explode('#', $temp_stage_type);
                $stage_type = $stage_type_arr[0];
                $stage_assignment = $stage_type_arr[1];
            }
            */
            $multi_child = FALSE;
            if($stage_assignment == 'invitation' || $stage_assignment == 'manual') // TASK #6004 The email log does not show the on complete mail entry for specific email id at DFFR completeness stage when the user selects a certain stage from all stages dropdown button
            {
                $flow_childs = $Article_flow::get_single_record('Group_concat(aflw_id) as aflw_ids',"aflw_parent_flow_id={$stage}");

                if(!empty($flow_childs))
                {
                    if($flow_childs->aflw_ids != '')
                    {
                        $stage .= ','.$flow_childs->aflw_ids;
                        $multi_child = TRUE;
                    }
                }
            }

            if($multi_child == TRUE)
                $work_tables['email_send_log'][] = ' esl_aflw_id IN ('.$stage.')';
            else
                $work_tables['email_send_log'][] = ' esl_aflw_id = '.$stage;
        }

        if(isset($email_filter['type'])&&$email_filter['type'] != '')
        {
            $type = $email_filter['type'];

            if($type == 'adhoc')
            $work_tables['email_send_log'][] = '(esl_aflw_id IS NULL OR esl_etmp_action = \'adhoc\')'; //TASK #5042 When a user sends an adhoc mail, it does not indicate that it is an adhoc mail in the timeline or email log
            elseif($type == 'system')
                $work_tables['email_send_log'][] = ' (esl_posted_by = 0 OR esl_etmp_action = \'manual_reminder\')';
            elseif($type == 'active')
                $work_tables['email_send_log'][] = ' esl_aflw_id IS NOT NULL AND esl_posted_by IS NOT NULL ';
            elseif($type == 'discussion')
                $work_tables['email_send_log'][] = ' (esl_etmp_action = \'discussion_close\' OR esl_etmp_action = \'discussion_comment\' OR esl_etmp_action = \'discussion_start\' OR esl_etmp_action = \'discussion_updation\') ';
        }

       /* if($this->input->post('user_id') != '')
        {
            $user_id = $this->input->post('user_id');
        }*/

        $receive_mail_status = isset($this->current_client->functionality->cfty_receive_email_response) ? $this->current_client->functionality->cfty_receive_email_response : 'n';
        if($user_id != '' && ($article_privilages['author'] == true || ($article_privilages['reviewer'] == true && $article_privilages['user_allocated'] == false)) && (!$parent_mail_flag) ) // Task #206 , Reply-mail parent mail issue fix
        {
            if ($this->current_client->functionality->cfty_receive_email_response == 'y')
            {
                $work_tables['email_send_log'][] = '  ((esl_trans_mode = \'r\' AND esl_posted_by = '.$user_id.') OR (esl_user_id = '.$user_id.' OR esl_posted_by = '.$user_id.' )) ';  // TASK #8781, user(author) where sent the adhoc mails to other users(user adhoc mails) must be shown in email log of that article for that user
            }else{
                $work_tables['email_send_log'][] = ' (esl_user_id = '.$user_id.' OR esl_posted_by = '.$user_id.') ';  // TASK #8781, user(author) where sent the adhoc mails to other users(user adhoc mails) must be shown in email log of that article for that user
            }
        }
        $pre_authors = '';
        // Task #206 , Reply-mail, get reply to mail (from default client config / from journal settings).
        $default_mail_box = $this->get_reply_to_email($current_journal_data['jnl_id']);
        $article_eamillog_data_details = $Article_emaillog::get_artile_email_log($article_id, $where, $limit, $offs, $pre_authors,$work_tables,$this->current_user['user_id'],$receive_mail_status,$default_mail_box,$parent_mail_flag);
        if ($article_eamillog_data_details['count_result'] < $limit)
        {
            $show_load_more = 'n';
        }

        $log_row = array();

        if(count($article_eamillog_data_details['audit_result']) > 0)
        {
            $log_row= $this->render_email_log($article_eamillog_data_details['audit_result'],$article_data,$current_journal_data);
        }
        else
        {
            $show_load_more = 'n';
        }

        $total_count = $article_eamillog_data_details['count_result'];
        $total_data_count=0;
        if(isset($total_count[0]->count))
        {
            $total_data_count=$total_count[0]->count;
        }
        //print_r($log_row_html);exit;
        $search_flag = FALSE;
        /*if($this->input->post('action') == 'search'){
            $search_flag = TRUE;
        }
        $last_audit = $this->input->post('last_audit');
         */
        $filters = '';
        //filtering
        if($last_audit == 0 && $search_flag == FALSE)
            $filters = $this->get_article_timeline_filter_data($article_id,'emaillog',$previous_show,$current_journal_data);
        $emaillog_arr = array(
            'emaillog_data' => $log_row,
            'filter_data'	=> $filters,
            'journal_code' =>$current_journal_data['jnl_code'],
            //'journal_date_format' => $this->jnl_data->jset_date_format,
            'jnl_id' =>$current_journal_data['jnl_id'],
            'art_typ_id' => $article_data->art_artp_id,
            'show_load_more' => $show_load_more,
            'last_audit_trial' => $last_audit_trial,
            'previous_versions' => $previous_versions,
            'current_version_artid' => $current_version_id,
            'article_id' => $article_id,
            'status' => 'success'
        );
    }
   /* if($action == 'search')
        echo json_encode ($emaillog_arr);
    else*/
        return $emaillog_arr;
}





public function get_previous_view_permission($post_data)
{

    $show_history=FALSE;
    $status_id= $this->decrypt_data($post_data['current_status_id']);
    $article_id=$this->decrypt_data($post_data['article_id']);
    //$status_id=$post_data['current_status_id'];
    $this->current_user = $this->get_current_user_details();
    $client_code = $this->current_client->clnt_client_code;
    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
    $this->review_flow  = Config::get($workflow_config);
    $article_flow_table=(new \App\Models\Article_flow)->getTable();
    $generic_flow_table=(new \App\Models\Generic_flows)->getTable();
        $tables = array(
            'main_table' =>$article_flow_table,
            'join_table' => array(
                $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "join")
            )
          );
    $select_cur = 'aflw_id,jwf_stage_type,aflw_usr_id';
     $current_stage_detials =Article_flow::get_results_using_joins($tables, $select_cur,"aflw_id={$status_id}",'single');
    $curr_stage_type = $current_stage_detials->jwf_stage_type;
    $curr_stage_user = $current_stage_detials->aflw_usr_id;
    if(isset($this->review_flow[$curr_stage_type]['show_rview_history']) && $this->review_flow[$curr_stage_type]['show_rview_history'] == TRUE && $curr_stage_user == $this->current_user['user_id'] && ($this->current_user['proxy_user_id'] == 0 || $this->current_user['proxy_user_id'] == $this->current_user['user_id']))
    {
        $show_history=TRUE;
    }
    return $show_history;
}


public function audittrial_display($article_id, $limit, $offs, $last_audit, $current_version_id,$timeline_filter = array(),$previous_show = TRUE,$currentjnldata=array())
{

    $this->current_user = $this->get_current_user_details();
    $date_format = $this->get_platform_date_format($currentjnldata['jnl_id']);
    $default_mail_box = $this->get_reply_to_email($currentjnldata['jnl_id']);

    $hide_stage_array= array();
    $hide_user_array =array();
    $curnt_role_id =$currentjnldata['role_id'];
    if($this->current_client->modules->mdl_review_for_doc == 'y')
    {
        $hide_stage_array = array('article_flow_transit','user_articles','change_assignment','article_figshare_docs','article_export_data');
        $hide_user_array = array('article_flow_transit','user_articles','change_assignment','article_figshare_docs','article_export_data');
    }
	$where = array(
        'article_id' => $article_id);

    $article_data =Articles::get_single_record('art_artp_id,art_delete_status,art_prev_article_id',"art_id={$article_id}");

    $current_article_data =Articles::get_single_record('art_pre_all_ids',"art_id={$current_version_id}");
    $previous_versions = $this->get_previous_versions($current_article_data);

    $last_audit_trial = $last_audit + 1;
    $posted_date = time();
    $article_posted_detail =Articles::get_article_start_time($article_id);

    if (isset($article_posted_detail)&&(!empty($article_posted_detail)))
    {
        $posted_date = $article_posted_detail->art_posted_date;
    }
    $prod_status =FALSE; $review_only =FALSE;
    if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
    {

        if($currentjnldata['core_role'] != 'journal_admin')	{
            $current_role_status = $this->check_user_production_status($article_id,$this->current_user['user_id']);

            if($current_role_status != "both")
            {
                $article_flow_table=(new \App\Models\Article_flow)->getTable();
                $generic_flow_table=(new \App\Models\Generic_flows)->getTable();
                $sql=" select aflw_returned_date from ".$article_flow_table." left join ".$generic_flow_table." on aflw_jwf_id=jwf_id where jwf_stage_type='production' and aflw_art_id=".$article_id;

                $return_data =Article_flow::get_records_by_raw_query($sql,TRUE);

                if($current_role_status == "production_only" || ($current_role_status =='' && $previous_show == FALSE))
                {
                    $action_time = $posted_date;
                    $prod_status =TRUE;
                    if(isset($return_data->aflw_returned_date))
                    $where['action_time >'] = $return_data->aflw_returned_date;
                    else
                    $where['action_time >'] = $action_time;
                }
                elseif($current_role_status == "review_only" || ($current_role_status =='' && $previous_show == TRUE))
                {
                    $review_only =TRUE;
                    $action_time = $posted_date;
                    if(!empty($return_data) && (isset($return_data->aflw_returned_date) && $return_data->aflw_returned_date!=NULL))
                    {
                        $where['action_time1'] = $action_time;
                        $where['action_time2'] = $return_data->aflw_returned_date;
                    }
                    else
                    {
                        $where['action_time >='] =$action_time;
                    }
                }
                else
                {
                    $action_time = $posted_date;
                    $where['action_time >'] =$action_time;
                }

            }
            else
            {
                $prod_status =TRUE;
                $action_time = $posted_date;
                $where['action_time >='] = $action_time;
            }

        }
        else
        {
        $prod_status =FALSE;
        $action_time = $posted_date;
        $where['action_time >='] = $action_time;
    }
    }
    else
    {
        $action_time = $posted_date;
        $where['action_time >='] = $action_time;
    }

    $show_load_more = 'y';

    $all_roles = Roles::get_all_records('role_id,role_name');
    $all_roles = $this->rebuild_array_by_field($all_roles, 'role_id');
            $cfty_edit_response_form = FALSE;

    //*****PERFORMANCE IMPROVE***(START)******
    $pre_art_authors = array();
    if ($article_data->art_prev_article_id != '')
    {
        $Authors = new \App\Models\Authors();
        $pre_art_authors =$Authors::get_single_record('Group_concat(DISTINCT auth_usr_id) as pre_authors',"auth_art_id={$article_data->art_prev_article_id}");
    }
    $pre_authors = '';
    if (!empty($pre_art_authors))
        $pre_authors = $pre_art_authors->pre_authors;
    //*****PERFORMANCE IMPROVE***(STOP)******
    /* Old Time line Fetch Details */
    //$article_auditrail_data = $this->Article_timeline->get_auditrail_data($where, $limit, $offs,$pre_authors);

    $work_tables = array();
    //Task #180 JPR-317 Timeline: filtering	******MANAGE*TIMELINE*FILTER*START******
    $allow_timeline_fetch = TRUE;
    if(count($timeline_filter) > 0)
    {
        //MANAGE USER SECTION
        if($timeline_filter['user'] != '' || $timeline_filter['stage'] != '')
        {
            $article_timeline = 'article_timeline_config.article_timeline';
            $article_timeline_config = Config::get($article_timeline);

            if($timeline_filter['user'] != '')
            {
                foreach ($article_timeline_config['user_array'] as $table_key => $column_vals)
                {
                    if(!empty($hide_user_array))
                    {
                        if(in_array($table_key,$hide_user_array))
                        {
                            unset($article_timeline_config['user_array'][$table_key]);
                            continue;
                        }
                    }

                    $temp_col = array();
                    foreach ($column_vals as $col)
                    {
                        $temp_col[] = $col.' = '.$timeline_filter['user'];
                    }

                    $temp_cnd = '';
                    if($table_key== 'article_flow')
                    {
                        $temp_cnd = ' AND aflw_usr_id != aflw_posted_by ';
                    }
                    $sql_cond = '('.implode(' OR ', $temp_col).')'.$temp_cnd;
                    $work_tables[$table_key][] = $sql_cond;
                }
            }

            if($timeline_filter['stage'] != '')
            {
                $multi_child = FALSE;
                if(isset($timeline_filter['stage_assignment'])&&$timeline_filter['stage_assignment'] == 'invitation')
                {
                    $flow_childs = Article_flow::get_single_record('Group_concat(aflw_id) as aflw_ids',"aflw_parent_flow_id={$timeline_filter['stage']}");

                    if(!empty($flow_childs))
                    {
                        if($flow_childs->aflw_ids != '')
                        {
                            $timeline_filter['stage'] .= ','.$flow_childs->aflw_ids;
                            $multi_child = TRUE;
                        }
                    }
                }

                $holding_array = array();
                foreach ($article_timeline_config['stage_array'] as $table_key => $column_vals)
                {
                    if(!empty($hide_stage_array))
                    {
                        if(in_array($table_key,$hide_stage_array))
                        {
                            unset($article_timeline_config['stage_array'][$table_key]);
                            continue;
                        }
                    }

                    if(is_array($column_vals))
                    {
                        $temp_col = array();
                        foreach ($column_vals as $col)
                        {
                            if($multi_child == TRUE)
                            {
                                $temp_col[] = $col.' IN('.$timeline_filter['stage'].')';
                            }
                            else
                                $temp_col[] = $col.' = '.$timeline_filter['stage'];
                        }

                        $sql_cond = '('.implode(' OR ', $temp_col).')';
                        $work_tables[$table_key][] = $sql_cond;
                    }
                    elseif(isset($timeline_filter['stage_type'])&&$timeline_filter['stage_type'] == 'production' && $table_key == 'article_export_data')
                    {
                        $sql_cond = $column_vals.' = '.$article_id;
                        $work_tables[$table_key][] = $sql_cond;
                    }
                    else
                    {
                        if($multi_child == TRUE)
                        {
                            $sql_cond = $column_vals.' IN('.$timeline_filter['stage'].')';
                        }
                        else
                            $sql_cond = $column_vals.' = '.$timeline_filter['stage'];

                        $work_tables[$table_key][] = $sql_cond;
                    }

                    $holding_array[$table_key] = $work_tables[$table_key];
                }

                $work_tables = $holding_array;
            }
        }
        $holding_array = array();
        if($timeline_filter['type'] != '')
        {
            if($timeline_filter['type'] == 'email')
            {
                $holding_array['email_send_log'] = isset($work_tables['email_send_log'])?$work_tables['email_send_log']:'';
            }
            elseif($timeline_filter['type'] == 'flag')
            {
                if(isset($work_tables['article_flag']))
                {
                    $holding_array['article_flag'] = $work_tables['article_flag'];
                }
                elseif($timeline_filter['stage'] != '')
                {
                    $allow_timeline_fetch = FALSE;
                }
                else
                    $holding_array['article_flag'] = '';
            }
            elseif($timeline_filter['type'] == 'note')
            {
                if(isset($work_tables['article_notes']))
                {
                    $holding_array['article_notes'] = $work_tables['article_notes'];
                }
                elseif($timeline_filter['stage'] != '')
                {
                    $allow_timeline_fetch = FALSE;
                }
                else
                    $holding_array['article_notes'] = '';
            }
            elseif($timeline_filter['type'] == 'short_assign')
            {
                $holding_array['user_articles'] = (isset($work_tables['user_articles']))?$work_tables['user_articles']:'';
                $holding_array['change_assignment'] = (isset($work_tables['change_assignment'])?$work_tables['change_assignment']:'');

                $shortlist_con = ' aflw.aflw_status = \'u\' AND aflw.aflw_usr_id IS NOT NULL AND aflw.aflw_operation = \'i\'';
                if(isset($work_tables['article_flow']))
                {
                    $holding_array['article_flow'] = $work_tables['article_flow'];
                    $holding_array['article_flow'][] = $shortlist_con;
                }
                else
                    $holding_array['article_flow'] = $shortlist_con;
            }
            elseif($timeline_filter['type'] == 'invite')
            {
                $invite_cnd = ' aflw.aflw_status IN(\'i\',\'u\')  AND aflw.aflw_usr_id IS NOT NULL AND aflw.aflw_operation = \'u\'';
                if(isset($work_tables['article_flow']))
                {
                    $holding_array['article_flow'] = $work_tables['article_flow'];
                    $holding_array['article_flow'][] = $invite_cnd;
                }
                else
                    $holding_array['article_flow'] = $invite_cnd;
            }
            elseif($timeline_filter['type'] == 'generic_discussion')
            {
                $disc_cond = '(esl_etmp_action = \'discussion_close\' OR esl_etmp_action = \'discussion_comment\' OR esl_etmp_action = \'discussion_start\' OR esl_etmp_action = \'discussion_updation\')';
                $holding_array['email_send_log'] = $disc_cond;
                $holding_array['generic_discussion'] = '';
            }
            elseif($timeline_filter['type'] == 'all')
            {
                $holding_array = $work_tables;
            }

            $work_tables = $holding_array;
        }

    }
    //filtering	******MANAGE*TIMELINE*FILTER*STOP******

            if ($this->current_client->functionality->cfty_edit_author_response_form == 'y')
            {
                $cfty_edit_response_form = TRUE;


            }else if(!empty($work_tables) && isset($work_tables['author_response_edit']) )
            {
                unset($work_tables['author_response_edit']);
            }

    /* New Time Line Fetch Details */
    if($allow_timeline_fetch == TRUE)
    {
        
        $Article_timeline = new \App\Models\Article_timeline();
        $article_auditrail_data_details = $Article_timeline::get_artile_timeline($article_id, $where, $limit, $offs, $pre_authors,$work_tables,$currentjnldata['jnl_code'],$cfty_edit_response_form,$this->current_client,$prod_status,$review_only,$default_mail_box);

    }
    else
    {
        $article_auditrail_data_details = array(
            'audit_result' => array(),
            'count_result' => 0
        );
    }

    $article_auditrail_data = $article_auditrail_data_details['audit_result'];
    $total_count = $article_auditrail_data_details['count_result'];
    $total_data_count=0;
    if(isset($total_count[0]->count))
    {
        $total_data_count=$total_count[0]->count;
    }


$action_arr = array(
    'assigned' => ' on assignment of ',
    'completed'=> ' on completion of ',
    'accepted'=> ' on the acceptance of invitation ( stage : ##STAGE## ) ',
    'invitation'=> ' for ##STAGE## stage ',
    'assigned_not_accepted'=> ' to accept invitation for ##STAGE## stage',
    'accepted_not_completed'=> ' to complete task on ##STAGE## stage',
    'uninvite_user'=> ' as a part of uninvite from ##STAGE## stage',
    'unassign_user'=> ' as a part of unassignment from ##STAGE## stage',
    'rescind_review'=> 'as a part of rescind from ##STAGE## stage',
    'transfer_article'=> 'as a part of transfer :article from ##STAGE## stage',
    'add_potential_reviewer'=> 'as a part of shortlist reviewer on ##STAGE## stage',
    'edit_potential_reviewer'=> 'as a part of edit reviewer information on ##STAGE## stage',
    'initialization'=> 'as a part of initialization of ##STAGE## stage',
    'assignment_change'=> 'as a part of change assignment of ##USER_ROLE## role on ##STAGE## stage from ',
    'coauthor_notify'     =>'as part of a completing ##STAGE## stage',
    'change_assign_assignment'=>' on assignment of ',
    'change_assign_unassignment'=>' on unassignment of '
                      );
    if (count($article_auditrail_data) > 0)
    {
        $set_username = array();
        $array_data['journal_id']=$currentjnldata['jnl_id'];
        $array_data['flag']=TRUE;
        $array_data['article_id']=$article_id;
        $array_data['availability']=TRUE;
        $array_data['save_coauthor']=FALSE;
        $array_data['remove_user']=TRUE;

        foreach ($article_auditrail_data as $art_timeline)
        {
            if(!empty($art_timeline->esl_etmp_action))
            {
                if(isset($action_arr[$art_timeline->esl_etmp_action])  && $art_timeline->esl_etmp_action != '' && $art_timeline->flag_name != '')
				{


                    $action_arr[$art_timeline->esl_etmp_action] = customTrans($action_arr[$art_timeline->esl_etmp_action]);
					if($art_timeline->esl_etmp_action == 'accepted')
					{
						$art_timeline->action_mg = str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->esl_etmp_action]);
					}
					elseif($art_timeline->assigntype == 'invitation' && $art_timeline->esl_etmp_action == 'assigned')
					{
						$art_timeline->action_mg = str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->assigntype]);
					}
					elseif($art_timeline->esl_etmp_action == 'assigned_not_accepted' || $art_timeline->esl_etmp_action == 'accepted_not_completed')
					{
						$art_timeline->action_mg = str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->esl_etmp_action]);
					}
                    //406 display univite user,unassign user and rescind review mail in emaillog
                    elseif($art_timeline->esl_etmp_action == 'uninvite_user' || $art_timeline->esl_etmp_action == 'unassign_user' || $art_timeline->esl_etmp_action == 'transfer_article' || $art_timeline->esl_etmp_action == 'add_potential_reviewer'
                        || $art_timeline->esl_etmp_action == 'edit_potential_reviewer' || $art_timeline->esl_etmp_action == 'initialization' )
                    {
                        $art_timeline->action_mg =  str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->esl_etmp_action]);
                    }

                    elseif($art_timeline->esl_etmp_action == 'rescind_review' && $art_timeline->assigntype == 'invitation')
                    {
                        $art_timeline->action_mg =  str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->esl_etmp_action]);
                    }
                    /*elseif($art_timeline->esl_etmp_action == 'assignment_change' && $art_timeline->user_role != '' &&$art_timeline->assigntype == 'invitation')*/
                    elseif($art_timeline->esl_etmp_action == 'assignment_change' && $art_timeline->assigntype == 'invitation')
                    {
                       /* $action =  str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->esl_etmp_action]);
                        $action_mg =  str_replace('##USER_ROLE##',$art_timeline->user_role, $action);*/
                    
                        $art_timeline->action_mg =  str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->esl_etmp_action]);
                        $sql="select rvw_roles.role_name,cag_old_usr_id
                                FROM
                                    rvw_roles
                                JOIN
                                    rvw_change_assignment  ON
                                    rvw_change_assignment.cag_usr_role_id = rvw_roles.role_id
                                JOIN
                                    rvw_email_send_log email 
                                    ON email.esl_batch_id =rvw_change_assignment.cag_new_usr_esl_batch_id
                            where

                                    email.esl_batch_id =".$art_timeline->id;
                        $data=Article_flow::get_records_by_raw_query($sql,TRUE);
                        if(isset($data->role_name)&& !empty($data->role_name))
                        {
                            $art_timeline->action_mg =   str_replace('##USER_ROLE##',$data->role_name, $art_timeline->action_mg);
                        
                            if (!empty($data->cag_old_usr_id))
                            {
                                $array_data['user_id']=$data->cag_old_usr_id;
                                $set_username[$data->cag_old_usr_id] = $this->get_user_display_name(array_merge($array_data, ['aflw_id' => $art_timeline->flow_id]));
                                $art_timeline->old_user_id=  $set_username[$data->cag_old_usr_id];
                            }
                        }
                    }
                    elseif($art_timeline->esl_etmp_action == 'coauthor_notify')
					{
					$art_timeline->action_mg =  $art_timeline->action_mg =  str_replace('##STAGE##',$art_timeline->flag_name, $action_arr[$art_timeline->esl_etmp_action]);

					}

					else
						$art_timeline->action_mg = $action_arr[$art_timeline->esl_etmp_action].' '.$art_timeline->flag_name.' stage';

					$art_timeline->action_mg = $art_timeline->action_mg;
				} 
            }
            //echo '<pre>'; print_r($art_timeline); die;
           
           // if (isset($set_username[$art_timeline->posted_user_id]) && (!empty($set_username[$art_timeline->posted_user_id])))
          //  $art_timeline->posted_user=  $set_username[$art_timeline->posted_user_id];
            // $art_timeline->posted_user = $set_username[$art_timeline->posted_user_id] . $art_timeline->posted_user;
          //  else
          //  {


            if(!empty($art_timeline->posted_user)&&$art_timeline->posted_user!='')
            {
            $post_arr = explode('merge_date ', $art_timeline->posted_user);
            if(!empty($post_arr)&&isset($post_arr[1])&&(trim($post_arr[1])!=''))
            {
            $art_timeline->posted_user_merge_date=date($date_format." H:i:s", strtotime(trim($post_arr[1])));
            }
            }
                if (!empty($art_timeline->posted_user_id))
                {
                    $array_data['user_id']=$art_timeline->posted_user_id;


                    $set_username[$art_timeline->posted_user_id] = $this->get_user_display_name(array_merge($array_data, ['aflw_id' => $art_timeline->flow_id]));
                    

                   $art_timeline->posted_user=  $set_username[$art_timeline->posted_user_id];
                }
                else
                {
                    $art_timeline->posted_user= array();
                }

  
                if (!empty($art_timeline->proxy_user_id))
                {
                    $array_data['user_id']=$art_timeline->proxy_user_id;

                    $set_username[$art_timeline->proxy_user_id] = $this->get_user_display_name($array_data);

                   $art_timeline->proxy_user=$set_username[$art_timeline->proxy_user_id] ;
                }
                else
                {
                    $art_timeline->proxy_user = array();
                }

            //some time multiple whome user ids
            $art_timeline->to_whome_specific=false;

            if ($art_timeline->to_whome_user_id != '')
            {
                $art_timeline->to_whome_specific=true;
                $temp_towhome_arr = array();
                $temp_ids = explode(',', $art_timeline->to_whome_user_id);
                                    //#406 remove comma from timeline & email log sending mail using specific email id
                                    if (in_array("0", $temp_ids))
                                    {
                                        $pos = array_search('0', $temp_ids);
                                        unset($temp_ids[$pos]);
                                    }
                foreach ($temp_ids as $temp_id)
                {
                    $prefix = '';

                    if ($art_timeline->table_name == 'email_send_log')
                        $prefix = $temp_id . '|';


                        $array_data['user_id']=$temp_id;
                        $set_username[$temp_id] = $this->get_user_display_name($array_data);

                        //$art_timeline->to_whome = $set_username[$temp_id].$art_timeline->to_whome;
                       // $temp_towhome_arr[] = $prefix . $set_username[$temp_id];
                       $temp_towhome_arr[] =$set_username[$temp_id];

                }

                //$art_timeline->to_whome = implode(',', $temp_towhome_arr);
                $art_timeline->to_whome =$temp_towhome_arr;
            }
            else
            {
              /* Task #9861 Specific email id issue */  
                $to_hybid_to_whom=$this->hybrid_whom_to($art_timeline->to_whome,$article_id,$currentjnldata['jnl_id']);
                $art_timeline->to_whome= implode(',',$to_hybid_to_whom['data_to_whom_specific']);
                if(!empty($to_hybid_to_whom['data_to_whom']))
                $art_timeline->to_whome_specific_array=$to_hybid_to_whom['data_to_whom'];
             /* Task #9861 End Specific email id issue */ 
            }

         
                if(!empty($art_timeline->to_whome_changed)&&$art_timeline->to_whome_changed!='')
                {
                    $post_arr = explode(' merge_date ', $art_timeline->to_whome_changed);
                    if(!empty($post_arr)&&isset($post_arr[1])&&(trim($post_arr[1])!=''))
                    {
                    $art_timeline->to_whome_changed_user_merge_date=date($date_format." H:i:s", strtotime(trim($post_arr[1])));
                    }
                }
                if (!empty($art_timeline->to_whome_changed_user_id) && ($art_timeline->to_whome_changed_user_id != 0))
                {
                    $array_data['user_id']=$art_timeline->to_whome_changed_user_id;
                    $set_username[$art_timeline->to_whome_changed_user_id] = $this->get_user_display_name($array_data);

                  $art_timeline->to_whome_changed=$set_username[$art_timeline->to_whome_changed_user_id];
                }
                else
                {
                    $art_timeline->to_whome_changed = array();
                }


   

                if (!empty($art_timeline->by_whome)&&($art_timeline->by_whome!='') && ($art_timeline->by_whome != 0))
                {
                    


                    if($art_timeline->by_whome!='')
                    {
                        if(strpos($art_timeline->by_whome," merge_date") !== false)
                        {

                        $post_arr = explode(' merge_date ', $art_timeline->by_whome);
                        if($post_arr[0]&&$post_arr[0]=!'')
                        {

                        $bywhomuser_id=$post_arr[0];
                        }
                        }
                        else
                        {

                        $bywhomuser_id=$art_timeline->by_whome;
                        }

                    if(isset($bywhomuser_id))
                    {

                    $array_data['user_id']=$bywhomuser_id;

                    $set_username[$art_timeline->by_whome] = $this->get_user_display_name($array_data);
                    $art_timeline->by_whome = $set_username[$art_timeline->by_whome];
                       }
                     if(!empty($post_arr)&&isset($post_arr[1])&&(trim($post_arr[1])!=''))
                     {
                    $art_timeline->by_whome_merge_date=date($date_format." H:i:s", strtotime(trim($post_arr[1])));
                     }
                    }
                }
                else
                {
                    $art_timeline->by_whome = "";
                }


            if ($art_timeline->table_name == 'article_flow')
            {
                $action = $art_timeline->action;
                //$regex = '##\{(.*?)\}##';
                preg_match_all('/##\{(.*?)\}##/', $action, $matches);

                $role_name = '';
                if (isset($matches[1][0]))
                {
                    $skipped_roles_array = array_filter(explode(',', $matches[1][0]));
                    $skipped_role = end($skipped_roles_array);
                    $role_name = isset($all_roles[$skipped_role]) ? $all_roles[$skipped_role]->role_name : '';
                }
                $art_timeline->action = preg_replace('/##\{.*?\}##/', $role_name, $art_timeline->action);
            }
            //Feature #135 JPR-121 Figshare API
            if ($art_timeline->table_name == 'article_figshare_docs')
            {
                $client_code = $this->current_client->clnt_client_code;
                $link =  'clients.' . $this->current_client->clnt_client_code . '.figshare.fig_url'. $art_timeline->status;
                $art_timeline->status = '<a href="' . $link . '" target="_blank">' . $art_timeline->status . '</a>';
            }

                            if ($art_timeline->table_name == 'article_gnf_form_data')
                            {
                                $art_timeline->to_whome_changed = $set_username[$art_timeline->to_whome_changed_user_id];

                            }
                            $art_timeline->action_time=date($date_format." h:i:s A", strtotime($art_timeline->action_time));

          if(isset($art_timeline->table_name)&&$art_timeline->table_name=='change_due_date')
          {
            if(isset($art_timeline->action)&&$art_timeline->action!='')
            {
                $art_timelinefirstdate='';
                $art_timelineseconddate='';
                $actiondate=explode("to",$art_timeline->action);
                if(isset($actiondate[0])&&$actiondate[0]!='')
                $art_timelinefirstdate=date($date_format, strtotime($actiondate[0]));
                if(isset($actiondate[1])&&$actiondate[1]!='')
                $art_timelineseconddate=date($date_format, strtotime($actiondate[1]));
                $art_timeline->action=$art_timelinefirstdate.' to '.$art_timelineseconddate;
            }

          }
          /*if ($art_timeline->table_name == 'email_send_log'){
            if($art_timeline->action == 'initialization'){
                $art_timeline->email_send_result = 'as a part of ' . $art_timeline->action . ' of ' . $art_timeline->flag_name . ' stage';
            }
          }*/

        }


    }
    else
    {
        $show_load_more = 'n';
    }


    //echo '<pre>'; print_r($article_auditrail_data); die;
    if (!empty($article_auditrail_data))
    {
        foreach ($article_auditrail_data as $key => $value)
        {

            if (array_key_exists($key + 1, $article_auditrail_data))
            {
                $next_value = $article_auditrail_data[$key + 1];
                if($value->action == 'uninvited' && $next_value->action == 'reset')
                {
                    continue;
                }
                if ($next_value->action_time == $value->action_time)
                {
                    if (($next_value->action == 'sent' && $next_value->status == 'email' ) || ($value->status == $next_value->status && $value->tbk_id > $next_value->tbk_id && $value->flow_id == $next_value->flow_id))
                    {
                        $temp = $article_auditrail_data[$key];
                        $article_auditrail_data[$key] = $article_auditrail_data[$key + 1];
                        $article_auditrail_data[$key + 1] = $temp;
                    }
                }
            }
            $article_auditrail_data[$key]->art_withdrawn_stat = $article_data->art_delete_status;
        }

        if (count($article_auditrail_data) < $limit)
        {
            $show_load_more = 'n';
        }
    }
    else
    {
        $show_load_more = 'n';
    }
    //$article_auditrail_data = array_slice($article_auditrail_data, $offs, $limit);
    if (count($article_auditrail_data) < $limit)
    {
        $show_load_more = 'n';
    }
    /* Check New Timeline  count Check and scroll Limit */
    if ($total_count < $limit)
    {
        $show_load_more = 'n';
    }



    $data = array(
        'article_auditrail_data' => $article_auditrail_data,
        'journal_code' => $currentjnldata['jnl_code'],
       // 'journal_date_format' => $this->jnl_data->jset_date_format,
        'jnl_id' =>$currentjnldata['jnl_id'],
        'art_typ_id' => $article_data->art_artp_id,
        'show_load_more' => $show_load_more,
        'last_audit_trial' => $last_audit_trial,
        'previous_versions' => $previous_versions,
        'current_version_artid' => $current_version_id,
        'article_id' => $article_id,
        'current_role_id' => $curnt_role_id,
        'total_count'=>$total_data_count
    );

    return $data;
}

private function get_previous_versions($article_data)
{
    $previous_versions = array();

    $previous = ($article_data->art_pre_all_ids != NULL ) ? explode(',', $article_data->art_pre_all_ids) : array();
    if (!empty($previous))
    {

        $previous = array_reverse($previous);

        foreach ($previous as $pre)
        {

            $art_dets =Articles::get_single_record('art_id,art_version_no',"art_id={$pre}");

            $previous_versions[] = $art_dets;
        }
    }

    return $previous_versions;
}

public function get_article_timeline_filter_data($article_id,$filter_type = 'timeline',$previous_show =TRUE,$current_journal_data='')
{
    $this->current_user = $this->get_current_user_details();
    $filter_html = '';
    if(isset($this->current_client->modules->mdl_generic_discussion))
    $generic_disc_mdl = $this->current_client->modules->mdl_generic_discussion;
    else
    $generic_disc_mdl='n';
    if($article_id != '')
    {

        $generic_flow_table=(new \App\Models\Generic_flows)->getTable();
        $article_flow_table=(new \App\Models\Article_flow)->getTable();
        $user_article_table=(new \App\Models\User_articles)->getTable();
        $user_to_journal_table=(new \App\Models\User_to_journals)->getTable();
        $author_table=(new \App\Models\Authors)->getTable();
        $user_table=(new \App\Models\User)->getTable();
        $role_table=(new \App\Models\Roles)->getTable();
        $custom_reason_table=(new \App\Models\Article_custom_reasons)->getTable();
        $where =array(); $where_cond = $flw_prdt = $usr_prdt='';
        if( $current_journal_data['core_role'] != 'journal_admin' && isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
        {

            $current_role_status = $this->check_user_production_status($article_id,$this->current_user['user_id']);
            if($current_role_status != "both")
            {
                $client_code = $this->current_client->clnt_client_code;
                $this->review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');

                $stages=$this->get_production_stages_keys($this->review_flow,FALSE,TRUE);
                $review_stages=$stages['review'];
                $prdn_stages=$stages['production'];
                if($current_role_status == "review_only" || ($current_role_status =='' && $previous_show == TRUE))
                {
                    $where_cond =' and jwf_stage_type in ("' . implode('","', $review_stages) . '")';
                }
                elseif($current_role_status == "production_only" || ($current_role_status =='' && $previous_show == FALSE))
                {
                    $where_cond =' and jwf_stage_type in ("' . implode('","', $prdn_stages) . '")';
                }
                $flw_prdt = ' left join '.$generic_flow_table.' on aflw_jwf_id = jwf_id ';
                $usr_prdt = ' left join '.$generic_flow_table.' on usra_aflw_id = jwf_id ';
            }
        }


        $current_role = $current_journal_data['core_role'];


        $join_tables = array(
            'main_table' =>$article_flow_table,
            'join_table' => array(
                $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "join")
            )
          );
          $select = 'aflw_id,jwf_id,jwf_stage_name,jwf_stage_type,jwf_assignment';
          $criteria=' aflw_art_id='.$article_id. ' and aflw_parent_flow_id IS NULL';
          if(!empty($where_cond)) $criteria.= $where_cond;
          $article_types =Article_flow::get_results_using_joins($join_tables,$select, $criteria,'all');

        $stage_users = array();

        $art_data =Articles::get_single_record('art_artp_id as artp_id',"art_id={$article_id}");

        //flow
        $flow_users = ' SELECT DISTINCT aflw_usr_id AS user FROM '.$article_flow_table.$flw_prdt.'  WHERE aflw_usr_id IS NOT NULL AND aflw_art_id = '.$article_id.$where_cond;

        //allocated users
        $article_allocate_users = ' SELECT DISTINCT usra_usr_id AS user FROM '. $user_article_table.$usr_prdt.'  WHERE usra_art_id = '.$article_id.$where_cond;

        //authors
        $article_authors = ' SELECT DISTINCT auth_usr_id AS user FROM '. $author_table.'   WHERE auth_art_id = '.$article_id;

        //Custom Reason
        $custom_reason = ' SELECT DISTINCT cusr_posted_by AS user FROM '. $custom_reason_table.'   WHERE cusr_art_id = '.$article_id; 

        $user_union = '('.$flow_users.' UNION '.$article_allocate_users.' UNION '.$article_authors.' UNION '.$custom_reason.') as user_list';

        $select = 'usr_id,usr_title,usr_first_name,usr_middle_name,usr_last_name,GROUP_CONCAT(DISTINCT " ",role_name) as roles';

        $select_main_sql = ' SELECT '.$select.' FROM  '.$user_union.' JOIN '.$user_to_journal_table .' ON  user_list.user = usrj_usr_id JOIN '.$user_table.' ON usr_id = usrj_usr_id  JOIN '.$role_table.' ON  usrj_role_id = role_id  WHERE usrj_artp_id = '.$art_data->artp_id.' GROUP BY usrj_usr_id';
        $stage_users = Article_flow::get_records_by_raw_query($select_main_sql);
        //echo $this->db->last_query(); die;
        if($filter_type=='timeline')
        {
        $event_filter_array=timelineevents();
        if(isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion=='n')
        {
        unset($event_filter_array['generic_discussion']);
        }
        }
        else
        {
        $event_filter_array=emailevents();
        if(isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion=='n')
        {
        unset($event_filter_array['discussion']);
        }
        }

        $filter_data = array(
            'stages' => $article_types ,
            'stage_users' => $stage_users,
            'title_arr' =>$this->UserConfigdata('titles')['titles'],
            'current_role' =>$current_role,
            'current_user' =>$this->current_user['user_id'],
            'mdl_generic_discussion' => $generic_disc_mdl,
            'eventsfilter'=>$event_filter_array
        );


    }

    return $filter_data;
}

public function timeline_details(Request $request)
	{
        try
        {

       $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'jnl_code' => 'required',
               // 'flow_id' => 'required',
            ]);

        if($validator->fails())
        {
                return  $this->failure('Failed',422,$validator->errors());
        }

        $post_data=$request->all();

		$table_name =isset($post_data['table_name']) ?  $this->decrypt_data($post_data['table_name']) : '';
		$tbk_id =isset($post_data['tbk_id']) ?  $this->decrypt_data($post_data['tbk_id']) : '';
		$whome_id =isset($post_data['whome']) ?  $this->decrypt_data($post_data['whome']) : '';
		$posted_usr_id =isset($post_data['posted_usr']) ?  $this->decrypt_data($post_data['posted_usr']) : '';
		$article_id = isset($post_data['article_id']) ?  $this->decrypt_data($post_data['article_id']) : '';
		$mask_name_reviewer =isset($post_data['mask_name_reviewer']) ?  $post_data['mask_name_reviewer'] : '';
        $core_role =isset($post_data['core_role']) ?  $post_data['core_role'] : '';
        $jnl_id =isset($post_data['jnl_id']) ?  $this->decrypt_data($post_data['jnl_id']) : '';
        $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : '';
        $flow_id =isset($post_data['flow_id']) ?  $this->decrypt_data($post_data['flow_id']) : '';
        $date_format = $this->get_platform_date_format($jnl_id);
        $date_format= date_format_map($date_format);
        $array['article_id']=$article_id;
        $array['type']='timeline';
        $array['jnl_code']=$jnl_code;
        $array['current_flow_id']=$flow_id;
        $array['url']=$request->segment(4);
        $user_access=$this->check_permission_access_user($array);
          /*Task #9176 Add reason for Do not transfer option*/
        $reason_table_array=array('change_due_date','rescind_reset_record','article_rescind_request','articles','article_custom_reasons','article_transfer_suggesion');
           /*Task #9176 End*/
        if($user_access!=true)
        {
            return  $this->failure('Unauthorized', 200, 'Unauthorized User');
        }
		if ($table_name === 'rescind_reset_record')
		{
			//$whome=$this->get_user_display_name($whome_id, $this->jnl_data->jnl_id, TRUE,$article_id);
			//$posted_usr=$this->get_user_display_name($posted_usr_id, $this->jnl_data->jnl_id, TRUE,$article_id);
		}

		if ($table_name === 'email_send_log')
		{
            $Email_send_log = new \App\Models\Email_send_log;
            $Articles = new \App\Models\Articles;
            $Authors = new \App\Models\Authors;
            $User = new \App\Models\User;
            $User_emails = new \App\Models\User_emails;
            $Email_attachments = new \App\Models\Email_attachments;
            $Adhoc_notification_emails = new \App\Models\Adhoc_notification_emails;
            $Resent_forward_emails_attachments = new \App\Models\Resent_forward_emails_attachments;
            $Article_flow = new \App\Models\Article_flow;
            $Generic_flows = new \App\Models\Generic_flows;

            $template='';
			//$details = $Email_send_log::timeline_details($tbk_id, $article_id);
            $details = $Email_send_log::timeline_view_details($tbk_id, $article_id);
            /*
            DB::enableQueryLog();
            $queries = DB::getQueryLog();
			$queries=end($queries);
            dd($queries);
           */
            $email_content = $Email_send_log::get_all_records('esl_trans_mode,esl_content, esl_to,esl_aflw_id, esl_posted_by, esl_user_id, esl_proxy_id,esl_attachments,esl_etmp_action,esl_article_id, REPLACE(esl_cc, " ", "") as esl_cc, REPLACE(esl_bcc, " ", "") as esl_bcc,esl_trans_secret_id,esl_reply_to',"esl_batch_id={$tbk_id} and esl_article_id = $article_id");
            // Task #206 , Reply-mail, get reply to mail (from default client config / from journal settings).
            $default_mail_box = $this->get_reply_to_email($jnl_id); 
           
            $current_stage=array();
           if(isset($email_content[0]->esl_aflw_id))
           {
			$current_stage = $Article_flow::get_generic_flow('jwf_stage_type',"aflw_art_id={$article_id} AND aflw_id={$email_content[0]->esl_aflw_id}");
           }
			if(isset($article_id))
			{
			$article_data = $Articles::get_single_record('art_delete_status,art_submitted_by',"art_id={$article_id}");
			}

			if(trim($mask_name_reviewer) != '' && $core_role == 'author')
			{
				$details->posted_user = $mask_name_reviewer;
			}
			if (($email_content[0]->esl_posted_by == 0 || $email_content[0]->esl_posted_by == $email_content[0]->esl_user_id) && ((!isset($current_stage[0]->jwf_stage_type)) || ((isset($current_stage[0]->jwf_stage_type) && $current_stage[0]->jwf_stage_type != 'author_submission' || ($current_stage[0]->jwf_stage_type == 'author_submission' && ($email_content[0]->esl_etmp_action != 'assigned' && $email_content[0]->esl_etmp_action != 'uninvite_user'))))))// case user send mail to self
			{
                // Task #206 , Reply-mail, mail sender details correction based on system or external user mail account for reply mail responses
				if (isset($email_content[0]->esl_reply_to) && !empty($email_content[0]->esl_reply_to) && $email_content[0]->esl_reply_to != $default_mail_box) {
                    $details->posted_user = $email_content[0]->esl_reply_to;
                } else {
                    $details->posted_user = 'System';
                }
				$details->proxy_user = '';
			}

			$details->view_timeline_email = TRUE;
            $template = 'timeline_view_email_send_log';
            $blinded_array = array();
			//#357 fetch batch id
			$details->adhoc_path = false;
			$ad_noti=$Adhoc_notification_emails::get_single_record('ade_from',"ade_esl_batch_id={$tbk_id}");
            $details->email_attach_path = false;
            $details->article_attchment=false;
            $details->resend_email=false;
			if(isset($ad_noti)&&!empty($ad_noti)) {

				$details->adhoc_path = true;
			}
            if ($this->current_client->functionality->cfty_receive_email_response == 'y' && $email_content[0]->esl_trans_mode == 'r') {
				$details->adhoc_path = true;
			}
            $attach_array=array();
			if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y' && !empty($email_content))
			{

				foreach ($email_content as $eml)
				{
					$esl_attach = ($eml->esl_attachments != NULL) ? json_decode($eml->esl_attachments, TRUE) : array();
                    if ($eml->esl_trans_mode === 'r' && $eml->esl_posted_by === 0) {
                        $eml->esl_posted_by = $this->getRecievemailParentUserId($eml->esl_trans_secret_id);
                    }
                    $eml->esl_trans_secret_id = '';
					$email_attach = array();
					if (!empty($esl_attach))
					{

						//#357 fetch adhoc uploaded path
						if(isset($ad_noti)&&!empty($ad_noti)) {

							$ade_from	=	$ad_noti->ade_from;
							$ade_to		=	$email_content[0]->esl_user_id;
                            if ($this->current_client->functionality->cfty_receive_email_response == 'y' && $eml->esl_trans_mode == 'r') {
                                $adhoc_path	=	'email_attachments/'.$eml->esl_posted_by.'/'.$eml->esl_user_id.'/receive/';
                            }else{
                                $adhoc_path	=	'adhoc_attachments/'.$ade_from.'/'.$ade_to.'/';
                            }
							$details->adhoc_path = true;
                            if (isset($esl_attach['article']) && !empty($esl_attach['article']))
							{

							foreach ($esl_attach['article'] as $key=>$eat)
							{
                                $attach_data['atmt_id']=$key;
                                $attach_data['atmt_name']=$eat;
                                $attach_data['adhocpath']=$adhoc_path;
								$email_attach = $adhoc_path . $eat;
                                array_push($attach_array,$attach_data);
							}
                            }
                            $eml->email_attchment_files=$attach_array;
						} else {
                            if ($this->current_client->functionality->cfty_receive_email_response == 'y' && $email_content[0]->esl_trans_mode == 'r') {
                                $details->email_attach_path=false;			
                            }else{
                                $details->email_attach_path=true;			
                            }
							$article_details = $Articles::get_single_record('art_article_upload_path,art_id',"art_id={$eml->esl_article_id}");

							if (isset($esl_attach['article']) && !empty($esl_attach['article']))
							{
                                $details->article_attchment=TRUE;
								foreach ($esl_attach['article'] as $key=>$eat)
								{
                                    if ($this->current_client->functionality->cfty_receive_email_response == 'y' && $eml->esl_trans_mode == 'r') {
                                        $adhoc_path	=	'email_attachments/'.$eml->esl_posted_by.'/'.$eml->esl_user_id.'/receive/';
                                        $attach_data['adhocpath']=$adhoc_path;
                                    }
                                    $attach_data['atmt_id']=$key;
                                    $attach_data['atmt_name']=$eat;
                                    $eml->email_attchment=TRUE;
									$email_attach[$eat] = 'uploads/' . $article_details->art_article_upload_path . '/' . $eat;
                                    array_push($attach_array,$attach_data);
								}
                                // $eml->email_attchment_files=$attach_array;

							}
							elseif (isset($esl_attach['modified']) && !empty($esl_attach['modified']))
							{
                                $eml->email_attchment=TRUE;

								foreach ($esl_attach['modified'] as $key=>$eat)
								{

                                    $link_array = explode('/',$eat);
                                   if(is_array($link_array))
                                    $item = end($link_array);
                                    else
                                    $item=$eat;
                                    if ($this->current_client->functionality->cfty_receive_email_response == 'y' && $eml->esl_trans_mode == 'r') {
                                        $adhoc_path	=	'email_attachments/'.$eml->esl_posted_by.'/'.$eml->esl_user_id.'/receive/';
                                        $attach_data['adhocpath']=$adhoc_path;
                                    }
                                    $attach_data['atmt_id']=$key;
                                    $attach_data['atmt_name']=$item;

                             $is_production_files = $Email_attachments::get_single_record('emat_id',"emat_id={$key} AND emat_is_production_files='y'");
                                                                    if(!empty($is_production_files) || (strpos($eat, '/production/') !== false||strpos($eat, '/email_attachments/') !== false))
                                                                    {
                                                                        $email_attach[$eat] = $eat;
                                                                    }
                                                                    else
                                                                    {
                                                                        if ($this->current_client->functionality->cfty_receive_email_response == 'y' && $eml->esl_trans_mode == 'r') {
                                                                            $email_attach[$eat] = 'uploads/email_attachments/'.$eml->esl_posted_by.'/'.$eml->esl_user_id.'/receive/'. $eat;
                                                                        }
                                                                        else{
                                                                            $email_attach[$eat] = 'uploads/email_attachments/' . $article_details->art_id . '/' . $eat;
                                                                        }
                                                                    }
                                    array_push($attach_array,$attach_data);

								}
                                // $eml->email_attchment_files= collect($attach_array)->unique();
							}
                             /*TASK #4801  Part of RVRite integration: Need to keep the change log */
                            else
                            {
                                if(!empty($esl_attach)&&count($esl_attach)==1)
                                {
                                    $attach_data['atmt_id']=key($esl_attach);
                                    $attach_data['atmt_name']=current($esl_attach);
                                    array_push($attach_array,$attach_data);
                                }
                            
                            }
                            /*TASK #4801 End */
						}
					}
                    $eml->email_attchment_files= collect($attach_array)->unique();
					$eml->email_attachments = $email_attach;
				}
			} else {
                                //#357 fetch adhoc uploaded path when client functionilty is OFF
				foreach ($email_content as $eml)
				{
					$esl_attach = ($eml->esl_attachments != NULL) ? json_decode($eml->esl_attachments, TRUE) : array();
					$email_attach = array();
					if (!empty($esl_attach))
					{
						//#357 fetch adhoc uploaded path // need to work
						if(!empty($ad_noti)) {
							$ade_from	=	$ad_noti->ade_from;
							$ade_to		=	$email_content[0]->esl_user_id;
                            if ($this->current_client->functionality->cfty_receive_email_response == 'y' && $eml->esl_trans_mode == 'r') {
                                $adhoc_path	=	'email_attachments/'.$eml->esl_posted_by.'/'.$eml->esl_user_id.'/receive/';
                            }else{
                                $adhoc_path	=	'adhoc_attachments/'.$ade_from.'/'.$ade_to.'/';
                            }
							$details->adhoc_path = true;
                            if (isset($esl_attach['article']) && !empty($esl_attach['article']))
							{
							foreach ($esl_attach['article'] as $key=>$eat)
							{
                                $attach_data['atmt_id']=$key;
                                $attach_data['atmt_name']=$eat;
                                $attach_data['adhocpath']=$adhoc_path;
								$email_attach[$eat] = $adhoc_path . $eat;
                                array_push($attach_array,$attach_data);
							}
                            }
						}
					}
                    $eml->email_attchment_files= collect($attach_array)->unique();
					$eml->email_attachments = $email_attach;
				}
			}
                        $attach_ids = '';
                        $additnal_conditn = '';
                        if(!empty($esl_attach['modified']) ){
                            $attach_ids = implode(',',(array_keys($esl_attach['modified'])));
                            if(!empty($attach_ids))
                                $additnal_conditn = ' AND rfa_id IN (' . $attach_ids . ')';
                        }
                        $get_attachments	=	$Resent_forward_emails_attachments::get_all_records('rfa_id,rfa_attachment_path,rfa_file_name',"rfa_esl_batch_id={$tbk_id} {$additnal_conditn}");
                        if (!empty($get_attachments) && count($get_attachments) > 0)
                        {
                            $details->resend_email=true;
                            $email_attach = array();
                            foreach ($email_content as $eml)
                            {
                                $esl_attach = ($eml->esl_attachments != NULL) ? json_decode($eml->esl_attachments, TRUE) : array();
                                if (!empty($esl_attach['article']))
                                {
                                    foreach ($get_attachments as $ak=>$av)
                                    {
                                        if(in_array($av->rfa_file_name,array_values($esl_attach['article'])))
                                        {
                                            $email_attach[$av->rfa_file_name] = $av->rfa_attachment_path;
                                        }
                                    }
                                 //   $eml->email_attachments = array_merge($email_attach,$eml->email_attachments);
                                }
                            }
                        }


			$cc_emails = array_column(json_decode(json_encode($email_content), TRUE), 'esl_cc');
			if (!empty($cc_emails))
			{
				$cc_emails = array_diff(array_unique(explode(',', implode(',', $cc_emails))), array(
					''));

				if (!empty($cc_emails))
					$cc_email_with_email = $User::get_single_record('SUBSTRING(GROUP_CONCAT(usr_first_name, " ", usr_last_name,"[",usr_email, "]" SEPARATOR ", "), 1, LENGTH(GROUP_CONCAT(usr_first_name, " ", usr_last_name,"[",usr_email, "]" SEPARATOR ", "))) as cc_name, GROUP_CONCAT(usr_email) as cc_mail', "usr_email IN('" . implode("','", $cc_emails) . "')");
				if (!empty($cc_email_with_email->cc_mail))
					$cc_emails = array_diff($cc_emails, explode(',', $cc_email_with_email->cc_mail));

				$esl_cc = !empty($cc_email_with_email->cc_name) ? $cc_email_with_email->cc_name : '';
				if (!empty($cc_emails))
				{
					$sql = 'SELECT SUBSTRING(GROUP_CONCAT(usr_first_name, " ", usr_last_name,"[",uml_email, "]" SEPARATOR ", "), 1, LENGTH(GROUP_CONCAT(usr_first_name, " ", usr_last_name,"[",uml_email, "]" SEPARATOR ", "))) as cc_name, GROUP_CONCAT(uml_email) as cc_mail FROM rvw_users INNER JOIN rvw_user_emails ON usr_id = uml_user_id WHERE uml_email IN("' . implode('","', $cc_emails) . '")';
					$alternate_email_users = $User::get_records_by_raw_query($sql);
					if (!empty($alternate_email_users[0]->cc_name) && !empty($cc_email_with_email->cc_name))
						$esl_cc .= ', ';

					$esl_cc = !empty($alternate_email_users[0]->cc_name) ? $esl_cc . $alternate_email_users[0]->cc_name : $esl_cc;

					if (!empty($alternate_email_users[0]->cc_mail))
						$cc_emails = array_diff($cc_emails, explode(',', $alternate_email_users[0]->cc_mail));
				}
				if (!empty($cc_emails))
				{
					$cc_emails = implode(', ', $cc_emails);
					$esl_cc = !empty($esl_cc) ? $esl_cc . ', ' . $cc_emails : $cc_emails;
				}
				$details->esl_cc = $esl_cc;
			}

			$bcc_emails = array_column(json_decode(json_encode($email_content), TRUE), 'esl_bcc');

			if (!empty($bcc_emails))
			{
				$bcc_emails = array_diff(array_unique(explode(',', implode(',', $bcc_emails))), array(
					''));

				if (!empty($bcc_emails))
				{
					$bcc_email_with_email = $User::get_single_record('SUBSTRING(GROUP_CONCAT(usr_first_name, " ", usr_last_name,"[",usr_email, "]" SEPARATOR ", "), 1, LENGTH(GROUP_CONCAT(usr_first_name, " ", usr_last_name,"[",usr_email, "]" SEPARATOR ", "))) as bcc_name, GROUP_CONCAT(usr_email) as bcc_mail', "usr_email IN('" . implode("','", $bcc_emails) . "')");
					$bcc_emails = array_diff($bcc_emails, explode(',', $bcc_email_with_email->bcc_mail));
				}

				$esl_bcc = !empty($bcc_email_with_email->bcc_name) ? $bcc_email_with_email->bcc_name : '';
				if (!empty($bcc_emails))
				{
					$bcc_emails = implode(',', $bcc_emails);
					$esl_bcc = !empty($esl_bcc) ? $esl_bcc . ', ' . $bcc_emails : $bcc_emails;
				}
				$details->esl_bcc = $esl_bcc;
			}
            $details->blinded_user = false;
            for ($i = 0; $i < count($email_content); $i++) {
                preg_match_all('/<a\b[^>]*>(.*?)<\/a>/i', $email_content[$i]->esl_content, $matches);
                $keys = $matches[1];
               // $details->to .= ($email_content[$i]->esl_user_id == 0) ? ','.$email_content[$i]->esl_to : "";
                for ($j = 0; $j < count($keys); $j++) {
                    $element = $keys[$j];
                    if (!empty($element)) {
                       
                        /* Task #8411, Type error occuered in the timelinedetails API issue fix
                        if(preg_match("/\)/", $element)==true){
                            $changeelement =trim($element,")");
                        }
                        else{
                            $changeelement=$element;
                        }
                           old code for reference */
                        $changeelement=$element;
                        $tmpl_data = preg_replace('~<a[^>]*>'.$changeelement.'</a[^>]*>~','<a class="linkable">'.$changeelement.'</a>', $email_content[$i]->esl_content);
                        $email_content[$i]->esl_content = $tmpl_data;
                    }
                }   
                if($email_content[$i]->esl_article_id && $email_content[$i]->esl_aflw_id){
                    $email_content[$i]->esl_content = $this->replaceBlindingTags($email_content[$i]->esl_content, $email_content[$i]->esl_article_id, $email_content[$i]->esl_posted_by, $email_content[$i]->esl_user_id);
                    $email_content[$i]->resend_btn = false;
                }
                
                if(isset($email_content[$i]->esl_article_id) && isset($email_content[$i]->esl_aflw_id)){
                     if($this->is_custom_blinded(null, $email_content[$i]->esl_article_id, blinded_user:$email_content[$i]->esl_user_id, jnl:$jnl_code)){
                        $blinded_array[$i] = "anonymous user";
                        $email_content[$i]->esl_to = "anonymous user";
                        $details->blinded_user = true;
                     }
                }
                if(isset($email_content[$i]->esl_article_id) && isset($email_content[$i]->esl_posted_by) && $email_content[$i]->esl_posted_by != 0 && $email_content[$i]->esl_posted_by != $email_content[$i]->esl_user_id){
                    if($this->is_custom_blinded(null, $email_content[$i]->esl_article_id, blinded_user:$email_content[$i]->esl_posted_by, jnl:$jnl_code)){
                       $details->posted_user = "anonymous user";
                    }
               }
            }

			$details->message_body = $email_content;
			$details->journal_code = $jnl_code;
            $details->to = implode(',', array_replace(explode(',', $details->to), $blinded_array));
            if(str_contains($details->to, 'anonymous user')){
                $details->to = str_replace('anonymous user', "<span class='user_blinded px-1 mx-1' style='color: #c90000; border: 0.5px solid red; fontWeight: 200; borderRadius:4px; fontSize:0.8em;'>
                        anonymous user
                    </span>", $details->to);
            }

		}
        elseif(in_array($table_name,$reason_table_array))
        {
			$model=''; $reason='';
			if($table_name == 'change_due_date')
			{
				$model='Change_due_date';
				$reason='cd_reason';
                $Change_due_date = new \App\Models\Change_due_date;
                $details = $Change_due_date::timeline_details($tbk_id);
			}
			elseif($table_name == 'rescind_reset_record')
			{

				$model='Rescind_reset_record';
				$reason='rsc_reason';
                $Rescind_reset_record = new \App\Models\Rescind_reset_record;
                $details = $Rescind_reset_record::timeline_details($tbk_id);

			}
			elseif($table_name == 'articles')
			{
                $Articles = new \App\Models\Articles;
				$model='Articles';
				$reason='art_delete_reason';
                $details = $Articles::timeline_details($tbk_id);
			}
            /*Task #9176 Add reason for Do not transfer option*/
            elseif($table_name=='article_transfer_suggesion'){
                $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion;
                $reason='ats_reason';
				$model='Article_transfer_suggestion';
                $details = $Article_transfer_suggestion::timeline_details($tbk_id);
                
            }
            /* Task #9176 end*/
            elseif($table_name == 'article_custom_reasons'){
                $custom_reason = new \App\Models\Article_custom_reasons;
                $reason='cusr_reason';
                $details = $custom_reason::timeline_details($tbk_id);
                if(isset($details)){
                    switch($details->cusr_status){
                        case 'p':   
                            $reason = 'cusr_reason';
                            break;
                        case 'a' || 'r':
                            $reason = 'cusr_status_change_reason';
                            break;
                    }
                };
            }
			else
			{
                $Article_rescind_request = new \App\Models\Article_rescind_request;
				$model='Article_rescind_request';
				$reason='rrq_reason';
                $details = $Article_rescind_request::timeline_details($tbk_id);
			}


            $Generic_flows = new \App\Models\Generic_flows;
            $User = new \App\Models\User;


			if($details->$reason == 'review failed')
			{
				$reason=$posted_usr;
				$reason.= 'cleared the review submitted by';
				$reason.=$whome;
				$details->$reason=$reason;
			}
			$details->reason = $details->$reason;
            $template='tmpl_audittrial_reason';
			//$load_view = 'templates/tmpl_audittrial_reason';
		}
		elseif ($table_name === 'unassign_users')
		{

            $Unassign_reviewer = new \App\Models\Unassign_reviewer;
			$details = $Unassign_reviewer::get_single_record('*',"unsn_aflw_id={$tbk_id}");
			$details->reason = $details->unsn_reason;
            $template='tmpl_audittrial_reason';
			//$load_view = 'templates/tmpl_audittrial_reason';
		}
		elseif($table_name === 'article_notes')
		{
            $Article_notes = new \App\Models\Article_notes;
            $User = new \App\Models\User;
			$details = $Article_notes::timeline_note_details($tbk_id,$date_format);
            $template='tmpl_audittrial_art_note';
		}
		elseif ($table_name === 'tbk_article_flow')
		{
			//#3231 Reason for re-open
            $Article_flow = new \App\Models\Article_flow;
            $article_flow_table=(new \App\Models\Article_flow)->getTable();
            $tbktablename = (new \App\Models\Article_flow)::$tbk_table;
			$details  = new \stdClass();
			$reopen_query = 'SELECT aflw_remarks FROM ' . $tbktablename . ' WHERE tbk_id = '. $tbk_id ;

			$results = $Article_flow::get_records_by_raw_query($reopen_query);
			$details->reason = $results[0]->aflw_remarks;
            $template='tmpl_audittrial_reason';
		}
		$retutn_array=array();

		if ($details)
		{
            if(isset($details->date)&&$details->date!='')
            {
            $date_format_journal = $this->get_platform_date_format($jnl_id);
            $details->date=date($date_format_journal." h:i:s A", strtotime($details->date));
            }
             $retutn_array['details']=$details;
             $retutn_array['art_withdrawn_stat']=isset($article_data->art_delete_status)? $article_data->art_delete_status : NULL;
             $retutn_array['template']=$template;
            if(isset($details->posted_by) && $article_id && isset($details->posted_user)){
                $is_blinded = $this->is_custom_blinded(null, $article_id, blinded_user:$details->posted_by);
                if($is_blinded){
                    $details->posted_user = $is_blinded;
                }
            }
		}
        return $this->success("Success",200, $retutn_array );

    }
    catch(\Exception $e)
    {
        return $this->failure('Failed', 500, $e);
    }
	}
    public function render_email_log($rendering_data,$article_data,$current_journal_data)
	{
        $date_format = $this->get_platform_date_format($current_journal_data['jnl_id']);
		$render_html = '';
        $Article_type_advance_options = new \App\Models\Article_type_advance_options;
        $Article_types = new \App\Models\Article_types;
        $Stage_email_templates = new \App\Models\Stage_email_templates;
        $article_flow_table=(new \App\Models\Article_flow)->getTable();
        $Article_flow = new \App\Models\Article_flow;
		$review_method = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$article_data->art_artp_id}");
		if(!empty($review_method))
		{
			$user_name_arr = array();

			$action_arr = array(
					'assigned' => ' on assignment of ',
					'completed'=> ' on completion of ',
					'accepted'=> ' on the acceptance of invitation ( stage : ##STAGE## ) ',
					'invitation'=> ' for ##STAGE## stage ',
					'assigned_not_accepted'=> ' to accept invitation for ##STAGE## stage',
					'accepted_not_completed'=> ' to complete task on ##STAGE## stage',
					'uninvite_user'=> ' as a part of uninvite from ##STAGE## stage',
					'unassign_user'=> ' as a part of unassignment from ##STAGE## stage',
					'rescind_review'=> 'as a part of rescind from ##STAGE## stage',
					'transfer_article'=> 'as a part of transfer :article from ##STAGE## stage',
					'add_potential_reviewer'=> 'as a part of shortlist reviewer on ##STAGE## stage',
					'edit_potential_reviewer'=> 'as a part of edit reviewer information on ##STAGE## stage',
					'initialization'=> 'as a part of initialization of ##STAGE## stage',
					'assignment_change'=> 'as a part of change assignment of ##USER_ROLE## role on ##STAGE## stage from ',
					'coauthor_notify'     =>'as part of a completing ##STAGE## stage',
                    'change_assign_assignment'=>' on assignment of ',
                    'change_assign_unassignment'=>' on unassignment of '
                                      );

			$mask_name_reviewer = '';
			foreach($rendering_data as $rnd_dt)
			{
                $rnd_dt->old_user= array();
				$stage_user_ids = array();
				if($rnd_dt->flow_id != '')
				{
				$sql="select aflw_usr_id from ".$article_flow_table." where aflw_parent_flow_id= (select aflw_parent_flow_id from ".$article_flow_table." where aflw_id=".$rnd_dt->flow_id.") AND aflw_accepted_date !=NULL ORDER BY aflw_accepted_date ASC";
				$stage_user_id = $Article_flow::get_records_by_raw_query($sql);

				foreach($stage_user_id as $each_users)
				{
					$stage_user_ids[] = $each_users->aflw_usr_id;
				}
				}
				$rnd_dt->mask_name_reviewer = '';
				if($review_method->atotp_review_method != 'o' && $rnd_dt->jwf_stage_type == 'review' && $current_journal_data['core_role'] == 'author')
				{
					$mask_name_reviewer = "Reviewer ";
				}
				//in change assignment old user at reivew stage
                if($rnd_dt->old_user_id != '' && $rnd_dt->old_user_id != 0)
				{

					//if(isset($user_name_arr[$rnd_dt->old_user_id]))
						//$rnd_dt->old_user_id = $user_name_arr[$rnd_dt->old_user_id];
					//else
				//	{
                        $array_data['user_id'] = $rnd_dt->old_user_id;
                        $array_data['article_id'] = $rnd_dt->article_id;
                        $array_data['journal_id'] = $current_journal_data['jnl_id'];
                        $array_data['availability'] = TRUE;
                        $array_data['flag'] = TRUE;
                        $array_data['availability'] = TRUE;
						$user_name_arr[$rnd_dt->old_user_id] = $this->get_user_display_name($array_data);

						$rnd_dt->old_user_id = $user_name_arr[$rnd_dt->old_user_id];
					//}
				}
				//set posted user
				if($rnd_dt->posted_user_id != '' && $rnd_dt->posted_user_id != 0)
				{
					 ;
                        $array_data['user_id'] = $rnd_dt->posted_user_id;
                        $array_data['article_id'] = $rnd_dt->article_id;
                        $array_data['journal_id'] = $current_journal_data['jnl_id'];
                        $array_data['availability'] = TRUE;
                        $array_data['flag'] = TRUE;
                        $array_data['availability'] = TRUE;
						$user_name_arr[$rnd_dt->posted_user_id] = $this->get_user_display_name($array_data);

						$rnd_dt->posted_user = $user_name_arr[$rnd_dt->posted_user_id];

					if($mask_name_reviewer != '' && in_array($rnd_dt->posted_user_id,$stage_user_ids)&& $rnd_dt->jwf_stage_type == 'review' && $current_journal_data['core_role'] == 'author')
					{
						$pos_reviewer = array_search($rnd_dt->posted_user_id,$stage_user_ids) + 1;
						$rnd_dt->posted_user = $rnd_dt->mask_name_reviewer = $mask_name_reviewer.$pos_reviewer;
					}
				}

				//set proxy user
				if($rnd_dt->proxy_user_id != '' && $rnd_dt->proxy_user_id != 0)
				{
					if(isset($user_name_arr[$rnd_dt->proxy_user_id]))
						$rnd_dt->proxy_user = $user_name_arr[$rnd_dt->proxy_user_id];
					else
					{
                        $array_data['user_id'] = $rnd_dt->proxy_user_id;
                        $array_data['article_id'] = $rnd_dt->article_id;
                        $array_data['journal_id'] = $current_journal_data['jnl_id'];
                        $array_data['availability'] = TRUE;
                        $array_data['flag'] = TRUE;
                        $array_data['availability'] = TRUE;
						$user_name_arr[$rnd_dt->proxy_user_id] = $this->get_user_display_name($array_data);
						$rnd_dt->proxy_user = $user_name_arr[$rnd_dt->proxy_user_id];
					}
				}
                $rnd_dt->to_whome_specific_array=[];
				//some time multiple whome user ids
				if ($rnd_dt->to_whome_user_id != '')
				{

					$temp_towhome_arr = array();
					$temp_to_whome = array();
                    $temp_ids = explode(',', $rnd_dt->to_whome_user_id);


					foreach ($temp_ids as $temp_id)
					{
						$prefix = '';

						if ($rnd_dt->table_name == 'email_send_log')

                            $array_data['user_id'] = $temp_id;
                            $array_data['article_id'] = $rnd_dt->article_id;
                            $array_data['journal_id'] = $current_journal_data['jnl_id'];
                            $array_data['availability'] = TRUE;
                            $array_data['flag'] = TRUE;
                            $array_data['availability'] = TRUE;
							$user_name_arr = $this->get_user_display_name($array_data);

							$temp_towhome_arr[] = $user_name_arr;




					}

                    $rnd_dt->to_whome=$temp_towhome_arr;
                   // $rnd_dt->to_whome = implode(',', $temp_towhome_arr);
					//$rnd_dt->to_whome = implode(',', $temp_towhome_arr);
				}
                else
                {
                     /* Task #9861 Specific email id issue */     
                    if(isset($rnd_dt->to_whome)&&$rnd_dt->to_whome!='')
                    {
                      
                       $to_hybid_to_whom=$this->hybrid_whom_to($rnd_dt->to_whome,$rnd_dt->article_id,$current_journal_data['jnl_id']);
                  
                       
                       $rnd_dt->to_whome= implode(',',$to_hybid_to_whom['data_to_whom_specific']);
                    
                       $rnd_dt->to_whome_specific_array=$to_hybid_to_whom['data_to_whom'];
               
                    }

                        /* Task #9861 End Specific email id issue */
                }

				if ($rnd_dt->to_whome_changed_user_id != '' && $rnd_dt->to_whome_changed_user_id != 0)
				{

                        $array_data['user_id'] = $rnd_dt->to_whome_changed_user_id;
                        $array_data['article_id'] = $rnd_dt->article_id;
                        $array_data['journal_id'] = $current_journal_data['jnl_id'];
                        $array_data['availability'] = TRUE;
                        $array_data['flag'] = TRUE;
                        $array_data['availability'] = TRUE;
						$user_name_arr[$rnd_dt->to_whome_changed_user_id] = $this->get_user_display_name($array_data);
						$rnd_dt->to_whome_changed= $user_name_arr[$rnd_dt->to_whome_changed_user_id] ;

				}

				if ($rnd_dt->by_whome != '' && $rnd_dt->by_whome != 0)
				{

                        $array_data['user_id'] = $rnd_dt->by_whome;
                        $array_data['article_id'] = $rnd_dt->article_id;
                        $array_data['journal_id'] = $current_journal_data['jnl_id'];
                        $array_data['availability'] = TRUE;
                        $array_data['flag'] = TRUE;
                        $array_data['availability'] = TRUE;
						$user_name_arr[$rnd_dt->by_whome] = $this->get_user_display_name($array_data);
						$rnd_dt->by_whome = $user_name_arr[$rnd_dt->by_whome];

				}


				//$rnd_dt->journal_date_format = $this->jnl_data->jset_date_format;
				$show_merge_icon_wth_posted_user = '';
				$show_merge_icon_wth_by_whom = '';
				$show_merge_icon_wth_to_whom = '';
				$show_merge_icon_wth_to_whom_changed = '';




				if ($rnd_dt->table_name == 'email_send_log')
				{
                    $rnd_dt->to_whome_specific=false;
                    //print_r($rnd_dt->to_whome);exit;
                 if($rnd_dt->to_whome!=0)
                 {
                   //  print_r($rnd_dt->to_whome);exit;
					$to_whome_arr =$rnd_dt->to_whome;
				//	$to_whome_user_id_arr = explode(',', $rnd_dt->to_whome_user_id);

					$to_whome = '';

					if ($rnd_dt->to_whome_user_id != NULL)
					{
                        $rnd_dt->to_whome_specific=true;

					}

				}

				$rnd_dt->to_whome = $to_whome_arr;
            }

				$rnd_dt->show_merge_icon_wth_posted_user = $show_merge_icon_wth_posted_user;
				$rnd_dt->show_merge_icon_wth_by_whom = $show_merge_icon_wth_by_whom;
				$rnd_dt->show_merge_icon_wth_to_whom = $show_merge_icon_wth_to_whom;
				$rnd_dt->show_merge_icon_wth_to_whom_changed = $show_merge_icon_wth_to_whom_changed;
				$rnd_dt->action_mg = '';

				if(isset($action_arr[$rnd_dt->esl_etmp_action])  && $rnd_dt->esl_etmp_action != '' && $rnd_dt->jwf_stage_name != '')
				{
                    $action_arr[$rnd_dt->esl_etmp_action] = customTrans($action_arr[$rnd_dt->esl_etmp_action]);
					if($rnd_dt->esl_etmp_action == 'accepted')
					{
						$rnd_dt->action_mg = str_replace('##STAGE##',$rnd_dt->jwf_stage_name, $action_arr[$rnd_dt->esl_etmp_action]);
					}
					elseif($rnd_dt->jwf_assignment == 'invitation' && $rnd_dt->esl_etmp_action == 'assigned')
					{
						$rnd_dt->action_mg = str_replace('##STAGE##',$rnd_dt->jwf_stage_name, $action_arr[$rnd_dt->jwf_assignment]);
					}
					elseif($rnd_dt->esl_etmp_action == 'assigned_not_accepted' || $rnd_dt->esl_etmp_action == 'accepted_not_completed')
					{
						$rnd_dt->action_mg = str_replace('##STAGE##',$rnd_dt->jwf_stage_name, $action_arr[$rnd_dt->esl_etmp_action]);
					}
                                        //406 display univite user,unassign user and rescind review mail in emaillog
                                        elseif($rnd_dt->esl_etmp_action == 'uninvite_user' || $rnd_dt->esl_etmp_action == 'unassign_user' || $rnd_dt->esl_etmp_action == 'transfer_article' || $rnd_dt->esl_etmp_action == 'add_potential_reviewer'
                                         || $rnd_dt->esl_etmp_action == 'edit_potential_reviewer' || $rnd_dt->esl_etmp_action == 'initialization' )
                                        {
                                          $rnd_dt->action_mg =  str_replace('##STAGE##',$rnd_dt->jwf_stage_name, $action_arr[$rnd_dt->esl_etmp_action]);
                                        }

                                        elseif($rnd_dt->esl_etmp_action == 'rescind_review' && $rnd_dt->jwf_assignment == 'invitation' && $rnd_dt->jwf_stage_type =='review')
                                        {
                                          $rnd_dt->action_mg =  str_replace('##STAGE##',$rnd_dt->jwf_stage_name, $action_arr[$rnd_dt->esl_etmp_action]);
                                        }
                                        elseif($rnd_dt->esl_etmp_action == 'assignment_change' && $rnd_dt->user_role != '' && $rnd_dt->jwf_stage_type =='review')
                                        {
                                            $rnd_dt->action_mg=  str_replace('##STAGE##',$rnd_dt->jwf_stage_name, $action_arr[$rnd_dt->esl_etmp_action]);
                                            $rnd_dt->action_mg =  str_replace('##USER_ROLE##',$rnd_dt->user_role, $rnd_dt->action_mg);
                                        }

					 elseif($rnd_dt->esl_etmp_action == 'coauthor_notify')
					{
					$rnd_dt->action_mg =  $rnd_dt->action_mg =  str_replace('##STAGE##',$rnd_dt->jwf_stage_name, $action_arr[$rnd_dt->esl_etmp_action]);

					}

					else
						$rnd_dt->action_mg = $action_arr[$rnd_dt->esl_etmp_action].' '.$rnd_dt->jwf_stage_name.' stage';

					$rnd_dt->action_mg = $rnd_dt->action_mg;
				}

				$rnd_dt->action_time=date($date_format." h:i:s A", strtotime($rnd_dt->action_time));  ;
			//	$render_html .= $this->load->view('view_article_modification/email_log_row', $rnd_dt, TRUE);

			}
		}
      
		return $rendering_data;
	}

    public function set_filter_data($post_data)
    {
        $timeline_filter=array();
        if(isset($post_data['filter_search'])&&!empty($post_data['filter_search']))
        {
            $user='';
            $stage='';
            $type='';
            $filter_search=$post_data['filter_search'];
            if(isset($filter_search['user'])&&$filter_search['user']!=''&&$filter_search['user']!='select')
            $user=$filter_search['user'];

            if(isset($filter_search['events'])&&$filter_search['events']!=''&&$filter_search['events']!='select')
            $type=$filter_search['events'];
            $stage_type = '';
            $stage_assignment = '';
            $stage='';
            $temp_stage_type='';
            if(isset($filter_search['stagelist'])&&($filter_search['stagelist']!=''&&$filter_search['stagelist']!='select'))
            $temp_stage_type = $this->decrypt_data($filter_search['stagelist']);
            if($temp_stage_type != '')
            {
                $stage_type_arr = explode('#', $temp_stage_type);

                $stage=$stage_type_arr[0];
                $stage_type = $stage_type_arr[1];
                $stage_assignment = $stage_type_arr[2];
            }
        $timeline_filter = array(
            'user' => $user,
            'stage' =>$stage,
            'stage_type' => $stage_type,
            'stage_assignment' => $stage_assignment,
            'type' => $type,
        );

    }
       return  $timeline_filter;
    }

    public function get_article_flag_details(Request $request)
    {
        try {
            $post_data = $request->all();
            $Article_flag = new \App\Models\Article_flag();
            $article_id = decrypt_link($post_data['article_id']);
            $flags_choosed = array();
            $available_flags = array();
            $all_roles = Roles::get_all_records('role_id, role_name', NULL, 'role_name');
            /**
             * TASK #8446 article flags changes
             * changed due to choose only active flags for article flag list where flag status is 'y'
             * $criteria = ' flag_type="a"';
             */
            $criteria = ' flag_type="a" AND flag_status = "y"';
            $all_flags = Flags::get_all_records('flag_id,flag_name', $criteria, "flag_name");
            $artcriteria = "aflg_art_id=$article_id AND flag_status = 'y'";
            $artcriteria = "aflg_art_id=$article_id AND flag_status = 'y' GROUP BY aflg_flag_id, aflg_art_id, aflg_jnl_id";
            $article_flags = $Article_flag::get_article_flags('flag_id,flag_icon,flag_role,flag_color,flag_name,aflg_id,aflg_flag_id', $artcriteria);
            if ($article_flags != NULL) {
                foreach ($article_flags as $flag) {
                    $flags_choosed[] = $flag->aflg_flag_id;
                    $role_array = json_decode($flag->flag_role);
            		$role_name = array();
                    foreach ($all_roles as $roles) {
                        if (in_array($roles->role_id, $role_array))
                            $role_name[] = '<span class = "badge badge-primary mr-1">' . $roles->role_name . '</span>';
                    }
                    $flag->flag_role = implode("", $role_name);
                }
                $flags_choosed = array_unique($flags_choosed);
            }
            if ($all_flags != NULL) {
                foreach ($all_flags as $flag) {
                    if (!in_array($flag->flag_id, $flags_choosed))
                        $available_flags[] = $flag;
                }
            }
            $data['available_flags']  = $available_flags;
            $data['article_flags'] = $article_flags;
            return $this->success('Success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function save_article_flag(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'jnl_code' => 'required',
                'flow_id' => 'required'
                    ]);

                if($validator->fails())
                {
                        return  $this->failure('Failed',422,$validator->errors());
                }

                   $array['article_id']=decrypt_link($post_data['article_id']);
                    $array['jnl_code']=$post_data['jnl_code'];
                    $array['current_flow_id']=decrypt_link($post_data['flow_id']);
                    $array['url']=$request->segment(4);
                    $user_access=$this->check_permission_access_user($array);
                    if($user_access!=true)
                    {
                        return  $this->failure('Unauthorized', 200, 'Unauthorized User');
                    }
            $rtn_data  = array();
            if (isset($post_data['article_id'])) {
                $current_user = $this->get_current_user_details();
                $Article_flag = new \App\Models\Article_flag();
                $flag_id = decrypt_link($post_data['flag_id']);
                $article_id = decrypt_link($post_data['article_id']);
                $jnl_id = decrypt_link($post_data['jnl_id']);
                if (isset($flag_id) && $flag_id != '') {
                    $flag_data = 'aflg_flag_id =' . $flag_id . ' AND aflg_art_id =' . $article_id . ' AND aflg_jnl_id =' . $jnl_id;
                    $result = $Article_flag::get_single_record('count(aflg_id) as cnt', $flag_data);
                    if ($result->cnt > 0) {
                        $rtn_data['status'] = 'error';
                        $rtn_data['msg']    = 'Flag already exist';
                        return $this->warning('Warnings', 200, $rtn_data);
                    }
                    $ins_flag_data = array(
                        'aflg_flag_id' => $flag_id,
                        'aflg_art_id' => $article_id,
                        'aflg_jnl_id' => $jnl_id
                    );
                    $result = $Article_flag->insert_record($ins_flag_data, $current_user);
                    $rtn_data['status'] = 'success';
                    $rtn_data['msg']    = 'Flag already exist';
                    return $this->success('Success', 200, $rtn_data);
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function delete_article_flag(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'jnl_code' => 'required',
                'flow_id' => 'required'
                    ]);

                if($validator->fails())
                {
                        return  $this->failure('Failed',422,$validator->errors());
                }

                   $array['article_id']=decrypt_link($post_data['article_id']);
                    $array['jnl_code']=$post_data['jnl_code'];
                    $array['current_flow_id']=decrypt_link($post_data['flow_id']);
                    $array['url']=$request->segment(4);
                    $user_access=$this->check_permission_access_user($array);
                    if($user_access!=true)
                    {
                        return  $this->failure('Unauthorized', 200, 'Unauthorized User');
                    }
            $rtn_data  = array();
            if (isset($post_data['article_id'])) {
                $current_user = $this->get_current_user_details();
                $Article_flag = new \App\Models\Article_flag();
                $flag_id = decrypt_link($post_data['flag_id']);
                $article_id = decrypt_link($post_data['article_id']);
                $jnl_id = decrypt_link($post_data['jnl_id']);
                $journal_code = $post_data['jnl_code'];
                $formatted_journal_code = '_' . $journal_code;
                $criteria=array('aflg_flag_id'=>$flag_id,'aflg_art_id'=>$article_id);
                $result = $Article_flag ->get_single_record_with_bind_cond('aflg_emt_id,aflg_aflw_id',$criteria); 
                if(!empty($result) && isset($result->aflg_emt_id) && isset($result->aflg_aflw_id)){
                    $condition ="gdata_atfemt_id ={$result->aflg_emt_id} and gdata_flag_id = $flag_id and gdata_art_id = $article_id  and gdata_artflw_id = {$result->aflg_aflw_id}";
                $gdata_details = array(
                    'gdata_flag_deletestatus' =>  'y'
                );
                Article_generic_form_data::update_record($gdata_details,$condition, $current_user, $formatted_journal_code);
                }
                $Article_flag->delete_records('aflg_flag_id =' . $flag_id . ' AND aflg_art_id =' . $article_id, '', $current_user);
                return $this->success('Success', 200);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function get_all_article_notes(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'jnl_code' => 'required',
                'flow_id' => 'required',
                    ]);

                if($validator->fails())
                {
                        return  $this->failure('Failed',422,$validator->errors());
                }

            $array['article_id']=decrypt_link($post_data['article_id']);
            $array['jnl_code']=$post_data['jnl_code'];
            $array['current_flow_id']=decrypt_link($post_data['flow_id']);
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');
            }
            $rtn_arr = array();
            $showAddBtn = FALSE;
            $user_array = array();
            $temp_user_roles_notes = array();
            $is_authr_rvwr = FALSE;
            $view_note_roles = array();
            $read_update = 'y';
            $hide_settings = FALSE;
            $previous_show = FALSE;

            if ($post_data['version'] == "old") {
                $hide_settings = TRUE;
            }
            $current_user = $this->get_current_user_details();
            $article_id = decrypt_link($post_data['article_id']);
            $article_data = Articles::get_article_data($article_id);
            $user_roles_artp = $this->validate_user_journal($post_data['jnl_code'], $current_user['user_id'], $article_data->artp_id);
            if($post_data['jnl_id']!=""){
                $jnlStatus = Journals::validateJournal($post_data['jnl_id']);
                if($jnlStatus == false){
                    return  $this->failure('Failed',500,'Journal ID not valid');
                }
            }
            $article_privilages = $this->article_privilages($article_data, '', $post_data['jnl_code']);
            $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
            $user_array['user_roles'] = $user_roles_artp;
            $user_array['article_id'] = $article_id;
            $user_array['all_roles'] = $all_roles;
            $user_array['jnl_id'] = $post_data['jnl_id'];
            $user_array['user_id'] = $current_user['user_id'];
            $user_array['artp_id'] = $article_data->artp_id;
            $user_roles = $this->get_article_user_roles($user_array);
            $date_format = $this->get_platform_date_format($post_data['jnl_id']);
            $date_format = date_format_map($date_format);
            $select = 'art_version_no,art_code,an_id, an_art_id, an_title, an_to, an_note, an_posted_by, an_proxy_id, CONCAT(usr_first_name," ",usr_last_name) as posted_by, DATE_FORMAT(an_posted_date, "' . $date_format . '  %h:%i %p") as posted_date, usr_id AS note_by,an_read_users';
            $article_ids = $this->get_all_version_art_ids($article_id);;
            $where_condition =  'an_art_id IN (' . $article_ids . ')';
            $article_notes = Article_notes::get_notes($select, $where_condition);
            // print_r($article_notes);die;
            $current_user_notes = array();
            $update_array = array();
            $authr_role_id = Roles::get_role_ids("role_assigned_role IN('author')");
            $revr_role_id = Roles::get_role_ids("role_assigned_role IN('reviewer')");
            $revr_role_ids = explode(';', $revr_role_id->role_ids);
            $jnl_admin_role_id = Roles::get_role_ids("role_assigned_role IN('journal_admin')");
            $staff_role_id = Roles::get_role_ids("role_assigned_role IN('staff')");
            $staff_role_ids = explode(';', $staff_role_id->role_ids);
            foreach ($article_notes as $article_note) {
                $view_note_roles = json_decode($article_note->an_to);
                if (!is_array($view_note_roles)) {
                    $view_note_roles = (array) $view_note_roles;
                }
                $view_note_roles = array_merge((array) $jnl_admin_role_id->role_ids, $view_note_roles);
                $view_note_roles = array_merge($staff_role_ids, $view_note_roles);
                $view_note_roles = array_unique($view_note_roles);

                if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y' && $article_privilages['reviewer'] == TRUE && ($key = array_search($jnl_admin_role_id->role_ids, $view_note_roles)) !== false) {
                    unset($view_note_roles[$key]);
                }
                if (($key = array_search($authr_role_id->role_ids, $view_note_roles)) !== false && $article_privilages['author'] == FALSE) {
                    unset($view_note_roles[$key]);
                }
                if (count(array_intersect($revr_role_ids, $user_roles['role_id'])) > 0 && $article_privilages['reviewer'] == FALSE) {
                    $temp_user_roles_notes = array_intersect($revr_role_ids, $user_roles['role_id']);
                }
                $view_note_roles = array_diff($view_note_roles, $temp_user_roles_notes);
                if (is_array($view_note_roles) && sizeof(array_intersect($view_note_roles, $user_roles['role_id'])) > 0 || $article_note->an_posted_by == $this->current_user['user_id']) {
                    $encrpt_an_id = encrypt_link($article_note->an_id);
                    $encrpt_an_id = str_replace("~", "", $encrpt_an_id);
                    $article_note->encrpt_an_id = $encrpt_an_id;
                    $current_user_notes[] = $article_note;
                }
                if ($read_update == 'y' && $current_user['user_id'] != $article_note->an_posted_by) {
                    $read_user_array = array();
                    if ($article_note->an_read_users != NULL) {
                        $read_user_array = json_decode($article_note->an_read_users);
                    }
                    if (!in_array($current_user['user_id'], $read_user_array)) {
                        $read_user_array[] = $current_user['user_id'];
                        $read_user_string = json_encode($read_user_array);
                        $update_array[] = array(
                            'an_id' => $article_note->an_id,
                            'an_read_users' => $read_user_string
                        );
                    }
                }
                $article_code    = null;
                $article_version = null;
                if (isset($article_note->art_code) && !empty($article_note->art_code)) {
                    $article_code = $article_note->art_code;
                    $article_version = ($article_note->art_version_no == 0) ? 'Original version' : 'Revision ' . $article_note->art_version_no;
                }
                $article_note->article_code = $article_code;
                $article_note->article_version = $article_version;
                $article_note->note_stat = false;
                //&& $article_note->an_proxy_id == 0
                if ($article_note->an_art_id == $article_id && $current_user['user_id'] == $article_note->an_posted_by ) {
                    $article_note->note_stat = true;
                }

                if($this->is_custom_blinded(null, $article_note->an_art_id, blinded_user:$article_note->an_posted_by)){
                    $article_note->posted_by = "anonymous user";
                }
                
                // print_r($current_user['user_id']);die;
                $article_note->proxy_name = '';
                if ($article_note->an_proxy_id != 0) {
                    $proxy_full_name = User::get_single_record('CONCAT(usr_first_name," ",usr_last_name) as full_name', 'usr_id =' . $article_note->an_proxy_id);
                    $article_note->proxy_name = $proxy_full_name->full_name;
                }
                // json_encode(array_values(
                $article_note->an_to = (json_decode($article_note->an_to));
            }
            if (!empty($update_array) && count($current_user_notes) > 0) {
                // print_r($update_array);die;
                Article_notes::update_batch($update_array, 'an_id');
            }
            $current_article_data = Articles::get_single_record('art_pre_all_ids', 'art_id =' . $article_id);
            $previous_versions = $this->get_previous_versions($current_article_data);
            $rtn_arr['notes']['data'] = $current_user_notes;
            $encr_art_typ_id = $article_data->artp_id;
            $article_note_permission = $this->check_to_add_notes($article_id, $post_data['jnl_id'], $encr_art_typ_id, $user_roles);
            // print_r($article_note_permission);die;
            if ($article_note_permission == TRUE) {
                $rtn_arr['notes']['notes_to'] = User_to_journals::get_all_roles('usrj_artp_id =' . $article_data->artp_id, FALSE, 'a');
            }
            if ($article_privilages['author'] == TRUE || $article_privilages['reviewer'] == TRUE) {
                $is_authr_rvwr = TRUE;
                $reviewer_in_progress = $this->reviewer_inprogress_check($article_id);
                if ($reviewer_in_progress == FALSE) {
                    $is_authr_rvwr = FALSE;
                }
            }
            $rtn_arr['notes']['hide_settings'] = $hide_settings;
            $rtn_arr['notes']['add_notes'] = $article_note_permission;
            $rtn_arr['notes']['is_author'] = $is_authr_rvwr;
            $rtn_arr['article_type_data'] = Article_types::get_single_record('artp_id,artp_article_type,artp_fwm_id,artp_jnl_id, artp_special_issue,artp_abbr_article_type', 'artp_id =' . $article_data->artp_id);
            $rtn_arr['note_article_id'] = $article_id;
            // print_r($current_user);die;
            // $rtn_arr['current_usr_core_role'] = $post_data['core_role'];
            $rtn_arr['previous_versions'] = $previous_versions;
            $rtn_arr['article_id'] = $article_id;
            $rtn_arr['client_code'] = $this->current_client->clnt_client_code;
            $rtn_arr['previous_show'] = $previous_show;
            $rtn_arr['client_functionality'] = $this->current_client->functionality;
            return $this->success('Success', 200, $rtn_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function check_to_add_notes($article_id, $jnl_id, $art_typ_id, &$roles_assigned = "")
    {
        $current_user = $this->get_current_user_details();
        /* start -- fetch user roles */
        $jnl_user_roles = User_to_journals::get_user_jnl_roles($current_user['user_id'], $jnl_id);
        $allow_note_roles = array();
        $current_user_roles = array();
        $article_note_permission = FALSE;

        // $permission_roles = Article_type_advance_options::get_single_record('atotp_add_notes', 'atotp_artp_id =' . decrypt_link($art_typ_id));
        $select = "jp_add_notes";
        $condition = "artp_id=" . $art_typ_id;
        $permission_roles = $this->get_article_type_permission($select, $condition);
        // print_r($permission_roles);die;

        if ($permission_roles->jp_add_notes != NULL) {
            $allow_note_roles = json_decode($permission_roles->jp_add_notes);
        }
        if ($jnl_user_roles[0]->role_ids != '') {
            $current_user_roles = explode(';', $jnl_user_roles[0]->role_ids);
        }
        if (count(array_intersect($current_user_roles, $allow_note_roles)) > 0) {
            $article_note_permission = TRUE;
        }
        $isCurrentVersion =Articles::get_single_record('GROUP_CONCAT(art_id) as art_ids',"FIND_IN_SET( {$article_id}, art_pre_all_ids)")->art_ids;
        if(!empty($isCurrentVersion)){
            $article_note_permission = FALSE;
        }
        $roles_assigned = $current_user_roles;
        return $article_note_permission;
    }
    public function reviewer_inprogress_check($article_id)
    {
        $current_user = $this->get_current_user_details();
        $is_rvwr = TRUE;
        $article_flow_table = (new \App\Models\Article_flow)->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows)->getTable();

        if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y') {
            $tables = array(
                'main_table' => $article_flow_table,
                   'join_table' => array(
                    $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id')
                )

            );
         $reviewer_criteria = 'aflw_art_id=' .$article_id . ' AND aflw_status!=\'c\' AND jwf_stage_type=\'review\' AND aflw_usr_id='.$current_user['user_id'].' ';
          /*  $reviewer_criteria = array(
                'aflw_art_id' => $article_id,
                'aflw_status !=' => 'c',
                'jwf_stage_type' => 'review',
                'aflw_usr_id' => $current_user['user_id']
            );*/
   


            $reviwer_role_count = Article_flow::get_results_using_joins($tables,'count(aflw_id) as cnt', $reviewer_criteria, 'single');
            $reviewer_in_progress = (isset($reviwer_role_count->cnt) && $reviwer_role_count->cnt > 0) ? TRUE : FALSE;
            if ($reviewer_in_progress == FALSE) {
                $is_rvwr = FALSE;
            }
        } else {
            $is_rvwr = FALSE;
        }
        return $is_rvwr;
    }
    public function save_article_note(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'subject'    => 'required',
                'jnl_id'     => 'required',
                'flow_id' => 'required',
                'jnl_code'     => 'required',
             ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $array['article_id']=decrypt_link($post_data['article_id']);
            $array['jnl_code']=$post_data['jnl_code'];
            $array['current_flow_id']=decrypt_link($post_data['flow_id']);
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');
            }
            $articleType = array('input'=>Rv_decrypt($post_data['artp_id']),'type'=>'string','enc_data'=>FALSE);
            $typeValidation = $this->Rv_validator($articleType);
            if($typeValidation!= true){
                return $this->warning('Warning',200,'Invalid data','Warning');
            }
            $returnArr = array(
                'status' => 'failed'
            );

            $current_user = $this->get_current_user_details();
		    $article_id = decrypt_link($post_data['article_id']);
		    $jnl_id = decrypt_link($post_data['jnl_id']);
	    	$add_notes = $this->check_to_add_notes($article_id, $jnl_id, Rv_decrypt($post_data['artp_id']));
            if ($add_notes == FALSE)
            {
                return  $this->warning('Warnings',200,$returnArr,'warning');
            }
            $note_title = trim($post_data['subject']);
            if($post_data['subject'] == 'Other')
            {
                $note_title = trim($post_data['customSubject']);
            }
            $insData = array(
                'an_art_id' => $article_id,
                'an_title' => $note_title,
                'an_note' => trim($post_data['noteContent']),
                'an_to' => NULL
            );
            if (isset($post_data['whoCanSeeNote']) && !in_array('-1', $post_data['whoCanSeeNote']))
            {
                $insData['an_to'] = json_encode(array_values($post_data['whoCanSeeNote']));
            }
            DB::beginTransaction();
            if ($post_data['note_id'] == '')
            {
                $return['action'] = 'add';
                $new_an_id = Article_notes::insert_record($insData, $current_user);
            }
            else
            {
                $return['action'] = 'update';
                $an_id = ($post_data['note_id']);
                $condition = 'an_id =' . $an_id;
                $new_an_id = Article_notes::update_record($insData, $condition);
                if ($new_an_id)
                    $new_an_id = $an_id;
            }
            if ($new_an_id)
			{
                DB::commit();
                $returnArr['status']="success";
                return $this->success('Success', 200, $returnArr);
            }
            return  $this->warning('Warnings',200,$returnArr,'warning');
        } catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }
    public function delete_article_note(Request $request)
    {
        try{
            $post_data = $request->all();

            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'jnl_code' => 'required',
                'flow_id' => 'required'
                    ]);

                if($validator->fails())
                {
                        return  $this->failure('Failed',422,$validator->errors());
                }

            $array['article_id']=decrypt_link($post_data['article_id']);
            $array['jnl_code']=$post_data['jnl_code'];
            $array['current_flow_id']=decrypt_link($post_data['flow_id']);
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');
            }
            $returnArr = array(
                'status' => 'failed'
            );
		    $note_id = decrypt_link($post_data['note_id']);
		    $article_id = decrypt_link($post_data['article_id']);
            $current_user = $this->get_current_user_details();
		    $jnl_id = decrypt_link($post_data['jnl_id']);
            $add_notes = $this->check_to_add_notes($article_id, $jnl_id, Rv_decrypt($post_data['artp_id']));
            if ($add_notes == FALSE){
                return  $this->warning('Warnings',200,$returnArr,'warning');
            }
            DB::beginTransaction();
            $res = Article_notes::delete_records('an_id =' . $note_id, '', $current_user);

            if($res == true){
                DB::commit();
                $returnArr['status']="success";
                return $this->success('Success', 200, $returnArr);
            }
            return  $this->warning('Warnings',200,$returnArr,'warning');
        } catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_parent_mail_details(Request $request)
    {
        try{
            $post_data = $request->all();
            $Article_emaillog = new \App\Models\Article_emaillog;
            
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'jnl_code' => 'required',
                'esl_id' => 'required',
                    ]);
                if($validator->fails())
                {
                        return  $this->failure('Failed',422,$validator->errors());
                }
                $returnArr = array(
                    'status' => 'failed'
                );
                $article_id=$post_data['article_id'];
                $jnl_code=$post_data['jnl_code'];
                $esl_id=decrypt_link($post_data['esl_id']);
                $current_version_id=decrypt_link($post_data['current_version_id']);
                $limit = 1;
                $offs = 0;
                $last_audit = 0;
                $current_user = $this->get_current_user_details();
                // Task #206 , Reply-mail, parant mail flag declaration.
                $parent_mail_flag = TRUE;
                $core_role=$post_data['core_role'];
                $current_role_status = $this->check_user_production_status($article_id,$current_user['user_id']);
                $user_id = $current_user['user_id'];
                if($current_role_status !='review_only' && $core_role != 'journal_admin')
                {
                    $previous_show = $this->get_previous_view_permission($post_data);
                }
                else
                {
                    $previous_show = TRUE;
                }
                $current_journal_data['role_id']=$post_data['role_id'];
                $current_journal_data['jnl_id']=$post_data['jnl_id'];
                $current_journal_data['jnl_code']=$post_data['jnl_code'];
                $current_journal_data['core_role']=$post_data['core_role'];
                $email_filter=$this->set_filter_data($post_data);
                
                $data = $this->article_email_log($article_id,$current_version_id,$limit, $offs, $last_audit,$previous_show,$user_id,$current_journal_data,$email_filter,$esl_id,$parent_mail_flag);
                if(!empty($data)){
                    return $this->success('success', 200, $data);
                }else{
            return  $this->warning('Warnings',200,$returnArr,'warning');
                }

        } catch (\Exception $e) {
            // print_r($e);
            return $this->failure('Failed', 500, $e);
        }
    }
    public function getRecievemailParentUserId($secretId)
    {
        $Email_send_log = new \App\Models\Email_send_log;
        // Task #206 , Reply-mail, get parent mail esl_id.
        $parent_user_id = $Email_send_log::get_single_record('esl_user_id', " esl_trans_secret_id = '{$secretId}'");
        return $parent_user_id->esl_user_id;

    }

    public function replaceBlindingTags($content, $art_id, $user_id, $recp_id = null)
    {
        
        // $jwf_id = (new Article_flow())->setTable(Article_flow::$tbk_table)->select(['aflw_jwf_id'])->orderby('tbk_id', 'desc')->find($aflw_id)?->aflw_jwf_id;
        // $role_id = Generic_flows::find($jwf_id)?->jwf_role_id;
        $is_current_user_blinded = $this->is_custom_blinded(null, $art_id, blinded_user: $user_id );
        $replacement = '$1';  // Replace with class name only

        if ($is_current_user_blinded) {
            $pattern = '/<rvbu class="([^"]*)"[^>]*>(.*?)<\/rvbu>/';

            $content = preg_replace($pattern, $replacement, $content);
        } 
        if($recp_id){
            $is_recipient_blinded = $this->is_custom_blinded(null, $art_id, blinded_user:$recp_id);
            if($is_recipient_blinded){
                $pattern = '/<rvrt class="([^"]*)"[^>]*>(.*?)<\/rvrt>/';
                $content = preg_replace($pattern, $replacement, $content);
            }
        }
        $is_author_blinded = $this->is_custom_blinded('author', $art_id);
        if($is_author_blinded){
            $pattern = '/<rvat class="([^"]*)"[^>]*>(.*?)<\/rvat>/';
            $content = preg_replace($pattern, $replacement, $content);
        }
            return $content;
        
    }

    public function hybrid_whom_to($whom_to_users,$article_id,$jnl_id){
        $temp_data_to_whom=[];
        $temp_data_to_whom_specific=[];
        if(isset($whom_to_users)&&$whom_to_users!='')
        {
           $email_array=explode(',',$whom_to_users);
           if(!empty($email_array))
           {
           
           
            foreach($email_array as $email)
            {
               
                $user=User::get_single_record_with_bind_cond('usr_id',array('usr_email'=>trim($email)));
             
                if(!empty($user))
                {
                   
                    $array_data['user_id'] = $user->usr_id;
                    $array_data['article_id'] = $article_id;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['availability'] = true;
                    $array_data['flag'] = true;
                    $array_data['availability'] = true;
                    $user_name_arr = $this->get_user_display_name($array_data);
                    $temp_data_to_whom[]=$user_name_arr;
                }
                else
                {
                    $temp_data_to_whom_specific[]=$email;
                }
            }
           }
           
        }
        $array_to_whom['data_to_whom']= $temp_data_to_whom;
        $array_to_whom['data_to_whom_specific']= $temp_data_to_whom_specific;
        return $array_to_whom;
      
    }

}
