<?php

namespace App\Http\Controllers;

use App\Events\ArticleStatusUpdate;
use App\Http\Services\ConveyService;
use Illuminate\Http\Request;
use App\Models\Email_templates;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\JournalUserfunctionTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Http\Traits\StagemovementTrait;
use Config;
use DB;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Authors;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Models\Article_type_advance_options;
use App\Models\Generic_flows;
use App\Models\User;
use App\Models\User_affiliations;
use App\Models\Authors_affiliation;
use App\Models\Article_tab_status;
use App\Models\Required_file_type;
use App\Models\Attachment_file_description;
use App\Models\Attachment_designated_roles;
use App\Models\Attachment_files;
use App\Models\File_upload_type;
use App\Models\Article_pdf;
use App\Models\Event_invited_users;
use App\Models\Events_model;
use App\Models\Article_keywords;
use App\Models\Journal_permission;
use App\Http\Traits\SubmissionTrait;
use Illuminate\Support\Facades\Storage;
use App\Models\Issues;
use App\Models\Classifications;
use App\Models\Keyword_relationship;
use App\Http\Traits\InstituteSearchEngineTrait;
use App\Models\Abstract_category;
use App\Models\Article_classification;
use App\Models\Article_custom_reasons;
use App\Models\Article_reviewers;
use App\Models\Article_funder_details;
use App\Models\Funders;
use App\Models\Issue_management;
use PhpParser\Node\Expr\Print_;
use stdClass;
use ZipArchive;
use DOMDocument;
use DOMXPath;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use File;
use App\Http\Traits\RemoteConnectionTrait;
use App\Jobs\addAllUserOfArticleToConveyJob;
use App\Jobs\archiveUserFromDiscloserList;
use App\Models\AuthorHistory;
use Illuminate\Support\Facades\Crypt;
use Carbon\Carbon;
use Illuminate\Support\Facades\Broadcast;
use App\Http\Traits\ResearchIntegrityTrait;
use App\Models\Research_integrity_reports;
class Manage_Article_Submission_Api extends Controller
{

    use StagemovementTrait;
    use JournalUserfunctionTrait;
    use SubmissionTrait;
    use InstituteSearchEngineTrait;
    use ResearchIntegrityTrait;

    public $current_user;
    public function index(Request $request)
    {

        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'platform_code' => 'required',
                'art_type_code' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' =>$post_data['platform_code'],
                'type'=> 'string'
            );
            $platformcode_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$post_data['art_type_code'],
                'type'=> 'string'
            );
            $arttypecode_validate = $this->Rv_validator($input_arr);
            if($platformcode_validate == FALSE ||$arttypecode_validate==FALSE)
			{
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",201,$arraymsg);
            }
            $array['article_id']=decrypt_link($post_data['article_id']);
            $array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
            $array['url']=$request->segment(4);

            $user_access=$this->check_permission_access_user($array);
            /*if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 422, 'Unauthorized User');

            }*/
            $platform_code = $post_data['platform_code'];
            $art_type_code = $post_data['art_type_code'];
            if(isset($post_data['submission_type']) && $post_data['submission_type'] == 'submit_for_production')
            {
                $art_type_code = decrypt_link($post_data['art_type_code']);
            }
            $article_id = isset($post_data['article_id']) ? $this->decrypt_data($post_data['article_id']) : '';
            $article_flow_id = isset($post_data['art_flow_id']) ? $this->decrypt_data($post_data['art_flow_id']) : '';
            $platform_data = $this->platform_basic_settings_data($platform_code);
            $platform_id = $platform_data->jnl_id;
            $return_array['article_type_details'] = $this->article_type_settings_data($art_type_code, $platform_id);
            $article_details = array();
            $articleKeywordSet = NULL;
            $articleClassificationSet = null;
             $authorList ='';
            $article_funder_records = array();
            if ($article_id != NULL) {
                $date_format = $platform_data->jset_date_format;
                $date_format = static::date_format_map($date_format);
                $select = '*, DATE_FORMAT(art_stub_duedate,"' . $date_format . '") as stub_duedate, DATE_FORMAT(art_update_last_date,"' . $date_format . '") as update_last_date,art_receive_funding';
                // $criteria = "art_id={$article_id}";
                // $article_details = Articles::get_single_record($select, $criteria);
                $criteria = "art_id= ?";
                $article_details = Articles::get_single_record($select, $criteria,binding_arr:[$article_id]);
                $stages_arr = array();
                if($article_details->art_stage_submission_method == 'n')
                {
                    $submitted_stages = json_decode($article_details->art_submitted_current_stage);
                    if($submitted_stages !== '')
                    {
                        foreach($submitted_stages as $single_stages)
                        {
                            $myObj = new stdClass();
                            //echo $single_stages;
                            $myObj->value = $single_stages;
                            $condition = 'jwf_id ='.$single_stages;
                            $flow_data = Generic_flows::get_single_record('jwf_stage_name', $condition);
                            $myObj->label = $flow_data->jwf_stage_name;
                            array_push($stages_arr,$myObj);
                        }
                    }
                }
                $article_details->current_stages = $stages_arr;
                //get all article keywords
                // $article_details->keywordSelected = null;
                $hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;

                $articleKeywordSet = Article_keywords::get_article_keywords($article_id, FALSE, FALSE, $hierarchy, $platform_id);
                //get all article classifications
                //$condition ="arcls_art_id ={$article_id}";
                // $checkBoxData = Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition);
                $condition ="arcls_art_id = ?";
                $checkBoxData = Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition,binding_arr:[$article_id]);
                if(!empty($checkBoxData->checkData)){
                    $articleClassificationSet = json_decode(json_encode(explode(',', $checkBoxData->checkData)));
                    // $articleClassificationSet = $this->search_classificationdata($return_array['article_type_details']->artp_id,NULL,$checkBoxData->checkData);
                }
                //funderRef details
                if(isset($article_details->art_receive_funding) && $article_details->art_receive_funding == 'y'){
                    $article_funder_records = $this->get_funderRef_by_article_id($article_id);
                }
                  //Task #3457 Basecamp Ticket: Author Ability to Select Section -start
            if(isset($this->current_client->functionality->cfty_disable_author_classification_edit) && 
            $this->current_client->functionality->cfty_disable_author_classification_edit === 'y'
              ) {
                $authorList = Authors::get_all_records_with_bind_cond(
                    'auth_usr_id', 
                    ['auth_art_id' => $article_id]
                );
               
            }
            ////Task #3457 Basecamp Ticket: Author Ability to Select Section -end
            }
            // get all available issues
            $iss_criteria = 'FIND_IN_SET(' . $return_array['article_type_details']->artp_id . ',replace(replace(replace(iss_art_type,\'"\',""),"]",""),"[",""))>0 and iss_special_issue = \'y\' and iss_start_date <= CURDATE() and iss_status!=\'c\'';
            $return_array['issues'] = Issues::get_issues('iss_title,iss_id,vol_title,iss_soft_end_date,iss_hard_end_date', $iss_criteria); 
            foreach($return_array['issues'] as $issue)
            {
                $current_date = date_create(date('Y-m-d'));
                $softend_date = date_create($issue->iss_soft_end_date);
                $today = strtotime(date('Y-m-d')); // Current date

                if ($softend_date < $current_date) 
                {
                    $issue->disabled = true;
                }
                else
                {
                    $issue->disabled = false;
                }
            }
            //get all clasificaciones
            $term_table = (new \App\Models\Terms())->getTable();
            $classification_table = (new \App\Models\Classifications())->getTable();
            $cls_criteria = "cls_artp_id='{$return_array['article_type_details']->artp_id}'";
            $select = '*';
            $tables = array(
                'main_table' => $term_table,
                'join_table' => array(
                    $classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
                )
            );
            $classification_details = Classifications::get_results_using_joins($tables, $select, $cls_criteria, '');
            $res = [];
            if (count($classification_details) > 0) {
                foreach ($classification_details as $e) {
                    $this->convertToArr($res, $e);
                }
            }
            // print_r($res);die;
  
            $parent_keys = Classifications::get_single_record(' GROUP_CONCAT(DISTINCT cls_primary_id) as parent_keys', 'cls_jnl_id =' . $platform_id);
            $return_array['parentSet'] = (!empty($parent_keys->parent_keys)) ? Rv_encrypt($parent_keys->parent_keys) : null;
			$classification_treedata=json_decode(json_encode($res));
            $return_array['classification_treedata'] = $classification_treedata;
            $return_array['article_keyword'] = $articleKeywordSet;
            $return_array['articleClassification'] = $articleClassificationSet;
            $return_array['article_details'] = $article_details;
            $return_array['funder_details'] = $article_funder_records;
             $return_array['authorList'] = $authorList;

            //fetch the client's proceeding config array
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
            $return_array['proceeding_arr'] = $proceedingArr;
            return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function getarticletabstatus(Request $request)
    {
        try {
            $return_array = array();
            $Journal_terms = new \App\Models\Journal_terms();

            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id'=>'required'
                // 'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' => decrypt_link($post_data['art_id']),
                'type'=> 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);

            if($art_id_validate == FALSE)
			{
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",201,$arraymsg);
            }
            $array['article_id']=decrypt_link($post_data['art_id']);
            $array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');
            }
            //restricting edit-author url for users who are not allowed to view
            //TASK #3606 - Url redirecting issue in author submission - start
            $platform_data = $this->platform_basic_settings_data($post_data['platform_code']);
            $platform_id   = $platform_data->jnl_id;
            $arr = array(
                'article_id'        => $array['article_id'],
                'article_type_code' => $post_data['art_type_code'],
                'platform_id'       => $platform_id
            );
            $check_status = $this->confirm_author_access($arr);
            if(isset($check_status['status']) && $check_status['status'] == 'failed') {
                return $this->warning("Failed",201,$check_status);
            }
            //TASK #3606 - Url redirecting issue in author submission - end
            $article_stub = FALSE;
            $return_array['unset_tabreview_preference']=FALSE;
            $return_array['unset_tabattach_files']=FALSE;
            $return_array['unset_tabadditional_info']=FALSE;
            $show_generic_tab = FALSE;
            $article_for_resubmission = FALSE; // to do later
            $article_id = $this->decrypt_data($post_data['art_id']);
            $article_flow_id = $this->decrypt_data($post_data['art_flow_id']);
            // $condition = "tab_status_art_id={$article_id}";
            $condition = "tab_status_art_id= ?";
            // $tab_details = Article_tab_status::get_single_record('*', $condition);
            $tab_details = Article_tab_status::get_single_record('*', $condition,binding_arr:[$article_id]);
            // $art_condition = "art_id={$article_id}";
            $art_condition = "art_id= ?";
            // $article_details = Articles::get_single_record('*', $art_condition);
            $article_details = Articles::get_single_record('*', $art_condition,binding_arr:[$article_id]);
            // $article_flow =$return_array['article_flow']= Article_flow::get_single_record('*', "aflw_art_id={$article_id}");
            $article_flow =$return_array['article_flow']= Article_flow::get_single_record('*', "aflw_art_id= ?",binding_arr:[$article_id]);
            $return_array['tab_status'] = $tab_details;
            $return_array['article_details'] = $article_details;
            $article_funder_records = array();
            if($article_details->art_receive_funding == 'y'){
                $article_funder_records = $this->get_funderRef_by_article_id($article_id);
            }
            $return_array['funder_details'] = $article_funder_records;
            $articletype_id = $return_array['article_details']->art_artp_id;
            $article_advanced_details = Article_type_advance_options::get_all_records('*', "atotp_artp_id={$articletype_id}");
            $flow_master_id = Article_types::get_single_record('artp_fwm_id,artp_jpm_id', "artp_id={$articletype_id}");
            $stage = Generic_flows::get_single_record('jwf_article_attachment_status,jwf_enable_payment', "jwf_stage_type='author_submission' AND jwf_fwm_id={$flow_master_id->artp_fwm_id}");
            $article_attachment_status=$stage->jwf_article_attachment_status;
            $article_payment_status=$stage->jwf_enable_payment;
            $return_array['article_advanced_details'] = $article_advanced_details;
            // $return_array['all_primary_terms'] = $Journal_terms::get_primary_in_journal($articletype_id, 'artp', $article_id);

            if ($article_for_resubmission == FALSE) {
                $getforms = Article_types::get_form_onstage('author_submission', $articletype_id);
                !empty($getforms) && $show_generic_tab= TRUE;
            } else {
                $getforms = array();
            }

			    if ($article_advanced_details[0]->atotp_suggest_reviewers == 'n' && $article_advanced_details[0]->atotp_oppose_reviewers == 'n' || ($article_for_resubmission == TRUE && $article_details->art_transfer_status == 'n')) {
				    $return_array['unset_tabreview_preference']=TRUE;
			    }
			    if ($article_for_resubmission == TRUE || $show_generic_tab== FALSE) {
                    $return_array['unset_tabadditional_info']=TRUE;
			    }

                if($article_attachment_status=='n')
                {
                    $return_array['unset_tabattach_files']=TRUE;
                }

                $return_array['unset_tabpayment_info'] = TRUE;//for payment in abstract submission in confrence
                if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y' && $article_payment_status =='y') {
                    $return_array['unset_tabpayment_info'] = FALSE;
                    if(!empty($article_details)) {
                        if ($article_details->art_status == 'y' || json_decode($return_array['tab_status']->tab_status_array)->tab_additional_info == 'p') {
                            $Payment_order = new \App\Models\Payment_order();
                            $art_status =   Article_flow::get_single_record('aflw_status','aflw_art_id  = ?',binding_arr:[$article_id]);
                            $check  =   $Payment_order::get_single_record('count(pmt_ord_id) as cnt','pmt_ord_art_id = ? and pmt_transaction_status = \'fn\'',binding_arr:[$article_id]);
                            if ($check->cnt == 0) {
                                if($art_status->aflw_status=='c'){
                                    $rearray=array(
                                        'tab_article_details'=>'c',
                                        'tab_co_author'=>'c',
                                        'tab_attach_files'=>'c',
                                        'tab_review_preference'=>'c',
                                        'tab_payment_info' =>'c',
                                        'tab_additional_info'=>'p'
                                    );

                                }
                                else{
                                    $rearray=array(
                                        'tab_article_details'=>'c',
                                        'tab_co_author'=>'c',
                                        'tab_attach_files'=>'c',
                                        'tab_review_preference'=>'c',
                                        'tab_payment_info' =>'p',
                                        'tab_additional_info'=>''
                                    );

                                }
                               
                                if(isset($return_array['tab_status']->tab_status_array)){
                                    $return_array['tab_status']->tab_status_array=json_encode($rearray);
                                }
                            }
                        }
                    }
                }

                if(!empty($article_details)) {
                    if(!empty($article_details->art_prev_article_id) && $article_details->art_transfer_article=='n') {
                        $return_array['unset_tabreview_preference']=TRUE;
                        $return_array['unset_tabadditional_info']=TRUE;
                        $rearray=array(
                            'tab_article_details'=>'c',
                            'tab_co_author'=>'c',
                            'tab_attach_files'=>'p',
                            'tab_review_preference'=>'',
                            'tab_additional_info'=>''
                        );
                        if($article_attachment_status=='n') {
                            $rearray['tab_co_author']='p';
                            $rearray['tab_attach_files']='';
                        }
                        if(isset($return_array['tab_status']->tab_status_array)){
                            $return_array['tab_status']->tab_status_array=json_encode($rearray);
                        }

                    }
                    else if($article_details->art_transfer_article == 'y' && $article_details->art_status == 't' && (isset($return_array['tab_status']->tab_status_transfer_bit) && $return_array['tab_status']->tab_status_transfer_bit == 'n')){
                        /* Task #196-10096 Starts */
                        $rearray=array(
                            'tab_article_details' => 'p',
                            'tab_co_author' => '',
                            'tab_attach_files' => '',
                            'tab_review_preference' => '',
                            'tab_payment_info' => '',
                            'tab_additional_info' => ''
                        );
                        if(isset($return_array['tab_status']->tab_status_array)){
                            $return_array['tab_status']->tab_status_array=json_encode($rearray);
                            $return_array['tab_status']->tab_status_transfer_bit = 'y';
                        }
                        Article_tab_status::update_record(array(
                            "tab_status_array" => json_encode($rearray),"tab_status_transfer_bit" => "y"),"tab_status_art_id=?", $this->current_user,binding_arr:[$article_id]);
                        /* Task #196-10096 Ends */
                    }                 
                }
                $check_es_article = $this->check_espermission_access(array('article_id' => $article_id));
                if($check_es_article == true)
                {
                     $pass_array = array();
                     $pass_array['article_id'] = $article_id;
                     $pass_array['artp_id'] = $articletype_id;
                     $pass_array['artp_fwm_id'] = $flow_master_id->artp_fwm_id;
                     $pass_array['jnl_code'] = $post_data['platform_code'];
                     $pass_array['flow_id'] = $article_flow_id;
                     $flow_tbl =  (new \App\Models\Article_flow())->getTable();
                     $genric_tbl = (new \App\Models\Generic_flows())->getTable();
                     $join_tbls =  array(
                         'main_table' => $flow_tbl,
                         'join_table' => array(
                             $genric_tbl => array($genric_tbl . '.jwf_id', $flow_tbl . '.aflw_jwf_id')
                         )
                     );
                     $criteria = 'aflw_id ='.$article_flow_id;
                     $flw_dtls = Article_flow::get_results_using_joins($join_tbls,'jwf_stage_type,aflw_status,jwf_role_id,aflw_usr_id,aflw_stage_min_users', $criteria, 'all');
                     $pass_array['flow_status'] = $flw_dtls[0]->aflw_status;
                     $pass_array['stage_type'] = $flw_dtls[0]->jwf_stage_type;
                     $pass_array['role_id'] = $flw_dtls[0]->jwf_role_id;
                     $type_permissions = Journal_permission::get_single_record_with_bind_cond('jp_edit_article_files',array('jp_jpm_id' => $flow_master_id->artp_jpm_id));
                     $pass_array['jp_edit_article_files'] = $type_permissions->jp_edit_article_files;
                     $pass_array['flow_usr_id'] = $flw_dtls[0]->aflw_usr_id;
                     $pass_array['aflw_stage_min_users'] = $flw_dtls[0]->aflw_stage_min_users;
                     $es_array = $this->get_es_integrations_permissions($pass_array);
                     if(!empty($es_array))
                     {
                        $return_array['es_array'] = $es_array;
                     }
                }    


            $return_array['getforms'] = $getforms;
            return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function save_article_basic_details(Request $request)
    {
        try {
            $post_data = $request->all();
            $return_array = array();
            $this->current_user = $this->get_current_user_details();
            $is_proceeding=$this->check_client_proceeding();

            // Task #3022 Remove ‘abstract’ field’ in article submission page
            $remove_abstract_submission=false;
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
            if(!empty($proceedingArr)) {
                $remove_abstract_submission=isset($proceedingArr['remove_abstract_submission'])?$proceedingArr['remove_abstract_submission']:false;
            }

            if ($remove_abstract_submission == false) {
                $validator = Validator::make($request->all(), [
                    'artp_article_type_id' => 'required',
                    'art_title' => 'required',
                    'art_abstract' => 'required',
                    'platform_code' => 'required',
                ]);
            }
            else {
                $validator = Validator::make($request->all(), [
                    'artp_article_type_id' => 'required',
                    'art_title' => 'required',
                    'platform_code' => 'required',
                ]);
            }

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } else {
                //RV validation
				$keyword_changed = $title_changed = FALSE;
                $input_arr = array(
                    'input' =>$post_data['artp_article_type_id'],
                    'enc_data' => true,
                    'type'=> 'number'
                );
                $ArtTypevalidate = $this->Rv_validator($input_arr);
                $input_arr = array(
                    'input' =>$post_data['platform_code'],
                    'type'=> 'string'
                );
                $platformCodevalidate = $this->Rv_validator($input_arr);
                if($ArtTypevalidate == false || $platformCodevalidate == false) {
                    $arraymsg['message'] = customTrans('viewarticle.invalid_data');
                    $arraymsg['status'] = 'failed';
                    return  $this->success('Success', 200, $arraymsg);
                }
                $art_title = strip_tags($post_data['art_title']);
                $art_title = str_replace(' ', '', $art_title);
                $art_title = str_replace('&nbsp;', '', $art_title);
                $art_title = trim($art_title);
                if(empty($art_title)) {
                    $arraymsg['message'] = customTrans('viewarticle.article_title_required');
                    $arraymsg['status'] = 'failed';
                    return  $this->success('Success', 200, $arraymsg);
                }
                $article_type_id = $this->decrypt_data($post_data['artp_article_type_id']);
                $article_advanced_details = Article_type_advance_options::get_single_record('*', "atotp_artp_id={$article_type_id}");
                $title_length = isset($article_advanced_details->atotp_title_length) ? $article_advanced_details->atotp_title_length:250;
                if (strlen($art_title) > $title_length) { //checking the article title length
                    $arraymsg['message'] = "Maximum characters allowed: $title_length";
                    $arraymsg['status'] = 'failed';
                    return  $this->success('Success', 200, $arraymsg);
                }

                $art_abstract = strip_tags($post_data['art_abstract']);
                $art_abstract = str_replace(' ', '', $art_abstract);
                $art_abstract = str_replace('&nbsp;', '', $art_abstract);
                // Task #3022 Remove ‘abstract’ field’ in article submission page
                if(($remove_abstract_submission == false && empty($art_abstract))) {
                    $arraymsg['message'] = customTrans('viewarticle.article_abstract_required');
                    $arraymsg['status'] = 'failed';
                    return  $this->success('Success', 200, $arraymsg);
                }
                $article_data['article_stub'] = FALSE;
                // $article_type_id = $this->decrypt_data($post_data['artp_article_type_id']);
                $platform_code = $post_data['platform_code'];
                $article_data['title'] = $post_data['art_title'];
                // Task #3022 Remove ‘abstract’ field’ in article submission page
                $abstract = $remove_abstract_submission===false?$post_data['art_abstract']:'';
                // $article_advanced_details = Article_type_advance_options::get_single_record('*', "atotp_artp_id={$article_type_id}"); //  TASK #4943 savebasicdetails sql injection
                // $article_type = Article_types::get_single_record('artp_jnl_id, artp_fwm_id,artp_prefix_article_no,artp_abbr_article_type,artp_article_type', "artp_id={$article_type_id}"); //TASK #4943 savebasicdetails sql injection
                $article_advanced_details = Article_type_advance_options::get_single_record('*', "atotp_artp_id=?",binding_arr:[$article_type_id]); //TASK #4943 savebasicdetails sql injection
                $article_type = Article_types::get_single_record('artp_jnl_id, artp_fwm_id,artp_prefix_article_no,artp_abbr_article_type,artp_article_type,artp_es_document_type', "artp_id=?",binding_arr:[$article_type_id]);  //TASK #4943 savebasicdetails sql injection
                $submit_for_prod = FALSE;
                if(isset($post_data['submit_production']) && $post_data['submit_production'] == TRUE && !isset($post_data['article_id']))
                {
                    $submit_for_prod = TRUE;
                    $manuscript_id = $post_data['manuscript_id'];
                    // $dup_condition = 'art_code = "'.$manuscript_id.'"'; //  TASK #4943 savebasicdetails sql injection
                    // $check_duplicate = Articles::get_single_record('count(art_id) as cnt',$dup_condition); //  TASK #4943 savebasicdetails sql injection
                    $dup_condition = 'art_code = ?'; //  TASK #4943 savebasicdetails sql injection
                    $check_duplicate = Articles::get_single_record('count(art_id) as cnt',$dup_condition,binding_arr:[$manuscript_id]); //  TASK #4943 savebasicdetails sql injection
                    if($check_duplicate->cnt > 0)
                    {
                        $return_array['status'] = 'duplicate';
                        return  $this->success('Success', 200, $return_array);
                    }
                    if($post_data['current_stage'] && count($post_data['current_stage']) > 1)
                    {
                        $flow_masterid = $article_type->artp_fwm_id;
                        $where_parellel_condition = ' WHERE jwf_fwm_id =' . $flow_masterid . ' AND  FIND_array_in_all(\''.implode(',', $post_data['current_stage']) .'\',REPLACE(REPLACE(REPLACE(jwf_child_stages,\'"\',""),"]",""),"[","")) = 1';
                        $parallel_sql='SELECT count(jwf_id) as parellel_count FROM ' . (new \App\Models\Generic_flows())->getTable() .$where_parellel_condition;
                        $parallel_records  =   Articles::get_records_by_raw_query($parallel_sql);
                        if (isset($parallel_records[0]->parellel_count) && ($parallel_records[0]->parellel_count == 0))
                        {
                            $return_array['status'] = 'not_parallel';
                            return  $this->success('Success', 200, $return_array);
                        }
                    }
                }

                /* $journal_meta = $this->Journal_metadata->get_single_record('jm_meta_value', array(
            'jm_journal_code' => $this->journal_code,
            'jm_client_id' => $this->current_client->clnt_id,
            'jm_meta_name' => 'iet_prefix'
        ));
        $iet_prefix = (isset($journal_meta->jm_meta_value) ? $journal_meta->jm_meta_value : 'n');    */
                $iet_prefix = "n";
                $article_data_list = array();

                $article_id = NULL;
                if (isset($post_data['article_id']) && $post_data['article_id'] != '')
                    $article_id = $this->decrypt_data($post_data['article_id']);
                if (isset($post_data['art_flow_id']) && $post_data['art_flow_id'] != '')
                    $art_flow_id = $this->decrypt_data($post_data['art_flow_id']);


                $article_data_list['art_title'] = $article_data['title'];
                $article_data_list['art_abstract'] = $abstract;
                if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y') {
                    if(empty($post_data['abstract_category'])){
                        $arraymsg['message'] = customTrans('viewarticle.abstract_required');
                        $arraymsg['status'] = 'failed';
                        return  $this->success('Success', 200, $arraymsg);
                    }
                    if(!is_numeric($post_data['abstract_category'])){
                        $post_data['abstract_category'] = Abstract_category::insert_record(['absc_category' => $post_data['abstract_category']], $this->current_user);
                    }
                    $article_data_list['art_absc_id'] = $post_data['abstract_category'] ?? null;
                }
                // start -- funding area
                $article_funder_data = array();
                if(isset($post_data['receive_funding'])){
                    if($post_data['receive_funding'] == 'y'){
                        $article_data_list['art_receive_funding'] = $post_data['receive_funding'];
                        $funding_error = 0;
                        if ($post_data['receive_funding'] == 'y'){
                            $funder_name_org = ((array_column($post_data['autodata'],'funder_name')));
                            $grand_no_org = ((array_column($post_data['autodata'],'grand_no')));
                            $funder_name_arr = (array_filter(array_column($post_data['autodata'],'funder_name')));
                            $grand_no_arr = (array_filter(array_column($post_data['autodata'],'grand_no')));
                            if((count($funder_name_org) != count($funder_name_arr)) || (count($grand_no_org) != count($grand_no_arr)) || (count($funder_name_arr) == 0) || (count($grand_no_arr) == 0)){
                                $funding_error = 1;
                            }
                            $funder_details = ((array_column($post_data['autodata'],'info')));
                            $funder_info_check = array();
                            for ($i = 0; $i < count($funder_details); $i++){
                                $funder_info = ($funder_details[$i]);
                                if(!empty($funder_info)){
                                    if ($funder_info != NULL)
                                    {
                                        if (!array_key_exists(trim($funder_info['funder_name'], " "), $funder_info_check))
                                        {
                                            $funder_info_check[trim($funder_info['funder_name'], " ")] = [];
                                        }
                                    }
                                    if (in_array($grand_no_org[$i], $funder_info_check[trim($funder_info['funder_name'], " ")]))
                                    {
                                        $funding_error = 2;
                                    }
                                    else{
                                        $funder_info_check[trim($funder_info['funder_name'], " ")][] = $grand_no_org[$i];
                                        $funder_data = "funder_name= '{$funder_info['funder_name']}' AND funder_unique_id=" . (($funder_info['unique_id'] != '') ? $funder_info['unique_id'] : NULL);
                                        $funder_data_arr = array(
                                            'funder_name' => $funder_info['funder_name'],
                                            'funder_unique_id' => ($funder_info['unique_id'] != '') ? $funder_info['unique_id'] : NULL,
                                        );
                                        $res = Funders::get_single_record_with_bind_cond('*', $funder_data_arr);
                                        // print_r($res);die;
                                        if ($res)
                                        {
                                            $funder_id = $res->funder_id;
                                        }
                                        else
                                        {
                                            $funder_data .= " AND funder_uri = '{$funder_info['uri']}'";
                                            $funder_data_arr['funder_uri'] = $funder_info['uri'];
                                            if ($funder_info['location'] != ''){
                                                $funder_data .= " AND funder_location = '{$funder_info['location']}'";
                                                $funder_data_arr['funder_location'] = $funder_info['location'];
                                            }
                                            $funder_id = Funders::insert_record($funder_data_arr, $this->current_user);
                                        }
                                        $funder_element = array(
                                            'afd_funder_id' => $funder_id,
                                            'afd_grant_number' => trim($grand_no_org[$i]),
                                            'afd_posted_by' => $this->current_user['user_id'],
                                            'afd_posted_date' => date('Y-m-d H:i:s'),
                                            'afd_art_id' => '');
                                        array_push($article_funder_data, $funder_element);
                                    }
                                }
                            }
                        }
                        else
                        {
                            $funding_error = 1;
                        }
                        if ($funding_error == 1)
                        {
                            $return_array['status']  = 'failed';
                            $return_array['message'] = customTrans('viewarticle.funder_info_error');
                            return  $this->success('Success', 200, $return_array);
                        }
                        if ($funding_error == 2)
                        {
                            $return_array['status']  = 'failed';
                            $return_array['message'] = customTrans('viewarticle.funder_validation_error');
                            return  $this->success('Success', 200, $return_array);
                        }
                    }else{
                        if(isset($article_id) && $article_id != ''){
                            // Articles::update_record(array(
                            //     'art_receive_funding' => 'n'
                            // ), "art_id = {$article_id}", $this->current_user); //  TASK #4943 savebasicdetails sql injection
                            Articles::update_record(array(
                                'art_receive_funding' => 'n'
                            ), "art_id = ?", $this->current_user,binding_arr:[$article_id]); //  TASK #4943 savebasicdetails sql injection
                        }
                    }
                }
                // end -- funding area

                if ($this->current_client->modules->mdl_review_for_doc == 'y') {
                    if (isset($article_data['update_last_date']) && !empty($article_data['update_last_date'])) {
                        $article_data_list['art_update_last_date'] = convert_dmy_to_ymd($article_data['update_last_date'], $this->jnl_data->jset_date_format);
                    }
                }
                $stub = '';
                if (isset($article_data['hdn_art_stub'])) {
                    $article_data_list['art_stub'] = 'y';
                    $article_data_list['art_stub_created_by'] = $this->current_user['user_id'];
                    if (isset($article_data['title_view']))
                        $article_data_list['art_title_editable'] = 'y';
                    else
                        $article_data_list['art_title_editable'] = 'n';
                    if (isset($article_data['stub_due_date'])) {
                        $article_data_list['art_stub_duedate'] = convert_dmy_to_ymd($article_data['stub_due_date'], $this->jnl_data->jset_date_format);
                    }
                    if (isset($article_data['notes_to_author'])) {
                        $article_data_list['art_notes_to_author'] = $article_data['notes_to_author'];
                    }

                    $article_data_list['art_submitted_by'] = NULL;
                    $stub = '-stub';
                } else
                    $article_data_list['art_submitted_by'] = $this->current_user['user_id'];

                if(isset($post_data['submit_production']) && $post_data['submit_production'] == TRUE)
                {
                    $article_data_list['art_submitted_by'] = NULL;
                    $article_data_list['art_stage_submission_method'] = $post_data['submissiontype'];
                    $article_data_list['art_submission_date'] = $post_data['submitted_date'];
                    $article_data_list['art_prduction_submission_revised_date'] = ($post_data['revised_date'] !== NULL) ? convert_dmy_to_ymd($post_data['revised_date'],  $this->current_client->settings->cs_date_format) : NULL;
                    $article_data_list['art_prduction_submission_accepted_date'] = ($post_data['accepted_date'] !== NULL) ? convert_dmy_to_ymd($post_data['accepted_date'],  $this->current_client->settings->cs_date_format) : NULL;
                    $article_data_list['art_submitted_current_stage'] = json_encode($post_data['current_stage']);
                }
                //Check Special Issue And Parent Article Id not empty

                if (isset($article_data['parent_article_type']) && !empty($article_data['parent_article_type'])) {
                    $article_data_list['art_special_parent_article_type_id'] = $article_data['parent_article_type'];
                    $article_data_list['art_published_article_type'] = $article_data['parent_article_type'];
                }
                if (isset($post_data['issue']))
                {
                    $article_data_list['art_publication_issue'] = $post_data['issue'];
                }else{
                    $article_data_list['art_publication_issue'] = NULL;
                }

                if ($article_id == NULL || $article_id == "") {

                    $article_data_list['art_article_upload_path'] = '';
                    $article_data_list['art_artp_id'] = $article_type_id;
                    $article_data_list['art_published_article_type'] = $article_type_id;
                    preg_match('/^[a-zA-Z]+/', $article_type->artp_prefix_article_no, $matches);
                    $temp_article_code = $matches[0];
                    if($submit_for_prod == TRUE)
                    {
                    $article_data_list['art_code'] = $post_data['manuscript_id'];
                    }
                    else
                    {
                    $article_data_list['art_code'] = $this->create_article_code($article_type_id, $article_type->artp_prefix_article_no,NULL,$temp_article_code);
                    }

                    // Task #3027 Fetch the articles for article number re-ordering
                    if(isset($this->current_client->functionality->cfty_article_numbering) && $this->current_client->functionality->cfty_article_numbering == 'y'){
                        $article_data_list['art_chapter_order'] = $this->create_article_order($article_type->artp_jnl_id);
                    }

                    $article_code = $article_data_list['art_code'];
                    $doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
                    $doi_details  = Config::get($doi);
                    $article_doi = $this->create_article_doi($article_id, $doi_details, $iet_prefix, $article_code);
                    $article_data_list['art_doi'] = $article_doi['doi'];
                    if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && isset($article_type->artp_es_document_type) && $article_type->artp_es_document_type=='y')
                    {
                        $article_data_list['art_es_document_status'] = 'a';
                    }
                    $article_id = Articles::insert_record($article_data_list, $this->current_user);

                    if (isset($article_data['article_stub']) && $article_data['article_stub'] == FALSE) {
                        $condition = 'jwf_fwm_id =' . $article_type->artp_fwm_id . ' and jwf_stage_type =\'author_submission\'';
                        $journal_user_role = Generic_flows::get_single_record('jwf_role_id', $condition);
                        $assigned_role = $journal_user_role->jwf_role_id;
                        if($submit_for_prod == FALSE)
                        {
                        $condition = "usrj_usr_id={$article_data_list['art_submitted_by']} AND usrj_artp_id={$article_data_list['art_artp_id']} AND usrj_role_id={$assigned_role}";
                        $user_in_artp = User_to_journals::get_single_record('count(usrj_id) as cnt', $condition);

                        if ($user_in_artp->cnt == 0) {
                            $user_in_artp = array(
                                'usrj_jnl_id' => $article_type->artp_jnl_id,
                                'usrj_usr_id' => $article_data_list['art_submitted_by'],
                                'usrj_role_id' => $assigned_role,
                                'usrj_artp_id' => $article_type_id,
                                //'usrj_status' => 'a',
                            );
                            User_to_journals::insert_record($user_in_artp, $this->current_user);
                        }
                    }

                        $move_next_data_array['article_id'] = $article_id;
                        $move_next_data_array['current_user'] = $this->current_user;
                        $move_next_data_array['master_flow_id'] = $article_type->artp_fwm_id;
                        $art_flow_arr = $this->move_next_stage($move_next_data_array);
                        if ($this->current_client->modules->mdl_review_for_doc == 'n' && $submit_for_prod == FALSE)
                            $table_row = $this->save_corr_author($this->current_user['user_id'], $article_id);

                        if (isset($art_flow_arr[0]))
                            $art_flow_id = $art_flow_arr[0];
                    }
                    if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y') {
                    $path = 'uploads/' . $platform_code . '/' . $article_type->artp_abbr_article_type . '/' . $article_id.'/';
                    }
                    else
                    {
                        $path = 'public/uploads/' . $platform_code . '/' . $article_type->artp_abbr_article_type . '/' . $article_id;
                        $this->addDireactory($path);
                    }
                    // $upload_path = $this->journal_code . '/' . $article_type->artp_abbr_article_type . '/' . $article_id;
                    $art_updated_path = $platform_code . '/' . $article_type->artp_abbr_article_type . '/' . $article_id;



             /*
                  if (!Storage::exists($path)) {
                        $response = Storage::makeDirectory($path);
                    }
                    */
                    // Articles::update_record(array(
                    //     'art_article_upload_path' => $art_updated_path
                    // ), "art_id={$article_id}", $this->current_user, '', 'e');
                    // $this->insert_tab_status($article_id); //  TASK #4943 savebasicdetails sql injection
                    Articles::update_record(array(
                        'art_article_upload_path' => $art_updated_path
                    ), "art_id=?", $this->current_user, '', 'e',binding_arr:[$article_id]); //  TASK #4943 savebasicdetails sql injection
                    $this->insert_tab_status($article_id);
                } else {
                        // START TASK #4671 The Generate PDF is not showing when user change the contents in article details tab -in progress//
                        $chk_avl_article = Articles::get_single_record_with_bind_cond('art_title,art_es_document_status,art_abstract,art_artp_id',  array('art_id'=>$article_id));
                        if($chk_avl_article)
                        {
						$title_changed = (trim($chk_avl_article->art_title) != trim($article_data_list['art_title'])) ? TRUE : FALSE;
                        }
                       //END TASK #4671 The Generate PDF is not showing when user change the contents in article details tab -in progress//
                    unset($article_data_list['art_submitted_by']);
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    $esarray['article_id']=$article_id;
                    $checkdata=$this->check_espermission_access($esarray);
                    //if(isset($es_api_data['send_article_data']) && isset($chk_avl_article->art_es_document_status) && $chk_avl_article->art_es_document_status !=='n' && $this->current_client->modules->mdl_es_integration == 'y')
                    if(isset($es_api_data['send_article_data']) && isset($chk_avl_article->art_es_document_status) && $chk_avl_article->art_es_document_status !=='n' && $checkdata==true)
                    {
                        $apiUrl = $es_api_data['send_article_data'];
                        $send_arr = array(
                            'art_id' => $article_id,
                            'art_title' => $chk_avl_article->art_title,
                            'art_abstract' => $chk_avl_article->art_abstract
                        );
                        $article_keywords_table = new \App\Models\Article_keywords();
                        $article_type_table = new \App\Models\Article_types();
                        $art_jnl = $article_type_table::get_single_record_with_bind_cond('artp_jnl_id',array('artp_id' => $chk_avl_article->art_artp_id));
                        $hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;
                        $article_keywords = $article_keywords_table::get_article_keywords($article_id, FALSE, FALSE, $hierachy, $art_jnl->artp_jnl_id);
                        $send_arr['art_keywords'] = [];
                        if(!empty($article_keywords))
                        {
                            $art_kwd_arr = array();
                            foreach($article_keywords as $single_art_keyword)
                            {
                                array_push($art_kwd_arr,$single_art_keyword->kwd_name);
                            }
                            $send_arr['art_keywords'] = $art_kwd_arr;
                        }
                        $send_arr['art_classification'] = [];
                        $condition ="arcls_art_id =:art_id";
                        $Article_classification = new \App\Models\Article_classification();
                        $classification_tbl =  new \App\Models\Classifications();
            
                        $cls_table = (new \App\Models\Classifications())->getTable();
                        $checkBoxData = $Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition,NULL,'',NULL,array('art_id'=>$article_id));
                        if(!empty($checkBoxData->checkData)){
                            $class_id = explode(',', $checkBoxData->checkData);
                            $art_class_arr = array();
                            $term_table = (new \App\Models\Terms())->getTable();
            
                            foreach($class_id as $single_class_id)
                            {
                                $criteria = 'cls_id =' . $single_class_id;
                                $join_tbls =  array(
                                    'main_table' => $cls_table,
                                    'join_table' => array(
                                        $term_table => array($term_table . '.term_id', $cls_table . '.cls_term_id')
                                    )
                                );
                                $cls_dtls = $classification_tbl::get_results_using_joins($join_tbls,'term_name', $criteria, 'all');
                                array_push($art_class_arr,$cls_dtls[0]->term_name);
                            }
                            $send_arr['art_classification'] = $art_class_arr;
                        }
                        $send_arr = http_build_query($send_arr);
                        $response = $this->es_curl_request($apiUrl,$send_arr);
                        $response = json_decode($response);
                    }
                    // $condition = "art_id={$article_id}";
                    // Articles::update_record($article_data_list, $condition, $this->current_user); //  TASK #4943 savebasicdetails sql injection
                    $condition = "art_id=?";
                    Articles::update_record($article_data_list, $condition, $this->current_user,binding_arr:[$article_id]); //  TASK #4943 savebasicdetails sql injection
                }
                if($article_id){
                    /* TASK #4943 savebasicdetails sql injection */
                    // $condition ="ak_art_id ={$article_id}";
                    // $art_keywords = Article_keywords::get_all_records('ak_keyword_id', $condition);
                    // Article_keywords::delete_records($condition, '', $this->current_user);
                    $condition ="ak_art_id =?";
                    $art_keywords = Article_keywords::get_all_records('ak_keyword_id', $condition,binding_arr:[$article_id]);
                    Article_keywords::delete_records($condition, '', $this->current_user,binding_arr:[$article_id]);
                     /* end TASK #4943 savebasicdetails sql injection */
                    $keyword_changed = $this->article_keyword_activity($article_advanced_details, $post_data, $article_id, $art_keywords);
                    //classification save
                    if (isset($post_data['classifications']) && !empty($post_data['classifications'])){
                        $this->saveClassification($article_id,$post_data['classifications']);
                    }
                }
                // START TASK #4671 The Generate PDF is not showing when user change the contents in article details tab -in progress//
                if ($title_changed == TRUE || $keyword_changed == TRUE)
                {
                    $this->change_article_pdf_status($article_id, $this->current_user);
                }
                //END TASK #4671 The Generate PDF is not showing when user change the contents in article details tab -in progress//
                if(isset($post_data['receive_funding']) && ($post_data['receive_funding'] == 'y')){
                    if ($article_id != 0 && count($article_funder_data) > 0){
                        // Article_funder_details::delete_records('afd_art_id =' . $article_id, '', $this->current_user); //  TASK #4943 savebasicdetails sql injection 
                        Article_funder_details::delete_records('afd_art_id =?','', $this->current_user,binding_arr:[$article_id]); //  TASK #4943 savebasicdetails sql injection
                        for ($i = 0; $i < count($article_funder_data); $i++)
                        {
                            $article_funder_data[$i]['afd_art_id'] = $article_id;
                        }
                        Article_funder_details::insert_batch($article_funder_data, $this->current_user);
                        // Articles::update_record(array(
                        //     'art_receive_funding' => 'y'
                        // ), "art_id = {$article_id}", $this->current_user); //  TASK #4943 savebasicdetails sql injection 
                        Articles::update_record(array(
                            'art_receive_funding' => 'y'
                        ), "art_id =?", $this->current_user,binding_arr:[$article_id]); //  TASK #4943 savebasicdetails sql injection 
                    }
                }
//  START TASK #4844 Attached files not displayed when clicking on "Go to view article" button
                //
                $article_tab_status=(new \App\Models\Article_tab_status)->getTable();
                $articles=(new \App\Models\Articles)->getTable();
                // $criteria = "tab_status_art_id='{$article_id}' AND  art_id='{$article_id}' "; //  TASK #4943 savebasicdetails sql injection 
                $criteria = "tab_status_art_id= ? AND  art_id= ?"; //  TASK #4943 savebasicdetails sql injection 
                $select = 'tab_status_array,art_status';
                $tables = array(
                    'main_table' => $article_tab_status,
                    'join_table' => array(
                        $articles => array($article_tab_status . '.tab_status_art_id', $articles . '.art_id', "left")
                    )
                );

                $article_type_details = Articles::get_results_using_joins($tables, $select, $criteria, 'single',binding_arr:[$article_id, $article_id]);
                $get_article_tab_status_arr = json_decode($article_type_details->tab_status_array);

                 if(isset($article_type_details) && ($article_type_details->art_status != 'y') && !empty($get_article_tab_status_arr) && ($get_article_tab_status_arr->tab_additional_info != 'p'))
                {
                // $art_submission_tab=array('tab_article_details'=>'c','tab_co_author'=>'p','tab_attach_files'=>'', 'tab_review_preference'=>'', 'tab_additional_info'=>''   );
                $art_submission_tab=array('tab_article_details'=>'c','tab_co_author'=>'p','tab_attach_files'=>'', 'tab_review_preference'=>'', 'tab_payment_info' =>'','tab_additional_info'=>''   );
                Article_tab_status::update_record(array(
                    "tab_status_array" => json_encode($art_submission_tab)),"tab_status_art_id=?", $this->current_user,binding_arr:[$article_id]); //  TASK #4943 savebasicdetails sql injection 
                }
                // END  TASK #4844 

                $return_array['art_flow_id'] = $art_flow_id;
                $return_array['article_id'] = $article_id;
                return  $this->success('Success', 200, $return_array);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function save_corr_author($user_id, $article_id)
    {

        $return_array = array(
            'status' => 'error'
        );

        if ($user_id != "" && $article_id != "") {

            $cur_user_profile = User::get_single_record(
                'usr_title,usr_first_name,usr_last_name,usr_email, usr_phone_no',
                "usr_id={$user_id}"
            );
            // #4543 Manage author  data listing(normalization)
            $data = array(
                'auth_usr_id' => $user_id,
                'auth_art_id' => $article_id,
                'auth_corr_author' => 'y',
                'auth_confirm_status' => 'y'
            );

            $auth_id = Authors::insert_record($data, $this->current_user);
            if ($auth_id == TRUE) {
                $affiliation_data_arr = array();

                $user_affliation = User_affiliations::get_all_records('*', "usaff_user_id={$user_id}");
                if (count($user_affliation) > 0) {
                    $affiliation_data_arr = $this->copy_user_affliation_to_author($affiliation_data_arr, $user_affliation, $auth_id);
                }

            }
        }
    }
    public function insert_tab_status($article_id)
    {
        $this->current_user = $this->get_current_user_details();
        $tabarray = 'clients.' . $this->current_client->clnt_client_code . '.tabconfig';
        $art_submission_tab_arr = Config::get($tabarray);

        $tab_data['tab_status_art_id'] = $article_id;
        $art_submission = array();
        if(!empty($art_submission_tab_arr))
        {
        foreach ($art_submission_tab_arr as $art_tab_key => $art_tab_val) {

            if ($art_tab_key == "tab_article_details" || $art_tab_key == "tab_co_author") {
                $art_submission["$art_tab_key"] = $art_tab_key == "tab_article_details" ? "c" : "p";
            } else {
                $art_submission["$art_tab_key"] = $art_tab_val;
            }
        }
       }
        $tab_data["tab_status_array"] = json_encode($art_submission);
        Article_tab_status::insert_record($tab_data, $this->current_user);
    }

    public function upload_attachment(Request $request)
    {
        try {
            $Fileuploadtype = new \App\Models\File_upload_type();
            $post_data = $request->all();
            $file=$post_data['file'];
            $filename = $file->getClientOriginalName();
            $post_extension=strtolower($file->getClientOriginalExtension());
            $sql="SELECT GROUP_CONCAT(fut_extension) AS txt_extensions FROM rvw_file_upload_type WHERE fut_extension = '.$post_extension'";
            $allowed_extension=$Fileuploadtype::get_records_by_raw_query($sql);
            if(!empty($allowed_extension[0]->txt_extensions))
            {
            $filenameWithoutExtension['filename'] = pathinfo($filename, PATHINFO_FILENAME);
            if(isset($filenameWithoutExtension['filename']))
            {
                $validator = Validator::make($filenameWithoutExtension , [
                    'filename'      => 'required|regex:/^[a-zA-Z0-9(),_,-^ ]+$/'
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                $pattern = '/\s{2,}/';
                if (preg_match($pattern, $filename)) {
                    return $this->warning('Warnings',200,array('msg' => 'file name contains multiple adjacent spaces'));
                }
            }
            }
            else
            {
                return $this->warning('Warnings',200,'Invalid file extension');
            }
            if(isset($post_data['article_id']))
            {
            $post_data['article_id'] =$this->encrypt_data(Rv_decrypt($post_data['article_id']));
            }
            if(isset($post_data['article_flow_id']))
            {
            $post_data['article_flow_id'] =$this->encrypt_data(Rv_decrypt($post_data['article_flow_id']));
            }
            if(isset($post_data['platform_code']))
            {
            $post_data['platform_code'] =Rv_decrypt($post_data['platform_code']);
            }
            if(isset($post_data['art_type_code']))
            {
            $post_data['art_type_code'] =Rv_decrypt($post_data['art_type_code']);
            }
            $return_array = array();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'article_flow_id' => 'required',
                'art_type_code' => 'required',
               'file' => 'clamav|file',
                'platform_code' => 'required'
            ],[
                'file.clamav' => 'The :attribute contains a virus!',
            ]);
            if ($validator->fails()) {


                return response()->json([
                    'error' => $validator->errors()->first('file'),
                    'file'=>$post_data['file']->getClientOriginalName(),
                    'type'=>'clamav'
                ], 200);


            }
            if ($validator->fails()) {
                return  $this->failure('Failed', 200, $validator->errors());
            }
            $input_arr = array(
                'input' =>$this->decrypt_data($post_data['article_id']),
                'type'=> 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$this->decrypt_data($post_data['article_flow_id']),
                'type'=> 'number'
            );
            $art_flow_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$post_data['art_type_code'],
                'type'=> 'string'
            );
            $type_code_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$post_data['platform_code'],
                'type'=> 'string'
            );
            $platform_code_validate = $this->Rv_validator($input_arr);
            if($art_id_validate == FALSE ||$art_flow_id_validate==FALSE ||$type_code_validate==FALSE ||$platform_code_validate==FALSE)
	       {
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Warnings",200,$arraymsg);
            }

            $platform_code = $post_data['platform_code'];
            $platform_data = $this->platform_basic_settings_data($platform_code);

            $artflow_id = '';
            $journal_id = $platform_data->jnl_id;
            $article_id = $this->decrypt_data($post_data['article_id']);

            $article_flow_id = $this->decrypt_data($post_data['article_flow_id']);
            $art_type_code = $post_data['art_type_code'];
            $platform_data = $this->platform_basic_settings_data($platform_code);
            $platform_id = $platform_data->jnl_id;
            $art_type_code = isset($post_data['art_type_code']) ? $post_data['art_type_code'] : NULL;
            //Code to get article type for attachment section in view article.

            if($art_type_code == NULL || $art_type_code ==  'undefined')
            {
                $select_fields = "artp_id, artp_abbr_article_type";
                $condition = "art_id={$article_id}";
                $Article_types = (new \App\Models\Article_types())->getTable();
                $Articles = (new \App\Models\Articles())->getTable();
                $tables = array(
                    'main_table' => $Articles,
                    'join_table' => array(
                        $Article_types => array($Article_types . '.artp_id', $Articles . '.art_artp_id','left')
                    )
                );
                $result = Articles::get_results_using_joins($tables, $select_fields, $condition, 'single');
                $art_type_code = $result->artp_abbr_article_type;
            }

            $attachment_file = $post_data['file'];
            $artcle_type_data = $this->article_type_settings_data($art_type_code,$platform_id);
            if (!empty($artcle_type_data))
                $art_file_type = implode('|', json_decode($artcle_type_data->atotp_file_type));


            if (isset($article_id) && $article_id != '') {
                $article_data = Articles::get_single_record_with_bind_cond('art_article_upload_path', array('art_id'=>$article_id));

                // start -- append the application id if present in post data to the upload path
                //$section = $this->input->get('sect'); // only for supplementary files
                $section = '';
                $supp_files_path = '';

                $name = $attachment_file->getClientOriginalName();
                //$jnl_code =  $request->jnlcode;
                //	$jnl_id =  $request->jnlid;
                $path = $article_data->art_article_upload_path;
                $uploaded_file_details = $this->upload_file_handler($path, $attachment_file, $name);
                if ($uploaded_file_details['error'] == FALSE) {
                    $article_editable = TRUE;
                    $result_record = $this->db_action_attachments($article_id, $art_type_code, $artcle_type_data->artp_id, $uploaded_file_details, $article_data->art_article_upload_path, $article_editable, $article_flow_id, $platform_code);
                    if(count($result_record['skipped_files']) > 0)
                    {
                        $return_array['skipped_files'] = $result_record['skipped_files'];
                    }
                } else {
                    return  $this->warning('Warning', 200, 'Upload failed');
                }
            }
            return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function db_action_attachments($article_id, $artp_code, $articletype_id, $uploaded_file_details, $article_upload_path, $article_editable, $artflow_id, $platform_code)
    {

        $attch_files = array();
        $zip_types = array(
            'zip',
            'x-zip-compressed'
        );

        $allowd_filetype = Article_type_advance_options::get_single_record('atotp_file_type,atotp_file_description', "atotp_artp_id={$articletype_id}");

        $file_description_data = Required_file_type::get_all_records('*', "rft_artp_id={$articletype_id}");
        $file_description = array();
        $file_description_arr = array();
        if (!empty($file_description_data)) {
            foreach ($file_description_data as $fd) {
                array_push($file_description_arr, $fd->rft_file_desp_id);
            }
            $file_description = implode(',', $file_description_arr);
        }

        $allowd_filetype->description = $file_description;
        if ($allowd_filetype->description != NULL)
            $attach_file_description = Attachment_file_description::get_all_records('*', 'afdec_id IN (' . $allowd_filetype->description . ')', 'afdec_description');
        //$attach_file_description = $this->Attachment_file_description->get_all_records('*', 'afdec_id IN (' . $allowd_filetype->atotp_file_description . ')', 'afdec_description');

        $file_name_arr = explode('.', $uploaded_file_details['name']);

        $file_extension = strtolower(end($file_name_arr));


        $attch_files[] = array(
            'filename' => $uploaded_file_details['name'],
            'filesize' => $uploaded_file_details['size']
        );
        /*		 * * End -  Bug #1955 - JPR-308 Export includes not accepted file types﻿ * */

        //* start -- fetching article attachments*//
        /* $article_attchment = $this->Attachment_files->get_all_records('*', array(
		  'atmnt_art_id' => $article_id
		  )); */
        // To correct ordering
        $article_attchment_order = Attachment_files::get_single_record('max(atmnt_order) as max_order', "atmnt_art_id={$article_id}");
        $order_no = 1;
        $atmnt_designated_to = json_encode(array(
            "p",
            "r"
        ));
        //		$atmnt_designated_to = json_encode(array(
        //			"r"));
        $attch_file_html = '';
        $file_id_arr = array();
        $has_tex_file = FALSE;
        $update_attachment_table_array['attach_file'] = $attch_files;
        $update_attachment_table_array['article_id'] = $article_id;
        $update_attachment_table_array['article_type_id'] = $articletype_id;
        $update_attachment_table_array['allowed_file_type'] = $allowd_filetype;
        $update_attachment_table_array['article_type_code'] = $artp_code;
        $update_attachment_table_array['article_upload_path'] = $article_upload_path;
        $update_attachment_table_array['artflow_id'] = $artflow_id;
        $update_attachment_table_array['article_editable'] = $article_editable;
        $update_attachment_table_array['author_attachment'] = TRUE;
        $update_attachment_table_array['platform_code'] = $platform_code;

        $attch_result = $this->update_to_attachment_table($update_attachment_table_array);
        $file_id_arr = $attch_result['file_id_arr'];
        $has_tex_file = $attch_result['has_tex_file'];
        //$skipped_files = $attch_result['skipped_files'];

        $uploaded_file_details['attch_file_id'] = $file_id_arr;
        $uploaded_file_details['has_tex_file'] = $has_tex_file;
        $uploaded_file_details['view_pdf_link'] = '';
        $uploaded_file_details['skipped_files'] = $attch_result['skipped_files'];;
        //* end -- fetching article attachments*//

        /*	$get_pdf_status = $this->get_article_pdf_status($article_id, TRUE);
		if ($get_pdf_status['status'] == TRUE)
		{
			$pdfStatus = $this->update_article_pdf_status($article_id, 'y');
			$uploaded_file_details['files'][0]->view_pdf_link = $get_pdf_status['view_pdf_link'];
			$uploaded_file_details['files'][0]->ithenticate_link = $get_pdf_status['ithenticate_link'];
		}
		else
		{
			$pdfStatus = $this->update_article_pdf_status($article_id, 'n');
		}*/
        //Attachment_files::trans_complete();
        return $uploaded_file_details;
    }

    public function update_to_attachment_table($update_attachment_table_array)
    {


        $this->current_user = $this->get_current_user_details();
        $attch_files = isset($update_attachment_table_array['attach_file']) ? $update_attachment_table_array['attach_file'] : array();
        $article_id = isset($update_attachment_table_array['article_id']) ? $update_attachment_table_array['article_id'] : NULL;
        $articletype_id = isset($update_attachment_table_array['article_type_id']) ? $update_attachment_table_array['article_type_id'] : NULL;
        $allowd_filetype = isset($update_attachment_table_array['allowed_file_type']) ? $update_attachment_table_array['allowed_file_type'] : NULL;
        $artp_code = isset($update_attachment_table_array['article_type_code']) ? $update_attachment_table_array['article_type_code'] : NULL;
        $article_upload_path = isset($update_attachment_table_array['article_upload_path']) ? $update_attachment_table_array['article_upload_path'] : NULL;
        $artflow_id = isset($update_attachment_table_array['artflow_id']) ? $update_attachment_table_array['artflow_id'] : NULL;
        $article_editable = isset($update_attachment_table_array['article_editable']) ? $update_attachment_table_array['article_editable'] : FALSE;
        $author_attch = isset($update_attachment_table_array['author_attachment']) ? $update_attachment_table_array['author_attachment'] : FALSE;
        $platform_code = isset($update_attachment_table_array['platform_code']) ? $update_attachment_table_array['platform_code'] : NULL;


        $file_id_arr = array();
        $has_tex_file = FALSE;

        // To correct ordering
        $article_attchment_order = Attachment_files::get_single_record('max(atmnt_order) as max_order,count(atmnt_id) as count', "atmnt_art_id={$article_id}");
        $order_no = 1;
        $atmnt_designated_to = json_encode(array(
            "p",
            "r"
        ));
        //		$atmnt_designated_to = json_encode(array(
        //			"r"));
        //check user previlage
        $privillaged_user = $this->has_journal_privilege( $platform_code , $this->current_user['user_id'], $articletype_id);
		$non_author_privileged_user = $this->is_non_author_privileged_user($article_id, $privillaged_user);
		$article_file_editable = $this->check_article_editable($articletype_id, $article_id, $non_author_privileged_user, TRUE,$platform_code);

        $article_file_editable = TRUE;
        if ($article_attchment_order->max_order > 0) {
            $order_no = $article_attchment_order->max_order + 1;
        }
        $skipped_files = array();
        if (!empty($attch_files)) {
            foreach ($attch_files as $ach_file) {

                if ($has_tex_file == FALSE && preg_match('/\.tex$/', $ach_file['filename']) == TRUE) {
                    $has_tex_file = TRUE;
                }
                $attachment_file_name = $ach_file['filename'];
                $file_exist = Attachment_files::get_single_record('count(atmnt_id) as cnt', "atmnt_art_id={$article_id} AND atmnt_file_name='{$attachment_file_name}'");

                //*in zip file upload already uploaded files overwirte.  Avoid duplicate entry in database and avoid duplicate recode in front ent *//
                // if ($file_exist->cnt == 0) {

                    $folder_path = $platform_code . '/' . $artp_code . '/' . $article_id;
                    $data_list = array(
                        'atmnt_art_id' => $article_id,
                        'atmnt_orginal_upload_path' => $folder_path, //Upgrade #2293 Manage review uploads
                        'atmnt_file_name' => $ach_file['filename'],
                        'atmnt_document_size' => $this->file_size_convert_to_kb($ach_file['filesize']),
                        'atmnt_posted_date' => date('Y-m-d H:i:s'),
                        'atmnt_designated_to' => $atmnt_designated_to,
                        'atmnt_label' => '',
                        'atmnt_order' => $order_no,
                        'atmnt_file_uploaded_date' => date('Y-m-d H:i:s')
                    );

                    $order_no++;
                    //					if ($article_editable == FALSE && $artflow_id != '')
                    if (($article_editable == FALSE && $artflow_id != '') || ($author_attch == TRUE && $artflow_id != '')) {
                        $data_list['atmnt_aflw_id'] = $artflow_id;
                    }
                    $file_extension_arr = explode(".", $ach_file['filename']);
                    $file_extension = strtolower(end($file_extension_arr));
                    $fup_data = File_upload_type::get_single_record('fut_id', "fut_name='" . $file_extension . "'");

                    //					$where_condition = "afdec_file_type_id like  '%" . $fup_data->fut_id . "%'and afdec_id IN (" . $allowd_filetype->description . ")";
                    //					$at_where =  '(afdec_id IN (' . $allowd_filetype->description . ') ';
                    //					$def_where = '(afdec_id IN (' . $allowd_filetype->description . ')';

                   if(!empty($fup_data))
                   {
                    if ($file_extension == 'zip') {
                        $at_where = ' afdec_default = "s"';
                        $where_condition = ' afdec_default = "s"';
                        $def_where = 'afdec_default = "s"';
                    } else {
                        $at_where = '';
                        $where_condition = '';
                        $def_where = '';
                        if ($allowd_filetype->description != NULL) {
                            $at_where = '(afdec_id IN (' . $allowd_filetype->description . ') AND afdec_default != "s" AND afdec_apply_stage_type !="p" )';
                            $where_condition = 'FIND_IN_SET(' . $fup_data->fut_id . ',REPLACE(REPLACE(REPLACE(afdec_file_type_id,\'"\',""),"]",""),"[","")) > 0 AND afdec_id IN (' . $allowd_filetype->description . ') AND afdec_default != \'s\' AND afdec_apply_stage_type !=\'p\' ';
                            $def_where = 'afdec_id IN (' . $allowd_filetype->description . ') AND afdec_default = "y" ';
                        }
                    }
                    //					$at_where .= ')';
                    //					$def_where .=  ')';
                    $attach_file_description = Attachment_file_description::get_all_records('*', $at_where, 'afdec_description');

                    //echo '<pre>'; print_r($attach_file_description); die;

                    $descrption = Attachment_file_description::get_all_records('*', $where_condition);

                    $attach_file_default_desc=array();

                    if($def_where!='')
                    $attach_file_default_desc = Attachment_file_description::get_single_record('afdec_id,afdec_viewable_roles', $def_where);


                    $attch_design_roles_insert = FALSE;
                    $adr_role_id = '';
                    if (!empty($descrption)&&count($descrption)>0) {

                        if (count($descrption) > 1) {
                            $data_list['atmnt_label'] = '';
                        } else {

                            $es_array['article_id'] = $article_id;
                            $es_permission = $this->check_espermission_access($es_array);
                            if($es_permission == true)
                            {
                                $Attachment_files_table = (new \App\Models\Attachment_files())->getTable();
                                $Attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
                                $tables = array(
                                    'main_table' => $Attachment_files_table,
                                    'join_table' => array(
                                        $Attachment_file_description_table => array($Attachment_files_table . '.atmnt_label', $Attachment_file_description_table . '.afdec_id')
                                    )
                                );
                                $form_select = 'atmnt_id,atmnt_file_name,atmnt_label';
                                $condition = 'afdec_main_document = "y" AND atmnt_art_id = '.$article_id;
                                $main_document = Attachment_files::get_results_using_joins($tables, $form_select, $condition,'all', "atmnt_order");
                                if($main_document->isNotEmpty() && $descrption[0]->afdec_main_document == 'y')
                                {
                                    $skipped_files[] = $ach_file['filename'];
                                    continue;
                                }
                            }
                            //#2982 The system should automatically sort out all the uploaded files by Main doc, Figures, and then tables In Progress
                            if (isset($this->current_client->functionality->cfty_sort_order_for_author_submission_uploads) && $this->current_client->functionality->cfty_sort_order_for_author_submission_uploads == 'y') {


                                $sort_order = Required_file_type::get_single_record('rft_sort_order', "rft_file_desp_id={$descrption[0]->afdec_id} AND rft_artp_id={$articletype_id}");
                                if (isset($sort_order->rft_sort_order) && $sort_order->rft_sort_order != 0)
                                    $data_list['atmnt_order'] = $sort_order->rft_sort_order;
                            }
                            $data_list['atmnt_label'] = $descrption[0]->afdec_id;
                            $adr_role_id = $descrption[0]->afdec_viewable_roles;
                            $attch_design_roles_insert = TRUE;
                            if($es_permission == true)
                            {
                                $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                                $client_defaults  = Config::get($client_default);
                                $file_contents = '';
                                if($client_defaults['es_integration_transfer_file_from'] == 's3')
                                {

                                    $source_file_path =  $this->upload_folder_path('uploads/'.$folder_path.'/'.str_replace(" ", "+", $ach_file['filename']));
                                    $file_contents = file_get_contents($source_file_path);
                                }
                                else
                                {
                                    $filePath = 'uploads/'.$folder_path.'/'.str_replace(" ", "+", $ach_file['filename']);
                                    $file_contents = Storage::disk('public')->get($filePath);
                                }
                                $upload_file = false;
                                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                                $es_api_data  = Config::get($es_config);
                                $folder_name = $es_api_data['s3_folder_name'];	
                                $upload_file = false;
                                if($client_defaults['es_integration_transfer_file_to'] == 's3')
                                {
                                    $folder_name = $es_api_data['s3_folder_name'];	
                                    $s3FilePath = '/'.$folder_name.'/'.$folder_path.'/'.rawurlencode($ach_file['filename']);
                                    $upload_file  = Storage::disk('s3_es')->put($s3FilePath,$file_contents);
                                }
                                if($upload_file == true)
                                {
                                    $data_list['atmnt_send_to_es'] = 'y';
                                    if($descrption[0]->afdec_main_document == 'y')
                                    {
                                        $update_article = Articles::update_record(array('art_es_document_type' => 'u','art_es_document_status' => 'y'), "art_id = {$article_id}", $this->current_user); 
                                    }
                                }   
                            }
                            /*else if($es_permission == true)
                            {
                                $pass_data = array();
                                $pass_data['folder_path'] = $folder_path;
                                $pass_data['source_file_path'] = $source_file_path;
                                $pass_data['file_name'] = str_replace(" ", "+", $ach_file['filename']);
                                $upload_to_ftp = $this->send_editor_suite_file_to_ftp($pass_data);
                                if(isset($upload_to_ftp['status']) && $upload_to_ftp['status'] == true)
                                {
                                    $data_list['atmnt_send_to_es'] = 'y';
                                }
                            }*/
                            
                            
                        }
                    } elseif ($article_file_editable == TRUE && (!empty($attach_file_default_desc))) {

                        $data_list['atmnt_label'] = $attach_file_default_desc->afdec_id;
                        if(isset($descrption[0]->afdec_viewable_roles))
                        $adr_role_id = $descrption[0]->afdec_viewable_roles;
                        $attch_design_roles_insert = TRUE;
                    }
                    $art_data = Articles::get_single_record_with_bind_cond('art_es_document_status,art_es_document_type',array('art_id' => $article_id));
                   /* if($art_data->art_es_document_status !== 'n' && $art_data->art_es_document_type == NULL)
                    {
                        $update_array = array('art_es_document_type' => 'u');
                        $update_status = Articles::update_record($update_array,"art_id ={$article_id}", $this->current_user);
                    }*/
                    $id = Attachment_files::insert_record($data_list, $this->current_user);

                    //2583 Add all file submission files access to production users
                    if ($attch_design_roles_insert == TRUE && $adr_role_id != '') {
                        $attch_desig_data = array(
                            'adr_atmnt_id' => $id,
                            'adr_role_id' => $adr_role_id,
                            'adr_submitted_type' => 'as',
                        );
                        Attachment_designated_roles::insert_record($attch_desig_data, $this->current_user);
                    }
                    $file_id_arr[] = $id;
                    $data_list['atmnt_id'] = $id;
                    $data_list['jnl_code'] = $platform_code;
                    $data_list['artp_code'] = $artp_code;
                    $data_list['upload_path'] = $article_upload_path;
                    $data_list['attach_file_description'] = $attach_file_description;

                    $data_list['file_des_type'] = $descrption;
                    $article_details = Articles::get_single_record('art_resubmission_no,art_submitted_by,art_status,art_stub', "art_id={$article_id}");
                    /*	$current_stage =Article_flow::get_aticle_statuses($article_id, '', $artflow_id, TRUE);

					if ($article_details->art_submitted_by == $this->current_user['user_id'] && $article_file_editable == TRUE && $article_editable == TRUE && $article_details->art_stub != 'y' && $article_details->art_status == 'n' && (isset($current_stage[0]->jwf_stage_type) && $current_stage[0]->jwf_stage_type == 'resubmission'))
					{
						$article_editable = false;
					}
			*/
                    $article_editable = true;
                    $data_list['file_intended_permission'] = $article_editable;
                // }
            }
        }
        }


        return array(
            'file_id_arr' => $file_id_arr,
            'has_tex_file' => $has_tex_file,
            'skipped_files' => $skipped_files
        );
    }

    public function attachmenttabdatalist(Request $request)
    {
        try {
            $post_data = $request->all();
            if(isset($post_data['jnl_id']))
            $post_data['jnl_id']=Rv_decrypt($post_data['jnl_id']);
            if(isset($post_data['art_flow_id']))
            $post_data['art_flow_id']=Rv_decrypt($post_data['art_flow_id']);
            if(isset($post_data['article_id']))
            $post_data['article_id']=Rv_decrypt($post_data['article_id']);
            if(isset( $post_data['article_type_code']))
            $post_data['article_type_code']=Rv_decrypt($post_data['article_type_code']);
            if(isset( $post_data['role_in_time']))
            $post_data['role_in_time']=Rv_decrypt($post_data['role_in_time']);
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                //'article_type_code' => 'required'

            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' => decrypt_link($post_data['article_id']),
                'type'=> 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['art_flow_id'],
                'type'=> 'number'
            );
            $art_flow_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $request->segment(3),
                'type'=> 'string'
            );
            $jnlcode_validate = $this->Rv_validator($input_arr);
           /* $input_arr = array(
                'input' => $post_data['role_in_time'],
                'type'=> 'string'
            );
            $role_validate = $this->Rv_validator($input_arr);*/
            if($art_id_validate == FALSE||$art_flow_id_validate==FALSE||$jnlcode_validate==FALSE)
	        {
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",200,$arraymsg);
            }
            $array['article_id']=decrypt_link($post_data['article_id']);
            $array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=$post_data['art_flow_id'];
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');

            }
            $platform_code = $request->segment(3);
            $article_id = $this->decrypt_data($post_data['article_id']);
            $jnl_id = $this->decrypt_data($post_data['jnl_id']);
            $article_type_code = isset($post_data['article_type_code']) ? $post_data['article_type_code'] : NULL;
            $role_id = isset($post_data['role_id']) ? Rv_decrypt($post_data['role_id']) : NULL;
            // $role_id = Rv_decrypt($post_data['role_id']);
            $core_role =isset($post_data['core_role'])? Rv_decrypt($post_data['core_role']):NULL;
            $jnl_code = isset($post_data['jnl_code']) ? Rv_decrypt($post_data['jnl_code']) : NULL;
            //Code to get article type for attachment section in view article.
           // if($article_type_code == NULL)
           // {
                $select_fields = "artp_id, artp_abbr_article_type,art_es_document_status,art_es_document_type,artp_fwm_id";
                $condition = "art_id={$article_id}";
                $Article_types = (new \App\Models\Article_types())->getTable();
                $Articles = (new \App\Models\Articles())->getTable();
                $tables = array(
                    'main_table' => $Articles,
                    'join_table' => array(
                        $Article_types => array($Article_types . '.artp_id', $Articles . '.art_artp_id','left')
                    )
                );

                $result = $art_dtls = Articles::get_results_using_joins($tables, $select_fields, $condition, 'single');
                $article_type_code = $result->artp_abbr_article_type;
                $artp_id= $result->artp_id;
                $art_es_doc_status = $result->art_es_document_status;
                $art_es_doc_type = $result->art_es_document_type;
    
          //  }

            $artcle_type_data = $this->article_type_settings_data($article_type_code,NULL,$artp_id);

            $file_description_data = Required_file_type::get_all_records('*', "rft_artp_id={$artcle_type_data->artp_id}");

            $file_description_arr = array();
            $file_description = '';
            if (!empty($file_description_data)) {
                foreach ($file_description_data as $fd) {
                    array_push($file_description_arr, $fd->rft_file_desp_id);
                }
                $file_description = implode(',', $file_description_arr);
            }

            // $allowd_filetype->description = $file_description;

            $excluded_descriptions = array();

            if ($file_description != NULL)
                $attach_file_description = Attachment_file_description::get_all_records('afdec_description,afdec_exclude_file', 'afdec_id IN (' . $file_description . ')', 'afdec_description');

            $description = "";
            $excluded_descriptions = array();
            if (isset($attach_file_description) && empty($attach_file_description)) {
                foreach ($attach_file_description as $val) {
                    if ($val->afdec_exclude_file == "y")
                        $excluded_descriptions[] = $val->afdec_description;
                }
            }
            if (!empty($excluded_descriptions) && count($excluded_descriptions) > 0)
                $description = $this->string_with_comma_separation($excluded_descriptions);


            $form_data = array();
            $esarray['article_id']=$article_id;
            $checkdata = $this->check_espermission_access($esarray);
            $has_es_main_doc_permission = true;
            if($checkdata == true)
            {
                $article_data = (object) [
                    'artp_id' =>$artp_id,
                    'art_id' =>$article_id,
                    'artp_fwm_id'=>$result->artp_fwm_id,
                    'jnl_journal_code'=>$jnl_code,
                    'art_artp_id'=>$artp_id
                ];
                $article_privilages = $this->article_privilages($article_data,NULL,$jnl_code,'all',TRUE);
                $check_arr = array('art_id' => $article_id,'artp_id' => $artp_id,'role_id' => $role_id,'core_role' => $core_role,'article_privillages' => $article_privilages);
                $has_es_main_doc_permission = $this->main_doc_permission($check_arr);
            }
            $return_array['has_es_main_doc_permission'] = $has_es_main_doc_permission;
            $attach_records = $this->get_attachament_list($jnl_id, $artp_id, $article_id);
            $support_docs_record = array();
            $support_docs_remove = array();
            if(isset($attach_records['support_docs_record']) && !empty($attach_records['support_docs_record'])){
                $support_docs_record = $attach_records['support_docs_record'];
            }
            $user_roles = $this->validate_user_journal($platform_code, $this->current_user['user_id'], $artp_id);
            $author = Authors::get_single_record('auth_usr_id','auth_art_id = '.$article_id.' AND auth_usr_id = '.$this->current_user['user_id']);
            if(($support_docs_record && count($support_docs_record) > 0))
            {
                if((!empty($user_roles) && !in_array('journal_admin', $user_roles['assigned_roles'])) && empty($author))
                {
                    for($i = 0; $i < count($support_docs_record); $i++)
                    {
                        $view_permission = FALSE;
                        if(isset($support_docs_record[$i]->file_des_type))
                        {
                            foreach($support_docs_record[$i]->file_des_type as $file_desc_type)
                            {
                                if($file_desc_type->afdec_id == $support_docs_record[$i]->atmnt_label && isset($file_desc_type->afdec_viewable_roles))
                                {
                                  
                                    $viewable_roles = explode(",",$file_desc_type->afdec_viewable_roles);
                                  
                                   if(is_array($viewable_roles))
                                   {
                                       $result = array_intersect($user_roles['role_id'], $viewable_roles);
                                       if(count($result)>0 || $support_docs_record[$i]->atmnt_posted_by == $this->current_user['user_id'])
                                        {
                                            $view_permission = TRUE;
                                        }
                                   }
                                   
                                }
                                else if($file_desc_type->afdec_id == $support_docs_record[$i]->atmnt_label && $file_desc_type->afdec_viewable_roles == NULL)
                                {
                                        $view_permission = TRUE;
                                }
                            }
                            if(isset($support_docs_record[$i]->prev_selected_atmnt_label) && isset($support_docs_record[$i]->prev_selected_atmnt_label->afdec_viewable_roles))
                            {
                                $viewable_roles = explode(",",$support_docs_record[$i]->prev_selected_atmnt_label->afdec_viewable_roles);
                                if(is_array($viewable_roles))
                                {
                                    $result = array_intersect($user_roles['role_id'], $viewable_roles);
                                    if(count($result)>0 || $support_docs_record[$i]->atmnt_posted_by == $this->current_user['user_id'])
                                    {
                                        $view_permission = TRUE;
                                    }
                                }
                            }
                        }
                        else if(isset($support_docs_record[$i]->prev_selected_atmnt_label) && isset($support_docs_record[$i]->prev_selected_atmnt_label->afdec_viewable_roles))
                        {
                            $viewable_roles = explode(",",$support_docs_record[$i]->prev_selected_atmnt_label->afdec_viewable_roles);
                            if(is_array($viewable_roles))
                            {
                                $result = array_intersect($user_roles['role_id'], $viewable_roles);
                                if(count($result)>0 || $support_docs_record[$i]->atmnt_posted_by == $this->current_user['user_id'])
                                {
                                    $view_permission = TRUE;
                                }
                            }
                        }
                        else if(isset($support_docs_record[$i]->prev_selected_atmnt_label) && $support_docs_record[$i]->prev_selected_atmnt_label->afdec_viewable_roles == NULL)
                        {
                                $view_permission = TRUE;
                        }
                        if($support_docs_record[$i]->atmnt_label == 0 && empty($support_docs_record[$i]->prev_selected_atmnt_label))
                        {
                            $view_permission = TRUE;
                        }
                        if($support_docs_record[$i]->atmnt_posted_by == $this->current_user['user_id'])
                        {
                            $view_permission = TRUE;
                        }
                        if($view_permission == FALSE)
                        {
                                $support_docs_remove[] = $i;
                        }
                    }
                    //Code.
                    foreach($support_docs_remove as $index)
                    {
                        unset($support_docs_record[$index]);
                    }
                    if(!is_array($support_docs_record))
                    {
                        $support_docs_record = $support_docs_record->toArray();
                    }
                    $support_docs_record = array_values($support_docs_record);
                }
            }
            $return_array['has_tex_file'] = $this->has_tex_files($support_docs_record);
            $return_array['support_docs'] = $support_docs_record;
            $return_array['org_art_id'] = $attach_records['orgArt_id'];
            $return_array['count_support_docs'] = count($support_docs_record);
            $return_array['article_type_code'] = $article_type_code;
            $return_array['es_main_descriptions'] = isset($attach_records['es_main_descriptions']) ? $attach_records['es_main_descriptions'] : [];
            $return_array['es_main_attachments'] = isset($attach_records['es_main_attachs']) ? $attach_records['es_main_attachs'] :[];
            $return_array['es_doc_delete'] = $attach_records['es_document_delete'];
            $return_array['es_document_created'] = isset($attach_records['es_document_created']) ? $attach_records['es_document_created'] : TRUE;
            $return_array['file_desc_main_doc_type'] = isset($attach_records['file_desc_main_doc_type']) ? $attach_records['file_desc_main_doc_type'] : 0;

            //fetch the client's proceeding config array
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
            $return_array['proceeding_arr'] = $proceedingArr;
            if(isset($post_data['check_custom_form_show']) && $post_data['check_custom_form_show'] == true)
            {
                $is_cust_form_user = false;
                $select_fields = "jwf_stage_type,aflw_status,aflw_usr_id";
                $art_flow_id = Rv_decrypt($post_data['art_flow_id']);
                $condition_art_flow = "aflw_id={$post_data['art_flow_id']}";
                $Article_flow = (new \App\Models\Article_flow())->getTable();
                $Generic_flows = (new \App\Models\Generic_flows())->getTable();
                $tables = array(
                    'main_table' => $Article_flow,
                    'join_table' => array(
                        $Generic_flows => array($Generic_flows . '.jwf_id', $Article_flow . '.aflw_jwf_id')
                    )
                );

                $flow_data = Article_flow::get_results_using_joins($tables, $select_fields, $condition_art_flow, 'single');
                if($art_es_doc_status == 'y' && $flow_data->jwf_stage_type == 'review' && ($flow_data->aflw_status == 'a' || $flow_data->aflw_status == 'c') && $flow_data->aflw_usr_id == $this->current_user['user_id'])
                {
                    $is_cust_form_user = true;
                }
            }
            if(isset($post_data['es_transfer_flag']) && $post_data['es_transfer_flag'] == TRUE && count($return_array['support_docs']) > 0)
            {
                $post_data['jnl_code'] = Rv_decrypt($post_data['jnl_code']);
                $return_array['jnl_code'] = $this->decrypt_data($post_data['jnl_code']);
                $return_array['jnl_id'] =  $this->decrypt_data($post_data['jnl_id']);
                $return_data = array();
                $return_data['main_doc'] = ($art_es_doc_status == 'y' &&  $art_es_doc_type == 'n') ? TRUE : FALSE;
                $return_data['all_desc_found'] = TRUE;
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $es_site_url = $es_api_data['api_url'];
                $return_data['es_url'] = $es_site_url;
                foreach($return_array['support_docs'] as $single_spprt)
                {
                    foreach($single_spprt->file_des_type as $single_docs)
                    {
                       if($single_docs ->afdec_id == $single_spprt->atmnt_label && $single_docs->afdec_main_document == 'y')
                        {
                            $return_data['main_doc'] = TRUE;
                        }
                    }
                    if($single_spprt->atmnt_label == 0)
                    {
                        $return_data['all_desc_found'] = FALSE;            
                    }
                }
                if($return_data['all_desc_found'] == TRUE &&  $return_data['main_doc'] == TRUE)
                {
                    $return_array['article_id'] = $article_id;
                    $return_data['status'] = 'success';
                    $return_data['es_url'] = $es_site_url;
                }
                else
                {
                    $return_data['status'] = FALSE;
                }
                $return_data['is_cust_form_user'] = $is_cust_form_user;
                return  $this->success('Success', 200, $return_data);
            }
            else if(isset($post_data['es_transfer_flag']) && $post_data['es_transfer_flag'] == TRUE && $art_dtls->art_es_document_type == 'n')
            {
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $es_site_url = $es_api_data['api_url'];
                $return_array['es_url'] = $es_site_url;
                $return_array['rv_doc'] = TRUE;
                $return_array['status'] = 'success';
                $return_array['is_cust_form_user'] = $is_cust_form_user;

                return  $this->success('Success', 200, $return_array);
            }
            else
            {
                return  $this->success('Success', 200, $return_array);
            }
        } catch (\Exception $e) {
          
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_attachment_description_values($file_des_type)
    {
        $option = array();
        if (!empty($file_des_type)) {

            foreach ($file_des_type as $fdt) {
                $option['desc_label'] = $fdt->afdec_description;
                $option['desc_id'] = strval($fdt->afdec_id);
            }
        }
        return $option;
    }

    public function upload_generic_files_caption(Request $request)
    {//
        try {
            $return_arr = array();
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'file_id' => 'required',
                'file_caption_id' => 'required',
                //'location' => 'required',

            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' => $this->decrypt_data($post_data['file_id']),
                'type'=> 'number'
            );
            $file_id_validate = $this->Rv_validator($input_arr);

            if($post_data['location']=='artsubmission') {
                $input_arr = array(
                    'input' => $this->decrypt_data($post_data['file_caption_id']),
                    'type'=> 'number'
                );
                $file_caption_id_validate = $this->Rv_validator($input_arr);
            } else {
                $input_arr = array(
                    'input' => $this->decrypt_data($post_data['file_caption_id'])
                );
                $file_caption_id_validate = $this->Rv_validator($input_arr);
            }

            if($file_id_validate == FALSE||$file_caption_id_validate==FALSE)
	          {
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",200,$arraymsg);
            }
            //print_r($post_data); die;
            $file_id = $post_data['file_id'];
            $file_caption = $post_data['file_caption_id'];
            $location_caption =  $post_data['location'];

            $img_updated = FALSE;
            $generate_btn = TRUE;
            //#336 to store file desc old id
            $atmnt_old_label    =    NULL;
            if ($file_caption != '' && $file_id != '') {
                $file_id = $this->decrypt_data($file_id);
                /* if ($location_caption == 'registration')
          {
              $path = 'user/';
              $model = 'User_meta_files';
              $label = 'urgf_label';
              $label_id = 'urgf_id';
              $current_user = NULL;
          }
          */
                if ($location_caption == 'artsubmission') {
                    $path = '';
                    $model = new \App\Models\Attachment_files;
                    //$model = 'Attachment_files';
                    $label = 'atmnt_label';
                    $label_id = 'atmnt_id';
                    $current_user = $this->current_user;
                    $file_caption = $this->decrypt_data($file_caption);
                }
                /* elseif ($location_caption == 'artsupplement')
          {
              $path = '';
              $model = 'Article_supplementary_files';
              $label = 'asup_desc';
              $label_id = 'asup_id';
              $current_user = $this->current_user;
          }*/
          else
          {

              $model = new \App\Models\Generic_form_files;
              $path = 'workflow/';
              $label = 'agf_label';
              $label_id = 'agf_id';
              $current_user = $this->current_user;
              $file_caption = $this->decrypt_data($file_caption);


          }


                $show_review_indend = TRUE;
                $file_designated_arr = '';
                $main_document_status = 'a';
                $update_article = FALSE;
                $convert_doc_in_editor = FALSE;
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                if ($location_caption == 'artsubmission') {
                    $art_attachment = Attachment_files::get_single_record('atmnt_id,atmnt_art_id,atmnt_label,atmnt_designated_to,atmnt_orginal_upload_path,atmnt_file_name,atmnt_send_to_es', "atmnt_id ={$file_id}");
                    $article_type = Articles::get_single_record('art_artp_id,art_article_upload_path,art_resubmission_no,art_es_document_status', "art_id={$art_attachment->atmnt_art_id}");

                    $img_updated = TRUE;
                    $deleted_main_doc = FALSE;
                    $file_desc_data = Attachment_file_description::get_single_record('afdec_exclude_file,afdec_viewable_roles,afdec_main_document', "afdec_id={$file_caption}");
                    $esarray['article_id']=$art_attachment->atmnt_art_id;
                    $checkdata=$this->check_espermission_access($esarray);
                   // if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && !in_array($article_type->art_es_document_status,['n']))
                   if($checkdata==true && !in_array($article_type->art_es_document_status,['n']))
                    {
                        if($file_desc_data->afdec_main_document == 'y')
                        {
                            $convert_doc_in_editor = TRUE;
                        }
                        if($art_attachment->atmnt_label !== 0)
                        {
                            $attchmnt_main_tb = Attachment_file_description::get_single_record('afdec_main_document', "afdec_id={$art_attachment->atmnt_label}");
                            if($attchmnt_main_tb->afdec_main_document == 'y')
                            {
                                
                                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                                $es_api_data  = Config::get($es_config);
                                $query_string = 'article_id='.$art_attachment->atmnt_art_id.'&file_name='.rawurlencode($art_attachment->atmnt_file_name);

                            $apiUrl = $es_api_data['check_active_user'];
                            //$pass_arr = http_build_query($pass_arr);
                            $pass_arr =  array('encryptedData' => Rv_encrypt($query_string));
                            $response = $this->es_curl_request($apiUrl,$pass_arr);
                            $response = json_decode($response);
                            if(isset($response->active_users) && $response->active_users > 0 || $response == null)
                            {
                                $return_arr['status'] = 'active_user';
                                $return_arr['message'] = 'Main document amendment aborted. Active users found in the document';
                                return $this->warning("Failed",201,$return_arr);
                            }
                                $apiUrl = $es_api_data['delete_article_url'];	
                                $current_user = $this->current_user['user_id'];	
                                $pass_data =  array('art_id' => $art_attachment->atmnt_art_id,'user_id' => $current_user);
                                $response_delete = $this->es_curl_request($apiUrl,$pass_data);
                                $response_delete = json_decode($response_delete);
                                if(isset($response_delete->status) && $response_delete->status == 'success')
                                {
                                    if(isset($art_attachment->atmnt_id) && !empty($art_attachment->atmnt_id))
                                    {
                                    $update_attachment = Attachment_files::update_record(array('atmnt_doc_created_in_es' => 'n','atmnt_send_to_es' => 'n'), "atmnt_id = {$art_attachment->atmnt_id}", $this->current_user); 
                                    }
                                }
                                $deleted_main_doc = TRUE;
                            }
                        }
                        $return_arr['convert_doc_in_editor'] = $convert_doc_in_editor;
                        $return_arr['deleted_main_doc'] = $deleted_main_doc;
                        if($file_desc_data->afdec_main_document == 'y')
                        {
                            $update_article = TRUE;
                            $main_document_status = 'y';
                        }
                        if($update_article == FALSE)
                        {
                            $all_art_files = Attachment_files::get_all_records_with_bind_cond('atmnt_id,atmnt_art_id,atmnt_label,atmnt_designated_to',array('atmnt_art_id' => $art_attachment->atmnt_art_id));
                            if(!empty($all_art_files))
                            {
                                foreach($all_art_files as $single_art)
                                {
                                    $attchmnt_main = Attachment_file_description::get_single_record('afdec_main_document', "afdec_id={$single_art->atmnt_label}");
                                    if(!empty($attchmnt_main))
                                    {
                                        if($attchmnt_main->afdec_main_document == 'y' && $single_art->atmnt_id == $file_id)
                                        {
                                            $update_article = TRUE;
                                            $main_document_status = 'a';
                                        }
                                    }
                                }
                            }
                        }
                        $this->current_user = $this->get_current_user_details();
                        $folder_name = $es_api_data['s3_folder_name'];	
                        if($art_attachment->atmnt_send_to_es == 'n')
                        {
                            $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                            $client_defaults  = Config::get($client_default);
                            //if($this->current_client->functionality->cfty_enable_upload_s3_bucket == 'y')
                            //{
                                $attachment_file_name_org = $art_attachment->atmnt_file_name;
                                $attachment_file_path_org = $art_attachment->atmnt_orginal_upload_path;
                                if(strpos($attachment_file_name_org, '/') !== false) {
                                    $parts = explode('/', $attachment_file_name_org);
                                    $total_length = count($parts);
                                    foreach($parts as $part_index => $single_parts)
                                    {
                                        if($part_index + 1 == $total_length)
                                        {
                                            $attachment_file_name_org = $single_parts;
                                        }
                                        else
                                        {
                                            $attachment_file_path_org .= '/'.$single_parts;
                                        }
                                    }
                                }
                                $file_contents = '';
                                if($client_defaults['es_integration_transfer_file_from'] == 's3')
                                {
                                    $source_file_path =  $this->upload_folder_path('uploads/'.$art_attachment->atmnt_orginal_upload_path.'/'.str_replace(" ", "+", $art_attachment->atmnt_file_name));
                                    $file_contents = file_get_contents($source_file_path);
                                }
                                else
                                {
                                    $filePath = 'uploads/'.$art_attachment->atmnt_orginal_upload_path.'/'.str_replace(" ", "+", $art_attachment->atmnt_file_name);
                                    $file_contents = Storage::disk('public')->get($filePath);
                                }
                                $upload_file = false;
                                if($client_defaults['es_integration_transfer_file_to'] == 's3')
                                {
                                    $folder_name = $es_api_data['s3_folder_name'];	
                                    $s3FilePath = '/'.$folder_name.'/'.$attachment_file_path_org.'/'.rawurlencode($attachment_file_name_org);
                                    $upload_file  = Storage::disk('s3_es')->put($s3FilePath,$file_contents);
                                }
                                if($upload_file == true)
                                {
                                    $update_attachment = Attachment_files::update_record(array('atmnt_send_to_es' => 'y'), "atmnt_id = {$art_attachment->atmnt_id}", $this->current_user); 
                                }   
                            // }
                            // else
                            // {
                            //     $pass_data = array();
                            //     $pass_data['folder_path'] = $art_attachment->atmnt_orginal_upload_path;
                            //     $pass_data['source_file_path'] = $source_file_path;
                            //     $pass_data['file_name'] = str_replace(" ", "+", str_replace(" ", "+", $art_attachment->atmnt_file_name));
                            //     $upload_to_ftp = $this->send_editor_suite_file_to_ftp($pass_data);
                            //     if(isset($upload_to_ftp['status']) && $upload_to_ftp['status'] == true)
                            //     {
                            //         $update_attachment = Attachment_files::update_record(array('atmnt_send_to_es' => 'y'), "atmnt_id = {$art_attachment->atmnt_id}", $this->current_user); 
                            //     }
                            // }
                        }
                    }

                    if ($this->current_client->functionality->cfty_show_attachments_for_reveiwers == 'y') {

                        if (isset($file_desc_data->afdec_exclude_file) && $file_desc_data->afdec_exclude_file == 'y') {
                            $show_review_indend = FALSE;
                        }
                    }

                    if ($show_review_indend == FALSE) {
                        $file_designated_arr =  json_encode(array("p"));
                    } else {
                        $file_designated_arr =  json_encode(array("p", "r"));
                    }

                    //#336 if file desc is not zip then copy the curr attachment file desc id
                    if ($art_attachment->atmnt_label != 0)
                        $atmnt_old_label    =    $art_attachment->atmnt_label;
                }
                $update_array = array($label => $file_caption);
                if ($img_updated == true) {
                    $update_array = array($label => $file_caption, 'atmnt_pdf_name' => NULL);
                    //#336 of file desc change the curr(old) file desc id is copied to 'atmnt_old_label'
                    //atmnt_label will contains the new file desc id
                    if ($atmnt_old_label != NULL) {
                        $update_array['atmnt_old_label'] = $atmnt_old_label;
                    }
                }
                if ($file_designated_arr != '') {
                    $update_array['atmnt_designated_to'] = $file_designated_arr;
                }
                //#2982 The system should automatically sort out all the uploaded files by Main doc, Figures, and then tables In Progress
                $auto_sort_order = FALSE;
                if (isset($this->current_client->functionality->cfty_sort_order_for_author_submission_uploads) && $this->current_client->functionality->cfty_sort_order_for_author_submission_uploads == 'y' && isset($update_array['atmnt_label'])) {


                    $condition = "rft_file_desp_id={$update_array['atmnt_label']} AND rft_artp_id={$article_type->art_artp_id}";
                    $sort_order = Required_file_type::get_single_record('rft_sort_order', $condition);
                    //					print_r($sort_order);die;
                    if (isset($sort_order->rft_sort_order) && !empty($sort_order->rft_sort_order) && $sort_order->rft_sort_order != 0) {
                        $auto_sort_order = TRUE;
                        $update_array['atmnt_order'] = $sort_order->rft_sort_order;
                        $return_arr['sort_order'] = $update_array['atmnt_order'];
                    }
                }
                $result = $model::update_record($update_array, "{$label_id}={$file_id}", $this->current_user);
                if($update_article == TRUE)
                {
                    $update_status_data = array();
                    $update_status_data['art_es_document_status'] = $main_document_status;
                    $update_status_data['art_es_document_type'] = $main_document_status == 'y' ? 'u' : NULL;
                    $update_status_cond = array();
                    $update_status_cond['art_id'] =  $art_attachment->atmnt_art_id;
                    $art_update = Articles::update_record($update_status_data,$update_status_cond,$this->current_user);
                }
                // print_r($result);exit;
                // if ($result)
                //{
                    if ($location_caption == 'artsubmission') {

                        //2583 Add all file submission files access to production users
                        Attachment_designated_roles::delete_records("adr_atmnt_id={$file_id}",'',$this->current_user);
                        if (isset($file_desc_data->afdec_viewable_roles) && $file_desc_data->afdec_viewable_roles != '') {
                            $attch_desig_data = array(
                                'adr_atmnt_id' => $file_id,
                                'adr_role_id' => $file_desc_data->afdec_viewable_roles,
                                'adr_submitted_type' => 'as',
                            );
                            Attachment_designated_roles::insert_record($attch_desig_data, $this->current_user);
                        }
                        $condition = "pdf_art_id={$art_attachment->atmnt_art_id} AND pdf_show_status='y'";
                        $get_article_details = Article_pdf::get_all_records('*', $condition);
                        //Get PDF count
                        //305 TASK Exclude covering letters from composite PDF
                        //fetch all attchments of the article in which the document type , excluded from generating pdf
                        $Attachment_files_table = (new \App\Models\Attachment_files())->getTable();
                        $Attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
                        $tables = array(
                            'main_table' => $Attachment_files_table,
                            'join_table' => array(
                                $Attachment_file_description_table => array($Attachment_files_table . '.atmnt_label', $Attachment_file_description_table . '.afdec_id')
                            )
                        );
                    $get_review_status = Attachment_files::get_single_record('count(*) as cnt',"atmnt_art_id={$art_attachment->atmnt_art_id} AND atmnt_designated_to like '%r%'");

                  $pdf_review_cnd="atmnt_art_id={$art_attachment->atmnt_art_id}";
              if ($get_review_status->cnt > 0)
                  $pdf_review_cnd.=" AND 'atmnt_designated_to' like '%r%'";
              $condition = $pdf_review_cnd;
              $condition .=" AND 'afdec_exclude_file'='y'";

              $form_select = 'atmnt_id,atmnt_file_name,atmnt_label';
              $exclude_files = Attachment_files::get_results_using_joins($tables, $form_select, $condition,'all', "atmnt_order");
              $all_review_files = Attachment_files::get_all_records($form_select, $pdf_review_cnd, "atmnt_order");

              $current_description_order = array();
              $excluded_descriptions = array();
              $exclude_order = array();
              $current_order = array();
              $exclude_list = array(
                  'zip');
              $allowd_filetype = Article_type_advance_options::get_single_record('atotp_file_type,atotp_file_description',"atotp_artp_id={$article_type->art_artp_id}");
      $file_description_data = Required_file_type::get_all_records('*',"rft_artp_id={$article_type->art_artp_id}");

      $file_description_arr = array();
      if (!empty($file_description_data))
      {
          foreach ($file_description_data as $fd)
          {
              array_push($file_description_arr, $fd->rft_file_desp_id);
          }
          $file_description = implode(',', $file_description_arr);
      }

      $allowd_filetype->description = $file_description;
              $attach_file_description = Attachment_file_description::get_all_records('afdec_id,afdec_exclude_file', 'afdec_id IN (' . $allowd_filetype->description . ')', 'afdec_id');

                        foreach ($attach_file_description as $val)
              {
                  if ($val->afdec_exclude_file == "y")
                      $excluded_descriptions[] = $val->afdec_id;
              }

              foreach ($exclude_files as $val => $key)
              {
                  $ext = pathinfo($key->atmnt_file_name, PATHINFO_EXTENSION);
                  if (!in_array($ext, $exclude_list))
                  {
                      $exclude_order[] = $key->atmnt_id;
                      $current_description_order[] = $key->atmnt_label;
                  }
              }

              foreach ($all_review_files as $val => $key)
              {
                  if (!in_array($key->atmnt_id, $exclude_order))
                  {
                      $ext = pathinfo($key->atmnt_file_name, PATHINFO_EXTENSION);
                      if (!in_array($ext, $exclude_list))
                      {
                          $current_order[] = $key->atmnt_id;
                      }
                  }
              }
                        if (!empty($get_article_details)) {
                            foreach ($get_article_details as $k => $v) {
                                $generated_order = json_decode($v->pdf_art_attachement_order);
                                if ($generated_order == $current_order) {
                                    if ((in_array($this->decrypt_data($file_id), $generated_order) && in_array($file_caption, $generated_order)) || (!empty($excluded_descriptions && in_array($file_caption, $excluded_descriptions)))) {
                                        $generate_btn = FALSE;
                                    }
                                } else
                                    $generate_btn = TRUE;
                            }
                        }
                    } else {
                        $generate_btn = FALSE;
                    }

                    $return_arr['file_id'] = $file_id;
                    // $return_arr['auto_sort_order'] = $auto_sort_order;
                    $return_arr['show_review_check'] = $show_review_indend;

                    //#352 to generate link for preview pdf,we need old pdf
                    $return_arr['preview_link'] = '';
                    $return_arr['art_data'] = '';
                    /*
              if ($generate_btn == FALSE && isset($art_attachment))
              {
                  $article_pdf_details = $this->Article_pdf->get_single_record('pdf_id', array(
                      'pdf_show_status' => 'y',
                      'pdf_art_id' => $art_attachment->atmnt_art_id), '', 'AND', 'pdf_id desc');

                  $return_arr['preview_link'] = base_url('journal/' . $this->jnl_data->jnl_journal_code . '/view-pdf') . '/' . encrypt_link($art_attachment->atmnt_art_id) . '/' . encrypt_link($article_pdf_details->pdf_id);
                  #352 BUG In article correction it shows "Please upload files in Attach files tab" warning alert while changing the description of the file in attach file tab and click on continue
                  if (isset($art_attachment->atmnt_art_id))
                      $return_arr['art_data'] .= '<input type="hidden" id="hdn_art_id" name="attachment[art_hdn_id]" value="' . encrypt_link($art_attachment->atmnt_art_id) . '">';

                  if (isset($article_type->art_artp_id))
                      $return_arr['art_data'] .= '<input type="hidden" id="hdn_artp_id" name="attachment[hdn_artp_id]" value="' . $article_type->art_artp_id . '">';
              }
*/
                    //  $return_arr['generate'] = $generate_btn;
                    $return_arr['status'] = 'success';
                    $return_arr['img_updated'] = $img_updated;
                    $support_docs_record = array();
                    if(isset($post_data['jnl_id']) && !empty($post_data['jnl_id'])){
                        $jnl_id = Rv_decrypt($post_data['jnl_id']);
                        $input_arr = array(
                            'input' => $jnl_id,
                            'type'=> 'number'
                        );
                        $jnl_id_validate = $this->Rv_validator($input_arr);
                        if ($jnl_id_validate != false){
                            // $support_docs_record = $this->get_attachament_list($jnl_id, $article_type->art_artp_id, $art_attachment->atmnt_art_id);
                            $attach_records = $this->get_attachament_list($jnl_id, $article_type->art_artp_id, $art_attachment->atmnt_art_id);
                            $support_docs_record = array();
                            if(isset($attach_records['support_docs_record']) && !empty($attach_records['support_docs_record'])){
                                $support_docs_record = $attach_records['support_docs_record'];
                            }
                        }
                    }
                    $return_arr['support_docs'] = $support_docs_record;
                    // }
                //}
            }
            return  $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function file_ordering_list(Request $request)
    {
        try {
            $post_data = $request->all();
            if(isset($post_data['metadata']) && $post_data['metadata']=='true') {
                $validator = Validator::make($request->all(), [
                    'ordering_lst' => 'required',
                ]);
            }else{
                $validator = Validator::make($request->all(), [
                    'ordering_lst' => 'required',
                    //'location' => 'required',
                    'art_id' => 'required'
                ]);
            }
            
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $ordering_list = $post_data['ordering_lst'];
            $location_caption = $post_data['location'];

            $article_id = isset($post_data['art_id'])?$this->decrypt_data($post_data['art_id']):'';     
            $this->current_user = $this->get_current_user_details();

            if (count($ordering_list) > 0) {
                /*if ($location_caption == 'registration')
        {
            $path = 'user/';
            $model = 'User_meta_files';
            $label_order = 'urgf_order';
            $label_id = 'urgf_id';
            $current_user = NULL;
        }
        if ($location_caption == 'supp') //article submission supplementary files
        {
            $this->load->model(array(
                'Article_supplementary_files'));
            $path = '';
            $model = 'Article_supplementary_files';
            $label_order = 'asup_order';
            $label_id = 'asup_id';
            $current_user = $this->current_user;
        }*/
                if ($location_caption == 'artsubmission') {

                    $path = '';
                    $model = 'Attachment_files';
                    $label_order = 'atmnt_order';
                    $label_id = 'atmnt_id';
                    $model = new \App\Models\Attachment_files;
                    $art_id = $this->decrypt_data($post_data['art_id']);
                }
                /*  elseif ($location_caption == 'figshare')
        {
            $path = '';
            $model = 'Figshare_docs';
            $label_order = 'figshare_order';
            $label_id = 'figshare_id';
            $current_user = $this->current_user;
            $art_id = decrypt_link($this->input->post('art_id'));
        }*/
        else
        {
            $model = new \App\Models\Generic_form_files;
            $path = 'workflow/';
            $label_order = 'agf_order';
            $label_id = 'agf_id';
            $current_user = $this->current_user;
        }

                //$this->load->model($path . $model);

                $i = 1;
                foreach ($ordering_list as $art_order) {
                    $order = $i;

                    $data = array(
                        $label_order => $i
                    );
                    /*  $update_condition = array(
                $label_id => $art_order,
                $label_order.'!='=> $order

            );*/

                    $update_condition = "{$label_id}={$art_order[$label_id]} AND {$label_order}!={$order}";
                    if(isset($post_data['isDragged'])&&$post_data['isDragged'] == true){
                    $model::update_record($data, $update_condition, $this->current_user);
                    }
                    $i++;
                }
                $return_arr['status'] = 'success';
                $return_arr['msg'] = 'List updated successfully';

                if ($location_caption == 'artsubmission') {
                    $getpdf_status = $this->get_article_pdf_status($article_id, TRUE);
                    $criteria_cond = "art_id ={$article_id}";
                    $last_article_data = Articles::get_single_record('art_pdf_status', $criteria_cond);
                    $preview_link = $ithenticate_link = '';
                    if ($getpdf_status['status'] == TRUE) {
                        $task = 'p'; //check whether generate pdf or preview pdf link to show
                        if($last_article_data->art_pdf_status!='y')
                        $pdfStatus = $this->update_article_pdf_status($article_id, 'y');
                        $preview_link = $getpdf_status['view_pdf_link'];
                        $ithenticate_link = $getpdf_status['ithenticate_link'];
                    } else {
                        $task = 'g';
                        if($last_article_data->art_pdf_status!='n')
                        $pdfStatus = $this->update_article_pdf_status($article_id, 'n');
                    }
                    $pdfStatus = true;
                    
                    $return_arr['preview_link'] = $preview_link;
                    $return_arr['ithenticate_link'] = $ithenticate_link;
                    $return_arr['last_generated_file_order'] = $ordering_list;
                    $return_arr['pdfstatus'] = $pdfStatus;
                    $return_arr['task'] = $task; //preview(p) or generate(g) pdf
                } else if ($location_caption == 'figshare') {
                    $return_arr['last_generated_file_order'] = $ordering_list;
                }
            }
            return  $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function update_article_submission_tab(Request $request)
    {
        try {
            $return_arr = array();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'next_tab_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            // TASK #7033 SQL injection updatesubmissiontab
            $artidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
            $artidvalidation= $this->Rv_validator($artidarray);
            if($artidvalidation != TRUE){
                return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
            }
            // TASK #7033 SQL injection updatesubmissiontab
            $array['article_id']=decrypt_link($post_data['art_id']);
            $array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');

            }
            $this->current_user = $this->get_current_user_details();
            $article_id = $this->decrypt_data($post_data['art_id']);
            $next_tab_id = $post_data['next_tab_id'];
            // $authorList = Authors::get_all_records('auth_id', 'auth_art_id = ' . $article_id);// TASK #4943 updatesubmissiontab sql injection
            $authorList = Authors::get_all_records('auth_id', 'auth_art_id = ?',binding_arr:[$article_id]); // TASK #4943 updatesubmissiontab sql injection
            foreach ($authorList as $eachAuthor) {
                $sel = 'auaff_id';
                $crit = "auaff_auth_id ={$eachAuthor->auth_id} AND auaff_prime_affiliation ='y'";
                $aff = Authors_affiliation::get_single_record($sel, $crit);
                if(empty($aff)){
                    $return_arr['msg'] = customTrans('viewarticle.authr_aff_missing');
                    return $this->warning('Warning', 200,$return_arr,'warning');
                }
            }
            // $get_article_tab_status_arr = Article_tab_status::get_single_record('tab_status_array', "tab_status_art_id={$article_id}");// TASK #4943 updatesubmissiontab sql injection
            $get_article_tab_status_arr = Article_tab_status::get_single_record('tab_status_array', "tab_status_art_id=?",binding_arr:[$article_id]);// TASK #4943 updatesubmissiontab sql injection

            if (isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y') {
                $count_pres = Authors::get_single_record('count(auth_id) as cnt', "auth_art_id= ? AND auth_pres_author ='y'",binding_arr:[$article_id]);
                if ($count_pres->cnt < 1) { // Task #5181 implement presenting author for conference
                    $return_arr['msg'] = customTrans('viewarticle.pres_auth_missing');
                    return $this->warning('Warning', 200,$return_arr,'warning');
                }
            }

            $get_article_tab_status_arr = Article_tab_status::get_single_record('tab_status_array', "tab_status_art_id={$article_id}");
            if(!empty($get_article_tab_status_arr))
            {
            $get_article_tab_status_arr = json_decode($get_article_tab_status_arr->tab_status_array);
            foreach ($get_article_tab_status_arr as $get_article_tab_status_key => $get_article_tab_status_val) {

                if ($next_tab_id == $get_article_tab_status_key) {
                    if ($get_article_tab_status_arr->$get_article_tab_status_key == "")
                        $get_article_tab_status_arr->$get_article_tab_status_key = "p";
                    break;
                }
                $get_article_tab_status_arr->$get_article_tab_status_key = "c";
            }

            // $update_id = Article_tab_status::update_record(array(
            //     "tab_status_array" => json_encode($get_article_tab_status_arr)
            // ), "tab_status_art_id={$article_id}", $this->current_user); // TASK #4943 updatesubmissiontab sql injection
            $update_id = Article_tab_status::update_record(array(
                "tab_status_array" => json_encode($get_article_tab_status_arr)
            ), "tab_status_art_id=? ", $this->current_user,binding_arr:[$article_id]);// TASK #4943 updatesubmissiontab sql injection
          }
            return  $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function init_attachment_data(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();

            $es_integration = false;
            
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'art_flow_id' => 'required'

            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $array['article_id']=decrypt_link($post_data['article_id']);
            $array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');

            }
            $article_id = $this->decrypt_data($post_data['article_id']);
            $flow_id = $this->decrypt_data($post_data['art_flow_id']);
            $role_id = isset($post_data['role_id']) ? $this->decrypt_data($post_data['role_id']) : NULL;
            $article_type_code = isset($post_data['art_type_code']) ? $post_data['art_type_code'] : NULL;
            $art_type_id = '';
            $attach_file_description = [];
            $return_arr[] = [];
            $return_arr['permitted_user'] = FALSE;
            //Code to get article type for attachment section in view article.
            // if($article_type_code == NULL)
            // {
               
                $select_fields = "artp_id, artp_abbr_article_type,art_prev_article_id,art_status";
                // $condition = "art_id={$article_id}"; // TASK #4943 initattachdata sql injection
                $condition = "art_id=?"; // TASK #4943 initattachdata sql injection
                $Article_types = (new \App\Models\Article_types())->getTable();
                $Articles = (new \App\Models\Articles())->getTable();
                $Required_file_tbl = (new \App\Models\Required_file_type())->getTable();
                $Attachment_desc = (new \App\Models\Attachment_file_description())->getTable();
                $Article_flow_model = new \App\Models\Article_flow();
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                $Generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                $Roles_table = (new \App\Models\Roles())->getTable();

                $tables = array(
                    'main_table' => $Articles,
                    'join_table' => array(
                        $Article_types => array($Article_types . '.artp_id', $Articles . '.art_artp_id','left')
                    )
                );
                // $result = Articles::get_results_using_joins($tables, $select_fields, $condition, 'single'); // TASK #4943 initattachdata sql injection
                $result = Articles::get_results_using_joins($tables, $select_fields, $condition, 'single',binding_arr:[$article_id]); // TASK #4943 initattachdata sql injection
                $article_type_code = $result->artp_abbr_article_type;
                $art_type_id = $result->artp_id;
                $revised_article = $result->art_prev_article_id == NULL ? FALSE : TRUE;
                $description_cond = '';
                if($revised_article == TRUE)
                {
                    $description_cond =  'AND afdec_description_type IN(\'b\',\'r\')';
                }
                else
                {
                    $description_cond =  'AND afdec_description_type IN(\'b\',\'o\')';
                }
                $description_cond .= 'AND FIND_IN_SET("r", afdec_apply_stage_type)';
            // }
            $article_type_details = $this->article_type_settings_data($article_type_code,NULL,$art_type_id);

            $get_pdf_status = $this->get_article_pdf_status($article_id, TRUE, $flow_id,NULL,$array['jnl_code']);
            $join_tables = array(
                'main_table' => $Required_file_tbl,
                'join_table' => array(
                    $Attachment_desc => array($Attachment_desc . '.afdec_id',  $Required_file_tbl. '.rft_file_desp_id','left')
                )
            );
            $file_description_data  = Required_file_type::get_results_using_joins($join_tables, $Required_file_tbl.'.*' , "{$Required_file_tbl}.rft_artp_id={$article_type_details->artp_id} {$description_cond}");
            //$file_description_data = Required_file_type::get_all_records('*', "rft_artp_id={$article_type_details->artp_id}");
            $file_description_arr = array();
            $file_description = '';
            $description = "";
            if (!empty($file_description_data)) {
                foreach ($file_description_data as $fd) {
                    array_push($file_description_arr, $fd->rft_file_desp_id);
                }
                $file_description = implode(',', $file_description_arr);
            }
            $required_descrip_arr = $optional_descriptions =$opt_file_desc_arr = $included_required_descrip_arr= array();
            $flag_required_descrip =false;
            if ($file_description != '') {
                // $attach_file_description = Attachment_file_description::get_all_records('afdec_id,afdec_description,afdec_exclude_file,afdec_file_type_id', 'afdec_id IN (' . $file_description . ')', 'afdec_description');
                $fileDescriptionSettings=Config::get('clients.'.$this->current_client->clnt_client_code.'.upload_file_description_settings.file_description');
                $file_type_data = File_upload_type::get_all_records('fut_id,fut_name',NULL,'fut_id');
                $excluded_descriptions = $optional_descriptions = $required_descriptions = $required_descrip_id_arr = array();
                $attach_select = 'afdec_id,afdec_description,afdec_exclude_file,afdec_file_type_id,afdec_default,rft_file_desp_id,rft_req_count,rft_req_fld';
                $esarray['article_id'] = $article_id;
                $esarray['art_type_id']= $art_type_id;
                $checkdata=$this->check_espermission_access($esarray);
                if($checkdata == true)
                {
                    $attach_select .= ',afdec_main_document';
                }
                $main_doc_types = [];
                $main_doc_names = [];
                $attach_file_description = Required_file_type::get_file_description($attach_select, "rft_artp_id={$article_type_details->artp_id} {$description_cond}");
                // print_r($attach_file_description);exit;
                
                // print_r($file_type_data);die;
                foreach ($attach_file_description as $val) {
                    $file_types_array = array();
                    $file_types = '';
                    if($val->afdec_file_type_id != null) {
                        $file_type_ids = json_decode($val->afdec_file_type_id);
                        foreach ($file_type_data as $data)
                        {
                            if(in_array($data->fut_id,$file_type_ids)){
                                $file_types_array[] = $data->fut_name;
                            }
                        }
                        $file_types = implode(", ", $file_types_array);
                    }

                    if($file_types != '')
                    {
                       $file_types = ' ('.$file_types.')';
                    }
                    if ($val->afdec_exclude_file == "y")
                    {
                        $excluded_descriptions[] = $val->afdec_description.$file_types;
                    }
                    if($val->rft_req_fld == 'y' && $fileDescriptionSettings['required_descriptions'] == true){
                        $required_descriptions[] = $val->afdec_description.$file_types;
                        $required_descrip_arr[] = array('afdec_id' => $val->afdec_id,'afdec_description' => $val->afdec_description,'afdec_cnt' =>$val->rft_req_count);
                        if ($val->afdec_exclude_file == "n") {
                            $included_required_descrip_arr[] =array('afdec_id' => $val->afdec_id,'afdec_description' => $val->afdec_description); // Add afdec_id to array if both conditions are true
                            $flag_required_descrip= true;
                                  }
                    }elseif($val->rft_req_fld == 'n' && $fileDescriptionSettings['optional_descriptions'] == true){
                        $optional_descriptions[] = $val->afdec_description.$file_types;
                        $opt_file_desc_arr[] = array('afdec_id' => $val->afdec_id,'afdec_description' => $val->afdec_description,'afdec_cnt' =>$val->rft_req_count);
                    }
                    if(isset($val->afdec_main_document) && $val->afdec_main_document == 'y')
                    {
                        $main_doc_types[] = $val->afdec_description.$file_types;
                        $main_doc_names[] = $val->afdec_description;
                    }
                }
                if (!empty($excluded_descriptions) && count($excluded_descriptions) > 0)
                    $description = $this->string_with_comma_separation($excluded_descriptions);
            }

            $select = "ROUND(sum(`atmnt_document_size`)/1000,2) AS uploadfilesize,count(`atmnt_id`) AS totalfile";
            // $condition = "atmnt_art_id={$article_id}"; // TASK #4943 initattachdata sql injection
            $condition = "atmnt_art_id=?"; // TASK #4943 initattachdata sql injection
            $toalattachmentdetails = Attachment_files::get_single_record($select, $condition,binding_arr:[$article_id]);
            if($role_id != NULL)
            {
                $select ="artp_id,artp_jnl_id,jp_edit_article_files as edit_article_files,artp_article_type as art_type_name,artp_fwm_id";
                $Article_types_table = (new \App\Models\Article_types())->getTable();
                $Journal_permission_table = (new \App\Models\Journal_permission())->getTable();
                $Article_types = new \App\Models\Article_types();
                $jnl_tables = array(
                'main_table' => $Article_types_table,
                'join_table' => array(
                    $Journal_permission_table => array($Journal_permission_table.'.jp_jpm_id', $Article_types_table. '.artp_jpm_id','left')
                ));
                $jnl_criteria = "artp_id={$art_type_id}";
                $art_detail = $Article_types::get_results_using_joins($jnl_tables, $select, $jnl_criteria,'single');
                $return_arr['permitted_user'] = FALSE;
                if($art_detail->edit_article_files != '')
                {
                    $article_attachment_permissions = json_decode($art_detail->edit_article_files);
                    if (in_array($role_id , $article_attachment_permissions))
                    {
                        $return_arr['permitted_user'] = TRUE;

                    }
                }
            }
            $select = "jp_edit_article_files";
            $condition = "artp_id={$art_type_id}";
            $permissions = $this->get_article_type_permission($select, $condition);
            $user_roles = $this->validate_user_journal($post_data['platform_code'], $current_user['user_id'], $art_type_id);
            // $article_data = Articles::get_single_record('art_id,art_es_document_status,art_es_document_type,art_status,art_prev_article_id,art_status,art_artp_id as artp_id', "art_id={$article_id}"); // TASK #4943 initattachdata sql injection
            $article_data = Articles::get_single_record('art_id,art_es_document_status,art_es_document_type,art_status,art_prev_article_id,art_status,art_artp_id as artp_id', "art_id=?",binding_arr:[$article_id]); // TASK #4943 initattachdata sql injection
            $article_data->artp_fwm_id = $art_detail->artp_fwm_id;
            $show_attachemnts = TRUE;
            $article_privilages = $this->article_privilages($article_data,NULL,$post_data['platform_code'],'all');
            if(!empty(json_decode($permissions->jp_edit_article_files)) && count(array_intersect(json_decode($permissions->jp_edit_article_files), $user_roles['role_id'])) > 0 && $article_privilages['author'] == FALSE && $article_privilages['reviewer'] == FALSE)
            {
                $return_arr['permitted_user'] = TRUE;
            }
            $return_arr['totalfileinfo'] = $toalattachmentdetails;
            $return_arr['upload_file_size_config'] = $this->get_uploaded_file_size_config();
            $return_arr['article_type'] = $article_type_details;
            $return_arr['pdf_status'] = $get_pdf_status;
            $return_arr['doc_module'] = $this->current_client->modules->mdl_review_for_doc;
            $return_arr['excluded_descriptions'] = $excluded_descriptions;
            $return_arr['optional_descriptions'] = $optional_descriptions;
            if($checkdata == true)
            {
                $return_arr['main_doc_types'] = $main_doc_types;
                $return_arr['main_doc_names'] = $main_doc_names;
            }
            $return_arr['required_descriptions'] = $required_descriptions;
            $return_arr['file_descriptions'] =  $attach_file_description;
            $return_arr['required_descrip_arr'] = $required_descrip_arr;
            $return_arr['opt_file_desc_arr'] = $opt_file_desc_arr;
            $return_arr['is_author'] = $article_privilages['author'];
            $return_arr['is_custom_form_usr'] = FALSE;
            $return_arr['flag_required_descrip'] =$flag_required_descrip;
            $return_arr['included_required_descrip_arr'] =$included_required_descrip_arr;
            if($article_data->art_es_document_status == 'y' && isset($post_data['role_in_time']) && Rv_decrypt($post_data['role_in_time']) == 'reviewer')
            {
                $get_status_current = Article_flow::get_single_record_with_bind_cond('aflw_status,aflw_usr_id',array('aflw_id' => decrypt_link($post_data['art_flow_id'])));
                if(isset($get_status_current->aflw_status) && ($get_status_current->aflw_status == 'a' || $get_status_current->aflw_status == 'c') && $get_status_current->aflw_usr_id == $current_user['user_id'])
                {
                    $return_arr['is_custom_form_usr'] = TRUE;
                }
            }
            if($article_privilages['author'] == FALSE && $result->art_status == 'n' && $revised_article == FALSE)
            {
                $return_arr['permitted_user'] = FALSE;
            }
           /* $esarray['article_id']=decrypt_link($post_data['article_id']);
            $esarray['art_type_id']=$art_type_id;
            $checkdata=$this->check_espermission_access($esarray);*/
            //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
            $es_writescratch_flag=false;
            if($checkdata==true)
            {
                $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                $eswrite_array   = Config::get($client_default);
                if(isset($eswrite_array['es_write_scratch_hide']))
                {
                    $es_writescratch_flag=$eswrite_array['es_write_scratch_hide'];
                }
                $es_integration = TRUE;
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $return_arr['es_site_url'] = $es_api_data['api_url'];
                // if($article_data->art_es_document_status=='n' && $article_data->art_status=='n')
                // {
                //     $update_status_data_arr = array();
                //     $update_status_data_arr['art_es_document_status'] = 'a';
                //     $update_status_cond = array();
                //     $update_status_cond['art_id'] =  decrypt_link($post_data['article_id']);
                //     Articles::update_record($update_status_data_arr,$update_status_cond,$this->current_user);
                //     $return_arr['es_document_status'] = 'a'; 
                // }else{
                $return_arr['es_document_status'] = $article_data->art_es_document_status;
                //}
                $return_arr['es_doc_type'] = $article_data->art_es_document_type;
                $encryped_article_id = Crypt::encrypt($article_id);
                $return_arr['es_download_link'] = $es_api_data['doc_download_url'];
                $return_arr['art_status'] = $article_data->art_status;
                $flow_id = decrypt_link($post_data['art_flow_id']);
                // $criteria = "aflw_id='{$flow_id}'"; // TASK #4943 initattachdata sql injection
                $criteria = "aflw_id=?";  // TASK #4943 initattachdata sql injection
                $select = 'role_assigned_role,aflw_status,aflw_usr_id,aflw_stage_min_users,jwf_stage_type';
                $tables = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                        $Generic_flow_table => array($Generic_flow_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id'),
                        $Roles_table => array($Roles_table.'.role_id',$Generic_flow_table.'.jwf_role_id')
                    )
                );
                // $get_role = $Article_flow_model::get_results_using_joins($tables, $select, $criteria, '');  // TASK #4943 initattachdata sql injection
                $get_role = $Article_flow_model::get_results_using_joins($tables, $select, $criteria, '',binding_arr:[$flow_id]); // TASK #4943 initattachdata sql injection
                $editor_mode = FALSE;
                if(in_array($get_role[0]->aflw_status,['a','u']) && ($get_role[0]->jwf_stage_type !== 'resubmission' || ($get_role[0]->jwf_stage_type == 'resubmission' && ($article_privilages['author'] == true || $article_privilages['privilaged'] == true))))
                {
                    $editor_mode = TRUE;
                }
                if($get_role[0]->aflw_status == 'w')
                {
                    $criteria = 'aflw_parent_flow_id = '.$flow_id;
                    $parent_count = $Article_flow_model::get_single_record('count(aflw_id) as cnt', $criteria);
                    if($parent_count->cnt < $get_role[0]->aflw_stage_min_users)
                    {
                        $editor_mode = TRUE;
                    } 
                }
                if($article_privilages['author'] == TRUE && $get_role[0]->jwf_stage_type == 'resubmission' && in_array($get_role[0]->aflw_status,['u']))
                {
                    $editor_mode = FALSE;
                }
                $return_arr['editor_mode'] = $editor_mode;
                if(($article_data->art_prev_article_id !== NULL || $article_data->art_status !== 'n') && $return_arr['is_author'] == TRUE && (($get_role[0]->role_assigned_role == 'author' && $get_role[0]->aflw_status == 'c') || ($current_user['user_id'] !== $get_role[0]->aflw_usr_id) ))
                {
                    $show_attachemnts = FALSE;
                }
                if($show_attachemnts==TRUE)
                {
                 if(($article_data->art_prev_article_id !== NULL || $article_data->art_status !== 'n'))  
                 {
                    $show_attachemnts = FALSE; 
                 } 
                }
                if($return_arr['is_author'] == TRUE && $get_role[0]->role_assigned_role == 'author' && $get_role[0]->aflw_status !== 'c')
                {
                    $return_arr['permitted_user'] = TRUE;
                }
                $return_arr['show_attach'] = $return_arr['permitted_user'];
                
                if($article_data->art_es_document_status && $article_data->art_es_document_type == 'n')
                {
                    $platform_data = $this->platform_basic_settings_data($post_data['platform_code']);
                    $date_format = $platform_data->jset_date_format;
                    $es_data = array();
                    $query_string = 'article_id='.$article_id;
                    $encrypted_string = Rv_encrypt($query_string);
                    $pass_data = array('encryptedData' => $encrypted_string);
                    $pass_data = http_build_query($pass_data);
                    $es_config = 'clients.' .$this->current_client->clnt_client_code. '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    $apiUrl = $es_api_data['main_doc_dtls'];
                    $response = $this->es_curl_request($apiUrl,$pass_data);
                    $response = json_decode($response);
                    $es_data = array();
                    $es_data['file_name'] = '';
                    $es_data['file_size'] = '--';
                    $es_data['created_date'] = '';
                    if(isset($response->status) && $response->status == 200)
                    {
                        $es_data['file_name'] = $response->file_name;
                        $es_data['file_size'] = $response->file_size;
                        $created_date = Carbon::parse($response->created_at);
                        $mysqlDateTime = $created_date->toDateTimeString();
                        if($date_format !== '')
                        {
                            $es_data['created_date'] = date($date_format.' H:i:s',strtotime($mysqlDateTime));
                        }
                        else
                        {
                            $es_data['created_date'] = $response->created_at;
                        }
                    }
                    $description_tbl = new \App\Models\Attachment_file_description();
                    $description_tbl_name = (new \App\Models\Attachment_file_description())->getTable();
                    $Required_file_type_tbl = (new \App\Models\Required_file_type())->getTable();
                    $join_tbls = array(
                        'main_table' => $description_tbl_name,
                        'join_table' => array(
                            $Required_file_type_tbl => array($Required_file_type_tbl . '.rft_file_desp_id', $description_tbl_name . '.afdec_id')
                        )
                    );
                    $select_fields_decripin = 'afdec_description';
                    $criteria_check = 'rft_artp_id=' . $art_type_id.' AND afdec_main_document =\'y\'';
                    $get_main_attachment = $description_tbl::get_results_using_joins($join_tbls, $select_fields_decripin, $criteria_check, 'single');
                    $es_data['main_doc_desc'] = isset($get_main_attachment->afdec_description) ? $get_main_attachment->afdec_description : '';
                    $return_arr['es_doc_created_data'] = $es_data;
                }
            }
            $return_arr['es_writescratch'] = $es_writescratch_flag;
            $return_arr['is_es_module'] = $es_integration;
            //fetch the client's proceeding config array
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
            $return_arr['proceeding_arr'] = $proceedingArr;

            return  $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function preview_pdf_data(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = $this->decrypt_data($post_data['art_id']);
            $article_pdf_table = (new \App\Models\Article_pdf)->getTable();
            $article_data = Articles::get_single_record('art_article_upload_path', "art_id={$article_id}");
            $where_cnd = ' `pdf_id` = (select max(`pdf_id`) from ' . $article_pdf_table . ' where `pdf_art_id` = ' . $article_id . '  and `pdf_show_status`= \'y\')';

            /* $get_pdf_details = $this->Article_pdf->get_single_record('pdf_id,pdf_art_attachement_order,pdf_ith_document_id', $where_cnd); */
            $get_pdf_details = Article_pdf::get_single_record('*', $where_cnd);
          
            $filepathfolder=$this->get_upload_data($article_data->art_article_upload_path. '/' . $get_pdf_details->pdf_name);
            $return_arr['view_pdf_link'] = $filepathfolder ;
            return $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function remove_attachment(Request $request)
    {
        try {
            $return_arr = array();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'atmn_id' => 'required',
                'art_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $post_data = $request->all();
            $att_id = $this->decrypt_data($post_data['atmn_id']);
            $art_id = $this->decrypt_data($post_data['art_id']);
            $artp_code = $post_data['artp_code'];
            $platform_code = $post_data['platform_code'];
            if ($att_id != '' && $art_id != '' && $artp_code != '') {


                $exist_record = Attachment_files::get_single_record('*', "atmnt_id={$att_id}");
                if (!empty($exist_record)) {
                    $folder_path = $platform_code . '/' . $artp_code . '/' . $art_id;
                    $es_mode = FALSE;
                    $get_art_data = Articles::get_single_record_with_bind_cond('art_artp_id,art_es_document_status,art_es_document_type,art_status',array('art_id' => $art_id));
                    $esarray['article_id']=$art_id;
                    $checkdata=$this->check_espermission_access($esarray);
                    //if($get_art_data->art_es_document_status !== 'n' && isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                    if($get_art_data->art_es_document_status !== 'n' && $checkdata==true)
                    {
                        $es_mode = TRUE;
                    }
                    $main_document_flag = FALSE;
                    if($es_mode == TRUE && $exist_record->atmnt_send_to_es == 'y')
                    {
                        $attchment_table = (new \App\Models\Attachment_files())->getTable();
                        $description_tbl = (new \App\Models\Attachment_file_description())->getTable();
                        $newtables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id')
                            )
                        );
                        $select_fields_decripin = 'atmnt_file_name,afdec_main_document';
                        $criteriacheck = 'atmnt_art_id=' . $art_id.' AND atmnt_id = '.$att_id.' AND afdec_main_document =\'y\'';
                        $get_main_attachment = Attachment_files::get_results_using_joins($newtables, $select_fields_decripin, $criteriacheck, 'single');
                        if(!empty($get_main_attachment))
                        {
                            $main_document_flag = TRUE;
                            $file_name = rawurlencode($get_main_attachment->atmnt_file_name);
                            $query_string = 'article_id='.$art_id.'&file_name='.$file_name;
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            $apiUrl = $es_api_data['check_active_user'];
                            $pass_arr = array('encryptedData' => Rv_encrypt($query_string));
                            //$pass_arr = http_build_query($pass_arr);
                            $response = $this->es_curl_request($apiUrl,$pass_arr);
                            $response = json_decode($response);
                            if(isset($response->active_users) && $response->active_users > 0)
                            {
                                $return_arr['status'] = 'active_user';
                                $return_arr['message'] = 'Main document amendment aborted. Active users found in the document';
                                return $this->warning("Failed",201,$return_arr);
                            }
                        }
                        if($this->current_client->functionality->cfty_enable_upload_s3_bucket == 'n')
                        {
                            $ftp_connection = $this->connect_to_es();
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            $es_file_path = $es_api_data['ftp_file_path'];
                            $remote_file_path = '/'.$es_file_path.strtoupper($this->current_client->clnt_client_code).'/'.$folder_path.'/'.$exist_record->atmnt_file_name;
                            if(isset($ftp_connection['conn_id']))
                            {
                                $conn_id = $ftp_connection['conn_id'];
                                $remove_file_from_sftp = $this->remove_file_from_remote($conn_id,$remote_file_path);
                            }
                        }
                        else
                        {   
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            $folder_name = $es_api_data['s3_folder_name'];
                            $file_path = '/'.$folder_name.'/'.$folder_path.'/'.$exist_record->atmnt_file_name;
                            $delete_from_s3 = Storage::disk('s3_es')->delete($file_path);
                            if(isset($es_api_data['delete_supplemtary_file']))
                            {
                                $apiUrl = $es_api_data['delete_supplemtary_file'];
                                $data_to_editor = array('Docid' => $att_id,'SupFilename' => $exist_record->atmnt_file_name,'review_article_id' => $art_id);
                                $data_to_editor = http_build_query($data_to_editor);
                                $response = $this->es_curl_request($apiUrl,$data_to_editor);
                                $response = json_decode($response);
                            }
                        }
                    }
                    if($es_mode == TRUE)
                    {
                        $attchment_table = (new \App\Models\Attachment_files())->getTable();
                        $description_tbl = (new \App\Models\Attachment_file_description())->getTable();

                        $tables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id')
                            )
                        );
                        $select_fields = 'afdec_main_document';
                        $criteria = 'atmnt_art_id=' . $art_id.' AND atmnt_id != '.$att_id.' AND afdec_main_document =\'y\'';
                        $get_all_attach_details = Attachment_files::get_results_using_joins($tables, $select_fields, $criteria, 'all');
                        if(count($get_all_attach_details) == 0 && $get_art_data->art_es_document_type == 'u')
                        {
                            $update_arr = array('art_es_document_status' => 'a','art_es_document_type' => NULL);
                            $update_record = Articles::update_record($update_arr,array('art_id' => $art_id),$this->current_user);
                        }
                    }
                    //check manage review upload
                    //ecking delete document is main document
                    if($es_mode == TRUE)
                    {
                        if($main_document_flag == TRUE)
                        {
                            $esarray['article_id']=$art_id;
                            $checkdata=$this->check_espermission_access($esarray);
                            //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                            if($checkdata==true)
                            {
                                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                                $es_api_data  = Config::get($es_config);
                                $apiUrl = $es_api_data['delete_article_url'];	
                                $current_user = $this->current_user['user_id'];
                                $data_send = array('art_id' => $art_id,'user_id' => $current_user);
                                $response = $this->es_curl_request($apiUrl,$data_send);	
                                $response = json_decode($response);
                                if(isset($response->status) && $response->status == 'success' && $get_art_data->art_status == 'n')
                                {
                                    $update_data = array('art_es_document_status' => 'a','art_es_document_type' => NULL);
                                    $condition = array('art_id' => $art_id);
                                    $this->current_user = $this->get_current_user_details();
                                    $update_record = Articles::update_record($update_data, "art_id = ?", $this->current_user,binding_arr:[$art_id]);
                                    $return_arr['main_doc'] = TRUE;
                                    $return_arr['rvrite_msg'] = customTrans('viewarticle.main_doc_deleted');
                                }
                            }
                        }
                    }
                    //Upgrade #2293 Manage review uploads
                    $exist_another_record = Attachment_files::get_single_record('count(atmnt_id) as cnt', "atmnt_file_name='{$exist_record->atmnt_file_name}' AND atmnt_orginal_upload_path='{$folder_path}'");


                    $result = Attachment_files::delete_records("atmnt_id={$att_id}", '', $this->current_user);
                    
                    if ($result) {

                        // Task #925 if any authr has removed from the article, run the rvri report
                        if(isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
                        {
                            $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type', 'atotp_artp_id=' . $get_art_data->art_artp_id); 
                            if($article_type_options->atotp_research_integrity == 'y' && $get_art_data->art_status == 'y'){
                                $rvri_art_rec   =   Research_integrity_reports::get_single_record('*', 'rri_art_id=' .$art_id.' and rri_atmnt_id='.$att_id);
                                if(!empty($rvri_art_rec))
                                {
                                    // Research_integrity_reports::delete_records("rri_art_id={$art_id} and rri_atmnt_id={$att_id}", '', $this->current_user);
                                    if($article_type_options->atotp_rvrisubmission_type == 'auto')
                                        $this->generateresearchintegrity($art_id, $rvri_art_rec->rri_aflw_id);
                                    else {
                                        $data_rri   =   array();
                                        $data_rri['rri_new_report'] = 'n';
                                        Research_integrity_reports::update_record($data_rri, 'rri_art_id=' .$art_id.' and rri_atmnt_id='.$att_id, $this->current_user);
                                    }
                                }
                            }
                        }

                        $file_path = public_path() . '/storage/uploads/' . $folder_path . "/";
                        //   $file_path = APP_DOC_PATH . $folder_path . '/';
                        $remaining_tex_attachement = Attachment_files::get_single_record('count(atmnt_id) as count', 'atmnt_file_name LIKE "%\.tex" AND atmnt_id = ' . $att_id);

                        //Upgrade #2293 Manage review uploads
                        $aws_path="uploads/" . $folder_path . "/";

                        if ($exist_another_record->cnt == 1) {
                            $this->remove_fileinfolder($file_path,$exist_record->atmnt_file_name,$aws_path);
                            if ($exist_record->atmnt_pdf_name != NULL)
                            $this->remove_fileinfolder($file_path,$exist_record->atmnt_pdf_name,$aws_path);
                            /*unlink($file_path . $exist_record->atmnt_file_name);

                            if ($exist_record->atmnt_pdf_name != NULL && file_exists($file_path . $exist_record->atmnt_pdf_name)) //also remove pdf of attached file
                                unlink($file_path . $exist_record->atmnt_pdf_name);*/
                        }
                        $getpdf_status = $this->get_article_pdf_status($art_id, TRUE);
                        if ($getpdf_status['status'] == FALSE)
                            $temp_status = 'n';
                        else {
                            $temp_status = 'y';
                            $return_arr['view_pdf_link'] = $getpdf_status['view_pdf_link'];
                            $return_arr['ithenticate_link'] = $getpdf_status['ithenticate_link'];
                        }
                        $pdfStatus = $this->update_article_pdf_status($art_id, $temp_status);
                        //$return_arr['pdfstatus'] = $pdfStatus;
                        $return_arr['pdfstatus'] = $temp_status;
                        $return_arr['has_tex_file'] = $remaining_tex_attachement->count > 0 ? TRUE : FALSE;
                        $return_arr['status'] = 'success';
                    }
                }
            }

            return $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function check_final_submission(Request $request)
    {
       try {
            $msg = array();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'jnl_code'=>'required',
                'aflw_id'=>'required',
                'jnl_id'=>'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            // $authorList = Authors::get_all_records('auth_id', 'auth_art_id = ' . $this->decrypt_data($post_data['art_id']));
            $authorList = Authors::get_all_records('auth_id', 'auth_art_id = ?',binding_arr:[$this->decrypt_data($post_data['art_id'])]);
             $priority = '';
             $return_arr['priority'] ='';
            foreach ($authorList as $eachAuthor) {
                $sel = 'auaff_id';
                $crit = "auaff_auth_id ={$eachAuthor->auth_id} AND auaff_prime_affiliation ='y'";
                $aff = Authors_affiliation::get_single_record($sel, $crit);
                $priority_ref = 2; //2nd tab
                $return_arr['priority'] = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                if(empty($aff)){
                    $return_arr['msg'] = customTrans('viewarticle.authr_aff_missing');
                    return $this->warning('Warning', 200,$return_arr,'warning');
                }
            }
            
            $array['article_id']=decrypt_link($post_data['art_id']);
            $array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=decrypt_link($post_data['aflw_id']);
            $array['url']=$request->segment(4);

            $user_access=$this->check_permission_access_user($array);
  
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');

            }
            DB::beginTransaction();
            $return = "norecords";

            $this->current_user = $this->get_current_user_details();
            $userId = $this->current_user['user_id'];
            $article_id = $this->decrypt_data($post_data['art_id']);
            $jnl_code = $post_data['jnl_code'];
            $current_status_id = $this->decrypt_data($post_data['aflw_id']);


            $jnl_id = $post_data['jnl_id'];
            $bulk_submission = isset($post_data['bulksubmission']) ? $post_data['bulksubmission'] : '';
            $submission_from =  isset($post_data['submission_from']) ? $post_data['submission_from'] : '';
            $submit_prod = (isset($post_data['submit_for_production']) && $post_data['submit_for_production'] == TRUE) ? TRUE : FALSE;
            $article_for_resubmission = FALSE;
            $edit_article = FALSE;
            $preview_pdf_status = TRUE;
            $confirm_author_status = FALSE;
            $article_transfer_status = FALSE;
            $article_transfer_flag = FALSE;
            $priority = "";
            $identical_attachment_order = TRUE;
            $validate_forms = TRUE;
            $return_data['custom_form_complete'] = FALSE;
            $return_data['gotoview_article'] = FALSE;
            $return_data['article_payment_status']   =   'n';//checking payment is completed or not
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {
                $tables = [
                    'main_table' => (new Article_flow())->getTable(),
                    'join_table' => [(new Generic_flows())->getTable() => ['jwf_id','aflw_jwf_id']]
                ];
                $enable_payment = Article_flow::get_results_using_joins($tables,'jwf_enable_payment','aflw_id = ?','single',binding_arr:[$current_status_id]);
                if ($enable_payment->jwf_enable_payment == 'y') {
                    $payment_order  =   new \App\Models\Payment_order();
                    $pmnt_slct  =   "CASE WHEN COUNT(pmt_ord_id)>0 THEN 'y' ELSE 'n' END AS payment_status";
                    $pmnt_cnd   =   "pmt_ord_art_id = ? AND pmt_ord_aflw_id = ?";
                    $return_data['article_payment_status']  =   $payment_order::get_single_record($pmnt_slct,$pmnt_cnd,binding_arr:[$article_id,$current_status_id])->payment_status;
                }
            }
            $core_role = isset($post_data['core_role']) ? $post_data['core_role']: '';
			$role_name = isset($post_data['role_name']) ? $post_data['role_name']: '';
			$role_id = isset($post_data['role_id']) ? $post_data['role_id']: '';
            $get_article_rec = Articles::get_single_record('art_id,art_transfer_status,art_artp_id,art_status,art_transfer_article,art_prev_article_id,art_publication_issue,art_abstract,art_stub,art_submitted_current_stage,art_submitted_by,art_stage_submission_method,art_es_document_status,art_es_document_type,art_biorxiv', "art_id= ?",binding_arr:[$article_id]);  
               
            if (!empty($get_article_rec)) {
                $art_type_id = $get_article_rec->art_artp_id;
                if ($this->check_article_editable($art_type_id, $article_id, NULL, NULL, $jnl_code)) {
                    $edit_article = TRUE;
                }
                $cur_art_type_record = Article_types::get_single_record('artp_id, artp_jnl_id, artp_fwm_id,artp_abbr_article_type,artp_special_issue,artp_soft_enddate,artp_hard_enddate,artp_prefix_article_no', 'artp_id=' . $art_type_id);
                $flow_master_id = $cur_art_type_record->artp_fwm_id;
                $error_status=$this->checkArticletypeError($flow_master_id);
                if ($current_status_id != NULL) {
                    if($error_status==true){
                        $return_data['message']=customTrans('viewarticle.invalid_workflow');
                        return  $this->warning('Warning', 200, $return_data,'warning');
                    }

                    $validate_forms = $this->validate_stage_forms($current_status_id, $jnl_id, $jnl_code);
                    $form_select = 'jwf_stage_type,jwf_temporary_status_name,jwf_stage_name';
                    $article_flowtable = (new \App\Models\Article_flow())->getTable();
                    $generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                    $tables = array(
                        'main_table' => $article_flowtable,
                        'join_table' => array(
                            $generic_flows_table => array($generic_flows_table . '.jwf_id', $article_flowtable . '.aflw_jwf_id')
                        )
                    );

                    // $sub_cnd = "aflw_art_id={$article_id} and aflw_id={$current_status_id}";
                    // $get_gotoview = Article_flow::get_results_using_joins($tables,$form_select, $sub_cnd,'');
                    $sub_cnd = "aflw_art_id= ? and aflw_id= ?";
                    $get_gotoview = Article_flow::get_results_using_joins($tables,$form_select, $sub_cnd,'',binding_arr:[$article_id,$current_status_id]);
                    $author_stages = array('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright', 'author_submission','proof_reading','pro_revision','decision_revision');
                    if(!empty($get_gotoview)){
                        $get_gotoview=$get_gotoview[0];
                        if(($get_gotoview->jwf_stage_type!='author_submission') || ($get_gotoview->jwf_stage_type=='author_submission' && $get_article_rec->art_status=='y')){
                            $authors = Authors::get_all_records_with_bind_cond('GROUP_CONCAT(auth_usr_id) AS usr_id',['auth_art_id' => $article_id])->toArray();
                            $authorArr = (isset($authors[0]) && $authors[0]->usr_id)?explode(',',$authors[0]->usr_id):[];
                            if(in_array($get_gotoview->jwf_stage_type,$author_stages) && in_array($userId,$authorArr)){
                                $return_data['gotoview_article'] = 'author-article';
                            } else {
                                $return_data['gotoview_article'] = 'view-article';
                            }
                        }
                    }

                }
                /* Expire Article Manage in Article Submission Area  */
                $get_article_rec->jnl_code = $jnl_code;
                $issue_manage = $this->manage_issue($cur_art_type_record, $priority, $get_article_rec);

                if (!empty($issue_manage)) {
                    $return_data['message']=$issue_manage['msg'];
                    $return_data['priority']=$issue_manage['priority'];
                    return  $this->warning('Warning', 200, $return_data,'warning');
                }
                if ($get_article_rec->art_status == 't' || $get_article_rec->art_transfer_article == 'y') {
                    $article_transfer_flag = TRUE;
                }
            }
            //TASK #6000 - Prevent authors to changing the authorship on revised papers - Start
            $return_data['prevent_edit_author_list'] = false;
            $form_select = 'jwf_prevent_edit';
            $article_flowtable = (new \App\Models\Article_flow())->getTable();
            $generic_flows_table = (new \App\Models\Generic_flows())->getTable();
            $tables = array(
                'main_table' => $article_flowtable,
                'join_table' => array(
                    $generic_flows_table => array($generic_flows_table . '.jwf_id', $article_flowtable . '.aflw_jwf_id')
                )
            );
            // $sub_cnd = "aflw_id={$array['current_flow_id']}";
            $sub_cnd = "aflw_id= ?";
            $get_flow_details = Article_flow::get_results_using_joins($tables,$form_select, $sub_cnd,'single',binding_arr:[$array['current_flow_id']]);
            //check if there are any pending request for this article under this user.
            //$request_exist = Article_custom_reasons::get_single_record('cusr_id', 'cusr_art_id=' . $article_id . " AND cusr_aflw_id={$array['current_flow_id']}" . " AND cusr_status= 'a'");
            $custom_reason_data = Article_custom_reasons::get_single_record_with_bind_cond('cusr_id,cusr_status,cusr_status_change_reason', ['cusr_art_id' => $article_id,'cusr_aflw_id' => $array['current_flow_id']],NULL,NULL,NULL,NULL,'cusr_id DESC');
            if(($get_article_rec->art_submitted_by == $this->current_user['user_id']) && $get_flow_details->jwf_prevent_edit == 'y'){
               $return_data['prevent_edit_author_list'] = true;
               $return_data['pending_request_edit_author_list'] = 0;
            }
            // if(isset($request_exist->cusr_id) && !empty($request_exist->cusr_id)){
            //    $return_data['prevent_edit_author_list'] = false;
            // }
            if(isset($custom_reason_data->cusr_status) && $custom_reason_data->cusr_status == 'a'){
                $return_data['prevent_edit_author_list'] = false;
             }
            if(isset($custom_reason_data->cusr_status) && in_array($custom_reason_data->cusr_status,['p','r'])){
                $return_data['pending_request_edit_author_list'] = ($custom_reason_data->cusr_status=='p')? 1:2;
                $return_data['pending_request_edit_status_comment'] = ($custom_reason_data->cusr_status=='r')? $custom_reason_data->cusr_status_change_reason:"You have already requested for authorization";
            }
            //TASK #6000 - Prevent authors to changing the authorship on revised papers - End

            if ($this->current_client->functionality->cfty_j2b_along_with_submission == 'y' && $get_article_rec->art_biorxiv != 'y') {

                $Article_biorxiv_export = new \App\Models\Article_biorxiv_export();
                // $biorxiv_records = $Article_biorxiv_export::get_single_record('bexp_id', 'bexp_art_id=' . $article_id);
                $biorxiv_records = $Article_biorxiv_export::get_single_record('bexp_id', 'bexp_art_id= ?',binding_arr:[$article_id]);
                if (empty($biorxiv_records))
                    $validate_forms = FALSE;
            }
            if ($validate_forms == TRUE || $submit_prod == TRUE) {
                $return_data['custom_form_complete'] = TRUE;
                if($submit_prod == TRUE)
                {
                    $validate_forms = TRUE;
                }
            }
            //die($validate_forms);
            $identical_attachment_order = $this->get_article_pdf_status($article_id);
            //305 TASK Exclude covering letters from composite PDF
            //fetch all attchments of the article in which the document type is not excluded from generating pdf
            $form_select = 'count(*) as cnt';
            $attachmenttable = (new \App\Models\Attachment_files())->getTable();
            $attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
            $tables = array(
                'main_table' => $attachmenttable,
                'join_table' => array(
                    $attachment_file_description_table => array($attachment_file_description_table . '.afdec_id', $attachmenttable . '.atmnt_label')
                )
            );
            // $pdf_review_cnd = 'atmnt_art_id=' . $article_id;
            $pdf_review_cnd = 'atmnt_art_id= ? ';
            // $get_article_upload_files = Attachment_files::get_single_record($form_select, $pdf_review_cnd);
            $get_article_upload_files = Attachment_files::get_single_record($form_select, $pdf_review_cnd,binding_arr:[$article_id]);

            $manage_orcid = $this->manage_orcid($article_id, $priority);
            if (!empty($manage_orcid)) {
                $confirm = $manage_orcid['confirm'];
                if (!$confirm) {
                    $msg[] = $manage_orcid['message'];
                    $return_data['message']= $msg;
                return  $this->warning('Warning', 200, $return_data,'warning');
                }
            }

            $get_article_advance_options = Article_type_advance_options::get_single_record('atotp_article_submission_type,atotp_co_authors_agreement', " atotp_artp_id = {$art_type_id}");
            if ($get_article_advance_options != NULL) {
                if (!in_array('fu', json_decode($get_article_advance_options->atotp_article_submission_type)) && !in_array('re', json_decode($get_article_advance_options->atotp_article_submission_type))) {
                    $priority_ref = 1; //1st tab
                    $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $msg[] = customTrans('viewarticle.article_submission_type');
                    $return = 'norecords';
                }
            }
            // START TASK #3263 User can be able to continue from attach file page without generate pdf in article submission
            $articletype_id = $get_article_rec->art_artp_id;
            $flow_master_id = Article_types::get_single_record('artp_fwm_id', "artp_id={$articletype_id}");
            $stage = Generic_flows::get_single_record('jwf_article_attachment_status', "jwf_stage_type='author_submission' AND jwf_fwm_id={$flow_master_id->artp_fwm_id}");
            $article_attachment_status=$stage->jwf_article_attachment_status;
            $val_attach_files = TRUE;
            $val_attach_file_additional_info = TRUE;
            $es_mode = FALSE;
            $es_new_doc = FALSE;
            $esarray['article_id']=$article_id;
            $checkdata=$this->check_espermission_access($esarray);
            //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $get_article_rec->art_es_document_status !== 'n')
            if($checkdata==true)
            {
                $es_mode = TRUE;
                if($get_article_rec->art_es_document_type == 'n')
                {
                    $es_new_doc = TRUE;
                }
            }
            //check file uploaded both in db and uploaded folder //cur. no
            if($article_attachment_status=='y')
            {
            if ($get_article_rec->art_stub == 'n' && $get_article_advance_options != NULL && in_array('fu', json_decode($get_article_advance_options->atotp_article_submission_type)) && $get_article_upload_files->cnt == 0 && $get_article_rec->art_stage_submission_method !== 'z' && $es_new_doc == FALSE) {
                $val_attach_files = FALSE;
                $priority_ref = 3; //2nd tab
                $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                $msg[] = $return_data['message'] = $get_article_rec->art_es_document_status == 'n' ? customTrans('viewarticle.attach_files') : 'Please upload a main document';
                $return = 'norecords';
                $return_data['status'] = $return;
                $return_data['priority'] = $priority_ref;
                return  $this->warning('Warning', 200, $return_data,'warning');
            }
            if (in_array('fu', json_decode($get_article_advance_options->atotp_article_submission_type)) && $get_article_rec->art_stage_submission_method !== 'z' && $es_mode == FALSE) {
                if ($identical_attachment_order['status'] == FALSE) {
                    $priority_ref = 3; //2nd tab
                    $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $preview_pdf_status = FALSE;
                    $msg[] = $return_data['message'] = customTrans('viewarticle.preview_pdf_error');
                    $return = 'norecords';
                    $return_data['status'] = $return;
                    $return_data['priority'] = $priority_ref;
                    return  $this->warning('Warning', 200, $return_data,'warning');
                }
            }

            if (in_array('fu', json_decode($get_article_advance_options->atotp_article_submission_type)) && $get_article_rec->art_stage_submission_method !== 'z' && $es_mode == TRUE) 
            {

                $where_cond="atmnt_label=0 AND atmnt_art_id={$article_id}";
                $attchment_description=Attachment_files::get_single_record('count(atmnt_id) AS count',$where_cond);
                if(isset($attchment_description->count)&&$attchment_description->count!=0)
                {
                    $priority_ref = 3;
                    $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $return_data['message'] = trans('pdf.description_empty');
                    $return = 'norecords';
                    $return_data['status'] = $return;
                    $return_data['priority'] = $priority_ref;
                    $return_data['es_warnings'] = true;
                    return  $this->warning('Warning', 200, $return_data,'warning');
                }
                else
                {
                    $condition = array('rft_artp_id' => $get_article_rec->art_artp_id,'rft_req_fld' => 'y');
                    $get_all_required_files = Required_file_type::get_single_record_with_bind_cond('GROUP_CONCAT(rft_file_desp_id) as required_descs',$condition);
                    if($get_all_required_files->required_descs !== null)
                    {
                        $req_files = $get_all_required_files->required_descs;  
                        $req_files = explode(',',$req_files);
                        $req_file_count = count($req_files);
                        $attach_file_tbl = (new \App\Models\Attachment_files())->getTable();
                        $file_descrp_tbl = (new \App\Models\Attachment_file_description())->getTable();
                        $req_exists = Attachment_files::where('atmnt_art_id', $article_id)->whereIn('atmnt_label', $req_files)->select('atmnt_art_id')->groupBy('atmnt_art_id')->havingRaw('COUNT(DISTINCT atmnt_label) = ?', [$req_file_count]);
                        if($get_article_rec->art_es_document_type == 'n')
                        {
                            $req_exists = $req_exists->join($file_descrp_tbl, $attach_file_tbl.'.atmnt_label', '=', $file_descrp_tbl.'.afdec_id')
                            ->where($file_descrp_tbl.'.afdec_main_document', 'n');
                        }
                        if(!$req_exists) {
                            $priority_ref = 3;
                            $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                            $return_data['message'] = trans('pdf.upload_required_descs');
                            $return = 'norecords';
                            $return_data['status'] = $return;
                            $return_data['priority'] = $priority_ref;
                            $return_data['es_warnings'] = true;
                            return  $this->warning('Warning', 200, $return_data,'warning');
                        } 
                    }
                }
            }
        }
        // END TASK #3263
            $seek_confirm_status = TRUE;
            if ($get_article_advance_options->atotp_co_authors_agreement == 'y' && $submit_prod == FALSE) {
                // $confirm_status = Authors::get_all_records('count(auth_id) as auth_ids', "auth_art_id = '{$article_id}' AND (auth_confirm_status = 'n' OR auth_confirm_status = 'i')");
                $confirm_status = Authors::get_all_records('count(auth_id) as auth_ids', "auth_art_id = ? AND (auth_confirm_status = 'n' OR auth_confirm_status = 'i')",binding_arr:[$article_id]);
                if (!empty($confirm_status) && $confirm_status[0]->auth_ids > 0) {
                    $seek_confirm_status = FALSE;
                    $priority_ref = 2; //2nd tab
                    $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $return_data['priority'] = $priority_ref;
                    $msg[] = $return_data['message'] = customTrans('viewarticle.co_author_confirm_pending');
                    return  $this->warning('Warning', 200, $return_data,'warning');
                }
            }
            $authors_contributorship = TRUE;
            if ($this->current_client->functionality->cfty_carsrai_credit_mandatory == 'y') {

                $authors_contributorship = $this->check_author_contributorship($article_id);
                if ($authors_contributorship == FALSE) {
                    $msg[] = $return_data['message'] = customTrans('viewarticle.author_contributorship_warning');
                    $priority_ref = 2; //2nd tab
                    $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $return_data['priority'] = $priority_ref;
                    return  $this->warning('Warning', 200, $return_data,'warning');
                }
            }
            //check abstract added;
            $val_abstract = TRUE;
            if (!empty($get_article_rec)) {
                $art_abstract = trim($get_article_rec->art_abstract);
                if (empty($art_abstract) && in_array('re', json_decode($get_article_advance_options->atotp_article_submission_type))) {
                    $val_abstract = FALSE;
                    $priority_ref = 1; //2nd tab
                    $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $return_data['message'] = customTrans('viewarticle.abstract_field_empty');
                    $return = 'norecords';
                    $return_data['status'] = $return;
                    $return_data['priority'] = $priority_ref;
                    return  $this->warning('Warning', 200, $return_data,'warning');
                }
            }
           /* $articletype_id = $get_article_rec->art_artp_id;
            $flow_master_id = Article_types::get_single_record('artp_fwm_id', "artp_id={$articletype_id}");
            $stage = Generic_flows::get_single_record('jwf_article_attachment_status', "jwf_stage_type='author_submission' AND jwf_fwm_id={$flow_master_id->artp_fwm_id}");
            $article_attachment_status=$stage->jwf_article_attachment_status;
            $val_attach_files = TRUE;
            $val_attach_file_additional_info = TRUE;
            $es_mode = FALSE;
            $es_new_doc = FALSE;
            if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $get_article_rec->art_es_document_status !== 'n')
            {
                $es_mode = TRUE;
                if($get_article_rec->art_es_document_type == 'n')
                {
                    $es_new_doc = TRUE;
                }
            }
       
            if($article_attachment_status=='y')
            {
            if ($get_article_rec->art_stub == 'n' && $get_article_advance_options != NULL && in_array('fu', json_decode($get_article_advance_options->atotp_article_submission_type)) && $get_article_upload_files->cnt == 0 && $get_article_rec->art_stage_submission_method !== 'z' && $es_new_doc == FALSE) {
                $val_attach_files = FALSE;
                $priority_ref = 3; //2nd tab
                $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                $msg[] = $return_data['message'] = trans('viewarticle.attach_files');
                $return = 'norecords';
                $return_data['status'] = $return;
                $return_data['priority'] = $priority_ref;
                return  $this->warning('Warning', 200, $return_data,'warning');
            }
            if (in_array('fu', json_decode($get_article_advance_options->atotp_article_submission_type)) && $get_article_rec->art_stage_submission_method !== 'z' && $es_mode == FALSE) {
                if ($identical_attachment_order['status'] == FALSE) {
                    $priority_ref = 3; //2nd tab
                    $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $preview_pdf_status = FALSE;
                    $msg[] = $return_data['message'] = trans('viewarticle.preview_pdf_error');
                    $return = 'norecords';
                    $return_data['status'] = $return;
                    $return_data['priority'] = $priority_ref;
                    return  $this->warning('Warning', 200, $return_data,'warning');
                }
            }
        }*/
        
        if($es_mode == TRUE && $es_new_doc == FALSE)
        {
            $attchment_table = (new \App\Models\Attachment_files())->getTable();
            $description_tbl = (new \App\Models\Attachment_file_description())->getTable();
            $tables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id')
                            )
                        );
            $select_fields = 'afdec_main_document,atmnt_doc_created_in_es,atmnt_file_name,atmnt_id';
            // $criteria = 'atmnt_art_id=' . $article_id.' AND afdec_main_document =\'y\'';
            $criteria = 'atmnt_art_id= ? AND afdec_main_document =\'y\'';
            // $get_all_attach_details = Attachment_files::get_results_using_joins($tables, $select_fields, $criteria, 'all');
            $get_all_attach_details = Attachment_files::get_results_using_joins($tables, $select_fields, $criteria, 'all',binding_arr:[$article_id]);
            if(count($get_all_attach_details) == 0)
            {
                $priority_ref = 3; //2nd tab
                $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                $msg[] = $return_data['message'] = "Please upload a main document";
                $return = 'norecords';
                $return_data['status'] = $return;
                $return_data['priority'] = $priority_ref;
                return  $this->warning('Warning', 200, $return_data,'warning');          
            }
            else
            {
                $attach_es_data = $get_all_attach_details[0];
                if($attach_es_data->atmnt_doc_created_in_es == 'n')
                {
                    $file_name = rawurlencode($attach_es_data->atmnt_file_name);
                    $query_string = 'article_id='.$article_id.'&file_name='.$file_name;
                    $pass_arr = array();
                    $pass_arr['encryptedData'] = Rv_encrypt($query_string);
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    $apiUrl = $es_api_data['doc_status_url'];
                    $pass_arr =  array('encryptedData' => Rv_encrypt($query_string));
                    //$pass_arr = http_build_query($pass_arr);
                    $response = $this->es_curl_request($apiUrl,$pass_arr);
                    $response = json_decode($response);
                    if(isset($response->status) && $response->status == 200)
                    {
                        $this->current_user = $this->get_current_user_details();
                        $update_attachment = Attachment_files::update_record(array('atmnt_doc_created_in_es' => 'y'), "atmnt_id = {$attach_es_data->atmnt_id}", $this->current_user);
                        if($update_attachment)
                        {
                            $attach_es_data->atmnt_doc_created_in_es = 'y';
                        } 
                    }
                    else
                    {
                        $priority_ref = 3; //2nd tab
                        $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                        $msg[] = $return_data['message'] = "Main document not created in the editor";
                        $return = 'norecords';
                        $return_data['status'] = $return;
                        $return_data['priority'] = $priority_ref;
                        return  $this->warning('Warning', 200, $return_data,'warning');    
                    }
                }
            }
        }
            

            //   ///pdf
            $resubmit_warning = isset($post_data['resubmit_warning']) ? $post_data['resubmit_warning'] : '';
            if ($preview_pdf_status == FALSE && null != $resubmit_warning) {
                $msg[] = $return_data['message'] = customTrans('viewarticle.resubmit_pdf_error_upload_page');
                $return = 'norecords';
                $return_data['status'] = $return;
                return  $this->warning('Warning', 200, $return_data,'warning');
            }
            //    ///pdf end'

            //check co-author
            $check_co_author =  $this->check_co_author($article_id);
            if(!empty($check_co_author))
            {
                $priority = $check_co_author['priority'];
                $msg[] = $check_co_author['msg'];
            }
            $keyword_exist = $this->keyword_exist($article_id);
            $check_author_permission = $this->check_author_permission($article_id, $get_article_rec, $this->current_user['user_id'], $edit_article, $priority);
            $check_duplicate = $this->check_duplicate($current_status_id, $article_id);
            $art_pro_status = $this->is_article_in_production_management($article_id);
            $pro_link = '';
            // if ($art_pro_status['status'] == TRUE)
            //     $pro_link = '-production';
            $val_abstract = TRUE;
            $val_attach_file_additional_info = TRUE;
            if ((!empty($check_co_author['get_authors']) && $check_co_author['val_co_author'] == TRUE) && $val_abstract == TRUE && $val_attach_files == TRUE && ($check_author_permission['check_author_permission'] == TRUE || $edit_article == TRUE) && $val_attach_file_additional_info == TRUE && $keyword_exist['keyword_exist'] == TRUE && $check_co_author['author_title'] == TRUE &&  $check_co_author['author_aff'] == TRUE && $check_duplicate['duplicate'] == FALSE) {

                //checking copyright in abstract final submission Task #5214
                if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' ) {
                    $Copyright  =   new \App\Models\Copyright();
                   $copyright_check = $Copyright::get_single_record('COUNT(crt_id) as cnt,copy_att_name','crt_art_id = ?',binding_arr:[$article_id]);
                    if ($copyright_check->cnt < 1 && $submission_from == 'final-submit') {
                        $return_data['message'] = customTrans('viewarticle.copyright_missing');
                        $return_data['validate_copyright'] =true;
                        return  $this->warning('Warning', 200, $return_data,'warning');
                    }
                    // Task #3358 bug  email send error
                    if($this->current_client->functionality->cfty_enable_copyright_attachment && $this->current_client->functionality->cfty_enable_copyright_attachment =='y' && $copyright_check->cnt >0 && $copyright_check->copy_att_name=='' && $submission_from == 'final-submit')
                    { 
                        $return_data['message'] = customTrans('viewarticle.copyright_missing_attachment');
                        $return_data['validate_copyright'] =true;
                        return  $this->warning('Warning', 200, $return_data,'warning');
                    }


                }

                /* start --- add new status record to status table */
                //update the current status record in the table( fill end date and status as 'c'
                //for update attach file default description in final submit
                if (isset($get_article_upload_files->cnt) && $get_article_upload_files->cnt > 0)
                    $this->update_with_default_attach_description($article_id, $art_type_id);
                if ($submission_from == 'check-article-submission') {
                    $parameter_array['select ']='*';
                    // $parameter_array['condition']="art_status='n' and art_submitted_by=" . $this->current_user['user_id'] . " and artp_jnl_id=" .$jnl_id . " and art_prev_article_id IS NOT NULL
                    // AND art_id=" . $article_id;
                    $parameter_array['condition']="art_status='n' and art_submitted_by=" . $this->current_user['user_id'] . " and artp_jnl_id= ? and art_prev_article_id IS NOT NULL
                    AND art_id= ?";
                    $parameter_array['binding_arr'] = [$jnl_id,$article_id];
                    $article_for_resubmission_result = Article_flow::get_articles_and_status($parameter_array);
                if(count($article_for_resubmission_result)>0)
                 $article_for_resubmission = TRUE;
                    //$jnl_code = $this->jnl_data->jnl_journal_code;
                    if ($get_article_rec->art_status == 'n' && $validate_forms == TRUE && $article_for_resubmission == FALSE) {
                        $msg[] =$return_data['message'] = customTrans('viewarticle.preview-article');
                        if ($bulk_submission == TRUE) {
                            $preview_url = $jnl_code . '/' . $cur_art_type_record->artp_abbr_article_type . '/preview-article/' . $this->encrypt_data('article_id=' . $article_id . '&status_id=' . $current_status_id . '&bulksubmission=' . $bulk_submission);
                        } else
                            $preview_url = $jnl_code . '/' . $cur_art_type_record->artp_abbr_article_type . '/preview-article/' . $this->encrypt_data($article_id) .'/' .$this->encrypt_data($current_status_id);
                        $preview_link = "<a id='btn_preview_article' href='$preview_url' class='btn btn-primary txt-space' >Preview Submission</a>";
                        $return_data['preview_url'] = $preview_url;
                        $return_data['preview_link'] = $preview_link;
                        $return_data['preview_link_status'] = 'preview-article';
                    } elseif ($article_for_resubmission == TRUE || $get_article_rec->art_status == 'y' ||  ($art_pro_status['status'] == TRUE && $get_article_rec->art_status == 'a') || $get_article_rec->art_transfer_status == 'y') {
                        //$go_to_url = $jnl_code . '/author-article' . $pro_link . '?' . $this->encrypt_data("article_id={$article_id}&status_id=" . $current_status_id); 


                        $go_to_url = $jnl_code . '/author-article' . $pro_link .'/'.$this->encrypt_data($article_id) .'/' .$this->encrypt_data($current_status_id);
                        $data_trnsfer = ($get_article_rec->art_transfer_status == 'y') ? 'trans' : '';
                        $return_data['preview_url'] = $go_to_url;
                        $go_to_view_article =   customTrans('Go to view :article');

                        $preview_link = '<a href="' . $go_to_url . '" data="' . $data_trnsfer . '" id="btn_go_to_view_article" class="btn btn-primary">'.$go_to_view_article.'</a>';
                        $return_data['preview_link'] = $preview_link;
                        $return_data['preview_link_status'] = 'author-article'.$pro_link;
                    }
                    
                    $return = 'success';
                } else if ($submission_from == 'final-submit' && ($seek_confirm_status == FALSE ||  $check_co_author['val_corr_author'] == FALSE) || $preview_pdf_status == FALSE || ($authors_contributorship == FALSE)) {

                    $return = 'norecords';
                } else if (!$confirm) {
                    $return = 'norecords';
                }

                /* start --- add new status record to status table */
                //update the current status record in the table( fill end date and status as 'c'
                else if ($submission_from != 'article-correction') {
                    $ithenticate_enabled = FALSE;
                    if ($this->current_client->modules->mdl_ithenticate == 'y') {
                        $ithenticate_enabled = $this->current_client->clnt_id;
                    }
                    // Task #925 check if research integrity mdl is enabled
                    $rvri_enabled = FALSE;
                    if ($this->current_client->modules->mdl_research_integrity == 'y') {
                        $rvri_enabled = $this->current_client->clnt_id;
                    }
                    //  todo ->transaction start
                    $update_biorxiv = 0;
                    $result = $this->update_article_table($article_id, $jnl_code, $cur_art_type_record);
                    if (!empty($result)) {
                        $update_biorxiv = $result['update_biorxiv'];
                        $event_user = $this->event_manage($jnl_id, $article_id, $this->current_user);
                    }
                    $jnl_user_role[$jnl_code]= array(
                        'role_id' => $role_id,
                        'role_name' => $role_name,
                        'core_role' => $core_role,
                    );
                    $this->current_user['jnl_user_role']=$jnl_user_role;
                    if (!empty($result)&&$result['result']>0) {
                   $article_data=array(
                        'core_role'=>$core_role,
                        'role_name'=>$role_name,
                        'role_id'=>$role_id,
                        'article_id'=>$article_id,
                        'jnl_id'=>$jnl_id,
                        'jnl_code'=>$jnl_code,
                        'art_type_id'=>$art_type_id,
                        'current_status_id'=>$current_status_id,
                        'get_article_advance_options'=>$get_article_advance_options
                    );
                    $email_manage = $this->email_manage($article_data);
                    }
                    $move_next_data_array['article_id'] = $article_id;
                    $move_next_data_array['current_user'] = $this->current_user;
                    $move_next_data_array['master_flow_id'] = $flow_master_id->artp_fwm_id;
                    $move_next_data_array['current_stage'] = $current_status_id;
                    $move_next_data_array['artp_id'] = $art_type_id;
                    $move_next_data_array['ithenticate_enabled'] = $ithenticate_enabled;
                    $move_next_data_array['rvri_enabled'] = $rvri_enabled;
                    $move_next_data_array['current_client'] = $this->current_client;
                    $move_next_data_array['trans_started'] = TRUE;
                    $skip_ftp = FALSE;
                    if(isset($post_data['submit_for_production']) && $post_data['submit_for_production'] == TRUE && $submission_from == 'final-submit')
                    {
                        $skip_ftp = TRUE;
                        $next_stages = json_decode($get_article_rec->art_submitted_current_stage);
                        $move_next_data_array['aflw_submit_user'] = $get_article_rec->art_submitted_by;
                        $update_status_article = $this->get_article_status_by_stage_based($move_next_data_array['master_flow_id'],$next_stages);
                        $stub_status = Articles::get_single_record_with_bind_cond('art_stub', array(
					            'art_id' => $article_id
                        ));
                        $article_update_arr = array(
                            'art_status' => $update_status_article,
                            'art_stub' => $stub_status->art_stub
                        );
                        $current_user = $this->get_current_user_details();
                        $update_article_record = Articles::update_record($article_update_arr, array(
                            'art_id' => $article_id),$current_user);
                        foreach($next_stages as $single_stages)
                        {
                            $move_next_data_array['next_stage'] =  $single_stages;
                            $stage_move_result = $this->move_next_stage($move_next_data_array);
                        }
                    }
                    else
                    {
                        $stage_move_result = $this->move_next_stage($move_next_data_array);
                    }
                    if (!empty($stage_move_result)) {
                       
                        $move_next_data_array['role_id'] = $role_id;
                        $this->suspecious_activity_check($move_next_data_array);
                        
                        $esarray['article_id']=$article_id;
                        $checkdata=$this->check_espermission_access($esarray);
                        if($checkdata == TRUE)
                        {
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            if(isset($es_api_data['create_stage_backup']))
                                {
                                    $stage_details_current = $get_gotoview;
                                    $apiUrl = $es_api_data['create_stage_backup'];
                                    $data_to_editor = array('documentId' => $article_id,'currentFlowId' => $current_status_id,'systemType' => 1,'stage_name_privillaged' => $stage_details_current->jwf_stage_name,'stage_name_non_privillaged' => $stage_details_current->jwf_temporary_status_name  == NULL ? $stage_details_current->jwf_stage_name: $stage_details_current->jwf_temporary_status_name,'current_user' => $this->current_user);
                                    $data_to_editor = http_build_query($data_to_editor);
                                    $response = $this->es_curl_request($apiUrl,$data_to_editor);
                                    $response = json_decode($response);
                                }
                        }

                        $this->update_article_author_map($article_id, $check_co_author['author_aff_id'], $jnl_id);
                        $event_type = 'c';
                        if($skip_ftp == FALSE)
                        $this->upload_article_data_to_custom_ftp($article_id, $current_status_id, $event_type, $stage_move_result);
                        //$return_data['redirection_link'] = url('journal/' . $jnl_code);
                        $return_data['redirection_link'] = $this->current_client->platform_type.'/'. $jnl_code;
                       /* $role_id_broadcast = Roles::where('role_assigned_role', 'journal_admin')->get(['role_id'])->first()?->role_id;
                        $user_ids_broadcast = User_to_journals::where('usrj_jnl_id', $jnl_id)->where('usrj_artp_id', $art_type_id)->where('usrj_role_id', $role_id_broadcast)->get(['usrj_usr_id as id']);
                        Broadcast(new ArticleStatusUpdate(array("title" => "New Article Submitted", "body" => "Editorial Office received a new article", "tag" => Str::random(6)), array_column($user_ids_broadcast, 'id')));*/
                        $success_message = customTrans('viewarticle.art_fin_sub_success');
                        $return_data['review_for_doc'] = $this->current_client->modules->mdl_review_for_doc;
                        if ($update_biorxiv != 0)
                            $success_message = customTrans('viewarticle.art_fin_sub_bioxiv_success');

                        if(isset($es_mode) && $es_mode == true)
                        {
                            $return_data['message_to_rvrite'] = customTrans('viewarticle.submission_completed_rvrite');;
                        }
                        $return_data['message'] =  $success_message;
                    } else {
                        $msg[] = customTrans('viewarticle.art_fin_sub_flow_failed');
                    }
                } else {
                    $msg[] = 'Edited Successfully';
                    $return = 'success';
                    $return_data['redirection_link'] = $jnl_code . '/view-article?' . $this->encrypt_data('article_id=' . $article_id);
                }

            }
            if ($priority != "") {
                    $return_data['priority'] = $priority;
                }
                if (count($msg) > 1) {
                    $msg_arr = array();
                    foreach ($msg as $msg_key => $msg_val) {
                        $msg_key++;
                        $msg_arr[] = $msg_key . ". " . $msg_val;
                    }
                    $return_data['left_align'] = TRUE;
                    $message = implode('<br>', $msg_arr);
                } else {
                    $message = implode('<br>', $msg);
                }

                if($priority!='' && $msg!='')
                {
                    $return_data['message'] = $message;
                    return  $this->warning('Warning', 200,$return_data,'warning');
                }
                $article_for_resubmission_flag = FALSE;
                if (!empty($article_for_resubmission) || $article_transfer_flag == TRUE) {
                    if (!empty($article_for_resubmission)) {
                        $article_for_resubmission_flag = TRUE;
                    }
                    if ($article_transfer_flag == TRUE) {
                        $article_transfer_status = TRUE;
                    }
                    $article_for_resubmission = TRUE;
                    //$go_to_url = $jnl_code . '/author-article' . $pro_link . '?' . $this->encrypt_data("article_id={$article_id}&status_id=" . $current_status_id);
                    $go_to_url = $jnl_code . '/author-article' . $pro_link .'/'.$this->encrypt_data($article_id) .'/' .$this->encrypt_data($current_status_id);
                    $data_trnsfer = ($get_article_rec->art_transfer_status == 'y') ? 'trans' : '';
                    $return_data['preview_url'] = $go_to_url;
                    $preview_link = '<a href="' . $go_to_url . '" data="' . $data_trnsfer . '" id="btn_go_to_view_article" class="btn btn-primary">Go to View Article</a>';
                    $return_data['preview_link'] = $preview_link;
                    $return_data['preview_link_status'] = 'author-article'.$pro_link;
                    $confirm_author_status = $this->get_user_confirm_status($article_id, $art_type_id, $jnl_id);
                }
                $return_data['status'] = $return;
                $return_data['staff_edit'] = $edit_article;
                $return_data['article_for_resubmission'] = $article_for_resubmission_flag;
                $return_data['article_transfer_status'] = $article_transfer_status;
                $return_data['confirm_author_status'] = $confirm_author_status;
                if(isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y'){
                if($submission_from == 'final-submit'){
                    addAllUserOfArticleToConveyJob::dispatch($article_id);
                }
                }
            return  $this->success('Success', 200, $return_data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    //check co-author
    public function check_co_author($article_id)
    {
        $priority = '';
        $return_arr['priority'] ='';
        $return_arr['msg'] = '';
        $val_co_author = TRUE;
        $author_title = TRUE;
        $author_aff = TRUE;
        $get_authors = Authors::get_author_affiliations($article_id);
        if (count($get_authors) == 0) {
            $val_co_author = FALSE;
            $priority_ref = 2; //2nd tab
            $return_arr['priority'] = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
            $return_arr['msg'] = customTrans('viewarticle.author_final_submission');
        } else {
            $author_aff_id = NULL;
            foreach ($get_authors as $get_author) {
                if ($get_author->auaff_id == NULL) {
                    $author_aff = FALSE;
                    $priority_ref = 2; //2nd tab
                    $return_arr['priority'] = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                    $return_arr['msg'] = customTrans('viewarticle.authr_aff_missing');
                    break;
                }
                if ($get_author->auaff_prime_affiliation == 'y' && $get_author->auth_corr_author == 'y') {

                    $author_aff_id = $get_author->auaff_id;
                }
            }
            $return_arr['author_aff_id'] = $author_aff_id;
        }
        $val_corr_author = TRUE;
        // $get_corresp_rec = Authors::get_single_record('*', "auth_art_id={$article_id} and auth_corr_author ='y'");
        $get_corresp_rec = Authors::get_single_record('*', "auth_art_id= ? and auth_corr_author ='y'",binding_arr:[$article_id]);
        if ($get_corresp_rec == NULL) {
            $val_corr_author = FALSE;
            $priority_ref = 2; //2nd tab
            $return_arr['priority'] = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
            $return_arr['msg'] = customTrans('viewarticle.cur_author_final_submission');
        }

        //checking presenting author for confrence
        if (isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y') {
            $count_pres = Authors::get_single_record('count(auth_id) as cnt', "auth_art_id= ? AND auth_pres_author ='y'",binding_arr:[$article_id]);
            if ($count_pres->cnt < 1) {
                $priority_ref = 2; //2nd tab
                $return_arr['priority'] = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                $return_arr['msg'] = customTrans('viewarticle.pres_auth_missing');
            }
        }

        $return_arr['get_authors'] = $get_authors;
        $return_arr['val_corr_author'] = $val_corr_author;
        $return_arr['val_co_author'] = $val_co_author;
        $return_arr['author_title'] = $author_title;
        $return_arr['author_aff'] = $author_aff;
        return $return_arr;
    }
    //ensure article keyword during b2j article submission
    public function keyword_exist($article_id)
    {
        $keyword_exist = TRUE;
        $priority = '';
        if (isset($this->current_client->functionality->cfty_biorxiv) && $this->current_client->functionality->cfty_biorxiv == 'y') {



            // $exist_art_keyword = Article_keywords::get_all_records('count(ak_id) as cnt', "ak_art_id={$article_id}");
            $exist_art_keyword = Article_keywords::get_all_records('count(ak_id) as cnt', "ak_art_id= ? ",binding_arr:[$article_id]);

            if ($exist_art_keyword[0]->cnt == 0) {
                $keyword_exist = FALSE;
                $priority_ref = 1; //2nd tab
                $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
                $return_arr['msg'] = 'keyword_notification';
                $return_arr['priority'] = $priority;
            }
        }
        $return_arr['keyword_exist'] = $keyword_exist;

        return $return_arr;
    }
    // check_author_permission
    public function check_author_permission($article_id, $get_article_rec, $user_id, $edit_article, $priority)
    {
        $check_author_permission = FALSE;
        $get_authors = Authors::get_author_affiliations($article_id);
        if (!empty($get_article_rec)) {
            if ($get_authors != NULL) {
                ///$check_coauthors = Authors::get_all_records('*', "auth_usr_id={$user_id} and auth_art_id={$article_id}");
                $check_coauthors = Authors::get_all_records('*', "auth_usr_id= ? and auth_art_id= ?",binding_arr:[$user_id,$article_id]);
                if ($check_coauthors != NULL) {
                    $check_author_permission = TRUE;
                }
            }
        }

        if ($check_author_permission == FALSE && $edit_article == FALSE) {
            $priority_ref = 2; //2nd tab
            $priority = $priority !== "" && $priority <= $priority_ref ? $priority : $priority_ref;
            $return_arr['priority'] = $priority;

            $return_arr['msg'] = 'author_permission_failed';
        }
        $return_arr['check_author_permission'] = $check_author_permission;
        return $return_arr;
    }
    /*		 * *  Duplicate entry on completing stages * */
    public function check_duplicate($current_status_id, $article_id)
    {

        $duplicate = FALSE;
        $check_duplicate = TRUE;
        if (isset($current_status_id) && $current_status_id != "") {
            // $post_data['hdn_current_status_id'] = encrypt_link($current_status_id);
            // $post_data['article_id'] = encrypt_link($article_id);
            // $post_data['hdn_form_action'] = '';
            // $check_duplicate = $this->validate_duplicate_entry($post_data);
            $check_duplicate = TRUE;
        } else {
            // $submit_flow = Article_flow::get_single_record('aflw_id', "aflw_art_id={$article_id}");
            $submit_flow = Article_flow::get_single_record('aflw_id', "aflw_art_id= ?",binding_arr:[$article_id]);
            // $post_data['hdn_current_status_id'] = encrypt_link($submit_flow->aflw_id);
            // $post_data['article_id'] = encrypt_link($article_id);
            // $post_data['hdn_form_action'] = '';
            // $check_duplicate = $this->validate_duplicate_entry($post_data);
            $check_duplicate = TRUE;
        }
        if ($check_duplicate != TRUE) {
            $duplicate = TRUE;
            $return_arr['msg'] = customTrans('completed_duplicate_err');
            // $return = 'norecords';
        }
        $return_arr['duplicate'] = $duplicate;
        $return_arr['check_duplicate'] = $check_duplicate;
        return $return_arr;
    }
    public function gettabstatus(Request $request)
    {

        $articleflow_table = (new \App\Models\Article_flow)->getTable();
        $genericflow_table = (new \App\Models\Generic_flows)->getTable();
        try {
            $post_data = $request->all();
            
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id'=>'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' => decrypt_link($post_data['art_id']),
                'type'=> 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => decrypt_link($post_data['art_flow_id']),
                'type'=> 'number'
            );
            $art_flow_id_validate = $this->Rv_validator($input_arr);
   

            if($art_id_validate == FALSE || $art_flow_id_validate==FALSE)
			{
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",201,$arraymsg);
            }
            $array['article_id']=decrypt_link($post_data['art_id']);
            $array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
            $array['url']=$request->segment(4);
            
            $user_access=$this->check_permission_access_user($array);
            
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');

            }
            $article_id = $this->decrypt_data($post_data['art_id']);
            $current_flow_id = $this->decrypt_data($post_data['art_flow_id']);
             /*TASK #4943 submissiontabstatus sql injection*/
            // $condition = "tab_status_art_id={$article_id}";
            // $tab_details = Article_tab_status::get_single_record('*', $condition);
            $condition = "tab_status_art_id=?";
            $tab_details = Article_tab_status::get_single_record('*', $condition,binding_arr:[$article_id]);
            // $art_condition = "art_id={$article_id}"; 
            // $article_details = Articles::get_single_record('*', $art_condition);
            $art_condition = "art_id=?";
            $article_details = Articles::get_single_record('*', $art_condition,binding_arr:[$article_id]); 
            $articletype_id = $article_details->art_artp_id;
            $article_advanced_details = Article_type_advance_options::get_all_records('*', "atotp_artp_id={$articletype_id}");
            $flow_master_id = Article_types::get_single_record('artp_fwm_id', "artp_id={$articletype_id}");
            $stage = Generic_flows::get_single_record('jwf_article_attachment_status,jwf_enable_payment', "jwf_stage_type='author_submission' AND jwf_fwm_id={$flow_master_id->artp_fwm_id}");
            $article_attachment_status=$stage->jwf_article_attachment_status;
            $tables = array(
                'main_table' => $articleflow_table,
                'join_table' => array(
                    $genericflow_table => array('jwf_id','aflw_jwf_id') 
                )
            );
            $select = 'jwf_stage_type';
            $form_criteria = 'aflw_art_id = ' . $article_id . ' and  aflw_id='.$current_flow_id;
            $current_stage = Article_flow::get_results_using_joins($tables, $select, $form_criteria, 'single');
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y' && $stage->jwf_enable_payment =='y') {
                if(!empty($article_details)) {
                    if ($article_details->art_status == 'y' || json_decode($tab_details->tab_status_array)->tab_additional_info == 'p') {
                        $Payment_order = new \App\Models\Payment_order();
                        $check  =   $Payment_order::get_single_record('count(pmt_ord_id) as cnt','pmt_ord_art_id = ? and pmt_transaction_status = \'fn\'',binding_arr:[$article_id]);
                        $art_status =   Article_flow::get_single_record('aflw_status','aflw_art_id  = ?',binding_arr:[$article_id]);
                        if ($check->cnt == 0) {
                             if($art_status->aflw_status=='c'){
                                    $rearray=array(
                                        'tab_article_details'=>'c',
                                        'tab_co_author'=>'c',
                                        'tab_attach_files'=>'c',
                                        'tab_review_preference'=>'c',
                                        'tab_payment_info' =>'c',
                                        'tab_additional_info'=>'p'
                                    );

                                }
                                else{
                                    $rearray=array(
                                        'tab_article_details'=>'c',
                                        'tab_co_author'=>'c',
                                        'tab_attach_files'=>'c',
                                        'tab_review_preference'=>'c',
                                        'tab_payment_info' =>'p',
                                        'tab_additional_info'=>''
                                    );
                                }              
                            if(isset($tab_details->tab_status_array)){
                                $tab_details->tab_status_array=json_encode($rearray);
                            }
                        }
                    }
                }
            }

            if(!empty($article_details)) {
                if(!empty($article_details->art_prev_article_id) && $article_details->art_transfer_article=='n') {
                    $rearray=array(
                        'tab_article_details'=>'c',
                        'tab_co_author'=>'c',
                        'tab_attach_files'=>'p',
                        'tab_review_preference'=>'',
                        'tab_additional_info'=>''
                    );
                    if($article_attachment_status=='n') {
                        $rearray['tab_attach_files']='';
                        $rearray['tab_co_author']='p';
                    }
                    if(isset($tab_details->tab_status_array)){
                        $tab_details->tab_status_array=json_encode($rearray);
                    }

                }
            }
            /* Task #196-10096 Update Button Labels and Redirect Flow in Transfer Process-  After clicking on "Go to Edit Article", site will redirect to the first tab of edit article. */
            // if($current_stage->jwf_stage_type == 'transit')
            // {
            // $rear=array(
            //     'tab_article_details'=>'p',
            //     'tab_co_author'=>'c',
            //     'tab_attach_files'=>'c',
            //     'tab_review_preference'=>'c',
            //     'tab_payment_info' =>'c',
            //     'tab_additional_info'=>'c'
            // );
            // $tab_details->tab_status_array =json_encode($rear);
        //}
        /*   After clicking on "Go to Edit Article", site will redirect to the first tab of edit article. */
            $return_arr['tabdata'] = $tab_details;
            return $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {
      
            return $this->failure('Failed', 500, $e);
        }
    }

    public function custom_form($generic_form_data, $cfty_xml_cd_code_in_export, $doc, $configurable_data_fields_node, $article_code_data = NULL)

    {
        if ($article_code_data != NULL)
            $article_code = $article_code_data;
        $art_id = '';
        foreach ($generic_form_data as $gen_fm) {

            if ($article_code_data == NULL && ($art_id != $gen_fm->gdata_art_id)) {
                $art_id    = $gen_fm->gdata_art_id;
                $article_dt = Articles::get_single_record('art_code', 'art_id=' . $art_id);
                $article_code = $article_dt->art_code;
            }

            //generic form file name not managed
            if ($gen_fm->gdata_element_type == 'file')
                continue;
            $custom_fields_node = $doc->createElement('custom_fields');
            $custom_fields_node->setAttribute('cd_code', $this->filter_html_contents($gen_fm->gdata_gform_title));
            $custom_fields_node->setAttribute('cd_ms_version', $this->filter_html_contents($article_code));

            //Customisation #1591   JPR-183
            if ($cfty_xml_cd_code_in_export == TRUE) {

                $custom_fields_node->setAttribute('cd_name', $this->filter_html_contents($gen_fm->emt_cd_code));
                $custom_fields_node->setAttribute('cd_label', $this->filter_html_contents($gen_fm->gdata_label));
            } else
                $custom_fields_node->setAttribute('cd_name', $this->filter_html_contents($gen_fm->gdata_label));
            $custom_fields_node->setAttribute('cd_value', $this->filter_html_contents($gen_fm->gdata_display_data));
            $configurable_data_fields_node->appendChild($custom_fields_node);
        }
        return $configurable_data_fields_node;
    }

    public function get_user_confirm_status($art_id, $artp_id, $jnl_id)
    {
        $confirm_status = FALSE;
        $parameter_array['select ']='*';
        $current_user = $this->get_current_user_details();
        $parameter_array['condition']="art_status='n' and art_submitted_by=" . $current_user['user_id'] . " and artp_jnl_id =" . $jnl_id . " and art_prev_article_id IS NOT NULL and art_id=" . $art_id;
        $article_for_resubmission = Article_flow::get_articles_and_status($parameter_array);
        if (!empty($article_for_resubmission)) {
            $get_article_advance_options = Article_type_advance_options::get_single_record('atotp_co_authors_agreement', 'atotp_artp_id=' . $artp_id);
            if ($get_article_advance_options->atotp_co_authors_agreement == 'y') {
                // $condition = 'auth_confirm_status != "y" and auth_art_id = ' . $art_id;
                // $confirm = Authors::get_single_record('count(auth_id) as auth_count', $condition);
                $condition = 'auth_confirm_status != "y" and auth_art_id = ?';
                $confirm = Authors::get_single_record('count(auth_id) as auth_count', $condition,binding_arr:[$art_id]);
                if ($confirm->auth_count != 0) {
                    $confirm_status = TRUE;
                }
            }
        }
        return $confirm_status;
    }

    public function has_required_form_element($elements)
    {
        $status = FALSE;
        foreach ($elements as $element) {
            if ($element->emt_required == 1) {
                $status = TRUE;
                break;
            }
        }
        return $status;
    }

    public function manage_issue($cur_art_type_record, $priority, $get_article_rec)
    {
        $current_user = $this->get_current_user_details();
        if (isset($cur_art_type_record->artp_special_issue) && $cur_art_type_record->artp_special_issue == 'y' && $get_article_rec->art_status == "n" && $get_article_rec->art_prev_article_id == "") {
            $softend_date = date_create($cur_art_type_record->artp_soft_enddate);
            $current_date = date_create(date('Y-m-d'));
            $hardend_date = date_create($cur_art_type_record->artp_hard_enddate);
            if ($current_date > $hardend_date) {
                $msg[] = customTrans('viewarticle.article_expire_msg');
                $return_data['msg'] = customTrans('viewarticle.article_expire_msg');
                $priority_ref = 1;
                $priority = $priority !== "" && $priority < $priority_ref ? $priority : $priority_ref;
                $return_data['priority'] = $priority;
                return $return_data;
            }
        }
        if (!empty($get_article_rec->art_publication_issue)) {
            $Issues = new \App\Models\Issues();
            $issues = $Issues::get_single_record('iss_hard_end_date', 'iss_id=' . $get_article_rec->art_publication_issue);
            $current_date = date_create(date('Y-m-d'));
            $hardend_date = date_create($issues->iss_hard_end_date);
            if ($current_date > $hardend_date) {
                $msg[] = customTrans('viewarticle.expired_article');
                $return_data['msg'] = customTrans('viewarticle.expired_article');
                $priority_ref = 1;
                $priority = $priority !== "" && $priority < $priority_ref ? $priority : $priority_ref;
                $return_data['priority'] = $priority;
                return $return_data;
            }
            $pages = $this->issue_management_page_count($get_article_rec->art_id,$get_article_rec->jnl_code);
            if(!empty($issue_record))
            {
                Issue_management::update_record(array('ism_iss_id'=>$get_article_rec->art_publication_issue,'ism_art_page_cnt' => $pages), array('ism_art_id'=>$get_article_rec->art_id), $current_user);
            }else{

                $condition = array("ism_iss_id" => $get_article_rec->art_publication_issue, 'ism_art_id' =>  $get_article_rec->art_id);
                $issue_data = Issue_management::get_single_record_with_bind_cond('ism_iss_id, ism_art_id',$condition);
                if(empty($issue_data))
                {

                    $data        = array(
                        'ism_art_page_cnt' => $pages,
                        'ism_iss_id' =>  $get_article_rec->art_publication_issue,
                        'ism_art_id' =>  $get_article_rec->art_id,
                        'ism_order'  =>  1
                    );
                    Issue_management::insert_record($data, $current_user);
                }
            }
        }else{
            $issue_record=Issue_management::get_single_record_with_bind_cond('ism_id', array('ism_art_id'=>$get_article_rec->art_id));
            if(!empty($issue_record))
            {
                Issue_management::delete_records(array('ism_art_id'=>$get_article_rec->art_id), '', $current_user);
            }
        }
    }

    public function manage_orcid($article_id, $priority)
    {
        $confirm = TRUE;
        $users_table = (new \App\Models\User())->getTable();
        if (isset($this->current_client->functionality) && $this->current_client->functionality->cfty_mandate_orcid == 'y' && $this->current_client->modules->mdl_orcid == 'y') {

            // $author_orcid = Articles::get_single_record('art_id,(select usr_orcid_id from ' . $users_table . ' where art_submitted_by = usr_id) as usr_orcid_id ', 'art_id=' . $article_id);
            $author_orcid = Articles::get_single_record('art_id,(select usr_orcid_id from ' . $users_table . ' where art_submitted_by = usr_id) as usr_orcid_id ', 'art_id= ?',binding_arr:[$article_id]);

            $confirm = FALSE;
            if ($author_orcid->usr_orcid_id != NULL) {
                $confirm = TRUE;
            }
        }
        if (!$confirm) {
            $priority_ref = 2; //2nd tab
            $priority = $priority !== "" && $priority < $priority_ref ? $priority : $priority_ref;
            $return_arr['message'] = customTrans('viewarticle.update_orcid_msg');
            $return = 'norecords';
            $return_arr['confirm'] = $confirm;
            return $return_arr;
        } else {
            $return_arr['confirm'] = $confirm;
            return $return_arr;
        }
    }
    public function email_manage($article_data)
    {

        $article_id=$article_data['article_id'];
        $artp_id=$article_data['art_type_id'];
        $core_role=$article_data['core_role'];
        $role_id=$article_data['role_id'];
        $role_name=$article_data['role_name'];
        $jnl_code=$article_data['jnl_code'];
        $jnl_id=$article_data['jnl_id'];
        $current_status_id=$article_data['current_status_id'];
        $get_article_advance_options=$article_data['get_article_advance_options'];
        $Email_templates = new \App\Models\Email_templates();
        $record = $Email_templates::get_single_record('*', "etmp_name='coauthor_account_notification' and         etmp_notification ='User'");
        $record_for_creation = $Email_templates::get_single_record('*', "etmp_name='coauthor_account_creation and etmp_notification' ='User'");
        if ($record != NULL || $record_for_creation != NULL) {
            $authors_table = (new \App\Models\Authors())->getTable();
            $userstable = (new \App\Models\User())->getTable();
            //get all co-authors
            //#4543 Manage author data listing (normalization)
            $tables = array(
                'main_table' => $authors_table,
                'join_table' => array(
                    $userstable => array($authors_table . '.auth_usr_id', $userstable . '.usr_id')
                )
            );
            $select_fields = 'auth_usr_id, usr_email as auth_email,auth_corr_author';
            $criteria = 'auth_art_id=' . $article_id;
            $get_all_co_authors = Authors::get_results_using_joins($tables, $select_fields, $criteria, 'all');
            if (!empty($get_all_co_authors)) {

                        foreach ($get_all_co_authors as $co_author) {
                            if ($record_for_creation != NULL) {
                                $Users = new \App\Models\User();

                                $check_usr_status = $Users::get_single_record_with_bind_cond('usr_status,usr_deeplink_token', array('usr_id' => $co_author->auth_usr_id));
                                if ($check_usr_status->usr_status == 'w' && $check_usr_status->usr_deeplink_token != '' && (isset($get_article_advance_options->atotp_co_authors_agreement) && $get_article_advance_options->atotp_co_authors_agreement == 'n')) {
                                    $link =URL::to('/') . "/confirmation/" . encrypt_link("&key=" . $check_usr_status->usr_deeplink_token . "&userid=" . $co_author->auth_usr_id."&name=coauthor_account_creation");

                                    $custom_data = array(
                                        'confirmation_link' => $link,
                                        'esl_etmp_action'=>'coauthor_new',
                                        'coauthor_notify'=>True,
                                        'jnl_id'=>$jnl_id,
                                        'jnl_code'=>$jnl_code,
                                        'article_id'=>$article_id,
                                        'artp_id'=>$artp_id,
                                        'aflw_id' => $current_status_id,

                                    );
                                    $email_data = array(
                                        'type' => 'global',
                                        'action' => 'send',
                                        'email_with_login' => TRUE,
                                        'user_id' => $co_author->auth_usr_id,
                                        'empt_name' => 'coauthor_account_creation',
                                        'jnl_user_role'=>array(
                                          'core_role'=>$core_role,
                                          'role_name'=>$role_name,
                                          'jnl_journal_code'=> $jnl_code
                                      ),
                                        'custom_data' => $custom_data
                                    );
                            
                                    $this->master_email_details($email_data);
                                }
                            }

                            if ($record != NULL && $co_author->auth_corr_author == 'n') {
                                
                                $custom_data = array(
                                    'esl_etmp_action'=>'coauthor_notify',
                                    'coauthor_notify'=>True,
                                    'jnl_id'=>$jnl_id,
                                    'jnl_code'=>$jnl_code,
                                    'article_id'=>$article_id,
                                    'artp_id'=>$artp_id,
                                    'aflw_id' => $current_status_id,
                                );
                                $email_data = array(
                                    'type' => 'global',
                                    'action' => 'send',
                                    'email_with_login' => TRUE,
                                    'user_id' => $co_author->auth_usr_id,
                                    'empt_name' => 'coauthor_account_notification',
                                    'jnl_user_role'=>array(
                                      'core_role'=>$core_role,
                                      'role_name'=>$role_name,
                                      'jnl_journal_code'=> $jnl_code
                                  ),
                                    'custom_data' => $custom_data
                                );
                        
                                $this->master_email_details($email_data);
                            }
                        }
            }
        }
    }

    public function event_manage($jnl_id, $article_id, $current_user)
    {
        //                         /*----start----#660 update evu_submit_status (from d to s) of table `rvw_event_invited_users` if invitation is from an event*/


        // $event_sql  =   'SELECT count(*) cnt
        // FROM `rvw_events` e
        // JOIN `rvw_event_invited_users` eiu ON (eiu.`evu_event_id` = e.`event_id`)
        // WHERE e.`event_journal_id` = ' . $jnl_id . ' AND eiu.`evu_art_id` = ' . $article_id . ' AND eiu.`evu_user_id` = ' . $current_user['user_id'] . ' AND eiu.`evu_submit_status` = "d"';
        $event_sql  =   'SELECT count(*) cnt
        FROM `rvw_events` e
        JOIN `rvw_event_invited_users` eiu ON (eiu.`evu_event_id` = e.`event_id`)
        WHERE e.`event_journal_id` = ? AND eiu.`evu_art_id` = ? AND eiu.`evu_user_id` = ' . $current_user['user_id'] . ' AND eiu.`evu_submit_status` = "d"';

        // $eve_record     =   Event_invited_users::get_records_by_raw_query($event_sql);
        $eve_record     =   Event_invited_users::get_records_by_raw_query($event_sql,binding_arr:[$jnl_id ,$article_id]);
        if ($eve_record[0]->cnt > 0) {
            $eve_data_list  =   array(
                'evu_submit_status' => 's',
            );
            // $eve_criteria   =   "evu_user_id={$this->current_user['user_id']} and evu_art_id ={$article_id} and evu_submit_status = d";
            $eve_criteria   =   "evu_user_id={$this->current_user['user_id']} and evu_art_id =? and evu_submit_status = d";

            // Event_invited_users::update_record($eve_data_list, $eve_criteria, $current_user);
            Event_invited_users::update_record($eve_data_list, $eve_criteria, $current_user,binding_arr:[$article_id]);
        }
    }
    public function update_article_table($article_id, $jnl_code, $cur_art_type_record)
    {
        // $stub_status = Articles::get_single_record('art_stub,art_stage_submission_method,art_submission_date,art_status', "art_id={$article_id}");
        $stub_status = Articles::get_single_record('art_stub,art_stage_submission_method,art_submission_date,art_status,art_es_document_status', "art_id= ?",binding_arr:[$article_id]);
        //update stub status on submission -- to manage overview -- pending invited papers
        $art_stub_stat = ($stub_status->art_stub != 'n') ? 'i' : $stub_status->art_stub;
        $art_status = 'y';
        if ($this->current_client->modules->mdl_review_for_doc == 'y') {
            $art_status = 'q';
        }
        $article_update_arr = array(
            'art_status' => $art_status,
            'art_pdf_status' => 'y',
            'art_stub' => $art_stub_stat,
            "art_submission_date" => date('Y-m-d H:i:s'),
            "art_decision_date" => date('Y-m-d H:i:s')
        );
        $esarray['article_id']=$article_id;
        $checkdata=$this->check_espermission_access($esarray);
        if(isset($checkdata) && $checkdata==false)
        {
            if($stub_status->art_es_document_status == 'a' && $stub_status->art_status == 'n')
            {
                $article_update_arr['art_es_document_status'] = 'n';  
            }
        }
        $submitted_article_code =NULL;
        if($stub_status->art_stage_submission_method == 'o' && $stub_status->art_status == 'n' && $stub_status->art_stage_submission_method == 'o' && $stub_status->art_submission_date == NULL)
        {
            $submitted_article_code = $this->create_article_code($cur_art_type_record->artp_id, $cur_art_type_record->artp_prefix_article_no);
            $article_update_arr['art_code'] = $submitted_article_code;
            $Journal_metadata = new \App\Models\Journal_metadata();
            // $journal_meta = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value', "jm_journal_code='" . $jnl_code . "' AND jm_client_id =" . $this->current_client->clnt_id);
            $journal_meta = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value',"jm_journal_code= ? AND jm_client_id = {$this->current_client->clnt_id}",binding_arr:[$jnl_code]);
        $iet_prefix = 'n';
        foreach ($journal_meta as $jnl_meta) {
            if ($jnl_meta->jm_meta_name == 'iet_prefix')
                $iet_prefix = $jnl_meta->jm_meta_value;
        }
        $doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
        $doi_details  = Config::get($doi);
        $article_doi = $this->create_article_doi($article_id, $doi_details, $iet_prefix, $submitted_article_code);
        $article_update_arr['art_doi'] = $article_doi['doi'];
        if(isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y'){
            app(ConveyService::class)->updateArticleDiscloserList($article_id, ['name' => $submitted_article_code, 'purpose' => "Conflict of Interest for manuscript $submitted_article_code"]);
        }
        }

        if ($this->current_client->modules->mdl_review_for_doc == 'y') {
            $article_update_arr['art_new_submission'] = 'y';
        }
        $update_biorxiv = 0; {
            if ($this->current_client->functionality->cfty_j2b_along_with_submission == 'y') {

                $Article_biorxiv_export = new \App\Models\Article_biorxiv_export();
                // $biorxiv_records = $Article_biorxiv_export::get_single_record('*', 'bexp_art_id=' . $article_id . ' and bexp_status=0');
                $biorxiv_records = $Article_biorxiv_export::get_single_record('*', 'bexp_art_id= ? and bexp_status=0',binding_arr:[$article_id]);
                if (!empty($biorxiv_records)) {
                    //print_r($biorxiv_records);
                    if ($biorxiv_records->bexp_interest_of_submit == 'y') {
                        $biorxiv = 'clients.' . $this->current_client->clnt_client_code . '.biorxiv.biorxiv';
                        $biorxiv_details  = Config::get($biorxiv);
                        $biorxiv_status = $this->submit_biorxiv($biorxiv_records, $biorxiv_details, $jnl_code);
                        if ($biorxiv_status['status'] == "success") {
                            // $update_biorxiv = $Article_biorxiv_export::update_record(array(
                            //     'bexp_status' => 1
                            // ), 'bexp_art_id=' . $article_id);
                            $update_biorxiv = $Article_biorxiv_export::update_record(array(
                                'bexp_status' => 1
                            ), 'bexp_art_id= ?',binding_arr:[$article_id]);
                            $article_update_arr['art_biorxiv'] = 'b';
                        } else {
                            //echo json_encode($biorxiv_status);
                            return $this->warning('Failed', 500, $biorxiv_status);
                        }
                        //print_r($biorxiv_status);
                    }
                }
            }
        }
        $return_arr['update_biorxiv'] = $update_biorxiv;
        // $result = Articles::update_record($article_update_arr, "art_id = {$article_id}");
        $result = Articles::update_record($article_update_arr, "art_id = ?",binding_arr:[$article_id]);
        $return_arr['result'] = $result;
        return $return_arr;
    }

    public function submit_biorxiv($biorxiv_records, $biorxiv_details, $jnl_code)
    {
        $clinical_trial_id = '';
        $distribution = '';
        $article_category = $biorxiv_records->bexp_biorxiv_article_category;
        $author_type = $biorxiv_records->bexp_biorxiv_author_type;
        $subject_code = $biorxiv_records->bexp_biorxiv_subject_code;
        $article_id = $biorxiv_records->bexp_art_id;
        $clinical_trial_id = $biorxiv_records->bexp_biorxiv_clinical_trial_id;
        $distribution = $biorxiv_records->bexp_distribution;
        $jnl_id = $biorxiv_records->bexp_jnl_id;
        $article_categories = $biorxiv_details['article_category'];
        $article_category_value = $article_categories[$article_category];
        $author_types = $biorxiv_details['author_type'];
        $author_type_value = $author_types[$author_type];
        $Biorxiv_subject_code = new \App\Models\Biorxiv_subject_code();
        $biorxiv_subject_code = $Biorxiv_subject_code::get_single_record('brx_subcode_name', 'brx_subcode_id=' . $subject_code);

        $current_year = date("Y");
        $file_name = $jnl_code . '-' . $current_year . '-' . $article_id;
        $folder_path = "uploads";
        $folder_path_xml = $folder_path . '/' . "biorxiv_reviewj2b/" . $file_name;
        //$folder_path_xml = $folder_path . '/' . $time;
        if (!file_exists($folder_path_xml))
            mkdir($folder_path_xml, 0777, TRUE);

        //$file_location = $folder_path_xml . '/bmjos-'. time() . '.xml';
        $file_location = $folder_path_xml . '/' . $file_name . '.xml';
        $data = helperData('FCPATH');
        $destination = $data['FCPATH'] . $file_location;

        $article_type_table = (new \App\Models\Article_types())->getTable();
        $journals_table = (new \App\Models\Journals())->getTable();

        $article_data = Articles::get_single_record('*,art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,(select artp_abbr_article_type from ' . $article_type_table . ' where artp_id = art_artp_id) as artp_code,(select artp_article_type from ' . $article_type_table . ' where  artp_id = art_published_article_type) as published_artp_name,(select jnl_journal_code from ' . $journals_table . ',' . $article_type_table . ' where jnl_id = artp_jnl_id and  artp_id = art_artp_id) as jnl_code', 'art_id=' . $article_id);

        $xml_string = '<?xml version="1.0" ?>
<!DOCTYPE article SYSTEM "JATS-Archiving-1-1-MathML3-DTD/JATS-archivearticle1-mathml3.dtd"><article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsi="http://www.w3.org/2001/XMLSchemainstance" dtd-version="1.1" xml:lang="en"></article>';

        file_put_contents($file_location, $xml_string);

        $doc = new \DOMDocument();
        $doc->formatOutput = false;
        $doc->load($destination);

        $xpath = new \DOMXpath($doc);
        $root_element = $xpath->query('//article');

        $front = $doc->createElement('front');
        //journal-meta starting
        $journal_meta_node = $doc->createElement('journal-meta');

        $Journal_metadata = new \App\Models\Journal_metadata();
        $journal_meta = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value', array(
            'jm_journal_code' => $this->jnl_data->jnl_journal_code,
            'jm_client_id' => $this->current_client->clnt_id,
        ));
        $client_code = $this->current_client->clnt_client_code;
        $ppub = '';
        $epub = '';
        $iet_prefix = 'n';
        $publisher_name = 'BMJ';
        $copyright_statement = '&#xA9; Posted by BMJOS';
        foreach ($journal_meta as $jnl_meta) {
            if ($jnl_meta->jm_meta_name == 'e_issn')
                $epub = $jnl_meta->jm_meta_value;
            elseif ($jnl_meta->jm_meta_name == 'issn')
                $ppub = $jnl_meta->jm_meta_value;
            elseif ($jnl_meta->jm_meta_name == 'iet_prefix')
                $iet_prefix = $jnl_meta->jm_meta_value;
        }
        $pub = array(
            'epub' => $epub,
            'ppub' => $ppub,
            'iet_prefix' => $iet_prefix,
        );

        //load doi library
        $doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
        $doi_details  = Config::get($doi);
        $DOI_data = $this->create_article_doi($article_id, $doi_details, $iet_prefix);

        $DOI_data['doi_details'] = $doi_details;
        //journal-id
        $delivering_vendor_id = 'rvtech';
        $journal_id_node = $doc->createElement('journal-id', $delivering_vendor_id);
        $journal_id_node->setAttribute('journal-id-type', 'delivering-vendor-id');
        $journal_meta_node->appendChild($journal_id_node);
        $journal_publisher_id = 'bmj'; //suggested by gijo
        //$journal_id_node = $doc->createElement('journal_id', 'IET-RPG');
        $journal_id_node = $doc->createElement('journal-id', $journal_publisher_id);
        $journal_id_node->setAttribute('journal-id-type', 'delivering-publisher-id');
        $journal_meta_node->appendChild($journal_id_node);
        $upper_journal_code = strtoupper($this->jnl_data->jnl_journal_code);
        $journal_id_node = $doc->createElement('journal-id', $upper_journal_code);
        $journal_id_node->setAttribute('journal-id-type', 'delivering-journal-code');
        $journal_meta_node->appendChild($journal_id_node);
        $journal_destination = 'biorxiv';
        //$journal_id_node = $doc->createElement('journal_id', 'IET-RPG');
        $journal_id_destination = $doc->createElement('journal-id', $journal_destination);
        $journal_id_destination->setAttribute('journal-id-type', 'destination-journal-code');
        $journal_meta_node->appendChild($journal_id_destination);
        //starting article meta
        $article_meta_node = $doc->createElement('article-meta');
        //set article categories
        $article_categories_node = $doc->createElement('article-categories');
        //set subj group
        //set subject
        $subj_group = $doc->createElement('subj-group');
        $subj_group->setAttribute('subj-group-type', 'subjcode');
        $subject = $doc->createElement('subject', $biorxiv_subject_code->brx_subcode_name);
        $subj_group->appendChild($subject);
        $article_categories_node->appendChild($subj_group);
        $subj_group = $doc->createElement('subj-group');
        $subj_group->setAttribute('subj-group-type', 'toc-category');
        //set subject
        $subject = $doc->createElement('subject', $article_category_value);
        $subj_group->appendChild($subject);
        $article_categories_node->appendChild($subj_group);
        $subj_group = $doc->createElement('subj-group');
        $subj_group->setAttribute('subj-group-type', 'article-type');
        //set subject
        $subject = $doc->createElement('subject', $author_type_value);
        $subj_group->appendChild($subject);
        $article_categories_node->appendChild($subj_group);
        $article_meta_node->appendChild($article_categories_node);
        //set title group
        $title_group_node = $doc->createElement('title-group');
        $article_title_node = $doc->createElement('article_title');
        $art_title = str_replace(array(
            '<p>',
            '</p>'
        ), "", $article_data->art_title);
        $art_title = html_entity_decode($art_title);
        $article_title_node_content = $this->convert_html_to_xml($art_title, $doc, $article_title_node, 'article_title_id');
        $title_group_node->appendChild($article_title_node);
        //append title group node to article meta
        $article_meta_node->appendChild($title_group_node);

        //set contrib-group
        $contrib_group_node = $doc->createElement('contrib-group');
        $User_table = (new \App\Models\User())->getTable();
        // #4544 Manage author  data listing(normalization)
        $author_data = Authors::get_all_records('*,(select usr_title as auth_title , usr_first_name as auth_first_name , usr_last_name as auth_last_name , usr_email as auth_email ,usr_website, usr_phone_no as auth_phone , usr_orcid_id from ' . $User_table . ' where auth_usr_id = usr_id) as orcid_id', 'auth_art_id=' . $article_data->art_id);
        //set author data
        $j = 0;
        $co_author_email = '';
        foreach ($author_data as $author) {
            //set contrib
            $contrib_node = $doc->createElement('contrib');
            $contrib_node->setAttribute('contrib-type', 'author');

            //add corresp attribute
            if ($author->auth_corr_author == 'y')
                $contrib_node->setAttribute('corresp', 'yes');

            //add orcid id
            if ($author->orcid_id != NULL) {
                $contrib_id_node = $doc->createElement('contrib-id', $author->orcid_id);
                $contrib_id_node->setAttribute('contrib-id-type', 'orcid');
                $contrib_node->appendChild($contrib_id_node);
            }

            //add author name
            $name_node = $doc->createElement('name');
            //$name_node->setAttribute('name-style', 'western');
            //add surname
            $surname_node = $doc->createElement('surname', $author->auth_last_name);
            $name_node->appendChild($surname_node);
            //add given name
            $given_name_node = $doc->createElement('given-names', $author->auth_first_name);
            $name_node->appendChild($given_name_node);
            $contrib_node->appendChild($name_node);
            //append name node to contrib node
            //add author affiliation
            $Authors_affiliation = new \App\Models\Authors_affiliation();
            $Country_table = (new \App\Models\Country())->getTable();
            $author_affiliation_data = $Authors_affiliation::get_all_records('*,(select cnt_country from ' . $Country_table . ' where cnt_id = auaff_cnt_id) as aff_country', 'auaff_auth_id=' . $author->auth_id);
            if (count($author_affiliation_data) > 0) {

                foreach ($author_affiliation_data as $auth_aff) {
                    $auth_aff_node = $doc->createElement('address');
                    //set department as address-line
                    if ($auth_aff->auaff_department != '') {
                        $addr_line_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_department));
                        $auth_aff_node->appendChild($addr_line_node);
                    }

                    //set auaff_address_line1
                    if ($auth_aff->auaff_address_line1 != '') {
                        $addr_line_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_address_line1));
                        $auth_aff_node->appendChild($addr_line_node);
                    }
                    //set auaff_address_line2
                    if ($auth_aff->auaff_address_line2 != '') {
                        $addr_line_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_address_line2));
                        $auth_aff_node->appendChild($addr_line_node);
                    }
                    //set 	country
                    if ($auth_aff->aff_country != '') {
                        $country_node = $doc->createElement('country', $auth_aff->aff_country);
                        $auth_aff_node->appendChild($country_node);
                    }
                    //set auaff_phone
                    if ($auth_aff->auaff_phone != '') {
                        $phone_node = $doc->createElement('phone', $auth_aff->auaff_phone);
                        $auth_aff_node->appendChild($phone_node);
                    }

                    if ($auth_aff->auaff_postal_code != '') {
                        //set 	auaff_postal_code
                        $addr_line_node = $doc->createElement('postal-code', $auth_aff->auaff_postal_code);
                        $auth_aff_node->appendChild($addr_line_node);
                    }


                    if ($author->auth_email != '') {
                        $email_node = $doc->createElement('email', $author->auth_email);
                        $auth_aff_node->appendChild($email_node);
                    }

                    //set auaff_company
                    if ($auth_aff->auaff_company != '') {
                        $institution_node = $doc->createElement('institution', $auth_aff->auaff_company);
                        $auth_aff_node->appendChild($institution_node);
                    }
                    $contrib_node->appendChild($auth_aff_node);
                }
            } else {
                $result['status'] = 'failed';
                $result['msg'] = customTrans('viewarticle.j2b_aff_error');
                return $result;
            }

            //append contrib node to contrib group node
            $contrib_group_node->appendChild($contrib_node);


            //append contrib_group_node to article meta node
            $article_meta_node->appendChild($contrib_group_node);
        }


        //set permission node
        $permission_node = $doc->createElement('permissions');
        //set copyright statement
        $license_node = $doc->createElement('license');
        $license_node->setAttribute('license-type', 'reuse');
        $license_p_node = $doc->createElement('license-p', $distribution);
        $license_node->appendChild($license_p_node);
        //$copyright_stt_node = $doc->createElement('copyright-statement', $copyright_statement);
        //append copyright statement to permission node
        $permission_node->appendChild($license_node);


        //append permission_node to article meta node
        $article_meta_node->appendChild($permission_node);


        $abstract_node = $doc->createElement('abstract');
        $abstract_node->setAttribute('abstract-type', 'abstract');
        $abstract_p_node = $doc->createElement('p');
        //$abstract_p_node = $doc->createElement('p', strip_tags($article_data->art_abstract));

        $art_content = str_replace(array(
            '<p>',
            '</p>'
        ), "", $article_data->art_abstract);
        $art_content = html_entity_decode($art_content);
        $article_title_node_content = $this->convert_html_to_xml($art_content, $doc, $abstract_p_node, 'abstract_content');
        $abstract_node->appendChild($abstract_p_node);

        //append abstract_node to article meta node
        //$article_meta_node->appendChild($abstract_node);
        //end article meta
        //append abstract_node to article meta node
        $article_meta_node->appendChild($abstract_node);
        //end article meta

        $custom_meta_node = $doc->createElement('custom-meta-group');

        if ($biorxiv_subject_code->brx_subcode_name == "Clinical Trials" && $clinical_trial_id != '') {
            $custom_node = $doc->createElement('custom-meta');
            $meta_name = $doc->createElement('meta-name', 'clinical_trial_id');
            $meta_value = $doc->createElement('meta-value', $clinical_trial_id);
            $custom_node->appendChild($meta_name);
            $custom_node->appendChild($meta_value);
            $custom_meta_node->appendChild($custom_node);
        }

        $custom_node2 = $doc->createElement('custom-meta');
        $meta_name = $doc->createElement('meta-name', 'author_approval');
        $meta_value = $doc->createElement('meta-value', 'true');
        $custom_node2->appendChild($meta_name);
        $custom_node2->appendChild($meta_value);

        $custom_meta_node->appendChild($custom_node2);
        $article_meta_node->appendChild($custom_meta_node);



        $front->appendChild($journal_meta_node);
        $front->appendChild($article_meta_node);

        $root_node = $root_element->item(0);
        //$notes_node = $doc->createElement('notes', " ");
        //$front->appendChild($notes_node);
        $root_node->appendChild($front);
        $doc->saveXML();
        $doc->save($file_location);

        $result = $this->create_transfer_files($article_data, $article_id, $jnl_code, $file_location, $file_name);
        //echo json_encode($result);
        return $result;
    }

    private function create_transfer_files($article_data, $article_id, $jnl_code, $file_location, $file_name)
    {

        $current_user = $this->current_user;
        $path = 'uploads/' . $article_data->art_article_upload_path;
        //$folder_name = $article_data->art_code;


        $folder_path = "uploads/biorxiv_reviewj2b/" . $file_name;
        //$folder_path="uploads/biorxiv_reviewb2j/bmjos-".time();
        if (!file_exists($folder_path)) {
            mkdir($folder_path, 0777, TRUE);
        }
        $Article_pdf = new \App\Models\Article_pdf();
        $Article_pdf_table = ($Article_pdf)->getTable();
        $where_cnd = ' `pdf_id` = (select max(`pdf_id`) from ' . $Article_pdf_table . ' where `pdf_art_id` = ' . $article_id . '  and `pdf_show_status`= \'y\')';

        $article_pdf = $Article_pdf::get_single_record('pdf_name', $where_cnd);
        //copy article final pdf
        if (count($article_pdf) > 0) {

            //$folder_path_pdf = $folder_path . '/biorxiv-'.time(). '/pdf';
            if (!file_exists($folder_path))
                mkdir($folder_path, 0777, TRUE);
            if (file_exists($path . '/' . $article_pdf->pdf_name) && $article_pdf->pdf_name != '') {
                if (number_format(filesize($path . '/' . $article_pdf->pdf_name) / 1048576, 2) > 19) {
                    $result['status'] = 'failed';
                    $result['msg'] = customTrans('viewarticle.j2b_pdf_size_limit');
                    //echo json_encode($result);
                    return $result;
                }

                copy($path . '/' . $article_pdf->pdf_name, $folder_path . '/' . $file_name . ".pdf");
            }
        }


        $result['msg'] = customTrans('viewarticle.j2b_error');
        $biorxiv = 'clients.' . $this->current_client->clnt_client_code . '.biorxiv.biorxiv';
        $ftp_details  = Config::get($biorxiv);
        $file_name_pdf = $file_name . '.pdf';
        $data = helperData('FCPATH');
        $folder_path = $data['FCPATH'] . $folder_path;

        $result_pdf = $this->upload_to_server_j2b($folder_path . '/' . $file_name . '.pdf', $jnl_code, $file_name_pdf, $ftp_details);
        if ($result_pdf['status'] == "success") {

            $file_name_xml = $file_name . '.xml';
            $result_xml = $this->upload_to_server_j2b($folder_path . '/' . $file_name . '.xml', $jnl_code, $file_name_xml, $ftp_details);
            if ($result_xml['status'] == "success") {
                $file_name_go = $file_name . '.go.xml';
                $destination = $this->set_server_path($ftp_details['j2b']['location'], 'ftp', $jnl_code, FALSE);
                $file_location = $folder_path . '/' . $file_name . '.go' . '.xml';
                $file_xml_content = '<?xml version="1.0"?><ingest type="bpress"><metadata-filename name="' . $file_name_xml . '"/><pdf-filename name="' . $file_name_pdf . '"/><vendor-id>rvtech</vendor-id><reference-id>' . $file_name . '</reference-id></ingest>';

                file_put_contents($file_location, $file_xml_content);
                $result_go_xml = $this->upload_to_server_j2b($file_location, $jnl_code, $file_name . '.go.xml', $ftp_details);
                if ($result_go_xml['status'] == "success") {

                    //$this->delfolder($folder_path);
                    $result['status'] = 'success';
                    $result['msg'] = customTrans('viewarticle.j2b_success');
                    $result['log_msg'] = customTrans('viewarticle.j2b_success');
                } else {
                    $result['status'] = 'failed';
                    $result['log_msg'] = customTrans('viewarticle.j2b_go_err');
                }
            } else {
                $result['status'] = 'failed';
                $result['log_msg'] = customTrans('viewarticle.j2b_xml_err');
            }
        } elseif ($result_pdf['status'] == "failed") {
            $result['status'] = 'failed';
            $result['log_msg'] = customTrans('viewarticle.j2b_pdf_err');
        } else {
            $result['status'] = 'connection failed';
            $result['log_msg'] = customTrans('viewarticle.j2b_connect_failed');
            $result['msg'] = customTrans('viewarticle.j2b_connect_failed');
        }
        //add data to log file
        $data = helperData('FCPATH');
        $app_data = helperData('APP_DOC_PATH');
        $log_file_location = $data['FCPATH'] . $app_data['PATH'] . 'biorxiv_reviewj2b/log';
        if (!file_exists($log_file_location))
            mkdir($log_file_location, 0777, TRUE);

        $log_data = array(
            "server_details" => $_SERVER,
            "result" => $result,
            "article_data" => $article_data,
            "file_name" => $file_name
        );
        //$log_data = $this->load->view('workflow/generate_log', $log_data, TRUE);
        file_put_contents($log_file_location . '/J2B_log_' . date("d.m.Y") . '.log', $log_data, FILE_APPEND);

        return $result;
    }

    public function upload_to_server_j2b($source, $jnl_code, $dest_file, $ftp_details)
    {

        $upload_status['status'] = 'failed';
        $host = $ftp_details['j2b'];
        $journal_folder = FALSE;
        //EXPORT USING FTP
        $destination = $this->set_server_path($host['location'], 'ftp', $jnl_code, $journal_folder);
        $hostname = $host['hostname'];
        $res = $this->upload_file_sftp_server($source, $host, $dest_file, $destination);
        if ($res === TRUE) {
            $upload_status['status'] = 'success';
        } else if ($res === 'connect failed') {
            $upload_status['status'] = 'connection failed';
        }
        return $upload_status;
    }

    private function set_server_path($path, $upload_mode, $jnl_code, $jnl_floer = TRUE)
    {
        $ftp_location = '';
        if ($path != '') {

            $ftp_location = $this->set_path_slash($path, FALSE);
            if ($jnl_floer == TRUE) {
                $ftp_location .= '/' . $jnl_code;
            }
        } else {
            if ($jnl_floer == TRUE) {
                $ftp_location = '/' . $jnl_code;
            } elseif ($upload_mode == 'shell') {
                $ftp_location = '/';
            }
        }

        return $ftp_location;
    }
    public function get_zip_info(Request $request)
	{
      try
      {
          $post_data=$request->all();
          $validator = Validator::make($request->all(), [
            'art_id' => 'required',
            'att_id'=>'required'
            // 'user_id' => 'required',
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }

        $article_id=$this->decrypt_data($post_data['art_id']);
        $attachment_id=$this->decrypt_data($post_data['att_id']);
	$article_data =Articles::get_single_record('art_article_upload_path,art_artp_id',"art_id={$article_id}");
		$attchment_details =Attachment_files::get_single_record('atmnt_orginal_upload_path,atmnt_file_name',"atmnt_id={$attachment_id}");

		//$upload_dir = APP_DOC_PATH . $article_data->art_article_upload_path . DIRECTORY_SEPARATOR;

       // $upload_dir = APP_DOC_PATH . $attchment_details->atmnt_orginal_upload_path . DIRECTORY_SEPARATOR;
       // $path=$this->get_upload_data(ABS_PATH.$attchment_details->atmnt_orginal_upload_path.'/'.$attchment_details->atmnt_file_name,TRUE,NULL,'public');
       $path=public_path(ABS_PATH.$attchment_details->atmnt_orginal_upload_path.'/'.$attchment_details->atmnt_file_name);

       // $path=public_path(ABS_PATH.$attchment_details->atmnt_orginal_upload_path.'/'.$attchment_details->atmnt_file_name);
		$art_typ_rec =Article_type_advance_options::get_single_record('atotp_file_type',"atotp_artp_id={$article_data->art_artp_id}");
		$art_file_type = json_decode($art_typ_rec->atotp_file_type);

		$za = new \ZipArchive();

		$za->open($path);

		$file_array = array();
		$not_cnt = 0;
		if ($za->numFiles > 0)
		{
            $file_array=[];
			for ($i = 0; $i < $za->numFiles; $i++)
			{

				$child_array=array();
				$stat = $za->statIndex($i);
				if ($stat['size'])
				{
					$child_array['name'] = $stat['name'];
					$ext = pathinfo($stat['name'], PATHINFO_EXTENSION);
                    $pattern = '/^[A-Za-z0-9-\/_.()\s(\w+\s?)]+$/';
                    $pattern_adjacent_space = '/\s\s+/';
					$status = 's';
					if (!(in_array('.' . strtolower($ext), $art_file_type))&&!(in_array(strtolower($ext), $art_file_type)))
					{
						$not_cnt++;
						$status = 'n';
					}
                    else if(!preg_match($pattern, $stat['name']))
                    {
                        $not_cnt++;
						$status = 'n';
                    }
                    else if(preg_match($pattern_adjacent_space, $stat['name']))
                    {
                        $not_cnt++;
						$status = 'n';
                    }
					$child_array['status'] = $status;
				}
                if(!empty($child_array))
                array_push($file_array,$child_array);
			}
		}


		$data['status_array'] = array(
			's' => 'Supported',
			'n' => 'Not supported');

		$data['file_array'] = $file_array;
		$data['not_cnt'] = $not_cnt;
		$data['atmnt_id'] = $attachment_id;
		$data['article_id'] = $article_id;
        return  $this->success('Success', 200, $data);
        }
        catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
            }
    }

    public function extract_zip_file(Request $request)
	{
        try
        {
		$post_data = $request->all();

        $validator = Validator::make($request->all(), [
            'attach_id' => 'required',
            'art_id'=>'required',
            'artflow_id' => 'required',
            'platform_code'=>'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        $return_array=array();
		$attachment_id = $this->decrypt_data($post_data['attach_id']);
		$article_id =$this->decrypt_data($post_data['art_id']);
		 $artflow_id = $this->decrypt_data($post_data['artflow_id']);
        $platform_code=$post_data['platform_code'];
		$attach_url = 'upload-attachments';
		$attach_tot_size = $post_data['attach_tot_size'];
		$extract_file_size = 0;
       $this->current_user=$this->get_current_user_details();
		$article_data =Articles::get_single_record('art_article_upload_path,art_artp_id',"art_id={$article_id}");
		$article_type = Article_types::get_single_record('artp_abbr_article_type',"artp_id={$article_data->art_artp_id}");
		$attchment_details =Attachment_files::get_single_record('atmnt_orginal_upload_path,atmnt_file_name',"atmnt_id={$attachment_id}");

		//$upload_dir = APP_DOC_PATH . $article_data->art_article_upload_path . DIRECTORY_SEPARATOR;
		//$upload_dir = APP_DOC_PATH . $attchment_details->atmnt_orginal_upload_path . DIRECTORY_SEPARATOR;
      //  $upload_dir=$this->get_upload_data("app/public/".$attchment_details->atmnt_orginal_upload_path.DIRECTORY_SEPARATOR,TRUE,NULL,'asset');


      $upload_dir=public_path(ABS_PATH.$attchment_details->atmnt_orginal_upload_path);
    //
		$art_typ_rec = Article_type_advance_options::get_single_record('atotp_file_type,atotp_file_description',"atotp_artp_id={$article_data->art_artp_id}");

		$file_description_data = Required_file_type::get_all_records('*',"rft_artp_id={$article_data->art_artp_id}");
		$file_description_arr = array();
		if (!empty($file_description_data))
		{
			foreach ($file_description_data as $fd)
			{
				array_push($file_description_arr, $fd->rft_file_desp_id);
			}
			$file_description = implode(',', $file_description_arr);
		}
		$art_typ_rec->description = $file_description;


		$allowd_filetype_arr = array();
		if ($art_typ_rec->atotp_file_type != '')
		{
			$temp_string = str_replace('.', '', $art_typ_rec->atotp_file_type);
			$allowd_filetype_arr = json_decode($temp_string);
		}

        //DB::beginTransaction();
		$attch_files = $this->zip_extract($upload_dir."/", $attchment_details->atmnt_file_name, $allowd_filetype_arr,$attchment_details->atmnt_orginal_upload_path);
		// checking extract file size exceeded
        if(!empty($attch_files))
        {

		foreach ($attch_files as $attch)
		{

			$extract_file_size += $attch['filesize'];
		}

		$extract_file_size = $this->file_size_convert_to_kb($extract_file_size) / 1000;
		$total_size = $attach_tot_size + $extract_file_size;
	$upload_file_size_config=$this->get_uploaded_file_size_config();
	$entire_size= isset($upload_file_size_config['max_entire_file']) ? $upload_file_size_config['max_entire_file'] : "200";
     if(isset($upload_file_size_config['max_entire_file']))
     {
	$single = str_replace('##FILE_SINGLE_SIZE##', $upload_file_size_config['max_single_file_mb'],customTrans('messagelang.generic_file_size_limit_description'));
	$file_size_description = str_replace('##FILE_ENTIRE_SIZE##', $upload_file_size_config['max_entire_file'], $single);
	 }
	 else
	 {
		 $file_size_description=customTrans('messagelang.file_size_limit_description');

	 }
		if ($total_size > $entire_size)
		{
          //  DB::commit();
            return  $this->warning('Warning', 200,$file_size_description);

		}
		unlink($upload_dir.'/' . $attchment_details->atmnt_file_name);
		$link_array = explode('/', explode('?', $_SERVER['HTTP_REFERER'])[0]);

		$article_editable = FALSE; //only for author upload
		if (trim($attach_url) == 'upload-attachments')
			$article_editable = TRUE;
            $update_attachment_table_array['attach_file'] = $attch_files;
            $update_attachment_table_array['article_id'] = $article_id;
            $update_attachment_table_array['article_type_id'] = $article_data->art_artp_id;
            $update_attachment_table_array['allowed_file_type'] = $art_typ_rec;
            $update_attachment_table_array['article_type_code'] = $article_type->artp_abbr_article_type;
            $update_attachment_table_array['article_upload_path'] = $article_data->art_article_upload_path;
            $update_attachment_table_array['artflow_id'] = $artflow_id;
            $update_attachment_table_array['article_editable'] = $article_editable;
            $update_attachment_table_array['author_attachment'] = TRUE;
            $update_attachment_table_array['platform_code'] = $platform_code;

		$attch_result = $this->update_to_attachment_table($update_attachment_table_array);
		Attachment_files::delete_records("atmnt_id={$attachment_id}", '', $this->current_user);


		$file_id_arr = $attch_result['file_id_arr'];
		$has_tex_file = $attch_result['has_tex_file'];


		$view_pdf_link = $ithenticate_link = '';
		//* end -- fetching article attachments*//

		$get_pdf_status = $this->get_article_pdf_status($article_id, TRUE);
		if ($get_pdf_status['status'] == TRUE)
		{
			$pdfStatus = $this->update_article_pdf_status($article_id, 'y');
			$view_pdf_link = $get_pdf_status['view_pdf_link'];
			$ithenticate_link = $get_pdf_status['ithenticate_link'];
		}
		else
		{
			$pdfStatus = $this->update_article_pdf_status($article_id, 'n');
		}
		//$success_msg = (empty($attch_files)) ? lang('zip_extract_unsupported') : lang('zip_extract_success');
        $return_array['attch_file_id']=$file_id_arr;
        $return_array['has_tex_file']=$has_tex_file;
        $return_array['view_pdf_link']=$view_pdf_link;
        $return_array['ithenticate_link']=$ithenticate_link;
        $return_array['extract_file_size']=$total_size;
		return  $this->success('Success', 200, $return_array);
     }
     else
     {
        return $this->warning('Warnings',200,array('msg' => 'zip_extraction_failed'));
     }

    }
    catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
        }
	}


    public function get_funding_info(Request $request)
	{
     try {
        $post_data = $request->all();
        $return_array= array();
        if ($post_data['search_text']) {
            $search_txt = $post_data['search_text'];
            $search_txt = rawurlencode($search_txt);
            // $url = 'http://api.crossref.org/funders?query=' . $search_txt;
            // $header = array(
            //     'Accept: application/json'
            // );
            // $response_data = $this->curl_intialize($url, array(), $header);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'http://api.crossref.org/funders?query=' . $search_txt);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Accept: application/json'));

            $funders_info = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $funders_list = array();

            if ($httpCode == 200) {
                if ($funders_info) {
                    $funders_info = json_decode($funders_info, true);
                    foreach ($funders_info['message']['items'] as $key => $funder_info) {
                        $funders_list[$key]['id'] = '';
                        $funders_list[$key]['unique_id'] = $funder_info['id'];

                        $funders_list[$key]['value'] = $funder_info['name'] . ' (' . $funder_info['location'] . ')';
                        $funders_list[$key]['funder_name'] = $funder_info['name'];
                        $funders_list[$key]['location'] = $funder_info['location'];
                        $funders_list[$key]['uri'] = $funder_info['uri'];
                    }
                }
            } else {
                $funders = new \App\Models\Funders();
                $funders_table = (new \App\Models\Funders())->getTable();

                $select = 'CONCAT(funder_name, " (",funder_location,")") as value, funder_name, funder_unique_id, funder_location, funder_uri, funder_id';
                $where =
                    "funder_name LIKE '%{$search_txt}%'";

                $funders_info = $funders::get_all_records($select, $where);

                if ($funders_info) {
                    foreach ($funders_info as $key => $funder_info) {
                        $funders_list[$key]['id'] = $funder_info->funder_id;
                        $funders_list[$key]['unique_id'] = $funder_info->funder_unique_id;
                        $funders_list[$key]['value'] = $funder_info->value;
                        $funders_list[$key]['funder_name'] = $funder_info->funder_name;
                        $funders_list[$key]['location'] = $funder_info->funder_location;
                        $funders_list[$key]['uri'] = $funder_info->funder_uri;
                    }
                }
            }
            if (count($funders_list) > 0) {
                $return_array['funders_list'] = $funders_list;
            }else{
                $funders_list[0]['id']          = '';
                $funders_list[0]['unique_id']   = '';
                $funders_list[0]['value']       = '';
                $funders_list[0]['funder_name'] = $post_data['search_text'];
                $funders_list[0]['location']    = '';
                $funders_list[0]['uri']         = '';
                $return_array['funders_list']   = $funders_list;
            }

            return $this->success('Success', 200, $return_array);

            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }

    public function check_author_contributorship($art_id)
    {
        try
        {
            // $all_authors = Authors::get_all_records('auth_id', 'auth_art_id = ' . $art_id);
            $all_authors = Authors::get_all_records('auth_id', 'auth_art_id = ?',binding_arr:[$art_id]);
            $carsai_credit = TRUE;
            if(!empty($all_authors))
            {
                foreach($all_authors as $author)
                {
                    $Author_credits = new \App\Models\Author_credits();
                    $casrai_credits = $Author_credits::get_casrai_credits($author->auth_id);
                    if(empty($casrai_credits))
                    {
                    $carsai_credit = FALSE;
                    }
                }
            }
            return $carsai_credit;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }



    public function get_author_by_email_search(Request $request)
    {
        try {
            $post_data = $request->all();
            $author_mail = trim($post_data['email']);
            $article_id = $this->decrypt_data($post_data['article_id']);
            $unreg_requst_usr = false;
            $user_assigned_as_reviewer = false;
            $user_assigned_article = false;
            $user_unregister = new \App\Models\User_unregister;
            $Article_reviewers=new \App\Models\Article_reviewers();
            $this->current_user = $this->get_current_user_details();
            $current_email=	User::get_single_record('usr_email',"usr_id = {$this->current_user['user_id']}");

if($author_mail==$current_email->usr_email)
		{
					$return_array['success'] = 'Logged_user';
					$return_array['msg'] = 'Logging user cannot be invited';
                    return  $this->success('Success', 200, $return_array);
		}
    else{
        // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
            $return_array['client_fieldvalid']  = $this->get_clientfieldrequired_functionalities();
            if($this->current_client->functionality->cfty_user_unregister_account == 'y')

			{
				$user_confirm = User::get_single_record('usr_id',"usr_email = '{$author_mail}'");
				if(!empty($user_confirm))
				{
					$user_unregtr = $user_unregister::get_single_record('count(uur_id) as cnt',"uur_usr_id ='{ $user_confirm->usr_id}'");
					if($user_unregtr-> cnt != 0)
					{
						$unreg_requst_usr =  TRUE;
					}
				}
			}
            if($unreg_requst_usr == FALSE)
			{
                $user_already_present = User::get_single_record('usr_id',"usr_email = '{$author_mail}'");
                if(!empty($user_already_present))
				{
					$review_condition = "'sorw_suggested_reviewer_id'={$user_already_present->usr_id} AND 'sorw_art_id' ={$article_id}";
					$reviewer_found = $Article_reviewers::get_single_record('sorw_id',$review_condition);
					if(!empty($reviewer_found))
					{
						$user_assigned_as_reviewer = TRUE;
					}
			        if(isset($user_already_present->usr_id)) {
                        $user_assigned_article=$this->check_user_assigned_article($user_already_present->usr_id,$article_id);
                    }

				}

            if($user_assigned_as_reviewer == FALSE && $user_assigned_article == FALSE)
            {
                $j_id = ($post_data['jnl_standalone'] == 'y') ? $post_data['jnl_id'] : null;
                $condition = "usr_email='{$author_mail}' and (`usr_roles` NOT LIKE '%sudo%' OR `usr_roles` IS NULL) and (usr_status IN ('a','w','s','n')) ";
				$user_data = User::get_user_by_email_journal($condition, $j_id);
                /*TASK #8671 Prevent Adding Duplicate Authors or Co-Authors to an Article*/
                $authors_table = (new \App\Models\Authors())->getTable();
                $user_table = (new \App\Models\User())->getTable();
                if ($article_id && $user_data && !$user_data->isEmpty() && isset($user_data[0]->usr_id))  {
                    $criteria = "auth_art_id={$article_id} AND auth_usr_id={$user_data[0]->usr_id}";
                    $select_fields = 'usr_title as auth_title,usr_first_name as auth_first_name,usr_last_name as auth_last_name ,auth_id,auth_usr_id,auth_art_id,auth_corr_author,auth_confirm_status';
                    $tables = array(
                    'main_table' => $authors_table,
                    'join_table' => array(
                        $user_table => array($authors_table . '.auth_usr_id', $user_table . '.usr_id')
                    )
                    );
                    $check_author = Authors::get_results_using_joins($tables, $select_fields, $criteria, 'single');
                    if (isset($check_author) && !empty($check_author)) {
                        $role = ($this->current_client->modules->mdl_review_for_doc == 'y') ? 'author' : 'co-author';
                        $msg = sprintf('This user has already been added as %s', $role);
                        $return_array['success'] = 'already_added';
					    $return_array['msg'] = sprintf('This user has already been added as %s', $role);
                    return  $this->success('Success', 200, $return_array);
                    }
        }       
        /*end TASK #8671 Prevent Adding Duplicate Authors or Co-Authors to an Article*/
                $hasuser = 0;
				$ret_html = '';
				$cur_user_aff = array();
				$aff_html = '';
				$has_aff = 0;
				if (!empty($user_data[0])) {

                    $email=protect_email($user_data[0]->usr_email);
                    $phone='';
                    $user_data[0]->hdn_user_id = encrypt_link($user_data[0]->usr_id);
                    if($user_data[0]->usr_phone_no!=null||$user_data[0]->usr_phone_no!='')
                   { $phone=protect_phoneno($user_data[0]->usr_phone_no);}
                    $return_array['user_email'] = $email;
                    $return_array['phone_no'] = $phone;

                    if ($user_data[0]->usr_status != 's' && $user_data[0]->usr_status != 'n') {
                        $hasuser = 1;
						$user_id = $user_data[0]->usr_id;
                        $return['user_id'] = $id = $this->encrypt_data($user_id);
						// $cur_user_aff = User_affiliations::get_all_records('*', "usaff_user_id={$user_id}", 'usaff_prime_affiliation');
                        $User_affiliation = (new \App\Models\User_affiliations())->getTable();
                        $Country = (new \App\Models\Country())->getTable();
                        $select_aff        = "*";
                        $join_tables = array(
                            'main_table' => $User_affiliation,
                            'join_table' => array(
                                $Country => array($Country. '.cnt_id', $User_affiliation . '.usaff_cnt_id', "left"),
                                )
                            );
                        $condition_aff     =  array('usaff_user_id' => $user_id);
                        $cur_user_aff      = User_affiliations::get_results_using_joins($join_tables,$select_aff,$condition_aff,'all','usaff_prime_affiliation DESC');
                        if (count($cur_user_aff)>0) {
                            $has_aff = 1;
                            $prime_aff_found = FALSE;
							foreach ($cur_user_aff as $key => $val) {
								if ($val->usaff_prime_affiliation == 'y') {
									$prime_aff_found = TRUE;
								}

								foreach ($val as $k => $v) {
									if ($k == 'usaff_cnt_id') {
										$val->cnt_country = $val->cnt_country;
										unset($val->$k);
									} elseif ($k == 'usaff_user_id') {
										$val->auaff_auth_id = $val->$k;
										unset($val->$k);
									} else {
										$ka = str_replace('usaff_', 'auaff_', $k);
										$val->$ka = $v;
										if (strpos($k, 'usaff') !== FALSE)
											unset($val->$k);
									}
								}
							}
							if ($prime_aff_found == FALSE) {
								if (isset($cur_user_aff[0]->auaff_id)) {
									$usr_aff_id = $cur_user_aff[0]->auaff_id;
									$update_aff_condition = 'usaff_id =' . $usr_aff_id;
									$update_aff_data = array('usaff_prime_affiliation' => 'y');
									$update_affiliation = User_affiliations::update_record($update_aff_data, $update_aff_condition);
									if ($update_affiliation) {
										$cur_user_aff[0]->auaff_prime_affiliation = 'y';
									}
								}
							}
							$aff_data['user_id'] = $user_id;
							$aff_data['affiliations'] = $cur_user_aff;
							$aff_data['hide_affiliation_email'] = $this->current_client->functionality;
                            $aff_html=$aff_data;
                        }
                        $return_array['hasuser'] = $hasuser;
						$return_array['has_aff'] = $has_aff;
						$return_array['user_data'] = $user_data;
						$return_array['aff_html'] = $aff_html;
                        $return_array['msg']='';
                        $return['success'] = 1;
                    }
                    elseif ($user_data[0]->usr_status == 's') {
                        $return['success'] = 'suspended';
						$return_array['msg'] =  'Cannot add this user as a co-author due to the user account is already suspended';
					} elseif ($user_data[0]->usr_status == 'n') {
                        $return['success'] = 'inactive';
						$return_array['msg'] =' Cannot add this user as a co-author due to the user account is already inactive';
					}
                }
                else {

					$return_array['hasuser'] = $hasuser;
					$return_array['has_aff'] = $has_aff;
					$return_array['user_data'] = $user_data;
					$return_array['aff_html'] = $aff_html;
                    $return_array['msg']='';
                    $return['success'] = 1;
				}
                $return_array['check_affi'] = $this->check_co_author_affiliation($article_id);
                return  $this->success('Success', 200, $return_array);
            }
            else{
                $return_array['success'] = 'reviewer';
			    $return_array['msg'] = 'Cannot add as co-author. This user has been shortlisted/invited as reviewer or privileged user';
                return  $this->success('Success', 200, $return_array);
            }
        }

        else
		{
					$return_array['success'] = 'unregistered';
					$return_array['msg'] = 'Cannot add as co-author. This user have sent unregister request';
                    return  $this->success('Success', 200, $return_array);
		}
    }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }

    public function check_user_assigned_article($user_id, $article_id)
    {
        try{
        $User_articles = new \App\Models\User_articles;
        $user_assigned = $User_articles::get_single_record_with_bind_cond('count(usra_id) as count',array(
            'usra_usr_id' => $user_id,
            'usra_art_id' => $article_id));
        $article_assigned=Article_flow::get_single_record_with_bind_cond('count(aflw_id) as aflwcount',array(
            'aflw_usr_id' => $user_id,
            'aflw_art_id' => $article_id));
        if((!empty ($user_assigned) && isset($user_assigned->count) && ($user_assigned->count > 0))||(isset($article_assigned->aflwcount)&& $article_assigned->aflwcount > 0))

            return TRUE;
        else
            return FALSE;
    } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function check_co_author_affiliation($article_id='',$auth_id='')
        {
            try{
            $authors_table = (new \App\Models\Authors())->getTable();
            $authors_affiliation_table = (new \App\Models\Authors_affiliation)->getTable();

            if(!empty($auth_id))
            {
                $article_authors = Authors::get_single_record('count(auth_id) as cnt',"'auth_art_id'={$article_id} AND 'auth_id' !={$auth_id}");
                if($article_authors->cnt != 0)
                {
                    return TRUE;
                }
            }
            else
            {

                $join_tables = array(
                    'main_table' => $authors_table,
                    'join_table' => array(
                        $authors_affiliation_table => array($authors_table . '.auth_id', $authors_affiliation_table . '.auaff_auth_id')
                    )
                );
                $select = 'auaff_id';
                $criteria = "'auth_art_id'={$article_id}";
                $auth_aff = Authors_affiliation::get_results_using_joins($join_tables, $select, $criteria);

             if(!empty($auth_aff))
                {
                    return TRUE;
                }
            }
            return FALSE;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

        }

        public function cancel_submission(Request $request)
        {
            try {
                $post_data = $request->all();
                $this->current_user = $this->get_current_user_details();
                $article_id = isset($post_data['article_id']) ? $this->decrypt_data($post_data['article_id']) : '';
                $article_flow_id = isset($post_data['art_flow_id']) ? $this->decrypt_data($post_data['art_flow_id']) : '';
                /*
                * get article data
                */
                $select = 'art_id, art_stub_created_by, art_status, art_submitted_by,art_stage_submission_method,art_es_document_status';
                $where = "art_id={$article_id}";
                $article_data = Articles::get_single_record($select, $where);
                /*
                * start - deleting article
                */
                // Articles::trans_start();

                if ($article_data->art_status == 'n' && ($article_data->art_submitted_by == $this->current_user['user_id'] || $article_data->art_stage_submission_method == 'n' || $article_data->art_stage_submission_method == 'z')) {
                    /*
                    * deleting from incomplete submission
                    * by checking if current status in 'author_submission'
                    * and current user have submitted the application
                    */
                    $select = 'jwf_stage_type';
                    $where = "aflw_art_id={$article_id} AND aflw_id={$article_flow_id}";
                    $current_status = Article_flow::get_generic_flow($select, $where);
                    if ($current_status) {
                        $current_status = $current_status[0];

                        if ($current_status->jwf_stage_type == 'author_submission') {

                            $where = "art_id={$article_id}";
                            $esarray['article_id']=$article_id;
                            $checkdata=$this->check_espermission_access($esarray);
                            //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $article_data->art_es_document_status !== 'n')
                            if($checkdata==true && $article_data->art_es_document_status !== 'n')
                            {
                                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                                $es_api_data  = Config::get($es_config);
                                $apiUrl = $es_api_data['delete_article_url'];
                                $current_user = $this->current_user['user_id'];
                                $pass_data = array('art_id' => $article_id,'user_id' => $current_user);			
                                $response = $this->es_curl_request($apiUrl,$pass_data);
                            }
                            $afected_rows = Articles::delete_records($where, '', $this->current_user);
                            if ($afected_rows) {
                                /*---TASK#660----start---when author delete submission, update the status `draft` to `invited` in rvw_event_invited_users table*/

                                $eve_criteria = "evu_user_id={$this->current_user['user_id']} AND evu_submit_status='d' AND evu_art_id={$article_id}";
                                $eve_records = Event_invited_users::get_single_record('count(evu_id) as cnt', $eve_criteria);
                                if ($eve_records->cnt > 0) {
                                    $eve_new_data = array(
                                        'evu_submit_status' => 'i',
                                        'evu_art_id' => null,
                                    );
                                    Event_invited_users::update_record($eve_new_data, $eve_criteria);
                                }
                                /*---end---*/
                                $status = 'success';
                            }
                        }
                    }
                }
                if ($status == 'success') {
                    $return_data['status'] = 'success';
                    $return_data['msg'] = customTrans(':Article removed');
                    return $this->success('Success', 200, $return_data);
                }
                /*
            * end - deleting article
            */
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }

        }
        public function save_suggest_reviewer(Request $request)
        {
            try {
                $suggest_reviewer = $request->all();
                $this->current_user = $this->get_current_user_details();
                $Article_reviewers = new \App\Models\Article_reviewers();
                // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
                $client_fieldvalid  = $this->get_clientfieldrequired_functionalities();

                $rules['first_name'] = 'required';
                $rules['last_name'] = 'required';
                $rules['email_address'] = 'required';

                if (isset($client_fieldvalid->institution) && $client_fieldvalid->institution=='y'){
                    $rules['institution'] = 'required';
                }

                $validator = Validator::make($suggest_reviewer, $rules);
                if ($validator->fails()) {
                    return $this->failure('Failed', 422, $validator->errors());
                }
                // TASK #7033 SQL injection savesuggestreviewer
                $artidarray = array('input'=>$suggest_reviewer['article_id'],'type'=>'number', 'enc_data'=>TRUE );
                $artidvalidation= $this->Rv_validator($artidarray);
                if($artidvalidation != TRUE){
                    return $this->warning('Failed',422,customTrans('auth.invalid_data'));
                }
                 // TASK #7033 SQL injection savesuggestreviewer
                $array['article_id']=decrypt_link($suggest_reviewer['article_id']);
                $array['jnl_code']=$request->segment(3);
                $array['current_flow_id']=decrypt_link($suggest_reviewer['art_flow_id']);
                $array['url']=$request->segment(4);
                $user_access=$this->check_permission_access_user($array);
                if($user_access!=true)
                {
                    return  $this->failure('Unauthorized', 200, 'Unauthorized User');

                }
                // server side validation
                $input_arr = array(
					'input' => $suggest_reviewer["email_address"],
					'type'=> 'email'
				);
				$email_validate = $this->Rv_validator($input_arr);
                $input_arr = array(
					'input' => $suggest_reviewer["first_name"],
					'type'=> 'string'
				);
				$first_name_validate = $this->Rv_validator($input_arr);
                $input_arr['input']= $suggest_reviewer['last_name'];
				$last_name_validate = $this->Rv_validator($input_arr);
                $input_arr['input']= $suggest_reviewer['institution'];
                $institution_validate =true;
                if (isset($client_fieldvalid->institution) && $client_fieldvalid->institution=='y'){
				    $institution_validate = $this->Rv_validator($input_arr);
                }
                if($first_name_validate != TRUE || $last_name_validate != TRUE || $institution_validate != TRUE || $email_validate != TRUE){
                    return $this->warning('Failed',422,customTrans('auth.invalid_data'));
                }
                $article_id = isset($suggest_reviewer['article_id']) ? $this->decrypt_data($suggest_reviewer['article_id']) : '';
                $sorw_id = $suggest_reviewer['reviewer_id'];
                if ($article_id != '') {
                    $checkEmail = $this->checkEmailExists($suggest_reviewer,$sorw_id);
                    if(isset($checkEmail['status']) && !empty($checkEmail['status']) && $checkEmail['status'] == 'failed') {
                        return $this->success('Success', 200, $checkEmail);
                    }
                    // print_r($checkEmail);die;
                    if (isset($this->current_client->functionality->cfty_compact_reviewer_suggest_oppose) && $this->current_client->functionality->cfty_compact_reviewer_suggest_oppose == 'y') {



                        $data = array(
                            "sorw_art_id" => $article_id,
                            "sorw_title" => $suggest_reviewer["title"],
                            "sorw_name" => $suggest_reviewer["first_name"],
                            "sorw_last_name" => $suggest_reviewer["last_name"], //last name
                            "sorw_university" => $suggest_reviewer["institution"],
                            "sorw_email" => $suggest_reviewer["email_address"],
                            "sorw_action" => "s",
                        );
                    } else {
                        // $data = array(
                        //     "sorw_art_id" => $article_id,
                        //     "sorw_name" => $suggest_reviewer["first_name"],
                        //     "sorw_last_name" => $suggest_reviewer["last_name"], //last name
                        //     "sorw_university" => $suggest_reviewer["institution"],
                        //     "sorw_email" => $suggest_reviewer["email_address"],
                        //     "sorw_action" => "s",
                        // );
                        $data = array(
                            "sorw_art_id" => $article_id,
                            "sorw_title" => $suggest_reviewer["title"],
                            "sorw_name" => $suggest_reviewer["first_name"],
                            "sorw_last_name" => $suggest_reviewer["last_name"], //last name
                            "sorw_email" => $suggest_reviewer["email_address"],
                            "sorw_position" => $suggest_reviewer["position"],
                            "sorw_phone_number" => $suggest_reviewer["phone_number"],
                            "sorw_department" => $suggest_reviewer["department"],
                            "sorw_university" => $suggest_reviewer["institution"],
                            "sorw_reason" => $suggest_reviewer["reason"],
                            "sorw_action" => "s",
                            "sorw_address_line1" => $suggest_reviewer["addrLine1"],
                            "sorw_address_line2" => $suggest_reviewer["addrLine2"],
                            "sorw_cnt_id" => $suggest_reviewer["country"],
                            'sorw_state' => $suggest_reviewer['state'],
                            "sorw_postal_code" => $suggest_reviewer["zipcode"],
                            "sorw_aff_type" => 'w',
                        );
                        if($this->current_client->modules->mdl_ror == 'y' && !empty($suggest_reviewer['rorIdentifier']) && $suggest_reviewer['rorIdentifier'] != 'undefined'){
                            $data['sorw_ror_id'] = $suggest_reviewer['rorIdentifier'];
                            $data['sorw_ringgold_id'] = NULL;
                            $data['sorw_ringgold_family'] = NULL;
                          }elseif($this->current_client->modules->mdl_ringgold == 'y' && !empty($suggest_reviewer['ringgoldIdentifier']) && $suggest_reviewer['ringgoldIdentifier'] != 'undefined'){
                            $data['sorw_ror_id'] = NULL;
                            $data['sorw_ringgold_id'] = $suggest_reviewer['ringgoldIdentifier'];
                            $post_data = array(
                              'search_key' => $suggest_reviewer['ringgoldIdentifier']
                            );
                            $response = $this->search_organisation($post_data, false, true);
                            $responseArr = json_decode($response);
                            $ringgoldFamily = (implode( ',',array_column( $responseArr->response, 'member')));
                            $data['sorw_ringgold_family'] = '['.$ringgoldFamily.']';
                          }

                    }
                    if ($sorw_id == "")
                    {
                    $reviewer_id = $Article_reviewers::insert_record($data, $this->current_user);
                    if ($reviewer_id == true) {

                        $return_data['status'] = 'success';
                        $return_data['msg'] = 'Proposed reviewer added successfully';
                        return $this->success('Success', 200, $return_data);
                    }
                }
                    else
                    {

                        $updation = $Article_reviewers::update_record($data,"sorw_id={$sorw_id} AND sorw_action ='s'" , $this->current_user);
                        if ($updation == True)
                        {
                            $return_data['status'] = 'success';
                                $return_data['msg'] = 'Proposed reviewer details updated successfully';
                        }

                    }
                                            return $this->success('Success', 200, $return_data);
                }


            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function checkEmailExists($postData,$sorw_id=NULL){
            //check email
            $return_data['status'] = 'success';
            $art_id = decrypt_link($postData['article_id']);
            // $articleDetails = Articles::get_single_record('art_submitted_by', 'art_id=' .decrypt_link($postData['article_id']));
            $article_authors = Authors::get_single_record('GROUP_CONCAT(auth_usr_id) as authors',"auth_art_id={$art_id}")->authors;
            $email_condition = ' (usr_username = \''.$postData["email_address"].'\' OR usr_email = \''.$postData["email_address"].'\') AND usr_id IN (' . $article_authors . ')';
            $exist_email_data = User::get_all_records('usr_id',$email_condition);
            // print_r(($exist_email_data));die;
            $reviewers_email_condition = ' (sorw_email = \''.$postData["email_address"].'\') AND sorw_art_id = ' . decrypt_link($postData['article_id'])  ;
            if($sorw_id != NULL){
                $reviewers_email_condition .= " AND sorw_id != " . $sorw_id;
            }
            $reviewer_email_data = Article_reviewers::get_all_records('sorw_id',$reviewers_email_condition);
            // print_r(count($reviewer_email_data));die;
            if(count($exist_email_data) > 0){
                $return_data['status'] = 'failed';
                $return_data['msg'] = customTrans('Author and reviewer for an :article cannot be same.');
            }
            else if(count($reviewer_email_data) > 0){
                $return_data['status'] = 'failed';
                $return_data['msg'] = 'The reviewer email address entered has already been added.';
            }
            return $return_data;

        }
        public function get_suggest_oppose_reviewer(Request $request)
        {
            try {
                $reviewer = $request->all();
                $validator = Validator::make($request->all(), [
                    'article_id' => 'required',
                    'art_flow_id'=>'required'
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }
                $art_id_arr = array('input'=> Rv_decrypt($reviewer['article_id']),'type'=>'number', 'enc_data' => FALSE );
                $art_validation= $this->Rv_validator($art_id_arr);   
                if($art_validation != TRUE)
                {
                  return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
                }
                $array['article_id']=Rv_decrypt($reviewer['article_id']);
                $array['jnl_code']=$request->segment(3);
                $array['current_flow_id']=decrypt_link($reviewer['art_flow_id']);
                $array['url']=$request->segment(4);
                $user_access=$this->check_permission_access_user($array);
                if($user_access!=true)
                {
                    return  $this->failure('Unauthorized', 200, 'Unauthorized User');

                }
                $this->current_user = $this->get_current_user_details();
                $Article_reviewers = new \App\Models\Article_reviewers();
                $Country_table = (new \App\Models\Country())->getTable();
                $article_id = isset($reviewer['article_id']) ? Rv_decrypt($reviewer['article_id']) : '';
                if ($article_id != '') {
                    // For getting suggest reviewers
                    $return_data['get_sugg_rvr_details'] = $Article_reviewers::get_all_records('*,(select cnt_country from ' . $Country_table . ' where sorw_cnt_id = cnt_id) as country_name', "sorw_art_id={$article_id} AND sorw_suggested_user_role='a' AND sorw_action='s'");

                    // // For getting suggest reviewers skip
                    // $return_data['get_sugg_rvr_details'] = $Article_reviewers::get_all_records('*', "sk_art_id={$article_id} AND sk_skip_action='skip_suggest'");

                    // //For getting oppose reviewer
                    $return_data['get_opp_rvr_details'] = $Article_reviewers::get_all_records('*,(select cnt_country from ' . $Country_table . ' where sorw_cnt_id = cnt_id) as country_name', "sorw_art_id={$article_id} AND sorw_suggested_user_role='a' AND sorw_action='o'");

                    // //For getting oppose reviewer skip
                    // $return_data['get_sugg_rvr_details'] = $Article_reviewers::get_all_records('*', "sk_art_id={$article_id} AND sk_skip_action='skip_oppose'");

                    return $this->success('Success', 200, $return_data);

                }
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function delete_suggest_reviewer(Request $request)
        {
            try {
                $suggest_id = $request->all();
                $this->current_user = $this->get_current_user_details();
                $validator = Validator::make($request->all(), [
                    'article_id' => 'required',
                    'art_flow_id' => 'required'
                ]);
                if ($validator->fails()) {
                    return $this->failure('Failed', 422, $validator->errors());
                }
                $array['article_id']=decrypt_link($suggest_id['article_id']);
                $array['jnl_code']=$request->segment(3);
                $array['current_flow_id']=decrypt_link($suggest_id['art_flow_id']);
                $array['url']=$request->segment(4);
                $user_access=$this->check_permission_access_user($array);
                if($user_access!=true)
                {
                    return  $this->failure('Unauthorized', 200, 'Unauthorized User');

                }
                $Article_reviewers = new \App\Models\Article_reviewers();
                $Country_table = (new \App\Models\Country())->getTable();
                $suggest_reviewer_id = isset($suggest_id["suggest_reviewer_id"]) ? $this->decrypt_data($suggest_id["suggest_reviewer_id"]) : '';

                if ($suggest_reviewer_id != '') {
                    $condition = "sorw_id = {$suggest_reviewer_id}  AND sorw_action = 's'";

                    $Article_reviewers::delete_records($condition, '', $this->current_user);
                    $return_data['msg'] = 'Proposed reviewer deleted successfully';
                    return $this->success('Success', 200, $return_data);
                }
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function get_suggest_reviewer(Request $request)
        {
            try {
                $post_data = $request->all();
                $this->current_user = $this->get_current_user_details();
                $Article_reviewers = new \App\Models\Article_reviewers();
                $Country_table = (new \App\Models\Country())->getTable();

                $article_id = isset($post_data['article_id']) ? $this->decrypt_data($post_data['article_id']) : '';
                $reviewer_id = isset($post_data['sorw_id']) ? $this->decrypt_data($post_data['sorw_id']) : '';
                if($reviewer_id!=''){
                    $get_reviewer_row = $Article_reviewers::get_single_record('*,(select cnt_country from ' .  $Country_table . ' where sorw_cnt_id = cnt_id) as country_name',"sorw_id={$reviewer_id} AND sorw_action='s' AND sorw_art_id={$article_id}");
                    $titles = $this->UserConfigdata('titles')['titles'];
                    $usrTitle = '';
                    if(isset($titles[$get_reviewer_row->sorw_title])){
                        $usrTitle = $titles[$get_reviewer_row->sorw_title]. ' ';
                    }
                    $get_reviewer_row->fullName = $usrTitle . $get_reviewer_row->sorw_name . ' ' . $get_reviewer_row->sorw_last_name;
                    return $this->success('Success', 200, $get_reviewer_row);
                }
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function save_oppose_reviewer(Request $request)
        {
            try {
                $suggest_reviewer = $request->all();
                $this->current_user = $this->get_current_user_details();
                $Article_reviewers = new \App\Models\Article_reviewers();
                // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
                $client_fieldvalid  = $this->get_clientfieldrequired_functionalities();

                $rules['first_name'] = 'required';
                $rules['last_name'] = 'required';
                $rules['email_address'] = 'required';

                if (isset($client_fieldvalid->institution) && $client_fieldvalid->institution=='y'){
                    $rules['institution'] = 'required';
                }

                $validator = Validator::make($suggest_reviewer, $rules);
                if ($validator->fails()) {
                    return $this->failure('Failed', 422, $validator->errors());
                }
                $array['article_id']=decrypt_link($suggest_reviewer['article_id']);
                $array['jnl_code']=$request->segment(3);
                $array['current_flow_id']=decrypt_link($suggest_reviewer['art_flow_id']);
                $array['url']=$request->segment(4);
                $user_access=$this->check_permission_access_user($array);
                if($user_access!=true)
                {
                    return  $this->failure('Unauthorized', 200, 'Unauthorized User');

                }
                // server side validation
                $input_arr = array(
					'input' => $suggest_reviewer["email_address"],
					'type'=> 'email'
				);
				$email_validate = $this->Rv_validator($input_arr);
                $input_arr = array(
					'input' => $suggest_reviewer["first_name"],
					'type'=> 'string'
				);
				$first_name_validate = $this->Rv_validator($input_arr);
                $input_arr['input']= $suggest_reviewer['last_name'];
				$last_name_validate = $this->Rv_validator($input_arr);
                $input_arr['input']= $suggest_reviewer['institution'];
                $institution_validate =true;
                if (isset($client_fieldvalid->institution) && $client_fieldvalid->institution=='y' || (isset($suggest_reviewer['institution']) && !empty($suggest_reviewer['institution']))){
				    $institution_validate = $this->Rv_validator($input_arr);
                }

                if($first_name_validate != TRUE || $last_name_validate != TRUE || $institution_validate != TRUE || $email_validate != TRUE){
                    return $this->warning('Failed',422,customTrans('auth.invalid_data'));
                }
                $article_id = isset($suggest_reviewer['article_id']) ? $this->decrypt_data($suggest_reviewer['article_id']) : '';
                $sorw_id = $suggest_reviewer['reviewer_id'];
                if ($article_id != '') {
                    $checkEmail = $this->checkEmailExists($suggest_reviewer,$sorw_id);
                    if(isset($checkEmail['status']) && $checkEmail['status'] == 'failed') {
                        return $this->success('Success', 200, $checkEmail);
                    }
                    if (isset($this->current_client->functionality->cfty_compact_reviewer_suggest_oppose) && $this->current_client->functionality->cfty_compact_reviewer_suggest_oppose == 'y') {



                        $data = array(
                            "sorw_art_id" => $article_id,
                            "sorw_title" => $suggest_reviewer["title"],
                            "sorw_name" => $suggest_reviewer["first_name"],
                            "sorw_last_name" => $suggest_reviewer["last_name"], //last name
                            "sorw_university" => $suggest_reviewer["institution"],
                            "sorw_email" => $suggest_reviewer["email_address"],
                            "sorw_action" => "o",
                        );
                    } else {
                        // $data = array(
                        //     "sorw_art_id" => $article_id,
                        //     "sorw_name" => $suggest_reviewer["first_name"],
                        //     "sorw_last_name" => $suggest_reviewer["last_name"], //last name
                        //     "sorw_university" => $suggest_reviewer["institution"],
                        //     "sorw_email" => $suggest_reviewer["email_address"],
                        //     "sorw_action" => "o",
                        // );
                        $data = array(
                            "sorw_art_id" => $article_id,
                            "sorw_title" => $suggest_reviewer["title"],
                            "sorw_name" => $suggest_reviewer["first_name"],
                            "sorw_last_name" => $suggest_reviewer["last_name"], //last name
                            "sorw_email" => $suggest_reviewer["email_address"],
                            "sorw_position" => $suggest_reviewer["position"],
                            "sorw_phone_number" => $suggest_reviewer["phone_number"],
                            "sorw_department" => $suggest_reviewer["department"],
                            "sorw_university" => $suggest_reviewer["institution"],
                            "sorw_reason" => $suggest_reviewer["reason"],
                            "sorw_action" => "o",
                            "sorw_address_line1" => $suggest_reviewer["addrLine1"],
                            "sorw_address_line2" => $suggest_reviewer["addrLine2"],
                            "sorw_cnt_id" => $suggest_reviewer["country"],
                            'sorw_state' => $suggest_reviewer['state'],
                            "sorw_postal_code" => $suggest_reviewer["zipcode"],
                            "sorw_aff_type" => 'w',
                        );
                        if($this->current_client->modules->mdl_ror == 'y' && !empty($suggest_reviewer['rorIdentifier']) && $suggest_reviewer['rorIdentifier'] != 'undefined'){
                            $data['sorw_ror_id'] = $suggest_reviewer['rorIdentifier'];
                            $data['sorw_ringgold_id'] = NULL;
                            $data['sorw_ringgold_family'] = NULL;
                          }elseif($this->current_client->modules->mdl_ringgold == 'y' && !empty($suggest_reviewer['ringgoldIdentifier']) && $suggest_reviewer['ringgoldIdentifier'] != 'undefined'){
                            $data['sorw_ror_id'] = NULL;
                            $data['sorw_ringgold_id'] = $suggest_reviewer['ringgoldIdentifier'];
                            $post_data = array(
                              'search_key' => $suggest_reviewer['ringgoldIdentifier']
                            );
                            $response = $this->search_organisation($post_data, false, true);
                            $responseArr = json_decode($response);
                            $ringgoldFamily = (implode( ',',array_column( $responseArr->response, 'member')));
                            $data['sorw_ringgold_family'] = '['.$ringgoldFamily.']';
                          }

                    }
                    if ($sorw_id == "")
                    {
                    $reviewer_id = $Article_reviewers::insert_record($data, $this->current_user);
                    if ($reviewer_id == true) {

                        $return_data['status'] = 'success';
                        $return_data['msg'] = 'Opposed reviewer added successfully';
                        $return_data['added'] = true;
                        return $this->success('Success', 200, $return_data);
                    }
                }
                    else
                    {

                        $updation = $Article_reviewers::update_record($data,"sorw_id={$sorw_id} AND sorw_action ='o'" , $this->current_user);
                        if ($updation == True)
                        {
                            $return_data['status'] = 'success';
                                $return_data['msg'] = 'Opposed reviewer details updated successfully';
                                $return_data['updated'] = true;
                        }

                    }
                                            return $this->success('Success', 200, $return_data);
                }


            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function get_oppose_reviewer(Request $request)
        {
            try {
                $post_data = $request->all();
                $this->current_user = $this->get_current_user_details();
                $validator = Validator::make($request->all(), [
                    'article_id' => 'required',
                    'art_flow_id' => 'required'
                ]);
                if ($validator->fails()) {
                    return $this->failure('Failed', 422, $validator->errors());
                }
                $array['article_id']=decrypt_link($post_data['article_id']);
                $array['jnl_code']=$request->segment(3);
                $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
                $array['url']=$request->segment(4);
                $user_access=$this->check_permission_access_user($array);
                if($user_access!=true)
                {
                    return  $this->failure('Unauthorized', 200, 'Unauthorized User');

                }
                $Article_reviewers = new \App\Models\Article_reviewers();
                $Country_table = (new \App\Models\Country())->getTable();

                $article_id = isset($post_data['article_id']) ? $this->decrypt_data($post_data['article_id']) : '';
                $reviewer_id = isset($post_data['sorw_id']) ? $this->decrypt_data($post_data['sorw_id']) : '';
                if($reviewer_id!=''){
                    $get_reviewer_row = $Article_reviewers::get_single_record('*,(select cnt_country from ' .  $Country_table . ' where sorw_cnt_id = cnt_id) as country_name',"sorw_id={$reviewer_id} AND sorw_action='o' AND sorw_art_id={$article_id}");
                    $titles = $this->UserConfigdata('titles')['titles'];
                    $usrTitle = '';
                    if(isset($titles[$get_reviewer_row->sorw_title])){
                        $usrTitle = $titles[$get_reviewer_row->sorw_title]. ' ';
                    }
                    $get_reviewer_row->fullName = $usrTitle . $get_reviewer_row->sorw_name . ' ' . $get_reviewer_row->sorw_last_name;
                    return $this->success('Success', 200, $get_reviewer_row);
                }
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function delete_oppose_reviewer(Request $request)
        {
            try {
                $suggest_id = $request->all();
                $this->current_user = $this->get_current_user_details();
                $validator = Validator::make($request->all(), [
                    'article_id' => 'required',
                    'art_flow_id' => 'required'
                ]);
                if ($validator->fails()) {
                    return $this->failure('Failed', 422, $validator->errors());
                }
                $array['article_id']=decrypt_link($suggest_id['article_id']);
                $array['jnl_code']=$request->segment(3);
                $array['current_flow_id']=decrypt_link($suggest_id['art_flow_id']);
                $array['url']=$request->segment(4);
                $user_access=$this->check_permission_access_user($array);
                if($user_access!=true)
                {
                    return  $this->failure('Unauthorized', 200, 'Unauthorized User');

                }
                $Article_reviewers = new \App\Models\Article_reviewers();
                $Country_table = (new \App\Models\Country())->getTable();
                $suggest_reviewer_id = isset($suggest_id["oppose_reviewer_id"]) ? $this->decrypt_data($suggest_id["oppose_reviewer_id"]) : '';

                if ($suggest_reviewer_id != '') {
                    $condition = "sorw_id = {$suggest_reviewer_id} AND sorw_action = 'o'";

                    $Article_reviewers::delete_records($condition, '', $this->current_user);
                    $return_data['msg'] = 'Opposed/non-preferred reviewer deleted successfully';
                    $return_data['delete'] = true;
                    return $this->success('Success', 200, $return_data);
                }
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }
        public function get_custom_article_keywords(Request $request)
        {
            try {
                $post_data = $request->all();
                $this->current_user = $this->get_current_user_details();
                $artp_id = isset($post_data['art_type_id']) ? $this->decrypt_data($post_data['art_type_id']) : '';
                $jnl_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
                $art_id = isset($post_data['art_id']) ? $this->decrypt_data($post_data['art_id']) : '';
                $keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
                $Keywords = new \App\Models\Keywords();
                $journals_table = (new \App\Models\Journals())->getTable();
                $Keywords_table = (new \App\Models\Keywords())->getTable();
                $articlekeyword_table = (new \App\Models\Article_keywords())->getTable();
                $hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;
                // $return_arr['article_details'] = Article_type_advance_options::get_all_records('atotp_user_input_keyword,atotp_separate_adhoc_keywords',"atotp_artp_id={$artp_id}");
                $results = array();
                if (!empty($post_data['search']))
                {
                    if ($this->current_client->functionality->cfty_keyword_inactive == 'y')

                    {
                        $where = "kwdrl_inactive = 'n'";
                    }
                    $where = "kwd_user_keyword = 'n'";
                    $search = htmlspecialchars($post_data['search'], ENT_QUOTES);
                    if($art_id !== 'undefined' && $art_id !== '')
				{
                    if($hierarchy=='j')
                    {
					$where = " kwdrl_jnl_id='".$jnl_id . "' AND kwd_user_keyword = 'n'  AND (kwdrl_inactive = 'n' OR ak_art_id = '".$art_id."' )";
                    }
                    else{
                        $excludekeywords = (new \App\Models\Excluded_journal_keywords())->getTable();
                        $where = " kwd_user_keyword = 'n'  AND (kwdrl_inactive = 'n' OR ak_art_id = '".$art_id."' ) AND kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM " .$excludekeywords . " where ejk_jnl_id='" . $jnl_id. "')";
                    }

                    if(!empty($search))
                    {
                        $where .= ' AND kwd_name LIKE "%' . $search . '%"';
                    }
				}
				else
				{
                    if($hierarchy=='j')
                    {
					$where = " kwdrl_jnl_id=".$jnl_id . " AND kwd_user_keyword = 'n'  AND kwdrl_inactive = 'n' ";
                    }
                    else{
                        $excludekeywords = (new \App\Models\Excluded_journal_keywords())->getTable();
                        $where = " kwd_user_keyword = 'n' AND kwdrl_inactive = 'n' AND kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM " .$excludekeywords . " where ejk_jnl_id='" . $jnl_id. "')";
                    }
                    if(!empty($search))
                    {
                        $where .= ' AND kwd_name LIKE "%' . $search . '%"';
                    }
				}
                $select = 'kwd_id,REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\') as kwd_name,kwd_user_keyword,kwdrl_id,kwdrl_inactive';
                $group_by = 'kwd_id';
                if($hierarchy=='j')
                {
				$sql ='SELECT '.$select.' FROM '.$Keywords_table.' JOIN '.$keyword_relationship_table.' ON kwdrl_kwd_id = kwd_id JOIN '.$journals_table.' ON kwdrl_kwd_id = kwd_id LEFT JOIN '.$articlekeyword_table.' ON ak_keyword_id = kwd_id WHERE '.$where.' GROUP BY '.$group_by.' ORDER BY kwd_name ASC';
                }
                else{
                $sql ='SELECT '.$select.' FROM '.$Keywords_table.' JOIN '.$keyword_relationship_table.' ON kwdrl_kwd_id = kwd_id LEFT JOIN '.$articlekeyword_table.' ON ak_keyword_id = kwd_id WHERE '.$where.' GROUP BY '.$group_by.' ORDER BY kwd_name ASC';
                }
                $return_arr['keywords']  = $Keywords::get_records_by_raw_query($sql);
                return $this->success('Success', 200, $return_arr);
              }
            }
            catch (\Exception $e) {

                return $this->failure('Failed', 500, $e);
            }
    }

    public function article_keyword_activity($article_details, $post_data, $article_id, $art_keywords)
    {
        try {
            $current_user = $this->get_current_user_details();
            $hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;

            $Keyword_category = new \App\Models\Keyword_category();
            $Keywords = new \App\Models\Keywords();
            $Keyword_relationship = new \App\Models\Keyword_relationship;
            $Article_keywords = new \App\Models\Article_keywords;
            $platform_code = $post_data['platform_code'];
            $platform_data = $this->platform_basic_settings_data($platform_code);
            $journal_id = $platform_data->jnl_id;

            if (!empty($art_keywords)) {
                $art_keywords = json_decode(json_encode($art_keywords), true);
                $art_keywords = array_column($art_keywords, 'ak_keyword_id');
            }
            $key_from_post = array();
            $keyword_changed = FALSE;
            if ($article_details->atotp_user_input_keyword == 'y') {
                if (isset($post_data['keywords'])) {
                    foreach ($post_data['keywords'] as $artkeyvalue) {
                        if (!isset($artkeyvalue['id'])) {
                            //Custom category
                            $keyword_changed = TRUE;
                            $keyword_val = strtoupper($artkeyvalue['value']);
                            $keyword_val = str_replace('\\', '"', $keyword_val);
                            $keyword_value = htmlspecialchars($keyword_val, ENT_QUOTES);

                            if (($hierarchy == 'c')) {
                                $default_catid = $Keyword_category->get_default_category();
                                if ($default_catid == 0) {
                                    $default_catid = $Keyword_category->insert_record(array(
                                        'kwc_name' => 'Asorted',
                                        'kwc_is_default' => 'y'
                                    ), $current_user);
                                }
                                if ($default_catid) {
                                    $condition = ' kwd_name = \'' . $keyword_value . '\' AND kwdrl_category_id = ' . $default_catid;
                                    $keyword_exists = $Keywords->get_keywords($condition, '*', NULL, NULL, 'kwd_id', $hierarchy);
                                    if (count($keyword_exists) == 0) {
                                        //keyword not exists in uncatogrised category
                                        $data = ' kwd_name = \'' . $keyword_value . '\' ';
                                        $get_keyword_record = $Keywords->get_single_record('*', $data);
                                        if (!empty($get_keyword_record)) {
                                            $keyinsertid = $get_keyword_record->kwd_id;
                                            $data_keyword_category = array(
                                                'kwdrl_category_id' => $default_catid,
                                                'kwdrl_kwd_id' => $keyinsertid
                                            );
                                            $relationshipExist = $Keyword_relationship->get_single_record('*', 'kwdrl_category_id =' . $default_catid . 'AND kwdrl_kwd_id =' . $keyinsertid);
                                            if (count($relationshipExist) == 0) {
                                                $Keyword_relationship->insert_record($data_keyword_category, $current_user);
                                            }
                                        } else {
                                            $insData['kwd_name'] = $keyword_value;
                                            $insData['kwd_user_keyword'] = 'y';
                                            $keyinsertid = $Keywords->insert_record($insData, $current_user);
                                            $data_keyword_category = array(
                                                'kwdrl_category_id' => $default_catid,
                                                'kwdrl_kwd_id' => $keyinsertid
                                            );
                                            $Keyword_relationship->insert_record($data_keyword_category, $current_user);
                                        }
                                        $exists_in_ak = $Article_keywords->get_all_records('*', 'ak_art_id =' . $article_id . ' AND ak_keyword_id =' . $keyinsertid);

                                        if (count($exists_in_ak) == 0) {
                                            $Article_keywords->insert_record(array(
                                                'ak_art_id' => $article_id,
                                                'ak_keyword_id' => $keyinsertid
                                            ), $current_user);
                                        }
                                    } else {

                                        $data_keyword_category = 'kwdrl_category_id = ' . $default_catid . ' AND kwdrl_kwd_id = ' . $keyword_exists[0]->kwd_id;
                                        $get_keyword_relation_record = $Keyword_relationship->get_single_record('*', $data_keyword_category);

                                        $data_update = 'kwdrl_inactive=' . 'n';
                                        if (count($get_keyword_relation_record) > 0) {
                                            $up_data = $Keyword_relationship->update_record($data_update, $data_keyword_category);
                                        } else {
                                            $ins_data = $Keyword_relationship->insert_record($data_keyword_category, $current_user);
                                        }
                                        $exists_in_ak = $Article_keywords->get_all_records('*', array(
                                            'ak_art_id' => $article_id,
                                            'ak_keyword_id' => $keyword_exists[0]->kwd_id
                                        ));
                                        if (
                                            count($exists_in_ak) == 0
                                        ) {
                                            $Article_keywords->insert_record(array(
                                                'ak_art_id' => $article_id,
                                                'ak_keyword_id' => $keyword_exists[0]->kwd_id
                                            ), $current_user);
                                        }
                                    }
                                }
                            } else {
                                $condition = ' kwd_name = \'' . $keyword_value . '\' AND kwdrl_jnl_id = ' . $journal_id;
                                $keyword_exists = $Keywords->get_keywords($condition, '*', NULL, NULL, 'kwd_id', $hierarchy);
                                if (count($keyword_exists) == 0) {
                                    $data = 'kwd_name = \'' . $keyword_value . '\'';
                                    $get_keyword_record = $Keywords->get_single_record('*', $data);
                                    if (!empty($get_keyword_record)) {
                                        $keyinsertid = $get_keyword_record->kwd_id;
                                        $data_keyword = array(
                                            'kwdrl_jnl_id' => $journal_id,
                                            'kwdrl_kwd_id' => $keyinsertid
                                        );
                                        $result = $Keyword_relationship->insert_record($data_keyword, $current_user);
                                    } else {
                                        $keyData['kwd_name'] = $keyword_value;
                                        $keyData['kwd_user_keyword'] = 'y';
                                        $keyinsertid = $Keywords->insert_record($keyData, $current_user);
                                        $data_keyword = array(
                                            'kwdrl_jnl_id' => $journal_id,
                                            'kwdrl_kwd_id' => $keyinsertid
                                        );
                                        $result = $Keyword_relationship->insert_record($data_keyword, $current_user);
                                    }
                                    $exists_in_ak = $Article_keywords->get_all_records('*', 'ak_art_id =' . $article_id . ' AND ak_keyword_id =' . $keyinsertid);
                                    if (count($exists_in_ak) == 0) {
                                        $Article_keywords->insert_record(array(
                                            'ak_art_id' => $article_id,
                                            'ak_keyword_id' => $keyinsertid
                                        ), $current_user);
                                    }
                                    // print_r($keyword_exists);
                                } else {

                                    $data_keyword_journal = 'kwdrl_jnl_id =' . $journal_id . ' AND kwdrl_kwd_id =' . $keyword_exists[0]->kwd_id;
                                    $get_keyword_relation_record = $Keyword_relationship->get_single_record('*', $data_keyword_journal);
                                    $data_update = array(
                                        'kwdrl_inactive' => 'n'
                                    );
                                    if (!empty($get_keyword_relation_record)) {
                                        $up_data = $Keyword_relationship->update_record($data_update, $data_keyword_journal);
                                    } else {
                                        $ins_data = $Keyword_relationship->insert_record($data_keyword_journal, $this->currentuser);
                                    }
                                    $exists_in_ak = $Article_keywords->get_all_records('*', 'ak_art_id =' . $article_id . ' AND ak_keyword_id =' . $keyword_exists[0]->kwd_id);
                                    if (count($exists_in_ak) == 0) {
                                        $Article_keywords->insert_record(array(
                                            'ak_art_id' => $article_id,
                                            'ak_keyword_id' => $keyword_exists[0]->kwd_id
                                        ), $current_user);
                                    }
                                }
                            }
                        } else {
                            $artkeyvalue = $artkeyvalue['id'];
                            // $exists_in_ak = $Article_keywords->get_all_records('*', 'ak_art_id =' . $article_id . ' AND ak_keyword_id = ' . $artkeyvalue); //TASK #4943 savebasicdetails sql injection
                            $exists_in_ak = $Article_keywords->get_all_records('*', 'ak_art_id = ? AND ak_keyword_id = ?',binding_arr:[$article_id,$artkeyvalue]); //TASK #4943 savebasicdetails sql injection
                            $key_from_post[] = $artkeyvalue;
                            if (count($exists_in_ak) == 0) {
                                $Article_keywords->insert_record(array(
                                    'ak_art_id' => $article_id,
                                    'ak_keyword_id' => $artkeyvalue
                                ), $current_user);
                            }
                        }
                    }
                }
            } else {
                // user_input_keyword is NO
                if (isset($post_data['keywords'])) {
                    foreach ($post_data['keywords'] as $artkeyvalue) {
                        $artkeyvalue = $artkeyvalue['id'];
                        // $exists_in_ak = $Article_keywords->get_all_records('*', 'ak_art_id =' . $article_id . ' AND ak_keyword_id =' . $artkeyvalue); //TASK #4943 savebasicdetails sql injection
                        $exists_in_ak = $Article_keywords->get_all_records('*', 'ak_art_id = ? AND ak_keyword_id = ?',binding_arr:[$article_id,$artkeyvalue]); ////TASK #4943 savebasicdetails sql injection
                        $key_from_post[] = $artkeyvalue;
                        if (count($exists_in_ak) == 0) {
                            $Article_keywords->insert_record(array(
                                'ak_art_id' => $article_id,
                                'ak_keyword_id' => $artkeyvalue
                            ), $current_user);
                        }
                    }
                }
            }
            if (count(array_diff($art_keywords, $key_from_post)) > 0 || count(array_diff($key_from_post, $art_keywords)) > 0) {
                $keyword_changed = TRUE;
            }
            return $keyword_changed;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function getSortableTreeData(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'classificationData' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' =>$post_data['classificationData'],
                'rv_enc_data' => TRUE,
                'type' => 'string'
            );
            $dataValidate = $this->Rv_validator($input_arr);
            $classificationData = Rv_decrypt($post_data['classificationData']);
            if($dataValidate == false || empty($classificationData)) {
                $arraymsg['message'] = customTrans('viewarticle.invalid_data');
                $arraymsg['status'] = 'failed';
                return  $this->success('Success', 200, $arraymsg);
            }
            $classificationData = explode(',', $classificationData);
            $resultSet = $this->getArticleClassifications($classificationData);
            $classification_treedata = json_decode(json_encode($resultSet));
            $getReadOnlyView = $this->getReadOnlyView($resultSet);
            $return_arr['status'] = 'success';
            $return_arr['classification_list'] = $classification_treedata;
            $return_arr['readOnlyList'] = $getReadOnlyView;
            return $this->success('success', 201, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_search_classificationdata(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $search_data = isset($post_data['searchData'])?$post_data['searchData']:NULL;
            $jnl_id = Rv_decrypt($post_data['jnl_id']);
            $return_array['classification_treedata'] = $this->search_classificationdata($search_data, NULL, $jnl_id);
            // $parent_keys = Classifications::get_single_record(' GROUP_CONCAT(DISTINCT cls_primary_id) as parent_keys', 'cls_jnl_id =' . $jnl_id);
            // $return_array['parentSet'] = (!empty($parent_keys->parent_keys)) ? Rv_encrypt($parent_keys->parent_keys) : null;
            return $this->success('success', 201, $return_array);

        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function set_as_primary_affiliation(Request $request)
    {
        try {
            $post_data = $request->all();
            $current_user = $this->get_current_user_details();
            $aff_id = (decrypt_link($post_data['auaff_id']));
            $auaff_auth_id = (decrypt_link($post_data['auaff_auth_id']));
            $jnl_id = decrypt_link($post_data['jnl_id']);
            $art_id = decrypt_link($post_data['art_id']);
            if (!empty($aff_id)) {
                $data_affiliation['auaff_prime_affiliation'] = 'y';
                Authors_affiliation::update_record(array(
                    'auaff_prime_affiliation' => 'n'
                ), 'auaff_id !=' . $aff_id .' AND auaff_auth_id=' .$auaff_auth_id, $current_user);
                Authors_affiliation::update_record($data_affiliation, "auaff_id={$aff_id}", $current_user);
                $this->update_article_author_map($art_id,$aff_id,$jnl_id);
                return $this->success('success', 201);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function delete_coauthor(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $array['article_id']=decrypt_link($post_data['art_id']);
            $jnl_code=$array['jnl_code']=$request->segment(3);
            $array['current_flow_id']=decrypt_link($post_data['art_flow_id']);
            $array['url']=$request->segment(4);
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return  $this->failure('Unauthorized', 200, 'Unauthorized User');

            }
            $co_author_id = decrypt_link($post_data["auth_id"]);
            $jnl_id = decrypt_link($post_data["jnl_id"]);
            $confirm_status = FALSE;
            $current_user = $this->get_current_user_details();

            if (isset($co_author_id)) {
                $msg = '';
                $status = 'failed';
                $condition = "auth_id =" . $co_author_id;
                $author_id = Authors::get_single_record('auth_usr_id,auth_corr_author,auth_posted_by', $condition);
                $genereate_pdf_changed = FALSE;
                if ($author_id->auth_usr_id == $current_user['user_id']) {
                    $msg = 'You do not have permission to access that page';
                    return $this->warning('failure', 201, $msg);
                } else {
                    // $classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
                    $article_table = (new \App\Models\Articles())->getTable();
                    $authors_table = (new \App\Models\Authors())->getTable();
                    $users_table = (new \App\Models\User())->getTable();
                    $tables = array(
                        'main_table' => $authors_table,
                        'join_table' => array(
                            $users_table => array('auth_usr_id', 'usr_id', 'left'),
                            $article_table => array('auth_art_id','art_id','left')
                        )
                    );
                    $select_fields = 'auth_art_id,usr_email as auth_email,auth_usr_id,art_es_document_status,art_es_document_type';
                    $criteria = 'auth_id =' . $co_author_id;
                    $author_det = Authors::get_results_using_joins($tables, $select_fields, $criteria, '');
                    $art_status =  Articles::get_single_record('art_status,art_artp_id,art_pre_all_ids', 'art_id =' . $author_det[0]->auth_art_id);

                    Authors_affiliation::delete_records('auaff_auth_id =' . $co_author_id,'', $current_user);
                    $auth_user_id = Authors::find($co_author_id, ['auth_usr_id'])?->auth_usr_id;
                    Authors::delete_records($condition, '', $current_user);
                    if($author_det[0]->art_es_document_status == 'y')
                    {
                        $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                        $es_api_data  = Config::get($es_config);
                        $apiUrl = $es_api_data['co_author_delete'];
                        $pass_arr =  array('usr_id' => Rv_encrypt($author_det[0]->auth_usr_id),'art_id' => Rv_encrypt($array['article_id']));
                        $response = $this->es_curl_request($apiUrl,$pass_arr);
                        $response = json_decode($response);
                    }
                    $status = 'success';
                    $msg = 'Co-author deleted';

                    // Task #925 if any authr has removed from the article, run the rvri report
                    if(isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
                    {
                        $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type', 'atotp_artp_id=' . $art_status->art_artp_id); 
                        if($article_type_options->atotp_research_integrity == 'y' && $art_status->art_status == 'y'){
                            if($article_type_options->atotp_rvrisubmission_type == 'auto')
                                $this->generateresearchintegrity($array['article_id'], $array['current_flow_id']);
                            else {
                                $data_rri   =   array();
                                $data_rri['rri_new_report'] = 'n';
                                Research_integrity_reports::update_record($data_rri, 'rri_art_id=' . $array['article_id'], $current_user);
                            }
                        }
                    }

                    archiveUserFromDiscloserList::dispatch($array['article_id'], $auth_user_id);
                    $this->change_article_pdf_status($author_det[0]->auth_art_id, $current_user);
                    $confirm_status = $this->get_user_confirm_status($author_det[0]->auth_art_id, $art_status->art_artp_id, $jnl_id);
                    if ($art_status->art_status != 'n' || $art_status->art_pre_all_ids != '') {
                        // TASK #8861 start
                        $Email_templates = new \App\Models\Email_templates();
                        $email_record= $Email_templates::get_single_record_with_bind_cond('*', array(
                            'etmp_name' => 'coauthor_remove_notification',
                            'etmp_notification' => 'User'
                    ));
                       $current_status_id = '';
                       $status_record = Article_flow::get_single_record_with_bind_cond('aflw_id', array(
                       'aflw_art_id' => $author_det[0]->auth_art_id,
                       'aflw_status' => 'a',
                       'aflw_returned_date' => NULL));
                       if(!empty($status_record)){
                        $current_status_id = $status_record->aflw_id;  
                       } 
                       if(!empty($email_record))
                       {
                           $custom_data = array(
                            'esl_etmp_action'=>'coauthor_deleted',
                            'coauthor_notify'=>true,
                            'jnl_id'=>$jnl_id,
                            'jnl_code'=>$jnl_code,
                            'article_id'=>$author_det[0]->auth_art_id,
                            'artp_id'=>$art_status->art_artp_id,

                        );
                        if (!empty($current_status_id)){
                             $custom_data['aflw_id'] =$current_status_id;
                        }

                        $email_data = array(
                            'type' => 'global',
                            'action' => 'send',
                            'email_with_login' => true,
                            'user_id' => $author_det[0]->auth_usr_id,
                            'empt_name' => 'coauthor_remove_notification',
                            'jnl_user_role'=>array(
                              'jnl_journal_code'=> $jnl_code
                          ),
                            'custom_data' => $custom_data
                        );
                
                        $this->master_email_details($email_data);
                       }               
                     // TASK #8861 end
                      }
                    return $this->success('success', 201, $msg);
                }
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function seek_confirmation(Request $request)
    {
        try {
            $return_arr = array(
                'status' => 'error'
            );
            $post_data = $request->all();
            $current_user = $this->get_current_user_details();
            if (!empty($post_data['userid']) && !empty($post_data['corresp']) && !empty($post_data['artid'])) {
                $user = User::get_single_record('usr_id,usr_first_name,usr_last_name,usr_email,usr_activation,usr_status,usr_deeplink_token', 'usr_id=' . decrypt_link($post_data['userid']));

                $article = Articles::get_single_record('art_id,art_artp_id,art_title,art_submitted_by', 'art_id=' . decrypt_link($post_data['artid']));
                if (!empty($user) && !empty($article)) {
                    $auth_deeplink_token = Str::random(16);
                    $user_deeplink_token = "";
                    $general_config= Config::get('general_config');
                    $deeplink_token_attempts = $general_config['deeplink_token_attempts'];
                    $author_role_id = Roles::get_single_record('role_id','role_assigned_role = "author"');
                    Authors::update_record(array(
                        'auth_confirm_status' => 'i',
                        'auth_deeplink_token' => $auth_deeplink_token, 'auth_deeplink_token_attempts' => $deeplink_token_attempts), 'auth_usr_id=' . decrypt_link($post_data['userid']) . ' AND auth_art_id =' . decrypt_link($post_data['artid']), $current_user);
                    if ($user->usr_status == 'n' || $user->usr_status == 'w')
                    {
                        if (!empty($user->usr_deeplink_token))
                            $user_deeplink_token = $user->usr_deeplink_token;
                        else
                        {
                            $user_deeplink_token = Str::random(16);
                            User::update_record(array(
                                'usr_status' => 'w',
                                'usr_deeplink_token' => $user_deeplink_token, 'usr_deeplink_token_attempts' => $deeplink_token_attempts), 'usr_id=' . decrypt_link($post_data['userid']), $current_user);
                        }
                    }
                    elseif ($user->usr_status == 'a' && $user->usr_deeplink_token != '')
                    { //existing user with non empty deeplink_token
                        $user_deeplink_token = $user->usr_deeplink_token;
                    }
                    $journal_data = Journals::get_single_record('jnl_id,jnl_journal_name,jnl_journal_code', 'jnl_id=' . decrypt_link($post_data['jnl']));

                    $orginalAuthor = User::get_single_record('usr_first_name,usr_last_name', 'usr_id=' . $article->art_submitted_by);

                    $record = Email_templates::get_single_record('*', "etmp_name = 'co_author_confirmation' AND etmp_notification ='User'");
					$link = URL::to('/').'/'. $this->current_client->platform_type .'/'. $journal_data->jnl_journal_code . '/author-invitation-accept?' . encrypt_link('&ukey=' . $user_deeplink_token . '&akey=' . $auth_deeplink_token . '&userid=' . $user->usr_id . '&articletype_id=' . $article->art_artp_id . '&article_id=' . $post_data['artid'] . '&rid='.$author_role_id->role_id);
                    if ($record != NULL)
                    {
                        $custom_data = array(
                            'confirmation_link' => $link,
                            'esl_etmp_action'=>'co_author_confirmation',
                            'coauthor_notify'=>True,
                            'jnl_id'=>$journal_data->jnl_id,
                            'jnl_code'=>$journal_data->jnl_journal_code,
                            'article_id'=>decrypt_link($post_data['artid']),
                            'artp_id'=>$article->art_artp_id,
                        ); // commit for sarath bugfix at the time of seek confirmation.
                        $email_data = array(
                            'type' => 'global',
                            'action' => 'send',
                            'email_with_login' => TRUE,
                            'user_id' => $user->usr_id,
                            'empt_name' => $record->etmp_name,
                            'jnl_user_role'=>array(
                            'core_role'=>$post_data['core_role'],
                            'role_name'=>$post_data['role_name'],
                            'jnl_journal_code'=> $journal_data->jnl_journal_code
                        ),
                            'custom_data' => $custom_data
                        );
                        $this->master_email_details($email_data);
                        $return_arr['status'] = 'success';
                        $return_arr['msg'] = customTrans('viewarticle.successfully_send_invitation');
                        return $this->success('success', 201, $return_arr);
                    }else{
                        $return_arr['msg'] = customTrans('viewarticle.email_template_not_found');
                    }
                }else{
                    $return_arr['msg'] = customTrans('viewarticle.user_or_article_not_found');
                }
                return $this->success('warning', 201, $return_arr);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function authorConfirmInvitation(Request $request)
    {
        try {
            $post_data = $request->all();
            $return_arr = array(
                'status' => 'error',
                'msg' => "Error occured"
            );
            $current_user = $this->get_current_user_details();
            $userid = $post_data['userid'];
            $artid = $post_data['artid'];
            if (!empty($userid) && !empty($artid)) {

                Authors::update_record(array(
                    'auth_enabled_seek_confirm' => 'y',
                    'auth_confirm_status' => 'y',
                    'auth_deeplink_token' => '',
                    'auth_deeplink_token_attempts' => ''
                ),  'auth_usr_id=' . decrypt_link($post_data['userid']) . ' AND auth_art_id=' . decrypt_link($post_data['artid']), $current_user);

                $return_arr['status'] = "success";
                $return_arr['msg'] = customTrans('viewarticle.author_invitation_confirmation_success');
                return $this->success('warning', 201, $return_arr);
            }
        } catch (\Exception $e) {
            // print_r($e);
            // die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function changeAuthorOrder(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $ordering_list = $post_data["ordering_lst"];
            $article_id = decrypt_link($post_data['art_id']);
            $return_arr = array(
                'status' => 'err',
                'msg' => 'Error: Update failed',
            );
            if (count($ordering_list) > 0) {
                $i = 0;
                foreach ($ordering_list as $author_order) {
                    $order = $i;
                    $data = array(
                        'auth_order' => $order
                    );
                    $update_condition = 'auth_id =' . $author_order['auth_id'] . ' AND auth_order !=' . $order;
                    Authors::update_record($data, $update_condition, $current_user, '', 'e');
                    $i++;
                    // $auth_id = decrypt_link($author_order);
                }
                $this->change_article_pdf_status($article_id, $current_user);
                $return_arr['status'] = 'success';
                $return_arr['msg'] = 'List updated successfully';
            }
            return $this->success('success', 201, $return_arr);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function getStageNames(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_type_id' => 'required',
                'search_query' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $articletype_id = decrypt_link($post_data['art_type_id']);
            $Article_types = new \App\Models\Article_types();
            $Generic_flows = new \App\Models\Generic_flows();
            $user_data = $this->get_current_user_details();
            $results = array();
            $return_arr = array();
            $work_flow_conf = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config';
            $review_config= Config::get($work_flow_conf);
            $review_flow = $review_config['review_flow'];
            $stage_type = array();
            foreach ($review_flow as $key => $re_flw)
            {
                if (is_array($re_flw['roles']) == TRUE)
                {
                    if (isset($re_flw['roles']) && (!in_array("author", $re_flw['roles'])))
                        {
                            $stage_type[] = '"'.$key.'"';
                        }
                }
            }
            $include_types = implode(',',$stage_type);
            $exclude_flow = '';
            $jnl_id = decrypt_link($post_data['jnl_id']);
            if(isset($post_data['selected_stages']))
            {
                if(count($post_data['selected_stages']) > 0)
                {
                    $exclude_flow = ' AND jwf_id NOT IN('.implode(',',$post_data['selected_stages']).')';
                }
            }
            $sql = "select `jwf_id`, `jwf_stage_name` from `rvw_journal_workflows` inner join `".$Article_types->getTable()."` on `jwf_fwm_id` = `artp_fwm_id` where `artp_abbr_article_type` = '".$articletype_id."' AND `artp_jnl_id`=".$jnl_id." AND `jwf_stage_name` LIKE '%".$post_data['search_query']."%' AND jwf_hide_status != 'y' AND `jwf_stage_type` IN(".$include_types.") ".$exclude_flow;
            $stage_name_list = $Generic_flows::get_records_by_raw_query($sql);

            foreach ($stage_name_list as $stage)
            {
                $results[] = array(
                    'value' => $stage->jwf_id,
                    'label' => $stage->jwf_stage_name
                );
            }
            $return_arr['status'] = 'success';
            $return_arr['output'] = $results;
            return $this->success('success', 201, $return_arr);

        }
        catch (\Exception $e) {
                return  $this->failure('Failed', 500, $e);
        }
    }

    public function submissionViaZip(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $return_arr = array();
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
                'file' => 'clamav',
                'jnl_code'=>'required'
            ],[
                'file.clamav' => 'The :attribute contains a virus!',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'error' => $validator->errors()->first('file'),
                    'file'=>$post_data['file']->getClientOriginalName(),
                    'type'=>'clamav'
                ], 200);
            }
            $attachment_file = $post_data['file'];
            $filenameWithoutExtension['filename'] = $name = $attachment_file->getClientOriginalName();
            if(isset($filenameWithoutExtension['filename']))
            {
                $validator = Validator::make($filenameWithoutExtension , [
                    'filename'      => 'required|regex:/^[a-zA-Z0-9(),_,-^]+$/'
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
            }
            $folder_name = basename($name,'.zip');
            $path = 'tmp_article_zip'.DIRECTORY_SEPARATOR;
            $uploaded_file_details = $this->upload_file_handler($path, $attachment_file, $name);
            $file_path = Config::get('general_config.file_retrieval')['file_path'];
            if(file_exists(public_path().$file_path.'/'.$path.$name))
            {
                $zip = new ZipArchive;
                $res = $zip->open(public_path().$file_path.'/'.$path.$name);
                $zip_path = public_path().$file_path.'/'.$path.$name;
                if ($res === true) {
                    $zip->extractTo(public_path().$file_path.'/'.$path.'/'.$folder_name.'/');
                    $zip->close();
                    $scan_dir = scandir(public_path().$file_path.'/'.$path.'/'.$folder_name.'/');
                    $xml_file = '';
                    if(!empty($scan_dir))
                    {
                        foreach($scan_dir as $single_scan)
                        {
                            $ext = pathinfo($single_scan, PATHINFO_EXTENSION);
                            if(strtolower($ext) == 'xml')
                            {
                                $xml_file = $single_scan;
                            }
                        }
                    }
                    $directory = public_path().$file_path.'/'.$path.$folder_name.'/';
                    if($xml_file !== '')
                    {
                        try
                        {
                            $file_path = $directory.$xml_file;
                            $read_data = $this->read_xml_file($file_path);
                            if($read_data['status'] == 'success')
							{
                                $read_data['copy_source_path'] = $directory;
                                $read_data['copy_zip_path'] = $zip_path;
                                $article_save_data = $this->save_xml_file_data($read_data);
                                if($article_save_data['status'] == 'success')
                                {
                                    $article_save_data['completed'] = TRUE;
                                    $return_arr['status'] = 'success';
                                }
                                else
                                {
                                    $this->remove_uploaded_files($directory,$zip_path);
                                    $return_arr['status'] = 'failed';
                                }
                                $return_arr['data'] = $article_save_data;
                                return  $this->success('Success', 200, $return_arr);
                            }
                            else
                            {
                                $this->remove_uploaded_files($directory,$zip_path);
                                $return_arr['status'] = 'failed';
                                $return_arr['data'] = $read_data;
                                return  $this->success('Success', 200, $return_arr);
                            }
                        }
                        catch(\exeception $e)
                        {
                            return  $this->failure('Failed', 500, $e);
                        }
                    }
                    else
                    {
                        $this->remove_uploaded_files($directory,$zip_path);
                        $errors = [
                            'filename' => 'XML file missing'
                        ];
                        return $this->warning('error',200,$errors);
                    }
                } else {
                    return  $this->warning('Failed', 500, $e);
                }

            }
            else
            {
                return  $this->warning('Failed', 500, $e);
            }
        }
        catch(\exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function remove_uploaded_files($directory,$zip_path)
    {
        $iterate_files = new RecursiveDirectoryIterator($directory, RecursiveDirectoryIterator::SKIP_DOTS);
        $all_files = new RecursiveIteratorIterator($iterate_files,RecursiveIteratorIterator::CHILD_FIRST);
        foreach($all_files as $s_file) {
            if($s_file->isDir())
            {
                rmdir($s_file->getRealPath());
            }
            else
            {
                unlink($s_file->getRealPath());
            }
        }
        rmdir($directory);
        unlink($zip_path);
    }

    public function read_xml_file($path,$auto_import_flag = FALSE,$csv_data = array(),$artp_name_flag = FALSE)
    {
        try
        {

        $xml_file_contents = file_get_contents($path);
		libxml_use_internal_errors(true);
        $article = simplexml_load_string($xml_file_contents, 'SimpleXMLElement', LIBXML_NOCDATA);
        if (!$article)
		{
            $errors = libxml_get_errors();
            $xml_errors = array();
			if (!empty($errors))
			{
				foreach ($errors as $error)
				{
					array_push($xml_errors, $error->message);
				}
			}
			$return_array['xml_errors_array'] = $xml_errors;
			$return_array['status'] = 'fail';
		}
		elseif($artp_name_flag == TRUE)
		{
		    $doc = new DOMDocument;
			$doc->loadXML($xml_file_contents);
			$xpath = new DOMXPath($doc);
			$article_type = $xpath->query("//article-categories/subj-group[@subj-group-type='heading']/subject");
			$artp_name = '';
			if ($article_type->length > 0)
			{
				$art_type = trim($article_type->item(0)->nodeValue);
				$artp_name = trim($art_type);
			}
			return strtolower($artp_name);
		}
		else
		{
			$doc = new DOMDocument;
			$doc->loadXML($xml_file_contents);
			$xpath = new DOMXPath($doc);
			$xml_data = [];
			$xml_fields = array();
			$xml_article_array = array();
			$elms_id_arr = array();
			$xml_errors = array();
			$xml_article_array = array();

			/* Check xml duplicate  id in xml */
			$elms_with_id = $xpath->query("//*[@id]");

			for ($j = 0; $j < $elms_with_id->length; $j++)
			{
				$elms_item = $elms_with_id->item($j);
				if ($elms_item->hasAttribute('id'))
				{
					array_push($elms_id_arr, $elms_item->getAttribute('id'));
				}
			}

			if (count($elms_id_arr) != count(array_flip($elms_id_arr)))
			{
				$dup_id_arr = array_unique(array_diff_assoc($elms_id_arr, array_unique($elms_id_arr)));
				$comma_separated_dup_id = implode(", ", $dup_id_arr);
				$xml_fields["dup_id"] = $comma_separated_dup_id;
				array_push($xml_errors, customTrans('viewarticle.duplicate_xml_ids_found'));
				$xml_fields["error_key"] = "duplicate_id_exist";
				array_push($xml_data, $xml_fields);
			}
			$article_id = '';
			$article_id_temp = '';
			$journal_code = '';
			$article_doi = '';
			$art_type = '';
			$journal_title_value = '';
			$art_abstract = '';
			$art_title = '';
			$pdfname = '';
			/* journal code get in xml */
			$journal_type = $xpath->query("//journal-id[@journal-id-type='publisher-id']");
			if ($journal_type->length > 0)
			{
			    $journal_code = $journal_type->item(0)->nodeValue;
				$xml_article_array['journl_id'] = trim($journal_code);
			}
			else
			{
                /*lang*/
				$xml_fields["error_key"] = "no_journal_id";
				array_push($xml_errors, customTrans('viewarticle.jounal_code_not_found'));
			}
			/* */
			$journal_title = $xpath->query("//journal-title");
			if ($journal_title->length > 0)
			{
				$journal_title_value = $journal_title->item(0)->nodeValue;
				$xml_article_array['journl_title'] = trim($journal_title_value);
			}
			else
			{
                /*lang*/
				$xml_fields["error_key"] = "no_journal_title";
				array_push($xml_errors, customTrans('viewarticle.journal_title_not_found'));
			}

			/* article  code get in xml */
			/*
			    $article_id_value = $xpath->query("//article-id[@pub-id-type='publisher-id']");
				if ($article_id_value->length > 0)
				{
					$article_id = $article_id_value->item(0)->nodeValue;
					$xml_article_array['article_id'] = trim($article_id);
				}
				else
				{
				    $xml_fields["error_key"] = "no_article_id";
					array_push($xml_errors, lang('article_code_not_found'));
				}
			*/
			/* article  doi get in xml */
			$article_doi_value = $xpath->query("//article-id[@pub-id-type='doi']");
			if ($article_doi_value->length > 0)
			{
				$article_doi = $article_doi_value->item(0)->nodeValue;
				$xml_article_array['article_doi'] = trim($article_doi);

                /* article  code get in xml */
                $doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
                $doi_details  = Config::get($doi);
				$article_id = trim(str_replace($doi_details['doi_predix'], '', $xml_article_array['article_doi']));
                $xml_article_array['article_id'] = $article_id;
				$article_id_temp = strtolower($article_id);
			}
			else
			{
                // lang
				$xml_fields["error_key"] = "no_article_doi";
				array_push($xml_errors, customTrans('viewarticle.article_doi_not_found'));
				array_push($xml_errors, customTrans('viewarticle.article_code_not_found'));
			}
			/* article  title get in xml */
			$article_type = $xpath->query("//article-categories/subj-group[@subj-group-type='heading']/subject");
			if ($article_type->length > 0)
			{
				$art_type = trim($article_type->item(0)->nodeValue);
				$xml_article_array['article_type'] = trim($art_type);
			}
			else
			{
			    $xml_fields["error_key"] = "no_article_type";
				array_push($xml_errors, customTrans('viewarticle.article_type_not_found'));
			}
			/* Abstract Article  get in xml */
			$abstract_node = $xpath->query("//abstract");
			if ($abstract_node->length > 0)
			{
				$art_abstract = $abstract_node->item(0)->nodeValue;
				$xml_article_array['article_abstract'] = $this->xmlEscape($art_abstract);
			}
			else
			{
				$xml_fields["error_key"] = "no_article_abstract";
				array_push($xml_errors, customTrans('viewarticle.article_abstract_not_found'));
			}
			/* Article  title  get in xml */
			$art_title_node = $xpath->query("//article-title");
			if ($art_title_node->length > 0)
			{
			    $art_title = $art_title_node->item(0)->nodeValue;
				$xml_article_array['article_title'] = $this->xmlEscape($art_title);
			}
			else
			{
                // lang
			    $xml_fields["error_key"] = "no_article_title";
				array_push($xml_errors, customTrans('viewarticle.article_title_not_found'));
			}
			/* Article  Pdf name  get in xml */
			$art_pdfname_node = $xpath->query("//self-uri[@content-type='pdf']");
			if ($art_pdfname_node->length > 0)
			{
				$pdfname = $art_pdfname_node->item(0)->getAttribute("xlink:href");

				/*checking pdf file exist in folder*/
				if(!file_exists($path.$pdfname) && $auto_import_flag == TRUE)
				{
					$pdfname = strtolower($pdfname);
					if(!file_exists($path.$pdfname))
					{
                        // lang
						$xml_fields["error_key"] = "no_pdf_file";
						array_push($xml_errors, customTrans('viewarticle.no_pdf_file'));
					}
				}

				$xml_article_array['pdfname'] = $pdfname;
			}
			else
			{
                // lang
				$xml_fields["error_key"] = "no_pdf_name";
				array_push($xml_errors, customTrans('viewarticle.no_pdf_name'));
			}
			if($auto_import_flag == TRUE)
			{
				/*Fetching article submit date*/
				$art_submit_dt_node = $xpath->query("//history/date[@date-type='received']");
				$xml_article_array['submit_date'] = $this->get_date_from_node($xpath,$art_submit_dt_node);
				if($xml_article_array['submit_date'] == '')
				{
                    // lang
					$xml_fields["error_key"] = "no_submit_date";
					array_push($xml_errors, customTrans('viewarticle.no_submit_date'));
				}

				/*Fetching article accepted date*/
				$art_acpt_dt_node = $xpath->query("//history/date[@date-type='accepted']");
				$xml_article_array['accept_date'] = $this->get_date_from_node($xpath,$art_acpt_dt_node);
				if($xml_article_array['accept_date'] == '')
				{
                    // lang
					$xml_fields["error_key"] = "no_acpt_date";
					array_push($xml_errors, customTrans('viewarticle.no_acpt_date'));
				}

				/*Fetching article epub date*/
				$art_epub_dt_node = $xpath->query("//pub-date[@pub-type='epub']");
				$xml_article_array['epub_date'] = $this->get_date_from_node($xpath,$art_epub_dt_node,TRUE);

				/*Fetching article ppub date*/
				$art_ppub_dt_node = $xpath->query("//pub-date[@pub-type='ppub']");
				$xml_article_array['ppub_date'] = $this->get_date_from_node($xpath,$art_ppub_dt_node,TRUE);
			}

			/* article meta information */
			$meta_data = [
						"fpage",
						"lpage"];
			foreach ($meta_data as $meta)
			{
				$meta_val = "";
				$meta_elms = $xpath->query("//$meta");
				if ($meta_elms->length > 0)
				{
					$meta_val = $meta_elms->item(0)->nodeValue;
				}
				$xml_article_array[$meta] = $meta_val;
			}

			/* article publishing information */
			$pub_data = ["epub"];
			foreach ($pub_data as $pub)
			{
				$pub_val = "";
				$pub_elms = $xpath->query("//issn[@pub-type='$pub']");
				if ($pub_elms->length > 0)
				{
					$pub_val = $pub_elms->item(0)->nodeValue;
				}
				$xml_article_array[$pub] = $pub_val;
			}

			/* Get author List push into in an array  */

			$mainauthorarray = array();
			$corresponding_author = $xpath->query("//contrib-group/contrib[@contrib-type='author']");
			$corresp_auth_flag = FALSE;
			$corresp_auth_email_flag = FALSE;
			$main_email_arrray = array();

			for ($i = 0; $i < $corresponding_author->length; $i++)
			{
			    $authorarray = array();
				$authornode = $corresponding_author->item($i);
				$authorarray['corresp'] = 'n';
				if($authornode->getAttribute("corresp") == 'yes')
				{
					$authorarray['corresp'] = 'y';
					$corresp_auth_flag = TRUE;
				}

				$author_childs = $xpath->query('./*', $authornode);
				$cor = 1;

				$cores_author_id = $authornode->getAttribute("rid");
				$corresponding_author_email = $xpath->query("//contrib-group/contrib[@contrib-type='author'][@rid='$cores_author_id']");

				$authorarray['cor_id'] = $authornode->getAttribute("rid");
				for ($j = 0; $j < $author_childs->length; $j++)
				{
					$name_node = $author_childs->item($j);
					$namechilds = $xpath->query('./*', $name_node);
					for ($k = 0; $k < $namechilds->length; $k++)
					{
						if ($namechilds->item($k)->nodeName == 'surname')
						{
							$authorarray['surname'] = $namechilds->item($k)->nodeValue;
						}
						if ($namechilds->item($k)->nodeName == 'given-names')
						{
							$authorarray['givenname'] = $namechilds->item($k)->nodeValue;
						}

					}
					if ($author_childs->item($j)->nodeName == 'degrees')
					{
						$authorarray['degrees'] = $author_childs->item($j)->nodeValue;
					}
					if ($author_childs->item($j)->nodeName == 'role')
					{
						$authorarray['role'] = $author_childs->item($j)->nodeValue;
					}
					if ($author_childs->item($j)->nodeName == 'aff')
					{
						$authorarray['aff'] = $this->xmlEscape($author_childs->item($j)->nodeValue);
					}
				}
				$cor++;

			    /* Get author email array cration */

				$email_arry = array();
				//$main_email_arrray = array();
				$main_email_arrray = array();
				$art_corre_author_email = $xpath->query("//corresp/email");
				$art_corre_id = $xpath->query("//corresp");
				if ($art_corre_author_email->length > 0)
				{
					$email_id_data = trim($art_corre_author_email->item(0)->nodeValue);
					$eid = trim($art_corre_id->item(0)->getAttribute('id'));
					if(valid_email($email_id_data) == TRUE && $eid!= '')
					{
			        	$email_arry['email_id'] = $email_id_data;
						$email_arry['cor_id'] = trim($art_corre_id->item(0)->getAttribute('id'));
					}
		    		$main_email_arrray[] = $email_arry;
				}

				if (isset($authorarray['surname']) && ($authorarray['surname'] != '') && isset($authorarray['givenname']) && ($authorarray['givenname'] != '') && isset($authorarray['aff']) && ($authorarray['aff'] != ''))
				{
					$mainauthorarray[] = $authorarray;
				}
			}

			$author_info_detila_array = $this->generate_author_details_array($mainauthorarray, $main_email_arrray);
			if($auto_import_flag == TRUE && ($corresp_auth_flag == FALSE || count($author_info_detila_array) == 0) && isset($csv_data[$article_id_temp]) && $csv_data[$article_id_temp]['Corresponding author email'] != '')
			{
				$csv_art_data = $csv_data[$article_id_temp];
				$csv_user_email = trim($csv_art_data['Corresponding author email']);
				if(valid_email($csv_user_email) == TRUE)
				{
					$copy_corsp_flag = TRUE;
					$corresp_auth_email_flag = TRUE;
					if($corresp_auth_flag == FALSE && count($author_info_detila_array) > 0)
					{
						foreach ($author_info_detila_array as $key => $auth_arr)
						{
							if($auth_arr['email_id'] == $csv_user_email)
							{
								$auth_arr['corresp'] = 'y';
								$copy_corsp_flag = FALSE;
								$author_info_detila_array[$key] = $auth_arr;
							}
						}
					}

					if($copy_corsp_flag == TRUE)
					{
						$cor_au_arr = array();
						$cor_au_arr['givenname'] = $csv_art_data['Corresponding author First Name'];
						$cor_au_arr['surname'] = $csv_art_data['Corresponding author Last Name'];
						$cor_au_arr['email_id'] = $csv_user_email;
						$cor_au_arr['corresp'] = 'y';
						$author_info_detila_array[] = $cor_au_arr;
						$mainauthorarray[] = $cor_au_arr;
					}
				}
						$corresp_auth_flag = TRUE;
			}

			$xml_article_array['author_list_array'] = $author_info_detila_array;
			/* Get Keyword list in xml */

			$keywordnode = $xpath->query("//kwd-group/kwd");
			$keywordarray = array();
			for ($m = 0; $m < $keywordnode->length; $m++)
			{
				if ($keywordnode->item($m)->nodeName == 'kwd')
				{
				    $keywordarray[] = $this->xmlEscape($keywordnode->item($m)->nodeValue);
				}
			}
			$xml_article_array['keyword_list_array'] = $keywordarray;

			/* Chek Author and Keyword empty or not */
			if (empty($author_info_detila_array) && $auto_import_flag == FALSE)
			{
                $xml_fields["error_key"] = "no_author";
				array_push($xml_errors, customTrans('viewarticle.article_authors_not_found'));
			}
			//corresp="yes"  for all xml
			if ($corresp_auth_flag == FALSE && $auto_import_flag == TRUE)
			{
                // lang
				$xml_fields["error_key"] = "corresp_author_missing";
				array_push($xml_errors, customTrans('viewarticle.corresp_author_missing'));
			}

			if ($corresp_auth_email_flag == FALSE && $auto_import_flag == TRUE)
			{
                // lang
				$xml_fields["error_key"] = "corresp_author_eamil_invalid";
				array_push($xml_errors, customTrans('viewarticle.corresp_author_eamil_invalid'));
			}
			if (empty($keywordarray) && $auto_import_flag == FALSE)
			{
                // lang
				$xml_fields["error_key"] = "no_keyword";
				array_push($xml_errors,customTrans('viewarticle.article_keywords_not_found'));
			}
			$return_array = array();
			if ($journal_code != '' && $journal_title_value != '' && $article_id != '' && $pdfname != '' && $article_doi != '' && $art_abstract != '' && $art_type != '' && $art_title != '' && ((!empty($keywordarray) && $auto_import_flag == FALSE) || $auto_import_flag == TRUE) && (!empty($mainauthorarray)) && (empty($xml_fields)))
			{
				$return_array['status'] = 'success';
				$return_array['article_data'] = $xml_article_array;
				$return_array['xml_errors_array'] = $xml_errors;
			}
			else
			{
				$return_array['error'] = $xml_fields;
				$return_array['status'] = 'fail';
				$return_array['xml_errors_array'] = $xml_errors;
            }

        }
        return $return_array;
    }
    catch(\exception $e)
    {
        return  $this->failure('Failed', 500, $e);
    }
    }

    function xmlEscape($string)
	{
		return htmlspecialchars_decode($string);
    }

    public function generate_author_details_array($mainauthorarray, $main_email_arrray)
	{
		$mainauthorarr = array();
		if (!empty($mainauthorarray))
		{
			foreach ($mainauthorarray as $author_arr)
			{
				if ($main_email_arrray)
				{
					foreach ($main_email_arrray as $value)
					{
						$email = FALSE;
						if ($value['cor_id'] == $author_arr['cor_id'])
						{
							$author_arr['email_id'] = $value['email_id'];
							$email = TRUE;
						}
					}
					if ($email == TRUE)
						$mainauthorarr[] = $author_arr;
                }
			}
		}
		return $mainauthorarr;
    }

    function save_xml_file_data($data,$auto_import_flag = FALSE,$config_jnl_artps = array())
	{

        $Terms = new \App\Models\Terms();
        $Casrai_credits =  new \App\Models\Terms();
        $Journal_terms = new \App\Models\Journal_terms();
        $Keyword_category = new \App\Models\Keyword_category();
        $Keywords = new \App\Models\Keywords();
        $Journal_metadata = new \App\Models\Journal_metadata();
        $Users = new \App\Models\User();
        $Author_credits = new \App\Models\Author_credits();
        $current_user = $this->get_current_user_details();
		$xml_errors_array = [];
		$xml_errors = array();
		//current journal details
		//$journal_id = $this->jnl_data->jset_jnl_id;
		//$journal_code = $this->journal_code;

		//uploaded journal details
		$journal_code=$data['article_data']['journl_id'];
        /* Get Journal details */
        $journal_dtails =Journals::get_single_record('jnl_id,jnl_journal_code','jnl_journal_code ="'.$journal_code.'"');
		if(empty($journal_dtails))
		{
		    array_push($xml_errors, customTrans('viewarticle.jnl_mismatch'));
			$return_array['status'] = 'fail';
			$return_array['msg'] = 'jnl_mismatch';
		}
		else
		{
			$journal_id=$journal_dtails->jnl_id;
		/* Get the article type  id details given  zip file article_type name */
		$article_type_name = trim($data['article_data']['article_type']);

		$jurnl_id = $journal_dtails->jnl_id;
        $art_type_dtails = Article_types::get_single_record('artp_id','artp_article_type ="'.$article_type_name.'" AND artp_jnl_id ='.$jurnl_id);
		$article_type_id = '';
		$article_type_name = strtolower($article_type_name);
		if (isset($art_type_dtails->artp_id) && ($art_type_dtails->artp_id != ''))
		{
			$article_type_id = $art_type_dtails->artp_id;
		}
		elseif($auto_import_flag == TRUE && isset($config_jnl_artps[$article_type_name]))
		{
			$art_type_dtails = Article_types::get_single_record('artp_id','artp_article_type = "'.$config_jnl_artps[$article_type_name].'" AND artp_jnl_id ='.$jurnl_id);

			if(count($art_type_dtails) > 0)
			{
				$article_type_id = $art_type_dtails->artp_id;
			}
		}

		/* check article type id exist or not */
		if ($article_type_id != '')
		{
			/* check article code exis in db */
			$article_code = $data['article_data']['article_id'];
			$check_code_exist = Articles::get_single_record('art_code','art_code ="'.$article_code.'"');
			/* Not founnd then insert details into db */
			if (empty($check_code_exist))
			{

				/* Retrieve the article related data */
                $jnl_id = $data['article_data']['journl_id'];
				$article_data_list['art_code'] = $data['article_data']['article_id'];
				$article_data_list['art_doi'] = $data['article_data']['article_doi'];
				$article_data_list['art_title'] = $data['article_data']['article_title'];
				$article_data_list['art_abstract'] = $data['article_data']['article_abstract'];
				$article_data_list['art_status'] = 'n';
				$article_data_list['art_submitted_by'] = $current_user['user_id'];

				$submission_method = 'z';
				if($auto_import_flag == TRUE)
					$submission_method = 'p';

				$article_data_list['art_stage_submission_method'] = $submission_method;
				$article_data_list['art_published_article_type'] = $article_type_id;
				$article_data_list['art_artp_id'] = $article_type_id;
				$article_data_list['art_submission_date'] = isset($data['article_data']['submit_date']) ? $data['article_data']['submit_date'] : date('Y-m-d H:i:s');

				/* Retrieve article type advance option  given article type id basis */
				$article_details = Article_type_advance_options::get_all_records('*','atotp_artp_id ='.$article_type_id);
				/* Get the article Type details */
				$article_jnlid = Article_types::get_single_record('artp_id,artp_jnl_id, artp_fwm_id,artp_prefix_article_no,artp_abbr_article_type,artp_article_type', 'artp_id ='.$article_type_id);
				$jnl_hdn_id = $article_jnlid->artp_jnl_id;
				/* get the details article publishing workkflow id for submitted article going through publish stage */
				$publish_stage_id = NULL;
				$publish_role_id = NULL;
				if (isset($article_jnlid->artp_fwm_id))
				{
					$jwf_id_publish = Generic_flows::get_single_record('jwf_id,jwf_role_id','jwf_fwm_id ='. $article_jnlid->artp_fwm_id .' AND jwf_stage_type ="publish"');

					$pubish_jwf_id[] = $jwf_id_publish->jwf_id;
					$publish_stage_id = $jwf_id_publish->jwf_id;
					$publish_role_id = $jwf_id_publish->jwf_role_id;
					$article_data_list['art_submitted_current_stage'] = json_encode($pubish_jwf_id);
				}



				/* insert the basic details in article */

				DB::beginTransaction();
				$article_id = Articles::insert_record($article_data_list, $current_user);

				/* Get the article authors and insertthe details  */
				if (!empty($data['article_data']['author_list_array']))
				{
					$authorslist = $data['article_data']['author_list_array'];
					$usr_status = 'w';
					$user_find_cond = ' and (usr_status = \'a\' or usr_status = \'w\') ';
					if($auto_import_flag == TRUE)
					{
						$usr_status = 'a';
						$user_find_cond = '';
					}

					foreach ($authorslist as $co_author)
					{
						if (isset($co_author['email_id']) && ($co_author['email_id'] != ''))
						{
							$condition = "usr_email='" . $co_author['email_id'] . "'";
							$j_id = NULL;
                            $user_data = $Users::get_user_by_email_journal($condition, $j_id);
                            /* insert the user table when the author not exist the user table */
							if(count($user_data) == 0)
							{
								$user_details = array(
									'usr_username' => $co_author['email_id'],
									'usr_first_name' => $co_author['givenname'],
									'usr_last_name' => $co_author['surname'],
									'usr_email' => $co_author['email_id'],
									'usr_title' => '',
									'usr_status' => $usr_status, // modified status from a to 'w'
								);

								$key = Str::random(8);
								$user_details['usr_deeplink_token'] = $key;
								$new_user_id = $Users::insert_record($user_details, $current_user);

								$data['auth_usr_id'] = $new_user_id;
							}
							else
							{
								$data['auth_usr_id'] = $user_data[0]->usr_id;
							}
							$data_affiliation = array();
							/* check corresponding author exist in the current article */
							/*
							$author_exist = $this->Authors->get_single_record('count(auth_id) as cnt', array(
								'auth_art_id' => $article_id));
							if ($author_exist->cnt == 0)
							{
								$corresponding = 'y';
							}
							else
							{
								$corresponding = 'n';
							}
							*/
							/* insert author table in author details */
							// #4543 Manage author  data listing(normalization)
							$data_author = array(
								'auth_usr_id' => $data['auth_usr_id'],
								'auth_art_id' => $article_id,
								'auth_corr_author' => $co_author['corresp'],
								'auth_confirm_status' => 'y',
								'auth_editable' => 'y'
							);
							$auth_id = Authors::insert_record($data_author, $current_user);

							/* insert the author affiliation into author affiliation table */
							/* $data_affiliation = array(
							  'auaff_email' => '',
							  'auaff_department' => '',
							  'auaff_company' => 'State Key Laboratory of Rolling and Automation',
							  'auaff_cnt_id' => 'AU',
							  'auaff_postal_code' => '695104',
							  'auaff_type' => 'e',
							  'auaff_editable' => 'y',
							  'auaff_prime_affiliation' => 'y'
							  ); */
							$auth_aff = '';
							if(isset($co_author['aff']))
								$auth_aff = $co_author['aff'];

							$data_affiliation = array(
								'auaff_editable' => 'y',
								'auaff_prime_affiliation' => 'y',
								'auaff_single_affiliation' => $auth_aff
							);

							$data_affiliation['auaff_ringgold_id'] = NULL;
							$data_affiliation['auaff_ringgold_family'] = NULL;
							if($auth_id !== '')
							{
								$user_affliation = User_affiliations::get_all_records('*', 'usaff_user_id ='.$data['auth_usr_id']);
								$data_affiliation['auaff_auth_id'] = $auth_id;
								$data_affiliation['auaff_posted_by'] = $current_user['user_id'];
								$data_affiliation['auaff_posted_date'] = date('Y-m-d H:i:s');
								$insert_id = Authors_affiliation::insert_record($data_affiliation, $current_user);
                            }

							/* Add co author to journal */
							$author_role_id = Roles::get_single_record('role_id','role_assigned_role = "author"');
							$user_in_jnl ='usrj_usr_id ='.$data['auth_usr_id'].' AND usrj_role_id ='.$author_role_id->role_id.' AND usrj_jnl_id ='.$jnl_hdn_id.' AND usrj_artp_id = NULL';
							$user_in_artp_condition ='usrj_jnl_id ='.$jnl_hdn_id.' AND usrj_usr_id ='.$data['auth_usr_id'].' AND usrj_role_id ='.$author_role_id->role_id.' AND usrj_artp_id ='.$article_type_id;
							$user_journals_count = User_to_journals::get_single_record('count(*) AS row_count', $user_in_jnl);
							if ($user_journals_count->row_count === '0')
							{
								$user_in_jnl['usrj_invite'] = 'n';
								User_to_journals::insert_record($user_in_jnl, $current_user);
							}
							$user_jnl_tb_count = User_to_journals::get_single_record('count(*) as cnt', $user_in_artp_condition);
							if ($user_jnl_tb_count->cnt == 0)
                            {//check if not exist
                                $user_in_artp = array();
                                $user_in_artp = array(
                                    'usrj_jnl_id' => $jnl_hdn_id,
                                    'usrj_usr_id' => $data['auth_usr_id'],
                                    'usrj_role_id' => $author_role_id->role_id,
                                    'usrj_artp_id' => $article_type_id,
                                    'usrj_invite' => 'n'
                                );
								User_to_journals::insert_record($user_in_artp, $current_user);
							}
							/* Add co author to journal ends */

							$error_flag = FALSE;
						}
						else
						{
							$error_flag = TRUE;
						}
					}
					//Check user journal table entry not present then insert
					if (isset($data['auth_usr_id']) && ($data['auth_usr_id'] != '') && isset($error_flag) && ($error_flag == FALSE))
					{
						$art_flow_id = '';
						$condition = 'jwf_fwm_id ='.$article_jnlid->artp_fwm_id.' and jwf_stage_type =\'author_submission\'';
						$journal_user_role = Generic_flows::get_single_record('jwf_role_id', $condition);
						$assigned_role = $journal_user_role->jwf_role_id;

						$user_in_artp = User_to_journals::get_single_record('count(*) as cnt',' usrj_usr_id ='.$data['auth_usr_id'].' AND usrj_artp_id ='.$article_data_list['art_artp_id'].' AND usrj_role_id ='.$assigned_role);

						if ($user_in_artp->cnt == 0)
						{
							$user_in_artp = 'usrj_jnl_id ='.$article_jnlid->artp_jnl_id.' AND usrj_usr_id ='.$data['auth_usr_id'].' AND usrj_role_id ='.$assigned_role.' AND usrj_artp_id ='.$article_type_id;

							User_to_journals::insert_record($user_in_artp, $current_user);
						}
					}
					$error_flag = FALSE;
				}
				else
				{
					$error_flag = TRUE;
				}


				if (isset($error_flag) && ($error_flag == FALSE))
				{

					$author_user_id = Authors::get_single_record('auth_usr_id','auth_art_id = '.$article_id.' AND auth_corr_author = "y"');

					$user_arr = $current_user;
					if($auto_import_flag == TRUE)
					{
						$user_arr = array(
							'user_id' => $author_user_id->auth_usr_id,
							'proxy_user_id' => 0
						);
                    }
                    $move_next_data_array = array();
                    $move_next_data_array['article_id'] = $article_id;
                    $move_next_data_array['current_user'] = $current_user;
                    $move_next_data_array['master_flow_id'] = $article_jnlid->artp_fwm_id;
                    $move_next_data_array['current_client'] = $this->current_client;

                    $art_flow_arr = $this->move_next_stage($move_next_data_array);
				// work_on_it	$art_flow_arr = $this->workflow->move_next_stage($article_id, $user_arr, $load_models, $article_jnlid->artp_fwm_id, NULL, NULL, NULL, NULL, FALSE, FALSE, FALSE, FALSE, NULL, $this->current_client, NULL, $this->jnl_data->jset_reply_to_email);

					if (isset($art_flow_arr[0]))
						$art_flow_id = $art_flow_arr[0];

					$upload_path = $journal_dtails->jnl_journal_code . '/' . $article_jnlid->artp_abbr_article_type . '/' . $article_id;
					/* updated folder path into article table */
					if (!file_exists('uploads/' . $upload_path))
					{
						mkdir('uploads/' . $upload_path, 0777, TRUE);
					}

					$article_update = array(
						'art_article_upload_path' => $upload_path,
						'art_submitted_by' => $author_user_id->auth_usr_id
						);

					$update_flag = 'e';
                    if(isset($data['article_data']['pdfname']) && $data['article_data']['pdfname'] != '')
                    {
                        $article_update['art_pdf_status'] = 'y';
                    }
					Articles::update_record($article_update,'art_id ='.$article_id, $user_arr, '', $update_flag);

					/* Update Keyword list into the table */
					if (isset($data['article_data']['keyword_list_array']) && !empty($data['article_data']['keyword_list_array']))
					{
						$keyword_list_array = $data['article_data']['keyword_list_array'];
						$this->keyword_updation($keyword_list_array,$current_user, $journal_id, $this->current_client->functionality->cfty_keyword_hierarchy, $article_id,$auto_import_flag);

					}

					$article_type = $article_jnlid->artp_abbr_article_type;
					$jnl_code = $journal_dtails->jnl_journal_code;
					$art_id = encrypt_link($article_id);
					$status_id = encrypt_link($art_flow_id);
                    $msg[] = 'preview-article';
                    $preview_url = $jnl_code . '/' . $article_type . '/preview-article/' . $this->encrypt_data($article_id) .'/' .$status_id;
					//$preview_url = $jnl_code . '/' . $article_type . '/preview-article' . encrypt_link('article_id=' . $article_id . '&status_id=' . $status_id);
					$preview_link = "<a id='btn_preview_article' href='$preview_url' class='btn btn-primary txt-space' >Preview Submission</a>";
					/* article pdf table  genertaed pdf name */
					if (isset($data['article_data']['pdfname']) && $data['article_data']['pdfname'] != '' && $auto_import_flag == FALSE)
					{
						$article_pdf_details = Article_pdf::get_single_record('pdf_art_id,pdf_name', 'pdf_art_id =' .$article_id);
						$pdfName = $data['article_data']['pdfname'];
						$pdf_details = array(
							'pdf_art_id' => $article_id,
							'pdf_aflw_id' => $art_flow_id,
							'pdf_name' => $pdfName,
							'pdf_show_status' => 'y',
						);

						if (empty($article_pdf_details))
						{

							$pdf_id = Article_pdf::insert_record($pdf_details, $current_user);
						}
						else
						{
							$pdf_id = $article_pdf_details->pdf_id;
							Article_pdf::update_record($pdf_details, 'pdf_art_id ='.$pdf_id);
						}
					}

					//insert in to publish stage
					$art_stage_arr = array();
                    /* data copy into the temparay zip to article folder */
                    $file_path = Config::get('general_config.file_retrieval')['file_path'];
					$desination = public_path().$file_path.'/'.$upload_path;
                    $source = $data['copy_source_path'];

                    $this->custom_copy($source, $desination);
                    $this->remove_uploaded_files($source, $data['copy_zip_path']);
					if (DB::commit() === FALSE)
					{
						$status = 'fail';
						array_push($xml_errors, customTrans('viewarticle.invalid_data'));
						$return_array['msg'] = 'invalid_data';
						$article_id = NULL;
					}
					elseif($auto_import_flag == TRUE)
					{
						$return_array['status'] = 'success';
						$return_array['art_upload_path'] = $desination;
						$return_array['article_id'] = $article_id;
						$return_array['production_stage'] = $art_stage_arr;
					}
					else
					{
						$return_array['msg'] = 'preview-article';
						$return_array['preview_url'] = $preview_url;
						$return_array['preview_link'] = $preview_link;
						$return_array['status'] = 'success';
					}
				}
				else
				{
					$return_array['status'] = 'fail';
					$return_array['msg'] = 'invalid_data';
				}
			}
			else
			{
				$return_array['status'] = 'fail';
				array_push($xml_errors, customTrans('viewarticle.article_code_exist'));
				$return_array['msg'] = 'article_code_exist';
			}
		}
		else
		{
			$return_array['status'] = 'fail';
			$artp_msg = $article_type_name.' '.customTrans('viewarticle.article_type_not_exist');
			array_push($xml_errors, $artp_msg);
			$return_array['msg'] = $artp_msg;
		}
		}
		$return_array['xml_errors_array'] = $xml_errors;
		return $return_array;
    }

    public function keyword_updation($keyword_array, $current_user, $jnl_id, $heerarchy, $article_id,$auto_import_flag = FALSE)
    {
        if (!empty($keyword_array))
		{
            $Keywords = new \App\Models\Keywords();
			foreach ($keyword_array as $keyword_val)
			{
				$condition = 'kwd_name ="'.$keyword_val.'"';
				$hierarchy = 'c';
				$keyword_value = htmlspecialchars($keyword_val, ENT_QUOTES);
                $keyword_exists = $Keywords::get_keywords($condition, '*', NULL, NULL, 'kwd_id', $hierarchy);
				$default_catid = 'c';
				if (count($keyword_exists) == 0)
				{//keyword not exists in uncatogrised category
					$data = 'kwd_name ="'.$keyword_val.'"';
					/* $data = array(
					  'kwd_name' => 'UPPER("' . $keyword_value . '")'); */
                    $get_keyword_record = $Keywords::get_single_record('*', $data);
					if($get_keyword_record !== NULL && !empty($get_keyword_record))
					{
						$keyinsertid = $get_keyword_record->kwd_id;
						if($auto_import_flag == FALSE)
						{
							$keyrelation = Keyword_relationship::get_single_record('count(kwdrl_id) as cnt','kwdrl_jnl_id ='.$jnl_id.' AND kwdrl_kwd_id ='.$keyinsertid);
							if($keyrelation->cnt == 0)
							{
								$data_keyword_category = array(
									'kwdrl_category_id' => $default_catid,
									'kwdrl_jnl_id' => $jnl_id,
									'kwdrl_kwd_id' => $keyinsertid);
								$result = Keyword_relationship::insert_record($data_keyword_category, $current_user);
							}
						}
					}
					else
					{
                        $data = array();
                        $data = array('kwd_name' => strtoupper(htmlspecialchars($keyword_value, ENT_QUOTES)),'kwd_user_keyword' => 'y');
						$keyinsertid = $Keywords::insert_record($data, $current_user);
						if($auto_import_flag == FALSE)
						{
							$data_keyword_category = array(
								'kwdrl_category_id' => $default_catid,
								'kwdrl_jnl_id' => $jnl_id,
								'kwdrl_kwd_id' => $keyinsertid);
							$result = Keyword_relationship::insert_record($data_keyword_category, $current_user);
						}
					}
					$exists_in_ak = Article_keywords::get_all_records('*','ak_art_id ='.$article_id.' AND ak_keyword_id ='.$keyinsertid);
					if (count($exists_in_ak) == 0)
					{
						Article_keywords::insert_record(array(
							'ak_art_id' => $article_id,
							'ak_keyword_id' => $keyinsertid), $current_user);
					}
				}
			}
		}
    }

    function custom_copy($source_dir, $destination_dir)
	{
		// Open the source folder / directory
		$dir = opendir($source_dir);

		// Create a destination folder / directory if not exist
		@mkdir($destination_dir);

		// Loop through the files in source directory
		while ($file = readdir($dir))
		{
			// Skip . and ..
			if (($file != '.') && ($file != '..'))
			{
				// Check if it's folder / directory or file
				if (is_dir($source_dir . '/' . $file))
				{
					// Recursively calling this function for sub directory
					$this->custom_copy($source_dir . '/' . $file, $destination_dir . '/' . $file);
				}
				else
				{
					// Copying the files
					copy($source_dir . '/' . $file, $destination_dir . '/' . $file);
				}
			}
		}

		closedir($dir);
	}
    public function get_funderRef_by_article_id($article_id){
        $article_funder_records = Article_funder_details::get_all_records('*', "afd_art_id = {$article_id}");
        if (count($article_funder_records) > 0){
            foreach ($article_funder_records as $af_val){
                $where = "funder_id = {$af_val->afd_funder_id}";
                $location = Funders::get_single_record('funder_location', $where);
                if (empty($location->funder_location)) {
                    $select = 'CONCAT(funder_name) as value, funder_name, funder_unique_id as unique_id, funder_location as location, funder_uri as uri, funder_id as id';
                } else {
                    $select = 'CONCAT(funder_name, " (",funder_location,")") as value, funder_name, funder_unique_id as unique_id, funder_location as location, funder_uri as uri, funder_id as id';
                }
                $af_val->funder_info = Funders::get_single_record($select, $where);
            }
        }
        return $article_funder_records;
    }
    public function get_funder_details(Request $request){
        try{
            $post_data = $request->all();
            $rtn_arr   = array();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' =>$post_data['article_id'],
                'enc_data' => TRUE,
                'type'=> 'number'
            );
            $validator = $this->Rv_validator($input_arr);
            $article_funder_records = array();
            $article_id = Rv_decrypt($post_data['article_id']);
            $artflw_id = Rv_decrypt($post_data['article_flow_id']);
            if($article_id){
                $condition = 'art_id = '.$article_id.' AND aflw_id =' . $artflw_id;
                $article_details = Articles::get_article_details("art_receive_funding,jwf_stage_type", $condition, NULL, FALSE);
                $article_details = $article_details[0];
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);
                $stage_flow = $review_flow[$article_details->jwf_stage_type];
                if(isset($article_details->art_receive_funding) && $article_details->art_receive_funding == 'y'){
                    $article_funder_records = $this->get_funderRef_by_article_id($article_id);
                }
                if((!isset($this->current_client->functionality->cfty_enable_funder_details_for_production)) || (isset($this->current_client->functionality->cfty_enable_funder_details_for_production) && $this->current_client->functionality->cfty_enable_funder_details_for_production == 'n') && $stage_flow['stage_for'] == 'manageproduction'){



                    $article_funder_records = array();
                }
            }
            $rtn_arr['article_funder_records'] = $article_funder_records;
            return  $this->success('Success', 200, $rtn_arr);
        } catch(\Exception $e){

        }
    }

    public function get_attachament_list($jnl_id, $artp_id, $article_id)
    {
        $date_format = $this->get_platform_date_format($jnl_id);
        $date_format = date_format_map($date_format);

        $form_data = array();
        $date_format = $date_format.' %H:%i:%s';
        $return_arr = array();

        $query_str = "SELECT a1.art_id,a1.art_article_upload_path FROM `rvw_articles` as a1 join rvw_articles as a2 on (a2.`art_id`=? and a1.art_doi = a2.art_doi) ORDER by a1.art_id LIMIT 1";
        $bind_arr = array($article_id);
        $result_orgpath = Articles::get_records_by_raw_query($query_str,FALSE,$bind_arr);

        $es_integrations = FALSE;
        $esarray['article_id']=$article_id;
        $checkdata=$this->check_espermission_access($esarray);
        //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
        if($checkdata==true)
        {
            $es_integrations = TRUE;
        }
        $orgArt_path = '';
        $orgArt_id = '';
        if(isset($result_orgpath[0]))
        {
            $orgArt_path = $result_orgpath[0]->art_article_upload_path;
            $orgArt_id = $result_orgpath[0]->art_id;
        }
        $return_arr['orgArt_id'] = $orgArt_id;
        $select = 'atmnt_id,atmnt_art_id,atmnt_aflw_id,atmnt_orginal_upload_path,atmnt_file_name,atmnt_pdf_name,atmnt_document_size,atmnt_designated_to,atmnt_label,atmnt_old_label,atmnt_order,DATE_FORMAT(atmnt_file_uploaded_date, "' . $date_format . '") as atmnt_file_uploaded_date,atmnt_posted_by,atmnt_proxy_id,atmnt_posted_date,atmnt_merge_date,atmnt_operation,IF(atmnt_orginal_upload_path = \''.$orgArt_path.'\',\'Original file\',\'Revised file\') as submission_type,atmnt_send_to_es,atmnt_doc_created_in_es';

        if (isset($this->current_client->functionality->cfty_include_short_metadata_file) && $this->current_client->functionality->cfty_include_short_metadata_file == 'y')
        {
            $cond = array(
                'atmnt_art_id' => $article_id,
                'atmnt_metadata_file'=>'n'
            );
        } 
        else
        {
            $cond = array(
                'atmnt_art_id' => $article_id
            );
        }
        $support_docs_record = Attachment_files::get_all_records_with_bind_cond($select, $cond,'',array(), 'atmnt_order');

        // $support_docs_record = Attachment_files::get_all_records('atmnt_id,atmnt_art_id,atmnt_aflw_id,atmnt_orginal_upload_path,atmnt_file_name,atmnt_pdf_name,atmnt_document_size,atmnt_designated_to,atmnt_label,atmnt_old_label,atmnt_order,DATE_FORMAT(atmnt_file_uploaded_date, "' . $date_format . '") as atmnt_file_uploaded_date,atmnt_posted_by,atmnt_proxy_id,atmnt_posted_date,atmnt_merge_date,atmnt_operation', "atmnt_art_id={$article_id}", 'atmnt_order');
        $file_description = Required_file_type::get_file_description('afdec_description,rft_file_desp_id,rft_req_count,rft_req_fld,afdec_file_type_id', "rft_artp_id={$artp_id}");

        $revised_article = FALSE;
        $check_revised_article = Articles::get_single_record_with_bind_cond('art_prev_article_id,art_status,art_es_document_type,art_es_document_status',array('art_id' => $article_id));
        if(isset($check_revised_article->art_prev_article_id) && $check_revised_article->art_prev_article_id !== NULL)
        {
            $revised_article = TRUE;
        }
        $description_cond = '';
        if($revised_article == FALSE)
        {
            $description_cond =  ' afdec_description_type IN(\'b\',\'o\')';
        }
        else
        {
            $description_cond =  ' afdec_description_type IN(\'b\',\'r\')';
        }
        $allowed_file_desc = array();
        $allowed_main_docs = array();
        if($es_integrations == TRUE)
        {
            $attach_file_description = Attachment_file_description::get_all_records('afdec_id,afdec_main_document', $description_cond);     
            foreach($attach_file_description as $single_file_description)
            {
                if($single_file_description->afdec_main_document == 'y')
                {
                    array_push($allowed_main_docs,$single_file_description->afdec_id);
                }
                array_push($allowed_file_desc,$single_file_description->afdec_id);
            }
        }
        else
        {
        $attach_file_description = Attachment_file_description::get_single_record('GROUP_CONCAT(afdec_id) AS descriptions', $description_cond);        
        if($attach_file_description->descriptions !== NULL)
        {
            $allowed_file_desc = explode(',',$attach_file_description->descriptions);
        }
        }
        $require_array = array();
        $file_type_max =array();
        $req_file_desc_arr = $opt_file_desc_arr = array();
        $file_desp_arr = array();
        $file_desc_main_doc_type = 0;
        if (!empty($file_description)) {

            $i = 0;
            $j = 0;
            foreach ($file_description as $fd) {
                array_push($file_desp_arr, $fd->rft_file_desp_id);
                if ($fd->rft_req_fld == 'y') {
                    $require_array[$i] = array(
                        'id' => $fd->rft_file_desp_id,
                        'cnt' => $fd->rft_req_count,
                        'desp' => $fd->afdec_description
                    );
                    $i++;
                    $req_file_desc_arr[] = $fd->afdec_description;
                } else {

                    if ($fd->rft_req_count > 0) {
                        $file_type_max[$j] = array(
                            'id' => $fd->rft_file_desp_id,
                            'cnt' => $fd->rft_req_count,
                            'desp' => $fd->afdec_description
                        );
                        $j++;
                    }
                    $opt_file_desc_arr[] = $fd->afdec_description;
                }
                if($es_integrations == TRUE)
                {
                    $file_type_arr = json_decode($fd->afdec_file_type_id);
                    $comma_separate_types = implode(',',$file_type_arr);
                    $general_config= Config::get('general_config');
                    $allowed_main_types = "'" . implode("','", $general_config['allowed_main_doc_types']) . "'"; 
                    $fup_data = File_upload_type::get_single_record('count(fut_id) as type_count ', "fut_name IN(".$allowed_main_types.") AND fut_id IN(".$comma_separate_types.")");
                    if($fup_data->type_count > 0)
                    {
                        $file_desc_main_doc_type ++;
                    }
                }
            }
            $require_array = json_encode($require_array);
            $file_type_max = json_encode($file_type_max);
        }
        $file_description_values = implode(',', $file_desp_arr);
        $main_attac_arr = array();
        $es_document_delete_flag = FALSE;
        if($es_integrations == TRUE && $check_revised_article->art_es_document_type == 'n' && $revised_article == FALSE && $check_revised_article->art_status == 'n')
        {
            $es_document_delete_flag = TRUE;
        }
        $return_arr['es_document_delete'] = $es_document_delete_flag;
        $document_created = FALSE;
        if (count($support_docs_record) > 0) {
            foreach ($support_docs_record as $doc) {

                if($es_integrations == TRUE)
                {
                    if(in_array($doc->atmnt_label,$allowed_main_docs))
                    {
                        array_push($main_attac_arr,$doc->atmnt_id);
                        if($check_revised_article->art_es_document_status == 'y' && $check_revised_article->art_es_document_type == 'u' && $doc->atmnt_doc_created_in_es == 'n')
                        {
                            $file_name = rawurlencode($doc->atmnt_file_name);
                            $query_string = 'article_id='.$article_id.'&file_name='.$file_name;
                            $pass_arr = array();
                            $pass_arr['encryptedData'] = Rv_encrypt($query_string);
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            $apiUrl = $es_api_data['doc_status_url'];
                            $pass_arr =  array('encryptedData' => Rv_encrypt($query_string));
                            $response = $this->es_curl_request($apiUrl,$pass_arr);
                            $response = json_decode($response);
                            if(isset($response->status) && $response->status == 200)
                            {
                                $this->current_user = $this->get_current_user_details();
                                $update_attachment = Attachment_files::update_record(array('atmnt_doc_created_in_es' => 'y'), "atmnt_id = {$doc->atmnt_id}", $this->current_user);
                                if($update_attachment)
                                {
                                    $doc->atmnt_doc_created_in_es = 'y';
                                    $document_created = TRUE;
                                } 
                            }
                            else
                            {
                                $this->current_user = $this->get_current_user_details();
                                $update_attachment = Attachment_files::update_record(array('atmnt_doc_created_in_es' => 'n'), "atmnt_id = {$doc->atmnt_id}", $this->current_user);
                                if($update_attachment)
                                {
                                    $doc->atmnt_doc_created_in_es = 'n';
                                } 
                                $document_created = FALSE;
                            }
                        }
                    }
                    else if($check_revised_article->art_es_document_status == 'y' && $doc->atmnt_send_to_es == 'n')
                    {
                        $send_file_to_s3 = $this->send_supplimentary_files_to_s3($doc);
                    }
                    // dd($check_revised_article->art_es_document_status);
                    $doc->show_delete_icon = TRUE;
                    if($doc->atmnt_doc_created_in_es == 'y')
                    {
                        $document_created = TRUE;
                    }
                }
                $file_extension_arr = explode('.', $doc->atmnt_file_name);
                $file_extension = strtolower(end($file_extension_arr));

                $fup_data = File_upload_type::get_single_record('fut_id', "fut_name='{$file_extension}'");

                if (!empty($fup_data) && $file_extension != "zip" && $file_description_values != NULL) {
                    //$where_condition = "afdec_file_type_id like  '%" . $fup_data->fut_id . "%'and afdec_id IN (" . $article_details[0]->atotp_file_description . ")";
                    $fut_id = '"'.$fup_data->fut_id.'"';
                    $where_condition = "afdec_file_type_id like  '%" . $fut_id . "%'and afdec_id IN (" . $file_description_values . ")  AND afdec_apply_stage_type !='p' ";
                    $file_des_type = Attachment_file_description::get_all_records('*', $where_condition);
                    /* All File description when Empty file type Managing */
                    if(count($file_des_type)==0)
                    {
                        $file_des_type=Attachment_file_description::get_all_records('*', 'afdec_id IN (' . $file_description_values . ')');
                    }
                    /* End All File description when Empty file*/
                    $file_desc_arr = array();
                    if(!empty($allowed_file_desc))
                    {
                        foreach($file_des_type as $single_key => $single_desc)
                        {
                            if($single_desc->afdec_id == $doc->atmnt_label && $single_desc->afdec_main_document == 'y' && ($revised_article == TRUE || $check_revised_article->art_status !== 'n') && $es_integrations == TRUE)
                            {
                                $doc->show_delete_icon = FALSE;
                            }
                            if(in_array($single_desc->afdec_id,$allowed_file_desc) || $doc->atmnt_label == $single_desc->afdec_id)
                            {
                                array_push($file_desc_arr,$single_desc);
                            }
                        }
                    }
                    $file_des_type = $file_desc_arr;
                    // $doc->file_des_type=$this->get_attachment_description_values($file_des_type);
                    if(!empty($file_des_type))
                        $doc->file_des_type = $file_des_type;
                }

                // #336 Supplementary Zip disappearing from file description after page refresh
                if (!empty($fup_data) && $file_extension == "zip") {
                   // print_r($doc); die;
                    $zip_descid        =    $doc->atmnt_label;
                    $where_condition = "afdec_id =" . $zip_descid . "";
                    $file_des_type = Attachment_file_description::get_all_records('*', $where_condition);

                    $doc->file_des_type = $file_des_type;
                }
                if(isset($doc->file_des_type) && count($doc->file_des_type)==0)
                {
                   // $doc->file_des_type=Attachment_file_description::get_all_records('*', "afdec_apply_stage_type !='p'");
                    $doc->file_des_type=Attachment_file_description::get_all_records('*', 'afdec_id IN (' . $file_description_values . ')');
                }
                //Bug fix - To assign attachment label to zero, if the selected description not in available file description.
                $item = NULL;
                $val = $doc->atmnt_label;
                if(isset($doc->file_des_type))
                {
                    foreach($doc->file_des_type as $obj) {
                        if ($val == $obj->afdec_id) {
                            $item = $obj;
                            break;
                        }
                    }
                }

                if($item == NULL)
                {
                    if($doc->atmnt_label!='')
                    {
                        $doc->prev_selected_atmnt_label= Attachment_file_description::get_single_record('*',"afdec_id={$doc->atmnt_label}");
                      //  print_r($doc->file_des_type);exit;
                    }
                    else
                    {
                        $doc->atmnt_label = 0;
                    }
                }


                $show_review_indend = TRUE;
                if (isset($doc->atmnt_label) && $doc->atmnt_label != '' && $this->current_client->functionality->cfty_show_attachments_for_reveiwers == 'y') {

                    $file_exclude_data = Attachment_file_description::get_single_record('afdec_exclude_file', "afdec_id={$doc->atmnt_label}");
                    if (isset($file_exclude_data->afdec_exclude_file) && $file_exclude_data->afdec_exclude_file == 'y') {
                        $show_review_indend = FALSE;
                    }
                }
                $doc->file_indent_review = $show_review_indend;
                //Gigascience Post-live fix
                //$doc->resubmission_no = $this->get_article_resubmission_no_using_upload_path($doc->atmnt_orginal_upload_path);

            }

            /*   $article_data = $this->Articles->get_single_record('art_resubmission_no', array(
                                            'art_id' => $article_id
                                    ))->art_resubmission_no;
                $form_data['art_resubmission_no'] = $article_data;
                */
                $return_arr = array(
                    'support_docs_record'   => $support_docs_record,
                    'orgArt_id'           => $orgArt_id,
                    'es_main_descriptions' => $allowed_main_docs,
                    'es_main_attachs' => $main_attac_arr,
                    'es_document_delete' => $es_document_delete_flag,
                    'es_document_created' => $document_created,
                    'file_desc_main_doc_type' => $file_desc_main_doc_type
                );
        }
        return $return_arr;
    }
    public function get_author_list(Request $request){
        try{
            $post_data = $request->all();
            $rtn_arr   = array(
                'status' => 'failed',
                'msg' => ''
            );
            $validator = Validator::make($request->all(), [
                // 'author_id' => 'required',
                'article_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' =>$post_data['article_id'],
                'enc_data' => TRUE,
                'type'=> 'number'
            );
            $validator = $this->Rv_validator($input_arr);
            $article_id = Rv_decrypt($post_data['article_id']);
		    $auth_id = Rv_decrypt($post_data['author_id']);

            $authorTable = (new \App\Models\Authors())->getTable();
            $userTable = (new \App\Models\User())->getTable();
            $criteria = "auth_art_id='{$article_id}' AND auth_id!='{$auth_id}'";
            $select = 'auth_id,usr_title,concat(usr_first_name,\' \',usr_last_name) as author_name';
            $tables = array(
                'main_table' => $authorTable,
                'join_table' => array(
                    $userTable => array($authorTable . '.auth_usr_id', $userTable . '.usr_id', "left")
                )
            );
            $coAuthors = Authors::get_results_using_joins($tables, $select, $criteria, '');
            $affiliation_types=Config::get('clients.'.$this->current_client->clnt_client_code.'.aff_config.user_affiliation_type');
            if(!empty($coAuthors)&&count($coAuthors)>0){
                $titles = $this->UserConfigdata('titles')['titles'];
                foreach($coAuthors as $coAuthor){
                    $Authors_affiliation = new \App\Models\Authors_affiliation();
                    $Country_table = (new \App\Models\Country())->getTable();
                    $author_affiliation_data = $Authors_affiliation::get_all_records('auaff_id,auaff_department,auaff_company,auaff_state,auaff_address_line1,auaff_address_line2,auaff_postal_code,auaff_type,auaff_phone,auaff_cnt_id,(select cnt_country from ' . $Country_table . ' where cnt_id = auaff_cnt_id) as aff_country', 'auaff_auth_id=' . $coAuthor->auth_id);
                    foreach($author_affiliation_data as $auth_aff){
                        $auth_aff->auaff_type_str = isset($affiliation_types[$auth_aff->auaff_type])?$affiliation_types[$auth_aff->auaff_type]:'';
                    }
                    $coAuthor->affiliations = $author_affiliation_data;
                    $coAuthor->author_full_name = (isset($titles[$coAuthor->usr_title])) ? ($titles[$coAuthor->usr_title] . ' ' . $coAuthor->author_name ) : ($coAuthor->author_name);
                    // $coAuthor->key = $coAuthor->auth_id;
                }
                $rtn_arr   = array(
                    'status' => 'success',
                    'data' => $coAuthors
                );
            }
            return  $this->success('Success', 200, $rtn_arr);
        } catch(\Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function transfer_file_ftp($data)
    {
        try
        {
            $return_array = array();
            $suport_docs = $data['support_docs'];
            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
            $es_api_data  = Config::get($es_config);
            $es_ftp_host = $es_api_data['ftp_host'];
            $es_ftp_port = $es_api_data['ftp_port']; 
            $es_ftp_user = $es_api_data['ftp_user_name']; 
            $es_ftp_folder = $es_api_data['ftp_folder_path'];
            $es_file_path = $es_api_data['ftp_file_path'];
            $es_ftp_password = $es_api_data['ftp_password']; 
            $actual_key_Path = $this->upload_folder_path('uploads/key_for_es/es.pem');
            $require_private_key = array();
            $require_private_key['sftp_flag'] 	= TRUE;
            $require_private_key['key_path'] 	= $actual_key_Path;
            $client_code = $this->current_client->clnt_client_code;
            $ftp_connection = array();
            $ssh ='';
            $conn_id='';
            $inside_path = strtoupper($client_code).'/'.$data['jnl_code'].'/'.$data['article_type_code'].'/'.$data['article_id'].'/';
            $destination_folder = $es_ftp_folder.$inside_path;
            $destination = $this->set_server_path($destination_folder,'ftp','pcori',FALSE);
            if($this->current_client->functionality->cfty_enable_upload_s3_bucket == 'n')
            {
                $ftp_connection = $this->remoteConneciton($es_ftp_host, $es_ftp_user, $es_ftp_password,$es_ftp_port,TRUE,$require_private_key);
                if(isset($ftp_connection['login']) && $ftp_connection['login'] == TRUE)
                {
                    $ssh = $ftp_connection['ssh'];
                    $conn_id = $ftp_connection['conn_id'];
                    $this->make_server_directory($conn_id,$destination, $require_private_key['sftp_flag'], $ssh);
                }
                else
                {
                    $return_array['status'] = 'failed';
                }
            }
            foreach($suport_docs as $single_docs)
            {
                $main_document = FALSE;
                $check_desc = Attachment_file_description::get_single_record('afdec_main_document','afdec_id ='.$single_docs->atmnt_label);
                if(!empty($check_desc) && $check_desc->afdec_main_document == 'y')
                {
                    $main_document = TRUE;
                }
                if($single_docs->atmnt_send_to_es == 'n')
                {
                    $source_file_path =  $this->upload_folder_path('uploads/'.$single_docs->atmnt_orginal_upload_path.'/'.rawurlencode($single_docs->atmnt_file_name));
                    if($this->current_client->functionality->cfty_enable_upload_s3_bucket == 'y')
                    {
                        $s3FilePath = '/review-ftp/'.$single_docs->atmnt_orginal_upload_path.'/'.rawurlencode($single_docs->atmnt_file_name);
                        // $upload_file  = Storage::disk('s3_es')->put($s3FilePath, file_get_contents($source_file_path));
                        // if($upload_file == true)
                        // {
                        //     $this->current_user = $this->get_current_user_details();
                        //     $update_attachment = Attachment_files::update_record(array('atmnt_send_to_es' => 'y'), "atmnt_id = {$single_docs->atmnt_id}", $this->current_user); 
                        // }
                        // else
                        // {
                        //     $return_array['status'] = 'failed';
                        // }         
                    }
                    else
                    {
                        if(file_exists($source_file_path))
                        {
                            $destination_file = $es_file_path.$inside_path.$single_docs->atmnt_file_name;
                            $response = $this->put_files($conn_id,$destination_file,$source_file_path, $require_private_key['sftp_flag'],$ssh);
                            if($response == true)
                            {
                                $this->current_user = $this->get_current_user_details();
                                $update_attachment = Attachment_files::update_record(array('atmnt_send_to_es' => 'y'), "atmnt_id = {$single_docs->atmnt_id}", $this->current_user); 
                            }
                            else
                            {
                                $return_array['status'] = 'failed';
                            }
                        }                
                    }
                }
            }

            if(!isset($return_array['status']))
            {
                $return_array['status'] = 'success';
            }
            else
            {
                $return_array['status'] = 'ftp_issue';
                $return_array['message'] = 'Unable to connect to the RvRite';
            }
            return $return_array;

            /*$ftp_connection = $this->remoteConneciton($es_ftp_host, $es_ftp_user, $es_ftp_password,$es_ftp_port,TRUE,$require_private_key);
            if(isset($ftp_connection['login']) && $ftp_connection['login'] == TRUE)
            {
                $inside_path = strtoupper($client_code).'/'.$data['jnl_code'].'/'.$data['article_type_code'].'/'.$data['article_id'].'/';
                $destination_folder = $es_ftp_folder.$inside_path;
                $destination = $this->set_server_path($destination_folder,'ftp','pcori',FALSE);
                $ssh = $ftp_connection['ssh'];
                $conn_id = $ftp_connection['conn_id'];
                $this->make_server_directory($conn_id,$destination, $require_private_key['sftp_flag'], $ssh);
                foreach($suport_docs as $single_docs)
                {
                    $source_file_path =  $this->upload_folder_path('uploads/'.$single_docs->atmnt_orginal_upload_path.'/'.$single_docs->atmnt_file_name);
                    if($single_docs->atmnt_send_to_es == 'n')
                    {
                        if(file_exists($source_file_path))
                        {
                            $destination_file = $es_file_path.$inside_path.$single_docs->atmnt_file_name;
                            $response = $this->put_files($conn_id,$destination_file,$source_file_path, $require_private_key['sftp_flag'],$ssh);
                            if($response == true)
                            {
                                $this->current_user = $this->get_current_user_details();
                                $update_attachment = Attachment_files::update_record(array('atmnt_send_to_es' => 'y'), "atmnt_id = {$single_docs->atmnt_id}", $this->current_user); 
                            }
                        }    
                    }
                }
                $return_array['status'] = 'success';
            }
            else
            {
                $return_array['status'] = 'ftp_issue';
                $return_array['message'] = 'Unable to connect to the RvRite';
            }
            return $return_array;*/
        }
        catch(\exeception $e)
        {
            $return_array['status'] = 'error';
            $return_array['message'] = 'Unable to connect to the RvRite';
            return $return_array;
        }       
    }



    public function get_article_status_by_stage_based($flow_master_id,$art_submitted_current_stages)
	{
				$raw_workflow = Generic_flows::get_all_records_with_bind_cond('jwf_id,jwf_stage_type,jwf_stage_type', array('jwf_fwm_id' => $flow_master_id));

                $this_workflow = $this->process_flow($raw_workflow);
	           	$statge_type_array=array();
				if(!empty($art_submitted_current_stages))
				{
				foreach($art_submitted_current_stages as $stage)
				{
					$statge_type_array[]=$this_workflow[$stage]->jwf_stage_type;
				}
                $review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($review_config);
				$accept_child_stage=array();
				if(isset($review_flow['accept']['child_stages'])&&(!empty($review_flow['accept']['child_stages'])))
				$accept_child_stage=$review_flow['accept']['child_stages'];
				$count_accept_complete= count(array_intersect($accept_child_stage, $statge_type_array));
                $production_satges=array();
				if(!empty($review_flow))
				{
				 foreach ($review_flow as $key => $re_flw)
						{
							if(isset($re_flw['stage_for']) && $re_flw['stage_for'] == 'manageproduction')
							{
								$production_satges[] = $key;
							}
						}
                }
				$count_production_stages=count(array_intersect($production_satges, $statge_type_array));

		         if(isset($count_accept_complete)&&$count_accept_complete>0)
				 {
					$art_status = 'a';
				 }
				 elseif(isset($count_production_stages)&&$count_production_stages>0)
				 {
					$art_status = 'a';
				 }
				  else
				 {
					$art_status = 'y';
				 }

				}
				else
				{
					$art_status = 'y';
				}
				return $art_status;
    }
    
    public function create_new_es_doc(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $art_id = Rv_decrypt($post_data['art_id']);
            $article_id = $this->decrypt_data($art_id);
            $return_arr = array('status' => 'failed'); 
            $current_user = $this->get_current_user_details();
            $update_arr = array('art_es_document_type' => 'n');
            $update_record = Articles::update_record($update_arr,array('art_id' => $article_id),$current_user);
            if($update_record)
            {
                $return_arr['status'] = 'success';
            }
            else
            {
                $return_arr['status'] = 'failed';
            }
            return  $this->success('Success', 200, $return_arr);
        }
        catch(\Exeception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function set_data_for_editor($article_id,$article_flow_id,$user_data,$auth_id,$current_role)
    {
            $article_model = (new \App\Models\Articles());
            $article_data = $article_model::get_single_record_with_bind_cond('art_id,art_artp_id,art_title,art_abstract,art_es_document_status,art_es_document_type,art_prev_article_id,art_submitted_by,art_code,art_submission_date',array('art_id' => $article_id));
            $attchment_table = (new \App\Models\Attachment_files())->getTable();
            $description_tbl = (new \App\Models\Attachment_file_description())->getTable();
            $article_tbl = (new \App\Models\Articles())->getTable();
            $article_type_tbl = (new \App\Models\Article_types())->getTable();
            $jnl_table = (new \App\Models\Journals())->getTable();
            $attch_tbl = new \App\Models\Attachment_files();
            $generic_flw_tbl = (new \App\Models\Generic_flows())->getTable();
            $article_flow_tbl_name = (new \App\Models\Article_flow())->getTable();
            $article_flow_tbl = new \App\Models\Article_flow();

            $auth_data_arr = array();
            $Authors_tbl_name = (new \App\Models\Authors())->getTable();
            $User_tbl_name = (new \App\Models\User())->getTable();
            $join_tbls_author = array(
                'main_table' => $article_tbl,
                'join_table' => array(
                    $Authors_tbl_name => array(
                        $Authors_tbl_name.'.auth_art_id', $article_tbl.'.art_id'),
                        $User_tbl_name => array(
                            $User_tbl_name.'.usr_id', $Authors_tbl_name.'.auth_usr_id')
                )
            );
            $select = 'usr_id,CONCAT( IF( usr_title IS NULL OR usr_title = "", " ", CONCAT( UPPER(SUBSTR(usr_title, 1, 1)), LOWER(SUBSTR(usr_title, 2)) ) )," ", usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user_name,usr_email,auth_corr_author';
            $wherecondition = 'art_id=' .$article_id;
            $articles_authors = $article_model::get_results_using_joins($join_tbls_author, $select, $wherecondition); 
            if(!empty($articles_authors))
            {
                $authors_key = array(); 
                foreach($articles_authors as $authors_list)
                {
                    if($authors_list->auth_corr_author=='y')
                    {
                        $auth_data_arr['user_global_id'] = Rv_encrypt($authors_list->usr_id);
                        $auth_data_arr['user_name'] = $authors_list->user_name; 
                        $auth_data_arr['usr_email'] = $authors_list->usr_email; 
                        $auth_data_arr['corresponding_author'] = 'y';   
                     }
                     else
                    {
                        $auth_co_author['user_global_id'] = Rv_encrypt($authors_list->usr_id);
                        $auth_co_author['user_name'] = $authors_list->user_name; 
                        $auth_co_author['usr_email'] = $authors_list->usr_email; 
                        $auth_co_author['corresponding_author'] = 'n'; 
                        array_push($authors_key, $auth_co_author);
                    }
                   
                }
                $auth_data_arr['list_co_authors']= $authors_key; 

            }
           

            $join_tbls = array(
                'main_table' => $article_flow_tbl_name,
                'join_table' => array(
                    $generic_flw_tbl => array(
                        $generic_flw_tbl.'.jwf_id', $article_flow_tbl_name.'.aflw_jwf_id'
                    )
                )
            );
            $work_criteria = 'aflw_id ='.$article_flow_id;
            $get_all_workflow_details = $attch_tbl::get_results_using_joins($join_tbls, 'jwf_stage_name',$work_criteria, 'all');

            $tables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id'),
                                $article_tbl => array($attchment_table.'.atmnt_art_id',$article_tbl.'.art_id'),
                                $article_type_tbl => array($article_tbl.'.art_artp_id',$article_type_tbl.'.artp_id'),
                                $jnl_table => array($article_type_tbl.'.artp_jnl_id',$jnl_table.'.jnl_id')
                            )
                        );
            $select_fields = 'atmnt_id,atmnt_orginal_upload_path,atmnt_file_name,atmnt_send_to_es,afdec_main_document,jnl_journal_code,artp_abbr_article_type,art_es_document_status,art_es_document_type';
            $criteria = 'atmnt_art_id=' . $article_id;
            $get_all_attach_details = $attch_tbl::get_results_using_joins($tables, $select_fields, $criteria, 'all');
            $return_arr = array();
            $return_arr['article_data'] = [];
            $return_arr['document_created_at_rv_rite'] = $article_data->art_es_document_type == 'n' ? 'y' : 'n';
            $return_arr['article_data']['art_previous_id'] = $article_data->art_prev_article_id;
            $return_arr['main_document'] = '';
            $return_arr['document_id'] = '';
            $return_arr['article_data']['current_stage_name'] = $get_all_workflow_details[0]->jwf_stage_name;
            $return_arr['article_data']['current_status'] = $article_flow_id;
            $return_arr['article_data']['art_submitted_by'] = $article_data->art_submitted_by;
            $return_arr['article_data']['art_id'] = $article_data->art_id;
            $return_arr['article_data']['art_code'] = $article_data->art_code;
            $return_arr['article_data']['art_title'] = $article_data->art_title;
            $return_arr['article_data']['art_abstract'] = $article_data->art_abstract;
            $return_arr['article_data']['art_submission_date'] = $article_data->art_submission_date;
            $return_arr['article_data']['art_authors'] = $auth_data_arr;
            $article_keywords_table = new \App\Models\Article_keywords();
            $article_type_table = new \App\Models\Article_types();
            $art_jnl = $article_type_table::get_single_record_with_bind_cond('artp_jnl_id',array('artp_id' => $article_data->art_artp_id));
            $hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;
            $article_keywords = $article_keywords_table::get_article_keywords($article_id, FALSE, FALSE, $hierachy, $art_jnl->artp_jnl_id);
            $return_arr['article_data']['art_keywords'] = [];
            $return_arr['article_data']['art_classification'] = [];
            if(!empty($article_keywords))
            {
                $art_kwd_arr = array();
                foreach($article_keywords as $single_art_keyword)
                {
                    array_push($art_kwd_arr,$single_art_keyword->kwd_name);
                }
                $return_arr['article_data']['art_keywords'] = $art_kwd_arr;
            }
            $condition ="arcls_art_id =:art_id";
            $Article_classification = new \App\Models\Article_classification();
            $classification_tbl =  new \App\Models\Classifications();

            $cls_table = (new \App\Models\Classifications())->getTable();
            $checkBoxData = $Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition,NULL,'',NULL,array('art_id'=>$article_id));
            if(!empty($checkBoxData->checkData)){
                $class_id = explode(',', $checkBoxData->checkData);
                $art_class_arr = array();
                $term_table = (new \App\Models\Terms())->getTable();

                foreach($class_id as $single_class_id)
                {
                    $criteria = 'cls_id =' . $single_class_id;
                    $join_tbls =  array(
                        'main_table' => $cls_table,
                        'join_table' => array(
                            $term_table => array($term_table . '.term_id', $cls_table . '.cls_term_id')
                        )
                    );
                    $cls_dtls = $classification_tbl::get_results_using_joins($join_tbls,'term_name', $criteria, 'all');
                    array_push($art_class_arr,$cls_dtls[0]->term_name);
                }
                $return_arr['article_data']['art_classification'] = $art_class_arr;
            }
            $client_code = $this->current_client->clnt_client_code;
            if(count($get_all_attach_details) > 0)
            {
                $other_docs = array();
                foreach($get_all_attach_details as $single_attac)
                {
                    $doc_dtls = $this->get_file_name_and_path($single_attac);
                    if($single_attac->afdec_main_document == 'y')
                    {
                        $return_arr['document_id'] = $single_attac->atmnt_id;
                        $return_arr['main_document'] = $doc_dtls['file_name'];
                        $return_arr['file_ftp_location'] = $doc_dtls['file_path'].'/'.urlencode($doc_dtls['file_name']);
                    }
                    else
                    {
                        array_push($other_docs,$doc_dtls['file_name']);
                    }
                }
                $return_arr['other_documents'] = NULL;
                if(count($other_docs) > 0)
                {
                    $return_arr['other_documents'] = $other_docs;
                }
            }
            $return_arr['user_email'] = $user_data->usr_email;
            $return_arr['user_first_name'] = $user_data->usr_first_name;
            $return_arr['user_id'] = $user_data->usr_id;
            $return_arr['user_last_name'] = $user_data->usr_last_name;
            $return_arr['user_middle_name'] = $user_data->usr_middle_name;
            $return_arr['user_name'] = $user_data->user_name;
            $return_arr['user_current_auth_id'] = $auth_id;
            $return_arr['user_current_role'] = $current_role;
            $return_arr['article_data']['current_role'] = $current_role;
            return $return_arr;
    }

    public function document_convert_in_rvrite(Request $request)
    {
        try
        {
        $return_arr = array('status' => 'failed','msg' => '');
        $validator = Validator::make($request->all(), [
            "file_caption_id" => "required",
            "file_id" =>  "required",
            "location" =>  "required",
            "jnl_id" =>  "required",
            "art_flw_id" =>  "required",
            "auth_id" =>  "required",
            "current_role" =>  "required",
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        $post_data = $request->all();
        $article_flw_id = '';
        $article_id = Rv_decrypt($post_data['article_id']);
        if(isset($post_data['art_flw_id']))
        {
            $current_user = $this->get_current_user_details();
            $Users = new \App\Models\User();
            $user_data = $Users::get_single_record_with_bind_cond('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,concat(usr_first_name,\' \',usr_last_name) as user_name',array('usr_id' => $current_user['user_id']));
            $article_flw_id = decrypt_link($post_data['art_flw_id']);
            $data_to_editor = $this->set_data_for_editor($article_id,$article_flw_id,$user_data,$post_data['auth_id'],$post_data['current_role']);
            $main_document_name = $data_to_editor['main_document'];
            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
            $es_api_data  = Config::get($es_config);
            $apiUrl = $es_api_data['doc_convert_url'];
            $data_to_editor = http_build_query($data_to_editor);
            $response = $this->es_curl_request($apiUrl,$data_to_editor);
            $response = json_decode($response);
            if(isset($response->status) && $response->status == 200 && !isset($response->status_code))
            {
                $file_id = decrypt_link($post_data['file_id']);
                $update_attachment = Attachment_files::update_record(array('atmnt_doc_created_in_es' => 'y'), "atmnt_id = {$file_id}", $current_user); 
                $return_arr = array('status' => 'success','success_msg' => customTrans(('viewarticle.document_convert_success')));
            }   
            else if(isset($response->errorMessages))
            {
                $return_arr = array('status' => 'error','latex_error' => $response->errorMessages ,'error_document' => $main_document_name);
            }
            else
            {
                $return_arr = array('status' => 'error','err_msg' => customTrans('viewarticle.doc_covert_error'));
            }
        }

        return  $this->success('Success', 200, $return_arr);
    } catch(\Exception $e){
            return  $this->failure('Failed', 500, $e);
    }
        
    }

    public function check_document_created(Request $request)
    {
        try
        {
            $return_arr = array('status' => 'failed','msg' => '');
            $validator = Validator::make($request->all(), [
                "article_id" => "required",
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $post_data = $request->all();
            $article_id = decrypt_link(Rv_decrypt($post_data['article_id']));
            $Attachment_files_table = (new \App\Models\Attachment_files())->getTable();
            $Attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
            $tables = array(
                'main_table' => $Attachment_files_table,
                'join_table' => array(
                    $Attachment_file_description_table => array($Attachment_files_table . '.atmnt_label', $Attachment_file_description_table . '.afdec_id')
                )
            );
            $form_select = 'atmnt_id,atmnt_file_name,atmnt_label';
            $condition = 'afdec_main_document = "y" AND atmnt_art_id = '.$article_id;
            $main_document = Attachment_files::get_results_using_joins($tables, $form_select, $condition,'all', "atmnt_order");
            if(!empty($main_document))
            {
                $file_name = rawurlencode($main_document[0]->atmnt_file_name);
                $query_string = 'article_id='.$article_id.'&file_name='.$file_name;
                $pass_arr = array();
                $pass_arr['encryptedData'] = Rv_encrypt($query_string);
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $apiUrl = $es_api_data['doc_status_url'];
                $pass_arr =  array('encryptedData' => Rv_encrypt($query_string));
                //$pass_arr = http_build_query($pass_arr);
                $response = $this->es_curl_request($apiUrl,$pass_arr);
                $response = json_decode($response);
                if(isset($response->status) && $response->status == 200)
                {
                    $return_arr['status'] = 'success';
                }
            }
            return  $this->success('Success', 200, $return_arr);
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

	
    /* TASK #5384 Api for getting unset tab details */
    public function get_unset_tab_details(Request $request){
        try{
            $post_data=$request->all();
            $validator = Validator::make($request->all(), [
                'art_type_code' => 'required',
                'platform_code' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' =>$post_data['platform_code'],
                'type'=> 'string'
            );
            $platformcode_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$post_data['art_type_code'],
                'type'=> 'string'
            );
            $arttypecode_validate = $this->Rv_validator($input_arr);
            if($platformcode_validate == FALSE ||$arttypecode_validate==FALSE)
			{
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",201,$arraymsg);
            }
            $return_array=array();
            $articletype_code= $post_data['art_type_code'];
            $platform_code = $post_data['platform_code'];
            $platform_data = $this->platform_basic_settings_data($platform_code);
            if(isset($platform_data) && !empty($platform_data)){
                $platform_id = $platform_data->jnl_id;
            }
           
            $article_type_details = $this->article_type_settings_data($articletype_code, $platform_id);
            if(isset($article_type_details) && !empty($article_type_details)){
                $articletype_id=$article_type_details->artp_id;
            }
            
            $article_advanced_details = Article_type_advance_options::get_single_record('*', "atotp_artp_id=?",binding_arr:[$articletype_id]);
            $flow_master_id = Article_types::get_single_record('artp_fwm_id', "artp_id=?",binding_arr:[$articletype_id]);
            $return_array['unset_tabattach_files']=FALSE;
            $return_array['unset_tabreview_preference']=FALSE;
            $return_array['unset_tabadditional_info']=FALSE;
            $show_generic_tab = FALSE;
            $article_for_resubmission = FALSE; 
            if ($article_for_resubmission == FALSE) {
                $getforms = Article_types::get_form_onstage('author_submission', $articletype_id);
                !empty($getforms) && $show_generic_tab= TRUE;
            } else {
                $getforms = array();
            }
            if(isset($flow_master_id)&& !empty($flow_master_id)){
                $stage = Generic_flows::get_single_record('jwf_article_attachment_status,jwf_enable_payment', "jwf_stage_type='author_submission' AND jwf_fwm_id=?",binding_arr:[$flow_master_id->artp_fwm_id]);
                $article_attachment_status=$stage->jwf_article_attachment_status;
                $article_payment_status=$stage->jwf_enable_payment;
                if($article_attachment_status=='n')
                {
                    $return_array['unset_tabattach_files']=TRUE;
                } 
            }

            if(isset($article_advanced_details) && !empty($article_advanced_details)){
                if ($article_advanced_details->atotp_suggest_reviewers == 'n' && $article_advanced_details->atotp_oppose_reviewers == 'n') {
                    $return_array['unset_tabreview_preference']=TRUE;
                } 
            }
            if ($show_generic_tab== FALSE) {
                $return_array['unset_tabadditional_info']=TRUE;
            }
            $return_array['unset_tabpayment_info'] = TRUE;//for payment in abstract submission in confrence
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y' && $article_payment_status =='y') {
                $return_array['unset_tabpayment_info'] = FALSE;
            }

            return $this->success('Success', 200, $return_array);


        } catch(\Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    }
    /* end TASK #5384 Api for getting unset tab details */

    public function remove_main_attachment(Request $request)
    {
        try 
        {
            $return_arr = ['success' => FALSE];
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $post_data = $request->all();
            $art_id = $this->decrypt_data($post_data['art_id']);
            $artp_code = $post_data['artp_code'];
            $platform_code = $post_data['platform_code'];
            if ($art_id != '' && $artp_code != '') 
            {
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $apiUrl = $es_api_data['delete_article_url'];
                $current_user = $this->current_user['user_id'];
                $pass_data = array('art_id' => $art_id,'user_id' => $current_user);				
                $response = $this->es_curl_request($apiUrl,$pass_data);
                $response = json_decode($response);
                if(isset($response->status) && $response->status == 'success')
                {
                    $update_data = array('art_es_document_status' => 'a','art_es_document_type' => NULL);
                    $condition = array('art_id' => $art_id);
                    //$this->current_user = $this->get_current_user_details();
                    $update_record = Articles::update_record($update_data, "art_id = ?", $this->current_user,binding_arr:[$art_id]);
                    if($update_record)
                    {
                        $return_arr = ['success' => TRUE];
                        return $this->success('Success', 200, $return_arr);
                    }
                }
                else
                {
                    $return_arr = ['success' => false];
                    return $this->success('Failed', 200, $return_arr);
                }
            }
        }
        catch(\Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_article(){
        return 'id';
    }
    public function send_supplimentary_files_to_s3($attch_data)
    {
        $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
        $client_defaults  = Config::get($client_default);

        //if($this->current_client->functionality->cfty_enable_upload_s3_bucket == 'y')
        //{
            $file_contents = '';
            if($client_defaults['es_integration_transfer_file_from'] == 's3')
            {
                $source_file_path =  $this->upload_folder_path('uploads/'.$attch_data->atmnt_orginal_upload_path.'/'.str_replace(" ", "+", $attch_data->atmnt_file_name));
                $file_contents = file_get_contents($source_file_path);
            }
            else
            {
                $filePath = 'uploads/'.$attch_data->atmnt_orginal_upload_path.'/'.str_replace(" ", "+", $attch_data->atmnt_file_name);
                $file_contents = Storage::disk('public')->get($filePath);
            }
            $upload_file = false;
            if($client_defaults['es_integration_transfer_file_to'] == 's3')
            {
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $folder_name = $es_api_data['s3_folder_name'];	
                $s3FilePath = '/'.$folder_name.'/'.$attch_data->atmnt_orginal_upload_path.'/'.rawurlencode($attch_data->atmnt_file_name);
                $upload_file  = Storage::disk('s3_es')->put($s3FilePath, $file_contents);
            }
            if($upload_file == true)
            {
                $update_attachments = Attachment_files::update_record(array(
                    'atmnt_send_to_es' => 'y'
                ), "atmnt_id = ?", $this->current_user,binding_arr:[$attch_data->atmnt_id]);
            }
        //}
        /*else
        {
            $pass_data = array();
            $pass_data['folder_path'] = $attch_data->atmnt_orginal_upload_path;
            $pass_data['source_file_path'] = $source_file_path;
            $pass_data['file_name'] = str_replace(" ", "+", str_replace(" ", "+", $attch_data->atmnt_file_name));
            $upload_to_ftp = $this->send_editor_suite_file_to_ftp($pass_data);
            if(isset($upload_to_ftp['status']) && $upload_to_ftp['status'] == true)
            {
                $update_attachments = Attachment_files::update_record(array(
                    'atmnt_send_to_es' => 'y'
                ), "atmnt_id = ?", $this->current_user,binding_arr:[$attch_data->atmnt_id]);
            }
        }*/
    }
}
