<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Article_types;
use App\Models\Journals;
use App\Models\Flow_master;
use App\Models\Article_type_advance_options;
use App\Models\Generic_flows;
use App\Models\Journal_permission_master;
use App\Models\Required_file_type;
use App\Models\Journal_terms;
use App\Models\Api_credentials;
use App\Models\Classifications;
use App\Models\Ftp;
use App\Models\Stage_email_tmpl_reference;
use App\Models\User_to_journals;
use App\Models\Assign_permission;
// use App\Models\Article_secondary_classification;
use App\Models\Articles;
use App\Models\Article_transfer_suggestion;
use App\Models\Roles;
use App\Models\Journal_permission;
use App\Models\Journal_settings;
use App\Models\User_journal_classifications;
use App\Models\Advance_flow_movement;
use JWTAuth;
use JWTAuthException;
use Illuminate\Support\Facades\DB;
use Config;
use App\Http\Traits\ModalDataTrait;
use App\Models\Article_flag;
use App\Models\Article_flow;
use App\Models\Article_notification_emails;
use App\Models\Rescind_reset_record;
use App\Models\Review_discussion;
use Exception;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use \stdClass;




class Manage_Articletype_Api extends Controller
{
	public function index(Request $request)
	{
		try {
			/* TASK #6805 Copy journal and manage article type icon is disabled Start */			
			$data=$request->all();
			$validator = Validator::make($request->all(), [
				'jnl_code' => 'required'
			]);
			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}
			$jnlcode=$data["jnl_code"];
		
			$jounal_data = Journals::get_single_record_with_bind_cond('*',array("jnl_journal_code"=>$jnlcode));
			/* start --- get all article types in resp. journal */
		
		   $return_data['chk_jnl_status']  = true;
			//task #672 check journal have a proper workflow, if not redirect to home page
			$proper_flow = $this->validate_journal($jounal_data->jnl_fwm_id, $jounal_data->jnl_id);
			$is_sudo    =    false;
			$this->current_user = $this->get_current_user_details();
			$isSudoChk = array_intersect($this->current_user['roles'], array('sudo', 'super_admin'));
			if(!empty($isSudoChk))
			{
				$is_sudo    =    true;
				$return_data['chk_jnl_status']  = $jounal_data->jnl_journal_status == 'y'?true:false;
			}
			// $check_access=$this->check_admin_access("journals",$this->current_user['roles']);
			// if($check_access==true)
			// {
			// 	$is_sudo    =    true;
			// 	$return_data['chk_jnl_status']  = $jounal_data->jnl_journal_status == 'y'?true:false;
			// }
			
			$return_data['is_sudo']  = $is_sudo;

			if ($proper_flow['status'] == false) {
				$return_data['status']='failed';
				$return_data['errors']=$proper_flow;
				return $this->success("Success",200, $return_data );
			}
			if ($jounal_data->jnl_journal_status == 'n' &&  $is_sudo ==false )
			{
			$return_data['chk_jnl_status']  =   false;
			$return_data['status']='failed';
			// return $this->success("Success",200, $return_data );
			}
		$sort_field = $data['sort_field'] ?? 'etmp_id';
		$sort_order = $data['sort_order'] ?? 'asc';
		$limit = $data['per_page'] ?? 5;
		$select = "*";
		$condition = "artp_jnl_id={$jounal_data->jnl_id}";
		$return_data['all_article_types'] = Article_types::get_paginated_records($select, $condition, $sort_field, $sort_order, $limit);

		return $this->success("Success",200, $return_data );
			/* TASK #6805 Copy journal and manage article type icon is disabled End  */
		/* end --- get all article types in resp. journal */
	} catch (\Exception $e) {
		// DB::rollback();
		return $this->failure('Failure', 500, $e);
	}
	}
	public function checkArticletypeInfo(Request $request)
	{
		try {
			$article_type_data = $request->all();

			$condition = '';
			$bind_arr=[];
			if (!empty($article_type_data) && isset($article_type_data['value'])) {
				// $condition = "artp_jnl_id ='" . $article_type_data["jnl_id"] . "'";
				$condition = "artp_jnl_id = ?";
				$bind_arr[] = $article_type_data["jnl_id"];
				if (isset($article_type_data['hdn_articletype_id']) && $article_type_data['hdn_articletype_id'] != '') {
					// $condition .= " AND  artp_id <> '" . $article_type_data['hdn_articletype_id'] . "'";
					$condition .= " AND  artp_id <> ?";
					$bind_arr[] = $article_type_data['hdn_articletype_id'];
				}
			}
			$check = $article_type_data['check'];

			// $condition .= " AND artp_" . $check . "= '" . $article_type_data["value"] . "'";
			$condition .= " AND `artp_".$check."` = ?";
			$bind_arr[]=$article_type_data["value"];
			$avl_art_type = Article_types::get_single_record("count(*) count", $condition,binding_arr:$bind_arr);

			if ($avl_art_type->count > 0) {
				$return_array['found'] = true;
			} else {
				$return_array['found'] = false;
			}
			return $this->success("Success", 200, $return_array);
		} catch (\Exception $e) {
			// DB::rollback();
			return $this->failure('Failure', 500, $e);
		}
	}

	public function saveSettings(Request $request)
	{

		// DB::beginTransaction();
		$article_type = $request->all();

		try {

			$this->current_user = $this->get_current_user_details();
			if ($this->current_client->modules->mdl_review_for_doc == 'y') {
				$article_type['chk_submission_type'] = array('0' => 'a');
				$article_type['special_issue'] = 'n';
			} elseif ($this->current_client->functionality->cfty_enable_issue_inarticletype == 'n') {
				$article_type['special_issue'] = 'n';
			}

			$retired_role_status = NULL;


			$validator = Validator::make($request->all(), [
				'article_type_code' => 'required',
				'article_type' => 'required',
				'submission_type'   => 'required',
				'revision_id_postion' => 'required',
				'prefix' => 'required',
				'type_format' => 'required',
			]);
			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}
			$jnl_id = $article_type['jnl_id'];
			$artp_id = $article_type['article_type_id'] ? $this->decrypt_data($article_type['article_type_id']) : '';

			$get_uni_article_type = NULL;
			$get_uni_article_type_title = NULL;

			// $accode_condition = "artp_abbr_article_type='{$article_type['article_type_code']}' AND artp_jnl_id='{$jnl_id}' AND artp_id <> '{$artp_id}'";
			$accode_condition = "artp_abbr_article_type= ? AND artp_jnl_id= ? AND artp_id <> ?";
			// $title_condition = "artp_article_type='{$article_type['article_type']}' AND artp_jnl_id='{$jnl_id}' AND artp_id <> '{$artp_id}'";
			$title_condition = "artp_article_type= ? AND artp_jnl_id= ? AND artp_id <> ?";
			$platform_es_checking = isset($article_type['platform_es_checking']) ? $article_type['platform_es_checking'] : 'n';
			$get_uni_article_type =  Article_types::get_single_record('*', $accode_condition,binding_arr:[$article_type['article_type_code'],$jnl_id,$artp_id]);

			//to check article type title in db
			$get_uni_article_type_title =  Article_types::get_single_record('*', $title_condition,binding_arr:[$article_type['article_type'],$jnl_id,$artp_id]);

			//save details
			if ($get_uni_article_type == NULL && $get_uni_article_type_title == NULL) {

				$replace_str = array(
					'"',
					"'"
				);

				$article_prefix = trim(str_replace($replace_str, '', $article_type['prefix']));
				$article_suffix = trim(str_replace($replace_str, '', $article_type['type_format']));
				$color_code = '';

				if ($article_type['choose_color'] != '') {
					$color_code = $article_type['choose_color'];
				}
				$data = array(
					'artp_article_type' => $article_type['article_type'],
					'artp_abbr_article_type' => $article_type['article_type_code'],
					'artp_login_user_type' => json_encode($article_type['submission_type']),
					'artp_jnl_id' => $jnl_id,
					'artp_prefix_article_no' => $article_prefix,
					'artp_suffix' => $article_suffix,
					//'artp_postfix_article_no_length' => $article_type['postfixno'],
					'artp_description' => $article_type['articletype_description'],
					'artp_palette_color_code' => $color_code,
					'artp_revision_id_postion' => $article_type['revision_id_postion'],
                    'artp_venue' => $article_type['venue'] ?? null,
                    'artp_contact_num' => $article_type['contact_num'] ?? null,
                    'artp_website_url' => $article_type['website_url'] ?? null,
					'artp_es_document_type'=>$platform_es_checking
				);

				//* start -- special issue*//
				$date_error_msg = '';
                $conference = $this->current_client->modules->mdl_conference ?? 'n';
				if ($this->current_client->functionality->cfty_enable_issue_inarticletype == 'y' && $conference != 'y') {
					if(isset($article_type['disable_check_issue']) && $article_type['disable_check_issue'] == false)
					{
					$data['artp_special_issue'] = isset($article_type['special_issue']) ? $article_type['special_issue'] : 'n';
					if (isset($article_type['special_issue']) && $article_type['special_issue'] == 'y') {
					$responseArr = $article_type['parent_article_type'];
					$parentids = implode(',', $responseArr);
					$data['artp_parent_artp_id'] = $parentids;
					$date_format=$this->get_platform_date_format($jnl_id);
					$data['artp_start_date'] = convert_dmy_to_ymd($article_type['hdn_start_date'], $date_format);
					$data['artp_soft_enddate'] = convert_dmy_to_ymd($article_type['hdn_soft_enddate'], $date_format);
					$data['artp_hard_enddate'] = convert_dmy_to_ymd($article_type['hdn_hard_enddate'], $date_format);
					$data['artp_production_deadline'] = convert_dmy_to_ymd($article_type['hdn_prdn_deadline'], $date_format);
					if (date($data['artp_hard_enddate']) < date($data['artp_soft_enddate']) || date($data['artp_hard_enddate']) < date($data['artp_start_date']) || date($data['artp_soft_enddate']) < date($data['artp_start_date']))
						$date_error_msg = $date_error_msg . 'Please check special issue dates';
					elseif (date($data['artp_production_deadline']) <= date($data['artp_hard_enddate']) || date($data['artp_production_deadline']) <= date($data['artp_soft_enddate']) || date($data['artp_production_deadline']) <= date($data['artp_start_date']))
						$date_error_msg = $date_error_msg . 'Please check production deadline';
				} else {
				$data['artp_parent_artp_id'] = NULL;
				$data['artp_start_date'] = NULL;
				$data['artp_soft_enddate'] = NULL;
				$data['artp_hard_enddate'] = NULL;
				$data['artp_production_deadline'] = NULL;
				 }
				}
				}else if($conference == 'y'){
                    $date_format=$this->get_platform_date_format($jnl_id);
					$data['artp_start_date'] = convert_dmy_to_ymd($article_type['hdn_start_date'] ??  date('Y-m-d'), $date_format);
					$data['artp_soft_enddate'] = convert_dmy_to_ymd($article_type['hdn_soft_enddate'], $date_format);
					$data['artp_hard_enddate'] = convert_dmy_to_ymd($article_type['hdn_hard_enddate'], $date_format);
                    $data['artp_production_start_date'] = convert_dmy_to_ymd($article_type['hdn_prdn_start_date'], $date_format);
					$data['artp_production_deadline'] = convert_dmy_to_ymd($article_type['hdn_prdn_deadline'], $date_format);
					if (date($data['artp_hard_enddate']) < date($data['artp_soft_enddate']) || date($data['artp_hard_enddate']) < date($data['artp_start_date']) || date($data['artp_soft_enddate']) < date($data['artp_start_date']))
						$date_error_msg = $date_error_msg . 'Please check submission dates';
					elseif (date($data['artp_production_deadline']) < date($data['artp_hard_enddate']) || date($data['artp_production_deadline']) < date($data['artp_soft_enddate']) || date($data['artp_production_deadline']) < date($data['artp_start_date']) || date($data['artp_production_deadline']) < date($data['artp_production_start_date']))
						$date_error_msg = $date_error_msg . 'Please check event dates';
                }else{
					$data['artp_parent_artp_id'] = NULL;
					$data['artp_start_date'] = NULL;
					$data['artp_soft_enddate'] = NULL;
					$data['artp_hard_enddate'] = NULL;
					$data['artp_production_deadline'] = NULL;
					$data['artp_special_issue'] ='n';
				}
				 //print_r($data);die;
				//* start -- special issue*//
				if ($date_error_msg != '') {
					
					$return_array['status'] = 'failed';
					$return_array['msg'] = $date_error_msg;
					return $this->warning('Failed',200, $return_array);
				} else {
					if ($artp_id == '' || $artp_id == null) {
						//get journal data
						// $where_cnd = 'jnl_id = ' . $jnl_id;
						$where_cnd = 'jnl_id = ?';
						$journal_data = Journals::get_single_record('*', $where_cnd,binding_arr:[$jnl_id]);
						// $this->load->model(array(
						// 	'Flow_master'
						// ));
						// Flow_master::trans_start();
						//Task #4768 Article types use journal workflow
						$use_jnl_workflow = TRUE;
						$use_jnl_permissions = TRUE;
						if (isset($article_type['use_journal_workflow']) && $article_type['use_journal_workflow'] == 'y') {
							$mast_flow_id = $journal_data->jnl_fwm_id;
						} else {
							$use_jnl_workflow = FALSE;
							$article_type_desc = 'Flow of ' . $data['artp_article_type'];
							//for getting master flow tb id (FLOW)
							$flow_data = ['fwm_description' => $article_type_desc];
							$mast_flow_id = Flow_master::insert_record($flow_data, $this->current_user);
						}
						$data['artp_fwm_id'] = $mast_flow_id;

						if (isset($article_type['use_journal_permissions']) && $article_type['use_journal_permissions'] == 'y') {
							$mast_permission_id = $journal_data->jnl_jpm_id;
						} else {
							$use_jnl_permissions = FALSE;
							$Permission_desc = 'Permission of ' . $data['artp_article_type'];

							$mast_permission_id = Journal_permission_master::insert_record(array(
								'jpm_description' => $Permission_desc
							), $this->current_user);
							$permission_setting_data=array();
							if ($this->current_client->modules->mdl_review_for_doc == 'n') {
								$role_table = (new \App\Models\Roles())->getTable();
								$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
								$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";
								$previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
								$user_roles = Roles::get_records_by_raw_query($previleged_sql);
								$role_id_perm = array();
								foreach ($user_roles as $val) {
									if ($val->role_assigned_role == 'journal_admin' || $val->role_assigned_role == 'staff') {
												$role_id_perm[] = "$val->role_id";
											}
									}
									//set default permission for article add notes
									$permission_setting_data["jp_add_notes"]=json_encode($role_id_perm);
							}
						$permission_setting_data["jp_jpm_id"]=$mast_permission_id;
						Journal_permission::insert_record($permission_setting_data, $this->current_user);
						}
						$data['artp_jpm_id'] = $mast_permission_id;

						//insert article type
						$id = Article_types::insert_record($data, $this->current_user);

						$art_advance_options = $this->copy_jnl_settings($jnl_id, $id, $this->current_user['user_id']);


						//fetch article type advance options


						$get_adv_option_condition = "atotp_artp_id=" . $id;
						$get_article_type_settings = Article_type_advance_options::get_single_record('*', $get_adv_option_condition);

						$art_file_type = $this->copy_file_settings($jnl_id, $id, $this->current_user['user_id']);


						if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role) {
							$retired_role_status = $this->current_client->functionality->cfty_retire_role;
						}
						if ($get_article_type_settings->atotp_classification_hierarchy === 'n') {
							//if no hierarcy then direct copy in db
							$this->copy_classification($jnl_id, $id, $this->current_user['user_id']);
							/*bug #2017 fix
							*/
							// $trm_con="cls_jnl_id='{$jnl_id}'and cls_artp_id is NULL";
							$trm_con="cls_jnl_id= ? and cls_artp_id is NULL";
							$get_classification_primary = Classifications::get_all_records('*', $trm_con,binding_arr:[$jnl_id]);
								if (!empty($get_classification_primary) && count($get_classification_primary)>0) {
									foreach ($get_classification_primary as $jnl_primary) {
										$primary_array['cls_term_id'] = $jnl_primary->cls_term_id;
										$primary_array['cls_artp_id'] = $id;
										$primary_array['cls_jnl_id'] = $jnl_id;
										$primary_array['cls_primary_id'] = $jnl_primary->cls_primary_id;
										$primary_array['cls_old_cls_id'] = $jnl_primary->cls_id;
									}
									$new_primary_id = Classifications::insert_record($primary_array, $this->current_user);
								}

							$data = $this->copy_user_jnl_classifications($jnl_id, $id, $this->current_user['user_id'], $retired_role_status);
							//update primary column of user journal classification table

							$this->update_user_jnl_classification_article_type($id);
						} elseif ($get_article_type_settings->atotp_classification === 'y') {
							//then we need self reference id
							// $primary_array = "jntm_jnl_id=".$jnl_id." and jntm_type = 'p' and jntm_artp_id = NULL";

							// $get_classification_primary = Journal_terms::get_all_records('*', $primary_array);

							// if (!empty($get_classification_primary)) {
							// 	foreach ($get_classification_primary as $jnl_primary) {
							// 		$condition_jnl_trr="jntm_term_id=".$jnl_primary->jntm_term_id." and jntm_artp_id=".$id." and jntm_old_jntm_id".$jnl_primary->jntm_id;
							// 		// $primary_array['jntm_term_id'] = $jnl_primary->jntm_term_id;
							// 		// $primary_array['jntm_artp_id'] = $id;
							// 		// $primary_array['jntm_old_jntm_id'] = $jnl_primary->jntm_id;
							// 		// //insert primary
							// 		$new_primary_id = Journal_terms::insert_record($condition_jnl_trr, $this->current_user);

							// 		//direct insert secondary
							// 		if ($get_article_type_settings->atotp_secondary_class === 'y') {
							// 			Journal_terms::copy_secondary($new_primary_id, $jnl_primary->jntm_id, $id, $this->current_user['user_id']);
							// 		}
							// 	}
							// }
							/* ADD user_journal_classifications to article type */
							// $this->copy_user_jnl_classifications($jnl_id, $id, $this->current_user['user_id'], $retired_role_status);
							// //update primary column of user journal classification table
							// $this->update_user_jnl_classification($id);

							//clear jntm_old_jntm_id
							// $updatecondition="jntm_jnl_id={$jnl_id} and jntm_artp_id={$id}";
							// Journal_terms::update_record(array(
							// 	'jntm_old_jntm_id' => NULL
							// ), $updatecondition,$this->current_user);
						}
						// }
						/* end --- copy journal classification to article type
					 * and get classification for article type */
						if ($use_jnl_workflow == FALSE) {
							/* ADD journal flow to article type */
							// Generic_flows::trans_start();
							$this->insert_article_flow($journal_data->jnl_fwm_id, $mast_flow_id, $this->current_user['user_id']);


							/*
					 * task#669-Flow based FTP export
					 * Add journal workflow based ftp to new article type
					 */
							$jnlData = new stdClass;
							$jnlData->jnl_id =$journal_data->jnl_id;
							$jnlData->jnl_fwm_id = $journal_data->jnl_fwm_id;
							$this->copy_ftp_in_journal_workflow($jnlData, $mast_flow_id);

							/* ADD Gereric form to article type */
							//for insert generic form  and its elements and update article type form json id
							$genflow_condition = "jwf_fwm_id=" . $mast_flow_id;
							$article_flows = Generic_flows::get_all_records('*', $genflow_condition);
							// if (Generic_flows::trans_complete() === TRUE) {

							if (!empty($article_flows)) {

								$art_master = array(); //master array for track old and new ids
								$temp_id = array(); //(old_id => new_id)
								$insert_asoc_tmpls = array();
								foreach ($article_flows as $art_flow) {
									//getting old and new ids
									$temp_id[$art_flow->jwf_temp_id] = $art_flow->jwf_id;
									//getting old and new ids
									$art_child = array();

									$old_forms = json_decode($art_flow->jwf_forms);

									$con_asoc_tmpls = "setr_jwf_id=" . $art_flow->jwf_temp_id;
									//associate journal workflow templates to article type : Customisation #1565
									$asoc_tmpls = Stage_email_tmpl_reference::get_all_records('setr_stage_etmp_id', $con_asoc_tmpls);



									foreach ($asoc_tmpls as $t) {
										$insert_asoc_tmpls[] = array(
											'setr_jwf_id' => $art_flow->jwf_id,
											'setr_stage_etmp_id' => $t->setr_stage_etmp_id,
											'setr_posted_date' => date('Y-m-d H:i:s'),
											'setr_posted_by' => $this->current_user['user_id'],
											'setr_proxy_id' => $this->current_user['proxy_user_id'],
											'setr_operation' => 'i'
										);
									}
								}
								if (!empty($insert_asoc_tmpls))
									Stage_email_tmpl_reference::insert_batch($insert_asoc_tmpls);
								//start updating old stag ids with new ids
								foreach ($article_flows as $article_flow) {
									$parent_stages = json_decode($article_flow->jwf_parent_stages);
									foreach ($parent_stages as $key => $parent_stages_id) {
										foreach ($temp_id as $old_stage_id => $new_stage_id) {
											$con_acive = "jwf_id=" . $parent_stages_id . " and jwf_hide_status='n'";
											$active_record = Generic_flows::get_single_record('jwf_id', $con_acive);
											if (!empty($active_record)) {
												if ($parent_stages_id == $old_stage_id) {
													$parent_stages[$key] = "".$new_stage_id."";
												}
											} else {
												unset($parent_stages[$key]);
											}
										}
									}
									$parent_stages = array_values($parent_stages);
									$con_update = "jwf_id=" . $article_flow->jwf_id;
									Generic_flows::update_record(array(
										'jwf_parent_stages' => json_encode($parent_stages)
									), $con_update,$this->current_user);

									$child_stages = json_decode($article_flow->jwf_child_stages);


									foreach ($child_stages as $key => $child_stages_id) {
										foreach ($temp_id as $old_stage_id => $new_stage_id) {
											//oldstage check exist then unset data
											$cond_active = "jwf_id=" . $child_stages_id . " and jwf_hide_status='n'";
											$active_record = Generic_flows::get_single_record('jwf_id', $cond_active);
											if (!empty($active_record)) {
												if ($child_stages_id == $old_stage_id) {
													$child_stages[$key] = "".$new_stage_id."";
												}
											} else {
												unset($child_stages[$key]);
											}
										}
									}
									$cond_up_child = "jwf_id=" . $article_flow->jwf_id;
									$child_stages = array_values($child_stages);
									Generic_flows::update_record(array(
										'jwf_child_stages' => json_encode($child_stages)
									), $cond_up_child,$this->current_user);
								}

								//Task 664 ICE ReView new stages
								$this->manage_advance_flow_movement_entries($journal_data->jnl_fwm_id, $mast_flow_id, $temp_id);
							}
							// }
						}
						//end updating old stag ids with new ids
						/* ADD User Role in Journal to article type */
						$retire_role_status = FALSE;
						if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y') {
							$retire_role_status = TRUE;
						}
						User_to_journals::move_user_roles($jnl_id, $id, $this->current_user['user_id'], NULL, $retire_role_status);
						// $this->load->model('Assign_permission');
						if (isset($article_type['use_journal_permissions']) && $article_type['use_journal_permissions'] == 'y') {
						Assign_permission::move_user_assgmnt($jnl_id, $id, $this->current_user['user_id']);
						}

						
						$redir_link = $article_type['article_type_code'] . '/settings/' . $this->encrypt_data($id);
						$return_array['status'] = 'success';
						$return_array['redirectLink'] = $redir_link;
						$return_array['jnl_code'] = $journal_data->jnl_journal_code;
						$return_array['accode'] = $article_type['article_type_code'];
						$return_array['action_status'] = 'add';
						// DB::commit();
						return $this->success('success', 200, $return_array);

						// redirect(site_url($redir_link));
					} else if ($artp_id != '') {
						// $condition = "artp_id='{$artp_id}'";
						$condition = "artp_id= ?";

						 Article_types::update_record($data, $condition, $this->current_user,binding_arr:[$artp_id]);

						$return_array['status'] = 'success';
						$return_array['action_status'] = 'update';
						return $this->success('update', 201, $return_array);
					}
				}
			} else {

				$return_array['status'] = 'failed';
				$return_array['msg'] = customTrans('platform_settings.duplicate_article');
				return $this->success('success',201,$return_array);

			}
		} catch (\Exception $e) {
			// DB::rollback();

			return $this->failure('Failure', 500, $e);
		}
	}
	public function update_event_basic_setting(Request $request){
		try{
			$article_type = $request->all();
			$art_id=$this->decrypt_data($article_type['art_type_id']);
			$current_user = $this->get_current_user_details();
			$date_format=$this->get_platform_date_format($this->decrypt_data($article_type['jnl_id']));
			$data['artp_start_date'] = convert_dmy_to_ymd($article_type['artp_start_date'] ??  date('Y-m-d'), $date_format);
			$data['artp_hard_enddate'] = convert_dmy_to_ymd($article_type['artp_hard_enddate'], $date_format);
			$data['artp_production_start_date'] = convert_dmy_to_ymd($article_type['artp_production_start_date'], $date_format);
			$data['artp_production_deadline'] = convert_dmy_to_ymd($article_type['artp_production_deadline'], $date_format);
			$data['artp_venue']=$article_type['venue'];
			$data['artp_contact_num']=$article_type['phone_no'];
			$data['artp_website_url']=$article_type['website_url'];
			$condition = "artp_id='{$art_id}'";
			Article_types::update_record($data, $condition, $current_user);
			$return_array['status'] = 'success';
			$return_array['action_status'] = 'update';
			return $this->success('update', 201, $return_array);
		}
		catch (\Exception $e) {
			return $this->failure('Failure', 500, $e);
		}
	}

	public function copy_jnl_settings($journal_id, $article_type_id, $current_user)
	{
		// Task #925 added jset_research_integrity
		$Article_type_advance_options_tbl = (new \App\Models\Article_type_advance_options())->getTable();
		$Journal_settings = (new \App\Models\Journal_settings())->getTable();
		$sql = "insert into " . $Article_type_advance_options_tbl . " (atotp_artp_id,atotp_article_submission_type,atotp_paper_length,atotp_title_length,atotp_review_method,atotp_review_open_decision,atotp_review_open_count,atotp_file_type,atotp_file_description,atotp_custom_classification,atotp_classification_title,atotp_classification_hierarchy,atotp_min_keyword,atotp_max_keyword,atotp_user_input_keyword,atotp_suggest_reviewers,atotp_oppose_reviewers,atotp_convert_to_pdf,atotp_co_authors_agreement,atotp_text_direction,atotp_plagiarism_checking,atotp_default_ithapi_folder,atotp_ithsubmission_type,atotp_ithauto_submissions,atotp_research_integrity,atotp_rvrisubmission_type,atotp_rvriauto_submissions,atotp_posted_by,atotp_posted_date) "
			. "select " . $article_type_id . " ,jset_article_submission_type,jset_paper_length,jset_title_length,jset_review_method,jset_review_open_decision,jset_review_open_count,jset_file_type,jset_file_description,jset_custom_classification,jset_classification_title, jset_classification_hierarchy,jset_min_keyword,jset_max_keyword,jset_user_input_keyword,jset_suggest_reviewers, jset_oppose_reviewers, jset_convert_to_pdf,jset_co_authors_agreement,jset_text_direction,jset_plagiarism_checking,jset_default_ithapi_folder,jset_ithsubmission_type,jset_ithauto_submissions,jset_research_integrity,jset_rvrisubmission_type,jset_rvriauto_submissions," . $current_user . ",'" . date('Y-m-d H:i:s') . "' from " . $Journal_settings . " where jset_jnl_id=" . $journal_id;
		// $sql = "insert into " . $Article_type_advance_options_tbl . " (atotp_artp_id,atotp_article_submission_type,atotp_paper_length,atotp_review_method,atotp_review_open_decision,atotp_review_open_count,atotp_file_type,atotp_file_description,atotp_custom_classification,atotp_cust_secondary_class,atotp_secondary_class,atotp_min_no_secondary_class,atotp_max_no_secondary_class,atotp_secondary_class_alias, atotp_classification,atotp_min_no_primary_class,atotp_max_no_primary_class,atotp_primary_class_alias,atotp_classification_hierarchy,atotp_min_keyword,atotp_max_keyword,atotp_user_input_keyword,atotp_suggest_reviewers,atotp_oppose_reviewers,atotp_convert_to_pdf,atotp_co_authors_agreement,atotp_text_direction,atotp_plagiarism_checking,atotp_default_ithapi_folder,atotp_ithsubmission_type,atotp_ithauto_submissions,atotp_posted_by,atotp_posted_date) "
		// 	. "select " . $article_type_id . " ,jset_article_submission_type,jset_paper_length,jset_review_method,jset_review_open_decision,jset_review_open_count,jset_file_type,jset_file_description,jset_custom_classification,jset_cust_secondary_class,jset_secondary_class, jset_min_no_secondary_class, jset_max_no_secondary_class, jset_secondary_class_alias, jset_primary_class, jset_min_no_primary_class, jset_max_no_primary_class, jset_custom_classification, jset_classification_hierarchy,jset_min_keyword,jset_max_keyword,jset_user_input_keyword,jset_suggest_reviewers, jset_oppose_reviewers, jset_convert_to_pdf,jset_co_authors_agreement,jset_text_direction,jset_plagiarism_checking,jset_default_ithapi_folder,jset_ithsubmission_type,jset_ithauto_submissions," . $current_user . ",'" . date('Y-m-d H:i:s') . "' from " . $Journal_settings . " where jset_jnl_id=" . $journal_id;
		// $sql = "insert into ".$Article_type_advance_options_tbl." (atotp_artp_id,atotp_view_file_inventory,atotp_view_email_log,atotp_stage_manual_reminder,atotp_move_article_from_payment,atotp_article_submission_type,atotp_paper_length,atotp_review_method,atotp_review_open_decision,atotp_review_open_count,atotp_file_type,atotp_file_description,atotp_custom_classification,atotp_cust_secondary_class,atotp_secondary_class,atotp_min_no_secondary_class,atotp_max_no_secondary_class,atotp_secondary_class_alias, atotp_primary_class,atotp_min_no_primary_class,atotp_max_no_primary_class,atotp_primary_class_alias,atotp_classification_hierarchy,atotp_min_keyword,atotp_max_keyword,atotp_user_input_keyword,atotp_separate_adhoc_keywords,atotp_suggest_reviewers,atotp_oppose_reviewers,atotp_convert_to_pdf,atotp_co_authors_agreement,atotp_add_notes,atotp_flag_articles,atotp_edit_articles,atotp_edit_article_files,atotp_transfer_article,atotp_rescind_article,atotp_rescind_review,atotp_reset_article,atotp_extend_task,atotp_edit_reviewer_count,atotp_view_auditrail,atotp_rate_reviewer,atotp_text_direction,atotp_plagiarism_checking,atotp_default_ithapi_folder,atotp_ithsubmission_type,atotp_ithauto_submissions,atotp_change_usr_assigmnts,atotp_auto_assign_role,atotp_posted_by,atotp_posted_date) "
		// 	. "select " . $article_type_id . " ,jset_view_file_inventory,jset_view_email_log,jset_stage_manual_reminder,jset_move_article_from_payment,jset_article_submission_type,jset_paper_length,jset_review_method,jset_review_open_decision,jset_review_open_count,jset_file_type,jset_file_description,jset_custom_classification,jset_cust_secondary_class,jset_secondary_class, jset_min_no_secondary_class, jset_max_no_secondary_class, jset_secondary_class_alias, jset_primary_class, jset_min_no_primary_class, jset_max_no_primary_class, jset_primary_class_alias, jset_classification_hierarchy,jset_min_keyword,jset_max_keyword,jset_user_input_keyword,jset_separate_adhoc_keywords,jset_suggest_reviewers, jset_oppose_reviewers, jset_convert_to_pdf,jset_co_authors_agreement,jset_add_notes,jset_flag_articles,jset_edit_articles,jset_edit_article_files,jset_transfer_article,jset_rescind_article,jset_rescind_review,jset_reset_article,jset_extend_task,jset_edit_reviewer_count,jset_view_auditrail,jset_rate_reviewer,jset_text_direction,jset_plagiarism_checking,jset_default_ithapi_folder,jset_ithsubmission_type,jset_ithauto_submissions,jset_change_usr_assigmnts,jset_auto_assign_role," . $current_user . ",'" . date('Y-m-d H:i:s') . "' from " . $Journal_settings . " where jset_jnl_id=" . $journal_id;
		// jset_view_file_inventory,jset_view_email_log,jset_stage_manual_reminder,jset_move_article_from_payment,jset_separate_adhoc_keywords,jset_add_notes,jset_flag_articles,jset_edit_articles,jset_edit_article_files,jset_transfer_article,jset_rescind_article,jset_rescind_review,jset_reset_article,jset_extend_task,jset_edit_reviewer_count,jset_view_auditrail,jset_rate_reviewer,jset_change_usr_assigmnts,jset_auto_assign_role,atotp_proxy_id
		$return_array['user_roles'] = Article_type_advance_options::get_records_by_raw_query($sql);
		return $return_array;
	}
	public function copy_file_settings($journal_id, $article_type_id, $current_user)
	{
		$Required_file_type_tbl = (new \App\Models\Required_file_type())->getTable();
		$sql = "insert into " . $Required_file_type_tbl . "(rft_jnl_id,rft_artp_id,rft_file_desp_id,rft_req_count,rft_req_fld,rft_sort_order,rft_posted_by,rft_posted_date) "
			. "select " . $journal_id . "," . $article_type_id . " , rft_file_desp_id,rft_req_count,rft_req_fld,rft_sort_order," . $current_user . ",'" . date('Y-m-d H:i:s') . "' from " . $Required_file_type_tbl . " where rft_jnl_id=" . $journal_id . " and rft_artp_id is null";


		$result = Required_file_type::get_records_by_raw_query($sql);
		return $result;
	}
	public function copy_classification($journal_id, $article_type_id, $current_user, $old_article_type_id = NULL)
	{

		$Journal_terms_tbl = (new \App\Models\Journal_terms())->getTable();
		$sql = "insert into " . $Journal_terms_tbl . "(jntm_jnl_id,jntm_term_id,jntm_type,jntm_artp_id,jntm_posted_by,jntm_posted_date,jntm_old_jntm_id) select " . $journal_id . ", jntm_term_id,jntm_type," . $article_type_id . "," . $current_user . ",'" . date('Y-m-d H:i:s') . "',jntm_id  from " . $Journal_terms_tbl  . " where jntm_jnl_id = " . $journal_id;
		if ($old_article_type_id != NULL) {
			$sql .= " and jntm_artp_id = " . $old_article_type_id;
		} else {
			$sql .= " and jntm_artp_id IS NULL";
		}
		$result = Journal_terms::get_records_by_raw_query($sql);
		return $result;
	}
	public function copy_user_jnl_classifications($jnl_id, $id, $current_user, $retired_role_status)
	{
		$User_journal_classifications_tbl = (new \App\Models\User_journal_classifications())->getTable();
		$Journal_terms_tbl = (new \App\Models\Journal_terms())->getTable();

		if ($retired_role_status == "y") {
			$sql = "insert into " . $User_journal_classifications_tbl . "(jucl_usr_id,jucl_jntm_id,jucl_artp_id,jucl_posted_by,jucl_posted_date) select distinct jucl_usr_id,jucl_jntm_id," . $id . "," . $current_user . ",'" . date('Y-m-d H:i:s') . "' from " . $User_journal_classifications_tbl . " join " . $Journal_terms_tbl . " ON   jucl_jntm_id = jntm_id join rvw_user_journals ON usrj_usr_id = jucl_usr_id join rvw_roles ON rvw_roles.role_id = rvw_user_journals.usrj_role_id where rvw_journal_terms.jntm_id =" . $User_journal_classifications_tbl . ".jucl_jntm_id and " . $User_journal_classifications_tbl . ".jucl_jntm_id =  rvw_journal_terms.jntm_id and rvw_journal_terms.jntm_artp_id IS NULL and jntm_jnl_id = " . $jnl_id . " and jucl_artp_id is NULL and usrj_role_retired = 'n'  and role_assigned_role = 'associate_editor' and rvw_user_journals.usrj_jnl_id=" . $jnl_id . " group by jucl_id, rvw_journal_terms.jntm_id,rvw_user_journals.usrj_jnl_id," . $User_journal_classifications_tbl . ".jucl_usr_id";
		} else {
			$sql = "insert into " . $User_journal_classifications_tbl . "(jucl_usr_id,jucl_jntm_id,jucl_artp_id,jucl_posted_by,jucl_posted_date) select jucl_usr_id,jucl_jntm_id," . $id . "," . $current_user . ",'" . date('Y-m-d H:i:s') . "' from " . $User_journal_classifications_tbl . " ," . $Journal_terms_tbl . "  where jucl_jntm_id = jntm_id and jntm_jnl_id = " . $jnl_id . " and jucl_artp_id is NULL group by jucl_id";
		}

		$result = User_journal_classifications::get_records_by_raw_query($sql);


		return $result;
	}
	public function update_user_jnl_classification($id)
	{

		$User_journal_classifications_tbl = (new \App\Models\User_journal_classifications())->getTable();
		$Journal_terms_tbl = (new \App\Models\Journal_terms())->getTable();
		$sql = "Update " . $User_journal_classifications_tbl . " set jucl_jntm_id = (select jntm_id from " . $Journal_terms_tbl . " WHERE jucl_jntm_id = jntm_old_jntm_id ) where jucl_artp_id =" . $id;
		$result = User_journal_classifications::get_records_by_raw_query($sql);

		return $result;
	}
	public function update_user_jnl_classification_article_type($id)
	{
		$User_journal_classifications_tbl = (new \App\Models\User_journal_classifications())->getTable();
		$Journal_terms_tbl = (new \App\Models\Journal_terms())->getTable();

		$sql = "Update " . $User_journal_classifications_tbl . " set jucl_jntm_id = (select jntm_id from " . $Journal_terms_tbl . " WHERE jucl_jntm_id = jntm_old_jntm_id and jntm_artp_id=$id) where jucl_artp_id =" . $id;
		$result = User_journal_classifications::get_records_by_raw_query($sql);

		return $result;
	}
	public function insert_article_flow($jnl_master_id, $master_id, $current_user)
	{

		$generic_flows_tbl = (new \App\Models\Generic_flows())->getTable();

		//		$sql = "insert into " . self::$tbl_name . " (jwf_fwm_id, jwf_stage_code,jwf_stage_name,jwf_stage_type,jwf_stage_description,jwf_ypos,jwf_xpos,jwf_start,jwf_role_id,jwf_parent_stages,jwf_child_stages,jwf_stage_incomplete,jwf_flow_proceed_type,jwf_forms,jwf_posted_date,jwf_posted_by) "
		//			. "select  " . $master_id . ", jwf_stage_code,jwf_stage_name,jwf_stage_type,jwf_stage_description,jwf_ypos,jwf_xpos,jwf_start,jwf_role_id,jwf_parent_stages,jwf_child_stages,jwf_stage_incomplete,jwf_flow_proceed_type,jwf_forms,'" . date('Y-m-d H:i:s') . "'," . $current_user . " from " . self::$tbl_name . " where jwf_fwm_id=" . $jnl_master_id;
		$sql = "insert into " . $generic_flows_tbl . " (jwf_fwm_id,jwf_stage_name,jwf_stage_type,jwf_no_of_min_users,jwf_no_of_max_users,jwf_reviewers_assignment,jwf_reviewers_filltype,jwf_reviewers_discuss_forum,jwf_assignment,jwf_parent_user_roles,jwf_who_can_invite,jwf_avoid_email_notifications_to_roles,jwf_classification_filter,jwf_classification_primary,jwf_classification_secondary,jwf_stage_description,jwf_ypos,jwf_xpos,jwf_start,jwf_role_id,jwf_parent_stages,jwf_child_stages,jwf_stage_incomplete,jwf_flow_proceed_type,jwf_forms,jwf_enable_tat_for_auto_decline,jwf_tat_accept,jwf_tat_complete,jwf_tat_decline,jwf_arrow_begin_with,jwf_posted_date,jwf_posted_by,jwf_temp_id,jwf_tab_name, jwf_status_name, jwf_temporary_status_name, jwf_article_editable, jwf_enable_ithenticate,jwf_confirm_casrai_credits,jwf_confirm_orcid,jwf_enable_popup_after_completion,jwf_button_title,jwf_production_upload,jwf_afdec_ids,jwf_enable_transfer,jwf_resubmission_after_reject,jwf_edit_submission_date,jwf_prevent_edit) "
			. "select  " . $master_id . ", jwf_stage_name,jwf_stage_type,jwf_no_of_min_users,jwf_no_of_max_users,jwf_reviewers_assignment,jwf_reviewers_filltype,jwf_reviewers_discuss_forum,jwf_assignment,jwf_parent_user_roles,jwf_who_can_invite,jwf_avoid_email_notifications_to_roles,jwf_classification_filter,jwf_classification_primary,jwf_classification_secondary,jwf_stage_description,jwf_ypos,jwf_xpos,jwf_start,jwf_role_id,jwf_parent_stages,jwf_child_stages,jwf_stage_incomplete,jwf_flow_proceed_type,jwf_forms,jwf_enable_tat_for_auto_decline,jwf_tat_accept,jwf_tat_complete,jwf_tat_decline,jwf_arrow_begin_with,'" . date('Y-m-d H:i:s') . "'," . $current_user . ",jwf_id, jwf_tab_name, jwf_status_name, jwf_temporary_status_name, jwf_article_editable, jwf_enable_ithenticate,jwf_confirm_casrai_credits,jwf_confirm_orcid,jwf_enable_popup_after_completion,jwf_button_title,jwf_production_upload,jwf_afdec_ids,jwf_enable_transfer,jwf_resubmission_after_reject,jwf_edit_submission_date,jwf_prevent_edit  from " . $generic_flows_tbl . " where jwf_fwm_id=" . $jnl_master_id . " and 	jwf_hide_status='n'";
		
		$result = Generic_flows::get_records_by_raw_query($sql);
		$old_ids = Generic_flows::where('jwf_fwm_id', $jnl_master_id)->where('jwf_hide_status', 'n')->get('jwf_id')->toArray();
		$old_ids = array_column($old_ids, 'jwf_id');
		$new_ids = Generic_flows::where('jwf_fwm_id', $master_id)->get('jwf_id')->toArray();
		$new_ids = array_column($new_ids, 'jwf_id');
		$master_updation_map = array_combine($old_ids, $new_ids);
		if ($master_updation_map) {
			return $master_updation_map;
		} else {
			return FALSE;
		}
	}
	public	function copy_ftp_in_journal_workflow($jnlData, $new_mast_flow_id)
	{

		if (isset($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage) && ($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage == 'y')) {
			$ftp_set_fields = (new \App\Models\Ftp())->getTableColumns();

			$insert_fields = implode(',', $ftp_set_fields);

			$insert_fields = str_replace('ftp_id,', '', $insert_fields);

			$select_fields = implode(',', $ftp_set_fields);
			$select_fields = str_replace('ftp_id,', '', $select_fields);
			$select_fields = str_replace('ftp_posted_by,', '0,', $select_fields);
			$newFtpSettings = Ftp::copy_ftp_journal_workflow($insert_fields, $select_fields, $jnlData);
			$this->update_ftp_option_in_flow_stages($jnlData, $new_mast_flow_id);
		}
	}


	function update_ftp_option_in_flow_stages($jnlData, $new_mast_flow_id)
	{
		$this->current_user = $this->get_current_user_details();
		$condition_flow = "jwf_fwm_id=" . $new_mast_flow_id;
		$work_flows = Generic_flows::get_all_records('*', $condition_flow);
		$temp_wrk_flw_id = '';
		if (!empty($work_flows)) {
			foreach ($work_flows as $work_flow) {
				$temp_wrk_flw_id = $work_flow->jwf_temp_id;
				$new_wrk_flw_id  = $work_flow->jwf_id;
				$condition_update = "ftp_jwf_id=" . $work_flow->jwf_temp_id . " and ftp_posted_by='0'";
				Ftp::update_record(
					array(
						'ftp_jwf_id' => $work_flow->jwf_id
					),
					$condition_update, $this->current_user
				);
			}

		}
	}
	public function updateArticleAdvanceOptions(Request $request)
	{
		try
		{
		$options = $request->all();

		$options['hdn_id']=$this->decrypt_data($options['hdn_id']);

		$this->current_user = $this->get_current_user_details();
		$articles_table=(new \App\Models\Articles())->getTable();
		if ($this->current_client->modules->mdl_review_for_doc == 'y') {
			$options['review_method'] = 'o';
			$options['review_open_decision'] = 'n';
			$options['suggest_reviewer'] = 'n';
			$options['oppose_reviewer'] = 'n';
			$options['min_secondary_class'] = '2';
			$options['max_secondary_class'] = '5';
			$options['alias_secondary_class'] = '';
			$options['co_author_agreement'] = 'n';
		}

		$file_types = '';
		if (isset($options['platform_filetype']) && $options['platform_filetype'] != '') {
			$file_types = json_encode($options['platform_filetype']);
		}

		$file_type_data = '';
		if (isset($options['platform_file_type_data']) && $options['platform_file_type_data'] != '') {
			if(isset($options['hdn_id']))
			{
				$condition = array('artp_id' => $options['hdn_id']);
				$get_editor_options = Article_types::get_single_record_with_bind_cond('artp_es_document_type',$condition);
				if($get_editor_options->artp_es_document_type == 'y')
				{
					$file_desc_collect = collect($options['platform_file_type_data']);
					$file_desc_list = $file_desc_collect->pluck('rft_file_desp_id')->toArray();
					$attach_file_desc = new \App\Models\Attachment_file_description();
					$check_main_documents = $attach_file_desc::whereIn('afdec_id', $file_desc_list)
					->where('afdec_main_document', 'y')
					->count();
					if($check_main_documents == 0)
					{
						$return_arr = array('success' => false,'msg' => customTrans('platform_settings.select_main_document'));
						return $this->failure('Failure', 200, $return_arr);
					}
				}
			}
			$file_type_data = $options['platform_file_type_data'];
		}
		$delete_secondary_cls = TRUE;
		$file_descriptions = '';
		if (isset($options['filedescription']) && $options['filedescription'] != '') {
			$file_descriptions = implode(',', $options['filedescription']);
		}
		$classification_hierarchy = 'n';
		if (isset($options['classification_hierarchy']) && ($options['classification_hierarchy'] != '')) {
			$classification_hierarchy = $options['classification_hierarchy'];
		}
		$secondary_count = 'n';
		if (isset($options['secondary_class_count']) && ($options['secondary_class_count'] != '')) {
			$secondary_count = $options['secondary_class_count'];
		}
		$custprimaryclss = 'n';
		if (isset($options['platform_custom_classification']) && ($options['platform_custom_classification'] != '')) {
			$custprimaryclss = $options['platform_custom_classification'];
			if ($options['platform_classification'] == 'y') {
				$classification_hierarchy = 'n';
			}
		}
		$ith_v2 = FALSE;
		if(isset($this->current_client->functionality->cfty_ithenticate_v2) && isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y'  && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
		{
			$ith_v2 = TRUE;
		}

		$custsecondaryclss = 'n';
		// Task #3022 Remove ‘abstract’ field’ in article submission page
		$remove_abstract_submission=false;
		$proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
		if(!empty($proceedingArr)) {
			$remove_abstract_submission=isset($proceedingArr['remove_abstract_submission'])?$proceedingArr['remove_abstract_submission']:false;
		}
		$paper_length=0;
		if($remove_abstract_submission===false){
			$paper_length=$options['platform_paper_length'];
		}
		$article_submission_type = array();
		if (isset($options['platform_article_submission_type']) && ($options['platform_article_submission_type'] != '')) {
			$article_submission_type = json_encode($options['platform_article_submission_type']);
		}
		$review_open_count = 0;
		if (isset($options['platform_review_open_decision']) && $options['platform_review_open_decision'] == 'y')
			$review_open_count = $options['review_open_count'];
		if ($options !== FALSE) {
			$conAtypeSettings="atotp_artp_id='{$options['hdn_id']}'";
			$old_artp_settings = Article_type_advance_options::get_single_record('*',$conAtypeSettings);

			$plagiarism_checking = isset($options['platform_plagiarism_checking']) ? $options['platform_plagiarism_checking'] : 'n';
			$default_ithapi_folder = (isset($options['platform_default_ithapi_folder']) && $ith_v2 == FALSE) ? $options['platform_default_ithapi_folder'] : '';
			$ithsubmission_type = isset($options['platform_ithsubmission_type']) ? $options['platform_ithsubmission_type'] : '';
			$ithauto_submissions = isset($options['platform_ithauto_submissions']) ? json_encode($options['platform_ithauto_submissions']) : NULL;
			$separate_adhoc_keywords = isset($options['platform_separate_adhoc_keywords']) ? $options['platform_separate_adhoc_keywords'] : 'n';
			// Task #925 research integrity checking
			$research_integrity_checking = isset($options['platform_research_integrity_checking']) ? $options['platform_research_integrity_checking'] : 'n';
			$rvrisubmission_type = isset($options['platform_rvri_type']) ? $options['platform_rvri_type'] : '';
			$rvriauto_submissions = isset($options['platform_rvriauto_submissions']) ? json_encode($options['platform_rvriauto_submissions']) : NULL;
			
			$new_data = array(
				// 'atotp_artp_id' => $options['hdn_id'],
				'atotp_file_type' => $file_types,
				'atotp_file_description' => $file_descriptions,
				'atotp_article_submission_type' => $article_submission_type,
				//'atotp_submission_editor' => $article_format_editor,
				'atotp_paper_length' => $paper_length,
				'atotp_title_length' => $options['platform_title_length'], //dynamic validation for article title characters
				'atotp_review_method' => $options['platform_review_method'],
				'atotp_custom_blind_params' => $options['platform_review_method'] == 'c' ? $options['custom_blind_params'] : null,
				'atotp_review_open_decision' => $options['platform_review_open_decision'],
				'atotp_review_open_count' => $review_open_count,
				//'atotp_submission_upload' => $article_format_upload,
				'atotp_custom_classification' => $custprimaryclss,
				// 'atotp_cust_secondary_class' => $custsecondaryclss,
				// 'atotp_secondary_class' => $secondary_count,
				// 'atotp_min_no_secondary_class' => $options['platform_secondary_class_minimum'],
				// 'atotp_max_no_secondary_class' => $options['platform_secondary_class_maximum'],
				// 'atotp_secondary_class_alias' => $options['title_secondary_classification'],
			//	'atotp_classification' => $options['platform_classification'],
			//	'atotp_classification_title' => $options['platform_classification_title'],
				// 'atotp_min_no_primary_class' => $options['platform_primary_class_minimum'],
				// 'atotp_max_no_primary_class' => $options['platform_primary_class_maximum'],
				// 'atotp_primary_class_alias' => $options['title_primary_classification'],
				// 'atotp_classification_hierarchy' => $classification_hierarchy,
				'atotp_suggest_reviewers' => $options['platform_suggest_reviewer'],
				'atotp_suggest_reviewers_mandatory' => $options['platform_suggest_reviewers_mandatory'],
				'atotp_oppose_reviewers' => $options['platform_oppose_reviewer'],
				'atotp_oppose_reviewers_mandatory' => $options['platform_oppose_reviewers_mandatory'],
				// 'atotp_min_keyword' => $options['platform_secondary_class_minimum'],
				// 'atotp_max_keyword' => $options['platform_secondary_class_maximum'],
				'atotp_user_input_keyword' => isset($options['platform_adhoc_keyword'])?$options['platform_adhoc_keyword']:"",
				'atotp_separate_adhoc_keywords' => $separate_adhoc_keywords,
				//'atotp_reviewer_cmt_to_author' => $options['reviewer_cmt_to_author'],
				'atotp_co_authors_agreement' => $options['platform_co_author_agreement'],
				'atotp_plagiarism_checking' => $plagiarism_checking,
				'atotp_default_ithapi_folder' => $default_ithapi_folder,
				'atotp_ithsubmission_type' => $ithsubmission_type,
				'atotp_ithauto_submissions' => $ithauto_submissions,
				// Task #925 atotp_research_integrity
				'atotp_research_integrity' => $research_integrity_checking,
				'atotp_rvrisubmission_type' => $rvrisubmission_type,
				'atotp_rvriauto_submissions' => $rvriauto_submissions,
				// TASK BOlt 90  Restrict Authors from Viewing Reviewers' Comments
				'atotp_author_viewable_content' => (isset($options['author_viewablecontent']) && $options['author_viewablecontent']=='y')?$options['author_viewablecontent']:'n',
			);
			if ($this->current_client->modules->mdl_textdirection == 'y') {
				$new_data['atotp_text_direction'] = $options['text_direction'];
			}

			if($ith_v2 == TRUE)
			{
				if(isset($options['ithv2_viewsettings']))
					$new_data['atotp_ith_v2_view_settings'] = json_encode($options['ithv2_viewsettings']);
				if(isset($options['ithv2_add_to_index']))
					$new_data['atotp_ith_v2_add_to_index'] = json_encode($options['ithv2_add_to_index']);
				if(isset($options['ithv2_save_changes']))
					$new_data['atotp_ith_v2_save_changes'] = json_encode($options['ithv2_save_changes']);
				
				//Task 7850  iThenticate v2 enhancement
				//$new_data['atotp_eula'] = isset($options['ith_v2_eula']) && $options['ith_v2_eula']?'y':'n';
			}


			// if (isset($old_artp_settings->atotp_classification_hierarchy))
			// if (($old_artp_settings->atotp_classification_hierarchy == 'y' && $new_data['atotp_classification_hierarchy'] == 'n') || ($old_artp_settings->atotp_classification_hierarchy == 'n' && $new_data['atotp_classification_hierarchy'] == 'y') || ($old_artp_settings->atotp_secondary_class == 'y' && $new_data['atotp_secondary_class'] == 'n')) {
			// 	$join_tables = array(
			// 		'main_table' => $article_secondary_classification_table,
			// 		'join_table' => array(
			// 			$articles_table => array($article_secondary_classification_table.'.ats_art_id',$articles_table.'.art_id')
			// 		)
			// 	);

			// 	$select = 'count(ats_id) as cnt';
			// 	$criteria = 'art_artp_id = '.$options['hdn_id'];
			// 	$article_sec_class = Article_secondary_classification::get_results_using_joins($join_tables, $select, $criteria,'all', NULL, NULL, '', NULL, NULL, TRUE);
			// 	if ($article_sec_class[0]->cnt > 0) {
			// 		$delete_secondary_cls = FALSE;
			// 	}
			// }
			if ($delete_secondary_cls == FALSE) {
				return $this->warning('Failure',  500);
			} else {
				// Article_type_advance_options::trans_start();
				$conadvoptions="atotp_artp_id='{$options['hdn_id']}'";

				$result = Article_type_advance_options::update_record($new_data,$conadvoptions, $this->current_user);

				if (!empty($file_type_data)) {
					$where_desp = 'rft_jnl_id=' . $options['platform_id'] . ' and rft_artp_id=' . $options['hdn_id'];
					Required_file_type::delete_records($where_desp, '', $this->current_user);
					$desp_arr = array();
					foreach ($file_type_data as $ft) {
						$desp_data = array();
						$desp_data['rft_file_desp_id'] = $ft['rft_file_desp_id'];
						$desp_data['rft_req_count'] = $ft['rft_req_count'];
						//#2982 The system should automatically sort out all the uploaded files by Main doc, Figures, and then tables In Progress
						if (isset($this->current_client->functionality->cfty_sort_order_for_author_submission_uploads) && $this->current_client->functionality->cfty_sort_order_for_author_submission_uploads == 'y')
							$desp_data['rft_sort_order'] = $ft['rft_sort_order'];
						else
							$desp_data['rft_sort_order'] = 0;
						$desp_data['rft_req_fld'] = 'n';
						if ($ft['rft_req_fld'] == 'y')
							$desp_data['rft_req_fld'] = 'y';
						$desp_data['rft_jnl_id'] = $options['platform_id'];
						$desp_data['rft_artp_id'] = $options['hdn_id'];
						array_push($desp_arr, $desp_data);
					}
				Required_file_type::insert_batch($desp_arr);
				}


				if ($result) {

					// if($old_artp_settings){
					// if (
					// 	($old_artp_settings->atotp_classification_hierarchy == 'y' && $new_data['atotp_classification_hierarchy'] == 'n') || ($old_artp_settings->atotp_classification_hierarchy == 'n' && $new_data['atotp_classification_hierarchy'] == 'y'
					// 	) || ($old_artp_settings->atotp_secondary_class == 'y' && $new_data['atotp_secondary_class'] == 'n'
					// 	)
					// ) { //HIERARCHY CHECKING OR //SECONDARY CHECKING
					// 	//delete secondary added user classification (update secondary as null)
					// 	// User_journal_classifications::delete_classification_user($options['hdn_id'], 's', 'a'); //todo



					// 	//delete secondary area
					// 	$sec_con="jntm_artp_id={$options['hdn_id']} and jntm_type='s'";
					// 	Journal_terms::delete_records($sec_con, '', $this->current_user);
					// }

					// if ($old_artp_settings->atotp_primary_class == 'y' && $new_data['atotp_primary_class'] == 'n') { //PRIMARY CHECKING
					// 	//delete secondary added user classification
					// 	$class_con="jucl_artp_id={$options['hdn_id']}";
					// 	User_journal_classifications::delete_records($class_con, '', $this->current_user);

					// 	//delete primary area
					// 	$term_con="jntm_artp_id={$options['hdn_id']} and jntm_type='p'";
					// 	Journal_terms::delete_records($term_con, '', $this->current_user);
					// }
				// }
				}
///commented for trasaction is not working
				// if (Article_type_advance_options::trans_complete() === FALSE) {
				// 	echo json_encode(array(
				// 		'status' => 'failed',
				// 		'msg' => lang('cmn_db_error')
				// 	));
				// } else {
					//pass artp settings for switching
					$return_array=array(
						'status' => 'update_success',
						'msg' => customTrans('platform_settings.article_type_settings_msg'),
						'review_open_count' => $review_open_count,
						'secondary' => $secondary_count,
						'primary' => $options['platform_classification'],
						'hierarchy' => $classification_hierarchy,
						'plagiarism_checking' => $plagiarism_checking,
						'ithsubmission_type' => $ithsubmission_type,
						// Task #925 research_integrity_checking
						'research_integrity_checking' => $research_integrity_checking,
					);
				return $this->success('update', 200,$return_array);
				// }
			}
		} else {
			return $this->warning('Failure',  500);
		}
	} catch (\Exception $e) {

		// DB::rollback();
		return $this->failure('Failure', 500, $e);
	}
	}

	public function deleteArticleType(Request $request)
	{

		try {
			$formdata = $request->all();

			$this->current_user = $this->get_current_user_details();
			$articletyp_id = $formdata["article_id"];
			$jnlcode=$formdata["jnlcode"];
			$criteria = "jnl_journal_code='{$jnlcode}'";
			$jounal_data = Journals::get_single_record('*', $criteria);

			if (isset($articletyp_id) && $articletyp_id != "") {
				//load model
				$articletyp_id = $this->decrypt_data($articletyp_id);
				$artTypeCondition="art_artp_id='{$articletyp_id}'";
				$chk_avl_article_type = Articles::get_single_record("count(*) count",$artTypeCondition);
				if ($chk_avl_article_type->count > 0) {
					$return_array=array(
						"status" => "article_type_avl",
						"msg" => customTrans('platform_settings.article_type_error')
					);
					return $this->warning('Warnings',200,$return_array,'warning');
				} else {
					$condition="artp_id='{$articletyp_id}'";

					$artp_data = Article_types::get_single_record("artp_fwm_id,artp_jnl_id",$condition);
					$use_journal_workflow_flag = FALSE;

					//1.Task #4768 Article types use journal workflow
					if ($jounal_data->jnl_fwm_id == $artp_data->artp_fwm_id) {
							$use_journal_workflow_flag = TRUE;
						}
					$journalterms = Journal_terms::get_articletype_term($articletyp_id);

					/*
		$sql = "SELECT count(aflw_id) as aflw_count FROM `rvw_article_flow` WHERE `aflw_jwf_id` IN (SELECT jwf_id FROM `rvw_journal_workflows` WHERE `jwf_fwm_id` = $artp_data->artp_fwm_id) AND aflw_art_id NOT IN (SELECT art_id from `rvw_articles` where `art_artp_id` = $articletyp_id)";
		$flow_count = $this->Article_flow->get_records_by_raw_query($sql);
		*/

					//Task #4768 Article types use journal workflow

					$active_arts = Articles::get_single_record('count(art_id) as cnt', $artTypeCondition);

					$trans_cnd = ' (ats_src_artp = ' . $articletyp_id . ' OR ats_dst_artp = ' . $articletyp_id . ') AND ats_author_action = \'1\'';
					$transfer_artps = Article_transfer_suggestion::get_single_record('count(ats_id) as cnt', $trans_cnd);

					//if ($flow_count[0]->aflw_count > 0) {
					if ($active_arts->cnt > 0 || $transfer_artps->cnt > 0) {
							$returndata=array(
								"status" => "article_type_avl",
								"msg" => customTrans('platform_settings.article_type_trans_error')
							);
							return $this->warning('Failure', 500, $returndata);
						} else {
						// Article_type_advance_options::trans_start();

						$adv_condition="atotp_artp_id ='{$articletyp_id}'";

						//Delete article type from advanced options record
						Article_type_advance_options::delete_records($adv_condition, '', $this->current_user);

						$class_condition="jucl_artp_id = '{$articletyp_id}'";
						User_journal_classifications::delete_records($class_condition, '', $this->current_user);
						$artp_data->artp_jnl_id;
						// Journal_terms::delete_journal_terms($artp_data->artp_jnl_id, $articletyp_id);
						$termids = array();
						//Fixed for demo
						//				if ($journalterms != NULL)
						//				{
						//					foreach ($journalterms as $value)
						//					{
						//						$termids[] = $value->jntm_term_id;
						//					}
						//					$this->Terms->delete_terms($termids);
						//				}
						$del_condition="usrj_artp_id='{$articletyp_id}'";
						User_to_journals::delete_records($del_condition, '', $this->current_user);

						//delete article type
						$del_atype_condition="artp_id='{$articletyp_id}'";
						Article_types::delete_records($del_atype_condition, '', $this->current_user);

						//Task #4768 Article types use journal workflow
						// if ($use_journal_workflow_flag == FALSE) {   //todo
						// 		//task#669-Flow based FTP export deleate all ftp based on the deleting article type
						// 		$this->delete_article_type_ftp($artp_data);

						// 		//delete moster flow id
						// 		$flow_condition="fwm_id='{$artp_data->artp_fwm_id}'";
						// 		Flow_master::delete_records($flow_condition, '', $this->current_user);
						// 	}
						$getatype_condition="artp_jnl_id='{$jounal_data->jnl_id}'";
						$get_all_article_types = Article_types::get_single_record('count(artp_id) as type_count', $getatype_condition);
						$count_ext_art_type = $get_all_article_types->type_count;
						// if (Article_type_advance_options::trans_complete() === FALSE) {    //////todo

							// $return_data=array(
							// 	"status" => "failed",
							// 	"msg" => lang('article_type_dele_failed')
							// );
							// return $this->failure('Failure', $return_data, 500);

						// } else {
							//					$get_all_article_types = $this->Article_types->get_all_records();
							//
							//					$count_ext_art_type = count($get_all_article_types);
							$returnvalue=array(
								"status" => "success",
								"result" => $count_ext_art_type,
								'msg' => customTrans('platform_settings.article_type_del_success')
								// 'redirectTo'=>'platform/'.$jnlcode.'/article-types'
							);
							// return $this->success('update', 200, $returnvalue);
							return $this->success("Success", 200, $returnvalue);

						// }
					}
				}
			} else {
				return $this->warning('Failure', 500, customTrans('platform_settings.article_type_dele_failed'));
			}
		} catch (\Exception $e) {
			return $this->failure('Failure', 500, $e);
		}
	}
	// public function delete_article_type_ftp($artp_data)
	// {
	// 	if (isset($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage) && ($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage == 'y')) {

	// 		Ftp::delete_article_type_ftp($artp_data);
	// 	}
	// }
	 //create workflow for articletype
	 public function create_articletype_workflow(Request $request)
	 {
		 try{

			 $return_arr = array(
				 'status' => 'failed',
				 'status_txt' => 'Sorry'
			 );
			 $post_data = $request->all();
			 $artp_id = $post_data['art_id'];
			 $this->current_user = $this->get_current_user_details();
			 DB::beginTransaction();
			 if($artp_id != '')
			 {
				 $artp_id = $this->decrypt_data($artp_id);

				 $existcount="art_artp_id='{$artp_id}'";
				 $article_exist = Articles::get_single_record('count(art_id) as cnt',$existcount);

				 $select = 'jnl_id,artp_fwm_id,jnl_fwm_id,artp_article_type';
				 $article_types_table = (new \App\Models\Article_types())->getTable();
				 $journals_table = (new \App\Models\Journals())->getTable();
				 $join_tables = array(
					 'main_table' => $article_types_table,
					 'join_table' => array(
						 $journals_table => array($article_types_table . '.artp_jnl_id', $journals_table . '.jnl_id', "left")
					 )
				 );
				 $join_criteria ="artp_id='{$artp_id}'";
				 $completed_stage = Article_types::get_results_using_joins($join_tables,$select,$join_criteria);
				 $allow_copy_flw_with_existing_articles = in_array("sudo", $this->current_user['roles']) ? true : false; 
				 if(!empty($article_exist) && !empty($completed_stage) && ($article_exist->cnt == 0 || $allow_copy_flw_with_existing_articles) && $completed_stage[0]->artp_fwm_id == $completed_stage[0]->jnl_fwm_id)
				 {
					 $article_type_desc = 'Flow of ' . $completed_stage[0]->artp_article_type;

					//  Generic_flows::trans_start();
					 //for getting master flow  id
					 $mast_flow_id = Flow_master::insert_record(array(
							 'fwm_description' => $article_type_desc
						 ), $this->current_user);

					 $this->copy_journal_workflow($completed_stage[0]->jnl_id,$completed_stage[0]->jnl_fwm_id,$mast_flow_id, $artp_id);

					 Article_types::update_record(array(
						 'artp_fwm_id' => $mast_flow_id
					 ),$join_criteria,$this->current_user);
					//  if (Generic_flows::trans_complete() === TRUE)
					//  {
						 $return_arr['status'] = 'success';
						 $return_arr['status_txt'] = 'Success';
					//  }
					//  else
					//  {
					// 	 $return_arr['msg'] = lang('processing_error');
					//  }
				 }
				 elseif(!empty($article_exist) && $article_exist->cnt > 0)
				 {
					 $return_arr['msg'] = customTrans('platform_settings.article_exist_workflow');
					//  $return_arr['msg'] = lang('article_exist_workflow');
					 $return_arr['status_txt'] = 'Warning';
				 }
				 elseif(!empty($completed_stage) && $completed_stage[0]->artp_fwm_id != $completed_stage[0]->jnl_fwm_id)
				 {
					 $return_arr['msg'] = customTrans('platform_settings.already_workflow_exist');
					 $return_arr['status_txt'] = 'Warning';
				 }

			 }
			 else
			 {
				 $return_arr['msg'] =customTrans('platform_settings.processing_error');
			 }
			 DB::commit();
		 return $this->success('check stage name',200,$return_arr);
	 } catch (Exception $e) {
		DB::rollBack();
		 return $this->failure('Failed', 500, $e);
	 }
	 }



	 public function save_article_type_copy(Request $request)
	{
		try{
		$article_type = $request->all();
		$this->current_user = $this->get_current_user_details();
		$article_type_id = decrypt_link($article_type['article_type_id']);
		$old_flow_master_id = '';
		$atype_con="artp_id='{$article_type_id}'";
		$artcle_type_details = Article_types::get_single_record('artp_id,artp_abbr_article_type,artp_description,artp_login_user_type,artp_fwm_id,artp_jpm_id', $atype_con);

		if (isset($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers) && ($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers == 'y')) 
		{
			$old_flow_master_id = isset($artcle_type_details->artp_fwm_id) ? $artcle_type_details->artp_fwm_id : '';
		}
		if (empty($artcle_type_details)) {
			$return_array=array(
				"status" => "failed",
				"msg" => customTrans('platform_settings.arttypenotfound')
			);
			return $this->warning('Warnings',200,$return_array,'warning');
		}

	
		$validator = Validator::make($request->all(), [
			'article_type_code' => 'required',
			'article_type' => 'required',
			'submission_type'   => 'required',
			'revision_id_postion' => 'required',
			'prefix' => 'required',
			'type_format' => 'required',
		]);
		if ($validator->fails()) {
			return  $this->failure('Failed', 422, $validator->errors());
		}

		if ($this->current_client->modules->mdl_review_for_doc == 'y') {
			$article_type['chk_submission_type'] = array('0' => 'a');
			$article_type['special_issue'] = 'n';
		}
		 else {
			if ($article_type != FALSE) {
				$jnl_id = $article_type['jnl_id'];
				$abbr=$article_type['article_type_code'];
				$platform_es_checking = isset($article_type['platform_es_checking']) ? $article_type['platform_es_checking'] : 'n';
				$atype_uni_con="artp_abbr_article_type='{$abbr}' and artp_jnl_id='{$jnl_id}'";
				$get_uni_article_type = Article_types::get_single_record('*',$atype_uni_con);
				//to check article type title in db
				$title=$article_type['article_type'];
				$atype_uni_title_con="artp_article_type='{$title}' and artp_jnl_id='{$jnl_id}'";
				$get_uni_article_type_title = Article_types::get_single_record('*', $atype_uni_title_con);

				//save details
				if ($get_uni_article_type == NULL && $get_uni_article_type_title == NULL) {
					$replace_str = array(
						'"',
						"'"
					);
					$article_prefix = str_replace($replace_str, '', $article_type['prefix']);
					$article_suffix = str_replace($replace_str, '', $article_type['type_format']);
			
					$data = array(
						'artp_article_type' => $article_type['article_type'],
						'artp_abbr_article_type' => $article_type['article_type_code'],
						'artp_login_user_type' => json_encode($article_type['submission_type']),
						'artp_jnl_id' => $jnl_id,
						'artp_prefix_article_no' => $article_prefix,
						'artp_suffix' => $article_suffix,
						//'artp_postfix_article_no_length' => $article_type['postfixno'],
						'artp_description' => $article_type['articletype_description'],
						'artp_palette_color_code' => $article_type['choose_color'],
						'artp_revision_id_postion' => $article_type['revision_id_postion'],
						'artp_es_document_type'=>$platform_es_checking
					);

					//* start -- special issue*//
					$date_error_msg = '';
					if ($this->current_client->functionality->cfty_enable_issue_inarticletype == 'y') {

						if(isset($article_type['disable_check_issue']) && $article_type['disable_check_issue'] == false)
						{

							$data['artp_special_issue'] = isset($article_type['special_issue']) ? $article_type['special_issue'] : 'n';
							if (isset($article_type['special_issue']) && $article_type['special_issue'] == 'y') {
								$responseArr = $article_type['parent_article_type'];
								$parentids = implode(',', $responseArr);
								$data['artp_parent_artp_id'] = $parentids;
								$date_format=$this->get_platform_date_format($jnl_id);
								$data['artp_start_date'] = convert_dmy_to_ymd($article_type['hdn_start_date'], $date_format);
								$data['artp_soft_enddate'] = convert_dmy_to_ymd($article_type['hdn_soft_enddate'], $date_format);
								$data['artp_hard_enddate'] = convert_dmy_to_ymd($article_type['hdn_hard_enddate'], $date_format);
								$data['artp_production_deadline'] = convert_dmy_to_ymd($article_type['hdn_prdn_deadline'], $date_format);
								if (date($data['artp_hard_enddate']) < date($data['artp_soft_enddate']) || date($data['artp_hard_enddate']) < date($data['artp_start_date']) || date($data['artp_soft_enddate']) < date($data['artp_start_date']))
									$date_error_msg = $date_error_msg . 'Please check special issue dates';
								elseif (date($data['artp_production_deadline']) <= date($data['artp_hard_enddate']) || date($data['artp_production_deadline']) <= date($data['artp_soft_enddate']) || date($data['artp_production_deadline']) <= date($data['artp_start_date']))
									$date_error_msg = $date_error_msg . 'Please check production deadline';
							}else{
								$data['artp_parent_artp_id'] = NULL;
								$data['artp_start_date'] = NULL;
								$data['artp_soft_enddate'] = NULL;
								$data['artp_hard_enddate'] = NULL;
								$data['artp_production_deadline'] = NULL;
								$data['artp_special_issue'] ='n';
							}
						}

					}else{
						$data['artp_parent_artp_id'] = NULL;
						$data['artp_start_date'] = NULL;
						$data['artp_soft_enddate'] = NULL;
						$data['artp_hard_enddate'] = NULL;
						$data['artp_production_deadline'] = NULL;
						$data['artp_special_issue'] ='n';
						}
						if($date_error_msg != '')
						{
							$return_array['status'] = 'failed';
							$return_array['msg'] = $date_error_msg;
							return $this->warning('Failed',200, $return_array);
						}
		
						$where_cnd = 'jnl_id = ' . $jnl_id;
						$jnl_data = Journals::get_single_record('*', $where_cnd);

						if(isset($article_type['use_workflow']) && $article_type['use_workflow'] == 'j')
						{
							$mast_flow_id = $jnl_data->jnl_fwm_id;
						}
						else
						{
							$article_type_desc = 'Flow of ' . $data['artp_article_type'];
							//for getting master flow  id
							$mast_flow_id = Flow_master::insert_record(array(
								'fwm_description' => $article_type_desc
							), $this->current_user);
						}

						$data['artp_fwm_id'] = $mast_flow_id;

						if (isset($article_type['use_journal_permissions']) && $article_type['use_journal_permissions'] == 'y') {
							$mast_permission_id = $jnl_data->jnl_jpm_id;
						} else {
							if($jnl_data->jnl_jpm_id==$artcle_type_details->artp_jpm_id)
							{
								$mast_permission_id = $jnl_data->jnl_jpm_id;
							}else{
							$use_jnl_permissions = FALSE;
							$Permission_desc = 'Permission of ' . $data['artp_article_type'];

							$mast_permission_id = Journal_permission_master::insert_record(array(
								'jpm_description' => $Permission_desc
							), $this->current_user);

						$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
						if((isset($article_type['arttp_section']) && in_array('arttp_permissions', $article_type['arttp_section'])))
						{

							//copy journal permissions
							$sql = "insert into " . $journal_permission_table . " (jp_jpm_id,jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_forms,jp_edit_article_files,
							jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
							jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_suspecious_activity,jp_prevent_edit,jp_rate_reviewer,jp_blind_articles,jp_download_review,jp_request_rescind,jp_posted_by
							)"
							. "select " . $mast_permission_id . ",jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_forms,jp_edit_article_files,
							jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
							jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_suspecious_activity,jp_prevent_edit,jp_rate_reviewer,jp_blind_articles,jp_download_review,jp_request_rescind,jp_posted_by from " . $journal_permission_table . " where jp_jpm_id=" . $artcle_type_details->artp_jpm_id;
							DB::select($sql);
						}else{


						$permission_setting_data=array();
						$role_id_perm = array();
						$permission_setting_data["jp_add_notes"]=json_encode($role_id_perm);
						if ($this->current_client->modules->mdl_review_for_doc == 'n') {
							$role_table = (new \App\Models\Roles())->getTable();
							$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
							$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";
							$previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
							$user_roles = Roles::get_records_by_raw_query($previleged_sql);
							if(!empty($user_roles))
							{
								foreach ($user_roles as $val) {
									if ($val->role_assigned_role == 'journal_admin' || $val->role_assigned_role == 'staff') {
										$role_id_perm[] = "$val->role_id";
									}

								}
								//$permission_setting_data["jp_add_notes"]=json_encode($role_id_perm);
							}

						}
						$permission_setting_data["jp_jpm_id"]=$mast_permission_id;
						Journal_permission::insert_record($permission_setting_data, $this->current_user);

						}


						// 	$permission_setting_data=array();

						// $permission_setting_data["jp_jpm_id"]=$mast_permission_id;
						// Journal_permission::insert_record($permission_setting_data, $this->current_user);

						}
						}
						$data['artp_jpm_id'] = $mast_permission_id;




						/* insert article type */
						$id = Article_types::insert_record($data, $this->current_user);
						$adv_con="atotp_artp_id='{$article_type_id}'";
						/* Start -  Copy Advance options */
						$advanced_options = Article_type_advance_options::get_single_record('*', $adv_con);

						unset($advanced_options->atotp_id);
						unset($advanced_options->atotp_artp_id);
						unset($advanced_options->atotp_posted_by);
						unset($advanced_options->atotp_posted_date);
						unset($advanced_options->atotp_proxy_id);
						unset($advanced_options->atotp_operation);

						// Article type copying based on section checkout-- Advanced settings
						$advanced_option_fields = $advanced_options_insert = array();
						if(isset($article_type['arttp_section']) && !empty($article_type['arttp_section']))
						{
							if (!in_array('arttp_setting', $article_type['arttp_section']))
							{
								$advanced_option_fields = array(
									'atotp_file_type',
									'atotp_paper_length',
									'atotp_review_method',
									'atotp_review_open_decision',
									'atotp_review_open_count',
									'atotp_file_description',
									'atotp_min_keyword',
									'atotp_max_keyword',
									'atotp_user_input_keyword',
									'atotp_separate_adhoc_keywords',
									'atotp_suggest_reviewers',
									'atotp_suggest_reviewers_mandatory',
									'atotp_oppose_reviewers',
									'atotp_oppose_reviewers_mandatory',
									'atotp_ithauto_submissions',
									'atotp_ithsubmission_type',
									'atotp_plagiarism_checking',
									'atotp_co_authors_agreement',
									'atotp_title_length',
									// Task #925  atotp_research_integrity
									'atotp_research_integrity',
									'atotp_rvriauto_submissions',
									'atotp_rvrisubmission_type'
								);
							}

							if (!in_array('arttp_classification', $article_type['arttp_section']))
							{
								array_push(
									$advanced_option_fields,
									// 'atotp_secondary_class',
									'atotp_custom_classification',
									// 'atotp_cust_secondary_class',
									// 'atotp_min_no_secondary_class',
									// 'atotp_max_no_secondary_class',
									// 'atotp_secondary_class_alias',
									'atotp_classification',
									// 'atotp_min_no_primary_class',
									// 'atotp_max_no_primary_class',
									// 'atotp_primary_class_alias',
									// 'atotp_classification_hierarchy'
								);
							}

							if (!in_array('arttp_permissions', $article_type['arttp_section']))
							{
								array_push(
									$advanced_option_fields,
									'atotp_add_notes',
									'atotp_flag_articles',
									'atotp_edit_articles',
									'atotp_edit_article_files',
									'atotp_transfer_article',
									'atotp_rescind_article',
									'atotp_rescind_review',
									'atotp_reset_article',
									'atotp_extend_task',
									'atotp_edit_reviewer_count',
									'atotp_manage_article',
									'atotp_edit_user_details',
									'atotp_add_user_note',
									'atotp_add_user_attachemnts',
									'atotp_user_flags',
									'atotp_change_user_status',
									'atotp_view_auditrail',
									'atotp_change_usr_assigmnts',
									'atotp_move_article_from_payment',
									'atotp_rate_reviewer',
									'atotp_view_email_log',
									'atotp_stage_manual_reminder',
									'atotp_auto_assign_role'
								);
								// = array_merge($advanced_option_fields, $field_set_permissn);
							}

							if (!empty($advanced_option_fields)) {
								foreach ($advanced_option_fields as $field) {
									unset($advanced_options->$field);
								}
							}
						}

						$advanced_options->atotp_artp_id = $id;
						$advanced_options_insert = json_decode(json_encode($advanced_options), TRUE);
						$jnl_con="jset_jnl_id='{$jnl_data->jnl_id}'";
						$jnl_adv_opts =Journal_settings::get_single_record('*',$jnl_con);

						if((!isset($article_type['arttp_section'])) || (isset($article_type['arttp_section']) && !in_array('arttp_setting', $article_type['arttp_section'])))
						{
							if(!isset($article_type['arttp_section']))
							{
								//in the case of no setting opted then optimal settings for databse copied from journal settings
								$advanced_options_insert = array();
								$advanced_options_insert['atotp_artp_id'] = $id;
							}

							$advanced_options_insert['atotp_review_method'] = $jnl_adv_opts->jset_review_method;
							$advanced_options_insert['atotp_review_open_count']= $jnl_adv_opts->jset_review_open_count;
							$advanced_options_insert['atotp_custom_classification']= $jnl_adv_opts->jset_custom_classification;
			
							$advanced_options_insert['atotp_min_keyword'] = $jnl_adv_opts->jset_min_keyword;
							$advanced_options_insert['atotp_max_keyword']= $jnl_adv_opts->jset_max_keyword;
							$advanced_options_insert['atotp_text_direction']= $jnl_adv_opts->jset_text_direction;
							$advanced_options_insert['atotp_default_ithapi_folder']= $jnl_adv_opts->jset_default_ithapi_folder;
							$advanced_options_insert['atotp_ithsubmission_type']= $jnl_adv_opts->jset_ithsubmission_type;
							$advanced_options_insert['atotp_rvrisubmission_type']= $jnl_adv_opts->jset_rvrisubmission_type;
						}

						Article_type_advance_options::insert_record($advanced_options_insert, $this->current_user);

						/* End -  Copy Advance options */
						//if ((isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_setting', $article_type['arttp_section'])) ||  empty($article_type['arttp_section']))
						if(isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_setting', $article_type['arttp_section']))
						{
							$this->copy_credential_ithenticate_articletype($id, $article_type_id);
							$this->copy_article_type_description($id, $article_type_id);
						}

/* Start - Copy Classifications */
						//if ((isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_classification', $article_type['arttp_section'])) ||  empty($article_type['arttp_section']))
						if(isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_classification', $article_type['arttp_section']))
						{
							//if ($advanced_options->atotp_classification_hierarchy === 'n') {
								if ($advanced_options->atotp_classification === 'n') {
								//todo
								$this->copy_classification($jnl_id, $id, $this->current_user['user_id'], $article_type_id);
							} elseif ($advanced_options->atotp_classification === 'y') {
								$trm_con="cls_jnl_id='{$jnl_id}' and cls_artp_id='{$article_type_id}' ";
								$get_classification_primary = Classifications::get_all_records('*', $trm_con);
								if (!empty($get_classification_primary)) {
									foreach ($get_classification_primary as $jnl_primary) {
										$primary_array['cls_term_id'] = $jnl_primary->cls_term_id;
										$primary_array['cls_artp_id'] = $id;
										$primary_array['cls_jnl_id'] = $jnl_id;
										$primary_array['cls_primary_id'] = $jnl_primary->cls_primary_id;
										$primary_array['cls_old_cls_id'] = $jnl_primary->cls_id;
										//insert primary
										$new_primary_id = Classifications::insert_record($primary_array, $this->current_user);
										//direct insert secondary
										// if ($advanced_options->atotp_secondary_class === 'y') {
											// Classifications::copy_secondary($new_primary_id, $jnl_primary->cls_id, $id, $this->current_user['user_id']);
										// }
									}
								}
							}
							/* ADD user_journal_classifications to article type */
							$fetch_con="cls_artp_id='{$id}'";
							$journal_classification =  Classifications::get_all_records('cls_id,cls_old_cls_id', $fetch_con);
							$class_temp_ids = array();
							if (!empty($journal_classification) && count($journal_classification)>0) {
								foreach ($journal_classification as $jk => $jv) {

									$class_temp_ids[$jv->cls_old_cls_id] = $jv->cls_id;
								}
								$cls_con="jucl_artp_id='{$article_type_id}'";
								$user_classifications = User_journal_classifications::get_all_records('jucl_usr_id,jucl_jntm_id',$cls_con);
								//print "<pre>";print_r($journal_classification); print_r($class_temp_ids);print_r($user_classifications); exit;
								$user_classification_insert = array();

								if (!empty($user_classifications)) {
									foreach ($user_classifications as $usek => $user) {
										$user_classification_insert[$usek]['jucl_usr_id'] = $user->jucl_usr_id;
										$user_classification_insert[$usek]['jucl_jntm_id'] = $class_temp_ids[$user->jucl_jntm_id];
										$user_classification_insert[$usek]['jucl_artp_id'] = $id;
										$user_classification_insert[$usek]['jucl_posted_by'] = $this->current_user['user_id'];
										$user_classification_insert[$usek]['jucl_posted_date'] = date('Y-m-d H:i:s');
										$user_classification_insert[$usek]['jucl_proxy_id'] = 0;
										$user_classification_insert[$usek]['jucl_operation'] = 'i';
									}
									User_journal_classifications::insert_batch($user_classification_insert);
								}

								$art_terms = Classifications::get_all_records("*", "cls_jnl_id = '{$jnl_id}' AND cls_artp_id='{$id}' AND cls_primary_id!='NULL' AND cls_old_cls_id IS NOT NULL");

								foreach ($art_terms as $art)
								{
									$cls_con="cls_old_cls_id='{$art->cls_primary_id}'";
									$getId =Classifications::get_single_record("cls_id", $cls_con);

									if ($getId)
									{
										$update_con="cls_id='{$art->cls_id}'";
									Classifications::update_record(array(
											'cls_primary_id' => $getId->cls_id,
										), $update_con, $this->current_user);
									}
								}


								/* clear jntm_old_jntm_id */
								$update_term="cls_jnl_id='{$jnl_id}' and cls_artp_id='{$id}'";
								Classifications::update_record(array(
									'cls_old_cls_id' => NULL
								), $update_term,$this->current_user);
							}
						}
						/* End - Copy Classifications */
						/* Start - Work flow */
						//if ((isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_workflow', $article_type['arttp_section'])) /*||  empty($article_type['arttp_section'])*/)
						if(isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_workflow', $article_type['arttp_section']) && isset($article_type['use_workflow']) && $article_type['use_workflow'] == 'c')
						{
							$this->copy_journal_workflow($jnl_data->jnl_id,$artcle_type_details->artp_fwm_id,$mast_flow_id,null,$old_flow_master_id);
						}
						/* Journal Users */
						$retire_role_status = FALSE;
						if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y') {
							$retire_role_status = TRUE;
						}

						//if ((isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_users', $article_type['arttp_section'])) ||  empty($article_type['arttp_section']))
						if(isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_users', $article_type['arttp_section']))
						{
							User_to_journals::move_user_roles($jnl_data->jnl_id, $id, $this->current_user['user_id'], $article_type_id, $retire_role_status);
						}
						/* Assigned users */
					
						if(isset($article_type['arttp_section']) && !empty($article_type['arttp_section']) && in_array('arttp_permissions', $article_type['arttp_section']))
						{

							Assign_permission::move_user_assgmnt($jnl_data->jnl_id, $id, $this->current_user['user_id'], $jnl_data->jnl_id, $article_type_id);
							$perm_con="asgm_artp_id='{$article_type_id}'";
							$assigned = Assign_permission::get_all_records('asgm_can_assgn_role,asgm_assgnd_role', $perm_con);

							if (!empty($assigned)) {
								$assigned = json_decode(json_encode($assigned), TRUE);
								foreach ($assigned as $ak => $a) {
									$assigned[$ak]['asgm_jnl_id']		= $jnl_data->jnl_id;
									$assigned[$ak]['asgm_artp_id']		= $id;
									$assigned[$ak]['asgm_posted_by']	= $this->current_user['user_id'];;
									$assigned[$ak]['asgm_posted_date']	= date('Y-m-d H:i:s');;
									$assigned[$ak]['asgm_proxy_id']		= 0;
									$assigned[$ak]['asgm_operation']	= 'i';
								}
								Assign_permission::insert_batch($assigned);
							}
						}

						// if (Flow_master::trans_complete() === TRUE)
						// { // End Copy Article type
							/* Create article type folder in uploads/journal */
							$path = 'uploads/' . $jnl_data->jnl_journal_code . '/' . $abbr;
							if (!file_exists($path)) {

								mkdir($path, 0765, TRUE);
							}
							$jnldetails['journal_code']=$jnl_data->jnl_journal_code;
							$jnldetails['abbr']=$abbr;
							$redir_link =  $jnl_data->jnl_journal_code . '/' . $abbr . '/settings/' .$this->encrypt_data($id);

							$return_arr=array(
								"status" => "success",
								"action_status" => "copy",
								"redirectLink" => $redir_link,
								"data"=>$jnldetails,
								"msg" => customTrans('platform_settings.art_type_copy_success')
							);
							return $this->success('check stage name',200,$return_arr);
				
				}
				else
				{

					$return_array=array(
						"status" => "failed",
						"msg" => customTrans('platform_settings.duplicate_article')
					);
					return $this->warning('Warnings',200,$return_array,'warning');
				}
			}
		}
	} catch (Exception $e) {

		return $this->failure('Failed', 500, $e);
	}
	}
	function copy_article_type_description($newArtTypeId, $oldArticle_id)
	{
		$this->current_user = $this->get_current_user_details();
		//get journal_settings table field names
		$art_set_fields = Required_file_type::get_field_names();

		$insert_fields = implode(',', $art_set_fields);
		$insert_fields = str_replace('rft_id,', '', $insert_fields);

		$select_fields = implode(',', $art_set_fields);
		$select_fields = str_replace('rft_id,', '', $select_fields);
		$select_fields = str_replace('rft_artp_id', $newArtTypeId, $select_fields);

		$select_fields = str_replace('rft_posted_by', $this->current_user['user_id'], $select_fields);
		$select_fields = str_replace('rft_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newartData = Required_file_type::copy_article_type_description($insert_fields, $select_fields, $oldArticle_id);
		return $newartData;
	}

	function copy_credential_ithenticate_articletype($newArtTypeId, $oldArticletype_id)
	{
		$this->current_user = $this->get_current_user_details();
		//get journal_settings table field names
		$art_set_fields = Api_credentials::get_field_names();

		$insert_fields = implode(',', $art_set_fields);
		$insert_fields = str_replace('acrd_id,', '', $insert_fields);

		$select_fields = implode(',', $art_set_fields);
		$select_fields = str_replace('acrd_id,', '', $select_fields);
		$select_fields = str_replace('acrd_artp_id', $newArtTypeId, $select_fields);

		$select_fields = str_replace('acrd_posted_by', $this->current_user['user_id'], $select_fields);
		$select_fields = str_replace('acrd_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newartData = Api_credentials::copy_credential_ithenticate_articletype($insert_fields, $select_fields, $oldArticletype_id);
		return $newartData;
	}
	 public function copy_journal_workflow($jnl_id,$jnl_fwm_id,$mast_flow_id, $artp_id = null,$old_fwm_id = NULL)
	 {
		 $this->current_user = $this->get_current_user_details();
		 $where = 'jwf_fwm_id != 0';
		 Generic_flows::update_record(array('jwf_temp_id' => 0), $where,$this->current_user);
		 $master_map_ids = $this->insert_article_flow($jnl_fwm_id, $mast_flow_id, $this->current_user['user_id']);
 		 $all_condition="jwf_fwm_id='{$mast_flow_id}'";
		 $article_flows = Generic_flows::get_all_records('*',$all_condition);
		 if (!empty($article_flows))
		 {

			 //$art_master = array(); //master array for track old and new ids
			 $temp_id = array(); //(old_id => new_id)
			 $insert_asoc_tmpls = array();
			 foreach ($article_flows as $art_flow)
			 {
				 //getting old and new ids
				 $temp_id[$art_flow->jwf_temp_id] = $art_flow->jwf_id;

				 //associate journal workflow templates to article type : Customisation #1565
				 $stgemilcondition="setr_jwf_id='{$art_flow->jwf_temp_id}'";
				 $asoc_tmpls = Stage_email_tmpl_reference::get_all_records('setr_stage_etmp_id', $stgemilcondition);
				 foreach ($asoc_tmpls as $t)
				 {
					 $insert_asoc_tmpls[] = array(
						 'setr_jwf_id' => $art_flow->jwf_id,
						 'setr_stage_etmp_id' => $t->setr_stage_etmp_id,
						 'setr_posted_date' => date('Y-m-d H:i:s'),
						 'setr_posted_by' => $this->current_user['user_id'],
						 'setr_proxy_id' => $this->current_user['proxy_user_id'],
						 'setr_operation' => 'i'
					 );
				 }
			 }


			 //start updating old stag ids with new ids
			 foreach ($article_flows as $article_flow)
			 {
				 $parent_stages = json_decode($article_flow->jwf_parent_stages);
				 foreach ($parent_stages as $key => $parent_stages_id)
				 {
					 if(isset($temp_id[$parent_stages_id]))
					 {
						 $parent_stages[$key] = "".$temp_id[$parent_stages_id]."";
					 }
					 else
					 {
						 unset($parent_stages[$key]);
					 }
					 /*foreach ($temp_id as $old_stage_id => $new_stage_id) {
						 $active_record = $this->Generic_flows->get_single_record('jwf_id', array('jwf_id' => $parent_stages_id, 'jwf_hide_status' => 'n'));
						 if (!empty($active_record)) {
							 if ($parent_stages_id == $old_stage_id) {
								 $parent_stages[$key] = $new_stage_id;
							 }
						 } else {
							 unset($parent_stages[$key]);
						 }
					 }*/
				 }
				 $parent_stages = array_values($parent_stages);
				 $flow_condition="jwf_id='{$article_flow->jwf_id}'";
				 Generic_flows::update_record(array(
					 'jwf_parent_stages' => json_encode($parent_stages)
				 ),$flow_condition,$this->current_user);

				 $child_stages = json_decode($article_flow->jwf_child_stages);
				 foreach ($child_stages as $key => $child_stages_id)
				 {
					 if(isset($temp_id[$child_stages_id]))
					 {
						 $child_stages[$key] = "".$temp_id[$child_stages_id]."";
					 }
					 else
					 {
						 unset($child_stages[$key]);
					 }
					 /*foreach ($temp_id as $old_stage_id => $new_stage_id)
					 {
						 //oldstage check exist then unset data
						 $active_record = $this->Generic_flows->get_single_record('jwf_id', array('jwf_id' => $child_stages_id, 'jwf_hide_status' => 'n'));
						 if (!empty($active_record)) {
							 if ($child_stages_id == $old_stage_id) {
								 $child_stages[$key] = $new_stage_id;
							 }
						 } else {
							 unset($child_stages[$key]);
						 }
					 }*/
				 }
				 $child_stages = array_values($child_stages);
				 Generic_flows::update_record(array(
					 'jwf_child_stages' => json_encode($child_stages)
				 ), $flow_condition,$this->current_user);
			 }
			 $updatecondition="jwf_fwm_id='{$mast_flow_id}'";
			 Generic_flows::update_record(array('jwf_temp_id' => 0),$updatecondition,$this->current_user);

			 if (!empty($insert_asoc_tmpls))
			 {
				 Stage_email_tmpl_reference::insert_batch($insert_asoc_tmpls);
			 }

			 //Task 664 ICE ReView new stages
			 $this->manage_advance_flow_movement_entries($jnl_fwm_id, $mast_flow_id, $temp_id);

			 $jnlData = new stdClass;
			 $jnlData->jnl_id =$jnl_id;
			 $jnlData->jnl_fwm_id = $jnl_fwm_id;


			 $this->copy_ftp_in_journal_workflow($jnlData, $mast_flow_id);
 
		 }
		if ($artp_id) {
			$this->update_old_jwf_with_new_jwf_id($master_map_ids, $artp_id);
		}
		if (isset($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers) && ($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers == 'y') && ($old_fwm_id != NULL)) {
			$old_source_stage_id_array = [];
			$old_destination_stage_id_array = [];
			$new_source_stage_id_array = [];
			$new_destination_stage_id_array = [];
			$copy_pool_data_select = "war_Jwf_id,war_destination_review_stage_id,war_wa_id";
			$workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
			$copy_pool_data = $workflow_assignment_reference::get_all_records_with_bind_cond($copy_pool_data_select, array('war_flow_master_id' => $old_fwm_id));
			if (!$copy_pool_data->isEmpty()) {
				foreach ($copy_pool_data as $key => $pool_data) {
					if (!empty($pool_data->war_Jwf_id)) {
						$old_source_stage_id_array = json_decode($pool_data->war_Jwf_id);
					}
					if (!empty($pool_data->war_destination_review_stage_id)) {
						$old_destination_stage_id_array = json_decode($pool_data->war_destination_review_stage_id);
					}
					if (count($old_source_stage_id_array) > 0) {
						foreach ($old_source_stage_id_array as $key => $value) {
							$source_stage_data_condition = "jwf_fwm_id = {$mast_flow_id} AND jwf_stage_name = ( SELECT jwf_stage_name FROM rvw_journal_workflows WHERE jwf_id = {$value})";
							$source_stage_data = Generic_flows::get_single_record('jwf_id', $source_stage_data_condition);
							if (!empty($source_stage_data)) {
								array_push($new_source_stage_id_array, strval($source_stage_data->jwf_id));
							}
						}
					}
					if (count($old_destination_stage_id_array) > 0) {
						foreach ($old_destination_stage_id_array as $key => $value) {
							$dest_stage_data_condition = "jwf_fwm_id = {$mast_flow_id} AND jwf_stage_name = ( SELECT jwf_stage_name FROM rvw_journal_workflows WHERE jwf_id = {$value})";
							$dest_stage_data = Generic_flows::get_single_record('jwf_id', $dest_stage_data_condition);
							if (!empty($dest_stage_data)) {
								array_push($new_destination_stage_id_array, strval($dest_stage_data->jwf_id));
							}
						}
					}
					$source_stage_id = count($old_source_stage_id_array) > 0 ? json_encode($new_source_stage_id_array) : NULL;
					$destination_stage_id = count($old_destination_stage_id_array) > 0 ? json_encode($new_destination_stage_id_array) : NULL;
					$workflow_assignment_data = array(
						'war_Jwf_id' => $source_stage_id,
						'war_destination_review_stage_id' => $destination_stage_id,
						'war_flow_master_id' => $mast_flow_id,
						'war_wa_id' => $pool_data->war_wa_id
					);
					$workflow_assignment_reference::insert_record($workflow_assignment_data, $this->current_user);
					$new_source_stage_id_array = [];
					$new_destination_stage_id_array = [];
				}
			}
		}

		 
		 return;
	 }

	private function update_old_jwf_with_new_jwf_id($updation_ids, $artp_id){
		foreach($updation_ids as $old_id => $new_id){
			$article_table = (new Articles)->getTable();
			$article_flow_table = (new Article_flow)->getTable();
			Article_flow::join($article_table, 'aflw_art_id', '=', 'art_id')->where('art_artp_id', $artp_id)->where('aflw_jwf_id', $old_id)->update(getColumnsWithDefault('Article_flow', ['aflw_jwf_id' => $new_id], 'u'));
			Article_notification_emails::join($article_table, 'ane_art_id', '=', 'art_id')->where('art_artp_id', $artp_id)->where('ane_next_jwf_id', $old_id)->update(getColumnsWithDefault('Article_notification_emails',['ane_next_jwf_id' => $new_id], 'u'));
			Rescind_reset_record::join($article_flow_table, 'rsc_current_flow_id', '=', 'aflw_id')->join($article_table, 'aflw_art_id', '=', 'art_id')->where('art_artp_id', $artp_id)->where('rsc_source_jwf_id', $old_id)->update(getColumnsWithDefault('Rescind_reset_record',['rsc_source_jwf_id' => $new_id], 'u'));
			Review_discussion::join($article_flow_table, 'rvd_aflw_id', '=', 'aflw_id')->join($article_table, 'aflw_art_id', '=', 'art_id')->where('art_artp_id', $artp_id)->where('rvd_jwf_id', $old_id)->update(getColumnsWithDefault('Review_discussion',['rvd_jwf_id' => $new_id], 'u'));
		}
	}
	 /*
         * start/stop article submission status of a article type
         */
	public function change_article_submission_status(Request $request)
	{
	try{
		$form_data=$request->all();
		$status     =   'error';
		$artp_id    =   $this->decrypt_data($form_data['artp_id']);
		$condition = "artp_id=" .$artp_id;
		$artp_data  =   Article_types::get_single_record('artp_article_submission_status', $condition);
		$this->current_user = $this->get_current_user_details();
		if ($artp_data->artp_article_submission_status == 'y') {
			$article_submission_status = 'n';
		} elseif ($artp_data->artp_article_submission_status == 'n') {
			$article_submission_status = 'y';
		}
		$data_update = array(
			'artp_article_submission_status' => $article_submission_status
		);

		$update = Article_types::update_record($data_update,'artp_id='.$artp_id, $this->current_user);
		$return_array['status'] = 'error';
		if ($update > 0)
		{
			$return_array['status'] = 'success';
		}
		$return_array['artsub_status']=$article_submission_status;
		return $this->success('success', 201, $return_array);
	} catch (\Exception $e) {
		return $this->failure('Failure', 500, $e);
	}

	}

	public function change_article_type_status(Request $request)
	{
		try {
			$form_data = $request->all();
			$form_data['artp_id'] = Rv_decrypt($form_data['artp_id']);
			$status_title = $form_data['title'];
			$condition = ['artp_id'=>$form_data['artp_id']];
			$article_type_data = Article_types::get_single_record_with_bind_cond('*',$condition);
			$this->current_user = $this->get_current_user_details();
			$en_message = '';
			if ($status_title == 'archive' && $article_type_data->artp_status == 'y')
			{
				$article_type_data->artp_status = 'n';
				// $en_message = 'Article type archived successfully';
					$en_message = customTrans('viewarticle.article_type_archived');
			}
			elseif ($status_title == 'activate' && $article_type_data->artp_status == 'n')
			{
				$article_type_data->artp_status = 'y';
				// $en_message = 'Article type activated successfully';
					$en_message = customTrans('viewarticle.article_type_activated');

			}

			$data_update = array(
				'artp_status' => $article_type_data->artp_status
			);
			$update = Article_types::update_record($data_update,$condition,$this->current_user);
			$return_array['status'] = 'error';
			if ($update > 0)
			{
				$return_array['status'] = 'success';
				$return_array['message'] = $en_message;
			}
			$return_array['artp_status']=$article_type_data->artp_status;
			return $this->success('success', 201, $return_array);

		} catch (\Exception $e) {
			return $this->failure('Failure', 500, $e);
		}
	}
    public function get_article_type_all_data(Request $request){
		try{
        $post_data = $request->all();
        $art_type_id = $post_data['artp_id'] = $this->decrypt_data($post_data['artp_id']);
        $post_data['jnl_id'] = Journals::get_single_record_with_bind_cond('jnl_id', ['jnl_journal_code' => $post_data['jnl_code']])->jnl_id;
        // $post_data['jnl_id'] = $this->decrypt_data($post_data['jnl_id']);
        $dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
		$dashboard_arr  = Config::get($dashboard_config);
        $this->current_user = $this->get_current_user_details();
        $user_retire_status = $this->get_user_role_retire($post_data['role_id'],$this->current_user['user_id'],$post_data['jnl_id']);
        $data = array();
        $data['artp_detail'] = Article_types::get_single_record_with_bind_cond("artp_article_type, artp_abbr_article_type, artp_venue,artp_start_date, artp_hard_enddate, artp_production_start_date, artp_production_deadline, artp_contact_num, artp_website_url", ['artp_id' => $art_type_id]);
        $data['tile_data'] = (new Manage_Dashboard_Api)->load_static_tiles($post_data, $dashboard_arr, $this->current_user, $user_retire_status, 'event_dash');

        return $this->success('success', data: $data);
		}
		catch(Exception $e){
			$this->failure(data:$e);
		}
    }

}
