<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Traits\GeneralEmailTrait;
use App\Http\Traits\SendemailTrait;
use Illuminate\Support\Facades\Validator;
use App\Models\Journals;
use App\Models\Article_types;
use App\Models\Event_invited_users;
use App\Models\Roles;
use App\Models\User_to_journals;
use App\Models\User;
use DateTime;
use Config;
use DB;
use \stdClass;
Class Manage_Bulk_Invitation_Api extends Controller {
     use GeneralEmailTrait;
     use SendemailTrait;
    public function index(Request $request)
	{
        try
        {
           $postdata=$request->all(); 
           $validator = Validator::make($request->all(), [
            'art_type_id' => 'required',
            'per_page' => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
           $post_data['article_type_id']=Rv_decrypt($postdata['art_type_id']);
           $post_data['per_page']=$postdata['per_page'];
           $post_data['jnl_code']=$postdata['jnl_code'];
           $result=$this->bulk_invited_users($post_data);
           return $this->success('success', 200, $result);
        }
        catch (\Exception $e) 
        {
            return $this->failure('Failure', 500, $e);
        }

    }
    public function bulk_invited_users($post_data)
    {


        $article_type_id=$post_data['article_type_id'];
        $current_user = $this->get_current_user_details();
        $type_data= Article_types::get_single_record_with_bind_cond('artp_soft_enddate,artp_jnl_id',array("artp_id"=>$article_type_id));
        $jnl_id=$type_data->artp_jnl_id; 
         $date_format = $this->get_platform_date_format($jnl_id);
         $date_format= date_format_map($date_format);
         $show_invite_button=false;
         if(isset($type_data->artp_soft_enddate)&&($type_data->artp_soft_enddate!=NULL))
         {
         $date_now = new DateTime();
         $softend_date   = new DateTime($type_data->artp_soft_enddate);
        if ($date_now <= $softend_date) {
            $show_invite_button=true;
        }else{
            $show_invite_button=false;
        }
       }
         $chap_sub_aflw_id_sql='';
         $additional_conditions = '';
         $additional_having = array();
         $orderby_field = '';
         $orderby_mode = '';
         $articles_per_page = $post_data['per_page'];
         $date_format = $this->get_platform_date_format($jnl_id);
         $date_format= date_format_map($date_format).' %H:%i:%s';;
         $select =  ' CONCAT(ru.usr_first_name, IF(ru.usr_middle_name IS NULL or ru.usr_middle_name="", " ", CONCAT(" ",ru.usr_middle_name," ")), ru.usr_last_name) as user_name,
         ru.`usr_id`,re.`evu_user_email` as user_email,re.`evu_registration_usr_id`,re.evu_user_id,ru.usr_email,DATE_FORMAT(re.evu_posted_date, "' . $date_format . '")  as invited_date,re.evu_submit_status,
         ra.`art_id`,ra.`art_code`,ra.`art_artp_id`, ra.`art_status` ';
         $condition = 'evu_artp_id = ? AND usr_status IN (\'a\')';
    

              $bind_arr[]=  $article_type_id;
              //article id search
              if (isset($post_data['review_art_code']) && $post_data['review_art_code'] != '') {
                 $post_data['review_art_code'] = trim($post_data['review_art_code']);
                 $condition = $condition . " AND  `art_code` LIKE ? ";
                 $bind_arr[]=  "%".$post_data['review_art_code']."%";
 
             }
             //article title search
             if (isset($post_data['review_art_title']) && $post_data['review_art_title'] != '') {
                 $post_data['review_art_code'] = trim($post_data['review_art_title']);
                 $condition = $condition . " AND `art_title` LIKE ? ";
                 $bind_arr[]=  "%".$post_data['review_art_title']."%";
             }
             //article type search
            /* */
             if (isset($post_data['art_type_id']) && $post_data['art_type_id'] != ''){
                 $condition = $condition . " AND  `art_artp_id` = ? ";
                 $bind_arr[]=  Rv_decrypt($post_data['art_type_id']);
             }
           /*  if(isset($post_data['filtr_by_auth']) && $post_data['filtr_by_auth'] != '' && count($post_data['filtr_by_auth']) > 0) {
                 $temp_ar = array();
                 foreach($post_data['filtr_by_auth'] as $authflt) {
                      $temp_ar[] = $this->decrypt_data($authflt);
                 }
                 $auth_filtr = implode(',',$temp_ar);
                 $condition = $condition . " AND if(art_submitted_by IS not null,FIND_array_intersect(art_submitted_by,?)=1,false)  ";
                 $bind_arr[]=  $auth_filtr;
             }
             $temp_user_ids=array();
             if(isset($current_user['user_id'])&&$current_user['user_id'])
             {
                 array_push($temp_user_ids,$current_user['user_id']);
                 $auth_ids = implode(',',$temp_user_ids);
                 $bind_arr[]=  $auth_ids;
                 $condition =$condition . ' AND  FIND_array_intersect(author_art_table.author_list,?) = 0 ';
 
             }*/
 
         DB::enableQueryLog();
         $result=Event_invited_users::get_event_invited_users($select,$condition,$additional_having,$orderby_field,$orderby_mode,$articles_per_page,$bind_arr);
        /* $query = DB::getQueryLog();
         $query = end($query);
         echo $result->total();exit;*/
        if(!empty($result['invited_result']))
        {
            foreach($result['invited_result'] as $invited)
            {
            
            $displayarray=array();
            $displayarray['user_id']=$invited->usr_id;
            $displayarray['jnl_code']=$post_data['jnl_code'];
            $displayarray['flag']=TRUE;
            $displayarray['availability']=TRUE;
            $displayarray['save_coauthor']=FALSE;
            $displayarray['remove_user']=FALSE;
            $displayarray['source']=FALSE;
            $displayarray['salutation']=TRUE;
            $displayarray['flag_only']=FALSE;
            $displayarray['inactive_user']=FALSE;
            $displayarray['fullname_only']=FALSE;
            $displayarray['journal_id'] = $jnl_id;
            $invited->userdata= $this->get_user_display_name($displayarray);
            }
        }
        
        $invited_list=$result['invited_result'];
        $rtn_arr = array(
            'tot_count' => $invited_list->total(),
            'userlist'  => $invited_list,
            'lastPage' => $invited_list->lastPage(),
            'show_invite_button'=>$show_invite_button
        );

        return $rtn_arr;

    }

    public function get_bulkuser_invite_emailtmpl(Request $request)
    {
        try{
            $post_data=$request->all();
            $validator = Validator::make($request->all(), [
                'art_type_id' => 'required',
                'jnl_id' => 'required',
                'jnl_code'=>'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $art_type_id=Rv_decrypt($post_data['art_type_id']);
            $jnl_id=Rv_decrypt($post_data['jnl_id']);
            $article_type_data = Article_types::get_single_record_with_bind_cond('artp_abbr_article_type', array('artp_id'=>$art_type_id) );
            $Email_templates = new \App\Models\Email_templates();
            $current_user = $this->get_current_user_details();
            
            $email_template= $Email_templates::get_single_record_with_bind_cond('*', array(
                'etmp_name' => 'bulk_invite_submission',
                'etmp_notification' => 'User'
        ));
  
            $email_hooks = $this->Utility('email_hooks');
            
            foreach ($email_hooks as $eh => $value) {
            
                if ($eh == 'email_hooks') {

                    $email_template->template_name = $value["bulk_invite_submission"];
                    break;
                }
            }
            $return_arr['email_count']='no_record';
            if ($email_template != NULL)
			{
                $email_data = new stdClass;
                preg_match_all('/##([^##]*)##/', $email_template->etmp_email_template, $matches);
                $keys = $matches[1];
           
                        $email_data->email_templates_config = $this->email_templates_config();
                        $email_data->join_config = $this->join_config();
                        $email_data->join_dependency_config = $this->join_dependency_config();
                        $email_data->artp_id=$art_type_id;
                        $email_data->jnl_id=$jnl_id;
                        $email_data->jnl_journal_code=$post_data['jnl_code'];
                        $email_data->artp_code=$article_type_data->artp_abbr_article_type;
                        $email_data->template_name=$email_template->etmp_name;
                        
                     //   $email_data->user_id=$current_user['user_id'];
                        $email_data->user_role_tags = $this->user_role_tags();
                        $subject = $email_template->etmp_subject;
						$content =$email_template->etmp_email_template;
                        $user_titles = $this->UserConfigdata('titles')['titles'];
                       // $email_data->user_id = $recipient->usr_id;
                        $email_data->resend_usr_confirmation = TRUE;
                        if($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email=$this->current_client->functionality->cfty_unique_hide_control_label_email;
                        $subject = $this->generate_email_data_from_keys($email_data, $subject, $current_user, $user_titles, TRUE);
                        $content = $this->generate_email_data_from_keys($email_data, $content, $current_user, $user_titles, TRUE);                   
                       
                        $reply_to= '';
                        $reply_to=Config::get('clients.'.$this->current_client->clnt_client_code.'.email.email_settings')['reply_to_email'];
                        /*
						if (isset($this->current_client->email_settings['reply_to_email']) && $this->current_client->email_settings['reply_to_email'] != '')
						{
							$reply_to = $this->current_client->email_settings['reply_to_email'];
						}
                        */
                        $cc_bcc_roles = array();
						/*$remove_roles=array("sudo"=>"Super User");
                        $display_role = array_diff_key($this->UserConfigdata("managing_roles")['managing_roles'], $remove_roles);
                        $usr_roles = array_values($display_role);
                        if (!empty($usr_roles)) {
							foreach ($usr_roles as $us) {
								$cc_bcc_roles[$us] = $us;
							}
						}*/
						$cc_roles['Custom_cc'] = 'Specific email ID';
                        $bcc_roles['Custom_bcc'] = 'Specific email ID';
                        $etm_custom_cc=array();
                        $etm_custom_bcc=array();
                        if(isset($email_template->etmp_cust_cc)&&$email_template->etmp_cust_cc!=NULL)
                        $etm_custom_cc=explode(',',$email_template->etmp_cust_cc);
                        if(isset($email_template->etmp_cust_bcc)&&$email_template->etmp_cust_cc!=NULL)
                        $etm_custom_bcc=explode(',',$email_template->etmp_cust_bcc);
                        $return_arr = array(
                            'status' => 'success',
                            'cc_roles' =>$cc_roles,
                            'bcc_roles'=>$bcc_roles,
                            'to_cc' => json_decode($email_template->etmp_cc),
                            'to_bcc' => json_decode($email_template->etmp_bcc),
                            'cust_cc' =>$etm_custom_cc,
                            'cust_bcc' => $etm_custom_bcc,
                            'reply_to' => $reply_to,
                            'subject' => $subject,
                            'content' => $content,
                            'email_count'=>1);
               
            }
            else
            {
                return $this->warning('Warnings',200,$return_arr,'warning');
                
            }
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    
    public function fetch_users_to_invite(Request $request)
    {
        try{
            $post_data=$request->all();
            $validator = Validator::make($request->all(), [
                'art_type_id' => 'required',
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $return_array=array();
            $user_data = $this->get_current_user_details();
            $author_role_id     =   null;
            $art_type_id=Rv_decrypt($post_data['art_type_id']);
            $jnl_id=Rv_decrypt($post_data['jnl_id']);
            $jnl_standalone='n';
            $search=$post_data['search'];
            $user_journal_table = (new \App\Models\User_to_journals())->getTable();
            $users_table = (new \App\Models\User())->getTable();
            $fetch_author_role  =   Roles::get_single_record_with_bind_cond('role_id', array('role_assigned_role' => 'author'));
       
            if(isset($fetch_author_role->role_id)) {
                $author_role_id    =   $fetch_author_role->role_id;
            }     
             
            if($author_role_id != null) {
                $condition  =   'usrj_jnl_id = '.$jnl_id.' AND usrj_usr_id != '.$user_data['user_id'].' AND usrj_role_id = '.$author_role_id.' AND usr_status="a"';
                if($jnl_standalone == 'y') {
                    $condition  .=   ' AND `usr_jnl_standalone` = ' .$jnl_id. '';
                }
                $post_search = htmlspecialchars($search, ENT_QUOTES);
                if ($search != NULL) {
                    $condition  .=   ' AND (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE "%'.$search.'%" OR usr_email LIKE "%'.$search.'%")';
                }
               /* $tables     =   array(
                                'main_table' => User_to_journals::$tbl_name,
                                'join_table' => array(Users::$tbl_name => 'usrj_usr_id = usr_id')
                                );*/
                                $tables = array(
                                    'main_table' => $user_journal_table,
                                    'join_table' => array(
                                        $users_table => array($user_journal_table . '.usrj_usr_id', $users_table . '.usr_id', "inner")
                                    )
                                );
                $select     =   'usr_id, usr_email, CONCAT(concat(UPPER(SUBSTR(usr_title,1,1)),LOWER(SUBSTR(usr_title,2)))," ", usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user_name';
               
                $records    =   User_to_journals::get_results_using_joins($tables, $select, $condition, 'all',null,null,null,null,null,null,'usr_id');
                $return_array['users']=$records;
                return $this->success('Success', 200, $return_array);
                

        }
    }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
        public function send_bulk_invitation_mail(Request $request) {
            try
            {
                $Email_templates = new \App\Models\Email_templates();
                $return_array=array();
                $post_data = $request->all();
                $validator = Validator::make($request->all(), [
                    'email_subject' => 'required',
                    'email_content' => 'required',
                    'jnl_id' => 'required',
                    'jnl_code' => 'required',
                    'art_type_id' => 'required',
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }

                $user_data = $this->get_current_user_details();
                $to_users   =   array();
                $user_id    =   $user_data['user_id'];
                $subject    =   $post_data['email_subject'];
                $content    =   $post_data['email_content'];
                $jnl_id=Rv_decrypt($post_data['jnl_id']);
                $jnl_code=$post_data['jnl_code'];
               // $eve_action =   $post_data['event_action'];
                $artp_id   =   Rv_decrypt($post_data['art_type_id']);
                $article_type_data = Article_types::get_single_record_with_bind_cond('artp_abbr_article_type', array('artp_id'=>$artp_id) );   
                //registered users email pushed to a array
                if(isset($post_data['bulk_reg_users'])) {
                    $registered_users   =   $post_data['bulk_reg_users'];
                    if(count($registered_users) > 0) {
                        foreach($registered_users as $key) {
                            $to_users[]    =   $key;
                        }
                    }
                }
                //new users email pushed to a array
                if(isset($post_data['bulk_non_reg_users'])) {
                    $new_users  =   $post_data['bulk_non_reg_users'];
                    if(count($new_users) > 0) {
                        foreach($new_users as $key) {
                            $to_users[]    =   $key;
                        }
                    }
                }
     
                $template= $Email_templates::get_single_record_with_bind_cond('*', array('etmp_name' => 'bulk_invite_submission', 'etmp_notification' => 'User'
            ));
          
            if ($template != NULL)
            {
                $temp_email_tpl =   $template->etmp_email_template;
            } else {
                $temp_email_tpl =   '';
            }
            $temp_email_tpl     =   $content;
            if(!empty($to_users))
            {
                $post_data['postdata']['stage_template_sub']=$subject;
                $post_data['postdata']['stage_template_content']=$temp_email_tpl;
                $post_data['postdata']['jnl_id']=encrypt_link($jnl_id);
                $post_data['postdata']['jnl_code']=encrypt_link($jnl_code);

                if(isset($post_data['email_invitecc'])&&$post_data['email_invitecc']!=NULL)
                {    
                $post_data['postdata']['stage_template_to_cc']=$post_data['email_invitecc'];

                }   
                if(isset($post_data['email_invitebcc'])&&$post_data['email_invitebcc']!=NULL)
                {
                $post_data['postdata']['stage_template_to_bcc']=$post_data['email_invitecc'];
                }
                $post_stage_cust_cc=isset($post_data['email_specific_cc'])?$post_data['email_specific_cc']:'';
                $post_stage_cust_bcc=isset($post_data['email_specific_bcc'])?$post_data['email_specific_bcc']:'';
                $get_formated_custom_cc_bcc=$this->get_specific_cc_bcc_values($post_stage_cust_cc,$post_stage_cust_bcc);
                if(isset($get_formated_custom_cc_bcc['cust_cc'])&&$get_formated_custom_cc_bcc['cust_cc']!=NULL)
                $post_data['postdata']['stage_cust_cc']=$get_formated_custom_cc_bcc['cust_cc'];
                if(isset($get_formated_custom_cc_bcc['cust_bcc'])&&$get_formated_custom_cc_bcc['cust_bcc']!=NULL)
                $post_data['postdata']['stage_cust_bcc']=$get_formated_custom_cc_bcc['cust_bcc'];
                $post_data['postdata']['stage_template_to_mail']=$post_data['email_replay_to'];

            foreach($to_users as $email) { 
               
                $condition='(
                    (
                      `usr_roles` NOT LIKE "%super_admin%" && `usr_roles` NOT LIKE "%sudo%"
                    ) OR `usr_roles` IS NULL
                  ) AND `usr_status` IN ("a","w") AND usr_email=?';
                  DB::enableQueryLog();
                  $user = User::get_single_record('usr_id,usr_status,usr_deeplink_token,usr_url', $condition,binding_arr:[$email]);
                 
                  $query = DB::getQueryLog();
                  $query = end($query);
                    

                  $custom_data=array(
                    'artp_id'=> $artp_id
                );
                if(!empty($user)) {
                    $user_id = $user->usr_id;
                } else {
                    $user_id = null;
                } 
               
                if (isset($post_data['email_invitecc'])&&!empty($post_data['email_invitecc']))
                {
                    $template->etmp_cc = json_encode($post_data['email_invitecc']);
            
                }
                if (isset($post_data['email_invitebcc'])&&!empty($post_data['email_invitebcc']))
                {
                    $template->etmp_bcc = json_encode($post_data['email_invitebcc']);
                
                }
                if(isset($get_formated_custom_cc_bcc['cust_cc'])&&$get_formated_custom_cc_bcc['cust_cc']!=NULL)
                $template->etmp_cust_cc=$get_formated_custom_cc_bcc['cust_cc'];
                if(isset($get_formated_custom_cc_bcc['cust_bcc'])&&$get_formated_custom_cc_bcc['cust_bcc']!=NULL)
                $template->etmp_cust_bcc=$get_formated_custom_cc_bcc['cust_bcc'];
                $template->reply_to = trim($post_data['email_replay_to']);
                $template->etmp_subject=$subject;
                $template->etmp_email_template=$content;
                $send_array['email']=$email;
                $send_array['user_id']=$user_id;
                $send_array['template']=$template;
                $send_array['art_type_id']=$artp_id;
                $send_array['jnl_code']=$jnl_code;
                $send_array['art_type_code']=$article_type_data->artp_abbr_article_type;
                $send_array['post_data']=$post_data;
                $send_array['email_template']=$template;
                
                $this->send_email_invite($send_array);
               // $specific_emails=$this->get_specific_cc_bcc_values();
           
                /*$email_data=array(
                    'type'=>'custom',
                    'action'=>'send',
                    'email_temp'=>'global',
                    'action'=>'send',
                    'email_with_login'=>TRUE,
                    'user_id'=> $user_id,
                    'post_data'=>$post_data,
                    'template'=> 'bulk_invite_submission',
                    'jnl_journal_code'=>$jnl_code,
                     'artp_code'=>$article_type_data->artp_abbr_article_type,
                 
                    'custom_data'=>$custom_data
                );
             
                $send = $this->master_email_details($email_data);
               */

             
                    $email_already_exists    =   Event_invited_users::get_single_record_with_bind_cond('count(evu_id) as cnt', array('evu_user_email'=>$email,'evu_artp_id' => $artp_id,'evu_submit_status' => 'i'));
                    if($email_already_exists->cnt == 0) {
               
                        $data_list   =   array(
                                        'evu_artp_id' => $artp_id,
                                        'evu_user_id' => $user_id,
                                        'evu_user_email' => $email,
                                        'evu_registration_usr_id' => null,
                                    );
                                  
                        Event_invited_users::insert_record($data_list,$user_data);
                    }
                
            }
                }
                $return_array['status'] = 'success';
                return $this->success('Success', 200, $return_array);

            }
            catch (\Exception $e) {
                     
                return  $this->failure('Failed', 500, $e);
            }

        }

        public function send_email_invite($send_array)
        {
        
            $this->current_user = $this->get_current_user_details();
            $email_template=$send_array['email_template'];
            $email_data= new stdClass();
            /* new email template config */
            $email_data->user_id =$send_array['user_id'];
            $email_data->user_email = $send_array['email'];
            $email_data->artp_id=$send_array['art_type_id'];
            $email_data->new_email = true;
            $email_data->mail_recipient_ids = $send_array['user_id'];
            $email_data->jnl_journal_code =$send_array['jnl_code'];
            $email_data->artp_code = $send_array['art_type_code'];
            $email_data->email_templates_config = $this->email_templates_config();
            // print_r($email_data->email_templates_config);exit;
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();
            $email_data->user_role_tags = $this->user_role_tags();
            $email_config = 'clients.' . $this->current_client->clnt_client_code;
            $email_config_data = Config::get($email_config . '.email');
            $email_data->reply_to= $email_config_data['email_settings']['reply_to_email'];
            $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
            if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

            if (isset($email_template->etmp_email_template) && strpos($email_template->etmp_email_template,"OPENING_PARAGRAPH") > 0)
            $email_template->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->etmp_email_template);

            $data_array = array(
                'record' => $email_template,
                'email_data' => $email_data,
                'user_data' =>$this->current_user,
                'column_prefix' =>'etmp_',
            );
            
            $this->notify_mail($data_array);
        }
}
?>