<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\StagemovementTrait;

use App\Models\Volumes;
use App\Models\Article_types;
use App\Models\Journals;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Generic_flows;
use App\Models\User;
use App\Models\Stage_email_templates;
use App\Models\Issues;
use App\Models\Journal_settings;
use App\Models\User_to_journals;
use App\Models\Article_type_advance_options;
use App\Models\Authors;
use App\Models\User_affiliations;
use App\Models\Authors_affiliation;
use App\Models\Issue_management;
use App\Models\Article_notes;
use App\Models\Article_notification_emails;
use App\Models\Roles;
use App\Models\Article_tab_status;
use Illuminate\Support\Facades\URL;
use DateTime;
use Config;
use DB;
class Manage_Conference_Paper_Api extends Controller
{
    use UtilityTrait;
    use StagemovementTrait;

    public function batch_article_paper_list(Request $request)
    {
        try
        {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $res=array();
            $jnl_id= Rv_decrypt($form_data['jnl_id']);
            $jnlidarray = array('input'=>$jnl_id,'type'=>'number');
            $jnlidvalidation = $this->Rv_validator($jnlidarray);

            if($jnlidvalidation !== true){
				$res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
			}
            $post_data=array();

            $post_data['review_art_code'] =isset($form_data['paramsdet']['review_art_code']) ? $form_data['paramsdet']['review_art_code'] : '';
            $post_data['review_art_title'] =isset($form_data['paramsdet']['review_art_title']) ? $form_data['paramsdet']['review_art_title'] : '';
            $post_data['event_type'] =isset($form_data['paramsdet']['event_type']) ? $form_data['paramsdet']['event_type'] : '';
            $post_data['filtr_by_auth'] =isset($form_data['paramsdet']['filter_by_auth']) ? $form_data['paramsdet']['filter_by_auth'] : '';
            $post_data['filter_by_star'] =isset($form_data['paramsdet']['filter_by_star']) ? $form_data['paramsdet']['filter_by_star'] : '';
            $post_data['start'] = isset($form_data['start']) ? $form_data['start'] : '0';
            $post_data['sort_order'] = isset($form_data['sort_order']) ? $form_data['sort_order'] : '';
            $post_data['sort_field'] = isset($form_data['sort_field']) ? $form_data['sort_field'] : '';
            $post_data['per_page'] = isset($form_data['per_page']) ? $form_data['per_page'] : '';
            $post_data['type'] = isset($form_data['type']) ? $form_data['type'] : '';
            $post_data['stage_id']=isset($form_data['stage_id']) ? $form_data['stage_id'] : '';
            $post_data['art_type_id']=isset($form_data['art_type_id']) ? $form_data['art_type_id'] : '';
            $post_data['art_status']=isset($form_data['art_status']) ? $form_data['art_status'] : '';

            $post_data['jnl_id'] = $jnl_id;
            $post_data['event_dash']=isset($form_data['event_dash']) ? $form_data['event_dash'] : '';
            if(isset($jnl_id))
            {
            $result=$this->get_conferene_papers($jnl_id,$post_data);
            }
            return $this->success('success', 200, $result);

        }
        catch(\Exception $e)
        {
   
            return  $this->failure('Failed',500,$e);

        }
    }
    public function get_conferene_papers($jnl_id,$post_data)
    {

        
        $articleflow_table = (new \App\Models\Article_flow())->getTable();
        $current_user = $this->get_current_user_details();
       $jnl_data= Journals::get_single_record_with_bind_cond('jnl_journal_code AS jnl_code',array("jnl_id"=>$jnl_id));
        $date_format = $this->get_platform_date_format($jnl_id);
        $date_format= date_format_map($date_format);
        $chap_sub_aflw_id_sql='';
        $additional_having = array();
        $orderby_field = $post_data['sort_field'];
        $orderby_mode = $post_data['sort_order'];
        $articles_per_page = $post_data['per_page'];
        $select =  ' art_id,art_code,art_title,art_status,art_pre_all_ids,absc_category,
        art_title_editable,art_submitted_by,usr_id,(CONCAT(usr_first_name,  IF(
            usr_middle_name IS NULL OR usr_middle_name = "",
            " ",
            CONCAT(" ", usr_middle_name, " ")
        ), usr_last_name)) as usr_full_name,usr_first_name as userdata, (DATEDIFF(`art_invitation_due`, NOW())) AS author_response_due_remaining,
        aflw_id,art_artp_id,usr_email,aflw_status,rat_star_value,jwf_stage_name,jwf_stage_type,aflw_posted_by,aflw_usr_id,jwf_fwm_id,jwf_id,
        artp_abbr_article_type,	artp_article_type,jnl_journal_code,jwf_child_stages,stage_etmp_id,stage_etmp_name,
        DATE_FORMAT(art_invitation_due, "' . $date_format . '") as author_response_due,art_invitation_due,
        DATE_FORMAT(aflw_due_date, "' . $date_format . '") as submission_due_date, aflw_due_date, DATE_FORMAT(aflw_posted_date, "' . $date_format . '") as aflw_posted_date, author_list' . $chap_sub_aflw_id_sql;
        $condition = 'jnl_id = ? AND art_delete_status IN (\'n\',\'h\') AND art_delete_status!=\'w\'';
        $bind_arr[]=  $jnl_id;
        if(isset($post_data['type'])&&$post_data['type']=='review')
        {
            $condition.=' AND fl1.aflw_id = (select max(aflw_id) from '.$articleflow_table.' as fl2 where fl2.aflw_art_id = fl1.aflw_art_id  AND aflw_status=\'w\')';
            if (isset($post_data['event_type']) && $post_data['event_type'] != ''){
                $condition = $condition . " AND  `art_artp_id` = ? ";
                $bind_arr[]=  Rv_decrypt($post_data['event_type']);
            }
        }
        else
        {
            $subcondition='';
            if(isset($post_data['art_status'])&&$post_data['art_status']!='')
            {
                $status=$post_data['art_status'];
            $subcondition.=" AND aflw_status ='$status'";
            }
            $condition.=' AND fl1.aflw_id = (select max(aflw_id) from '.$articleflow_table.' as fl2 where fl2.aflw_art_id = fl1.aflw_art_id'.$subcondition.' ) ';



            $non_decision_stages="'".implode("', '", config('general_config.avoid_decision_stages'))."'";



            $condition.=' AND  jwf_stage_type NOT IN('.$non_decision_stages.')';
            if(isset($post_data['stage_id'])&&$post_data['stage_id']!='')
        {
            $condition = $condition . " AND  `jwf_id` = ? ";
            $bind_arr[]=  decrypt_link($post_data['stage_id']);
        }
        }



             //article id search
             if (isset($post_data['review_art_code']) && $post_data['review_art_code'] != '') {
                $post_data['review_art_code'] = trim($post_data['review_art_code']);
                $condition = $condition . " AND  `art_code` LIKE ? ";
                $bind_arr[]=  "%".$post_data['review_art_code']."%";

            }
            //article title search
            if (isset($post_data['review_art_title']) && $post_data['review_art_title'] != '') {
                $post_data['review_art_code'] = trim($post_data['review_art_title']);
                $condition = $condition . " AND `art_title` LIKE ? ";
                $bind_arr[]=  "%".$post_data['review_art_title']."%";
            }
            //article type search
           /* */
            if (isset($post_data['art_type_id']) && $post_data['art_type_id'] != ''){
                $condition = $condition . " AND  `art_artp_id` = ? ";
                $bind_arr[]=  Rv_decrypt($post_data['art_type_id']);
            }
            if(isset($post_data['star_rate_value']) && $post_data['star_rate_value'] != '')
            {
                $condition = $condition . " AND  `rat_star_value` = ? ";
                $bind_arr[]=  Rv_decrypt($post_data['star_rate_value']);
            }
            if(isset($post_data['filter_by_star']) && $post_data['filter_by_star'] != '' && count($post_data['filter_by_star']) > 0) {
                $temp_ar = array();
                foreach($post_data['filter_by_star'] as $starflt) {
                     $temp_ar[] = $starflt;
                }
                $star_filtr = implode(',',$temp_ar);
                $condition = $condition . " AND if(rat_star_value IS not null,FIND_array_intersect(rat_star_value,?)=1,false)  ";
                $bind_arr[]=  $star_filtr;
            }
            if(isset($post_data['filtr_by_auth']) && $post_data['filtr_by_auth'] != '' && count($post_data['filtr_by_auth']) > 0) {
                $temp_ar = array();
                foreach($post_data['filtr_by_auth'] as $authflt) {
                     $temp_ar[] = $this->decrypt_data($authflt);
                }
                $auth_filtr = implode(',',$temp_ar);
                $condition = $condition . " AND if(art_submitted_by IS not null,FIND_array_intersect(art_submitted_by,?)=1,false)  ";
                $bind_arr[]=  $auth_filtr;
            }
            $temp_user_ids=array();
            if(isset($current_user['user_id'])&&$current_user['user_id'])
            {
                array_push($temp_user_ids,$current_user['user_id']);
                $auth_ids = implode(',',$temp_user_ids);
                $bind_arr[]=  $auth_ids;
                $condition =$condition . ' AND  FIND_array_intersect(author_art_table.author_list,?) = 0 ';

            }

        DB::enableQueryLog();
        $result=Articles::get_all_article_confernce_papers($select,$condition,$additional_having,$orderby_field,$orderby_mode,$articles_per_page,$bind_arr);
        $paperlist=$result['article_result'];
      /*  $query = DB::getQueryLog();
		$query = end($query);print_r($query);*/
        if(!empty($paperlist))
        {
          foreach($paperlist as $paper)
          {
            $displayarray=array();
            $displayarray['user_id']=$paper->usr_id;
            $displayarray['jnl_code']=$jnl_data->jnl_code;
            $displayarray['flag']=true;
            $displayarray['article_id']=$paper->art_id;
            $displayarray['availability']=true;
            $displayarray['save_coauthor']=false;
            $displayarray['remove_user']=false;
            $displayarray['source']=false;
            $displayarray['salutation']=true;
            $displayarray['flag_only']=false;
            $displayarray['inactive_user']=false;
            $displayarray['fullname_only']=false;
            $displayarray['journal_id'] = $jnl_id;
            $paper->userdata= $this->get_user_display_name($displayarray);

          }
        }
       return array(
            'tot_count' => $paperlist->total(),
            'articles'  => $paperlist,
            'lastPage' => $paperlist->lastPage()
        );

       
    }

    public function  batch_reviewer_intiate_filter_papers(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'journal_id' => 'required',
            ]);
            $art_classification=array();
         
            $jnl_id = Rv_decrypt($request->journal_id);
            $jnl_classification = $this->search_classificationdata(NULL, NULL, $jnl_id);
            $return_arr['classfication_data'] = array(
                'jnl_classification' => $jnl_classification,
                'art_classification' => $art_classification
            );
            return  $this->success('Success', 200, $return_arr);
        }
        catch(\Exception $e)
        {

            return  $this->failure('Failed',500,$e);
        }

    }

    public function invited_reviewer_checking(Request $request)
    {
       try
       {
        $post_data=$request->all();
        $user_id=Rv_decrypt($post_data['user_id']);
       /* $article_ids=array('LoGH','L4GH','LJGH');
        $art_stage_ids=array("LoGH"=>"LJGH","L4GH"=>"NoGH","LJGH"=>"LrHH");
        */
        $article_ids=$post_data['article_ids'];
        $art_stage_ids=$post_data['art_stage_ids'];
        $journal_id=Rv_decrypt($post_data['jnl_id']);
        $jounal_code=$post_data['jnl_code'];
        $return_array=array();
         if(!empty($art_stage_ids))
         {
        $data_array['jnl_code']=$jounal_code;
        $data_array['jnl_id']=$journal_id;
        $data_array['art_stage_ids']=$art_stage_ids;
        $data_array['user_id']=$user_id;

        $exclude_users=$this->check_reviewer_vaild($data_array);

        $return_array['message']='';
        $return_array['msg_count']=count($exclude_users);
        if((isset($exclude_users))&&(!empty($exclude_users)))
        {

            $message_data=$this->format_reviewer_check_validation($exclude_users);
            $return_array['message']=$message_data;
        }

        }

        return  $this->success('Success', 200, $return_array);
       }
       catch(\Exception $e)
       {

        return  $this->failure('Failed',500,$e);
       }
    }

    public function batch_paper_reviewer_invite(Request $request)
    {
      try
      {
        $post_data = $request->all();
        $current_user=$this->get_current_user_details();
        $user_data = $this->get_current_user_details();
        $Article_flow=new \App\Models\Article_flow;
        $Articles=new \App\Models\Articles;
        $Article_reviewers=new \App\Models\Article_reviewers;
        $Roles=new \App\Models\Roles;
        $User=new \App\Models\User;
        $Generic_flows=new \App\Models\Generic_flows;
        $Stage_email_templates=new \App\Models\Stage_email_templates;
        $Email_templates=new \App\Models\Email_templates;
        $Email_send_log=new \App\Models\Email_send_log;
        $Journals=new \App\Models\Journals;
        $User_to_journals=new \App\Models\User_to_journals;
        $Article_types=new \App\Models\Article_types;
        $Authors=new \App\Models\Authors;
        $Reject_reasons=new \App\Models\Reject_reasons;
        $Article_notification_emails=new \App\Models\Article_notification_emails;
        $Article_versions_reviewers = new \App\Models\Article_versions_reviewers;
        $User_articles = new \App\Models\User_articles;
    
        $article_ids=$post_data['article_ids'];
        $art_stage_ids=$post_data['art_stage_ids'];
        $user_ids=$post_data['user_ids'];
        $journal_id=Rv_decrypt($post_data['jnl_id']);
        $journal_code=$post_data['jnl_code'];
        $return_array=array();

        if(!empty($user_ids))
        {
            foreach($user_ids as $user_id)
            {
                $user_id = Rv_decrypt($user_id);
                $data_array['jnl_code']=$journal_code;
                $data_array['jnl_id']=$journal_id;
                $data_array['art_stage_ids']=$art_stage_ids;
                $data_array['user_id']=$user_id;
                $exclude_users=$this->check_reviewer_vaild($data_array);
                $return_array['message']='';
                if((isset($exclude_users))&&(!empty($exclude_users)))
                {
                    return  $this->warning('Warnings',200,"Failed",'warning');
                }

                $input_arr = array(
                    'input' =>$user_id,
                    'type'=> 'number'
                );
                $user_id_validate = $this->Rv_validator($input_arr);
                if(!empty($article_ids))
                {
                $aflw_ids = array();
                foreach($art_stage_ids as $article_id=>$current_stage_id)
                 {



                    $current_stage_id=Rv_decrypt($current_stage_id);
                    $input_arr = array(
                        'input' =>$current_stage_id,
                        'type'=> 'number'
                    );
                    $flow_id_validate = $this->Rv_validator($input_arr);

                    $article_id = Rv_decrypt($article_id);
                    $input_arr = array(
                        'input' =>$article_id,
                        'type'=> 'number'
                    );
                    $article_id_validate = $this->Rv_validator($input_arr);
                    if( $article_id_validate===false &&$flow_id_validate=== false  &&$user_id_validate===false)
                    {

                     $arraymsg['mesage'] = customTrans('validation.notvalid');

                    return $this->warning("Failed",200,$arraymsg);

                    }

                    $today = date('Y-m-d H:i:s', time());
                    $article_cur_stage = $Article_flow::get_aticle_statuses($article_id, $current_user, $current_stage_id, true);
                    $article_cur_stage = $article_cur_stage[0];
                    $select = 'art_id, art_artp_id, art_title,art_pre_all_ids, artp_article_type, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
                    $article_details = $Articles::get_article_details($select,"aflw_id={$current_stage_id}");
                    $article_details= $article_details[0];

                    $due_date = $this->get_due_date_for_article($article_details->art_id, $article_details->jwf_tat_accept);
                    $parent_status_record = $Article_flow::get_single_record_with_bind_cond('*',array("aflw_id"=>$current_stage_id));
                    $exist_condition=array("aflw_usr_id"=>$user_id,"aflw_parent_flow_id"=>$current_stage_id);

                    $get_record = $Article_flow::get_single_record_with_bind_cond('*', $exist_condition);
                    $inserted_ids = array();
                    if ($article_cur_stage->aflw_status == 'w')
			         {
				    $req_role_id = $article_cur_stage->jwf_role_id;
			        }
                    $in = 0;
                    if ($get_record != '')
                    {
                        $already_added[] = $user_id;
                        $return_data['id_arr_duplication'][] = Rv_encrypt($user_id);
                    }
                    else
                    {

                        $data['aflw_usr_id'] = $user_id;
                        $data['aflw_art_id'] = $article_id;
                        $data['aflw_parent_flow_id'] = $current_stage_id;
                        $data['aflw_status'] = 'i';
                        $data['aflw_due_date'] = $due_date;
                        $data['aflw_assigned_date'] = $today;
                        $data['aflw_jwf_id'] = $parent_status_record->aflw_jwf_id;
                        $data['aflw_level'] = $parent_status_record->aflw_level;


                        $inserted_id = $Article_flow::insert_record($data, $current_user);

                        $article_reviewer_data ['sorw_aflw_id'] = $inserted_id;
                        $article_reviewer_data ['sorw_suggested_reviewer_id'] = $user_id;
                        $article_reviewer_data ['sorw_suggested_user_id'] = $current_user['user_id'];
                        $article_reviewer_data['sorw_suggested_on'] = $today;
                        $article_reviewer_data['sorw_art_id'] = $article_id;
                        if(isset($post_data['usr_source']))
                        {
                        $article_reviewer_data['sorw_usr_source']=$post_data['usr_source'];
                        }
                        $article_reviewer_data ['sorw_invited_by'] =$current_user['user_id'];
                        $article_reviewer_data['sorw_invited_on'] = $today;

                        $art_rev_id = $Article_reviewers::insert_record($article_reviewer_data, $current_user);

                        //Task #5083 Modify alternative reviewer selection


                        if ($inserted_id)
                        {
                            $aflw_ids[] = $inserted_id;
                            $inserted_ids[$in]['user'] = $user_id;
                            $inserted_ids[$in]['flow'] = $inserted_id;
                            $inserted_ids[$in]['review'] = $art_rev_id;
                            $in++;
                            /* start  --- add the user with reviewer role to journal users if not added */
                            if ($article_cur_stage->aflw_status == 'w')
                            {
                                $user_role_details = array(
                                    'usrj_jnl_id' => $journal_id,
                                    'usrj_usr_id' => $user_id,
                                    'usrj_role_id' => $req_role_id,
                                    'usrj_artp_id' => null,
                                );

                         
                                $jnl_spec_rev_record = $User_to_journals::get_single_record_with_bind_cond('*', $user_role_details);

                                $user_role_details_insert = array(
                                    'usrj_jnl_id' => $journal_id,
                                    'usrj_usr_id' => $user_id,
                                    'usrj_role_id' => $req_role_id,
                                    'usrj_artp_id' => null,
                                );

                                if ($jnl_spec_rev_record == null)
                                {

                                    $user_role_id = $User_to_journals::insert_record($user_role_details_insert, $current_user);
                                }
                                $user_role_details_art_type = array(
                                    'usrj_jnl_id' => $journal_id,
                                    'usrj_usr_id' => $user_id,
                                    'usrj_role_id' => $req_role_id,
                                    'usrj_artp_id' => $article_details->art_artp_id,
                                );
                              

                                $art_type_spec_rev_record = $User_to_journals::get_single_record_with_bind_cond('*', $user_role_details_art_type);

                                if ($art_type_spec_rev_record == null)
                                {
                                    $user_role_details_insert['usrj_artp_id']=$article_details->art_artp_id;
                                    $user_role_id = $User_to_journals::insert_record($user_role_details_insert, $current_user);
                                }
                            }
                            /* end  --- add the user with reviewer role to journal users if not added */
                            $added[] = $user_id;
                            $return_data['id_arr_alloacted'][] = encrypt_link($user_id);
                            if ($article_cur_stage->jwf_stage_type == "review" && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                            {
                            $del_criteria=array("usra_art_id"=>$article_id,"usra_usr_id"=>$user_id);
                                $User_articles::delete_records($del_criteria, '',$current_user);
                            }
                        }
                        else
                        {
                            $return_data['msg'] = 'Sorry ! some error occured';
                            return $this->success('warning',200,$return_data);
                        }

                        //Enhancement#2068 Self and Assignmet type processing on production and ReView
                        //only below code work when assign reviewers
                        if($article_cur_stage->jwf_stage_type == 'review' && $article_cur_stage->role_assigned_role == 'reviewer')
                        {
                            $revier_exist = $Article_versions_reviewers::get_single_record_with_bind_cond('count(artvr_id) as count',array("artvr_article_id"=>$article_id,"artvr_user_id"=>$user_id));
                            if($revier_exist->count > 0)
                            {
                                $criteria_revwr =array("artvr_article_id"=>$article_id,"artvr_user_id"=>$user_id
                            );
                                $Article_versions_reviewers::delete_records($criteria_revwr,'',$current_user);
                            }

                            $reviwers_details = array(
                                'artvr_user_id' => $user_id,
                                //'artvr_prev_art_id' => $user_id,
                                'artvr_article_id' => $article_id,
                                'artvr_previous_art_ids' => $article_details->art_pre_all_ids
                            );
                            $Article_versions_reviewers::insert_record($reviwers_details, $current_user);
                        }
                    }
                   }
                   $req_data = [
                    'user_id' => $user_id,
                    'aflw_ids' => $aflw_ids,
                    'jnl_id' => $journal_id,
                    'jnl_code' => $journal_code
                   ];
                   $this->batch_article_reviewer_assignment($req_data);

                }
            }
        }
        return  $this->success('Success', 200, $return_array);
      }
      catch(\Exception $e)
      {
        return  $this->failure('Failed',500,$e);
      }


    }
    public function check_reviewer_vaild($data_array)
    {


        $Blind_user_articles=new \App\Models\Blind_user_articles;
        $Reviewed_privilaged_users = new \App\Models\Reviewed_privilaged_users;

        $art_stage_ids=$data_array['art_stage_ids'];
        $user_id=$data_array['user_id'];

        $arraymsg=array();
        $arraymsg['warnings']=array();
        $art_message_array=array();
        if(!empty($art_stage_ids))
        {

        foreach($art_stage_ids as $article_id=>$parent_flow)
        {

           $input_arr = array(
               'input' =>$user_id,
               'type'=> 'number'
           );
           $user_id_validate = $this->Rv_validator($input_arr);
           if(isset($parent_flow))
           {
           $parent_flow_id=Rv_decrypt($parent_flow);
           $input_arr = array(
               'input' =>$parent_flow_id,
               'type'=> 'number'
           );
           $flow_id_validate = $this->Rv_validator($input_arr);
           }
           else
           {
           $return_array['msg']="Invalid Data";
           return  $this->warning('Warnings',200,$return_array,'warning');
           }

           $article_id = Rv_decrypt($article_id);
           $input_arr = array(
               'input' =>$article_id,
               'type'=> 'number'
           );
           $article_id_validate = $this->Rv_validator($input_arr);
           if( $article_id_validate===false &&$flow_id_validate===false  &&$user_id_validate===false)
           {

            $arraymsg['message'] = customTrans('validation.notvalid');

           return  $arraymsg['message'];

           }

       $exclude_users = array();

       $article_flow_users =Article_flow::get_all_records_with_bind_cond('aflw_usr_id',array("aflw_art_id"=>$article_id,"aflw_parent_flow_id"=>$parent_flow_id));

       if (!empty($article_flow_users))
       {
       $aflw_usrs = $this->get_column_array($article_flow_users, 'aflw_usr_id');
       $exclude_users = array_merge($exclude_users, $aflw_usrs);
       if (in_array($user_id, $aflw_usrs))
       {
        $art_message_array[$article_id]['alreadyassign']=true;
       }
       }
       $article_authors =Authors::get_all_records_with_bind_cond('auth_usr_id',array("auth_art_id"=>$article_id));

       $auth_usrs = $this->get_column_array($article_authors, 'auth_usr_id');

       if (in_array($user_id, $auth_usrs))
       {
       $art_message_array[$article_id]['author']=true;
       }

       $exclude_users = array_merge($exclude_users, $auth_usrs);

            /* Exclude reviewed privilaged user if they perform any task after the review stage. */
         

                $article_details =Articles::get_single_record_with_bind_cond('art_pre_all_ids,art_artp_id',array("art_id"=>$article_id));
                $art_ids = array();
                $art_ids = ($article_details->art_pre_all_ids != NULL) ? $article_details->art_pre_all_ids : '';
                $art_ids = ($art_ids != '') ? $art_ids . ',' . $article_id : $article_id;

                $reviewd_privilaged = array();
                if ($art_ids != null)
                {
                    $reviewd_privilaged = $Reviewed_privilaged_users::get_all_records('rvp_usr_id', 'rvp_art_id in(' . $art_ids . ')');
                }

                $exclude_privilaged = array();
                if (!empty($reviewd_privilaged))
                {
                    foreach ($reviewd_privilaged as $rev)
                    {
                        $exclude_privilaged[] = $rev->rvp_usr_id;
                    }
                }

                $exclude_users = array_merge($exclude_users, $exclude_privilaged);

            $exclude_users = (!empty($exclude_users)) ? array_unique(array_filter($exclude_users)) : array();



            $blinded_usr_records = $Blind_user_articles::get_single_record('bau_usr_ids','bau_art_id = '. $article_id);
            if(isset($blinded_usr_records->bau_usr_ids)){
                $blinded_usr_ids = json_decode($blinded_usr_records->bau_usr_ids);
                $exclude_users = array_merge($exclude_users, $blinded_usr_ids);
            }

       }

  
    }
      return $art_message_array;
    }
    public function format_reviewer_check_validation($message_array)
    {
        if(!empty($message_array))
        {
            $formatmsg =' <b>The selected Reviewer can not add as a Reviewer,  </b><br/> <br/>';
            $author_art_array=array();
            $exist_reviewer_array=array();
            foreach($message_array as $art_id=>$message)
            {

                $input_arr = array(
                    'input' =>$art_id,
                    'type'=> 'number'
                );
                $article_id_validate = $this->Rv_validator($input_arr);

                if($article_id_validate===true)
                {
                $article_details =Articles::get_single_record_with_bind_cond('art_code',array("art_id"=>$art_id));

                if(isset($message['alreadyassign'])&&($message['alreadyassign']===true))
                {
              
                   $exist_reviewer_array[]=$article_details->art_code;
                }
                if(isset($message['author'])&&($message['author']===true))
                {
                    $author_art_array[]=$article_details->art_code;
                   
                }


                }

            }
            if(!empty($author_art_array)&&(count($author_art_array)))
            {
                $auth_artids=implode(",",$author_art_array);
                $formatmsg .=$auth_artids.'   has already author . <br/>';
            }
            if(!empty($exist_reviewer_array)&&(count($exist_reviewer_array)))
            {
                $exist_artids=implode(",",$exist_reviewer_array);
                $formatmsg .=$exist_artids.'   has already been assigned as Reviewer . <br/>';
            }

            return $formatmsg;
        }
    }

    public function batch_article_reviewer_assignment($data)
    {
        $user_id = $data['user_id'];
        $aflw_ids = $data['aflw_ids'];
        $jnl_id = $data['jnl_id'];
        $jnl_code = $data['jnl_code'];
        $template_action = 'batch_article_reviewer_assignment';
        $current_stage_id_str = '"' . implode('", "', $aflw_ids) . '"';
        $article = new \App\Models\Articles();
        $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept, aflw_deeplink_token,aflw_usr_id,jwf_child_stages';
        $article_details = $article::get_article_details($select, "aflw_id in ($current_stage_id_str) ", limit: count($aflw_ids));
        $article_details = $article_details->toArray();
        $article_ids = array_column($article_details, 'art_id');
        if ($template_action != '') {
            $custom_data = array(
                'esl_etmp_action' => $template_action,
                'coauthor_notify' => true,
                'jnl_id' => $jnl_id,
                'jnl_code' => $jnl_code,
                'article_id' => $article_ids,
                'aflw_id' => $aflw_ids,
            );
            $email_data = array(
                'type' => 'global',
                'action' => 'send',
                'email_with_login' => false,
                'user_id' => $user_id,
                'empt_name' => $template_action,
                'custom_data' => $custom_data,
                //   'email_templates_config' => WorkflowTrait::email_templates_config()
            );
            $this->master_email_details($email_data);
        }
    }

}
