<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use JWTAuthException;
use App\Models\Casrai_credits;
use App\Models\Modules;
use Config;
use DB;
class Manage_Contributorships_Api extends Controller
{
    /*
    get pagination
    commited date :-  11-11-2022
    Request type :- POST
    */
    public function index(Request $request)
    {   
		try {
			$form_data= $request->all();	
			$this->current_user = $this->get_current_user_details();
			$result_array=[];
            $sort_field = $form_data['sort_field'] ?? 'cas_id';
            $sort_order = $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 5;
            //$criteria = 'etmp_platform = "g" ';
            $select = "*";
			/* start --- Checking roles table author and journal admin roles are present 
		 	* if not present then insert */
			 //$criteria = 'role_assigned_role ="author"';
			 //$author = Casrai_credits::get_all_records('*',$criteria); 
			 
            $result_array = Casrai_credits::get_paginated_records($select, $criteria =NULL, $sort_field, $sort_order, $limit);
            return $this->success('success',200,$result_array);
		} 
        catch (exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
     /*
    save data.
    commited date :-  11-11-2022
    Request type :- POST
    */
    public function saveContribData(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            if(!isset($post_data))
            {
                return  $this->failure('Failed',500,$e);
            }
            $validator = Validator::make($post_data, [
                'credit_name' => 'required',
                'description' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',422);
                }
           
            $data = array(
				'cas_credit_name' => $post_data['credit_name'],
				'cas_description' => $post_data['description']
			); 
            if (isset($post_data['hidden_id']) && $post_data['hidden_id'] != '') { 
                $cas_id = $this->decrypt_data($post_data['hidden_id']);
                $duplicate_check = $this->checkUniqueContrib($post_data['credit_name'], $post_data['hidden_id']);
                if($duplicate_check)
                {
                    return $this->warning('warning',200);
                }
                $criteria = 'cas_id="' . $cas_id . '"';						
				$result = Casrai_credits::update_record($data,$criteria,$this->current_user);
            }
            else
            {
                $duplicate_check = $this->checkUniqueContrib($post_data['credit_name']);
                if($duplicate_check)
                {
                    return $this->warning('warning',200);
                }
                $duplicate_check = $this->checkUniqueContrib($post_data['credit_name']);
                $result = Casrai_credits::insert_record($data, $this->current_user);
            }
           
            return $this->success('success',200,$result);
        }
        catch (exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
     /*
    get single data
    commited date :-  13-11-2022
    Request type :- POST
    */
    public function checkUniqueContrib($data, $id=NULL)
	{
		$credit_name = $data;
        $result = false;
		//$values = explode("&",$casrai_data['casrai_credits']['cas_credit_name']);			
		if ($credit_name)
		{	
            if($id != NULL)
            {
                $id = $this->decrypt_data($id);
                $criteria = 'cas_credit_name = "' .$credit_name. '" AND cas_id != "' .$id. '"';	
            }
            else
            {
                $criteria = 'cas_credit_name = "' .$credit_name. '"';	
            }
            
			$cas_data= Casrai_credits::get_all_records('*', $criteria);
			if (count($cas_data) > 0)
			{
				$result = true;
			}
			else
			{
				$result = false;
			}
		}
		return $result;
	}
    public function getContribData(Request $request)
    {
        try {
            $post_data = $request->all();
            $cas_id = $this->decrypt_data($post_data['cas_id']);
            if(!is_numeric($cas_id)) {
                $msg_arr[]='Somthing went wrong';
                return  $this->warning($msg_arr,200,'','warning');
            }	
            $criteria = 'cas_id = "' .$cas_id. '"';
            $result = Casrai_credits::get_single_record('cas_id,cas_credit_name,cas_description', $criteria);
            if($result)
            {
                return $this->success('success',200,$result);
            }
            else
            {
                return  $this->warning('Failed',500);
            }
            
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function deleteContribData(Request $request)
    {
        try {
            $cas_id = $this->decrypt_data($request->contrib_id);
            $this->current_user = $this->get_current_user_details();
            $criteria = "cas_id='{$cas_id}'";
            $result = Casrai_credits::delete_records($criteria,"",$this->current_user);
            if($result)
            {
                return $this->success('success',200,$result);
            }
            else
            {
                return  $this->warning('Failed',500);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
}
