<?php

namespace App\Http\Controllers;

use App\Models\Copyright_master;
use App\Models\Copyright;
use Config;
use App\Models\Copyright_request;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\URL;
use App\Http\Traits\WorkflowTrait;
use function PHPUnit\Framework\countOf;
use \stdClass;

class Manage_Copyright_Statement_Api extends Controller
{
    use WorkflowTrait;
    /*List all Copyrights
     commited date :- 17-11-2022
     Requested type :- POST
    */
    public function index(Request $request)
    {
        try {
            $form_data = $request->all();
            DB::enableQueryLog();
            $sort_field = (isset($form_data['sort_field'])) ? $form_data['sort_field'] : 'crtm_id';
            $sort_order =  (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'asc';
            $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 5;
            $result = Copyright_master::get_paginated_records('*', NULL, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Delete a Copyright from table
     commited date :- 17-11-2022
     Requested type :- POST
    */
    public function delete_copyright(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $client_code = $this->current_client->clnt_client_code;
            $validator = Validator::make($request->all(), [
                'crtm_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $copyright_id = $this->decrypt_data($request->crtm_id);


            $condition = 'crt_crtm_id=' . $copyright_id;
            $result = Copyright::get_single_record('count(crt_crtm_id) as count', $condition);
            if ($result->count > 0) {
                $cpr_wng='copyright';
                if(env('VITE_CONFERENCE_PROCEEDINGS') == TRUE)
                $cpr_wng='article submission';
                $res['msg']=customTrans('copyright.copyright_already_used',['copyright' => $cpr_wng]);
                return $this->warning('Warning',200,$res,'warning');             
            }

            $criteria = 'crtm_id="' . $copyright_id . '"';
            $file = public_path() . '/storage/uploads/copyright_licence/'. $client_code . '/' . $copyright_id . '.pdf';
            $newName = $copyright_id.'.pdf';
            if ($this->current_client->enable_upload_s3_bucket == 'y') 
			{
                $path	=	public_path() . '/storage/uploads/copyright_licence/'. $client_code .'/';
				$aws_path='uploads/copyright_licence/'. $client_code .'/';
				$this->remove_fileinfolder($path,$newName,$aws_path);
			}
            else
            {
                if ($copyright_id != '') 
                {
                    if (file_exists($file))
                    {
                        unlink($file);    
                    }
                }
            }
            
            $result = Copyright_master::delete_records($criteria, '', $current_user);
            $message = customTrans('copyright.delete_copyright_success');
            return $this->success($message, 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Add / Update a Copyright 
     commited date :- 17-11-2022
     Requested type :- POST
    */
    public function save_copyright(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $form_data = $request->all();
            $client_code = $this->current_client->clnt_client_code;
            $copyright_id = $this->decrypt_data($form_data['edit_id']);
            $messages = [];
            if ($form_data['edit_id'] != '') {
                $rules = [
                    'license_name' => 'required',
                    'license_details' => 'required',
                ];
            }else{
                $rules = [
                    'license_name' => 'required|unique:rvw_copyright_master,crtm_license_name',
                    'license_details' => 'required',
                ];
            }
            
            if ($this->current_client->functionality->cfty_copyright_upload != 'y') 
            {
                $rules['license_content'] = 'required';
            }else{
                if(isset($form_data['uploadBit']) && $form_data['uploadBit'] == 0){
                    $rules['file'] = 'required|file';
                    $messages['file.required'] = 'Copyright PDF file is required';
                    $messages['file.file'] = 'Copyright PDF should be a file';
                }
            }

            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) {
                return $this->failure('Failed', 200, $validator->errors()->first());
            }
            DB::enableQueryLog();
            $paymeny_mode =  $form_data['license_mode'] === 'n' ? 'o' : 't';
            $copyright_array = array(
                'crtm_license_name' => $form_data['license_name'],
                'crtm_payment' => $paymeny_mode,
                'crtm_license_details' => $form_data['license_details'],
                //  'crtm_license_content' => $form_data['license_content'] ?? '<p></p>'
            );
            if ($this->current_client->functionality->cfty_copyright_upload != 'y') 
            {
                //task #3419 Issues in maange copyright statment
                $target = '<button contenteditable="false">JOURNAL_NAME</button>';
                $aipp=$this->check_client_proceeding();		
                if (strpos($form_data['license_content'], $target) !== false && $aipp===true) {
                    $replacement = '<button contenteditable="false">CONFERENCE_NAME</button>';
                    $copyright_array['crtm_license_content'] = str_replace($target, $replacement, $form_data['license_content']);
                } else {
                    $copyright_array['crtm_license_content'] = $form_data['license_content'];
                }
            }

            $where_cnd = ' `crtm_license_name` = "' . $form_data['license_name'] . '"  AND `crtm_payment`= "' . $paymeny_mode . '"';

            // print_r($where_cnd);
            // print_r($copyright_id);
            $result = Copyright_master::get_single_record('crtm_id,count(crtm_id) as count', $where_cnd);
            // $query = DB::getQueryLog();
            // $query = end($query);
            // print_r($query);
            if (($result->count > 0) && ($result->crtm_id != $copyright_id)) {
                return $this->warning('Exist', 200, 'License name with given license mode already exists.');
            }
            // exit;
            if ($form_data['edit_id'] != '') {
                $condition = 'crtm_id=' . $copyright_id;
                $result = Copyright_master::get_single_record('count(crtm_id) as count', $condition);
                if ($result->count > 0) {
                    $result_data = Copyright_master::update_record($copyright_array, $condition, $current_user);
                }
                $message = customTrans('copyright.copyright_updated_success');
            } 
            else 
            {
                $result_data = Copyright_master::insert_record($copyright_array, $current_user);
              
               
                $message = customTrans('copyright.copyright_save_successfully');
            }
            if ($this->current_client->functionality->cfty_copyright_upload == 'y') 
            {
                $allowed_extensions = array("pdf");
                // $attachment_file = $form_data['file'];
                $attachment_file = $request->file('file');
                if(isset($attachment_file) && $attachment_file != "")
                {   
                    $name = $attachment_file->getClientOriginalName();
                    $extension = $attachment_file->getClientOriginalExtension();
                    if(!in_array($extension,$allowed_extensions))
                    {
                        $result_data = array(
                            'status' => false,
                            'msg'    => 'Invalid File type'
                        );
                        $message = 'Invalid File type';
                        return $this->warning($message, 200, 'Invalid File type');   
                    }
                    else
                    {
                        $file_path = Config::get('general_config.file_retrieval')['file_path'];
                        $path = 'copyright_licence/'. $client_code;
                        $fullpath = "uploads" . DIRECTORY_SEPARATOR . $path;
                        $aws = false;
                        if ($this->current_client->enable_upload_s3_bucket == 'y') 
                        {
                            $aws = true;
                            $this->update_s3_files($path);	
                        }
                        if ($form_data['edit_id'] != '') 
                        {
                            $result_data = $copyright_id;
                            $newName = $result_data.'.pdf';
                            $file = public_path() . '/storage/uploads/copyright_licence/'. $client_code .'/' . $copyright_id . '.pdf';
                            if ($this->current_client->enable_upload_s3_bucket == 'y') 
                            {
                                $path_copy	=	public_path() . '/storage/uploads/copyright_licence/'. $client_code .'/';
                                $aws_path='uploads/copyright_licence/'. $client_code .'/';
                                $this->remove_fileinfolder($path_copy,$newName,$aws_path);    
                            }
                            else
                            {
                                if ($copyright_id != '') 
                                {
                                    if (file_exists($file))
                                    {
                                        unlink($file);    
                                    }
                                }
                            }
                            $name = $this->rename_file(public_path() . $file_path . "/" . $path . DIRECTORY_SEPARATOR, $newName,$aws,$fullpath);
                            $uploaded_file_details=$this->upload_file_handler($path, $attachment_file, $name);
                        }
                        else
                        {
                            $newName = $result_data.'.pdf';
                            $name = $this->rename_file(public_path() . $file_path . "/" . $path . DIRECTORY_SEPARATOR, $newName,$aws,$fullpath);
                            $uploaded_file_details=$this->upload_file_handler($path, $attachment_file, $name);    
                        }
                
                    }
                }
            }
            return $this->success($message, 200, $result_data);   
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Get details of a Copyright
     commited date :- 17-11-2022
     Requested type :- POST
    */
    public function get_copyright(Request $request)
    {
        try {
            $form_id = $request->all();
            $client_code = $this->current_client->clnt_client_code;
            $validator = Validator::make($form_id, [
                'crt_id' => 'required'
            ]);
            $copyright_id = $this->decrypt_data($form_id['crt_id']);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $condition = 'crtm_id=' . $copyright_id;
            $get_copyright = Copyright_master::get_single_record('*', $condition);
            $path = '';
            $uploaded_file = false;
            $file = "";
            if ($this->current_client->functionality->cfty_copyright_upload == 'y') 
            {
                $path = public_path() . '/storage/uploads/copyright_licence/'. $client_code .'/';
                if (!file_exists($path)) {
                    mkdir($path, 0765, TRUE);
                }
                $file = public_path() . '/storage/uploads/copyright_licence/' . $client_code . '/' . $get_copyright->crtm_id . '.pdf';   
                if ($get_copyright->crtm_id != '') {
                    if (file_exists($file))
                    {
                        $uploaded_file = true;
                    }
				}
            }
            $result = array(
                'copyright_details' => $get_copyright,
                'copyright_path' => $file,
                'upload_file' => $uploaded_file
            );
            $message = customTrans('copyright.select_copyright_success');
            return $this->success($message, 200, $result);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function preview_copyright_pdf(Request $request) 
    { 
        try{
            $form_id = $request->all();
            $client_code = $this->current_client->clnt_client_code;
            $copyright_id = $this->decrypt_data($form_id['crt_id']);
            $condition = 'crtm_id=' . $copyright_id;
            $get_copyright = Copyright_master::get_single_record('*', $condition);
            $copyrightid = $get_copyright->crtm_id.'.pdf';
            $pdf_path = 'copyright_licence/' . $client_code .'/'. $copyrightid;
            if ($pdf_path != NULL) {
                $data = array(
                    'file' => $this->get_upload_data($pdf_path)
                );
            }
            return  $this->success('Success',201,$data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
	}
    //copyright in article preview submission page for confrence
    public function get_copyright_list(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
                'art_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $jnl_id =   decrypt_link($request->jnl_id);
            $art_id =   decrypt_link($request->art_id);
            if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' ) {
                
                $journal_settings   =  new \App\Models\Journal_settings();
                $Copyright_master   =   new \App\Models\Copyright_master();
                $Articles   =   new \App\Models\Articles();
                $previous_ids = $Articles::get_single_record('art_pre_all_ids', 'art_id = ?',binding_arr:[$art_id]);
                if (!empty($previous_ids->art_pre_all_ids)) {
                    $art_id = strtok($previous_ids->art_pre_all_ids, ',');
                }
                $license_id  =   $journal_settings::get_single_record('jset_license_id','jset_jnl_id = ?',binding_arr:[$jnl_id]);
                if (!empty($license_id) && isset($license_id->jset_license_id)) {
                    $string = implode(',', array_map(function($val) { return "'$val'"; }, json_decode($license_id->jset_license_id)));
                    $copyright_slct = "crtm_id,crtm_license_name,crtm_license_details,crtm_payment, CASE WHEN crtm_id  = (SELECT crt_crtm_id FROM rvw_copyright  WHERE crt_art_id = ? LIMIT 1) THEN 'true' ELSE 'false' END AS checked,(SELECT crt_id FROM rvw_copyright WHERE crt_art_id = ? LIMIT 1) AS crt_id"; 
                    $cpt_cnd = 'crtm_id IN ('.$string.')';
                    $binding_arr = [$art_id, $art_id];
                    if (isset($request->licence_type) && $request->licence_type !== '') {
                        $license_type = $request->licence_type;
                        if ($license_type !== "all") {
                            $cpt_cnd     .= " AND crtm_payment = ?";
                            $binding_arr[] = $license_type;
                        }
                    }
                    $license_details['item'] = Copyright_master::get_all_records($copyright_slct,$cpt_cnd,binding_arr: $binding_arr);
                    $copyright_mode_array = $this->Utility('copyright_mode_array');
                    $license_details['avail_license_modes'] = $copyright_mode_array['copyright_mode_array'];
                    if( !empty($license_id) && count($license_details['item']) !=1)
                    {
                        foreach ($license_details['item']  as $licensedetails) {
                            if($licensedetails->checked=='true'){
                                $license_details['selected_license_id']=$licensedetails->crt_id;
                                $license_details['selected_name']=$licensedetails->crtm_license_name;
                                $license_details['selected_avail_license_modes']=$licensedetails->crtm_payment;
                                // $license_details['selected_license_dtl']=$licensedetails->crtm_license_details;
                                //Task #3333 show new line for copyright license details
                                $license_details['selected_license_dtl']=nl2br(htmlspecialchars($licensedetails->crtm_license_details));
                                break;
                            }
                        }
                    }
                    else
                    {
                        if($license_details['item'][0]->checked=='true'){
                        $license_details['selected_license_id']=$license_details['item'][0]->crt_id;
                        $license_details['selected_name']=$license_details['item'][0]->crtm_license_name;
                        $license_details['selected_avail_license_modes']=$license_details['item'][0]->crtm_payment;
                        // $license_details['selected_license_dtl']=$license_details['item'][0]->crtm_license_details;
                        //Task #3333 show new line for copyright license details
                        $license_details['selected_license_dtl']=nl2br(htmlspecialchars($license_details['item'][0]->crtm_license_details));
                        }
                    }

                    return  $this->success('Success',200,$license_details); 
                }
                return $this->warning('Warnings',200,'No license type for this journal','warning');
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function save_copyright_list(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'crtm_id' => 'required',
                'aflw_id' => 'required',
                'jnl_id' => 'required',
                'jnl_code' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $art_id     =   decrypt_link($request->art_id);
            $crtm_id    =   decrypt_link($request->crtm_id);
            $aflw_id    =   decrypt_link($request->aflw_id);
            if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' ) {

                $Copyright  =   new \App\Models\Copyright();
                $Copyright_master = (new \App\Models\Copyright_master())->getTable();
                $current_user = $this->get_current_user_details();
                $copyright_check = $Copyright::get_single_record('COUNT(crt_id) as cnt','crt_art_id = ?',binding_arr:[$art_id]);
                if (isset($copyright_check->cnt) && $copyright_check->cnt > 0) {
                    $upadet_data    =   ['crt_crtm_id' => $crtm_id];
                    $Copyright::update_record($upadet_data,'crt_art_id = ?',$current_user,binding_arr:[$art_id]);
                    $msg = 'Copyright updated successfully';
                    $Articles   =   new \App\Models\Articles();
                    $art_status    =   $Articles::get_single_record('art_status','art_id = ? ',binding_arr:[$art_id]);
                    if (isset($art_status->art_status) && $art_status->art_status == 'y') {
                        //send email to privilaged users
                        $jnl_id =   decrypt_link($request->jnl_id);
                        $data   =   [
                            'jnl_id' => $jnl_id,
                            'jnl_code' => $request->jnl_code,
                            'art_id'    =>  $art_id
                        ];
                        $this->change_copyright_confirm($data);
                    }
                }
                else {
                    $insert_data = [
                        'crt_art_id' => $art_id,
                        'crt_aflw_id' => $aflw_id,
                        'crt_crtm_id' => $crtm_id,
                        'crt_license_content' => '',
                        'crt_fee_waiver_reason' => '',
                    ];
                    $Copyright::insert_record($insert_data,$current_user);
                    $msg = 'Copyright added successfully';  
                } 
                return  $this->success('Success',201,['msg'=>$msg]);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function change_copyright_send_email(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
                'jnl_code' => 'required',
                'art_id' => 'required',
                'email_subject'=>'required',
                'email_content'=>'required'

            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $user_data = $this->get_current_user_details();
            DB::beginTransaction();
            if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' ) {
                $jnl_id =   Rv_decrypt($request->jnl_id);
                $art_id =   Rv_decrypt($request->art_id);
                $post_data  =   $request->all();
                $user_id    =   $user_data['user_id'];
                $subject    =   $post_data['email_subject'];
                $content    =   $post_data['email_content'];
                $Email_templates    =   new \App\Models\Email_templates();
                $Generic_flows      =   new \App\Models\Generic_flows();
                $Article_flow       =   new \App\Models\Article_flow();
                $Articles   =   new \App\Models\Articles();
                // Task #3393 Copyright Aipp New tile for author
                $art_data    =   $Articles::get_single_record('art_submitted_by,art_artp_id,art_copyright_request','art_id = ? ',binding_arr:[$art_id]);
                if(!empty($art_data)) {
                $artp_id    =$art_data->art_artp_id;
                //$cond   =   "aflw_art_id = ? AND jwf_stage_type = 'author_submission'";
                //$aflw_details   =   $Article_flow::get_results_using_joins($tables,'aflw_id',$cond,'single',binding_arr:[$art_id]);
                $records    =   $Email_templates::get_single_record('*', "etmp_name ='change_copyright'");
                if (!empty($records)) {
                    $send_mail_to_detail    =   $this->send_email_to($records->etmp_notification,$jnl_id,$artp_id,$art_id);

                    if ($send_mail_to_detail) {
                        $post_data['postdata']['stage_template_sub']    =   $subject;
                        $post_data['postdata']['stage_template_content']    =   $content;
                        $post_data['postdata']['stage_template_to_mail']=$post_data['email_replay_to'];
                        $post_data['jnl_id']=encrypt_link(RV_decrypt($request->jnl_id));
                        $post_data['jnl_code']=encrypt_link(RV_decrypt($request->jnl_code));
                        if(isset($post_data['email_invitecc'])&&$post_data['email_invitecc']!=NULL)
                        {
                        $post_data['postdata']['stage_template_to_cc']=$post_data['email_invitecc'];

                        }
                        if(isset($post_data['email_invitebcc'])&&$post_data['email_invitebcc']!=NULL)
                        {
                        $post_data['postdata']['stage_template_to_bcc']=$post_data['email_invitebcc'];//Task #3448 Issues in Change copyright notification email template  bug 4
                        }
                        $post_stage_cust_cc=isset($post_data['email_specific_cc'])?$post_data['email_specific_cc']:'';
                        $post_stage_cust_bcc=isset($post_data['email_specific_bcc'])?$post_data['email_specific_bcc']:'';
                        $get_formated_custom_cc_bcc=$this->get_specific_cc_bcc_values($post_stage_cust_cc,$post_stage_cust_bcc);
                        if(isset($get_formated_custom_cc_bcc['cust_cc'])&&$get_formated_custom_cc_bcc['cust_cc']!=NULL)
                        $post_data['postdata']['stage_cust_cc']=$get_formated_custom_cc_bcc['cust_cc'];
                        if(isset($get_formated_custom_cc_bcc['cust_bcc'])&&$get_formated_custom_cc_bcc['cust_bcc']!=NULL)
                        $post_data['postdata']['stage_cust_bcc']=$get_formated_custom_cc_bcc['cust_bcc'];
                        $post_data['postdata']['stage_template_to_mail']=$post_data['email_replay_to'];

                        $email_data= [
                            'type'=>'custom',
                            'action'=>'send',
                            'email_temp'=>'global',
                            'action'=>'send',
                            'email_with_login'=>TRUE,
                            'user_id'=> $send_mail_to_detail['usr_ids'],
                            'post_data'=>$post_data,
                            'template'=> 'change_copyright',
                            'article_id'=>$art_id,
                            'custom_data'=>[
                                'artp_id' => $artp_id,
                                'esl_etmp_action' => 'change_copyright',
                                'change_copyright' => true
                            ],
                        ];
                        $this->master_email_details($email_data);
                        // Task #3393 Copyright Aipp New tile for author
                        $article_update = array(
                            'art_copyright_request' => 'y'
                        );
                        $Articles::update_record($article_update,"art_id={$art_id}", $user_data);
                        $dataarray = array(
                            'crr_art_id' => $art_id,
                            'crr_request_to' => $art_data->art_submitted_by,
                            'crr_request_from' => $user_id,
                            'crr_request_status' => 'r'
                        );

                        Copyright_request::insert_record($dataarray, $user_data);
                        DB::commit();
                        return  $this->success('Success',200,['msg'=>'Email send to author']);
                    } else {
                        DB::rollback();
                        return $this->warning('Warnings',200,['msg'=>'Not defined email template properly'],'warning');
                    }
                } else {
                    DB::rollback();
                    return $this->warning('Warnings',200,['msg'=>'Not defined email template properly'],'warning');
                }                
            }else {
                DB::rollback();
                return $this->warning('Warnings',200,['msg'=>'Not defined email template properly'],'warning');
            }


            }
        } catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }

    public function get_copyright_email_template(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
                'jnl_code' => 'required',
                'art_id' => 'required',
                'art_type_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
          
            if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' ) {
                $jnl_id =   Rv_decrypt($request->jnl_id);
                $art_id =   Rv_decrypt($request->art_id);
                $art_type_id =  Rv_decrypt($request->art_type_id);
                $Email_templates    =   new \App\Models\Email_templates();
                $current_user = $this->get_current_user_details();
                $record    =   $Email_templates::get_single_record('*', "etmp_name ='change_copyright'");
                $return_arr =   [
                    'email_count'=>'no_record'
                ];
        
                if (!empty($record)) {
                  
                    $email_data = new stdClass;
                    $email_data->email_templates_config = $this->email_templates_config();
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->artp_id = $art_type_id;
                    $email_data->user_role_tags = $this->user_role_tags();
                    $email_data->article_id =  $art_id; 
                    $subject = $record->etmp_subject;
                    $content =$record->etmp_email_template;
                    
                    $user_titles = $this->UserConfigdata('titles')['titles'];
                    if(isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                    $email_data->cfty_unique_hide_control_label_email=$this->current_client->functionality->cfty_unique_hide_control_label_email;

                    $content    =   $this->generate_email_data_from_keys($email_data, $content, $current_user, $user_titles, TRUE);
                    $subject    =   $this->generate_email_data_from_keys($email_data, $subject, $current_user, $user_titles, TRUE);
                    preg_match_all('/##([^##]*)##/', $content, $matches);
                    $keys = $matches[1];
                    for ($i = 0; $i < count($keys); $i++) {
                        $element = $keys[$i];
                        if(!empty($element))
                        {
                        $tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$content);
                        $content = $tmpl_data;
                        }
                    }
                    $body = str_ireplace('##', '', $content);
                    $body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
                    $content=  str_ireplace('</button></button>','</button>', $body);
                    $Authorize  =   new \App\Models\Authorize();
                    $Articles   =   new \App\Models\Articles();
                    $tables =   [
                        'main_table'    =>  ($Articles)->getTable(),
                        'join_table'    =>  [
                           ($Authorize)->getTable() =>  ['art_submitted_by','usr_id'] 
                        ]
                    ];
                    $user_email =   $Articles::get_results_using_joins($tables,'usr_email','art_id = ?','single',binding_arr:[$art_id]);
                   
                    $reply_to=Config::get('clients.'.$this->current_client->clnt_client_code.'.email.email_settings')['reply_to_email'];        
                    //Task #3448 Issues in Change copyright notification email template start bug 6
                    if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
                    {
                    $role_cond = 'role_assigned_role NOT IN ("system", "author","reviewer")';
                    
                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow = Config::get($workflow_config);

                    $reviewflow = $review_flow['author_submission'];
                    if(isset($reviewflow['stage_for']))
                    {
                            if($reviewflow['stage_for'] == 'review')
                            {
                                $role_cond.=' and FIND_IN_SET("r", role_used_in)';
                            }
                            elseif($reviewflow['stage_for'] == 'manageproduction')
                            {
                                $role_cond.=' and FIND_IN_SET("p", role_used_in)';
                            }
                    }
                    $Roles=new \App\Models\Roles();
                    $user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                    if (!empty($user_roles))
                    {
                        foreach ($user_roles as $usrole)
                        {
                            $role_label = "All " . $usrole->role_name . "s";
                            $cc_roles[$usrole->role_name] = $role_label;
                            $bcc_roles[$usrole->role_name] = $role_label;
                        }
                    }
                }
              //Task #3448 Issues in Change copyright notification email template end bug 6
                    $cc_roles['Custom_cc'] = 'Specific email ID';
                    $bcc_roles['Custom_bcc'] = 'Specific email ID';
                    $recipient_roles    =   WorkflowTrait::get_email_tmpl_additional_recpient()['possible_email_tmpl_additional_recipient'];
                    unset($recipient_roles['submit_author'],$recipient_roles['article_authors']);
                    $return_arr = [
                        'status' => 'success',
                        'cc_roles' =>$cc_roles,
                        'bcc_roles'=>$bcc_roles,
                        'too' => $record->etmp_notification,
                        'mailtousers' => $recipient_roles,
                        'to_cc' => json_decode($record->etmp_cc),
                        'to_bcc' => json_decode($record->etmp_bcc),
                        'cust_cc' => explode(',',$record->etmp_cust_cc),
                        'cust_bcc' => explode(',',$record->etmp_cust_bcc),
                        'reply_to' => $reply_to,
                        'subject' => $subject,
                        'content' => $content,
                        'email_count'=>1
                    ];
                    return $this->success('Success',200,$return_arr);
                }
                return $this->warning('Warnings',200,$return_arr,'warning');
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function change_copyright_confirm($data)
    {   
        $jnl_id =   $data['jnl_id'];
        $art_id =   $data['art_id'];
        $jnl_code = $data['jnl_code'];
        $Email_templates    =   new \App\Models\Email_templates();
        $Articles   =   new \App\Models\Articles();
        $artp_id    =   $Articles::get_single_record('art_artp_id','art_id = ? ',binding_arr:[$art_id])->art_artp_id;
        $record    =   $Email_templates::get_single_record('*', "etmp_name ='change_copyright_confirmation'");
        if ($record) {
            $send_mail_to_detail    =   $this->send_email_to($record->etmp_notification,$jnl_id,$artp_id,$art_id);
            if (isset($send_mail_to_detail)) {
                $user_id =   explode(',',$send_mail_to_detail['usr_ids']);
                $user_email      =  explode(',',$send_mail_to_detail['email_ids']);
                foreach ($user_email as $key => $value) {
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => TRUE,
                        'user_id' => $user_id[$key],
                        'empt_name' => 'change_copyright_confirmation',
                        'jnl_user_role'=>array(
                            // 'core_role'=>$request->core_role,
                            // 'role_name'=>$request->role_name,
                            'jnl_journal_code'=> $jnl_code
                        ),
                        'custom_data' => array(
                            'user_email' => $value,
                            'article_id' => $art_id,
                            'jnl_id'=> $jnl_id,
                            'jnl_code'=> $jnl_code,
                            'artp_id'=> $artp_id,
                            'etmp_notification' => $record->etmp_notification,
                            'esl_etmp_action' => 'confirm_copyright'
                        )
                    );
                    $this->master_email_details($email_data);
                }
            }
        }
    }

}
