<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Payment_order;
use App\Models\Journals;
use App\Models\Articles;
use App\Models\Article_types;
use App\Models\Article_flow;
use App\Models\Generic_flows;
use App\Models\Authors;
use App\Models\Authors_affiliation;
use App\Models\Copyright_master;
use App\Models\Copyright;
use App\Models\Journal_metadata;
use App\Models\Roles;
use App\Models\User;
use App\Models\User_emails;
use App\Models\Article_funder_details;
use App\Models\Funders;
use App\Models\Email_templates;
use App\Models\Journal_settings;
use App\Models\Article_type_advance_options;
use App\Models\Unassign_reviewer;
use App\Models\Ithenticate_autosubmission;
use App\Models\Article_pdf;
use App\Models\Ftp;
use App\Models\Email_send_log;
use App\Models\Research_integrity_reports;
use Illuminate\Support\Facades\Storage;
use DB;
use Config;

use App\Http\Traits\UtilityTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\GeneralEmailTrait;
use App\Http\Traits\IthenticateTrait;
use App\Http\Traits\StagemovementTrait;
use App\Http\Traits\RightslinkTrait;
use App\Http\Traits\ReviewerListTrait;
use Illuminate\Support\Facades\URL;
use \stdClass;
use Illuminate\Support\Str;
use App\Http\Traits\RemoteConnectionTrait;
use App\Http\Traits\SubmissionTrait;
use App\Http\Traits\ResearchIntegrityTrait;

use DateTime;
use DateTimeZone;
use GuzzleHttp\Client;
use App\Http\Traits\General_ConfigTraits;
use App\Models\Reports_model;
use App\Models\Reports_email;
use App\Http\Controllers\Manage_Reports_Api;
//use DateTime;
use DOMDocument;
use Mpdf\Tag\Em;
use App\Http\Services\ConveyService;
use App\Models\Report_email_sent_log;
use Carbon\Carbon;

/*
use JWTAuth;
use JWTAuthException;
use App\Models\User;
use App\Models\Country;
use App\Models\Flags;
use App\Models\User_affiliations;
use App\Models\User_global_flags;
use Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Crypt;
use App\Http\Traits\StandaloneDataTrait;
use App\Http\Traits\GeneralEmailTrait;
use App\Http\Traits\SendGlobalEmailFunctionTrait;
use App\Http\Traits\General_ConfigTraits;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendEmail;
use App\Models\Email_templates;
//use App\Models\Journals;
use App\Models\User_unregister;
use Jenssegers\Agent\Agent;
*/

class Manage_Cron_Api extends Controller
{

	use UtilityTrait;
	use WorkflowTrait;
	use GeneralEmailTrait;
	use IthenticateTrait;
	use StagemovementTrait;
	use RightslinkTrait;
	use RemoteConnectionTrait;
	use SubmissionTrait;
	use ResearchIntegrityTrait;
	use ReviewerListTrait;

    public function repost_manuscript_data()
	{
		try
		{
			$condition = ' pmt_ord_art_id IS NOT NULL AND pmt_ord_manuscript_id IS NULL AND pmt_ord_completed_date IS NULL AND aflw_status != \'c\' AND jnl_journal_status = \'y\' AND jwf_stage_type = \'payment\' ';
			
			$payment_failed_records = Payment_order::get_payment_failed_records('rvw_payment_order.*',$condition);
			if(count($payment_failed_records) > 0)
			{
				$author_table = (new \App\Models\Authors())->getTable();
				$Authors_affiliation_table = (new \App\Models\Authors_affiliation())->getTable();
				$Users = (new \App\Models\User())->getTable();
				//$Article_funder_details = (new \App\Models\Article_funder_details())->getTable();
				
				$user_arr = array(
					'user_id' => 0,
					'proxy_user_id' => 0
				);

				foreach($payment_failed_records as $payment_failed_record)
				{
					$article_id = $payment_failed_record->pmt_ord_art_id;
					$order_id = $payment_failed_record->pmt_ord_id;
					$metadata = array();
					$rightslink_config_arr = array();
					$copyright_licence_name = '';
					$article_basic_data = Articles::get_article_data($article_id);
					$author_oa_role = '';
					
					if (!empty($article_basic_data))
					{
						$journal_code = $article_basic_data->jnl_journal_code;
						$cnd = 'crt_art_id = '.$article_id;
						$copyright_details = Copyright::get_copyright($cnd,'crtm_license_name',TRUE);
						if (!empty($copyright_details))
						{
							$copyright_licence_name = $copyright_details->crtm_license_name;
						}
						
						//#4544 Manage author data listing (normalization)
						$select_author = 'auth_corr_author,usr_first_name as auth_first_name,usr_last_name as auth_last_name,usr_email as auth_email,auth_id,auth_usr_id,auaff_department,auaff_company,auaff_ringgold_id,auaff_address_line1,auaff_address_line2,auaff_cnt_id,auaff_postal_code,auaff_phone';

						//#4544 Manage author data listing (normalization)
						
						$tables = array(
							'main_table' => $author_table,
							'join_table' => array(
								$Authors_affiliation_table => array('auaff_auth_id', 'auth_id', 'left'),
								$Users => array('auth_usr_id', 'usr_id', 'left')
							)
						);
						$condition = 'auth_art_id = '.$article_id;
						$auth_aff_data = Authors::get_results_using_joins($tables,$select_author,$condition,'all',NULL,NULL,'',NULL,NULL,FALSE,'auth_id');

						$funder_key = array();
						
						$criteria = "afd_art_id='$article_id' GROUP BY afd_funder_id";
						$select_criteria = "afd_funder_id,GROUP_CONCAT(CONCAT(afd_grant_number)) as afd_grant_number";
						$article_funder_records = Article_funder_details::get_all_records($select_criteria, $criteria);

						if (!empty($article_funder_records)) 
						{
							//$funders = count($article_funder_records);
							
							$select = '(case when length(funder_location)=0 then funder_name else CONCAT(funder_name, " (", `funder_location`, ")" ) end )as value,`funder_name`, `funder_unique_id` as `unique_id`,`funder_location` as `location`, `funder_uri` as `uri`, `funder_id` as `id`';

							foreach ($article_funder_records as $af_val)
							{
								$funder_data_arr = array();
								$grants_key = array();
								$where = 'funder_id = '.$af_val->afd_funder_id;
								$funder_val = Funders::get_single_record($select, $where);
								$funder_data_arr['funder']['name'] = $funder_val->funder_name;
								$funder_data_arr['funder']['identifiers'] = array();
								array_push($funder_data_arr['funder']['identifiers'],  ['type' => 'FUNDREF','value' => '10.13039/'.$funder_val->unique_id]);
								$myArray = explode(',', $af_val->afd_grant_number);
								if(count($myArray)>0)
								{
									for($i=0;$i<count($myArray);$i++)
									{
										array_push($grants_key,$myArray[$i]);
									}
								}
								$funder_data_arr['numbers'] = $grants_key;
								array_push($funder_key, $funder_data_arr);
							}
						}
						$authors_key = array();
						if (count($auth_aff_data) > 0)
						{
							$authors = array();
							foreach ($auth_aff_data as $auth_value)
							{
								$primary = false;
								$auth_data_arr = array();
								//$auth_aff_arr = array();
								if ($auth_value->auth_corr_author == 'y')
								{
									$primary = true;
								}
								$auth_data_arr['primary'] = $primary;
								$auth_data_arr['firstName'] = $auth_value->auth_first_name;
								$auth_data_arr['lastName'] = $auth_value->auth_last_name;
								$auth_data_arr['emailAddress'] = $auth_value->auth_email;

								if(isset($auth_value->auaff_company) && $auth_value->auaff_company != NULL)
								{
									$auth_data_arr['institutionName'] = $auth_value->auaff_company;

								}
								if(isset($auth_value->auaff_ringgold_id) && $auth_value->auaff_ringgold_id != NULL)
								{
									if($auth_value->auaff_ringgold_id ==0)
									{
										$auth_data_arr['institutionIdentifiers'] = array(array('type'=>'OTHER','value'=>$auth_value->auaff_ringgold_id));
									}else{
										$auth_data_arr['institutionIdentifiers'] = array(array('type'=>'RINGGOLD','value'=>$auth_value->auaff_ringgold_id));
									}
								}
								$address = array();
								if(isset($auth_value->auaff_address_line1) && $auth_value->auaff_address_line1 != NULL)
								{
									$address['address1'] = 	 $auth_value->auaff_address_line1;
								}
								if(isset($auth_value->auaff_address_line2) && $auth_value->auaff_address_line2 != NULL)
								{
									$address['address2'] =  $auth_value->auaff_address_line2;
								}
								if(isset($auth_value->auaff_cnt_id) && $auth_value->auaff_cnt_id != NULL)
								{
									$address['country'] =  $auth_value->auaff_cnt_id;

								}
								if(isset($auth_value->auaff_postal_code) && $auth_value->auaff_postal_code != NULL)
								{
									$address['zip'] =  $auth_value->auaff_postal_code;
								}

								if(!empty($address))
								{
									$auth_data_arr['address'] = $address;
								}
								array_push($authors_key, $auth_data_arr);
								array_push($authors, $auth_value->auth_usr_id);
							}

							$author_oa_role = UtilityTrait::get_oa_discount_role_for_article($article_basic_data->jnl_id, $authors);
						}
						
						$cond = array(
							'jm_client_id'=>$this->current_client->clnt_id,
							'jm_journal_code'=>$journal_code
						);
						$meta_id='';
						$cond_hornal = 'jnl_metadata_id IS NOT NULL AND jnl_id ='.$article_basic_data->jnl_id;
						$journalmetaid =Journals::get_single_record('jnl_metadata_id', $cond_hornal);
						if(!empty($journalmetaid))
						{
							$meta_id=$journalmetaid->jnl_metadata_id;
							$form_select = 'gdata_label as jm_meta_name,gdata_display_data as jm_meta_value';
							$where ='gncf_id ='.$meta_id;
							$formatted_journal_code = '_' . $journal_code;
            				$Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
							$Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
							$details_tables = array(
								'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
								'join_table' => array(
								$Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
								$Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id'),
								)
							);
						$metadata = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', 'gdata_data_order,gdata_posted_date asc', NULL, '', NULL, NULL, TRUE);
						
						//$metadata = Journal_metadata::get_all_records_with_bind_cond('jm_meta_name,jm_meta_value', $cond);	

						if (count($metadata) > 0)
						{
							$meta_journal_issn = $meta_journalcode = $work_order = $product_code = '';

							if (isset($this->current_client->functionality->cfty_rightslink_api_v2) && $this->current_client->functionality->cfty_rightslink_api_v2 == 'y')
							{
								$rightslink_data = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
								$cfty_rightslink_api_v2=TRUE;
							}else{
								$rightslink_data = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
								$cfty_rightslink_api_v2=FALSE;
							}
							
							$rightslink_data  = Config::get($rightslink_data);
							
							foreach ($metadata as $mvalue)
							{
								switch($mvalue->jm_meta_name)
								{
									case 'ISSN': $meta_journal_issn = $mvalue->jm_meta_value;
										break;
									case 'E-ISSN' : $meta_journalcode = $mvalue->jm_meta_value;
										break;
									case 'work_order': $work_order = $mvalue->jm_meta_value;
										break;
									case 'product_code': $product_code = $mvalue->jm_meta_value;
										break;
								}
							}
							foreach ($rightslink_data as $key => $rightslink_value)
							{
								if ($rightslink_value['type'] == 'static')
								{
									$rightslink_config_arr[$key] = $rightslink_value['value'];
								}
								if ($rightslink_value['type'] == 'dynamic')
								{
									if ($rightslink_value['value'] == 'single')
									{
										$result = '';
										switch ($key)
										{
											case 'journalCode' : $result = $meta_journalcode; //E-ISSN
												break;
											case 'journalTitle' : $result = $article_basic_data->jnl_journal_name;
												break;
											case 'externalManuscriptId' : $result = $article_basic_data->art_code;
												break;
											case 'articleTitle' : $result = str_replace(array('&lt;p&gt;','&lt;/p&gt;','<p>','</p>'),'',$article_basic_data->art_title);
												break;
											case 'manuscriptType' : $result = $article_basic_data->artp_article_type;
												break;
										}
										$rightslink_config_arr[$key] = $result;
									}
									elseif ($rightslink_value['value'] == 'multiple')
									{
										switch ($key)
										{
											case 'articleIdentifiers' :
												for($i=0; $i < count($rightslink_value['keys']); $i++)
												{
													if($rightslink_value['keys'][$i]['type'] == 'DOI')
													{
														$rightslink_value['keys'][$i]['value'] = $article_basic_data->art_doi;
													}
													elseif($rightslink_value['keys'][$i]['type'] == 'PII')
													{
														$rightslink_value['keys'][$i]['value'] = $work_order;
													}
													else
													{
														$rightslink_value['keys'][$i]['value'] = "No value";
													}
												}
												break;
											case 'publicationIdentifiers' :	
												for($i=0; $i < count($rightslink_value['keys']); $i++)
												{
													if($rightslink_value['keys'][$i]['type'] == 'ISSN')
													{
														$rightslink_value['keys'][$i]['value'] = $meta_journal_issn;
													}
													elseif($rightslink_value['keys'][$i]['type'] == 'E-ISSN')
													{
														$rightslink_value['keys'][$i]['value'] = $meta_journalcode;
													}
													elseif($rightslink_value['keys'][$i]['type'] == 'DOI')
													{
														$rightslink_value['keys'][$i]['value'] = $article_basic_data->art_doi;
													}
													else
													{
														$rightslink_value['keys'][$i]['value'] = $product_code;
													}
												}
												break;
											case 'licenses' : $rightslink_value['keys'][0]['value'] = $copyright_licence_name;
												break;
											case 'authors' : $rightslink_value['keys'] = $authors_key;
												break;	
											case 'other' :	
												$publisher_role_namearray = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.publisher_role_name';
                                       			$publisher_role_name  = Config::get($publisher_role_namearray);
												if(!empty($author_oa_role))
												{
													$rightslink_value['keys']['oaAccess'] = TRUE;
													$rightslink_value['keys'][$publisher_role_name] = $author_oa_role;
												}
												else
												{
													$rightslink_value['keys']['oaAccess'] = FALSE;
													$rightslink_value['keys'][$publisher_role_name] = '';
												}
												break;
										}
										$rightslink_config_arr[$key] = $rightslink_value['keys'];
									}
									elseif ($rightslink_value['value'] == 'funders' && !empty($funder_key))
									{
										switch ($key)
										{
											case 'grants' :	$rightslink_value['keys'] =$funder_key;
											break;	
										}
										$rightslink_config_arr[$key] = $rightslink_value['keys'];
									}
								}
							}

							$payment_status_data = '';
							$payment_status_arr = array();
							$payment_status_data = RightslinkTrait::post_manuscript($rightslink_config_arr,$this->current_client->clnt_client_code,$cfty_rightslink_api_v2);
							$manuscript_id = NULL;
							if ($payment_status_data != '')
							{
								$payment_status_arr = json_decode($payment_status_data);
								if (!empty($payment_status_arr))
								{
									if (isset($payment_status_arr->manuscriptId))
									{
										$manuscript_id = $payment_status_arr->manuscriptId;
									}
									if(isset($payment_status_arr->error))
									{
										$requestdata = json_encode($rightslink_config_arr);
										$subject = 'Rightslink payment  failed - '.$this->current_client->clnt_client_name;
										$body = '<p>Rightslink failed details  <br>';
										$body .= 'Client : ' . $this->current_client->clnt_client_name . '</p>';
										$body .= 'Request :'. $requestdata .' </p>';
										$body .= '<p>Error <br>'. $payment_status_data . '<p>';

										$this->send_email_to_team_review($subject,$body);
									}
								}
							}
							if ($manuscript_id != NULL)
							{
								$payment_details = array(
									'pmt_ord_manuscript_posted_date' => date('Y-m-d H:i:s'),
									'pmt_ord_manuscript_id' => $manuscript_id
								);
								$cond = array(
									'pmt_ord_id'=>$order_id
								);
								
								$update_result = Payment_order::update_record($payment_details, $cond, $user_arr);
								if ($update_result)
									echo date('d-m-Y H:i:s') . ' : Article details posted in rightslink successfully ';
							}
							else
							{
								echo date('d-m-Y H:i:s') . ' : Article details posting in rightslink failed ';
							}
						}
					}
					}
				}
			}
			else
			{
				echo date('d-m-Y H:i:s') . ' : No failed records to repost. ';
			}
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',422,$e);
		}
	}

	public function auto_decline_invitation($auto_decline=FALSE)
	{
		try
		{
			if($auto_decline == FALSE)
			{
				$invitations = Article_flow::check_invitation_expire();
				$auto_decline_remark = 'timeout';
			}
			else
			{
				$select = 'art_id, artp_id,jnl_journal_code,jnl_id, aflw_id, aflw_usr_id';
				$where = " aflw_status = 'i' ";
				$invitations = Article_type_advance_options::get_review_close_flow_id($select,$where); //get flw_ids to close review
				$auto_decline_remark = 'auto_decline_after_decision_period';
			}
			
			if (count($invitations) > 0)
			{
				$today = date('Y-m-d H:i:s');
				
				$decline_send_count = 0;
				$cron_default = array(
					'user_id' => 0,
					'proxy_user_id' => 0); //default value for seting current user data

				ini_set('max_execution_time', 300);
				$cond = 'etmp_name = \'auto_decline_invitation\' AND etmp_notification = \'User\'';
				$email_template = Email_templates::get_single_record('*', $cond);
			
				$parent_ids = array();
			
				foreach ($invitations as $invitation)
				{
					if($auto_decline==FALSE)
					{
						//feature#626-Auto decline/unassign reviewer on passing due date
						$invitation->remaining_days = $this->check_tat_for_auto_decline_unassign($invitation);
					}
					
					if ((isset($invitation->remaining_days) && $invitation->remaining_days <= 0) || ($auto_decline==TRUE))
					{
						$cond = 'aflw_id = '.$invitation->aflw_id;
						$flowStatus = Article_flow::update_record(array(
							'aflw_status' => 'd',
							'aflw_returned_date' => $today,
							'aflw_remarks' => $auto_decline_remark,
							'aflw_proxy_id' => 0), $cond, $cron_default);

						//Task #122  The article is not listed for the privileged user after it is rescinded
						if($flowStatus)
						{
							$this->mngReviewerversion($invitation->art_id,$invitation->aflw_id,$invitation->aflw_usr_id,false);	
						}
						
						$decline_send_count++;
						//} need to send mail only when decline review
						
						$select = 'art_id,jnl_journal_code,jnl_id, aflw_id,art_artp_id,aflw_parent_flow_id,jwf_who_can_invite,jwf_parent_user_roles,jnl_standalone_group,jwf_avoid_email_notifications_to_roles';
						
						$article_details = Articles::get_article_details($select, $cond);
					
						if(!empty($article_details))
						{
							$user_id = $invitation->aflw_usr_id;
							$article_details = $article_details[0];
							$article_id = $article_details->art_id;
							
							if($auto_decline==FALSE)
							{
								/* #625 Queue system for shortlisted reviewers auto invitation function */
								if (isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y')|| isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))
								{
									$array_rvwer_details=array();
									$array_rvwer_details['article_id']=$article_id;
									$array_rvwer_details['artflow_id']=$invitation->aflw_id;
									$array_rvwer_details['jnl_id']=$article_details->jnl_id;
									$array_rvwer_details['parentflow_id']=$invitation->aflw_parent_flow_id;
									$array_rvwer_details['user_data']=array( 'user_id' => $invitation->aflw_usr_id, 'proxy_user_id' => $invitation->aflw_usr_id);
									$array_rvwer_details['jnl_data'] = Journal_settings::get_essential_journal_settings($article_details->jnl_journal_code);
									
									$this->auto_invite_reviewer($array_rvwer_details,TRUE);

								}
								
								/** Bug #2048 - Trigger email to AE while decline **/
								$rev_cnd = 'aflw_status IN ("i","a","c") AND aflw_parent_flow_id ='.$article_details->aflw_parent_flow_id;
								$reviews_completed = Article_flow::get_single_record('count(aflw_id) as cnt',$rev_cnd);
								
								$parent_st_cnd = 'aflw_id = '.$article_details->aflw_parent_flow_id;
								$parent_stage = Article_flow::get_single_record('aflw_stage_min_users',$parent_st_cnd);
								
								if($reviews_completed->cnt < $parent_stage->aflw_stage_min_users && !in_array($article_details->aflw_parent_flow_id,$parent_ids))
								{
									$current_user = array('user_id'=>$user_id,'proxy_user_id'=>0);
									$parent_ids[] = $article_details->aflw_parent_flow_id;
									$this->send_decline_notification_email($article_details,$current_user,TRUE);
								}
							}
							/** Bug #2048 - Trigger email to AE while decline **/
							$article_id = $article_details->art_id;
							
							if(!empty($email_template))
							{
								$custom_data = array(
									'jnl_id'=>$article_details->jnl_id,
									'jnl_code'=>$article_details->jnl_journal_code,
									'article_id'=>$article_id,
									'artp_id'=>$article_details->art_artp_id,
						
								);
								$email_data = array(
									'type' => 'global',
									'action' => 'send',
									'email_with_login' => FALSE,
									'user_id' => $invitation->aflw_usr_id,
									'empt_name' => $email_template->etmp_name,
									'custom_data' => $custom_data
								);
						
								$this->master_email_details($email_data);
							}
						}
					}
				} 
				if ($decline_send_count > 0)
					echo date('d-m-Y H:i:s') . ' : '.$decline_send_count.' Invitation declined successfully</br>';
				else
					echo 'No records found</br>';
				
			}
			else
			{
				echo date('d-m-Y H:i:s') . ' : Cron job executed</br>';
			}

			/*
                 * feature#626-Auto decline/unassign reviewer on passing due date
                 * If tat is defined for a review stage and value is 0 then unassignment of the reviewer is performed immediatly or after passing both duedate and TAT
                 */
			if ((!isset($this->current_client->functionality->cfty_auto_decline_only) || (isset($this->current_client->functionality->cfty_auto_decline_only) && $this->current_client->functionality->cfty_auto_decline_only != 'y')) && $auto_decline==FALSE)
			{
				$this->auto_review_close(TRUE);
			}	
            
		}
		catch(\Exception $e)
		{
			
			return  $this->failure('Failed',422,$e);
		}
	}

	//feature#626-Auto decline/unassign reviewer on passing due date
	function check_tat_for_auto_decline_unassign($data_set)
	{
		/*
		 * TAT for auto decline/unassigned is defined in the review stage
		 * after passing duedate checks any days available to keep the invidation/assignment for a certain period or not
		 */
		$remaining_days = $data_set->remaining_days;
		if($data_set->jwf_enable_tat_for_auto_decline == 'y' && $data_set->remaining_days < 0)
		{
			  $remaining_days += $data_set->jwf_tat_decline;
		}
		return $remaining_days;
	}

	/*
         * Modified for the feature#626-Auto decline/unassign reviewer on passing due date
         * This cron function is used to serve two different actions,
         * First, function can be called independently to unassign unsubmitted reviewers and also to close the review after a decision is made (also check the review open after decision period)
         * Second, as a function call from auto_decline_invitation(), if auto decline/unassign after duedate is checked in the review stage, with respect to the TAT for auto decline/unassign value the invitations should be auto declined after due date and also unassignment should be performed in the same way.
         */
	public function auto_review_close($auto_unassign=FALSE)
	{
		try
		{
			if($auto_unassign==FALSE)
			{
				$this->auto_decline_invitation(TRUE);
				$select = 'art_id, artp_id,jnl_journal_code,jnl_id, aflw_id, aflw_usr_id';
				$where = " aflw_status = 'a' ";
				//DB::enableQueryLog();
				$all_ids = Article_type_advance_options::get_review_close_flow_id($select,$where); //get flw_ids to close review
				//$query = DB::getQueryLog();
				//$query = end($query);exit
				$email_tmpl = 'auto_unassign';
				$unassign_remark = 'Auto close review';
			}
			else
			{
				/*/*
				* feature#626-Auto decline/unassign reviewer on passing due date
				* get all the reviewer who has passed the duedate and not submitted and also checks if the TAT for auto-decline/unassignment is approved for this stage or not.
				*/

				$all_ids = Article_flow::check_review_submittion_expire();
				$email_tmpl = 'auto_unassign_after_duedate_and_tat';
				$unassign_remark = 'auto_unassign_after_duedate_and_tat';
			}


			$updated_rows = 0;

			if (!empty($all_ids))
			{
				$cron_default = array(
					'user_id' => 0,
					'proxy_user_id' => 0); //default value for seting current user data

				$data = array(
					'aflw_status' => 'g',
					'aflw_remarks' => $unassign_remark,
					'aflw_proxy_id' => 0);

				//send auto unassign email to stage user
				$cond = 'etmp_name = \''.$email_tmpl.'\' AND etmp_notification = \'User\'';
				$email_template = Email_templates::get_single_record('count(etmp_id) as cnt', $cond);
				DB::beginTransaction();	
				$user_email_arr = array();
				foreach ($all_ids as $id_data)
				{
					$user_id = $id_data->aflw_usr_id;
					$insert_data = array(
							'unsn_aflw_id' => $id_data->aflw_id,
							'unsn_rvr_id' => $user_id,
							'unsn_reason' => customTrans('cron.auto_unassign_review_open'),
					);
					
					if($auto_unassign==TRUE){
						$id_data->remaining_days = $this->check_tat_for_auto_decline_unassign($id_data);
						$insert_data['unsn_reason'] = customTrans('cron.auto-unassign-after-duedate-and-tat');
					}

					if((isset($id_data->remaining_days) && $id_data->remaining_days < 0) || $auto_unassign == FALSE)
					{
						$cond = 'aflw_id = '.$id_data->aflw_id;
						Unassign_reviewer::insert_record($insert_data, $cron_default);
						$flowStatus = Article_flow::update_record($data, $cond, $cron_default);
						//Task #122  The article is not listed for the privileged user after it is rescinded
						if($flowStatus)
						{
							$this->mngReviewerversion($id_data->art_id,$id_data->aflw_id,$id_data->aflw_usr_id,false);	
						}
						$updated_rows++;

						if($email_template->cnt > 0)
						{
							$send_mail_to = '';
							
							//Task #303	Check all CRON function to optimise SQL
							if(isset($user_email_arr[$user_id]))
							{
								$send_mail_to = $user_email_arr[$user_id];
							}
							else
							{
								$cond = 'usr_id = '.$user_id;
								$reviewer = User::get_single_record('usr_email', $cond);
								if(!empty($reviewer))
								{
									$user_email_arr[$user_id] = $send_mail_to = $reviewer->usr_email;
								}
							}
							
							if($send_mail_to != '')
							{
								$custom_data = array(
									//	'confirmation_link' => $link,
									//	'esl_etmp_action'=>'coauthor_notify',
									//	'coauthor_notify'=>True,
										'jnl_id'=>$id_data->jnl_id,
										'jnl_code'=>$id_data->jnl_journal_code,
										'article_id'=>$id_data->art_id,
										'artp_id'=>$id_data->artp_id,
										'user_email' => $send_mail_to
									);
									$email_data = array(
										'type' => 'global',
										'action' => 'send',
										'email_with_login' => FALSE,
										'user_id' => $user_id,
										'empt_name' => $email_tmpl,
										/*'jnl_user_role'=>array(
										  'core_role'=>$core_role,
										  'role_name'=>$role_name,
										  'jnl_journal_code'=> $jnl_code
									  ),*/
										'custom_data' => $custom_data
									);
							
									$this->master_email_details($email_data);
							}
						}

					}
				}	
				DB::commit();
			}
		}
		catch(\Exception $e)
		{
			
			return  $this->failure('Failed',422,$e);
		}

	}

	public function autosubmit_to_ithenticate(Request $request)
	{
        try
        {
			$currentdate = date('Y-m-d');
			$criteria = "ias_status='n' AND ias_posted_date>={$currentdate} ";
			$all_pdfs = Ithenticate_autosubmission::get_all_records('*', $criteria);
			if(!empty($all_pdfs)) 
			{
				foreach ($all_pdfs as $pdf)
				{
					$this->submit_pdf_to_ithenticate($pdf);
				}
			}   
        }catch (\Exception $e) {
           
            return  $this->failure('Failed', 422, $e);
        }

    }

	/*
	* Task #925 auto generation of research integrity reports
	*/
	public function autosubmit_to_rvri(Request $request)
	{
        try
        {
			if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y') {
				// $rvri_config = 'clients.' . $this->current_client->clnt_client_code . '.research_integrity_config';
				// $rvriconfig  = Config::get($rvri_config);

				$currentdate = date('Y-m-d');

				$Rvri = (new \App\Models\Research_integrity_reports())->getTable(); 
				$Articles = (new \App\Models\Articles())->getTable(); 
				$Article_types = (new \App\Models\Article_types())->getTable();
				$Adv_options = (new \App\Models\Article_type_advance_options())->getTable();
				$join_tables = array(
					'main_table' => $Rvri,
					'join_table' => array(
						$Articles => array('art_id','rri_art_id'),
						$Article_types => array('art_artp_id','artp_id'),
						$Adv_options => array('artp_id','atotp_artp_id'),
					));
				$criteria 	= 	"rri_status='n' AND rri_posted_date>={$currentdate} ";
				$select 	= 	'art_id, art_code, rri_aflw_id, atotp_research_integrity, atotp_rvrisubmission_type';
				$group_by 	= 	'art_id';
				$articles = Research_integrity_reports::get_results_using_joins($join_tables, $select, $criteria, 'all', NULL, NULL, '', NULL, NULL, FALSE, $group_by);
				if(!$articles->isEmpty())
				{
					$artStr 	=	'';
					foreach ($articles as $art)
					{
						if($art->atotp_research_integrity == 'y' && $art->atotp_rvrisubmission_type == 'auto') {
							$artStr	.=	$art->art_code . ', ';
							$this->generateresearchintegrity($art->art_id, $art->rri_aflw_id);
						}
					}
					$trimmed = rtrim($artStr, ", ");
					return  $this->success('Success', 200, 'Research integrity cron executed successfully for the articles '. $trimmed);
				} else {
					return  $this->failure('Failed', 422, 'No articles found');
				}
			} 
        }catch (\Exception $e) {
           
            return  $this->failure('Failed', 422, $e);
        }

    }

    private function submit_pdf_to_ithenticate($pdf_data)
	{
        $Clients = new \App\Models\Clients();
        $criteria1 = "clnt_id={$pdf_data->ias_clnt_id}";
        $client_details = $Clients::get_single_record('clnt_client_code',$criteria1);
        if (!empty($client_details))
		{
            $ithenticate_config = 'clients.' . $client_details->clnt_client_code . '.ithenticate';
            $ithenticateconfig  = Config::get($ithenticate_config);
            $ithenticateconfig['retry_submission_limit'];
            if ($pdf_data->ias_retry_count > $ithenticateconfig['retry_submission_limit'])
            {
                return;
            }
           $conditiontype = "artp_id={$pdf_data->ias_artp_id}";
           $article_type_details = Article_types::get_single_record('artp_jnl_id', $conditiontype);
           $condition = "pdf_id={$pdf_data->ias_pdf_id}";
           $article_pdf_details = Article_pdf::get_single_record('pdf_art_id,pdf_aflw_id,pdf_ith_document_id',$condition);
		    if ($article_type_details != NULL && $article_pdf_details != NULL)
			{
				if($article_pdf_details->pdf_ith_document_id!=NULL)
				{
					$update_arr['ias_status'] = 'y';
					Ithenticate_autosubmission::update_record($update_arr, 'ias_id=' . $pdf_data->ias_id);
				}else{
                $result = $this->submit_to_ithenticate($pdf_data->ias_clnt_id, $article_pdf_details->pdf_art_id, $article_type_details->artp_jnl_id, $pdf_data->ias_pdf_id, NULL,$article_pdf_details->pdf_aflw_id,TRUE);
                if ($result['status'] == 'success')
				{
                    $update_arr['ias_status'] = 'y';
                   Ithenticate_autosubmission::update_record($update_arr, 'ias_id=' . $pdf_data->ias_id);
                  
					
				}else{
                    $Ithenticate_autosubmission_table = (new \App\Models\Ithenticate_autosubmission())->getTable();
                    Ithenticate_autosubmission::execute_query('
                         UPDATE ' . $Ithenticate_autosubmission_table . '
                         SET `ias_retry_count` = `ias_retry_count` + 1
                         WHERE `ias_id` = ' . $pdf_data->ias_id . '
                     ');

                }
            }
		}
        }
    }
	
	public function send_reminder()
	{
		try
		{
			$Article_flow_table = (new \App\Models\Article_flow)->getTable();
			$Stage_email_templates = new \App\Models\Stage_email_templates();
			$date_format = $this->current_client->settings->cs_date_format;
			$date_format = date_format_map($date_format);

			$remind_after = 'CASE WHEN stage_etmp_reminder_format = \'after\' AND stage_etmp_action = \'assigned_not_accepted\' AND stage_etmp_remind_after = \'i\' THEN aflw_assigned_date WHEN stage_etmp_reminder_format = \'after\' AND stage_etmp_action = \'accepted_not_completed\' AND stage_etmp_remind_after = \'a\' THEN aflw_accepted_date ELSE aflw_due_date END';
			$reviewer_remind_after = 'CASE WHEN stage_etmp_reminder_format = \'after\' AND stage_etmp_action = \'pnd_reviewer_shortlist\' AND stage_etmp_remind_after = \'d\' THEN aflw_due_date WHEN stage_etmp_reminder_format = \'after\' AND stage_etmp_action = \'pnd_reviewer_invite\' AND stage_etmp_remind_after = \'d\' THEN aflw_invite_due_date WHEN stage_etmp_reminder_format = \'after\' AND stage_etmp_remind_after = \'a\' THEN aflw_assigned_date  ELSE aflw_due_date END';

			$skipReviewCnd = ' aflw_skip_review = \'n\' ';
			$select = 'aflw_id, aflw_jwf_id, aflw_art_id, (CASE WHEN (aflw_status= \'u\') AND stage_etmp_reminder_format = \'each\' AND stage_etmp_action = \'assigned_not_accepted\' AND DATEDIFF( NOW(),aflw_assigned_date) > 0 THEN DATEDIFF( NOW(),aflw_assigned_date) WHEN stage_etmp_reminder_format = \'each\' AND stage_etmp_action = \'accepted_not_completed\' AND DATEDIFF( NOW(),aflw_accepted_date) > 0 THEN DATEDIFF( NOW(),aflw_accepted_date) WHEN (aflw_status= \'w\')  AND stage_etmp_reminder_format = \'each\' AND stage_etmp_action IN (\'pnd_reviewer_shortlist\',\'pnd_reviewer_invite\') AND DATEDIFF( NOW(),aflw_assigned_date) > 0 THEN DATEDIFF( NOW(),aflw_assigned_date) WHEN (aflw_status IN (\'a\',\'w\',\'u\'))  AND DATEDIFF(aflw_due_date, NOW()) > 0 THEN DATEDIFF(aflw_due_date, NOW()) END) AS remaining_days,jwf_who_can_invite,jwf_parent_user_roles,
		(CASE WHEN aflw_status = \'w\'  AND stage_etmp_reminder_format = \'after\' AND stage_etmp_action = \'pnd_reviewer_shortlist\' AND DATEDIFF(NOW(), '.$reviewer_remind_after.')>0 THEN DATEDIFF(NOW(), '.$reviewer_remind_after.') WHEN (aflw_status IN (\'a\',\'w\',\'u\')) AND DATEDIFF(NOW(), '.$remind_after.')>0 THEN DATEDIFF(NOW(), '.$remind_after.') END) as reminder_after, rvw_stage_email_tmpls.*, stage_etmp_content AS stage_etmp_email_template';
			$select .= ', (CASE WHEN (aflw_status= \'w\')  AND stage_etmp_reminder_format = \'each\' AND (stage_etmp_action IN (\'pnd_reviewer_shortlist\',\'pnd_reviewer_invite\')) AND DATEDIFF( NOW(),aflw_assigned_date) > 0 THEN DATEDIFF( NOW(),aflw_assigned_date) WHEN aflw_status = "w"  AND DATEDIFF(aflw_invite_due_date, NOW()) > 0 THEN DATEDIFF(aflw_invite_due_date, NOW()) END) AS invite_remaining_days,DATE_FORMAT(aflw_invite_due_date,"' . $date_format . '") AS aflw_invite_due_date,
		(CASE WHEN aflw_status =  "w" AND DATEDIFF(NOW(), '.$reviewer_remind_after.')>0 THEN DATEDIFF(NOW(), '.$reviewer_remind_after.') END) as invite_reminder_after';
			$select .= ',artp_id, art_id, art_title, artp_article_type, jnl_id, jnl_journal_name, jwf_id, aflw_id, aflw_usr_id, jwf_stage_type, aflw_status, aflw_assigned_date, aflw_accepted_date, jwf_stage_name, jwf_status_name, jwf_tat_complete, jwf_tat_accept, jnl_journal_code,jnl_standalone_group, jwf_role_id, jwf_assignment, aflw_deeplink_token';
	
	
			$normal_email_case_condition = 'CASE WHEN stage_etmp_reminder_format = \'on_due_date\' AND DATEDIFF(aflw_due_date, NOW()) = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'each\' AND DATEDIFF(aflw_accepted_date, NOW()) != 0 AND DATEDIFF(aflw_accepted_date, NOW()) % stage_etmp_remind_days = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'after\' and aflw_assigned_date IS NOT NULL AND  DATEDIFF(NOW(), '.$remind_after.') = stage_etmp_remind_days THEN TRUE WHEN stage_etmp_reminder_format = \'before\' AND  DATEDIFF(aflw_due_date, NOW()) = stage_etmp_remind_days THEN TRUE ELSE FALSE END';
			$normal_email_case_condition_pnd_reviewer = 'CASE WHEN stage_etmp_reminder_format = \'on_due_date\' AND DATEDIFF(aflw_due_date, NOW()) = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'each\' AND DATEDIFF(aflw_assigned_date, NOW()) != 0 AND DATEDIFF(aflw_assigned_date, NOW()) % stage_etmp_remind_days = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'after\' and aflw_assigned_date IS NOT NULL AND  DATEDIFF(NOW(), '.$reviewer_remind_after.') = stage_etmp_remind_days THEN TRUE WHEN stage_etmp_reminder_format = \'before\' AND  DATEDIFF(aflw_due_date, NOW()) = stage_etmp_remind_days THEN TRUE ELSE FALSE END';		
			$normal_email_case_condition_for_not_accept = 'CASE WHEN stage_etmp_reminder_format = \'on_due_date\' AND DATEDIFF(aflw_due_date, NOW()) = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'each\' AND DATEDIFF(aflw_assigned_date, NOW()) != 0 AND DATEDIFF(aflw_assigned_date, NOW()) % stage_etmp_remind_days = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'after\' and aflw_assigned_date IS NOT NULL AND  DATEDIFF(NOW(), '.$remind_after.') = stage_etmp_remind_days THEN TRUE WHEN stage_etmp_reminder_format = \'before\' AND  DATEDIFF(aflw_due_date, NOW()) = stage_etmp_remind_days THEN TRUE ELSE FALSE END';
			$normal_email_case_invite_condition = 'CASE WHEN stage_etmp_reminder_format = \'on_due_date\' AND DATEDIFF(aflw_invite_due_date, NOW()) = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'each\' AND DATEDIFF(aflw_assigned_date, NOW()) != 0 AND DATEDIFF(aflw_assigned_date, NOW()) % stage_etmp_remind_days = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'after\' and aflw_assigned_date IS NOT NULL AND  DATEDIFF(NOW(), '.$reviewer_remind_after.') = stage_etmp_remind_days THEN TRUE WHEN stage_etmp_reminder_format = \'before\' AND  DATEDIFF(aflw_invite_due_date, NOW()) = stage_etmp_remind_days THEN TRUE ELSE FALSE END';
			$where = $skipReviewCnd.' AND stage_etmp_to <> \'\' and art_delete_status = \'n\' AND art_status != \'t\' AND (CASE WHEN aflw_status = \'a\' AND stage_etmp_action = \'accepted_not_completed\' THEN ('.$normal_email_case_condition.') WHEN aflw_status = \'u\' AND stage_etmp_action = \'assigned_not_accepted\' AND stage_etmp_stage_type != \'review\' THEN ('.$normal_email_case_condition_for_not_accept.')  WHEN aflw_status = \'w\' AND stage_etmp_action = \'pnd_reviewer_shortlist\'  THEN ('.$normal_email_case_condition_pnd_reviewer.') AND aflw_stage_min_users > (select count(aflw_id) FROM '.$Article_flow_table.'  as  sub_tb  WHERE rvw_article_flow.aflw_id = sub_tb.aflw_parent_flow_id AND  sub_tb.aflw_status IN (\'u\',\'a\',\'i\',\'c\')) WHEN aflw_status = \'w\' AND stage_etmp_action = \'pnd_reviewer_invite\'  THEN ('.$normal_email_case_invite_condition.') AND (select count(aflw_id) FROM '.$Article_flow_table.'  as  sub_tb  WHERE rvw_article_flow.aflw_id = sub_tb.aflw_parent_flow_id AND  sub_tb.aflw_status IN (\'u\')) != 0 AND aflw_stage_min_users > (select count(aflw_id) FROM '.$Article_flow_table.'  as  sub_tb  WHERE rvw_article_flow.aflw_id = sub_tb.aflw_parent_flow_id AND  sub_tb.aflw_status IN (\'i\',\'a\',\'c\'))  END) ';

			//DB::enableQueryLog();
			$all_article_tmpl_details = $Stage_email_templates::get_reminder_recieve_article_data($select, $where);
			//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
			if (count($all_article_tmpl_details) > 0)
			{
	
				$send_success = 0;
				foreach ($all_article_tmpl_details as $art_tmpl_details)
				{
					$result = $this->send_email_notifications($art_tmpl_details, $art_tmpl_details);
					if($result == TRUE)
						$send_success++;
				}
				if($send_success>0)
					echo date('d-m-Y H:i:s') . ' : Reminder sent successfully ';
				else
					echo date('d-m-Y H:i:s') . ' :  No record found';
			}
			else
				echo date('d-m-Y H:i:s') . ' :  No record found';
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',422,$e);
		}
	}
	public function send_invitation_reminder()
	{
		try
		{
			$Stage_email_templates = new \App\Models\Stage_email_templates();
			$remind_after = 'CASE WHEN stage_etmp_reminder_format = \'after\' AND stage_etmp_action = \'assigned_not_accepted\' AND stage_etmp_remind_after = \'i\' THEN aflw_assigned_date ELSE aflw_due_date END';
			$select = 'aflw_id, aflw_parent_flow_id, aflw_jwf_id, aflw_art_id, IF(stage_etmp_reminder_format = \'each\',DATEDIFF( NOW(),aflw_assigned_date), DATEDIFF(aflw_due_date, NOW())) AS remaining_days,DATEDIFF(NOW(), '.$remind_after.') as reminder_after, rvw_stage_email_tmpls.*, stage_etmp_content AS stage_etmp_email_template';
			$select .= ',artp_id,art_id, art_title, artp_article_type, jnl_id, jnl_journal_name, jwf_id, aflw_id, aflw_usr_id,jwf_stage_type,aflw_status,aflw_assigned_date, aflw_accepted_date,jwf_stage_name, jwf_status_name,jwf_tat_complete,jwf_tat_accept,jnl_journal_code,jnl_standalone_group, jwf_role_id,jwf_no_of_min_users, jwf_assignment, aflw_deeplink_token';

			$where = 'aflw_status = \'i\' AND stage_etmp_action = \'assigned_not_accepted\' AND stage_etmp_to <> \'\' AND art_delete_status = \'n\' AND (CASE WHEN stage_etmp_reminder_format = \'on_due_date\' AND DATEDIFF(aflw_due_date, NOW()) = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'each\' AND DATEDIFF(aflw_assigned_date, NOW()) != 0 AND DATEDIFF(aflw_assigned_date, NOW()) % stage_etmp_remind_days = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'before\' AND  DATEDIFF(aflw_due_date, NOW()) = stage_etmp_remind_days THEN TRUE WHEN stage_etmp_reminder_format = \'after\' and aflw_assigned_date IS NOT NULL AND  DATEDIFF(NOW(), '.$remind_after.') = stage_etmp_remind_days THEN TRUE ELSE FALSE END)  ';
			//DB::enableQueryLog();
			$all_article_tmpl_details = $Stage_email_templates::get_reminder_recieve_article_data($select, $where);
			//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
			if (count($all_article_tmpl_details) > 0)
			{
			
				$success_mails = 0;
				foreach ($all_article_tmpl_details as $art_tmpl_details)
				{
					if(isset($art_tmpl_details->jwf_stage_type) && $art_tmpl_details->jwf_stage_type == 'author_submission')
					{
						$result = $this->send_email_notifications($art_tmpl_details, $art_tmpl_details);
						if ($result == TRUE)
							$success_mails++;
					}
					else{
					$users_complete_review = Article_flow::get_single_record('count(aflw_id) as completed_count',"aflw_parent_flow_id = {$art_tmpl_details->aflw_parent_flow_id} AND aflw_status = 'c'");
					$required_min_reviewers = Article_flow::get_single_record('aflw_stage_min_users',"aflw_id = {$art_tmpl_details->aflw_parent_flow_id}");
					if ($users_complete_review->completed_count < $required_min_reviewers->aflw_stage_min_users)
					{
						$result = $this->send_email_notifications($art_tmpl_details, $art_tmpl_details);
						if ($result == TRUE)
							$success_mails++;
					}
					}
				}
				if($success_mails > 0)
					echo date('d-m-Y H:i:s') . ' : Invitation reminder sent successfully ';
				else
					echo date('d-m-Y H:i:s') . ' :  No record found';
			}
			else
				echo date('d-m-Y H:i:s') . ' :  No record found';
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',422,$e);
		}
	}

	public function send_email_notifications($article_details, $template,$email_attachment=NULL)/* Part of RVRite integration: Need to keep the change log */
	{ 
		
		DB::beginTransaction(); 

		$Article_type_advance_options = new \App\Models\Article_type_advance_options;
        $Journal_setting = new \App\Models\Journal_settings();
		$User_to_journals = new \App\Models\User_to_journals();
		$Article_flow = new \App\Models\Article_flow;
		$User=new \App\Models\User();
		$accept_link='';
		$reject_link='';
		$link='';
		$tmpl_reminder_days = $template->stage_etmp_remind_days;
		$check_reminder_valid = FALSE;
		$send_mail = NULL;

		$remaining_days = $article_details->remaining_days;
		$reminder_after = $article_details->reminder_after;
		if($article_details->stage_etmp_action == 'pnd_reviewer_invite')
		{
			$remaining_days = $article_details->invite_remaining_days;
			$reminder_after = $article_details->invite_reminder_after;
		}

		if ($tmpl_reminder_days > 0)
		{
			switch ($template->stage_etmp_reminder_format)
			{
				case 'each' :
					if ($remaining_days != 0 && $remaining_days % $tmpl_reminder_days == 0)
					{
						$check_reminder_valid = TRUE;
					}
					break;
				case 'after' :
					if ($article_details->aflw_assigned_date != NULL)
					{
						if ($reminder_after == $tmpl_reminder_days)
							$check_reminder_valid = TRUE;
					}
					break;
				case 'before' :
					if ($remaining_days == $tmpl_reminder_days)
					{
						$check_reminder_valid = TRUE;
					}
					break;
			}
		}
		if($tmpl_reminder_days == 0 && $template->stage_etmp_reminder_format == 'on_due_date')
		{
			$check_reminder_valid = TRUE;
		}
 	/*TASK #4081 Part of RVRite integration: Need to keep the change log */	
	 if(isset($template->stage_etmp_action)&&$template->stage_etmp_action=='track_author_changes')
	 {
		$check_reminder_valid = TRUE;


	 }
	 /* TASK #4081 End */

		$article_title = $article_details->art_title;
		$article_id = $article_details->art_id;
		$user_id = $article_details->aflw_usr_id;
		$role_id = $article_details->jwf_role_id;
		$artp_id = $article_details->artp_id;
		$mail_send_flag = TRUE;
		$send_mail_to = '';
		$send_mail_to_usr_ids = '';
		$invite_due_date='';
		if($article_details->stage_etmp_action == 'pnd_reviewer_shortlist' || $article_details->stage_etmp_action == 'pnd_reviewer_invite' || $article_details->stage_etmp_action == 'assigned_not_accepted')
		{
			$roles = array();
			if($article_details->stage_etmp_action == 'pnd_reviewer_shortlist')
			{
				$roles = json_decode($article_details->jwf_parent_user_roles);
			}

			if($article_details->stage_etmp_action == 'pnd_reviewer_invite')
			{
				$invite_due_date=$article_details->aflw_invite_due_date;
				$roles = json_decode($article_details->jwf_who_can_invite);
			}

			if($article_details->stage_etmp_action == 'assigned_not_accepted' && !empty($article_details->jwf_role_id))
			{
				$core_role = Roles::where('role_id',$article_details->jwf_role_id)->value('role_assigned_role');
				//Task 9367 Add 'Reminder to accept' and 'Reminder to complete' in cron -- for avoid non allocated users 
				if($core_role != 'author' && $core_role != 'reviewer')
				{
					$roles = array($article_details->jwf_role_id);
				}
			}

			$to_users = $this->get_article_permitted_users($artp_id,$article_id,$roles);
			if(count($to_users['user_emails']) > 0)
			{
				$send_mail_to = implode(', ', $to_users['user_emails']);
				$send_mail_to_usr_ids = $user_id = implode(', ', $to_users['user_ids']);

				$mail_send_flag = FALSE;
			}
		}
		$this->org_base_url = URL::to('/') . '/';
		$redirect_base_url = $this->org_base_url;
		$site_url='';
		if (isset($article_details->jnl_standalone_group) && $article_details->jnl_standalone_group != NULL)
		{
			$redirect_base_url = $this->build_url_standalone($article_details->jnl_standalone_group);
			$site_url = $redirect_base_url;
		}
		$article_url = $redirect_base_url . $this->current_client->platform_type .'/' . $article_details->jnl_journal_code . '/view-article?' . encrypt_link('&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id);

	
		if ($user_id != NULL && $mail_send_flag == TRUE)
		{
			$reviewer = $User::get_single_record('usr_email',"usr_id={$user_id}");
			if ($reviewer != NULL)
			{
				$send_mail_to = $reviewer->usr_email;
				$send_mail_to_usr_ids = $user_id;
			}
			$aflw_deeplink_token = ($article_details->aflw_deeplink_token != '' ) ? $article_details->aflw_deeplink_token :  Str::random(16);;
			if (in_array($article_details->jwf_stage_type, array(
					'review',
					'pre_assessment',
					'post_assessment')) && $article_details->jwf_assignment != 'self_service')
			{
				if ($article_details->aflw_deeplink_token == '') //update new deeplink_token
					$Article_flow::update_record(array(
						'aflw_deeplink_token' => $aflw_deeplink_token),"aflw_id={$article_details->aflw_id}",NULL,NULL,'e');

				$link = $redirect_base_url . $this->current_client->platform_type .'/'. $article_details->jnl_journal_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&user_role_id=' . $role_id . '&article_flow_id=' . $article_details->aflw_id);
			}

			if ($template->stage_etmp_action == 'assigned_not_accepted' && $article_details->jwf_stage_type == 'review' && $article_details->aflw_status == 'i')
			{
				$accept_link = $redirect_base_url .$this->current_client->platform_type .'/'. $article_details->jnl_journal_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id);
				$reject_link = $redirect_base_url .$this->current_client->platform_type .'/'. $article_details->jnl_journal_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide');
			}
		}
		$aflw_accepted_date='';
		if($article_details->stage_etmp_action == 'accepted_not_completed' && isset($article_details->aflw_accepted_date) && $article_details->aflw_accepted_date != '')
		{

			$journal_date_format = $Journal_setting::get_single_record('jset_date_format',"jset_jnl_id={$article_details->jnl_id}");
			$date_format = 'd-m-y';
			if(!empty($journal_date_format))
			{
				$date_format = $journal_date_format->jset_date_format;
			}
			$aflw_accepted_date = date($date_format,strtotime($article_details->aflw_accepted_date));
		}
		$article_status_link = $article_url;
		$base_url = $redirect_base_url;
		if ($template->stage_etmp_to != 'User' && $template->stage_etmp_to != 'Custom' && $mail_send_flag == TRUE)
		{
			$cfty_retire_role = FALSE;
			if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
			{
				$cfty_retire_role = TRUE;
			}
			$send_mail_to_detail = $this->send_email_to($template->stage_etmp_to, $article_details->jnl_journal_code, $article_details->artp_id, $article_id,$cfty_retire_role,$article_details->aflw_jwf_id);
			$send_mail_to = $send_mail_to_detail['email_ids'];
			$send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
		}

		if ($check_reminder_valid == TRUE && ($send_mail_to != '' || $template->stage_etmp_to == 'Custom'))
		{
			$send_mail = TRUE;
			$prev_article_id = NULL;
			$src_jnl_id = NULL;
			if($article_details->jwf_stage_type == 'transit')
			{
				$prev_article_id = $article_id;
				$src_jnl_id = $article_details->jnl_id;
			}
	
				$custom_data=array( 
					'site_url'=>$site_url,
					'link'=>$link,
					'accept_link'=>$accept_link,
					'reject_link'=>$reject_link,
					'aflw_accepted_date'=>$aflw_accepted_date,
					'article_status_link'=>$article_status_link,
					'base_url'=>$base_url,
					'remaining_days'=>$remaining_days,
					'user_email'=>$send_mail_to,
					'prev_article_id'=>$prev_article_id,
					'src_jnl_id'=>$src_jnl_id,
					'stage_etmp_action' =>$template->stage_etmp_action,
					'stage_etmp_to' =>$template->stage_etmp_to,
					'api_name'=>'cron_job',
					'template_id'=>$template->stage_etmp_id,
					'send_attachment_data'=>$email_attachment,
					'aflw_due_date'=>$invite_due_date
					);

					$email_data=array(
						'type'=>'stage',
						'action'=>'send',
						'email_with_login'=>FALSE,
						'user_id'=> $user_id,
						'aflw_id'=>$article_details->aflw_id,
						'custom_data'=>$custom_data,
						'jnl_user_role'=>array(
							// 'core_role'=>$core_role,
							// 'role_name'=>$jnl_array['role_name'],
							'jnl_id'=>$article_details->jnl_id,
							'jnl_journal_code'=> $article_details->jnl_journal_code
						),
					);
			
					if(isset($article_details->aflw_id))
					{
						$roles_table = (new \App\Models\Roles())->getTable();
						$artflow_table = (new \App\Models\Article_flow())->getTable();
						$jnlflow_table = (new \App\Models\Generic_flows())->getTable();
						$select = 'role_id,role_name,role_assigned_role';
						$condition = array(
							'aflw_id'=> $article_details->aflw_id
						);
						$tables = array(
							'main_table' => $artflow_table,
							'join_table' => array(
								$jnlflow_table => array('aflw_jwf_id','jwf_id'),
								$roles_table => array('jwf_role_id','role_id')
							)
						);
						$role_data = Article_flow::get_results_using_joins($tables, $select, $condition, 'single');
						
						if(!empty($role_data))
						{
							$email_data['jnl_user_role']['core_role'] = $role_data->role_assigned_role;
							$email_data['jnl_user_role']['role_name'] = $role_data->role_name;
						}
					}
					$send = $this->master_email_details($email_data);
		}
	
			DB::commit();	
			if(!empty($send_mail))
				return TRUE;
			else
				return FALSE;

	}

	public function check_payment_status()
	{
		try
		{
			$move_test = TRUE;
			$select = 'pmt_ord_manuscript_id,pmt_ord_art_id';
			$cond = ' pmt_ord_manuscript_id IS NOT NULL AND pmt_ord_transaction_id IS NULL AND pmt_ord_completed_date IS NULL ';
			$pending_payment_records = Payment_order::get_all_records('*',$cond);
			
			if (count($pending_payment_records) > 0)
			{
				if (isset($this->current_client->functionality->cfty_rightslink_api_v2) && $this->current_client->functionality->cfty_rightslink_api_v2 == 'y') {
					$rightslink_data = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
					$cfty_rightslink_api_v2=TRUE;
				}else{
					$rightslink_data = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
					$cfty_rightslink_api_v2=FALSE;
				}
				
				foreach ($pending_payment_records as $pending_payment_record)
				{
					$order_details = RightslinkTrait::check_payment_status_lib($pending_payment_record->pmt_ord_manuscript_id,$this->current_client->clnt_client_code,$cfty_rightslink_api_v2);
					
					$condition = array(
						'art_id' => $pending_payment_record->pmt_ord_art_id,
						'art_delete_status' => 'n'
					);
					$article_basic_details = Articles::get_single_record_with_bind_cond('art_code',$condition);
					
					if ($order_details != '' && !empty($article_basic_details))
					{
						$order_details_records = json_decode($order_details);
						
						$payment_data_arr = array();
						
						if (isset($order_details_records->orders) && $order_details_records->orders != NULL && isset($order_details_records->orders[0]->transactionId) && $order_details_records->orders[0]->transactionId != NULL)
						{
							$transaction_details = RightslinkTrait::get_transaction_details($order_details_records->orders[0]->transactionId,$this->current_client->clnt_client_code,$cfty_rightslink_api_v2);
							
							if ($transaction_details != '')
							{
								$transaction_detail_records = json_decode($transaction_details);

								//To check the payment is completed or not
								if($transaction_detail_records->orderStatus!='')
								{
									$payment_data_arr = array(
										'pmt_ord_transaction_id' => $order_details_records->orders[0]->transactionId,
									);
									
									$update_record = $this->update_order_details($transaction_detail_records,$payment_data_arr,$pending_payment_record);
									
									if($update_record)
									{
										if($transaction_detail_records->orderStatus == 'FINISHED')
										{
											$this->initiate_payment_process($transaction_detail_records, $payment_data_arr, $pending_payment_record);
										}
										else if($transaction_detail_records->orderStatus == 'CHECKEDOUTCOMPLETE')
										{
											$message_log = $article_basic_details->art_code .' - Invoice generated [orderStatus = "'.$transaction_detail_records->orderStatus.'"]';
											echo '<br/>'.$message_log;
											RightslinkTrait::log_rightslink_call($message_log);
										}
									}
									else
									{
										echo '<br/>' . date('d-m-Y H:i:s') . ' : ' . $article_basic_details->art_code . ' failed to update payment';
									}
									
								}
								
							}
						}
						else
						{
							echo '<br/>' . date('d-m-Y H:i:s') . ' : ' . $article_basic_details->art_code . ' Payment not complete';
						}
					}
				}
			}
			else
			{
				echo '<br/>' . date('d-m-Y H:i:s') . ' : No payment requests exist. ';
			}
		}
		catch(\Exception $e)
		{
			
			return $this->failure('Failed',422,$e);
		}

	}

	public function update_order_details($transaction_detail_records,$payment_data_arr,$pending_payment_record)
	{
		if (isset($transaction_detail_records->orderStatus) && ($transaction_detail_records->orderStatus == 'CHECKOUTCOMPLETE' || $transaction_detail_records->orderStatus == 'FINISHED'))
		{
			$payment_data_arr['pmt_ord_order_date'] = $transaction_detail_records->orderDate;
			$payment_data_arr['pmt_ord_price'] = $transaction_detail_records->charges[0]->price;
			$payment_data_arr['pmt_ord_netamount'] = $transaction_detail_records->charges[0]->netAmount;
			$payment_data_arr['pmt_ord_discount'] = $transaction_detail_records->charges[0]->totalDiscount;
			$payment_data_arr['pmt_ord_tax_amount'] = $transaction_detail_records->charges[0]->taxAmount;
			$payment_data_arr['pmt_ord_currency'] = $transaction_detail_records->orderCurrency;
			$payment_data_arr['pmt_ord_payment_method'] = $transaction_detail_records->paymentMethod;
		}

		if (isset($transaction_detail_records->orderStatus) && $transaction_detail_records->orderStatus == 'FINISHED' && isset($transaction_detail_records->paymentStatusDate) && $transaction_detail_records->paymentStatusDate != NULL)
		{
			$payment_data_arr['pmt_ord_completed_date'] = $transaction_detail_records->paymentStatusDate;
		}

		if (isset($transaction_detail_records->orderStatus))
		{
			$status = $transaction_detail_records->orderStatus;
			$payment_status_arr=$this->Utility('payment_transaction_status');
			$payment_status='';
			if(array_key_exists($status,$payment_status_arr['payment_transaction_status']))
			{
				$payment_status=$payment_status_arr['payment_transaction_status'][$status];
			}
			$payment_data_arr['pmt_transaction_status'] = $payment_status;
		}

		$cond = array(
			'pmt_ord_id' => $pending_payment_record->pmt_ord_id
		);
		$current_user = array('user_id'=>0,'proxy_user_id'=>0);
		$updated_result = Payment_order::update_record($payment_data_arr, $cond, $current_user);
		return $updated_result;
	}


	public function initiate_payment_process($transaction_detail_records, $payment_data_arr, $pending_payment_record)
	{
		$Payment_discounts=new \App\Models\Payment_discounts();
		$article_basic_details = Articles::get_article_data($pending_payment_record->pmt_ord_art_id);
		if (isset($transaction_detail_records->charges[0]->appliedDiscounts))
		{
			$applied_discounts = $transaction_detail_records->charges[0]->appliedDiscounts;
			$discounts_data = array();

			if (!empty($applied_discounts))
			{
				foreach ($applied_discounts as $disc)
				{
					$displayValue= '';
					if(isset($disc->displayValue))
						$displayValue= $disc->displayValue;
					
					$discounts_element = array(
						'pmt_disc_payment_id' => $pending_payment_record->pmt_ord_id,
						'pmt_disc_type' => $disc->type,
						'pmt_disc_display_value' => $displayValue,
						'pmt_disc_amount' => $disc->amount,
						'pmt_disc_posted_by' => 0,
						'pmt_disc_posted_date' => date('Y-m-d H:i:s'));
					array_push($discounts_data, $discounts_element);	
				}
			}
			if (count($discounts_data) > 0)
			{
				$Payment_discounts::insert_batch($discounts_data);
			}
		}
		echo date('d-m-Y H:i:s') . ' : ' . $article_basic_details->art_code . ' Payment process successfull';

		$cond = 'aflw_art_id = '.$pending_payment_record->pmt_ord_art_id.' AND jwf_stage_type = \'payment\' AND aflw_returned_date IS NULL';
		$article_flow_data = Article_flow::get_article_stage_details('aflw_id,jwf_id,jwf_stage_name,jwf_temporary_status_name', $cond);

		if (isset($article_flow_data[0]))
		{
			$current_user = array('user_id'=>0,'proxy_user_id'=>0);
			$move_next_data_array['article_id'] = $pending_payment_record->pmt_ord_art_id;
			$move_next_data_array['current_jwf_id'] = $article_flow_data[0]->jwf_id;
			$move_next_data_array['current_user'] = $current_user;
			$move_next_data_array['master_flow_id'] = $article_basic_details->artp_fwm_id;
			$move_next_data_array['current_stage'] = $article_flow_data[0]->aflw_id;
			$move_next_data_array['artp_id'] = $article_basic_details->artp_id;
			$move_next_data_array['next_stage'] = NULL;
			$move_next_data_array['checkout_article'] = FALSE;
			$move_next_data_array['current_client'] = $this->current_client;
			$move_next_data_array['cron_flag'] = TRUE;

			$stage_move_result = $this->move_next_stage($move_next_data_array);

			if ($stage_move_result)
			{
				$esarray['article_id']=$pending_payment_record->pmt_ord_art_id;
				$checkdata=$this->check_espermission_access($esarray);
				if($checkdata == true)
				{
					$es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
					$es_api_data  = Config::get($es_config);
					if(isset($es_api_data['create_stage_backup']))
							{
								$apiUrl = $es_api_data['create_stage_backup'];
								$data_to_editor = array('documentId' => $pending_payment_record->pmt_ord_art_id,'currentFlowId' => $article_flow_data[0]->aflw_id,'systemType' => 1,'stage_name_privillaged' => $article_flow_data[0]->jwf_stage_name,'stage_name_non_privillaged' => $article_flow_data[0]->jwf_temporary_status_name  == NULL ? $article_flow_data[0]->jwf_stage_name : $article_flow_data[0]->jwf_temporary_status_name,'current_user' => $current_user);
								$data_to_editor = http_build_query($data_to_editor);
								$response = $this->es_curl_request($apiUrl,$data_to_editor);
								$response = json_decode($response);
							}
				}
				echo '<br/>' . date('d-m-Y H:i:s') . ' : ' . $article_basic_details->art_code . '  Article moved to next stage';
			}
			else
			{
				echo '<br/>' . date('d-m-Y H:i:s') . ' : ' . $article_basic_details->art_code . ' Move to next stage change failed';
			}
		}
		else
			echo '<br/>' . date('d-m-Y H:i:s') . ' : ' . $article_basic_details->art_code . ' Payment not complete';
	}


	public function manage_pending_payments()
	{
		try
		{
			$select = 'art_code,pmt_ord_art_id,pmt_ord_transaction_id,pmt_ord_id';
			$condition = 'pmt_ord_manuscript_id IS NOT NULL AND pmt_ord_transaction_id IS NOT NULL AND pmt_ord_completed_date IS NULL AND aflw_status <> \'c\' AND jnl_journal_status = \'y\' AND jwf_stage_type = \'payment\' '; 
			$failed_payment_records = Payment_order::get_payment_failed_records($select, $condition);

			//echo '<pre>';print_r($failed_payment_records);exit;

			if (count($failed_payment_records) > 0)
			{
				if (isset($this->current_client->functionality->cfty_rightslink_api_v2) && $this->current_client->functionality->cfty_rightslink_api_v2 == 'y')
				{
					//$rightslink_data = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
					$cfty_rightslink_api_v2=TRUE;
				}else{
					//$rightslink_data = 'clients.' . $this->current_client->clnt_client_code . '.rightslink.rightslink_data';
					$cfty_rightslink_api_v2=FALSE;
				}
				
				foreach ($failed_payment_records as $failed_payment_record)
				{
					$transaction_details = RightslinkTrait::get_transaction_details($failed_payment_record->pmt_ord_transaction_id,$this->current_client->clnt_client_code,$cfty_rightslink_api_v2);

					if ($transaction_details != '')
					{
						$transaction_detail_records = json_decode($transaction_details);
						$payment_data_arr = array();
						$update_record = $this->update_order_details($transaction_detail_records,$payment_data_arr,$failed_payment_record);

						if($update_record && isset($transaction_detail_records->orderStatus) && $transaction_detail_records->orderStatus == 'FINISHED')
						{
							$this->initiate_payment_process($transaction_detail_records, $payment_data_arr, $failed_payment_record);
						}
						else
						{
							echo '<br/>' . date('d-m-Y H:i:s') . ' : ' . $failed_payment_record->art_code . ' failed to update payment';
						}
					}
				}
			}
			else
			{
				echo date('d-m-Y H:i:s') . ' : No pending payment requests. ';
			}
		}
		catch(\Exception $e)
		{
			
			return $this->failure('Failed',422,$e);
		}
	}

	
	public function stage_import_files()
	{
		try
		{
			if(isset($this->current_client->functionality->cfty_import_stage_data_from_ftp_location) && $this->current_client->functionality->cfty_import_stage_data_from_ftp_location == 'y')
			{
				$cfty_retire_role = FALSE;
				if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
				{
					$cfty_retire_role = TRUE;
				}

				$role_arr = $this->set_all_roles_key_value();
				
				//$client_code = $this->current_client->clnt_client_code;
            	$review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            	//$review_flow  = Config::get($review_config);
				$this->review_flow = Config::get($review_config);

				$select = 'ftpm_display_name,ftpm_host_name,ftpm_user_name,ftpm_password,ftpm_enable_private_key,ftpm_private_key_path,ftpm_port,ftpm_location,ftp_import_stage_name,ftp_action_for,aflw_status,aflw_jwf_id,aflw_usr_id,GROUP_CONCAT(DISTINCT concat(`art_code`,\'{\',jwf_stage_name,\'}\')) as art_code_and_stage,art_code,artp_article_type,jnl_journal_name,jnl_journal_code,jwf_stage_name';

				$Ftp_table =(new \App\Models\Ftp())->getTable();
				$Ftp_master_table =(new \App\Models\Ftp_master())->getTable();
				$Stage_import_go_files =new \App\Models\Stage_import_go_files();
				$Stage_import_go_files_table =(new \App\Models\Stage_import_go_files())->getTable();
				$Article_flow_table =(new \App\Models\Article_flow())->getTable();
				$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
				$Articles = (new \App\Models\Articles())->getTable(); 
				$Article_types = (new \App\Models\Article_types())->getTable();
				$Journals = (new \App\Models\Journals())->getTable();
				$join_tables = array(
					'main_table' => $Ftp_table,
					'join_table' => array(
						$Ftp_master_table => array('ftp_ftpm_id','ftpm_id'),
						$Article_flow_table => array('ftp_jwf_id','aflw_jwf_id'),
						$generic_flow_table => array('ftp_jwf_id','jwf_id'),
						$Articles => array('aflw_art_id','art_id'),
						$Article_types => array('art_artp_id','artp_id'),
						$Journals => array('artp_jnl_id','jnl_id'),
					),
					'join_type' => array(
						$generic_flow_table => 'LEFT',
						$Articles => 'LEFT',
						$Article_types => 'LEFT',
						$Journals => 'LEFT',
					));

				$criteria = ' ftp_action_for IN (\'i\',\'b\') AND aflw_status IN (\'u\',\'a\')';
				$group_by = array('ftpm_host_name','ftpm_user_name','ftpm_password','ftpm_port','ftpm_location');
				
				//DB::enableQueryLog();
				$import_stage_data = Ftp::get_results_using_joins($join_tables, $select, $criteria, 'all',NULL,NULL,'',NULL,NULL,FALSE,$group_by);
				//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
				//echo '<pre>';print_r($import_stage_data);exit;

				if(count($import_stage_data) > 0)
				{
					$download_loc = 'uploads/stageImport/';
					$download_writing = 'uploads/stageImport';
					$download_reading = 'stageImport';

					$download_writing =  $this->get_upload_path($download_writing,FALSE,'storage',TRUE);
					$download_reading =  $this->get_upload_path($download_reading,TRUE,'',TRUE);

					$download_writing = $this->set_path_slash($download_writing);
					$download_reading = $this->set_path_slash($download_reading);

					$dtd_content = 'clients.' . $this->current_client->clnt_client_code . '.ReView_import_go.dtd_content';
					$dtd_content_data  = Config::get($dtd_content);

					if(!file_exists($download_writing))
					{
						$cmd = ' mkdir -p '.$download_writing;
						shell_exec($cmd);
					}
					elseif(file_exists($download_writing) && strpos($download_writing,'stageImport')>0)
					{
						shell_exec('rm -rf ' . $download_writing.'*');
					}
					

					$dtd_file_path = $download_writing.'ReView_import_go.dtd';
					file_put_contents($dtd_file_path,$dtd_content_data);

					//FTP communication details
					$remote_communicate = 'clients.' . $this->current_client->clnt_client_code . '.remote_file_transfer.stage_import';
					$remote_communicate_data  = Config::get($remote_communicate);
					
					$conn_fail_arr = array();
					
					if(file_exists($dtd_file_path))
					{
						foreach ($import_stage_data as $imp_stdatum)
						{
							//echo '<pre>';print_r($imp_stdatum);
							$ftp_location = $this->set_path_slash($imp_stdatum->ftpm_location,FALSE);
							
							$host = trim($imp_stdatum->ftpm_host_name);
							$username = trim($imp_stdatum->ftpm_user_name);
							$pass = trim($imp_stdatum->ftpm_password);
							$port = trim($imp_stdatum->ftpm_port);
							$require_private_key = array();
							
							$sftp_flag = FALSE;
							if($imp_stdatum->ftpm_enable_private_key == 'y' && $imp_stdatum->ftpm_private_key_path != '')
							{
								$sftp_flag = TRUE;
								$require_private_key['sftp_flag'] 	= $sftp_flag;

								$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
								$prefixPath = storage_path() . $file_storage_path;

								$require_private_key['key_path'] 	= $prefixPath . $imp_stdatum->ftpm_private_key_path;
							}
							//echo '<pre>';print_r($require_private_key);exit;
							$login_result = array(
								'login' => FALSE
							);

							/*
							$host = 'ftp.novatechset.com';
							$username = 'ICE';
							$pass = 'Ice1510';
							$port = 21;
							$require_private_key = array();
							*/

							if($remote_communicate_data['connection_through'] == 'normal')
							{
								$login_result = $this->remoteConneciton($host,$username,$pass,$port,TRUE,$require_private_key);
							}
							else
							{
								//shell communication
							}
							
							$ssh = $sftpkey = FALSE;
							if($login_result['login'] == TRUE)
							{
								$conn_id = $login_result['conn_id'];
								$ssh = $login_result['ssh'];
								$sftpkey = $login_result['key'];
								//$this->settoPassive($conn_id);
								
								$go_file_list = $this->getRemotefileList($conn_id, $ftp_location,TRUE,'.import.go.xml',$ssh,$sftpkey);	
								
								if(!empty($go_file_list) && count($go_file_list) > 0)
								{
									// download server file
									foreach ($go_file_list as $go_file)
									{
										$temp_file_arr = explode('/', $go_file);
										$temp_go_file = end($temp_file_arr);

										$where_cnd = 'sig_file_name = \''.$temp_go_file.'\' AND sig_status IN (\'s\',\'f\')';
										$go_file_db = $Stage_import_go_files::get_single_record('count(sig_id) as cnt',$where_cnd);
										
										if($go_file_db->cnt > 0)
											continue;

										if($ftp_location == '')
											$ftp_location = '/';	
										
										$xml_go_location = $download_writing.$temp_go_file;		
										$this->getRemote_files($conn_id, $xml_go_location, $ftp_location.$temp_go_file,$ssh,$sftpkey);
										
										sleep(3);
										if(!file_exists($xml_go_location))
											continue;

										//HERE SET DTD VALIDATION FOR STAGE IMPORT GO FILE
										$shell_cmd = 'xmllint --valid --noout ' . $xml_go_location . ' 2>&1; echo $?';
										$error = shell_exec($shell_cmd);	
										
										$error_len = strlen(trim($error));
										if ($error_len > 1 || $error != 0)
										{
											$conn_fail_arr[] = $temp_go_file.' go.xml file from HOST : '.$host.', USER : '.$username.' downloaded have DTD Validation failed. So can\'t import the Article ID{Stage} : '.$imp_stdatum->art_code_and_stage.', Journal : '.$imp_stdatum->jnl_journal_name.'('.$imp_stdatum->jnl_journal_code.') of Article type : '.$imp_stdatum->artp_article_type.' data.<br> Error list : <br>'.$error;
										}
										else
										{
											$doc = new \DOMDocument();
											$doc->formatOutput = false;
											$doc->load($xml_go_location);
											
											$xpath = new \DOMXpath($doc);
											$stage_name_node = $xpath->query("//parameter[@name='production-task-name']");
											$art_code_node = $xpath->query("//parameter[@name='manuscript-number']");
											$xml_stage_name = '';
											if($stage_name_node->length > 0)
												$xml_stage_name = $stage_name_node->item(0)->getAttribute("value");
											$xml_art_code = '';
											if($art_code_node->length > 0)
												$xml_art_code = $art_code_node->item(0)->getAttribute("value");
											$suport_file_node = $xpath->query("//filegroup/archive-file");

											$stage_file_node = $xpath->query("//filegroup/file[@description]");
											
											$suport_file = '';
											if($suport_file_node->length > 0)
											{
												$temp_file_no = $suport_file_node->item(0)->getAttribute('name');
												
												$file_list = $this->getRemotefileList($conn_id, $ftp_location,FALSE,$temp_file_no,$ssh,$sftpkey);
												
												if(count($file_list) == 0)
													continue;
												else
												{
													$temp_file_arr = explode('/', $file_list[0]);
													$temp_file = end($temp_file_arr);
												}	
												
												$file_location = $download_writing.$temp_file;		
												$this->getRemote_files($conn_id, $file_location, $ftp_location.$temp_file,$ssh,$sftpkey);

												if(file_exists($file_location))
												{
													$stage_import_res = $this->stageImportprocess($xml_art_code,$xml_stage_name,$temp_go_file,$temp_file,$download_writing,$role_arr,$stage_file_node);
													
													if($stage_import_res['status'] == 'success')
													{
														//echo '<pre>';print_r($stage_import_res);
														$import_res = $stage_import_res['db_action_arr'];
														if(isset($import_res['sig_id']))
														{
															$sql = 'Update '.$Stage_import_go_files_table.' SET ';
															$cnd_str = ' Where sig_id = '.$import_res['sig_id'];
															unset($import_res['sig_id']);
															$temp_arr = array();
															foreach($import_res as $key => $val)
															{
																$temp_arr[] = $key.' = \''.$val.'\'';
															}

															$sql .= implode(',', $temp_arr).$cnd_str;
														}
														else
														{
															$temp_col = array_keys($import_res);
															$temp_val = array_values($import_res);

															$sql = 'INSERT INTO '.$Stage_import_go_files_table.' ('. implode(',', $temp_col).') VALUES (\''. implode('\',\'', $temp_val).'\')';
														}

														$Stage_import_go_files::execute_query($sql);

														//set SEND EMAIL HERE
														//########################################//

														if(isset($stage_import_res['move_next']) && $stage_import_res['move_next'] != FALSE)
														{
															$done_loc = $ftp_location.'done/';

															$done_file_list = $this->getRemotefileList($conn_id, $done_loc,FALSE,'',$ssh,$sftpkey);
												
															if ($done_file_list === FALSE)
															{
																$this->crDirectory($conn_id, $done_loc,$ssh,$sftpkey);
															}

															//stage import completed files moved into 'done' folder in the same remote location
															
															$this->moveRemotefile($conn_id, $ftp_location.$temp_go_file, $done_loc.$temp_go_file,$ssh,$sftpkey);
															$this->moveRemotefile($conn_id, $ftp_location.$temp_file, $done_loc.$temp_file,$ssh,$sftpkey);
															
															//check with sarath
															//$this->upload_article_data_to_custom_ftp($stage_import_res['art_id'],$stage_import_res['stage_id'],'c',$stage_import_res['move_next']);
														}
														elseif($xml_art_code != '')
														{
															$email_cnd = array(
																'etmp_name' => 'stage_import_email'
															);

															$email_template = Email_templates::get_single_record_with_bind_cond('etmp_notification',$email_cnd);

															if(isset($email_template->etmp_notification))
															{
																$join_tables = array(
																	'main_table' => $Articles,
																	'join_table' => array(
																		$Article_types => array('art_artp_id','artp_id'),
																		$Journals => array('artp_jnl_id','jnl_id'),
																	));
	
																$criteria = array(
																	'art_code' => $xml_art_code
																);
																$select = 'art_id,art_code,art_title,art_doi,artp_article_type,artp_id,jnl_id,jnl_journal_code,jnl_journal_name';

																$article_data = Articles::get_results_using_joins($join_tables, $select,$criteria,'single');

																$send_mail_to = '';
																$send_mail_to_usr_ids = '';

																if ($email_template->etmp_notification != 'User' && $email_template->etmp_notification != 'Custom')
																{
																	$send_mail_to_detail = $this->send_email_to($email_template->etmp_notification,$article_data->jnl_journal_code, $article_data->artp_id, $article_data->art_id,$cfty_retire_role);

																	$send_mail_to = $send_mail_to_detail['email_ids'];
																	$send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
																}

																if ($send_mail_to != '' || $email_template->etmp_notification == 'Custom')
																{
																	$errmsg = '';
																	if(isset($import_res['sig_message']))
																	{
																		$errmsg = '<p>'.implode('</p><p>', json_decode($import_res['sig_message'])).'</p>';
																	}

																	//HERE NEED TO SET USER IDS
																	$user_data = array(
																		'user_id' => 0,
																		'proxy_user_id' => 0
																	);
																	if(isset($import_res['sig_posted_by']))
																	{
																		$user_data = array(
																			'user_id' => $import_res['sig_posted_by'],
																			'proxy_user_id' => 0
																		);
																	}

																	$custom_data = array(
																		'usr_email'=>$send_mail_to,
																		'etmp_notification' => $email_template->etmp_notification,
																		'mail_recipient_ids'=> $send_mail_to_usr_ids,
																		'article_id'=> $article_data->art_id,
																		'artp_id'=> $article_data->artp_id,
																		'jnl_id'=>$article_data->jnl_id,
																		'jnl_code'=>$article_data->jnl_journal_code,
																		 //'aflw_id'=>$current_status_id,
																		'user_data'=>$user_data, 
																		'stage_import_errors'=>$errmsg
																	 );

																	 $email_data = array(
																		 'type' => 'global',
																		 'action' => 'send',
																		 'user_id'=> $user_data['user_id'],
																		 'email_with_login' => FALSE,
																		 'empt_name' => 'stage_import_email',
																		 'custom_data' => $custom_data
																	 );

																	 $this->master_email_details($email_data);	
																}

															}

														}

														//delete files from local location
														//shell_exec('rm -r ' . $download_writing.$temp_go_file);
														//shell_exec('rm -r ' . $download_writing.$temp_file);

														//########################################//
													}
												}
											}
										}
									}
								}
								$this->ftpclose($conn_id,$sftpkey,$ssh);
							}
							else
							{
								$conn_fail_arr[] = 'HOST : '.$host.', USER : '.$username.' connection/login failed in the Article ID{Stage} : '.$imp_stdatum->art_code_and_stage.', Journal : '.$imp_stdatum->jnl_journal_name.'('.$imp_stdatum->jnl_journal_code.') of Article type : '.$imp_stdatum->artp_article_type;
							}
						}
					}
					else
					{
						$conn_fail_arr[] = $this->current_client->clnt_client_name.' DTD file missing in application client folder. Please place ReView_import.go.dtd for stage import';
					}

					if(count($conn_fail_arr) > 0)
					{
						$bug_report = implode('<br/>=============================<br/>', $conn_fail_arr);

						$subject = 'Stage import failed - '.$this->current_client->clnt_client_name;
						$body = '<p>Connection failed details  <br>';
						$body .= 'Client : ' . $this->current_client->clnt_client_name . '</p>';
						$body .= '<p>Issue list <br>'. $bug_report . '<p>';

						$this->send_email_to_team_review($subject,$body);
					}

					if(file_exists($download_writing) && strpos($download_writing,'stageImport')>0)
					{
						shell_exec('rm -rf ' . $download_writing.'*');
					}
				}
			}
		}
		catch(\Exception $e)
		{
			
			return  $this->failure('Failed',422,$e);
		}
	}

	// public function sample_bind_query()
	// {
	// 	try
	// 	{
	// 	$Stage_import_go_files =new \App\Models\Stage_import_go_files();
		
	// 	$code = 'CIEN-2021-001';
	// 	$user_id = 339;
	// 	$cond = array(
	// 		'art_id'=> 10,
	// 		'art_status'=> 'a',
	// 		'art_code'=>$code
	// 	);
	// 	$str_cnd = '';
	// 	$bnd = array();
	// 	//**************string condition and bind data array******************* */
	// 	$cond = array();
	// 	//$str_cnd = 'art_id > ? and art_status = \'a\' and art_code= ? ';
	// 	$cond = 'sig_id = ? ';
	// 	$bnd = array(
	// 		'sig_id'=>280);
	// 	// $cond = array(
	// 	// 	'sig_id' => 338
	// 	// );

	// 	//$str_cnd = ' art_code=  '.$code;
	// 	//$Stage_import_go_files::delete_records($cond); 
	// 	//$sql_raw_query  = 'SELECT usr_posted_date from tbk_users where usr_id= ? ORDER BY tbk_id ASC LIMIT 1';
	// 	// $cond = array($user_id);
	// 	// $cond = array();
	// 	DB::enableQueryLog();
	// 	$Stage_import_go_files::delete_records($cond,'',NULL,$bnd); 
	// 	//$res = Articles::get_single_record_with_bind_cond('*',$cond,$str_cnd,$bnd);
	// 	//$res = Articles::get_all_records_with_bind_cond('*',$cond,$str_cnd,$bnd);
	// 	//$res = Articles::get_records_by_raw_query($sql_raw_query,FALSE,$cond);
	// 	/*
	// 			$art_type_id = 10;

	// 			$artp_table     =   (new \App\Models\Article_types())->getTable();
	// 			$jpm_table      =   (new \App\Models\Journal_permission_master())->getTable();
	// 			$jp_table       =   (new \App\Models\Journal_permission())->getTable();
	// 			$tables         =   array(
	// 									'main_table' => $artp_table,
	// 									'join_table' => array(
	// 										$jpm_table => array($artp_table . '.artp_jpm_id', $jpm_table . '.jpm_id', "left"),
	// 										$jp_table => array($jp_table . '.jp_jpm_id', $jpm_table . '.jpm_id', "left")
	// 								));
	// 			$criteria       =   "artp_id = ?";
	// 			$binding_arr = array($art_type_id);
	// 			$criteria       =  array(
	// 				'artp_id' => $art_type_id
	// 			); 
	// 			DB::enableQueryLog();
	// 			$artp_opt     =   Article_types::get_results_using_joins($tables, 'jp_auto_assign_role', $criteria, 'single', NULL, NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr);
	// 	*/

		
		
	// 	$query = DB::getQueryLog();
	// 	$query = end($query);
	// 	print_r($query);exit;
	// 	}
	// 	catch(\Exception $e)
	// 	{
	// 		//print_r($e);
	// 		return  $this->failure('Failed',422,$e);
	// 	}
	// }

	public function stageImportprocess($xml_art_code,$xml_stage_name,$go_file,$suport_file,$location,$role_arr,$stage_file_node)
	{
		$return_arr = array(
			'status' => 'failed'
		);
		$error_log = array();
		$go_file_arr = array();

		if($xml_art_code == '')
			$error_log[$go_file][] = customTrans('cron.xml_art_not_found');
		if($xml_stage_name == '')
			$error_log[$go_file][] = customTrans('cron.xml_stage_not_found');

		$Stage_import_go_files_table =new \App\Models\Stage_import_go_files();
		$go_file_arr['sig_file_name'] = $go_file;
		$go_file_arr['sig_status'] = 'f';
		$go_file_arr['sig_operation'] = 'i';

		$for_del_files = array();
		
		if(file_exists($location.$go_file) && file_exists($location.$suport_file))
		{
			$xml_go_location = $location.$go_file;
			//$where_cnd = 'sig_file_name = \''.$go_file.'\'';
			$where_cnd = array(
				'sig_file_name'=> $go_file
			);
			$go_file_db = $Stage_import_go_files_table::get_single_record_with_bind_cond('sig_id',$where_cnd);
			
			if(!empty($go_file_db))
			{
				$go_file_arr['sig_id'] = $go_file_db->sig_id;
				$go_file_arr['sig_operation'] = 'u';
			}
			$file_desc_insert_flag = FALSE;
			if($xml_stage_name != '' && $xml_art_code != '')
			{
				$Ftp_table =(new \App\Models\Ftp())->getTable();
				$Article_flow_table =(new \App\Models\Article_flow())->getTable();
				$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
				$Articles = (new \App\Models\Articles())->getTable(); 
				$Article_types = (new \App\Models\Article_types())->getTable();
				$Journals = (new \App\Models\Journals())->getTable();
				$Journal_setting = (new \App\Models\Journal_settings())->getTable();
				$user_article_table = new \App\Models\User_articles();
				$User_to_journals = new \App\Models\User_to_journals();
				$Attachment_file_description = new \App\Models\Attachment_file_description();
				$Production_attachment_files = new \App\Models\Production_attachment_files();
				$Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
				$advance_flow_movement_table = new \App\Models\Advance_flow_movement();
				$Article_flow =new \App\Models\Article_flow();
				
				$select = 'aflw_id,aflw_status,aflw_jwf_id,aflw_usr_id,jwf_role_id,art_id,art_artp_id,art_article_upload_path,jwf_fwm_id,jwf_child_stages,jwf_stage_name,jwf_flow_proceed_type,jwf_stage_type,jset_reply_to_email,jwf_afdec_ids,jnl_id,jnl_journal_code,artp_fwm_id';
				
				$join_tables = array(
					'main_table' => $Ftp_table,
					'join_table' => array(
						$Article_flow_table => array('ftp_jwf_id','aflw_jwf_id'),
						$Articles => array('art_id','aflw_art_id'),
						$generic_flow_table => array('jwf_id','aflw_jwf_id'),
						$Article_types => array('art_artp_id','artp_id'),
						$Journals => array('artp_jnl_id','jnl_id'),
						$Journal_setting => array('jset_jnl_id','jnl_id'),
					));

				//$criteria = ' ftp_action_for IN (\'i\',\'b\') AND aflw_status IN (\'u\',\'a\') AND art_code = \''.$xml_art_code.'\' AND IF(ftp_import_stage_name IS NOT NULL AND ftp_import_stage_name != \'\',ftp_import_stage_name = \''.$xml_stage_name.'\',jwf_stage_name = \''.$xml_stage_name.'\')';

				$criteria = ' ftp_action_for IN (\'i\',\'b\') AND aflw_status IN (\'u\',\'a\') AND art_code =?  AND IF(ftp_import_stage_name IS NOT NULL AND ftp_import_stage_name != \'\',ftp_import_stage_name = ?,jwf_stage_name = ?)';

				$binding_arr = array($xml_art_code,$xml_stage_name,$xml_stage_name);
				
				$stage_data = Ftp::get_results_using_joins($join_tables,$select,$criteria,'single',NULL,NULL,'',NULL,NULL,FALSE, NULL,FALSE,$binding_arr);	
				
				if(isset($stage_data->aflw_id))
				{
					$stage_id = $stage_data->aflw_id;
					$go_file_arr['sig_aflw_id'] = $stage_id;
					$user_arr = array();
					$art_id = $stage_data->art_id;
					$return_arr['art_stage_data'] = $stage_data;
					$jnl_id = $stage_data->jnl_id;
					$jnl_code = $stage_data->jnl_journal_code;
					
					$production_status = FALSE;
					$stage_for_flag = 'r';
					if(isset($this->review_flow[$stage_data->jwf_stage_type]['stage_for']) && $this->review_flow[$stage_data->jwf_stage_type]['stage_for'] == 'manageproduction')
					{
						$production_status = TRUE;
						$stage_for_flag = 'p';
					}
					
					$user_flag = TRUE;
					if($stage_data->aflw_usr_id == NULL)
					{
						//check stage role assigned to a purticular user
						$assinged_sers = $user_article_table::get_all_records_with_bind_cond('usra_usr_id',array(
							'usra_art_id' => $stage_data->art_id,
							'usra_role_id' => $stage_data->jwf_role_id,
						));

						$role_name = '';
						if(isset($role_arr[$stage_data->jwf_role_id]))
							$role_name = $role_arr[$stage_data->jwf_role_id];
						
						if(empty($assinged_sers) || count($assinged_sers) == 0)
						{
							$artp_users = $User_to_journals::get_all_records_with_bind_cond('usrj_usr_id',array(
								'usrj_artp_id' => $stage_data->art_artp_id,
								'usrj_role_id' => $stage_data->jwf_role_id,
							));

							if(empty($artp_users) || count($artp_users) == 0)
							{
								$wan_message = customTrans('cron.no_roleuser_in_articletype');
								$wan_message = str_replace('##ROLE_NAME##',$role_name,$wan_message);
								$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);
								
								$error_log[$go_file][] = $wan_message;
								$user_flag = FALSE;
							}
							elseif(count($artp_users) > 1)
							{
								$wan_message = customTrans('cron.multi_roleuser_in_articletype');
								$wan_message = str_replace('##ROLE_NAME##',$role_name,$wan_message);
								$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);

								$error_log[$go_file][] = $wan_message;
								$user_flag = FALSE;
							}
							elseif(count($artp_users) == 1)
							{
								$user_arr = array(
									'user_id' => $artp_users[0]->usrj_usr_id,
									'proxy_user_id' => 0
								);
							}
						}
						elseif(count($assinged_sers) > 1)
						{
							$wan_message = customTrans('cron.multi_assignusers_in_article');
							$wan_message = str_replace('##ROLE_NAME##',$role_name,$wan_message);
							$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);
							
							$error_log[$go_file][] = $wan_message;
							$user_flag = FALSE;
						}
						elseif(count($assinged_sers) == 1)
						{
							$user_arr = array(
								'user_id' => $assinged_sers[0]->usra_usr_id,
								'proxy_user_id' => 0
							);
						}	
					}
					else
					{
						$user_arr = array(
								'user_id' => $stage_data->aflw_usr_id,
								'proxy_user_id' => 0
							);
					}

					if($user_flag == TRUE)
					{
						if($stage_file_node->length > 0)
						{
							$sh_unzip_cmd ='unzip '.$location.$suport_file.' -d '.$location;
							shell_exec($sh_unzip_cmd);
							$extract_folder = substr(trim($suport_file), 0, -4);
							
							//no desc. no insert
							//if desc. there not find in db (desc. mismatch), not insert all
							//mismatch  files [file count not correct to xml  files]
							$file_desc_insert_flag = TRUE;
							$files_upload_flag = TRUE;
							$file_desc_insert_err = array();
							$pro_attach_file = array();

							DB::beginTransaction();	

							$art_production_path = 'uploads/'.$stage_data->art_article_upload_path.'/production/';
							$art_path = $art_production_path.$stage_id.'/';

							$art_path_for_s3 = $stage_data->art_article_upload_path.'/production/'.$stage_id.'/';

							$art_path =  $this->get_upload_path($art_path,FALSE,'storage',TRUE);
							
							if(!file_exists($art_path))
							{
								$cmd = ' mkdir -p '.$art_path;
								shell_exec($cmd);
							}

							//stage id folder created in stage import folder
							$art_local_path = $location.$stage_id.'/';
							if(!file_exists($art_local_path))
							{
								$cmd = ' mkdir -p '.$art_local_path;
								shell_exec($cmd);
							}

							//$for_del_files[] = $art_local_path;

							for ($i = 0; $i < $stage_file_node->length; $i++)
							{
								$element_node = $stage_file_node->item($i);
								$file_name = trim($element_node->getAttribute('name'));
								$file_desc = trim($element_node->getAttribute('description'));

								if($file_desc != '')
								{
									// #4511 enable TrAction file formats for upload
									$where = 'afdec_description = \''.$file_desc.'\' AND FIND_IN_SET("'.$stage_for_flag.'", afdec_apply_stage_type) ';
									$temp_flag = array();
									if($stage_data->jwf_afdec_ids != NULL)
										$temp_flag = json_decode($stage_data->jwf_afdec_ids);

									if(count($temp_flag) > 0)
									{
										$where .= ' AND  afdec_id IN ('.implode(',',$temp_flag).')';
									}	

									$desc_data = $Attachment_file_description::get_single_record('afdec_id,afdec_viewable_roles',$where);

									$file_imported_path = NULL;
									if(file_exists($location.$extract_folder.'/'.$file_name))
									{
										$file_imported_path = $location.$extract_folder.'/';
									}
									elseif(file_exists($location.$file_name))
									{
										$file_imported_path = $location;
									}
									
									if(isset($desc_data->afdec_id) && $file_imported_path != NULL)
									{
										//copy file from temp location to article location
										$pro_file_name = escapeshellcmd($file_name);
										$pro_file_name = str_replace(' ','\ ',$pro_file_name);

										//$sh_move_cmd=' cp '.$file_imported_path.$pro_file_name.' '.$art_path;


										$sh_move_cmd=' cp '.$file_imported_path.$pro_file_name.' '.$art_local_path;
										shell_exec($sh_move_cmd);

										//if(!file_exists($art_path.$file_name))
										if(!file_exists($art_local_path.$file_name))
										{
											$files_upload_flag = FALSE;
											$file_desc_insert_flag = FALSE;
											$wan_message = customTrans('cron.file_not_exist');
											$wan_message = str_replace('##FILE_NAME##',$file_name,$wan_message);
											$wan_message = str_replace('##SUPPORT_FILE##',$suport_file,$wan_message);

											$file_desc_insert_err[] = $wan_message;
											break;
										}

										$file_size = round(filesize($file_imported_path.$file_name)/1000,2);
										$pro_attach_file = array(
											'paf_art_id' => $stage_data->art_id,
											'paf_aflw_id'=> $stage_data->aflw_id,
											'paf_file_name' => $file_name,
											'paf_document_size'=> $file_size,
											'paf_description_id' => $desc_data->afdec_id,
										);
										
										$pro_attch_id = $Production_attachment_files::insert_record($pro_attach_file,$user_arr);

										/*if($desc_data->afdec_viewable_roles != NULL &&  $desc_data->afdec_viewable_roles != '' && $pro_attch_id > 0)*/
										if($pro_attch_id > 0 && $pro_attch_id != FALSE)
										{
											$desig_roles = array(
												'adr_paf_id' => $pro_attch_id,
												'adr_role_id' => $desc_data->afdec_viewable_roles,
												'adr_submitted_type' => 'ps'
											);
											$Attachment_designated_roles::insert_record($desig_roles,$user_arr);
										}
										else
										{
											$file_desc_insert_flag = FALSE;

											$wan_message = customTrans('cron.file_addto_stage_fail');
											$wan_message = str_replace('##STAGE_NAME##',$stage_data->jwf_stage_name,$wan_message);
											$wan_message = str_replace('##FILE_NAME##',$file_name,$wan_message);
											$wan_message = str_replace('##GO_FILE##',$go_file,$wan_message);

											$file_desc_insert_err[] = $wan_message;
										}
									}
									elseif(!file_exists($file_imported_path.$file_name) || $file_imported_path == NULL)
									{
										$file_desc_insert_flag = FALSE;

										$wan_message = customTrans('cron.file_not_exist');
										$wan_message = str_replace('##FILE_NAME##',$file_name,$wan_message);
										$wan_message = str_replace('##SUPPORT_FILE##',$suport_file,$wan_message);

										$file_desc_insert_err[] = $wan_message;
									}
									else
									{
										$file_desc_insert_flag = FALSE;

										$wan_message = customTrans('cron.gofile_desc_not_exist');
										$wan_message = str_replace('##FILE_DESCRIPTION##',$file_desc,$wan_message);
										$wan_message = str_replace('##FILE_NAME##',$file_name,$wan_message);
										$wan_message = str_replace('##GO_FILE##',$go_file,$wan_message);
										$wan_message = str_replace('##STAGE_NAME##',$stage_data->jwf_stage_name,$wan_message);

										$file_desc_insert_err[] = $wan_message;
									}
								}
								else
								{
									$file_desc_insert_flag = FALSE;

									$wan_message = customTrans('cron.no_desc_in_gofile');
									$wan_message = str_replace('##FILE_NAME##',$file_name,$wan_message);
									$wan_message = str_replace('##GO_FILE##',$go_file,$wan_message);

									$file_desc_insert_err[] = $wan_message;
								}
							}
							$commit_flag = ($files_upload_flag == FALSE || $file_desc_insert_flag == FALSE) ? FALSE : TRUE;
							if ($commit_flag == FALSE)
							{
								$wan_message = customTrans('cron.file_addto_stage_fail');
								$wan_message = str_replace('##STAGE_NAME##',$stage_data->jwf_stage_name,$wan_message);
								$wan_message = str_replace('(##FILE_NAME##)','',$wan_message);
								$wan_message = str_replace('##GO_FILE##',$go_file,$wan_message);

								$error_log[$go_file][] = $wan_message;

								 if(file_exists($art_path))
								 	shell_exec('rm -r ' . $art_path);
								
								DB::rollback();	
							}	

							if($file_desc_insert_flag == FALSE)
							{
								$error_log[$go_file][] = implode('<br>',$file_desc_insert_err);
							}
							// if(file_exists($file_imported_path))
							// 	shell_exec('rm -r ' . $file_imported_path);

						}
						else
						{
							$wan_message = customTrans('cron.no_desc_file');
							$wan_message = str_replace('##GO_FILE##',$go_file,$wan_message);
							$wan_message = str_replace('##STAGE_NAME##',$stage_data->jwf_stage_name,$wan_message);
							$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);

							$error_log[$go_file][] = $wan_message;
						}
	
						//add zip file article stage
						if($stage_data->aflw_status == 'u' && $file_desc_insert_flag == TRUE)
						{
							$update_arr = array(
								'aflw_usr_id' => $user_arr['user_id'],
								//'aflw_accepted_date' => date('Y-m-d H:i:s'),
								'aflw_status' => 'a',
								'aflw_remarks' => 'stage_import',
							);
							$Article_flow::update_record($update_arr,array(
								'aflw_id' => $stage_id
							),$user_arr);
						}
						$go_file_arr['sig_posted_by'] = $user_arr['user_id'];
						if( $file_desc_insert_flag == TRUE)
						{
							//find if there is multiple childs
							$child_stages_arr = json_decode($stage_data->jwf_child_stages);
							$next_stage = NULL;
							$adv_flow_id = NULL;
							
							if(count($child_stages_arr) > 0)
							{
								//wright find sql
								$where = 'jwf_id IN (\''. implode('\',\'', $child_stages_arr).'\') AND jwf_disable_status = \'n\'';
								$child_count = Generic_flows::get_single_record('count(jwf_id) as cnt',$where);
								
								$multiple_child_flag = FALSE;
								if($stage_data->jwf_flow_proceed_type == 'parallel' && count($child_stages_arr) > 1)
								{
									$multiple_child_flag = TRUE;
								}
								elseif($stage_data->jwf_flow_proceed_type == 'advance')
								{
									$adv_flow = $advance_flow_movement_table::get_single_record_with_bind_cond('count(DISTINCT afm_jwf_id) as cnt,afm_id',array(
										'afm_jwf_id' => $stage_data->aflw_jwf_id
									));
								
									if($adv_flow->cnt == 1)
									{
										$multiple_child_flag = TRUE;
										$adv_flow_id = $adv_flow->afm_id;
									}
								}
								
								if($child_count->cnt == 1 || $multiple_child_flag == TRUE)
								{
									if($child_count->cnt == 1 && isset($child_stages_arr[0]))
									{
										$next_stage = $child_stages_arr[0];
									}

									/*
									if(!isset($this->jnl_data->jnl_journal_code) || (isset($this->jnl_data->jnl_journal_code) && $this->jnl_data->jnl_journal_code != $stage_data->jnl_journal_code))
									{
										$this->intiate_journal($stage_data->jnl_journal_code);
										$this->set_jnl_data();
									}*/

									/*
									//move article stage to next
									$art_stage_arr = $this->workflow->move_next_stage($art_id, $user_arr, $load_models, $stage_data->jwf_fwm_id, $stage_id, $next_stage, FALSE, $stage_data->art_artp_id, $load_libraries, FALSE, FALSE, FALSE, NULL, $this->current_client, NULL, $stage_data->jset_reply_to_email,FALSE,array(),NULL,array(),'n',NULL,NULL,FALSE,FALSE ,$stage_data->jwf_role_id,NULL,$adv_flow_id,$production_status,FALSE);
									*/
									
									//$move_next_data_array['checkout_article'] = FALSE;
									$move_next_data_array['article_id'] = $stage_data->art_id;
									$move_next_data_array['current_user'] = $user_arr;
									$move_next_data_array['master_flow_id'] = $stage_data->artp_fwm_id;;
									$move_next_data_array['current_jwf_id'] =$stage_data->aflw_jwf_id;
									$move_next_data_array['current_stage'] = $stage_data->aflw_id;
									$move_next_data_array['artp_id'] = $stage_data->art_artp_id;
									//$move_next_data_array['ithenticate_enabled']=$ithenticate_enabled;
									$move_next_data_array['current_client'] = $this->current_client;
									$move_next_data_array['this_stage'] = $stage_data->aflw_id;
									$move_next_data_array['trans_started'] = false;
									$move_next_data_array['role_id'] = $stage_data->jwf_role_id;
									$move_next_data_array['reply_to_email'] = $stage_data->jset_reply_to_email;
									$move_next_data_array['adv_flow_id'] = $adv_flow_id;
									$move_next_data_array['production_status'] = $production_status;
									$move_next_data_array['cron_flag'] = TRUE;
									$move_next_data_array['trans_started'] = TRUE;
									//$move_next_data_array['auto_assign_role'] = $auto_assign_role;
									//$move_next_data_array['new_article_id'] = $new_article_id;
									//$move_next_data_array['stage_email_ids'] = $stage_email_ids;
									//$move_next_data_array['art_prev_article_id'] = $article_basics->art_prev_article_id;
									//$move_next_data_array['stage']=$stagename;
									$move_next_data_array['next_stage'] = $next_stage;
									$art_stage_arr = $this->move_next_stage($move_next_data_array);
									
									$this->current_user = $user_arr;
									//$this->upload_article_data_to_custom_ftp($art_id,$stage_id,'c',$art_stage_arr);
									$return_arr['move_next'] = $art_stage_arr;
									$return_arr['stage_id'] = $stage_id;
									$return_arr['art_id'] = $art_id;
									if($art_stage_arr != FALSE)
									{
										$go_file_arr['sig_status'] = 's';

										//update files to remote location
										$sh_move_cmd=' cp '.$art_local_path.'* '.$art_path;
										shell_exec($sh_move_cmd);
										
										if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y')
										{
											$this->update_s3_files($art_path_for_s3);	

										}
										
									}
								}
								elseif($child_count->cnt > 1 || $multiple_child_flag == FALSE)
								{
									$wan_message = customTrans('cron.multi_child');
									$wan_message = str_replace('##STAGE_NAME##',$stage_data->jwf_stage_name,$wan_message);
									$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);

									$error_log[$go_file][] = $wan_message;
								}
								else
								{
									$wan_message = customTrans('cron.no_child_stage');
									$wan_message = str_replace('##STAGE_NAME##',$stage_data->jwf_stage_name,$wan_message);
									$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);

									$error_log[$go_file][] = $wan_message;
								}
							}
							else
							{
								$wan_message = customTrans('cron.no_child_stage');
								$wan_message = str_replace('##STAGE_NAME##',$stage_data->jwf_stage_name,$wan_message);
								$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);

								$error_log[$go_file][] = $wan_message;
							}
						}
					}
				}
				else
				{
					$wan_message = customTrans('cron.no_xmlstage_article');
					$wan_message = str_replace('##STAGE_NAME##',$xml_stage_name,$wan_message);
					$wan_message = str_replace('##ARTICLE_CODE##',$xml_art_code,$wan_message);

					$error_log[$go_file][] = $wan_message;
				}
			}
			$return_arr['status'] = 'success';
		}
			if(isset($error_log[$go_file]))
				$go_file_arr['sig_message'] = json_encode($error_log[$go_file]);
			$go_file_arr['sig_posted_date'] = date('Y-m-d H:i:s');
			$go_file_arr['sig_proxy_id'] = 0;
			
			$return_arr['db_action_arr'] = $go_file_arr;

			return $return_arr;
	}
  /*TASK #4801  Part of RVRite integration: Need to keep the change log */
   public function rv_write_author_log_api_format(Request $request)
   {
      try{
		$artcle_ids=array(867,866);
		$base_path="https://reviewv3.s3.amazonaws.com/uploads/email_attachments/866";
		$file_name="file-sample_100kB(2).doc";
		$return_array['art_array']=array(array("art_id"=>867,"attach_name"=>"file-sample_100kB(2).doc"),array("art_id"=>866,"attach_name"=>"file-sample_100kB(2).doc"));
		$return_array['base_path']=$base_path;
		return  $this->success('Success', 200, $return_array);
	  }
	  catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}
   }
	public function track_author_changes_log_notification()
	{
		
       try
	   {
		$count=0;
		$total=1;
		while($count<$total)
		{
		$article_data=$this->get_all_article_author_edit_log_list($count);
	
		if(isset($article_data['total_record'])&&$article_data['total_record']!=0)
		{
			$total=$article_data['total_record'];
			$count=$count+1;
		
		$Stage_email_templates = new \App\Models\Stage_email_templates();
	

		if(isset($article_data['record'])&&$article_data['record']==true)
		{
		$article_list_info=$this->formatted_article_data($article_data);
        $file_data_array=$article_list_info['file_array'];

		$file_data_size_array=$article_list_info['file_array_size'];
		//$artcle_ids=array($article_list_info['id_array']);
		$list_articles=implode(",",$article_list_info['id_array']);
		
	
		$remind_after = 'CASE WHEN stage_etmp_reminder_format = \'after\' AND stage_etmp_action = \'assigned_not_accepted\' AND stage_etmp_remind_after = \'i\' THEN aflw_assigned_date ELSE aflw_due_date END';
		$select = 'aflw_id, aflw_parent_flow_id, aflw_jwf_id, aflw_art_id, IF(stage_etmp_reminder_format = \'each\',DATEDIFF( NOW(),aflw_assigned_date), DATEDIFF(aflw_due_date, NOW())) AS remaining_days,DATEDIFF(NOW(), '.$remind_after.') as reminder_after, rvw_stage_email_tmpls.*, stage_etmp_content AS stage_etmp_email_template';
		$select .= ',artp_id,art_id, art_title, artp_article_type, jnl_id, jnl_journal_name, jwf_id, aflw_id, aflw_usr_id,jwf_stage_type,aflw_status,aflw_assigned_date, aflw_accepted_date,jwf_stage_name, jwf_status_name,jwf_tat_complete,jwf_tat_accept,jnl_journal_code,jnl_standalone_group, jwf_role_id,jwf_no_of_min_users, jwf_assignment, aflw_deeplink_token';
        $where_article_condition="art_id IN(".$list_articles.") AND stage_etmp_action = 'track_author_changes' AND jwf_stage_type IN('author_submission','revision','resubmission');";
		DB::enableQueryLog();
		$all_article_details = $Stage_email_templates::get_reminder_recieve_article_data($select, $where_article_condition);
		$query = DB::getQueryLog();
		//$query = end($query);print_r($query);exit;
	
         // print_r($all_article_details);exit;
	//	$where = 'aflw_status = \'i\' AND stage_etmp_action = \'assigned_not_accepted\' AND stage_etmp_to <> \'\' AND art_delete_status = \'n\' AND (CASE WHEN stage_etmp_reminder_format = \'on_due_date\' AND DATEDIFF(aflw_due_date, NOW()) = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'each\' AND DATEDIFF(aflw_assigned_date, NOW()) != 0 AND DATEDIFF(aflw_assigned_date, NOW()) % stage_etmp_remind_days = 0 THEN TRUE WHEN stage_etmp_reminder_format = \'before\' AND  DATEDIFF(aflw_due_date, NOW()) = stage_etmp_remind_days THEN TRUE WHEN stage_etmp_reminder_format = \'after\' and aflw_assigned_date IS NOT NULL AND  DATEDIFF(NOW(), '.$remind_after.') = stage_etmp_remind_days THEN TRUE ELSE FALSE END)  ';
        $where=array('stage_etmp_action'=>'track_author_changes');

		$all_article_tmpl_details = $Stage_email_templates::get_single_record_with_bind_cond('*', $where);
		//print_r($all_article_tmpl_details);exit;
		$email_attached=array();
		//$base_path="https://reviewv3.s3.amazonaws.com/uploads/email_attachments/866";
		$base_path=$article_data['result']['base_path'];
		//$file_name="file-sample_100kB(2).doc";

		if (count($all_article_details) > 0)
		{
			
			$send_success = 0;
			foreach ($all_article_details as $art_details)
			{
				
				$file_name=$file_data_array[$art_details->aflw_art_id];
				$file_size=$file_data_size_array[$art_details->aflw_art_id];
				
				$file_data=array($file_name=>$base_path.'/'.$file_name);
				
				$email_att_id=$this->save_cron_email_attachment($art_details,$file_name,$base_path,$file_size);
				if($email_att_id!=NULL)
				{
				$email_attach_data=$this->get_attach_log_data($file_data,$email_att_id);
				$result = $this->send_email_notifications($art_details, $all_article_tmpl_details,$email_attach_data);
				if($result == TRUE)
					$send_success++;
				}
			}
			/*if($send_success>0)
				echo date('d-m-Y H:i:s') . ' : Reminder sent successfully ';
			else
				echo date('d-m-Y H:i:s') . ' :  No record found';
		}
		else
			echo date('d-m-Y H:i:s') . ' :  No record found';*/
	}
	/*else
	{
		echo date('d-m-Y H:i:s') . ' :  No record found';
	}*/

		}
	}
	
	   }
	
	   if($count>1)
	   {
		   echo date('d-m-Y H:i:s') . ' : Reminder sent successfully ';
	   }
	   else
	   {
		   echo date('d-m-Y H:i:s') . ' :  No record found';
	   }
	}
	   catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}
	}
	public function get_attach_log_data($file_data,$email_attach_id)
	{
		try
		{
		$attach_mod = $attachments = $files_attached = array();
		$rtn_arr=array();
		if ($this->current_client->enable_upload_s3_bucket == 'y') {
            $mainpath="uploads/email_attachments/";
        }
        else
        {
            $mainpath="email_attachments/";
        }
		foreach ($file_data as $attkey=>$att) {
			//$attach_mod[$att->emat_id]  = $att->emat_file_name;
			$path             =    $mainpath . '/' . $att;
			//$full_file_path             =    $this->get_upload_path($path ,TRUE);
		//	echo $att;exit;
			$files_attached[$attkey]   =  $att;
			$attachments[$email_attach_id]=$attkey;
		}
		//$attachments['modified'] = $attach_mod;
		$attachments        =    json_encode($attachments);
		$rtn_arr['attachments'] = $attachments;
		$rtn_arr['files_attached'] = $files_attached;
		return $rtn_arr;
	 }
	 catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}
	}

    public function get_all_article_author_edit_log_list($count)
	{
		try
		{
      // Create a new Guzzle client
	  $client = new Client(['verify' => false]);
	  // Define the URL you want to send the POST request to
	  $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
	 
	  $es_api_data  = Config::get($es_config);
	  $service_end_url=$es_api_data['rvriteurl'];
      $url=$service_end_url.'/laravel/api/rvrite-author-logs';
	
	  // Define the data you want to send in the request body
	  $data_array = [
		  'client_code'=>$this->current_client->clnt_client_code,
		  'current_segment'=>$count
	  ];

		  // Send the POST request
		  $response = $client->post($url, [
			  'json' => $data_array, // Use 'json' to send JSON data, or 'form_params' for form data
		  ]);
		
		  $responseBody = $response->getBody()->getContents();
		 // print_r( $responseBody);exit;
		  // You can then process the response as needed
		  $responseData = json_decode($responseBody, true);
		 // print_r( $responseData);exit;
        return $responseData;
	}
	catch (\Exception $e) {

		return $this->failure('Failed', 500, $e);
	}
}

public function save_cron_email_attachment($array_data,$file_name,$base_path,$file_size)
{
	try
	{

		$Email_attachments = new \App\Models\Email_attachments;
	
			 $insert_data = array(
				 'emat_file_name' =>$file_name,
				 'emat_art_id' => $array_data->aflw_art_id,
				 'emat_document_size' =>$file_size
			 );

			 $cron_default_user = array(
				'user_id' => 0,
				'proxy_user_id' => 0);
			$condition=array("emat_file_name"=>$file_name,"emat_art_id"=>$array_data->aflw_art_id);
			 $email_attach_exists = $Email_attachments::get_single_record_with_bind_cond('emat_file_name',$condition, NULL, NULL,NULL,NUll, 'emat_id DESC');
		
			 if (empty($email_attach_exists)) {
				 
				$source = $base_path.'/'.$file_name;
				$destination = public_path() . '/storage/uploads/email_attachments/' . $array_data->aflw_art_id;

				if (!file_exists($destination)){
					mkdir($destination, 0765, TRUE);
				}
				
				$dest_file = $destination . '/' . $file_name;
		$headers = get_headers($source);
			//$exists = strpos($headers[0], '200 OK') !== false;
			$exists = storage::disk('s3')->exists($source);
		 
				//#357 if $source does not exists , PHP error showing for copy function
				if ($exists) {
				
					copy($source, $dest_file);
				}
				$path='email_attachments/' . $array_data->aflw_art_id;
				if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y')
				{
				   
					$this->update_s3_files($path);	

				}
				   
				$email_id=$Email_attachments::insert_record($insert_data,$cron_default_user);
				return $email_id;
			}
	
}
	catch (\Exception $e) {
	
		return $this->failure('Failed', 500, $e);
	}

}
public function formatted_article_data($article_data)
{

	if(!empty($article_data['result']['art_array'])&&$article_data['result']['art_array'])
	{
		$article_data_array=array();
		$art_id_array=array();
		$article_file_size_array=array();
		foreach($article_data['result']['art_array'] as $article)
		{
		
			$article_data_array[$article['art_id']]=$article['attach_name'];
			$article_file_size_array[$article['art_id']]=$article['file_size'];
			array_push($art_id_array,$article['art_id']);
			//$article_data_array['760']=$article['attach_name'];
		}
		$return_array['file_array']=$article_data_array;
		$return_array['file_array_size']=$article_file_size_array;
		//$return_array['id_array']=array(760,758);
		$return_array['id_array']=$art_id_array;
		return $return_array;
	}
}


	// To receive responses from emails and update email_send_log and if there is a need to trigger send an email to other will be handles. 
	public function manage_receive_mail_responses()
	{
		try {
			if (isset($this->current_client->functionality->cfty_receive_email_response) && $this->current_client->functionality->cfty_receive_email_response == 'y') {
				$mail_domain = $_ENV['DOM_EMAIL_EXTENTION'];
				$select = 'esl_trans_mode,esl_read_status,esl_trans_secret_id,esl_posted_date';
				$condition = "esl_trans_secret_id IS NOT NULL AND esl_trans_secret_id LIKE '%{$mail_domain}%' ";
				$email_send_records = Email_send_log::get_all_records($select, $condition);
				$recieved_email_id_array = array();
				$last_update_time =  Email_send_log::get_records_by_raw_query("SELECT esl_response FROM rvw_email_send_log WHERE esl_rply_source = 'e' ORDER BY esl_id DESC LIMIT 1");
				$last_mail_updated_from_exteranl_source = (isset($last_update_time) && isset($last_update_time[0]->esl_response) && !empty($last_update_time[0]->esl_response)) ?  $last_update_time[0]->esl_response : "2025-01-01 00:00:00";
				$last_mail_updated_from_exteranl_source = new DateTime($last_mail_updated_from_exteranl_source);
				$last_mail_updated_from_exteranl_source->modify('-1 day');
				$last_mail_updated_from_exteranl_source = $last_mail_updated_from_exteranl_source->format('d-M-Y');
				$formatted_last_update_time = date("d-M-Y", strtotime($last_mail_updated_from_exteranl_source));

				$run_special_mail_send_secret_array = array(
					//'reviewmailbox-JnVzZXJpZD0xMDg0NSZhcnRpZD04NTEmZmxvd2lkPTEwNzk0JnNlbmR1c2VyaWQ9MTI3MjEmZGF0ZXRpbWU9MjAyNS0wMS0wNyAxMDo1NToxMQ@rivervalley.io'
					//'reviewmailbox-jnvzzxjpzd0ynty3jmfydglkptg1mizmbg93awq9mta0odumc2vuzhvzzxjpzd0wjmrhdgv0aw1lptiwmjutmdetmdmgmdq6mda6mdi@rivervalley.io'
					//'reviewmailbox-JnVzZXJpZD0xOTQ3JmFydGlkPTExNzYmZmxvd2lkPSZzZW5kdXNlcmlkPTE3MiZlc2xwYXJlbnRpZD0zNzQzNCZkYXRldGltZT0yMDI1LTAxLTE1IDA0OjAzOjA4@rivervalley.io'
				);

				$send_email_id_array = array();
				$updated_records = '';
				$logMessage = '';
				if (count($email_send_records) > 0) {
					foreach ($email_send_records as $email_send_data) {
						if ($email_send_data->esl_trans_mode == 's' || $email_send_data->esl_trans_mode == 'r') {
							if (!in_array($email_send_data->esl_trans_secret_id, $send_email_id_array)) {
								$send_email_id_array[] = $email_send_data->esl_trans_secret_id;
							}
							if ($email_send_data->esl_trans_mode == 'r') {
								if (array_key_exists($email_send_data->esl_trans_secret_id, $recieved_email_id_array)) {
									$recieved_email_id_array[$email_send_data->esl_trans_secret_id][] = $email_send_data->esl_posted_date;
								} else {
									$recieved_email_id_array[$email_send_data->esl_trans_secret_id] = [$email_send_data->esl_posted_date];
								}
							}
						}
					}

					if ($mail_domain == '@rivervalley.io') {
						$hostname = "{imap.gmail.com:993/imap/ssl}INBOX"; // for G-suite
					} else if ($mail_domain == '@rivervalleytechnologies.in') {
						$hostname = "{mail.your-server.de:993/imap/ssl}INBOX"; // for hetzner
					}
					$username = $_ENV['IMAP_MAILBOX'];
					$password = $_ENV['IMAP_PASSWORD'];
					$appTimezone = $_ENV["APP_TIMEZONE"];
					$mailbox = imap_open($hostname, $username, $password);
					if (!$mailbox) {
						return "Failed to connect to mailbox: " . imap_last_error();
					}
					foreach ($send_email_id_array as $send_email_id) {
					//foreach($run_special_mail_send_secret_array as $send_email_id){ // for run particular mails secret ids

						$searchToAddress = $send_email_id;
						$searchCriteria = "TO \"$searchToAddress\" SINCE \"$formatted_last_update_time\"";
						$emails = imap_search($mailbox, $searchCriteria); // Search for emails where the specified email address is in the "To" field
						if ($emails) {
							foreach ($emails as $email_number) {
								$email = imap_fetch_overview($mailbox, $email_number, 0);
								$mail_date = new DateTime($email[0]->date);
								$email_secret_data = $this->decrypt_data(str_replace(['reviewmailbox-', $mail_domain], '', $send_email_id));
								parse_str($email_secret_data, $secret_code);
								$mail_recieve_date = $mail_date->setTimezone(new DateTimeZone($appTimezone))->format('Y-m-d H:i:s');
								$result = $this->insert_recieve_email_data($mailbox, $email, $email_number, $send_email_id, $mail_recieve_date);
								if (isset($result) && !empty($result)) {
									$updated_records .= $result . ', ';
								}
							}
						}
					}
					$logMessage = " Cron job triggered at " . date('Y-m-d H:i:s') . " updated rows --- " . $updated_records . " ---" . "\n";
					$logMessage .=  date('d-m-Y H:i:s') . ' : All mail responses are updated. ';
					echo 'All mail responses are updated';
				} else {
					echo 'Already updated all mails';
					$logMessage .=  date('d-m-Y H:i:s') . ' : No mail response requests exist. ';
				}
				$this->recieve_email_log_wirte($logMessage);
			} else {
				echo "Can't be run due to turn off client functionality  ";
			}
		} catch (\Exception $e) {
			$this->recieve_email_log_wirte($e);
			echo 'cron failed';
			return $this->failure('Failed', 422, $e);
		}
	}
	public function insert_recieve_email_data($mailbox, $email, $email_number, $send_email_id, $mail_recieve_date)
	{
		$mail_data = [];
		$mail_domain = $_ENV['DOM_EMAIL_EXTENTION'];
		$jnl_id = '';
		$email_action_type = NULL;
		$parent_id = 0;
		$email_send_log_table = new \App\Models\Email_send_log();

		$email_secret_data = $this->decrypt_data(str_replace(['reviewmailbox-', $mail_domain], '', $send_email_id));
		$decodedData = base64_decode(str_replace(['reviewmailbox-', $mail_domain], '', $send_email_id), true);

		if (!(ctype_print($decodedData))) {
			$secret_check = "esl_trans_secret_id LIKE '%{$send_email_id}%' ORDER BY esl_id ASC ";
			$mail_secret_data = $email_send_log_table::get_single_record('esl_trans_secret_id', $secret_check);
			if (isset($mail_secret_data) && !empty($mail_secret_data->esl_trans_secret_id)) {
				$email_secret_data = $this->decrypt_data(str_replace(['reviewmailbox-', $mail_domain], '', $mail_secret_data->esl_trans_secret_id));
			}
			else{
				return $secret_check;
			}
		}
		parse_str($email_secret_data, $secret_data);
		$esl_parent_id = isset($secret_data['eslparentid']) ? $secret_data['eslparentid'] : NULL;
		if (!empty($esl_parent_id)) {
			$cond = "esl_id ={$esl_parent_id}";
			$mail_log_data = $email_send_log_table::get_single_record('esl_id,esl_user_id,esl_article_id,esl_aflw_id,esl_posted_by,esl_etmp_action', $cond);
			$send_user_id = ($mail_log_data->esl_user_id) ? $mail_log_data->esl_user_id : NULL;
			$received_user_id = ($mail_log_data->esl_posted_by) ? $mail_log_data->esl_posted_by : NULL;
			$article_id = ($mail_log_data->esl_article_id) ? $mail_log_data->esl_article_id : NULL;
			$article_flow_id = ($mail_log_data->esl_aflw_id) ? $mail_log_data->esl_aflw_id : NULL;
			$email_action_type = ($mail_log_data->esl_etmp_action) ? $mail_log_data->esl_etmp_action : NULL;
			$parent_id = $esl_parent_id;
		} else {
			$send_user_id = isset($secret_data['userid']) ? $secret_data['userid'] : NULL;
			$received_user_id = isset($secret_data['senduserid']) ? $secret_data['senduserid'] : NULL;
			$article_id = isset($secret_data['artid']) ? $secret_data['artid'] : NULL;
			$article_flow_id = isset($secret_data['flowid']) ? $secret_data['flowid'] : NULL;
			$parent_details =  $email_send_log_table::get_records_by_raw_query("SELECT esl_id FROM rvw_email_send_log WHERE esl_trans_secret_id = '{$send_email_id}' ORDER BY esl_id ASC LIMIT 1");
			$parent_id = $parent_details[0]->esl_id;
		}
		if ($article_id) {
			$jnl_query = "SELECT artp_jnl_id AS jnl_id FROM `rvw_article_types` LEFT JOIN rvw_articles on art_artp_id = artp_id WHERE art_id = ? ";
			$bind_arr[] = $article_id;
			$jnl_id_details = Article_types::get_records_by_raw_query($jnl_query, false, $bind_arr);
			if (isset($jnl_id_details) && !empty($jnl_id_details[0]->jnl_id)) {
				$jnl_id = $jnl_id_details[0]->jnl_id;
			}
		}
		$journal_default_mail_id = $this->get_reply_to_email($jnl_id);

		$mail_data['esl_user_id'] = $received_user_id;
		$mail_data['esl_article_id'] = $article_id ? $article_id : null;
		$mail_data['esl_aflw_id'] = $article_flow_id;
		$mail_data['esl_etmp_action'] = $email_action_type;
		//$mail_data['esl_posted_by'] = $send_user_id;
		$mail_data['esl_content'] = $this->getMainContent($mailbox, $email_number, '1.2');
		$mail_data['esl_subject'] = $email[0]->subject;

		$headers = imap_fetchheader($mailbox, $email_number);
		preg_match_all('/To:\s*([^<]*<)?([^>,]+@[^>,]+)\s*>?/i', $headers, $matches);
		// Combine the matched email addresses
		$toAddresses = isset($matches[2]) ? $matches[2] : [];
		$mail_data['esl_reply_to'] = $toAddresses[0];
		$mail_data['esl_to'] = $this->getUserEmailid($secret_data['senduserid']);
		$usr_id = $this->getUserid($toAddresses[0]);
		$mail_data['esl_posted_by'] = $usr_id;
		// Get CC and BCC 
		$ccBccInfo = $this->getCCandBCC($mailbox, $email_number);
		$mail_data['esl_cc'] = $ccBccInfo['cc'];
		$mail_data['esl_bcc'] = $ccBccInfo['bcc'];
		$mail_data['esl_success_status'] = 'y';
		$mail_data['esl_trans_mode'] = 'r';
		$mail_data['esl_read_status'] = 'u';
		$mail_data['esl_rpid'] = $parent_id;
		//$mail_data['esl_trans_secret_id'] = $send_email_id;
		$mail_data['esl_response'] = $mail_recieve_date;
		$mail_data['esl_posted_date'] = $mail_recieve_date;
		$mail_data['esl_rply_source'] = 'e';
		$mail_data['esl_operation'] = 'm';
		$mail_data['esl_proxy_id'] = 0;

		if ($received_user_id == 0) {
			$received_user_id = 0;
			$mail_data['esl_user_id'] = $received_user_id;
			$mail_data['esl_to'] = $journal_default_mail_id;
		}

		$data_exist_check = "esl_user_id ={$received_user_id} AND esl_reply_to = '{$mail_data['esl_reply_to']}' AND esl_trans_mode = 'r' AND esl_response = '{$mail_recieve_date}' ";
		$already_exist_mail_log = $email_send_log_table::get_single_record('esl_id,esl_trans_secret_id,esl_posted_date', $data_exist_check);

		if (empty($already_exist_mail_log)) {

		//set batch id 
		$batch_id = '';
		$Batch_id_generate_table = new \App\Models\Batch_id_generate();
		$insert_data = array(
			'btchgen_posted_date' => date('Y-m-d H:i:s'),
		);
		if ($batch_id == '') {
			$batch_id = $Batch_id_generate_table::insert_batch_id();
		}
		$mail_data['esl_batch_id'] = $batch_id;
		// Get email attachments
		$attachments = $this->getAttachments($mailbox, $email_number);
		$receive_mail_attachment_details = [];
		if (count($attachments)) {
			$file_insert_data = $this->saveAttachments($attachments, $secret_data['userid'], $mail_recieve_date, $secret_data['artid'], $received_user_id, $usr_id);
			$mail_data['esl_attachments'] = $file_insert_data['data'];
			$receive_mail_attachment_details = $file_insert_data['files_with_paths'];
		} else {
			$mail_data['esl_attachments'] = NULL;
			$receive_mail_attachment_details = [];
		}
		$recieved_esl_id = $email_send_log_table::insert_receive_record($mail_data);
			$encrypt_dynamic_data = $this->encrypt_data('&userid=' . $received_user_id . '&artid=' . $article_id . '&flowid=' . $article_flow_id . '&senduserid=' . $send_user_id . '&eslparentid=' . $recieved_esl_id . '&datetime=' . date("Y-m-d H:i:s"));
			$encrypt_dynamic_data = $this->custom_base64_encoded_data($encrypt_dynamic_data);
			$dynamic_secret_mail_id = 'reviewmailbox-' . $encrypt_dynamic_data . $mail_domain;
			$mail_data['esl_trans_secret_id'] = $dynamic_secret_mail_id;
			Email_send_log::where('esl_id', $recieved_esl_id)->update(
				[
					'esl_trans_secret_id' => $dynamic_secret_mail_id,
					'esl_operation' => 'm'
				]
			);
			$this->forward_to_received_reply_mail_to_user($mail_data, $receive_mail_attachment_details);
		return $recieved_esl_id;
		}
	}

	public function getAttachments($inbox, $email_number)
	{
		$attachments = [];
		$structure = imap_fetchstructure($inbox, $email_number);
		if (isset($structure->parts) && count($structure->parts) > 0) {
			foreach ($structure->parts as $part_number => $part) {
				if (isset($part->disposition, $part->dparameters)) {
					$sizeInBytes = $part->bytes;
					$sizeInKB = round($sizeInBytes / 1024, 3); // Convert bytes to KB and round to 3 decimal places	
					for($i=0;$i<count($part->dparameters);$i++){
						if(isset($part->dparameters[$i]->attribute) && $part->dparameters[$i]->attribute == 'FILENAME'){
							$attachment = [
								'filename' => $part->dparameters[$i]->value,
								'size' => $sizeInKB, // Size in KB
								'content' => decrypt_link(imap_fetchbody($inbox, $email_number, $part_number + 1)),
							];
							$attachments[] = $attachment;
							break;
						}
					}
				}
			}
		}
		return $attachments;
	}

	public function saveAttachments($attachments, $send_user_id, $mail_recieve_date, $art_id, $received_user_id, $user_in_system_id)
	{
		$email_attachment_table = new \App\Models\Email_attachments();
		$file_attachment_array = ["modified" => []];
		$file_array = array();
		$file_data_array = array();
		$return_file_data_array = array();
		foreach ($attachments as $attachment) {
			/* Define the local path where you want to save the attachments */
			$attachment['filename'] = str_replace(' ', '_', $attachment['filename']); 		// 	Task #3301, if filename have spaces ' '-> change that into '_'
			$localPath = storage_path("app/public/{$attachment['filename']}");
			file_put_contents($localPath, $attachment['content']);
			$send_user_id = $user_in_system_id != 0 ? $user_in_system_id : $send_user_id;
			$fullpath = "email_attachments/{$send_user_id}/{$received_user_id}/receive";
			$check_path_exist = storage_path() . '/app/public/uploads/' . $fullpath;
			if (!file_exists($check_path_exist)) {
				mkdir($check_path_exist, 0765, TRUE);
			}
			if ($this->current_client->enable_upload_s3_bucket == 'y') {
				$aws = true;
				$this->update_s3_files($fullpath);
			}
			$insert_data = array(
				'emat_file_name' => $attachment['filename'],
				'emat_document_size' => $attachment['size'],
				'emat_ade_id' => NULL,
				'emat_ane_id' => NULL,
				'emat_agf_id' => NULL,
				'emat_art_id' => $art_id,
				'emat_action_status' => 'r',
				'emat_posted_date' => $mail_recieve_date,
				'emat_operation' => 'i'
			);
			/* Save the attachment content to the file in the "public" disk */
			$uploaded_file_details = $this->upload_file_handler($fullpath, $localPath, $attachment['filename']);
			array_push($file_data_array, $uploaded_file_details);
			$user_arr = array(
				'user_id' => $send_user_id,
				'proxy_user_id' => 0
			);
			$attachment_id = $email_attachment_table::insert_receive_attachment_record($insert_data, $user_arr);
			$file_attachment_array["modified"][$attachment_id] = $attachment['filename'];
			unlink($localPath);
		}
		if (!empty($file_data_array)) {
			$fullpath = "email_attachments/{$send_user_id}/{$received_user_id}/receive";
			$file_path = storage_path() . '/app/public/uploads/' . $fullpath;
			foreach ($file_data_array as $file) {
				$file_array[$file['name']] = $file_path . '/' . $file['name'];
			}
		}
		$return_file_data_array['data'] = json_encode($file_attachment_array);
		$return_file_data_array['files_with_paths'] = ($file_array);
		return $return_file_data_array;
	}

	public function getCCandBCC($inbox, $email_number)
	{
		$headers = imap_headerinfo($inbox, $email_number);
		$hdr_raw = imap_fetchheader($inbox, $email_number);
		$headerinfo = imap_rfc822_parse_headers($hdr_raw);

		$cc = isset($headerinfo->cc) && !empty($headerinfo->cc) && count($headerinfo->cc) > 0 ? $headerinfo->cc : [];
		$bcc = isset($headerinfo->bcc) && !empty($headerinfo->bcc) && count($headerinfo->bcc) > 0 ? $headerinfo->bcc : [];
		$cc = is_array($cc) ? $cc : [$cc];
		$bcc = is_array($bcc) ? $bcc : [$bcc];
		$cc = array_filter($cc);
		$bcc = array_filter($bcc);
		$ccEmails = array_map(function ($item) {
			return $item->mailbox . '@' . $item->host;
		}, $cc);
		$bccEmails = array_map(function ($item) {
			return $item->mailbox . '@' . $item->host;
		}, $bcc);
		$ccEmailsdata = implode(',', $ccEmails);
		$bccEmailsdata = implode(',', $bccEmails);
		return ['cc' => $ccEmailsdata, 'bcc' => $bccEmailsdata];
	}

	public function getMainContent($inbox, $email_number, $num)
	{
		$struct = imap_fetchstructure($inbox, $email_number);
		$parts = is_array($struct->parts) ? $struct->parts : array();
		$i = 0;
		$body = '';
		$content = "";
		if (empty($parts)) {
			$body = imap_body($inbox, $email_number);
			$encoding = $struct->encoding; // Get the encoding
			$content = $this->decodeContent($body, $encoding);
		} else {
			$endwhile = false;
			$stack = array();
			while (!$endwhile) {
				if (!isset($parts[$i])) {
					if (count($stack) > 0) {
						$parts = $stack[count($stack) - 1]["p"];
						$i = $stack[count($stack) - 1]["i"] + 1;
						array_pop($stack);
					} else {
						$endwhile = true;
					}
				}
				if (!$endwhile) {
					$partstring = "";
					foreach ($stack as $s) {
						$partstring .= ($s["i"] + 1) . ".";
					}
					$partstring .= ($i + 1);
					if (isset($parts[$i]->subtype) && strtoupper($parts[$i]->subtype) == "HTML") {
						$body .= imap_fetchbody($inbox, $email_number, $partstring);
						$encoding = $parts[$i]->encoding;
						$content .= $this->decodeContent($body, $encoding);
					}
				}
				if (isset($parts[$i]->parts) && is_array($parts[$i]->parts)) {
					$stack[] = array("p" => $parts, "i" => $i);
					$parts = $parts[$i]->parts;
					$i = 0;
				} else {
					$i++;
				}
			}
		}
		$decodedContent = quoted_printable_decode($content);
		$return_data = html_entity_decode($decodedContent, ENT_QUOTES | ENT_HTML5, 'UTF-8');
		$extractedContent = $this->processEmailContent($return_data);
		/* print_r(htmlspecialchars_decode($extractedContent));
		die; */
		return $extractedContent;
	}

	public function decodeContent($content, $encoding)
	{
		switch ($encoding) {
			case 0: // 7BIT (no encoding)
				return $content;
			case 1: // 8BIT (no encoding)
				return $content;
			case 3: // BASE64 encoding
				return base64_decode($content);
			case 4: // QUOTED-PRINTABLE encoding
				return quoted_printable_decode($content);
			default:
				return $content;
		}
	}

	public function removeQuotedText($node)
	{
		if ($node->nodeType === XML_ELEMENT_NODE) {
			foreach ($node->childNodes as $child) {
				if ($child->nodeType === XML_ELEMENT_NODE && ($this->shouldRemoveNode($child))) {
					$node->removeChild($child);
				} else {
					// Recursively check for quoted text inside the child nodes
					$this->removeQuotedText($child);
				}
			}
		}
	}
			
	private function shouldRemoveNode($child)
	{
	    	return (
			$child->nodeName === 'blockquote' || 
			(strpos($child->getAttribute('class'), '_quote') !== false) || 
			(strpos($child->getAttribute('class'), 'MsoNormalTable') !== false) || 
			(strpos($child->getAttribute('style'), '#E1E1E1') !== false) || 
			(strpos($child->getAttribute('style'), 'background-color:#ffffff') !== false) || 
			(strpos($child->getAttribute('style'), '#718096') !== false) || 
			(strpos($child->getAttribute('id'), 'appendonsend') !== false) || 
			(strpos($child->getAttribute('id'), 'divRplyFwdMsg') !== false) || 
			(strpos($child->getAttribute('class'), 'x_wrapper') !== false) || 
			(strpos($child->getAttribute('class'), 'x_content') !== false) || 
			(strpos($child->getAttribute('style'), '#718096') !== false)
	   	 );
	}

	public function extractSignature($node, $doc)
	{
		$signature = '';
		if ($node->nodeType === XML_ELEMENT_NODE) {
			foreach ($node->childNodes as $child) {
				if ($child->nodeType === XML_ELEMENT_NODE && ($child->getAttribute('class') === 'gmail_signature' || strpos($child->getAttribute('class'), 'signature') !== false)) {
					$signature .= $doc->saveHTML($child);
					$node->removeChild($child);
					break;
				} else {
					$signature .= $this->extractSignature($child, $doc);
					break;
				}
			}
		}
		return $signature;
	}

	private function processEmailContent($html)
	{
		$doc = new \DOMDocument();
		libxml_use_internal_errors(true);
		$doc->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
		libxml_clear_errors();
		// to keep the special tags if exist in the reply mail content, and also filter(quoted contents) from the xpath data.
		$xpath = new \DOMXPath($doc);
		$nodes = $xpath->query('//body');		
		foreach ($nodes as $node) {
    			$this->removeQuotedText($node);
		}

		// Check if the document is already in UTF-8 format or not
		if ($doc->xmlEncoding != 'UTF-8') {
			$doc->encoding = 'UTF-8';
			$utf8_xml = $doc->saveXML();
			$doc = new \DOMDocument();
			libxml_use_internal_errors(true);
			$doc->loadHTML(mb_convert_encoding($utf8_xml, 'HTML-ENTITIES', 'UTF-8'), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
			libxml_clear_errors();
		}
		$this->removeQuotedText($doc->documentElement);
		/*
			-> Extract signature from the content 
			-> Append signature if it exists 
		*/
		$signature = $this->extractSignature($doc->documentElement, $doc);
		$content = $doc->saveHTML();
		if ($signature) {
			$content .= '<br>' . $signature;
		}
		$search = array("&Acirc;", "Â");
		$replace = array("", ""); 
		$content = str_replace($search, $replace, $content);
		return $content;
	}

	public function getUserEmailid($user_id)
	{
		if (!empty($user_id)) {
			$cond = "usr_id ={$user_id}";
			$user_data = User::get_single_record('usr_email', $cond);
			if (!empty($user_data)) {
				return $user_data->usr_email;
			}
		} else {
			return "";
		}
	}
	public function getUserid($email_from_id)
	{
		if (!empty($email_from_id)) {
			$usr_cond = "usr_email ='{$email_from_id}'";
			$usr_alter_cond = "uml_email ='{$email_from_id}'";
			$user_data = User::get_single_record('usr_id', $usr_cond);
			$user_alter_mail_data = User_emails::get_single_record('uml_user_id', $usr_alter_cond);
			if (!empty($user_data)) {
				return $user_data->usr_id;
			} else if (!empty($user_alter_mail_data)) {
				return $user_alter_mail_data->uml_user_id;
			} else {
				$user_id = 0;
				return $user_id;
			}
		} else {
			return "";
		}
	}
	public function recieve_email_log_wirte($msg)
	{
		$receive_mail_log_path = public_path() . '/storage/logs/receivemaillog/';
		;
		if (file_exists($receive_mail_log_path) == FALSE) {
			mkdir($receive_mail_log_path, 0777);
		}
		$log_file = $receive_mail_log_path . date("dmY", time()) . ".log";
		$handle = fopen($log_file, "a+");
		fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $msg . "\r\n\r\n\r\n");
		fclose($handle);
	}
	public function build_users()
   {
	try
	{
	$userdata=User::get_single_record('count(usr_id) as count');
	$count_user=$userdata->count;
	$usr_latest_id=$count_user+1;
	
	for($i=$usr_latest_id;$i<100;$i++)
	{
	$array=array("usr_user_legacy_id"=> null,
		 "usr_username"=> "Rv_user_".$i,
		 "usr_pwd_original"=> "733d7d737c3ed2b0adc36a010b24f4fb",
		 "usr_pwd"=> '$2a$10$IiExah6A9nMFCVmbNtUmnOhoR3.XTfSQKztxCzDBHoAHE91EbKZva',
		 "usr_title"=> "mr",
		 "usr_first_name"=> "Rv_user_first_name_".$i,
		 "usr_middle_name"=> null,
		 "usr_last_name"=> "last_name_".$i,
		 "usr_email"=> "test".$i."@reviewdemo.rivervalleytechnologies.com",
		 "usr_website"=> null,
		 "usr_twitter_id"=> null,
		 "usr_github_id"=> null,
		 "usr_dnd"=> "n",
		 "usr_dnd_marketing"=> null,
		 "usr_dnd_share_data"=> null,
		 "usr_dnd_jnls"=> null,
		 "usr_status"=> "a",
		 "usr_institution"=> null,
		 "usr_postal_code"=> "666 666",
		 "usr_phone_no"=> "(91)4555944731126".$i,
		 "usr_registered"=> "n",
		 "usr_filter_key"=> null,
		 "usr_home_filter_keys"=> '{"article_code":"","article_title":"","journals":"","article_type":"","stage_name":"","my_task":"1","jnlcd":""}',
		 "usr_home_sort_keys"=> null,
		 "usr_url"=> null,
		 "usr_activation"=> "n",
		 "usr_deeplink_token"=> "",
		 "usr_roles"=> '[]',
		 "usr_jnl_standalone"=> null,
		 "usr_image"=> "",
		 "usr_thumb_preference"=> "list",
		 "usr_f_status"=> "n",
		 "usr_terms_condition"=> "y",
		 "usr_last_review_invite"=> date('Y-m-d h:i:s'),
		 "usr_orcid_response"=> null,
		 "usr_reg_date"=> date('Y-m-d h:i:s'),
		 "usr_reauthorised_date"=> null,
		 "usr_mfa_token"=> null,
		 "usr_alt_totps"=> null,
		 "usr_gender"=> "n",
		 "usr_ethnicity"=> '',
		 "usr_race"=> '',
		 "usr_posted_by"=> 1,
		 "usr_posted_date"=> date('Y-m-d h:i:s'),
		 "usr_proxy_id"=> 0,
		 "usr_operation"=> "u",
		 "usr_orcid_id"=> null,
		 "usr_orcid_token"=> null);
		 User::insert($array);	 
   }
}
   catch(\Exception $e)
		{
			return  $this->failure('Failed',422,$e);
		}
}

	/* End TASK #4801 */
	public function ithenticate_v2_callbacks(Request $request)
	{
		try
		{
			$post_data = $request->all();
			$this->iThenticatev2Log($request);
			
			$update_data = array();
			$sid = NULL;
			$ithv2_url = '';
			$artId = null;

			if(isset($post_data['submission_id']))//for update similarity report 
			{
				//$response_arr = (array) json_decode($post_data);
				$response_arr = $post_data;
				//similarity response
				if(isset($response_arr['submission_id']) && isset($response_arr['overall_match_percentage']) && isset($response_arr['top_source_largest_matched_word_count']))
				{
					$document_id = $response_arr['submission_id'];
					$ith_api_condition = $this->getIthenticatecred($document_id,$artId);

					$credential = $this->get_credentials($ith_api_condition);
					if(isset($credential['password']))
                    {
                        $sid = $credential['password'];
                        $ithv2_url = $credential['username'];
					}
					if($sid != NULL)
					{
						$criteria = "pdf_ith_document_id = '{$document_id}'";
						$current_user = array(
							'user_id' => 0,
							'proxy_user_id' => 0
						);

						//get report status
						$body = array(
							'doc_id'=>$document_id
						);
						$response_rep = $this->do_call_v2($ithv2_url,$body,$sid,'PUT','similarityreport_status');
						$response_rep_arr = (array) json_decode($response_rep);

						if(isset($response_rep_arr['status']) && $response_rep_arr['status'] == 'COMPLETE')
						{
							//$response = json_encode($post_data);
							$update_data = $this->prepare_for_artPdfUpdate($response_rep);
							if(count($update_data) > 0)
							{
								$update_data['pdf_posted_date'] = date('Y-m-d H:i:s');
								Article_pdf::updateData($update_data, $criteria);
							}
						}
					}
					
				}
			}
			elseif(isset($post_data['id']) && isset($post_data['status']) && $post_data['status'] == 'COMPLETE' && isset($post_data['word_count']) && isset($post_data['created_time']))//for update article submission details -- word count
			{
				$body = array(
					'doc_id'=>$post_data['id']
				);
				$ith_api_condition = $this->getIthenticatecred($post_data['id'],$artId);
				$credential = $this->get_credentials($ith_api_condition);
				if(isset($credential['password']))
				{
					$sid = $credential['password'];
					$ithv2_url = $credential['username'];
				}

				//Checking submission status
				$response_rep = $this->do_call_v2($ithv2_url,$body,$sid,'PUT','submit_status');
                $response_rep_arr = (array) json_decode($response_rep);

				if(isset($response_rep_arr['status']) && $response_rep_arr['status'] == 'COMPLETE')
				{
					$update_data['pdf_word_count'] =  $response_rep_arr['word_count'];
					$update_data['pdf_ith_v2_action_type'] = 'c';
					$update_data['pdf_operation'] =  'u';
					$update_data['pdf_ith_submission_status'] =  'S';
					$update_data['pdf_ith_v2_fileupload_status'] =  'y';
					$update_data['pdf_posted_date'] = date('Y-m-d H:i:s');
					$update_data['pdf_ith_submission_message'] =  customTrans('ithenticate.ithenticate_submit_success');

					$criteria = "pdf_ith_document_id = '{$post_data['id']}' AND pdf_ith_v2_fileupload_status = '' ";
				
					$current_user=$this->posted_poxy_status($post_data['id']);
					Article_pdf::update_record($update_data, $criteria,$current_user);
					//CALL REPORT GENERATION FUNCTION
					$similarity_report = $this->similarity_report($post_data['id'], $sid, $ith_api_condition,$artId);		
					
				}
				
			}
			
		}
		catch(\Exception $e)
		{
			$this->iThenticatev2Log($e->getMessage());
		}
	}

	/**
	 * CLEAR SIMILARITY CHECK RESULTED FILES UNDER THE PATH :public/storage/uploads/python_script
	 * 
	 */

	 public function clear_similarityCheck_resulted_files()
	 {
		try
		{
			$duplicate_check_upload = 'uploads/python_script';
			$duplicate_check_file_path =  $this->get_upload_path($duplicate_check_upload,FALSE,'storage',TRUE);

			if(file_exists($duplicate_check_file_path) && strpos($duplicate_check_file_path, 'python_script') !== FALSE)
			{
				delfolder($duplicate_check_file_path,FALSE);
			}
		}
		catch(\Exception $e)
		{
			$this->iThenticatev2Log($e->getMessage());
		}
	 }

	 /**
	  * c -- cancel on rvw_ithenticate_auto_submit
	  * THIS CRON CHECK IF THERE IS ANY ITHENTICATE V2 TASK IS IN 'INPROGRESS' (30 MINS INTERVAL) THEN
	  * IT INSERT/UPDATE INTO rvw_ithenticate_auto_submit TABLE FOR  10 MINS AUTO RUN
	  * sp - submission pending
	  * rp - report generation pending
	  *	ct - cancel task
	  * c  - completed
	  */
	public function iThenticateAwaitingTask()
	{
		try
		{
			if(isset($this->current_client->functionality->cfty_ithenticate_v2) &&  isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
			{
				$currentDateTime = new DateTime();
				$onedayback = clone $currentDateTime;
				$onedayback->modify('-24 hours');

				$current_user = array(
					'user_id' => 0,
					'proxy_user_id' => 0
				);

				$select = 'pdf_id,pdf_ith_similarity_percentage,pdf_art_id,pdf_aflw_id,art_artp_id,pdf_ith_v2_action_type,pdf_ith_v2_action_date,ias_id,ias_pdf_id,ias_artp_id,ias_status,ias_retry_count';
				$cond = 'pdf_ith_v2_action_type IN (\'sp\',\'rp\') and pdf_ith_version = \'v2\' and pdf_ith_similarity_percentage = 0';
				//DB::enableQueryLog();
				$Article_pdf_table = (new \App\Models\Article_pdf())->getTable();
				$Articles_table = (new \App\Models\Articles())->getTable();
				$Ithenticate_autosubmission_table = (new \App\Models\Ithenticate_autosubmission())->getTable();

				//$inproTasks = Article_pdf::get_all_records($select,$cond);
				$tables = array(
					'main_table' => $Article_pdf_table,
					'join_table' => array(
					$Articles_table => array('pdf_art_id','art_id'),
                	$Ithenticate_autosubmission_table => array('pdf_id','ias_pdf_id','left')
				));
				$inproTasks =  Article_pdf::get_results_using_joins($tables, $select, $cond,'all');
				//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
				if(!empty($inproTasks))
				{
					//all check 30 mins. exceed
					//1.in no entry in auto ith. then insert date not exceed one day
					//2.if ithen. entry in auto table.  then check the check the status (if articlepdf table sp/rp and auto table having status y then update with pending)
					//3.if exceed 24hrs then pdf_ith_v2_action_type marked as c 
					foreach($inproTasks as $task)
					{
						$cond_pdf = array(
							'pdf_id' => $task->pdf_id
						);
						
						$tasktime = new DateTime($task->pdf_ith_v2_action_date);
						if($currentDateTime >= $tasktime  && $onedayback <= $tasktime)
						{
							//1.in no entry in auto ith. then insert date not exceed one day
							if($task->ias_id == null)
							{
								$autoSubmit = array(
									'ias_pdf_id' => $task->pdf_id,
									'ias_artp_id'=>$task->art_artp_id,
									'ias_clnt_id' => $this->current_client->clnt_id,
									'ias_status' => 'n',
									//'ias_retry_count'=> '0'
								);
								Ithenticate_autosubmission::insert_record($autoSubmit,$current_user);
							}
							elseif($task->ias_id != null && $task->pdf_ith_similarity_percentage == 0 && $task->ias_status == 'y' && ($task->pdf_ith_v2_action_type == 'sp' ||  $task->pdf_ith_v2_action_type == 'rp'))
							{	//auto submit condition
								//2.if ithen. entry in auto table.  then check the check the status (if articlepdf table sp/rp and auto table having status y then update with pending)
								$update_arr = array(
									'ias_status' => 'n',
									'ias_retry_count' => 0
								);
								$cond_autosubmit = array(
									'ias_id' => $task->ias_id
								);
								Ithenticate_autosubmission::update_record($update_arr, $cond_autosubmit, $current_user);
							}
						}
						else
						{
							//3.if exceed 24hrs then pdf_ith_v2_action_type marked as ct  --- task cancelled
							$update_arr = array(
								'pdf_ith_v2_action_type' => 'ct',
								'pdf_ith_v2_action_date' => date('Y-m-d H:i:s')
							);
							Article_pdf::update_record($update_arr, $cond_pdf, $current_user);
							if($task->ias_id != null)
							{
								$update_arr = array(
									'ias_status' => 'c',
								);
								$cond_autosubmit = array(
									'ias_id' => $task->ias_id
								);
								Ithenticate_autosubmission::update_record($update_arr, $cond_autosubmit, $current_user);
							}
						}
					}
				}
			}
		}
		catch(\Exception $e)
		{
			//echo '<pre>';print_r($e);exit;
			$this->iThenticatev2Log($e->getMessage());
		}
	}

	public function iThenticatev2Log($request)
	{
		$app_log = General_ConfigTraits::General_config_data('ITHENTICATE_WEBHOOK_LOG_PATH');
		$app_log_path = $app_log['ITHENTICATE_WEBHOOK_LOG_PATH'];
		
		if (file_exists($app_log_path) == FALSE)
		{
			mkdir($app_log_path,0777,true);
		}
		
		if($app_log_path != '')
		{
			$log_file = $app_log_path . date("dmY", time()) . ".log";
			$handle = fopen($log_file, "a+");
			fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $request . "\r\n\r\n\r\n");
			fclose($handle);
		}
		return true;

	}
    // TASK #9425 Convey Integration In Review3
	public function sendConveyDisclosureReminderCron(){
		try
		{
			if(isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y')
			{
				$Email_templates = new \App\Models\Email_templates();
				$ConveyData_table = new \App\Models\ConveyData();
				$convey_articles_list = $ConveyData_table::where('rcd_disclosure_cmpltn_status','!=', 'c')->get(['rcd_id','rcd_usr_id','rcd_art_id','rcd_discloser_id','rcd_last_invited_date']);
				foreach($convey_articles_list  as $articles_list)
				{ 
					$dicloser_details=app(ConveyService::class)->getDiscloserData($articles_list->rcd_usr_id,$articles_list->rcd_art_id);
					$email_template_data = $Email_templates::get_single_record('etmp_id,etmp_remind_days',"etmp_name='reminder_disclosure_convey_email'");
					$last_invited_date=Carbon::parse($articles_list->rcd_last_invited_date);
					$today = Carbon::today();
					$remaining_days=$email_template_data->etmp_remind_days;
					if($dicloser_details['disclosureStatus']['id']!='completed'&&!empty($email_template_data) && $last_invited_date->diffInDays($today)>=$remaining_days)
					{
						(new Manage_Email_Api())->sendConveyDisclosureEmail($articles_list->rcd_discloser_id,'reminder_disclosure_convey_email','cron_job');					
						$ConveyData_table::where('rcd_id',$articles_list->rcd_id)->update(['rcd_last_invited_date' => $today]);
						// $this->sendConveyDisclosureReminder($articles_list->rcd_art_id,$articles_list->rcd_usr_id,$dicloser_details['disclosureStatus']['id']);
					}
					else{
						$ConveyData_table::where('rcd_id',$articles_list->rcd_id)->update(['rcd_disclosure_cmpltn_status' => 'c']);
					}			
				}
			}		
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',422,$e);
		}
	}
	public function cron_send_report()
	{
		try {
			$cron_send_status = array();
			$date = date('d_m_Y');
			$report_cron_full_path = storage_path('/app/public/uploads/' . config('report_generation')['report_cron_send_path'] . '/' . $date . '/');
			/*
				1.Fetch send reports 
			*/
			$where_condition = '((DATEDIFF(CURDATE(),DATE_FORMAT(`rmil_report_last_sent`,\'%Y-%m-%d\')) >= 1  AND `rmil_report_period` = \'d\') OR (DATEDIFF(CURDATE(),DATE_FORMAT(`rmil_report_last_sent`,\'%Y-%m-%d\')) >= 7 AND `rmil_report_period` = \'w\') OR (date(DATE_FORMAT(`rmil_report_last_sent`,\'%Y-%m-%d\') + INTERVAL 1 MONTH ) <= CURDATE() AND `rmil_report_period` = \'m\'))';
			$report_send_data = Reports_email::get_all_records('*,IF(rmil_report_format = \'p\',\'pdf\',\'csv\') as export_type', $where_condition);
			/*
				2.Check fetch result having data
			*/
			// print_r($report_send_data);die;
			if (count($report_send_data) > 0) {
				$created_file_list = array();
				/* 
					create if the folder doesnt exist
				*/
				if (!file_exists($report_cron_full_path)) {
					mkdir($report_cron_full_path, 0765, TRUE);
				}
				/*
					2.2 Looping  fetched data
				*/
				$i=0;
				foreach ($report_send_data as $snd_report) {
					$created_file_data = array();
					/*
				 		2.2.1 Check current report file is created and saved in file or not-- if created then access its data from $created_file_list array
				 	*/
					$created_file_name = Reports_model::get_single_record('rep_title', 'rep_id=' . $snd_report->rmil_rep_id)->rep_title;
					if (isset($created_file_list[$snd_report->rmil_rep_id][$snd_report->export_type])) {
						$created_file_data['file'] = $report_cron_full_path . $created_file_name . '.' . $snd_report->export_type;
						/*
						* 2.2.2 if current report file not created 
						*/
					} else {
						/*
						* 2.2.2.1  Call $this->report_lib->generate_report_file() to create in specific path
						*/
						$processed_data = (new Manage_Reports_Api())->process_download($snd_report->rmil_rep_id, $snd_report->rmil_report_format, $report_cron_full_path);
						if(!isset($processed_data['file_name']) && $processed_data['status'] == 'warning'){
							//break the loop and continue with the next iteration if the current report doesnt have any columns to produce a result
							continue;
						}
						$created_file_data['file'] = $report_cron_full_path . Rv_decrypt($processed_data['file_name']);
						$report_generation_job_data = $processed_data['report_generation_job_data'];
						// print_r($created_file_data);die;
						/*
						* 2.2.2.2 Assign created file details to $created_file_list array
						*/
						$created_file_list[$snd_report->rmil_rep_id][$snd_report->export_type] = $created_file_name;
					}
					$snd_report->attachment = $date .'/'. Rv_decrypt($processed_data['file_name']);
					$snd_report->subject = $created_file_name . ' ' . $date; 
					$cron_send_status[] =  $this->cron_mail_trigger($snd_report, $created_file_data, $report_generation_job_data);
					Reports_email::update_record(array(
						'rmil_report_last_sent' => date('Y-m-d H:i:s')
					), array(
						'rmil_id' => $snd_report->rmil_id
					));
					$cron_default = array(
						'user_id' => 0,
						'proxy_user_id' => 0
					);
					$report_log_data = array(
						'resl_rep_id' => $snd_report->rmil_rep_id,
						'resl_esl_id' => $cron_send_status[$i]['esl_id'],
						'resl_rmil_report_period' => $snd_report->rmil_report_period
					);
					Report_email_sent_log::insert_record($report_log_data, $cron_default);
					$i++;
				}
				return $cron_send_status;
				// print_r($cron_send_status);die;
			}
		} catch (\Exception $e) {
			// print_r($e);die;
			return  $this->failure('Failed', 422, $e);
		}
	}

	public function forward_to_received_reply_mail_to_user($mail_data = [],$attachment_array = [])
	{
	$email_config = 'clients.' . $this->current_client->clnt_client_code ;
        $email_config_data=Config::get($email_config.'.email');
        $from_address_email =$email_config_data['email_settings']['email_from_address'];
        $from_name=$email_config_data['email_settings']['email_from_alias'];
        if(env('APP_ENV') != 'local'){
            $from_address_email =$email_config_data['email_settings']['email_from_address'];
            $from_name=$email_config_data['email_settings']['email_from_alias'];
        }else{
            $from_address_email =env('MAIL_FROM_ADDRESS');
            $from_name=env('MAIL_FROM_NAME');
        }
	if(isset($mail_data) && !empty($mail_data)){
			// $send_array['replay_to'] = $mail_data['esl_reply_to'] ?? null;
			$send_array['replay_to'] = 'replytest@reviewdemo.rivervalleytechnologies.com';
			$send_array['to'] = $mail_data['esl_to'] ?? null;
			$send_array['cc'] = $mail_data['esl_cc'] ?? null;
			$send_array['bcc'] = $mail_data['esl_bcc'] ?? null;
			$send_array['subject']= $mail_data['esl_subject'] ?? null;
			$send_array['send_content'] = $mail_data['esl_content'] ?? null;
			$send_array['attachments'] =$attachment_array ?? [];
			$send_array['secret_mail_id'] = $mail_data['esl_trans_secret_id'] ?? null;
			// $send_array['reply_to'] = $mail_data['esl_reply_to'] ?? null;
			$send_array['reply_to'] = 'replytest@reviewdemo.rivervalleytechnologies.com';
			$send_array['batch_id'] = $mail_data['esl_batch_id'] ?? null;
			$send_array['model'] = 'Email_send_log';
			
			$this->trigger_email($send_array);
		}
	}
}
