<?php

namespace App\Http\Controllers;

use App\Models\Custom_email_template_tags;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

class Manage_Custom_Email_Tags_Api extends Controller
{
    /*List all custom email tags
     commited date :- 03-01-2023
     Requested type :- POST
    */
    public function index(Request $request)
    {
        try {
            $form_data = $request->all();
            DB::enableQueryLog();
            $sort_field = (isset($form_data['sort_field'])) ? $form_data['sort_field'] : 'cettag__id';
            $sort_order =  (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'asc';
            $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
            $result = Custom_email_template_tags::get_paginated_records('*', NULL, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
           
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*Delete a custom email tag from table
     commited date :- 03-01-2023
     Requested type :- POST
    */
    public function remove_custom_email_tags(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'etag_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $email_tags_id = $this->decrypt_data($request->etag_id);
            $criteria = "cettag_id={$email_tags_id}";
            // TASK #7020 start
            $status=FALSE;
            $customtagdetails = Custom_email_template_tags::get_single_record('cettag_id,cettag_name', $criteria);
            $Email_templates = new \App\Models\Email_templates;
            $Stage_email_template = new \App\Models\Stage_email_templates;
            $Article_notification_emails = new \App\Models\Article_notification_emails;

            $email_template_data = $Email_templates::get_all_records('etmp_id,etmp_name', " `etmp_email_template` LIKE '%{$customtagdetails->cettag_name}%' ");
            $stage_email_templates_data = $Stage_email_template::get_all_records('stage_etmp_id,stage_etmp_name', " `stage_etmp_content` LIKE '%{$customtagdetails->cettag_name}%' ");
            $stage_save_emails = $Article_notification_emails::get_all_records('ane_stage_etmp_id,ane_template_name ', " `ane_content` LIKE '%{$customtagdetails->cettag_name}%' ");

           
            if ((isset($email_template_data) && $email_template_data->isNotEmpty())||(isset($stage_email_templates_data) && $stage_email_templates_data->isNotEmpty())||(isset($stage_save_emails) && $stage_save_emails->isNotEmpty())) {
                $status=TRUE;
            }
            if($status){
                return $this->warning('Email tag  cannot be deleted as it is currently in use.',200,'warning');
            }
            // TASK #7020 end
            $result = Custom_email_template_tags::delete_records($criteria, '', $current_user);
            $message = customTrans('emailtags.email_tags_removed_success');
            return $this->success($message, 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Add / Update a reject reason 
     commited date :- 03-01-2023
     Requested type :- POST
    */
    public function save_custom_email_tags(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $form_data = $request->all();
            if ($form_data['edit_id'] != '') {
                $validator = Validator::make($request->all(), [
                    'tag_name' => 'required',
                    'tag_value' => 'required',
                ]);
            } else {
                $validator = Validator::make($request->all(), [
                    'tag_name' => 'required|unique:rvw_custom_email_template_tags,cettag_name',
                    'tag_value' => 'required',
                ]);
            }
            // $validator = Validator::make($request->all(), [
            //     'tag_name' => 'required|unique:rvw_custom_email_template_tags,cettag_name',
            //     'tag_value' => 'required',
            // ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 200, customTrans('emailtags.duplicate_err'));
            }
            $reason_array = [];

            $reason_array['cettag_name'] = $form_data['tag_name'];
            $reason_array['cettag_value'] = $form_data['tag_value'];
            if ($form_data['edit_id'] != '') {
                $emailtag_id = $this->decrypt_data($form_data['edit_id']);
                $condition = "cettag_id={$emailtag_id}";
                $result = Custom_email_template_tags::get_single_record('count(cettag_id) as count', $condition);
                if ($result->count > 0) {
                     // TASK #7020 start
            $status=FALSE;
            $customtagdetails = Custom_email_template_tags::get_single_record('cettag_id,cettag_name', $condition);
            $Email_templates = new \App\Models\Email_templates;
            $Stage_email_template = new \App\Models\Stage_email_templates;
            $Article_notification_emails = new \App\Models\Article_notification_emails;

            $email_template_data = $Email_templates::get_all_records('etmp_id,etmp_name', " `etmp_email_template` LIKE '%{$customtagdetails->cettag_name}%' ");
            $stage_email_templates_data = $Stage_email_template::get_all_records('stage_etmp_id,stage_etmp_name', " `stage_etmp_content` LIKE '%{$customtagdetails->cettag_name}%' ");
            $stage_save_emails = $Article_notification_emails::get_all_records('ane_stage_etmp_id,ane_template_name ', " `ane_content` LIKE '%{$customtagdetails->cettag_name}%' ");

           
            if ((isset($email_template_data) && $email_template_data->isNotEmpty())||(isset($stage_email_templates_data) && $stage_email_templates_data->isNotEmpty())||(isset($stage_save_emails) && $stage_save_emails->isNotEmpty())) {
                $status=TRUE;
            }
            if($customtagdetails->cettag_name==$reason_array['cettag_name'] ){
                $status=FALSE;
            }
            if($status){
                return $this->warning('Email tag  cannot be updated as it is currently in use.',200,'warning');
            }
            // TASK #7020 end
            else{
                    $updatedata = Custom_email_template_tags::update_record($reason_array, $condition, $current_user);
            }
                }
                $message = customTrans('emailtags.email_tags_update_success');
                return $this->success($message, 200, $updatedata);
            } else {
                $result = Custom_email_template_tags::insert_record($reason_array, $current_user);
                $message = customTrans('emailtags.email_tags_saved_success');
                return $this->success($message, 200, $result);
                // print_r($reason_array);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
}
