<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\JournalUserfunctionTrait;
use App\Http\Traits\RolesConfigTrait;
use Config;
use DB;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Blind_user_articles;
use App\Models\Authors;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Models\Dashboard_settings;
use App\Models\Dashboard_tile;
use App\Models\User_journal_dashboard_tile_sort_keys;
use App\Models\User_journal_dashboard_tile_filter_keys;
use App\Http\Traits\ArticlelistTrait;
use App\Http\Traits\SendGlobalEmailFunctionTrait;
use Mpdf\Tag\Em;
use App\Http\Traits\General_ConfigTraits;
use App\Models\Article_legacydata;
use App\Models\Article_legacy_author_list;
use App\Models\User;
use App\Models\Article_reviewer_legacydata;
use DateTime;
use Carbon\Carbon;
use App\Http\Traits\ViewarticleTrait;
class Manage_Dashboard_Api extends Controller
{
    use JournalUserfunctionTrait;
    use RolesConfigTrait;
	use ArticlelistTrait;
	use SendGlobalEmailFunctionTrait;
	use General_ConfigTraits;
	use ViewarticleTrait;
    /*
    master function to load dashboard config
    commited date :-  25-04-2022
    Request type :- POST
    */
    public function index(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'core_role' => 'required',
            ]);

            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            else
            {
                $post_data = $request->all();
                //$this->current_user = $this->get_current_user_details();
                $dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
                $dashboard_arr  = Config::get($dashboard_config);

                return $this->success('success',200,$dashboard_arr[$post_data['core_role']]);
            }
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }

    }

	//load dashboard content dynamic
	public function get_dashboard_items_role_based(Request $request)
	{
		try
		{
			$validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
				'role_id' => 'required',
				'core_role'=> 'required'
            ]);

			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			else
			{
				$post_data = $request->all();

				//fetch dashboard items
                $where_cnd = 'ds_jnl_id = '.$post_data['jnl_id'];
                $dashboard_items = Dashboard_settings::get_single_record('ds_features',$where_cnd);


				$front_items = array('tile','todolist');
				if(!empty($dashboard_items))
				{
					$front_items = json_decode($dashboard_items->ds_features);
				}
				return  $this->success('Success',200,$front_items);
			}
		}
		catch(\Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
	}

	public function get_dashboard_tiles(Request $request)
	{
		try
		{
			$validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
				'jnl_code' => 'required',
				'role_id' => 'required',
				'core_role' => 'required',
            ]);

			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			else
			{
				$post_data = $request->all();

				$input_arr = array(
					'input' => $post_data['jnl_id'],
					'type'=> 'number'
				);
				$jnl_id_validate = $this->Rv_validator($input_arr);

				$input_arr['input']= $post_data['role_id'];
				$role_id_validate = $this->Rv_validator($input_arr);

				$input_arr = array(
					'input' => $post_data['jnl_code'],
				);
				$jnl_code_validate = $this->Rv_validator($input_arr);

				$input_arr['input']= $post_data['core_role'];
				$core_role_validate = $this->Rv_validator($input_arr);

				if($jnl_id_validate == TRUE && $role_id_validate == TRUE && $jnl_code_validate == TRUE && $core_role_validate == TRUE)
				{

					$tile_arr = $dynamic_arr = $static_arr = $extra_arr = array();

					//DB::enableQueryLog();
					$dashboard_sett_table = (new \App\Models\Dashboard_settings())->getTable();
					$dashboard_tile_table = (new \App\Models\Dashboard_tile())->getTable();

					$select = 'dt_static_tile,dt_title,dt_color_option,dt_color,dt_icon,dt_layout,dt_revised_type,dt_status_submitted,dt_submitted_author,dt_no_result,dt_art_type,dt_data';

					$condition = array(
						'ds_jnl_id'=> $post_data['jnl_id'],
						'ds_role_id'=>$post_data['role_id']
					);
					$tables = array(
						'main_table' => $dashboard_sett_table,
						'join_table' => array(
							$dashboard_tile_table => array('ds_id','dt_settings_id')
						)
					);
					$tile_data = Dashboard_settings::get_results_using_joins($tables, $select, $condition, 'single');
					//$queries = DB::getQueryLog();
					//dd($queries);

					$dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
					$dashboard_arr  = Config::get($dashboard_config);

					$this->current_user = $this->get_current_user_details();
					$user_roles = $this->validate_user_journal($post_data['jnl_code'], $this->current_user['user_id']);

					$user_retire_status = $this->get_user_role_retire($post_data['role_id'],$this->current_user['user_id'],$post_data['jnl_id']);

					$tile_arr = array();
					if(!empty($tile_data))
					{
						$tile_arr = json_decode($tile_data->dt_data);
						if(count($tile_arr) > 0)
						{
							$dynamic_arr = $this->load_dynamic_tiles($tile_data,$post_data,$this->current_user);
						}
					}
					else
					{
						//For static tiles
						$static_arr = $this->load_static_tiles($post_data,$dashboard_arr,$this->current_user,$user_retire_status);
					}

					//For extra tile
					//$extra_arr = $this->load_extra_tiles($post_data,$this->current_user);



					$tile_arr = array_merge($dynamic_arr,$static_arr,$extra_arr);

					return  $this->success('Success',200,$tile_arr);
				}
				else
				{
					return $this->warning('Failed',422,customTrans('auth.invalid_data'));
				}
			}
		}
		catch(\Exception $e)
		{

			return  $this->failure('Failed',500,$e);
		}
	}

	//load dynamic tiles for dashboard
	public function load_dynamic_tiles($tile_data,$post_data)
	{
		$dynamic_arr = array();
		$dynamic_arr[] = array(
			'count'=> 1,
			'title' => customTrans('Submit :article'),
			'type'=> 'info',
			'icon'=>'fa fa-upload',
			'navigateTo'=>'view-more'
		);
		dd(json_decode($tile_data->dt_data));


		return $dynamic_arr;
	}

	//load static tiles for dashboard
	public function load_static_tiles($post_data,$dashboard_arr,$current_user,$user_retire_status, $take_from = 'Tiles')
	{
		$static_arr = array();

		$core_role = $post_data['core_role'];
		$roleid = $post_data['role_id'];
		$dashboard_config = $dashboard_arr[$core_role];

		$dashboard_config['Tiles'] = array_values($dashboard_config[$take_from]);

		$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $workflow_arr  = Config::get($workflow_config);

		$roles = User_to_journals::get_user_role_ids($post_data['jnl_id'],$current_user['user_id'],$roleid);
		$user_roles =  $this->rebuild_array_by_field($roles,'usrj_artp_id');

		$tile_array = array();
		if(!empty($dashboard_config['Tiles']))
		{
			$i = 0;
			foreach ($dashboard_config['Tiles'] as $tile)
			{
				$tile['tile_stage_type'] = $tile['stage_type'];

				if ($tile['section_id'] == 'submit_article_tile')
				{
					/*$criteria = 'artp_jnl_id = '.$post_data['jnl_id'] .' AND artp_status = \'y\' AND JSON_SEARCH(artp_login_user_type, \'all\', \'a\') IS NOT NULL ';

					if (isset($this->current_client->functionality->cfty_enable_stop_submission_in_article_type) && $this->current_client->functionality->cfty_enable_stop_submission_in_article_type == 'y')
                    {
                        $criteria .= 'AND artp_article_submission_status = \'y\'';
                    }

					$select = 'count(artp_id) as cnt';
                    */
                    $article_types =$this->get_adhoc_submission_type_data($post_data['jnl_id']);
					if($article_types->cnt == 0)
						continue;
				}
				// Task #3393 Copyright Aipp New tile for author
				if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' && $core_role == 'author' && $tile['section_id'] == 'manage-copyright-request') {
					$art_data = Articles::get_single_record_with_bind_cond('count(art_id) as cnt',array('art_copyright_request'=>'y','art_submitted_by'=>$current_user['user_id']));
					if($art_data->cnt == 0)
						continue;
				}
				if ($core_role == 'author' && $tile['function'] == 'manage_biorxiv')
				{
					if (isset($this->current_client->functionality->cfty_biorxiv) && $this->current_client->functionality->cfty_biorxiv != 'y') {
						unset($dashboard_config['Tiles'][$i]);
						continue;
					}
				} elseif ($core_role == 'reviewer' && $tile['function'] == 'manage_publons') {
					if ((isset($this->current_client->modules->mdl_publons)) && $this->current_client->modules->mdl_publons != 'y') {
						unset($dashboard_config['Tiles'][$i]);
						continue;
					}
				}
				if( (isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion == 'n') && $tile['section_id'] == 'open-generic-discussion')
				{
					unset($dashboard_config['Tiles'][$i]);
					continue;
				}

				/*if($tile['section_id'] == 'author-collab' && $this->current_client->modules->mdl_es_integration == 'n')
				{
					unset($dashboard_config['Tiles'][$i]);
					continue;
				}*/

				if($tile['section_id'] == 'articles-under-submission')
				{
					$check_view_article_on_sub = $this->check_view_article_on_submission($post_data);
					if($check_view_article_on_sub == FALSE)
					{
						unset($dashboard_config['Tiles'][$i]);
						continue;
					}
				}

				if($tile['section_id'] == 'all-request')
				{
					$articles = $this->check_all_request_exist($post_data,'count');
					if($articles['status'] == FALSE){
						unset($dashboard_config['Tiles'][$i]);
						continue;
					}
				}

                if($tile['section_id'] == 'all-submission'){
					$cnt = $this->load_tile_details($post_data, TRUE,$tile,$current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
                    $tile['count'] = $cnt;
                }

                if(isset($tile['sub_data'])){
                    foreach($tile['sub_data'] as $key => $sub_tile){
                        $tile['sub_data'][$key]['count'] = $this->load_tile_details($post_data, TRUE,$sub_tile,$current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
                    }
                }

				if($tile['section_id']!='submit_article_tile')
				{
				$single_color='bg-blue';
				if(isset($this->current_client->functionality->cfty_single_color_tiles) && $this->current_client->functionality->cfty_single_color_tiles == 'y')
				{
					$tile['color_class']=$single_color;
				}
				}
				/*if((!isset($this->current_client->modules->mdl_production) || (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n')) && $tile['section_id'] == 'copy_editor_ready_production')
				{
					continue;
				}*/

				$title = $tile['title_singular'];
				$page_url = '';
				$run_function = $tile['function'];
				$cnt = 0;
				if($tile['section_id'] != 'submit_article_tile')
					$cnt = $this->load_tile_details($post_data, TRUE,$tile,$current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);

				$tile['count'] = $cnt;

				if(isset($tile['hide_when_zero']) && $tile['hide_when_zero'] == true && $cnt == 0)
				{
					continue;
				}
				/*elseif($tile['section_id'] == "manage-overdue-task" && $cnt == 0)
				{
					continue;
				}*/

				if((!isset($this->current_client->modules->mdl_production) || (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n')) && $tile['function'] == 'manage_production' && $cnt == 0)
				{
					$search_parameter = 'production-exported';
					/*$prd_cnt = $this->manage_production($roleid, TRUE,$second_ajax,
					$user_retire_status,$search_parameter);*/
					$prd_cnt = 0;
					$tile['export_production'] = $prd_cnt;
					$page_url = $tile['page_url'];
					if(($core_role =="editor_in_chief" || $core_role =="associate_editor") && $prd_cnt==0)
					{
						unset($dashboard_config['Tiles'][$i]);
						continue;
					}
				}

				$bulksubmission=FALSE;
				if($tile['page_url']=='article-bulkinvitation' || $tile['page_url']=='drafts')
				{
					$bulksubmission=TRUE;
				}
				$tile['bulksubmission'] = $bulksubmission;

				if ($cnt > 0)
				{
					if ($tile['view_mode'] == 'link') {
						$page_url = $tile['page_url'];
					}
					if ($cnt > 1) {
						$title = $tile['title_plural'];
					}
				}

				//###################################
				$view_mode = '';
				if(isset($tile['view_mode']))
				{
					if($tile['section_id'] == 'submit_article_tile')
					{
						$view_mode = 'popup';
					}
					elseif($cnt >0)
					{
						$view_mode = $tile['view_mode'];
					}
				}
                $final_arr = array(
					//'title' => ($cnt > 1)?customTrans($tile['title_plural']):customTrans($tile['title_singular']),
					'title' =>customTrans($tile['title_plural']),
					'color_class' => $tile['color_class'],
					'color' => $tile['color'],
					'icon' => $tile['icon'],
					'section_id' => $tile['section_id'],
					'count'=> $cnt,
					'page_url' => $tile['page_url'],
					'view_mode' => $view_mode,
					'bulksubmission' => $tile['bulksubmission'],
					'callout' => isset($tile['callout']) && $tile['callout'] != '' ? $tile['callout'] : ""
				);
                if(isset($tile['sub_data'])){
                    $final_arr['sub_data'] = $tile['sub_data'];
                }
				$tile_array[] = $final_arr;

				$i++;
			}
		}
		return $tile_array;
	}

	//load extra tiles for dashboard
	public function load_extra_tiles($post_data,$dashboard_arr,$current_user)
	{
		$extra_arr = array();

		$core_role = $post_data['core_role'];
		$roleid = $post_data['role_id'];
		$dashboard_config = $dashboard_arr[$core_role];

		$dashboard_config['Tiles'] = array_values($dashboard_config['Tiles']);
		//dd($dashboard_config);

		if(!empty($dashboard_config['Tiles']))
		{
			foreach ($dashboard_config['Tiles'] as $tile)
			{
				$bulksubmission=FALSE;
				if($tile['page_url']=='article-bulkinvitation' || $tile['page_url']=='drafts')
				{
					$bulksubmission=TRUE;
				}
				$tile['bulksubmission'] = $bulksubmission;
			}
		}

		$extra_arr[] = array(
			'count'=> 3,
			'title' => 'Prescreening',
			'type'=> 'info',
			'icon'=>'fa fa-upload',
			'navigateTo'=>'view-more'
		);
		return $extra_arr;
	}

	public function load_tile_details($post_data, $return_count = FALSE,$tile_info,$current_user,$user_roles,$workflow_arr,$user_retire_status = NULL,$next_data = NULL)
	{
		$return = '';
		$core_role = $post_data['core_role'];
		$roleid = $post_data['role_id'];
		$jnl_id = $post_data['jnl_id'];
		$user_id = $current_user['user_id'];

		$production_flag = FALSE;
		//for information tile except journal admin
		$for_corerole_users = array('staff','editor_in_chief');
		$for_tile_section = array('manage-review-complete','manage-export-to-production','manage-peer-review');
		$for_information_tile = FALSE;
		
		$tile_info['section_id'] = $tile_info['section_id']??'';
		if(in_array($core_role,$for_corerole_users) == TRUE && in_array($tile_info['section_id'],$for_tile_section) == TRUE)
		{
			$for_information_tile = TRUE;
		}

		$article_flow_table = (new \App\Models\Article_flow())->getTable();

		$join_permission_tb_flag = FALSE;
		$ice_flag = FALSE;
		if($this->current_client->modules->mdl_production == 'y')
			$ice_flag = TRUE;
		
		$stage_type = $tile_info['stage_type']??array();
		$section = $tile_info['section_id'];
		$bulksubmission=(isset($tile_info['bulksubmission'])?$tile_info['bulksubmission']:false);
		$order_by = '';
		$group_by = '';
		$my_task = TRUE;
		$condition = $array_data = array();
		$fn_type = (isset($tile_info['fn_type']))?$tile_info['fn_type']:'';
		$fn_section = (isset($tile_info['fn_section']))?$tile_info['fn_section']:'';
		$type = (isset($tile_info['type']))?$tile_info['type']:'';
		$seek_confirmation = '';
		$transfer_art = '';

		$cfty_allow_privileged_users_as_only_reviewer = FALSE;
		if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
		{
			$cfty_allow_privileged_users_as_only_reviewer = TRUE;
		}

		if(isset($post_data['filter']['my_list']))
		{
			$my_task = $post_data['filter']['my_list'];
		}

		if(($return_count == FALSE && $tile_info['section_id'] != 'overview') || (isset($tile_info['inner_list']) && $tile_info['inner_list'] == true))
		{
			$group_by = 'art_id';

			$form_post=isset($post_data['filter']) ? $post_data['filter'] : array();

			$journal_data['jnl_id']=$jnl_id;
			$journal_data['jnl_code']=$post_data['jnl_code'];
			$journal_data['role_id']=$roleid;
			// $form_post['my_list'] = $my_task;
			$search_condition = $this->global_function_for_search_article('inner_list', $form_post, TRUE,array(),array(),$journal_data,$tile_info,$post_data);

			if(isset($search_condition['conditions']) && $search_condition['conditions'] != '')
			{
				$condition[] = substr(trim($search_condition['conditions']),3);
			}

			if(isset($search_condition['condition_stage']))
			{
				$form_post['condition_stage'] = $search_condition['condition_stage'];
				if($search_condition['condition_stage'] != '')
					$condition[] = ' (jwf_stage_name ' . $search_condition['condition_stage'] . ' OR jwf_status_name ' . $search_condition['condition_stage'] . ' )';
			}
			if(isset($search_condition['condition_order_by'])&&$search_condition['condition_order_by']!=NULL)
			{
				$form_post['condition_order_by'] = $order_by = $search_condition['condition_order_by'];
			}
			if(isset($search_condition['sort_type_array'])&&$search_condition['sort_type_array'] !=NULL)
			{
				$form_post['condition_order_by']  =$search_condition['sort_type_array'];
				//$order_by = $search_condition['sort_type_array']['sort_type'].' '.$search_condition['sort_type_array']['sort_order'];
				$order_by = ' strip_tags(REGEXP_REPLACE('.$search_condition['sort_type_array']['sort_type'].',\'<p>&nbsp;|<p> |<p>&ldquo;|<p>"\',\'\')) '.$search_condition['sort_type_array']['sort_order'];
			}
		}
		$user_retire_flag = ' TRUE ';
		if($user_retire_status == TRUE)
			$user_retire_flag = ' FALSE ';

		$where_cnd = array(
			'role_id' => $roleid
		);
		$role_areas = Roles::get_single_record_with_bind_cond('role_used_in',$where_cnd);
		$role_arr = array();
		if(isset($role_areas->role_used_in) && $role_areas->role_used_in != '')
		{
			$role_arr = explode(',',$role_areas->role_used_in);
		}
		// CONDITION FOR TILES
		//need a check current role in production or not
		$art_status = 'art_status = \'y\' ';
		//$prod_stages_for_task = array('to-be-initiated','preprocessing','to-be-copyedited','to-be-typeset','to-be-proofread','to-be-check');
		$prod_stages_for_task = array('to-be-initiated','to-be-proofread');
		if($core_role != 'tsp')
		{
			$prod_stages_for_task[]='preprocessing';
		}
		if(isset($this->current_client->modules->mdl_copyedit) &&  $this->current_client->modules->mdl_copyedit == 'y')
		{
			$art_status = ' art_status = \'y\'  ';
			if($tile_info['section_id'] == 'manage_copyediting')
			{
			}

		}
		elseif(isset($this->current_client->modules->mdl_production) &&  $this->current_client->modules->mdl_production == 'y')
		{
			$production_flag = TRUE;
			$art_status = 'art_status IN (\'y\',\'a\') ';
			$for_prod_stages_role_base = array('manage-new-manuscript','overview');

			$stage_keys = $this->get_production_stages_keys($workflow_arr,FALSE,TRUE);

			if(in_array($tile_info['section_id'],$for_prod_stages_role_base) == TRUE)
			{
				if($tile_info['section_id'] == 'overview')
				{
					if(in_array('r',$role_arr) && !in_array('p',$role_arr))
					{
						$stage_type = $stage_keys['review'];
					}
					elseif(in_array('p',$role_arr) && !in_array('r',$role_arr))
					{
						$stage_type = $stage_keys['production'];
						$art_status = 'art_status = \'a\' ';
					}
				}
				else
				{
					if(in_array('p',$role_arr))
					{
						if($tile_info['section_id'] != 'manage-new-manuscript')
						{
							$stage_type = array_merge($stage_type,$stage_keys['production']);
						}
						$art_status = 'art_status = \'a\' ';
					}
				}
			}
			$for_prod_stages = array('manage-production-amendment','manage-export-to-production','copy_editor_ready_production');
			if($core_role == 'editor_in_chief' && $tile_info['section_id'] == 'manage-export-to-production')
			{
				$eic_stages = array();
				foreach ($workflow_arr as $key => $re_flw)
				{
					if(isset($re_flw['stage_for']) && $re_flw['stage_for'] == 'manageproduction')
					{
						if(in_array('editor_in_chief', $re_flw['roles']) && $key != 'proof_reading')
						{
							$eic_stages[] = $key;
						}
					}
				}
				$stage_keys['production'] = $eic_stages;
			}
			if( $tile_info['section_id'] == 'manage-export-to-production')
			{
				$stage_type = array('production');
			}
			if(in_array($tile_info['section_id'],$for_prod_stages) == TRUE)
			{
				$stage_type = array_merge($stage_type,$stage_keys['production']);
			}
		}
		elseif($tile_info['section_id'] == 'manage-export-to-production')
		{
			$stage_type = array('production');
		}
/*
		if(!empty($stage_type))
		{
			if(count($stage_type) > 1)
			{
				$condition[] = ' jwf_stage_type IN (\''. implode('\',\'', $stage_type).'\')';
			}
			else
			{
				$condition[] = ' jwf_stage_type = \''.$stage_type[0].'\'';
			}
		}*/

		$select = '*';
		$select_pe = "";
		$blinded_articles = $this->get_blinded_articles($user_id);
        if(!empty($blinded_articles))
		{
			$condition[] = ' art_id NOT IN ('.$blinded_articles.') ';
		}

		$export_to_production = '(CASE WHEN jwf_stage_type = "production" THEN aflw_status IN(\'u\',\'c\',\'a\') ELSE aflw_status IN (\'u\',\'a\') END)';
		if($tile_info['section_id'] == 'open-generic-discussion')
		{
			$art_status = ' art_status IN (\'y\',\'a\',\'c\',\'t\')  ';
			$array_data['discussion_flag']= TRUE;
			if($core_role == 'author')
			{
				$array_data['non_author_flag']= FALSE;
			}
			$condition[] = 'gdis_status = \'o\' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$user_id.') IS NOT NULL OR gdis_started_by = '.$user_id.') AND aflw_status IN (\'u\',\'a\',\'p\',\'w\')  AND IF(aflw_status IN (\'p\',\'w\') ,(select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = a1.aflw_id AND tb1.aflw_status IN (\'i\',\'a\',\'c\') ) < a1.aflw_stage_min_users,TRUE) ';
		}
		elseif($core_role != 'journal_admin'  && $core_role != 'author' && $core_role != 'reviewer' && $for_information_tile == FALSE && $tile_info['section_id'] !== 'articles-under-submission')
		{
			// TASK #4260The user assigned to the review selection/invitation stages is not shown in the search results.
			if($core_role == 'staff')
           {
			$my_task = FALSE;
		   }
			$cond_acitive_on = array('manage-peer-review','manage-overdue-task');
			$cond_ShortlistIvite = array('manage-pending-review','manage-reviewer-score','select-invite-reviewer');

			$cond_role_must_on = array('manage-new-manuscript','manage-awaiting-decision','manage_revised_manuscript','postprocessing','article-ready-production_manuscript');
			$cond_not_in = array('manage-production-management-completed-task','manage-completed-task','manage_production_completed_task','bounced-back','to-submit-aop2-web-files-completed','to-be-copyedited','to-be-typeset','copy_editor_ready_production','my_completed_task');
			$cond_complete_task = array('my_completed_task'); //for my completed task there is no detailed checking
			if($core_role == 'tsp')
			{
				$cond_not_in[]='preprocessing';
			}
			$must_work = array('manage-overdue-task','files-for-correction');
			$art_user_allocation_cnd = '';

			if($production_flag == TRUE)
			{
				$must_work = array_merge($must_work,$prod_stages_for_task);
				$cond_acitive_on = array_merge($cond_acitive_on,$prod_stages_for_task);
			}

			$cond_production = array('manage-production-amendment');

			//allocation or role not check are, because the task current user already start
			if(!in_array($tile_info['section_id'],$cond_not_in) && $core_role != 'staff')
			{
				$art_user_allocation_cnd = '((aflw_status = \'a\' AND aflw_usr_id='.$user_id.' )  OR IF(allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$user_id.',allocate_curr_role_users) = 1, '.$user_retire_flag.' AND FIND_array_intersect('.$roleid.',user_artp_roles) = 1)) ';
			}
			else
			{
				$art_user_allocation_cnd = ' FIND_array_intersect('.$roleid.',user_artp_roles) = 1 AND '.$user_retire_flag;
			}

			//must current role have work on this tile
			if(in_array($tile_info['section_id'],$cond_role_must_on))
			{
				$condition[] = 'jwf_role_id = '.$roleid.' AND IF(aflw_status IN (\'a\'),aflw_usr_id='.$user_id.',TRUE)';
			}

			//Shortlist / invite permision
			if(in_array($tile_info['section_id'],$cond_ShortlistIvite))
			{
				$flow_status =  '';
				$child_entry  = ' AND  aflw_parent_flow_id IS NOT NULL ';
				$except_stage_status = array('manage-reviewer-score','select-invite-reviewer');
				if(!in_array($tile_info['section_id'],$except_stage_status))
				{
					$flow_status =  ' AND aflw_status IN(\'a\',\'i\')';
				}

				if($tile_info['section_id'] == 'select-invite-reviewer')
				{
					$child_entry = '';
				}
				//$condition[] = 'jwf_role_id = '.$roleid.' AND IF(aflw_status IN (\'a\'),aflw_usr_id='.$user_id.',TRUE)';
				$condition[] = ' (FIND_array_intersect('.$roleid.',REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")) = 1  OR   FIND_array_intersect('.$roleid.',REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")) = 1 ) '.$child_entry.'  AND jwf_assignment = \'invitation\' '.$flow_status;
			}

			if(in_array($tile_info['section_id'],$must_work))
			{
				$condition[] = '(CASE WHEN aflw_status = \'a\' THEN aflw_usr_id = '.$user_id.' AND jwf_role_id = '.$roleid.' WHEN aflw_status = \'u\' THEN jwf_role_id = '.$roleid.' ELSE aflw_status NOT IN (\'u\',\'a\') END)';
			}
			//short list or invite works
			if(in_array($tile_info['section_id'],$cond_acitive_on))
			{
				$condition[] = $art_user_allocation_cnd;

				$shortlist = ' FIND_array_intersect('.$roleid.',REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")) > 0 AND (select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = a1.aflw_id AND tb1.aflw_status IN (\'u\',\'i\',\'a\',\'c\') ) < a1.aflw_stage_min_users';

				$invite = ' FIND_array_intersect('.$roleid.',REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")) > 0 AND (select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = a1.aflw_id AND tb1.aflw_status IN (\'i\',\'a\',\'c\') ) < a1.aflw_stage_min_users';

				$review_assignment = ' AND IF('.$shortlist.',TRUE,'.$invite.' )';

				//adding reviewer list too
				$listing_reviewers_too = '';
				$status_w = 'aflw_status = \'w\'';
				if($tile_info['section_id'] == 'manage-pending-review')
				{
					$listing_reviewers_condition = ' aflw_status IN(\'a\',\'i\') AND  aflw_parent_flow_id IS NOT NULL AND jwf_assignment = \'invitation\' AND (select tb1.aflw_status FROM  '.$article_flow_table.' as tb1 WHERE tb1.aflw_id = a1.aflw_parent_flow_id ) != \'c\'';

					$listing_reviewers_too = ' WHEN '.$listing_reviewers_condition.' THEN  TRUE ';
				}
				elseif($tile_info['section_id'] == 'manage-overdue-task')
				{
					$status_w = 'aflw_status IN (\'w\',\'p\') ';
					$listing_reviewers_too = ' WHEN aflw_status IN (\'u\',\'a\',\'i\')  THEN  TRUE ';
				}

				if(in_array($tile_info['section_id'],$prod_stages_for_task))
				{
					$condition[] = ' ( CASE  WHEN  art_status = \'a\' AND aflw_status IN (\'w\',\'p\') AND aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\' '.$review_assignment.' THEN TRUE '.$listing_reviewers_too.' ELSE TRUE END)';
				}
				else
				{
					$condition[] = ' ( CASE  WHEN  art_status IN (\'y\',\'a\') AND '.$status_w.' AND aflw_skip_review =\'n\' '.$review_assignment.' THEN TRUE '.$listing_reviewers_too.' END)';
				}
				//echo '<pre>';print_r($condition);exit;
            }
			elseif($tile_info['section_id'] == 'manage-review-complete')
			{
				$condition[] = ' ((aflw_usr_id=' . $user_id.' and jwf_role_id='.$roleid .') OR aflw_usr_id IS NULL)';
			}
			elseif(in_array($tile_info['section_id'],$cond_complete_task))
			{
				$condition[] = ' aflw_usr_id=' . $user_id.' and aflw_status = \'c\' ';
			}
			elseif(!empty($art_user_allocation_cnd))
			{
				$condition[] = $art_user_allocation_cnd;
			}
			
			

			//must production tile
			if(in_array($tile_info['section_id'],$cond_production) && $core_role == 'editor_in_chief')
			{
				$condition[] = ' AND ((aflw_usr_id = ' . $user_id . ' AND  aflw_status = \'a\' ) OR (aflw_usr_id IS NULL AND aflw_status = \'u\')) AND jwf_role_id = ' . $roleid;
			}

		}
		else
		{
			if($core_role == 'journal_admin' || $for_information_tile == TRUE)
			{
				$array_in = array('manage-export-to-production','manage-production-amendment');
				$my_task = FALSE;

				if(in_array($tile_info['section_id'],$array_in) && !($core_role == 'associate_editor' || $core_role == 'editor_in_chief'))
				{
					//$export_to_production = ' aflw_status  = \'c\' ';
					$export_to_production = '(CASE WHEN jwf_stage_type = "publish" THEN aflw_status IN(\'u\',\'c\') WHEN jwf_stage_type = "production" THEN aflw_status IN(\'u\',\'c\',\'a\') ELSE aflw_status IN(\'u\',\'a\')  END)';
				}
			} 
			elseif($core_role == 'author')
			{
				$array_data['non_author_flag'] = FALSE;
				$array_in = array('manage-peer-review','manage-awaiting-decision','manage-awaiting-revision','manage-review-complete','manage-biorxiv','manage_copyediting','finished_publish','manage-copyright-request');
				$array_prod = array('manage-production-amendment');
				if(in_array($tile_info['section_id'],$array_in))
				{
					$condition[] = ' art_submitted_by=' . $user_id;
					if(isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' && $tile_info['section_id'] == 'manage-copyright-request') {
						// Task #3393 Copyright Aipp New tile for author
						$condition[] = 'art_copyright_request= "y" ';
					}
				}
				elseif(in_array($tile_info['section_id'],$array_prod))
				{
					$condition[] = ' aflw_status  = \'a\' AND aflw_usr_id ='.$user_id;
					$stage_type = array('pro_revision');
				}
			    elseif($tile_info['section_id'] != 'manage-coauthor' && $type != 'author_withdrawn_articles' && $tile_info['section_id'] != 'manuscript-to-confirmation')
				{
					$condition[] = ' aflw_usr_id = '.$user_id;
				}
			}
			elseif($core_role == 'reviewer')
			{
				$condition[] = ' aflw_usr_id = '.$user_id;
			}
		}
		//Add conditions
		if($tile_info['section_id'] == 'manage-new-manuscript')
		{
			$art_status = ' art_status IN (\'y\',\'a\')  ';
			$condition[] = ' aflw_status IN (\'u\',\'a\') AND IF(art_transfer_article = \'n\',art_prev_article_id IS NULL,TRUE)';
		}
        if($tile_info['section_id'] == 'manage-new-manuscript-waiting')
		{
			$art_status = ' art_status IN (\'y\',\'a\')  ';
			$condition[] = ' aflw_status IN (\'u\') AND IF(art_transfer_article = \'n\',art_prev_article_id IS NULL,TRUE)';
		}
        if($tile_info['section_id'] == 'manage-all-manuscript')
		{
			$art_status = ' art_status IN (\'y\',\'a\')  ';
			$condition[] = ' aflw_status IN (\'u\',\'a\',\'w\') AND IF(art_transfer_article = \'n\',art_prev_article_id IS NULL,TRUE)';
		}
		elseif($tile_info['section_id'] == 'articles-under-submission')
		{
			$art_status = ' art_status IN (\'y\',\'a\',\'n\')  ';
			$condition[] = ' aflw_status IN (\'a\') AND IF(art_transfer_article = \'n\',art_prev_article_id IS NULL,TRUE)';
		}
		elseif($tile_info['section_id'] == 'view-assignment')
		{

			$assign_role =  array();
			if(!empty($workflow_arr))
			{
				foreach($workflow_arr as $stage=>$value)
				{
					if($value['assignment_tabs'] == FALSE)
					{
						if($this->current_client->modules->mdl_production == 'n' && $value['stage_for'] == 'manageproduction')
						{
							continue;
						}
						$assign_role[] = $stage;
					}
				}
			}

			$asnt_str = '';
			if(count($assign_role) > 0)
			{
				$asnt_str = ' WHEN FIND_IN_SET(jwf_stage_type,"'.implode(',',$assign_role).'") = 0 THEN TRUE ';
			}

			$role_assign_condition  =' AND (CASE '.$asnt_str.' WHEN (SELECT COUNT(cjwf.jwf_id) FROM rvw_journal_workflows cjwf WHERE cjwf.jwf_fwm_id = jwf.jwf_fwm_id  and cjwf.jwf_id>jwf.jwf_id AND (FIND_IN_SET(cjwf.jwf_role_id, asgm_assgnd_role) > 0  OR FIND_array_intersect(asgm_assgnd_role,REPLACE(REPLACE(REPLACE(cjwf.jwf_who_can_invite, \'"\', ""),"]",""),"[","")) = 1 OR FIND_array_intersect(asgm_assgnd_role,REPLACE(REPLACE(REPLACE(cjwf.jwf_parent_user_roles, \'"\', ""),"]",""),"[","")) = 1)) > 0 THEN TRUE ELSE FALSE END )';

			$p_assign_condition = ' aflw_status = \'p\' AND aflw_stage_min_users > (SELECT COUNT(aflw_id) FROM '.$article_flow_table.' as cld WHERE cld.aflw_parent_flow_id = a1.aflw_id) AND FIND_array_intersect('.$roleid.',REPLACE(REPLACE(REPLACE(jwf_parent_user_roles, \'"\', ""),"]",""),"[","")) = 1';

			$article_assign_condition = 'aflw_status = \'a\' AND jwf_role_id = '.$roleid.' AND aflw_usr_id = '.$user_id.' AND  asgm_can_assgn_role = '.$roleid.' AND IF(aflw_skip_assignment IS NOT NULL,FIND_array_intersect(asgm_assgnd_role,aflw_skip_assignment) = 0,TRUE) '.$role_assign_condition;

			$condition[] = ' jwf_stage_type NOT IN (\'accept\',\'reject\',\'decision_revision\')';

			$condition[] = ' ( ('.$p_assign_condition.') OR ('.$article_assign_condition.'))';

			$join_permission_tb_flag = TRUE;
		}
		elseif($tile_info['section_id'] == 'manage-peer-review' && $core_role != 'author')
		{

			$condition[] = ' aflw_parent_flow_id IS NULL  AND aflw_status = \'w\' AND aflw_skip_review =\'n\' AND aflw_more_review_skip_status = \'n\' AND a1.aflw_stage_min_users > ( SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status = \'c\' )  ';
		}
        elseif($tile_info['section_id'] == 'manage-peer-review-all' && $core_role != 'author')
		{
			$condition[] = ' aflw_parent_flow_id IS NULL  AND aflw_status IN (\'a\',\'w\',\'p\') AND aflw_skip_review =\'n\' AND aflw_more_review_skip_status = \'n\' AND a1.aflw_stage_min_users > ( SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status = \'c\' )  ';
		}
		elseif(in_array($tile_info['section_id'],$prod_stages_for_task))
		{
			$condition[] = ' aflw_status IN (\'u\',\'a\',\'w\',\'p\')';
		}
		elseif(($tile_info['section_id'] == 'manage-peer-review' || $tile_info['section_id'] == 'manage-awaiting-revision' )  && $core_role == 'author')
		{
			$art_status = 'art_status IN (\'y\',\'c\',\'n\')  ';
			if($tile_info['section_id'] == 'manage-peer-review')
			{
				$condition[] = ' aflw_status IN (\'u\',\'a\',\'w\',\'p\')  ';
				$condition[] = ' IF(aflw_status IN (\'w\',\'p\'),(aflw_parent_flow_id IS NULL  AND aflw_skip_review =\'n\' AND aflw_more_review_skip_status = \'n\' AND a1.aflw_stage_min_users > ( SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status = \'c\' )),aflw_parent_flow_id IS NULL)  ';
			}
			else
			{
				$condition[] = ' aflw_status IN (\'u\',\'a\') ';
			}

		}
		elseif($tile_info['section_id'] == 'manage-post-review')
		{
			$art_status = ' art_status IN (\'y\',\'a\')';
			$condition[] = ' aflw_status IN (\'u\',\'a\') AND jwf_role_id = '.$roleid.' AND IF(aflw_status = \'a\',aflw_usr_id = '.$user_id.',TRUE )';
		}

		elseif($tile_info['section_id'] == 'manage-awaiting-decision')
		{
			$condition[] = ' aflw_status IN (\'u\',\'a\',\'p\',\'w\') ';
		}elseif($tile_info['section_id'] == 'all-submissions'){
            $art_status = ' art_status IS NOT NULL ';
            $condition[] = ' aflw_status is not null ';
        }
		elseif($tile_info['section_id'] == 'manage_revised_manuscript')
		{
			$cond_A = 'IF(art_prev_article_id IS NULL,jwf_stage_type = \'revision\',FALSE)';
			$cond_B = 'IF(art_prev_article_id IS NOT NULL,jwf_stage_type IN("staff_check", "pre_assessment","resubmission"),FALSE)';
			$cond_C = 'IF(art_prev_article_id IS NULL,jwf_stage_type = \'resubmission\',FALSE)';
			$condition[] = ' aflw_status != \'c\' AND art_transfer_article = \'n\' AND (('.$cond_A.') OR ('.$cond_B.') OR ('.$cond_C.'))  ';
			//$art_status = 'art_status != \'n\' ';
			$art_status = 'art_status IN (\'n\',\'y\',\'c\')  ';
		}
		elseif($tile_info['section_id'] == 'manage-review-complete')
		{
			$art_status = ' art_status IN(\'a\',\'r\') ';
			$condition[] = ' aflw_status IN (\'u\',\'a\',\'c\') AND IF(jwf_stage_type = \'production\' AND aflw_status = \'c\',FALSE,TRUE) ';
		}
        elseif($tile_info['section_id'] == 'manage-review-all-complete')
		{
			$art_status = ' art_status IN(\'a\',\'r\',\'y\') ';
			$condition[] = ' aflw_status IN (\'u\',\'a\',\'c\') AND IF(jwf_stage_type = \'production\' AND aflw_status = \'c\',FALSE,TRUE) ';
		}
		elseif($tile_info['section_id'] == 'manage-completed-task')
		{
			$art_status = '';
			$condition[] = ' aflw_status = \'c\' AND jwf_role_id = '.$roleid;
			if($core_role != 'author' && $core_role != 'reviewer')
			{
				$condition[] = ' aflw_usr_id = '.$user_id;
			}
		}
		elseif($tile_info['section_id'] == 'manage-export-to-production')
		{
			$art_status = ' art_status = \'a\' ';
			$array_data['issue_tb_connect'] = TRUE;
			$condition[] = $export_to_production;
			//$condition[] = ' IF(jwf_stage_type = \'production\',aflw_status =\'c\' AND iss_status =\'c\',TRUE) ';

			$condition[] = '  IF(tb_issues.iss_status IS NOT NULL,tb_issues.iss_status != \'c\',TRUE)';
            $condition[]  = ' IF(jwf_stage_type = "production", aflw_status IN(\'u\',\'a\'),TRUE)';
			if(!isset($this->current_client->modules->mdl_production) ||(isset($this->current_client->modules->mdl_production) &&  $this->current_client->modules->mdl_production == 'n'))
			{
				$stage_type = array('production');
			}

			if(($core_role == 'associate_editor' || $core_role == 'editor_in_chief'))
			{
				$array_data['self_worked_artciles'] = TRUE;
			}
		}
		elseif($tile_info['section_id'] == 'manage-overdue-task' && $core_role == 'reviewer')
		{
			$condition[] = ' a1.aflw_status IN (\'i\',\'a\')  AND  a1.aflw_parent_flow_id IS NOT NULL AND DATEDIFF(NOW(), aflw_due_date) > 0  AND aflw_usr_id = '.$user_id.'  AND jwf_role_id = '.$roleid;
		}
		elseif($tile_info['section_id'] == 'manage-overdue-task' && $core_role != 'author')
		{
			$art_status = '';
			$condition[] = ' aflw_status IN (\'u\',\'a\',\'i\',\'w\',\'p\') AND aflw_skip_review = \'n\'';
			$condition[] = 'jwf_stage_type NOT IN(\'author_submission\',\'transit\',\'payment\',\'authors_declaration\',\'revision\',\'decision_resubmit\',\'resubmission\',\'copyright\')';

			$condition[] = ' (CASE  WHEN aflw_status = \'i\' AND aflw_invite_due_date IS NOT NULL AND aflw_parent_flow_id IS NOT NULL THEN (DATEDIFF(NOW(), aflw_invite_due_date) > 0) WHEN aflw_status = \'u\' AND aflw_parent_flow_id IS NULL THEN (DATEDIFF(NOW(), aflw_due_date) > 0) WHEN aflw_status = \'a\' THEN (DATEDIFF(NOW(), aflw_due_date) > 0) WHEN aflw_status IN (\'w\',\'p\') and DATEDIFF(NOW(), aflw_due_date) > 0  THEN aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\' AND a1.aflw_stage_min_users > (SELECT COUNT(inn_tb.aflw_id) AS cnt FROM rvw_article_flow AS inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id AND inn_tb.aflw_status IN(\'a\', \'c\',\'i\')) END ) AND art_status <> \'t\'';
			//'authors_declaration','revision','decision_resubmit','resubmission','copyright',
		}
		elseif($tile_info['section_id'] == 'manage-overdue-task' && $core_role == 'author')
		{
			$author_table = (new \App\Models\Authors())->getTable();

			$art_status = ' art_status <> \'c\'';

			$condition[] ='DATEDIFF(NOW(), aflw_due_date) > 0';
			$condition[] = '(CASE WHEN aflw_status <> \'c\' THEN aflw_usr_id = '.$user_id.'   WHEN (art_status IN (\'n\',\'t\') OR (art_status = \'c\' AND aflw_status <> \'c\' AND jwf_stage_type = \'resubmission\'))  AND art_submitted_by = '.$user_id.' THEN (select count(auth_id) FROM '.$author_table.' WHERE auth_art_id = art_id AND auth_usr_id = '.$user_id.' AND auth_confirm_status = "i")>0 END)  AND jwf_role_id = '.$roleid;
		}
		elseif($tile_info['section_id'] == 'manage-production-management-completed-task'  || $tile_info['section_id'] == 'manage_production_completed_task')
		{
			$condition[] = 'aflw_status=\'c\' AND aflw_usr_id = '.$user_id.' AND jwf_role_id = '.$roleid;
			$art_status = ' art_status NOT IN (\'n\',\'t\') ';
		}
		elseif($tile_info['section_id'] == 'manage-reviewer-score' || $tile_info['section_id'] == 'select-invite-reviewer')
		{
			$array_data['invite_sub_table']= TRUE;
			
			$review_cond = 'aflw_status IN (\'i\',\'a\',\'c\') AND aflw_parent_flow_id IS NOT NULL AND invite_flow_table.flow_stage_id = a1.aflw_parent_flow_id';
			$review_cond_flag = ' >= ';
			if($tile_info['section_id'] == 'select-invite-reviewer')
			{
				$review_cond_flag = ' < ';
				$review_cond = ' CASE WHEN aflw_status IN (\'i\',\'a\') THEN invite_flow_table.flow_stage_id = a1.aflw_parent_flow_id AND aflw_parent_flow_id IS NOT NULL WHEN aflw_status = \'w\' THEN  invite_flow_table.flow_stage_id = a1.aflw_id END ';
			}

			$shortlist_score = ' (select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = invite_flow_table.flow_stage_id AND tb1.aflw_status IN (\'u\',\'i\',\'a\',\'c\') ) '.$review_cond_flag.' invite_flow_table.invite_min_users';

			$invite_score = ' (select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = invite_flow_table.flow_stage_id AND tb1.aflw_status IN (\'i\',\'a\',\'c\') ) '.$review_cond_flag.' invite_flow_table.invite_min_users';

			$condition[] = $review_cond;
			$condition[] = '('.$shortlist_score.' OR '.$invite_score.')';
			if($tile_info['section_id'] == 'manage-reviewer-score')
			{
				$condition[] = ' (select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = invite_flow_table.flow_stage_id AND tb1.aflw_status IN (\'i\',\'a\') ) > 0 ';
			}
		}
		elseif($tile_info['section_id'] == 'manage-pending-review')
		{
			$art_status = 'art_status IN (\'y\') ';
		}
		elseif($tile_info['section_id'] == 'article_invite')
		{
			$art_status = ' art_status= \'n\'';
			$condition[] = ' aflw_status = \'i\' AND art_stage_submission_method = \'b\' ';
		}
		elseif($tile_info['section_id'] == 'manage-draft')
		{
			$art_status = ' art_status= \'n\'';
			$condition[] = ' art_prev_article_id IS NULL AND aflw_status NOT IN (\'u\',\'d\') AND art_stage_submission_method NOT IN (\'n\',\'z\') ';
		}
		elseif($tile_info['section_id'] == 'manage-copyright-complete')
		{
			$art_status = ' art_status <> \'n\'';
			$condition[] = ' aflw_status = \'a\'';
		}
		elseif($tile_info['section_id'] == 'manage-coauthor')
		{
			if($this->current_client->modules->mdl_es_integration == 'n')
			{
				$art_status = ' art_status NOT IN (\'n\',\'t\') ';
				$condition[] = ' FIND_array_intersect('.$user_id.',author_art_table.author_list) = 1 AND art_submitted_by != '.$user_id.' AND jwf_role_id = '.$roleid;
			}
			else
			{
				$art_status = ' art_status NOT IN (\'t\') ';
				$condition[] = ' FIND_array_intersect('.$user_id.',author_art_table.author_list) = 1 AND art_submitted_by != '.$user_id.' AND jwf_role_id = '.$roleid.' AND IF(
					art_status = \'n\',
					art_es_document_status != \'n\' AND(
						IF(
							atotp_co_authors_agreement = \'y\',
							(
							SELECT
								COUNT(art_author_tbl.auth_id) AS cnt
							FROM
								rvw_article_authors art_author_tbl
							WHERE
								art_author_tbl.auth_confirm_status = \'y\' AND art_author_tbl.auth_art_id = art_id AND art_author_tbl.auth_usr_id = '.$user_id.'
						) > 0 AND art_prev_article_id IS NULL,
						TRUE
						)
					),
					TRUE
				) ';
			}
		}
		/*elseif($tile_info['section_id'] == 'author-collab')
		{
			$art_status = ' art_status IN (\'n\') ';
			$condition[] = ' FIND_array_intersect('.$user_id.',author_art_table.author_list) = 1 AND art_submitted_by != '.$user_id.' AND jwf_role_id = '.$roleid.' AND  IF(article_type_table.atotp_co_authors_agreement = \'y\',(SELECT count(art_author_tbl.auth_id) as cnt from rvw_article_authors art_author_tbl WHERE art_author_tbl.auth_confirm_status = \'y\' AND art_author_tbl.auth_art_id = art_id AND art_author_tbl.auth_usr_id = '.$user_id.') > 0,TRUE) AND art_prev_article_id IS NULL ';
		}*/
		elseif($tile_info['section_id'] == 'manuscript-to-confirmation')
		{
				$art_status = ' (IF(author_art_table.auth_seek_confrim IS NOT NULL ,art_status = \'n\', TRUE) OR art_status = \'t\')';
				$seek_confirmation = 'art_submitted_by != '.$user_id.' AND FIND_array_intersect('.$user_id.',author_art_table.auth_seek_confrim) = 1 AND jwf_stage_type = \'author_submission\'';
				$transfer_art = 'aflw_usr_id = '.$user_id.' AND art_submitted_by = '.$user_id.' AND jwf_stage_type = \'transit\' AND aflw_status = \'a\'';
				$condition[]='(('.$seek_confirmation.') OR ('.$transfer_art.'))';
		}
		elseif($tile_info['section_id'] == 'manage-biorxiv')
		{
			$art_status = ' art_status = \'b\'';
			$condition[] = ' art_biorxiv = \'y\' AND bimp_jnl_id ='.$jnl_id;
			$array_data['biorxiv_import'] = TRUE;
		}
		elseif($tile_info['section_id'] == 'manage-invitation')
		{
			$condition[] = ' jwf_role_id = '.$roleid.' AND aflw_status = \'i\'';
		}
		elseif($tile_info['section_id'] == 'manage-under-review')
		{
			$condition[] = ' jwf_role_id = '.$roleid.' AND aflw_status = \'a\'';
		}
		elseif($tile_info['section_id'] == 'declined-invitation')
		{
			$art_status = 'art_status IN(\'a\',\'y\',\'c\')';
			$condition[] = ' jwf_role_id = '.$roleid.' AND aflw_status IN(\'d\',\'g\') AND aflw_usr_id = '.$user_id;
		}
		elseif($tile_info['section_id'] == 'article_ready_production_manuscript')
		{
			$condition[] = ' jwf_role_id = '.$roleid.' AND aflw_status IN (\'a\',\'u\') AND IF(aflw_status = \'a\', aflw_usr_id = '.$user_id.',TRUE) ';
		}
        elseif($tile_info['section_id'] == 'withdrawn-submissions')
		{
			    $art_status = 'art_status != \'n\'';
				$array_data['for_withdrawn_article'] = TRUE;
				$condition[] = ' FIND_array_intersect('.$user_id.',author_art_table.author_list) = 1 AND jwf_role_id = '.$roleid;
		}
		elseif($tile_info['section_id'] == 'manage-submitted')
		{
			$art_status ='art_status IN(\'a\',\'y\',\'c\')';
		}
		elseif($tile_info['section_id'] == 'overview')
		{
			if($core_role == 'editor_in_chief' || $core_role == 'associate_editor')
			{
				if($core_role != 'associate_editor')
				{
					$pre_acceptance_stage = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.pre_acceptance_stage';
					$stage_type  = Config::get($pre_acceptance_stage);
				}

				if ($this->current_client->functionality->cfty_manage_search_results_for_editors == 'y')
				{
					$array_data['self_worked_artciles'] = TRUE;
				}
			}

			//$art_status = 'art_status IN (\'y\',\'a\',\'t\')  ';
			$art_status = ' IF(art_status IN (\'c\',\'n\') AND a1.aflw_status IN (\'u\',\'a\'),jwf_stage_type = \'resubmission\',art_status IN (\'y\',\'a\',\'t\'))  ';
			$condition[] = 'FIND_array_intersect('.$roleid.',user_artp_roles) = 1';

			$inner_list = (isset($tile_info['inner_list']))?$tile_info['inner_list']:FALSE;

			$overview_title = (isset($tile_info['title']))?$tile_info['title']:'';
			//$select = 'jwf_stage_name,count(aflw_id) as cnt';
			if($type == 'resubmission' && (isset($tile_info['title']) && $tile_info['title'] =='In Revision'))
			{
				$overview_title = 'Revision';
			}
			$group_by = '';
			$select = 'count(aflw_id) as cnt';
			if($inner_list == FALSE)
				$return_count = TRUE;
			if($type == 'overdue-reviewers')
			{
				$condition[] = ' a1.aflw_status IN (\'i\',\'a\')   AND jwf_stage_type = \'review\' AND now() >  aflw_due_date ';
			}
			elseif($type == 'checkout_articles')
			{
				$art_status = 'art_status != \'t\'';
				$condition[] = ' aflw_status = \'a\'  AND jwf_stage_type IN ("staff_check","pre_assessment","post_assessment") ';
			}
			elseif($type == 'author_withdrawn_articles')
			{
				$art_status = 'art_status != \'n\'';
				$array_data['for_withdrawn_article'] = TRUE;
				$condition[] = ' FIND_array_intersect('.$user_id.',author_art_table.author_list) = 1 AND jwf_role_id = '.$roleid;
			}
			elseif($type == 'Accepted')
			{
				$condition[] =  ' aflw_status IN (\'u\',\'i\',\'a\',\'w\',\'p\') AND IF(jwf_assignment = "invitation",a1.aflw_status != "u",TRUE)' ;
				$art_status = ' art_status = \'a\' ';
			}
			elseif($type == 'Rejected')
			{
				$art_status = ' art_status = \'r\' ';
				$stage_type = array('reject');
			}
			elseif($type == 'review_selection')
			{
				$art_status = ' art_status IN (\'y\',\'a\') ';
				$condition[] = ' jwf_stage_type = \'review\' AND aflw_status IN(\'w\', \'p\') AND aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\'';

				$condition[] = 'IF(a1.aflw_more_review_skip_status = \'n\' AND a1.aflw_reopened_min_user_count > 0,a1.aflw_reopened_min_user_count,a1.aflw_stage_min_users) >(SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE a1.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status IN(\'i\', \'a\', \'c\') ) ';
			}
			elseif($type == 'reviewer_response')
			{
				$art_status = ' art_status IN (\'y\',\'a\') ';
				$condition[] = ' a1.aflw_status = \'i\' AND jwf_stage_type = \'review\' AND aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\' ';
			}
			elseif($type == 'reviewer_report')
			{
				$art_status = ' art_status IN (\'y\',\'a\') ';
				$condition[] = ' a1.aflw_status = \'a\' AND jwf_stage_type = \'review\' AND aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\' ';
			}
			elseif($type == 'review_overdue')
			{
				$art_status = ' art_status IN (\'y\',\'a\') ';
				$condition[] = ' a1.aflw_status IN (\'i\',\'a\')   AND jwf_stage_type = \'review\' AND now() >  aflw_due_date  AND aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\'';
			}
			elseif($type == 'production_draft_article')
			{
				$art_status = ' art_status =\'n\'';
				$condition[] = ' art_stage_submission_method IN (\'n\',\'z\') AND art_posted_by ='.$user_id;
				$stage_type = array('author_submission');
				//echo 'here';print_r($condition);exit;
			}
			elseif($type == 'legacy_article') //in progress
			{
				$art_status = ' art_status =\'n\'';
				$condition[] = ' art_stage_submission_method IN (\'n\',\'z\') AND art_posted_by ='.$user_id;
				$stage_type = array('author_submission');
				//echo 'here';print_r($condition);exit;
			}
			elseif($type == 'author_submitted_articles') {
				// WHERE art_submitted_by =' . $user_id . '  AND art_artp_id = artp_id AND art_status NOT IN (\'b\', \'n\') AND art_delete_status IN (\'n\',\'h\') AND artp_jnl_id =' . $journal_id . '
				$art_status = ' art_status NOT IN (\'b\', \'n\')';
				if(isset($post_data['userid'])) {
					$userinfo_userid 	=	decrypt_link($post_data['userid']);
					$condition[] = ' art_submitted_by ='.$userinfo_userid.' AND art_delete_status IN (\'n\',\'h\')';
				} else {
					$condition[] = ' art_delete_status IN (\'n\',\'h\')';
				}
				$stage_type = array('author_submission');
			}
			else
			{
				$return_count = FALSE;
				$array_data['articleflow_as_resultset']=TRUE;

				$p_condition_str = ' WHEN a1.aflw_status = \'p\' THEN a1.aflw_stage_min_users > (SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE a1.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status IN(\'a\', \'c\',\'h\')) ';
				$condition[] =  ' aflw_status IN (\'u\',\'i\',\'a\',\'w\',\'p\',\'n\')' ;
				$condition[] = '(CASE WHEN stagename_reset_table.article_status IN (\'c\',\'n\') THEN stagename_reset_table.stage_type = \'resubmission\' AND stagename_reset_table.afl_status IN (\'u\',\'a\') '.$p_condition_str.' WHEN stagename_reset_table.article_status != \'n\' THEN stagename_reset_table.afl_status IN(\'u\', \'i\', \'a\', \'w\') END)';

				//$condition[] = 'aflw_parent_flow_id IS NULL';

				$select = ' count(distinct art_id) as count,jwf_stage_name,jwf_stage_type,art_id,jwf_stage_name_new,jwf_stage_type_new ';

				$stage_keys = $this->get_production_stages_keys($workflow_arr,FALSE,TRUE);
				$stage_key_arr = $stage_keys['review'];

				if(isset($this->current_client->modules->mdl_production) &&  $this->current_client->modules->mdl_production == 'y')
				{
					if(isset($stage_keys['production']) && $stage_keys['production'] > 0)
					{
						$stage_key_arr = array_merge($stage_key_arr,$stage_keys['production']);
						$production_user_roles = overview_productionroles();
                        if(in_array($core_role,$production_user_roles)  && $inner_list == FALSE)
						{
							$condition[] =  'stage_type IN ( \'' . implode('\',\'',$stage_keys['production']) . '\' ) ';
						}

                    }
				}

				//condition set for inner lising
				if($inner_list == TRUE)
				{
					$condition[] =  'stagename_reset_table.jwf_stage_type_new = \''.$type.'\' ';
					$condition[] =  'stagename_reset_table.jwf_stage_name_new = \''.$overview_title.'\'';
				}
				else
				{
				$group_by = array('jwf_stage_name_new','jwf_stage_type_new');
				$order_by = 'FIELD(stage_type,\'' . implode('\',\'', $stage_key_arr) . '\')';
				}
			}
		}
		// #6007 : All Request Tile Starts
		elseif($tile_info['section_id'] == 'all-request'){
			$array_data['all_req'] = true;
			$art_status = ' art_status IN (\'y\',\'a\',\'n\')  ';
			$prevent_edit_cond = '(cusr_action_type!=\'more_review\' AND IF(JSON_SEARCH(jp_prevent_edit,\'all\','.$roleid.') IS NOT NULL,IF(user_allocation_table.allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$user_id.', allocate_curr_role_users),TRUE),FALSE))'; 
			$condition[] = $prevent_edit_cond; 
			// if($return_count == TRUE){
			// 	$select = 'IF('.$prevent_edit_cond.',count(DISTINCT cusr_id),0) AS cnt,IF('.$prevent_edit_cond.',cusr_action_type,"") AS cusr_action_type';
			// }else
			$select_pe = ',IF('.$prevent_edit_cond.',(cusr_id),"") AS cusr_id,IF('.$prevent_edit_cond.',cusr_action_type,"") AS cusr_action_type,IF('.$prevent_edit_cond.',cusr_status,"") AS cusr_status';
				
		}
		// #6007 : All Request Tile Ends
		elseif((!isset($this->current_client->modules->mdl_production) || (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n')) && $tile_info['section_id'] == 'copy_editor_ready_production')
		{
			$art_status = 'art_status = \'a\' ';
			$condition[] = ' aflw_status IN (\'u\',\'a\') AND ( aflw_usr_id IS NULL OR aflw_usr_id = '.$user_id.') AND jwf_role_id =' . $roleid;
		}
		elseif(isset($this->current_client->modules->mdl_copyedit) &&  $this->current_client->modules->mdl_copyedit == 'y')
		{
			$art_status = ' art_status = \'y\'  ';
			if($tile_info['section_id'] == 'manage_copyediting' || $tile_info['section_id'] == 'my-open-task')
			{
				$condition[] = ' aflw_status IN (\'u\',\'a\') ';
			}
			elseif($tile_info['section_id'] == 'finished_publish')
			{
				$condition[] = ' aflw_status = \'c\' ';//my_completed_task
			}
		}
		elseif(isset($this->current_client->modules->mdl_production) &&  $this->current_client->modules->mdl_production == 'y')
		{
			if($tile_info['section_id'] != 'open-generic-discussion')
				$art_status = 'art_status = \'a\' ';

			if($tile_info['section_id'] == 'my-open-task')
			{
				$condition[] = ' jwf_role_id = '.$roleid.' AND aflw_usr_id = '.$user_id.' AND aflw_status = \'a\' ';

			}
			elseif($tile_info['section_id'] == 'bounced-back' || $tile_info['section_id'] == 'to-be-check' || $tile_info['section_id'] == 'to-submit-aop2-web-files-inprogress' || $tile_info['section_id'] == 'to-be-copyedited' || $tile_info['section_id'] == 'to-be-typeset' || $tile_info['section_id'] == 'postprocessing' || $tile_info['section_id'] == 'files-for-correction' || $tile_info['section_id'] == 'article-ready-production_manuscript' || $tile_info['section_id'] == 'proofcheck')
			{
				$condition[] = ' aflw_status IN (\'a\',\'u\') ';
               if($tile_info['section_id'] == 'to-be-check')
			   {
				$condition[] = 'jwf_role_id = '.$roleid;
			   }

			}
			elseif($tile_info['section_id'] == 'to-submit-aop2-web-files-completed') //core role publish (typesetting) - completed articles
			{
				$array_data['issue_tb_connect'] = TRUE;
				$condition[] = ' aflw_status =\'c\' AND IF(tb_issues.iss_status IS NOT NULL,tb_issues.iss_status != \'c\',TRUE)';
			}
			elseif($tile_info['section_id'] == 'copy_editor_ready_production' || $tile_info['section_id'] == 'manage_ready_publishing')
			{
				$condition[] = 'aflw_status IN (\'u\',\'a\') AND ( aflw_usr_id IS NULL OR aflw_usr_id = '.$user_id.') AND jwf_role_id =' . $roleid;
			}
			elseif($tile_info['section_id'] == 'preprocessing' && $core_role == 'tsp')//information tile
			{
				$condition[] = 'aflw_status IN (\'u\',\'a\',\'w\',\'p\') AND aflw_parent_flow_id = NULL';
			}
			elseif($tile_info['section_id'] == 'to-submit-aop2-web-files')//information tile
			{
				$condition[] = 'aflw_status IN (\'a\',\'u\',\'c\')';
				$array_data['issue_tb_connect'] = TRUE;
				$condition[] = ' IF(tb_issues.iss_status IS NOT NULL,tb_issues.iss_status != \'c\',TRUE)';
			}
			elseif($tile_info['section_id'] == 'manage-new-manuscript')
		    {
				$art_status = ' art_status IN (\'y\',\'a\')';
		    }
		}

		if(!empty($stage_type))
		{
			if(count($stage_type) > 1)
			{
				$condition[] = ' jwf_stage_type IN (\''. implode('\',\'', $stage_type).'\')';
			}
			else
			{
				$condition[] = ' jwf_stage_type = \''.$stage_type[0].'\'';
			}
		}

		if(empty($tile_info['section_id']))
		{
			$art_status = ' art_status IN (\'y\',\'a\')';
		}
		if(!empty($art_status))
		{
			$condition[] = $art_status;
		}

        if(($this->current_client->modules->mdl_conference ?? 'n') == 'y'){
            $array_data['non_author_flag']=false;
        }

		$tile_condition = implode(' AND ',$condition);
        if(isset($post_data['artp_id']) && is_numeric($post_data['artp_id'])){
            $artp_id = $post_data['artp_id'];
            $tile_condition .= " AND art_artp_id = {$artp_id} ";
        }
		//dd($tile_condition);
		$array_data['user_id']=$current_user['user_id'];
		$array_data['jnl_id']=$post_data['jnl_id'];
		$array_data['select']=$select;
		$array_data['return_count']=$return_count;
		$array_data['condition']=$tile_condition;
		$array_data['cfty_manage_privilaged_user_as_reviewer']=FALSE;
		$array_data['limit']=NULL;
		$array_data['start']=NULL;
		$array_data['group_by']=$group_by;
		$array_data['order_by']=$order_by;
		$array_data['assignment']=$join_permission_tb_flag;
		$array_data['role_id']=$roleid;
		$array_data['art_flow_alias']=TRUE;
		$array_data['cfty_allow_privileged_users_as_only_reviewer'] = $cfty_allow_privileged_users_as_only_reviewer;
		$array_data['clnt_client_code']=$this->current_client->clnt_client_code;
		$array_data['movenext'] = isset($post_data['movenext'])?$post_data['movenext']:FALSE;
		$array_data['page'] = isset($post_data['page'])?$post_data['page']:'';
		$array_data['core_role']=$core_role;
		$array_data['completed_task']=(isset($tile_info['section_id']) && ($tile_info['section_id']=='manage-completed-task' || $tile_info['section_id']=='manage-production-management-completed-task'))?true:false;
	    $array_data['transfer_tb_connect'] = true;
		$array_data['parent_review_only']=(isset($tile_info['section_id']) && ($tile_info['section_id']=='manage-reviewer-score' || $tile_info['section_id']=='manage-pending-review'))?true:false;
		if($return_count == TRUE)
		{
			//DB::enableQueryLog();
			$count = Articles::base_function_to_get_article_details($array_data);
			//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
			$result =  $count->cnt;
		}
		elseif($tile_info['section_id'] == 'overview' && $inner_list == FALSE)
		{
			$array_data['pagination'] = FALSE;

			//DB::enableQueryLog();
			$result = Articles::base_function_to_get_article_details($array_data);
			//$query = DB::getQueryLog();
			//$query = end($query);
			//print_r($query);exit;
		}
		else
		{
			$array_data['issue_tb_connect'] = TRUE;

			$date_format = $this->get_platform_date_format($post_data['jnl_id']);
			$date_format = $this->date_format_map($date_format);

			$jwf_parent_user_roles_new = 'REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")';
            $jwf_who_can_invite_new = 'REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")';

			$art_user_allocation_cnd = ' IF(allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$this->current_user['user_id'].',allocate_curr_role_users) = 1, '.$user_retire_flag.' AND FIND_array_intersect('.$roleid.',user_artp_roles) = 1) ';

			$select_shortlist_permission = ',IF(aflw_status IN (\'w\',\'p\')  AND FIND_array_intersect('.$post_data['role_id'].','.$jwf_parent_user_roles_new.') = 1 AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS shortlist_permission';

			$select_invite_permission = ',IF(aflw_status = \'w\' AND FIND_array_intersect('.$post_data['role_id'].','.$jwf_who_can_invite_new.') = 1 AND aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\' AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS invite_permission';

			$select = 'art_prev_article_id,artp_palette_color_code,artp_fwm_id,DATE_FORMAT(art_epub_date,"' . $date_format . '") AS rv_art_epub_date,IF(art_epub_date IS NOT NULL and art_epub_date< now(),1,0) as art_epub_date_flag,artp_jpm_id,artp_special_issue,artp_article_type,artp_abbr_article_type,art_id,art_code,art_status,art_delete_status,art_title,art_artp_id,art_submitted_by,DATE_FORMAT(art_submission_date, "' . $date_format .' %H:%i") as art_submission_date_format,art_stub,aflw_id,aflw_due_date as due_date,DATEDIFF(aflw_due_date ,NOW()) AS rvd_remaining_days,aflw_art_id as reviewed_article,art_publication_issue,iss_soft_end_date,auth_corr_author_list,atotp_review_method,atotp_custom_blind_params,art_posted_by,iss_hard_end_date,ats_author_action'.$select_shortlist_permission.$select_invite_permission.$select_pe;

			$array_data['group_by'] = 'art_id';
			$array_data['select']=$select;
			if($order_by == '')
				$array_data['order_by'] = 'aflw_id';

			//DB::enableQueryLog();
			$article_list['head'] = Articles::base_function_to_get_article_details($array_data);
			//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;

			$article_list['format_head_stage']=$this->format_head_article($article_list['head'],$post_data['jnl_id'],$post_data['jnl_code'],$post_data['role_id']);
			$jnl_date_form = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$post_data['jnl_id']}' ")->jset_date_format;
			$jnl_dateformat_array = $this->Utility('date_format');
			$array_date = $jnl_dateformat_array['date_format'];
			$article_list['jnl_date_format'] = $array_date[$jnl_date_form];
			//echo '<pre>';print_r($article_list['format_head_stage']);exit;

			$art_id_arr = array();

			if(count($article_list['head']) > 0)
			{
				$array_data['group_by'] = array('art_id','aflw_id');

				$art_id_arr = array();
				foreach($article_list['head'] as $item)
				{
					$art_id_arr[] = $item->art_id;
				}


				$article_list['format_head_stage']=$this->format_head_article($article_list['head'],$post_data['jnl_id'],$post_data['jnl_code'],$post_data['role_id']);


				$select = 'art_prev_article_id,art_stage_submission_method,art_posted_by,art_artp_id,artp_jpm_id,artp_fwm_id,art_status,art_delete_status,art_submitted_by,aflw_id,aflw_parent_flow_id,aflw_art_id as art_id,aflw_jwf_id,aflw_remarks,aflw_stage_min_users,aflw_stage_max_users,aflw_status,aflw_due_date,aflw_invite_due_date,aflw_posted_by,aflw_operation,aflw_usr_id,jwf_stage_name,jwf_status_name,jwf_temporary_status_name,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as per_shotlist_roles,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as jwf_parent_user_roles_new,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as per_invite_roles,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as jwf_who_can_invite_new,jwf_role_id,jwf_stage_type,art_publication_issue,iss_soft_end_date,iss_hard_end_date,ats_author_action'.$select_shortlist_permission.$select_invite_permission;

				$select .= ' ,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE a1.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status IN(\'u\',\'i\',\'a\',\'c\')),NULL) as shot_listed,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(base_tbtwo.aflw_id) FROM '.$article_flow_table.' base_tbtwo WHERE a1.aflw_id = base_tbtwo.aflw_parent_flow_id AND base_tbtwo.aflw_status IN(\'i\',\'a\',\'c\')),NULL) as invited_list';

				$select .= ',DATEDIFF(a1.aflw_due_date ,NOW()) AS rvd_remaining_days';
				$select .= ',DATEDIFF(a1.aflw_invite_due_date ,NOW()) AS rvd_remaining_days_invite_due';

				$select .= ',DATE_FORMAT(a1.aflw_due_date,"' . $date_format . ' %H:%i") AS rvd_aflw_due_date';
				$select .= ',DATE_FORMAT(a1.aflw_invite_due_date,"' . $date_format . ' %H:%i") AS invite_due_date';
				$select .= ',DATE_FORMAT(aflw_assigned_date,"' . $date_format . ' %H:%i") AS aflw_assigned_date';
				$select .= ',DATE_FORMAT(aflw_accepted_date,"' . $date_format . ' %H:%i") AS aflw_accepted_date';
				$select .= ',DATE_FORMAT(aflw_returned_date,"' . $date_format . ' %H:%i") AS aflw_returned_date';
				//$select.=',DATE_FORMAT(a1.aflw_due_date,"' . $date_format . ' %H:%i") AS rvd_aflw_due_date';

				if($tile_info['section_id'] == 'open-generic-discussion')
				{
					$select .= ',GROUP_CONCAT(DISTINCT tbl_unread.gdsc_id) as unread_ids,COUNT(DISTINCT tbl_unread.gdsc_id) AS unread_ids_cnt';
					$array_data['group_by'] = array('art_id');
				}
				elseif($tile_info['section_id'] == 'manage-peer-review'  && $core_role == 'author')
				{
					$array_data['group_by'] = array('art_id','jwf_status_name');
				}

				$article_str_list = implode(',',$art_id_arr);
				$array_data['condition']= $array_data['condition']. ' AND  art_id IN ('.$article_str_list.')';

				$art_order_list = ' FIELD(art_id,'.$article_str_list.') ASC ';
				if($array_data['order_by'] != '')
				{
					$array_data['order_by'] = $art_order_list.', '.$array_data['order_by'];
				}
				else
				{
					$array_data['order_by'] = $art_order_list.', aflw_id ASC';
				}

				$array_data['select']=$select;
				$array_data['pagination'] = FALSE;
				//DB::enableQueryLog();
				$article_stages = Articles::base_function_to_get_article_details($array_data);
				//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
				//dd($article_stages);


				$type = $fn_type;

				$article_list['stages'] = $this->arrange_article_stages($article_stages,$post_data['jnl_code'],$post_data['jnl_id'],$core_role,$type,$my_task,$post_data['role_id'],$fn_section);

				$article_list['es_data_global_arr'] = $article_list['stages']['es_data_global_arr'];
				//$article_list['stages'] = $article_list_stages['art_stages'];
			}
			$result =  $article_list;

		}

		return $result;
	}

    //load todo section in dashboard
    public function load_todo(Request $request)
    {
        try
        {

            $validator = Validator::make($request->all(), [
                'jnl_code' => 'required',
                'jnl_id' => 'required',
                'core_role' => 'required',
                'role_id' => 'required',
               // 'my_list' => 'required',
              //  'jset_date_format' => 'required'
            ]);

            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            else
            {
				$post_data = $request->all();

				$input_arr = array(
					'input' => $post_data['jnl_id'],
					'type'=> 'number'
				);
				$jnl_id_validate = $this->Rv_validator($input_arr);

				$input_arr['input']= $post_data['role_id'];
				$role_id_validate = $this->Rv_validator($input_arr);

				$input_arr = array(
					'input' => $post_data['jnl_code'],
				);
				$input_arr['input']= $post_data['jnl_code'];
				$jnl_code_validate = $this->Rv_validator($input_arr);

				$input_arr['input']= $post_data['core_role'];
				$core_role_validate = $this->Rv_validator($input_arr);

				$form_post=isset($post_data['filter']) ? $post_data['filter'] : array();
				$filter_validate = $this->filter_validator($form_post);

				if($jnl_id_validate == TRUE && $role_id_validate == TRUE && $jnl_code_validate == TRUE && $core_role_validate == TRUE && $filter_validate == TRUE)
				{
					$article_list = array(
						'head' => array(),
						'stages'=>array()
					);

					if(isset($post_data['sort_order'])&&(!empty($post_data['sort_order'])))
					{

						if(is_array($post_data['sort_order'])==true)
						{
							$form_post['sort_order']=$post_data['sort_order'];

						}
						else
						{

						$sort_order=explode(" ",$post_data['sort_order']);
						$arrange_order['sort_type']=$sort_order[0];
						$arrange_order['order']=$sort_order[1];
						$form_post['sort_order']=$arrange_order;


						}

					}
					$my_list = TRUE;
					$only_jnl_admin = FALSE;
					$this->current_user = $this->get_current_user_details();

					//CHECK: journal active or not
					$where_cnd = array(
						'jnl_id'=> $post_data['jnl_id']
					);
					/*
					$bind = array();
					$where_cnd = 'jnl_id = ?';//.$post_data['jnl_id'];
					$bind = array($post_data['jnl_id']);
					$bind = array($post_data['jnl_id']);
					*/
					//DB::enableQueryLog();
					$jnl_data = Journals::get_single_record_with_bind_cond('jnl_journal_status,jnl_article_submission_status',$where_cnd);
					// $query = DB::getQueryLog();
					// $query = end($query);
					// print_r($query);exit;
					if(isset($jnl_data->jnl_journal_status) && $jnl_data->jnl_journal_status == 'n')
					{
						return $this->warning('Failed',422,customTrans('dashboard.inactive_journal'),403);
					}
					//$this->current_user = $this->get_current_user_details();

					$user_roles = $this->validate_user_journal($post_data['jnl_code'], $this->current_user['user_id']);

					if ($user_roles['status'] == TRUE)
					{
						if($post_data['core_role'] == 'journal_admin')
						{
							$only_jnl_admin = TRUE;
							$my_list = FALSE;
						}

						if (isset($post_data['filter']['my_list']) && $post_data['filter']['my_list'] == 0)
						{
							$my_list = FALSE;
						}

						$roles = User_to_journals::get_user_role_ids($post_data['jnl_id'],$this->current_user['user_id'],$post_data['role_id']);
						$user_roles =  $this->rebuild_array_by_field($roles,'usrj_artp_id');

					if(!empty($user_roles))
						{
							$artpid = implode(',', array_keys($user_roles));
							$order_by = '';
							$total_condition ='';
							$post_condition='';
							$journal_data['jnl_id']=$post_data['jnl_id'];
							$journal_data['jnl_code']=$post_data['jnl_code'];
							$journal_data['role_id']=$post_data['role_id'];


							$search_condition = $this->global_function_for_search_article('inner_list', $form_post, TRUE,array(),array(),$journal_data,array(),$post_data);

							if ($search_condition != NULL)
							{
							if(isset($search_condition['conditions'])&&$search_condition['conditions']!=NULL)
								$form_post['conditions'] = $post_condition = $search_condition['conditions'];
								if(isset($search_condition['condition_stage']))
								{
								$form_post['condition_stage'] = $search_condition['condition_stage'];
								if($search_condition['condition_stage'] != '')
									$post_condition .= ' AND (jwf_stage_name ' . $search_condition['condition_stage'] . ' OR jwf_status_name ' . $search_condition['condition_stage'] . ' )';
								}
								if(isset($search_condition['condition_order_by'])&&$search_condition['condition_order_by']!=NULL)
								{
									$form_post['condition_order_by'] = $order_by_cond = $search_condition['condition_order_by'];
								}
							if(isset($search_condition['sort_type_array'])&&$search_condition['sort_type_array']!=NULL)
							{
								$form_post['condition_order_by']  =$search_condition['sort_type_array'];
								//$order_by = $search_condition['sort_type_array']['sort_type'].' '.$search_condition['sort_type_array']['sort_order'];
								//$order_by = 'REGEXP_REPLACE('.$search_condition['sort_type_array']['sort_type'].',\'<p>&nbsp;|<p> \',\'\') '.$search_condition['sort_type_array']['sort_order'];
								$order_by = ' strip_tags(REGEXP_REPLACE('.$search_condition['sort_type_array']['sort_type'].',\'<p>&nbsp;|<p> |<p>&ldquo;|<p>"\',\'\')) '.$search_condition['sort_type_array']['sort_order'];
							}
								if(isset($search_condition['my_task']))
								{
									$form_post['my_task'] = $search_condition['my_task'];
								}

								$total_condition =$post_condition;
							}

							$date_format = $this->get_platform_date_format($post_data['jnl_id']);
							$date_format= date_format_map($date_format);
							//$articletype_table = (new \App\Models\Article_types())->getTable();
							$artflw_table = (new \App\Models\Article_flow())->getTable();

							$group_by = NULL;

							//Bug #2036 JPR-214 Retiring an AE/Editor on review2    dashboard
							$user_retire_status = $this->get_user_role_retire($post_data['role_id'],$this->current_user['user_id'],$post_data['jnl_id']);

							$fu_type = 'd';
							$fu_section = '';

							//Task #596 Create EIDO configuration and build workflow
							if($this->current_client->modules->mdl_review_for_doc == 'y')
							{
								$shortlist_cnd = '';
								$invite_cnd = '';
								$user_having_role = '';
								$user_current_role = ' TRUE ';
								$true_flag = ' TRUE ';
								if($post_data['core_role'] != 'journal_admin' && $my_list == TRUE)
								{
									$shortlist_cnd = ' FIND_IN_SET('.$post_data['role_id'].',REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")) > 0 AND ';
									$invite_cnd = ' FIND_IN_SET('.$post_data['role_id'].',REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")) > 0 AND';

									$user_having_role = ' FIND_IN_SET('.$post_data['role_id'].',user_artp_roles) > 0  AND';
									$user_current_role = ' jwf_role_id = '.$post_data['role_id'];

									$true_flag = ' aflw_usr_id = '. $this->current_user['user_id'].' AND  jwf_role_id = '.$post_data['role_id'];
								}

								$shortlist = $shortlist_cnd.' (select count(aflw_id) FROM '.$artflw_table.' as tb1 WHERE tb1.aflw_parent_flow_id = a1.aflw_id AND tb1.aflw_status IN (\'u\',\'i\',\'c\') ) < a1.aflw_stage_min_users';

								$invite = $invite_cnd.' (select count(aflw_id) FROM '.$artflw_table.' as tb1 WHERE tb1.aflw_parent_flow_id = a1.aflw_id AND tb1.aflw_status IN (\'i\',\'c\') ) < a1.aflw_stage_min_users';

								$review_assignment = ' AND IF('.$shortlist.',TRUE,'.$invite.' )';

								$condition =  $user_having_role.'  CASE ';

								$condition .= '  WHEN  art_status = \'y\' AND aflw_status = \'w\' '.$review_assignment.' THEN TRUE '; //for priviledged user's assigment

								$condition .= ' WHEN art_status = \'y\' AND aflw_status IN (\'a\',\'i\' ) THEN  '.$true_flag; //for accepted / invited users

								$condition .= ' WHEN  art_status = \'y\' AND aflw_status = \'u\' AND jwf_stage_type != \'review\' THEN  '.$user_current_role; //for ready stages

								if($my_list == TRUE)
								{
									$condition .= ' WHEN  art_status = \'n\' AND aflw_status = \'a\' AND jwf_stage_type = \'author_submission\' THEN  '.$true_flag; //for submission in progress stage
								}

								$condition .= ' END ';
								$condition .= $post_condition;


								$select = 'artp_palette_color_code,atotp_review_method,atotp_custom_blind_params,artp_article_type,artp_special_issue,artp_abbr_article_type,art_id,art_status,art_delete_status,art_title,art_artp_id,art_submitted_by,DATE_FORMAT(art_update_last_date, "' . $date_format .'") as art_update_last_date_format,aflw_id,DATE_FORMAT(aflw_due_date, "' . $date_format .' %H:%i") as due_date,DATEDIFF(aflw_due_date ,NOW()) AS rvd_remaining_days,aflw_art_id as reviewed_article,art_new_submission,jwf_role_id,art_publication_issue,iss_soft_end_date,iss_hard_end_date,artp_jpm_id,art_code,art_submitted_by,DATE_FORMAT(art_submission_date, "' . $date_format .' %H:%i") as art_submission_date_format,art_es_document_status,art_es_document_type';

								DB::enableQueryLog();
								$article_list['head'] = Articles::base_function_to_get_document_details($this->current_user['user_id'],$post_data['jnl_id'],$select,FALSE,$condition,NULL, NULL, $group_by, $order_by,TRUE,FALSE,FALSE,FALSE,NULL,FALSE);
								//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
								//echo '<pre>';print_r($article_list['head']);exit;
								//dd($article_list['head']);die;
								if(count($article_list['head']) > 0)
								{
									$art_id_arr = array();
									foreach($article_list['head'] as $item)
									{
										$art_id_arr[] = $item->art_id;
									}
									// echo '<pre>';print_r($art_id_arr);die;
									$article_list['format_head_stage']=$this->format_head_article($article_list['head'],$post_data['jnl_id'],$post_data['jnl_code'],$post_data['role_id']);
									//dd($article_list['format_head_stage']);

									$article_list_stages = $this->get_article_stages($art_id_arr,$user_retire_status,$date_format,$post_data['core_role'],$post_data['role_id'],$this->current_user['user_id'],$post_data['jnl_id'],$post_data['jnl_code'],$post_data);

									$article_list['stages'] = $article_list_stages['art_stages'];

									$data_arr = array(
										'jnl_id'=> $post_data['jnl_id'],
										'role_id' => $post_data['role_id'],
										'type' => 'd',
										'art_list' =>$article_list_stages['art_list'],
										'filter_list' => $post_data
									);
									$this->write_user_article_list($data_arr);

								}

							}
							else
							{

								$select = '*';
								$auth_art_data = Articles::get_article_id_details('art_id',$this->current_user['user_id'],array_keys($user_roles));
								$condition = '';
								if($post_data['core_role'] !='author' && !empty($auth_art_data))
								{
									$art_auth_id = array_column(json_decode(json_encode($auth_art_data), true), 'art_id');
									$art_auth_id = implode(', ', $art_auth_id);
									$condition = ' art_id NOT IN ('.$art_auth_id.') AND  art_status =\'y\'';
								}

								//FOR NON PRIVILEGED USERS
								if($post_data['core_role'] == 'author' || $post_data['core_role'] == 'reviewer')
								{
									$stage_data = FALSE;
									$segment = 5;
									//$journal,$journal_code,$journal_dateformat

									$get_art_list= $this->todo_article_list_non_priv_users($post_data['role_id'],$post_data['core_role'],$segment,$post_data['jnl_id'],$search_condition,$post_data['jnl_code'],$date_format,$this->current_user);



									$article_list['head'] = $get_art_list['article_list'];

									$article_list['format_head_stage']=$this->format_head_article($get_art_list['article_list'],$post_data['jnl_id'],$post_data['jnl_code'],$post_data['role_id']);


									$article_list['stages']= $get_art_list['stage_list'];
									$article_list['global_es_data'] = $get_art_list['es_data_global_arr'];


								}
								else
								{
									$count_condition = '';

									$article_flow_table = (new \App\Models\Article_flow())->getTable();

									$cfty_manage_privilaged_user_as_reviewer = FALSE;
									$cfty_allow_privileged_users_as_only_reviewer = FALSE;
									if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y') {
										$cfty_manage_privilaged_user_as_reviewer = TRUE;
									}

									if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y'){

										$cfty_allow_privileged_users_as_only_reviewer = TRUE;
									}

									$user_retire_flag = ' TRUE ';
									if($user_retire_status == TRUE)
										$user_retire_flag = ' FALSE ';


									$jwf_parent_user_roles_new = 'REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")';
									$jwf_who_can_invite_new = 'REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")';

									$select_shortlist_permission = $select_invite_permission = '';
																		
									$prevent_edit_cond = '(cusr_action_type!=\'more_review\' AND IF(JSON_SEARCH(jp_prevent_edit,\'all\','.$post_data['role_id'].') IS NOT NULL,IF(user_allocation_table.allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$this->current_user['user_id'].', allocate_curr_role_users),TRUE),FALSE))';
									$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
									$review_flow  = Config::get($workflow_config);
									$array_data['prevent_edit_todo'] = in_array(true,array_column($review_flow, 'prevent_edit'),true);
									$select_pe = "";
									
									//journal admin/staff can only get all task condition
									if($post_data['core_role'] == 'journal_admin' || ($post_data['core_role'] == 'staff' && $my_list == FALSE && $user_retire_status == FALSE))
									{
										$art_status_cnd = ' AND IF(art_status IN (\'n\',\'c\'), jwf_stage_type = \'resubmission\',art_status !=\'c\') ';

										$count_condition .= ' aflw_status IN (\'u\',\'i\',\'a\',\'w\',\'p\')  '.$art_status_cnd.' AND  FIND_array_intersect('.$post_data['role_id'].',user_artp_roles) = 1 AND (IF(a1.aflw_status = \'w\',aflw_more_review_skip_status =\'n\' AND aflw_skip_review =\'n\' AND (a1.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'u\',\'i\',\'a\',\'c\')) OR a1.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'i\',\'a\',\'c\')) ),TRUE)) AND IF(a1.aflw_status = \'p\',aflw_skip_review =\'n\' AND a1.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'a\',\'c\')),TRUE) AND  IF(aflw_status = \'u\',jwf_stage_type != \'review\',TRUE)';

										$count_condition .=' AND (jwf_stage_type != \'author_submission\') ';

										$role_condition = NULL;

										if ($cfty_manage_privilaged_user_as_reviewer == TRUE|| $cfty_allow_privileged_users_as_only_reviewer == TRUE)
										{
											$role_condition = $post_data['role_id'];
										}			
									}
									else
									{
										$shotlist_cnd = ' (FIND_array_intersect('.$post_data['role_id'].','.$jwf_parent_user_roles_new.') = 1 AND  a1.aflw_stage_min_users > (SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'u\',\'i\',\'a\',\'c\') )) ';

										$most_shortlist_cond = '( SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'u\') ) > 0 ';
										$invite_cnd = ' ( '.$most_shortlist_cond.' AND FIND_array_intersect('.$post_data['role_id'].','.$jwf_who_can_invite_new.') = 1 AND a1.aflw_stage_min_users > ( SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'i\',\'a\',\'c\') )) ';

										$art_user_allocation_cnd = ' IF(allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$this->current_user['user_id'].',allocate_curr_role_users) = 1, '.$user_retire_flag.' AND FIND_array_intersect('.$post_data['role_id'].',user_artp_roles) = 1) ';
										$select_shortlist_permission = ',IF(aflw_status IN (\'w\',\'p\')  AND FIND_array_intersect('.$post_data['role_id'].','.$jwf_parent_user_roles_new.') = 1 AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS shortlist_permission';

										$select_invite_permission = ',IF(aflw_status = \'w\' AND FIND_array_intersect('.$post_data['role_id'].','.$jwf_who_can_invite_new.') = 1 AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS invite_permission';


										 $assignment_cnd = ' IF(a1.aflw_status = \'w\', '.$art_user_allocation_cnd.' AND ('.$shotlist_cnd.' OR '.$invite_cnd.' ) AND aflw_more_review_skip_status =\'n\' AND  aflw_skip_review =\'n\',FALSE) ';

										// $assignment_cnd = ' IF(a1.aflw_status = \'w\', '.$art_user_allocation_cnd.' AND ('.$invite_cnd.' ) AND aflw_more_review_skip_status =\'n\' AND  aflw_skip_review =\'n\',FALSE) ';

										$assignment_p_cnd = ' IF(a1.aflw_status = \'p\', FIND_array_intersect('.$post_data['role_id'].','.$jwf_parent_user_roles_new.') = 1 AND '.$art_user_allocation_cnd.'  AND aflw_skip_review =\'n\' AND a1.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'a\',\'c\')),FALSE) ';

										$already_started = ' ( aflw_status = \'a\' AND aflw_usr_id = '.$this->current_user['user_id'].' ) ';
										$for_checkout = ' ( aflw_status = \'u\' AND '.$art_user_allocation_cnd.' )';
										$assign_checkout_cnd = ' ( jwf_role_id= '.$post_data['role_id'].'  AND ( '.$already_started.' OR '.$for_checkout.')) ';

										$count_condition .= ' (aflw_status IN (\'u\',\'a\',\'w\',\'p\') AND art_status NOT IN (\'t\',\'n\',\'c\') AND jwf_stage_type NOT IN (\'author_submission\',\'transit\',\'authors_declaration\',\'revision\',\'decision_resubmit\',\'resubmission\',\'copyright\',\'payment\')  AND FIND_array_intersect('.$post_data['role_id'].',user_artp_roles) = 1 AND  ('.$assignment_cnd.' OR '.$assignment_p_cnd.' OR '.$assign_checkout_cnd.') OR ('.$prevent_edit_cond.'))';
										//\'staff_check\',\'pre_assessment\',\'post_assessment\',\'accept\',\'reject\',\'decision_revision\',\'license_check\',\'production\',\'review\'
										$role_condition = $post_data['role_id'];

									}
									if($role_condition!=null && in_array(true,array_column($review_flow, 'prevent_edit'),true)){
										$select_pe = ',IF('.$prevent_edit_cond.',cusr_id,"") AS cusr_id,IF('.$prevent_edit_cond.',cusr_action_type,"") AS cusr_action_type,IF('.$prevent_edit_cond.',cusr_status,"") AS cusr_status';
									}
									if(isset($post_condition)&&$post_condition!=NULL)
									$count_condition .= $post_condition;

									$blinded_articles = $this->get_blinded_articles($this->current_user['user_id']);
									if(!empty($blinded_articles))
									{
										$count_condition .= ' AND art_id NOT IN ('.$blinded_articles.') ';
									}
									

									$select = 'artp_palette_color_code,artp_fwm_id,DATE_FORMAT(art_epub_date,"' . $date_format . '") AS rv_art_epub_date,IF(art_epub_date IS NOT NULL and art_epub_date< now(),1,0) as art_epub_date_flag,artp_jpm_id,artp_special_issue,artp_article_type,artp_abbr_article_type,art_id,art_code,art_status,art_delete_status,art_title,art_artp_id,art_submitted_by,DATE_FORMAT(art_submission_date, "' . $date_format .' %H:%i") as art_submission_date_format,art_stub,aflw_id,aflw_due_date as due_date,DATEDIFF(aflw_due_date ,NOW()) AS rvd_remaining_days,aflw_art_id as reviewed_article,art_publication_issue,iss_soft_end_date,iss_hard_end_date,auth_corr_author_list,atotp_review_method,atotp_custom_blind_params'.$select_shortlist_permission.$select_invite_permission.$select_pe;
								// $order_by = str_replace('ORDER BY', '', $order_by);
								//  $order_by = NULL;
									//$count_condition .= $next_task_condtion;
									$array_data['user_id']=$this->current_user['user_id'];
									$array_data['jnl_id']=$post_data['jnl_id'];
									$array_data['select']=$select;
									$array_data['return_count']=FALSE;
									$array_data['condition']=$count_condition;
									$array_data['cfty_manage_privilaged_user_as_reviewer']=$cfty_manage_privilaged_user_as_reviewer;
									$array_data['limit']=NULL;
									$array_data['start']=NULL;
									$array_data['group_by']='art_id';
									$array_data['order_by']=$order_by;
									$array_data['assignment']=FALSE;
									$array_data['role_id']=$role_condition;
									$array_data['art_flow_alias']=TRUE;
									$array_data['cfty_allow_privileged_users_as_only_reviewer']=$cfty_allow_privileged_users_as_only_reviewer;
									$array_data['clnt_client_code'] =$this->current_client->clnt_client_code;
									$array_data['issue_tb_connect'] = TRUE;
									$array_data['movenext'] = isset($post_data['movenext'])?$post_data['movenext']:FALSE;
									$array_data['page'] = isset($post_data['page'])?$post_data['page']:'';

									//DB::enableQueryLog();
									$article_list['head'] = Articles::base_function_to_get_article_details($array_data);
									//$query = DB::getQueryLog();$query = end($query);dd($query);
									if(count($article_list['head']) > 0)
									{
										$art_id_arr = array();
										foreach($article_list['head'] as $item)
										{
											$art_id_arr[] = $item->art_id;
										}

										$article_list['format_head_stage']=$this->format_head_article($article_list['head'],$post_data['jnl_id'],$post_data['jnl_code'],$post_data['role_id']);
										//dd($article_list['format_head_stage']);
										$article_list_stages = $this->get_article_stages($art_id_arr,$user_retire_status,$date_format,$post_data['core_role'],$post_data['role_id'],$this->current_user['user_id'],$post_data['jnl_id'],$post_data['jnl_code'],$post_data);

										$article_list['stages'] = $article_list_stages['art_stages'];
										$article_list['global_es_data'] = $article_list_stages['es_data_global_arr'];

										$data_arr = array(
											'jnl_id'=> $post_data['jnl_id'],
											'role_id' => $post_data['role_id'],
											'type' => 'd',
											'art_list' =>$article_list_stages['art_list'],
											'filter_list' => $post_data
										);
										$this->write_user_article_list($data_arr);

									}


								}

							}

						}
					}
					return  $this->success('Success',200,$article_list);
				}
				else
				{
					return $this->warning('Failed',422,customTrans('auth.invalid_data'));
				}
            }
        }
        catch (\Exception $e){

            return  $this->failure('Failed',500,$e);
        }

    }

    public function todo_article_list_non_priv_users($roleid,$core_role,$segment,$journal_id,$form_post,$journal_code,$journal_dateformat,$current_user)
	{
		if(isset($segment)&&$segment!='')
		$segment=5;

		$article_list = array();
        $return_array=array();
		if($roleid != '')
		{
            //Customization #2472 --Need to implement "temporary status name" in every article listing section for non-privileged user
			$select = 'artp_article_type,artp_fwm_id,artp_abbr_article_type,artp_special_issue,artp_palette_color_code,atotp_review_method,atotp_custom_blind_params,art_id,art_artp_id,art_code,art_title,art_status,art_delete_status,art_stub,art_submitted_by,art_prev_article_id,art_decision_date,jwf_role_id,jwf_status_name,jwf_stage_name,jwf_temporary_status_name,jwf_stage_type,aflw_id,aflw_usr_id,aflw_status,aflw_accepted_date,aflw_due_date,aflw_assigned_date,aflw_due_date,aflw_returned_date,aflw_operation,rvd_remaining_days,artp_soft_enddate,artp_hard_enddate,art_publication_issue,iss_soft_end_date,iss_hard_end_date,artp_jpm_id,aflw_posted_by,aflw_remarks,art_es_document_status,art_es_document_type';

			$user_id = $current_user['user_id'];
            $order_by = NULL;

			$condition = 'jnl_id = '.$journal_id.$form_post['conditions'];

			$blinded_articles = $this->get_blinded_articles($user_id);
			if(!empty($blinded_articles))
			{
				$condition .= ' AND art_id NOT IN ('.$blinded_articles.') ';
			}

        if(isset($form_post['condition_stage'])&&$form_post['condition_stage'] != '')
        $condition .= ' AND jwf_status_name ' . $form_post['condition_stage'];//.$condition;
		$condition .= " ORDER BY ".$form_post['condition_order_by'];
			/*if($form_post['condition_stage'] != '')
				$form_post['conditions'] = ' jwf_status_name ' . $form_post['condition_stage'];*/
				$type = 'todo';
				$my_task=TRUE;

				//DB::enableQueryLog();
                $return_array['article_list'] = Article_types::get_article_data_non_privilege($select,$roleid,$user_id,$journal_id,FALSE,$condition,NULL, NULL,$core_role,$journal_dateformat,$order_by);
				//$query = DB::getQueryLog();
				//$query = end($query);
				//print_r($query);exit;

                $article_list_stages =$this->arrange_article_stages($return_array['article_list'],$journal_code,$journal_id,$core_role,$type,$my_task,$roleid);
				$return_array['stage_list'] = $article_list_stages['art_stages'];
				$return_array['es_data_global_arr'] = $article_list_stages['es_data_global_arr'];
            }

		return $return_array;
	}


    public function get_article_stages($art_ids,$user_retire_status,$date_format,$core_role,$roleid,$user_id,$jnl_id,$jnl_code,$post_data)
    {
        // $form_data = $this->input->post();
		// $form_post = $this->input->post('search');
		// $post_art = $this->input->post('art', TRUE);
		$form_post = $post_data['filter'];
		$stage_name = '';
		$article_role='';
		if (isset($form_post['stage_name']) && $form_post['stage_name'] != '')
		{
			$stage_name = $form_post['stage_name'];
		}

		$my_task = TRUE;
		if (isset($form_post['my_list']) && $form_post['my_list'] == "0") {
			$form_post['my_task'] = $form_post['my_list'];
			$my_task = $form_post['my_list'];
		}

        if($core_role == 'journal_admin')
		{
			$only_jnl_admin = TRUE;
			$my_task = FALSE;
		}
		$return_arr = array(
			'status' => 'failed'
		);

		// if ($post_art == '')
		// 	return $post_art;

		if (isset($form_data['sort_order']) && $form_data['sort_order'] != '')
			$form_post['sort_order'] = $form_data['sort_order'];

		//1791 ICE todo and other article listing section bug
		$parallel_workflow = FALSE;



		$article_stages_result = array();
		//NEW SECTION TO AVOID LOAD -- *****START****
		if(count($art_ids) > 0)
		{

            $post_condition = '';
			$art_list_temp = $art_ids;
			$type = 'todo';
			$fn_type = 'd';
            $article_flow_table = (new \App\Models\Article_flow())->getTable();

			//Task #596 Create EIDO configuration and build workflow
			if($this->current_client->modules->mdl_review_for_doc == 'y')
			{
			    $select = 'art_artp_id,art_status,art_delete_status,aflw_id,aflw_parent_flow_id,aflw_art_id as art_id,aflw_jwf_id,aflw_remarks,aflw_stage_min_users,aflw_stage_max_users,aflw_status,aflw_due_date,aflw_posted_by,aflw_operation,aflw_usr_id,aflw_invite_due_date,jwf_stage_name,jwf_stage_type,jwf_status_name,jwf_temporary_status_name,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as per_shotlist_roles,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as per_invite_roles,jwf_role_id,aflw_assigned_date,art_publication_issue,iss_soft_end_date,iss_hard_end_date,artp_jpm_id,art_submitted_by';

				$select .= ' ,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE a1.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status IN(\'u\',\'i\',\'a\',\'c\')),NULL) as short_listed,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE a1.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status = \'u\'),NULL) as invite_pending,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(base_tbtwo.aflw_id) FROM '.$article_flow_table.' base_tbtwo WHERE a1.aflw_id = base_tbtwo.aflw_parent_flow_id AND base_tbtwo.aflw_status IN(\'i\',\'a\',\'c\')),NULL) as invited_list';

				$select .= ',DATE_FORMAT(a1.aflw_assigned_date, "' . $date_format .' %H:%i") as aflw_assigned_date';
				$select .= ',DATE_FORMAT(a1.aflw_accepted_date, "' . $date_format .' %H:%i") as aflw_accepted_date';
				$select .= ',DATE_FORMAT(a1.aflw_returned_date, "' . $date_format .' %H:%i") as aflw_returned_date';
				$select .= ',DATE_FORMAT(a1.aflw_due_date,"' . $date_format . ' %H:%i") AS due_date';
				$select .= ',DATE_FORMAT(a1.aflw_invite_due_date,"' . $date_format . ' %H:%i") AS invite_due_date';
				$select .= ',DATE_FORMAT(a1.aflw_due_date,"' . $date_format . ' %H:%i") AS rvd_aflw_due_date';

				$select .= ',DATEDIFF(aflw_due_date ,NOW()) AS rvd_remaining_days';
				$select .= ',DATEDIFF(aflw_invite_due_date ,NOW()) AS rvd_remaining_days_invite_due';
				$select .= ' ,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE a1.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status IN(\'u\',\'i\',\'a\',\'c\')),NULL) as shot_listed,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(base_tbtwo.aflw_id) FROM '.$article_flow_table.' base_tbtwo WHERE a1.aflw_id = base_tbtwo.aflw_parent_flow_id AND base_tbtwo.aflw_status IN(\'i\',\'a\',\'c\')),NULL) as invited_list';

				//FOR SELF CONDITION
				$shortlist_cnd = '';
				$invite_cnd = '';
				$user_having_role = '';
				$user_current_role = ' TRUE ';
				$true_flag = ' TRUE ';
				if($core_role != 'journal_admin' && $my_task == TRUE)
				{
					$shortlist_cnd = ' FIND_IN_SET('.$roleid.',REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")) > 0 AND ';
					$invite_cnd = ' FIND_IN_SET('.$roleid.',REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")) > 0 AND';

					$user_having_role = ' FIND_IN_SET('.$roleid.',user_artp_roles) > 0  AND';
					$user_current_role = ' jwf_role_id = '.$roleid;

					$true_flag = ' aflw_usr_id = '.$user_id.' AND  jwf_role_id = '.$roleid;
				}

				$shortlist = $shortlist_cnd.' (select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = a1.aflw_id AND tb1.aflw_status IN (\'u\',\'i\',\'c\') ) < a1.aflw_stage_min_users';

				$invite = $invite_cnd.' (select count(aflw_id) FROM '.$article_flow_table.' as tb1 WHERE tb1.aflw_parent_flow_id = a1.aflw_id AND tb1.aflw_status IN (\'i\',\'c\') ) < a1.aflw_stage_min_users';

				$review_assignment = ' AND IF('.$shortlist.',TRUE,'.$invite.' )';


				$condition =  $user_having_role.'  CASE ';

				if($my_task == TRUE)
				{
					$condition .= ' WHEN  art_status = \'n\' AND aflw_status = \'a\' AND jwf_stage_type = \'author_submission\' THEN  '.$true_flag; //for submission in progress stage
				}

				$condition .= '  WHEN  art_status = \'y\' AND aflw_status = \'w\' '.$review_assignment.' THEN TRUE '; //for priviledged user's assigment

				$condition .= ' WHEN art_status = \'y\' AND aflw_status IN (\'a\',\'i\' ) THEN  '.$true_flag; //for accepted / invited users

				$condition .= ' WHEN art_status = \'y\' AND aflw_status = \'u\' AND jwf_stage_type != \'review\' THEN  '.$user_current_role; //for ready stages

				$condition .= ' END ';

				$condition .= ' AND a1.aflw_art_id IN ('. implode(',',$art_ids ).')';

				$article_stages = Articles::base_function_to_get_document_details($user_id,$jnl_id,$select,FALSE,$condition,NULL, NULL, array('art_id','aflw_id'), '',TRUE,TRUE);
                $article_stages_result = $this->arrange_article_stages($article_stages,$jnl_code,$jnl_id,$core_role,$fn_type,$my_task,$roleid);
				//echo '<pre>';print($article_stages_result);die;
			}
			else
			{
				$user_retire_flag = ' TRUE ';
				if($user_retire_status == TRUE)
					$user_retire_flag = ' FALSE ';

				$select_shortlist_permission = $select_invite_permission = '';

				$jwf_parent_user_roles_new = 'REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")';
				$jwf_who_can_invite_new = 'REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")';

				if($my_task == TRUE)
				{
					$art_user_allocation_cnd = ' IF(allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$user_id.',allocate_curr_role_users) = 1, '.$user_retire_flag.' AND FIND_array_intersect('.$roleid.',user_artp_roles) = 1) ';

					$select_shortlist_permission = ',IF(aflw_status IN (\'w\',\'p\') AND FIND_array_intersect('.$roleid.','.$jwf_parent_user_roles_new.') = 1 AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS shortlist_permission';

					$select_invite_permission = ',IF(aflw_status = \'w\' AND FIND_array_intersect('.$roleid.','.$jwf_who_can_invite_new.') = 1 AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS invite_permission';
				}

				$select = 'art_artp_id,artp_fwm_id,jp_edit_articles,artp_jpm_id,art_status,art_delete_status,art_submitted_by,aflw_id,aflw_parent_flow_id,aflw_art_id as art_id,aflw_jwf_id,aflw_usr_id,aflw_remarks,aflw_stage_min_users,aflw_stage_max_users,aflw_status,aflw_due_date,aflw_invite_due_date,aflw_posted_by,aflw_operation,aflw_usr_id,jwf_stage_name,jwf_status_name,jwf_temporary_status_name,jwf_stage_type,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as per_shotlist_roles,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as jwf_parent_user_roles_new,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as per_invite_roles,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as jwf_who_can_invite_new,jwf_role_id,art_publication_issue,iss_soft_end_date,iss_hard_end_date'.$select_shortlist_permission.$select_invite_permission;

				$p_condition = 'FIND_array_intersect('.$roleid.','.$jwf_parent_user_roles_new.')=1';

				$p_sub_condition = ' aflw_skip_review =\'n\' AND base_tb.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = base_tb.aflw_id and inn_tb.aflw_status IN (\'a\',\'c\',\'h\'))';

				//if($core_role == 'journal_admin')

				$cond_shortlist_permission = ' AND FIND_array_intersect('.$roleid.','.$jwf_parent_user_roles_new.') = 1  ';
				$cond_invite_permission = ' AND FIND_array_intersect('.$roleid.','.$jwf_who_can_invite_new.') = 1 ';

				if($my_task == FALSE)
				{
					$p_condition = $p_sub_condition;
					$cond_shortlist_permission = $cond_invite_permission = '';
				}
				else
					$p_condition .= ' AND '.$p_sub_condition;

                if($post_condition != '')
                    $post_condition .= ' AND ';

				$shortlist = ' base_tb.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = base_tb.aflw_id and inn_tb.aflw_status IN (\'u\',\'i\',\'a\',\'c\')) '.$cond_shortlist_permission;

				$invite = ' base_tb.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = base_tb.aflw_id and inn_tb.aflw_status IN (\'i\',\'a\',\'c\')) '.$cond_invite_permission;

				$condition_w = '( '.$shortlist.' OR '.$invite.' )';

				/*
				$todo_condition = $post_condition.'  IF(aflw_status = \'u\',aflw_parent_flow_id IS NULL,TRUE)  AND (IF(base_tb.aflw_status = \'w\',aflw_more_review_skip_status =\'n\' AND aflw_skip_review =\'n\' AND (base_tb.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = base_tb.aflw_id and inn_tb.aflw_status IN (\'u\',\'i\',\'a\',\'c\')) OR base_tb.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = base_tb.aflw_id and inn_tb.aflw_status IN (\'i\',\'a\',\'c\')) ),IF(base_tb.aflw_status = \'p\','.$p_condition.',TRUE))) ';
				*/
							
				if($my_task == TRUE)
				{
					$article_role = ' AND jwf_role_id = '.$roleid;
				}
				$todo_condition = $post_condition.'  IF(aflw_status = \'u\',aflw_parent_flow_id IS NULL'.$article_role.' ,TRUE)  AND (IF(base_tb.aflw_status = \'w\',aflw_more_review_skip_status =\'n\' AND aflw_skip_review =\'n\' AND '.$condition_w.',IF(base_tb.aflw_status = \'p\','.$p_condition.',TRUE))) ';

				if($my_task == FALSE)
				{
					$type = 'todo_all_task';
					//$todo_condition .= ' AND IF(art_status IN (\'y\',\'a\',\'t\'),TRUE,TRUE) ';
				}
				else
				{
					$todo_condition .= ' AND IF(aflw_status IN (\'i\',\'a\'),aflw_usr_id = '.$user_id.',TRUE) ';
				}
				//Task #6000 Starts
				$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
				$review_flow  = Config::get($workflow_config);
				$preventEdit= in_array(true,array_column($review_flow, 'prevent_edit'),true);
				//Task #6000 Ends

				$parallel_workflow = TRUE;
				if(isset($this->current_client->functionality->cfty_parallel_workflow_active) && $this->current_client->functionality->cfty_parallel_workflow_active == 'y' && $my_task == TRUE)
				{
					//$parallel_workflow = TRUE;
					/*
					$case_cond = ' jwf_role_id = '.$roleid.' AND CASE WHEN user_allocation_table.allocate_curr_role_users != NULL THEN FIND_IN_SET('.$user_id.',user_allocation_table.allocate_curr_role_users) > 0  WHEN FIND_IN_SET('.$roleid.',article_type_table.user_artp_roles) > 0 THEN TRUE END';
					$todo_condition .= ' AND IF(jwf_assignment = \'self_service\','.$case_cond.',TRUE)';
					*/
					$case_cond = '  AND CASE WHEN user_allocation_table.allocate_curr_role_users != NULL THEN FIND_IN_SET('.$user_id.',user_allocation_table.allocate_curr_role_users) > 0  WHEN FIND_IN_SET('.$roleid.',article_type_table.user_artp_roles) > 0 THEN TRUE END ';

					$self_condition = ' jwf_role_id ='.$roleid.' AND IF(aflw_status IN (\'i\',\'a\'),aflw_usr_id = '.$user_id.',aflw_status = \'u\') ';
					//$todo_condition .= ' AND IF(jwf_assignment = \'self_service\','.$self_condition.',TRUE) '.$case_cond;

					$todo_condition .= ' AND IF(aflw_status IN (\'u\',\'i\',\'a\'),'.$self_condition.',TRUE) '.$case_cond;
				}

				//$order_by = ' art_id';

				$order_by = ' FIELD(art_id,'. implode(',',$art_ids ).') ASC ';
				//DB::enableQueryLog();
				$article_stages = Article_flow::get_article_review_selection($art_ids,$select,$date_format,$type,$todo_condition,NULL,FALSE,array(),$parallel_workflow,$jnl_id,$user_id,$roleid,$order_by,$preventEdit);
				//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
				$type='';
				//dd($article_stages);
                $article_stages_result = $this->arrange_article_stages($article_stages,$jnl_code,$jnl_id,$core_role,$fn_type,$my_task,$roleid);

            }

		}

		//NEW SECTION TO AVOID LOAD -- *****STOP****
		return $article_stages_result;
	}



    public function leftmenu(Request $request)
    {
       try
       {

            $post_data=$request->all();
			$validator = Validator::make($request->all(), [
                'platform_code' => 'required',
                'user_id' => 'required',
            ]);

            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            else
            {
				$platform_code=Rv_decrypt($post_data['platform_code']);
				$current_user = $this->get_current_user_details();
				$user_id=Rv_decrypt($post_data['user_id']);


				$input_arr = array(
					'input' =>$user_id,
					'type'=> 'number'
				);
				$user_id_validate = $this->Rv_validator($input_arr);
				$input_arr = array(
					'input' =>$platform_code,
					'type'=> 'string'
				);
				$platform_code_validate = $this->Rv_validator($input_arr);
				if($user_id_validate != TRUE || $platform_code_validate != TRUE){
					return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
				}
            $return_array['rolelist']='';
            $return_array['menu_links']='';
			if($this->current_client->modules->mdl_es_integration == 'y')
			{
				$es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
				$es_api_data  = Config::get($es_config);
				$return_array['es_url'] = $es_api_data['rvriteurl'];
			}
            if(isset($post_data['platform_code'])&&isset($post_data['user_id'])&&$post_data['platform_code']!=''&&$post_data['user_id']!='')
            {
			$condition=array("jnl_journal_code"=>$platform_code);
           // $condition="jnl_journal_code='{$platform_code}'";
            $jnl_data=Journals::get_single_record_with_bind_cond('*',$condition);

            $user_roles = $this->validate_user_journal($platform_code, $user_id);

            $active_default_role=$this->set_dashboard_default_role_active($user_roles,$jnl_data->jnl_id, $user_id);


            if(isset($post_data['active_role'])&&$post_data['active_role']!='')
            {
            $active_role_id=$post_data['active_role'];
            $login_user_current_active_role=$this->login_as_user($user_roles,$jnl_data->jnl_id, $user_id,$active_role_id);
            }
            else
            {
            $active_role_id=isset($active_default_role['role_id']) ? $active_default_role['role_id'] : '';
            }

            $main_role_array=array();
            if(isset($user_roles['role_id_name_list'])&&!empty($user_roles['role_id_name_list']))
            {
                foreach($user_roles['role_id_name_list'] as $key=>$rolelist)
                {
                    $role_array['role_id']=$key;
                    $role_array['role_name']=$rolelist['role_name'];
                    $role_array['assigned_role']=$rolelist['assigned_role'];

                    $main_role_array[]=$role_array;
                }

            }
			$user_permission_roles =Journal_settings::get_single_record('jset_proxy_login', "jset_jnl_id={$jnl_data->jnl_id}");
			$result= (isset($user_roles['role_id']) && (isset($user_permission_roles->jset_proxy_login))) ? array_intersect(json_decode($user_permission_roles->jset_proxy_login),$user_roles['role_id']):[];
			$proxy_avail_roles =  array_map('intval', explode(',', $user_permission_roles->jset_proxy_login));

			if($current_user['proxy_user_id'] != 0)
			{
				$proxy_status = true;
			}
			else
			{
				/* Start -> TASK #8105 Retire roles able to proxy as a another user 
				$proxy_status = (count($result) > 0) ? true : false;
				*/
				$proxy_status = $this->check_user_proxy_access($user_id,$jnl_data->jnl_id,null);
				/* End -> TASK #8105 Retire roles able to proxy as a another user */
			}

            $return_array['rolelist']=$main_role_array;
            $return_array['menu_links']=$this->left_menu_links($jnl_data,$user_id,$active_role_id);
			$return_array['empty_menu'] =FALSE;
			if(empty($return_array['menu_links']))
			{
			$return_array['empty_menu'] =TRUE;
			}
            if(isset($login_user_current_active_role)&&!empty($login_user_current_active_role))
            $return_array['active_default_role']=$login_user_current_active_role;
            else
            $return_array['active_default_role']=$active_default_role;
            $return_array['proxy_status']=$proxy_status;
            /* $return_array['proxy_avails']=$proxy_avail_roles; */
			$return_array['batch_decision_assignment']=FALSE;
			$return_array['batch_assignment']=FALSE;

			if (isset($return_array['menu_links'])&&is_array($return_array['menu_links'])&&in_array('batch_assignment',$return_array['menu_links']))
            {
				$return_array['batch_assignment']=TRUE;
            }
			if (isset($return_array['menu_links'])&&is_array($return_array['menu_links'])&&in_array('batch_decision_assignment',$return_array['menu_links']))
            {
				$return_array['batch_decision_assignment']=TRUE;
            }
            return  $this->success('Success',200,$return_array);
           }
           else
           {
            return  $this->success('Failed',200,$return_array);
           }
		}
        }
        catch (\Exception $e){
            return  $this->failure('Failed',500,$e);
        }

    }

    public function left_menu_links($jnl_data,$user_id,$active_role_id)
    {

        $menu_links = array();


		$any_trans_started = FALSE;
		//$privileged_user = $this->has_journal_privilege();
		$user_roles = $this->validate_user_journal($jnl_data->jnl_journal_code, $user_id);

        $this->current_user['usr_jnl_standalone']=NULL;
                //#684 Stop submission for a journal - fetch jnl_article_submission_status from journal
                $can_submit_article_in_this_journal     =   'y';


                if((isset($this->current_client->functionality->cfty_enable_stop_submission_in_journal) && $this->current_client->functionality->cfty_enable_stop_submission_in_journal == "y") && isset($jrnl_data->jnl_article_submission_status))
                {
                    $can_submit_article_in_this_journal = $jrnl_data->jnl_article_submission_status;
                }

		if (isset($user_roles['status']) &&$user_roles['status'] == TRUE && isset($user_roles['role_id_name_list']))
		{
            $condition="role_id={$active_role_id}";
            $roledata=Roles::get_single_record('role_id,role_name,role_assigned_role',$condition);
			/*$temp_role = $this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code];
			$this->jnl_data->active_tab_id = $active_role_id = $temp_role['role_id'];
			$user_role = $temp_role['core_role'];*/
            $active_role_id = $roledata->role_id;
            $user_role=$roledata->role_assigned_role;
			//$set_default_role =isset($temp_role['set_default_role'])?$temp_role['set_default_role']:'';
			$user_permission_roles =Journal_settings::get_single_record('jset_draft_proposal_invite,jset_add_user_note,jset_add_user_attachemnts,jset_user_flags,jset_change_user_status,jset_email_permission,jset_create_article_stub,jset_manage_issue,jset_add_article_to_issue,jset_manage_article_type,jset_manage_article,jset_edit_user_details,jset_bulk_invite_submission,jset_batch_decision,jset_batch_reviews', "jset_jnl_id={$jnl_data->jnl_id}");
			$this->data['all_article_types'] = array();
			$this->data['adhoc_art_type']=array();

		//	$this->data['set_default_role'] = $set_default_role;
			$role_retire_flag = FALSE;
			if(isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y')
			{
				$role_retire_flag = $this->get_user_role_retire($active_role_id,$user_id,$jnl_data->jnl_id);
			}
			/*Task #870 taskboat join as author button management in no adhoc submission */
            $article_type=$this->get_adhoc_submission_type_data($jnl_data->jnl_id);
			/* Task #870 End */
                        //BUG#2217 for EIDO, staff can submit even if article submission in a journal is stopped
			$aipp=$this->check_client_proceeding();			
			if($this->current_client->modules->mdl_review_for_doc == 'y' && in_array('staff', $user_roles['assigned_roles']) === TRUE && $user_role == 'staff' && $can_submit_article_in_this_journal == 'y')
			{
				$menu_links[] = 'author';
			}
           /* elseif (($this->current_user['usr_jnl_standalone'] != NULL && $this->current_user['usr_jnl_standalone'] == $this->jnl_data->jnl_id ) || ( $this->current_user['usr_jnl_standalone'] == NULL && $this->jnl_data->jnl_standalone == 'n'))
			{
              */                  //BUG#2217 $privileged_user check is removed from old confition, cos "join as author" was not showing for reviewers dashboard
                elseif (in_array('author', $user_roles['assigned_roles']) === FALSE  && $this->current_client->modules->mdl_review_for_doc == 'n' && $can_submit_article_in_this_journal == 'y' &&$article_type->cnt>0 && $aipp===false)
				{
					$menu_links[] = 'new_author';
				}

			/*}
            */

            if($user_role == 'journal_admin')
				$menu_links[] = 'journal_admin';

			$user_note = $user_attach = $user_change = $user_flags = $user_edit_det = array();
			$email_permission = $create_article_stub = $manage_article = $manage_issue_users = $manage_article_type = array();
			if (isset($this->current_client->functionality->cfty_manage_article_type) && $this->current_client->functionality->cfty_manage_article_type == 'y')
				{
					if($user_permission_roles->jset_manage_article_type != NULL)
							$manage_article_type= json_decode($user_permission_roles->jset_manage_article_type);
					if(in_array($active_role_id, $manage_article_type))
					{
							$menu_links[] = 'manage_article_type';
					}
				}
			else if(!isset($this->current_client->functionality->cfty_manage_article_type) || (isset($this->current_client->functionality->cfty_manage_article_type) && $this->current_client->functionality->cfty_manage_article_type == 'n'))
			{
				if($user_role == 'journal_admin')
				$menu_links[] = 'manage_article_type';
			}
			if (isset($user_permission_roles) && $role_retire_flag == FALSE)
			{
				if($user_permission_roles->jset_add_user_note != NULL)
					$user_note = json_decode($user_permission_roles->jset_add_user_note);

				if($user_permission_roles->jset_add_user_attachemnts != NULL)
					$user_attach = json_decode($user_permission_roles->jset_add_user_attachemnts);

				if($user_permission_roles->jset_change_user_status != NULL)
					$user_change = json_decode($user_permission_roles->jset_change_user_status);

				if($user_permission_roles->jset_user_flags != NULL)
					$user_flags = json_decode($user_permission_roles->jset_user_flags);

				if($user_permission_roles->jset_edit_user_details != NULL)
					$user_edit_det = json_decode($user_permission_roles->jset_edit_user_details);

				if(in_array($active_role_id, $user_note) == TRUE || in_array($active_role_id, $user_attach) == TRUE || in_array($active_role_id, $user_change) == TRUE || in_array($active_role_id, $user_flags) == TRUE || in_array($active_role_id, $user_edit_det) == TRUE)
				{
					$menu_links[] = "manage_users";
				}

				if($user_permission_roles->jset_email_permission != NULL)
					$email_permission = json_decode($user_permission_roles->jset_email_permission);

				if(in_array($active_role_id, $email_permission))
				{
					$menu_links[] = 'manage_journal_emails';
				}

				// Check to show staff links
				if($user_permission_roles->jset_create_article_stub != NULL)
					$create_article_stub = json_decode($user_permission_roles->jset_create_article_stub);

				if(in_array($active_role_id, $create_article_stub))
				{
                                    $this->data['can_submit_article_in_this_journal']   =   $can_submit_article_in_this_journal;
                                    //---start----#660 if bulk submission is enabled, show the link in the sidebar
                                    $this->data['enable_bulk_submission']   =   false;
                                    if(isset($this->current_client->functionality->cfty_enable_bulk_invite_submission) && $this->current_client->functionality->cfty_enable_bulk_invite_submission=='y')
                                    {
                                        //get the user roles permissions to invite bulk submission
                                        if($user_permission_roles->jset_bulk_invite_submission != '') {
                                            $bulk_inv_sub_per_roles         =   $user_permission_roles->jset_bulk_invite_submission;

                                            if(in_array($active_role_id, json_decode($bulk_inv_sub_per_roles))) {
                                                $this->data['enable_bulk_submission']   =   true;
                                            }
                                        }
                                    }
                                    //----end----
                                    // $menu_links[] = 'staff';
				}

				// Task#385-Issue Management
                                if(isset($this->current_client->functionality->cfty_manage_issues) && ($this->current_client->functionality->cfty_manage_issues == 'y'))
                                {
                                    if($user_permission_roles->jset_manage_issue != NULL)
                                            $manage_issue_users= json_decode($user_permission_roles->jset_manage_issue);
                                    if(in_array($active_role_id, $manage_issue_users))
                                    {
                                            $menu_links[] = 'manage_issues';
                                    }
                                }
				if($user_permission_roles->jset_draft_proposal_invite != NULL)
				{
					$manage_draft = json_decode($user_permission_roles->jset_draft_proposal_invite);
					if(in_array($active_role_id, $manage_draft))
					{
						$menu_links[] = 'invite_proposal';
					}
				}
				//set user delete permission
				if (isset($this->current_client->functionality->cfty_enable_article_delete) && $this->current_client->functionality->cfty_enable_article_delete == 'y' || isset($this->current_client->functionality->cfty_enable_article_withdraw) && $this->current_client->functionality->cfty_enable_article_withdraw == 'y' )
				{
					if($user_permission_roles->jset_manage_article != NULL)
						$manage_article = json_decode($user_permission_roles->jset_manage_article);

					if(in_array($active_role_id, $manage_article))
					{
						// if($this->current_client->modules->mdl_production == 'y')
						// 	$menu_links[] = 'sheet_view';
						// else
							$menu_links[] = 'manage_articles';

						if($this->current_client->functionality->cfty_enable_article_delete == 'y')
						{
							$menu_links[] = 'deleted_articles';
						}
					}

				}
			}
		}

		$submit_production_article_enable= $this->check_submit_article_production($user_role);

		if (isset($submit_production_article_enable)&&$submit_production_article_enable==TRUE)
		{
			$menu_links[] = 'article_production_submission';
		}
		$batch_assign_permitted_roles= array('staff','journal_admin','editor_in_chief');
        if(isset($this->current_client->modules->mdl_conference)&&$this->current_client->modules->mdl_conference == 'y')
         {
			$manage_batch_decision 	=	$manage_batch_reviews	=	array();
			if($user_permission_roles->jset_batch_decision != NULL)
				$manage_batch_decision= json_decode($user_permission_roles->jset_batch_decision);
			if($user_permission_roles->jset_batch_reviews != NULL)
				$manage_batch_reviews= json_decode($user_permission_roles->jset_batch_reviews);

			if(in_array($active_role_id, $manage_batch_decision))
			{
					$menu_links[] = 'batch_decision_assignment';
			}

			if(in_array($active_role_id, $manage_batch_reviews))
			{
					$menu_links[] = 'batch_assignment';
			}

			// $role_used = $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
			
			// if(in_array($user_role, $role_used))
			// {
            // $menu_links[] = 'batch_assignment';
			// }
		 }
		return $menu_links;
    }



    public function login_as_user($user_role,$platform_id, $user_id,$current_active_role)
    {

        $where ="role_id={$current_active_role}";
		$review_roles = Roles::get_single_record('role_id,role_name,role_assigned_role', $where);
                /*
		  $role_name = $review_roles->role_name;
		  $core_role = $review_roles->role_assigned_role;
		  $roleid = $review_roles->role_id;
		 */
		$user_role = array(
			'role_id' => $review_roles->role_id,
			'role_name' => $review_roles->role_name,
			'core_role' => $review_roles->role_assigned_role,
		);

		$set_default_role = '';
        $condition="usrj_usr_id={$user_id} AND usrj_jnl_id={$platform_id} AND usrj_enable_default_role='y' AND usrj_artp_id IS NULL";

		$default_dash = User_to_journals::get_single_record('usrj_role_id',$condition);
		if(!empty($default_dash))
		$set_default_role = $default_dash->usrj_role_id;

		$user_role['set_default_role'] = $set_default_role;

        return $user_role;
    }

    public function allarticletypes(Request $request)
    {
           try
           {
               $post_data=$request->all();
			   $validator = Validator::make($request->all(), [
                'platform_code' => 'required',
                'user_id' => 'required',
                'type' => 'required',

               // 'my_list' => 'required',
              //  'jset_date_format' => 'required'
            ]);

            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
			$jnlcode_validate = $this->Rv_validator(array('input' => $post_data['platform_code'],'type'=> 'string'));
			if($jnlcode_validate == false)
	        {
             $arraymsg['mesage'] = customTrans('viewarticle.invalid_jnl_code');
            return $this->warning("Failed",200,$arraymsg);
            }
			$current_user = $this->get_current_user_details();
               //$platform_id=$post_data['platform_id'];
               $platform_code=$post_data['platform_code'];
               $platform_data=$this->platform_basic_settings_data($platform_code);
              if(empty($platform_data))
			  {
				return  $this->failure('Failed',422,customTrans('viewarticle.invalid_jnl_code'));
			  }
			  	// TASK #6949 Starts
				$jounal_data = Journals::get_single_record_with_bind_cond('jnl_id,jnl_fwm_id',array("jnl_journal_code"=>$platform_code));
				$proper_flow = $this->validate_journal($jounal_data->jnl_fwm_id, $jounal_data->jnl_id);
				if($proper_flow['status'] == false) {
					$return_arr['status'] = 'invalid_jnl';
					$return_arr['msg'] = isset($proper_flow['err_msg'][0])?$proper_flow['err_msg'][0]:customTrans('viewarticle.invalid_journal');
					return $return_arr;
					//return $this->success("Failed",200, $return_arr);
				}
				// TASK #6949 Ends
               $user_id=$current_user['user_id'];
               $type=$post_data['type'];
               $platform_id=$platform_data->jnl_id;
               $date_format=$platform_data->jset_date_format;
                $additional_criteria = NULL;
               $msg='';
			   $today = date('Y-m-d');

                if ($type != 'adhoc')
                { // list out all article types who have role
                    $condition=array('jset_jnl_id'=>$platform_id);
                    $user_permission_roles =Journal_settings::get_all_records_with_bind_cond('jset_add_user_note,jset_add_user_attachemnts,jset_user_flags,jset_change_user_status,jset_email_permission,jset_create_article_stub',$condition);

                    $user_roles = $this->validate_user_journal($platform_code,$user_id);

                    if(empty($user_roles['role_id']))
					{
					$msg = customTrans('viewarticle.unauthorized');
					return  $this->success('Success',200,$msg);
					}
                    if (isset($user_permission_roles->jset_create_article_stub) && $user_permission_roles->jset_create_article_stub != NULL && !empty($user_roles['role_id'])&&count(array_intersect($user_roles['role_id'], json_decode($user_permission_roles->jset_create_article_stub))))
                    {
                        $role_id = implode(",", $user_roles['role_id']);



                    $additional_criteria[] = '(artp_id IN (SELECT usrj_artp_id FROM rvw_user_journals WHERE usrj_usr_id = ' . $user_id . ' and usrj_jnl_id = ' . $platform_id . ' AND usrj_role_id IN (' . $role_id . ') AND usrj_artp_id IS NOT NULL))';
					}
                    /* $additional_criteria[] = '(artp_id IN (SELECT usrj_artp_id FROM rvw_user_journals WHERE usrj_usr_id = '.$this->current_user['user_id'].' and usrj_jnl_id = '.$this->jnl_data->jnl_id.' AND usrj_role_id = '.$role_id.' AND usrj_artp_id IS NOT NULL))'; */
                }
                     if (isset($this->current_client->functionality->cfty_enable_stop_submission_in_article_type) && $this->current_client->functionality->cfty_enable_stop_submission_in_article_type == 'y')
                     {
                                $additional_criteria[] = 'artp_article_submission_status = \'y\'';
                    }
                    $date_format= date_format_map($date_format);
                    $all_article_types =Article_types::get_all_artp_with_parent_article_type($platform_id, $date_format, $type, $user_id, $additional_criteria);


				    $articletype_row_data = [];
					$soft_end_date = "";
                if (count($all_article_types) > 0)
                {
                    $i = 0;
                   // print_r($all_article_types);exit;
                    foreach ($all_article_types as $article_type)
                    {
                        //print_r($article_type);exit;
                       $fwm_id = $article_type->artp_fwm_id;
					   $softdate_valid=0;
					   $softdate_today=0;

					   if($article_type->artp_special_issue=='y' || $this->current_client->modules->mdl_conference == 'y')
					   {
						   $soft_end_date = $article_type->artp_soft_enddate;
						   if(!empty($soft_end_date))
						   {
							if(strtotime($soft_end_date) == strtotime($today))
							{
								$softdate_today=1;
							}
						   }
						   $softdate_valid= $article_type->softdate_valid;
					   }
                        if($this->current_client->modules->mdl_review_for_doc =='n')
                        {
                            $proper_flow = $this->validate_journal($fwm_id, $article_type->artp_id, 'a');

                            if ($proper_flow['status'] == FALSE)
                            {
                                continue;
                            }
                        }
                       $i++;
                        $article_type->type = $type;
						$article_type->softdate_valid_date = $softdate_valid;
						$article_type->softdate_today = $softdate_today;
                     //   $article_type->jnl_journal_code = $this->journal_code;
                        $articletype_row_data[]= $article_type;

                    }
                   // print_r($articletype_row_data);exit;
                    if ($i == 0)
                    $msg = customTrans('viewarticle.article_type_not_available');
                }
                else
                {
                    /*
                     * In the case of invitaion showing empty modal window
                     */
                    $msg = customTrans('viewarticle.article_type_not_available');
                }
                $condition="role_assigned_role='author'";
                $author_role_id =Roles::get_single_record('role_id', $condition);
                $return_arr['status'] = 'success';
                $return_arr['msg'] = $msg;
               //$return_arr['author_role_id'] = encrypt_link($author_role_id->role_id);
				$return_arr['soft_today'] = $today;
				$return_arr['soft_en_date'] = $soft_end_date;
                $return_arr['articletype_list'] = $articletype_row_data;
                $return_arr['article_submission_type'] = $type;
				// $articletype_row_data_count = count($articletype_row_data);
				$return_arr['articletype_list_count'] = count($articletype_row_data);
				$return_arr['articletype_code'] = isset($articletype_row_data[0]->artp_abbr_article_type)?$articletype_row_data[0]->artp_abbr_article_type:"";
				$return_arr['platform_code'] = $platform_code;
				$return_arr['url'] = url('/api/platform/' . $platform_code . '/articlesubmission');
				return $return_arr;
           	}
           catch (\Exception $e){

            return  $this->failure('Failed',500,$e);
        }

    }
	public function get_active_default_roles(Request $request)
	{
		try
		{
		$post_data=$request->all();
		$validator = Validator::make($request->all(), [
		 'platform_code' => 'required',
		// 'my_list' => 'required',
	   //  'jset_date_format' => 'required'
	 ]);

	 if($validator->fails())
	 {
		 return  $this->failure('Failed',422,$validator->errors());
	 }
		if(isset($post_data['platform_code'])&&$post_data['platform_code']!='')
		{
		$platform_code=$post_data['platform_code'];
		$this->current_user = $this->get_current_user_details();

		$user_id=$this->current_user['user_id'];

		$condition="jnl_journal_code='{$platform_code}'";
		$jnl_data=Journals::get_single_record('*',$condition);
       if(!empty($jnl_data))
	   {
		$user_roles = $this->validate_user_journal($platform_code, $user_id);

		$active_default_role=array();
	  if(isset($user_roles)&&(!empty($user_roles )))
	  {
		$active_default_role=$this->set_dashboard_default_role_active($user_roles,$jnl_data->jnl_id, $user_id);
		$active_role_id=isset($active_default_role['role_id']) ? $active_default_role['role_id'] : '';
	  }

		$return_array['active_default_role']=$active_default_role;
		$return_array['platform_id']=$jnl_data->jnl_id;
		$return_array['platformexist']=TRUE;
	}
	else
	{
		$return_array['platformexist']=FALSE;
	}
		return  $this->success('Success',200,$return_array);
	   }
	}
	catch (\Exception $e){

		return  $this->failure('Failed',500,$e);
	}
}
public function get_platform_data(Request $request)
{
	try{
		$post_data = $request->all();
		$validator = Validator::make($request->all(), [
			'jnl_code' => 'required',
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$jnl_code = $post_data['jnl_code'];
			$platformdata=$this->platform_basic_settings_data($jnl_code);
		   if(!empty($platformdata))
		   {
			$array_date=platform_date_format();
			if(isset($platformdata->jset_date_format)&&$platformdata->jset_date_format!='')
			{
				$platformdata->jset_date_format=$array_date[$platformdata->jset_date_format];
			}
			else
			{
				$platformdata->jset_date_format=$array_date[$this->current_client->settings->cs_date_format];
			}
			$return_array['platformexist']=TRUE;
			$return_array['platform_data']=$platformdata;
		  }
		  else
		  {
			$return_array['platformexist']=FALSE;
		  }
			return  $this->success('Success',200,$return_array);
		}
	}
	catch (\Exception $e){
		return  $this->failure('Failed',500,$e);
	}

}
public function load_dashboad_data(Request $request)
{
try
{
	$post_data =$request->all();
	$this->current_user = $this->get_current_user_details();
	$validator = Validator::make($request->all(), [
	 'platform_code' => 'required',

 ]);
       if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		$platform_code = $post_data['platform_code'];
		if(isset($form_data['jnl_code'])){
			$input_arr = array(
				'input' =>$platform_code,
				'type'=> 'string'
			);
			$platform_code_validate = $this->Rv_validator($input_arr);
			if( $platform_code_validate != TRUE){
				return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
			}
		}
		$user_id=$this->current_user['user_id'];
		$platformdata=$this->platform_basic_settings_data($platform_code);
	   if(!empty($platformdata) && $platformdata->jnl_journal_status =='y')
	   {
		 $array_date=platform_date_format();
		if(isset($platformdata->jset_date_format)&&$platformdata->jset_date_format!='')
		{
			$platformdata->jset_date_format=$array_date[$platformdata->jset_date_format];

		}
		else
		{
			$platformdata->jset_date_format=$array_date[$this->current_client->settings->cs_date_format];
		}
		$user_roles = $this->validate_user_journal($platform_code, $user_id);

		$active_default_role=array();
		if(isset($user_roles)&&(!empty($user_roles )))
		{
		  if (isset($post_data['currole'])) {
		  	$active_default_role = $this->set_dashboard_default_role_active($user_roles, $platformdata->jnl_id, $user_id,Rv_decrypt($post_data['currole']));
		  } else {
		  	$active_default_role = $this->set_dashboard_default_role_active($user_roles, $platformdata->jnl_id, $user_id);
		  }
		  $active_role_id=isset($active_default_role['role_id']) ? $active_default_role['role_id'] : '';
		// $active_default_role=$this->set_dashboard_default_role_active($user_roles,$platformdata->jnl_id, $user_id);
	  }
	    $return_array['platformexist']=TRUE;
	    $return_array['platform_data']=$platformdata;
		$return_array['active_default_role']=$active_default_role;
		$return_array['platform_id']=$platformdata->jnl_id;

	  }
	  else
	  {
		$return_array['platformexist']=FALSE;
	  }
	  return  $this->success('Success',200,$return_array);
}
catch(\Exception $e)
{

	return  $this->failure('Failed',500,$e);
}
}


	public function add_user_to_journal(Request $request) {
		try
		{
         $post_data=$request->all();
		 $return_array=array();
		 $this->current_user=$this->get_current_user_details();
		 $validator = Validator::make($request->all(), [
			'platform_id' => 'required',
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		$platformarray = array('input'=>$post_data['platform_id'],'type'=>'number', 'enc_data'=>FALSE );
		$platformvalidation= $this->Rv_validator($platformarray);
		if($platformvalidation==false)
                {
                    $arraymsg['chatmesage'] = customTrans('auth.invalid_data');
                    return $this->warning("Failed",201,$arraymsg);
                }
	$journal = $post_data['platform_id'];

	$role= Roles::get_single_record('role_id',"role_assigned_role='author'");


	if (isset($journal) && $journal != '') {
		$data = array(
			'usrj_jnl_id' => $journal,
			'usrj_usr_id' => $this->current_user['user_id'],
			'usrj_role_id' => $role->role_id,
			'usrj_artp_id' =>NULL
		);
		$jnlidvalid = $this->validatecode(array('jnl_id'=>$post_data['platform_id']),false);
		if($jnlidvalid['jnl_id'] != TRUE ){
			$arraymsg['chatmesage']=customTrans('auth.invalid_data');
            return $this->warning("Failed",201,$arraymsg);
        }

       // $condition="usrj_jnl_id={$journal} AND usrj_usr_id={$this->current_user['user_id']} AND usrj_role_id={$role->role_id} AND usrj_artp_id = NULL ";
		//$check_journal = User_to_journals::get_single_record('usrj_id', $condition);
		$check_journal = User_to_journals::get_single_record_with_bind_cond('usrj_id',$data);
		if (empty($check_journal)) {
			//$data['usrj_status'] = 'a';
			User_to_journals::insert_record($data, $this->current_user);
			$dataarry = array(
				'role_id' => $role->role_id
			);
			$rolesdetails =Roles::get_single_record_with_bind_cond('role_id,role_name,role_assigned_role',$dataarry);
			$user_role = array(
				'role_id' => $role->role_id,
				'role_name' => $rolesdetails->role_name,
				'core_role' => $rolesdetails->role_assigned_role,
				'set_default_role'=>''
			);

			$return_array['roledata']=$user_role;
			return  $this->success('Success',201,$return_array);
		} else {
			$return_array['message']='You are already a user in this journal';
			return  $this->warning('warning',200,$return_array,'warning');
		}

	}
}
catch(\Exception $e)
{
	return  $this->failure('Failed',500,$e);
}
}
public function filter_data(Request $request)
{
	try
	{
	$return_array=array();
	$this->current_user=$this->get_current_user_details();
	 $validator = Validator::make($request->all(), [
		'jnl_code' => 'required',
		'jnl_id' => 'required',
		'core_role' => 'required',
		'role_id' => 'required',
	   // 'my_list' => 'required',
	  //  'jset_date_format' => 'required'
	]);

	if($validator->fails())
	{
		return  $this->failure('Failed',422,$validator->errors());
	}
	else
	{
	$post_data=$request->all();
	$Article_types=new \App\Models\Article_types();
	$User_to_journals=new \App\Models\User_to_journals();
	$Generic_flows=new \App\Models\Generic_flows();
	$journal_data['jnl_id']=$post_data['jnl_id'];
	$journal_data['jnl_code']=$post_data['jnl_code'];
	$journal_data['role_id']=$post_data['role_id'];
	if(isset($post_data['artp_type_id']) && !empty($post_data['artp_type_id']))
	{
		$article_type_id=$post_data['artp_type_id'];
		$return_array['article_type_set']=$Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$article_type_id}");
	}
	$core_role=$post_data['core_role'];
	$search_condition = $this->global_function_for_search_article('journal_dashboard', '', FALSE,array(),array(),$journal_data,array(),$post_data);

	$flt_roles = $User_to_journals::get_user_role_ids($journal_data['jnl_id'],$this->current_user['user_id'],$journal_data['role_id']);

	$filter_article_type = array();
	if(!empty($flt_roles))
	{
		$flt_user_roles =  $this->rebuild_array_by_field($flt_roles,'usrj_artp_id');
		$implode_role_data=implode(',',array_keys($flt_user_roles));

		$sql_stage="SELECT artp_id, artp_article_type, artp_abbr_article_type,artp_special_issue FROM rvw_article_types WHERE artp_status='y' AND artp_id IN({$implode_role_data})";
		//$filter_article_type = $Article_types->get_records_where_in('artp_id,artp_article_type,artp_abbr_article_type', 'artp_id', array_keys($flt_user_roles));

		$filter_article_type=$Article_types::get_records_by_raw_query($sql_stage);

	}
	$return_array['sort_key'] = NULL;
	$return_array['selectstatus']=1;
	$taskstatus=taskstatus();
	if ($search_condition != NULL) {
		$return_array['all_task_flag'] = FALSE;
		if($core_role == 'journal_admin' || $core_role == 'staff')
		{
			$return_array['all_task_flag'] = TRUE;
		}
		$return_array['previlegerole'] =TRUE;
		if($core_role == 'reviewer' || $core_role == 'author')
		{
			$return_array['previlegerole'] =FALSE;

		}
        if($core_role == 'journal_admin')
		{
			unset($taskstatus[1]);
			$return_array['selectstatus']=0;
		}
		else if($core_role == 'staff')
		{
			$return_array['selectstatus'];
		}
		else
		{
			unset($taskstatus[0]);
		}
		$return_array['privileged_user'] = $search_condition['art_privileged_user'];
		$return_array['only_author_role'] = $search_condition['only_author_role'];
		$return_array['only_jnl_admin'] = $search_condition['only_jnl_admin'];
		$return_array['filter_key'] = $search_condition['filter_key'];
		$return_array['sort_key'] = $search_condition['sort_key'];
		if (isset($search_condition['filter_key']->article_type)) {
			$db_label = ($return_array['privileged_user'] == TRUE) ? 'jwf_stage_name' : 'jwf_status_name';
			$article_status = $Generic_flows::get_article_type_stages($db_label, array(
				'artp_id' => $this->decrypt_data($search_condition['filter_key']->article_type)
					), $db_label);
			if (!empty($article_status))
			$return_array['article_status'] = array_column(json_decode(json_encode($article_status), True), $db_label);
		}
		$jnl_date_form = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$journal_data['jnl_id']}' ")->jset_date_format;
		$jnl_dateformat_array = $this->Utility('date_format');
		$array_date = $jnl_dateformat_array['date_format'];
		$article_list = array();
		$section = (isset($post_data['section']))?$this->decrypt_data($post_data['section']):"";
		if($section == 'overview')
		{
			$Roles = new \App\Models\Roles;
			$this->current_user = $this->get_current_user_details();
			$db_label = ($return_array['privileged_user'] == TRUE) ? 'jwf_stage_name' : 'jwf_status_name';
			$stg_name = array();
			if(isset($post_data['stg_name']) && $post_data['stg_name'] != '')
			{
				$stg_name[] = $post_data['stg_name'];
			}
			$user_roles = $this->validate_user_journal($post_data['jnl_code'], $this->current_user['user_id']);
			$core_role = $post_data['core_role'];
			$roleid = $post_data['role_id'];
			$user_retire_status = "";
			$type = (isset($post_data['filter_type']))?$this->decrypt_data($post_data['filter_type']):'';
			$overview_title = (isset($post_data['title']))?$this->decrypt_data($post_data['title']):'';
			$dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
			$dashboard_arr  = Config::get($dashboard_config);

			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
			$workflow_arr  = Config::get($workflow_config);

			// $dashboard_config = $dashboard_arr[$core_role];
			// $from_sect = 't';
			// $fn_section = $section;
			$tile_arr = array();
			$from_sect = 'o';
			$tile_arr['section_id'] = 'overview';
			$tile_arr['inner_list'] = TRUE;
			$tile_arr['stage_type'] = array();
			$tile_arr['type'] = $type;
			$tile_arr['title'] = $overview_title;
			$fn_section = $section;
			$tile_arr['fn_type'] = $from_sect;
			$tile_arr['fn_section'] = $fn_section;
			$article_list = $this->load_tile_details($post_data, FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
			$stage_article = $article_list['stages']['art_stages'];
			$data_stag = array();
			if($type == "review_selection" || $type == "reviewer_response" || $type == "reviewer_report" || $type == "checkout_articles")
			{
				$return_array['stages'] = $search_condition['journal_stages'];
			}
			else
			{
				foreach($stage_article as $value=>$v)
				{
					if (is_array($v)) {
						$data_stag = array_merge($data_stag, $v);
					} else {
						$data_stag[] = $v;
					}
				}
				$return_array['stages'] = $data_stag;
			}
		}
		else
		{
			$return_array['stages'] = $search_condition['journal_stages'];
		}

        $return_array['jnl_date_format'] = $array_date[$jnl_date_form];
		$return_array['filter_article_type']  = $filter_article_type;
		$return_array['taskstatus']=$taskstatus;
	}
	return  $this->success('Success',200,$return_array);
}
    }
catch(\Exception $e)
{
	return  $this->failure('Failed',500,$e);
}
}

public function get_artp_stages(Request $request)
{
try
{
	$post_data = $request->all();
	$this->current_user=$this->get_current_user_details();
	$validator = Validator::make($request->all(), [
		'jnl_code' => 'required',
		'jnl_id' => 'required',
		//'article_type_id' => 'required',
		'role_id'=>'required'

	]);

	if($validator->fails())
	{
		return  $this->failure('Failed',422,$validator->errors());
	}
	else
	{
		$article_type_id=$post_data['article_type_id'];
		$jnl_code=$post_data['jnl_code'];
	    $jnl_task = FALSE;
		$Article_types=new \App\Models\Article_types();
	if (isset($post_data['jnl_task']) && $post_data['jnl_task'] == "true")
		$jnl_task = TRUE;

	$label = 'Article status';
	$db_label = 'jwf_status_name';
	$privileged_user = FALSE;
	$control_name = 'status_name';
	$stage_type=array();
	$stg_name = array();
	if(isset($post_data['stg_name']) && $post_data['stg_name'] != '')
	{
		$stg_name[] = $post_data['stg_name'];
	}
	if ($article_type_id != '') {


		if (isset($jnl_code) && $jnl_code != '')
			$privileged_user = $this->has_journal_privilege($jnl_code, $this->current_user['user_id'], $article_type_id);

		if ($privileged_user == TRUE && $jnl_task == TRUE) {
			$label = 'Article stage';
			$db_label = 'jwf_stage_name';
			$control_name= 'stage_name';
		}

		if (isset($post_data['jnl_task'])) {

			$artp_id = $article_type_id;

			if(isset($post_data['stage_type'])&&$post_data['stage_type']!='')
			{
				if(is_array(json_decode($post_data['stage_type']))==1)
				{
					$stage_type=json_decode($post_data['stage_type']);
				}
				else
				{
					array_push($stage_type,$post_data['stage_type']);
				}

				if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y' && in_array('production', $stage_type))
				{
					$temp_arr = $this->get_production_stages_keys();
					$stage_type = array_merge($stage_type,$temp_arr);
				}
			//currently 'stage_for' for production stage is  review but the article from production to publish should list in the editor tile
				if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y' && in_array('production_only', $stage_type))
				{
					$stage_type[] = 'production';
				}
			}
			//$result = $this->Generic_flows->get_article_type_stages($db_label, $search_cond, $db_label,$stage_type);

			$result = $this->get_all_articletype_stages($db_label,$artp_id,$stage_type,$stg_name,$post_data);
			//print_r($result);
			$return_array['stages']=$result;
			//$return_array['stages'] = array_column(json_decode(json_encode($result), True), $db_label);
			$return_array['control_name'] = $control_name;
			$return_array['label'] = $label;
			$return_array['privileged_user'] = $privileged_user;
		}
	}
	else
	{
		$privileged_user = $this->has_journal_privilege($jnl_code,$this->current_user['user_id']);
		if(isset($post_data['stage_type']) && !empty($post_data['stage_type']))
			array_push($stage_type,$post_data['stage_type']);

		if($privileged_user == TRUE && $jnl_task == TRUE)
		{
			$label = 'Article stage';
			$db_label = 'jwf_stage_name';
			$control_name= 'stage_name';
		}

		$result = $this->get_all_articletype_stages($db_label,NULL,$stage_type,$stg_name,$post_data);
		$return_array['stages']=$result;
		//$return_array['stages'] = array_column(json_decode(json_encode($result), True), $db_label);
		$return_array['control_name'] = $control_name;
		$return_array['label'] = $label;
		$return_array['privileged_user'] = $privileged_user;
	}
	$return_array['article_type']=$Article_types::get_single_record('artp_id,artp_article_type', "artp_id={$article_type_id}");
	return  $this->success('Success',200,$return_array);
}
}
catch(\Exception $e)
{

	return  $this->failure('Failed',500,$e);
}
}
public function user_filter_save(Request $request)
{
	try{
		$post_data = $request->all();

		$validator = Validator::make($request->all(), [
			'jnl_code' => 'required',
			'jnl_id' => 'required',
			//'article_type_id' => 'required',
			'role_id'=>'required'

		]);

		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
		$jnl_id=$post_data['jnl_id'];
		$role_id=$post_data['role_id'];
		$jnl_code=$post_data['jnl_code'];
	//	$post_data['store_data']['section'] = $post_data['section'];
	//	$post_data['store_data']['type'] = $post_data['type'];
		$data_store=custom_json_encode($post_data['store_data']);
		$this->current_user=$this->get_current_user_details();
		$User_journal_filter_keys=new \App\Models\User_journal_filter_keys();
			$condition="ujfk_usr_id={$this->current_user['user_id']} AND ujfk_jnl_id={$jnl_id} AND ujfk_role_id={$role_id}";
			$result = $User_journal_filter_keys::get_single_record('count(ujfk_id) as cnt', $condition);

			if ($result->cnt > 0)
			{

					$update_arr = array(
						'ujfk_filter_keys' => json_encode($data_store));
					if (isset($role_id) && $role_id != '')
					{
						$update_arr['ujfk_role_id'] = $role_id;
					}
					$result = $User_journal_filter_keys::update_record($update_arr, $condition, $this->current_user);

			}
			else
			{


					$data['ujfk_role_id'] = $role_id;
					$data['ujfk_usr_id'] = $this->current_user['user_id'];
					$data['ujfk_jnl_id'] = $jnl_id;
					$data['ujfk_filter_keys'] = json_encode($data_store);
					$result = $User_journal_filter_keys::insert_record($data, $this->current_user);

			}
			return  $this->success('Success',201,$result);

		}
	}

	catch(\Exception $e)
{

	return  $this->failure('Failed',500,$e);
}
}

/**
 * this function used to save tile, overview filters
 */
public function user_filter_inner_tiles_save(Request $request)
{
	try
	{
		$validator = Validator::make($request->all(), [
			'jnl_code' => 'required',
			'jnl_id' => 'required',
			'role_id'=>'required'
		]);

		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$post_data = $request->all();
			//dd($post_data);
			$User_journal_dashboard_tile_filter_keys = new \App\Models\User_journal_dashboard_tile_filter_keys();
			$this->current_user=$this->get_current_user_details();

			$jnl_id=$post_data['jnl_id'];
			$role_id=$post_data['role_id'];
			$jnl_code=$post_data['jnl_code'];
			$section = decrypt_link($post_data['section']);

			$section_str =  $section;
			$type = '';
			if(isset($post_data['type']) && !empty($post_data['type']))//for overview
			{
				$type = decrypt_link($post_data['type']);
				$title_name = decrypt_link($post_data['title']);
				$section_str = $type . '#' . str_replace(' ','_',$title_name);
			}

			$data_arr = array(
                'ujdtfk_usr_id' => $this->current_user['user_id'],
                'ujdtfk_jnl_id' => $jnl_id,
                'ujdtfk_role_id' => $role_id,
			);

			$data_store=custom_json_encode($post_data['store_data']);

			$data = 'ujdtfk_usr_id ='.$this->current_user['user_id'].' AND ujdtfk_jnl_id = '.$jnl_id.' AND ujdtfk_role_id ='.$role_id;
			$filter_data = User_journal_dashboard_tile_filter_keys::get_single_record('ujdtfk_filter_keys,ujdtfk_id', $data);

			if(!empty($filter_data))
			{
				$db_filter_data = json_decode($filter_data->ujdtfk_filter_keys);

				$db_filter_data->$section_str = $data_store;
				$condition = 'ujdtfk_id = '.$filter_data->ujdtfk_id;
				$update_arr = array(
					'ujdtfk_filter_keys' => json_encode($db_filter_data)
				);

				$result = User_journal_dashboard_tile_filter_keys::update_record($update_arr, $condition, $this->current_user);
			}
			else
			{
				$filter_arr  = array(
					$section_str => $data_store
				);

				$data_arr['ujdtfk_filter_keys'] = json_encode($filter_arr);
				$result = User_journal_dashboard_tile_filter_keys::insert_record($data_arr, $this->current_user);
			}

			return  $this->success('Success',201,$result);
		}
	}
	catch(\Exception $e)
	{

		return  $this->failure('Failed',500,$e);
	}
}
public function get_filter_data(Request $request)
{
	try{
		$post_data = $request->all();
		$validator = Validator::make($request->all(), [
			'jnl_code' => 'required',
			'jnl_id' => 'required',
			//'article_type_id' => 'required',
			'role_id'=>'required'

		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$return_array['filterdata']='';
			$return_array['article_type']='';
			$jnl_id=$post_data['jnl_id'];
			$role_id=$post_data['role_id'];
			$jnl_code=$post_data['jnl_code'];
			$User_journal_filter_keys=new \App\Models\User_journal_filter_keys();
			$User_journal_sort_keys=new \App\Models\User_journal_sort_keys();
			$User_journal_dashboard_tile_sort_keys = new \App\Models\User_journal_dashboard_tile_sort_keys;
			$Article_types=new \App\Models\Article_types();
			$this->current_user=$this->get_current_user_details();

			$section = decrypt_link($post_data['section']);

			$artp_id = '';
			$jnl_date_form = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = ? ", binding_arr:[$jnl_id])->jset_date_format;
			$jnl_dateformat_array = $this->Utility('date_format');
			$array_date = $jnl_dateformat_array['date_format'];
			$return_array['jnl_date_format'] = $array_date[$jnl_date_form];
			if($section == 'todo')
			{
				$condition="ujfk_usr_id={$this->current_user['user_id']} AND ujfk_jnl_id=? AND ujfk_role_id=?";
				$result = $User_journal_filter_keys::get_single_record('ujfk_filter_keys', $condition, binding_arr:[$jnl_id, $role_id]);

				if(!empty($result))
				{
					$decode_data = json_decode($result->ujfk_filter_keys);
					$return_array['filterdata'] = $decode_data;
					if(isset($decode_data)&&($decode_data->article_type))
						$artp_id = $decode_data->article_type;
				}
			}
			else
			{
				$data = 'ujdtfk_usr_id ='.$this->current_user['user_id'].' AND ujdtfk_jnl_id = ? AND ujdtfk_role_id = ?';
				$result = User_journal_dashboard_tile_filter_keys::get_single_record('ujdtfk_filter_keys,ujdtfk_id', $data, binding_arr:[$jnl_id, $role_id]);
				if(!empty($result))
				{
					$section_str =  $section;
					if(isset($post_data['filter_type']) && !empty($post_data['filter_type']))//for overview
					{
						$type = decrypt_link($post_data['filter_type']);
						$title_name = decrypt_link($post_data['sec_title']);
						$section_str = $type . '#' . str_replace(' ','_',$title_name);
					}

					$decode_data=json_decode($result->ujdtfk_filter_keys);
					if(isset($decode_data->$section_str) )
					{
						$return_array['filterdata'] = $decode_data->$section_str;
						$artp_id = isset($decode_data->$section_str->article_type)?$decode_data->$section_str->article_type:"";
					}
				}
			}

			if(!empty($artp_id))
			{
				//echo $artp_id; die;
				//$return_array['article_type']=$Article_types::get_single_record('artp_article_type', "artp_id={$artp_id}");
				$condition = ['artp_id'=>$artp_id,'artp_status'=>'y'];
				$return_array['article_type']=$Article_types::get_single_record_with_bind_cond('artp_article_type',$condition); // Active Article Type Only

			}
		if($section == 'todo')
		{
			$condition="ujsk_usr_id={$this->current_user['user_id']} AND ujsk_jnl_id=?";
			$resultsort =$User_journal_sort_keys::get_single_record('ujsk_sort_keys', $condition, binding_arr:[$jnl_id]);
			if(!empty($resultsort))
			{
				$sortlist=(array)json_decode($resultsort->ujsk_sort_keys);
			}
		}
		else
		{
			$data = 'ujdtsk_usr_id ='.$this->current_user['user_id'].' AND ujdtsk_jnl_id = ?';
			$resultsort = User_journal_dashboard_tile_sort_keys::get_single_record('ujdtsk_sort_keys,ujdtsk_id', $data, binding_arr:[$jnl_id]);
			$section_str =  $section;
			if(isset($post_data['type']) && !empty($post_data['type']))//for overview
			{
				$type = decrypt_link($post_data['type']);
				$title_name = decrypt_link($post_data['title']);
				$section_str = $type . '#' . str_replace(' ','_',$title_name);
			}
			if(!empty($resultsort))
			{
				$sort_list_tile=(array)json_decode($resultsort->ujdtsk_sort_keys);
				if(isset($sort_list_tile[$section_str]) && !empty($sort_list_tile[$section_str]))
				{
					$sortlist = (array)json_decode($sort_list_tile[$section_str]);
				}
			}
		}
		$return_array['save_sort_list']='';
		$sortdata = [];
		if(!empty($resultsort))
		{
		if(isset($sortlist) && !empty($sortlist))
		{
		$sortdata['sort_type']=array_keys($sortlist)[0];
		$sortdata['sort_order']=$sortlist[array_keys($sortlist)[0]];
		}
		$return_array['save_sort_list']=$sortdata;
		}

			$return_array['progress_chart_perm']=false;
			$jnl_prog_chart_perm = Journal_settings::get_single_record('REPLACE(REPLACE(REPLACE(jset_view_work_progress_report,"]",""),"[",""),"\"","") AS jset_view_work_progress_report', "jset_jnl_id = ? ", binding_arr:[$jnl_id]);
			if(isset($jnl_prog_chart_perm->jset_view_work_progress_report) && $jnl_prog_chart_perm->jset_view_work_progress_report != NULL) {
				$work_progress_arr 	=	explode(",", $jnl_prog_chart_perm->jset_view_work_progress_report);
				if (in_array($role_id, $work_progress_arr)) {
					$return_array['progress_chart_perm']=true;
				} else {
					$return_array['progress_chart_perm']=false;
				}
			}
			return  $this->success('Success',200,$return_array);
		}

	}
	catch(\Exception $e)
	{

		return  $this->failure('Failed',500,$e);

	}
}
public function reset_filter(Request $request)
{
	try
	{
		$post_data = $request->all();
		$validator = Validator::make($request->all(), [
			'jnl_code' => 'required',
			'jnl_id' => 'required',
			'role_id'=>'required'

		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$section = decrypt_link($post_data['section']);
			$jnl_id=$post_data['jnl_id'];
			$role_id=$post_data['role_id'];

			$this->current_user=$this->get_current_user_details();
			$User_journal_filter_keys=new \App\Models\User_journal_filter_keys();

			if($section == 'todo')
			{
				$condition="ujfk_usr_id={$this->current_user['user_id']} AND ujfk_jnl_id={$jnl_id} AND ujfk_role_id={$role_id}";
				$result = $User_journal_filter_keys::delete_records($condition,'',$this->current_user);
			}
			else
			{
				$data = 'ujdtfk_usr_id ='.$this->current_user['user_id'].' AND ujdtfk_jnl_id = '.$jnl_id.' AND ujdtfk_role_id ='.$role_id;
				$result = User_journal_dashboard_tile_filter_keys::get_single_record('ujdtfk_filter_keys,ujdtfk_id', $data);
				if(!empty($result))
				{
					$section_str =  $section;
					if(isset($post_data['type']) && !empty($post_data['type']))//for overview
					{
						$type = decrypt_link($post_data['type']);
						$title_name = decrypt_link($post_data['title']);
						$section_str = $type . '#' . str_replace(' ','_',$title_name);
					}

					$decode_data=json_decode($result->ujdtfk_filter_keys);
					if(count((array)$decode_data)== 1)
					{
						$condition="ujdtfk_usr_id={$this->current_user['user_id']} AND ujdtfk_jnl_id={$jnl_id} AND ujdtfk_role_id={$role_id}";
						$result = User_journal_dashboard_tile_filter_keys::delete_records($condition,'',$this->current_user);
					}
					else
					{
						if(isset($decode_data->$section_str) )
						{
							unset($decode_data->$section_str);
							$condition = 'ujdtfk_id = '.$result->ujdtfk_id;

								$update_arr = array(
									'ujdtfk_filter_keys' => json_encode($decode_data)
								);
								$result = User_journal_dashboard_tile_filter_keys::update_record($update_arr, $condition, $this->current_user);

						}
					}
				}
			}
			return  $this->success('Success',201,$result);
		}
	}
	catch(\Exception $e)
	{
		return  $this->failure('Failed',500,$e);
	}

}
public function get_sort_list(Request $request)
{
	try
	{
		$post_data = $request->all();
		$User_journal_sort_keys=new \App\Models\User_journal_sort_keys();

		$confMod 	=	'';
		if($this->current_client->modules->mdl_conference == 'y')
			$confMod 	=	'_conference';
		$default_sort_order = 'clients.' . $this->current_client->clnt_client_code . '.default_sort_order.default_sort_order_list'.$confMod;
        $default_sort_order_list = sort_items();
		$validator = Validator::make($request->all(), [
			'jnl_id' => 'required',

		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$this->current_user=$this->get_current_user_details();
			$jnl_id=$post_data['jnl_id'];
			$section = (isset($post_data['section']))?$this->decrypt_data($post_data['section']):"";
			$type = (isset($post_data['type']))?$this->decrypt_data($post_data['type']):'';
			$overview_title = (isset($post_data['title']))?$this->decrypt_data($post_data['title']):'';
		$ordering_list=isset($post_data['ordering_lst']) ? $post_data['ordering_lst'] : array();
		$Dragged=isset($post_data['isDragged']) ? $post_data['isDragged'] : FALSE;

		if($section == 'todo')
		{
			$condition="ujsk_usr_id={$this->current_user['user_id']} AND ujsk_jnl_id={$jnl_id}";
			$result =$User_journal_sort_keys::get_single_record('ujsk_sort_keys', $condition);
			if(!empty($result))
			{
				$sortlist=(array)json_decode($result->ujsk_sort_keys);
			}
		}
		else
		{
			$data = 'ujdtsk_usr_id ='.$this->current_user['user_id'].' AND ujdtsk_jnl_id = '.$jnl_id;
			$result = User_journal_dashboard_tile_sort_keys::get_single_record('ujdtsk_sort_keys,ujdtsk_id', $data);
			$section_str =  $section;
			if(isset($post_data['type']) && !empty($post_data['type']))//for overview
			{
				$type = decrypt_link($post_data['type']);
				$title_name = decrypt_link($post_data['title']);
				$section_str = $type . '#' . str_replace(' ','_',$title_name);
			}
			if(!empty($result))
			{
				$sort_list_tile=(array)json_decode($result->ujdtsk_sort_keys);
				if(isset($sort_list_tile[$section_str]) && !empty($sort_list_tile[$section_str]))
				{
					$sortlist = (array)json_decode($sort_list_tile[$section_str]);
				}
			}
		}
		$sort_ord_val = '';
		$sortdata = [];

		$itemSort 	=	'article_sort';
		if($this->current_client->modules->mdl_conference == 'y')
			$itemSort 	=	'abstract_sort';

		if (!empty($default_sort_order_list))
		{
			$default_sort_article = $default_sort_order_list[$itemSort];
			$sort_values = array();
			foreach ($default_sort_article as $k => $val)
			{
				$s=array('key' => $k,'val'=>$val);
				array_push($sort_values,json_encode($s));
			}

			$default_sort_user = $default_sort_order_list['user_sort'];
			$sort_user = array();
			foreach ($default_sort_user as $ky => $valu)
			{
				$s=array('key' => $ky,'val'=>$valu);
				array_push($sort_user,json_encode($s));
			}
		}
		$return_array['sort_ord']='';
		if(isset($sortlist) && !empty($sortlist))
		{
			if (isset($this->current_client->functionality->cfty_show_minimised_sort)&&($this->current_client->functionality->cfty_show_minimised_sort == 'y'))
			{
				$sortdata['sort_type']=array_keys($sortlist)[0];
				$sortdata['sort_order']=$sortlist[array_keys($sortlist)[0]];
			}
			else
			{
				foreach($sortlist as $sort_order_val )
				{
					$sort_ord_val = $sort_order_val;
				}
				$sort_data['sort_type']=array_keys($sortlist);
				$srt_values = array();
				foreach ($sort_data['sort_type'] as $type => $type_ky)
				{
					if (!empty($default_sort_order_list))
					{
						$default_sort_article = $default_sort_order_list[$itemSort];
						foreach ($default_sort_article as $sort_val => $sort_ky)
						{
							if($sort_ky == $type_ky)
							{
								$s=array('key' => $sort_val,'val'=>$sort_ky);
								array_push($srt_values,json_encode($s));
							}
						}
					}
				}
				$sortdata = $srt_values;
			}
		}
		$return_array['sort_order_val']=$sort_ord_val;
		$return_array['save_sort_list']=$sortdata;
		if(isset($Dragged) && $Dragged == TRUE  && $ordering_list != [] )
		{
			$return_array['sort_listordering']= $ordering_list;
			// $return_array['sort_listorder_user'] = $ordering_list;
		}
		else
		{
			$return_array['sort_listordering']   = $sort_values;
			$return_array['sort_listorder_user'] = $sort_user;
		}
		$return_array['sort_list_item']=$this->get_default_sort_order(FALSE,TRUE);
		return  $this->success('Success',200,$return_array);
		}
	}
	catch(\Exception $e)
	{

		return  $this->failure('Failed',500,$e);
	}

}
public function  user_sort_save(Request $request)
{
	try
	{
	$post_data =$request->all();

	$User_journal_sort_keys=new \App\Models\User_journal_sort_keys();
	$validator = Validator::make($request->all(), [
		'jnl_id' => 'required',

	]);
	if($validator->fails())
	{
		return  $this->failure('Failed',422,$validator->errors());
	}
	else
	{
	if ($post_data != NULL)
	{
		$sortdata=$post_data['store_data'];
		if(isset($sortdata['sort_type'])&&$sortdata['sort_type']!=''&&isset($sortdata['order'])&&($sortdata['order']!=''))
		{
			if (isset($this->current_client->functionality->cfty_show_minimised_sort)&&($this->current_client->functionality->cfty_show_minimised_sort == 'y'))
            {
                $sortarray[$sortdata['sort_type']]=$sortdata['order'];
				$sortjsondata=json_encode($sortarray);
            }
			else
			{
				$string_version = '{"';
				$string_version .= implode('":"'.$sortdata['order'].'","', $sortdata['sort_type']);
				$string_version .= '":"'.$sortdata['order'];
				$string_version .= '"}';
				$sortjsondata=$string_version;
			}
		$jnl_id=$post_data['jnl_id'];
		$this->current_user=$this->get_current_user_details();

				       $condition="ujsk_usr_id={$this->current_user['user_id']} AND ujsk_jnl_id={$jnl_id}";
						$result =$User_journal_sort_keys::get_single_record('count(ujsk_id) as cnt', $condition);
						if ($result->cnt > 0)
						{
										$result = $User_journal_sort_keys::update_record(array(
												'ujsk_sort_keys' => $sortjsondata), $condition, $this->current_user);
						}
						else
						{
							$data = array(
								'ujsk_usr_id' => $this->current_user['user_id'],
								'ujsk_jnl_id' => $jnl_id,
								'ujsk_sort_keys'=>$sortjsondata
							);

								$result =$User_journal_sort_keys::insert_record($data, $this->current_user);
						}
					}
		if ($result)
			$return_array['status'] = "success";
			return  $this->success('Success',201,$return_array);
				}
	}
}

	  catch(\Exception $e)
	  {

		  return  $this->failure('Failed',500,$e);
	  }
}
public function reset_sort(Request $request)
{
	try
	{
		$post_data = $request->all();
		$User_journal_sort_keys=new \App\Models\User_journal_sort_keys();
		$validator = Validator::make($request->all(), [
			'jnl_code' => 'required',
			'jnl_id' => 'required',


		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$this->current_user=$this->get_current_user_details();

			$jnl_id=$post_data['jnl_id'];
			$section = decrypt_link($post_data['section']);
			if($section == 'todo')
			{
			$condition="ujsk_usr_id={$this->current_user['user_id']} AND ujsk_jnl_id={$jnl_id}";
			$result = $User_journal_sort_keys::delete_records($condition,'',$this->current_user);
			}
			else
			{
				$data = 'ujdtsk_usr_id ='.$this->current_user['user_id'].' AND ujdtsk_jnl_id = '.$jnl_id;
				$result = User_journal_dashboard_tile_sort_keys::get_single_record('ujdtsk_sort_keys,ujdtsk_id', $data);
				if(!empty($result))
				{
					$section_str =  $section;
					if(isset($post_data['type']) && !empty($post_data['type']))//for overview
					{
						$type = decrypt_link($post_data['type']);
						$title_name = decrypt_link($post_data['title']);
						$section_str = $type . '#' . str_replace(' ','_',$title_name);
					}

					$decode_data=json_decode($result->ujdtsk_sort_keys);
					if(count((array)$decode_data)== 1)
					{
						$condition="ujdtsk_usr_id={$this->current_user['user_id']} AND ujdtsk_jnl_id={$jnl_id} ";
						$result = User_journal_dashboard_tile_sort_keys::delete_records($condition,'',$this->current_user);
					}
					else
					{
						if(isset($decode_data->$section_str) )
						{
							unset($decode_data->$section_str);
							$condition = 'ujdtsk_id = '.$result->ujdtsk_id;

								$update_arr = array(
									'ujdtsk_sort_keys' => json_encode($decode_data)
								);
								$result = User_journal_dashboard_tile_sort_keys::update_record($update_arr, $condition, $this->current_user);

						}
					}
				}
			}
			return  $this->success('Success',201,$result);
		}
	}
	catch(\Exception $e)
	{

		return  $this->failure('Failed',500,$e);
	}

}

public function default_dashboard(Request $request){

	try
	{
		$post_data =$request->all();
		$User_to_journals=new \App\Models\User_to_journals();
		$Roles=new \App\Models\Roles();
		$validator = Validator::make($request->all(), [
			'type' => 'required',
		    'jnl_id'=>'required',
			'role_id'=>'required'
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$this->current_user=$this->get_current_user_details();
			$usr_id=$this->current_user['user_id'];
			$role_id=$post_data['role_id'];
			$jnl_id=$post_data['jnl_id'];
			$type=$post_data['type'];
			$result=array();
			$user_role =array();
			$review_roles =$Roles::get_single_record('role_id,role_name,role_assigned_role',"role_id={$role_id}");

	if(!empty($type))
	{

		$condition="usrj_usr_id={$usr_id} AND usrj_jnl_id={$jnl_id} AND usrj_artp_id IS NULL";
		$update_all =$User_to_journals::update_record(array('usrj_enable_default_role'=>'n'),$condition,$this->current_user);
		if($type == 'y')
		{
			$condition .=" AND usrj_role_id={$role_id}";
			$update_all =$User_to_journals::update_record(array('usrj_enable_default_role'=>$type),$condition,$this->current_user);

		}
		if(isset($update_all) && $update_all>0)
		{
			$user_role = array(
			'role_id' => $role_id,
			'role_name' => $review_roles->role_name,
			'core_role' => $review_roles->role_assigned_role,
			);
			if($type == 'y')
			{
				//$result['msg'] = $this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name'].' '.lang('default_role_add');
			//	$result['role_id'] = $role_id;
				$user_role['set_default_role'] = $role_id;

			}
			else
			{
				//$result['msg'] = lang('default_role_remove');
			//	$user_role['set_default_role'] = '';
			}
			//$this->set_user_session_with_dashboard_role($user_role);
			$result['status'] = 'success';
		}
	}
	else
	{
		$user_role = array(
			'role_id' => $role_id,
			'role_name' => $review_roles->role_name,
			'core_role' => $review_roles->role_assigned_role,
			);
		$result['status'] = 'success';
	}

	$result['roledata']=$user_role;

			return  $this->success('Success',201,$result);
		}
	}
	catch(\Exception $e)
	{

		return  $this->failure('Failed',500,$e);
	}

}

public function load_tileArticlelist(Request $request)
{
	try{
		$validator = Validator::make($request->all(),[
			'jnl_id' => 'required',
			'jnl_code' => 'required',
			'role_id' => 'required',
			'core_role' => 'required',
			'section' => 'required'
		]);

		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$post_data = $request->all();

			$input_arr = array(
				'input' => $post_data['jnl_id'],
				'type'=> 'number'
			);
			$jnl_id_validate = $this->Rv_validator($input_arr);

			$input_arr['input']= $post_data['role_id'];
			$role_id_validate = $this->Rv_validator($input_arr);

			$input_arr = array(
				'input' => $post_data['jnl_code'],
			);
			$jnl_code_validate = $this->Rv_validator($input_arr);

			$input_arr['input']= $post_data['core_role'];
			$core_role_validate = $this->Rv_validator($input_arr);

			$input_arr['input']= $post_data['section'];
			$input_arr['enc_data']= TRUE;
			$section_validate = $this->Rv_validator($input_arr);

			$input_arr['input']= $post_data['title'];
			$input_arr['enc_data']= TRUE;
			$title_validate = $this->Rv_validator($input_arr);

			if(isset($post_data['sort_order']) && !is_array($post_data['sort_order']))
			{
				$input_arr['input']= $post_data['sort_order'];
				$input_arr['required']= FALSE;
				$input_arr['enc_data']= FALSE;
				$sort_order_validate = $this->Rv_validator($input_arr);
			}
			else
			{
				$sort_order_validate = TRUE;
			}

			$form_post=isset($post_data['filter']) ? $post_data['filter'] : array();
			$filter_validate = $this->filter_validator($form_post);


			if($jnl_id_validate == TRUE && $role_id_validate == TRUE && $jnl_code_validate == TRUE && $core_role_validate == TRUE &&  $section_validate == TRUE && $title_validate == TRUE && $sort_order_validate == TRUE && $filter_validate == TRUE)
			{
				$section = $this->decrypt_data($post_data['section']);
				$core_role = $post_data['core_role'];
				$roleid = $post_data['role_id'];
				$type = (isset($post_data['type']))?$this->decrypt_data($post_data['type']):''; //for overview
				$overview_title = (isset($post_data['title']))?$this->decrypt_data($post_data['title']):'';

				$this->current_user = $this->get_current_user_details();
				$user_roles = $this->validate_user_journal($post_data['jnl_code'], $this->current_user['user_id']);

				$user_retire_status = $this->get_user_role_retire($roleid,$this->current_user['user_id'],$post_data['jnl_id']);

				$dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
				$dashboard_arr  = Config::get($dashboard_config);

				$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
				$workflow_arr  = Config::get($workflow_config);

				$dashboard_config = $dashboard_arr[$core_role];

				$article_list = array(
					'head' => array(),
					'stages'=>array()
				);

				//d-todo
				//t-tilie
				//s-search
				//o-overview
				$from_sect = 't';
				$fn_section = $section;

				$tile_arr = array();
				if($section == 'overview')
				{
					$from_sect = 'o';
					$tile_arr['section_id'] = 'overview';
					$tile_arr['inner_list'] = TRUE;
					$tile_arr['stage_type'] = array();
					$tile_arr['type'] = $type;
					$tile_arr['title'] = $overview_title;
					$fn_section = $type;
				}
				else
				{
					$tile_arr['section_id'] = '';
					foreach($dashboard_config['Tiles'] as $key => $value)
					{
						if($value['section_id'] == $section)
						{
							$tile_arr = $value;
							break;
						}
					}
				}
				$tile_arr['fn_type'] = $from_sect;
				$tile_arr['fn_section'] = $fn_section;

				$article_list = $this->load_tile_details($post_data, FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);

				if(isset($article_list['stages']))
				{
					$data_arr = array(
						'jnl_id'=> $post_data['jnl_id'],
						'overview_type'=>$type,
						'role_id' => $post_data['role_id'],
						'type' => $from_sect,
						'art_list' =>$article_list['stages']['art_list'],
						'filter_list' => $post_data
					);
					$this->write_user_article_list($data_arr);
					$article_list['global_es_data'] = $article_list['stages']['es_data_global_arr'];
					$article_list['stages'] = $article_list['stages']['art_stages'];
				}
				return  $this->success('Success',200,$article_list);
				//dd($article_list);
			}
			else
			{
				return $this->warning('Failed',422,customTrans('auth.invalid_data'));
			}
		}
	} catch (\Exception $e)
	{

		return  $this->failure('Failed',500,$e);
	}


}

public function load_due_date_change(Request $request)
{
	try
	{
         $post_data=$request->all();
		 $validator = Validator::make($request->all(), [
			'art_flow_id' => 'required',
		    'jnl_id'=>'required',
			'jnl_code'=>'required'
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		$return=array();
		 $Journal_settings=new \App\Models\Journal_settings();
		 $status_id=$post_data['art_flow_id'];
		 $jnl_id=$post_data['jnl_id'];
		 $jnl_code=$post_data['jnl_code'];
		 $jnl_data =$Journal_settings::get_single_record('jset_date_format',"jset_jnl_id={$jnl_id}");

		 if(!empty($jnl_data))
		 {
			$date_format = $this->get_platform_date_format($post_data['jnl_id']);
			$date_format= date_format_map($date_format);

		 $jnl_array=array("jnl_id"=>$jnl_id,"date_format"=>$date_format,"jnl_code"=>$jnl_code);
		 $stage_info=$this->get_stage_info(array($status_id),$jnl_array);
		 $return['stage_data']=array();
		 if(!empty($stage_info))
		 {
			$stage_info_data = $stage_info[0];
			$return['stage_data']=$stage_info_data;
		 }
		}
		 return  $this->success('Success',200,$return);
	}
	catch(\Exception $e)
	{
		return  $this->failure('Failed',500,$e);
	}
	}

public function change_due_date(Request $request)
{
	try
	{
		$post_data=$request->all();
		$validator = Validator::make($request->all(), [
			'art_flow_id' => 'required',
		    'jnl_id'=>'required',
			'jnl_code'=>'required'
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		$data=$post_data['dudatedata'];
		$duedate = $data['due_date'];
		$reason = $data['reason'];
		$status_id =$post_data['art_flow_id'];
		$jnl_id=$post_data['jnl_id'];
		$jnl_code=$post_data['jnl_code'];
        $core_role=$post_data['core_role'];
		$role_name=$post_data['role_name'];
		$date_format=$this->get_platform_date_format($jnl_id);
		$date_format= date_format_map($date_format);

		$Generic_flows=new \App\Models\Generic_flows();
		$Article_flow=new \App\Models\Article_flow();
		$Change_due_date=new \App\Models\Change_due_date();
		$User_to_journals=new \App\Models\User_to_journals();
		$this->current_user=$this->get_current_user_details();
		//Task #140: JPR-136 BUG: Overdue Reviewer Selection
		//$spos = strrpos($status_id,'_invite');
		$change_due_type = '';
		if(isset($post_data['invite_due_id']) && $post_data['invite_due_id'] == '_invite')
		{
			// $status_id = str_replace('_invite','', $status_id);
			$change_due_type = 'invite';
		}


		$select = 'aflw_art_id, aflw_jwf_id, aflw_due_date,aflw_invite_due_date';

		$where ="aflw_id={$status_id}";

		$stage_info = $Article_flow::get_single_record($select, $where);

		$articel_id = $stage_info->aflw_art_id;
		$jwf_id = $stage_info->aflw_jwf_id;

		if($change_due_type == 'invite')
		{
			$old_due_date = $stage_info->aflw_invite_due_date;
			$change_field = 'aflw_invite_due_date';
		}
		else
		{
			$old_due_date = $stage_info->aflw_due_date;
			$change_field = 'aflw_due_date';
		}

		$duedate = convert_dmy_to_ymd($duedate, $date_format);
		$duedate .= ' ' . date('H:i:s');

		/* updating due date in status table */
		$update_data = array(
			$change_field => $duedate);
		$where ="aflw_id={$status_id}";
		/*
		 * $change_operation = 'e' is set to not list article flow record while changing due date
		 */
		$res = $Article_flow::update_record($update_data, $where, $this->current_user, '', 'e');


		$insert_data = array(
			'cd_aflw_id' => $status_id,
			'cd_due_date' => $duedate,
			'cd_old_due_date' => $old_due_date,
			'cd_chg_duedate_type' => 'o',
			'cd_reason' => $reason,
		);

		/* delete existing due date and adding new one in change_due_date table */

		//Task #140: JPR-136 BUG: Overdue Reviewer Selection
		$where ="cd_aflw_id={$status_id} AND cd_chg_duedate_type='o'";
		$due_change_field = 'aflw_due_date';
		$due_flag = '';
		if($change_due_type == 'invite')
		{
			// $where['cd_chg_duedate_type'] = 'i';
			$where ="cd_aflw_id={$status_id} AND cd_chg_duedate_type='i'";
			$insert_data['cd_chg_duedate_type'] = 'i';
			$due_change_field = 'aflw_invite_due_date';
			$due_flag = '_invite';
		}

		$Change_due_date::delete_records($where, '', $this->current_user);
		$Change_due_date::insert_record($insert_data, $this->current_user);

		/* get new TAT to display */

		$select = 'aflw_id, aflw_art_id, aflw_usr_id,aflw_jwf_id,aflw_status,jwf_stage_type,jwf_parent_user_roles,jwf_who_can_invite,'
			. '(SELECT art_artp_id FROM rvw_articles WHERE art_id = aflw_art_id) AS artp_id, '
			. 'DATE_FORMAT('.$due_change_field.',"' . $date_format . ' %H:%i") AS rvd_aflw_due_date, '
			. 'DATE_FORMAT("' . $old_due_date . '","' . $date_format . ' %H:%i") AS old_due_date, '
			. 'DATEDIFF('.$due_change_field.', NOW()) AS rvd_remaining_days';

		$whereflow ="aflw_id={$status_id}";
		$art_stage = $Article_flow::get_generic_flow($select, $whereflow);
		$art_stage = $art_stage[0];

		//Task #140: JPR-136 BUG: Overdue Reviewer Selection
		if($art_stage->aflw_status == 'w' && $art_stage->jwf_stage_type == 'review')
		{
			if($change_due_type == 'invite')
				$art_stage->type = 'invtation';
			else
				$art_stage->type = 'selection';
		}
		$jnl_array=array('jnl_id'=>$jnl_id,'jnl_code'=>$jnl_code,'core_role'=>$core_role,'role_name'=>$role_name);
		$this->notify_duedate_extension($art_stage,$jnl_array);

		$expire = '';
		$days_passed = '';
		if ($art_stage->rvd_remaining_days < 0)
		{
			$expire = 'text-danger';
			$days_passed = ' (' . abs($art_stage->rvd_remaining_days) . ' days overdue)';
		}

		$return_arr['status'] = 'success';
		//$return_arr['msg'] = lang('due_date_change_success');
		//$return_arr['data_status_id'] = encrypt_link($status_id);
               // $due_date_class = $this->get_due_date_class($art_stage->rvd_remaining_days);
		//$return_arr['output_html'] = "<span id='due_" . $status_id.$due_flag. "'>| <span class='".$due_date_class."'>Due: <strong>" . $art_stage->rvd_aflw_due_date . $days_passed . "</span> <a href='#'><i class='fa fa-pencil-square change_due_date cfa' title='Change Due Date' data-status_id='" . encrypt_link($status_id.$due_flag) . "' data-dateformat='" . $this->jnl_data->js_date_format . "' id='change_duedate'></i></a></strong> </span>";
		return  $this->success('Success',200,$return_arr);
	}
	catch(\Exception $e)
	{
		return  $this->failure('Failed',500,$e);
	}


}

public function get_overview_details(Request $request)
{
	try
	{
		$validator = Validator::make($request->all(), [
			'jnl_id' => 'required',
			'jnl_code' => 'required',
			'role_id' => 'required',
			'core_role' => 'required',
		]);

		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$post_data = $request->all();
			$input_arr = array(
				'input' => $post_data['jnl_id'],
				'type'=> 'number'
			);
			$jnl_id_validate = $this->Rv_validator($input_arr);

			$input_arr['input']= $post_data['role_id'];
			$role_id_validate = $this->Rv_validator($input_arr);

			$input_arr = array(
				'input' => $post_data['jnl_code'],
			);
			//$input_arr['input']= $post_data['jnl_code'];
			$jnl_code_validate = $this->Rv_validator($input_arr);

			$input_arr['input']= $post_data['core_role'];
			$core_role_validate = $this->Rv_validator($input_arr);

			// $form_post=isset($post_data['filter']) ? $post_data['filter'] : array();
			// $filter_validate = $this->filter_validator($form_post);

			if($jnl_id_validate == TRUE && $role_id_validate == TRUE && $jnl_code_validate == TRUE && $core_role_validate == TRUE)
			{
				$result = array();

				$this->current_user = $this->get_current_user_details();

				$core_role = $post_data['core_role'];
				$roleid = $post_data['role_id'];

				$dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
				$dashboard_arr  = Config::get($dashboard_config);
				$dashboard_config = $dashboard_arr[$core_role];

				$user_roles = $this->validate_user_journal($post_data['jnl_code'], $this->current_user['user_id']);

				$user_retire_status = $this->get_user_role_retire($roleid,$this->current_user['user_id'],$post_data['jnl_id']);

				$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
				$workflow_arr  = Config::get($workflow_config);

				$res = array(
					'stage_view_flag' => FALSE,
					'for_author_view' => FALSE,
					'list' => ''
				);

				if(isset($dashboard_config['Overview_block']) && $dashboard_config['Overview_block'] == TRUE)
				{
					$tile_arr['section_id'] = 'overview';
					$tile_arr['inner_list'] = FALSE;
					$tile_arr['stage_type'] = array();

					$review_sel_invite_label = customTrans('dashboard.prod_review_selInvite');
					$review_response_label = customTrans('dashboard.prod_review_actRej');
					$review_report_label = customTrans('dashboard.prod_review_report');
					$review_overdue_label = customTrans('dashboard.prod_review_overdue');

					if($this->current_client->modules->mdl_production == 'n')
					{
						$review_sel_invite_label = customTrans('dashboard.review_selInvite');
						$review_response_label = customTrans('dashboard.review_actRej');
						$review_report_label = customTrans('dashboard.review_report');
						$review_overdue_label = customTrans('dashboard.review_overdue');

						//REVIEW OVERDUE
						$tile_arr['type'] = 'overdue-reviewers';

						$review_overdue = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
						if($review_overdue > 0)
						{
							$result[] = array(
								'label' => 'Reviews overdue',
								'count' => $review_overdue,
								'bind' => $tile_arr['type'],
								//'link' => $url,
							);
						}

						//CHECKEDOUT ARTICLES
						$tile_arr['type'] = 'checkout_articles';
						$checkout_article = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
						if($checkout_article > 0)
						{
							$result[] = array(
								'label' => customTrans('Checked out :articles'),
								'count' => $checkout_article,
								'bind' => $tile_arr['type'],
							//	'link' => $url,
							);
						}

						//ACCEPTED ARTICLES
						$tile_arr['type'] = 'Accepted';
						$accepted_article = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
						if($accepted_article > 0)
						{
							$result[] = array(
								'label' => customTrans('Accepted :articles'),
								'count' => $accepted_article,
								'bind' => $tile_arr['type'],
							//	'link' => $url,
							);
						}

						//REJECTED ARTICLES
						$tile_arr['type'] = 'Rejected';
						$rejected_article = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
						if($rejected_article > 0)
						{
							$result[] = array(
								'label' => customTrans('Rejected :articles'),
								'count' => $rejected_article,
								'bind' => $tile_arr['type'],
							//	'link' => $url,
							);
						}
					}

					$tile_arr['type'] = '';
					$stages_ressult_count = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
					//dd($stages_ressult_count);
					$review_flag = TRUE;
					if(!empty($stages_ressult_count))
					{
						foreach($stages_ressult_count as $res_cnt)
						{
							//in this loop only one time review section works
							if($res_cnt->jwf_stage_type == 'review' && $review_flag == TRUE)
							{
								$review_flag = FALSE;

								//Awaiting reviewer invitation/selection
								$tile_arr['type'] = 'review_selection';
								$review_sel_invite = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
								if($review_sel_invite > 0)
								{
									$result[] = array(
										'label' => $review_sel_invite_label,
										'count' => $review_sel_invite,
										'bind' => $tile_arr['type'],
									//	'link' => $url,
									);
								}

								//Awaiting reviewer responses
								$tile_arr['type'] = 'reviewer_response';
								$reviewer_response = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
								if($reviewer_response > 0)
								{
									$result[] = array(
										'label' => $review_response_label,
										'count' => $reviewer_response,
										'bind' => $tile_arr['type'],
									//	'link' => $url,
									);
								}

								//Awaiting reviewer reports
								$tile_arr['type'] = 'reviewer_report';
								$reviewer_report = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
								if($reviewer_report > 0)
								{
									$result[] = array(
										'label' => $review_report_label,
										'count' => $reviewer_report,
										'bind' => $tile_arr['type'],
									//	'link' => $url,
									);
								}

								//Reviews overdue
								if($this->current_client->modules->mdl_production == 'y')
								{
								$tile_arr['type'] = 'review_overdue';
								$reviewer_overdue = $this->load_tile_details($post_data,FALSE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
								if($reviewer_overdue > 0)
								{
									$result[] = array(
										'label' => $review_overdue_label,
										'count' => $reviewer_overdue,
										'bind' => $tile_arr['type'],
									//	'link' => $url,
									);
								}
							}
								//dd($result);
							}
							elseif($res_cnt->jwf_stage_type == 'review')
							{
								continue;
							}
							elseif($res_cnt->count > 0)
							{
								$result[] = array(
									'label' => ($res_cnt->jwf_stage_name_new != 'Revision')? $res_cnt->jwf_stage_name_new : 'In Revision',
									'count' => $res_cnt->count,
									'bind' => $res_cnt->jwf_stage_type_new,
								//	'link' => $url,
								);
							}
						}
					}

					$res = array(
						'stage_view_flag' => $dashboard_config['Overview_block'],
						'for_author_view' => FALSE,
						'list' => $result
					);
					//return  $this->success('Success',200,$res);
				}
				elseif($core_role == 'author')
				{
					$tile_arr['section_id'] = 'overview';
					$tile_arr['inner_list'] = FALSE;
					$tile_arr['stage_type'] = array();

					//Other submissions (withdrawn articles)
					$tile_arr['type'] = 'author_withdrawn_articles';
					$withdrawn_article_cnt = $this->load_tile_details($post_data,TRUE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
					//echo '<pre>';print_r($withdrawn_article_cnt);exit;

					if($withdrawn_article_cnt > 0)
					{
						$result[] = array(
							'label' => customTrans('dashboard.withdraw_submission'),
							'count' => $withdrawn_article_cnt,
							'bind' => $tile_arr['type'],
						//	'link' => $url,
						);

						$res = array(
							'stage_view_flag' => TRUE,
							'for_author_view' => TRUE,
							'list' => $result
						);
						//return  $this->success('Success',200,$res);
					}
				}

				//production article in draft
				$res['prodDraft'] = FALSE;
				$res['prodDraft_arr'] = array();
				if(isset($this->current_client->modules->mdl_production) &&  $this->current_client->modules->mdl_production == 'y')
				{
					$tile_arr['section_id'] = 'overview';
					$tile_arr['inner_list'] = FALSE;
					$tile_arr['stage_type'] = array();
					$tile_arr['type'] = 'production_draft_article';

					$pro_draft = $this->load_tile_details($post_data,TRUE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);

					if($pro_draft > 0)
					{
						$res['prodDraft'] = TRUE;
						$res['prodDraft_arr'] = array(
							'head_label' => 'Article in draft',
							'label' => 'Drafted manuscript for production',
							'count'=> $pro_draft,
							'bind' => $tile_arr['type'],
						);
					}
				}

				//for legacy articles
				$res['legacyArt'] 		= FALSE;
				$res['legacyArt_arr'] 	= array();
				if ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y')
				{
					$tile_arr['section_id'] = 'overview';
					$tile_arr['inner_list'] = FALSE;
					$tile_arr['stage_type'] = array();
					$tile_arr['type'] = 'legacy_article';

					$legacy_art = 0;
					//$legacy_art = $this->load_tile_details($post_data,TRUE,$tile_arr,$this->current_user,$user_roles,$workflow_arr,$user_retire_status,NULL);
					$legacy_art = $this->legacy_data($post_data, $this->current_user);
					if(count($legacy_art) > 0)
					{
						if($legacy_art['legacy_show'] == true){
							$res['legacyArt'] = TRUE;
							$res['legacyArt_arr'] = array(
								'head_label' => 'Legacy Articles',
								'label' => $legacy_art['legacy_name'],
								'count'=> $legacy_art['legacy_count'],
								'link'=> $legacy_art['all_legacy_link'],
								'bind' => $tile_arr['type'],
							);
						}
					}

				}
				return  $this->success('Success',200,$res);
			}
			else
			{
				return $this->warning('Failed',422,customTrans('auth.invalid_data'));
			}
		}
	}
	catch(\Exception $e)
	{

		return  $this->failure('Failed',500,$e);
	}
}

public function legacy_data($post_data, $current_user) {
	$Article_legacydata 	= new \App\Models\Article_legacydata;
	$Article_legacydata_tbl = $Article_legacydata->getTable();

	$user_id 	= 	$current_user['user_id'];
	$core_role 	= 	$post_data['core_role'];
	$jnl_id 	= 	$post_data['jnl_id'];
	$jnl_code 	= 	'';

	$legacy_show= 	FALSE;
	$lcount		=	0;
	$data		=	array();

	// Legacy data
	if ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y')
	{
		$legacy_auth_count	=	0;
		$jnl_data =	Journals::get_single_record('jnl_journal_code',"jnl_id={$jnl_id}");
		if(!empty($jnl_data)) {
			$jnl_code	=	$jnl_data->jnl_journal_code;
		}
		else {
			return $data;
		}

		if ($core_role == 'author')
		{
			$select = 	'count(arld_id) legacy_count';
			$where 	=	"arld_submitted_by = ".$user_id." and arld_jnl_id = ".$jnl_id." and arld_art_previous_id IS NULL";
			$all_legacy_submission = $Article_legacydata::get_single_record($select, $where);

			$data['legacy_count'] =	0;
			if($all_legacy_submission->legacy_count > 0)
			{
				$legacy_auth_count 		=  	$data['legacy_count'] = $all_legacy_submission->legacy_count;
				$data['legacy_name'] 	=	$this->get_legacy_head_label($core_role);
				$param 	=	encrypt_link($core_role).'/'.encrypt_link($jnl_code);
				$data['all_legacy_link']= 	$jnl_code . '/legacy-articles/'.$param.'';
			}
			$lg_sql = 'SELECT arld_id,arld_art_pre_all_ids FROM ' . $Article_legacydata_tbl . ' WHERE FIND_IN_SET(' . $user_id . ',arld_author_id) AND arld_jnl_id = ' . $jnl_id . ' AND arld_submitted_by != ' . $user_id;
			$legacy_details = $Article_legacydata->get_records_by_raw_query($lg_sql);
			$lcount = $this->get_legacy_actual_count($legacy_details);
			$data['legacy_co_authored'] = $lcount;
			if($lcount > 0)
			{
				$data['legacy_name'] 	=	$this->get_legacy_head_label('co_author');
				$param 	=	encrypt_link('co_author').'/'.encrypt_link($jnl_code);
				$data['legacy_coauth_link'] 	= 	$jnl_code . '/legacy-articles/'.$param.'';
			}
		}
		elseif ($core_role == 'staff' || $core_role == 'editor_in_chief' || $core_role == 'reviewer')
		{
			$data['legacy_name'] 	=	$this->get_legacy_head_label($core_role);
			if ($core_role == 'staff')
			{
				$select = 	'count(arld_id) cnt';
				$where 	=	"arld_jnl_id = ".$jnl_id." and arld_art_pre_all_ids IS NULL";
				$temp_leg_count = $Article_legacydata::get_single_record($select, $where);
				$lcount = $temp_leg_count->cnt;
			}
			else if ($core_role == 'editor_in_chief')
			{
				$sub_condition = 'FIND_IN_SET(' . $user_id . ',arld_editors) AND';
				$lg_sql = 'SELECT count(arld_id) as cnt FROM ' . $Article_legacydata_tbl . ' WHERE ' . $sub_condition . ' arld_jnl_id = ' . $jnl_id . ' and arld_art_pre_all_ids is null';
				$legacy_details = $Article_legacydata::get_records_by_raw_query($lg_sql);
				$lcount = isset($legacy_details[0]) ? $legacy_details[0]->cnt:0;

			}
			else if ($core_role == 'reviewer')
			{
				$lg_sql = 'SELECT arld_id,arld_art_pre_all_ids FROM ' . $Article_legacydata_tbl . ' WHERE FIND_IN_SET(' . $user_id . ',arld_reviewers) AND arld_jnl_id = ' . $jnl_id;
				$legacy_details = $Article_legacydata::get_records_by_raw_query($lg_sql);
				$lcount = $this->get_legacy_actual_count($legacy_details);
			}
			$data['legacy_count'] = $lcount;
			if($lcount > 0){
				$param 	=	encrypt_link($core_role).'/'.encrypt_link($jnl_code);
				$data['all_legacy_link']=	$jnl_code . '/legacy-articles/'.$param.'';
			}
		}
		if($lcount> 0 || $legacy_auth_count > 0)
		{
			$legacy_show = TRUE;
		}
	}
	$data['legacy_show'] = $legacy_show;
	return $data;
}

function get_legacy_head_label($core_role)    {
	if($core_role == 'author') {
		return 'Legacy submissions';
	}
	else if($core_role == 'co_author') {
		return 'Legacy co-authored articles';
	}
	else {
		return 'Legacy completed articles';
	}
}

public function get_legacy_actual_count($legacy_details)
{
	$lcount = 0;
	$leg_ids = array();
	if (!empty($legacy_details))
	{
		foreach ($legacy_details as $leg)
		{
			$prev_array = ($leg->arld_art_pre_all_ids != NULL) ? explode(',', $leg->arld_art_pre_all_ids) : array();
			if (count(array_intersect($leg_ids, $prev_array)) <= 0)
			{
				$lcount++;
				$leg_ids[] = $leg->arld_id;
			}
		}
	}

	return $lcount;
}

public function create_map(Request $request)
{
	try
	{
		$validator = Validator::make($request->all(), [
			'jnl_id' => 'required',
			'core_role' => 'required',
		]);

		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		$post_data=$request->all();
		$core_role = $post_data['core_role'];
		$Author_country_map=new \App\Models\Author_country_map();
		$Authors_affiliation=new \App\Models\Authors_affiliation();
		$Country=new \App\Models\Country();

	$map_details = $Author_country_map::get_author_map_info($post_data['jnl_id']);
	$position_arr = array();
	$check_array = array();
	//The map functionality is currently displayed for all users; it should only be displayed for those who are permitted, as defined in the client dashboard configuration file.
	$dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard';
	$dashboard_arr  = Config::get($dashboard_config);

	if (!empty($map_details) && isset($dashboard_arr[$core_role]['Map']) && $dashboard_arr[$core_role]['Map'] == TRUE)
	{
		foreach ($map_details as $map_detail)
		{
			if ($map_detail->auaff_address_line2 != "")
			{
				$cord = $map_detail->auaff_address_line2 . ', ' . $map_detail->cnt_country;
			}
			else
			{
				$cord = $map_detail->cnt_country;
			}
			$cordinates = [];
			array_push($cordinates, $map_detail->acm_longitude);
			array_push($cordinates, $map_detail->acm_latitude);

			$check = [
				'coordinates' => $cordinates,
			];
			array_push($check_array, $check);
			$position_arr[] = '[' . $map_detail->acm_latitude . ',' . $map_detail->acm_longitude . ']';
		}
	}
	return  $this->success('Success',200,$check_array);
}

catch(\Exception $e)
{
	return  $this->failure('Failed',500,$e);
}
}

public function save_review_rating(Request $request) {
	try {
		$rules = [
					'type'       => 'required',
					'rating'     => 'required',
					'posted'     => 'required',
					'flow'       => 'required',
					'article_id' => 'required',
				];
		if (isset($this->current_client->functionality->cfty_reviewer_rating_feedback ) && $this->current_client->functionality->cfty_reviewer_rating_feedback == 'y') {
			$rules['feedback'] = 'required';
		}

		$validator = Validator::make($request->all(), $rules);
		if ($validator->fails()) {
			return  $this->warning('Warnings',200,$validator->errors(),'warning');
		}
		$this->current_user = $this->get_current_user_details();
		$form_data = $request->all();
		$reviewid = decrypt_link($form_data['flow']);
		$rver = decrypt_link($form_data['posted']);
		$type=$form_data['type'];
		$rating=$form_data['rating'];
		$Review_rating = new \App\Models\Review_rating;
		$five_star = $form_data['five_star'] == TRUE ? 'y':'n';
		if (isset($this->current_client->functionality->cfty_reviewer_rating_feedback ) && $this->current_client->functionality->cfty_reviewer_rating_feedback == 'y') {
			$feedback=$form_data['feedback'];
		}
		
		$get_review_details = $Review_rating::get_single_record_with_bind_cond(
			'rvr_id',
			array(
				'rvr_aflw_id'    => $reviewid,
				'rvr_reviewer_id'=> $rver,
				'rvr_rated_by'   => $this->current_user['user_id'],
				'rvr_rating_type'=> $type
			)
		);

		if ($get_review_details != NULL) { // update
			$updateData = [
                'rvr_rating'   => $rating,
                'rvr_five_star'=> $five_star
            ];

            if (isset($this->current_client->functionality->cfty_reviewer_rating_feedback ) && $this->current_client->functionality->cfty_reviewer_rating_feedback === 'y') {
                $updateData['rvr_feedback'] = $feedback;
            }
			$update = $Review_rating::update_record($updateData,"rvr_id={$get_review_details->rvr_id}", $this->current_user);
			$return_arr['status'] = 'success';
			//$return_arr['msg'] = lang('rating_updated');
			$return_arr['msg'] = 'update';
		} else { // insert
			$data = array(
				'rvr_aflw_id' => $reviewid,
				'rvr_reviewer_id' => $rver,
				'rvr_rated_by' => $this->current_user['user_id'],
				'rvr_rating_type' => $type,
				'rvr_rating' => $rating,
				'rvr_five_star' => $five_star
			);
			if (isset($this->current_client->functionality->cfty_reviewer_rating_feedback ) && $this->current_client->functionality->cfty_reviewer_rating_feedback == 'y') {
                $data['rvr_feedback'] = $feedback;
            }
			$inserted_id = $Review_rating::insert_record($data, $this->current_user);

			if ($inserted_id)
			{
				$return_arr['status'] = 'success';
				//$return_arr['msg'] = lang('rating_insert');
				$return_arr['msg'] = 'insert';
			}
		}

		$get_avg_rating = $Review_rating::get_single_record('sum(rvr_rating) as revew_avg_rating',"rvr_aflw_id={$reviewid} and rvr_reviewer_id={$rver} and rvr_rated_by={$this->current_user['user_id']} ");

		$return_arr['avg_rating'] = $get_avg_rating->revew_avg_rating / 2;
		//$return_arr['avg_rating'] = round($get_avg_rating->revew_avg_rating, 1);
		//$return_arr['reviewid'] = decrypt_link($post_data['reviewid']);

		return  $this->success('Success',200,$return_arr);


	} catch(\Exception $e) {

		return  $this->failure('Failed',500,$e);
	}
}



	public function get_review_rating(Request $request) {
		try {
			$validator = Validator::make($request->all(), [
				'posted'      => 'required',
				'flow'      => 'required',
			]);
			if ($validator->fails()) {
				return  $this->warning('Warnings',200,$validator->errors(),'warning');
			}
			$this->current_user = $this->get_current_user_details();
			$form_data = $request->all();
			$reviewid = decrypt_link($form_data['flow']);
			$rver = decrypt_link($form_data['posted']);

			$Review_rating = new \App\Models\Review_rating;

			$get_review_details = $Review_rating::get_all_records_with_bind_cond(
				'rvr_rating, rvr_feedback, rvr_rating_type, rvr_five_star',
				array(
					'rvr_aflw_id'     => $reviewid,
					'rvr_reviewer_id' => $rver,
					'rvr_rated_by'    => $this->current_user['user_id']
				)
			);
			if ($get_review_details != NULL)
			{
				$five_star = FALSE;
				if(count($get_review_details) == 1 && $get_review_details[0]->rvr_five_star == 'y')
				{
					$five_star = TRUE;
				}
				$sm = '';
				$ld = '';
				$feedback = Null;
				if (isset($get_review_details[0]->rvr_rating_type)) {

					if ($get_review_details[0]->rvr_rating_type == 'sm') {
						$sm = $get_review_details[0]->rvr_rating;
					}
					if ($get_review_details[0]->rvr_rating_type == 'ld') {
						$ld = $get_review_details[0]->rvr_rating;
					}
					if ($get_review_details[0]->rvr_feedback != NULL) {
						$feedback = $get_review_details[0]->rvr_feedback;
					}

				}
				if (isset($get_review_details[1]->rvr_rating_type)) {

					if ($get_review_details[1]->rvr_rating_type == 'sm') {
						$sm = $get_review_details[1]->rvr_rating;
					}
					if ($get_review_details[1]->rvr_rating_type == 'ld') {
						$ld = $get_review_details[1]->rvr_rating;
					}
					if ($get_review_details[0]->rvr_feedback != NULL) {
						$feedback = $get_review_details[0]->rvr_feedback;
					}
				}
				if($sm==''){
					$sm=0;
				}
				if($five_star == TRUE && $ld=='')
				{
					$ld = 'five_star';
				}
				else if($ld==''){
					$ld=0;
				}
				$data['status'] = "success";
				$data['reviewdata'] = array(
					'sm' => $sm,
					'ld' => $ld,
					'feedback' => $feedback);
			}
			else
			{
				$data['status'] = "success";
				$data['reviewdata'] = array(
					'sm' => 0,
					'ld' => $this->current_client->functionality->cfty_fivestar_review_rating == 'y' ? 'five_star':0,
					'feedback' => NULL);
			}
			return  $this->success('Success',200,$data);


		} catch(\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}

public function rescind_review(Request $request) {
	try {
		$validator = Validator::make($request->all(), [
			'record_reason_reviewer'      => 'required',
			'posted'      => 'required',
			'flow'      => 'required',
			'article_id'      => 'required',
			'core_role'      => 'required',
			'role_name'      => 'required',
		]);
		if ($validator->fails()) {
			return  $this->warning('Warnings',200,$validator->errors(),'warning');
		}
		$form_data = $request->all();
		$record_reson=$form_data['record_reason_reviewer'];
		$email_data_action='rescind';
		$aflw_id = decrypt_link($form_data['flow']);
		$article_id = decrypt_link($form_data['article_id']);
		$jnlcode = $form_data['jnl_code'];
		$jnl_id = $form_data['jnl_id'];

		$core_role = $form_data['core_role'];
		$role_name = $form_data['role_name'];
		$role_id = $form_data['role_id'];

		$rvwer_id = decrypt_link($form_data['posted']);


		$this->current_user = $this->get_current_user_details();
		$Article_generic_form_data::delete_generic_form_data($formatted_journal_code, $delfield, $delvalues,$this->current_user);

		$reviewer = Article_flow::get_single_record('aflw_parent_flow_id,aflw_due_date,aflw_jwf_id',"aflw_id={$aflw_id}" );
			$rescind_record = array(
				'rsc_current_flow_id' => $aflw_id,
				'rsc_source_jwf_id' => $reviewer->aflw_jwf_id,
				'rsc_reason' => $record_reson,
				'rsc_action' => 'rescind',
				'rsc_review_by_priv_usr'=>0);


				$Rescind_reset_record = new \App\Models\Rescind_reset_record;
				$Article_generic_form_data = new \App\Models\Article_generic_form_data;
				$Roles = new \App\Models\Roles;
				$Review_rating = new \App\Models\Review_rating;
				$Articles = new \App\Models\Articles;
				$User = new \App\Models\User;
				$Generic_flows = new \App\Models\Generic_flows;

				$record_id = $Rescind_reset_record::insert_record($rescind_record, $this->current_user);

			//update review flow status and flow returned_date
			Article_flow::update_record(array(
				'aflw_remarks'=>$record_reson,
				'aflw_returned_date' => NULL,
				'aflw_status' => 'a'),"aflw_id={$aflw_id}", $this->current_user);
			//delete generic form data
			$delfield = 'gdata_artflw_id';
			$formatted_journal_code = '_' . $jnlcode;
			$delvalues = array(
				$aflw_id);
			$Article_generic_form_data::delete_generic_form_data($formatted_journal_code, $delfield, $delvalues);

			$article_new_data = $Articles::get_article_data($article_id);


			$invite = FALSE;
			$article_stage=$Generic_flows::get_single_record('*',"jwf_id={$reviewer->aflw_jwf_id}");

			$who_can_invite = json_decode($article_stage->jwf_who_can_invite);

			$all_user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $article_new_data->artp_id);
			$all_roles = $Roles::get_all_records('role_id,role_name,role_assigned_role');
			$user_array = array();
			$user_array['user_roles'] = $all_user_roles;
			$user_array['article_id'] = $article_id;
			$user_array['all_roles'] = $all_roles;
			//$user_array['article_privilages'] = $article_privilages;
			$user_array['jnl_id'] = $jnl_id;
			$user_array['user_id'] = $this->current_user['user_id'];
			$user_array['art_flow_id'] = $aflw_id;
			$user_roles = $this->get_article_user_roles($user_array);

			//$user_roles = $this->get_article_user_roles($all_user_roles, $article_new_data->art_id, $all_roles);
			if (count($user_roles) > 0 && count($who_can_invite) > 0)
			{

				/* 5.1 if any of the users roles has permission to invite reviewer,
				 *  use the revier on fly template  */
				if (count(array_intersect($user_roles['role_id'], $who_can_invite)) > 0)
				{
					//$article_flow_status = 'i';
					$invite = TRUE;
				}
			}

			//delete review rating
			$Review_rating::delete_records("rvr_aflw_id={$aflw_id}" , '', $this->current_user);

			$rvwer_mail = $User::get_single_record('usr_email',"usr_id={$rvwer_id}");
			$custom_data = array(
				'user_email' => $rvwer_mail->usr_email,
				'esl_etmp_action' =>'rescind_review',
				'action' =>'rescind',
				'mail_recipient_ids'=>$rvwer_id,
				'aflw_id'=>$aflw_id,
				'article_id'=>$article_id,
				'artp_id'=>$article_new_data->artp_id,
				'jnl_id'=>$jnl_id,
				'rescind_request'=>TRUE,
				'jnl_code'=>$jnlcode,
			);

			$email_data = array(
				'type' => 'global',
				'action' => 'send',
				'email_with_login' => TRUE,
				'user_id' => $rvwer_id,
				'empt_name' => 'rescind_review',
				'jnl_user_role'=>array(
				'core_role'=>$core_role,
				'role_name'=>$role_name,
				'jnl_journal_code'=> $jnlcode
				),
				'custom_data' => $custom_data
			);

			$this->master_email_details($email_data);

				$result['msg']='Updated successfully';
				return  $this->success('Success',200,$result);


	} catch(\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}
	}
   public function get_initialization_unasgn_emails(Request $request)
	{
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'curnt_flow_id' => 'required',
                'current_stage_type' => 'required',
            ]);

            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
			$flowidarray = array('input'=>$post_data['curnt_flow_id'],'type'=>'number', 'enc_data'=>TRUE );
			$articleidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
			$currentstagetypearray = array('input'=>$post_data['current_stage_type'],'type'=>'string', 'enc_data'=>TRUE );
			$flowidvalidation= $this->Rv_validator($flowidarray);
			$articleidvalidation= $this->Rv_validator($articleidarray);
			$currentstagetypevalidation= $this->Rv_validator($currentstagetypearray);


		if($flowidvalidation != TRUE || $articleidvalidation != TRUE   || $currentstagetypevalidation != TRUE ){
			return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
		}
            $this->current_user = $this->get_current_user_details();
            $Stage_email_templates = new \App\Models\Stage_email_templates;
            $Article_type_advance_options = new \App\Models\Article_type_advance_options;
            $Article_flow = new \App\Models\Article_flow;
            $Generic_flows = new \App\Models\Generic_flows();
            $GenericFlowsTable = (new \App\Models\Generic_flows())->getTable();
            $stage_id = trim($post_data['stage']);
            $article_id = decrypt_link($post_data['art_id']);
            $curnt_flow_id = decrypt_link($post_data['curnt_flow_id']);
            $stage_type = decrypt_link($post_data['current_stage_type']);
            $next_stage_type = decrypt_link($post_data['stage_type']);
            $article_details = Articles::get_single_record('art_artp_id', "art_id ={$article_id}");
            $article_type_id = $article_details->art_artp_id;
            if ($stage_id == "" && $stage_type != 'reject') {
                $return_arr['msg'] = 'Invalid data';
                return $this->warning('Failed', 500, $return_arr);
            }
            $author_stage_emails = array();
            if ($stage_id != '') {
                /*Bug#4518 AE cannot review decision letters now start  */
                $author_stage_save_emails = array();
                $author_save_emailids = array();
                $general_config = General_ConfigTraits::General_config_data('decision_popup_showstages');
                $decision_poup_show_stage_array = $general_config['decision_popup_showstages'];

                if (!empty($decision_poup_show_stage_array) && (in_array($stage_type, $decision_poup_show_stage_array)) && isset($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage) && ($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage == 'y')) {
                    $next_stage_decision_id = $this->get_next_decision_stageid(array($stage_id), allow_multi_stage_return:true);
                    $stage_id = $next_stage_decision_id;
                    $author_stage_save_emails = $this->get_article_saved_email_template_details($article_id, $stage_id);

                    if ($author_stage_save_emails->isNotEmpty()) {
                        foreach ($author_stage_save_emails as $author_email) {
                            $author_save_emailids[] = $author_email->stage_etmp_id;
                        }
                    }

                }
				$stage_id_cdtn = is_array($stage_id) ? " ('". implode("','", $stage_id) . "') " : " ($stage_id) ";
                $condition_author = 'setr_jwf_id  IN' . $stage_id_cdtn . ' AND (stage_etmp_action = "assigned" OR stage_etmp_action = "initialization" )';
                if (!empty($author_save_emailids)) {
                    $template_ids = implode(',', $author_save_emailids);
                    $condition_author .= ' AND  stage_etmp_id NOT IN(' . $template_ids . ')';
                }
                $author_stage_emails = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_id,stage_etmp_name,stage_etmp_subject,setr_id', $condition_author);
				;
				if (count($author_stage_emails)==0){
					$author_stage_emails=array();
				}else{
					if (!is_array($author_stage_emails)) {
						$author_stage_emails=$author_stage_emails->toarray();
					}
					else{
						$author_stage_emails=$author_stage_emails;
					}

				}
				if (count($author_stage_save_emails)==0){
					$author_stage_save_emails=array();
				}else{
					if (!is_array($author_stage_save_emails)) {
						$author_stage_save_emails=$author_stage_save_emails->toarray();
					}
					else{
						$author_stage_save_emails=$author_stage_save_emails;
					}
				}
				/* print_r($author_stage_emails);
				 print_r($author_stage_save_emails);die;*/
					$author_stage_emails = array_merge($author_stage_emails, $author_stage_save_emails);

                /*Bug#4518 AE cannot review decision letters now end  */
            }

            $instant_decision_stages = array(
                'resubmission',
            );
			//TASK #8906 An error occurs when clicking on the "Confirm Reject" button 
            $next_stage_id = isset($stage_id[0])?$stage_id[0]:$stage_id;
            $next_stage_types = array();
            $instant_decision_init_mail = false;
            if ($next_stage_id !== '') {
                $next_stage_types = $Generic_flows::get_single_record('jwf_stage_type', "jwf_id={$next_stage_id}");
                if (!empty($next_stage_types)) {
                    if (in_array($next_stage_types->jwf_stage_type, $instant_decision_stages)) {
                        $instant_decision_init_mail = true;
                    }
                }
            }
            $show_warning = false;
            $un_assign_stage_emails = $un_assign_stages = array();
            if (in_array($stage_type, array(
                'accept',
                'reject',
                'decision_revision')) || $instant_decision_init_mail == true) {
                $art_type_adv = $Article_type_advance_options::get_single_record('atotp_review_open_decision', "atotp_artp_id={$article_type_id}");
                if ($art_type_adv->atotp_review_open_decision == 'n') {
                    $users_to_unassign = $Article_flow::get_single_record('count(*) as cnt,aflw_jwf_id', 'aflw_parent_flow_id is not NULL and (aflw_status = "a") and  aflw_art_id =' . $article_id);
					if (isset($users_to_unassign) &&isset($users_to_unassign->aflw_jwf_id)) {
						$Generic_flows = new \App\Models\Generic_flows();

						$stagedetails = $Generic_flows::get_single_record_with_bind_cond('jwf_role_id,jwf_stage_type', array('jwf_id'=>$users_to_unassign->aflw_jwf_id));

					}					
					$current_flow_level = $Article_flow::get_single_record('aflw_level', ' aflw_id =' . $curnt_flow_id);

					if (isset($users_to_unassign->cnt) && $users_to_unassign->cnt > 0 && (isset($stagedetails->jwf_stage_type) && $stagedetails->jwf_stage_type=='review')) {
                        $prev_review_stages = $Article_flow::get_all_records('DISTINCT(aflw_jwf_id) as jwf', 'aflw_level <' . $current_flow_level->aflw_level . ' AND aflw_parent_flow_id IS NOT NULL AND aflw_status ="a" AND aflw_art_id =' . $article_id);
                        if (!empty($prev_review_stages)) {
                            $un_assign_stage_emails = array_flip(array_column(json_decode(json_encode($prev_review_stages), true), 'jwf'));
                        }
                        $emls = array();
                        if (!empty($un_assign_stage_emails)) {
                            foreach ($un_assign_stage_emails as $uk => $u) {

                                $un_email = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_id,stage_etmp_name,stage_etmp_subject,(SELECT jwf_stage_name FROM ' . $GenericFlowsTable . ' WHERE jwf_id = ' . $uk . ' ) as stage_name,setr_id', 'setr_jwf_id =' . $uk . ' AND stage_etmp_action = "unassign_user"');
                                $un_assign_stage_emails[$uk] = $un_email;
                                if (!empty($un_email)) {
                                    $emls[] = $un_email;
                                }
                                $un_assign_stages[$uk] = isset($un_assign_stage_emails[$uk][0]->stage_name) ? $un_assign_stage_emails[$uk][0]->stage_name : '';
                            }
                        }

                        if (empty($emls)) {
                            $show_warning = true;
                        }
                    }
                }
            }
            if (empty($author_stage_emails) && empty($un_assign_stage_emails)) {
                $return_arr['msg'] = 'Invalid data';
                return $this->warning('Failed', 500, $return_arr);
            }

            $data['author_stage_emails'] = $author_stage_emails;
            $data['show_warning'] = $show_warning;
            $data['un_assign_stage_emails'] = $un_assign_stage_emails;
            $data['un_assign_stages'] = $un_assign_stages;
            $data['stage_id'] = $stage_id;
            $data['author_stage_tab_name'] = 'Emails';
            $data['author_stage_info'] = 'Please select email(s) to be sent out when the next stage is initialized';
            $data['unassign_stage_info'] = 'Please select emails from list below, in order to unassign users';
            return $this->success('Success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

public function load_next_task(Request $request)
{
	try {
		$modal_data = array();
		$this->current_user = $this->get_current_user_details();
		$form_data = $request->all();
		$validator = Validator::make($request->all(), [
			'article_id' => 'required',
			'art_flow_id' => 'required',
			//'jnl_id' => 'required',
			'jnlcode' => 'required'
		]);
		if ($validator->fails()) {
			return  $this->failure('Failed', 422, $validator->errors());
		}

		if ($form_data['article_id'] != '') {
			$article_id = isset($form_data['article_id']) ?  $this->decrypt_data($form_data['article_id']) : '';
			$jnlcode = isset($form_data['jnlcode']) ? $form_data['jnlcode'] : '';
			$jnl_id = isset($form_data['jnl_id']) ? $form_data['jnl_id'] : '';
			$aflw_id = isset($form_data['art_flow_id']) ?  $this->decrypt_data($form_data['art_flow_id']) : '';
			$prev_aflw_id = isset($form_data['prev_aflw_id']) ?  $this->decrypt_data($form_data['prev_aflw_id']) : '';
			$privilage = isset($form_data['privilage']) ? $form_data['privilage'] : '';
			$show_modal = isset($form_data['show_modal']) ? $form_data['show_modal'] : '';
			$mode = isset($form_data['mode']) ? $form_data['mode'] : '';
			$defaultroledata = isset($form_data['defaultroledata']) ? $form_data['defaultroledata'] : '';
			parse_str($this->decrypt_data($form_data['string']), $_GET);
			$section=isset($_GET['type']) ? $_GET['type'] : 'd';
			$category=isset($_GET['section']) ? $_GET['section'] : 'd';
			$client_code = $this->current_client->clnt_client_code;
			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
			$review_config = Config::get($workflow_config);

			$artflow_id_array = array('input'=>$form_data['art_flow_id'],'type'=>'number', 'enc_data'=>TRUE );
			$artflw_idvalidation= $this->Rv_validator($artflow_id_array);
			if($artflw_idvalidation==false)
            {
				return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
            }
			$art_id_array = array('input'=>$form_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
			$art_idvalidation= $this->Rv_validator($art_id_array);
			if($art_idvalidation==false)
            {
				return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
            }
			$prev_id_array = array('input'=>$form_data['prev_aflw_id'],'type'=>'number', 'enc_data'=>TRUE );
			$prv_idvalidation= $this->Rv_validator($prev_id_array);
			if($prv_idvalidation==false)
            {
				return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
            }
			$jnl_id_array = array('input'=>$form_data['jnl_id'],'type'=>'number', 'enc_data'=>FALSE );
			$jnl_idvalidation= $this->Rv_validator($jnl_id_array);
			if($jnl_idvalidation==false)
            {
				return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
            }
			if(isset($defaultroledata['role_id']) && !empty($defaultroledata['role_id']))
			{
				$role_id_array = array('input'=>$defaultroledata['role_id'],'type'=>'number', 'enc_data'=>FALSE );
				$role_idvalidation= $this->Rv_validator($role_id_array);
				if($role_idvalidation==false)
            	{
					return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
           	 	}
			}
			if($jnl_id=='')
			{
			$platform_data = $this->platform_basic_settings_data($jnlcode);
			$jnl_id = $platform_data->jnl_id;
			}
			/* Task percentage */
			$assignment = FALSE;
			$return_arr = array();
			if ($privilage == TRUE) {
				/* Assign/Invite permissions/Assigned users */
				$current_stage_detials = Article_flow::get_stage_details('aflw_id=' . $aflw_id, 'aflw_id,jwf_stage_type,jwf_id,aflw_status,aflw_usr_id,jwf_stage_name,jwf_role_id,jwf_assignment,jwf_parent_user_roles,jwf_who_can_invite,jwf_child_stages,aflw_parent_flow_id,art_artp_id');
				$data = $article_assign_permission = $article_invite_permission = array();
				$user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $current_stage_detials->art_artp_id);
				$assigned_roles = $user_roles['role_id'];
				$jwf_parent_user_roles = json_decode($current_stage_detials->jwf_parent_user_roles, TRUE);
				$jwf_who_can_invite = json_decode($current_stage_detials->jwf_who_can_invite, TRUE);
				$jwf_role_id = $current_stage_detials->jwf_role_id;
				//print_r($user_roles); die;
				$redirect_to = 'dashboard';
				if (!empty(array_intersect($assigned_roles, $jwf_parent_user_roles)) || !empty(array_intersect($assigned_roles, $jwf_who_can_invite)) || (in_array($jwf_role_id, $assigned_roles) && ($current_stage_detials->aflw_usr_id== NULL || $current_stage_detials->aflw_usr_id == $this->current_user['user_id'])) && ($current_stage_detials->jwf_stage_type!="aop_publish" || ($current_stage_detials->jwf_stage_type == 'aop_publish' && $current_stage_detials->aflw_status!='c'))) {
					$redirect_to = 'next task';
				}


				$article_details = Articles::get_single_record('art_artp_id', 'art_id=' . $article_id);
				if ($current_stage_detials->aflw_usr_id != NULL && $current_stage_detials->aflw_status == 'a') {
					$stage_role = Roles::get_single_record('role_name', 'role_id=' . $current_stage_detials->jwf_role_id);
					$modal_data['role'] = $stage_role->role_name;

					$array_data['user_id'] = $current_stage_detials->aflw_usr_id;
					$array_data['journal_id'] = $jnl_id;
					$array_data['flag'] = TRUE;
					$array_data['article_id'] = $article_id;
					$array_data['jnl_code'] = $jnlcode;
					$modal_data['user'] = $this->get_user_display_name($array_data);
				} else {

					$assign_permission = '';
					$assigning_roles = json_decode($current_stage_detials->jwf_parent_user_roles);
					if (!empty($assigning_roles)) {
						$article_assign_permission = $this->get_users_in_role($article_id, $article_details->art_artp_id, $assigning_roles, $jnl_id, $jnlcode);
					}
					$invite_permission = '';
					//role who is inviting users
					$inviting_roles = json_decode($current_stage_detials->jwf_who_can_invite);
					if (!empty($inviting_roles)) {
						$article_invite_permission = $this->get_users_in_role($article_id, $article_details->art_artp_id, $inviting_roles, $jnl_id, $jnlcode);
					}
					if (!empty($article_assign_permission)) {
						$data['who_can_assign'] = $article_assign_permission;
					}
					if (!empty($article_invite_permission)) {
						$data['who_can_invite'] = $article_invite_permission;
					}
				}
				$assignment = FALSE;
				if (!empty($data)) {
					$assignment = TRUE;
				}
				$modal_data['assignment'] = $assignment;
				$model_info = '';
				$redirect_after_complete = 'n';
				$hide_actions = FALSE;
				$modal_data["popup_on_completion_status"] = 1;
				$prev_stage = Article_flow::get_stage_details('aflw_id=' . $prev_aflw_id, 'jwf_stage_type,jwf_stage_name,jwf_child_stages,jwf_parent_stages,jwf_enable_popup_after_completion,jwf_assignment');
				if ($show_modal == 'y' || $show_modal == 'redirect') {
					$redirect_after_complete = 'y';
					$all_user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $article_details->art_artp_id);
					$all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
					/* Roles assigned to this article */
					$user_array = array();
					$user_array['user_roles'] = $all_user_roles;
					$user_array['article_id'] = $article_id;
					$user_array['all_roles'] = $all_roles;
					$user_array['jnl_id'] = $jnl_id;
					$user_array['user_id'] = $this->current_user['user_id'];
					$article_user_roles = $this->get_article_user_roles($user_array);
					$next_array=array();
					if (!empty($prev_aflw_id)) {
						//$prev_stage = Article_flow::get_stage_details('aflw_id=' . $prev_aflw_id, 'jwf_stage_type,jwf_stage_name,jwf_child_stages,jwf_parent_stages,jwf_enable_popup_after_completion,jwf_assignment');
						$modal_data['notify_msg'] = '';
						if ($prev_stage->jwf_assignment != 'invitation' && (($prev_stage->jwf_child_stages != '[]'  && $prev_stage->jwf_child_stages != '') || ($prev_stage->jwf_parent_stages != '' && $mode == 'hold'))) {
							$Generic_flows = new \App\Models\Generic_flows();
							$Generic_flows_table = ($Generic_flows)->getTable();
							$genericrec=$Generic_flows::get_all_records('jwf_id,jwf_child_stages','jwf_disable_status=\'y\' and jwf_id IN( ' . implode(',', json_decode($prev_stage->jwf_child_stages)) . ')');
							$childstages= json_decode($prev_stage->jwf_child_stages);
							if(!empty($genericrec) & isset($genericrec[0]->jwf_id))
							{
								foreach($genericrec as $gr)
								{
									if(in_array($gr->jwf_id,$childstages))
									{
										$key = array_search($gr->jwf_id, $childstages);
										unset($childstages[$key]);
										$childstages = array_values($childstages);
										$newchildstages=json_decode($gr->jwf_child_stages);
										foreach($newchildstages as $nc)
										{
											array_push($childstages,$nc);
										}
									}
								}
							}
							$where = 'aflw_jwf_id IN( ' . implode(',', $childstages) . ') AND aflw_art_id = ' . $article_id . ' AND aflw_id > ' . $prev_aflw_id . ' AND aflw_status NOT IN("c","g","d","h")';
							$parallel_hold_msg = '';
							//only for parallel stage submission, if any one of the stages are not completed (Bug #1009	manage parallel stage decision buttons)
							if ($mode == 'hold') {
								$next_stage_where = ' FIND_IN_SET(aflw_jwf_id,(SELECT GROUP_CONCAT(REPLACE(REPLACE(REPLACE(jwf_child_stages,\'"\',\'\'),"]",""),"[","") SEPARATOR \',\') as childs from ' . $Generic_flows_table . ' where jwf_id IN (' . implode(",", json_decode($prev_stage->jwf_parent_stages)) . ')) )  AND aflw_art_id = ' . $article_id;
								$next_stage_fields = ' (select  GROUP_CONCAT(a1.jwf_stage_name SEPARATOR \',\' ) from rvw_journal_workflows a1 where FIND_IN_SET(a1.jwf_id,REPLACE(REPLACE(REPLACE(c_stg.jwf_child_stages,\'"\',\'\'),"]",""),"[","")))  as nex_stage_names';
								$child_stage_data = Article_flow::get_generic_flow($next_stage_fields, $next_stage_where);
								$temp_nxt_stage = '';
								if (count($child_stage_data) > 0) {
									foreach ($child_stage_data as $next_child) {
										$temp_nxt_stage .= ',' . $next_child->nex_stage_names;
									}
									$temp_nxt_arr = explode(',', $temp_nxt_stage);
									$temp_nxt_stage = array_unique($temp_nxt_arr);

									unset($temp_nxt_stage[0]);
									$temp_nxt_stage_str = implode(',', $temp_nxt_stage);
								}

								$parallel_hold_msg = str_replace('%next_stage%', $temp_nxt_stage_str, customTrans('viewarticle.parallel_stg_hold_msg'));
								$where = $next_stage_where . ' AND  (aflw_status = "u"  or aflw_status = "a")';
							}
							$modal_data['parallel_hold_msg'] = $parallel_hold_msg;
							$group_by = array('jwf_stage_name', 'aflw_usr_id');
							$select = 'jwf_role_id,jwf_stage_name, aflw_status, aflw_usr_id, jwf_assignment, jwf_parent_user_roles, jwf_who_can_invite, IF(jwf_assignment = "self_service", (SELECT role_name FROM rvw_roles WHERE role_id = jwf_role_id), "") AS user_role,jwf_stage_type';

							$next_stage_details = Article_flow::get_generic_flow($select, $where, null, $group_by);
							$loggined_role_id = $defaultroledata['role_id'];
							if (!empty($next_stage_details)) {
								foreach ($next_stage_details as $val) {

									$val->user_full_name = '';
									$val->who_can_assign = '';
									$val->who_can_invite = '';
									if ($this->current_client->modules->mdl_review_for_doc == 'y' && $val->jwf_stage_type === 'document_queue') {
										$modal_data['notify_msg'] = customTrans('viewarticle.document_status');
										$hide_actions = TRUE;
										$redirect_after_complete = 'y';
									} elseif ($val->aflw_usr_id != '') {
										$array_data['user_id'] = $val->aflw_usr_id;
										$array_data['journal_id'] = $jnl_id;
										$array_data['flag'] = TRUE;
										$array_data['article_id'] = $article_id;
										$array_data['jnl_code'] = $jnlcode;
										$userdata = $this->get_user_display_name($array_data);
										$val->user_full_name = $userdata;
										$next_array[$val->jwf_stage_name]['name'][] = $userdata;
										if ($val->aflw_usr_id == $this->current_user['user_id'] && $val->jwf_role_id == $loggined_role_id) {
											$redirect_after_complete = 'n';
										}
									}

									/* start -- checking assignment types and getting roles of that */
									if ($val->jwf_assignment == 'manual' || $val->jwf_assignment == 'invitation') {
										//echo '<pre>'; print_r($val); die;
										/* role who is assigning users */
										$assigning_roles = json_decode($val->jwf_parent_user_roles);
										$inviting_roles = array();
										$select = 'GROUP_CONCAT(role_name SEPARATOR ", ") AS roles';
										$where = 'role_id IN(' . implode(',', $assigning_roles) . ')';
										$who_can_assign = Roles::get_single_record($select, $where);

										$val->who_can_assign = $who_can_assign->roles;
										$next_array[$val->jwf_stage_name]['who_can_assign'] = $who_can_assign->roles;
										$next_array[$val->jwf_stage_name]['jwf_assignment'] = $val->jwf_assignment;
										if (in_array($loggined_role_id, $assigning_roles)) {
											$redirect_after_complete = 'n';
										}

										if ($val->jwf_assignment == 'invitation') {
											/* role who is inviting users */
											$inviting_roles = json_decode($val->jwf_who_can_invite);
											$shortlist_roles = json_decode($val->jwf_parent_user_roles);

											$select = 'GROUP_CONCAT(role_name SEPARATOR ",") AS roles';
											$where = 'role_id IN(' . implode(',', $inviting_roles) . ')';
											$who_can_invite = Roles::get_single_record($select, $where);

											$val->who_can_invite = $who_can_invite->roles;
											$next_array[$val->jwf_stage_name]['who_can_invite'] = $who_can_invite->roles;
											if (in_array($loggined_role_id, $shortlist_roles)) {
												$redirect_after_complete = 'n';
											}
										}

										$select = 'GROUP_CONCAT(role_id SEPARATOR ",") AS roles';
										$where = 'role_assigned_role ="staff"';
										$core_role_staff = Roles::get_single_record($select, $where);
										$core_role_staff_id = $core_role_staff->roles;
										$core_role_staffid_arr = explode(",", $core_role_staff_id);
										$staff_assigned = FALSE;
										$invite_staff = array_intersect($core_role_staffid_arr, $inviting_roles);
										$assign_staff = array_intersect($core_role_staffid_arr, $assigning_roles);
										if (count($invite_staff) > 0 || count($assign_staff) > 0) {
											$merge_arr = array_merge($invite_staff, $assign_staff);
											//check assignment exist , if yes then $staff_assigned
											$cond = 'usra_role_id IN(' . implode(',', $merge_arr) . ') and usra_art_id=' . $article_id;
											$User_articles = new \App\Models\User_articles;
											$record = $User_articles::get_single_record('count(usra_id) as cnt', $cond);
											if ($record->cnt > 0)
												$staff_assigned = TRUE;
										}
										$next_array[$val->jwf_stage_name]['staff_assigned'] = $staff_assigned;
										$select_des = 'role_name';
										$where_des = 'role_id =' . $val->jwf_role_id;
										$user_assign_role = Roles::get_single_record($select_des, $where_des);

										//$val->role_name = $user_assign_role->role_name;
										$next_array[$val->jwf_stage_name]['user_assign_role'] = $user_assign_role->role_name;
										$next_array[$val->jwf_stage_name]['assigned_usrs'] =  isset($data['who_can_assign']) ? $data['who_can_assign'] : '';
										$next_array[$val->jwf_stage_name]['invite_usrs'] =  isset($data['who_can_invite']) ? $data['who_can_invite'] : '';
									}
									$next_array[$val->jwf_stage_name]['user_role'] = $val->user_role;
									$next_array[$val->jwf_stage_name]['stage_name'] = $val->jwf_stage_name;
									/* end -- checking assignment types and getting roles of that */
									if ($val->jwf_role_id == $loggined_role_id && $val->jwf_stage_type != 'document_queue') {
										$redirect_after_complete = 'n';
									}
								}
								$modal_data['next_array'] = $next_array;
							}
						}
					}

					$modal_data['redirect_to'] = $redirect_to;
					$modal_data['hide_actions'] = $hide_actions;

					$modal_data['prev_stage_name'] = $prev_stage->jwf_stage_name;
					$modal_data['redirect_after_complete'] = $redirect_after_complete;
					$redirect_url = isset($form_data['redirect_url']) ? $form_data['redirect_url'] : '';

					//$redirect_url = $this->session->userdata('redirect_after_stage_completion');
					//$modal_data['redirect_url'] = ($redirect_url != "") ? $redirect_url : url('journal/' . $jnlcode);
					//$this->session->set_userdata('redirect_after_stage_completion',$redirect_url);
					$cfty_manage_popup_on_completion = $this->current_client->functionality->cfty_manage_popup_on_completion ?? 'n';
					$modal_data["headtitle"]="Next task assignment details";
					if (isset($next_array) && !empty($next_array)) {
						//echo "xxxx".$prev_stage->jwf_stage_type; die;
						/*check Current stage is Payment and Client functionality article payment bypass enable*/
						if ($prev_stage->jwf_stage_type == 'payment' && $this->current_client->functionality->cfty_enable_article_payment_bypass == 'y') {

							/*Get the Current article transaction Status */
							$Payment_order = new \App\Models\Payment_order();
							$article_payment_status = $Payment_order::get_single_record('pmt_transaction_status',            'pmt_ord_art_id=' . $article_id);
							/*Check Payment Status CheckoutComplete*/
							if ($article_payment_status->pmt_transaction_status == 'CC') {
								$modal_data['notify_msg'] = customTrans('viewarticle.payment_bypass_msg');
							}
						}

						/* Next task link */ //need to redo
						$next_link = '';
						$next_link_params='';
						 if (isset($this->current_client->functionality->cfty_next_task_button) && $this->current_client->functionality->cfty_next_task_button == 'y' && $section!='') {
							//$page = ($form_data['page'])?$form_data['page']:'';
							//$page_start =($form_data['page_start'])?$form_data['page_start']:'';
							//if ($page != "") {
								//$next_link = $this->get_next_task($page, $article_id, $jnl_id, $page_start);
								$next_link_params =$this->gotonextarticle($section,$jnl_id,$this->current_user['user_id'],$defaultroledata['role_id'],$article_id,$prev_aflw_id,$jnlcode,$category);
								if(!empty($next_link_params) && isset($next_link_params['flw_id']))
								{
									$newflwid=decrypt_link($next_link_params['flw_id']);
									if($newflwid==$prev_aflw_id)
									{
										$next_link_params='';
									}
								}
							

							//}
						}
						if ($cfty_manage_popup_on_completion == 'y') {
							if(isset($prev_stage->jwf_enable_popup_after_completion) && $prev_stage->jwf_enable_popup_after_completion == 'y'){
								$modal_data["popup_on_completion_status"] = 3;
							}else{
								$modal_data["popup_on_completion_status"] = 2;
								$modal_data['notify_msg'] = str_replace('%STAGE_NAME%', $prev_stage->jwf_stage_name, customTrans('viewarticle.stage_cmpt'));
							}
						}
						$modal_data['next_link'] = $next_link_params;
						//$model_info = $this->load->view('view_article_modification/assigned_user_model', $modal_data, TRUE);
					} else {
						$modal_data["popup_on_completion_status"] = 2;
						$modal_data['notify_msg'] = str_replace('%STAGE_NAME%', $prev_stage->jwf_stage_name, customTrans('viewarticle.stage_cmpt'));
						$modal_data['hide_actions'] = $hide_actions;
						//echo "Ssss";
						if ((isset($review_config[$prev_stage->jwf_stage_type]['milestone_stage']) && $review_config[$prev_stage->jwf_stage_type]['milestone_stage'] == TRUE) || ($cfty_manage_popup_on_completion == 'y' && (isset($prev_stage->jwf_enable_popup_after_completion) && $prev_stage->jwf_enable_popup_after_completion == 'y'))) {
							//echo "vvv"; die;
							//$modal_data['notify_msg'] = str_replace('%STAGE_NAME%', $prev_stage->jwf_stage_name, customTrans('viewarticle.stage_cmpt'));
							$modal_data["popup_on_completion_status"] = 3;
							$modal_data['next_array'] = array();
							$modal_data["headtitle"]="Completed stage details";
							// $model_info = $this->load->view('view_article_modification/assigned_user_model', $modal_data, TRUE);
						}
					}
				}
			}
			$return_arr = array(
				'status' => 'success',
				'modal_data' => $modal_data,
			);
			//Task#366-Generic solution to switch on/off popup after completing a step
			if ($show_modal == 'redirect') {
				//$redirect_url = $this->input->post('redirect_url');
				$return_arr['redirect_url'] = ($redirect_url != "") ? $redirect_url : url('journal/' . $jnlcode);
			}
		}
		return  $this->success('Success', 200, $return_arr);
	} catch (\Exception $e) {

		return  $this->failure('Failed', 500, $e);
	}
}
public function gotonextarticle($section,$jnl_id,$user_id,$role_id,$art_id,$art_flow_id,$jnlcode,$category)
    {
       	$nextstage_paras=array();
        $Article_next_task = new \App\Models\Article_next_task();
        $condition="ant_usr_id=".$user_id." and ant_jnl_id=".$jnl_id." and ant_role_id=".$role_id." and ant_type='{$section}'";
		if($category!='')
		$condition.=" and ant_section='".$category."'";
        $next_task_record = $Article_next_task::get_single_record('ant_article_list,ant_filter_list,ant_section',$condition);
		if(!empty($next_task_record))
        {
			$articlelist = json_decode($next_task_record->ant_article_list,TRUE);
            $art_arr = array_keys($articlelist);
            $flow_arr =array_values($articlelist);

			$index = array_search($art_id,$art_arr);
			if($index!='' && $index > -1)
            {
				$totalarr=count($art_arr);
				if($totalarr==$index+1)
                {
					$request = new Request();
					$ant_filter_list = json_decode($next_task_record->ant_filter_list,TRUE);
					$ant_filter_list['page']=$ant_filter_list['page']+1;
					$ant_filter_list['movenext']=TRUE;
					//echo '<pre>'; print_r($ant_filter_list); die;
					$request->merge($ant_filter_list);
                    // Call the second function and pass the modified request
					if($section == 'd')
					{
                    	$data = $this->load_todo($request);
					}
					else{
						$data = $this->load_tileArticlelist($request);
					}
					if(!empty($data->original['result']['stages']))
					{
						//echo "dddd"; die;
						$condition="ant_usr_id=".$user_id." and ant_jnl_id=".$jnl_id." and ant_role_id=".$role_id." and ant_type='{$section}'";
        				$next_task_record = $Article_next_task::get_single_record('ant_article_list,ant_filter_list',$condition);
						$articlelist = json_decode($next_task_record->ant_article_list,TRUE);
						$art_arr = array_keys($articlelist);
            			$flow_arr =array_values($articlelist);
						$nextstage_paras['art_id']=$this->encrypt_data($art_arr[0]);
						$nextstage_paras['flw_id']=$this->encrypt_data($flow_arr[0][0]);
						$nextstage_paras['type']=$section;
						$nextstage_paras['section']=$category;
						return $nextstage_paras;

					}
					else{
						//echo "vvv"; die;
						$request = new Request();
						$ant_filter_list = json_decode($next_task_record->ant_filter_list,TRUE);
						$ant_filter_list['page']=1;
						if($section == 'o')
						{
							$ant_filter_list['section']=encrypt_link('overview');
						}
						else if($section == 't'){
							$ant_filter_list['section']=encrypt_link($next_task_record->ant_section);
						}
						$request->merge($ant_filter_list);
						if($section == 'd')
						{
						$data = $this->load_todo($request);
						}
						else{
							$data = $this->load_tileArticlelist($request);
						}
						$condition="ant_usr_id=".$user_id." and ant_jnl_id=".$jnl_id." and ant_role_id=".$role_id." and ant_type='{$section}'";
        				$next_task_record = $Article_next_task::get_single_record('ant_article_list,ant_filter_list',$condition);
						$articlelist = json_decode($next_task_record->ant_article_list,TRUE);
						$art_arr = array_keys($articlelist);
            			$flow_arr =array_values($articlelist);
						$nextstage_paras['art_id']=$this->encrypt_data($art_arr[0]);
						$nextstage_paras['flw_id']=$this->encrypt_data($flow_arr[0][0]);
						$nextstage_paras['type']=$section;
						$nextstage_paras['section']=$category;
						return $nextstage_paras;
					}
                }
                else{
                    $flowdata =$flow_arr[$index];
                    if(count($flowdata)==1)
                    {
                        $nextstage_paras['art_id']=$this->encrypt_data($art_arr[$index+1]);
                        $nextstage_paras['flw_id']=$this->encrypt_data($flow_arr[$index+1][0]);
						$nextstage_paras['type']=$section;
						$nextstage_paras['section']=$category;
                    }
                    else{
                        $indexdata = array_search($art_flow_id, $flowdata);
						if(isset($flowdata[$indexdata+1]))
                        {
							$nextstage_paras['art_id']=$this->encrypt_data($art_arr[$indexdata]);
                            $nextstage_paras['flw_id']=$this->encrypt_data($flowdata[$indexdata+1]);
							$nextstage_paras['type']=$section;
							$nextstage_paras['section']=$category;
                        }
                        else{
                            $nextstage_paras['art_id']=$this->encrypt_data($art_arr[$index+1]);
                            $nextstage_paras['flw_id']=$this->encrypt_data($flow_arr[$index+1][0]);
							$nextstage_paras['type']=$section;
							$nextstage_paras['section']=$category;
                        }
                    }
                    return $nextstage_paras;
                }
            }
			else{
				$nextstage_paras['art_id']=$this->encrypt_data($art_arr[0]);
				$nextstage_paras['flw_id']=$this->encrypt_data($flow_arr[0][0]);
				$nextstage_paras['type']=$section;
				$nextstage_paras['section']=$category;
				return $nextstage_paras;
			}
		}
	}

    public function get_deleted_articles(Request $request)
	{
		try {
			$form_data = $request->all();
			$Article_table = (new \App\Models\Articles())->getTable();
            $Article_type_table = (new \App\Models\Article_types())->getTable();
			$jnl_code = isset($form_data['jnlcode']) ? $form_data['jnlcode'] : '';
			$jnl_id = isset($form_data['jnl_id']) ? $form_data['jnl_id'] : '';
			$sort_field = $form_data['sort_field'] ? $form_data['sort_field'] : 'art_id';
            $sort_order = $form_data['sort_order'] ? $form_data['sort_order'] : 'asc';
			$limit = 10;
			// $limit = $form_data['per_page'] ?? 10;
			$this->current_user = $this->get_current_user_details();
			$user_roles = $this->validate_user_journal($jnl_code, $this->current_user['user_id'] );
			$delete_permission_roles = array();
			if (isset($this->current_client->functionality->cfty_enable_article_delete) && $this->current_client->functionality->cfty_enable_article_delete == 'y')
			{
				if (isset($user_roles['role_id']))
				{
					$jset_delet_permission = Journal_settings::get_single_record('jset_manage_article', "jset_jnl_id={$jnl_id}");
					$delete_permission_roles = ($jset_delet_permission->jset_manage_article != NULL) ? json_decode($jset_delet_permission->jset_manage_article) : array();
					$permitted_role = array_intersect($delete_permission_roles, $user_roles['role_id']);
					if (count($permitted_role) > 0)
					{
						$can_delete = 'y';
					}
				}
			}
			$select = 'art_id,art_code,art_title,artp_article_type,art_delete_status,art_delete_reason';
            $tables = array(
                'main_table' => $Article_table,
                'join_table' => $Article_type_table,
                'column_prefix1' => $Article_table . '.art_artp_id',
                'column_prefix2' => $Article_type_table . '.artp_id',
            );
			$criteria ="art_delete_status='y' AND artp_jnl_id = {$jnl_id}";
			$art_delete_data =  Articles::get_results_join_pagination($tables, $select, $criteria, null, $sort_field, $sort_order, $limit);
			// $art_delete_data = Articles::get_paginated_records('*', $where, $sort_field, $sort_order, $limit);
			$return_array['article_delete'] =$art_delete_data;
			return $this->success('success',200,$return_array);
		}
		catch(\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}
	public function get_parentflow(Request $request)
	{
		try {
			$form_data = $request->all();
			$flow = isset($form_data['flow']) ? decrypt_link($form_data['flow']) : '';
			$this->current_user = $this->get_current_user_details();
			if(!empty($flow))
			{
				$aflw_parent_flow_id = NULL;
				$Article_flow = new \App\Models\Article_flow();
				//$stage_assigned = $Article_flow::get_single_record('aflw_parent_flow_id', 'aflw_id=' . $flow);
				$stage_assigned = $Article_flow::get_single_record_with_bind_cond('aflw_parent_flow_id', ['aflw_id' => $flow]);
				if(!empty($stage_assigned))
				{
					$aflw_parent_flow_id=$stage_assigned->aflw_parent_flow_id;
				}
				$return_array['parent_flow_id']=$aflw_parent_flow_id;


			}
			return $this->success('success',200,$return_array);
		}
		catch(\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}


	public function fetch_legacy_articles(Request $request) {
		try {
			if ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y')
			{
				$Article_legacydata 	= 	new \App\Models\Article_legacydata;
				$User 					= 	new \App\Models\User;
				$Journals				= 	new \App\Models\Journals;

				$form_data 		= 	$request->all();
				$core_role 		= 	isset($form_data['user_role']) ? decrypt_link($form_data['user_role']) : '';
				$jnl_code 		= 	isset($form_data['jnl_code']) ? decrypt_link($form_data['jnl_code']) : '';
				$search 		= 	isset($form_data['search']) ? $form_data['search'] : '';
				$check_pri_roles= 	FALSE;
				$this->current_user = 	$this->get_current_user_details();
				$user_id 			=	$this->current_user['user_id'];
				$usr_name 			=	'';
				$total_records		=	0;
				$usr_record 		= 	$User::get_single_record('usr_title, concat_ws(" ",usr_first_name,IF(usr_middle_name = "",\'null\',usr_middle_name),usr_last_name) as usr_name', 'usr_id='.$user_id);
				if(!empty($usr_record)) {
					$usr_name 	=	($usr_record->usr_title !='' ? $usr_record->usr_title.' ' : '').$usr_record->usr_name;
				}
				$return_data	=	array('status' => 'failed',
										'redirect_link' =>'',
										'jnl_code' =>$jnl_code,
										'data' => array(),
										'article_types' => array(),
										'usr_name' =>$usr_name,
										'head_lbl' => '',
										'total_records' => $total_records
									);

				if (isset($core_role) && $core_role != '')
				{
					$conditions 	=	'';
					$currentClient  = 	$this->current_client;
					$dateFormat 	= 	$currentClient->settings->cs_date_format;
					$return_data['head_lbl']	=	$this->get_legacy_head_label($core_role);

					$journalData 	= 	$Journals::get_single_record('jnl_id', 'jnl_journal_code="'.$jnl_code.'"');
					$jnl_id 		=	'';
					if(!empty($journalData)) {
						$jnl_id 			=	$journalData->jnl_id;
						$jset_date_format 	=  $this->get_platform_date_format($jnl_id);
						$jset_date_format 	=  $this->get_platform_date_format($jnl_id);
						if (isset($jset_date_format) && !empty($jset_date_format)) {
							$dateFormat 	= $jset_date_format;
						}
					} else {
						$dateFormat 	= $currentClient->settings->cs_date_format;
					}
					$dateFormat = date_format_map($dateFormat);

					if ($core_role == 'author')
					{
						$check_pri_roles = TRUE;
						if ($core_role == 'author')
						{
							$conditions 	=	'arld_decision != "s" AND arld_submitted_by = '.$user_id;
							$art_condition 	=	'arld_submitted_by = '.$user_id;
						}
						else
						{
							$conditions 	=	'arld_submitted_by != '.$user_id.' AND FIND_IN_SET(' . $user_id . ',arld_author_id) != 0';
							$art_condition 	=	'arld_submitted_by != '.$user_id.' AND FIND_IN_SET(' . $user_id . ',arld_author_id) != 0';
						}
						$return_data['status']	=	'success';
					}
					else if ($core_role == 'reviewer')
					{
						$check_pri_roles = TRUE;
						$conditions 	=	'FIND_IN_SET(' . $user_id . ',arld_reviewers) != 0';
						$art_condition 	=	'FIND_IN_SET(' . $user_id . ',arld_reviewers) != 0';
						$return_data['status']	=	'success';
					}
					else if ($core_role == 'editor_in_chief')
					{
						$check_pri_roles = TRUE;
						$conditions 	=	'FIND_IN_SET(' . $user_id . ',arld_editors) != 0';
						$art_condition 	=	'FIND_IN_SET(' . $user_id . ',arld_editors) != 0';
						$return_data['status']	=	'success';
					}
					else if ($core_role == 'staff')
					{
						$check_pri_roles = TRUE;
						$conditions 	=	"arld_art_pre_all_ids IS NULL";
						$art_condition 	=	'';
						$return_data['status']	=	'success';
					}

					if ($check_pri_roles == FALSE) {
						$return_data['redirect_link']	=	url('journal/' . $jnl_code);
					}

					$conditions	.=	' AND arld_jnl_id = '.$jnl_id;

					if(is_array($search) == true) {
						foreach($search as $key => $val){
							if($val != '') {
								if($key == 'article_code') {
									$conditions	.=	' AND arld_article_code LIKE "%'.decrypt_link($val).'%"';
								}
								if($key == 'article_title') {
									$conditions	.=	' AND arld_article_title LIKE "%'.decrypt_link($val).'%"';
								}
								if($key == 'article_type') {
									$conditions	.=	' AND arld_article_type LIKE "%'.decrypt_link($val).'%"';
								}
							}
						}
					}

					$records 		= 	$Article_legacydata::get_single_record('count(*) as cnt', $conditions);
					$total_records 	= 	$records->cnt;
					if ($total_records != 0)
					{
						$select 		= 	'*, DATE_FORMAT(arld_submission_date, "' . $dateFormat . '  %h:%i %p") as arld_submission_date';
						$limit 			= 	$form_data['per_page'] ?? 10;
						$data 			= 	$Article_legacydata::get_paginated_records($select, $conditions, 'arld_id', 'asc', $limit);
						$article_type 	= 	$Article_legacydata::get_all_records('arld_article_type', $art_condition, NULL, NULL, NULL, NULL, 'distinct');
						if(count($article_type)) {
							foreach ($article_type as $val) {
								$return_data['article_types'][]	=	$val->arld_article_type;
							}
						}
						if(count($data)) {
							foreach ($data as $val) {
								$return_data['data'][]	=	$val;
							}
						}
					}
					$return_data['total_records']	=	$total_records;
				}
				return  $this->success('Success', 200, $return_data);
			} else {
				$form_data 		= 	$request->all();
				$jnl_code 		= 	isset($form_data['jnl_code']) ? decrypt_link($form_data['jnl_code']) : '';
				$return_data	=	array('status' => 'failed',
										'redirect_link' =>url('journal/' . $jnl_code),
										'jnl_code' =>$jnl_code,
										'data' => array(),
										'article_types' => array(),
										'usr_name' =>'',
										'head_lbl' => '',
										'total_records' => $total_records
									);
				return  $this->failure('Failed', 200, $return_data);
			}
		}
		catch(\Exception $e) {

			return  $this->failure('Failed',500,$e);
		}
	}

	public function user_sort_inner_tiles_save(Request $request)
	{
		try
		{
			$post_data =$request->all();
			$User_journal_tile_sort_keys=new \App\Models\User_journal_dashboard_tile_sort_keys();
			$validator = Validator::make($request->all(), [
				'jnl_id' => 'required',

			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			else
			{
			if ($post_data != NULL)
			{
				$sortdata=$post_data['store_data'];
				$section = decrypt_link($post_data['section']);
				$section_str =  $section;
				$type = '';
				if(isset($post_data['type']) && !empty($post_data['type']))//for overview
				{
					$type = decrypt_link($post_data['type']);
					$title_name = decrypt_link($post_data['title']);
					$section_str = $type . '#' . str_replace(' ','_',$title_name);
				}
				if(isset($sortdata['sort_type'])&&$sortdata['sort_type']!=''&&isset($sortdata['order'])&&($sortdata['order']!=''))
				{
					if (isset($this->current_client->functionality->cfty_show_minimised_sort)&&($this->current_client->functionality->cfty_show_minimised_sort == 'y'))
					{
						$sortarray[$sortdata['sort_type']]=$sortdata['order'];
						$sortjsondata=json_encode($sortarray);
					}
					else
					{
						$string_version = '{"';
						$string_version .= implode('":"'.$sortdata['order'].'","', $sortdata['sort_type']);
						$string_version .= '":"'.$sortdata['order'];
						$string_version .= '"}';
						$sortjsondata=$string_version;
					}
					$jnl_id=$post_data['jnl_id'];
					$this->current_user=$this->get_current_user_details();
					$data_store=custom_json_encode($post_data['store_data']);
					$condition="ujdtsk_usr_id={$this->current_user['user_id']} AND ujdtsk_jnl_id={$jnl_id}";
					$result =$User_journal_tile_sort_keys::get_single_record('count(ujdtsk_id) as cnt,ujdtsk_id, ujdtsk_sort_keys', $condition);
					if ($result->cnt > 0)
					{
						$db_filter_data = json_decode($result->ujdtsk_sort_keys);
						$db_filter_data->$section_str = $sortjsondata;
						$condition = 'ujdtsk_id = '.$result->ujdtsk_id;
						$update_arr = array(
							'ujdtsk_sort_keys' => json_encode($db_filter_data));
						$result = $User_journal_tile_sort_keys::update_record($update_arr, $condition, $this->current_user);
					}
					else
					{
						$filter_arr  = array(
							$section_str => $sortjsondata
							);
						$data = array(
							'ujdtsk_usr_id' => $this->current_user['user_id'],
							'ujdtsk_jnl_id' => $jnl_id,
							'ujdtsk_sort_keys'=>json_encode($filter_arr)
							);
						$result =$User_journal_tile_sort_keys::insert_record($data, $this->current_user);
					}
				}
				if ($result)
					$return_array['status'] = "success";
					return  $this->success('Success',201,$return_array);
				}
			}
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',500,$e);
		}
	}
	public function getrole_retirestatus_dashboard(Request $request)
	{
		try{
			$post_data =$request->all();
			$this->current_user=$this->get_current_user_details();
			$return_array['adhoc_submission']=false;
			if(isset($post_data['role_id']) && isset($post_data['jnl_id']) && (!empty($post_data['role_id'])))
			{
			$return_array['user_retire_status'] = $this->get_user_role_retire($post_data['role_id'],$this->current_user['user_id'],$post_data['jnl_id']);
		    }
			else{
			$return_array['user_retire_status'] ='';
			   }
	    /*Task #870 join as author button management in no adhoc submission*/	
		$return_array['adhoc_submission'] =false;	   
		if(isset($post_data['jnl_id']))
		{
			$article_type=$this->get_adhoc_submission_type_data($post_data['jnl_id']);
			if($article_type->cnt>0)
			{
				$return_array['adhoc_submission'] =true;
			}
			
		}
		/*Task #870 */
			   return  $this->success('Success',201,$return_array);

			
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',500,$e);
		}
	}
	 public function save_legacy_article(Request $request)
	{
		try {
			$return_data	= array();
			$post_data		= $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_id'	=> 'required',
				'file'      => 'required',
			]);
			if ($validator->fails()) {
				$return_data    = array(
					'status' => 'error',
					'msg'    => customTrans('platform_settings.processing_error')
				);
				return $this->success('success', 200, $return_data);
			}
			$import_journal			= $this->decrypt_data($post_data['jnl_id']);
			if (!empty($post_data) && isset($post_data['file'])) {
				$filename=$post_data['file']->getClientOriginalName();
				$baseDirectory = 'public/uploads/legacy';
				$path 		 = $post_data['file']->storeAs($baseDirectory, $filename);
				$return_data = $this->read_upload_file($path, $import_journal);
				// unlink(storage_path() . '/app/' . $path);
				return $this->success('success', 200, $return_data);
			} else {
				$return_data = array(
					'status' => 'warning',
					'msg'    => customTrans('platform_settings.uploaded_file_not_found'),
				);
				// print_r($return_data);die;
				return $this->success('success', 200, $return_data);
			}
		} catch (\Exception $e) {
			// print_r($e);die;
			return  $this->failure('Failed', 500, $e);
		}
	}


	public function parseDate($dateStr)
	{
		$dateStr = trim($dateStr);
		if (empty($dateStr)) return null;
	
		$normalizedDate = str_replace(['/', '.', ','], '-', $dateStr);
	
		$formats = ['d-m-y', 'd-m-Y', 'Y-m-d', 'm-d-Y'];
	
		foreach ($formats as $format) {
			try {
				$date = Carbon::createFromFormat($format, $normalizedDate);
				if ($date !== false) {
					return $date->format('Y-m-d H:i:s');
				}
			} catch (\Exception $e) {
				error_log("Carbon failed with format $format: $dateStr");
	
			}
		}

		return null;
	}
		
	public function read_upload_file($path, $import_journal)
	{
       try{
		$i = 0;
		$email_exist_cnt = 0;
		$return_data    = array(
			'status' => 'error',
			'msg'    => ''
		);
		//uploaded csv must contain following fields.
		$required_columns = array('arld_article_code', 'arld_article_title', 'arld_article_abstract','arld_author_id');
		$file_path		= storage_path() . '/app/' . $path;
		$file_read 		= fopen($file_path, 'r');
		$fields         = fgetcsv($file_read);
		$keys	= $this->escape_string($fields);
        $csvData = array();
		$db_fields1 = Article_legacydata::get_field_names();
		$db_fields2 = Article_legacy_author_list::get_field_names();
		$db_fields = array_merge($db_fields2, $db_fields1);
		$this->current_user=$this->get_current_user_details();
			//check whether the uploaded csv has the necessary columns
			$missing_columns = array_diff($required_columns, $keys);

			if (!empty($missing_columns)) {
				$missing_columns_str = '';
	
				if (count($missing_columns) > 1) {
					$last_column = array_pop($missing_columns);
					$missing_columns_str = implode(', ', $missing_columns) . ' and ' . $last_column;
				} else {
					$missing_columns_str = implode(', ', $missing_columns);
				}
				$return_data = array(
					'status' => 'warning',
					'msg'    => customTrans('legacyarticle.mandatory-fields-missing') . ' ' . $missing_columns_str
				);
				return $return_data;
			} else {

			$csvData_author = array();
			$csvData_article = array();
			$no_user_array = array();
			$jnl_code='';
			$jnls = Journals::get_single_record_with_bind_cond('jnl_journal_code', array(
				'jnl_id' => $import_journal));
			$jnl_code =$jnls->jnl_journal_code;
			$no_decision_article_codes = [];
			$line_number = 0;
			while (($row = fgetcsv($file_read)) !== FALSE)
			{
				$line_number++;
				// Skip empty lines
				array_filter($row, function($value)
				{
					return !is_null($value) && $value !== '';
				});

				if (empty($row))
				{
					unset($row);
				}
				if (isset($row))
				{

					if ($row != NULL)
					{
						$values = $row;

						$handle_array = array();
						if (count($keys) == count($values))
						{

							foreach ($keys as $k)
							{
								$ky = explode('_', $k);
								$k1 = $ky[0];
								if ($k1 == "arld")
								{
									$handle_array[] = "arld";
								}
								else
								{
									$handle_array[] = "lauth";
								}
							}



							$new_values = $values;
							$val = array_search('arld_decision_reason', $keys);

							$decision_date = array_search('arld_decision_date', $keys);
							$article_code_val = array_search('arld_article_code', $keys);
							$article_title = array_search('arld_article_title', $keys);
							$article_abstract = array_search('arld_article_abstract', $keys);
							$author_id = array_search('arld_author_id', $keys);
							$date_value = trim($new_values[$decision_date]);
							if (empty($date_value) || preg_match('/[a-zA-Z]/', $date_value)) {
								$is_valid_date = null; 
							} else {
								$is_valid_date = $this->parseDate($date_value);
							}
							//if ((strpos($new_values[$val], 'Accept') == FALSE && strpos($new_values[$val], 'Reject') == FALSE && strpos($new_values[$val], 'Transfer') == FALSE && strpos($new_values[$val], 'Withdrawn') == FALSE) || empty($new_values[$decision_date]))
							$reasons = ['ACCEPT', 'REJECT','TRANSFER'];
							$reason_value = strtoupper($new_values[$val]);
							if (!in_array($reason_value, $reasons) || empty($new_values[$decision_date]) || !$is_valid_date || empty($new_values[$article_code_val]) || empty($new_values[$article_title]) || empty($new_values[$article_abstract]) || empty($new_values[$author_id])) {
								
								$article_code = $new_values[$article_code_val];
								if (empty($article_code)) {
									$no_decision_article_codes[] = "Row $line_number (missing article code)";
								} else {
									$no_decision_article_codes[] = $article_code;
								}
							
								continue; 
							}
							else
							{

								$val = array_search('arld_article_code', $keys);
								$article_code = $new_values[$val];
								$records = Article_legacydata::get_single_record_with_bind_cond('arld_id', array(
									'arld_article_code' => $article_code));
								if(empty($records))
								{
									$val = array_search('arld_author_id', $keys);

									$author_ids = explode("###",$new_values[$val]);
									//$author_id = $new_values[$val];
									foreach($author_ids as $author_id)
									{
										$legacy_author = User::get_single_record_with_bind_cond('usr_id', array(
										'usr_id' => $author_id));
										if(!empty($legacy_author))
										{
											$legacy_author_id=$legacy_author->usr_id;
										}

									}
									if(empty($legacy_author))
									{
										$no_user_array['articles'][]=$article_code;
									}
									//echo "<pre>";print_r($author_ids);die;
								}


								if (empty($records) && !empty($legacy_author))
								{
									$keys_article = array();
									$keys_author = array();
									$data_article = array();
									$data_author = array();

									for ($j = 0; $j < count($keys); $j++)
									{
										if ($keys[$j] != "" && in_array($keys[$j], $db_fields))
										{
											if ($handle_array[$j] == "arld")
											{
												$keys_article[] = $keys[$j];
												if ($keys[$j] == "arld_article_abstract" || $keys[$j] == "arld_article_title" || $keys[$j] == "arld_fundref" || $keys[$j] == "arld_article_type")
												{
													$data_article[] = str_replace('###',';',htmlspecialchars(addslashes($new_values[$j])));
												}
												elseif ($keys[$j] == "arld_author_id")
												{
													$data_article[] = $legacy_author_id;
													$data_author[] = $legacy_author_id;
													$data_author[] = 'y';
													$keys_author[] = 'lauth_usr_id';
													$keys_author[] = 'lauth_submit_author';

													$keys_article[] = 'arld_submitted_by';
													$data_article[] = $legacy_author_id;
													$keys_article[] = 'arld_legacy_status';
													$data_article[] = 'y';
												}
												elseif ($keys[$j] == "arld_article_code")
												{

													$data_article[] = $new_values[$j];
													$data_author[] = $new_values[$j];
													$keys_author[] = 'lauth_art_id';
												}
												elseif ($keys[$j] == "arld_decision_reason")
												{
													$data_article[] = $new_values[$j];
													$keys_article[] = 'arld_decision';
													if (strpos($new_values[$j], 'Accept') !== false)
													{
														$data_article[] = 'a';
													}
													elseif (strpos($new_values[$j], 'Reject') !== false)
													{
														$data_article[] = 'r';
													}
													elseif (strpos($new_values[$j], 'Transfer') !== false)
													{
														$data_article[] = 't';
													}
													else
													{
														$data_article[] = 'n';
													}
												}
										
												else if ($keys[$j] == "arld_submission_date") {
													$submission_date = $this->parseDate($new_values[$j]);
													
													if ($submission_date !== null) {
														$data_article[] = $submission_date;
														$data_author[] = $submission_date;
														$keys_author[] = 'lauth_submission_date';
													} else {
														$data_article[] = null;
														$data_author[] = null;
														$keys_author[] = 'lauth_submission_date';
														error_log("Invalid date format for arld_submission_date: " . $new_values[$j]);
													}
												}
												
												elseif ($keys[$j] == "arld_most_recent_decision_date")
												{
													if (!empty($new_values[$j]))  // Check for non-empty value
													{
														$recent_decision_date = $this->parseDate($new_values[$j]);
														$data_article[] = ($recent_decision_date !== null) ? $recent_decision_date : null;
													}
													else
													{
														$data_article[] = null; // Explicitly set NULL instead of empty string
													}
												}
												
												elseif ($keys[$j] == "arld_decision_date") {
													if ($new_values[$j] != '') {
														$decision_date = $this->parseDate($new_values[$j]);
														if ($decision_date !== null) {
															$data_article[] = $decision_date;
														} else {
														
															$data_article[] = null;
														}
													} else {
														$data_article[] = null;
													}
												}
												
												else
												{
													$data_article[] = $new_values[$j];
												}
											}
											else
											{

												//$data_author[] =$new_values[$j];
												if ($keys[$j] == "lauth_address" || $keys[$j] == "lauth_institution" || $keys[$j] == "lauth_address" || $keys[$j] == "lauth_city" || $keys[$j] == "lauth_country")
												{
													$data_author[] =str_replace('###',';',htmlspecialchars(addslashes($new_values[$j])));

												}
												else
												{
													$data_author[] = $new_values[$j];
												}
												$keys_author[] = $keys[$j];
											}
										}
									}
									$data_article[] = $import_journal;
									$keys_article[] = 'arld_jnl_id';
									$csvData_article[] = $data_article;
									$csvData_author[] = $data_author;
								}
							}


							$i++;
						}
					}
					else
					{
						$return_data    = array(
							'status' => 'error',
							'msg'    => 'No records were found in the uploaded file.'
						);
						return $return_data;
					}
				}
			}

			if (!empty($csvData_article))
			{

				//echo '<pre>'; print_r($csvData_article); die;

				$keys_articles = implode(',', $keys_article);
				$article_sql = "insert ignore into rvw_article_legacydata ($keys_articles) values ";
				//echo count($csvData_article); die;
				//echo '<pre>';	print_r($keys_article);

				for ($i = 0; $i < count($csvData_article); $i++)
				{
					//echo '<pre>'; print_r($csvData_article[$i]);
					//$csvData_article_values=implode(',',$csvData_article[$i]);
					$csvData_article_values = "'" . implode("', '", $csvData_article[$i]) . "'";
					if ($i > 0)
						$article_sql .= ",";
					$article_sql .= "(" . $csvData_article_values . ")";
				}
				//echo $article_sql; die;
				Article_legacydata::execute_query($article_sql);

				$val = array_search('lauth_art_id', $keys_author);
				$author_val = array_search('lauth_usr_id', $keys_author);
				foreach ($csvData_author as $cs => $value)
				{
					$art_code = $value[$val];
					$records = Article_legacydata::get_single_record_with_bind_cond('arld_id', array(
						'arld_article_code' => $art_code));
					$csvData_author[$cs][$val] = $records->arld_id;

					$author_value = $value[$author_val];
					//echo $author_val; die;
					$role_data = Roles::get_single_record_with_bind_cond('role_id', array('role_assigned_role' => "author"));
					$role_id = $role_data->role_id;
					$role_data = User_to_journals::get_single_record_with_bind_cond('usrj_id', array('usrj_usr_id' => $author_value,'usrj_jnl_id'=>$import_journal,'usrj_role_id'=>$role_id));
					if(empty($role_data))
					{
						$insert_array=array(
							'usrj_usr_id'=>$author_value,
							'usrj_jnl_id'=>$import_journal,
							'usrj_role_id'=>$role_id
						);
						 $insert_id = User_to_journals::insert_record($insert_array,$this->current_user);
					}

				}



				$keys_authors = implode(',', $keys_author);
				$author_sql = "insert ignore into rvw_legacy_article_author_list ($keys_authors) values ";
				//echo '<pre>';	print_r($csvData_author); die;
				//echo '<pre>';	print_r($keys_author);

				for ($i = 0; $i < count($csvData_author); $i++)
				{
					//echo '<pre>'; print_r($csvData_author[$i]);
					//die;
					$csvData_article_values = implode(',', $csvData_author[$i]);
					$csvData_author_values = "'" . implode("', '", $csvData_author[$i]) . "'";
					if ($i > 0)
						$author_sql .= ",";
					$author_sql .= "(" . $csvData_author_values . ")";

				}

				//echo $article_sql; die;
				Article_legacy_author_list::execute_query($author_sql);

				$sqla="UPDATE rvw_article_legacydata SET arld_art_previous_id = NULL WHERE arld_art_previous_id=0";
				Article_legacydata::execute_query($sqla);
				$no_decision_article_codes_string ='';
				 if (!empty($no_decision_article_codes)) {
					$comma_separated_string = implode(',', $no_decision_article_codes);
					$no_decision_article_codes_string = $comma_separated_string; // Include the missing codes
				}
				$return_data    = array(
					'status' => 'success',
					'msg'    => customTrans('legacyarticle.imprt-sucs'),
					'no_user' =>$no_user_array,
					'no_decision_article_codes'=>$no_decision_article_codes_string

				);
				$org_path = 'public/uploads/legacy/no_user_legacy_'.$jnl_code.'.txt';
				$file_paths = storage_path() . '/app/' . $org_path;
				file_put_contents($file_paths, json_encode($no_user_array),FILE_APPEND);
			}
			else
			{
				if(!empty($records))
				{
					$return_data    = array(
						'status' => 'empty_row_error',
						'msg'    => customTrans('legacyarticle.data-exist'),
					);
				}
				else if (!empty(array_filter($no_decision_article_codes))) {
					$article_codes_string = implode(',', $no_decision_article_codes);
	
					$return_data = array(
						'status' => 'empty_row_error',
						'msg' => customTrans('legacyarticle.imported_article') . " " . $article_codes_string . "."
					);
				}
				else
				{
					$return_data    = array(
						'status' => 'empty_row_error',
						'msg'    => customTrans('legacyarticle.no-record'),
					);
				}


			}
		}

		// Close opened CSV file
		fclose($file_read);
		if (file_exists($file_path))
		{
			unlink($file_path);
		}

//        print_r();die;
       return $return_data;
	} catch (\Exception $e) {
		return  $this->failure('Failed', 500, $e);
	}
	}
	public function fetch_legacy_article_data(Request $request)
	{
		try{
			$form_data = $request->all();
			$paramsdet = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
			$currentClient   = $this->current_client;
			$dateFormat = $currentClient->settings->cs_date_format;
			$condition = "arld_id IS NOT NULL ";
			 $dateFormat = date_format_map($dateFormat);
			 if (isset($paramsdet['journal_name']) && $paramsdet['journal_name'] != '') {
				$paramsdet['journal_name'] = trim($paramsdet['journal_name']);

				$condition = $condition. " AND `jnl_journal_name` LIKE '%{$paramsdet['journal_name']}%' ";
			}
			if (isset($paramsdet['article_title']) && $paramsdet['article_title'] != '') {
				$paramsdet['article_title'] = trim($paramsdet['article_title']);
				$condition = $condition . " AND `arld_article_title` LIKE '%{$paramsdet['article_title']}%' ";
			}
			if (isset($paramsdet['article_id']) && $paramsdet['article_id'] != '') {
				$paramsdet['article_id'] = trim($paramsdet['article_id']);
				$condition = $condition . " AND `arld_article_code` LIKE '%{$paramsdet['article_id']}%' ";
			}
			if (isset($post_data['sort_field']) && $post_data['sort_field'] != ''){
				if($post_data['sort_field'] == 'userfullname') {
					$sort_field = 'usr_first_name';
				}
				else
				{
					$sort_field =$post_data["sort_field"];
				}

			}
			else{
				$sort_field ='journal_name';
			}

			$sort_order =  (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'asc';
			$limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
			 $select = "
			 `arld_id`,
			  `arld_article_title`,
			  `arld_article_code`,
			  `arld_article_abstract`,
			  `arld_article_type`,
			  GROUP_CONCAT(DISTINCT jnl_journal_name SEPARATOR ',') as journal_name,
			   DATE_FORMAT(NULLIF(arld_submission_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as submitted_date,
             DATE_FORMAT(NULLIF(arld_decision_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as decision_date,
              DATE_FORMAT(NULLIF(arld_most_recent_decision_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as most_recent_decision_date,
			  `arld_submitted_by`";

			  $legacyArticleDetails = Article_legacydata::legacy_article_data_paginated_records($select, $condition, $sort_field, $sort_order, $limit);

			  foreach ($legacyArticleDetails as $legacyArticleDetail) {
				if($legacyArticleDetail->arld_submitted_by)
				{
					$displayArray = array(
						'user_id' => $legacyArticleDetail->arld_submitted_by,
						'jnl_code' => NULL,
						'flag'     => TRUE,
						'article_id' =>  NULL,
						'availability' => TRUE,
						'save_coauthor' => FALSE,
						'remove_user' => FALSE,
						'source' => FALSE,
						'salutation' => TRUE,
						'flag_only' => FALSE,
						'inactive_user' => FALSE,
						'fullname_only' => FALSE,
						'journal_id' => NULL,
					);
					$legacyArticleDetail->userfullname = $this->get_user_display_name($displayArray );
				}
			}
			  return $this->success("Success",200, $legacyArticleDetails);

			} catch (\Exception $e) {
		return  $this->failure('Failed', 500, $e);
			}
	}
	public function fetch_legacy_reviewer_data(Request $request)
	{
		try{
			$form_data = $request->all();
			$paramsdet = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
			$currentClient   = $this->current_client;
			$dateFormat = $currentClient->settings->cs_date_format;
			$condition = 'arev_arld_id IS NOT NULL ';
			 $dateFormat = date_format_map($dateFormat);

			$sort_field = (isset($form_data['sort_field'])) ? $form_data['sort_field'] : 'arld_article_code';
			if($form_data["sort_field"] == 'userfullname') {
                $sort_field = 'usr_first_name';
                // $additionalJoinsArr[] = array($UserTable, 'art_submitted_by', 'usr_id');
            }
			$sort_order =  (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'asc';
			$limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
			$select = "arev_arld_id,arev_reveiewer_recommentation,DATE_FORMAT(arev_stage_start_date, ' " . $dateFormat . "') as start_date,DATE_FORMAT(arev_stage_end_date, ' " . $dateFormat . "') as end_date,arev_user_id,arld_article_code,arld_article_type,GROUP_CONCAT(DISTINCT jnl_journal_name SEPARATOR ',') as journal_name";
			if (isset($paramsdet['journal_name']) && $paramsdet['journal_name'] != '') {
				$paramsdet['journal_name'] = trim($paramsdet['journal_name']);

				$condition = $condition. " AND `jnl_journal_name` LIKE '%{$paramsdet['journal_name']}%' ";
			}
			if (isset($paramsdet['article_id']) && $paramsdet['article_id'] != '') {
				$paramsdet['article_id'] = trim($paramsdet['article_id']);
				// $condition = $condition . " AND `arld_article_code` LIKE '%{$paramsdet['article_id']}%' ";
				$condition = $condition.' AND arld_article_code  LIKE "%'.$paramsdet['article_id'].'%"';

			}
			if (isset($paramsdet['user_name'])&&$paramsdet['user_name'] != '')
			{
				$condition =  $condition . ' AND (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $paramsdet['user_name'] . '%"))';
			}
			$legacyReviewerDetails = Article_reviewer_legacydata::legacy_reviewer_data_paginated_records($select, $condition, $sort_field, $sort_order, $limit);

			  foreach ($legacyReviewerDetails as $legacyReviewerDetail) {
				if($legacyReviewerDetail->arev_user_id)
				{
					$displayArray = array(
						'user_id' => $legacyReviewerDetail->arev_user_id,
						'jnl_code' => NULL,
						'flag'     => TRUE,
						'article_id' =>  NULL,
						'availability' => TRUE,
						'save_coauthor' => FALSE,
						'remove_user' => FALSE,
						'source' => FALSE,
						'salutation' => TRUE,
						'flag_only' => FALSE,
						'inactive_user' => FALSE,
						'fullname_only' => FALSE,
						'journal_id' => NULL,
					);
					$legacyReviewerDetail->userfullname = $this->get_user_display_name($displayArray );
				}
			}
			  return $this->success("Success",200, $legacyReviewerDetails);

			} catch (\Exception $e) {
		return  $this->failure('Failed', 500, $e);
			}
	}
	public function save_legacy_reviewers(Request $request)
	{
		try {
			$return_data	= array();
			$post_data		= $request->all();
			$validator = Validator::make($request->all(), [
				'file'      => 'required',
			]);
			if ($validator->fails()) {
				$return_data    = array(
					'status' => 'error',
					'msg'    => customTrans('platform_settings.processing_error')
				);
				return $this->success('success', 200, $return_data);
			}
			if (!empty($post_data) && isset($post_data['file'])) {
				$filename=$post_data['file']->getClientOriginalName();
				$baseDirectory = 'public/uploads/legacy';
				$path 		 = $post_data['file']->storeAs($baseDirectory, $filename);
				$return_data = $this->read_upload_file_reviewers($path);
				// unlink(storage_path() . '/app/' . $path);
				return $this->success('success', 200, $return_data);
			} else {
				$return_data = array(
					'status' => 'warning',
					'msg'    => customTrans('platform_settings.uploaded_file_not_found'),
				);
				// print_r($return_data);die;
				return $this->success('success', 200, $return_data);
			}
		} catch (\Exception $e) {
			// print_r($e);die;
			return  $this->failure('Failed', 500, $e);
		}
	}
	public function read_upload_file_reviewers($path)
	{
         try{
		$i = 0;
		$email_exist_cnt = 0;
		$jnl_id ='';
		$csvData = array();
		$email_arr_set = array();
		$email_arr = array();
		$file_path		= storage_path() . '/app/' . $path;
		$file_read 		= fopen($file_path, 'r');
		$fields         = fgetcsv($file_read);
		$keys = $this->escape_string($fields);
		$jnl_code='';
		$db_fields = Article_reviewer_legacydata::get_field_names();
		$required_columns = array('arev_user_id', 'arev_arld_id');
		$this->current_user=$this->get_current_user_details();
	//check whether the uploaded csv has the necessary columns
	$flag = 'true';
	foreach ($required_columns as $required_column) {
		if (!in_array($required_column, $keys)) {
			$flag = 'false';
		}
	}
	if ($flag == 'false') {
		$return_data    = array(
			'status' => 'warning',
			'msg'    => customTrans('legacyarticle.mandatory-fields-missing')
		);
		return $return_data;
	} else {

			$csvData_reviewers = array();
			$no_user_array =array();
			while (($row = fgetcsv($file_read)) !== FALSE)
			{
				// Skip empty lines
				array_filter($row, function($value)
				{
					return !is_null($value) && $value !== '';
				});
				if (empty($row))
				{
					unset($row);
				}
				if (isset($row))
				{

					if ($row != NULL)
					{
						$new_values = $row;
						if (count($keys) == count($new_values))
						{
							/* $val = array_search('arev_reveiewer_recommentation', $keys);
							  if (strpos($new_values[$val], 'not publishable') == FALSE)
							  {
							  continue;
							  }
							  else
							  { */
							$val = array_search('arev_arld_id', $keys);
							$article_code = $new_values[$val];
							$records = Article_legacydata::get_single_record_with_bind_cond('arld_id,arld_jnl_id', array(
								'arld_article_code' => $article_code));

							$article_id = '';
							if (!empty($records))
							{
								$article_id = $records->arld_id;
								$jnl_id = $records->arld_jnl_id;

								$jnls = Journals::get_single_record_with_bind_cond('jnl_journal_code', array(
									'jnl_id' => $jnl_id));
									$jnl_code =$jnls->jnl_journal_code;


								$duplicate = Article_reviewer_legacydata::get_single_record_with_bind_cond('arev_id', array(
									'arev_arld_id' => $article_id));
								//duplicate check
								if(empty($duplicate))
								{
									$val = array_search('arev_user_id', $keys);
									//$reviewer_id = $new_values[$val];
									$reviewer_ids = explode("###",$new_values[$val]);
									 foreach($reviewer_ids as $reviewer_id)
									{
										$legacy_reviewer = User::get_single_record_with_bind_cond('usr_id', array(
										'usr_id' => $reviewer_id));
										if(!empty($legacy_reviewer))
										{
											$legacy_reviewer_id=$legacy_reviewer->usr_id;
										}
									}
									if(empty($legacy_reviewer))
									{
										$no_user_array['articles'][]=$article_code;
									}

								}


							}
							if (!empty($records) && empty($duplicate) && !empty($legacy_reviewer))
							{
								$keys_reviewers = array();
								$data_reviewers = array();

								for ($j = 0; $j < count($keys); $j++)
								{
									if ($keys[$j] != "" && in_array($keys[$j], $db_fields))
									{
										//$keys_reviewers[] = $keys[$j];
										if($keys[$j] == "arev_user_id")
										{
											$data_reviewers[] =$legacy_reviewer_id;
											$keys_reviewers[] = 'arev_user_id';
										}
										elseif ($keys[$j] == "arev_arld_id")
										{
											//$article_code=$new_values[$j];

											$data_reviewers[] = $article_id;
											$keys_reviewers[] = 'arev_arld_id';
										}
										elseif ($keys[$j] == "arev_reveiewer_recommentation")
										{
											$keys_reviewers[] = $keys[$j];
											$data_reviewers[] = $new_values[$j];
											$keys_reviewers[] = 'arev_status';
											if ($new_values[$j] != '')
											{
												$data_reviewers[] = 'ac';
											}
											else
											{
												$data_reviewers[] = 'nr';
											}
										}
										elseif ($keys[$j] == "arev_stage_start_date")
										{
											if ($new_values[$j] != '')
											{
												$arev_stage_start_date=$this->parseDate($new_values[$j]);
											// $arev_stage_start_date = date('Y-m-d', strtotime(str_replace('-', '/', $new_values[$j])));
											$data_reviewers[] = $arev_stage_start_date;
											$keys_reviewers[] = 'arev_stage_start_date';
											}
										}
										elseif ($keys[$j] == "arev_stage_end_date")
										{
											if ($new_values[$j] != '')
											{
												$arev_stage_end_date=$this->parseDate($new_values[$j]);
												$data_reviewers[] = $arev_stage_end_date;
											      $keys_reviewers[] = 'arev_stage_end_date';
											}
										}
										else
										{
											$data_reviewers[] = $new_values[$j];
											$keys_reviewers[] = $keys[$j];
										}
									}
								}
								$csvData_reviewers[] = $data_reviewers;
							}
							//}


							$i++;
						}
					}
					else
					{
						$return_data    = array(
							'status' => 'empty_row_error',
							'msg'    => customTrans('legacyarticle.empty_row_found'),
						);

					}
				}
			}
			if (!empty($csvData_reviewers))
			{
				$keys_reviewer = implode(',', $keys_reviewers);
				$reviewer_sql = "insert ignore into  rvw_article_reviewer_legacydata ($keys_reviewer) values ";
				//echo '<pre>';	print_r($csvData_reviewers);
				//echo '<pre>';	print_r($keys_reviewers);
				//die;

				for ($i = 0; $i < count($csvData_reviewers); $i++)
				{
					$csvData_reviewers_values = "'" . implode("', '", $csvData_reviewers[$i]) . "'";
					if ($i > 0)
						$reviewer_sql .= ",";
					$reviewer_sql .= "(" . $csvData_reviewers_values . ")";
				}

			   Article_reviewer_legacydata::execute_query($reviewer_sql);
				$reviewer_val = array_search('arev_user_id', $keys_reviewers);
				foreach ($csvData_reviewers as $cs => $value)
				{
					$reviewer_value = $value[$reviewer_val];
					//echo $author_val; die;

					$role_data = Roles::get_single_record_with_bind_cond('role_id', array('role_assigned_role' => "reviewer"));
					$role_id = $role_data->role_id;
					$role_data = User_to_journals::get_single_record_with_bind_cond('usrj_id', array('usrj_usr_id' => $reviewer_value,'usrj_jnl_id'=>$jnl_id,'usrj_role_id'=>$role_id));
					if(empty($role_data))
					{
						$insert_array=array(
							'usrj_usr_id'=>$reviewer_value,
							'usrj_jnl_id'=>$jnl_id,
							'usrj_role_id'=>$role_id
						);
						 $insert_id = User_to_journals::insert_record($insert_array,$this->current_user);
					}

				}
				$sqlr="UPDATE rvw_article_legacydata SET arld_reviewers =( SELECT GROUP_CONCAT(`arev_user_id`) FROM `rvw_article_reviewer_legacydata` WHERE arev_arld_id=arld_id)";
				Article_reviewer_legacydata::execute_query($sqlr);

				$return_data    = array(
					'status' => 'success',
					'msg'    => customTrans('legacyarticle.imprt-sucs'),
					'no_user' =>$no_user_array
				);

				$org_path = 'public/uploads/legacy/no_user_legacy_'.$jnl_code.'.txt';
				$file_paths = storage_path() . '/app/' . $org_path;
				file_put_contents($file_paths, json_encode($no_user_array),FILE_APPEND);
			}
			else
			{
				if(!empty($duplicate))
				{
					$return_data    = array(
						'status' => 'empty_row_error',
						'msg'    => customTrans('legacyarticle.data-exist'),
					);

				}
				else
				{
					$return_data    = array(
						'status' => 'empty_row_error',
						'msg'    => customTrans('legacyarticle.no-record'),
					);
				}


			}
		}
	// Close opened CSV file
	fclose($file_read);
	if (file_exists($file_path))
	{
		unlink($file_path);
	}
   return $return_data;
	} catch (\Exception $e) {
		return  $this->failure('Failed', 500, $e);
	}
	}

	public function fetch_legacy_reviewer_by_id(Request $request)
	{
		try{
			$form_data = $request->all();
			$currentClient   = $this->current_client;
			$dateFormat = $currentClient->settings->cs_date_format;

			 $dateFormat = date_format_map($dateFormat);
			$arld_id =  decrypt_link($form_data['arev_arld_id']);

			// $condition='arev_arld_id =' . $arld_id;yy
			$legacyReviewerDetails = Article_reviewer_legacydata::legacy_reviewer_data_by_id('arev_arld_id =' . $arld_id,$dateFormat);
				if($legacyReviewerDetails->arev_user_id)
				{
					$displayArray = array(
						'user_id' => $legacyReviewerDetails->arev_user_id,
						'jnl_code' => NULL,
						'flag'     => TRUE,
						'article_id' =>  NULL,
						'availability' => TRUE,
						'save_coauthor' => FALSE,
						'remove_user' => FALSE,
						'source' => FALSE,
						'salutation' => TRUE,
						'flag_only' => FALSE,
						'inactive_user' => FALSE,
						'fullname_only' => FALSE,
						'journal_id' => NULL,
					);
					$legacyReviewerDetails->userfullname = $this->get_user_display_name($displayArray );
				}
				$legacy_status  = array(
					'ac' => 'Completed',
					'dc' => 'Declined',
					'dn' => 'Declined - No time',
					'do' => 'Declined - Out of field',
					'ra' => 'Reassigned',
					'nr' => 'No response',
					'ad' => 'Auto Declined',
					'ag' => 'Agreed',
					'ua' => 'Unavailable',
					'cm' => 'Changes to manuscript format required'
				);
				$legacyReviewerDetails->legacy_status = $legacy_status;
			  return $this->success("Success",200, $legacyReviewerDetails);

			} catch (\Exception $e) {
		return  $this->failure('Failed', 500, $e);
			}
	}
	public function fetch_legacy_article_by_id(Request $request)
	{
		try{
			$form_data = $request->all();
			$currentClient   = $this->current_client;
			$dateFormat = $currentClient->settings->cs_date_format;

			 $dateFormat = date_format_map($dateFormat);
			$arld_id =  decrypt_link($form_data['arld_id']);
			$legacyArticleDetails = Article_legacydata::legacy_article_data_by_id('arld_id =' . $arld_id,$dateFormat);
			$legacy_status  = array(
				'a' => 'Accepted',
				'r' => 'Rejected',
				't' => 'Transferred',
				'w' => 'Withdrawn',

			);
			$legacyArticleDetails->legacy_status = $legacy_status;
			return $this->success("Success",200, $legacyArticleDetails);

			} catch (\Exception $e) {

		return  $this->failure('Failed', 500, $e);
			}
	}

	public function supportingform_view(Request $request) {
		try{
			$post_data = $request->all();
			$supportDetails['viewpermission']=false;
			$validator = Validator::make($request->all(),[
				'jnl_id' => 'required',
				'jnl_code' => 'required',
				'role_id' => 'required',
				'core_role' => 'required'
			]);
	
			if($validator->fails()) {
				return  $this->failure('Failed',422,$validator->errors());
			} else {			

				$input_arr = array('input' => $post_data['jnl_id'],'type'=> 'number');
				$jnl_id_validate = $this->Rv_validator($input_arr);
	
				$input_arr['input']= $post_data['role_id'];
				$role_id_validate = $this->Rv_validator($input_arr);
	
				$input_arr = array('input' => $post_data['jnl_code'],);
				$jnl_code_validate = $this->Rv_validator($input_arr);
	
				$input_arr['input']= $post_data['core_role'];
				$core_role_validate = $this->Rv_validator($input_arr);


				if($jnl_id_validate == TRUE && $role_id_validate == TRUE && $jnl_code_validate == TRUE && $core_role_validate == TRUE) {
				
					$core_role = $post_data['core_role'];
					$roleid = $post_data['role_id'];
					$jnl_id=$post_data['jnl_id'];
					$jnl_code=$post_data['jnl_code'];

					if (isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y') {						
						
						
							$res=$this->getSupportingdataforms(array('jnl_id'=>$jnl_id,'jnl_code'=>$jnl_code));
							if(!empty($res)){
								$supportDetails['completedforms']=isset($res['completedforms'])?$res['completedforms']:[];
							}
						
						

						$jnl_setting = Journal_settings::get_single_record_with_bind_cond('jset_showsupportingdata',array("jset_jnl_id"=>$jnl_id));
						if(isset($jnl_setting->jset_showsupportingdata)){
							$jnl_permissionuser = json_decode($jnl_setting->jset_showsupportingdata, true);
							if (is_array($jnl_permissionuser) && in_array($roleid, $jnl_permissionuser)) {
								$supportDetails['viewpermission']=true;
							}						
						}
					}

					return $this->success("Success",200, $supportDetails);
				}
			}

		} catch (\Exception $e) {
			return  $this->failure('Failed', 500, $e);
		}
	}

	 /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
	 public function get_supportingcompleted_forms($supportDetails) {
		$viewform=$supportDetails['viewform'];
		$jnl_id=$supportDetails['jnl_id'];
		$jnlcode=$supportDetails['jnl_code'];

		$where='gncf_metadata_status="s"';
		 $forms = array();
		 $forms_exist = array();
		 if ($viewform != '') {
 
			 
			 
			 // remove element form custom form settings bug fixed
			 $form_select ="CASE WHEN emt_hideafterstage IS NULL THEN (SELECT emt_hideafterstage FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='label' order by tbk_id DESC limit 1) ELSE emt_hideafterstage END AS emt_hideafterstage, CASE WHEN emt_element_type IS NULL THEN (SELECT emt_element_type FROM tbk_generic_form_elements WHERE emt_id=gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date <=gdata_posted_date order by tbk_id DESC limit 1) ELSE emt_element_type END AS emt_element_type, CASE WHEN emt_tinymce_required IS NULL THEN (SELECT emt_tinymce_required FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='textarea' order by tbk_id DESC limit 1) ELSE emt_tinymce_required END AS emt_tinymce_required,";
 
			 $form_select .= 'gdata_dynamic_status,gdata_art_id,gdata_gform_title,gdata_group_name,gdata_label,gdata_user_roles,gdata_element_type,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_atf_id,gdata_artflw_id,gdata_posted_by,gdata_gfg_id,gncf_form_type,gncf_user_roles,gncf_posted_by,gncf_form_privilege_usr_edit,gdata_atfemt_id';
 
			 $formatted_journal_code = '_' . $jnlcode;
			 $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
			 $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
 
			 $details_tables = array(
				 'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
				 'join_table' => array(
					 $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
					 $Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id','left'),
 
				 )
			 );
			 $order_by = "gdata_data_order,gdata_posted_date asc";
			 if(!empty($viewform) && count(json_decode($viewform))>0){
				 $form_order = implode(',',(json_decode($viewform)));
				 $order_by = "FIELD(gdata_atf_id,".$form_order."),gdata_data_order,gdata_posted_date asc";
			 }
 
			 
				 $forms = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', $order_by, null, '', null, null, true);
			 

			 

 
		 }
		 $return_arr =array('forms'=>$forms);
		 return $return_arr;
	 }


}
