<?php

namespace App\Http\Controllers;

use App\Models\Users_unavailability;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class Manage_Dates_Unavailable_Api extends Controller
{
    /*List all Unavailable dates
     commited date :- 22-11-2022
     Requested type :- POST
    */
    public function index(Request $request)
    {
        try {
            $form_data = $request->all();
            // DB::enableQueryLog();
            $validator = Validator::make($request->all(), [
                'current_user' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $user_id = $this->decrypt_data($form_data['current_user']);
            $format = platform_date_format();
            $date_format =$this->current_client->settings->cs_date_format;
            $date_format= date_format_map($date_format);
            $criteria = 'unavail_user_id = "' . $user_id . '"';
            $result = Users_unavailability::get_all_records('*,DATE_FORMAT(unavail_start_date,"' . $date_format . ' ") AS startdate,DATE_FORMAT(unavail_end_date,"' . $date_format . ' ") AS enddate', $criteria, NULL, NULL, '', NULL, NULL, 'ASC');
      
            if (isset($format[$this->current_client->settings->cs_date_format]))
                $data['cs_format'] = $format[$this->current_client->settings->cs_date_format];

            $data['user_unavailability'] = $result;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Delete Unavailable dates
     commited date :- 22-11-2022
     Requested type :- POST
    */
    public function delete_datesunavailable(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'dates_unavail_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $dates_unavailable_id = $this->decrypt_data($form_data['dates_unavail_id']);
            $criteria = 'unavail_id = "' . $dates_unavailable_id . '"';
            $result = Users_unavailability::delete_records($criteria, '', $this->current_user);
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Get Unavailable dates
     commited date :- 22-11-2022
     Requested type :- POST
    */
    public function get_datesunavailable(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'dates_unavail_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $dates_unavailable_id = $this->decrypt_data($form_data['dates_unavail_id']);
            $criteria = 'unavail_id = "' . $dates_unavailable_id . '"';
            $result = Users_unavailability::get_single_record('*', $criteria);
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Save / Update Unavailable dates
     commited date :- 22-11-2022
     Requested type :- POST
    */
    public function save_datesunavailable(Request $request)
    {
        try {
            DB::enableQueryLog();
            $form_data = $request->all();
            $current_user = $this->get_current_user_details();
            $unavail_date_id = '';
            if(isset($form_data['edit_id']) && $form_data['edit_id'] != NULL || isset($form_data['edit_id']) && $form_data['edit_id'] != '' ){
                $validator = Validator::make($request->all(), [
                    'start_date' => 'required',
                    'end_date' => 'required',
                    'edit_id' => 'required',
                ]);
            }
            else{
                $validator = Validator::make($request->all(), [
                    'start_date' => 'required',
                    'end_date' => 'required',
                ]);
            }
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
              	
		$user_id = 	$current_user['user_id'];	
		if(isset($form_data['user_id']) )
		{
			$user_id =$this->decrypt_data($form_data['user_id']);
            $form_data['edit_id'] = NULL;
            if(isset($form_data['date_id']) && $form_data['date_id'] != NULL)
            {
                $unavail_date_id=  $form_data['date_id'];
			
		     }
        }
        else if(isset($form_data['curr_user']))
        {
            $user_id =$this->decrypt_data($form_data['curr_user']);
        }
            $dates_array = array(
                'unavail_start_date' => convert_dmy_to_ymd($form_data["start_date"],  $this->current_client->settings->cs_date_format),
                'unavail_end_date' => convert_dmy_to_ymd($form_data["end_date"],  $this->current_client->settings->cs_date_format),
                'unavail_reason' => $form_data['reason'],
                'unavail_user_id' => $user_id
            );
            $user_id = $user_id;
            $criteria = 'unavail_user_id = ?';
            $bind_arr = [$user_id];
            $unavaile_dates = Users_unavailability::get_all_records('unavail_id,unavail_start_date,unavail_end_date', $criteria, NULL, NULL, '', NULL, NULL, 'ASC',$bind_arr);
            $save_start_date = strtotime(convert_dmy_to_ymd($form_data["start_date"],  $this->current_client->settings->cs_date_format));
            $save_end_date = strtotime(convert_dmy_to_ymd($form_data["end_date"],  $this->current_client->settings->cs_date_format));
            if ($form_data['edit_id'] != NULL) {
                $unavail_date_id = $this->decrypt_data($form_data['edit_id']);
            }
           
            foreach ($unavaile_dates as $dates) {
                $start_date_db = strtotime($dates->unavail_start_date);
                $end_date_db = strtotime($dates->unavail_end_date);
                if (($save_start_date == $start_date_db) && ($dates->unavail_id != $unavail_date_id)
                    || ($save_start_date == $end_date_db) && ($dates->unavail_id != $unavail_date_id)
                    || ($save_start_date > $start_date_db && $save_start_date < $end_date_db) && ($dates->unavail_id != $unavail_date_id)
                    || ($save_end_date == $start_date_db) && ($dates->unavail_id != $unavail_date_id)
                    || ($save_end_date == $end_date_db) && ($dates->unavail_id != $unavail_date_id)
                    || ($save_end_date > $save_start_date && $save_end_date < $save_end_date) && ($dates->unavail_id != $unavail_date_id)
                    || ($end_date_db > $save_end_date && $start_date_db < $save_end_date)&& ($dates->unavail_id != $unavail_date_id)
                    ||($save_start_date < $start_date_db && $save_end_date > $end_date_db)&& ($dates->unavail_id != $unavail_date_id)
                ) {
                 
                    $message = customTrans('unavailabledates.dates_exist');
                    return  $this->warning($message, 200, '', 'warning');
                }
            };
            if (isset($form_data['edit_id']) && ($form_data['edit_id'] != 'null') || isset($form_data['date_id'])&&($form_data['date_id']!='null'))  {
                // $condition = 'unavail_id=' . $unavail_date_id;
                // $result = Users_unavailability::get_single_record('count(unavail_id) as count', $condition);
                $condition = ['unavail_id'=>$unavail_date_id];
                $result = Users_unavailability::get_single_record_with_bind_cond('count(unavail_id) as count',$condition);
                if ($result->count > 0) {
                    $updatedata = Users_unavailability::update_record($dates_array, $condition, $current_user);
                }
                $message = customTrans('unavailabledates.unavailable_date_updated_success');
                return $this->success($message, 200, $updatedata);
            } else {
                $result = Users_unavailability::insert_record($dates_array, $current_user);
                $message = customTrans('unavailabledates.unavailable_date_save_successfully');
                return $this->success($message, 200, $result);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
}
