<?php

namespace App\Http\Controllers;

use App\Models\Discussion_type;
use App\Models\Roles;
use Config;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\GeneralEmailTrait;
use \stdClass;
use Illuminate\Support\Facades\URL;

class Manage_Discussion_Type_Api extends Controller
{
    use GeneralEmailTrait;
    public function index(Request $request)
    {
        try {
            
            $form_data = $request->all();
            $return_array=array();
            DB::enableQueryLog();
            $all_roles =Roles::get_all_records();
            if(!empty($all_roles )) {
                foreach($all_roles as $row) {
                    $return_array['all_roles'][$row->role_id]=$row->role_name;
                }
            }
            $order_by ='role_name ASC';
            $select = '*';
            $sort_field = $form_data['sort_field'] ?? 'dsctp_id';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 5;
            $select = '*';
            $return_array['discussion_type'] = Discussion_type::get_paginated_records($select, $criteria =NULL, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $return_array);

        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }

    
    public function save_discussion_type(Request $request)
	{
        
        try {
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'roles_assigned' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $form_data = $request->all();
            $from_dataroles= $form_data['roles_assigned'];
            $admin_rolescheck=explode(",",$from_dataroles);
            $checkroles=TRUE;
           if(count($admin_rolescheck)>0)
           {
            foreach ( $admin_rolescheck as $val=>$values) {
                if(!empty($values))
                {
                    $wherecondition="role_id='{$values}' ";  
                    $check_role = Roles::get_single_record('role_id', $wherecondition);
                    if(empty($check_role))
                    {
                        $checkroles=FALSE;
                    }
                }
            }
           }
            // var_dump($form_data);die;
            if($checkroles==TRUE)
            {
            if ($form_data['hdn_id'] == null)
            {
                $where="dsctp_type='{$form_data['name']}' ";    
            }else{
                $where="dsctp_type='{$form_data['name']}' AND dsctp_id!={$form_data['hdn_id']}";
            }
               
              $check_discussion_type = Discussion_type::get_single_record('*', $where);
              $file_type_descr = NULL;
            //DB::enableQueryLog();die;
                if ($check_discussion_type == NULL )
			    {
                    $from_data= $form_data['roles_assigned'];
                    $admin_roles=explode(",",$from_data);
                   $role_assigned = json_encode($admin_roles);
                 /* if (!empty($form_data['roles_assigned'])) {
					$decrypt_filetype_array=array();
					$file_types = $form_data['roles_assigned'];
					$file_types_arr = explode(',',$file_types);
					foreach ($file_types_arr as $filetype) {
						$decrypt_filetype_array[] = $filetype;
					}
					$file_type_descr = ($decrypt_filetype_array);
				}*/
                   
                  // $role_assigned = json_encode(array_values($form_data['roles_assigned']));
				
				//Hidden id is empty insert record
				if ($form_data['hdn_id'] == null)
				{ 
                    
                    $data = array(
                        'dsctp_type' => $form_data['name'],
                        'dsctp_role_id' => $role_assigned
                    );
					$result = Discussion_type::insert_record($data, $current_user);
					$message = customTrans('discussion.discussion_save_successfully');
                     return $this->success($message, 200, $result);
					
				}	else
				{
                $criteria = 'dsctp_id="' . $form_data['hdn_id'] . '"';	 
				$data = array(
					'dsctp_type' => $form_data['name'],
					'dsctp_role_id' => $role_assigned
				);
                $result =Discussion_type::update_record($data,  $criteria, $current_user);
				if($result)
                {
                        $message = customTrans('discussion.discussion_updated_success');
                        return $this->success($message, 200, $result);
                }else{
                    $msg_arr[] = customTrans('discussion.invalid_exits');
                    return $this->warning($msg_arr, 200,'','warning');    
                }
				}

                }else{
                    $msg_arr[] = customTrans('discussion.already_discussion_exits');
                    return $this->warning($msg_arr, 200,'','warning');  
                  
                }
            }else{
                $msg_arr[] = 'Role does not exits';
                    return $this->warning($msg_arr, 200,'','warning');   
            }


        }catch (\Exception $e) {
            
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function delete_discussion_type(Request $request)
	{
        DB::beginTransaction(); 
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data=$request->all();
            $dsctp_id=$this->decrypt_data($post_data['dsctp_id']); 
            if(!is_numeric($dsctp_id)) {
                $msg_arr[]='Somthing went wrong';
                return  $this->warning($msg_arr,200,'','warning');
            }
            $Generic_discussion=new \App\Models\Generic_discussion();
            $noof_filedesc=$Generic_discussion::get_all_records('gdis_id',"gdis_dsctp_id='{$dsctp_id}'");
            if(sizeof($noof_filedesc)>0){
                $msg_arr[]=customTrans('discussion.disc_type_exist_discuss');
                return  $this->warning($msg_arr,200,'','warning');
            }
            $criteria = "dsctp_id='{$dsctp_id}'";
            $result = Discussion_type::delete_records($criteria,"",$this->current_user);
            DB::commit();	
            $msg_arr[]=customTrans('discussion.disc_type_dlt_success');
		return $this->success($msg_arr,201,'');

        }catch (\Exception $e) {
            DB::rollback();  
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function get_discussion_type(Request $request)
	{
        try {
            $role_arry=[];
            DB::enableQueryLog();
            $order_by ='role_name';
            $role_type =Roles::get_all_records('role_id,role_name,role_assigned_role',array(),$order_by,NULL,'',NULL,NULL,'ASC');
            if(!empty($role_type)) {
                foreach($role_type as $row) {
                    $role_arry[$row->role_id]=$row->role_name;
                }
            }
            $return_array['all_roles'] =$role_arry;
            return $this->success('success', 200, $return_array);
        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function get_discussion_type_data(Request $request)
	{
        try {
           
            DB::enableQueryLog();
            $post_data = $request->all();
            $dsctp_id = $this->decrypt_data($post_data['edited_id']);
            if ($dsctp_id != "")
            {
                $criteria = 'dsctp_id = "' .$dsctp_id. '"';
                $edit_record = Discussion_type::get_single_record('dsctp_id,dsctp_role_id,dsctp_type,dsctp_posted_by', $criteria);
                if($edit_record)
                {
                    return $this->success('success',200,$edit_record);
                }
                else
                {
                    return  $this->warning('Failed',500);
                }
            }else{
                return  $this->warning('Failed',500); 
            }
          
        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function get_all_discussion_type(Request $request)
	{
        try {
            $post_data=$request->all();
            $article_id =isset($post_data['article_id']) ?  $this->decrypt_data($post_data['article_id']) : ''; 
            $flow_id =isset($post_data['current_status_id']) ?  $this->decrypt_data($post_data['current_status_id']) : '';
            $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : ''; 

            $array['article_id']=$article_id;
            $array['type']='discussion';
            $array['jnl_code']=$jnl_code;
            $array['current_flow_id']=$flow_id;
            $array['url']=$request->segment(4);
            // $user_access=$this->check_permission_access_user($array);
            // if($user_access!=true)
            // {
            //     return response()->json(['status' => false,'message'=>'Unauthorized User','access_token'=>false,'success'=>false]);
            // }
            $role_arry=[];
            $disc_type =Discussion_type::get_all_records('dsctp_id as disc_type_id,dsctp_role_id as role_id, dsctp_type as disc_type');
            if(!empty($disc_type)) {
                foreach($disc_type as $row) {
                    $role_arry[$row->disc_type_id]=$row->disc_type;
                }
            }
            $return_array['disc_type'] =$role_arry;
            return $this->success('success', 200, $return_array);

        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function get_users_on_disctype(Request $request)
	{
        try {
            $role_arry=[];
            $user_ids_ar=[];
            $name='';
            $user_role='';
            $post_data = $request->all();
            if(isset($post_data['article_id']))
            {
            $artclearray = array('input'=>$post_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
            $artclevalidation= $this->Rv_validator($artclearray);
            if($artclevalidation==false)
                {
                    $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                    return $this->warning("Failed",201,$arraymsg);     
                }
            }
            if(isset($post_data['discussion_type']))
            {
            $disctypearray = array('input'=>$post_data['discussion_type'],'type'=>'number', 'enc_data'=>FALSE );   
            $disctypevalidation= $this->Rv_validator($disctypearray);
            
            if($disctypevalidation==false)
                {
                    $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                    return $this->warning("Failed",201,$arraymsg);     
                } 
            }   
           // $article_id = $this->decrypt_data($post_data['article_id']);
            $article_id =isset($post_data['article_id']) ? $this->decrypt_data($post_data['article_id']) : '';
           // $dsc_type_id = $post_data['discussion_type'];
            $dsc_type_id =isset($post_data['discussion_type']) ? $post_data['discussion_type'] : '';
            $art_all_prev_ids = isset($post_data['art_all_prev_ids']) ?$post_data['art_all_prev_ids']:'';
            $Articles=new \App\Models\Articles();
            $data = array(
                'art_id' => $article_id
            );
            $art_submitted_authr = $Articles::get_single_record_with_bind_cond('art_submitted_by,art_artp_id,art_pre_all_ids',$data);
            if(!empty($art_submitted_authr))
            {
            $to_users = $this->get_all_artp_users($dsc_type_id,$article_id,$art_submitted_authr->art_artp_id,$art_submitted_authr->art_pre_all_ids);
            if(!empty($to_users)) {
                foreach($to_users as $row) {
                   
                   $name = ($row->usr_middle_name!="" && $row->usr_middle_name!=null ) ? $row->usr_first_name.' '.$row->usr_middle_name.' '.$row->usr_last_name : $row->usr_first_name.' '.$row->usr_last_name;
                    if(isset($row->is_author) && $row->is_author!= null && $row->is_author == 'y')
                    {
                   $user_role = '[Submitted author]';
                    }
                    else if(isset($row->is_author) && $row->is_author != null && $row->is_author == 'n')
                    {
                    $user_role = '[Co-author]';
                    }
                    else if(isset($row->stage_type) && $row->stage_type != null && $row->stage_type == 'review')
                    {
                        $user_role = '[Reviewer]';
                    }
                    if(isset($row->roles) && $row->roles != null)
                    {
                        $roles_assgn  = '(' .$row->roles.')';
                    }
                    $role_arry[$row->usr_id]=$name.$user_role.$roles_assgn;
                    $user_ids_ar[]=$row->usr_id;
                }
            }
        }
            $return_array['user_ids'] =$user_ids_ar;
            $return_array['all_roles'] =$role_arry;
            return $this->success('success', 200, $return_array);
        }  catch (\Exception $e) {
            
            //echo "<pre/>";
            return  $this->failure('Failed', 500, $e);
        }
       
    }
    public function get_all_artp_users($dsc_type_id,$article_id,$artp_id,$art_all_prev_ids = NULL)
	{
 
        try {
        $Discussion_type=new \App\Models\Discussion_type();
        $Roles=new \App\Models\Roles();
        $Authors=new \App\Models\Authors();
        $Users=new \App\Models\User();
        $Generic_flows=new \App\Models\Generic_flows();
        $Article_flow=new \App\Models\Article_flow();
        $Blind_user_articles=new \App\Models\Blind_user_articles();
        $Discussion_type_table = (new \App\Models\Discussion_type)->getTable(); 
        $User_table = (new \App\Models\User)->getTable();
        $Roles_table = (new \App\Models\Roles)->getTable(); 
        $User_to_journals_table = (new \App\Models\User_to_journals)->getTable();   
        $Article_flow_table = (new \App\Models\Article_flow)->getTable();
        $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();   
        $role_sql =  'SELECT dsctp_role_id as role_ids,role_assigned_role FROM '.$Discussion_type_table.' LEFT JOIN rvw_roles  ON JSON_CONTAINS(dsctp_role_id, cast(CONCAT(\'"\', role_id, \'"\') as JSON)) WHERE dsctp_id =? GROUP BY role_assigned_role' ;
        $cond = array();
        $cond = array($dsc_type_id);
        $result = $Discussion_type::get_records_by_raw_query($role_sql,FALSE,$cond);
        $roles_assgned = array();
       //  if(!empty( $result))
       //  {
       // 	 foreach($result as $rls)
       // 	 {
       // 		$roles_assgned[] = $rls->role_assigned_role;
       // 	 }
       //  }
        $author_union ='';
        $reviewer_union ='';
        $roles_cond = '';
        $where_like_cond = '';
        $article_authors = '';
        $authr_id = '';
        $roles_arr = array();
        $prev_art_ids = '';
        $reviewer_id = array();
        $bind_arr = array(); 
       if(isset($result[0]->role_ids) && $result[0]->role_ids != NULL)
        {
           
           $roles =  implode(',',json_decode($result[0]->role_ids));
           $role_assgnd_role_sql = 'SELECT role_assigned_role, role_id FROM '.$Roles_table.' WHERE role_id IN ('.$roles.')';
           $resultrole = Roles::get_records_by_raw_query($role_assgnd_role_sql);
           $roles_cond = ' AND usrj_role_id IN('.$roles.')';
           if(!empty($resultrole))
           {
            foreach($resultrole as $key=>$rle)
		    {
                
                if($rle->role_assigned_role == 'author')
                {
                    $authr_id=  $rle->role_id;
                }
                if($rle->role_assigned_role == 'reviewer')
                {
                    $reviewer_id[] = $rle->role_id; 
                }

            }

           }

           if($art_all_prev_ids != NULL)
            {
                $prev_art_ids = ','.$art_all_prev_ids;
            }
            if($authr_id != '')
		    {
			$author_union = ' AND (CASE when rvw_roles.role_id = ? THEN rvw_user_journals.usrj_usr_id IN(SELECT auth_usr_id FROM rvw_article_authors WHERE  FIND_array_intersect(auth_art_id,?)=1) ELSE TRUE END)';
            $bind_arr[]=  $authr_id; 
            $bind_arr[]=  $article_id.$prev_art_ids; 
		    }
            if(!empty($reviewer_id))
		    {
			$rvw_ids = implode(',',$reviewer_id);
			$reviewer_union = ' AND (CASE when rvw_roles.role_id IN ('.$rvw_ids.') THEN rvw_user_journals.usrj_usr_id IN(SELECT aflw_usr_id FROM '.$Article_flow_table.' JOIN '.$Generic_flows_table.' ON aflw_jwf_id = jwf_id WHERE aflw_usr_id IS NOT NULL AND  aflw_status IN (\'a\',\'c\') AND jwf_stage_type=\'review\' AND aflw_parent_flow_id IS NOT NULL AND aflw_art_id  IN(?)) ELSE TRUE END)';
            $bind_arr[]=  $article_id.$prev_art_ids; 
		    }
            
        } 
        else
        {
            $ar_role = array();
	        $disc_roles = '';
             // $allroles= $this->get_discussion_user_role();
            //$roles = implode(',',$allroles['disc_roles']);	
            $Roles=new \App\Models\Roles();
            $role_result =  $Roles::get_all_records('role_id,role_assigned_role');
            foreach($role_result as $role)
	  		{ 
                if($role->role_assigned_role == 'author')
                {
                    $authr_id=  $role->role_id;
                }
                if($role->role_assigned_role == 'reviewer')
                {
                    $reviewer_id[] = $role->role_id; 
                }
                if ($role->role_assigned_role == 'system')
		 		{
			 		continue;
		 		}
				else if ($role->role_assigned_role == 'sudo')
		 		{
			 		continue;
		 		}
		 		else if ($role->role_assigned_role == 'super_admin')
		 		{
			 		continue;
		 		}
                 $ar_role[]  = $role->role_id;
            }
            $roles = implode(',',$ar_role);	
            if($art_all_prev_ids != NULL)
            {
                $prev_art_ids = ','.$art_all_prev_ids;
            }
            if($authr_id != '')
		    {
			$author_union = ' AND (CASE when rvw_roles.role_id = ? THEN rvw_user_journals.usrj_usr_id IN(SELECT auth_usr_id FROM rvw_article_authors WHERE  FIND_array_intersect(auth_art_id,?)=1) ELSE TRUE END)';
            $bind_arr[]=  $authr_id; 
            $bind_arr[]=  $article_id.$prev_art_ids; 
		    }
            if(!empty($reviewer_id))
		    {
			$rvw_ids = implode(',',$reviewer_id);
			$reviewer_union = ' AND (CASE when rvw_roles.role_id IN ('.$rvw_ids.') THEN rvw_user_journals.usrj_usr_id IN(SELECT aflw_usr_id FROM '.$Article_flow_table.' JOIN '.$Generic_flows_table.' ON aflw_jwf_id = jwf_id WHERE aflw_usr_id IS NOT NULL AND  aflw_status IN (\'a\',\'c\') AND jwf_stage_type=\'review\' AND aflw_parent_flow_id IS NOT NULL AND aflw_art_id  IN(?)) ELSE TRUE END)';
            $bind_arr[]=  $article_id.$prev_art_ids; 
		    }
        }
        
      

             $select = ' usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name, tbl_artp.user_all_roles as roles' ; 
             $artp_users = ' JOIN(SELECT usrj_usr_id,GROUP_CONCAT(role_name SEPARATOR ",") AS user_all_roles, FIND_array_intersect(GROUP_CONCAT(usrj_role_id SEPARATOR ","),"'.$roles.'") as exist_or_not FROM '. $Roles_table.' JOIN '.$User_to_journals_table.' ON usrj_role_id = role_id WHERE usrj_artp_id = '.$artp_id.' AND usrj_role_retired = \'n\' '.$author_union.$reviewer_union.' GROUP BY usrj_usr_id) as tbl_artp  ON  tbl_artp.usrj_usr_id = usr_id WHERE tbl_artp.exist_or_not = 1 AND  JSON_SEARCH((SELECT bau_usr_ids FROM rvw_blind_article_to_users WHERE bau_art_id ='.$article_id.'),"all",tbl_artp.usrj_usr_id) is NULL';
             $select_main_sql = 'SELECT'.$select.' FROM '.$User_table.$artp_users.$where_like_cond;
             $to_users = $Users::get_records_by_raw_query($select_main_sql,FALSE,$bind_arr);

             return  $to_users;
            }  catch (\Exception $e) {
   
                return  $this->failure('Failed', 500, $e);
            }
    }
    public function get_discussion_user_role()
     { 
        try {
            $Roles=new \App\Models\Roles();
	        $ar_role = array();
	        $disc_roles = '';
	    
        	$role_result =  $Roles::get_all_records('role_id,role_assigned_role');
	  		foreach($role_result as $role)
	  		{ 
		 		if ($role->role_assigned_role == 'system')
		 		{
			 		continue;
		 		}
				else if ($role->role_assigned_role == 'sudo')
		 		{
			 		continue;
		 		}
		 		else if ($role->role_assigned_role == 'super_admin')
		 		{
			 		continue;
		 		}

		  		$ar_role[]  = $role->role_id;
	  		}
	  		$disc_roles  = $ar_role;
	 	    return $disc_roles;
        }catch (\Exception $e) {
           return  $this->failure('Failed', 500, $e);
       }
    }
    
    public function add_generic_discussion(Request $request)
    { 
        try {
            $this->current_user = $this->get_current_user_details();
            $this->current_user['user_id'];
            $discussion_user_role = '';
            $post_data = $request->all();

            if(!empty($post_data))
		    {
                $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : ''; 
                $flow_id =isset($post_data['current_status_id']) ?  $this->decrypt_data($post_data['current_status_id']) : ''; 
                $article_id = isset($post_data['article_id']) ?  $this->decrypt_data($post_data['article_id']) : '';
                $array['article_id']=$article_id;
                $array['type']='discussion';
                $array['jnl_code']=$jnl_code;
                $array['current_flow_id']=$flow_id;
                $array['url']=$request->segment(4);
                $array['user_id']=$this->current_user['user_id'];
                $user_access=$this->check_permission_access_user($array);
                if($user_access!=true)
                {
                    return response()->json(['status' => false,'message'=>'Unauthorized User','success'=>false]);
                }

                $validator = Validator::make($request->all(), [
                    'title' => 'required|string',
                    'discussion_type'=> 'required'
                    
                ],[
                    'title.required' => 'Title is required',
                    'discussion_type.required' => 'Discussion type is required'   
                ]);
                if ($validator->fails()) {
                    // return  $this->failure('Failed',422,$validator->errors());
                    return $this->failure("Failed",201,$validator->errors());  
                 }
                 if(isset($post_data['all_user_check']) && $post_data['all_user_check'] == 'y')
                 {
                    $validator = Validator::make($request->all(), [
                        'all_usr_ids' => 'required|string' 
                    ],[
                        'all_usr_ids.required' => 'Participants user is required'         
                    ]);
                    if ($validator->fails()) {
                        return $this->failure("Failed",201,$validator->errors());  
                     }
                 }else{
                    $validator = Validator::make($request->all(), [
                        'discussion_user' => 'required|string' 
                    ],[
                        'discussion_user.required' => 'Participants user is required'         
                    ]);
                    if ($validator->fails()) {
                        return $this->failure("Failed",201,$validator->errors());  
                     }


                     $particpant_by_usr1 = explode(',',$post_data['all_usr_ids']); 
                     $from_data1= $post_data['discussion_user'];
                     $admin_roles1=explode(",",$from_data1);
                     $flg=TRUE;
                     if(count($admin_roles1)>0)
                     {
                         for($k=0;$k<count($admin_roles1);$k++)
                         {
                             if (in_array($admin_roles1[$k], $particpant_by_usr1))
                             {
                             }else{
                                $flg=false;
                             }
                         }
                     }
                     if($flg==false)
                     {
                        $arraymsg['chatmesage'] = 'User Not Exits';
                        return $this->warning("Failed",201,$arraymsg);      
                     }
                    
                 }
                 
               
                    
                  

        
                $artclearray = array('input'=>$post_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
                $titlearray = array('input'=>$post_data['title'],'type'=>'string', 'enc_data'=>FALSE );
                $typearray = array('input'=>$post_data['discussion_type'],'type'=>'number', 'enc_data'=>FALSE );
                $artclevalidation= $this->Rv_validator($artclearray);
                $titlevalidation= $this->Rv_validator($titlearray);  
                $typevalidation= $this->Rv_validator($typearray);    
                if($artclevalidation==false)
                {
                    $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                    return $this->warning("Failed",201,$arraymsg);     
                }if($titlevalidation==false)
                {
                    $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                    return $this->warning("Failed",201,$arraymsg);     
                }if($typevalidation==false)
                {
                    $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                    return $this->warning("Failed",201,$arraymsg);     
                }
                if(!empty($post_data['discussion_type']))
                {
                    
                    $disc_type =Discussion_type::get_single_record('dsctp_id','dsctp_id ='.$post_data['discussion_type']);
                    if(empty($disc_type))
                    {
                        $arraymsg['chatmesage'] = 'Discussion type Not Exits';
                        return $this->warning("Failed",201,$arraymsg);     
                    }
                }
                if(empty($post_data['hdn_gen_disc_id']))
                {
                    $validator = Validator::make($request->all(), [
                        'initial_comment' => 'required|string'  
                    ],[
                        'initial_comment.required' => 'Initial_comment is required' 
                    ]);
                    if ($validator->fails()) {
                        return $this->failure("Failed",201,$validator->errors());  
                     }
                     $intcmtarray = array('input'=>$post_data['initial_comment'],'type'=>'string', 'enc_data'=>FALSE );
                     $cmtsvalidation= $this->Rv_validator($intcmtarray);  
                     if($cmtsvalidation==false)
                        {
                            $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');;
                            return $this->warning("Failed",201,$arraymsg);     
                        }
                   
                $article_id = $this->decrypt_data($post_data['article_id']);
                if(!empty($article_id))
                {
                $core_role = $post_data['core_role'];
                $role_name = $post_data['role_name'];
                $Articles=new \App\Models\Articles();
                $Generic_discussion=new \App\Models\Generic_discussion();
                $check_title_ckck = array(
                    'gdis_art_id' => $article_id,
                    'gdis_title'=>$post_data['title']
                );
                $disc_title = $Generic_discussion::get_single_record_with_bind_cond('gdis_id', $check_title_ckck );
                if(!empty($disc_title))
                {
                    $arraymsg['chatmesage'] = 'Discussion has been already started with this title';
                    return $this->warning("Failed",201,$arraymsg);    
                }
                $art_art_artp_id = $Articles::get_single_record('art_artp_id','art_id ='.$article_id);
                $artp_id =$art_art_artp_id->art_artp_id;
                $status_id = $this->decrypt_data($post_data['status_id']);
                if(isset($post_data['all_user_check']) && $post_data['all_user_check'] == 'y')
			    {
                    $particpant_by_usr = explode(',',$post_data['all_usr_ids']);
                    $particpant_by_usr =json_encode(array_values($particpant_by_usr));
				    $all_user_chk = 'y';
                   
			    }
			    else
			    {
                    $all_user_chk = 'n';
                    $from_data= $post_data['discussion_user'];
                    $admin_roles=explode(",",$from_data);
                    $particpant_by_usr = json_encode($admin_roles);
			    }
                $Users=new \App\Models\User();
                
                $Generic_discussion_comments=new \App\Models\Generic_discussion_comments();
                $Articles=new \App\Models\Articles();
                $User_to_journals=new \App\Models\User_to_journals();
                $Roles=new \App\Models\Roles();
                $Article_types=new \App\Models\Article_types();
                $Article_type_advance_options=new \App\Models\Article_type_advance_options();
                $Stage_email_templates=new \App\Models\Stage_email_templates();
                $Custom_email_template_tags=new \App\Models\Custom_email_template_tags();
                $Batch_id_generate=new \App\Models\Batch_id_generate();
                $Email_send_log=new \App\Models\Email_send_log();
                $Authors=new \App\Models\Authors();
                $Article_reviewers=new \App\Models\Article_reviewers();
               // $Article_status_link_statistics=new \App\Models\Article_status_link_statistics();
                $Article_generic_form_data=new \App\Models\Article_generic_form_data();
                $Article_flow=new \App\Models\Article_flow();
                $Generic_flows=new \App\Models\Generic_flows();
               $data = array(
                    'gdis_art_id' => $article_id,
                    'gdis_title' => trim($post_data['title']),
                    'gdis_started_by' => $this->current_user['user_id'],
                    'gdis_status' =>'o',
                    'gdis_time_status' =>'o',
                    'gdis_posted_by' =>$this->current_user['user_id'],
                    'gdis_posted_date' => date('Y-m-d H:i:s'),
                    'gdis_operation' => 'i'
                );
               
                if(isset($post_data['discussion_type']) && $post_data['discussion_type'] !='')
		        { 
		            $data['gdis_dsctp_id'] = $post_data['discussion_type'];	
		        }
		        if(!empty($particpant_by_usr))
		        {
			        $data['gdis_participants_by_usr_id'] = $particpant_by_usr;
		        }
		        if(isset($all_user_chk))
		        {
			        $data['gdis_enable_all_user'] = $all_user_chk;
		        } if(isset($post_data['gdis_hold_task']) && $post_data['gdis_hold_task'] !='')
                {
                    $data['gdis_hold_task'] =  $post_data['gdis_hold_task'];
			        $data['gdis_aflw_id'] = $status_id; /* To know which stage is discussion started */
                }
              $result_generic_discussion = $Generic_discussion::insert_record($data, $this->current_user);
              $comnt_data = array(
                'gdsc_gdis_id' => $result_generic_discussion,
                'gdsc_comment' => trim($post_data['initial_comment']),
                'gdsc_posted_by' =>$this->current_user['user_id'],
                'gdsc_posted_date' => date('Y-m-d H:i:s'),
                'gdsc_operation' => 'i'
                );
                $result_generic_discussion_cmnts= $Generic_discussion_comments::insert_record($comnt_data, $this->current_user); 
                $data = array();
                if ($result_generic_discussion_cmnts > 0)
				{
                    $date_format = $this->get_platform_date_format($post_data['jnl_id']);
                    $date_format= date_format_map($date_format);
                    $discussion = $Generic_discussion::get_generic_discussions($result_generic_discussion,$date_format);
                    $data['all_discussion'] = $discussion;
					$data['gdis_id'] = $result_generic_discussion;
					$data['user_data'] = $this->current_user['user_id'];
					$data['article_id'] = $article_id;
					$data['show_close_discussion'] = TRUE;
					$data['disc_type_id'] = $post_data['discussion_type'];
                    
                    if(!empty($particpant_by_usr))
					{
                        $userlist = json_decode($particpant_by_usr);
						$particpant_by_usr = $this->current_user['user_id'];
                        $userlist[] = $particpant_by_usr;
                        $impusers=implode(',',$userlist);
                        $data['gen_disc_user_ids'] =$impusers;
                        $user_criteria = "usr_id IN ({$impusers})";
						//$data['gen_disc_user_ids'] = implode(',',$particpant_by_usr);
						//$user_criteria = 'usr_id IN ('.$data['gen_disc_user_ids'].')';
						$user_participants = $Users::get_all_records('CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as full_name,usr_first_name,usr_middle_name,usr_last_name',$user_criteria);
						if(!empty($user_participants))
						{  
							$disc_user_html ='<table>';
							foreach($user_participants as $users)
							{
								($users->usr_middle_name!='' || !empty($users->usr_middle_name)) ? $name=$users->usr_first_name.' '.$users->usr_middle_name.' '.$users->usr_last_name : $name=$users->usr_first_name.' '.$users->usr_last_name;
								$disc_user_html .='<tr><td>'.$name.' </td></tr>' ;
							}
							$disc_user_html.='</table>';
							
						}
						$data['disc_user_html'] = $disc_user_html;	
						
					}
                    $client_code = $this->current_client->clnt_client_code;
                    $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default.max_disc_commnt_size';
                    $commnt_size   = Config::get($client_default);
                    $data['cmmnt_limit'] = $commnt_size;
                    
                   //new email code
                /*   $custom_data=array( 
                    'cc_email'=>$user_email,
                    'cc_confirmation_link'=>URL::to('/') . '/confirmation/cc-mail/' . $activation_url,
                    'confirm_cc_email'=>TRUE);
                    $email_data=array(
                    'type'=>'global',
                    'action'=>'send',
                    'email_with_login'=>FALSE,
                    'user_id'=>$userlist,
                    'empt_name'=>'start_generic_discussion'
                   // 'custom_data'=>$custom_data
                );
                
                $this->master_email_details($email_data);*/

                    //Email
                    $jnl_journal_code=isset($post_data['jnl_code'])?$post_data['jnl_code']:'';
                    $Email_templates = new \App\Models\Email_templates;
                    $record = $Email_templates::get_single_record('*',"etmp_name = 'start_generic_discussion' AND etmp_notification = 'Users'" );
        
					if(!empty($record))
					{
					$send_mail_to =[];
					$send_mail_to_usr_ids =[];
			
				if(!empty($discussion_user_role))
				{ 

					$discussion_user_roles = json_decode($discussion_user_role);
					foreach($discussion_user_roles  as $user_role)
					{ 
						$etmp_notification = $Roles::get_single_record('role_name,role_assigned_role','role_id ='.$user_role);
						$send_mail_to_detail = $this->send_email_to($etmp_notification->role_name,$jnl_journal_code, $artp_id, $article_id); 
						if(!empty($send_mail_to_detail['usr_ids']))
						{
						$send_mail_to_user_array = explode(',',$send_mail_to_detail['usr_ids']);
						$send_mail_to_email_array = explode(',',$send_mail_to_detail['email_ids']);
						$article_user = $this->get_article_assgned_user($send_mail_to_detail['usr_ids'],$article_id, $user_role);
						if(!empty($article_user))
						   { 
							   $users=explode(',',$article_user[0]->userids);
							 
							   foreach($send_mail_to_user_array as $key=>$usrs)
							   {   
								   if (!in_array($usrs,$users))
								   { 
									   unset($send_mail_to_user_array[$key]);
									   unset($send_mail_to_email_array[$key]);
								   } 
							   }
						   }
						$send_mail_to = array_unique(array_merge($send_mail_to,$send_mail_to_email_array));
				   		$send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,$send_mail_to_user_array));	   
					}
				  }
				} 
				// if (isset($userlist) && !in_array('-1', $userlist))
				// {
                        
				// 	$usrs_email = $Users::get_single_record('GROUP_CONCAT(usr_email SEPARATOR ",") as usrs_email, GROUP_CONCAT(usr_id SEPARATOR ",") as usrs_ids', 'usr_id IN ('.implode(',',$userlist).')'); 
                  
                //     $send_mail_to = array_unique(array_merge($send_mail_to,(explode(',',$usrs_email->usrs_email))));

				//     $send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,explode(',',$usrs_email->usrs_ids)));
				// }
                if (isset($userlist) && !in_array('-1', $userlist))
				{
                        
					$usrs_email = $Users::get_all_records('usr_email  as usrs_email, usr_id  as usrs_ids', 'usr_id IN ('.implode(',',$userlist).')'); 
                    foreach($usrs_email as $usrsemail)
                    {
                        $send_mail_to[] = $usrsemail->usrs_email;
                        $send_mail_to_usr_ids[] = $usrsemail->usrs_ids;
                    }
                    $send_mail_to =array_unique($send_mail_to);
                    $send_mail_to_usr_ids =array_unique($send_mail_to_usr_ids);
				}
                if (($key = array_search($this->current_user['user_id'], $send_mail_to_usr_ids)) !== false)
				{
					unset($send_mail_to_usr_ids[$key]);
					unset($send_mail_to[$key]);
				} 
               
				$article_url =  URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_journal_code . '/view-article?' . encrypt_link('&article_id=' . $article_id . '&status_id=' . $status_id);
				$send_mail_to = implode(', ',array_unique($send_mail_to));
				$send_mail_to_usr_ids = implode(', ',array_unique($send_mail_to_usr_ids));

				if($send_mail_to != '')
				{
                $email_data = new stdClass;
				$email_data->article_id = $article_id;
				$email_data->jnl_id = $post_data['jnl_id'];
                $reply_to=$this->get_reply_to_email($post_data['jnl_id']);
                $email_data->reply_to = $reply_to;
				$email_data->jnl_journal_code = $jnl_journal_code;
				$email_data->gen_disc_id = $result_generic_discussion;
				$email_data->gen_disc_commnt_id = $result_generic_discussion_cmnts;
				$email_data->user_id = $this->current_user['user_id'];
				$email_data->user_email = $send_mail_to;
				$email_data->aflw_id = $status_id;
                $email_data->ARTICLE_STATUS_LINK = $article_url;
				$email_data->mail_recipient_ids = $send_mail_to_usr_ids;
				$email_data->email_templates_config = $this->email_templates_config();
				$email_data->join_config = $this->join_config();
				$email_data->join_dependency_config = $this->join_dependency_config();
				$email_data->user_role_tags = $this->user_role_tags();
				$email_data->artp_id = $artp_id;
                $core_role=(isset($post_data['core_role']))?$post_data['core_role']:'';
                $email_data->core_role = $core_role;
                $core_role_name=(isset($post_data['role_name']))?$post_data['role_name']:'';
                $email_data->core_role_name = $core_role_name;
				// $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
				// $email_data->core_role = $core_role;
				// $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
				// $email_data->core_role_name = $core_role_name;
				$email_data->esl_etmp_action = 'discussion_start';
				$email_data->discussion_notify = TRUE;
                $data = array(
                    'record' => $record,
                    'email_data' => $email_data,
                    'user_data' =>$this->current_user,
                    'column_prefix' =>'etmp_',
                );
				$this->notify_mail($data);
				}
			    }



                    $cond = ' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$this->current_user['user_id'].') is NOT NULL OR gdis_started_by='.$this->current_user['user_id'].')';	
		            $sql ='SELECT `gdis_title`,`gdis_id`,`gdis_participants_by_role_id`,`gdis_participants_by_usr_id`,`gdis_status`,`gdis_started_by`,`gdis_art_id`,`gdis_dsctp_id`, gdis_enable_all_user, IF(tbl_disc_read.total IS NOT NULL,tbl_disc_read.total, 0) AS unread, tbl_disc_read.disc_cmnt_id,tbl_totl_cmnt.total_cmnts FROM `rvw_generic_discussion` LEFT JOIN(SELECT gdsc_gdis_id,GROUP_CONCAT(gdsc_id) as disc_cmnt_id, COUNT(rvw_generic_discussion_cmts.gdsc_gdis_id) AS total FROM rvw_generic_discussion JOIN rvw_generic_discussion_cmts ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id WHERE gdsc_id NOT IN( SELECT gdrs_gdsc_id FROM rvw_generic_discussion_read_status WHERE gdrs_posted_by = '.$this->current_user['user_id'].') AND gdsc_posted_by <>'.$this->current_user['user_id'].' AND gdis_art_id = '.$article_id.' group by gdis_id) AS tbl_disc_read ON  gdis_id = tbl_disc_read.gdsc_gdis_id LEFT JOIN (SELECT gdsc_gdis_id,COUNT(gdsc_id) AS total_cmnts FROM rvw_generic_discussion INNER JOIN rvw_generic_discussion_cmts ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id WHERE gdsc_id IN(SELECT gdrs_gdsc_id FROM rvw_generic_discussion_read_status WHERE gdrs_posted_by ='.$this->current_user['user_id'].') AND gdis_art_id = '.$article_id.' AND gdsc_posted_by <> '.$this->current_user['user_id'].' GROUP BY gdis_id) as tbl_totl_cmnt ON gdis_id = tbl_totl_cmnt.gdsc_gdis_id  WHERE gdis_art_id='.$article_id.' AND gdis_id='.$result_generic_discussion.' '. $cond.' ORDER BY gdis_id ASC' ;
		            $discussion_list = $Generic_discussion::get_records_by_raw_query($sql);
        
		            $return_array['discussion_list'] = $discussion_list;

                    $message = 'New discussion added successfully';
                    return $this->success($message, 200, $return_array);


                }
            }

            }
            else{
                //Edit
                if(!empty($post_data['article_id']) && !empty($post_data['hdn_gen_disc_id']))
                {
                $core_role = $post_data['core_role'];
                $role_name = $post_data['role_name'];
                $article_id = $this->decrypt_data($post_data['article_id']);
                $Articles=new \App\Models\Articles();
                $art_art_artp_id = $Articles::get_single_record('art_artp_id','art_id ='.$article_id);
                $artp_id =$art_art_artp_id->art_artp_id;
                $status_id = $this->decrypt_data($post_data['status_id']);
                $Users=new \App\Models\User();
                $Generic_discussion=new \App\Models\Generic_discussion();
                $Generic_discussion_comments=new \App\Models\Generic_discussion_comments();
                $Articles=new \App\Models\Articles();
                $User_to_journals=new \App\Models\User_to_journals();
                $Roles=new \App\Models\Roles();
                $Article_types=new \App\Models\Article_types();
                $Article_type_advance_options=new \App\Models\Article_type_advance_options();
                $Stage_email_templates=new \App\Models\Stage_email_templates();
                $Custom_email_template_tags=new \App\Models\Custom_email_template_tags();
                $Batch_id_generate=new \App\Models\Batch_id_generate();
                $Email_send_log=new \App\Models\Email_send_log();
                $Authors=new \App\Models\Authors();
                $Article_reviewers=new \App\Models\Article_reviewers();
               // $Article_status_link_statistics=new \App\Models\Article_status_link_statistics();
                $Article_generic_form_data=new \App\Models\Article_generic_form_data();
                $Article_flow=new \App\Models\Article_flow();
                $Generic_flows=new \App\Models\Generic_flows();
                $Generic_discussion=new \App\Models\Generic_discussion();
                $check_title_ckck = "gdis_art_id={$article_id} AND gdis_title='{$post_data['title']}' AND gdis_id!={$post_data['hdn_gen_disc_id']}";
                $disc_title = $Generic_discussion::get_single_record('gdis_id', $check_title_ckck );
                if(!empty($disc_title))
                {
                    $arraymsg['chatmesage'] = 'Discussion has been already started with this title';
                    return $this->warning("Failed",201,$arraymsg);    
                }
                $data = array(
			       'gdis_title' => trim($post_data['title'])
                    );
                 
                if (isset($post_data['discussion_user']) && !isset($post_data['all_user_check']))
                { 

                   $particpant_by_usr = explode(',',$post_data['discussion_user']);
                   $data['gdis_participants_by_usr_id'] =json_encode(array_values($particpant_by_usr));
                   if($post_data['hdn_part_user_ids'] != '')
                    {                        
                        $prev_user_ids = json_decode($post_data['hdn_part_user_ids']);
                        $particpant_byuser = explode(',',$post_data['discussion_user']);
                        $discussion_user_ids = array_diff($particpant_byuser, $prev_user_ids );                        
                    }
                    else
                    {
                        $discussion_user_ids = 	$post_data['discussion_user'];
                    }	        
                }
                    elseif($post_data['all_user_check'] == 'y')
                    {
                        $all_users = $this->get_all_artp_users($post_data['hdn_disc_type_id'],$article_id,$artp_id);
                        if(!empty($all_users))
                        {
                        foreach($all_users  as $usr)
                        {
                                $user_arry[] = "".$usr->usr_id."";
                        }
                        }
                        
                        if($post_data['hdn_part_user_ids'] != '')
                        {
                            $prev_user_ids = json_decode($post_data['hdn_part_user_ids']);

                            $discussion_user_ids = array_diff($user_arry, $prev_user_ids ); 
                        }
                       
                        $data['gdis_enable_all_user'] = 'y';
                        $data['gdis_participants_by_usr_id'] = json_encode(array_values($user_arry));
                    }
                        if(!isset($post_data['all_user_check']))
                        { 

                            $data['gdis_enable_all_user'] = 'n';
                        }
                        if(isset($post_data['gdis_hold_task']) && $post_data['gdis_hold_task'] !='')
                        {
                            $data['gdis_hold_task'] =  'y';
			                $data['gdis_aflw_id'] = $status_id; /* To know which stage is discussion started */
                        }else{
                            $data['gdis_hold_task'] =  'n';
                        }
                        $criteria = "gdsc_gdis_id={$post_data['hdn_gen_disc_id']}";
                        $gen_disc_cmnt_id = $Generic_discussion_comments::get_single_record('gdsc_id',$criteria );
                        //email template
                        $data['gdis_time_status'] =  'o';
                        $conditions = "gdis_id={$post_data['hdn_gen_disc_id']}";
                        $edit_id = $Generic_discussion::update_record($data, $conditions,$this->current_user);


                    //Email
                    $jnl_journal_code=isset($post_data['jnl_code'])?$post_data['jnl_code']:'';

                    $Email_templates = new \App\Models\Email_templates;
                    $record = $Email_templates::get_single_record('*',"etmp_name = 'generic_discussion_updation' AND etmp_notification = 'Users'" );
					if(!empty($record))
					{
                        
					$send_mail_to =[];
					$send_mail_to_usr_ids =[];
			
                    if(!empty($discussion_user_role))
                    { 
    
                        foreach($discussion_user_role  as $user_role)
                        { 
                            $etmp_notification = $Roles::get_single_record('role_name,role_assigned_role','role_id ='.$user_role);
                            $send_mail_to_detail = $this->send_email_to($etmp_notification->role_name,$this->journal_code, $artp_id, $article_id); 
                            $send_mail_to_user_array = explode(',',$send_mail_to_detail['usr_ids']);
                            $send_mail_to_email_array = explode(',',$send_mail_to_detail['email_ids']);
                            if($etmp_notification->role_assigned_role != 'journal_admin')
                            {
                            $article_user = $this->get_article_assgned_user($send_mail_to_detail['usr_ids'],$article_id, $user_role);
                            if(!empty($article_user))
                               { 
                                   $users=explode(',',$article_user[0]->userids);
                                   
                                   foreach($send_mail_to_user_array as $key=>$usrs)
                                   { 
                                       if (!in_array($usrs,$users))
                                       { 
                                           unset($send_mail_to_user_array[$key]);
                                           unset($send_mail_to_email_array[$key]);
                                       } 
                                   }
                               }
                            }	
                            $send_mail_to = array_unique(array_merge($send_mail_to,$send_mail_to_email_array));
                               $send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,$send_mail_to_user_array));	
                        }	
                    }
                    // if (!empty($discussion_user_ids ))
                    // {
                    //     $usrs_email = $Users::get_single_record('GROUP_CONCAT(usr_email SEPARATOR ", ") as usrs_email, GROUP_CONCAT(usr_id SEPARATOR ", ") as usrs_ids', 'usr_id IN ('.implode(',', $discussion_user_ids).')'); 
                    //     $send_mail_to = array_unique(array_merge($send_mail_to,(explode(',',$usrs_email->usrs_email))));
                    //     $send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,explode(',',$usrs_email->usrs_ids)));
                    // }

                    if (!empty($discussion_user_ids ))
                    {
                        $usrs_email = $Users::get_all_records('usr_email as usrs_email, usr_id as usrs_ids', 'usr_id IN ('.implode(',', $discussion_user_ids).')'); 
                        if(!empty($usrs_email))
                        {
                        foreach($usrs_email as $usrsemail)
                        {
                            $send_mail_to[] = $usrsemail->usrs_email;
                            $send_mail_to_usr_ids[] = $usrsemail->usrs_ids;
                        }
                        $send_mail_to =array_unique($send_mail_to);
                        $send_mail_to_usr_ids =array_unique($send_mail_to_usr_ids);
                    }
                    }
                    if (($key = array_search($this->current_user['user_id'], $send_mail_to_usr_ids)) !== false)
                    {
                    unset($send_mail_to_usr_ids[$key]);
                    unset($send_mail_to[$key]);
                    } 
                    $send_mail_to = implode(', ',$send_mail_to);
                    $send_mail_to_usr_ids = implode(', ',$send_mail_to_usr_ids);
                    $article_url =  URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_journal_code . '/view-article?' . encrypt_link('&article_id=' . $article_id . '&status_id=' . $status_id);
				if($send_mail_to != '')
				{
                    $email_data = new stdClass;
                    $email_data->article_id = $article_id;
                    $email_data->aflw_id = $status_id;
                    $email_data->jnl_id = $post_data['jnl_id'];
                    $reply_to=$this->get_reply_to_email($post_data['jnl_id']);
                    $email_data->reply_to = $reply_to;
                    $email_data->jnl_journal_code = $jnl_journal_code;
                    $email_data->ARTICLE_STATUS_LINK = $article_url;
                    $email_data->gen_disc_id = $post_data['hdn_gen_disc_id'];
                    $email_data->gen_disc_commnt_id = $gen_disc_cmnt_id->gdsc_id;
                    $email_data->user_id = $this->current_user['user_id'];
                    $email_data->user_email = $send_mail_to;
                    $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
                    $email_data->email_templates_config = $this->email_templates_config();
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    $email_data->artp_id =$artp_id;
                    $core_role=(isset($post_data['core_role']))?$post_data['core_role']:'';
                    $email_data->core_role = $core_role;
                    $core_role_name=(isset($post_data['role_name']))?$post_data['role_name']:'';
                    $email_data->core_role_name = $core_role_name;
                    // $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
                    // $email_data->core_role = $core_role;
                    // $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
                    // $email_data->core_role_name = $core_role_name;
                    $email_data->esl_etmp_action = 'discussion_updation';
                    $email_data->discussion_notify = TRUE;

                $data = array(
                    'record' => $record,
                    'email_data' => $email_data,
                    'user_data' =>$this->current_user,
                    'column_prefix' =>'etmp_',
                );
				$this->notify_mail($data);
				}
			    }

              
                        if($edit_id > 0)
                        {
                            $cond = ' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$this->current_user['user_id'].') is NOT NULL OR gdis_started_by='.$this->current_user['user_id'].')';	
                            $sql ='SELECT `gdis_title`,`gdis_id`,`gdis_participants_by_role_id`,`gdis_participants_by_usr_id`,`gdis_status`,`gdis_started_by`,`gdis_art_id`,`gdis_dsctp_id`, gdis_enable_all_user, IF(tbl_disc_read.total IS NOT NULL,tbl_disc_read.total, 0) AS unread, tbl_disc_read.disc_cmnt_id,tbl_totl_cmnt.total_cmnts FROM `rvw_generic_discussion` LEFT JOIN(SELECT gdsc_gdis_id,GROUP_CONCAT(gdsc_id) as disc_cmnt_id, COUNT(rvw_generic_discussion_cmts.gdsc_gdis_id) AS total FROM rvw_generic_discussion JOIN rvw_generic_discussion_cmts ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id WHERE gdsc_id NOT IN( SELECT gdrs_gdsc_id FROM rvw_generic_discussion_read_status WHERE gdrs_posted_by = '.$this->current_user['user_id'].') AND gdsc_posted_by <>'.$this->current_user['user_id'].' AND gdis_art_id = '.$article_id.' group by gdis_id) AS tbl_disc_read ON  gdis_id = tbl_disc_read.gdsc_gdis_id LEFT JOIN (SELECT gdsc_gdis_id,COUNT(gdsc_id) AS total_cmnts FROM rvw_generic_discussion INNER JOIN rvw_generic_discussion_cmts ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id WHERE gdsc_id IN(SELECT gdrs_gdsc_id FROM rvw_generic_discussion_read_status WHERE gdrs_posted_by ='.$this->current_user['user_id'].') AND gdis_art_id = '.$article_id.' AND gdsc_posted_by <> '.$this->current_user['user_id'].' GROUP BY gdis_id) as tbl_totl_cmnt ON gdis_id = tbl_totl_cmnt.gdsc_gdis_id  WHERE gdis_art_id='.$article_id.' AND gdis_id='.$post_data['hdn_gen_disc_id'].' '. $cond.' ORDER BY gdis_id ASC' ;
                            $discussion_list = $Generic_discussion::get_records_by_raw_query($sql);
                
                            $return_array['discussion_list'] = $discussion_list;
                            $message = 'Updated successfully';
                            return $this->success($message, 200, $return_array);

                        }

                    }
                
            }
        }
            
        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function get_generic_discussion_details(Request $request)
    {
        try {
            $article_id = ''; /* current active article id */
            $art_type_id = '';
            $cond = '';
            $hdn_art_id = ''; 
            $role_id='';
            $commnt_size=0;
            $article_flow_id ='';
            $hide_reopen = FALSE;
            $atotp_generic_discussion = array();
            $this->current_user = $this->get_current_user_details();
            $this->current_user['user_id'];
            $post_data = $request->all();
            $article_id = Rv_Decrypt($post_data['article_id']);
            $jnl_id =isset($post_data['jnl_id']) ?  Rv_Decrypt($post_data['jnl_id']) : ''; 
            $article_flow_id =isset($post_data['article_flow_id']) ?  Rv_Decrypt($post_data['article_flow_id']) : ''; 
            $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : ''; 
            $array['article_id']=$article_id;
            $array['type']='discussion';
            $array['jnl_code']=$jnl_code;
            $array['current_flow_id']=$article_flow_id;
            $array['url']=$request->segment(4);
            $array['user_id']=$this->current_user['user_id'];
            $artclearray = array('input'=>Rv_Decrypt($post_data['article_id']),'type'=>'number', 'enc_data'=>FALSE );
            $artclevalidation= $this->Rv_validator($artclearray);
            if($artclevalidation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                return $this->warning("Failed",201,$arraymsg);     
            }
            $jnl_id_array = array('input'=>Rv_Decrypt($post_data['jnl_id']),'type'=>'number', 'enc_data'=>FALSE );
            $jnl_idvalidation= $this->Rv_validator($jnl_id_array);
            if($jnl_idvalidation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                return $this->warning("Failed",201,$arraymsg);     
            }

            if(!empty($article_flow_id))
            {
                $flowarrays = array('input'=>Rv_Decrypt($post_data['article_flow_id']),'type'=>'number', 'enc_data'=>FALSE ); 
                $flowvalidation_flid= $this->Rv_validator($flowarrays); 
                if($flowvalidation_flid==false)
                {
                    $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                    return $this->warning("Failed",201,$arraymsg);     
                } 
            }
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return response()->json(['status' => false,'message'=>'Unauthorized User','success'=>false]);
            }
            $Articles=new \App\Models\Articles();
            $art_art_artp_id = $Articles::get_single_record('art_artp_id,art_submitted_by,art_status,art_code','art_id ='.$article_id);
            $art_type_id =$art_art_artp_id->art_artp_id;
            $art_code =$art_art_artp_id->art_code;
            $client_code = $this->current_client->clnt_client_code;
            $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default.max_disc_commnt_size';
            $commnt_size   = Config::get($client_default);
            $return_array['cmmnt_limit'] = $commnt_size;
           $core_role = $post_data['core_role'];
           $role_id = $post_data['role_id'];
           $Generic_discussion=new \App\Models\Generic_discussion();
           $Article_types=new \App\Models\Article_types();
           $Roles=new \App\Models\Roles();
           $User_to_journals=new \App\Models\User_to_journals();
           $Users=new \App\Models\User();
           $Article_type_advance_options=new \App\Models\Article_type_advance_options();
           $Journal_permission=new \App\Models\Journal_permission();
           $Discussion_type=new \App\Models\Discussion_type();
           $Authors=new \App\Models\Authors();
           $Article_flow=new \App\Models\Article_flow();
           $User_articles=new \App\Models\User_articles();
           $Generic_flows=new \App\Models\Generic_flows();
           $Articlestable = (new \App\Models\Articles())->getTable();
           $revisiincheckdata = array(
            'art_status' => 'c',
            'art_id'=>$article_id
            );
            $resultcheck = $Articles::get_single_record_with_bind_cond('art_id',$revisiincheckdata);
            if(!empty($resultcheck))
            {
                $hide_reopen = TRUE;  
            }
          /* if($hdn_art_id != $article_id)
		    {
			$hide_reopen = TRUE; *//* hide reopen button in original revision */
		  //  }
           $return_array['art_status'] =''; 
           $return_array['art_pre_all_ids'] =''; 
           $return_array['art_code'] =$art_code;   
            $art_submited_sql = 'SELECT art_submitted_by,art_status,art_code,art_pre_all_ids  FROM '.$Articlestable.' WHERE art_id ='.$article_id;
		   $article_submitted_by = $Articles::get_records_by_raw_query($art_submited_sql); 
           if(!empty($article_submitted_by))
           {
               
            foreach($article_submitted_by as $rls)
             {
                $return_array['art_status'] = $rls->art_status; 
                $return_array['art_pre_all_ids'] = $rls->art_pre_all_ids;   
             }
           
           }
          // $this->data['article_submitted_by'] = $Articles::get_records_by_raw_query($art_submited_sql); 

           $select ="artp_id,artp_jnl_id,jp_generic_discussion as atotp_generic_discussion,artp_article_type as art_type_name";
           $articletypestable = (new \App\Models\Article_types())->getTable();
           $Journalpermissiontable = (new \App\Models\Journal_permission())->getTable();
           $jnl_tables = array(
			'main_table' => $articletypestable,
			'join_table' => array(
				$Journalpermissiontable => array($Journalpermissiontable.'.jp_jpm_id', $articletypestable. '.artp_jpm_id','left')
		));
		
		$jnl_criteria = "artp_id={$art_type_id}";
		$art_detail = $Article_types::get_results_using_joins($jnl_tables,$select, $jnl_criteria,'single');
        $return_array['article_id'] = $article_id;
        $return_array['permitted_user'] = FALSE;
	    if($art_detail->atotp_generic_discussion != '')
		{
			$atotp_generic_discussion = json_decode($art_detail->atotp_generic_discussion);
           
			if (in_array($role_id , $atotp_generic_discussion)) 
			{
				$return_array['permitted_user'] = TRUE;
               
			}
		}
        $return_array['show_discussion_list'] = FALSE;
		$return_array['show_discussion_perm_allowed'] = FALSE;
		$disc_type = $Discussion_type::get_all_records('dsctp_id as disc_type_id,dsctp_role_id as role_id, dsctp_type as disc_type');
        $return_array['disc_type'] = $disc_type;
        $return_array['article_type_data'] =$art_detail;
		$cond = ' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$this->current_user['user_id'].') is NOT NULL OR gdis_started_by='.$this->current_user['user_id'].')';	
		$sql ='SELECT `gdis_title`,`gdis_id`,`gdis_participants_by_role_id`,`gdis_participants_by_usr_id`,`gdis_status`,`gdis_started_by`,`gdis_art_id`,`gdis_dsctp_id`, gdis_enable_all_user, IF(tbl_disc_read.total IS NOT NULL,tbl_disc_read.total, 0) AS unread, tbl_disc_read.disc_cmnt_id,tbl_totl_cmnt.total_cmnts FROM `rvw_generic_discussion` LEFT JOIN(SELECT gdsc_gdis_id,GROUP_CONCAT(gdsc_id) as disc_cmnt_id, COUNT(rvw_generic_discussion_cmts.gdsc_gdis_id) AS total FROM rvw_generic_discussion JOIN rvw_generic_discussion_cmts ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id WHERE gdsc_id NOT IN( SELECT gdrs_gdsc_id FROM rvw_generic_discussion_read_status WHERE gdrs_posted_by = '.$this->current_user['user_id'].') AND gdsc_posted_by <>'.$this->current_user['user_id'].' AND gdis_art_id = '.$article_id.' group by gdis_id) AS tbl_disc_read ON  gdis_id = tbl_disc_read.gdsc_gdis_id LEFT JOIN (SELECT gdsc_gdis_id,COUNT(gdsc_id) AS total_cmnts FROM rvw_generic_discussion INNER JOIN rvw_generic_discussion_cmts ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id WHERE gdsc_id IN(SELECT gdrs_gdsc_id FROM rvw_generic_discussion_read_status WHERE gdrs_posted_by ='.$this->current_user['user_id'].') AND gdis_art_id = '.$article_id.' AND gdsc_posted_by <> '.$this->current_user['user_id'].' GROUP BY gdis_id) as tbl_totl_cmnt ON gdis_id = tbl_totl_cmnt.gdsc_gdis_id  WHERE gdis_art_id='.$article_id. $cond.' AND gdis_dsctp_id is NOT NULL ORDER BY gdis_id ASC' ;
		$discussion_list = $Generic_discussion::get_records_by_raw_query($sql);
        
		$return_array['discussion_list'] = $discussion_list;
        if(!empty($atotp_generic_discussion) && in_array($role_id,$atotp_generic_discussion) && empty($discussion_list))
		{
			$return_array['show_discussion_perm_allowed'] = TRUE;	
			
		}
		if(!empty($discussion_list))
		{
			$return_array['show_discussion_list'] = TRUE;		
		}
		$return_array['hide_reopen'] = $hide_reopen;

        $select_article_details = 'jwf_status_name,jwf_stage_name,aflw_status,jwf_stage_type';
       $condition = "aflw_art_id={$article_id} and jnl_id={$jnl_id} and auth_corr_author='y'";
        if (!empty($article_flow_id)) {
            $condition .= " and aflw_id={$article_flow_id}";
        }
        $return_array['jwf_status_name'] ='';
        $article_details = $Articles::get_article_details($select_article_details, $condition, NULL, TRUE, TRUE);
        foreach ($article_details as $article) {
            $return_array['jwf_status_name'] = $article->jwf_status_name;
        }
		//$generic_discussion_html = $this->load->view('view_article_modification/article_generic_discussion', $this->data, TRUE);
		return $return_array;


        }catch (\Exception $e) {
             
            return  $this->failure('Failed', 500, $e);
        }

    }
    
    public function update_generic_discussion(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $Email_templates = new \App\Models\Email_templates;
            $post_data = $request->all();
            $current_role ='';
            $discussion_user_role = array();
			$discussion_user_ids = array();
            $arraymsg = array();
			$article_id = '';
			$status_id = '';
			$proxy_user_name = '';
            $gdis_id='';
            $Users=new \App\Models\User();
            $Generic_discussion=new \App\Models\Generic_discussion();
            $jnl_id=($post_data['jnl_id'])?$post_data['jnl_id']:'';
            $article_ids = isset($post_data['article_id']) ?  $this->decrypt_data($post_data['article_id']) : '';
            $flow_id =isset($post_data['current_status_id']) ?  $this->decrypt_data($post_data['current_status_id']) : ''; 
            $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : ''; 
            $array['article_id']=$article_ids;
            $array['type']='discussion';
            $array['jnl_code']=$jnl_code;
            $array['current_flow_id']=$flow_id;
            $array['url']=$request->segment(4);
            $array['user_id']=$this->current_user['user_id'];
            $user_access=$this->check_permission_access_user($array);
            if($user_access!=true)
            {
                return response()->json(['status' => false,'message'=>'Unauthorized User','success'=>false]);
            }

            $validator = Validator::make($request->all(), [
                'chattext' => 'required|string',
                'article_id'=> 'required',
                'gen_disc_user_ids'=> 'required',
                'chatgdisid'=> 'required'
                
            ],[
                'chattext.required' => 'Title is required',
                'article_id.required' => 'article id is required',
                'gen_disc_user_ids.required' => 'Participants is required',
                'chatgdisid.required' => 'Chat id is required'          
            ]);
            if ($validator->fails()) {
                return $this->failure("Failed",201,$validator->errors());  
             }
             $chatarray = array('input'=>$post_data['chattext'],'type'=>'string', 'enc_data'=>FALSE );
             $artclearray = array('input'=>$post_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
             $chat= $this->Rv_validator($chatarray);     
             $artclevalidation= $this->Rv_validator($artclearray);  
           
          
            if($chat==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input_special');;
                return $this->warning("Failed",201,$arraymsg);     
            }if($artclevalidation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');;
                return $this->warning("Failed",201,$arraymsg);     
            }
            if(isset($post_data['chattext']) && $post_data['chattext']!='')
            {
                if($post_data['char_limit']!=0 && $post_data['char_limit']!='')
                {
                  if($post_data['charcterlenght']>$post_data['char_limit'])
                  {
                    $arraymsg['chatmesage'] = 'Maximum comments length exceeded.';
                    return $this->warning("Failed",201,$arraymsg);   
                  }
                }
                
            }
            if($post_data['gen_disc_role_ids']!= '')
			{
				$discussion_user_role  = json_decode($post_data['gen_disc_role_ids']);
			}
			if($post_data['gen_disc_user_ids']!= '')
			{
				$discussion_user_ids  =json_decode($post_data['gen_disc_user_ids']);
			}
            if($post_data['article_id']!= '')
			{
				$article_id  = $this->decrypt_data($post_data['article_id']);
			}
			if($post_data['current_status_id']!= '')
			{
				$status_id  = $this->decrypt_data($post_data['current_status_id']);
			}if($post_data['chatgdisid']!='')
            {
                $gdis_id= $post_data['chatgdisid']; 
            }
            
            $condcheckuserexit = ' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$this->current_user['user_id'].') is NOT NULL OR gdis_started_by='.$this->current_user['user_id'].')';	
            $sql ='SELECT `gdis_art_id` FROM `rvw_generic_discussion`  WHERE gdis_art_id='.$article_id. $condcheckuserexit.' AND gdis_dsctp_id is NOT NULL AND gdis_id='.$gdis_id.' ORDER BY gdis_id ASC' ;
            $discussion_checkuser = $Generic_discussion::get_records_by_raw_query($sql);
            if(!empty($discussion_checkuser))
            {
            if($this->current_user['proxy_user_id'] != '' &&  $this->current_user['proxy_user_id'] != $this->current_user['user_id'] )
			{
                
                $jnl_criteria = "usr_id={$this->current_user['proxy_user_id']}";
				$proxy_name = $Users::get_single_record('CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as proxy_user', $jnl_criteria);
				if(!empty($proxy_name))
                {
                $proxy_user_name = 	$proxy_name->proxy_user;
                }
			}
            $user_criteria = "usr_id={$this->current_user['user_id']}";
            $user_name = $Users::get_single_record('CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as display_name,usr_image as profile_pic', $user_criteria);
           
            $details = array(
				'rgd_text' => nl2br(trim($post_data['chattext'])),
				'rgd_user' => $user_name->display_name,
				'current_usr_pic' => $user_name->profile_pic,
				'proxy_user_name' => $proxy_user_name);
                $dicussion_details = array(
					'gdsc_gdis_id' =>$post_data['chatgdisid'] ,
					'gdsc_comment' => trim($post_data['chattext']),
					'gdsc_posted_by' =>$this->current_user['user_id'],
					'gdsc_posted_date' => date('Y-m-d H:i:s'),
					'gdsc_operation' => 'i' );
                    $Articles=new \App\Models\Articles();
                    $Generic_discussion_comments=new \App\Models\Generic_discussion_comments();
                    $Article_types=new \App\Models\Article_types();
                    $Roles=new \App\Models\Roles();
                    $User_to_journals=new \App\Models\User_to_journals();
                    $Users=new \App\Models\User();
                    $Article_type_advance_options=new \App\Models\Article_type_advance_options();
                    $Journal_permission=new \App\Models\Journal_permission();
                    $Discussion_type=new \App\Models\Discussion_type();
                    $Authors=new \App\Models\Authors();
                    $Article_flow=new \App\Models\Article_flow();
                    $User_articles=new \App\Models\User_articles();
                    $Generic_flows=new \App\Models\Generic_flows();
                    if ($post_data['edit'] == 'n')
                    {
                        $article_details = $Articles::get_single_record('art_artp_id,art_submitted_by,art_status,art_code','art_id ='.$article_id); 
                        $gdsc_id = $Generic_discussion_comments::insert_record($dicussion_details,$this->current_user);
                        $dataarray = array(
                            'gdis_time_status' => 'o'
                             );
                        $conditions1 = "gdis_id={$post_data['chatgdisid']}";
                        $Generic_discussion::update_record($dataarray, $conditions1,$this->current_user);
                        $record = $Email_templates::get_single_record('*',"etmp_name='generic_discussion_comment' AND etmp_notification='Users'");
                        if(!empty($record))
                        {
                        // Email_templates::trans_start();
                        $send_mail_to =array();
                        $send_mail_to_usr_ids = array();
                    if(!empty($discussion_user_role))
                    { 
                        
                        foreach($discussion_user_role  as $user_role)
                        { 
                                  $etmp_notification = $Roles::get_single_record('role_name,role_assigned_role','role_id ='.$user_role);
                                  $cfty_retire_role = FALSE;
                                  if ((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y') {
                                      $cfty_retire_role = TRUE;
                                  }
                                $send_mail_to_detail = $this->send_email_to($etmp_notification->role_name, $jnl_code, $article_details->art_artp_id, $article_id,$cfty_retire_role);
                                if(!empty($send_mail_to_detail['usr_ids']))
                                {
                                $send_mail_to_user_array = explode(',',$send_mail_to_detail['usr_ids']);
                                $send_mail_to_email_array = explode(',',$send_mail_to_detail['email_ids']);
                               $article_user = $this->get_article_assgned_user($send_mail_to_detail['usr_ids'],$article_id, $user_role);
                               
                               if(!empty($article_user))
                               { 
                                   $users=explode(',',$article_user[0]->userids);
                                   
                                   foreach($send_mail_to_user_array as $key=>$usrs)
                                   { 
                                       if (!in_array($usrs,$users))
                                       { 
                                           unset($send_mail_to_user_array[$key]);
                                           unset($send_mail_to_email_array[$key]);
                                       } 
                                   }
                               }
                                
                            $send_mail_to = array_unique(array_merge($send_mail_to,$send_mail_to_email_array));
                               $send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,$send_mail_to_user_array));		
                        } 	
                    }
                    }	

                    // if (!empty($discussion_user_ids) && !in_array('-1', $discussion_user_ids))
                    // { 
                    //     $usrs_email = $Users::get_single_record('GROUP_CONCAT(usr_email SEPARATOR ",") as usrs_email, GROUP_CONCAT(usr_id SEPARATOR ",") as usrs_ids', 'usr_id IN ('.implode(',', $discussion_user_ids).')'); 

                    //     $send_mail_to = array_unique(array_merge($send_mail_to,(explode(',',$usrs_email->usrs_email))));
                    //     $send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,explode(',',$usrs_email->usrs_ids)));
                    // }
                    if (!empty($discussion_user_ids) && !in_array('-1', $discussion_user_ids))
                    { 
                        
                        $usrs_email = $Users::get_all_records('usr_email as usrs_email, usr_id as usrs_ids', 'usr_id IN ('.implode(',', $discussion_user_ids).')'); 
                        if(!empty($usrs_email))
                        {
                        foreach($usrs_email as $usrsemail)
                        {
                            $send_mail_to[] = $usrsemail->usrs_email;
                            $send_mail_to_usr_ids[] = $usrsemail->usrs_ids;  
                        }
                        $send_mail_to =array_unique($send_mail_to);
                        $send_mail_to_usr_ids =array_unique($send_mail_to_usr_ids);
                        }
                    }
                    if (($key = array_search($this->current_user['user_id'], $send_mail_to_usr_ids)) !== false)
                    {
                        unset($send_mail_to_usr_ids[$key]);
                        unset($send_mail_to[$key]);
                    } 
                    $article_url = URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_code .'/view-article?' . encrypt_link('&article_id=' . $article_id . '&status_id=' . $status_id);
                    $send_mail_to = implode(', ',array_unique($send_mail_to));
                    $send_mail_to_usr_ids = implode(', ',array_unique($send_mail_to_usr_ids));
                    $email_data = new stdClass;
                    $email_data->article_id = $article_id;
                    $email_data->jnl_journal_code = $jnl_code;   
                    $email_data->jnl_id = $jnl_id;
                    $reply_to=$this->get_reply_to_email($jnl_id);
                    $email_data->reply_to = $reply_to;
                    $email_data->gen_disc_id  = $post_data['chatgdisid'];
                    $email_data->gen_disc_commnt_id = $gdsc_id;
                    $email_data->aflw_id = $status_id;
                    $email_data->ARTICLE_STATUS_LINK = $article_url;
                    $email_data->user_id =$this->current_user['user_id'];
                    $email_data->user_email = $send_mail_to;
                    $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
                    $email_data->email_templates_config = $this->email_templates_config();
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    $core_role=(isset($post_data['core_role']))?$post_data['core_role']:'';
                    $email_data->core_role = $core_role;
                    $core_role_name=(isset($post_data['role_name']))?$post_data['role_name']:'';
                    $email_data->core_role_name = $core_role_name;
                    $email_data->artp_id = $article_details->art_artp_id;
                    $email_data->esl_etmp_action = 'discussion_comment';
                    $email_data->discussion_notify = TRUE;
                    $data = array(
                        'record' => $record,
                        'email_data' => $email_data,
                        'user_data' => $this->current_user,
                        'column_prefix' =>'etmp_',
                    );
                    $this->notify_mail($data);
                }
                   // Email_templates::trans_complete();
                    }
                        $details['gen_edited'] = 'n';
                        return $this->success('success', 200, $details);
                }
                return $this->warning('failed', 200);
                
                }
                        
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    
    public function close_discussion(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $this->current_user['user_id'];
            $post_data = $request->all();
            $current_role ='';
            $disc_id = '';
            $discussion_user_role = array();
            $discussion_user_ids = array();
            $article_id = '';
            $core_role='';
            $role_name ='';
            if($post_data != '')
            {
                $article_id = isset($post_data['gen_art_id']) ?  $this->decrypt_data($post_data['gen_art_id']) : '';
                $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : ''; 
                $flow_id =isset($post_data['current_status_id']) ?  $this->decrypt_data($post_data['current_status_id']) : ''; 
                $array['article_id']=$article_id;
                $array['type']='discussion';
                $array['jnl_code']=$jnl_code;
                $array['current_flow_id']=$flow_id;
                $array['url']=$request->segment(4);
                $array['user_id']=$this->current_user['user_id'];
                $user_access=$this->check_permission_access_user($array);
            
                if($user_access!=true)
                {
                    return response()->json(['status' => false,'message'=>'Unauthorized User','success'=>false]);
                }

                $gdsarray = array('input'=>$post_data['gdis_id'],'type'=>'number', 'enc_data'=>FALSE );
                $artclearray = array('input'=>$post_data['gen_art_id'],'type'=>'number', 'enc_data'=>TRUE );
                $gdsid= $this->Rv_validator($gdsarray);     
                $artclevalidation= $this->Rv_validator($artclearray);  
           
          
            if($gdsid==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');;
                return $this->warning("Failed",201,$arraymsg);     
            }if($artclevalidation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');;
                return $this->warning("Failed",201,$arraymsg);     
            }

                $core_role = $post_data['core_role'];
                $role_name = $post_data['role_name'];
                $disc_id = $post_data['gdis_id'];
                $article_id = $this->decrypt_data($post_data['gen_art_id']);
                if($post_data['gen_disc_role_ids'] != '')
                {
                    $discussion_user_role = json_decode($post_data['gen_disc_role_ids']);
                }
                if($post_data['gen_disc_user_ids'] != '')
			    {
                json_decode($post_data['gen_disc_user_ids']);
				$discussion_user_ids = json_decode($post_data['gen_disc_user_ids']);
			    }
                
                    $status_id  =isset($post_data['current_status_id'])?$this->decrypt_data($post_data['current_status_id']):'';
            }
            $disc_close_data = array(
                'gdis_time_status' => 'c',
                'gdis_status' => 'c'
            );
            $Articles=new \App\Models\Articles();
            $Generic_discussion_comments=new \App\Models\Generic_discussion_comments();
            $Generic_discussion=new \App\Models\Generic_discussion();
            $Article_types=new \App\Models\Article_types();
            $Roles=new \App\Models\Roles();
            $User_to_journals=new \App\Models\User_to_journals();
            $Users=new \App\Models\User();
            $Article_type_advance_options=new \App\Models\Article_type_advance_options();
            $Journal_permission=new \App\Models\Journal_permission();
            $Discussion_type=new \App\Models\Discussion_type();
            $Authors=new \App\Models\Authors();
            $Article_flow=new \App\Models\Article_flow();
            $User_articles=new \App\Models\User_articles();
            $Generic_flows=new \App\Models\Generic_flows();
            $Stage_email_templates = new \App\Models\Stage_email_templates;
            $Custom_email_template_tags=new \App\Models\Custom_email_template_tags();
            $Batch_id_generate=new \App\Models\Batch_id_generate();
            $Email_send_log=new \App\Models\Email_send_log; 
            $Article_reviewers=new \App\Models\Article_reviewers();
            $Article_generic_form_data = new \App\Models\Article_generic_form_data();
            $disc_close_checkdata = array(
                'gdis_status' => 'c',
                'gdis_id'=>$disc_id
            );
            $resultcheck = $Generic_discussion::get_single_record_with_bind_cond('gdis_id',$disc_close_checkdata);
            if(!empty($resultcheck))
            {
                $arraymsg['chatmesage'] = 'Discussion already closed.';
                return $this->warning("Failed",201,$arraymsg);    
            }
            $condition = "gdis_id ={$disc_id}";
            $result = $Generic_discussion::update_record($disc_close_data, $condition,$this->current_user);
            $criteria = "art_id ={$article_id}";
            $article_details = $Articles::get_single_record('art_artp_id',$criteria);
            if($result > 0)
            {
                $jnl_journal_code=isset($post_data['jnl_code'])?$post_data['jnl_code']:'';

                $Email_templates = new \App\Models\Email_templates;
                $record = $Email_templates::get_single_record('*',"etmp_name = 'close_generic_discussion' AND etmp_notification = 'Users'" );
		
			if(!empty($record))
			{
		
			$send_mail_to =array();
			$send_mail_to_usr_ids = array();
		if(!empty($discussion_user_role))
		{
			
			foreach($discussion_user_role  as $user_role)
			{ 
				   $etmp_notification = $Roles::get_single_record('role_name,role_assigned_role','role_id ='.$user_role);
				   $send_mail_to_detail = $this->send_email_to($etmp_notification->role_name,$jnl_journal_code, $article_details->art_artp_id, $article_id);
				   if(!empty($send_mail_to_detail['usr_ids']))
				   {
				   $send_mail_to_user_array = explode(',',$send_mail_to_detail['usr_ids']);
				   $send_mail_to_email_array = explode(',',$send_mail_to_detail['email_ids']);
				 
				     $article_user = $this->get_article_assgned_user($send_mail_to_detail['usr_ids'],$article_id, $user_role);
						if(!empty($article_user))
						   { 
							   $users=explode(',',$article_user[0]->userids);
							   
							   foreach($send_mail_to_user_array as $key=>$usrs)
							   { 
								   if (!in_array($usrs,$users))
								   { 
									   unset($send_mail_to_user_array[$key]);
									   unset($send_mail_to_email_array[$key]);
								   } 
							   }
						   }
							
						$send_mail_to = array_unique(array_merge($send_mail_to,$send_mail_to_email_array));
				   		$send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,$send_mail_to_user_array));		
			  			} 
					} 
				}
		// if (!empty($discussion_user_ids) && !in_array('-1', $discussion_user_ids))
		// {
		// 	$usrs_email = $Users::get_single_record('GROUP_CONCAT(usr_email SEPARATOR ",") as usrs_email, GROUP_CONCAT(usr_id SEPARATOR ",") as usrs_ids', 'usr_id IN ('.implode(',', $discussion_user_ids).')'); 
		// 	$send_mail_to = array_unique(array_merge($send_mail_to,(explode(',',$usrs_email->usrs_email))));
		// 	$send_mail_to_usr_ids = array_unique(array_merge($send_mail_to_usr_ids,explode(',',$usrs_email->usrs_ids)));
		// }
        if (!empty($discussion_user_ids) && !in_array('-1', $discussion_user_ids))
		{
			$usrs_email = $Users::get_all_records('usr_email as usrs_email, usr_id as usrs_ids', 'usr_id IN ('.implode(',', $discussion_user_ids).')'); 
			if(!empty($usrs_email))
            {
            foreach($usrs_email as $usrsemail)
            {
                $send_mail_to[] = $usrsemail->usrs_email;
                $send_mail_to_usr_ids[] = $usrsemail->usrs_ids;
            }
                $send_mail_to =array_unique($send_mail_to);
                $send_mail_to_usr_ids =array_unique($send_mail_to_usr_ids);
            }
		}
		if (($key = array_search($this->current_user['user_id'], $send_mail_to_usr_ids)) !== false)
		{
			unset($send_mail_to_usr_ids[$key]);
			unset($send_mail_to[$key]);
		} 
		$send_mail_to = implode(',',array_unique($send_mail_to));
		$send_mail_to_usr_ids = implode(',',array_unique($send_mail_to_usr_ids));

		$email_data = new stdClass;
		$email_data->article_id = $article_id;
        $email_data->jnl_id = $post_data['jnl_id'];
        $reply_to=$this->get_reply_to_email($post_data['jnl_id']);
        $email_data->reply_to = $reply_to;
		$email_data->jnl_journal_code = $jnl_journal_code;
		$email_data->gen_disc_id  = $disc_id;
		$email_data->user_id =   $this->current_user['user_id'];
		$email_data->user_email = $send_mail_to;
        $email_data->aflw_id = $status_id;
		$email_data->mail_recipient_ids = $send_mail_to_usr_ids;
		$email_data->email_templates_config = $this->email_templates_config();
		$email_data->join_config = $this->join_config();
		$email_data->join_dependency_config = $this->join_dependency_config();
		$email_data->user_role_tags = $this->user_role_tags();
		$email_data->artp_id =$article_details->art_artp_id;
        $core_role=(isset($post_data['core_role']))?$post_data['core_role']:'';
        $email_data->core_role = $core_role;
        $core_role_name=(isset($post_data['role_name']))?$post_data['role_name']:'';
        $email_data->core_role_name = $core_role_name;
		// $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
		// $email_data->core_role = $core_role;
		// $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
		// $email_data->core_role_name = $core_role_name;
		$email_data->esl_etmp_action = 'discussion_close';
		$email_data->discussion_notify = TRUE;
        $data = array(
            'record' => $record,
            'email_data' => $email_data,
            'user_data' =>$this->current_user,
            'column_prefix' =>'etmp_',
        );
		$this->notify_mail($data);
	    }
                return $this->success('success', 200, $result);
            }

        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    
    public function edit_generic_discussion(Request $request)
    {
        try {
            $role_arry=[];
            $user_ids_ar=[];
            $user_ids_ar_selected=[];
            $post_data = $request->all();
            $is_update = '';
            $enable_userflag=false;
            $this->current_user = $this->get_current_user_details();
            $Generic_discussion=new \App\Models\Generic_discussion();
            $Discussion_type=new \App\Models\Discussion_type();
            $users = '';
		    $html = '';
            if($post_data)
            {

                $art_id = $this->decrypt_data($post_data['article_id']);
                $status_id = $post_data['status_id'];
                $Articles=new \App\Models\Articles();
                $art_art_artp_id = $Articles::get_single_record('art_artp_id,art_submitted_by,art_status,art_code','art_id ='.$art_id); 
                $artp_id =$art_art_artp_id->art_artp_id;
                $disc_type_id = $post_data['discussion_type'];
                $disc_id = $post_data['gen_disc_id'];
                $condition = "gdis_id ={$disc_id}";
                $result = $Generic_discussion::get_single_record('gdis_id as generic_discussion_id,gdis_title as title,gdis_participants_by_role_id as roles,gdis_participants_by_usr_id as users,gdis_enable_all_user,gdis_dsctp_id,gdis_started_by,gdis_hold_task',$condition);		
                if(json_decode($result->users) !=null)
                {
                    $user_participants = json_decode($result->users);
			        $user_participants[] = $result->gdis_started_by;
                    
                }
                if($result->gdis_dsctp_id != NULL)
		        {
			        $user_participant = $this->get_all_artp_users($result->gdis_dsctp_id,$art_id,$artp_id);
                    
		        }
                if(!empty($user_participant))
		        {
                  
                    foreach($user_participant as $users)
                    {
                       $roles_assgn ='';
                       $user_role = '';
                       $selected = '';
                      ($users->usr_middle_name!='' || !empty($users->usr_middle_name)) ? $name=$users->usr_first_name.' '.$users->usr_middle_name.' '.$users->usr_last_name : $name=$users->usr_first_name.' '.$users->usr_last_name;
                      if(isset($users->is_author) && $users->is_author!= NULL)
                       {				
                          
                           if($users->is_author == 'y')
                           {
                               $user_role = ' [Corr.author]';
                           }
                           elseif($users->is_author == 'n')
                           {
                               $user_role = ' [Co-author]';
                           }
                           }  
                           if(!empty($users->stage_type) && $users->stage_type == 'review')
                           {
                               $user_role = '[Reviewer]';
                           }
                           if($users->roles != null)
                           {
                            $roles_assgn  = '(' .$users->roles.')';
                           }
                           if($result->gdis_enable_all_user == 'n' && !empty($user_participants) && in_array($users->usr_id,$user_participants))
                           //if($result->gdis_enable_all_user == 'n' && in_array($users->usr_id,$user_participants))
                           {
                               $selected = 'selected';
                               $user_ids_ar_selected[]=$users->usr_id;
                           }
                           $role_arry[$users->usr_id]=$name.$user_role.$roles_assgn;
                            $user_ids_ar[]=$users->usr_id;	
           
                       //$html .= '<option '.$selected.' value="'.$users->usr_id.'">'.$name.$user_role. $roles_assgn.'</option>';
                    }


                }
                if($result->gdis_enable_all_user== 'y')
                {
                    $enable_userflag=true;
                }
                $role_assigned = json_encode($user_ids_ar_selected);
                $generic_discussion_id  = $result->generic_discussion_id;
                $roles = $result->roles;		
                if($result->users != "null")
                {
                    $users = $result->users;
                }
                if(!empty($result) > 0)
		        {
                    $return_arr = array(
                        'status' => 'success',
                        'generic_discussion_id' =>$generic_discussion_id ,
                        'content' => $result,
                        'users'=>$users,
                        'user_participant'=>$role_arry,
                        'user_ids'=>$user_ids_ar,
                        'enable_all_user' => $enable_userflag
                      
                    );

                }
                return $this->success('success', 200, $return_arr);
                
            }

           

        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function reopen_discussion(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();

            $article_id = isset($post_data['article_id']) ?  $this->decrypt_data($post_data['article_id']) : '';
            $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : ''; 
            $flow_id =isset($post_data['article_flow_id']) ?  $this->decrypt_data($post_data['article_flow_id']) : ''; 
            $gdis_id =isset($post_data['gen_id']) ?  Rv_Decrypt($post_data['gen_id']) : '';
            $array['article_id']=$article_id;
            $array['type']='discussion';
            $array['jnl_code']=$jnl_code;
            $array['current_flow_id']=$flow_id;
            $array['url']=$request->segment(4);
            $array['user_id']=$this->current_user['user_id'];
            $user_access=$this->check_permission_access_user($array);
         
            if($user_access!=true)
            {
                return response()->json(['status' => false,'message'=>'Unauthorized User','success'=>false]);
            }
            $artclearray = array('input'=>Rv_Decrypt($post_data['gen_id']),'type'=>'number', 'enc_data'=>FALSE );
            $artclevalidation= $this->Rv_validator($artclearray);
            if($artclevalidation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                return $this->warning("Failed",201,$arraymsg);     
            }
            $Generic_discussion=new \App\Models\Generic_discussion();
            $disc_close_data = array(
                'gdis_status' => 'o',
                'gdis_time_status' => 'r'
            );
            $condition = "gdis_id ={$gdis_id}";
            $result = $Generic_discussion::update_record($disc_close_data,$condition,$this->current_user);
            if($result > 0)
            {
                return $this->success('success', 200, $result);
            }

        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function get_chat_list(Request $request)
    {
        try {
            $gdis_id = '';
			$gdis_status ='';
			$gdis_started_by ='';
			$gdis_title = '';
			$gen_dis_art_id = '';
			$gen_disc_role_ids = '';
			$gen_disc_user_ids = '';
			$disc_role_html = '';
			$unread_msg = '';
			$disc_type_id  = '';
			$userlist = array();
            $userlist1 = array();
			$unrd_cnt = 0;
           
            $this->current_user = $this->get_current_user_details();
            $this->current_user['user_id'];
            $post_data = $request->all();

            $article_id = isset($post_data['article_id']) ?  Rv_Decrypt($post_data['article_id']) : '';
            $jnl_code =isset($post_data['jnl_code']) ?  $post_data['jnl_code'] : ''; 
            $flow_id =isset($post_data['current_status_id']) ?  $this->decrypt_data($post_data['current_status_id']) : ''; 
            $array['article_id']=$article_id;
            $array['type']='discussion';
            $array['jnl_code']=$jnl_code;
            $array['current_flow_id']=$flow_id;
            $array['url']=$request->segment(4);
            $array['user_id']=$this->current_user['user_id'];
            $user_access=$this->check_permission_access_user($array);
        
            if($user_access!=true)
            {
                return response()->json(['status' => false,'message'=>'Unauthorized User','success'=>false]);
            }
            $artclearray = array('input'=>Rv_Decrypt($post_data['article_id']),'type'=>'number', 'enc_data'=>FALSE );
            $artclevalidation= $this->Rv_validator($artclearray);
            if($artclevalidation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                return $this->warning("Failed",201,$arraymsg);     
            }
            $Generic_discussion=new \App\Models\Generic_discussion();
            

            $client_code = $this->current_client->clnt_client_code;
            $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default.max_disc_commnt_size';
            $commnt_size   = Config::get($client_default);
            $data['cmmnt_limit'] = $commnt_size;
            if($post_data !='')
			{
            $gdis_id = isset($post_data['gdis_id']) ?  Rv_Decrypt($post_data['gdis_id']) : '';    
			//$gdis_status = $post_data['gen_dis_status'];
            $gdis_started_by = isset($post_data['gen_dis_started_by']) ?  Rv_Decrypt($post_data['gen_dis_started_by']) : '';   
			$gdis_title = $post_data['gen_title'];
			$gen_dis_art_id = $post_data['gen_dis_art_id'];
			$gen_disc_user_ids = Rv_Decrypt($post_data['gen_dic_user_id']);
			$disc_type_id = $post_data['disc_type_id'];
            $role_id = $post_data['role_id'];
            $gdis_id_array = array('input'=>Rv_Decrypt($post_data['gdis_id']),'type'=>'number', 'enc_data'=>FALSE );
            $started_by_array = array('input'=>Rv_Decrypt($post_data['gen_dis_started_by']),'type'=>'number', 'enc_data'=>FALSE );
            $gdis_idvalidation= $this->Rv_validator($gdis_id_array);
            $started_by_validation= $this->Rv_validator($started_by_array);
            if($gdis_idvalidation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                return $this->warning("Failed",201,$arraymsg);     
            }
            if($started_by_validation==false)
            {
                $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                return $this->warning("Failed",201,$arraymsg);     
            }
            $userlist = json_decode($gen_disc_user_ids); 

            if(!empty($userlist))
            {
                for($i=0;$i<count($userlist);$i++)
                {
                    $gen_dic_user_id_array = array('input'=>$userlist[$i],'type'=>'number','enc_data'=>FALSE );
                    $idvalidation= $this->Rv_validator($gen_dic_user_id_array);  
                    if($idvalidation==false)
                        {
                            $arraymsg['chatmesage'] = customTrans('discussion.invalid_input');
                            return $this->warning("Failed",201,$arraymsg);     
                        }
                }
            }
            $condcheckuserexit = ' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$this->current_user['user_id'].') is NOT NULL OR gdis_started_by='.$this->current_user['user_id'].')';	
            $sql ='SELECT `gdis_art_id` FROM `rvw_generic_discussion`  WHERE gdis_art_id='.$article_id. $condcheckuserexit.' AND gdis_dsctp_id is NOT NULL AND gdis_id='.$gdis_id.' ORDER BY gdis_id ASC' ;
            $discussion_checkuser = $Generic_discussion::get_records_by_raw_query($sql);
           if(!empty($discussion_checkuser))

                {
                   
                     
           if($this->current_user['user_id'] != $gdis_started_by)
            {  
                $userlist[] = "$gdis_started_by";
                $gen_disc_user_ids=json_encode($userlist); 
                // if(!empty($gen_disc_user_ids))
                // {
                //     $userlist1 = json_decode($gen_disc_user_ids);
                // }
              
                // $userlist1[] = $gdis_started_by;
                // $gen_disc_user_ids = implode(',',$userlist1);
            }

                if($post_data['unread_msg'] != '' )
                {
                        $unread_msg = explode(',',($post_data['unread_msg']));
                        $unrd_cnt = count($unread_msg);
                }

            
            $Article_types=new \App\Models\Article_types();
            $Users=new \App\Models\User();
            $Articles=new \App\Models\Articles();
            $Article_type_advance_options=new \App\Models\Article_type_advance_options();
            $Generic_discussion=new \App\Models\Generic_discussion();
            $Generic_discussion_comments=new \App\Models\Generic_discussion_comments();
            $Generic_discussion_read=new \App\Models\Generic_discussion_read();
            $Roles=new \App\Models\Roles();
            $art_art_artp_id = $Articles::get_single_record('art_artp_id,art_submitted_by,art_status,art_code','art_id ='.$article_id); 
            $art_type_id =$art_art_artp_id->art_artp_id;
            $select ="artp_id,artp_jnl_id,jp_generic_discussion as atotp_generic_discussion,artp_article_type as art_type_name";
            $articletypestable = (new \App\Models\Article_types())->getTable();
            $Journalpermissiontable = (new \App\Models\Journal_permission())->getTable();
            $jnl_tables = array(
             'main_table' => $articletypestable,
             'join_table' => array(
                 $Journalpermissiontable => array($Journalpermissiontable.'.jp_jpm_id', $articletypestable. '.artp_jpm_id','left')
         ));
         $condition = "gdis_id ={$gdis_id}";
         $gdsstatus = $Generic_discussion::get_single_record('gdis_status', $condition);
         $gdis_status=$gdsstatus->gdis_status;
         $jnl_criteria = "artp_id={$art_type_id}";
         $article_type_advance = $Article_types::get_results_using_joins($jnl_tables,$select, $jnl_criteria,'single');
         $data['show_close_discussion'] = FALSE;
         $date_format = $this->get_platform_date_format($post_data['jnl_id']);
         $date_format= date_format_map($date_format);

         $dsc_cmmnt_sql ='SELECT
		 `gen_dsc`.`gdsc_comment`,
		 `usr`.`usr_id`,
		 `disc`.`gdis_proxy_id`,
		 DATE_FORMAT(gen_dsc.gdsc_posted_date, "' . $date_format . ' %h:%i %p") as gdsc_posted_date,
		 `gen_dsc`.`gdsc_posted_by`,
		 `gen_dsc`.`gdsc_gdis_id`,
		 `gen_dsc`.`gdsc_id`,
		 `usr`.`usr_image`,
		 CONCAT(
		   usr.usr_first_name,
		   IF(
			 usr.usr_middle_name IS NULL OR usr.usr_middle_name = "",
			 " ",
			 CONCAT(" ", `usr`.`usr_middle_name`, " ")
		   ),
		   usr.usr_last_name
		 ) AS full_name,
		 `usr`.`usr_first_name`,
		 `usr`.`usr_middle_name`,
		 `usr`.`usr_last_name`,
		 CONCAT(
		   pxr.usr_first_name,
		   IF(
			 pxr.usr_middle_name IS NULL OR pxr.usr_middle_name = "",
			 " ",
			 CONCAT(" ", `pxr`.`usr_middle_name`, " ")
		   ),
		   pxr.usr_last_name
		 ) AS proxy_user
	   FROM
		 `rvw_generic_discussion_cmts` AS `gen_dsc`
	   INNER JOIN
		 `rvw_generic_discussion` AS `disc`
	   ON
		 `disc`.`gdis_id` = `gen_dsc`.`gdsc_gdis_id`
	   JOIN
		 `rvw_users` AS `usr`
	   ON
		 `gen_dsc`.`gdsc_posted_by` = `usr`.`usr_id`
		LEFT JOIN
		 `rvw_users` AS `pxr`
	   ON
		 `gen_dsc`.`gdsc_proxy_id` = `pxr`.`usr_id`
	   WHERE
		 `gdsc_gdis_id` = '.$gdis_id;

         $chat_list = $Generic_discussion_comments::get_records_by_raw_query($dsc_cmmnt_sql); 
		 $read_status_data = array();
		 $atotp_generic_discussion = json_decode($article_type_advance->atotp_generic_discussion);
        
         if(!empty($unread_msg))
         { 
              foreach($unread_msg as $ids)
             {
                 $read_status = array(
                  'gdrs_gdsc_id' =>$ids,
                  'gdrs_posted_by' => $this->current_user['user_id'],
                  'gdrs_proxy_id' => $this->current_user['proxy_user_id'],
                  'gdrs_posted_date' => date('Y-m-d H:i:s'),
                  'gdrs_operation' => 'i'
                 );
                 array_push($read_status_data,$read_status);
             } 
             $Generic_discussion_read::insert_batch($read_status_data);
         }
         $data['all_discussion'] = $chat_list;
		 $data['gdis_id'] = $gdis_id;
		 $data['user_data'] = $this->current_user['user_id'];
		 $data['gen_disc_title'] = $gdis_title;
		 $data['gen_status'] = $gdis_status;
		 $data['gen_disc_role_ids'] = $gen_disc_role_ids;
		 $data['gen_disc_user_ids'] =  $gen_disc_user_ids;
		 $data['article_id'] = $gen_dis_art_id;
		 $data['disc_type_id'] = $disc_type_id;
		 $data['date_format'] = $date_format;
         $data['unread_cnt'] = $unrd_cnt;
         if($data['gen_disc_role_ids'] != '' )
		{
            
		  // $role_criteria = 'role_id IN ('.$data['gen_disc_role_ids'].')';
           $role_criteria = "role_id IN ({$data['gen_disc_role_ids']})";
		   $all_roles = $Roles::get_all_records('role_id,role_name',$role_criteria);
		   if(!empty($all_roles))
		   {  
			$disc_role_html="<table>";
			foreach($all_roles as $role)
			{
				$disc_role_html .="<tr><td>".$role->role_name."</td></tr>" ;
			}
			$disc_role_html.="</table>";				
		    }
			$data['disc_role_html'] = $disc_role_html;	
		}
        
		 if($data['gen_disc_user_ids']!= '' )
		 {
           
			$userlist[] = $gdis_started_by;
            $impusers=implode(',',$userlist);
            $user_criteria = "usr_id IN ({$impusers})";
			$user_participants = $Users::get_all_records('CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as full_name,usr_first_name,usr_middle_name,usr_last_name',$user_criteria);
           
            $user_for_title = array();
	    	if(!empty($user_participants))
			{   
			$disc_user_html ="<table>";
			foreach($user_participants as $users)
			{
				($users->usr_middle_name!='' || !empty($users->usr_middle_name)) ? $name=$users->usr_first_name.' '.$users->usr_middle_name.' '.$users->usr_last_name : $name=$users->usr_first_name.' '.$users->usr_last_name;
				array_push($user_for_title,$name);
                $disc_user_html .="<tr><td>".$name."</td></tr>" ;
			}
			$disc_user_html.="</table>";
							
			}
			$data['disc_user_html'] = $disc_user_html;
            $data['user_for_title'] = $user_for_title;
		}
         if($gdis_status == 'o' && in_array($role_id,$atotp_generic_discussion))
            {
                $data['show_close_discussion'] = TRUE;
            }

        //return $data;
        return $this->success('success', 200, $data);
            }
            return $this->warning('failed', 200);
        }
        return $this->warning('failed', 200);
        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
        
    }
  public function get_article_assgned_user($userids,$article_id,$role_id)
    {
       
        $Article_flow = new \App\Models\Article_flow;
        $Article_flow_table = (new \App\Models\Article_flow)->getTable();
        $Generic_flow_table = (new \App\Models\Generic_flows())->getTable();
       $sql = 'SELECT GROUP_CONCAT(DISTINCT aflw_usr_id SEPARATOR ",") as userids FROM  '.$Article_flow_table.' INNER JOIN '.$Generic_flow_table.' ON jwf_id = aflw_jwf_id WHERE aflw_usr_id IN ('.$userids .') and  aflw_art_id = ' . $article_id.' and aflw_status IN ("a","c") and jwf_role_id = '.$role_id ;
       $user_ids = $Article_flow::get_records_by_raw_query($sql);
       return $user_ids;
    }
}



