<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use config ;
use \stdClass;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\UploadedFile;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\GeneralEmailTrait;
use  App\Http\Traits\UserDataTrait;
use App\Http\Traits\StagemovementTrait;
use App\Http\Traits\General_ConfigTraits;
use App\Models\Adhoc_notification_emails;
use App\Models\Articles;
use App\Models\Email_attachments;
use App\Models\Email_send_log;
use App\Models\Resent_forward_emails_attachments;
use Carbon\Carbon;
use Symfony\Component\HttpFoundation\File\File;
use DB;
use Exception;
use App\Http\Traits\ReviewerListTrait;
use App\Http\Services\ConveyService;
use App\Models\AuthorHistory;
use App\Models\Email_templates;
use App\Models\Generic_flows;
use App\Models\Roles;

class Manage_Email_Api extends Controller
{
    use WorkflowTrait;
    use GeneralEmailTrait;
    use UserDataTrait;
    use StagemovementTrait;
    use General_ConfigTraits;
	use ReviewerListTrait;

	public $current_user;
	/**
	 * Total size of attachments in a mail should be 25 MB (25000 KB).     *
	*/
    public const tot_file_upd_sz = 25000;

    public function index(Request $request)
    {
        try {
			$this->current_user=$this->get_current_user_details();
            $form_data = $request->all();
			$post_data=array(
				'subject'=>	$form_data['subject'],
				'content'=>	$form_data['content'],
				'filename'=> $form_data['filename']
			);
			$art_id = isset($form_data['art_id']) ? decrypt_link($form_data['art_id']): '';
			$aflw_id = isset($form_data['aflw_id']) ? decrypt_link($form_data['aflw_id']) : '';
            $stage_etmp_id = (isset($form_data['stage_etmp_id'])&&$form_data['stage_etmp_id'] != "") ? decrypt_link($form_data['stage_etmp_id']) : "";
			$image =  $form_data['filename'];
			$name = $image->getClientOriginalName();
            $uploaded_file_details=$this->upload_file_handler('email_attachments/'.$art_id, $image, $name);
			$this->save_invite_attachments($post_data,$art_id,$aflw_id,NULL,$stage_etmp_id);
			return  $this->success('Success', 200, $uploaded_file_details);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

	public function save_invite_attachments($post_data,$art_id,$aflw_id,$inventory_files=NULL,$stage_etmp_id= NULL,$etmp_data = NULL)
	{
		try{

		$formdata = array();
		$noti_condition = "ane_art_id={$art_id} AND ane_aflw_id={$aflw_id} and ane_status = 0 ";
		$this->current_user=$this->get_current_user_details();
		$Stage_email_templates= new \App\Models\Stage_email_templates();
		$Article_notification_emails = new \App\Models\Article_notification_emails;
		$Email_attachments = new \App\Models\Email_attachments;
		$Attachment_files = new \App\Models\Attachment_files;
		$tmp_type = (isset($post_data['type']) && !empty($post_data['type'])) ? decrypt_link($post_data['type']) : '';
		if($tmp_type != ''){
			$noti_condition .=" AND ane_for ='{$tmp_type}'";
		}

		if(isset($stage_etmp_id) && !empty($stage_etmp_id))
		{

			$formdata['ane_stage_etmp_id'] = $stage_etmp_id;
			$noti_condition .=" AND ane_stage_etmp_id = {$stage_etmp_id}";
			$stage_email = $Stage_email_templates::get_single_record('stage_etmp_to,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_cust_to',"stage_etmp_id ={$stage_etmp_id}");
			$stage_type 	= $stage_email->stage_etmp_stage_type;
			$action 		= $stage_email->stage_etmp_action;
			$tmp_name 		= $stage_email->stage_etmp_name;
			$tmp_cust_to 	= $stage_email->stage_etmp_cust_to;
			$tmp_to 		= $stage_email->stage_etmp_to;
		}
		elseif(isset($etmp_data) && !empty($etmp_data))
		{
			$formdata['ane_event_etmp_id'] = $etmp_data->etmp_id;
			$noti_condition .=" AND ane_event_etmp_id = {$etmp_data->etmp_id}";
			$stage_type 	= $etmp_data->etmp_name;
			$action 		= '';
			$tmp_name 		= $etmp_data->etmp_templete_name;
			$tmp_cust_to 	= $etmp_data->etmp_cust_to;
			$tmp_to 		= $etmp_data->etmp_notification;
		}
		$article_notification = $Article_notification_emails::get_single_record('ane_id',$noti_condition);
		$formdata['ane_cc'] = '';
		$formdata['ane_bcc'] = '';
		if (isset($post_data['stage_template_to_cc']) && !empty($post_data['stage_template_to_cc']) && $post_data['stage_template_to_cc'] != 'undefined' && $post_data['stage_template_to_cc'] != '[]') {
			$cc_data = is_string($post_data['stage_template_to_cc']) ? json_decode($post_data['stage_template_to_cc'], true) : $post_data['stage_template_to_cc'];
			if (is_array($cc_data)) {
				$formdata['ane_cc'] = json_encode($cc_data); 
			} else {
				$formdata['ane_cc'] = json_encode([$cc_data]); 
			}
		}
		if (isset($post_data['stage_template_to_bcc']) && !empty($post_data['stage_template_to_bcc']) && $post_data['stage_template_to_bcc'] != 'undefined' && $post_data['stage_template_to_bcc'] != '[]') {
			$bcc_data = is_string($post_data['stage_template_to_bcc']) ? json_decode($post_data['stage_template_to_bcc'], true) : $post_data['stage_template_to_bcc'];
			if (is_array($bcc_data)) {
				$formdata['ane_bcc'] = json_encode($bcc_data);
			} else {
				$formdata['ane_bcc'] = json_encode($bcc_data);
			}
		}
		$cust_bcc =isset($post_data['stage_cust_bcc'])  ? $post_data['stage_cust_bcc'] : '';
        $cust_cc =isset($post_data['stage_cust_cc'])  ? $post_data['stage_cust_cc'] : '';
		if(empty($article_notification))
		{
			$formdata['ane_art_id']        = $art_id;
			$formdata['ane_stage_type']    = $stage_type;
			$formdata['ane_aflw_id']       = $aflw_id;
			$formdata['ane_action']        = $action;
			$formdata['ane_to']            = $tmp_to;
			$formdata['ane_subject']       = $post_data['subject'];
			$formdata['ane_content']       = $post_data['content'];
			$formdata['ane_template_name'] = $tmp_name;
			$formdata['ane_cust_to']       = $tmp_cust_to;
			$formdata['ane_cust_cc']	   = $cust_cc;
			$formdata['ane_cust_bcc']      = $cust_bcc;
			$formdata['ane_for']           = $tmp_type;

			$ane_id = $Article_notification_emails::insert_record($formdata, $this->current_user);
		}
		else
		{
			$ane_id = $article_notification->ane_id;
            $formdata['ane_to']            = $tmp_to;
            $formdata['ane_subject']       = $post_data['subject'];
            $formdata['ane_content']       = $post_data['content'];
            $formdata['ane_cust_to']       = $tmp_cust_to;
			$formdata['ane_cust_cc']	   =$cust_cc;
			$formdata['ane_cust_bcc']      = $cust_bcc;
			$formdata['ane_for']           = $tmp_type;
            $Article_notification_emails::update_record($formdata,"ane_id = {$ane_id}", $this->current_user);
		}



		if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y') {
			$Articles = new \App\Models\Articles;
			$article_details = $Articles::get_single_record('art_article_upload_path',"art_id={$art_id}");
			if (isset($post_data['attach_org']) && !empty($post_data['attach_org'])) {
				$Generic_form_files = new \App\Models\Generic_form_files;
				$attach_org=explode(',',$post_data['attach_org']);
				if(count($attach_org)>0) {
				foreach ($attach_org as $att) {
					$genric_form_file = $Generic_form_files::get_single_record('agf_id,agf_name,agf_file_size',"agf_id={$att}");
					if (!empty($genric_form_file)) {
						$insert_data = array(
							'emat_file_name' => $genric_form_file->agf_name,
							'emat_ane_id' => $ane_id,
							'emat_agf_id' => $genric_form_file->agf_id,
							'emat_art_id' => $art_id,
							'emat_document_size' => $genric_form_file->agf_file_size
						);
						if($tmp_type != ''){ // data validation added
							$insert_data['emat_for'] = $tmp_type;
						}						
						$email_attach_exists = $Email_attachments::get_single_record('emat_file_name',"emat_file_name='{$genric_form_file->agf_name}' and emat_ane_id={$ane_id} and emat_agf_id={$genric_form_file->agf_id} ");

						if (empty($email_attach_exists)) {

							$source = public_path() . '/storage/uploads/' . $article_details->art_article_upload_path . '/' . $genric_form_file->agf_name;
							$destination = public_path() . '/storage/uploads/email_attachments/' . $art_id;

							if (!file_exists($destination)){
								mkdir($destination, 0765, TRUE);
							}
							$dest_file = $destination . '/' . $genric_form_file->agf_name;
							//#357 if $source does not exists , PHP error showing for copy function
							if (file_exists($source)) {
								copy($source, $dest_file);
							}
							$Email_attachments::insert_record($insert_data,$this->current_user);
						}
					}
				}
			}
			}
			//#1954 Author designated file attach publish complete stage code start
			if (isset($post_data['attach_mod_production']) && !empty($post_data['attach_mod_production'])) {
				$attach_mod_production=explode(',',$post_data['attach_mod_production']);
				if(count($attach_mod_production)>0) {
				foreach ($attach_mod_production as $att_production) {
					$Production_attachment_files = new \App\Models\Production_attachment_files();
					$production_uploaded_files = $Production_attachment_files::get_single_record('paf_id,paf_file_name,paf_aflw_id,paf_document_size',"paf_id={$att_production}");
					if (!empty($production_uploaded_files)) {
						$destination = 'uploads/email_attachments/' . $art_id;
							if (!file_exists($destination)){
								mkdir($destination, 0765, TRUE);
							}

							$dest_file = $destination . '/' . $production_uploaded_files->paf_file_name;
							$original_name_of_file=$production_uploaded_files->paf_file_name;
							if(file_exists($dest_file)) {
								$name_of_uploaded_file=$this->updatenewName($destination, $original_name_of_file);
								$destination_file_path =$destination.'/'. $name_of_uploaded_file;
							} else {
								$name_of_uploaded_file =$production_uploaded_files->paf_file_name;
								$destination_file_path=$dest_file;
							}

						$insert_data = array(
							'emat_file_name' => $name_of_uploaded_file,
							'emat_ane_id' => $ane_id,
							'emat_agf_id' => $production_uploaded_files->paf_id,
							'emat_art_id' => $art_id,
							'emat_document_size' => $production_uploaded_files->paf_document_size
						);
						$email_attach_exists = $Email_attachments::get_single_record('emat_file_name',"emat_file_name='{$name_of_uploaded_file}' and emat_ane_id={$ane_id} and emat_agf_id={$production_uploaded_files->paf_id}");

						if (empty($email_attach_exists)) {
							$source = 'uploads/' . $article_details->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/'. $production_uploaded_files->paf_aflw_id. DIRECTORY_SEPARATOR.$production_uploaded_files->paf_file_name;

							//#357 if $source does not exists , PHP error showing for copy function
							if (file_exists($source)) {

								copy($source, $destination_file_path);
							}
							$Email_attachments::insert_record($insert_data, $this->current_user);
						}
					}
				}
			}
		 }

		}



		$basic_path		=	'uploads/email_attachments/' . $art_id;
		$path			=	APP_DOC_PATH . $basic_path;
		if (!file_exists($path))
		{
			mkdir($path, 0765, TRUE);
		}
		$tot_attachment_sz 	=	0;

		if($inventory_files == NULL)
		{
			$image =  $post_data['filename'];
			$name = $image->getClientOriginalName();
            $uploaded_file_details=$this->upload_file_handler('email_attachments/'.$art_id, $image, $name);
					if ($uploaded_file_details && $uploaded_file_details['name'] &&
			isset($uploaded_file_details['error'])&&$uploaded_file_details['error']== FALSE)
		{
			$upld_flsz	=	$this->file_size_convert_to_kb($uploaded_file_details['size']);
			$attch_file_html = $this->get_invite_email_attachments($art_id,$ane_id);
			if(count($attch_file_html) > 0) {
				foreach($attch_file_html as $key) {
					$tot_attachment_sz	=	$tot_attachment_sz + $key['document_size'];
				}
				$tot_attachment_sz	=	$upld_flsz + $tot_attachment_sz;
			} else {
				$tot_attachment_sz	=	$upld_flsz;
			}

			if($tot_attachment_sz < $this::tot_file_upd_sz) {
			$insert_data = array(
				'emat_file_name' => $uploaded_file_details['name'],
				'emat_ane_id' => $ane_id,
				'emat_art_id' => $art_id,
				'emat_document_size' => $upld_flsz
			);
			if($tmp_type != ''){ // data validation added
				$insert_data['emat_for'] = $tmp_type;
			}
			$Email_attachments::insert_record($insert_data, $this->current_user);
			}
			$uploaded_file_details['tot_attachment_sz'] = $tot_attachment_sz;
			$uploaded_file_details['attch_file_html'] = $attch_file_html;
			$uploaded_file_details['ane_id']      = encrypt_link($ane_id);
		}
		}
		else
		{
			$basic_path		= $path =	'uploads/email_attachments/' . $art_id;
			$path			=	APP_DOC_PATH . $basic_path;
			if (!file_exists($path))
			{
				mkdir($path, 0765, TRUE);
			}

			$error_artcle_files = array();
			if(!empty($inventory_files) && count($inventory_files) > 0)
			{
				foreach($inventory_files as $attach_file_id)
				{
					$file_id=decrypt_link($attach_file_id);
					$attachment_file_name = $Attachment_files::get_single_record('atmnt_file_name,atmnt_orginal_upload_path',"atmnt_id={$file_id}");
					$attachment_path 	  = $attachment_file_name->atmnt_orginal_upload_path;
					$attachment_file_name = $attachment_file_name->atmnt_file_name;
					$source_path = $this->get_upload_path($attachment_path.'/'.$attachment_file_name,TRUE);
					$destination_path = $this->get_upload_path($basic_path.'/'.$attachment_file_name,TRUE);

							$i = 1;
							$got_new_file = FALSE;
							while($got_new_file == FALSE)
							{
								$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
								$file_name = basename($attachment_file_name,'.'.$ext);
								if(!file_exists($this->get_upload_path($basic_path.'/'.$file_name.' ('.$i.').'.$ext,TRUE)))
								{
									$got_new_file = TRUE;
									$attachment_file_name = $file_name.' ('.$i.').'.$ext;
								}
								$i++;
							}
							$destination_path = $this->get_upload_path($basic_path.'/'.$attachment_file_name,TRUE);

						if(copy($source_path, $destination_path))
						{
							$insert_data = array(
								'emat_file_name' => $attachment_file_name,
								'emat_ane_id' => $ane_id,
								'emat_art_id' => $art_id
							);
							$Email_attachments::insert_record($insert_data,$this->current_user);
						}
						else
						{
							array_push($error_artcle_files,$attachment_file_name);
						}

				}
			}

		}
		$return_arr = array('status' => 'success');
		$return_arr['upload_file_size_config']=$this->get_uploaded_file_size_config();
		$attch_file_html	=	$this->get_invite_email_attachments($art_id,$ane_id);
		$return_arr['total_size_exceeded'] = false;
		if($tot_attachment_sz > $this::tot_file_upd_sz) {
			$return_arr['total_size_exceeded'] = true;
		}
			$return_arr['attch_file_html'] = $attch_file_html;
			$return_arr['tot_attachment_sz'] = $tot_attachment_sz;
			$return_arr['ane_id'] = encrypt_link($ane_id);
		return $return_arr;
	} catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}
	}
    public function enable_email_preview(Request $request)
    {

        try {
            $post_data = $request->all();

            if(is_array($post_data['aflw_id'])){
                return $this->email_preview_bulk_article($post_data);
            }
			$validator = Validator::make($request->all(), [
				'aflw_id' => 'required',
				'template' => 'required',
				'jnl_code' => 'required',
				'jnl_id' => 'required',
				'event_based' => 'required',
			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			$flowarray = array('input'=>$post_data['aflw_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
			$aflwidarray = array('input'=>$post_data['aflw_id'],'type'=>'number', 'enc_data'=>TRUE );
			$eventbasedarray = array('input'=>$post_data['event_based'],'type'=>'bflag' );
			$jnlcodearray = array('input'=>$post_data['jnl_code']);

			$flowidvalidation= $this->Rv_validator($flowarray);
			$jnlidvalidation= $this->Rv_validator($jnlidarray);
			$aflwidvalidation= $this->Rv_validator($aflwidarray);
			$eventbasedvalidation= $this->Rv_validator($eventbasedarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
			if($flowidvalidation != TRUE || $jnlidvalidation != TRUE || $aflwidvalidation != TRUE || $eventbasedvalidation != TRUE || $jnlcodevalidation != TRUE ){
				return $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}

			$tmpl_type =isset($post_data['type']) ? decrypt_link($post_data['type']) : '';
			$usercount ='';
            $article= new \App\Models\Articles();
            $article_flow = (new \App\Models\Article_flow);
            $article_autoinvitation_emails= (new \App\Models\Article_autoinvitation_emails);
			$Email_templates = new \App\Models\Email_templates;
            $stage_email_templates= new \App\Models\Stage_email_templates();
            $User_to_journals= new \App\Models\User_to_journals();
            $Users=new \App\Models\User();
            $Roles=new \App\Models\Roles();
			$Generic_flows=new \App\Models\Generic_flows();
			$Article_notification_emails = new \App\Models\Article_notification_emails;
			$Journal_setting = new \App\Models\Journal_settings();
            $this->current_user=$this->get_current_user_details();
            $current_stage_id = decrypt_link($post_data['aflw_id']);
			$user_id = isset($post_data['user_id']) ?$post_data['user_id']: '';
			$tmpl_id = isset($post_data['tmpl_id']) ? decrypt_link($post_data['tmpl_id']) : '';
			$jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
			$jnl_code = isset($post_data['jnl_code']) ? $post_data['jnl_code']: '';
			$template_view = isset($post_data['view']) ? $post_data['view']: '';
			$cur_tmpl_id = isset($post_data['cur_tmpl_id']) ? decrypt_link($post_data['cur_tmpl_id']) : '';
			/*core_role task*/
			$core_role_id=(isset($post_data['role_id']))?$post_data['role_id']:'';
			/*end core_role task*/
			$template_action = $post_data['template'];
			$event_based = (isset($post_data['event_based'])) ? $post_data['event_based'] : 'n';
			$usr_ids = $user_id;
			/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
			$active_parent_stage = isset($post_data['active_parent_stage']) ? $post_data['active_parent_stage']: '';
				$prereview_flow_id = isset($post_data['prereview_flow_id']) ? decrypt_link($post_data['prereview_flow_id']) : '';
				$destination_stage_id = isset($post_data['destination_stage_id']) ? decrypt_link($post_data['destination_stage_id']) : '';
			$skipcondition = isset($post_data['skipcondition']) ? $post_data['skipcondition'] :false;
			/* To keep the cc , bcc and cotent loading issue after adding attachments form inventory files issue fix -> Start*/
			$saved_template_data = '';
			$save_temp_data_obj = array(
				'saved_template_subject' => '',
				'saved_template_content' => '',
				'saved_template_cc' => '',
				'saved_template_bcc' => '',
				'saved_template_cust_cc' => '',
				'saved_template_cust_bcc' => '',
			);		
			/* To keep the cc , bcc and cotent loading issue after adding attachments form inventory files issue fix -> End*/
			if($active_parent_stage == 'prereview' && ($prereview_flow_id != '' || $destination_stage_id != ''))
			{
				if($prereview_flow_id != '')
				{
					$where = "aflw_id={$prereview_flow_id}";
				}
				elseif($destination_stage_id != '')
				{
					$where = "aflw_jwf_id={$destination_stage_id}";
				}
			}
			else
			{
				$where = "aflw_id={$current_stage_id}";	
			}
            $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,aflw_deeplink_token,aflw_usr_id,jwf_child_stages,art_proposal_method';
			$article_details = $article::get_article_details($select, $where);
			$article_details = $article_details[0];
			$article_id = $article_details->art_id;
			$journal_date_format = $Journal_setting::get_single_record('jset_date_format',"jset_jnl_id={$jnl_id}");
			$client_date_format = '';
			if(!empty($journal_date_format))
			{
				$client_date_format = $journal_date_format->jset_date_format;
			}
			
			/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
			$all_templates = array();
			$alltemplates = array();
			$article_details->TASK_DUE_DATE = $this->get_due_date_for_article($article_id, $article_details->jwf_tat_accept,$client_date_format);
			// TASK #9747 Issue in Remaining Days Calculation.
			$remaining_days = Carbon::now()->diffInDays(Carbon::createFromFormat($client_date_format,$article_details->TASK_DUE_DATE), false);
            $article_details->TASK_REMAINING_DAYS = $remaining_days > 0 ?  $remaining_days : 0;
			if ($event_based == 'n')
			{
                if ($template_action == 'unassign' || $template_action == 'unassign-reviewer' || $template_action == 'uninvite')
				{
					$tmp_act = 'unassign_user';
					if ($template_action == 'uninvite'){
						if ($user_id !='' || $user_id != NULL) {
							$check = $article_flow::get_single_record("aflw_status","aflw_parent_flow_id = ? AND aflw_usr_id = ?",orderby:'aflw_id desc',binding_arr:[$current_stage_id,decrypt_link($user_id)]);
							if (!empty($check) && in_array($check->aflw_status,['a','d'])) {
								$msg = $check->aflw_status == 'a' ? 'accepted' : 'declined';
								return $this->warning('warning',200,'The reviewer has '.$msg.' the invitation');
							}
						}
						$tmp_act = 'uninvite_user';
					}
                    $condition="stage_etmp_stage_type='{$article_details->jwf_stage_type}' AND setr_jwf_id={$article_details->jwf_id} AND stage_etmp_action='{$tmp_act}'";
					if ($user_id == '' || $user_id == NULL)
					{
						$accepted_child = $article_flow::get_all_records('aflw_usr_id', 'aflw_parent_flow_id =' . $current_stage_id . ' AND aflw_status IN ("a","i")');

						if (!empty($accepted_child))
						{
							$user_id = $this->get_column_array($accepted_child, 'aflw_usr_id');
							array_walk($user_id, function(&$value, $key)
							{
								$value = encrypt_link($value);
							});
							$user_id = join(',', $user_id);
						}
					}
				}
				else
				{
                    $condition="stage_etmp_stage_type='{$article_details->jwf_stage_type}' AND setr_jwf_id={$article_details->jwf_id} AND stage_etmp_action='assigned'";
				}

				if ($template_action == 'review_resubmit' )
				{
					$condition="stage_etmp_stage_type='{$article_details->jwf_stage_type}' AND setr_jwf_id={$article_details->jwf_id} AND stage_etmp_action='review_resubmit'";

				}
				$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
				$review_flow = Config::get($workflow_config);

				$reviewflow = $review_flow[$article_details->jwf_stage_type];
				$invitation_id = isset($post_data['invite_email_id']) ? decrypt_link($post_data['invite_email_id']) : '';
				$alter_priority_id=isset($post_data['alter_priority_id']) ? decrypt_link($post_data['alter_priority_id']) : '';
				$priority_type=isset($post_data['priority_type']) ?$post_data['priority_type'] : '';
				$enable_priority_userinvitation_email = FALSE;
				if (isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y' ) || (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))
				{
					$enable_priority_userinvitation_email = TRUE;
				}


				if (($invitation_id!=''||$alter_priority_id!="")&& $template_action == 'invitation' && $enable_priority_userinvitation_email == TRUE)
				{
				if(($invitation_id != "" ||$alter_priority_id!="" ))
				{
					$alter_user_id=decrypt_link($user_id);
					if($invitation_id != "")
					{
					$condition_autoinvited ="aae_id={$invitation_id}";
					}
					else if($priority_type == 'user')
					{
						$condition_autoinvited ="aae_auap_id={$alter_priority_id} AND aae_usr_id={$alter_user_id}";
					}
					else
					{
					$condition_autoinvited ="aae_afap_id={$alter_priority_id} AND aae_usr_id={$alter_user_id}";
					}
					$template = $article_autoinvitation_emails::get_all_records('aae_to as stage_etmp_to,aae_cc as stage_etmp_cc,aae_bcc as stage_etmp_bcc,aae_subject as stage_etmp_subject,aae_content as stage_etmp_content,aae_cust_to as stage_etmp_cust_to,aae_cust_cc as stage_etmp_cust_cc,aae_cust_bcc as stage_etmp_cust_bcc,aae_stage_etmp_id as stage_etmp_id,aae_template_name as stage_etmp_name', $condition_autoinvited);
				if (count($template)==0)
					{
						$selected_condition='';
						if ($tmpl_id != "")
						{
							$selected_condition="stage_etmp_id= {$tmpl_id}";
						}
						$template = $stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', (($selected_condition != '') ? $selected_condition : $condition));
					}
				}
					$alltemplates =  $stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
				}
				else
				{
					$alltemplates =  $stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
				if ($tmpl_id != "")
				{
					$condition="stage_etmp_id= {$tmpl_id}";
				}
				$template =  $stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
			}
			if ($template->isNotempty())
			{
					$all_templates = $template;
					
					/* To keep the cc , bcc and cotent loading issue after adding attachments form inventory files issue fix -> Start*/
					$template_flow_id = (isset($prereview_flow_id) && !empty($prereview_flow_id)) ? $prereview_flow_id : $current_stage_id;
					if (isset($cur_tmpl_id) && !empty($cur_tmpl_id)) {
						$saved_template_condition = "ane_stage_etmp_id = ? AND ane_aflw_id = ?";
						$bind_cond = [$cur_tmpl_id,$template_flow_id];
						$saved_template_data = $Article_notification_emails::get_single_record_with_bind_cond('*',null,$saved_template_condition,$bind_cond);
						if (isset($saved_template_data) &&  $saved_template_data != '') {
							$save_temp_data_obj['saved_template_subject'] = $saved_template_data->ane_subject;
							$save_temp_data_obj['saved_template_content']= $saved_template_data->ane_content;
							$save_temp_data_obj['saved_template_cc'] = $saved_template_data->ane_cc;
							$save_temp_data_obj['saved_template_bcc'] = $saved_template_data->ane_bcc;
							$save_temp_data_obj['saved_template_cust_cc'] = $saved_template_data->ane_cust_cc;
							$save_temp_data_obj['saved_template_cust_bcc'] = $saved_template_data->ane_cust_bcc;
						}
					}
					/* To keep the cc , bcc and cotent loading issue after adding attachments form inventory files issue fix -> End*/

					$index = ($cur_tmpl_id != '') ? $template->where('stage_etmp_id', $cur_tmpl_id)->keys()->first() : 0;
					$template = $template[$index];

					/* To keep the cc , bcc and cotent loading issue after adding attachments form inventory files issue fix => data upadating withrespect to the saved template data -> Start*/
					$this->update_template_data($template,$save_temp_data_obj);
				}
				else{
					$template = array();
				}
            }
			else if($event_based == 'y')
			{

				$template = $Email_templates::get_single_record('*',"etmp_name='{$template_action}' AND etmp_notification='User'" );

				if ($template != null)
				{
					$template->stage_etmp_to = $template->etmp_notification;
					// Task #1753 Typeerror occuered when user click on re-open mail.
					$template->stage_etmp_subject = $template->etmp_subject;
					$template->stage_etmp_content = $template->etmp_email_template;
					$template->stage_etmp_cc = $template->etmp_cc;
					$template->stage_etmp_bcc = $template->etmp_bcc;
					$template->stage_etmp_cust_cc = $template->etmp_cust_cc;
					$template->stage_etmp_cust_bcc = $template->etmp_cust_bcc;
					/* To keep the cc , bcc and cotent loading issue after adding attachments form inventory files issue fix => data upadating withrespect to the saved template data */
					$this->update_template_data($template, $save_temp_data_obj);
				}
			}
			else
			{
				return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));

			}
			$hold = isset($post_data['hold']) ? $post_data['hold'] : '';
			if (!empty($user_id))
			{
				$user_ids = explode(',', $user_id);

				$reviewer = new stdClass();
				$preview_recipient = FALSE;
				$replace_all_tags = TRUE;
				$user_info = '';
				if (count($user_ids) == 1 && !empty($template))
				{
					$user_id = decrypt_link($user_ids[0]);
					if($article_details->jwf_stage_type == "review" &&  $skipcondition == false && $template_action == 'invite')
					{
						$return_data=$this->get_current_user_only_reviewer_conditon($article_details->art_artp_id,$article_details->art_id,$user_id,$jnl_code,$jnl_id,$user_ids,true);
						//print_r($return_data); die;

						if(isset($return_data['msg'])&&$return_data['msg']!='')
						{
						return $this->success('warning',200,$return_data);
						}
			
					}

					if (!empty($template))
					{
						if ($template->stage_etmp_to == 'User')
						{
							$preview_recipient = TRUE;
						}
					}
					$reviewer = array();
					
					$reviewer = $Users::get_single_record('usr_id,usr_title,usr_first_name,usr_last_name,usr_username,usr_email,usr_status,usr_deeplink_token', "usr_id={$user_id}");
					$displayarray=array();
                    $displayarray['user_id']=$user_id;
                    $displayarray['salutation']=TRUE;
                    $displayarray['fullname_only']=TRUE;
					$displayarray['journal_id']=$jnl_id;
					$usercount =  'single';
                                         //#431 Not showing user middle name in adhoc email popup
                                        $reviewer->full_name = $this->get_user_display_name($displayarray);
					$user_info=$reviewer;
				}
				else
				{
					$optvalue = array();
					for($i=0;$i<count($user_ids);$i++)
					{
						$uid=decrypt_link($user_ids[$i]);

						if($article_details->jwf_stage_type == "review" &&  $skipcondition == false && $template_action == 'invite')
						{
							$return_data=$this->get_current_user_only_reviewer_conditon($article_details->art_artp_id,$article_details->art_id,$uid,$jnl_code,$jnl_id,$user_ids,true);
							if(isset($return_data['msg'])&&$return_data['msg']!='')
							{
							return $this->success('warning',200,$return_data);
							}
				
						}
						$user = $Users::get_single_record('usr_id,usr_title,usr_first_name,usr_last_name,usr_username,usr_email,usr_status,usr_deeplink_token',"usr_id={$uid}");
						$displayarray=array();
						$displayarray['user_id']=$uid;
						$displayarray['salutation']=TRUE;
						$displayarray['fullname_only']=TRUE;
						$displayarray['journal_id']=$jnl_id;
						$usercount =  'multiple';
											 //#431 Not showing user middle name in adhoc email popup
											 $user->full_name = $this->get_user_display_name($displayarray);
						array_push($optvalue, $user);
					}

					$user_info = $optvalue;
				}
				if ($template != NULL)
				{
					$link = $accept_link = $reject_link = '';
					if (count($user_ids) == 1 && !empty($reviewer) && $template_action != 'batch_article_reviewer_assignment')
					{
						if ($reviewer->usr_status == 'w')
						{
								$aflw_deeplink_token = Str::random(16);
								$Users::update_record(array(
									'usr_deeplink_token' => $aflw_deeplink_token),"usr_id={$reviewer->usr_id}",$this->current_user);
						}
						else
						{
							if ($article_details->aflw_deeplink_token == NULL || $article_details->aflw_deeplink_token == '')
							{
								$aflw_deeplink_token = Str::random(16);
							}
							else
							{
								$aflw_deeplink_token = $article_details->aflw_deeplink_token;
							}
						}

						$condition ="aflw_parent_flow_id={$current_stage_id} AND aflw_usr_id={$user_id}";

						$get_flow_rcrd = $article_flow::get_single_record('aflw_id,aflw_deeplink_token,aflw_status', $condition,orderby:'aflw_id desc');
						if (!empty($get_flow_rcrd))
						{
							$article_details->aflw_id = $current_stage_id = $get_flow_rcrd->aflw_id;
								#6324 Issue with accept/reject link in saved emails for reviewers
								if (($get_flow_rcrd->aflw_deeplink_token == NULL || $get_flow_rcrd->aflw_deeplink_token == '') && $get_flow_rcrd->aflw_status !== 'd')
								{
								$article_flow::update_record(array(
									'aflw_deeplink_token' => $aflw_deeplink_token,'aflw_operation'=>'e'),"aflw_id={$article_details->aflw_id}",$this->current_user);
								}
								else{
									$aflw_deeplink_token = $get_flow_rcrd->aflw_deeplink_token;
								}
						}
						
						$link =  URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&article_flow_id=' . $article_details->aflw_id);
						$accept_link =URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&user_role=reviewer');

                      //#581 hide terms & conditions popup for reviewers on decline invitation
                       $reject_link =URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide');
				}

					/* 2.1 if templates found,generate email data */
					$email_data = new stdClass;
					$email_data->article_id = $article_id;
					if ($preview_recipient == TRUE)
					{
						$email_data->CONFIRMATION_URL = $link;
						$email_data->DIRECT_ACCEPT = $accept_link;
						$email_data->DIRECT_REJECT = $reject_link;
						$email_data->user_name = $reviewer->usr_username;
						$email_data->name = $reviewer->usr_first_name . ' ' . $reviewer->usr_last_name;
						$email_data->user_email = $reviewer->usr_email;
						$email_data->user_id = $user_id;
					}
					if ($template->stage_etmp_to == 'User' && $preview_recipient == FALSE)
					{
						$email_data->replace_email_link_tags = TRUE;
					}

					$email_data->aflw_id = $article_details->aflw_id;
					/*core_role*/
					if(isset($core_role_id)&&!empty($core_role_id)){
						$core_role_details=$Roles::get_single_record('role_name,role_assigned_role',"role_id={$core_role_id}");
						$email_data->core_role=$core_role_details->role_assigned_role;
						$email_data->core_role_name=$core_role_details->role_name;
					}
					/*end core_role task*/
					$select = 'jwf_stage_type';
					$where ="aflw_art_id={$email_data->article_id} AND aflw_id={$email_data->aflw_id}" ;

					$current_status = $article_flow::get_generic_flow($select, $where);
					$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
					$review_flow = Config::get($workflow_config);
					$email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_id, 'a');
					$email_data->artp_id = $article_details->art_artp_id;
					$email_data->jnl_id = $jnl_id;
					$email_data->jnl_journal_code = $jnl_code;
					$email_data->email_templates_config = $this->email_templates_config();
					if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
						$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
					$email_data->join_config = $this->join_config();
					$email_data->join_dependency_config = $this->join_dependency_config();
					$email_data->user_role_tags = $this->user_role_tags();
					if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
						$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
					// clearing user_email after each mail send, to avoid merging on "custom to"
					$email_data->user_email = '';
					$tmpl_subject = $template->stage_etmp_subject;
					$tmpl_body = $template->stage_etmp_content;
					//since due_date get only after send : calculate for preview
					$email_data->article_status_details_for_init[0] = array(
						'ARTICLE_STATUS_NAME' => $article_details->jwf_status_name,
						'ARTICLE_STAGE_NAME' => $article_details->jwf_stage_name,
						// 'TASK_DUE_DATE' => $article_details->TASK_DUE_DATE,
						// 'TASK_REMAINING_DAYS' => $article_details->TASK_REMAINING_DAYS
					);
					if (strpos($tmpl_body,"OPENING_PARAGRAPH") > 0)
				$tmpl_body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$tmpl_body);

				if ($template_action == 'reopen_review' ){
					$replace_all_tags = FALSE;
				}
				$body = $this->generate_email_data_from_keys($email_data, $tmpl_body, $this->current_user, '', $preview_recipient, $replace_all_tags);
					$subject = $this->generate_email_data_from_keys($email_data, $tmpl_subject,$this->current_user, '', $preview_recipient);
					//bug with link tags DIRECT_ACCEPT, DIRECT_REJECT, CONFIRMATION_URL if multiple user invitation
					if ($template->stage_etmp_to != 'User')
					{
						$body = str_ireplace('##CONFIRMATION_URL##', '', $body);
						$body = str_ireplace('##DIRECT_ACCEPT##', '', $body);
						$body = str_ireplace('##DIRECT_REJECT##', '', $body);
					}
					preg_match_all('/##([^##]*)##/', $body, $matches);
					$keys = $matches[1];

					for ($i = 0; $i < count($keys); $i++) {
						$element = $keys[$i];
						if(!empty($element))
						{
						$tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
						$body = $tmpl_data;
						}
					}
					$body = str_ireplace('##', '', $body);
					$body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
					$body=  str_ireplace('</button></button>','</button>', $body);
					$reply_to=$this->get_reply_to_email($jnl_id,$current_status);

					//Bug #1809 : JPR-260 Remove options for cc and bcc roles in invitation email
					$to_cc_arr = json_decode($template->stage_etmp_cc);
					$to_bcc_arr = json_decode($template->stage_etmp_bcc);
					$cc_roles = array();
					$bcc_roles = array();
					$disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
					if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
					{
					$role_cond = 'role_assigned_role NOT IN ("system", "author","reviewer")';
					if ($event_based == 'n')
					{
						if(isset($reviewflow['stage_for']))
						{
							 if($reviewflow['stage_for'] == 'review')
								 $role_cond.=' and FIND_IN_SET("r", role_used_in)';
							 elseif($reviewflow['stage_for'] == 'manageproduction')
								 $role_cond.=' and FIND_IN_SET("p", role_used_in)';
						}
					}

					$user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
					if (!empty($user_roles))
					{
						foreach ($user_roles as $usrole)
						{
							$role_label = "All " . $usrole->role_name . "s";
							$cc_roles[$usrole->role_name] = $role_label;
							$bcc_roles[$usrole->role_name] = $role_label;
						}
					}
					}
					$cc_roles['Custom_cc'] = 'Specific email ID';
					$bcc_roles['Custom_bcc'] = 'Specific email ID';
					//task 5177 and 2384 - while inviting reviewers the corresponding attachments are not retrived properly 
					array_walk($user_ids, function(&$value, $key)
					{
						$value = decrypt_link($value);
					});
					$user_id_arr = join(',', $user_ids);
					$condition ="aflw_parent_flow_id={$current_stage_id} AND aflw_usr_id IN ({$user_id_arr})";
					if (!isset($get_flow_rcrd) && empty($get_flow_rcrd))
					{
						$get_flow_rcrd = $article_flow::get_single_record('aflw_id', $condition);
					}
					// Task #3044 , single/multi mail template related bug fix   => start
					$attch_file_html	=	'';
					$tot_attachment_sz 	=	0;
					if(isset($get_flow_rcrd) && !empty($get_flow_rcrd) && $template_action != 'uninvite'){
						// Task #3044 , single/multi mail template related bug fix    => end
					$noti_condition ="ane_art_id={$article_id} AND ane_aflw_id={$get_flow_rcrd->aflw_id} AND ane_status = 0 "; // Task #8948, The reopen mail showing previously added attachments in reopen submit invitation mail issue fixed by add a condition to check weather the article notification mail send or not by -> ane_status = 0/1 if 0 -> mail not send else 1 -> mail send successfully
					if(isset($template->stage_etmp_id))
					{
						$noti_condition .=" AND ane_stage_etmp_id={$template->stage_etmp_id}";
					}
					elseif(isset($template->etmp_id))
					{
						$noti_condition .=" AND ane_event_etmp_id={$template->etmp_id}";
						$data['stage_etmp_id']=$template->etmp_id;
					}
					if($tmpl_type != ''){
						$noti_condition .="  AND ane_for= '{$tmpl_type}' ";
					}
					$article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to', $noti_condition);
					if(!empty($article_notification))
					{
						$attch_file_html = $this->get_invite_email_attachments($article_id,$article_notification->ane_id,TRUE,'',$tmpl_type);
						if(count($attch_file_html) > 0) {
							foreach($attch_file_html as $key) {
								$tot_attachment_sz	=	$tot_attachment_sz + $key['document_size'];
							}
						}
					}
					}
					
					$data = array(
						'cc_roles' => $cc_roles,
						'bcc_roles' => $bcc_roles,
						'user_ids' => $usr_ids,
						'aflw_id' => $current_stage_id,
						'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
						'to_cc' => $to_cc_arr,
						'to_bcc' => $to_bcc_arr,
						'cust_cc' => $template->stage_etmp_cust_cc,
						'cust_bcc' => $template->stage_etmp_cust_bcc,
						'reply_to' => $reply_to,
						'subject' => $subject,
						'content' => $body,
                        'attch_file_html' => (isset($attch_file_html)?$attch_file_html:''),
						'invite_templates' => $all_templates,
						'change_invite_templates' => $alltemplates,
						'user_info' => $user_info,
						'tot_attachment_sz' => $tot_attachment_sz,
					);
						$data['usercount'] = $usercount;
				}
				else
				{
					$data = array(
						'status' => 'template_err',
						'user_info' => $user_info,
						'aflw_id' => $current_stage_id,
						'email_template' =>  'You have not defined any email templates'
					);
				}

				$content = '';
				$return_arr = array();
				$allowed_tmpl_actn = array('invitation','reopen_review');
				if(in_array($template_action,$allowed_tmpl_actn))
				{
					$data['enable_attachments'] = TRUE;
					$data['enable_inventory_files'] = TRUE;
					$data['is_reopen'] = FALSE;
					if($template_action == 'reopen_review')
						$data['is_reopen'] = TRUE;
				}
				if ($template_view == 'y')
				{
					$content=$data;
				}
				else
				{
					$data['template_action'] = $template_action;
					$confirm_msg = "";
					if ($template_action == 'uninvite')
					{
						$btn_id = 'btn_uninvite_invitation';
						$btn_name = 'btn_uninvite_invitation';
						$confirm_msg = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
					else
					{
						$btn_id = 'btn_send_invitation';
						$btn_name = 'btn_send_invitation';
						$confirm_msg = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
					$btn_text = 'Send';
					$form_id = "form_invite_email_preview";
					$form_name = "form_invite_email_preview";
					$stage_name = "";
					if ($template_action == 'unassign' || $template_action == 'unassign-reviewer')
					{
						$btn_id = 'btn_unassgn_rvr';
						$btn_name = 'btn_unassgn_rvr';
						$form_name = 'form_preview_unassgn';
						$form_id = 'form_preview_unassgn';
						if ($hold != '')
						{
							$hold_id = decrypt_link($hold);
							$hold_article_details = $article::get_article_details('jwf_stage_name',"aflw_id={$hold_id}");
							$stage_name = $hold_article_details[0]->jwf_stage_name;
							$btn_text = 'Proceed to ' . $hold_article_details[0]->jwf_stage_name;
						}
					}

					if ($template_action == 'review_resubmit' || $template_action == 'reopen_review')
					{
						$btn_id = 'btn_review_resubmit';
						$btn_name = 'btn_review_resubmit';
					}

					$data['form_name'] = $form_name;
					$data['form_id'] = $form_id;
					$data['btn_id'] = $btn_id;
					$data['btn_name'] = $btn_name;
					$data['btn_text'] = $btn_text;
					$data['btn_confirm_msg'] = $confirm_msg;

					if ($event_based == 'y')
					{
						$title = '';
						if ($template_action == 'reviewer_on_fly_email_change')
						{
							$return_arr['userdata'] = $reviewer;
							$title = 'Edit reviewer information';

							$data['form_name'] = 'reviewer_on_fly_email_change';
							$data['form_id'] = 'reviewer_on_fly_email_change';
							$data['btn_id'] = 'reviewer_on_fly_email_change_button';
							$data['btn_name'] = 'reviewer_on_fly_email_change_button';
							$data['btn_text'] = 'Change';
							$return_arr['instruction'] = str_replace('##link##', ' <a id=\'edit_fly_email_template\'>here</a> ', str_replace('##email##', $reviewer->usr_email, 'If there is a change in the email address, an email notification will be sent to <b>##email##</b>. Click ##link## to view or edit the email.'));
						}
						else if ($template_action == 'reopen_review')
						{
							$title = 'Review reopen';
						}
					}
					else if($event_based == 'n')
					{
						if ($template_action == 'unassign' || $template_action == 'unassign-reviewer')
						{
							$title = 'Unassign user';
						}
						else if ($template_action == 'uninvite')
						{
							$title = 'Uninvite user';
						}
						else if ($template_action == 'review_resubmit')
						{
							$title = 'Review resubmit';
						}
						else
						{
							if($article_details->art_proposal_method == 'assign')
							$title = 'Assign user';
							else
							$title = 'Invite user';
						}
					}
					else{
						return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
					}
					$data['stage_name'] = $stage_name;
					$data['title'] = $title;
					$data['hold'] = $hold;

				}
				$return_arr['template_view'] = $template_view;
				$return_arr['content'] = $content;
			}
			elseif ($template_action == 'unassign-reviewer')
			{
				$curr_stage_child = json_decode($article_details->jwf_child_stages);
				$next_stage_data = $Generic_flows::get_single_record('jwf_stage_name',"jwf_id={$curr_stage_child[0]}" );


				$stage_name = $next_stage_data->jwf_stage_name;
				$btn_id = 'btn_unassgn_rvr';
				$btn_name = 'btn_unassgn_rvr';
				$form_name = 'form_preview_unassgn';
				$form_id = 'form_preview_unassgn';
				if ($hold != '')
				{

					$hold_id = decrypt_link($hold);
					$hold_article_details = $article->get_article_details('jwf_stage_name, jwf_stage_type',"aflw_id={$hold_id}");

					$stage_name = $hold_article_details[0]->jwf_stage_name;
					$btn_text = 'Proceed to ' . $hold_article_details[0]->jwf_stage_name;
					if ($hold_article_details[0]->jwf_stage_type == "post_assessment")
					{
						$data['btn_confirm_msg'] = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
				}
				$msg = 'You are moving to ' . $stage_name;

				$data['stage_name'] = $stage_name;
				$data['hold'] = $hold;
				$data['form_name'] = $form_name;
				$data['form_id'] = $form_id;
				$data['btn_id'] = $btn_id;
				$data['status'] = 'proceed';
				$data['title'] = 'Proceed';
				$data['hold'] = $hold;
				$data['aflw_id'] = $current_stage_id;
				$data['msg'] = $msg;
				$data['btn_name'] = $btn_name;
				$data['btn_text'] = $btn_text;
				$return_arr['template_view'] = $template_view;
			}
		$return_arr['email_data'] = (isset($data)) ? $data : null;
		return $this->success('success',200,$return_arr);

        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function email_preview_bulk_article($data){

        $validator = validator($data, [
            'aflw_id' => 'required',
            'template' => 'required',
            'user_id' => 'required',
            'jnl_code' => 'required',
            'jnl_id' => 'required',
        ]);

        if($validator->fails()){
            return "failed";
        }
            $usercount ='';
            $article= new \App\Models\Articles();
			$Email_templates = new \App\Models\Email_templates;
            $Users=new \App\Models\User();
            $Roles=new \App\Models\Roles();
            $this->current_user=$this->get_current_user_details();
            $current_stage_id = $data['aflw_id'];
            sort($current_stage_id);
			$user_id = isset($data['user_id']) ? decrypt_link($data['user_id']): '';
			$jnl_id = isset($data['jnl_id']) ? decrypt_link($data['jnl_id']) : '';
			$jnl_code = isset($data['jnl_code']) ? $data['jnl_code']: '';
			$template_view = isset($data['view']) ? $data['view']: '';
			$core_role_id=(isset($data['role_id']))?$data['role_id']:'';
			$template_action = $data['template'];
			$event_based = (isset($data['event_based'])) ? $data['event_based'] : 'n';
			$usr_ids = $user_id;
            $current_stage_id_str = '"'.implode('", "', $current_stage_id).'"';
            $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,aflw_deeplink_token,aflw_usr_id,jwf_child_stages';
			$article_details = $article::get_article_details($select, "aflw_id in ($current_stage_id_str) ", limit: count($current_stage_id));
			$article_details = $article_details->toArray();
			$article_ids = array_column($article_details, 'art_id');
			$all_templates = array();
			$alltemplates = array();
			if($event_based == 'y')
			{

				$template = $Email_templates::get_single_record('*',"etmp_name='{$template_action}' AND etmp_notification='User'" );

				if ($template != null)
				{
					$template->stage_etmp_to = $template->etmp_notification;
					$template->stage_etmp_subject = $template->etmp_subject;
					$template->stage_etmp_content = $template->etmp_email_template;
					$template->stage_etmp_subject = $template->etmp_subject;
					$template->stage_etmp_cc = $template->etmp_cc;
					$template->stage_etmp_bcc = $template->etmp_bcc;
					$template->stage_etmp_cust_cc = $template->etmp_cust_cc;
					$template->stage_etmp_cust_bcc = $template->etmp_cust_bcc;
				}
			}
			else
			{
				return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));

			}
			$hold = isset($post_data['hold']) ? $post_data['hold'] : '';
			$user_info = '';
			if (!empty($user_id))
			{

				$user_ids = explode(',', $user_id);

				$reviewer = new stdClass();
				$preview_recipient = FALSE;
				$replace_all_tags = TRUE;

				if (count($user_ids) == 1 && !empty($template))
				{

					if (!empty($template))
					{
						if ($template->stage_etmp_to == 'User')
						{
							$preview_recipient = TRUE;
						}
					}
					$reviewer = array();
					$user_id = $user_ids[0];
					$reviewer = $Users::get_single_record('usr_id,usr_title,usr_first_name,usr_last_name,usr_username,usr_email,usr_status,usr_deeplink_token', "usr_id={$user_id}");
					$displayarray=array();
                    $displayarray['user_id']=$user_id;
                    $displayarray['salutation']=TRUE;
                    $displayarray['fullname_only']=TRUE;
					$displayarray['journal_id']=$jnl_id;
					$usercount =  'single';
                                         //#431 Not showing user middle name in adhoc email popup
                                        $reviewer->full_name = $this->get_user_display_name($displayarray);
					$user_info=$reviewer;
				}
				else
				{
					$optvalue = array();
					for($i=0;$i<count($user_ids);$i++)
					{
						$uid=decrypt_link($user_ids[$i]);
						$user = $Users::get_single_record('usr_id,usr_title,usr_first_name,usr_last_name,usr_username,usr_email,usr_status,usr_deeplink_token',"usr_id={$uid}");
						$displayarray=array();
						$displayarray['user_id']=$uid;
						$displayarray['salutation']=TRUE;
						$displayarray['fullname_only']=TRUE;
						$displayarray['journal_id']=$jnl_id;
						$usercount =  'multiple';
											 //#431 Not showing user middle name in adhoc email popup
											 $user->full_name = $this->get_user_display_name($displayarray);
						array_push($optvalue, $user);
					}

					$user_info = $optvalue;
				}
					/* 2.1 if templates found,generate email data */
					$email_data = new stdClass;
					$email_data->article_id = $article_ids;
					if ($template->stage_etmp_to == 'User' && $preview_recipient == FALSE)
					{
						$email_data->replace_email_link_tags = TRUE;
					}

					$email_data->aflw_id = $current_stage_id;
					/*core_role*/
					if(isset($core_role_id)&&!empty($core_role_id)){
						$core_role_details=$Roles::get_single_record('role_name,role_assigned_role',"role_id={$core_role_id}");
						$email_data->core_role=$core_role_details->role_assigned_role;
						$email_data->core_role_name=$core_role_details->role_name;
					}
					/*end core_role task*/

					$current_status = array();
					$email_data->jnl_id = $jnl_id;
					$email_data->jnl_journal_code = $jnl_code;
					$email_data->email_templates_config = $this->email_templates_config();
					$email_data->join_config = $this->join_config();
					$email_data->join_dependency_config = $this->join_dependency_config();
					$email_data->user_role_tags = $this->user_role_tags();
					if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
						$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
					// clearing user_email after each mail send, to avoid merging on "custom to"
					$email_data->user_email = '';
					$tmpl_subject = $template->stage_etmp_subject;
					$tmpl_body = $template->stage_etmp_content;
					//since due_date get only after send : calculate for preview
				    $body = $this->generate_email_data_from_keys($email_data, $tmpl_body, $this->current_user, '', $preview_recipient, $replace_all_tags);
					$subject = $this->generate_email_data_from_keys($email_data, $tmpl_subject,$this->current_user, '', $preview_recipient);
					//bug with link tags DIRECT_ACCEPT, DIRECT_REJECT, CONFIRMATION_URL if multiple user invitation
					if ($template->stage_etmp_to != 'User')
					{
						$body = str_ireplace('##CONFIRMATION_URL##', '', $body);
						$body = str_ireplace('##DIRECT_ACCEPT##', '', $body);
						$body = str_ireplace('##DIRECT_REJECT##', '', $body);
					}
					preg_match_all('/##([^##]*)##/', $body, $matches);
					$keys = $matches[1];

					for ($i = 0; $i < count($keys); $i++) {
						$element = $keys[$i];
						if(!empty($element))
						{
						$tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
						$body = $tmpl_data;
						}
					}
					$body = str_ireplace('##', '', $body);
					$body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
					$body=  str_ireplace('</button></button>','</button>', $body);
					$reply_to=$this->get_reply_to_email($jnl_id,$current_status);

					//Bug #1809 : JPR-260 Remove options for cc and bcc roles in invitation email
					$to_cc_arr = json_decode($template->stage_etmp_cc);
					$to_bcc_arr = json_decode($template->stage_etmp_bcc);
					$cc_roles = array();
					$bcc_roles = array();
					$disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
					if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
					{
					$role_cond = 'role_assigned_role NOT IN ("system", "author","reviewer")';
					if ($event_based == 'n')
					{
						if(isset($reviewflow['stage_for']))
						{
							 if($reviewflow['stage_for'] == 'review')
								 $role_cond.=' and FIND_IN_SET("r", role_used_in)';
							 elseif($reviewflow['stage_for'] == 'manageproduction')
								 $role_cond.=' and FIND_IN_SET("p", role_used_in)';
						}
					}

					$user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
					if (!empty($user_roles))
					{
						foreach ($user_roles as $usrole)
						{
							$role_label = "All " . $usrole->role_name . "s";
							$cc_roles[$usrole->role_name] = $role_label;
							$bcc_roles[$usrole->role_name] = $role_label;
						}
					}
					}
					$cc_roles['Custom_cc'] = 'Specific email ID';
					$bcc_roles['Custom_bcc'] = 'Specific email ID';
					$tot_attachment_sz 	=	0;

					$data = array(
						'cc_roles' => $cc_roles,
						'bcc_roles' => $bcc_roles,
						'user_ids' => $usr_ids,
						'aflw_id' => $current_stage_id,
						'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
						'to_cc' => $to_cc_arr,
						'to_bcc' => $to_bcc_arr,
						'cust_cc' => $template->stage_etmp_cust_cc,
						'cust_bcc' => $template->stage_etmp_cust_bcc,
						'reply_to' => $reply_to,
						'subject' => $subject,
						'content' => $body,
                        'attch_file_html' => (isset($attch_file_html)?$attch_file_html:''),
						'invite_templates' => $all_templates,
						'change_invite_templates' => $alltemplates,
						'user_info' => $user_info,
						'tot_attachment_sz' => $tot_attachment_sz,
					);
						$data['usercount'] = $usercount;

				}
				else
				{
					$data = array(
						'status' => 'template_err',
						'user_info' => $user_info ?? '',
						'aflw_id' => $current_stage_id,
						'email_template' =>  'You have not defined any email templates'
					);
				}

				$content = '';
				$return_arr = array();
				$allowed_tmpl_actn = array('invitation','reopen_review');
				if(in_array($template_action,$allowed_tmpl_actn))
				{
					$data['enable_attachments'] = TRUE;
					$data['enable_inventory_files'] = TRUE;
					$data['is_reopen'] = FALSE;
					if($template_action == 'reopen_review')
						$data['is_reopen'] = TRUE;
				}
				if ($template_view == 'y')
				{
					$content=$data;
				}
				else
				{
					$data['template_action'] = $template_action;
					$confirm_msg = "";
					if ($template_action == 'uninvite')
					{
						$btn_id = 'btn_uninvite_invitation';
						$btn_name = 'btn_uninvite_invitation';
						$confirm_msg = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
					else
					{
						$btn_id = 'btn_send_invitation';
						$btn_name = 'btn_send_invitation';
						$confirm_msg = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
					$btn_text = 'Send';
					$form_id = "form_invite_email_preview";
					$form_name = "form_invite_email_preview";
					$stage_name = "";
					if ($template_action == 'unassign' || $template_action == 'unassign-reviewer')
					{
						$btn_id = 'btn_unassgn_rvr';
						$btn_name = 'btn_unassgn_rvr';
						$form_name = 'form_preview_unassgn';
						$form_id = 'form_preview_unassgn';
						if ($hold != '')
						{
							$hold_id = decrypt_link($hold);
							$hold_article_details = $article::get_article_details('jwf_stage_name',"aflw_id={$hold_id}");
							$stage_name = $hold_article_details[0]->jwf_stage_name;
							$btn_text = 'Proceed to ' . $hold_article_details[0]->jwf_stage_name;
						}
					}

					$data['form_name'] = $form_name;
					$data['form_id'] = $form_id;
					$data['btn_id'] = $btn_id;
					$data['btn_name'] = $btn_name;
					$data['btn_text'] = $btn_text;
					$data['btn_confirm_msg'] = $confirm_msg;
					$data['stage_name'] = $stage_name;
					$data['title'] = '';
					$data['hold'] = $hold;

				}
				$return_arr['template_view'] = $template_view;
				$return_arr['content'] = $content;

                $return_arr['email_data'] = (isset($data)) ? $data : null;
                return $this->success('success',200,$return_arr);

    }

	public function fetch_email_preview(Request $request)
    {
		try {
			$post_data = $request->all();
			$this->current_user=$this->get_current_user_details();
			$validator = Validator::make($request->all(), [
				'jnl_code' => 'required',
				'jnl_id' => 'required',
				'article_set.0.stage_etmp_id'=>'required',
				'view'=>'required',
				'action'=>'required',
			]);
			if ($validator->fails()) {
				return $this->failure('Failed', 422, $validator->errors());
			}
			$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlcodearray = array('input'=>$post_data['jnl_code']);
			$stageetmpidarray = array('input'=>$post_data['article_set'][0]['stage_etmp_id'],'type'=>'number', 'enc_data'=>TRUE );
			$viewarray = array('input'=>$post_data['view'],'type'=>'bflag' );
			$actionarray = array('input'=>$post_data['action'],'type'=>'string', 'enc_data'=>TRUE );

			$jnlidvalidation= $this->Rv_validator($jnlidarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
			$stageetmpidvalidation= $this->Rv_validator($stageetmpidarray);
			$viewvalidation= $this->Rv_validator($viewarray);
			$actionvalidation= $this->Rv_validator($actionarray);

			if($jnlidvalidation != TRUE || $jnlcodevalidation != TRUE || $stageetmpidvalidation != TRUE || $viewvalidation != TRUE || $actionvalidation != TRUE ){
				return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}
			$core_role = isset($post_data['core_role']) ? decrypt_link($post_data['core_role']): '';
			$role_name = isset($post_data['role_name']) ?decrypt_link($post_data['role_name']): '';
			$role_id = isset($post_data['role_id']) ? decrypt_link($post_data['role_id']): '';
			$Articles= new \App\Models\Articles();
			$Article_flow = (new \App\Models\Article_flow);
			$Stage_email_templates= new \App\Models\Stage_email_templates();
			$Article_notification_emails = new \App\Models\Article_notification_emails;
			$Users=new \App\Models\User();
			$Roles=new \App\Models\Roles();
			$User_to_journals= new \App\Models\User_to_journals();
			$jnl_code = isset($post_data['jnl_code']) ?decrypt_link($post_data['jnl_code']): '';
			$jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
			$current_stage_ids = array();
            $user_ids = array();

            $article_set = $post_data['article_set'];
            foreach($article_set as $article)
            {
                $current_stage_ids[] = decrypt_link($article['aflw_id']);
                $user_ids[] = decrypt_link($article['user_id']);
            }

            $current_stage_id  = $current_stage_ids[0];
			$placeholders =  implode(',',array_fill(0,count($current_stage_ids),'?'));
			$stage_etmp_id = isset($post_data['article_set'][0]['stage_etmp_id']) ? decrypt_link($post_data['article_set'][0]['stage_etmp_id']) : '';
            $template_view = $post_data['view'];
            $template_action = decrypt_link($post_data['action']);

            $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept, `aflw_due_date` AS `TASK_DUE_DATE`, (CASE WHEN DATEDIFF(`aflw_due_date`, NOW()) < 0 THEN "0" ELSE DATEDIFF(`aflw_due_date`, NOW()) END) AS TASK_REMAINING_DAYS,aflw_deeplink_token,aflw_usr_id,jwf_child_stages,art_proposal_method';
			$article_details = $Articles::get_article_details($select, 'aflw_id IN (' .  $placeholders . ')',condition_arr:$current_stage_ids);

			$article_details = $article_details[0];
            $article_id = decrypt_link($article_set[0]['art_id']);
			if(!empty($template_action))
            {
				$preview_recipient = FALSE;
                $tmpl_action = NULL;

                if($template_action == 'invitation' || $template_action == 'reinvitation')
                {
                    $tmpl_action = 'assigned';
                }
                elseif($template_action == 'uninvite')
                {
                    $tmpl_action = 'uninvite_user';
                }
				elseif($template_action == 'unassign')
                {
                    $tmpl_action = 'unassign_user';
                }


				$condition="stage_etmp_stage_type='{$article_details->jwf_stage_type}' AND setr_jwf_id={$article_details->jwf_id} AND stage_etmp_action='{$tmpl_action}'";

                if ($template_view == 'y')
				{
					$condition .= " AND stage_etmp_id= {$stage_etmp_id}";
				}

                $template = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);

				if (!empty($stage_etmp_id) && !empty($template))
                {
                    $templ_f = $templ_l = array();
                    $i=1;
                    foreach($template as $row)
                    {
                        if($row->stage_etmp_id == $stage_etmp_id)
                        {
                            if(isset($post_data['discard_stat']) && !empty($post_data['discard_stat']) && $post_data['discard_stat'] == true)
                            {
								$Article_notification_emails::delete_records("ane_stage_etmp_id = ? AND ane_art_id = ? AND ane_aflw_id = ?",'',$this->current_user,binding_arr:[$stage_etmp_id,$article_id,$current_stage_id]); // TASK #4943 proposalemailpreview sql injection
							}
                            $article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to',"ane_stage_etmp_id = ? AND ane_art_id = ? AND ane_aflw_id = ?",binding_arr:[$stage_etmp_id,$article_id,$current_stage_id]); // TASK #4943 proposalemailpreview sql injection
						if(!empty($article_notification))
                            {
                                $row->stage_etmp_subject = $article_notification->ane_subject;
                                $row->stage_etmp_content = $article_notification->ane_content;
                                $edited_reply_to = $article_notification->ane_reply_to;
                                $row->stage_etmp_cc = $article_notification->ane_cc;
                                $row->stage_etmp_bcc = $article_notification->ane_bcc;
                                $row->stage_etmp_cust_cc = $article_notification->ane_cust_cc;
                                $row->stage_etmp_cust_bcc = $article_notification->ane_cust_bcc;
                                $row->attch_file_html = $this->get_invite_email_attachments($article_id,$article_notification->ane_id);
                            }
                            $templ_f = $row;
                        }
                        else
                        {
                            $templ_l[] = $row;
                            $i++;
                        }
                    }
                    if(count($template)>1)
                    {
                        if(!empty($templ_f))
                            array_unshift( $templ_l, $templ_f );
                        $template = $templ_l;
                    }
                }
				$author = new stdClass();
                $all_templates = $template;

                if(count($user_ids) == 1)
                {
                    $preview_recipient = TRUE;
                    $user_id = $user_ids[0];
                    $author = $Users::get_single_record('usr_id,usr_title,usr_first_name,usr_last_name,usr_username,usr_email,usr_status,usr_deeplink_token',"usr_id=?",binding_arr:[$user_id]); // TASK #4943 proposalemailpreview sql injection
                    $author->user_titles =  $this->UserConfigdata('titles')['titles'];
                    $author->modal_title = 'Email preview';
					$array_data['user_id']=$user_id;
                    $array_data['salutation']=TRUE;
                    $array_data['fullname_only']=TRUE;
					$author->full_name  = $this->get_user_display_name($array_data);
                    $user_info = $author;
                }
                else
                {
					$optvalue = array();
					for($i=0;$i<count($user_ids);$i++)
					{
						$uid=$user_ids[$i];
						$user = $Users::get_single_record('usr_id,usr_title,usr_first_name,usr_last_name,usr_username,usr_email,usr_status,usr_deeplink_token',"usr_id=?",binding_arr:[$uid]); // TASK #4943 proposalemailpreview sql injection
						$displayarray=array();
						$displayarray['user_id']=$uid;
						$displayarray['salutation']=TRUE;
						$displayarray['fullname_only']=TRUE;
						$displayarray['journal_id']=$jnl_id;
						$user->full_name = $this->get_user_display_name($displayarray);
						array_push($optvalue, $user);
					}

					$user_info = $optvalue;
                }
				$jnl_user_role[$jnl_code]= array(
					'role_id' => $role_id,
					'role_name' => $role_name,
					'core_role' => $core_role,
				);
				$this->current_user['jnl_user_role']=$jnl_user_role;

				if(empty($template[0]))
				{
					$data = array(
						'status' => 'template_err',
						'user_info' => $user_info,
						'aflw_id' => $current_stage_id,
						'email_template' => 'You have not defined any email templates'
					);
				}

				if (count($template)>0)
                {
                    $template = $template[0];
                    $replace_all_tags = TRUE;
                    $update_deeplink = FALSE;
                    $link = $accept_link = $reject_link = '';
                    if (count($user_ids) == 1 && !empty($author))
                    {
                        if ($author->usr_status == 'w')
                        {
                            if (!empty($author->usr_deeplink_token))
                            {
                                $aflw_deeplink_token = $author->usr_deeplink_token;
                                if ($article_details->aflw_deeplink_token != $author->usr_deeplink_token)
                                {
                                    $update_deeplink = TRUE;
                                }
                            }
                            else
                            {
                                $aflw_deeplink_token = 	$aflw_deeplink_token = Str::random(16);
								$Users::update_record(array(
									'usr_deeplink_token' => $aflw_deeplink_token),"usr_id={$author->usr_id}",$this->current_user);
                                $update_deeplink = TRUE;
                            }
                        }
                        else
                        {
                            if ($article_details->aflw_deeplink_token == NULL || $article_details->aflw_deeplink_token == '')
                            {
                                $update_deeplink = TRUE;
                                $aflw_deeplink_token =Str::random(16);
                            }
                            else
                            {
                                $aflw_deeplink_token = $article_details->aflw_deeplink_token;
                            }
                        }

				$condition ="aflw_parent_flow_id={$current_stage_id} AND aflw_usr_id={$user_id}";
				if ($update_deeplink == TRUE && $article_details->aflw_status !== 'd')
						{
							$Article_flow::update_record(array(
								'aflw_deeplink_token' => $aflw_deeplink_token),"aflw_id=?",$this->current_user,binding_arr:[$current_stage_id]); // TASK #4943 proposalemailpreview sql injection
						}

						$link =  URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&article_flow_id=' . $article_details->aflw_id.'&bulksubmission=true');
						$accept_link =URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/accept-reject-submittion' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&bulksubmission=true');

                      //#581 hide terms & conditions popup for reviewers on decline invitation
                       $reject_link =URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/accept-reject-submittion' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide&bulksubmission=true');

                    }
                    $email_data = new stdClass;
                    $email_data->article_id = $article_id;
                    if ($preview_recipient == TRUE)
                    {
                        $email_data->CONFIRMATION_URL = $link;
                        $email_data->DIRECT_ACCEPT = $accept_link;
                        $email_data->DIRECT_REJECT = $reject_link;
                        $email_data->AUTHOR_DIRECT_ACCEPT = $accept_link;
                        $email_data->AUTHOR_DIRECT_REJECT = $reject_link;
                        $email_data->user_name = $author->usr_username;
                        $email_data->name = $author->usr_first_name . ' ' . $author->usr_last_name;
                        $email_data->user_email = $author->usr_email;
                        $email_data->user_id = $user_id;
                    }
                    if ($template->stage_etmp_to == 'User')
                    {
                        $email_data->replace_email_link_tags = TRUE;
                    }
                    $email_data->aflw_id = $article_details->aflw_id;
                    $email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_id, 'a');

                    $email_data->artp_id = $article_details->art_artp_id;
                    $email_data->jnl_id = $jnl_id;
                    $email_data->jnl_journal_code = $jnl_code;
                    $email_data->email_templates_config = $this->email_templates_config();
                    if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                        $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
                    $email_data->user_email = '';
                    $email_data->mail_type = 'preview';
                    $tmpl_subject = $template->stage_etmp_subject;
                    $tmpl_body = $template->stage_etmp_content;
                    $user_titles =  $this->UserConfigdata('titles')['titles'];
                    $email_data->article_status_details_for_init[0] = array(
                        'ARTICLE_STATUS_NAME' => $article_details->jwf_status_name,
                        'ARTICLE_STAGE_NAME' => $article_details->jwf_stage_name,
                        //'TASK_DUE_DATE' => $article_details->TASK_DUE_DATE,
                        //'TASK_REMAINING_DAYS' => $article_details->TASK_REMAINING_DAYS
                    );
                    if (strpos($tmpl_body,"OPENING_PARAGRAPH") > 0)
                        $tmpl_body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$tmpl_body);
                    if(count($user_ids) == 1 && !empty($author))
                    {
                        $body = $this->generate_email_data_from_keys($email_data, $tmpl_body, $this->current_user, $user_titles, $preview_recipient, $replace_all_tags);
                        $subject = $this->generate_email_data_from_keys($email_data, $tmpl_subject, $this->current_user, $user_titles, $preview_recipient);
                    }
                    else
                    {
                        $body = $tmpl_body;
                        $subject = $tmpl_subject;
                    }
                    if (!empty($template->stage_etmp_to) && $template->stage_etmp_to == 'User')
                    {
                    preg_match_all('/##([^##]*)##/', $template->stage_etmp_content, $matches);
                    $keys = $matches[1];
                    if (in_array('CONFIRMATION_URL', $keys))
                    {
                        $body = str_ireplace('##CONFIRMATION_URL##', '<a id="confirmation_url_tag_reinvite" href="' . $link . '">' . $link . '</a>', $body);
                    }

                    if (in_array('DIRECT_ACCEPT', $keys))
                    {
                        $body = str_ireplace('##DIRECT_ACCEPT##', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' . ((customTrans('client_lang.accept_link_text') != '') ? customTrans('client_lang.accept_link_text') : 'Accept') . '</a>', $body);
                    }

                    if (in_array('DIRECT_REJECT', $keys))
                    {
                        $body = str_ireplace('##DIRECT_REJECT##', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '" >' .((customTrans('client_lang.reject_link_text') != '') ? customTrans('client_lang.reject_link_text') : 'Reject'). '</a>', $body);
                    }
                    if (in_array('AUTHOR_DIRECT_ACCEPT', $keys))
                    {
                        $body = str_ireplace('##AUTHOR_DIRECT_ACCEPT##', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' . ((customTrans('client_lang.accept_link_text') != '') ? customTrans('client_lang.accept_link_text') : 'Accept') . '</a>', $body);
                    }

                    if (in_array('AUTHOR_DIRECT_REJECT', $keys))
                    {
                        $body = str_ireplace('##AUTHOR_DIRECT_REJECT##', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '" >' . ((customTrans('client_lang.reject_link_text') != '') ? customTrans('client_lang.reject_link_text') : 'Reject'). '</a>', $body);
                    }
                    }
                    else
                    {
                        $body = str_ireplace('##CONFIRMATION_URL##', '', $body);
                        $body = str_ireplace('##DIRECT_ACCEPT##', '', $body);
                        $body = str_ireplace('##DIRECT_REJECT##', '', $body);
                    }

					preg_match_all('/##([^##]*)##/', $body, $matches);
					$keys = $matches[1];
					for ($i = 0; $i < count($keys); $i++) {
						$element = $keys[$i];
						if(!empty($element))
						{
						$tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
						$body = $tmpl_data;
						}
					}
					$body = str_ireplace('##', '', $body);
					$body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
					$body=  str_ireplace('</button></button>','</button>', $body);

				$reply_to=$this->get_reply_to_email($jnl_id);
                    $to_cc_arr = json_decode($template->stage_etmp_cc);
                    $to_bcc_arr = json_decode($template->stage_etmp_bcc);
                    $cc_roles = array();
                    $bcc_roles = array();
                    $disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
                    if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
                    {
                    $roles_condition = null;
                    $role_cond = 'role_assigned_role NOT IN ("system", "author","reviewer")';

                    if(isset($reviewflow['stage_for']))
                    {
                            if($reviewflow['stage_for'] == 'review')
                                $role_cond.=' and FIND_IN_SET("r", role_used_in)';
                            elseif($reviewflow['stage_for'] == 'manageproduction')
                                $role_cond.=' and FIND_IN_SET("p", role_used_in)';
                    }
                    $user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                    if (!empty($user_roles))
                    {
                        foreach ($user_roles as $usrole)
                        {
                            $role_label = "All " . $usrole->role_name . "s";
                            $cc_roles[$usrole->role_name] = $role_label;
                            $bcc_roles[$usrole->role_name] = $role_label;
                        }
                    }
                }
                    $cc_roles['Custom_cc'] = 'Specific email ID';
                    $bcc_roles['Custom_bcc'] = 'Specific email ID';
				    $data = array(
                        'status' => 'success',
                        'cc_roles' => $cc_roles,
                        'bcc_roles' => $bcc_roles,
                        'user_ids' => $user_ids,
                        'aflw_id' => $current_stage_id,
                        'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
                        'to_cc' => $to_cc_arr,
                        'to_bcc' => $to_bcc_arr,
                        'cust_cc' => $template->stage_etmp_cust_cc !== '' ? explode(',',$template->stage_etmp_cust_cc):'',
                        'cust_bcc' => $template->stage_etmp_cust_bcc !=='' ? explode(',',$template->stage_etmp_cust_bcc):'',
                        'reply_to' => $reply_to,
                        'subject' => $subject,
                        'content' => $body,
                        'invite_templates' => $all_templates,
                        'attch_file_html' => (isset($template->attch_file_html)?$template->attch_file_html:''),
                        'user_info' => $user_info
                    );
                if($template_action == 'reinvitation')
                {
                    $data['disable_tmpl_select'] = true;
                }

                }

				$content = '';
				$return_arr = array();
                if($template_action == 'invitation' || $template_action == 'reinvitation')
				{
                    $data['enable_attachments'] = TRUE;
                    $data['enable_inventory_files'] = FALSE;
                }
                $show_discard_btn = FALSE;
                if(isset($article_notification) && !empty($article_notification)){
                    $show_discard_btn = TRUE;
                }
                if ($template_view == 'y')
				{
					$content =  $data;
				}
                else{
                    $data['template_action'] = $template_action;
                    $confirm_msg = "";
                    $title = '';
                    $btn_id = '';
                    $btn_name = '';
                    $btn_text = 'Send';
                    $confirm_msg = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
                    if ($template_action == 'uninvite')
                    {
                        $title = 'Uninvite user';
                        $btn_id = 'btn_send_uninvitation';
                        $btn_name = 'btn_send_uninvitation';
                        $show_discard_btn = FALSE;
                    }elseif($template_action == 'unassign' && $article_details->art_proposal_method == 'assign')
					{
						$title = 'Unassign user';
                        $btn_id = 'btn_send_uninvitation';
                        $btn_name = 'btn_send_uninvitation';
                        $show_discard_btn = FALSE;
					}

                    elseif($template_action == 'invitation' || $template_action == 'reinvitation')
                    {
						if($article_details->art_proposal_method == 'assign')
						$title = 'Assign user';
						else
                        $title = 'Invite user';

                        if($template_action == 'reinvitation')
                            $title = 'Reinvite user';
                        $btn_id = 'btn_send_invitation';
                        $btn_name = 'btn_send_invitation';
                    }
                    $form_id = "form_invite_email_preview";
                    $form_name = "form_invite_email_preview";
                    $stage_name = "";

                    $data['form_name'] = $form_name;
                    $data['form_id'] = $form_id;
                    $data['btn_id'] = $btn_id;
                    $data['btn_name'] = $btn_name;
                    $data['btn_text'] = $btn_text;
                    $data['btn_confirm_msg'] = $confirm_msg;
                    if(isset($article_notification) && !empty($article_notification)){
                        $data['show_discard_btn'] = $show_discard_btn;
                    }
                    $data['stage_name'] = $stage_name;
                    $data['title'] = $title;
                    $data['hold'] = '';
                    $content =$data;
                }
                $return_arr['status'] = 'success';
                $return_arr['msg'] = 'success';
                $return_arr['template_view'] = $template_view;
                $return_arr['content'] = $content;
                $return_arr['show_discard_btn'] = $show_discard_btn;

			}
			$return_arr['email_data'] = (isset($data)) ? $data : null;
			$return_arr['upload_file_size_config']=$this->get_uploaded_file_size_config();
			return $this->success('success',200,$return_arr);
		}
		catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	public function get_email_without_reviewer_popup(Request $request)
    {
		try {
			$this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'article_details.art_id' => 'required',
				'jnl_id' => 'required',
				'jnl_code' => 'required',
				'core_role' => 'required',

			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}

			$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlcodearray = array('input'=>$post_data['jnl_code']);
			$corerolearray = array('input'=>$post_data['core_role']);

			$jnlidvalidation= $this->Rv_validator($jnlidarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
			$corerolevalidation= $this->Rv_validator($corerolearray);

			if($jnlidvalidation != TRUE || $jnlcodevalidation != TRUE || $corerolevalidation !=TRUE){
				return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}

			$article_details=$post_data['article_details'];
            $article_id = $article_details['art_id'];
			$jnl_code = isset($post_data['jnl_code']) ? $post_data['jnl_code']: '';
			$jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
			$current_flow_id = isset($post_data['current_flow_id']) ? $post_data['current_flow_id'] : '';
			$invited_reviewers_list = isset($post_data['invited_reviewers_list']) ? $post_data['invited_reviewers_list'] : '';
			$User_to_journals= new \App\Models\User_to_journals();
			$Stage_email_templates = new \App\Models\Stage_email_templates();
			$Users=new \App\Models\User();
			$Roles=new \App\Models\Roles();
			$user_info = '';
            $user_id = array();
            $all_templates = array();
                $condition = "stage_etmp_stage_type='{$article_details['jwf_stage_type']}' and setr_jwf_id={$article_details['jwf_id']} and stage_etmp_action='unassign_user'";
                $email_templates = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_id, stage_etmp_name', $condition);

                if (empty($email_templates))
                {
                    $return_data['status'] = 'tmpl_err';
                    $return_data['msg'] = customTrans('viewarticle.undefined_template');
                    return $this->warning('Warning', 200, $return_data);
                }
                foreach ($email_templates as $email_key => $email_value)
                {
                    $encrpt_id = encrypt_link($email_value->stage_etmp_id);
                    $email_value->encrpt_id = $encrpt_id;
                }
                if (isset($post_data['stage_etmp_id']) && $post_data['stage_etmp_id'] != "")
                {
                    $condition.="stage_etmp_id=".$this->decrypt_data($post_data['stage_etmp_id']);
                }
                $template = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
                $all_templates = $template;
				$usercount ='';
              if (count($template)>0)
                {
                    $template = $template[0];

                    $email_data = new stdClass;
					$email_data->aflw_id = $current_flow_id;
					$email_data->article_id = $article_id;
                    $email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_id, 'a');
                    $email_data->artp_id = $article_details['art_artp_id'];
                    $email_data->jnl_id = $jnl_id;
                    $email_data->jnl_journal_code = $jnl_code;
                    $email_data->email_templates_config = $this->email_templates_config();
                    if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                        $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

					$user_titles =  $this->UserConfigdata('titles')['titles'];
                    $preview_recipient = FALSE;
                    if ((count($invited_reviewers_list) == 1))
                    {

                        $preview_recipient = TRUE;
                        $reviewer_id = $invited_reviewers_list[0]['aflw_usr_id'];
                        $reviewer = $Users::get_single_record('usr_id,usr_image,usr_title,usr_username,usr_first_name,usr_last_name,usr_email',"usr_id={$reviewer_id}");
                        $email_data->user_name = $reviewer->usr_username;
                        $email_data->name = $reviewer->usr_first_name . ' ' . $reviewer->usr_last_name;
                        $email_data->user_email = $reviewer->usr_email;
                        $email_data->user_id = $reviewer_id;
                        $reviewer->user_titles =$this->UserConfigdata('titles')['titles'];
                        $reviewer->modal_title = 'Email preview';
						$array_data['user_id']=$reviewer_id;
						$array_data['salutation']=TRUE;
						$array_data['fullname_only']=TRUE;
                                            $reviewer->full_name = $this->get_user_display_name($array_data);
                        $user_info =  $reviewer;
                        $usercount =  'single';
						$user_id[] = encrypt_link($reviewer_id);
                    }
                    else
                    {
                        $preview_recipient = FALSE;
						$optvalue = array();
						for($i=0;$i<count($invited_reviewers_list);$i++)
						{
							$user_id[] = encrypt_link($invited_reviewers_list[$i]['aflw_usr_id']);
							$uid=$invited_reviewers_list[$i]['aflw_usr_id'];
							$user = $Users::get_single_record('usr_title,usr_first_name,usr_last_name,usr_email',"usr_id={$uid}");
							$displayarray=array();
							$displayarray['user_id']=$uid;
							$displayarray['salutation']=TRUE;
							$displayarray['fullname_only']=TRUE;
							$displayarray['journal_id']=$jnl_id;
							$user->full_name = $this->get_user_display_name($displayarray);
							array_push($optvalue, $user);
						}
						$user_info = $optvalue;
						$usercount ='multiple';
                    }

                     $body = $this->generate_email_data_from_keys($email_data, $template->stage_etmp_content,  $this->current_user, $user_titles, $preview_recipient);
                 $subject = $this->generate_email_data_from_keys($email_data, $template->stage_etmp_subject,$this->current_user, $user_titles, $preview_recipient);
				 preg_match_all('/##([^##]*)##/', $body, $matches);
				 $keys = $matches[1];

				 for ($i = 0; $i < count($keys); $i++) {
					$element = $keys[$i];
					if(!empty($element))
					{
					$tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
					$body = $tmpl_data;
					}
				 }
				 $reply_to=$this->get_reply_to_email($jnl_id);

                    //Bug #1809 : JPR-260 Remove options for cc and bcc roles in invitation email
                $to_cc_arr = json_decode($template->stage_etmp_cc);
                    $to_bcc_arr = json_decode($template->stage_etmp_bcc);
                    $cc_roles = array();
                    $bcc_roles = array();
                    $disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;

                        if ((!empty($to_cc_arr) && count(array_diff($to_cc_arr, array(
                                'Custo_cc'))) >= 1) || (!empty($to_bcc_arr) && count(array_diff($to_bcc_arr, array(
                                'Custom_bcc'))) >= 1))
                        {

                            $role_cond = 'role_assigned_role NOT IN ("system", "author","reviewer")';
                            if(isset($reviewflow['stage_for']))
                            {
                                if($reviewflow['stage_for'] == 'review')
                                    $role_cond.=' and FIND_IN_SET("r", role_used_in)';
                                elseif($reviewflow['stage_for'] == 'manageproduction')
                                    $role_cond.=' and FIND_IN_SET("p", role_used_in)';
                            }

                            $user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                            if (!empty($user_roles))
                            {
                                foreach ($user_roles as $usrole)
                                {
                                    $role_label = "All " . strtolower($usrole->role_name) . "s";
                                    $cc_roles[$usrole->role_name] = $role_label;
                                    $bcc_roles[$usrole->role_name] = $role_label;
                                }
                            }
                        }
                        $bcc_roles['Custom_bcc'] = 'Specific email ID';
                        $cc_roles['Custom_cc'] = 'Specific email ID';
                   		$usr_ids = join(',', $user_id);

                 $data = array(
                        'status' => 'success',
                        'cc_roles' => $cc_roles,
                        'bcc_roles' => $bcc_roles,
                        'user_ids' => $usr_ids,
                        'aflw_id' => $current_flow_id,
                        'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
                        'to_cc' => $to_cc_arr,
                        'to_bcc' => $to_bcc_arr,
                        'cust_cc' => $template->stage_etmp_cust_cc,
                        'cust_bcc' => $template->stage_etmp_cust_bcc,
                        'reply_to' => $reply_to,
                        'subject' => $subject,
                        'content' => $body,
                        'invite_templates' => $all_templates,
                        'template_action' => 'unassign',
                        'user_info' => $user_info);
					 $btn_id = 'btn_unassgn_rvr';
                    $btn_name = 'btn_unassgn_rvr';
                    $form_name = 'form_preview_unassgn';
                    $form_id = 'form_preview_unassgn';
                    $btn_text = 'Proceed without review ';
                    $data['btn_id'] = $btn_id;
                    $data['title'] = 'Unassign user';
                    $data['hold'] = 'skip';
                    $data['form_name'] = $form_name;
                    $data['form_id'] = $form_id;
                    $data['btn_name'] = $btn_name;
                    $data['btn_text'] = $btn_text;
                    $data['btn_name'] = $btn_name;
                    $data['usercount'] = $usercount;
					$return_data = array(
                        'status' => 'success',
                        'msg' => 'success',
                        'content' => $data
                    );

               }
			   else{
			   $return_data = array(
				'title' =>'Unassign user',
				'status' => 'template_err',
				'msg' => 'success',
				'email_template' => 'You have not defined any email templates'			);

			}
			return $this->success('success',200,$return_data);
		}
		catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	public function get_email_info(Request $request)
	{
		try{
		$post_data = $request->all();
		$validator = Validator::make($request->all(), [
			'jnl_code' => 'required',
			'jnl_id' => 'required',
			'core_role' => 'required',
			'email_for' => 'required',
			'flow' => 'required',
			'art' => 'required',
			'type' => 'required',
			'id' => 'required',
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}

		$post_data['art'] = is_array($post_data['art']) ? array_keys($post_data['art'])[0] : $post_data['art'];

		$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
		$idarray = array('input'=>$post_data['id'],'type'=>'number', 'enc_data'=>TRUE );
		$artarray = array('input'=>$post_data['art'],'type'=>'number', 'enc_data'=>TRUE );
		$jnlcodearray = array('input'=>$post_data['jnl_code']);
		$emailforarray = array('input'=>$post_data['email_for']);
		$corerolearray = array('input'=>$post_data['core_role']);
		$typearray = array('input'=>$post_data['type']);

		$jnlidvalidation= $this->Rv_validator($jnlidarray);
		$idvalidation= $this->Rv_validator($idarray);
		$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
		$emailforvalidation= $this->Rv_validator($emailforarray);
		$corerolevalidation= $this->Rv_validator($corerolearray);
		$artvalidation= $this->Rv_validator($artarray);
		$typevalidation= $this->Rv_validator($typearray);

		if($jnlidvalidation != TRUE || $idvalidation != TRUE || $jnlcodevalidation != TRUE || $emailforvalidation !=TRUE || $corerolevalidation !=TRUE || $artvalidation !=TRUE || $typevalidation !=TRUE){
			return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
		}


		$this->current_user = $this->get_current_user_details();
		$tmpl_id = decrypt_link($post_data['id']);
		$setr_id =  isset($post_data['setr_id'])?decrypt_link($post_data['setr_id']):'';
		$event_emtp_id = isset($post_data['event_tmp_id'])?decrypt_link($post_data['event_tmp_id']):'';
		$type =$post_data['type'];
		$art_id =  decrypt_link($post_data['art']);
		$aflw_id = decrypt_link($post_data['flow']);
		$email_for = $post_data['email_for'];
		$source = isset( $post_data['source'])?$post_data['source']:'';
		$stage_id =(isset($post_data['stage_id'])&&$post_data['stage_id']!='')?decrypt_link($post_data['stage_id']):'';
		$is_event_email = isset($post_data['event_temp'])?$post_data['event_temp']:'';
		$return = array();
		$show_attachments = FALSE;
		$show_preview=($type == 'preview')?TRUE:FALSE;
		$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
		$review_flow = Config::get($workflow_config);
		$Articles = new \App\Models\Articles;
		$Article_flow = (new \App\Models\Article_flow);
        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
		$Stage_email_templates= new \App\Models\Stage_email_templates();
		$Article_notification_emails = new \App\Models\Article_notification_emails;
		$Roles=new \App\Models\Roles();
		$Generic_flows=new \App\Models\Generic_flows();
		$Email_templates = new \App\Models\Email_templates;
		$Generic_form_files = new \App\Models\Generic_form_files;
		$Email_attachments = new \App\Models\Email_attachments;
		$jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
		$jnl_code = isset($post_data['jnl_code']) ? $post_data['jnl_code']: '';
		$select = 'art_id, art_title, artp_id,artp_article_type, jnl_id, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jnl_journal_code, jwf_role_id, CONCAT(auth_sub.usr_title,  " ", auth_sub.usr_first_name, " ", auth_sub.usr_last_name) AS submitted_author, CONCAT(auth_coresp.usr_title,  " ", auth_coresp.usr_first_name, " ", auth_coresp.usr_last_name) AS coresp_author,aflw_status,aflw_level,art_article_upload_path,aflw_level,art_submitted_by,auth_coresp.usr_id as coresp_author_id,aflw_usr_id,art_proposal_method';
		$decision_stages = array(
			'decision_revision',
			'staff_check',
			'reject',
			'accept');
			$article_details = $Articles::get_article_details($select,"aflw_id={$aflw_id}",NULL,TRUE);

		$article_details = $article_details[0];
		$enable_reply_to = $this->current_client->functionality->cfty_enable_journal_reply_to;
		$intermediate_stage = false;//Task #8327
		if ($email_for == 'initialization' || $email_for == 'decision')
		{
			$prev_sql = 'SELECT aflw_id,aflw_jwf_id FROM ' . $Article_flow_table . ' WHERE aflw_level < ' . $article_details->aflw_level . ' AND aflw_art_id = ' . $art_id . ' ORDER BY  aflw_posted_date desc ,aflw_id DESC LIMIT 1';
			$prev_workflow_details=array();
			$prev_stage_type='';
			$prev_art_flow = $Article_flow::get_records_by_raw_query($prev_sql);
			$prev_jwf_id = (isset($prev_art_flow[0]->aflw_jwf_id)) ? $prev_art_flow[0]->aflw_jwf_id : '';
			if(isset($prev_jwf_id)&&$prev_jwf_id!=''){
			$workflow_id = 'jwf_id=' . $prev_jwf_id;
			$prev_workflow_details = $Generic_flows::get_single_record('jwf_stage_type', $workflow_id);
			$prev_stage_type=(isset($prev_workflow_details)&&isset($prev_workflow_details->jwf_stage_type))?$prev_workflow_details->jwf_stage_type:'';
			}
			$Stage_email_templates = new \App\Models\Stage_email_templates();
			$Article_notification_emails = new \App\Models\Article_notification_emails;
			$Article_flow = (new \App\Models\Article_flow);
			$Generic_flows = new \App\Models\Generic_flows();
			$next_stage_type='';
			if($stage_id)
			{$workflow_id = 'jwf_id=' . $stage_id;
			
			$workflow_details = $Generic_flows::get_single_record('jwf_stage_type', $workflow_id);}
			$stage_type = (isset($workflow_details)&&isset($workflow_details->jwf_stage_type))?$workflow_details->jwf_stage_type:'';
			$cmp_prev_flw_id='';
			$aflw_ids='';
			$general_config = General_ConfigTraits::General_config_data('decision_popup_showstages');
			$decision_poup_show_stage_array = $general_config['decision_popup_showstages'];
			array_push($decision_poup_show_stage_array,'resubmission');
			

			if (!empty($decision_poup_show_stage_array) && (in_array($stage_type, $decision_poup_show_stage_array)) && isset($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage) && ($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage == 'y')) {
				$next_stage_decision_id = $this->get_next_decision_stageid(array($stage_id), allow_multi_stage_return:true);
				$stage_id = $next_stage_decision_id[0];
				$workflow_id = 'jwf_id=' . $stage_id;
			$next_workflow_details = $Generic_flows::get_single_record('jwf_stage_type', $workflow_id);
			$next_stage_type=(isset($next_workflow_details)&&isset($next_workflow_details->jwf_stage_type))?$next_workflow_details->jwf_stage_type:'';
			$intermediate_stage = !($next_stage_type==$stage_type);//Task #8327
			}
			$include_stages=["accept","decision_revision","resubmission"];
			$aflw_ids=$aflw_id;
			if(isset($next_stage_type)&&(in_array($next_stage_type, $include_stages))&&isset($prev_art_flow)&&$prev_stage_type=='post_assessment'){
				$cmp_prev_flw_id = (isset($prev_art_flow[0]->aflw_id)) ? $prev_art_flow[0]->aflw_id : '';
			if ($cmp_prev_flw_id != '')
			{
				$aflw_ids.=',' . $cmp_prev_flw_id ;
			}
					}
				$where = 'ane_stage_etmp_id =' . $tmpl_id . ' AND ane_art_id =' . $art_id ;			
		}
		elseif ($email_for == 'complete')
		{
			$cmp_stage_id = ($stage_id == "") ? $article_details->jwf_id : $stage_id;

			$prev_sql = 'SELECT aflw_id FROM ' . $Article_flow_table . ' WHERE aflw_level < ' . $article_details->aflw_level . ' AND aflw_parent_flow_id is null AND aflw_art_id = ' . $art_id . ' ORDER BY aflw_id DESC LIMIT 1';

			$prev_art_flow = $Article_flow::get_records_by_raw_query($prev_sql);

			$cmp_prev_flw_id = (isset($prev_art_flow[0]->aflw_id)) ? $prev_art_flow[0]->aflw_id : '';
			if ($cmp_prev_flw_id == '')
			{
				$where = ' (ane_stage_etmp_id = ' . $tmpl_id . ' AND ane_art_id = ' . $art_id . ' AND ane_aflw_id = ' . $aflw_id . ' )';
			}
			else
			{
				$where = ' ((ane_stage_etmp_id = ' . $tmpl_id . ' AND ane_art_id = ' . $art_id .  ' AND ane_next_jwf_id = ' . $cmp_stage_id . ' ) OR (ane_stage_etmp_id = ' . $tmpl_id . ' AND ane_art_id = ' . $art_id . ' AND ane_aflw_id = ' . $aflw_id . ' ))';
			}
		}
		elseif ($email_for == 'rescind')
		{
			if ($source == 'source')
			{
				$where = 'ane_stage_etmp_id = ' . $tmpl_id . ' AND ane_art_id = ' . $art_id . ' AND ane_aflw_id = ' . $aflw_id;
			}
			else
			{
				$where = 'ane_stage_etmp_id = ' . $tmpl_id . ' AND ane_art_id = ' . $art_id . ' AND ane_prev_aflw_id = ' . $aflw_id . ' AND ane_next_jwf_id =' . $stage_id;
			}
		}
		else
		{
			$where = 'ane_stage_etmp_id = ' . $tmpl_id . ' AND ane_art_id = ' . $art_id . ' AND ane_aflw_id = ' . $aflw_id;
		}


		$where .= ' AND ane_status != 1 AND( ane_setr_id = 0 OR ane_setr_id = ' . $setr_id . ' )ORDER BY `rvw_article_notification_emails`.`ane_id` DESC';

		if($is_event_email == 'y')
		{
			//TASK #10010 Change Assignment: Assign/Unassign email retains previous edits even after sending. Edits should clear and reset to the default template after each send.
			$where_event =array('ane_event_etmp_id'=>$tmpl_id, 'ane_art_id'=>$art_id, 'ane_aflw_id'=>$aflw_id, 'ane_status' => false );
			$email_template = $Article_notification_emails::get_single_record_with_bind_cond('ane_to AS too ,ane_cust_to AS cust_to,ane_cc AS cc,ane_cust_cc AS cust_cc,ane_bcc AS bcc,ane_cust_bcc AS cust_bcc,ane_subject AS subject,ane_content AS content,ane_stage_etmp_id AS id,ane_template_name AS template,ane_stage_type AS stage_type,ane_id,ane_reply_to AS reply_to,ane_setr_id AS setr_id,ane_action AS stage_etmp_action', $where_event);
			if(!empty($email_template))
			{
				$email_template->stage_type = $article_details->jwf_stage_type;
				$email_template->stage_etmp_action = '';
				$email_template->event_flag = TRUE;
			}
		}
		else
		{
			$email_template = $Article_notification_emails::get_single_record('ane_to AS too ,ane_cust_to AS cust_to,ane_cc AS cc,ane_cust_cc AS cust_cc,ane_bcc AS bcc,ane_cust_bcc AS cust_bcc,ane_subject AS subject,ane_content AS content,ane_stage_etmp_id AS id,ane_template_name AS template,ane_stage_type AS stage_type,ane_id,ane_reply_to AS reply_to,ane_setr_id AS setr_id,ane_action AS stage_etmp_action', $where);
		}

		$modified = FALSE;
		$attachments = array();
		$customform_attachments = array();
		$customform_production_attachments = array();
		$attachments_production=array();
		$publish_stages=array('aop_publish','publish');

		$instant_decision_stages = array(
			'resubmission',
			'revision'
		);

		$next_stage_id = $stage_id;
		$next_stage_types = array();
		$instant_decision_init_mail = FALSE;
		if($next_stage_id !== '' && $email_for == 'initialization')
		{
	  /*Bug#4518 AE cannot review decision letters now end  */
			$next_stage_types = $Generic_flows::get_single_record('jwf_stage_type',"jwf_id={$next_stage_id}");
			if(!empty($next_stage_types))
			{
				if(in_array($next_stage_types->jwf_stage_type,$instant_decision_stages) && ($article_details->jwf_stage_type == 'post_assessment' || $article_details->jwf_stage_type == 'staff_check'))
				{
					$instant_decision_init_mail = TRUE;
				}
			}
		}
		if(isset($email_template->ane_id))
		{
			$attachments	=	$this->get_invite_email_attachments($art_id ,$email_template->ane_id,TRUE);
		}

		if (empty($email_template))
		{
			if($is_event_email !== 'y')
			{
			$email_template = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_name as template,stage_etmp_id as id,stage_etmp_to as too,stage_etmp_cust_to as cust_to,stage_etmp_cc as cc,stage_etmp_cust_cc as cust_cc,stage_etmp_bcc as bcc,stage_etmp_cust_bcc as cust_bcc,stage_etmp_subject as subject,stage_etmp_content as content,stage_etmp_stage_type as stage_type,setr_id,stage_etmp_action',"setr_id={$setr_id}");
			}
			else
			{
				$email_template[0] = $Email_templates::get_single_record('etmp_id as id,etmp_templete_name as template,etmp_notification as too,etmp_cust_to as cust_to,etmp_cc as cc,etmp_cust_cc as cust_cc,etmp_bcc as bcc,etmp_cust_bcc as cust_bcc,etmp_subject as subject,etmp_email_template as content',"etmp_id={$event_emtp_id}");
				$email_template[0]->stage_type = $article_details->jwf_stage_type;
				$email_template[0]->stage_etmp_action = '';
				$email_template[0]->event_flag = TRUE;
			}
			$email_template = isset($email_template[0]) ? $email_template[0] : array();
			$email_template->to = $email_template->too;
			//reply_to start
			$current_status = array();
			$article_flow_table = (new \App\Models\Article_flow);
			if((isset($art_id)&&$art_id !=NULL)&&(isset($aflw_id)&&$aflw_id!=NULL))
			{
			$select = 'jwf_stage_type,jwf_role_id';
			$where ="aflw_art_id={$art_id} AND aflw_id={$aflw_id}";
			$current_status = $article_flow_table::get_generic_flow($select, $where);
			}
			$reply_to=$this->get_reply_to_email($jnl_id,$current_status);
			//reply_to end
			$email_template->reply_to = ($enable_reply_to == 'y') ? $reply_to : '';
			if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
				$email_template->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

			if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y' && (((in_array($article_details->jwf_stage_type, $decision_stages) || $instant_decision_init_mail == TRUE) && ($email_for == "complete" || $email_for=="initialization")) || $email_for == 'decision') && isset($email_template->to) && $email_template->to != 'submitted_reviewers') // TASK #6401 remove attachments for submitted reviewers
			{
				$show_attachments = TRUE;
				$jwf_ids = $Article_flow::get_all_records('DISTINCT(aflw_jwf_id)', 'aflw_art_id = ' . $art_id . ' AND aflw_usr_id IS NOT NULL');


				if (!empty($jwf_ids))
				{
					foreach ($jwf_ids as $jwf)
					{
						$stage_form_result = array();
						$stage_form_result = $Stage_email_templates::get_generic_form_data_files($article_details->art_id, $article_details->jnl_journal_code,$jwf->aflw_jwf_id);


						if (!empty($stage_form_result))
						{

							foreach ($stage_form_result as $stg)
							{
								$file_ids = ($stg->gdata_data != "") ? join(",", array_filter(json_decode($stg->gdata_data))) : '';

								if ($file_ids != "" && isset($article_details->art_article_upload_path))
								{
									$file_details = $Generic_form_files::get_all_records('agf_name,agf_id,agf_file_size', 'agf_id in (' . $file_ids . ')');

									if (!empty($file_details))
									{


										foreach ($file_details as $ft)
										{
											$customform_attachments[$ft->agf_id]['document_size'] = $ft->agf_file_size;
											$customform_attachments[$ft->agf_id]['atmnt_file_name'] = $ft->agf_name;
											$customform_attachments[$ft->agf_id]['path'] = $this->get_upload_path('uploads/' .  $article_details->art_article_upload_path . '/' . $ft->agf_name, true);
											$customform_attachments[$ft->agf_id]['atmnt_id'] = $ft->agf_id;
											$customform_attachments[$ft->agf_id]['art_id'] = $art_id;
											$customform_attachments[$ft->agf_id]['jnl_code'] = $jnl_code;


										}
									}
								}
							}
						}
					}
				}
			}



			if(isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y' && in_array($article_details->jwf_stage_type, $publish_stages) && $email_for == "complete")
			{
				$Production_attachment_files = new \App\Models\Production_attachment_files();
				$Attachment_file_description = new \App\Models\Attachment_file_description();

				$result_pdf = $Attachment_file_description::get_all_records('afdec_id',"afdec_attach_to_author='y'");
				$offprint_pdf_id = '';
				$afdec_id = array();

				if(isset($result_pdf ))
				{
				foreach ($result_pdf as $val) {
				$afdec_id[] = $val->afdec_id ;

				}
				$offprint_pdf_id = implode(',',$afdec_id);
				}
				$Production_attachment_files = $Production_attachment_files::get_all_records('paf_id,paf_file_name,paf_art_id,paf_description_id,paf_document_size',"
				paf_art_id={$art_id} AND paf_description_id IN ($offprint_pdf_id) AND 	paf_aflw_id<{$aflw_id}");
				if (!empty($Production_attachment_files))
					{


						foreach ($Production_attachment_files as $ft)
						{
							$customform_production_attachments[$ft->paf_id]['document_size'] = $ft->paf_document_size;
							$customform_production_attachments[$ft->paf_id]['atmnt_file_name'] = $ft->paf_file_name;
							$customform_production_attachments[$ft->paf_id]['path'] = $this->get_upload_path('uploads/' . $article_details->art_article_upload_path . '/' . $ft->paf_file_name, true);
							$customform_production_attachments[$ft->paf_id]['atmnt_id'] = $ft->paf_id;
							$customform_production_attachments[$ft->paf_id]['art_id'] = $art_id;
							$customform_production_attachments[$ft->paf_id]['jnl_code'] = $jnl_code;

						}
					}
			}
		if(isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y' && in_array($article_details->jwf_stage_type, $publish_stages) && $email_for == "complete")
		{
			$show_attachments = TRUE;
			$author_attachments=$this->previous_author_designated_files($article_details->art_id,$article_details->aflw_id);

		//Fix for parellel stage file showing
		 $base_production_path=$this->get_upload_path(APP_DOC_PATH . $article_details->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/');
		if (!empty($author_attachments))
		{
			foreach ($author_attachments as $fat)
			{
			$attachments_production[$fat->paf_id]['name'] = $fat->paf_file_name;
			$attachments_production[$fat->paf_id]['path'] =$base_production_path .$fat->paf_aflw_id. '/' . $fat->paf_file_name;
			$attachments_production[$fat->paf_id]['flow_id'] = $fat->paf_aflw_id;
			$attachments_production[$fat->paf_id]['id'] = $fat->paf_id;
			}
		}

		}
		}
		else
		{
			$modified = TRUE;
			if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y' && ( ((in_array($article_details->jwf_stage_type, $decision_stages) || $instant_decision_init_mail == TRUE) && ($email_for == "complete" || $email_for=="initialization")) || $email_for == 'decision' ))
			{
				$show_attachments = TRUE;
				$attachments	=	$this->get_invite_email_attachments($art_id ,$email_template->ane_id,TRUE);
			}
					if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y' && ( (in_array($article_details->jwf_stage_type, $publish_stages) && $email_for == "complete") ))
			    {
						$show_attachments = TRUE;
					$attachments_production = $Email_attachments::get_all_records('*',"emat_ane_id={$email_template->ane_id}");
				}
		}


		if ($email_for == "rescind" && $source == 'source')
		{
			$stage_id = "";
		}
		$tot_attachment_sz 	=	0;
		if(count($attachments) > 0) {
			foreach($attachments as $key) {
				$tot_attachment_sz	=	$tot_attachment_sz + $key['document_size'];
			}
		}


		$data['customform_attachments'] =$customform_attachments;
		$data['customform_production_attachments'] =$customform_production_attachments;
		$data['show_attachments'] = $show_attachments;
		$data['stage_id'] = $stage_id;
		$data['source'] = $source;
		$data['email_for'] = $email_for;
		$data['is_modified'] = $modified;
		$data['show_attachments'] = $show_attachments;
		$data['article_id'] = $art_id;
		$data['jnl_code'] = $jnl_code;
		$data['attachments'] = $attachments;
		$data['tot_attachment_sz'] = $tot_attachment_sz;
	    $data['attachments_production'] = $attachments_production;
		$data['title'] = 'Emails';
		$data['tmpl_id'] = $tmpl_id;
		$data['mdl_production'] = $this->current_client->modules->mdl_production;
		$possible_roles = array();
		$cc_roles = array();
		$bcc_roles = array();

		$possible_roles['User'] = 'Stage assigned user';
		$stage_type = $email_template->stage_type;
		if ($intermediate_stage) {
			$email_template->intermediate_stage = $intermediate_stage; //Task #8327
		}
		$reviewflow = $review_flow[$stage_type];
		$stages = array(
			'accept',
			'proof_reading',
			'aop_publish',
			'publish',
			'reject',
			'decision_revision');
		if (in_array($stage_type, $stages) || $email_for != "complete")
		{
			$possible_roles['Author'] = 'Corresponding author';
			//1.Task 664 ICE ReView new stages
			if($stage_type != 'aop_publish' && $stage_type != 'publish')
			{
				$possible_roles['submit_author'] = 'Submitted author';
				$possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
				// $possible_roles['Authors'] = 'All authors in article type';
			}
		}
		if($stage_type == 'staff_check' || $stage_type == 'pre_assessment' || $stage_type == 'post_assessment')
		{
				$possible_roles['submit_author'] = 'Submitted author';
				$possible_roles['Author'] = 'Corresponding author';
				$possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
		}
		$role_used = $this->RolesConfigdata('privileged_user_roles');
        $privileged_roles = $role_used['privileged_user_roles'];
		$role_cond = 'role_assigned_role IN ("' . implode('","', $privileged_roles) . '")';
		if(isset($reviewflow['stage_for']))
		{
			 if($reviewflow['stage_for'] == 'review')
				 $role_cond.=' and FIND_IN_SET("r", role_used_in)';
			 elseif($reviewflow['stage_for'] == 'manageproduction')
				 $role_cond.=' and FIND_IN_SET("p", role_used_in)';
		}
		$user_roles = $Roles::get_all_records('role_name, role_assigned_role', $role_cond);
		if (!empty($user_roles))
		{
			foreach ($user_roles as $usrole)
			{if($usrole->role_name=='Author Services'){
				$role_label = "All " . strtolower($usrole->role_name) ;
			}else{
				$role_label = "All " . strtolower($usrole->role_name) . "s";
			}
				$possible_roles[$usrole->role_name] = $role_label;
				if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
				{
					$cc_roles[$usrole->role_name] = $role_label;
					$bcc_roles[$usrole->role_name] = $role_label;
				}
			}
		}

		$stage_role_id = $article_details->jwf_role_id;
		$jwf_stage_type = $article_details->jwf_stage_type;
		$present_stage_type = $jwf_stage_type;


		if ($stage_id != "" && $email_template->stage_type != 'review' && $email_template->stage_etmp_action != 'unassign_user')
		{
			$next_stage_det = $Generic_flows::get_single_record('jwf_role_id,jwf_stage_type',"jwf_id={$stage_id}");
			$stage_role_id = $next_stage_det->jwf_role_id;
			$jwf_stage_type = $next_stage_det->jwf_stage_type;
		}

		$stage_role = $Roles::get_single_record('role_assigned_role',"role_id={$stage_role_id}");

		if ($stage_role->role_assigned_role == 'author')
		{
			if ($jwf_stage_type != 'resubmission' && $stage_type != 'revision')
			{
				$possible_roles['User'] = 'Submitting author';
				unset($possible_roles['submit_author']);
			}
			else
			{
				$possible_roles['submit_author'] = 'Submitted author';
				//unset($possible_roles['User']);
			}
		}
		if(in_array($stage_type, array('reject', 'accept', 'resubmission')) && ($email_for == "complete" || $email_for == "initialization")){ //TASK #6401 Create a new tag for informing Reviewers about the final decision
			$possible_roles['submitted_reviewers'] = 'All submitted reviewers';

		}
		if($stage_id != '')
			$email_template->stage_id = $stage_id;
		if ($type == 'edit')
		{

			$possible_roles['Custom_to'] = 'Specific email ID';
			$cc_roles['Custom_cc'] = 'Specific email ID';
			$bcc_roles['Custom_bcc'] = 'Specific email ID';
                        //#3691 in edit certain tags (like links, dates etc) no need to replace
                        $email_template->mail_type = 'edit';

                        //#3561 tags should replace in edit email template except recipient tags
                        $email_template =   $this->convert_all_tags_in_mail($email_for,$email_template,$article_details,$show_preview,$jnl_code,$jnl_id );
						if(isset($email_template->too)&&$email_template->too=='Custom')
						{
							$email_template->too='Custom_to';
						}
						if(isset($email_template->to)&&$email_template->to=='Custom')
						{
							$email_template->to='Custom_to';
						}
						preg_match_all('/##([^##]*)##/', $email_template->content, $matches);
            $keys = $matches[1];
				if(isset($email_template->cust_bcc))
				{$email_template->cust_bcc = explode(',', $email_template->cust_bcc);}
				if(isset($email_template->cust_cc))
				{$email_template->cust_cc = explode(',', $email_template->cust_cc);}
				if(isset($email_template->cust_to))
				{$email_template->cust_to = explode(',', $email_template->cust_to);}
            for ($i = 0; $i < count($keys); $i++) {
                $element = $keys[$i];
				if(!empty($element))
				{
                $tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$email_template->content);
				$email_template->content = $tmpl_data;
				}
            }
            $body = str_ireplace('##', '', $email_template->content);
            $body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
            $email_template->content=  str_ireplace('</button></button>','</button>', $body);
			unset($email_template->cfty_unique_hide_control_label_email );
			unset($email_template->email_templates_config );
			unset($email_template->join_config );
			unset($email_template->join_dependency_config );
			unset($email_template->user_role_tags );
			if(empty($email_template->reply_to)){
				//reply_to start
			$current_status = array();
			$article_flow_table = (new \App\Models\Article_flow);
			if((isset($art_id)&&$art_id !=NULL)&&(isset($aflw_id)&&$aflw_id!=NULL))
			{
			$select = 'jwf_stage_type,jwf_role_id';
			$where ="aflw_art_id={$art_id} AND aflw_id={$aflw_id}";
			$current_status = $article_flow_table::get_generic_flow($select, $where);
			}
			$email_template->reply_to=$this->get_reply_to_email($jnl_id,$current_status);
			//reply_to end
			}
			$data['cc_roles'] = $cc_roles;
			$data['bcc_roles'] = $bcc_roles;
			$data['email_template'] = $email_template;
			$data['art_id'] = $art_id;
			$data['aflw_id'] = $aflw_id;
			$data['enable_reply_to'] = $enable_reply_to;
		}
		if ($type == 'preview')
		{
			if($email_template->id == '' && $is_event_email == 'y')
			{
				$email_template->id = $tmpl_id;
			}
			$email_template->to_value = $email_template->too;
			$email_template->to = ($email_template->cust_to != '') ? $email_template->cust_to : $email_template->too;
			$email_template->to =  $email_template->too;
			$custom = array(
				'Custom');
			if ($email_template->bcc != '' && $email_template->bcc != '""')
			{
				$email_template->bcc = join(", ", array_diff(json_decode($email_template->bcc), $custom));
				$email_template->bcc = (isset($bcc_roles[$email_template->bcc])) ? $bcc_roles[$email_template->bcc] : $email_template->bcc;
			}

			if ($email_template->cust_bcc != '')
			{

				$bcc=(str_replace('Custom_bcc,','',$email_template->bcc));
				$email_template->bcc = ($email_template->bcc != '' && $email_template->bcc != '""') ?$bcc . ', ' . $email_template->cust_bcc : $email_template->cust_bcc;
			}
			if ($email_template->cc != '' && $email_template->cc != '""')
			{
				$email_template->cc = join(", ", array_diff(json_decode($email_template->cc), $custom));
				$email_template->cc = (isset($cc_roles[$email_template->cc])) ? $cc_roles[$email_template->cc] : $email_template->cc;
			}
			if ($email_template->cust_cc != '')
			{
				$cc=(str_replace('Custom_cc,','',$email_template->cc));
				$email_template->cc = ($email_template->cc != '' && $email_template->cc != '""') ?$cc. ', '  . $email_template->cust_cc : $email_template->cust_cc;
			}
			if(empty($email_template->reply_to)){
				//reply_to start
			$current_status = array();
			$article_flow_table = (new \App\Models\Article_flow);
			if((isset($art_id)&&$art_id !=NULL)&&(isset($aflw_id)&&$aflw_id!=NULL))
			{
			$select = 'jwf_stage_type,jwf_role_id';
			$where ="aflw_art_id={$art_id} AND aflw_id={$aflw_id}";
			$current_status = $article_flow_table::get_generic_flow($select, $where);
			}
			$email_template->reply_to=$this->get_reply_to_email($jnl_id,$current_status);
			//reply_to end
			}
			$email_template->mail_type = 'preview';
			$return['stage_type'] = $email_template->stage_type;
		}
		if ($type != 'edit' || in_array($stage_type, $stages))
		{
                        //#3561 tags should replace in edit email template except recipient tags
				if(isset($email_template->too) && $email_template->too == 'submitted_reviewers'){
					$show_preview = FALSE;
				} // TASK 6401 show recipient tag in email view.
                $email_template =   $this->convert_all_tags_in_mail($email_for,$email_template,
				$article_details,$show_preview,$jnl_code,$jnl_id );
				$email_template->to = (isset($possible_roles[$email_template->too])) ? $possible_roles[$email_template->too] : $email_template->too;
				if ($email_template->too == "Custom" )
				{
					$email_template->to =$email_template->cust_to;
				}
				if ($email_template->bcc == "[]" || $email_template->bcc == '""')
				{
					$email_template->bcc ='';
				}
				if ($email_template->cc == "[]" || $email_template->cc == '""')
				{
					$email_template->cc ='';
				}
				/* TASK 6401 mail popup tag should not replace*/
				preg_match_all('/##([^##]*)##/', $email_template->content, $matches);
				$keys = $matches[1];
				for ($i = 0; $i < count($keys); $i++) {
					$element = $keys[$i];
					if(!empty($element))
					{
					$tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$email_template->content);
					$email_template->content = $tmpl_data;
					}
				}
				$body = str_ireplace('##', '', $email_template->content);
				$body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
				$email_template->content=  str_ireplace('</button></button>','</button>', $body);
				
			/* end TASK 6401 mail popup tag should not replace*/
			$data['enable_reply_to'] = $enable_reply_to;
			unset($email_template->cfty_unique_hide_control_label_email );
			unset($email_template->email_templates_config );
			unset($email_template->join_config );
			unset($email_template->join_dependency_config );
			unset($email_template->user_role_tags );
			$data['email_template'] = $email_template;
		}
		$decision_to_author = FALSE;
		if($stage_role->role_assigned_role == 'author' && $present_stage_type == 'post_assessment')
		{
			$decision_to_author = TRUE;
		}
		$data['decision_to_author'] = $decision_to_author;
		if ($type == 'edit')
		{

			/*			 * * Bug #1809 - JPR-260 Remove options for cc and bcc roles in invitation email - disable to field for author emails * */
			$auth_roles = array(
				'submit_author',
				'Author',
				'article_authors',
				'Authors');
			$disable_to = ($this->current_client->functionality->cfty_disable_email_cc_bcc_editable == 'y' && in_array($email_template->to, $auth_roles)) ? TRUE : FALSE;
			if (($email_for == 'initialization' || $email_for == 'decision') && $email_template->too == 'User')
			{
				$disable_to = TRUE;
			}

			//for revision stage stage assigned user is not required.
			if ($email_for == 'initialization' && ($stage_type == 'revision' || $stage_type == 'resubmission' ))
			{
				$disable_to = TRUE;
				unset($possible_roles['User']);
			}
            if($email_for == 'complete')
			{
				$disable_to = TRUE;
			}
			if ($disable_to == TRUE)
			{
				/*TASK #6401 send mail to box bug fix */
				// if(isset($email_template->to))
				// {
				// $to = $email_template->to;}
				// else{
					$to = $email_template->too;
				// }
				 /* end TASK #6401  send mail to box bug fix */
				$to_array = array();
				if(isset($possible_roles[$to])){
				$to_array = array(
					$to => $possible_roles[$to]);}

				$possible_roles = array_intersect_key($to_array, $possible_roles);

			}

			if($email_for == 'decision')
			{
				$user_roles_arr=array();
				foreach($auth_roles as $ar=>$val)
				{
					if(isset($possible_roles[$val]))
					{
					$user_roles_arr[$val] = $possible_roles[$val];
					}

				}
				if(!empty($user_roles_arr))
					$possible_roles=$user_roles_arr;
			}
			$data['disable_to'] = $disable_to;
			$data['mailtousers'] = $possible_roles;
			$return['stage_type'] = $email_template->stage_type;
			$return['content'] = $data;
			$return['tmplid'] = $tmpl_id;
		}
		else
		{
			$data['aflw_id'] = $aflw_id;
			$return['content'] = $data;
		}
		$return['upload_file_size_config']=$this->get_uploaded_file_size_config();
        return $this->success("success",200, $return );


	} catch (\Exception $e) {

		return $this->failure('Failed', 500, $e);
	}
	}
	/*
         * #3561 tags should replace in edit email template except recipient tags
         */
        public function convert_all_tags_in_mail($email_for,$email_template,$article_details,$show_preview,$jnl_code,$jnl_id )
        {try{
			$this->current_user=$this->get_current_user_details();
		$Roles=new \App\Models\Roles();
		$User_to_journals= new \App\Models\User_to_journals();
		$Generic_flows=new \App\Models\Generic_flows();
            $email_template->article_title = $article_details->art_title;
            $email_template->article_id = $article_details->art_id;
            $email_template->jnl_journal_code = $jnl_code;
            $email_template->aflw_id = $article_details->aflw_id;
            $email_template->stage_name = $article_details->jwf_stage_name;
            $email_template->status_name = $article_details->jwf_status_name;
            $email_template->artp_id = $article_details->artp_id;
            $email_template->jnl_id = $article_details->jnl_id;
            $email_template->article_type = $article_details->artp_article_type;
            $article_url = URL::to('/').'/'. $this->current_client->platform_type.'/'.  $article_details->jnl_journal_code . '/view-article?' . encrypt_link('&article_id=' . $article_details->art_id . '&status_id=' . $article_details->aflw_id);
            $email_template->article_url = $article_url;
            $email_template->submitted_author = $article_details->submitted_author;
            $email_template->corresponding_author = $article_details->coresp_author;
            $email_template->email_for = $email_for??'';//Task #752 The "User Assign" email preview in the "Change Assignment" section is displaying the wrong recipient.


            if($show_preview == TRUE)
            {
                if($email_template->to == "submit_author" || $email_template->to == "article_authors" || $email_template->to == "Authors")
                {
                        $email_template->user_id = $article_details->art_submitted_by;
                }
                elseif($email_template->to == "Author")
                {
					$Authors = new \App\Models\Authors;
					$article_author_details = $Authors::get_single_record('auth_id,auth_usr_id',"auth_art_id={$article_details->art_id} AND auth_corr_author='y'");
					$email_template->user_id = $article_author_details->auth_usr_id;
                }
                elseif($email_template->to == "journal_admin" || $email_template->to == "editor_in_chief" || $email_template->to == "associate_editor" || $email_template->to == "staff" || $email_template->to == "copy_editor" || $email_template->to == "type_setter" || $email_template->to == "proof_reader" || $email_template->to == "production_manager" || $email_template->to == "tsp")
                {
                        $email_to=$email_template->to;
                        $jnl_roles=$Roles::get_single_record('group_concat(role_id) as role_ids',"role_name='{$email_to}'");
                        $jnl_role_ids=str_replace(";",",",$jnl_roles->role_ids);
                        $condition = 'role_id in ('.$jnl_role_ids.') and jnl_journal_code = "'.$jnl_code.'" and artp_id='.$article_details->artp_id;
                        $to_users=$User_to_journals::get_user_from_jnl('usr_id', $condition);
                        if(!empty($to_users))
                        $email_template->user_id = $to_users[0]->usr_id;
                        else
                                $email_template->user_id ='';
                }
                elseif($email_template->to == "User" && $article_details->aflw_usr_id!=NULL)
                {
                        $email_template->user_id = $article_details->aflw_usr_id;
                }
                else
                        $email_template->user_id = $this->current_user['user_id'];
            }
            else
                $email_template->user_id = $this->current_user['user_id'];

            $current_jnl_date_format = $this->get_platform_date_format($jnl_id);
            $email_template->current_date_for_tag = date($current_jnl_date_format, strtotime(date('d-m-Y')));

            $email_template->email_templates_config = $this->email_templates_config();
            if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                    $email_template->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_template->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
            $email_template->join_config = $this->join_config();
            $email_template->join_dependency_config = $this->join_dependency_config();
            $email_template->user_role_tags = $this->user_role_tags();
            if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                    $email_template->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

			$user_titles =$this->UserConfigdata('titles')['titles'];
            //preview email -- if cfty_manage_on_complete_email = 'y'-- tag didnt pull correctly
			if(isset($email_template->stage_id)&&!empty($email_template->stage_id))
				$stage_id = $email_template->stage_id;
            if ($email_for == 'initialization' && !empty($stage_id) && !isset($email_template->intermediate_stage))//Task #8327
            {
                $wrflw_details = $Generic_flows::get_all_records('jwf_stage_name AS ARTICLE_STAGE_NAME,jwf_status_name AS ARTICLE_STATUS_NAME,jwf_tat_complete',"jwf_id={$stage_id}");
                if (!empty($wrflw_details))
                {
						foreach($wrflw_details as $key => $value){
							$task_due_date = $this->get_due_date_for_article($article_details->art_id, $value->jwf_tat_complete, false);
							// $wrflw_details[$key]->TASK_DUE_DATE = $task_due_date->copy()->format('Y-m-d H:i:s');
							// $remaining_days = $task_due_date->diffInDays(Carbon::now(), false);
							// $wrflw_details[$key]->TASK_REMAINING_DAYS = $remaining_days > 0 ?  $remaining_days : 0;
						}
                        $email_template->article_status_details_for_init = $wrflw_details;
                }
            }

            if (strpos($email_template->content,"OPENING_PARAGRAPH") > 0)
                $email_template->content = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->content);
            $email_template->content = $this->generate_email_data_from_keys($email_template, $email_template->content, $this->current_user, $user_titles,$show_preview,TRUE);
            $email_template->subject = $this->generate_email_data_from_keys($email_template, $email_template->subject,  $this->current_user, $user_titles,$show_preview);

            return $email_template;
		} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
        }

		public function save_email_info(Request $request){
			$post_data = $request->all();
			try{
				DB::beginTransaction();
				if(is_array($post_data['art_id'])){
					unset($post_data['ane_id']);
					$art_ids = $post_data['art_id'] ;
				}else{
					$art_ids = [$post_data['art_id'] => $post_data['aflw_id']];
				}
				foreach($art_ids as $art_id => $flow_id){
					$post_data['art_id'] = $art_id;
					$post_data['aflw_id'] = $flow_id;
					$data = $this->save_email_info_service($post_data);
				}
				DB::commit();
				return $data;
			}
			catch(\Exception $e){
				DB::rollback();
				return $this->failure('Failed', 500, $e);
			}
			
		}
		public function save_email_info_service($post_data)
		{
			try {

				$validator = Validator::make($post_data, [
					'jnl_code' => 'required',
					'jnl_id' => 'required',
					'core_role' => 'required',
					'email_for' => 'required',
					'aflw_id' => 'required',
					'event_flag' => 'required',
					'postdata' => 'required',
					'id' => 'required',
					'art_id' => 'required',
					'postdata.stage_template_content'=>'required',
					'postdata.stage_template_sub'=>'required',
					'postdata.stage_template_to'=>'required',
				]);
				if ($validator->fails()) {
					return $this->failure('Failed', 422, $validator->errors());
				}
				$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
				$jnlcodearray = array('input'=>$post_data['jnl_code']);
				$articleidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
				$aflwidarray = array('input'=>$post_data['aflw_id'],'type'=>'number', 'enc_data'=>TRUE );
				$eventflagarray = array('input'=>$post_data['event_flag'],'type'=>'bflag' );
				$emailforarray = array('input'=>$post_data['email_for']);
				$corerolearray = array('input'=>$post_data['core_role']);

				$jnlidvalidation= $this->Rv_validator($jnlidarray);
				$articleidvalidation= $this->Rv_validator($articleidarray);
				$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
				$aflwidvalidation= $this->Rv_validator($aflwidarray);
				$emailforvalidation= $this->Rv_validator($emailforarray);
				$corerolevalidation= $this->Rv_validator($corerolearray);
				$eventflagvalidation= $this->Rv_validator($eventflagarray);

				if($jnlidvalidation != TRUE || $articleidvalidation != TRUE || $jnlcodevalidation != TRUE || $aflwidvalidation != TRUE || $emailforvalidation != TRUE || $corerolevalidation != TRUE || $eventflagvalidation != TRUE ){
					return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
				}


				$this->current_user = $this->get_current_user_details();
				$jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
				$opttovalue = array();
				if (isset($post_data['postdata']['stage_cust_to'])&&!empty($post_data['postdata']['stage_cust_to'])&&($post_data['postdata']['stage_template_to']=='Custom'||$post_data['postdata']['stage_template_to']=='Custom_to')) {
					$custm_cc = $post_data['postdata']['stage_cust_to'];
					for ($i = 0; $i < count($custm_cc); $i++) {
						$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
						$cust_value = str_replace('\\', '"', $cust_value);
						$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

						array_push($opttovalue, $cust_value);


					}
					$post_data['postdata']['stage_cust_to'] = implode(',', $opttovalue);

				}
				else{
					$post_data['postdata']['stage_cust_to']='';
				}

				$optccvalue = array();
				if (isset($post_data['postdata']['stage_cust_cc'])&&!empty($post_data['postdata']['stage_cust_cc']) && (in_array('Custom_cc',$post_data['postdata']['stage_template_to_cc'])||in_array('Custom',$post_data['postdata']['stage_template_to_cc']))) {
					$custm_cc = $post_data['postdata']['stage_cust_cc'];
					for ($i = 0; $i < count($custm_cc); $i++) {
						$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
						$cust_value = str_replace('\\', '"', $cust_value);
						$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

						array_push($optccvalue, $cust_value);


					}
					$post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);

				}
				else{
					$post_data['postdata']['stage_cust_cc']='';
				}
				$optbccvalue = array();
				if (isset($post_data['postdata']['stage_cust_bcc'])&&!empty($post_data['postdata']['stage_cust_bcc']) && (in_array('Custom_bcc',$post_data['postdata']['stage_template_to_bcc'])||in_array('Custom',$post_data['postdata']['stage_template_to_bcc']))) {
					$custm_bcc = $post_data['postdata']['stage_cust_bcc'];
					for ($i = 0; $i < count($custm_bcc); $i++) {
						$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
						$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
						$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

						array_push($optbccvalue, $cust_bcc_value);

					}
					$post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
				}
				else{
					$post_data['postdata']['stage_cust_bcc']='';
				}
				$this->save_article_email_notification($post_data, 'email');

				$date = date('Y-m-d H:i:s');
				$jset_date_format = $this->get_platform_date_format($jnl_id);
				$date = date($jset_date_format . " H:i", strtotime($date));

				$return = array(
					'status' => 'success',
					'msg' => 'Email updated successfully.',
					'date' => $date,
				);
				return $this->success("Success", 200, $return);

			} catch (\Exception $e) {
				return $this->failure('Failed', 500, $e);
			}
		}
			//#1954 Author designated file attach publish complete stage code start
			public function updatenewName($path, $filename)
			{
				$res = "$path/$filename";
				if (!file_exists($res))
					return $filename;
				$fnameNoExt = pathinfo($filename, PATHINFO_FILENAME);
				$ext = pathinfo($filename, PATHINFO_EXTENSION);

				$i = 1;
				while (file_exists("$path/$fnameNoExt ($i).$ext"))
					$i++;
				return "$fnameNoExt ($i).$ext";
			}
			public function upload_email_attachments(Request $request)
			{
				try {
					$this->current_user=$this->get_current_user_details();
					$Article_notification_emails = new \App\Models\Article_notification_emails;
					$form_data = $request->all();
					$Email_templates = new \App\Models\Email_templates;
					$validator = Validator::make($request->all(), [
						'art_id' => 'required',
						'aflw_id' => 'required'
					]);

					if($validator->fails())
					{
							return  $this->failure('Failed',422,$validator->errors());
					}
					$aflwidarray = array('input'=>$form_data['aflw_id'],'type'=>'number', 'enc_data'=>TRUE );
					$articleidarray = array('input'=>$form_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
					$aflwidvalidation= $this->Rv_validator($aflwidarray);
					$articleidvalidation= $this->Rv_validator($articleidarray);

					if($aflwidvalidation != TRUE || $articleidvalidation != TRUE ){
						return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
					}
					$art_id = isset($form_data['art_id']) ? decrypt_link($form_data['art_id']): '';
					$aflw_id = isset($form_data['aflw_id']) ? decrypt_link($form_data['aflw_id']) : '';
					$stage_etmp_id = (isset($form_data['stage_etmp_id'])&&$form_data['stage_etmp_id'] != "") ? decrypt_link($form_data['stage_etmp_id']) : "";
					$ane_id = (isset($form_data['ane_id'])&&!empty($form_data['ane_id'])) ? $form_data['ane_id'] : '';
					$template =(isset($form_data['template'])&&($form_data['template']!='')&& ($form_data['template']!='undefined'))? $form_data['template']: '';
					$etmp_data ='';
					if($template=='reopen_review'){
					$etmp_data = $Email_templates::get_single_record('*', "etmp_name='reopen_review' AND etmp_notification='User'");
					$stage_etmp_id='';
				}

				if(!empty($ane_id)){
					$update_data['ane_aflw_id'] = $aflw_id;
					$Article_notification_emails::update_record($update_data, "ane_id={$ane_id}", $this->current_user);
				}
					$uploaded_file_details=$this->save_invite_attachments($form_data,$art_id,$aflw_id,NULL,$stage_etmp_id,$etmp_data);
									return  $this->success('Success', 200, $uploaded_file_details);
				} catch (\Exception $e) {
					return $this->failure('Failed', 500, $e);
				}
			}
			public function get_decision_emails(Request $request)
			{
				try {
					$post_data = $request->all();
					$this->current_user = $this->get_current_user_details();
					$stage_id = trim($post_data['stage']);
					$aflw_id = decrypt_link(trim($post_data['curnt_flow_id']));
					$Stage_email_templates = new \App\Models\Stage_email_templates();
					$Article_notification_emails = new \App\Models\Article_notification_emails;
					$Article_flow = (new \App\Models\Article_flow);
					$Generic_flows = new \App\Models\Generic_flows();

					$flow_cond = 'aflw_id=' . $aflw_id;
					$art_details = $Article_flow::get_single_record('aflw_art_id', $flow_cond);
					$article_id = $art_details->aflw_art_id;
					$workflow_id = 'jwf_id=' . $stage_id;
					$workflow_details = $Generic_flows::get_single_record('jwf_stage_type', $workflow_id);
					$stage_type = $workflow_details->jwf_stage_type;
					$decsion_stage_save_emails = array();
					$decision_save_emailids = array();
					$general_config = General_ConfigTraits::General_config_data('decision_popup_showstages');
					$decision_poup_show_stage_array = $general_config['decision_popup_showstages'];
					if (!empty($decision_poup_show_stage_array) && (in_array($stage_type, $decision_poup_show_stage_array)) && isset($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage) && ($this->current_client->functionality->cfty_allow_review_decision_email_for_multiple_stage == 'y')) {
						$next_stage_decision_id = $this->get_next_decision_stageid(array($stage_id), allow_multi_stage_return:true);
						$stage_id = $next_stage_decision_id;
						if ($stage_id == null) {
							$stage_id = trim($post_data['stage']);
						}

						$decsion_stage_save_emails = $this->get_article_saved_email_template_details($article_id, $stage_id);
						if (!empty($decsion_stage_save_emails)) {
							foreach ($decsion_stage_save_emails as $decision_email) {
								$decision_save_emailids[] = $decision_email->stage_etmp_id;
							}
						}
					}
					if(is_array($stage_id)){
						$stage_id = " ('". implode("','",$stage_id) . "')";
					}else{
						$stage_id = " ($stage_id) ";
					}
					$email_to_auth = array(
						'submit_author',
						'Author',
						'Authors',
						'article_authors');
					$eml_to_auth_str = '"' . join('","', $email_to_auth) . '"';
					$dec_condition = 'setr_jwf_id IN' . $stage_id . ' AND ((stage_etmp_action = "completed" AND stage_etmp_stage_type != "reject") OR (stage_etmp_action = "declined" AND stage_etmp_stage_type = "reject"))  AND stage_etmp_to IN (' . $eml_to_auth_str . ')';
					if (!empty($decision_save_emailids)) {
						$template_ids = implode(',', $decision_save_emailids);
						$dec_condition .= ' AND  stage_etmp_id NOT IN(' . $template_ids . ')';
					}
					$decsion_stage_emails = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_id,stage_etmp_name,stage_etmp_subject,setr_id', $dec_condition);
					// dd($decsion_stage_emails);exit;
					if (!empty($decsion_stage_emails)) {
						foreach ($decsion_stage_emails as $dk => $dc) {
							$dec_edited = $Article_notification_emails::get_single_record('ane_to', 'ane_stage_etmp_id = ' . $dc->stage_etmp_id . ' AND ane_art_id = ' . $article_id);

							if (!empty($dec_edited)) {
								if (isset($dec_edited->ane_to) && !in_array($dec_edited->ane_to, $email_to_auth)) {
									unset($decsion_stage_emails[$dk]);
								}
							}
						}
					}
					if(count($decsion_stage_save_emails)==0){
						$decsion_stage_save_emails=array();
					}else{
						$decsion_stage_save_emails = is_array($decsion_stage_save_emails) ? $decsion_stage_save_emails : $decsion_stage_save_emails->toArray();
						// $decsion_stage_save_emails = $$decsion_stage_emails->toArray();
					}
					// print_r($decsion_stage_save_emails);
					$decsion_stage_emails = array_merge($decsion_stage_save_emails, $decsion_stage_emails->toArray());

					if (empty($decsion_stage_emails)) {
						return $this->warning('Failed', 500, 'invalid_data');
					}
					$data['stage_emails'] = $decsion_stage_emails;
					$data['stage_id'] = $stage_id;
					$data['eml_stage_tab_name'] = 'Decision Letter';
					$data['eml_stage_info'] = 'You can edit the decision letter from the list below';
					return $this->success("Success", 200, $data);
				} catch (\Exception $e) {
					return $this->failure('Failed', 500, $e);
				}
			}
			  public function remove_invite_attachments(Request $request)
			{
				try{
					$post_data = $request->all();
					$emat_id=decrypt_link($post_data['atmn_id']);

					$this->current_user = $this->get_current_user_details();
					$Email_attachments = new \App\Models\Email_attachments;

				$rtn_arr  = array(
				'status' => 'failed'
				);
				$attach = $Email_attachments::get_single_record('emat_id,emat_file_name,emat_art_id, IF(emat_document_size IS NULL, 0, emat_document_size) as document_size',"emat_id={$emat_id}");
				if(!empty($attach))
				{
					$path	=	public_path() . "/storage/uploads/email_attachments/{$attach->emat_art_id}/";
						$aws_path="uploads/email_attachments/{$attach->emat_art_id}/";
						$this->remove_fileinfolder($path,$attach->emat_file_name,$aws_path);
				$Email_attachments::delete_records("emat_id={$emat_id}", '', $this->current_user);

					$rtn_arr  = array(
					'status' => 'success'
					);
				}
				return $this->success("Success", 200, $rtn_arr);
			} catch (\Exception $e) {
				return $this->failure('Failed', 500, $e);
			}
			}
			public function adhoc_article_details(Request $request)
			{
				try{
					$post_data = $request->all();
					$Articles = new \App\Models\Articles;
					$validator = Validator::make($request->all(), [
						'art_id' => 'required',

					]);

					if($validator->fails())
					{
							return  $this->failure('Failed',422,$validator->errors());
					}

					$articleidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
					$articleidvalidation= $this->Rv_validator($articleidarray);

					if($articleidvalidation != TRUE ){
						return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
					}
					$article_id= isset($post_data['art_id']) ? decrypt_link($post_data['art_id']): '';
					$jnl_code= isset($post_data['jnl_code']) ? decrypt_link($post_data['jnl_code']): '';
					$platform_data = $this->platform_basic_settings_data($jnl_code);
        			$journal_id = $platform_data->jnl_id;
					$article_data = $Articles::get_article_data($article_id);
					$article_type_id = $article_data->artp_id;

					$article_privilages = $this->article_privilages($article_data, NULL, $jnl_code);
					$user_access=FALSE;
					if ($article_privilages['privilaged'] == TRUE)
					{					$user_access =TRUE;
						if (isset($article_privilages['author'])&& $article_privilages['author'] == TRUE) {
							$user_access = FALSE;
						}

					}
					$adhoc_mail_for_author  =   false;
					$to_users               =   array();

					//fetch all authors included in that article
					$Authors = new \App\Models\Authors();
					$fetch_authors_arr  =   $Authors::get_all_records('auth_usr_id','auth_art_id=:art_id',NULL, NULL,'', NULL, NULL,'ASC',array('art_id'=>$article_id));
					$authors_arr = array_column(json_decode(json_encode($fetch_authors_arr), True), 'auth_usr_id');
					if($article_privilages['author'] == TRUE && (isset($this->current_client->functionality->cfty_enable_adhoc_mail_for_author) && $this->current_client->functionality->cfty_enable_adhoc_mail_for_author == 'y') && (in_array($this->current_user['user_id'], $authors_arr) == TRUE))
					{
					  $adhoc_mail_for_author  =   true;
					}
					if($user_access!=true&&$adhoc_mail_for_author==false)
					{
						return  $this->failure('Unauthorized', 200, 'Unauthorized User');
					}
					$condition = array(
                        'art_id'=>$article_id
                    );
					$article_main_info    =   $Articles::get_all_records_with_bind_cond('art_code,art_title', $condition);
                    $to_users               =   $this->fetch_privileged_users_involved_ina_article($article_id,$article_type_id,$journal_id);
					$retun_array['article_main_info'] = $article_main_info[0];
					$retun_array['to_users'] = $to_users;

						return $this->success("Success", 200, $retun_array);
			} catch (\Exception $e) {
				return $this->failure('Failed', 500, $e);
			}
			}
			public function get_adhoc_info(Request $request)
			{
				try{
				$post_data = $request->all();

				$Users=new \App\Models\User();
				$Articles = new \App\Models\Articles;
				$Adhoc_notification_emails = new \App\Models\Adhoc_notification_emails;
				$Email_attachments = new \App\Models\Email_attachments;
				$Article_flow = (new \App\Models\Article_flow);
				$article_flow_table = (new \App\Models\Article_flow)->getTable();
				$Authors = new \App\Models\Authors;

				$Email_templates = new \App\Models\Email_templates;
				$generic_flow_table = (new \App\Models\Generic_flows())->getTable();

				$Roles = new \App\Models\Roles();
				$this->current_user=$this->get_current_user_details();
				$validator = Validator::make($request->all(), [
					'artid' => 'required',
					'jnl_code' => 'required',
					'jnl_id' => 'required',
					'usr_id' => 'required',

				]);

				if($validator->fails())
				{
						return  $this->failure('Failed',422,$validator->errors());
				}

				$articleidarray = array('input'=>$post_data['artid'],'type'=>'number', 'enc_data'=>TRUE );
				$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
				$useridarray = array('input'=>$post_data['usr_id'],'type'=>'number', 'enc_data'=>TRUE );
				$jnlcodearray = array('input'=>$post_data['jnl_code'],'type'=>'string', 'enc_data'=>TRUE );
				$articleidvalidation= $this->Rv_validator($articleidarray);
				$jnlidvalidation= $this->Rv_validator($jnlidarray);
				$useridvalidation= $this->Rv_validator($useridarray);
				$jnlcodevalidation= $this->Rv_validator($jnlcodearray);

				/*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
				if(isset($post_data['flow_id'])&&$post_data['flow_id']!=''){
					$aflwidarray = array('input'=>$post_data['flow_id'],'type'=>'number', 'enc_data'=>TRUE );
					$aflwidarrayvalidation=$this->Rv_validator($aflwidarray);
					if($aflwidarrayvalidation != TRUE){
						return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
					}
				}
				/* End TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
				if($articleidvalidation != TRUE || $jnlidvalidation != TRUE || $useridvalidation != TRUE || $jnlcodevalidation != TRUE ){
					return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
				}
				$jnlcodevalid = $this->validatecode(array('jnl_code'=>$post_data['jnl_code']),TRUE);
				if($jnlcodevalid['jnl_code'] != TRUE ){
					return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
					exit;
				}
				if(isset($form_data['jnl_id'])){
					$jnlidvalid = $this->validatecode(array('jnl_id'=>$form_data['jnl_id']),false);
					if($jnlidvalid['jnl_id'] != TRUE ){
						return $this->warning("Warning",200,customTrans('viewarticle.invalid_data'),'Warning');
						exit;
					}
				}
				$template_id=isset($post_data["template_id"])?($post_data["template_id"]):"";
				$jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
				$jnl_code = isset($post_data['jnl_code']) ? decrypt_link($post_data['jnl_code']): '';
				$aflw_id = isset($post_data['flow_id']) ? decrypt_link($post_data['flow_id']): '';  //TASK #3755 Modification in adhoc email to load the 'View Article' link with its content.
					$userid = decrypt_link($post_data["usr_id"]);
					$art_id = decrypt_link($post_data["artid"]);

					$article_data = $Articles::get_article_data($art_id);

					$article_privilages = $this->article_privilages($article_data, NULL, $jnl_code);
					$user_access=FALSE;
					if ($article_privilages['privilaged'] == TRUE)
					{					$user_access =TRUE;
						if (isset($article_privilages['author'])&& $article_privilages['author'] == TRUE) {
							$user_access = FALSE;
						}

					}
					$adhoc_mail_for_author  =   false;

					//fetch all authors included in that article
					$Authors = new \App\Models\Authors();
					$fetch_authors_arr  =   $Authors::get_all_records('auth_usr_id','auth_art_id=:art_id',NULL, NULL,'', NULL, NULL,'ASC',array('art_id'=>$art_id));
					/* TASK #3755 flow_id of submission stage should be passed for author mail */
					if (isset($userid) && !empty($userid) && isset($art_id) && !empty($art_id)){
						//checking if the to_user is an author
						$chk_cond="auth_usr_id=:user_id AND auth_art_id=:auth_art_id";
						$chk_arr=array('user_id'=>$userid,
										'auth_art_id'=>$art_id
						);
						$chk_author = $Authors::get_single_record('count(auth_id) as count', $chk_cond,NULL,'',NULL,$chk_arr);
						if(isset($chk_author)){
							$is_author = (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;
							if($is_author == TRUE){
								//fetch flow id of article submission
								$select = 'aflw_id';
								$where_condition = [
									'aflw_art_id' => $art_id,
									'aflw_usr_id' => $userid,
									'jwf_stage_type' => 'author_submission'
								];
								$tables = array(
									'main_table' => $article_flow_table,
									'join_table' => array(
										$generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "left")
									)
								);
								$aflw_id_for_author = $Article_flow ::get_results_using_joins($tables, $select, $where_condition, 'single');
								if(isset($aflw_id_for_author)&& !empty($aflw_id_for_author)){
										$aflw_id=$aflw_id_for_author->aflw_id;
								}
							}
						}
					}
					/* end  TASK #3755 flow_id of submission stage should be passed for author mail  */
					$authors_arr = array_column(json_decode(json_encode($fetch_authors_arr), True), 'auth_usr_id');
					if($article_privilages['author'] == TRUE && (isset($this->current_client->functionality->cfty_enable_adhoc_mail_for_author) && $this->current_client->functionality->cfty_enable_adhoc_mail_for_author == 'y') && (in_array($this->current_user['user_id'], $authors_arr) == TRUE))
					{
					  $adhoc_mail_for_author  =   true;
					}
					if($user_access!=true&&$adhoc_mail_for_author==false)
					{
						return  $this->failure('Unauthorized', 200, 'Unauthorized User');
					}

					if($template_id != "")
					{
						$art_id = decrypt_link($post_data['artid']);
					}
					$user = $Users::get_single_record_with_bind_cond('usr_username,usr_first_name,usr_last_name,usr_email',array('usr_id'=>$userid));
					$array_data['user_id']      = $userid;
					$array_data['article_id']   = $art_id;

					$user->full_name = $this->get_user_display_name($array_data);
					$user->user_titles =$this->UserConfigdata('titles')['titles'];
					$user->modal_title = 'Send Ad hoc Email';
					$user_info = $user;

					$get_article_details = $Articles::get_all_records_with_bind_cond('art_title,art_artp_id',array('art_id'=>$art_id));
					$article_details = $get_article_details[0];
					$article_info = $article_details;

					$tmpl_condition =array('etmp_name'=>'adhoc_email' , 'etmp_notification'=>'User');

					if($template_id != "")
					{
						$tmpl_condition =array('etmp_name'=>'adhoc_email', 'etmp_notification' =>'User','etmp_id'=>$template_id);
					}
					$template = $Email_templates::get_all_records_with_bind_cond('etmp_subject,etmp_email_template,etmp_id,etmp_cc,etmp_bcc,etmp_cust_cc,etmp_cust_bcc,etmp_templete_name,etmp_name,etmp_cust_to,etmp_content_type,etmp_name,etmp_notification',$tmpl_condition);

					if (count($template)>0)
					{
						$email_data = new stdClass;
						/* TASK #3755 flow_id of submission stage should be passed for author mail */
						$email_data->article_id = $art_id;
						/* end  TASK #3755 flow_id of submission stage should be passed for author mail  */
						$email_data->article_title = $article_details->art_title;
						$email_data->user_name = $user->usr_username;
						$email_data->name = $user->usr_first_name . ' ' . $user->usr_last_name;
						$email_data->user_email = $user->usr_email;
						$email_data->user_id = $userid;

						/*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content.*/
						if(!empty($aflw_id)){
							$email_data->aflw_id=$aflw_id;
						}
						/* End TASK #3755 Modification in adhoc email to load the 'View Article' link with its content.*/
						$email_data->artp_id = $article_details->art_artp_id;
						$email_data->jnl_id = $jnl_id;
						$email_data->jnl_journal_code = $jnl_code;
						$email_data->email_templates_config = $this->email_templates_config();
						if($this->current_client->functionality->cfty_article_authors_tag == 'y')
							$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
						$email_data->join_config = $this->join_config();
						$email_data->join_dependency_config = $this->join_dependency_config();
						$email_data->user_role_tags = $this->user_role_tags();
						$email_data->mail_type = 'edit';

						if($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
						$email_data->cfty_unique_hide_control_label_email=$this->current_client->functionality->cfty_unique_hide_control_label_email;
						$tmpl_subject = $template[0]->etmp_subject;
						$tmpl_body = $template[0]->etmp_email_template;
										$tmpl_etmp_id   =   $template[0]->etmp_id;
										$tmpl_cc        =   $template[0]->etmp_cc;
										$tmpl_bcc       =   $template[0]->etmp_bcc;
										$tmpl_cust_cc   =   $template[0]->etmp_cust_cc;
										$tmpl_cust_bcc  =   $template[0]->etmp_cust_bcc;

						$user_titles  =$this->UserConfigdata('titles')['titles'];
						if (strpos($tmpl_body,"OPENING_PARAGRAPH") > 0)
						$tmpl_body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$tmpl_body);

						$body = $this->generate_email_data_from_keys($email_data, $tmpl_body, $this->current_user, $user_titles, TRUE);
						$subject = $this->generate_email_data_from_keys($email_data, $tmpl_subject, $this->current_user, $user_titles, TRUE);

						preg_match_all('/##([^##]*)##/', $body, $matches);
						$keys = $matches[1];
						for ($i = 0; $i < count($keys); $i++) {
						$element = $keys[$i];
							if(!empty($element))
							{
								$tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
								$body = $tmpl_data;
							}
						}
						$body = str_ireplace('##', '', $body);
						$body= str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
						$body= str_ireplace('</button></button>','</button>', $body);
						//reply_to start
						$current_status = array();
						$article_flow_table = (new \App\Models\Article_flow);
						if((isset($art_id)&&$art_id!=NULL)&&(isset($aflw_id)&&$aflw_id!=NULL))
						{
						$select = 'jwf_stage_type,jwf_role_id';
						$where ="aflw_art_id={$art_id} AND aflw_id={$aflw_id}";
						$current_status = $article_flow_table::get_generic_flow($select,$where);
						}
						$reply_to=$this->get_reply_to_email($jnl_id,$current_status);
  						//reply_to end
						$cc_roles = array();
						$bcc_roles = array();
						if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
						{
						$roles = $Roles::get_all_records('role_assigned_role,role_name',"role_assigned_role NOT IN ('system', 'reviewer')");
						if(!empty($roles))
						{
							foreach ($roles as $usrole)
							{
								$role_label = 'All ' . strtolower($usrole->role_name) . 's';
								if($usrole->role_assigned_role == 'author')
									$role_label = 'Corresponding Author';
								$cc_roles[$usrole->role_name] = $role_label;
								$bcc_roles[$usrole->role_name] = $role_label;
							}
						}
						$cc_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
						$bcc_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
						}
						$cc_roles['Custom_cc'] = 'Specific email ID';
					$bcc_roles['Custom_bcc'] = 'Specific email ID';

					$current_user = $this->get_current_user_details();
						$ad_noti	=	$Adhoc_notification_emails::get_single_record_with_bind_cond('ade_id,ade_cc,ade_bcc,ade_cust_cc,ade_cust_bcc,ade_reply_to,ade_subject,ade_content', array('ade_template_id'=>$tmpl_etmp_id,'ade_status'=>'0' ,'ade_from'=>$current_user['user_id'],'ade_usr_id'=>$userid));
						$attachments	=	array();
						$attch_file_html= '';
						$ade_id		=	'';
						if(!empty($ad_noti)){

							$ade_id		=   $ad_noti->ade_id;
												$tmpl_cc        =   $ad_noti->ade_cc;
												$tmpl_bcc       =   $ad_noti->ade_bcc;
												$tmpl_cust_cc   =   $ad_noti->ade_cust_cc;
												$tmpl_cust_bcc  =   $ad_noti->ade_cust_bcc;
												$reply_to       =   $ad_noti->ade_reply_to;
												$subject        =   $ad_noti->ade_subject;
												$body           =   $ad_noti->ade_content;

							$attachments = $Email_attachments::get_all_records('emat_id as ane_id,emat_file_name as ane_name, IF(emat_document_size IS NULL, 0, emat_document_size) as document_size',"emat_ade_id={$ade_id} AND emat_art_id={$art_id}");
							$attch_file_html =$attachments;
						}
										if(isset($tmpl_cc)&&($tmpl_cc != null || $tmpl_cc != '')) {
											$tmpl_cc   =   json_decode($tmpl_cc);
										} else {
											$tmpl_cc = '';
										}
										if(isset($tmpl_bcc)&&($tmpl_bcc != null || $tmpl_bcc != '')) {
											$tmpl_bcc   =   json_decode($tmpl_bcc);
										} else {
											$tmpl_bcc = '';
										}
						//Multiple adhoc emails
						$tot_attachment_sz 	=	0;
						if(count($attachments) > 0) {
							foreach($attachments as $key) {
								$tot_attachment_sz	=	$tot_attachment_sz + $key->document_size;
							}
						}

						$return_arr = array(
							'status' => 'success',
							'cc_roles' => $cc_roles,
							'bcc_roles' => $bcc_roles,
							'temp_id' => $template[0]->etmp_id,
							'to_cc' => $tmpl_cc,
							'to_bcc' => $tmpl_bcc,
							'cust_cc' => $tmpl_cust_cc,
							'cust_bcc' => $tmpl_cust_bcc,
							'disable_cc_bcc_editable' => $this->current_client->functionality->cfty_disable_email_cc_bcc_editable,
							'reply_to' => $reply_to,
							'subject' => $subject,
							'content' => $body,
							'user_info' => $user_info,
							'article_info' => $article_info,
							'attachments' => $attch_file_html,
							'tot_attachment_sz' => $tot_attachment_sz,
							'ade_id' => encrypt_link($ade_id),
							// 'all_templates' => $all_templates
						);

					}
					else
					{
						$return_arr = array(
							'status' => 'template_err',
							'user_info' => $user_info,
							'msg' => 'No email template defined'
						);
					}
					$return_arr['upload_file_size_config']=$this->get_uploaded_file_size_config();
				return $this->success("Success", 200, $return_arr);
			} catch (\Exception $e) {
				return $this->failure('Failed', 500, $e);
			}
		}

	public function send_adhoc_email(Request $request)
	{
		try{
		$post_data =  $request->all();
		$Users=new \App\Models\User();
		$Articles = new \App\Models\Articles;
		/*  TASK #3755 flow_id of submission stage should be passed for author mail  */
		$Article_flow = (new \App\Models\Article_flow);
		$article_flow_table = (new \App\Models\Article_flow)->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		/* end  TASK #3755 flow_id of submission stage should be passed for author mail  */
		$Email_templates = new \App\Models\Email_templates;
		$Authors = new \App\Models\Authors;
		$Adhoc_notification_emails = new \App\Models\Adhoc_notification_emails;
		$Email_attachments = new \App\Models\Email_attachments;
		$this->current_user=$this->get_current_user_details();
		$template = $Email_templates::get_single_record('*',"etmp_name='adhoc_email' AND etmp_notification='User'");
		$article_id = decrypt_link($post_data['art_id']);		
			$current_user	=	$this->current_user['user_id'];
			$form_data=$post_data['postdata'];
			$temp_id= decrypt_link($post_data['template_id']);
			$jnl_id= isset($post_data['jnl_id'])?decrypt_link($post_data['jnl_id']):"";
			$jnl_code= isset($post_data['jnlcode'])?decrypt_link($post_data['jnlcode']):"";
			$validator = Validator::make($request->all(), [
				'art_id' => 'required',
				'jnlcode' => 'required',
				'jnl_id' => 'required',
				'template_id' => 'required',
				'postdata.stage_template_content' => 'required',
				'postdata.stage_template_sub' => 'required',

			]);

			if($validator->fails())
			{
					return  $this->failure('Failed',422,$validator->errors());
			}

			$articleidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
			$templateidarray = array('input'=>$post_data['template_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlcodearray = array('input'=>$post_data['jnlcode'],'type'=>'string', 'enc_data'=>TRUE );
			$articleidvalidation= $this->Rv_validator($articleidarray);
			$jnlidvalidation= $this->Rv_validator($jnlidarray);
			$templateidvalidation= $this->Rv_validator($templateidarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);

			/*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
			if(isset($post_data['art_flow_id'])&&$post_data['art_flow_id']!=''){
				$aflwidarray = array('input'=>$post_data['art_flow_id'],'type'=>'number', 'enc_data'=>TRUE );
				$aflwidarrayvalidation=$this->Rv_validator($aflwidarray);
				if($aflwidarrayvalidation != TRUE){
					return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
				}
			}
			/* End TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
			if($articleidvalidation != TRUE || $jnlidvalidation != TRUE || $templateidvalidation != TRUE || $jnlcodevalidation != TRUE ){
				return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}
			$jnlcodevalid = $this->validatecode(array('jnl_code'=>$post_data['jnlcode']),TRUE);
			if($jnlcodevalid['jnl_code'] != TRUE ){
				$res['msg']=customTrans('viewarticle.invalid_data');
				return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}
			if(isset($post_data['jnl_id'])){
                $jnlidvalid = $this->validatecode(array('jnl_id'=>decrypt_link($post_data['jnl_id'])),false);
                if($jnlidvalid['jnl_id'] != TRUE ){
                    return $this->warning("Warning",200,customTrans('viewarticle.invalid_data'),'Warning');
                }
            }
			$article_data = $Articles::get_article_data($article_id);
			$article_type_id = $article_data->artp_id;
			$aflw_id = isset($post_data['art_flow_id']) ? decrypt_link($post_data['art_flow_id']): '';  //TASK #3755 Modification in adhoc email to load the 'View Article' link with its content

			$aflw_due_date = $Article_flow::get_single_record('aflw_due_date','aflw_id =?',binding_arr:[$aflw_id]);

			$article_privilages = $this->article_privilages($article_data, NULL, $jnl_code);
			$user_access=FALSE;
			if ($article_privilages['privilaged'] == TRUE)
			{					$user_access =TRUE;
				if (isset($article_privilages['author'])&& $article_privilages['author'] == TRUE) {
					$user_access = FALSE;
				}

			}
			$adhoc_mail_for_author  =   false;

			//fetch all authors included in that article
			$Authors = new \App\Models\Authors();
			$fetch_authors_arr  =   $Authors::get_all_records('auth_usr_id','auth_art_id=:art_id',NULL, NULL,'', NULL, NULL,'ASC',array('art_id'=>$article_id));
			/*  TASK #3755 flow_id of submission stage should be passed for author mail  */
			if(isset($post_data['postdata']['user_ids']) && !empty($post_data['postdata']['user_ids'])){
				$selected_user_id = $post_data['postdata']['user_ids'];				
				$chk_cond="auth_usr_id=:user_id AND auth_art_id=:auth_art_id";
				// checking if the to_user is an author
						$chk_arr=array('user_id'=>$selected_user_id,
										'auth_art_id'=>$article_id
						);
						$chk_author = $Authors::get_single_record('count(auth_id) as count', $chk_cond,NULL,'',NULL,$chk_arr);
						if(isset($chk_author)){
							$is_author = (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;
							if($is_author == TRUE){
								//fetching the flow id of article submission.
								$select = 'aflw_id';
								$where_condition = [
									'aflw_art_id' => $article_id,
									'aflw_usr_id' => $selected_user_id,
									'jwf_stage_type' => 'author_submission'
								];
								$tables = array(
									'main_table' => $article_flow_table,
									'join_table' => array(
										$generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "left")
									)
								);
								$aflw_id_for_author = $Article_flow ::get_results_using_joins($tables, $select, $where_condition, 'single');
							if(isset($aflw_id_for_author) && !empty($aflw_id_for_author)){
									$aflw_id=$aflw_id_for_author->aflw_id;
							}
							else{
								//transferred article or revised article 
								if(isset($article_data->art_prev_article_id) && !empty($article_data->art_prev_article_id)){
									$cond = ['art_id' => $article_id];
									//fetching original article id 
									$art_pre_all_ids = Articles::get_single_record_with_bind_cond('art_pre_all_ids',$cond);
									$values_array = explode(',', $art_pre_all_ids->art_pre_all_ids);
								}
							}
						}
					}
				}
				/* end  TASK #3755 flow_id of submission stage should be passed for author mail  */
			$authors_arr = array_column(json_decode(json_encode($fetch_authors_arr), True), 'auth_usr_id');
			if($article_privilages['author'] == TRUE && (isset($this->current_client->functionality->cfty_enable_adhoc_mail_for_author) && $this->current_client->functionality->cfty_enable_adhoc_mail_for_author == 'y') && (in_array($this->current_user['user_id'], $authors_arr) == TRUE))
			{
			  $adhoc_mail_for_author  =   true;
			}
			if($user_access!=true&&$adhoc_mail_for_author==false)
			{
				return  $this->failure('Unauthorized', 200, 'Unauthorized User');
			}
		if ($template != NULL)
		{
			$ade_id = '';
			$subject = $form_data['stage_template_sub'];
			$content = $form_data['stage_template_content'];
			$user_id = decrypt_link($form_data['to_users']);
			if($form_data['to_users'] != '')
			{	$tousersarray = array('input'=>$form_data['to_users'],'type'=>'number', 'enc_data'=>TRUE );
				$tousersvalidation= $this->Rv_validator($tousersarray);
				if($tousersvalidation != TRUE){
					return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
				}
				$ade_id = decrypt_link($post_data['ade_id']);
			}
			if($post_data['ade_id'] != '')
			{	$adeidarray = array('input'=>$post_data['ade_id'],'type'=>'number', 'enc_data'=>TRUE );
				$adeidvalidation= $this->Rv_validator($adeidarray);
				if($adeidvalidation != TRUE){
					return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
				}
				$ade_id = decrypt_link($post_data['ade_id']);
			}
			/*Task #566 taskboat -Emails should not be sent to users who are designated as "Article blinded for.- bug 3"*/
			$blinded_usr_list = (new Controller)->get_blinded_users($jnl_code, $article_id);
			$blinded_arr = array();
			if(count($blinded_usr_list) > 0) {
				foreach ($blinded_usr_list as $user) {
					$blinded_arr[] = $user->usr_email;
				}
			}
			/*Task #566 taskboat -Emails should not be sent to users who are designated as "Article blinded for.- bug 3"*/
			$optccvalue = array();
			if (isset($form_data['stage_cust_cc'])&&!empty($form_data['stage_cust_cc']) && (in_array('Custom_cc',$form_data['stage_template_to_cc'])||in_array('Custom',$form_data['stage_template_to_cc']))) {
				$custm_cc = $form_data['stage_cust_cc'];
				
				for ($i = 0; $i < count($custm_cc); $i++) {
					$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
					$cust_value = str_replace('\\', '"', $cust_value);
					$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);
					
                    if(!empty($blinded_arr) && in_array($cust_value,$blinded_arr))
                    { 
							continue;  /*Task #566 taskboat -Emails should not be sent to users who are designated as "Article blinded for.- bug 3"*/
                    }
                    else {

					array_push($optccvalue, $cust_value);
					}

				}
				$form_data['stage_cust_cc'] = implode(',', $optccvalue);
			}
			else{
				$form_data['stage_cust_cc']='';
			}
			
			$optbccvalue = array();
			if (isset($form_data['stage_cust_bcc'])&&!empty($form_data['stage_cust_bcc']) && (in_array('Custom_bcc',$form_data['stage_template_to_bcc'])||in_array('Custom',$form_data['stage_template_to_bcc']))) {
				$custm_bcc = $form_data['stage_cust_bcc'];
				for ($i = 0; $i < count($custm_bcc); $i++) {
					$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
					$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
					$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

					if(!empty($blinded_arr) && in_array($cust_bcc_value,$blinded_arr))
                    { 
                            continue;   /*Task #566 taskboat -Emails should not be sent to users who are designated as "Article blinded for.- bug 3"*/
                    }else
					{
					array_push($optbccvalue, $cust_bcc_value);
					}
				}
                 

				$form_data['stage_cust_bcc'] = implode(',', $optbccvalue);
			}
			else{
				$form_data['stage_cust_bcc']='';
			}
			//#357 to encode attachment array to json to store in email attachment table
			$attachments	=	array();
                        //#357 stores the attachments with path
                        $files_attached =       array();
                        $email_attachments =       array();
						$adhoc_notification = $Adhoc_notification_emails::get_all_records('ade_id',
						"ade_template_id={$temp_id} and ade_art_id={$article_id} AND ade_status = 0");
						foreach ($adhoc_notification as $adhoc_notification) {
						$email_attachments    =    $Email_attachments::get_all_records('*', "emat_ade_id ={$adhoc_notification->ade_id} AND emat_art_id ={$article_id}");
						}
						if ($this->current_client->enable_upload_s3_bucket == 'y') {
							$mainpath="uploads/adhoc_attachments/".$current_user.'/'.$user_id;
						}
						else
						{
							$mainpath='adhoc_attachments/'.$current_user.'/'.$user_id;
						}
						if (!empty($email_attachments)) {

								$attach_mod = $attachments = $files_attached = array();
								foreach ($email_attachments as $att) {
									$attach_mod[$att->emat_id]  = $att->emat_file_name;
									$path             =    $mainpath. '/' . $att->emat_file_name;

									$full_file_path   =    $this->get_upload_path($path ,TRUE);							
									$files_attached[$att->emat_file_name]   =   $full_file_path;
								}
							if(!empty($attach_mod) && (count($attach_mod) > 0)){
								$attachments['article'] = $attach_mod;
							}
							$attachments        =   !empty($attachments) && (count($attachments) > 0) ? json_encode($attachments) : NULL;
			}


			$user_record = $Users::get_single_record('usr_email',"usr_id={$user_id}");
			$article_data = $Articles::get_single_record('*', "art_id={$article_id}");
			$email_data = new stdClass;
			//#357 added attachments in email_data array
			$email_data->ade_id = $ade_id;
			$email_data->attachments = !empty($attachments) ? $attachments : NULL;
			if (!empty($files_attached))
			{
				$email_data->files_attached = $files_attached;
			}
			/*  TASK #3755 flow_id of submission stage should be passed for author mail  */
			$email_data->article_id = $article_id;
			//TASK #5042 When a user sends an adhoc mail, it does not indicate that it is an adhoc mail in the timeline or email log.
			$email_data->esl_etmp_action = 'adhoc';
			$email_data->adhoc_action = TRUE;
			/* end TASK #3755 flow_id of submission stage should be passed for author mail  */
			$email_data->user_id = $user_id;
			$email_data->user_email = $user_record->usr_email;
			$email_data->mail_recipient_ids = $user_id;
			$email_data->jnl_id = $jnl_id;
			/*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
			if(!empty($aflw_id)){
				$email_data->aflw_id=$aflw_id;
			}
			/* End TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
			$email_data->jnl_journal_code = $jnl_code;
			$email_data->artp_id = $article_data->art_artp_id;
			$email_data->subject = $subject;
			$replace_button = array('<button contenteditable="false">', '</button>');
			$content = str_replace($replace_button, '##', $content);
			$email_data->body = $content;
			$email_data->email_templates_config = $this->email_templates_config();
			if($this->current_client->functionality->cfty_article_authors_tag == 'y')
					$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
			
			$email_data->join_config = $this->join_config();
			$email_data->join_dependency_config = $this->join_dependency_config();
			$email_data->user_role_tags = $this->user_role_tags();
			if (isset($aflw_due_date->aflw_due_date)) {
				$date_format = $this->get_platform_date_format($jnl_id);
				$email_data->aflw_due_date = date($date_format,strtotime($aflw_due_date->aflw_due_date));
			}
			$email_data->mail_type = 'send';
			$email_data->body = $this->generate_email_data_from_keys($email_data,$content,$this->current_user);

			$email_data->reply_to = $form_data['stage_template_to_mail'];
			$email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
			$template->etmp_cc = $template->etmp_bcc = '';
			$template->etmp_cust_cc = $template->etmp_cust_bcc = '';
			if(!empty($form_data['stage_template_to_cc']))
			{
				$template->etmp_cc =json_encode($form_data['stage_template_to_cc']);
				if(in_array('Custom_cc', $form_data['stage_template_to_cc'])||in_array('Custom', $form_data['stage_template_to_cc']))
					$template->etmp_cust_cc = trim($form_data['stage_cust_cc']);
			}
			if(!empty($form_data['stage_template_to_bcc']))
			{
				$template->etmp_bcc =json_encode($form_data['stage_template_to_bcc']);
				if(in_array('Custom_bcc', $form_data['stage_template_to_bcc'])||in_array('Custom', $form_data['stage_template_to_bcc']))
					$template->etmp_cust_bcc = trim($form_data['stage_cust_bcc']);
			}

			if(!empty($post_data['core_role']))
			{
			$email_data->core_role = decrypt_link($post_data['core_role']);
			$email_data->core_role_name = decrypt_link($post_data['role_name']);
			}
			
            $batch_id = $this->send_email_notification($template, $email_data, $this->current_user, 'etmp_',true);
			if($batch_id != FALSE)
			{
				if($ade_id != '')
				{
					$adhoc_notify_condition ="ade_id={$ade_id}";
				}
				else
				{
					$adhoc_notify_condition ="ade_art_id={$article_id} AND ade_template_id={$temp_id} AND ade_from={$current_user} AND ade_status='0' AND ade_to='{$user_record->usr_email}'";
				}

				$Adhoc_notification_emails::update_record(array(
					'ade_status' => 1,
					'ade_esl_batch_id' => $batch_id
					), $adhoc_notify_condition,$this->current_user);
			}
			$return_data = array(
				"status" => "success",
				"msg" => "Email sent");
		}
		return $this->success("Success", 200, $return_data);
	} catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}
	}
	 /*
	* Get the email details and set the details into the editable email form for resent/forward
	*/
	public function get_timeline_mail_details(Request $request)
	{
		try{
		$post_data =  $request->all();
		$validator = Validator::make($request->all(), [
			'article_id' => 'required',
			'jnl_code' => 'required',
			'flow_id' => 'required',
			'table_name'=>'required',
            'tbk_id'=>'required',
            'jnl_id'=>'required',
		]);

		if($validator->fails())
		{
				return  $this->failure('Failed',422,$validator->errors());
		}
		$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
		$jnlcodearray = array('input'=>$post_data['jnl_code']);
		$flowidarray = array('input'=>$post_data['flow_id'],'type'=>'string', 'enc_data'=>TRUE );
		$tablenamearray = array('input'=>$post_data['table_name'],'type'=>'string', 'enc_data'=>TRUE );
		$articleidarray = array('input'=>$post_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
		$tbkidarray = array('input'=>$post_data['tbk_id'],'type'=>'number', 'enc_data'=>TRUE );
		$mail_type = $post_data['mail_type_id'] ? TRUE:FALSE; 


		$tablenamevalidation= $this->Rv_validator($tablenamearray);
		$flowidvalidation= $this->Rv_validator($flowidarray);
		$jnlidvalidation= $this->Rv_validator($jnlidarray);
		$articleidvalidation= $this->Rv_validator($articleidarray);
		$tbkidvalidation= $this->Rv_validator($tbkidarray);
		$jnlcodevalidation= $this->Rv_validator($jnlcodearray);

		if($tablenamevalidation != TRUE || $flowidvalidation != TRUE || $jnlidvalidation != TRUE || $articleidvalidation != TRUE || $tbkidvalidation != TRUE || $jnlcodevalidation != TRUE ){
			return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
		}

		$table_name =decrypt_link($post_data['table_name']);
		$batch_id   =decrypt_link($post_data['tbk_id']);
		$jnl_code   =$post_data['jnl_code'];
		$article_id   =decrypt_link($post_data['article_id']);
		$flow_id   =decrypt_link($post_data['flow_id']);
		$array['article_id']=$article_id;
        $array['jnl_code']=$jnl_code;
        $array['current_flow_id']=$flow_id;
        $array['url']=$request->segment(4);
        $user_access=$this->check_permission_access_user($array);
        if($user_access!=true)
        {
            return  $this->failure('Unauthorized', 200, 'Unauthorized User');
        }
		if ($table_name === 'email_send_log')
		{
			$Email_send_log = new \App\Models\Email_send_log;
			$Resent_forward_emails_attachments = new \App\Models\Resent_forward_emails_attachments;
			$Email_send_log_table = (new \App\Models\Email_send_log())->getTable();
			$Users_table        =   (new \App\Models\User())->getTable();

			$this->current_user=$this->get_current_user_details();


				$send_mail_details = new stdClass;
				$send_mail_details->details = $Email_send_log::timeline_details($batch_id, $article_id);
				$send_mail_details->journal_code = $jnl_code;
				$tables = array(
					'main_table' => $Email_send_log_table,
					'join_table' => array(
										$Users_table => array($Email_send_log_table . '.esl_user_id', $Users_table . '.usr_id', "left"),
									)
				);

				$criteria ="esl_batch_id={$batch_id} and esl_article_id={$article_id}";
				$select = 'concat_ws(" ", usr_first_name, usr_last_name) AS user_name,esl_to, esl_posted_by, esl_user_id, esl_content, esl_proxy_id,esl_attachments,esl_article_id';
				$email_content = $Resent_forward_emails_attachments::get_results_using_joins($tables, $select, $criteria, 'all');

				if (count($email_content) == 1 && $email_content[0]->esl_posted_by == $email_content[0]->esl_user_id && (empty($email_content[0]->esl_proxy_id) || $email_content[0]->esl_posted_by == $email_content[0]->esl_proxy_id))
						$send_mail_details->posted_user = 'System';
					$attach_row_html =array();
					$tot_attachment_sz 	=	0;
					if(!$mail_type){
				// load attachments for adhoc / stage-wise mails
				$this->load_resent_attachments($batch_id);

				$select_attach = 'rfa_id as ane_id,rfa_esl_batch_id,rfa_attachment_path,rfa_file_name as ane_name, IF(rfa_document_size IS NULL, 0, rfa_document_size) as document_size';
				$get_attach = $this->get_resent_attachment($select_attach,$batch_id,$post_data['deletedAttachments']);

				$attach_row_html = $get_attach;
				$tot_attachment_sz 	=	0;
				if(count($attach_row_html) > 0) {
					foreach($attach_row_html as $key) {
						$tot_attachment_sz	=	$tot_attachment_sz + $key->document_size;
					}
				}
			}
			if($mail_type){
				$send_mail_details->details->message_body = '';
				$startPos = strpos($send_mail_details->details->to, '[') + 1;
				$endPos = strpos($send_mail_details->details->to, ']');
				$send_mail_details->details->to = substr($send_mail_details->details->to, $startPos, $endPos - $startPos);
				$temp_reply_to = isset($send_mail_details->details->reply_to) ? $send_mail_details->details->reply_to : '';
				$send_mail_details->details->reply_to = isset($send_mail_details->details->to) ? $send_mail_details->details->to : '';
				$send_mail_details->details->to = $temp_reply_to;
		
            }


				$send_mail_details->multiple_recipients = false;
				$email_body         = array();
				$showing_email_for  = array();
				if(count($email_content) > 1)
				{
					$to_emails = array_column(json_decode(json_encode(($email_content)), TRUE), 'esl_to');
					$send_mail_details->multiple_recipients = true;
					$send_mail_details->to_emails    = implode(',',$to_emails);

					foreach($email_content as $eml_cont)
					{
						$esl_user_id = encrypt_link($eml_cont->esl_user_id ? $eml_cont->esl_user_id:$eml_cont->esl_to);
						$esl_user_id = str_replace("~","",$esl_user_id);
						$email_body[$esl_user_id]         = $eml_cont->esl_content;
						$showing_email_for[$esl_user_id]  = ($eml_cont->user_name != null)?$eml_cont->user_name:$eml_cont->esl_to;
					}
				}
				else
				{
					$send_mail_details->to_emails    = $email_content[0]->esl_to;
				}
				$send_mail_details->attach_row_html = $attach_row_html;
				$send_mail_details->tot_attachment_sz = $tot_attachment_sz;
			$send_mail_details->batch_id     = encrypt_link($batch_id);
			$send_mail_details->article_id   = encrypt_link($email_content[0]->esl_article_id);
			$send_mail_details->user_name      = $email_content[0]->user_name;
			$send_mail_details->user_id      = str_replace("~","",encrypt_link($email_content[0]->esl_user_id));
			$send_mail_details->email_body_arr      = $email_body;
			$send_mail_details->showing_email_for   = $showing_email_for;
			if(!empty($ad_noti))
			{
				$send_mail_details->ade_id      = encrypt_link($ad_noti->ade_id);
			}
	 }
		$send_mail_details->upload_file_size_config=$this->get_uploaded_file_size_config();
			return $this->success("Success", 200, $send_mail_details);
		} catch (\Exception $e) {

			return $this->failure('Failed', 500, $e);
		}
	}
	public function resend_forward_mail(Request $request)
	{
			try{
				$post_data =  $request->all();

				$validator = Validator::make($request->all(), [
					'article_id' => 'required',
					'jnlcode' => 'required',
					'flow_id' => 'required',
					'batch_id' => 'required',
					'postdata.resend_mode'=>'required',
					'postdata.stage_template_content'=>'required',
					'postdata.stage_template_sub'=>'required',
				]);
			if($validator->fails())
			{
					return  $this->failure('Failed',422,$validator->errors());
			}
			$jnlcodearray = array('input'=>$post_data['jnlcode']);
			$flowidarray = array('input'=>$post_data['flow_id'],'type'=>'string', 'enc_data'=>TRUE );
			$articleidarray = array('input'=>$post_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
			$batchidarray = array('input'=>$post_data['batch_id'],'type'=>'number', 'enc_data'=>TRUE );
			$resendmodearray = array('input'=>$post_data['postdata']['resend_mode']);

			$flowidvalidation= $this->Rv_validator($flowidarray);
			$articleidvalidation= $this->Rv_validator($articleidarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
			$batchidvalidation= $this->Rv_validator($batchidarray);
			$resendmodevalidation= $this->Rv_validator($resendmodearray);

			if($flowidvalidation != TRUE || $articleidvalidation != TRUE || $jnlcodevalidation != TRUE || $batchidvalidation != TRUE || $resendmodevalidation != TRUE ){
				return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}
		   	$array['article_id']=decrypt_link($post_data['article_id']);
			$array['jnl_code']=$post_data['jnlcode'];
			$array['current_flow_id']=decrypt_link($post_data['flow_id']);
			$array['url']=$request->segment(4);
			$user_access=$this->check_permission_access_user($array);
			if($user_access!=true)
			{
				return  $this->failure('Unauthorized', 200, 'Unauthorized User');
			}


				$batch_id   =decrypt_link($post_data['batch_id']);
				$form_data=$post_data['postdata'];
				$resend_mode = $form_data['resend_mode'];

				$Articles = new \App\Models\Articles;
				$Email_send_log = new \App\Models\Email_send_log;

	
		$email_details = $Email_send_log::get_all_records('esl_id,esl_user_id,esl_article_id,esl_aflw_id,esl_etmp_action,esl_subject,esl_content,esl_to,esl_reply_to,esl_batch_id,esl_attachments,esl_resend_email_id,esl_posted_by,esl_trans_mode',"esl_batch_id={$batch_id}");
		$article_id_arr = array_unique(array_column(json_decode(json_encode($email_details), TRUE), 'esl_article_id')); 
		$article_id = $article_id_arr[0]; 

		$article_data = $Articles::get_article_data($article_id);
		if($resend_mode == 'resend')
		{
			if(count($email_details) > 1)
			{
				//multiple recipients
				$esl_to   = array_column(json_decode(json_encode($email_details), TRUE), 'esl_to');
				$email_detail = $email_details[0];

				/* To check that the mail ids were valid users or merged users , if merged users then replace the mail by master users mail id */
				$email_detail->esl_to = implode(', ', $esl_to);
				$result_data = $this->check_merged_users_mail_id($email_detail->esl_to);
				$email_detail->esl_to = $result_data['esl_to'];
				$email_detail->recipient_ids = $result_data['recipient_ids'];
				
				
				$this->resend_mail_notification($email_detail,$article_data,$post_data,$resend_mode);
			}
			else
			{
				$email_detail = $email_details[0];
				/* To check that the mail ids were valid users or merged users , if merged users then replace the mail by master users mail id */
				$result_data = $this->check_merged_users_mail_id($email_detail->esl_to);
				$email_detail->esl_to = $result_data['esl_to'];
				$email_detail->recipient_ids = $result_data['recipient_ids'];			
				$this->resend_mail_notification($email_detail,$article_data,$post_data,$resend_mode);
			}
			$return['msg'] = 'Mail resent successfully';
		}
		elseif($resend_mode == 'forward')
		{
			$email_detail = $email_details[0];
			$return_data = $this->resend_mail_notification($email_detail,$article_data,$post_data,$resend_mode);
			if($return_data == 'blinded_user')
			{
			   $blnded_msg = 'Unable to forward this email, user is blinded to this article';
			   return  $this->warning('Warning',200,$blnded_msg,'Warning');
			}
			else
			{
			   $return['msg'] = 'Mail forward successfully';
			}
		}
		else if($resend_mode == 'reply_mail')
		{
			$email_detail = $email_details[0];
			if($email_detail->esl_trans_mode == 'r'){
				$temp_reply_to = (isset($email_detail->esl_reply_to) && !empty($email_detail->esl_reply_to)) ? $email_detail->esl_reply_to : '';
				//$email_detail->esl_reply_to = (isset($email_detail->esl_to) && !empty($email_detail->esl_to)) ? $email_detail->esl_to : '';  // Task #206 , Reply-mail, removed this line
				$email_detail->esl_to = $temp_reply_to;
			}
			$this->resend_mail_notification($email_detail,$article_data,$post_data,$resend_mode);
			$return['msg'] = 'Mail replied successfully';
		}
		
		$return['status'] = 'success';
		return $this->success("Success", 200, $return);

		} catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
		}
}
public function resend_mail_notification($email_detail,$article_data,$post_data,$resend_mode)
{
	$Resent_forward_emails_attachments = new \App\Models\Resent_forward_emails_attachments;
	$batch_id = decrypt_link($post_data['batch_id']);
	$batchidarray = array('input'=>$post_data['batch_id'],'type'=>'number', 'enc_data'=>TRUE );
	$batchidvalidation= $this->Rv_validator($batchidarray);
	if($batchidvalidation != TRUE ){
		return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
	}
	$form_data=$post_data['postdata'];
	$this->current_user=$this->get_current_user_details();
	$current_user =$this->current_user['user_id'];
	$email_data = new stdClass;
	$email_data->article_id = $email_detail->esl_article_id;
	$email_data->aflw_id = $email_detail->esl_aflw_id;
	if((isset($email_detail->esl_etmp_action) && !empty($email_detail->esl_etmp_action) && $email_detail->esl_etmp_action == 'adhoc') || (isset($email_detail->esl_etmp_action,$email_detail->esl_aflw_id) && ($email_detail->esl_etmp_action == NULL && $email_detail->esl_aflw_id == NULL)) ){
		$email_data->esl_etmp_action = 'adhoc';
	}else{
		$email_data->esl_etmp_action = $email_detail->esl_etmp_action;
	}
	$email_data->user_id = $email_detail->esl_user_id;
	$email_data->user_email = $email_detail->esl_to;
	$email_data->mail_recipient_ids = (isset($email_detail->recipient_ids))?$email_detail->recipient_ids:$email_detail->esl_user_id;
	if($resend_mode == 'forward')
	{
		$email_data->user_id = NULL;
		$email_data->user_email = $form_data['resend_to'];
		$email_data->mail_recipient_ids = NULL;
		
	}else  if($resend_mode == 'reply_mail'){
		$email_data->user_id = $email_detail->esl_posted_by;
		 // Task #206 , Reply-mail, email send log changes(columns) added
		$email_data->esl_read_status = 'u';
		$email_data->esl_trans_mode = 'r';
		$email_data->esl_rply_source = 's';
		$email_data->esl_rply_mail = TRUE;
		// Task #206 , Reply-mail, parent mail issue fix
		$esl_data = Email_send_log::get_single_record_with_bind_cond('esl_id', array( 'esl_batch_id' => $batch_id ));
		$email_data->esl_rpid = (isset($esl_data->esl_id) && !empty($esl_data->esl_id)) ? $esl_data->esl_id : null;
		$email_data->mail_recipient_ids = (isset($email_detail->recipient_ids))?$email_detail->recipient_ids:$email_detail->esl_posted_by;
	}
	if (!empty($article_data))
	{
			$email_data->jnl_id = $article_data->jnl_id;
			$email_data->jnl_journal_code = $article_data->jnl_journal_code;
			$email_data->artp_id = $article_data->artp_id;
	}
	$email_data->subject = $form_data['stage_template_sub'];
	$email_data->body = $form_data['stage_template_content'];
	if(isset($form_data['content_arr']) && ($resend_mode != 'forward'))
	$email_data->body_arr = $form_data['content_arr'];
	$email_data->email_templates_config = $this->email_templates_config();

	$email_data->reply_to = $form_data['stage_template_to_mail'];
	$email_data->esl_resend_email_id = ($resend_mode != 'reply_mail') ? $email_detail->esl_id : 0;

	$template = new stdClass();
	$template->cust_cc = '';
	$template->cust_to = '';
	$template->cust_bcc = '';
	$files_attached = array();
	if($resend_mode == 'reply_mail'){
		$attachArray = json_decode(json_decode(decrypt_link($form_data['rply_attach'])));
		$select_attach = 'emat_id as rfa_id,emat_file_name as rfa_file_name, IF(emat_document_size IS NULL, 0, emat_document_size) as rfa_document_size';
			$array_attach_id = '';
			if(count($attachArray)>0){
				$array_attach_id = '(' . implode(',', $attachArray) . ')';
				$get_attachments = $this->get_reply_attachment($select_attach,$array_attach_id);
				if(!empty($get_attachments)){
					foreach ($get_attachments as $attachment) {
						$attachment->rfa_attachment_path = public_path() . '/storage/uploads/email_attachments/'.$current_user.'/'.$email_data->user_id.'/receive/'.$attachment->rfa_file_name; // Task #206 , Reply-mail file-path issue fix
					}
				}
			}
	}else{
		$select_attach =  'rfa_id,rfa_attachment_path,rfa_file_name,rfa_document_size';
		$get_attachments = $this->get_resent_attachment($select_attach,$batch_id,$post_data['deletedAttachments']);
	}
	
	if (!empty($get_attachments))
	{
			foreach ($get_attachments as $av)
			{
						if(isset($av->rfa_attachment_path)&&((strpos($av->rfa_attachment_path, '/production/') === false)&&(strpos($av->rfa_attachment_path, '/email_attachments/') === false)))
							$email_data->article_files_attached_ids[$av->rfa_id] = $av->rfa_file_name;
						else
							$email_data->custom_file_ids[$av->rfa_id] = $av->rfa_attachment_path;
						$files_attached[$av->rfa_file_name] = $av->rfa_attachment_path;
						$attach_mod[$av->rfa_id] = $av->rfa_attachment_path;
						$save_attachment[] = array(
							'rfa_article_id'        =>  $email_detail->esl_article_id,
							'rfa_user_id'           =>  $current_user,
							'rfa_document_size'		=>	$av->rfa_document_size,
							'rfa_esl_id'            =>  0,
							'rfa_file_name'         =>  $av->rfa_file_name,
							'rfa_attachment_path'   =>  $av->rfa_attachment_path,
							'rfa_posted_by'         =>  $this->current_user['user_id'],
							'rfa_posted_date'       =>  date('Y-m-d H:i:s'),
							'rfa_proxy_id'       	=>  $this->current_user['proxy_user_id'],
							'rfa_operation'         => 'i',
						);
			}
	}
	if (!empty($files_attached))
	{
			$email_data->files_attached = $files_attached;

			$attachments	=	array();
					if(!empty($attach_mod)){
						$tmp_attach_mod 	=	array();
						foreach ($attach_mod as $idx => $att) {
							if (strpos($att, 'uploads/') !== false)
							{
								$att = str_replace('uploads/', '', $att); // $newString is now 'World'
							}
							$tmp_attach_mod[$idx]             =    $this->get_upload_path($att ,TRUE);
						}
								$attachments['article']	=	$tmp_attach_mod;
							$attachments		=	json_encode($attachments);
						}
			$email_data->attachments = $attachments;
	}
	$core_role=(isset($post_data['core_role']))?$post_data['core_role']:'';
	$email_data->core_role = $core_role;
	$core_role_name=(isset($post_data['role_name']))?$post_data['role_name']:'';
	$email_data->core_role_name = $core_role_name;
	$email_data->is_forwarded = ($resend_mode == 'forward') ? 'y' : 'n';
	$new_batch_id = NULL;
	if(!empty($get_attachments))
	{
		$Batch_id_generate_table = new \App\Models\Batch_id_generate();
		$new_batch_id = $Batch_id_generate_table::insert_batch_id();
		
		// Task #206 , Reply-mail file-path issue fix
		if(isset($save_attachment) && !empty($save_attachment) && $resend_mode != 'reply_mail')
		{
			$save_attachment = array_map(function($e) use($new_batch_id) {
					($e['rfa_esl_batch_id'] = $new_batch_id);
					return($e);
			}, $save_attachment);
			$Resent_forward_emails_attachments::insert_batch($save_attachment);
			$resent_attachments	=	$Resent_forward_emails_attachments::get_all_records('rfa_id,rfa_attachment_path,rfa_file_name,rfa_document_size',"rfa_esl_batch_id={$new_batch_id}");
			if (!empty($resent_attachments))
			{
				$email_data->custom_file_ids = array();
				foreach ($resent_attachments as $ak=>$av)
				{
					$email_data->custom_file_ids[$av->rfa_id] = $av->rfa_attachment_path;
				}
			}
		}
		else{
			foreach ($get_attachments as $av)
			{
				$email_data->custom_file_ids[$av->rfa_id] = $av->rfa_attachment_path;
			}
		}
		$new_batch_id = $this->send_email_notification($template, $email_data, $this->current_user, '',true,null,false,$new_batch_id);
		$esl_attach = ($email_detail->esl_attachments != NULL) ? json_decode($email_detail->esl_attachments, TRUE) : array();
		if(isset($get_attachments) && !empty($get_attachments))
		{
			foreach ($get_attachments as $av)
			{
				if(isset($esl_attach['modified'])&&!empty($esl_attach['modified']))
				{
					if(!in_array($av->rfa_attachment_path,$esl_attach['modified']))
					{
						$delet_data_id = $av->rfa_id;
						$Resent_forward_emails_attachments::delete_records("rfa_id={$delet_data_id}", '', $this->current_user);
					}
				}
				else
				{
					$delet_data_id = $av->rfa_id;
					$Resent_forward_emails_attachments::delete_records("rfa_id={$delet_data_id}", '', $this->current_user);
				}
			}
		}
	}
	else
	{
		$this->send_email_notification($template, $email_data,  $this->current_user, '',true);
	}
	if($new_batch_id != NULL)
	{
		return $new_batch_id;
	}
}
public function upload_resend_email_attachments(Request $request)
{
	try{
		$resend_data =  $request->all();
		$validator = Validator::make($request->all(), [
			'art_id' => 'required',
			'jnl_code' => 'required',
			'flow_id' => 'required',
		]);

	if($validator->fails())
	{
			return  $this->failure('Failed',422,$validator->errors());
	}
			$articleidarray = array('input'=>$resend_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlcodearray = array('input'=>$resend_data['jnl_code']);
			$articleidvalidation= $this->Rv_validator($articleidarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);


		if( $articleidvalidation != TRUE || $jnlcodevalidation != TRUE ){
			return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
		}
		$flowid=decrypt_link($resend_data['flow_id']);
		if(isset($flowid)&&$flowid!='null'){
			$flowidarray = array('input'=>$resend_data['flow_id'],'type'=>'number', 'enc_data'=>TRUE );
			$flowidvalidation= $this->Rv_validator($flowidarray);
			if( $flowidvalidation != TRUE){
				return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}
		}
  	$array['article_id']=decrypt_link($resend_data['art_id']);
	$array['jnl_code']=$resend_data['jnl_code'];
	$array['current_flow_id']=decrypt_link($resend_data['flow_id']);
	$array['url']=$request->segment(4);
	$user_access=$this->check_permission_access_user($array);
	if($user_access!=true)
	{
		return  $this->failure('Unauthorized', 200, 'Unauthorized User');
	}
		$this->current_user = $this->get_current_user_details();
		$current_user	=$this->current_user['user_id'];

		$batch_id   =decrypt_link($resend_data['batch_id']);
		$art_id   =decrypt_link($resend_data['art_id']);

		$Resent_forward_emails_attachments = new \App\Models\Resent_forward_emails_attachments;
		$basic_path		=	'email_attachments/' . $art_id .'/';
		$path			=	APP_DOC_PATH . $basic_path;
		if (!file_exists($path))
		{
			mkdir($path, 0765, TRUE);
		}
		$image =  $resend_data['filename'];
		$name = $image->getClientOriginalName();
		$uploaded_file_details=$this->upload_file_handler('email_attachments/'.$art_id, $image, $name);
				if ($uploaded_file_details && $uploaded_file_details['name'] &&
		isset($uploaded_file_details['error'])&&$uploaded_file_details['error']== FALSE)
	{
		$upld_flsz	=	$this->file_size_convert_to_kb($uploaded_file_details['size']);
		$tot_attachment_sz 	=	0;
		$attachmentz	=	$Resent_forward_emails_attachments::get_all_records('IF(rfa_document_size IS NULL, 0, rfa_document_size) as document_size',"rfa_esl_batch_id={$batch_id}" );
		if(count($attachmentz) > 0) {
			foreach($attachmentz as $key) {
				$tot_attachment_sz	=	$tot_attachment_sz + $key->document_size;
			}
			$tot_attachment_sz	=	$upld_flsz + $tot_attachment_sz;
		}
		else {
			$tot_attachment_sz	=	$upld_flsz;
		}

		$uploaded_file_details['total_size_exceeded'] = false;
		if($tot_attachment_sz > $this::tot_file_upd_sz) {
			$uploaded_file_details['total_size_exceeded'] = true;
		} else {
		$insert_data = array(
			'rfa_article_id'        =>  $art_id,
			'rfa_user_id'           =>  $current_user,
			'rfa_esl_id'            =>  0,
			'rfa_esl_batch_id'      =>  $batch_id,
			'rfa_file_name'         =>  $uploaded_file_details['name'],
			'rfa_document_size'     =>  $upld_flsz,
			'rfa_attachment_path'   =>  $path.$uploaded_file_details['name'],
			'rfa_posted_by'         =>  0,
			'rfa_posted_date'       =>  date('Y-m-d H:i:s'),
			'rfa_operation'         => 'i',
		);
		$Resent_forward_emails_attachments::insert_record($insert_data,$this->current_user);
		}
		if(isset($resend_data['deletedAttachments']) && !empty($resend_data['deletedAttachments'])){
			$resend_data['deletedAttachments'] = explode(',',$resend_data['deletedAttachments']);
		}
		$select_attach = 'rfa_id as ane_id,rfa_file_name as ane_name,rfa_attachment_path, IF(rfa_document_size IS NULL, 0, rfa_document_size) as document_size';
		$attachments = $this->get_resent_attachment($select_attach,$batch_id,$resend_data['deletedAttachments']);

		$attch_file_html	=     $attachments;

		$uploaded_file_details['attch_file_html'] = $attch_file_html;
		$uploaded_file_details['tot_attachment_sz'] = $tot_attachment_sz;
		return  $this->success('Success', 200, $uploaded_file_details);
	}

	}
	catch (\Exception $e) {

	return $this->failure('Failed', 500, $e);
	}
}

public function get_email_attachments($send_mail_details,$email_content,$tbk_id,$art_id)
{
	$attach_row_html = array();
		$Adhoc_notification_emails = new \App\Models\Adhoc_notification_emails;
		$Resent_forward_emails_attachments = new \App\Models\Resent_forward_emails_attachments;
		$Articles = new \App\Models\Articles;
		$get_attch		=	$Resent_forward_emails_attachments::get_all_records('rfa_id as ane_id,rfa_esl_batch_id,rfa_attachment_path,rfa_file_name as ane_name', "rfa_esl_batch_id={$tbk_id}");
		if ($this->current_client->enable_upload_s3_bucket == 'y') {
            $mainpath="uploads/email_attachments/";
        }
        else
        {
            $mainpath="email_attachments/";
        }

	if(empty($get_attch))
	{
		$send_mail_details->adhoc_path = false;
		$ad_noti		=	$Adhoc_notification_emails::get_single_record('ade_id,ade_from',  "ade_esl_batch_id={$tbk_id}");
		if(!empty($ad_noti)) {
				$send_mail_details->adhoc_path = true;
		}
		if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y' && !empty($email_content))
		{
			foreach ($email_content as $eml)
			{
					$esl_attach = ($eml->esl_attachments != NULL) ? json_decode($eml->esl_attachments, TRUE) : array();
				   $email_attach = array();
					if (!empty($esl_attach))
					{
							// fetch adhoc uploaded path
							if(!empty($ad_noti))
							{
									$ade_from	=	$ad_noti->ade_from;
									$ade_to		=	$email_content[0]->esl_user_id;
									$article_path	=  $this->get_upload_path($mainpath . $art_id . '/' . $emat_name,true);
									$modified_path	=	'uploads/adhoc_attachments/'.$ade_from.'/'.$ade_to.'/';
									$send_mail_details->adhoc_path = true;
							}
							else
							{
								$article_details = $Articles::get_single_record('art_article_upload_path,art_id', "art_id={$eml->esl_article_id}");
									$article_path  = 'uploads/' . $article_details->art_article_upload_path . '/' ;
									$modified_path = 'uploads/email_attachments/' . $article_details->art_id . '/';
							}
							if (isset($esl_attach['article']) && !empty($esl_attach['article']))
							{
									foreach ($esl_attach['article'] as $eat)
									{
											$email_attach[$eat] = $article_path . $eat;
									}
							}
							if (isset($esl_attach['modified']) && !empty($esl_attach['modified']))
							{
									foreach ($esl_attach['modified'] as $eat)
									{
											$arr = array();
											$eat_edited = '';
											if (strpos($eat, '/') !== false) {
												$arr = explode('/',$eat);
												$eat_edited = end($arr);
												$email_attach[$eat_edited] = $eat;
											}
											else
												$email_attach[$eat] = $modified_path . $eat;
									}
							}
					}
					$eml->email_attachments = $email_attach;
			}
		}
		else
		{
			//fetch adhoc uploaded path when client functionilty is OFF
			foreach ($email_content as $eml)
			{
					$esl_attach = ($eml->esl_attachments != NULL) ? json_decode($eml->esl_attachments, TRUE) : array();
					$email_attach = array();
					if (!empty($esl_attach))
					{
							//fetch adhoc uploaded path
							if(!empty($ad_noti)) {
									$ade_from	=	$ad_noti->ade_from;
									$ade_to		=	$email_content[0]->esl_user_id;
									$adhoc_path	=	'uploads/adhoc_attachments/'.$ade_from.'/'.$ade_to.'/';
									$send_mail_details->adhoc_path = true;
									foreach ($esl_attach['article'] as $eat)
									{
											$email_attach[$eat] = $adhoc_path . $eat;
									}
							}
					}
					$eml->email_attachments = $email_attach;
			}
		}
		//
		if(count($email_content[0]->email_attachments) > 0)
		{
			$attachments = $email_content[0]->email_attachments;
			$attach_row_html = $attachments;
		}
	}
	else
	{
		$attach_row_html	=      $get_attch;
	}
	return($attach_row_html);
}
public function remove_resend_email_attachments(Request $request)
{
	try {
		$resend_data = $request->all();
		$validator = Validator::make($request->all(), [
			'article_id' => 'required',
			'jnl_code' => 'required',
			'flow_id' => 'required',
		]);

	if($validator->fails())
	{
			return  $this->failure('Failed',422,$validator->errors());
	}
	$flowidarray = array('input'=>$resend_data['flow_id'],'type'=>'number', 'enc_data'=>TRUE );
		$articleidarray = array('input'=>$resend_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
		$jnlcodearray = array('input'=>$resend_data['jnl_code']);
		$flowidvalidation= $this->Rv_validator($flowidarray);
		$articleidvalidation= $this->Rv_validator($articleidarray);
		$jnlcodevalidation= $this->Rv_validator($jnlcodearray);

		if($articleidvalidation != TRUE || $jnlcodevalidation != TRUE ){
			return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
		}
		$flowid=decrypt_link($resend_data['flow_id']);
			if(isset($flowid)&&$flowid!='null'){
				$flowidarray = array('input'=>$resend_data['flow_id'],'type'=>'number', 'enc_data'=>TRUE );
				$flowidvalidation= $this->Rv_validator($flowidarray);
				if( $flowidvalidation != TRUE){
					return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
				}
			}

   $array['article_id']=decrypt_link($resend_data['article_id']);
	$array['jnl_code']=$resend_data['jnl_code'];
	$array['current_flow_id']=$flowid;
	$array['url']=$request->segment(4);
	$user_access=$this->check_permission_access_user($array);
	if($user_access!=true)
	{
		return  $this->failure('Unauthorized', 200, 'Unauthorized User');
	}

		$this->current_user = $this->get_current_user_details();
		$Resent_forward_emails_attachments = new \App\Models\Resent_forward_emails_attachments;
		$Email_send_log_table = (new \App\Models\Email_send_log )->getTable();
		$Resent_forward_emails_attachments_table = (new \App\Models\Resent_forward_emails_attachments )->getTable();

		$rfa_id = decrypt_link($resend_data['atmn_id']);
		$criteria = "rfa_id={$rfa_id}";

		$select = 'esl_attachments,rfa_attachment_path,rfa_file_name,rfa_article_id';
		$tables = array(
			'main_table' => $Resent_forward_emails_attachments_table,
			'join_table' => array(
				$Email_send_log_table => array($Email_send_log_table . '.esl_batch_id', $Resent_forward_emails_attachments_table . '.rfa_esl_batch_id', "join"),
			),
		);
		$get_attchments = $Resent_forward_emails_attachments::get_results_using_joins($tables, $select, $criteria, 'single');
		if (isset($get_attchments)) {
			$path = public_path() . "/storage/uploads/email_attachments/{$get_attchments->rfa_article_id}/";
			$aws_path = "uploads/email_attachments/{$get_attchments->rfa_article_id}/";
			//check if the attachment is already assosisated to any other mail, if associated then dont have to remove the attachemt from server
			$esl_attach = ($get_attchments->esl_attachments != NULL) ? json_decode($get_attchments->esl_attachments, TRUE) : array();
			if(isset($esl_attach['modified'])&&!empty($esl_attach['modified']))
			{
				$rfa_ids = array_values($esl_attach['modified']);
				if( (!in_array($get_attchments->rfa_attachment_path,$esl_attach['modified'])) && strpos($rfa_ids[0],'/') != 0 )
				{
					$this->remove_fileinfolder($path, $get_attchments->rfa_file_name, $aws_path);
					$Resent_forward_emails_attachments::delete_records("rfa_id={$rfa_id}", '', $this->current_user);
				}
				else if ((!in_array($get_attchments->rfa_file_name,$esl_attach['modified']) && strpos($rfa_ids[0],'/') == 0))
				{
					$this->remove_fileinfolder($path, $get_attchments->rfa_file_name, $aws_path);
					$Resent_forward_emails_attachments::delete_records("rfa_id={$rfa_id}", '', $this->current_user);
				}
			}elseif(isset($esl_attach['article'])&&!empty($esl_attach['article'])){
				if ((!in_array($get_attchments->rfa_file_name,$esl_attach['article']))){
					$this->remove_fileinfolder($path, $get_attchments->rfa_file_name, $aws_path);
					$Resent_forward_emails_attachments::delete_records("rfa_id={$rfa_id}", '', $this->current_user);
				}
			} elseif (empty($esl_attach['article']) && empty($esl_attach['modified'])) {
				$this->remove_fileinfolder($path, $get_attchments->rfa_file_name, $aws_path);
				$Resent_forward_emails_attachments::delete_records("rfa_id={$rfa_id}", '', $this->current_user);
			}			
		}

		$rtn_arr = array(
			'status' => 'success',
		);
		return $this->success('Success', 200, $rtn_arr);

	} catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}

}
public function get_all_inventory_files(Request $request)
{
try{

		$production_attachment_table = (new \App\Models\Production_attachment_files)->getTable();
        $Generic_flows = new \App\Models\Generic_flows();
        $Generic_flows_table =(new \App\Models\Generic_flows())->getTable();
        $Article_flow = new \App\Models\Article_flow();
        $Article_flow_table =( new \App\Models\Article_flow())->getTable();
		$Articles_table = (new \App\Models\Articles)->getTable();
		$Attachment_files_table = (new \App\Models\Attachment_files())->getTable();
		$Roles = new \App\Models\Roles();
		$Attachment_designated_roles_table = (new \App\Models\Attachment_designated_roles())->getTable();
		$Attachment_file_description_table = ( new \App\Models\Attachment_file_description())->getTable();
		$post_data = $request->all();
		$jnl_id=decrypt_link($post_data['jnl_id']);
		$jnl_code=$post_data['jnl_code'];
		$date_format = $this->get_platform_date_format($jnl_id);
        $date_format= date_format_map($date_format);
		$art_id= decrypt_link($post_data['art_id']);
		$popup_type =$post_data["type"];
		$this->current_user = $this->get_current_user_details();
		$customform_details = array();// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
		$attachment_type="attachment_type";
		$table_join = array(
			'main_table' => $production_attachment_table,
			'join_table' => array(
								$Article_flow_table => array($Article_flow_table . '.aflw_id', $production_attachment_table . '.paf_aflw_id'),
								$Generic_flows_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id'),
								$Articles_table => array($production_attachment_table . '.paf_art_id', $Articles_table . '.art_id'),
								$Attachment_designated_roles_table => array($Attachment_designated_roles_table . '.adr_paf_id', $production_attachment_table . '.paf_id', "left"),
								$Attachment_file_description_table => array($Attachment_file_description_table . '.afdec_id', $production_attachment_table . '.paf_description_id', "left")
							)
		);

		$max_flow_level = $Article_flow::get_single_record_with_bind_cond("max(aflw_level) as level",array("aflw_art_id" => $art_id));
		$get_all_top_levels = $Article_flow::get_all_records_with_bind_cond("aflw_jwf_id",array("aflw_level"=>$max_flow_level->level,"aflw_art_id"=>$art_id));
		$production_article = FALSE;
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($review_config);

		foreach($get_all_top_levels as $single_all_top_level)
		{
			$stage_type = $Generic_flows::get_single_record_with_bind_cond("jwf_stage_type",array("jwf_id" => $single_all_top_level->aflw_jwf_id));
			if(isset($review_flow[$stage_type->jwf_stage_type]['stage_for']) && $review_flow[$stage_type->jwf_stage_type]['stage_for'] == "manageproduction")
			{
				$production_article = TRUE;
			}
		}
		if($popup_type == 'invite')
		{
			$production_article = FALSE;
		}
		$role_id='';
		$core_role='';
		if(isset($post_data['role_id']))
		{
			$role_id=$post_data['role_id'];
			$core_role=$post_data['core_role'];
		}
		$data['show_viewable_file_permission_manage']=TRUE;
		$manage_role=main_production_roles();
		$art_criteria='paf_art_id = "' . $art_id .'"';
		if (!in_array($core_role, $manage_role))
		{
			$art_criteria.=' AND  (FIND_array_intersect(\''.$role_id.'\',adr_role_id) = 1';
			$art_criteria.=' OR aflw_usr_id='.$this->current_user['user_id'].')';
			$data['show_viewable_file_permission_manage']=FALSE;
		}
		$attachments = $Article_flow::get_results_using_joins($table_join, 'paf_id,paf_art_id,paf_aflw_id,jwf_stage_name,paf_file_name,paf_document_size,paf_designated_to,paf_posted_by,DATE_FORMAT(paf_posted_date, "' . $date_format . '") as uploaded_date,art_article_upload_path,adr_role_id as designated_roles,adr_id,afdec_description',$art_criteria,'all');
		foreach($attachments as $item){
			$item->$attachment_type ='Production Stage Files';
		}
		$table_auth_join = array(
			'main_table' => $Attachment_files_table,
			'join_table' => array(
								$Article_flow_table => array($Article_flow_table . '.aflw_id', $Attachment_files_table . '.atmnt_aflw_id'),
								$Generic_flows_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id'),
								$Articles_table => array($Attachment_files_table . '.atmnt_art_id', $Articles_table . '.art_id'),
								$Attachment_designated_roles_table => array($Attachment_designated_roles_table . '.adr_paf_id', $Attachment_files_table . '.atmnt_id', "left"),
								$Attachment_file_description_table => array($Attachment_file_description_table . '.afdec_id', $Attachment_files_table . '.atmnt_label', "left")
							)
		);
		if($production_article == TRUE)
		{
			$where_file_condition = 'atmnt_art_id =' .$art_id. ' AND  FIND_array_intersect("p",REPLACE(REPLACE(REPLACE(atmnt_designated_to,\'"\',""),"]",""),"[","")) = 1';
			if(!in_array($core_role, $manage_role))
			{
				$where_file_condition.=' AND  FIND_array_intersect(\''.$role_id.'\',adr_role_id) = 1';
			}
		}
		else
		{
			$where_file_condition = 'atmnt_art_id =' .$art_id;
		}
	
		$author_attachment = $Article_flow::get_results_using_joins($table_auth_join,  'atmnt_id,atmnt_art_id,atmnt_aflw_id,jwf_stage_name,atmnt_file_name,atmnt_document_size,DATE_FORMAT(atmnt_file_uploaded_date, "' . $date_format . '") as uploaded_date,atmnt_posted_by,atmnt_posted_date,art_article_upload_path,adr_role_id as designated_roles,adr_id,afdec_description',$where_file_condition,'all');
		foreach($author_attachment as $item){
			$item->$attachment_type ='Submission Files';
		}
		// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
		$data_arr=array(
			'art_id'=>$art_id??'',
			'jnl_code'=>$jnl_code??'',
			'role_id'=>$role_id??'',
			'core_role'=>$core_role??'',
			);
		$customform_details=$this->get_all_customform_files($data_arr);
		$data['showflag'] =$customform_details['showflag'];
		$data['element_viewstatus'] =$customform_details['element_viewstatus']; 
		$data['othercustomform_attachments'] =$customform_details['customform_attachments'];
		$data['journal_code']=$jnl_code;
		$data['production_stage_files']=$attachments;
		$data['production_author_attachment']=$author_attachment;
		$data['production_designated_roles']=array();
		$user_desinated_roles=$this->UserConfigdata('production_designated_roles');
		$production_roles=$Roles::get_all_records('role_id,role_name, role_assigned_role', 'role_assigned_role IN ("' . implode('","', $user_desinated_roles['production_designated_roles']) . '")');
		$data['production_designated_roles']=$production_roles;
		$data['permission_to_designate_roles']=FALSE;
		$data['popup_type'] = $popup_type;
		$table_body =  $data;
		$return_arr['attach_list']=$table_body;
	return $this->success('Success', 200, $return_arr);

	} catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	}
}
public function send_returned_to_reopened_stage_email(Request $request)
{
try{
	$Article_flow = (new \App\Models\Article_flow);
	$Article_reviewers = new \App\Models\Article_reviewers();
	$Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement;
	$Articles = new \App\Models\Articles;
	$Stage_email_templates= new \App\Models\Stage_email_templates();
	$Users=new \App\Models\User();
	$Unassign_reviewer = new \App\Models\Unassign_reviewer;
	$Generic_flows = new \App\Models\Generic_flows();

	$post_data =  $request->all();
	$validator = Validator::make($post_data, [
		'art_id' => 'required',
		'aflw_id' => 'required',
		'hold'=> 'required',
		'jnl_code'=> 'required'
		]);
		if ($validator->fails()) {
			return  $this->failure('Failed', 422, $validator->errors());
		}
	$this->current_user = $this->get_current_user_details();
	$art_id = isset($post_data['art_id'])?$this->decrypt_data($post_data['art_id']):'';
	$article_flow_id = decrypt_link($post_data['aflw_id']);
	$hold_stage_flow_id = decrypt_link($post_data['hold']);
	$jnl_id = decrypt_link($post_data['jnl_id']);
	$jnl_journal_code =decrypt_link($post_data['jnl_code']);
	$emaildata=$post_data['postdata'];

	$existrecord =$this->checkValidRecord($art_id, $article_flow_id,$jnl_journal_code);
	if($existrecord == false)
	{
		return  $this->warning('Failed', 200, "redirectdashboard");
	}

	if ($article_flow_id != '' && $hold_stage_flow_id != '' && $this->current_client->functionality->cfty_proceed_without_review == 'y')
	{

		$article_flow = $Article_flow::get_single_record_with_bind_cond('aflw_resume_source_of,aflw_reopened_stage_min_max_count,aflw_art_id,aflw_jwf_id', array(
			'aflw_id' => $hold_stage_flow_id));

		if (!empty($article_flow))
		{

			$invited_reviewers_list = $Article_flow::get_all_records('aflw_usr_id,aflw_id', 'aflw_parent_flow_id = ' . $article_flow->aflw_resume_source_of . ' and (aflw_status = \'i\' or aflw_status = \'a\') ');
			$article_id = $article_flow->aflw_art_id;
			$review_flow_id = $article_flow->aflw_resume_source_of;
			$previous_min_max_count = json_decode($article_flow->aflw_reopened_stage_min_max_count);
			$reviewers_count = $Article_reviewers::get_single_record_with_bind_cond('count(sorw_id) as reviewers',array('sorw_art_id' => decrypt_link($post_data['art_id'])));
			$flow_review_main = $Article_flow::get_single_record_with_bind_cond('aflw_jwf_id', array(
				'aflw_id' => $review_flow_id));
			$reviw_update_array = array(
				'aflw_stage_min_users' => $previous_min_max_count[0],
				'aflw_stage_max_users' => $previous_min_max_count[1],
				'aflw_more_review_skip_status' => 'y'
			);

			if($reviewers_count->reviewers == 0)
			{
				$reviw_update_array['aflw_skip_review'] = 'y';
			}

			if ($article_flow_id == $hold_stage_flow_id)
				$reviw_update_array['aflw_reopened_flow_id'] = NULL;
			$Article_flow::update_record($reviw_update_array,"aflw_id={$review_flow_id}", $this->current_user);
			$Article_flow::update_record(array(
				'aflw_status' => 'g'), 'aflw_status IN ("a", "i") AND aflw_parent_flow_id = ' . $review_flow_id,$this->current_user); //unassign reviewers

			$where_condition ="aflw_art_id={$article_id} AND 'apfm_status' = 'a'";
			$add_where = 'FIND_array_intersect("'.$flow_review_main->aflw_jwf_id.'",apfm_travel_path_ids) > 0';
			$select = "group_concat(apfm_id) as ids";
			$get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select,$where_condition,$add_where);
			if(!empty($get_path_having_jwf))
			{
				$ids = $get_path_having_jwf[0]->ids;
				if(!empty($ids))
				{
					$sql = "update rvw_article_parallel_flow_movement set apfm_status = 'c' where apfm_id IN (".$ids.")";
					$Article_parallel_flow_movement::execute_query($sql,TRUE);
				}
			}

			$select = 'art_artp_id, jwf_id, jwf_fwm_id';
			$article_details = $Articles::get_article_details($select,"aflw_id={$review_flow_id}");
			$article_details=$article_details[0];
			$flow_master_sql = "SELECT * FROM rvw_journal_workflows WHERE jwf_fwm_id = " . $article_details->jwf_fwm_id;
			$get_flow = $Generic_flows::get_records_by_raw_query($flow_master_sql);
			$current_jwf = $article_details->jwf_id;
			$workflow =$this->process_flow($get_flow);
			$select = '*, (select role_name from rvw_roles where role_id = jwf_role_id) as role_name';
			$this_stage = $Article_flow::get_stage_details("aflw_id={$review_flow_id}", $select);
			$reply_to_email='';
			$array_data['current_jwf'] = $current_jwf;
			$array_data['this_workflow'] = $workflow;
			$array_data['article_id'] = $article_id;
			$array_data['current_user'] =  $this->current_user;
			$array_data['parent_stage'] = $array_data['this_stage'] = $this_stage;
			$array_data['art_artp_id'] = $article_details->art_artp_id;
			$array_data['artp_id'] = $article_details->art_artp_id;
			$array_data['current_client'] = $this->current_client;
			$array_data['article_details'] = $article_details;
			$array_data['next_stage'] = $article_flow->aflw_jwf_id;
			$array_data['aflw_id'] = $article_flow_id;
			$array_data['reply_to_email'] = $reply_to_email;
			$tmp_status_id = $this->update_reopened_stages($array_data);

			$return['status'] = 'success';
			$return['prev_status_id'] = $review_flow_id;
			$return['status_id'] = $tmp_status_id;
			$return['show_modal'] = TRUE;


			if (isset($invited_reviewers_list) && count($invited_reviewers_list) >= 1)
			{
				$select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept';
				$article_details = $Articles::get_article_details($select,"aflw_id={$article_flow_id}" );
				$article_details = $article_details[0];

				$condition = array(
					'stage_etmp_action' => 'unassign_user',
					'stage_etmp_id' => ($emaildata['invite_tmpl_name'])
				);
				$email_template = $Stage_email_templates::get_single_record_with_bind_cond('*', $condition);
				if (!empty($email_template))
				{
					$post_data['art_id'] = $article_id;
					$insert_data = array(
						'unsn_reason' => (isset($emaildata['unassign_reason'])) ? $emaildata['unassign_reason'] : '',
					);
					foreach ($invited_reviewers_list as $invited)
					{
						$usr_details = $Users::get_single_record_with_bind_cond('usr_email,usr_id', array(
							'usr_id' => $invited->aflw_usr_id));

						//update the unassign reason
						$insert_data['unsn_rvr_id'] = $invited->aflw_usr_id;
						$insert_data['unsn_aflw_id'] = $invited->aflw_id;
						$Unassign_reviewer::insert_record($insert_data, $this->current_user);
						$post_data['esl_aflw_id'] = $invited->aflw_id;
						$post_data['unassign_email_reply_to'] =$emaildata['stage_template_to_mail'];

						if (isset($emaildata['stage_template_to_mail'])) {
						 $post_data['unassign_email_reply_to'] = $emaildata['stage_template_to_mail'];
					 }

					 if (!empty($emaildata['stage_template_to_cc'])) {
                        $post_data['unassign_tmpl_to_cc'] = $emaildata['stage_template_to_cc'];
                        $optccvalue = array();
                        if (isset($emaildata['stage_cust_cc'])) {
                            $custm_cc = $emaildata['stage_cust_cc'];
                            for ($i = 0; $i < count($custm_cc); $i++) {
                                $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                                $cust_value = str_replace('\\', '"', $cust_value);
                                $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);
            
                                array_push($optccvalue, $cust_value);
            
                            }
                            $post_data['unassign_tmpl_to_cust_cc'] = implode(',', $optccvalue);
            
                        }
                        else{
                            $post_data['unassign_tmpl_to_cust_cc'] = '';
                        }
            
                    }
					if (!empty($emaildata['stage_template_to_bcc'])) {
                        $post_data['unassign_tmpl_to_bcc'] = $emaildata['stage_template_to_bcc'];
                        $optbccvalue = array();
                        if (isset($emaildata['stage_cust_bcc'])) {
                            $custm_bcc = $emaildata['stage_cust_bcc'];
                            for ($i = 0; $i < count($custm_bcc); $i++) {
                                $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                                $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                                $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);
            
                                array_push($optbccvalue, $cust_bcc_value);
            
                            }
                            $post_data['unassign_tmpl_to_cust_bcc'] = implode(',', $optbccvalue);
                        }
                        else{
                            $post_data['unassign_tmpl_to_cust_bcc']='';
                        }
            
                    }
					$replace_button = array('<button contenteditable="false">', '</button>');
                    $post_data['postdata']['stage_template_content'] = str_replace($replace_button, '##', $emaildata['stage_template_content']);
					$this->send_unassign_email($email_template, $post_data, $article_details, $usr_details,$jnl_id,$jnl_journal_code);
					}
				}
			}
		}
	}
	return $this->success('Success', 200, $return);

} catch (\Exception $e) {
	return $this->failure('Failed', 500, $e);
}
}
public function upload_adhoc_email_attachments(Request $request)
{
	try
	{
		$adhoc_data =  $request->all();
		$Email_attachments = new \App\Models\Email_attachments;

		$this->current_user = $this->get_current_user_details();
		$current_user	=$this->current_user['user_id'];
							$ade_cc    =   $ade_bcc    =   '';
			if (isset($adhoc_data['adhoc_cc'])) {
				$cc = $adhoc_data['adhoc_cc'];
				 $adhoc_data['adhoc_cc'] = json_decode($cc);
			}

			if (isset($adhoc_data['adhoc_bcc']) && $adhoc_data['adhoc_bcc'] != "") {
				$bcc = $adhoc_data['adhoc_bcc'];
				$adhoc_data['adhoc_bcc'] = json_decode($bcc);
			}
					$optccvalue = [];
					if ($adhoc_data['adhoc_cc']) {
						if (isset($adhoc_data['adhoc_cust_cc']) && isset($adhoc_data['adhoc_cc']) && !empty($adhoc_data['adhoc_cust_cc']) && $adhoc_data['adhoc_cust_cc'] != 'undefined' && $adhoc_data['adhoc_cust_cc'] != '[]' && (in_array('Custom', $adhoc_data['adhoc_cc']) || in_array('Custom_cc', $adhoc_data['adhoc_cc']))) {
							$custm_cc = json_decode($adhoc_data['adhoc_cust_cc'], true);
							for ($i = 0; $i < count($custm_cc); $i++) {
								$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
								$cust_value = str_replace('\\', '"', $cust_value);
								$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

								array_push($optccvalue, $cust_value);
							}
							$adhoc_data['adhoc_cust_cc'] = implode(',', $optccvalue);
						}
					} else {
						$adhoc_data['adhoc_cust_cc'] = '';
					}
		
					$optbccvalue = array();
					if ($adhoc_data['adhoc_bcc']) {
						if (isset($adhoc_data['adhoc_cust_bcc']) && isset($adhoc_data['adhoc_bcc']) && !empty($adhoc_data['adhoc_cust_bcc']) && $adhoc_data['adhoc_cust_bcc'] != 'undefined' && $adhoc_data['adhoc_cust_cc'] != '[]' && (in_array('Custom', $adhoc_data['adhoc_bcc']) || in_array('Custom_bcc', $adhoc_data['adhoc_bcc']))) {
							$custm_bcc = json_decode($adhoc_data['adhoc_cust_bcc'], true);
							for ($i = 0; $i < count($custm_bcc); $i++) {
								$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
								$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
								$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);
								array_push($optbccvalue, $cust_bcc_value);
							}
							$adhoc_data['adhoc_cust_bcc'] = implode(',', $optbccvalue);
						}
					} else {
						$adhoc_data['adhoc_cust_bcc'] = '';
					}
		$to_user		=	decrypt_link($adhoc_data['userid']);
		$basic_path		=	'adhoc_attachments/' . $current_user . '/' .$to_user;
		$path			=	APP_DOC_PATH . $basic_path;
		if (!file_exists($path))
			mkdir($path, 0765, TRUE);
		// task id  6597 start
		if($adhoc_data['ade_id'] == ''){
			$ade_id = $this->save_adhoc_email_notification($adhoc_data);
		}
		else{
			$ade_id = $adhoc_data['ade_id'];
		}
		// task id  6597 start
			
	$image =  $adhoc_data['filename'];
		$name = $image->getClientOriginalName();
		$uploaded_file_details=$this->upload_file_handler($basic_path, $image, $name);

		if ($uploaded_file_details && $uploaded_file_details['name'] &&
		isset($uploaded_file_details['error'])&&$uploaded_file_details['error']== FALSE)
	{
			$hdn_article 	=	decrypt_link($adhoc_data['hdn_article']);
			$upld_flsz	=	$this->file_size_convert_to_kb($uploaded_file_details['size']);
			$attachments = $Email_attachments::get_all_records('IF(emat_document_size IS NULL, 0, emat_document_size) as document_size',"emat_ade_id={$ade_id} AND emat_art_id={$hdn_article}");
			$attch_file_html =$attachments;
			$tot_attachment_sz 	=	0;
			if(count($attachments) > 0) {
				foreach($attachments as $key) {
					$tot_attachment_sz	=	$tot_attachment_sz + $key->document_size;
				}
				$tot_attachment_sz	=	$upld_flsz + $tot_attachment_sz;
			}
			$uploaded_file_details['tot_attachment_sz'] = $tot_attachment_sz;
			$uploaded_file_details['total_size_exceeded'] = false;
			if($tot_attachment_sz > $this::tot_file_upd_sz) {
				$uploaded_file_details['total_size_exceeded'] = true;
			} else {
			$attch_file_html = '';

			$insert_data = array(
				'emat_file_name' =>$uploaded_file_details['name'],
				'emat_document_size' => $upld_flsz,
				'emat_ade_id' => $ade_id,
				'emat_art_id' => $hdn_article,
				'emat_posted_by' => $this->current_user['user_id'],
				'emat_proxy_id' => $this->current_user['proxy_user_id'],
			);
			$id				=	$Email_attachments::insert_record($insert_data);
			$attachments	=	$Email_attachments::get_all_records_with_bind_cond('emat_id as ane_id,emat_file_name as ane_name,IF(emat_document_size IS NULL, 0, emat_document_size) as document_size', array('emat_ade_id' => $ade_id,"emat_art_id" => decrypt_link($adhoc_data['hdn_article'])));

			$attch_file_html	=     $attachments;
			$uploaded_file_details['attch_file_html'] = $attch_file_html;
			}
		}
	return $this->success('Success', 200, $uploaded_file_details);

} catch (\Exception $e) {
	return $this->failure('Failed', 500, $e);
}
}
public function upload_reply_email_attachments(Request $request)
{
	try{
		$reply_data =  $request->all();
		$validator = Validator::make($request->all(), [
			'art_id' => 'required',
			'jnl_code' => 'required',
		]);

	if($validator->fails())
	{
			return  $this->failure('Failed',422,$validator->errors());
	}
			$articleidarray = array('input'=>$reply_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlcodearray = array('input'=>$reply_data['jnl_code']);
			$articleidvalidation= $this->Rv_validator($articleidarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
			$array_attach_id = '';
		if( $articleidvalidation != TRUE || $jnlcodevalidation != TRUE ){
			return  $this->warning('Warning',200,trans('viewarticle.invalid_data'),'Warning');
		}
		$flowid=decrypt_link($reply_data['aflw_id']);
		if(isset($flowid) && $flowid != null){
			$flowidarray = array('input'=>$reply_data['aflw_id'],'type'=>'number', 'enc_data'=>TRUE );
			$flowidvalidation= $this->Rv_validator($flowidarray);
			if( $flowidvalidation != TRUE){
				return  $this->warning('Warning',200,trans('viewarticle.invalid_data'),'Warning');
			}
		}
  	$array['article_id']=decrypt_link($reply_data['art_id']);
	$array['jnl_code']=$reply_data['jnl_code'];
	$array['current_flow_id']=decrypt_link($reply_data['aflw_id']);
	$array['url']=$request->segment(4);

		$this->current_user = $this->get_current_user_details();
		
		$art_id   =decrypt_link($reply_data['art_id']); 
		$attachArray = json_decode(decrypt_link($reply_data['attachArray']));
		$attachmentz = [];
		if(count($attachArray) > 0){
			$array_attach_id = '(' . implode(',', $attachArray) . ')';
		}else{
			$array_attach_id = NULL;
		}

		$Email_attachments = new \App\Models\Email_attachments;
		// Task #206 , Reply-mail file-path issue fix
		$to_user = decrypt_link($reply_data['usrto']);
		$from_user = decrypt_link($reply_data['usrfrom']);
		$fullpath = "email_attachments/{$to_user}/{$from_user}/receive";
		$basic_path		=	$fullpath .'/';
		$path			=	APP_DOC_PATH . $basic_path;
		if (!file_exists($path))
		{	
			mkdir($path, 0765, TRUE);
		}
		$image =  $reply_data['filename'];
		$name = $image->getClientOriginalName();
		$uploaded_file_details=$this->upload_file_handler($fullpath, $image, $name); // Task #206 , Reply-mail file-path issue fix	
		
		if ($uploaded_file_details && $uploaded_file_details['name'] && isset($uploaded_file_details['error'])&&$uploaded_file_details['error']== FALSE)
		{
			$upld_flsz = $this->file_size_convert_to_kb($uploaded_file_details['size']);
			if(!empty($array_attach_id)){
				$attachmentz = $Email_attachments::get_all_records('IF(emat_document_size IS NULL, 0, emat_document_size) as document_size',"emat_id IN {$array_attach_id}" );
			}
			$tot_attachment_sz = 0;
			if(count($attachmentz) > 0 && !empty($attachmentz)) {
				foreach($attachmentz as $key) {
					$tot_attachment_sz = $tot_attachment_sz + $key->document_size;
				}
				$tot_attachment_sz = $upld_flsz + $tot_attachment_sz;
			}
			else {
				$tot_attachment_sz = $upld_flsz;
			}
			$uploaded_file_details['total_size_exceeded'] = false;
			if($tot_attachment_sz > $this::tot_file_upd_sz) {
				$uploaded_file_details['total_size_exceeded'] = true;
			} else {
				$insert_data = array(
					'emat_file_name' => $uploaded_file_details['name'],
					'emat_document_size' => $upld_flsz,
					'emat_ade_id' => NULL,
					'emat_ane_id' => NULL,
					'emat_agf_id' => NULL,
					'emat_art_id' => $art_id,
					'emat_action_status' => 's',
					'emat_operation' => 'i'
				);
				$id = $Email_attachments::insert_record($insert_data,$this->current_user);
				array_push($attachArray, $id);
				
			}
			$select_attach = 'emat_id as ane_id,emat_file_name as ane_name, IF(emat_document_size IS NULL, 0, emat_document_size) as document_size';
			$array_attach_id = '';
			$array_attach_data = [];
			if(count($attachArray)>0){
				$array_attach_id = '(' . implode(',', $attachArray) . ')';
				$attachments = $this->get_reply_attachment($select_attach,$array_attach_id);
				if(!empty($attachments)){
					foreach ($attachments as $attachment) {
						array_push($array_attach_data,$attachment->ane_id);
						$attachment->rfa_attachment_path = 'uploads/email_attachments/'.$to_user.'/'.$from_user.'/receive/'.$attachment->ane_name; // Task #206 , Reply-mail file-path issue fix
					}
				}
			}
			else{
				$attachments = [];
			}
			$attch_file_html	=     $attachments;
			$uploaded_file_details['attch_file_html'] = $attch_file_html;	
			$uploaded_file_details['attch_file_data'] = $array_attach_data;	
			$uploaded_file_details['tot_attachment_sz'] = $tot_attachment_sz;
			return  $this->success('Success', 200, $uploaded_file_details);
		}
		
	}
	catch (\Exception $e) {
		return $this->failure('Failed', 500, $e);
	} 
}	
private function save_adhoc_email_notification($adhoc_data) 
	{
		$this->current_user = $this->get_current_user_details();
		$current_user	=$this->current_user['user_id'];
		$Adhoc_notification_emails = new \App\Models\Adhoc_notification_emails;

		$hidden_id	=	'';

		$adhoc_data['article_id']	=	decrypt_link($adhoc_data['hdn_article']);
		$hidden_id			=	($adhoc_data['ade_id'] != "") ? ($adhoc_data['ade_id']) : "";
		$ade_cc    =   $ade_bcc    =   '';								
		if (isset($adhoc_data['adhoc_cc']) && $adhoc_data['adhoc_cc'] != []) {
			$cc = $adhoc_data['adhoc_cc'];
			$ade_cc = json_encode($cc,true);
		}
		else{
			$ade_cc   = '';
		}
		if (isset($adhoc_data['adhoc_bcc']) && $adhoc_data['adhoc_bcc'] != []) {
			$bcc = $adhoc_data['adhoc_bcc'];
			$ade_bcc = json_encode($bcc,true);
		}
		else{
			$ade_bcc   = '';
		}
		$cust_cc    =   $cust_bcc    =   '';

				if (isset($adhoc_data['adhoc_cust_cc']) && !empty($adhoc_data['adhoc_cust_cc']) && $adhoc_data['adhoc_cust_cc'] != 'undefined' && $adhoc_data['adhoc_cust_cc'] != '[]') {
                    $cust_cc = ((isset($adhoc_data['adhoc_cc']))  && !empty($adhoc_data['adhoc_cc']) && (in_array('Custom', $adhoc_data['adhoc_cc'])||in_array('Custom_cc', $adhoc_data['adhoc_cc']))) ? ($adhoc_data['adhoc_cust_cc']) : '';
                }
				if (isset($adhoc_data['adhoc_cust_bcc']) && !empty($adhoc_data['adhoc_cust_bcc']) && $adhoc_data['adhoc_cust_bcc'] != 'undefined' && $adhoc_data['adhoc_cust_bcc'] != '[]') {
                    $cust_bcc = ((isset($adhoc_data['adhoc_bcc'])) && !empty($adhoc_data['adhoc_bcc']) && $adhoc_data['adhoc_cust_bcc'] !='undefined' &&( in_array('Custom', $adhoc_data['adhoc_bcc'])||in_array('Custom_bcc', $adhoc_data['adhoc_bcc']))) ? ($adhoc_data['adhoc_cust_bcc']) : '';
                }

                $em_content = (isset($adhoc_data['content'])) ? $adhoc_data['content'] : '';

		$formdata = array(
			'ade_art_id'	=> $adhoc_data['article_id'],
			'ade_usr_id'	=> decrypt_link($adhoc_data['userid']),
			'ade_template_id'=> $adhoc_data['temp_id'],
			'ade_from'	=> $current_user,
			'ade_to'	=> $adhoc_data['mail_to'],
			'ade_cc'	=> $ade_cc,
			'ade_bcc'	=> $ade_bcc,
			'ade_subject'	=> $adhoc_data['email_sub'],
			'ade_content'	=> $em_content,
			'ade_cust_cc'	=> $cust_cc,
			'ade_cust_bcc'	=> $cust_bcc,
			'ade_reply_to'	=> $adhoc_data['adhoc_reply_to']
		);
		if ($hidden_id == "")
		{
			$adhoc_notification = $Adhoc_notification_emails::get_single_record_with_bind_cond('ade_id', array(
				'ade_template_id' => $adhoc_data['temp_id'],
				'ade_to' => $adhoc_data['mail_to'],
				'ade_from' => $current_user,
				'ade_status' => 0
			));
			if (!empty($adhoc_notification))
			{
				$hidden_id = $adhoc_notification->ade_id;
			}
		}

		if (isset($hidden_id) && $hidden_id != '')
		{
			$ade_id = $hidden_id;
			$Adhoc_notification_emails::update_record($formdata,"ade_id = {$hidden_id}", $this->current_user);
		}
		else
		{
			$ade_id = $Adhoc_notification_emails::insert_record($formdata, $this->current_user);
		}
		return $ade_id;
	}
	public function remove_adhoc_email_attachments(Request $request) {
	try{
		$this->current_user = $this->get_current_user_details();
		$current_user = $this->current_user['user_id'];
		$Email_attachments = new \App\Models\Email_attachments;
		$adhoc_data = $request->all();

		$ade_id = decrypt_link($adhoc_data['ade_id']);
		$emat_id = decrypt_link($adhoc_data['ade_id']);
		$to_user = decrypt_link($adhoc_data['to_user']);

		$attach = $Email_attachments::get_single_record_with_bind_cond('emat_file_name', array(
			'emat_id' => $emat_id));
			if(!empty($attach)){
				$path = public_path() . '/storage/uploads/adhoc_attachments/'.$current_user.'/'.$to_user.'/';
			$aws_path = 'uploads/adhoc_attachments/'.$current_user.'/'.$to_user.'/';
			$this->remove_fileinfolder($path, $attach->emat_file_name, $aws_path);
			$Email_attachments::delete_records("emat_id ={$ade_id}", '', $this->current_user);
		}
		$rtn_arr = array(
			'status' => 'success',
		);
		return $this->success('Success', 200, $rtn_arr);

} catch (\Exception $e) {
	return $this->failure('Failed', 500, $e);
}
	}
	public function discard_adhoc_email(Request $request) {
		try{
			$this->current_user = $this->get_current_user_details();
			$current_user = $this->current_user['user_id'];
			$Adhoc_notification_emails = new \App\Models\Adhoc_notification_emails;
			$Email_attachments = new \App\Models\Email_attachments;

		$adhoc_data = $request->all();

			$ade_id         =	decrypt_link($adhoc_data['ade_id']);
			$to_user	=	decrypt_link($adhoc_data['usr_id']);
			$path = public_path() . '/storage/uploads/adhoc_attachments/'.$current_user.'/'.$to_user.'/';

			if($ade_id != '' && $to_user != '') {
				$adhoc_mail_cnt     = $Adhoc_notification_emails::get_single_record_with_bind_cond('count(ade_id) as cnt', array('ade_id' => $ade_id));

				if ($adhoc_mail_cnt->cnt > 0) {

					$attachments	=	$Email_attachments::get_all_records_with_bind_cond('emat_id,emat_file_name', array('emat_ade_id' => $ade_id));
					if(count($attachments)>0){
						$path = public_path() . '/storage/uploads/adhoc_attachments/'.$current_user.'/'.$to_user.'/';
					$aws_path = 'uploads/adhoc_attachments/'.$current_user.'/'.$to_user.'/';
					foreach($attachments as $key => $val) {
						$path = public_path() . '/storage/uploads/adhoc_attachments/'.$current_user.'/'.$to_user.'/';
						$aws_path = 'uploads/adhoc_attachments/'.$current_user.'/'.$to_user.'/';
						$this->remove_fileinfolder($path, $val->emat_file_name, $aws_path);

					}
					$Email_attachments::delete_records("emat_ade_id ={$ade_id}", '', $this->current_user);
				}

					$Adhoc_notification_emails::delete_records("ade_id ={$ade_id}", '', $this->current_user);

					$rtn_arr =	array(
						'status' => 'success',
						'msg' =>'Email deleted successfully'
					);
				}

			}
			return $this->success('Success', 200, $rtn_arr);

} catch (\Exception $e) {
	return $this->failure('Failed', 500, $e);
}
	}
	public function upload_adhoc_email_inventory_attachments(Request $request)
	{
		try {
			$current_user = $this->get_current_user_details();
			$current_user_id = $current_user['user_id'];
			$adhoc_data = $request->all();
			$jnl_code = Rv_decrypt($adhoc_data['jnl_code']);
			$art_id = decrypt_link($adhoc_data['artid']);

			$select = 'jwf_stage_type,artp_abbr_article_type';
			$article_details = Articles::get_article_details($select, "art_id={$art_id}");
			$article_details = $article_details[0];
			// task id  6597 start
			if (isset($adhoc_data['formData'][0]['adhoc_cc'])) {
				$cc = $adhoc_data['formData'][0]['adhoc_cc'];
				 $adhoc_data['formData'][0]['adhoc_cc'] = (gettype($cc) == 'string') ? json_decode($cc) : $cc;
			}
			if (isset($adhoc_data['formData'][0]['adhoc_bcc'])) {
				$bcc = $adhoc_data['formData'][0]['adhoc_bcc'];
				$adhoc_data['formData'][0]['adhoc_bcc'] = (gettype($bcc) == 'string') ? json_decode($bcc) : $bcc;
			}
					$optccvalue = [];
					if (isset($adhoc_data['formData'][0]['adhoc_cust_cc'])&&!empty($adhoc_data['formData'][0]['adhoc_cust_cc']) && $adhoc_data['formData'][0]['adhoc_cc'] != '' && (in_array('Custom', $adhoc_data['formData'][0]['adhoc_cc'])||in_array('Custom_cc', $adhoc_data['formData'][0]['adhoc_cc']))) {
						$custm_cc = (gettype($adhoc_data['formData'][0]['adhoc_cust_cc']) == 'string') ? json_decode($adhoc_data['formData'][0]['adhoc_cust_cc'],true) : $adhoc_data['formData'][0]['adhoc_cust_cc'];
						for ($i = 0; $i < count($custm_cc); $i++) {
							$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
							$cust_value = str_replace('\\', '"', $cust_value);
							$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);
	
							array_push($optccvalue, $cust_value);
	
						}
						$adhoc_data['formData'][0]['adhoc_cust_cc'] = implode(',', $optccvalue);
	
					}
					else{
						$adhoc_data['formData'][0]['adhoc_cust_cc']='';
					}
	
					$optbccvalue = array();
					if (isset($adhoc_data['formData'][0]['adhoc_cust_bcc'])&&!empty($adhoc_data['formData'][0]['adhoc_cust_bcc']) && $adhoc_data['formData'][0]['adhoc_bcc'] != '' &&(in_array('Custom', $adhoc_data['formData'][0]['adhoc_bcc'])||in_array('Custom_bcc', $adhoc_data['formData'][0]['adhoc_bcc']))) {
						$custm_bcc = (gettype($adhoc_data['formData'][0]['adhoc_cust_bcc']) == 'string') ? json_decode($adhoc_data['formData'][0]['adhoc_cust_bcc'], true) : $adhoc_data['formData'][0]['adhoc_cust_bcc'];
						for ($i = 0; $i < count($custm_bcc); $i++) {
							$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
							$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
							$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);
							array_push($optbccvalue, $cust_bcc_value);
	
						}
						$adhoc_data['formData'][0]['adhoc_cust_bcc'] = implode(',', $optbccvalue);
					}
					else{
						$adhoc_data['formData'][0]['adhoc_cust_bcc']='';
					}
			// task id  6597 end
			$Email_attachments = new \App\Models\Email_attachments;
			$Production_attachment_files = new \App\Models\Production_attachment_files();
			$Attachment_files = new \App\Models\Attachment_files();

			$art_details = $article_details;

			$to_user = Rv_decrypt($adhoc_data['hdn_usr_id']);

			$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
			$prefixPath = storage_path()  . $file_storage_path;
			$basic_path = $prefixPath . APP_DOC_PATH . 'adhoc_attachments/' . $current_user_id . '/' . $to_user;
			if (!file_exists($basic_path)) {
				mkdir($basic_path, 0765, TRUE);
			}
		$ade_id = $this->save_adhoc_email_notification($adhoc_data['formData'][0]);

			$ade_attachments 	= 	$Email_attachments::get_all_records('IF(emat_document_size IS NULL, 0, emat_document_size) as document_size',"emat_ade_id={$ade_id} AND emat_art_id={$art_id}");
			$tot_attachment_sz 	=	0;
			if(count($ade_attachments) > 0) {
				foreach($ade_attachments as $key) {
					$tot_attachment_sz	=	$tot_attachment_sz + $key->document_size;
				}
			}

			$article_files = $adhoc_data['selectedfilelist'];
			$error_artcle_files = array();
			/**
			 * if an article have revisions then need to take all the previous article id for source file exist check
			 */
			$prev_select = "art_pre_all_ids";
			$prev_article_ids = Articles::get_article_details($prev_select, "art_id={$art_id}");
			$prev_article_id_array = (!empty($prev_article_ids[0]->art_pre_all_ids)) ? explode(',',$prev_article_ids[0]->art_pre_all_ids) : [];
			if (!empty($article_files) && count($article_files) > 0) {
				foreach ($article_files as $single_article_files) {
					// $attachment_file_name = $Attachment_files::get_single_record('atmnt_file_name,atmnt_orginal_upload_path', "atmnt_id={$single_article_files['atmnt_id']}");

					$attachment_file_dtls = $Attachment_files::get_single_record_with_bind_cond('atmnt_file_name', array('atmnt_id' => ($single_article_files['atmnt_id'])));
					$attachment_file_name = $attachment_file_dtls->atmnt_file_name;
					if(count($prev_article_id_array) > 0){
						foreach ($prev_article_id_array as $key => $prev_art_id) {
							$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $art_details->artp_abbr_article_type . '/' . $prev_art_id . '/' . $attachment_file_name;
							if (file_exists($source_path)) {
								break;
							}else{
								$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $art_details->artp_abbr_article_type . '/' . $art_id . '/' . $attachment_file_name;
							}
						}
					}
					else{
						$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $art_details->artp_abbr_article_type . '/' . $art_id . '/' . $attachment_file_name;
					}
					if (file_exists($source_path)) {
						$sf_fz_bi	=	filesize($source_path);		// in bytes
						$sf_fz_kb	=	$this->file_size_convert_to_kb($sf_fz_bi); 	// in kb
						$destination_path = $basic_path . '/' . $attachment_file_name;
						if (file_exists($destination_path)) {
							$i = 1;
							$got_new_file = FALSE;
							while ($got_new_file == FALSE) {
								$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
								$file_name = basename($attachment_file_name, '.' . $ext);
								if (!file_exists($basic_path . '/' . $file_name . '(' . $i . ').' . $ext)) { // TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
									$got_new_file = TRUE;
									$attachment_file_name = $file_name . '(' . $i . ').' . $ext; // TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								}
								$i++;
							}
							$destination_path = $basic_path . '/' . $attachment_file_name;
						}
						$tot_attachment_sz	=	$sf_fz_kb + $tot_attachment_sz;
						if($tot_attachment_sz < $this::tot_file_upd_sz) {
							if (copy($source_path, $destination_path)) {
								// start TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$file = new File($source_path);
									$image = new UploadedFile(
										$file->getPathname(), // The full path to the file
										$file->getFilename(), // The original file name
										$file->getMimeType(), // The mime type of the file
										0, // The error code (UPLOAD_ERR_OK)
										true // Whether the test mode is enabled (skip move verification)
									);
								if(isset($current_user_id) && isset($to_user)){
									$path_adhoc_file ='adhoc_attachments/'. $current_user_id .'/' .$to_user;
									if(isset($path_adhoc_file) && isset($image) && isset($attachment_file_name))
									$uploaded_file_details=$this->upload_file_handler($path_adhoc_file, $image, $attachment_file_name);
								}
								// end TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$insert_data = array(
									'emat_file_name' => $attachment_file_name,
									'emat_document_size' => $single_article_files['atmnt_document_size'],
									'emat_ade_id' => $ade_id,
									'emat_art_id' => $art_id
								);
								$id = Email_attachments::insert_record($insert_data,$current_user);
							} else {
								array_push($error_artcle_files, $attachment_file_name);
							}
						}
					}
				}
			}
			// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
			$custom_files = $adhoc_data['selectedcustomfilelist'];
			if (!empty($custom_files) && count($custom_files) > 0) {
				foreach ($custom_files as $single_custom_files) {

					$Generic_form_files = new \App\Models\Generic_form_files;

					$attachment_file_dtls = $Generic_form_files::get_single_record('agf_id,agf_name as atmnt_file_name,agf_file_size as atmnt_document_size',"agf_id={$single_custom_files['atmnt_id']}");
;
					// $attachment_file_dtls = $Attachment_files::get_single_record_with_bind_cond('atmnt_file_name', array('atmnt_id' => ($single_custom_files['atmnt_id'])));
					$attachment_file_name = $attachment_file_dtls->atmnt_file_name;
					if(count($prev_article_id_array) > 0){
						foreach ($prev_article_id_array as $key => $prev_art_id) {
							$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $art_details->artp_abbr_article_type . '/' . $prev_art_id . '/' . $attachment_file_name;
							if (file_exists($source_path)) {
								break;
							}else{
								$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $art_details->artp_abbr_article_type . '/' . $art_id . '/' . $attachment_file_name;
							}
						}
					}
					else{
						$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $art_details->artp_abbr_article_type . '/' . $art_id . '/' . $attachment_file_name;
					}
					if (file_exists($source_path)) {
						$sf_fz_bi	=	filesize($source_path);		// in bytes
						$sf_fz_kb	=	$this->file_size_convert_to_kb($sf_fz_bi); 	// in kb
						$destination_path = $basic_path . '/' . $attachment_file_name;
						if (file_exists($destination_path)) {
							$i = 1;
							$got_new_file = FALSE;
							while ($got_new_file == FALSE) {
								$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
								$file_name = basename($attachment_file_name, '.' . $ext);
								if (!file_exists($basic_path . '/' . $file_name . '(' . $i . ').' . $ext)) { // TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
									$got_new_file = TRUE;
									$attachment_file_name = $file_name . '(' . $i . ').' . $ext; // TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								}
								$i++;
							}
							$destination_path = $basic_path . '/' . $attachment_file_name;
						}
						$tot_attachment_sz	=	$sf_fz_kb + $tot_attachment_sz;
						if($tot_attachment_sz < $this::tot_file_upd_sz) {
							if (copy($source_path, $destination_path)) {
								// start TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$file = new File($source_path);
									$image = new UploadedFile(
										$file->getPathname(), // The full path to the file
										$file->getFilename(), // The original file name
										$file->getMimeType(), // The mime type of the file
										0, // The error code (UPLOAD_ERR_OK)
										true // Whether the test mode is enabled (skip move verification)
									);
								if(isset($current_user_id) && isset($to_user)){
									$path_adhoc_file ='adhoc_attachments/'. $current_user_id .'/' .$to_user;
									if(isset($path_adhoc_file) && isset($image) && isset($attachment_file_name))
									$uploaded_file_details=$this->upload_file_handler($path_adhoc_file, $image, $attachment_file_name);
								}
								// end TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$insert_data = array(
									'emat_file_name' => $attachment_file_name,
									'emat_document_size' =>  $single_custom_files['document_size'],
									'emat_ade_id' => $ade_id,
									'emat_art_id' => $art_id
								);
								$id = Email_attachments::insert_record($insert_data,$current_user);
							} else {
								array_push($error_artcle_files, $attachment_file_name);
							}
						}
					}
				}
			}
			$production_files = $adhoc_data['selectedproductionfilelist'];
			if (!empty($production_files) && count($production_files) > 0) {
				$error_pro_files = array();
				foreach ($production_files as $single_production_files) {
					$pro_files_dtls = $Production_attachment_files::get_single_record_with_bind_cond('paf_aflw_id,paf_file_name', array('paf_id' => ($single_production_files['paf_id'])));
					$attachment_file_name = $pro_files_dtls->paf_file_name;
					$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $art_details->artp_abbr_article_type . '/' . $art_id . '/production/' . $pro_files_dtls->paf_aflw_id . '/' . $attachment_file_name;
					if (file_exists($source_path)) {
						$sf_fz_bi	=	 filesize($source_path);	// in bytes
						$sf_fz_kb	=	$this->file_size_convert_to_kb($sf_fz_bi); 	// in kb
						$destination_path = $basic_path . '/' . $attachment_file_name;
						if (file_exists($destination_path)) {
							$i = 1;
							$got_new_file = FALSE;
							while ($got_new_file == FALSE) {
								$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
								$file_name = basename($attachment_file_name, '.' . $ext);
								if (!file_exists($basic_path . '/' . $file_name . '(' . $i . ').' . $ext)) { // TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
									$got_new_file = TRUE;
									$attachment_file_name = $file_name . '(' . $i . ').' . $ext; // TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								}
								$i++;
							}
							$destination_path = $basic_path . '/' . $attachment_file_name;
						}
						$tot_attachment_sz	=	$sf_fz_kb + $tot_attachment_sz;
						if($tot_attachment_sz < $this::tot_file_upd_sz) {
							if (copy($source_path, $destination_path)) {
								 //start TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$file = new File($source_path);							
									$image = new UploadedFile(
										$file->getPathname(), // The full path to the file
										$file->getFilename(), // The original file name
										$file->getMimeType(), // The mime type of the file
										0, // The error code (UPLOAD_ERR_OK)
										true // Whether the test mode is enabled (skip move verification)
									);
								if(isset($current_user_id) && isset($to_user)){
									$path_adhoc_file ='adhoc_attachments/'. $current_user_id .'/' .$to_user;
									if(isset($path_adhoc_file) && isset($image) && isset($attachment_file_name))
									$this->upload_file_handler($path_adhoc_file, $image, $attachment_file_name);
								}
								 // end TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$insert_data = array(
									'emat_file_name' => $attachment_file_name,
									'emat_document_size' => $single_production_files['paf_document_size'],
									'emat_ade_id' => $ade_id,
									'emat_art_id' => $art_id
								);
								Email_attachments::insert_record($insert_data,$current_user);
							} else {
								array_push($error_pro_files, $attachment_file_name);
							}
						}
					}
				}
			}
			$return_arr = array('status' => 'success', 'tot_attachment_sz' => '0');
			$return_arr['ade_id'] = encrypt_link($ade_id);
			if($tot_attachment_sz > $this::tot_file_upd_sz) {
				$return_arr = array('status' => 'warning', 'tot_attachment_sz' => $tot_attachment_sz);
				return $this->warning('Warning', 200, $return_arr);
			}
			else
				return $this->success('Success', 200, $return_arr);
		} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	public function attach_invertory_to_email(Request $request)
	{
		try {
			$current_user = $this->get_current_user_details();
			$payload_data = $request->all();
			$Email_attachments = new \App\Models\Email_attachments;
			$Production_attachment_files = new \App\Models\Production_attachment_files();
			$Attachment_files = new \App\Models\Attachment_files();
			$jnl_code = Rv_decrypt($payload_data['jnl_code']);
			$art_id = decrypt_link($payload_data['artid']);
			$select = 'jwf_stage_type,artp_abbr_article_type';
			$article_details = Articles::get_article_details($select, "art_id={$art_id}");
			$article_details = $article_details[0];
			$temp_type = '';
			if(isset($payload_data['type']) && !empty($payload_data['type'])){
				$temp_type = decrypt_link($payload_data['type']);
			}
			$ane_id = $this->save_article_email_notification($payload_data['formData'][0], 'email', $temp_type);
			$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
			$prefixPath = storage_path()  . $file_storage_path;
			$basic_path = $prefixPath . APP_DOC_PATH . 'email_attachments/' . $art_id;
			if (!file_exists($basic_path)) {
				mkdir($basic_path, 0765, TRUE);
			}
			$article_files = $payload_data['selectedfilelist'];

			$tot_attachment_sz 	=	0;
			$ane_attachments 	= 	$Email_attachments::get_all_records('IF(emat_document_size IS NULL, 0, emat_document_size) as document_size',"emat_ane_id={$ane_id} AND emat_art_id={$art_id}");
			if(count($ane_attachments) > 0) {
				foreach($ane_attachments as $key) {
					$tot_attachment_sz	=	$tot_attachment_sz + $key->document_size;
				}
			}

			if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y') {
				$Articles = new \App\Models\Articles;
				$article_details1 = $Articles::get_single_record('art_article_upload_path',"art_id={$art_id}");


				if (isset($payload_data['formData']['0']['attach_org']) && !empty($payload_data['formData']['0']['attach_org'])) {
					$Generic_form_files = new \App\Models\Generic_form_files;
					$attach_org=$payload_data['formData']['0']['attach_org'];
					if(count($attach_org)>0) {
					foreach ($attach_org as $att) {
						$genric_form_file = $Generic_form_files::get_single_record('agf_id,agf_name,agf_file_size',"agf_id={$att}");
						if (!empty($genric_form_file)) {
							$insert_data = array(
								'emat_file_name' => $genric_form_file->agf_name,
								'emat_ane_id' => $ane_id,
								'emat_agf_id' => $genric_form_file->agf_id,
								'emat_art_id' => $art_id,
								'emat_document_size' => $genric_form_file->agf_file_size
							);
							if($temp_type != ''){
								$insert_data['emat_for'] = $temp_type;
							}
							$email_attach_exists = $Email_attachments::get_single_record('emat_file_name',"emat_file_name='{$genric_form_file->agf_name}' and emat_ane_id={$ane_id} and emat_agf_id={$genric_form_file->agf_id} ");

							if (empty($email_attach_exists)) {

								$source = public_path() . '/storage/uploads/' . $article_details1->art_article_upload_path . '/' . $genric_form_file->agf_name;
								$destination = public_path() . '/storage/uploads/email_attachments/' . $art_id;

								if (!file_exists($destination)){
									mkdir($destination, 0765, TRUE);
								}
								$dest_file = $destination . '/' . $genric_form_file->agf_name;
								//#357 if $source does not exists , PHP error showing for copy function
								if (file_exists($source)) {
									copy($source, $dest_file);
								}
								$Email_attachments::insert_record($insert_data,$current_user);
							}
						}
					}
				}
				}
				//#1954 Author designated file attach publish complete stage code start
				if (isset($payload_data['formData']['0']['attach_mod_production']) && !empty($payload_data['formData']['0']['attach_mod_production'])) {
					$attach_mod_production=$payload_data['formData']['0']['attach_mod_production'];
					if(count($attach_mod_production)>0) {
					foreach ($attach_mod_production as $att_production) {
						$Production_attachment_files = new \App\Models\Production_attachment_files();
						$production_uploaded_files = $Production_attachment_files::get_single_record('paf_id,paf_file_name,paf_aflw_id,paf_document_size',"paf_id={$att_production}");
						if (!empty($production_uploaded_files)) {
							$destination = 'uploads/email_attachments/' . $art_id;
								if (!file_exists($destination)){
									mkdir($destination, 0765, TRUE);
								}

								$dest_file = $destination . '/' . $production_uploaded_files->paf_file_name;
								$original_name_of_file=$production_uploaded_files->paf_file_name;
								if(file_exists($dest_file)) {
									$name_of_uploaded_file=$this->updatenewName($destination, $original_name_of_file);
									$destination_file_path =$destination.'/'. $name_of_uploaded_file;
								} else {
									$name_of_uploaded_file =$production_uploaded_files->paf_file_name;
									$destination_file_path=$dest_file;
								}

							$insert_data = array(
								'emat_file_name' => $name_of_uploaded_file,
								'emat_ane_id' => $ane_id,
								'emat_agf_id' => $production_uploaded_files->paf_id,
								'emat_art_id' => $art_id,
								'emat_document_size' => $production_uploaded_files->paf_document_size
							);
							$email_attach_exists = $Email_attachments::get_single_record('emat_file_name',"emat_file_name='{$name_of_uploaded_file}' and emat_ane_id={$ane_id} and emat_agf_id={$production_uploaded_files->paf_id}");

							if (empty($email_attach_exists)) {
								$source = 'uploads/' . $article_details1->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/'. $production_uploaded_files->paf_aflw_id. DIRECTORY_SEPARATOR.$production_uploaded_files->paf_file_name;

								//#357 if $source does not exists , PHP error showing for copy function
								if (file_exists($source)) {

									copy($source, $destination_file_path);
								}
								$Email_attachments::insert_record($insert_data, $current_user);
							}
						}
					}
				}
			 }

			}
			// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
			$custom_files = $payload_data['selectedcustomfilelist'];
			if (!empty($custom_files) && count($custom_files) > 0) {
				$error_artcle_files = array();
				foreach ($custom_files as $single_custom_files) {
					$Generic_form_files = new \App\Models\Generic_form_files;
					$attachment_file_dtls = $Generic_form_files::get_single_record('agf_id,agf_name as atmnt_file_name,agf_file_size as atmnt_document_size,agf_original_upload_path as atmnt_orginal_upload_path',"agf_id={$single_custom_files['atmnt_id']}");
					$attachment_file_name = $attachment_file_dtls->atmnt_file_name;
					$source_path = $prefixPath . APP_DOC_PATH . $attachment_file_dtls->atmnt_orginal_upload_path . '/' . $attachment_file_name;
					if (file_exists($source_path)) {
						$destination_path = $basic_path . '/' . $attachment_file_name;
						$sf_fz_bi	=	 filesize($source_path);	// in bytes
						$sf_fz_kb	=	$this->file_size_convert_to_kb($sf_fz_bi); 	// in kb

						if (file_exists($destination_path)) {
							$i = 1;
							$got_new_file = FALSE;
							while ($got_new_file == FALSE) {
								$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
								$file_name = basename($attachment_file_name, '.' . $ext);
								if (!file_exists($basic_path . '/' . $file_name . '(' . $i . ').' . $ext)) {
									$got_new_file = TRUE;
									$attachment_file_name = $file_name . '(' . $i . ').' . $ext;
								}
								$i++;
							}
							$destination_path = $basic_path . '/' . $attachment_file_name;
						}
						$tot_attachment_sz	=	$sf_fz_kb + $tot_attachment_sz;
						if($tot_attachment_sz < $this::tot_file_upd_sz) {
							if (copy($source_path, $destination_path)) {
								// start TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$file = new File($source_path);
								$image = new UploadedFile(
									$file->getPathname(), // The full path to the file
									$file->getFilename(), // The original file name
									$file->getMimeType(), // The mime type of the file
									0, // The error code (UPLOAD_ERR_OK)
									true // Whether the test mode is enabled (skip move verification)
								);
								if(isset($art_id) ){
									$path_decision_file ='email_attachments/' . $art_id;
									if(isset($path_decision_file) && isset($image) && isset($attachment_file_name))
									$this->upload_file_handler($path_decision_file, $image, $attachment_file_name);
								}
								// end TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$insert_data = array(
									'emat_file_name' => $attachment_file_name,
									'emat_document_size' => $single_custom_files['document_size'],
									'emat_ane_id' => $ane_id,
									'emat_art_id' => $art_id
								);
								if($temp_type != ''){
									$insert_data['emat_for'] = $temp_type;
								}
								Email_attachments::insert_record($insert_data,$current_user);
							} else {
								array_push($error_artcle_files, $attachment_file_name);
							}
						}
					}
				}
			}
			if (!empty($article_files) && count($article_files) > 0) {
				$error_artcle_files = array();
				foreach ($article_files as $single_article_files) {
					$attachment_file_dtls = $Attachment_files::get_single_record_with_bind_cond('atmnt_file_name,atmnt_orginal_upload_path', array('atmnt_id' => ($single_article_files['atmnt_id'])));
					$attachment_file_name = $attachment_file_dtls->atmnt_file_name;
					$source_path = $prefixPath . APP_DOC_PATH . $attachment_file_dtls->atmnt_orginal_upload_path . '/' . $attachment_file_name;
					if (file_exists($source_path)) {
						$destination_path = $basic_path . '/' . $attachment_file_name;
						$sf_fz_bi	=	 filesize($source_path);	// in bytes
						$sf_fz_kb	=	$this->file_size_convert_to_kb($sf_fz_bi); 	// in kb

						if (file_exists($destination_path)) {
							$i = 1;
							$got_new_file = FALSE;
							while ($got_new_file == FALSE) {
								$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
								$file_name = basename($attachment_file_name, '.' . $ext);
								if (!file_exists($basic_path . '/' . $file_name . '(' . $i . ').' . $ext)) {
									$got_new_file = TRUE;
									$attachment_file_name = $file_name . '(' . $i . ').' . $ext;
								}
								$i++;
							}
							$destination_path = $basic_path . '/' . $attachment_file_name;
						}
						$tot_attachment_sz	=	$sf_fz_kb + $tot_attachment_sz;
						if($tot_attachment_sz < $this::tot_file_upd_sz) {
							if (copy($source_path, $destination_path)) {
								// start TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$file = new File($source_path);
								$image = new UploadedFile(
									$file->getPathname(), // The full path to the file
									$file->getFilename(), // The original file name
									$file->getMimeType(), // The mime type of the file
									0, // The error code (UPLOAD_ERR_OK)
									true // Whether the test mode is enabled (skip move verification)
								);
								if(isset($art_id) ){
									$path_decision_file ='email_attachments/' . $art_id;
									if(isset($path_decision_file) && isset($image) && isset($attachment_file_name))
									$this->upload_file_handler($path_decision_file, $image, $attachment_file_name);
								}
								// end TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
								$insert_data = array(
									'emat_file_name' => $attachment_file_name,
									'emat_document_size' => $single_article_files['atmnt_document_size'],
									'emat_ane_id' => $ane_id,
									'emat_art_id' => $art_id
								);
								if($temp_type != ''){
									$insert_data['emat_for'] = $temp_type;
								}
								Email_attachments::insert_record($insert_data,$current_user);
							} else {
								array_push($error_artcle_files, $attachment_file_name);
							}
						}
					}
				}
			}
			$production_files = $payload_data['selectedproductionfilelist'];
			if (!empty($production_files) && count($production_files) > 0) {
				$error_pro_files = array();
				foreach ($production_files as $single_production_files) {
					$pro_files_dtls = $Production_attachment_files::get_single_record_with_bind_cond('paf_aflw_id,paf_file_name', array('paf_id' => ($single_production_files['paf_id'])));
					$attachment_file_name = $pro_files_dtls->paf_file_name;
					$source_path = $prefixPath . 'uploads/' . $jnl_code . '/' . $article_details->artp_abbr_article_type . '/' . $art_id . '/production/' . $pro_files_dtls->paf_aflw_id . '/' . $attachment_file_name;
					if (file_exists($source_path)) {
						$destination_path = $basic_path . '/' . $attachment_file_name;
						$sf_fz_bi	=	 filesize($source_path);	// in bytes
						$sf_fz_kb	=	$this->file_size_convert_to_kb($sf_fz_bi); 	// in kb

						if (file_exists($destination_path)) {
							$i = 1;
							$got_new_file = FALSE;
							while ($got_new_file == FALSE) {
								$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
								$file_name = basename($attachment_file_name, '.' . $ext);
								if (!file_exists($basic_path . '/' . $file_name . '(' . $i . ').' . $ext)) {
									$got_new_file = TRUE;
									$attachment_file_name = $file_name . '(' . $i . ').' . $ext;
								}
								$i++;
							}
							$destination_path = $basic_path . '/' . $attachment_file_name;
						}
					}
					$tot_attachment_sz	=	$sf_fz_kb + $tot_attachment_sz;
					if($tot_attachment_sz < $this::tot_file_upd_sz) {
						if (copy($source_path, $destination_path)) {
							// start TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
							$file = new File($source_path);
							$image = new UploadedFile(
								$file->getPathname(), // The full path to the file
								$file->getFilename(), // The original file name
								$file->getMimeType(), // The mime type of the file
								0, // The error code (UPLOAD_ERR_OK)
								true // Whether the test mode is enabled (skip move verification)
							);
						if(isset($art_id)){
							$path_decision_file ='email_attachments/' . $art_id;
							if(isset($path_decision_file) && isset($image) && isset($attachment_file_name))
							$this->upload_file_handler($path_decision_file, $image, $attachment_file_name);
						}
						// end TASK #6980 The file does not open when a user attaches a file from the file inventory in an ad hoc email.
							$insert_data = array(
								'emat_file_name' => $attachment_file_name,
								'emat_ane_id' => $ane_id,
								'emat_art_id' => $art_id,
								'emat_document_size' => $single_production_files['paf_document_size'],
							);
							Email_attachments::insert_record($insert_data,$current_user);
						} else {
							array_push($error_pro_files, $attachment_file_name);
						}
					}
				}
			}
			$return_arr = array('status' => 'success', 'tot_attachment_sz' => '0');
			$return_arr['ane_id'] = encrypt_link($ane_id);
			if($tot_attachment_sz > $this::tot_file_upd_sz) {
				$return_arr = array('status' => 'warning', 'tot_attachment_sz' => $tot_attachment_sz);
				return $this->warning('Warning', 200, $return_arr);
			}
			else
				return $this->success('Success', 200, $return_arr);
		} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	public function get_resent_attachment($select,$batch_id,$deleted_attachments = array()){
		$condition = "rfa_esl_batch_id={$batch_id}";
		if(isset($deleted_attachments) && !empty($deleted_attachments)){
			$deleted_attachment = array_map(function($e){
			($e = decrypt_link($e));
					return($e);
			}, $deleted_attachments);
			$deleted_attachment = implode(',', $deleted_attachment);
			$condition .= " AND rfa_id NOT IN (" . $deleted_attachment . ")";
		}
		$get_attch		=	Resent_forward_emails_attachments::get_all_records($select, $condition);
		return $get_attch;
	}
	public function get_reply_attachment($select,$condition_array){
		$condition = "emat_id IN {$condition_array}";
		$Email_attachments = new \App\Models\Email_attachments;
		$get_attch		=	$Email_attachments::get_all_records($select, $condition);
		return $get_attch;
	}
	public function load_resent_attachments($batch_id){
		$current_user = $this->get_current_user_details();
		$email_log_details = Email_send_log::get_all_records('esl_id,esl_user_id,esl_article_id,esl_batch_id,esl_attachments',"esl_batch_id={$batch_id}");
		$email_log_attach_arr = array_unique(array_column(json_decode(json_encode($email_log_details), TRUE), 'esl_attachments'));
		$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
		$prefixPath = storage_path()  . $file_storage_path;
		if(count($email_log_attach_arr)>0){
			$email_log_attach_id_arr = [];
			foreach($email_log_attach_arr as $email_log_attach){
				$email_log_attachments = json_decode($email_log_attach);
				if((isset($email_log_attachments->article)&&!empty($email_log_attachments->article)) || (isset($email_log_attachments->modified)&&!empty($email_log_attachments->modified))){
					$email_log_attachments_ids =  (isset($email_log_attachments->article) && !empty($email_log_attachments->article) ? $email_log_attachments->article : array());
					if(empty($email_log_attachments_ids)){
						$email_log_attachments_ids =  (($email_log_attachments->modified));
					}
					foreach($email_log_attachments_ids as $k => $v){
						$email_log_attach_id_arr[] = $k;
					}
					$email_attachments_details = Email_attachments::get_all_records('emat_id,emat_file_name,emat_ane_id,emat_agf_id,emat_ade_id,emat_art_id,emat_document_size,emat_posted_by', 'emat_id IN (' . implode(',',$email_log_attach_id_arr) .') AND emat_art_id = ' . $email_log_details[0]->esl_article_id );
					if(count($email_attachments_details)> 0){
						foreach($email_attachments_details as $email_attachment){
							if(!empty($email_attachment->emat_ade_id)){
								$article_notification = Adhoc_notification_emails::get_single_record('ade_art_id,ade_usr_id,ade_from',"ade_id={$email_attachment->emat_ade_id}");
								$attachment_file_name = $email_attachment->emat_file_name;
								$source_path = $prefixPath . APP_DOC_PATH . 'adhoc_attachments/' . $article_notification->ade_from . '/' . $article_notification->ade_usr_id . '/' .$attachment_file_name;
								$resent_attachment_exist = Resent_forward_emails_attachments::get_single_record('rfa_id',"rfa_esl_batch_id = ". $batch_id . " AND rfa_file_name ='" .$attachment_file_name . "'");

								if (file_exists($source_path)&& empty($resent_attachment_exist)) {
									$destination_base_path = $prefixPath . APP_DOC_PATH .  'email_attachments/' . $article_notification->ade_art_id;
									$upload_base_path = APP_DOC_PATH .  'email_attachments/' . $article_notification->ade_art_id;
									if (!file_exists($destination_base_path)) {
										mkdir($destination_base_path, 0765, TRUE);
									}
									$destination_path = $destination_base_path . '/' . $attachment_file_name;
									if (file_exists($destination_path)) {
										$i = 1;
										$got_new_file = FALSE;
										while ($got_new_file == FALSE) {
											$ext = pathinfo($destination_path, PATHINFO_EXTENSION);
											$file_name = basename($attachment_file_name, '.' . $ext);
											$resent_attachment_exist = Resent_forward_emails_attachments::get_single_record('rfa_id',"rfa_esl_batch_id = ". $batch_id . " AND rfa_file_name ='" . $file_name . ' (' . $i . ').' . $ext . "'");
											if(!empty($resent_attachment_exist)){
												//print_r($resent_attachment_exist);die;
												$got_new_file = TRUE;
											}
											if (!file_exists($destination_base_path . '/' . $file_name . ' (' . $i . ').' . $ext)) {
												$got_new_file = TRUE;
												$attachment_file_name = $file_name . ' (' . $i . ').' . $ext;
											}
											$i++;
										}
										$destination_path = $destination_base_path . '/' . $attachment_file_name;
									}
									$upload_path = $upload_base_path . '/' . $attachment_file_name;

									if (copy($source_path, $destination_path)) {
										$insert_data = array(
											'rfa_article_id' => $article_notification->ade_art_id,
											'rfa_user_id' => $article_notification->ade_from,
											'rfa_esl_batch_id' => $batch_id,
											'rfa_file_name' => $attachment_file_name,
											'rfa_document_size' => $email_attachment->emat_document_size,
											'rfa_attachment_path' => $upload_path,
											'rfa_posted_by' => $current_user['user_id'],
											'rfa_posted_date' => date('Y-m-d H:i:s'),
											'rfa_proxy_id' => $current_user['proxy_user_id'],
										);
										Resent_forward_emails_attachments::insert_record($insert_data, $current_user);
									}
									// print_r(($attachment_file_name));die;
								}
							}else {
								$resent_attachment_exist = Resent_forward_emails_attachments::get_single_record('rfa_id',"rfa_esl_batch_id = ". $batch_id . " AND rfa_file_name ='" . $email_attachment->emat_file_name . "'");

								if(!empty($email_attachment->emat_art_id) && empty($resent_attachment_exist) ){
									$insert_data = array(
										'rfa_article_id' => $email_attachment->emat_art_id,
										'rfa_user_id' => $email_attachment->emat_posted_by,
										'rfa_esl_batch_id' => $batch_id,
										'rfa_file_name' => $email_attachment->emat_file_name,
										'rfa_document_size' => $email_attachment->emat_document_size,
										'rfa_attachment_path' => APP_DOC_PATH .  'email_attachments/' . $email_attachment->emat_art_id . '/' . $email_attachment->emat_file_name,
										'rfa_posted_by' => $current_user['user_id'],
										'rfa_posted_date' => date('Y-m-d H:i:s'),
										'rfa_proxy_id' => $current_user['proxy_user_id'],
									);
									Resent_forward_emails_attachments::insert_record($insert_data, $current_user);
								}
							}

						}
						// die;
					}
				}

			}
		}
	}
	public function get_event_email_info(Request $request)
	{
		try{
			$post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'user_id' => 'required',
				'art_id'  => 'required',
				'role_id' => 'required',
				'stageid' => 'required',
			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			$userarray = array('input'=>$post_data['user_id'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlidarray = array('input'=>$post_data['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
			$artidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>TRUE );
			$roleidarray = array('input'=>$post_data['role_id'],'type'=>'number', 'enc_data'=>TRUE );
			$stageidarray = array('input'=>$post_data['stageid'],'type'=>'number', 'enc_data'=>TRUE );
			$jnlcodearray = array('input'=>$post_data['jnl_code']);

			$useridvalidation= $this->Rv_validator($userarray);
			$jnlidvalidation= $this->Rv_validator($artidarray);
			$artidvalidation= $this->Rv_validator($jnlidarray);
			$roleidvalidation= $this->Rv_validator($roleidarray);
			$stageidvalidation= $this->Rv_validator($stageidarray);
			$jnlcodevalidation= $this->Rv_validator($jnlcodearray);
			if($useridvalidation != TRUE || $jnlidvalidation != TRUE || $artidvalidation != TRUE || $roleidvalidation != TRUE || $stageidvalidation != TRUE || $jnlcodevalidation != TRUE){
				return $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}

			$user_id = isset($post_data['user_id']) ? decrypt_link($post_data['user_id']): '';
			$art_id = isset($post_data['art_id']) ? decrypt_link($post_data['art_id']): '';
			$role_id = isset($post_data['role_id']) ? decrypt_link($post_data['role_id']): '';
			$stage_id = isset($post_data['stageid']) ? decrypt_link($post_data['stageid']): '';
			$jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']): '';
			$jnl_code = isset($post_data['jnl_code']) ? decrypt_link($post_data['jnl_code']): '';

			if ($user_id == '' || $art_id == '' || $role_id == '' || $stage_id == '')
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			$this->current_user=$this->get_current_user_details();
			$Email_templates = new \App\Models\Email_templates;
			$Users=new \App\Models\User();
			$Roles = new \App\Models\Roles();
			$Articles = new \App\Models\Articles;

			$email_data			=	$Email_templates::get_single_record_with_bind_cond('etmp_id,etmp_name,etmp_templete_name,etmp_notification,etmp_cust_to,etmp_cc,etmp_cust_cc,etmp_bcc,etmp_cust_bcc,etmp_subject,etmp_email_template', array(
				'etmp_name' => 'change_assign'
			));
			if (!empty($email_data))
			{


				$email_data->email_templates_config = $this->email_templates_config();
				$email_data->join_config = $this->join_config();
				$email_data->join_dependency_config = $this->join_dependency_config();
				if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
					$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
				$assign_user_data = $Users::get_single_record_with_bind_cond('*,CONCAT_WS(" ",usr_first_name,usr_middle_name,usr_last_name) as assignee_full_name', array(
					'usr_id' => $user_id
				));

				$role_data = $Roles::get_single_record_with_bind_cond('role_name', array(
					'role_id' => $role_id
				));

				$article_type_data = $Articles::get_single_record_with_bind_cond('art_artp_id', array(
					'art_id' => $art_id
				));
				$subject = $email_data->etmp_subject;
				$body = $email_data->etmp_email_template;
				$email_data->ASSIGN_USER_FULL_NAME = $assign_user_data->assignee_full_name;
				$email_data->ASSIGN_USER_ROLE = $role_data->role_name;
				$email_data->article_id = $art_id;
				$email_data->aflw_id = $stage_id;
				$email_data->jnl_journal_code = $jnl_code;
				$email_data->mail_recipient_ids = $user_id;
				$email_data->artp_id = $article_type_data->art_artp_id;
				$email_data->user_id = $user_id;

				//generate_email_data_from_keys
				$assign_user = array(
					'user_id' => $user_id
				);
				$email_data->status_link_blind_event = TRUE;
				$email_data->mail_type = 'edit';
				$email_data->subject = strip_tags($this->generate_email_data_from_keys($email_data, $subject, $assign_user));
				$user_titles  =$this->UserConfigdata('titles')['titles'];
				$email_data->body = $this->generate_email_data_from_keys($email_data, $body,$this->current_user, $user_titles, TRUE);
				preg_match_all('/##([^##]*)##/', $email_data->body, $matches);
				$keys = $matches[1];

				for ($i = 0; $i < count($keys); $i++) {
					$element = $keys[$i];
					if (!empty($element)) {
						$tmpl_data = str_ireplace('##' . $element . '##', '<button contenteditable="false">' . $element . '</button>',$email_data->body);
						$email_data->body = $tmpl_data;
					}
				}
				$b_body = str_ireplace('##', '', $email_data->body);
				$b_bodyview =  str_ireplace('<button contenteditable="false"><button contenteditable="false">', '<button contenteditable="false">', $b_body);
				$email_body =  str_ireplace('</button></button>', '</button>', $b_bodyview);
				$email_data->body = $email_body;
				$email_template_data = $this->get_event_email_template_form($assign_user_data, $email_data, $email_data->subject, $email_data->body,$jnl_id);
				$email_template_data['emtp_id']=$email_data->etmp_id;
				$return_arr['email_template_with_data'] = $email_template_data;
			}
			else
			{
				$return_arr = array(
					'status' => 'template_err',
					'email_template' => "Please add an email template for the Article assignment event"
				);
			}

			return $this->success('Success', 200, $return_arr);

		} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	public function get_event_email_template_form($user_data, $template_data, $subject, $body,$jnl_id)
	{
		$Roles = new \App\Models\Roles();
		$user_data->user_titles =$this->UserConfigdata('titles')['titles'];
		$user_data->modal_title = 'Email Info';
		$array_data['user_id']      = $user_data->usr_id;
		$array_data['salutation']   = TRUE;
		$array_data['fullname_only']   = TRUE;
    	$user_data->full_name = $this->get_user_display_name($array_data);
		$user_info = $user_data;

		$template_data->cfty_disable_email_cc_bcc_editable = $disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;

		$reply_to =$this->get_reply_to_email($jnl_id);


		$to_cc_arr = json_decode($template_data->etmp_cc);
		$to_bcc_arr = json_decode($template_data->etmp_bcc);
		$cc_roles = array();
		$bcc_roles = array();

			if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
			{
			$roles = $Roles::get_all_records('role_name, role_assigned_role',"role_assigned_role NOT IN ('system', 'reviewer')");
			if (!empty($roles))
			{
				foreach ($roles as $usrole)
				{

					$usrole->role_label = "";
					if ($usrole->role_assigned_role != 'author')
					{
						$usrole->role_label = "All " . $usrole->role_name . "s";
					}
					else if ($usrole->role_assigned_role == 'author')
					{
						$usrole->role_label = 'Corresponding Author';
					}
					else
					{
						$usrole->role_label = $usrole->role_name;
					}

					$cc_roles[$usrole->role_name] = $usrole->role_label;
					$bcc_roles[$usrole->role_name] = $usrole->role_label;
				}
			}
			$cc_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
			$bcc_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
		    }
			$cc_roles['Custom_cc'] = 'Specific email ID';
			$bcc_roles['Custom_bcc'] = 'Specific email ID';
		$data_arr = array(
			'cc_roles' => $cc_roles,
			'bcc_roles' => $bcc_roles,
			'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
			'to_cc' => $to_cc_arr,
			'to_bcc' => $to_bcc_arr,
			'cust_cc' => $template_data->etmp_cust_cc,
			'cust_bcc' => $template_data->etmp_cust_bcc,
			'reply_to' => $reply_to,
			'subject' => $subject,
			'user' => $user_data->usr_id,
			'content' => $body,
			'user_info' => $user_info,
			'reply_to' => $reply_to

		);

		$template_info = $data_arr;

		return $template_info;
	}
	public function remove_reply_email_attachments(Request $request)
	{
		try {
			$reply_data = $request->all();
			$array_attach_id = '';
			$validator = Validator::make($request->all(), [
				'article_id' => 'required',
				'atmn_id' => 'required',
			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}

			$attachArray = json_decode(decrypt_link($reply_data['attach_array']));
			if(count($attachArray) > 0){
				$array_attach_id = '(' . implode(',', $attachArray) . ')';
			}else{
				$array_attach_id = NULL;
			}
			$articleidarray = array('input'=>$reply_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
			$articleidvalidation= $this->Rv_validator($articleidarray);
			if($articleidvalidation != TRUE ){
				return  $this->warning('Warning',200,trans('viewarticle.invalid_data'),'Warning');
			}
			$art_id = decrypt_link($reply_data['article_id']); 
			$this->current_user = $this->get_current_user_details();
			
			$email_attachments = new \App\Models\Email_attachments;
			$emat_id = decrypt_link($reply_data['atmn_id']);
			$email_attach_criteria = "emat_id={$emat_id}";
			$get_attchments = $email_attachments::get_single_record('emat_file_name,emat_art_id',$email_attach_criteria);
			if (isset($get_attchments)) {
				$path = public_path() . "/storage/uploads/email_attachments/{$get_attchments->emat_art_id}/";
				$aws_path = "uploads/email_attachments/{$get_attchments->emat_art_id}/";
				$this->remove_fileinfolder($path, $get_attchments->emat_file_name, $aws_path);
				$email_attachments::delete_records("emat_id={$emat_id}", '', $this->current_user);	
			}
			$array_attach_id = '';
			$array_attach_data = [];
			if(count($attachArray)>0){
				$select_attach = 'emat_id as ane_id,emat_file_name as ane_name, IF(emat_document_size IS NULL, 0, emat_document_size) as document_size';
				$array_attach_id = '(' . implode(',', $attachArray) . ')';
				$attachments = $this->get_reply_attachment($select_attach,$array_attach_id);
				if(!empty($attachments)){
					foreach ($attachments as $attachment) {
						array_push($array_attach_data,$attachment->ane_id);
						$attachment->rfa_attachment_path = 'uploads/email_attachments/'.$art_id.'/'.$attachment->ane_name;
					}
				}
			}
			else{
				$attachments = [];
			}
			$attch_file_html	=     $attachments;
			$rtn_arr = array( 'status' => 'success');
			$rtn_arr['attch_file_html'] = $attch_file_html;	
			$rtn_arr['attch_file_data'] = $array_attach_data;	

			return $this->success('Success', 200, $rtn_arr);
		} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	public function remove_all_reply_email_attachments(Request $request)
	{
		try {
			$reply_data = $request->all();
			$validator = Validator::make($request->all(), [
				'article_id' => 'required',
			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			$articleidarray = array('input'=>$reply_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
			$articleidvalidation= $this->Rv_validator($articleidarray);
			if($articleidvalidation != TRUE ){
				return  $this->warning('Warning',200,trans('viewarticle.invalid_data'),'Warning');
			}
			$this->current_user = $this->get_current_user_details();
			$email_attachments = new \App\Models\Email_attachments;
			$attach_id_array = json_decode(decrypt_link($reply_data['atmnt_ary']));
			if(count($attach_id_array) > 0){
				foreach($attach_id_array as $attach_id) {
					$email_attach_criteria = "emat_id={$attach_id}";
					$get_attchments = $email_attachments::get_single_record('emat_file_name,emat_art_id',$email_attach_criteria);
					if (isset($get_attchments)) {
						$path = public_path() . "/storage/uploads/email_attachments/{$get_attchments->emat_art_id}/";
						$aws_path = "uploads/email_attachments/{$get_attchments->emat_art_id}/";
						$this->remove_fileinfolder($path, $get_attchments->emat_file_name, $aws_path);
						$email_attachments::delete_records("emat_id={$attach_id}", '', $this->current_user);	
					}
				}
			}
			$rtn_arr = array( 'status' => 'success');
			return $this->success('Success', 200, $rtn_arr);
		} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}

	public function save_adhoc_email(Request $request)
	{
		try{
			$adhoc_data =  $request->all();
			$optccvalue = [];
			if (isset($adhoc_data['adhoc_cust_cc'])&&!empty($adhoc_data['adhoc_cust_cc']) && $adhoc_data['adhoc_cc'] != '' && (in_array('Custom_cc',$adhoc_data['adhoc_cc'])||in_array('Custom',$adhoc_data['adhoc_cc']))) {
				$custm_cc = $adhoc_data['adhoc_cust_cc'];
				for ($i = 0; $i < count($custm_cc); $i++) {
					$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
					$cust_value = str_replace('\\', '"', $cust_value);
					$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

					array_push($optccvalue, $cust_value);

				}
				$adhoc_data['adhoc_cust_cc'] = implode(',', $optccvalue);

			}
			else{
				$adhoc_data['adhoc_cust_cc']='';
			}

			$optbccvalue = array();
			if (isset($adhoc_data['adhoc_cust_bcc'])&&!empty($adhoc_data['adhoc_cust_bcc']) && $adhoc_data['adhoc_bcc'] != '' && (in_array('Custom_bcc',$adhoc_data['adhoc_bcc'])||in_array('Custom',$adhoc_data['adhoc_bcc']))) {
				$custm_bcc = $adhoc_data['adhoc_cust_bcc'];
				for ($i = 0; $i < count($custm_bcc); $i++) {
					$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
					$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
					$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

					array_push($optbccvalue, $cust_bcc_value);

				}
				$adhoc_data['adhoc_cust_bcc'] = implode(',', $optbccvalue);
			}
			else{
				$adhoc_data['adhoc_cust_bcc']='';
			}
			// task id  6597 start
			$ade_id = $this->save_adhoc_email_notification($adhoc_data);
			// task id  6597 end
						return $this->success('Success', 200, $ade_id);

					} catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	public function check_merged_users_mail_id($email_to_address)
	{
		$merge_user_table = new \App\Models\Merged_users;
		$Users=new \App\Models\User();
		$to_array = explode(',', $email_to_address);
		$email_to_address_array = array();
		foreach ($to_array as $key => $email_address) {
			$email_address = trim($email_address);
			$merged_user_data = $merge_user_table::get_single_record('musr_master_usr_id', "musr_email = '{$email_address}'");
			if (isset($merged_user_data) && isset($merged_user_data->musr_master_usr_id) && $merged_user_data->musr_master_usr_id) {
				$usr_mail_data = $Users::get_single_record('usr_email', "usr_id = {$merged_user_data->musr_master_usr_id}");
				if (isset($usr_mail_data) && isset($usr_mail_data->usr_email) && $usr_mail_data->usr_email != '') {
					array_push($email_to_address_array, $usr_mail_data->usr_email);
				}
			} else {
				array_push($email_to_address_array, $email_address);
			}
		}
		$unique_email_to_address_array = array_unique($email_to_address_array);
		$email_to_address_data = implode(',', $unique_email_to_address_array);
		$recipient_id_array = array();
		foreach ($unique_email_to_address_array as $key => $value) {
			$recipient_id_data = $Users::get_single_record('usr_id AS recipient_id', "usr_email = '{$value}' ");
			if(isset($recipient_id_data->recipient_id) && $recipient_id_data->recipient_id){
				array_push($recipient_id_array, $recipient_id_data->recipient_id);
			}
		}
		$recipient_ids = implode(',', $recipient_id_array);
		$return_array = array(
			'esl_to' => $email_to_address_data,
			'recipient_ids' => $recipient_ids
		);
		return $return_array;
	}
	public function get_adhoc_all_info(Request $request)
	{
		try {
			$post_data = $request->all();

			$Users = new \App\Models\User();
			$Articles = new \App\Models\Articles;
			$Authors = new \App\Models\Authors;
			$Email_templates = new \App\Models\Email_templates;

			$this->current_user = $this->get_current_user_details();
			$validator = Validator::make($request->all(), [
				'artid' => 'required',
				'jnl_code' => 'required',
				'jnl_id' => 'required',
				'usr_id' => 'required',

			]);

			if ($validator->fails()) {
				return $this->failure('Failed', 422, $validator->errors());
			}

			$articleidarray = array('input' => $post_data['artid'], 'type' => 'number', 'enc_data' => TRUE);
			$jnlidarray = array('input' => $post_data['jnl_id'], 'type' => 'number', 'enc_data' => TRUE);
			$useridarray = array('input' => $post_data['usr_id'], 'type' => 'number', 'enc_data' => TRUE);
			$jnlcodearray = array('input' => $post_data['jnl_code'], 'type' => 'string', 'enc_data' => TRUE);
			$articleidvalidation = $this->Rv_validator($articleidarray);
			$jnlidvalidation = $this->Rv_validator($jnlidarray);
			$useridvalidation = $this->Rv_validator($useridarray);
			$jnlcodevalidation = $this->Rv_validator($jnlcodearray);

			/*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
			if (isset($post_data['flow_id']) && $post_data['flow_id'] != '') {
				$aflwidarray = array('input' => $post_data['flow_id'], 'type' => 'number', 'enc_data' => TRUE);
				$aflwidarrayvalidation = $this->Rv_validator($aflwidarray);
				if ($aflwidarrayvalidation != TRUE) {
					return $this->warning('Warning', 200, customTrans('viewarticle.invalid_data'), 'Warning');
				}
			}
			/* End TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
			if ($articleidvalidation != TRUE || $jnlidvalidation != TRUE || $useridvalidation != TRUE || $jnlcodevalidation != TRUE) {
				return $this->warning('Warning', 200, customTrans('viewarticle.invalid_data'), 'Warning');
			}
			$jnlcodevalid = $this->validatecode(array('jnl_code' => $post_data['jnl_code']), TRUE);
			if ($jnlcodevalid['jnl_code'] != TRUE) {
				return $this->warning('Warning', 200, customTrans('viewarticle.invalid_data'), 'Warning');
				exit;
			}
			if (isset($form_data['jnl_id'])) {
				$jnlidvalid = $this->validatecode(array('jnl_id' => $form_data['jnl_id']), false);
				if ($jnlidvalid['jnl_id'] != TRUE) {
					return $this->warning("Warning", 200, customTrans('viewarticle.invalid_data'), 'Warning');
					exit;
				}
			}
			$template_id = isset($post_data["template_id"]) ? ($post_data["template_id"]) : "";
			$jnl_code = isset($post_data['jnl_code']) ? decrypt_link($post_data['jnl_code']) : '';
			$userid = decrypt_link($post_data["usr_id"]);
			$art_id = decrypt_link($post_data["artid"]);

			$article_data = $Articles::get_article_data($art_id);

			$article_privilages = $this->article_privilages($article_data, NULL, $jnl_code);
			$user_access = FALSE;
			if ($article_privilages['privilaged'] == TRUE) {
				$user_access = TRUE;
				if (isset($article_privilages['author']) && $article_privilages['author'] == TRUE) {
					$user_access = FALSE;
				}

			}
			$adhoc_mail_for_author = false;

			//fetch all authors included in that article
			$Authors = new \App\Models\Authors();
			$fetch_authors_arr = $Authors::get_all_records('auth_usr_id', 'auth_art_id=:art_id', NULL, NULL, '', NULL, NULL, 'ASC', array('art_id' => $art_id));
			$authors_arr = array_column(json_decode(json_encode($fetch_authors_arr), True), 'auth_usr_id');
			if ($article_privilages['author'] == TRUE && (isset($this->current_client->functionality->cfty_enable_adhoc_mail_for_author) && $this->current_client->functionality->cfty_enable_adhoc_mail_for_author == 'y') && (in_array($this->current_user['user_id'], $authors_arr) == TRUE)) {
				$adhoc_mail_for_author = true;
			}
			if ($user_access != true && $adhoc_mail_for_author == false) {
				return $this->failure('Unauthorized', 200, 'Unauthorized User');
			}

			if ($template_id != "") {
				$art_id = decrypt_link($post_data['artid']);
			}
			$user = $Users::get_single_record_with_bind_cond('usr_username,usr_first_name,usr_last_name,usr_email', array('usr_id' => $userid));
			$array_data['user_id'] = $userid;
			$array_data['article_id'] = $art_id;

			$user->full_name = $this->get_user_display_name($array_data);
			$user->user_titles = $this->UserConfigdata('titles')['titles'];
			$user->modal_title = 'Send Ad hoc Email';
			$user_info = $user;

			$tmpl_condition = array('etmp_name' => 'adhoc_email', 'etmp_notification' => 'User');
			$alltemplate = $Email_templates::get_all_records_with_bind_cond('etmp_id,etmp_templete_name', $tmpl_condition);
			$all_templates = '';
			if (count($alltemplate) > 0) {
				$all_templates = $alltemplate;
				$return_arr = array(
					'user_info' => $user_info,
					'all_templates' => $all_templates,
				);
			} else {
				$return_arr = array(
					'status' => 'template_err',
					'user_info' => $user_info,
					'msg' => 'No email template defined'
				);
			}
			return $this->success("Success", 200, $return_arr);
		} catch (Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
    // TASK #9425 Convey Integration In Review3
	public function sendConveyDisclosureEmail($discloser_id,$etmp_name,$type='',$post_data=''){
		try
		{
			$Email_templates = new \App\Models\Email_templates();
			$Articles = new \App\Models\Articles();
			$ConveyData_table = new \App\Models\ConveyData();

			$email_template_data = $Email_templates::get_single_record('*',"etmp_name='{$etmp_name}'");
 			if(!empty($email_template_data) && isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y')
			{			
				$convey_article_details = $ConveyData_table::where('rcd_discloser_id',$discloser_id)->get(['rcd_id','rcd_usr_id','rcd_art_id','rcd_discloser_list_id','rcd_discloser_id','rcd_disclosure_id','rcd_last_invited_date','rcd_disclosure_cmpltn_status']);
				$send_mail_to = '';
				$send_mail_to_usr_ids = '';
				$cfty_retire_role = FALSE;
				$article_details = $Articles::where('art_id',$convey_article_details[0]->rcd_art_id)->get('art_artp_id')->first();	
				if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
				{
					$cfty_retire_role = TRUE;
				}
				$jnl_journal_code = $Articles::get_art_jnl_column_val($convey_article_details[0]->rcd_art_id, 'jnl_journal_code');				
				$send_mail_to_detail = $this->send_email_to($email_template_data->etmp_notification,$jnl_journal_code,$article_details->art_artp_id,$convey_article_details[0]->rcd_art_id,$cfty_retire_role ); 
				if(!empty($send_mail_to_detail['usr_ids']))
				{
					$send_mail_to = explode(',',$send_mail_to_detail['email_ids']);
					$send_mail_to_usr_ids = explode(',',$send_mail_to_detail['usr_ids']);
				}
				$link = app(ConveyService::class)->getDiscloserLink($convey_article_details[0]->rcd_discloser_list_id, $discloser_id);
				
				$custom_data = array(
					'user_email'=>$send_mail_to_detail['email_ids'],
					'etmp_notification' => $email_template_data->etmp_notification,
					'mail_recipient_ids'=> $post_data?$convey_article_details[0]->rcd_usr_id:$send_mail_to_detail['usr_ids'],
					'jnl_code'=>$jnl_journal_code,
					'article_id'=>$convey_article_details[0]->rcd_art_id,
					'artp_id'=>$article_details->art_artp_id,
					'convey_link_to_disclose'=>$link?$link:'',
					'api_name'=>$type ?? '',
					'esl_etmp_action' => 'convey_mail',

				);

				$email_data = array(
					'type' => $post_data?'custom':'global',
					'email_temp'=>$post_data?'global':'',
					'action' => 'send',
					'user_id'=> session('user_id') ?? $convey_article_details[0]->rcd_usr_id,
					'post_data'=>$post_data?$post_data:'',
					'email_with_login' =>$type!='cron_job'? TRUE:FALSE,
					'empt_name' => $email_template_data->etmp_name,
					'template' => $email_template_data->etmp_name,
					'article_id'=>$convey_article_details[0]->rcd_art_id,
					'custom_data' => $custom_data
				);
				$this->master_email_details($email_data);
					
			}
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',422,$e);
		}
	}

	public function checkAndEmailAuthorListChange($art_id)
	{
		$change = AuthorHistory::isAuthorsListChanged($art_id);
		if($change['changed'] ?? false){
			$email_template_data = Email_templates::get_single_record('*',"etmp_name='author_list_update'");
			if($email_template_data){
				if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
				{
					$cfty_retire_role = TRUE;
				}
				$article_details = Articles::where('art_id',$art_id)->get('art_artp_id')->first();
				$jnl_journal_code = Articles::get_art_jnl_column_val($art_id, 'jnl_journal_code');
				$send_mail_to_detail = $this->send_email_to($email_template_data->etmp_notification,$jnl_journal_code,$article_details->art_artp_id,$art_id,$cfty_retire_role );

				if(!empty($send_mail_to_detail['usr_ids']))
				{
					$send_mail_to = explode(',',$send_mail_to_detail['email_ids']);
					$send_mail_to_usr_ids = explode(',',$send_mail_to_detail['usr_ids']);
				}

				$author_list_change_string = '';

				if($change['authors_added']){
					$author_list_change_string = "{$change['authors_added']} authors added";
				}
				if($change['authors_removed']){
					if($author_list_change_string != ''){
						$author_list_change_string .= ' and ';
					}
					$author_list_change_string .= "{$change['authors_removed']} authors removed";
				}
				if($change['authors_order_changed']){
					$author_list_change_string = 'Order of author list has been changed';
				}
				$custom_data = array(
					'user_email'=>$send_mail_to_detail['email_ids'],
					'etmp_notification' => $email_template_data->etmp_notification,
					'mail_recipient_ids'=> $send_mail_to_detail['usr_ids'],
					'jnl_code'=>$jnl_journal_code,
					'article_id'=>$art_id,
					'artp_id'=>$article_details->art_artp_id,
					'author_list_change'=> $author_list_change_string,
				);

				$email_data = array(
					'type' => 'global',
					'action' => 'send',
					'user_id'=> session('user_id') ?? 0,
					'email_with_login' => FALSE,
					'empt_name' => $email_template_data->etmp_name,
					'custom_data' => $custom_data
				);

				$this->master_email_details($email_data);
			}
		}
	}
	// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory			
	public function get_all_customform_files($data)
	{
		$customform_details = array();
		$customform_attachments = array();
		$showflag=false;
		$element_viewstatus = false;
		$art_id = $data['art_id'] ?? '';
		$jnl_code = $data['jnl_code'] ?? '';
		$role_id = $data['role_id'] ?? '';
		$core_role = $data['core_role'] ?? '';
		$Stage_email_templates = new \App\Models\Stage_email_templates();
		$Generic_form_files = new \App\Models\Generic_form_files;
		$Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
		$Article_flow_table = (new \App\Models\Article_flow)->getTable();
		$user_table = (new \App\Models\User())->getTable();
		$Generic_form_files_table = (new \App\Models\Generic_form_files())->getTable();
		if (!empty($art_id) && !empty($jnl_code)) {
			$platform_data = $this->platform_basic_settings_data($jnl_code);
			$jnl_id = $platform_data->jnl_id;
			$date_format = $this->get_platform_date_format($jnl_id);
			$date_format = date_format_map($date_format);
			$review_method = '';
			$select = 'art_code,art_title,art_abstract,art_artp_id,art_article_upload_path';
			$get_article_details = Articles::get_single_record($select, "art_id={$art_id}");
			if (!empty($get_article_details)) {
				$Article_types = new \App\Models\Article_type_advance_options();
				$article_type_data = $Article_types::get_single_record('atotp_review_method', "atotp_artp_id=:atotp_artp_id", null, '', null, array("atotp_artp_id" => $get_article_details->art_artp_id));
				if (!empty($article_type_data)) {
					$review_method = $article_type_data->atotp_review_method;
				}
			}
			$tables = array(
				'main_table' => $Generic_flows_table,
				'join_table' => array(
					$Article_flow_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id', "inner")
				)
			);
			$select = 'DISTINCT(aflw_jwf_id) as aflw_jwf_id,jwf_stage_name,jwf_stage_type,jwf_role_id';
			$where = 'aflw_art_id=' . $art_id . ' AND aflw_usr_id IS NOT null AND aflw_status = "c" ';
			$journal_wfids = Generic_flows::get_results_using_joins($tables, $select, $where);
			if (!empty($journal_wfids)) {
				foreach ($journal_wfids as $jwf) {
					$stage_form_result = $Stage_email_templates::get_generic_form_data_files_allcustoms($art_id, $jnl_code, $jwf->aflw_jwf_id);
					if (!empty($stage_form_result)) {
						foreach ($stage_form_result as $stg) {
							if ($stg->gdata_element_type == 'file') {
								$element_viewstatus = FALSE;
								$condition = "art_id=:mainart_id";
								$condition_arr = array(
									'mainart_id' => $art_id
								);
								$article_data = Articles::get_article_details('artp_jpm_id,artp_id,art_version_no,art_id,artp_fwm_id,art_status,aflw_parent_flow_id,jwf_stage_type,art_code,art_delete_status,aflw_status', $condition, null, true, false, null, $condition_arr);
								$article_data = $article_data[0];
								$article_privilages = $this->article_privilages($article_data, null, $jnl_code);
								if ($article_privilages['privilaged'] == TRUE) {
									$user_access = TRUE;
									if (isset($article_privilages['author']) && $article_privilages['author'] == TRUE) {
										$user_access = FALSE;
									}
								}
								$emt_viewable_rls = explode(',', $stg->gdata_user_roles);
								if (in_array($role_id, $emt_viewable_rls) || (empty($stg->gdata_user_roles) && $user_access == TRUE)) {
									$element_viewstatus = TRUE;
								}
								if ($stg->gdata_dynamic_status == 'y') {
									$temp_arr = json_decode($stg->gdata_data);
									$commaSeparatedValues = '';
									// Iterate through the array and concatenate values with commas
									foreach ($temp_arr as $subArray) {
										$commaSeparatedValues .= implode(',', $subArray) . ',';
									}
									$commaSeparatedValues = rtrim($commaSeparatedValues, ',');
									// Print the comma-separated values
									$file_ids = $commaSeparatedValues;
								} else {
									$file_ids = ($stg->gdata_data != "") ? join(",", array_filter(json_decode($stg->gdata_data))) : '';
								}
								if ($file_ids != "" && isset($get_article_details->art_article_upload_path)) {
									$selectdata = 'agf_name,agf_id,agf_file_size,agf_label,DATE_FORMAT(agf_file_uploaded_date, "' . $date_format . '") as agf_file_uploaded_date,CONCAT(usr_first_name," ",usr_last_name) as posted_user,usr_id';
									$wherecondition = 'agf_id in (' . $file_ids . ') ';
									$tablesdata = array(
										'main_table' => $Generic_form_files_table,
										'join_table' => array(
											$user_table => array($user_table . '.usr_id', $Generic_form_files_table . '.agf_posted_by', "inner")
										)
									);
									$file_details = $Generic_form_files::get_results_using_joins($tablesdata, $selectdata, $wherecondition, 'all');
									if (!empty($file_details)) {
										foreach ($file_details as $ft) {
											$customform_attachments[$ft->agf_id]['document_size'] = $ft->agf_file_size;
											$customform_attachments[$ft->agf_id]['atmnt_file_name'] = $ft->agf_name;
											$customform_attachments[$ft->agf_id]['path'] = $this->get_upload_path('uploads/' .  $get_article_details->art_article_upload_path . '/' . $ft->agf_name, true);
											$customform_attachments[$ft->agf_id]['atmnt_id'] = $ft->agf_id;
											$customform_attachments[$ft->agf_id]['art_id'] = $art_id;
											$customform_attachments[$ft->agf_id]['jnl_code'] = $jnl_code;
											$customform_attachments[$ft->agf_id]['posted_user'] = $ft->posted_user;
											if (!empty($review_method)) {
												if (($review_method == 's' || $review_method == 'd') && $core_role == 'author' && isset($jwf->jwf_stage_type) && $jwf->jwf_stage_type == 'review') {
													if (isset($jwf->jwf_role_id) && !empty($jwf->jwf_role_id)) {
														$name = Roles::find($jwf->jwf_role_id, ['role_name'])?->role_name;
													} else {
														$name = '';
													}
													$customform_attachments[$ft->agf_id]['posted_user'] = $name;
												}
												if ($review_method == 'c') {
													$is_blinded = $this->is_custom_blinded($jwf->jwf_role_id, $art_id, artp: $get_article_details->art_artp_id, jnl: $jnl_code, blinded_user: $ft->usr_id);
													if ($is_blinded) {
														$customform_attachments[$ft->agf_id]['posted_user'] = $is_blinded;
													}
												}
											}
											$customform_attachments[$ft->agf_id]['jwf_stage_name'] = $jwf->jwf_stage_name;
											$customform_attachments[$ft->agf_id]['custom_filedescription'] = $ft->agf_label;
											$customform_attachments[$ft->agf_id]['agf_file_uploaded_date'] = $ft->agf_file_uploaded_date;
											$customform_attachments[$ft->agf_id]['attachment_type'] = 'Custom Form';
											$showflag = true;
										}
									}
								}
							}
						}
					}
				}
			}
			$customform_details = array(
				'customform_attachments' => $customform_attachments ?? '',
				'element_viewstatus' => $element_viewstatus ?? '',
				'showflag' => $showflag ?? '',

			);
			return $customform_details;
		}
	}
	/*
	 To keep the cc , bcc and cotent loading issue after adding attachments form inventory files issue fix => data upadating withrespect to the saved template data.
	 Update template contents when attach files into mails from inventory 
	*/
	public function update_template_data($template_data, $saved_temp_data)
	{
		$template_data->stage_etmp_subject = (isset($saved_temp_data['saved_template_subject']) && $saved_temp_data['saved_template_subject'] != '') ? $saved_temp_data['saved_template_subject'] : $template_data->stage_etmp_subject;
		$template_data->stage_etmp_content = (isset($saved_temp_data['saved_template_content']) && $saved_temp_data['saved_template_content'] != '') ? $saved_temp_data['saved_template_content'] : $template_data->stage_etmp_content;
		$template_data->stage_etmp_cc = (isset($saved_temp_data['saved_template_cc']) && $saved_temp_data['saved_template_cc'] != '') ? $saved_temp_data['saved_template_cc'] : $template_data->stage_etmp_cc;
		$template_data->stage_etmp_bcc = (isset($saved_temp_data['saved_template_bcc']) && $saved_temp_data['saved_template_bcc'] != '') ? $saved_temp_data['saved_template_bcc'] : $template_data->stage_etmp_bcc;
		$template_data->stage_etmp_cust_cc = (isset($saved_temp_data['saved_template_cust_cc']) && $saved_temp_data['saved_template_cust_cc'] != '') ? $saved_temp_data['saved_template_cust_cc'] : $template_data->stage_etmp_cust_cc;
		$template_data->stage_etmp_cust_bcc = (isset($saved_temp_data['saved_template_cust_bcc']) && $saved_temp_data['saved_template_cust_bcc'] != '') ? $saved_temp_data['saved_template_cust_bcc'] : $template_data->stage_etmp_cust_bcc;
		return $template_data;
	}

}
