<?php

namespace App\Http\Controllers;

use App\Http\Traits\GeneralEmailTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Http\Traits\UserDataTrait;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\WorkflowDataTrait;
use App\Http\Traits\WorkflowTrait;
use App\Models\Article_type_advance_options;
use App\Models\Email_templates;
use App\Models\Generic_flows;
use App\Models\Roles;
use App\Models\Stage_email_templates;
use App\Models\Stage_email_tmpl_reference;
use App\Models\General_permission;
use App\Models\Journals;
use Config;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class Manage_Email_Templates_Api extends Controller
{
    use UtilityTrait;
    use UserDataTrait;
    use WorkflowDataTrait;
    use RolesConfigTrait;
    use WorkflowTrait;
    use GeneralEmailTrait;
    /*
    Get golbal email template list
    commited date :-  8-03-2022
    Request type :- POST
     */
    public function index(Request $request)
    {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
				'sort_field' => 'required',
				'sort_order' => 'required'

			]);
			if ($validator->fails()) {
				return $this->failure('Failed', 422, $validator->errors());
			}
			$sortorderarray = array('input'=>$form_data['sort_order']);
			$sortfieldarray = array('input'=>$form_data['sort_field']);

			$sortordervalidation= $this->Rv_validator($sortorderarray);
			$sortfieldvalidation= $this->Rv_validator($sortfieldarray);

			if($sortordervalidation != TRUE || $sortfieldvalidation != TRUE ){
                return $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}
            $sort_field = (isset($form_data['sort_field'])) ? $form_data['sort_field'] : 'etmp_id';
            $sort_order = (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'ASC';
            $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 5;
            $criteria = 'etmp_platform = "g" ';
            if (isset($this->current_client->functionality->cfty_import_stage_data_from_ftp_location) && $this->current_client->functionality->cfty_import_stage_data_from_ftp_location != 'y')
            {
                $criteria .= ' AND etmp_name != "stage_import_email" ';
            }
        if(isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion != 'y')
        {
            $criteria .= ' AND etmp_name != "start_generic_discussion" AND etmp_name != "generic_discussion_comment" AND etmp_name != "close_generic_discussion" AND etmp_name != "generic_discussion_updation" AND etmp_name != "discussion_mail"';
        }
            $select = "*";
            $userslist = Email_templates::get_paginated_records($select, $criteria, $sort_field, $sort_order, $limit);
            $data = [];
            return $this->success('success', 200, $userslist);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
    Get stage type email template list
    commited date :-  22-03-2022
    Request type :- POST
     */
    public function get_stage_based_email_templates(Request $request)
    {

        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
				'sort_field' => 'required',
				'sort_order' => 'required'

			]);
			if ($validator->fails()) {
				return $this->failure('Failed', 422, $validator->errors());
			}
			$sortorderarray = array('input'=>$form_data['sort_order']);
			$sortfieldarray = array('input'=>$form_data['sort_field']);

			$sortordervalidation= $this->Rv_validator($sortorderarray);
			$sortfieldvalidation= $this->Rv_validator($sortfieldarray);

			if($sortordervalidation != TRUE || $sortfieldvalidation != TRUE ){
                return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
			}
            $search_parameters = (isset($form_data['paramsdet'])) ? $form_data['paramsdet'] : array();
            $jnl_id = (isset($form_data['jnlparam'])) ? $this->decrypt_data($form_data['jnlparam']) : 'NULL';
            if (!empty($search_parameters)) {
                if (isset($search_parameters)) {
                    $stage_type = $search_parameters;
                }
            }
            $stage_email_table = (new \App\Models\Stage_email_templates())->getTable();
            $journals_table = (new \App\Models\Journals())->getTable();
            $sort_field = (isset($form_data['sort_field'])) ? $form_data['sort_field'] : 'stage_etmp_id';
            $sort_order = (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'asc';
            $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
            if (isset($this->current_client->functionality->cfty_allow_journal_wise_data_to_sa) && $this->current_client->functionality->cfty_allow_journal_wise_data_to_sa == 'y') {
                $avail_jnls = Journals::get_single_record('GROUP_CONCAT(DISTINCT jnl_id) as ids', "jnl_standalone = 'n'");
                $criteria = (isset($form_data['jnlparam'])) ? "stage_etmp_journal_id = {$jnl_id}" : "(stage_etmp_journal_id IN ({$avail_jnls->ids}) OR stage_etmp_journal_id IS {$jnl_id})";
            }
            else{
                $criteria = (isset($form_data['jnlparam'])) ? "stage_etmp_journal_id = {$jnl_id}":"stage_etmp_journal_id IS {$jnl_id}";
            }

            if (isset($stage_type) && $stage_type != '') {
                $criteria .= ' AND stage_etmp_stage_type = "' . $stage_type . '"';
            }

            $select = "*";
            $tables = array(
                'main_table' => $stage_email_table,
                'join_table' => $journals_table,
                'column_prefix1' => $stage_email_table . '.stage_etmp_journal_id',
                'column_prefix2' => $journals_table . '.jnl_id',
            );
            $userslist = Stage_email_templates::get_results_join_pagination($tables, $select, $criteria, null, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $userslist);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
Get email_hooks from utility traits
commited date :-  8-03-2022
Request type :- GET
 */
    public function getutility(Request $request)
    {
        try {
            $select = 'email_hooks';
            $hookvalue = $this->Utility($select);
            $emailhook = [];
            if (!empty($hookvalue)) {
                foreach ($hookvalue['email_hooks'] as $key => $val) {
                    if (isset($key) && isset($val['name'])) {
                        $tmp_name = $val['name'];
                        $emailhook[$key] = $tmp_name;
                    }
                }
            }
            return $this->success('success', 200, $emailhook);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
    Get email_hooks from utility traits
    commited date :-  8-03-2022
    Request type :- post
     */
    public function getstagetype(Request $request)
    {
        try {
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow = Config::get($workflow_config);

            $reviewflow = [];
            if (!empty($review_flow)) {
                foreach ($review_flow as $key => $val) {
                    if (isset($key) && isset($val['label'])) {
                        $tmp_name = $val['label'];
                        $reviewflow[$key] = $tmp_name;
                    }
                }
            }
            return $this->success('success', 200, $reviewflow);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
Get existing_hooks from datatable
commited date :-  28-03-2022
Request type :- Post
 */
    public function get_existing_email_hooks(Request $request)
    {
        try {

            $select = "email_hooks";
            $hookvalue = $this->Utility($select);
            $emailhook = [];
            $em_hooks = [];
            $existing_hooks = Email_templates::get_all_records('etmp_name');
            if (!empty($hookvalue)) {
                foreach ($existing_hooks as $key => $value) {
                    $exist_hooks[] = $value->etmp_name;
                }
            }
            if (!empty($hookvalue)) {
                foreach ($hookvalue['email_hooks'] as $key => $val) {
                    if (in_array($key, $exist_hooks)) {
                        continue;
                    }

                    $em_hooks[$key] = $val;
                }
            }
            $adhoc_array=array('name'=>'Adhoc email');
            $em_hooks['adhoc_email']=$adhoc_array;
            //1.Feature #1493   JPR-100 - Re-assigning Users on Articles
            if ($this->current_client->functionality->cfty_change_assignment == 'n') {
                unset($em_hooks['change_assign']);
            }

            /* Do  not list Withdraw emails if the client functonlaity is not enabled */
            if ($this->current_client->functionality->cfty_enable_article_withdraw == 'n') {
                unset($em_hooks['author_withdrawal']);
                unset($em_hooks['withdraw_article_author']);
                unset($em_hooks['withdraw_article_privileged']);
                unset($em_hooks['undo_withdraw_article_author']);
                unset($em_hooks['undo_withdraw_article_privileged']);
            }

            if (isset($this->current_client->functionality->cfty_biorxiv) && $this->current_client->functionality->cfty_biorxiv != 'y') {
                unset($em_hooks['b2j_corr_author_mail']);
                unset($em_hooks['b2j_failure_mail']);
                unset($em_hooks['b2j_submission_mail']);
            }
            if (isset($this->current_client->modules->mdl_publons) && $this->current_client->modules->mdl_publons != 'y') {
                unset($em_hooks['publons_mail']);
            }

            if (isset($this->current_client->functionality->cfty_enable_article_delete) && $this->current_client->functionality->cfty_enable_article_delete != 'y') {
                unset($em_hooks['delete_article']);
                unset($em_hooks['undo_delete_article']);
            }
            if (isset($this->current_client->functionality->cfty_merge_user) && $this->current_client->functionality->cfty_merge_user != 'y') {
                unset($em_hooks['merge_notification']);
            }
            if (isset($this->current_client->functionality->cfty_disable_reviewer_on_fly_email) && $this->current_client->functionality->cfty_disable_reviewer_on_fly_email == 'y') {
                unset($em_hooks['reviewer_on_fly']);
                unset($em_hooks['reviewer_on_fly_awaiting_confirm']);
            }
            if (isset($this->current_client->functionality->cfty_import_stage_data_from_ftp_location) && $this->current_client->functionality->cfty_import_stage_data_from_ftp_location != 'y')
            {
                unset($em_hooks['stage_import_email']);
            }
            if(isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion != 'y')
            {
                unset($em_hooks['start_generic_discussion']);
                unset($em_hooks['generic_discussion_comment']);
                unset($em_hooks['close_generic_discussion']);
                unset($em_hooks['generic_discussion_updation']);
                unset($em_hooks['discussion_mail']);
            }
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference != 'y'){
                unset($em_hooks['batch_article_reviewer_assignment']);
            }
            return $this->success('success', 200, $em_hooks);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
    Get userrole based on hook selected
    commited date :-  28-03-2022
    Request type :- post
     */
    public function get_email_hook_based_userroles(Request $request)
    {
        try {
            $hook_name = $request->all();
            $select = "email_hooks";
            $email_hooks = $this->Utility($select);
            $Roles_table = (new \App\Models\Roles())->getTable();
            $selectedEmailtemplate=$hook_name['params']['selected']??'';
            $hook_data = $email_hooks['email_hooks'][$selectedEmailtemplate]??'';
            $user_roles = $usr_roles = array();
            $userroles = array();
            $data = array();
            $recipient_roles = array();
            $return_arr = array();
            $toNoteArr = array();
            $hook_recipient = $hook_data['to']??[];
            if (!$hook_data) {
                return  $this->failure('Failed', 422, 'Invalid Hook Data');
            }
            if (isset($hook_data['generic_template'])) {
                $user_role = $this->UserConfigdata('managing_roles');
                $remove_roles = array(
                    "sudo" => "Super User"
                );
                $display_role = array_diff_key($user_role['managing_roles'], $remove_roles);
                $usr_roles = array_values($display_role);
                if (!empty($usr_roles)) {
                    foreach ($usr_roles as $us) {
                        $user_roles[$us] = $us;
                    }
                }
            } else {
                $special_cases = ['withdraw_article_privileged', 'undo_withdraw_article_privileged', 'author_withdrawal'];
                $excluded_roles = ['system', 'author', 'reviewer'];
                $query = in_array($selectedEmailtemplate, $special_cases) ? 'SELECT * FROM ' . $Roles_table . ' WHERE `role_assigned_role` NOT IN ("' . implode('","', $excluded_roles) . '")' : 'role_assigned_role NOT IN ("system", "reviewer")';
                $roles = in_array($selectedEmailtemplate, $special_cases) ? Roles::get_records_by_raw_query($query) : Roles::get_all_records('*', $query);
                if (!empty($roles)) {
                    foreach ($roles as $usrole) {
                        $usrole->role_label = "";
                        if ($usrole->role_assigned_role != 'author' && $usrole->role_assigned_role != 'system') {
                            $usrole->role_label = "All " . $usrole->role_name . "s";
                        } elseif ($usrole->role_assigned_role == 'author') {
                            $usrole->role_label = 'Corresponding Author';
                        } else {
                            $usrole->role_label = $usrole->role_name;
                        }
                    }
                }

                foreach ($roles as $role) {
                    $user_roles[$role->role_name] = $role->role_label;
                }
                $user_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
            }
            $user_roles['User'] = 'Stage User';
            $additional_roles = [
                'discussion_mail', 'reopen_review', 'retire_user_roles', 'rejoin_user_roles', 
                'unregister_notification', 'manage_user_keywords', 'start_generic_discussion', 
                'generic_discussion_comment', 'close_generic_discussion', 'generic_discussion_updation'
            ];
            if (in_array($selectedEmailtemplate, $additional_roles)) {
                $user_roles['Users'] = 'Users';
            }
            //1.Feature #1493   JPR-100 - Re-assigning Users on Articles
            $special_recipient_roles = [
                'change_assign' => ['change_user' => 'Assign user'],
                'author_invitation' => ['Author' => 'Corresponding Author']
            ];            
            $recipient_roles = $special_recipient_roles[$selectedEmailtemplate] ?? [];
            if ($selectedEmailtemplate === 'b2j_submission_mail') {
                unset($user_roles['User'], $user_roles['article_authors'], $user_roles['Author']);
            }
            if (!empty($hook_recipient)) {
                foreach ($hook_recipient as $recipient) {
                    if (array_key_exists($recipient, $user_roles)) {
                        $recipient_roles[$recipient] = $user_roles[$recipient];
                    }
                }
            } else {
                $recipient_roles = $user_roles;
            }

            /* Task 6000 - Task to get permitted user dropdown */
            $pUDropdown = permittedUserGlobalMail($selectedEmailtemplate,true);
            if($pUDropdown['status']){
                $recipient_roles['permitted_user'] = $pUDropdown['label'];
                $toNoteArr['permitted_user'] = $pUDropdown['note'];
                $return_arr['to_note'] = $toNoteArr;
            }
            // TASK #8907 contact us mail            
            $replay_to_email = $this->get_reply_to_email();
            if($selectedEmailtemplate == 'add_contact_us_mail' && $replay_to_email =='')
            {
                $recipient_roles = array();
                $recipient_roles['Custom_to'] = 'Specific email ID';
            }
            // Task #539 Mail fro organizer to cp team member
            if($selectedEmailtemplate=='send_notification_to_user'){
                $recipient_roles['staff'] = 'CP Team member';
            }
            $cc_roles = $bcc_roles = $user_roles;
            $cc_roles['Custom_cc'] = 'Specific email ID';
            $bcc_roles['Custom_bcc'] = 'Specific email ID';
            $return_arr['recipient_roles'] = $recipient_roles;
            $return_arr['cc_roles'] = $cc_roles;
            $return_arr['bcc_roles'] = $bcc_roles;
            // TASK #8907 contact us mail
            $return_arr['replay_to_email'] = $replay_to_email;

            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
    Save global email template
    Commited date :-  18-04-2022
    Request type :- POST
     */
    public function save_global_email(Request $request)
    {
        try {
            $success = false;
            $message = '';
            $this->current_user = $this->get_current_user_details();
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'email_hook_select' => 'required',
                'subject' => $form_data['email_hook_select']=='add_contact_us_mail'?'':'required',// TASK #8907 contact us mail
                'email_body' => 'required',
                'to_mail' =>'required',// TASK #69 contact us mail (task #8907)
                'remind_days' =>$form_data['email_hook_select']=='reminder_disclosure_convey_email'? 'required':'',// TASK #9425 Convey Integration In Review3
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $edited_id = $this->decrypt_data($form_data['edited_id']);
            $tmpl_cc = "";
            $tmpl_bcc = "";
            $tmpl_to = "";
            $remind_days = '';// TASK #9425 Convey Integration In Review3 
            $replace_button = array('<button contenteditable="false">', '</button>');
            $replaceval = str_replace($replace_button, '##', $form_data['email_body']);
            $email_body = $replaceval;
            if (isset($form_data['cc']) && !empty($form_data['cc'])) {
                $tmpl_cc = json_encode($form_data['cc']);
            }
            if (isset($form_data['bcc']) && !empty($form_data['bcc'])) {
                $tmpl_bcc = json_encode( $form_data['bcc']);
            }
            if (isset($form_data['event_templ_name']) && !empty($form_data['event_templ_name'])) {
                $templ_name = ( $form_data['event_templ_name']);
            }
            $event_templ_name = isset($templ_name) ? ($templ_name) : '';
            $etmp_cc = isset($tmpl_cc) ? ($tmpl_cc) : '';
            $etmp_bcc = isset($tmpl_bcc) ? ($tmpl_bcc) : '';
            // TASK #8907 contact us mail
            $opttovalue = array();
			if (isset($form_data['cust_to'])&&!empty($form_data['cust_to'])&&(($form_data['to_mail']=='Custom_to')||($form_data['to_mail']=='Custom'))) {
				$custm_to = $form_data['cust_to'];
				for ($i = 0; $i < count($custm_to); $i++) {
					$cust_value = isset($custm_to[$i]['value']) ? $custm_to[$i]['value'] : $custm_to[$i];
					$cust_value = str_replace('\\', '"', $cust_value);
					$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

					array_push($opttovalue, $cust_value);


				}
				$form_data['cust_to'] = implode(',', $opttovalue);

			}
			else{
				$form_data['cust_to']='';
			}
            $optccvalue = array();
			if (isset($form_data['cust_cc'])&&!empty($form_data['cust_cc'])&&(in_array('Custom_cc',$form_data['cc'])||in_array('Custom',$form_data['cc']))) {
				$custm_cc = $form_data['cust_cc'];
				for ($i = 0; $i < count($custm_cc); $i++) {
					$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
					$cust_value = str_replace('\\', '"', $cust_value);
					$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

					array_push($optccvalue, $cust_value);


				}
				$form_data['cust_cc'] = implode(',', $optccvalue);

			}
			else{
				$form_data['cust_cc']='';
			}
			$optbccvalue = array();
			if (isset($form_data['cust_bcc'])&&!empty($form_data['cust_bcc'])&&(in_array('Custom_bcc',$form_data['bcc'])||in_array('Custom',$form_data['bcc']))) {
				$custm_bcc = $form_data['cust_bcc'];
				for ($i = 0; $i < count($custm_bcc); $i++) {
					$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
					$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
					$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

					array_push($optbccvalue, $cust_bcc_value);

				}
				$form_data['cust_bcc'] = implode(',', $optbccvalue);
			}
			else{
				$form_data['cust_bcc']='';
			}
            $cust_cc = '';
            if (isset($form_data['cust_cc'])&&!empty($form_data['cust_cc'])) {
                $cust_cc = $form_data['cust_cc'];
            }
            $cust_bcc = '';
            if (isset($form_data['cust_bcc'])&&!empty($form_data['cust_bcc'])) {
                $cust_bcc = $form_data['cust_bcc'];
            }
            // TASK #9425 Convey Integration In Review3            
            if (isset($form_data['remind_days'])&&!empty($form_data['remind_days'])) {
                $remind_days = $form_data['remind_days'];
            }
            $data = array(
                'etmp_name' => $form_data['email_hook_select'],
                'etmp_templete_name' => $event_templ_name,
                'etmp_notification' => $form_data['to_mail'],// TASK #69 contact us mail (task #8907)
                'etmp_cust_to' => $form_data['cust_to'],
                'etmp_content_type' => '',
                'etmp_cc' => $etmp_cc,
                'etmp_cust_cc' => $cust_cc,
                'etmp_bcc' => $etmp_bcc,
                'etmp_cust_bcc' => $cust_bcc,
                'etmp_subject' => $form_data['subject']?$form_data['subject']:'',// TASK #8907 contact us mail
                'etmp_email_template' => $email_body,
                'etmp_remind_days'=> $remind_days?$remind_days :'',// TASK #9425 Convey Integration In Review3 
            );
            $email_criteria = 'etmp_name= "' . $form_data['email_hook_select'] . '"';
            if ($edited_id != '') {
                $email_criteria .= ' AND etmp_id !=' . $edited_id;
            }

            $check_hook_mail = Email_templates::get_single_record('count(*) count', $email_criteria);
            if ($check_hook_mail->count > 0 && $form_data['email_hook_select'] !== 'adhoc_email') {
                return response()->json([
                    'success' => false,
                    'message' => customTrans('email_template.email_tmpl_error'),
                    'responsecode' => 422,
                ]);
            } else {
                $check_template_name = array();
                if ($event_templ_name !== "") {
                    $email_criteria = 'etmp_templete_name= "' . $event_templ_name . '"';
                    if ($edited_id != '') {
                        $email_criteria .= ' AND etmp_id !=' . $edited_id;
                    }
                    $check_template_name = Email_templates::get_single_record('etmp_id', $email_criteria);
                }
                if ($edited_id == '') {

                    if (isset($check_template_name)&&!empty($check_template_name)) {
                        $message = customTrans('email_template.email_tmpl_name_error');
                        $success = false;
                        $status = 'duplicate';
                    } else {

                        $insert = Email_templates::insert_record($data, $this->current_user);
                        $message = customTrans('email_template.email_save');
                        $success = true;
                    }
                } else {

                    if (empty($check_template_name) || (!empty($check_template_name) && $check_template_name->etmp_id === $edited_id)) {
                        $criteria = 'etmp_id= ' . $edited_id;
                        $update = Email_templates::update_record($data, $criteria, $this->current_user);
                            $message = customTrans('email_template.email_tmpl_updated');
                            $success = true;
                        } else {
                            $message = customTrans('email_template.email_tmpl_error');
                            $success = false;
                    }
                }
                return response()->json([
                    'success' => $success,
                    'message' => $message,
                    'responsecode' => 201,
                ]);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', $e, 500);
        }
    }
    /* Get Current User Details*/
    public function geteditedglobalemaildetails(Request $request)
    {
        try {
            $get_data = $request->all();
            $etmp_id = $this->decrypt_data($get_data['params']['etmp_id']);
            $criteria = 'etmp_id =' . $etmp_id;
            $globalemaildet = Email_templates::get_single_record('*', $criteria);
            $email_hooks = $this->Utility("email_hooks");
            $email_all_keys = array_keys($email_hooks['email_hooks']);
            $email_key = $email_all_keys[array_search($globalemaildet->etmp_name, $email_all_keys)];
            $email_temp_name = $email_hooks['email_hooks'][$email_key]['name'];
            $return_arr['globalemaildet'] = $globalemaildet;
            $return_arr['temp_name'] = $email_temp_name;
            preg_match_all('/##([^##]*)##/', $globalemaildet->etmp_email_template, $matches);
            $keys = $matches[1];

            for ($i = 0; $i < count($keys); $i++) {
                $element = $keys[$i];
                if (!empty($element)) {
                    $tmpl_data = str_ireplace('##' . $element . '##', '<button contenteditable="false">' . $element . '</button>',  $globalemaildet->etmp_email_template);
                    $globalemaildet->etmp_email_template = $tmpl_data;
                }
            }
            if(isset($globalemaildet->etmp_cust_bcc))
				{$globalemaildet->etmp_cust_bcc = explode(',', $globalemaildet->etmp_cust_bcc);}
				if(isset($globalemaildet->etmp_cust_cc))
				{$globalemaildet->etmp_cust_cc = explode(',', $globalemaildet->etmp_cust_cc);}
                // TASK #8907 contact us mail
                if(isset($globalemaildet->etmp_cust_to))
				{$globalemaildet->etmp_cust_to = explode(',', $globalemaildet->etmp_cust_to);}
            $email_body = str_ireplace('##', '', $globalemaildet->etmp_email_template);
            $return_arr['etmp_email_template'] = $email_body;
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /* Get Current stage email Details*/
    public function geteditedstageemaildetails(Request $request)
    {
        try {
            $get_data = $request->all();
            $stage_etmp_id = $this->decrypt_data($get_data['params']['stage_etmp_id']);

            $criteria = 'stage_etmp_id =' . $stage_etmp_id;
            $globalemaildet = Stage_email_templates::get_single_record('*', $criteria);
            preg_match_all('/##([^##]*)##/', $globalemaildet->stage_etmp_content, $matches);
            $keys = $matches[1];
            for ($i = 0; $i < count($keys); $i++) {
                $element = $keys[$i];
                if (!empty($element)) {
                    $tmpl_data = str_ireplace('##' . $element . '##', '<button contenteditable="false">' . $element . '</button>',  $globalemaildet->stage_etmp_content);
                    $globalemaildet->stage_etmp_content = $tmpl_data;
                }
            }
            $reminder_to_complete = $this->Utility('reminder_to_complete');
            $reminder_to_accept = $this->Utility('reminder_to_accept');
            $reminder_to_shortlist = $this->Utility('reminder_to_shortlist');
            $reminder_to_invite = $this->Utility('reminder_to_invite');
            if(isset($globalemaildet->stage_etmp_cust_cc))
            {$globalemaildet->stage_etmp_cust_cc = explode(',', $globalemaildet->stage_etmp_cust_cc);}
            if(isset($globalemaildet->stage_etmp_cust_bcc))
            {$globalemaildet->stage_etmp_cust_bcc = explode(',', $globalemaildet->stage_etmp_cust_bcc);}
            if(isset($globalemaildet->stage_etmp_cust_to))
				{$globalemaildet->stage_etmp_cust_to = explode(',', $globalemaildet->stage_etmp_cust_to);}
            $globalemaildet->reminder_to_accept = $reminder_to_accept['reminder_to_accept'];
            $globalemaildet->reminder_to_complete = $reminder_to_complete['reminder_to_complete'];
            $globalemaildet->reminder_to_shortlist = $reminder_to_shortlist['reminder_to_shortlist'];
            $globalemaildet->reminder_to_invite = $reminder_to_invite['reminder_to_invite'];
            $stage_email_body = str_ireplace('##', '', $globalemaildet->stage_etmp_content);
            $return_arr['globalemaildet'] = $globalemaildet;
            $return_arr['stage_email_body'] = $stage_email_body;
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function show_roles_template($stage_type = NULL, $action = NULL, $jnl_id = NULL, $jwf_id = NULL, $art_type = NULL)
    {
        try {

            $client_code = $this->current_client->clnt_client_code;
            $workflow_config = 'clients.' . $client_code . '.workflow_config.review_flow';
            $review_flow = Config::get($workflow_config);
            if (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n') {
                $stages = array();
                foreach ($review_flow as $k => $v) {
                    if (isset($v['stage_for']) && $v['stage_for'] == 'review') {
                        $stages[$k] = $v;
                    }
                }
                $review_flow = $stages;
            }
            $select = "reminder_format";
            $reminder_format = $this->Utility('reminder_format');
            if (isset($stage_type)) {
                $reviewflow = $review_flow[$stage_type];
                $event = $review_flow[$stage_type]['possible_email_tmpl_actions'];
                //get stage actions -- start
                $stage_actions = $reviewflow['possible_email_tmpl_actions'];
                if ($this->current_client->modules->mdl_casrai_credit == 'n' || ($this->current_client->modules->mdl_casrai_credit == 'y' && (!isset($reviewflow['enable_casrai_credits_confirm']) || $reviewflow['enable_casrai_credits_confirm'] == false))) {
                    if (isset($stage_actions['confirm_casrai'])) {
                        unset($stage_actions['confirm_casrai']);
                    }
                }
                if ($this->current_client->modules->mdl_orcid == 'n' || ($this->current_client->modules->mdl_orcid == 'y' && (!isset($reviewflow['enable_orcid_confirm']) || $reviewflow['enable_orcid_confirm'] == false))) {
                    if (isset($stage_actions['confirm_orcid'])) {
                        unset($stage_actions['confirm_orcid']);
                    }
                }
                if ($art_type != null) {

                    $permission_roles = Article_type_advance_options::get_single_record('atotp_rescind_article,atotp_reset_article', array(
                        'atotp_artp_id' => $art_type
                    ));
                    if (isset($stage_actions['rescind_source']) && $permission_roles->atotp_rescind_article == null) {
                        unset($stage_actions['rescind_source']);
                        unset($stage_actions['rescind_destination']);
                    }
                    if (isset($stage_actions['reset']) && $permission_roles->atotp_reset_article == null) {
                        unset($stage_actions['reset']);
                    }
                    if ($jwf_id != null) {
                        $assignment_type = Generic_flows::get_single_record('jwf_parent_user_roles, jwf_who_can_invite, jwf_role_id,jwf_assignment', array(
                            'jwf_id' => $jwf_id
                        ));
                        $stage_role = $assignment_type->jwf_role_id;
                        if ($assignment_type->jwf_assignment == 'manual' || $assignment_type->jwf_assignment == 'invitation') {
                            $assign_permission_role = json_decode($assignment_type->jwf_parent_user_roles);
                            if ($assignment_type->jwf_assignment == 'invitation') {
                                $invite_permission_role = json_decode($assignment_type->jwf_who_can_invite);
                            }
                        }
                        if (isset($stage_actions['accepted']) && $assignment_type->jwf_assignment == 'self_service') {
                            unset($stage_actions['accepted']);
                            unset($stage_actions['declined']);
                            unset($stage_actions['assigned_not_accepted']);
                            unset($stage_actions['unassign_user']);
                        }
                    }
                }
                $return_arr['stage_actions'] = $stage_actions;
                //get stage actions -- end
                $cc_bcc_roles = array();
                $possible_roles = array(); //get all possible roles --start
                //1. stage role
                if (in_array('author', $reviewflow['roles']) || $stage_type == 'accept' || $stage_type == 'reject' || $stage_type == 'decision_revision' || $stage_type == 'aop_publish' || $stage_type == 'publish' || $stage_type == 'review') {
                    $possible_roles['User'] = 'Submitting author';
                    if ($stage_type == 'accept' || $stage_type == 'reject' || $stage_type == 'resubmission' || $stage_type == 'decision_revision' || $stage_type == 'review') {
                        unset($possible_roles['User']);
                        $possible_roles['submit_author'] = 'Submitting author';
                    }

                    $possible_roles['Author'] = 'Corresponding author';
                    if ($stage_type != 'aop_publish' && $stage_type != 'publish') {
                        $possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
                    }
                }

                if ($stage_type == 'staff_check' || $stage_type == 'pre_assessment' || $stage_type == 'post_assessment'){
                    $possible_roles['submit_author'] = 'Submitted author';
                    $possible_roles['Author'] = 'Corresponding author';
                    $possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
                }
                if (!in_array('system', $reviewflow['roles']) && (!in_array('author', $reviewflow['roles']))) {
                    $possible_roles['User'] = 'Stage assigned user';
                }
                $role_used = $this->RolesConfigdata('privileged_user_roles');
                $privileged_roles = $role_used['privileged_user_roles'];
                $role_cond = 'role_assigned_role NOT IN ("system", "author")';
                if (isset($reviewflow['stage_for'])) {
                    if ($reviewflow['stage_for'] == 'review') {
                        $role_cond .= ' and FIND_IN_SET("r", role_used_in)';
                    } elseif ($reviewflow['stage_for'] == 'manageproduction') {
                        $role_cond .= ' and FIND_IN_SET("p", role_used_in)';
                    }
                }

                $user_roles = Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                if (!empty($user_roles)) {
                    foreach ($user_roles as $usrole) {
                        if (in_array($usrole->role_assigned_role, $privileged_roles) || ($usrole->role_assigned_role == 'reviewer' && in_array('reviewer', $reviewflow['roles']))) {
                            $is_stage_user = '';
                            if (isset($stage_role) && $stage_role == $usrole->role_id) {
                                $is_stage_user = 'stage user role,';
                            }

                            if (isset($assign_permission_role) && !empty($assign_permission_role) && in_array($usrole->role_id, $assign_permission_role)) {
                                $is_stage_user .= 'assign permission,';
                            }

                            if (isset($invite_permission_role) && !empty($invite_permission_role) && in_array($usrole->role_id, $invite_permission_role)) {
                                $is_stage_user .= 'invite permission,';
                            }

                            if ($is_stage_user != '') {
                                $is_stage_user = ' (' . rtrim($is_stage_user, ',') . ')';
                            }

                            $role_label = "All " . strtolower($usrole->role_name) . "s" . $is_stage_user;
                            $possible_roles[$usrole->role_name] = $role_label;
                            $bcc_roles[$usrole->role_name] = $cc_roles[$usrole->role_name] = $role_label;
                        }
                    }
                    $possible_roles['Custom_to'] = $bcc_roles['Custom_bcc'] = $cc_roles['Custom_cc'] = 'Specific email ID';
                }
            } else {
                $event[] = [];
                $cc_roles[] = [];
                $bcc_roles[] = [];
                $possible_roles[] = [];
            }
            $return_arr['review_flow'] = $review_flow;
            $return_arr['reminder_format'] = $reminder_format['reminder_format'];
            $return_arr['event'] = $event;
            $return_arr['cc_roles'] = $cc_roles;
            $return_arr['bcc_roles'] = $bcc_roles;
            $return_arr['possible_roles'] = $possible_roles;
            $return_arr['cc_bcc_roles'] = $bcc_roles;
            return $return_arr;
        } catch (Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function stage_template_design(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $get_data = $request->all();
            if (!(isset($get_data['data']['type'])) || $get_data['data']['type'] != 'global') {
                if ($get_data['data']['stage_etmp_id']) {
                    $email_tmpl_id = $this->decrypt_data($get_data['data']['stage_etmp_id']);
                }
                if (!empty($email_tmpl_id)) {
                    // $criteria = 'stage_etmp_id =' . $email_tmpl_id;
                    $criteria = 'stage_etmp_id = ?';
                    $get_record = Stage_email_templates::get_single_record('*', $criteria,binding_arr:[$email_tmpl_id]);
                    $return_arr['stage_actions'] = $return_arr['possible_roles'] = array();
                    $get_record->stage_etmp_cc = json_decode($get_record->stage_etmp_cc);
                    $get_record->stage_etmp_bcc = json_decode($get_record->stage_etmp_bcc);


                    preg_match_all('/##([^##]*)##/', $get_record->stage_etmp_content, $matches);
                    $keys = $matches[1];

                    for ($i = 0; $i < count($keys); $i++) {
                        $element = $keys[$i];
                        if (!empty($element)) {
                            $tmpl_data = str_ireplace('##' . $element . '##', '<button contenteditable="false">' . $element . '</button>', $get_record->stage_etmp_content);
                            $get_record->stage_etmp_content = $tmpl_data;
                        }
                    }
                    $b_body = str_ireplace('##', '', $get_record->stage_etmp_content);
                    $b_bodyview =  str_ireplace('<button contenteditable="false"><button contenteditable="false">', '<button contenteditable="false">', $b_body);
                    $email_body =  str_ireplace('</button></button>', '</button>', $b_bodyview);
                    $get_record->stage_etmp_content = $email_body;

                    $get_record->cc_roles = $get_record->bcc_roles = array();
                    $get_actions_role = $this->show_roles_template($get_record->stage_etmp_stage_type, $get_record->stage_etmp_action);
                    if (!empty($get_actions_role)) {
                        $reminder = '';
                        if ($get_record->stage_etmp_action == 'assigned_not_accepted' || $get_record->stage_etmp_action == 'accepted_not_completed' || $get_record->stage_etmp_action == 'pnd_reviewer_shortlist' || $get_record->stage_etmp_action == 'pnd_reviewer_invite') {
                            $remind_aftr_str = $get_record->stage_etmp_remind_after;
                            $str_to_append = '';
                            if (($remind_aftr_str != '' || $remind_aftr_str != NULL) && $get_record->stage_etmp_reminder_format == 'after') {
                                if ($get_record->stage_etmp_action == 'assigned_not_accepted')
                                $utility_action =  $this->Utility('reminder_to_accept')['reminder_to_accept'];
                                elseif ($get_record->stage_etmp_action == 'accepted_not_completed')
                                $utility_action =   $this->Utility('reminder_to_complete')['reminder_to_complete'];
                                elseif ($get_record->stage_etmp_action == 'pnd_reviewer_shortlist')
                                $utility_action =   $this->Utility('reminder_to_shortlist')['reminder_to_shortlist'];
                                elseif ($get_record->stage_etmp_action == 'pnd_reviewer_invite')
                                $utility_action =   $this->Utility('reminder_to_invite')['reminder_to_invite'];
                                $str_to_append = 'of ' . $utility_action[$remind_aftr_str];
                            }
                            if ($get_record->stage_etmp_reminder_format == 'on_due_date') {
                                $reminder1 = $this->Utility('reminder_format');
                                $reminder = ' [ ' . $reminder1['reminder_format']['on_due_date'] . ']';
                            } else {
                                $reminder1 = $this->Utility('reminder_format');
                                $reminder = ' [ ' . $reminder1['reminder_format'][$get_record->stage_etmp_reminder_format] . ' ' . $get_record->stage_etmp_remind_days . ' day(s) ' . $str_to_append . ']';
                            }
                        }
                        if (isset($get_record->stage_etmp_action) && $get_record->stage_etmp_action == 'document_queue_updated')
                            $reminder = ' [ ' . $get_record->stage_etmp_remind_months . ' Month(s) ]';
                        $get_record->stage_etmp_action = $get_actions_role['stage_actions'][$get_record->stage_etmp_action] . $reminder;
                        if (!empty($get_record->stage_etmp_to)) {
                            if ($get_record->stage_etmp_to != 'Custom') {
                                if(in_array($get_record->stage_etmp_stage_type, array('reject', 'accept', 'resubmission')) &&( $get_record->stage_etmp_action == "On complete" || $get_record->stage_etmp_action == "On stage initialization" )){ //TASK #6401 Create a new tag for informing Reviewers about the final decision
                                    $get_actions_role['possible_roles']['submitted_reviewers']='All submitted reviewers';
                                }
                                if (isset($get_actions_role['possible_roles'][$get_record->stage_etmp_to]))
                                    $get_record->stage_etmp_to = $get_actions_role['possible_roles'][$get_record->stage_etmp_to];
                                // else
                                //     $get_record->stage_etmp_to = '';
                            } else {
                                $get_record->stage_etmp_to = 'Custom';
                                if (!empty($get_record->stage_etmp_cust_to))
                                    $get_record->stage_etmp_to = $get_record->stage_etmp_cust_to;
                            }
                        }
                        if (!empty($get_record->stage_etmp_cc)) {

                            foreach ($get_record->stage_etmp_cc as $cc) {
                                if (isset($get_actions_role['cc_roles'][$cc]) && ($cc != 'Custom' && $cc != 'Custom_cc')) {

                                    array_push($get_record->cc_roles, $get_actions_role['cc_roles'][$cc]);
                                }
                            }
                            $get_record->cc_roles = implode(', ', $get_record->cc_roles);
                            if ((in_array('Custom', $get_record->stage_etmp_cc) || in_array('Custom_cc', $get_record->stage_etmp_cc)) && !empty($get_record->stage_etmp_cust_cc)) {
                                if(isset($get_record->cc_roles) && !empty($get_record->cc_roles)){
                                    $get_record->cc_roles .= ', Specific email ID('.implode(', ', explode(',', $get_record->stage_etmp_cust_cc)).')';
                                }else{
                                    $get_record->cc_roles .= 'Specific email ID('.implode(', ', explode(',', $get_record->stage_etmp_cust_cc)).')';
                                }
                            }
                        }
                        if (!empty($get_record->stage_etmp_bcc)) {
                            foreach ($get_record->stage_etmp_bcc as $bcc) {
                                if (isset($get_actions_role['cc_bcc_roles'][$bcc]) && ( $bcc != 'Custom' && $bcc != 'Custom_bcc'))
                                    array_push($get_record->bcc_roles, $get_actions_role['cc_bcc_roles'][$bcc]);
                            }
                            $get_record->bcc_roles = implode(', ', $get_record->bcc_roles);
                            if ((in_array('Custom', $get_record->stage_etmp_bcc) || in_array('Custom_bcc', $get_record->stage_etmp_bcc)) && !empty($get_record->stage_etmp_cust_bcc)) {
                               if(isset($get_record->bcc_roles) && !empty($get_record->bcc_roles)){
                                   $get_record->bcc_roles .= ', Specific email ID('.implode(', ', explode(',', $get_record->stage_etmp_cust_bcc)).')';
                               }else{
                                   $get_record->bcc_roles .= 'Specific email ID('.implode(', ', explode(',', $get_record->stage_etmp_cust_bcc)).')';
                               }
                            }
                        }
                    }
                    $get_record->edit_permission = TRUE;
                    if ($get_record->stage_etmp_journal_id == NULL) {
                        $condition = "permission_route='email-templates'";
                        $permission_roles = General_permission::get_single_record('permission_roles', $condition);
                        $permission_roles = json_decode($permission_roles->permission_roles);
                        if ((!empty($permission_roles) && !empty(array_intersect($permission_roles, $this->current_user['roles']))) || in_array('sudo', $this->current_user['roles'])) {
                            $get_record->edit_permission = TRUE;
                        } else {
                            $get_record->edit_permission = FALSE;
                        }
                    }
                    return $this->success('success', 200, $get_record);
                }
            } else {
                $email_tmpl_id = $this->decrypt_data($get_data['data']['etmp_id']);
                // $criteria = 'etmp_id =' . $email_tmpl_id;
                $criteria = 'etmp_id = ?';
                $get_record = Email_templates::get_single_record('*', $criteria,binding_arr:[$email_tmpl_id]);
                // Task #8549, Global manual reminder is incorrectly displayed as 'global_manual_remainder' in the email template preview when using the 'search all templates available for stage' option.issue fix start
                $hookvalue = $this->Utility("email_hooks");
                $get_record->etmp_name = (isset($hookvalue['email_hooks'][$get_record->etmp_name]['name']) && !empty($hookvalue['email_hooks'][$get_record->etmp_name]['name'])) ? $hookvalue['email_hooks'][$get_record->etmp_name]['name'] : $get_record->etmp_name;
                // Task #8549, Global manual reminder is incorrectly displayed as 'global_manual_remainder' in the email template preview when using the 'search all templates available for stage' option.issue fix end
                $get_record->stage_etmp_cc = json_decode($get_record->etmp_cc);
                $get_record->stage_etmp_bcc = json_decode($get_record->etmp_bcc);
                $get_record->stage_etmp_subject = $get_record->etmp_subject;
                $get_record->stage_etmp_platform = $get_record->etmp_platform;
                $get_record->stage_etmp_name = $get_record->etmp_name;

                preg_match_all('/##([^##]*)##/', $get_record->etmp_email_template, $matches);
                $keys = $matches[1];
                for ($i = 0; $i < count($keys); $i++) {
                    $element = $keys[$i];
                    if (!empty($element)) {
                        $tmpl_data = str_ireplace('##' . $element . '##', '<button contenteditable="false">' . $element . '</button>', $get_record->etmp_email_template);
                        $get_record->etmp_email_template = $tmpl_data;
                    }
                }
                $b_body = str_ireplace('##', '', $get_record->etmp_email_template);
                $b_bodyview =  str_ireplace('<button contenteditable="false"><button contenteditable="false">', '<button contenteditable="false">', $b_body);
                $email_body =  str_ireplace('</button></button>', '</button>', $b_bodyview);
                $get_record->stage_etmp_content = $email_body;

                $get_record->cc_roles = $get_record->bcc_roles = array();
                $get_actions_role = $this->get_event_email_template_actions();

                if (!empty($get_actions_role)) {
                    if (!empty($get_record->etmp_notification)) {
                        if ($get_record->etmp_notification != 'Custom'||$get_record->etmp_notification != 'Custom_to') {
                            if (isset($get_actions_role['possible_roles'][$get_record->etmp_notification]))
                            { 
                                $get_record->stage_etmp_to = $get_actions_role['possible_roles'][$get_record->etmp_notification];
                            }
                            else
                            {
                                if (!empty($get_record->etmp_cust_to))
                                {
                                $get_record->etmp_notification = $get_record->etmp_cust_to;
                                }
                                else{
                                    $get_record->stage_etmp_to = '';
                                }
                             }
                        } else {
                            $get_record->etmp_notification = 'Custom';
                            if (!empty($get_record->etmp_cust_to))
                            {
                            $get_record->etmp_notification = $get_record->etmp_cust_to;
                            }
                        }
                        $get_record->stage_etmp_to = $get_record->etmp_notification;
                    }
                    if (!empty($get_record->stage_etmp_cc)) {
                        foreach ($get_record->stage_etmp_cc as $cc) {
                            if (isset($get_actions_role['cc_bcc_roles'][$cc]) && $cc != 'Custom')
                                array_push($get_record->cc_roles, $get_actions_role['cc_bcc_roles'][$cc]);
                        }
                        $get_record->cc_roles = implode(', ', $get_record->cc_roles);
                        if (in_array('Custom', $get_record->stage_etmp_cc) && !empty($get_record->etmp_cust_cc)) {
                            $comma  =   "";
                            if ($get_record->cc_roles != "")
                                $comma  =   ", ";
                            $get_record->cc_roles .= $comma . implode(', ', explode(',', $get_record->etmp_cust_cc));
                        }
                    }
                    if (!empty($get_record->stag_etmp_bcc)) {
                        foreach ($get_record->stage_etmp_bcc as $bcc) {
                            if (isset($get_actions_role['cc_bcc_roles'][$bcc]) && $bcc != 'Custom')
                                array_push($get_record->bcc_roles, $get_actions_role['cc_bcc_roles'][$bcc]);
                        }
                        $get_record->bcc_roles = implode(', ', $get_record->bcc_roles);
                        if (in_array('Custom', $get_record->stage_etmp_bcc) && !empty($get_record->etmp_cust_bcc)) {
                            $comma  =   "";
                            if ($get_record->bcc_roles != "")
                                $comma  =   ", ";
                            $get_record->bcc_roles .= $comma . implode(', ', explode(',', $get_record->etmp_cust_bcc));
                        }
                    }
                }
                $get_record->edit_permission = TRUE;

;
                return $this->success('success', 200, $get_record);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
    Get stage template name ,possible role,cc and bcc for stage based email template
    Commited date :-  12-04-2022
    Request type :- post
     */
    public function show_stage_email_template(Request $request)
    {
        try {
            $get_data = $request->all();
            if ($get_data['params']) {
                $stage_type = $get_data['params']['selected'];
                $art_type = $get_data['params']['art_type'];
                $jwf_id = $get_data['params']['jwf_id'];
            }
            $client_code = $this->current_client->clnt_client_code;
            $workflow_config = 'clients.' . $client_code . '.workflow_config.review_flow';
            $enable_journal_data = FALSE;
            if (isset($this->current_client->functionality->cfty_allow_journal_wise_data_to_sa) && $this->current_client->functionality->cfty_allow_journal_wise_data_to_sa == 'y') {
                $enable_journal_data = TRUE;
                $all_jnls = Journals::get_all_records('jnl_id, jnl_journal_name', "jnl_standalone = 'n'");
                $all_journals = array();
                if (isset($all_jnls)) {
                    foreach ($all_jnls as $jnl) {
                        $all_journals[$jnl->jnl_id] = $jnl->jnl_journal_name;
                    }
                    $all_jnls = $all_journals;
                }
                $return_arr['all_jnls'] = $all_jnls;
            }
            $review_flow = Config::get($workflow_config);
            if (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n') {
                $stages = array();
                foreach ($review_flow as $k => $v) {
                    if (isset($v['stage_for']) && $v['stage_for'] == 'review') {
                        $stages[$k] = $v;
                    }
                }
                $review_flow = $stages;
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if (!empty($review_flow)) {
                $workflow_stages = array();
                foreach ($review_flow as $key => $val) {
                    if (!isset($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers) || (isset($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers) && ($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers == 'n'))) {
                        if (isset($key) && $key == 'review') {
                            if (isset($val['possible_email_tmpl_actions']) && isset($val['possible_email_tmpl_actions']['pre_review_initializaion'])) {
                                unset($val['possible_email_tmpl_actions']['pre_review_initializaion']);
                            }
                        }
                        
                    }
                    $workflow_stages[$key] = $val;
                }
                $review_flow = $workflow_stages;
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            $select = "reminder_format";
            $reminder_format = $this->Utility('reminder_format');
            if (isset($stage_type)) {
                $reviewflow = $review_flow[$stage_type];
                $event = $review_flow[$stage_type]['possible_email_tmpl_actions'];
                //get stage actions -- start
                $stage_actions = $reviewflow['possible_email_tmpl_actions'];
                if ($this->current_client->modules->mdl_casrai_credit == 'n' || ($this->current_client->modules->mdl_casrai_credit == 'y' && (!isset($reviewflow['enable_casrai_credits_confirm']) || $reviewflow['enable_casrai_credits_confirm'] == false))) {
                    if (isset($stage_actions['confirm_casrai'])) {
                        unset($stage_actions['confirm_casrai']);
                    }
                }
                if ($this->current_client->modules->mdl_orcid == 'n' || ($this->current_client->modules->mdl_orcid == 'y' && (!isset($reviewflow['enable_orcid_confirm']) || $reviewflow['enable_orcid_confirm'] == false))) {
                    if (isset($stage_actions['confirm_orcid'])) {
                        unset($stage_actions['confirm_orcid']);
                    }
                }

                /* TASK #4801  Part of RVRite integration: Need to keep the change log*/
                if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'n')
                {
                    if (isset($stage_actions['track_author_changes'])) {
                        unset($stage_actions['track_author_changes']);
                    }
                }
                /* End Task #4801 */
       
                if ($art_type != null) {

                    $permission_roles = Article_type_advance_options::get_single_record('atotp_rescind_article,atotp_reset_article', array(
                        'atotp_artp_id' => $art_type
                    ));
                    if (isset($stage_actions['rescind_source']) && $permission_roles->atotp_rescind_article == null) {
                        unset($stage_actions['rescind_source']);
                        unset($stage_actions['rescind_destination']);
                    }
                    if (isset($stage_actions['reset']) && $permission_roles->atotp_reset_article == null) {
                        unset($stage_actions['reset']);
                    }
                    if ($jwf_id != null) {
                        $assignment_type = Generic_flows::get_single_record('jwf_parent_user_roles, jwf_who_can_invite, jwf_role_id,jwf_assignment', array(
                            'jwf_id' => $jwf_id
                        ));
                        $stage_role = $assignment_type->jwf_role_id;
                        if ($assignment_type->jwf_assignment == 'manual' || $assignment_type->jwf_assignment == 'invitation') {
                            $assign_permission_role = json_decode($assignment_type->jwf_parent_user_roles);
                            if ($assignment_type->jwf_assignment == 'invitation') {
                                $invite_permission_role = json_decode($assignment_type->jwf_who_can_invite);
                            }
                        }
                        if (isset($stage_actions['accepted']) && $assignment_type->jwf_assignment == 'self_service') {
                            unset($stage_actions['accepted']);
                            unset($stage_actions['declined']);
                            unset($stage_actions['assigned_not_accepted']);
                            unset($stage_actions['unassign_user']);
                        }
                    }
                }
                $result['stage_actions'] = $stage_actions;
                //get stage actions -- end
                $cc_bcc_roles = array();
                $possible_roles = array(); //get all possible roles --start
                //1. stage role
                if (in_array('author', $reviewflow['roles']) || $stage_type == 'accept' || $stage_type == 'reject' || $stage_type == 'decision_revision' || $stage_type == 'aop_publish' || $stage_type == 'publish' || $stage_type == 'review') {
                    $possible_roles['User'] = 'Submitting author';
                    if ($stage_type == 'accept' || $stage_type == 'reject' || $stage_type == 'resubmission' || $stage_type == 'decision_revision' || $stage_type == 'review'|| $stage_type == 'revision') {
                        unset($possible_roles['User']);
                        $possible_roles['submit_author'] = 'Submitting author';
                    }

                    $possible_roles['Author'] = 'Corresponding author';
                    if ($stage_type != 'aop_publish' && $stage_type != 'publish') {
                        $possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
                    }
                }
                if ($stage_type == 'staff_check' || $stage_type == 'pre_assessment' || $stage_type == 'post_assessment') {
                    $possible_roles['submit_author'] = 'Submitted author';
                    $possible_roles['Author'] = 'Corresponding author';
                    $possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';
                }
                if (!in_array('system', $reviewflow['roles']) && (!in_array('author', $reviewflow['roles']))) {
                    $possible_roles['User'] = 'Stage assigned user';
                }
                /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                if(isset($this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers) && $this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers == 'y' && $stage_type == 'review')
                {
                    $possible_roles['review_assigned_users'] = 'Review assigned users';
                }
                /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                $role_used = $this->RolesConfigdata('privileged_user_roles');
                $privileged_roles = $role_used['privileged_user_roles'];
                $role_cond = 'role_assigned_role NOT IN ("system", "author","reviewer")';
                if (isset($reviewflow['stage_for'])) {
                    if ($reviewflow['stage_for'] == 'review') {
                        $role_cond .= ' and FIND_IN_SET("r", role_used_in)';
                    } elseif ($reviewflow['stage_for'] == 'manageproduction') {
                        $role_cond .= ' and FIND_IN_SET("p", role_used_in)';
                    }
                }
                if(in_array($stage_type, array('reject', 'accept', 'resubmission'))) { //TASK #6401 Create a new tag for informing Reviewers about the final decision
                    $possible_roles['submitted_reviewers'] = 'All submitted reviewers';
                }
                $user_roles = Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                if (!empty($user_roles)) {
                    foreach ($user_roles as $usrole) {
                        if (in_array($usrole->role_assigned_role, $privileged_roles) || ($usrole->role_assigned_role == 'reviewer' && in_array('reviewer', $reviewflow['roles']))) {
                            $is_stage_user = '';
                            if (isset($stage_role) && $stage_role == $usrole->role_id) {
                                $is_stage_user = 'stage user role,';
                            }

                            if (isset($assign_permission_role) && !empty($assign_permission_role) && in_array($usrole->role_id, $assign_permission_role)) {
                                $is_stage_user .= 'assign permission,';
                            }

                            if (isset($invite_permission_role) && !empty($invite_permission_role) && in_array($usrole->role_id, $invite_permission_role)) {
                                $is_stage_user .= 'invite permission,';
                            }

                            if ($is_stage_user != '') {
                                $is_stage_user = ' (' . rtrim($is_stage_user, ',') . ')';
                            }
                            if($usrole->role_name=='Author Services'){
                                $role_label = "All " . strtolower($usrole->role_name) . "" . $is_stage_user;
                            }else{
                            $role_label = "All " . strtolower($usrole->role_name) . "s" . $is_stage_user;
                            }
                            $possible_roles[$usrole->role_name] = $role_label;
                            $bcc_roles[$usrole->role_name] = $cc_roles[$usrole->role_name] = $role_label;
                        }
                    }
                    $possible_roles['Custom'] = $bcc_roles['Custom_bcc'] = $cc_roles['Custom_cc'] = 'Specific email ID';
                }
            } else {
                $event[] = [];
                $cc_roles[] = [];
                $bcc_roles[] = [];
                $possible_roles[] = [];
            }
            $reminder_to_complete = $this->Utility('reminder_to_complete');
            $reminder_to_accept = $this->Utility('reminder_to_accept');
            $reminder_to_shortlist = $this->Utility('reminder_to_shortlist');
            $reminder_to_invite = $this->Utility('reminder_to_invite');

            $return_arr['reminder_to_accept'] = $reminder_to_accept['reminder_to_accept'];
            $return_arr['reminder_to_complete'] = $reminder_to_complete['reminder_to_complete'];
            $return_arr['reminder_to_shortlist'] = $reminder_to_shortlist['reminder_to_shortlist'];
            $return_arr['reminder_to_invite'] = $reminder_to_invite['reminder_to_invite'];
            $return_arr['review_flow'] = $review_flow;
            $return_arr['enable_jnl_wise'] = $enable_journal_data;
            $return_arr['reminder_format'] = $reminder_format['reminder_format'];
            $return_arr['event'] = $event;
            $return_arr['cc_roles'] = $cc_roles;
            $return_arr['bcc_roles'] = $bcc_roles;
            $return_arr['possible_roles'] = $possible_roles;
            return $this->success('success', 200, $return_arr);
        } catch (Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
    Save stage based email template
    Commited date :-  18-04-2022
    Request type :- POST
     */
    public function save_stage_email_template(Request $request)
    {
        try {

            $this->current_user = $this->get_current_user_details();
            $stage_email_tmpl = $request->all();
            $email_temp_id = $this->decrypt_data($stage_email_tmpl['edited_id']);
            $validator = Validator::make($request->all(), [
                'stage_type' => 'required',
                'stage_template_action' => 'required',
                'stage_template_name' => 'required',
                'stage_template_to_mail' => 'required',
                'stage_template_sub' => 'required',
                'stage_template_content' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $stage_type = $stage_email_tmpl['stage_type'];
            if ($email_temp_id != '') {
                $criteria_ref = 'setr_stage_etmp_id= "' . $email_temp_id . '"';

                $stage_reference_record = Stage_email_tmpl_reference::get_single_record('setr_id', $criteria_ref);

                if (!empty($stage_reference_record)) {
                    $criteria = 'stage_etmp_id= "' . $email_temp_id . '"';
                    $stage_record = Stage_email_templates::get_single_record('stage_etmp_stage_type', $criteria);
                }
                if (!empty($stage_record)) {
                    if ($stage_record->stage_etmp_stage_type != $stage_type) {
                        $return_arr['status'] = 'failed';
                        $return_arr['msg'] = 'failed data';
                        echo json_encode($return_arr);
                        exit;
                    }
                }
            }
            $stage_template_action = $stage_email_tmpl['stage_template_action'];
            $replace_button = array('<button contenteditable="false">', '</button>');
            $replaceval = str_replace($replace_button, '##', $stage_email_tmpl['stage_template_content']);
            $content = $replaceval;

            $to_mail = $stage_email_tmpl['stage_template_to_mail'];
            $template_name = $stage_email_tmpl['stage_template_name'];

            $opttovalue = array();
            if (isset($stage_email_tmpl['stage_cust_to'])&&!empty($stage_email_tmpl['stage_cust_to'])&&($to_mail=='Custom'||$to_mail=='Custom_to')) {
                $custm_to = $stage_email_tmpl['stage_cust_to'];
                for ($i = 0; $i < count($custm_to); $i++) {
                    $cust_value = isset($custm_to[$i]['value']) ? $custm_to[$i]['value'] : $custm_to[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                    array_push($opttovalue, $cust_value);


                }
                $stage_email_tmpl['stage_cust_to'] = implode(',', $opttovalue);

            }
            else{
                $stage_email_tmpl['stage_cust_to']='';
            }
            $cust_to = '';
            if (isset($stage_email_tmpl['stage_cust_to'])&&!empty($stage_email_tmpl['stage_cust_to'])) {
                $cust_to = $stage_email_tmpl['stage_cust_to'];
            }
            $cc = '';
            if (isset($stage_email_tmpl['stage_template_to_cc']) && !empty($stage_email_tmpl['stage_template_to_cc'])) {
                $tmpl_cc = json_encode($stage_email_tmpl['stage_template_to_cc']);
            }
            $optccvalue = array();
            if (isset($stage_email_tmpl['stage_cust_cc'])&&!empty($stage_email_tmpl['stage_cust_cc']) && (in_array('Custom_cc',$stage_email_tmpl['stage_template_to_cc'])||in_array('Custom',$stage_email_tmpl['stage_template_to_cc']))) {
                $custm_cc = $stage_email_tmpl['stage_cust_cc'];
                for ($i = 0; $i < count($custm_cc); $i++) {
                    $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                    array_push($optccvalue, $cust_value);


                }
                $stage_email_tmpl['stage_cust_cc'] = implode(',', $optccvalue);

            }
            else{
                $stage_email_tmpl['stage_cust_cc']='';
            }
            $optbccvalue = array();
            if (isset($stage_email_tmpl['stage_cust_bcc'])&&!empty($stage_email_tmpl['stage_cust_bcc']) && (in_array('Custom_bcc',$stage_email_tmpl['stage_template_to_bcc'])||in_array('Custom',$stage_email_tmpl['stage_template_to_bcc']))) {
                $custm_bcc = $stage_email_tmpl['stage_cust_bcc'];
                for ($i = 0; $i < count($custm_bcc); $i++) {
                    $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                    $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                    $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                    array_push($optbccvalue, $cust_bcc_value);

                }
                $stage_email_tmpl['stage_cust_bcc'] = implode(',', $optbccvalue);
            }
            else{
                $stage_email_tmpl['stage_cust_bcc']='';
            }
            $cust_cc = '';
            if (isset($stage_email_tmpl['stage_cust_cc']) && !empty($stage_email_tmpl['stage_cust_cc'])) {
                $cust_cc = $stage_email_tmpl['stage_cust_cc'];
            }
            $bcc = '';
            if (isset($stage_email_tmpl['stage_template_to_bcc']) && !empty($stage_email_tmpl['stage_template_to_bcc'])) {
                $tmpl_bcc = json_encode($stage_email_tmpl['stage_template_to_bcc']);
            }
            $cust_bcc = '';
            if (isset($stage_email_tmpl['stage_cust_bcc']) && !empty($stage_email_tmpl['stage_cust_bcc'])) {
                $cust_bcc = $stage_email_tmpl['stage_cust_bcc'];
            }
            $subject = $stage_email_tmpl['stage_template_sub'];
            $condition = "stage_etmp_name='{$template_name}'";
            if ($email_temp_id != '') {
                $get_current_etemp_data = Stage_email_templates::get_single_record("stage_etmp_journal_id", "stage_etmp_id={$email_temp_id}");
                if ( isset($get_current_etemp_data) && !empty($get_current_etemp_data)) {
                    if(isset($get_current_etemp_data->stage_etmp_journal_id)){
                        $condition .= "AND stage_etmp_journal_id='" . $get_current_etemp_data->stage_etmp_journal_id . "' ";
                    }
                    else{
                        $condition .= "AND stage_etmp_journal_id IS NULL ";
                    }
                } else {
                    $condition .= " AND stage_etmp_journal_id IS NULL ";
                }
                $condition .= " AND stage_etmp_id != $email_temp_id";
            }
            else{
                $condition .= " AND stage_etmp_journal_id IS NULL";
            }

            $to_cc = isset($tmpl_cc) ? ($tmpl_cc) : '';
            $to_bcc = isset($tmpl_bcc) ? ($tmpl_bcc) : '';
            $record_data = Stage_email_templates::get_single_record("stage_etmp_id", $condition);
            if (!empty($record_data)) {
                $message = customTrans('email_template.email_tmpl_name_error');
                $success = false;
                return response()->json(['success' => $success,'message' => $message,'responsecode' => 201,'status' => 'duplicate', ]);
            }

            $data_arr = array(
                "stage_etmp_name" => $template_name,
                "stage_etmp_to" => $to_mail,
                "stage_etmp_cust_to" => $cust_to,
                "stage_etmp_cc" => $to_cc,
                "stage_etmp_cust_cc" => $cust_cc,
                "stage_etmp_bcc" => $to_bcc,
                "stage_etmp_cust_bcc" => $cust_bcc,
                "stage_etmp_subject" => $subject,
                "stage_etmp_content" => $content,
            );
            if ($stage_template_action == 'assigned_not_accepted' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else if ($stage_template_action == 'accepted_not_completed' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else if ($stage_template_action == 'pnd_reviewer_shortlist' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else if ($stage_template_action == 'pnd_reviewer_invite' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else {
                $data_arr['stage_etmp_remind_after'] = NULL;
            }
             /* TASK #4801  Part of RVRite integration: Need to keep the change log*/
            $remind_field_array = array("accepted_not_completed", "assigned_not_accepted", "pnd_reviewer_shortlist", "pnd_reviewer_invite");
             if (in_array($stage_template_action, $remind_field_array ))/*End TASK #4801 */
            {
                $reminder_format = $stage_email_tmpl['stage_template_reminder_format'];
                $remind_days = $stage_email_tmpl['stage_template_remind_days'];
                $data_arr['stage_etmp_reminder_format'] = $reminder_format;
                $data_arr['stage_etmp_remind_days'] = $remind_days;
            } elseif ($stage_template_action == 'document_queue_updated') {
                $remind_months = $stage_email_tmpl['stage_etmp_remind_months'];
                $data_arr['stage_etmp_remind_months'] = $remind_months;
            }
            if ($stage_email_tmpl['stage_template_reminder_format'] == 'on_due_date') {
                $data_arr['stage_etmp_remind_days'] = 0;
            }
            $data_arr["stage_etmp_stage_type"] = $stage_type;
            $data_arr["stage_etmp_action"] = $stage_template_action;
            if ($email_temp_id != '') {
                $condition = "stage_etmp_id='" . $email_temp_id . "'";
                $insertid = Stage_email_templates::update_record($data_arr, $condition, $this->current_user);
                $message = customTrans('email_template.email_tmpl_updated');
                $data_arr["stage_etmp_id"] = $email_temp_id;
            } else {
                $insertid = Stage_email_templates::insert_record($data_arr, $this->current_user);
                $message = customTrans('email_template.email_tmpl_added');
                $data_arr["stage_etmp_id"] = $insertid;
            }
            return response()->json([
                'success' => true,
                'message' => $message,
                'result' => $data_arr,

            ]);
        } catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }
    public function delete_stage_email_template(Request $request)
    {

        DB::beginTransaction();
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $id = $this->decrypt_data($form_data['stage_etmp_id']);
            if (isset($id) && $id != "") {
                $crietria = 'stage_etmp_id=' . $id;
                $deletedata = Stage_email_templates::delete_records($crietria, '', $this->current_user);
            }
            DB::commit();
            return response()->json([
                'success' => true,
                'message' => customTrans('email_template.email_tmpl_deleted'),
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'success' => false,
                'message' => customTrans('email_template.email_tmpl_del_error'),
            ]);
        }
    }
    public function delete_global_email_template(Request $request)
    {
        DB::beginTransaction();
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $id = $this->decrypt_data($form_data['etmp_id']);
            if (isset($id) && $id != "") {
                $crietria = 'etmp_id=' . $id;
                $deletedata = Email_templates::delete_records($crietria, '', $this->current_user);
            }
            DB::commit();
            return response()->json([
                'success' => true,
                'message' => customTrans('email_template.email_tmpl_deleted'),
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'success' => false,
                'message' => customTrans('email_template.email_tmpl_del_error'),
            ]);
        }
    }
    public function stage_based_email_tags(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $form_data['params']['artid'] = isset($form_data['params']['artid']) ? (is_array($form_data['params']['artid']) ? array_keys($form_data['params']['artid'])[0] : $form_data['params']['artid']) : '';
            $jnl_id=isset($form_data['params']['selected'])?decrypt_link($form_data['params']['selected']):'';
            $artpid=isset($form_data['params']['artpid'])?decrypt_link($form_data['params']['artpid']):'';
            $artid=isset($form_data['params']['artid'])?decrypt_link($form_data['params']['artid']):'';
            $select = "email_hooks";
            $email_hooks = $this->Utility($select);
            $Generic_form_elements = new \App\Models\Generic_form_elements();
            if($artpid =="" && $artid!='')
            {
               $Articles =  new \App\Models\Articles();
               $artpid = $Articles::get_single_record('art_artp_id',"art_id={$artid}")->art_artp_id;
            }
            $all_tags = $this->stage_email_tmpl_tags($jnl_id,$artpid);
            if ($this->current_client->modules->mdl_production == 'n') {
                unset($all_tags['article_tags'][array_search('PUBLISH_ISSUE_TITLE', $all_tags['article_tags'])]);
                unset($all_tags['article_tags'][array_search('PUBLISH_VOLUME_TITLE', $all_tags['article_tags'])]);
            }
            if (isset($this->current_client->functionality->cfty_enable_review_resubmit) && $this->current_client->functionality->cfty_enable_review_resubmit != 'y') {
                //#3231 Reason for re-open
                unset($all_tags['article_tags'][array_search('REOPEN_REASON', $all_tags['article_tags'])]);
            }
            if (($all_tags['author_tags'] || $all_tags['current_user_tags']) && ($this->current_client->modules->mdl_orcid != 'y')) {
                if (($key = array_search('CORRESPONDING_AUTHOR_ORCID', $all_tags['author_tags'])) !== false) {
                    unset($all_tags['author_tags'][$key]);
                }

                if (($key = array_search('CURRENT_USER_ORCID', $all_tags['current_user_tags'])) !== false) {
                    unset($all_tags['current_user_tags'][$key]);
                }
            }

            if ($jnl_id!=""&&(!in_array('super_admin', $this->current_user['roles']) || !in_array('sudo', $this->current_user['roles']))) {
                $return_arr['generic_form_element_tags'] = $all_tags['generic_form_element_tags'];

            }else{
                $return_arr['generic_form_element_tags'] = array();
            }
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y'){
                $return_arr['abstract_tags'] = $all_tags['abstract_tags'];
                /*TASK #5761 Event Based Email Tags Settings in Email Template*/
                $return_arr['event_tags'] = $all_tags['event_tags'];
                /* TASK #5761 End */
            }
            $return_arr['article_tags'] = $all_tags['article_tags'];
            $return_arr['custom_tags'] = $all_tags['custom_tags'];
            $return_arr['author_tags'] = $all_tags['author_tags'];
            $return_arr['copyright_tags'] = $all_tags['copyright_tags'];
            $return_arr['recipient_tags'] = $all_tags['recipient_tags'];
            $return_arr['variable_tags'] = $all_tags['variable_tags'];
            $return_arr['avail_links'] = $all_tags['email_links'];
            $return_arr['current_user_tags'] = $all_tags['current_user_tags'];
            $return_arr['userrole_tags'] = $all_tags['userrole_tags'];
            $return_arr['transfer_article_tags'] = $all_tags['transfer_article_tags'];
            $email_link = $all_tags['email_links'];
            $return_arr['email_links'] = $email_link;
            $return_arr['journal_EPA_tags'] = array_keys($this->email_templates_config()['journal_EPA_tags']);
            $return_arr['transfer_article_tags'] = $all_tags['transfer_article_tags'];
            $return_arr['journal_tags'] = $all_tags['journal_tags'];
            $return_arr['article_type_tags'] = $all_tags['article_type_tags'];
            $return_arr['bioRxiv_tags'] = $all_tags['bioRxiv_tags'];
            $return_arr['assignment_tags'] = $all_tags['assignment_tags'];
            $return_arr['api_user_client_tags'] = $all_tags['api_user_client_tags'];
            $return_arr['merged_user_tags'] = $all_tags['merged_user_tags'];
            $return_arr['retired_roles_tags'] = $all_tags['retired_roles_tags'];
            $return_arr['stage_import_error_tags'] = $all_tags['stage_import_error_tags'];
            $return_arr['rejoin_roles_tags'] = $all_tags['rejoin_roles_tags'];
            $return_arr['jnl_user_keywords_tags'] = $all_tags['jnl_user_keywords_tags'];
            $return_arr['contact_details'] = $all_tags['contact_details'];// TASK #8907 contact us mail
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function stage_email_tmpl_tags($jnl_id = null, $article_type_id = null, $email_tmpl_stage_type = null)
    {
        try {
            $this->current_user = $this->get_current_user_details();

            $article_type_advance_options = new \App\Models\Article_type_advance_options();
            $Generic_form_elements = new \App\Models\Generic_form_elements();
            $links = array_keys($this->email_templates_config()['links']);
        
            sort($links);
            $all_tags['email_links'] = $links;
            $email_tags = $this->configure_email_tags();
            if ($this->current_client->functionality->cfty_jnl_EPA == 'n') {
                unset($email_tags['journal_EPA_tags']);
            }

            if ($this->current_client->modules->mdl_casrai_credit == 'n') {
                if (!empty($email_tags)) {
                    foreach ($email_tags as $key => $value) {
                        foreach ($value as $k => $v) {
                            if ($v == 'CORRESPONDING_AUTHOR_CASRAI_CREDITS') {
                                unset($email_tags[$key][$k]);
                            }
                        }
                    }
                }
            }

            foreach ($email_tags as $ekey => $evalue) {
                $all_tags[$ekey] = $evalue;
            }

            if (($key = array_search('PRECEDING_DUE_DATE', $all_tags['article_tags'])) !== false) {
                unset($all_tags['article_tags'][$key]);
            }

            unset($all_tags['article_tags'][array_search('REOPENED_REVIEW_STAGE_NAME', $all_tags['article_tags'])]);

            if ($this->current_client->modules->mdl_review_for_doc == 'y') {

                if (in_array("ARTICLE_ABSTRACT", $all_tags['article_tags']) > 0) {
                    $all_tags['article_tags'] = str_replace('ARTICLE_ABSTRACT', 'OPENING_PARAGRAPH', $all_tags['article_tags']);
                }
            }
            if ($article_type_id != null) {
                $has_plagarism = $article_type_advance_options::get_single_record('atotp_article_submission_type,atotp_plagiarism_checking,	atotp_review_open_decision,atotp_review_open_count', "atotp_artp_id={$article_type_id}");
            }
            //copyright tags for stage type :license check and copyright:
            $extra_article_tag_arr = array();
            if (!empty($email_tmpl_stage_type)) {
                $email_template_config = $this->email_templates_config();
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow = Config::get($workflow_config);
                $reviewflow = $review_flow[$email_tmpl_stage_type];

                $w_email_templates = (!empty($reviewflow) && !empty($reviewflow['email_templates'])) ? $reviewflow['email_templates'] : array();
                for ($i = 0; $i < count($w_email_templates); $i++) {
                    if ($w_email_templates[$i] != 'comments_to_author_tags') {
                        foreach ($email_template_config[$w_email_templates[$i]] as $key => $val) {
                            $extra_article_tag_arr[$key] = $key;
                        }
                    }
                }
            }
            $extra_art_tags = array_values($extra_article_tag_arr);
            $all_tags['article_tags'] = array_merge($all_tags['article_tags'], $extra_art_tags);

            if ($all_tags['article_tags'] && ($this->current_client->modules->mdl_ithenticate != 'y' || ($this->current_client->modules->mdl_ithenticate == 'y' && isset($has_plagarism) && ($has_plagarism->atotp_plagiarism_checking == 'n' || !in_array('fu', json_decode($has_plagarism->atotp_article_submission_type)))))) {
                if (($key = array_search('PERCENT_MATCH', $all_tags['article_tags'])) !== false) {
                    unset($all_tags['article_tags'][$key]);
                }

                if (($key = array_search('PLAGIARISM_REPORT_LINK', $all_tags['article_tags'])) !== false) {
                    unset($all_tags['article_tags'][$key]);
                }
            }
            sort($all_tags['article_tags']);
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y'){
                $all_tags['Conference'] = array_keys($this->email_templates_config()['abstract_tags']);
                 /*TASK #5761 Event Based Email Tags Settings in Email Template*/
                $all_tags['Conference'] = array_keys($this->email_templates_config()['event_tags']);
                /* TASK #5761 End */
            }
            $generic_form_element_tags =$uni_condition = array();
            $uni_condition = "emt_attach_to_mail='n' AND emt_unique_identifier IS NOT NULL";
            if ($jnl_id!=""&&(!in_array('super_admin', $this->current_user['roles']) || !in_array('sudo', $this->current_user['roles']))) {

                $elements = $Generic_form_elements::get_all_form_elements_unique('emt_unique_identifier,jwf_stage_type, jwf_stage_name', $uni_condition, $jnl_id, $article_type_id);

            }
            else{

                $elements = '';
            }
            if (!empty($elements))
            {
                foreach ($elements as $element)
                {
                    if ($element->emt_unique_identifier != NULL)
                        $generic_form_element_tags[] = $element->emt_unique_identifier . '{' . $element->jwf_stage_name . '}';
                        if($element->jwf_stage_type == 'author_submission' && $this->current_client->functionality->cfty_populate_prev_custom_to_current_art_vrsn == 'y')
                        {
                          $generic_form_element_tags[] = $element->emt_unique_identifier . '{' . $element->jwf_stage_name .'_original}';
                        }
                }
            }
            $all_tags['generic_form_element_tags'] = array_unique($generic_form_element_tags);

            /*event_based_email start*/
            $all_tags['journal_tags'] = array_keys($this->email_templates_config()['journal_tags']);
            $all_tags['article_type_tags'] = array_keys($this->email_templates_config()['article_type_tags']);
            $all_tags['bioRxiv_tags'] = array_keys($this->email_templates_config()['bioRxiv_tags']);
            $all_tags['assignment_tags'] = array_keys($this->email_templates_config()['assignment_tags']);
            $all_tags['api_user_client_tags'] = array_keys($this->email_templates_config()['api_user_client_tags']);

            $all_tags['merged_user_tags'] = array_keys($this->email_templates_config()['merged_user_tags']);

            $all_tags['journal_EPA_tags'] = array_keys($this->email_templates_config()['journal_EPA_tags']);
            $all_tags['retired_roles_tags'] = array_keys($this->email_templates_config()['retired_roles_tags']);
            $all_tags['stage_import_error_tags'] = array_keys($this->email_templates_config()['stage_import_error_tags']);
            $all_tags['rejoin_roles_tags'] = array_keys($this->email_templates_config()['rejoin_roles_tags']);
            $all_tags['jnl_user_keywords_tags'] = array_keys($this->email_templates_config()['jnl_user_keywords_tags']);
            $all_tags['contact_details'] = array_keys($this->email_templates_config()['contact_details']);// TASK #8907 contact us mail
            /*event_based_email end */
            return $all_tags;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function event_template_list(Request $request)
    {
        try {
            $email_hooks = $this->Utility('email_hooks');
            $current_user = $this->get_current_user_details();

            /* Do  not list Withdraw emails if the client functonlaity is not enabled */
            if ($this->current_client->functionality->cfty_enable_article_withdraw == 'n') {

                unset($email_hooks['withdraw_article_author']);
                unset($email_hooks['withdraw_article_privileged']);
                unset($email_hooks['undo_withdraw_article_author']);
                unset($email_hooks['undo_withdraw_article_privileged']);
            }
            if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role != 'y') {
                unset($email_hooks['retire_user_roles']);
                unset($email_hooks['rejoin_user_roles']);
            }
            if (isset($this->current_client->functionality->cfty_user_unregister_account) && $this->current_client->functionality->cfty_user_unregister_account != 'y') {
                unset($email_hooks['unregister_confirmation']);
                unset($email_hooks['unregister_notification']);
                unset($email_hooks['unregister_notification_super']);
                unset($email_hooks['unregister_diapproval']);
            }
            if (isset($this->current_client->functionality->cfty_merge_user) && $this->current_client->functionality->cfty_merge_user != 'y') {
                unset($email_hooks['merge_notification']);
            }
            if (isset($this->current_client->functionality->cfty_disable_reviewer_on_fly_email) && $this->current_client->functionality->cfty_disable_reviewer_on_fly_email == 'y') {
                unset($email_hooks['reviewer_on_fly']);
                unset($email_hooks['reviewer_on_fly_awaiting_confirm']);
            }
            if (isset($this->current_client->functionality->cfty_biorxiv) && $this->current_client->functionality->cfty_biorxiv != 'y') {
                unset($email_hooks['b2j_corr_author_mail']);
                unset($email_hooks['b2j_submission_mail']);
                unset($email_hooks['b2j_failure_mail']);
            }

            if (isset($this->current_client->functionality->cfty_enable_article_delete) && $this->current_client->functionality->cfty_enable_article_delete != 'y') {
                unset($email_hooks['delete_article']);
                unset($email_hooks['undo_delete_article']);
            }
            if (isset($this->current_client->functionality->cfty_change_assignment) && $this->current_client->functionality->cfty_change_assignment != 'y') {
                unset($email_hooks['change_assign']);
            }

            if (isset($this->current_client->functionality->cfty_manage_user_keywords) && $this->current_client->functionality->cfty_manage_user_keywords != 'y') {
                unset($email_hooks['manage_user_keywords']);
            }
            if (isset($this->current_client->functionality->cfty_enable_rescind_request) && $this->current_client->functionality->cfty_enable_rescind_request != 'y') {
                unset($email_hooks['request_rescind_article']);
                unset($email_hooks['accepted_rescind_article']);
                unset($email_hooks['rejected_rescind_article']);
            }

            //Task #2913 N5 feedback in ICE Feedback on for FTP upload
            if (isset($this->current_client->functionality->cfty_import_stage_data_from_ftp_location) && $this->current_client->functionality->cfty_import_stage_data_from_ftp_location != 'y') {
                unset($email_hooks['stage_import_email']);
            }
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference != 'y'){
                unset($email_hooks['batch_article_reviewer_assignment']);
            }

            $event_types = Email_templates::get_all_records('etmp_name');
            $exist_hooks = array();
            if ((isset($current_user['roles']) && count($current_user['roles']) > 0))
                $user_role = $current_user['roles'][0];

            if ($user_role != 'sudo') {
                //add email templates here to exclude to other non-sudo users
                $exist_hooks[] = 'api_client_invitation';
                $exist_hooks[] = 'api_client_expire_notification';
                $exist_hooks[] = 'api_client_expired_notification';
            }

            $result_data = array();
            foreach ($event_types as $value)
                $exist_hooks[] = $value->etmp_name;
            // $existing_hooks_available = $exist_hooks;

            foreach ($email_hooks as $value)
                foreach ($value as $key => $temp) {
                    $data = [];
                    $data['label'] =  $temp['name'];
                    $data['value'] =  $key;
                    array_push($result_data, $data);
                }
            usort($result_data, function ($a, $b) {
                return strcmp($a['label'], $b['label']);
            });
            array_multisort($email_hooks, SORT_ASC);


            return $this->success('success', 200, $result_data);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function save_workflw_stage_template(Request $request)
    {
        try {

            $this->current_user = $this->get_current_user_details();
            $stage_email_tmpl = $request->all();
            $manage_roles = $this->convert_string_array($this->current_user['roles']);
            $email_temp_id = $this->decrypt_data($stage_email_tmpl['edited_id']);
            $stage_id = $this->decrypt_data($stage_email_tmpl['stage_id']);
            $jnl_code_status = ($stage_email_tmpl['jnl_code']) ? true : false;
            $jnl_id = $stage_email_tmpl['jnl_id'];

            $validator = Validator::make($request->all(), [
                'stage_type' => 'required',
                'stage_template_action' => 'required',
                'stage_template_name' => 'required',
                'stage_template_to_mail' => 'required',
                'stage_template_sub' => 'required',
                'stage_template_content' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $stage_type = $stage_email_tmpl['stage_type'];
            $action_type = $stage_email_tmpl['action_type'];
            if ($email_temp_id != '') {
                $criteria_ref = 'setr_stage_etmp_id= "' . $email_temp_id . '"';

                $stage_reference_record = Stage_email_tmpl_reference::get_single_record('setr_id', $criteria_ref);

                if (!empty($stage_reference_record)) {
                    $criteria = 'stage_etmp_id= "' . $email_temp_id . '"';
                    $stage_record = Stage_email_templates::get_single_record('stage_etmp_stage_type', $criteria);
                }
                if (!empty($stage_record)) {
                    if ($stage_record->stage_etmp_stage_type != $stage_type) {
                        $return_arr['status'] = 'failed';
                        $return_arr['message'] = 'failed data';
                        $return_arr['st'] = '0';
                        echo json_encode($return_arr);
                        exit;
                    }
                }
            }
            $stage_template_action = $stage_email_tmpl['stage_template_action'];
            $replace_button = array('<button contenteditable="false">', '</button>');
            $replaceval = str_replace($replace_button, '##', $stage_email_tmpl['stage_template_content']);
            $content = $replaceval;

            $to_mail = $stage_email_tmpl['stage_template_to_mail'];
            $template_name = $stage_email_tmpl['stage_template_name'];

            $opttovalue = array();
            if (isset($stage_email_tmpl['stage_cust_to'])&&!empty($stage_email_tmpl['stage_cust_to']) &&($to_mail=='Custom'||$to_mail=='Custom_to') ) {
                $custm_to = $stage_email_tmpl['stage_cust_to'];
                for ($i = 0; $i < count($custm_to); $i++) {
                    $cust_value = isset($custm_to[$i]['value']) ? $custm_to[$i]['value'] : $custm_to[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                    array_push($opttovalue, $cust_value);


                }
                $stage_email_tmpl['stage_cust_to'] = implode(',', $opttovalue);

            }
            else{
                $stage_email_tmpl['stage_cust_to']='';
            }
            $cust_to = '';
            if (isset($stage_email_tmpl['stage_cust_to'])&&!empty($stage_email_tmpl['stage_cust_to'])) {
                $cust_to = $stage_email_tmpl['stage_cust_to'];
            }
            $cc = '';
            if (isset($stage_email_tmpl['stage_template_to_cc'])&&!empty($stage_email_tmpl['stage_template_to_cc'])) {
                $tmpl_cc = json_encode($stage_email_tmpl['stage_template_to_cc']);
            }
            $optccvalue = array();
            if (isset($stage_email_tmpl['stage_cust_cc'])&&!empty($stage_email_tmpl['stage_cust_cc']) && (in_array('Custom_cc',$stage_email_tmpl['stage_template_to_cc'])||in_array('Custom',$stage_email_tmpl['stage_template_to_cc']))) {
                $custm_cc = $stage_email_tmpl['stage_cust_cc'];
                for ($i = 0; $i < count($custm_cc); $i++) {
                    $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                    array_push($optccvalue, $cust_value);


                }
                $stage_email_tmpl['stage_cust_cc'] = implode(',', $optccvalue);

            }
            else{
                $stage_email_tmpl['stage_cust_cc']='';
            }
            $optbccvalue = array();
            if (isset($stage_email_tmpl['stage_cust_bcc'])&&!empty($stage_email_tmpl['stage_cust_bcc']) && (in_array('Custom_bcc',$stage_email_tmpl['stage_template_to_bcc'])||in_array('Custom',$stage_email_tmpl['stage_template_to_bcc']))) {
                $custm_bcc = $stage_email_tmpl['stage_cust_bcc'];
                for ($i = 0; $i < count($custm_bcc); $i++) {
                    $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                    $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                    $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                    array_push($optbccvalue, $cust_bcc_value);

                }
                $stage_email_tmpl['stage_cust_bcc'] = implode(',', $optbccvalue);
            }
            else{
                $stage_email_tmpl['stage_cust_bcc']='';
            }
            $cust_cc = '';
            if (isset($stage_email_tmpl['stage_cust_cc'])&&!empty($stage_email_tmpl['stage_cust_cc'])) {
                $cust_cc = $stage_email_tmpl['stage_cust_cc'];
            }
            $bcc = '';
            if (isset($stage_email_tmpl['stage_template_to_bcc'])&&!empty($stage_email_tmpl['stage_template_to_bcc'])) {
                $tmpl_bcc = json_encode($stage_email_tmpl['stage_template_to_bcc']);
            }
            $cust_bcc = '';
            if (isset($stage_email_tmpl['stage_cust_bcc'])&&!empty($stage_email_tmpl['stage_cust_bcc'])) {
                $cust_bcc = $stage_email_tmpl['stage_cust_bcc'];
            }
            $subject = $stage_email_tmpl['stage_template_sub'];
            /** old_code => $condition = "stage_etmp_name='" . $template_name . "' AND (stage_etmp_journal_id IS NULL OR stage_etmp_journal_id='" . $stage_email_tmpl['jnl_id'] . "' )";
             * convert the above condition into specific type if we edit an master template it will checks duplicates in master templates and journal based duplicate check will occurs in the same journals it will helps to find out journal wise email template duplication. 
             */
            //Task taskbot#294 Copying an email template incorrectly triggers the "Email template name already exists" alert, even when the template name is unused in any stage.
            $condition = "stage_etmp_name ='{$template_name}' AND stage_etmp_stage_type = '{$stage_type}'";
            if ($email_temp_id != '' && $action_type != 'copy') {
                $get_current_etemp_data = Stage_email_templates::get_single_record("stage_etmp_journal_id", "stage_etmp_id={$email_temp_id}");
                if (isset($get_current_etemp_data) && !empty($get_current_etemp_data)) {
                    if (isset($get_current_etemp_data->stage_etmp_journal_id)) {
                        $condition .= "AND stage_etmp_journal_id='" . $get_current_etemp_data->stage_etmp_journal_id . "' ";
                    } else {
                        $condition .= "AND stage_etmp_journal_id IS NULL ";
                    }
                } elseif (!(isset($get_current_etemp_data) && !empty($get_current_etemp_data)) && $jnl_code_status) {
                    $condition .= "AND stage_etmp_journal_id IN ('" . $jnl_id . "') ";
                } else {
                    $condition .= " AND stage_etmp_journal_id IS NULL ";
                }
                $condition .= " and stage_etmp_id!=$email_temp_id";
            } else if ($email_temp_id == '' && $action_type != 'copy') {
                    $condition .= ($jnl_code_status) ? "AND stage_etmp_journal_id='" . $jnl_id . "' " : " AND stage_etmp_journal_id IS NULL ";
            }
            elseif($email_temp_id !='' && $action_type == 'copy')
            {
                $condition .= " AND stage_etmp_journal_id ='" . $jnl_id . "'";
            }
    
            $to_cc = isset($tmpl_cc) ? ($tmpl_cc) : '';
            $to_bcc = isset($tmpl_bcc) ? ($tmpl_bcc) : '';
            $record_data = Stage_email_templates::get_single_record("stage_etmp_id", $condition);
            if (!empty($record_data))
			{
                $message = customTrans('email_template.email_tmpl_name_error');
                $success = false;
                return response()->json([ 'success' => $success, 'message' => $message, 'responsecode' => 201, 'status' => 'duplicate']);
			}

            $data_arr = array(
                "stage_etmp_name" => $template_name,
                "stage_etmp_to" => $to_mail,
                "stage_etmp_cust_to" => $cust_to,
                "stage_etmp_cc" => $to_cc,
                "stage_etmp_cust_cc" => $cust_cc,
                "stage_etmp_bcc" => $to_bcc,
                "stage_etmp_cust_bcc" => $cust_bcc,
                "stage_etmp_subject" => $subject,
                "stage_etmp_content" => $content,
            );

            if ($stage_template_action == 'assigned_not_accepted' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else if ($stage_template_action == 'accepted_not_completed' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else if ($stage_template_action == 'pnd_reviewer_shortlist' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else if ($stage_template_action == 'pnd_reviewer_invite' && $stage_email_tmpl['stage_template_reminder_format'] == 'after') {
                $data_arr['stage_etmp_remind_after'] = $stage_email_tmpl['stage_template_to_remind_after'];
            } else {
                $data_arr['stage_etmp_remind_after'] = NULL;
            }
            if ($stage_template_action == 'accepted_not_completed' || $stage_template_action == 'assigned_not_accepted' || $stage_template_action == 'pnd_reviewer_shortlist' || $stage_template_action == 'pnd_reviewer_invite') {
                $reminder_format = $stage_email_tmpl['stage_template_reminder_format'];
                $remind_days = $stage_email_tmpl['stage_template_remind_days'];
                $data_arr['stage_etmp_reminder_format'] = $reminder_format;
                $data_arr['stage_etmp_remind_days'] = $remind_days;
            } elseif ($stage_template_action == 'document_queue_updated') {
                $remind_months = $stage_email_tmpl['stage_etmp_remind_months'];
                $data_arr['stage_etmp_remind_months'] = $remind_months;
            }
            if ($stage_email_tmpl['stage_template_reminder_format'] == 'on_due_date') {
                $data_arr['stage_etmp_remind_days'] = 0;
            }


            $data_arr['stage_old_etmp_id'] = 0;

            $data_arr["stage_etmp_stage_type"] = $stage_type;
            $data_arr["stage_etmp_action"] = $stage_template_action;
            if ($email_temp_id != '' && $action_type == 'edit') {
                $condition = "stage_etmp_id='" . $email_temp_id . "'";
                $insertid = Stage_email_templates::update_record($data_arr, $condition, $this->current_user);
                $email_tmpl_id = $email_temp_id;
                $record = Stage_email_templates::get_all_records('stage_etmp_id,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_journal_id', 'stage_etmp_id IN(' . $email_tmpl_id . ')');
                $is_super_admin = FALSE;
                $condition = "permission_route='email-templates'";
                $permission_roles = General_permission::get_single_record('permission_roles', $condition);
                $permission_roles = json_decode($permission_roles->permission_roles);
                if ((!empty($permission_roles) && !empty(array_intersect($permission_roles, $manage_roles))) || in_array('sudo', $manage_roles))
                    $is_super_admin = TRUE;
                $data_arr['remove_class_import_err'] = '';
                if (!empty($record)) {

                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow  = Config::get($workflow_config);
                    $possible_actions = $review_flow[$record[0]->stage_etmp_stage_type]['possible_email_tmpl_actions'];

                    foreach ($record as $r) {
                        $r->is_super_admin = $is_super_admin;
                        $r->stage_etmp_action = $possible_actions[$r->stage_etmp_action];
                    }
                }
                $data_arr['assoc_tmpls_array'] = $record;

                $message = customTrans('email_template.email_tmpl_updated');
                $data_arr["stage_etmp_id"] = $email_temp_id;
            } else {
                $data_arr["stage_etmp_journal_id"] = $stage_email_tmpl['jnl_id'];
                $insertid = Stage_email_templates::insert_record($data_arr, $this->current_user);
                $time = date('Y-m-d H:i:s', time());
                $insert_arr = array(
                    "setr_jwf_id" => $stage_id,
                    "setr_stage_etmp_id" => $insertid,
                    "setr_posted_date" => $time,
                    "setr_posted_by" => $this->current_user['user_id'],
                    "setr_proxy_id" => $this->current_user['proxy_user_id'],
                    "setr_proxy_id" => 'i'
                );
                $email_tmpl_id = $insertid;
                $result = Stage_email_tmpl_reference::insert_record($insert_arr, $this->current_user);
                $assoc_tmpls_array = '';
                $record = Stage_email_templates::get_all_records('stage_etmp_id,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_journal_id', 'stage_etmp_id IN(' . $email_tmpl_id . ')');
                $is_super_admin = FALSE;
                $condition = "permission_route='email-templates'";
                $permission_roles = General_permission::get_single_record('permission_roles', $condition);
                $permission_roles = json_decode($permission_roles->permission_roles);
                if ((!empty($permission_roles) && !empty(array_intersect($permission_roles, $manage_roles))) || in_array('sudo', $manage_roles))
                    $is_super_admin = TRUE;
                $data_arr['remove_class_import_err'] = '';

                if (!empty($record)) {

                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow  = Config::get($workflow_config);
                    $possible_actions = $review_flow[$record[0]->stage_etmp_stage_type]['possible_email_tmpl_actions'];

                    foreach ($record as $r) {
                        $r->is_super_admin = $is_super_admin;
                        $r->stage_etmp_action = $possible_actions[$r->stage_etmp_action];
                    }
                }

                $usr_condition ="jwf_id={$stage_id}";
                $user_details = array(
                    'jwf_import_email_form_err' => NULL
                );
                $updated_result = Generic_flows::update_record($user_details,$usr_condition,$this->current_user);

                $data_arr['assoc_tmpls_array'] = $record;
                if($action_type == 'copy'){
                    $message = customTrans('email_template.email_tmpl_copied');
                }else{
                    $message = customTrans('email_template.email_tmpl_added');
                }
                $data_arr["stage_etmp_id"] = $insertid;
            }
            return response()->json([
                'success' => true,
                'message' => $message,
                'result' => $data_arr,

            ]);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_event_email_template_actions()
    {
        try {
            $return_arr = array();
            $possible_roles = array(); //get all possible roles --start
            $cc_bcc_roles = array();

            //1. event role
            $possible_roles['User'] = 'Submitting author';
            $possible_roles['submit_author'] = 'Submitted author';
            $possible_roles['Author'] = 'Corresponding author';
            $possible_roles['article_authors'] = 'All '.CustomTrans(':article').' authors';

            //2. privileged roles and custom
            $privileged_roles = $this->RolesConfigdata('privileged_user_roles');
            $role_criteria = 'role_assigned_role NOT IN ("system", "author","reviwer")';
            $user_roles = Roles::get_all_records('role_id, role_name, role_assigned_role', $role_criteria);
            if (!empty($user_roles)) {
                foreach ($user_roles as $usrole) {
                    if (in_array($usrole->role_assigned_role, $privileged_roles) || $usrole->role_assigned_role == 'reviewer') {
                        $role_label = "All " . strtolower($usrole->role_name) . "s";
                        $possible_roles[$usrole->role_name] = $role_label;
                        $cc_bcc_roles[$usrole->role_name] = $role_label;
                    }
                }
            }
            $possible_roles['Custom'] = $cc_bcc_roles['Custom'] = 'Specific email ID';
            $return_arr['cc_bcc_roles'] = $cc_bcc_roles;
            $return_arr['possible_roles'] = $possible_roles;
            return $return_arr;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
}
