<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Config;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Http\Traits\StagemovementTrait;
use App\Http\Traits\WorkflowDataTrait;
use App\Http\Traits\SubmissionTrait;
use Illuminate\Support\Str;
use App\Http\Traits\ArticlelistTrait;
use App\Http\Traits\IthenticateTrait;
use App\Http\Traits\StandaloneDataTrait;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\ReviewerListTrait;
use App\Http\Traits\GeneralEmailTrait;
use App\Models\Article_generic_form_data;
use App\Models\Authors;
use App\Models\Generic_form_files;
use App\Models\Generic_forms;
use App\Models\Journals;
use App\Models\Stage_email_templates;
use RecursiveIteratorIterator;
use ZipArchive;
use DB;
use Illuminate\Support\Facades\Storage;

class Manage_Exportarticle_Api extends Controller
{
    use StagemovementTrait;
    use SubmissionTrait;
    use ArticlelistTrait;
    use StandaloneDataTrait;
    use IthenticateTrait;
    use UtilityTrait;
    use ReviewerListTrait;
    use GeneralEmailTrait;
    use WorkflowDataTrait;

    public function export_article_data(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                //'jnl_id' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $pre_art_ids = array();
            if ($form_data['art_id'] != '') {
                $article_id = isset($form_data['art_id']) ?  $this->decrypt_data($form_data['art_id']) : '';
                $jnlcode = isset($form_data['jnlcode']) ? $this->decrypt_data($form_data['jnlcode']) : '';
                $jnl_id = isset($form_data['jnl_id']) ? $this->decrypt_data($form_data['jnl_id']) : '';
                $aflow_id = isset($form_data['art_flow_id']) ?  $this->decrypt_data($form_data['art_flow_id']) : '';
                $core_role = isset($form_data['core_role']) ?  $this->decrypt_data($form_data['core_role']) : '';
                $role_name = isset($form_data['role_name']) ?  $this->decrypt_data($form_data['role_name']) : '';
                if($jnl_id=='')
                {
                $platform_data = $this->platform_basic_settings_data($jnlcode);
                $jnl_id = $platform_data->jnl_id;
                }
                $select_fields = "art_artp_id,artp_article_type";
                $condition = "art_id={$article_id}";
              
                $Article_types = (new \App\Models\Article_types())->getTable();

                $Articles = (new \App\Models\Articles())->getTable();
                
                $tables = array(
                    'main_table' => $Article_types,
                    'join_table' => array($Articles => array($Articles . '.art_artp_id', $Article_types . '.artp_id')
                    )
                );
                // $tables  = array(
                $result = Articles::get_results_using_joins($tables, $select_fields, $condition, 'single');
                 $rtn_data['arttypeid'] =$result->art_artp_id;
                $rtn_data['arttype']=$result->artp_article_type;
                
                $get_pdf_status = $this->get_article_pdf_status($article_id,TRUE);
                if ($get_pdf_status['status'] == FALSE)
                {
                    $rtn_data['status'] = 'warning';
                    $rtn_data['msg']    = customTrans('viewarticle.pdf_warning_msg');
                    return $this->warning('Warning', 200, $rtn_data);
                }
                // $Article_types_name = (new \App\Models\Article_types())->getTable();
                $Journals = new \App\Models\Journals();
                // $Journals_name = ($Journals)->getTable();
                // $article_data = Articles::get_single_record('art_prev_article_id,art_transfer_article,art_id,art_artp_id,art_status,art_title,art_abstract,art_no_of_tables,art_no_of_figures,art_code,art_article_upload_path,art_copyright_pdf_name,art_pre_all_ids,art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,(select artp_abbr_article_type from ' . $Article_types_name . ' where artp_id = art_artp_id) as artp_code,(select artp_article_type from ' .  $Article_types_name . ' where  artp_id = art_published_article_type) as published_artp_name,(select jnl_journal_code from ' . $Journals_name . ',' .  $Article_types_name . ' where jnl_id = artp_jnl_id and  artp_id = art_artp_id) as jnl_code', 'art_id=' . $article_id);
                $select = 'art_prev_article_id,art_transfer_article,art_id,art_artp_id,art_code as current_art_code,art_status,art_title,art_id,art_abstract,art_pre_all_ids,art_no_of_tables,art_no_of_figures,artp_id,art_code,art_transfer_article,art_copyright_pdf_name,art_article_upload_path,art_doi,aflw_id,aflw_due_date,jwf_stage_name,jnl_id,jnl_journal_code as jnl_code,jnl_journal_name,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,artp_abbr_article_type as artp_code,artp_article_type as published_artp_name,jnl_id,art_chapter_order';
                $article_data = Articles::get_article_details($select,'art_id =' . $article_id);
                $article_data = $article_data[0];
                //fetch base article details
                if (isset($article_data->art_pre_all_ids) && $article_data->art_pre_all_ids != '') {

                    $article_data->jnl_id = $jnl_id;


                    $pre_art_ids = explode(',', $article_data->art_pre_all_ids);
                    if (isset($pre_art_ids[0]) && $pre_art_ids[0] != '') {
                        $base_article_data = Articles::get_single_record('art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year', 'art_id=' . $pre_art_ids[0]);
                        if (isset($base_article_data->current_art_code)) {
                            $article_data->resubmit_day = $article_data->submit_day;
                            $article_data->resubmit_month = $article_data->submit_month;
                            $article_data->resubmit_year = $article_data->submit_year;

                            $article_data->submit_day = $base_article_data->submit_day;
                            $article_data->submit_month = $base_article_data->submit_month;
                            $article_data->submit_year = $base_article_data->submit_year;
                        }
                    }
                }

                // Load email config for the current user
                $export = 'clients.' . $this->current_client->clnt_client_code . '.remote_file_transfer.export_article';
                $export_data = Config::get($export);
                $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
		        $prefixPath = storage_path()  . $file_storage_path ;
                $path = $prefixPath . 'uploads/' . $article_data->art_article_upload_path;

                $Article_pdf = new \App\Models\Article_pdf();
                $Article_pdf_name = ($Article_pdf)->getTable();
                //get article pdf
                $where_cnd = ' `pdf_id` = (select max(`pdf_id`) from ' . $Article_pdf_name . ' where `pdf_art_id` = ' . $article_id . '  and `pdf_show_status`= \'y\')';
                $article_pdf = $Article_pdf::get_single_record('pdf_name', $where_cnd);

                $where_file_condition = 'atmnt_art_id =' . $article_id . ' AND  FIND_array_intersect("p",REPLACE(REPLACE(REPLACE(atmnt_designated_to,\'"\',""),"]",""),"[","")) = 1';
                $Attachment_files = new \App\Models\Attachment_files();
                $article_attachemnt_data = $Attachment_files::get_all_records('atmnt_orginal_upload_path,atmnt_file_name,atmnt_metadata_file', $where_file_condition);

                //fetch supplementary files
                $Article_supplementary_files = new \App\Models\Article_supplementary_files();
                $article_supplement_data = $Article_supplementary_files::get_all_records('asup_file_name', 'asup_art_id=' . $article_id);
                //fetch journal meta
                $journals = Journals::get_single_record('jnl_journal_name', 'jnl_id=' . $jnl_id);
                $article_data->jnl_journal_name=$journals->jnl_journal_name;
                $Journals_tbl = (new \App\Models\Journals())->getTable();
                $select_meta = 'jnl_journal_name,gdata_label,gdata_data';
                $tables_meta = array(
                    'main_table' => $Journals_tbl,
                    'join_table' => array(
                        'rvw_article_gnf_form_data_'.$jnlcode => array('rvw_article_gnf_form_data_'.$jnlcode.'.gdata_atf_id', $Journals_tbl . '.jnl_metadata_id'),
                    )
                );
                $meta_condition = "jnl_journal_code='" .$jnlcode . "'";
                $meta_form_data = Generic_forms::get_results_using_joins($tables_meta, $select_meta, $meta_condition, 'all');
                $ppub = $epub = '';
                $iet_prefix = 'n';
                if(count($meta_form_data) > 0){
                    foreach ($meta_form_data as $meta_data) {
                        if (strtolower($meta_data->gdata_label) == 'e-issn')
                            $epub = $meta_data->gdata_data;
                        elseif (strtolower($meta_data->gdata_label) == 'issn')
                            $ppub = $meta_data->gdata_data;
                        elseif (strpos(strtolower($meta_data->gdata_label), 'prefix') > 0)
                            $iet_prefix = $meta_data->gdata_data;
                    }
                }else{
                    $Journal_metadata = new \App\Models\Journal_metadata();
                    $journal_meta = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value', "jm_journal_code ='" . $jnlcode . "'  AND jm_client_id=" . $this->current_client->clnt_id);
                    foreach ($journal_meta as $jnl_meta) {
                        if ($jnl_meta->jm_meta_name == 'e_issn')
                            $epub = $jnl_meta->jm_meta_value;
                        elseif ($jnl_meta->jm_meta_name == 'issn')
                            $ppub = $jnl_meta->jm_meta_value;
                        elseif ($jnl_meta->jm_meta_name == 'iet_prefix')
                            $iet_prefix = $jnl_meta->jm_meta_value;
                    }
                }
                $pub = array(
                    'epub' => $epub,
                    'ppub' => $ppub,
                    'iet_prefix' => $iet_prefix,
                );

                //load doi library
                $details = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
                $doi_details = Config::get($details);

                $DOI_data = $this->create_article_doi($article_id, $doi_details, $iet_prefix);

                $DOI_data['doi_details'] = $doi_details;

                $export_time = date('d-m-Y_H:i:s');
                $file_list = array();
                $internal_file_structure = array(
                    'file_name' => array(
                        'label' => 'File name',
                        'value' => $DOI_data['manuscript_except_revision'],
                    ),
                    'file_title' => $DOI_data['manuscript_except_revision'],
                    'export_date' => array(
                        'label' => 'Exported On',
                        'value' => date('d M Y H:i:s'),
                    ),
                    'output_format' => array(
                        'label' => 'Output Format',
                        'value' => 'XML (ReView DTD)',
                    ),
                );

                $folder_name = $article_data->art_code;
                if (!file_exists($path . '/' . $export_time . '/' . $folder_name)) {
                    mkdir($path . '/' . $export_time . '/' . $folder_name, 0765, TRUE);
                }

                $export_location =  $export_time . '/' . $folder_name;
                $folder_path = $path . '/' . $export_location;
                //generating client xml file
                if($export_data['xml_function']=="build_xml_default")
                    $this->build_xml_default($article_data, $DOI_data, $folder_path, $pub);
                else
                    $this->build_xml_iet($article_data, $DOI_data, $folder_path, $pub);
                
                //copy attachment files
                $folder_path_doc = $folder_path . '/doc';
                mkdir($folder_path_doc, 0765, TRUE);
                $i = 0;
                foreach ($article_attachemnt_data as $att_file) {
                    //Upgrade #2293 Manage review uploads
                    $source_path = $prefixPath . 'uploads/' . $att_file->atmnt_orginal_upload_path;

                    $temp_file = explode('/', $att_file->atmnt_file_name);

                    if (count($temp_file) > 1) {
                        if (!file_exists($folder_path_doc . '/' . $temp_file[0])) {
                            $temp_filename = end($temp_file);
                            $temp_file_key = count($temp_file) - 1;
                            if($att_file->atmnt_metadata_file == 'y' && (isset($this->current_client->functionality->cfty_include_short_metadata_file) && $this->current_client->functionality->cfty_include_short_metadata_file == 'y'))
                            {
                                $filename = $this->recurse_copy($source_path . '/' . $temp_file[0], $folder_path . '/' . $temp_file[0], $article_data->art_code, $temp_filename);
                                $temp_file[$temp_file_key] = $filename;
                                $new_file_name = implode('/', $temp_file);
                                    $file_list[] = array(
                                        'name' => $DOI_data['manuscript_except_revision'] . '/'.$new_file_name,
                                        'version' => ''
                                    );
                            }
                            else
                            {
                                $filename = $this->recurse_copy($source_path . '/' . $temp_file[0], $folder_path_doc . '/' . $temp_file[0], $article_data->art_code, $temp_filename);
                                $temp_file[$temp_file_key] = $filename;
                                $new_file_name = implode('/', $temp_file);
                                $file_list[] = array(
                                    'name' => $DOI_data['manuscript_except_revision'] . '/doc/' . $new_file_name,
                                    'version' => 'Version 1.0',
                                );
                               
                            }
                        }
                    } else {
                        if (file_exists($source_path . '/' . $att_file->atmnt_file_name)) {
                            $i++;
                            $filename_cnt = '';
                            if (count($article_attachemnt_data) > 1)
                                $filename_cnt = $i;
                                if($att_file->atmnt_metadata_file == 'y' && (isset($this->current_client->functionality->cfty_include_short_metadata_file) && $this->current_client->functionality->cfty_include_short_metadata_file == 'y'))
                                {
                                    $filename = $article_data->art_code.'-metadata-jats.xml';
                                    copy($source_path . '/' . $att_file->atmnt_file_name, $folder_path . '/' . $filename);
                                    $file_list[] = array(
                                        'name' => $DOI_data['manuscript_except_revision'] .  '/'.$filename,
                                        'version' => ''
                                    );
                                }
                                else
                                {    
                                    $filename = $this->file_name_manipulation($att_file->atmnt_file_name, $article_data->art_code, $filename_cnt);
                                    copy($source_path . '/' . $att_file->atmnt_file_name, $folder_path_doc . '/' . $filename);
                                    $file_list[] = array(
                                        'name' => $DOI_data['manuscript_except_revision'] . '/doc/' . $filename,
                                        'version' => 'Version 1.0',
                                    );
                                }
                        }
                    }
                }

                //copy custome form files
                if ($article_data->art_pre_all_ids != '') {
                    $stage_form_cnd = 'gdata_art_id in (' . $article_data->art_pre_all_ids . ',' . $article_id . ') and gdata_element_type = "file" ';
                } else {
                    $stage_form_cnd = 'gdata_art_id =' . $article_id . ' and gdata_element_type = "file" ';
                }
                $generic_form_files = Article_generic_form_data::get_all_records('*', $stage_form_cnd, NULL, NULL, "_" . $article_data->jnl_code);
                if (!empty($generic_form_files)) {
                    foreach ($generic_form_files as $gen_frm_files) {
                        $article_code_for_stage = Articles::get_single_record_with_bind_cond('art_code', array('art_id' => $gen_frm_files->gdata_art_id));
                        $article_code_for_stage = $article_code_for_stage->art_code;
                        $sql = "SELECT jwf_stage_name FROM rvw_journal_workflows JOIN rvw_article_flow on jwf_id=aflw_jwf_id where aflw_id = " . $gen_frm_files->gdata_artflw_id;
                        $get_stage_type = Article_flow::get_records_by_raw_query($sql);
                        $folder_path_forms = $folder_path . '/stage_files/' . $article_code_for_stage . '/' . $get_stage_type[0]->jwf_stage_name;
                        if (!file_exists($folder_path_forms)) {
                            mkdir($folder_path_forms, 0765, TRUE);
                        }
                        if ($gen_frm_files->gdata_data != '') {
                            //start - making adjustments to incoparate dynamic form elements
                            $file_str = $this->convert_gdata_to_comma_seperated_data($gen_frm_files);
                            //end - making adjustments to incoparate dynamic form elements
                            if ($file_str != '') {
                                $gen_file = Generic_form_files::get_all_records('agf_original_upload_path,agf_name,agf_id,agf_posted_by', '`agf_id` IN (' . $file_str . ')');
                                foreach ($gen_file as $each_file) {
                                    $source_path = $prefixPath.'uploads/' . $each_file->agf_original_upload_path . '/' . $each_file->agf_name;
                                    if (!file_exists($source_path)){
                                        continue;
                                    }
                                    copy($source_path, $folder_path_forms . '/' . $each_file->agf_name);
                                    $file_list[] = array(
                                        'name' => $DOI_data['manuscript_except_revision'] . '/stage_files/' . $article_code_for_stage . '/' . $get_stage_type[0]->jwf_stage_name . '/' . $each_file->agf_name,
                                        'version' => '',
                                    );
                                }
                            }
                        }
                    }
                }

                //copy supplementary files
                if (count($article_supplement_data) > 0) {
                    $folder_path_supplements = $folder_path . '/supplements';
                    mkdir($folder_path_supplements, 0765, TRUE);
                    $i = 0;
                    foreach ($article_supplement_data as $supp_file) {
                        if (!file_exists($path . '/supplementary_files/' . $supp_file->asup_file_name))
                            continue;
                        $i++;
                        $filename_cnt = '';
                        if (count($article_supplement_data) > 1)
                            $filename_cnt = $i;
                        $filename = $this->file_name_manipulation($supp_file->asup_file_name, $article_data->art_code, $filename_cnt);

                        copy($path . '/supplementary_files/' . $supp_file->asup_file_name, $folder_path_supplements . '/' . $filename);

                        $file_list[] = array(
                            'name' => $DOI_data['manuscript_except_revision'] . '/supplements/' . $filename,
                            'version' => 'Version 1.0',
                        );
                    }
                }

                //copy licence form
                $folder_path_form = $folder_path . '/form';
                if (!file_exists($folder_path_form)) {
                    mkdir($folder_path_form, 0765, TRUE);
                }
                if (file_exists($path . '/' . $article_data->art_copyright_pdf_name) && $article_data->art_copyright_pdf_name != '') {
                    $filename = str_replace('copyright', $article_data->art_code, $article_data->art_copyright_pdf_name);
                    copy($path . '/' . $article_data->art_copyright_pdf_name, $folder_path_form . '/' . $filename);
                    $file_list[] = array(
                        'name' => $DOI_data['manuscript_except_revision'] . '/form/' . $filename,
                        'version' => '',
                    );
                }

                //copy article final pdf
                if (isset($article_pdf->pdf_name)) {
                    $folder_path_pdf = $folder_path . '/pdf';
                    mkdir($folder_path_pdf, 0765, TRUE);
                    if (file_exists($path . '/' . $article_pdf->pdf_name) && $article_pdf->pdf_name != '') {
                        $filename = $this->file_name_manipulation($article_pdf->pdf_name, $DOI_data['manuscript_except_revision']);

                        copy($path . '/' . $article_pdf->pdf_name, $folder_path_pdf . '/' . $filename);
                        $file_list[] = array(
                            'name' => $DOI_data['manuscript_except_revision'] . '/pdf/' . $filename,
                            'version' => '',
                        );
                    }
                }

                //generate html file
                $file_location_html = $folder_path . '/' . $DOI_data['manuscript_except_revision'] . '-manifest.html';
                $file_list[] = array(
                    'name' => $DOI_data['manuscript_except_revision'] . '/' . $DOI_data['manuscript_except_revision'] . '-metadata.xml',
                    'version' => '',
                );

                // start -- Support #1571 IET Export XML DTD
                $dtdfile = isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y' ? 'ReView_Conf.dtd':'ReView.dtd';
                $dtd_file_path = base_path() . '/config/clients/' . $this->current_client->clnt_client_code . '/'.$dtdfile;
                $dest_dtd_path = $folder_path . '/'.$dtdfile;
                
                if (file_exists($dtd_file_path) && isset($this->current_client->functionality->cfty_export_xml_dtd_validation) && $this->current_client->functionality->cfty_export_xml_dtd_validation == 'y') {
                    copy($dtd_file_path, $dest_dtd_path);
                    if (file_exists($dest_dtd_path)) {
                        $file_list[] = array(
                            'name' => $dtdfile,
                            'version' => '',
                        );
                        $xml_file = $folder_path . '/' . $DOI_data['manuscript_except_revision'] . '-metadata.xml';
                        //validate dtd and xml file

                        $shell_cmd = 'xmllint --valid --noout ' . $xml_file . ' 2>&1; echo $?';
                        $error = shell_exec($shell_cmd);

                        $error_len = strlen(trim($error));

                        //if(!empty($error) && $error != 0)
                        if ($error_len > 1 || $error != 0) {
                            $key = Str::random(4);
                            $this->report_dtd_issue($error, $article_data->art_code, $key, $xml_file, $journals->jnl_journal_name);
                            //need to replace ref. no
                            $return_arr['msg'] = str_replace('%REF-NO%', $key, customTrans('viewarticle.export_fail_dtd'));
                            echo json_encode($return_arr);
                            exit;
                        }
                    }
                }
                
                // end -- Support #1571 IET Export XML DTD
                $file_list[] = array(
                    'name' => $DOI_data['manuscript_except_revision'] . '-manifest.html',
                    'version' => 'This document',
                );

                $internal_file_structure['file_list'] = $file_list;
                $html_string = $this->get_html_string($internal_file_structure);
		        file_put_contents($file_location_html, $html_string);

                $zip_flag = FALSE;
                $sors_location = $path . '/' . $export_time . '/';//suggested by sarath
                //correction in export section
                if (isset($this->current_client->functionality->cfty_create_zip_using_shell) && $this->current_client->functionality->cfty_create_zip_using_shell == 'y') {
                   $dest_location = $path;

                    $zip_flag = $this->createRVzip($sors_location, $dest_location, $folder_name, $folder_name);
                } else {
                    $zip_flag = $this->createZip($folder_path, $path . '/' . $folder_name . '.zip');
                }

                $result = array(
                    'status' => 'failed'
                );

                if ($zip_flag == TRUE) {
                    $result = $this->ftp_upload_to_server($path . '/' . $folder_name . '.zip', $jnlcode, $folder_name . '_' . $export_time . '.zip',NULL,$jnl_id);
                    if ($result['status'] == 'failed') {
                        $return_arr['status'] = 'failed';
                        $return_arr['msg'] = implode('<br/>', $result['host_list']);
                        if(empty($result['host_list'])){
                            $return_arr['msg'] = 'Please provide FTP informations to export';
                        }
                    }
                } else
                    $return_arr['msg'] = customTrans('viewarticle.arch_failed');

                if ($result['status'] == 'success') {
                    $Article_export_data = new \App\Models\Article_export_data();
                    //insert export data
                    $insert_data = array(
                        'exp_art_id' => $article_id,
                        'exp_jnl_id' => $jnl_id,
                        'exp_user_id' => $this->current_user['user_id']
                    );
                    $Article_export_data::insert_record($insert_data, $this->current_user);

                    if (file_exists($path . '/' . $folder_name . '.zip'))
                        unlink($path . '/' . $folder_name . '.zip');
                        
                        $this->delete_files($sors_location, TRUE);
                        rmdir($sors_location);

                    //1.Upgrade #2293 Manage review uploads
                    // $this->clean_export_article_data(TRUE, $article_id);
                    $pre_art_ids[] = $article_id;
                    // $this->clean_view_article_pdf_data(TRUE, $pre_art_ids);

                    if (count($result['host_list']) > 1) {
                        //export failed
                        $return_arr['status'] = $result['fail_any_one'];
                        $return_arr['msg'] = implode('</br>', $result['host_list']);
                        //					$return_arr['redirect_url'] = '';
                    } else {
                        //export success
                        $return_arr['status'] = $result['status'];
                        $return_arr['msg'] = customTrans('viewarticle.export_success_single');
                        //$return_arr['redirect_url'] =base_url()."journal/" . $journal_code;
                    }
                    if ($aflow_id != NULL) {
                        $flow_detail = Article_flow::get_single_record('aflw_status,aflw_jwf_id', 'aflw_id=' . $aflow_id);
                        if (isset($flow_detail) && ($flow_detail->aflw_status != 'c')) {
                            $update_arr['aflw_status'] = 'c';
                            $today = date('Y-m-d H:i:s', time());
                            $update_arr['aflw_returned_date'] = $today;
                            $update_record = Article_flow::update_record($update_arr, 'aflw_id=' . $aflow_id);
                        }
                    }
                    if (isset($aflow_id) && isset($form_data['redirect_after_stage_completion'])) {
                        $return_arr['redirect_url'] = $form_data['redirect_after_stage_completion'];
                    } else {
                        $return_arr['redirect_url'] = "journal/" . $jnlcode;
                    }

                    //bug #2522 :- Redirect page issue
                    if (isset($form_data['redirect_after_stage_completion']) && strpos($form_data['redirect_after_stage_completion'], '/article-correction/') != false) {
                        $return_arr['redirect_url'] = url('journal/' . $jnlcode);
                    }
                    //$return_arr['msg'] = $result['host_list'];
                    if ($aflow_id != NULL) {
                        $condition = "stage_etmp_stage_type = 'production' AND setr_jwf_id =" . $flow_detail->aflw_jwf_id . " AND stage_etmp_action = 'export'";
                        $stage_email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
                        if ($stage_email_templates != NULL) {
                            foreach ($stage_email_templates as $template)
                            {
                                $custom_data = array(
                                    'article_id'        => $article_data->art_id,
                                    'stage_etmp_action' => $template->stage_etmp_action,
                                    'stage_etmp_to'     => $template->stage_etmp_to,
                                    'aflw_id'           => $article_data->aflw_id,
                                    'article_id'        => $article_id,
                                    'artp_id'           => $article_data->art_artp_id,
                                    'jnl_id'            => $jnl_id,
                                    'jnl_code'          => $article_data->jnl_code,
                                );
                                $email_data = array(
                                    'type' => 'stage',
                                    'action' => 'send',
                                    'email_with_login' => TRUE,
                                    'aflw_id'=>$article_data->aflw_id,
                                    'user_id' => $this->current_user['user_id'],
                                    'jnl_user_role' => array(
                                        'core_role' => $core_role,
                                        'role_name' => $role_name,
                                        'jnl_id'=>$jnl_id,
                                        'jnl_journal_code' => $article_data->jnl_code
                                    ),
                                    'custom_data' => $custom_data
                                );
                                $this->master_email_details($email_data);
                            }
                        }
                    }
                }
            }
            // echo json_encode($return_arr);
            return  $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function recurse_copy($src, $dst, $art_code = NULL, $old_file = NULL)
    {
        $new_filename = '';
        $dir = opendir($src);
        mkdir($dst, 0765);
        $file_det = new \FilesystemIterator($src, \FilesystemIterator::SKIP_DOTS);
        $i = 0;
        while (false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    $this->recurse_copy($src . '/' . $file, $dst . '/' . $file, $art_code, $old_file);
                } else {
                    $filename = $file;
                    if ($art_code != NULL) {
                        $i++;
                        $filename_cnt = '';
                        if (iterator_count($file_det) > 1)
                            $filename_cnt = $i;
                        $filename = $this->file_name_manipulation($file, $art_code, $filename_cnt);
                        if ($file == $old_file)
                            $new_filename = $filename;
                    }
                    copy($src . '/' . $file, $dst . '/' . $filename);
                }
            }
        }
        closedir($dir);
        return $new_filename;
    }
    //file name manipulation for export data
    public function file_name_manipulation($file_name, $article_id, $curr_file_cnt = '', $add_date_time = FALSE)
    {
        $file_name_art_part = $article_id;
        $file_name_cnt_part = '';
        if ($curr_file_cnt != '') {
            $file_name_cnt_part = '-File' . str_pad($curr_file_cnt, 3, "0", STR_PAD_LEFT);
        }

        $file_type_temp = explode('.', $file_name);
        $filetype = end($file_type_temp);
        $unique_date_time = '';
        if ($add_date_time == TRUE)
            $unique_date_time = '_' . date('d-m-Y_H:i:s');

        return $file_name_art_part . $file_name_cnt_part . $unique_date_time . '.' . $filetype;
    }

    //This function will send a email to review team about DTD validation failed along with failed xml
    public function report_dtd_issue($bug_report, $art_code, $issue_code, $error_xml_file, $jnl_journal_name)
    {
        $bug_report = str_replace('/n', '<br/>', $bug_report);

        $subject = '[' . $issue_code . '] ' . $this->current_client->clnt_client_name . ' XML DTD Validation issue on ' . $art_code;
        $body = '<p>Reference no : ' . $issue_code . '<br>';
        $body .= 'Article Details<br>';
        $body .= 'Client : ' . $this->current_client->clnt_client_name . '<br>';
        $body .= 'Journal : ' . $jnl_journal_name . '<br>';
        $body .= 'Article code : ' . $art_code . '<p><br>';
        $body .= '<p>Issue list <br>';
        $body .= 'Error msg : ' . $bug_report . '<p>';

        $this->send_email_to_team_review($subject, $body, $error_xml_file);

        return;
    }



    //create zip using review function
    public function createRVzip($sourse_location, $destination_location, $zip_name, $zip_folder_name)
    {
        //take root path
        $root_location = getcwd();

        //change root directory to article path location
        chdir($sourse_location);

        $zip_shell_cmd = ' zip -r ' . $destination_location . '/' . $zip_name . '.zip ' . $zip_folder_name;
        $zip_flag = shell_exec($zip_shell_cmd);

        //reset to root path
        chdir($root_location);

        $flag = FALSE;

        if ($zip_flag != '')
            $flag = TRUE;

        return $flag;
    }

    public function createZip($source, $destination)
    {
        if (!extension_loaded('zip') || !file_exists($source)) {
            return false;
        }

        $zip = new \ZipArchive();
        if (!$zip->open($destination, ZipArchive::CREATE)) {
            return false;
        }

        $source = str_replace('\\', '/', realpath($source));

        if (is_dir($source) === true) {
            $files = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);

            foreach ($files as $file) {
                $file = str_replace('\\', '/', $file);

                // Ignore "." and ".." folders
                if (in_array(substr($file, strrpos($file, '/') + 1), array(
                    '.',
                    '..'
                )))
                    continue;

                $file = realpath($file);

                if (is_dir($file) === true) {
                    $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
                } else if (is_file($file) === true) {
                    $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
                }
            }
        } else if (is_file($source) === true) {
            $zip->addFromString(basename($source), file_get_contents($source));
        }

        return $zip->close();
    }

    public function clean_export_article_data($delete_flag = FALSE, $art_id = NULL)
    {
        $Article_export_data = new \App\Models\Article_export_data();
        $select = 'jnl_journal_code,artp_abbr_article_type,exp_posted_date,exp_art_id,DATE_FORMAT(exp_posted_date,\'%Y\') as year,DATE_FORMAT(exp_posted_date,\'%m\') as month,DATE_FORMAT(exp_posted_date,\'%d\') as day,DATE_FORMAT(exp_posted_date,\'%H\') as hour,DATE_FORMAT(exp_posted_date,\'%i\') as minute';
        $Article_export_data_table = (new \App\Models\Article_export_data())->getTable();
        $Articles_table = (new \App\Models\Articles())->getTable();
        $Article_types_table = (new \App\Models\Article_types())->getTable();
        $Journals_table = (new \App\Models\Journals())->getTable();

        $tables = array(
            'main_table' => $Article_export_data_table,
            'join_table' => array(
                $Articles_table => array($Article_export_data_table . '.exp_art_id', $Articles_table . '.art_id'),
                $Article_types_table => array($Articles_table . '.art_artp_id', $Article_types_table . '.artp_id'),
                $Journals_table => array($Article_types_table . '.artp_jnl_id', $Journals_table . '.jnl_id')
            )
        );
        //$condition = ' exp_art_id IN(14699,15178) ';

        $condition = NULL;
        if ($art_id != NULL) {
            $condition = ' exp_art_id =' . $art_id;
        }

        $export_data = $Article_export_data::get_results_using_joins($tables, $select, $condition, 'all' ,'exp_art_id');

        $del_files = array();
        $exp_folders = array();
        if (count($export_data) > 0) {
            $exp_folders_sub = array();
            $art_id_temp = '';
            foreach ($export_data as $exp_dta) {
                if ($art_id_temp != '' && $art_id_temp != $exp_dta->exp_art_id) {
                    if (count($exp_folders_sub) > 1) {
                        end($exp_folders_sub);
                        $end_index = key($exp_folders_sub);
                        unset($exp_folders_sub[$end_index]);
                        $exp_folders[$art_id_temp] = array_unique($exp_folders_sub);
                        $del_files[] = $this->clear_data($exp_folders_sub, $delete_flag);
                    }
                    $exp_folders_sub = array();
                }

                $export_folder_name = $exp_dta->day . '-' . $exp_dta->month . '-' . $exp_dta->year . '_' . $exp_dta->hour . ':' . $exp_dta->minute . ':';
                $export_folder_name_symbol = $exp_dta->day . '\-' . $exp_dta->month . '\-' . $exp_dta->year . '\_' . $exp_dta->hour . ':' . $exp_dta->minute . ':';
                $source = APP_DOC_PATH . $exp_dta->jnl_journal_code . '/' . $exp_dta->artp_abbr_article_type . '/' . $exp_dta->exp_art_id;

                $match = '/^(' . $export_folder_name_symbol . ')[0-9]{2}$/';
                if (file_exists($source) && $dh = opendir($source)) {
                    while (($file = readdir($dh)) !== false) {
                        if ($file != '.' && $file != '..') {
                            if (preg_match($match, trim($file)) == TRUE)
                                $exp_folders_sub[] = $source . '/' . $file;
                        }
                    }

                    closedir($dh);
                }
                $art_id_temp = $exp_dta->exp_art_id;
            }
            if (count($exp_folders_sub) > 1) {
                end($exp_folders_sub);
                $end_index = key($exp_folders_sub);
                unset($exp_folders_sub[$end_index]);
                $exp_folders[$art_id_temp] = array_unique($exp_folders_sub);
                $del_files[] = $this->clear_data($exp_folders_sub, $delete_flag);
            }
        }

        return array(
            'for_delete_files' => $exp_folders,
            'files_deleted' => $del_files,
        );
    }

    public function clear_data($data_arr, $delete_flag = FALSE)
    {
        $return = array();
        if (count($data_arr) > 0 && $delete_flag == TRUE) {
            foreach ($data_arr as $data) {
                if (file_exists($data)) {
                    if (is_dir($data)) {
                        delfolder($data);
                    } else {
                        unlink($data);
                    }
                    $return[] = $data;
                }
            }
        }
        return $return;
    }


    public function clean_view_article_pdf_data($delete_flag = FALSE, $art_ids = array())
    {

        $Article_pdf = new \App\Models\Article_pdf();
        $Article_pdf_table = (new \App\Models\Article_pdf())->getTable();
        $Articles_table = (new \App\Models\Articles())->getTable();
        $Article_types_table = (new \App\Models\Article_types())->getTable();
        $Journals_table = (new \App\Models\Journals())->getTable();


        $select = 'jnl_journal_code,artp_abbr_article_type,art_id,pdf_name';

        $tables = array(
            'main_table' => $Article_pdf_table,
            'join_table' => array(
                $Articles_table => array($Article_pdf_table . '.pdf_art_id', $Articles_table . '.art_id'),
                $Article_types_table => array($Articles_table . '.art_artp_id', $Article_types_table . '.artp_id'),
                $Journals_table => array($Article_types_table . '.artp_jnl_id', $Journals_table . '.jnl_id')
            )
        );


        $condition = ' pdf_show_status = \'n\' ';
        //1.Upgrade #2293 Manage review uploads
        if (count($art_ids) > 0) {
            $condition .= '  AND  pdf_art_id IN ( ' . implode(',', $art_ids) . ') ';
        }

        $pdf_data = $Article_pdf::get_results_using_joins($tables, $select, $condition, 'all', 'pdf_art_id');

        $source_data = $sorce_org_data = $source_pdf_data = array();
        if (count($pdf_data) > 0) {
            foreach ($pdf_data as $pdf) {
                $pdf_name = trim($pdf->pdf_name);
                $pdf_location = APP_DOC_PATH . $pdf->jnl_journal_code . '/' . $pdf->artp_abbr_article_type . '/' . $pdf->art_id . '/';
                $source  = $pdf_location . $pdf_name;

                if (file_exists($source)) {
                    $sorce_org_data[] = $source;
                    if ($delete_flag == TRUE) {
                        $source_data[] = $source;
                        unlink($source);

                        //delete pdf support folder
                        $temp_pdf = str_replace('.pdf', '', $pdf_name);
                        $source_pdf_data[] = $pdf_location . $temp_pdf;
                    }
                }
            }

            $this->clear_data($source_pdf_data, $delete_flag);
        }

        return array(
            'for_delete_files' => $sorce_org_data,
            'files_deleted' => $source_data,
        );
    }

    /**
     * Task 2997 Development: Basecamp Ticket - JATS XML Export
     * article id input needed
     */

     public function buildSpecificJatsXml($artId)
     {
         //sample return variable
         /*
         $artId = 13915;
         $artCode = 'BIBN-2022-038-R2';
         $return =  array(
             'filename'=> $artCode.'-metadata-jats.xml',
             'path' => 'acrt/RESP/1480', //sample path (journalcode/articletype code/articleid)
             'size'=> '145' //kb
         );
         $artPath = 'jcien/PPR/13915';//for temp purpose
         */
         $return =  array(
             'filename'=> '',
             'path' => '', 
             'size'=> '' //kb
         );
 
         $volumeArr = array(
             '2025' => 4,
             '2026' => 5,
             '2027' => 6,
             '2028' => 7,
             '2029' => 8,
         );
         $currYear = date('Y');
         if(!empty($artId))
         {
             $artTable = (new \App\Models\Articles())->getTable();
             $articletypeTable = (new \App\Models\Article_types())->getTable();
             $journalTable = (new \App\Models\Journals())->getTable();

             /*
             //Input data validation section
             $input_arr = array(
                 'input' => $artId,
                 'type'=> 'number'
             );
             $jnl_id_validate = $this->Rv_validator($input_arr);
             */
 
             //Data fetching section
             $select = 'art_id,art_code,art_doi,art_article_upload_path,art_title,art_abstract,art_pre_all_ids,artp_id,artp_article_type,DATE_FORMAT(art_final_decision_date,\'%d\') as decision_day,DATE_FORMAT(art_final_decision_date,\'%m\') as decision_month,DATE_FORMAT(art_final_decision_date,\'%Y\') as decision_year,jnl_journal_code,jnl_journal_name,jnl_metadata_id';
             $cond = array(
                 'art_id' => $artId
             );
             $tables = array(
                 'main_table' => $artTable,
                 'join_table' => array(
                    $articletypeTable => array('artp_id','art_artp_id'),
                    $journalTable => array('artp_jnl_id','jnl_id'),
                 )
             );
             $artData = Articles::get_results_using_joins($tables, $select, $cond, 'single');
 
             
             //if successful data is there
             if(!empty($artData))
             {
                 $articleCode = $artData->art_code;
                 $artDoi = trim($artData->art_doi);
                 $exartDoi = explode('/',$artDoi);
                 $baseArtcode = '';
                 if(isset($exartDoi['1']))
                 {
                     $baseArtcode = $exartDoi['1'];
                     $exartDoi['1'] =  preg_replace("/[^A-Za-z0-9]/", "", $baseArtcode);
                     $artDoi = strtolower(implode('/',$exartDoi));
                 }
                 
                 $artPath = $artData->art_article_upload_path;
                 $fileName =  $articleCode.'-metadata-jats.xml';
                 $file_location =  APP_DOC_PATH.$artPath;
                 $file_location = $this->get_upload_path($file_location,local_location:true);
                 if(file_exists($file_location))
                 {
                     $file_location =  $file_location.'/'.$fileName; 
                     $return['filename'] = $fileName;
                     $return['path'] = $artPath;
 
                     //XML building section
                     $doc_type_str  = '<?xml version="1.0" encoding="UTF-8"?>';
                     $xml_string = $doc_type_str.'<article xml:lang="en" xmlns:xlink="http://www.w3.org/1999/xlink"></article>';
                     file_put_contents($file_location, $xml_string);
 
 
                     $doc = new \DOMDocument('1.0', 'UTF-8');
                     $doc->formatOutput = false;
                     $doc->load($file_location);
 
                     $xpath = new \DOMXpath($doc);
                     $root_element = $xpath->query('//article');
                 
                     //create front tag
                     $front_node = $doc->createElement('front');
 
                    //ADD JOURNAL META
                    //$this->buildartJournalmeta($doc, $front_node,$artData);

                     //create article-meta tag
                     $articlemeta_node = $doc->createElement('article-meta');
 
                     //create article-id tag
                     $articleid_node = $doc->createElement('article-id',$articleCode);
                     $articleid_node->setAttribute('pub-id-type','publisher-id');
 
                     $articlemeta_node->appendChild($articleid_node);
 
                     //create article-id tag
                     $articleid_node = $doc->createElement('article-id',$artDoi);
                     $articleid_node->setAttribute('pub-id-type','doi');
                     
                     $articlemeta_node->appendChild($articleid_node);
 
                     //create article-categories tag
                     $newTagArr = array(
                         'subj-group' => array(
                             'attrib' => array(
                             'subj-group-type' => 'heading',
                             ),
                             'child_nodes'=>array(
                                 '1' => array(
                                     'node' => 'subject',
                                     'value' => $artData->artp_article_type
                                 ),
                             ),
                         ),
                     );
 
                     $newTag = 'article-categories';
                     $this->generate_node($doc, $articlemeta_node, $newTag, $newTagArr);
                     
                     //create title-group tag
                    $artTitle = preg_replace('/^<p>(.*)<\/p>$/s', '$1', $artData->art_title);
                    $newTagArr = array(
                         'article-title' => $this->filter_html_contents($artTitle)
                     );
                     $newTag = 'title-group';
                     $this->generate_node($doc, $articlemeta_node, $newTag, $newTagArr);
                     
                     //BUILD CONTRIB
                     $this->buildContrib($doc, $articlemeta_node,$artId);
 
                     //VOLUME
                     if(isset($volumeArr[$currYear]))
                     {
                         $volume_node = $doc->createElement('volume',$volumeArr[$currYear]);
                         $articlemeta_node->appendChild($volume_node);
                     }
                     
                     //BUILD HISTORY TAG
                     $this->buildHistory($doc, $articlemeta_node,$artData);
 
                     //BUILD PERMISSION TAG
                     $this->buildPermission($doc, $articlemeta_node);
 
                     //ADD ABSTRACT
                     $abstract_node = $doc->createElement('abstract');
                     $abstract_node->setAttribute('abstract-type','simple');
                     $abstractStr = preg_replace('/^<p>(.*)<\/p>$/s', '$1', $artData->art_abstract);
                     $arrAbstruct = array(
                         'p'=> $this->filter_html_contents($abstractStr)
                     );
                     $this->generate_node($doc, $articlemeta_node, $abstract_node, $arrAbstruct,true);
                     
                     //BUILD ARTICLE KEYWORD TAG
                     $this->buildartKeywords($doc, $articlemeta_node,$artId);
 
                     //TAGS APPENDING SECTION
                     //append article-meta tag
                     $front_node->appendChild($articlemeta_node);
 
                     //append front tag
                     $root_node = $root_element->item(0);
                     $root_node->appendChild($front_node);
 
                     $doc->saveXML();
                     $doc->save($file_location);
 
                     //get file size
                     if(file_exists($file_location))
                     {
                         $bytes = filesize($file_location); // size in bytes
                         $return['size'] = round($bytes / 1024, 2);

                         //if s3 then push to s3 path
                        if ($this->current_client->enable_upload_s3_bucket == 'y')
                        {
                            $s3Path = 'uploads/'.$artPath.'/'.$fileName;
                            Storage::disk('s3')->put($s3Path, fopen($file_location, 'r+'));
                        }
                     }
                 }
             }
         }
         
         return $return;
     }

     /**
     * this is private function and no additional article testings
     * HERE BUILD ARTILCE AUTHOR TAGS
     */
    private function buildContrib($doc, $articlemeta_node,$artId)
    {
        $authTable = (new \App\Models\Authors())->getTable();
		$userTable = (new \App\Models\User())->getTable();
        $authaffTable = (new \App\Models\Authors_affiliation())->getTable();
        $contryTable = (new \App\Models\Country())->getTable();

        $select = 'auth_id,usr_id,usr_first_name,usr_middle_name,usr_last_name,auth_corr_author,auaff_department,auaff_company,auaff_state,cnt_country,usr_email,auaff_address_line2';
        $cond = array(
            'auth_art_id' => $artId
        );
        $tables = array(
            'main_table' => $authTable,
            'join_table' => array(
                $userTable => array('auth_usr_id','usr_id'),
                $authaffTable => array('auaff_auth_id','auth_id'),
                $contryTable => array('auaff_cnt_id','cnt_id'),
            )
        );
        $athData = Authors::get_results_using_joins($tables, $select, $cond, 'all','auth_id');
        
        if(!empty($athData))
        {
            $autharr = array();
            $i = 1;
            
            $contribGroup_node = $doc->createElement('contrib-group');
            $affid = '';
            $affData = $authorNotearr = array();
            foreach($athData as $key=>$value)
            {
                if($affid == '' || $affid != $value->auth_id)
                {
                    $contrib_node = $doc->createElement('contrib');
                    $contrib_node->setAttribute('contrib-type','author');
                    if($value->auth_corr_author == 'y')
                    {
                        $contrib_node->setAttribute('corresp','yes');
                    }
                    
                    $authnameArr =  array(
                        'name' => array(
                            'child_nodes'=>array(
                                '0' => array(
                                    'node' => 'surname',
                                    'value' => $value->usr_last_name
                                ),
                                '1' => array(
                                    'node' => 'given-names',
                                    'value' => $value->usr_first_name
                                ),
                            ),
                        ),
                    );
                    $this->generate_node($doc, $contribGroup_node, $contrib_node, $authnameArr,true);
                }
                $affid = $value->auth_id;
                $affArr = array(
                    'xref' => array(
                        'attrib' => array(
                            'ref-type' => 'aff',
                            'rid' => 'aff'.$i
                        ),
                        'child_nodes'=> array(
                            '0' => array(
                                'node' => 'sup',
                                'value' => $i
                            ),
                        ),
                    ),
                );
                $this->generate_node($doc, $contribGroup_node, $contrib_node, $affArr,true);
                if($value->auth_corr_author == 'y')
                {
                    $xref_node = $doc->createElement('xref','*');
                    $xref_node->setAttribute('ref-type','corresp');
                    $xref_node->setAttribute('rid','cor001');
                    
                    $contrib_node->appendChild($xref_node);

                    $authorNotearr['cor001'] = $value->usr_email;
                }
                $affData['aff'.$i]  = array(
                    'auaff_department' => $value->auaff_department,
                    'auaff_company' => $value->auaff_company,
                    'auaff_address_line2' =>$value->auaff_address_line2,
                    'cnt_country' => $value->cnt_country,
                );

                $i++;
            }

            //adding affiliation
            if(!empty($affData))
            {
                $i = 1;
                foreach($affData as $key => $value)
                {
                    $aff_node = $doc->createElement('aff');
                    $aff_node->setAttribute('id',$key);
                    
                    $label_node = $doc->createElement('label');
                    $sup_node = $doc->createElement('sup',$i);
                    $label_node->appendChild($sup_node);

                    $aff_node->appendChild($label_node);

                    if(!empty($value['auaff_department']))
                    {
                        $addl_node = $doc->createElement('addr-line',$this->filter_html_contents($value['auaff_department']));
                        $addl_node->setAttribute('content-type','department');
                        $aff_node->appendChild($addl_node);
                    }
                    
                    if(!empty($value['auaff_company']))
                    {
                        $co_node = $doc->createElement('institution',$this->filter_html_contents($value['auaff_company']));
                        $aff_node->appendChild($co_node);
                    }
                    
                    
                    //city needed
                    if(!empty($value['auaff_address_line2']))
                    {
                        $city_node = $doc->createElement('addr-line',$this->filter_html_contents($value['auaff_address_line2']));
                        $city_node->setAttribute('content-type','city');
                        $aff_node->appendChild($city_node);
                    }
                    
                    if(!empty($value['cnt_country']))
                    {
                        $cnty_node = $doc->createElement('country',$this->filter_html_contents($value['cnt_country']));
                        $aff_node->appendChild($cnty_node);
                    }

                    $contribGroup_node->appendChild($aff_node);
                    
                    $i++;
                }
            }

            $articlemeta_node->appendChild($contribGroup_node);

            //AUTHOR NOTE
            if(!empty($authorNotearr))
            {
                $authoNote_node = $doc->createElement('author-notes');   
                foreach($authorNotearr as $key=>$value)
                {
                    $corresp_node = $doc->createElement('corresp');   
                    $corresp_node->setAttribute('id',$key);

                    $label_node = $doc->createElement('label');   
                    $sup_node = $doc->createElement('sup','*');
                    
                    $label_node->appendChild($sup_node);
                    $corresp_node->appendChild($label_node);

                    $labelText = $doc->createTextNode(" Corresponding author. E-mail: ");
                    $corresp_node->appendChild($labelText);
                    
                    $email_node = $doc->createElement('email',$value); 
                    $email_node->setAttribute('xlink:href',$value);
                    /*$email_node->setAttributeNS(
                        "http://www.w3.org/1999/xlink",
                        "xlink:href",
                        $value
                    );*/
                    $corresp_node->appendChild($email_node);

                    $authoNote_node->appendChild($corresp_node);
                }
                $articlemeta_node->appendChild($authoNote_node);
            }
        }
        return;
    }

    /**
     * this is private function and no additional article testings
     * HERE BUILD HISTORY TAGS
     */
    private function buildHistory($doc, $articlemeta_node,$artData)
    {
        if(!empty($artData))
        {
            $artId = $artData->art_id;
            $baseartData = $this->get_base_article_code($artId);

            /*
            //HISTORY TAG

            //$artDoi  --> need as arrgument

            $history_node = $doc->createElement('history');
            
            //14.0set ms_id nods
            $this->generate_article_history($doc, $history_node, $artId, $baseartData->revision_cnt, TRUE, $artDoi);
            
            $articlemeta_node->appendChild($history_node);
            */
            
            $history_node = $doc->createElement('history');

            $artReceived = array(
                'date' => array(
                    'attrib' => array(
                        'date-type' => 'received',
                    ),
                    'child_nodes'=> array(
                        '0' => array(
                            'node' => 'day',
                            'value' => $baseartData->day
                        ),
                        '1' => array(
                            'node' => 'month',
                            'value' => $baseartData->month
                        ),
                        '2' => array(
                            'node' => 'year',
                            'value' => $baseartData->year
                        ),
                    ),
                ),
            );
            $this->generate_node($doc, $articlemeta_node, $history_node, $artReceived,true);

            //ARTICLE REVISIONS
            if(!empty($artData->art_pre_all_ids))
            {
                $limitCnt = count(explode(',',$artData->art_pre_all_ids));
                $select = 'DATE_FORMAT(art_submission_date,\'%d\') as revised_day,DATE_FORMAT(art_submission_date,\'%m\') as revised_month,DATE_FORMAT(art_submission_date,\'%Y\') as revised_year';
                
                $cond = 'art_id IN ('.$artData->art_pre_all_ids.','.$artData->art_id.') AND art_artp_id ='.$artData->artp_id;
                
                $allRevisions = Articles::get_all_records($select,$cond,limit:$limitCnt,start:1);
                
                if(!empty($allRevisions))
                {
                    foreach($allRevisions as $key=>$value)
                    {
                        $artRevised = array(
                            'date' => array(
                                'attrib' => array(
                                    'date-type' => 'revised',
                                ),
                                'child_nodes'=> array(
                                    '0' => array(
                                        'node' => 'day',
                                        'value' => $value->revised_day
                                    ),
                                    '1' => array(
                                        'node' => 'month',
                                        'value' => $value->revised_month
                                    ),
                                    '2' => array(
                                        'node' => 'year',
                                        'value' => $value->revised_year
                                    ),
                                ),
                            ),
                        );
                        $this->generate_node($doc, $articlemeta_node, $history_node, $artRevised,true);
                       
                    }

                }

            }

            $artAccepted = array(
                'date' => array(
                    'attrib' => array(
                        'date-type' => 'accepted',
                    ),
                    'child_nodes'=> array(
                        '0' => array(
                            'node' => 'day',
                            'value' => date('d')//$artData->decision_day
                        ),
                        '1' => array(
                            'node' => 'month',
                            'value' => date('m') //$artData->decision_month
                        ),
                        '2' => array(
                            'node' => 'year',
                            'value' => date('Y') //$artData->decision_year
                        ),
                    ),
                ),
            );
            $this->generate_node($doc, $articlemeta_node, $history_node, $artAccepted,true);
        }
        return;
    }

/**
     * this is private function and no additional article testings
     * HERE BUILD PERMISSION TAGS
     * HERE ADD STATIC CONTENT
     */
    private function buildPermission($doc, $articlemeta_node)
    {
        $permission_node = $doc->createElement('permission');
        
        $crYear = date('Y');
        $yearRight = '© The Author(s) '.$crYear.'.';

        //COPYRIGHT STATEMENT
        $crStt_node = $doc->createElement('copyright-statement',$yearRight);
        $permission_node->appendChild($crStt_node);

        //COPYRIGHT YEAR
        $crYear_node = $doc->createElement('copyright-year',$crYear);
        $permission_node->appendChild($crYear_node);

        //LICENSE
        $license_node = $doc->createElement('license');
        $license_node->setAttribute('license-type','open-access');

        //ali:license_ref sub tag
        $licenseRefStr = 'https://creativecommons.org/licenses/by/4.0/';
        $aliNS = "http://www.niso.org/schemas/ali/1.0/";
        $licenseRef_node = $doc->createElementNS($aliNS,'ali:license_ref',$licenseRefStr);
        $license_node->appendChild($licenseRef_node);

        $licensePStr = 'This is an Open Access article distributed under the terms of the Creative Commons Attribution License (';
        $licenseP_node = $doc->createElement('license-p',$licensePStr);

        $extLink_node = $doc->createElement('ext-link',$licenseRefStr);
        $extLink_node->setAttribute('ext-link-type','url');
        $extLink_node->setAttribute('specific-use','url');
        $extLink_node->setAttribute("xlink:href",$licenseRefStr);

        $licenseP_node->appendChild($extLink_node);

        // Add remaining text after the <ext-link>
        $extLinkText = $doc->createTextNode("), which permits unrestricted reuse, distribution, and reproduction in any medium, provided the original work is properly cited.");
        $licenseP_node->appendChild($extLinkText);
        $license_node->appendChild($licenseP_node);

        //append license node to permission main node
        $permission_node->appendChild($license_node);

        //Append permission tag to article meta
        $articlemeta_node->appendChild($permission_node);

        return;
    }

/**
     * this is private function and no additional article testings
     * HERE BUILD ARTICLE KEYWORD TAGS
     */
    private function buildartKeywords($doc, $articlemeta_node,$artId)
    {
        if(!empty($artId))
        {
            $Article_keywords = new \App\Models\Article_keywords();
            
            $article_keywords = $Article_keywords::get_article_keywords($artId, FALSE);
            
            if(!empty($article_keywords))
            {
                $artKeywordGp_node = $doc->createElement('kwd-group');
                $artKeywordGp_node->setAttribute('kwd-group-type','keywords');
                foreach($article_keywords as $key => $value)
                {
                    $artKwd_node = $doc->createElement('kwd',$this->filter_html_contents($value->kwd_name));
                    $artKeywordGp_node->appendChild($artKwd_node);
                }  
                $articlemeta_node->appendChild($artKeywordGp_node);  
            }
        }
        return;
    }

    /**
     * this is private function and no additional article testings
     * HERE BUILD JOURNAL META TAGS
     */
    private function buildartJournalmeta($doc, $front_node,$artData)
    {
        if(!empty($artData))
        {
            $jnlMeta_node = $doc->createElement('journal-meta');

            $jnlId_node = $doc->createElement('journal-id',$artData->jnl_journal_code);
            $jnlId_node->setAttribute('journal-id-type','publisher-id');

            $jnlMeta_node->appendChild($jnlId_node);  

            $jnlTitleGp_node = $doc->createElement('journal-title-group');

            $jnlTitle_node = $doc->createElement('journal-title',$this->filter_html_contents($artData->jnl_journal_name));
            $jnlTitleGp_node->appendChild($jnlTitle_node);  
            $jnlMeta_node->appendChild($jnlTitleGp_node);  
            /*
            $jnl_metadata = array();
            if(!empty($artData->jnl_metadata_id))
            {
                $meta_id=$artData->jnl_metadata_id;
				$form_select = 'gdata_id, gdata_data, gdata_label as jm_meta_name,gdata_display_data as jm_meta_value, gdata_unique_identifier as unique_identifier, gdata_dynamic_status';
				$where ='gncf_id ='.$meta_id;
				$formatted_journal_code = '_' . $artData->jnl_journal_code;
				$Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
				$Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
				$details_tables = array(
					'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
					'join_table' => array(
					$Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
					$Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id'),
					)
				);
				$metadata_res = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', 'gdata_data_order,gdata_posted_date asc', NULL, '', NULL, NULL, TRUE);
                echo '<pre>';print_r($metadata_res);exit;
				// Re-structured array
				foreach ($metadata_res as $item) {
					$key = $item->unique_identifier;
					unset($item->unique_identifier); // Remove the unique_identifier from the object
					$jnl_metadata[$key] = $item;
				}
            }*/
            $Journals_tbl = (new \App\Models\Journals())->getTable();
            $select_meta = 'jnl_journal_name,gdata_label,gdata_data';
            $tables_meta = array(
                'main_table' => $Journals_tbl,
                'join_table' => array(
                    'rvw_article_gnf_form_data_'.$artData->jnl_journal_code => array('rvw_article_gnf_form_data_'.$artData->jnl_journal_code.'.gdata_atf_id', $Journals_tbl . '.jnl_metadata_id'),
                )
            );
            $meta_condition = "jnl_journal_code='" .$artData->jnl_journal_code. "'";
            $meta_form_data = Generic_forms::get_results_using_joins($tables_meta, $select_meta, $meta_condition, 'all');
            
            $ppub = $epub = '';
            if(count($meta_form_data) > 0){
                foreach ($meta_form_data as $meta_data) 
                {
                    if (strtolower($meta_data->gdata_label) == 'e-issn')
                        $epub = $meta_data->gdata_data;
                    elseif (strtolower($meta_data->gdata_label) == 'issn')
                        $ppub = $meta_data->gdata_data;
                }

                if(!empty($ppub) || !empty($epub))
                {
                    if(!empty($ppub))
                    {
                        $ppub_node = $doc->createElement('issn',$ppub);
                        $ppub_node->setAttribute('pub-type','ppub');
                        $jnlMeta_node->appendChild($ppub_node);  
                    }

                    if(!empty($epub))
                    {
                        $epub_node = $doc->createElement('issn',$epub);
                        $epub_node->setAttribute('pub-type','epub');
                        $jnlMeta_node->appendChild($epub_node);  
                    }
                    
                }
            }
            if(!empty($this->current_client->clnt_client_name))
            {
                $publisher_node = $doc->createElement('publisher');

                $publisherName_node = $doc->createElement('publisher-name',$this->filter_html_contents($this->current_client->clnt_client_name));

                $publisher_node->appendChild($publisherName_node); 
                $jnlMeta_node->appendChild($publisher_node); 
            }
            $front_node->appendChild($jnlMeta_node); 
        }
        return;
    }


   
}
