<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Faq;
use App\Models\Faq_rating;
use App\Models\Clients;
use App\Models\Roles;
use App\Models\All_Clients;
use Illuminate\Support\Facades\Storage;
use Config;
use DB;
use Log;
use Illuminate\Support\Str;
use writecrow\Lemmatizer\Lemmatizer;

class Manage_Faq_Api extends Controller
{
    /*
    * fetch single faq record for editing purpose
    */
   public function fetch_single_faq_data(Request $request) {  
        try{
        $post_data      =   $request->all();
        $select         =   array('faq_id','faq_question','faq_answer','faq_tags','faq_categories','faq_level','faq_client','faq_visible_status');            
        $return_arr     =   array('status'=>'failure','data'=>array());

        if (count($post_data) > 0)
        {
            $faq_id         =   $post_data['faq_id'];
            $criteria       =   array('faq_id'=>$faq_id);
            $faq_data       =   (new Faq())->get_single_record($select, $criteria);
            $return_arr     =   array('status'=>'success','data'=>$faq_data);
        }
        echo json_encode($return_arr);
        return $this->success("Success",200, $return_arr );
        }catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

/*
    * to check question is repeated
    */
    public function check_faq_question_exists($question,$faq_id=null) 
    {
       $tbl_name       =   (new \App\Models\Faq)->getTable();
       if($faq_id == null) {
           $sql  =  'SELECT count(faq_id) cnt FROM '.$tbl_name.' WHERE faq_question = "'.$question.'"';
        }
        else {
            // print_r('test2'); die;
            $sql  =  'SELECT count(faq_id) cnt FROM '.$tbl_name.' WHERE faq_question = "'.$question.'" and faq_id !='.$faq_id.'';
        }
        $cntArr = (new Faq())->get_records_by_raw_query($sql);
        if($cntArr[0]->cnt > 1) 
        {
            $cnt    =   $cntArr[0]->cnt;
        }
        else {
            $cnt    =   0;
        }
        return $cnt;
    }

    /*
    * save/update faq data
    */
    public function save_single_faq_data(Request $request) {
        DB::beginTransaction();
        try{
        $form_data      =   $request->all();
        $return_arr             =   array('status'=>'failure','msg'=>'Failed');
        $current_date           =   date('Y-m-d H:i:s');
        $current_user = $this->get_current_user_details(); 
        $user_id     =   $current_user['user_id'];
        $faq_categories     =   $form_data['faq_categories'];
        if(!empty($form_data['faq_tags']))
        {
            $faq_tags  =  $form_data['faq_tags'];
        }
        else
        {
            $faq_tags  = "";
        }
        if(!empty($form_data['faq_categories']))
        {
            $faq_categories = $form_data['faq_categories'];
        }
        else
        {
            $faq_categories  = "";
        }
        if(isset($form_data['faq_categories']) && !empty($form_data['faq_categories']) && is_array($form_data['faq_categories'])) 
        {
            $faq_categories =implode(',', $form_data['faq_categories']);
        } 
        if(isset($form_data['faq_tags']) && !empty($form_data['faq_tags'] && is_array($form_data['faq_tags']))) 
        {
            $faq_tags =implode(',', $form_data['faq_tags']);
        }
        
        $data_list = array(
            'faq_id' => trim($form_data['editid']),
            'faq_question' => trim($form_data['faq_question']),
            'faq_answer' => trim($form_data['faq_answer']),
            'faq_level' => trim($form_data['faq_level']),
            'faq_client' => trim($form_data['faq_client']),
            'faq_platform_type' => $form_data['faq_platform_type'],
            'faq_categories' => $faq_categories,
            'faq_tags' => $faq_tags,
            'faq_visible_status' => trim($form_data['faq_visible_status']),
            'faq_posted_by' => $user_id
        );
        if(!empty($data_list)) 
        {
            $faq_id         =   trim($form_data['editid']);
            $faq_question   =   trim($form_data['faq_question']);
            $faq_level      =   trim($form_data['faq_level']);
            if(isset($faq_id) && $faq_id != '')
            {
                
                $get_faq_question_cnt   =   $this->check_faq_question_exists($faq_question,$faq_id);                    
                if ($get_faq_question_cnt == 0)
                {
                    $condition = 'faq_id =' . $form_data['editid'];
                    (new Faq())->update_record($data_list, $condition, $current_user);
                    $status =   'success';
                } else {
                    $status =   'same_question_exists';
                }
            }
            else
            {
                
                $get_faq_question_cnt   =   $this->check_faq_question_exists($faq_question,$faq_id);                    
                if ($get_faq_question_cnt == 0)
                {
                    (new Faq())->insert_record($data_list);
                    $status =   'success';
                } else {
                    $status =   'same_question_exists';
                }
            }
                if(isset($faq_id) && $faq_id != '')
                {
                    $msg = "Update successfully";
                }
                else
                {
                    $msg = "Added successfully";
                }
                
                if($status ==   'same_question_exists') {
                    $msg = 'Same Faq question exists';
                }
            $return_arr['status']=$status;
            $return_arr['msg']=$msg;
        }
        DB::commit();
        return $this->success("Success",200, $return_arr );
        }catch (\Exception $e) {
   
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
    * #435 ajax show FAQ list page
    */
    public function show_faq_list_page(Request $request) 
    {            
         try{ 
        $form_data = $request->all(); 
        $Faq = (new \App\Models\Faq())->getTable();
        $Faq_rating = (new \App\Models\Faq_rating())->getTable();
        $client_details = $this->get_client_details();
        $select = "faq_id,faq_question,faq_answer,faq_tags,faq_categories,faq_visible_status,(fr_rating) as faq_rating";
        $category = (isset($form_data['category']))? $form_data['category'] :array();
        $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
        $client_id = $client_details->clnt_client_code;
        $criteria  =   '(faq_client ="" OR faq_client ="'.$client_id.'") AND faq_visible_status = "y" AND (faq_platform_type is null or faq_platform_type = "'.$this->current_client->platform_type.'")';
        $in_where  =   ''; 
        $key_name  = (isset($form_data['keyword']))? $form_data['keyword'] :"";
        $current_user = $this->get_current_user_details(); 
        $currentuser=$current_user['user_id'];
        $group_by = 'faq_id';
        if(count($category) > 0) 
        {
            $criteria      .=   'AND (';
            foreach($category as $key => $val) 
            {
                if($val != '')
                {
                    $in_where      .=   " faq_categories LIKE '%{$val}%' OR ";
                }
            }
            $criteria          .=   rtrim($in_where, ' OR ');
            $criteria          .=   ")";
        }
        //search keyword
        $sort_field = 'faq_id';
        $sort_order = 'desc';
        if ($key_name != "")
        {
            //$criteria .=   " AND faq_question LIKE '%{$key_name}%' OR  faq_answer LIKE '%{$key_name}%' OR  faq_tags LIKE '%{$key_name}%' OR  faq_categories LIKE '%{$key_name}%'";
            $str_len        =   strlen($key_name);
            $include_words_arr  =   Config::get('faq_config.include_words_arr');
            $user_roles  =   Roles::get_all_records('LOWER(role_name) as role_name',NULL,'role_name');
            $user_roles = $user_roles->map(function ($item) {
                return $item->role_name;
            })->toArray();
            $exact_res_qry      =   '';
            $include_res_qry    =   '';
            if ($key_name != '') {
                $temp           = 	explode(' ', $key_name);
                $wordsAry       =       $temp;
                $wordsCount     = 	count($wordsAry);
                //fetch each words in the keyword and finds its singular
                for($i=0;$i<$wordsCount;$i++) {
                    $sWord          =   Str::singular($wordsAry[$i]);
                    $wordsAry[$i]   =   $sWord;
                }
                //array keeps the words which are in the include_words_arr
                $matched_array      =   array_values(array_intersect($include_words_arr, $wordsAry));
                //array keeps the words which are in the roles_arr
                $roles_array        =   array_values(array_intersect($user_roles, $wordsAry)); 
                //array keeps the lemmatized words and roles (singular and plural) words
                $lemmatized_array   =   $this->lemmatize_each_matched_words($matched_array, $roles_array);
                
                $exact_res_qry      =   $this->fetch_combination($key_name, $lemmatized_array, $criteria,$currentuser);
                $select = $exact_res_qry['select'];
                $criteria .= $exact_res_qry['where'];
                $group_by = $exact_res_qry['groupby'];
                $sort_field = 'type';
                $sort_order = 'asc';
            } 
        }

        $tables = array(
            'main_table' => $Faq,
            'join_table' => $Faq_rating,
            'column_prefix1' => $Faq . '.faq_id',
            'column_prefix2' => $Faq_rating . '.fr_faq_id',
        );

        $return_array['pagination']  =   (new Faq())->get_results_join_pagination($tables,$select, $criteria, null, $sort_field, $sort_order, $limit,group_by:$group_by);
        
        foreach ($return_array['pagination'] as $value) {
            $value->faq_question =  $this->highlightWords($value->faq_question,$key_name);
            $value->faq_answer   =  $this->highlightWords($value->faq_answer,$key_name);
        } 
        return $this->success("Success",200, $return_array );
        }catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function show_faq_category(Request $request) 
    {            
         try{  
        $form_data = $request->all();
        $faq = 'faq_config.faq_core_roles';
        $return_array['all_categories']  =  Config::get($faq);
        return $this->success("Success",200, $return_array );
        }catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }

    public function rate_the_question(Request $request) 
    {
        try{
        $post_data = $request->all();
        $current_user = $this->get_current_user_details();
        $faq_id         =   $post_data['faq_id'];
        $rating         =   $post_data['rating'];
        $currentuser = $current_user['user_id'];  
        $rate_cnt       =   0;
        $where          =   "fr_posted_by = '$currentuser' and fr_faq_id = '$faq_id' and fr_client_code = '$this->client_code' ";
        $data           =   array('fr_faq_id'=>$faq_id, 'fr_rating' =>$rating, 'fr_posted_by'=>$currentuser, 'fr_client_code' => $this->client_code);
        
        //check if that user has already rated for that faq
        $ratings_qry    =   (new Faq_rating())->get_single_record('COUNT(fr_rating_id) cnt,fr_rating,fr_faq_id', $where);
        if(!empty($ratings_qry)) 
        {
            $rate_cnt   =   $ratings_qry->cnt;
        }
        //insert or update
        if($rate_cnt == 0)
        {
            (new Faq_rating())->insert_record($data);
            $status     =   'success';
        }
        else
        {
            (new Faq_rating())->update_record($data, array('fr_faq_id'=> $faq_id, 'fr_posted_by'=>$currentuser, 'fr_client_code' => $this->client_code));
            $status     =   'updated successfully';
        }
        $return_array['faqrating'] = $ratings_qry;
        return $this->success("Success",200, $return_array );
        }catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }  

    public function show_faq_list_sudo(Request $request) 
    {            
         try{ 
        $form_data = $request->all(); 
        $client_details = $this->get_client_details();
        $select = "faq_id,faq_question,faq_answer,faq_tags,faq_categories,faq_level,faq_client,faq_visible_status,acls_client_name,faq_platform_type,(select count(fr_rating_id) from rvw_faq_ratings where fr_faq_id = faq_id and fr_rating='y') as yes_cnt,(select count(fr_rating_id) from rvw_faq_ratings where fr_faq_id = faq_id and fr_rating='n') as no_cnt";
        $category = (isset($form_data['category']))? $form_data['category'] :array();
        $sort_field = $form_data['sort_field'] ?? 'faq_id';
		$sort_order = $form_data['sort_order'] ?? 'desc';
        $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
        $client_id = $client_details->clnt_id;
        $criteria  =   "";
        $in_where  =   ''; 
        $search_data  = (isset($form_data['search_data']))? $form_data['search_data'] :"";
        $search_text=(isset($search_data['key_text']))?$search_data['key_text']:"";
        $client=(isset($search_data['client']))?$search_data['client']:"";
        $search_category=(isset($search_data['category']))?$search_data['category']:"";
        $platform_type = isset($search_data['platform_type']) ? $search_data['platform_type'] :"";
        $current_user = $this->get_current_user_details(); 
        $currentuser=$current_user['user_id'];
        $tables = [
            'main_table' => (new Faq())->getTable(),
            'join_table' => (new All_Clients())->getTable(),
            'column_prefix1' => 'faq_client',
            'column_prefix2' => 'acls_client_code'
        ];
        
        //search keyword
        if ($search_data != "")
        {
            if($search_text != '')
            {
                $criteria .=   "(faq_question LIKE '%{$search_text}%' OR  faq_answer LIKE '%{$search_text}%' )";
            }
            if($client!= '')
            {
                $criteria .= ($criteria != '') ? ' AND ' : '';
                $criteria   .=   "faq_client = '{$client}'";
            }
            if ($platform_type != '') {
                $criteria .= ($criteria != '') ? ' AND ' : '';
                $criteria   .=  " faq_platform_type = '$platform_type'";
            }
            if($search_category != '')
            {
                $criteria .= ($criteria != '') ? ' AND ' : '';
                $criteria   .=   "(faq_categories LIKE '%{$search_category}%') ";
            }
        } 
        // attach files to faq_visibility checked radio value
		$faq_visibility = 'n';

		if(isset($form_data['faq_visible_status']) && $form_data['faq_visible_status']=='y') {
			$faq_visibility = 'y';
		}
        $faq = 'faq_config.faq_level';
        $all_clients =  (new All_Clients())->get_all_records('acls_client_code,acls_client_name');
        $return_array['set_faq_level']  =  Config::get($faq);
        $return_array['clients']    = $all_clients;
        $return_array['faq_tag']  =  $this->fetch_faq_tags($request);
        // $return_array['pagination']  =   (new Faq())->get_paginated_records($select,$criteria,$sort_field, $sort_order, $limit);
        $return_array['pagination']  =   (new Faq())->get_results_join_pagination($tables,$select,$criteria,'all',$sort_field,$sort_order,$limit);
        return $this->success("Success",200, $return_array );
        }catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function edit_faq_list_sudo(Request $request) 
    {            
        try{ 
        $form_data = $request->all(); 
        $client_details = $this->get_client_details();
        $select = "faq_id,faq_question,faq_answer,faq_tags,faq_categories,faq_level,faq_client,faq_visible_status,faq_platform_type";
        $faq = 'faq_config.faq_level';
        $faq_id=(isset($form_data['faqid']))? $form_data['faqid'] :"";
        $return_array['set_faq_level']  =  Config::get($faq);
        $faq_cat_config = 'faq_config.faq_core_roles';
        $return_array['all_categories']  =  Config::get($faq_cat_config);
        $all_clients =  (new All_Clients())->get_all_records('acls_id,acls_client_name');
        $return_array['clients']    =  $all_clients;
        $return_array['faq_tag']  =  $this->fetch_faq_tags($request);
        $condition =  'faq_id=' . $faq_id;
        // print_r($condition);  die;
        $return_array['data']  =   (new Faq())->get_single_record($select, $condition);
        return $this->success("Success",200, $return_array );
        }catch (\Exception $e) {
            
            return $this->failure('Failed', 500, $e);
        }
    }

     /*
    * delete a faq record
    */
    public function delete_faq_record(Request $request) {
        try{
        $status		=	"";	
        $form_data = $request->all();
        $current_user = $this->get_current_user_details(); 
        $faq_id=(isset($form_data['faq_id']))? $form_data['faq_id'] :"";
        if ($faq_id != "")
        {	
            $criteria1	=  "fr_faq_id = {$faq_id} ";
            
            $criteria2	=  'faq_id=' . $faq_id;
            $faq_status = (new Faq_rating())->delete_records($criteria1, '', $current_user);
            if ($faq_status == 0)
            {
              (new Faq())->delete_records($criteria2, '', $current_user);
                $status		=	"success";
            }
        }
        else {
                $status		=	"failed";
        }
        $data = array(
            'status' => $status,
            'message' => 'Deleted Successfully',
        );
        return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
    * fetch faq tags for add/edit form
    */
    public function fetch_faq_tags(Request $request) 
    {
        try{
        $post_data  =  $request->all();
        $results    =   array();
        $condition  =   array();
        $arr1       =   array();

        if (isset($post_data['data']['q']) && !empty($post_data['data']['q']))
        {
            $post_search = $post_data['data']['q'];
            if ($post_search != NULL) {
                $condition = array('LOWER(faq_tags) LIKE ' => '%' . $post_search . '%');
            }
            $records    =   (new Faq())->get_all_records('faq_tags',$condition);
        }
        else {
            $records            =  (new Faq())->get_all_records('faq_tags',$condition);
        }
        foreach ($records as $key)
        {
            if($key->faq_tags != '') {
                $tag    =   $key->faq_tags;
                if( strpos($tag, ',') !== false ) {
                    $expRes =   explode(",",$tag);
                    foreach ($expRes as $str)
                    {
                        if(trim($str) != '') {
                            $arr1[] =   trim($str);
                        }
                    }
                } else {
                    $arr1[]   =   trim($key->faq_tags);
                }
            }                
        }
        $arr2       =   array_values(array_unique($arr1));
        foreach ($arr2 as $key)
        {
            $results[]  =   array(
                            'id' => $key,
                            'text' => $key
                            );
        }
        sort($results);
        if (isset($post_data['data']['q']) && !empty($post_data['data']['q']))
        {
            echo json_encode(array(
                    'q' => $post_data['data']['q'],
                    "results" => $results)
            );
        } else {
            return $results;
        }
        return  $this->success('Success', 200, $results);
        } catch (\Exception $e) {
            
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
    * FAQ upload csv file for import action  CSVRepository $CSVRepository 
    */
   
    public function import_faq(Request $request)
    {

        try {
            $form_data = $request->all();
            $current_user = $this->get_current_user_details();
            $file =  $request->file('file');
            $filename=$file->getClientOriginalName();
            $full_path = 'faq'. DIRECTORY_SEPARATOR;
            $fileName = $filename;  
            $uploaded_file_details =  $request->file->move(public_path('storage/uploads/faq'), $fileName);
            $return_array = array();
            if (isset($uploaded_file_details) && $uploaded_file_details != "")
            {
            
            $fileupload_detail  =   array(
                'file_name' => $fileName,
            );
            $file_name = $fileupload_detail['file_name'];
            $separator          =   ';';
            $max_row_size       =   10240;
            $faq_array          =   array();
            $fls_file_path = rtrim($full_path . DIRECTORY_SEPARATOR. $file_name,'.csv').'.csv';//gets .fls file name 
            $full_file_path      =    $this->get_upload_path($fls_file_path,true);
           
            $file  =   fopen($full_file_path, 'r');
            $fields  =   fgetcsv($file, $max_row_size, $separator);
            // print_r($fields); die;
                $first_value        =   $fields;
                if ($first_value != "")
                {
                    $return_array['fileupload_detail']  =   $fileupload_detail;
                    $return_array['status']             =   'success';
                    $return_array['msg']  =  'csv file uploaded successfully';
                }
            }
            else
            {
                $file_name          =   $uploaded_file_details['name'];
                unlink($full_path . DIRECTORY_SEPARATOR . $file_name);
                $return_array['status'] = 'failed';
                $return_array['msg'] = 'Failed to upload';
            }
           return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {
            
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
    * fetch each rows of uploaded file
    */
    public function parse_faq_file($p_Filepath)
    {
        try{
        //    $fields;
           $separator              =   ';';
           $enclosure              =   '"';
           $max_row_size           =   10240;
           $faq_array              =   array();
           $file                   =   fopen($p_Filepath, 'r');
           $i                      =   0;
           $current_date           =   date('Y-m-d H:i:s');
           $faq_ids                =   array();

        //    $this->config->load('faq_config');

           // Open uploaded CSV file with read-only mode
           $csvFile = fopen($p_Filepath, 'r');
           // Get Fields and values
           $fields                 =   fgetcsv($csvFile, $max_row_size, $separator, $enclosure);
        //    print_r($csvFile);  die;

           // Store CSV data in an array
           $csvData                =   array();
           $faq_cat_config = 'faq_config.faq_categories';
           $faq_categories  =  Config::get($faq_cat_config);
           $transRow = true;
        //    print_r($fields);  die;
           while(($fields) !== false)
           {
               $records    =   fgetcsv($csvFile);
            // if (!$transRow) { 
               if(!empty($records)) 
               {
                //    print_r($question); die;
                   $category       =   array();
                   $status         =   strtolower($records[4]);
                   //    if($status != '' && $status == 'checked') 
                   //    {
                       $question   =   addslashes($this->faq_clean_str($records[0]));
                       $answer     =   addslashes($this->faq_clean_str($records[1]));
                       $keywords   =   addslashes($this->faq_clean_str($records[2]));
                       $roles      =   addslashes($records[3]);
                       $expl       =   explode(',', $roles);

                       if(count($expl) > 0) 
                       {
                           foreach ($expl as $key => $val) 
                           {
                               $role           =   strtolower(trim($val));
                               if($role != '' && $role != 'all') 
                               {
                                   $category[]     =   $faq_categories[$role];
                               }
                               else 
                               {
                                   $category[]     =   '';
                               }
                           }

                           if(count($category) > 0)
                           {
                               $cat_str    =   implode(",", $category); 
                           }
                           else
                           {
                               $cat_str    =   '';
                           }
                       }
                       else 
                       {
                           $cat_str    =   '';
                       }

                       $level      =   addslashes($records[5]);
                       $client     =   addslashes($records[6]);

                       $csvData[]  =   array(
                                               $question,
                                               $answer,
                                               $keywords,
                                               $cat_str,
                                               $level,
                                               $client
                                           );
                //    }                        
               }
           }
           fclose($file);
        //    return $csvData;
           return  $this->success('Success', 200, $csvData);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
    * remove special charachters (–,’,‘,“,”)
    */
    public function faq_clean_str($string) 
    {
        try{
       if (strpos($string, '–') !== false) {
           $string     =   str_replace('–', '-', $string); // Replaces all – with -.
       }
       if (strpos($string, '’') !== false) {
           $string     =   str_replace('’', "'", $string); // Replaces all ’ with '.
       }
       if (strpos($string, '‘') !== false) {
           $string     =   str_replace('‘', "'", $string); // Replaces all ‘ with '.
       }
       if (strpos($string, '“') !== false) {
           $string     =   str_replace('“', '"', $string); // Replaces all “ with ".
       }
       if (strpos($string, '”') !== false) {
           $string     =   str_replace('”', '"', $string); // Replaces all ” with ".
       }
       return  $this->success('Success', 200, $string);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    } 


    /*
    * save csv file records
    */
    public function save_imported_faq(Request $request) 
    {
        try{
       $form_data = $request->all();
       $file_name  = (isset($form_data['upload_file_name']))? $form_data['upload_file_name'] :"";
    $url  = (isset($form_data['upload_file_url']))? $form_data['upload_file_url'] :"";
    $app_data = helperData('APP_DOC_PATH');
    $path   =   $app_data . 'faq';
    $fpath  =   pathinfo($url);
    $data = helperData('FCPATH');
    $dir_name = $data. $path;
    $return_array    =   array();
    $current_date    =   date('Y-m-d H:i:s');
    $current_user = $this->get_current_user_details(); 
    $user_id     =   $current_user['user_id'];
    $full_path = 'faq'. DIRECTORY_SEPARATOR;
    $fls_file_path = rtrim($full_path . $file_name,'.csv').'.csv';//gets .fls file name 
    $full_file_path      =    $this->get_upload_path($fls_file_path,true);
    
    $result   =   $this->parse_faq_file($full_file_path);
       if (!empty($result))
       {
           $i  =   0;
           // fields for inserting faqs to table
           $keyword_field_array    =   array(
                                           'faq_question',
                                           'faq_answer',
                                           'faq_tags',
                                           'faq_categories',
                                           'faq_level',
                                           'faq_client',
                                           'faq_visible_status',
                                           'faq_posted_by',
                                           'faq_posted_date',
                                           'faq_proxy_id',
                                           'faq_operation'
                                       );
           $keyword_field_name     =   "`" . implode("`,`", $keyword_field_array) . "`";
           $tbl_name               =  (new \App\Models\Faq)->getTable();

           $faq_sql    =   "insert ignore into ".$tbl_name." ($keyword_field_name) values ";
           foreach ($result as $key => $val)
           {
               $question               =   $val[0];
               //to check question is repeated
               $get_faq_question_cnt   =   $this->check_faq_question_exists($question,'null');                    
               if ($get_faq_question_cnt == 0)
               {
                   $faq_value     =   "'" . implode("','", $val) . "', 'y', ".$user_id.", '".$current_date."', '0', 'i'"; 
                   $faq_sql      .=    "(" . $faq_value. "),";
                   $i++;
               }
           }
           if($i > 0) 
           {
               $faq_sql    =   rtrim($faq_sql, ',');
               (new Faq())->execute_query($faq_sql);
               if ((new Faq())->trans_complete() === FALSE) 
               {
                   $status =   'failed';
               }
               else 
               {
                   $status =   'success';
               }
           }
           else {
               $status =   'failed'; 
           }

           $return_array['status'] = $status;
       }
       else
       {
           $return_array['status'] =   'failed';
       }
       return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
    * search the keyword for exact matches
    * return a sql query
    */
    public function fetch_combination($key_name, $lemmatized_array, $maincondition,$user_id)
    {
        $key_wrd_cnt    =       count(preg_split('/\s+/', $key_name));
        $key_name       =       addslashes($key_name);
        $matchCount     =       count($lemmatized_array);

        $where          =       '';
        $ex_cnt_sql     =       '';                     //to store exact keyword fetch where query
        $rlvnt_wrd_qry  =       '';                     //to check if all relevant keywords are occured in a record
        $type_wrd_qry   =       '';                     //to check exact or contains
        $fulltext       =       '';
        $noun_cnt_sql   =       '';
        $ret_query    =       [];
        $rlvnt_wrd_qry  .=      ' SUM( ';
        $ex_cnt_sql     .=      '(';
        
        if ($matchCount > 0) {
            //this is to fetch the base forms
            //if the lemmatize library is not found, then normal search is done
            $exist_arr      =       $this->fetch_lemmatize_base_word($lemmatized_array);
            if (count($exist_arr) > 0) {
                if (preg_match('/[^a-zA-Z0-9 \d]/', $key_name)) {
                    $condition      =       "LIKE '%".$key_name."%'"; 
                } else {
                    $condition      =       "REGEXP '\\\b".$key_name."\\\b'";    
                }
                //if search keyword has more than 1 word
                if ($key_wrd_cnt > 1) {
                    //Find rows that contain the exact phrase (""keyword"" IN BOOLEAN MODE)
                    $ex_cnt_sql     .=      "MATCH( `faq_question`, `faq_answer`, `faq_tags` ) AGAINST( '\"".$key_name."\"' IN BOOLEAN MODE) + ";
                    $rlvnt_wrd_qry  .=      "IF((faq_question ".$condition." OR faq_answer ".$condition." OR faq_tags ".$condition."), 1,0) + ";
                    $type_wrd_qry   .=      "IF((faq_question ".$condition." OR faq_answer ".$condition." OR faq_tags ".$condition."), 'exact','includes') as type";
                    $where          =       '(faq_question '.$condition.' OR faq_answer '.$condition.' OR faq_tags '.$condition.') OR ';
                } else {
                    $type_wrd_qry   .=       "'includes' as type";
                }
                //to find the relavant occurances
                $i = 0;
                foreach ($lemmatized_array as $key => $value) {
                    $word           =   addslashes($value);
                    $fulltext       .=  $word;
                    $con            =   "REGEXP '\\\b".$word."\\\b'";
                    $rlvnt_wrd_qry  .=  "IF((faq_question ".$con." OR faq_answer ".$con." OR faq_tags ".$con."), 1,0)";
                    if ($i < $matchCount - 1) {
                        $fulltext           .=  ' ';
                        $rlvnt_wrd_qry      .=  ' + ';
                    }
                    $i++;
                }
                //to find the no. of occurances of a word
                $j = 0;
                if (count($exist_arr) > 0) {
                    $is_noun_exists  =   array();
                    foreach ($exist_arr as $k => $v) {
                        $word   =   addslashes($value);
                        $likcon =   "LIKE '%".$word."%'";
                        $noun_form          =       $this->fetch_noun_form($word); 
                        if ($noun_form != '') {
                            if (!in_array($noun_form,$is_noun_exists)) {
                                $is_noun_exists[] =   $noun_form;
                                $noun_cnt_sql   .=  'ROUND((LENGTH( CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`) ) - LENGTH(REPLACE(LOWER(CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`)),LOWER("'.$noun_form.'"),""))) / LENGTH(LOWER("'.$noun_form.'"))) + ';
                            }
                        }
                        $ex_cnt_sql .=      'ROUND((LENGTH( CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`) ) - LENGTH(REPLACE(LOWER(CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`)),LOWER("'.$word.'"),""))) / LENGTH(LOWER("'.$word.'")))';
                        if ($j < count($exist_arr) -1) {
                            $ex_cnt_sql     .=  ' + ';
                        }
                        $j++;
                    }
                }
                if ($noun_cnt_sql != '') {
                    $noun_cnt_sql   =   rtrim($noun_cnt_sql, ' + ');
                    $ex_cnt_sql     =   $ex_cnt_sql . ' - ('.$noun_cnt_sql.')' ;
                }
                $where  .=  'MATCH(`faq_question`, `faq_answer`, `faq_tags`) AGAINST("'.$fulltext.'")';
            } else {
                $condition      =       "LIKE '%".$key_name."%'";
                $ex_cnt_sql     .=      'ROUND((LENGTH( CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`) ) - LENGTH(REPLACE(LOWER(CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`)),LOWER("'.$key_name.'"),""))) / LENGTH(LOWER("'.$key_name.'")))';
                $rlvnt_wrd_qry  .=      "IF((faq_question ".$condition." OR faq_answer ".$condition." OR faq_tags ".$condition."), 1,0)";
                $type_wrd_qry   .=       "IF((faq_question ".$condition." OR faq_answer ".$condition." OR faq_tags ".$condition."), 'exact','includes') as type";
                $where          =       '(faq_question '.$condition.' OR faq_answer '.$condition.' OR faq_tags '.$condition.')';
            }
        } else {
            $condition      =       "LIKE '%".$key_name."%'";
            if($key_name != ',')
                $ex_cnt_sql     .=      'ROUND((LENGTH( CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`) ) - LENGTH(REPLACE(LOWER(CONCAT_WS(" ",`faq_question`,`faq_answer`,`faq_tags`)),LOWER("'.$key_name.'"),""))) / LENGTH(LOWER("'.$key_name.'")))';
            else
                $ex_cnt_sql     .=      'ROUND((LENGTH( CONCAT_WS(" ",`faq_question`,`faq_answer`) ) - LENGTH(REPLACE(LOWER(CONCAT_WS(" ",`faq_question`,`faq_answer`)),LOWER("'.$key_name.'"),""))) / LENGTH(LOWER("'.$key_name.'")))';
            $rlvnt_wrd_qry  .=       "0";
            
            if($key_name != ',')
                $type_wrd_qry   .=       "IF((faq_question ".$condition." OR faq_answer ".$condition." OR faq_tags ".$condition."), 'exact','includes') as type";
            else
                $type_wrd_qry   .=       "IF((faq_question ".$condition." OR faq_answer ".$condition."), 'exact','includes') as type";
            
            if($key_name != ',')
                $where          =       '(faq_question '.$condition.' OR faq_answer '.$condition.' OR faq_tags '.$condition.')';  
            else
                $where          =       '(faq_question '.$condition.' OR faq_answer '.$condition.')';
        }
        $rlvnt_wrd_qry  .=  ') as relavant';
        $ret_query['select'] = 'faq_id,faq_question,faq_answer,faq_tags,faq_categories,faq_level,faq_client,faq_visible_status,fr_rating_id,fr_faq_id,(fr_rating) as faq_rating,fr_posted_by,'.$ex_cnt_sql.') as cnt,'.$rlvnt_wrd_qry.','.$type_wrd_qry;
        $ret_query['where']   =   ' AND ('.$where.')';
        $ret_query['groupby'] =   '`faq_id` having (cnt >0 OR relavant >0)';
        return $ret_query;
    }

    public function fetch_lemmatize_base_word($lemmatized_array)
    {
        $lemmatized_arr         =   array();
        if(count($lemmatized_array) > 0) 
        {
            foreach($lemmatized_array as $key => $val) 
            {
                //if lemmatizer lib is not found , then return array will be null
                //if lemmatizer lib is found
                if(Lemmatizer::getLemma($val) != 'not_found')
                {
                    $lemmatized_arr[]         =   Lemmatizer::getLemma($val);
                }
            }
        }
        
        $result = array_values(array_unique($lemmatized_arr));
        return $result;
    }

    public function lemmatize_each_matched_words($matched_array, $roles_array) 
    {
        $lemmatized_str     =   '';
        $lemmatized_array   =   array();
        
        if(count($matched_array) > 0) 
        {
            foreach($matched_array as $key => $val) 
            {
                $v1_form = Lemmatizer::getLemma($val); //get v1 form of each word to get all forms
                $lemmatizer = Lemmatizer::getWordsFromLemma($v1_form);
                //if lemmatizer lib is found
                if($lemmatizer == $v1_form)
                {
                    $lemmatized_str     .=  $val;
                }
                else
                {
                    $lemmatized_str     .=  $v1_form.','.$lemmatizer.',';
                }
            }
            $lemmatized_str     =   rtrim($lemmatized_str, ',');
            if($lemmatized_str != '') 
            {
                $lemmatized_array   =   array_unique(explode(',', $lemmatized_str));
            }
        }
        //if user roles found in the search keyword, no need to find its lemmatized words
        if(count($roles_array) > 0) 
        {
            foreach($roles_array as $key => $val) 
            {                
                $plural_form = Str::plural($val);
                array_push($lemmatized_array, $val, $plural_form);
            }
            $lemmatized_array = array_unique($lemmatized_array);
        }
        return $lemmatized_array;
    }

    public function fetch_noun_form($word)
    {
        $noun_form  =   '';
        if($word == 'edit' || $word == 'assess' || $word == 'auth' || $word == 'moderate')
        {
            $noun_form  =   $word.'or';
        }
        else if($word == 'review' || $word == 'interview' || $word == 'market' || $word == 'report' || $word == 'use' || $word == 'test')
        {
            $noun_form  =   $word.'er';
        }
        return $noun_form;
    }

    public function highlightWords($subtext, $keyword)
    {
        //load helper "text" for string functions
            
        if($keyword != '') 
        {
            $key_wrd_cnt        =       count(preg_split('/\s+/', $keyword));
            $include_words_arr  =   Config::get('faq_config.include_words_arr');
            $user_roles  =   Roles::get_all_records('LOWER(role_name) as role_name',NULL,'role_name');
            $user_roles = $user_roles->map(function ($item) {
                return $item->role_name;
            })->toArray();
            $temp               = 	explode(' ', $keyword);
            $wordsAry           =       $temp;
            $wordsCount         = 	count($wordsAry);
            
            //fetch each words in the keyword and finds its singular
            for($i=0;$i<$wordsCount;$i++) 
            {
                $sWord          =   str::singular($wordsAry[$i]);
                $wordsAry[$i]   =   $sWord;
            }
                            
            //array keeps the words which are  in the include_words_arr
            $matched_array      =   array_values(array_intersect($include_words_arr, $wordsAry));                
            //array keeps the words which are in the roles_arr
            $roles_array        =   array_values(array_intersect($user_roles, $wordsAry));
            //array keeps the lemmatized words and roles (singular and plural) words
            $lemmatized_array   =   $this->lemmatize_each_matched_words($matched_array, $roles_array); 
            $matchCount         = 	count($lemmatized_array); 
            $exist_arr          =   $this->fetch_lemmatize_base_word($lemmatized_array);
            $existCount         = 	count($exist_arr); 

            if($existCount == 0) {
                if (preg_match('/#/', $keyword)) 
                {
                    $subtext =  preg_replace('/'. $keyword .'/i', '<b class="search_mark">\\0</b>', $subtext);
                }
                else
                {
                    $subtext =  preg_replace('#'. preg_quote($keyword) .'#i', '<b class="search_mark">\\0</b>', $subtext);
                }
            }
            else {
                if($key_wrd_cnt > 1) 
                {
                    $subtext = preg_replace("/\p{L}*?".preg_quote($keyword, '/')."\p{L}*/ui", "<b class='search_mark'>$0</b>", $subtext);
                }

                if($matchCount > 0) 
                {
                    foreach($lemmatized_array as $key => $word) {
                        $subtext =  preg_replace('/\b'. preg_quote($word, "/") .'\b/i', '<b class="search_mark">\\0</b>', $subtext);
                    }
                } 
                else 
                {
                    $subtext =  preg_replace('/'. preg_quote($keyword, "/") .'/i', '<b class="search_mark">\\0</b>', $subtext);
                }
            }
        }
        return $subtext;
    }
}
