<?php

namespace App\Http\Controllers;

use App\Models\Attachment_file_description;
use App\Models\File_upload_type;
use App\Models\Roles;
use Illuminate\Http\Request;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\UserDataTrait;
use Config;
use DB;
use Illuminate\Support\Facades\Validator;
use phpDocumentor\Reflection\PseudoTypes\False_;

Class Manage_FileDescription_Api extends Controller {
    use UtilityTrait;
	use UserDataTrait;
    public function getFiletype(Request $request) {
        try {
            $file_arry=[];
            $hook_arry=[];
            $roles_arry=[];
            $hookvalue = $this->Utility('role_used_in');
            $mdl_production =$this->current_client->modules->mdl_production;
            $return_array['production_flag'] = FALSE;
            $criteria='role_assigned_role NOT IN(\'system\',\'journal_admin\')';
            $designated_roles= Roles::get_all_records('role_id,role_name,role_assigned_role',$criteria);
            $upload_type = File_upload_type::get_all_records();
            if(!empty($upload_type)) {
                foreach($upload_type as $row) {
                    $file_arry[$this->encrypt_data($row->fut_id)]=$row->fut_name;
                }
            }
            if(!empty($designated_roles)) {
                foreach($designated_roles as $row) {
                    $roles_arry[$this->encrypt_data($row->role_id)]=$row->role_name;
                }
            }           
            if(isset($mdl_production) && $mdl_production == 'y') {
                $return_array['production_flag'] = TRUE;
            }
            $return_array['upload_typeall'] =$file_arry;
            $return_array['role_used_in'] =$hookvalue;                        
            $return_array['designated_roles'] =$roles_arry;
            return $this->success('success',200,$return_array);
        } catch(\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function getAllfiledescriptions(Request $request) {
		try {
			$post_data = $request->all();
            $sort_field = $post_data['sort_field'] ?? 'afdec_id';
            $sort_order =  $post_data['sort_order'] ?? 'asc';
            $limit = $post_data['per_page'] ?? 5;
            $return_array['production_flag'] = FALSE;
            $mdl_production =$this->current_client->modules->mdl_production;
            $where	=	'FIND_IN_SET(\'r\', `afdec_apply_stage_type`)';
            if(isset($mdl_production) && $mdl_production == 'y') {
                $where	=	'(FIND_IN_SET(\'r\', `afdec_apply_stage_type`) OR FIND_IN_SET(\'p\', `afdec_apply_stage_type`))';
                $return_array['production_flag'] = TRUE;
            }		
			$platform_data = Attachment_file_description::get_paginated_records('*', $where, $sort_field, $sort_order, $limit);
			$return_array['filedescription'] =$platform_data;
            return $this->success('success',200,$return_array);
		}
		catch(\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}
    public function save_description(Request $request) {
		DB::beginTransaction();
        try {
            $form_data= $request->all();
			$modeoperation='';
			$validator=Validator::make($request->all(),[
				'file_desc'=>customTrans('file_desc.pls-enter-filedesc')
			]);
			if($validator->fails()) {
			  return $this->failure('Failed',422,$validator->errors());
			}
			
			if($form_data['chk_prod_value']!='p' && $form_data['chk_review_value']!='r') {
				return  $this->warning(customTrans('file_desc.pls-select-stage'),200,'','warning');
			}
			$this->current_user = $this->get_current_user_details();
			
                $check_duplicate = array();
                $set_default = '';
                $desc_row = '';
                $insert_id = 0;
                $status = "";
                $file_type_descr = NULL;
				$file_exclude = 'n';
				if(isset($form_data['hd_exclude']) && $form_data['hd_exclude']=='y') {
					$file_exclude = 'y';
				}
				// uncheck review check box then change file exclude value 'n'
				if($form_data['chk_prod_value']=='p' && $form_data['chk_review_value']!='r') {
					$file_exclude = 'n';
				}
				// file types 
				if (!empty($form_data['file_types'])) {
					$decrypt_filetype_array=array();
					$file_types = $form_data['file_types'];
					$file_types_arr = explode(',',$file_types);
					foreach ($file_types_arr as $filetype) {
						$decrypt_filetype_array[] = $this->decrypt_data($filetype);
					}
					$file_type_descr = json_encode($decrypt_filetype_array);
				}

				// who can view 
				$role_list='';
				if (!empty($form_data['viewable_roles'])) {
					$viewble_roles=explode(",",$form_data['viewable_roles']);
					$decrypt_role_array=array();
					if($viewble_roles) {
						foreach ($viewble_roles as $roles) {
							$decrypt_role_array[] = $this->decrypt_data($roles);  //  to do decript $decrypt_role_array[] = decrypt_link($roles);
						}
					}
					$role_list=implode(',',$decrypt_role_array);
				}
				// review production checked value
				if($form_data['chk_prod_value']=='p' && $form_data['chk_review_value']=='r') {
					$arr = array($form_data['chk_review_value'],$form_data['chk_prod_value']);
					$afdec_apply_stage_type = implode(',',$arr);
				} else if($form_data['chk_prod_value']!='p' && $form_data['chk_review_value']=='r') {
					$afdec_apply_stage_type = $form_data['chk_review_value'];
				} else if($form_data['chk_prod_value']=='p' && $form_data['chk_review_value']!='r') {
					$afdec_apply_stage_type = $form_data['chk_prod_value'];
				} else {
					$afdec_apply_stage_type='r';
					if (isset($form_data['hdn_description_id']) && $form_data['hdn_description_id'] != '') {
						$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
						$where_condition='afdec_id ='.$desc_id;
       					$desc_rcrd = Attachment_file_description::get_single_record('afdec_apply_stage_type',$where_condition);
						$afdec_apply_stage_type	=	$desc_rcrd->afdec_apply_stage_type;
					}
				}
				// attach files to author checked radio value
				$author_attach = 'n';

				if(isset($form_data['hd_author']) && $form_data['hd_author']=='y') {
					$author_attach = 'y';
					$where_condition="afdec_attach_to_author ='".$author_attach."'";
					if (isset($form_data['hdn_description_id']) && $form_data['hdn_description_id'] != '') { 
						$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
						$where_condition .=  " AND afdec_id != " . $desc_id;
					}
					$check_exist = Attachment_file_description::get_single_record('afdec_description',$where_condition);
					if(!empty($check_exist)){
						return  $this->warning(customTrans('file_desc.already-selected').$check_exist->afdec_description,200,'','warning');
					}
				}
							
				// editor suite checked value
				$afdec_esintegration_desc = 'n';
				if(isset($form_data['chk_editor_value']) && $form_data['chk_editor_value']=='y') {
					$afdec_esintegration_desc = 'y';
				}

				$afdec_main_document = 'n';
				if(isset($form_data['es_integration']) && $form_data['es_integration'] == 'y') {
					$afdec_main_document = 'y';
					if(empty($form_data['file_types']))
					{
						return  $this->warning(customTrans('file_desc.mandatory_file_types'),200,'','warning');
					}
					else
					{
						$file_types = $form_data['file_types'];
						$file_type_arr = explode(',',$form_data['file_types']);
						$general_config= Config::get('general_config');
						$allowed_main_types = "'" . implode("','", $general_config['allowed_main_doc_types']) . "'"; 
						$fup_data = File_upload_type::get_single_record('GROUP_CONCAT(fut_id) AS main_type_ids', "fut_name IN(".$allowed_main_types.")");
						$main_doc_arr = explode(',',$fup_data->main_type_ids);
						$disallowed_types = false;
						foreach($file_type_arr as $single_file_types)
						{
							$decrypted_sing_types = $this->decrypt_data($single_file_types);
							if(!in_array($decrypted_sing_types,$main_doc_arr))
							{
								$disallowed_types = true;
								break;
							}
						}
						if($disallowed_types == true)
						{
							$warn_message = customTrans('file_desc.allowed_file_types');
							$warn_message = str_replace('##FILE_TYPE##',implode(',',$general_config['allowed_main_doc_types']),$warn_message);
							return  $this->warning($warn_message,200,'','warning');
						}
						if(isset($form_data['hdn_description_id']))
						{
						$req_file_desc = (new \App\Models\Required_file_type());
						$req_file_desc_tbl = (new \App\Models\Required_file_type())->getTable();
						$artp_tbl = (new \App\Models\Article_types())->getTable();
						$file_desc_tbl = (new \App\Models\Attachment_file_description)->getTable();
						$tables = array(
							'main_table' => $req_file_desc_tbl,
							'join_table' => array(
								$artp_tbl => array($req_file_desc_tbl . '.rft_artp_id', $artp_tbl . '.artp_id'),
							)
						);
						$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
						$select = 'GROUP_CONCAT(artp_id) as contained_types';
						$where = 'rft_file_desp_id ='.$desc_id.' AND artp_es_document_type=\'y\' ';
						$article_types_all = $req_file_desc::get_results_using_joins($tables, $select, $where);
						/*Task 426 Issue with validation message*/
						$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
						$where_condition='afdec_id ='.$desc_id;
       					$desc_rcrd = Attachment_file_description::get_single_record('afdec_main_document',$where_condition);
						if(!empty($article_types_all) && $article_types_all[0]->contained_types !== null && $desc_rcrd->afdec_main_document == 'n')
						{
							$artp_list = $article_types_all[0]->contained_types;
							$tables_desc = array(
								'main_table' => $req_file_desc_tbl,
								'join_table' => array(
									$artp_tbl => array($req_file_desc_tbl . '.rft_artp_id', $artp_tbl . '.artp_id'),
									$file_desc_tbl => array($req_file_desc_tbl.'.rft_file_desp_id',$file_desc_tbl.'.afdec_id')
								)
							);
							$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
							$select = 'artp_id as contained_types';
							$where = 'rft_file_desp_id !='.$desc_id.' AND artp_id IN('.$artp_list.') AND afdec_main_document=\'y\'';
							$check_already_present = $req_file_desc::get_results_using_joins($tables_desc, $select, $where);
							if($check_already_present->isNotEmpty())
							{
								$warn_message = customTrans('file_desc.other_main_doc_already_present');
								return  $this->warning($warn_message,200,'','warning');
							}
						}
					}
						
					}
					/*$where_condition_doc =  "afdec_main_document = 'y'";
					if (isset($form_data['hdn_description_id']) && $form_data['hdn_description_id'] != '') 
					{ 
						$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
						$where_condition_doc .=  " AND afdec_id != " . $desc_id;
					}
					$check_exist_doc = Attachment_file_description::get_single_record('afdec_description',$where_condition_doc);
					if(!empty($check_exist_doc))
					{
						return  $this->warning(trans('file_desc.doc-already-exist'),200,'','warning');
					}*/
				}

				if(isset($form_data['es_integration']) && $form_data['es_integration'] == 'n') 
				{
					if (isset($form_data['hdn_description_id']) && $form_data['hdn_description_id'] != '') 
					{
						$attachment_file_desc_tbl = (new \App\Models\Attachment_files())->getTable();	
						$article_tbl = (new \App\Models\Articles())->getTable();	
						$file_desc_tbl = (new \App\Models\Attachment_file_description())->getTable();
						$tables = array(
							'main_table' => $attachment_file_desc_tbl,
							'join_table' => array(
								$article_tbl => array($attachment_file_desc_tbl . '.atmnt_art_id', $article_tbl . '.art_id'),
								$file_desc_tbl => array($attachment_file_desc_tbl . '.atmnt_label', $file_desc_tbl . '.afdec_id'),
							)
						);
						$select = 'count(art_id) as cnt';
						$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
						$where = 'atmnt_label=' .$desc_id.' AND art_es_document_status != \'n\' AND afdec_main_document =\'y\' AND atmnt_doc_created_in_es =\'y\' ';
						$attch_desc_count = Attachment_file_description::get_results_using_joins($tables, $select, $where);
						if($attch_desc_count[0]->cnt > 0)
						{
							return  $this->warning(trans('file_desc.doc-article_present'),200,'','warning');
						}
					}
				}
								
				$data = array(
					'afdec_description' => trim($form_data['file_description']),
					'afdec_file_type_id' => $file_type_descr,
					'afdec_exclude_file' => $file_exclude,
					'afdec_attach_to_author' => $author_attach,
					'afdec_apply_stage_type'=>$afdec_apply_stage_type,
					'afdec_esintegration_desc'=> $afdec_esintegration_desc,
					'afdec_description_type' => $form_data['revision_desc'],
					'afdec_main_document' => $afdec_main_document
					);
				if($role_list != '')
					$data['afdec_viewable_roles'] = $role_list;
				else
					$data['afdec_viewable_roles'] = NULL;
				
				// update		
				if (isset($form_data['hdn_description_id']) && $form_data['hdn_description_id'] != '') { 
					$desc_id = $this->decrypt_data($form_data['hdn_description_id']);
					$where_condition="afdec_description ='".trim($form_data['file_description'])."' and afdec_id !='".$desc_id."' ";
					$check_duplicate = Attachment_file_description::get_single_record('afdec_description',$where_condition);					
					if (!empty($check_duplicate)) {
						return  $this->warning(customTrans('file_desc.filedesc-already-exist'),200,'','warning');										
					} else {
						$criteria = 'afdec_id="' . $desc_id . '"';						
						$result = Attachment_file_description::update_record($data,$criteria,$this->current_user);
						$insert_id = $desc_id;
						$status = 'update_success';
						$msg_arr['message']=customTrans('file_desc.update_desc_success');
						$msg_arr['mode']='update';	
					}									
				} else { // insert					
					$where_condition="afdec_description ='".trim($form_data['file_description'])."'";
					$check_duplicate = Attachment_file_description::get_single_record('afdec_description',$where_condition);
					if (!empty($check_duplicate)) {
						return  $this->warning(customTrans('file_desc.filedesc-already-exist'),200,'','warning');						
					} else {
						$insert_id = Attachment_file_description::insert_record($data,$this->current_user);
						$status = 'insert_success';
						$msg_arr['message']=customTrans('file_desc.insert_desc_success');
						$msg_arr['mode']='add';
						
					}					
				}
				
				//manage set default section
				if ($status == 'insert_success' || $status == 'update_success') {
					$set_def = 'n';
					if (isset($form_data['chk_default_value']) && $form_data['chk_default_value'] == 'y') {
						$set_def = 'y';
						$dvalue='s';
						$criteria = 'afdec_default!="' . $dvalue . '"';
						$data_default=array('afdec_default' => 'n');
						$result = Attachment_file_description::update_record($data_default,$criteria,$this->current_user);

					}					
					$data_default2=array('afdec_default' => $set_def);
					$criteria2 = 'afdec_id="' . $insert_id . '"';
					$result = Attachment_file_description::update_record($data_default2,$criteria2,$this->current_user);

					if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y'){
						$set_rvri = 'n';
						if (isset($form_data['chk_rvri_value']) && $form_data['chk_rvri_value'] == 'y') {
							$set_rvri = 'y';
							$criteria = 'afdec_submit_to_rvri="y"';
							$data_default=array('afdec_submit_to_rvri' => 'n');
							$result = Attachment_file_description::update_record($data_default,$criteria,$this->current_user);
						}
						$data_default3=array('afdec_submit_to_rvri' => $set_rvri);
						$criteria3 = 'afdec_id="' . $insert_id . '"';
						$result = Attachment_file_description::update_record($data_default3,$criteria3,$this->current_user);
					}
				}
					
				$user_desinated_roles = $this->UserConfigdata('production_designated_roles');
				$criteria4='role_assigned_role NOT IN(\'system\',\'journal_admin\')';
				$production_roles= Roles::get_all_records('role_id,role_name,role_assigned_role',$criteria4);				
				if ($insert_id > 0) {
					$criteria3 = 'afdec_id="' . $insert_id . '"';
					$result = Attachment_file_description::get_single_record('*',$criteria3);
					$result->all_file_upload = File_upload_type::get_all_records('fut_id,fut_name');
					$result->designated_roles=$production_roles;
					$production_module = FALSE;
					if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') {
						$production_module = TRUE;
					}
					$result->production_module = $production_module;
					$this->stage_types=$this->Utility('role_used_in');
					$result->stage_types = $this->stage_types;					
				}
				DB::commit();
	           return $this->success('success',200,$msg_arr);
        } catch(\Exception $e) {
			DB::rollback();  
			return  $this->failure('Failed',500,$e);
		}
    }

	public function get_filedescriptionbyid(Request $request) {
		try {
		$post_data = $request->all();		
		// $validator=Validator::make($request->all(),[
		// 	'afdec_id'=>'File description error',
		// ]);
		// if($validator->fails()) {
		//   return $this->failure('Failed',422,$validator->errors());
		// }
		$afdec_id=$this->decrypt_data($post_data['afdec_id']);
		if(!is_numeric($afdec_id)) {
            $msg_arr[]='Somthing went wrong';
            return  $this->warning($msg_arr,200,'','warning');
        }
		$criteria3 = 'afdec_id="' . $afdec_id . '"';
		$edit_record = Attachment_file_description::get_single_record('afdec_id,afdec_description,afdec_file_type_id,afdec_default,afdec_attach_to_author,afdec_exclude_file,afdec_viewable_roles,afdec_apply_stage_type,afdec_esintegration_desc,afdec_main_document,afdec_description_type,afdec_submit_to_rvri',$criteria3);
		$edit_record->afdec_file_type_id = json_decode($edit_record->afdec_file_type_id);
		$encrypt_filetype_array=array();
		if(!empty($edit_record->afdec_file_type_id) && sizeof($edit_record->afdec_file_type_id)>0) {
		foreach ($edit_record->afdec_file_type_id as $filetype) {
			$encrypt_filetype_array[] = $this->encrypt_data($filetype);
		}
		$edit_record->afdec_file_type_id = $encrypt_filetype_array;
		}

		$edit_record->all_file_upload = $all_file_upload = File_upload_type::get_all_records('fut_id,fut_name');
		foreach($all_file_upload as $each_file_upload) {
			$each_file_upload->en_fut_id = $this->encrypt_data($each_file_upload->fut_id);
		}

		$viewable_roles =array();
		$user_desinated_roles = $this->UserConfigdata('production_designated_roles');
		$criteria4='role_assigned_role NOT IN(\'system\',\'journal_admin\')';
		$production_roles= Roles::get_all_records('role_id,role_name,role_assigned_role',$criteria4);				
		foreach($production_roles as $roles) {
			 $roles->role_id=$this->encrypt_data($roles->role_id);
		}

		$viewable_roles=explode(',',$edit_record->afdec_viewable_roles);
		$roleslist=array();
		foreach($viewable_roles as $rolesid) {
			$roleslist[]= $this->encrypt_data($rolesid);
		}
		$edit_record->selected_role_id=$roleslist;
		$edit_record->all_roles=$production_roles;
		return $this->success("Success",200,$edit_record);
		
		} catch(\Exception $e) {
			DB::rollback();  
			return  $this->failure('Failed',500,$e);
		}
	}

public function delete_filedesc(Request $request) {
	DB::beginTransaction();
	try {
		$this->current_user = $this->get_current_user_details();
		$post_data=$request->all();		
		/*$validator=Validator::make($post_data,[
			'afdec_id'=>'File description error',
		]);
		if($validator->fails()) {
		  return $this->failure('Failed',422,$validator->errors());
		}*/
		
		
		$afdec_id=$this->decrypt_data($post_data['afdec_id']);
		if(!is_numeric($afdec_id)) {
            $msg_arr[]='Somthing went wrong';
            return  $this->warning($msg_arr,200,'','warning');
        }
		$attachment_filestable=new \App\Models\Attachment_files();
		$noof_filedesc=$attachment_filestable::get_all_records('atmnt_label',"atmnt_label='{$afdec_id}'");
		if(sizeof($noof_filedesc)>0){
			$msg_arr[]=customTrans('file_desc.filedesc-already-used');
            return  $this->warning($msg_arr,200,'','warning');
		}
		$criteria = "afdec_id='{$afdec_id}'";
		$result = Attachment_file_description::delete_records($criteria,"",$this->current_user);
		DB::commit();		
		$msg_arr[]=customTrans('file_desc.delete_desc_success');
		return $this->success($msg_arr,201,'');
	} catch(\Exception $e) {
		DB::rollback();  
		return  $this->failure('Failed',500,$e);
	}
}
   	 	

	 /*
    edit  description type
    commited date :- 26-05-2022
    Requested type :- GET
    */
	public function description_type(Request $request) {
		try{
		
			$post_data=$request->all();
			$casrai_module = $this->current_client->modules;
		
			if(isset($casrai_module->mdl_production) && $casrai_module->mdl_production == 'n') {
				$ar_cond = '`afdec_default` <> \'s\' AND FIND_IN_SET(\'r\', `afdec_apply_stage_type`)';
			} else {
				$ar_cond = 'afdec_default <> "s"';
			}
			$select_data = 'afdec_id,afdec_description,afdec_exclude_file';
			if(isset($casrai_module->mdl_research_integrity) && $casrai_module->mdl_research_integrity == 'y') 
			{
				$select_data .= ',afdec_submit_to_rvri';
			}
			$es_article_type = false;
			$main_doc_locked = false;
			$artp_id = $this->decrypt_data($post_data['item_id']);
			if(isset($casrai_module->mdl_es_integration) && $casrai_module->mdl_es_integration == 'y' && $artp_id !== null)
			{
				$advanced_table = new \App\Models\Article_types();
				$get_details = $advanced_table::get_single_record_with_bind_cond('artp_es_document_type',array('artp_id' => $artp_id));
				if(isset($get_details->artp_es_document_type) && $get_details->artp_es_document_type == 'y')
				{
					$select_data .= ',afdec_main_document';
					$es_article_type = true;
				}
			}
			$result = Attachment_file_description::get_all_records($select_data,$ar_cond);
			
	
			if(!empty($result)) {
				$result_arry['record']=$result;
				if($es_article_type == true)
				{
					foreach($result as $single_result)
					{
						if($single_result->afdec_main_document == 'y')
						{
							$attachment_file_desc_tbl = (new \App\Models\Attachment_files())->getTable();	
							$article_tbl = (new \App\Models\Articles())->getTable();	
							$file_desc_tbl = (new \App\Models\Attachment_file_description())->getTable();
							$tables = array(
								'main_table' => $attachment_file_desc_tbl,
								'join_table' => array(
									$article_tbl => array($attachment_file_desc_tbl . '.atmnt_art_id', $article_tbl . '.art_id'),
									$file_desc_tbl => array($attachment_file_desc_tbl . '.atmnt_label', $file_desc_tbl . '.afdec_id'),
								)
							);
							$select = 'count(art_id) as cnt';
							$desc_id = $single_result->afdec_id;
		 					$where = 'atmnt_label=' .$desc_id.' AND art_es_document_status != \'n\' AND afdec_main_document =\'y\' AND atmnt_doc_created_in_es =\'y\' AND art_artp_id ='.$artp_id;
							$attch_desc_count = Attachment_file_description::get_results_using_joins($tables, $select, $where);
							if($attch_desc_count[0]->cnt > 0)
							{
								$main_doc_locked = true;
							}
						}
					}
				}
				$result_arry['es_artp_type'] = $es_article_type;
				$permit_sort_in_author_submittion = FALSE;
				$result_arry['main_doc_locked'] = $main_doc_locked;
				if(isset($this->current_client->functionality->cfty_sort_order_for_author_submission_uploads) && $this->current_client->functionality->cfty_sort_order_for_author_submission_uploads == 'y') {
					$permit_sort_in_author_submittion = TRUE;
				}
				$result_arry['permit_sort_in_author_submittion'] = $permit_sort_in_author_submittion;				

				//CHecking any file description is marked for research integrity
				//If none of the file descriptions is marked, then show a warning msg
				if((isset($casrai_module->mdl_research_integrity) && $casrai_module->mdl_research_integrity == 'y'))
				{
					$is_rvri_marked 	=	false;
					foreach($result as $arr)
					{
						if($arr->afdec_submit_to_rvri == 'y')
						{
							$is_rvri_marked = true;
							break;
						}
					}
				} else {
					$is_rvri_marked 	=	true;
				}
				$result_arry['is_rvri_marked'] = $is_rvri_marked;
			}
			return $this->success('success',200,$result_arry);
        } catch(\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }

	}


















}
