<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\File_upload_type;
use App\Models\Article_types;
use App\Models\Article_type_advance_options;
use App\Models\Journals;
use App\Models\Journal_settings;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\Reader\Csv;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Ods;
use Illuminate\Support\Facades\Storage;

use function PHPUnit\Framework\directoryExists;

class Manage_File_Upload_type_Api extends Controller
{
     /*
    Get manage file upload list
    commited date :-  14-06-2022
    Request type :- POST
     */
  public function index(Request $request)
  {
      try{
        $form_data = $request->all();
        $current_user = $this->get_current_user_details();
        $sort_field = $form_data['sort_field'] ?? 'fut_id';
		  	$sort_order =  $form_data['sort_order'] ?? 'asc';
			  $limit = $form_data['per_page'] ?? 10;
        $select = 'fut_id,fut_name,fut_extension';
	    	$return_array = File_upload_type::get_paginated_records($select,$criteria =NULL, $sort_field, $sort_order, $limit);
        return $this->success('success',200,$return_array);
      }
      catch (\Exception $e){
        return  $this->failure('Failed', 500, $e);
    }
  }
   /*
    save manage file upload list
    commited date :-  14-06-2022
    Request type :- POST
     */
  public function save_file_upload_type(Request $request)
	{
    try{
      $post_data=$request->all();
      $current_user = $this->get_current_user_details();
      $validator = Validator::make($post_data, [
        'file_upload_name'     => 'required',
        'file_upload_extension'  => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message'=>$validator->errors(),
                'responsecode'=>422
            ]
        );
        }

        if ($post_data != FALSE)
        {
          $result['fut_name'] = $post_data['file_upload_name'];
          $result['fut_extension'] = rtrim($post_data['file_upload_extension']);
          $check_exist_cond = "fut_extension='". $result['fut_extension']."'";
          $check_exist_name = "fut_name='". $result['fut_name']."'";
          if (isset($post_data['hdn_file_up_id']) && $post_data['hdn_file_up_id'] != '')
          {
              $check_exist_id = $this->decrypt_data($post_data['hdn_file_up_id']);
              $check_exist_cond .= " AND fut_id != {$check_exist_id}";
              $check_exist_name .= " AND fut_id != {$check_exist_id}";
          }
          $file_extension = File_upload_type::get_single_record('count(*) as count', $check_exist_cond);
          $filetype_name =  File_upload_type::get_single_record('count(*) as count', $check_exist_name);
          if($file_extension->count > 0 && $filetype_name->count > 0)
						{
              return response()->json([
                'success' => false,
                'message' => customTrans('fileuploadtype.already-exist-filetype'),
              ]);
						}
            elseif($file_extension->count > 0 ){
            return response()->json([
              'success' => false,
              'message' => customTrans('fileuploadtype.invalid-exist'),
            ]);
            }
            elseif ($filetype_name->count > 0){
            return response()->json([
              'success' => false,
              'message' => customTrans('fileuploadtype.alrdy-exst-filetype-name'),
            ]);
            }
            $name = rtrim($post_data['file_upload_name']);
            if ((strrpos($name, ' ')!== false) ||(strlen($name) <= 1))
		        {
              return response()->json([
                'success' => false,
                'message' => customTrans('fileuploadtype.filetype-not-valid'),
              ]);
			      }
            $extsn_name = substr($name, 1, strlen($name));
            if (!preg_match('/^[A-Za-z0-9]+$/', $extsn_name))
                        {
                          return response()->json([
                            'success' => false,
                            'message' => customTrans('fileuploadtype.upload-file-type-name-not-valid'),
                          ]);
                        }
            $str = rtrim($post_data['file_upload_extension']);
            if (strpos($str, '.') !== 0)
            {
              return response()->json([
                'success' => false,
                'message' => customTrans('fileuploadtype.invalid-format'),
              ]);
            }
            if (strlen($str) <= 1)
            {
              return response()->json([
                'success' => false,
                'message' => customTrans('fileuploadtype.invalid-length'),
              ]);
            }
            $extsn_strng = substr($str, 1, strlen($str));
            if (!preg_match('/^[A-Za-z0-9]+$/', $extsn_strng))
            {
              return response()->json([
                'success' => false,
                'message' => customTrans('fileuploadtype.invalid-ext-strng'),
              ]);
            }
            if (isset($post_data['hdn_file_up_id']) && $post_data['hdn_file_up_id'] != '')
            {
              $file_up_id = $this->decrypt_data($post_data['hdn_file_up_id']);
              $condition = 'fut_id=' . $file_up_id;
              File_upload_type::update_record($result,$condition,$current_user);
              $result['fut_id'] = $file_up_id;
              $result['fileuploadstatus'] = 'update';
              $status = 'update_success';
              $msg = customTrans('fileuploadtype.update-upload-type');
            }
            else
            {
              $insert_id = File_upload_type::insert_record($result,$current_user);
              $status = 'insert_success';
              $msg = customTrans('fileuploadtype.insert-upload-type');
              $result['fut_id'] = $insert_id;
              $result['fileuploadstatus'] = 'insert';
            }
            return $this->success($msg,201,$result);
        }
    }
      catch (\Exception $e){
      return  $this->failure('Failed', 500, $e);
      }
	}

  /*
    GET  file upload type using editedid
    commited date :-  17-06-2022
    Request type :- POST
     */

  public function get_upload_type(Request $request)
	{
    try{
      $post_data=$request->all();
      if ($post_data == TRUE && $post_data['file_up_id'] != "")
      {
        $file_up_id = $post_data['file_up_id'];
        $condition='fut_id='.$this->decrypt_data($file_up_id);
        $file_up_data =File_upload_type::get_single_record('fut_name,fut_extension',$condition);
        return $this->success('success',200,$file_up_data);
      }
    }
    catch (\Exception $e){
      return  $this->failure('Failed', 500, $e);
      }
    }
    /* Check file upload type exits
    commited date :-  17-06-2022
    Request type :- POST
     */
    public function check_upload_type_exists(Request $request)
	  {
      try{
        $article_types_final=array();
        $uploadid=$request->all();
        $upload_id = $this->decrypt_data($uploadid['file_up_id']);
        if (isset($upload_id) && $upload_id != '')
	    	{
        $criteria = "fut_id= {$upload_id}";
		  	$result = File_upload_type::get_single_record('fut_extension',$criteria);
        $articletype_table=(new \App\Models\Article_types())->getTable();
        $articletypeadvanceoptions_table=(new \App\Models\Article_type_advance_options())->getTable();
        $journals_table=(new \App\Models\Journals())->getTable();
        $journal_settings_table=(new \App\Models\Journal_settings())->getTable();
        $tables = array(
          'main_table' =>  $articletype_table,
          'join_table' => array(
            $articletypeadvanceoptions_table => array($articletypeadvanceoptions_table . '.atotp_artp_id', $articletype_table . '.artp_id', "join"),
            $journals_table => array($articletype_table . '.artp_jnl_id',  $journals_table . '.jnl_id', "left")
          )
        );
			  $criteria = ' FIND_IN_SET("'.$result->fut_extension.'", REPLACE(REPLACE(REPLACE(atotp_file_type,\'"\',\'\'),"]",""),"[","")) ';
        $article_types = Article_types::get_results_using_joins($tables, 'artp_article_type,jnl_id,jnl_journal_name', $criteria,'all');
        $jnl_tables = array(
          'main_table' =>  $journals_table,
          'join_table' => array(
            $journal_settings_table => array($journal_settings_table . '.jset_jnl_id', $journals_table . '.jnl_id', "join")
          )
        );
        $jnl_criteria = ' FIND_IN_SET("'.$result->fut_extension.'", REPLACE(REPLACE(REPLACE(jset_file_type,\'"\',\'\'),"]",""),"[","")) ';
        $jnl_details = Journals::get_results_using_joins($jnl_tables, 'jnl_id,jnl_journal_name', $jnl_criteria,'all');
        if(!empty($jnl_details) && count($jnl_details)>0)
			  {
				foreach($jnl_details as $jn)
				{
					$article_types_final[$jn->jnl_id]['journal'] = $jn->jnl_journal_name;
					$article_types_final[$jn->jnl_id]['article_type'] = array();
				}
			  }
        if(!empty($article_types) && count($article_types)>0)
        {
          foreach($article_types as $art)
          {
            $article_types_final[$art->jnl_id]['journal'] = $art->jnl_journal_name;
            $article_types_final[$art->jnl_id]['article_type'][] = $art->artp_article_type;
          }
        }
        if(!empty($article_types_final)&& count($article_types_final)>0)
		  	{
        $article_types_final['confirmation'] = 'n';
        return $this->success('success',200,$article_types_final);
			  }
        $article_types_final['confirmation'] = 'y';
        return $this->success('success',200,$article_types_final);
        // print_r('hai');exit;
        }
        }
        catch (\Exception $e){
        return  $this->failure('Failed', 500, $e);
        }
	}
/*  Delete file upload type exits
    commited date :-  28-06-2022
    Request type :- POST
     */
  public function delete_upload_type(Request $request)
	{
    try
    {
      $uploadid=$request->all();
      $upload_id = $this->decrypt_data($uploadid['file_up_id']);
      if (isset($upload_id) && $upload_id != '')
		  { 
        $condition = "fut_id={$upload_id}";
        $current_user = $this->get_current_user_details();
        $file_upload_type = File_upload_type::get_single_record('fut_extension',$condition);
			  $result = File_upload_type::delete_records($condition,'',$current_user);  
        $articletype_table=(new \App\Models\Article_types())->getTable();
        $articletypeadvanceoptions_table=(new \App\Models\Article_type_advance_options())->getTable();
        $journals_table=(new \App\Models\Journals())->getTable();
        $journal_settings_table=(new \App\Models\Journal_settings())->getTable();
        if ($result > 0)
		  	{
           $tables = array(
                    'main_table' => $articletype_table,
                    'join_table' => array( $articletypeadvanceoptions_table => array($articletypeadvanceoptions_table . '.atotp_artp_id', $articletype_table . '.artp_id') )
                );
				  $criteria = ' FIND_IN_SET("'.$file_upload_type->fut_extension.'", REPLACE(REPLACE(REPLACE(atotp_file_type,\'"\',\'\'),"]",""),"[","")) ';
          $article_types = Article_types::get_results_using_joins($tables, '*',$criteria);
                $jnl_tables = array(
                  'main_table' => $journals_table,
                  'join_table' => array( $journal_settings_table => array($journal_settings_table . '.jset_jnl_id', $journals_table . '.jnl_id') )
              );
          $jnl_criteria = ' FIND_IN_SET("'.$file_upload_type->fut_extension.'", REPLACE(REPLACE(REPLACE(jset_file_type,\'"\',\'\'),"]",""),"[","")) ';
          $jnl_details = Journals::get_results_using_joins($jnl_tables, 'jset_id,jset_file_type', $jnl_criteria);
          $file_type_arr = array($file_upload_type->fut_extension);
          if(!empty($jnl_details))
				  {
					foreach($jnl_details as $jnl)
					{
						$jnl_diff = array_diff(json_decode($jnl->jset_file_type),$file_type_arr);
						sort($jnl_diff);
						$jnl_file_types = json_encode($jnl_diff);
            $Condition1="jset_id= {$jnl->jset_id}";
						Journal_settings::update_record(array('jset_file_type'=>$jnl_file_types),$Condition1,$current_user );
					}
          if(!empty($article_types))
				  {
					foreach($article_types as $art)
					{
						$art_diff = array_diff(json_decode($art->atotp_file_type),$file_type_arr);
						sort($art_diff);
						$art_file_types = json_encode($art_diff);
            $Condition2="atotp_id= {$art->atotp_id}";
						Article_type_advance_options::update_record(array('atotp_file_type'=>$art_file_types),$Condition2, $current_user);
					}
				  }
         /* Remove filetype from journal and article type settings */

          $no_record = '';
			  	if (count(File_upload_type::get_all_records()) == 0) //no record msg -- seperate JS
					$no_record = "y";
          $msg=customTrans('fileuploadtype.delete_upload_type');
          return $this->success($msg,200,$no_record);
				}
        }
        $msg=customTrans('fileuploadtype.delete_upload_type');
        return  $this->success('Success',200,$msg);
      }
    }
    catch (\Exception $e){
      return  $this->failure('Failed', 500, $e);
      }
		}

        public function extract_dates(Request $request)
        {
            try{
            $file = $request->file;
            $date_format = $request->dformat ?? null;
            $path = 'uploads/special_days';
            if(!directoryExists($path))
                mkdir($path);
            $filename = uniqid() . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->putFileAs($path, $file, $filename);
            $fileLocation = public_path('storage/'.$path. "/".$filename);
            $dates = $this->readDatesFromFile($fileLocation, $date_format);
            if(count($dates) == 0)
                return $this->success('Unable to extract dates from file. Please ensure dates are in recommended format');
            return $this->success('success', data : ['dates' => $dates]);
            }
            catch(Exception $e){
                return $this->success('Unable to extract dates from file. Please upload a proper and accessible file');
            }
        }

        public function readDatesFromFile($fileLocation, $date_format = null)
        {
            $extension = File::extension($fileLocation);
            $reader = match ($extension) {
                'csv' => new Csv(),
                'xlsx' => new Xlsx(),
                'ods' => new Ods(),
                default => null,
            };

            if ($reader === null) {
                throw new \InvalidArgumentException("Unsupported file format: $extension");
            }

            $spreadsheet = $reader->load($fileLocation);
            $worksheet = $spreadsheet->getActiveSheet();

            $highestRow = $worksheet->getHighestRow();
            $dates = [];

            for ($row = 1; $row <= $highestRow; $row++) {
                $dateString = $worksheet->getCell([1,$row])->getValue();
                if($dateString == ''){
                    continue;
                }
                try{
                    if(gettype($dateString) == 'double')
                        $date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($dateString);
                    else
                        if($date_format){
                            $date = Carbon::createFromFormat($date_format, $dateString);
                        }else{
                            $date = Carbon::parse($dateString);
                        }
                }
                catch(Exception $e){
                    continue;
                }
                $dates[] = $date->format('Y-m-d');
            }

            return $dates;
        }


}
