<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Attachment_file_description;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Ftp;
use Illuminate\Support\Facades\Storage;
use App\Models\Ftp_master;
use Config;
use DB;


class Manage_Ftp_Api extends Controller
{
    public function get_ftp_configurations(Request $request)
    {
        try {
            $rtn_data = array();
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnl_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' => $form_data['jnl_id'],
                'enc_data' => true,
                'type' => 'number'
            );
            $jnl_id_validate = $this->Rv_validator($input_arr);
            if ($jnl_id_validate == TRUE) {
                $jnl_id   =   $this->decrypt_data($form_data['jnl_id']);
                //Task #55(Taskbbot) Updated for issue final file upload.
                $select = 'ftp_id,ftpm_id,ftp_is_default,ftpm_display_name,ftpm_host_name,ftpm_user_name,ftpm_password,ftpm_port,ftpm_location,ftp_action_for,ftp_event_type,ftp_metadata_on_export,ftpm_enable_private_key,ftpm_private_key_path,ftp_import_stage_name,ftp_afdec_ids,ftp_ext_location';
                $criteria = "ftp_jnl_id = {$jnl_id} AND (ftp_jwf_id IS NULL OR ftp_jwf_id = 0)";
                if(isset($form_data['jwf_id']) && !empty($form_data['jwf_id'])){
                    $jwf_id = decrypt_link($form_data['jwf_id']);
                    $criteria = "ftp_jnl_id = {$jnl_id} AND ftp_jwf_id = {$jwf_id}";
                }
                $associated_ftpm_id = array();
                $rtn_data['associated_ftp'] = $this->get_ftp_data($select, $criteria);
                if(count($rtn_data['associated_ftp']) > 0){
                    $ftp_config_status = $this->Utility('ftp_config_status')['ftp_config_status'];
                    $ftp_event_status = $this->Utility('ftp_event_status')['ftp_event_status'];
                    $flag_status = $this->Utility('flag_status')['flag_status'];
                    foreach($rtn_data['associated_ftp'] as $ftp){
                        $associated_ftpm_id[] = $ftp->ftpm_id;
                        $ftp->file_descriptions = null;
                        if(!empty($ftp->ftp_afdec_ids)){
                            $ftp->file_descriptions = Attachment_file_description::get_single_record('GROUP_CONCAT(afdec_description SEPARATOR", ") as file_description', 'afdec_id IN ( '.$ftp->ftp_afdec_ids.' ) ')->file_description; 
                            // $ftp->ftp_afdec_id_arr = json_encode(explode(',',$ftp->ftp_afdec_ids));
                            $ftp->ftp_afdec_id_arr = array_map('intval', explode(',',$ftp->ftp_afdec_ids));
                        }
                        if (!empty($ftp->ftp_action_for))
                        {
                            $ftp->ftp_action_for_str = $ftp_config_status[$ftp->ftp_action_for];
                        }
                        if (!empty($ftp->ftp_metadata_on_export)){
                            $ftp->ftp_metadata_on_export_str = $flag_status[$ftp->ftp_metadata_on_export];
                        }
                        if (!empty($ftp->ftp_event_type)){
                            $ftp->ftp_event_type_str = $ftp_event_status[$ftp->ftp_event_type];
                        }
                        if(!empty($ftp->ftpm_private_key_path)){
                            $url = $ftp->ftpm_private_key_path;
                            $ftp->uploadedPPKfileName = basename($url);
                        }
                        $ftp->passwordvisibility=false;
                    }
                }
                //Task #55(Taskbbot) Updated for issue final file upload.
                $select = 'ftpm_id,ftpm_display_name,ftpm_host_name,ftpm_user_name,ftpm_password,ftpm_enable_private_key,ftpm_private_key_path,ftpm_port,ftpm_location';
                $rtn_data['available_ftp'] = Ftp_master::get_all_records($select);
                foreach($rtn_data['available_ftp'] as $ftp){
                    if(!empty($ftp->ftpm_private_key_path)){
                        $url = $ftp->ftpm_private_key_path;
                        $ftp->uploadedPPKfileName = basename($url);
                    }
                }
                return $this->success('success', 201, $rtn_data);
            } else {
                return $this->warning('Failed', 422, customTrans('auth.invalid_data'));
            }
        } catch (\Exception $e) {
           
            return $this->failure('Failure', 500, $e);
        }
    }
    public function check_ftp_exist($ftp_details,$condition = ''){
        $FtpTable = (new \App\Models\Ftp())->getTable();
        $FtpMasterTable = (new \App\Models\Ftp_master())->getTable();
        $select = 'ftpm_id';
        $tables = array(
            'main_table' => $FtpTable,
            'join_table' => array(
                $FtpMasterTable => array($FtpTable . '.ftp_ftpm_id', $FtpMasterTable . '.ftpm_id', "right")
            )
        );
        $criteria = "ftpm_display_name = '" . $ftp_details['display_name'] . "' AND ftpm_host_name = '" . $ftp_details['host_name'] . "' AND ftpm_user_name = '" . $ftp_details['user_name'] . "' AND ftpm_password = '" . $ftp_details['password'] . "' AND ftpm_port = '" . $ftp_details['port'] . "'";
        if($ftp_details['location'] == ''){
            $criteria .= " AND ftpm_location IS NULL";
        } else {
            $criteria .= " AND ftpm_location = '{$ftp_details['location']}'";
        }
        if($condition != NULL){
            $criteria .= $condition;
        }
        $ftpMasterExist = Ftp::get_results_using_joins($tables, $select, $criteria, 'single');
        return $ftpMasterExist;
    }
    public function save_ftp_configurations(Request $request)
    {
        try {
            $ftp_details = $request->all();
            $validationArr = array(
                'display_name'  => 'required',
                'host_name'     => 'required',
                'user_name'     => 'required',
                // 'password'      => 'required',
                'hdn_jnl_id'    => 'required',
            );
            $enable_advance_validation = FALSE;
            if(isset($ftp_details['hdn_jwf_id']) && !empty($ftp_details['hdn_jwf_id'])){
                $enable_advance_validation = TRUE;
            }
            if(isset($ftp_details['hdn_stage_for']) && !empty($ftp_details['hdn_stage_for']) && decrypt_link($ftp_details['hdn_stage_for']) == 'review'){
                $enable_advance_validation = FALSE;
            }
            if($enable_advance_validation == TRUE){
                if($this->current_client->functionality->cfty_import_stage_data_from_ftp_location == 'y'){
                    $validationArr['ftpFor'] = 'required';
                }
                if(isset($ftp_details['ftpFor']) && $ftp_details['ftpFor'] != 'i'){
                    $validationArr['event'] = 'required';
                    if((isset($ftp_details['metadataFile']) && $ftp_details['metadataFile'] != 'y') || ( !isset($ftp_details['metadataFile'] ))){
                        $validationArr['fileDescription'] = 'required';
                    }
                }
            }
            if(isset($ftp_details['privateKey']) && $ftp_details['privateKey'] == 'y'){
                $validationArr['uploadedPrivateKeyPath'] = 'required';
            } else {
                $validationArr['password'] = 'required';
            }
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            // die;
            $rtn_arr = array();
            $ftpm_id = '';
            $input_arr = array(
                'input' => $ftp_details['hdn_jnl_id'],
                'enc_data' => true,
                'type' => 'number'
            );
            $jnl_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $ftp_details['display_name'],
                'type'  => 'string'
            );
            $display_name_validate = $this->Rv_validator($input_arr);
            $input_arr['input'] = $ftp_details['host_name'];
            $host_name_validate = $this->Rv_validator($input_arr);
            $input_arr['input'] = $ftp_details['user_name'];
            $user_name_validate = $this->Rv_validator($input_arr);
            // $input_arr['input'] = $ftp_details['password'];
            // $password_validate = $this->Rv_validator($input_arr);

            if ($jnl_id_validate == TRUE && $display_name_validate == TRUE && $host_name_validate == TRUE && $user_name_validate == TRUE) {
                $jnl_id      = decrypt_link($ftp_details['hdn_jnl_id']);
                $ftp_details['port'] == '' ? $ftp_details['port'] = 21 : $ftp_details['port'];
                ($ftp_details['location'] == '' || $ftp_details['location'] == 'null') ? $ftp_details['location'] = NULL : $ftp_details['location'];
                $current_user = $this->get_current_user_details();

                // hotfix for the Task #55(Taskbbot) 
                $ftp_master_data = array(
                    'ftpm_display_name' => $ftp_details['display_name'],
                    'ftpm_host_name'    => $ftp_details['host_name'],
                    'ftpm_user_name'    => $ftp_details['user_name'],
                    // 'ftpm_password'     => $ftp_details['password'],
                    'ftpm_port'         => $ftp_details['port'],
                    'ftpm_enable_private_key'         => $ftp_details['privateKey'],
                    //Task #55(Taskbbot) Updated for issue final file upload.
                    // 'ftpm_ext_location' => ($ftp_details['ext_location'] == 'undefined') ? 'n' : $ftp_details['ext_location']
                );
                $ftp_master_data['ftpm_location'] = ($ftp_details['location'] == '') ? NULL : ($ftp_details['location']);
                if(isset($ftp_details['uploadedPrivateKeyPath']) && !empty($ftp_details['uploadedPrivateKeyPath']) && $ftp_details['privateKey'] == 'y'){
                    $ftp_master_data['ftpm_private_key_path']   = $ftp_details['uploadedPrivateKeyPath'];
                    if(!empty($ftp_details['password'])){
                        $ftp_master_data['ftpm_password']   = $ftp_details['password'];
                    }
                } else {
                    $ftp_master_data['ftpm_password']   = $ftp_details['password'];
                    if(!empty($ftp_details['uploadedPrivateKeyPath']) && $ftp_details['uploadedPrivateKeyPath'] != 'null'){
                        $ftp_master_data['ftpm_private_key_path']   = $ftp_details['uploadedPrivateKeyPath'];
                    }
                }
                $ftpMasterExist = Ftp_master::get_single_record_with_bind_cond('ftpm_id', $ftp_master_data);
                // print_r($ftpMasterExist);die;
                if (isset($ftpMasterExist->ftpm_id) && !empty($ftpMasterExist->ftpm_id)) {
                    $ftpm_id = $ftpMasterExist->ftpm_id;
                }
                if($ftpm_id == ''){
                    //check the uniqueness of the  display name
                    $displayNameExist = Ftp_master::get_single_record_with_bind_cond('ftpm_id', array('ftpm_display_name' => $ftp_master_data['ftpm_display_name']));
                    if(isset($displayNameExist->ftpm_id) && !empty($displayNameExist->ftpm_id)){
                        $rtn_arr = array(
                            'msg' => 'Display name already exists!',
                            'status' => 'warning'
                        );
                        return $this->success('warning', 200, $rtn_arr);
                    }
                    $ftpm_id = Ftp_master::insert_record($ftp_master_data, $current_user);
                }
                $ftp_data = array(
                    'ftp_jnl_id'        => $jnl_id,
                    'ftp_is_default'    => 'n',
                    'ftp_ftpm_id'       => $ftpm_id,
                    'ftp_ext_location' => ($ftp_details['ext_location'] == 'undefined') ? 'n' : $ftp_details['ext_location']
                );
                if(isset($ftp_details['hdn_jnl_id']) && !empty($ftp_details['hdn_jnl_id']))
                {
                    if(isset($ftp_details['hdn_jwf_id']) && !empty($ftp_details['hdn_jwf_id']) && $ftp_details['hdn_jwf_id'] != ''){
                        $ftp_data['ftp_is_default'] = 'y';
                        $jwf_id =decrypt_link($ftp_details['hdn_jwf_id']);
                        $ftp_data['ftp_jwf_id'] = $jwf_id;     
                    }
                }
                if($enable_advance_validation == TRUE){
                    $jwf_id = decrypt_link($ftp_details['hdn_jwf_id']);
                    $ftp_data['ftp_jwf_id'] = $jwf_id;
                    $ftp_data['ftp_is_default'] = 'y';
                    if(isset($ftp_details['ftpFor']) && !empty($ftp_details['ftpFor'])){
                        $ftp_data['ftp_action_for'] = $ftp_details['ftpFor'];
                    }
                    if(isset($ftp_details['event']) && !empty($ftp_details['event'])){
                        $ftp_data['ftp_event_type'] = $ftp_details['event'];
                    }
                    if(isset($ftp_details['fileDescription']) && !empty($ftp_details['fileDescription']) && $ftp_details['fileDescription'] != 'undefined'){
                        $jsonData = json_decode($ftp_details['fileDescription'], true);
                        if (!empty($jsonData) && is_array($jsonData)) {
                            $ftp_data['ftp_afdec_ids'] = ( implode(',',json_decode($ftp_details['fileDescription'])));
                        }else{
                            $ftp_data['ftp_afdec_ids'] = $ftp_details['fileDescription'];
                        }
                        // print_r($jsonData);die;
                    }
                    if(isset($ftp_details['metadataFile']) && !empty($ftp_details['metadataFile'])){
                        $ftp_data['ftp_metadata_on_export']   = $ftp_details['metadataFile'];
                    }
                    if(isset($ftp_details['importStageName']) && !empty($ftp_details['importStageName'])){
                        $ftp_data['ftp_import_stage_name']   = $ftp_details['importStageName'];
                    }
                }
                // print_r($ftp_master_data);die;
                if (!empty($ftp_details['hdn_ftp_id'])) {
                    //update
                    // $ftpm_condition = "ftpm_id=" . decrypt_link($ftp_details['hdn_ftpm_id']);
                    // $result = Ftp_master::update_record($ftp_master_data, $ftpm_condition);
                    $ftp_condition = "ftp_id=" . decrypt_link($ftp_details['hdn_ftp_id']);
                    Ftp::update_record($ftp_data, $ftp_condition);
                    $msg = customTrans('platform_settings.ftp_updated');
                    $rtn_arr = array(
                        'msg' => $msg,
                        'status' => 'success'
                    );
                } else {
                    $ftp_data['ftp_ftpm_id'] = $ftpm_id;
                    // print_r($ftp_data);die;
                    Ftp::insert_record($ftp_data, $current_user);
                    $msg = customTrans('platform_settings.ftp_added');
                    $rtn_arr = array(
                        'msg' => $msg,
                        'status' => 'success'
                    );
                }
                
                return $this->success('success', 201, $rtn_arr);
            } else {
                return $this->warning('Failed', 422, customTrans('auth.invalid_data'));
            }
        } catch (\Exception $e) {
            return $this->failure('Failure', 500, $e);
        }
    }
    public function delete_ftp_configurations(Request $request)
    {
        try {
            $form_data = $request->all();
            $ftp_id = decrypt_link($form_data['ftp_id']);
            $ftpm_id = decrypt_link($form_data['ftpm_id']);
            $current_user = $this->get_current_user_details();
            $ftp_condition = "ftp_id=" . $ftp_id;
            $ftpm_condition = "ftpm_id=" . $ftpm_id;
            $result = Ftp::delete_records($ftp_condition, '', $current_user);
            // Ftp_master::delete_records($ftpm_condition, '', $current_user);
            $message = customTrans('platform_settings.ftp_deleted');
            return $this->success($message, 201, $result);
            // $jnl_id = $this->jnl_data->jnl_id;
            // $rtn_data = $this->render_ftp_data($jnl_id,$jwf_id);
            // echo json_encode($rtn_data);
        } catch (\Exception $e) {
            
            return $this->failure('Failure', 500, $e);
        }
    }
    public function update_ftp_settings(Request $request)
    {
        try{
            $form_data=$request->all();
            $jnl_id = decrypt_link($form_data['jnl_id']);
            $type = $form_data['type'];
            $Ftp = new \App\Models\Ftp();
            $where = "ftp_jnl_id=$jnl_id and ftp_jwf_id is null";
            if(isset($form_data['jwf_id']) && !empty($form_data['jwf_id'])){
                $jwf_id = decrypt_link($form_data['jwf_id']);
                $where = "ftp_jnl_id=$jnl_id and ftp_jwf_id = {$jwf_id}";
            }
            $ftp_data = array(
                'ftp_is_default' => ($type == 'd' || $type == 'y') ? 'y' : 'n'
            );
            if(isset($form_data['jwf_id']) && $form_data['jwf_id'] != ''){
                $jwf_id = decrypt_link($form_data['jwf_id']);
                $where = "ftp_jnl_id=$jnl_id and ftp_jwf_id = $jwf_id";
            }
            
            $result = $Ftp::update_record($ftp_data, $where);
            return $this->success('success', 201, $result);
        }
        catch (\Exception $e) {
            return $this->failure('Failure', 500, $e);
        } 
    }
    public function link_selected_ftp(Request $request){
        try {
            $validator = Validator::make($request->all(), [
                'markedFtp' => 'required',
                'jnl_id'    => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $ftp_details = $request->all();
            $rtn_arr = array(
                'status' => false
            );
/*             $input_arr = array(
                'input' => $ftp_details['markedFtp'],
                'enc_data' => true,
                'type' => 'number'
            );
            $validate = $this->Rv_validator($input_arr); */
            $current_user = $this->get_current_user_details();
            $input_arr = array(
                'input' => $ftp_details['jnl_id'],
                'enc_data' => true,
                'type' => 'string'
            );
            $jnl_id_validate = $this->Rv_validator($input_arr);
            // print_r(decrypt_link($ftp_details['markedFtp']));die;
            if($jnl_id_validate == TRUE){
                $markedFtps = decrypt_link($ftp_details['markedFtp']);
                $jnl_id = decrypt_link($ftp_details['jnl_id']);
                $markedFtps_arr = explode(',', $markedFtps);
                $insert_batch = array();
    
                // print_r($markedFtps_arr);die;
                $i = 0;
                if(count($markedFtps_arr)>0){
                    foreach($markedFtps_arr as $id){
                        $insert_batch[$i] = array(
                            'ftp_jnl_id'        => $jnl_id,
                            'ftp_is_default'    => 'n',
                            'ftp_ftpm_id'       => $id
                        );
                        if(isset($ftp_details['jwf_id']) && !empty($ftp_details['jwf_id'])){
                            $jwf_id = decrypt_link($ftp_details['jwf_id']);
                            $insert_batch[$i]['ftp_jwf_id'] = $jwf_id;
                            $insert_batch[$i]['ftp_is_default'] = 'y';
                        }
                        $i++;
                    }
                    FTP::insert_batch($insert_batch, $current_user);
                    $rtn_arr = array(
                        'status' => true,
                        'msg'    => 'Ftp linked successfully'
                    );
                    return $this->success('success', 201, $rtn_arr);

                } 

            }else {
                return $this->warning('Failed', 422, customTrans('auth.invalid_data'));
            }
            // die;

        }catch (\Exception $e) {
            
            return $this->failure('Failure', 500, $e);
        }
    }
    // uploadPrivateKey
    public function upload_private_key(Request $request){
        try{
            $post_data = $request->all();
            $rtn_arr = array();
            $validator = Validator::make($request->all(), [
                'file' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $allowed_ext = array('ppk', 'pem');
            $attachment_file = $post_data['file'];
            $name = $attachment_file->getClientOriginalName();
            $extension = $attachment_file->getClientOriginalExtension();
            if(!in_array($extension,$allowed_ext)){
                $rtn_arr = array(
                    'status' => false,
                    'msg'    => 'Invalid File type'
                );
            } else {
                $file_path = Config::get('general_config.file_retrieval')['file_path'];
                $path = 'sftp_private_keys/';
                $fullpath = "uploads" . DIRECTORY_SEPARATOR . $path;
                
                $name = $this->rename_file(public_path() . $file_path . DIRECTORY_SEPARATOR . $path . DIRECTORY_SEPARATOR, $name,false);
                Storage::disk('public')->putFileAs($fullpath, $attachment_file, $name);
                Storage::size('public/' . $fullpath . DIRECTORY_SEPARATOR . $name);
                $rtn_arr = array(
                    'status' => true,
                    'uploadedPath' => Rv_encrypt($fullpath . $name),
                    'fileName' => $name
                );
            }
            return $this->success('success', 201, $rtn_arr);
            

        }catch (\Exception $e) {
            return $this->failure('Failure', 500, $e);
        }
    }
}
