<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Journals;
use App\Models\Generic_forms;
use App\Models\Generic_form_elements;
use App\Models\Generic_form_groups;
use App\Models\Generic_form_files;
use App\Models\Stage_email_templates;
use App\Models\Article_generic_form_data;
use App\Models\Article_generic_form_data_temp;
use App\Models\File_upload_type;
use App\Http\Traits\UserDataTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\Table_idValidatorTrait;
use App\Http\Traits\ViewarticleTrait;
use phpDocumentor\Reflection\DocBlock\Tags\Generic;
use App\Models\Roles;
use App\Models\Generic_flows;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\User_to_journals;
use App\Models\Article_publons;
use App\Models\Article_figshare;
use App\Http\Traits\UtilityTrait;
use App\Models\Advance_flow_movement;
use App\Models\Article_flag;
use App\Models\Flags;
use Exception;
use Illuminate\Support\Facades\Schema;



class Manage_Generic_Form_Api extends Controller
{
    use UserDataTrait;
    use UtilityTrait;
    use WorkflowTrait;
    use Table_idValidatorTrait;
    use ViewarticleTrait;
    public function get_stage_type(Request $request) {
        try {
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow = Config::get($workflow_config);
            $reviewflow = [];
            if (!empty($review_flow)) {
                if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n') {
                foreach ($review_flow as $key => $val) {
                    if (isset($key) && isset($val['label']) && isset($val['stage_for']) && $val['stage_for'] == 'review' ) {
                        $tmp_name = $val['label'];
                        $reviewflow[$key] = $tmp_name;
                    }
                }
                }else {
                    foreach ($review_flow as $key => $val) {
                        if (isset($key) && isset($val['label']) && isset($val['stage_for']) && ($val['stage_for'] == 'review' || $val['stage_for'] == 'manageproduction') ) {
                            $tmp_name = $val['label'];
                            $reviewflow[$key] = $tmp_name;
                        }
                    }
                }
            }
            return $this->success('success', 200, $reviewflow);
        } catch (\exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function get_journals(Request $request) {
        try {
            $data = [];
            $data['journals'] = Journals::get_all_records('jnl_id,jnl_journal_name');
            return $this->success('success', 200, $data);
        } catch (\exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*   get customform values based on search  for Super Admin Area  */

    public function get_all_generic_forms_records(Request $request) {
        try {
            $form_data = $request->all();
            $search_parameters = $form_data['paramsdet'] ?? array();
            $is_super_admin = FALSE;
            $criteria = '';
            $bind_arr = array();
            $this->current_user = $this->get_current_user_details();
            $client_code = $this->current_client->clnt_client_code;
            $workflow_config = 'clients.' . $client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);
            $reviewflow = [];
            $validsortorder=array('ASC','asc','desc','DESC');
            $validsortfield=array('gncf_form_title','gncf_form_name','gncf_form_description','jnl_journal_name');

            if (!empty($review_flow)) {
                if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n') {
                foreach ($review_flow as $key => $val) {
                    if (isset($key) && isset($val['label']) && isset($val['stage_for']) && $val['stage_for'] == 'review' ) {
                        $tmp_name = $val['label'];
                        $reviewflow[$key] = $tmp_name;
                    }
                }
                }else {
                    foreach ($review_flow as $key => $val) {
                        if (isset($key) && isset($val['label']) && isset($val['stage_for']) && ($val['stage_for'] == 'review' || $val['stage_for'] == 'manageproduction')) {
                            $tmp_name = $val['label'];
                            $reviewflow[$key] = $tmp_name;
                        }
                    }
                }
            }
            $enable_journal_data = FALSE;
            $avail_jnls ='';
            $jnl_name='';
            $jnl_id='';
            if (isset($this->current_client->functionality->cfty_allow_journal_wise_data_to_sa) && $this->current_client->functionality->cfty_allow_journal_wise_data_to_sa == 'y') {
                $enable_journal_data = TRUE;
                $avail_jnls = Journals::get_single_record('GROUP_CONCAT(DISTINCT jnl_id) as ids', "jnl_standalone = 'n'")->ids;
            }
            //additional checking to avoid conflict if the user has any managing roles and JA
            $select = 'managing_roles';
            $user_role = $this->UserConfigdata($select);
            $managing_roles = array_keys($user_role['managing_roles']);
            if(empty($form_data['journalstatus']) && !empty(array_intersect($managing_roles, $this->current_user['roles']))) {
                $criteria = '(gncf_jnl_id IS NULL OR  gncf_form_type=\'feedback_form\')'; //manage gen form by super admin
                $is_super_admin = TRUE;
                if($enable_journal_data == TRUE) {
                    $criteria = '(gncf_jnl_id IS NULL OR  gncf_form_type=\'feedback_form\' OR gncf_jnl_id IN (' . $avail_jnls . '))';
                    if(isset($search_parameters['jnl_name']) && !empty($search_parameters['jnl_name'])) {
                        $avail_jnls = $search_parameters['jnl_name'];
                        $jnlidarray = array('input'=>$search_parameters['jnl_name'],'type'=>'number');
                        $jnlidvalidation = $this->Rv_validator($jnlidarray);
                        if($jnlidvalidation != TRUE ){
                            $res['msg']=customTrans('viewarticle.invalid_data');
                            return  $this->warning('Warnings',200,$res,'warning');
                        }
                        $criteria = ' gncf_jnl_id = ? ';
                        $bind_arr[]=  $avail_jnls;
                    }
                }
            } else {
                $jnl_code=$form_data['jnl_code'];
                $jnlcodearray = array('input'=>$form_data['jnl_code']);
                $jnlcodevalidation = $this->Rv_validator($jnlcodearray);
                if($jnlcodevalidation != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }

                $jnlcodevalid = $this->validatecode(array('jnl_code'=>$form_data['jnl_code']),false);
                if($jnlcodevalid['jnl_code'] != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }

                $jnl_id = Journals::get_single_record_with_bind_cond('jnl_id',array("jnl_journal_code"=>$jnl_code))->jnl_id;
                $criteria = '(gncf_jnl_id IS NULL OR gncf_jnl_id = ' . $jnl_id . ') AND gncf_form_type <> \'\'';
            }

            if (!empty($search_parameters)) {
                if (isset($search_parameters['stage_type']) && $search_parameters['stage_type'] != '') {
                    $fieldarray = array('input'=>$search_parameters['stage_type']);
                    $fieldvalidation = $this->Rv_validator($fieldarray);
                    if($fieldvalidation != TRUE ) {
                        $res['msg']='Invalid Stage you have selected';
                        return  $this->warning('Warnings',200,$res,'warning');
                    }
                    $criteria = $criteria . ' AND LOWER(gncf_form_type) LIKE LOWER( ? )';
                    $bind_arr[]=  "%".$search_parameters['stage_type']."%";
                }
                if (isset($search_parameters['form_name']) && $search_parameters['form_name'] != NULL) {

                    $fieldarray = array('input'=>$search_parameters['form_name']);
                    $fieldvalidation = $this->Rv_validator($fieldarray);
                    if($fieldvalidation != TRUE ) {
                        $res['msg']='Invalid form name you have entered';
                        return  $this->warning('Warnings',200,$res,'warning');
                    }

                    $criteria = $criteria . ' AND LOWER(gncf_form_name) LIKE LOWER( ? )';
                    $bind_arr[]=  "%".$search_parameters['form_name']."%";
                }
                if (isset($search_parameters['form_title']) && $search_parameters['form_title'] != NULL) {
                    $fieldarray = array('input'=>$search_parameters['form_title']);
                    $fieldvalidation = $this->Rv_validator($fieldarray);
                    if($fieldvalidation != TRUE ) {
                        $res['msg']='Invalid form title you have entered';
                        return  $this->warning('Warnings',200,$res,'warning');
                    }
                    $criteria = $criteria . ' AND LOWER(gncf_form_title) LIKE LOWER( ? )';
                    $bind_arr[]=  "%".$search_parameters['form_title']."%";
                }
            }

            if (isset($form_data['meta_status']) && $form_data['meta_status'] != ''){
                $fieldarray = array('input'=>$form_data['meta_status']);
                $fieldvalidation = $this->Rv_validator($fieldarray);
                if($fieldvalidation != TRUE ) {
                    $res['msg']='Invalid data you have selected';
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            }

            if (isset($form_data['per_page']) && $form_data['per_page'] != ''){
                $fieldarray = array('input'=>$form_data['per_page'],'type'=>'number');
                $fieldvalidation = $this->Rv_validator($fieldarray);
                if($fieldvalidation != TRUE ) {
                    $res['msg']='Invalid data you have selected';
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            }

            if (isset($form_data['sort_order']) && $form_data['sort_order'] != ''){
                if (!in_array($form_data['sort_order'], $validsortorder)){
                    $res['msg']='Invalid data';
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            }

            if (isset($form_data['sort_field']) && $form_data['sort_field'] != ''){
                if (!in_array($form_data['sort_field'], $validsortfield)){
                    $res['msg']='Invalid data';
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            }

            if (isset($form_data['meta_status']) && $form_data['meta_status'] != ''){
                $criteria = $criteria . " AND gncf_metadata_status= ? ";
                $bind_arr[]=  $form_data['meta_status'];
            }

            $all_records = Generic_forms::get_single_record('count(gncf_id) as cnt', $criteria,NULL,'',NULL,$bind_arr);

            if(array_key_exists("journalstatus",$form_data) && empty($form_data['journalstatus'] && !empty(array_intersect($managing_roles, $this->current_user['roles'])))) {
			    $is_super_admin = TRUE;
			    $view = 'superadmin';
		    } else {
			    $view = 'admin';
		    }

            $current_uri = request()->segment(2);
            $sort_field = $form_data['sort_field'] ?? 'gncf_id';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
            $total_records = $all_records->cnt;
            $gen_form_records = array();
            $generic_table = (new \App\Models\Generic_forms())->getTable();
            $journal_table = (new \App\Models\Journals())->getTable();
            if ($total_records != 0) {
                $select = '*';

                $tables = array(
                    'main_table' => $generic_table,
                    'join_table' => $journal_table,
                    'column_prefix1' => $generic_table . '.gncf_jnl_id',
                    'column_prefix2' => $journal_table . '.jnl_id',
                );
                $limit =  $form_data['per_page'] ?? '10';
                if ($is_super_admin == TRUE) {
                    $gen_form_records =  Generic_forms::get_results_join_pagination_with_bind_cond($tables, $select, $criteria, null, $sort_field, $sort_order, $limit,$bind_arr);

                } else {
                    $select = 'gncf_metadata_status,gncf_id, gncf_jnl_id, gncf_form_type, gncf_form_name, gncf_form_title, gncf_form_layout,gncf_form_description,gncf_reviewer_view,jnl_standalone,jnl_journal_name,gncf_form_created';
                    $gen_form_records =  Generic_forms::get_results_join_pagination_with_bind_cond($tables, $select, $criteria, null, $sort_field, $sort_order, $limit,$bind_arr);
                }
                if(!empty($gen_form_records)) {
                foreach ($gen_form_records as $gen_form) {
                    $frm_name= $gen_form->gncf_form_name;
                    $tmpl_name = $frm_name;
				    if(empty($gen_form->jnl_journal_name) && $enable_journal_data == TRUE && $is_super_admin == TRUE)
					    $tmpl_name = $frm_name . ' (Master)';
    				    $gen_form->gncf_form_name = $tmpl_name;

                }
                }

            }
            $data['page_view'] = $view;
            $data['jnl_id'] = $jnl_id;
            $data['is_super_admin'] = $is_super_admin;
            $data['enable_journal_data'] = $enable_journal_data;
            $data['form_records'] = $gen_form_records;
            $data['stagelist'] = $reviewflow;
		    $data['all_jnls'] = Journals::get_all_records('jnl_id, jnl_journal_name', "jnl_standalone = 'n'");
            $data['total_records'] = $total_records;
            $data['current_client'] = $this->current_client;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
   get customform values (stage type and roles)  for Super Admin Area
    commited date :- 25-04-2022
    Requested type :- GET
    */
    public function get_generic_formdetails(Request $request)
    {
        try {
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow = Config::get($workflow_config);
            $reviewflow = [];
            if (!empty($review_flow)) {
                if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n') {
                    foreach ($review_flow as $key => $val) {
                        if (isset($key) && isset($val['label']) && isset($val['stage_for']) && $val['stage_for'] == 'review' ) {
                            $tmp_name = $val['label'];
                            $reviewflow[$key] = $tmp_name;
                        }
                    }
                } else {
                    foreach ($review_flow as $key => $val) {
                        if (isset($key) && isset($val['label']) && isset($val['stage_for']) && ($val['stage_for'] == 'review' || $val['stage_for'] == 'manageproduction') ) {
                            $tmp_name = $val['label'];
                            $reviewflow[$key] = $tmp_name;
                        }
                    }
                }

            }
            return $this->success('success', 200, $reviewflow);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
 get role based on stage type selected customform for Super Admin Area
    commited date :- 25-04-2022
    Requested type :-get
    */
    public function get_stagebased_role(Request $request)
    {
        try {
            $form_data = $request->all();
            $post_stage = $form_data['selected'];
            $validator = Validator::make($request->all(), [
                'selected'      => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $condition = 'role_assigned_role NOT IN (\'system\')';
            /*$author_stages = array('transit', 'authors_declaration', 'copyright'); //removed author_submission_stage
            if (in_array($post_stage, $author_stages)) {
                $condition = 'role_assigned_role NOT IN (\'system\',\'reviewer\')';
            } elseif (($post_stage != 'review' && $post_stage != 'revision' && ($post_stage != 'resubmission') && $post_stage != 'author_submission')) {
                $condition = 'role_assigned_role NOT IN (\'system\',\'reviewer\',\'author\')';
            }*/

            $roles = Roles::get_all_records('role_id,role_name,role_assigned_role', $condition, 'role_name');
            if (count($roles) > 0) {
                foreach ($roles as $val => $row) {
                    $row->role_id=$this->encrypt_data($row->role_id);
                }
                $return_arr['roles'] = $roles;
                $return_arr['status'] = 'success';
            }
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function  checkforname($formName)
    {
        try {
            $condition = array();
            if ($formName != NULL) {
                $condition = 'gncf_form_name="' . $formName . '"';
            }
            $forms_name = Generic_forms::get_single_record('count(*) cnt', $condition);
            if ($forms_name->cnt > 0) {
                $return_array['found'] = true;
            } else {

                $return_array['found'] = false;
            }
            return  $return_array;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
   checking customform name exist for Super Admin Area
    commited date :- 26-04-2022
    Requested type :-GET
    */
    //available journal abbreviation
    public function check_generic_form_name(Request $request)
    {
        try {
            $gecform_data = $request->all();
            $validator = Validator::make($request->all(), [
                'form_name'      => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }

            $formName = $gecform_data['form_name'];
            $return = $this->checkforname($formName, true);
            return $this->success('success', 200,$return);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
   save customform for Super Admin Area
    commited date :- 25-04-2022
    Requested type :-POST
    */
    public function save_generic_form(Request $request) {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'form_name'      => 'required',
                'title'      => 'required',
                'layout'      => 'required',
            ]);

            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $bind_arr = array();
            $view_role = array();
            $stage_type = '';
            $jnl_code=$form_data['hdn_gncf_jnl_code'];
            $checkstage=$form_data['checkstage'];
            $oldstage_type=$form_data['oldstage_type'];

            $formnamearray = array('input'=>$form_data['form_name'],'type'=>'string');
            $titlearray = array('input'=>$form_data['title'],'type'=>'string');
            $layoutarray = array('input'=>$form_data['layout'],'type'=>'string');

            $formnamevalidation= $this->Rv_validator($formnamearray);
			$titlevalidation= $this->Rv_validator($titlearray);
			$layoutvalidation= $this->Rv_validator($layoutarray);

            if($formnamevalidation != TRUE || $titlevalidation != TRUE || $layoutvalidation != TRUE ){
                return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
			}

            if (isset($form_data['description'])) {
                $descriptionarray = array('input'=>$form_data['description']);
                $descriptionvalidation= $this->Rv_validator($descriptionarray);
                if($descriptionvalidation != TRUE ){
                    return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
                }
            }


            if (isset($form_data['viewable_role'])) {
                $view_role = explode(',', $form_data['viewable_role']);
                $view_roleflag=TRUE;
                for($i=0;$i<count($view_role);$i++) {
                    $fieldarray = array('input'=>$view_role[$i],'type'=>'number', 'enc_data'=>TRUE);
                    $fieldvalidation = $this->Rv_validator($fieldarray);
                    if($fieldvalidation != TRUE ){
                        $view_roleflag=FALSE;
                    }
                }

                if($view_roleflag != TRUE ){
                    return  $this->warning('Warnings',200,'Invalid viewable role you have selected','warning');
			    }

                $decrypt_role_array=array();
                foreach ($view_role as $roleid) {
                    $decrypt_role_array[] = $this->decrypt_data($roleid);
                }
                $view_role = $decrypt_role_array;

            }

            if (isset($form_data['hdn_gncf_jnl_code']) && $form_data['hdn_gncf_jnl_code'] != ''){
                $fieldarray = array('input'=>$form_data['hdn_gncf_jnl_code'],'type'=>'number');
                $fieldvalidation = $this->Rv_validator($fieldarray);
                if($fieldvalidation != TRUE ){
                    return  $this->warning('Warnings',200,'Invalid journal code you have given','warning');
                }
            }


            if (isset($form_data['metadata_status']) && $form_data['metadata_status'] != ''){
                $fieldarray = array('input'=>$form_data['metadata_status']);
                $fieldvalidation = $this->Rv_validator($fieldarray);
                if($fieldvalidation != TRUE ){
                    return  $this->warning('Warnings',200,'Invalid form type you have selected','warning');
                }
            }

            if (isset($form_data['edit_gecform_id']) && $form_data['edit_gecform_id'] != ''){
                $fieldarray = array('input'=>$form_data['edit_gecform_id'],'type'=>'number', 'enc_data'=>TRUE);
                $fieldvalidation = $this->Rv_validator($fieldarray);
                if($fieldvalidation != TRUE ){
                    return  $this->warning('Warnings',200,'Invalid data you have selected','warning');
                }
            }


            if($form_data['metadata_status']=='c'){
                if ($form_data['stage_type'] == '') {
                    return  $this->warning('Warnings',200,customTrans('customform.select_stage_type'),'warning');
                }
                $stage_type = $form_data['stage_type'];
                if (isset($form_data['stage_type']) && $form_data['stage_type'] != ''){
                    $fieldarray = array('input'=>$form_data['stage_type']);
                    $fieldvalidation = $this->Rv_validator($fieldarray);
                    if($fieldvalidation != TRUE ){
                        return  $this->warning('Warnings',200,'Invalid stage type you have selected','warning');
                    }
                }
            }
            else if($form_data['metadata_status']=='m')
            {
                $stage_type = 'metadata';
            }else if($form_data['metadata_status']=='s')
            {
                $stage_type = 'supporting data forms';
            }

            $generic_form_data_details = array(
                'gncf_form_type' => $stage_type,
                'gncf_form_name' => trim($form_data['form_name']),
                'gncf_form_title' => trim($form_data['title']),
                'gncf_form_layout' =>  $form_data['layout'],
                'gncf_form_description' => trim($form_data['description']),
                'gncf_user_roles' => json_encode($view_role)
            );
            if($form_data['metadata_status']=='m' || $form_data['metadata_status']=='s'){
                $generic_form_data_details['gncf_metadata_status']=$form_data['metadata_status'];
                $generic_form_data_details['gncf_form_created'] = 'j';
            }

            //check code duplicate
            $gnc_form_id = NULL;
            if ($form_data['edit_gecform_id'] != '') {
                $gnc_form_id = $this->decrypt_data($form_data['edit_gecform_id']);
                if($form_data['metadata_status']=='c' && isset($gnc_form_id) && $gnc_form_id != NULL){
                $all_generic_forms = Generic_flows::get_single_record('COUNT(jwf_id) AS count','jwf_forms LIKE \'%'.$gnc_form_id.'%\'');
                if ($all_generic_forms->count > 0 && $oldstage_type!=$stage_type) {
                    return  $this->warning('Warnings',200,'The form is currently linked to a workflow. To change the stage type, you will need to unlink them first.','warning');
                }

                }
            }
            //check form exist
            if (isset($gnc_form_id) && $gnc_form_id != NULL) {
                $criteria = "gncf_form_name= ? AND gncf_id != ? ";
                $bind_arr[]=$form_data['form_name'];
                $bind_arr[]=$gnc_form_id;
            } else {
                $criteria = 'gncf_form_name= ? ';
                $bind_arr[]=$form_data['form_name'];
            }
            $forms_name = Generic_forms::get_single_record('count(*) cnt', $criteria,NULL,'',NULL,$bind_arr);

            //checking form submission
            $check_gnc_name = 'true';
            if ($forms_name->cnt > 0) { //form name exist
                $check_gnc_name = 'false';
                if(isset($form_data['metadata_status']) && $form_data['metadata_status']=='m')
                {
                    return  $this->warning('Warnings',200,customTrans('customform.duplicate-meta-name'),'warning');
                } else if(isset($form_data['metadata_status']) && $form_data['metadata_status']=='s') {
                    return  $this->warning('Warnings',200,customTrans('customform.duplicate-supporting-name'),'warning');
                } else {
                    return  $this->warning('Warnings',200,customTrans('customform.duplicate-gncform-name'),'warning');
                }
                
            } else if (($form_data['form_name']) && isset($form_data['title']) && isset($form_data['layout'])  && $check_gnc_name === 'true') {

                if ($gnc_form_id != '') {  //edit
                    $bind_arr=array();
                    $criteria = 'gncf_id = ?';
                    $bind_arr[]=$gnc_form_id;

                    $result = Generic_forms::update_record($generic_form_data_details, $criteria, $this->current_user,'',NULL,$bind_arr);
                    if ($result) {
                        if(isset($form_data['metadata_status']) && $form_data['metadata_status']=='m')
                        {
                            return $this->success('success', 200,array('mode'=> 'update','message' => customTrans('customform.meta-update-msg')));
                        } else if(isset($form_data['metadata_status']) && $form_data['metadata_status']=='s') {
                            return $this->success('success', 200,array('mode'=> 'update','message' => customTrans('customform.supporting-update-msg')));
                        } else {
                            return $this->success('success', 200,array('mode'=> 'update','message' => customTrans('customform.gncform-update-msg')));
                        }
                    }
                } else {
                    //insert record
                    if($jnl_code != NULL) {
                        $jnl_id = Journals::get_single_record_with_bind_cond('jnl_id',array("jnl_journal_code"=>$jnl_code))->jnl_id;
					    $generic_form_data_details['gncf_jnl_id'] = $jnl_id;
					    $generic_form_data_details['gncf_form_created'] = 'j';
				    }

                    $gnc_form_id = Generic_forms::insert_record($generic_form_data_details, $this->current_user);
                    $gnc_id = $this->encrypt_data($gnc_form_id);
                    if (!empty($gnc_form_id)) {
                        if(isset($form_data['metadata_status']) && $form_data['metadata_status']=='m')
                        {
                            return $this->success('success', 200,array('mode'=> 'add','form_id'=>$gnc_id,'message' => customTrans('customform.meta-added-msg')));
                        }else if(isset($form_data['metadata_status']) && $form_data['metadata_status']=='s') {
                            return $this->success('success', 200,array('mode'=> 'add','form_id'=>$gnc_id,'message' => customTrans('customform.supporting-added-msg')));
                        } else {
                            return $this->success('success', 200,array('mode'=> 'add','form_id'=>$gnc_id,'message' => customTrans('customform.gncform-added-msg')));
                        }
                    }
                }
            } else {
                return  $this->warning('Warnings',200,customTrans('customform.form-submission-err'),'warning');
            }
        } catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }
    /*
   get customform details  for Super Admin Area
    commited date :- 25-04-2022
    Requested type :-GET
    */
    public function get_custom_form_byid(Request $request) {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'gncf_id'      => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $checkstage=true;
            $gid = $this->decrypt_data($form_data['gncf_id']);
             if ($gid != '') {
                $condition = "gncf_id=" . $gid;
                $edit_record = Generic_forms::get_single_record('gncf_jnl_id,gncf_metadata_status,gncf_form_type,gncf_form_name,gncf_form_title,gncf_form_layout,gncf_form_description,gncf_user_roles', $condition);



                $edit_record->gncf_user_roles = json_decode($edit_record->gncf_user_roles);
                $encrypt_filetype_array=array();
                if(!empty($edit_record->gncf_user_roles) && sizeof($edit_record->gncf_user_roles)>0) {
                foreach ($edit_record->gncf_user_roles as $filetype) {
                    $encrypt_filetype_array[] = $this->encrypt_data($filetype);
                }
                $edit_record->gncf_user_roles = json_encode($encrypt_filetype_array);
                }

                $all_generic_forms = Generic_flows::get_single_record('COUNT(jwf_id) AS count', 'jwf_forms LIKE \'%' . $gid . '%\'');
                if ($all_generic_forms->count > 0) {
                    $checkstage=false;
                }
                $custom_details['checkstage'] =$checkstage;
                $custom_details['custom_details'] =$edit_record;


                $custom_details['mode'] = 'edit';
                return $this->success('success', 200,$custom_details);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /* delete customform details for Super Admin Area */
    public function delete_generic_form(Request $request) {
        try {
            $validator = Validator::make($request->all(), [
                'gncf_id'      => 'required'

             ]);
            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $generic_form = $request->all();
            $jnl_code=$generic_form['jnl_code'];
            $current_user = $this->get_current_user_details();
            if (isset($generic_form['gncf_id']) && $generic_form['gncf_id'] != '') {
                $formid = $this->decrypt_data($generic_form['gncf_id']);
                $generic_data = Generic_forms::get_single_record_with_bind_cond('gncf_metadata_status,gncf_form_type', array('gncf_id'=>$formid) );
                $all_generic_forms = Generic_flows::get_single_record('COUNT(jwf_id) AS count', 'jwf_forms LIKE \'%' . $formid . '%\'');

                // //bug #2507 :- Db error is showing when delete form in manage custom form page
                if($jnl_code != NULL) {
                    $formatted_journal_code='_'.$jnl_code;
                    $record_exist = Article_generic_form_data::get_single_record("COUNT(gdata_id) AS count","gdata_atf_id={$formid} ",'',$formatted_journal_code);
                    if ($record_exist->count > 0) {
                        return  $this->warning(customTrans('customform.gncform-del-err'),200,'','warning');
                    }
                }else {
                    $found=0;
                    $found=$this->element_exist_check($formid);
                    if($found==1){
                        return  $this->warning(customTrans('customform.gncform-del-err'),200,'','warning');
                    }
                }

                // Task #3393 Metadata custom form fields should be able to delete
                // for metadata This form cannot be deleted because it is used in one or more journals.
                if(!empty($generic_data)) {
                    if($generic_data->gncf_metadata_status=='m') {
                        $meta_formcount = Journals::get_single_record_with_bind_cond('count(jnl_id) jnl_count',array("jnl_metadata_id"=>$formid))->jnl_count;
                        if($meta_formcount>0) {
                            return  $this->warning(customTrans('customform.gncform-del-err'),200,'','warning');
                        }
                    }
                }

                if ($all_generic_forms->count > 0) {
                    return  $this->warning(customTrans('customform.gncform-del-err'),200,'','warning');
                } else {
                    if ($generic_data->gncf_form_type != '') /* bug RVW730 */ {
                        $condition = 'gncf_id="' . $formid . '"';
                        Generic_forms::delete_records($condition, '', $current_user);
                        if (isset($generic_form['metastatus']) && $generic_form['metastatus'] === 'm') {
                            return $this->success(customTrans('customform.delete-meta-frm-success'), 200, array());
                        }
                        else{
                        return $this->success(customTrans('customform.delete-gene-frm-success'), 200, array());
                        }
                    } else {
                        return $this->success(customTrans('customform.gncform-del-unsuccess'), 200, array());
                    }
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /* copy customform details */
    public function copy_generic_form(Request $request) {
        try {
            $validator = Validator::make($request->all(), [
                'gncf_id'      => 'required'
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $form_data = $request->all();
            $jnl_code=$form_data['jnl_code'];
            $gncf_id = $this->decrypt_data($form_data['gncf_id']);
            $jnl_id = '';
            if($jnl_code != NULL) {
                $jnl_id = Journals::get_single_record('jnl_id', "jnl_journal_code = '{$jnl_code}' ")->jnl_id;
            }
            $new_gnf_id = $this->copy_generic_form_contents($gncf_id, $jnl_id, TRUE);
            $condition = 'gncf_id="' . $new_gnf_id . '"';
            if ($new_gnf_id !== FALSE) {
                $new_form_details['form_details'] = Generic_forms::get_single_record('*', $condition);
            }
            $new_form_details['form_id'] = $this->encrypt_data($new_gnf_id);
            $copy_msg =customTrans('customform.gncform-copy-msg'); 
            if(isset($form_data['metastatus']) && $form_data['metastatus'] =='m')
            {
                $copy_msg =customTrans('customform.metaform-copy-msg');
            }
            if(isset($form_data['metastatus']) && $form_data['metastatus'] =='s')
            {
                $copy_msg =customTrans('customform.supportingform-copy-msg');
            }
            return response()->json([
                'success' => true,
                'result' => $new_form_details,
                'message' => $copy_msg
            ]);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function copy_generic_form_contents($form_id, $jnl_id, $check_form_name_duplication = FALSE) {
        /*
                 * -Copy master custom forms and create new in the same level
                 * to check the form name is unique or not
                 * $check_form_name_duplication is TRUE only when copy_generic_form_contents is redirected from Manage_generic_form.php otherwise $check_form_name_duplication is false
                 */
        try{
        $this->current_user = $this->get_current_user_details();
        $new_form_name = NULL;
        if ($check_form_name_duplication == TRUE) {
            $condition = "gncf_id=" . $form_id;
            $form_name = Generic_forms::get_single_record('gncf_form_name', $condition);
            $newname = $this->check_form_name_exist($form_id, $form_name->gncf_form_name);
            if (!empty($newname)) {
                $new_form_name = $newname;
            }
        }
        //copy from
        $new_gnf_id = Generic_forms::move_generic_from($form_id, $jnl_id, $this->current_user, $new_form_name);
        $new_form_id = FALSE;
        if ($new_gnf_id !== FALSE) {
            $new_form_id = $new_gnf_id;
            //generic form group movement
			Generic_form_groups::move_generic_form_groups($form_id, $new_gnf_id, $this->current_user['user_id']);

			//generic form group elements movement
			Generic_form_elements::move_generic_form_elements($form_id, $new_gnf_id, $this->current_user['user_id']);

			//update group id in  rvw_generic_form_elements tb
			Generic_form_elements::update_form_element_group($new_gnf_id);
			//update group dependency elements rvw_generic_form_elements tb
			Generic_form_elements::update_form_element_dependency($new_gnf_id);
			//clear old gfg id
			Generic_form_groups::update_record(array('gfg_old_gfg_id' => NULL),"gfg_gncf_id={$new_gnf_id}");

			//clear old_emt_id
			Generic_form_elements::update_record(array('emt_old_emt_id' => NULL),"emt_gucf_id={$new_gnf_id}");
        }

        return $new_form_id;
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
    }

    public function check_form_name_exist($form_id, $formname) {
        try {
            $append_wrd = ' copy';
            $formname =  $formname . $append_wrd;
            $form_chk = $this->checkforname($formname);
            if ($form_chk["found"]) {
                $newfrm_name = $this->check_form_name_exist($form_id, $formname);
            } else {
                $newfrm_name = $formname;
            }
            return $newfrm_name;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }


//generic form builder settings page  group element listing
public function generic_form_settings(Request $request) {
    try {
        $form_data = $request->all();
        $result=array();
        $id = $this->decrypt_data($form_data['edit_record']);
        if ($id != '') {
            $criteria3 = 'gncf_id="' . $id . '"';
		    $get_record = Generic_forms::get_single_record('*',$criteria3); //INTRV0302
            $result['form_setng_path_segmnt']='';
            if(!empty($get_record)) {
                $result['table_data']['form_data']= $get_record;
                $result['client_functionality'] = $this->current_client->functionality;
                $client_code = $this->current_client->clnt_client_code;
                $generic_config = 'clients.' . $this->current_client->clnt_client_code . '.generic_form_identifiers.identifier';
                $generic_form_identifier = Config::get($generic_config);
                $result['table_data']['generic_form_identifier']= $generic_form_identifier;
                $result['cd_code_help'] = customTrans('customform.cd_code_help');
                $result['table_data']['id']= $this->encrypt_data($id);

                $condition = 'emt_gucf_id="' . $id . '"';
                $groupelementdata = Generic_form_elements::get_all_records('*', $condition, 'emt_order');

                // start -- looping form elements to add selectbox options from tables, if "emp_populate_from_table" is set
                $populate_tables = $this->Utility('populate_tables');
                foreach ($groupelementdata as $val) {
                    if ($val->emt_element_type == 'combobox' ) {
                        $pop_all_keys = array_keys($populate_tables['populate_tables']);
                        foreach($pop_all_keys as $key => $value){
                            $pop_all_keys2 = array_keys($populate_tables['populate_tables'][$value]);
                            if(in_array($val->emp_populate_from_table, array_keys($populate_tables['populate_tables'][$value]))) {
                                $val->emt_options =$this->populate_options_from_table($val,$populate_tables['populate_tables'][$value]);
                            }
                        }
                    }
                }
                $groupelementarray=array();
                foreach ($groupelementdata as $val) {
                     // Task #8244 populate data task start
                    $val->emt_populate_data_pair=json_decode($val->emt_populate_data_pair,true);
                    // Task #8244 populate data task end
                    $groupelementarray[$val->emt_gfg_id.'-'.$val->emt_id]=$val;
                }
                // end -- looping form elements to add selectbox options from tables

                $result['groupelementdata']=$groupelementdata;
                // Task #8244 populate data task start
                $result['groupelementarray'] = Generic_form_elements::get_all_records('emt_id,emt_label,emt_populate_data_pair',$condition);
                // Task #8244 populate data task end
                $condition2 =array('gfg_gncf_id'=>$id);
                $result['groupdata']=Generic_form_groups::get_all_records_with_bind_cond('`gfg_id`, `gfg_gncf_id`, `gfg_group_name`, `gfg_dynamic_status`, `gfg_order`, `gfg_posted_by`, `gfg_posted_date`, `gfg_old_gfg_id`, `gfg_proxy_id`, `gfg_operation`', $condition2, '',array(),'gfg_order');
            }
            $result['upload_file_size_config']=$this->get_uploaded_file_size_config();
            $distinctValues=$this->usedflags($id);
            $sql= "SELECT emt_gucf_id,emt_flag_id,emt_id FROM `rvw_generic_form_elements` WHERE `emt_gucf_id`={$id} AND `emt_flag_id` IS NOT NULL";
            $cur_empt_flg_count = Generic_form_elements::get_records_by_raw_query($sql);
            $distinctValues =[];
            $form_ids = Generic_flows::whereJsonContains('jwf_forms',$id)
            ->pluck('jwf_forms')
            ->flatMap(function ($item) {
                $decoded = json_decode($item, true);
                return is_array($decoded) ? $decoded : [];
            })
            ->unique()
            ->values()
            ->toArray();
            if(empty($form_ids)) {
                $form_ids[] = $id;
            }
            $valid_flags = Generic_form_elements::whereIn('emt_gucf_id', $form_ids)
            ->whereNotNull('emt_flag_id')
            ->where(DB::raw('JSON_LENGTH(emt_flag_id)'), '>', 0)
            ->pluck('emt_flag_id')
            ->map(function ($flagId) {
                return json_decode($flagId, true);
            })
            ->filter() // Filter out null/empty results from json_decode
            ->toArray();
            foreach ($valid_flags as $outerArray) {
                foreach ($outerArray as $innerArray) {
                    foreach ($innerArray as $key => $value) {
                        $distinctValues[$key] = $value; // Use keys to avoid duplicates
                    }
                }
            }
           
            $distinctArray = array_unique($distinctValues);
            $distinctValues = array_values($distinctArray );
            foreach ($cur_empt_flg_count as $item) {
                $jsonArray = json_decode( $item->emt_flag_id, true);
                
                foreach ($jsonArray as $flag) {
                    if(isset(array_values($flag)[0])){
                    $emtFlagIds[] = array_values($flag)[0];
                    }
            }
            }
            $result['used_flag_array']=isset($distinctArray)?$distinctValues:null;
            return $this->success('success', 200,$result);
        }
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
}

//Changing form group title
public function change_group_title(Request $request) {
    //DB::beginTransaction();
    try {
        $form_data = $request->all();
        $groupid=$this->decrypt_data($form_data['groupid']);
        $validator = Validator::make($request->all(), [
            'groupid'      => 'required',
            //'title'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }
        $this->current_user = $this->get_current_user_details();
        if ($form_data['title'] != strip_tags($form_data['title'])) {
            if (preg_match("#<([a-zA-Z]+).*?>(.*?)</\\1>#", $form_data['title']) === 0) {
                return  $this->warning(customTrans('customform.html_tag_err'),200,'','warning');
            }
        }
        $title = array(
            'gfg_group_name' => $form_data['title']);
        if(strtolower($form_data['title'])!= "group name") {
            $condition='gfg_id='.$groupid;
            $insertid = Generic_form_groups::update_record($title,$condition,$this->current_user);
        }
        // DB::commit();
        return $this->success('Success',200,array());
    } catch (\Exception $e) {
        // DB::rollback();
        return $this->failure('Failed', 500, $e);
    }
}

public function view_form_demo(Request $request) {
    try {
        $form_data = $request->all();
        $formid=$this->decrypt_data($form_data['formid']);
        $article_id=$this->decrypt_data($form_data['article_id']);
        $jnl_id=$this->decrypt_data($form_data['jnlid']);
        $jnl_code=$form_data['jnl_code'];
        $flow_id=$this->decrypt_data($form_data['flow_id']);
        $stage_type=$form_data['stage_type'];
        $metadata=isset($form_data['metadata'])?$form_data['metadata']:false; 
        $stage_repeat_count=isset($form_data['stage_repeat_count'])?$form_data['stage_repeat_count']:0;
        $validator = Validator::make($request->all(), [
            'formid'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }
         // TASK #7033 SQL injection viewformdemo
        $formidarray = array('input'=>$form_data['formid'],'type'=>'number', 'enc_data'=>TRUE );
        $formidvalidation= $this->Rv_validator($formidarray);
        if($formidvalidation != TRUE){
            return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
        }
        // end TASK #7033 SQL injection viewformdemo

        $chekjnlflag = true;
        if(!empty($jnl_code))
        {
            if(is_string($jnl_code))
            {
                $journaldata = Journals::get_single_record_with_bind_cond('jnl_id', array('jnl_journal_code'=>$jnl_code) );
                if(!isset($journaldata->jnl_id) || (isset($journaldata->jnl_id) && empty($journaldata->jnl_id)))
                {
                    $chekjnlflag = false;
                }
            }
            else{
                $chekjnlflag = false;
            }
        }
        if($chekjnlflag == false){
            return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
        }

        $groups = Generic_form_groups::get_all_records('gfg_group_name,gfg_id,gfg_order,gfg_dynamic_status',"gfg_gncf_id= ?", 'gfg_order',binding_arr:[$formid]);

        $editcmtfrm = FALSE;
        $EditfrmCondition = '';
        if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y')
        {
            if(isset($form_data['viewemt']))
            {
                $editcmtfrm=$form_data['editcmtfrm'];
                $viewemt_ids=$this->decrypt_data($form_data['viewemt']);
                if($viewemt_ids != '' && $editcmtfrm == TRUE)
                {
                    $EditfrmCondition = ' AND (emt_id IN ('.$viewemt_ids.') OR emt_depending_control IN ('.$viewemt_ids.'))';

                    $Generic_form_groups_obj = new \App\Models\Generic_form_groups;
                    $Generic_form_groups = (new \App\Models\Generic_form_groups)->getTable();
                    $Generic_form_elements = (new \App\Models\Generic_form_elements)->getTable();
                    $tables = array(
                        'main_table' => $Generic_form_groups,
                        'join_table' => array(
                            $Generic_form_elements => array('gfg_id','emt_gfg_id', "join")
                        )
                    );
                    $condition = "gfg_gncf_id= ?".$EditfrmCondition;
                    $groups = $Generic_form_groups_obj::get_results_using_joins($tables, "gfg_group_name,gfg_id,gfg_order,gfg_dynamic_status", $condition, 'all','gfg_order',NULL, '', NULL,NULL,FALSE, 'gfg_id',binding_arr:[$formid]);
                }
            }
        }


        $subflow_id=$flow_id;
        if($stage_type=='author_submission') {
            $subflow_id=Article_flow::check_articlesubmission($article_id)->aflw_id;
            $flow_id=$subflow_id;
        }

 		$out['group_count'] = count($groups);
        $out[$formid]= (object) ['form_validation' => false];
        $noofelmt = Generic_form_elements::get_single_record('count(emt_id) as noofelmt',"emt_gucf_id= ? {$EditfrmCondition}",binding_arr:[$formid])->noofelmt;
        $out['updatebtn'] = $noofelmt;
        $out['label_only'] = false;
        if(!empty($groups)) {
            $groupidarray=array();
            $warnarray=array();
        foreach ($groups as $group) {
			//Display title for each form groups
            $groupnamearray=array();
			if ($group->gfg_group_name != "") {
                array_push($groupnamearray,$group->gfg_group_name);
			}
            array_push($groupidarray,$group->gfg_id);
            $out['group_data'][$group->gfg_order][$group->gfg_id]['groupname']=$groupnamearray;
            $out['group_data'][$group->gfg_order][$group->gfg_id]['groupdynamicstatus']=$group->gfg_dynamic_status;

            $elements = Generic_form_elements::get_all_records('*',"emt_gucf_id= ? and emt_gfg_id={$group->gfg_id} {$EditfrmCondition}", 'emt_order',binding_arr:[$formid]);
            if(!empty($elements)) {
                $elmtdata=array();
                $elmtdetails=array();
                foreach ($elements as $element) {
                    $conditions3="emt_gucf_id= ? and emt_gfg_id={$group->gfg_id} and emt_id={$element->emt_id}";
                    $element_data = Generic_form_elements::get_single_record('*',$conditions3,binding_arr:[$formid]);

                    $emt_depending_groupid=$group->gfg_id;
                    if($element->emt_dependency_required==1 && isset($element->emt_depending_control) && !empty($element->emt_depending_control)) {
                        $conditions3="emt_gucf_id= ? and emt_id={$element->emt_depending_control}";
                        $dependelement_data = Generic_form_elements::get_single_record('emt_gfg_id',$conditions3,binding_arr:[$formid]);
                        $emt_depending_groupid=isset($dependelement_data->emt_gfg_id)?$dependelement_data->emt_gfg_id:$group->gfg_id;
                    }

                    $element_data->emt_depending_groupid=$emt_depending_groupid;
                    // label only condition
                    if($noofelmt==1 && $element->emt_element_type == 'label') {
                        $out['label_only'] = true;
                    }


                    $out['populate_tables'] =$populate_tables= $this->Utility('populate_tables');
                    if ($element->emt_element_type == 'combobox' ) {
                        $pop_all_keys = array_keys($populate_tables['populate_tables']);
                        foreach($pop_all_keys as $key => $value){
                            $pop_all_keys2 = array_keys($populate_tables['populate_tables'][$value]);
                            if(in_array($element->emp_populate_from_table, array_keys($populate_tables['populate_tables'][$value]))) {
                                $element_data->emt_options =$this->populate_options_from_table($element,$populate_tables['populate_tables'][$value]);
                            }
                        }
			        } elseif($element->emt_populate_data == 1 && ($element->emt_element_type == 'textbox' || $element->emt_element_type == 'textarea') && !empty($article_id) && $element->emt_source_formid != '') {
                        if (isset($element->emt_populate_data_pair)) {
                            $gdatadt_content ='';
                            $populatedata = json_decode($element->emt_populate_data_pair, true);             
                            foreach ($populatedata as $outerItem) {
                                if (is_array($outerItem) && !empty($outerItem)) {
                                    foreach ($outerItem as $source_id => $elmt_array) { // Direct access to source ID and element array
                                        if (is_array($elmt_array) && !empty($elmt_array)) {
                                            foreach ($elmt_array as $element_id) { // Iterate through element IDs (if there are multiple)
                                                $genericformscondition ="gncf_id={$source_id}";
                                                $genericformsdata = Generic_forms::get_single_record('gncf_form_type',$genericformscondition);
                                                $form_stage_type =$genericformsdata->gncf_form_type;
                                                $group_by=NULL;
                                                $limit=" limit 1";
                                                $order=' order by aflw_id desc';
                                                if($form_stage_type == 'review') {
                                                    $group_by=' group by jwf_id,aflw_id';
                                                    $limit=NULL;
                                                    $order = ' order by gdata_posted_date asc';
                                                }
                                                $formatted_journal_code='_'.$jnl_code;
                                                if($metadata){
                                                    $record_exist = Article_generic_form_data::get_single_record("gdata_label,gdata_data","gdata_atfemt_id={$element_id} and gdata_artflw_stage_repeat_count=? ",'',$formatted_journal_code,binding_arr:[$article_id,$flow_id,$stage_repeat_count]);
                                                }else{
                                                    $record_exist = Article_generic_form_data::get_single_record("gdata_label,gdata_data","gdata_atfemt_id={$element_id} and  gdata_art_id= ? and gdata_artflw_id= ? and gdata_artflw_stage_repeat_count=? ",'',$formatted_journal_code,binding_arr:[$article_id,$flow_id,$stage_repeat_count]);
                                                }
                                                if(empty($record_exist)) {
                                                    $another_element_data = Generic_form_elements::get_single_record('*',"emt_gucf_id={$source_id} and emt_id={$element_id}");
                        
                                                    $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
                                                    $article_table = (new \App\Models\Articles())->getTable();
                                                    $article_type_advance_options_table = (new \App\Models\Article_type_advance_options())->getTable();
                                                    $tab_name = $article_generic_form_data_table.'_'.$jnl_code;

                                                    $sql = "select aflw_status,gdata_label,gdata_data,gdata_posted_by from {$tab_name} left join rvw_article_flow on gdata_artflw_id = aflw_id left join rvw_journal_workflows on aflw_jwf_id=jwf_id where gdata_atfemt_id=".$element_id." and gdata_art_id= ?".$group_by.$order.$limit;
                                                    $label = Article_generic_form_data::get_records_by_raw_query($sql,binding_arr:[$article_id]);
                                        

                                                    $sql = "select atotp_review_method, atotp_custom_blind_params from {$article_table} left join {$article_type_advance_options_table} on art_artp_id=atotp_artp_id where art_id= ?";
                                                    $data_sql = Articles::get_records_by_raw_query($sql,binding_arr:[$article_id]);

                                                    $atotp_review_method = isset($data_sql[0]->atotp_review_method)?$data_sql[0]->atotp_review_method:'';
                                                    $atotp_review =  isset($data_sql[0]->atotp_review_method)?$data_sql[0] : "";
                                                    $gdatadt_label='';
                                                    if(!empty($label)) {
                                                        if(count($label)>1) {
                                                            $gdatadt_label = $label[0]->gdata_label;
                                                            $l=1;
                                                            foreach($label as $lb) {
                                                                if($lb->aflw_status == 'c') {
                                                                $gdatadt_content.=$this->get_element_content($element_data,$jnl_id,$atotp_review_method,$article_id,$form_stage_type,$lb,$l,$atotp_review);
                                                                $l++;
                                                                }
                                                            }
                                                        } else{
                                                            if($element->emt_element_type == 'textbox'){
                                                                $gdatadt_content.=' ';
                                                            }else{
                                                            $gdatadt_content.='&#13;&#10;';
                                                            }
                                                            if(!empty($another_element_data)) {
                                                                $reviewemptystatus='';
                                                                $reviewemptyarray=array();
                                                                if($form_stage_type == 'review' && count($label)==1){
                                                                    if($element_data->emt_tinymce_required == TRUE) {
                                                                        $reviewemptystatus='t'; // for tinymce
                                                                    } else {
                                                                        $reviewemptystatus='r'; // for textarea
                                                                    }
                                                                }
                                                            if($another_element_data->emt_element_type!='radiobutton') {
                                                                $gdatadt_content_temp=$this->get_element_content($element_data,$jnl_id,$atotp_review_method,$article_id,$form_stage_type,$label[0], null, $atotp_review);
                                                                $original_data=str_replace("<p>","",$gdatadt_content_temp);
                                                                $original_data=str_replace("</p>", "", $original_data);
                                                                if(!empty($original_data) && $form_stage_type == 'review'){
                                                                    if($reviewemptystatus=='t'){ // for tinymce
                                                                        $gdatadt_content.='<p><strong>Reviewer #1</strong></p>';
                                                                    }else if($reviewemptystatus=='r'){ // for textarea
                                                                        $gdatadt_content.='Reviewer #1 ';
                                                                        if($element_data->emt_populate_data == TRUE) {
                                                                            $gdatadt_content.='&#13;&#10;';
                                                                        }
                                                                    }
                                                                }
                                                                $gdatadt_content.=$gdatadt_content_temp;
                            
                                                            } else {
                                                                $options = json_decode($another_element_data->emt_options,TRUE);
                                                                if(!empty($options)) {
                                                                    if($form_stage_type == 'review'){
                                                                        if($reviewemptystatus=='t'){ // for tinymce
                                                                            $gdatadt_content.='<p><strong>Reviewer #1</strong></p>';
                                                                        } else if($reviewemptystatus=='r'){ // for textarea
                                                                            $gdatadt_content.='Reviewer #1 ';
                                                                            if($element_data->emt_populate_data == TRUE) {
                                                                                $gdatadt_content.='&#13;&#10;';
                                                                            }
                                                                        }
                                                                    }
                                                                    foreach($options as $opts) {
                                                                        $i = 1;
                                                                        foreach($opts as $key => $value) {
                                                                            if($key == $label[0]->gdata_data) {
                                                                                $gdatadt_content.=$value;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        }
                                                    }
                                                    $element_data->element_gdata = trim($gdatadt_content);

                                                }
                                               }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    array_push($elmtdetails,$element_data);
                    $element->emt_label = str_replace('"', '\"', $element->emt_label);

                    if($metadata){
                        $dynamic_orders = (isset($jnl_code) && isset($formid)) ?Article_generic_form_data::get_all_records('distinct gdata_dynamic_id,gdata_id', " gdata_atf_id = ? and gdata_atfemt_id={$element->emt_id} ", "gdata_dynamic_id", null ,"_".$jnl_code,binding_arr:[$formid]):[];
                    }else {
                        $dynamic_orders = (isset($article_id) && isset($jnl_code) && isset($formid)) ?Article_generic_form_data::get_all_records('distinct gdata_dynamic_id,gdata_id', " gdata_art_id = ?    and gdata_atf_id = ? and gdata_atfemt_id={$element->emt_id} ", "gdata_dynamic_id", null ,"_".$jnl_code,binding_arr:[$article_id,$formid]):[];
                    }

                    


                    if(count($dynamic_orders) == 0){
                        $dynamic_orders = [(object)['gdata_dynamic_id' => 0]];
                    }
                    $baseFields = [
                        'elmnt_type' => $element->emt_element_type,
                        'group_id' => $group->gfg_id,
                        'formid' => $formid,
                        'dependency_required' => $element->emt_dependency_required,
                        'depending_control' => 'form_' . $formid . '_' . $element->emt_depending_control,
                        'depending_value' => $element->emt_depending_value,
                        'depending_groupid' => $element->emt_depending_groupid ?? null,
                        'field_name' => 'form_' . $formid . '_' . $element->emt_id,
                        'emt_id' => $element->emt_id,
                        'emt_dynamic_status' => isset($element->emt_dynamic_status)?$element->emt_dynamic_status:'n'
                    ];


                foreach($dynamic_orders as $dynamic_order){
                    $baseFields['dynamic_id']=isset($dynamic_order->gdata_dynamic_id)?$dynamic_order->gdata_dynamic_id:0;


                    switch (trim($element->emt_element_type)) {
                        case 'textbox':
                            $min_required=false;
                            $min_char=false;
                            $max_required=false;
                            $max_char=false;
                            $email_required=false;
                            $required=false;
                            $date_required=false;
                            $date_format = '"dd-mm-yy"';
                            $digit_required=false;
                            if ($element->emt_required == 1) {
						        $required=true;
                                $out[$formid]= (object) ['form_validation' => true];
                            }
                            if($element->emt_min_char>0) {
                                $min_required=true;
                            }
                            if($element->emt_max_char>0) {
                                $max_required=true;
                            }
                            if (!empty($element->emt_min_char)) {
                                if ($element->emt_column_type == "nu")
                                $min_required=true;
                                $min_char=$element->emt_min_char;
                            }
                            if (!empty($element->emt_max_char)) {
                                if ($element->emt_column_type == "nu")
                                $max_required=true;
                                $max_char=$element->emt_max_char;
                            }
                            if ($element->emt_column_type == 'em') {
                                $email_required=true;
                            }
					        if ($element->emt_column_type == 'da') {
						        if (isset($gnfdatae) && $gnfdatae != '') {
							        $date_format = $gnfdatae;
						        } else {
							        $date_format = '"dd-mm-yy"';
						        }
                                $date_required=true;
						    }
					        if ($element->emt_column_type == 'nu') {
                                $digit_required=true;
					        }

                            $additionalFields = [
                                'field_required' => $required,
                                'column_type' => $element->emt_column_type,
                                'min_required' => $min_required,
                                'min_char' => $min_char,
                                'max_required' => $max_required,
                                'max_char' => $max_char,
                                'email_required' => $email_required,
                                'date_format' => $date_format,
                                'date_required' => $date_required,
                                'digit_required' => $digit_required,
                            ];
                            array_push($warnarray, array_merge($baseFields, $additionalFields));

                            break;
                        case 'textarea':
                            $required=false;
                            $tinymce_required=false;
                            $wordmin_required=false;
                            $wordmin_char=false;
                            $wordmax_required=false;
                            $wordmax_char=false;
                            $tinymce_height=false;
                            if ($element->emt_required == 1) {
						        $required=true;
                                $out[$formid]= (object) ['form_validation' => true];
                            }
                             if($element->emt_word_min>0) {
                                $wordmin_required=true;
                                $wordmin_char=$element->emt_word_min;
                            }
                            if($element->emt_word_max>0) {
                                $wordmin_required=true;
                                $wordmin_char=$element->emt_word_min;
                                $wordmax_required=true;
                                $wordmax_char=$element->emt_word_max;
                            }

                            if ($element->emt_tinymce_required == 1) {
						        $tinymce_required=true;
                                $tinymce_height = 20 * $element->emt_textarea_rows;
                            }

                            $additionalFields = [
                                'field_required' => $required,
                                'wordmin_required' => $wordmin_required,
                                'wordmin_char' => $wordmin_char,
                                'wordmax_required' => $wordmax_required,
                                'wordmax_char' => $wordmax_char,
                                'tinymce_required' => $tinymce_required,
                                'tinymce_height' => $tinymce_height
                            ];
                            array_push($warnarray, array_merge($baseFields, $additionalFields));

                            break;
                        case 'combobox'|| 'radiobutton'||'checkbox' || 'file':
                            $required=false;
                            if ($element->emt_required == 1) {
						        $required=true;
                                $out[$formid]= (object) ['form_validation' => true];
                            }
                            $additionalFields = [
                                'field_required' => $required
                            ];
                            array_push($warnarray, array_merge($baseFields, $additionalFields));
                            break;
                        case 'label':
                            $additionalFields = [];
                            array_push($warnarray, array_merge($baseFields, $additionalFields));
                            break;
                    }
                }

                }

                if($metadata){
                    $dynamic_orders = (isset($article_id) && isset($jnl_code) && isset($formid)) ? Article_generic_form_data::get_all_records('distinct gdata_dynamic_id', "gdata_atf_id = ? and gdata_gfg_id = '$group->gfg_id' ", "gdata_dynamic_id", null ,"_".$jnl_code,binding_arr:[$formid]) : [];
                }else{
                    $dynamic_orders = (isset($article_id) && isset($jnl_code) && isset($formid)) ? Article_generic_form_data::get_all_records('distinct gdata_dynamic_id', " gdata_art_id = ? and gdata_atf_id = ? and gdata_gfg_id = '$group->gfg_id' ", "gdata_dynamic_id", null ,"_".$jnl_code,binding_arr:[$article_id,$formid]) : [];
                }
                
                if(count($dynamic_orders) == 0){
                    $dynamic_orders = [(object)['gdata_dynamic_id' => 0]];
                }
                foreach($dynamic_orders as $dynamic_order){
                    $out['group_data'][$group->gfg_order][$group->gfg_id][$dynamic_order->gdata_dynamic_id]['elementdata']=$elmtdata;
                    $out['group_data'][$group->gfg_order][$group->gfg_id][$dynamic_order->gdata_dynamic_id]['elementdetails']=$elmtdetails;
                }
            }

		}
        $out['group_id']=$groupidarray;
        $out['warningdata']=$warnarray;
        }
        $general_config= Config::get('general_config');
        $source_count = $general_config['source_count'];
        $out['source_count']=$source_count;
        $out['upload_file_size_config']=$this->get_uploaded_file_size_config();
        $out['client_functionality'] = $this->current_client->functionality;
        $out['subflow_id'] = $subflow_id;
        return $this->success('Success',200,$out);
    } catch(\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
}

public function add_form_group(Request $request) {

    DB::beginTransaction();
    try {
        $form_data = $request->all();
        $formid=$this->decrypt_data($form_data['formid']);
        $reference_id=$this->decrypt_data($form_data['reference_id']);
        $data = array();

        $validator = Validator::make($request->all(), [
            'formid'      => 'required',
            'reference_id'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }


		if ($formid != '') {
			$insert_data = array(
				'gfg_gncf_id' => $formid);

			//if referenceid equal zero just save in normal way
			if ($reference_id == '0') {
                $maxorderid = Generic_form_groups::get_max_group_order($formid);
				$maxorderid++;
				$insert_data['gfg_order'] = $maxorderid;
			} else {
				//referenceid not equal zero then find that reference id row in table
                $criteria='gfg_id='.$reference_id;
                $orderid = Generic_form_groups::get_single_record('gfg_order', $criteria);
				//find rows greater than or equal to that order id and increment those with 1
                $out = Generic_form_groups::increment_orderids($formid, $orderid->gfg_order);  //save this order id as current row order id and save the record
				if ($out == TRUE) {
					$insert_data['gfg_order'] = $orderid->gfg_order;
				}
			}
            $this->current_user = $this->get_current_user_details();
			$insertid = Generic_form_groups::insert_record($insert_data, $this->current_user);
			$insert_data["gfg_id"] = $insertid;
			$insert_data["gfg_group_name"] = "";
		}
		DB::commit();
        return $this->success('Success',201,array());
    }catch (\Exception $e) {
        DB::rollback();
        return $this->failure('Failed', 500, $e);
    }

}

public function delete_group(Request $request) {
	DB::beginTransaction();
	try {

        $this->current_user = $this->get_current_user_details();
        $form_data = $request->all();
        $validator = Validator::make($request->all(), [
            'formid'      => 'required',
            'groupid'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }

        $formid=$this->decrypt_data($form_data['formid']);
        $groupid=$this->decrypt_data($form_data['groupid']);
		$data = array(
			'formid' => $formid,
			'groupid' => $groupid);
		//Checking whether this group have any elements
		$groupelement = Generic_form_elements::check_group_element($data);
		if ($groupelement === true) {
            return  $this->warning(customTrans('customform.plselement-rmv-group'),200,'','warning');
    	} else {
            $criteria = 'gfg_gncf_id="'.$formid.'" and gfg_id="'.$groupid.'"  ';
			$result = Generic_form_groups::delete_records($criteria,"",$this->current_user);
            DB::commit();
		    $msg_arr[]=customTrans('customform.group-rmv-success');
		    return $this->success($msg_arr,201,array());
		}
	} catch(\Exception $e) {
		DB::rollback();
		return  $this->failure('Failed',500,$e);
	}
}
public function update_group_settngs(Request $request) {
	try {
        DB::beginTransaction();
        $msg_arr='Failed';
        $current_user = $this->get_current_user_details();
        $Generic_form_elements = (new \App\Models\Generic_form_elements())->getTable();
        $form_data = $request->all();
        $validator = Validator::make($request->all(), [
            'formid'      => 'required',
            'groupid'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }
        else
        {
            $formidarray = array('input'=>$form_data['formid'],'type'=>'number', 'enc_data'=>TRUE );
            $groupidarray = array('input'=>$form_data['groupid'],'type'=>'number', 'enc_data'=>TRUE );
            $formidvalidation= $this->Rv_validator($formidarray);
            $groupidvalidation= $this->Rv_validator($groupidarray);
            if($formidvalidation == TRUE || $groupidvalidation == TRUE ) {
                $msg_arr=customTrans('customform.dynamic-group-rmv-success');
                $formid=$this->decrypt_data($form_data['formid']);
                $groupid=$this->decrypt_data($form_data['groupid']);
                $formdata = array(
                    'emt_gucf_id' => $formid,
                    'emt_gfg_id' => $groupid,
                    'emt_dynamic_status'=>'y'
                );

                $resflagCount  = Generic_form_elements::get_single_record_with_bind_cond('count(emt_gucf_id) as cnt', null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_flag_id is not null ", [$formid, $groupid]);
                if ($resflagCount->cnt > 0) {
                    $resflag  = Generic_form_elements::get_single_record_with_bind_cond("CASE WHEN COUNT(emt_label) = 1 THEN MAX(emt_label)  WHEN COUNT(emt_label) = 2 THEN GROUP_CONCAT(emt_label SEPARATOR ' and ') ELSE CONCAT(SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', COUNT(emt_label)-1),' and ',SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', -1))END AS label", null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_flag_id is not null ", [$formid, $groupid]);

                    $msg=customTrans('customform.group_dymnamic_warn_check',array('label' => 'flags','labelval'=>$resflag->label));
                    return  $this->warning($msg,200,'','warning');
                }

                $resdepCount  = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt', null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_dependency_required =? ", [$formid, $groupid,1]);
                if ($resdepCount->cnt > 0) {
                    $resflag  = Generic_form_elements::get_single_record_with_bind_cond("CASE WHEN COUNT(emt_label) = 1 THEN MAX(emt_label)  WHEN COUNT(emt_label) = 2 THEN GROUP_CONCAT(emt_label SEPARATOR ' and ') ELSE CONCAT(SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', COUNT(emt_label)-1),' and ',SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', -1))END AS label", null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_dependency_required = ? ", [$formid, $groupid,1]);
                    $msg=customTrans('customform.group_dymnamic_warn_check',array('label' => 'dependancy','labelval'=>$resflag->label));
                    return  $this->warning($msg,200,'','warning');
                }

                $resuniqueCount  = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt', null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_unique_identifier is not null ", [$formid, $groupid]);
                if ($resuniqueCount->cnt > 0) {
                    $resflag  = Generic_form_elements::get_single_record_with_bind_cond("CASE WHEN COUNT(emt_label) = 1 THEN MAX(emt_label)  WHEN COUNT(emt_label) = 2 THEN GROUP_CONCAT(emt_label SEPARATOR ' and ') ELSE CONCAT(SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', COUNT(emt_label)-1),' and ',SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', -1))END AS label", null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_unique_identifier is not null ", [$formid, $groupid]);
                    $msg=customTrans('customform.group_dymnamic_warn_check',array('label' => 'unique identifier','labelval'=>$resflag->label));
                    return  $this->warning($msg,200,'','warning');
                }

                $respopCount  = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt', null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_populate_data =? ", [$formid, $groupid,1]);
                if ($respopCount->cnt > 0) {
                    $resflag  = Generic_form_elements::get_single_record_with_bind_cond("CASE WHEN COUNT(emt_label) = 1 THEN MAX(emt_label)  WHEN COUNT(emt_label) = 2 THEN GROUP_CONCAT(emt_label SEPARATOR ' and ') ELSE CONCAT(SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', COUNT(emt_label)-1),' and ',SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', -1))END AS label", null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_populate_data = ? ", [$formid, $groupid,1]);
                    $msg=customTrans('customform.group_dymnamic_warn_check',array('label' => 'populate data from another form','labelval'=>$resflag->label));
                    return  $this->warning($msg,200,'','warning');
                }


                $resCount = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt',  $formdata);
                if ($resCount->cnt > 0) {
                    $resflag  = Generic_form_elements::get_single_record_with_bind_cond("CASE WHEN COUNT(emt_label) = 1 THEN MAX(emt_label)  WHEN COUNT(emt_label) = 2 THEN GROUP_CONCAT(emt_label SEPARATOR ' and ') ELSE CONCAT(SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', COUNT(emt_label)-1),' and ',SUBSTRING_INDEX(GROUP_CONCAT(emt_label SEPARATOR ', '), ', ', -1))END AS label", null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_dynamic_status = ? ", [$formid, $groupid,'y']);
                    $msg=customTrans('customform.group_dymnamic_warn_check',array('label' => 'dynamic element','labelval'=>$resflag->label));
                    return  $this->warning($msg,200,'','warning');
                } else {
                
                    $criteria= array(
                        'gfg_gncf_id'=>$formid,
                        'gfg_id'=>$groupid
                    );
                    $data = [
                        'gfg_dynamic_status' => ($form_data['dynamicstatus'] == 'n') ? 'y' : 'n'
                    ];
                    Generic_form_groups::update_record($data,$criteria,$current_user);
                    // If the group is dynamic, then the dependency set is empty.
                    $criteria_dependent= array(
                        'emt_gucf_id'=>$formid,
                        'emt_gfg_id'=>$groupid,
                        'emt_dependency_required'=>1
                    );
                    $resCountDepend = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt',  $criteria_dependent);
                    if ($resCountDepend->cnt > 0) {
                        $data_element = array(
                            'emt_dependency_required' => 0,
                            'emt_depending_control' => 0,
                            'emt_depending_value' => ''
                        );
                        Generic_form_elements::update_record($data_element,$criteria_dependent,$current_user);
                    }

                    // If the group is dynamic, then the populate data set is empty.
                    $criteria_poulate= array(
                        'emt_gucf_id'=>$formid,
                        'emt_gfg_id'=>$groupid,
                        'emt_populate_data'=>1
                    );
                    $resCountPopulate = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt',  $criteria_poulate);
                    if ($resCountPopulate->cnt > 0) {
                        $data_populate = array(
                            'emt_source_formid' => null,
                            'emt_source_elementid' => null,
                            'emt_populate_data_pair' => null,
                            'emt_populate_data' => 0
                        );
                        Generic_form_elements::update_record($data_populate,$criteria_poulate,$current_user);
                    }

                    $resCountIdentifier  = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt', null, "emt_gucf_id = ?  AND emt_gfg_id = ? AND emt_unique_identifier is not null ", [$formid, $groupid]);
                    if ($resCountIdentifier->cnt > 0) {
                        // If the group is dynamic, then the Unique identifier set is empty.
                        $criteria_unique= "emt_gucf_id='{$formid}' and emt_gfg_id='{$groupid}' and emt_unique_identifier is not null";

                        $data_unique = array(
                            'emt_unique_identifier' => null
                        );
                        Generic_form_elements::update_record($data_unique,$criteria_unique,$current_user);
                    }

                    // If the group is dynamic, then the custom form Flag set is empty.
                    $criteria_flag= "emt_gucf_id='{$formid}' and emt_gfg_id='{$groupid}' and emt_flag_id is not null";

                    $data_flag = array(
                        'emt_flag_id' => null
                    );
                    Generic_form_elements::update_record($data_flag,$criteria_flag,$current_user);
                
                    DB::commit();

                    return $this->success($msg_arr,201,array());
                }
            } else {
                DB::rollback();
                return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
            }
        }
	} catch(\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}
}

public function getadd_groupelement(Request $request) {
    DB::beginTransaction();
    try {
        $output=array();
        $reviewflow=array();
        $data = $request->all();
        $formid=$data['formid'];
        $groupid=$data['groupid'];
        $referenceid=$data['referenceid'];
        $jnl_id=$data['jnl_id'];
        $validator = Validator::make($request->all(), [
            'formid'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }

        if($referenceid=='0') {
            $output['datagroup'] = array(
				'formid' => $data['formid'],
				'groupid' => $data['groupid'],
				'referenceid' => $this->encrypt_data($data['referenceid']));
        } else {
            $output['datagroup'] = $data;
        }
        $formid = $this->decrypt_data($data['formid']);
        //position ( add new element above (u), left to an element (l), right to an element (r)
		$output['position'] = $data['position'];
        $condition='emt_gucf_id='.$formid.' and emt_dynamic_status!="y" and gfg_dynamic_status="n"';
        $output['savedcontrols'] = Generic_form_elements::get_form_controls($condition);
        //Task #480 Viewable roles configuration for custom from elements
		$feedback_form = $this->is_feedback_form($formid);
        $output['upload_type'] = File_upload_type::get_all_records();
		$roles = array();
        if($feedback_form['from_flag'] == FALSE) {
			$condition = 'role_assigned_role != \'system\'';
			$roles_data = Roles::get_all_records('role_id,role_name,role_assigned_role',$condition,'role_name');

            if(!empty($roles_data)) {
                foreach($roles_data as $row) {
                    $roles[$row->role_id]=$row->role_name;
                }
            }
        }

        $generic_form_identifier = $this->identifier_appaly($feedback_form['gncf_form_type'],'textbox');
		$output['generic_form_identifier'] = $generic_form_identifier;
		$output['roles'] = $roles;
        $output['feedback_form'] = $feedback_form['from_flag'];
		$output['client_functionality'] = $this->current_client->functionality;
		$output['cd_code_help'] = customTrans('customform.cd_code_help');
        $output['decision_ctrl_present'] = FALSE;
		$gncf_form_type = $feedback_form['gncf_form_type'];
		$client_code = $this->current_client->clnt_client_code;
        $workflow_config = 'clients.'.$this->current_client->clnt_client_code.'.workflow_config.review_flow';
        $review_flow = Config::get($workflow_config);
        $stage_arr=array(); //$type = array();

		$type[] =$gncf_form_type;
		$order ="FIELD(gncf_form_type,'author_submission','transit','staff_check','pre_assessment','review','post_assessment','accept','reject','decision_revision','revision','copyright','license_check','payment','production','resubmission','copy_editing','type_setting','proof_reading','editorial_manage','publish')";
		$stage_type_array=$this->get_stages($review_flow,$type,array(),$gncf_form_type);
		$stage_type_str ="'" . implode ( "', '", $stage_type_array ) . "'";
        $criteria = "gncf_form_type IN ({$stage_type_str})  and gncf_jnl_id is NULL AND gncf_id !={$formid}";
        $this->current_user = $this->get_current_user_details();
		if(isset($this->current_user['roles']) && (!in_array('super_admin', $this->current_user['roles']) && !in_array('sudo', $this->current_user['roles'])) && isset($jnl_id)) {
			$criteria .= ' and gncf_jnl_id='.$jnl_id;
		}
         /*  Task #175 Bug 2 waiting for confirmation
        $criteria .= ' and gncf_id !='.$formid;
        */

        // Task #3563 Collecting Supporting Documents for Conference
        $output['formdetails'] = Generic_forms::get_single_record_with_bind_cond("gncf_metadata_status",array('gncf_id'=>$formid));

        $forms_array=Generic_forms::get_generic_forms('gncf_id,gncf_form_name',$criteria,NULL,NULL,$order);

        if (!empty($review_flow)) {
            // TASK #8978 Custom form settings view stage type up to production
            if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n') {
                foreach ($review_flow as $key => $val) {
                    if (isset($key) && isset($val['label']) && isset($val['stage_for']) && $val['stage_for'] == 'review' ) {
                        $tmp_name = $val['label'];
                        $reviewflow[$key] = $tmp_name;
                    }
                }
            }else {
                    foreach ($review_flow as $key => $val) {
                        if (isset($key) && isset($val['label']) && isset($val['stage_for']) && ($val['stage_for'] == 'review' || $val['stage_for'] == 'manageproduction')) {
                            $tmp_name = $val['label'];
                            $reviewflow[$key] = $tmp_name;
                        }
                    }
            }
        }
        $output['child_stages'] = $reviewflow;
        $output['form_stage_type'] = $feedback_form['gncf_form_type'];

        if($this->current_client->functionality->cfty_enable_decision_control == 'y') {
			$output['decision_ctrl_present'] = TRUE;
		}

        $generic_form_identifier_combobox = $this->identifier_appaly($feedback_form['gncf_form_type'],'combobox');
		$output['generic_form_identifier_combobox'] = $generic_form_identifier_combobox;
        $generic_form_identifier_textarea = $this->identifier_appaly($feedback_form['gncf_form_type'],'textarea');
		$output['generic_form_identifier_textarea'] = $generic_form_identifier_textarea;
        $generic_form_identifier_checkbox = $this->identifier_appaly($feedback_form['gncf_form_type'],'checkbox');
		$output['generic_form_identifier_checkbox'] = $generic_form_identifier_checkbox;
        $generic_form_identifier_radiobutton = $this->identifier_appaly($feedback_form['gncf_form_type'],'radiobutton');
		$output['generic_form_identifier_radiobutton'] = $generic_form_identifier_radiobutton;
        $generic_form_identifier_label = $this->identifier_appaly($feedback_form['gncf_form_type'],'label');
		$output['generic_form_identifier_label'] = $generic_form_identifier_label;
        $generic_form_identifier_file = $this->identifier_appaly($feedback_form['gncf_form_type'],'file');
		$output['generic_form_identifier_file'] = $generic_form_identifier_file;

        $criteria5=array('emt_element_type'=>'file','emt_gucf_id'=>$formid);
        $form_file_count = Generic_form_elements::get_single_record_with_bind_cond('count(emt_id) as cnt', $criteria5);
        $output['form_file_count']=$form_file_count;
         $sql= "SELECT emt_gucf_id,emt_flag_id,emt_id FROM `rvw_generic_form_elements` WHERE `emt_gucf_id`={$formid} AND `emt_flag_id` IS NOT NULL";
        $cur_empt_flg_count = Generic_form_elements::get_records_by_raw_query($sql);
        $distinctValues =[];
        $form_ids = Generic_flows::whereJsonContains('jwf_forms',$formid)
            ->pluck('jwf_forms')
            ->flatMap(function ($item) {
                $decoded = json_decode($item, true);
                return is_array($decoded) ? $decoded : [];
            })
            ->unique()
            ->values()
            ->toArray();
            if(empty($form_ids)) {
                $form_ids[] = $formid;
            }
            $valid_flags = Generic_form_elements::whereIn('emt_gucf_id', $form_ids)
            ->whereNotNull('emt_flag_id')
            ->where(DB::raw('JSON_LENGTH(emt_flag_id)'), '>', 0)
            ->pluck('emt_flag_id')
            ->map(function ($flagId) {
                return json_decode($flagId, true);
            })
            ->filter() // Filter out null/empty results from json_decode
            ->toArray();
            foreach ($valid_flags as $outerArray) {
                foreach ($outerArray as $innerArray) {
                    foreach ($innerArray as $key => $value) {
                        $distinctValues[$key] = $value; // Use keys to avoid duplicates
                    }
                }
            }
           
            $distinctArray = array_unique($distinctValues);
            $distinctValues = array_values($distinctArray );
        
        
foreach ($cur_empt_flg_count as $item) {
    $jsonArray = json_decode( $item->emt_flag_id, true);
    
    foreach ($jsonArray as $flag) {
        if(isset(array_values($flag)[0])){
        $emtFlagIds[] = array_values($flag)[0];
        }
}
}
        $output['used_flag_array']=isset($distinctArray)?$distinctValues :null;

        $output['populate_tables'] = $this->Utility('populate_tables');
		$output['forms_array']=$forms_array;
        return $this->success('success',200,$output);
		// DB::commit();
    }catch (\Exception $e) {
       // DB::rollback();
        return $this->failure('Failed', 500, $e);
    }

}




//Edit generic form group elements/
public function edit_group_element(Request $request) {
    try {
        $output=array();
        $reviewflow=array();
        $data = $request->all();
        $formid=$this->decrypt_data($data['formid']);
        $groupid=$this->decrypt_data($data['groupid']);
        $elementid=$this->decrypt_data($data['elementid']);
        $formtype=isset(($data['formtype']))?$data['formtype']:null;
        $jnl_code = $data['jnl_code'] ?? null;

        $validator = Validator::make($request->all(), [
            'formid'      => 'required',
            'groupid'      => 'required',
            'elementid'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }

        //Task #3563 Collecting Supporting Documents for Conference
        $output['formdetails'] = Generic_forms::get_single_record_with_bind_cond("gncf_metadata_status",array('gncf_id'=>$formid));
        $condition='emt_gucf_id='.$formid.' and emt_dynamic_status!="y" and gfg_dynamic_status="n" and emt_id <>'.$elementid;
        $output['savedcontrols'] = Generic_form_elements::get_form_controls($condition);

        $condition2='emt_gucf_id='.$formid.' and emt_gfg_id ='.$groupid.' and emt_id='.$elementid;
        // Task #8244 populate data task start
        // $output['editgroup'] = Generic_form_elements::get_single_record('emt_id,emt_gucf_id,emt_gfg_id,emt_unique_identifier,emt_element_type,emt_label,emt_alignment,emt_required,emt_max_char,emt_min_char,emt_column_type,emt_word_min,emt_word_max,  emt_error_msg,emt_place_holder,emt_file_min_cnt,emt_file_max_cnt,emt_file_types,emt_tinymce_required,emp_populate_from_table,  emt_options,emt_combo_multiple,emt_combo_custom,emt_note_text,emt_user_roles,emt_dependency_required,emt_depending_control,  emt_depending_value,emt_active,emt_order,right_emt_ids,div_start_emt_id,emt_cd_code,emt_dnd_value,emt_identifier_type,emt_attach_to_mail,emt_textarea_rows,emt_help_icon,emt_help_icon_text,emt_populate_data,emt_source_formid,emt_source_elementid,  emt_dynamic_status,emt_flag_id,emt_hideafterstage,emt_posted_by,emt_posted_date,emt_old_emt_id,emt_proxy_id,emt_operation',$condition2);
        $output['editgroup'] = Generic_form_elements::get_single_record('emt_id,emt_gucf_id,emt_gfg_id,emt_unique_identifier,emt_element_type,emt_label,emt_alignment,emt_required,emt_max_char,emt_min_char,emt_column_type,emt_word_min,emt_word_max,  emt_error_msg,emt_place_holder,emt_file_min_cnt,emt_file_max_cnt,emt_file_types,emt_tinymce_required,emp_populate_from_table,  emt_options,emt_combo_multiple,emt_combo_custom,emt_note_text,emt_user_roles,emt_dependency_required,emt_depending_control,  emt_depending_value,emt_active,emt_order,right_emt_ids,div_start_emt_id,emt_cd_code,emt_dnd_value,emt_identifier_type,emt_attach_to_mail,emt_textarea_rows,emt_help_icon,emt_help_icon_text,emt_populate_data,emt_source_formid,emt_source_elementid,  emt_dynamic_status,emt_flag_id,emt_hideafterstage,emt_posted_by,emt_posted_date,emt_old_emt_id,emt_proxy_id,emt_operation,emt_populate_data_pair',$condition2);
        if (isset($output['editgroup']->emt_populate_data_pair)&& $output['editgroup']->emt_populate_data_pair !=null) {
            $originalArray=$output['editgroup']->emt_populate_data_pair = json_decode($output['editgroup']->emt_populate_data_pair, true);
            foreach ($originalArray as $elementIds) {

                $newArray = [];

                foreach ($elementIds as $elementId =>$emt_id) {
                    // Fetch the label from the database.
                    $orgArray[$elementId]=[];
                    for($i=0;$i<count($emt_id);$i++) {
                    $element= DB::table('rvw_generic_form_elements')->where('emt_id', $emt_id[$i])->first();
                        $newArray[]  = [
                            'emt_id' => (int)$element->emt_id, // Ensure emt_id is an integer
                            'emt_label' => $element->emt_label,
                        ];

                    }
                    $orgArray[$elementId]=$newArray;
                }



            }
            $output['editgroup']->emt_populate_data_pair=[$orgArray];
        }
        /*
        Task #8244 populate data task end 
        */


        $output['flagDetails'] = $this->get_flag_details($request);
        $element_type = $output['editgroup']->emt_element_type;
        //Task #480 Viewable roles configuration for custom from elements
        $feedback_form = $this->is_feedback_form($formid);
        $gncf_form_type = $feedback_form['gncf_form_type'];
        $workflow_config = 'clients.'.$this->current_client->clnt_client_code.'.workflow_config.review_flow';
        $review_flow = Config::get($workflow_config);
        $stage_arr=array(); //$type = array();
        $type[] =$gncf_form_type;
		$order ="FIELD(gncf_form_type,'author_submission','transit','staff_check','pre_assessment','review','post_assessment','accept','reject','decision_revision','revision','copyright','license_check','payment','production','resubmission','copy_editing','type_setting','proof_reading','editorial_manage','publish')";
  		$stage_type_array=$this->get_stages($review_flow,$type,array(),$gncf_form_type);
		$stage_type_str ="'" . implode ( "', '", $stage_type_array ) . "'";
		$criteria = "gncf_form_type IN ({$stage_type_str}) AND gncf_id !={$formid}";
        
        // for testing
        // $criteria ="gncf_form_type IN ('post_assessment', 'staff_check', 'pre_assessment', 'revision', 'review', 'resubmission', 'author_submission', 'authors_declaration', 'decision_revision', 'decision_resubmit')";
        // TASK #8372 The created custom form failed to appear in the "Populate data from another form" dropdown.
        $jnl_id='';
        if(isset($jnl_code))
        {
        $criteria_jnl = [
            'jnl_journal_code' => $jnl_code
            
        ]; 
        $jrnl_data = Journals::get_single_record_with_bind_cond('jnl_id',$criteria_jnl );
        $jnl_id =$jrnl_data->jnl_id;
        }
        $this->current_user = $this->get_current_user_details();
		if((!in_array('super_admin', $this->current_user['roles']) && !in_array('sudo', $this->current_user['roles'])) && isset($jnl_id) && !empty($jnl_id)) {
			$criteria .= ' and (gncf_jnl_id is NULL OR gncf_jnl_id='.$jnl_id.')';
		} else {
            $criteria .= ' and gncf_jnl_id is NULL';
        }
        /*  Task #175 Bug 2 waiting for confirmation
        $criteria .= ' and gncf_id !='.$formid;
        */
// TASK #8372 The created custom form failed to appear in the "Populate data from another form" dropdown.
        $forms_array=Generic_forms::get_generic_forms('gncf_id,gncf_form_name',$criteria,NULL,NULL,$order);
        $output['forms_array']=$forms_array;
        $output['elm_view_roles']=array();
        $roles = array();

        if($feedback_form['from_flag'] == FALSE) {
        if(isset($output['editgroup']->emt_user_roles) && $output['editgroup']->emt_user_roles != '') {
            $output['elm_view_roles'] = explode(',', $output['editgroup']->emt_user_roles);
        }

        $condition3 = 'role_assigned_role != \'system\'';
        $roles_data = Roles::get_all_records('role_id,role_name,role_assigned_role',$condition3,'role_name');
            if(!empty($roles_data)) {
                foreach($roles_data as $row) {
                    $roles[$row->role_id]=$row->role_name;
                }
            }
        }
        $output['roles'] = $roles;

        if (($element_type == "radiobutton" || $element_type == "combobox") && $feedback_form['from_flag'] == TRUE)
        $output['unique_identifier_value'] = 'USER_DATA_PROTECTION';

        $output['upload_type'] = File_upload_type::get_all_records();
        $output['client_functionality'] = $this->current_client->functionality;
        $output['cd_code_help'] = customTrans('customform.cd_code_help');
        $output['feedback_form'] = $feedback_form['from_flag'];
        $value = $output['editgroup']->emt_element_type;


        $output['decision_ctrl_present'] = FALSE;
        if($this->current_client->functionality->cfty_enable_decision_control == 'y') {
            $output['decision_ctrl_present'] = TRUE;
        } // console.log(listoption);
        // return false;
        if($value == 'combobox' || $value == 'radiobutton') {
            if (!empty($review_flow)) {
// TASK #8978 Custom form settings view stage type up to production
                if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'n') {
                    foreach ($review_flow as $key => $val) {
                        if (isset($key) && isset($val['label']) && isset($val['stage_for']) && $val['stage_for'] == 'review' ) {
                            $tmp_name = $val['label'];
                            $reviewflow[$key] = $tmp_name;
                        }
                    }
                }else {
                    foreach ($review_flow as $key => $val) {
                        if (isset($key) && isset($val['label']) && isset($val['stage_for']) && ($val['stage_for'] == 'review' || $val['stage_for'] == 'manageproduction')) {
                            $tmp_name = $val['label'];
                            $reviewflow[$key] = $tmp_name;
                        }
                    }
                }

            }
            $output['child_stages'] = $reviewflow;
            $output['form_stage_type'] = $feedback_form['gncf_form_type'];
            $newArray=[];
            $sql= "SELECT emt_gucf_id,emt_flag_id,emt_id FROM `rvw_generic_form_elements` WHERE `emt_gucf_id`={$formid} AND `emt_id` != {$elementid} AND  `emt_flag_id` IS NOT NULL";
            $cur_empt_flg_count = Generic_form_elements::get_records_by_raw_query($sql);
                if(!empty($cur_empt_flg_count)){
                    foreach ($cur_empt_flg_count as $item) {
                        $jsonArray = json_decode( $item->emt_flag_id, true);
                        foreach ($jsonArray as $flag) {
                            if(isset(array_values($flag)[0])){
                            $newArray = array_values($flag)[0];
                            }
                        }
                        $output['used_flag_array']=$newArray;
                    }
            }
        }

        $generic_form_identifier = $this->identifier_appaly($feedback_form['gncf_form_type'],$value);
        $output['generic_form_identifier'] = $generic_form_identifier;
        $output['populate_tables'] = $this->Utility('populate_tables');
        return $this->success('Success',201,$output);
    }catch (\Exception $e) {
       // DB::rollback();
        return $this->failure('Failed', 500, $e);
    }

}

public function get_form_elements_data(Request $request) {
    try {
        $output=array();
        $form_data = $request->all();
        $form_id=$form_data['form_eleid'];
        $select=$form_data['select'];
        $field_element_type=$form_data['field_element_type'];

        $validator = Validator::make($request->all(), [
            'form_eleid'      => 'required',
            //'field_element_type'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }

        $workflow_config = 'clients.'.$this->current_client->clnt_client_code.'.workflow_config.customdata';
        $customdata = Config::get($workflow_config);
        $condition ='emt_gucf_id='.$form_id .' and emt_dynamic_status!="y"';
        if(isset($customdata[$field_element_type])) {
            $customelements= "'".implode("','",$customdata[$field_element_type])."'";
        } else {
            $customelements= "'".implode("','",$customdata["textarea"])."'";
        }
        if($field_element_type == "te") {
            $condition.=' and emt_element_type in ('.$customelements.')';
        } else {
            $condition.=' and emt_element_type in ('.$customelements.')';
        }
        // Task #8244 populate data task start
        $result = Generic_form_elements::get_all_records('emt_id,emt_label,emt_dynamic_status',$condition);
        // $result = Generic_form_elements::get_all_records('emt_id,emt_label,emt_populate_data_pair',$condition);
        // Task #8244 populate data task end
        $output['option_html']=$result;
        return $this->success('Success',201,$output);
    }catch (\Exception $e) {
       // DB::rollback();
        return $this->failure('Failed', 500, $e);
    }
}

public function is_feedback_form($form_id) {
    $return_arr = array(
        'from_flag' => FALSE
    );
    $condition='gncf_id='.$form_id;
	$form_data = Generic_forms::get_single_record('gncf_form_type',$condition);
    $return_arr['gncf_form_type'] = $form_data->gncf_form_type;
	if($form_data->gncf_form_type == 'feedback_form') {
        $return_arr['from_flag'] = TRUE;
    }
    return $return_arr;
}

public function identifier_appaly($form_type,$emt_type) {
    $client_code = $this->current_client->clnt_client_code;
    $generic_config = 'clients.'.$this->current_client->clnt_client_code.'.generic_form_identifiers.identifier';
    $generic_form_identifier = Config::get($generic_config);

    $user_feedback_config = 'clients.'.$this->current_client->clnt_client_code.'.generic_form_identifiers.user_feedback_identifier';
    $user_feedback = Config::get($user_feedback_config);
	//Task 647 Remove static form from TrAction stages
    if(count($generic_form_identifier) > 0) {
        foreach ($generic_form_identifier as $key => $gen_identifier) {
            $unset_key_flag = TRUE;
            $apply_stages = $gen_identifier['apply_stages'];
            $elements = $gen_identifier['emelemt'];
            if(in_array($emt_type,$elements) == TRUE || in_array('all',$elements) == TRUE) {
                if(in_array($form_type,$apply_stages) == TRUE || in_array('all',$apply_stages) == TRUE) {
                    $unset_key_flag = FALSE;
                }
                //if data protection off then that identifiers not use
                if(isset($user_feedback) && $this->current_client->functionality->cfty_enable_data_protection == 'n' && in_array($key,$user_feedback) == TRUE) {
						$unset_key_flag = TRUE;
                }
            }
            if($unset_key_flag == TRUE)
                unset($generic_form_identifier[$key]);
        }
    }
    return $generic_form_identifier;
}

public function get_stages($review_flow,$gncf_form_type,$stage_array,$intial_type) {
    $stage_arr=array();
    if(!empty($gncf_form_type)) {
        foreach ($review_flow as $key =>$chd) {
            foreach($gncf_form_type as $gncf_fm) {
                if(in_array($gncf_fm, $chd['child_stages'])) {
                    if(!in_array($key,$stage_arr) && !in_array($key,$stage_array)) {
                      $stage_arr[]=$key;
                    }
                }
            }
        }
    } else {
        return $stage_array;
    }
    if(!empty($stage_arr)) {
        $result = array_merge($stage_array,$stage_arr);
        $stage_array=array_unique($result);
        return $this->get_stages($review_flow,$stage_arr,$stage_array,$intial_type);
    } else {
        return $stage_array;
    }
}

public function update_new_unique_identifier($old_element_details, $new_unique_identifier) {
    $this->current_user=$this->get_current_user_details();
		$journals = Journals::get_all_records('jnl_journal_code');
		$all_tables = Journals::get_all_tables_in_db(" AND table_name LIKE '%rvw_article_gnf_form_data%' ");
		$all_tables = array_column(json_decode(json_encode($all_tables),true), 'TABLE_NAME');
		foreach ($journals as $jnl) {
            $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
            $tab_name = $article_generic_form_data_table.'_'.$jnl->jnl_journal_code;
			if(in_array($tab_name,$all_tables)) {
                /*---start---Bug#3116 Checking Unique identifier is saved/updated correctly in old and new records of rvw_article_gnf_form_data_{{jnl_code}}----*/
                $unique_identifier_condi    =   "gdata_atfemt_id = ".$old_element_details->emt_id."";
                if(is_null($new_unique_identifier) == true)  {
                    $unique_identifier_set  =   " gdata_unique_identifier = NULL";
                }else {
                    $unique_identifier_set  =   " gdata_unique_identifier='".$new_unique_identifier."'";
                }
                $sql = 'UPDATE '.$tab_name.' SET '.$unique_identifier_set.' WHERE '.$unique_identifier_condi.'';
                /*----end----*/
				Article_generic_form_data::execute_query($sql);
			}

		}
		$old_identifier_tag = '##' . $old_element_details->emt_unique_identifier . '##';
		$old_identifier_stage_tag = '##' . $old_element_details->emt_unique_identifier . '{';
		$new_identifier_tag = '##' . $new_unique_identifier . '##';
		$new_identifier_stage_tag = '##' . $new_unique_identifier . '{';
		$stage_email_templates = Stage_email_templates::get_all_records('*', "stage_etmp_subject LIKE '%" . $old_identifier_tag . "%' OR stage_etmp_content LIKE '%" . $old_identifier_tag . "%' OR stage_etmp_subject LIKE '%" . $old_identifier_stage_tag . "%' OR stage_etmp_content LIKE '%" . $old_identifier_stage_tag . "%'");

		if ($stage_email_templates != NULL) {
			foreach ($stage_email_templates as $stage_email_template) {
				$subject = $stage_email_template->stage_etmp_subject;
				$body = $stage_email_template->stage_etmp_content;
				$subject = str_replace($old_identifier_tag, $new_identifier_tag, $subject);
				$body = str_replace($old_identifier_tag, $new_identifier_tag, $body);
				$subject = str_replace($old_identifier_stage_tag, $new_identifier_stage_tag, $subject);
				$body = str_replace($old_identifier_stage_tag, $new_identifier_stage_tag, $body);
                $criteria='stage_etmp_id ='.$stage_email_template->stage_etmp_id;
				Stage_email_templates::update_record(array(
					'stage_etmp_subject' => $subject,
					'stage_etmp_content' => $body),$criteria,$this->current_user);
			}
		}
	}
    //Task #480 Viewable roles configuration for custom from elements
public function get_dependent_viewable_roles($element_id = NULL) {
    $ajax = FALSE;
    $return_arr = NULL;
    if($element_id == NULL) {
        die('Error');
    }

    if($element_id != '') {
        $condition='emt_id='.$element_id;
        $result = Generic_form_elements::get_single_record('emt_user_roles',$condition);
		if(!empty($result->emt_user_roles)) {
            if($ajax == FALSE) {
                $return_arr = $result->emt_user_roles;
            } else {
                $return_arr['status'] = 'success';
                $role_arr = array();
                $roles_arr = explode(',', $result->emt_user_roles);
                foreach ($roles_arr as $role) {
                    $role_arr[] = $this->encrypt_data($role);
                }
                $return_arr['roles'] = $role_arr;
            }
        }
    }
    if($ajax == FALSE)
        return $return_arr;
    else
    echo json_encode($return_arr);
}

public function update_new_emt_label($old_element_details, $new_label) {
    $journals   =   Journals::get_all_records('jnl_journal_code');
    $all_tables =   Journals::get_all_tables_in_db(" AND table_name LIKE '%rvw_article_gnf_form_data%' ");
    $all_tables =   array_column(json_decode(json_encode($all_tables),true), 'TABLE_NAME');
    foreach ($journals as $jnl) {
        $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
        $tab_name = $article_generic_form_data_table.'_'.$jnl->jnl_journal_code;
        if(in_array($tab_name,$all_tables)) {
            if(in_array($tab_name,$all_tables)) {
                $label_condi    =   " gdata_atfemt_id = ".$old_element_details->emt_id."";
                $label_set      =   " gdata_label='".$new_label."'";
                $sql            =   'UPDATE '.$tab_name.' SET '.$label_set.' WHERE '.$label_condi.'';
                Article_generic_form_data::execute_query($sql);
            }
        }
    }
}



    public function deleteform_element(Request $request) {
        DB::beginTransaction();
        try {

            $this->current_user = $this->get_current_user_details();
            $form_data = $request->all();
            $formid=$this->decrypt_data($form_data['formid']);
            $groupid=$this->decrypt_data($form_data['groupid']);
            $elementid=$this->decrypt_data($form_data['elementid']);
            $is_proceeding=$this->check_client_proceeding();
            $metadata_status='';
            $msgKey ='';
            $elementdelete='n';

            $validator = Validator::make($request->all(), [
                'formid'      => 'required',
                'groupid'      => 'required',
                'elementid'      => 'required'
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());
            }


            //if right_emt_ids is not null, and count>1, then update this value to the next element in order
            //and update update the div_start_emt_id = id of next element in order , where div_start_emt_id = $element_id;
            //if count ==1 , update the div_start_emt_id = NULL , where div_start_emt_id = $elementid;
            // Task #3393 Metadata custom form fields should be able to delete
            $record = Generic_form_elements::get_single_record_with_bind_cond('emt_unique_identifier,div_start_emt_id,right_emt_ids',array(
                'emt_id' => $elementid));
                
            $metadatacheck = Generic_forms::get_single_record_with_bind_cond('gncf_metadata_status',array('gncf_id' => $formid));
            if(!empty($metadatacheck)){
                $metadata_status=$metadatacheck->gncf_metadata_status;
                if($is_proceeding == true && $metadata_status == 'm' && empty($record->emt_unique_identifier)) {
                    $elementdelete = 'y';
                }
            }
            if($elementdelete=='n') {
                $found=$this->element_exist_check($formid,$elementid);
                if($found==1){
                    return  $this->warning(customTrans('customform.gncform-elmt-del-err'),200,'','warning');
                }
            }

            if ($record->right_emt_ids != NULL ) {
                $right_emt_ids = json_decode($record->right_emt_ids);
                $update_data['div_start_emt_id'] = NULL;
                $criteria = ' div_start_emt_id="'.$elementid.'"';
                $next_elm_in_row = Generic_form_elements::get_all_records('*', $criteria, 'emt_order', 1);
                $next_elm_in_row = $next_elm_in_row[0];
                $div_start_emt_id = $next_elm_in_row->emt_id;
                $key = array_search($next_elm_in_row->emt_id, $right_emt_ids);
                unset($right_emt_ids[$key]);
                if (count($right_emt_ids) > 1) {
                    $update_data['right_emt_ids'] = json_encode(array_values($right_emt_ids));
                    $cond='emt_id='.$next_elm_in_row->emt_id;
                    Generic_form_elements::update_record($update_data,$cond, $this->current_user);
                    unset($update_data['right_emt_ids']);
                    $update_data['div_start_emt_id'] = $next_elm_in_row->emt_id;
                }
            } else if ($record->div_start_emt_id != NULL ) {
                $criteria='emt_id='.$record->div_start_emt_id;
                $start_elm_record = Generic_form_elements::get_single_record('emt_id, right_emt_ids', $criteria);
                $update_data['right_emt_ids'] = NULL;
                $right_emt_ids = json_decode($start_elm_record->right_emt_ids);
                if (count($right_emt_ids) > 0) {
                    $key = array_search($elementid, $right_emt_ids);
                    unset($right_emt_ids[$key]);
                    $update_data['right_emt_ids'] = json_encode(array_values($right_emt_ids));
                }
                $div_start_emt_id = $start_elm_record->emt_id;
            }
            //attach_to_mail
            $div_ids = array();
            if (isset($div_start_emt_id)) {
                $right_emt_ids[] = $div_start_emt_id;
                Generic_form_elements::update_record($update_data, $criteria, $this->current_user);
                //id of div elements in which the all other elements placed horizontally
                foreach ($right_emt_ids as $id) {
                    $div_ids[$groupid . '_group_element_' . $id] = floor(12 / count($right_emt_ids));
                }
            }

            $criteria = array(
                'emt_gucf_id' => $formid,
                'emt_depending_control' => $elementid
            );
            
            $dependancycheck = Generic_form_elements::get_single_record_with_bind_cond('emt_note_text,emt_id',$criteria);
            if(!empty($dependancycheck)){
                return  $this->warning('Cannot delete: This element is used as a dependent control.',200,'','warning');
            }



            $input = 'emt_gucf_id="'.$formid.'" and emt_gfg_id="'.$groupid.'" and emt_id= '.$elementid;
            $result = Generic_form_elements::delete_records($input, '', $this->current_user);
            DB::commit();
            if(isset($metadata_status) && $metadata_status === 'm') {
                $msgKey = customTrans('customform.gncform_metaele_del');
            } else if(isset($metadata_status) && $metadata_status === 's') {
                $msgKey = customTrans('customform.gncform_supportingele_del');
            } else {
                $msgKey = customTrans('customform.gncform_ele_del');
            } 
        
        return $this->success($msgKey, 201, array());
        }catch(\Exception $e) {
           DB::rollback();
            return  $this->failure('Failed',500,$e);
        }
    }

    //Task #480 Viewable roles configuration for custom from elements
	public function update_elmt_viewable_role_on_gdata_tables($id,$view_role_str = NULL) {
		$database_name = DB::getDatabaseName();
		$select = 'table_name';
		$condition = ' AND (table_name LIKE \'rvw_article_gnf_form_data%\')';
		$sql = 'SELECT '.$select.' FROM information_schema.TABLES WHERE table_schema = "'.$database_name.'" '.$condition;
		$results = Article_generic_form_data::get_records_by_raw_query($sql);
		if(count($results) > 0) {
			if(is_array($id)) {
				$where_cnd = '  gdata_atfemt_id IN ('.implode(',', $id).')';
			} else {
				$where_cnd = '  gdata_atfemt_id ='.$id;
			}

			if($view_role_str != NULL)
				$update_roles = 'gdata_user_roles = \''.$view_role_str.'\'';
			else
				$update_roles = 'gdata_user_roles = NULL';

			foreach ($results as $result) {
				$update_sql = 'UPDATE '.$result->TABLE_NAME.' SET '.$update_roles.'  WHERE '.$where_cnd;
				Article_generic_form_data::execute_query($update_sql);
			}

		}
		return;
	}

    public function iterative_update_element_view_roles($id,$view_role_str,$update_condition = array()) {
        $this->current_user=$this->get_current_user_details();
        $where = 'emt_dependency_required = 1 ';
		if(is_array($id)) {
			$where .= ' AND  emt_depending_control IN ('.implode(',', $id).')';
		} else {
			$where .= ' AND emt_depending_control ='.$id;
		}
		$result = Generic_form_elements::get_single_record('emt_id,emt_user_roles,group_concat(emt_id) as emt_depnt_cntl',$where);

		if($result==TRUE  && $result->emt_depnt_cntl != NULL) {
			$temp = explode(',', $result->emt_depnt_cntl);
			$update_condition = array_merge($update_condition,$temp);
			$this->iterative_update_element_view_roles($temp,$view_role_str,$update_condition);
		} else {
			if(count($update_condition) > 0) {
				$update_arr = array(
					'emt_user_roles' => $view_role_str
				);
				$update_cnd = ' emt_id IN ('.implode(',', $update_condition).')';

				Generic_form_elements::update_record($update_arr,$update_cnd,$this->current_user);

				//update gdata tables
				$this->update_elmt_viewable_role_on_gdata_tables($update_condition,$view_role_str);
				return;
			}
			else
				return;
		}
	}
    public function getFlagvalue($value,$element_id)
    {
        try{
            $array = json_decode($value, true);
            foreach ($array as $item) {
                if (array_key_exists($element_id, $item))
                {
                    return $item[$element_id];
                }
   
            }
            return null;
            }
            catch(\Exception $e) {
                DB::rollback();
                return  $this->failure('Failed',500,$e);
            }

    }
     public function element_exist_check($formid=null,$elementid=null){
          $found=false;
          $criteria = ($elementid === null) ?  array('gdata_atf_id' => $formid) : array('gdata_atf_id' => $formid,'gdata_atfemt_id'=>$elementid);
          $jnl_details = Journals::get_all_records('jnl_id,jnl_journal_code');
                    if (!empty($jnl_details)) {
                        foreach ($jnl_details as $jn) {
                            $jnlcode=$jn->jnl_journal_code;
                            $formatted_journal_code='_'.$jnlcode;
                            $table_name = 'rvw_article_gnf_form_data_'.$jnlcode;
            				if (Schema::hasTable($table_name)) {
                                $record_exist = Article_generic_form_data::get_single_record_with_bind_cond("COUNT(gdata_id) AS count",$criteria,'',array(),'',$formatted_journal_code);
                                if ($record_exist->count > 0) {
                                    $found=true;
                                    break;
                                }
                            }
                        }
                    }
        return $found;
                   
    }

    public function option_value_validate($value) {
        $field='Value & Option';
		$lines = explode("\n", $value);
		$val = array();
		$succ = array();
        $result=array();
		for ($i = 0; $i < count($lines); $i++) {
			$lines[$i] = trim($lines[$i]);
			if ($lines[$i] != '') {
				//$lines[$i] = preg_replace('/\s+/', '_', $lines[$i]);
				if (strpos($lines[$i], ';') === false) {
					if (preg_match('/\s/', $lines[$i]) === 1) {
                        $result['success']=false;
                        $result['msg']='Value should not have white spaces';
						return $result;
					} else {
						array_push($val, $lines[$i]);
					}
				} else {
					$count = substr_count($lines[$i], ';');
					if ($count > 1) {
                        $result['success']=false;
                        $result['msg']='The '.$field.' should not contain more than one semicolon';
						return $result;
					} else {
						if (substr($lines[$i], 0, strpos($lines[$i], ';')) != '' && substr($lines[$i], strpos($lines[$i], ";") + 1)) {
							if (preg_match('/\s/', substr($lines[$i], 0, strpos($lines[$i], ';'))) === 1) {
                                $result['success']=false;
                                $result['msg']='value should not have white spaces';
								return $result;
							} else {
								array_push($succ, $lines[$i]);
							}
						}
					}
				}
			} else {
                $result['success']=false;
                $result['msg']='The '.$field.' should not have blank line';
				return $result;
			}
		}

		if (count($val) === count($lines)) {
            $result['success']=true;
            $result['msg']='success';
			return $result;
		} elseif (count($succ) === count($lines)) {
            $result['success']=true;
            $result['msg']='success';
			return $result;
		} else {
            $result['success']=false;
            $result['msg']='The '.$field.' format is wrong';
			return $result;
		}
	}

    public function save_form_details(Request $request)	{ // article submission save
        try {


            $validator = Validator::make($request->all(), [
                'jnl_code'      => 'required',
                'form_id'      => 'required',
                'hdn_current_status_id'      => 'required',

            ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }

        $form_data = $request->all();
        $formid = $this->decrypt_data($form_data['form_id']);
		$articleid = $this->decrypt_data($form_data['articleid']);
	    $current_status_id = $this->decrypt_data($form_data['hdn_current_status_id']);
        $journal_code = $form_data['jnl_code'];
        $jnl_id = $this->decrypt_data($form_data['jnl_id']);
        $chkstage_type = $form_data['stage_type'];
        //3313 edit completed forms
        $editcmtfrm = FALSE;
        $EditfrmCondition = '';
        $EditEmtCondition = '';
        $viewemt_ids = '';
        if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y')
        {
            if(isset($form_data['Viewelements']))
            {
                $editcmtfrm=$form_data['editcmtfrm'];
                $viewemt_ids=$this->decrypt_data($form_data['Viewelements']);
                if($viewemt_ids != '' && $editcmtfrm == TRUE)
                {
                    $EditfrmCondition = ' AND gdata_atfemt_id IN ('.$viewemt_ids.')';
                    $EditEmtCondition = ' AND (emt_id IN ('.$viewemt_ids.') OR (emt_depending_control IN ('.$viewemt_ids.')))';
                }
            }
        }
        DB::beginTransaction();
        if($chkstage_type=='author_submission') {
            $current_status_id=Article_flow::check_articlesubmission($articleid)->aflw_id;
        }
        $res=array();
        $formelmtdata=array();
        $formelmtdatanew=array();
        $formatted_journal_code = '_'.$journal_code;
        $this->current_user = $this->get_current_user_details();
        $author_response_edit = FALSE;
        if (isset($form_data['frm_author_respone_edit_'.$formid]) && ($form_data['frm_author_respone_edit_'.$formid]) == 'y' && $this->current_client->functionality->cfty_edit_author_response_form == 'y') {
            $author_response_edit = TRUE;
            $current_status_id = $form_data['frm_flw_id_'.$formid];
        }

        $file_gdata_id = [];
        $get_article_data = Articles::get_article_data($articleid);
        $condition='aflw_id=?';                     //TASK #7017
        $stage_type_dtls = Article_flow::get_stage_details($condition,'aflw_stage_repeat_count',wherearr:[$current_status_id]);              //TASK #7017
        $stage_repeat_count=isset($stage_type_dtls) && isset($stage_type_dtls->aflw_stage_repeat_count)?$stage_type_dtls->aflw_stage_repeat_count:0;
   


    $array=array(
        'formid'=>$formid,
        'form_data'=>$form_data,
        'articleid'=>$articleid,
        'current_status_id'=>$current_status_id,
        'viewemt_ids'=>$viewemt_ids,
        'stage_repeat_count'=>$stage_repeat_count,
        'formatted_journal_code'=>$formatted_journal_code,
        'EditEmtCondition'=>$EditEmtCondition,
        'file_gdata_id'=>$file_gdata_id,
        'current_user'=>$this->current_user
    );

    $res=$this->setSavecustomformElementreorder($array);
    if(!empty($res)) {
        $formelmtdata=$res['formelmtdata'];
        $file_gdata_id=$res['file_gdata_id'];
    }
   

    $select = 'jwf_stage_type, jwf_stage_name, aflw_status,aflw_skip_assignment,aflw_art_id,jwf_role_id,aflw_due_date';
    $condition='aflw_id=?';        //TASK #7017
    $article_status = Article_flow::get_generic_flow($select, $condition,bind_data:[$current_status_id]);
    if($article_status->isEmpty()) {
        $res['journal_status']=false;
        (!empty($journal_code)) && $res['journal_status']=true;
        $res['status']='stage_failed';
        $res['msg']=customTrans('customform.article_stage_not_exist');
        return  $this->warning('Warnings',200,$res,'warning');
    }

    $article_status = $article_status[0];

    /* Start --- if article status is in transit stage restric users( except users ) from submiting generic form */
    if ($get_article_data->art_status == 't' && $article_status->jwf_stage_type != 'transit' && $get_article_data->art_transfer_status == 'n') {
        $res['status']='failed';
        $res['msg']=customTrans('customform.article_transit_stage_warning');
        return  $this->warning('Warnings',200,$res,'warning');
    }
    /* End --- if article status is in transit stage restric users( except users ) from submiting generic form */

    /*Feature #2548 Author stage deadline passed so that they cannot access their paper */
    if(isset($this->current_client->functionality->cfty_restrict_revision_on_duedate_expired)&& $this->current_client->functionality->cfty_restrict_revision_on_duedate_expired == 'y') {
    if(($article_status->jwf_stage_type == 'revision' ||  $article_status->jwf_stage_type== 'resubmission') && $author_response_edit == FALSE && ($this->current_client->modules->mdl_review_for_doc == 'n')) {
    if(isset($article_status->aflw_due_date)) {
        $date_format = $this->current_client->settings->cs_date_format;
        if (!empty($this->jnl_data->jset_date_format)) {
            $date_format = $this->jnl_data->jset_date_format;
        }
        $due_date=date_create($article_status->aflw_due_date);
        $current_date = date_create(date('Y-m-d'));
        if($current_date>$due_date) {
            $res['status']='failed';
            $res['msg']=customTrans('customform.author_due_date_expired');
            return  $this->warning('Warnings',200,$res,'warning');
        }
    }}}
    /* End */

    // custom form validation if form data is get
    $return_data = array();
    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
    $review_flow  = Config::get($workflow_config);
	$usr_roles =  FALSE;
    //$wherecondition='usrj_role_id='.$article_status->jwf_role_id.' and usrj_usr_id='.$this->current_user['user_id'].' and usrj_jnl_id='.$jnl_id.' and usrj_role_retired="'.$n.'" and usrj_artp_id=NULL ' ;
    $wherecondition = [
        'usrj_role_id' => $article_status->jwf_role_id,
        'usrj_usr_id' => $this->current_user['user_id'],
        'usrj_jnl_id' => $jnl_id,
        'usrj_role_retired' => 'n',
        'usrj_artp_id' => NULL
    ];             //TASK #7017
    //$chek_retire = User_to_journals::get_single_record('count(*) as cnt',$wherecondition);dd($chek_retire);
    $chek_retire = User_to_journals::get_single_record_with_bind_cond('count(usrj_role_id) as cnt',$wherecondition);
    if(isset($chek_retire->cnt) && $chek_retire->cnt > 0) {
        $usr_roles = array($article_status->jwf_role_id);
    }

    /* Modified Bug #1378 - RVW1276 - Form validation */
    $validated_assignment_forms = (($article_status->aflw_skip_assignment == 'y') || ($review_flow[$article_status->jwf_stage_type]['assignment_tabs'] == FALSE) || $usr_roles == FALSE) ? TRUE : $this->validate_assignment_forms($get_article_data->artp_id, $article_status->aflw_art_id,$usr_roles,null,$journal_code);

    $return_data = array(
        'status' => 'success',
        'forms_validated' => 'false');
        $criteria = "aflw_id=?";
		//$stage_type = Article_flow::get_stage_details($criteria,'jwf_stage_type,aflw_stage_repeat_count');
        $stage_type = Article_flow::get_stage_details($criteria,'jwf_stage_type,aflw_stage_repeat_count',wherearr:[$current_status_id]);          //TASK #7017
		$article_submission = false;
		if ($stage_type->jwf_stage_type == 'author_submission') {
			$article_submission = true;
		}
		if (is_array($form_data)) {
			//$validdata = $this->custom_form_validation($formid, $form_data, $article_submission,$current_status_id);
            //Production Management validation required after discussion with vimal
            $validdata='success';
		} else {// in case of no form data
			// check if generic form contains any required fields
            $criteria = "emt_gucf_id=? and emt_required=? ".$EditEmtCondition;
			//$elementdata = Generic_form_elements::get_single_record('COUNT(emt_id) AS required_elms',$criteria);
            $elementdata = Generic_form_elements::get_single_record('COUNT(emt_id) AS required_elms',$criteria,binding_arr:[$formid,1]);           //TASK #7017
			// return error message in case of required fileds else set flag to denote validation success
			$validdata = 'success';
			if ($elementdata && $elementdata->required_elms > 0) {
                $res['status']='failed';
                $res['msg']=customTrans('customform.not_valid_form');
                return  $this->warning('Warnings',200,$res,'warning');
			}
		}
		$change_status=FALSE;
		//If validation successful means saving data
		$manage_depend_file_upload = array();

		if ($validdata == 'success') {
            $formEditH_id = 0;
            if($editcmtfrm == true)
            {
                $Form_edithistory_table = new \App\Models\Form_edithistory();
                $formEdit_data = array(
                    'feh_art_id' => $articleid,
                    'feh_aflw_id'=> $current_status_id,
                    'feh_gncf_id'=> $formid,
                );

                $formEditH_id = $Form_edithistory_table::insert_record($formEdit_data, $this->current_user);
            }
			$i = 1;
			$journal_code = $get_article_data->jnl_journal_code;
            $formatted_journal_code = '_' . $journal_code;
            /* start -- clear genereic form elements */
            $array=array(
                'articleid'=>$articleid,
                'formid'=>$formid,
                'current_status_id'=>$current_status_id,
                'EditfrmCondition'=>$EditfrmCondition,
                'stage_repeat_count'=>$stage_type->aflw_stage_repeat_count,
                'filepath'=>$get_article_data->art_article_upload_path,
                'formatted_journal_code'=>$formatted_journal_code,
                'file_gdata_id'=>$file_gdata_id,
                'current_user'=>$this->current_user
            );
        
            $res=$this->setSavecustomformCleargenereicformelements($array);

			/* end -- clear genereic form elements */

            if (isset($form_data['label_only_element']) && $form_data['label_only_element'] != null) {
				$insertid = $this->save_label_element($articleid, $formid, $current_status_id, $form_data, $stage_type, $formatted_journal_code,$viewemt_ids);
			}




            $i = 1;

            $array=array(
                'formelmtdata'=>$formelmtdata,
                'formatted_journal_code'=>$formatted_journal_code,
                'articleid'=>$articleid,
                'formid'=>$formid,
                'formEditH_id'=>$formEditH_id,
                'current_status_id'=>$current_status_id,
                'EditfrmCondition'=>$EditfrmCondition,
                'stage_repeat_count'=>$stage_type->aflw_stage_repeat_count,
                'jnl_id'=>$jnl_id,
                'filepath'=>$get_article_data->art_article_upload_path,
                'change_status'=>$change_status,
                'manage_upload_file_depend'=>$manage_depend_file_upload,
                'current_user'=>$this->current_user
            );

            $res=$this->setSavecustomformcommon($array);

            if(!empty($res)) {
                $change_status=$res['change_status'];
                $manage_depend_file_upload=$res['manage_depend_file_upload'];
                $insertid=$res['insertid'];
                $existdata=$res['existdata'];
            }

			

            if(isset($form_data['publon_data'])) {

				$pub_user_id=$this->current_user['user_id'];
				$publon_data=array(
					'pub_art_id'=>$articleid,
					'pub_jnl_id'=>$jnl_id,
					'pub_usr_id'=>$pub_user_id,
					'pub_status'=>$form_data['publon_data']
				);
				//$criteria = "pub_usr_id=$pub_user_id and pub_art_id = $articleid";
                $criteria = [
                    'pub_usr_id' => $pub_user_id,
                    'pub_art_id' => $articleid
                ];          //TASK #7017
				//$publons_records = Article_publons::get_single_record('*', $criteria);
                $publons_records = Article_publons::get_single_record_with_bind_cond('*', $criteria);

				if(sizeof($publons_records)>0) {
					if($publons_records->pub_status == 'n') {
                        $condition = "pub_id=$publons_records->pub_id";
						Article_publons::delete_records($condition,'',$this->current_user);
						Article_publons::insert_record($publon_data, $this->current_user);
					}
				} else {
					Article_publons::insert_record($publon_data, $this->current_user);
				}
			}
            //Task - 326 JPR-454 FigShare API-part2
            //figshare Integration
			if(isset($form_data['figshare_data'])) {
				$fig_user_id=$this->current_user['user_id'];
				$figshare_data=array(
					'fig_art_id'    => $articleid,
					'fig_jnl_id'    => $jnl_id,
					'fig_aflw_id'   => $current_status_id,
					'fig_usr_id'    => $fig_user_id,
					'fig_status'    => $form_data['figshare_data']
				);
				//$criteria = "fig_usr_id=$fig_user_id and fig_art_id = $articleid";
				$criteria = [
                    'fig_usr_id' => $fig_user_id,
                    'fig_art_id'    => $articleid,
                ];          //TASK #7017
                //$figshare_records = Article_figshare::get_single_record('fig_id,fig_status', $criteria);
                $figshare_records = Article_figshare::get_single_record_with_bind_cond('fig_id,fig_status', $criteria);
				if(sizeof($figshare_records)>0) {
                    Article_figshare::update_record($figshare_data, $criteria,$this->current_user);
				} else {
                    Article_figshare::insert_record($figshare_data, $this->current_user);
                }
			}
            $forms_validated=$this->validate_stage_forms($current_status_id,$jnl_id,$journal_code,array());
			//Article_generic_form_data::trans_complete();

			if (isset($insertid) && $insertid != '') {
				$output = array(
                    'status' => 'success',
					'forms_validated' => $forms_validated,
                    "article_type_code"=>$get_article_data->artp_abbr_article_type
				);

				if (($validated_assignment_forms != TRUE)) {
					$output = $return_data;
				}
                $output['art_status']=$get_article_data->art_status;
				$output['manage_upload_file_depend'] = $manage_depend_file_upload;
				$output['change_status'] = $change_status;
				if ($stage_type->jwf_stage_type == 'author_submission') {
					$output['article_submission'] = true;
				}
				if ($stage_type->jwf_stage_type == 'resubmission') {
					$output['article_resubmission'] = true;
				}
                //fetch the client's proceeding config array
			    $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
			    $output['proceeding_arr'] = $proceedingArr;
                DB::commit();
                return $this->success('Success',201,$output);
			} elseif ($validdata == 'success') {
				$output = array(
					'status' => 'success',
					'forms_validated' => true,
                    "article_type_code"=>$get_article_data->artp_abbr_article_type
				);
				if (($validated_assignment_forms != TRUE)) {
					$output = $return_data;
				}
                $output['art_status']=$get_article_data->art_status;
				$output['manage_upload_file_depend'] = $manage_depend_file_upload;
				$output['change_status'] = $change_status;

                //fetch the client's proceeding config array
			    $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
			    $output['proceeding_arr'] = $proceedingArr;

                DB::commit();
				return $this->success('Success',201,$output);
			} else {
                DB::rollback();
				$output = array(
					'status' => 'failed','msg' => 'failed');
                return  $this->warning('Warnings',200,$output,'warning');
			}
		} else {
            DB::rollback();
            $output = array(
                'validate' => $validdata,'msg' => 'failed');
            return  $this->warning('Warnings',200,$output,'warning');
		}

    } catch(\Exception $e) {
        DB::rollback();
        return  $this->failure('Failed',500,$e);
     }
	}

    public function removeUploadedFiles($existdata, $art_article_upload_path){
        $upload_file_ids = json_decode($existdata->gdata_data);
        $generic_upload_files = Generic_form_files::get_upload_files($upload_file_ids);
        foreach ($generic_upload_files as $up_file) {
            // $articletype_code = $article_data->artp_abbr_article_type;
            // $article_id = $article_data->art_id;
            $folder_path=$art_article_upload_path.'/';
            $file_path = public_path() . '/storage/uploads/' .$folder_path;
            $aws_path="uploads/" . $folder_path . "/";
            $this->remove_fileinfolder($file_path,$up_file->agf_name,$aws_path);
        }
        //* end remove uploaded files*//
        //remove uploaded files from rvw_article_generic_form_files
        Generic_form_files::del_upload_files($upload_file_ids);
    }
    public function save_metadata(Request $request)	{ // article submission save
        try {
        $form_data = $request->all();
        $validator = Validator::make($request->all(), [
            'form_id'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }

        $formid = $this->decrypt_data($form_data['form_id']);
	    $journal_code = $form_data['jnl_code'];
        $jnl_id = $this->decrypt_data($form_data['jnl_id']);
        $res=array();
        $formelmtdata=array();
        $file_gdata_id = [];
        $formatted_journal_code = '_'.$journal_code;
        // Task #3393 Metadata custom form fields should be able to delete
        DB::beginTransaction();
        $metadata_path=$this->get_metadatafilepath();
        $generic_data = Generic_forms::get_single_record_with_bind_cond('gncf_metadata_status,gncf_form_type', array('gncf_id'=>$formid) );
        if(!empty($generic_data)) {
            if($generic_data->gncf_metadata_status=='s'){
                $metadata_path=$this->get_metadatafilepath('s');
            }
        }
        $metadatafilepath=$journal_code.'/'.$metadata_path;
        $current_user = $this->get_current_user_details();
        $author_response_edit = FALSE;
        if (isset($form_data['frm_author_respone_edit_'.$formid]) && ($form_data['frm_author_respone_edit_'.$formid]) == 'y' && $this->current_client->functionality->cfty_edit_author_response_form == 'y') {
            $author_response_edit = TRUE;
            $current_status_id = $form_data['frm_flw_id_'.$formid];
        }





    $array=array(
        'formid'=>$formid,
        'metadata'=>true,
        'form_data'=>$form_data,
        'formatted_journal_code'=>$formatted_journal_code,
        'file_gdata_id'=>$file_gdata_id,
        'current_user'=>$current_user
    );

    $res=$this->setSavecustomformElementreorder($array);
    if(!empty($res)) {
        $formelmtdata=$res['formelmtdata'];
        $file_gdata_id=$res['file_gdata_id'];
    }
   
    $return_data = array(
        'status' => 'success',
        'forms_validated' => 'false');
       $article_submission = false;
		if (is_array($form_data)) {
			$validdata='success';
		} else {// in case of no form data
			// check if generic form contains any required fields
            $criteria = "emt_gucf_id='{$formid}' and emt_required=1 ";
			$elementdata = Generic_form_elements::get_single_record('COUNT(emt_id) AS required_elms',$criteria);
			// return error message in case of required fileds else set flag to denote validation success
			$validdata = 'success';
			if ($elementdata && $elementdata->required_elms > 0) {
                $res['status']='failed';
                $res['msg']=customTrans('customform.not_valid_form');
                return  $this->warning('Warnings',200,$res,'warning');
			}
		}
		$change_status=FALSE;
		//If validation successful means saving data
		$manage_depend_file_upload = array();

		if ($validdata == 'success') {
			$i = 1;
            /* start -- clear genereic form elements */
            $array=array(
                'formid'=>$formid,
                'metadata'=>true,
                'filepath'=>$metadatafilepath,
                'formatted_journal_code'=>$formatted_journal_code,
                'file_gdata_id'=>$file_gdata_id,
                'current_user'=>$current_user
            );
        
            $res=$this->setSavecustomformCleargenereicformelements($array);
            /*if(!empty($res)) {
                $status=$res['status'];
            }*/
            /* end -- clear genereic form elements */
			if (isset($form_data['label_only_element']) && $form_data['label_only_element'] != null) {
				$insertid = $this->save_label_element('', $formid, '', $form_data, '', $formatted_journal_code);
			}

            $array=array(
                'formelmtdata'=>$formelmtdata,
                'formatted_journal_code'=>$formatted_journal_code,
                'formid'=>$formid,
                'metadata'=>true,
                'jnl_id'=>$jnl_id,
                'filepath'=>$metadatafilepath,
                'change_status'=>$change_status,
                'manage_upload_file_depend'=>$manage_depend_file_upload,
                'current_user'=>$current_user
            );

        $res=$this->setSavecustomformcommon($array);
        

        if(!empty($res)) {
            $change_status=$res['change_status'];
            $manage_depend_file_upload=$res['manage_depend_file_upload'];
            $insertid=$res['insertid'];
            $existdata=$res['existdata'];            
        }




			


          $forms_validated = true;
			if (isset($insertid) && $insertid != '') {
				$output = array(
                    'status' => 'success',
					'forms_validated' => $forms_validated
				);

				$output['manage_upload_file_depend'] = $manage_depend_file_upload;
				$output['change_status'] = $change_status;

                    if (isset($existdata) > 0) {
                        $output['msg'] = isset($generic_data->gncf_metadata_status) &&  $generic_data->gncf_metadata_status=='s'?customTrans('metadata.supporting_updated'):customTrans('metadata.metadata_updated');
                    } else {
                        $output['msg'] = isset($generic_data->gncf_metadata_status) &&  $generic_data->gncf_metadata_status=='s'?customTrans('metadata.supporting_added'):customTrans('metadata.metadata_added');
                    }
                    DB::commit();   
                return $this->success('Success',201,$output);
			} elseif ($validdata == 'success') {
				$output = array(
					'status' => 'success',
					'forms_validated' => true,
				);
				$output['manage_upload_file_depend'] = $manage_depend_file_upload;
				$output['change_status'] = $change_status;
				$output['msg'] = isset($generic_data->gncf_metadata_status) &&  $generic_data->gncf_metadata_status=='s'?customTrans('metadata.supporting_added'):customTrans('metadata.metadata_added');
                DB::commit();
				return $this->success('Success',201,$output);
			} else {
                DB::rollback();
				$output = array(
					'status' => 'failed');
                return  $this->warning('Warnings',200,$output,'warning');
			}
		} else {
            DB::rollback();
            $output = array(
                'validate' => $validdata);
            return  $this->warning('Warnings',200,$output,'warning');
		}
    } catch(\Exception $e) {
        DB::rollback();
        return  $this->failure('Failed',500,$e);
     }
	}
    public function check_populate_data_found(Request $request){
        $data = $request->all();
        $emt_id = $data['emt_id'];
        $check_tables = DB::select("show tables like 'rvw_article_gnf_form_data_%' ");
        $check_tables = json_decode(json_encode($check_tables),true);
        $msg=customTrans('customform.dynamic_elmt_validation');
        foreach ($check_tables as $value) {
            $table = array_values($value)[0];
            $data= DB::table($table)->whereRaw(" gdata_atfemt_id = ? and gdata_data REGEXP '^\\\[.*\\\]$' ")->setBindings([$emt_id]);
            if ($data->exists()) {
                return $this->success($msg, data:['validation' => false]);
            }
        }
        return $this->success("success", data:['validation' => true]);
    }

    public function check_emt_dynamic_status_change(Request $request){
        $data = $request->all();
        $emt_id = $data['emt_id'];
        $check_tables = DB::select("show tables like 'rvw_article_gnf_form_data_%' ");
        $check_tables = json_decode(json_encode($check_tables),true);
        $msg=customTrans('customform.dynamic_elmt_validation');
        foreach ($check_tables as $value) {
            $table = array_values($value)[0];
            $data= DB::table($table)->whereRaw(" gdata_atfemt_id = ? and gdata_data REGEXP '^\\\[.*\\\]$' ")->setBindings([$emt_id]);
            if ($data->exists()) {
                return $this->success($msg, data:['validation' => false]);
            }
        }
        return $this->success("success", data:['validation' => true]);
    }

	public function remove_data_without_element($current_status='', $form_id='', $formatted_journal_code='') {
        $this->current_user = $this->get_current_user_details();
        $data = "";
        if ($current_status == '') {
            $data = "`gdata_atfemt_id`  NOT IN (SELECT `emt_id`  FROM `rvw_generic_form_elements` WHERE `emt_gucf_id` = " . $form_id . ") AND gdata_atf_id =" . $form_id;
        } else {
            $data = "`gdata_atfemt_id`  NOT IN (SELECT `emt_id`  FROM `rvw_generic_form_elements` WHERE `emt_gucf_id` = " . $form_id . ") AND gdata_atf_id =" . $form_id . " AND gdata_artflw_id = " . $current_status;
        }
        $elements = Article_generic_form_data::get_all_records('gdata_id', $data, NULL, NULL, $formatted_journal_code);

        if ($elements != NULL) {
			foreach ($elements as $elm) {
                $condition = "gdata_id='{$elm->gdata_id}' ";
				Article_generic_form_data::delete_records($condition,$formatted_journal_code,$this->current_user);
			}
		}
	}

    private function save_label_element($articleid, $formid, $current_status_id, $data, $stage_type, $formatted_journal_code,$viewemt_ids = '') {

        $EditfrmCondition = $EditEmtCondition = '';
        $elem_codition = "emt_gucf_id='{$formid}' ";
        if($viewemt_ids != '')
        {
            $EditEmtCondition = ' AND (emt_id IN ('.$viewemt_ids.') OR (emt_depending_control IN ('.$viewemt_ids.')))';
            $elem_codition = "emt_gucf_id='{$formid}' ".$EditEmtCondition;
            $form_data_elements = Generic_form_elements::get_single_record('group_concat(emt_id) as emt_ids',$elem_codition);

            if(isset($form_data_elements->emt_ids))
            {
               $EditfrmCondition = ' AND gdata_atfemt_id IN ('.$form_data_elements->emt_ids.')';
            }
        }
		$insertid = '';
        $current_user = $this->get_current_user_details();

		$form_data_array = Generic_form_elements::get_all_records('*',$elem_codition,'emt_order');
        $codition = "gdata_art_id='{$articleid}' and gdata_atf_id = '{$formid}' and gdata_artflw_id = '{$current_status_id}' ".$EditfrmCondition;
		Article_generic_form_data::delete_records($codition, $formatted_journal_code,$current_user);
		foreach ($form_data_array as $form_data) {
			$elementdata = Generic_form_elements::get_element_details_with_group($form_data->emt_id);
			Article_generic_form_data::insert_record(array(
				'gdata_art_id' => $articleid,
				'gdata_atf_id' => $formid,
				'gdata_atfemt_id' => $form_data->emt_id,
				'gdata_user_roles' => $elementdata->emt_user_roles,
				'gdata_artflw_id' => $current_status_id,
				'gdata_gform_title' => $elementdata->gncf_form_title,
				'gdata_gfg_id' => $elementdata->gfg_id,
				'gdata_group_name' => $elementdata->gfg_group_name,
				'gdata_unique_identifier' => $elementdata->emt_unique_identifier,
				'gdata_label' => $elementdata->emt_note_text,
				'gdata_artflw_stage_repeat_count' => $stage_type->aflw_stage_repeat_count), $current_user, $formatted_journal_code);
		}
		if (isset($elementdata)) {
			$form_data = $form_data_array[0];
			$insertid = Article_generic_form_data::insert_record(array(
				'gdata_art_id' => $articleid,
				'gdata_atf_id' => $formid,
				'gdata_user_roles' => $elementdata->emt_user_roles,
				'gdata_artflw_id' => $current_status_id,
				'gdata_label' => 'Status',
				'gdata_display_data' => $data['label_only_element'],
				'gdata_artflw_stage_repeat_count' => $stage_type->aflw_stage_repeat_count), $current_user, $formatted_journal_code);
		}
		return $insertid;
	}

public function save_form_element(Request $request) {
    //DB::beginTransaction();

	try {
        $this->current_user = $this->get_current_user_details();
        $form_data = $request->all();
        $formid=$this->decrypt_data($form_data['formid']);
        $groupid=$this->decrypt_data($form_data['groupid']);
        $updatereq=$this->decrypt_data($form_data['urequired']);
        $position = $form_data['position'];
		$reference_id = $this->decrypt_data($form_data['referenceid']);
        $formtype = $form_data['select_form_element'];
        $help_icon_chk = $help_icon_desc_text = '';
        (!empty($form_data[$formtype.'_help_icon_chk'])) && $help_icon_chk	= $form_data[$formtype.'_help_icon_chk'];
        (!empty($form_data[$formtype.'_help_icon_desc_txt'])) && $help_icon_desc_text	= $form_data[$formtype.'_help_icon_desc_txt'];
        $file_upload_count = TRUE;
		$html_tag_error = FALSE;
		$action = '';
        $form_catogory = isset($form_data['form_catogory'])?$form_data['form_catogory']:null;
        $element_type=0;

        $validator = Validator::make($request->all(), [
            'formid' => 'required',
            'groupid' => 'required',
            'urequired' => 'required',
            'referenceid' => 'required'

        ]);
        if($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }

        //Validation for textbox
        if ($formtype != 'label') {
            if(empty($form_data[$formtype.'_element_label_field'])) {
                return $this->warning(customTrans('customform.gncform_label_name'),200,'','warning');
            }


        }
        $form_data[$formtype.'_element_dynamic_field'] = $form_data[$formtype.'_element_dynamic_field'] ?? 'n';

        if($formtype=='textbox') {  
                      
            if(empty($form_data[$formtype.'_field_element_type'])) {
                return  $this->warning(customTrans('customform.gncform_elm_type'),200,'','warning');
            }
            if(!is_numeric($form_data[$formtype.'_min_length'])) {
                return  $this->warning(customTrans('customform.gncform_min_leng_req'),200,'','warning');
            }
            if(!is_numeric($form_data[$formtype.'_max_length'])) {
                return  $this->warning(customTrans('customform.gncform_max_leng_req'),200,'','warning');
            }
            $element_type=$form_data[$formtype.'_field_element_type'];
        } elseif ($formtype === 'textarea') {
			if(!is_numeric($form_data[$formtype.'_element_word_min_length'])) {
                return  $this->warning(customTrans('customform.gncform_min_leng_req'),200,'','warning');
            }
            if(!is_numeric($form_data[$formtype.'_element_word_max_length'])) {
                return  $this->warning(customTrans('customform.gncform_max_leng_req'),200,'','warning');
            }
            if($form_data[$formtype.'_element_row_count']==0) {
                return  $this->warning(customTrans('customform.gncform_row_grt_zero'),200,'','warning');
            }
            if($form_data[$formtype.'_element_row_count']>25) {
                return  $this->warning(customTrans('customform.gncform_row_lesr_twfive'),200,'','warning');
            }
		} elseif ($formtype === 'checkbox') {
            if (empty($form_data[$formtype.'_autodata'][0]['selectval']) || empty($form_data[$formtype.'_autodata'][0]['selectopt'])) {
                return  $this->warning(customTrans('customform.gncform_val'),200,'','warning');
            }
		} elseif ($formtype === 'label') {
            if(empty($form_data[$formtype.'_element_note_field'])) {
                return  $this->warning(customTrans('customform.gncform_note_txt'),200,'','warning');
            }
		} elseif ($formtype == 'file') {
            if(empty($form_data[$formtype.'_element_file_types'])) {
                return  $this->warning(customTrans('customform.gncform_alw_file_type'),200,'','warning');
            }
		} elseif ($formtype == 'combobox') {
            if($form_data[$formtype.'_element_dynamic_field'] == 'y' || (isset($form_data[$formtype.'_element_flag_ctrl'])&& $form_data[$formtype.'_element_flag_ctrl']!='1')){
                $form_data[$formtype.'_autodataflag']=array();
            }
            if($form_data[$formtype.'_element_opt_from_table']==1) {
                if(empty($form_data[$formtype.'_element_populate_table'])) {
                    return  $this->warning(customTrans('customform.gncform_val_tbl'),200,'','warning');
                }
            }else if (empty($form_data[$formtype.'_autodata'][0]['selectval']) || empty($form_data[$formtype.'_autodata'][0]['selectopt'])) {
                return  $this->warning(customTrans('customform.gncform_val'),200,'','warning');
            }
		} elseif ($formtype == 'radiobutton') {
            if($form_data[$formtype.'_element_dynamic_field'] == 'y' || (isset($form_data[$formtype.'_element_flag_ctrl'])&& $form_data[$formtype.'_element_flag_ctrl']!='1')){
                $form_data[$formtype.'_autodataflag']=array();
            }
            if (empty($form_data[$formtype.'_autodata'][0]['selectval']) || empty($form_data[$formtype.'_autodata'][0]['selectopt'])) {
                return  $this->warning(customTrans('customform.gncform_val'),200,'','warning');
            }
		}



        /* $data['position'] will contain values depending upon the direction in which the element is added
		 * '' -> vertically after/veritically before
		 * 'l' -> horizontally before -
		 * 'r' -> horizontally after */

        //$reference_id =$updatereq;

        ((isset($form_data[$formtype.'_autodata'][0]['selectstg'])) && (!empty($form_data[$formtype.'_autodata'][0]['selectstg'])) && (empty($form_data[$formtype.'_element_populate_table']))) && $form_data[$formtype.'_dependency_required'] = 0;
        //Getting dependency value(0 or 1) to check whether its required or not.
        $dependency = $form_data[$formtype.'_dependency_required'];
        $attach_files = (isset($form_data[$formtype.'_attach_to_mail'])) ? $form_data[$formtype.'_attach_to_mail'] : 'n';

        //dependency value 1 means dependency fields are there and 0 means no dependency
		if ($dependency == 1) {
            if(empty($form_data[$formtype.'_depending_control'])) {
                return  $this->warning(customTrans('customform.gncform_decision_ctrl_req'),200,'','warning');
            }
            if(empty($form_data[$formtype.'_depending_value'])) {
                return  $this->warning(customTrans('customform.gncform_dependency_req'),200,'','warning');
            }
		}
        $populate_data = $form_data[$formtype.'_element_dynamic_field'] == 'y' ? 0 : (isset($form_data[$formtype.'_populatedata_required'])?$form_data[$formtype.'_populatedata_required']:'');
        if ($populate_data == 1) {
            // Task #8244 populate data task start
            if(empty($form_data[$formtype.'_populate_form_elem'])) {
                return  $this->warning(customTrans('customform.gncform_form_req'),200,'','warning');
            }
            // Task #8244 populate data task end
		}
        $element_enable_unique_idr = $form_data[$formtype.'_element_dynamic_field'] == 'y' ? 0 : ((isset($form_data[$formtype.'_element_enable_unique_idr'])?$form_data[$formtype.'_element_enable_unique_idr']:''));
        if ($element_enable_unique_idr == 1) {
            if(empty($form_data[$formtype.'_element_unique_identifier'])) {
                return  $this->warning(customTrans('customform.gncform_enter_identifier'),200,'','warning');
            }
            $select_identifier=0;
            if (isset($form_data[$formtype.'_select_identifier']) && !empty($form_data[$formtype.'_select_identifier']))
            $select_identifier = $form_data[$formtype.'_select_identifier'];
            $element_id = 0;
            if (!empty($updatereq) && $updatereq != 0) {
                $element_id = (int) $updatereq;
            }

            $res_uniqidenvalid=$this->check_generic_form_unique_identifier($formid,$element_id,$form_catogory,$form_data[$formtype.'_element_unique_identifier'],$formtype,$element_type,$select_identifier);

            if(!empty($res_uniqidenvalid)) {
                if(!empty($res_uniqidenvalid['msg'])){
                    return  $this->warning($res_uniqidenvalid['msg'],200,'','warning');
                }
            }
            //print_r($res_uniqidenvalid);die;
        }
        $help_icon_chk = (isset($form_data[$formtype.'_help_icon_chk'])?$form_data[$formtype.'_help_icon_chk']:'');
        if($help_icon_chk=='y') {
            if(empty($form_data[$formtype.'_help_icon_desc_txt'])) {
                return  $this->warning(customTrans('customform.gncform_enter_icon_desc'),200,'','warning');
            }
        }



        // Task #8244 populate data task start
        $form_eleid ='';
		$anotherid ='';
        $populate_form_element=null;
        if(!empty($populate_data)) {
			$form_eleid =(isset($form_data[$formtype.'_field_form_type'])?$form_data[$formtype.'_field_form_type']:'');
			$anotherid =(isset($form_data[$formtype.'_field_element_id'])?$form_data[$formtype.'_field_element_id']:'');
            $populate_form_element=(isset($form_data[$formtype.'_populate_form_elem'])?$form_data[$formtype.'_populate_form_elem']:''); 
		}
        // Task #8244 populate data task end 

		//Validation for label field

        if (isset($form_data[$formtype.'_element_label_field']) && $form_data[$formtype.'_element_label_field'] != strip_tags($form_data[$formtype.'_element_label_field'])) {
			if (preg_match("#<([a-zA-Z]+).*?>(.*?)</\\1>#", $form_data[$formtype.'_element_label_field']) === 0){
                return  $this->warning('Min length numeric required',200,'','warning');
            }
		}

        

       $datacustom = array();
        $move_to_next = FALSE;
        if(isset($form_data[$formtype.'_autodata'][0]['selectval'])) {
            $optvalue = array();
            $temp_arr =array();
            if(isset($form_data['selectOptions'])) {
                $stages = json_decode($form_data['selectOptions']);
            }

            for($i=0;$i<count($form_data[$formtype.'_autodata']);$i++) {
                $j=0;
                $selectval=$form_data[$formtype.'_autodata'][$i]['selectval'];
                $selectopt=$form_data[$formtype.'_autodata'][$i]['selectopt'];
                $selectstg=isset($form_data[$formtype.'_autodata'][$i]['selectstg'])? $form_data[$formtype.'_autodata'][$i]['selectstg']:'';
                if ((!empty($selectval)) && (!empty($selectopt))) {
                    $temp_arr[$selectval] = $selectopt;
                    if(!empty($selectstg) && isset($form_data[$formtype.'_element_decision_ctrl']) && $form_data[$formtype.'_element_decision_ctrl']==1 ) {
                        if(!is_array($selectstg)) {
                            $selectstg=explode(',', $selectstg);
                        }
                        $temp_arr['next_stage'] =implode(',', $selectstg);
                        $move_to_next = TRUE;
                    }
                }
                array_push($optvalue, $temp_arr);
                $temp_arr =array();
            }
        }
        $flagresult=$this->usedflags($formid); 
            if(!empty($flagresult)){
                if (isset($form_data[$formtype . '_autodataflag']) && is_array($form_data[$formtype . '_autodataflag'])) {
                    foreach ($form_data[$formtype . '_autodataflag'] as $item) {
                        $selectval = isset($item['selectval']) ? $item['selectval'] : null;
                        $selectflag = (isset($item['selectflag']) && !empty($item['selectflag'])) ? $item['selectflag'] : null;
                        if (!empty($selectflag) && !empty(array_search($selectflag, $flagresult))) {
                            $criteria = array('flag_id'=>$selectflag);
                            $removeflags = Flags::get_single_record_with_bind_cond("CASE WHEN COUNT(flag_name) = 1 THEN MAX(flag_name) WHEN COUNT(flag_name) = 2 THEN GROUP_CONCAT(flag_name SEPARATOR ' and ') ELSE CONCAT(SUBSTRING_INDEX(GROUP_CONCAT(flag_name SEPARATOR ', '), ', ', COUNT(flag_name)-1),' and ',SUBSTRING_INDEX(GROUP_CONCAT(flag_name SEPARATOR ', '), ', ', -1))END AS flag_name", $criteria);
                            $translatedMessage = trans('workflow.flagging_element', ['flag' => $removeflags->flag_name]);
                            return $this->warning($translatedMessage, 200, '', 'warning');
                        }
                    } 
                }
            }
       
        if(isset($form_data[$formtype.'_autodataflag'][0]['selectval'])) {
       
            $optflagvalue = array();
            $tempflg_arr =array();
            
            
            for($i=0;$i<count($form_data[$formtype.'_autodataflag']);$i++) {    
                $j=0;
                $selectval=isset($form_data[$formtype.'_autodataflag'][$i]['selectval'])?$form_data[$formtype.'_autodataflag'][$i]['selectval']:null;
                $selectflag=(isset($form_data[$formtype.'_autodataflag'][$i]['selectflag']) && !empty($form_data[$formtype.'_autodataflag'][$i]['selectflag']))?$form_data[$formtype.'_autodataflag'][$i]['selectflag']:null;   
                $flagresult=$this->usedflags($formid); 
                if(!empty($flagresult)){
                    if (!empty($selectflag) &&  !empty(array_search($selectflag, $flagresult))) {
                        $criteria = 'flag_id='.$selectflag;
                        $removeflags = Flags::get_single_record('flag_id,flag_name', $criteria);
                        $translatedMessage = trans('workflow.flagging_element', ['flag' => $removeflags->flag_name]); // Use trans, and $selectflag
                        return $this->warning($translatedMessage, 200, '', 'warning');
                    }
                }      
                if ((!empty($selectval)) && (!empty($selectflag))) {
                    $tempflg_arr[$selectval] = $selectflag;
                }
                if(!empty($tempflg_arr)){
                    array_push($optflagvalue, $tempflg_arr);
                    $tempflg_arr =array();
                }             
            }
        
        }
        // print_r($optflagvalue);exit;
        
       



        //Task #480 Viewable roles configuration for custom from elements
        $view_role = array();
        $view_role_str = NULL;
        // TASK #8960 viewable roles for decision control elements This is suggestion from Gijo
        // enabling viewable roles for decision control elements
        if ((isset($form_data[$formtype.'_emt_viewable_role']) || isset($form_data[$formtype.'_depending_control']))) { //viewable role is not applicable in decision control element
            if(isset($form_data[$formtype.'_depending_control']) && $form_data[$formtype.'_dependency_required'] == TRUE) {
                $view_role_str = $this->get_dependent_viewable_roles($form_data[$formtype.'_depending_control']);
            } elseif(isset($form_data[$formtype.'_emt_viewable_role'])) {
                foreach ($form_data[$formtype.'_emt_viewable_role'] as $view_rl) {
                    //$view_role[] = $this->decrypt_data($view_rl); // to do
                    $view_role[] = $view_rl;
                }
                $view_role_str = implode(',', $view_role);
            }
        }

        //Condition to limit the datafield to save
        if($move_to_next == TRUE) {
            $update_id = '';
            if (!empty($updatereq) && $updatereq != 0) {
                $update_id = $updatereq;
            }
            $move_next_elements_duplct = FALSE;
            $cur_empt_options = Generic_form_elements::get_element_options($formid,$update_id);
            if(!empty($cur_empt_options)) {
                foreach($cur_empt_options as $empt_options) {
                    if(!empty($empt_options->emt_options)) {
                        $i = 1;
                        $options = json_decode($empt_options->emt_options);
                        foreach($options as $opts) {
                            $i = 1;
                            foreach($opts as $key => $value) {
                                if($i != 1) {
                                    $move_next_elements_duplct = TRUE;
                                }
                                $i++;
                            }
                        }
                    }

                }
            }
        }
        
        if(isset($move_next_elements_duplct) && $move_next_elements_duplct == TRUE && empty($form_data[$formtype.'_element_populate_table'])) {
            return  $this->warning(customTrans('customform.gncform_decision_alrdy_set'),200,'','warning');
        } 
        $dynamic_status='n';
        if(isset($form_data[$formtype.'_element_dynamic_field']) && $form_data[$formtype.'_element_dynamic_field']=='y'){
            $dynamic_status=$form_data[$formtype.'_element_dynamic_field'];
        }
        $commonFields = [
            'emt_dynamic_status' => $dynamic_status,
            'emt_help_icon' => $help_icon_chk,
            'emt_user_roles' => $view_role_str,
            'emt_help_icon_text' => $help_icon_desc_text,
        ];

        switch ($formtype) {
            case 'textbox':
                $identifier_type = '';
                if (isset($form_data[$formtype.'_select_identifier']) && !empty($form_data[$formtype.'_select_identifier']))
                    $identifier_type = $form_data[$formtype.'_select_identifier'];
    
                    $datacustom = array_merge($commonFields, [
                    'emt_required' => $form_data[$formtype.'_element_required_field'],
                    'emt_min_char' => $form_data[$formtype.'_min_length'],
                    'emt_max_char' => $form_data[$formtype.'_max_length'],
                    'emt_place_holder' => $form_data[$formtype . '_element_placeholder'],
                    'emt_column_type' => $form_data[$formtype . '_field_element_type'],
                    'emt_identifier_type' => $identifier_type,
                    'emt_populate_data' => $populate_data,
                    'emt_source_formid' => $form_eleid,
                    'emt_source_elementid' => $anotherid,
                     // Task #8244 populate data task start
                    'emt_populate_data_pair' =>$populate_form_element !=null ? json_encode($populate_form_element):null
                    // Task #8244 populate data task end
                ]);
                break;
            case 'combobox':
                $populate_from_table = NULL;
                if (!empty($form_data[$formtype.'_element_populate_table'])) {
                    $populate_from_table = $form_data[$formtype.'_element_populate_table'];
                    $emt_options = NULL;
                } else
                    $emt_options = json_encode($optvalue);

                $user_dnd_value = '';
                if (isset($form_data[$formtype.'_user_dnd_value']) && !empty($form_data[$formtype.'_user_dnd_value']))
                    $user_dnd_value = $form_data[$formtype.'_user_dnd_value'];
                $identifier_type = '';
                if (isset($form_data[$formtype.'_select_identifier']) && !empty($form_data[$formtype.'_select_identifier']))
                    $identifier_type = $form_data[$formtype.'_select_identifier'];
                    $datacustom = array_merge($commonFields, [
                        'emt_required' => $form_data[$formtype.'_element_required_field'],
                        'emt_options' => $emt_options,
                        'emt_combo_multiple' => '',
                        'emt_combo_custom' => '',
                        'emt_flag_id' => isset($optflagvalue) && !empty($optflagvalue)  ? json_encode($optflagvalue) : null,
                        'emp_populate_from_table' => $populate_from_table,
                        'emt_dnd_value' => $user_dnd_value,
                        'emt_identifier_type' => $identifier_type,
                    ]);
                break;
            case 'radiobutton':
                $user_dnd_value = '';
                if (isset($form_data[$formtype.'_user_dnd_value']) && !empty($form_data[$formtype.'_user_dnd_value']))
                    $user_dnd_value = $form_data[$formtype.'_user_dnd_value'];
                $identifier_type = '';
                if (isset($form_data[$formtype.'_select_identifier']) && !empty($form_data[$formtype.'_select_identifier']))
                    $identifier_type = $form_data[$formtype.'_select_identifier'];
                    $datacustom = array_merge($commonFields, [
                        'emt_required' => $form_data[$formtype.'_element_required_field'],
                        'emt_options' => json_encode($optvalue),
                        'emt_flag_id' => isset($optflagvalue) && !empty($optflagvalue)  ? json_encode($optflagvalue) : null,
                        'emt_alignment' => (isset($form_data[$formtype.'_element_alignment'])) ? $form_data[$formtype.'_element_alignment'] : NULL,
                        'emt_dnd_value' => $user_dnd_value,
                        'emt_identifier_type' => $identifier_type,
                    ]);
                break;
            case 'checkbox':
                $identifier_type = '';
                if (isset($form_data[$formtype.'_select_identifier']) && !empty($form_data[$formtype.'_select_identifier']))
                    $identifier_type = $form_data[$formtype.'_select_identifier'];
                    $jsoption=json_encode($optvalue);
                    $datacustom = array_merge($commonFields, [
                        'emt_required' => $form_data[$formtype.'_element_required_field'],
                        'emt_options' => $jsoption,
                        //'emt_flag_id'=>isset($optflagvalue)?json_encode($optflagvalue):null,
                        'emt_alignment' => (isset($form_data[$formtype.'_element_alignment'])) ? $form_data[$formtype.'_element_alignment'] : NULL,
                        'emt_identifier_type' => $identifier_type,
                    ]);

                break;
            case 'label':
                    $datacustom = array_merge($commonFields, [
                        'emt_note_text' => $form_data[$formtype.'_element_note_field'],
                        'emt_hideafterstage' => (isset($form_data[$formtype.'_element_hidestage']) && $form_data[$formtype.'_element_hidestage']=='y')?$form_data[$formtype.'_element_hidestage']:'n'
                    ]);
                break;
            case 'textarea':
                $identifier_type = '';
                if (isset($form_data[$formtype.'_select_identifier']) && !empty($form_data[$formtype.'_select_identifier']))
                $identifier_type = $form_data[$formtype.'_select_identifier'];

                $datacustom = array_merge($commonFields, [
                    'emt_word_min' => $form_data[$formtype.'_element_word_min_length'],
                    'emt_word_max' => $form_data[$formtype.'_element_word_max_length'],
                    'emt_tinymce_required' => $form_data[$formtype.'_element_tiny_required_field'],
                    'emt_required' => $form_data[$formtype.'_element_required_field'],
                    'emt_place_holder' => $form_data[$formtype.'_element_placeholder'],
                    'emt_identifier_type' => $identifier_type,
                    'emt_textarea_rows' => $form_data[$formtype.'_element_row_count'],
                    'emt_populate_data' => $populate_data,
                    'emt_source_formid'=> $form_eleid,
                    'emt_source_elementid' => $anotherid,
                     // Task #8244 populate data task start
                    'emt_populate_data_pair' =>$populate_form_element !=null ? json_encode($populate_form_element):null
                    // Task #8244 populate data task end
            ]);
                break;
            case 'file':
                $identifier_type = '';
                if (isset($form_data[$formtype.'_select_identifier']) && !empty($form_data[$formtype.'_select_identifier']))
                    $identifier_type = $form_data[$formtype.'_select_identifier'];
                    $jsonfile=json_encode($form_data[$formtype.'_element_file_types']);
                    $datacustom = array_merge($commonFields, [
                        'emt_required' => $form_data[$formtype.'_element_required_field'],
                        'emt_file_min_cnt' => $form_data[$formtype.'_min_count'],
                        'emt_file_max_cnt' => $form_data[$formtype.'_max_count'],
                        'emt_file_types' => $jsonfile,
                        'emt_identifier_type' => $identifier_type
                    ]);    
                break;
        }
        
        $emt_cd_code = '';

        if (isset($this->current_client->functionality->cfty_xml_cd_code_in_export) && $this->current_client->functionality->cfty_xml_cd_code_in_export == 'y') {
            $emt_cd_code = (isset($form_data[$formtype.'_emt_cd_code'])) ? $form_data[$formtype.'_emt_cd_code'] : '';
        }
        $datacustom['emt_cd_code'] = $emt_cd_code;
        $depdata = array();
        if ($dependency == 1) {
            $depdata = array(
                'emt_dependency_required' => $form_data[$formtype.'_dependency_required'],
                'emt_depending_control' => $form_data[$formtype.'_depending_control'],
                'emt_depending_value' => trim($form_data[$formtype.'_depending_value']));
        } elseif ($dependency == 0) {
            $depdata = array(
                'emt_dependency_required' => $form_data[$formtype.'_dependency_required'],
                'emt_depending_control' => '',
                'emt_depending_value' => '');
        }
        $element_common_details = array(
            'emt_gucf_id' => $formid,
            'emt_gfg_id' => $groupid,
            'emt_element_type' => $formtype,
            //'emt_label' => $data['element_label_field'],
            'emt_active' => ''
        );
        $element_common_details['emt_label'] = '';
        if ($formtype != 'label')
            $element_common_details['emt_label'] = isset($form_data[$formtype.'_element_label_field']) ? $form_data[$formtype.'_element_label_field'] : '';

        $div_ids = array();
        $elementdetails = ($element_common_details + $datacustom + $depdata);

        $elementdetails['emt_unique_identifier'] = NULL;
        if ($form_data[$formtype.'_element_dynamic_field'] != 'y' && isset($form_data[$formtype.'_element_enable_unique_idr']) && isset($form_data[$formtype.'_element_unique_identifier']) && trim($form_data[$formtype.'_element_unique_identifier']) != '0' && $attach_files == 'n')
        {
            $elementdetails['emt_unique_identifier'] = trim($form_data[$formtype.'_element_unique_identifier']);
        }
        $elementdetails['emt_attach_to_mail'] = $attach_files;

        if (!empty($updatereq) && $updatereq != 0) {
            $id = (int) $updatereq;
            $emt_id = $id;
            $element_condition = 'emt_id='.$id;
            $old_elm_details = Generic_form_elements::get_single_record('*', $element_condition);
            $res = Generic_form_elements::update_record($elementdetails,$element_condition, $this->current_user);

            //#3859 Label change in custom form need to effect in gdata tables
            if($res && $elementdetails['emt_label'] != '' && ($old_elm_details->emt_label != $elementdetails['emt_label'])) {
                $this->update_new_emt_label($old_elm_details, $elementdetails['emt_label']);
            }

            if ($res && $old_elm_details->emt_unique_identifier != $elementdetails['emt_unique_identifier']) {
                $this->update_new_unique_identifier($old_elm_details, $elementdetails['emt_unique_identifier']);
            }
            // gdata_user_roles
            //Task #480 Viewable roles configuration for custom from elements
            //this function update current element data in gdata table
            $this->update_elmt_viewable_role_on_gdata_tables($id,$view_role_str);

            //if current element having dependency elements its under then update - - current element's viewable roles to that elements also.
            $this->iterative_update_element_view_roles($id,$view_role_str);

            //$extout['insertid'] = $this->encrypt_data($id);

            //$msg_arr[]=customTrans('file_desc.insert_desc_success');
            $insertid = $id;
            if(isset($form_data['metaStatus']) && $form_data['metaStatus'] === 'm')
            {
                $msg_arr['msg']=customTrans('customform.gncform_meta_upd');
            } else if(isset($form_data['metaStatus']) && $form_data['metaStatus'] === 's') {
                $msg_arr['msg']=customTrans('customform.gncform_supporting_upd');
            } else{
                $msg_arr['msg']=customTrans('customform.gncform_ele_upd');

            }  
            
        } else {
            //emt_attach_to_mail
            $insertid = false;
            //if referenceid equal zero just save in normal way
            if ($reference_id == 0) {
                //Getting maximum order value from corresponding group elements
                $maxorderid = Generic_form_elements::getmax_order_element($formid, $groupid);
                $maxorderid++;
                $dataorder = array(
                    'emt_order' => $maxorderid);
                $elementdetails = ($elementdetails + $dataorder);
                $insertid = Generic_form_elements::insert_record($elementdetails, $this->current_user);
                $msg_arr['insertid'] = $this->encrypt_data($insertid);
                $status = 'success';
                if(isset($form_data['metaStatus']) && $form_data['metaStatus'] === 'm')
                {
                    $msg_arr['msg']=customTrans('customform.gncform_meta_add');
                } else if(isset($form_data['metaStatus']) && $form_data['metaStatus'] === 's') {
                    $msg_arr['msg']=customTrans('customform.gncform_supporting_add');
                } else{
                $msg_arr['msg']=customTrans('customform.gncform_ele_add');
                }
                if ($insertid == false) {
                    $status = 'failed';
                    $msg_arr['msg']=customTrans('customform.gncform_el_add_fail');
                }

            }else {
                //referenceid not equal zero then find that reference id row in table
                $condition1 = 'emt_id="' . $reference_id . '"';
                $orderid = Generic_form_elements::get_single_record('emt_order',$condition1);
                //if position=='r', then no need to increase the order of reference element as the new element will be in order after the ref. element. Hence if position=='r',then $orderid is incremented by one.
                if ($position == 'r' || $position == 'b') {
                    $orderid->emt_order++;
                }
                //find rows greater than or equal to that order id and increment those with 1
                $out = Generic_form_elements::increment_orderids($formid, $groupid, $orderid->emt_order);
                if ($out === true || $position != '') {
                    $ref_elm_right_emt_ids = array();
                    //fetch the row with id as reference element id
                    $condition2 = 'emt_id="' . $reference_id . '"';
                    $row_start_elm_record = Generic_form_elements::get_single_record('div_start_emt_id,right_emt_ids, emt_order ',$condition2);
                    /* if $row_start_elm_record->div_start_emt_id is not NULL,
                     * then this element is not the starting element of the row in which
                     * the new element is about to be placed together.
                     * In such case the id of the starting element will be the value of this field. */
                    if ($row_start_elm_record->div_start_emt_id != NULL) {
                        $reference_id = $row_start_elm_record->div_start_emt_id;
                        /* Fetch the record corresponding to the starting element of row.
                         * Need to update the right_emt_ids field */
                        $condition3 = 'emt_id="' . $reference_id . '"';
                        $row_start_elm_record = Generic_form_elements::get_single_record('div_start_emt_id,right_emt_ids, emt_order',$condition3);
                    }

                    $right_emt_ids = array();
                    if ($row_start_elm_record->right_emt_ids != NULL) {
                        $right_emt_ids = json_decode($row_start_elm_record->right_emt_ids);
                    }

                    if ($position == 'l') {
                        if ($orderid->emt_order < $row_start_elm_record->emt_order) {
                            $right_emt_ids[] = $reference_id;
                            $elementdetails['right_emt_ids'] = json_encode($right_emt_ids);
                        }else {
                            $elementdetails['div_start_emt_id'] = $reference_id;
                        }
                    }else if ($position == 'r') {
                        $elementdetails['div_start_emt_id'] = $reference_id;
                    }
                    //save this order id as current row order id(if the position is left, up), else save order of the new element as next to reference element and save the record
                    $dataorder = array(
                        'emt_order' => $orderid->emt_order);
                    $elementdetails = ($elementdetails + $dataorder);

                    $insertid = Generic_form_elements::insert_record($elementdetails, $this->current_user);
                    $msg_arr['insertid'] = $this->encrypt_data($insertid);
                    if ($position == 'l' || $position == 'r') {
                        $div_start_emt_id = $reference_id;
                        if ($position == 'l') {
                            if ($orderid->emt_order < $row_start_elm_record->emt_order) {
                                $div_start_emt_id = $insertid;
                                $ref_elm_right_emt_ids['right_emt_ids'] = NULL;
                                $ref_elm_right_emt_ids['div_start_emt_id'] = $insertid;
                                //update the div_start_emt_id value in all the related elements
                                $update_data['div_start_emt_id'] = $div_start_emt_id;
                                $condition4 = "div_start_emt_id={$reference_id}";
                                Generic_form_elements::update_record($update_data, $condition4, $this->current_user);
                            }else {
                                $right_emt_ids[] = $insertid;
                                $ref_elm_right_emt_ids['right_emt_ids'] = json_encode($right_emt_ids);
                            }
                        }else if ($position == 'r') {
                            $right_emt_ids[] = $insertid;
                            $ref_elm_right_emt_ids['right_emt_ids'] = json_encode($right_emt_ids);
                        }
                        $condition5 = "emt_id={$reference_id}";
                        Generic_form_elements::update_record($ref_elm_right_emt_ids,$condition5,$this->current_user);
                        $right_emt_ids[] = $div_start_emt_id;

                        //id of div elements in which the all other elements placed horizontally
                        foreach ($right_emt_ids as $id) {
                            $div_ids[$groupid . '_group_element_' . $id] = floor(12 / count($right_emt_ids));
                        }
                    }
                    if(isset($form_data['metaStatus']) && $form_data['metaStatus'] === 'm')
                    {
                        $msg_arr['msg']=customTrans('customform.gncform_meta_add');
                    }else if(isset($form_data['metaStatus']) && $form_data['metaStatus'] === 's') {
                        $msg_arr['msg']=customTrans('customform.gncform_supporting_add');
                    } else{
                    $msg_arr['msg']=customTrans('customform.gncform_ele_add');
                    }
                    $status = 'success';
                    if ($insertid == false) {
                        $status = 'failed';
                        $msg_arr['msg']=customTrans('customform.gncform_el_add_fail');
                    }

                }
            }
            $emt_id = $insertid;
        }

        //$query = $this->db->get('rvw_generic_form_elements');
        $condition = 'emt_id="' . $insertid . '"';
        $resultout = Generic_form_elements::get_single_record('*',$condition);
        // start -- add selectbox options from tables, if "emp_populate_from_table" is set
        $populate_tables= $this->Utility('populate_tables');
        if ($resultout->emt_element_type == 'combobox' ) {
            $pop_all_keys = array_keys($populate_tables['populate_tables']);
            foreach($pop_all_keys as $key => $value){
                $pop_all_keys2 = array_keys($populate_tables['populate_tables'][$value]);
                if(in_array($resultout->emp_populate_from_table, array_keys($populate_tables['populate_tables'][$value]))) {
                    $resultout->emt_options =$this->populate_options_from_table($resultout,$populate_tables['populate_tables'][$value]);
                }
            }
        }
        // end -- add selectbox options from tables, if "emp_populate_from_table" is set
        if ($emt_id != FALSE && $attach_files == 'y') {
            $unique_id = 'RV_ATTACHMENT_TO_AUTHOR_' . $emt_id;
            $criteria = 'emt_id="' . $emt_id . '"';
            Generic_form_elements::update_record(array(
                'emt_unique_identifier' => $unique_id),$criteria, $this->current_user);
            if (isset($old_elm_details) && !empty($old_elm_details)) {
                $this->update_new_unique_identifier($old_elm_details, $unique_id);
            }
        }elseif ($formtype == 'file' && isset($old_elm_details) && !empty($old_elm_details) && $old_elm_details->emt_unique_identifier != $elementdetails['emt_unique_identifier'])  {
            $unique_id = '';
            $this->update_new_unique_identifier($old_elm_details, $unique_id);
        }
        return  $this->success('Success', 200, $msg_arr);

	} catch(\Exception $e) {
		//DB::rollback();

		return  $this->failure('Failed',500,$e);
	}
}


public function upload_generic_form_files(Request $request) {
    
    try { 
        $form_data = $request->all();
        $metadata=false;
        if(isset($form_data['metadata']) && $form_data['metadata']=='true') {
            $validator = Validator::make($request->all(), [
                'emt_id'      => 'required',
                'form_id'      => 'required',
            ]);
            $metadata=true;
        }else {
            $validator = Validator::make($request->all(), [
                'emt_id'      => 'required',
                'form_id'      => 'required',
                'article_flow_id'      => 'required',
                'article_id'      => 'required',
            ]);
            
        }

        if ($validator->fails()) {
            return  $this->warning('Warnings',200,$validator->errors(),'warning');
        }
        $article_id= ((!$metadata) && isset($form_data['article_id'])) ? $this->decrypt_data($form_data['article_id']):null;
        $article_flow_id=((!$metadata) && isset($form_data['article_flow_id'])) ? $this->decrypt_data($form_data['article_flow_id']):null;

        $result=array();
        $this->current_user = $this->get_current_user_details();
        $form_data = $request->all();

        if( isset($form_data['author_response_edit_flw_id']) && $form_data['author_response_edit_flw_id']!= '' && $this->current_client->functionality->cfty_edit_author_response_form == 'y') {
            $article_flow_id = $form_data['author_response_edit_flw_id'];
        }
        $form_id=$this->decrypt_data($form_data['form_id']);
        $elemnt_id=$this->decrypt_data($form_data['emt_id']);
        $jnlcode=$form_data['jnl_code'];
        $jnlid=$this->decrypt_data($form_data['jnlid']);
        $attachment_file = $form_data['file'];
        $stage_type = $form_data['stage_type'];
        $dynamic_status = isset($form_data['dynamic_status']) ? $form_data['dynamic_status'] :'n';
        $dynamic_index = isset($form_data['dynamic_index']) ? $form_data['dynamic_index'] :'';;
        $group_id = $form_data['group_id'] ?? null;
        $dynamic_id = $form_data['dynamic_id'] ?? 0;
        $stage_repeat_count=0;
        if($stage_type=='author_submission') {
            $subflow_id=Article_flow::check_articlesubmission($article_id)->aflw_id;
            $article_flow_id=$subflow_id;
        }

        if(!$metadata) {
            //get journal and article type details
		    $get_article_data = Articles::get_article_data($article_id);
            $article_flow_details = Article_flow::get_single_record('aflw_stage_repeat_count',"aflw_id={$article_flow_id}");
            $stage_repeat_count=$article_flow_details->aflw_stage_repeat_count;
        }   

        if((!empty($get_article_data) && $get_article_data->art_article_upload_path != '') || $metadata) {
			$element_dets = Generic_form_elements::get_single_record('emt_file_max_cnt',"emt_id={$elemnt_id}" );

            if($metadata) {
                $journal = Journals::get_single_record('jnl_journal_code', "jnl_id = '{$jnlid}' ");
                $formatted_journal_code = '_' . $journal->jnl_journal_code;
                $generic_form_data = Article_generic_form_data::get_single_record('*',"gdata_atf_id={$form_id} and gdata_atfemt_id={$elemnt_id} and gdata_dynamic_id = {$dynamic_id} ","", $formatted_journal_code);
                // Task #3393 Metadata custom form fields should be able to delete
                $metadata_path=$this->get_metadatafilepath();   
                $generic_data = Generic_forms::get_single_record_with_bind_cond('gncf_metadata_status,gncf_form_type', array('gncf_id'=>$form_id) );
                if(!empty($generic_data)) {
                    if($generic_data->gncf_metadata_status=='s'){
                        $metadata_path=$this->get_metadatafilepath('s');
                    }
                }  
                $path=$journal->jnl_journal_code.'/'.$metadata_path;
                
            } else {
                $journal_code = $get_article_data->jnl_journal_code;
                $formatted_journal_code = '_' . $journal_code;
                $generic_form_data = Article_generic_form_data::get_single_record('*',"gdata_art_id={$article_id} and gdata_atf_id={$form_id} and  gdata_artflw_id ={$article_flow_id} and gdata_atfemt_id={$elemnt_id} and gdata_artflw_stage_repeat_count={$stage_repeat_count} and gdata_dynamic_id = {$dynamic_id}","", $formatted_journal_code);
                $path = $get_article_data->art_article_upload_path;
                $articletype_code = $get_article_data->artp_abbr_article_type;
            }            
            $file_array = array();
			if (!empty($generic_form_data) > 0) {
                $file_array = json_decode($generic_form_data->gdata_data);
                if($dynamic_status!='y') {
					if($element_dets->emt_file_max_cnt <= count($file_array)){
                        $msg_arr['msg']=customTrans('customform.gen_files_exceed');
                        return  $this->warning('Warnings',200,$msg_arr,'warning');
					}
                }
            }

            // start -- set the options for file upload
			// thumbnail veson not required
			$options['image_versions'] = array(
				// The empty image version key defines options for the original image:
				'' => array(
					// Automatically rotate images based on EXIF meta data:
					'auto_orient' => true
			));


			// start -- append the application id if present in post data to the upload path


            $section = '';
            $supp_files_path = '';

            $name = $attachment_file->getClientOriginalName();
            

            $uploaded_file_details = $this->upload_file_handler($path, $attachment_file, $name);
            if ($uploaded_file_details['error'] == FALSE) {

            //get article generic form data
            /*$generic_form_data = Article_generic_form_data::get_single_record('*',"gdata_art_id={$article_id} and gdata_atf_id={$form_id} and  gdata_artflw_id ={$article_flow_id} and gdata_atfemt_id={$elemnt_id} and gdata_artflw_stage_repeat_count={$article_flow_details->aflw_stage_repeat_count} and gdata_dynamic_id = {$dynamic_id} ","", $formatted_journal_code);
            */
            $file_id_arr = array();
            $order_no = 1;
            if (!empty($generic_form_data)) {
                $file_id_arr = json_decode($generic_form_data->gdata_data);
                if($dynamic_status=='y') {
                    foreach($file_id_arr as $key=>$value){
                        //echo $key;
                    }

                    //$order_no =
                } else {
                    $order_no = count($file_id_arr) + 1;
                }

            }

            $upload_file_name = $uploaded_file_details['name'];

            $uploaded_folder_path = $path;


            //insert data into rvw_article_attachment_files
            $data_list = array(
                'agf_name' => $upload_file_name,
                'agf_order' => $order_no,
                'agf_file_size' => $this->file_size_convert_to_kb($uploaded_file_details['size']),
                'agf_original_upload_path' => $uploaded_folder_path,
                'agf_dynamic_fileorder' => $dynamic_index,
                'agf_file_uploaded_date' => date('Y-m-d H:i:s')
            );

            $id = Generic_form_files::insert_record($data_list, $this->current_user);

            if($dynamic_status=='y') {
                $keyfound=0;
                foreach ($file_id_arr as $key => $values) {
                    // echo "Key: $key\n";
                    // echo "Values: ";

                    // Loop through the values in the array
                    foreach ($values as $value) {
                        // echo "$value ";

                        // Push the values into a new key in the result array
                        if (!isset($resultArray[$key])) {
                            $resultArray[$key] = [];
                        }
                        $resultArray[$key][] = $value;
                    }
                    if($key=='key'.$dynamic_index) {
                        $resultArray[$key][] = $id;
                        $keyfound=1;
                    }

                    // echo "\n\n";
                }
                if ($keyfound==0) {
                    $resultArray['key'.$dynamic_index][] = $id;
                }

            } else {
                $file_id_arr[] = $id;
            }

            if (!empty($generic_form_data)) {
                Article_generic_form_data::update_record(array('gdata_dynamic_status' => $dynamic_status,'gdata_data' => ($dynamic_status=='y') ? json_encode($resultArray):json_encode($file_id_arr)),"gdata_id={$generic_form_data->gdata_id}", $this->current_user, $formatted_journal_code);
                $element_data_id = $generic_form_data->gdata_id;
            } else {
                // start -- manage dependency dependency
                $get_element_data = Generic_form_elements::get_element_details_with_group($elemnt_id);

                if ($get_element_data->emt_dependency_required == 1) {
                    //starting get dependency value //
                    $dependency_elementdata = Generic_form_elements::get_single_record('*',"emt_id={$get_element_data->emt_depending_control}");

                    if($metadata) {
                        $generic_form_depent_ctrl_data = Article_generic_form_data::get_single_record('*',"gdata_atf_id={$form_id} and gdata_atfemt_id={$get_element_data->emt_depending_control} and gdata_artflw_stage_repeat_count={$stage_repeat_count} and gdata_dynamic_id = {$dynamic_id} ","", $formatted_journal_code);
                    }else{
                        $generic_form_depent_ctrl_data = Article_generic_form_data::get_single_record('*',"gdata_art_id={$article_id} and gdata_atf_id={$form_id} and  gdata_artflw_id ={$article_flow_id} and gdata_atfemt_id={$get_element_data->emt_depending_control} and gdata_artflw_stage_repeat_count={$stage_repeat_count} and gdata_dynamic_id = {$dynamic_id} ","", $formatted_journal_code);
                    }                    

                    $dependency_data = $this->generic_form_dependency_data($dependency_elementdata, $generic_form_depent_ctrl_data, $get_element_data);
                    $depend_condition = array(
                        'gdata_art_id' => $article_id,
                        'gdata_atf_id' => $form_id,
                        'gdata_artflw_id' => $article_flow_id,
                        'gdata_gform_title' => $get_element_data->gncf_form_title,
                        'gdata_gfg_id' => $get_element_data->gfg_id,
                        'gdata_group_name' => $get_element_data->gfg_group_name,
                        'gdata_atfemt_id' => $get_element_data->emt_depending_control,
                        'gdata_user_roles' => $get_element_data->emt_user_roles,
                        'gdata_label' => $dependency_elementdata->emt_label,
                        'gdata_data' => is_array($dependency_data['elementvalue'])?implode(',', $dependency_data['elementvalue']):$dependency_data['elementvalue'],
                        'gdata_display_data' => is_array($dependency_data['element_dply_data'])?implode(',', $dependency_data['element_dply_data']):$dependency_data['element_dply_data'],
                        'gdata_artflw_stage_repeat_count' => $stage_repeat_count
                    );

                    if($metadata) {
                        Article_generic_form_data::delete_records("gdata_atf_id={$form_id} and gdata_atfemt_id={$get_element_data->emt_depending_control} and gdata_artflw_stage_repeat_count={$stage_repeat_count} and gdata_dynamic_id = {$dynamic_id}",$formatted_journal_code, $this->current_user);
                    }else {
                        Article_generic_form_data::delete_records("gdata_art_id={$article_id} and gdata_atf_id={$form_id} and  gdata_artflw_id ={$article_flow_id} and gdata_atfemt_id={$get_element_data->emt_depending_control} and gdata_artflw_stage_repeat_count={$stage_repeat_count} and gdata_dynamic_id = {$dynamic_id}",$formatted_journal_code, $this->current_user);
                    }

                    
                    //Article_generic_form_data::insert_record($depend_condition,$this->current_user, $formatted_journal_code);
                }
                // end -- manage dependency dependency
                if($dynamic_status=='y') {
                    $file_id_arr2['key'.$dynamic_index][] = $id;
                }
                $element_data_id = Article_generic_form_data::insert_record(array(
                    'gdata_art_id' => $article_id,
                    'gdata_atf_id' => $form_id,
                    'gdata_artflw_id' => $article_flow_id,
                    'gdata_gform_title' => $get_element_data->gncf_form_title,
                    'gdata_gfg_id' => $get_element_data->gfg_id,
                    'gdata_group_name' => $get_element_data->gfg_group_name,
                    'gdata_atfemt_id' => $elemnt_id,
                    'gdata_user_roles' => $get_element_data->emt_user_roles,
                    'gdata_element_type' => 'file',
                    'gdata_label' => $get_element_data->emt_label,
                    'gdata_data' => ($dynamic_status=='y') ? json_encode($file_id_arr2):json_encode($file_id_arr),
                    'gdata_artflw_stage_repeat_count' => $stage_repeat_count,
                    'gdata_unique_identifier' => $get_element_data->emt_unique_identifier,
                    'gdata_dynamic_status' => $dynamic_status,
                    'gdata_dynamic_id' => $dynamic_id
                ), $this->current_user, $formatted_journal_code);
            }
            $result['insert']=$id;
            $result['gdata_id']=$element_data_id;
            return  $this->success('Success', 200, $result);
            } else {
                return  $this->warning('Warning', 200, 'Upload failed');
            }




        }




    } catch(\Exception $e) {
		//DB::rollback();

		return  $this->failure('Failed',500,$e);
	}



	}


    public function custom_generic_form_files(Request $request) {
        try {
            $form_data = $request->all();
            $metadata=false;
            if(isset($form_data['metadata']) && $form_data['metadata']=='true') {
                $validator = Validator::make($request->all(), [
                    'metadata'      => 'required'
                ]);
                $metadata=true;
            }else {
                $validator = Validator::make($request->all(), [
                    'article_id'      => 'required'
                ]);
            }            
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $List ='';
            $support_docs_record =array();
            $toalattachmentdetails='';
            if(!empty($form_data['file_ids'])) {
                if(gettype($form_data['file_ids']) == 'string'){
                    $form_data['file_ids'] = json_decode($form_data['file_ids']);
                }
                $Array=$form_data['file_ids'];
                if(is_array($Array)) {
                    $List = implode(',', $Array);
                }
            }
            $gdata_id=$form_data['gdata'];
            $stage_type = $form_data['stage_type'];
            $dynamic_status = $form_data['emt_dynamic_status'];
            $dynamic_index = $form_data['dynamic_index'];
            $formid = Rv_decrypt($form_data['formid']);
            $elementid = Rv_decrypt($form_data['elementid']);
            $jnl_code=Rv_decrypt($form_data['jnl_code']);
            $jnl_id=Rv_decrypt($form_data['jnl_id']);
            $article_id = Rv_decrypt($form_data['article_id']);
            $flow_id = Rv_decrypt($form_data['flow_id']);
            $dynamic_id = Rv_decrypt($form_data['dynamic_id']) ?? 0;
            $stage_repeat_count=isset($form_data['stage_repeat_count'])?$form_data['stage_repeat_count']:0;
            $formatted_journal_code = '_' . $jnl_code;
            
            //  sql injunction validation start
    if(!$metadata){
            if($article_id!='') {
                $idarray = array('input'=>$article_id,'type'=>'number','category'=>'art_id');
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['art_id'] != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            } else {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }
            if($flow_id!='') {
                $idarray = array('input'=>$flow_id,'type'=>'number','category'=>'flow_id');
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['flow_id'] != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            } else{
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }
    }

            if($jnl_id!='') {
                $idarray = array('input'=>$jnl_id,'type'=>'number','category'=>'jnl_id');
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['jnl_id'] != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            } else {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }

            if($jnl_code!='') {
                $idarray = array('input'=>$jnl_code,'type'=>'string','category'=>'jnl_code');
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['jnl_code'] != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            } else {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }

            if($formid!='' && $jnl_code!='') {
                $idarray = array('input'=>$formid,'type'=>'number','category'=>'form_id');
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['form_id'] != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            } else {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }

            if($elementid!=''&& $jnl_code!='') {
                $idarray = array('input'=>$elementid,'type'=>'number','category'=>'emt_id','jnl_code'=>$jnl_code);
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            } else {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }

            if($dynamic_id!='') {
                $pattern = '/^[0-9]+$/';
                if(!preg_match($pattern, $dynamic_id) == TRUE) {
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }

                if (!ctype_digit($dynamic_id)) {
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }

            } else {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }

            //  sql injunction validation end

            if($stage_type=='author_submission') {
                $subflow_id=Article_flow::check_articlesubmission($article_id)->aflw_id;
                $article_flow_id=$subflow_id;
            } else {
                $article_flow_id=$flow_id;
            }

            if($metadata){
                $generic_form_data = Article_generic_form_data::get_single_record('gdata_data',"gdata_atf_id={$formid} and gdata_atfemt_id={$elementid} and gdata_dynamic_id = {$dynamic_id}","", $formatted_journal_code);
            }else {
                $generic_form_data = Article_generic_form_data::get_single_record('gdata_data',"gdata_atf_id={$formid} and gdata_art_id={$article_id} and gdata_artflw_id={$article_flow_id} and gdata_atfemt_id={$elementid} and gdata_dynamic_id = {$dynamic_id} and gdata_artflw_stage_repeat_count={$stage_repeat_count} ","", $formatted_journal_code);
            }
            


            if($generic_form_data!='') {
                if($dynamic_status=='y') {
                    $file_id_arr=json_decode($generic_form_data->gdata_data);
                    $keyfound=0;
                    foreach ($file_id_arr as $key => $values) {
                          if($key=='key'.$dynamic_index) {
                            $List = implode(',', $values);
                        }
                    }
                 } else {
                    $Array=json_decode($generic_form_data->gdata_data);
                    $List = implode(',', $Array);
                }
            }

            $date_format = $this->get_platform_date_format($jnl_id);
            $date_format = date_format_map($date_format);

            $date_format = $date_format.' %H:%i:%s';

            if($List!='') {
                $support_docs_record = Generic_form_files::get_all_records('agf_id,agf_label,agf_name,agf_file_size,agf_original_upload_path,DATE_FORMAT(agf_file_uploaded_date, "' . $date_format . '") as agf_file_uploaded_date ', 'agf_id IN (' . $List . ')', 'agf_order');
                $select = "ROUND(sum(`agf_file_size`)/1000,2) AS uploadfilesize,count(`agf_id`) AS totalfile";
                $toalattachmentdetails = Generic_form_files::get_single_record($select,'agf_id IN (' . $List . ')');
            }


            $return_array['totalfileinfo'] = $toalattachmentdetails;
            $return_array['support_docs'] = $support_docs_record;
            $return_array['count_support_docs'] = count($support_docs_record);

            return  $this->success('Success', 200, $return_array);

        } catch(\Exception $e) {
            //DB::rollback();
            return  $this->failure('Failed',500,$e);
        }
    }

    public function remove_generic_files(Request $request) {
        try {
            $form_data = $request->all();
            $metadata=false;
            if(isset($form_data['metadata']) && $form_data['metadata']=='true') {
                $validator = Validator::make($request->all(), [
                    'form'      => 'required',
                    'element'      => 'required'
                ]);
               
                $article_id = null;
                $metadata=true;
            }else {
                $validator = Validator::make($request->all(), [
                    'art_id'      => 'required',
                    'form'      => 'required',
                    'element'      => 'required'
                ]);
            }
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $article_id = ((!$metadata) && isset($form_data['art_id'])) ? Rv_decrypt($form_data['art_id']):null;
            $flow_id = ((!$metadata) && isset($form_data['flow_id'])) ? Rv_decrypt($form_data['flow_id']):null;
            $this->current_user = $this->get_current_user_details();
			$frm_id = Rv_decrypt($form_data['form']);
			$elemnt_id = Rv_decrypt($form_data['element']);
            $jnl_code = Rv_decrypt($form_data['jnl_code']);
            $article_files_arr = $form_data['article_files'];
            $stage_type = $form_data['stage_type'];
            $emt_dynamic_status = isset($form_data['emt_dynamic_status'])?$form_data['emt_dynamic_status']:'n';
            $dynamic_index = isset($form_data['dynamic_index'])?$form_data['dynamic_index']:'0';
            $stage_repeat_count=isset($form_data['stage_repeat_count'])?$form_data['stage_repeat_count']:0;
            $dynamic_id = Rv_decrypt($form_data['dynamic_id']) ?? 0;

            $file_from_editauthor_response = 'n';
            $return_array=array();
            if ($this->current_client->functionality->cfty_edit_author_response_form == 'y') {
                $file_from_editauthor_response = isset($form_data['frm_author_respone_edit_'.$frm_id])? $form_data['frm_author_respone_edit_'.$frm_id] : 'n';
            }

            if(!$metadata) {
                //  sql injunction validation start
                if($article_id!='') {
                    $idarray = array('input'=>$article_id,'type'=>'number','category'=>'art_id');
                    $idvalid=$this->validatesqlinjuction($idarray);
                    if($idvalid['art_id'] != TRUE ){
                        return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
                    }
                } else {
                    return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
                }
            }

            if($jnl_code!='') {
                $idarray = array('input'=>$jnl_code,'type'=>'string','category'=>'jnl_code');
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['jnl_code'] != TRUE ){
                    return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
                }
            } else {
                return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
            }

            if($frm_id!='' && $jnl_code!='') {
                $idarray = array('input'=>$frm_id,'type'=>'number','category'=>'form_id','jnl_code'=>$jnl_code);
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['form_id'] != TRUE ){
                    return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
                }
            } else {
                return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
            }

            if($elemnt_id!=''&& $jnl_code!='') {
                $idarray = array('input'=>$elemnt_id,'type'=>'number','category'=>'emt_id','jnl_code'=>$jnl_code);
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['emt_id'] != TRUE ){
                    return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
                }
            } else {
                return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
            }

            if($dynamic_id!='') {
                $idarray = array('input'=>(int)$dynamic_id,'type'=>'number','category'=>'dynamic_id','jnl_code'=>$jnl_code);
                $idvalid=$this->validatesqlinjuction($idarray);
                if($idvalid['dynamic_id'] != TRUE ){
                    return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
                }
            } else {
                return  $this->warning('Warnings',200,customTrans('viewarticle.invalid_data'),'warning');
            }

            //  sql injunction validation end

            if($metadata) {
                $formatted_journal_code = '_' . $jnl_code;    
                $elem_codition = [
                    'gdata_atf_id' => $frm_id,
                    'gdata_atfemt_id' => $elemnt_id,
                    'gdata_dynamic_id' => $dynamic_id,
                    'gdata_artflw_stage_repeat_count' => $stage_repeat_count,
                    'gdata_posted_by' => $this->current_user['user_id']
                ];


                $metadata_path=$this->get_metadatafilepath();
                $generic_data = Generic_forms::get_single_record_with_bind_cond('gncf_metadata_status,gncf_form_type', array('gncf_id'=>$frm_id) );
                if(!empty($generic_data)) {
                    if($generic_data->gncf_metadata_status=='s'){
                        $metadata_path=$this->get_metadatafilepath('s');
                        // Task #3563 Collecting Supporting Documents for Conference
                        $elem_codition = [
                            'gdata_atf_id' => $frm_id,
                            'gdata_atfemt_id' => $elemnt_id,
                            'gdata_dynamic_id' => $dynamic_id,
                            'gdata_artflw_stage_repeat_count' => $stage_repeat_count
                        ];
                    }
                }  
                $folder_path=$jnl_code.'/'.$metadata_path;
            }else {
                $result_article_data = Articles::get_article_data($article_id);
                $journal_code = $result_article_data->jnl_journal_code;
                $formatted_journal_code = '_' . $journal_code;
    
                $elem_codition = [
                    'gdata_art_id' => $article_id,
                    'gdata_atf_id' => $frm_id,
                    'gdata_atfemt_id' => $elemnt_id,
                    'gdata_dynamic_id' => $dynamic_id,
                    'gdata_artflw_stage_repeat_count' => $stage_repeat_count,
                    'gdata_posted_by' => $this->current_user['user_id']
                ];
                $folder_path=$result_article_data->art_article_upload_path.'/';
            }


            if ($file_from_editauthor_response == 'y') {
                $elem_codition = [
                    'gdata_art_id' => $article_id,
                    'gdata_atf_id' => $frm_id,
                    'gdata_atfemt_id' => $elemnt_id,
                    'gdata_artflw_stage_repeat_count' => $stage_repeat_count
                ];
            }

            if($stage_type=='author_submission') {
                $subflow_id=Article_flow::check_articlesubmission($article_id)->aflw_id;
                $elem_codition['gdata_artflw_id']=$subflow_id;
            }else {
                // TSKbolt 1291 Upload Missing in File Inventory & Upload Field Hidden After Editor Decision in PM Stage
                // Task #3563 Collecting Supporting Documents for Conference
                if(!$metadata) {
                    $elem_codition['gdata_artflw_id']=$flow_id;
                }
            }

			//ger article generic form data
            $generic_form_data = Article_generic_form_data::get_single_record_with_bind_cond("gdata_id,gdata_data,gdata_display_data", $elem_codition,journal_code:$formatted_journal_code);

            if (count($article_files_arr) > 0 && !empty($generic_form_data)) {
				$generic_files = json_decode($generic_form_data->gdata_data);
				$exist_files = array();
				$for_del_files = array();


                if($emt_dynamic_status=='y') {
                    foreach ($generic_files as $key => $values) {
                        if($key=='key'.$dynamic_index) {
                             foreach ($values as $key => $gen_file) {
                                if (in_array($gen_file, $article_files_arr)) {
                                    $for_del_files[] = $gen_file;
                                } else {
                                    $exist_files[] = $gen_file;
                                }
                            }
                        }
                        else {
                        foreach ($values as $key => $gen_file) {
                            $exist_files[] = $gen_file;
                            }
                        }
                    }
                } else {
                    foreach ($generic_files as $key => $gen_file) {
                        if (in_array($gen_file, $article_files_arr)) {
                            $for_del_files[] = $gen_file;
                        } else {
                            $exist_files[] = $gen_file;
                        }
                    }
                }


                $del_files_data = Generic_form_files::get_upload_files($for_del_files);
                Generic_form_files::del_upload_files($for_del_files);

				if (count($exist_files) > 0) {
                    if($emt_dynamic_status=='y') {
                        $resultArray=array();
                        $valueToRemove = implode(',', $for_del_files);
                        foreach ($generic_files as $key => $values) {
                            // echo "Key: $key\n";
                            // echo "Values: ";

                            // Loop through the values in the array
                            foreach ($values as $value) {
                                // echo "$value ";

                                // Push the values into a new key in the result array
                                if (!isset($resultArray[$key])) {
                                    $resultArray[$key] = [];
                                }
                                if($key=='key'.$dynamic_index) {
                                    if($value!=$valueToRemove){
                                        $resultArray[$key][] = $value;
                                    }
                                }else{
                                    $resultArray[$key][] = $value;
                                }
                            }


                            // echo "\n\n";
                        }
                        $files = json_encode($resultArray);


                    } else{
                        $files = json_encode($exist_files);
                        $generic_upload_files = Generic_form_files::get_upload_files($exist_files);
                    }

                    //$generic_upload_files = Generic_form_files::get_all_records('agf_id,agf_label,agf_name,agf_file_size,agf_original_upload_path,agf_file_uploaded_date', 'agf_id IN (' . $files_existed . ')', 'agf_order');
				} else {
					$files = '';
					$generic_upload_files = array();
				}

				if($files != NULL) {
					Article_generic_form_data::update_record(array('gdata_data' => $files),"gdata_id={$generic_form_data->gdata_id} and gdata_artflw_stage_repeat_count={$stage_repeat_count} ",$this->current_user, $formatted_journal_code);
				} else {
					Article_generic_form_data::delete_records("gdata_id={$generic_form_data->gdata_id} and gdata_artflw_stage_repeat_count={$stage_repeat_count} ",$formatted_journal_code);
				}

                $return_array['status'] = 'success';

                /* starting -- delete files */

                $file_path = public_path() . '/storage/uploads/' .$folder_path;
                //   $file_path = APP_DOC_PATH . $folder_path . '/';


                //Upgrade #2293 Manage review uploads
                $aws_path="uploads/" . $folder_path . "/";

                foreach ($del_files_data as $del_file) {
                    $this->remove_fileinfolder($file_path,$del_file->agf_name,$aws_path);
                }
                /* end -- delete files */
                /*$generic_file_html = $this->get_generic_file_list($generic_upload_files, $elemnt_id, $generic_form_data->gdata_id);
                $return_arr['element'] = $elemnt_id;
                $return_arr['file_html'] = $generic_file_html['file_html'];
                $return_arr['total_uploaded_file_size'] = $generic_file_html['total_uploaded_file_size'];*/
                return  $this->success('Success', 200, $return_array);

			} else {
                return  $this->warning('Warnings', 200, 'Cannot delete','warning');
            }





        } catch(\Exception $e) {
            //DB::rollback();

            return  $this->failure('Failed',500,$e);
        }

	}



    public function generic_form_dependency_data($dependency_elementdata, $generic_form_depent_ctrl_data, $get_element_data)
	{
		if ($dependency_elementdata->emt_element_type == 'checkbox')
		{
			$optionvaluechk = json_decode($dependency_elementdata->emt_options);
			$elementvalue = array();
			$element_dply_data = array();

			foreach ($optionvaluechk as $optchk)
			{
				foreach ($optchk as $keychk => $optckresult)
				{
					$optionsck[$keychk] = $optckresult;
				}
			}
			if (!empty($generic_form_depent_ctrl_data))
			{
				$elementvalue[] = $get_element_data->emt_depending_value;
				$element_dply_data[] = $optionsck[$get_element_data->emt_depending_value];

				$exist_chk_depend_data = json_decode($generic_form_depent_ctrl_data->gdata_data);
				if(gettype($exist_chk_depend_data)=="array")
				{
					foreach ($exist_chk_depend_data as $dpt_key => $dpt_value)
					{
						if (!in_array($dpt_key, $temp_value))
						{
							$depend_value[$dpt_key] = $dpt_value;
							$elementvalue[] = $dpt_key;
							$element_dply_data[] = $dpt_value;
						}
					}
				}
			}
			else
			{
				$elementvalue[] = $get_element_data->emt_depending_value;
				;
				$element_dply_data[] = $optionsck[$get_element_data->emt_depending_value];
			}
		}
		elseif ($dependency_elementdata->emt_element_type == 'combobox')
		{
			//If combobox is the input element means getting data text for the corresponding value from db
			$optionvaluecom = json_decode($dependency_elementdata->emt_options);
			$elementvalue = array();
			$element_dply_data = array();
			foreach ($optionvaluecom as $keycom => $optcom)
			{
				foreach ($optcom as $combkey => $optcomresult)
				{
					$optionscom[$combkey] = $optcomresult;
				}
			}

			$elementvalue[] = $get_element_data->emt_depending_value;
			$element_dply_data[] = $optionscom[$get_element_data->emt_depending_value];
		}
		elseif ($dependency_elementdata->emt_element_type == 'radiobutton')
		{
			//If radiobutton is the input element means getting data text for the corresponding value from db
			$optionvaluerad = json_decode($dependency_elementdata->emt_options);
			$elementvalue = array();
			$element_dply_data = array();
			foreach ($optionvaluerad as $keyrad => $optrad)
			{
				foreach ($optrad as $radkey => $optresultrad)
				{
					$optionsrad[$radkey] = $optresultrad;
				}
			}
			$elementvalue[] = $get_element_data->emt_depending_value;
			$element_dply_data[] = $optionsrad[$get_element_data->emt_depending_value];
		}
		else
		{

			$elementvalue = $get_element_data->emt_depending_value;
			$element_dply_data = $get_element_data->emt_depending_value;
		}

		return array(
			'elementvalue' => $elementvalue,
			'element_dply_data' => $element_dply_data,
		);
	}

	public function load_form_groups($groupid, $formid) {
        $elements = Generic_form_elements::get_all_records('*',"emt_gucf_id='{$formid}' and emt_gfg_id ='{$groupid}' " ,'emt_order');
        $form_element_count = count($elements);
		foreach ($elements as $element) {

        }
    }
    
    public function get_allowed_next_stage(Request $request) {

        try {
            $validator = Validator::make($request->all(), [
                'next-stage'      => 'required',
                'jnl_code'      => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }

            $form_data = $request->all();
           // print_r($form_data);die;
            $decison_stage = $form_data['next-stage'];
            $current_buttons = $form_data['next-stage-buttons'];
            $next_stage_assign = $form_data['next-stage-assign'];
            $next_stage_btns_choices = $form_data['next-stage-buttons-choice'] ?? [];
            $this->current_user = $this->get_current_user_details();
            $assignments = array();
            if(!empty($next_stage_assign)) {
                foreach($next_stage_assign as $assign_role) {
                    array_push($assignments, decrypt_link($assign_role));
                }
            }
            $return_arr = array();
            $return_button = array();
            $return_button_rank = array();

        foreach($current_buttons as $key => $allowed_stages) {
            $adv_stage = null;
			$each_stage = substr($allowed_stages, strpos($allowed_stages, "btn") + 3);
            if(count($next_stage_btns_choices) && $next_stage_btns_choices[$key] == 'move_to_advance_selected'){
                $adv_stage = $each_stage;
                $adv_stages = Advance_flow_movement::find($each_stage)?->afm_associated_stage_ids;
                $each_stage = explode(',', str_replace(' ','',$adv_stages))[0];
            }
			$get_current_data = Generic_flows::get_single_record('jwf_stage_type,jwf_child_stages',"jwf_id={$each_stage}");
            if(!empty($get_current_data)) {

			if(in_array($get_current_data->jwf_stage_type,$decison_stage)) {
                if($adv_stage){
                    $return_button_rank['btn'.$adv_stage] = 1;
                }else{
                    $return_button_rank['btn'.$each_stage] = 1;
                }
			} else {
				if(count(json_decode($get_current_data->jwf_child_stages,1)) != 0)  {
					$child_stages_imlode = json_decode($get_current_data->jwf_child_stages);
					$child_stages_for_check = implode(',',$child_stages_imlode);
					$while_intial = TRUE;
					$decision_found = FALSE;
					$new_childs_for_nxt_loop = $child_stages_for_check;
					$roles = array();
					$stages_present = array();
					$child_stages_already_checked = array();
					$return_btn_rank = 2;
					while ($while_intial == TRUE) {
                        $genericflows_table = (new \App\Models\Generic_flows())->getTable();
						$get_fields = 'jwf_id,jwf_stage_type,jwf_child_stages,jwf_disable_status';

                        $sql = 'select '.$get_fields.' from '.$genericflows_table.' where jwf_id IN('.$new_childs_for_nxt_loop.')';
                        $get_child_details =Generic_flows::get_records_by_raw_query($sql);

                        // $query = DB::getQueryLog();
                        // $query = end($query);
                        // print_r($query);exit;

						$new_childs_for_nxt_loop = '';

						if(!empty($get_child_details)) {
							foreach($get_child_details as $ind_data) {
								if(in_array($ind_data->jwf_stage_type,$decison_stage) && $ind_data->jwf_disable_status == 'n') {
									if($decision_found == FALSE) {
                                        if($adv_stage){
                                            $return_button_rank['btn'.$adv_stage] = $return_btn_rank;
                                        }else{
                                            $return_button_rank['btn'.$each_stage] = $return_btn_rank;

                                        }
									}
									$while_intial = FALSE;
									$decision_found = TRUE;
									array_push($stages_present, $ind_data->jwf_stage_type);
								} else {
									if(count(json_decode($ind_data->jwf_child_stages,1)) != 0) {
										$child_stages_arr= json_decode($ind_data->jwf_child_stages);
										foreach($child_stages_arr as $child_stages) {
											if(!in_array($child_stages, $child_stages_already_checked)) {
												$new_childs_for_nxt_loop = $new_childs_for_nxt_loop.','.$child_stages;
												array_push($child_stages_already_checked,$child_stages);
											}
										}
									}
								}
							}

							$return_btn_rank++;

						}

						$new_childs_for_nxt_loop = ltrim($new_childs_for_nxt_loop,',');
						if($new_childs_for_nxt_loop == '')
						{
							$while_intial = FALSE;
						}
					}

				}
			}
        }
		}

        if(!empty($return_button_rank)) {
            $shortest_path = min($return_button_rank);
            foreach($return_button_rank as $stage_id => $node_level) {
			    if($node_level == $shortest_path) {
				    array_push($return_button,$stage_id);
			    }
		    }
	    }


		$next_roles_found = array();
		if(!empty($next_stage_assign) && !empty($return_button)) {
			foreach($return_button as $allowed_stages) {
				$decision_found = TRUE;
				$adv_stage = null;
			    $each_stage = substr($allowed_stages, strpos($allowed_stages, "btn") + 3);
                if(count($next_stage_btns_choices) && $next_stage_btns_choices[$key] == 'move_to_advance_selected'){
                    $adv_stage = $each_stage;
                    $adv_stages = Advance_flow_movement::find($each_stage)?->afm_associated_stage_ids;
                    $each_stage = explode(',', str_replace(' ','',$adv_stages))[0];
                }
				$role_id_arr = array();
				$get_current_data = Generic_flows::get_single_record('jwf_stage_type,jwf_role_id,jwf_child_stages',"jwf_id={$each_stage}" );
				array_push($role_id_arr,$get_current_data->jwf_role_id);
				if(in_array($get_current_data->jwf_stage_type,$decison_stage)) {
					$decision_found = TRUE;
					foreach($assignments as $key => $value) {
						if(in_array($value, $role_id_arr)) {
							if(!in_array($value,$next_roles_found)) {
								array_push($next_roles_found,$value);
							}
						}
					}

				}

				if(count(json_decode($get_current_data->jwf_child_stages,1)) != 0)  {
						$child_stages_imlode = json_decode($get_current_data->jwf_child_stages);
						$child_stages_for_check = implode(',',$child_stages_imlode);
						$while_intial = TRUE;
						$new_childs_for_nxt_loop = $child_stages_for_check;
						$roles = array();
						$stages_present = array();
						$child_stages_already_checked = array();
						while ($while_intial == TRUE) {

							$get_fields = 'jwf_id,jwf_stage_type,jwf_child_stages,jwf_disable_status,jwf_role_id';
                            $genericflows_table = (new \App\Models\Generic_flows())->getTable();

                            $sql = 'select '.$get_fields.' from '.$genericflows_table.' where jwf_id IN('.$new_childs_for_nxt_loop.')';
                            $get_child_details =Generic_flows::get_records_by_raw_query($sql);

							$new_childs_for_nxt_loop = '';

							if(!empty($get_child_details)) {
								foreach($get_child_details as $ind_data) {
									if(in_array($ind_data->jwf_stage_type,$decison_stage) && $ind_data->jwf_disable_status == 'n') {
										$decision_found = TRUE;
									}
									if(count(json_decode($ind_data->jwf_child_stages,1)) != 0) {
										$child_stages_arr= json_decode($ind_data->jwf_child_stages);
										foreach($child_stages_arr as $child_stages) {
											if(!in_array($child_stages, $child_stages_already_checked)) {
												$new_childs_for_nxt_loop = $new_childs_for_nxt_loop.','.$child_stages;
												array_push($child_stages_already_checked,$child_stages);
											}
										}
									}
									if(!in_array($ind_data->jwf_role_id, $role_id_arr)) {
										array_push($role_id_arr,$ind_data->jwf_role_id);
									}
								}

							}

							$new_childs_for_nxt_loop = ltrim($new_childs_for_nxt_loop,',');
							if($new_childs_for_nxt_loop == '') {
								$while_intial = FALSE;
							}
						}

						if($decision_found == TRUE) {
							foreach($assignments as $key => $value) {
								if(in_array($value, $role_id_arr)) {
									if(!in_array($value,$next_roles_found)) {
									  array_push($next_roles_found,$value);
									}
								}
							}
						}
					}

			}
		}

        foreach($next_roles_found as $key => $encrypt_role) {
			$next_roles_found[$key] = encrypt_link($encrypt_role);
		}

		if(!empty($return_button)) {
			$return_arr['status'] = 'success';
			$return_arr['buttons'] = $return_button;
			$return_arr['role'] = $next_roles_found;

		}
        return  $this->success('Success', 200, $return_arr);

        } catch(\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }

	}



//Changing form group title
public function changeorderelements(Request $request) {
    DB::beginTransaction();
    try {
        $form_data = $request->all();
        $groupid                = Rv_decrypt($form_data['groupid']);
        $formid                 = Rv_decrypt($form_data['formid']);
        $ordering_list          = $form_data['ordering_lst'];
        $validator = Validator::make($request->all(), [
            'formid'      => 'required',
            'ordering_lst'      => 'required'
        ]);

        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }
        $this->current_user = $this->get_current_user_details();

        DB::enableQueryLog();

        $res=array();        
        $label_order = 'emt_order';
        $label_id = 'emt_id';
        $i = 1;
        if (count($ordering_list) > 0) {
            foreach ($ordering_list as $art_order) {
                $order = $i;
                
                $data = array(
                    $label_order => $i
                );

                $update_condition = "{$label_id}={$art_order[$label_id]} AND {$label_order}!={$order}";
                if(isset($form_data['isDragged'])&&$form_data['isDragged'] == true){
                    Generic_form_elements::update_record($data, $update_condition, $this->current_user);
                }
                $i++;
            }

        }
        DB::commit();
        return $this->success('Success',200,$res);

    } catch (\Exception $e) {
        // DB::rollback();
        //print_r($e);
        return $this->failure('Failed', 500, $e);
    }
}
public function get_flag_details(Request $request)
{
    try {
        $data = $request->all();
        $formtype = $data['formtype'] ?? null;
        $formid = isset($data['formid']) ? $this->decrypt_data($data['formid']) : null;

        if (!$formtype || !$formid) {
            // Handle missing formtype or formid gracefully
            $criteria=array('flag_type'=>'a','flag_status'=>'y');
            $all_flags = Flags::get_all_records_with_bind_cond('flag_id,flag_name', $criteria,'',array(), "flag_name");
            return $this->success('Success', 200, ['article_flags' => $all_flags]);
        }
        $distinctValues =[];
        $form_ids = Generic_flows::where('jwf_stage_type', $formtype)
            ->whereJsonContains('jwf_forms', $formid)
            ->pluck('jwf_forms')
            ->flatMap(function ($item) {
                $decoded = json_decode($item, true);
                return is_array($decoded) ? $decoded : [];
            })
            ->unique()
            ->values();

        if (!$form_ids->contains($formid)) {
            // Form ID not found in the workflow
            $criteria=array('flag_type'=>'a','flag_status'=>'y');
            $all_flags = Flags::get_all_records_with_bind_cond('flag_id,flag_name', $criteria,'',array(), "flag_name");
            return $this->success('Success', 200, ['article_flags' => $all_flags]);
        }
        $valid_flags = Generic_form_elements::whereIn('emt_gucf_id', $form_ids)
            ->whereNotNull('emt_flag_id')
            ->where(DB::raw('JSON_LENGTH(emt_flag_id)'), '>', 0)
            ->pluck('emt_flag_id')
            ->map(function ($flagId) {
                return json_decode($flagId, true);
            })
            ->filter() // Filter out null/empty results from json_decode
            ->toArray();

            foreach ($valid_flags as $outerArray) {
                foreach ($outerArray as $innerArray) {
                    foreach ($innerArray as $key => $value) {
                        $distinctValues[$key] = $value; // Use keys to avoid duplicates
                    }
                }
            }
            //If you want to reindex the array.
            $distinctArray = array_unique($distinctValues);
            $distinctValues = array_values($distinctArray);
            // $distinctArray = array_unique($distinctValues);
            $criteria=array('flag_type'=>'a','flag_status'=>'y');
            $all_flags = Flags::get_all_records_with_bind_cond('flag_id,flag_name', $criteria,'',array(), "flag_name");
            $filteredFlags = $all_flags->filter(function ($flag) use ($distinctArray) {
                return !in_array($flag->flag_id, $distinctArray);
            })->values()->sortBy('flag_id')->values();
            return $this->success('Success', 200, ['article_flags' => $all_flags->toArray(), 'used_flags' => $distinctValues,'used_flags' => $distinctValues]);
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
}
public function usedflags($id){

    $sql= "SELECT emt_gucf_id,emt_flag_id,emt_id FROM `rvw_generic_form_elements` WHERE `emt_gucf_id`={$id} AND `emt_flag_id` IS NOT NULL";
    $cur_empt_flg_count = Generic_form_elements::get_records_by_raw_query($sql);
    $distinctValues =[];
    $form_ids = Generic_flows::whereJsonContains('jwf_forms',$id)
    ->pluck('jwf_forms')
    ->flatMap(function ($item) {
        $decoded = json_decode($item, true);
        return is_array($decoded) ? $decoded : [];
    })
    ->unique()
    ->values();
    $valid_flags = Generic_form_elements::whereIn('emt_gucf_id', $form_ids)
    ->whereNotNull('emt_flag_id')
    ->where('emt_gucf_id', '!=', $id)
    ->where(DB::raw('JSON_LENGTH(emt_flag_id)'), '>', 0)
    ->pluck('emt_flag_id')
    ->map(function ($flagId) {
        return json_decode($flagId, true);
    })
    ->filter() // Filter out null/empty results from json_decode
    ->toArray();
    foreach ($valid_flags as $outerArray) {
        foreach ($outerArray as $innerArray) {
            foreach ($innerArray as $key => $value) {
                $distinctValues[$key] = $value; // Use keys to avoid duplicates
            }
        }
    }
    $distinctArray = array_unique($distinctValues);
    $distinctValues = array_values($distinctArray );
    return $distinctArray; 

}


public function check_generic_form_unique_identifier($form_id,$element_id,$form_type,$identifier,$element,$element_type,$select_identifier) {
		$result['msg'] = '';
        DB::enableQueryLog();
		//Task 647 Remove static form from TrAction stages
		$generic_config = 'clients.' . $this->current_client->clnt_client_code . '.generic_form_identifiers.identifier';
        $generic_form_identifier = Config::get($generic_config);
		
		$system_identifier = $this->check_system_identifier($generic_form_identifier,$identifier,$form_type,$element,$element_type);

		if ($form_type == 'feedback_form' || $system_identifier == TRUE) {
            $criteria = "emt_unique_identifier= ? AND emt_id != ? AND emt_gucf_id=?";
            $bind_arr[]=$identifier;
            $bind_arr[]=$element_id;
            $bind_arr[]=$form_id;
			$unique_identifier = Generic_form_elements::get_single_record('count(*) as count',$criteria,NULL,'',NULL,$bind_arr); 
            // $query = DB::getQueryLog();
            // $query = end($query); 
            // print_r($query);exit;           
			if ($unique_identifier->count != 0) {
				$result['msg'] = customTrans('customform.dup_sys_identifier');
			}
			if ($select_identifier == 'custom') {
				if (array_key_exists($identifier, $generic_form_identifier)) {
					$result['msg'] = customTrans('customform.custom_in_system');
				}
			}
		} else {
			if (array_key_exists($identifier, $generic_form_identifier)) {
				$result['msg'] = customTrans('customform.custom_in_system');
			} else {

        $generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
        $generic_forms_table = (new \App\Models\Generic_forms())->getTable();

        $tables = array(
            'main_table' => $generic_form_elements_table,
            'join_table' => array(
                $generic_forms_table => array($generic_form_elements_table . '.emt_gucf_id', $generic_forms_table . '.gncf_id', "inner")
            )
        );
        $el_select = 'count(*) as count';
        $el_criteria = '';
        $el_criteria = '(emt_unique_identifier = "'.$identifier.'" AND emt_gucf_id = '.$form_id.' AND emt_id != '.$element_id.') OR ';
        $el_criteria .= '(emt_unique_identifier = "'.$identifier.'" AND gncf_form_type != "'.$form_type.'")';
        $unique_identifier = Generic_form_elements::get_results_using_joins($tables, $el_select, $el_criteria, 'all');			
            if (count($unique_identifier) > 0 && $unique_identifier[0]->count != 0) {
                $result['msg'] = customTrans('customform.dup_identifier');
            }
        }

        $email_tag_config = $this->configure_email_tags();
            foreach ($email_tag_config as $category => $tags) {
                if($category!='variable_tags') {
                    if (in_array($identifier, $tags)) {
                        $result['msg'] = customTrans('customform.tag_in_email');
                        break;
                    }
                }
			}
		}

		return $result;
	}
	
	//Task 647 Remove static form from TrAction stages   
	public function check_system_identifier($generic_form_identifier,$identifier,$form_type,$element,$element_type) {
		$system_identifier = FALSE;
		if(isset($generic_form_identifier[$identifier])) {
			$sys_ident_arr = $generic_form_identifier[$identifier];
			$aply_stages = $sys_ident_arr['apply_stages'];
			$aply_elements = $sys_ident_arr['emelemt'];
			$aply_types = $sys_ident_arr['type'];
			if(count($aply_types) > 0) {
				$aply_types = explode(',', $aply_types[0]);
			}
			
			if(in_array($form_type, $aply_stages) == TRUE && in_array($element, $aply_elements) == TRUE) {
				$system_identifier = TRUE;
				if($element == 'textbox' && in_array($element_type, $aply_types) == FALSE)
					$system_identifier = FALSE;
			}
		}
		
		return $system_identifier;
	}
}
