<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Tours_master;
use App\Models\Tour_details;
use DB;
use Config;
use \stdClass;

class Manage_Help_tour_Api extends Controller
{
    public function show_help_tour(Request $request)
    {    
        try{
            $usr_terms_status       =   FALSE;
            $usr_protection_status  =   FALSE;
            //Specify the path of page separated by commas for which the popup have to be shown on first load
            $popup_on_first_load    =    array("home");
            $return_arr['status']   =   'error';

            if (isset($this->current_client->functionality->cfty_enable_help_tour) && $this->current_client->functionality->cfty_enable_help_tour == 'y') {
                $post_data  =   $request->all();
                if(isset($post_data['path']) && $post_data['path'] != '') {
                    $path       =   decrypt_link($post_data['path']);
                    $tour_steps =   $post_data['tour_steps'];

                    $logged_user=   $this->get_current_user_details();
                    $user_id    =   $logged_user['user_id'];

                    $get_user_terms = User::get_single_record('usr_terms_condition','usr_id = '.$user_id);
                    $get_user_dataprotection = User::get_single_record('count(*) as cnt', 'usr_id = '.$user_id.' AND usr_dnd_marketing IS NULL AND usr_dnd_share_data IS NULL');
                    if ($this->current_client->functionality->cfty_show_terms_conditions == 'y')
                    {
                        if(isset($get_user_terms->usr_terms_condition) && $get_user_terms->usr_terms_condition == 'n')
                        {
                            $usr_terms_status = TRUE;
                        }
                    }
                    if($this->current_client->functionality->cfty_enable_data_protection == 'y')
                    {
                        if($get_user_dataprotection->cnt > 0)
                        {
                            $usr_protection_status = TRUE;
                        }
                    }
                    if($path =='edit-article' && (isset($post_data['corerole']) && $post_data['corerole'] == "author"))
                    {
                    $path ="create-article"; 
                    }
                    if($usr_terms_status == FALSE && $usr_protection_status == FALSE)
                    {
                        $tour_id    =   '';
                        $tour_data  =   Tours_master::is_tour_record_exists($path, $user_id); 
                        $non_saved  =   $this->fetch_tour_steps_that_need_to_see($path, $user_id, $tour_steps[$path]);
                        
                        $return_arr['popup_on_first_load']  =   in_array($path, $popup_on_first_load)? "Y" : "N";
                        if ($tour_data->tour_id == NULL) { 
                            DB::beginTransaction();
                            $tour_details   =   array(                       
                                                    'tour_posted_by' => $user_id,
                                                    'tour_page_path' => $path ,
                                                    'tour_steps_cnt' => 0
                                                );
                            $tour_id    =   Tours_master::insert_record($tour_details); 
                            DB::commit(); 
                        } else {
                            $tour_id    =   $tour_data->tour_id;
                            // $steps_cnt  =   $tour_data->tour_steps_cnt;

                            // if($steps_cnt == count($tour_steps[$path])) {
                            //     $non_saved  =   array();
                            // }
                            if(in_array($path, $popup_on_first_load) == true && $tour_data->tour_cnt == 0) {
                                $return_arr['popup_on_first_load']  =   "Y";
                            } else {
                                $return_arr['popup_on_first_load']  =   "N";
                            }
                        }
                        $return_arr['status']               =   'success';
                        $return_arr['tour_id']              =   $tour_id;
                        $return_arr['pending']              =   $non_saved;
                    }
                }
            }
            echo json_encode($return_arr);
        }
        catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }
    
    /*
    *  save the steps of help tour in tour details tbl
    */
    public function save_help_tour(Request $request)
    {    
        try{ 
            $return_arr['status']   =   'error';
            if (isset($this->current_client->functionality->cfty_enable_help_tour) && $this->current_client->functionality->cfty_enable_help_tour == 'y') {
                $post_data          =   $request->all();
                $logged_user        =   $this->get_current_user_details();
                $user_id            =   $logged_user['user_id'];
                $path               =   decrypt_link($post_data['path']);   
                if($path =='edit-article' && (isset($post_data['corerole']) && decrypt_link($post_data['corerole']) == "author"))
                {
                    $path ="create-article"; 
                }
                $tour_id            =   decrypt_link($post_data['tour_id']);
                $type               =   decrypt_link($post_data['type']);
                $curr_tour_key      =   decrypt_link($post_data['current_tour_key']);
                $tour_steps         =   $post_data['steps'];
                $steps_cnt          =   0;
                     
                DB::beginTransaction();
                $tourdtls_id        =   Tour_details::checkif_tour_element_exists($tour_id, $curr_tour_key);                      
                
                if(empty($tourdtls_id)) 
                {
                    $tour_details = array(
                        'tourdt_tour_id' =>  $tour_id,
                        'tourdt_tour_key' => $curr_tour_key,
                        'tourdt_posted_by' => $user_id
                    );           
                    Tour_details::insert_record($tour_details);  

                    //Check for tour start   
                    $tour_data  =   Tours_master::is_tour_record_exists($path, $user_id); 
                    $steps_cnt  =   $tour_data->tour_steps_cnt + 1;
                    Tours_master::update_record(array('tour_steps_cnt' => $steps_cnt), array('tour_posted_by' => $user_id, 'tour_page_path' =>$path));
                } else {
                    if($type == 'tour:end')
                    {
                        foreach($tour_steps as $tours => $step)
                        {
                            $tourdtls_id        =   Tour_details::checkif_tour_element_exists($tour_id, $step['key']);
                            if(empty($tourdtls_id)) 
                            {
                                $tour_details = array(
                                    'tourdt_tour_id' =>  $tour_id,
                                    'tourdt_tour_key' => $step['key'],
                                    'tourdt_posted_by' => $user_id
                                );           
                                Tour_details::insert_record($tour_details);
                            }
                        }
                        $steps_cnt  =   count($tour_steps);
                        Tours_master::update_record(array('tour_steps_cnt' => $steps_cnt), array('tour_posted_by' => $user_id, 'tour_page_path' =>$path));
                    }
                }
                $return_arr['status']   =   'success'; 
                DB::commit();
            }
            echo json_encode($return_arr);
        }
        catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }
    
    /*
    * fetch the tour steps that need to see in a path
    * $path - page 
    * $user_id - current user
    * $tour_steps - each steps in a page tour
    */
    public function fetch_tour_steps_that_need_to_see($path, $user_id, $tour_steps) {
        $tour_data      =   Tours_master::get_tour_data($path, $user_id);
        $saved          =   array();
        $non_saved      =   array();
        if (count($tour_steps) > 0) { 
            $objtourArr     =       (array)$tour_data->toArray();
            $savedtourArr   =       json_decode(json_encode($objtourArr), true);
            foreach($savedtourArr as $key) {
                $saved[]    =   $key['tourdt_tour_key'];
            }
            //check is there any tour steps need to be saved
            foreach($tour_steps as $key) {
                $key    =   $key['key'];
                if (!in_array($key, $saved)) {
                    $non_saved[]    =   $key;
                }
            }
        }
        return $non_saved;
    }
}
