<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Traits\InstituteSearchEngineTrait;

class Manage_Institution_Search_Api extends Controller
{
    use InstituteSearchEngineTrait;
    // use JournalUserfunctionTrait;
    // use SubmissionTrait;
    public function getInstitutionIntegration(Request $request)
    {
        try {
            $current_client = $this->current_client;
            // $post_data = $request->all();
            // $author_affiliation_data = $post_data['affiliationDetails'];
            $return_arr = array();
            $api_type = 'default';

                if ($current_client->modules->mdl_ringgold == 'y' && $current_client->modules->mdl_ror == 'y') {
                    $api_type = 'both';
                } elseif ($current_client->modules->mdl_ringgold == 'y') {
                    $api_type = 'ringgold';
                } elseif ($current_client->modules->mdl_ror == 'y') {
                    $api_type = 'ror';
                }
            $return_arr = array(
                'api_type' => $api_type
            );
            return $this->success('success', 201, $return_arr);
        } catch (\Exception $e) {
          
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function executeInstitutionSearch(Request $request)
    {
        try {
            $post_data = $request->all();
            $search_in_ror = FALSE;
            if (isset($post_data['selected_api']) && $this->current_client->modules->mdl_ror == 'y' && $this->current_client->modules->mdl_ringgold == 'y') {
                if ($post_data['selected_api'] == 'ror') {
                    $search_in_ror = TRUE;
                }
            } else {
                if ($this->current_client->modules->mdl_ror == 'y') {
                    $search_in_ror = TRUE;
                }
            }
            $ror_institution_found = FALSE;
            if($search_in_ror == TRUE){
                $response_array = (object) array();
			    $response = $this->search_organisation($post_data,$search_in_ror);
                if(isset($response['number_of_results']) && $response['number_of_results'] > 0)
                {
                    $output_data = array();
                    $total_count = $response['number_of_results'];
                    foreach($response['items'] as $single_institutions)
                    {
                        $inst_arr = array();
                        $inst_arr['identifier'] = $single_institutions['id'];
                        $inst_arr['name'] = $single_institutions['name'];
                        $inst_arr['country'] = (strlen($single_institutions['country']['country_code']) > 0) ? $single_institutions['country']['country_code'] : '';
                        $inst_arr['postCode'] = (strlen($single_institutions['addresses'][0]['postcode']) > 0) ? $single_institutions['addresses'][0]['postcode'] : '';
                        $inst_arr['city'] = (strlen($single_institutions['addresses'][0]['city']) > 0) ? $single_institutions['addresses'][0]['city'] : '';
                        $inst_arr['state'] = (strlen($single_institutions['addresses'][0]['state']) > 0) ? $single_institutions['addresses'][0]['state'] : '';
                        $output_data[] = $inst_arr;
                    }
                    $response_array->response = $output_data;
                    $ror_institution_found =TRUE;
                }
            }else{
                //ringgold
                $response = $this->search_organisation($post_data,false);
                $response_array = (json_decode($response));
                // print_r($ror_institution_found);die;
            }
            if (isset($response_array->response) && !empty($response_array->response)){
                if ($ror_institution_found == TRUE){
                    $formated_response = (object) array();
                    $formated_response->status = 'success';
                    if($ror_institution_found == TRUE){
                        $formated_response_array = $response_array->response;
                        // if($total_count > 20){
                            $links = '';
                            $formated_response->total_page_count = ceil($total_count / 20);
                            $formated_response->page_div = $links;
                        // }
                    }
                    else
                    {
                        $formated_response_array[0] = $response_array->response;
                    }
                    $formated_response->response = $formated_response_array;
                }
                elseif ($ror_institution_found == false){
                    $formated_response = (object) array();
                    $formated_response->status = 'success';
                    // print_r($response_array->response);die;
                    $formated_response_array = $response_array->response;
                    $formated_response->response = $formated_response_array;
                    // $response = json_encode($formated_response, true);
                }
            }
            else
            {
                $formated_response = (object) array();
			    $formated_response->status = 'failed';
                $formated_response->msg = customTrans('institution_search_engine.search_institution_msg');
                // $response = json_encode($formated_response, true);
            }
            return $this->success($formated_response->status, 200, $formated_response);
            // print_r($response->status);die;

        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
}
