<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Config;
use DB;
use App\Models\Articles;
use App\Models\Article_keywords;
use App\Models\Article_flow;
use App\Http\Traits\StagemovementTrait;
use App\Models\Roles;
use phpDocumentor\Reflection\Types\Null_;
use Illuminate\Support\Facades\URL;
use App\Http\Traits\SubmissionTrait;
use Illuminate\Support\Str;
use App\Http\Traits\ArticlelistTrait;
use App\Http\Traits\RolesConfigTrait;
use  App\Http\Traits\UserDataTrait;
use App\Http\Traits\InstituteSearchEngineTrait;
//use App\Models\Article_types;
use App\Models\Attachment_files;
use App\Models\Article_pdf;
use App\Http\Traits\GeneralEmailTrait;
use \stdClass;

use DateTime;
class Manage_Invitation_Api extends Controller
{
    use StagemovementTrait;
    use SubmissionTrait;
    use ArticlelistTrait;
    use RolesConfigTrait;
    use UserDataTrait;
    use GeneralEmailTrait;
    use InstituteSearchEngineTrait;

public function confirm_invitation(Request $request)
{
    try
    {
    $post_data = $request->all();

    $validator = Validator::make($request->all(), [
        'jnl_code' => 'required',
        'jnl_id' => 'required',
        'core_role' => 'required',
        'art_flow_id'=> 'required'
    ]);

    if ($validator->fails()) {
        return  $this->failure('Failed', 422, $validator->errors());
    }
    $Articles=new \App\Models\Articles;
    $Journals=new \App\Models\Journals();
    $Article_flow=new \App\Models\Article_flow();
    $Generic_flows=new \App\Models\Generic_flows();
    $Stage_email_templates=new \App\Models\Stage_email_templates();
    $Article_types=new \App\Models\Article_types();
    $User_to_journals=new \App\Models\User_to_journals();
    $Journal_settings=new \App\Models\Journal_settings();
    $Authors=new \App\Models\Authors;
    $Email_send_log=new \App\Models\Email_send_log;
    $Reviewed_privilaged_users=new \App\Models\Reviewed_privilaged_users;
    $Stage_email_tmpl_reference=new \App\Models\Stage_email_tmpl_reference;
       $jnl_code=$post_data['jnl_code'];
       $jnl_id=$post_data['jnl_id'];
       $core_role=$post_data['core_role'];

		$this->current_user =$this->get_current_user_details();
		$today = date('Y-m-d H:i:s', time());
		$due_date = new DateTime($today);
		$user_role_manage_tab = '';
		$bulksubmission=FALSE;
		// Changed if($this->input->post) : it returns NULL and go to else condition.
		if (isset($post_data) && !empty($post_data))
		{
			$current_sub_status_id = decrypt_link($post_data['art_flow_id']);
			$status = $post_data['status'];
			$bulksubmission=$post_data['bulksubmission'];
            if($bulksubmission=='true')
            {
                $bulksubmission=TRUE;
            }
            else
            {
                $bulksubmission=FALSE;
            }
		}


        $input_arr = array('input' => $current_sub_status_id,'type'=> 'number');
        $status_id_validate = $this->Rv_validator($input_arr);
		if($status_id_validate != TRUE){
			return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
		}
		$user_id = $this->current_user['user_id'];
        $res=$this->checkmultipleaccept($current_sub_status_id);
        if($res['multiplestatus']==false) {
            $warn_data['msg']='Already accepted/rejected';
            return $this->success('warning',200,$warn_data,'warning');
        }
        else if($res['uninvitestatus']==false)
        {
            $warn_data['msg']=$res['message'];
            return $this->success('warning',200,$warn_data,'warning');  
        }

		$condition ="aflw_usr_id={$user_id} AND aflw_id={$current_sub_status_id}";

		$data['aflw_status'] = $status;
		$data['aflw_accepted_date'] = $today;
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
		$select = 'art_id, art_artp_id,art_title,art_stage_submission_method,aflw_source_assignment_id, aflw_id,artp_article_type, jnl_journal_name, jwf_id, jwf_stage_type,jwf_stage_name, jwf_status_name,jwf_tat_complete, aflw_parent_flow_id,artp_abbr_article_type,jwf_role_id,aflw_reviewer_added_by_stage_status';
		$article_details = $Articles::get_article_details($select,"aflw_id={$current_sub_status_id}" ,NULL ,'n' ,FALSE ,NULL);

		$article_details = $article_details[0];
		$valid_post_data['art_flow_id'] = encrypt_link($current_sub_status_id);
		$valid_post_data['article_id'] = encrypt_link($article_details->art_id);
		$valid_post_data['data_choice'] = 'accept';

		$this->validate_duplicate_entry($valid_post_data,NULL);

		// $due_date = $due_date->modify('+' . $article_details->jwf_tat_complete . ' days');
		// $due_date = $due_date->format('Y-m-d H:i:s');
		// $data['aflw_due_date'] = $due_date;
        $data['aflw_due_date'] = $this->get_due_date_for_article($article_details->art_id, $article_details->jwf_tat_complete);

		//for article proposal, due date is not suppose to update at time of author submission.
		if($article_details->jwf_stage_type == "author_submission" && $article_details->art_stage_submission_method == 'b' )
			unset($data['aflw_due_date']);
        $return_data['pre_review_status'] = FALSE;
        if($article_details->aflw_reviewer_added_by_stage_status == 'p')
        {
            $data['aflw_due_date'] = NULL;
            $return_data['pre_review_status'] = TRUE;
        }
		$update_status = $Article_flow::update_record($data, $condition,$this->current_user);
		/* To track reviewed privilaged user is accepted invitation */
		$privillaged_user = $this->has_journal_privilege($jnl_code, $this->current_user['user_id'], $article_details->art_artp_id);
		if ($article_details->jwf_stage_type != "review"  && $privillaged_user == TRUE)
		{
			$this->insert_to_reviewed_privilaged($user_id, $article_details->art_id, $this->current_user);
		}

		if ($update_status)
		{
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */

			$returned_date = NULL;
            $flow_id=$article_details->aflw_parent_flow_id;
            if($bulksubmission==true) {
    
                $flow_id=$article_details->aflw_id;
            } 
            if($article_details->aflw_reviewer_added_by_stage_status != 'p')
            {
			if ($article_details->aflw_parent_flow_id != NULL)
			{
				$parent_stage = $Article_flow::get_stage_details("aflw_id={$article_details->aflw_parent_flow_id}", 'aflw_stage_min_users');
				$criteria = 'aflw_status IN (\'a\', \'c\') AND aflw_parent_flow_id = ' . $article_details->aflw_parent_flow_id . ' AND  aflw_art_id =' . $article_details->art_id;
				$current_count = $Article_flow::get_single_record('count(aflw_id) as assignments', $criteria);
				//	$aflw_stage_min_user_cnt = $article_details->jwf_no_of_min_users;
				if ($parent_stage->aflw_stage_min_users >= 0)
					$aflw_stage_min_user_cnt = $parent_stage->aflw_stage_min_users;

				if ($aflw_stage_min_user_cnt == $current_count->assignments)
					$returned_date = $today;
			}


            $flow_id=$article_details->aflw_parent_flow_id;


            if($bulksubmission==true) {

                $flow_id=$article_details->aflw_id;
            }
			//start - update parent stage accept date
			$Article_flow::update_record(array(
				'aflw_accepted_date' => $today,
				'aflw_returned_date' => $returned_date),"aflw_id={$flow_id}",$this->current_user);
			//end - update parent stage accept date

            $custom_data=array(
                // 'current_count'=>$current_count,
            'stage_etmp_action' => 'accepted',
            );

            $email_data=array(
                'type'=>'stage',
                'action'=>'send',
                'email_with_login'=>TRUE,
                'user_id'=> $user_id,
                'aflw_id'=>$article_details->aflw_id,
                'custom_data'=>$custom_data,
                'jnl_user_role'=>array(
                    'core_role'=>$core_role,
                    // 'role_name'=>$jnl_array['role_name'],
                    'jnl_id'=>$jnl_id,
                    'jnl_journal_code'=> $jnl_code
                ),
            );
            $send = $this->master_email_details($email_data);

			$return_data['msg'] = customTrans('accept_decline_invite.invitation_accept');
			$return_data['status'] = 'success';
            $return_data['bulksubmission'] = $bulksubmission;
            $return_data['typecode'] = $article_details->artp_abbr_article_type;
            $return_data['encrypt_artid'] = $this->encrypt_data($article_details->art_id);
            $return_data['encrypt_flowid'] = $this->encrypt_data($article_details->aflw_id);
		}
		else
		{
			//$return_data['msg'] = lang('cmn_db_error');
			$return_data['msg'] =customTrans('accept_decline_invite.invitation_not_accept');
		}
        return $this->success('success',200,$return_data);

    }
}
    catch (\Exception $e) {

        return  $this->failure('Failed', 500, $e);
    }
}

public function suggest_reviewer_by_declined_user(Request $request) {
    try {

        $suggest_reviewer = $request->all();
        $validator = Validator::make($request->all(), [
            'article_id' => 'required',
            'art_flw_id' => 'required',
        ]);

        if($validator->fails()) {
            return  $this->failure('Failed',200,$validator->errors());
        }

        $article_id = decrypt_link($suggest_reviewer['article_id']);
        $aflow_id = decrypt_link($suggest_reviewer['art_flw_id']);
        parse_str(decrypt_link($suggest_reviewer["select"]), $_GET);
        $bulksubmission = isset($_GET['bulksubmission']) ? $_GET['bulksubmission'] : false;
        $bulksubmission = ($bulksubmission === 'true' || $bulksubmission === true) ? true: false;
        $article_id = isset($_GET['article_id']) ? $_GET['article_id'] : '';
        $aflow_id = isset($_GET['status_id']) ? $_GET['status_id'] : '';
        $jnl_code=$suggest_reviewer['jnl_code'];
        DB::beginTransaction();
        $existrecord =$this->checkValidRecord($article_id, $aflow_id,$jnl_code);
        if($existrecord===false) {
            $warn_data['msg']=customTrans('accept_decline_invite.invitation_invalid_data');
            return $this->success('warning',200,$warn_data,'warning');
        }

        $res=$this->checkmultipleaccept($aflow_id);
        if($res['multiplestatus']===false) {
            $warn_data['msg']='Already accepted/rejected';
            return $this->success('warning',200,$warn_data,'warning');
        }elseif($res['uninvitestatus']===false) {
            $warn_data['msg']=$res['message'];
            return $this->success('warning',200,$warn_data,'warning');
        }

        $suggest_flag=$suggest_reviewer['hdn_suggest_reviewer'];
        $multiple_reviewerstatus=$suggest_reviewer['multiplereviwerstatus'];
        
        if (!empty($article_id)) {
            if (isset($suggest_reviewer['suggest_reviewer'][0]) && $suggest_reviewer['suggest_reviewer'][0] == 'y') {
                $suggest_flag='y';
            } else {
                $suggest_flag='n';
            }

            $suggest_flag=$suggest_reviewer['check_suggest_reviewer']==true ? 'y': 'n';
            $valid_post_data['art_flow_id'] = encrypt_link($aflow_id);
            $valid_post_data['article_id'] = encrypt_link($article_id);
            $valid_post_data['data_choice'] = 'decline';
            $this->validate_duplicate_entry($valid_post_data,null);
            // $multiple_reviewerstatus is set to true by default, but it may change based on client funct.
            if($multiple_reviewerstatus===true ) {
                $addreviewstatus=$this->addnewreviwerdecline($article_id, $aflow_id,$suggest_reviewer,$suggest_flag,$bulksubmission);
                if($addreviewstatus['success']===true && isset($addreviewstatus['user_addnew']) && $addreviewstatus['user_addnew']=='add_new') {
                    DB::commit();
                    return $this->success('success',200,$addreviewstatus);
                } elseif($addreviewstatus['success']===false) {
                    return $this->success('warning',200,$addreviewstatus,'warning');
                }
                $multireviewstatus=$this->multiplereviwerdecline($article_id, $aflow_id,$suggest_reviewer,$suggest_flag,$bulksubmission);
                if($multireviewstatus['success']===true) {
                    DB::commit();
                    return $this->success('success',200,$multireviewstatus);
                } else {
                    return $this->success('warning',200,$multireviewstatus,'warning');
                }
            }

        } else {
            $return_data['msg']=customTrans('accept_decline_invite.invitation_invalid_data');
            return $this->success('warning',200,$return_data);
        }
    } catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
    }
}
public function sugestion_reviewr_new($jnl_id,$user_id,$aflow_id,$reviewer_id,$article_id)
{
    try
        {
    $this->current_user=$this->get_current_user_details();
    $aflw_ids= $aflow_id;
    $today = date('Y-m-d H:i:s', time());
    $User_to_journals = new \App\Models\User_to_journals();
    $Article_reviewers=new \App\Models\Article_reviewers();
    $Articles=new \App\Models\Articles;
    $select = 'jwf_role_id';
    $article_details = $Articles::get_article_details($select,"aflw_id={$aflow_id}");
    $article_details = $article_details[0];
    $role_id = $article_details->jwf_role_id;

    $reviewer_role = Roles::get_single_record_with_bind_cond('role_id', array(
        'role_assigned_role' => 'reviewer'));
        $user_role_detail = array(
            'usrj_jnl_id' => $jnl_id,
            'usrj_usr_id' => $user_id,
            'usrj_role_id' => $role_id,
            'usrj_artp_id' => NULL,
            'usrj_invite' => 'n'
        );
        $role_in_jrnl = $role_in_artp = FALSE;
    $check_role_exist_condtn = array(
        'usrj_jnl_id' => $jnl_id,
        'usrj_usr_id' => $user_id,
        'usrj_role_id' => $role_id,
        'usrj_artp_id' => NULL
    );
    $jrnl_role = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $check_role_exist_condtn);
    if (!empty($jrnl_role) && $jrnl_role->usrj_id > 0)
        $role_in_jrnl = TRUE;
        $article_detls = $Articles::get_article_data($article_id);
    $check_role_exist_condtn['usrj_artp_id'] = $article_detls->artp_id;
    $artp_role = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $check_role_exist_condtn);
    if (!empty($artp_role) && $artp_role->usrj_id > 0)
        $role_in_artp = TRUE;

        $user_role_details = array(
            'usrj_jnl_id' => $jnl_id,
            'usrj_usr_id' => $user_id,
            'usrj_role_id' => $role_id,
            'usrj_artp_id' => NULL,
            'usrj_invite' => 'n'
        );

        if ($role_in_jrnl == FALSE)
        {
            $user_role_id = $User_to_journals::insert_record($user_role_details, $this->current_user);
        }
        //register user as article type reviewer
        $user_role_details['usrj_artp_id'] = $article_detls->artp_id;
        if ($role_in_artp == FALSE)
        {
            $user_role_id = $User_to_journals::insert_record($user_role_details, $this->current_user);
        }
        $flow_data = Article_flow::get_single_record_with_bind_cond('*', array(
            'aflw_id' => $aflow_id));
        if ($flow_data != NULL)
        {
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(($flow_data->aflw_source_assignment_id != NULL || $flow_data->aflw_source_assignment_id != 0) && ($flow_data->aflw_assignment_type_id != NULL || $flow_data->aflw_assignment_type_id != 0) )
            {
                $aflw_data['aflw_source_assignment_id'] = $flow_data->aflw_source_assignment_id;
                $aflw_data['aflw_assignment_type_id'] = $flow_data->aflw_assignment_type_id;
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            $aflw_data['aflw_usr_id'] = $user_id;
            $aflw_data['aflw_art_id'] = $article_id;
            $aflw_data['aflw_parent_flow_id'] = $flow_data->aflw_parent_flow_id;
            $aflw_data['aflw_status'] = 'u';
            $aflw_data['aflw_assigned_date'] = $today;
            $aflw_data['aflw_jwf_id'] = $flow_data->aflw_jwf_id;
            $aflw_data['aflw_level'] = $flow_data->aflw_level;
            $aflw_ids = Article_flow::insert_record($aflw_data, $this->current_user);
        }
        $reviewer_data = $Article_reviewers::update_record(array(
            'sorw_suggestion_accepted' => 'y',
            'sorw_aflw_id' => $aflw_ids,
            'sorw_rvwr_deeplink_token' => '',
            'sorw_suggested_user_id' => $flow_data->aflw_usr_id
            ), array(
            'sorw_id' => $reviewer_id), $this->current_user);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
}

public function decline_invitation(Request $request) {
        try {

            $Article_flow=new \App\Models\Article_flow;
            $Reject_reasons=new \App\Models\Reject_reasons();
            $post_data=$request->all();
            parse_str(decrypt_link($post_data["select"]), $_GET);

            $jnl_code = $post_data['jnl_code'];
            $art_flw_id=isset($_GET['status_id']) ? $_GET['status_id'] : '';
            $article_id=isset($_GET['article_id']) ? $_GET['article_id']: '';
            $bulksubmission = isset($_GET['bulksubmission']) ? $_GET['bulksubmission'] : FALSE;
            $bulksubmission = ($bulksubmission === 'true' || $bulksubmission === true) ? TRUE: FALSE;

            $show_tc_popup = TRUE;
            if (isset($_GET['show_user_terms_condition_modal']) && $_GET['show_user_terms_condition_modal'] == 'hide') {
                $show_tc_popup = FALSE;
            }


            $data['bulksubmission'] = $bulksubmission;
            $data['article_flow_data'] = $Article_flow::get_stage_details("aflw_id={$art_flw_id}", 'jwf_stage_type,aflw_art_id,aflw_id,aflw_parent_flow_id,aflw_usr_id');


            $condition="rjct_reason_reviewers='n' AND rjct_inactive='n'";
            if($bulksubmission == TRUE) {
                $condition="rjct_reason_reviewers='i' AND rjct_inactive='n'";
            } elseif ($data['article_flow_data']->jwf_stage_type == 'review') {
                $condition="rjct_reason_reviewers='y' AND rjct_inactive='n'";
            }

            $data['all_reject_reasons'] = $Reject_reasons::get_all_records('rjct_id,rjct_reason,rjct_suggest_flag', $condition);
            // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
            $data['client_fieldvalid']= $this->get_clientfieldrequired_functionalities();
            $data['show_user_terms_condition_modal'] = $show_tc_popup;

		return $this->success('success',200,$data);
    } catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
    }
}
    public function get_user_details_reviewer(Request $request)
    {
    try
    {
        $User=new \App\Models\User;
        $User_affiliation=new \App\Models\User_affiliations();
        $Article_flow=new \App\Models\Article_flow();
        $Authors=new \App\Models\Authors();
        $Country=new \App\Models\Country();
        $this->current_user=$this->get_current_user_details();
        $post_data=$request->all();
        $email = $post_data['email'];
        $jnl_id=decrypt_link($post_data['jnl_id']);
        $jnl_standalone=$post_data['jnl_standalone'];
        $article_id = decrypt_link($post_data['article_id']); //exclude article authors
        $art_flw_id = isset($post_data['art_parent_flw_id']) && $post_data['art_flw_id']!='' ?decrypt_link($post_data['art_flw_id']):'';
        $art_parent_flw_id = isset($post_data['art_parent_flw_id']) && $post_data['art_parent_flw_id']!='' ?decrypt_link($post_data['art_parent_flw_id']):'';
        
        $declined_by = $this->current_user['user_id']; //exclude declined user
        $exclude_usr_ids = ($declined_by != '') ? $declined_by : '';
        $jnl_id = ($jnl_standalone == 'y') ? $jnl_id : null;
        $condition = "usr_email='" . $email . "' and (`usr_roles` NOT LIKE '%sudo%' OR `usr_roles` IS NULL)";
        $condition .= " AND usr_id NOT IN (" . $exclude_usr_ids . ")";
        $user_id = '';
        // TASK #5861 When a reviewer declines the review invitation, they should be able to suggest multiple alternative reviewers. Currently, only one suggestion is allowed.
        $suggest_flag=isset($post_data['check_suggest_reviewer']) && $post_data['check_suggest_reviewer']==true ? 'y': 'n';
        $error_flag = FALSE;
        $return = array();
        $cur_user_aff = array();
        $hasuser=FALSE;
        $userdetails=array();
        $user_data = $User::get_user_by_email_journal($condition, $jnl_id);

        $author_flag = FALSE;
        $author_error_msg = '';
        $document_module = FALSE;
        if(isset($this->current_client->modules->mdl_review_for_doc) && $this->current_client->modules->mdl_review_for_doc == 'y')
        {
        $document_module = TRUE;
        }

        if ($article_id != '' && isset($user_data[0])&& !empty($user_data) && $document_module == FALSE)
        {
            $article_authors = $Authors::get_all_records('auth_usr_id',"auth_art_id={$article_id}");
            foreach ($article_authors as $authors)
            {
                if ($authors->auth_usr_id == $user_data[0]->usr_id)
                {
                    $author_flag = TRUE;
                }
            }
        }

        //  TASK #8886 Type Error occurs when attempting to suggest and add an already shortlisted reviewer under "Suggest Another Reviewer" while declining a review invitation.
        $return['country_list'] = $Country::get_all_records('*',"cnt_id !='0'",'cnt_country');
        $return['author_flag'] = $author_flag;
        $return['titles'] = $this->UserConfigdata('titles')['titles'];
        $return['affiliation_types']=Config::get('clients.'.$this->current_client->clnt_client_code.'.aff_config.user_affiliation_type');





        if ($author_flag == TRUE)
        {
            $user_data = "";
            $author_error_msg =customTrans('accept_decline_invite.invitation_author_reviewer');
            $error_flag = TRUE;
            $return['msg'] = $author_error_msg;
            return $this->success('success',200,$return);
        }
// TASK #5861 When a reviewer declines the review invitation, they should be able to suggest multiple alternative reviewers. Currently, only one suggestion is allowed.
        if($exclude_usr_ids!='') {
            //Validate the current user email id given.
            $currentusr_details = $User::get_single_record('usr_id,usr_first_name,usr_email,usr_status, usr_id AS user_id',"usr_id={$exclude_usr_ids} and usr_email='{$email}'");
            if(!empty($currentusr_details)){
                $user_data = "";
                $author_error_msg =customTrans('accept_decline_invite.author_email_unable_touse');
                $error_flag = TRUE;
                $return['msg'] = $author_error_msg;
                return $this->success('success',200,$return);
            }
        }

        // TASK #5861 When a reviewer declines the review invitation, they should be able to suggest multiple alternative reviewers. Currently, only one suggestion is allowed.
        if (!empty($user_data)&&isset($user_data[0]) && $author_flag == FALSE) {

            if (isset($suggest_flag) && $suggest_flag == 'y') {
                $journals_id=$post_data['jnl_id'];
                $Journal = new \App\Models\Journals;
                $journal_data = $Journal::get_single_record('jnl_journal_code,jnl_journal_name,jnl_logo', "jnl_id = '{$journals_id}' ");
                if ( $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' && $suggest_flag== 'y') {
                        
                    //Validate the reviewer because the user has already participated in a post-review stage.
                    $msg=$this->ValidateReviewerparticipated_postreviewstage($article_id,$declined_by,$user_data[0]->usr_id,$journals_id);
                    if(!empty($msg)) {
                        $author_error_msg =$msg;
                        $error_flag = TRUE;
                        $return['msg'] = $author_error_msg;
                        return $this->success('success',200,$return);
                    }
                    //Validate the reviewer because the user has only one role.
                    $msg=$this->ValidateReviewerhasonlyonerole($article_id,$user_data[0]->usr_id,$journals_id,$journal_data->jnl_journal_code);
                    if(!empty($msg)){
                        $author_error_msg =$msg;
                        $error_flag = TRUE;
                        $return['msg'] = $author_error_msg;
                        return $this->success('success',200,$return);
                    }
        
                    //Validate The assigned role of the reviewer should be changed before proceeding for flawless processing of this article.
                    $msg=$this->ValidateReviewerassignedroles($article_id,$user_data[0]->usr_id,$journals_id,$journal_data->jnl_journal_code);
                    if(!empty($msg)){
                        $author_error_msg =$msg;
                        $error_flag = TRUE;
                        $return['msg'] = $author_error_msg;
                        return $this->success('success',200,$return);
                    }
        
                }
        
        
                //Validate reviewer already exist in the article.
                $msg=$this->ValidateRevieweralreadyexist($article_id,$user_data[0]->usr_id,'','',$art_parent_flw_id);
                if(!empty($msg)){
                    $author_error_msg =$msg;
                    $error_flag = TRUE;
                    $return['msg'] = $author_error_msg;
                    return $this->success('success',200,$return);
                }
                // TASK #8320 Able to shortlist an inactive user through the 'Suggest Reviewer' option after declining a review invitation
                $user_record_status = $User::get_single_record('usr_id,usr_first_name,usr_last_name,usr_status,usr_terms_condition',"usr_id={$user_data[0]->usr_id}");

                if ($user_record_status->usr_status != "a" && $user_record_status->usr_status != "w") {
                    $author_error_msg =customTrans('accept_decline_invite.author_email_unable_touse');
                    $error_flag = TRUE;
                    $return['msg'] = $author_error_msg;
                    return $this->success('success',200,$return);
                }
        
            }




            if($error_flag===false) {


            $displayarray=array();
            $displayarray['user_id']=$user_data[0]->usr_id;
            $displayarray['salutation']=TRUE;
            $displayarray['fullname_only']=TRUE;
            $displayarray['journal_id']=$jnl_id;
            $displayarray['article_id']=$article_id;
            $selected_user_name = $this->get_user_display_name($displayarray);
            $us_details = $User::get_single_record('usr_id,usr_first_name,usr_email,usr_status, usr_id AS user_id',"usr_id={$user_data[0]->usr_id}");
            $userdetails['fullname']=$selected_user_name['fullname'];
            $userdetails['email']=protect_email($user_data[0]->usr_email);
            $userdetails['user_id']=$user_data[0]->usr_id;
            $userdetails['user_status']=$us_details->usr_status;
            $hasuser = TRUE;
            $user_id = $user_data[0]->usr_id;

            $cur_user_aff = $User_affiliation::get_all_records('*',"usaff_user_id={$user_id}");
            $user_id = encrypt_link($user_id);

            }

        }
        $return['user_data'] =$userdetails;
        $return['affiliations'] = $cur_user_aff;
        $return['msg'] = $author_error_msg;
        $return['user_id'] = $user_id;
        $return['hasuser'] = $hasuser;

        return $this->success('success',200,$return);
    }
        catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
    }

    public function checkmultipleaccept($flow_id) {
        try {
            $Generic_flows = (new \App\Models\Generic_flows())->getTable();
            $roles_table = (new \App\Models\Roles())->getTable();
            $returnarray['multiplestatus']=true;
            $returnarray['uninvitestatus']=true;
            $flowdata=Article_flow::get_single_record_with_bind_cond('aflw_status,aflw_jwf_id',array('aflw_id'=>$flow_id));
            $tables = array(
            'main_table' => $Generic_flows,
            'join_table' => array(
                $roles_table => array($Generic_flows . '.jwf_role_id', $roles_table . '.role_id')
               
            ));
            $select='role_assigned_role';
            $criteria = "jwf_id={$flowdata->aflw_jwf_id}";
            $rolename = Roles::get_results_using_joins($tables, $select, $criteria, 'all');
            if(!empty($flowdata)){
                if($flowdata->aflw_status=='u')
                {
                    if($rolename[0]->role_assigned_role == 'author')
                    {
                    $returnarray['message']=customTrans('accept_decline_invite.revoke_author_invitation');
                    }
                    else if($rolename[0]->role_assigned_role == 'reviewer')
                    {
                        $returnarray['message']=customTrans('accept_decline_invite.revoke_reviewer_invitation');
                    }
                    else{
                        $returnarray['message']=customTrans('accept_decline_invite.revoke_invitation');
                    }
                    $returnarray['uninvitestatus']=false;
                }
                else if($flowdata->aflw_status!='i'){
                    $returnarray['multiplestatus']=false;
                }
            }
           
            return $returnarray;

        } catch(\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

}
