<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\RemoteConnectionTrait;
use App\Models\Journals;
use App\Models\Volumes;
use App\Models\Issues;
use App\Models\Article_types;
use App\Models\Articles;
use App\Models\Issue_management;
use App\Models\Issue_attachments;
use App\Models\Journal_metadata;
use App\Models\Attachment_files;
use App\Models\Email_templates;
use App\Models\Article_flow;
use App\Models\Email_send_log;
use App\Models\Issue_final_upload_files;
use IDCT\Networking\Ssh\SftpClient;
use IDCT\Networking\Ssh\Credentials;
use Config;
use DB;
use stdClass;
use ZipArchive;
use RecursiveIteratorIterator;
use RecursiveDirectoryIterator;
use Response;
use Illuminate\Support\Facades\URL;
class Manage_Issues_Api extends Controller
{
    use UtilityTrait;
    use WorkflowTrait;
    use RemoteConnectionTrait;
     /*
    get pagination
    commited date :-  18-11-2022
    Request type :- POST
    */
    public function index(Request $request)
    {   
        //test commit
		try {
            $validator = Validator::make($request->all(), 
                [
                    'jnl_id' => 'required'
                ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }

			$post_data= $request->all();
			$current_user = $this->get_current_user_details();
            /* Getting Pagination data */
			$result_array = [];
            $sort_field = $post_data['sort_field'] ?? 'vol_id';
            $sort_order = $post_data['sort_order'] ?? 'asc';
            $limit = $post_data['per_page'] ?? 10;
            $jnl_id = isset($post_data['jnl_id'])?Rv_decrypt($post_data['jnl_id']):NULL;
            $search_filter = $post_data['search_filter'];
            $criteria = 'vol_jnl_id = ' . $jnl_id;
            if (!empty($search_filter)) {
                foreach($search_filter as $key => $val)
                {
                    $criteria .= " AND $key LIKE '%$val%'";
                    if ($key !== array_key_last($search_filter)) {
                        $criteria .= " AND";
                    }
                }
            }
            $select = "*";
            $result_array = Volumes::get_paginated_records($select, $criteria, $sort_field, $sort_order, $limit);
            return $this->success('success',200,$result_array);
		} 
        catch (exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
      /*
    save data.
    commited date :-  11-11-2022
    Request type :- POST
    */
    public function saveVolume(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $post_data['vol_title'] = isset($post_data['vol_title'])?Rv_decrypt($post_data['vol_title']):'';
            $post_data['vol_jnl_id'] = isset($post_data['vol_jnl_id'])?Rv_decrypt($post_data['vol_jnl_id']):''; 
            $validator = Validator::make($post_data, 
                [
                    'vol_title' => 'required|regex:/(^([0-9a-zA-z. ]+)(\d+)?$)/u',
                    'vol_jnl_id' => 'required'
                ],
                [
                    'vol_title.required' => 'volume_title_required',
                    'vol_title.regex' => 'volume_title_invalid_char',
                    'vol_jnl_id.required' => 'volume_journal_required',
                ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
            $post_data['vol_title'] = trim(preg_replace("/\s+/", " ",$post_data['vol_title']));
            $data = array(
				'vol_title' => trim($post_data['vol_title']),
				'vol_jnl_id' => $post_data['vol_jnl_id']

            );
            if (isset($post_data['vol_id']) && $post_data['vol_id'] != '') { 
                $vol_id = Rv_decrypt($post_data['vol_id']);
                $duplicate_check = $this->checkUniqueVolume($post_data['vol_title'], $post_data['vol_jnl_id'], $post_data['vol_id']);
                if($duplicate_check)
                {
                    return $this->warning('warning',200, ['vol_title' => 'volume_exist']);
                }
                $criteria = 'vol_id="' . $vol_id . '"';					
				$result = Volumes::update_record($data,$criteria, $this->current_user);
            }
            else
            {
                $duplicate_check = $this->checkUniqueVolume($post_data['vol_title'], $post_data['vol_jnl_id']);
                if($duplicate_check)
                {
                    return $this->warning('warning',200, ['vol_title' => 'volume_exist']);
                }
                $result = Volumes::insert_record($data, $this->current_user);
            }
           
            return $this->success('success',200,$result);
        }
        catch (exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
     /*
    get single data
    commited date :-  13-11-2022
    Request type :- POST
    */
    public function checkUniqueVolume($data, $jnl_id, $id=NULL)
	{
		$volume_title = $data;
        $result = false;			
		if ($volume_title)
		{	
            if($id != NULL)
            {
                $id = Rv_decrypt($id);
                $criteria = 'vol_title = "' .$volume_title. '" AND vol_id != "' .$id. '" AND vol_jnl_id = "'.$jnl_id.'"';	
            }
            else
            {
                $criteria = 'vol_title = "' .$volume_title. '" AND vol_jnl_id = "'.$jnl_id.'"';	
            }
			$result_array = Volumes::get_all_records('*', $criteria);
			if (count($result_array) > 0)
			{
				$result = true;
			}
			else
			{
				$result = false;
			}
		}
		return $result;
	}
    public function getVolume(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), 
                [
                    'vol_id' => 'required'
                ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
            $post_data = $request->all();
            $vol_id = Rv_decrypt($post_data['vol_id']);
            if(!is_numeric($vol_id)) {
                $msg_arr[]='Somthing went wrong';
                return  $this->warning($msg_arr,200,'','warning');
            }	
            $criteria = 'vol_id = "' .$vol_id. '"';
            $result = Volumes::get_single_record('vol_id, vol_title', $criteria);
            if($result)
            {
                return $this->success('success',200,$result);
            }
            else
            {
                return  $this->warning('Failed',500);
            }
            
        }
        catch (exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function deleteVolume(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), 
            [
                'volume_id' => 'required'
            ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
            $post_data = $request->all();
            $vol_id = Rv_decrypt($post_data['volume_id']);
            $this->current_user = $this->get_current_user_details();
            $criteria = "vol_id='{$vol_id}'";
            $result = Volumes::delete_records($criteria,"",$this->current_user);
            if($result)
            {
                return $this->success('success',200,$result);
            }
            else
            {
                return  $this->warning('Failed',500);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function getAllIssues(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), 
            [
                'volume_id' => 'required'
            ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
			$form_data= $request->all();	
			$this->current_user = $this->get_current_user_details();
            // $special_issue_col_header = $this->config->item('special_issue')['col_header'];
            $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
            $issue_config_data = Config::get($issue_management_config);
            //issue types.
            $special_issue_types = $issue_config_data['special_issue_type'];
            //issue status.
            $issue_status = $this->Utility('issue_status')['issue_status'];
            $jnl_id = Rv_decrypt($request->jnl_id);
            $date_format = $this->get_platform_date_format($jnl_id);
            //$result->iss_due_date = date($date_format, strtotime($result->iss_due_date));
            /* Getting Pagination data */
			$result_array = [];
            $sort_field = $form_data['sort_field'] ?? 'iss_id';
            $sort_order = $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 5;
            $search_filter = $form_data['search_filter'];
            $volume_id = Rv_decrypt($form_data['volume_id']);
            $criteria = "iss_vol_id = '$volume_id'";
            if (!empty($search_filter)) {
                foreach($search_filter as $key => $val)
                {
                    if (isset($search_filter[$key]) && $search_filter[$key] != '') {
                        if($key == 'iss_special_issue')
                        {
                            if($key == 'iss_special_issue' && $val != 'a')
                            {
                                $criteria .= ' AND ';
                                $criteria .= "$key = '$val'";
                            }
                           
                        }
                        else if($key == 'iss_status')
                        {
                            $criteria .= ' AND ';
                            $criteria .= "$key = '$val'";
                        }
                        else
                        {
                            $criteria .= ' AND ';
                            $criteria .= "$key LIKE '%$val%'";
                        }
                       
                    }
                    
                    
                }
            }
            $select = "*";
			/* start --- Checking roles table author and journal admin roles are present 
		 	* if not present then insert */
			
            $result_array = Issues::get_paginated_records($select, $criteria, $sort_field, $sort_order, $limit);
            foreach($result_array as $key => $val)
            {
                if($val->iss_special_issue == 'y')
                {
                    $val->iss_special_issue = 'Yes';
                } 
                else
                {
                    $val->iss_special_issue = 'No';
                }
                $val->iss_status_key = $val->iss_status;
                $val->iss_status_val = $issue_status[$val->iss_status];
                $val->iss_status = $val->iss_status_val . ' on '.date($date_format, strtotime($val->iss_status_date));
                $val->iss_due_date = date($date_format, strtotime($val->iss_due_date));
                $val->iss_posted_date = date($date_format, strtotime($val->iss_posted_date));
            }
            return $this->success('success',200,$result_array);
		} 
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function getIssueData(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), 
                [
                    'journal_id' => 'required',
                    'volume_id' => 'required'
                ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }

            $journal_id = Rv_decrypt($request->journal_id);
            $volume_id = Rv_decrypt($request->volume_id);
            $volume_title = '';
            $this->current_user = $this->get_current_user_details();
            $criteria = "artp_jnl_id = '$journal_id'";
            $article_types = Article_types::get_all_records("artp_id as value, artp_article_type as label", $criteria);
            $volume = Volumes::get_all_records("vol_title", 'vol_id='.$volume_id);
            if($volume)
            {
                $volume_title = $volume[0]->vol_title;
            }
            $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
            $issue_config_data = Config::get($issue_management_config);
            $special_issue_types = $issue_config_data['special_issue_type'];
            $issue_status = $this->Utility('issue_status')['issue_status'];
            $data = array(
                'issue_types' => $special_issue_types,
                'article_types' => $article_types,
                'issue_statuses' => $issue_status,
                'volume_title' => $volume_title
            );
            return $this->success('success',200,$data);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function saveIssue(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
            $issue_config_data = Config::get($issue_management_config);
            //issue types.
            $special_issue_types = $issue_config_data['special_issue_type'];
            //issue status.
            $issue_status = $this->Utility('issue_status')['issue_status'];
            $post_data = $request->all();
                $validator = Validator::make($post_data, 
                    [
                        'iss_number' => 'required|regex:/(^([0-9 ]+)(\d+)?$)/u',
                        'iss_title' => 'required',
                        'iss_due_date' => 'required',
                        'iss_page_limit' => 'required',
                        'iss_special_issue' => 'required',
                        'iss_art_type' => ['required_if:iss_special_issue,y'],
                        'iss_start_date' => ['required_if:iss_special_issue,y'],
                        'iss_soft_end_date' => ['required_if:iss_special_issue,y'],
                        'iss_hard_end_date' => ['required_if:iss_special_issue,y'],
                        'vol_id' => 'required'
                    ],
                    [
                        'iss_number.required' => 'iss_number_required',
                        'iss_number.regex' => 'iss_number_invalid',
                        'iss_title.required' => 'iss_title_required',
                        'iss_due_date.required' => 'iss_due_date_required',
                        'iss_page_limit.required' => 'iss_page_limit_required',
                        'iss_special_issue.required' => 'iss_special_issue_required',
                        'iss_art_type.required_if' => 'iss_art_type_required',
                        'iss_start_date.required_if' => 'iss_start_date_required',
                        'iss_soft_end_date.required_if' => 'iss_soft_end_date_required',
                        'iss_hard_end_date.required_if' => 'iss_hard_end_date_required',
                        'vol_id.required' => 'vol_id_required'
                    ]
                );
                if ($validator->fails()) {
                        return $this->failure('error',200,$validator->errors());
                }
                $article_types_allowed =  $post_data['iss_art_type'];
                if($post_data['iss_description'] == NULL)
                {
                    $post_data['iss_description'] = ' ';
                }
                $data = array(
                    'iss_vol_id' => Rv_decrypt($post_data['vol_id']),
                    'iss_number' => $post_data['iss_number'],
                    'iss_title' => $post_data['iss_title'],
                    'iss_description' => $post_data['iss_description'],
                    'iss_special_issue' => $post_data['iss_special_issue'],
                    'iss_status' => array_search('Open', $issue_status),
                    'iss_status_date' =>  date("Y-m-d"),
                    'iss_page_limit' => $post_data['iss_page_limit'],
                    'iss_due_date' => $post_data['iss_due_date'],
                    'iss_start_date' => $post_data['iss_start_date'],
                    'iss_soft_end_date' => $post_data['iss_soft_end_date'],
                    'iss_hard_end_date' => $post_data['iss_hard_end_date'],
                    'iss_art_type' => $article_types_allowed,
                );
                $vol_id = Rv_decrypt($post_data['vol_id']);
                if (isset($post_data['issue_id']) && $post_data['issue_id'] != '') { 
                    $issue_id = Rv_decrypt($post_data['issue_id']);
                    $criteria = "iss_id = '$issue_id'";
                    $issue_data = Issues::get_single_record("iss_id,iss_status", $criteria);
                    if($issue_data && $issue_data->iss_status == 'c')
                    {
                        return  $this->warning('warning',200,array('error' => 'issue_closed'));
                    }
                    $duplicate_check = $this->checkUniqueIssue($post_data['iss_title'], $vol_id, $issue_id);
                    if($duplicate_check)
                    {
                        return $this->warning('warning',200, ['iss_title' => 'issue_exist']);
                    }
                    $criteria = 'iss_id="' . $issue_id . '"';						
                    $result = Issues::update_record($data,$criteria, $this->current_user);
                }
                else
                {
                    $duplicate_check = $this->checkUniqueIssue($post_data['iss_title'], $vol_id);
                    if($duplicate_check)
                    {
                        return $this->warning('warning',200, ['iss_title' => 'issue_exist']);
                    }
                    $result = Issues::insert_record($data, $this->current_user);
                }
            
                return $this->success('success',200,$result);
            }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function getIssue(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), 
            [
                'issue_id' => 'required',
                'jnl_id' => 'required',
                'jnl_code' => 'required'
            ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }

            $issue_id = Rv_decrypt($request->issue_id);
            $jnl_id = Rv_decrypt($request->jnl_id);
            $jnl_code = Rv_decrypt($request->jnl_code);
            $this->current_user = $this->get_current_user_details();
            $issue_status = $this->Utility('issue_status')['issue_status'];
            $Issues_table = (new \App\Models\Issues())->getTable();
            $Volumes_table = (new \App\Models\Volumes())->getTable();
            $criteria = "iss_id = '$issue_id'";
            $select_fields = "$Issues_table.iss_id, $Issues_table.iss_title,$Issues_table.iss_description, $Issues_table.iss_number, $Volumes_table.vol_title, $Volumes_table.vol_id, $Issues_table.iss_number, $Issues_table.iss_page_limit, $Issues_table.iss_status, $Issues_table.iss_status_date, $Issues_table.iss_due_date, $Issues_table.iss_special_issue, $Issues_table.iss_start_date, $Issues_table.iss_soft_end_date, $Issues_table.iss_hard_end_date,$Issues_table.iss_art_type";
            $issue_data = Issues::get_single_record("*", $criteria);
            $tables = array(
                'main_table' =>  $Issues_table,
                'join_table' => array(
                    $Volumes_table => array($Issues_table . '.iss_vol_id', $Volumes_table . '.vol_id')
                )
            );
            $result = Issue_management::get_results_using_joins($tables, $select_fields, $criteria, 'single');
            if($result)
            {
                $issue_zip_name = $this->get_export_issue_name($result, $jnl_code);
                //$article_data_list['art_update_last_date'] = convert_dmy_to_ymd($article_data['update_last_date'], $this->jnl_data->jset_date_format);
                $date_format = $this->get_platform_date_format($jnl_id);
                $result->iss_deadline = date($date_format, strtotime($result->iss_due_date));
                $result->iss_art_type_selected = $result->iss_art_type;
                $result->iss_art_type = explode(',', $result->iss_art_type);
                $result->iss_status_date = date($date_format, strtotime($result->iss_status_date));
                if($result->iss_status == 'c' || $result->iss_status == 'r')
                {
                    $result->iss_status_view = $issue_status[$result->iss_status].' on '.$result->iss_status_date;
                }
                else
                {
                    $result->iss_status_view = $issue_status[$result->iss_status];
                }
                $result->iss_number = (string)$result->iss_number;
                $result->iss_page_limit = (string)$result->iss_page_limit;
                $result->issue_zip_name = $issue_zip_name;
                //Task #55(Taskbbot) Updated for issue final file upload.
                $final_file_export = $this->checkFinalFileExported($result->iss_id);
                $result->final_file_export = $final_file_export;
                return $this->success('success',200,$result);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function checkUniqueIssue($data, $vol_id, $issue_id=NULL)
	{
		$issue_title = $data;
        $result = false;	
		if ($issue_title)
		{	
            if($issue_id != NULL)
            {
                $criteria = 'iss_title = "' .$issue_title. '" AND iss_id != "' .$issue_id. '" AND iss_vol_id = "'.$vol_id.'"';	
            }
            else
            {
                $criteria = 'iss_title = "' .$issue_title. '" AND iss_vol_id = "'.$vol_id.'"';	
            }
			$result_array = Issues::get_all_records('*', $criteria);
			if (count($result_array) > 0)
			{
				$result = true;
			}
			else
			{
				$result = false;
			}
		}
		return $result;
	}
    public function deleteIssue(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), 
            [
                'issue_id' => 'required',
            ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
            $post_data = $request->all();
            $issue_id = Rv_decrypt($post_data['issue_id']);
            $criteria = 'art_publication_issue = "' .$issue_id.'"';
            $data = array('art_publication_issue' => NULL);
            $current_user = $this->get_current_user_details();
            $result = Articles::update_record($data, $criteria, $current_user);
            $criteria = "iss_id='{$issue_id}'";
            $result = Issues::delete_records($criteria,"",$current_user);
            if($result)
            {
                return $this->success('success',200,$result);
            }
            else
            {
                return  $this->warning('Failed',500);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function manage_transfer_issue(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
            [
                'volume_id' => 'required',
                'issue_id' => 'required',
                'journal_id' => 'required'
            ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
            $volume_id = Rv_decrypt($request->volume_id);
            $issue_id = Rv_decrypt($request->issue_id);
            $journal_id = Rv_decrypt($request->journal_id);
            $this->current_user = $this->get_current_user_details();
        
            $criteria = "vol_id != '{$volume_id}' AND vol_jnl_id = '{$journal_id}'";
            $volumes_list = Volumes::get_all_records('vol_id as value, vol_title as label',$criteria,);
            $criteria = "iss_id = '$issue_id'";
            $issue_data = Issues::get_single_record("iss_id, iss_title, iss_vol_id", $criteria);
            if(count($volumes_list) == 0)
            {
                return $this->warning('volumes_not_available',200);
            }
            else
            {
                $data = array();
                $data['volumes'] = $volumes_list;
                $data['issue'] = $issue_data;
                return $this->success('success',200, $data);
               
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }

    }
    public function transfer_issue_volume(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
            [
                'volume_id' => 'required',
                'issue_id' => 'required'
            ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
            $volume_id = Rv_decrypt($request->volume_id);
            $issue_id = Rv_decrypt($request->issue_id);
            $this->current_user = $this->get_current_user_details();
            $data = array('iss_vol_id' => $volume_id);
            $criteria = 'iss_id="' . $issue_id . '"';						
            $result = Issues::update_record($data, $criteria, $this->current_user);
            if($result)
            {
                return $this->success('success',200);
            }
            else
            {
                return $this->warning('failed',500);
            }
        } 
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function change_issue_status(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
            [
                'iss_id' => 'required',
            ]);
            if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
            }
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            if(isset($post_data['iss_id']) && !empty($post_data['iss_id']))
                {
                    $issue_id = Rv_decrypt($post_data['iss_id']);
                    $issue_status = $post_data['status'];
                
                    $criteria = 'iss_id="' . $issue_id . '"';
                    $status_date = date('Y-m-d H:i:s');
                    $data = array(
                        'iss_status' => $issue_status,
                        'iss_status_date' =>$status_date
                    );
                    //check whether all articles assocciated to this issue are at publish stage
                    $check_closing_protocol = $this->check_before_closing_issue($issue_id);
                    //$check_closing_protocol['check_stats'] = TRUE;
                    if($issue_status == 'c' && $check_closing_protocol['check_stats'] == FALSE)
                    {
                        /* Start - Publication Notification Emails Sent in Error - basecamp ticket */
                        $result_arr = array(
                            'status' => 'failed',
                            'art_codes' => $check_closing_protocol['art_codes'],
                            'art_code_str' => $check_closing_protocol['art_code_str'],
                            'msg' => 'article_not_at_publish_stage'
                        );
                        return $this->warning('error', 200, $result_arr);
                        /* End - Publication Notification Emails Sent in Error - basecamp ticket */
                    }
                    $validate_issue = $this->check_page_limit($issue_id);
                    if(($issue_status == 'c' && $validate_issue['status'] == FALSE))
                    {
                        $result_arr = array(
                            'status'  => 'failed',
                            'msg'  => 'insufficient_page_count'
                        );
                        return $this->warning('error', 200, $result_arr);
                    }
                    $result = Issues::update_record($data, $criteria, $this->current_user);
                    if ($result)
                    {
                        return $this->success('success',200);
                    }
                    else
                    {
                        return $this->warning('failed',500);
                    }
             }
                
        } 
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function check_before_closing_issue($iss_id) 
    {
        $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();	
        $Articles_table = (new \App\Models\Articles())->getTable();	
        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
        $Issues_table = (new \App\Models\Issues())->getTable();
        $Issue_management_table = (new \App\Models\Issue_management())->getTable();

        $issue_articles = [];
        $select_fields = "ism_art_id";
        $criteria = "ism_iss_id =".$iss_id." AND IF(rvw_articles.art_id IS NOT NULL, (CASE WHEN (select count(a.art_id) from rvw_articles a where a.art_prev_article_id=rvw_articles.art_id)>0 then false else true end) AND art_status != 'r' AND art_delete_status != 'y' AND art_delete_status != 'w', true) ";
        $tables = array(
            'main_table' => $Issue_management_table,
            'join_table' => array(
                $Articles_table => array($Articles_table . '.art_id', $Issue_management_table . '.ism_art_id', 'left')
            )
        );
        $issue_articles = Issue_management::get_results_using_joins($tables, $select_fields, $criteria, 'all','ism_order ASC');
        $check_stats = TRUE;
        $art_codes = array();
        if(!empty($issue_articles))
        {
            foreach ($issue_articles as $iss_art)
            {
                if($iss_art->ism_art_id)
                {
                    $tables = array(
                        'main_table' => $Article_flow_table,
                        'join_table' => array(
                            $Articles_table => array($Articles_table . '.art_id', $Article_flow_table . '.aflw_art_id'),
                            $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', 'left')
                        )
                    );
                    $select_fields = 'art_code,aflw_art_id,jwf_stage_type,aflw_status';
                     /* Start - Publication Notification Emails Sent in Error - basecamp ticket */
                    $criteria = "aflw_art_id=".$iss_art->ism_art_id;
                    $article_list = array();
                    $art_dets = Articles::get_results_using_joins($tables, $select_fields, $criteria, 'all','aflw_id DESC');
                    if(!empty($art_dets))
                    {
                        $publish_stage = FALSE;
                        foreach($art_dets as $key => $value)
                        {
                            if($value->jwf_stage_type == 'publish' && $value->aflw_status == 'c')
                            {
                                $publish_stage = TRUE;
                            }
                        }
                        if($publish_stage == FALSE && !empty($art_dets[0]))
                        {
                            $check_stats = FALSE;
                            $art_codes[] = $art_dets[0]->art_code;
                        }
                    }
                }
                
            }
        }
        $art_code_str = join(' and ', array_filter(array_merge(array(join(', ', array_slice($art_codes, 0, -1))), array_slice($art_codes, -1)), 'strlen'));
        $rtn_data = array(
            'check_stats' => $check_stats,
            'art_code_str'   => $art_code_str,
            'art_codes' => $art_codes
        );
         /* End - Publication Notification Emails Sent in Error - basecamp ticket */
        return $rtn_data;
    }
    public function get_attachment_list(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
            [
                'issue_id' => 'required',
                'volume_id' => 'required',
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
            $current_user = $this->get_current_user_details();
            $Roles_table = (new \App\Models\Roles())->getTable();	
            $Articles_table = (new \App\Models\Articles())->getTable();	
            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
            $Issues_table = (new \App\Models\Issues())->getTable();
            $Volumes_table = (new \App\Models\Volumes())->getTable();
            $Issue_management_table = (new \App\Models\Issue_management())->getTable();
            $Issue_attachments_table = (new \App\Models\Issue_attachments())->getTable();
            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
            $Production_attachment_files_table = (new \App\Models\Production_attachment_files())->getTable();
            $Production_stages_info_table = (new \App\Models\Production_stages_info())->getTable();

            //Get neccessary ids
            $volume_id                  = Rv_decrypt($request->volume_id);
            $issue_id                   = Rv_decrypt($request->issue_id);
            $jnl_id                     = Rv_decrypt($request->jnl_id);
            $front_chk                  = false;
            $back_chk                   = false;
            $volume_title               = '';
            $issue_title                = '';
            $issue_page_limit           = '';
            $issue_due_date             = '';
            $issue_number             = '';
            $total_page                 = 0;
            $attachment_validation_status = true;
            $attachment_validation_msg    = '';
            $attach_typ_arr             = array();
            $missing_page               = '';
            $iss_att_types              = $this->Utility('issue_attachment_types')['issue_attachment_types'];
            $jnl_code  =  Journals::get_single_record('jnl_journal_code', "jnl_id={$jnl_id}")->jnl_journal_code;
            if(!isset($client_code)) 
            {
                $client_code = $this->current_client->clnt_client_code;
            }

            $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
            $issue_config_data = Config::get($issue_management_config);
            if(!empty($issue_config_data['issue_attachment_type']))
            {
                $iss_att_types = $issue_config_data['issue_attachment_type']; 
            }
            $date_format = $this->get_platform_date_format($jnl_id);
            $issue_stat  = $this->Utility('issue_status')['issue_status'];
             //select all attachments corresponding to this issue
            $select_fields = "$Volumes_table.vol_title,$Issues_table.iss_number,$Issues_table.iss_title,$Issues_table.iss_page_limit,$Issues_table.iss_status,$Issues_table.iss_status_date as iss_due_date,$Issue_management_table.ism_id,$Issue_management_table.ism_isat_id,$Issue_management_table.ism_art_id,$Issue_management_table.ism_art_page_cnt,$Articles_table.art_code,$Articles_table.art_article_upload_path,$Issue_attachments_table.isat_id,$Issue_attachments_table.isat_iss_id,$Issue_attachments_table.isat_type,$Issue_attachments_table.isat_type,$Issue_attachments_table.isat_location,$Issue_attachments_table.isat_name,$Issue_attachments_table.isat_size,$Issue_attachments_table.isat_page,$Issue_management_table.ism_order";
            $criteria = "ism_iss_id =".$issue_id." AND IF(rvw_articles.art_id IS NOT NULL, (CASE WHEN (select count(a.art_id) from rvw_articles a where a.art_prev_article_id=rvw_articles.art_id)>0 then false else true end) AND art_status != 'r' AND art_delete_status != 'y' AND art_delete_status != 'w', true) ";
            $tables = array(
                'main_table' => $Issue_management_table,
                'join_table' => array(
                    $Issue_attachments_table => array($Issue_attachments_table . '.isat_id', $Issue_management_table . '.ism_isat_id', 'left'),
                    $Issues_table => array($Issues_table . '.iss_id', $Issue_management_table . '.ism_iss_id', 'left'),
                    $Volumes_table => array($Volumes_table . '.vol_id', $Issues_table . '.iss_vol_id', 'left'),
                    $Articles_table => array($Articles_table . '.art_id', $Issue_management_table . '.ism_art_id', 'left')
                )
            );
            $article_list = array();
            $result_arr = Issue_management::get_results_using_joins($tables, $select_fields, $criteria, 'all','ism_order ASC');
            //attach all the issue to the issue management table and to generate preview issue management row
            if(!empty($result_arr))
            {
                
                $select = 'isat_id,isat_iss_id,isat_type,isat_location,isat_name,isat_size,isat_page';
                $where  = 'isat_iss_id='.$issue_id;
                $issue_attachment_contents = Issue_attachments::get_all_records($select,$where);
                if(!empty($issue_attachment_contents))
                {
                    foreach($issue_attachment_contents as $row)
                    {
                        if($row->isat_type == 'f')
                            $front_chk              = true;
                        if($row->isat_type == 'b')
                            $back_chk               = true;
                    }
                }
                $result_data = array();
                foreach($result_arr as $row)
                {
                    if($row->ism_isat_id !== NULL || ($row->ism_art_id !== NULL && $row->art_code != NULL))
                    {
                        $data['isat_page']='';
                        $data['isat_type']='';
                        $data['isat_name']='';
                        $data['front_chk']      = $front_chk;
                        $data['back_chk']       = $back_chk;
                        $ism_id                 = Rv_encrypt($row->ism_id);
                        $volume_title           = $row->vol_title;
                        $issue_title            = $row->iss_title;
                        $issue_page_limit       = $row->iss_page_limit;
                        $issue_due_date         = $row->iss_due_date;
                        $issue_number           = $row->iss_number;
                        $stat_date              = $this->get_status_date($row,$date_format);
                        $issue_status_msg       = $issue_stat[$row->iss_status] . $stat_date;
                        $issue_status           = $row->iss_status;
                        $data['ism_id']         = Rv_encrypt($row->ism_id);
                        $data['isat_id']        = Rv_encrypt($row->isat_id);
                        $data['isat_type_id']   = $row->isat_type;
                        $data['isat_iss_id']    = $row->isat_iss_id;
                        $data['iss_att_types']  = $iss_att_types;
                        if($row->ism_isat_id !== NULL)
                        {
                            $data['isat_name']      = $row->isat_name;
                            $data['isat_page']      = $row->isat_page;
                            $upload_path            = $row->isat_location.$row->isat_name;
                            $data['isat_type_key']  = (!empty($row->isat_type))?$row->isat_type:NULL ;
                            $data['isat_type']      = (!empty($row->isat_type))?$iss_att_types[$row->isat_type]:NULL ;
                            $data['front_chk']      = $front_chk;
                            $data['back_chk']       = $back_chk;
                            $data['attach_type']    = $row->isat_type;
                            $data['isat_link'] = $upload_path;
                            $attach_typ_arr[]       = $row->isat_type;
                        }
                        else if($row->ism_art_id !== NULL && $row->art_code != NULL)
                        {
                            $row->art_id = $row->ism_art_id;
                            //clicking on the article id redirects to the view article page

                            $flw_data = $this->get_latest_workflw_data($row->ism_art_id);
                            if(isset($flw_data) && !empty($flw_data))
                            {
                                $route_url  =   '';
                                $page       =   '';
                                $core_stage =   $flw_data->jwf_stage_type;
                                $client_code = $this->current_client->clnt_client_code;
                                $review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config';
                                $review_flow = Config::get($review_config);
                                // if(isset($review_flow[$core_stage]['stage_for']) && $review_flow[$core_stage]['stage_for'] == 'manageproduction')
                                // {
                                //     $route_url = '-production';
                                // }
                                //commented by kiran.
                                //$data['isat_link'] = base_url('journal/' . $this->jnl_data->jnl_journal_code . '/view-article'.$route_url.'?' . encrypt_link('article_id=' . $row->ism_art_id . '&status_id=' . $flw_data->aflw_id.'&page='.$page));
                            // $data['isat_link'] = '/view-article'.$route_url.'/'.$this->encrypt_data($row->ism_art_id).'/'.$this->encrypt_data($flw_data->aflw_id);
                                $data['isat_link'] = URL::to('/').'/'. $this->current_client->platform_type.'/'.$jnl_code.'/view-article/'.$this->encrypt_data($row->ism_art_id) .'/' . $this->encrypt_data($flw_data->aflw_id);
                                $data['isat_name'] = $row->art_code;
                                $data['isat_type'] = 'Article';
                                $data['isat_page'] = $row->ism_art_page_cnt;
                            } 
                        }
                        if(isset($data['isat_page']) && is_int($data['isat_page']))
                        {
                            $total_page += $data['isat_page'];
                        }
                        
                        $result_data[] = $data;
                    }
                }
                $iss_where ='iss_id = '.$issue_id;
                $issue_contents = Issues::get_single_record('iss_page_limit',$iss_where);
                
                $check_page_limit = $this->check_page_limit($issue_id);
                //To check if any article in the attachment list is not completed the publish stage.
                $check_closing_protocol = $this->check_before_closing_issue($issue_id);
                $published_all_articles = true;
                if($check_closing_protocol['check_stats'] == FALSE)
                {
                    $published_all_articles = false;
                }
                if($check_page_limit['status'] == false)
                {
                    return $this->success('success', 200, array('result_data' => $result_data, 'page_limit' => $issue_contents->iss_page_limit, 'total_pages' => $total_page,'page_count' => FALSE, 'published_all_articles' => $published_all_articles));
                }
                return $this->success('success', 200, array('result_data' => $result_data, 'total_pages' => $total_page, 'page_count' => TRUE,'published_all_articles' => $published_all_articles));
            }
    }
    catch(\Exception $e)
    {
        $this->failure('Failed',500,$e);
    }
    }
    public function get_latest_workflw_data($art_id)
    {
        $rtn_data = NULL;
        if(!empty($art_id))
        {	
            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();	
            $Article_flow_table = (new \App\Models\Article_flow())->getTable();

            $select = 'aflw_id,jwf_id,jwf_stage_type';
            $tables = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                        $Generic_flows_table => array($Article_flow_table.'.aflw_jwf_id',$Generic_flows_table.'.jwf_id')
            ));
            $condition = 'aflw_art_id='.$art_id;
            $result_data = Articles::get_results_using_joins($tables, $select, $condition, 'single','aflw_id DESC');
        }
        return $result_data;
    }
    public function get_status_date($iss_row_data,$date_format)
        {
            if($iss_row_data->iss_status == 'o')
            {
                $return_stat_date = '';
            }
            else
            {
                $return_stat_date = $iss_row_data->iss_due_date;
            }
            return $return_stat_date;
        }
    public function deleteIssueAttachment(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), 
            [
                'issue_atchmnt_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
            $post_data = $request->all();
            $issat_id = Rv_decrypt($post_data['issue_atchmnt_id']);
            $this->current_user = $this->get_current_user_details();
            $criteria = "ism_id='{$issat_id}'";
            $result = Issue_management::delete_records($criteria,"",$this->current_user);
            if($result)
            {
                return $this->success('success',200,$result);
            }
            else
            {
                return  $this->warning('Failed',500);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function getIssueArticles(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
                [
                    'issue_id' => 'required',
                    'journal_id' => 'required'
                ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
            $issue_id = Rv_decrypt($request->issue_id);
            $journal_id = Rv_decrypt($request->journal_id);
            $journal_code = Rv_decrypt($request->journal_code);
            if(!empty($issue_id))
            {
                //select all articles which are in publish stage type and and article flow status is 'u'
                $Articles_table = (new \App\Models\Articles())->getTable();	
                $Roles_table = (new \App\Models\Roles())->getTable();	
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                $Article_types_table = (new \App\Models\Article_types())->getTable();
                $Production_stages_info_table = (new \App\Models\Production_stages_info())->getTable();
                $Issue_management_table = (new \App\Models\Issue_management())->getTable();
                $Issues_table = (new \App\Models\Issues())->getTable();
                $select_fields = "$Articles_table.art_id,$Articles_table.art_code,$Articles_table.art_title,$Articles_table.art_article_upload_path,$Article_types_table.artp_article_type,$Article_flow_table.aflw_level";
                $criteria = "art_delete_status IN ('n','h') AND jwf_stage_type = 'publish' AND artp_jnl_id = '$journal_id' AND aflw_status IN ('c') ";
                $tables = array(
                    'main_table' => $Articles_table,
                    'join_table' => array(
                        $Article_flow_table => array($Articles_table . '.art_id', $Article_flow_table . '.aflw_art_id', 'left'),
                        $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id','left'),
                        $Article_types_table => array($Articles_table . '.art_artp_id', $Article_types_table . '.artp_id','left'),
                        $Production_stages_info_table => array($Articles_table . '.art_id', $Production_stages_info_table . '.psi_art_id', 'left')
                    )
                );
                $article_list = array();
                $result_arr = Articles::get_results_using_joins($tables, $select_fields, $criteria, 'all');
                if($result_arr)
                {
                    foreach($result_arr as $row)
                    {
                        $data['art_id']             = Rv_encrypt($row->art_id);
                        $data['art_code']           = $row->art_code;
                        $data['artp_article_type']  = $row->artp_article_type;
                        $data['art_title']          = $row->art_title;
                        $check_status               = Issue_management::get_single_record('ism_id,ism_iss_id','ism_art_id='.$row->art_id);
                        //takes the latest pdf count of attachment that has designated to author 
                        //shows when the production module is on
                        $pdf_pages = $this->issue_management_page_count($row->art_id, $journal_code);
                        $data['psi_page_count'] = $pdf_pages;
                        $data['check_status']       = (!empty($check_status) ? TRUE : FALSE);
                        
                        if(!isset($check_status->ism_iss_id) && empty($check_status->ism_iss_id))
                        {
                            $article_list[] = $data;
                        }
                        elseif(isset($check_status->ism_iss_id) && ($check_status->ism_iss_id == $issue_id))
                        {
                            $article_list[] = $data;
                        }
                            
                    }
                    $result = array(
                        'article_list' => $article_list
                    );
                    return $this->success('success',200, $result);
                }
                else
                {
                    return  $this->warning('Failed',500);
                }
            }
        } 
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function assossiateArticleToIssue(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
            [
                'issue_id' => 'required',
                'volume_id' => 'required',
                'art_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
            $Roles_table = (new \App\Models\Roles())->getTable();
            $Issues_table = (new \App\Models\Issues())->getTable();
            $Volumes_table = (new \App\Models\Volumes())->getTable();
            $Issue_management_table = (new \App\Models\Issue_management())->getTable();	
            $Issue_attachments_table = (new \App\Models\Issue_attachments())->getTable();
            $Production_stages_info_table = (new \App\Models\Production_stages_info())->getTable();
            //Get neccessary ids
            $current_user = $this->get_current_user_details();
            $volume_id = Rv_decrypt($request->volume_id);
            $issue_id  = Rv_decrypt($request->issue_id);
            $result = NUll;
            $art_id = Rv_decrypt($request->art_id);
            $check_status  = $request->is_checked;
            $art_page_len  = trim(strip_tags($request->art_page_len));
            $today = date('Y-m-d H:i:s', time());
            $criteria = "iss_id = '$issue_id'";
            $issue_data = Issues::get_all_records("iss_id,iss_status", $criteria);
            if($issue_data && $issue_data[0]->iss_status != 'c')
            {
                if(!empty($art_id))
                {
                    if($check_status == 1)
                    {
                        $data  = array(
                            'ism_iss_id' =>  $issue_id,
                            'ism_art_id' =>  $art_id,
                            'ism_art_page_cnt' =>  $art_page_len,
                            'ism_order'  =>  1
                        );
                        $result = Issue_management::insert_record($data, $current_user);
                        //To add publication issue from article table.
                        $criteria = 'art_id = "' .$art_id.'"';
                        $data = array('art_publication_issue' => $issue_id);
                        $current_user = $this->get_current_user_details();
                        $result = Articles::update_record($data, $criteria, $current_user);
                    }
                    else
                    {
                        $condi = 'ism_art_id='.$art_id;
                        $result = Issue_management::delete_records($condi);
                        //To remove publication issue from article table.
                        $criteria = 'art_id = "' .$art_id.'"';
                        $data = array('art_publication_issue' => NULL);
                        $current_user = $this->get_current_user_details();
                        $result = Articles::update_record($data, $criteria, $current_user);
                    }
                    if($result)
                    {        
                        return $this->success('success',200, $result);
                    }
                }
            }
            return  $this->warning('warning',200,array('error' => 'issue_closed'));

        } 
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function get_issue_attachments(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
            [
                'issue_id' => 'required',
                'volume_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
            $Roles_table = (new \App\Models\Roles())->getTable();
            $Issue_management_table = (new \App\Models\Issue_management())->getTable();	
            //Get neccessary ids
            $issue_attachment_html = array();
            $has_records  = false;
            $front_chk  = false;
            $back_chk = false;
            $volume_id = Rv_decrypt($request->volume_id);
            $issue_id = Rv_decrypt($request->issue_id);
            $iss_att_types = $this->Utility('issue_attachment_types')['issue_attachment_types'];
            if(!isset($client_code)) 
                $client_code = $this->current_client->clnt_client_code;
            $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
            if( $issue_management_config)
            {
                 $issue_config_data = Config::get($issue_management_config);
                //issue types.
                $iss_att_types = $issue_config_data['issue_attachment_type'];
            }
                
            if(!empty($issue_id))
            {    
                $select = 'isat_id,isat_iss_id,isat_type,isat_location,isat_name,isat_size,isat_page';
                $where  = 'isat_iss_id='.$issue_id;
                $issue_attachments = array();
                $issue_attachment_contents = Issue_attachments::get_all_records($select,$where);
                if(!empty($issue_attachment_contents))
                {
                    foreach($issue_attachment_contents as $row)
                    {
                        if($row->isat_type == 'f')
                            $front_chk  = true;
                        if($row->isat_type == 'b')
                            $back_chk = true;
                    }
                    foreach($issue_attachment_contents as $row)
                    {
                        $data['isat_id']        = Rv_encrypt($row->isat_id);
                        $data['isat_name']      = $row->isat_name;
                        $data['isat_page']      = $row->isat_page;
                        $data['isat_type']      = (!empty($row->isat_type))?$iss_att_types[$row->isat_type]:NULL ;
                        $data['isat_iss_id']    = $row->isat_iss_id;
                        $data['front_chk']      = $front_chk;
                        $data['back_chk']       = $back_chk;
                        $upload_path            = $row->isat_location;
                        $data['attach_type']    = $row->isat_type;
                        $data['iss_att_types']  = $iss_att_types;        
                        $issue_attachments[] = $data;
                        $has_records = true;
                    }
                   
                }
                else
                {
                    $has_records = false;
                }
                $result_arr['issue_attachments'] = $issue_attachments;
                $result_arr['has_records'] = $has_records;
                return $this->success('success',200, $result_arr);
            }
        } 
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
       
    }
    //Need co convert.
    public function uploadIssueAttachment(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), 
            [
                'issue_id' => 'required',
                'volume_id' => 'required',
                'jnl_code' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
            $current_user = $this->get_current_user_details();
            $Issues_table = (new \App\Models\Issues())->getTable();
            $Issues_management_table = (new \App\Models\Issue_management())->getTable();
            $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
            $Articles_table = (new \App\Models\Articles())->getTable();	
            $Volumes_table = (new \App\Models\Volumes())->getTable();
            $Production_stages_info_table = (new \App\Models\Production_stages_info())->getTable();
    
            //Get neccessary ids
            $volume_id = Rv_decrypt($request->volume_id);
            $issue_id  = Rv_decrypt($request->issue_id);
            $jnl_code  = Rv_decrypt($request->jnl_code);
            $criteria = "iss_id = '$issue_id'";
            $issue_data = Issues::get_single_record("iss_id,iss_status", $criteria);
            if($issue_data && $issue_data->iss_status == 'c')
            {
                return  $this->warning('warning',200,array('error' => 'issue_closed'));
            }
            $front_chk = false; 
            $back_chk  = false; 
            $criteria = "iss_id = '$issue_id'";
            $issue_data = Issues::get_all_records("iss_id,iss_status", $criteria);
            if($issue_data && $issue_data[0]->iss_status != 'c')
            {    
                //upload and dirictory paths and check if exists
                $upload_path  = 'issue_management/'.$jnl_code.'/'.$volume_id . '/' . $issue_id . '/';
                $attach_dir = $upload_path;
                $attachment_file = $request->file;
                $att_name = str_replace(' ', '_', $attachment_file->getClientOriginalName());
                $file_extension = explode('.', $att_name);
                $file_extension = end($file_extension);
                if(!file_exists($attach_dir))
                    mkdir($attach_dir, 0765,TRUE);
                    
                $uploaded_file_details = $this->upload_file_handler($upload_path, $attachment_file, $att_name);
                if ($uploaded_file_details && empty($uploaded_file_details['error']))
                {   
                    if($file_extension == 'pdf')
                    {
                        $data = array();
                        $data['isat_location']  = $upload_path;
                        $data['isat_size']      = $this->file_size_convert_to_kb($uploaded_file_details['size']);
                        $data['isat_name']      = $uploaded_file_details['name'];
                        $data['isat_iss_id']    = $issue_id;
                        $att_pages              = 1;
                        
                        $att_path = $attach_dir . $att_name;
                        $att_pages = $this->count_pdf_pages($att_path);
                    
                        $data['isat_page']  = $att_pages;
                        $isat_id            = Issue_attachments::insert_record($data, $current_user);
                        //insert in issue management table ---starts
                        $ism_data = array(
                                'ism_iss_id'      => $issue_id,
                                'ism_isat_id'     => $isat_id,
                                'ism_order'       => 1,
                                'ism_posted_by'   => 0,
                                'ism_posted_date' => date('Y-m-d H:i:s'),
                        );
                        $ism_id = Issue_management::insert_record($ism_data, $current_user);
                        //ends
                        $data['isat_type'] = '';
                        $data['isat_id'] = Rv_encrypt($isat_id);
                        //check if already a front and back cover exit or not..
                        $select = 'isat_type';
                        $where  = "isat_iss_id ='{$issue_id}'";
                        $issue_attachment_contents = Issue_attachments::get_all_records($select,$where);
                        foreach($issue_attachment_contents as $row)
                        {
                            if($row->isat_type == 'f')
                                $front_chk  = true;
                            if($row->isat_type == 'b')
                                $back_chk   = true;
                        }
                        $data['front_chk']      = $front_chk;
                        $data['back_chk']       = $back_chk;

                        return $this->success('success',200);
                    }
                    else
                    {
                        return  $this->warning('Failed',500);    
                    }
                }
                else
                {
                    return  $this->warning('Failed',500);
                }
            }
            else
            {
                return  $this->warning('Failed',500);
            }

                    
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }

    }
    //Start - Task #55(Taskbbot) Updated for issue final file upload.
    public function uploadIssueFinalFile(Request $request)
    {
        try{
            if((isset($this->current_client->functionality->cfty_enable_issue_final_file_upload)) && $this->current_client->functionality->cfty_enable_issue_final_file_upload == 'y')
            {
                $validator = Validator::make($request->all(), 
                [
                    'issue_id' => 'required',
                    'volume_id' => 'required',
                    'jnl_code' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                $enable_final_file_upload = FALSE;
                $current_user = $this->get_current_user_details();
                $Issues_table = (new \App\Models\Issues())->getTable();
                $Issues_management_table = (new \App\Models\Issue_management())->getTable();
                $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
                $Issues_final_upload_files_table = (new \App\Models\Issue_final_upload_files())->getTable();
                $Articles_table = (new \App\Models\Articles())->getTable();	
                $Volumes_table = (new \App\Models\Volumes())->getTable();
                //Get neccessary ids
                $volume_id = Rv_decrypt($request->volume_id);
                $issue_id  = Rv_decrypt($request->issue_id);
                $jnl_code  = Rv_decrypt($request->jnl_code);
                $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
                $issue_config_data = Config::get($issue_management_config);
                $final_file_upload_type = 'single';
                if(isset($issue_config_data['final_file_upload_type']))
                {
                    $final_file_upload_type = $issue_config_data['final_file_upload_type'];
                }
                $criteria = "isfuf_iss_id=$issue_id";
                $finalzipfiles  = Issue_final_upload_files::get_all_records('*',$criteria);
                if((isset($this->current_client->functionality->cfty_enable_issue_final_file_upload)) && $this->current_client->functionality->cfty_enable_issue_final_file_upload == 'y')
                {
                    $enable_final_file_upload = TRUE;
                }
                if($enable_final_file_upload == TRUE && (($final_file_upload_type == 'single' && count($finalzipfiles) <= 0)||($final_file_upload_type == 'multiple')))
                {
                    //upload and dirictory paths and check if exists
                    $upload_path  = 'issue_management/'.$jnl_code.'/'.$volume_id . '/' . $issue_id . '/';
                    $attach_dir = $upload_path;
                    $attachment_file = $request->file;
                    $att_name = str_replace(' ', '_', $attachment_file->getClientOriginalName());
                    $file_extension = explode('.', $att_name);
                    $file_extension = end($file_extension);
                    if($file_extension == 'zip')
                    {
                        $criteria = "iss_id = '$issue_id'";
                        $issue_data = Issues::get_all_records("iss_id,iss_status", $criteria); 
                        $criteria = "isfuf_name='$att_name'";
                        $file_data = Issue_final_upload_files::get_single_record('isfuf_id,isfuf_name',$criteria);
                        if(empty($file_data))
                        { 
                            if(!file_exists($attach_dir))
                            {
                                mkdir($attach_dir, 0765,TRUE);   
                            }                   
                            $uploaded_file_details = $this->upload_file_handler($upload_path, $attachment_file, $att_name);
                            if ($uploaded_file_details && empty($uploaded_file_details['error']))
                            {
                                $data = array();
                                $data['isfuf_location']  = $upload_path;
                                $data['isfuf_size']      = $this->file_size_convert_to_kb($uploaded_file_details['size']);
                                $data['isfuf_name']      = $uploaded_file_details['name'];
                                $data['isfuf_iss_id']    = $issue_id;
                                $data['isfuf_export_status']  = 'n';
                                $isat_id = Issue_final_upload_files::insert_record($data, $current_user);
                                if($isat_id)
                                {
                                    return $this->success('success',200);
                                }
                            
                            }
                        }
                        else
                        {
                            return $this->failure('Failed',200,array('error' => 'file_name_exists'));
                        }
                    }
                }
                else
                {
                    return $this->failure('Failed',200);
                }
            }
            else
            {
                return $this->failure('Failed',200);
            }
        }
        catch(Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function getIssueFinalFiles(Request $request)
    {
        try{
            if((isset($this->current_client->functionality->cfty_enable_issue_final_file_upload)) && $this->current_client->functionality->cfty_enable_issue_final_file_upload == 'y')
            {
                
                $validator = Validator::make($request->all(), 
                [
                    'issue_id' => 'required',
                    'volume_id' => 'required',
                    'jnl_code' => 'required',
                    'jnl_id' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                //Get neccessary ids
                $volume_id = Rv_decrypt($request->volume_id);
                $issue_id  = Rv_decrypt($request->issue_id);
                $jnl_code  = Rv_decrypt($request->jnl_code);
                $jnl_id  = Rv_decrypt($request->jnl_id);
                $Issues_final_upload_files_table = (new \App\Models\Issue_final_upload_files())->getTable();
                $upload_path  = 'issue_management/'.$jnl_code.'/'.$volume_id . '/' . $issue_id . '/';
                $criteria = "isfuf_iss_id=$issue_id";
                if($jnl_id == '')
                {
                    $platform_data = $this->platform_basic_settings_data($jnl_code);
                    $jnl_id = $platform_data->jnl_id;
                }
                $date_format = $this->get_platform_date_format($jnl_id);
                $date_format = static::date_format_map($date_format);
                $finalzipfiles  = Issue_final_upload_files::get_all_records("isfuf_id,isfuf_name,isfuf_export_status,isfuf_size,DATE_FORMAT(isfuf_posted_date, '$date_format') as isfuf_posted_date",$criteria);
                
                $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
                $issue_config_data = Config::get($issue_management_config);
                $final_file_upload_type = 'single';
                if(isset($issue_config_data['final_file_upload_type']))
                {
                    $final_file_upload_type = $issue_config_data['final_file_upload_type'];
                }
                $result_arr['finalzipfiles'] = $finalzipfiles;
                $result_arr['finalfileuploadtype'] = $final_file_upload_type;

                return $this->success('success',200, $result_arr);
            }
            else
            {
                return  $this->failure('Failed',500);
            }
        }
        catch(Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
    }
    
    public function getFinalZipContents(Request $request)
    {
        try
        {
            if((isset($this->current_client->functionality->cfty_enable_issue_final_file_upload)) && $this->current_client->functionality->cfty_enable_issue_final_file_upload == 'y')
            {
                $validator = Validator::make($request->all(), 
                [
                    'file_id' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                $file_id  = Rv_decrypt($request->file_id);
                $criteria = "isfuf_id=$file_id";
                $finalzipfile  = Issue_final_upload_files::get_single_record("isfuf_id,isfuf_name,isfuf_location",$criteria);
                $uploadPath = $this->get_upload_path($finalzipfile->isfuf_location,TRUE);
                $zipPath = $uploadPath.$finalzipfile->isfuf_name;
                if(file_exists($zipPath))
                {
                    $zip = new ZipArchive;
                    if ($zip->open($zipPath) === TRUE) {
                        $fileNames = [];
                        
                        // Loop through each file in the ZIP
                        for ($i = 0; $i < $zip->numFiles; $i++) {
                            $fileNames[] = $zip->getNameIndex($i);
                        }

                        $zip->close();
                        $result_arr['fileNames'] = $fileNames;
                        $result_arr['zipName'] = $finalzipfile->isfuf_name;
                        return $this->success('success',200, $result_arr);
                    } 
                }
                else {
                    return  $this->failure('Failed',500);
                }
            }
            else
            {
                return  $this->failure('Failed',500);
            }
        }
        catch(Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
        
    }

    public function downloadFinalFile($data)
    {
        try
        {
            if((isset($this->current_client->functionality->cfty_enable_issue_final_file_upload)) && $this->current_client->functionality->cfty_enable_issue_final_file_upload == 'y')
            {
                $post_data = json_decode($data);
                $issue_id  = (isset($post_data->issue_id)) ? Rv_decrypt($post_data->issue_id) : NULL;
                $volume_id = (isset($post_data->volume_id))  ? Rv_decrypt($post_data->volume_id)  : NULL;
                $jnl_id = (isset($post_data->jnl_id)) ? Rv_decrypt($post_data->jnl_id): NULL;
                $jnl_code = isset($post_data->jnl_code)? Rv_decrypt($post_data->jnl_code):NULL;
                $criteria = "isfuf_id=$post_data->file_id";
                $finalzipfile  = Issue_final_upload_files::get_single_record("isfuf_id,isfuf_name,isfuf_location",$criteria);
                $issue_path = 'uploads/issue_management/'.$jnl_code. '/' . $volume_id . '/' . $issue_id;
                if(!empty($finalzipfile) && $finalzipfile->isfuf_location)
                {
                    $final_file_path = $this->upload_folder_path($issue_path . '/' . $finalzipfile->isfuf_name);
                    if(file_exists($final_file_path))
                    {
                        $this->download_file($final_file_path,'force-download');
                    }
                    else
                    {
                        return response()->json(['status' => false], 404);
                    }
                }
                else
                {
                    return response()->json(['status' => false], 404);
                }
            }
            else
            {
                return  $this->failure('Failed',500);
            }
        }
        catch(Exception $e)
        {
            return response()->json(['status' => false], 500);
        }
    }
    public function removeIssueFinalFile(Request $request)
    {
        try{
            if((isset($this->current_client->functionality->cfty_enable_issue_final_file_upload)) && $this->current_client->functionality->cfty_enable_issue_final_file_upload == 'y')
            {
                $validator = Validator::make($request->all(), 
                [
                    'isfuf_id' => 'required',
                    'isfuf_name' => 'required',
                    'issue_id' => 'required',
                    'volume_id' => 'required',
                    'jnl_code' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                //Get neccessary ids
                $isfuf_id  = Rv_decrypt($request->isfuf_id);
                $isfuf_name = Rv_decrypt($request->isfuf_name);
                $volume_id = Rv_decrypt($request->volume_id);
                $issue_id  = Rv_decrypt($request->issue_id);
                $jnl_code  = Rv_decrypt($request->jnl_code);
                $Issues_final_upload_files_table = (new \App\Models\Issue_final_upload_files())->getTable();
                $current_user = $this->get_current_user_details();
                $criteria = "isfuf_id=$isfuf_id";
                $upload_path  = 'uploads/issue_management/'.$jnl_code.'/'.$volume_id . '/' . $issue_id . '/'.$isfuf_name;
                $finalzipfiles  = Issue_final_upload_files::delete_records($criteria,'',$current_user);
                if($finalzipfiles)
                {
                    Storage::disk('public')->delete($upload_path);
                }
                $final_file_export = $this->checkFinalFileExported($issue_id);
                return $this->success('success',200,array('final_file_export' => $final_file_export));
            }
            else
            {
                return  $this->failure('Failed',500);
            }
        }
        catch(Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function exportIssueFinalFiles(Request $request)
    {
        try
        {
            if((isset($this->current_client->functionality->cfty_enable_issue_final_file_upload)) && $this->current_client->functionality->cfty_enable_issue_final_file_upload == 'y')
            {
                $validator = Validator::make($request->all(), 
                [
                    'issue_id' => 'required',
                    'volume_id' => 'required',
                    'jnl_code' => 'required',
                    'jnl_id' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                //Get neccessary ids
                $volume_id = Rv_decrypt($request->volume_id);
                $issue_id  = Rv_decrypt($request->issue_id);
                $jnl_code  = Rv_decrypt($request->jnl_code);
                $jnl_id  = Rv_decrypt($request->jnl_id);
                $current_user = $this->get_current_user_details();
                $file_exported = false;
                $export_final_files_flag = true;
                $criteria = "isfuf_iss_id=$issue_id";
                $finalzipfiles  = Issue_final_upload_files::get_all_records('*',$criteria);
                $return_arr = array();
                foreach($finalzipfiles as $item)
                {
                    $file_path = 'uploads/issue_management/'.$jnl_code.'/'.$volume_id . '/' . $issue_id . '/'.$item->isfuf_name;
                    $return_arr = $this->upload_to_server($file_path, $jnl_id, $item->isfuf_name, $export_final_files_flag);
                    if($return_arr['status'] == true && !empty($return_arr['host_list']))
                    {
                        $file_exported = true;
                        $data = array('isfuf_export_status' => 'y');
                        $criteria = array('isfuf_id' => $item->isfuf_id);
                        $isat_id = Issue_final_upload_files::update_record($data, $criteria, $current_user);
                    }
                }
                if($file_exported == true)
                {
                    $final_file_export = $this->checkFinalFileExported($issue_id);
                    return $this->success('success',200, array('final_file_export' => $final_file_export));
                }
                else
                {
                    return  $this->warning('warning',200, $return_arr);
                }
            }
            else
            {
                return  $this->warning('Failed',500);
            }
        }
        catch(Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }

    }
    public function checkFinalFileExported($issue_id)
    {
        try
        {
            if($issue_id != NULL)
            {
                $criteria = "isfuf_iss_id=$issue_id";
                $finalzipfiles  = Issue_final_upload_files::get_all_records('isfuf_id,isfuf_export_status',$criteria);
                $export_status = true;
                $result_arr['final_file_export'] = true;
                if(count($finalzipfiles) == 0)
                {
                    $export_status = false;
                }
                foreach($finalzipfiles as $item)
                {
                    if($item->isfuf_export_status == 'n')
                    {
                        $export_status = false;
                    }
                }
                return $export_status;
            }
            else
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            print_r($e);
        }
    }
    //End - Task #55(Taskbbot) Updated for issue final file upload.
    public function update_issue_attachments_details(Request $request)
        {
            try
            {
                $validator = Validator::make($request->all(), 
                [
                    'issue_id' => 'required',
                    'volume_id' => 'required',
                    'type' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                $Roles_table = (new \App\Models\Roles())->getTable();
                $Articles_table = (new \App\Models\Articles())->getTable();	
                $Issues_table = (new \App\Models\Issues())->getTable();
                $Volumes_table = (new \App\Models\Volumes())->getTable();
                $Issues_management_table = (new \App\Models\Issue_management())->getTable();
                $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
                $Production_stages_info_table = (new \App\Models\Production_stages_info())->getTable();
                $current_user = $this->get_current_user_details();
                //Get neccessary ids
                $volume_id  = Rv_decrypt($request->volume_id);
                $issue_id   = Rv_decrypt($request->issue_id);
                $ism_id = Rv_decrypt($request->ism_id);
                $ism_art_page = Rv_decrypt($request->ism_art_page);
                $isat_page = Rv_decrypt($request->isat_page);
                $post_data  = $request->all();
                $type       = Rv_decrypt($request->type);
                $criteria = "iss_id = '$issue_id'";
                $issue_data = Issues::get_all_records("iss_id,iss_status", $criteria);
                if($issue_data && $issue_data[0]->iss_status != 'c')
                {
                    if($type == 'article_page_update')
                    {
                        $ism_data['ism_art_page_cnt']   = $ism_art_page;
                        Issue_management::update_record($ism_data, 'ism_id='.$ism_id, $current_user);
                        return $this->success('success',200);
                    }
                    else
                    {
                        $isat_data = array();
                        $isat_id  = Rv_decrypt($post_data['isat_id']);
                        if($type == 'page_count')
                        {
                            $isat_data['isat_page']  = Rv_decrypt($post_data['isat_page']);
                        }
                        elseif($type == 'att_type')
                        {
                            $isat_type = Rv_decrypt($post_data['isat_type']);
                            $this->update_issue_management_sort_order($issue_id,$isat_id,$isat_type);
                            $isat_data['isat_type']  = Rv_decrypt($post_data['isat_type']);
                        }
                        Issue_attachments::update_record($isat_data, 'isat_id='.$isat_id, $current_user);
                        return $this->success('success',200);
                    }    
                }
                else
                {
                    return  $this->warning('warning',200,array('error' => 'issue_closed'));
                }
                    
            }
            catch(\Exception $e)
            {
                return  $this->failure('Failed',500,$e); 
            }
            
        }
        //Need to convert.
        public function update_issue_management_sort_order($issue_id,$issue_attach_id,$issue_attach_type)
        {
            
            $Roles_table = (new \App\Models\Roles())->getTable();
            $Issues_management_table = (new \App\Models\Issue_management())->getTable();
            $current_user = $this->get_current_user_details();
            if(!empty($issue_attach_id) && !empty($issue_attach_type))
            {
                $att_condi = 'ism_iss_id='.$issue_id;
                $att_cnt =  Issue_management::get_single_record('count(ism_id)as cnt',$att_condi)->cnt;
                if($issue_attach_type == 'f')
                {
                    $ism_data = array(
                        'ism_order' => '0'
                    );
                }
                elseif($issue_attach_type == 'b')
                {
                    if($att_cnt==1)
                        $att_cnt=2;
                    $ism_data = array(
                        'ism_order' => $att_cnt
                    );
                }
                else
                {
                    $ordr = 1;
                    $crnt_ordr = Issue_management::get_single_record('ism_order','ism_isat_id='.$issue_attach_id)->ism_order;
                    if(isset($crnt_ordr) && !empty($crnt_ordr) && $crnt_ordr > 1)
                    {
                        $ordr = $crnt_ordr;
                        if($att_cnt == $ordr)
                            $ordr--;
                    }
                    $ism_data = array(
                        'ism_order' => $ordr
                    );
                }
                //DB::beginTransaction();
                Issue_management::update_record($ism_data, 'ism_isat_id='.$issue_attach_id, $current_user);
                //DB::commit();
            }
            
        }
        public function delete_issue_attachment(Request $request)
        {
            try
            {
                $validator = Validator::make($request->all(), 
                [
                    //'isat_id' => 'required',
                    //'ism_id' => 'required'
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                $Roles_table = (new \App\Models\Roles())->getTable();
                $Issues_management_table = (new \App\Models\Issue_management())->getTable();
                $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
                //Get neccessary ids
                $volume_id  = (isset($request->volume_id)) ? Rv_decrypt($request->volume_id) : '';
                $issue_id   = (isset($request->issue_id)) ? Rv_decrypt($request->issue_id) : '';
                $criteria = "iss_id = '$issue_id'";
                $issue_data = Issues::get_single_record("iss_id,iss_status", $criteria);
                if($issue_data && $issue_data->iss_status == 'c')
                {
                    return  $this->warning('warning',200,array('error' => 'issue_closed'));
                }
                $post_data    = $request->all();
                $current_user = $this->get_current_user_details();
                $isat_id      = (isset($post_data['isat_id'])) ? Rv_decrypt($post_data['isat_id']) : '';
                $ism_id       = (isset($post_data['ism_id']))  ? Rv_decrypt($post_data['ism_id'])  : '';
                if(!empty($ism_id))
                {
                    $att_det  = Issue_management::get_single_record('ism_isat_id,ism_art_id','ism_id='.$ism_id);
                    $isat_id  = $att_det->ism_isat_id;
                    $ism_art_id = $att_det->ism_art_id;
                }
                if(!empty($isat_id))
                {
                    $att_condi= 'isat_id='.$isat_id;
                    $mng_condi= 'ism_isat_id='.$isat_id;
                    $att_det = Issue_attachments::get_single_record('isat_location,isat_name',$att_condi);
                    $att_loc =  $this->upload_folder_path('uploads/'.$att_det->isat_location.$att_det->isat_name);
                    DB::beginTransaction();
                    $result = Issue_attachments::delete_records($att_condi,'',$current_user);
                    $result = Issue_management::delete_records($mng_condi,'',$current_user);
                    if (file_exists($att_loc)) 
                    {
                        unlink($att_loc);
                    }
                    DB::commit();
                    return $this->success('success',200);
                }
                if(!empty($ism_art_id))
                {
                    $mng_condi= 'ism_art_id='.$ism_art_id;
                    $update_data=array(
                       'aflw_status' => 'u',
                       'aflw_usr_id' => NULL
                    );
    //                $this->update_publish_stage($ism_art_id,$update_data,$current_user);
                    $result = Issue_management::delete_records($mng_condi,'',$current_user);
                    //To remove publication issue from article table.
                    $criteria = 'art_id = "' .$ism_art_id.'"';
                    $data = array('art_publication_issue' => NULL);
                    $current_user = $this->get_current_user_details();
                    $result = Articles::update_record($data, $criteria, $current_user);
                    if($result)
                    {
                        return $this->success('success',200);
                    }
                }
                return  $this->warning('Failed',500); 
            }
            catch(\Exception $e)
            {
                return  $this->failure('Failed',500,$e); 
            }
        }

        public function issue_attach_ordering(Request $request)
        {
            try
            {
                $validator = Validator::make($request->all(), 
                [
                    'volume_id' => 'required',
                    'issue_id' => 'required'
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                $Roles_table = (new \App\Models\Roles())->getTable();
                $Issues_management_table = (new \App\Models\Issue_management())->getTable();
                $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
                //Get neccessary ids
                $post_data    = $request->all();
                $current_user = $this->get_current_user_details();
                $issue_id  = (isset($post_data['issue_id'])) ? Rv_decrypt($post_data['issue_id']) : '';
                $volume_id = (isset($post_data['volume_id']))  ? Rv_decrypt($post_data['volume_id'])  : '';
                $criteria = "iss_id = '$issue_id'";
                $issue_data = Issues::get_single_record("iss_id,iss_status", $criteria);
                if($issue_data && $issue_data->iss_status == 'c')
                {
                    return  $this->warning('warning',200,array('error' => 'issue_closed'));
                }
                $label_id  = 'ism_id';
                $label_order = 'ism_order';
                $ordering_list              = $post_data['ordering_lst'];
                
                $issue_attachment_contents  = Issue_attachments::get_all_records('isat_id,isat_type','isat_iss_id='.$issue_id);
                $attach_arr                 = array();
                foreach ($issue_attachment_contents as $attach)
                {
                    $attach_arr[$attach->isat_id] = $attach->isat_type;
                }
                if (count($ordering_list) > 0)
                {
                    $i   = 1;
                    $inc = null; 
                    foreach ($ordering_list as $order)
                    {
                            $ism_id  = Rv_decrypt($order);
                            $ism_det = Issue_management::get_single_record('ism_isat_id', 'ism_id='.$ism_id);
                            if(isset($attach_arr[$ism_det->ism_isat_id]) && $attach_arr[$ism_det->ism_isat_id] == 'f')
                            {
                                $inc = 0;
                            }
                            elseif(isset($attach_arr[$ism_det->ism_isat_id]) && $attach_arr[$ism_det->ism_isat_id] == 'b')
                            {
                                $att_condi = 'ism_iss_id='.$issue_id;
                                $att_cnt = Issue_management::get_all_records('ism_id='.$att_condi);
                                $inc = count($att_cnt);
                            }
                            else
                            {
                                $inc = $i;
                            }
                            $data = array(
                                    $label_order => $inc
                            );
                            $update_condition = $label_id.'='.$ism_id;
                            Issue_management::update_record($data, $update_condition);
                            $i++;
                    }
                }
                return $this->success('success',200);
            }
            catch(\Exception $e)
            {
                return  $this->failure('Failed',500,$e);
            }
        }

        public function check_page_limit($issue_id)
        {
            $rtn_arr = array();
            $Issues_table = (new \App\Models\Issues())->getTable();
            $Roles_table = (new \App\Models\Roles())->getTable();
            $Articles_table = (new \App\Models\Articles())->getTable();
            $Issues_management_table = (new \App\Models\Issue_management())->getTable();
            $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
            //to get the issue page limit
            $iss_where ='iss_id = '.$issue_id;
            $issue_contents = Issues::get_single_record('iss_page_limit',$iss_where);

            //to get all assossiated articles and attachments page count to the issue
            $tables = array(
                'main_table' => $Issues_management_table,
                'join_table' => array(
                    $Issues_attachments_table => array($Issues_attachments_table . '.isat_id', $Issues_management_table . '.ism_isat_id', 'left'),
                    $Issues_table => array($Issues_table . '.iss_id', $Issues_management_table . '.ism_iss_id','left'),
                    $Articles_table => array($Articles_table . '.art_id', $Issues_management_table . '.ism_art_id','left')
                )
            );
            $select_fields = 'SUM(ism_art_page_cnt) as art_page_cnt, SUM(isat_page) as att_page_cnt';;
            $criteria = " ism_iss_id =".$issue_id." AND IF(rvw_articles.art_id IS NOT NULL, (CASE WHEN (select count(a.art_id) from rvw_articles a where a.art_prev_article_id=rvw_articles.art_id)>0 then false else true end) AND art_status != 'r' AND art_delete_status != 'y' AND art_delete_status != 'w', true) ";
            $article_list = array();
            $art_att_dets = Issue_attachments::get_results_using_joins($tables, $select_fields, $criteria, 'all','ism_order ASC');
            $current_page_cnt = $art_att_dets[0]->art_page_cnt + $art_att_dets[0]->att_page_cnt;
            if($current_page_cnt < $issue_contents->iss_page_limit)
            {
                $rtn_arr = array(
                        'status' => false,
                        'msg'    => 'page count less than limit'
                );
            }
            elseif($current_page_cnt > $issue_contents->iss_page_limit)
            {
                $rtn_arr = array(
                           'status' => false,
                           'msg'    => 'page count exceeds its limit'
                );
            }
            else
            {
                $rtn_arr = array(
                    'status' => true,
                    'msg'    => ''
                );
            }  
            return $rtn_arr;
        }
    //function recevies full path of the pdf location
    public function count_pdf_pages($pdfname) 
    {
          $num = 0;
          $pdfname = 'uploads/'.$pdfname;
          $path = $this->upload_folder_path($pdfname);
          if(file_exists($path))
          {
              $pdftext = file_get_contents($path);
              $num = preg_match_all("/\/Page\W/", $pdftext);
              if($num == 0)
              {
                  $num = preg_match_all("/\/Pages\W/", $pdftext);
              }
          }
          return $num;
    }
    public function exportIssueData(Request $request)
    {
        $validator = Validator::make($request->all(), 
            [
                'issue_id' => 'required',
                'volume_id' => 'required',
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
        $post_data = json_encode($request->all());
        $result = $this->export_issue($post_data);
        if($result)
        {
            if($result['status'] == 'failed')
            {
                return $this->warning('failed',200, $result); 
            }
            else
            {
                return $this->success('success',200, $result); 
            }
        }
    }
    public function export_issue($data)
        {
            //Get neccessary ids
            $post_data = json_decode($data);
            $download_stats = $post_data->dowload_stat;
            $result = NUll;
            $issue_id  = (isset($post_data->issue_id)) ? Rv_decrypt($post_data->issue_id) : NULL;
            $volume_id = (isset($post_data->volume_id))  ? Rv_decrypt($post_data->volume_id)  : NULL;
            $jnl_id = (isset($post_data->jnl_id)) ? Rv_decrypt($post_data->jnl_id): NULL;
            $dwn_stat = (isset($post_data->dowload_stat)) ? $post_data->dowload_stat: FALSE;
            $jnl_code = isset($post_data->jnl_code)? Rv_decrypt($post_data->jnl_code):NULL;
            //loads neccessary models.
            $Articles_table = (new \App\Models\Articles())->getTable();	
            $Issues_table = (new \App\Models\Issues())->getTable();
            $Volumes_table = (new \App\Models\Volumes())->getTable();
            $Issues_management_table = (new \App\Models\Issue_management())->getTable();
            $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
            $Attachment_files = (new \App\Models\Attachment_files())->getTable();
            $Production_stages_info_table = (new \App\Models\Production_stages_info())->getTable();
            $Production_attachment_files_table = (new \App\Models\Production_attachment_files())->getTable();
            $Journal_metadata_table = (new \App\Models\Journal_metadata())->getTable();
            $Article_types_table = (new \App\Models\Article_types())->getTable();
            $return_arr = array();
            $check_closing_protocol = $this->check_before_closing_issue($issue_id);
            if($check_closing_protocol['check_stats'] == FALSE)
            {
                 /* Start - Publication Notification Emails Sent in Error - basecamp ticket */
                $return_arr = array(
                    'status' => 'failed',
                    'art_code_str' => $check_closing_protocol['art_code_str'],
                    'msg' => 'article_not_at_publish_stage'
                );
                return $return_arr;
                /* End - Publication Notification Emails Sent in Error - basecamp ticket */
            }
            $validate_issue = $this->check_page_limit($issue_id);
            if($validate_issue['status'] == FALSE)
            {
                    $return_arr = array(
                            'status'    => 'failed',
                            'msg'       => 'insufficient_page_count'
                    );
                    return $return_arr;
            }

            if($issue_id != NULL)
            {
                //select all attachments corresponding to this issue both issue attachments and article attachments
                $tables = array(
                    'main_table' => $Issues_management_table,
                    'join_table' => array(
                        $Issues_attachments_table => array($Issues_attachments_table . '.isat_id', $Issues_management_table . '.ism_isat_id', 'left'),
                        $Issues_table => array($Issues_table . '.iss_id', $Issues_management_table . '.ism_iss_id','left'),
                        $Volumes_table => array($Volumes_table . '.vol_id', $Issues_table . '.iss_vol_id','left'),
                        $Articles_table => array($Articles_table . '.art_id', $Issues_management_table . '.ism_art_id','left')
                    )
                );
                $date_format = $this->get_platform_date_format($jnl_id);
                $select_fields = "vol_title,art_id,art_code,art_article_upload_path,art_delete_status,iss_number,iss_title,iss_page_limit,iss_due_date as iss_due_date,ism_id,ism_isat_id,ism_art_id,ism_art_page_cnt,art_code,art_article_upload_path,isat_id,isat_iss_id,isat_type,isat_location,isat_name,isat_size,isat_page,ism_order";
                //$criteria = " ism_iss_id =".$issue_id;
                //$select_fields = '';
                $article_list = array();
                $criteria = "ism_iss_id =".$issue_id." AND IF(rvw_articles.art_id IS NOT NULL, (CASE WHEN (select count(a.art_id) from rvw_articles a where a.art_prev_article_id=rvw_articles.art_id)>0 then false else true end) AND art_status = 'a' AND art_status != 'r' AND art_status != 't' AND art_delete_status != 'y' AND art_delete_status != 'w', true) ";
                $issue_data = Issue_management::get_results_using_joins($tables, $select_fields, $criteria, 'all','ism_order ASC');
               // $issue_data = Issue_management::get_results_using_joins($tables, $select_fields, $criteria, 'all','ism_order ASC');
                //setting a unique location to keep all the attachments and metadata-xml to get finally zip
                $export_time = date('d-m-Y_H:i:s');
                //$issue_path   = APP_ISSUE_ATTATCHMENT_PATH . $this->jnl_data->jnl_journal_code . '/' . $volume_id . '/' . $issue_id;
                $issue_path   = 'uploads/issue_management/'.$jnl_code. '/' . $volume_id . '/' . $issue_id;
                $issue_number = $this->get_export_issue_name($issue_data[0],$jnl_code);
                $volume_title = $issue_data[0]->vol_title;
                $page_limit = $issue_data[0]->iss_page_limit;
                $export_to_path =  $this->upload_folder_path($issue_path . '/' . $export_time . '/' . $issue_number);
                if (!file_exists($export_to_path))
                {
                        mkdir($export_to_path, 0765, TRUE);
                }
                if(!empty($issue_data))
                {
                    //XML generation starts
                    $xml_string = '<?xml version="1.0"  encoding="UTF-8"?>'
                            . '<issue number="'.$issue_number.'" volume="'.$volume_title.'" page-lenght="'.$page_limit.'"></issue>';
//                    $xml_path = $issue_path . DIRECTORY_SEPARATOR . $issue_number . '-metadata'  . '.xml';
                    $xml_path = $export_to_path . DIRECTORY_SEPARATOR . $issue_number . '-metadata'  . '.xml';
                    if (file_exists($xml_path))
                    {
                            unlink($xml_path);
                    }
                    file_put_contents($xml_path, $xml_string);
                    $destination = $xml_path;
                    $doc = new \DOMDocument();
                    $doc->formatOutput = false;
                    $doc->load($destination);
                    $xpath = new \DOMXpath($doc);
                    $root_element = $xpath->query('//issue');
                    $root_node = $root_element->item(0);
                    
                    //fetch journal meta.
                    $criteria = "jm_journal_code='".$jnl_code."' AND jm_client_id=".$this->current_client->clnt_id;
                    $journal_meta = Journal_metadata::get_all_records('*', $criteria);
                    $ppub = '';
                    $epub = '';
                    $iet_prefix = 'n';
                    foreach ($journal_meta as $jnl_meta)
                    {
                        if ($jnl_meta->jm_meta_name == 'e_issn')
                            $epub = $jnl_meta->jm_meta_value;
                        elseif ($jnl_meta->jm_meta_name == 'issn')
                            $ppub = $jnl_meta->jm_meta_value;
                        elseif ($jnl_meta->jm_meta_name == 'iet_prefix')
                            $iet_prefix = $jnl_meta->jm_meta_value;
                    }
                    $pub = array(
                            'epub' => $epub,
                            'ppub' => $ppub,
                            'iet_prefix' => $iet_prefix,
                    );
                    $client_code = $this->current_client->clnt_client_code;
                    $review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow  = Config::get($review_config);
                    //load doi library
                    $client_code = $this->current_client->clnt_client_code;
                    $doi_config = 'clients.' . $this->current_client->clnt_client_code . '.doi';
                    $doi_details  = Config::get($doi_config);
                    
                    //Journal-meta starting
                    $journal_meta_node = $doc->createElement('journal-meta');
                    $root_node->appendChild($journal_meta_node);
                    //journal-id
                    $journal_publisher_id = '';
                    if ($pub['iet_prefix'] == 'y')
                            $journal_publisher_id = $doi_details['client_predix'] . '-';

                    $journal_publisher_id .= $jnl_code;
                    $journal_id_node = $doc->createElement('journal_id', $journal_publisher_id);
                    $journal_id_node->setAttribute('journal-id-type', 'publisher-id');
                    $journal_meta_node->appendChild($journal_id_node);

                    //journal-title-group
                    $journal_title_group_node = $doc->createElement('journal-title-group');

                    //journal-title
                    $jnl_journal_name   =  Journals::get_single_record('jnl_journal_name', "jnl_id={$jnl_id}")->jnl_journal_name;
                    $journal_title_node = $doc->createElement('journal-title', $this->filter_html_contents($jnl_journal_name));
                    $journal_title_group_node->appendChild($journal_title_node);

                    //abbrev-journal-title
                    $abbrev_journal_title_node = $doc->createElement('abbrev-journal-title', $jnl_code);
                    $journal_title_group_node->appendChild($abbrev_journal_title_node);

                    $journal_meta_node->appendChild($journal_title_group_node);

                    //issn  First ISSN
                    if ($pub['ppub'] != '')
                    {
                            $issn_node = $doc->createElement('issn', $pub['ppub']);
                            $issn_node->setAttribute('pub-type', 'ppub');
                            $journal_meta_node->appendChild($issn_node);
                    }

                    //issn Second E-ISSN
                    if ($pub['epub'] != '')
                    {
                            $issn_node = $doc->createElement('issn', $pub['epub']);
                            $issn_node->setAttribute('pub-type', 'epub');
                            $journal_meta_node->appendChild($issn_node);
                    }

                    //publisher 
                    $publisher_node = $doc->createElement('publisher');

                    //publisher-name
                    $publisher_name_node = $doc->createElement('publisher-name', 'Thomas Telford Ltd');
                    $publisher_node->appendChild($publisher_name_node);

                    $journal_meta_node->appendChild($publisher_node);
                    //Journal-meta starting
                    
                    //issue-package starting
                    $issue_package = $doc->createElement('issue-package');
                    $root_node->appendChild($issue_package);
                    
                    $order = 1;
                    foreach ($issue_data as $each_data)
                    {
                        if(empty($each_data->ism_art_id) && !empty($each_data->ism_isat_id))
                        {
                            $path = $this->upload_folder_path('uploads/'.$each_data->isat_location . $each_data->isat_name);
                            //issue attachments
                            if (file_exists($path) && $each_data->isat_name != '')
                            {
                                copy($path, $export_to_path . '/' . $each_data->isat_name);
                                if(!isset($client_code)) 
                                    $client_code = $this->current_client->clnt_client_code;

                                $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
                                $issue_config_data = Config::get($issue_management_config);
                                if(!empty($issue_config_data['issue_attachment_type']))
                                {
                                    $iss_att_types = $issue_config_data['issue_attachment_type']; 
                                }
                                $attach_type = (!empty($each_data->isat_type))?$iss_att_types[$each_data->isat_type]:'' ;
                                $attach_node = $doc->createElement('attachment',$each_data->isat_name);
                                $attach_node->setAttribute('type', $attach_type);
                                $attach_node->setAttribute('order', $order);
                                $attach_node->setAttribute('number-of-pages', $each_data->isat_page);
                                $issue_package->appendChild($attach_node);
                            }
                        }
                        else if(!empty($each_data->ism_art_id) && ($each_data->art_delete_status != 'y') && ($each_data->art_delete_status != 'w') && empty($each_data->ism_isat_id))
                        {
                            //article attachments
                            $art_data = array(
                                'art_article_upload_path' =>$each_data->art_article_upload_path,
                                'art_code' =>$each_data->art_code,
                                'art_id' =>$each_data->ism_art_id
                            );
                            $attach_node = $doc->createElement('attachment');
                            $attach_node->setAttribute('type', 'article');
                            $attach_node->setAttribute('order', $order);
                            $attach_node->setAttribute('number-of-pages', $each_data->ism_art_page_cnt);
//                            $attach_node->setAttribute('article_code', $art_data['art_code']);
                            $issue_package->appendChild($attach_node);
                            $article_attachments = $this->export_article_attachments($each_data->ism_art_id,$art_data,$export_to_path,$doc,$attach_node,$pub);
                        }
                        $order++;
                    }
                    $doc->saveXML();
                    $doc->save($xml_path);
                    
                    $source_location = $this->upload_folder_path($issue_path . '/' . $export_time);
                    $zip_location = $this->upload_folder_path($issue_path . '/' . $issue_number . '.zip');
                    if (file_exists($zip_location))
                            unlink($zip_location);
                    $zip_flag = $this->createZip($source_location, $zip_location);
                    if($zip_flag == TRUE)
                    {

                        //this->load->helper('file');
                        if(isset($download_stats) && ($download_stats) && $download_stats == true)
                        {
                            $iss_ful_path = $this->upload_folder_path($issue_path . '/' . $issue_number . '.zip');
                            if(file_exists($iss_ful_path))
                            {
                                $this->download_file($iss_ful_path,'force-download');
                                $del_source = $source_location;
                                $cmd = "rm -r '$del_source'";
					            shell_exec($cmd);
                                //$this->delete_directory($del_source); 
                                //rmdir($del_source);
                            }
                            die;
                        }
                        //$this->ConnectWithPrivateKey();exit;
                        $return_arr = $this->upload_to_server($issue_path . '/' . $issue_number . '.zip', $jnl_id, $issue_number . '.zip');
                        $del_source = $source_location;
                        $cmd = "rm -r '$del_source'";
                        shell_exec($cmd);
                        //$this->delete_directory($del_source); 
                        //rmdir($del_source);
                        //die;

                        return $return_arr;
                    }     
                }
                $return_arr = array(
                    'status'    => 'failed',
                    'msg'       => 'export_failed'
                );
                return $return_arr;
            }
        }
        #2618 Changing the name of the zip files which gets exported in the Issue management section
        public function get_export_issue_name($issue_data,$jnl_code)
        {
            $issue_name = '';
            if(!isset($client_code)) 
                $client_code = $this->current_client->clnt_client_code;
            $issue_management_config = 'clients.' . $this->current_client->clnt_client_code . '.issue_management_config';
            $issue_config_data = Config::get($issue_management_config);
            $prefix_removal_code = $issue_config_data['export_issue_prefix_remove'];
            if(isset($prefix_removal_code) && !empty($prefix_removal_code) && substr($jnl_code, 0, 1) == $prefix_removal_code)
            {
                $jnl_code = substr($jnl_code, 1);
            }

            $issue_name = strtoupper($jnl_code). '_' . $issue_data->vol_title . '_' . $issue_data->iss_number;
            return $issue_name;
        }
        public function export_article_attachments($art_id,$article_data,$export_to_path,$doc=null,$attach_node=null,$pub=null)
        {
            $Articles_table = (new \App\Models\Articles())->getTable();	
            $Issues_table = (new \App\Models\Issues())->getTable();
            $Volumes_table = (new \App\Models\Volumes())->getTable();
            $Issues_management_table = (new \App\Models\Issue_management())->getTable();
            $Issues_attachments_table = (new \App\Models\Issue_attachments())->getTable();
            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
            $Attachment_files = (new \App\Models\Attachment_files())->getTable();
            $Production_stages_info_table = (new \App\Models\Production_stages_info())->getTable();
            $Production_attachment_files_table = (new \App\Models\Production_attachment_files())->getTable();
            $Journals_table = (new \App\Models\Journals())->getTable();
            $Journal_metadata_table = (new \App\Models\Journal_metadata())->getTable();
            $Article_types_table = (new \App\Models\Article_types())->getTable();

            //$uploaded_path = APP_DOC_PATH.$article_data['art_article_upload_path'];
            $uploaded_path = $this->upload_folder_path('uploads/'.$article_data['art_article_upload_path']);
            $export_to_path = $export_to_path . '/' .$article_data['art_code']. '/';
            if (!file_exists($export_to_path))
                    mkdir($export_to_path, 0765, TRUE);
            
            $art_data = new stdClass();
            $art_data->art_id = $article_data['art_id'];
            $latest_author_attachmnt = $this->get_attach_to_author_files($art_data->art_id);
            if(!empty($latest_author_attachmnt))
            {
                foreach($latest_author_attachmnt as $file)
                {
                    $proof_uploaded_path = $uploaded_path . '/production/';
                    if (file_exists($proof_uploaded_path.$file->paf_aflw_id .'/'. $file->paf_file_name) && $file->paf_file_name != '')
                    {
                        copy($proof_uploaded_path .$file->paf_aflw_id .'/'. $file->paf_file_name, $export_to_path . $file->paf_file_name);
                        $art_node = $doc->createElement('file',$article_data['art_code'].'/'.$file->paf_file_name);
                        $art_node->setAttribute('type','final-proof');
                        $attach_node->appendChild($art_node);
    //                        break;
                    }
                }
               
            }
            $where_file_condition = 'atmnt_art_id =' . $art_id;
            $article_attachemnt_data = Attachment_files::get_all_records('atmnt_orginal_upload_path,atmnt_file_name', $where_file_condition);
            if(!$article_attachemnt_data->isEmpty())
            {
                $temp = $export_to_path . 'temp/';
                foreach ($article_attachemnt_data as $each_art_attach)
                {
                    $path = $this->upload_folder_path($uploaded_path .'/'. $each_art_attach->atmnt_file_name);
                    if (file_exists($uploaded_path .'/'. $each_art_attach->atmnt_file_name) && $each_art_attach->atmnt_file_name != '')
                    {
                        $folder_path = $temp . $each_art_attach->atmnt_file_name;
                        if(strpos($each_art_attach->atmnt_file_name,"/")!==false)
                        {
                            $ext_path = explode('/', $each_art_attach->atmnt_file_name);
                            $temp_ext = $temp.$ext_path[0].'/';
                            if (!file_exists($temp_ext))
                                mkdir($temp_ext, 0765, TRUE);
                        }
                        else
                        {
                        if (!file_exists($temp))
                            mkdir($temp, 0765, TRUE);
                        }
                        copy($uploaded_path . '/'. $each_art_attach->atmnt_file_name, $folder_path);
                    }
                }//die;
                //generating client xml file
                $export_article_config = 'clients.' . $this->current_client->clnt_client_code . '.export_article';
                $export_data = Config::get($export_article_config);       
                $article_details = Articles::get_single_record('*,art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,(select artp_abbr_article_type from ' . $Article_types_table . ' where artp_id = art_artp_id) as artp_code,(select artp_article_type from ' . $Article_types_table . ' where  artp_id = art_published_article_type) as published_artp_name,(select jnl_journal_code from ' . $Journals_table . ',' . $Article_types_table . ' where jnl_id = artp_jnl_id and  artp_id = art_artp_id) as jnl_code', 'art_id='.$art_id);
                $doi_config = 'clients.' . $this->current_client->clnt_client_code . '.doi';
                $doi_details  = Config::get($doi_config);

                // $load_models['Articles'] = $this->Articles;
                // $DOI_data = $this->workflow->create_article_doi($art_id, $load_models, $doi_details, $pub['iet_prefix']);
                // $DOI_data['doi_details'] = $doi_details;
                // $this->$export_data['xml_function']($article_details, $DOI_data, $export_to_path, $pub);
                $temp_zip_location = $export_to_path . $article_data['art_code'] . '.zip';
                if (file_exists($temp_zip_location))
                        unlink($temp_zip_location);
                $temp_zip_flag = $this->createZip($temp, $temp_zip_location);
                $del_temp_source = $temp;
                if (file_exists($del_temp_source))
                {
                    $cmd = "rm -r '$del_temp_source'";
                    shell_exec($cmd);
                }
                $art_node = $doc->createElement('file', $article_data['art_code'].'/'.$article_data['art_code'] . '.zip');
                $art_node->setAttribute('type','original-files');
                $attach_node->appendChild($art_node);
            }
            
        }

        private function createZip($source, $destination)
        {
            if (!extension_loaded('zip') || !file_exists($source))
            {
                return false;
            }
            $zip = new ZipArchive();
            if (!$zip->open($destination, ZIPARCHIVE::CREATE))
            {
                return false;
            }
            $source = str_replace('\\', '/', realpath($source));
            if (is_dir($source) === true)
            {
                $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);

                foreach ($files as $file)
                {
                    $file = str_replace('\\', '/', $file);

                    // Ignore "." and ".." folders
                    if (in_array(substr($file, strrpos($file, '/') + 1), array(
                            '.',
                            '..')))
                        continue;

                    $file = realpath($file);

                    if (is_dir($file) === true)
                    {
                        $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
                    }
                    else if (is_file($file) === true)
                    {
                        $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
                    }
                }
            }
            else if (is_file($source) === true)
            {
                $zip->addFromString(basename($source), file_get_contents($source));
            }
            return $zip->close();
        }
        private function download_file($file_path, $type, $new_name_with_location=NULL)
        {
            switch ($type)
            {
                case 'pdf':
                    $mime = 'application/pdf';
                    break;
                case 'zip':
                    $mime = 'application/zip';
                    break;
                case 'jpeg':
                case 'jpg':
                    $mime = 'image/jpg';
                    break;
                default:
                    $mime = 'application/force-download';
                    break;
            }
            if($new_name_with_location == NULL)
                $new_name_with_location = $file_path;
            header('Pragma: public');  // required
            header('Expires: 0');  // no cache
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Last-Modifi$file_pathed: ' . gmdate('D, d M Y H:i:s', filemtime($file_path)) . ' GMT');
            header('Cache-Control: private', false);
            header('Content-Type: ' . $mime);
            header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
            //header('Content-Disposition: attachment; filename="' . basename($new_name_with_location) . '"');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file_path)); // provide file size
            header('Connection: close');
            readfile($file_path);
        }
        private function upload_to_server($source, $jnl_id, $dest_file, $final_file_export = false)
        {
            $source = $this->upload_folder_path($source);
            // Load email config for the current user
            $client_code = $this->current_client->clnt_client_code;
            //$ftp_details = $this->config->item('export'); 
            $export_article_config = 'clients.' . $this->current_client->clnt_client_code . '.remote_file_transfer';
            $export_data = Config::get($export_article_config); 
            $ftp_details = $export_data; 
    //      task#665-Configure FTP export at workflow stage. --starts
            $custom_hostlist = $this->get_custom_hostlist($jnl_id,$final_file_export);
            $jnl_code  =  Journals::get_single_record('jnl_journal_code', "jnl_id={$jnl_id}")->jnl_journal_code;
            $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
		    $prefixPath = storage_path()  . $file_storage_path;
            if(!empty($custom_hostlist))
            {
                $ftp_details['export_article']['hostlist'] = $custom_hostlist;
            }
            if(empty($custom_hostlist) && $final_file_export == true)
            {
                $ftp_details['export_article']['hostlist'] = [];
            }
            if (isset($ftp_details['export_article']['mode']) && $ftp_details['export_article']['mode'] == 'shell')
            {
                //EXPORT USING SHELL
                $result = $this->upload_to_server_from_terminal($source, $jnl_code, $ftp_details);
            }
            else
            {
                $result = array(
                    'status' => 'true',
                    'host_list' => array()
                );
                //EXPORT USING FTP
                $host_list = $ftp_details['export_article']['hostlist'];
                $journal_folder = $ftp_details['export_article']['journal_folder'];
                //to check the connection is over ssl
                $is_ssl = false;
                if(isset($ftp_details['export_article']['over_ssl']))
                    $is_ssl = $ftp_details['export_article']['over_ssl'];
                $fail_any_one = FALSE;
                $result['fail_any_one'] = FALSE;
                if(!empty($host_list))
                {
                    foreach ($host_list as $host)
                    { 
                        //Condition to avoid location from config file, based on the ext_location value
                        if($final_file_export == true && (empty($host['ext_location']) || (!empty($host['ext_location']) && $host['ext_location'] == 'n')))
                        {
                            continue;
                        }
                         //Condition to avoid export for other than final file upload, if ext_location is set to 'y'
                        if($final_file_export == false && (!empty($host['ext_location']) && $host['ext_location'] == 'y'))
                        {
                            continue;
                        }
                        if(!isset($host['portno']) && empty($host['portno']))
                            $host['portno'] = $ftp_details['export_article']['connection_method']['port'];
                        $destination = $this->set_server_path($host['location'], 'ftp', $jnl_code, $journal_folder);
                        $hostname = $host['disply_name'];
                        //#5108 implement SFTP stage export with private key
                        $require_private_key = array();
                        $sftp_flag = FALSE;
                        if(isset($host['enable_private_key']) && $host['enable_private_key'] == 'y')
                        {
                            $sftp_flag = TRUE;
                            $require_private_key['sftp_flag'] 	= $sftp_flag;
                            $require_private_key['key_path'] 	= $prefixPath . $host['private_key_path'];
                        }
                        if(isset($host['hostname']) && isset($host['username']) && isset($host['password']) && isset($host['portno']))
                        {
                            $ftp_connection = $this->remoteConneciton($host['hostname'], $host['username'], $host['password'], $host['portno'],TRUE, $require_private_key);
                            if(isset($ftp_connection['sftp']) && $ftp_connection['sftp'] == TRUE){
                                $sftp_flag = TRUE;
                            }
                            if(isset($ftp_connection['login']) && $ftp_connection['login'] == TRUE)
                            {
                                $conn_id = $ftp_connection['conn_id'];
                                $private_key = $ftp_connection['key'];
                                $ssh = $ftp_connection['ssh'];
                                $this->make_server_directory($conn_id, $destination, $sftp_flag, $ssh);
                                $destination_arr = array_filter(explode('/', $destination));
                                $destination = implode('/', $destination_arr) . '/' . $dest_file;
                                $response = $this->put_files($conn_id, $destination, $source, $sftp_flag,$ssh);
                                if ($response == TRUE)
                                {
                                    $result['host_list'][] = ['host_name' => $host['disply_name'],'status' => 'export_success'];
                                }
                                else
                                {
                                    $result['host_list'][] = ['host_name' => $host['disply_name'],'status' => 'export_failed'];
                                    $result['fail_any_one'] = TRUE;
                                }
                                $this->ftpclose($ftp_connection['conn_id'],$sftp_flag,$ssh);
                            }
                            else
                            {
                                $result['host_list'][] = ['host_name' => $host['disply_name'],'status' => 'remote_connection_failed'];
                                $result['fail_any_one'] = TRUE;
                            }
                        }
    
                    }
                }
                else
                {
                    $result['fail_any_one'] = TRUE;
                }
            }

            return $result;
        }
        private function upload_to_server_from_terminal($soruce, $jnl_code, $ftp_details)
        {
            $result = array(
                'status' => 'failed',
                'host_list' => array()
            );
            $fail_any_one = 'failed';
            $host_list = $ftp_details['export_ftp-connect']['hostlist'];
            $journal_folder = $ftp_details['export_journal_folder'];
            foreach ($host_list as $host)
            {
                $destination = $this->set_server_path($host['location'], 'shell', $jnl_code, $journal_folder);
                $hostname = $host['disply_name'];
                $storage_path = $this->upload_folder_path("");
                $output = shell_exec('sh ' . $storage_path . 'uploads/shell_scripts/articleShellExport.sh ' . $host['hostname'] . ' ' . $host['username'] . ' ' . $host['password'] . ' ' . $destination . ' ' . $storage_path . $soruce);
                if ($output == 0)
                {
                    $fail_any_one = 'success';
                    $result['status'] = 'success';
                    $result['msg'] = 'Exported successfully';
                }
                else
                {
                    $result['msg'] = 'Exported failed';
                }
            }
            $result['fail_any_one'] = $fail_any_one;
            return $result;
        }
        private function set_server_path($path, $upload_mode, $jnl_code, $jnl_floer = TRUE)
        {
            $ftp_location = '';
            if ($path != '')
            {
                $ftp_location = $this->set_path_slash($path, FALSE);
                if ($jnl_floer == TRUE)
                {
                    $ftp_location .= '/' . $jnl_code;
                }
            }
            else
            {
                if ($jnl_floer == TRUE)
                {
                    $ftp_location = '/' . $jnl_code;
                }
                elseif ($upload_mode == 'shell')
                {
                    $ftp_location = '/';
                }
            }
            return $ftp_location;
        }
        public function send_notification_to_author(Request $request)
        {
            try
            {            
                $validator = Validator::make($request->all(), 
                [
                    'issue_id' => 'required',
                    'jnl_id' => 'required',
                    'jnl_code' => 'required'
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',200,$validator->errors());
                }
                $Issue_management_table = (new \App\Models\Issue_management())->getTable();
                $Articles_table = (new \App\Models\Articles())->getTable();
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();

                $return_data = array();
                $issue_id    = Rv_decrypt($request->issue_id);
                $jnl_id      = Rv_decrypt($request->jnl_id);
                $jnl_code    = Rv_decrypt($request->jnl_code);
                $check_closing_protocol = $this->check_before_closing_issue($issue_id);
                if($check_closing_protocol['check_stats'] == FALSE)
                {
                     /* Start - Publication Notification Emails Sent in Error - basecamp ticket */
                    $result_arr = array(
                        'status' => 'failed',
                        'art_codes' => $check_closing_protocol['art_codes'],
                        'art_code_str' => $check_closing_protocol['art_code_str'],
                        'msg' => 'article_not_at_publish_stage'
                    );
                     /* End - Publication Notification Emails Sent in Error - basecamp ticket */
                    return $this->warning('error', 200, $result_arr);
                }
                $tables = array(
                    'main_table' =>  $Issue_management_table,
                    'join_table' => array(
                        $Articles_table => array($Articles_table . '.art_id', $Issue_management_table . '.ism_art_id'),
                        $Article_flow_table => array($Articles_table . '.art_id', $Article_flow_table . '.aflw_art_id'),
                        $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', 'left')
                    )
                );
                $criteria = " ism_iss_id =".$issue_id." AND jwf_stage_type='publish' AND IF(rvw_articles.art_id IS NOT NULL, (CASE WHEN (select count(a.art_id) from rvw_articles a where a.art_prev_article_id=rvw_articles.art_id)>0 then false else true end) AND art_status='a' AND art_status != 'r' AND art_status != 't' AND art_delete_status != 'y' AND art_delete_status != 'w', true) ";
                $select_fields = "art_id,art_code,art_artp_id,art_delete_status,art_status,aflw_art_id,jwf_stage_type,aflw_status";
                $article_details = Issue_management::get_results_using_joins($tables, $select_fields, $criteria, 'all');
                $record = Email_templates::get_single_record('*', "etmp_name='issue_notify_to_author_before_closing' AND etmp_notification='Author'");
                if(empty($record))
                {
                    $return_data = array(
                            'status' => 'failed',
                            'msg' => 'No template found to notify author',
                        );
                    return $this->warning('error', 200, $result_arr);
                        
                }
                $cfty_retire_role = FALSE;
                if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
                {
                    $cfty_retire_role = TRUE;
                }
                if ($record != NULL && !empty($article_details))
                {
                    foreach($article_details as $art_det )
                    {
                        if($art_det->aflw_status == 'c' && $art_det->art_delete_status != 'w' && $art_det->art_delete_status != 'y' && $art_det->art_status == 'a' && $art_det->art_status != 'r' && $art_det->art_status != 't')
                        {
                            $send_mail_to_detail = $this->send_email_to($record->etmp_notification, $jnl_code, $art_det->art_artp_id, $art_det->art_id,$cfty_retire_role);
                            $art_flw_id = Article_flow::get_single_record('aflw_id','aflw_art_id='.$art_det->art_id,'','','aflw_id DESC')->aflw_id;
                            $article_data = Articles::get_single_record('art_submitted_by','art_id='.$art_det->art_id);
                            $send_mail_to = $send_mail_to_detail['email_ids'];
                            $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
                            $custom_data = array(
                                'usr_email'=>$send_mail_to,
                                'mail_recipient_ids'=> $send_mail_to_usr_ids,
                                'article_id'=> $art_det->art_id,
                                'artp_id'=> $art_det->art_artp_id,
                                'jnl_id'=>$jnl_id,
                                'jnl_code'=>$jnl_code,
                                'aflw_id'=>$art_flw_id,
                                'return_batch_id'=>TRUE
                            );
                            $email_data = array(
                                    'type' => 'global',
                                    'action' => 'send',
                                    'email_with_login' => TRUE,
                                    'user_id' => $article_data->art_submitted_by,
                                    'empt_name' => 'issue_notify_to_author_before_closing',
                                    'jnl_user_role'=>array(
                                    'core_role'=>'',
                                    'role_name'=>'',
                                    'jnl_journal_code'=> $jnl_code
                            ),
                                    'custom_data' => $custom_data
                            );
                            $sent_batch_id = $this->master_email_details($email_data); 
                            $select = 'jwf_stage_type';
                            $where = 'aflw_art_id='.$art_det->art_id.' AND aflw_id='.$art_flw_id;
                            $current_status = Article_flow::get_generic_flow($select, $where);
                            $client_code = $this->current_client->clnt_client_code;
                            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config';
                            $review_flow = Config::get($review_config);
                            $current_date_time = date('Y-m-d H:i:s');
                            $attach_mod =   array();
                            $attachments    =  array();
                            $files_attached =  array();
            
                            $send_status[] = Email_send_log::get_single_record('esl_id,esl_user_id,esl_article_id', "esl_batch_id=".$sent_batch_id." AND esl_success_status='n'");
                        }
                    }
                    $send_status = [];
                    $return_data = array(
                        'status' => 'success',
                        'msg' => 'successfully sent mail.',
                    );
                    if(!empty($send_status))
                    {
                        $user_names = array();
                        foreach($send_status as $stat)
                        {
                                if(!empty($stat))
                                    $user_names[] = $this->get_user_display_name($stat->esl_user_id, $jnl_id, TRUE, $stat->esl_article_id);
                        }
                        if(!empty($user_names))
                                $return_data = array(
                                    'status' => 'failed',
                                    'hdn_content' => implode(', ', $user_names),
                                    //'hdn_title' => lang('mail_not_delivered_title'),
                                    'msg' => 'mail not delivered'
                                );
                    }
                    return $this->warning('error', 200, $return_data);
                }
                }catch(\Exception $e)
                {
                    return  $this->failure('Failed',500,$e);
                }
        }
}
