<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Config;
use DB;
use App\Models\Articles;
use App\Models\Article_keywords;
use App\Models\Article_flow;
use App\Http\Traits\StagemovementTrait;
use App\Models\Roles;
use phpDocumentor\Reflection\Types\Null_;
use Illuminate\Support\Facades\URL;
use App\Http\Traits\SubmissionTrait;
use Illuminate\Support\Str;
use App\Http\Traits\ArticlelistTrait;
use App\Models\Article_types;
use App\Models\Attachment_files;
use App\Models\Article_pdf;
use App\Models\Article_classification;
use App\Models\User_to_journals;
use App\Http\Traits\StandaloneDataTrait;
use App\Http\Traits\IthenticateTrait;
use App\Models\Issues;
use App\Models\Volumes;
use App\Models\Issue_management;
use App\Models\Ithenticate_autosubmission;
use App\Models\Article_generic_form_data;
use App\Http\Traits\UtilityTrait;
use App\Models\Generic_flows;
use Response;
class Manage_Ithenticate_Api extends Controller
{
    use IthenticateTrait;
    public $currentuser;

    public function submit_document(Request $request)
    {
        set_time_limit(0);
        try {
            $result = array(
                'status' => 'failed');
            $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
            $ithenticateconfig  = Config::get($ithenticate_config);
            
            $return_array = array();
            $post_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            if ($post_data)
		    {
                $article_id = $this->decrypt_data($post_data['art_id']);
			    $aflw_id = $this->decrypt_data($post_data['art_flow_id']);
			    $pdf_id = $post_data['pdf_id'];
			    $jnlcode = $post_data['jnlcode'];
                $platform_data = $this->platform_basic_settings_data($jnlcode);
                $jnlid = $platform_data->jnl_id;
                $result = $this->submit_to_ithenticate($this->current_client->clnt_id,$article_id, $jnlid, $pdf_id, $this->current_user, $aflw_id);
            }
           
            return  $this->success('Success', 200, $result);
        }catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }

    }
    public function show_words_count(Request $request)
    {
        try {
            $result = array(
                'status' => 'failed');
            $return_array = array();
            $post_data = $request->all();
            if($post_data)
            {
                $this->current_user = $this->get_current_user_details();
                $article_id = $this->decrypt_data($post_data['art_id']);
			    $aflw_id = $this->decrypt_data($post_data['art_flow_id']);
			    $article_type_id = $post_data['article_type_id'];
			    $jnlcode = $post_data['jnlcode'];
                $criteria = "pdf_art_id={$article_id} and pdf_show_status='y'";
                $pdf_detail = Article_pdf::get_single_record('*', $criteria, '', '', 'pdf_id desc');
                $platform_data = $this->platform_basic_settings_data($jnlcode);
                $jnlid = $platform_data->jnl_id;
                $js_date_format = static::date_format_map($platform_data->jset_date_format);
                $date_format = $this->get_platform_date_format($jnlid);
                if (!empty($pdf_detail))
				{
                    /**
                     * Task 5299 iThenticate V2 feature
                     */
                    $ith_v2 = FALSE;
                    if(isset($this->current_client->modules->mdl_ithenticate) && isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y' && $this->current_client->modules->mdl_ithenticate == 'y')
                    {
                        $ith_v2 = TRUE;
                    }

                    if ((empty($pdf_detail->pdf_ith_view_only_url) || $ith_v2 == TRUE) && !empty($pdf_detail->pdf_ith_document_id))
						{
                            if(isset($article_type_id) && $article_type_id!='')
                            {
                                $artp_id =$article_type_id;
                            }else {
                                $article_data = Articles::get_article_data($article_id);
                                $artp_id =$article_data->artp_id;
                            }
                            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
                            $criteria2 = "atotp_artp_id={$artp_id}";
                            if($ith_v2==true && $pdf_detail->pdf_ith_v2_fileupload_status == 'n')
                            {
                                $this->submit_pdf_to_ithenticate($pdf_detail,TRUE);
                                $pdf_detail = Article_pdf::get_single_record('*', $criteria, '', '', 'pdf_id desc');
                            }
                            $article_type_advance = $Article_type_advance_options::get_single_record('atotp_artp_id', $criteria2); 
                            $ith_api_condition = array(
                                'acrd_clnt_id' => $this->current_client->clnt_id,
                                'acrd_api_name' => 'ithenticate',
                                'acrd_artp_id' => $article_type_advance->atotp_artp_id,
                                'acrd_jnl_id' => $jnlid
                            );
                            $sid = $this->login_ithenticate($ith_api_condition);
                            $similarity_report = $this->similarity_report($pdf_detail->pdf_ith_document_id, $sid, $ith_api_condition,$article_type_advance->atotp_artp_id);
                            //echo '<pre>';print_r($similarity_report);exit;
                            if (isset($similarity_report['is_pending']) && $similarity_report['is_pending'] == TRUE)
								{
									$result = array(
										'status' => 'failed');
								}else
                                {
                                    $pdf_file['ith_ver_change'] = FALSE;
                                    if($ith_v2 == TRUE && $pdf_detail->pdf_ith_version == 'v1' && !empty($similarity_report['view_only_url']))
                                    {
                                        $previous_ithenticates['ith_ver_change'] = TRUE;
                                    }

                                    $pdf_file['ith_view_url'] = $similarity_report['view_only_url'];
									$pdf_file['ith_percent_match'] = $similarity_report['percent_match'];
									$pdf_file['words'] = $similarity_report['words'];
									$pdf_file['pdf_ith_report_date'] = $similarity_report['response_timestamp'];
                                    $generic_forms_table = (new \App\Models\Generic_forms)->getTable();
                                    $generic_form_elements_table = (new \App\Models\Generic_form_elements)->getTable();
                                    $auth_tables_identifier = array(
										'main_table' => 'rvw_article_gnf_form_data_' . $jnlcode,
										'join_table' => array(
											$generic_forms_table => array( $generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data_'.$jnlcode.'.gdata_atf_id'),
											$generic_form_elements_table => array($generic_form_elements_table.'.emt_gucf_id',$generic_forms_table.'.gncf_id')
										));
                                       
                                        $where_cond = "gdata_art_id ={$article_id} AND gncf_form_type='author_submission' and gdata_unique_identifier IS NOT NULL  AND emt_identifier_type IS NOT NULL AND emt_identifier_type!='custom' AND emt_identifier_type !='' AND gdata_unique_identifier='PRE_PRINT_IDENTIFIER' ";     
                                        $unique_identifier = Article_generic_form_data::get_results_using_joins($auth_tables_identifier,  'gdata_data,gdata_display_data', $where_cond,'all');
                                        $identifier_flag=FALSE;
                                        if (isset($unique_identifier) && !empty($unique_identifier))
                                        {
                                            foreach($unique_identifier as $identifier)
                                            {
                                                if(!empty($identifier->gdata_data))
													{
														$identifier_flag=TRUE;
																		
													}	
                                            }
                                        }
                                        $pdf_file['pdf_ith_sub_date']	=	' as on '.date($date_format. ' h:i:s A', strtotime($pdf_file['pdf_ith_report_date']));
                                        $count_html='';
                                        $url =   URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnlcode . '/show-similarity-report/' . $this->encrypt_data($pdf_detail->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($jnlid);
                                        if($identifier_flag==TRUE)
											{
												$count_html.= '<div id="identifier_id_new" class="alert alert-idetification-message">'.customTrans('ithenticate.system_identification').'</div>';
												$count_html.= '<div id="identifier_id" class="alert alert-idetification-message remark">'.customTrans('ithenticate.system_identification_remark').'</div>';
																												
											}
                                            $result = array(
												'status' => 'success',
												'html' => $count_html,
                                                'url'=>$url,
                                                'pdf_data'=>$pdf_file
												
											);
                                
                                        }
                        
                        }elseif (!empty($pdf_detail->pdf_ith_view_only_url) && !empty($pdf_detail->pdf_ith_document_id)){
                                $pdf_file['ith_view_url'] = $pdf_detail->pdf_ith_view_only_url;
								$pdf_file['ith_percent_match'] = $pdf_detail->pdf_ith_similarity_percentage;
								$pdf_file['words'] = $pdf_detail->pdf_word_count;
								$pdf_file['pdf_ith_report_date'] = $pdf_detail->pdf_ith_report_date;
                                $generic_forms_table = (new \App\Models\Generic_forms)->getTable();
                                    $generic_form_elements_table = (new \App\Models\Generic_form_elements)->getTable();
                                    $auth_tables_identifier = array(
										'main_table' => 'rvw_article_gnf_form_data_' . $jnlcode,
										'join_table' => array(
											$generic_forms_table => array( $generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data_'.$jnlcode.'.gdata_atf_id'),
											$generic_form_elements_table => array($generic_form_elements_table.'.emt_gucf_id',$generic_forms_table.'.gncf_id')
										));
                                       
                                        $where_cond = "gdata_art_id ={$article_id} AND gncf_form_type='author_submission' and gdata_unique_identifier IS NOT NULL  AND emt_identifier_type IS NOT NULL AND emt_identifier_type!='custom' AND emt_identifier_type !='' AND gdata_unique_identifier='PRE_PRINT_IDENTIFIER' ";     
                                        $unique_identifier = Article_generic_form_data::get_results_using_joins($auth_tables_identifier,  'gdata_data,gdata_display_data', $where_cond,'all');
                                        $identifier_flag=FALSE;
                                        if (isset($unique_identifier) && !empty($unique_identifier))
										 {
																											
											foreach($unique_identifier as $identifier)
											{
												if(!empty($identifier->gdata_data))
												{
													$identifier_flag=TRUE;
																	
												}	
																												
											}	
										}
                                        $pdf_file['pdf_ith_sub_date']	=	' as on '.date($date_format. ' h:i:s A', strtotime($pdf_file['pdf_ith_report_date']));
                                        $count_html='';
                                      // $url= URL::to('/') . '/' . $this->current_client->platform_type . '/' .  $jnlcode . '/show-similarity-report?' . encrypt_link('pdf_id=' . $pdf_detail->pdf_id . '&artp_id=' . $article_id.'&jnl_id='.$jnlid);
                                       $url =   URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnlcode . '/show-similarity-report/' . $this->encrypt_data($pdf_detail->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($jnlid);
                                        if($identifier_flag==TRUE)
											{
												$count_html.= '<div id="identifier_id_new" class="alert alert-idetification-message">'.customTrans('ithenticate.system_identification').'</div>';
												$count_html.= '<div id="identifier_id" class="alert alert-idetification-message remark">'.customTrans('ithenticate.system_identification_remark').'</div>';
																												
											}
                                            $result = array(
												'status' => 'success',
												'html' => $count_html,
                                                'url'=>$url,
                                                'pdf_data'=>$pdf_file
												
											);


                        }


                }

            }
            return  $this->success('Success', 200, $result);

        }catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }

    }

    public function show_similarity_report(Request $request)
    {
        try
        {
            $result = array(
                'status' => 'failed');
             $post_data=$request->all();
             $redirect_url = NULL;
             if($post_data)
             {
                $pdf_id=$this->decrypt_data($post_data['pdf_id']); 
                $criteria = "pdf_id={$pdf_id}";
                $pdf_detail = Article_pdf::get_single_record('*', $criteria);
                if(!empty($pdf_detail))
                {
                     /**
                     * Task 5299 iThenticate V2 feature
                     */
                    $artp_id = NULL;
                    $ith_cred = $this->getIthenticatecred($pdf_detail->pdf_ith_document_id,$artp_id);
                    $jnl_id = isset($ith_cred['acrd_jnl_id'])?$ith_cred['acrd_jnl_id']:"";
                    $ith_v2 = FALSE;
                    if(isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
                    {
                        $ith_v2 = TRUE;
                        if($pdf_detail->pdf_ith_version == 'v1' || $pdf_detail->pdf_ith_v2_fileupload_status == 'n')
                        {
                            $this->submit_pdf_to_ithenticate($pdf_detail,TRUE);
                            $pdf_detail = Article_pdf::get_single_record('*', $criteria);
                        }

                    }

                    if ($this->check_valid_view_url($pdf_detail) && $ith_v2 == FALSE)
                    {
                        $redirect_url = $pdf_detail->pdf_ith_view_only_url;
                        
                    }else{
                        $ith_api_condition = array(
                            'acrd_clnt_id' => $this->current_client->clnt_id,
                            'acrd_api_name' => 'ithenticate',
                            'acrd_artp_id' => $artp_id,
                            'acrd_jnl_id' => $jnl_id
                        );
                        $sid = $this->login_ithenticate($ith_api_condition);
                        if ($sid != NULL)
                        {
                            $similarity_report = $this->similarity_report($pdf_detail->pdf_ith_document_id, $sid, $ith_api_condition,$artp_id);
                            
                            if ($similarity_report != NULL)
                            {
                                $redirect_url = $similarity_report['view_only_url'];
                            }
                        }
                    }
                }
                $result = array(
                     'status' => 'success',
                    'url'=>$redirect_url
                   
                 );
             }
             return  $this->success('Success', 200, $result);
            
             
        }catch (\Exception $e) {
           
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function autosubmit_to_ithenticate(Request $request)
	{
        try
        {
        $currentdate = date('Y-m-d');
        $criteria = "ias_status='n' AND ias_posted_date>={$currentdate} ";
        $all_pdfs = Ithenticate_autosubmission::get_all_records('*', $criteria);
        if(!empty($all_pdfs)) 
        {
            foreach ($all_pdfs as $pdf)
		{
			$this->submit_pdf_to_ithenticate($pdf);
		}
        }   
        }catch (\Exception $e) {
           
            return  $this->failure('Failed', 500, $e);
        }

    }
    private function submit_pdf_to_ithenticate($pdf_data,$ith_version_change = FALSE)
	{
        $client_details = '';
        if($ith_version_change == FALSE)
        {
            $Clients = new \App\Models\Clients();
            $criteria1 = "clnt_id={$pdf_data->ias_clnt_id}";
            $client_details = $Clients::get_single_record('clnt_client_code',$criteria1);
        }
        
        if (!empty($client_details) || $ith_version_change == TRUE)
		{
            $this->current_user = $this->get_current_user_details();
            $currentUser = null;
            if(!empty($this->current_user))
            {
                $currentUser = $this->current_user;
            }
            if($ith_version_change == TRUE)
            {
                $Artpdf_table = (new \App\Models\Article_pdf())->getTable();
                $articletype_table = (new \App\Models\Article_types())->getTable();
                $Article_table = (new \App\Models\Articles())->getTable();

                $article_pdf_details = $pdf_data;

                $condition = array(
                    'pdf_id'=> $pdf_data->pdf_id
                );
                $tables = array(
                    'main_table' => $Artpdf_table,
                    'join_table' => array(
                        $Article_table => array('art_id','pdf_art_id'),
                        $articletype_table => array('art_artp_id','artp_id')
                    )
                );
                $article_type_details = Article_types::get_results_using_joins($tables, 'artp_jnl_id', $condition, 'single');

                $client_id = $this->current_client->clnt_id;
                $pdf_id = $pdf_data->pdf_id;
            }
            else
            {
                $ithenticate_config = 'clients.' . $client_details->clnt_client_code . '.ithenticate';
                $ithenticateconfig  = Config::get($ithenticate_config);
                $ithenticateconfig['retry_submission_limit'];
                if ($pdf_data->ias_retry_count > $ithenticateconfig['retry_submission_limit'])
                {
                    return;
                }
                $conditiontype = "artp_id={$pdf_data->ias_artp_id}";
                $article_type_details = Article_types::get_single_record('artp_jnl_id', $conditiontype);
                $condition = "pdf_id={$pdf_data->ias_pdf_id}";
                $article_pdf_details = Article_pdf::get_single_record('pdf_art_id',$condition);

                $client_id = $pdf_data->ias_clnt_id;
                $pdf_id = $pdf_data->ias_pdf_id;
            }
            

            if ($article_type_details != NULL && $article_pdf_details != NULL)
			{
                $result = $this->submit_to_ithenticate($client_id, $article_pdf_details->pdf_art_id, $article_type_details->artp_jnl_id, $pdf_id, $currentUser,null);
                if($ith_version_change == TRUE)
                {
                    return $result;
                }
                else
                {
                    if ($result['status'] == 'success')
                    {
                        $update_arr['ias_status'] = 'y';
                        Ithenticate_autosubmission::update_record($update_arr, 'ias_id=' . $pdf_data->ias_id);
                    
                        
                    }else{
                        $Ithenticate_autosubmission_table = (new \App\Models\Ithenticate_autosubmission())->getTable();
                        Ithenticate_autosubmission::execute_query('
                            UPDATE ' . $Ithenticate_autosubmission_table . '
                            SET `ias_retry_count` = `ias_retry_count` + 1
                            WHERE `ias_id` = ' . $pdf_data->ias_id . '
                        ');

                    }
                }
                
            }
        }
    }

    /**
     * for EULA -- accept
     * input -- article type id, journal id
     */
    public function eulaAccept(Request $request)
    {
        try
        {
            $result = array('status' => 'failed');
            $postdata = $request->all();
            if(isset($postdata['jnlid']) && isset($postdata['artpid']))
            {
                $jnldata = array('input'=>$postdata['jnlid'],'type'=>'number', 'rv_enc_data'=>true );
                $artpdata = array('input'=>$postdata['artpid'],'type'=>'number', 'rv_enc_data'=>true );
                $jnlflag= $this->Rv_validator($jnldata);
                $artpflag= $this->Rv_validator($artpdata);

                if(isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y' && $jnlflag === true &&  $artpflag === true)
                {
                    $jnlid = Rv_decrypt($postdata['jnlid']);
                    $artpid = Rv_decrypt($postdata['artpid']);

                    $ith_api_condition = array(
                        'acrd_clnt_id' => $this->current_client->clnt_id,
                        'acrd_api_name' => 'ithenticate',
                        'acrd_artp_id' => $artpid,
                        'acrd_jnl_id' => $jnlid
                    );

                    $ithv2url = $sid = null;
                    $credential = $this->get_credentials($ith_api_condition);
                    if(isset($credential['password']))
                    {
                        $sid = $credential['password'];
                        $ithv2url = $credential['username'];
                        $this->currentuser = $this->get_current_user_details();
                        $userID = 'rv_user_'.$this->currentuser['user_id'];

                        $data  = array(
                            'userid' => $userID
                        );

                        //check user already accept T&C or not
                        $response_rep = $this->do_call_v2($ithv2url,$data,$sid,'PUT','check_tnc');
                        $response_rep_arr = (array) json_decode($response_rep);
                        if(isset($response_rep_arr['success']) && $response_rep_arr['success'] === false)
                        {
                            $isotime = $this->getnormaltimetoISO();
                            $data = array(
                                'user_id' => $userID,
                                'accepted_timestamp' => $isotime,
                                'language'=> 'en-US'
                            );
                            $response_rep = $this->do_call_v2($ithv2url,$data,$sid,'POST','tncaccept');
                            $response_rep_arr = (array) json_decode($response_rep);
                            if(isset($response_rep_arr['accepted_timestamp']))
                            {
                                $result['status'] = 'success';
                            }

                        }
                        else
                        {
                            $result['status'] = 'success';
                        }
                    }
                }
            }
            return  $this->success('Success', 200, $result);
        }catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
}