<?php

    namespace App\Http\Controllers;

    use Illuminate\Http\Request;
    use App\Http\Traits\JatsArtcileXmlTrait;
    use DOMDocument;
    use Config;
    use DB;
    use Response;
    use Illuminate\Support\Str;
    use App\Models\Articles;

    class Manage_Jats_Article_Api extends Controller
    {
        use JatsArtcileXmlTrait;

        public function create_meca_package(Request $request)
        {
            try {
                //to create manifest.html and manifest.xml
                $file_names_arr     =   array();
                
                $artXmldtdPath      =   '';     //DTD path for article xml
                $mfestXmldtdPath    =   '';     //DTD path for manifest xml
                
                // The naming convention is {UUID}-meca.zip.
                $uuid   =   (string) Str::uuid() . '-MECA';
                $file_names_arr[]   =   array('file_name'=>$uuid, 'file_type'=>'Archive file', 'location'=>'N/A');
                // All files, including the required metadata files, are packaged in a zip file.
                $meca_path_fldr =  public_path().'/storage/uploads/meca_files/' . $uuid;
                if (!file_exists($meca_path_fldr)) {
                    mkdir($meca_path_fldr, 0777, true);
                }

                //DTD folder and DTD file name
                $jatsDirectory  =   'JATS-Archiving-1-4-DTD';
                $jatsDtd        =   'JATS-archivearticle1-4.dtd';
                $file_names_arr[]   =   array('file_name'=>$jatsDtd, 'file_type'=>'Article Xml DTD file', 'location'=>$jatsDirectory.'/');
                $manifestDtd        =   'MECA_manifest.dtd';
                $file_names_arr[]   =   array('file_name'=>$manifestDtd, 'file_type'=>'Manifest Xml DTD file', 'location'=>$jatsDirectory.'/');
                
                $client_functionality =  $this->get_client_functionalities($this->current_client->clnt_id, $this->current_client->clnt_client_code);
                if(!isset($client_functionality->cfty_meca_export) || 
                (isset($client_functionality->cfty_meca_export) && $client_functionality->cfty_meca_export == 'n'))
                {
                    return $this->success('failure', 201, customTrans('jats.no_permission'));
                }

                $art_id         =   decrypt_link($request->art_id);
                $jnl_id         =   decrypt_link($request->jnl_id);
                $select         =   'art_id, art_code, jnl_journal_code, jnl_journal_name';
                $art_details    =   Articles::get_article_details($select,"art_id={$art_id}");

                if(count($art_details) > 0) {
                    $data           =   $art_details[0];
                    $art_code       =   $data->art_code;
                    $jnl_name       =   $data->jnl_journal_name;
                }

                // Copy JATS DTD files to the export folder
                $srcedtdPath    =   base_path('config/jats/dtd/'.$jatsDirectory); // Provide the absolute path to your JATS DTD file
                $destidtdPath   =   $meca_path_fldr; // Parent directory where the folder will be copied
                $cpyjatsdtdfldr =   $this->copy_jats_dtd_folder($srcedtdPath, $destidtdPath);
                if($cpyjatsdtdfldr['status'] == 'failed') {
                    return $cpyjatsdtdfldr['msg'];
                } else {
                    $artXmldtdPath   =   $jatsDirectory.'/'.$jatsDtd;
                    $mfestXmldtdPath   =   $jatsDirectory.'/'.$manifestDtd;
                }

                //for creating JATS Archiving XML
                $xmlArr     =   $this->createJatsArchiveXmlTags($art_id, $meca_path_fldr, $artXmldtdPath);
                $file_names_arr[]   =   array('id' =>'article-xml', 'item_type'=>'article-metadata', 'item_descr' => '>This is the article.xml file that contains the submission’s metadata', 'file_name'=>$art_code.'.xml', 'file_type'=>'Article metadata file', 'location'=>'Root', 'inst_media_typ' => 'application/xml', 'inst_xlink_href' => $art_code.'xml');
                $xml        =   $xmlArr['xml'];

                $resp   =   $this->validateJatsXml($xml);
                if($resp == '') {
                    // Copy the article files and attachments to the export folder only if the xml validation is success
                    $file_names_arr     =   $this->copy_article_files($art_id, $jnl_id, $meca_path_fldr, $file_names_arr);
                    
                    //create manifest html
                    $this->create_jats_manifest_html($art_code, $file_names_arr, $meca_path_fldr);
                    
                    //create manifest xml
                    $this->createJatsManifestXmlTags($file_names_arr, $meca_path_fldr, $mfestXmldtdPath);

                    $returnArr  =   array('status'=>true, 'msg' => customTrans('jats.jats_created'), 'file' => $xml);
                    return $this->success('success', 200, $returnArr);
                } else {
                    $rand               =   Str::random(4);
                    $jats_dtd_failed    =   str_replace('%REF-NO%', $rand, customTrans('jats.dtd_validation_failed'));
                    $returnArr          =   array('status'=>false, 'msg' => $jats_dtd_failed);
                    echo $resp;exit;
                    // If the dtd validation fails, inform the client with ref no. and send a mail to review team.
                    $this->report_dtd_issue($resp, $art_code, $rand, $xml, $jnl_name);
                    return $this->success('failure', 201, $returnArr);
                }
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            }
        }

        /*
        * Create manifest html file
        */
        private function create_jats_manifest_html($art_code, $file_names_arr, $meca_path_fldr) 
        {
            $row = '';
            $file_name  =   $art_code . '-manifest.html';
            foreach ($file_names_arr as $file) {
                $row .= '<tr>';
                $row .= '<td>' . $file['file_name'] . '</td>';
                $row .= '<td>' . $file['file_type'] . '</td>';
                $row .= '<td>' . $file['location'] . '</td>';
                $row .= '</tr>';
            }
            $row .= '<tr>';
            $row .= '<td>' . $file_name . '</td>';
            $row .= '<td>Manifest metadata html</td>';
            $row .= '<td>Root</td>';
            $row .= '</tr>';

            $html_content = "
                        <html>
                            <head>
                                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>
                                <title>".$art_code."</title>
                            </head>
                            <body>
                                <table border='1' cellspacing='0' cellpadding='4'>
                                    <thead bgcolor='#9ccde7'>
                                        <th>File Name</th>
                                        <th>File Type</th>
                                        <th>Location</th>
                                    </thead>
                                    <tbody bgcolor='#ffffff'>
                                        {$row}
                                    </tbody>
                                </table>
                            </body>
                        </html>";
            $file_location_html =   $meca_path_fldr .'/'. $file_name ;
            file_put_contents($file_location_html, $html_content);
            return true;
        }

        /*
        * Copy the article files and attachments to the export folder
        */
        private function copy_article_files($art_id, $jnl_id, $meca_path_fldr, $file_names_arr) {
            //article attachments
            $attachmentsArr     =   $this->show_art_attachments($art_id, $jnl_id);
            if(count($attachmentsArr) > 0) {
                $attchLbl   =   'Attachments';
                $stor_path = storage_path('/app/public/uploads');
                foreach($attachmentsArr as $key) {
                    $stor_file_path     =   $stor_path.'/'.$key->atmnt_orginal_upload_path .'/'. $key->atmnt_file_name;
                    // push attachment names for making manifest.html
                    $mime_content_type  =   mime_content_type($stor_file_path);
                    if($mime_content_type != NULL) {
                        $mctArr = explode( '/', $mime_content_type);
                        $mimetype       =   $mctArr[0];
                        $mime_subtype   =   $mctArr[1];
                    }

                    $file_names_arr[]   =   array('id' =>$key->atmnt_id, 'item_type'=>'article attachment', 'file_name'=>$attchLbl.'/'.$key->atmnt_file_name, 'file_type'=>'File uploaded by Author', 'location'=>$attchLbl.'/', 'item_descr' => 'This is the article attachment uploaded by the author', 'inst_media_typ' => $mimetype.'/'.$mime_subtype, 'inst_xlink_href' => $attchLbl.'/'.$key->atmnt_file_name);
                    if (file_exists($stor_file_path)) {
                        // All article files, are packaged in a 'attachents' folder
                        $attFldr    =   $meca_path_fldr . '/'. $attchLbl;
                        if (!file_exists($attFldr)) {
                            mkdir($attFldr, 0777, true);
                        }
                        // Store the path of destination file 
                        $artFilesdesti = $attFldr . '/'. $key->atmnt_file_name;
                        // Copy article attachments to export folder
                        copy($stor_file_path, $artFilesdesti);
                    }
                }
            }
             //article copyright files
            $cnd                =   'crt_art_id = '.$art_id;
            $Copyright          =   new \App\Models\Copyright();
            $copyright_details  =   $Copyright::get_copyright($cnd, 'crtm_license_name, copy_location, copy_att_name', TRUE);
            if (!empty($copyright_details))
            {
                $stor_path = storage_path('/app/public');
                // push copyright names for making manifest.html
                $file_names_arr[]   =   array('file_name'=>$cpyrtLbl.'/'.$copyright_details->copy_att_name, 'file_type'=>'Copyright file', 'location'=>$cpyrtLbl.'/');
                $stor_file_path     =   $stor_path.'/'.$key->atmnt_orginal_upload_path .'/'. $key->atmnt_file_name;
                // push attachment names for making manifest.html
                $mime_content_type  =   mime_content_type($stor_file_path);
                if($mime_content_type != NULL) {
                    $mctArr = explode( '/', $mime_content_type);
                    $mimetype       =   $mctArr[0];
                    $mime_subtype   =   $mctArr[1];
                }

                $file_names_arr[]   =   array('id' =>$key->atmnt_id, 'item_type'=>'article attachment', 'file_name'=>$attchLbl.'/'.$key->atmnt_file_name, 'file_type'=>'File uploaded by Author', 'location'=>$attchLbl.'/', 'item_descr' => 'This is the article attachment uploaded by the author', 'inst_media_typ' => $mimetype.'/'.$mime_subtype, 'inst_xlink_href' => $attchLbl.'/'.$key->atmnt_file_name);
                $file_names_arr[]   =   array('id' =>'agreement', 'item_type'=>'author agreement', 'file_name'=>$cpyrtLbl.'/'.$copyright_details->copy_att_name, 'file_type'=>'Copyright file', 'location'=>$cpyrtLbl.'/', 'item_descr' => 'Author Agreement', 'inst_media_typ' => $mimetype.'/'.$mime_subtype, 'inst_xlink_href' => $attchLbl.'/'.$key->atmnt_file_name);
                   
                // path of source file 
                $licsFilesrce =  $stor_path.'/'. $copyright_details->copy_location.'/'.$copyright_details->copy_att_name;
                if (file_exists($licsFilesrce)) {
                    $cpyrtLbl   =   'Copyrights';
                    // Copyright files, are packaged in a 'copyrights' folder
                    $copyFldr    =   $meca_path_fldr . '/'. $cpyrtLbl;
                    if (!file_exists($copyFldr)) {
                        mkdir($copyFldr, 0777, true);
                    }
                    // Store the path of destination file 
                    $licsFiledesti = $copyFldr . '/'. $copyright_details->copy_att_name;
                    // Copy article attachments to export folder
                    copy($licsFilesrce, $licsFiledesti);
                }
            }
            return $file_names_arr;
        }

        /*
        * validate the jats xml and then export
        */
        private function validateJatsXml($xmlPath)
        {
            // Enable error reporting for libxml
            libxml_use_internal_errors(true);

            // Load the XML document
            $dom = new DOMDocument();
            $dom->load($xmlPath);

            // Validate the XML against the DTD
            if ($dom->validate()) {
                return '';
            } else {
                $levels = [
                    LIBXML_ERR_WARNING => 'Warning',
                    LIBXML_ERR_ERROR   => 'Error',
                    LIBXML_ERR_FATAL   => 'Fatal Error',
                ];
    
                $errArr     =   '';
                $i          =   1;
                foreach (libxml_get_errors() as $error) {
                    $level      =   $levels[$error->level] ?? 'Unknown';
                    $errArr     .=   sprintf(
                                        "%d). %s: Line no. %d: %s",
                                        $i,
                                        $level,
                                        $error->line,
                                        trim($error->message)
                                    ).'<br/>';
                    $i++;
                }
                // Clear libxml errors
                libxml_clear_errors();
                return $errArr;
            }
        }

        /*
        * This function will send a email to review team about DTD validation failed along with failed xml
        */
        private function report_dtd_issue($bug_report, $art_code, $issue_code, $xml_file, $jnl_name)
        {
            $bug_report =   str_replace('/n', '<br/>', $bug_report);
            $subject    =   $this->current_client->clnt_client_name . ' - JATS XML DTD Validation issue on ' . $art_code . ' [Reference no :' . $issue_code . ']';
            $body       =   '<p>Reference no : ' . $issue_code . '<br>';
            $body       .=  customTrans('jats.mail.article_details') . '<br>';
            $body       .=  'Client : ' . $this->current_client->clnt_client_name . '<br>';
            $body       .=  customTrans('jats.mail.journal') . ' : ' . $jnl_name . '<br>';
            $body       .=  customTrans('jats.mail.article_code') .' : ' . $art_code . '<p>';
            $body       .=  '<p>Issue list :<br>';
            $body       .=  $bug_report . '<p>';

            return $this->send_email_to_team_review($subject, $body, array($xml_file));
        }

        /*
        * This function will copy the JATS dtd folder from main location to each export folder
        */
        private function copy_jats_dtd_folder($source, $destination)
        {
            // Ensure the source folder exists
            if (!is_dir($source)) {
                return array('status'=>'failed', 'msg'=>"JATS DTD directory does not exist.");
            }

            // Get the folder name of the source
            $folderName     = basename($source);
            $destination    = rtrim($destination, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . $folderName;

            // Create the destination folder (the folder itself) if it doesn't exist
            if (!is_dir($destination)) {
                mkdir($destination, 0755, true);
            }

            // Open the source directory
            $dir = opendir($source);

            if ($dir === false) {
                return array('status'=>'failed', 'msg'=>"Failed to open JATS DTD directory.");
            }

            // Loop through the contents of the source directory
            $cpyFail    =   '';
            while (($file = readdir($dir)) !== false) {
                if ($file === '.' || $file === '..') {
                    continue;
                }

                $srcPath    = $source . DIRECTORY_SEPARATOR . $file;
                $destPath   = $destination . DIRECTORY_SEPARATOR . $file;

                if (is_dir($srcPath)) {
                    // Recursively copy subdirectory
                    $this->copy_jats_dtd_folder($srcPath, $destPath);
                } else {
                    // Copy file
                    if (!copy($srcPath, $destPath)) {
                        $cpyFail    .=   "Failed to copy file: '$srcPath' in JATS DTD directory.\n";
                    }
                }
            }
            if ($cpyFail != '') {
                return array('status'=>'failed', 'msg'=>$cpyFail);
            }

            closedir($dir);
            return array('status'=>'success', 'msg'=>'');
        }
    }