<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Journals;
use App\Models\Keyword_category;
use App\Models\Keywords;
use App\Models\Keyword_relationship;
use App\Models\Excluded_journal_keywords;
use App\Models\Article_keywords;
use App\Http\Traits\KeywordTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use ZipArchive;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Cache; //Task #1180 Reduce the load time of manage keywords section

//use App\Http\Traits\UtilityTrait;
class Manage_Keyword_Api extends Controller
{
    use KeywordTrait;
    // use UtilityTrait;

    public function get_all_jnlkeyword_records(Request $request)
    {
        try {
            $form_data = $request->all();
            /*Task #1180 Reduce the load time of manage keywords section 
            $criteria = 'kwd_user_keyword IN (\'n\',\'y\') ';
            $having = 'cnt >=0';
            $journals = Journals::get_all_records('jnl_id,jnl_journal_name');
            $keyword_type = $this->KeywordData('keywordtype')['keywordtype'];
            $operant_type = $this->KeywordData('operanttype')['operanttype'];
            $search = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
            $total_records = 0;
            $jnl_keyword_records = array();
            $enable_separate_keywords = FALSE;
            if (isset($this->current_client->functionality->cfty_separate_adhoc_keywords) && $this->current_client->functionality->cfty_separate_adhoc_keywords == 'y') {
                $enable_separate_keywords = TRUE;
            }
             end Task #1180 Reduce the load time of manage keywords section */
            /*Task #1180 Reduce the load time of manage keywords section*/
            $search = $form_data['paramsdet'] ?? [];
            $enable_separate_keywords = isset($this->current_client->functionality->cfty_separate_adhoc_keywords) && $this->current_client->functionality->cfty_separate_adhoc_keywords == 'y';
            $sort_field = $form_data['sort_field'] ?? 'kwd_name';
            $sort_order = $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 10;
            $keyword_number = $search['keyword_number'] ?? null;
            $keyword_operant = $search['keyword_operant'] ?? null;
            $query = Keywords::query();
            /*end Task #1180 Reduce the load time of manage keywords section*/
            if (!empty($search)) {
                if (isset($search['keyword_name']) && $search['keyword_name'] != '') {
                    $key_name = htmlspecialchars($search['keyword_name'], ENT_QUOTES);
                    // $criteria .= ' AND LOWER(kwd_name) LIKE LOWER("%' . trim($key_name) . '%")'; //Task #1180 Reduce the load time of manage keywords section
                    $query->where('kwd_name', 'LIKE', '%' . trim($key_name) . '%'); //Task #1180 Reduce the load time of manage keywords section
                }
                // if (isset($search['keyword_journal']) && $search['keyword_journal'] != NULL) {
                //     $criteria .= ' AND kwdrl_jnl_id = ' . $search['keyword_journal'];
                if (isset($search['keyword_journal']) && $search['keyword_journal'] != null) {
                    $query->whereHas('keywordRelationships', function ($q) use ($search) {
                        $q->where('kwdrl_jnl_id', $search['keyword_journal']);
                    }); //Task #1180 Reduce the load time of manage keywords section
                }
                /*Task #1180 Reduce the load time of manage keywords section
                if ($enable_separate_keywords == TRUE) {
                    if (isset($search['keyword_type'])) {
                        $criteria .= ' AND kwd_user_keyword ="' . $search['keyword_type'] . '"';
                        $find_value = $search['keyword_type'];
                    }
                    $keyword_number = isset($search['keyword_number']) ? $search['keyword_number'] : '';
                    $keyword_operant = isset($search['keyword_operant']) ? $search['keyword_operant'] : '';
                    if ($keyword_number != '')
                        $having = 'cnt ' .  $keyword_operant . ' ' . $keyword_number . '';
                        Task #1180 Reduce the load time of manage keywords section */
                        if ($enable_separate_keywords && isset($search['keyword_type'])) {
                            $query->where('kwd_user_keyword', $search['keyword_type']); //Task #1180 Reduce the load time of manage keywords section
                }
            }
            // if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y') {
            //     $criteria .= ' AND kwdrl_inactive =\'n\'';
            // }
            /* Task #1180 Reduce the load time of manage keywords section
            $group_by = 'kwd_id';
            $sort_field = $form_data['sort_field'] ?? 'kwd_name';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
            // DB::enableQueryLog();
            $all_records = Keywords::get_jnl_keywords('count(kwd_name) as count,"" as keyword_data, count(DISTINCT art_artp_id) as cnt', TRUE, $criteria, NULL, $group_by, NULL, NULL, $having);
          //  $queries = DB::getQueryLog();
		         //   dd($queries); 
            if (!empty($all_records)) {
                $total_records = $all_records->count;

                if ($total_records != 0) {
                   // $queries = DB::enableQueryLog();
                    $select = 'kwd_id, REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\') as kwd_name,kwd_user_keyword,CONCAT(REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\'),"\t",kwd_user_keyword) as keyword_data,kwdrl_id, GROUP_CONCAT(DISTINCT jnl_journal_name SEPARATOR "\t") as names, GROUP_CONCAT(distinct jnl_id) as ids, count(DISTINCT art_artp_id) as cnt,kwdrl_inactive';
                    $limit = $form_data['per_page'] ?? '10';;
                    $jnl_keyword_records =  Keywords::get_jnl_keywords($select, FALSE, $criteria, $limit, $group_by, $sort_field, $sort_order, $having);
                   // $queries = DB::getQueryLog();
		           // dd($queries); 
                }
                   end Task #1180 Reduce the load time of manage keywords section */$total_records = $query->count();
    /* Task #1180 Reduce the load time of manage keywords section*/
            $query = $query->with(['journals' => function ($q) {
                $q->select('jnl_id', 'jnl_journal_name');
            }]);
    
            //sorting
            $query->leftJoin('rvw_keyword_relationship', 'rvw_keywords.kwd_id', '=', 'rvw_keyword_relationship.kwdrl_kwd_id')
            ->leftJoin('rvw_journals', 'rvw_keyword_relationship.kwdrl_jnl_id', '=', 'rvw_journals.jnl_id')
            ->select('rvw_keywords.*')
            ->groupBy('rvw_keywords.kwd_id');
      
      // Apply sorting logic
      switch ($sort_field) {
          case 'cnt':
              $query->leftJoin('rvw_article_keywords', 'rvw_keywords.kwd_id', '=', 'rvw_article_keywords.ak_keyword_id')
                    ->orderByRaw('COUNT(rvw_article_keywords.ak_art_id) ' . $sort_order);
              break;
      
          case 'names':
              $query->orderByRaw('GROUP_CONCAT(rvw_journals.jnl_journal_name SEPARATOR "\t") ' . $sort_order);
              break;
      
          case 'kwdrl_inactive':
              $query->orderBy('rvw_keyword_relationship.kwdrl_inactive', $sort_order);
              break;
      
          case 'keyword_data':
              $query->orderByRaw("CONCAT(REPLACE(REPLACE(kwd_name,'&','&'),'&','&'),'\t',kwd_user_keyword) " . $sort_order);
              break;
      
          default:
              $query->orderBy($sort_field, $sort_order);
              break;
      }
            if ($keyword_number && $keyword_operant) {
                $query->groupBy('rvw_keywords.kwd_id')
                      ->havingRaw('(SELECT COUNT(DISTINCT ak_art_id) FROM rvw_article_keywords WHERE ak_keyword_id = rvw_keywords.kwd_id) ' . $keyword_operant . ' ?', [$keyword_number]);
            /* end Task #1180 Reduce the load time of manage keywords section*/
                    }
            /* Task #1180 Reduce the load time of manage keywords section
            $data['journals'] = $journals;
            $data['keywordtype'] = $keyword_type;
            $data['operanttype'] = $operant_type;
            $data['enable_separate_keywords'] = $enable_separate_keywords;
            $data['jnl_keyword_records'] = $jnl_keyword_records;
            $data['total_records'] = $total_records;
            end Task #1180 Reduce the load time of manage keywords section */
            /*Task #1180 Reduce the load time of manage keywords section*/
            $jnl_keyword_records = $query->paginate($limit, ['*'], 'page');
    
            $data = [
                'journals' => Cache::remember('all_journals', 3600, function () {
    return Journals::select('jnl_id', 'jnl_journal_name')->get();
}),
                'keywordtype' => $this->KeywordData('keywordtype')['keywordtype'],
                'operanttype' => $this->KeywordData('operanttype')['operanttype'],
                'enable_separate_keywords' => $enable_separate_keywords,
                'jnl_keyword_records' => [
                    'current_page' => $jnl_keyword_records->currentPage(),
                    'data' => $jnl_keyword_records->map(function ($keyword) {
                        return [
                            'kwd_id' => $keyword->kwd_id,
                            'kwd_name' => $keyword->kwd_name,
                            'kwd_user_keyword' => $keyword->kwd_user_keyword,
                            'kwd_category_id' => $keyword->kwd_category_id,
                            'keyword_data' => $keyword->kwd_name . "\t" . $keyword->kwd_user_keyword,
                            'kwdrl_id' => $keyword->keywordRelationships->first()->kwdrl_id ?? null,
                            'names' => $keyword->journals->implode('jnl_journal_name', "\t") ?? null,
                            'ids' => $keyword->journals->implode('jnl_id', ",") ?? null,
                            'cnt' => $keyword->articles->count() ?? 0,
                            'kwdrl_inactive' => $keyword->keywordRelationships->first()->kwdrl_inactive ?? null,
                            'kwd_posted_date' => $keyword->kwd_posted_date,
                            'kwd_posted_by' => $keyword->kwd_posted_by,
                            'kwd_proxy_id' => $keyword->kwd_proxy_id,
                        ];
                    }),
                    'first_page_url' => $jnl_keyword_records->url(1),
                    'from' => $jnl_keyword_records->firstItem(),
                    'last_page' => $jnl_keyword_records->lastPage(),
                    'last_page_url' => $jnl_keyword_records->url($jnl_keyword_records->lastPage()),
                    'links' => $jnl_keyword_records->links(),
                    'next_page_url' => $jnl_keyword_records->nextPageUrl(),
                    'path' => $jnl_keyword_records->path(),
                    'per_page' => $jnl_keyword_records->perPage(),
                    'prev_page_url' => $jnl_keyword_records->previousPageUrl(),
                    'to' => $jnl_keyword_records->lastItem(),
                    'total' => $jnl_keyword_records->total(),
                ],
                'total_records' => $total_records,
            ];
    /*end Task #1180 Reduce the load time of manage keywords section*/
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function get_all_catkeyword_records(Request $request)
    {
        try {
            $form_data = $request->all();
            $keyword_type = $this->KeywordData('keywordtype')['keywordtype'];
            $operant_type = $this->KeywordData('operanttype')['operanttype'];
            $category = Keyword_category::get_all_records('kwc_id,kwc_name', 'kwc_is_default=\'n\'');
            $criteria = 'kwd_user_keyword IN (\'n\',\'y\') ';
            $having = 'cnt >=0';
            $total_records = 0;
            $cat_keyword_records = array();
            $enable_separate_keywords = FALSE;
            if (isset($this->current_client->functionality->cfty_separate_adhoc_keywords) && $this->current_client->functionality->cfty_separate_adhoc_keywords == 'y') {
                $enable_separate_keywords = TRUE;
            }
            $search = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
            if (!empty($search)) {
                if (isset($search['keyword_name']) && $search['keyword_name'] != '') {
                    $key_name = htmlspecialchars($search['keyword_name'], ENT_QUOTES);
                    $criteria .= ' AND LOWER(kwd_name) LIKE LOWER("%' . trim($key_name) . '%")';
                }
                if (isset($search['keyword_category']) && $search['keyword_category'] != NULL) {

                    $criteria .= ' AND kwdrl_category_id = ' . $search['keyword_category'];
                    $find_value = $search['keyword_category'];
                }
                if ($enable_separate_keywords == TRUE) {
                    if (isset($search['keyword_type']) && $search['keyword_type'] != NULL) {
                        $criteria .= ' AND kwd_user_keyword ="' . $search['keyword_type'] . '"';
                        $find_value = $search['keyword_type'];
                    }
                    $keyword_number = isset($search['keyword_number']) ? $search['keyword_number'] : '';
                    $keyword_operant = isset($search['keyword_operant']) ? $search['keyword_operant'] : '';
                    if ($keyword_number != '')
                        $having = 'cnt ' .  $keyword_operant . ' ' . $keyword_number . '';
                }
            }
            if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y') {
                $criteria .= ' AND kwdrl_inactive =\'n\'';
            }
            $group_by = 'kwd_id';
            $sort_field = $form_data['sort_field'] ?? 'kwd_name';
            $sort_order =  $form_data['sort_order'] ?? 'asc';

            $all_records = Keywords::get_cat_keywords('count(kwd_name) as count,"" as keyword_data,COUNT(DISTINCT art_artp_id) as cnt ', TRUE, $criteria, NULL, NULL, $sort_field, $sort_order, $having);
            if (!empty($all_records)) {
                $total_records = $all_records->count;
                $select = 'kwd_id,kwd_name,kwd_user_keyword,CONCAT(kwd_name,"\t",kwd_user_keyword) as keyword_data,kwdrl_id,kwdrl_inactive,kwdrl_category_id, GROUP_CONCAT(DISTINCT kwc_name ORDER BY kwc_id ASC SEPARATOR "\t") as names, GROUP_CONCAT(DISTINCT kwc_id ORDER BY kwc_id ASC) as ids, COUNT(DISTINCT art_artp_id) as cnt ';
                $limit = 25;
                $cat_keyword_records =  Keywords::get_cat_keywords($select, FALSE, $criteria, $limit, $group_by, $sort_field, $sort_order, $having);
            }

            $data['category'] = $category;
            $data['operanttype'] = $operant_type;
            $data['keywordtype'] = $keyword_type;
            $data['cat_keyword_records'] = $cat_keyword_records;
            $data['total_records'] = $total_records;
            $data['enable_separate_keywords'] = $enable_separate_keywords;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function get_all_category_records(Request $request)
    {
        try {
            $form_data = $request->all();
            $criteria = 'kwc_is_default =\'n\'';
            $search = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
            if (!empty($search)) {
                if (isset($search['category_search']) && $search['category_search'] != '') {
                    $criteria .= ' AND kwc_name LIKE "%' . $search['category_search'] . '%"';
                }
            }
            $categories = array();
            $all_records = Keyword_category::get_single_record('count(kwc_id) as cnt', $criteria);
            $total_records = $all_records->cnt;
            if ($total_records != 0) {
                $sort_field = $form_data['sort_field'] ?? 'kwc_id';
                $sort_order =  $form_data['sort_order'] ?? 'asc';
                $limit = $form_data['per_page'] ?? 10;
                $select = 'kwc_id,kwc_name';
                $categories = Keyword_category::get_paginated_records($select, $criteria, $sort_field, $sort_order, $limit);
            }
            $data['categories'] = $categories;
            $data['total_records'] = $total_records;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function save_category(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'category'      => 'required',
            ]);
            if ($validator->fails()) {

                return  $this->failure('Failed', 422, $validator->errors());
            }

            $category_details = array(
                'kwc_name' => $form_data['category'],
            );
            //check code duplicate
            $cat_id = NULL;
            if ($form_data['hdn_cat_id'] != '') {
                $cat_id = $this->decrypt_data($form_data['hdn_cat_id']);
            }
            //check form exist 
            if (isset($cat_id) && $cat_id != NULL) {
                $criteria = "kwc_name='{$form_data['category']}' AND kwc_id !={$cat_id}";
            } else {
                $criteria = 'kwc_name="' . $form_data['category'] . '"';
            }
            $category_name = Keyword_category::get_single_record('count(*) cnt', $criteria);
            //checking form submission
            $check_cat_name = TRUE;
            if ($category_name->cnt > 0) { //form name exist
                $check_cat_name = FALSE;
                return $this->warning('warning', 200, customTrans('keyword.duplicate-category-name'), 'warning');
            } else if (($form_data['category']) && $check_cat_name === TRUE) {
                if ($cat_id != '') {  //edit
                    $criteria = 'kwc_id="' . $cat_id . '"';
                    $result = Keyword_category::update_record($category_details, $criteria, $this->current_user);

                    if ($result) {
                        $data = array(
                            'success' => true,
                            'mode'    => 'update',
                            'message' => customTrans('keyword.category-update-msg'),
                        );
                        return $this->success('success', 200, $data);
                    }
                } else {
                    //insert record
                    $cat_insert_id = Keyword_category::insert_record($category_details, $this->current_user);
                    $cat_id = $this->encrypt_data($cat_insert_id);
                    if (!empty($cat_insert_id)) {
                        $data = array(
                            'success' => true,
                            'mode'    => 'add',
                            'result'  => $cat_id,
                            'message' => customTrans('keyword.category-added-msg'),
                        );
                        return $this->success('success', 200, $data);
                    }
                }
            } else {
                return $this->warning('Failed', 500, customTrans('keyword.category-submission-err'));
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function save_journal_keyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'keywords'      => 'required',
                'journals'      => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $is_edit = FALSE;
            $hdn_keyword_id = '';
            if (isset($form_data['hdn_keyword_id']) && !empty($form_data['hdn_keyword_id'])) {
                $is_edit = TRUE;
                $hdn_keyword_id = $form_data['hdn_keyword_id'];
            }
            $keyword = $form_data['keywords'];
            $journal = $form_data['journals'];

            $error_msg = '';
            if ($is_edit == FALSE) //add mode
            {
                $keyword = is_array($keyword) ? $keyword : explode(',', $keyword);
                for ($i = 0; $i < count($keyword); $i++) {
                    $keyword_val = isset($keyword[$i]['value']) ? $keyword[$i]['value'] : $keyword[$i];
                    $keyword_val = str_replace('\\', '"', $keyword_val);
                    $kwd_name = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
                    $journal = is_array($journal) ? $journal : explode(',', $journal);
                    for ($j = 0; $j < count($journal); $j++) {
                        $journal_id = $journal[$j];
                        $condition = "kwd_name ='" . $kwd_name . "' AND kwdrl_jnl_id='" . $journal_id . "'";
                        if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y')
                            $condition .= " AND kwdrl_inactive = 'n'";
                        $get_keyword_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt');
                        if ($get_keyword_record->cnt > 0) {
                            $get_journal_record = Journals::get_single_record('jnl_journal_name', "jnl_id=" . $journal_id);
                            $journal_name = $get_journal_record->jnl_journal_name;
                            $error_msg .= "keyword '" . $kwd_name . "' already exists for journal '" . $journal_name . "'<br/>";
                        }
                    }
                }
                if ($error_msg != "") {
                    return $this->warning('warning', 200, $error_msg, 'warning');
                } else {
                    for ($i = 0; $i < count($keyword); $i++) {
                        $keyword_val = $keyword[$i]['value'];
                        $keyword_val = str_replace('\\', '"', $keyword_val);
                        $kwd_name = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
                        $data = "kwd_name='" . strtoupper($kwd_name) . "'";
                        $get_keyword_record = Keywords::get_single_record('count(*) cnt,kwd_id', $data);
                        if ($get_keyword_record->cnt > 0) {
                            $keyword_id = $get_keyword_record->kwd_id;
                            $where = "kwdrl_kwd_id=$keyword_id and kwdrl_jnl_id is not null";
                            $select = 'count(*) as cnt';
                            if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y')
                                $where = "kwdrl_inactive= 'n'";
                            $journal_records = Keywords::check_keyword_exists($where, $select);
                            if ($journal_records->cnt > 0)
                                $insertIDs[$i] = array(
                                    "action" => "u",
                                    "key_id" => $keyword_id
                                );
                            else
                                $insertIDs[$i] = array(
                                    "action" => "i",
                                    "key_id" => $keyword_id
                                );
                        } else {
                            $insertdata = array(
                                'kwd_name' => strtoupper($kwd_name)
                            );
                            $keyword_id = Keywords::insert_record($insertdata, $this->current_user);
                            $insertIDs[$i] = array(
                                "action" => "i",
                                "key_id" => $keyword_id
                            );
                        }
                        for ($j = 0; $j < count($journal); $j++) {
                            $journal_id = $journal[$j];
                            $data_keyword_journal = "kwdrl_jnl_id=$journal_id AND kwdrl_kwd_id= $keyword_id";
                            $get_keyword_relation_record = Keyword_relationship::get_single_record('count(*) cnt', $data_keyword_journal);
                            $data_update = array(
                                'kwdrl_inactive' => 'n'
                            );
                            if ($get_keyword_relation_record->cnt > 0) {
                                $result = Keyword_relationship::update_record($data_update, $data_keyword_journal, $this->current_user);
                            } else {
                                $data_keyword_journal = array(
                                    'kwdrl_jnl_id' => $journal_id,
                                    'kwdrl_kwd_id' => $keyword_id
                                );
                                $result = Keyword_relationship::insert_record($data_keyword_journal, $this->current_user);
                            }
                            $insertIDs[$i] = array(
                                "action" => "i",
                                "key_id" => $keyword_id
                            );
                        }
                    }
                    $data = array(
                        'message' => customTrans('keyword.keyword_added_msg'),
                        'result' => $insertIDs,
                        'mode' => 'add'
                    );
                    return $this->success('success', 200, $data);
                }
            } else {

                $keyword_val = $keyword;
                $keyword_val = str_replace('\\', '"', $keyword_val);
                $keyword = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
                $condition = "kwd_name='" . $keyword . "' AND kwd_id!=" . $this->decrypt_data($hdn_keyword_id);
                if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y')
                    $condition .= " AND kwdrl_inactive= 'n'";
                $get_keyword_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt');
                if ($get_keyword_record->cnt > 0) {
                    return $this->warning('warning', 200, customTrans('keyword.duplicate_keyword'), 'warning');
                } else {
                    $journal = is_array($journal) ? $journal : explode(',', $journal);
                    $new_keyword = '';
                    $condition = "kwd_name='" . $keyword . "' AND kwd_id !=" . $this->decrypt_data($hdn_keyword_id);
                    $data = array(
                        'kwd_name' => strtoupper($keyword)
                    );
                    $get_keyword_record = Keywords::check_keyword_exists($condition, 'kwd_id');
                    if (!empty($get_keyword_record->kwd_id)) {
                        $keyword_id = $get_keyword_record->kwd_id;
                        $new_keyword = $keyword_id;
                        $keyword_del = $this->Keywords->delete_records(array(
                            "kwd_id" =>  $this->decrypt_data($hdn_keyword_id)
                        ), '', $this->current_user);
                    } else {

                        $update = Keywords::update_record($data, 'kwd_id=' . $this->decrypt_data($hdn_keyword_id), $this->current_user);
                        $keyword_id =  $this->decrypt_data($hdn_keyword_id);
                    }

                    $where = "kwdrl_kwd_id='" .  $this->decrypt_data($hdn_keyword_id) . "' and kwdrl_jnl_id is not null";
                    Keyword_relationship::delete_records($where, '', $this->current_user);

                    for ($j = 0; $j < count($journal); $j++) {
                        $journal_id = $journal[$j];
                        $condition = "kwdrl_jnl_id=" . $journal_id . " AND kwdrl_kwd_id=" . $keyword_id;
                        $get_keyword_relation_record = Keyword_relationship::get_single_record('count(*) cnt', $condition);
                        $data_update = array(
                            'kwdrl_inactive' => 'n'
                        );

                        if ($get_keyword_relation_record->cnt > 0) {
                            $data_keyword_journal = 'kwdrl_jnl_id =' . $journal_id . ' AND kwdrl_kwd_id=' . $keyword_id;
                            $result = Keyword_relationship::update_record($data_update, $data_keyword_journal, $this->current_user);
                            Keyword_relationship::update_record($data_update, $data_keyword_journal, $this->current_user);
                        } else {
                            $data_keyword_journal = array(
                                'kwdrl_jnl_id' => $journal_id,
                                'kwdrl_kwd_id' => $keyword_id
                            );
                            Keyword_relationship::insert_record($data_keyword_journal, $this->current_user);
                        }
                    }
                    $data = array(
                        'success' => true,
                        'mode' => 'update',
                        'hdn_key_id' => $hdn_keyword_id,
                        'message' => customTrans('keyword.keyword_update_msg')
                    );
                    return $this->success('success', 200, $data);
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function save_category_keyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            if (isset($form_data['keywords']) && !empty($form_data['keywords'])) {
                $validator = Validator::make($request->all(), [
                    'keywords'      => 'required',
                    'category'      => 'required',
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }
            }
            /*else
            {
                echo '<pre>'; print_r($form_data); die;
                $validator = Validator::make($request->all(), [
                    'edit_keyword_category[keyword]'      => 'required',
                    'edit_keyword_category[category]'      => 'required',
                  ]);
            }*/

            $is_edit = FALSE;
            $hdn_keyword_id = '';
            if (isset($form_data['hdn_keyword_id']) && !empty($form_data['hdn_keyword_id'])) {
                $is_edit = TRUE;
                $hdn_keyword_id = $form_data['hdn_keyword_id'];
            }
            $error_msg = '';
            if ($is_edit == FALSE) //add mode
            {
                $keyword = $form_data['keywords'];
                $category = $form_data['category'];

                $condition = "kwd_name='" . htmlspecialchars($keyword, ENT_QUOTES) . "' AND kwdrl_category_id=" . $category;
                if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y')
                    $condition .= " AND kwdrl_inactive= 'n'";

                $get_keyword_category_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt');
                if ($get_keyword_category_record->cnt == 0) {

                    $data = "kwd_name ='" . strtoupper(htmlspecialchars($keyword, ENT_QUOTES)) . "'";
                    $get_keyword_record = Keywords::get_single_record('count(*) as cnt,kwd_id', $data);
                    if ($get_keyword_record->cnt > 0) {

                        $keyword_id = $get_keyword_record->kwd_id;
                        $return_array['hdn_key_id'] = $this->encrypt_data($keyword_id);
                    } else {
                        $data = array(
                            'kwd_name' => strtoupper(htmlspecialchars($keyword, ENT_QUOTES))
                        );
                        $keyword_id = Keywords::insert_record($data, $this->current_user);
                        $return_array['hdn_key_id'] = '';
                    }

                    $data_keyword_category = "kwdrl_category_id=$category AND kwdrl_kwd_id=" . $keyword_id;
                    $get_keyword_relation_record = Keyword_relationship::get_single_record('count(*) as cnt', $data_keyword_category);
                    $data_update = array(
                        'kwdrl_inactive' => 'n'
                    );
                    if ($get_keyword_relation_record->cnt > 0) {
                        $result = Keyword_relationship::update_record($data_update, $data_keyword_category, $this->current_user);
                    } else {
                        $data_keyword_category = array(
                            'kwdrl_category_id' => $category,
                            'kwdrl_kwd_id' => $keyword_id
                        );
                        $result = Keyword_relationship::insert_record($data_keyword_category, $this->current_user);
                    }

                    $data = array(
                        'success' => true,
                        'mode'    => 'add',
                        'result'  => $keyword_id,
                        'message' => customTrans('keyword.keyword_added_msg'),
                    );
                    return $this->success('success', 200, $data);
                } else {
                    return $this->warning('warning', 200, customTrans('keyword.duplicate_keyword'), 'warning');
                }
            } else {
                $keyword = htmlspecialchars($form_data['keywords'], ENT_QUOTES);
                $category_data = $form_data['category'];
                $category_data = is_array($category_data) ? $category_data : explode(',', $category_data);
                $hdn_keyword_id = $form_data['hdn_keyword_id'];
                $condition = "kwd_name ='" . $keyword . "' AND kwd_id!=" . $this->decrypt_data($hdn_keyword_id);
                if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y')
                    $condition .= "kwdrl_inactive= 'n'";
                $get_keyword_category_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt,kwd_id');
                if ($get_keyword_category_record->cnt == 0) {
                    $insertIDs = array();
                    $data = "kwd_name='" . strtoupper($keyword) . "'";
                    $get_keyword_record = Keywords::check_keyword_exists($data, 'kwd_id');
                    if (!empty($get_keyword_record)) {
                        $result = $get_keyword_record->kwd_id;
                        $keyword_id = $get_keyword_record->kwd_id;
                        $new_keyword = $keyword_id;
                    } else {
                        $data = array(
                            'kwd_name' => strtoupper($keyword)
                        );
                        $result = Keywords::update_record($data, 'kwd_id=' . $this->decrypt_data($hdn_keyword_id), $this->current_user);
                        $keyword_id = $this->decrypt_data($hdn_keyword_id);
                    }


                    $where = "kwdrl_kwd_id='" . $this->decrypt_data($hdn_keyword_id) . "' and kwdrl_category_id is not null";
                    $category_delete = Keyword_relationship::delete_records($where, '', $this->current_user);

                    if (count($category_data) > 0) {
                        for ($j = 0; $j < count($category_data); $j++) {
                            $data = "kwdrl_category_id=" . $category_data[$j] . " AND kwdrl_kwd_id=" . $keyword_id;

                            $get_keyword_relation_record = Keyword_relationship::get_single_record('count(*) as cnt', $data);
                            $data_update = array(
                                'kwdrl_inactive' => 'n'
                            );
                            if ($get_keyword_relation_record->cnt > 0) {
                                $category_insert = Keyword_relationship::update_record($data_update, $data, $this->current_user);
                            } else {
                                $data = array(
                                    'kwdrl_category_id' => $category_data[$j],
                                    'kwdrl_kwd_id' => $keyword_id
                                );
                                $category_insert = Keyword_relationship::insert_record($data, $this->current_user);
                            }

                            array_push($insertIDs, $category_insert);
                        }
                    }

                    $condition = "kwdrl_kwd_id=" . $this->decrypt_data($hdn_keyword_id);
                    $get_keyword_category_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt');
                    if ($get_keyword_category_record->cnt == 0) {
                        Keywords::delete_records("kwd_id=" . $this->decrypt_data($hdn_keyword_id), '', $this->current_user);
                    }

                    $result_arr = array(
                        'success' => true,
                        'mode'    => 'update',
                        'result'  => $hdn_keyword_id,
                        'message' => customTrans('keyword.keyword_update_msg'),
                    );
                    return $this->success('success', 200, $result_arr);
                } else {
                    return $this->warning('warning', 200, customTrans('keyword.duplicate_keyword'), 'warning');
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function keyword_handler()
    {
        try {
            $journal_keyword = TRUE;
            if (isset($this->current_client->functionality->keyword_hierarchy) && $this->current_client->functionality->keyword_hierarchy == 'c') {
                $journal_keyword = FALSE;
            }
            if ($journal_keyword == TRUE) {
                $journals = Journals::get_all_records('jnl_id,jnl_journal_name');
                $data['journals'] = $journals;
                return $this->success('success', 200, $data);
            } else {
                $category = Keyword_category::get_all_records('kwc_id,kwc_name', 'kwc_is_default=\'n\'');
                $data['category'] = $category;
                return $this->success('success', 200, $data);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function delete_category(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $search = isset($form_data['params']) ? $form_data['params'] : '';
            if (isset($search) && $search != '') {
                $category_id = $this->decrypt_data($search['cat_id']);
                $result = Keywords::get_single_record('count(kwd_category_id) as cnt', 'kwd_category_id=' . $category_id);
                $from_keyword_relationship = Keyword_relationship::get_all_records('kwdrl_kwd_id', 'kwdrl_category_id=' . $category_id);
                if ($result->cnt == 0 && count($from_keyword_relationship) == 0) { //delete category from child as well as master table if no keywords in category
                    $del_exclude_keyword = Excluded_journal_keywords::delete_records('ejk_keyword_category=' . $category_id, '', $this->current_user);
                    Keyword_category::delete_records('kwc_id=' . $category_id, '', $this->current_user);
                    $data = array(
                        'success' => true,
                        'message' => customTrans('keyword.category_delete'),
                    );
                    return $this->success('success', 200, $data);
                } else {
                    return $this->warning('warning', 200, customTrans('keyword.catgry_del_warning'), 'warning');
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function delete_journal_keyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $search = isset($form_data['params']) ? $form_data['params'] : '';
            if (isset($search['key_id']) && $search['key_id'] != '') {
                $key_id =  $this->decrypt_data($search['key_id']);
                $result = Article_keywords::get_single_record('count(ak_id) as cnt', 'ak_keyword_id=' . $key_id); //check keyword used in articles
                if ($result->cnt == 0) {
                    $journal_where = "kwdrl_kwd_id='" . $key_id . "' and kwdrl_jnl_id is not null";
                    $category_where = "kwdrl_kwd_id='" . $key_id . "' and kwdrl_category_id is not null";
                    if ($this->current_client->functionality->cfty_keyword_hierarchy == "c")
                    {
                        $where_check = $journal_where;
                        $where_update = $category_where;
                    }
                    else
                    {
                        $where_check = $category_where;
                        $where_update = $journal_where;
                    }
                    $keyword_records = Keywords::check_keyword_exists($where_check, 'count(*) as cnt');
                    if ($keyword_records->cnt > 0) {
                        Keyword_relationship::delete_records($where_update, '', $this->current_user);
                        $data = array(
                            'success' => true,
                            'message' => customTrans('keyword.delete_keyword'),
                            'del_rcrd_id' => $key_id
                        );
                        return $this->success('success', 200, $data);
                    } else {
                        $keyword = Keywords::delete_records('kwd_id=' . $key_id, '', $this->current_user);
                        Keyword_relationship::delete_records('kwdrl_kwd_id=' . $key_id, '', $this->current_user);
                        $data = array(
                            'success' => true,
                            'message' => customTrans('keyword.delete_keyword'),
                            'del_rcrd_id' => $key_id
                        );
                        return $this->success('success', 200, $data);
                    }
                    return $this->warning('warning', 200, customTrans('keyword.keywd_del_warning'), 'warning');
                } else {
                    return $this->warning('warning', 200, customTrans('keyword.keywd_del_warning'), 'warning');
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function delete_category_keyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $search = isset($form_data['params']) ? $form_data['params'] : '';
            if (isset($search['key_id']) && $search['key_id'] != '') {
                $key_id =  $this->decrypt_data($search['key_id']);
                $result =  Article_keywords::get_single_record('count(ak_id) as cnt', 'ak_keyword_id=' . $key_id);
                if ($result->cnt == 0) {
                    $journal_where = "kwdrl_kwd_id='" . $key_id . "' and kwdrl_jnl_id is not null";
                    $category_where = "kwdrl_kwd_id='" . $key_id . "' and kwdrl_category_id is not null";
                    $keyword_records = Keywords::check_keyword_exists($journal_where, 'count(*) as cnt');
                    if ($keyword_records->cnt > 0) {
                        Keyword_relationship::delete_records($category_where, '', $this->current_user);
                        $data = array(
                            'success' => true,
                            'message' => customTrans('keyword.delete_keyword'),
                            'del_rcrd_id' => $key_id
                        );
                        return $this->success('success', 200, $data);
                    } else {
                        Keywords::delete_records('kwd_id=' . $key_id, '', $this->current_user);
                        Keyword_relationship::delete_records('kwdrl_kwd_id=' . $key_id, '', $this->current_user);
                        $data = array(
                            'success' => true,
                            'message' => customTrans('keyword.delete_keyword'),
                            'del_rcrd_id' => $key_id
                        );
                        return $this->success('success', 200, $data);
                    }
                    return $this->warning('warning', 200, customTrans('keyword.keywd_del_warning'), 'warning');
                } else {
                    return $this->warning('warning', 200, customTrans('keyword.keywd_del_warning'), 'warning');
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_keyword_byid(Request $request)
    {
        try {
            $form_data = $request->all();
            $keywordid = $this->decrypt_data($form_data['keywordid']);
            if ($keywordid != '') {
                $condition = "kwd_id=" . $keywordid;
                $keyword_details['keyword_detail'] = Keywords::get_jnl_keywords('kwd_id, kwd_name,GROUP_CONCAT(distinct jnl_id) as ids', TRUE, $condition);
                return $this->success('success', 200, $keyword_details);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function chooseKeyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $criteria = 'kwd_user_keyword IN (\'n\',\'y\') ';
            $keywordid = isset($form_data['keywordid']) ? $form_data['keywordid'] : '';
            if (!empty($keywordid)) {
                $key_name = htmlspecialchars($keywordid, ENT_QUOTES);
                $criteria .= ' AND LOWER(kwd_name) LIKE LOWER("%' . trim($key_name) . '%")';
            }
            if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y') {
                $criteria .= ' AND kwdrl_inactive =\'n\'';
            }
            $records =  Keywords::get_jnl_keywords('Distinct kwd_name', FALSE, $criteria, 25);
            $data['records'] = $records;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_catkeyword_byid(Request $request)
    {
        try {
            $form_data = $request->all();
            $keywordid = $this->decrypt_data($form_data['keywordid']);
            if ($keywordid != '') {
                $condition = "kwd_id=" . $keywordid;
                $keyword_details['keyword_detail'] = Keywords::get_cat_keywords('kwd_id, kwd_name,GROUP_CONCAT(distinct kwc_id) as ids', TRUE, $condition);
                return $this->success('success', 200, $keyword_details);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function get_category_byid(Request $request)
    {
        try {
            $form_data = $request->all();
            $categoryid = $this->decrypt_data($form_data['categoryid']);
            if ($categoryid != '') {
                $condition = "kwc_id=" . $categoryid;
                $category_details['category_detail'] = Keyword_category::get_single_record('kwc_id, kwc_name', $condition);
                return $this->success('success', 200, $category_details);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function save_controlled_keyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $search = isset($form_data['params']) ? $form_data['params'] : '';
            if (isset($search['key_id']) && $search['key_id'] != '') {
                $key_id =  $this->decrypt_data($search['key_id']);
                $data = array(
                    'kwd_user_keyword' => 'n'
                );
                $result = Keywords::update_record($data, 'kwd_id=' . $key_id, $this->current_user);
                $result_arry = array(
                    'success' => true,
                    'message' => customTrans('keyword.kwd_custom_msg'),
                );
                return $this->success('success', 200, $result_arry);
            } else {
                return $this->warning('warning', 200, customTrans('keyword.kwd_custom_err'), 'warning');
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_journals(Request $request)
    {
        try {
            $journals = Journals::get_all_records('jnl_id,jnl_journal_name');
            $data['journals'] = $journals;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function category_list(Request $request)
    {
        try {
            $category = Keyword_category::get_all_records('kwc_id, kwc_name');
            $data['category'] = $category;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function export_journal_keywords(Request $request) 
        {
       
            try {
                $post_data=$request->all();
                $specified_jnl_details=array();
                $export_type = $post_data['export_type'];
                $export_specific_jnl_id = isset($post_data['specific_jnl_id'])?$post_data['specific_jnl_id']:'';
                $is_consolidate         = ($post_data['is_consolidate']==''|| $post_data['is_consolidate']=='Undefined')?false:$post_data['is_consolidate'];
                $select = 'kwd_id,kwd_name';
                $group_by = 'kwd_id';
                $zipname = '';
                $csv_file = '';
                $jnl_condtion = array();
                $headers = array('KEYWORD ID','KEYWORD NAME');
                if ($export_type == 'all_journals') {
                    $zipname = 'All_journal_keywords.zip';
                } elseif ($export_type == 'all_normal_journals') {
                    $zipname = 'Normal_journal_keywords.zip';
                    $jnl_condtion = array('jnl_standalone' => 'n');
                } elseif ($export_type == 'all_standalone_journals') {
                    $zipname = 'Standalone_journal_keywords.zip';
                    $jnl_condtion = array('jnl_standalone' => 'y');
                } else {
                    $specified_jnl_details = Journals::get_single_record_with_bind_cond('jnl_id,jnl_journal_code', array('jnl_id' => $export_specific_jnl_id));
                    $csv_file =  $this->current_client->clnt_client_code. '-' .$specified_jnl_details->jnl_journal_code . '.csv';
                } 
                if ($export_type != 'specific_journals' && $is_consolidate == false) 
                { 
                $all_jnls = Journals::get_all_records_with_bind_cond('jnl_id,jnl_journal_code', $jnl_condtion);
                if(count($all_jnls)>0)
                {
                $zip = new ZipArchive;
                $zip->open(storage_path() . '/app/public/uploads' . $zipname, ZipArchive::CREATE);
                foreach ($all_jnls as $jnl) 
                {
                    $where = 'kwdrl_jnl_id= ' . $jnl->jnl_id . ' AND kwdrl_inactive = \'n\' ';
                    $all_records = Keywords::get_keywords($where, $select, NULL, NULL, $group_by, $this->current_client->functionality->cfty_keyword_hierarchy, NULL, NULL, NULL, NULL, NULL, FALSE);
                    $tempfile = fopen('php://temp/maxmemory:1048576', 'w');
                    if (false === $tempfile) {
                        die('Failed to create temporary file');
                    }

                    // write the data to csv
                    if(count($all_records)>0){
                        fputcsv($tempfile, $headers);
                        foreach ($all_records as $record) {
                            if (is_object($record)) {
                                $record = get_object_vars($record);
                            }
    
                            if (is_array($record)) {
    //                            $record['kwd_name'] = htmlspecialchars_decode(str_replace('&AMP;', '&amp;', $record['kwd_name']),ENT_QUOTES);
                                $record['kwd_name'] = $this->unicode_correction($record['kwd_name']);
                                fputcsv($tempfile, $record);
                            }
                        }
                        rewind($tempfile);
                        // add the in-memory file to the archive, giving a name
                        $zip->addFromString( $this->current_client->clnt_client_code. '-' .$jnl->jnl_journal_code . '.csv', stream_get_contents($tempfile));
                        //close the file
                        fclose($tempfile);

                    }
                } 
                }
                else
                {
                    $error_msg='There is no journal with an invalid keyword.';
                    return $this->warning('warning', 200, $error_msg, 'warning');
                }               
                // $zip->close();
                $file_path = storage_path() . '/app/public/uploads'. $zipname;
                if( file_exists($file_path))
                {
                    
                    // $this->download_file($file_path, 'zip');
                    unlink($file_path);
                }
                

            }
            else if ($export_type != 'specific_journals' && $is_consolidate == 'true')
            {
                //consolidate csv built
                $where = 'kwdrl_inactive = \'n\' ';
                $jnl_condtion ='jnl_standalone = \'n\'';
                if ($export_type == 'all_standalone_journals')
                $jnl_condtion ='jnl_standalone = \'y\'';
                
                $all_records = Keywords::get_keywords($where, $select, NULL, NULL, $group_by, $this->current_client->functionality->cfty_keyword_hierarchy, NULL, $jnl_condtion, NULL, NULL, NULL, FALSE);
                $zip = new ZipArchive;  
                $zip->open(storage_path() . '/app/public/uploads' . $zipname, ZipArchive::CREATE);
                // $zip->open($this->upload_folder_path("") . $zipname, ZipArchive::CREATE);
                $tempfile = fopen('php://temp/maxmemory:1048576', 'w');
                if (false === $tempfile) {
                    die('Failed to create temporary file');
                }
                // write the data to csv
                fputcsv($tempfile, $headers);
                foreach ($all_records as $record) {
                    if (is_object($record)) {
                        $record = get_object_vars($record);
                    }

                    if (is_array($record)) {
//                        $record['kwd_name'] = htmlspecialchars_decode(str_replace('&AMP;', '&amp;', $record['kwd_name']),ENT_QUOTES);
                        $record['kwd_name'] = $this->unicode_correction($record['kwd_name']);
                        fputcsv($tempfile, $record);
                    }
                }
                // return to the start of the stream
                rewind($tempfile);
                $zip->addFromString( $this->current_client->clnt_client_code. '-' .$export_type . '-keywords.csv', stream_get_contents($tempfile));
                // fclose($tempfile);
                $file_path = storage_path() . '/app/public/uploads'. $zipname;
                // $file_path = $this->upload_folder_path(""). $zipname;
                if( file_exists($file_path))
                {
                    unlink($file_path);
                }
            }
            else 
            {
                
                $where = 'kwdrl_jnl_id= ' . $specified_jnl_details->jnl_id . ' AND kwdrl_inactive = \'n\' ';
                $keywords_list = Keywords::get_keywords($where, $select, NULL, NULL, $group_by, $this->current_client->functionality->cfty_keyword_hierarchy, NULL, NULL, NULL, NULL, NULL, FALSE);
                header("Content-type: application/octet-stream");
                header("Content-Disposition: attachment; filename=$csv_file");
                header("Pragma: no-cache");
                header("Expires: 0");
                $file_path = storage_path() . '/app/public/uploads/export_journal_keyword/';
                File::deleteDirectory($file_path);
                if (!file_exists($file_path)) {
                    File::makeDirectory($file_path, 0777, TRUE, TRUE);
                }
                $file = fopen($file_path . $csv_file, 'w');
                fputcsv($file, $headers);
               
                foreach ($keywords_list as $kwds) {
                    if (is_object($kwds)) {
                        $kwds = get_object_vars($kwds);
                    }
                   
                    if (is_array($kwds)) {
//                        $kwds['kwd_name'] = htmlspecialchars_decode(str_replace('&AMP;', '&amp;', $kwds['kwd_name']),ENT_QUOTES);
                        $kwds['kwd_name'] = $this->unicode_correction($kwds['kwd_name']);
                        fputcsv($file, $kwds);
                       
                    }
                    $file_path =storage_path() . '/app/public/uploads/export_journal_keyword/'. $csv_file;
                    
                }
                fclose($file);
            } 
            $filename=basename($file_path);
            $data = array(
                'success' => true,
                'message' => customTrans('keyword.kwd_suceess'),
                'file_path' => encrypt_link($file_path),
                'filename' => $filename
            );
            return $this->success('success', 200, $data);
               
            } catch (\Exception $e) {
                return $this->failure('Failed', 500, $e);
            } 
        }
        public function unicode_correction($str)
        {
            //unicode and ther correction
            $unicode_correction_set = array(
                '&AMP;' => '&amp;',
                'Â¡ÅŽ'  => '',
                'Â'  => '',
                'Â€™'   => '\''
            );
            $unicode        = array_keys($unicode_correction_set);
            $correct_code   = array_values($unicode_correction_set);
            $corrected_str = htmlspecialchars_decode(str_replace($unicode, $correct_code, $str),ENT_QUOTES);
            return $corrected_str;
        }
        public function import_keyword(Request $request)
	    {
        try
        {
		$path = APP_DOC_PATH . 'keywords';
		$options['upload_dir'] = $path . DIRECTORY_SEPARATOR;
		$options['upload_url'] = storage_path() . $path . DIRECTORY_SEPARATOR;
		$options['script_url'] = storage_path() . 'uploads';
		$options['print_response'] = false;
        $form_data=$request->all();
        if (isset($form_data['file']) && !empty($form_data['file'])) {
            $validator = Validator::make($request->all(), [
                'file'      => 'required|file',
            ]);
            if ($validator->fails()) {

                return  $this->failure('Failed', 422, $validator->errors());
            }
            else{
                $uploadedFile = $request->file('file'); // Assuming you have the uploaded file in a request
                $file_name = $uploadedFile->getClientOriginalName();
                $file = $request->file('file'); // Assuming you are uploading the file via a form
                $storedPath = $file->storeAs('public/'.$path, $file_name);
                $url =storage_path(). '/' . $storedPath;
                $fileupload_detail = array(
                    'upload_file_name' => $file_name,
                    'upload_file_url' => $url,
                    'journal'=>encrypt_link($form_data['journal']));
                $basePath = storage_path();
                $dir_name = $basePath .'/app/'. $storedPath;
                $file = fopen($dir_name, 'r');
                $separator = ';';
			    $max_row_size = 4096;
                $fields = fgetcsv($file, $max_row_size, $separator);
			    $first_value = htmlspecialchars($fields[0], ENT_QUOTES);
                
                $journal_id = $form_data['journal'];
			    $journal_code = '';
			    $pat_array = '';
			    preg_match_all("/{{(.*)}}/U", $first_value, $pat_array);
                if (!empty($pat_array[0]))
			    {
				$first_value = $pat_array[1][0];
				$journal_details = Journals::get_single_record_with_bind_cond('jnl_journal_code', array(
					"jnl_id" => $journal_id));
				if (!empty($journal_details))
					$journal_code = $journal_details->jnl_journal_code;
				if ($journal_code == $first_value)
				{
					$return_array['fileupload_detail'] = $fileupload_detail;
					$return_array['status'] = 'success';
					$return_array['msg'] = customTrans('keyword.kwd_update');
				}
				else
				{
					unlink($dir_name);
					$return_array['status'] = 'failed';
					$return_array['msg'] = customTrans('keyword.import_jln_nt_mtch');
				}
			    }
                else
                {
                    Storage::delete($dir_name);
                    $return_array['status'] = 'failed';
                    $return_array['msg'] = customTrans('keyword.failed_upload_csv');
                }
                return $this->success('success', 200, $return_array);
            }

        }
    }
    catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
	}

    public function import_save_journal(Request $request)
	{
        try{
            $this->current_user = $this->get_current_user_details();
            $form_data =$request->all();
            $journal_id = decrypt_link($form_data['journal']);
		    $file_name = $form_data['upload_file_name'];
            $path = APP_DOC_PATH . 'keywords';
            $url = $form_data['upload_file_url'];
            $fpath = pathinfo($url);
            $extension = $fpath['extension'];
            $dir_name  = storage_path() .'/app/public/' . $path;    //commit for ajo 
            $return_array = array();
		    $journal_details = Journals::get_single_record_with_bind_cond('jnl_journal_code', array(
			"jnl_id" => $journal_id));
		    $journal_code = $journal_details->jnl_journal_code;
		    $new_file_name = $journal_code . "_" . time() . "." . $extension;
		    $result = $this->parse_file($dir_name.DIRECTORY_SEPARATOR.$file_name, $journal_id);
            if(isset($result['update_keyword']) && count($result['update_keyword'])>0)
            {
                $keyword_count=count($result['update_keyword']);
                $return_array['update_keyword']=json_encode($result['update_keyword'],true);
                $return_array['keyword_names']=json_encode($result['keyword_names'],true);
                $return_array['count']=$keyword_count;
                $return_array['status'] = 'success';
                $return_array['msg']="The imported keyword already exists in the custom keywords. It will be updated to a controlled keyword. Do you want to continue?";
                $this->Update_controlled_keyword($return_array);
            }
            if ($result['status'] == "success")
            {
                $return_array['status'] = 'success';
            }
            else
            {
                $return_array['status'] = 'failed';
                $return_array['msg'] = customTrans('keyword.error_import');
            }
            return $this->success('success', 200, $return_array);
        }
        catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
	}
    public function parse_file($p_Filepath, $journal_id)
	{
        $this->current_user = $this->get_current_user_details();
		$fields;
		$separator = ';';
		$max_row_size = 4096;
		$keyword_array = array();
        $result=array();
        $update_keyword =array();
        $kwd_user_keyword='n';
        $dir_name = $p_Filepath;
		$file = fopen($dir_name, 'r');
		$i = 0;
		$current_date = date('Y-m-d H:i:s');
		$kwd_ids = array();
		$journal_record = Keyword_relationship::get_all_records_with_bind_cond('*', array(
			"kwdrl_jnl_id" => $journal_id));
            
		// Initialize arrays to store keyword and keyword relation data
        $keyword_array = [];
        $update_keyword= [];
        $keyword_names=[];
        $keyword_relation_array = [];
        $kwd_ids = [];
        while (($row = fgetcsv($file, $max_row_size, $separator)) !== false) {
            if ($i == 0) {
                $i++;
                continue; // Skip the first row
            }
            $new_values = trim($row[0]);

            if (!empty($new_values)) { // Skip empty lines
                // Convert to uppercase and clear HTML tags
                $data_value = strtoupper(htmlspecialchars($new_values, ENT_QUOTES));

                // Create an array for keyword insertion
                $keyword_data = [
                    $data_value,
                    $current_date,
                    $kwd_user_keyword,
                    $this->current_user['user_id'],
                    0,
                    "b",
                ];    
                $keyword_array[$i] = "'" . implode("','", $keyword_data) . "'";
                // Create an array for keyword relation insertion
                if ($this->current_client->functionality->cfty_keyword_inactive == 'y') {
                    $key_condition = 'kwdrl_jnl_id = ' . $journal_id;

                    // Get keywords with the given condition
                    $keyword_records = Keywords::get_keywords($key_condition, 'kwd_id', null, null, null, $this->current_client->functionality->cfty_keyword_hierarchy);

                    if (!empty($keyword_records) && count($keyword_records) > 0) {
                        $kwd_ids[] = $keyword_records[0]->kwd_id;
                    }
                }

                $keyword_relation_data = [
                    $journal_id,
                    $data_value,
                    $current_date,
                    $this->current_user['user_id'],
                    0,
                    "b",
                ];
                $keyword_duplicate_check = Keywords::get_single_record_with_bind_cond('count(kwd_name) as cnt, kwd_name',array(
                    'kwd_name' => $data_value,
                    'kwd_user_keyword' =>'y'
                ));
                if($keyword_duplicate_check->cnt >0){
        
                    $update_keyword [$i] = "UPDATE rvw_keywords set `kwd_user_keyword`='n' where `kwd_name`='".$keyword_duplicate_check->kwd_name."'";
                    $keyword_names[]=$keyword_duplicate_check->kwd_name;
                
                }
                $keyword_relation_array[$i] = "'" . implode("','", $keyword_relation_data) . "'";
                $i++;
            }
        } 
		if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
		{ 
			$exclude_arr = array();
			$include_arr = array();
           
			if (!empty($journal_record) && count($journal_record)>0)
			{
				foreach ($journal_record as $jr)
				{
					$key_id = $jr->kwdrl_kwd_id;
					if (!in_array($key_id, $kwd_ids))
					{
						$exclude_arr[] = $jr->kwdrl_id;
					}
					else
					{
						$include_arr[] = $jr->kwdrl_id;
					}
				}
			}
			if (!empty($exclude_arr) && count($exclude_arr))
			{  
               
				// implode this array and convert to comma seperated and update that recorde with inactive='y
				$elemnt_ids = implode(',', $exclude_arr);
				$tmp_update_sql = "update rvw_keyword_relationship set 	kwdrl_inactive='y' where kwdrl_id in($elemnt_ids)";
				Keyword_relationship::execute_query($tmp_update_sql);
			}
			if (!empty($include_arr))
			{
				$in_elemnt_ids = implode(',', $include_arr); 
				$tmp_update_sql = "update rvw_keyword_relationship set 	kwdrl_inactive='n' where kwdrl_id in($in_elemnt_ids)";
				Keyword_relationship::execute_query($tmp_update_sql); 
			}
		}
		// query for inserting keywords to table
		$keyword_field_array = array(
			"kwd_name",
			"kwd_posted_date",
            "kwd_user_keyword",
			"kwd_posted_by",
			"kwd_proxy_id",
			"kwd_operation");
		$keyword_field_name = implode(",", $keyword_field_array);
        DB::beginTransaction();
		$keyword_sql = "insert ignore into rvw_keywords ($keyword_field_name) values ";
		for ($i = 1; $i <= count($keyword_array); $i++)
		{
			if ($i > 1)
				$keyword_sql .= ",";
			$keyword_sql .= "(" . $keyword_array[$i] . ")";
		}  
		Keywords::execute_query($keyword_sql);
		// query for inserting keywords relationship to table
		$keyword_relation_field_array = array(
			"kwdrl_jnl_id",
			"kwdrl_kwd_name_csv",
			"kwdrl_posted_date",
			"kwdrl_posted_by",
			"kwdrl_proxy_id",
			"kwdrl_operation");
		$keyword_relation_field_name = implode(",", $keyword_relation_field_array);
		$keyword_relation_sql = "insert ignore into rvw_keyword_relationship ($keyword_relation_field_name) values ";
		for ($i = 1; $i <= count($keyword_relation_array); $i++)
		{
			if ($i > 1)
				$keyword_relation_sql .= ",";
			$keyword_relation_sql .= "(" . $keyword_relation_array[$i] . ")";
		}
	    Keyword_relationship::execute_query($keyword_relation_sql);
		//updating  keyword id to keyword relationship
		$upper_keyword_relation = "UPDATE rvw_keyword_relationship set `kwdrl_kwd_id`=(select kwd_id from rvw_keywords where kwd_name=kwdrl_kwd_name_csv) where kwdrl_kwd_id is null";
		Keywords::execute_query($upper_keyword_relation);
		$tmp_clr_sql = "update rvw_keyword_relationship set kwdrl_kwd_name_csv=null where kwdrl_kwd_name_csv IS NOT NULL";
		Keyword_relationship::execute_query($tmp_clr_sql);
		if (DB::commit() === FALSE)
        {
			$status = "failed";
            DB::rollBack();
        }
		else
        {
            $status = "success";
        }
        $result['keyword_names']=$keyword_names;
        $result['status']=$status;
        $result['update_keyword']=$update_keyword;
		return $result;
        
	}
    public function Update_controlled_keyword($return_array)
    {
        try {
            $form_data = $return_array;
            $updateKeywords = json_decode($form_data['update_keyword']);
            $keywordNames = json_decode($form_data['keyword_names']);
    
            if (empty($keywordNames) || !is_array($keywordNames) || empty($updateKeywords)) {

                return response()->json(['status' => 'success', 'message' => 'No keywords to update.'], 200); // Or a 204 No Content
            }
    
            DB::beginTransaction();
            try {
                $chunks = array_chunk($keywordNames, 1000);
    
                foreach ($chunks as $keywordChunk) {
                    $cases = [];
                    $ids = [];
    
                    foreach ($keywordChunk as $keywordName) {
                        $escapedKeywordName = addslashes($keywordName); // Escape for SQL injection protection
                        $cases[] = "WHEN '" . $escapedKeywordName . "' THEN 'n'";
                        $ids[] = "'" . $escapedKeywordName . "'";
                    }
    
                    $idsString = implode(',', $ids); // Correctly implode the $ids array
                    $sql = "UPDATE rvw_keywords SET kwd_user_keyword = CASE kwd_name " . implode(' ', $cases) . " END WHERE kwd_name IN ($idsString)";
                    Keywords::execute_query($sql);
                }
    
                DB::commit();
                return response()->json(['status' => 'success', 'message' => 'Keywords updated successfully.'], 200);
            } catch (\Exception $e) {
                DB::rollBack();
                Log::error("Database update error: " . $e->getMessage());
                return response()->json(['status' => 'error', 'message' => 'Database update failed. '.$e->getMessage()], 500); // Include error message for debugging
            }
        } catch (\Exception $e) {
            Log::error("Request error: " . $e->getMessage()); // Log the exception
            return response()->json(['status' => 'error', 'message' => 'Invalid request data. '.$e->getMessage()], 400); // Return 400 Bad Request
        }
    }
    
    
}
