<?php

namespace App\Http\Controllers;

use App\Models\Article_deletion_reasons;
use App\Models\Ftp_master;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;


class Manage_Master_Ftp_Api extends Controller
{
    public function index(Request $request)
    {
        try {
            $post_data = $request->all();
            $sort_field = (isset($post_data['sort_field'])) ? $post_data['sort_field'] : 'ftpm_id';
            $sort_order =  (isset($post_data['sort_order'])) ? $post_data['sort_order'] : 'asc';
            $limit = (isset($post_data['per_page'])) ? $post_data['per_page'] : 10;
            $select = 'ftpm_id,ftpm_display_name,ftpm_host_name,ftpm_user_name,ftpm_password,ftpm_enable_private_key,ftpm_private_key_path,ftpm_port,ftpm_location';
            $rtn_data = Ftp_master::get_paginated_records($select, NULL, $sort_field, $sort_order, $limit);
            foreach ($rtn_data as $ftp) {
                $ftp->uploadedPPKfileName = '';
                if (!empty($ftp->ftpm_private_key_path)) {
                    $url = $ftp->ftpm_private_key_path;
                    $ftp->uploadedPPKfileName = basename($url);
                }
                $ftp->privateKey = ($ftp->ftpm_enable_private_key == 'y') ? 'Yes' : 'No';
                $ftp->ftpm_location = ($ftp->ftpm_location == null) ? '' : $ftp->ftpm_location;
                $ftp->ftpm_private_key_path = ($ftp->ftpm_private_key_path == null) ? '' : $ftp->ftpm_private_key_path;
                $ftp->passwordvisibility =false;
            }
            return $this->success('success', 201, $rtn_data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function add_master_ftp_reason(Request $request)
    {
        try {
            $post_data = $request->all();
            $validationArr = array(
                'displayName'  => 'required',
                'hostName'     => 'required',
                'userName'     => 'required'
            );
            if (isset($post_data['privateKey']) && $post_data['privateKey'] == 'y') {
                $validationArr['uploadedPrivateKeyPath'] = 'required';
            } else {
                $validationArr['password'] = 'required';
            }
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $update_status = false;
            $rtn_arr = array();
            $ftpm_id = '';
            $input_arr = array(
                'input' => $post_data['displayName'],
                'type'  => 'string'
            );
            $display_name_validate = $this->Rv_validator($input_arr);
            $input_arr['input'] = $post_data['hostName'];
            $host_name_validate = $this->Rv_validator($input_arr);
            $input_arr['input'] = $post_data['userName'];
            $user_name_validate = $this->Rv_validator($input_arr);
            if ($display_name_validate == TRUE && $host_name_validate == TRUE && $user_name_validate == TRUE) {
                $post_data['port'] == '' ? $post_data['port'] = NULL : $post_data['port'];
                $post_data['location'] == '' ? $post_data['location'] = NULL : $post_data['location'];
            }
            $current_user = $this->get_current_user_details();
            $sting_cond = "ftpm_display_name = ? AND ftpm_host_name = ? AND ftpm_user_name = ? AND ftpm_port = ? AND ftpm_enable_private_key = ?";
            $bind_data = array(
                $post_data['displayName'],
                $post_data['hostName'],
                $post_data['userName'],
                $post_data['port'],
                $post_data['privateKey'],
            );
            $ftp_master_data = array(
                'ftpm_display_name' => $post_data['displayName'],
                'ftpm_host_name'    => $post_data['hostName'],
                'ftpm_user_name'    => $post_data['userName'],
                'ftpm_port'         => $post_data['port'],
                'ftpm_enable_private_key' => $post_data['privateKey'],
            );
            if (isset($post_data['location']) && !empty($post_data['location'])) {
                $sting_cond .= " AND ftpm_location = ?";
                $bind_data[] = $post_data['location'];
                $ftp_master_data['ftpm_location'] = $post_data['location'];
            }else{
                $sting_cond .= " AND ftpm_location = ?";
                $bind_data[] = '';
                $ftp_master_data['ftpm_location'] = '';
            }
            if (isset($post_data['uploadedPrivateKeyPath']) && !empty($post_data['uploadedPrivateKeyPath']) && $post_data['privateKey'] == 'y' && $post_data['uploadedPrivateKeyPath'] != null && $post_data['uploadedPrivateKeyPath'] != 'null') {
                $sting_cond .= " AND ftpm_private_key_path = ?";
                $bind_data[]   = $post_data['uploadedPrivateKeyPath'];
                $ftp_master_data['ftpm_private_key_path'] = $post_data['uploadedPrivateKeyPath'];
                if (!empty($post_data['password'])) {
                    $sting_cond .= " AND ftpm_password = ?";
                    $bind_data[]   = $post_data['password'];
                    $ftp_master_data['ftpm_password'] = $post_data['password'];
                }
            } else {
                $sting_cond .= " AND ftpm_password = ?";
                $bind_data[]   = $post_data['password'];
                $ftp_master_data['ftpm_password'] = $post_data['password'];
                if (!empty($post_data['uploadedPrivateKeyPath']) && ($post_data['uploadedPrivateKeyPath'] != null || $post_data['uploadedPrivateKeyPath'] != 'null')) {
                    $sting_cond .= " AND ftpm_private_key_path = ?";
                    $bind_data[]   = $post_data['uploadedPrivateKeyPath'];
                    $ftp_master_data['ftpm_private_key_path'] = $post_data['uploadedPrivateKeyPath'];
                }
            }
            if (isset($post_data['edit_id']) && !empty($post_data['edit_id'])) {
                $update_status = true;
                $sting_cond .= " AND ftpm_id <> ?";
                $bind_data[] = decrypt_link($post_data['edit_id']);
            }
            // check the host details already exists or not
            $ftpMasterExist = Ftp_master::get_single_record_with_bind_cond('ftpm_id', array(), $sting_cond, $bind_data);
            if (isset($ftpMasterExist->ftpm_id) && !empty($ftpMasterExist->ftpm_id)) {
                $rtn_arr = array(
                    'msg' => 'Ftp details already exists!',
                    'status' => 'warning'
                );
                return $this->success('warning', 200, $rtn_arr);
            } else {
                //check the uniqueness of the  display name
                $display_name_criteria = "ftpm_display_name = ?";
                $display_name_data = array(
                    $post_data['displayName']
                );
                if ($update_status == true) {
                    $display_name_criteria .= " AND ftpm_id <> ?";
                    $display_name_data[] = decrypt_link($post_data['edit_id']);
                }
                $displayNameExist = Ftp_master::get_single_record_with_bind_cond('ftpm_id', array(), $display_name_criteria, $display_name_data);
                if(isset($displayNameExist->ftpm_id) && !empty($displayNameExist->ftpm_id)){
                    $rtn_arr = array(
                        'msg' => 'Display name already exists!',
                        'status' => 'warning'
                    );
                    return $this->success('warning', 200, $rtn_arr);
                }
                if ($update_status == true) {
                    $ftpm_condition = "ftpm_id=" . decrypt_link($post_data['edit_id']);
                    Ftp_master::update_record($ftp_master_data, $ftpm_condition);
                    $msg =  customTrans('platform_settings.ftp_updated');
                }else{
                    $msg = customTrans('platform_settings.ftp_added');
                    Ftp_master::insert_record($ftp_master_data, $current_user);
                }
                $rtn_arr = array(
                    'msg' => $msg,
                    'status' => 'success'
                );
                return $this->success('success', 200, $rtn_arr);
            };
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function remove_master_ftp(Request $request){
        try{
            $current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'ftpm_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $ftpm_id = $this->decrypt_data($post_data['ftpm_id']);
            $criteria = 'ftpm_id="' . $ftpm_id . '"';
            $result = Ftp_master::delete_records($criteria, '', $current_user);
            $message = customTrans('platform_settings.ftp_deleted');
            return $this->success($message, 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
}
