<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use App\Models\General_permission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\JournalUserfunctionTrait;
class Manage_Menu_Permissions_Api extends Controller
{
  use JournalUserfunctionTrait;
  /*List all general menu permissions
 commited date :- 29-11-2022
 Requested type :- POST
*/
  public function index(Request $request)
  {
    try {
      $form_data = $request->all();
      // DB::enableQueryLog();
      $permission = [];

      $criteria = "permission_caption !='' AND permission_parent_route != ''";
      $order_by = 'permission_caption';
      $result = General_permission::get_all_records('*', $criteria, $order_by, NULL, '', NULL, NULL, 'ASC');
      $casrai_module = $this->current_client->modules;
      if (!empty($result)) {
        foreach ($result as $key => $menu_permission) {
          if ($menu_permission->permission_route == 'casrai-credits' && $casrai_module->mdl_casrai_credit == 'n') {
            unset($result[$key]);
          } else if ($menu_permission->permission_route == 'cron-task' && $this->current_client->functionality->cfty_biorxiv == 'n') {
            unset($result[$key]);
          } else if ($menu_permission->permission_route == 'manage-rescind-request' && $this->current_client->functionality->cfty_enable_rescind_request == 'n') {
            unset($result[$key]);
          }
          /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review */
          else if ($menu_permission->permission_route == 'workflow-assignment' && $this->current_client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers == 'n') {
            unset($result[$key]);
          }
           else {
            array_push($permission, $menu_permission);
          }
        }
      };
      $data['permission_data'] = $permission;
      $data['count'] = count($permission);
      $data['roles'] = $this->UserConfigdata('managing_roles');
      return $this->success('success', 200, $data);
    } catch (\Exception $e) {
      return  $this->failure('Failed', 500, $e);
    }
  }
  /*Get selected general menu permissions
 commited date :- 29-11-2022
 Requested type :- POST
*/
  public function get_menupermission(Request $request)
  {
    try {
      $form_data = $request->all();
      $validator = Validator::make($request->all(), [
        'menu_id' => 'required',
      ]);
      if ($validator->fails()) {
        return $this->failure('Failed', 422, $validator->errors());
      }
      $menu_permission_id = $this->decrypt_data($form_data['menu_id']);
      $criteria = 'id = "' . $menu_permission_id . '"';
      $result = General_permission::get_single_record('*', $criteria);
      $data['result'] = $result;
      $data['roles'] = $this->UserConfigdata('managing_roles');
      return $this->success('success', 200, $data);
    } catch (\Exception $e) {
      return  $this->failure('Failed', 500, $e);
    }
  }
  /*Update selected general menu permissions
 commited date :- 29-11-2022
 Requested type :- POST
*/
  public function update_menupermission(Request $request)
  {
    try {
      $current_user = $this->get_current_user_details();
      $form_data = $request->all();
      $admin_roles=array();
      if(isset($form_data['user_roles'])&&($form_data['user_roles']!=''))
      $admin_roles=explode(',',$form_data['user_roles']);
      $permission_roles = array(
        'permission_roles' => json_encode($admin_roles)
      );
      $menu_permission_id = $this->decrypt_data($form_data['edit_id']);
      $criteria = 'id = "' . $menu_permission_id . '"';
      $updatedata = General_permission::update_record($permission_roles, $criteria, $current_user);
      $message = customTrans('menupermission.permission_updated');
      return $this->success($message, 200, $updatedata);
    } catch (\Exception $e) {
      return  $this->failure('Failed', 500, $e);
    }
  }
  public function get_menu_list(Request $request)
  {
    try
    {
      $post_data=$request->all();
    $user_id=Rv_decrypt($post_data['user_id']);
    $user_id_array = array('input'=>$user_id,'type'=>'number');
    $user_id_validate= $this->Rv_validator($user_id_array);
    if($user_id_validate != TRUE){
      return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));	
  }
      $adm_setting_menu = array();
      $logged_user = $this->get_current_user_details();
    
    $link_route_permissions = General_permission::get_all_records('permission_icon,permission_route, permission_caption, permission_roles',"permission_caption!='' AND permission_roles !=''" );
    if (!empty($logged_user)) {
      $functionality=$this->current_client->functionality;
        if(isset($logged_user['proxy_user_id']) && $logged_user['proxy_user_id'] != 0) {
          $userId = $logged_user['proxy_user_id'];
        } else {
          $userId = $logged_user['user_id'];
        }
        $rightmenu_items = $this->get_right_menu_data($user_id, $userId, $functionality);
     return $this->success('success', 200, $rightmenu_items);  
    }

  }
  catch (\Exception $e) {
    
    return  $this->failure('Failed', 500, $e);
  }
  }
}
