<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use Stripe\PaymentMethod;
use Stripe\Customer;
use App\Models\Article_flow;
use App\Models\Generic_flows;
use App\Models\Currency_master;
use App\Models\Payment_order;
use App\Models\Authors;
use App\Models\Authorize;
use App\Models\Articles;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Config;

class Manage_Payment extends Controller
{
    public function get_payment_details(Request $request) 
    {
        $validator = Validator::make($request->all(), [
            // 'aflw_id' => 'required',
            'article_id' => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        try {
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {
                $article_id     =   $this->decrypt_data($request->article_id);
                // $aflw_id        =   $request->aflw_id ? $this->decrypt_data($request->aflw_id):NULL;
                $previous_ids = Articles::get_single_record('art_pre_all_ids', 'art_id = ?',binding_arr:[$article_id]);
                if (!empty($previous_ids->art_pre_all_ids)) {
                    $article_id = strtok($previous_ids->art_pre_all_ids, ',');
                }
                $Payment_order_details  =   $this->payment_order_details($article_id,null);
                $user_data  =   $this->get_current_user_details();
                $author =   Articles::get_single_record('art_code,art_title,art_submitted_by','art_id = ?',binding_arr:[$article_id]);
                $art_status =   Article_flow::get_single_record('aflw_id,aflw_status','aflw_art_id  = ?',binding_arr:[$article_id]);
                $return = []; 
                if (count($Payment_order_details['payment_detaills']) > 0) {
                    $return =   $Payment_order_details;
                } else {
                    $return  =  $this->get_amount_details($article_id,null);
                }
                $return['author'] = ($user_data['user_id'] == $author->art_submitted_by);
                $return['payment_bypass'] = [];

                //TASK #8180 Payment page for development env
                if(isset($this->current_client->functionality->cfty_enable_abstract_submission_payment_bypass) && $this->current_client->functionality->cfty_enable_abstract_submission_payment_bypass == 'y'){
                    $authors    =   (new Authors())->getTable();
                    $users      =   (new Authorize())->getTable();
                    $tbls   =   [
                        'main_table'    =>  $authors,
                        'join_table'    =>  [
                            $users => ['auth_usr_id','usr_id']
                        ]
                    ];
                    $cnd    =   "rvw_article_authors.auth_art_id = ? and rvw_article_authors.auth_corr_author = 'y'";
                    $authorDetail   =   Authors::get_results_using_joins($tbls,"usr_email,CONCAT(usr_first_name,' ',usr_last_name) as name",$cnd,'single',binding_arr:[$article_id]);
                    $return['payment_bypass'] = array(
                        'art_id' => $article_id,
                        'art_code' => $author->art_code,
                        'art_aflw_id' => $art_status->aflw_id,
                        'art_title' => strip_tags($author->art_title),
                        'name' => $authorDetail->name,
                        'email' => $authorDetail->usr_email,
                        'amount' => isset($return['payment_detaills']) && isset($return['payment_detaills'][0])?$return['payment_detaills'][0]->formatted_fee:"",
                        'fees' => isset($return['payment_detaills']) && isset($return['payment_detaills'][0])?$return['payment_detaills'][0]->jwf_payment_fees:"",
                        'currency' => isset($return['payment_detaills']) && isset($return['payment_detaills'][0])?$return['payment_detaills'][0]->curr_symbol:'$',
                        'dop' => date("Y-m-d", strtotime(now())),
                    );
                    $paymentRes = $this->test_payment_save($return);
                    if($paymentRes){
                        $return['payment_bypass']['payment_status'] = 'Payment completed';
                        //$return['payment_bypass']['txn_id'] = $paymentRes;
                        $return['payment_status'] = true;
                    }
                }
                //TASK #8180 Ends
                $return['art_status'] = $art_status;
                return $this->success("Success",200,$return);
            }  
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function payment_intent(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'amount' => 'required',
            'currency' => 'required',
            'article_id'   => 'required',
            'aflw_id'   =>  'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        try {
            $authors    =   (new Authors())->getTable();
            $users      =   (new Authorize())->getTable();
            $abstract_id    =   $this->decrypt_data($request->article_id);
            $aflw_id    =   $this->decrypt_data($request->aflw_id);
            $tbls   =   [
                'main_table'    =>  $authors,
                'join_table'    =>  [
                    $users => ['auth_usr_id','usr_id']
                ]
            ];
            $cnd    =   "rvw_article_authors.auth_art_id = ? and rvw_article_authors.auth_corr_author = 'y'";
            $author_email   =   Authors::get_results_using_joins($tbls,"usr_email,CONCAT(usr_first_name,' ',usr_last_name) as name",$cnd,'single',binding_arr:[$abstract_id]);
            $payment_noes   =   Article_flow::get_generic_flow('jwf_payment_notes','aflw_id = '.$aflw_id,get_single_result:TRUE);
            $description    =   isset($payment_noes->jwf_payment_notes) && $payment_noes->jwf_payment_notes != '' ? $payment_noes->jwf_payment_notes : "Payment for the abstract submission";
            Stripe::setApiKey(config('app.stripe_secret_key'));

            $customer   =  Customer::create([
                'email' => $author_email->usr_email, // Customer's email address
                'name' => $author_email->name, // Customer's name (optional)
                // Add any additional customer information here
            ]);
        
            $paymentIntent = PaymentIntent::create([
                'amount' => round($request->amount * 100),//convert the amount into cents
                'currency' => $request->currency,
                'description'=> $description,
                // 'receipt_email'=> $author_email
                'customer' =>   $customer->id
            ]);
            return $this->success("Success",200,$paymentIntent);
        } catch (\Exception $e) {
            return response()->json(['error' => $e], 500);
        }
    }

    public function payment_intent_save(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'paymentIntent_id' => 'required',
                'paymentIntent_status' => 'required',
                'payment_method'    =>  'required',
                'amount' => 'required',
                'currency' => 'required',
                'aflw_id'   =>  'required'
            ]);
            if ($validator->fails()) {
               return $this->failure("Failed",422,$validator->errors()); 
            }
            $paymentIntent  =   $request->paymentIntent;
            $article_id     =   $this->decrypt_data($request->article_id);
            $previous_ids = Articles::get_single_record('art_pre_all_ids', 'art_id = ?',binding_arr:[$article_id]);
            if (!empty($previous_ids->art_pre_all_ids)) {
                $article_id = strtok($previous_ids->art_pre_all_ids, ',');
            }
            $aflw_id        =   $this->decrypt_data($request->aflw_id);
            Stripe::setApiKey(config('app.stripe_secret_key'));
            $card = PaymentMethod::retrieve($request->payment_method);
            $last4  =  ($card->type === 'card') ?  $card->card->last4 : '';
            $insert_data    =   [
                'pmt_ord_art_id' => $article_id ,
                'pmt_ord_aflw_id' => $aflw_id,
                'pmt_ord_transaction_id' => $request->paymentIntent_id,
                'pmt_transaction_status' => ($request->paymentIntent_status == 'succeeded') ? 'fn':'cl',
                'pmt_ord_price' =>  number_format($request->amount / 100, 2), // Convert cents to dollars and format
                'pmt_ord_currency' =>  $request->currency,
                'pmt_ord_payment_method' =>  'PaymentIntent',
                'pmt_ord_card_no'   =>  $last4,
                'pmt_ord_order_date' => date('Y-m-d H:i:s'),
                'pmt_ord_posted_date' => date('Y-m-d H:i:s')
            ];
            $user_data  =   $this->get_current_user_details();
            Payment_order::insert_record($insert_data,$user_data);
            // $Payment_order_details  =   $this->payment_order_details($article_id,$aflw_id);
            return $this->success("Success",201,['msg'=>'Payment Details Created']);
        } catch (\Exception $e) {
            return response()->json(['error' => $e], 500);
        }  
    }

    public function payment_order_details($article_id,$aflw_id=NULL)
    {
        $return_arr =   [];
        $art_flw_tbl    =   (new Article_flow())->getTable().' as af';
        $jnl_flw_tbl    =   (new Generic_flows())->getTable().' as jw';
        $curr_tbl       =   (new Currency_master())->getTable().' as cm';
        $pmnt_tbl       =   (new Payment_order())->getTable().' as po';
        $cnd    =   "po.pmt_ord_art_id = ?  and po.pmt_transaction_status = 'fn' and jw.jwf_stage_type IN ('author_submission','revision') and jwf_enable_payment = 'y'";
        $binding_arr    =   [$article_id];
        if ($aflw_id != NULL) {
            $cnd .= 'and po.pmt_ord_aflw_id = ?';
            $binding_arr[]  =   $aflw_id;
        }
        $slct   =   "cm.curr_symbol,cm.curr_code,jw.jwf_payment_fees,po.pmt_ord_transaction_id,jw.jwf_stage_type,po.pmt_ord_card_no,po.pmt_ord_id,po.pmt_ord_price,af.aflw_status";
        $tables =   [
            "main_table"    =>  $pmnt_tbl,
            "join_table"    =>  [
                $art_flw_tbl    =>  ['af.aflw_id','po.pmt_ord_aflw_id'],
                $jnl_flw_tbl    =>  ['jw.jwf_id','af.aflw_jwf_id'],
                $curr_tbl       =>  ['cm.curr_id','jw.jwf_curr_id']
            ]
        ];
        $Payment_order_details  =   Payment_order::get_results_using_joins($tables,$slct,$cnd,'all','pmt_ord_id ASC',1,binding_arr:$binding_arr);
        $return_arr['payment_status']   =   false;
        $return_arr['payment_detaills'] =   [];
        if (count($Payment_order_details)>0) {
            $return_arr['payment_status']   =   true;
            $this->formated_fees($Payment_order_details);
            $return_arr['payment_detaills'] =   $Payment_order_details;
        }
        return $return_arr;
    }

    public function get_viewarticle_payment_details(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'aflw_id' => 'required',
            'article_id' => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        try {
            $article_id     =   $this->decrypt_data($request->article_id);
            $previous_ids = Articles::get_single_record('art_pre_all_ids', 'art_id = ?',binding_arr:[$article_id]);
            if (!empty($previous_ids->art_pre_all_ids)) {
                $article_id = strtok($previous_ids->art_pre_all_ids, ',');
            }
            $aflw_id        =   $this->decrypt_data($request->aflw_id);
            $Payment_order_details  =  $this->payment_order_details($article_id,$aflw_id); 
            if (count($Payment_order_details['payment_detaills']) > 0) {
                return $this->success("Success",200,$Payment_order_details);
            } else {
                $return_arr =   $this->get_amount_details($article_id,$aflw_id);
            }
            return $this->success("Success",200,$return_arr);
        } catch (\Exception $e) {
            return response()->json(['error' => $e], 500);
        }
    }

    public function get_amount_details($article_id,$aflw_id=NULL)
    {
        $art_flw_tbl    =   (new Article_flow())->getTable().' as rf';
        $jnl_flw_tbl    =   (new Generic_flows())->getTable().' as jw';   
        $curr_tbl       =   (new Currency_master())->getTable();
        $tbls = [
            "main_table" => $jnl_flw_tbl,
            "join_table" => [
                $art_flw_tbl => ["jw.jwf_id","aflw_jwf_id"],
                $curr_tbl   =>  ["jw.jwf_curr_id","curr_id"]

            ],
        ];
        $slct   =   'jwf_payment_fees,curr_symbol,curr_code,jwf_stage_type,jwf_payment_notes';
        if ($aflw_id!=NULL) {
            $cnd    =   "aflw_id = ?";
            $binding_arr    =   [$aflw_id];
        } else {
            $binding_arr    =   [$article_id];
            $cnd    = "aflw_art_id = ?";
        }
        $cnd    .=   " and jwf_enable_payment = 'y'";
        $article_flow_details   =   Generic_flows::get_results_using_joins($tbls,$slct,$cnd,'all',binding_arr:$binding_arr);
        if(count($article_flow_details) > 0) {
            $this->formated_fees($article_flow_details);
        }
        $return_arr['payment_status']   =   false;
        $return_arr['payment_detaills'] =   $article_flow_details;
        return $return_arr;
    }
    public function formated_fees($Payment_order_details=null)
    {
        $clnt_config = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
            $fetch_confArr  = Config::get($clnt_config);
            $fee_formArr     =   array();
            if(isset($fetch_confArr['fee_format']) && $fetch_confArr['fee_format'] != '') {
                $fee_formArr    =   explode("_", $fetch_confArr['fee_format']);
            }            
            //for formatting the fee in a unique style
            foreach($Payment_order_details as $key => $val) {
                $val->formatted_fee   =   '';
                $formatted_fee  =   '';
                foreach($fee_formArr as $indx => $fmt) {
                    switch ($fmt) {
                        case "SYMBOL":
                            $formatted_fee  .=   $val->curr_symbol . '';
                        break;
                        case "AMOUNT":
                            $formatted_fee  .=   number_format((float)$val->jwf_payment_fees, 2, '.', '') . '';
                        break;
                        case "SPACE":
                            $formatted_fee  .=   ' ';
                        break;
                        case "CODE":
                            $formatted_fee  .=   $val->curr_code . '';
                        break;
                        default:
                            $formatted_fee  .=   '';
                    }
                }
                $val->formatted_fee   =   $formatted_fee;
            }
            return $val->formatted_fee ;
    }
    //TASK #8180 Payment page for development env
    public function test_payment_save($array_data)
    {   
        $payment_bypass = isset($array_data['payment_bypass'])?$array_data['payment_bypass']:[];
        $payments = Payment_order::get_single_record_with_bind_cond('pmt_ord_transaction_id',['pmt_ord_art_id' => $payment_bypass['art_id'],'pmt_ord_aflw_id' => $payment_bypass['art_aflw_id']]);
        //$txn_id = "";
        if(!$payments){
           // $txn_id = "TXN" . strtoupper(uniqid());
            $insert_data    =   [
                'pmt_ord_art_id' => $payment_bypass['art_id'],
                'pmt_ord_aflw_id' => $payment_bypass['art_aflw_id'],
                //'pmt_ord_transaction_id' => $txn_id,
                'pmt_transaction_status' => 'fn',
                'pmt_ord_price' =>  number_format($payment_bypass['fees'], 2), // Convert cents to dollars and format
                'pmt_ord_currency' =>  $payment_bypass['currency'],
                'pmt_ord_payment_method' =>  "PaymentBypassed",
                'pmt_ord_card_no'   => 1234,
                'pmt_ord_order_date' => date('Y-m-d H:i:s'),
                'pmt_ord_posted_date' => date('Y-m-d H:i:s')
            ];
            $user_data  =   $this->get_current_user_details();

            Payment_order::insert_record($insert_data,$user_data);
        }
        return 'Success';
    }
    //TASK #8180 Ends
}
