<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use Illuminate\Support\Facades\Validator;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\User;
use App\Models\Email_templates;
use App\Models\Unassign_reviewer;
use App\Models\Stage_email_templates;
use App\Models\Roles;
use App\Http\Traits\SendemailTrait;
use App\Models\Article_deletion_reasons;
use App\Http\Traits\UtilityTrait;
use App\Models\User_to_journals;
use DB;
class Manage_Permissions_Api extends Controller
{
    use UtilityTrait;
    use SendemailTrait;
    public function delete_article(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'act' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $art_id = $this->decrypt_data($post_data['art_id']);
            $act = $post_data['act'];
            $core_role = $post_data['core_role'];
            $role_name = $post_data['role_name'];
            $jnl_code = $post_data['jnl_code'];

            
            $condition = 'art_id='.$art_id;

            if($act == 'delete' || $act == 'withdraw' || $act == 'hold')
            {
                $del_reasons =Article_deletion_reasons::get_all_records();
                if (!empty($del_reasons))
                {
                    foreach ($del_reasons as $del)
                    {
                        $delete_reasons[$del->adel_id] = $del->adel_reason;
                    }
                }
                $delete_reasons = (!empty($delete_reasons)) ? $delete_reasons : UtilityTrait::Utility('reason_to_delete_article')['reason_to_delete_article'];
            
                //$delete_reasons[]
                $reason = $post_data['deletereason'];
                if ($reason == 'custom')
                    $reason = $post_data['custom_reason_text'];
                else
                    $reason = (isset($delete_reasons[$reason])) ? $delete_reasons[$reason] : $reason;
                
                // If the action is delete art_delete_status = 'y'. if action is withdraw then the art_delete_status will be 'w'
                //Task-150 JPR-223	Papers on Hold
                $delete_status = $act == 'delete' ? 'y' : ($act == 'withdraw' ? 'w' : ($act == 'hold' ? 'h' : ''));
                $update_array = array(
                    'art_delete_status' => $delete_status,
                    'art_delete_reason' => $reason,
                    'art_deleted_by' => $this->current_user['user_id'],
                    'art_deleted_date' => date('Y-m-d H:i:s')
                );
                
                $article_details = Articles::get_single_record('art_id,art_artp_id', "art_id={$art_id}");


                $art_details = array(
                    'art_id' => $article_details->art_id,
                    'artp_id' => $article_details->art_artp_id,
                    'jnl_code' => $jnl_code,
                    'core_role' => $core_role,
                    'role_name' => $role_name,
                );
                DB::beginTransaction();
                
                if($act=="hold") {
                    $condition ="art_id={$art_id}";
                    Articles::update_record($update_array, $condition, $this->current_user);
                } else {
                    $this->update_article_data($art_id, $update_array,$this->current_user);
                }
                if ($act == 'delete'){
                    $this->update_last_invitaion_date($art_id,$this->current_user);
                }
                
                DB::commit();
                if ($act == 'delete'){
                    $this->send_email_article_delete_status($art_details, 'delete_article');
                    $undo_class = 'undo';
                }


            if ($act == 'withdraw')
            {   

                DB::beginTransaction();
                        $this->manange_article_auto_decline_invitation($art_id);
                        DB::commit();
                        $etmp_name = 'withdraw_article_author';
                        $this->send_email_article_delete_status($art_details, $etmp_name,$reason);
                        $undo_class = 'undo_withdraw';
            }
            elseif($act == 'hold')
            {
                $undo_class = 'undo_hold';
            }
			$return =  array(
                'status' => 'success',
                'msg' => ($act == 'hold' ? customTrans('viewarticle.article_hold_success') : ($act == 'withdraw' ? customTrans('viewarticle.article_withdraw_success') : customTrans('viewarticle.article_delete_success'))));
                $es_article = false;
                $esarray['article_id']=$art_id;
                $checkdata=$this->check_espermission_access($esarray);
                if($checkdata==true)
                {                 
                    $es_article = true;
                    $aflw_ids = Article_flow::get_single_record_with_bind_cond('GROUP_CONCAT(aflw_id) as aflw_id_list ', array('aflw_art_id' => $art_id));
                    $return['redirect_flows'] = $aflw_ids->aflw_id_list;
                    $return['redirect_msg'] = 'Proposal status has been changed.';
                }
                $return['es_article'] = $es_article;  
		}
		elseif($act == 'undo' || $act == 'undo_withdraw' || $act == 'undo_hold')
		{

            $condition = ' art_id =' . $art_id;
            $my_tak = FALSE;
            $userRoles = $this->validate_user_journal($jnl_code, $this->current_user);
            if (!in_array('journal_admin', $userRoles['assigned_roles']))
            {
                $my_tak = TRUE;
            }
            $update_array = array(
                'art_delete_status' => 'n',
                'art_delete_reason' => NULL,
                'art_deleted_by' => NULL,
                'art_deleted_date' => NULL
            );
            $data = '';
            $msg = '';
            if ($mode == 'undo')
            {
                $date_format=$this->get_platform_date_format($jnl_id);
                $date_format= $this->date_format_map($date_format);
                $select_data=$this->select_sql($date_format);

                // print_r($select_data);die;
                // // Articles::trans_start();
                $this->update_article_data($art_id, $update_array, $current_user);
                $this->update_last_invitaion_date($art_id, $current_user, 'undo');

                
                $this->send_email_article_delete_status($art_details, 'undo_delete_article');
                $msg = customTrans('sheetView.article_recovered');
            }
            if ($mode == 'undo_withdraw')
            {
                $this->update_article_data($art_id,$update_array, $current_user);
                $this->send_email_article_delete_status($art_details, 'undo_withdraw_article_author');
                $msg = customTrans('sheetView.article_recovered');
            }
            elseif($mode == 'undo_hold')
            {
                Articles::update_record($update_array, $condition, $current_user);
                //$this->update_article_data($art_id,$update_array);
                $msg = customTrans('sheetView.article_released');
            }
            $rtn_arr = array(
                'msg' => $msg
            );
            return $this->success('success', 200, $rtn_arr);

	
		}
		else
		{
			$return = array(
				'status' => 'failed',
				'msg' => customTrans('sheetView.invalid_request'));
		}
            return $this->success('success', 200, $return);
        }         catch (Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    }


    public function update_article_data($article_id, $update_array, $current_user) {
		$condition = "art_id={$article_id}";
		Articles::update_record($update_array, $condition, $current_user);
		$article_detail = Articles::get_single_record('art_pre_all_ids', $condition);
		if (isset($article_detail->art_pre_all_ids) && $article_detail->art_pre_all_ids != NULL) {
			$previous_ids = explode(',', $article_detail->art_pre_all_ids);
			if (!empty($previous_ids)) {
				foreach ($previous_ids as $pre) {
					$pre_condition = "art_id ={$pre}";
					Articles::update_record($update_array, $pre_condition, $current_user);
				}
			}
		}
		$resubmitted_articles = Articles::get_all_records('art_id', 'SUBSTRING_INDEX(art_pre_all_ids, ",", 1) =' . $article_id);
		if (!empty($resubmitted_articles)) {
			foreach ($resubmitted_articles as $re) {
				$resub_condition = 'art_id=' . $re->art_id;
				Articles::update_record($update_array, $resub_condition, $current_user);
			}
		}
	}

    public function update_last_invitaion_date($article_id, $current_user ,$type = 'delete')
	{
		$article_flow = Article_flow::get_all_records('aflw_usr_id', 'aflw_art_id =' . $article_id . ' AND aflw_usr_id IS NOT NULL');
		$user_ids = array();
		if (!empty($article_flow)){
			foreach ($article_flow as $af){
				$user_ids[] = $af->aflw_usr_id;
			}
		}
		if ($type == 'undo'){
            $article_id = NULL;
		}
		$user_latest_invitation_data = User::get_user_last_invite_list($article_id, $user_ids);
		foreach ($user_latest_invitation_data as $user_list)
		{
            if ($user_list->last_invitation_date != '')
			{
				User::update_record(array(
					'usr_last_review_invite' => $user_list->last_invitation_date), 'usr_id =' . $user_list->usr_id, $current_user);
			}
		}
	}
    public function send_email_article_delete_status($article_details, $etmp_name, $reason=""){
        $send_to_privileged_users = false;
        $current_user = $this->get_current_user_details();
        if ($etmp_name == 'withdraw_article_author' || $etmp_name == 'undo_withdraw_article_author'){
            $record = Email_templates::get_single_record('*', "etmp_name ='" . $etmp_name . "' AND etmp_notification =" . "'Author'");
            $send_to_privileged_users = true;
        } elseif($etmp_name == 'author_withdrawal') {
			$record = Email_templates::get_single_record('*', "etmp_name ='" . $etmp_name . "'");
		}
        else {
            $record = Email_templates::get_single_record("*", "etmp_name = '" . $etmp_name . "' AND etmp_notification =" . "'Journal Admin'");
        }

        if ($record != NULL)
		{
			$cfty_retire_role = FALSE;
			if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
			{
				$cfty_retire_role = TRUE;
			}
            // print_r($article_details);die;
            $send_mail_to_detail = $this->send_email_to($record->etmp_notification, $article_details['jnl_code'], $article_details['artp_id'], $article_details['art_id'], $cfty_retire_role);
            if(isset($send_mail_to_detail)){
                $send_mail_to_ids = $send_mail_to_detail['email_ids'];
                $send_mail_to_ids = explode(',', $send_mail_to_ids);
                $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
                $send_mail_to_usr_ids = explode(',', $send_mail_to_usr_ids);
                $jnl_id = Articles::get_art_jnl_column_val($article_details['art_id']);
                for ($i=0; $i < count($send_mail_to_ids); $i++) { 
                    $custom_data = array(
                        'user_email' => $send_mail_to_ids[$i],
                        'article_id' => $article_details['art_id'],
                        'withdraw_reason'   => $reason,
                        'jnl_code'=> $article_details['jnl_code'],
                        'jnl_id'=> $jnl_id,
                        'artp_id'=> $article_details['artp_id']
                    );
                    if(isset($article_details['artp_id']) && !empty($article_details['artp_id'])) {
                        $custom_data['artp_id'] = $article_details['artp_id'];
                    } //TASK #5630 Implement an option within the sheet view to recover a withdrawn article. withdraw bugfix
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => TRUE,
                        'user_id' => $send_mail_to_usr_ids[$i],//$current_user['user_id']
                        'empt_name' => $etmp_name,
                        'jnl_user_role'=>array(
                          'core_role'=>$article_details['core_role'],
                          'role_name'=>$article_details['role_name'],
                          'jnl_journal_code'=> $article_details['jnl_code']
                      ),
                        'custom_data' => $custom_data
                    );
                    $this->master_email_details($email_data);
                }
            }

            if ($send_to_privileged_users === true) {
                if ($etmp_name == 'withdraw_article_author'){
                    $record = Email_templates::get_single_record("*", "etmp_name = 'withdraw_article_privileged'");
                }
                if ($etmp_name == 'undo_withdraw_article_author'){
                    $record = Email_templates::get_single_record("*", "etmp_name = 'undo_withdraw_article_privileged'");
                }
                if ($record != NULL){
                    $send_mail_to_detail = $this->get_sendto_roles_in_article($article_details['art_id'],$record->etmp_notification,$article_details['artp_id']);
                    if(isset($send_mail_to_detail))
                    {
                        $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
                        $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
                        $send_mail_to_ids = $send_mail_to_detail['email_ids'];
                        $send_mail_to_ids = explode(',', $send_mail_to_ids);
                        $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
                        $send_mail_to_usr_ids = explode(',', $send_mail_to_usr_ids);
                        $jnl_id = Articles::get_art_jnl_column_val($article_details['art_id']);

                        for ($i=0; $i < count($send_mail_to_ids); $i++) {
                            $custom_data = array(
                                'user_email' => $send_mail_to_ids[$i],
                                'article_id' => $article_details['art_id'],
                                'etmp_notification' => $record->etmp_notification,
                                'withdraw_reason'   => $reason,
                                'jnl_id'=> $jnl_id,
                                'jnl_code'=> $article_details['jnl_code'],
                                'artp_id'=> $article_details['artp_id']
                            );
                            if(isset($article_details['artp_id']) && !empty($article_details['artp_id'])) {
                                $custom_data['artp_id'] = $article_details['artp_id'];
                            } //TASK #5630 Implement an option within the sheet view to recover a withdrawn article. withdraw bugfix
                            $email_data = array(
                                'type'      => 'global',
                                'action'    => 'send',
                                'email_with_login' => TRUE,
                                'user_id'   => $send_mail_to_usr_ids[$i],
                                'empt_name' => $record->etmp_name,
                                'jnl_user_role'     =>array(
                                'core_role'         =>$article_details['core_role'],
                                'role_name'         =>$article_details['role_name'],
                                'jnl_journal_code'  => $article_details['jnl_code']
                            ),
                                'custom_data' => $custom_data
                            );
                            $this->master_email_details($email_data);
                        }
                    }
                }
            }
        }
    }

    public function manange_article_auto_decline_invitation($article_id)
    {
        
        $current_user = $this->get_current_user_details();
        $client = $this->current_client;
        $current_stage = false;
        //Decline all active invitation and review on withdrawn
        $article_flow_child_data['aflw_status'] = 'd';
        $article_flow_child_data['aflw_remarks'] = 'onwithdrawn';
        $article_flow_child_data['aflw_returned_date'] = date('Y-m-d H:i:s');
        
        $article_flow_child_condition = 'aflw_art_id =' . $article_id . ' AND aflw_parent_flow_id IS NOT NULL AND aflw_status = "i"';
        
        $decline_flow_records = Article_flow::get_all_records('aflw_id,aflw_usr_id', $article_flow_child_condition);
        
        Article_flow::update_record($article_flow_child_data, $article_flow_child_condition, $current_user);
        
        $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept, artp_id,jnl_journal_code,jnl_id,art_article_upload_path';
        $article_details = Articles::get_article_details($select, 'art_id =' . $article_id . " AND art_delete_status ='w'", null);
        
        $article_details = $article_details[0];
        if (sizeof($decline_flow_records) > 0) {
            foreach ($decline_flow_records as $invited) {
                //Email_templates
                $email_template = Email_templates::get_single_record('*', 'etmp_name =' . 'auto_decline_invitation' . "AND etmp_notification ='User'");
                $this->send_unassign_email_workflow($email_template, $article_details, $invited->aflw_usr_id, $client, $current_user, $current_stage,'etmp_');
            }
        }
        
        // Unassign all accepted reviews on decision
        
        $unassign_flow_child_condition = 'aflw_art_id =' . $article_id . ' AND aflw_parent_flow_id <> NULL' . " AND aflw_status = 'a'";
        $unassign_flow_records = Article_flow::get_all_records('aflw_parent_flow_id,aflw_id,aflw_usr_id,aflw_jwf_id', $unassign_flow_child_condition);

        Article_flow::update_record(array('aflw_status' => 'g'), $unassign_flow_child_condition, $current_user);

        $eselect = 'stage_etmp_id, stage_etmp_to, stage_etmp_cust_to, stage_etmp_cc, stage_etmp_cust_cc, stage_etmp_bcc, stage_etmp_cust_bcc, stage_etmp_subject, stage_etmp_content AS stage_etmp_email_template, stage_etmp_journal_id,stage_etmp_action,setr_id';
        if (!empty($unassign_flow_records)) {
            foreach ($unassign_flow_records as $unas) {
                $insert_data = array(
                    'unsn_reason' => 'Auto unassign',
                    'unsn_rvr_id' => $unas->aflw_usr_id,
                    'unsn_aflw_id' => $unas->aflw_id
                );

                $article_details->aflw_id = $unas->aflw_parent_flow_id;

                Unassign_reviewer::insert_record($insert_data, $current_user);

                if (isset($stage_email_ids['unassign']) && !empty($stage_email_ids['unassign'])) {
                    $condition = 'setr_jwf_id = ' . $unas->aflw_jwf_id . ' AND setr_id in (' . join(",", $stage_email_ids['unassign']) . ' ) AND stage_etmp_action = "unassign_user"';
                    $email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger($eselect, $condition);
                    if (!empty($email_templates)) {
                        foreach ($email_templates as $email_template) {
                            $this->send_unassign_email_workflow($email_template, $article_details, $unas->aflw_usr_id, $client, $current_user, $current_stage, 'stage_etmp_');
                        }
                    }
                }
            }
        }
    }

    public function get_sendto_roles_in_article($article_id,$to_role_name,$artp_id)
	{
        $authorsTable       = (new \App\Models\Authors())->getTable();
        $usersFlag          = (new \App\Models\User())->getTable();
        $articleFlowFlag    = (new \App\Models\Article_flow())->getTable();
        $GenericFlowsFlag    = (new \App\Models\Generic_flows())->getTable();

        if($to_role_name == 'article_authors')
		{
			$tables = array(
				'main_table' => $authorsTable,
				'join_table' => array(
					$usersFlag => array($usersFlag.'.usr_id', $authorsTable . '.auth_usr_id', "left")
				));
			$select_fields ='GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS auth_email, GROUP_CONCAT(`auth_usr_id` SEPARATOR ", ") AS usr_ids';
			$criteria = 'auth_art_id =' . $article_id;
			$corresp_author = Authors::get_results_using_joins($tables,$select_fields,$criteria,'single');
			
			if(!empty($corresp_author))
			{
				$user_email = $corresp_author->auth_email;
				$user_ids = $corresp_author->usr_ids;
				return array('email_ids'=>$user_email,'usr_ids'=>$user_ids);
			}
		}
		
		$role = Roles::get_single_record("role_id,role_assigned_role","role_name='" . $to_role_name . "'");
		if(isset($role->role_id))
		{
            $role_id = $role->role_id;
			$user_article_ids = array();
			if($role->role_assigned_role == 'journal_admin')
			{
                $user_journals = User_to_journals::get_all_records('usrj_usr_id','usrj_artp_id =' . $artp_id . ' AND usrj_role_id=' . $role_id);
				if(!empty($user_journals))
				{
					$user_article_ids = array_filter(array_column(json_decode(json_encode($user_journals), true), 'usrj_usr_id'));
				}
			}

			$select = 'aflw_usr_id';
			$art_flw_tables = array(
				'main_table' => $articleFlowFlag,
				'join_table' => array(
					$GenericFlowsFlag => array($GenericFlowsFlag.'.jwf_id', $articleFlowFlag . '.aflw_jwf_id', "left")
			));
			$art_flw_criteria = 'aflw_art_id=' . $article_id . ' AND jwf_role_id =' . $role_id;
			$artcle_flow = Article_flow::get_results_using_joins($art_flw_tables, $select,$art_flw_criteria, 'all');
			$artcle_flow_usr_ids = array();
			if(!empty($artcle_flow))
			{

				$artcle_flow_usr_ids = array_filter(array_column(json_decode(json_encode($artcle_flow), true), 'aflw_usr_id'));
			}
			$user_ids = array_filter(array_unique(array_merge($artcle_flow_usr_ids,$user_article_ids)));

			
			if(!empty($user_ids))
			{
				$select = 'GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids';
				$users = User::get_single_record($select, 'usr_id IN ('.join(",",$user_ids).')');
				return array('email_ids'=>$users->usr_email,'usr_ids'=>$users->usr_ids);
			}
		}
	}
    

}
