<?php

namespace App\Http\Controllers;

use App\Models\Journals;
use App\Models\User_classification;
use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use Config;
use DB;
use Exception;
use Illuminate\Support\Facades\Validator;

class Manage_Profile_Classifications_Api extends Controller
{
    public function getJournalsAndClassifications(Request $request)
    {
        try {
            $post_data = $request->all();
            $rtn_data = array();
            // get all journals that have classifications turned on
            $journals_table = (new \App\Models\Journals())->getTable();
            $journal_settings_table = (new \App\Models\Journal_settings())->getTable();
            $classification_table = (new \App\Models\Classifications())->getTable();
            $select = 'jnl_id,jnl_journal_name';
            $criteria = "jset_classification='y' AND jnl_journal_status = 'y'";
            $tables = array(
                'main_table' =>  $journals_table,
                'join_table' => array(
                    $journal_settings_table => array($journal_settings_table . '.jset_jnl_id', $journals_table . '.jnl_id', "left"),
                    // $classification_table => array($classification_table . '.cls_jnl_id', $journals_table . '.jnl_id', "left")
                )
            );
            $journal_data = Journals::get_results_using_joins($tables, $select, $criteria);
            if (count($journal_data) > 0) {
                foreach ($journal_data as $jnl) {
                    $jnl->classification_data = $this->search_classificationdata(null, null, $jnl->jnl_id);
                    $jnl->jnl_id = Rv_encrypt($jnl->jnl_id);
                }
                $rtn_data = array(
                    "status" => "success",
                    "data" => $journal_data
                );
            } else {
                $rtn_data = array(
                    "status" => "warning",
                    "msg" => customTrans("profile.no_classfn_found")
                );
            }
            return  $this->success('Success', 200, $rtn_data);
            // print_r($journals);die;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function save_user_classification_uata(Request $request)
    {
        try {
            $rtn_data = array(
                "status" => "failed",
                "msg" => "An unknown error has occurred. Please try again."
            );
            $post_data = $request->all();
            $classificationData = $post_data;
            $insRow = array();
            $current_user = $this->get_current_user_details();
            $condition = "usrcls_usr_id ={$current_user['user_id']}";
            $savedClassificationData = User_classification::get_all_records('*', $condition);
            $success_msg = 'Classification added successfully';
            if (!empty($savedClassificationData) && count($savedClassificationData) >0) {
                //remove already saved classification
                $success_msg = 'Classification updated successfully';
                User_classification::delete_records($condition, '', $current_user);
            }
            if(count($classificationData) > 0){
                foreach ($classificationData as $row) {
                    if ($row['jnl_id'] != '') {
                        foreach ($row['data'] as $cls_id) {
                            $insRow[] = array(
                                'usrcls_usr_id'      => $current_user['user_id'],
                                'usrcls_cls_id'      => $cls_id,
                                'usrcls_posted_date' => date('Y-m-d H:i:s'),
                                'usrcls_posted_by'   => $current_user['user_id'],
                                'usrcls_proxy_id'    => $current_user['proxy_user_id'],
                            );
                        }
                    }
                }
            }
            if (!empty($insRow)) {
                User_classification::insert_batch($insRow, $current_user);
                $rtn_data = array(
                    'status' => 'success',
                    'msg' => $success_msg
                );
            }
            return  $this->success('Success', 200, $rtn_data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_user_classification(Request $request)
    {
        try {
            $rtn_data = array(
                "status" => "failed"
            );
            $current_user = $this->get_current_user_details();
            $classification_table = (new \App\Models\Classifications())->getTable();
            $user_classification_table = (new \App\Models\User_classification())->getTable();
            $journal_table = (new \App\Models\Journals())->getTable();
            $journal_settings_table = (new \App\Models\Journal_settings())->getTable();
            $criteria = "usrcls_usr_id='{$current_user['user_id']}' AND jset_classification='y' AND jnl_journal_status='y'";
            $select = 'GROUP_CONCAT(usrcls_cls_id) as cls_data, jnl_journal_name, jnl_id';
            $tables = array(
                'main_table' => $classification_table,
                'join_table' => array(
                    $user_classification_table => array($classification_table . '.cls_id', $user_classification_table . '.usrcls_cls_id', "left"),
                    $journal_table => array($classification_table . '.cls_jnl_id', $journal_table . '.jnl_id', "left"),
                    $journal_settings_table => array($journal_settings_table . '.jset_jnl_id', $journal_table . '.jnl_id', "left"),
                )
            );

            $user_classification_data = User_classification::get_results_using_joins($tables, $select, $criteria, "all", NUll, NUll, '', NULL, NULL, FALSE, "cls_jnl_id");
            if (count($user_classification_data) > 0) {
                $usr_classfn_arr = array();
                $cls_arr = array();
                $i = 0;
                foreach ($user_classification_data as $row) {
                    $cls_arr = explode(',', $row->cls_data);
                    $classification_treedata = $this->getArticleClassifications($cls_arr);
                    $usr_classfn_arr[$i]['jnl_id'] = Rv_encrypt($row->jnl_id);
                    $usr_classfn_arr[$i]['jnl_name'] = $row->jnl_journal_name;
                    $usr_classfn_arr[$i]['selected_classification_data'] = json_decode(json_encode($classification_treedata));
                    $usr_classfn_arr[$i]['selected_classification_arr'] = $cls_arr;
                    $i++;
                }
                $rtn_data = array(
                    "status" => "success",
                    "data"   => $usr_classfn_arr
                );
            }
            return  $this->success('Success', 200, $rtn_data);
        } catch (\Exception $e) {
            // print_r($e);die;
            return $this->failure('Failed', 500, $e);
        }
    }
}
