<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use App\Models\User;
use App\Models\User_emails;
use App\Models\Authors_affiliations;
use App\Models\Authors;
use App\Models\Country;
use App\Models\Login_tracking;
use App\Models\User_affiliations;
use Config;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\ModalDataTrait;
use App\Http\Traits\StandaloneDataTrait;
use App\Models\User_unregister;
use App\Models\Email_templates;
use App\Models\Primary_email;
use Illuminate\Support\Facades\Storage;
use Image;
use App\Http\Traits\InstituteSearchEngineTrait;
use stdClass;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;

class Manage_Profile_Details_Api extends Controller
{
    use StandaloneDataTrait;
    use InstituteSearchEngineTrait;
    /*Update user details based on login user id
     commited date :- 15-02-2022
     Requested type :- POST
    */
    public function updateuserdetails(Request $request)
    {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'first_name'      => 'required',
                'last_name'      => 'required',
                'email'    => 'required|email',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 200,$validator->errors());
            }
            $this->current_user = $this->get_current_user_details();
            $token = JWTAuth::getToken();

            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $user = JWTAuth::parseToken()->authenticate();
            $user_id = $user->usr_id;
            if(isset($form_data['email']))
            {
                $user_exist_email= $this->check_email($form_data['email'],$user_id);
                if(isset( $user_exist_email)&& ($user_exist_email==true))
                {
                    return  $this->warning('Failed', 200,'Email Already Exist');
                }
            }

            if (isset($form_data['first_login'])) {
                $f_status = 'y';
            }
            elseif(isset($form_data['proxy_status'])&& $form_data['proxy_status'] ==false) {
                $f_status = 'n';
            }
            $data = array(
                'usr_title' => $form_data['user_title'],
                'usr_first_name' => $form_data['first_name'],
                'usr_middle_name' => $form_data['middle_name'],
                'usr_last_name' => $form_data['last_name'],
                'usr_email' => $form_data['email'],
                'usr_phone_no' => $form_data['phone_no'],
                'usr_website' => $form_data['website_url'],
                'usr_posted_by' => $this->current_user['user_id'],
                'usr_posted_date' => date('Y-m-d H:i:s'),
                'usr_proxy_id' => 0,
            );
            if (!empty($f_status)) {
                $data['usr_f_status'] = $f_status;
            }

            $condition =array("uml_user_id"=>$this->current_user['user_id']);
            $cc_mail_data = User_emails::get_all_records_with_bind_cond('uml_email,uml_id', $condition);
            $hdn_user_id=$this->current_user['user_id'];
            $usr_url_record = User::get_single_record_with_bind_cond('usr_url, usr_email', array(
                'usr_id' => $hdn_user_id));
                if ($usr_url_record != NULL && ($usr_url_record->usr_url == NULL || $usr_url_record->usr_url == '') && $usr_url_record->usr_email != $form_data['email']) {
                    $user_email = $form_data['email'];
                    $send_to_old_mail = $usr_url_record->usr_email;

                    $record = Email_templates::get_single_record_with_bind_cond('*', array(
                        'etmp_name' => 'email_change',
                        'etmp_notification' => 'User'));
                        $email_template=Email_templates::get_single_record_with_bind_cond('*', array(
                            'etmp_name' => 'verify_user',
                            'etmp_notification' => 'User'));

                            //start
                if ($record != NULL && $email_template !=NULL) {
                    $email_data = new stdClass();
                    $primary_email_data= new stdClass();
                    /* new email template config */
                    $email_data->user_id = $hdn_user_id;
                    $email_data->user_email = $user_email;
                    $email_data->new_email = true;
                    $email_data->mail_recipient_ids = $hdn_user_id;
                    $current_date_time = date('Y-m-d H:i:s');
                    $activation_url = md5(uniqid(rand(), true) . '' . $current_date_time);
                    $user_encrypted_id=encrypt_link($hdn_user_id);
                    // $email_data->VERIFY_EMAIL =  URL::to('/').'/'. 'confirmation-user/primary-email?token=' . $activation_url . '&id=' . $user_encrypted_id;
                    $email_data->VERIFY_EMAIL = URL::to('/')  . "/confirmationuserprimaryemail?" . $this->encrypt_data("&token=" . $activation_url . "&id=" . $user_encrypted_id . "&primaryemail=true");

                    $email_data->email_templates_config = $this->email_templates_config();
                    // print_r($email_data->email_templates_config);exit;
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    $email_config = 'clients.' . $this->current_client->clnt_client_code;
                    $email_config_data = Config::get($email_config . '.email');
                    $email_data->reply_to= $email_config_data['email_settings']['reply_to_email'];
                    $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                    if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

                    if (isset($record->etmp_email_template) && strpos($record->etmp_email_template,"OPENING_PARAGRAPH") > 0)
                    $record->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$record->etmp_email_template);
                    if(!empty($this->current_user['jnl_user_role']))
                    {
                    $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
                    $email_data->core_role = $core_role;
                    $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
                    $email_data->core_role_name = $core_role_name;
                    }
                    $data_array = array(
                        'record' => $email_template,
                        'email_data' => $email_data,
                        'user_data' =>$this->current_user,
                        'column_prefix' =>'etmp_',
                    );
                    $this->notify_mail($data_array);
                    $data['usr_url'] = $activation_url;


                    /* Old Email Verification*/
                    $primary_email_data->user_id = $hdn_user_id;
                    $primary_email_data->user_email = $send_to_old_mail;
                    $primary_email_data->mail_recipient_ids = $hdn_user_id;
                    $primary_email_data->email_templates_config = $this->email_templates_config();
                    $primary_email_data->join_config = $this->join_config();
                    $primary_email_data->join_dependency_config = $this->join_dependency_config();
                    $primary_email_data->user_role_tags = $this->user_role_tags();
                    $email_config = 'clients.' . $this->current_client->clnt_client_code;
                    $email_config_data = Config::get($email_config . '.email');
                    $primary_email_data->reply_to= $email_config_data['email_settings']['reply_to_email'];



                    $primary_email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                    if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                    $primary_email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

                    $verifyactivation_url = md5(uniqid(rand(), true) . '' . $current_date_time);
                    $encrypted_userid=encrypt_link($hdn_user_id);


                    // $primary_email_data->VERIFY_EMAIL =URL::to('/').'/'.'verify-user/primary-email?token=' . $verifyactivation_url . '&id=' . $encrypted_userid;
                    $primary_email_data->VERIFY_EMAIL = URL::to('/')  . "/verifyuserprimaryemail?" . $this->encrypt_data("&token=" . $verifyactivation_url . "&id=" . $user_encrypted_id . "&primaryemail=true");
                    $primary_email_data->REVERT_EMAIL = URL::to('/')  . "/revertuserprimaryemail?" . $this->encrypt_data("&token=" . $verifyactivation_url . "&id=" . $user_encrypted_id . "&primaryemail=true");
                    // $primary_email_data->REVERT_EMAIL =URL::to('/').'/'. 'revert-user/primary-email?token=' . $verifyactivation_url . '&id=' . $encrypted_userid;

                    $updated_email_data['cpe_usr_id'] = $hdn_user_id;
                    $updated_email_data['cpe_new_email_id'] =  $user_email;
                    $updated_email_data['cpe_posted_by'] = $this->current_user['user_id'];
                    $updated_email_data['cpe_verification_uri']=$verifyactivation_url;
                    $exist_primary_email = Primary_email::get_all_records_with_bind_cond('cpe_new_email_id', array(
                        'cpe_usr_id' => $hdn_user_id));
                        if(!empty($exist_primary_email))
                        {
                            $criteria="cpe_usr_id={$hdn_user_id}";
                            Primary_email::delete_records($criteria,'',$this->current_user);
                        }

                        Primary_email::insert_record($updated_email_data);
                        if (isset($email_template->etmp_email_template) && strpos($email_template->etmp_email_template,"OPENING_PARAGRAPH") > 0)
                        $email_template->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->etmp_email_template);
                        // $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
                        // $primary_email_data->core_role = $core_role;
                        $data_response = array(
                            'record' => $email_template,
                            'email_data' => $primary_email_data,
                            'user_data' =>$this->current_user,
                            'column_prefix' =>'etmp_',
                        );
                       $this->notify_mail($data_response);
                }
                $data['usr_email'] = $send_to_old_mail;      
                }

            $cc_mail_data = User_emails::get_all_records('uml_email,uml_id', "uml_user_id={$this->current_user['user_id']}");
            // User_emails::delete_records("uml_user_id={$this->current_user['user_id']}", '', $this->current_user);

            if (isset($form_data['autodata'][0]['uml_email'])) {
                for ($i = 0; $i < count($form_data['autodata']); $i++) {
                    $input_alt_emails[] = $form_data['autodata'][$i]['uml_email'];
                    $valid_email = array();
                    if (!preg_match(
                        "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$^", "{$form_data['autodata'][$i]['uml_email']}")) {
                        $valid_email[] = "Invalid";
                    } else {
                        $valid_email[] = "Valid";
                    }
                }

                $cc_mail_data_array = array();
                foreach ($cc_mail_data as $key => $mail) {
                    $cc_mail_data_array[] = $mail->uml_email;
                    if (!in_array($mail->uml_email, $input_alt_emails) && $mail != '') {

                        User_emails::delete_records("uml_email='{$mail->uml_email}' AND uml_user_id={$this->current_user['user_id']} AND uml_id={$mail->uml_id}", '', $this->current_user);
                    }
                }
                $check_email_validation = 'FALSE';
                if (in_array("Invalid", $valid_email)) {$check_email_validation = true;} else { $check_email_validation = false;}
                $activation_links = array();
                $new_alter_email_found= array();
                $new_email_data= array();
                if ($check_email_validation == false) {
                    for ($i = 0; $i < count($form_data['autodata']); $i++) {

                        $mail = $form_data['autodata'][$i]['uml_email'];
                        if (!in_array($mail, $cc_mail_data_array) && $mail != '') {

                            $current_date_time = date('Y-m-d H:i:s');

                            $activation_url = md5($mail . '' . $current_date_time);
                            $cc_data['uml_url'] = $activation_url;
                            $cc_data['uml_user_id'] = $tokeninfo['user_id'];
                            $cc_data['uml_email'] = $form_data['autodata'][$i]['uml_email'];
                            $cc_data['uml_posted_by'] = $this->current_user['user_id'];
                            $new_alter_email_found['uml_email']=$cc_data['uml_email'];
                            $new_alter_email_found['uml_url'] = $cc_data['uml_url'];
                            array_push($new_email_data,$new_alter_email_found);
                            User_emails::insert_record($cc_data, $this->current_user);
                        }
                    }

                } else {
                    return $this->warning('Invalid email address', 200, '', 'warning');
                    exit;
                }
            }
            else{
                $input_alt_emails[] =array();
                  if(isset($cc_mail_data) && $cc_mail_data->isNotEmpty())
                  {
                    // if($form_data['autodata'][0]['uml_email'])
                    // {
                    for ($i = 0; $i < count($form_data['autodata']); $i++) {
                        $input_alt_emails[] = $form_data['autodata'][$i]['uml_email'];
                    }
                    foreach ($cc_mail_data as $key => $mail) {
                        $cc_mail_data_array[] = $mail->uml_email;
                        if (!in_array($mail->uml_email, $input_alt_emails) && $mail != '') {

                            User_emails::delete_records("uml_email='{$mail->uml_email}' AND uml_user_id={$this->current_user['user_id']} AND uml_id={$mail->uml_id}", '', $this->current_user);
                        }
                    }
               // }
                //   User_emails::delete_records("uml_user_id={$this->current_user['user_id']}", '', $this->current_user);
                  }
            }
            if(isset($new_email_data[0])&&!empty($new_email_data[0]) && $new_email_data[0] !=''){
                $ccuser_data=array("usr_id"=>$user_id ,'activation_link'=>'');
                $mail_flag="add_profile";
                    $ccmailuser_data = (object) $ccuser_data;
               $this->send_cc_email_confirmation($new_email_data,$ccmailuser_data,$mail_flag);
                }

            // $data['usr_status'] = isset($form_data['status']) ? $form_data['status'] : 'w';
            $where = 'usr_id = "' . $user_id . '"';
            $user_id = User::update_record($data, $where, $this->current_user);
            $msg = "User profile updated";
            return $this->success($msg, 201);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }
    /*get user alternative email list based on login user id
     commited date :- 15-02-2022
     Requested type :- GET
    */
    public function useremails(Request $request)
    {
        try {
            $get_data = $request->all();
            $user_id = Rv_decrypt($get_data['user_id']);
            $input_arr = array(
                'input' =>$user_id,
                'type'=> 'number'
            );
            $usr_id_validate = $this->Rv_validator($input_arr);
            if($usr_id_validate != TRUE ){
                return $this->warning('Failed',422,'Invalid');
            }

            $select = 'uml_email,uml_cc_email,uml_status';
            $criteria = array('uml_user_id'=> $user_id);
            $useremail = User_emails::get_all_records_with_bind_cond($select, $criteria);
            if (!empty($useremail))
                $response = ['success' => true, 'message' => 'user emails !!', 'result' => $useremail];
        } catch (\Exception $e) {
            $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }
        return response()->json($response, 200);
    }
    /*get loggin details
     commited date :- 15-02-2022
     Requested type :- GET
    */
    public function profile_view(Request $request)
    {

        try {

            $user = JWTAuth::parseToken()->authenticate();

            $format = $this->get_platform_date_format();
            $date_format= date_format_map($format);

            $user_id = $user->usr_id;
            $select = 'ltk_ip,DATE_FORMAT(ltk_posted_date, "' . $date_format .' %H:%i") as ltk_posted_date';
            $current_user = $this->get_current_user_details();
            $criteria = 'ltk_posted_by = "' . $user_id . '" AND ltk_action_type ="in" AND ltk_user_type ="normal" ORDER BY `ltk_id` DESC LIMIT 1,1';
            $user_log_data = Login_tracking::get_all_records($select, $criteria);
            $userdata = (count($user_log_data) > 0) ?  $user_log_data[0] : '';
            // $userdata = (count($user_log_data) > 0) ?  $user_log_data[0] : new stdClass();
            if ($this->current_client->functionality->cfty_user_unregister_account == 'y') {
                $current_user_status = User::get_single_record('usr_status', "usr_id={$user->usr_id}");
                if(!empty($userdata)){
                    if (in_array('super_admin', $current_user['roles']) || $current_user_status->usr_status == 'w' || in_array('sudo', $current_user['roles'])) {
                        $userdata->unregister = '';
                    } else {
                        $status = User_unregister::get_single_record('count(uur_id) as un_count', "uur_usr_id={$user->usr_id}");
                        if ($status->un_count == 0) {
                            $userdata->unregister = 'n';
                        } else {
                            $userdata->unregister = 'y';
                        }
                    }
                    $userdata->unregister_account = $this->current_client->functionality->cfty_user_unregister_account;
                }
                else{
                    if (isset($userdata) && in_array('super_admin', $current_user['roles']) || $current_user_status->usr_status == 'w' || isset($userdata) && in_array('sudo', $current_user['roles'])) {
                        $userdata = [ 'unregister' => '', 'unregister_account'=>$this->current_client->functionality->cfty_user_unregister_account ];
                    } else {
                        $status = User_unregister::get_single_record('count(uur_id) as un_count', "uur_usr_id={$user->usr_id}");
                        if ($status->un_count == 0) {
                            $userdata = [ 'unregister' => 'n', 'unregister_account'=>$this->current_client->functionality->cfty_user_unregister_account ];
                        } else {
                            $userdata = [ 'unregister' => 'y', 'unregister_account'=>$this->current_client->functionality->cfty_user_unregister_account ];
                        }
                    }
                }
            }
            $orcid_status = $this->current_client->modules->mdl_orcid;
            if($orcid_status == 'y'){
                $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
                $client_params  = Config::get($review_config);
                $client_url = [];
                $jnl_id = NULL;
                if ($client_params) {
                    $client_url['client_id'] = encrypt_link($client_params['orcid']['oauth_client_id']);
                    $client_url['client_secret'] = encrypt_link($client_params['orcid']['oauth_client_secret']);
                    $client_url['auth_url'] = encrypt_link($client_params['orcid']['oauth_authorization_url']);
                    $client_url['scope'] = encrypt_link($client_params['orcid']['scope']);
                    $client_url['main_url'] = encrypt_link($client_params['orcid']['main_url']);
                    $client_url['orcid_uri'] = encrypt_link('profile');
                    $client_url['view_url'] = encrypt_link($client_params['orcid']['view_url']);
                    $client_url['link_url'] = encrypt_link($client_params['orcid']['link_url']);
                    $client_url['orcid_jnl_id'] = encrypt_link($jnl_id);
                }
                if (is_array($userdata)) {
                    $userdata['logorc'] = $client_url;
                }
                if (is_object($userdata)) {
                    $userdata->logorc = $client_url;
                }
                if($userdata == ''){
                    $userdata = [];
                    $userdata['logorc'] = $client_url;
                }
            }
            $response = ['success' => true, 'message' => 'user login details!!', 'result' => $userdata];
        } catch (\Exception $e) {
            $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }
        return response()->json($response, 200);
    }

    /*
   Change username Function for Super Admin Area
   commited date :- 22-02-2022
   Requested type :- POST
    */
    public function update_username(Request $request)
    {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'username'      => 'required',
            ]);
            if ($validator->fails()) {

                return response()->json(
                    [
                        'success' => false,
                        'message' => $validator->errors(),
                        'responsecode' => 422
                    ]
                );
            }
            $token = JWTAuth::getToken();
            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $user = JWTAuth::parseToken()->authenticate();
            $user_id = $user->usr_id;
            if($user->usr_username != decrypt_link($form_data['c_name'])){
                return response()->json(['responsecode' => 422,'message'=>'Unauthorized User','success'=>false]);
                }
            $userdata = array(
                'user_id' => $tokeninfo['user_id'],
                'proxy_user_id' => 0,
            );
            $data = array(
                'usr_username' => decrypt_link($form_data['username']),
            );
            $criteria = 'usr_username="' . decrypt_link($form_data['username']) . '"';
            $check_username = User::get_single_record('count(usr_id) as cnt', $criteria);

            if ($check_username->cnt > 0) {
                return response()->json([
                    'success' => false,
                    'message' =>  customTrans('profile.usrnme_already_exist')
                ]);
            }

            $where = 'usr_id = "' . $user_id . '"';
            User::update_record($data, $where, $userdata);
            $criteria = "etmp_name = 'changed_username' AND etmp_notification = 'User'";
            $email_tmpls = Email_templates::get_single_record('*',$criteria);
            if ($email_tmpls !== null)
            {

                $custom_data=array(
                    'usr_username'=>decrypt_link($form_data['username']),);
                $email_data=array(
                    'type'=>'global',
                    'action'=>'send',
                    'email_with_login'=>FALSE,
                    'user_id'=>$user_id,
                    'empt_name'=>'changed_username',
                    'custom_data'=>$custom_data
                );

                $this->master_email_details($email_data);
            }
            return response()->json([
                'success' => true,
                'message' =>  customTrans('profile.usrnme_changed')
            ]);
        }  catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
    Change user password Function for Super Admin Area
    commited date :- 22-02-2022
    Requested type :- POST
    */
    public function update_password(Request $request)
    {
        try {
            // DB::beginTransaction();
            $form_data = $request->all();
            $newpassword = Hash::make(decrypt_link($form_data['newpassword']));
            if(isset($form_data['newpassword']) && $form_data['newpassword'] !=''){
                $form_data['dcpt_password']=decrypt_link($form_data['newpassword']);
            }
            $current_password = decrypt_link($form_data['current_password']);
            $validator = Validator::make($form_data, [
                'current_password'      => 'required',
                'newpassword'      => 'required',
                'dcpt_password'      => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/',
                'confirmpassword'      => 'required|same:newpassword',
            ]);
            if ($validator->fails()) {
                return response()->json(
                    [
                        'success' => false,
                        'message' => $validator->errors(),
                        'responsecode' => 422
                    ]
                );
            }
            $token = JWTAuth::getToken();
            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $user = JWTAuth::parseToken()->authenticate();
            $user_id = $user->usr_id;
            if($user->usr_username != decrypt_link($form_data['username'])){
                return response()->json(['responsecode' => 422,'message'=>'Unauthorized User','success'=>false]);
                }
            $userdata = array(
                'user_id' => $tokeninfo['user_id'],
                'proxy_user_id' => 0,
            );
            $data = array(
                'usr_username' => decrypt_link($form_data['username']),
                'usr_pwd' => $newpassword,
            );
            $standalone_journal_id = NULL;
            $standalone_journal = $this->get_standalone_journal_data();
            if ($standalone_journal != null) {
                $standalone_journal_id = $standalone_journal->jnl_id;
                $criteria = 'usr_jnl_standalone = ' . $standalone_journal_id;
            } else {
                $criteria = 'usr_jnl_standalone IS NULL ';
            }
            $user = User::where('usr_username', decrypt_link($form_data['username']))->get()->first();
            $user_dets = false;
            if (\Hash::check($current_password, $user->usr_pwd)) {
                $user_dets = true;
            }
            $where = 'usr_id =' . $user_id;
            if (($user_dets == false) && isset($user_id)) {
                return response()->json([
                    'success' => false,
                    'message' => customTrans('profile.pwd_not_crct')
                ]);
                exit;
            } else {
                $check_pass=$this->check_recent_passwords($user_id,$form_data['dcpt_password']);
                if($check_pass==true && !empty($check_pass))
                {
                    $return_array['msg'] = customTrans('users.resetpasswordvalid');
                    return $this->success('failure', 201, $return_array);
                }
                $update_data = User::update_record($data, $where, $userdata);
                if (!empty($update_data)) {
                    $this->update_password_history($newpassword, $user_id, $userdata);
                }
                $criteria = "etmp_name = 'changed_password' AND etmp_notification = 'User'";
                $email_tmpls = Email_templates::get_single_record('*',$criteria);
                if ($email_tmpls !== null)
                {
                    $key = Str::random(10);
                    $ecncrypt_user_data = $this->encrypt_data('&userid=' . $user_id . '&datetime=' . date("Y-m-d H:i:s") . '&key=' . $key);
                    $usr_data = array('userid' => $user_id, 'datetime' => date("Y-m-d H:i:s"), 'key' => $key);
                    $encrypt_deeplink_user_data = $this->encrypt_data(json_encode($usr_data));
                    $usr_criteria = "usr_id = {$user_id}";
                    $update_arr = array('usr_deeplink_token' => $encrypt_deeplink_user_data);
                    $current_user['user_id'] =  $current_user['proxy_user_id'] = $user_id;
                    User::update_record($update_arr, $usr_criteria, $current_user);
                    $custom_data = array(
                        'password' => $newpassword,
                        'reset_link' => URL::to('/') . '/reset-password?' . $ecncrypt_user_data,
                    );
                    $email_data=array(
                        'type'=>'global',
                        'action'=>'send',
                        'email_with_login'=>FALSE,
                        'user_id'=>$user_id,
                        'empt_name'=>'changed_password',
                        'custom_data'=>$custom_data
                    );

                    $this->master_email_details($email_data);
                }
                return response()->json([
                    'success' => true,
                    'message' => customTrans('profile.pwd_changed')
                ]);
            }
            //DB::commit();
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
   Save User Affiliation  Function for Super Admin Area
   commited date :- 22-02-2022
   Requested type :- POST
    */
    public function save_affilation(Request $request)
    {

        try {

            // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
            $client_fieldvalid  = $this->get_clientfieldrequired_functionalities();
            $affiliation_data = $request->all();
            $rules['login_user_id'] = 'required';
            $rules['usaff_type'] = 'required';

            if (isset($client_fieldvalid->department) && $client_fieldvalid->department=='y' && array_key_exists('department',$affiliation_data) ){
                $rules['department'] = 'required';
            }
            if (isset($client_fieldvalid->institution) && $client_fieldvalid->institution=='y' && array_key_exists('company',$affiliation_data) ){
                $rules['company'] = 'required|regex:/^(?!.*<[^>]*>)/';
            }
            if (isset($client_fieldvalid->country) && $client_fieldvalid->country=='y' && array_key_exists('country',$affiliation_data) ){
                $rules['country'] = 'required|regex:/^(?!.*<[^>]*>)/';
            }
            if (isset($client_fieldvalid->postal_code) && $client_fieldvalid->postal_code=='y' && array_key_exists('postal_code',$affiliation_data) ){
                $rules['postal_code'] = 'required|regex:/^(?!.*<[^>]*>)/';
            }
            if (isset($client_fieldvalid->addressline_1) && $client_fieldvalid->addressline_1=='y' && array_key_exists('addressline_1',$affiliation_data) ){
                $rules['addressline_1'] = 'required';
            }
            if (isset($client_fieldvalid->addressline_2) && $client_fieldvalid->addressline_2=='y' && array_key_exists('addressline_2',$affiliation_data) ){
                $rules['addressline_2'] = 'required';
            }

            if (isset($client_fieldvalid->aff_phonenumber) && $client_fieldvalid->aff_phonenumber=='y' && array_key_exists('phonenumber',$affiliation_data) ){
                $rules['phonenumber'] = 'required|min:6|regex:/^[\d\s()+-]+$/|regex:/^(?!.*<[^>]*>)/';
            } elseif (array_key_exists('phonenumber',$affiliation_data)){
                $rules['phonenumber'] = 'nullable|min:6|regex:/^[\d\s()+-]+$/|regex:/^(?!.*<[^>]*>)/';
            }

            if (isset($client_fieldvalid->state) && $client_fieldvalid->state=='y' && array_key_exists('state',$affiliation_data) ){
                $rules['state'] = 'required';
            }

            if ($this->current_client->functionality->cfty_hide_affiliation_email_field=='n' && isset($client_fieldvalid->affiliation_email) && $client_fieldvalid->affiliation_email=='y' && array_key_exists('affiliation_email',$affiliation_data) ){
                $rules['affiliation_email'] = 'required|email|regex:/^(?!.*<[^>]*>)/';
            } else if(array_key_exists('affiliation_email',$affiliation_data)){
                $rules['affiliation_email'] = 'nullable|email|regex:/^(?!.*<[^>]*>)/';
            }

            $validator = Validator::make($affiliation_data, $rules);
            if ($validator->fails()) {
                return response()->json(
                    [
                        'success' => false,
                        'message' => $validator->errors(),
                        'responsecode' => 422
                    ]
                );
            }
            $usr_afl_id = $this->decrypt_data($affiliation_data['affiliation_id']) ?? '';
            if($usr_afl_id  !=''){
                $input_arr = array(
                    'input' =>$usr_afl_id,
                    'type'=> 'number'
                );
                $usr_afl_id_validate = $this->Rv_validator($input_arr);
                if($usr_afl_id_validate != TRUE ){
                    return $this->warning('Failed',422,'Invalid');
                }
            }
            $this->current_user = $this->get_current_user_details();
            $affiliation_data['login_user_id']=Rv_decrypt($affiliation_data['login_user_id']);
            if($usr_afl_id  !=''){
                $input_arr = array(
                    'input' =>$affiliation_data['login_user_id'],
                    'type'=> 'number'
                );
                $affiliation_data_validate = $this->Rv_validator($input_arr);
                if($affiliation_data_validate != TRUE ){
                    return $this->warning('Failed',422,'Invalid');
                }
            }
            if (isset($this->current_client->functionality->cfty_hide_affiliation_email_field) && $this->current_client->functionality->cfty_hide_affiliation_email_field == 'n') {
                $affiliation_email=  isset($affiliation_data['affiliationemail'])?$affiliation_data['affiliationemail']:'';
            }
            else{
                $affiliation_email='';
            }
            $usr_aff_array=[];
            $data_affiliation = array(
                'usaff_user_id' => $affiliation_data['login_user_id'],
                'usaff_email' => $affiliation_email,
                'usaff_department' => isset($affiliation_data['department'])?$affiliation_data['department']:'',
                'usaff_company' => isset($affiliation_data['company'])?$affiliation_data['company']:'',
                'usaff_address_line1' => isset($affiliation_data['address_line_1'])?$affiliation_data['address_line_1']:'',
                'usaff_address_line2' => isset($affiliation_data['address_line_2'])?$affiliation_data['address_line_2']:'',
                'usaff_cnt_id' => isset($affiliation_data['country'])?$affiliation_data['country']:'',
                'usaff_postal_code' => isset($affiliation_data['postal_code'])?$affiliation_data['postal_code']:'',
                'usaff_phone' => isset($affiliation_data['phonenumber'])?$affiliation_data['phonenumber']:'',
                'usaff_posted_by' => $affiliation_data['login_user_id'],
                'usaff_type' => isset($affiliation_data['usaff_type'])?$affiliation_data['usaff_type']:'',
                'usaff_state' => isset($affiliation_data['state'])?$affiliation_data['state']:''
            );
            $data_affiliation['usaff_posted_date'] = date('Y-m-d H:i:s');
            $data_affiliation['usaff_proxy_id'] = 0;
            $data_affiliation['usaff_operation'] = 'i';
            $criteria = array(
                'usaff_prime_affiliation' => 'y',
                'usaff_user_id' => $affiliation_data['login_user_id']
            );
            $select ="usaff_id";
            $primary_affiliation_exist = User_affiliations::get_all_records_with_bind_cond($select,$criteria);
            if ((!empty($affiliation_data['prime_aff_check']) && $affiliation_data['prime_aff_check'] == 'y') || count($primary_affiliation_exist) == 0)
                $data_affiliation['usaff_prime_affiliation'] = 'y';
            if ($this->current_client->modules->mdl_ror == 'y' && !empty($affiliation_data['rorIdentifier']) && $affiliation_data['rorIdentifier'] != 'undefined') {
                $data_affiliation['usaff_ror_id'] = $affiliation_data['rorIdentifier'];
                $data_affiliation['usaff_ringgold_id'] = NULL;
                $data_affiliation['usaff_ringgold_family'] = NULL;
            } elseif ($this->current_client->modules->mdl_ringgold == 'y' && !empty($affiliation_data['ringgoldIdentifier']) && $affiliation_data['ringgoldIdentifier'] != 'undefined') {
                $data_affiliation['usaff_ror_id'] = NULL;
                $data_affiliation['usaff_ringgold_id'] = $affiliation_data['ringgoldIdentifier'];
                $post_data = array(
                    'search_key' => $affiliation_data['ringgoldIdentifier']
                );
                $response = $this->search_organisation($post_data, false, true);
                $responseArr = json_decode($response);
                $ringgoldFamily = (implode(',', array_column($responseArr->response, 'member')));
                $data_affiliation['usaff_ringgold_family'] = '[' . $ringgoldFamily . ']';
            }
            if ($usr_afl_id != '') {
                $edit_array = 'usaff_id=' . $usr_afl_id;
                User_affiliations::update_record($data_affiliation, $edit_array,$this->current_user);
                $conditn = 'usaff_user_id=' . $affiliation_data['login_user_id'];
                if(isset($data_affiliation['usaff_prime_affiliation']) && $data_affiliation['usaff_prime_affiliation']=='y')
                {
                    User_affiliations::update_record(array('usaff_prime_affiliation' => 'n'), $conditn);
                    User_affiliations::update_record(array('usaff_prime_affiliation' => 'y'), $edit_array);
                }
                $message=customTrans('profile.aff_updated');
                $this->syncAuthorAffiliation($affiliation_data, $data_affiliation);
                return $this->success($message, 201);
            } else {
                $insert_id = User_affiliations::insert_record($data_affiliation);
                $conditn = 'usaff_user_id=' . $affiliation_data['login_user_id'];
                $conditions = 'usaff_id=' .$insert_id;
                if(isset($data_affiliation['usaff_prime_affiliation']) && $data_affiliation['usaff_prime_affiliation']=='y')
                {
                    User_affiliations::update_record(array('usaff_prime_affiliation' => 'n'), $conditn);
                    User_affiliations::update_record(array('usaff_prime_affiliation' => 'y'), $conditions);
                }
                $message=customTrans('profile.new_aff_add');
                $this->syncAuthorAffiliation($affiliation_data, $data_affiliation);
                return $this->success($message, 201);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    /*
   Upload Profile picture Function for Super Admin Area
    commited date :- 22-02-2022
    Requested type :- POST
    */
    public function upload_profile_picture(Request $request)
    {
        try {
            $this->current_user=$this->get_current_user_details();
            if ($request->profileimage) {
                $image =  $request->profileimage;
                $user = JWTAuth::parseToken()->authenticate();
                $user_id = $user->usr_id;
                // Storage::disk('public')->putFileAs('avatar', $image,$name);
                $name = time().'_'.$user_id . '.' . $image->getClientOriginalExtension();
                $path='users/'.$user_id;
                $uploaded_path= $path;

                    $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
                    $uploaded_resize_path = storage_path() . $file_storage_path .'/uploads/'. $path;

                //   $name = time().'.' . explode('/', explode(':', substr($image, 0, strpos($image, ';')))[1])[1];
                // Storage::disk('public')->putFileAs('users/' . $user_id, $image, $name);
                $uploaded_file_details=$this->upload_file_handler($uploaded_path, $image, $name);
                $img = Image::make($image->getRealPath());
				$img->resize(100, 100, function ($constraint) {
					$constraint->aspectRatio();
				})->save( $uploaded_resize_path."/thumb_".$name);
                $img->resize(200, 200, function ($constraint) {
					$constraint->aspectRatio();
				})->save($uploaded_resize_path."/pic_".$name);
                $img->resize(200, 262, function ($constraint) {
					$constraint->aspectRatio();
				})->save($uploaded_resize_path."/new_".$name);
                //$user->avatar = $name;
                $data['usr_image'] = $name;

                $edit_id = 'usr_id=' . $user_id;
                if ($this->current_client->enable_upload_s3_bucket == 'y') {
					$this->update_s3_files($path);
				}
                User::update_record($data, $edit_id,$this->current_user);
                $response = ['success' => true, 'message' => 'Profile image Updated !!'];
            }
        } catch (Exception $e) {
            $response = ['success' => false, 'message' => '', 'data' => $e->getMessage()];
        }
    }
    /*
   User Affiliation List Function for Super Admin Area
   commited date :- 22-02-2022
   Requested type :- GET
    */
    public function get_user_affilation(Request $request)
    {
        $affiliation_table = (new \App\Models\User_affiliations())->getTable();
        $country_table = (new \App\Models\Country())->getTable();
        $select = $affiliation_table . ".*,";
        $select .= $country_table . ".cnt_country";
        try {
            $return_arr['hide_affiliation_email'] = $this->current_client->functionality->cfty_hide_affiliation_email_field;
            $token = JWTAuth::getToken();
            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $user = JWTAuth::parseToken()->authenticate();
            $user_id = $user->usr_id;
            $criteria = 'usaff_user_id=' . $user_id;
            //   $select='*';
            $tables = array(
                'main_table' => $affiliation_table,
                'join_table' => array(
                    $country_table => array($affiliation_table . '.usaff_cnt_id', $country_table . '.cnt_id', "left")
                )
            );
            $usereaff = User::get_results_using_joins($tables, $select, $criteria);
            if (!empty($usereaff))
                $response = ['success' => true, 'message' => 'user Affilation !!', 'result' => $usereaff];
        } catch (Exception $e) {
            $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }
        return response()->json($response, 200);
    }

    /* User Affiliation List with AffiliationId Function for Super Admin Area
  commited date :- 22-02-2022
  Requested type :- GET
   */
    public function get_user_affilation_by_id(Request $request)
    {
        $get_data = $request->all();
        $usr_afl_id = $this->decrypt_data($get_data['affilationid']);
        $affiliation_table = (new \App\Models\User_affiliations())->getTable();
        $country_table = (new \App\Models\Country())->getTable();
        $select = $affiliation_table . ".*,";
        $select .= $country_table . ".cnt_country";
        try {
            $criteria = 'usaff_id=' . $usr_afl_id;
            $select = '*';
            $tables = array(
                'main_table' => $affiliation_table,
                'join_table' => array(
                    $country_table => array($affiliation_table . '.usaff_cnt_id', $country_table . '.cnt_id', "left")
                )
            );
            $usereaff = User::get_results_using_joins($tables, $select, $criteria);
            if (!empty($usereaff))
                $response = ['success' => true, 'message' => 'user Affilation !!', 'result' => $usereaff[0]];
        } catch (Exception $e) {
            $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }
        return response()->json($response, 200);
    }
    /*Delete User Affiliation  Function for Super Admin Area
  commited date :- 22-02-2022
  Requested type :- POST
   */
    public function delete_affiliation(Request $request)
    {
        try {
            $get_data = $request->all();
            $usr_afl_id = $get_data['affil_id'];
            $us_aff_id = Rv_decrypt($get_data['affil_id']);
                $input_arr = array(
                    'input' => $us_aff_id,
                    'type'=> 'number'
                );
                $usr_afl_id_validate = $this->Rv_validator($input_arr);
                if($usr_afl_id_validate != TRUE ){
                    return $this->warning('Failed',422,'Invalid');
                }
            // $criteria = array("usaff_id"=>$us_aff_id);
            $criteria = 'usaff_id=' . $us_aff_id;
            $select ="usaff_user_id,usaff_put_code,usaff_type,usaff_prime_affiliation";
            $aff_usr = User_affiliations::get_single_record($select,$criteria);
            if ($aff_usr->usaff_prime_affiliation == 'y')
                return response()->json(
                    [
                        'success' => false,
                        'message' => customTrans('profile.del_primary_aff_failed'),
                        'responsecode' => 422
                    ]
                );
            $condition = 'usaff_user_id=' . $aff_usr->usaff_user_id;
            $aff_count =User_affiliations::get_all_records('count(usaff_id) usaff_count',$condition)[0]->usaff_count;
            $return_arr['msg'] = customTrans('profile.mandatory_affliation');
            if ($aff_count > 1) {
                if ($aff_usr->usaff_put_code != NULL && $this->current_client->modules->mdl_orcid == 'y' && $this->current_client->functionality->cfty_profile_update_to_orcid == 'y') {
                    /*
                    $end_point = ($aff_usr->usaff_type == 'e') ? 'education/' : 'employment/';
                    Config::get('clients.' . $this->current_client->clnt_client_code . '.orcid');
                    $end_point = $end_point . trim($aff_usr->usaff_put_code);
                    $this->load->library('orcid_lib', $this->config->item('orcid'));
                    $user = Userget_single_record('usr_orcid_token,usr_orcid_id', array('usr_id' => $aff_usr->usaff_user_id));
                    $token = $user->usr_orcid_token;
                    $orcid = $user->usr_orcid_id;
                    $this->orcid_lib->delete_from_orcid($end_point, $token, $orcid);
                    */

                }
                $response = User_affiliations::delete_records($criteria);
                return response()->json($response, 200);
                $response = ['success' => true, 'message' => 'user Deleted successfully'];
                return response()->json($response, 201);
            }
            $response = ['success' => false, 'message' => $return_arr['msg']];
                }
            catch (Exception $e) {
            $response = ['success' => false, 'message' => '', 'data' => $e->getMessage()];
        }
    }
    /*Delete and Change ORCID
  commited date :- 6-05-2022
  Requested type :- POST
   */
    public function  change_orcid(Request $request)
    {
        try {
            $get_data = $request->all();
            $act = $get_data['act'];
            $current_user = $this->get_current_user_details();
            $criteria = 'usr_id='. $current_user['user_id'];
            User::update_record(array('usr_orcid_id' => NULL, 'usr_orcid_token' => NULL),$criteria,$current_user);
            $orcid = 'clients.' . $this->current_client->clnt_client_code . '.orcid.orcid';
            $config_orcid = Config::get($orcid);
            $orcid_jnl_id = NULL;
            $user_details = User::get_single_record('usr_jnl_standalone', $criteria);
            if ($user_details->usr_jnl_standalone != NULL) {
                $orcid_jnl_id = $user_details->usr_jnl_standalone;
            }
            $data['url']= $config_orcid['oauth_authorization_url'] . '?client_id=' . $config_orcid['oauth_client_id'] . '&response_type=code&scope='.$config_orcid['scope'].'&redirect_uri=' . $config_orcid['main_url'] . 'orcid&state=' . $this->encrypt_data('uri=profile&jnl_id=' . $orcid_jnl_id . '&existing=TRUE&user=' . $current_user['user_id']);
            if ($act == 'remove' || $act == 'change') {
                return response()->json([
                    'success' => true,
                    'result' =>  $data,
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'result' => $e,
            ]);
        }
    }
    /*Mark as primary Affiliation
  commited date :- 08-06-2022
  Requested type :- POST
*/
public function mark_as_primary_affiliation(Request $request)	//Feature #1967
    {
        DB::beginTransaction();
        try{
            $post_data=$request->all();
            $aff_id= $this->decrypt_data($post_data['aff_id']);
            $usr_id= $this->decrypt_data($post_data['usr_id']);
            if($post_data['type'] == 'user')
			{
                $conditn = 'usaff_user_id=' . $usr_id;
                $conditions = 'usaff_id=' .$aff_id;
                User_affiliations::update_record(array('usaff_prime_affiliation' => 'n'), $conditn);
                User_affiliations::update_record(array('usaff_prime_affiliation' => 'y'), $conditions);
            }
            else
			{
                $article_id = $this->decrypt_data($post_data['art_id']);
				$conditn = 'auaff_auth_id='. $usr_id;
                $criteria= 'auaff_id='.$aff_id;
                $field = 'auaff_prime_affiliation';
                $model = 'Authors_affiliation';
                $conditions = 'auaff_id=' .$aff_id;
				$get_company = Authors_affiliations::get_single_record('auaff_company,auaff_auth_id,auaff_address_line1,auaff_address_line2,auaff_department,	auaff_cnt_id,auaff_postal_code',$criteria);
                $criteria1= 'auth_id='. $get_company->auaff_cnt_id;
                $criteria2= 'cnt_id='. $get_company->auaff_cnt_id;
				$get_user = Authors::get_single_record('auth_usr_id',$criteria1);
				$auth_country = Country::get_single_record('cnt_country',$criteria2);
                Authors_affiliations::update_record(array('usaff_prime_affiliation' => 'n'), $conditn);
                Authors_affiliations::update_record(array('usaff_prime_affiliation' => 'y'), $conditions);
            }

            DB::commit();
            // if($post_data['type'] == 'author')
            // {
            // $this->update_article_author_map($article_id,$aff_id);
            // }
            // if($post_data['type'] == 'author')
            // 	{
            //         $return_arr['user_id'] = $get_user->auth_usr_id;
            //     }
            return $this->success(customTrans('profile.updt_primary_affiliation'),200);
        }
        catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }
    public function check_recent_passwords($userid,$password)
    {
        try{
            $return_arr = array('status'=>'success');
            $User_password_history=new \App\Models\User_password_history();
            $where_condi = 'pash_usr_id ='.$userid;
            $urlsetting= 'general_config';
            $click_count= Config::get($urlsetting);
            $password_cnt=$click_count['password_count'];
            $sql_raw_query  = 'SELECT  pash_pwd from rvw_password_history where pash_usr_id=' . $userid . ' ORDER BY pash_id DESC LIMIT '.$password_cnt;
            $check_recent_psw=  $User_password_history::get_records_by_raw_query($sql_raw_query);
            // print_r($check_recent_psw);exit;
            // $check_recent_psw = $User_password_history::get_all_records('pash_pwd',$where_condi,'pash_id',$password_cnt,'','','DESC');
            $recent_ten_psw = FALSE;
            if(!empty($check_recent_psw))
            {
            foreach($check_recent_psw as $single_psw)
            {
                if(Hash::check($password, $single_psw->pash_pwd))
                {
                        $recent_ten_psw = TRUE;
                        break;
                    }
                }
            }
            if($recent_ten_psw == TRUE)
            {
                $return_arr['status'] = 'failed';
            }
            return $recent_ten_psw;
            // echo json_encode($return_arr);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    //Task #3029 After article submission, the cp team member should able to change the submitting author
public function syncAuthorAffiliation($affiliation_data, $data_affiliation)
{
     $this->current_user = $this->get_current_user_details();
    $authorRecords = Authors::get_all_records_with_bind_cond(
        'auth_id',
        ['auth_usr_id' => $affiliation_data['login_user_id']]
    );
        $Authors_affiliation = new \App\Models\Authors_affiliation();
    $proceedingArr  =   $this->fetch_client_proceeding_config_array('article-proposal');
    if ($proceedingArr['change_submitting_author'] == true && !empty($authorRecords)) {
        foreach ($authorRecords as $author) {
            $existingAuthorAff = $Authors_affiliation::get_single_record_with_bind_cond(
                'auaff_id',
                ['auaff_auth_id' => $author->auth_id]
            );
            if (empty($existingAuthorAff)) {
                // Insert only if no author affiliation exists
               $author_affiliation = [
        'auaff_auth_id'         => $author->auth_id,   // From Authors table
        'auaff_email'           => $data_affiliation['usaff_email'] ?? null,
        'auaff_department'      => $data_affiliation['usaff_department'] ?? null,
        'auaff_company'         => $data_affiliation['usaff_company'] ?? null,
        'auaff_ror_id'          => $data_affiliation['usaff_ror_id'] ?? null,
        'auaff_ringgold_id'     => $data_affiliation['usaff_ringgold_id'] ?? null,
        'auaff_ringgold_family' => $data_affiliation['usaff_ringgold_family'] ?? null,
        'auaff_state'           => $data_affiliation['usaff_state'] ?? null,
        'auaff_address_line1'   => $data_affiliation['usaff_address_line1'] ?? null,
        'auaff_address_line2'   => $data_affiliation['usaff_address_line2'] ?? null,
        'auaff_cnt_id'          => $data_affiliation['usaff_cnt_id'] ?? null,
        'auaff_postal_code'     => $data_affiliation['usaff_postal_code'] ?? null,
        'auaff_website'         => $data_affiliation['usaff_website'] ?? null,
        'auaff_phone'           => $data_affiliation['usaff_phone'] ?? null,
        'auaff_editable'        => 'y',
        'auaff_type'            => $data_affiliation['usaff_type'] ?? 'w',
        'auaff_single_affiliation' => $data_affiliation['usaff_company'] ?? null,
        'auaff_prime_affiliation'  => 'y',
        'auaff_posted_by'       => $data_affiliation['usaff_posted_by'] ?? null,
        'auaff_posted_date'     => $data_affiliation['usaff_posted_date'] ?? date('Y-m-d H:i:s'),
        'auaff_proxy_id'        => $data_affiliation['usaff_proxy_id'] ?? 0,
        'auaff_operation'       => $data_affiliation['usaff_operation'] ?? 'i',
        ];
                $Authors_affiliation::insert_record($author_affiliation,$this->current_user);
            }
        }
    }
}


}
