<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use Config;
use DB;
use App\Models\Excluded_journal_keywords;
use App\Models\Keywords;
use App\Models\Keyword_category;
use App\Models\Userkeywords;
use Illuminate\Support\Facades\Validator;
use App\Models\User; /*TASK #9272 Provide a search feature for keyword in the user profile section.*/
// use App\Http\Traits\ModalDataTrait;
use Illuminate\Support\Facades\Cache; /*Task #1295 Reduce the load time of profile keyword search */

class Manage_Profilekeyword_Api extends Controller
{
  // use ModalDataTrait;
  /*
   get min max count of keyword for Super Admin Area
    commited date :- 12-04-2022
    Requested type :- GET
    */
  public function keyword_limit(Request $request)
  {
    try {
      $data['keyword_min'] = $this->current_client->settings->cs_min_keyword;
      $data['keyword_max'] = $this->current_client->settings->cs_max_keyword;
      return response()->json([
        'success' => true,
        'result' => $data,

      ]);
    } catch (exception $e) {
      return response()->json([
        'success' => false,
        'result' => $e
      ]);
    }
  }
  /*
   Common function for Browse  keyword 
    commited date :- 22-02-2022
    Requested type :- GET
    */
  public function browse_keywords(Request $request)
  {
    try {
      $form_data = $request->all();
      $sort_order =  $form_data['sort_order'] ?? 'asc';
      $sort_field =  $form_data['sort_field'] ?? 'kwd_id';
      $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
			$client_defaults  = Config::get($client_default);
      $limit=$client_defaults['limit_keyword'];
      $search_parameters = $form_data['paramsdet'] ?? array();
      $search_keyword = '';
      if (!empty($search_parameters)) {
        if (isset($search_parameters['search_keyword']))
          $search_keyword = $search_parameters['search_keyword'] ?? '';
      }
      $art_id = isset($form_data['art_id'])?$form_data['art_id']:'';
      $jnl_id = '';
      $keyword_table = (new \App\Models\Keywords())->getTable();
      $kywdrltnshp_table = (new \App\Models\Keyword_relationship())->getTable();
      $articlekwd_table = (new \App\Models\Article_keywords())->getTable();
      $journal_table = (new \App\Models\Journals())->getTable();

      $select = 'kwd_id,REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\') as kwd_name,kwdrl_id';
      $hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;
			$bind_array = [];
      if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
		  {
			/*if($art_id !== 'undefined' && $art_id !== '')
			{
				$where = ' kwdrl_jnl_id='.$form_data['jnl_id']. " AND kwd_user_keyword = 'n' " .'AND kwd_name LIKE "%' . $search_keyword. '%"'.' AND (kwdrl_inactive = \'n\' OR ak_art_id = '.$art_id.' )';
			}	
			else
			{
        $where = "kwd_user_keyword = 'n' " .'AND kwd_name LIKE "%' . $search_keyword . '%"'.' AND kwdrl_inactive = \'n\'';		
        if(!empty($form_data['jnl_id']))
        {
				$where = "kwdrl_jnl_id=".$form_data['jnl_id'] . " AND kwd_user_keyword = 'n' " .'AND kwd_name LIKE "%' . $search_keyword . '%"'.' AND kwdrl_inactive = \'n\'';
        }
      }*/
			$select .= ',kwdrl_inactive';
			/*$group_by = 'kwd_id'; 
      $sort_field = 'kwd_name';
      $sort_order = 'ASC';*/
		}
		/*else
		{ */
			if($art_id !== 'undefined' && $art_id !== '')
			{
				//$where = ' kwdrl_jnl_id='.$form_data['jnl_id'] . " AND kwd_user_keyword = 'n' " .'AND kwd_name LIKE "%' .$search_keyword . '%"'.' AND (kwdrl_inactive = \'n\' OR ak_art_id = '.$art_id.' )';
        if($hierarchy=='j')
        {
        // $where = " kwdrl_jnl_id=".$form_data['jnl_id'] . " AND kwd_user_keyword = 'n'  AND (kwdrl_inactive = 'n' OR ak_art_id = '".$art_id."' )";
        $where = " kwdrl_jnl_id= ? AND kwd_user_keyword = 'n'  AND (kwdrl_inactive = 'n' OR ak_art_id = ? )";
        $bind_array = [$form_data['jnl_id'],$art_id];
        }
        elseif($hierarchy=='c')
        {
          $excludekeywords = (new \App\Models\Excluded_journal_keywords())->getTable();
          // $where = " kwd_user_keyword = 'n'  AND (kwdrl_inactive = 'n' OR ak_art_id = '".$art_id."' ) and kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM " .$excludekeywords . " where ejk_jnl_id='" . $form_data['jnl_id']. "')";
          $where = " kwd_user_keyword = 'n'  AND (kwdrl_inactive = 'n' OR ak_art_id = ? ) and kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM " .$excludekeywords . " where ejk_jnl_id= ?)";
          $bind_array = [$art_id , $form_data['jnl_id']];
        }
        if(!empty($search_keyword))
        {
          // $where .= ' AND kwd_name LIKE "%' .$search_keyword . '%"';
          $where .= ' AND kwd_name LIKE ?';
          $bind_array[]  =  "%{$search_keyword}%";
        }
			}	
			else
			{
        $where = "kwd_user_keyword = 'n' " .' AND kwdrl_inactive = \'n\'';

        if(!empty($search_keyword))
        {
          // $where .= ' AND kwd_name LIKE "%' .$search_keyword . '%"';
          $where .= ' AND kwd_name LIKE ?';
          $bind_array  = ["%$search_keyword%"];
        }
        if(!empty($form_data['jnl_id']) && $hierarchy=='j')
        {
				  // $where = "kwdrl_jnl_id=".$form_data['jnl_id'] . " AND kwd_user_keyword = 'n'  AND kwdrl_inactive = 'n'";
          $where = "kwdrl_jnl_id= ? AND kwd_user_keyword = 'n'  AND kwdrl_inactive = 'n'";
          $bind_array  = [$form_data['jnl_id']];
          if(!empty($search_keyword))
          {
            // $where .= ' AND kwd_name LIKE "%' .$search_keyword . '%"';
            $where .= ' AND kwd_name LIKE ?';
            $bind_array[]  =  "%$search_keyword%";
          }
        }
        elseif($hierarchy=='c')
        {
          $excludekeywords = (new \App\Models\Excluded_journal_keywords())->getTable();
          // $where = " kwd_user_keyword = 'n'  AND kwdrl_inactive = 'n' and kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM " .$excludekeywords . " where ejk_jnl_id='" . $form_data['jnl_id']. "')";
          $where = " kwd_user_keyword = 'n'  AND kwdrl_inactive = 'n' and kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM " .$excludekeywords . " where ejk_jnl_id=?)";
          $bind_array = [$form_data['jnl_id']];
          if(!empty($search_keyword))
          {
            // $where .= ' AND kwd_name LIKE "%' .$search_keyword . '%"';
            $where .= ' AND kwd_name LIKE ?';
            $bind_array[]  =  "%$search_keyword%";
          }
        }
        
      }
			$group_by = 'kwd_id'; 
      $sort_field = 'kwd_name';
      $sort_order = 'ASC';
			//$total = $this->Excluded_journal_keywords->search_journal_keywords($jnl_id, $search, $hierarchy, $issearch, NULL, NULL, TRUE, $where);
	//	}
      // DB::enableQueryLog();
      // $keyword_list =Keywords::get_keyword_browse($select,$where,$group_by,$limit,$sort_field,$sort_order,$form_data['jnl_id'],$hierarchy);
      $keyword_list =Keywords::get_keyword_browse($select,$where,$group_by,$limit,$sort_field,$sort_order,$form_data['jnl_id'],$hierarchy,binding_arr:$bind_array);
      // $result = DB::getQueryLog();
      // dd($result);
      // $keyword_list = [];
      return response()->json([
        'success' => true,
        'result' => $keyword_list,
        'keyword_limit' => $limit
      ]);
    
    } catch (\Exception $e) {
      return response()->json([
        'success' => false,
        'result' => $e
      ]);
    }
  }
  /*
   End of Common function for Browse  keyword 
    */
  /*
    get user selected profile keywords Function for Super Admin Area
    commited date :- 8-03-2022
    Requested type :- GET
    */
  public function get_userselectedkeywords(Request $request)
  {

    $userkeywords_table = (new \App\Models\Userkeywords())->getTable();
    $keywords_table = (new \App\Models\Keywords())->getTable();
    $select =  $keywords_table  . ".*,";
    try {
      $user = JWTAuth::parseToken()->authenticate();
      $user_id = $user->usr_id;
      $select = '*';
      $criteria = ' ukwd_usr_id=' . $user_id;
      $tables = array(
        'main_table' =>  $keywords_table,
        'join_table' => array(
          $userkeywords_table => array($userkeywords_table . '.ukwd_kwd_id', $keywords_table . '.kwd_id', "left")
        )
      );
      $userkeywords = Keywords::get_results_using_joins($tables, $select, $criteria);

      if (!empty($userkeywords))
        $response = ['success' => true, 'message' => 'user selectedkeywords!!', 'result' => $userkeywords];
    } catch (Exception $e) {
      $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
    }
    return response()->json($response, 200);
  }
  /*
    get user  profile keywords Function for Super Admin Area
    commited date :- 28-03-2022
    Requested type :- GET
    */
  public function get_user_keywords(Request $request)
  {
    
    try {
      $form_data = $request->all();
      $sort_field = $form_data['sort_field'] ?? 'kwd_id';
      $sort_order =  $form_data['sort_order'] ?? 'asc';
      $limit = '20';
      $keyword_table = (new \App\Models\Keywords())->getTable();
      $kywdrltnshp_table = (new \App\Models\Keyword_relationship())->getTable();
      $keycat_table = (new \App\Models\Keyword_category())->getTable();
      $journal_table = (new \App\Models\Journals())->getTable();
      $user = JWTAuth::parseToken()->authenticate();
      $user_id = $user->usr_id;
      $select = 'DISTINCT(kwd_id),kwd_category_id,kwd_name';
      $criteria = ' kwc_is_default= "n" or  kwc_is_default IS NULL';
      $tables = array(
        'main_table' => $keyword_table,
        'join_table' => array(
          $kywdrltnshp_table => array($keyword_table . '.kwd_id', $kywdrltnshp_table . '.kwdrl_kwd_id', "join"),
          $keycat_table => array($kywdrltnshp_table . '.kwdrl_category_id', $keycat_table . '.kwc_id', "left"),
          $journal_table => array($kywdrltnshp_table . '.kwdrl_jnl_id',  $journal_table . '.jnl_id', "left")
        )
      );
      $profilekeywords = Keywords::get_results_using_joins($tables, $select, $criteria, NULL, NULL, $limit);
      //$profilekeywords= Keywords::get_paginated_records($select, $criteria, $sort_field, $sort_order, $limit);
      if (!empty($profilekeywords))
        $response = ['success' => true, 'message' => 'profile keywords!!', 'result' =>  $profilekeywords];
    } catch (Exception $e) {
      $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
    }
    return response()->json($response, 200);
  }
  /*
    save user  profile keywords Function for Super Admin Area
    commited date :- 29-03-2022
    Requested type :- POST
    */
  public function save_profile_keywords(Request $request)
  {
    try {
      $form_data = $request->all();
      $user = JWTAuth::parseToken()->authenticate();
      $user_id = $user->usr_id;
      $select_keys =array();
      $from_form = $form_data['keywordlist'];
      foreach ($form_data['keywordlist'] as $keywords) {
				if(isset($keywords['id']))
				{
				$select_keys[] = $keywords['id'];
				}
				}
				$from_form = $select_keys;
      $select = 'ukwd_kwd_id,ukwd_put_code';
      $criteria = ' ukwd_usr_id=' . $user_id;
      $user_keywords = Userkeywords::get_all_records($select, $criteria);
      $from_db = array();
      $keyword_put_code = array();
      if ($user_id != '') {
        if (isset($form_data['keywordlist']) && $this->current_client->settings->cs_min_keyword > count($form_data['keywordlist'])) {

          return response()->json([
            'success' => false,
            'message' => customTrans('profile.min_no_keywords'),

          ]);
        } elseif (isset($form_data['keywordlist']) && $this->current_client->settings->cs_max_keyword < count($form_data['keywordlist'])) {
          return response()->json([
            'success' => false,
            'message' => customTrans('profile.max_no_keywords'),
          ]);
        } else {
           /*TASK #9419 Add new feature to add custom keyword in user profile section*/
           foreach ($form_data['keywordlist'] as $keywords) {
            if (isset($keywords['id'])) {
            // Existing keyword: Collect the ID
            $select_keys[] = $keywords['id'];
        } else {
            // New word: Check if it exists in the table
            $keyword_value = strtoupper($keywords['value']);
            $keyword_value = str_replace('\\', '"', $keyword_value);
            $keyword_value = htmlspecialchars($keyword_value, ENT_QUOTES);
            $check_kw_exist = Keywords::get_single_record_with_bind_cond('kwd_id', ['kwd_name' => $keyword_value]);
    
            if ($check_kw_exist) {
                // Add existing keyword value to the list and collect its ID
                  $select_keys[] = $check_kw_exist->kwd_id;
            } else {
                // Insert new keyword and collect its ID
                $new_id = Keywords::insert_record(['kwd_name' => $keyword_value, 'kwd_user_keyword' => 'y', 'kwd_posted_by' => $user_id]);
                $select_keys[] = $new_id;
            }
        }
          }
        $from_form = $select_keys;
        $select = 'ukwd_kwd_id,ukwd_put_code';
        $criteria = ' ukwd_usr_id=' . $user_id;
        $user_keywords = Userkeywords::get_all_records($select, $criteria);
        $from_db = array();
        $keyword_put_code = array();
       /* end TASK #9419 Add new feature to add custom keyword in user profile section*/

          if (!empty($user_keywords)) {
            foreach ($user_keywords as $uk) {
              $from_db[] = $uk->ukwd_kwd_id;
              if ($uk->ukwd_put_code != NULL) {
                $keyword_put_code[$uk->ukwd_kwd_id] = $uk->ukwd_put_code;
              }
            }
          }

          $to_insert = $to_delete = $data_list = array();
          $to_insert = $from_form;
          if (!empty($from_db)) {
            $to_insert = array_diff($from_form, $from_db);
            $to_delete = array_diff($from_db, $from_form);
          }
          if (!empty($to_insert)) {
           
            foreach ($to_insert as $in) {
              $data_list[] = array(
                'ukwd_kwd_id' => $in,
                'ukwd_usr_id' => $user_id,
                'ukwd_posted_date' => date('Y-m-d H:i:s'),
                'ukwd_posted_by' => $user_id
              );
            }
            $result = Userkeywords::insert_batch($data_list);
          }
          if (!empty($to_delete)) {

            foreach ($to_delete as $del) {

              $criteria = ' ukwd_usr_id =' . $user_id . ' AND ukwd_kwd_id =' . $del;
             /*TASK #9419 Add new feature to add custom keyword in user profile section*/
                 if(isset($user_id) && isset($del)){
                  $confirm_custom_keyword = Userkeywords::get_single_record_with_bind_cond('ukwd_id',['ukwd_usr_id'=>$user_id ,'ukwd_kwd_id'=> $del]);
                  if(isset($confirm_custom_keyword) && !empty($confirm_custom_keyword)){
                    $count_linked_users = Userkeywords::get_single_record_with_bind_cond('count(ukwd_kwd_id) as cnt',['ukwd_kwd_id'=> $del]);
                    if($count_linked_users->cnt == 1){
                      $confirm_posted_by = Keywords::get_single_record_with_bind_cond('kwd_id',['kwd_id'=>$del,'kwd_posted_by'=>$user_id,'kwd_user_keyword' =>'y']);
                      if ( $confirm_posted_by){
                        $delete_keywrd = Keywords::delete_records(['kwd_id'=>$del,'kwd_user_keyword' =>'y','kwd_posted_by'=>$user_id]);
                      }
                    }
                  }
                }
                /* end TASK #9419 Add new feature to add custom keyword in user profile section*/
              // $delete_records = Userkeywords::delete_records(array(
              //   'ukwd_usr_id' =>  $user_id, 'ukwd_kwd_id' => $del
              //       ), '');
              $delete_records = Userkeywords::delete_records($criteria);
            }
          }


          return response()->json([
            'success' => true,
            'message' => customTrans('profile.kwd_updated'),

          ]);
        }
      }
    } catch (\Exception $e) {
      return response()->json([
        'success' => false,
        'message' => customTrans('profile.kwd_not_updated'),
        'result' => $e
      ]);
    }
  }
  /* Task #1295 Reduce the load time of profile keyword search */
  public function get_all_user_keywords(Request $request){
    try {
      $form_data = $request->all();
      $user = JWTAuth::parseToken()->authenticate();
      $searchVal = $form_data['searchval'];
      $cacheKey = "user_keywords_{$user->usr_id}_" . md5($searchVal);
      $limit = 20;

      $profileKeywords = Cache::remember($cacheKey, 3600, function () use ($searchVal, $user, $limit) {
          $query = Keywords::query()
              // Eager load relationships to optimize query
              ->with(['keywordRelationships' => function($query) {
                  $query->where('kwdrl_inactive', 'n');
              }])
              ->where(function($q) use ($user) {
                  $q->where('kwd_user_keyword', 'n')
                    ->orWhere(function($subq) use ($user) {
                        $subq->whereIn('kwd_user_keyword', ['y', 'n'])
                             ->where('kwd_posted_by', $user->usr_id);
                    });
              })
              ->when(!empty($searchVal), function($query) use ($searchVal) {
                  return $query->where('kwd_name', 'LIKE', "%{$searchVal}%");
              });


          if (!empty($searchVal)) {
              $query->orderByRaw("
                  CASE 
                      WHEN LOWER(kwd_name) = LOWER(?) THEN 1
                      WHEN kwd_name LIKE ? THEN 2
                      WHEN LOWER(kwd_name) LIKE ? THEN 3
                      WHEN kwd_name LIKE ? THEN 4
                      ELSE 5
                  END
              ", [
                  $searchVal,                 
                  $searchVal . '%',           
                  strtolower($searchVal) . '%', 
                  '%' . $searchVal . '%'     
              ])
              ->orderBy('kwd_name');
          } else {
              $query->orderByRaw("
                  CASE 
                      WHEN kwd_name REGEXP '^[A-Za-z]' THEN 1 
                      ELSE 2 
                  END
              ")
              ->orderBy('kwd_name');
          }

          return $query->select('kwd_id', 'kwd_name')
              ->distinct()
              ->limit($limit)
              ->get();
      });

      return response()->json([
          'success' => true, 
          'message' => 'Profile keywords retrieved successfully', 
          'result' => $profileKeywords
      ], 200);

  } catch (Exception $e) {
      // Log the error
      Log::error('User Keywords Retrieval Error: ' . $e->getMessage());
      // Prepare error response
      return response()->json([
          'success' => false, 
          'message' => 'Failed to retrieve keywords', 
          'result' => $e->getMessage()
      ], 500);
  }
  }
  /*end Task #1295 Reduce the load time of profile keyword search */
}
